//
//  main.c
//  IFC97_MM
//
//  Created by Rodrigo Carvajal on 01/Jul/13.
//  Copyright (c) 2013 Rodrigo Carvajal. All rights reserved.
//

#include "mathlink.h"
#include "IFC97_GetProperty_PT.h"
#include "IFC97_GetProperty_Ph.h"
#include "IFC97_GetProperty_Ps.h"
#include "IFC97_GetProperty_hs.h"
#include "IFC97_GetProperty_Ts.h"
#include "IFC97_Saturation_Curve.h"
#include <math.h>
#include <string.h>
#include <stdio.h>

const int NumberOfErrors = 12;

char ListOfErrors[NumberOfErrors][80] = {   "Temperature Too Low.",         // 0
                                            "Temperature Too High.",        // 1
                                            "Pressure Too Low.",            // 2
                                            "Pressure Too High.",           // 3
                                            "Enthalpy Too Low.",            // 4
                                            "Enthalpy Too High.",           // 5
                                            "Entropy Too Low.",             // 6
                                            "Entropy Too High.",            // 7
                                            "Too Many Iterations.",         // 8
                                            "Unknown Error.",               // 9
                                            "Invalid Property.",            // 10
                                            "Incorrect Property Input."};   // 11

void ErrorTest(double Solution, double ErrorValue, char *ErrorText) {
    // Check for errors
    if ( Solution < ErrorValue ) {
 
        char hold[120] = "";
  
        // Error Occurred. Write Out Error
        switch ( (int)trunc(Solution) ) {
            case -10000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[11]));
                break;
                
            case -11000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[0]));
                break;
                
            case -12000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[1]));
                break;
                
            case -21000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[2]));
                break;
                
            case -22000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[3]));
                break;
                
            case -31000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[4]));
                break;
                
            case -32000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[5]));
                break;
                
            case -41000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[6]));
                break;
                
            case -42000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[7]));
                break;
                
            case -80000:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[10]));
                break;
                
            case -99990:
                MLPutString(stdlink, strcat(ErrorText, ListOfErrors[8]));
                break;
                
            case -90000:
            default:
                sprintf(hold, "%s(%d): ", ErrorText, (int)trunc(Solution));
                
                MLPutString(stdlink, strcat(hold, ListOfErrors[9]));
                
                return;
        };
    }
    else {  // No Errory Occurred.
        MLPutReal64(stdlink, Solution);
    };
    
    return;

}

/*******************************************************************************
 Determine Saturation Pressure or Temperature
*******************************************************************************/
void H2O_Sat_Press(double T) {
    
    char ErrorText[120] = "Error in h2oSatPress: ";
    
    double Result = IFC97_GetProperty_PT(0, 0.0, T, 0);
    
    ErrorTest(Result, -9900.0, ErrorText);
    
    return;
}


void H2O_Sat_Temp(double P) {
    
    char ErrorText[120] = "Error in h2oSatTemp: ";
    
    double Result = IFC97_GetProperty_PT(1, P, 0.0, 0);
    
    ErrorTest(Result, -9900.0, ErrorText);
    
    return;
}


/*******************************************************************************
   Determine Properties based on Pressure and Temperature
*******************************************************************************/
void H2O_Prop_PT(int Property, double P, double T, int Saturation) {
    
    char ErrorText[200] = "";
    
    sprintf(ErrorText, "Error in h2oPropPT: Prop=%d: ", Property);
    
    double Result = IFC97_GetProperty_PT(Property, P, T, Saturation);
    
    ErrorTest(Result, -9900.0, ErrorText);
    
    return;
    
}

/*******************************************************************************
 Determine Properties based on Pressure and Enthalpy
 *******************************************************************************/
void H2O_Prop_Ph(int Property, double P, double h) {
    
    char ErrorText[200] = "";
    
    sprintf(ErrorText, "Error in h2oPropPh: Prop=%d: ", Property);
    
    double Result = IFC97_GetProperty_Ph(Property, P, h);
    
    ErrorTest(Result, -9900.0, ErrorText);
    
    return;
    
}

/*******************************************************************************
 Determine Properties based on Pressure and Entropy
 *******************************************************************************/
void H2O_Prop_Ps(int Property, double P, double s) {
    
    char ErrorText[200] = "";
    
    sprintf(ErrorText, "Error in h2oPropPs: Prop=%d: ", Property);
    
    double Result = IFC97_GetProperty_Ps(Property, P, s);
    
    ErrorTest(Result, -9900.0, ErrorText);
    
    return;
    
}

/*******************************************************************************
 Determine Properties based on Enthalpy and Entropy
 *******************************************************************************/
void H2O_Prop_hs(int Property, double h, double s) {
    
    char ErrorText[200] = "";
    
    sprintf(ErrorText, "Error in h2oProphs: Prop=%d: ", Property);
    
    double Result = IFC97_GetProperty_hs(Property, h, s);
    
    ErrorTest(Result, -9900.0, ErrorText);
    
    return;
    
}

/*******************************************************************************
 Determine Properties based on Temperature and Entropy
 *******************************************************************************/
void H2O_Prop_Ts(int Property, double T, double s) {
    
    char ErrorText[200] = "";
    
    sprintf(ErrorText, "Error in h2oPropTs: Prop=%d: ", Property);
    
    double Result = IFC97_GetProperty_Ts(Property, T, s);
    
    ErrorTest(Result, -9900.0, ErrorText);
    
    return;
    
}


int main(int argc, char* argv[])
{
	return MLMain(argc, argv);
}



