//
//  IFC_97_h3ab_Equation.cpp
//  IFC97
//
//  Created by Rodrigo Carvajal on 03/Dec/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#include "IFC97_h3ab_Equation.h"
#include <math.h>

/*
 Equations given below are based on the information provided in the IAPWS, Revised Supplementary Release on Backward Equations for the Functions T(P,h), v(P,h) and T(P,s), v(P,s) for Region 3 of the IAPWS Industrial Formulation 1997 for the Thermodynamic Properites of Water and Steam. Kyoto, Japan, September 2004
 */

double IFC97_h3ab(double P){
    /* Provides the equation for the Boundary between Regions 3a and 3b in Region 3.
     
     Equations are based on Equation (1) of IAPWS reference discussed above.
     
     Note, no out of range checks performed in this function. These should be performed prior to calling this function.
     
     Inputs:
        P   = Pressure, MPa
     
     Return:
        h   = Specific enthalpy, kJ/kg
     
     Errors:
        None. No out of range checks performed in this function. These should be performed prior to calling this function.
     */
    
    // Reference states
    double Pstar = 1.0; // Units of MPa
    double hstar = 1.0; // Units of kJ / kg
    
    // Non-dimensional values
    double Pi = P/Pstar;
    
    // Numerical coefficients from Table 2.
    
    double n[] = {   0.0,
                     0.201464004206875e+04,
                     0.374696550136983e+01,
                    -0.219921901054187e-01,
                     0.875131686009950e-04 };
    
    return (n[1] + n[2]*Pi + n[3]*pow(Pi,2.0) + n[4]*pow(Pi,3.0))*hstar;// Equation (5)
    
};