//
//  IFC97_h2ab_Equation.cpp
//  IFC97
//
//  Created by Rodrigo Carvajal on 29/Nov/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#include "IFC97_h2ab_Equation.h"
#include <math.h>

/*
 Equations given below are based on the information provided in the IAPWS, Supplemetary Release on Backward Equations for Pressure as a Function of Enthalpy and Entropy P(h,s) to the IAWPS Industrial Formualation 1997 for the Thermodynamic Properties of Water and Steam. Gaithersburh, Maryland, USA. September 2001.
 */

double IFC97_h2ab(double s){
    /* Provides the equation for the Boundary between Regions 2a and 2b in Region 2.
     
     Equations are based on Equation (2) of IAPWS reference discussed above.
     
     Note, no out of range checks performed in this function. These should be performed prior to calling this function.
     
     Inputs:
        s   = Specific entropy, kJ/(kg K)
     
     Return:
        h   = Specific enthalpy, kJ/kg
     
     Errors:
        None. No out of range checks performed in this function. These should be performed prior to calling this function.
     */
    
    // Reference states
    double sstar = 1.0; // Units of kJ / (kg K)
    double hstar = 1.0; // Units of kJ / kg
    
    // Non-dimensional values
    double Sigma = s/sstar;
    
    // Numerical coefficients from Table 5.
    
    double n[] = {   0.0,
                    -0.349898083432139e+04,
                     0.257560716905876e+04,
                    -0.421073558227969e+03,
                     0.276349063799944e+02 };
    
    return (n[1] + n[2]*Sigma + n[3]*pow(Sigma,2.0) + n[4]*pow(Sigma,3.0))*hstar;// Equation (5)
    
};