//
//  IFC97_R4_x_Th.cpp
//  IFC97
//
//  Created by Rodrigo Carvajal on 24/Dec/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#include "IFC97_R4_x_Th.h"

#include "IFC97_B23_Equations.h"
#include "IFC97_Saturation_Curve.h"
#include "IFC97_R1_Basic.h"
#include "IFC97_R2_Basic.h"
#include "IFC97_R3_Basic.h"
#include "IFC97_R1_Backward_Tph.h"
#include "IFC97_R1_Backward_Tps.h"
#include "IFC97_B2bc_Equation.h"
#include "IFC97_R2_Backward_Tph.h"
#include "IFC97_R2_Backward_Tps.h"
#include "IFC97_R1_Backward_Phs.h"
#include "IFC97_h2ab_Equation.h"
#include "IFC97_R2_Backward_Phs.h"
#include "IFC97_h3ab_Equation.h"
#include "IFC97_R3_Backward_Tph.h"
#include "IFC97_R3_Backward_Vph.h"
#include "IFC97_R3_Backward_Tps.h"
#include "IFC97_R3_Backward_Vps.h"
#include "IFC97_P3sat_s.h"
#include "IFC97_P3sat_h.h"
#include "IFC97_R3_Backward_Phs.h"
#include "IFC97_h_liq_1_s.h"
#include "IFC97_h_liq_3a_s.h"
#include "IFC97_h_vap_2ab_s.h"
#include "IFC97_h_vap_2c3b_s.h"
#include "IFC97_hB13_s.h"
#include "IFC97_T_B23_hs.h"
#include "IFC97_Tsat_hs.h"
#include "IFC97_R3_T_Boundaries.h"
#include "IFC97_R3_Backward_Vpt.h"
#include "IFC97_Single_Iteration.h"
#include "IFC97_Double_Iteration.h"
#include "IFC97_GetRegion_PT.h"
#include "IFC97_GetProperty_PT.h"
#include "IFC97_GetRegion_Ph.h"
#include "IFC97_GetProperty_Ph.h"
#include "IFC97_GetProperty_Ph_Region4.h"
#include "IFC97_GetRegion_Ps.h"
#include "IFC97_GetProperty_Ps.h"
#include "IFC97_GetProperty_Ps_Region4.h"
#include "IFC97_GetRegion_hs.h"
#include "IFC97_Bhmax_s.h"
#include "IFC97_Bhmin_s.h"
/*
 Provides the two-phase quality based on input saturation temperature and enthalpy
 */

double IFC97_R4_x_Th(double Tsat, double h) {
    /* Provides the two-phase quality given saturation temperature and enthalpy
     
     Note, no out of range checks performed in this function. These should be performed prior to calling this function.
     
     Inputs:
         Tsat = Saturation temperature, K
         h    = Specific enthalpy, kJ/kg
     
     Return:
         Quality, dimensionless
     
     Errors:
         None
     */
    // Get saturated liquid and vapor enthalpies at the given saturation temperature
    double h_liq = IFC97_GetProperty_PT(5, 0.0, Tsat, 0);
    double h_vap = IFC97_GetProperty_PT(5, 0.0, Tsat, 1);
    
    // Determine quality and return
    return (h-h_liq)/(h_vap-h_liq);
};

