//
//  IFC97_R4_s_Tx.cpp
//  IFC97
//
//  Created by Rodrigo Carvajal on 24/Dec/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#include "IFC97_R4_s_Tx.h"
#include "IFC97_GetProperty_PT.h"


/*
 Function provides the entropy in Region 4 (two-phase) based on input Saturation temperature and quality
 */

double IFC97_R4_s_Tx(double Tsat, double Quality) {
    /* Provides the entropy in Region 4 (two-phase) based on input Quality and Saturation Temperature
     
     Note, no out of range checks performed in this function. These should be performed prior to calling this function.
     
     Inputs:
         Tsat    = Saturation temperature, K
         Quality = Quality, dimensionless
     
     Return:
         s  = Region 4 Specific entropy, kJ/kg
     
     Errors:
     None
     */
    
    return (1.0-Quality)*IFC97_GetProperty_PT(4, 0.0, Tsat, 0) + Quality*IFC97_GetProperty_PT(4, 0.0, Tsat, 1);
};
