//
//  IFC97_R3_T_Boundaries.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 15/Dec/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R3_T_Boundaries__
#define __IFC97__IFC97_R3_T_Boundaries__

/*
    Equations given below are based on the information provided in the IAPWS, Supplemetary Release on Backward Equations for Specific Volume a a Function of Pressure and temperature v(P,T) for Region 2 of the IAWPS Industrial Formaulation 1997 for the Thermodynamic Properties of Water and Steam. Santorini, Greece, July 2005.
 */

// Backward Equations outside the critical region.
double IFC97_R3_T3ab_P(double P);
double IFC97_R3_T3cd_P(double P);
double IFC97_R3_T3ef_P(double P);
double IFC97_R3_T3gh_P(double P);
double IFC97_R3_T3ij_P(double P);
double IFC97_R3_T3jk_P(double P);
double IFC97_R3_T3mn_P(double P);
double IFC97_R3_T3op_P(double P);
double IFC97_R3_T3qu_P(double P);
double IFC97_R3_T3rx_P(double P);


// Auxiliary Equations near the critical region.
double IFC97_R3_T3uv_P(double P);
double IFC97_R3_T3wx_P(double P);

#endif /* defined(__IFC97__IFC97_R3_T_Boundaries__) */
