//
//  IFC97_R3_Basic.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 24/Nov/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R3_Basic__
#define __IFC97__IFC97_R3_Basic__

/*
 Equations given below are based on the information provided in the IAPWS, Revised Release on the IAPWS Industrial
 Formulation 1997 for the Thermodynamic Properties of Water and Steam,. Lucerne, Switzerland, August 2007.
 */

double IFC97_R3_Basic(int Property, double RHO, double T);

// Non-Dimensional Hemholtz free energy. Equation (28)
double IFC97_R3_Hemholtz_ND(double Delta, double Tau, double *n, int *I, int *J);

// Derivatives for the Hemholtz free energy per Table 32.
double IFC97_R3_Get_Hr(double Delta, double Tau, double *n, int *I, int *J);
double IFC97_R3_Get_Hrr(double Delta, double Tau, double *n, int *I, int *J);
double IFC97_R3_Get_Ht(double Delta, double Tau, double *n, int *I, int *J);
double IFC97_R3_Get_Htt(double Delta, double Tau, double *n, int *I, int *J);
double IFC97_R3_Get_Hrt(double Delta, double Tau, double *n, int *I, int *J);

// Interface functions to obtain specific properties
double IFC97_R3_P_dt(double RHO, double T);
double IFC97_R3_U_dt(double RHO, double T);
double IFC97_R3_S_dt(double RHO, double T);
double IFC97_R3_H_dt(double RHO, double T);
double IFC97_R3_Cp_dt(double RHO, double T);
double IFC97_R3_Cv_dt(double RHO, double T);
double IFC97_R3_SOS_dt(double RHO, double T);
double IFC97_R3_Gibbs_dt(double RHO, double T);
double IFC97_R3_Hemholtz_dt(double RHO, double T);
double IFC97_R3_k_Ratio_dt(double RHO, double T);
double IFC97_R3_SV_dt(double RHO, double T);

#endif /* defined(__IFC97__IFC97_R3_Basic__) */
