//
//  IFC97_R3_Backward_Vpt.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 16/Dec/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R3_Backward_Vpt__
#define __IFC97__IFC97_R3_Backward_Vpt__

/*
 Equations given below are based on the information provided in the IAPWS, Supplemetary Release on Backward Equations for Specific Volume a a Function of Pressure and temperature v(P,T) for Region 2 of the IAWPS Industrial Formaulation 1997 for the Thermodynamic Properties of Water and Steam. Santorini, Greece, July 2005.
 */

// Backward Equations outside the critical region.
double IFC97_R3_V_pt_3a(double P, double T);
double IFC97_R3_V_pt_3b(double P, double T);
double IFC97_R3_V_pt_3c(double P, double T);
double IFC97_R3_V_pt_3d(double P, double T);
double IFC97_R3_V_pt_3e(double P, double T);
double IFC97_R3_V_pt_3f(double P, double T);
double IFC97_R3_V_pt_3g(double P, double T);
double IFC97_R3_V_pt_3h(double P, double T);
double IFC97_R3_V_pt_3i(double P, double T);
double IFC97_R3_V_pt_3j(double P, double T);
double IFC97_R3_V_pt_3k(double P, double T);
double IFC97_R3_V_pt_3l(double P, double T);
double IFC97_R3_V_pt_3m(double P, double T);
double IFC97_R3_V_pt_3n(double P, double T);
double IFC97_R3_V_pt_3o(double P, double T);
double IFC97_R3_V_pt_3p(double P, double T);
double IFC97_R3_V_pt_3q(double P, double T);
double IFC97_R3_V_pt_3r(double P, double T);
double IFC97_R3_V_pt_3s(double P, double T);
double IFC97_R3_V_pt_3t(double P, double T);

// Backward Equations near the critical region.
double IFC97_R3_V_pt_3u(double P, double T);
double IFC97_R3_V_pt_3v(double P, double T);
double IFC97_R3_V_pt_3w(double P, double T);
double IFC97_R3_V_pt_3x(double P, double T);
double IFC97_R3_V_pt_3y(double P, double T);
double IFC97_R3_V_pt_3z(double P, double T);

// User interface function
double IFC97_R3_V_pt(int SubRegion, double P, double T); // Calls appropriate sub-region function

#endif /* defined(__IFC97__IFC97_R3_Backward_Vpt__) */
