//
//  IFC97_R3_Backward_Tps.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 07/Dec/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R3_Backward_Tps__
#define __IFC97__IFC97_R3_Backward_Tps__

/*
 Equations given below are based on the information provided in the IAPWS, Revised Supplementary Release on Backward Equations for the Functions T(P,h), v(P,h) and T(P,s), v(P,s) for Region 3 of the IAPWS Industrial Formulation 1997 for the Thermodynamic Properites of Water and Steam. Kyoto, Japan, September 2004
 */

// Sub-region specific equations from above referenced IAPWS document
double IFC97_R3_T_ps_3a(double P, double s); // Equation (6)
double IFC97_R3_T_ps_3b(double P, double s); // Equation (7)

// User interface function
double IFC97_R3_T_ps(int iRegion, double P, double s); // Calls appropriate sub-region function


#endif /* defined(__IFC97__IFC97_R3_Backward_Tps__) */
