//
//  IFC97_R3_Backward_Tph.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 03/Dec/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R3_Backward_Tph__
#define __IFC97__IFC97_R3_Backward_Tph__

/*
 Equations given below are based on the information provided in the IAPWS, Revised Supplementary Release on Backward Equations for the Functions T(P,h), v(P,h) and T(P,s), v(P,s) for Region 3 of the IAPWS Industrial Formulation 1997 for the Thermodynamic Properites of Water and Steam. Kyoto, Japan, September 2004
 */

// Sub-region specific equations from above referenced IAPWS document
double IFC97_R3_T_ph_3a(double P, double h); // Equation (2)
double IFC97_R3_T_ph_3b(double P, double h); // Equation (3)

// User interface function
double IFC97_R3_T_ph(int iRegion, double P, double h); // Calls appropriate sub-region function


#endif /* defined(__IFC97__IFC97_R3_Backward_Tph__) */
