//
//  IFC97_R3_Backward_Phs.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 10/Dec/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R3_Backward_Phs__
#define __IFC97__IFC97_R3_Backward_Phs__

/*
 Equations given below are based on the information provided in the IAPWS, Supplemetary Release on Backward Equations P(h,s) for Region 3, Equations as a Function of h and s for the Redion Boundaries, and an Equation Tsat(h,s) for Region 4 of the IAPWS Industrial Formulation 1997 for the Thermodynamic Properties of Water and Steam. Kyoto, Japan, September 2004
 */

// Sub-region specific equations from above referenced IAPWS document
double IFC97_R3_P_hs_3a(double h, double s);  // IAPWS Eq (1)
double IFC97_R3_P_hs_3b(double h, double s);  // IAPWS Eq (2)

// User interface function
double IFC97_R3_P_hs(int iRegion, double h, double s);  // Calls appropriate sub-region function

#endif /* defined(__IFC97__IFC97_R3_Backward_Phs__) */
