//
//  IFC97_R2_Basic.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 23/Nov/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R2_Basic__
#define __IFC97__IFC97_R2_Basic__

/*
 Equations given below are based on the information provided in the IAPWS, Revised Release on the IAPWS Industrial
 Formulation 1997 for the Thermodynamic Properties of Water and Steam,. Lucerne, Switzerland, August 2007.
 */

double IFC97_R2_Basic(int Property, double P, double T);

// Non-Dimensional Gibbs free energy. Equation (15)
double IFC97_R2_Gibbs_ND(double Pi, double Tau, double *n, int *I, int *J, double *n_o, int *J_o);

// Derivatives for the Ideal Gas Portion of the Gibbs free energy per Table 13.
double IFC97_R2_Get_Go(double Pi, double Tau, double *n_o, int *J_o);
double IFC97_R2_Get_Go_p(double Pi);
double IFC97_R2_Get_Go_pp(double Pi);
double IFC97_R2_Get_Go_t(double Tau, double *n_o, int *J_o);
double IFC97_R2_Get_Go_tt(double Tau, double *n_o, int *J_o);


// Derivatives for the Residual Portion of the Gibbs free energy per Table 14.
double IFC97_R2_Get_Gr(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R2_Get_Gr_p(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R2_Get_Gr_pp(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R2_Get_Gr_t(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R2_Get_Gr_tt(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R2_Get_Gr_pt(double Pi, double Tau, double *n, int *I, int *J);


// Interface functions to obtain specific properties
double IFC97_R2_SV_pt(double P, double T);
double IFC97_R2_U_pt(double P, double T);
double IFC97_R2_S_pt(double P, double T);
double IFC97_R2_H_pt(double P, double T);
double IFC97_R2_Cp_pt(double P, double T);
double IFC97_R2_Cv_pt(double P, double T);
double IFC97_R2_SOS_pt(double P, double T);
double IFC97_R2_Gibbs_pt(double P, double T);
double IFC97_R2_Hemholtz_pt(double P, double T);
double IFC97_R2_k_Ratio_pt(double P, double T);
double IFC97_R2_RHO_pt(double P, double T);


#endif /* defined(__IFC97__IFC97_R2_Basic__) */
