//
//  IFC97_R2_Backward_Tps.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 26/Nov/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R2_Backward_Tps__
#define __IFC97__IFC97_R2_Backward_Tps__

/*
 Equations given below are based on the information provided in the IAPWS, Revised Release on the IAPWS Industrial
 Formulation 1997 for the Thermodynamic Properties of Water and Steam,. Lucerne, Switzerland, August 2007.
 */

// Sub-region specific equations from above referenced IAPWS document
double IFC97_R2_T_ps_2a(double P, double s); // Equation (25)
double IFC97_R2_T_ps_2b(double P, double s); // Equation (26)
double IFC97_R2_T_ps_2c(double P, double s); // Equation (27)

// User interface function
double IFC97_R2_T_ps(int iRegion, double P, double s); // Calls appropriate sub-region function

#endif /* defined(__IFC97__IFC97_R2_Backward_Tps__) */
