//
//  IFC97_R2_Backward_Tph.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 26/Nov/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R2_Backward_Tph__
#define __IFC97__IFC97_R2_Backward_Tph__

/*
 Equations given below are based on the information provided in the IAPWS, Revised Release on the IAPWS Industrial
 Formulation 1997 for the Thermodynamic Properties of Water and Steam,. Lucerne, Switzerland, August 2007.
 */

// Sub-region specific equations from above referenced IAPWS document
double IFC97_R2_T_ph_2a(double P, double h); // Equation (22)
double IFC97_R2_T_ph_2b(double P, double h); // Equation (23)
double IFC97_R2_T_ph_2c(double P, double h); // Equation (24)

// User interface function
double IFC97_R2_T_ph(int iRegion, double P, double h); // Calls appropriate sub-region function

#endif /* defined(__IFC97__IFC97_R2_Backward_Tph__) */
