//
//  IFC97_R2_Backward_Phs.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 29/Nov/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R2_Backward_Phs__
#define __IFC97__IFC97_R2_Backward_Phs__

/*
 Equations given below are based on the information provided in the IAPWS, Supplemetary Release on Backward Equations for Pressure as a Function of Enthalpy and Entropy P(h,s) to the IAWPS Industrial Formualation 1997 for the Thermodynamic Properties of Water and Steam. Gaithersburh, Maryland, USA. September 2001.
 */

// Sub-region specific equations from above referenced IAPWS document
double IFC97_R2_P_hs_2a(double h, double s); // Equation (3)
double IFC97_R2_P_hs_2b(double h, double s); // Equation (4)
double IFC97_R2_P_hs_2c(double h, double s); // Equation (5)

// User interface function
double IFC97_R2_P_hs(int iRegion, double h, double s); // Calls appropriate sub-region function

#endif /* defined(__IFC97__IFC97_R2_Backward_Phs__) */
