//
//  IFC97_R1_Basic.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 23/Nov/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_R1_Basic__
#define __IFC97__IFC97_R1_Basic__

/*
 Equations given below are based on the information provided in the IAPWS, Revised Release on the IAPWS Industrial
 Formulation 1997 for the Thermodynamic Properties of Water and Steam,. Lucerne, Switzerland, August 2007.
 */

double IFC97_R1_Basic(int Property, double P, double T);

// Non-Dimensional Gibbs free energy. Equation (7)
double IFC97_R1_Gibbs_ND(double Pi, double Tau, double *n, int *I, int *J);

// Derivatives for the Gibbs free energy per Note a at the bottom of Table 3.
double IFC97_R1_Get_Gp(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R1_Get_Gpp(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R1_Get_Gt(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R1_Get_Gtt(double Pi, double Tau, double *n, int *I, int *J);
double IFC97_R1_Get_Gpt(double Pi, double Tau, double *n, int *I, int *J);

// Interface functions to obtain specific properties
double IFC97_R1_SV_pt(double P, double T);
double IFC97_R1_U_pt(double P, double T);
double IFC97_R1_S_pt(double P, double T);
double IFC97_R1_H_pt(double P, double T);
double IFC97_R1_Cp_pt(double P, double T);
double IFC97_R1_Cv_pt(double P, double T);
double IFC97_R1_SOS_pt(double P, double T);
double IFC97_R1_Gibbs_pt(double P, double T);
double IFC97_R1_Hemholtz_pt(double P, double T);
double IFC97_R1_k_Ratio_pt(double P, double T);
double IFC97_R1_RHO_pt(double P, double T);



#endif /* defined(__IFC97__IFC97_R1_Basic__) */
