//
//  IFC97_B2bc_Equation.h
//  IFC97
//
//  Created by Rodrigo Carvajal on 26/Nov/12.
//  Copyright (c) 2012 Rodrigo Carvajal. All rights reserved.
//

#ifndef __IFC97__IFC97_B2bc_Equation__
#define __IFC97__IFC97_B2bc_Equation__
/*
 Equations given below are based on the information provided in the IAPWS, Revised Release on the IAPWS Industrial
 Formulation 1997 for the Thermodynamic Properties of Water and Steam,. Lucerne, Switzerland, August 2007.
 */

// Overall base equation providing the coefficients for both P(h) and h(P). Table 19 coefficients and Equation (20) and (21).
double IFC97_B2bc(int iType, double P, double h);

// User interface functions
double IFC97_B2bc_P_h(double h);  // User interface function to obtain the B2bc Pressure boundary given h. Calls IFC97_B2bc
double IFC97_B2bc_h_p(double P);  // User interface function to obtain the B2bc enthalpy boundary given P. Calls IFC97_B2bc

#endif /* defined(__IFC97__IFC97_B2bc_Equation__) */
