(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialization Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

































BeginPackage["rayshade`"]

Rayshade::usage="Rayshade[filename, graphics, ops] writes graphics in \
Rayshade format to file.  see rayshade.note.nb"

RayView::usage="Render and View with xli."

RayPreView::usage="PreView Render and view with xli."





Options[Rayshade]={
    RayHeader\[Rule]"",
    RayInformation\[Rule]Automatic,
    RayView\[Rule]False,
    RayPreView\[Rule]False,
    RayShow\[Rule]False,
    RaySurfaces\[Rule]{},
    RayAspect\[Rule]False,
    RayLineWidth\[Rule].001, (* magic *)
    RayFovAngle\[Rule]40,
    RayFastLight\[Rule]False,
    RayGrey\[Rule]False,
    RayGreyShade\[Rule]False,
    RayGlass\[Rule]False,
    RayPOV\[Rule]False, (* not finished *)
    RayTubeLines\[Rule]False,
    RayBoxLines\[Rule]False,
    RayCsg\[Rule]False,
    RayOverlay\[Rule]True,
    RayClipPlotRange\[Rule]False,
    RayScaled\[Rule]False,
    RayTesselate\[Rule]False,
    RayFooter\[Rule]Automatic
    }





Begin["`Private`"]

Rayshade[filename_String,obj_,opts___]:=
  Module[{file,rayview,raypreview,rayshow,raypov,g},
    raypov=RayPOV/.Flatten[{opts}]/.Options[Rayshade];
    rayshow=RayShow/.Flatten[{opts}]/.Options[Rayshade];
    rayview=RayView/.Flatten[{opts}]/.Options[Rayshade];
    raypreview=RayPreView/.Flatten[{opts}]/.Options[Rayshade];
    file=OpenWrite[filename,FormatType\[Rule]OutputForm,
        PageWidth\[Rule]Infinity];
    If[file===$Failed,Return[file]];
    Rayshade[file,Unevaluated[obj],Unevaluated[opts]];
    Close[file];
    If[raypov===False,
      If[rayview||raypreview,
          cmd="rayshade "<>filename<>" -O "<>filename<>".rle -q";
          If[raypreview,cmd=cmd<>" -R 240 240 -p"];
          cmd=cmd<>" 2>>/dev/null";
          Run[cmd];
          If[Not[rayshow],
            cmd="xli "<>filename<>".rle 2>>/dev/null &";
            Run[cmd];
            ,
            
            cmd="rletopnm "<>filename<>".rle 1> "<>filename<>
                ".pnm 2>>/dev/null";
            Run[cmd];
            
            cmd="pnmtojpeg --quality 100 "<>filename<>".pnm 1> "<>filename<>
                ".jpeg 2>>/dev/null";
            Run[cmd];
            g=Import[filename<>".jpeg","JPEG"];
            NotebookPut[Show[g],EvaluationNotebook[]];
            Return[g];
            ];
          ];
      ,
      If[rayview||raypreview,
          cmd="povray "<>filename<>" -O"<>filename<>".png";
          If[raypreview===False,cmd=cmd<>" -W512 -H512 "];
          cmd=cmd<>" 2>>/dev/null";
          Run[cmd];
          If[rayshow===True,
            
            cmd="pngtopnm "<>filename<>".png 1> "<>filename<>
                ".pnm 2>>/dev/null";
            Run[cmd];
            
            cmd="pnmtojpeg --quality 100 "<>filename<>".pnm 1> "<>filename<>
                ".jpeg 2>>/dev/null";
            Run[cmd];
            g=Import[filename<>".jpeg","JPEG"];
            NotebookPut[Show[g],EvaluationNotebook[]];
            Return[g];
            ];
          ];
      ];
    ]



(* race cond for small issue need symbol defined for \[Equal] to work;
  BeginPackage["SurfaceGraphics3D`"];
  SurfaceGraphics3D;
  EndPackage[];
  *)

version=2;

initVars[];





Rayshade[file2_OutputStream,obj_,opts___]:=
  Module[{optsf,opts2,fullopts,optlistsmall,rayinfo,rayview,raypreview,
      rayheader,rayfooter,raylinewidth,rayfovangle,raygreyshade,rayscaled,
      aspect,fastlight,grey,glass,pov,tesselate,boxlines,tubelines,csg,
      clipplotrange,overlay,x,inc,len,grlen,prclip,pr1,pr2,pr3,g,
      onnormalplane,ilinewidth,mvp,error,v,obj2},
    
    error=0;
    initVars[];
    rayshade`Private`file=file2;
    ilinewidth=linewidth;
    obj2=Null;
    
    (* PROCESS OPTS *)
    
    Print["opts"];
    
    dropopt[y_]:=Module[{pos},If[Length[opts2]>0,
          opts2=DeleteCases[opts2,y\[Rule]_]
          ]];
    dropopt[y_]:=Module[{pos},
        If[Length[opts2]>0&&Position[opts2,y\[Rule]_]\[NotEqual]{},
            pos=Position[opts2,y\[Rule]_][[1]][[1]];
            opts2=Drop[opts2,{pos,pos}];
            ];];
    getopt[x_,y_]:=(x=y/.optsf/.Options[Rayshade];dropopt[y];);
    
    (* opts are mixed, get+drop so only Graphics opts remain *)
    
    optsf=Flatten[{opts}];
    opts2=optsf;
    
    (*things get ugly if we proceed with bogus opts2 *)
    
    For[inc=1,inc<1000&&inc\[LessEqual]Length[opts2],++inc,
      If[Head[opts2[[inc]]]=!=Rule,
        Print["opt is not a rule: ",opts2[[inc]]];
        error=1;
        Return[];
        ]
      ];
    
    getopt[rayinfo,RayInformation];
    getopt[rayview,RayView];
    getopt[raypreview,RayPreView];
    getopt[rayheader,RayHeader];
    getopt[rayfooter,RayFooter];
    getopt[raysurfaces,RaySurfaces];
    getopt[raylinewidth,RayLineWidth];
    getopt[rayfovangle,RayFovAngle];
    getopt[fastlight,RayFastLight];
    getopt[raygreyshade,RayGreyShade];
    getopt[rayscaled,RayScaled];
    getopt[glass,RayGlass];
    getopt[grey,RayGrey];
    getopt[pov,RayPOV];
    getopt[tesselate,RayTesselate];
    getopt[boxlines,RayBoxLines];
    getopt[tubelines,RayTubeLines];
    getopt[csg,RayCsg];
    getopt[overlay,RayOverlay];
    getopt[clipplotrange,RayClipPlotRange];
    getopt[aspect,RayAspect];
    
    rayglass=glass;
    rayfastlight=fastlight;
    raygrey=grey;
    raypov=pov;
    raytesselate=tesselate;
    rayboxlines=boxlines;
    raytubelines=tubelines;
    raycsg=csg;
    rayoverlay=overlay;
    rayclipplotrange=clipplotrange;
    rayaspect=aspect;
    
    If[Head@rayoverlay===List,{rayoverlay,ola}=rayoverlay];
    
    (* more options stuff *)
    
    (* incase Show cant gather more opts *)
    
    optlistsmall=Flatten[{opts2,Options[Graphics3D]}];
    fullopts=optlistsmall;
    optlist=optlistsmall;
    
    (* get full opts if single graphic *)
    x=True;
    inc=Head[Unevaluated[obj]];
    If[rayinfo===
          Automatic&&(inc==Graphics3D||inc==Graphics||inc==SurfaceGraphics||
 
                       inc==SurfaceGraphics3D`SurfaceGraphics3D),
      (* see (1) *)
      If[inc===SurfaceGraphics3D`SurfaceGraphics3D,
        fullopts=AbsoluteOptions[obj];
        ,fullopts=AbsoluteOptions[Unevaluated[obj]];
        ];
      optlist=Flatten[{opts2,fullopts,Options[Graphics3D]}];
      x=False;
      ];
    
    (* use show to gather fullopts for total scene *)
    
    If[rayinfo===Automatic&&x&&inc===List,
      (* Show will return 2D opts if they are anywhere;
        if 3D anywhere exclude 2D; tries as simple list only; *)
      
      len=.;x=.;
      inc=Map[(Head[#])&,Unevaluated[obj]];
      If[Position[inc,Graphics]=!={},
        v=Position[inc,Graphics3D|SurfaceGraphics|SurfaceGraphics3D];
        If[v=!={},len=1;x=Part[Unevaluated[obj],Flatten@v]];
        ];
      If[len=!=1,x=Unevaluated[obj]];
      (* superflous List ie {justone} changes PlotRange *)
      
      If[Length[x]\[Equal]1,x=x[[1]]];
      
      g=.;
      If[x=!={},
        g=Show[x,DisplayFunction\[Rule]Identity];
        fullopts=AbsoluteOptions[g];
        optlist=Flatten[{opts2,fullopts,Options[Graphics3D]}];
        ,
        x=Select[Flatten[{Unevaluated[obj]}],(Head[#]==Graphics)&];
        If[x=!={},
          g=Show[obj,DisplayFunction\[Rule]Identity];
          fullopts=AbsoluteOptions[g];
          optlist=Flatten[{opts2,fullopts,Options[Graphics3D]}];
          ];
        ];
      If[Head[g]===Show,Print["tried to show non graphics err"];
        Return[Unevaluated[obj]];];
      g=.;x=.;inc=.;len=.;
      ];
    
    rayshade`Private`pointInPlotRange[v_]:=If[
        v[[1]] >=pr[[1,1]]&&v[[1]]<=pr[[1,2]]
          &&v[[2]] >=pr[[2,1]]&&v[[2]]<=pr[[2,2]]
          &&v[[3]] >=pr[[3,1]]&&v[[3]]<=pr[[3,2]]
        ,v
        ];
    
    (* oops mm ver; look "both" places incase not defined; *)
    
    x=Global`PlotRangeClipping/.optlist;
    If[x===False,rayshade`Private`pointInPlotRange[vv_]:=vv];
    x=System`PlotRangeClipping/.optlist;
    If[x===False,rayshade`Private`pointInPlotRange[vv_]:=vv];
    
    (* SCENE SETUP CALCULATIONS *)
    
    Print["scene"];
    
    fov=45;
    
    (* see basic scene setup notes *)
    x=PlotRange/.optlist;
    If[x=!=Automatic,pr=x];
    (* vc handled after scene boxcenter *)
    vc=ViewCenter/.opts2;
    If[vc==ViewCenter,vc={0,0,0}];
    vv=ViewVertical/.optlist;
    lights=LightSources/.optlist;
    x=ViewPoint/.optlist;
    If[x=!=ViewPoint,vp=x];
    x=ViewAngle/.optlist;
    If[NumberQ[x],fov=x];
    x=ViewVector/.optlist;
    If[ListQ[x],{vp,lookp}=x];
    
    up=vv;
    
    (* provide more colorful default; any change overrides *)
    
    If[lights===Automatic||
        N[Chop[lights]]===
          N[Chop[{{{1.`,0.`,1.`},RGBColor[1.`,0.`,0.`]},{{1.`,1.`,1.`},
                  RGBColor[0.`,1.`,0.`]},{{0.`,1.`,1.`},
                  RGBColor[0.`,0.`,1.`]}}]]
      ,
      lights={{{1,-1,-1},RGBColor[1,0,0]},{{1,1,1},
              RGBColor[0,1,0]},{{-1,-1,1},RGBColor[0,0,1]}};
      ];
    
    (* 2D test; some funs like Line can do 2D or 3D so try;
      unlike Graphics3D we have no use for Prolog;
      so it's a start at being like Show[];
      *)
    If[Length[pr]\[Equal]2,
      twospace=True;
      (* vp will be up in front after calcs *)
      (* 
        the 3D default dir is valid its preferencial *)
      
      x=ViewPoint/.optsf;
      If[x==ViewPoint,vp={0,-1,0}];
      pr=Insert[pr,{-.01,.01},2];
      (* If[NumberQ[rayoverlay]===True, see further below *)
      ];
    
    (* un-noticeable but skirts div/0 checking; mostly for 2D; *)
    
    If[vp[[1]]\[Equal]0,vp[[1]]=.0001];
    If[vp[[2]]\[Equal]0,vp[[2]]=.0001];
    If[vp[[3]]\[Equal]0,vp[[3]]=.0001];
    
    (* SIDE TRACK FOR ASPECT;
      
      we sqash graphics to fit in a square by simply using;
      "scale x y z" upon each gr. code wise the viewpoint changes;
      and in a few places the squash effect must be considered;
      good news is aspect is acheived without altering or; 
      size interpreting the shapes of data;
      
      for aspect we calculate the below twice.  w/new pr to find;
      vp of squashed box then again w/orig pr so all else;
      is un-affected (the scene before "scale" is reached);
      *)
    
    If[rayaspect===True,
      {pr1,pr2,pr3}=nbaspect[]~N~maxprecision;
      (* Print[" will scale ",{pr1,pr2,pr3}," "]; *)
       (* 
        we need vp closer but not the rest; see below; *)
      x=pr;
      prasp={pr1,pr2,pr3};
      pr=pr prasp;
      ];
    
    box=prbox[pr];
    boxcenter=(box[[7]]+box[[1]])/2;
    
    v=Map[NumberQ,Flatten[{pr,vc,vv,vp,lookp,up,fov}]];
    If[Cases[v,False]=!={},
      Print["init err: some init vars became non-numbers."];
      Return[];
      ];
    
    scenedepth=Table[magnitude[boxcenter,box[[i]]],{i,1,8}]//Sort//Last;
    (* dependancy; do before += boxcenter else its vp-boxcenter *)
    
    mvp=magnitude[vp];
    unit=vp/mvp;
    (* see notes ; a vec in normal plane; div/0 issue too *)
    
    onnormalplane=-1{0,vp[[2]]/vp[[1]],vp[[3]]/vp[[1]]};
    vpnormal=Cross[onnormalplane,vp]; (* unused *)
    
    vpnormal=vpnormal/magnitude[vpnormal]; (* unused *)
    
    (* want fov\[Equal]45; scale view pt (in / out) so it is;
      done by searching; begin with n\[Equal]1.5 scenedepth;
      need angle between final vp and all box corners;
      *)
    (* 2.5 is magic - should put us closer to 45 to start;
      ok if rough guess but avoid 1000 iteration quit *)
    origvp=vp;
    vp=unit viewPointMulSearch[{2.5 scenedepth,0,rayfovangle}];
    
    If[rayaspect===True, (* unused *)
      viewdepth=magnitude[vp];
      linewidth=1.2 ilinewidth viewdepth (viewdepth)^(1/4);
      ];
    
    (* make the scene's origin boxcenter *)
    vp +=boxcenter;
    lookp=boxcenter;
    
    (* ignored; usu. {0.5,0.5,0.5} for any PlotRange; *)
    
    vc=ViewCenter/.opts2;
    (* FIXME: lookp and vc are not used in calcs;
      unsure if use of overriden vc will help or hurt cals; *)
    
    If[vc==ViewCenter,vc=boxcenter,lookp=vc];
    
    (* for aspect; recalc with orig pr using found/new vp *)
    
    If[rayaspect===True,
      pr=x;
      box=prbox[pr];
      boxcenter=(box[[7]]+box[[1]])/2;
      scenedepth=Table[magnitude[boxcenter,box[[i]]],{i,1,8}]//Sort//Last;
      vp -=boxcenter;
      mvp=magnitude[vp];
      unit=vp/mvp;
      onnormalplane=-1{0,vp[[2]]/vp[[1]],vp[[3]]/vp[[1]]};
      onnormalplaneunit=onnormalplane/magnitude[onnormalplane];
      vpnormal=Cross[onnormalplane,vp];
      vpnormal=vpnormal/magnitude[vpnormal];
      (* what vp would have been without pr change *)
      (* 
        use of origvp corrects Point size for aspect *)
      
      origvp=unit viewPointMulSearch[{2.5 scenedepth,0,rayfovangle}];
      (* ie. box was wide aspect made it square mvp now smaller *)
      
      apparentzoom=magnitude[origvp]/magnitude[vp];
      origvp +=boxcenter;
      vp +=boxcenter; 
      (* we don't have or need unit of origvp *)
      ];
    
    (* allows opts to override *)
    x=ViewPoint/.opts2;
    If[x=!=ViewPoint,vp=x];
    
    (* un-noticeable but rids div/0 problem *)
    
    If[vp[[1]]\[Equal]0,vp[[1]]=.0001];
    If[vp[[2]]\[Equal]0,vp[[2]]=.0001];
    If[vp[[3]]\[Equal]0,vp[[3]]=.0001];
    
    eyep=vp;
    
    (* as opposed to unit altered from aspect *)
    (* 
      newunit=(eyep-lookp)/magnitude[(eyep-lookp)]; *)
    
    viewdepth=magnitude[vp];
    scenedepth=Table[magnitude[boxcenter,box[[i]]],{i,1,8}]//Sort//Last;
    
    (* unsure how mm chooses font size *)
    
    sceneAveWidth=((2 scenedepth^2)^(1/2))/2;
    sceneAveWidth=scenedepth/2;
    
    If[rayaspect===False, (* unused *)
      (* 1.2 is magic , 
        as well as 1/4 dropoff *)
      
      linewidth=1.2 ilinewidth viewdepth (viewdepth)^(1/4);
      ];
    
    (* width adjustment far from perfect but ok for starters;
      see note about Lines; not better after vp is adjusted; *)
    
    (* less good maybe but better avoids hazards *)
    
    m=0.004025335676887489`;
    flw[x_]=200+m(x-49685.6210916414);
    
    linewidth=flw[magnitude[vp]];
    
    x=RayLineWidth/.optsf;
    If[x=!=RayLineWidth,linewidth=x];
    
    (*
      
      if an object is at origin facing {0,-1,
          0} then the two rotations to make it face ViewPoint are a z \
rotation and x rotation, in any order
      *)
    
    v={unit[[1]],unit[[2]],0}; (* rest on x-y *)
    x=magnitude[v];
    If[x===0,x=.001];
    vpRotAngles={
          ArcCos[({0,-1,0}.v)/x]/Degree,
          0,
          ArcCos[(v.unit)/x] /Degree
          }~N~maxprecision;
    
    (* these werent given but overlay needs something to go on *)
    (* 
      add depth for poly overlays; overlays*linewidth needed;
      nothing above should be effected if lesser pr inserted; *)
    
    If[twospace===True,
      If[rayoverlay=!=False,
          {pr1,pr2,pr3}=nbaspect3[pr];
          If[pr1>pr3,
            pr[[2]]=pr[[3]],
            pr[[2]]=pr[[1]]
            ];
          ];
      ];
    If[rayoverlay===True,
      (* auto default to allow lines to not coincide ? *)
      (* 
        but unfortunately way too deep for many common plots *)
      (* 
        and it was the point to make the at first hands free *)
      (* 
        ola=-linewidth 1.01; *)
      (* 
        this actually worked for bar chart and world plot wow *)
      
      ola=-linewidth/100//N; (* step by *)
      
      olc=pr[[2,2]]+ola 10//N; (* starting offset *)
      rayoverlay=olc;
      ];
    (* overlay can cause points dropped but see rayopts; *)
    
    (*
      Print["eyep=",eyep];
      Print["lookp=",lookp];
      Print["vc=",vc];
      Print["boxcenter=",boxcenter];
      Print["pr=",pr];
      Print["ro=",rayoverlay];
      Print["ola=",ola];
      *)
    
    If[rayscaled===True,
      Module[{x,y,z,x2,y2,z2},
          {pr1,pr2,pr3}=nbaspect3[pr];
          obj2=obj/.Scaled[{x_,y_}]\[Rule]
                {pr[[1,1]]+(x pr1),pr[[2,1]]+(y pr2)};
          obj2=obj2/.Scaled[{x_,y_,z_}]\[Rule]
                {pr[[1,1]]+(x pr1),pr[[2,1]]+(y pr2),pr[[3,1]]+(z pr3)};
          obj2=obj2/.Offset[{x___}]\[Rule]{x};
          obj2=obj2/.Offset[{x_,y_},{x2_,y2_}]\[Rule]
                {x+x2,y+y2};
          obj2=obj2/.Offset[{x_,y_,z_},{x2_,y2_,z2_}]\[Rule]
                {x+x2,y+y2,z+z2};
          ];
      ];
    
    (* BEGIN BUILDING FILE.RAY *)
    
    (* write to header string for opts that ask *)
    
    If[raypov===False,
      Write2[rayheader,"maxdepth 15"];
      globalsurf="";
      If[raygreyshade\[Equal]True,
        Write2[rayheader,
          "surface greyshade ambient .2 .2 .2 diffuse 0 0 0 transp .4"];
        newline2[rayheader];
        Write2[rayheader,"applysurf greyshade"];
        globalsurf="greyshade";
        ];
      If[rayglass===True,
        v=
          "surface glass ambient .025 .05 .05 diffuse .1 .2 .2 specular .5 .7 \
.7 transp
          .4 specpow 60 reflect .3";
        Write2[rayheader,v];
        newline2[rayheader];
        Write2[rayheader,"applysurf glass"];
        globalsurf="glass";
        ];
      If[globalsurf===""&&raygrey===False,
        v=
          "surface  regular  ambient .05 .05 .05  diffuse .5 .5 .5 specular \
.5 .5 .5  specpow 60 reflect .2";
        Write2[rayheader,v];
        newline2[rayheader];
        Write2[rayheader,"applysurf regular"];
        globalsurf="regular";
        ];
      ];
    
    (* see rayshade-notes.nb about rayshade v. pov glass *)
    
    If[raypov===True,
      globalsurf="";
      If[raygreyshade===True,
        Write2[rayheader,
          "#default {\ntexture { pigment {color rgb <0,0,0> transmit .4}\n\
finish {ambient .2}\n}\n}"];
        globalsurf="greyshade";
        ];
      If[rayglass===True,
        Write2[rayheader,
          "#default {\ntexture { pigment {color rgb <.5, .7, .7> transmit .4}\
\nfinish {phong 0.7 ambient 0.3}\n}\n}"];
        globalsurf="glass";
        ];
      If[globalsurf===""&&raygrey===False,
        Write2[rayheader,
          "#default {\ntexture { pigment {color rgb <.8, .8, .8>} }}"];
        globalsurf="regular";
        ];
      If[raygrey===True,
        Write2[rayheader,
            "#default {\ntexture { pigment {color rgb <.8, .8, .8>} }}"];
        ];
      ];
    
    If[rayheader=!="",Write[file,rayheader]];
    
    (* generate and write object definitions to file *)
    
    Print["callwriteobj"];
    If[obj2===Null,
      callwriteobj[obj],
      callwriteobj[obj2]
      ];
    
    Print["box"];
    
    (* generate and write bounding box lines object *)
    
    If[Boxed/.optlistsmall,
      newline[file];
      If[twospace===False,
        g=Graphics3D[prboxline[pr]];
        ,
        (* do 2d since 3d normals may well be too tight *)
        
        g=Graphics3D[prboxline2d[pr]]
        ];
      woonce=False;
      writeobj["List",Hold[{g}]];
      g=.;
      ];
    
    Print["lights etc"];
    
    (* instanciate; write "object gr1 <surf> <trans>" *)
    
    (* clip list is ie diff diff diff a b end c end d end; *)
    (* 
      the b end c end d end should be last in trans[[]]; *)
    
    For[inc=1,inc<grcount,++inc,
      newline[file];
      
      (* instanciate named object *)
      
      If[raypov===False,
        
        If[
          Length[trans]\[GreaterEqual]inc&&rayclipplotrange===True&&
            StringMatchQ[trans[[inc]],"object *"],
          Scan[
              Write[file,"difference"],
              StringPosition[trans[[inc]],"object "]
              ];
          ];
        
        Write[file,"object gr"<>ToString[inc]];
        (* any surface specifications from opts___ *)
        
        If[Length[raysurfaces]\[GreaterEqual]inc&&
            raysurfaces[[inc]]\[NotEqual]"",
          Write[file,"surface gr"<>ToString[inc]];
          Write[file,raysurfaces[[inc]]];
          ];
        (* any stored translations ie, Text uses *)
        x=False;
        If[Length[trans]\[GreaterEqual]inc&&trans[[inc]]\[NotEqual]"",
          If[rayclipplotrange===True&&StringMatchQ[trans[[inc]],"object *"],
              If[rayaspect===True,
                  v=First@First@StringPosition[trans[[inc]],"object"];
                  v=v-1;
                  Write[file,StringTake[trans[[inc]],v]];
                  writeNums[file,"\tscale",prasp];
                  Write[file,StringDrop[trans[[inc]],v]];
                  x=True;
                  ,
                  Write[file,trans[[inc]]];
                  ];
              ,
              Write[file,trans[[inc]]];
              ];
          ];
        (* stored apsect ratio squash last *)
        
        If[rayaspect===True&&x===False,writeNums[file,"\tscale",prasp]];
        ];
      
      (* instanciate named object for pov *)
      
      If[raypov===True,
        
        If[
          Length[trans]\[GreaterEqual]inc&&rayclipplotrange===True&&
            StringMatchQ[trans[[inc]],"object *"],
          Scan[
              Write[file,"difference { "],
              StringPosition[trans[[inc]],"object "]
              ];
          ];
        
        Write[file,"object { gr"<>ToString[inc]<>" "];
        If[
          Length[raysurfaces]\[GreaterEqual]inc&&
            raysurfaces[[inc]]\[NotEqual]"",
          Write[file,"texture gr"<>ToString[inc]<>" {"];
          Write[file,raysurfaces[[inc]]];
          Write[file,"}"]; (*close texture*)
          ];
        
        x=False;
        If[Length[trans]\[GreaterEqual]inc&&trans[[inc]]\[NotEqual]"",
          If[rayclipplotrange===True&&StringMatchQ[trans[[inc]],"object *"],
              x=True;
              v=First@First@StringPosition[trans[[inc]],"object"];
              v=v-1;
              Write[file,StringTake[trans[[inc]],v]];
              If[rayaspect===True,writeNums[file,"\tscale",prasp]];
              Write[file,"}"]; (*close obj*)
              
              Write[file,StringDrop[trans[[inc]],v]];
              ,
              Write[file,trans[[inc]]];
              ];
          ];
        (* stored apsect ratio squash last *)
        
        If[rayaspect===True&&x===False,writeNums[file,"\tscale",prasp]];
        If[x===False,Write[file,"}"]]; (*close obj*)
        
        ];
      
      ]; (* end for each gr loop *)
    
    (* write scene options *)
    
    (* If[rayinfo===Automatic, *)
    (* Print[" scene opts "]; *)
    
    writeOpts[file];
    
    (* write footer *)
    
    If[rayfooter===Automatic,
      newline[file];
      If[raypov===False,
        Write[file,"background 1 1 1"],
        Write[file,"background { color rgb < 1 , 1, 1 > }"];
        ]
      ,
      Write[file,rayfooter];
      ];
    (* x=Background/.fullopts; not for scene if in opts;
      writeNums[file,Apply[List,x]]; *)
    
    newline[file];
    
    (* DONE - file.ray is complete *)
    Print["done."];
    
    (* for view file could be piped to rayshade *)
    file
    ]









nbaspect3[pr_]:=Module[{fun,pr1,pr2,pr3,len},
    (* not 4 3D; pr=AspectRatio/.fullopts; *)
    len=Length[pr];
    If[len\[LessEqual]0,Return[{}]];
    If[Sign[pr[[1,1]]]===Sign[pr[[1,2]]],fun=Subtract,fun=Plus];
    pr1=Abs[Abs[pr[[1,1]]]~fun~Abs[pr[[1,2]]]];
    If[len\[LessEqual]1,Return[{pr1}]];
    
    If[Sign[pr[[2,1]]]===Sign[pr[[2,2]]],fun=Subtract,fun=Plus];
    pr2=Abs[Abs[pr[[2,1]]]~fun~Abs[pr[[2,2]]]];
    If[len\[LessEqual]2,Return[{pr1,pr2}]];
    
    If[Sign[pr[[3,1]]]===Sign[pr[[3,2]]],fun=Subtract,fun=Plus];
    pr3=Abs[Abs[pr[[3,1]]]~fun~Abs[pr[[3,2]]]];
    {pr1,pr2,pr3}
    ]

nbaspect[]:=Module[{fun,len,pr1,pr2,pr3},
    {pr1,pr2,pr3}=nbaspect3[pr]; (*rayshade`pr*)
    (* 
      scale large two down as fractions to smallest of x-y *)
    
    If[twospace===False,
      len=(pr1+pr2+pr3)/3;
      pr1=len/pr1;pr2=len/pr2;pr3=len/pr3;
      ];
    If[twospace===True,
      pr2=1;
      len=(pr1+pr3)/2;
      pr1=len/pr1;pr3=len/pr3;
      ];
    {pr1,pr2,pr3}
    ]





SetAttributes[writeobj,HoldRest];

















writeobj["rSurfaceGraphics",vl_]:=Module[{g},
      (* Print["### SurfaceGraphics "]; *)
      If[Length[vl[[1]]]>1,
        g=Graphics3D[SurfaceGraphics[vl[[1,1]],vl[[1,2]]]][[1]],
        g=Graphics3D[SurfaceGraphics[vl[[1,1]]]][[1]]
        ];
      writeobj["List",Hold[{g}]]
      ];



writeobj["rGraphics3D",oblist_]:=
    Module[{primcount2},
      primcount2=primcount;
      subprims=0;
      objadd="";
      
      newline[file];
      If[raypov===False,
        Write[file,"name gr"<>ToString[grcount]];
        Write[file,"list /* Graphics3D */"];
        ,
        Write[file,"#declare gr"<>ToString[grcount]<>" = union {"];
        ];
      
      (* writeobj[file,Chop[N[oblist]]]; *)
      (* 
        Scan[(Print["obj is: ",#];writeobj[file, #])&,oblist]; *)
      
      If[Head[oblist[[1,1]]]===List,
        writeobj["List", Unevaluated[oblist[[1]]]];
        ,
        writeobj["List", Unevaluated[oblist]];
        ];
      
      If[primcount2==primcount,
        (* empty error; use normal not usually visible *)
        
        If[raypov===False,
            Write[file,"disc  .00001  0 0 0   0 0 1"]
            ,
            Write[file,"disc  { <0, 0, 0> <0, 0, 1>  .00001 } "]
            ];
        ];
      
      If[raypov===False,
        Write[file,"end  /* Graphics3D */"];
        ,
        Write[file,"}"];
        ];
      
      If[rayclipplotrange===True,boundingbox[pr]];
      
      (* if any are sublis with names  *)
      
      If[objadd\[NotEqual]"",Write[file,objadd];primcount+=subprims];
      objadd="";
      subprims=0;
      ++grcount;
      ];





writeobj["rGraphics",oblist_]:=
    Module[{primcount2},
      primcount2=primcount;
      subprims=0;
      objadd="";
      
      newline[file];
      If[raypov===False,
        Write[file,"name gr"<>ToString[grcount]];
        Write[file,"list /* Graphics3D */"];
        ,
        Write[file,"#declare gr"<>ToString[grcount]<>" = union {"];
        ];
      
      (* writeobj[file,Chop[N[oblist]]]; *)
      (* 
        Scan[(Print["obj is: ",#];writeobj[file, #])&,oblist]; *)
      
      If[Head[oblist[[1,1]]]===List,
        writeobj["List", Unevaluated[oblist[[1]]]];
        ,
        writeobj["List", Unevaluated[oblist]];
        ];
      
      If[primcount2==primcount,
        (* empty error; use normal not usually visible *)
        
        If[raypov===False,
            Write[file,"disc  .00001  0 0 0   0 0 1"]
            ,
            Write[file,"disc  { <0, 0, 0> <0, 0, 1>  .00001 } "]
            ];
        ];
      
      If[raypov===False,
        Write[file,"end  /* Graphics3D */"];
        ,
        Write[file,"}"];
        ];
      
      If[rayclipplotrange===True,boundingbox[pr]];
      
      (* Print["exiting objadd = ",objadd]; *)
      
      (* if any are sublis with names  *)
      
      If[objadd\[NotEqual]"",Write[file,objadd];primcount+=subprims];
      objadd="";
      subprims=0;
      ++grcount;
      ];







writeobj["List", obj_]:=Module[{inc,len,lprimcount,lobj,a,h,pos},
      
      (*
        Print["LIST h= ",List];
        Print["LIST l= ",Length[obj]];
        Print["LIST a= ",obj];
        *)
      
      If[worecursion\[GreaterEqual]$RecursionLimit,Return[]];
      ++worecursion;
      
      (* Print[" + "]; *)
      (* pushsurf[""]; pushmathfun[{}]; *)
      (* 
        instead make things from outer group we're in;
        current in this group *)
      
      If[Length[surfstore]>0,
        pushsurf[surfstore[[Length[surfstore]]]];
        ,surfstore={""}];
      
      If[Length[transstore]>0,
        pushtrans[transstore[[Length[transstore]]]];
        ,transstore={""}];
      
      If[Length[mathfunstore]>0,
        pushmathfun[mathfunstore[[Length[mathfunstore]]]];
        If[(Textures/.mathfunstore[[Length[mathfunstore]]])=!=Textures,
          checktexture=True;
          ];
        ,mathfunstore={{}}
        ];
      
      Scan[
        (
            a=Hold[#];
            h=ToString[a[[1,0]]];
            a[[1,0]]=List;
            
            If[Symbol[h]===List,
              pushsurf[surfstore[[Length[surfstore]]]];
              pushtrans[transstore[[Length[transstore]]]];
              pushmathfun[mathfunstore[[Length[mathfunstore]]]];
              writeobj["List",a];
              popsurf[];
              popmathfun[];
              lasttransmit="";
              checktexture=False;
              ,
              origsymb=h;
              pos=StringPosition[h,"`"]; (*strip context*)
              
              If[pos=!={},
                pos=Last[pos[[2]]];
                h=StringDrop[h,{1,pos}];
                ];
              If[StringTake[h,1]=!="r",h="r"<>h];
              writeobj[h,a];
              ];
            
            )&
        ,obj[[1]]
        ];
      
      (* Print["obj: ",#]; *)
      (* 
        Print["color: ",surfstore[[Length[surfstore]]]]; *)
      popsurf[];
      poptrans[];
      popmathfun[];
      lasttransmit="";
      checktexture=False;
      (* Print[" - "]; *)
      --worecursion;
      ];











writeobj[h_,obj_]:=writeobj2[h,obj];



writeobjEval[h_,obj_]:=Module[{s},
    obj=obj[[1]];
    obj[[0]]=Sequence;
    (* s=StringDrop[h,1]; use origsymb, has context; *)
    
    writeobjEval[file,Symbol[origsymb][obj]];
    ]



writeobjEval[h_,obj_]:=Module[{},
      Print[" unk h: ",h," a ", obj," con ",Context[Evaluate[obj[[0]]]]," "]];









writeobj2[file_,rGraphicsComplex[gc_]]:=writeobj["List",Hold[{gc}]];



writeobj2[file_,rGraphicsGroup[gg_]]:=writeobj["List",Hold[{gg}]];



writeobj2[file_,rDirective[dd_]]:=writeobj["List",Hold[{dd}]];



writeobj2[file_,rDynamic[dd_]]:=writeobj["List",Hold[{dd}]];



pushsurf[surfspec_]:=AppendTo[surfstore,surfspec];

popsurf[]:=
    If[Length[surfstore]>1,surfstore=Take[surfstore,{1,-2}],surfstore={""}];

writesurf[file_]:=If[surfstore[[Length[surfstore]]]\[NotEqual]"",
      Write[file,surfstore[[Length[surfstore]]]]];

writesurfPOV[file_]:=
    If[surfstore[[Length[surfstore]]]\[NotEqual]"",
      Write[file,"texture { "];
      Write[file,surfstore[[Length[surfstore]]]];
      Write[file,"}"];
      ];

writesurfPOV2[str_]:=
    If[surfstore[[Length[surfstore]]]\[NotEqual]"",
      Write[str,"texture { "];
      Write2[str,surfstore[[Length[surfstore]]]];
      Write[str,"}"];
      ];

pushtrans[transspec_]:=AppendTo[transstore,transspec];

poptrans[]:=
    If[Length[transstore]>1,transstore=Take[transstore,{1,-2}],
      transstore={""}];

writetrans[file_]:=If[transstore[[Length[transstore]]]\[NotEqual]"",
      Write[file,transstore[[Length[transstore]]]]];

applytrans[str_]:=Module[{inc},
      Write2[str,transstore[[Length[transstore]]]];
      inc=1; (* insure trans is one per gr so far *)
      
      While[Length[trans]<grcount&&++inc\[LessEqual]1000,AppendTo[trans,""]];
      trans[[grcount]]=trans[[grcount]]<>str;
      ];

pushmathfun[mathfun_]:=AppendTo[mathfunstore,mathfun];

popmathfun[]:=(If[Length[mathfunstore]>1,
        mathfunstore=Take[mathfunstore,{1,-2}],mathfunstore={{}}];)





(* WRONG: writeobj2[file_,{RGBColor[r_,g_,b_],Polygon[vl_]}]:= *)







writeobj["rCylinder",vl_]:=XrCylinder[vl];

SetAttributes[XrCylinder,HoldAll];

XrCylinder[vl_]:=
    Module[{inc,len,v,rad,x,y,p1,p2,radv,cap,cu},
      (* Print["### Cylinder ",vl]; *)
      
      v=ReleaseHold[vl];
      If[v==={},v={{{0,0,-1},{0,0,1}}}];
      len=Length[v];
      If[len>1,
        v[[1]]=Partition[Flatten[v[[1]]],3];
        len=Length[v[[1]]];
        If[Length[v[[2]]]>=1,
          radv=v[[2]],radv=Table[v[[2]],{inc,1,len/2}];
          ];
        v=v[[1]];
        ,
        v=Partition[Flatten[v],3];
        len=Length[v];
        radv=Table[1,{inc,1,len/2}];
        ];
      
      If[len>=2,
        
        If[Length[mathfunstore]>0,
          cap=CapForm/.mathfunstore[[Length[mathfunstore]]]];
        
        For[inc=2,inc\[LessEqual]len,inc+=2,
          p1=v[[inc-1]];
          p2=v[[inc]];
          p1=pointInPlotRange[p1];
          If[p1===Null,Continue[]];
          p2=pointInPlotRange[p2];
          If[p2===Null,Continue[]];
          rad=radv[[inc/2]];
          
          If[raypov===False,
            writeNums[file,"cylinder ",surfstore[[Length[surfstore]]]];
            writeNumsFastR[rad,p1];
            writeNumsFast[p2];
            applyTexture["cylindrical",(p1+p2)/2];
            writetrans[file];
            ,
            Write[file,"cylinder  { "];
            writeNums[file,p1," , "];
            writeNums[file,p2," , "];
            writeNums[file,rad];
            Write[file," open "];
            applyTexture["cylindrical",(p1+p2)/2];
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          (* put on endcap /. options here *)
          
          If[ cap=!=CapForm&&cap[[1]]=!=None,
              If[cap[[1]]\[Equal]"Butt",
                x=magnitude[(p2-p1)];
                If[Chop@x===0,x=.001];
                cu=(p2-p1)/x;
                Xrdisc[{rad,p1,-cu}];
                Xrdisc[{rad,p2,cu}];
                ];
              If[cap[[1]]\[Equal]"Round",XrSphere[{{p1,p2},rad}]];
              ];
          ];
        
        primcount+=len;
        ];
      ];





writeobj["rTube",vl_]:=XrTube[vl];

SetAttributes[XrTube,HoldAll];

XrTube[vl_]:=
    Module[{inc,len,v,o,rad,x,y,p1,p2,cap},
      (* Print["### Tube ",vl]; *)
      
      v=ReleaseHold[vl];
      If[v==={},v={{{0,0,-1},{0,0,1}}}];
      len=Length[v];
      If[len>1,
        v[[1]]=Partition[Flatten[v[[1]]],3];
        len=Length[v[[1]]];
        If[Length[v[[2]]]>=1,
          radv=v[[2]],radv=Table[v[[2]],{inc,1,len/2}];
          ];
        v=v[[1]];
        ,
        v=Partition[Flatten[v],3];
        len=Length[v];
        radv=Table[linewidth,{inc,1,len/2}];
        ];
      
      If[len>1,
        
        If[Length[mathfunstore]>0,
          cap=CapForm/.mathfunstore[[Length[mathfunstore]]]];
        For[inc=1,inc<len,++inc,
          p1=pointInPlotRange[v[[inc]]];
          If[p1===Null,Continue[]];
          p2=pointInPlotRange[v[[inc+1]]];
          If[p2===Null,Continue[]];
          rad=radv[[(inc+Mod[inc,2])/2]];
          If[raypov===False,
            writeNums[file,"cylinder ",surfstore[[Length[surfstore]]]];
            writeNumsFastR[rad,p1];
            writeNumsFast[p2];
            applyTexture["cylindrical",(p1+p2)/2];
            writetrans[file];
            ,
            Write[file,"cylinder  { "];
            writeNums[file,p1," , "];
            writeNums[file,p2," , "];
            writeNums[file,rad];
            Write[file," open "];
            applyTexture["cylindrical",(p1+p2)/2];
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          (* put on endcap /. options here *)
          
          If[ cap=!=CapForm&&cap[[1]]=!=None,
            If[cap[[1]]\[Equal]"Butt",
              x=magnitude[(p2-p1)];
              If[Chop@x===0,x=.001];
              cu=(p2-p1)/x;
              Xrdisc[{rad,p1,-cu}];
              Xrdisc[{rad,p2,cu}];
              ];
            If[cap[[1]]\[Equal]"Round",XrSphere[{{p1,p2},rad}]];
            ];
          ];
        primcount+=len;
        ];
      ];





writeobj["rLineTube",vl_]:=XrLineTube[vl];

SetAttributes[XrLineTube,HoldAll];

XrLineTube[vl_]:=
    Module[{inc,len,v,rad,x,y,p1,p2},
      (* Print["### LineTube ",vl]; *)
      v=ReleaseHold[vl][[1]];
      If[v==={},Return[]];
      
      If[NumberQ[rayoverlay]===True,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      
      v=Partition[Flatten[v],3];
      (* v=Select[Map[pointInPlotRange,v],ListQ]; *)
      len=Length[v];
      
      If[len>1,
        If[Length[mathfunstore]>0,
          rad=AbsoluteThickness/.mathfunstore[[Length[mathfunstore]]];
          ];
        If[\[Not]NumberQ[rad],rad=linewidth];
        rad*=4/10~N~maxprecision;
        (* see notes below *)
        
        If[rayaspect===True,rad=rad/(apparentzoom^2)];
        For[inc=1,inc<len,++inc,
          
          p1=v[[inc]];
          p2=v[[inc+1]];
          p1=pointInPlotRange[p1];
          If[p1===Null,Continue[]];
          p2=pointInPlotRange[p2];
          If[p2===Null,Continue[]];
          
          If[raypov===False,
            writeNums[file,"cylinder ",surfstore[[Length[surfstore]]]];
            writeNumsFastR[rad,p1];
            writeNumsFast[p2];
            writetrans[file];
            ];
          If[raypov===True,
            Write[file,"cylinder  { "];
            writeNums[file,p1," , "];
            writeNums[file,p2];
            writeNums[file,rad];
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          ];
        primcount+=len;
        ];
      ];





writeobj["rLineBox",vl_]:=XrLineBox[vl];

SetAttributes[XrLineBox,HoldAll];

XrLineBox[vl_]:=
    
    Module[{inc,len,v,rad,x,y,unit,vn,vpRotAngles,mvn,mag,ang,p1,p2,err},
      (* Print["### LineBox ",vl]; *)
      v=ReleaseHold[vl][[1]];
      If[v==={},Return[]];
      
      If[NumberQ[rayoverlay]===True,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      
      v=Partition[Flatten[v],3];
      (* v=Select[Map[pointInPlotRange,v],ListQ]; *)
      len=Length[v];
      
      If[len>1,
        If[Length[mathfunstore]>0,
          rad=AbsoluteThickness/.mathfunstore[[Length[mathfunstore]]];
          ];
        If[\[Not]NumberQ[rad],rad=linewidth];
        rad*=1/4~N~maxprecision;
        
        (* see notes below *)
        
        If[rayaspect===True,rad=rad/(apparentzoom^2)];
        For[inc=1,inc<len,++inc,
          
          p1=v[[inc]];
          p2=v[[inc+1]];
          p1=pointInPlotRange[p1];
          If[p1===Null,Continue[]];
          p2=pointInPlotRange[p2];
          If[p2===Null,Continue[]];
          
          If[p2[[2]]>p1[[2]],vn=p2-p1,vn=p1-p2];
          
          mag=magnitude[vn];
          If[mag===0,Continue[]];
          
          unit=vn/mag;
          vn={unit[[1]],unit[[2]],0}; (* rest on x-y *)
          
          mvn=magnitude[vn];
          (* clamp *)
          ang=({1,0,0}.vn)/(mvn+.00001);
          If[ang<-1,ang=-1];
          If[ang>1,ang=1];
          
          vpRotAngles={
                ArcCos[ang]/Degree,
                0,
                ArcCos[({0,0,1}.unit)]/Degree
                }~N~maxprecision;
          vpRotAngles[[3]]=90-vpRotAngles[[3]]~N~maxprecision;
          
          (* FIXME *)
          
          err=False;
          
          If[vpRotAngles[[1]]===Indeterminate,vpRotAngles[[1]]=90;err=True;
            Print["indet"];];
          
          If[vpRotAngles[[3]]===Indeterminate,vpRotAngles[[3]]=90;err=True;
            Print["indet"];];
          vpRotAngles[[1]]=Re[vpRotAngles[[1]]];
          vpRotAngles[[3]]=Re[vpRotAngles[[3]]];
          
          If[raypov===False,
            writeNums[file,"box ",surfstore[[Length[surfstore]]]];
            writeNumsFast[{-mag/2,-rad,-rad}];
            writeNumsFast[{mag/2,rad,rad} ];
            writeNums[file,"rotate ",{0,1,0},-vpRotAngles[[3]]];
            writeNums[file,"rotate ",{0,0,1},vpRotAngles[[1]]];
            writeNums[file,"translate ",(p1+p2)/2];
            
            writetrans[file];
            ];
          
          If[raypov===True,
            Write[file,"box  { "];
            
            writeNums[file,{-mag/2,-rad,-rad},","];
            writeNums[file,{mag/2,rad,rad} ];
            writeNums[file,"rotate ",{0,-vpRotAngles[[3]],0}];
            writeNums[file,"rotate ",{0,0,vpRotAngles[[1]]}];
            writeNums[file,"translate ",(p1+p2)/2];
            
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          ];
        
        primcount+=len;
        ];
      ];















writeobj["rLine",vl_]:=
    
    If[Length[mathfunstore]>
          0&&(Dashing/.mathfunstore[[Length[mathfunstore]]])=!=Dashing,
      XrDashing[vl];
      ,
      If[rayboxlines===False&&raytubelines===False,
          XrLine[vl]
          ,
          If[rayboxlines===True,XrLineBox[vl],XrLineTube[vl]]
          ];
      ];

SetAttributes[XrLine,HoldAll];



XrLine[vl_]:=
    Module[{inc,len,v,add,ma,rad,x,y,p1,p2},
      (* Print["### Line ", vl]; *)
      v=ReleaseHold[vl][[1]];
      If[v==={},Return[]];
      
      If[NumberQ[rayoverlay]===True,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      
      v=Partition[Flatten[v],3];
      len=Length[v];
      (* Print["line len pr v",len,"\n",pr,"\n",v]; *)
      
      If[len>1,
        If[Length[mathfunstore]>0,
          rad=AbsoluteThickness/.mathfunstore[[Length[mathfunstore]]];
          ];
        If[\[Not]NumberQ[rad],rad=linewidth];
        
        For[inc=1,inc<len,++inc,
          
          p1=v[[inc]];
          p2=v[[inc+1]];
          p1=pointInPlotRange[p1];
          If[p1===Null,Continue[]];
          p2=pointInPlotRange[p2];
          If[p2===Null,Continue[]];
          
          (* see code notes about surfstore *)
          If[raypov===False,
            (* darken - with std lights it washes out near boxcenter;
              this is due to reflect v. normal rather than size;
              *)
            If[rayglass===False,
                
                Write[file,
                  "polygon "<>globalsurf<>" diffuse .2 .2 .2 "<>
                    surfstore[[Length[surfstore]]]]
                ,
                
                Write[file,
                  "polygon glass diffuse  .05 .1 .1 "<>
                    surfstore[[Length[surfstore]]]]
                ];
            ];
          If[raypov===True,
            Write[file,"polygon { 5, "];
            ];
          (* "fast" add=Cross[(v[[inc]]-v[[inc+1]]),unit]; *)
          
          add=Cross[(p1-p2),(eyep-p1)];
          ma=magnitude[add];
          If[ma\[Equal]0,ma=.0001];
          add=rad add/ma;
          add/=2;
          (* we get scaled later but need to keep linewidth *)
          
          add/=prasp; (* If[rayaspect\[Equal]True] *)
          
          If[raypov===False,
            writeNumsFast[p1-add/2];
            writeNumsFast[p2-add/2];
            writeNumsFast[p2 +add/2];
            writeNumsFast[p1+add/2];
            writetrans[file];
            ,
            writeNums[file,p1-add/2," , "];
            writeNums[file,p2-add/2, " , "];
            writeNums[file,p2 +add/2, " , "];
            writeNums[file,p1+add/2," , "];
            writeNums[file,p1-add/2];
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          ];
        
        primcount+=len;
        ];
      ];







writeobj["rPoint",vl_]:=XrPoint[vl];

SetAttributes[XrPoint,HoldAll];

XrPoint[vl_]:=
    Module[{inc,len,v,rad,x,y,area,area2},
      
      (* Print["### Point ", vl]; *)
      v=ReleaseHold[vl][[1]];
      If[v==={},Return[]];
      
      If[NumberQ[rayoverlay]===True,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      
      v=Partition[Flatten[v],3];
      v=Select[Map[pointInPlotRange,v],ListQ];
      len=Length[v];
      
      If[len>0,
        If[Length[mathfunstore]>0,
          rad=PointSize/.mathfunstore[[Length[mathfunstore]]];
          ];
        If[\[Not]NumberQ[rad],rad=linewidth];
        (* see notes below *)
        
        If[rayaspect===True,rad=rad/apparentzoom];
        rad=rad~N~maxprecision;
        
        For[inc=1,inc\[LessEqual]len,++inc,
          v2=v[[inc]];
          If[raypov===False,
            (* darken - with std lights it washes out near boxcenter;
              this is due to reflect v. normal rather than size;
              *)
            If[rayglass===False,
              
              writeNums[file,"disc ",globalsurf," diffuse .1 .1 .1 ",
                surfstore[[Length[surfstore]]],rad]
              ,
              
              writeNums[file,"disc glass diffuse .05 .1 .1 ",
                surfstore[[Length[surfstore]]],rad]
              ];
            writeNumsFast[v2];
            writeNumsFast[-unit];
            writetrans[file];
            ];
          If[raypov===True,
            Write[file,"disc  { "];
            writeNums[file,v2];
            writeNums[file,-unit];
            writeNums[file,rad];
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          
          ++primcount;
          ];
        ];
      ];







writeobj["rPolygon",vl_]:=XrPolygon[ReleaseHold[vl][[1]]];



XrPolygon[vl_]:=
    Module[{v,x,y,vi,vt,len},
      (* Print["### Polygon ", vl]; *)
      If[vl==={},Return[]];
      (* mm v9 allows lists in lists *)
      If[First[First[vl]]===List,
        If[polyrecursion\[GreaterEqual]$RecursionLimit,Return[]];
        ++polyrecursion;
        Scan[XrPolygon,vl];
        --polyrecursion;
        Return[];
        ];
      (* tesselation gives us a limited list todo *)
      
      If[raytesselate===True,
        vt=tessfunPoly3[vl];
        raytesselate=False;
        Scan[writetriagle,vt];
        raytesselate=True;
        Return[];
        ];
      
      If[NumberQ[rayoverlay]===True,
        v=vl/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        v=vl/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y}; 
        ];
      
      v=Select[Map[pointInPlotRange,v],ListQ];
      If[Length[v]\[LessEqual]2,Return[]];
      
      (* closes Polygon but POV still barfs;
        rayshade and TriangularSurfacePlot dont care *)
      (*If[
            Last[v]=!=First[v],AppendTo[v,First[v]]];*)
      
      If[raypov===False,
        Write[file,"polygon  "<>surfstore[[Length[surfstore]]]];
        Scan[(writeNumsFast[#])&,v];
        If[checktexture===True,applyTexture["planar",Plus@@v/Length[v]]];
        writetrans[file];
        ,
        Write[file,"polygon { "];
        Write[file,ToString[Length[v]]<>","];
        Scan[(writeNums[file,#];Write[file,","])&,Take[v,Length[v]-1]];
        writeNums[file,Last[v]];
        If[checktexture===True,applyTexture["planar",{0,0,0}]];
        writesurfPOV[file];
        writetrans[file];
        Write[file,"}"];
        ];
      
      ++primcount;
      ];



writetriagle[vl_]:=
    Module[{},
      If[raypov===False,
        Write[file,"triangle  "<>surfstore[[Length[surfstore]]]];
        Scan[(writeNumsFast[#])&,vl];
        If[checktexture===True,applyTexture["planar",Plus@@vl/3]];
        writetrans[file];
        ,
        Write[file,"triangle { "];
        Scan[(writeNums[file,#];Write[file,","])&,Take[vl,Length[vl]-1]];
        writeNums[file,Last[vl]];
        If[checktexture===True,applyTexture["planar",{0,0,0}]];
        writesurfPOV[file];
        writetrans[file];
        Write[file,"}"];
        ];
      
      ++primcount;
      ];









writeobj["rCuboid",vl_]:=XrCuboid[vl];

SetAttributes[XrCuboid,HoldAll];

XrCuboid[vl_]:=Module[{v,p1,p2,inc},
      (* Print["### Cuboid ", vl]; *)
      v=ReleaseHold[vl];
      If[v==={},v={{0,0,0},{1,1,1}}];
      v=Partition[Flatten[v],3];
      If[Length[v]===1,AppendTo[v,v[[1]]+{1,1,1}]];
      len=Length[v];
      
      If[len>=2,
        For[inc=2,inc\[LessEqual]len,inc+=2,
          p1=v[[inc-1]];
          p2=v[[inc]];
          p1=pointInPlotRange[p1];
          If[p1===Null,Continue[]];
          p2=pointInPlotRange[p2];
          If[p2===Null,Continue[]];
          
          If[raypov===False,
            Write[file,"box  "<>surfstore[[Length[surfstore]]]];
            writeNumsFast[p1];
            writeNumsFast[p2];
            applyTexture["planar",(p1+p2)/2];
            writetrans[file];
            ,
            Write[file,"box { "];
            writeNums[file,p1];
            writeNums[file,p2];
            applyTexture["planar",(p1+p2)/2];
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          ];
        ++primcount;
        ];
      ];











writeobj["rSphere",vl_]:=XrSphere[vl];

SetAttributes[XrSphere,HoldAll];

XrSphere[vl_]:=Module[{v,rad,p1,inc,radv},
      
      (* Print["### Sphere ", vl]; *)
      
      v=ReleaseHold[vl];
      If[v==={},v={{0,0,0}}];
      len=Length[v];
      
      If[Head[v[[1]]]=!=List,v={v};len=1;];
      
      If[len>1,
        v[[1]]=Partition[Flatten[v[[1]]],3];
        len=Length[v[[1]]];
        If[Length[v[[2]]]>=1,
          radv=v[[2]],radv=Table[v[[2]],{inc,1,len}];
          ];
        v=v[[1]];
        ,
        v=Partition[Flatten[v],3];
        len=Length[v];
        radv=Table[1,{inc,1,len}];
        ];
      
      inc=1;
      Scan[(
            rad=radv[[inc++]];
            p1=pointInPlotRange[#];
            If[p1=!=Null,
              If[raypov===False,
                Write[file,"sphere  "<>surfstore[[Length[surfstore]]]];
                writeNumsFastR[rad,#];
                writetrans[file];
                If[checktexture===True,applyTexture["spherical",#]];
                ,
                Write[file,"sphere { "];
                writeNums[file,#];
                writeNums[file,rad];
                If[checktexture===True,applyTexture["spherical",#]];
                writesurfPOV[file];
                writetrans[file];
                Write[file,"}"];
                ];
              ++primcount;
              ];
            )&,v
        ];
      ];







writeobj2["rDisk",vl_]:=XrDisk[vl];

SetAttributes[XrDisk,HoldAll];



XrDisk[vl_]:=
    
    Module[{inc,len,v,rad,x,y,center,norm,segangle,semiaxis,str},
      (* Print["### Disk ",vl]; *)
      v=ReleaseHold[vl];
      segangle=Null;semiaxis=Null;
      If[v==={},v={{0,0}}];
      norm={0,1,0};
      center=v[[1]];
      rad=1;
      If[Length[v]>1,
        If[Head@v[[2]]=!=List,
            rad=v[[2]];If[Length[v]>2,segangle=v[[3]]],
            semiaxis=v[[2]]];];
      
      If[NumberQ[rayoverlay]===True,
        center=center/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        center=center/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      
      center=pointInPlotRange[center];
      If[center\[Equal]Null,Return[]];
      
      (* if drawing as poly; ie cant do csg segangle for now; *)
      
      If[raycsg===False||segangle=!=Null,
        Module[{u,g,r,gr,primcount2=primcount},
          If[segangle===Null,r={-\[Pi],\[Pi]},r=segangle];
          
          g=ParametricPlot[{rad Cos[u]+center[[1]],rad Sin[u]+center[[3]]},{u,
                r[[1]],r[[2]]},DisplayFunction\[Rule]Identity,
              PlotRange\[Rule]Drop[pr,{2,2}]];
          g[[1]]=g[[1]]/.Line\[Rule]Polygon;
          If[segangle=!=Null,
            g[[1,1,1,1]]=Append[g[[1,1,1,1]],{center[[1]],center[[3]]}];
            g[[1,1,1,1]]=Prepend[g[[1,1,1,1]],{center[[1]],center[[3]]}];
            ];
          (* Show[g,DisplayFunction\[Rule]$DisplayFunction]; *)
          
          (* eclectically scale here v. after instanciation;
            oops its harder for pov; see also notes after circle; *)
         
           If[raypov===False,
            writeNums[file,"list"],
            gr="gr"<>ToString@grcount<>ToString@primcount;
            writeNums[file,"#declare "<>gr<>" = union {"]
            ];
          
          writeobj["List",Unevaluated[{g}]];
          If[primcount2==primcount,
            (* empty error; use normal not usually visible *)
            
            If[raypov===False,
                Write[file,"disc  .00001  0 0 0   0 0 1"]
                ,
                Write[file,"disc  { <0, 0, 0> <0, 0, 1>  .00001 } "]
                ];
            ];
          
          If[raypov===False,
            writeNums[file,"end"];
            If[semiaxis=!=Null,writeNums[file,"scale ",
                {semiaxis[[1]],semiaxis[[2]],1}]];
            ,
            writeNums[file,"}"];
            writeNums[file,"object { "<>gr];
            If[semiaxis=!=Null,writeNums[file,"scale ",
                {semiaxis[[1]],semiaxis[[2]],1}]];
            writeNums[file,"}"];
            ];
          
          ];
        primcount+=1;
        Return[];
        ];
      
      If[raypov===False,
        writeNums[file,"disc ",surfstore[[Length[surfstore]]]];
        writeNumsFastR[rad,center];
        writeNumsFast[norm];
        If[semiaxis=!=Null,
          writeNums[file,"scale ",{semiaxis[[1]],semiaxis[[2]],1}];];
        applyTexture["planar",center];
        writetrans[file];
        ,
        Write[file,"disc  { "];
        writeNums[file,center," , "];
        writeNums[file,norm];
        writeNums[file,rad];
        applyTexture["planar",center];
        writesurfPOV[file];
        If[semiaxis=!=Null,
          writeNums[file,"scale ",{semiaxis[[1]],semiaxis[[2]],1}];];
        writetrans[file];
        Write[file,"}"];
        
        ];
      
      primcount+=1;
      ];



writeobj2["rdisc",vl_]:=Xrdisc[vl];

SetAttributes[Xrdisc,HoldAll];



Xrdisc[vl_]:=
    Module[{inc,len,rad,center,semiaxis},
      (* Print["### disc ",vl]; *)
      v=ReleaseHold[vl];
      len=Length@v;
      If[len<3,Return[]];
      rad=v[[1]];
      center=v[[2]];
      center=pointInPlotRange[center];
      If[center\[Equal]Null,Return[]];
      norm=v[[3]];
      semiaxis=Null;
      If[len>3,semiaxis=v[[4]]];
      
      If[raypov===False,
        writeNums[file,"disc ",surfstore[[Length[surfstore]]]];
        writeNumsFastR[rad,center];
        writeNumsFast[norm];
        If[semiaxis=!=Null,writeNums[file,"scale ",semiaxis]];
        writetrans[file];
        ,
        Write[file,"disc  { "];
        writeNums[file,center," , "];
        writeNums[file,norm];
        writeNums[file,rad];
        writesurfPOV[file];
        If[semiaxis=!=Null,writeNums[file,"scale ",semiaxis]];
        writetrans[file];
        Write[file,"}"];
        ];
      primcount+=1;
      ];





writeobj2["rCircle",vl_]:=XrCircle[vl];

SetAttributes[XrCircle,HoldAll];

XrCircle[vl_]:=
    
    Module[{inc,len,v,rad,x,y,center,norm,segangle,semiaxis,str},
      (* Print["### Circle ",vl]; *)
      v=ReleaseHold[vl];
      segangle=Null;semiaxis=Null;
      If[v==={},v={{0,0}}];
      norm={0,1,0};
      center=v[[1]];
      rad=1;
      If[Length[v]>1,
        If[Head@v[[2]]=!=List,
            rad=v[[2]];If[Length[v]>2,segangle=v[[3]]],
            semiaxis=v[[2]]];];
      
      If[NumberQ[rayoverlay]===True,
        center=center/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        center=center/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      
      center=pointInPlotRange[center];
      If[center\[Equal]Null,Return[]];
      
      (* draw as lines or tubes; cant do csg segangle for now; *)
      
      If[raycsg===False||segangle=!=Null,
        Module[{u,g,r,gr,primcount2=primcount},
          If[segangle===Null,r={-\[Pi],\[Pi]},r=segangle];
          
          g=ParametricPlot[{rad Cos[u]+center[[1]],rad Sin[u]+center[[3]]},{u,
                r[[1]],r[[2]]},DisplayFunction\[Rule]Identity,
              PlotRange\[Rule]Drop[pr,{2,2}]];
          (* Show[g,DisplayFunction\[Rule]$DisplayFunction]; *)
          
          (* eclectically scale here v. after instanciation;
            oops its harder for pov; *)
          If[raypov===False,
            writeNums[file,"list"],
            gr="gr"<>ToString@grcount<>ToString@primcount;
            writeNums[file,"#declare "<>gr<>" = union {"]
            ];
          
          writeobj["List",Unevaluated[{g}]];
          If[primcount2==primcount,
            (* empty error; use normal not usually visible *)
            
            If[raypov===False,
                Write[file,"disc  .00001  0 0 0   0 0 1"]
                ,
                Write[file,"disc  { <0, 0, 0> <0, 0, 1>  .00001 } "]
                ];
            ];
          
          If[raypov===False,
            writeNums[file,"end"];
            If[semiaxis=!=Null,writeNums[file,"scale ",
                {semiaxis[[1]],semiaxis[[2]],1}]];
            ,
            writeNums[file,"}"];
            writeNums[file,"object { "<>gr];
            If[semiaxis=!=Null,writeNums[file,"scale ",
                {semiaxis[[1]],semiaxis[[2]],1}]];
            writeNums[file,"}"];
            ];
          ];
        primcount+=1;
        Return[];
        ];
      
      If[raypov===False,
        (* a little hard in rayshade *)
        (* draw as solid *)
        
        If[raycsg===True,
            writeNums[file,"difference"];
            
            writeNums[file,"list"];
            writeNums[file,"cylinder ",surfstore[[Length[surfstore]]]];
            
            writeNumsFastV[{rad,center-{0,linewidth/2,0},
                center+{0,linewidth/2,0}}];
            writeNums[file,"disc ",surfstore[[Length[surfstore]]]];
            writeNumsFastV[{rad,center+{0,linewidth/2,0},norm}];
            writeNums[file,"disc ",surfstore[[Length[surfstore]]]];
            writeNumsFastV[{rad,center-{0,linewidth/2,0},-norm}];
            writeNums[file,"end"];
            
            writeNums[file,"list"];
            writeNums[file,"cylinder ",surfstore[[Length[surfstore]]]];
            
            writeNumsFastV[{rad-linewidth/2,center-{0,linewidth/2,0},
                center+{0,linewidth/2,0}}];
            writeNums[file,"disc ",surfstore[[Length[surfstore]]]];
            writeNumsFastV[{rad-linewidth/2,center+{0,linewidth/2,0},norm}];
            writeNums[file,"disc ",surfstore[[Length[surfstore]]]];
            writeNumsFastV[{rad-linewidth/2,center-{0,linewidth/2,0},-norm}];
            writeNums[file,"end"];
            
            writeNums[file,"end"];
            
            If[semiaxis=!=Null,
              writeNums[file,"scale ",{semiaxis[[1]],semiaxis[[2]],1}];];
            applyTexture["planar",center];
            writetrans[file];
            ];
        ,
        Write[file,"disc  { "];
        writeNums[file,center," , "];
        writeNums[file,norm];
        writeNums[file,rad];
        writeNums[file,rad-linewidth];
        applyTexture["planar",center];
        writesurfPOV[file];
        If[semiaxis=!=Null,
          writeNums[file,"scale ",{semiaxis[[1]],semiaxis[[2]],1}];];
        writetrans[file];
        Write[file,"}"];
        ];
      
      ];







writeobj2["rRectangle",vl_]:=XrRectangle[vl];

SetAttributes[XrRectangle,HoldAll];

XrRectangle[vl_]:=Module[{p1,p2,inc,g,center,pr1,pr2,gpr1,gpr2,bc,str,gpr},
      
      (* Print["### Rectangle ", vl]; *)
      v=ReleaseHold[vl];
      If[v==={},v={{0,0},{1,1}}];
      len=Length[v];
      If[len===1,v={v[[1]],v[[1]]+{1,1}};len=2];
      
      (* does g if g is given *)
      If[len===3,
        
        (* PlotRegion does not change pts wish it did *)
        
        g=Show[v[[3]],DisplayFunction\[Rule]Identity];
        gpr=PlotRange/.AbsoluteOptions[g];
        g=v[[3]];
        
        center=(v[[1]]+v[[2]])/2;
        {pr1,pr2}=nbaspect3[
            {{v[[1,1]],v[[2,1]]},{v[[1,2]],v[[2,2]]}}];
        {gpr1,gpr2}=nbaspect3[gpr];
        
        (* this empty is for rect *)
        If[raypov===False,
          Write[file,"disc  .00001  0 0 0   0 0 1"]
          ,
          Write[file,"disc  { <0, 0, 0> <0, 0, 1>  .00001 } "]
          ];
        ++primcount;
        ++grcount;
        inc=pr; (* shouldnt need but to be safe *)
        
        pr={gpr[[1]],{-.001,.001},gpr[[2]]};
        
        writeobj["List",Hold[{g}]];
        
        pr=inc;
        --grcount;
        str="";
        writeNums2[str,
          "\ttranslate ",{-(Plus@@gpr[[1]])/2,0,-(Plus@@gpr[[2]])/2}];
        writeNums2[str,"\tscale ",{pr1/gpr1,1,pr2/gpr2}];
        
        If[NumberQ[rayoverlay]===True,
          
          writeNums2[str,
            "\ttranslate ",{center[[1]],rayoverlay,center[[2]]}];
          rayoverlay+=ola;
          ,
          writeNums2[str,"\ttranslate ",{center[[1]],0,center[[2]]}];
          ];
        
        applytrans[str];
        Return[];
        ];
      
      If[NumberQ[rayoverlay]===True,
        v[[1]]=v[[1]]/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        v[[2]]=v[[2]]/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        v[[1]]=v[[1]]/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        v[[2]]=v[[2]]/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      
      If[len>=2,
        For[inc=2,inc\[LessEqual]len,inc+=2,
          p1=v[[inc-1]];
          p2=v[[inc]];
          p1=pointInPlotRange[p1];
          If[p1===Null,Continue[]];
          p2=pointInPlotRange[p2];
          If[p2===Null,Continue[]];
          
          p1[[2]]+=-linewidth/2;
          p2[[2]]+=linewidth/2;
          
          If[raypov===False,
            Write[file,"box  "<>surfstore[[Length[surfstore]]]];
            writeNumsFast[p1];
            writeNumsFast[p2];
            applyTexture["planar",(p1+p2)/2];
            writetrans[file];
            ,
            Write[file,"box { "];
            writeNums[file,p1];
            writeNums[file,p2];
            applyTexture["planar",(p1+p2)/2];
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          ];
        ++primcount;
        ];
      ];







writeobj2["rCone",vl_]:=XrCone[vl];

SetAttributes[XrCone,HoldAll];

XrCone[vl_]:=
    Module[{inc,len,v,rad,x,y,p1,p2,radv,cap},
      (* Print["### Cone ",vl]; *)
      
      v=ReleaseHold[vl];
      If[v==={},v={{{0,0,-1},{0,0,1}}}];
      len=Length[v];
      If[len>1,
        v[[1]]=Partition[Flatten[v[[1]]],3];
        len=Length[v[[1]]];
        If[Length[v[[2]]]>=1,
          radv=v[[2]],radv=Table[v[[2]],{inc,1,len/2}];
          ];
        v=v[[1]];
        ,
        v=Partition[Flatten[v],3];
        len=Length[v];
        radv=Table[1,{inc,1,len/2}];
        ];
      
      If[len>=2,
        
        If[Length[mathfunstore]>0,
          cap=CapForm/.mathfunstore[[Length[mathfunstore]]]];
        
        For[inc=2,inc\[LessEqual]len,inc+=2,
          p1=v[[inc-1]];
          p2=v[[inc]];
          p1=pointInPlotRange[p1];
          If[p1===Null,Continue[]];
          p2=pointInPlotRange[p2];
          If[p2===Null,Continue[]];
          rad=radv[[inc/2]];
          (*
            Print["r=",rad];
            Print["p1=",p1];
            Print["p2=",p2];
            *)
          If[raypov===False,
            writeNums[file,"cone ",surfstore[[Length[surfstore]]]];
            writeNumsFastR[rad,p1];
            writeNumsFastR[0,p2];
            applyTexture["cylindrical",(p1+p2)/2];
            writetrans[file];
            ,
            Write[file,"cone  { "];
            writeNums[file,p1," , "];
            writeNums[file,rad, " , "];
            writeNums[file,p2, " , "];
            writeNums[file,0];
            Write[file," open "];
            applyTexture["cylindrical",(p1+p2)/2];
            writesurfPOV[file];
            writetrans[file];
            Write[file,"}"];
            ];
          
          (* put on endcap /. options here *)
          
          If[ cap=!=CapForm&&cap[[1]]=!=None,
              If[cap[[1]]\[Equal]"Butt",
                x=magnitude[(p2-p1)];
                If[Chop@x===0,x=.001];
                cu=(p2-p1)/x;
                Xrdisc[{rad,p1,-cu}];
                ];
              If[cap[[1]]\[Equal]"Round",XrSphere[{p1,rad}]];
              ];
          
          ];
        primcount+=len;
        ];
      ];







writeobj2["rArrow",vl_]:=XrArrow[vl];

SetAttributes[XrArrow,HoldAll];

XrArrow[vl_]:=
    Module[{inc,v,u,mu,rad,add,ma,p0,p1,p2,headscaling,headlength,headwidth,
        headcenter,lopts,cone,x,k,w,len,len2},
      
      v=ReleaseHold[vl];
      x=Position[v,Rule];lopts={};
      If[x=!={}&&IntegerQ@x[[1,1]],
        x=x[[1,1]]-1;If[x<1,Return[]];
        lopts=Drop[v,x];
        v=Take[v,x];
        ];
      (*ignore v9 setback*)
      
      If[NumericQ@Last@v,headcenter=Last@v;v=Drop[v,-1]];
      If[NumberQ[rayoverlay]===True,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      x=Position[v,{x_?NumberQ,y_?NumberQ,z_?NumberQ}];
      len=Length@x;
      If[len<1,Return[]];
      If[len>1,p0=v[[Sequence@@x[[1]]]],p0=boxcenter];
      If[len>1,p1=v[[Sequence@@x[[len-1]]]],p1=boxcenter];
      p2=v[[Sequence@@x[[len]]]];
      p0=pointInPlotRange[p0];
      If[p0===Null,Return[]];
      p1=pointInPlotRange[p1];
      If[p1===Null,Return[]];
      p2=pointInPlotRange[p2];
      If[p2===Null,Return[]];
      If[p1\[Equal]p2,Return[]];
      (*no direction;
        If[p1\[Equal]p2,p2+=linewidth/10;
          v[[Sequence@@x[[len]]]]+=linewidth/10];*)
      u=p2-p1;
      mu=magnitude[u];
      If[mu\[NotEqual]0,u=u/mu];
      If[Length[mathfunstore]>0,
        rad=AbsoluteThickness/.mathfunstore[[Length[mathfunstore]]]
        ];
      If[\[Not]NumberQ[rad],rad=linewidth];
      
      (* this is a problem of mm changing public env *)
      
      headlength=Graphics`Arrow`HeadLength/.lopts/.Options[Arrow];
      headscaling=Graphics`Arrow`HeadScaling/.lopts/.Options[Arrow];
      headwidth=Graphics`Arrow`HeadWidth/.lopts/.Options[Arrow];
      headcenter=Graphics`Arrow`HeadCenter/.lopts/.Options[Arrow];
      If[\[Not]NumberQ[rad],rad=linewidth];
      If[\[Not]NumberQ[headlength],headlength=1];
      If[\[Not]NumberQ[headwidth],headwidth=1/2];
      If[\[Not]NumberQ[headcenter],headcenter=1];
      If[headscaling===Graphics`Arrow`Relative,
        headlength*=mu/(rad 4),headlength*=7];
      headwidth=headlength headwidth;
      If[\[Not]NumberQ[headlength],headlength=linewidth/10];
      
      (* cone arg *)
      x=u rad headlength;
      cone={{p2+(1-headcenter)x,p2+x},rad headwidth};
      
      If[Head@First@v===List,
        writeobj["rLine",{v}],
        writeobj["List",{v}]
        ];
      
      If[rayboxlines===False&&raytubelines===False,
        
        (* do as triangle *)
        p1=cone[[1,1]];
        p2=cone[[1,2]];
        rad=cone[[2]];
        
        add=Cross[(p1-p2),(eyep-p1)];
        ma=magnitude[add];
        If[ma\[Equal]0,ma=.0001];
        add=(rad add)/ma;
        (* we get scaled later but need to keep linewidth *)
        
        add/=prasp; (* If[rayaspect\[Equal]True] *)
        
        If[raypov===False,
          Write[file,"triangle  "<>surfstore[[Length[surfstore]]]];
          writeNumsFast[p1+add/2];
          writeNumsFast[p2];
          writeNumsFast[p1-add/2];
          writetrans[file];
          ,
          Write[file,"triangle { "];
          writeNums[file,p1+add/2," , "];
          writeNums[file,p2, " , "];
          writeNums[file,p1-add/2];
          writesurfPOV[file];
          writetrans[file];
          Write[file,"}"];
          ];
        ,
        XrCone[Hold[cone]];
        ];
      ++primcount;
      ];













SetAttributes[XrDashing,HoldAll];

XrDashing[vl_]:=
    Module[{inc,v,u,w,rad,add,ma,mu,p1,p2,pt,line,lengthsv,lengthsinc,
        lengthslen,looplimit,midptlen,lastmidptlen,addedmu,toadd,skip},
      
      v=ReleaseHold[vl];
      
      If[NumberQ[rayoverlay]===True,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,rayoverlay,y};
        rayoverlay+=ola;
        ,
        v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
        ];
      
      v=Partition[Flatten[v],3];
      len=Length[v];
      
      If[len<2,Return[]];
      
      If[Length[mathfunstore]>0,
        rad=AbsoluteThickness/.mathfunstore[[Length[mathfunstore]]];
        lengthsv=Dashing/.mathfunstore[[Length[mathfunstore]]];
        ];
      If[\[Not]NumberQ[rad],rad=linewidth];
      lengthslen=Length[lengthsv];
      If[lengthslen===0,lengthsv={.1},lengthsv=lengthsv[[1]]];
      lengthslen=Length[lengthsv];
      inc=0;
      Scan[(
            If[#<0||#>1,
                
                Print["Argument in Dashing[ ",lengthsv,
                  " ] is not a real number between 0 and 1 : gr",grcount,
                  " prim ",primcount];
                inc=1;
                ];
            )&,lengthsv];
      If[inc===1,Return[]];
      lengthsv=lengthsv scenedepth;
      
      If[Plus@@lengthsv===0,
        If[rayboxlines===False&&raytubelines===False,
            XrLine[Hold[v]]
            ,
            If[rayboxlines===True,XrLineBox[Hold[v]],XrLineTube[Hold[v]]]
            ];
        ];
      
      inc=1;
      add={0,0,0};
      addedmu=0;
      p1=v[[1]];
      p2=v[[2]];
      u=p2-p1;
      mu=magnitude[u];
      u=u/mu;
      pt=p1;
      
      (* entry cond *)
      line={{p1}};
      lengthsinc=0;
      toadd=0;
      midptlen=0;
      skip=False;
      looplimit=1000;
      
      (* oops what if lengthsv has 0's *)
      
      (* Print["new line",v]; *)
      
      While[inc<len,
        
        If[--looplimit\[LessEqual]0,
          
          Print["oops: looped 1000 dashing line gr",grcount," prim ",
            primcount];
          Return[];
          ];
        
        (* length intended for next line (or skip) *)
        If[addedmu===0,
          ++lengthsinc;
          If[lengthsinc>lengthslen,lengthsinc=1];
          toadd=lengthsv[[lengthsinc]];
          If[toadd===0,toadd=linewidth];
          (* Print["toadd",toadd," mpt=",midptlen," mu=",mu]; *)
          (* 
            length sofar dashing same line *)
          
          lastmidptlen=midptlen;
          midptlen+=toadd;
          ,
          lastmidptlen=0;
          midptlen=toadd;
          ];
        add=u toadd;
        
        If[midptlen>mu,
          If[inc+1\[GreaterEqual]len,
              (* Print["last"]; *)
              inc=len;pt=Last[v];
              add={0,0,0};toadd=0;
              ,
              (* for this mu only want toadd-=length remaining *)
            
                mu=mu-lastmidptlen;
              (* toadd can be < mu of last line *)
              addedmu=0;
              (* including more pts until long enough toadd *)
              
              While[addedmu===0||(toadd>mu&&--looplimit\[GreaterEqual]0),
                If[inc+1<len,
                    ++inc;
                    addedmu+=mu;
                    toadd-=mu;
                    (* Print["    toadd rem=",toadd," ll=",looplimit]; *)
    
                                    p1=v[[inc]];
                    line=Append[line,p1];
                    pt=p1;
                    p2=v[[inc+1]];
                    u=p2-p1;
                    mu=magnitude[u];
                    u=u/mu;
                    ,
                    (* Print["last"]; *)
                    inc=len;
                    pt=Last[v];
                    add={0,0,0};toadd=0;
                    ];
                ];
              If[inc<len,Continue[]];
              ];
          ];
        
        pt=pt+add;
        line=Append[line,pt];
        skip=Xor[skip,True];
        
        If[skip===True,
          (* Print["line=",line]; *)
          line={line};
          If[rayboxlines===False&&raytubelines===False,
            XrLine[Hold[line]]
            ,
            
            If[rayboxlines===True,XrLineBox[Hold[line]],
              XrLineTube[Hold[line]]]
            ];
          (* ,Print["skip line=",line]; *)
          ];
        
        line={pt};
        addedmu=0;
        toadd=0;
        (* do not reset mu it is the invariant alg needs *)
        ];
      
      ];















writeobj["rRGBColor",obj_]:=Module[{v},
      v=ReleaseHold[obj];
      v[[0]]=Sequence;
      XrRGBColor[v];
      ];



XrAmbient[r_,g_,b_]:=
    Module[{surfspec,r2,g2,b2,v},
      r2=r~N~maxprecision;g2=g~N~maxprecision;b2=b~N~maxprecision;
      surfspec="";
      If[raypov===False,
        If[rayglass===False,
            (* magic - 1 will wash out using std lights *)
            
            writeNums2[surfspec," ambient ",{r2,g2,b2}];
            
            surfstore[[Length[surfstore]]]=
              surfstore[[Length[surfstore]]]<>surfspec;
            ,
            writeNums2[surfspec," glass ambient ",{r2 -.01,g2 -.01,b2-.01}];
            surfstore[[Length[surfstore]]]=surfspec;
            ];
        ];
      If[raypov===True,
        If[rayglass===False,
          writeNums2[surfspec," finish { "];
          writeNums2[surfspec," ambient rgb ",{r2,g2,b2}];
          writeNums2[surfspec," } "];
          ,
          writeNums2[surfspec," finish { "];
          writeNums2[surfspec," phong 0.7 "];
          writeNums2[surfspec," ambient rgb ",{r2,g2,b2}];
          writeNums2[surfspec," } "];
          ];
        surfstore[[Length[surfstore]]]=
          surfstore[[Length[surfstore]]]<>surfspec;
        ];
      ];



XrDiffuse[r_,g_,b_]:=
    Module[{surfspec,r2,g2,b2,v},
      r2=r~N~maxprecision;g2=g~N~maxprecision;b2=b~N~maxprecision;
      surfspec="";
      If[raypov===False,
        If[rayglass===False,
            (* magic - 1 will wash out using std lights *)
            
            writeNums2[surfspec," diffuse ",{r2,g2,b2}];
            
            surfstore[[Length[surfstore]]]=
              surfstore[[Length[surfstore]]]<>surfspec;
            ,
            writeNums2[surfspec," glass ambient ",{r2 .17,g2 .17,b2 .17}];
            surfstore[[Length[surfstore]]]=surfspec;
            ];
        ];
      If[raypov===True,
        If[rayglass===False&&lasttransmit==="",
          writeNums2[surfspec," pigment { color rgb ",{r2,g2,b2}];
          writeNums2[surfspec," } "];
          ,
          writeNums2[surfspec," pigment { color rgb ",{r2,g2,b2}];
          If[rayglass===True,
            writeNums2[surfspec," transmit .4 "];
            lasttransmit=" .4 ";
            ,
            writeNums2[surfspec," transmit "<>lasttransmit];
            ];
          writeNums2[surfspec," } "];
          ];
        surfstore[[Length[surfstore]]]=
          surfstore[[Length[surfstore]]]<>surfspec;
        ];
      ];

XrRGBColor[r_,g_,b_]:=
    (If[raypov===False,
          XrAmbient[r .05,g .05,b .05];XrDiffuse[r .7,g .7,b .7];
          ,
          XrAmbient[r .1,g .1,b .1];XrDiffuse[r,g,b];
          ];
      );



writeobj["rGrayLevel",obj_]:=Module[{v},
      v=ReleaseHold[obj][[1]];
      XrRGBColor[v,v,v]
      ];







HuetoRGB[h_]:=Module[{x,y,a,r,g,b},
    a=h;
    If[a<0,a=-a];
    If[a>1,a=a-Floor[a]];
    a=(2Pi a)/Degree;
    a=N@a;
    If[a<=$MinPrecision,Return[{1,0,0}]];
    If[a>=360,Return[{1,0,0}]];
    y[m_,x_,x1_,b_]:=m(x-x1)+b;
    r[a_]:={1,y[-1,a,120,0]/60,0,0,y[1,a,240,0]/60,1}
          [[Ceiling[a/60]]]//N;
    g[a_]:={y[1,a,0,0]/60,1,1,y[-1,a,240,0]/60,0,0}
          [[Ceiling[a/60]]]//N;
    b[a_]:={0,0,y[1,a,120,0]/60,1,1,y[-1,a,360,0]/60}
          [[Ceiling[a/60]]]//N;
    N@{r[a],g[a],b[a]}
    ]



HuetoRGB[h_,as_,abr_]:=Module[{s=as,br=abr,v1,v2,clamp,x},
    clamp[x_]:=If[x<0,0,If[x>1,1,x]];
    s=clamp[s];br=clamp[br];
    v1=HuetoRGB[h];
    v2=HuetoRGB[h+.5];
    v1=(v1+v2 (1-s))br;
    Map[clamp,v1]
    ]

writeobj["rHue",obj_]:=Module[{v,len,r,g,b},
      v=ReleaseHold[obj];
      {r,g,b}=HuetoRGB[Sequence@@v];
      XrRGBColor[r,g,b];
      ];



XrHue[c_]:=XrHue[c,1,1];

XrHue[h_,as_,abr_]:=Module[{r,g,b},
      {r,g,b}=HuetoRGB[h,as,abr];
      XrRGBColor[r,g,b];
      ];







writeobj["rTextureCoordinateScaling",obj_]:=XrTextureCoordinateScaling[obj];

XrTextureCoordinateScaling[vl_]:=
  Module[{v},
    v=ReleaseHold[vl];
    PrependTo[mathfunstore[[Length[mathfunstore]]],
      TextureCoordinateScaling\[Rule]v];
    ]

writeobj2["rTexture",obj_]:=Module[{v},
      v=ReleaseHold[obj];
      v[[0]]=Sequence;
      XrTexture[v];
      ];

XrTexture[obj_]:=Module[{g,tmpf,box,tcs,str,xi,yi,tmpf2},
      
      str="";
      tmpf="";
      box={};
      If[Length[mathfunstore]>0,
        tcs=TextureCoordinateScaling/.mathfunstore[[Length[mathfunstore]]]];
      
      g=Head[obj];
      If[g===RasterArray||g===Raster,
        g=Dimensions[obj];
        box={0,g[[1]]-1,0,g[[2]]-1};
        ];
      
      If[Head[obj]=!=String,
        g=Import[obj];
        If[g\[NotEqual]Null,
          tmpf=OpenTemporary[][[1]];
          Close[tmpf];
          tmpf=tmpf<>".tiff";
          Export[tmpf,g,"TIFF"]
          ,
          Return[]
          ];
        ];
      
      If[Head[obj]===String,
        If[
            StringMatchQ[obj,"*.rle"]===False&&
              
              StringMatchQ[obj,"*.tiff"]===False,
            tmpf=OpenTemporary[][[1]];
            Close[tmpf];
            tmpf=tmpf<>".tiff";
            Export[tmpf,obj,"TIFF"];
            (* we cant tell if Export bailed *)
            ,
            tmpf=obj;
            ];
        ];
      
      (* tmpf is now a string of file.tiff or file.rle *)
      
      If[raypov===False&&StringMatchQ[tmpf,"*.tiff"]===True,
        tmpf=StringReplace[tmpf,".tiff"\[Rule]""];
        cmd="tifftopnm "<>tmpf<>".tiff 1> "<>tmpf<>".pnm"<>" 2>>/dev/null";
        Run[cmd];
        cmd="pnmtorle "<>tmpf<>".pnm -o "<>tmpf<>".rle"<>" 2>>/dev/null";
        Run[cmd];
        ];
      
      If[raypov===True&&StringMatchQ[tmpf,"*.tiff"]===False,Return[]];
      
      If[tcs===True,
        If[raypov===False,
          cmd="rlebox "<>tmpf<>".rle"<>" 1>"<>tmpf<>".box";
          Run[cmd];
          box=Import[tmpf<>".box","List"];
          ];
        
        If[raypov===True,
          g=Import[tmpf,"TIFF"];
          tmpf2=OpenTemporary[][[1]];
          Close[tmpf2];
          tmpf2=tmpf2<>".xbm";
          Display[tmpf2,cell,"Xbitmap",ImageResolution\[Rule]512];
          g=Import[tmpf2,"Xbitmap"];
          box=Dimensions[g[[1,1]]];
          box={0,box[[2]]-1,0,box[[1]]-1};
          ];
        
        xi=(2.5 box[[2]] 2)/(2630)~N~maxprecision;
        yi=(box[[4]] .15)/(98)~N~maxprecision;
        xi*=sceneAveWidth;
        yi*=sceneAveWidth;
        ];
      
      If[Length[mathfunstore]>0,
        g=Textures/.mathfunstore[[Length[mathfunstore]]]];
      
      If[g=!=Textures&&Head[g]===List,
        PrependTo[mathfunstore[[Length[mathfunstore]]],
            Textures\[Rule]{g[[1]],{tmpf,xi,yi,tcs}}];
        ,
        PrependTo[mathfunstore[[Length[mathfunstore]]],
            Textures\[Rule]{{tmpf,xi,yi,tcs}}];
        ];
      checktexture=True;
      ];



applyTexture[method_,pos_]:=Module[{tmpf,tcs,xi,yi},
      
      If[Length[mathfunstore]>0,
          Scan[
              (
                  {tmpf,xi,yi,tcs}=#;
                  
                  If[raypov===False,
                    Write[file,"\ttexture image"];
                    Write[file,"\t"<>tmpf];
                    Write[file,"\tmap "<>method];
                    writeNums[file,"\t",pos];
                    Write[file,"\t0 0 1"];
                    Write[file,"\t1 0 0"];
                    If[tcs===True,
                      Write[file,"\ttile 1 1"];
                      ,Write[file,"\ttile 0 0"];
                      ];
                    If[tcs===True,writeNums[file,"\tscale ",{xi,1,yi}]];
                    ];
                  
                  If[raypov===True,
                    writeNums[file,"\tscale ",{1,1,2}];
                    Write[file,"\ttexture { "];
                    If[method==="uv",
                      " uv_mapping "
                      ];
                    Write[file,"pigment { "];
                    Write[file,"image_map { "];
                    Write[file,"\ttiff \""<>tmpf<>"\" "];
                    If[tcs===True,Write[file,"\tonce "]];
                    Write[file,"}"];(*close image_map*)
                    
                    writeNums[file,"\trotate ",{30,0,0}];
                    Write[file,"\t} }"];(*close pigment*)
                    
                    If[tcs===True,writeNums[file,"\tscale ",{xi,1,yi/2}]];
                    (*apparently already glued*)
                    \
(*writeNums[file,"\ttranslate ",pos];*)
                    (*Write[file,
                          "}"];*) (*close texture*)
                    ];
                  
                  )&
              ,(Textures/.mathfunstore[[Length[mathfunstore]]])
              ];
          ];
      ];







writeobj2["rSpecularity",obj_]:=Module[{v},
      v=ReleaseHold[obj];
      v[[0]]=Sequence;
      XrSpecularity[v];
      ];

XrSpecularity[s_]:=
    Module[{surfspec,s},
      s=s~N~maxprecision;
      surfspec="";
      If[raypov===False,
        writeNums2[surfspec," specpow ",s];
        ,
        writeNums2[surfspec," finish { "];
        writeNums2[surfspec," phong ",s];
        writeNums2[surfspec," } "];
        ];
      surfstore[[Length[surfstore]]]=
        surfstore[[Length[surfstore]]]<>surfspec;
      ];

XrSpecularity[r_,g_,b_,s_]:=
    Module[{surfspec,r2,g2,b2,s,len},
      v=ReleaseHold[vl];
      r2=r~N~maxprecision;g2=g~N~maxprecision;b2=b~N~maxprecision;
      s=v[[4]]~N~maxprecision;
      surfspec="";
      If[raypov===False,
        writeNums2[surfspec," specular ",{r2,g2,b2}];
        writeNums2[surfspec," specpow ",s];
        ,
        writeNums2[surfspec," finish { "];
        writeNums2[surfspec," phong ",s];
        writeNums2[surfspec," } "];
        ];
      surfstore[[Length[surfstore]]]=
        surfstore[[Length[surfstore]]]<>surfspec;
      ];

XrSpecularity[c_,s_]:=XrSpecularity[c,c,c,s];

XrSpecularity[RGBColor[r_,g_,b_],s_]:=XrSpecularity[r,g,b,s];

writeobj2["rGlow",obj_]:=Module[{v},
      v=ReleaseHold[obj];
      v[[0]]=Sequence;
      XrGlow[v];
      ];



XrGlow[r_,g_,b_]:=
    Module[{camb},If[raypov===False,camb=.01,camb=.5];XrAmbient[r,g,b];
      XrDiffuse[camb,camb,camb];];

XrGlow[c_]:=Module[{camb},If[raypov===False,camb=.01,camb=.5];
      If[c==={},XrAmbient[.01,.01,.01],XrGlow[c,c,c]]
      ];

XrGlow[RGBColor[r_,g_,b_]]:=XrGlow[r,g,b];

writeobj2["rOpacity",obj_]:=Module[{v},
      v=ReleaseHold[obj];
      v[[0]]=Sequence;
      XrOpacity[v];
      ];

XrOpacity[n_]:=
    Module[{surfspec,n2},
      n2=1-n~N~maxprecision;
      surfspec="";
      If[raypov===False,
        writeNums2[surfspec," transp ",n2];
        surfstore[[Length[surfstore]]]=
          surfstore[[Length[surfstore]]]<>surfspec;
        ,
        writeNums2[surfspec," pigment { transmit ",n2," } "];
        surfstore[[Length[surfstore]]]=surfspec;
        lasttransmit=" "<>nsForm2[n2];
        ];
      ];

XrOpacity[n_,r_,g_,b_]:=(XrOpacity[n];XrRGBColor[r,g,b];)







SetAttributes[XrCapForm,HoldAll];

writeobj["rCapForm",obj_]:=XrCapForm[obj];

XrCapForm[vl_]:=
  Module[{v},
    v=ReleaseHold[vl];
    PrependTo[mathfunstore[[Length[mathfunstore]]],CapForm\[Rule]v];
    ]

SetAttributes[XrPointSize,HoldAll];

writeobj["rPointSize",obj_]:=XrPointSize[obj];

XrPointSize[vl_]:=
  Module[{newrad,rad},
    rad=ReleaseHold[vl];
    rad=rad[[1]];
    newrad=rad linewidth/(.001); (* pre-adjusted linewidth *)
    
    newrad/=10~N~maxprecision; (* magic *)
    
    PrependTo[mathfunstore[[Length[mathfunstore]]],PointSize\[Rule]newrad];
    ]

SetAttributes[XrAbsoluteThickness,HoldAll];

writeobj["rAbsoluteThickness",obj_]:=XrAbsoluteThickness[obj];



XrAbsoluteThickness[vl_]:=
  Module[{newrad,rad},
    rad=ReleaseHold[vl];
    rad=rad[[1]];
    newrad=rad ;
    newrad/=30~N~maxprecision; (* magic *)
    
    newrad=rad sceneAveWidth/20~N~maxprecision; (* magic *)
    
    PrependTo[mathfunstore[[Length[mathfunstore]]],
      AbsoluteThickness\[Rule]newrad];
    ]

SetAttributes[XrThickness,HoldAll];

writeobj["rThickness",obj_]:=XrThickness[obj];

XrThickness[vl_]:=
  Module[{newrad,rad},
    rad=ReleaseHold[vl];
    rad=rad[[1]];
    newrad=rad linewidth/(.001 25);
    newrad/=30~N~maxprecision; (* magic *)
    (* newrad *=100; 
      magic for WoldPlot *)
    
    PrependTo[mathfunstore[[Length[mathfunstore]]],
      AbsoluteThickness\[Rule]newrad];
    ]

writeobj["rDashing",obj_]:=XrDashingSet[obj];

XrDashingSet[vl_]:=
  Module[{v},
    v=ReleaseHold[vl];
    PrependTo[mathfunstore[[Length[mathfunstore]]],Dashing\[Rule]v];
    ]







SetAttributes[XrTranslateShape,HoldAll];

writeobj2["rTranslateShape",obj_]:=XrTranslateShape[obj];

XrTranslateShape[obj_]:=
    Module[{transspec,v,o},
      o=ReleaseHold[obj];
      v=o[[2]];
      v=v/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
      (* v=Select[Map[pointInPlotRange,v],ListQ]; *)
      
      v=v~N~maxprecision;
      If[Length[v]>2,
        transspec="";
        writeNums2[transspec,"\ttranslate ",v];
        transstore[[Length[transstore]]]=
          transstore[[Length[transstore]]]<>transspec;
        writeobj["List",Hold[{o[[1]]}]];
        ];
      ];





SetAttributes[XrRotateShape,HoldAll];

writeobj2["rRotateShape",obj_]:=XrRotateShape[obj];

XrRotateShape[obj_]:=
    Module[{transspec,psi,theta,phi,o},
      o=ReleaseHold[obj];
      psi=o[[2]]/Degree;
      theta=o[[3]]/Degree;
      phi=o[[4]]/Degree;
      (* oops this isn't Euler transspec=
                    "\trotate "<>ToString[phi/Degree~N~maxprecision]]<>" "<>
                ToString[theta/Degree~N~maxprecision]<>" "<>
                ToString[psi/Degree~N~maxprecision]]<>"\n"; *)
      (* 
        Euler rot is z, x, z *)
      transspec="";
      If[raypov===False,
        writeNums2[transspec,"\trotate  ",{0,0,1},psi];
        writeNums2[transspec,"\trotate  ",{1,0,0},theta];
        writeNums2[transspec,"\trotate  ",{0,0,1},phi];
        ,
        writeNums2[transspec,"\trotate  ",{0,0,psi}];
        writeNums2[transspec,"\trotate  ",{theta,0,0}];
        writeNums2[transspec,"\trotate  ",{0,0,phi}];
        ];
      applytrans[transspec];
      writeobj["List",Hold[{o[[1]]}]];
      ];



SetAttributes[XrAffineShape,HoldAll];

writeobj["rAffineShape",obj_]:=XrAffineShape[obj];

XrAffineShape[obj_]:=
    Module[{transspec,v,o},
      o=ReleaseHold[obj];
      v=o[[2]]~N~maxprecision;
      If[Length[v]>2,
        transspec="";
        writeNums2[transspec,"\tscale  ",v];
        applytrans[transspec];
        writeobj["List",Hold[{o[[1]]}]];
        ];
      ];







writeobj["rText",obj_]:=XrText[obj];



XrText[obj_]:=
    
    Module[{cell,tmpf,g,box,pts,v,x,xi,y,yi,xc,yc,m,f,inc,dist,angle,str,expr,
        vl,dir,off,txtopts,background,textstyle,formattype,bgsurf},
      
      (* Print["### Text "]; *)
      
      bgsurf="";
      
      (* FIXME ?? v=ReleaseHold[obj][[1]]; *)
      v=ReleaseHold[obj];
      vl={};txtopts={};
      Scan[
        (If[Head[#]===Rule,
                txtopts=txtopts~Append~#;,
                vl=vl~Append~#;];
            )&,v];
      v=vl;
      
      background=Background/.txtopts;
      If[background=!="SolidWhite",
        If[background===Background,
            background=None;
            ,
            If[Length[surfstore]>0,
              pushsurf[surfstore[[Length[surfstore]]]];
              ,surfstore={""}];
            pushsurf[surfstore[[Length[surfstore]]]];
            x=background;
            y=x[[0]];
            x[[0]]=Sequence;
            If[y===RGBColor,XrRGBColor[x]];
            If[y===Hue,XrHue[x]];
            bgsurf=surfstore[[Length[surfstore]]];
            popsurf[];
            ];
        ];
      
      textstyle=TextStyle/.txtopts;
      If[textstyle===TextStyle,textstyle=Automatic];
      formattype=FormatType/.txtopts;
      If[formattype===FormatType,formattype=StandardForm];
      
      If[v==={},Return[]];
      expr=v[[1]];
      If[Length[v]>1,vl=v[[2]],vl={0,0}];
      If[Length[v]>2,off=v[[3]],off={0,0}];
      If[Length[v]>3,dir=v[[4]],dir={1,0}];
      
      If[formattype=!=StandardForm,Abort[];expr=formattype[expr]];
      
      (*
        Print["v = ",v];
        Print["expr = ",expr];
        Print["vl = ",vl];
        Print["off = ",off];
        Print["tops=",txtopts];
        Print["v=",v];
        Print["background=",background];
        Print["textstyle=",textstyle];Print["formattype=",formattype];
        *)
      
      str="";
      (* Print[" Text "]; *)
      
      v=vl/.{x_?NumberQ,y_?NumberQ}\[Rule]{x,0,y};
      v=pointInPlotRange[v];
      If[v===Null,Return[]];
      
      v=v~N~maxprecision;
      (*  i get errors times roman in Display *)
      (* 
        cell=Cell[Text[expr,"Text"]]; *)
      
      If[textstyle===Automatic,
        cell=Cell[Text[expr,"Text"],FontFamily\[Rule]"Courier"];
        ,
        textstyle[[0]]=Sequence;
        cell=Cell[Text[expr,"Text"],textstyle];
        ];
      
      tmpf=OpenTemporary[][[1]];
      Close[tmpf];
      (* an easy way to get rle using standard available;
        package netpbm; works on my box *)
      
      Display[tmpf<>".tiff",cell,"TIFF",ImageResolution\[Rule]512];
      
      If[raypov===False,
        cmd="tifftopnm "<>tmpf<>".tiff 1> "<>tmpf<>".pnm"<>" 2>>/dev/null";
        Run[cmd];
        cmd="pnmtorle "<>tmpf<>".pnm -o "<>tmpf<>".rle"<>" 2>>/dev/null";
        Run[cmd];
        (* need size; note could Display as Xbitmap, export, import, 
          and use Dimensions *)
        
        cmd="rlebox "<>tmpf<>".rle"<>" 1>"<>tmpf<>".box";
        Run[cmd];
        box=Import[tmpf<>".box","List"];
        ];
      
      If[raypov===True,
        Display[tmpf<>".xbm",cell,"Xbitmap",ImageResolution\[Rule]512];
        g=Import[tmpf<>".xbm","Xbitmap"];
        box=Dimensions[g[[1,1]]];
        (* note reversal *)
        box={0,box[[2]]-1,0,box[[1]]-1};
        ];
      
      (* old Print["box = ",box," "]; *)
      (* 
        old pts=rectpoints[v,box[[2]],box[[4]],vp,up]; *)
      (* 
        old pts=rectpoints[v,box[[2]],box[[4]],{0,-1,0},up]; *)
      
      (* its important to treat as normalized for now *)
      
      pts=rectpoints[{0,0,0},1,1,{0,-1,0},up];
      
      (* needs to be a separate gr to translate as gr *)
      ++grcount;
      
      (* magic x scale to make rect given pixel width of text *)
      
      m=1.4321590301661122`*^-8;
      f[x_]:=.00076-m(2630-x); 
      x=f[box[[2]]]~N~maxprecision;
      
      (* z works as const. though note texture is z scaled below *)
      
      y=0.0015;
      
      (* rayshade punts textures; x-z becomes x-y *)
      
      xi=(2.5 box[[2]] 2)/(2630)~N~maxprecision;
      yi=(box[[4]] .15)/(98)~N~maxprecision;
      xc = -1.25 box[[2]] x~N~maxprecision;
      yc = -box[[4]] y/2~N~maxprecision;
      off=IntegerPart@off;
      off ={off[[1]],0,off[[2]]} {xc,0,yc};
      
      xi*=sceneAveWidth;
      yi*=sceneAveWidth;
      xc*=sceneAveWidth;
      yc*=sceneAveWidth;
      off*=sceneAveWidth;
      
      If[dir==={-1,0},xc*=-1;yc*=-1;off*=-1;];
      
      
      
      If[raypov===False,
        
        Write2[objadd,"name gr"<>ToString[grcount]];
        Write2[objadd,"list /* Text */"];
        Write2[objadd,"polygon  "<>surfstore[[Length[surfstore]]]<>bgsurf];
        
        If[background==="SolidWhite"||(background=!=None&&bgsurf===""),
          (* a fallback ; ignores lights *)
          
          Write2[objadd,"\tambient 1 1 1 diffuse 0 0 0"];
          ];
        
        Scan[writeNums2[objadd,#]&,pts];
        
        Write2[objadd,"\ttexture image"];
        Write2[objadd,"\t"<>tmpf<>".rle"];
        If[background===None,
          
          Write2[objadd,
              "\ttextsurf diffuse 0 0 0 ambient .5 .5 .5 transp .5 body 1 1 \
1"];
          ];
        Write2[objadd,"\tmap planar"];
        Write2[objadd,"\t0 0 0"];
        Write2[objadd,"\t0 0 1"];
        Write2[objadd,"\t1 0 0"];
        Write2[objadd,"\ttile 1 1"];
        Write2[objadd,"end /* Text */"];
        
        (* order of these is important *)
        
        writeNums2[str,"\tscale ",{xi,1,yi}];
        
        If[NumberQ[rayoverlay]===True,
          writeNums2[str,"\ttranslate ",{0,rayoverlay,0}];
          rayoverlay+=ola;
          ];
        
        If[dir==={-1,0},
          writeNums2[str,"\trotate ",{0,0,1},180];
          writeNums2[str,"\trotate ",{1,0,0},180];
          ];
        
        writeNums2[str,"\trotate ",{1,0,0},(-1)vpRotAngles[[3]]];
        writeNums2[str,"\ttranslate ",v];
        
        (* start centered then apply off *)
        
        writeNums2[str,"\ttranslate ",{0,0,yc}];
        writeNums2[str,"\ttranslate ",{xc,0,0}];
        writeNums2[str,"\ttranslate ",off];
        
        writeNums2[str,"\trotate ",{0,0,1},vpRotAngles[[1]]];
        
        (* works im unsure which is better;
          If[NumberQ[rayoverlay]===True,
            writeNums2[str,"\ttranslate ",-unit ola];
            rayoverlay+=ola;
            ];
          *)
        
        If[rayaspect===True,writeNums2[str,"\tscale ",1/prasp]];
        
        applytrans[str];
        ];
      
      
      
      If[raypov===True,
        
        Write2[objadd,"#declare gr"<>ToString[grcount]<>" = union { "];
        
        Write2[objadd,"polygon { 5, "];
        Scan[(writeNums2[objadd,#];Write2[objadd,","])&,
          Take[pts,Length[pts]-1]];
        writeNums2[objadd,Last[pts]];
        
        If[background==="SolidWhite",
          
          Write2[objadd,
            "\ttexture{ finish { ambient rgb <1,1,1> } pigment{color rgb \
<0,0,0>}}"]
          ];
        
        If[background=!=None,
          (* writesurfPOV2[objadd]; ignore *)
          If[bgsurf=!="",
              bgsurf="\ttexture { "<>bgsurf<>" } ";
              Write2[objadd,bgsurf]
              ,
              
              Write2[objadd,
                "\ttexture{ finish { ambient rgb <1,1,1> } pigment{color rgb \
<0,0,0>}}"]
              ];
          ];
        
        (* seems 2x here or get 1/2 img but must scale 1/2 later *)
        
        writeNums2[objadd,"\tscale ",{1,1,2}];
        
        Write2[objadd,"\ttexture { "];
        Write2[objadd,"\tpigment { "];
        Write2[objadd,"\timage_map { "];
        Write2[objadd,"\ttiff \""<>tmpf<>".tiff\" "];
        Write2[objadd,"\tonce"];
        If[background===None,
          Write2[objadd,"\tfilter all 1 transmit all 0 "];
          ];
        Write2[objadd,"\t}"];(*close image*)
        
        writeNums2[objadd,"\trotate ",{30,0,0}];
        Write2[objadd,"\t}"];(*close pigment*)
        
        Write2[objadd,"\t}"];(*close texture*)
        
        writeNums2[objadd,"\tscale ",{xi,1,yi}];
        
        If[NumberQ[rayoverlay]===True,
          writeNums2[objadd,"\ttranslate ",{0,rayoverlay,0}];
          rayoverlay+=ola;
          ];
        
        writeNums2[objadd,"\trotate ",{(-1)vpRotAngles[[3]],0,0}];
        
        (* x2 due to scale above ; this fix might still be wrong *)
        
        writeNums2[objadd,"\ttranslate ",{v[[1]],v[[2]],v[[3]]2}];
        
        writeNums2[objadd,"\ttranslate ",{0,0,yc 2}];
        writeNums2[objadd,"\ttranslate ",{xc,0,0}];
        writeNums2[objadd,"\ttranslate ",off];
        
        writeNums2[objadd,"\trotate ",{0,0,vpRotAngles[[1]]}];
        (*
          If[NumberQ[rayoverlay]===True,
              writeNums2[objadd,"\ttranslate ",-unit ola];
              rayoverlay+=ola;
              ];
          *)
        writeNums2[objadd,"\tscale ",{1,1,.5}];
        If[rayaspect===True,writeNums2[str,"\tscale ",1/prasp]];
        Write2[objadd,"}"]; (*close poly*)
        
        Write2[objadd,"}"]; (*close obj*)
        ];
      
      
      
      (* do not ++primcount; *)
      ];













writeobj["rRaster",obj_]:=XrRaster[Raster,obj];

writeobj["rRasterArray",obj_]:=XrRaster[RasterArray,obj];

writeobj2["rRasterClear",obj_]:=XrRasterClear[Raster,obj];

writeobj2["rRasterArrayClear",obj_]:=XrRasterClear[RasterArray,obj];

SetAttributes[XrRaster,HoldAll];

SetAttributes[XrRasterClear,HoldAll];

XrRasterClear[raster_,pobj_]:=(rasterclear=True;XrRaster[raster,pobj];
    rasterclear=False;)

XrRaster[raster_,pobj_]:=
    
    Module[{cell,tmpf,box,pts,v,x,xi,y,yi,xc,yc,xr,yr,xm,ym,xt,yt,m,f,inc,
        dist,angle,obj2,str,bx,by,bz,obj,background},
      
      (* do not use Background *)
      background=None;
      
      (* Print["### Raster "]; *)
      
      obj=ReleaseHold[pobj][[1]];
      (* obj=ReleaseHold[pobj]; *)
      If[obj==={},Return[]];
      
      str="";
      (* Print[" Raster "]; *)
      v={0,0,0};
      (* v=pointInPlotRange[v]; to boxcenter; *)
      
      (*
        If[raster===RasterArray,
            {xr,yr}=Dimensions[obj[[1]]];
            ,{xr,yr}=Dimensions[obj];
            ];
        *)
      {xr,yr}=Dimensions[obj];
      
      tmpf=OpenTemporary[][[1]];
      Close[tmpf];
      (* an easy way to get rle using standard available;
        package netpbm; works on my box *)
      If[raster===RasterArray,
        Display[tmpf<>".tiff",Graphics[RasterArray[obj],AspectRatio\[Rule]1],
            "TIFF",ImageSize\[Rule]{xr,yr}];
        ,
        Display[tmpf<>".tiff",Graphics[Raster[obj],AspectRatio\[Rule]1],
            "TIFF",ImageSize\[Rule]{xr,yr}];
        ];
      
      If[raypov===False,
        cmd="tifftopnm "<>tmpf<>".tiff 1> "<>tmpf<>".pnm"<>" 2>>/dev/null";
        Run[cmd];
        cmd="pnmtorle "<>tmpf<>".pnm -o "<>tmpf<>".rle"<>" 2>>/dev/null";
        Run[cmd];
        (*cmd="rlebox "<>tmpf<>".rle"<>" 1>"<>tmpf<>".box";
          Run[cmd]; box=Import[tmpf<>".box","List"];*)
        ];
      
      (* note reversal *)
      box={0,yr-1,0,xr-1};
      
      (* Print[" box = ",box," "]; *)
      (* 
        pts=rectpoints[v,box[[2]],box[[4]],{0,-1,0},up]; *)
      (* 
        its important to treat as normalized for now *)
      
      pts=rectpoints[{0,0,0},1,1,{0,-1,0},up];
      
      (* needs to be a separate gr to translate as gr *)
      ++grcount;
      
      bx=pr[[1,2]]-pr[[1,1]];
      by=pr[[2,2]]-pr[[2,1]];
      bz=pr[[3,2]]-pr[[3,1]];
      
      
      
      If[raypov===False,
        
        Write2[objadd,"name gr"<>ToString[grcount]];
        Write2[objadd,"list /* Text */"];
        Write2[objadd,"polygon  "<>surfstore[[Length[surfstore]]]];
        
        If[rasterclear===False,
          Write2[objadd,"\tambient 1 1 1 diffuse 0 0 0"];
          ,
          Write2[objadd,"\tdiffuse 0 0 0 ambient 0 0 0 transp 1"];
          ];
        If[rayglass===True,
          Write2[objadd,"\tambient .8 .8 .8 diffuse .1 .1 .1 transp .4"];
          ];
        
        Scan[writeNums2[objadd,#]&,pts];
        
        Write2[objadd,"\ttexture image"];
        Write2[objadd,"\t"<>tmpf<>".rle"];
        If[rasterclear===True,
          Write2[objadd,"\ttextsurf diffuse 1 1 1 ambient 0 0 0 transp .5"];
          ];
        Write2[objadd,"\tmap planar"];
        Write2[objadd,"\t0 0 0"];
        Write2[objadd,"\t0 0 1"];
        Write2[objadd,"\t1 0 0"];
        Write2[objadd,"\ttile 1 1"];
        Write2[objadd,"end /* Text */"];
        
        writeNums2[str,"\tscale ",{bx,1,bz}];
        
        If[NumberQ[rayoverlay]===True,
          writeNums2[str,"\ttranslate ",{0,rayoverlay,0}];
          rayoverlay+=ola;
          ];
        
        applytrans[str];
        ];
      
      
      
      If[raypov===True,
        
        Write2[objadd,"#declare gr"<>ToString[grcount]<>" = union { "];
        Write2[objadd,"polygon { 5, "];
        Scan[(writeNums2[objadd,#];Write2[objadd,","])&,
          Take[pts,Length[pts]-1]];
        writeNums2[objadd,Last[pts]];
        
        writesurfPOV2[objadd];
        writeNums2[objadd,"\tscale ",{1,1,2}];
        Write2[objadd,"\ttexture { "];
        Write2[objadd,"\tpigment { "];
        Write2[objadd,"\timage_map { "];
        Write2[objadd,"\ttiff \""<>tmpf<>".tiff\" "];
        Write2[objadd,"\tonce"];
        If[rasterclear=!=False,
          Write2[objadd,"\tfilter all 1 transmit all 0 "];
          ];
        Write2[objadd,"\t}"];(*close image*)
        
        writeNums2[objadd,"\trotate ",{30,0,0}];
        Write2[objadd,"\t}"];(*close pigment*)
        
        Write2[objadd,"\t}"];(*close texture*)
        
        writeNums2[objadd,"\tscale ",{bx,1,bz/2}];
        
        If[NumberQ[rayoverlay]===True,
          writeNums2[objadd,"\ttranslate ",{0,rayoverlay,0}];
          rayoverlay+=ola;
          ];
        
        Write2[objadd,"}"]; (*close poly*)
        
        Write2[objadd,"}"]; (*close obj*)
        ];
      
      ];
(* do not ++primcount; *)





initVars[]:=Module[{},
      file="";
      pr={{-1,1},{-1,1},{-1,1}};
      vc={0,0,0}; (* ignored *)
      vp={1.3,-2.4,2};
      origvp={1.3,-2.4,2};
      vv={0,0,1};
      (* vp is directional but eyep needs vertex *)
      eyep=vp 1;
      lookp={0,0,0};
      up=vv;
      fov=45;
      rayfovangle=40;
      (* replaced with default in scene setup; *)
      
      lights={{{1.`,0.`,1.`},RGBColor[1.`,0.`,0.`]},{{1.`,1.`,1.`},
            RGBColor[0.`,1.`,0.`]},{{0.`,1.`,1.`},RGBColor[0.`,0.`,1.`]}};
      grcount=1;
      primcount=1;
      subprims=0;
      scenedepth=1;
      sceneAveWidth=1;
      viewdepth=scenedepth;
      box={{-1,-1,-1},{1,-1,-1},{1,1,-1},{-1,1,-1},{-1,-1,1},{1,-1,1},{1,1,
            1},{-1,1,1}};
      boxcenter={0,0,0};
      unit={0.3841851809676021`,-0.70926494947865`,0.5910541245655417`};
      vpnormal={-8.713490501485645`*^-18,-0.6401843996644799`,-0.\
7682212795973759`};
      onnormalplane=vpnormal;
      onnormalplaneunit=vpnormal;
      apparentzoom=1;
      origvp=vp;
      surfstore={""};
      transstore={""};
      diffstore={""};
      mathfunstore={{}};
      linewidth=.001; (* magic *)
      raysurfaces={};
      trans={};
      diff={};
      objadd="";
      txtadd={};
      optlist={};
      (* so far used only in main;
        optlistsmall={};
        fullopts={};
        *)
      rayfastlight=False;
      raygrey=False;
      rayglass=False;
      raypov=False;
      rayaspect=False;
      raytesselate=False;
      rayboxlines=False;
      raytubelines=False;
      raycsg=False;
      rayclipplotrange=False;
      
      rayoverlay=True;
      (* olpr={-.5,.5}; hack dropped; *)
      ola=-.001;
      (* leave 10 for tuck ins *)
      olc=.5+ola 10;
      
      globalsurf="regular";
      vpRotAngles={0,0,0};
      twospace=False;
      prasp={1,1,1};
      newunit=unit;
      worecursion=1;
      polyrecursion=1;
      woonce=False;
      checktexture=False;
      origsymb=.;
      lasttransmit="";
      rasterclear=False;
      
      (* rayshade uses double unsure if used from file but ok;
        is how you compile but C shouldnt balk if too long;
        *)
      maxprecision=19; (* for significand width using N *) 
      ];





newline[file_]:=Write[file,""]

SetAttributes[newline2,HoldFirst];

newline2[file_]:=Write2[file,""]



nForm[r_]:=FortranForm[r~N~maxprecision];

nsForm[r_]:=FortranForm[r~N~maxprecision]//ToString;

nsForm2[r_]:=ToString[FortranForm[r~N~maxprecision]]<>" ";





writevec[vl_]:=If[raypov===False,writeRay[vl],writePOV[vl]]

writeRay[vl_]:=
  nsForm[vl[[1]]]<>" "<>nsForm[vl[[2]]]<>" "<>nsForm[vl[[3]]]<>" "

writePOV[vl_]:=
  "< "<>nsForm[vl[[1]]]<>" , "<>nsForm[vl[[2]]]<>" , "<>nsForm[vl[[3]]]<>" > "



writeNums[file_,vl___]:=
    Module[{inc,s="",v,v2},
      Scan[(
            If[StringQ[#],s=s<>#<>" ",
              If[ListQ[#],
                s=s<>writevec[#]
                ,If[#=!=Null,s=s<>nsForm[#]<>" "]
                ]])&
        ,{vl}];
      Write[file,s]
      ];



writeNumsFast[vl_]:=
    Write[file,nsForm[vl[[1]]]<>" "<>nsForm[vl[[2]]]<>" "<>nsForm[vl[[3]]]];

writeNumsFast6[vl_]:=
    Write[file,
      nsForm[vl[[1]]]<>" "<>nsForm[vl[[2]]]<>" "<>nsForm[vl[[3]]]<>" "<>
        nsForm[vl[[4]]]<>" "<>nsForm[vl[[5]]]<>" "<>nsForm[vl[[6]]]];

writeNumsFastR[r_,vl_]:=
    Write[file,
      nsForm[r]<>" "<>nsForm[vl[[1]]]<>" "<>nsForm[vl[[2]]]<>" "<>
        nsForm[vl[[3]]]];

writeNumsFastV[vl_]:=Module[{s=""},
      s=Map[nsForm2,Flatten[vl]];
      Write[file,StringJoin@s]
      ];

SetAttributes[writeNums2,HoldFirst];

writeNums2[file_,vl___]:=
    Module[{inc,s="",v,v2},
      Scan[(
            If[StringQ[#],s=s<>#<>" ",
              If[ListQ[#],
                s=s<>writevec[#]
                ,If[#=!=Null,s=s<>nsForm[#]<>" "]
                ]])&
        ,{vl}];
      Write2[file,s]
      ];

SetAttributes[Write2,HoldFirst]

Write2[str_Symbol,v___:""]:=
  Module[{},Unhold[str];If[Head[str]\[NotEqual]String,Return[]];
    Unprotect[str];Scan[(str=str<>ToString[#])&,Flatten[{v}]];str=str<>"\n";]













writeOpts[file_]:=If[raypov===False,writeOptsRay[file],writeOptsPOV[file]]

writeOptsRay[file_]:=Module[{},
      
      newline[file];
      Write[file,"/* plot range:"];
      (* to be clear, due to writeNums hack *)
      (* 
        writeNums[file," * ",#]&/@pr; *)
      
      Write[file," * "<>ToString[pr]];
      Write[file,"*/"];
      
      newline[file];
      writeNums[file,"eyep",eyep];
      writeNums[file,"lookp",lookp];
      writeNums[file,"up",up];
      writeNums[file,"fov",fov];
      newline[file];
      
      If[raygrey===False,
        Scan[doLightRay[file,pr,#]&,lights];
        (* part 1 of eyep light *)
        writeNums[file,"light",{1,1,1}];
        ,
        writeNums[file,"light",{1.5,1.5,1.5}];
        ];
      
      (* part 2 of eyep light *)
      If[rayfastlight===True,
        writeNums[file,"\tdirectional",eyep];
        ,
        writeNums[file,"\textended 1.5 ",eyep 1.9];
        ];
      
      (* eyep light is "always there" for stability "safety light";
        curently raygrey raygreyshade assume its there;
        *)
      
      ];

doLightRay[file_,pr_,{{x_,y_,z_},RGBColor[r_,g_,b_]}]:=Module[{scaled,v,pos},
      pos={x,y,z};
      writeNums[file,"light",{r,g,b}];
      (* un-normalize first *)
      v=(pos+boxcenter) scenedepth 1.01;
      If[rayfastlight===True,
        writeNums[file,"\tdirectional",v];
        ,
        writeNums[file,"\textended 1.5 ",v 1.9];
        ];
      ];







doLightRay[file_,pr_,{"ambient",RGBColor[r_,g_,b_]}]:=Module[{scaled,v},
      writeNums[file,"light",{r,g,b}," ambient"];
      ];

doLightRay[file_,pr_,{"Directional",RGBColor[r_,g_,b_],pos_}]:=
    Module[{scaled,v},
      writeNums[file,"light",{r,g,b}];
      v=(pos+boxcenter) scenedepth 1.01;
      writeNums[file,"\tdirectional",v];
      ];

doLightRay[file_,pr_,{"Directional",RGBColor[r_,g_,b_],{pos_,pos2_}}]:=
    doLightRay[file,pr,{"Directional",RGBColor[r,g,b],{pos2-pos1}}];

doLightRay[file_,pr_,{"Point",RGBColor[r_,g_,b_],pos_}]:=Module[{scaled,v},
      writeNums[file,"light",{r,g,b}];
      writeNums[file,"\tpoint ",pos];
      ];



doLightRay[file_,pr_,{"Point",RGBColor[r_,g_,b_],pos_,{a_,b_,c_}}]:=
    Module[{scaled,v,R},
      writeNums[file,"light",{r,g,b}];
      R=magnitude[vp];
      writeNums[file,"\tspot ",pos,boxcenter,1/(c R^2+b R+a)];
      ];

doLightRay[file_,pr_,{"Spot",RGBColor[r_,g_,b_],pos_,aa_}]:=
    Module[{scaled,v},
      writeNums[file,"light",{r,g,b}];
      writeNums[file,"\tspot ",pos,boxcenter,aa];
      ];

doLightRay[file_,pr_,{"Spot",RGBColor[r_,g_,b_],{pos_,pos2_},aa_}]:=
    Module[{scaled,v},
      writeNums[file,"light",{r,g,b}];
      writeNums[file,"\tspot ",pos,pos2,1,aa,aa];
      ];

doLightRay[file_,
      pr_,{"Spot",RGBColor[r_,g_,b_],{pos_,pos2_},{aa_,s_},{a_,b_,c_}}]:=
    Module[{scaled,v,R},
      writeNums[file,"light",{r,g,b}];
      R=magnitude[vp];
      writeNums[file,"\tspot ",pos,pos2,1/(c R^s+b R+a),aa];
      ];



writeOptsPOV[file_]:=Module[{},
      
      newline[file];
      Write[file,"/* plot range:"];
      (* to be clear, due to writeNums hack *)
      (* 
        writeNums[file," * ",#]&/@pr; *)
      
      Write[file," * "<>ToString[pr]];
      Write[file,"*/"];
      
      newline[file];
      Write[file,"camera {"];
      Write[file, "right x"];
      writeNums[file,"up ",up];
      writeNums[file,"location ",eyep];
      writeNums[file,"look_at ",lookp];
      writeNums[file,"sky ",up];
      writeNums[file,"angle ",fov];
      Write[file,"}"];
      
      (* FIXME: despite any variation of the above the;
        POV result is all slanted; fix may not be perfect;
        and likely won't work if parameters above change;
        *)
      (* was missing sky; lucky i didnt need direction;
        Write[file,"  rotate < 0, 0, 25 >"];
        Write[file,"  rotate < 25, 0, 0 >"];
        Write[file,"  rotate < 0, -25, 0 >"];
        *)
      
      If[raygrey===False,
        Scan[doLightPOV[file,pr,#]&,lights];
        ];
      
      (* eyep light *)
      newline[file];
      Write[file,"light_source {"];
      writeNums[file,vp];
      If[raygrey===False,
        Write[file,"color rgb < 1, 1, 1 >"];
        ,
        Write[file,"color rgb < 1.5, 1.5, 1.5 >"];
        ];
      Write[file,"}"];
      ];

doLightPOV[file_,pr_,{pos_,RGBColor[r_,g_,b_]}]:=Module[{scaled,v},
      newline[file];
      Write[file,"light_source {"];
      v=(pos+boxcenter) scenedepth 1.01;
      writeNums[file,v];
      writeNums[file,"color rgb ",{r,g,b}];
      Write[file,"}"];
      ];



doLightPOV[file_,
      pr_,{"Spot",RGBColor[r_,g_,b_],{pos_,pos2_},{aa_,s_},{a_,b_,c_}}]:=
    Module[{scaled,v,R},
      R=magnitude[vp];
      newline[file];
      Write[file,"light_source {"];
      writeNums[file,pos];
      writeNums[file,"color rgb ",{r,g,b}];
      writeNums[file,"spotlight"];
      writeNums[file,"radius ",1];
      writeNums[file,"falloff ",1/(c R^s+b R+a)];
      writeNums[file,"tightness ",aa];
      writeNums[file,"point_at ",pos2];
      Write[file,"}"];
      ];

doLightPOV[file_,pr_,{"Spot",RGBColor[r_,g_,b_],{pos_,pos2_},aa_,{a_,b_,c_}}]:=
    Module[{scaled,v,R},
      R=magnitude[vp];
      newline[file];
      Write[file,"light_source {"];
      writeNums[file,pos];
      writeNums[file,"color rgb ",{r,g,b}];
      writeNums[file,"spotlight"];
      writeNums[file,"radius ",1];
      writeNums[file,"falloff ",aa];
      writeNums[file,"tightness ",aa];
      writeNums[file,"point_at ",pos2];
      Write[file,"}"];
      ];

doLightPOV[file_,pr_,{"Spot",RGBColor[r_,g_,b_],pos_,aa_}]:=
    Module[{scaled,v,R},
      R=magnitude[vp];
      newline[file];
      Write[file,"light_source {"];
      writeNums[file,pos];
      writeNums[file,"color rgb ",{r,g,b}];
      writeNums[file,"spotlight"];
      writeNums[file,"radius ",1];
      writeNums[file,"falloff ",aa];
      writeNums[file,"tightness ",aa];
      writeNums[file,"point_at ",boxcenter];
      Write[file,"}"];
      ];

doLightPOV[file_,pr_,{"Point",RGBColor[r_,g_,b_],pos_,{a_,b_,c_}}]:=
    Module[{scaled,v,R},
      R=magnitude[vp];
      newline[file];
      Write[file,"light_source {"];
      writeNums[file,pos];
      writeNums[file,"color rgb ",{r,g,b}];
      writeNums[file,"spotlight"];
      writeNums[file,"radius ",1];
      writeNums[file,"falloff ",1/(c R^2+b R+a)];
      writeNums[file,"tightness ",10];
      writeNums[file,"point_at ",boxcenter];
      Write[file,"}"];
      ];

doLightPOV[file_,pr_,{"ambient",RGBColor[r_,g_,b_]}]:=Module[{scaled,v},
      newline[file];
      writeNums[file,"global_settings { "];
      writeNums[file,"ambient_light rgb ",{r,g,b}];
      Write[file,"}"];
      ];

doLightPOV[file_,pr_,{"Directional",RGBColor[r_,g_,b_],pos_}]:=
    Module[{scaled,v},
      v=(pos+boxcenter) scenedepth 1.01;
      newline[file];
      Write[file,"light_source {"];
      writeNums[file,v];
      writeNums[file,"color rgb ",{r,g,b}];
      writeNums[file,"spotlight"];
      writeNums[file,"radius ",1];
      writeNums[file,"falloff ",10];
      writeNums[file,"tightness ",10];
      writeNums[file,"point_at ",boxcenter];
      Write[file,"}"];
      ];

doLightPOV[file_,pr_,{"Directional",RGBColor[r_,g_,b_],{pos_,pos2_}}]:=
    doLightPOV[file,pr,{"Directional",RGBColor[r,g,b],{pos2-pos1}}];

doLightRay[file_,pr_,{"Point",RGBColor[r_,g_,b_],pos_}]:=
    
    doLightPOV[file,pr,{pos,RGBColor[r,g,b]}];





prbox[pr_]:={
    (* low counter clockwise *)
    {pr[[1,1]],pr[[2,1]],pr[[3,1]]},
    {pr[[1,2]],pr[[2,1]],pr[[3,1]]},
    {pr[[1,2]],pr[[2,2]],pr[[3,1]]},
    {pr[[1,1]],pr[[2,2]],pr[[3,1]]},
    (* high cc *)
    {pr[[1,1]],pr[[2,1]],pr[[3,2]]},
    {pr[[1,2]],pr[[2,1]],pr[[3,2]]},
    {pr[[1,2]],pr[[2,2]],pr[[3,2]]},
    {pr[[1,1]],pr[[2,2]],pr[[3,2]]}
    }



prboxline[pr_]:=Module[{box},
    box=prbox[pr];
    (* finish *)
    AppendTo[box,box[[5]]];
    box=Insert[box,box[[1]],5];
    (* legs *)
    AppendTo[box,box[[1]]];
    AppendTo[box,box[[6]]];
    AppendTo[box,box[[2]]];
    AppendTo[box,box[[7]]];
    AppendTo[box,box[[3]]];
    AppendTo[box,box[[8]]];
    AppendTo[box,box[[4]]];
    AppendTo[box,box[[9]]];
    {
      Line[Take[box,{1,5}]],
      Line[Take[box,{6,10}]],
      Line[Take[box,{11,12}]],
      Line[Take[box,{13,14}]],
      Line[Take[box,{15,16}]],
      Line[Take[box,{17,18}]]
      }
    ]

prbox2d[pr_]:={
    (* face cc *)
    {pr[[1,1]],pr[[2,1]],pr[[3,1]]},
    {pr[[1,2]],pr[[2,1]],pr[[3,1]]},
    {pr[[1,2]],pr[[2,1]],pr[[3,2]]},
    {pr[[1,1]],pr[[2,1]],pr[[3,2]]}
    }

prboxline2d[pr_]:=Module[{box},
    box=prbox2d[pr];
    (* finish *)
    AppendTo[box,box[[1]]];
    {
      Line[Take[box,{1,2}]],
      Line[Take[box,{2,3}]],
      Line[Take[box,{3,4}]],
      Line[Take[box,{4,5}]]
      }
    ]

pointInPlotRange[v_]:=If[
    v[[1]] >=pr[[1,1]]&&v[[1]]<=pr[[1,2]]
      &&v[[2]] >=pr[[2,1]]&&v[[2]]<=pr[[2,2]]
      &&v[[3]] >=pr[[3,1]]&&v[[3]]<=pr[[3,2]]
    ,v
    ]



rectpoints[low_,w_,h_,norm_,up_]:=Module[{W,H,uw,uh},
      uw=Cross[up,norm];
      uw= uw/magnitude[uw];
      uh=Cross[norm,uw];
      W=w uw;
      H=h uh/magnitude[uh];
      (* counter clockwise *)
      {low,low+W,low+W+H,low+H,low}~N~
        maxprecision
      ];

magnitude[v_,
    w_]:=((v[[1]]-w[[1]])^2+(v[[2]]-w[[2]])^2+(v[[3]]-w[[3]])^2)^(1/2)

magnitude[v_]:=((v[[1]])^2+(v[[2]])^2+(v[[3]])^2)^(1/2)

magnitude2[v_,w_]:=((v[[1]]-w[[1]])^2+(v[[2]]-w[[2]])^2)^(1/2)

magnitude2[v_]:=((v[[1]])^2+(v[[2]])^2)^(1/2)



viewAnglesAtMul[{mul_,A_,targA_}]:=Module[{inc,u,v,w,angle,a,lstep},
    angle=0;
    v=mul unit ;
    lstep=scenedepth/100;
    For[inc=1,inc\[LessEqual]8,++inc,
      w=box[[inc]]-boxcenter;
      u=v-w;
      a= (v.u)/(magnitude[v] magnitude[u]);
      a=a//ArcCos;
      a=2 a/Degree;
      If[Head[a]\[Equal]Complex,a=0];
      If[a>angle,angle=a];
      ];
    If[targA>Abs[angle],lstep=lstep,lstep=-lstep];
    {mul-lstep,angle,targA}~N~maxprecision
    ]



viewPointMulSearch[{mul_,A_,targA_}]:=Module[{inc,last,ret,beforelast},
    last=0;beforelast=0;
    ret=viewAnglesAtMul[{mul,A,targA}];
    For[inc=1,inc<1000,++inc,
      ret=viewAnglesAtMul[ret];
      If[ret[[2]]>(targA-.1)&&ret[[2]]<(targA+.1),Break[]];
      (* if alternates between two close nums; *)
      
      If[ret[[2]]\[Equal]beforelast,Break[]];
      beforelast=last;
      last=ret[[2]];
      ];
    ret[[1]]
    ]











tessfunPoly[vl_List]:=Module[{v,center,len},
    v=vl;
    If[Last[v]=!=First[v],AppendTo[v,First[v]]];
    len=Length[v]; (* in cc order given good poly *)
    
    center=Apply[Plus,v]/len;
    Table[{v[[inc-1]],v[[inc]],center,v[[inc-1]]}
      ,{inc,2,len}]
    ]



tessfunPoly3[vl_List]:=Module[{v,center,len},
    v=vl;
    If[Last[v]=!=First[v],AppendTo[v,First[v]]];
    len=Length[v]; (* in cc order given good poly *)
    
    center=Apply[Plus,v]/len;
    Table[{v[[inc-1]],v[[inc]],center}
      ,{inc,2,len}]
    ]

callwriteobj[obj___]:=Module[{a,h,pos},
      a=Hold[obj];
      h=ToString[a[[1,0]]];
      a[[1,0]]=List;
      pos=StringPosition[h,"`"]; (*strip context*)
      If[pos=!={},
        pos=Last[pos[[2]]];
        h=StringDrop[h,{1,pos}];
        ];
      (*
        h=Symbol[h];
        h=
          h/.{Graphics\[Rule]rGraphics,Graphics3D\[Rule]rGraphics3D,
              Polygon\[Rule]rPolygon,Line\[Rule]rLine,Line2\[Rule]rLine2,
              Point\[Rule]rPoint,Cuboid\[Rule]rCuboid,Sphere\[Rule]rSphere,
              Text\[Rule]rText,Raster\[Rule]rRaster,
              RasterArray\[Rule]rRasterArray};
        (* Print["calling h= ",h];
          Print["with    a= ",a]; *)
        writeobj[h,a];
        *)
      
      (*
        
        h=StringReplace[
            h,{"Graphics"\[Rule]"rGraphics",
              "SurfaceGraphics"\[Rule]"rSurfaceGraphics",
              "Graphics3D"\[Rule]"rGraphics3D","Polygon"\[Rule]"rPolygon",
              "Line"\[Rule]"rLine","Line2"\[Rule]"rLine2",
              "Point"\[Rule]"rPoint","Cuboid"\[Rule]"rCuboid",
              "Sphere"\[Rule]"rSphere","Text"\[Rule]"rText",
              "Raster"\[Rule]"rRaster","RasterArray"\[Rule]"rRasterArray"}];
        
        h=StringReplace[h,"rr"\[Rule]"r"];
        *)
      
      If[h\[NotEqual]"List",
        origsymb=h;
        pos=StringPosition[h,"`"]; (*strip context*)
        If[pos=!={},
          pos=Last[pos[[2]]];
          h=StringDrop[h,{1,pos}];
          ];
        If[StringTake[h,1]=!="r",h="r"<>h];
        ];
      
      (* Print["post /. ",Symbol[h]]; *)
      (* h=Symbol[h]; 
        broken ? never matches fun call ? *)
      
      (*
        Print["calling h= ",h];
        Print["with    a= ",a];
        Print["with   a1= ",a[[1]]];
        Print["with   a2= ",a[[2]]];
        *)
      
      writeobj[h,a];
      ];





boundingbox[pr_]:=Module[{xl,xh,yl,yh,zl,zh,gr0,gr1,gr2,gr3,str},
      
      xl=pr[[1,1]]-linewidth*3;
      yl=pr[[2,1]]-linewidth*3;
      zl=pr[[3,1]]-linewidth*3;
      xh=pr[[1,2]]+linewidth*3;
      yh=pr[[2,2]]+linewidth*3;
      zh=pr[[3,2]]+linewidth*3;
      gr0="gr"<>ToString@grcount;
      gr1="gr"<>ToString@grcount<>ToString@primcount;
      gr2="gr"<>ToString@grcount<>ToString@(primcount+1);
      gr3="gr"<>ToString@grcount<>ToString@(primcount+2);
      If[raypov===False,
        writeNums[file,"name "<>gr1];
        writeNums[file,"list"];
        XrCuboid[{2{xl,yl,zl},2{xh,yh,zh}}];
        writeNums[file,"end"];
        ++primcount;
        writeNums[file,"name "<>gr2];
        writeNums[file,"list"];
        XrCuboid[{{xl,yl,zl},{xh,yh,zh}}];
        writeNums[file,"end"];
        ++primcount;
        writeNums[file,"name "<>gr3];
        writeNums[file,"list"];
        writeNums[file,"difference "];
        writeNums[file,"object "<>gr1<>" object "<>gr2];
        writeNums[file,"end"];
        writeNums[file,"end"];
        str="";
        (* as implemented these hurt more than help *)
        (* 
          writeNums2[str,"difference "]; *)
        (* 
          writeNums2[str,"object "<>gr0<>" object "<>gr3]; *)
        
        writeNums2[str,"object "<>gr3];
        writeNums2[str,"end"];
        applytrans[str];
        ];
      
      If[raypov===True,
        writeNums[file,"#declare "<>gr1<>" = union {"];
        XrCuboid[{2{xl,yl,zl},2{xh,yh,zh}}];
        writeNums[file,"}"];
        ++primcount;
        writeNums[file,"#declare "<>gr2<>" = union {"];
        XrCuboid[{{xl,yl,zl},{xh,yh,zh}}];
        writeNums[file,"}"];
        ++primcount;
        writeNums[file,"#declare "<>gr3<>" = union {"];
        writeNums[file,"difference { "];
        writeNums[file,"object { "<>gr1<>" } "];
        writeNums[file,"object { "<>gr2<>" } "];
        writeNums[file,"}"];
        writeNums[file,"}"];
        str="";
        (* as implemented these hurt more than help *)
        (* 
          writeNums2[str,"difference { "]; *)
        (* 
          writeNums2[str,"object "<>gr0<>" object "<>gr3]; *)
        
        writeNums2[str,"object { "<>gr3<>" } "];
        writeNums2[str,"}"];
        applytrans[str];
        ];
      
      ];



End[]

Protect["rayshade`*"]

EndPackage[]