(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    288329,       6313]*)
(*NotebookOutlinePosition[    308115,       6923]*)
(*  CellTagsIndexPosition[    307724,       6904]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Package info and :: usage Help", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s1"],

Cell[":Title: Rayshade raytrace extension", "Text",
  CellTags->"s1"],

Cell[":Author: John D. Hendrickson", "Text",
  CellTags->"s1"],

Cell[":Summary: makes file.ray and views it", "Text",
  CellTags->"s1"],

Cell[":Context: rayshade`", "Text",
  CellTags->"s1"],

Cell[":Package Version: 2.0", "Text",
  CellTags->"s1"],

Cell["\<\
:Copyright: 

Version 2.0 of rayshade.m is Copyright 2013, John D. Hendrickson, all righs \
reserved.  Permission for use is granted for evaluation purpose.  Please pay \
if you find it useful.  Please do not copy code parts for use in similar \
application.  No express or implied: warranty, fitness for use.  There is \
expressely no permission for government or commercial use without payment.  \
Copies of the work may be retained for storage and must retain this notice.\
\
\>", "Text",
  CellTags->"s1"],

Cell["\<\
:License:

Version 2.0 of rayshade.m is Copyright 2013, John D. Hendrickson, all righs \
reserved.  Permission for use is granted for evaluation purpose.  Please pay \
if you find it useful.  Please do not copy code parts for use in similar \
application.  No express or implied: warranty, fitness for use.  There is \
expressely no permission for government or commercial use without payment.  \
Copies of the work may be retained for storage and must retain this notice.\
\
\>", "Text",
  CellTags->"s1"],

Cell[":History:", "Text",
  CellTags->"s1"],

Cell[":Keywords: rayshade, ray tracing, raytrace, 3D", "Text",
  CellTags->"s1"],

Cell[":Source:  a total re-write by John Hendrickson during 2013.", "Text",
  CellTags->"s1"],

Cell[":Mathematica Version: 4.0", "Text",
  CellTags->"s1"],

Cell["\<\
:Discussion:
\tRayshade and URT are depends (must be installed first) for some features.
\t\tRoman Maeder's SurfaceGraphics3D is suggested but not required.
\tSee: rayshade.note.nb for full discussion.
\tRayshade[file, graphics, opts___]
\tRayshade[file, {gr1, gr2, ...}, opts___]\
\>", "Text",
  CellTags->"s1"],

Cell["\<\
(* BeginPackage[\"rayshade`\",\"DiscreteMath`ComputationalGeometry`\
\",\"Utilities`FilterOptions`\"] *)\
\>", "Text",
  CellTags->"s1"],

Cell["\<\
i hear from math news group DiscreteMath` is now not \
necessary\
\>", "Text"],

Cell["\<\
(* \"DiscreteMath`ComputationalGeometry`\" was for Delaunay \
triangulation; unused *)\
\>", "Text",
  CellTags->"s1"],

Cell[BoxData[
    \(BeginPackage["\<rayshade`\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Rayshade::usage = "\<Rayshade[filename, graphics, ops] writes graphics \
in Rayshade format to file.  see rayshade.note.nb\>"\)], "Input",
  InitializationCell->True,
  CellTags->"s1"],

Cell[BoxData[
    \(RayView::usage = "\<Render and View with xli.\>"\)], "Input",
  InitializationCell->True,
  CellTags->"s1"],

Cell[BoxData[
    \(RayPreView::usage = "\<PreView Render and view with xli.\>"\)], "Input",\

  InitializationCell->True,
  CellTags->"s1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rayshade  Options", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s2"],

Cell["sp gray not grey", "Text",
  CellTags->"s2"],

Cell[BoxData[
    \(Options[
        Rayshade] = {\[IndentingNewLine]RayHeader \[Rule] "\<\>", \
\[IndentingNewLine]RayInformation \[Rule] 
          Automatic, \[IndentingNewLine]RayView \[Rule] 
          False, \[IndentingNewLine]RayPreView \[Rule] 
          False, \[IndentingNewLine]RayShow \[Rule] 
          False, \[IndentingNewLine]RaySurfaces \[Rule] {}, \
\[IndentingNewLine]RayAspect \[Rule] 
          False, \[IndentingNewLine]RayLineWidth \[Rule]  .001, \  (*\ 
          magic\ *) \[IndentingNewLine]RayFovAngle \[Rule] 
          40, \[IndentingNewLine]RayFastLight \[Rule] 
          False, \[IndentingNewLine]RayGrey \[Rule] 
          False, \[IndentingNewLine]RayGreyShade \[Rule] 
          False, \[IndentingNewLine]RayGlass \[Rule] 
          False, \[IndentingNewLine]RayPOV \[Rule] False, \  (*\ 
          not\ finished\ *) \[IndentingNewLine]RayTubeLines \[Rule] 
          False, \[IndentingNewLine]RayBoxLines \[Rule] 
          False, \[IndentingNewLine]RayCsg \[Rule] 
          False, \[IndentingNewLine]RayOverlay \[Rule] 
          True, \[IndentingNewLine]RayClipPlotRange \[Rule] 
          False, \[IndentingNewLine]RayScaled \[Rule] 
          False, \[IndentingNewLine]RayTesselate \[Rule] 
          False, \[IndentingNewLine]RayFooter \[Rule] 
          Automatic\[IndentingNewLine]}\)], "Input",
  InitializationCell->True,
  CellTags->"s2"],

Cell["\<\
raycsg is used in circle / disk only: and interferes with both \
Dashing and circle segments\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rayshade  file", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s3"],

Cell[BoxData[
    \(Begin["\<`Private`\>"]\)], "Input",
  InitializationCell->True,
  CellTags->"s3"],

Cell[BoxData[
    \(Rayshade[filename_String, obj_, opts___] := 
      Module[{file, rayview, raypreview, rayshow, raypov, 
          g}, \[IndentingNewLine]raypov = \(RayPOV /. Flatten[{opts}]\) /. 
            Options[Rayshade]; \[IndentingNewLine]rayshow = \(RayShow /. 
              Flatten[{opts}]\) /. 
            Options[Rayshade]; \[IndentingNewLine]rayview = \(RayView /. 
              Flatten[{opts}]\) /. 
            Options[Rayshade]; \[IndentingNewLine]raypreview = \(RayPreView /. 
              Flatten[{opts}]\) /. 
            Options[Rayshade]; \[IndentingNewLine]file = 
          OpenWrite[filename, FormatType \[Rule] OutputForm, 
            PageWidth \[Rule] Infinity]; \[IndentingNewLine]If[
          file === $Failed, Return[file]]; \[IndentingNewLine]Rayshade[file, 
          Unevaluated[obj], Unevaluated[opts]]; \[IndentingNewLine]Close[
          file]; \[IndentingNewLine]If[
          raypov === False, \[IndentingNewLine]\(If[
              rayview || 
                raypreview, \[IndentingNewLine]cmd = "\<rayshade \>" <> 
                  filename <> "\< -O \>" <> 
                  filename <> "\<.rle -q\>"; \[IndentingNewLine]If[
                raypreview, 
                cmd = cmd <> "\< -R 240 240 -p\>"]; \[IndentingNewLine]cmd = 
                cmd <> "\< 2>>/dev/null\>"; \[IndentingNewLine]Run[
                cmd]; \[IndentingNewLine]If[
                Not[rayshow], \[IndentingNewLine]cmd = "\<xli \>" <> 
                    filename <> "\<.rle 2>>/dev/null &\>"; \
\[IndentingNewLine]Run[
                  cmd];\[IndentingNewLine], \[IndentingNewLine]cmd = \
"\<rletopnm \>" <> filename <> "\<.rle 1> \>" <> 
                    filename <> "\<.pnm 2>>/dev/null\>"; \
\[IndentingNewLine]Run[
                  cmd]; \[IndentingNewLine]cmd = "\<pnmtojpeg --quality 100 \
\>" <> filename <> "\<.pnm 1> \>" <> 
                    filename <> "\<.jpeg 2>>/dev/null\>"; \
\[IndentingNewLine]Run[cmd]; \[IndentingNewLine]g = 
                  Import[filename <> "\<.jpeg\>", "\<JPEG\>"]; \
\[IndentingNewLine]NotebookPut[Show[g], 
                  EvaluationNotebook[]]; \[IndentingNewLine]Return[
                  g];\[IndentingNewLine]];\[IndentingNewLine]];\)\
\[IndentingNewLine], \[IndentingNewLine]\(If[
              rayview || 
                raypreview, \[IndentingNewLine]cmd = "\<povray \>" <> 
                  filename <> "\< -O\>" <> 
                  filename <> "\<.png\>"; \[IndentingNewLine]If[
                raypreview === False, 
                cmd = cmd <> "\< -W512 -H512 \>"]; \[IndentingNewLine]cmd = 
                cmd <> "\< 2>>/dev/null\>"; \[IndentingNewLine]Run[
                cmd]; \[IndentingNewLine]If[
                rayshow === 
                  True, \[IndentingNewLine]cmd = "\<pngtopnm \>" <> 
                    filename <> "\<.png 1> \>" <> 
                    filename <> "\<.pnm 2>>/dev/null\>"; \
\[IndentingNewLine]Run[
                  cmd]; \[IndentingNewLine]cmd = "\<pnmtojpeg --quality 100 \
\>" <> filename <> "\<.pnm 1> \>" <> 
                    filename <> "\<.jpeg 2>>/dev/null\>"; \
\[IndentingNewLine]Run[cmd]; \[IndentingNewLine]g = 
                  Import[filename <> "\<.jpeg\>", "\<JPEG\>"]; \
\[IndentingNewLine]NotebookPut[Show[g], 
                  EvaluationNotebook[]]; \[IndentingNewLine]Return[
                  g];\[IndentingNewLine]];\[IndentingNewLine]];\)\
\[IndentingNewLine]];\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rayshade  main", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s4"],

Cell[BoxData[
    \( (*\ 
      race\ cond\ for\ small\ issue\ need\ symbol\ defined\ for\  \[Equal] \ 
        to\ work; \[IndentingNewLine]BeginPackage["\<SurfaceGraphics3D`\>"]; \
\nSurfaceGraphics3D; \nEndPackage[];\[IndentingNewLine]*) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(version = 2;\)\)], "Input",
  InitializationCell->True,
  CellTags->"s12"],

Cell[BoxData[
    \(\(initVars[];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s12"],

Cell["\<\
Needs here won't enter context path at all (due to placement) thus \
pkg won't work: and I'd rather not hack $ContextPath i'm unsure if it's \
against any policy or throws a warning or has new structure *)\
\>", "Text"],

Cell[BoxData[
    \( (*\ \(Needs["\<SurfaceGraphics3D`\>"];\)\ *) \)], "Input",
  CellTags->"s12"],

Cell[BoxData[
    \(Rayshade[file2_OutputStream, obj_, opts___] := 
      Module[{optsf, opts2, fullopts, optlistsmall, rayinfo, rayview, 
          raypreview, rayheader, rayfooter, raylinewidth, rayfovangle, 
          raygreyshade, rayscaled, aspect, fastlight, grey, glass, pov, 
          tesselate, boxlines, tubelines, csg, clipplotrange, overlay, x, 
          inc, len, grlen, prclip, pr1, pr2, pr3, g, onnormalplane, 
          ilinewidth, mvp, error, v, 
          obj2}, \[IndentingNewLine]\[IndentingNewLine]error = 
          0; \[IndentingNewLine]initVars[]; \
\[IndentingNewLine]rayshade`Private`file = 
          file2; \[IndentingNewLine]ilinewidth = 
          linewidth; \[IndentingNewLine]obj2 = 
          Null; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          PROCESS\ OPTS\ \
*) \[IndentingNewLine]\[IndentingNewLine]Print["\<opts\>"]; \
\[IndentingNewLine]\[IndentingNewLine]dropopt[y_] := 
          Module[{pos}, 
            If[Length[opts2] > 0, \[IndentingNewLine]opts2 = 
                DeleteCases[opts2, 
                  y \[Rule] _]\[IndentingNewLine]]]; \
\[IndentingNewLine]dropopt[y_] := 
          Module[{pos}, \[IndentingNewLine]\(If[
                Length[opts2] > 0 && 
                  Position[opts2, 
                      y \[Rule] _] \[NotEqual] {}, \[IndentingNewLine]pos = \
\(\(Position[opts2, 
                        y \[Rule] _]\)[\([1]\)]\)[\([1]\)]; \
\[IndentingNewLine]opts2 = 
                  Drop[opts2, {pos, 
                      pos}];\[IndentingNewLine]];\)]; \
\[IndentingNewLine]getopt[x_, 
            y_] := \((x = \(y /. optsf\) /. Options[Rayshade]; 
            dropopt[y];)\); \[IndentingNewLine]\[IndentingNewLine] (*\ 
          opts\ are\ mixed, \ 
          get + drop\ so\ only\ Graphics\ opts\ remain\ \
*) \[IndentingNewLine]optsf = Flatten[{opts}]; \[IndentingNewLine]opts2 = 
          optsf; \[IndentingNewLine]\[IndentingNewLine] (*things\ get\ ugly\ \
if\ we\ proceed\ with\ bogus\ opts2\ *) \[IndentingNewLine]For[inc = 1, 
          inc < 1000 && 
            inc \[LessEqual] Length[opts2], \(++inc\), \[IndentingNewLine]If[
            Head[opts2[\([inc]\)]] =!= 
              Rule, \[IndentingNewLine]Print["\<opt is not a rule: \>", 
              opts2[\([inc]\)]]; \[IndentingNewLine]error = 
              1; \[IndentingNewLine]Return[];\[IndentingNewLine]]\
\[IndentingNewLine]]; \[IndentingNewLine]\[IndentingNewLine]getopt[rayinfo, 
          RayInformation]; \[IndentingNewLine]getopt[rayview, 
          RayView]; \[IndentingNewLine]getopt[raypreview, 
          RayPreView]; \[IndentingNewLine]getopt[rayheader, 
          RayHeader]; \[IndentingNewLine]getopt[rayfooter, 
          RayFooter]; \[IndentingNewLine]getopt[raysurfaces, 
          RaySurfaces]; \[IndentingNewLine]getopt[raylinewidth, 
          RayLineWidth]; \[IndentingNewLine]getopt[rayfovangle, 
          RayFovAngle]; \[IndentingNewLine]getopt[fastlight, 
          RayFastLight]; \[IndentingNewLine]getopt[raygreyshade, 
          RayGreyShade]; \[IndentingNewLine]getopt[rayscaled, 
          RayScaled]; \[IndentingNewLine]getopt[glass, 
          RayGlass]; \[IndentingNewLine]getopt[grey, 
          RayGrey]; \[IndentingNewLine]getopt[pov, 
          RayPOV]; \[IndentingNewLine]getopt[tesselate, 
          RayTesselate]; \[IndentingNewLine]getopt[boxlines, 
          RayBoxLines]; \[IndentingNewLine]getopt[tubelines, 
          RayTubeLines]; \[IndentingNewLine]getopt[csg, 
          RayCsg]; \[IndentingNewLine]getopt[overlay, 
          RayOverlay]; \[IndentingNewLine]getopt[clipplotrange, 
          RayClipPlotRange]; \[IndentingNewLine]getopt[aspect, 
          RayAspect]; \[IndentingNewLine]\[IndentingNewLine]rayglass = 
          glass; \[IndentingNewLine]rayfastlight = 
          fastlight; \[IndentingNewLine]raygrey = 
          grey; \[IndentingNewLine]raypov = 
          pov; \[IndentingNewLine]raytesselate = 
          tesselate; \[IndentingNewLine]rayboxlines = 
          boxlines; \[IndentingNewLine]raytubelines = 
          tubelines; \[IndentingNewLine]raycsg = 
          csg; \[IndentingNewLine]rayoverlay = 
          overlay; \[IndentingNewLine]rayclipplotrange = 
          clipplotrange; \[IndentingNewLine]rayaspect = 
          aspect; \[IndentingNewLine]\[IndentingNewLine]If[
          Head@rayoverlay === List, {rayoverlay, ola} = 
            rayoverlay]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          more\ options\ stuff\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
          incase\ Show\ cant\ gather\ more\ opts\ \
*) \[IndentingNewLine]optlistsmall = 
          Flatten[{opts2, 
              Options[Graphics3D]}]; \[IndentingNewLine]fullopts = 
          optlistsmall; \[IndentingNewLine]optlist = 
          optlistsmall; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          get\ full\ opts\ if\ single\ graphic\ *) \[IndentingNewLine]x = 
          True; \[IndentingNewLine]inc = 
          Head[Unevaluated[obj]]; \[IndentingNewLine]If[
          rayinfo === 
              Automatic && \((inc == Graphics3D || inc == Graphics || 
                inc == SurfaceGraphics || \[IndentingNewLine]inc == 
                  SurfaceGraphics3D`SurfaceGraphics3D)\), \[IndentingNewLine] \
(*\ see\ \((1)\)\ *) \[IndentingNewLine]If[
            inc === SurfaceGraphics3D`SurfaceGraphics3D, \
\[IndentingNewLine]\(fullopts = 
                AbsoluteOptions[obj];\)\[IndentingNewLine], \(fullopts = 
                AbsoluteOptions[
                  Unevaluated[
                    obj]];\)\[IndentingNewLine]]; \[IndentingNewLine]optlist \
= Flatten[{opts2, fullopts, Options[Graphics3D]}]; \[IndentingNewLine]x = 
            False;\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
          use\ show\ to\ gather\ fullopts\ for\ total\ scene\ \
*) \[IndentingNewLine]\[IndentingNewLine]If[
          rayinfo === Automatic && x && inc === List, \[IndentingNewLine] (*\ 
            Show\ will\ return\ 2  
              D\ opts\ if\ they\ are\ anywhere; \[IndentingNewLine]if\ 3  
              D\ anywhere\ exclude\ 2  D; \ 
            tries\ as\ simple\ list\ only;\ *) \[IndentingNewLine]\
\[IndentingNewLine]len =. ; 
          x =. ; \[IndentingNewLine]inc = 
            Map[\((Head[#])\) &, Unevaluated[obj]]; \[IndentingNewLine]If[
            Position[inc, Graphics] =!= {}, \[IndentingNewLine]v = 
              Position[inc, 
                Graphics3D | SurfaceGraphics | 
                  SurfaceGraphics3D]; \[IndentingNewLine]If[v =!= {}, 
              len = 1; 
              x = Part[Unevaluated[obj], 
                  Flatten@v]];\[IndentingNewLine]]; \[IndentingNewLine]If[
            len =!= 1, x = Unevaluated[obj]]; \[IndentingNewLine] (*\ 
            superflous\ List\ ie\ {justone}\ changes\ PlotRange\ \
*) \[IndentingNewLine]If[Length[x] \[Equal] 1, 
            x = x[\([1]\)]]; \[IndentingNewLine]\[IndentingNewLine]g =. ; \
\[IndentingNewLine]If[
            x =!= {}, \[IndentingNewLine]g = 
              Show[x, DisplayFunction \[Rule] 
                  Identity]; \[IndentingNewLine]fullopts = 
              AbsoluteOptions[g]; \[IndentingNewLine]optlist = 
              Flatten[{opts2, fullopts, 
                  Options[
                    Graphics3D]}];\[IndentingNewLine], \[IndentingNewLine]x = 
              Select[Flatten[{Unevaluated[obj]}], \((Head[#] == 
                      Graphics)\) &]; \[IndentingNewLine]If[
              x =!= {}, \[IndentingNewLine]g = 
                Show[obj, 
                  DisplayFunction \[Rule] 
                    Identity]; \[IndentingNewLine]fullopts = 
                AbsoluteOptions[g]; \[IndentingNewLine]optlist = 
                Flatten[{opts2, fullopts, 
                    Options[
                      Graphics3D]}];\[IndentingNewLine]];\[IndentingNewLine]];\
 \[IndentingNewLine]If[Head[g] === Show, 
            Print["\<tried to show non graphics err\>"]; 
            Return[Unevaluated[obj]];]; \[IndentingNewLine]g =. ; x =. ; 
          inc =. ; 
          len =. ;\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]rayshade`Private`pointInPlotRange[v_] := 
          If[\[IndentingNewLine]v[\([1]\)]\  >= pr[\([1, 1]\)] && 
              v[\([1]\)] <= pr[\([1, 2]\)]\[IndentingNewLine] && 
              v[\([2]\)]\  >= pr[\([2, 1]\)] && 
              v[\([2]\)] <= pr[\([2, 2]\)]\[IndentingNewLine] && 
              v[\([3]\)]\  >= pr[\([3, 1]\)] && 
              v[\([3]\)] <= pr[\([3, 2]\)]\[IndentingNewLine], 
            v\[IndentingNewLine]]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          oops\ mm\ ver; \ 
          look\ "\<both\>"\ places\ incase\ not\ defined;\ \
*) \[IndentingNewLine]x = 
          Global`PlotRangeClipping /. optlist; \[IndentingNewLine]If[
          x === False, 
          rayshade`Private`pointInPlotRange[vv_] := 
            vv]; \[IndentingNewLine]x = 
          System`PlotRangeClipping /. optlist; \[IndentingNewLine]If[
          x === False, 
          rayshade`Private`pointInPlotRange[vv_] := 
            vv]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          SCENE\ SETUP\ CALCULATIONS\ *) \[IndentingNewLine]\
\[IndentingNewLine]Print["\<scene\>"]; \
\[IndentingNewLine]\[IndentingNewLine]fov = 
          45; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          see\ basic\ scene\ setup\ notes\ *) \[IndentingNewLine]x = 
          PlotRange /. optlist; \[IndentingNewLine]If[x =!= Automatic, 
          pr = x]; \[IndentingNewLine] (*\ 
          vc\ handled\ after\ scene\ boxcenter\ *) \[IndentingNewLine]vc = 
          ViewCenter /. opts2; \[IndentingNewLine]If[vc == ViewCenter, 
          vc = {0, 0, 0}]; \[IndentingNewLine]vv = 
          ViewVertical /. optlist; \[IndentingNewLine]lights = 
          LightSources /. optlist; \[IndentingNewLine]x = 
          ViewPoint /. optlist; \[IndentingNewLine]If[x =!= ViewPoint, 
          vp = x]; \[IndentingNewLine]x = 
          ViewAngle /. optlist; \[IndentingNewLine]If[NumberQ[x], 
          fov = x]; \[IndentingNewLine]x = 
          ViewVector /. optlist; \[IndentingNewLine]If[
          ListQ[x], {vp, lookp} = 
            x]; \[IndentingNewLine]\[IndentingNewLine]up = 
          vv; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          provide\ more\ colorful\ default; \ 
          any\ change\ overrides\ *) \[IndentingNewLine]If[
          lights === Automatic || 
            N[Chop[lights]] === 
              N[Chop[{{{1.`, 0.`, 1.`}, 
                      RGBColor[1.`, 0.`, 0.`]}, {{1.`, 1.`, 1.`}, 
                      RGBColor[0.`, 1.`, 0.`]}, {{0.`, 1.`, 1.`}, 
                      RGBColor[0.`, 0.`, 
                        1.`]}}]]\[IndentingNewLine], \
\[IndentingNewLine]\(lights = {{{1, \(-1\), \(-1\)}, 
                  RGBColor[1, 0, 0]}, {{1, 1, 1}, 
                  RGBColor[0, 1, 0]}, {{\(-1\), \(-1\), 1}, 
                  RGBColor[0, 0, 
                    1]}};\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 2  D\ test; \ 
          some\ funs\ like\ Line\ can\ do\ 2  D\ or\ 3  
            D\ so\ try; \[IndentingNewLine]unlike\ Graphics3D\ we\ have\ no\ \
use\ for\ Prolog; \[IndentingNewLine]so\ it' 
            s\ a\ start\ at\ being\ like\ Show[];\[IndentingNewLine]\
*) \[IndentingNewLine]If[
          Length[pr] \[Equal] 2, \[IndentingNewLine]twospace = 
            True; \[IndentingNewLine] (*\ 
            vp\ will\ be\ up\ in\ front\ after\ calcs\ *) \[IndentingNewLine] \
(*\ the\ 3  
              D\ default\ dir\ is\ valid\ its\ preferencial\ \
*) \[IndentingNewLine]x = ViewPoint /. optsf; \[IndentingNewLine]If[
            x == ViewPoint, vp = {0, \(-1\), 0}]; \[IndentingNewLine]pr = 
            Insert[pr, {\(- .01\),  .01}, 
              2]; \[IndentingNewLine] (*\ \(If\)\([\)\(NumberQ[rayoverlay] === 
                True, \ 
              see\ further\ below\)\(\ \)*) \[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
          un - noticeable\ but\ skirts\ div/0\ checking; \ 
          mostly\ for\ 2  D;\ *) \[IndentingNewLine]If[
          vp[\([1]\)] \[Equal] 0, 
          vp[\([1]\)] =  .0001]; \[IndentingNewLine]If[
          vp[\([2]\)] \[Equal] 0, 
          vp[\([2]\)] =  .0001]; \[IndentingNewLine]If[
          vp[\([3]\)] \[Equal] 0, 
          vp[\([3]\)] =  .0001]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          SIDE\ TRACK\ FOR\ ASPECT; \[IndentingNewLine]\[IndentingNewLine]we\ \
sqash\ graphics\ to\ fit\ in\ a\ square\ by\ simply\ using; "\<scale x y z\>"\
\ upon\ each\ gr . \ 
              code\ wise\ the\ viewpoint\ changes; \[IndentingNewLine]and\ in\
\ a\ few\ places\ the\ squash\ effect\ must\ be\ considered; \
\[IndentingNewLine]good\ news\ is\ aspect\ is\ acheived\ without\ altering\ \
or; \ size\ interpreting\ the\ shapes\ of\ data; \[IndentingNewLine]\
\[IndentingNewLine]for\ aspect\ we\ calculate\ the\ below\ twice . \ \ w/
              new\ pr\ to\ find; \[IndentingNewLine]vp\ of\ squashed\ box\ \
then\ again\ w/orig\ pr\ so\ all\ else; \[IndentingNewLine]is\ un - 
            affected\ \((the\ scene\ before\ "\<scale\>"\ is\ reached)\);\
\[IndentingNewLine]*) \[IndentingNewLine]\[IndentingNewLine]If[
          rayaspect === True, \[IndentingNewLine]{pr1, pr2, pr3} = 
            nbaspect[]~N~
              maxprecision; \[IndentingNewLine] (*\ \(Print["\< will scale \
\>", {pr1, pr2, pr3}, "\< \>"];\)\ *) \[IndentingNewLine]\  (*\ 
            we\ need\ vp\ closer\ but\ not\ the\ rest; \ 
            see\ below;\ *) \[IndentingNewLine]x = 
            pr; \[IndentingNewLine]prasp = {pr1, pr2, 
              pr3}; \[IndentingNewLine]pr = 
            pr\ prasp;\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]box = 
          prbox[pr]; \[IndentingNewLine]boxcenter = \((box[\([7]\)] + 
                box[\([1]\)])\)/2; \[IndentingNewLine]\[IndentingNewLine]v = 
          Map[NumberQ, 
            Flatten[{pr, vc, vv, vp, lookp, up, fov}]]; \[IndentingNewLine]If[
          Cases[v, 
              False] =!= {}, \[IndentingNewLine]Print["\<init err: some init \
vars became non-numbers.\>"]; \
\[IndentingNewLine]Return[];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]scenedepth = \(Table[
                magnitude[boxcenter, box[\([i]\)]], {i, 1, 8}] // Sort\) // 
            Last; \[IndentingNewLine] (*\ dependancy; \ 
          do\ before\  += \ 
            boxcenter\ else\ its\ vp - boxcenter\ *) \[IndentingNewLine]mvp = 
          magnitude[vp]; \[IndentingNewLine]unit = 
          vp/mvp; \[IndentingNewLine] (*\ see\ notes\ ; \ 
          a\ vec\ in\ normal\ plane; \ 
          div/0\ issue\ too\ *) \[IndentingNewLine]onnormalplane = \(-1\) {0, 
              vp[\([2]\)]/vp[\([1]\)], 
              vp[\([3]\)]/vp[\([1]\)]}; \[IndentingNewLine]vpnormal = 
          Cross[onnormalplane, vp]; \  (*\ 
          unused\ *) \[IndentingNewLine]vpnormal = 
          vpnormal/magnitude[vpnormal]; \  (*\ 
          unused\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
          want\ fov \[Equal] 45; \ 
          scale\ view\ pt\ \((in\ /\ 
                out)\)\ so\ it\ is; \[IndentingNewLine]done\ by\ searching; \ 
          begin\ with\ n \[Equal] 
            1.5\ scenedepth; \[IndentingNewLine]need\ angle\ between\ final\ \
vp\ and\ all\ box\ corners;\[IndentingNewLine]*) \[IndentingNewLine] (*\ 
          2.5\ is\ magic\  - \ 
            should\ put\ us\ closer\ to\ 45\ to\ start; \[IndentingNewLine]ok\
\ if\ rough\ guess\ but\ avoid\ 1000\ iteration\ quit\ \
*) \[IndentingNewLine]origvp = vp; \[IndentingNewLine]vp = 
          unit\ viewPointMulSearch[{2.5\ scenedepth, 0, 
                rayfovangle}]; \[IndentingNewLine]\[IndentingNewLine]If[
          rayaspect === True, \  (*\ 
            unused\ *) \[IndentingNewLine]viewdepth = 
            magnitude[vp]; \[IndentingNewLine]linewidth = 
            1.2\ ilinewidth\ viewdepth\ \((viewdepth)\)^\((1/
                    4)\);\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
          make\ the\ scene' s\ origin\ boxcenter\ *) \[IndentingNewLine]vp\  += 
          boxcenter; \[IndentingNewLine]lookp = 
          boxcenter; \[IndentingNewLine]\[IndentingNewLine] (*\ ignored; \ 
          usu . \ {0.5, 0.5, 
                0.5}\ for\ any\ PlotRange;\ *) \[IndentingNewLine]vc = 
          ViewCenter /. opts2; \[IndentingNewLine] (*\ 
          FIXME : \ 
            lookp\ and\ vc\ are\ not\ used\ in\ calcs; \
\[IndentingNewLine]unsure\ if\ use\ of\ overriden\ vc\ will\ help\ or\ hurt\ \
cals;\ *) \[IndentingNewLine]If[vc == ViewCenter, vc = boxcenter, 
          lookp = vc]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          for\ aspect; \ 
          recalc\ with\ orig\ pr\ using\ found/
              new\ vp\ *) \[IndentingNewLine]If[
          rayaspect === True, \[IndentingNewLine]pr = 
            x; \[IndentingNewLine]box = 
            prbox[pr]; \[IndentingNewLine]boxcenter = \((box[\([7]\)] + 
                  box[\([1]\)])\)/
              2; \[IndentingNewLine]scenedepth = \(Table[
                  magnitude[boxcenter, box[\([i]\)]], {i, 1, 8}] // Sort\) // 
              Last; \[IndentingNewLine]vp\  -= 
            boxcenter; \[IndentingNewLine]mvp = 
            magnitude[vp]; \[IndentingNewLine]unit = 
            vp/mvp; \[IndentingNewLine]onnormalplane = \(-1\) {0, 
                vp[\([2]\)]/vp[\([1]\)], 
                vp[\([3]\)]/
                  vp[\([1]\)]}; \[IndentingNewLine]onnormalplaneunit = 
            onnormalplane/
              magnitude[onnormalplane]; \[IndentingNewLine]vpnormal = 
            Cross[onnormalplane, vp]; \[IndentingNewLine]vpnormal = 
            vpnormal/magnitude[vpnormal]; \[IndentingNewLine] (*\ 
            what\ vp\ would\ have\ been\ without\ pr\ change\ \
*) \[IndentingNewLine] (*\ 
            use\ of\ origvp\ corrects\ Point\ size\ for\ aspect\ \
*) \[IndentingNewLine]origvp = 
            unit\ viewPointMulSearch[{2.5\ scenedepth, 0, 
                  rayfovangle}]; \[IndentingNewLine] (*\ 
            ie . \ box\ was\ wide\ aspect\ made\ it\ square\ mvp\ now\ \
smaller\ *) \[IndentingNewLine]apparentzoom = 
            magnitude[origvp]/magnitude[vp]; \[IndentingNewLine]origvp\  += 
            boxcenter; \[IndentingNewLine]vp\  += 
            boxcenter; \ \[IndentingNewLine] (*\ 
            we\ don' 
              t\ have\ or\ need\ unit\ of\ origvp\ *) \[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
          allows\ opts\ to\ override\ *) \[IndentingNewLine]x = 
          ViewPoint /. opts2; \[IndentingNewLine]If[x =!= ViewPoint, 
          vp = x]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          un - noticeable\ but\ rids\ div/
                0\ problem\ *) \[IndentingNewLine]If[vp[\([1]\)] \[Equal] 0, 
          vp[\([1]\)] =  .0001]; \[IndentingNewLine]If[
          vp[\([2]\)] \[Equal] 0, 
          vp[\([2]\)] =  .0001]; \[IndentingNewLine]If[
          vp[\([3]\)] \[Equal] 0, 
          vp[\([3]\)] =  .0001]; \[IndentingNewLine]\[IndentingNewLine]eyep = 
          vp; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          as\ opposed\ to\ unit\ altered\ from\ aspect\ \
*) \[IndentingNewLine] (*\ \(newunit = \((eyep - lookp)\)/
                magnitude[\((eyep - 
                      lookp)\)];\)\ \
*) \[IndentingNewLine]\[IndentingNewLine]viewdepth = 
          magnitude[
            vp]; \[IndentingNewLine]scenedepth = \(Table[
                magnitude[boxcenter, box[\([i]\)]], {i, 1, 8}] // Sort\) // 
            Last; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          unsure\ how\ mm\ chooses\ font\ size\ \
*) \[IndentingNewLine]sceneAveWidth = \((\((2\ scenedepth^2)\)^\((1/2)\))\)/
            2; \[IndentingNewLine]sceneAveWidth = 
          scenedepth/2; \[IndentingNewLine]\[IndentingNewLine]If[
          rayaspect === False, \  (*\ unused\ *) \[IndentingNewLine] (*\ 
            1.2\ is\ magic\ , \ 
            as\ well\ as\ 1/4\ dropoff\ *) \[IndentingNewLine]\(linewidth = 
              1.2\ ilinewidth\ viewdepth\ \((viewdepth)\)^\((1/
                      4)\);\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
          width\ adjustment\ far\ from\ perfect\ but\ ok\ for\ starters; \
\[IndentingNewLine]see\ note\ about\ Lines; \ 
          not\ better\ after\ vp\ is\ adjusted;\ *) \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
          less\ good\ maybe\ but\ better\ avoids\ hazards\ \
*) \[IndentingNewLine]m = 0.004025335676887489`; \[IndentingNewLine]flw[x_] = 
          200 + m \((x - 
                  49685.6210916414)\); \
\[IndentingNewLine]\[IndentingNewLine]linewidth = 
          flw[magnitude[vp]]; \[IndentingNewLine]\[IndentingNewLine]x = 
          RayLineWidth /. optsf; \[IndentingNewLine]If[x =!= RayLineWidth, 
          linewidth = 
            x]; \[IndentingNewLine]\[IndentingNewLine] \
(*\[IndentingNewLine]if\ an\ object\ is\ at\ origin\ facing\ {0, \(-1\), 
              0}\ then\ the\ two\ rotations\ to\ make\ it\ face\ ViewPoint\ \
are\ a\ z\ rotation\ and\ x\ rotation, \ 
          in\ any\ order\[IndentingNewLine]*) \[IndentingNewLine]\
\[IndentingNewLine]v = {unit[\([1]\)], unit[\([2]\)], 0}; \  (*\ 
          rest\ on\ x - y\ *) \[IndentingNewLine]x = 
          magnitude[v]; \[IndentingNewLine]If[x === 0, 
          x =  .001]; \[IndentingNewLine]vpRotAngles = \
{\[IndentingNewLine]ArcCos[\(({0, \(-1\), 0} . v)\)/x]/
                Degree, \[IndentingNewLine]0, \[IndentingNewLine]ArcCos[\((v \
. unit)\)/x]\ /Degree\[IndentingNewLine]}~N~
            maxprecision; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          these\ werent\ given\ but\ overlay\ needs\ something\ to\ go\ on\ \
*) \[IndentingNewLine] (*\ add\ depth\ for\ poly\ overlays; \ 
          overlays*
            linewidth\ needed; \[IndentingNewLine]nothing\ above\ should\ be\ \
effected\ if\ lesser\ pr\ inserted;\ *) \[IndentingNewLine]If[
          twospace === 
            True, \[IndentingNewLine]\(If[
              rayoverlay =!= False, \[IndentingNewLine]{pr1, pr2, pr3} = 
                nbaspect3[pr]; \[IndentingNewLine]If[
                pr1 > pr3, \[IndentingNewLine]pr[\([2]\)] = 
                  pr[\([3]\)], \[IndentingNewLine]pr[\([2]\)] = 
                  pr[\([1]\)]\[IndentingNewLine]];\[IndentingNewLine]];\)\
\[IndentingNewLine]]; \[IndentingNewLine]If[
          rayoverlay === True, \[IndentingNewLine] (*\ 
            auto\ default\ to\ allow\ lines\ to\ not\ \(\(coincide\)\(\ \)\(?\
\)\)\ *) \[IndentingNewLine] (*\ 
            but\ unfortunately\ way\ too\ deep\ for\ many\ common\ plots\ \
*) \[IndentingNewLine] (*\ 
            and\ it\ was\ the\ point\ to\ make\ the\ at\ first\ hands\ free\ \
*) \[IndentingNewLine] (*\ \(ola = \(-linewidth\)\ 1.01;\)\ \
*) \[IndentingNewLine] (*\ 
            this\ actually\ worked\ for\ bar\ chart\ and\ world\ plot\ wow\ \
*) \[IndentingNewLine]ola = \(-linewidth\)/100 // N; \  (*\ 
            step\ by\ *) \[IndentingNewLine]olc = 
            pr[\([2, 2]\)] + ola\ 10 // N; \  (*\ 
            starting\ offset\ *) \[IndentingNewLine]rayoverlay = 
            olc;\[IndentingNewLine]]; \[IndentingNewLine] (*\ \(overlay\ can\ \
cause\ points\ dropped\ but\ see\ rayopts;\)\ *) \[IndentingNewLine]\
\[IndentingNewLine] (*\[IndentingNewLine]Print["\<eyep=\>", 
            eyep]; \[IndentingNewLine]Print["\<lookp=\>", 
            lookp]; \[IndentingNewLine]Print["\<vc=\>", 
            vc]; \[IndentingNewLine]Print["\<boxcenter=\>", 
            boxcenter]; \[IndentingNewLine]Print["\<pr=\>", 
            pr]; \[IndentingNewLine]Print["\<ro=\>", 
            rayoverlay]; \[IndentingNewLine]Print["\<ola=\>", 
            ola];\[IndentingNewLine]*) \[IndentingNewLine]\[IndentingNewLine]\
If[rayscaled === 
            True, \[IndentingNewLine]\(Module[{x, y, z, x2, y2, 
                z2}, \[IndentingNewLine]{pr1, pr2, pr3} = 
                nbaspect3[pr]; \[IndentingNewLine]obj2 = 
                obj /. Scaled[{x_, 
                        y_}] \[Rule] \[IndentingNewLine]{pr[\([1, 
                            1]\)] + \((x\ pr1)\), 
                      pr[\([2, 
                            1]\)] + \((y\ pr2)\)}; \[IndentingNewLine]obj2 = 
                obj2 /. Scaled[{x_, y_, 
                        z_}] \[Rule] \[IndentingNewLine]{pr[\([1, 
                            1]\)] + \((x\ pr1)\), 
                      pr[\([2, 1]\)] + \((y\ pr2)\), 
                      pr[\([3, 
                            1]\)] + \((z\ pr3)\)}; \[IndentingNewLine]obj2 = 
                obj2 /. Offset[{x___}] \[Rule] {x}; \[IndentingNewLine]obj2 = 
                obj2 /. Offset[{x_, y_}, {x2_, 
                        y2_}] \[Rule] \[IndentingNewLine]{x + x2, 
                      y + y2}; \[IndentingNewLine]obj2 = 
                obj2 /. Offset[{x_, y_, z_}, {x2_, y2_, 
                        z2_}] \[Rule] \[IndentingNewLine]{x + x2, y + y2, 
                      z + z2};\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
          BEGIN\ BUILDING\ FILE . 
              RAY\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
          write\ to\ header\ string\ for\ opts\ that\ ask\ \
*) \[IndentingNewLine]\[IndentingNewLine]If[
          raypov === False, \[IndentingNewLine]Write2[
            rayheader, "\<maxdepth 15\>"]; \[IndentingNewLine]globalsurf = \
"\<\>"; \[IndentingNewLine]If[
            raygreyshade \[Equal] True, \[IndentingNewLine]Write2[
              rayheader, "\<surface greyshade ambient .2 .2 .2 diffuse 0 0 0 \
transp .4\>"]; \[IndentingNewLine]newline2[
              rayheader]; \[IndentingNewLine]Write2[
              rayheader, "\<applysurf greyshade\>"]; \
\[IndentingNewLine]globalsurf = "\<greyshade\>";\[IndentingNewLine]]; \
\[IndentingNewLine]If[
            rayglass === 
              True, \[IndentingNewLine]v = "\<surface glass ambient .025 .05 \
.05 diffuse .1 .2 .2 specular .5 .7 .7 transp\[IndentingNewLine].4 specpow 60 \
reflect .3\>"; \[IndentingNewLine]Write2[rayheader, 
              v]; \[IndentingNewLine]newline2[
              rayheader]; \[IndentingNewLine]Write2[
              rayheader, "\<applysurf glass\>"]; \
\[IndentingNewLine]globalsurf = "\<glass\>";\[IndentingNewLine]]; \
\[IndentingNewLine]If[
            globalsurf === "\<\>" && 
              raygrey === 
                False, \[IndentingNewLine]v = "\<surface  regular  ambient \
.05 .05 .05  diffuse .5 .5 .5 specular .5 .5 .5  specpow 60 reflect .2\>"; \
\[IndentingNewLine]Write2[rayheader, v]; \[IndentingNewLine]newline2[
              rayheader]; \[IndentingNewLine]Write2[
              rayheader, "\<applysurf regular\>"]; \
\[IndentingNewLine]globalsurf = "\<regular\>";\[IndentingNewLine]];\
\[IndentingNewLine]]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          see\ rayshade - 
            notes . nb\ about\ rayshade\ v . \ 
                pov\ glass\ *) \[IndentingNewLine]\[IndentingNewLine]If[
          raypov === 
            True, \[IndentingNewLine]globalsurf = "\<\>"; \
\[IndentingNewLine]If[
            raygreyshade === True, \[IndentingNewLine]Write2[
              rayheader, "\<#default {\ntexture { pigment {color rgb <0,0,0> \
transmit .4}\nfinish {ambient .2}\n}\n}\>"]; \[IndentingNewLine]globalsurf = \
"\<greyshade\>";\[IndentingNewLine]]; \[IndentingNewLine]If[
            rayglass === True, \[IndentingNewLine]Write2[
              rayheader, "\<#default {\ntexture { pigment {color rgb <.5, .7, \
.7> transmit .4}\nfinish {phong 0.7 ambient 0.3}\n}\n}\>"]; \
\[IndentingNewLine]globalsurf = "\<glass\>";\[IndentingNewLine]]; \
\[IndentingNewLine]If[
            globalsurf === "\<\>" && 
              raygrey === False, \[IndentingNewLine]Write2[
              rayheader, "\<#default {\ntexture { pigment {color rgb <.8, .8, \
.8>} }}\>"]; \[IndentingNewLine]globalsurf = \
"\<regular\>";\[IndentingNewLine]]; \[IndentingNewLine]If[
            raygrey === 
              True, \[IndentingNewLine]\(Write2[
                rayheader, "\<#default {\ntexture { pigment {color rgb <.8, \
.8, .8>} }}\>"];\)\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[rayheader =!= "\<\>", 
          Write[file, rayheader]]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          
          generate\ and\ write\ object\ definitions\ to\ file\ \
*) \[IndentingNewLine]\[IndentingNewLine]Print["\<callwriteobj\>"]; \
\[IndentingNewLine]If[
          obj2 === Null, \[IndentingNewLine]callwriteobj[
            obj], \[IndentingNewLine]callwriteobj[
            obj2]\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]Print["\<box\>"]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
          generate\ and\ write\ bounding\ box\ lines\ object\ \
*) \[IndentingNewLine]\[IndentingNewLine]If[
          Boxed /. optlistsmall, \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]If[
            twospace === 
              False, \[IndentingNewLine]\(g = 
                Graphics3D[
                  prboxline[
                    pr]];\)\[IndentingNewLine], \[IndentingNewLine] (*\ 
              do\ 2  d\ since\ 3  
                d\ normals\ may\ well\ be\ too\ tight\ \
*) \[IndentingNewLine]g = 
              Graphics3D[
                prboxline2d[
                  pr]]\[IndentingNewLine]]; \[IndentingNewLine]woonce = 
            False; \[IndentingNewLine]writeobj["\<List\>", 
            Hold[{g}]]; \[IndentingNewLine]g =. ;\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]Print["\<lights etc\>"]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ instanciate; \ 
          write\ "\<object gr1 <surf> <trans>\>"\ *) \[IndentingNewLine]\
\[IndentingNewLine] (*\ \(clip\ list\ is\ ie\ diff\ diff\ diff\ a\ b\ end\ c\ \
end\ d\ end;\)\ *) \[IndentingNewLine] (*\ \(the\ b\ end\ c\ end\ d\ end\ \
should\ be\ last\ in\ trans[\([]\)];\)\ *) \[IndentingNewLine]\
\[IndentingNewLine]For[inc = 1, 
          inc < grcount, \(++inc\), \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            instanciate\ named\ object\ *) \[IndentingNewLine]\
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\[IndentingNewLine]If[
              Length[trans] \[GreaterEqual] inc && rayclipplotrange === True && 
                StringMatchQ[
                  trans[\([inc]\)], "\<object *\>"], \
\[IndentingNewLine]\(Scan[\[IndentingNewLine]Write[
                    file, "\<difference\>"], \
\[IndentingNewLine]StringPosition[
                    trans[\([inc]\)], "\<object \>"]\[IndentingNewLine]];\)\
\[IndentingNewLine]]; \[IndentingNewLine]\[IndentingNewLine]Write[
              file, "\<object gr\>" <> 
                ToString[inc]]; \[IndentingNewLine] (*\ 
              any\ surface\ specifications\ from\ opts___\ \
*) \[IndentingNewLine]If[
              Length[raysurfaces] \[GreaterEqual] inc && 
                raysurfaces[\([inc]\)] \[NotEqual] "\<\>", \
\[IndentingNewLine]Write[
                file, "\<surface gr\>" <> 
                  ToString[inc]]; \[IndentingNewLine]Write[file, 
                raysurfaces[\([inc]\)]];\[IndentingNewLine]]; \
\[IndentingNewLine] (*\ any\ stored\ translations\ ie, \ 
              Text\ uses\ *) \[IndentingNewLine]x = 
              False; \[IndentingNewLine]If[
              Length[trans] \[GreaterEqual] inc && 
                trans[\([inc]\)] \[NotEqual] "\<\>", \[IndentingNewLine]\(If[
                  rayclipplotrange === True && 
                    StringMatchQ[
                      trans[\([inc]\)], "\<object *\>"], \
\[IndentingNewLine]\(If[
                      rayaspect === True, \[IndentingNewLine]v = 
                        First@\(First@
                            StringPosition[
                              trans[\([inc]\)], "\<object\>"]\); \
\[IndentingNewLine]v = v - 1; \[IndentingNewLine]Write[file, 
                        StringTake[trans[\([inc]\)], 
                          v]]; \[IndentingNewLine]writeNums[
                        file, "\<\tscale\>", prasp]; \[IndentingNewLine]Write[
                        file, StringDrop[trans[\([inc]\)], 
                          v]]; \[IndentingNewLine]x = 
                        True;\[IndentingNewLine], \[IndentingNewLine]\(Write[
                          file, trans[\([inc]\)]];\)\[IndentingNewLine]];\)\
\[IndentingNewLine], \[IndentingNewLine]\(Write[file, 
                      trans[\([inc]\)]];\)\[IndentingNewLine]];\)\
\[IndentingNewLine]]; \[IndentingNewLine] (*\ 
              stored\ apsect\ ratio\ squash\ last\ *) \[IndentingNewLine]If[
              rayaspect === True && x === False, 
              writeNums[file, "\<\tscale\>", 
                prasp]];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
            instanciate\ named\ object\ for\ pov\ *) \[IndentingNewLine]\
\[IndentingNewLine]If[
            raypov === True, \[IndentingNewLine]\[IndentingNewLine]If[
              Length[trans] \[GreaterEqual] inc && rayclipplotrange === True && 
                StringMatchQ[
                  trans[\([inc]\)], "\<object *\>"], \
\[IndentingNewLine]\(Scan[\[IndentingNewLine]Write[
                    file, "\<difference { \>"], \
\[IndentingNewLine]StringPosition[
                    trans[\([inc]\)], "\<object \>"]\[IndentingNewLine]];\)\
\[IndentingNewLine]]; \[IndentingNewLine]\[IndentingNewLine]Write[
              file, "\<object { gr\>" <> 
                ToString[inc] <> "\< \>"]; \[IndentingNewLine]If[
              Length[raysurfaces] \[GreaterEqual] inc && 
                raysurfaces[\([inc]\)] \[NotEqual] "\<\>", \
\[IndentingNewLine]Write[
                file, "\<texture gr\>" <> 
                  ToString[inc] <> "\< {\>"]; \[IndentingNewLine]Write[file, 
                raysurfaces[\([inc]\)]]; \[IndentingNewLine]Write[
                file, "\<}\>"]; \  (*close\ texture*) \[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]x = False; \[IndentingNewLine]If[
              Length[trans] \[GreaterEqual] inc && 
                trans[\([inc]\)] \[NotEqual] "\<\>", \[IndentingNewLine]\(If[
                  rayclipplotrange === True && 
                    StringMatchQ[
                      trans[\([inc]\)], "\<object *\>"], \[IndentingNewLine]x \
= True; \[IndentingNewLine]v = 
                    First@\(First@
                        StringPosition[
                          trans[\([inc]\)], "\<object\>"]\); \
\[IndentingNewLine]v = v - 1; \[IndentingNewLine]Write[file, 
                    StringTake[trans[\([inc]\)], v]]; \[IndentingNewLine]If[
                    rayaspect === True, 
                    writeNums[file, "\<\tscale\>", 
                      prasp]]; \[IndentingNewLine]Write[
                    file, "\<}\>"]; \  (*close\ \
obj*) \[IndentingNewLine]Write[file, 
                    StringDrop[trans[\([inc]\)], 
                      v]];\[IndentingNewLine], \[IndentingNewLine]\(Write[
                      file, trans[\([inc]\)]];\)\[IndentingNewLine]];\)\
\[IndentingNewLine]]; \[IndentingNewLine] (*\ 
              stored\ apsect\ ratio\ squash\ last\ *) \[IndentingNewLine]If[
              rayaspect === True && x === False, 
              writeNums[file, "\<\tscale\>", prasp]]; \[IndentingNewLine]If[
              x === False, 
              Write[file, "\<}\>"]]; \  (*close\ obj*) \[IndentingNewLine]\
\[IndentingNewLine]];\[IndentingNewLine]\[IndentingNewLine]]; \  (*\ 
          end\ for\ each\ gr\ loop\ *) \[IndentingNewLine]\[IndentingNewLine] \
(*\ write\ scene\ options\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ \(If\
\)\([\)\(\(rayinfo === 
              Automatic\)\(,\)\)\(\ \)*) \[IndentingNewLine] (*\ \(Print["\< \
scene opts \>"];\)\ *) \[IndentingNewLine]writeOpts[
          file]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          write\ footer\ *) \[IndentingNewLine]\[IndentingNewLine]If[
          rayfooter === Automatic, \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]Write[
              file, "\<background 1 1 1\>"], \[IndentingNewLine]\(Write[
                file, "\<background { color rgb < 1 , 1, 1 > }\>"];\)\
\[IndentingNewLine]]\[IndentingNewLine], \[IndentingNewLine]\(Write[file, 
              rayfooter];\)\[IndentingNewLine]]; \[IndentingNewLine] (*\ 
          x = Background /. fullopts; \ 
          not\ for\ scene\ if\ in\ opts; \[IndentingNewLine]writeNums[file, 
            Apply[List, 
              x]];\ *) \[IndentingNewLine]\[IndentingNewLine]newline[
          file]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
          DONE\  - \ 
            file . ray\ is\ complete\ \
*) \[IndentingNewLine]Print["\<done.\>"]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
          for\ view\ file\ could\ be\ piped\ to\ rayshade\ \
*) \[IndentingNewLine]file\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s4"],

Cell["\<\
----------------------------
(1) as i said in SurfaceGraphics3D.m  I consider it a fixme using
\tinc==SurfaceGraphics3D`SurfaceGraphics3D
\tnot just  inc== SurfaceGraphics3D
i'm unsure why it's needed since SurfaceGraphics3D` should exist already - \
yet System`Graphics3D isn't needed.  With loading of sg3d.m done: i'm double \
unsure why.  This is what I was expecting:
\tex:
\tIn[]:=x=5;
\tIn[]:=Begin[\"a`p`\"];
\tIn[]:=x
\tOut[]=5
\tIn[]:=End[];\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["nbaspect[opts___]", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s5"],

Cell["\<\
(* optionally calculate scale to fixup aspect to be close to \
\"normal\" as to notebook display; a box *)\
\>", "Text",
  CellTags->"s5"],

Cell["(* aspect ratio squasher / scaling; likely broken; *)", "Text",
  CellTags->"s5"],

Cell[BoxData[
    \(nbaspect3[pr_] := 
      Module[{fun, pr1, pr2, pr3, len}, \[IndentingNewLine] (*\ 
          not\ 4\ 3  D; \ 
          pr = AspectRatio /. fullopts;\ *) \[IndentingNewLine]len = 
          Length[pr]; \[IndentingNewLine]If[len \[LessEqual] 0, 
          Return[{}]]; \[IndentingNewLine]If[
          Sign[pr[\([1, 1]\)]] === Sign[pr[\([1, 2]\)]], fun = Subtract, 
          fun = Plus]; \[IndentingNewLine]pr1 = 
          Abs[Abs[pr[\([1, 1]\)]]~fun~
              Abs[pr[\([1, 2]\)]]]; \[IndentingNewLine]If[len \[LessEqual] 1, 
          Return[{pr1}]]; \[IndentingNewLine]\[IndentingNewLine]If[
          Sign[pr[\([2, 1]\)]] === Sign[pr[\([2, 2]\)]], fun = Subtract, 
          fun = Plus]; \[IndentingNewLine]pr2 = 
          Abs[Abs[pr[\([2, 1]\)]]~fun~
              Abs[pr[\([2, 2]\)]]]; \[IndentingNewLine]If[len \[LessEqual] 2, 
          Return[{pr1, pr2}]]; \[IndentingNewLine]\[IndentingNewLine]If[
          Sign[pr[\([3, 1]\)]] === Sign[pr[\([3, 2]\)]], fun = Subtract, 
          fun = Plus]; \[IndentingNewLine]pr3 = 
          Abs[Abs[pr[\([3, 1]\)]]~fun~
              Abs[pr[\([3, 2]\)]]]; \[IndentingNewLine]{pr1, pr2, 
          pr3}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s5"],

Cell[BoxData[
    \(nbaspect[] := 
      Module[{fun, len, pr1, pr2, pr3}, \[IndentingNewLine]{pr1, pr2, pr3} = 
          nbaspect3[pr]; \  (*rayshade`pr*) \[IndentingNewLine] (*\ 
          scale\ large\ two\ down\ as\ fractions\ to\ smallest\ of\ x - 
            y\ *) \[IndentingNewLine]If[
          twospace === 
            False, \[IndentingNewLine]len = \((pr1 + pr2 + pr3)\)/
              3; \[IndentingNewLine]pr1 = len/pr1; pr2 = len/pr2; 
          pr3 = len/pr3;\[IndentingNewLine]]; \[IndentingNewLine]If[
          twospace === True, \[IndentingNewLine]pr2 = 
            1; \[IndentingNewLine]len = \((pr1 + pr3)\)/
              2; \[IndentingNewLine]pr1 = len/pr1; 
          pr3 = len/pr3;\[IndentingNewLine]]; \[IndentingNewLine]{pr1, pr2, 
          pr3}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s5"],

Cell[BoxData[
    \( (*\ 
      pinching\ instead\ of\ square\ boxing\ breaks\ too\ easy; \
\[IndentingNewLine]If[
        pr1 > pr2, \[IndentingNewLine]pr1 = \((pr2/
              pr1)\); \[IndentingNewLine]If[pr2 > pr3, pr3 = pr2/pr3, 
          pr3 = pr2/pr3]; \[IndentingNewLine]pr2 = 
          1;\[IndentingNewLine], \[IndentingNewLine]pr2 = \((pr1/
              pr2)\); \[IndentingNewLine]If[pr2 > pr3, pr3 = pr2/pr3, 
          pr3 = pr2/pr3]; \[IndentingNewLine]pr1 = 
          1;\[IndentingNewLine]];\[IndentingNewLine]*) \)], "Input",
  CellTags->"s5"]
}, Closed]],

Cell[CellGroupData[{

Cell["writeobj  graphic lists", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s6"],

Cell[BoxData[
    \(\(SetAttributes[writeobj, HoldRest];\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["discuss", "Subsubsection"],

Cell["\<\
(* wrapper functions for:
\t~ Graphics3D~
\t~ SurfaceGraphics ~
\t~ Graphics ~
\tand _List which runs through resulting graphics lists
missing (these are 2D Graphics):
\t~ DensityGraphics ~
\t~ ContourGraphics ~
\t~ WorlPlot ~

See code notes on why (1) is used instead of more familiar (2) to get to \
handler with args.
\t(1) writeobj[ \"Polygon\", Hold[ args_ ] ]
\t(2) writeobj[ g_Polygon[ {pt_, pt_, ...}.. ] ]
However any writeobj2 use (2).  Also some surf / trans funs make themselves \
like writeobj2 (same thing).

It's faster to get to XrLine that way and smarter not to multiply evaluate \
Line to do so.  But the real reason has to do with context (which?) and mm \
versional needs (ie, Opacity may or may not be defined).
*)\
\>", "Text",
  CellTags->"s6"],

Cell[BoxData[
    \(\(SetAttributes[callwriteobj, HoldAll];\)\)], "Input"],

Cell[BoxData[
    \( (*\ \(SetAttributes[writeobj2, HoldRest];\)\ *) \)], "Input"],

Cell[BoxData[
    \( (*\ \(writeobj2[file_, g : rSurfaceGraphics[obj___]] := 
          writeobj[file, Graphics3D[obj]];\)\ *) \)], "Input",
  CellTags->"s6"],

Cell[BoxData[
    \( (*\ should\ evaluate\ and\ then\ match\ obj_List\ *) \)], "Input"],

Cell["\<\
sometimes SurfaceGraphics[[2]] is opts even after Graphics3D ; note \
opts not passed to writeobj\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["SurfaceGraphics", "Subsubsection"],

Cell[BoxData[
    \(\(writeobj["\<rSurfaceGraphics\>", vl_] := 
        Module[{g}, \[IndentingNewLine] (*\ \(Print["\<### SurfaceGraphics \
\>"];\)\ *) \[IndentingNewLine]If[
            Length[vl[\([1]\)]] > 
              1, \[IndentingNewLine]g = \(Graphics3D[
                  SurfaceGraphics[vl[\([1, 1]\)], 
                    vl[\([1, 
                        2]\)]]]\)[\([1]\)], \[IndentingNewLine]g = \
\(Graphics3D[SurfaceGraphics[
                    vl[\([1, 
                        1]\)]]]\)[\([1]\)]\[IndentingNewLine]]; \
\[IndentingNewLine]writeobj["\<List\>", 
            Hold[{g}]]\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics3D", "Subsubsection"],

Cell[BoxData[
    \(\(writeobj["\<rGraphics3D\>", 
          oblist_] := \[IndentingNewLine]Module[{primcount2}, \
\[IndentingNewLine]primcount2 = primcount; \[IndentingNewLine]subprims = 
            0; \[IndentingNewLine]objadd = "\<\>"; \[IndentingNewLine]\
\[IndentingNewLine]newline[file]; \[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]Write[
              file, "\<name gr\>" <> 
                ToString[grcount]]; \[IndentingNewLine]Write[
              file, "\<list /* Graphics3D */\>"];\[IndentingNewLine], \
\[IndentingNewLine]\(Write[
                file, "\<#declare gr\>" <> 
                  ToString[
                    grcount] <> "\< = union {\>"];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ \(writeobj[file, 
                Chop[N[oblist]]];\)\ *) \[IndentingNewLine] (*\ \
\(Scan[\((Print["\<obj is: \>", #]; writeobj[file, \ #])\) &, 
                oblist];\)\ *) \[IndentingNewLine]\[IndentingNewLine]If[
            Head[oblist[\([1, 1]\)]] === 
              List, \[IndentingNewLine]\(writeobj["\<List\>", \ 
                Unevaluated[
                  oblist[\([1]\)]]];\)\[IndentingNewLine], \
\[IndentingNewLine]\(writeobj["\<List\>", \ 
                Unevaluated[
                  oblist]];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            primcount2 == primcount, \[IndentingNewLine] (*\ empty\ error; \ 
              use\ normal\ not\ usually\ visible\ *) \[IndentingNewLine]\(If[
                raypov === False, \[IndentingNewLine]Write[
                  file, "\<disc  .00001  0 0 0   0 0 \
1\>"]\[IndentingNewLine], \[IndentingNewLine]Write[
                  file, "\<disc  { <0, 0, 0> <0, 0, 1>  .00001 } \>"]\
\[IndentingNewLine]];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\(Write[
                file, "\<end  /* Graphics3D */\>"];\)\[IndentingNewLine], \
\[IndentingNewLine]\(Write[
                file, "\<}\>"];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[rayclipplotrange === True, 
            boundingbox[pr]]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            if\ any\ are\ sublis\ with\ names\ \ *) \[IndentingNewLine]If[
            objadd \[NotEqual] "\<\>", Write[file, objadd]; 
            primcount += 
              subprims]; \[IndentingNewLine]objadd = "\<\>"; \
\[IndentingNewLine]subprims = 
            0; \[IndentingNewLine]\(++grcount\);\[IndentingNewLine]];\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"s6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics", "Subsubsection"],

Cell[BoxData[
    \( (*\ \(writeobj[file_, 
          g : rGraphics[oblist_, opts_List: {}]]\)\(:=\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<rGraphics\>", 
          oblist_] := \[IndentingNewLine]Module[{primcount2}, \
\[IndentingNewLine]primcount2 = primcount; \[IndentingNewLine]subprims = 
            0; \[IndentingNewLine]objadd = "\<\>"; \[IndentingNewLine]\
\[IndentingNewLine]newline[file]; \[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]Write[
              file, "\<name gr\>" <> 
                ToString[grcount]]; \[IndentingNewLine]Write[
              file, "\<list /* Graphics3D */\>"];\[IndentingNewLine], \
\[IndentingNewLine]\(Write[
                file, "\<#declare gr\>" <> 
                  ToString[
                    grcount] <> "\< = union {\>"];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ \(writeobj[file, 
                Chop[N[oblist]]];\)\ *) \[IndentingNewLine] (*\ \
\(Scan[\((Print["\<obj is: \>", #]; writeobj[file, \ #])\) &, 
                oblist];\)\ *) \[IndentingNewLine]\[IndentingNewLine]If[
            Head[oblist[\([1, 1]\)]] === 
              List, \[IndentingNewLine]\(writeobj["\<List\>", \ 
                Unevaluated[
                  oblist[\([1]\)]]];\)\[IndentingNewLine], \
\[IndentingNewLine]\(writeobj["\<List\>", \ 
                Unevaluated[
                  oblist]];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            primcount2 == primcount, \[IndentingNewLine] (*\ empty\ error; \ 
              use\ normal\ not\ usually\ visible\ *) \[IndentingNewLine]\(If[
                raypov === False, \[IndentingNewLine]Write[
                  file, "\<disc  .00001  0 0 0   0 0 \
1\>"]\[IndentingNewLine], \[IndentingNewLine]Write[
                  file, "\<disc  { <0, 0, 0> <0, 0, 1>  .00001 } \>"]\
\[IndentingNewLine]];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\(Write[
                file, "\<end  /* Graphics3D */\>"];\)\[IndentingNewLine], \
\[IndentingNewLine]\(Write[
                file, "\<}\>"];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[rayclipplotrange === True, 
            boundingbox[
              pr]]; \[IndentingNewLine]\[IndentingNewLine] (*\ \
\(Print["\<exiting objadd = \>", 
                objadd];\)\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
            if\ any\ are\ sublis\ with\ names\ \ *) \[IndentingNewLine]If[
            objadd \[NotEqual] "\<\>", Write[file, objadd]; 
            primcount += 
              subprims]; \[IndentingNewLine]objadd = "\<\>"; \
\[IndentingNewLine]subprims = 
            0; \[IndentingNewLine]\(++grcount\);\[IndentingNewLine]];\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"s6"]
}, Closed]],

Cell[CellGroupData[{

Cell["dispatch", "Subsubsection"],

Cell["\<\
(*
\tDISPATCH  LISTS
\t\trecurse Lists to find things to draw
\t\thandles a good variety of nested graphics even if partly unknown
*)\
\>", "Text",
  CellTags->"s6"],

Cell[BoxData[
    \(\(writeobj[List, \ obj_] := writeobj["\<List\>", obj];\)\)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<List\>", \ obj_] := 
        Module[{inc, len, lprimcount, lobj, a, h, 
            pos}, \[IndentingNewLine]\[IndentingNewLine] \
(*\[IndentingNewLine]Print["\<LIST h= \>", 
              List]; \[IndentingNewLine]Print["\<LIST l= \>", 
              Length[obj]]; \[IndentingNewLine]Print["\<LIST a= \>", 
              obj];\[IndentingNewLine]*) \[IndentingNewLine]\
\[IndentingNewLine]If[worecursion \[GreaterEqual] $RecursionLimit, 
            Return[]]; \[IndentingNewLine]\(++worecursion\); \
\[IndentingNewLine]\[IndentingNewLine] (*\ \(Print["\< + \>"];\)\ \
*) \[IndentingNewLine] (*\ pushsurf["\<\>"]; \ 
            pushmathfun[{}];\ *) \[IndentingNewLine] (*\ 
            instead\ make\ things\ from\ outer\ group\ we' 
              re\ in; \[IndentingNewLine]current\ in\ this\ group\ \
*) \[IndentingNewLine]\[IndentingNewLine]If[
            Length[surfstore] > 
              0, \[IndentingNewLine]\(pushsurf[
                surfstore[\([Length[surfstore]]\)]];\)\[IndentingNewLine], 
            surfstore = {"\<\>"}]; \[IndentingNewLine]\[IndentingNewLine]If[
            Length[transstore] > 
              0, \[IndentingNewLine]\(pushtrans[
                transstore[\([Length[transstore]]\)]];\)\[IndentingNewLine], 
            transstore = {"\<\>"}]; \[IndentingNewLine]\[IndentingNewLine]If[
            Length[mathfunstore] > 0, \[IndentingNewLine]pushmathfun[
              mathfunstore[\([Length[
                    mathfunstore]]\)]]; \[IndentingNewLine]If[\((Textures /. 
                    mathfunstore[\([Length[mathfunstore]]\)])\) =!= 
                Textures, \[IndentingNewLine]\(checktexture = 
                  True;\)\[IndentingNewLine]];\[IndentingNewLine], 
            mathfunstore = {{}}\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]Scan[\[IndentingNewLine]\((\[IndentingNewLine]a = 
                  Hold[#]; \[IndentingNewLine]h = 
                  ToString[a[\([1, 0]\)]]; \[IndentingNewLine]a[\([1, 0]\)] = 
                  List; \[IndentingNewLine]\[IndentingNewLine]If[
                  Symbol[h] === List, \[IndentingNewLine]pushsurf[
                    surfstore[\([Length[
                          surfstore]]\)]]; \[IndentingNewLine]pushtrans[
                    transstore[\([Length[
                          transstore]]\)]]; \[IndentingNewLine]pushmathfun[
                    mathfunstore[\([Length[
                          mathfunstore]]\)]]; \
\[IndentingNewLine]writeobj["\<List\>", 
                    a]; \[IndentingNewLine]popsurf[]; \
\[IndentingNewLine]popmathfun[]; \[IndentingNewLine]lasttransmit = "\<\>"; \
\[IndentingNewLine]checktexture = 
                    False;\[IndentingNewLine], \[IndentingNewLine]origsymb = 
                    h; \[IndentingNewLine]pos = 
                    StringPosition[
                      h, "\<`\>"]; \  (*strip\ \
context*) \[IndentingNewLine]If[
                    pos =!= {}, \[IndentingNewLine]pos = 
                      Last[pos[\([2]\)]]; \[IndentingNewLine]h = 
                      StringDrop[
                        h, {1, 
                          pos}];\[IndentingNewLine]]; \[IndentingNewLine]If[
                    StringTake[h, 1] =!= "\<r\>", 
                    h = "\<r\>" <> h]; \[IndentingNewLine]writeobj[h, 
                    a];\[IndentingNewLine]];\[IndentingNewLine]\
\[IndentingNewLine])\) &\[IndentingNewLine], 
            obj[\([1]\)]\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ \(Print["\<obj: \>", #];\)\ *) \[IndentingNewLine] \
(*\ \(Print["\<color: \>", 
                surfstore[\([Length[
                      surfstore]]\)]];\)\ *) \[IndentingNewLine]popsurf[]; \
\[IndentingNewLine]poptrans[]; \[IndentingNewLine]popmathfun[]; \
\[IndentingNewLine]lasttransmit = "\<\>"; \[IndentingNewLine]checktexture = 
            False; \[IndentingNewLine] (*\ \(Print["\< - \>"];\)\ \
*) \[IndentingNewLine]\(--worecursion\);\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(\( (*\ 
      causes\ contexting\ problems; \[IndentingNewLine]h = 
        h /. \(\({\)\(Graphics \[Rule] rGraphics, 
            Line \[Rule] 
              rLine\)\(\ \)\)*) \)\(\[IndentingNewLine]\)\( (*\ \(If\)\([\)\(\
\ \)\(\(h\  =!= \ "\<string\>"\)\(,\)\)\(\ \)*) \)\(\[IndentingNewLine]\)\( \
(*\[IndentingNewLine]\(h = 
          StringReplace[
            h, {"\<Graphics\>" \[Rule] "\<rGraphics\>", "\<SurfaceGraphics\>" \
\[Rule] "\<rSurfaceGraphics\>", "\<Graphics3D\>" \[Rule] "\<rGraphics3D\>", "\
\<Polygon\>" \[Rule] "\<rPolygon\>", "\<Line\>" \[Rule] "\<rLine\>", "\<Line2\
\>" \[Rule] "\<rLine2\>", "\<Point\>" \[Rule] "\<rPoint\>", "\<Cuboid\>" \
\[Rule] "\<rCuboid\>", "\<Sphere\>" \[Rule] "\<rSphere\>", "\<Text\>" \[Rule] \
"\<rText\>", "\<Raster\>" \[Rule] "\<rRaster\>", "\<RasterArray\>" \[Rule] \
"\<rRasterArray\>"}];\)\[IndentingNewLine]*) \)\(\n\)\( (*\ \(h = 
          StringReplace[
            h, "\<rr\>" \[Rule] "\<r\>"];\)\ *) \)\(\[IndentingNewLine]\)\( \
(*\[IndentingNewLine]Print["\<post /. \>", 
        Symbol[h]]; \[IndentingNewLine]Print["\<     a= \>", 
        a];\[IndentingNewLine]*) \)\(\[IndentingNewLine]\)\( (*\ 
      h = Symbol[h]; \ 
      broken\ ?\ 
          never\ matches\ fun\ \(\(call\)\(\ \)\(?\)\)\ *) \)\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["supporting  writeobj  funs", "Subsubsection"],

Cell["\<\
note the above doesn't recurse into args of any Function[ args ] , \
it stops at Function\
\>", "Text"],

Cell[BoxData[
    \(writeobj[h_, 
        obj_] := \[IndentingNewLine]\((\[IndentingNewLine]Print["\<level 2  \
h= \>", h]; \[IndentingNewLine]Print["\<level 2  ol= \>", 
          obj[\([1]\)]]; \[IndentingNewLine]obj = 
          obj[\([1]\)]; \[IndentingNewLine]obj[\([0]\)] = 
          Sequence; \[IndentingNewLine]Print["\<level 2  os= \>", 
          obj]; \[IndentingNewLine]\[IndentingNewLine]writeobj2[
          file, \(Symbol[h]\)[obj]];\[IndentingNewLine])\)\)], "Input",
  CellTags->"s6"],

Cell["\<\
writeobj2  just splits up the matching task (if quick list fails, \
try longer list)\
\>", "Text"],

Cell[BoxData[
    \(\(writeobj[h_, obj_] := writeobj2[h, obj];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell["\<\
writeobjEval  reverts  to the origional expr
\t*  is never used *  is a curteousy function allowing normal arg matching
\tslows down long lists of failed matches though - could be removed\
\>", \
"Text"],

Cell[BoxData[
    \(writeobjEval[h_, obj_] := 
      Module[{s}, \[IndentingNewLine]obj = 
          obj[\([1]\)]; \[IndentingNewLine]obj[\([0]\)] = 
          Sequence; \[IndentingNewLine] (*\ s = StringDrop[h, 1]; \ 
          use\ origsymb, \ \(has\ context;\)\ \
*) \[IndentingNewLine]writeobjEval[
          file, \(Symbol[origsymb]\)[obj]];\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell["(* unkown object *)", "Text",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(writeobjEval[h_, obj_] := 
        Module[{}, \[IndentingNewLine]Print["\< unk h: \>", h, "\< a \>", \ 
            obj, "\< con \>", 
            Context[Evaluate[obj[\([0]\)]]], "\< \>"]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell["\<\
FIXME
\t??  rGraphicsComplex   or   GraphicsComplex   ??\
\>", "Text"],

Cell["for mm v.9", "Text",
  CellTags->"s6"],

Cell["\<\
\tlist fun does this ? no this replaces {pt1, pt2, pt3 } in \
Polygon[{1, 2, 3}]
\tand (should be) already done\
\>", "Text",
  CellTags->"s6"],

Cell[BoxData[
    \( (*\ \(writeobj["\<rGraphicsComplex\>", 
            oblist_] := \[IndentingNewLine]writeobj["\<List\>", \ 
            Unevaluated[{oblist}]];\)\ *) \)], "Input",
  CellTags->"s6"],

Cell[BoxData[
    \(\(writeobj2[file_, rGraphicsComplex[gc_]] := 
        writeobj["\<List\>", Hold[{gc}]];\)\)], "Input",
  InitializationCell->True],

Cell["\<\
\tthe list funs probably won't care ... unsure if these are even \
held in graphics array ...
\ti assume any {gr} is treated as group, else use Flatten[list] right ? \
right.\
\>", "Text",
  CellTags->"s6"],

Cell[BoxData[
    \(\(writeobj2[file_, rGraphicsGroup[gg_]] := 
        writeobj["\<List\>", Hold[{gg}]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell["\<\
\thave no idea why v9 feature adds anything.  but anyhow it will be \
Scanned.
FIXME:\ti think it applies options only to following item ?  for us that \
means
\teither {grouping with next graphic } or adding a way to pop after.  same \
either way.\
\>", "Text",
  CellTags->"s6"],

Cell[BoxData[
    \(\(writeobj2[file_, rDirective[dd_]] := 
        writeobj["\<List\>", Hold[{dd}]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell["\<\
\tis front end evaluator wrapper to animate effected cells / \
graphics \"if change\"
\tignore for now\
\>", "Text"],

Cell[BoxData[
    \(\(writeobj2[file_, rDynamic[dd_]] := 
        writeobj["\<List\>", Hold[{dd}]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell["\<\
(* assume
\tsurfstore[[Length[surfstore]]] does not accumulate w/in group (assigned \
with =)
\tbut trans and mathfun should accumulate w/in a group
*)\
\>", "Text",
  CellTags->"s6"],

Cell[BoxData[
    \(\(pushsurf[surfspec_] := AppendTo[surfstore, surfspec];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(popsurf[] := 
        If[Length[surfstore] > 1, surfstore = Take[surfstore, {1, \(-2\)}], 
          surfstore = {"\<\>"}];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(writesurf[file_] := 
        If[surfstore[\([Length[
                  surfstore]]\)] \[NotEqual] "\<\>", \[IndentingNewLine]Write[
            file, surfstore[\([Length[surfstore]]\)]]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(writesurfPOV[file_] := \[IndentingNewLine]If[
          surfstore[\([Length[
                  surfstore]]\)] \[NotEqual] "\<\>", \[IndentingNewLine]Write[
            file, "\<texture { \>"]; \[IndentingNewLine]Write[file, 
            surfstore[\([Length[surfstore]]\)]]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(writesurfPOV2[str_] := \[IndentingNewLine]If[
          surfstore[\([Length[
                  surfstore]]\)] \[NotEqual] "\<\>", \[IndentingNewLine]Write[
            str, "\<texture { \>"]; \[IndentingNewLine]Write2[str, 
            surfstore[\([Length[surfstore]]\)]]; \[IndentingNewLine]Write[
            str, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(pushtrans[transspec_] := 
        AppendTo[transstore, transspec];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(poptrans[] := 
        If[Length[transstore] > 1, 
          transstore = Take[transstore, {1, \(-2\)}], 
          transstore = {"\<\>"}];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(writetrans[file_] := 
        If[transstore[\([Length[
                  transstore]]\)] \[NotEqual] "\<\>", \
\[IndentingNewLine]Write[file, 
            transstore[\([Length[transstore]]\)]]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(\(applytrans[str_] := 
        Module[{inc}, \[IndentingNewLine]Write2[str, 
            transstore[\([Length[transstore]]\)]]; \[IndentingNewLine]inc = 
            1; \  (*\ 
            insure\ trans\ is\ one\ per\ gr\ so\ far\ \
*) \[IndentingNewLine]While[
            Length[trans] < grcount && \(++inc\) \[LessEqual] 1000, 
            AppendTo[
              trans, "\<\>"]]; \[IndentingNewLine]trans[\([grcount]\)] = 
            trans[\([grcount]\)] <> str;\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(pushmathfun[mathfun_] := 
        AppendTo[mathfunstore, mathfun];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \(popmathfun[] := \((\(If[Length[mathfunstore] > 1, 
            mathfunstore = Take[mathfunstore, {1, \(-2\)}], 
            mathfunstore = {{}}];\))\)\)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell[BoxData[
    \( (*\ avoid\ adding\ the\ like; \[IndentingNewLine]applydiff[str_] := 
        Module[{inc}, \[IndentingNewLine]Write2[str, 
            diffstore[\([Length[diffstore]]\)]]; \[IndentingNewLine]inc = 
            1; \  (*\ 
            insure\ diff\ is\ one\ per\ gr\ so\ far\ \
*) \[IndentingNewLine]While[
            Length[diff] < grcount && \(++inc\) \[LessEqual] 1000, 
            AppendTo[diff, "\<\>"]]; \[IndentingNewLine]diff[\([grcount]\)] = 
            diff[\([grcount]\)] <> 
              str;\[IndentingNewLine]];\[IndentingNewLine]*) \)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["writeobj  popular primatives", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s7"],

Cell[BoxData[
    \( (*\ \(WRONG : \ 
          writeobj2[
            file_, {RGBColor[r_, g_, b_], 
              Polygon[vl_]}]\)\(:=\)\ *) \)], "Input",
  InitializationCell->True,
  CellTags->"s6"],

Cell["\<\
NOTE: see next section surfs & trans or writeobj2 for normal style \
of arg handling\
\>", "Text"],

Cell[CellGroupData[{

Cell["cylinder", "Subsubsection"],

Cell["\<\
Cylinder
\tmm v.9 does not do {x,y,z,r}, {x,y,z,r}
\tnote similarity to Cuboid
\tit's not checked of all of Cylinder is in PlotRange, only endpoints checked
Cylinder[{{x1, y1, z1}, {x2, y2, z2}}, r]
\trepresents a cylinder of radius r around the line from to .
Cylinder[{{x1, y1, z1}, {x2, y2, z2}}]
\trepresents a cylinder of radius 1.
Cylinder[{spec1, spec2, ...}] 
\trepresents a collection of cylinders of radius 1.
Cylinder[{spec1, spec2, ...}, {r1, r2, ...}]
\trepresents a collection of cylinders with specifications  and radii .
Cylinder[{spec1, spec2, ...}, r]
\trepresents a collection of cylinders of radius r.
Cylinder[] is equivalent to Cylinder[{{0, 0, -1}, {0, 0, 1}}].\
\>", "Text",
  CellTags->"s7"],

Cell[BoxData[
    \(\(writeobj["\<rCylinder\>", vl_] := XrCylinder[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrCylinder, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrCylinder[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, rad, x, y, p1, p2, 
            radv, cap, 
            cu}, \[IndentingNewLine] (*\ \(Print["\<### Cylinder \>", 
                vl];\)\ *) \[IndentingNewLine]\[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]If[v === {}, 
            v = {{{0, 0, \(-1\)}, {0, 0, 1}}}]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]If[
            len > 1, \[IndentingNewLine]v[\([1]\)] = 
              Partition[Flatten[v[\([1]\)]], 3]; \[IndentingNewLine]len = 
              Length[v[\([1]\)]]; \[IndentingNewLine]If[
              Length[v[\([2]\)]] >= 1, \[IndentingNewLine]radv = 
                v[\([2]\)], \(radv = 
                  Table[v[\([2]\)], {inc, 1, 
                      len/2}];\)\[IndentingNewLine]]; \[IndentingNewLine]v = 
              v[\([1]\)];\[IndentingNewLine], \[IndentingNewLine]v = 
              Partition[Flatten[v], 3]; \[IndentingNewLine]len = 
              Length[v]; \[IndentingNewLine]radv = 
              Table[1, {inc, 1, 
                  len/2}];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            len >= 2, \[IndentingNewLine]\[IndentingNewLine]If[
              Length[mathfunstore] > 0, \[IndentingNewLine]cap = 
                CapForm /. 
                  mathfunstore[\([Length[
                        mathfunstore]]\)]]; \[IndentingNewLine]\
\[IndentingNewLine]For[inc = 2, inc \[LessEqual] len, 
              inc += 2, \[IndentingNewLine]p1 = 
                v[\([inc - 1]\)]; \[IndentingNewLine]p2 = 
                v[\([inc]\)]; \[IndentingNewLine]p1 = 
                pointInPlotRange[p1]; \[IndentingNewLine]If[p1 === Null, 
                Continue[]]; \[IndentingNewLine]p2 = 
                pointInPlotRange[p2]; \[IndentingNewLine]If[p2 === Null, 
                Continue[]]; \[IndentingNewLine]rad = 
                radv[\([inc/2]\)]; \[IndentingNewLine]\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<cylinder \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \[IndentingNewLine]writeNumsFastR[
                  rad, p1]; \[IndentingNewLine]writeNumsFast[
                  p2]; \[IndentingNewLine]applyTexture["\<cylindrical\>", \
\((p1 + p2)\)/2]; \[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine], \[IndentingNewLine]Write[
                  file, "\<cylinder  { \>"]; \[IndentingNewLine]writeNums[
                  file, p1, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  p2, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  rad]; \[IndentingNewLine]Write[
                  file, "\< open \>"]; \
\[IndentingNewLine]applyTexture["\<cylindrical\>", \((p1 + p2)\)/
                    2]; \[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]Write[
                  file, "\<}\>"];\[IndentingNewLine]]; \[IndentingNewLine] \
(*\ put\ on\ endcap\  /. \ options\ here\ *) \[IndentingNewLine]\(If[\ 
                  cap =!= CapForm && 
                    cap[\([1]\)] =!= None, \[IndentingNewLine]If[
                    cap[\([1]\)] \[Equal] "\<Butt\>", \[IndentingNewLine]x = 
                      magnitude[\((p2 - p1)\)]; \[IndentingNewLine]If[
                      Chop@x === 0, 
                      x =  .001]; \[IndentingNewLine]cu = \((p2 - p1)\)/
                        x; \[IndentingNewLine]Xrdisc[{rad, 
                        p1, \(-cu\)}]; \[IndentingNewLine]Xrdisc[{rad, p2, 
                        cu}];\[IndentingNewLine]]; \[IndentingNewLine]If[
                    cap[\([1]\)] \[Equal] "\<Round\>", 
                    XrSphere[{{p1, p2}, 
                        rad}]];\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]primcount += 
              len;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{

Cell["tube", "Subsubsection"],

Cell["\<\
Tube[{{x1, y1, z1}, {x2, y2, z2}, ...}]
\trepresents a 3D tube around the line joining a sequence of points.
Tube[{pt1, pt2, ...}, r]
\trepresents a tube of radius r.
Tube[{{pt11, pt12, ...}, {pt21, ...}, ...}, ...]
\trepresents a collection of tubes.
Tube[curve, ...]
\trepresents a tube around the specified 3D curve.

# Tube[{pt1, pt2, ...}, {r1, r2, ...}] specifies a different tube radius at \
the position of each of the points .
# Tube[{pt1, pt2, ...}, ...] gives a tube consisting of a sequence of \
straight segments. It is equivalent to Tube[Line[{pt1, ...}], ...].

If no explicit radius is specified, Tube uses a small scaled radius.\
\>", \
"Text"],

Cell[BoxData[
    \(\(writeobj["\<rTube\>", vl_] := XrTube[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrTube, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrTube[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, o, rad, x, y, p1, 
            p2, cap}, \[IndentingNewLine] (*\ \(Print["\<### Tube \>", 
                vl];\)\ *) \[IndentingNewLine]\[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]If[v === {}, 
            v = {{{0, 0, \(-1\)}, {0, 0, 1}}}]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]If[
            len > 1, \[IndentingNewLine]v[\([1]\)] = 
              Partition[Flatten[v[\([1]\)]], 3]; \[IndentingNewLine]len = 
              Length[v[\([1]\)]]; \[IndentingNewLine]If[
              Length[v[\([2]\)]] >= 1, \[IndentingNewLine]radv = 
                v[\([2]\)], \(radv = 
                  Table[v[\([2]\)], {inc, 1, 
                      len/2}];\)\[IndentingNewLine]]; \[IndentingNewLine]v = 
              v[\([1]\)];\[IndentingNewLine], \[IndentingNewLine]v = 
              Partition[Flatten[v], 3]; \[IndentingNewLine]len = 
              Length[v]; \[IndentingNewLine]radv = 
              Table[linewidth, {inc, 1, 
                  len/2}];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            len > 1, \[IndentingNewLine]\[IndentingNewLine]If[
              Length[mathfunstore] > 0, \[IndentingNewLine]cap = 
                CapForm /. 
                  mathfunstore[\([Length[
                        mathfunstore]]\)]]; \[IndentingNewLine]For[inc = 1, 
              inc < len, \(++inc\), \[IndentingNewLine]p1 = 
                pointInPlotRange[v[\([inc]\)]]; \[IndentingNewLine]If[
                p1 === Null, Continue[]]; \[IndentingNewLine]p2 = 
                pointInPlotRange[v[\([inc + 1]\)]]; \[IndentingNewLine]If[
                p2 === Null, Continue[]]; \[IndentingNewLine]rad = 
                radv[\([\((inc + Mod[inc, 2])\)/2]\)]; \[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<cylinder \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \[IndentingNewLine]writeNumsFastR[
                  rad, p1]; \[IndentingNewLine]writeNumsFast[
                  p2]; \[IndentingNewLine]applyTexture["\<cylindrical\>", \
\((p1 + p2)\)/2]; \[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine], \[IndentingNewLine]Write[
                  file, "\<cylinder  { \>"]; \[IndentingNewLine]writeNums[
                  file, p1, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  p2, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  rad]; \[IndentingNewLine]Write[
                  file, "\< open \>"]; \
\[IndentingNewLine]applyTexture["\<cylindrical\>", \((p1 + p2)\)/
                    2]; \[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]Write[
                  file, "\<}\>"];\[IndentingNewLine]]; \[IndentingNewLine] \
(*\ put\ on\ endcap\  /. \ options\ here\ *) \[IndentingNewLine]If[\ 
                cap =!= CapForm && 
                  cap[\([1]\)] =!= None, \[IndentingNewLine]If[
                  cap[\([1]\)] \[Equal] "\<Butt\>", \[IndentingNewLine]x = 
                    magnitude[\((p2 - p1)\)]; \[IndentingNewLine]If[
                    Chop@x === 0, 
                    x =  .001]; \[IndentingNewLine]cu = \((p2 - p1)\)/
                      x; \[IndentingNewLine]Xrdisc[{rad, 
                      p1, \(-cu\)}]; \[IndentingNewLine]Xrdisc[{rad, p2, 
                      cu}];\[IndentingNewLine]]; \[IndentingNewLine]If[
                  cap[\([1]\)] \[Equal] "\<Round\>", 
                  XrSphere[{{p1, p2}, 
                      rad}]];\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]primcount += 
              len;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[
    \( (*\[IndentingNewLine]o = ReleaseHold[vl]; \[IndentingNewLine]v = 
        o[\([1]\)]; \[IndentingNewLine]If[Length[o] > 1, rad = Last[o], 
        rad = linewidth]; \[IndentingNewLine]If[v === {}, 
        Return[]]; \[IndentingNewLine] (*\ \(v = 
            v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                  y};\)\ *) \[IndentingNewLine]v = 
        Partition[Flatten[v], 3]; \[IndentingNewLine]len = 
        Length[v];\[IndentingNewLine]*) \)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["line tube", "Subsubsection"],

Cell[BoxData[
    \(\(writeobj["\<rLineTube\>", vl_] := XrLineTube[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrLineTube, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrLineTube[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, rad, x, y, p1, 
            p2}, \[IndentingNewLine] (*\ \(Print["\<### LineTube \>", 
                vl];\)\ *) \[IndentingNewLine]v = \(ReleaseHold[
                vl]\)[\([1]\)]; \[IndentingNewLine]If[v === {}, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]v = 
              v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(v = 
                v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]v = 
            Partition[Flatten[v], 
              3]; \[IndentingNewLine] (*\ \(v = 
                Select[Map[pointInPlotRange, v], 
                  ListQ];\)\ *) \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]\[IndentingNewLine]If[
            len > 1, \[IndentingNewLine]If[
              Length[mathfunstore] > 
                0, \[IndentingNewLine]\(rad = 
                  AbsoluteThickness /. 
                    mathfunstore[\([Length[
                          mathfunstore]]\)];\)\[IndentingNewLine]]; \
\[IndentingNewLine]If[\[Not] NumberQ[rad], 
              rad = linewidth]; \[IndentingNewLine]rad *= 
              4/10~N~maxprecision; \[IndentingNewLine] (*\ 
              see\ notes\ below\ *) \[IndentingNewLine]If[rayaspect === True, 
              rad = rad/\((apparentzoom^2)\)]; \[IndentingNewLine]For[
              inc = 1, 
              inc < len, \(++inc\), \[IndentingNewLine]\[IndentingNewLine]p1 \
= v[\([inc]\)]; \[IndentingNewLine]p2 = 
                v[\([inc + 1]\)]; \[IndentingNewLine]p1 = 
                pointInPlotRange[p1]; \[IndentingNewLine]If[p1 === Null, 
                Continue[]]; \[IndentingNewLine]p2 = 
                pointInPlotRange[p2]; \[IndentingNewLine]If[p2 === Null, 
                Continue[]]; \[IndentingNewLine]\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<cylinder \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \[IndentingNewLine]writeNumsFastR[
                  rad, p1]; \[IndentingNewLine]writeNumsFast[
                  p2]; \[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine]]; \[IndentingNewLine]If[
                raypov === True, \[IndentingNewLine]Write[
                  file, "\<cylinder  { \>"]; \[IndentingNewLine]writeNums[
                  file, p1, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  p2]; \[IndentingNewLine]writeNums[file, 
                  rad]; \[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]Write[
                  file, "\<}\>"];\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]primcount += 
              len;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{

Cell["line box", "Subsubsection"],

Cell["\<\
may seem duplicative but an ability to assemble on axis and move \
into place is a skill that should be somewhere\
\>", "Text"],

Cell[BoxData[
    \(\(writeobj["\<rLineBox\>", vl_] := XrLineBox[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrLineBox, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrLineBox[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, rad, x, y, unit, 
            vn, vpRotAngles, mvn, mag, ang, p1, p2, 
            err}, \[IndentingNewLine] (*\ \(Print["\<### LineBox \>", 
                vl];\)\ *) \[IndentingNewLine]v = \(ReleaseHold[
                vl]\)[\([1]\)]; \[IndentingNewLine]If[v === {}, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]v = 
              v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(v = 
                v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]v = 
            Partition[Flatten[v], 
              3]; \[IndentingNewLine] (*\ \(v = 
                Select[Map[pointInPlotRange, v], 
                  ListQ];\)\ *) \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]\[IndentingNewLine]If[
            len > 1, \[IndentingNewLine]If[
              Length[mathfunstore] > 
                0, \[IndentingNewLine]\(rad = 
                  AbsoluteThickness /. 
                    mathfunstore[\([Length[
                          mathfunstore]]\)];\)\[IndentingNewLine]]; \
\[IndentingNewLine]If[\[Not] NumberQ[rad], 
              rad = linewidth]; \[IndentingNewLine]rad *= 
              1/4~N~maxprecision; \[IndentingNewLine]\[IndentingNewLine] (*\ 
              see\ notes\ below\ *) \[IndentingNewLine]If[rayaspect === True, 
              rad = rad/\((apparentzoom^2)\)]; \[IndentingNewLine]For[
              inc = 1, 
              inc < len, \(++inc\), \[IndentingNewLine]\[IndentingNewLine]p1 \
= v[\([inc]\)]; \[IndentingNewLine]p2 = 
                v[\([inc + 1]\)]; \[IndentingNewLine]p1 = 
                pointInPlotRange[p1]; \[IndentingNewLine]If[p1 === Null, 
                Continue[]]; \[IndentingNewLine]p2 = 
                pointInPlotRange[p2]; \[IndentingNewLine]If[p2 === Null, 
                Continue[]]; \[IndentingNewLine]\[IndentingNewLine]If[
                p2[\([2]\)] > p1[\([2]\)], vn = p2 - p1, 
                vn = p1 - p2]; \[IndentingNewLine]\[IndentingNewLine]mag = 
                magnitude[vn]; \[IndentingNewLine]If[mag === 0, 
                Continue[]]; \[IndentingNewLine]\[IndentingNewLine]unit = 
                vn/mag; \[IndentingNewLine]vn = {unit[\([1]\)], 
                  unit[\([2]\)], 0}; \  (*\ 
                rest\ on\ x - y\ *) \[IndentingNewLine]mvn = 
                magnitude[vn]; \[IndentingNewLine] (*\ 
                clamp\ *) \[IndentingNewLine]ang = \(({1, 0, 0} . 
                      vn)\)/\((mvn +  .00001)\); \[IndentingNewLine]If[
                ang < \(-1\), ang = \(-1\)]; \[IndentingNewLine]If[ang > 1, 
                ang = 1]; \[IndentingNewLine]\[IndentingNewLine]vpRotAngles = \
{\[IndentingNewLine]ArcCos[ang]/
                      Degree, \[IndentingNewLine]0, \
\[IndentingNewLine]ArcCos[\(({0, 0, 1} . unit)\)]/Degree\[IndentingNewLine]}~
                  N~maxprecision; \[IndentingNewLine]vpRotAngles[\([3]\)] = 
                90 - vpRotAngles[\([3]\)]~N~
                    maxprecision; \[IndentingNewLine]\[IndentingNewLine] (*\ 
                FIXME\ *) \[IndentingNewLine]\[IndentingNewLine]err = 
                False; \[IndentingNewLine]If[
                vpRotAngles[\([1]\)] === Indeterminate, 
                vpRotAngles[\([1]\)] = 90; err = True; 
                Print["\<indet\>"];]; \[IndentingNewLine]If[
                vpRotAngles[\([3]\)] === Indeterminate, 
                vpRotAngles[\([3]\)] = 90; err = True; 
                Print["\<indet\>"];]; \[IndentingNewLine]vpRotAngles[\([1]\)] \
= Re[vpRotAngles[\([1]\)]]; \[IndentingNewLine]vpRotAngles[\([3]\)] = 
                Re[vpRotAngles[\([3]\)]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<box \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFast[{\(-mag\)/
                      2, \(-rad\), \(-rad\)}]; \
\[IndentingNewLine]writeNumsFast[{mag/2, rad, 
                    rad}\ ]; \[IndentingNewLine]writeNums[
                  file, "\<rotate \>", {0, 1, 
                    0}, \(-vpRotAngles[\([3]\)]\)]; \
\[IndentingNewLine]writeNums[file, "\<rotate \>", {0, 0, 1}, 
                  vpRotAngles[\([1]\)]]; \[IndentingNewLine]writeNums[
                  file, "\<translate \>", \((p1 + p2)\)/
                    2]; \[IndentingNewLine]\[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
                raypov === True, \[IndentingNewLine]Write[
                  file, "\<box  { \>"]; \
\[IndentingNewLine]\[IndentingNewLine]writeNums[
                  file, {\(-mag\)/
                      2, \(-rad\), \(-rad\)}, "\<,\>"]; \
\[IndentingNewLine]writeNums[
                  file, {mag/2, rad, rad}\ ]; \[IndentingNewLine]writeNums[
                  file, "\<rotate \>", {0, \(-vpRotAngles[\([3]\)]\), 
                    0}]; \[IndentingNewLine]writeNums[
                  file, "\<rotate \>", {0, 0, 
                    vpRotAngles[\([1]\)]}]; \[IndentingNewLine]writeNums[
                  file, "\<translate \>", \((p1 + p2)\)/
                    2]; \[IndentingNewLine]\[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]Write[
                  file, "\<}\>"];\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]primcount += 
              len;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[
    \(\(\( (*\[IndentingNewLine]\(If[
          err === True, \[IndentingNewLine]\(writeNums[
              file, "\<box \>", "\< ambient .3 0 0 diffuse .3 0 0 \>"];\)\
\[IndentingNewLine], \[IndentingNewLine]\(writeNums[file, "\<box \>", 
              surfstore[\([Length[
                    surfstore]]\)]];\)\[IndentingNewLine]];\)\
\[IndentingNewLine]*) \)\(\[IndentingNewLine]\)\( (*\[IndentingNewLine]If[
        vpRotAngles[\([1]\)] === Indeterminate, 
        vpRotAngles[\([1]\)] = 90]; \[IndentingNewLine]If[
        vpRotAngles[\([3]\)] === Indeterminate, 
        vpRotAngles[\([3]\)] = 90];\[IndentingNewLine]*) \)\)\)], "Input"],

Cell["\<\
don't be dumb like me and carefully note
\trotate ^axis theta ; Rotate counter-clockwise about the given axis by theta \
degrees
to get into place create on x-axis, incline by tiling on y, then rotate \
around z, then translate
\t(trying to rotate around z then incline wrong, need unit vector to incline \
on)\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["line poly  and  line wrapper", "Subsubsection"],

Cell["\<\
(* this makes polygon lines;
  go counter clock; add to give width; make it face toward vp;
  ends arent round; for Boxes\[Rule]True its fine *)\
\>", "Text",
  CellTags->"s7"],

Cell[BoxData[
    \( (*\ \(writeobj[file_, rLine[vl_]] := XrLine[vl];\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<rLine\>", vl_] := XrLine[vl];\)\)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<rLine\>", vl_] := \[IndentingNewLine]If[
          rayboxlines === False && 
            raytubelines === False, \[IndentingNewLine]XrLine[
            vl]\[IndentingNewLine], \[IndentingNewLine]If[
            rayboxlines === True, XrLineBox[vl], 
            XrLineTube[vl]]\[IndentingNewLine]];\)\)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<rLine\>", vl_] := \[IndentingNewLine]If[
          Length[mathfunstore] > 
              0 && \((Dashing /. mathfunstore[\([Length[mathfunstore]]\)])\) =!= 
              Dashing, \[IndentingNewLine]\(XrDashing[
              vl];\)\[IndentingNewLine], \[IndentingNewLine]\(If[
              rayboxlines === False && 
                raytubelines === False, \[IndentingNewLine]XrLine[
                vl]\[IndentingNewLine], \[IndentingNewLine]If[
                rayboxlines === True, XrLineBox[vl], 
                XrLineTube[
                  vl]]\[IndentingNewLine]];\)\[IndentingNewLine]];\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrLine, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\ if\ level + 
          1\  === \ {list}\  \[NotEqual] \ {}\ then\ go\ again\ *) \)], \
"Input"],

Cell[BoxData[
    \(\(XrLine[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, add, ma, rad, x, y, 
            p1, p2}, \[IndentingNewLine] (*\ \(Print["\<### Line \>", \ 
                vl];\)\ *) \[IndentingNewLine]v = \(ReleaseHold[
                vl]\)[\([1]\)]; \[IndentingNewLine]If[v === {}, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]v = 
              v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(v = 
                v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]v = Partition[Flatten[v], 3]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine] (*\ \(Print["\<line len pr v\>", 
                len, "\<\n\>", pr, "\<\n\>", 
                v];\)\ *) \[IndentingNewLine]\[IndentingNewLine]If[
            len > 1, \[IndentingNewLine]If[
              Length[mathfunstore] > 
                0, \[IndentingNewLine]\(rad = 
                  AbsoluteThickness /. 
                    mathfunstore[\([Length[
                          mathfunstore]]\)];\)\[IndentingNewLine]]; \
\[IndentingNewLine]If[\[Not] NumberQ[rad], 
              rad = linewidth]; \[IndentingNewLine]\[IndentingNewLine]For[
              inc = 1, 
              inc < len, \(++inc\), \[IndentingNewLine]\[IndentingNewLine]p1 \
= v[\([inc]\)]; \[IndentingNewLine]p2 = 
                v[\([inc + 1]\)]; \[IndentingNewLine]p1 = 
                pointInPlotRange[p1]; \[IndentingNewLine]If[p1 === Null, 
                Continue[]]; \[IndentingNewLine]p2 = 
                pointInPlotRange[p2]; \[IndentingNewLine]If[p2 === Null, 
                Continue[]]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
                see\ code\ notes\ about\ surfstore\ *) \[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine] (*\ 
                  darken\  - \ 
                    with\ std\ lights\ it\ washes\ out\ near\ boxcenter; \
\[IndentingNewLine]this\ is\ due\ to\ reflect\ v . \ 
                      normal\ rather\ than\ size;\[IndentingNewLine]\
*) \[IndentingNewLine]\(If[
                    rayglass === False, \[IndentingNewLine]Write[
                      file, "\<polygon \>" <> 
                        globalsurf <> "\< diffuse .2 .2 .2 \>" <> 
                        surfstore[\([Length[
                              surfstore]]\)]]\[IndentingNewLine], \
\[IndentingNewLine]Write[
                      file, "\<polygon glass diffuse  .05 .1 .1 \>" <> 
                        surfstore[\([Length[
                              surfstore]]\)]]\[IndentingNewLine]];\)\
\[IndentingNewLine]]; \[IndentingNewLine]If[
                raypov === 
                  True, \[IndentingNewLine]\(Write[
                    file, "\<polygon { 5, \>"];\)\[IndentingNewLine]]; \
\[IndentingNewLine] (*\ \("\<fast\>"\ add = 
                    Cross[\((v[\([inc]\)] - v[\([inc + 1]\)])\), 
                      unit];\)\ *) \[IndentingNewLine]add = 
                Cross[\((p1 - p2)\), \((eyep - 
                      p1)\)]; \[IndentingNewLine]ma = 
                magnitude[add]; \[IndentingNewLine]If[ma \[Equal] 0, 
                ma =  .0001]; \[IndentingNewLine]add = 
                rad\ add/ma; \[IndentingNewLine]add /= 
                2; \[IndentingNewLine] (*\ 
                we\ get\ scaled\ later\ but\ need\ to\ keep\ linewidth\ \
*) \[IndentingNewLine]add /= prasp; \  (*\ 
                If[rayaspect \[Equal] 
                    True]\ *) \[IndentingNewLine]\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNumsFast[
                  p1 - add/2]; \[IndentingNewLine]writeNumsFast[
                  p2 - add/2]; \[IndentingNewLine]writeNumsFast[
                  p2\  + add/2]; \[IndentingNewLine]writeNumsFast[
                  p1 + add/2]; \[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine], \[IndentingNewLine]writeNums[
                  file, p1 - add/2, "\< , \>"]; \[IndentingNewLine]writeNums[
                  file, p2 - 
                    add/2, \ "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  p2\  + add/2, \ "\< , \>"]; \[IndentingNewLine]writeNums[
                  file, p1 + add/2, "\< , \>"]; \[IndentingNewLine]writeNums[
                  file, p1 - add/2]; \[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]Write[
                  file, "\<}\>"];\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]primcount += 
              len;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[
    \(\(\( (*\ 
      had\ effect\ of\ joining\ across\ dropped\ points\ *) \)\(\
\[IndentingNewLine]\)\( (*\ \(v = 
          Select[Map[pointInPlotRange, v], ListQ];\)\ *) \)\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["point", "Subsubsection"],

Cell["\<\
(*
\tchanging aspect will scew discs (not a unit normal problem)
\tok as Listable for now in mm v9 no groups allowed (cough, yet)
*)
Point[coords]
\tis a graphics primitive that represents a point.
Point[{coords1, coords2, ...}]
\trepresents a collection of points.\
\>", "Text",
  CellTags->"s7"],

Cell[BoxData[
    \(\(writeobj["\<rPoint\>", vl_] := XrPoint[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrPoint, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrPoint[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, rad, x, y, area, 
            area2}, \[IndentingNewLine]\[IndentingNewLine] (*\ \(Print["\<### \
Point \>", \ vl];\)\ *) \[IndentingNewLine]v = \(ReleaseHold[
                vl]\)[\([1]\)]; \[IndentingNewLine]If[v === {}, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]v = 
              v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(v = 
                v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]v = Partition[Flatten[v], 3]; \[IndentingNewLine]v = 
            Select[Map[pointInPlotRange, v], ListQ]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]\[IndentingNewLine]If[
            len > 0, \[IndentingNewLine]If[
              Length[mathfunstore] > 
                0, \[IndentingNewLine]\(rad = 
                  PointSize /. 
                    mathfunstore[\([Length[
                          mathfunstore]]\)];\)\[IndentingNewLine]]; \
\[IndentingNewLine]If[\[Not] NumberQ[rad], 
              rad = linewidth]; \[IndentingNewLine] (*\ 
              see\ notes\ below\ *) \[IndentingNewLine]If[rayaspect === True, 
              rad = rad/apparentzoom]; \[IndentingNewLine]rad = 
              rad~N~maxprecision; \[IndentingNewLine]\[IndentingNewLine]For[
              inc = 1, 
              inc \[LessEqual] len, \(++inc\), \[IndentingNewLine]v2 = 
                v[\([inc]\)]; \[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine] (*\ 
                  darken\  - \ 
                    with\ std\ lights\ it\ washes\ out\ near\ boxcenter; \
\[IndentingNewLine]this\ is\ due\ to\ reflect\ v . \ 
                      normal\ rather\ than\ size;\[IndentingNewLine]\
*) \[IndentingNewLine]If[
                  rayglass === False, \[IndentingNewLine]writeNums[
                    file, "\<disc \>", globalsurf, "\< diffuse .1 .1 .1 \>", 
                    surfstore[\([Length[surfstore]]\)], 
                    rad]\[IndentingNewLine], \[IndentingNewLine]writeNums[
                    file, "\<disc glass diffuse .05 .1 .1 \>", 
                    surfstore[\([Length[surfstore]]\)], 
                    rad]\[IndentingNewLine]]; \
\[IndentingNewLine]writeNumsFast[
                  v2]; \[IndentingNewLine]writeNumsFast[\(-unit\)]; \
\[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine]]; \[IndentingNewLine]If[
                raypov === True, \[IndentingNewLine]Write[
                  file, "\<disc  { \>"]; \[IndentingNewLine]writeNums[file, 
                  v2]; \[IndentingNewLine]writeNums[
                  file, \(-unit\)]; \[IndentingNewLine]writeNums[file, 
                  rad]; \[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]Write[
                  file, "\<}\>"];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]\(++primcount\);\[IndentingNewLine]];\[IndentingNewLine]];\
\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell["\<\
Point notes

(* darken is a hack: with std lights pts washe out near;
  boxcenter this is due to reflect v. normal rather than size;
  another hack would be to tilt normal but thats just as hacky;
  *)
(* ways to fix point shape when squashed;
  1 ignore it ok for many plots leave fix as optional;
  2 use apparent zoom so area is correct for apparent zoom;
  3 1/scale here so when squashed its orig. size ? OOPS;
  use of 2 and 3 will be orig. size and place!;
  \tie, writeNums[file,\"scale \",1/prasp];
  \trText does this intentionally;
  
  The only right way is draw an oblong disc that is circular;
  after squash. We have no rayshade primitive for oblong disc;
  *)\
\>", "Text",
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{

Cell["poly", "Subsubsection"],

Cell["\<\
(*
mm v.9 adds grouped lists
\tso tesselate by group
\tscan is used and I'm unsure if mm v9 nests deeper than that
rayshade:
\tpoly followed with no nums is ok
\trepeated surf specs ok, but all name surfs must be 1st
SPEED:
\tcode speed is ok getting here. parameter parsing slows this fun.  so does \
Write.
\tit's unavoidable insofar as to allow 2D points intermixed with 3D
\tand to allow new mm v9 grouped points: more needs to be done
\t\ttess could have it's own fun for better speed
\t\tpoints outside plotrange get checked after creating more poly
*)
Polygon[{pt1, pt2, ...}]
\tis a graphics primitive that represents a filled polygon.
Polygon[{{pt11, pt12, ...}, {pt21, ...}, ...}]
\trepresents a collection of polygons.
\
\>", "Text",
  CellTags->"s7"],

Cell[BoxData[
    \(\(writeobj["\<rPolygon\>", vl_] := 
        XrPolygon[\(ReleaseHold[vl]\)[\([1]\)]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\( (*\ \(v = \(ReleaseHold[
              vl]\)[\([1]\)];\)\ *) \)\(\[IndentingNewLine]\)\( (*\ \
\(Scan[\((\(XrPolygon[Hold[{#}]];\))\) &, vt];\)\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(XrPolygon[
          vl_] := \[IndentingNewLine]Module[{v, x, y, vi, vt, 
            len}, \[IndentingNewLine] (*\ \(Print["\<### Polygon \>", \ 
                vl];\)\ *) \[IndentingNewLine]If[vl === {}, 
            Return[]]; \[IndentingNewLine] (*\ 
            mm\ v9\ allows\ lists\ in\ lists\ *) \[IndentingNewLine]If[
            First[First[vl]] === List, \[IndentingNewLine]If[
              polyrecursion \[GreaterEqual] $RecursionLimit, 
              Return[]]; \[IndentingNewLine]\(++polyrecursion\); \
\[IndentingNewLine]Scan[XrPolygon, 
              vl]; \[IndentingNewLine]\(--polyrecursion\); \
\[IndentingNewLine]\(Return[];\)\[IndentingNewLine]]; \[IndentingNewLine] (*\ 
            tesselation\ gives\ us\ a\ limited\ list\ todo\ \
*) \[IndentingNewLine]If[
            raytesselate === True, \[IndentingNewLine]vt = 
              tessfunPoly3[vl]; \[IndentingNewLine]raytesselate = 
              False; \[IndentingNewLine]Scan[writetriagle, 
              vt]; \[IndentingNewLine]raytesselate = 
              True; \[IndentingNewLine]\(Return[];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]v = 
              vl /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(v = 
                vl /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\ \[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]v = 
            Select[Map[pointInPlotRange, v], ListQ]; \[IndentingNewLine]If[
            Length[v] \[LessEqual] 2, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            closes\ Polygon\ but\ POV\ still\ barfs; \
\[IndentingNewLine]rayshade\ and\ TriangularSurfacePlot\ dont\ care\ \
*) \[IndentingNewLine] (*\(If[Last[v] =!= First[v], 
                AppendTo[v, 
                  First[v]]];\)*) \[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]Write[
              file, "\<polygon  \>" <> 
                surfstore[\([Length[
                      surfstore]]\)]]; \
\[IndentingNewLine]Scan[\((writeNumsFast[#])\) &, v]; \[IndentingNewLine]If[
              checktexture === True, 
              applyTexture["\<planar\>", 
                Plus @@ v/Length[v]]]; \[IndentingNewLine]writetrans[
              file];\[IndentingNewLine], \[IndentingNewLine]Write[
              file, "\<polygon { \>"]; \[IndentingNewLine]Write[file, 
              ToString[
                  Length[v]] <> "\<,\>"]; \
\[IndentingNewLine]Scan[\((writeNums[file, #]; Write[file, "\<,\>"])\) &, 
              Take[v, Length[v] - 1]]; \[IndentingNewLine]writeNums[file, 
              Last[v]]; \[IndentingNewLine]If[checktexture === True, 
              applyTexture["\<planar\>", {0, 0, 
                  0}]]; \[IndentingNewLine]writesurfPOV[
              file]; \[IndentingNewLine]writetrans[
              file]; \[IndentingNewLine]Write[
              file, "\<}\>"];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]\(++primcount\);\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[
    \(\(\(\ \)\( (*\ 
      tessfunPoly\ with\ Scan\ XrPolygon\ can\ used\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(writetriagle[
          vl_] := \[IndentingNewLine]Module[{}, \[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]Write[
              file, "\<triangle  \>" <> 
                surfstore[\([Length[
                      surfstore]]\)]]; \
\[IndentingNewLine]Scan[\((writeNumsFast[#])\) &, vl]; \[IndentingNewLine]If[
              checktexture === True, 
              applyTexture["\<planar\>", 
                Plus @@ vl/3]]; \[IndentingNewLine]writetrans[
              file];\[IndentingNewLine], \[IndentingNewLine]Write[
              file, "\<triangle { \>"]; \[IndentingNewLine]Scan[\((writeNums[
                    file, #]; Write[file, "\<,\>"])\) &, 
              Take[vl, Length[vl] - 1]]; \[IndentingNewLine]writeNums[file, 
              Last[vl]]; \[IndentingNewLine]If[checktexture === True, 
              applyTexture["\<planar\>", {0, 0, 
                  0}]]; \[IndentingNewLine]writesurfPOV[
              file]; \[IndentingNewLine]writetrans[
              file]; \[IndentingNewLine]Write[
              file, "\<}\>"];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]\(++primcount\);\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{

Cell["cuboid", "Subsubsection"],

Cell["\<\
this works for mm v9 but note:
\t{ { { pt, pt } } } any grouping of pairs works
\t{ { pt, pt }, { pt } } does NOT work only { pt } does
\t(see next definition of same function which balks at grouping)

was wrong: above wasn't working with  v=ReleaseHold[vl][[1]]
\tAND Cuboid in mm 9 uses Sequence and doesn't take list like Sphere does
\tmay do the above , unsure , tested simple form only

however, lists still work - but don't use them mm doesn't

Cuboid[{xmin, ymin, zmin}]
\tis a three-dimensional graphics primitive that
\trepresents a unit cube, oriented parallel to the axes.
Cuboid[{xmin, ymin, zmin}, {xmax, ymax, zmax}]
\tspecifies a cuboid by giving the coordinates of opposite corners.
Cuboid[] is equivalent to Cuboid[{0, 0, 0}].\
\>", "Text"],

Cell[BoxData[
    \( (*\ \(writeobj[file_, rCuboid[p1_]] := 
          XrCuboid[p1, p1 + {1, 1, 1}];\)\ *) \)], "Input"],

Cell[BoxData[
    \( (*\ \(writeobj[file_, rCuboid[p1, p2]] := 
          XrCuboid[p1, p2];\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<rCuboid\>", vl_] := XrCuboid[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrCuboid, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrCuboid[vl_] := 
        Module[{v, p1, p2, 
            inc}, \[IndentingNewLine] (*\ \(Print["\<### Cuboid \>", \ 
                vl];\)\ *) \[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]If[v === {}, 
            v = {{0, 0, 0}, {1, 1, 1}}]; \[IndentingNewLine]v = 
            Partition[Flatten[v], 3]; \[IndentingNewLine]If[Length[v] === 1, 
            AppendTo[v, v[\([1]\)] + {1, 1, 1}]]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]\[IndentingNewLine]If[
            len >= 2, \[IndentingNewLine]For[inc = 2, inc \[LessEqual] len, 
              inc += 2, \[IndentingNewLine]p1 = 
                v[\([inc - 1]\)]; \[IndentingNewLine]p2 = 
                v[\([inc]\)]; \[IndentingNewLine]p1 = 
                pointInPlotRange[p1]; \[IndentingNewLine]If[p1 === Null, 
                Continue[]]; \[IndentingNewLine]p2 = 
                pointInPlotRange[p2]; \[IndentingNewLine]If[p2 === Null, 
                Continue[]]; \[IndentingNewLine]\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]Write[
                  file, "\<box  \>" <> 
                    surfstore[\([Length[
                          surfstore]]\)]]; \[IndentingNewLine]writeNumsFast[
                  p1]; \[IndentingNewLine]writeNumsFast[
                  p2]; \[IndentingNewLine]applyTexture["\<planar\>", \((p1 + 
                        p2)\)/2]; \[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine], \[IndentingNewLine]Write[
                  file, "\<box { \>"]; \[IndentingNewLine]writeNums[file, 
                  p1]; \[IndentingNewLine]writeNums[file, 
                  p2]; \[IndentingNewLine]applyTexture["\<planar\>", \((p1 + 
                        p2)\)/2]; \[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]\(Write[
                    file, "\<}\>"];\)\[IndentingNewLine]];\[IndentingNewLine]]\
; \[IndentingNewLine]\(++primcount\);\[IndentingNewLine]];\[IndentingNewLine]]\
;\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[
    \( (*\ old : \ \ v = 
        v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
              y}; \[IndentingNewLine]note\ use\ Graphics3D\ output\ of\ for\ \
mm\ ver\  < \ 5.2;\ *) \)], "Input"],

Cell["\<\
do not use
\tthis works for mm v9 but note:
\t\t{ { pt } } won't work due to extra {}
\t\t{ { pt, pt }, { pt } } does work
\tworks if pts are grouped normally\
\>", "Text"],

Cell[BoxData[
    \(\(XrCuboid[vl_] := 
        Module[{p1, p2, 
            inc}, \[IndentingNewLine]\[IndentingNewLine] (*\ \(Print["\<### \
Cuboid \>", \ vl];\)\ *) \[IndentingNewLine]v = \(ReleaseHold[
                vl]\)[\([1]\)]; \[IndentingNewLine]Print["\<v=\>", 
            v]; \[IndentingNewLine]If[v === {}, 
            Return[]]; \[IndentingNewLine]v = 
            v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                  y}; \[IndentingNewLine]If[NumberQ[First[First[v]]], 
            v = {v}]; \[IndentingNewLine]\[IndentingNewLine]Scan[\((\
\[IndentingNewLine]p1 = pointInPlotRange[#[\([1]\)]]; \[IndentingNewLine]If[
                  Length[#] === 1, p2 = p1 + {1, 1, 1}, 
                  p2 = #[\([2]\)]]; \[IndentingNewLine]p1 = 
                  pointInPlotRange[p1]; \[IndentingNewLine]p2 = 
                  pointInPlotRange[
                    p2]; \[IndentingNewLine]\[IndentingNewLine]If[\(p1 =!= 
                        Null && p2\) =!= Null, \[IndentingNewLine]If[
                    raypov === False, \[IndentingNewLine]Write[
                      file, "\<box  \>" <> 
                        surfstore[\([Length[
                              surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFast[p1]; \[IndentingNewLine]writeNumsFast[
                      p2]; \[IndentingNewLine]writetrans[
                      file];\[IndentingNewLine], \[IndentingNewLine]Write[
                      file, "\<box { \>"]; \[IndentingNewLine]writeNums[file, 
                      p1]; \[IndentingNewLine]writeNums[file, 
                      p2]; \[IndentingNewLine]writesurfPOV[
                      file]; \[IndentingNewLine]writetrans[
                      file]; \[IndentingNewLine]Write[
                      file, "\<}\>"];\[IndentingNewLine]]; \
\[IndentingNewLine]\(++primcount\);\[IndentingNewLine]];\[IndentingNewLine])\)\
 &, v\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{

Cell["sphere", "Subsubsection"],

Cell["\<\
NOTE: mm v.9 does not do
\t\tSphere [ {x,y,z,r}, {x,y,z,r} , r ]  neither does this
\t\tSphere [ { {x,y,z,r}, {x,y,z,r} } , r ]  works
\tgrouping does not matter, uses parition
\tit's not checked if all of sphere is in PlotRange, only center checked
Sphere[{x, y, z}, r]
\trepresents a sphere of radius r centered at .
Sphere[{x, y, z}]
\trepresents a sphere of radius 1.
Sphere[{{x1, y1, z1}, {x2, y2, z2}, ...}, r]
\trepresents a collection of spheres of radius r.
# Sphere[] is equivalent to Sphere[{0, 0, 0}]. \[RightGuillemet]
# Sphere[{c1, c2, ...}, {r1, r2, ...}] represents a collection of spheres \
with centers and radii .\
\>", "Text",
  CellTags->"s7"],

Cell[BoxData[
    \(\(writeobj["\<rSphere\>", vl_] := XrSphere[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrSphere, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrSphere[vl_] := 
        Module[{v, rad, p1, inc, 
            radv}, \[IndentingNewLine]\[IndentingNewLine] (*\ \(Print["\<### \
Sphere \>", \ vl];\)\ *) \[IndentingNewLine]\[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]If[v === {}, 
            v = {{0, 0, 0}}]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]\[IndentingNewLine]If[
            Head[v[\([1]\)]] =!= List, v = {v}; 
            len = 1;]; \[IndentingNewLine]\[IndentingNewLine]If[
            len > 1, \[IndentingNewLine]v[\([1]\)] = 
              Partition[Flatten[v[\([1]\)]], 3]; \[IndentingNewLine]len = 
              Length[v[\([1]\)]]; \[IndentingNewLine]If[
              Length[v[\([2]\)]] >= 1, \[IndentingNewLine]radv = 
                v[\([2]\)], \(radv = 
                  Table[v[\([2]\)], {inc, 1, 
                      len}];\)\[IndentingNewLine]]; \[IndentingNewLine]v = 
              v[\([1]\)];\[IndentingNewLine], \[IndentingNewLine]v = 
              Partition[Flatten[v], 3]; \[IndentingNewLine]len = 
              Length[v]; \[IndentingNewLine]radv = 
              Table[1, {inc, 1, 
                  len}];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]inc = 
            1; \[IndentingNewLine]Scan[\((\[IndentingNewLine]rad = 
                  radv[\([\(inc++\)]\)]; \[IndentingNewLine]p1 = 
                  pointInPlotRange[#]; \[IndentingNewLine]If[
                  p1 =!= Null, \[IndentingNewLine]If[
                    raypov === False, \[IndentingNewLine]Write[
                      file, "\<sphere  \>" <> 
                        surfstore[\([Length[
                              surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFastR[rad, #]; \[IndentingNewLine]writetrans[
                      file]; \[IndentingNewLine]If[checktexture === True, 
                      applyTexture["\<spherical\>", #]];\[IndentingNewLine], \
\[IndentingNewLine]Write[file, "\<sphere { \>"]; \[IndentingNewLine]writeNums[
                      file, #]; \[IndentingNewLine]writeNums[file, 
                      rad]; \[IndentingNewLine]If[checktexture === True, 
                      applyTexture["\<spherical\>", #]]; \
\[IndentingNewLine]writesurfPOV[file]; \[IndentingNewLine]writetrans[
                      file]; \[IndentingNewLine]Write[
                      file, "\<}\>"];\[IndentingNewLine]]; \
\[IndentingNewLine]\(++primcount\);\[IndentingNewLine]];\[IndentingNewLine])\)\
 &, v\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[
    \(\(\( (*\[IndentingNewLine]o = ReleaseHold[vl]; \[IndentingNewLine]If[
        o === {}, 
        v = {{0, 0, 0}}, \(v = o[\([1]\)];\)]; \[IndentingNewLine] (*\ \(v = 
            v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                  y};\)\ *) \[IndentingNewLine]If[Length[o] > 1, 
        rad = o[\([2]\)], rad = 1]; \[IndentingNewLine]v = 
        Partition[Flatten[v], 3]; \[IndentingNewLine]v = 
        Select[Map[pointInPlotRange, v], 
          ListQ];\[IndentingNewLine]*) \)\(\[IndentingNewLine]\)\)\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["writeobj2  more primatives", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s7"],

Cell[CellGroupData[{

Cell["disk", "Subsubsection"],

Cell[BoxData[
    \(\(writeobj2["\<rDisk\>", vl_] := XrDisk[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrDisk, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell["\<\
doesn't do
\t(x,y), r, (ang1, ang2) partial disc
\t(x,y) (r1,r2) elliptical disc 
Disk[{x, y}, r]
\tis a two-dimensional graphics primitive that 
\trepresents a filled disk of radius r centered at the point x, y.
Disk[{x, y}]
\tgives a disk of radius 1.
Disk[{x, y}, r, {1, 2}]
\tgives a segment of a disk.
Disk[{x, y}, {rx, ry}]
\tgives an elliptical disk with semi-axes of lengths and , 
\toriented parallel to the coordinate axes.
Disk[] is equivalent to Disk[{0, 0}].\
\>", "Text"],

Cell[BoxData[
    \(\(XrDisk[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, rad, x, y, center, 
            norm, segangle, semiaxis, 
            str}, \[IndentingNewLine] (*\ \(Print["\<### Disk \>", 
                vl];\)\ *) \[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]segangle = Null; 
          semiaxis = Null; \[IndentingNewLine]If[v === {}, 
            v = {{0, 0}}]; \[IndentingNewLine]norm = {0, 1, 
              0}; \[IndentingNewLine]center = 
            v[\([1]\)]; \[IndentingNewLine]rad = 1; \[IndentingNewLine]If[
            Length[v] > 
              1, \[IndentingNewLine]\(If[
                Head@v[\([2]\)] =!= List, \[IndentingNewLine]rad = 
                  v[\([2]\)]; 
                If[Length[v] > 2, 
                  segangle = v[\([3]\)]], \[IndentingNewLine]semiaxis = 
                  v[\([2]\)]];\)]; \[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]center = 
              center /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(center = 
                center /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]center = pointInPlotRange[center]; \[IndentingNewLine]If[
            center \[Equal] Null, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            if\ drawing\ as\ poly; \ 
            ie\ cant\ do\ csg\ segangle\ for\ now;\ *) \[IndentingNewLine]If[
            raycsg === False || 
              segangle =!= Null, \[IndentingNewLine]Module[{u, g, r, gr, 
                primcount2 = primcount}, \[IndentingNewLine]If[
                segangle === Null, r = {\(-\[Pi]\), \[Pi]}, 
                r = segangle]; \[IndentingNewLine]g = 
                ParametricPlot[{rad\ Cos[u] + center[\([1]\)], 
                    rad\ Sin[u] + center[\([3]\)]}, {u, r[\([1]\)], 
                    r[\([2]\)]}, DisplayFunction \[Rule] Identity, 
                  PlotRange \[Rule] 
                    Drop[pr, {2, 2}]]; \[IndentingNewLine]g[\([1]\)] = 
                g[\([1]\)] /. Line \[Rule] Polygon; \[IndentingNewLine]If[
                segangle =!= Null, \[IndentingNewLine]g[\([1, 1, 1, 1]\)] = 
                  Append[g[\([1, 1, 1, 1]\)], {center[\([1]\)], 
                      center[\([3]\)]}]; \[IndentingNewLine]g[\([1, 1, 1, 
                      1]\)] = 
                  Prepend[
                    g[\([1, 1, 1, 1]\)], {center[\([1]\)], 
                      center[\([3]\)]}];\[IndentingNewLine]]; \
\[IndentingNewLine] (*\ \(Show[g, 
                    DisplayFunction \[Rule] $DisplayFunction];\)\ \
*) \[IndentingNewLine]\[IndentingNewLine] (*\ 
                eclectically\ scale\ here\ v . \ 
                    after\ instanciation; \[IndentingNewLine]oops\ its\ \
harder\ for\ pov; \ 
                see\ also\ notes\ after\ circle;\ *) \[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<list\>"], \[IndentingNewLine]gr = "\<gr\>" <> 
                    ToString@grcount <> 
                    ToString@primcount; \[IndentingNewLine]writeNums[
                  file, "\<#declare \>" <> 
                    gr <> "\< = union {\>"]\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]writeobj["\<List\>", 
                Unevaluated[{g}]]; \[IndentingNewLine]If[
                primcount2 == primcount, \[IndentingNewLine] (*\ 
                  empty\ error; \ 
                  use\ normal\ not\ usually\ visible\ \
*) \[IndentingNewLine]\(If[
                    raypov === False, \[IndentingNewLine]Write[
                      file, "\<disc  .00001  0 0 0   0 0 1\>"]\
\[IndentingNewLine], \[IndentingNewLine]Write[
                      file, "\<disc  { <0, 0, 0> <0, 0, 1>  .00001 } \>"]\
\[IndentingNewLine]];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<end\>"]; \[IndentingNewLine]If[semiaxis =!= Null, 
                  writeNums[
                    file, "\<scale \>", \
\[IndentingNewLine]{semiaxis[\([1]\)], semiaxis[\([2]\)], 
                      1}]];\[IndentingNewLine], \[IndentingNewLine]writeNums[
                  file, "\<}\>"]; \[IndentingNewLine]writeNums[
                  file, "\<object { \>" <> gr]; \[IndentingNewLine]If[
                  semiaxis =!= Null, 
                  writeNums[
                    file, "\<scale \>", \
\[IndentingNewLine]{semiaxis[\([1]\)], semiaxis[\([2]\)], 
                      1}]]; \[IndentingNewLine]writeNums[
                  file, "\<}\>"];\[IndentingNewLine]];\[IndentingNewLine]\
\[IndentingNewLine]]; \[IndentingNewLine]primcount += 
              1; \[IndentingNewLine]Return[];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]writeNums[file, "\<disc \>", 
              surfstore[\([Length[
                    surfstore]]\)]]; \[IndentingNewLine]writeNumsFastR[rad, 
              center]; \[IndentingNewLine]writeNumsFast[
              norm]; \[IndentingNewLine]If[
              semiaxis =!= 
                Null, \(writeNums[
                  file, "\<scale \>", {semiaxis[\([1]\)], semiaxis[\([2]\)], 
                    1}];\)]; \[IndentingNewLine]applyTexture["\<planar\>", 
              center]; \[IndentingNewLine]writetrans[
              file];\[IndentingNewLine], \[IndentingNewLine]Write[
              file, "\<disc  { \>"]; \[IndentingNewLine]writeNums[file, 
              center, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
              norm]; \[IndentingNewLine]writeNums[file, 
              rad]; \[IndentingNewLine]applyTexture["\<planar\>", 
              center]; \[IndentingNewLine]writesurfPOV[
              file]; \[IndentingNewLine]If[
              semiaxis =!= 
                Null, \(writeNums[
                  file, "\<scale \>", {semiaxis[\([1]\)], semiaxis[\([2]\)], 
                    1}];\)]; \[IndentingNewLine]writetrans[
              file]; \[IndentingNewLine]Write[
              file, "\<}\>"];\[IndentingNewLine]\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]primcount += 
            1;\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{

Cell["disc", "Subsubsection"],

Cell[BoxData[
    \(\(writeobj2["\<rdisc\>", vl_] := Xrdisc[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[Xrdisc, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell["\<\
rdisc[ r, {x, y, z}, {xn, yn, zn} [ , { x , y , z } ] ]
\tis a two-dimensional graphics primitive that 
\trepresents a disk of radius r centered at the point x, y, z
\thaving normal xn, yn, zn.  Used by ie CapForm.\
\>", "Text"],

Cell[BoxData[
    \(\(Xrdisc[
          vl_] := \[IndentingNewLine]Module[{inc, len, rad, center, 
            semiaxis}, \[IndentingNewLine] (*\ \(Print["\<### disc \>", 
                vl];\)\ *) \[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]len = 
            Length@v; \[IndentingNewLine]If[len < 3, 
            Return[]]; \[IndentingNewLine]rad = 
            v[\([1]\)]; \[IndentingNewLine]center = 
            v[\([2]\)]; \[IndentingNewLine]center = 
            pointInPlotRange[center]; \[IndentingNewLine]If[
            center \[Equal] Null, Return[]]; \[IndentingNewLine]norm = 
            v[\([3]\)]; \[IndentingNewLine]semiaxis = 
            Null; \[IndentingNewLine]If[len > 3, 
            semiaxis = v[\([4]\)]]; \[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]writeNums[file, "\<disc \>", 
              surfstore[\([Length[
                    surfstore]]\)]]; \[IndentingNewLine]writeNumsFastR[rad, 
              center]; \[IndentingNewLine]writeNumsFast[
              norm]; \[IndentingNewLine]If[semiaxis =!= Null, 
              writeNums[file, "\<scale \>", 
                semiaxis]]; \[IndentingNewLine]writetrans[
              file];\[IndentingNewLine], \[IndentingNewLine]Write[
              file, "\<disc  { \>"]; \[IndentingNewLine]writeNums[file, 
              center, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
              norm]; \[IndentingNewLine]writeNums[file, 
              rad]; \[IndentingNewLine]writesurfPOV[
              file]; \[IndentingNewLine]If[semiaxis =!= Null, 
              writeNums[file, "\<scale \>", 
                semiaxis]]; \[IndentingNewLine]writetrans[
              file]; \[IndentingNewLine]Write[
              file, "\<}\>"];\[IndentingNewLine]]; \
\[IndentingNewLine]primcount += 1;\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{

Cell["circle", "Subsubsection"],

Cell["\<\
Circle[{x, y}, r]
\tis a two-dimensional graphics primitive that 
\trepresents a circle of radius r centered at the point x, y.
Circle[{x, y}]
\tgives a circle of radius 1.
Circle[{x, y}, r, {1, 2}]
\tgives a circular arc.
Circle[{x, y}, {rx, ry}]
\tgives an ellipse with semi-axes of lengths and , oriented parallel to the \
coordinate axes.
Circle[] is equivalent to Circle[{0, 0}]
\
\>", "Text"],

Cell[BoxData[
    \(\(writeobj2["\<rCircle\>", vl_] := XrCircle[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrCircle, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrCircle[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, rad, x, y, center, 
            norm, segangle, semiaxis, 
            str}, \[IndentingNewLine] (*\ \(Print["\<### Circle \>", 
                vl];\)\ *) \[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]segangle = Null; 
          semiaxis = Null; \[IndentingNewLine]If[v === {}, 
            v = {{0, 0}}]; \[IndentingNewLine]norm = {0, 1, 
              0}; \[IndentingNewLine]center = 
            v[\([1]\)]; \[IndentingNewLine]rad = 1; \[IndentingNewLine]If[
            Length[v] > 
              1, \[IndentingNewLine]\(If[
                Head@v[\([2]\)] =!= List, \[IndentingNewLine]rad = 
                  v[\([2]\)]; 
                If[Length[v] > 2, 
                  segangle = v[\([3]\)]], \[IndentingNewLine]semiaxis = 
                  v[\([2]\)]];\)]; \[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]center = 
              center /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(center = 
                center /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]center = pointInPlotRange[center]; \[IndentingNewLine]If[
            center \[Equal] Null, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            draw\ as\ lines\ or\ tubes; \ 
            cant\ do\ csg\ segangle\ for\ now;\ *) \[IndentingNewLine]If[
            raycsg === False || 
              segangle =!= Null, \[IndentingNewLine]Module[{u, g, r, gr, 
                primcount2 = primcount}, \[IndentingNewLine]If[
                segangle === Null, r = {\(-\[Pi]\), \[Pi]}, 
                r = segangle]; \[IndentingNewLine]g = 
                ParametricPlot[{rad\ Cos[u] + center[\([1]\)], 
                    rad\ Sin[u] + center[\([3]\)]}, {u, r[\([1]\)], 
                    r[\([2]\)]}, DisplayFunction \[Rule] Identity, 
                  PlotRange \[Rule] 
                    Drop[pr, {2, 2}]]; \[IndentingNewLine] (*\ \(Show[g, 
                    DisplayFunction \[Rule] $DisplayFunction];\)\ \
*) \[IndentingNewLine]\[IndentingNewLine] (*\ 
                eclectically\ scale\ here\ v . \ 
                    after\ instanciation; \[IndentingNewLine]oops\ its\ \
harder\ for\ pov;\ *) \[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<list\>"], \[IndentingNewLine]gr = "\<gr\>" <> 
                    ToString@grcount <> 
                    ToString@primcount; \[IndentingNewLine]writeNums[
                  file, "\<#declare \>" <> 
                    gr <> "\< = union {\>"]\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]writeobj["\<List\>", 
                Unevaluated[{g}]]; \[IndentingNewLine]If[
                primcount2 == primcount, \[IndentingNewLine] (*\ 
                  empty\ error; \ 
                  use\ normal\ not\ usually\ visible\ \
*) \[IndentingNewLine]\(If[
                    raypov === False, \[IndentingNewLine]Write[
                      file, "\<disc  .00001  0 0 0   0 0 1\>"]\
\[IndentingNewLine], \[IndentingNewLine]Write[
                      file, "\<disc  { <0, 0, 0> <0, 0, 1>  .00001 } \>"]\
\[IndentingNewLine]];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<end\>"]; \[IndentingNewLine]If[semiaxis =!= Null, 
                  writeNums[
                    file, "\<scale \>", \
\[IndentingNewLine]{semiaxis[\([1]\)], semiaxis[\([2]\)], 
                      1}]];\[IndentingNewLine], \[IndentingNewLine]writeNums[
                  file, "\<}\>"]; \[IndentingNewLine]writeNums[
                  file, "\<object { \>" <> gr]; \[IndentingNewLine]If[
                  semiaxis =!= Null, 
                  writeNums[
                    file, "\<scale \>", \
\[IndentingNewLine]{semiaxis[\([1]\)], semiaxis[\([2]\)], 
                      1}]]; \[IndentingNewLine]writeNums[
                  file, "\<}\>"];\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]primcount += 
              1; \[IndentingNewLine]Return[];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine] (*\ 
              a\ little\ hard\ in\ rayshade\ *) \[IndentingNewLine] (*\ 
              draw\ as\ solid\ *) \[IndentingNewLine]\(If[
                raycsg === True, \[IndentingNewLine]writeNums[
                  file, "\<difference\>"]; \[IndentingNewLine]\
\[IndentingNewLine]writeNums[file, "\<list\>"]; \[IndentingNewLine]writeNums[
                  file, "\<cylinder \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFastV[{rad, center - {0, linewidth/2, 0}, 
                    center + {0, linewidth/2, 
                        0}}]; \[IndentingNewLine]writeNums[file, "\<disc \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFastV[{rad, center + {0, linewidth/2, 0}, 
                    norm}]; \[IndentingNewLine]writeNums[file, "\<disc \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFastV[{rad, 
                    center - {0, linewidth/2, 
                        0}, \(-norm\)}]; \[IndentingNewLine]writeNums[
                  file, "\<end\>"]; \
\[IndentingNewLine]\[IndentingNewLine]writeNums[
                  file, "\<list\>"]; \[IndentingNewLine]writeNums[
                  file, "\<cylinder \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFastV[{rad - linewidth/2, 
                    center - {0, linewidth/2, 0}, 
                    center + {0, linewidth/2, 
                        0}}]; \[IndentingNewLine]writeNums[file, "\<disc \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFastV[{rad - linewidth/2, 
                    center + {0, linewidth/2, 0}, 
                    norm}]; \[IndentingNewLine]writeNums[file, "\<disc \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \
\[IndentingNewLine]writeNumsFastV[{rad - linewidth/2, 
                    center - {0, linewidth/2, 
                        0}, \(-norm\)}]; \[IndentingNewLine]writeNums[
                  file, "\<end\>"]; \
\[IndentingNewLine]\[IndentingNewLine]writeNums[
                  file, "\<end\>"]; \[IndentingNewLine]If[
                  semiaxis =!= 
                    Null, \(writeNums[
                      file, "\<scale \>", {semiaxis[\([1]\)], 
                        semiaxis[\([2]\)], 
                        1}];\)]; \
\[IndentingNewLine]applyTexture["\<planar\>", 
                  center]; \[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine]];\)\[IndentingNewLine], \
\[IndentingNewLine]Write[file, "\<disc  { \>"]; \[IndentingNewLine]writeNums[
              file, center, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
              norm]; \[IndentingNewLine]writeNums[file, 
              rad]; \[IndentingNewLine]writeNums[file, 
              rad - linewidth]; \[IndentingNewLine]applyTexture["\<planar\>", 
              center]; \[IndentingNewLine]writesurfPOV[
              file]; \[IndentingNewLine]If[
              semiaxis =!= 
                Null, \(writeNums[
                  file, "\<scale \>", {semiaxis[\([1]\)], semiaxis[\([2]\)], 
                    1}];\)]; \[IndentingNewLine]writetrans[
              file]; \[IndentingNewLine]Write[
              file, "\<}\>"];\[IndentingNewLine]];\[IndentingNewLine]\
\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[{
    \( (*\ \(how\ to\ do\ scale\ after\ instanciation;\)\ *) \
\[IndentingNewLine] (*\ "\<broken\>"\ it\ will\ apply\ to\ all\ list\ \
Graphics[{g, g2, 
            g2}]\ *) \[IndentingNewLine]\(str = "\<\>";\)\), "\
\[IndentingNewLine]", 
    \(\(writeNums2[
        str, "\<scale \>", {semiaxis[\([1]\)], semiaxis[\([2]\)], 
          1}];\)\), "\[IndentingNewLine]", 
    \(\(applytrans[str];\)\[IndentingNewLine]\[IndentingNewLine] (*\ 
      that\ is\ why\ Text\ creates\ a\ new\ name\ *) \), \
"\[IndentingNewLine]", 
    \(\(Write2[
        objadd, "\<name gr\>" <> 
          ToString[\(++grcount\)]];\)\), "\[IndentingNewLine]", 
    \(\(Write2[
        objadd, "\<list /* Text */\>"];\)\[IndentingNewLine] (*\  ... \ *) \
\), "\[IndentingNewLine]", 
    \(\(applytrans[str];\)\), "\[IndentingNewLine]", 
    \(\(Write2[objadd, "\<end /* Text */\>"];\)\)}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rectangle", "Subsubsection"],

Cell["\<\
Rectangle[{xmin, ymin}, {xmax, ymax}]
\tis a two-dimensional graphics primitive that 
\trepresents a filled rectangle, oriented parallel to the axes.
Rectangle[{xmin, ymin}]
\tcorresponds to a unit square with its bottom-left corner at .
Rectangle[] is equivalent to Rectangle[{0, 0}]
\
\>", "Text"],

Cell[BoxData[
    \(\(writeobj2["\<rRectangle\>", vl_] := XrRectangle[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrRectangle, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrRectangle[vl_] := 
        Module[{p1, p2, inc, g, center, pr1, pr2, gpr1, gpr2, bc, str, 
            gpr}, \[IndentingNewLine]\[IndentingNewLine] (*\ \(Print["\<### \
Rectangle \>", \ vl];\)\ *) \[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]If[v === {}, 
            v = {{0, 0}, {1, 1}}]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]If[len === 1, 
            v = {v[\([1]\)], v[\([1]\)] + {1, 1}}; 
            len = 2]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            does\ g\ if\ g\ is\ given\ *) \[IndentingNewLine]If[
            len === 3, \[IndentingNewLine]\[IndentingNewLine] (*\ 
              PlotRegion\ does\ not\ change\ pts\ wish\ it\ did\ \
*) \[IndentingNewLine]g = 
              Show[v[\([3]\)], 
                DisplayFunction \[Rule] Identity]; \[IndentingNewLine]gpr = 
              PlotRange /. AbsoluteOptions[g]; \[IndentingNewLine]g = 
              v[\([3]\)]; \[IndentingNewLine]\[IndentingNewLine]center = \
\((v[\([1]\)] + v[\([2]\)])\)/2; \[IndentingNewLine]{pr1, pr2} = 
              nbaspect3[\[IndentingNewLine]{{v[\([1, 1]\)], 
                    v[\([2, 1]\)]}, {v[\([1, 2]\)], 
                    v[\([2, 2]\)]}}]; \[IndentingNewLine]{gpr1, gpr2} = 
              nbaspect3[gpr]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
              this\ empty\ is\ for\ rect\ *) \[IndentingNewLine]If[
              raypov === False, \[IndentingNewLine]Write[
                file, "\<disc  .00001  0 0 0   0 0 1\>"]\[IndentingNewLine], \
\[IndentingNewLine]Write[
                file, "\<disc  { <0, 0, 0> <0, 0, 1>  .00001 } \>"]\
\[IndentingNewLine]]; \[IndentingNewLine]\(++primcount\); \[IndentingNewLine]\
\(++grcount\); \[IndentingNewLine]inc = pr; \  (*\ 
              shouldnt\ need\ but\ to\ be\ safe\ *) \[IndentingNewLine]pr = \
{gpr[\([1]\)], {\(- .001\),  .001}, 
                gpr[\([2]\)]}; \
\[IndentingNewLine]\[IndentingNewLine]writeobj["\<List\>", 
              Hold[{g}]]; \[IndentingNewLine]\[IndentingNewLine]pr = 
              inc; \[IndentingNewLine]\(--grcount\); \[IndentingNewLine]str = \
"\<\>"; \[IndentingNewLine]writeNums2[
              str, "\<\ttranslate \>", {\(-\((Plus @@ gpr[\([1]\)])\)\)/2, 
                0, \(-\((Plus @@ gpr[\([2]\)])\)\)/
                  2}]; \[IndentingNewLine]writeNums2[
              str, "\<\tscale \>", {pr1/gpr1, 1, 
                pr2/gpr2}]; \[IndentingNewLine]\[IndentingNewLine]If[
              NumberQ[rayoverlay] === True, \[IndentingNewLine]writeNums2[
                str, "\<\ttranslate \>", {center[\([1]\)], rayoverlay, 
                  center[\([2]\)]}]; \[IndentingNewLine]rayoverlay += 
                ola;\[IndentingNewLine], \[IndentingNewLine]\(writeNums2[
                  str, "\<\ttranslate \>", {center[\([1]\)], 0, 
                    center[\([2]\)]}];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]applytrans[
              str]; \[IndentingNewLine]\(Return[];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]v[\([1]\)] = 
              v[\([1]\)] /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]v[\([2]\)] = 
              v[\([2]\)] /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]v[\([1]\)] = 
              v[\([1]\)] /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                    y}; \[IndentingNewLine]v[\([2]\)] = 
              v[\([2]\)] /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                    y};\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            len >= 2, \[IndentingNewLine]For[inc = 2, inc \[LessEqual] len, 
              inc += 2, \[IndentingNewLine]p1 = 
                v[\([inc - 1]\)]; \[IndentingNewLine]p2 = 
                v[\([inc]\)]; \[IndentingNewLine]p1 = 
                pointInPlotRange[p1]; \[IndentingNewLine]If[p1 === Null, 
                Continue[]]; \[IndentingNewLine]p2 = 
                pointInPlotRange[p2]; \[IndentingNewLine]If[p2 === Null, 
                Continue[]]; \
\[IndentingNewLine]\[IndentingNewLine]p1[\([2]\)] += \(-linewidth\)/
                  2; \[IndentingNewLine]p2[\([2]\)] += 
                linewidth/2; \[IndentingNewLine]\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]Write[
                  file, "\<box  \>" <> 
                    surfstore[\([Length[
                          surfstore]]\)]]; \[IndentingNewLine]writeNumsFast[
                  p1]; \[IndentingNewLine]writeNumsFast[
                  p2]; \[IndentingNewLine]applyTexture["\<planar\>", \((p1 + 
                        p2)\)/2]; \[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine], \[IndentingNewLine]Write[
                  file, "\<box { \>"]; \[IndentingNewLine]writeNums[file, 
                  p1]; \[IndentingNewLine]writeNums[file, 
                  p2]; \[IndentingNewLine]applyTexture["\<planar\>", \((p1 + 
                        p2)\)/2]; \[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]Write[
                  file, "\<}\>"];\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]\(++primcount\);\[IndentingNewLine]];\[IndentingNewLine]];\
\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[{
    \( (*\[IndentingNewLine]Print["\<c=\>", 
        center]; \[IndentingNewLine]Print["\<bc=\>", 
        bc]; \[IndentingNewLine]Print["\<pr1=\>", 
        pr1]; \[IndentingNewLine]Print["\<pr2=\>", 
        pr2]; \[IndentingNewLine]Print["\<gpr=\>", 
        gpr]; \[IndentingNewLine]Print["\<gpr1=\>", 
        gpr1]; \[IndentingNewLine]Print["\<gpr2=\>", 
        gpr2];\[IndentingNewLine]*) \
\[IndentingNewLine]\[IndentingNewLine]\(Print[{{v[\([1, 1]\)], 
            v[\([2, 1]\)]}, {v[\([1, 2]\)], 
            v[\([2, 2]\)]}}];\)\), "\[IndentingNewLine]", 
    \(\(center = {{v[\([1, 1]\)], v[\([2, 1]\)]} + {v[\([1, 2]\)], 
                v[\([2, 2]\)]}}/2;\)\), "\[IndentingNewLine]", 
    \(\(bc = 
        boxcenter~
          Drop~{2, 2};\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(PlotRegion \[Rule] {\[IndentingNewLine]{\(-pr1\), pr1}/
          2, \[IndentingNewLine]{\(-pr2\), pr2}/
          2\[IndentingNewLine]}\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \({\[IndentingNewLine]{v[\([1, 1]\)], 
        v[\([2, 1]\)]}, \[IndentingNewLine]{v[\([1, 2]\)], 
        v[\([2, 2]\)]}\[IndentingNewLine]} (*\ \(,\)\(PlotRange \[Rule] 
        Drop[pr, {2, 2}]\)\ *) \)}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["cone", "Subsubsection"],

Cell["\<\
Cone[{{x1, y1, z1}, {x2, y2, z2}}, r]
\trepresents a cone with a base of radius r centered at and a tip at .
Cone[{{x1, y1, z1}, {x2, y2, z2}}]
\trepresents a cone with a base of radius 1.
# Cone[] is equivalent to Cone[{{0, 0, -1}, {0, 0, 1}}].
# Cone[{spec1, spec2, ...}] represents a collection of cones with base radius \
.
# Cone[{spec1, spec2, ...}, r] represents a collection of cones with base \
radius r.
# Cone[{spec1, spec2, ...}, {r1, r2, ...}] represents a collection of cones \
with specifications and base radii .\
\>", "Text"],

Cell[BoxData[
    \(\(writeobj2["\<rCone\>", vl_] := XrCone[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrCone, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrCone[
          vl_] := \[IndentingNewLine]Module[{inc, len, v, rad, x, y, p1, p2, 
            radv, cap}, \[IndentingNewLine] (*\ \(Print["\<### Cone \>", 
                vl];\)\ *) \[IndentingNewLine]\[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]If[v === {}, 
            v = {{{0, 0, \(-1\)}, {0, 0, 1}}}]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]If[
            len > 1, \[IndentingNewLine]v[\([1]\)] = 
              Partition[Flatten[v[\([1]\)]], 3]; \[IndentingNewLine]len = 
              Length[v[\([1]\)]]; \[IndentingNewLine]If[
              Length[v[\([2]\)]] >= 1, \[IndentingNewLine]radv = 
                v[\([2]\)], \(radv = 
                  Table[v[\([2]\)], {inc, 1, 
                      len/2}];\)\[IndentingNewLine]]; \[IndentingNewLine]v = 
              v[\([1]\)];\[IndentingNewLine], \[IndentingNewLine]v = 
              Partition[Flatten[v], 3]; \[IndentingNewLine]len = 
              Length[v]; \[IndentingNewLine]radv = 
              Table[1, {inc, 1, 
                  len/2}];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            len >= 2, \[IndentingNewLine]\[IndentingNewLine]If[
              Length[mathfunstore] > 0, \[IndentingNewLine]cap = 
                CapForm /. 
                  mathfunstore[\([Length[
                        mathfunstore]]\)]]; \[IndentingNewLine]\
\[IndentingNewLine]For[inc = 2, inc \[LessEqual] len, 
              inc += 2, \[IndentingNewLine]p1 = 
                v[\([inc - 1]\)]; \[IndentingNewLine]p2 = 
                v[\([inc]\)]; \[IndentingNewLine]p1 = 
                pointInPlotRange[p1]; \[IndentingNewLine]If[p1 === Null, 
                Continue[]]; \[IndentingNewLine]p2 = 
                pointInPlotRange[p2]; \[IndentingNewLine]If[p2 === Null, 
                Continue[]]; \[IndentingNewLine]rad = 
                radv[\([inc/
                      2]\)]; \[IndentingNewLine] (*\[IndentingNewLine]Print["\
\<r=\>", rad]; \[IndentingNewLine]Print["\<p1=\>", 
                  p1]; \[IndentingNewLine]Print["\<p2=\>", 
                  p2];\[IndentingNewLine]*) \[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]writeNums[
                  file, "\<cone \>", 
                  surfstore[\([Length[
                        surfstore]]\)]]; \[IndentingNewLine]writeNumsFastR[
                  rad, p1]; \[IndentingNewLine]writeNumsFastR[0, 
                  p2]; \[IndentingNewLine]applyTexture["\<cylindrical\>", \
\((p1 + p2)\)/2]; \[IndentingNewLine]writetrans[
                  file];\[IndentingNewLine], \[IndentingNewLine]Write[
                  file, "\<cone  { \>"]; \[IndentingNewLine]writeNums[file, 
                  p1, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  rad, \ "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  p2, \ "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                  0]; \[IndentingNewLine]Write[
                  file, "\< open \>"]; \
\[IndentingNewLine]applyTexture["\<cylindrical\>", \((p1 + p2)\)/
                    2]; \[IndentingNewLine]writesurfPOV[
                  file]; \[IndentingNewLine]writetrans[
                  file]; \[IndentingNewLine]Write[
                  file, "\<}\>"];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
                put\ on\ endcap\  /. \ 
                  options\ here\ *) \[IndentingNewLine]\(If[\ 
                  cap =!= CapForm && 
                    cap[\([1]\)] =!= None, \[IndentingNewLine]If[
                    cap[\([1]\)] \[Equal] "\<Butt\>", \[IndentingNewLine]x = 
                      magnitude[\((p2 - p1)\)]; \[IndentingNewLine]If[
                      Chop@x === 0, 
                      x =  .001]; \[IndentingNewLine]cu = \((p2 - p1)\)/
                        x; \[IndentingNewLine]Xrdisc[{rad, 
                        p1, \(-cu\)}];\[IndentingNewLine]]; \
\[IndentingNewLine]If[cap[\([1]\)] \[Equal] "\<Round\>", 
                    XrSphere[{p1, 
                        rad}]];\[IndentingNewLine]];\)\[IndentingNewLine]\
\[IndentingNewLine]]; \[IndentingNewLine]primcount += 
              len;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s7"],

Cell[BoxData[
    \( (*\[IndentingNewLine]v = \(ReleaseHold[
            vl]\)[\([1]\)]; \[IndentingNewLine]If[NumericQ[Last[v]], 
        rad = Last[v]; v = Drop[v, \(-1\)]\[IndentingNewLine], 
        rad = 1]; \[IndentingNewLine]If[v === {}, 
        Return[]]; \[IndentingNewLine] (*\ \(If\)\([\)\(\(twospace === 
            True\)\(,\)\)\(\ \)*) \[IndentingNewLine]v = 
        v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
              y}; \[IndentingNewLine]v = 
        Partition[Flatten[v], 3]; \[IndentingNewLine]len = 
        Length[v];\[IndentingNewLine]*) \)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["arrow", "Subsubsection"],

Cell["\<\
Arrow[ p1,p2, opts ]
\tHeadLength , HeadWidth , HeadCenter
\tHeadScaling->Automatic | Relative
rArrow[ {p1,p2,...}, opts ]
rArrow[ Cylinder[...] , opts ]
Arrow[ p1,p2, s ] ; s->headcenter
no: Arrow[ p1,p2,{s1,s2} ] undetectable
may not need rArrow if using mm9 , may work as is\
\>", "Text"],

Cell[BoxData[
    \(\(writeobj2["\<rArrow\>", vl_] := XrArrow[vl];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrArrow, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrArrow[vl_] := 
        Module[{inc, v, u, mu, rad, add, ma, p0, p1, p2, headscaling, 
            headlength, headwidth, headcenter, lopts, cone, x, k, w, len, 
            len2}, \[IndentingNewLine]\[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]x = Position[v, Rule]; 
          lopts = {}; \[IndentingNewLine]If[
            x =!= {} && IntegerQ@x[\([1, 1]\)], \[IndentingNewLine]x = 
              x[\([1, 1]\)] - 1; 
            If[x < 1, Return[]]; \[IndentingNewLine]lopts = 
              Drop[v, x]; \[IndentingNewLine]v = 
              Take[v, x];\[IndentingNewLine]]; \[IndentingNewLine] (*ignore\ \
v9\ setback*) \[IndentingNewLine]If[NumericQ@\(Last@v\), headcenter = Last@v; 
            v = Drop[v, \(-1\)]]; \[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]v = 
              v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(v = 
                v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\[IndentingNewLine]]; \[IndentingNewLine]x = 
            Position[
              v, {x_?NumberQ, y_?NumberQ, 
                z_?NumberQ}]; \[IndentingNewLine]len = 
            Length@x; \[IndentingNewLine]If[len < 1, 
            Return[]]; \[IndentingNewLine]If[len > 1, 
            p0 = v[\([Sequence @@ x[\([1]\)]]\)], 
            p0 = boxcenter]; \[IndentingNewLine]If[len > 1, 
            p1 = v[\([Sequence @@ x[\([len - 1]\)]]\)], 
            p1 = boxcenter]; \[IndentingNewLine]p2 = 
            v[\([Sequence @@ x[\([len]\)]]\)]; \[IndentingNewLine]p0 = 
            pointInPlotRange[p0]; \[IndentingNewLine]If[p0 === Null, 
            Return[]]; \[IndentingNewLine]p1 = 
            pointInPlotRange[p1]; \[IndentingNewLine]If[p1 === Null, 
            Return[]]; \[IndentingNewLine]p2 = 
            pointInPlotRange[p2]; \[IndentingNewLine]If[p2 === Null, 
            Return[]]; \[IndentingNewLine]If[p1 \[Equal] p2, 
            Return[]]; \[IndentingNewLine] (*no\ direction; 
            If[p1 \[Equal] p2, p2 += linewidth/10; 
              v[\([Sequence @@ x[\([len]\)]]\)] += 
                linewidth/10];*) \[IndentingNewLine]u = 
            p2 - p1; \[IndentingNewLine]mu = 
            magnitude[u]; \[IndentingNewLine]If[mu \[NotEqual] 0, 
            u = u/mu]; \[IndentingNewLine]If[
            Length[mathfunstore] > 0, \[IndentingNewLine]rad = 
              AbsoluteThickness /. 
                mathfunstore[\([Length[
                      mathfunstore]]\)]\[IndentingNewLine]]; \
\[IndentingNewLine]If[\[Not] NumberQ[rad], 
            rad = linewidth]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            this\ is\ a\ problem\ of\ mm\ changing\ public\ env\ \
*) \[IndentingNewLine]headlength = \(Graphics`Arrow`HeadLength /. lopts\) /. 
              Options[Arrow]; \[IndentingNewLine]headscaling = \
\(Graphics`Arrow`HeadScaling /. lopts\) /. 
              Options[Arrow]; \[IndentingNewLine]headwidth = \
\(Graphics`Arrow`HeadWidth /. lopts\) /. 
              Options[Arrow]; \[IndentingNewLine]headcenter = \
\(Graphics`Arrow`HeadCenter /. lopts\) /. 
              Options[Arrow]; \[IndentingNewLine]If[\[Not] NumberQ[rad], 
            rad = linewidth]; \[IndentingNewLine]If[\[Not] NumberQ[
                headlength], 
            headlength = 1]; \[IndentingNewLine]If[\[Not] NumberQ[headwidth], 
            headwidth = 
              1/2]; \[IndentingNewLine]If[\[Not] NumberQ[headcenter], 
            headcenter = 1]; \[IndentingNewLine]If[
            headscaling === 
              Graphics`Arrow`Relative, \[IndentingNewLine]headlength *= 
              mu/\((rad\ 4)\), 
            headlength *= 7]; \[IndentingNewLine]headwidth = 
            headlength\ headwidth; \[IndentingNewLine]If[\[Not] NumberQ[
                headlength], 
            headlength = 
              linewidth/10]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            cone\ arg\ *) \[IndentingNewLine]x = 
            u\ rad\ headlength; \[IndentingNewLine]cone = {{p2 + \((1 - 
                        headcenter)\) x, p2 + x}, 
              rad\ headwidth}; \[IndentingNewLine]\[IndentingNewLine]If[
            Head@\(First@v\) === 
              List, \[IndentingNewLine]writeobj["\<rLine\>", {v}], \
\[IndentingNewLine]writeobj["\<List\>", {v}]\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
            rayboxlines === False && 
              raytubelines === 
                False, \[IndentingNewLine]\[IndentingNewLine] (*\ 
              do\ as\ triangle\ *) \[IndentingNewLine]p1 = 
              cone[\([1, 1]\)]; \[IndentingNewLine]p2 = 
              cone[\([1, 2]\)]; \[IndentingNewLine]rad = 
              cone[\([2]\)]; \[IndentingNewLine]\[IndentingNewLine]add = 
              Cross[\((p1 - p2)\), \((eyep - p1)\)]; \[IndentingNewLine]ma = 
              magnitude[add]; \[IndentingNewLine]If[ma \[Equal] 0, 
              ma =  .0001]; \[IndentingNewLine]add = \((rad\ add)\)/
                ma; \[IndentingNewLine] (*\ 
              we\ get\ scaled\ later\ but\ need\ to\ keep\ linewidth\ \
*) \[IndentingNewLine]add /= prasp; \  (*\ 
              If[rayaspect \[Equal] 
                  True]\ *) \[IndentingNewLine]\[IndentingNewLine]If[
              raypov === False, \[IndentingNewLine]Write[
                file, "\<triangle  \>" <> 
                  surfstore[\([Length[
                        surfstore]]\)]]; \[IndentingNewLine]writeNumsFast[
                p1 + add/2]; \[IndentingNewLine]writeNumsFast[
                p2]; \[IndentingNewLine]writeNumsFast[
                p1 - add/2]; \[IndentingNewLine]writetrans[
                file];\[IndentingNewLine], \[IndentingNewLine]Write[
                file, "\<triangle { \>"]; \[IndentingNewLine]writeNums[file, 
                p1 + add/2, "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                p2, \ "\< , \>"]; \[IndentingNewLine]writeNums[file, 
                p1 - add/2]; \[IndentingNewLine]writesurfPOV[
                file]; \[IndentingNewLine]writetrans[
                file]; \[IndentingNewLine]Write[
                file, "\<}\>"];\[IndentingNewLine]];\[IndentingNewLine], \
\[IndentingNewLine]\(XrCone[
                Hold[cone]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\(++primcount\);\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrArrow, HoldAll];\)\)], "Input"],

Cell["\<\
i'd like to shorten line so {p1,p2} is tot length but with mm9 w/o \
knowing object shape: bad idea
(* note: should call writeobj[ \"rLine\"  not  XrLine *)
If[rayboxlines===False&&raytubelines===False, XrLine[{vl}],
\tIf[rayboxlines===True,XrLineBox[{vl}],XrLineTube[{vl}]]];\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["dashing", "Subsubsection"],

Cell["\<\
note: must call XrLine not writeobj[ \"rLine\"  or recursion will \
occur\
\>", "Text"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Dashing[{", "MR"],
  " ",
  StyleBox["}]\n\tspecifies lines should be solid\n", "MR"],
  "\[FilledSmallSquare] ",
  StyleBox["Dashing[{", "MR"],
  "run length , gap length , ...",
  StyleBox["}]\n", "MR"],
  "\tr are taken as successive segment lengths (begin at run)\n\tr are given \
as a fraction of the total width of the graph\n\tr must e between 0 and 1 \
where (1,1) tries to make 2 segments."
}], "Text"],

Cell[BoxData[
    \( (*\ \(writeobj2["\<rDashing\>", vl_] := 
          XrDashing[vl];\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(SetAttributes[XrDashing, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrDashing[vl_] := 
        Module[{inc, v, u, w, rad, add, ma, mu, p1, p2, pt, line, lengthsv, 
            lengthsinc, lengthslen, looplimit, midptlen, lastmidptlen, 
            addedmu, toadd, skip}, \[IndentingNewLine]\[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]\[IndentingNewLine]If[
            NumberQ[rayoverlay] === True, \[IndentingNewLine]v = 
              v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, rayoverlay, 
                    y}; \[IndentingNewLine]rayoverlay += 
              ola;\[IndentingNewLine], \[IndentingNewLine]\(v = 
                v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                      y};\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]v = Partition[Flatten[v], 3]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]\[IndentingNewLine]If[len < 2, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine]If[
            Length[mathfunstore] > 0, \[IndentingNewLine]rad = 
              AbsoluteThickness /. 
                mathfunstore[\([Length[
                      mathfunstore]]\)]; \[IndentingNewLine]lengthsv = 
              Dashing /. 
                mathfunstore[\([Length[
                      mathfunstore]]\)];\[IndentingNewLine]]; \
\[IndentingNewLine]If[\[Not] NumberQ[rad], 
            rad = linewidth]; \[IndentingNewLine]lengthslen = 
            Length[lengthsv]; \[IndentingNewLine]If[lengthslen === 0, 
            lengthsv = { .1}, 
            lengthsv = lengthsv[\([1]\)]]; \[IndentingNewLine]lengthslen = 
            Length[lengthsv]; \[IndentingNewLine]inc = 
            0; \[IndentingNewLine]Scan[\((\[IndentingNewLine]\(If[# < 
                        0 || # > 
                        1, \[IndentingNewLine]Print["\<Argument in Dashing[ \
\>", lengthsv, "\< ] is not a real number between 0 and 1 : gr\>", 
                      grcount, "\< prim \>", 
                      primcount]; \[IndentingNewLine]inc = 
                      1;\[IndentingNewLine]];\)\[IndentingNewLine])\) &, 
            lengthsv]; \[IndentingNewLine]If[inc === 1, 
            Return[]]; \[IndentingNewLine]lengthsv = 
            lengthsv\ scenedepth; \[IndentingNewLine]\[IndentingNewLine]If[
            Plus @@ lengthsv === 
              0, \[IndentingNewLine]\(If[
                rayboxlines === False && 
                  raytubelines === False, \[IndentingNewLine]XrLine[
                  Hold[v]]\[IndentingNewLine], \[IndentingNewLine]If[
                  rayboxlines === True, XrLineBox[Hold[v]], 
                  XrLineTube[
                    Hold[v]]]\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]inc = 
            1; \[IndentingNewLine]add = {0, 0, 
              0}; \[IndentingNewLine]addedmu = 0; \[IndentingNewLine]p1 = 
            v[\([1]\)]; \[IndentingNewLine]p2 = 
            v[\([2]\)]; \[IndentingNewLine]u = 
            p2 - p1; \[IndentingNewLine]mu = 
            magnitude[u]; \[IndentingNewLine]u = 
            u/mu; \[IndentingNewLine]pt = 
            p1; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            entry\ cond\ *) \[IndentingNewLine]line = {{p1}}; \
\[IndentingNewLine]lengthsinc = 0; \[IndentingNewLine]toadd = 
            0; \[IndentingNewLine]midptlen = 0; \[IndentingNewLine]skip = 
            False; \[IndentingNewLine]looplimit = 
            1000; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            oops\ what\ if\ lengthsv\ has\ 0' 
              s\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ \(Print["\<new \
line\>", v];\)\ *) \[IndentingNewLine]\[IndentingNewLine]While[
            inc < len, \[IndentingNewLine]\[IndentingNewLine]If[\(--looplimit\
\) \[LessEqual] 
                0, \[IndentingNewLine]Print["\<oops: looped 1000 dashing line \
gr\>", grcount, "\< prim \>", 
                primcount]; \[IndentingNewLine]Return[];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
              length\ intended\ for\ next\ line\ \((or\ skip)\)\ \
*) \[IndentingNewLine]If[
              addedmu === 
                0, \[IndentingNewLine]\(++lengthsinc\); \[IndentingNewLine]If[
                lengthsinc > lengthslen, 
                lengthsinc = 1]; \[IndentingNewLine]toadd = 
                lengthsv[\([lengthsinc]\)]; \[IndentingNewLine]If[
                toadd === 0, 
                toadd = 
                  linewidth]; \[IndentingNewLine] (*\ \(Print["\<toadd\>", 
                    toadd, "\< mpt=\>", midptlen, "\< mu=\>", 
                    mu];\)\ *) \[IndentingNewLine] (*\ 
                length\ sofar\ dashing\ same\ line\ \
*) \[IndentingNewLine]lastmidptlen = midptlen; \[IndentingNewLine]midptlen += 
                toadd;\[IndentingNewLine], \[IndentingNewLine]lastmidptlen = 
                0; \[IndentingNewLine]midptlen = 
                toadd;\[IndentingNewLine]]; \[IndentingNewLine]add = 
              u\ toadd; \[IndentingNewLine]\[IndentingNewLine]If[
              midptlen > 
                mu, \[IndentingNewLine]\(If[
                  inc + 1 \[GreaterEqual] 
                    len, \[IndentingNewLine] (*\ \(Print["\<last\>"];\)\ \
*) \[IndentingNewLine]inc = len; 
                  pt = Last[v]; \[IndentingNewLine]add = {0, 0, 0}; 
                  toadd = 0;\[IndentingNewLine], \[IndentingNewLine] (*\ 
                    for\ this\ mu\ only\ want\ toadd -= 
                      length\ remaining\ *) \[IndentingNewLine]mu = 
                    mu - lastmidptlen; \[IndentingNewLine] (*\ 
                    toadd\ can\ be\  < \ 
                      mu\ of\ last\ line\ *) \[IndentingNewLine]addedmu = 
                    0; \[IndentingNewLine] (*\ 
                    including\ more\ pts\ until\ long\ enough\ toadd\ \
*) \[IndentingNewLine]While[
                    addedmu === 
                        0 || \((toadd > mu && \(--looplimit\) \[GreaterEqual] 
                            0)\), \[IndentingNewLine]\(If[
                        inc + 1 < 
                          len, \[IndentingNewLine]\(++inc\); \
\[IndentingNewLine]addedmu += mu; \[IndentingNewLine]toadd -= 
                          mu; \[IndentingNewLine] (*\ \(Print["\<    toadd \
rem=\>", toadd, "\< ll=\>", looplimit];\)\ *) \[IndentingNewLine]p1 = 
                          v[\([inc]\)]; \[IndentingNewLine]line = 
                          Append[line, p1]; \[IndentingNewLine]pt = 
                          p1; \[IndentingNewLine]p2 = 
                          v[\([inc + 1]\)]; \[IndentingNewLine]u = 
                          p2 - p1; \[IndentingNewLine]mu = 
                          magnitude[u]; \[IndentingNewLine]u = 
                          u/mu;\[IndentingNewLine], \[IndentingNewLine] (*\ \
\(Print["\<last\>"];\)\ *) \[IndentingNewLine]inc = len; 
                        pt = Last[v]; \[IndentingNewLine]add = {0, 0, 0}; 
                        toadd = 
                          0;\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\(If[inc < len, 
                      Continue[]];\)\[IndentingNewLine]];\)\[IndentingNewLine]\
]; \[IndentingNewLine]\[IndentingNewLine]pt = 
              pt + add; \[IndentingNewLine]line = 
              Append[line, pt]; \[IndentingNewLine]skip = 
              Xor[skip, True]; \[IndentingNewLine]\[IndentingNewLine]If[
              skip === True, \[IndentingNewLine] (*\ \(Print["\<line=\>", 
                    line];\)\ *) \[IndentingNewLine]line = {line}; \
\[IndentingNewLine]If[
                rayboxlines === False && 
                  raytubelines === False, \[IndentingNewLine]XrLine[
                  Hold[line]]\[IndentingNewLine], \[IndentingNewLine]If[
                  rayboxlines === True, XrLineBox[Hold[line]], 
                  XrLineTube[
                    Hold[line]]]\[IndentingNewLine]]; \[IndentingNewLine] (*\ \
\(,\)\(Print["\<skip line=\>", 
                    line];\)\ *) \[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]line = {pt}; \[IndentingNewLine]addedmu = 
              0; \[IndentingNewLine]toadd = 0; \[IndentingNewLine] (*\ 
              do\ not\ reset\ mu\ it\ is\ the\ invariant\ alg\ needs\ \
*) \[IndentingNewLine]];\[IndentingNewLine]\[IndentingNewLine]];\)\)], "Input",\

  InitializationCell->True],

Cell["\<\
note to me:  what to do to have results like mm
\tmm seems to start at p1
\tfollow line irrespective of where line segments begin and end
\t\ta run it shows may be a corner of two joined segments
\t\tand so never joints a line draw across a skipped point
\tdoes not guarantee display of turns or segment of line
\tmaybe not guarantee whether end gets cut
\tdoes not guarantee a clean split in halves
\t\t{Dashing[{1,1}],Circle[{0,0},1]}
\tmay show close does and miss does (again, not clean)
\t\t{Dashing[{0.001,0.1}],Circle[{0,0},1]}\
\>", "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["surf and trans stack modifiers (pseudo primatives)", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s9"],

Cell[CellGroupData[{

Cell["color", "Subsubsection"],

Cell["\<\
Note: in mm v4.0 Gray[] White evalutaes to RGBColor unless held.  \
Hue apparently doesn't.\
\>", "Text",
  CellTags->"s9"],

Cell["\<\
eclectically this section uses both ways to invoke / match args to \
target function without writeobj2\
\>", "Text",
  CellTags->"s9"],

Cell["\<\
NOTE: in general don't use rayshade names unless for compatibility \
with rayglass: rayshade needs all names given before all surfspecs
\tcan join surfspec rayshade won't care (names aside)\
\>", "Text",
  CellTags->"s9"],

Cell[BoxData[
    \( (*\ writeobj2[file_, RGBColor[r_, g_, b_]] := \n
        SetAttributes[XrRGBColor, HoldAll]; \n
      writeobj["\<rRGBColor\>", obj_] := 
        XrRGBColor[obj];\[IndentingNewLine]*) \)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<rRGBColor\>", obj_] := 
        Module[{v}, \[IndentingNewLine]v = 
            ReleaseHold[obj]; \[IndentingNewLine]v[\([0]\)] = 
            Sequence; \[IndentingNewLine]XrRGBColor[
            v];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell["\<\
if mult colors are applied in a group both rayshade and pov can \
take all and will favor last of doubles, though syntax is different\
\>", \
"Text"],

Cell[BoxData[
    \(\(XrAmbient[r_, g_, 
          b_] := \[IndentingNewLine]Module[{surfspec, r2, g2, b2, 
            v}, \[IndentingNewLine]r2 = r~N~maxprecision; 
          g2 = g~N~maxprecision; 
          b2 = b~N~
              maxprecision; \[IndentingNewLine]surfspec = "\<\>"; \
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\(If[
                rayglass === False, \[IndentingNewLine] (*\ 
                  magic\  - \ 
                    1\ will\ wash\ out\ using\ std\ lights\ \
*) \[IndentingNewLine]writeNums2[
                  surfspec, "\< ambient \>", {r2, g2, 
                    b2}]; \[IndentingNewLine]surfstore[\([Length[
                        surfstore]]\)] = 
                  surfstore[\([Length[surfstore]]\)] <> 
                    surfspec;\[IndentingNewLine], \
\[IndentingNewLine]writeNums2[
                  surfspec, "\< glass ambient \>", {r2\  -  .01, g2\  -  .01, 
                    b2 -  .01}]; \[IndentingNewLine]surfstore[\([Length[
                        surfstore]]\)] = 
                  surfspec;\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]If[
            raypov === True, \[IndentingNewLine]If[
              rayglass === False, \[IndentingNewLine]writeNums2[
                surfspec, "\< finish { \>"]; \[IndentingNewLine]writeNums2[
                surfspec, "\< ambient rgb \>", {r2, g2, 
                  b2}]; \[IndentingNewLine]writeNums2[
                surfspec, "\< } \>"];\[IndentingNewLine], \
\[IndentingNewLine]writeNums2[
                surfspec, "\< finish { \>"]; \[IndentingNewLine]writeNums2[
                surfspec, "\< phong 0.7 \>"]; \[IndentingNewLine]writeNums2[
                surfspec, "\< ambient rgb \>", {r2, g2, 
                  b2}]; \[IndentingNewLine]writeNums2[
                surfspec, "\< } \>"];\[IndentingNewLine]]; \
\[IndentingNewLine]surfstore[\([Length[surfstore]]\)] = 
              surfstore[\([Length[surfstore]]\)] <> 
                surfspec;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell["pov   transmit must be embedded whenever pigment is used", "Text"],

Cell[BoxData[
    \(\(XrDiffuse[r_, g_, 
          b_] := \[IndentingNewLine]Module[{surfspec, r2, g2, b2, 
            v}, \[IndentingNewLine]r2 = r~N~maxprecision; 
          g2 = g~N~maxprecision; 
          b2 = b~N~
              maxprecision; \[IndentingNewLine]surfspec = "\<\>"; \
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\(If[
                rayglass === False, \[IndentingNewLine] (*\ 
                  magic\  - \ 
                    1\ will\ wash\ out\ using\ std\ lights\ \
*) \[IndentingNewLine]writeNums2[
                  surfspec, "\< diffuse \>", {r2, g2, 
                    b2}]; \[IndentingNewLine]surfstore[\([Length[
                        surfstore]]\)] = 
                  surfstore[\([Length[surfstore]]\)] <> 
                    surfspec;\[IndentingNewLine], \
\[IndentingNewLine]writeNums2[
                  surfspec, "\< glass ambient \>", {r2\  .17, g2\  .17, 
                    b2\  .17}]; \[IndentingNewLine]surfstore[\([Length[
                        surfstore]]\)] = 
                  surfspec;\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]If[
            raypov === True, \[IndentingNewLine]If[
              rayglass === False && 
                lasttransmit === "\<\>", \[IndentingNewLine]writeNums2[
                surfspec, "\< pigment { color rgb \>", {r2, g2, 
                  b2}]; \[IndentingNewLine]writeNums2[
                surfspec, "\< } \>"];\[IndentingNewLine], \
\[IndentingNewLine]writeNums2[
                surfspec, "\< pigment { color rgb \>", {r2, g2, 
                  b2}]; \[IndentingNewLine]If[
                rayglass === True, \[IndentingNewLine]writeNums2[
                  surfspec, "\< transmit .4 \>"]; \
\[IndentingNewLine]lasttransmit = "\< .4 \>";\[IndentingNewLine], \
\[IndentingNewLine]\(writeNums2[
                    surfspec, "\< transmit \>" <> 
                      lasttransmit];\)\[IndentingNewLine]]; \
\[IndentingNewLine]writeNums2[
                surfspec, "\< } \>"];\[IndentingNewLine]]; \
\[IndentingNewLine]surfstore[\([Length[surfstore]]\)] = 
              surfstore[\([Length[surfstore]]\)] <> 
                surfspec;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrRGBColor[r_, g_, 
          b_] := \[IndentingNewLine]\((\(If[
              raypov === False, \[IndentingNewLine]XrAmbient[r\  .05, 
                g\  .05, b\  .05]; 
              XrDiffuse[r\  .7, g\  .7, 
                b\  .7];\[IndentingNewLine], \[IndentingNewLine]XrAmbient[
                r\  .1, g\  .1, b\  .1]; 
              XrDiffuse[r, g, 
                b];\[IndentingNewLine]];\)\[IndentingNewLine])\);\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrRGBColor[r_, g_, 
          b_] := \[IndentingNewLine]Module[{surfspec, r2, g2, b2, 
            v}, \[IndentingNewLine]r2 = r~N~maxprecision; 
          g2 = g~N~maxprecision; 
          b2 = b~N~maxprecision; \[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\(If[
                rayglass === False, \[IndentingNewLine] (*\ 
                  magic\  - \ 
                    1\ will\ wash\ out\ using\ std\ lights\ \
*) \[IndentingNewLine]surfspec = \[IndentingNewLine]"\< ambient \>" <> 
                    ToString[r2\  .05] <> "\< \>" <> 
                    ToString[g2\  .05] <> "\< \>" <> 
                    ToString[
                      b2\  .05] <> \[IndentingNewLine]"\<  diffuse \>" <> 
                    ToString[r2\  .7] <> "\< \>" <> 
                    ToString[g2\  .7] <> "\< \>" <> 
                    ToString[
                      b2\  .7] <> "\< \>"; \
\[IndentingNewLine]surfstore[\([Length[surfstore]]\)] = 
                  surfstore[\([Length[surfstore]]\)] <> 
                    surfspec;\[IndentingNewLine], \[IndentingNewLine]surfspec \
= "\< glass \>" <> \[IndentingNewLine]"\< ambient \>" <> 
                    ToString[r2\  .04] <> "\< \>" <> 
                    ToString[g2\  .04] <> "\< \>" <> 
                    ToString[
                      b2\  .04] <> \[IndentingNewLine]"\<  diffuse \>" <> 
                    ToString[r2\  .17] <> "\< \>" <> 
                    ToString[g2\  .17] <> "\< \>" <> 
                    ToString[
                      b2\  .17] <> "\< \>"; \
\[IndentingNewLine]surfstore[\([Length[surfstore]]\)] = 
                  surfspec;\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]If[
            raypov === 
              True, \[IndentingNewLine] (*\[IndentingNewLine]\(surfspec = \
\[IndentingNewLine]"\< pigment { color rgb < \>"\[IndentingNewLine] <> 
                    ToString[r2] <> "\< , \>"\[IndentingNewLine] <> 
                    ToString[g2] <> "\< , \>"\[IndentingNewLine] <> 
                    ToString[b2] <> "\< > \>"\[IndentingNewLine] <> 
                    If[rayglass === 
                        True, "\< transmit .4 \>", "\<\>"]\[IndentingNewLine] \
<> "\< } finish { \>"\[IndentingNewLine] <> 
                    If[rayglass === 
                        True, "\< phong 0.7 \>", "\<\>"]\[IndentingNewLine] <> \
"\< ambient rgb < \>"\[IndentingNewLine] <> 
                    ToString[r2\  .1] <> "\< , \>"\[IndentingNewLine] <> 
                    ToString[g2\  .1] <> "\< , \>"\[IndentingNewLine] <> 
                    ToString[
                      b2\  .1]\[IndentingNewLine] <> \ "\< > } \>";\)\
\[IndentingNewLine]*) \[IndentingNewLine]surfspec = "\<\>"; \
\[IndentingNewLine]writeNums2[
              surfspec, "\< pigment { color rgb \>", {r2, g2, 
                b2}]; \[IndentingNewLine]If[rayglass === True, 
              writeNums2[
                surfspec, "\< transmit .4 \>"]]; \
\[IndentingNewLine]writeNums2[
              surfspec, "\< } \>"]; \[IndentingNewLine]writeNums2[
              surfspec, "\< finish { \>"]; \[IndentingNewLine]If[
              rayglass === True, 
              writeNums2[
                surfspec, "\< phong 0.7 \>"]]; \[IndentingNewLine]writeNums2[
              surfspec, "\< ambient rgb \>", {r2\  .1, g2\  .1, 
                b2\  .1}]; \[IndentingNewLine]writeNums2[
              surfspec, "\< } \>"]; \
\[IndentingNewLine]\[IndentingNewLine]surfstore[\([Length[surfstore]]\)] = 
              surfstore[\([Length[surfstore]]\)] <> 
                surfspec;\[IndentingNewLine]];\[IndentingNewLine]];\)\)], \
"Input",
  CellTags->"s9"],

Cell[BoxData[
    \(\(writeobj["\<rGrayLevel\>", obj_] := 
        Module[{v}, \[IndentingNewLine]v = \(ReleaseHold[
                obj]\)[\([1]\)]; \[IndentingNewLine]XrRGBColor[v, v, 
            v]\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrGrayLevel[c_] := XrRGBColor[c, c, c];\)\)], "Input",
  CellTags->"s9"],

Cell["\<\
Hue:     ONLY reason todo it is because many mm examples or \
~Graphics~ output
\tcontain it. Hue[ h ] only , none i know of use Hue[ h,s,b ]\
\>", "Text"],

Cell["\<\
           and HLSColor stopped being distributed 5.2.  uhhhh
... here we go again  ...\
\>", "Text"],

Cell[BoxData[
    \(HuetoRGB[h_] := 
      Module[{x, y, a, r, g, b}, \[IndentingNewLine]a = 
          h; \[IndentingNewLine]If[a < 0, a = \(-a\)]; \[IndentingNewLine]If[
          a > 1, a = a - Floor[a]]; \[IndentingNewLine]a = \((2  Pi\ a)\)/
            Degree; \[IndentingNewLine]a = N@a; \[IndentingNewLine]If[
          a <= $MinPrecision, Return[{1, 0, 0}]]; \[IndentingNewLine]If[
          a >= 360, 
          Return[{1, 0, 0}]]; \[IndentingNewLine]y[m_, x_, x1_, b_] := 
          m \((x - x1)\) + b; \[IndentingNewLine]r[
            a_] := {1, y[\(-1\), a, 120, 0]/60, 0, 0, y[1, a, 240, 0]/60, 
                1}\[IndentingNewLine][\([\)\(Ceiling[a/60]\)\(]\)] // 
            N; \[IndentingNewLine]g[
            a_] := {y[1, a, 0, 0]/60, 1, 1, y[\(-1\), a, 240, 0]/60, 0, 
                0}\[IndentingNewLine][\([\)\(Ceiling[a/60]\)\(]\)] // 
            N; \[IndentingNewLine]b[
            a_] := {0, 0, y[1, a, 120, 0]/60, 1, 1, 
                y[\(-1\), a, 360, 0]/60}\[IndentingNewLine][\([\)\(Ceiling[
                a/60]\)\(]\)] // N; \[IndentingNewLine]N@{r[a], g[a], 
            b[a]}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell["have no idea if this is right", "Text"],

Cell[BoxData[
    \(HuetoRGB[h_, as_, abr_] := 
      Module[{s = as, br = abr, v1, v2, clamp, 
          x}, \[IndentingNewLine]clamp[x_] := 
          If[x < 0, 0, If[x > 1, 1, x]]; \[IndentingNewLine]s = clamp[s]; 
        br = clamp[br]; \[IndentingNewLine]v1 = 
          HuetoRGB[h]; \[IndentingNewLine]v2 = 
          HuetoRGB[
            h +  .5]; \[IndentingNewLine]v1 = \((v1 + v2\ \((1 - s)\))\) 
            br; \[IndentingNewLine]Map[clamp, 
          v1]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj["\<rHue\>", obj_] := 
        Module[{v, len, r, g, b}, \[IndentingNewLine]v = 
            ReleaseHold[obj]; \[IndentingNewLine]{r, g, b} = 
            HuetoRGB[Sequence @@ v]; \[IndentingNewLine]XrRGBColor[r, g, 
            b];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\ v = 
        Graphics`Colors`HLSColor[v,  .5, 1]; \[IndentingNewLine]v[\([0]\)] = 
        Sequence;*) \)], "Input"],

Cell[BoxData[
    \(\(XrHue[c_] := XrHue[c, 1, 1];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrHue[h_, as_, abr_] := 
        Module[{r, g, b}, \[IndentingNewLine]{r, g, b} = 
            HuetoRGB[h, as, abr]; \[IndentingNewLine]XrRGBColor[r, g, 
            b];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"]
}, Closed]],

Cell[CellGroupData[{

Cell["texture", "Subsubsection"],

Cell["\<\
checktexture  can optionally be tested to avoid calling fun \
applyTexture and computing args for nothing , use esp for poly / triag for \
speed , and mostly not bothered with elsewhere\
\>", "Text"],

Cell["note: see Text and Raster Array for comments", "Text"],

Cell[BoxData[
    \(\(writeobj["\<rTextureCoordinateScaling\>", obj_] := 
        XrTextureCoordinateScaling[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(XrTextureCoordinateScaling[
        vl_] := \[IndentingNewLine]Module[{v}, \[IndentingNewLine]v = 
          ReleaseHold[vl]; \[IndentingNewLine]PrependTo[
          mathfunstore[\([Length[mathfunstore]]\)], 
          TextureCoordinateScaling \[Rule] v];\[IndentingNewLine]]\)], "Input",\

  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(writeobj2["\<rTexture\>", obj_] := 
        Module[{v}, \[IndentingNewLine]v = 
            ReleaseHold[obj]; \[IndentingNewLine]v[\([0]\)] = 
            Sequence; \[IndentingNewLine]XrTexture[
            v];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrTexture[obj_] := 
        Module[{g, tmpf, box, tcs, str, xi, yi, 
            tmpf2}, \[IndentingNewLine]\[IndentingNewLine]str = "\<\>"; \
\[IndentingNewLine]tmpf = "\<\>"; \[IndentingNewLine]box = {}; \
\[IndentingNewLine]If[
            Length[mathfunstore] > 0, \[IndentingNewLine]tcs = 
              TextureCoordinateScaling /. 
                mathfunstore[\([Length[
                      mathfunstore]]\)]]; \[IndentingNewLine]\
\[IndentingNewLine]g = Head[obj]; \[IndentingNewLine]If[
            g === RasterArray || g === Raster, \[IndentingNewLine]g = 
              Dimensions[obj]; \[IndentingNewLine]box = {0, g[\([1]\)] - 1, 
                0, g[\([2]\)] - 
                  1};\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            Head[obj] =!= String, \[IndentingNewLine]g = 
              Import[obj]; \[IndentingNewLine]If[
              g \[NotEqual] 
                Null, \[IndentingNewLine]tmpf = \(OpenTemporary[]\)[\([1]\)]; \
\[IndentingNewLine]Close[tmpf]; \[IndentingNewLine]tmpf = 
                tmpf <> "\<.tiff\>"; \[IndentingNewLine]Export[tmpf, 
                g, "\<TIFF\>"]\[IndentingNewLine], \
\[IndentingNewLine]Return[]\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
            Head[obj] === 
              String, \[IndentingNewLine]\(If[
                StringMatchQ[obj, "\<*.rle\>"] === 
                    False && \[IndentingNewLine]StringMatchQ[
                      obj, "\<*.tiff\>"] === 
                    False, \[IndentingNewLine]tmpf = \
\(OpenTemporary[]\)[\([1]\)]; \[IndentingNewLine]Close[
                  tmpf]; \[IndentingNewLine]tmpf = 
                  tmpf <> "\<.tiff\>"; \[IndentingNewLine]Export[tmpf, 
                  obj, "\<TIFF\>"];\[IndentingNewLine] (*\ 
                  we\ cant\ tell\ if\ Export\ bailed\ *) \[IndentingNewLine], \
\[IndentingNewLine]\(tmpf = 
                    obj;\)\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
            tmpf\ is\ now\ a\ string\ of\ file . tiff\ or\ file . 
                rle\ *) \[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False && 
              StringMatchQ[tmpf, "\<*.tiff\>"] === 
                True, \[IndentingNewLine]tmpf = 
              StringReplace[
                tmpf, "\<.tiff\>" \[Rule] "\<\>"]; \[IndentingNewLine]cmd = "\
\<tifftopnm \>" <> tmpf <> "\<.tiff 1> \>" <> 
                
                tmpf <> "\<.pnm\>" <> "\< 2>>/dev/null\>"; \
\[IndentingNewLine]Run[
              cmd]; \[IndentingNewLine]cmd = "\<pnmtorle \>" <> 
                tmpf <> "\<.pnm -o \>" <> 
                tmpf <> "\<.rle\>" <> "\< 2>>/dev/null\>"; \
\[IndentingNewLine]Run[
              cmd];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            raypov === True && StringMatchQ[tmpf, "\<*.tiff\>"] === False, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine]If[
            tcs === True, \[IndentingNewLine]If[
              raypov === False, \[IndentingNewLine]cmd = "\<rlebox \>" <> 
                  tmpf <> "\<.rle\>" <> "\< 1>\>" <> 
                  tmpf <> "\<.box\>"; \[IndentingNewLine]Run[
                cmd]; \[IndentingNewLine]box = 
                Import[tmpf <> "\<.box\>", "\<List\>"];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
              raypov === True, \[IndentingNewLine]g = 
                Import[tmpf, "\<TIFF\>"]; \[IndentingNewLine]tmpf2 = \
\(OpenTemporary[]\)[\([1]\)]; \[IndentingNewLine]Close[
                tmpf2]; \[IndentingNewLine]tmpf2 = 
                tmpf2 <> "\<.xbm\>"; \[IndentingNewLine]Display[tmpf2, 
                cell, "\<Xbitmap\>", 
                ImageResolution \[Rule] 512]; \[IndentingNewLine]g = 
                Import[tmpf2, "\<Xbitmap\>"]; \[IndentingNewLine]box = 
                Dimensions[g[\([1, 1]\)]]; \[IndentingNewLine]box = {0, 
                  box[\([2]\)] - 1, 0, 
                  box[\([1]\)] - 
                    1};\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]xi = \((2.5\ box[\([2]\)]\ 2)\)/\((2630)\)~N~
                  maxprecision; \[IndentingNewLine]yi = \((box[\([4]\)]\  \
.15)\)/\((98)\)~N~maxprecision; \[IndentingNewLine]xi *= 
              sceneAveWidth; \[IndentingNewLine]\(yi *= 
                sceneAveWidth;\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            Length[mathfunstore] > 0, \[IndentingNewLine]g = 
              Textures /. 
                mathfunstore[\([Length[
                      mathfunstore]]\)]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            g =!= Textures && 
              Head[g] === List, \[IndentingNewLine]\(PrependTo[
                mathfunstore[\([Length[mathfunstore]]\)], 
                Textures \[Rule] {g[\([1]\)], {tmpf, xi, yi, 
                      tcs}}];\)\[IndentingNewLine], \
\[IndentingNewLine]\(PrependTo[mathfunstore[\([Length[mathfunstore]]\)], 
                Textures \[Rule] {{tmpf, xi, yi, 
                      tcs}}];\)\[IndentingNewLine]]; \
\[IndentingNewLine]checktexture = True;\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell["\<\
for rayshade we need pos to even try applying texture - and that's \
shape dependant: at least\
\>", "Text"],

Cell[BoxData[
    \(\(applyTexture[method_, pos_] := 
        Module[{tmpf, tcs, xi, 
            yi}, \[IndentingNewLine]\[IndentingNewLine]\(If[
              Length[mathfunstore] > 
                0, \[IndentingNewLine]\(Scan[\[IndentingNewLine]\((\
\[IndentingNewLine]{tmpf, xi, yi, 
                          tcs} = #; \[IndentingNewLine]\[IndentingNewLine]If[
                        raypov === False, \[IndentingNewLine]Write[
                          file, "\<\ttexture image\>"]; \
\[IndentingNewLine]Write[file, "\<\t\>" <> tmpf]; \[IndentingNewLine]Write[
                          file, "\<\tmap \>" <> 
                            method]; \[IndentingNewLine]writeNums[
                          file, "\<\t\>", pos]; \[IndentingNewLine]Write[
                          file, "\<\t0 0 1\>"]; \[IndentingNewLine]Write[
                          file, "\<\t1 0 0\>"]; \[IndentingNewLine]If[
                          tcs === True, \[IndentingNewLine]\(Write[
                              file, "\<\ttile 1 1\>"];\)\[IndentingNewLine], \
\(Write[file, "\<\ttile 0 0\>"];\)\[IndentingNewLine]]; \[IndentingNewLine]If[
                          tcs === True, 
                          writeNums[
                            file, "\<\tscale \>", {xi, 1, 
                              yi}]];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[raypov === True, \[IndentingNewLine]writeNums[
                          file, "\<\tscale \>", {1, 1, 
                            2}]; \[IndentingNewLine]Write[
                          file, "\<\ttexture { \>"]; \[IndentingNewLine]If[
                          method === "\<uv\>", \[IndentingNewLine]"\< \
uv_mapping \>"\[IndentingNewLine]]; \[IndentingNewLine]Write[
                          file, "\<pigment { \>"]; \[IndentingNewLine]Write[
                          file, "\<image_map { \>"]; \[IndentingNewLine]Write[
                          file, "\<\ttiff \"\>" <> 
                            tmpf <> "\<\" \>"]; \[IndentingNewLine]If[
                          tcs === True, 
                          Write[file, "\<\tonce \>"]]; \
\[IndentingNewLine]Write[
                          file, "\<}\>"];  (*close\ image_map\
*) \[IndentingNewLine]writeNums[
                          file, "\<\trotate \>", {30, 0, 
                            0}]; \[IndentingNewLine]Write[
                          file, "\<\t} }\>"];  (*close\ pigment\
*) \[IndentingNewLine]If[tcs === True, 
                          writeNums[
                            file, "\<\tscale \>", {xi, 1, 
                              yi/2}]]; \[IndentingNewLine] (*apparently\ \
already\ glued*) \[IndentingNewLine] (*\(writeNums[file, "\<\ttranslate \>", 
                              pos];\)*) \[IndentingNewLine] (*\(Write[
                              file, "\<}\>"];\)*) \  (*close\ texture\
*) \[IndentingNewLine]];\[IndentingNewLine]\[IndentingNewLine])\) &\
\[IndentingNewLine], \((Textures /. 
                      mathfunstore[\([Length[
                            mathfunstore]]\)])\)\[IndentingNewLine]];\)\
\[IndentingNewLine]];\)\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \( (*\ \(applytrans[str];\)\ *) \)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["other", "Subsubsection"],

Cell["\<\
for mm v.9 never tested
\tSpecularity[{r_,g_,b_},s_]] ??
\tSpecularity[ RGBColor[ r_,b_,g_], s_] ]\
\>", "Text",
  CellTags->"s9"],

Cell[BoxData[
    \(\(writeobj2["\<rSpecularity\>", obj_] := 
        Module[{v}, \[IndentingNewLine]v = 
            ReleaseHold[obj]; \[IndentingNewLine]v[\([0]\)] = 
            Sequence; \[IndentingNewLine]XrSpecularity[
            v];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrSpecularity[
          s_] := \[IndentingNewLine]Module[{surfspec, 
            s}, \[IndentingNewLine]s = 
            s~N~maxprecision; \[IndentingNewLine]surfspec = "\<\>"; \
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\(writeNums2[
                surfspec, "\< specpow \>", 
                s];\)\[IndentingNewLine], \[IndentingNewLine]writeNums2[
              surfspec, "\< finish { \>"]; \[IndentingNewLine]writeNums2[
              surfspec, "\< phong \>", s]; \[IndentingNewLine]writeNums2[
              surfspec, "\< } \>"];\[IndentingNewLine]]; \
\[IndentingNewLine]surfstore[\([Length[surfstore]]\)] = 
            surfstore[\([Length[surfstore]]\)] <> 
              surfspec;\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrSpecularity[r_, g_, b_, 
          s_] := \[IndentingNewLine]Module[{surfspec, r2, g2, b2, s, 
            len}, \[IndentingNewLine]v = 
            ReleaseHold[vl]; \[IndentingNewLine]r2 = r~N~maxprecision; 
          g2 = g~N~maxprecision; b2 = b~N~maxprecision; 
          s = v[\([4]\)]~N~
              maxprecision; \[IndentingNewLine]surfspec = "\<\>"; \
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]writeNums2[
              surfspec, "\< specular \>", {r2, g2, 
                b2}]; \[IndentingNewLine]writeNums2[
              surfspec, "\< specpow \>", 
              s];\[IndentingNewLine], \[IndentingNewLine]writeNums2[
              surfspec, "\< finish { \>"]; \[IndentingNewLine]writeNums2[
              surfspec, "\< phong \>", s]; \[IndentingNewLine]writeNums2[
              surfspec, "\< } \>"];\[IndentingNewLine]]; \
\[IndentingNewLine]surfstore[\([Length[surfstore]]\)] = 
            surfstore[\([Length[surfstore]]\)] <> 
              surfspec;\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrSpecularity[c_, s_] := XrSpecularity[c, c, c, s];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrSpecularity[RGBColor[r_, g_, b_], s_] := 
        XrSpecularity[r, g, b, s];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(writeobj2["\<rGlow\>", obj_] := 
        Module[{v}, \[IndentingNewLine]v = 
            ReleaseHold[obj]; \[IndentingNewLine]v[\([0]\)] = 
            Sequence; \[IndentingNewLine]XrGlow[
            v];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell["\<\
don't follow rule \"once glow is applied nothing removes it\"
instead the usual rule \"last thing applied is best\" will apply\
\>", "Text"],

Cell[BoxData[
    \(\(XrGlow[r_, g_, b_] := 
        Module[{camb}, If[raypov === False, camb =  .01, camb =  .5]; 
          XrAmbient[r, g, b]; XrDiffuse[camb, camb, camb];];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrGlow[c_] := 
        Module[{camb}, 
          If[raypov === False, camb =  .01, 
            camb =  .5]; \[IndentingNewLine]If[c === {}, 
            XrAmbient[ .01,  .01,  .01], 
            XrGlow[c, c, c]]\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrGlow[RGBColor[r_, g_, b_]] := XrGlow[r, g, b];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(writeobj2["\<rOpacity\>", obj_] := 
        Module[{v}, \[IndentingNewLine]v = 
            ReleaseHold[obj]; \[IndentingNewLine]v[\([0]\)] = 
            Sequence; \[IndentingNewLine]XrOpacity[
            v];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrOpacity[
          n_] := \[IndentingNewLine]Module[{surfspec, 
            n2}, \[IndentingNewLine]n2 = 
            1 - n~N~maxprecision; \[IndentingNewLine]surfspec = "\<\>"; \
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]writeNums2[
              surfspec, "\< transp \>", 
              n2]; \[IndentingNewLine]surfstore[\([Length[surfstore]]\)] = 
              surfstore[\([Length[surfstore]]\)] <> 
                surfspec;\[IndentingNewLine], \[IndentingNewLine]writeNums2[
              surfspec, "\< pigment { transmit \>", 
              n2, "\< } \>"]; \[IndentingNewLine]surfstore[\([Length[
                    surfstore]]\)] = 
              surfspec; \[IndentingNewLine]lasttransmit = "\< \>" <> 
                nsForm2[
                  n2];\[IndentingNewLine]];\[IndentingNewLine]];\)\)], "Input",\

  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(XrOpacity[n_, r_, g_, b_] := \((XrOpacity[n]; 
        XrRGBColor[r, g, b];)\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(XrOpacity[n_, c_] := XrOpacity[n, c, c, c];\)\)], "Input"],

Cell[BoxData[
    \(\(XrOpacity[n_, RGBColor[r_, g_, b_]] := 
        XrOpacity[n, r, g, b];\)\)], "Input"],

Cell["butt round square none", "Text"],

Cell[BoxData[
    \(\(SetAttributes[XrCapForm, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj["\<rCapForm\>", obj_] := XrCapForm[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(XrCapForm[
        vl_] := \[IndentingNewLine]Module[{v}, \[IndentingNewLine]v = 
          ReleaseHold[vl]; \[IndentingNewLine]PrependTo[
          mathfunstore[\([Length[mathfunstore]]\)], 
          CapForm \[Rule] v];\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(SetAttributes[XrPointSize, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj["\<rPointSize\>", obj_] := XrPointSize[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(XrPointSize[
        vl_] := \[IndentingNewLine]Module[{newrad, 
          rad}, \[IndentingNewLine]rad = 
          ReleaseHold[vl]; \[IndentingNewLine]rad = 
          rad[\([1]\)]; \[IndentingNewLine]newrad = 
          rad\ linewidth/\(( .001)\); \  (*\ 
          pre - adjusted\ linewidth\ *) \[IndentingNewLine]newrad /= 
          10~N~maxprecision; \  (*\ magic\ *) \[IndentingNewLine]PrependTo[
          mathfunstore[\([Length[mathfunstore]]\)], 
          PointSize \[Rule] newrad];\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(SetAttributes[XrAbsoluteThickness, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj["\<rAbsoluteThickness\>", obj_] := 
        XrAbsoluteThickness[obj];\)\)], "Input",
  InitializationCell->True],

Cell["note mm's idea of absolute depends on pr", "Text"],

Cell[BoxData[
    \(XrAbsoluteThickness[
        vl_] := \[IndentingNewLine]Module[{newrad, 
          rad}, \[IndentingNewLine]rad = 
          ReleaseHold[vl]; \[IndentingNewLine]rad = 
          rad[\([1]\)]; \[IndentingNewLine]newrad = 
          rad\ ; \[IndentingNewLine]newrad /= 30~N~maxprecision; \  (*\ 
          magic\ *) \[IndentingNewLine]newrad = 
          rad\ sceneAveWidth/20~N~maxprecision; \  (*\ 
          magic\ *) \[IndentingNewLine]PrependTo[
          mathfunstore[\([Length[mathfunstore]]\)], 
          AbsoluteThickness \[Rule] newrad];\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(SetAttributes[XrThickness, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj["\<rThickness\>", obj_] := XrThickness[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(XrThickness[
        vl_] := \[IndentingNewLine]Module[{newrad, 
          rad}, \[IndentingNewLine]rad = 
          ReleaseHold[vl]; \[IndentingNewLine]rad = 
          rad[\([1]\)]; \[IndentingNewLine]newrad = 
          rad\ linewidth/\(( .001\ 25)\); \[IndentingNewLine]newrad /= 
          30~N~maxprecision; \  (*\ magic\ *) \[IndentingNewLine] (*\ 
          newrad\  *= 100; \ 
          magic\ for\ WoldPlot\ *) \[IndentingNewLine]PrependTo[
          mathfunstore[\([Length[mathfunstore]]\)], 
          AbsoluteThickness \[Rule] newrad];\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \(\(writeobj["\<rDashing\>", obj_] := XrDashingSet[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(XrDashingSet[
        vl_] := \[IndentingNewLine]Module[{v}, \[IndentingNewLine]v = 
          ReleaseHold[vl]; \[IndentingNewLine]PrependTo[
          mathfunstore[\([Length[mathfunstore]]\)], 
          Dashing \[Rule] v];\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s9"]
}, Closed]],

Cell[CellGroupData[{

Cell["rotateshape  affineshape  ( expected done - untested )", "Subsubsection"],

Cell["\<\
believe these are always done by mm before getting here
\tare here for completeness i guess\
\>", "Text"],

Cell[BoxData[
    \( (*\ \(writeobj2[file_, 
          TranslateShape[g_, vl_List]]\)\(:=\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(SetAttributes[XrTranslateShape, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj2["\<rTranslateShape\>", obj_] := 
        XrTranslateShape[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrTranslateShape[
          obj_] := \[IndentingNewLine]Module[{transspec, v, 
            o}, \[IndentingNewLine]o = 
            ReleaseHold[obj]; \[IndentingNewLine]v = 
            o[\([2]\)]; \[IndentingNewLine]v = 
            v /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                  y}; \[IndentingNewLine] (*\ \(v = 
                Select[Map[pointInPlotRange, v], 
                  ListQ];\)\ *) \[IndentingNewLine]v = 
            v~N~maxprecision; \[IndentingNewLine]If[
            Length[v] > 
              2, \[IndentingNewLine]transspec = "\<\>"; \
\[IndentingNewLine]writeNums2[transspec, "\<\ttranslate \>", 
              v]; \[IndentingNewLine]transstore[\([Length[transstore]]\)] = 
              transstore[\([Length[transstore]]\)] <> 
                transspec; \[IndentingNewLine]writeobj["\<List\>", 
              Hold[{o[\([1]\)]}]];\[IndentingNewLine]];\[IndentingNewLine]];\)\
\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell["these are untested and expected done already", "Text"],

Cell[BoxData[
    \( (*\ \(writeobj2[file_, 
          RotateShape[g_, psi_, theta_, phi_]]\)\(:=\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(SetAttributes[XrRotateShape, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj2["\<rRotateShape\>", obj_] := 
        XrRotateShape[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrRotateShape[
          obj_] := \[IndentingNewLine]Module[{transspec, psi, theta, phi, 
            o}, \[IndentingNewLine]o = 
            ReleaseHold[obj]; \[IndentingNewLine]psi = 
            o[\([2]\)]/Degree; \[IndentingNewLine]theta = 
            o[\([3]\)]/Degree; \[IndentingNewLine]phi = 
            o[\([4]\)]/
              Degree; \[IndentingNewLine] (*\(\(\(\(\(\ \)\(oops\ this\ isn' 
                          t\ Euler\ transspec = "\<\trotate \>" <> 
                          ToString[
                            phi/Degree~N~maxprecision]\)\(]\)\) <> "\< \>" <> 
                    ToString[theta/Degree~N~maxprecision] <> "\< \>" <> 
                    ToString[
                      psi/Degree~N~
                          maxprecision]\)\(]\)\) <> "\<\n\>";\)\ \
*) \[IndentingNewLine] (*\ Euler\ rot\ is\ z, \ x, \ 
            z\ *) \[IndentingNewLine]transspec = "\<\>"; \
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]writeNums2[
              transspec, "\<\trotate  \>", {0, 0, 1}, 
              psi]; \[IndentingNewLine]writeNums2[
              transspec, "\<\trotate  \>", {1, 0, 0}, 
              theta]; \[IndentingNewLine]writeNums2[
              transspec, "\<\trotate  \>", {0, 0, 1}, 
              phi];\[IndentingNewLine], \[IndentingNewLine]writeNums2[
              transspec, "\<\trotate  \>", {0, 0, 
                psi}]; \[IndentingNewLine]writeNums2[
              transspec, "\<\trotate  \>", {theta, 0, 
                0}]; \[IndentingNewLine]writeNums2[
              transspec, "\<\trotate  \>", {0, 0, 
                phi}];\[IndentingNewLine]]; \[IndentingNewLine]applytrans[
            transspec]; \[IndentingNewLine]writeobj["\<List\>", 
            Hold[{o[\([1]\)]}]];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s9"],

Cell[BoxData[
    \( (*\ \(writeobj2[file_, 
          AffineShape[g_, vl_List]]\)\(:=\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(SetAttributes[XrAffineShape, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj["\<rAffineShape\>", obj_] := 
        XrAffineShape[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(XrAffineShape[
          obj_] := \[IndentingNewLine]Module[{transspec, v, 
            o}, \[IndentingNewLine]o = 
            ReleaseHold[obj]; \[IndentingNewLine]v = 
            o[\([2]\)]~N~maxprecision; \[IndentingNewLine]If[
            Length[v] > 
              2, \[IndentingNewLine]transspec = "\<\>"; \
\[IndentingNewLine]writeNums2[transspec, "\<\tscale  \>", 
              v]; \[IndentingNewLine]applytrans[
              transspec]; \[IndentingNewLine]writeobj["\<List\>", 
              Hold[{o[\([1]\)]}]];\[IndentingNewLine]];\[IndentingNewLine]];\)\
\)], "Input",
  InitializationCell->True,
  CellTags->"s9"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text primative", "Subsection",
  Background->GrayLevel[0.900008]],

Cell[TextData[{
  "FIXME:\n\trlehdr(1) should be used instead of rlebox(1), rlebox can be \
crop size\n\thowever rlebox(1) is always right for what I've tested Text or \
Raster.\nBROKEN:  vertical Text direction (the rest works ok not perfect)\n\t\
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " apparently renders Graphics[ Text[] ] with Postscript\n\t\t(overlaying \
Text) which is how inner character rotation is supported.\n\t\tIt would be \
difficult to save the image and overlay it on the final rendering.\n\tDon't \
think Graphics will easily give cropped image to use.\n\t\tIf it could, use \
Display[ gr[txt] ] not Display [ cell[txt] ].\n\t\tBut I think ps is used to \
render in a box and fit of text within it is hit or miss\n\t\t(ps stops at \
ends) (which would mean mm itself cant auto-crop the result)\nUSE:  Cell \
formatted expr instead\n\tas a result the below (must) do:  off and dir\n\t\
(and rotate text toward eyep, since we dont ps render onto 2D image)\n\n(* \
for POV if scale is ie x8 text is easily readable but way too large to fit\n  \
  I have no idea why smaller text doesn't appear the same resolution\n*)"
}], "Text"],

Cell[BoxData[
    \( (*\ writeobj2[file_, rText[expr_, vl_, dir_: {0, 0}]] := 
        XrText[expr, vl, dir]; \ \[IndentingNewLine]\(\(XrText[expr_, vl_, 
          dir_: {0, 0}]\)\(:=\)\); \[IndentingNewLine]SetAttributes[XrText, 
        HoldFirst];\[IndentingNewLine]*) \)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<rText\>", obj_] := XrText[obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrText, HoldAll];\)\)], "Input"],

Cell[BoxData[
    \(\(XrText[
          obj_] := \[IndentingNewLine]Module[{cell, tmpf, g, box, pts, v, x, 
            xi, y, yi, xc, yc, m, f, inc, dist, angle, str, expr, vl, dir, 
            off, txtopts, background, textstyle, formattype, 
            bgsurf}, \[IndentingNewLine]\[IndentingNewLine] (*\ \
\(Print["\<### Text \>"];\)\ *) \[IndentingNewLine]\[IndentingNewLine]bgsurf \
= "\<\>"; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            FIXME\ \(?? \ \(v = \(ReleaseHold[
                        obj]\)[\([1]\)];\)\)\ *) \[IndentingNewLine]v = 
            ReleaseHold[obj]; \[IndentingNewLine]vl = {}; 
          txtopts = {}; \[IndentingNewLine]Scan[\[IndentingNewLine]\((\(If[
                    Head[#] === 
                      Rule, \[IndentingNewLine]\(txtopts = 
                        txtopts~Append~#;\), \[IndentingNewLine]\(vl = 
                        vl~Append~#;\)];\)\[IndentingNewLine])\) &, 
            v]; \[IndentingNewLine]v = 
            vl; \[IndentingNewLine]\[IndentingNewLine]background = 
            Background /. txtopts; \[IndentingNewLine]If[
            background =!= "\<SolidWhite\>", \[IndentingNewLine]\(If[
                background === 
                  Background, \[IndentingNewLine]\(background = 
                    None;\)\[IndentingNewLine], \[IndentingNewLine]If[
                  Length[surfstore] > 
                    0, \[IndentingNewLine]\(pushsurf[
                      surfstore[\([Length[
                            surfstore]]\)]];\)\[IndentingNewLine], 
                  surfstore = {"\<\>"}]; \[IndentingNewLine]pushsurf[
                  surfstore[\([Length[surfstore]]\)]]; \[IndentingNewLine]x = 
                  background; \[IndentingNewLine]y = 
                  x[\([0]\)]; \[IndentingNewLine]x[\([0]\)] = 
                  Sequence; \[IndentingNewLine]If[y === RGBColor, 
                  XrRGBColor[x]]; \[IndentingNewLine]If[y === Hue, 
                  XrHue[x]]; \[IndentingNewLine]bgsurf = 
                  surfstore[\([Length[
                        surfstore]]\)]; \[IndentingNewLine]popsurf[];\
\[IndentingNewLine]];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]textstyle = TextStyle /. txtopts; \[IndentingNewLine]If[
            textstyle === TextStyle, 
            textstyle = Automatic]; \[IndentingNewLine]formattype = 
            FormatType /. txtopts; \[IndentingNewLine]If[
            formattype === FormatType, 
            formattype = 
              StandardForm]; \[IndentingNewLine]\[IndentingNewLine]If[
            v === {}, Return[]]; \[IndentingNewLine]expr = 
            v[\([1]\)]; \[IndentingNewLine]If[Length[v] > 1, vl = v[\([2]\)], 
            vl = {0, 0}]; \[IndentingNewLine]If[Length[v] > 2, 
            off = v[\([3]\)], off = {0, 0}]; \[IndentingNewLine]If[
            Length[v] > 3, dir = v[\([4]\)], 
            dir = {1, 0}]; \[IndentingNewLine]\[IndentingNewLine]If[
            formattype =!= StandardForm, Abort[]; 
            expr = formattype[
                expr]]; \[IndentingNewLine]\[IndentingNewLine] \
(*\[IndentingNewLine]Print["\<v = \>", 
              v]; \[IndentingNewLine]Print["\<expr = \>", 
              expr]; \[IndentingNewLine]Print["\<vl = \>", 
              vl]; \[IndentingNewLine]Print["\<off = \>", 
              off]; \[IndentingNewLine]Print["\<tops=\>", 
              txtopts]; \[IndentingNewLine]Print["\<v=\>", 
              v]; \[IndentingNewLine]Print["\<background=\>", 
              background]; \[IndentingNewLine]Print["\<textstyle=\>", 
              textstyle]; 
            Print["\<formattype=\>", 
              formattype];\[IndentingNewLine]*) \[IndentingNewLine]\
\[IndentingNewLine]str = "\<\>"; \[IndentingNewLine] (*\ \(Print["\< Text \
\>"];\)\ *) \[IndentingNewLine]v = 
            vl /. {x_?NumberQ, y_?NumberQ} \[Rule] {x, 0, 
                  y}; \[IndentingNewLine]v = 
            pointInPlotRange[v]; \[IndentingNewLine]If[v === Null, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine]v = 
            v~N~maxprecision; \[IndentingNewLine] (*\ \ i\ get\ errors\ times\
\ roman\ in\ Display\ *) \[IndentingNewLine] (*\ \(cell = 
                Cell[Text[
                    expr, "\<Text\>"]];\)\ *) \[IndentingNewLine]\
\[IndentingNewLine]If[
            textstyle === 
              Automatic, \[IndentingNewLine]\(cell = 
                Cell[Text[expr, "\<Text\>"], 
                  FontFamily \[Rule] "\<Courier\>"];\)\[IndentingNewLine], \
\[IndentingNewLine]textstyle[\([0]\)] = Sequence; \[IndentingNewLine]cell = 
              Cell[Text[expr, "\<Text\>"], 
                textstyle];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]tmpf = \(OpenTemporary[]\)[\([1]\)]; \
\[IndentingNewLine]Close[tmpf]; \[IndentingNewLine] (*\ 
            an\ easy\ way\ to\ get\ rle\ using\ standard\ available; \
\[IndentingNewLine]package\ netpbm; \ 
            works\ on\ my\ box\ *) \[IndentingNewLine]Display[
            tmpf <> "\<.tiff\>", cell, "\<TIFF\>", 
            ImageResolution \[Rule] 
              512]; \[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]cmd = "\<tifftopnm \>" <> 
                tmpf <> "\<.tiff 1> \>" <> 
                tmpf <> "\<.pnm\>" <> "\< 2>>/dev/null\>"; \
\[IndentingNewLine]Run[
              cmd]; \[IndentingNewLine]cmd = "\<pnmtorle \>" <> 
                tmpf <> "\<.pnm -o \>" <> 
                tmpf <> "\<.rle\>" <> "\< 2>>/dev/null\>"; \
\[IndentingNewLine]Run[cmd]; \[IndentingNewLine] (*\ need\ size; \ 
              note\ could\ Display\ as\ Xbitmap, \ export, \ import, \ 
              and\ use\ Dimensions\ *) \[IndentingNewLine]cmd = "\<rlebox \>" \
<> tmpf <> "\<.rle\>" <> "\< 1>\>" <> 
                tmpf <> "\<.box\>"; \[IndentingNewLine]Run[
              cmd]; \[IndentingNewLine]box = 
              Import[tmpf <> "\<.box\>", "\<List\>"];\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
            raypov === True, \[IndentingNewLine]Display[tmpf <> "\<.xbm\>", 
              cell, "\<Xbitmap\>", 
              ImageResolution \[Rule] 512]; \[IndentingNewLine]g = 
              Import[tmpf <> "\<.xbm\>", "\<Xbitmap\>"]; \
\[IndentingNewLine]box = Dimensions[g[\([1, 1]\)]]; \[IndentingNewLine] (*\ 
              note\ reversal\ *) \[IndentingNewLine]box = {0, 
                box[\([2]\)] - 1, 0, 
                box[\([1]\)] - 
                  1};\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ \(old\ Print["\<box = \>", 
                  box, "\< \>"];\)\ *) \[IndentingNewLine] (*\ \(old\ pts = 
                rectpoints[v, box[\([2]\)], box[\([4]\)], vp, 
                  up];\)\ *) \[IndentingNewLine] (*\ \(old\ pts = 
                rectpoints[v, box[\([2]\)], box[\([4]\)], {0, \(-1\), 0}, 
                  up];\)\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
            its\ important\ to\ treat\ as\ normalized\ for\ now\ \
*) \[IndentingNewLine]pts = 
            rectpoints[{0, 0, 0}, 1, 1, {0, \(-1\), 0}, 
              up]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            needs\ to\ be\ a\ separate\ gr\ to\ translate\ as\ gr\ \
*) \[IndentingNewLine]\(++grcount\); \[IndentingNewLine]\[IndentingNewLine] \
(*\ magic\ x\ scale\ to\ make\ rect\ given\ pixel\ width\ of\ text\ \
*) \[IndentingNewLine]m = 
            1.4321590301661122`*^-8; \[IndentingNewLine]f[x_] :=  .00076 - 
              m \((2630 - x)\); \ \[IndentingNewLine]x = 
            f[box[\([2]\)]]~N~
              maxprecision; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            z\ works\ as\ const . \ 
                though\ note\ texture\ is\ z\ scaled\ below\ \
*) \[IndentingNewLine]y = 0.0015; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            rayshade\ punts\ textures; \ 
            x - z\ becomes\ x - 
              y\ *) \[IndentingNewLine]\[IndentingNewLine]xi = \((2.5\ \
box[\([2]\)]\ 2)\)/\((2630)\)~N~
                maxprecision; \[IndentingNewLine]yi = \((box[\([4]\)]\  \
.15)\)/\((98)\)~N~
                maxprecision; \[IndentingNewLine]xc\  = \ \(-1.25\)\ \
box[\([2]\)]\ x~N~
                maxprecision; \[IndentingNewLine]yc\  = \ \(-box[\([4]\)]\)\ \
y/2~N~maxprecision; \[IndentingNewLine]off = 
            IntegerPart@
              off; \[IndentingNewLine]off\  = {off[\([1]\)], 0, 
                off[\([2]\)]}\ {xc, 0, 
                yc}; \[IndentingNewLine]\[IndentingNewLine]xi *= 
            sceneAveWidth; \[IndentingNewLine]yi *= 
            sceneAveWidth; \[IndentingNewLine]xc *= 
            sceneAveWidth; \[IndentingNewLine]yc *= 
            sceneAveWidth; \[IndentingNewLine]off *= 
            sceneAveWidth; \[IndentingNewLine]\[IndentingNewLine]If[
            dir === {\(-1\), 0}, xc *= \(-1\); yc *= \(-1\); 
            off *= \(-1\);]; \[IndentingNewLine]\[IndentingNewLine]\
\[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\[IndentingNewLine]Write2[
              objadd, "\<name gr\>" <> 
                ToString[grcount]]; \[IndentingNewLine]Write2[
              objadd, "\<list /* Text */\>"]; \[IndentingNewLine]Write2[
              objadd, "\<polygon  \>" <> surfstore[\([Length[surfstore]]\)] <> 
                bgsurf]; \[IndentingNewLine]\[IndentingNewLine]If[
              background === "\<SolidWhite\>" || \((background =!= None && 
                    bgsurf === "\<\>")\), \[IndentingNewLine] (*\ 
                a\ fallback\ ; \ 
                ignores\ lights\ *) \[IndentingNewLine]\(Write2[
                  objadd, "\<\tambient 1 1 1 diffuse 0 0 0\>"];\)\
\[IndentingNewLine]]; \[IndentingNewLine]\[IndentingNewLine]Scan[
              writeNums2[objadd, #] &, 
              pts]; \[IndentingNewLine]\[IndentingNewLine]Write2[
              objadd, "\<\ttexture image\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\t\>" <> tmpf <> "\<.rle\>"]; \[IndentingNewLine]If[
              background === 
                None, \[IndentingNewLine]\(Write2[
                  objadd, "\<\ttextsurf diffuse 0 0 0 ambient .5 .5 .5 transp \
.5 body 1 1 1\>"];\)\[IndentingNewLine]]; \[IndentingNewLine]Write2[
              objadd, "\<\tmap planar\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\t0 0 0\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\t0 0 1\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\t1 0 0\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\ttile 1 1\>"]; \[IndentingNewLine]Write2[
              objadd, "\<end /* Text */\>"]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
              order\ of\ these\ is\ important\ \
*) \[IndentingNewLine]writeNums2[
              str, "\<\tscale \>", {xi, 1, 
                yi}]; \[IndentingNewLine]\[IndentingNewLine]If[
              NumberQ[rayoverlay] === True, \[IndentingNewLine]writeNums2[
                str, "\<\ttranslate \>", {0, rayoverlay, 
                  0}]; \[IndentingNewLine]rayoverlay += 
                ola;\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
              dir === {\(-1\), 0}, \[IndentingNewLine]writeNums2[
                str, "\<\trotate \>", {0, 0, 1}, 
                180]; \[IndentingNewLine]writeNums2[
                str, "\<\trotate \>", {1, 0, 0}, 
                180];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]writeNums2[
              str, "\<\trotate \>", {1, 0, 0}, \((\(-1\))\) 
                vpRotAngles[\([3]\)]]; \[IndentingNewLine]writeNums2[
              str, "\<\ttranslate \>", 
              v]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
              start\ centered\ then\ apply\ off\ \
*) \[IndentingNewLine]writeNums2[
              str, "\<\ttranslate \>", {0, 0, 
                yc}]; \[IndentingNewLine]writeNums2[
              str, "\<\ttranslate \>", {xc, 0, 
                0}]; \[IndentingNewLine]writeNums2[str, "\<\ttranslate \>", 
              off]; \[IndentingNewLine]\[IndentingNewLine]writeNums2[
              str, "\<\trotate \>", {0, 0, 1}, 
              vpRotAngles[\([1]\)]]; \[IndentingNewLine]\[IndentingNewLine] \
(*\ works\ im\ unsure\ which\ is\ better; \[IndentingNewLine]If[
                NumberQ[rayoverlay] === True, \[IndentingNewLine]writeNums2[
                  
                  str, "\<\ttranslate \>", \(-unit\)\ ola]; \
\[IndentingNewLine]rayoverlay += 
                  ola;\[IndentingNewLine]];\[IndentingNewLine]\
*) \[IndentingNewLine]\[IndentingNewLine]If[rayaspect === True, 
              writeNums2[str, "\<\tscale \>", 
                1/prasp]]; \[IndentingNewLine]\[IndentingNewLine]applytrans[
              str];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]\[IndentingNewLine]\[IndentingNewLine]If[
            raypov === True, \[IndentingNewLine]\[IndentingNewLine]Write2[
              objadd, "\<#declare gr\>" <> 
                ToString[
                  grcount] <> "\< = union { \>"]; \[IndentingNewLine]\
\[IndentingNewLine]Write2[
              objadd, "\<polygon { 5, \>"]; \
\[IndentingNewLine]Scan[\((writeNums2[objadd, #]; 
                  Write2[objadd, "\<,\>"])\) &, 
              Take[pts, Length[pts] - 1]]; \[IndentingNewLine]writeNums2[
              objadd, Last[pts]]; \[IndentingNewLine]\[IndentingNewLine]If[
              background === "\<SolidWhite\>", \[IndentingNewLine]Write2[
                objadd, "\<\ttexture{ finish { ambient rgb <1,1,1> } \
pigment{color rgb <0,0,0>}}\>"]\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
              background =!= None, \[IndentingNewLine] (*\ 
                writesurfPOV2[objadd]; \ 
                ignore\ *) \[IndentingNewLine]\(If[
                  bgsurf =!= "\<\>", \[IndentingNewLine]bgsurf = "\<\ttexture \
{ \>" <> bgsurf <> "\< } \>"; \[IndentingNewLine]Write2[objadd, 
                    bgsurf]\[IndentingNewLine], \[IndentingNewLine]Write2[
                    objadd, "\<\ttexture{ finish { ambient rgb <1,1,1> } \
pigment{color rgb <0,0,0>}}\>"]\[IndentingNewLine]];\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
              seems\ 2  
                x\ here\ or\ get\ 1/2\ img\ but\ must\ scale\ 1/
                  2\ later\ \
*) \[IndentingNewLine]\[IndentingNewLine]writeNums2[
              objadd, "\<\tscale \>", {1, 1, 
                2}]; \[IndentingNewLine]\[IndentingNewLine]Write2[
              objadd, "\<\ttexture { \>"]; \[IndentingNewLine]Write2[
              objadd, "\<\tpigment { \>"]; \[IndentingNewLine]Write2[
              objadd, "\<\timage_map { \>"]; \[IndentingNewLine]Write2[
              objadd, "\<\ttiff \"\>" <> 
                tmpf <> "\<.tiff\" \>"]; \[IndentingNewLine]Write2[
              objadd, "\<\tonce\>"]; \[IndentingNewLine]If[
              background === 
                None, \[IndentingNewLine]\(Write2[
                  objadd, "\<\tfilter all 1 transmit all 0 \>"];\)\
\[IndentingNewLine]]; \[IndentingNewLine]Write2[
              objadd, "\<\t}\>"];  (*close\ \
image*) \[IndentingNewLine]writeNums2[
              objadd, "\<\trotate \>", {30, 0, 0}]; \[IndentingNewLine]Write2[
              objadd, "\<\t}\>"];  (*close\ \
pigment*) \[IndentingNewLine]Write2[
              objadd, "\<\t}\>"];  (*close\ texture*) \[IndentingNewLine]\
\[IndentingNewLine]writeNums2[
              objadd, "\<\tscale \>", {xi, 1, 
                yi}]; \[IndentingNewLine]\[IndentingNewLine]If[
              NumberQ[rayoverlay] === True, \[IndentingNewLine]writeNums2[
                objadd, "\<\ttranslate \>", {0, rayoverlay, 
                  0}]; \[IndentingNewLine]rayoverlay += 
                ola;\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]writeNums2[
              objadd, "\<\trotate \>", {\((\(-1\))\) vpRotAngles[\([3]\)], 0, 
                0}]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
              x2\ due\ to\ scale\ above\ ; \ 
              this\ fix\ might\ still\ be\ wrong\ \
*) \[IndentingNewLine]writeNums2[
              objadd, "\<\ttranslate \>", {v[\([1]\)], v[\([2]\)], 
                v[\([3]\)] 
                  2}]; \[IndentingNewLine]\[IndentingNewLine]writeNums2[
              objadd, "\<\ttranslate \>", {0, 0, yc\ 2}]; 
            writeNums2[objadd, "\<\ttranslate \>", {xc, 0, 0}]; 
            writeNums2[objadd, "\<\ttranslate \>", 
              off]; \[IndentingNewLine]\[IndentingNewLine]writeNums2[
              objadd, "\<\trotate \>", {0, 0, 
                vpRotAngles[\([1]\)]}]; \[IndentingNewLine] \
(*\[IndentingNewLine]\(If[
                  NumberQ[rayoverlay] === True, \[IndentingNewLine]writeNums2[
                    objadd, "\<\ttranslate \>", \(-unit\)\ ola]; \
\[IndentingNewLine]rayoverlay += 
                    ola;\[IndentingNewLine]];\)\[IndentingNewLine]\
*) \[IndentingNewLine]writeNums2[
              objadd, "\<\tscale \>", {1, 1,  .5}]; \[IndentingNewLine]If[
              rayaspect === True, 
              writeNums2[str, "\<\tscale \>", 
                1/prasp]]; \[IndentingNewLine]Write2[
              objadd, "\<}\>"]; \  (*close\ poly*) \[IndentingNewLine]Write2[
              objadd, "\<}\>"];\  (*close\ obj*) \[IndentingNewLine]];\
\[IndentingNewLine]\[IndentingNewLine]\[IndentingNewLine]\[IndentingNewLine] \
(*\ \(do\ \(not\ ++\) primcount;\)\ *) \[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True],

Cell["\<\
(* FIXME  for None make it white, no transparency yet 
\t,FontColor\[Rule]GrayLevel[1],Background\[Rule]GrayLevel[0]
*)
(*
  
  If[background===None||bgsurf===\"\",
      If[rayglass===False,
          (* white bg *)
          
          Write2[objadd,\"\\tambient 1 1 1 diffuse 0 0 0\"];
          (* 
            Write2[objadd,
                \"\\tambient .7 .8 .9 diffuse .1 .1 .1\"]; *)
          ,
          (* really needs reverse color text and reverse color;
            black surface to work right as glass as things are; *)
          
          Write2[objadd,\"\\tambient .8 .8 .8 diffuse .1 .1 .1 transp .4\"];
          ];
      ];
  *)\
\>", "Text"],

Cell[TextData[{
  "(*\ncreate at origin facing {0,-1,0).  scaling is need for poly size v. \
image size.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " always faces text toward ViewPoint.  Translate as needed.  Rotate x then \
z using vpRotAngles.  See notes in rayshade-note.nb for detail.  see code \
notes about why it's not like Raster.\n*)"
}], "Text"],

Cell["\<\
(* TODO:  get POV  to do image color right.  the below is broken \
(image is wrong) and still POV shows odd colored background though (i'd \
hoped) ppm had no alpha.

cmd=\"xbmtopbm \"<>tmpf<>\".xbm 1> \"<>tmpf<>\".pbm\"<>\" 2>>/dev/null\";
Run[cmd];

cmd=\"pbmtopgm \"<>ToString[box[[2]]]<>\" \"<>ToString[box[[4]]]<>\" \
\"<>tmpf<>
      \".pbm 1> \"<>tmpf<>\".pgm\"<>\" 2>>/dev/null\";
Run[cmd];

cmd=\"pgmtoppm White \"<>tmpf<>\".pgm 1> \"<>tmpf<>\".ppm\"<>\" \
2>>/dev/null\";
Run[cmd];

*)\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Raster primative", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s11"],

Cell[TextData[{
  "(*\ncreate at origin facing {0,-1,0).  scaling is need for poly size v. \
image size.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " always faces text toward ViewPoint.  Translate as needed.  Rotate x then \
z using vpRotAngles.  See notes in rayshade-note.nb for detail\n*)"
}], "Text",
  CellTags->"s11"],

Cell[BoxData[
    \( (*\[IndentingNewLine]writeobj2[file_, RasterArray[obj_]] := 
        writeobj2[file, 
          Raster[RasterArray[obj]]]; \[IndentingNewLine]writeobj2[file_, 
          rRaster[obj_]] := XrRaster[obj]; \n
      writeobj2[file_, rRasterArray[obj_]] := 
        XrRaster[RasterArray[obj]];\[IndentingNewLine]*) \)], "Input"],

Cell[BoxData[
    \(\(writeobj["\<rRaster\>", obj_] := XrRaster[Raster, obj];\)\)], "Input",\

  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj["\<rRasterArray\>", obj_] := 
        XrRaster[RasterArray, obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj2["\<rRasterClear\>", obj_] := 
        XrRasterClear[Raster, obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(writeobj2["\<rRasterArrayClear\>", obj_] := 
        XrRasterClear[RasterArray, obj];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrRaster, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[XrRasterClear, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(XrRasterClear[raster_, pobj_] := \((rasterclear = True; 
        XrRaster[raster, pobj]; rasterclear = False;)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(XrRaster[raster_, 
          pobj_] := \[IndentingNewLine]Module[{cell, tmpf, box, pts, v, x, 
            xi, y, yi, xc, yc, xr, yr, xm, ym, xt, yt, m, f, inc, dist, 
            angle, obj2, str, bx, by, bz, obj, 
            background}, \[IndentingNewLine]\[IndentingNewLine] (*\ 
            do\ not\ use\ Background\ *) \[IndentingNewLine]background = 
            None; \[IndentingNewLine]\[IndentingNewLine] (*\ \(Print["\<### \
Raster \>"];\)\ *) \[IndentingNewLine]\[IndentingNewLine]obj = \(ReleaseHold[
                pobj]\)[\([1]\)]; \[IndentingNewLine] (*\ \(obj = 
                ReleaseHold[pobj];\)\ *) \[IndentingNewLine]If[obj === {}, 
            Return[]]; \[IndentingNewLine]\[IndentingNewLine]str = "\<\>"; \
\[IndentingNewLine] (*\ \(Print["\< Raster \>"];\)\ *) \[IndentingNewLine]v = \
{0, 0, 0}; \[IndentingNewLine] (*\ v = pointInPlotRange[v]; \ 
            to\ boxcenter;\ *) \[IndentingNewLine]\[IndentingNewLine] \
(*\[IndentingNewLine]\(If[
                raster === 
                  RasterArray, \[IndentingNewLine]\({xr, yr} = 
                    Dimensions[obj[\([1]\)]];\)\[IndentingNewLine], \({xr, 
                      yr} = Dimensions[
                      obj];\)\[IndentingNewLine]];\)\[IndentingNewLine]\
*) \[IndentingNewLine]{xr, yr} = 
            Dimensions[
              obj]; \[IndentingNewLine]\[IndentingNewLine]tmpf = \
\(OpenTemporary[]\)[\([1]\)]; \[IndentingNewLine]Close[
            tmpf]; \[IndentingNewLine] (*\ 
            an\ easy\ way\ to\ get\ rle\ using\ standard\ available; \
\[IndentingNewLine]package\ netpbm; \ 
            works\ on\ my\ box\ *) \[IndentingNewLine]If[
            raster === RasterArray, \[IndentingNewLine]\(Display[
                tmpf <> "\<.tiff\>", 
                Graphics[RasterArray[obj], 
                  AspectRatio \[Rule] 1], "\<TIFF\>", 
                ImageSize \[Rule] {xr, 
                    yr}];\)\[IndentingNewLine], \[IndentingNewLine]\(Display[
                tmpf <> "\<.tiff\>", 
                Graphics[Raster[obj], AspectRatio \[Rule] 1], "\<TIFF\>", 
                ImageSize \[Rule] {xr, 
                    yr}];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]cmd = "\<tifftopnm \>" <> 
                tmpf <> "\<.tiff 1> \>" <> 
                tmpf <> "\<.pnm\>" <> "\< 2>>/dev/null\>"; \
\[IndentingNewLine]Run[
              cmd]; \[IndentingNewLine]cmd = "\<pnmtorle \>" <> 
                tmpf <> "\<.pnm -o \>" <> 
                tmpf <> "\<.rle\>" <> "\< 2>>/dev/null\>"; \
\[IndentingNewLine]Run[
              cmd];\[IndentingNewLine] (*cmd = "\<rlebox \>" <> 
                  tmpf <> "\<.rle\>" <> "\< 1>\>" <> 
                  tmpf <> "\<.box\>"; \[IndentingNewLine]Run[cmd]; \ 
              box = Import[
                  tmpf <> "\<.box\>", "\<List\>"];*) \[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
            note\ reversal\ *) \[IndentingNewLine]box = {0, yr - 1, 0, 
              xr - 1}; \[IndentingNewLine]\[IndentingNewLine] (*\ \(Print["\< \
box = \>", box, "\< \>"];\)\ *) \[IndentingNewLine] (*\ \(pts = 
                rectpoints[v, box[\([2]\)], box[\([4]\)], {0, \(-1\), 0}, 
                  up];\)\ *) \[IndentingNewLine] (*\ 
            its\ important\ to\ treat\ as\ normalized\ for\ now\ \
*) \[IndentingNewLine]pts = 
            rectpoints[{0, 0, 0}, 1, 1, {0, \(-1\), 0}, 
              up]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            needs\ to\ be\ a\ separate\ gr\ to\ translate\ as\ gr\ \
*) \[IndentingNewLine]\(++grcount\); \[IndentingNewLine]\[IndentingNewLine]bx \
= pr[\([1, 2]\)] - pr[\([1, 1]\)]; \[IndentingNewLine]by = 
            pr[\([2, 2]\)] - pr[\([2, 1]\)]; \[IndentingNewLine]bz = 
            pr[\([3, 2]\)] - 
              pr[\([3, 
                  1]\)]; \[IndentingNewLine]\[IndentingNewLine]\
\[IndentingNewLine]\[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]\[IndentingNewLine]Write2[
              objadd, "\<name gr\>" <> 
                ToString[grcount]]; \[IndentingNewLine]Write2[
              objadd, "\<list /* Text */\>"]; \[IndentingNewLine]Write2[
              objadd, "\<polygon  \>" <> 
                surfstore[\([Length[
                      surfstore]]\)]]; \
\[IndentingNewLine]\[IndentingNewLine]If[
              rasterclear === 
                False, \[IndentingNewLine]\(Write2[
                  objadd, "\<\tambient 1 1 1 diffuse 0 0 0\>"];\)\
\[IndentingNewLine], \[IndentingNewLine]\(Write2[
                  objadd, "\<\tdiffuse 0 0 0 ambient 0 0 0 transp 1\>"];\)\
\[IndentingNewLine]]; \[IndentingNewLine]If[
              rayglass === 
                True, \[IndentingNewLine]\(Write2[
                  objadd, "\<\tambient .8 .8 .8 diffuse .1 .1 .1 transp \
.4\>"];\)\[IndentingNewLine]]; \[IndentingNewLine]\[IndentingNewLine]Scan[
              writeNums2[objadd, #] &, 
              pts]; \[IndentingNewLine]\[IndentingNewLine]Write2[
              objadd, "\<\ttexture image\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\t\>" <> tmpf <> "\<.rle\>"]; \[IndentingNewLine]If[
              rasterclear === 
                True, \[IndentingNewLine]\(Write2[
                  objadd, "\<\ttextsurf diffuse 1 1 1 ambient 0 0 0 transp .5\
\>"];\)\[IndentingNewLine]]; \[IndentingNewLine]Write2[
              objadd, "\<\tmap planar\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\t0 0 0\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\t0 0 1\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\t1 0 0\>"]; \[IndentingNewLine]Write2[
              objadd, "\<\ttile 1 1\>"]; \[IndentingNewLine]Write2[
              objadd, "\<end /* Text */\>"]; \[IndentingNewLine]\
\[IndentingNewLine]writeNums2[
              str, "\<\tscale \>", {bx, 1, 
                bz}]; \[IndentingNewLine]\[IndentingNewLine]If[
              NumberQ[rayoverlay] === True, \[IndentingNewLine]writeNums2[
                str, "\<\ttranslate \>", {0, rayoverlay, 
                  0}]; \[IndentingNewLine]rayoverlay += 
                ola;\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]applytrans[
              str];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]\[IndentingNewLine]\[IndentingNewLine]If[
            raypov === True, \[IndentingNewLine]\[IndentingNewLine]Write2[
              objadd, "\<#declare gr\>" <> 
                ToString[
                  grcount] <> "\< = union { \>"]; \[IndentingNewLine]Write2[
              objadd, "\<polygon { 5, \>"]; \
\[IndentingNewLine]Scan[\((writeNums2[objadd, #]; 
                  Write2[objadd, "\<,\>"])\) &, 
              Take[pts, Length[pts] - 1]]; \[IndentingNewLine]writeNums2[
              objadd, Last[
                pts]]; \[IndentingNewLine]\[IndentingNewLine]writesurfPOV2[
              objadd]; \[IndentingNewLine]writeNums2[
              objadd, "\<\tscale \>", {1, 1, 2}]; \[IndentingNewLine]Write2[
              objadd, "\<\ttexture { \>"]; \[IndentingNewLine]Write2[
              objadd, "\<\tpigment { \>"]; \[IndentingNewLine]Write2[
              objadd, "\<\timage_map { \>"]; \[IndentingNewLine]Write2[
              objadd, "\<\ttiff \"\>" <> 
                tmpf <> "\<.tiff\" \>"]; \[IndentingNewLine]Write2[
              objadd, "\<\tonce\>"]; \[IndentingNewLine]If[
              rasterclear =!= 
                False, \[IndentingNewLine]\(Write2[
                  objadd, "\<\tfilter all 1 transmit all 0 \>"];\)\
\[IndentingNewLine]]; \[IndentingNewLine]Write2[
              objadd, "\<\t}\>"];  (*close\ image*) \[IndentingNewLine]\
\[IndentingNewLine]writeNums2[
              objadd, "\<\trotate \>", {30, 0, 0}]; \[IndentingNewLine]Write2[
              objadd, "\<\t}\>"];  (*close\ \
pigment*) \[IndentingNewLine]Write2[
              objadd, "\<\t}\>"];  (*close\ texture*) \[IndentingNewLine]\
\[IndentingNewLine]writeNums2[
              objadd, "\<\tscale \>", {bx, 1, 
                bz/2}]; \[IndentingNewLine]\[IndentingNewLine]If[
              NumberQ[rayoverlay] === True, \[IndentingNewLine]writeNums2[
                objadd, "\<\ttranslate \>", {0, rayoverlay, 
                  0}]; \[IndentingNewLine]rayoverlay += 
                ola;\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]Write2[
              objadd, "\<}\>"]; \  (*close\ poly*) \[IndentingNewLine]Write2[
              objadd, "\<}\>"];\  (*close\ obj*) \[IndentingNewLine]];\
\[IndentingNewLine]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)\( (*\ \(do\ \
\(not\ ++\) primcount;\)\ *) \)\)\)], "Input",
  InitializationCell->True,
  CellTags->"s11"],

Cell[BoxData[
    \( (*\[IndentingNewLine]\[IndentingNewLine]Write2[str, 
        transstore[\([Length[transstore]]\)]]; \[IndentingNewLine]inc = 
        1; \  (*\ 
        insure\ trans\ is\ one\ per\ gr\ so\ far\ *) \[IndentingNewLine]While[
        Length[trans] < grcount && \(++inc\) \[LessEqual] 1000, 
        AppendTo[trans, "\<\>"]]; \[IndentingNewLine]trans[\([grcount]\)] = 
        trans[\([grcount]\)] <> str; \[IndentingNewLine]\[IndentingNewLine]If[
        rayglass === 
          False, \[IndentingNewLine]\(Write2[
            objadd, "\<\ttexture { pigment { color rgb <0,0,0> } finish { \
ambient rgb <1,1,1> } }\>"];\)\[IndentingNewLine], \
\[IndentingNewLine]\(Write2[
            objadd, "\<\ttexture { pigment { color rgb <0,0,0> transmit .4 } \
finish { ambient rgb <1,1,1> } }\>"];\)\[IndentingNewLine]];\
\[IndentingNewLine]*) \)], "Input",
  CellTags->"s11"]
}, Closed]],

Cell[CellGroupData[{

Cell["init  vars", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s12"],

Cell[BoxData[
    \(\(initVars[] := 
        Module[{}, \[IndentingNewLine]file = "\<\>"; \n
          pr = {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}; \n
          vc = {0, 0, 0}; \  (*\ ignored\ *) \n
          vp = {1.3, \(-2.4\), 
              2}; \[IndentingNewLine]origvp = {1.3, \(-2.4\), 2}; \n
          vv = {0, 0, 1}; \n (*\ 
            vp\ is\ directional\ but\ eyep\ needs\ vertex\ *) \n
          eyep = vp\ 1; \nlookp = {0, 0, 0}; \nup = vv; \n
          fov = 45; \[IndentingNewLine]rayfovangle = 
            40; \n (*\ \(replaced\ with\ default\ in\ scene\ setup;\)\ \
*) \[IndentingNewLine]lights = {{{1.`, 0.`, 1.`}, 
                RGBColor[1.`, 0.`, 0.`]}, {{1.`, 1.`, 1.`}, 
                RGBColor[0.`, 1.`, 0.`]}, {{0.`, 1.`, 1.`}, 
                RGBColor[0.`, 0.`, 1.`]}}; \ngrcount = 1; \n
          primcount = 1; \[IndentingNewLine]subprims = 0; \n
          scenedepth = 1; \[IndentingNewLine]sceneAveWidth = 
            1; \[IndentingNewLine]viewdepth = scenedepth; \n
          box = {{\(-1\), \(-1\), \(-1\)}, {1, \(-1\), \(-1\)}, {1, 
                1, \(-1\)}, {\(-1\), 1, \(-1\)}, {\(-1\), \(-1\), 
                1}, {1, \(-1\), 1}, {1, 1, 1}, {\(-1\), 1, 1}}; \n
          boxcenter = {0, 0, 0}; \n
          unit = {0.3841851809676021`, \(-0.70926494947865`\), 
              0.5910541245655417`}; \n
          vpnormal = {\(-8.713490501485645`*^-18\), \(-0.6401843996644799`\), \
\(-0.7682212795973759`\)}; \[IndentingNewLine]onnormalplane = 
            vpnormal; \[IndentingNewLine]onnormalplaneunit = 
            vpnormal; \[IndentingNewLine]apparentzoom = 
            1; \[IndentingNewLine]origvp = vp; \n
          surfstore = {"\<\>"}; \[IndentingNewLine]transstore = {"\<\>"}; \
\[IndentingNewLine]diffstore = {"\<\>"}; \[IndentingNewLine]mathfunstore = \
{{}}; \nlinewidth =  .001; \  (*\ magic\ *) \n
          raysurfaces = {}; \[IndentingNewLine]trans = {}; \
\[IndentingNewLine]diff = {}; \[IndentingNewLine]objadd = "\<\>"; \
\[IndentingNewLine]txtadd = {}; \[IndentingNewLine]optlist = {}; \
\[IndentingNewLine] (*\ so\ far\ used\ only\ in\ main; \noptlistsmall = {}; \n
            fullopts = \
{};\[IndentingNewLine]*) \[IndentingNewLine]rayfastlight = 
            False; \[IndentingNewLine]raygrey = 
            False; \[IndentingNewLine]rayglass = 
            False; \[IndentingNewLine]raypov = 
            False; \[IndentingNewLine]rayaspect = 
            False; \[IndentingNewLine]raytesselate = 
            False; \[IndentingNewLine]rayboxlines = 
            False; \[IndentingNewLine]raytubelines = 
            False; \[IndentingNewLine]raycsg = 
            False; \[IndentingNewLine]rayclipplotrange = 
            False; \[IndentingNewLine]\[IndentingNewLine]rayoverlay = 
            True; \[IndentingNewLine] (*\ olpr = {\(- .5\),  .5}; \ 
            hack\ dropped;\ *) \[IndentingNewLine]ola = \(- .001\); \
\[IndentingNewLine] (*\ 
            leave\ 10\ for\ tuck\ ins\ *) \[IndentingNewLine]olc =  .5 + 
              ola\ 10; \[IndentingNewLine]\[IndentingNewLine]globalsurf = \
"\<regular\>"; \[IndentingNewLine]vpRotAngles = {0, 0, 
              0}; \[IndentingNewLine]twospace = 
            False; \[IndentingNewLine]prasp = {1, 1, 
              1}; \[IndentingNewLine]newunit = 
            unit; \[IndentingNewLine]worecursion = 
            1; \[IndentingNewLine]polyrecursion = 
            1; \[IndentingNewLine]woonce = 
            False; \[IndentingNewLine]checktexture = 
            False; \[IndentingNewLine]origsymb =. ; \
\[IndentingNewLine]lasttransmit = "\<\>"; \[IndentingNewLine]rasterclear = 
            False; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            rayshade\ uses\ double\ unsure\ if\ used\ from\ file\ but\ ok; \
\[IndentingNewLine]is\ how\ you\ compile\ but\ C\ shouldnt\ balk\ if\ too\ \
long;\[IndentingNewLine]*) \[IndentingNewLine]maxprecision = 19; \  (*\ 
            for\ significand\ width\ using\ N\ *) \ \
\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s12"]
}, Closed]],

Cell[CellGroupData[{

Cell["write  funs", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s13"],

Cell["\<\
Simply Write a little.  This is just Write except numbers are \
handled automatically and spaces are inserted per element.  Write2 acts the \
same but writes to a string instead of stream.\
\>", "Text",
  CellTags->"s13"],

Cell[BoxData[
    \(newline[file_] := Write[file, "\<\>"]\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\(SetAttributes[newline2, HoldFirst];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(newline2[file_] := Write2[file, "\<\>"]\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell["\<\
(* FortranForm can write blob(-time) to which rayshade
  can use - though i doubt it should be used that way *)\
\>", "Text",
  CellTags->"s13"],

Cell[BoxData[
    \(\(nForm[r_] := FortranForm[r~N~maxprecision];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\(nsForm[r_] := FortranForm[r~N~maxprecision] // ToString;\)\)], "Input",\

  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\(nsForm2[r_] := 
        ToString[FortranForm[r~N~maxprecision]] <> "\< \>";\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell["\<\
(*
to keep with previously released code format for sake of anyone editing \
between both
the same writexxx are used ??
\tNEW.  it's more useful in code not to try to use this to do lists of \
<a,b,c>
*)\
\>", "Text",
  CellTags->"s13"],

Cell["we only take list of 3, caller uses Scan for many points", "Text",
  CellTags->"s13"],

Cell[BoxData[
    \(writevec[vl_] := 
      If[raypov === False, writeRay[vl], writePOV[vl]]\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(writeRay[vl_] := 
      nsForm[vl[\([1]\)]] <> "\< \>" <> nsForm[vl[\([2]\)]] <> "\< \>" <> 
        nsForm[vl[\([3]\)]] <> "\< \>"\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(writePOV[vl_] := "\<< \>" <> nsForm[vl[\([1]\)]] <> "\< , \>" <> 
        nsForm[vl[\([2]\)]] <> "\< , \>" <> 
        nsForm[vl[\([3]\)]] <> "\< > \>"\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell["\<\
(* these write to string, keeping \"code compatible\" with the file \
form *)\
\>", "Text",
  CellTags->"s13"],

Cell[BoxData[
    \(\(writeNums[file_, 
          vl___] := \[IndentingNewLine]Module[{inc, s = "\<\>", v, 
            v2}, \[IndentingNewLine]Scan[\((\[IndentingNewLine]If[StringQ[#], 
                  s = s <> # <> "\< \>", \[IndentingNewLine]If[
                    ListQ[#], \[IndentingNewLine]s = 
                      s <> writevec[#]\[IndentingNewLine], 
                    If[# =!= Null, 
                      s = s <> 
                          nsForm[#] <> "\< \>"]\[IndentingNewLine]]])\) &\
\[IndentingNewLine], {vl}]; \[IndentingNewLine]Write[file, 
            s]\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\((\[IndentingNewLine]Print["\<vl=\>", 
        vl]; \[IndentingNewLine]Print["\<vl1=\>", 
        vl[\([1]\)]]; \[IndentingNewLine]Print["\<vl1=\>", 
        vl[\([1]\)]]; \[IndentingNewLine]Print["\<hl1=\>", 
        Head[vl[\([1]\)]]]; \[IndentingNewLine]Print["\<ns1=\>", 
        nsForm[vl[\([1]\)]]]; \[IndentingNewLine]Abort[];)\)\)], "Input"],

Cell[BoxData[
    \(\(writeNumsFast[vl_] := 
        Write[file, 
          nsForm[vl[\([1]\)]] <> "\< \>" <> nsForm[vl[\([2]\)]] <> "\< \>" <> 
            nsForm[vl[\([3]\)]]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\(writeNumsFast6[vl_] := 
        Write[file, 
          nsForm[vl[\([1]\)]] <> "\< \>" <> nsForm[vl[\([2]\)]] <> "\< \>" <> 
            nsForm[vl[\([3]\)]] <> "\< \>" <> nsForm[vl[\([4]\)]] <> "\< \>" <> 
            nsForm[vl[\([5]\)]] <> "\< \>" <> 
            nsForm[vl[\([6]\)]]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\(writeNumsFastR[r_, vl_] := 
        Write[file, 
          nsForm[r] <> "\< \>" <> nsForm[vl[\([1]\)]] <> "\< \>" <> 
            nsForm[vl[\([2]\)]] <> "\< \>" <> 
            nsForm[vl[\([3]\)]]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\(writeNumsFastV[vl_] := 
        Module[{s = "\<\>"}, \[IndentingNewLine]s = 
            Map[nsForm2, Flatten[vl]]; \[IndentingNewLine]Write[file, 
            StringJoin@s]\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\(SetAttributes[writeNums2, HoldFirst];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(\(writeNums2[file_, 
          vl___] := \[IndentingNewLine]Module[{inc, s = "\<\>", v, 
            v2}, \[IndentingNewLine]Scan[\((\[IndentingNewLine]If[StringQ[#], 
                  s = s <> # <> "\< \>", \[IndentingNewLine]If[
                    ListQ[#], \[IndentingNewLine]s = 
                      s <> writevec[#]\[IndentingNewLine], 
                    If[# =!= Null, 
                      s = s <> 
                          nsForm[#] <> "\< \>"]\[IndentingNewLine]]])\) &\
\[IndentingNewLine], {vl}]; \[IndentingNewLine]Write2[file, 
            s]\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(SetAttributes[Write2, HoldFirst]\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell[BoxData[
    \(Write2[str_Symbol, v___ : "\<\>"] := 
      Module[{}, Unhold[str]; If[Head[str] \[NotEqual] String, Return[]]; 
        Unprotect[str]; Scan[\((str = str <> ToString[#])\) &, Flatten[{v}]]; 
        str = str <> "\<\n\>";]\)], "Input",
  InitializationCell->True,
  CellTags->"s13"],

Cell["(* unused *)", "Text",
  CellTags->"s13"],

Cell[BoxData[
    \(writeNumsString[txt_: "\<\>", r_?NumberQ] := 
      txt <> If[txt =!= "\<\>", "\< \>", "\<\>"] <> 
        ToString[nForm[r]] <> "\<\n\>"\)], "Input",
  CellTags->"s13"],

Cell[BoxData[
    \(writeNumsString[txt_: "\<\>", r_List] := 
      txt <> If[txt =!= "\<\>", "\< \>", "\<\>"] <> 
          Map[\((ToString[nForm[#]] <> "\< \>")\) &, r] <> "\<\n\>" // 
        StringJoin\)], "Input",
  CellTags->"s13"],

Cell["\<\
(*optional text followed by numbers,FortranForm with 5 \
digits*)\
\>", "Text",
  CellTags->"s13"],

Cell[BoxData[
    \( (*\[IndentingNewLine]ndig = 5; \[IndentingNewLine]nForm[r_] := 
        NumberForm[FortranForm[r], ndig]; \[IndentingNewLine]writeNums[file_, 
          txt_: "\<\>", r_?NumberQ] := 
        Write[file, txt, "\< \>", nForm[r]]; \[IndentingNewLine]writeNums[
          file_, txt_: "\<\>", r_List] := 
        Write[file, txt, "\< \>", 
          Infix[nForm /@ r, "\< \>"]];\[IndentingNewLine]*) \)], "Input",
  CellTags->"s13"]
}, Closed]],

Cell[CellGroupData[{

Cell["writeOptsRay", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s14"],

Cell[BoxData[
    \(writeOpts[file_] := 
      If[raypov === False, writeOptsRay[file], writeOptsPOV[file]]\)], "Input",\

  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(writeOptsRay[file_] := 
        Module[{}, \[IndentingNewLine]\[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\</* plot range:\>"]; \[IndentingNewLine] (*\ 
            to\ be\ clear, \ 
            due\ to\ writeNums\ hack\ *) \[IndentingNewLine] (*\ \
\(\(writeNums[file, "\< * \>", #] &\) /@ pr;\)\ *) \[IndentingNewLine]Write[
            file, "\< * \>" <> ToString[pr]]; \[IndentingNewLine]Write[
            file, "\<*/\>"]; \[IndentingNewLine]\[IndentingNewLine]newline[
            file]; \[IndentingNewLine]writeNums[file, "\<eyep\>", 
            eyep]; \[IndentingNewLine]writeNums[file, "\<lookp\>", 
            lookp]; \[IndentingNewLine]writeNums[file, "\<up\>", 
            up]; \[IndentingNewLine]writeNums[file, "\<fov\>", 
            fov]; \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]\[IndentingNewLine]If[
            raygrey === False, \[IndentingNewLine]Scan[
              doLightRay[file, pr, #] &, lights]; \[IndentingNewLine] (*\ 
              part\ 1\ of\ eyep\ light\ *) \[IndentingNewLine]writeNums[
              file, "\<light\>", {1, 1, 
                1}];\[IndentingNewLine], \[IndentingNewLine]\(writeNums[
                file, "\<light\>", {1.5, 1.5, 
                  1.5}];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ part\ 2\ of\ eyep\ light\ *) \[IndentingNewLine]If[
            rayfastlight === 
              True, \[IndentingNewLine]\(writeNums[file, "\<\tdirectional\>", 
                eyep];\)\[IndentingNewLine], \[IndentingNewLine]\(writeNums[
                file, "\<\textended 1.5 \>", 
                eyep\ 1.9];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
            eyep\ light\ is\ "\<always there\>"\ for\ stability\ "\<safety \
light\>"; \[IndentingNewLine]curently\ raygrey\ raygreyshade\ assume\ its\ \
there;\[IndentingNewLine]*) \[IndentingNewLine]\[IndentingNewLine]];\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, pr_, {{x_, y_, z_}, RGBColor[r_, g_, b_]}] := 
        Module[{scaled, v, 
            pos}, \[IndentingNewLine]pos = {x, y, 
              z}; \[IndentingNewLine]writeNums[
            file, "\<light\>", {r, g, b}]; \[IndentingNewLine] (*\ 
            un - normalize\ first\ *) \[IndentingNewLine]v = \((pos + 
                  boxcenter)\)\ scenedepth\ 1.01; \[IndentingNewLine]If[
            rayfastlight === 
              True, \[IndentingNewLine]\(writeNums[file, "\<\tdirectional\>", 
                v];\)\[IndentingNewLine], \[IndentingNewLine]\(writeNums[
                file, "\<\textended 1.5 \>", 
                v\ 1.9];\)\[IndentingNewLine]];\[IndentingNewLine]];\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell["\<\
Note: in mm v4.0 Gray[] evalutaes to RGBColor unless held.  Hue \
apparently doesn't.  White does.\
\>", "Text",
  CellTags->"s14"],

Cell[BoxData[
    \( (*\[IndentingNewLine]\(doLightRay[file_, 
            pr_, {{x_, y_, z_}, RGBColor[r_, g_, b_] | Gray[h_]}] := 
          Module[{scaled, v, pos}, \[IndentingNewLine]Print["\<rgb \>", r, g, 
              b]; \[IndentingNewLine]If[
              NumericQ[Symbol["\<h\>"]], \[IndentingNewLine]Print["\<huh?\>", 
                h, "\< \>", Information[h]]; \[IndentingNewLine]Unprotect[r, 
                g, b]; \[IndentingNewLine]r = h; b = h; 
              g = h;\[IndentingNewLine]]; \[IndentingNewLine]pos = {x, y, 
                z}; \[IndentingNewLine]writeNums[
              file, "\<light\>", {r, g, b}]; \[IndentingNewLine] (*\ 
              un - normalize\ first\ *) \[IndentingNewLine]v = \((pos + 
                    boxcenter)\)\ scenedepth\ 1.01; \[IndentingNewLine]If[
              rayfastlight === 
                True, \[IndentingNewLine]\(writeNums[
                  file, "\<\tdirectional\>", 
                  v];\)\[IndentingNewLine], \[IndentingNewLine]\(writeNums[
                  file, "\<\textended 1.5 \>", 
                  v\ 1.9];\)\[IndentingNewLine]];\[IndentingNewLine]];\)\
\[IndentingNewLine]*) \)], "Input",
  CellTags->"s14"],

Cell["mm v. 9 hack", "Text",
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, pr_, {"\<ambient\>", RGBColor[r_, g_, b_]}] := 
        Module[{scaled, 
            v}, \[IndentingNewLine]\(writeNums[
              file, "\<light\>", {r, g, 
                b}, "\< ambient\>"];\)\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, 
          pr_, {"\<Directional\>", RGBColor[r_, g_, b_], pos_}] := 
        Module[{scaled, v}, \[IndentingNewLine]writeNums[
            file, "\<light\>", {r, g, 
              b}]; \[IndentingNewLine]v = \((pos + 
                  boxcenter)\)\ scenedepth\ 1.01; \
\[IndentingNewLine]writeNums[file, "\<\tdirectional\>", 
            v];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, 
          pr_, {"\<Directional\>", RGBColor[r_, g_, b_], {pos_, pos2_}}] := 
        doLightRay[file, 
          pr, {"\<Directional\>", 
            RGBColor[r, g, b], {pos2 - pos1}}];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, pr_, {"\<Point\>", RGBColor[r_, g_, b_], pos_}] := 
        Module[{scaled, v}, \[IndentingNewLine]writeNums[
            file, "\<light\>", {r, g, b}]; \[IndentingNewLine]writeNums[
            file, "\<\tpoint \>", pos];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell["\<\
haven't tried spot before.  at least it will be more compatible

aa angle, s angle, {a,b,c} \"geometric falloff\", s spot exp
\tmy interpretation of \"geom. attenuation\" is a guess, esp use of s\
\>", \
"Text",
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, 
          pr_, {"\<Point\>", RGBColor[r_, g_, b_], pos_, {a_, b_, c_}}] := 
        Module[{scaled, v, R}, \[IndentingNewLine]writeNums[
            file, "\<light\>", {r, g, b}]; \[IndentingNewLine]R = 
            magnitude[vp]; \[IndentingNewLine]writeNums[file, "\<\tspot \>", 
            pos, boxcenter, 
            1/\((c\ R^2 + b\ R + a)\)];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, 
          pr_, {"\<Spot\>", RGBColor[r_, g_, b_], pos_, aa_}] := 
        Module[{scaled, v}, \[IndentingNewLine]writeNums[
            file, "\<light\>", {r, g, b}]; \[IndentingNewLine]writeNums[
            file, "\<\tspot \>", pos, boxcenter, 
            aa];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, 
          pr_, {"\<Spot\>", RGBColor[r_, g_, b_], {pos_, pos2_}, aa_}] := 
        Module[{scaled, v}, \[IndentingNewLine]writeNums[
            file, "\<light\>", {r, g, b}]; \[IndentingNewLine]writeNums[
            file, "\<\tspot \>", pos, pos2, 1, aa, 
            aa];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, 
          pr_, {"\<Spot\>", 
            RGBColor[r_, g_, b_], {pos_, pos2_}, {aa_, s_}, {a_, b_, c_}}] := 
        Module[{scaled, v, R}, \[IndentingNewLine]writeNums[
            file, "\<light\>", {r, g, b}]; \[IndentingNewLine]R = 
            magnitude[vp]; \[IndentingNewLine]writeNums[file, "\<\tspot \>", 
            pos, pos2, 1/\((c\ R^s + b\ R + a)\), 
            aa];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \( (*\[IndentingNewLine]scaled = 
        boxScale[pr, pos]; \[IndentingNewLine]writeNums[
        file, "\<light\>", {r, g, b}]; \[IndentingNewLine]writeNums[
        file, "\<\tpoint\>", scaled];\[IndentingNewLine]*) \)], "Input",
  CellTags->"s14"],

Cell[BoxData[
    \(\(writeOptsPOV[file_] := 
        Module[{}, \[IndentingNewLine]\[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\</* plot range:\>"]; \[IndentingNewLine] (*\ 
            to\ be\ clear, \ 
            due\ to\ writeNums\ hack\ *) \[IndentingNewLine] (*\ \
\(\(writeNums[file, "\< * \>", #] &\) /@ pr;\)\ *) \[IndentingNewLine]Write[
            file, "\< * \>" <> ToString[pr]]; \[IndentingNewLine]Write[
            file, "\<*/\>"]; \[IndentingNewLine]\[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\<camera {\>"]; \[IndentingNewLine]Write[
            file, \ "\<right x\>"]; \[IndentingNewLine]writeNums[
            file, "\<up \>", up]; \[IndentingNewLine]writeNums[
            file, "\<location \>", eyep]; \[IndentingNewLine]writeNums[
            file, "\<look_at \>", lookp]; \[IndentingNewLine]writeNums[
            file, "\<sky \>", up]; \[IndentingNewLine]writeNums[
            file, "\<angle \>", fov]; \[IndentingNewLine]Write[
            file, "\<}\>"]; \[IndentingNewLine]\[IndentingNewLine] (*\ 
            FIXME : \ 
              despite\ any\ variation\ of\ the\ above\ the; \
\[IndentingNewLine]POV\ result\ is\ all\ slanted; \ 
            fix\ may\ not\ be\ perfect; \[IndentingNewLine]and\ likely\ won' 
              t\ work\ if\ parameters\ above\ change;\[IndentingNewLine]\
*) \[IndentingNewLine] (*\ was\ missing\ sky; \ 
            lucky\ i\ didnt\ need\ direction; \[IndentingNewLine]Write[
              file, "\<  rotate < 0, 0, 25 >\>"]; \[IndentingNewLine]Write[
              file, "\<  rotate < 25, 0, 0 >\>"]; \[IndentingNewLine]Write[
              file, "\<  rotate < 0, -25, 0 >\>"];\[IndentingNewLine]\
*) \[IndentingNewLine]\[IndentingNewLine]If[
            raygrey === 
              False, \[IndentingNewLine]\(Scan[doLightPOV[file, pr, #] &, 
                lights];\)\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ eyep\ light\ *) \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\<light_source {\>"]; \[IndentingNewLine]writeNums[file, 
            vp]; \[IndentingNewLine]If[
            raygrey === 
              False, \[IndentingNewLine]\(Write[
                file, "\<color rgb < 1, 1, 1 >\>"];\)\[IndentingNewLine], \
\[IndentingNewLine]\(Write[
                file, "\<color rgb < 1.5, 1.5, 1.5 \
>\>"];\)\[IndentingNewLine]]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightPOV[file_, pr_, {pos_, RGBColor[r_, g_, b_]}] := 
        Module[{scaled, v}, \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\<light_source {\>"]; \[IndentingNewLine]v = \((pos + 
                  boxcenter)\)\ scenedepth\ 1.01; \
\[IndentingNewLine]writeNums[file, v]; \[IndentingNewLine]writeNums[
            file, "\<color rgb \>", {r, g, b}]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell["these are roughed in", "Text"],

Cell[BoxData[
    \(\(doLightPOV[file_, 
          pr_, {"\<Spot\>", 
            RGBColor[r_, g_, b_], {pos_, pos2_}, {aa_, s_}, {a_, b_, c_}}] := 
        Module[{scaled, v, R}, \[IndentingNewLine]R = 
            magnitude[vp]; \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\<light_source {\>"]; \[IndentingNewLine]writeNums[file, 
            pos]; \[IndentingNewLine]writeNums[
            file, "\<color rgb \>", {r, g, b}]; \[IndentingNewLine]writeNums[
            file, "\<spotlight\>"]; \[IndentingNewLine]writeNums[
            file, "\<radius \>", 1]; \[IndentingNewLine]writeNums[
            file, "\<falloff \>", 
            1/\((c\ R^s + b\ R + a)\)]; \[IndentingNewLine]writeNums[
            file, "\<tightness \>", aa]; \[IndentingNewLine]writeNums[
            file, "\<point_at \>", pos2]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightPOV[file_, 
          pr_, {"\<Spot\>", RGBColor[r_, g_, b_], {pos_, pos2_}, 
            aa_, {a_, b_, c_}}] := 
        Module[{scaled, v, R}, \[IndentingNewLine]R = 
            magnitude[vp]; \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\<light_source {\>"]; \[IndentingNewLine]writeNums[file, 
            pos]; \[IndentingNewLine]writeNums[
            file, "\<color rgb \>", {r, g, b}]; \[IndentingNewLine]writeNums[
            file, "\<spotlight\>"]; \[IndentingNewLine]writeNums[
            file, "\<radius \>", 1]; \[IndentingNewLine]writeNums[
            file, "\<falloff \>", aa]; \[IndentingNewLine]writeNums[
            file, "\<tightness \>", aa]; \[IndentingNewLine]writeNums[
            file, "\<point_at \>", pos2]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightPOV[file_, 
          pr_, {"\<Spot\>", RGBColor[r_, g_, b_], pos_, aa_}] := 
        Module[{scaled, v, R}, \[IndentingNewLine]R = 
            magnitude[vp]; \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\<light_source {\>"]; \[IndentingNewLine]writeNums[file, 
            pos]; \[IndentingNewLine]writeNums[
            file, "\<color rgb \>", {r, g, b}]; \[IndentingNewLine]writeNums[
            file, "\<spotlight\>"]; \[IndentingNewLine]writeNums[
            file, "\<radius \>", 1]; \[IndentingNewLine]writeNums[
            file, "\<falloff \>", aa]; \[IndentingNewLine]writeNums[
            file, "\<tightness \>", aa]; \[IndentingNewLine]writeNums[
            file, "\<point_at \>", boxcenter]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightPOV[file_, 
          pr_, {"\<Point\>", RGBColor[r_, g_, b_], pos_, {a_, b_, c_}}] := 
        Module[{scaled, v, R}, \[IndentingNewLine]R = 
            magnitude[vp]; \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\<light_source {\>"]; \[IndentingNewLine]writeNums[file, 
            pos]; \[IndentingNewLine]writeNums[
            file, "\<color rgb \>", {r, g, b}]; \[IndentingNewLine]writeNums[
            file, "\<spotlight\>"]; \[IndentingNewLine]writeNums[
            file, "\<radius \>", 1]; \[IndentingNewLine]writeNums[
            file, "\<falloff \>", 
            1/\((c\ R^2 + b\ R + a)\)]; \[IndentingNewLine]writeNums[
            file, "\<tightness \>", 10]; \[IndentingNewLine]writeNums[
            file, "\<point_at \>", boxcenter]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightPOV[file_, pr_, {"\<ambient\>", RGBColor[r_, g_, b_]}] := 
        Module[{scaled, v}, \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]writeNums[
            file, "\<global_settings { \>"]; \[IndentingNewLine]writeNums[
            file, "\<ambient_light rgb \>", {r, g, 
              b}]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightPOV[file_, 
          pr_, {"\<Directional\>", RGBColor[r_, g_, b_], pos_}] := 
        Module[{scaled, 
            v}, \[IndentingNewLine]v = \((pos + 
                  boxcenter)\)\ scenedepth\ 1.01; \[IndentingNewLine]newline[
            file]; \[IndentingNewLine]Write[
            file, "\<light_source {\>"]; \[IndentingNewLine]writeNums[file, 
            v]; \[IndentingNewLine]writeNums[
            file, "\<color rgb \>", {r, g, b}]; \[IndentingNewLine]writeNums[
            file, "\<spotlight\>"]; \[IndentingNewLine]writeNums[
            file, "\<radius \>", 1]; \[IndentingNewLine]writeNums[
            file, "\<falloff \>", 10]; \[IndentingNewLine]writeNums[
            file, "\<tightness \>", 10]; \[IndentingNewLine]writeNums[
            file, "\<point_at \>", boxcenter]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightPOV[file_, 
          pr_, {"\<Directional\>", RGBColor[r_, g_, b_], {pos_, pos2_}}] := 
        doLightPOV[file, 
          pr, {"\<Directional\>", 
            RGBColor[r, g, b], {pos2 - pos1}}];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"],

Cell[BoxData[
    \(\(doLightRay[file_, 
          pr_, {"\<Point\>", RGBColor[r_, g_, b_], 
            pos_}] := \[IndentingNewLine]doLightPOV[file, 
          pr, {pos, RGBColor[r, g, b]}];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s14"]
}, Closed]],

Cell[CellGroupData[{

Cell["misc funs", "Subsection",
  Background->GrayLevel[0.900008],
  CellTags->"s15"],

Cell["(*the 8 box points for boxing PlotRange*)", "Text",
  CellTags->"s15"],

Cell[BoxData[
    \(prbox[
        pr_] := {\[IndentingNewLine] (*\ 
          low\ counter\ clockwise\ *) \[IndentingNewLine]{pr[\([1, 1]\)], 
          pr[\([2, 1]\)], 
          pr[\([3, 1]\)]}, \[IndentingNewLine]{pr[\([1, 2]\)], 
          pr[\([2, 1]\)], 
          pr[\([3, 1]\)]}, \[IndentingNewLine]{pr[\([1, 2]\)], 
          pr[\([2, 2]\)], 
          pr[\([3, 1]\)]}, \[IndentingNewLine]{pr[\([1, 1]\)], 
          pr[\([2, 2]\)], pr[\([3, 1]\)]}, \[IndentingNewLine] (*\ 
          high\ cc\ *) \[IndentingNewLine]{pr[\([1, 1]\)], pr[\([2, 1]\)], 
          pr[\([3, 2]\)]}, \[IndentingNewLine]{pr[\([1, 2]\)], 
          pr[\([2, 1]\)], 
          pr[\([3, 2]\)]}, \[IndentingNewLine]{pr[\([1, 2]\)], 
          pr[\([2, 2]\)], 
          pr[\([3, 2]\)]}, \[IndentingNewLine]{pr[\([1, 1]\)], 
          pr[\([2, 2]\)], pr[\([3, 2]\)]}\[IndentingNewLine]}\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell["(* lines to make the 12 bounding box lines *)", "Text",
  CellTags->"s15"],

Cell[BoxData[
    \(prboxline[pr_] := 
      Module[{box}, \[IndentingNewLine]box = 
          prbox[pr]; \[IndentingNewLine] (*\ 
          finish\ *) \[IndentingNewLine]AppendTo[box, 
          box[\([5]\)]]; \[IndentingNewLine]box = 
          Insert[box, box[\([1]\)], 5]; \[IndentingNewLine] (*\ 
          legs\ *) \[IndentingNewLine]AppendTo[box, 
          box[\([1]\)]]; \[IndentingNewLine]AppendTo[box, 
          box[\([6]\)]]; \[IndentingNewLine]AppendTo[box, 
          box[\([2]\)]]; \[IndentingNewLine]AppendTo[box, 
          box[\([7]\)]]; \[IndentingNewLine]AppendTo[box, 
          box[\([3]\)]]; \[IndentingNewLine]AppendTo[box, 
          box[\([8]\)]]; \[IndentingNewLine]AppendTo[box, 
          box[\([4]\)]]; \[IndentingNewLine]AppendTo[box, 
          box[\([9]\)]]; \[IndentingNewLine]{\[IndentingNewLine]Line[
            Take[box, {1, 5}]], \[IndentingNewLine]Line[
            Take[box, {6, 10}]], \[IndentingNewLine]Line[
            Take[box, {11, 12}]], \[IndentingNewLine]Line[
            Take[box, {13, 14}]], \[IndentingNewLine]Line[
            Take[box, {15, 16}]], \[IndentingNewLine]Line[
            Take[box, {17, 
                18}]]\[IndentingNewLine]}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(prbox2d[
        pr_] := {\[IndentingNewLine] (*\ 
          face\ cc\ *) \[IndentingNewLine]{pr[\([1, 1]\)], pr[\([2, 1]\)], 
          pr[\([3, 1]\)]}, \[IndentingNewLine]{pr[\([1, 2]\)], 
          pr[\([2, 1]\)], 
          pr[\([3, 1]\)]}, \[IndentingNewLine]{pr[\([1, 2]\)], 
          pr[\([2, 1]\)], 
          pr[\([3, 2]\)]}, \[IndentingNewLine]{pr[\([1, 1]\)], 
          pr[\([2, 1]\)], pr[\([3, 2]\)]}\[IndentingNewLine]}\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(prboxline2d[pr_] := 
      Module[{box}, \[IndentingNewLine]box = 
          prbox2d[pr]; \[IndentingNewLine] (*\ 
          finish\ *) \[IndentingNewLine]AppendTo[box, 
          box[\([1]\)]]; \[IndentingNewLine]{\[IndentingNewLine]Line[
            Take[box, {1, 2}]], \[IndentingNewLine]Line[
            Take[box, {2, 3}]], \[IndentingNewLine]Line[
            Take[box, {3, 4}]], \[IndentingNewLine]Line[
            Take[box, {4, 
                5}]]\[IndentingNewLine]}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(pointInPlotRange[v_] := 
      If[\[IndentingNewLine]v[\([1]\)]\  >= pr[\([1, 1]\)] && 
          v[\([1]\)] <= pr[\([1, 2]\)]\[IndentingNewLine] && 
          v[\([2]\)]\  >= pr[\([2, 1]\)] && 
          v[\([2]\)] <= pr[\([2, 2]\)]\[IndentingNewLine] && 
          v[\([3]\)]\  >= pr[\([3, 1]\)] && 
          v[\([3]\)] <= pr[\([3, 2]\)]\[IndentingNewLine], 
        v\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell["(* the 5 points for polygon rectangle given ... *)", "Text",
  CellTags->"s15"],

Cell[BoxData[
    \(\(rectpoints[low_, w_, h_, norm_, up_] := 
        Module[{W, H, uw, uh}, \[IndentingNewLine]uw = 
            Cross[up, norm]; \[IndentingNewLine]uw = \ 
            uw/magnitude[uw]; \[IndentingNewLine]uh = 
            Cross[norm, uw]; \[IndentingNewLine]W = 
            w\ uw; \[IndentingNewLine]H = 
            h\ uh/magnitude[uh]; \[IndentingNewLine] (*\ 
            counter\ clockwise\ *) \[IndentingNewLine]{low, low + W, 
              low + W + H, low + H, low}~N~
            maxprecision\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(magnitude[v_, 
        w_] := \((\((v[\([1]\)] - w[\([1]\)])\)^2 + \((v[\([2]\)] - 
                  w[\([2]\)])\)^2 + \((v[\([3]\)] - w[\([3]\)])\)^2)\)^\((1/
            2)\)\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(magnitude[
        v_] := \((\((v[\([1]\)])\)^2 + \((v[\([2]\)])\)^2 + \
\((v[\([3]\)])\)^2)\)^\((1/2)\)\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(magnitude2[v_, 
        w_] := \((\((v[\([1]\)] - w[\([1]\)])\)^2 + \((v[\([2]\)] - 
                  w[\([2]\)])\)^2)\)^\((1/2)\)\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(magnitude2[
        v_] := \((\((v[\([1]\)])\)^2 + \((v[\([2]\)])\)^2)\)^\((1/
            2)\)\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell["\<\
(* v.u/mag...; assume divide by zero is impossible for a scene; \
*)\
\>", "Text",
  CellTags->"s15"],

Cell[BoxData[
    \(viewAnglesAtMul[{mul_, A_, targA_}] := 
      Module[{inc, u, v, w, angle, a, lstep}, \[IndentingNewLine]angle = 
          0; \[IndentingNewLine]v = mul\ unit\ ; \[IndentingNewLine]lstep = 
          scenedepth/100; \[IndentingNewLine]For[inc = 1, 
          inc \[LessEqual] 8, \(++inc\), \[IndentingNewLine]w = 
            box[\([inc]\)] - boxcenter; \[IndentingNewLine]u = 
            v - w; \[IndentingNewLine]a = \ \((v . 
                  u)\)/\((magnitude[v]\ magnitude[
                    u])\); \[IndentingNewLine]a = 
            a // ArcCos; \[IndentingNewLine]a = 
            2\ a/Degree; \[IndentingNewLine]If[Head[a] \[Equal] Complex, 
            a = 0]; \[IndentingNewLine]\(If[a > angle, 
              angle = a];\)\[IndentingNewLine]]; \[IndentingNewLine]If[
          targA > Abs[angle], lstep = lstep, 
          lstep = \(-lstep\)]; \[IndentingNewLine]{mul - lstep, angle, targA}~
          N~maxprecision\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(\(\( (*\ \(v = 
          mul\ unit\  + 
            boxcenter;\)\ *) \)\(\ \)\(\[IndentingNewLine]\)\( (*\ 
      angle\ 0\ causes\ unsure\ what\ very\ wide\ do\ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      Print["\<angle to corner \>", inc, "\< = \>", a]; \ 
      targA\ around\ 45;\ *) \)\(\[IndentingNewLine]\)\)\)], "Input",
  CellTags->"s15"],

Cell[BoxData[
    \(viewPointMulSearch[{mul_, A_, targA_}] := 
      Module[{inc, last, ret, beforelast}, \[IndentingNewLine]last = 0; 
        beforelast = 0; \[IndentingNewLine]ret = 
          viewAnglesAtMul[{mul, A, targA}]; \[IndentingNewLine]For[inc = 1, 
          inc < 1000, \(++inc\), \[IndentingNewLine]ret = 
            viewAnglesAtMul[ret]; \[IndentingNewLine]If[
            ret[\([2]\)] > \((targA -  .1)\) && 
              ret[\([2]\)] < \((targA +  .1)\), 
            Break[]]; \[IndentingNewLine] (*\ \(if\ alternates\ between\ two\ \
close\ nums;\)\ *) \[IndentingNewLine]If[ret[\([2]\)] \[Equal] beforelast, 
            Break[]]; \[IndentingNewLine]beforelast = 
            last; \[IndentingNewLine]last = 
            ret[\([2]\)];\[IndentingNewLine]]; \
\[IndentingNewLine]ret[\([1]\)]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \( (*\ \(Print["\<scene: inc \>", inc, \ "\< step \>", 
          scenedepth/100, "\< mul ang targ \>", ret];\)\ *) \)], "Input",
  CellTags->"s15"],

Cell["(* Needs[\"DiscreteMath`ComputationalGeometry`\"]; *)", "Text",
  CellTags->"s15"],

Cell[BoxData[
    \(tessfunSP[gr_] := 
      Module[{g, g2, 
          q}, \[IndentingNewLine] (*\ \
\(Needs["\<DiscreteMath`ComputationalGeometry`\>"];\)\ *) \n
        If[Head[gr] =!= Graphics3D, g = Graphics3D[gr], 
          g = gr]; \[IndentingNewLine]g2 = 
          g[\([1]\)] /. Polygon[q___] \[Rule] q; \n
        g2 = Partition[Flatten[g2], 3]; \n
        TriangularSurfacePlot[g2, 
          DisplayFunction \[Rule] Identity]\[IndentingNewLine]]\)], "Input",
  CellTags->"s15"],

Cell[BoxData[
    \(tessfunPolySP[vl_List] := 
      Module[{v, g, q}, \nv = Partition[Flatten[vl], 3]; \n
        g = TriangularSurfacePlot[v, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]g[\([1, 
              1]\)] /. Polygon[q___] \[Rule] q\[IndentingNewLine]]\)], "Input",\

  CellTags->"s15"],

Cell[BoxData[
    \( (*\ tessfunPoly\ returns\ closed\ poly*) \)], "Input"],

Cell[BoxData[
    \(tessfunPoly[vl_List] := 
      Module[{v, center, len}, \[IndentingNewLine]v = 
          vl; \[IndentingNewLine]If[Last[v] =!= First[v], 
          AppendTo[v, First[v]]]; \[IndentingNewLine]len = Length[v]; \  (*\ 
          in\ cc\ order\ given\ good\ poly\ *) \[IndentingNewLine]center = 
          Apply[Plus, v]/len; \[IndentingNewLine]Table[{v[\([inc - 1]\)], 
            v[\([inc]\)], center, v[\([inc - 1]\)]}\[IndentingNewLine], {inc, 
            2, len}]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \( (*\ 
      tessfunPoly\ returns\ open\ poly\ for\ use\ with\ triangle\ *) \)], \
"Input"],

Cell[BoxData[
    \(tessfunPoly3[vl_List] := 
      Module[{v, center, len}, \[IndentingNewLine]v = 
          vl; \[IndentingNewLine]If[Last[v] =!= First[v], 
          AppendTo[v, First[v]]]; \[IndentingNewLine]len = Length[v]; \  (*\ 
          in\ cc\ order\ given\ good\ poly\ *) \[IndentingNewLine]center = 
          Apply[Plus, v]/len; \[IndentingNewLine]Table[{v[\([inc - 1]\)], 
            v[\([inc]\)], center}\[IndentingNewLine], {inc, 2, 
            len}]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \(\(callwriteobj[obj___] := 
        Module[{a, h, pos}, \[IndentingNewLine]a = 
            Hold[obj]; \[IndentingNewLine]h = 
            ToString[a[\([1, 0]\)]]; \[IndentingNewLine]a[\([1, 0]\)] = 
            List; \[IndentingNewLine]pos = 
            StringPosition[
              h, "\<`\>"]; \  (*strip\ context*) \[IndentingNewLine]If[
            pos =!= {}, \[IndentingNewLine]pos = 
              Last[pos[\([2]\)]]; \[IndentingNewLine]h = 
              StringDrop[
                h, {1, pos}];\[IndentingNewLine]]; \[IndentingNewLine] \
(*\[IndentingNewLine]h = Symbol[h]; \[IndentingNewLine]h = 
              h /. {Graphics \[Rule] rGraphics, 
                  Graphics3D \[Rule] rGraphics3D, Polygon \[Rule] rPolygon, 
                  Line \[Rule] rLine, Line2 \[Rule] rLine2, 
                  Point \[Rule] rPoint, Cuboid \[Rule] rCuboid, 
                  Sphere \[Rule] rSphere, Text \[Rule] rText, 
                  Raster \[Rule] rRaster, 
                  RasterArray \[Rule] rRasterArray}; \[IndentingNewLine] (*\ 
              Print["\<calling h= \>", 
                h]; \[IndentingNewLine]Print["\<with    a= \>", 
                a];\ *) \[IndentingNewLine]writeobj[h, 
              a];\[IndentingNewLine]*) \[IndentingNewLine]\[IndentingNewLine] \
(*\[IndentingNewLine]h = 
              StringReplace[
                h, {"\<Graphics\>" \[Rule] "\<rGraphics\>", \
"\<SurfaceGraphics\>" \[Rule] "\<rSurfaceGraphics\>", "\<Graphics3D\>" \
\[Rule] "\<rGraphics3D\>", "\<Polygon\>" \[Rule] "\<rPolygon\>", "\<Line\>" \
\[Rule] "\<rLine\>", "\<Line2\>" \[Rule] "\<rLine2\>", "\<Point\>" \[Rule] \
"\<rPoint\>", "\<Cuboid\>" \[Rule] "\<rCuboid\>", "\<Sphere\>" \[Rule] \
"\<rSphere\>", "\<Text\>" \[Rule] "\<rText\>", "\<Raster\>" \[Rule] \
"\<rRaster\>", "\<RasterArray\>" \[Rule] "\<rRasterArray\>"}]; \
\[IndentingNewLine]\[IndentingNewLine]h = 
              StringReplace[
                h, "\<rr\>" \[Rule] "\<r\>"];\[IndentingNewLine]\
*) \[IndentingNewLine]\[IndentingNewLine]If[
            h \[NotEqual] "\<List\>", \[IndentingNewLine]origsymb = 
              h; \[IndentingNewLine]pos = 
              StringPosition[
                h, "\<`\>"]; \  (*strip\ context*) \[IndentingNewLine]If[
              pos =!= {}, \[IndentingNewLine]pos = 
                Last[pos[\([2]\)]]; \[IndentingNewLine]h = 
                StringDrop[
                  h, {1, pos}];\[IndentingNewLine]]; \[IndentingNewLine]If[
              StringTake[h, 1] =!= "\<r\>", 
              h = "\<r\>" <> 
                  h];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\ \(Print["\<post /. \>", 
                Symbol[h]];\)\ *) \[IndentingNewLine] (*\ h = Symbol[h]; \ 
            broken\ ?\ 
                never\ matches\ fun\ \(\(call\)\(\ \)\(?\)\)\ \
*) \[IndentingNewLine]\[IndentingNewLine] \
(*\[IndentingNewLine]Print["\<calling h= \>", 
              h]; \[IndentingNewLine]Print["\<with    a= \>", 
              a]; \[IndentingNewLine]Print["\<with   a1= \>", 
              a[\([1]\)]]; \[IndentingNewLine]Print["\<with   a2= \>", 
              a[\([2]\)]];\[IndentingNewLine]*) \[IndentingNewLine]\
\[IndentingNewLine]writeobj[h, a];\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True,
  CellTags->"s15"],

Cell[BoxData[
    \( (*{Hue[col +=  .1], 
        Polygon[{v[\([inc - 1]\)], v[\([inc]\)], c, 
            v[\([inc - 1]\)]}]}\ *) \)], "Input",
  CellTags->"s15"],

Cell["\<\
Csg diff list is like
\tdifference
\tdifference
\tobject
\t\tsurfspec
\t\tgr1
\t\ttranslations
\t\tfinal trans (asect ratio saling)
\tobject gr1diff
\tend
\tobject gr1diff2
\tend

instead of just
\tobject surf gr1 trans ascale

\"gr1diff1  end\" \"gr1diff2  end\"  must be last in trans for gr1 which \
isn't a limitation as it must apply to whole gr1 anyhow\
\>", "Text"],

Cell[BoxData[
    \(\(boundingbox[pr_] := 
        Module[{xl, xh, yl, yh, zl, zh, gr0, gr1, gr2, gr3, 
            str}, \[IndentingNewLine]\[IndentingNewLine]xl = 
            pr[\([1, 1]\)] - linewidth*3; \[IndentingNewLine]yl = 
            pr[\([2, 1]\)] - linewidth*3; \[IndentingNewLine]zl = 
            pr[\([3, 1]\)] - linewidth*3; \[IndentingNewLine]xh = 
            pr[\([1, 2]\)] + linewidth*3; \[IndentingNewLine]yh = 
            pr[\([2, 2]\)] + linewidth*3; \[IndentingNewLine]zh = 
            pr[\([3, 2]\)] + linewidth*3; \[IndentingNewLine]gr0 = "\<gr\>" <> 
              ToString@grcount; \[IndentingNewLine]gr1 = "\<gr\>" <> 
              ToString@grcount <> 
              ToString@primcount; \[IndentingNewLine]gr2 = "\<gr\>" <> 
              ToString@grcount <> 
              ToString@\((primcount + 
                    1)\); \[IndentingNewLine]gr3 = "\<gr\>" <> 
              ToString@grcount <> 
              ToString@\((primcount + 2)\); \[IndentingNewLine]If[
            raypov === False, \[IndentingNewLine]writeNums[
              file, "\<name \>" <> gr1]; \[IndentingNewLine]writeNums[
              file, "\<list\>"]; \[IndentingNewLine]XrCuboid[{2 {xl, yl, zl}, 
                2 {xh, yh, zh}}]; \[IndentingNewLine]writeNums[
              file, "\<end\>"]; \[IndentingNewLine]\(++primcount\); \
\[IndentingNewLine]writeNums[
              file, "\<name \>" <> gr2]; \[IndentingNewLine]writeNums[
              file, "\<list\>"]; \[IndentingNewLine]XrCuboid[{{xl, yl, 
                  zl}, {xh, yh, zh}}]; \[IndentingNewLine]writeNums[
              file, "\<end\>"]; \[IndentingNewLine]\(++primcount\); \
\[IndentingNewLine]writeNums[
              file, "\<name \>" <> gr3]; \[IndentingNewLine]writeNums[
              file, "\<list\>"]; \[IndentingNewLine]writeNums[
              file, "\<difference \>"]; \[IndentingNewLine]writeNums[
              file, "\<object \>" <> gr1 <> "\< object \>" <> 
                gr2]; \[IndentingNewLine]writeNums[
              file, "\<end\>"]; \[IndentingNewLine]writeNums[
              file, "\<end\>"]; \[IndentingNewLine]str = "\<\>"; \
\[IndentingNewLine] (*\ 
              as\ implemented\ these\ hurt\ more\ than\ help\ \
*) \[IndentingNewLine] (*\ \(writeNums2[
                  str, "\<difference \>"];\)\ *) \[IndentingNewLine] (*\ \
\(writeNums2[str, "\<object \>" <> gr0 <> "\< object \>" <> 
                    gr3];\)\ *) \[IndentingNewLine]writeNums2[
              str, "\<object \>" <> gr3]; \[IndentingNewLine]writeNums2[
              str, "\<end\>"]; \[IndentingNewLine]applytrans[
              str];\[IndentingNewLine]]; \[IndentingNewLine]\
\[IndentingNewLine]If[
            raypov === True, \[IndentingNewLine]writeNums[
              file, "\<#declare \>" <> 
                gr1 <> "\< = union {\>"]; \[IndentingNewLine]XrCuboid[{2 {xl, 
                    yl, zl}, 2 {xh, yh, zh}}]; \[IndentingNewLine]writeNums[
              file, "\<}\>"]; \[IndentingNewLine]\(++primcount\); \
\[IndentingNewLine]writeNums[
              file, "\<#declare \>" <> 
                gr2 <> "\< = union {\>"]; \[IndentingNewLine]XrCuboid[{{xl, 
                  yl, zl}, {xh, yh, zh}}]; \[IndentingNewLine]writeNums[
              file, "\<}\>"]; \[IndentingNewLine]\(++primcount\); \
\[IndentingNewLine]writeNums[
              file, "\<#declare \>" <> 
                gr3 <> "\< = union {\>"]; \[IndentingNewLine]writeNums[
              file, "\<difference { \>"]; \[IndentingNewLine]writeNums[
              file, "\<object { \>" <> 
                gr1 <> "\< } \>"]; \[IndentingNewLine]writeNums[
              file, "\<object { \>" <> 
                gr2 <> "\< } \>"]; \[IndentingNewLine]writeNums[
              file, "\<}\>"]; \[IndentingNewLine]writeNums[
              file, "\<}\>"]; \[IndentingNewLine]str = "\<\>"; \
\[IndentingNewLine] (*\ 
              as\ implemented\ these\ hurt\ more\ than\ help\ \
*) \[IndentingNewLine] (*\ \(writeNums2[
                  str, "\<difference { \>"];\)\ *) \[IndentingNewLine] (*\ \
\(writeNums2[str, "\<object \>" <> gr0 <> "\< object \>" <> 
                    gr3];\)\ *) \[IndentingNewLine]writeNums2[
              str, "\<object { \>" <> 
                gr3 <> "\< } \>"]; \[IndentingNewLine]writeNums2[
              str, "\<}\>"]; \[IndentingNewLine]applytrans[
              str];\[IndentingNewLine]];\[IndentingNewLine]\[IndentingNewLine]\
];\)\)], "Input",
  InitializationCell->True,
  CellTags->"Cuboid"]
}, Closed]],

Cell[CellGroupData[{

Cell["the rest", "Subsection",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(End[]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Protect["\<rayshade`*\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(EndPackage[]\)], "Input",
  InitializationCell->True]
}, Closed]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{579, 600},
WindowMargins->{{Automatic, 259}, {Automatic, 23}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "s1"->{
    Cell[1739, 51, 105, 2, 61, "Subsection",
      CellTags->"s1"],
    Cell[1847, 55, 69, 1, 32, "Text",
      CellTags->"s1"],
    Cell[1919, 58, 62, 1, 32, "Text",
      CellTags->"s1"],
    Cell[1984, 61, 71, 1, 32, "Text",
      CellTags->"s1"],
    Cell[2058, 64, 53, 1, 32, "Text",
      CellTags->"s1"],
    Cell[2114, 67, 55, 1, 32, "Text",
      CellTags->"s1"],
    Cell[2172, 70, 519, 11, 140, "Text",
      CellTags->"s1"],
    Cell[2694, 83, 516, 11, 140, "Text",
      CellTags->"s1"],
    Cell[3213, 96, 43, 1, 32, "Text",
      CellTags->"s1"],
    Cell[3259, 99, 80, 1, 32, "Text",
      CellTags->"s1"],
    Cell[3342, 102, 93, 1, 32, "Text",
      CellTags->"s1"],
    Cell[3438, 105, 59, 1, 32, "Text",
      CellTags->"s1"],
    Cell[3500, 108, 322, 8, 122, "Text",
      CellTags->"s1"],
    Cell[3825, 118, 146, 4, 32, "Text",
      CellTags->"s1"],
    Cell[4065, 129, 128, 4, 32, "Text",
      CellTags->"s1"],
    Cell[4289, 139, 204, 4, 59, "Input",
      InitializationCell->True,
      CellTags->"s1"],
    Cell[4496, 145, 127, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s1"],
    Cell[4626, 150, 140, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s1"]},
  "s2"->{
    Cell[4803, 159, 92, 2, 45, "Subsection",
      CellTags->"s2"],
    Cell[4898, 163, 50, 1, 32, "Text",
      CellTags->"s2"],
    Cell[4951, 166, 1385, 26, 395, "Input",
      InitializationCell->True,
      CellTags->"s2"]},
  "s3"->{
    Cell[6492, 202, 89, 2, 45, "Subsection",
      CellTags->"s3"],
    Cell[6584, 206, 101, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s3"],
    Cell[6688, 211, 3509, 64, 843, "Input",
      InitializationCell->True,
      CellTags->"s3"]},
  "s4"->{
    Cell[10234, 280, 89, 2, 45, "Subsection",
      CellTags->"s4"],
    Cell[11141, 311, 36987, 665, 9691, "Input",
      InitializationCell->True,
      CellTags->"s4"]},
  "s12"->{
    Cell[10611, 291, 96, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s12"],
    Cell[10710, 296, 95, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s12"],
    Cell[11040, 307, 98, 2, 27, "Input",
      CellTags->"s12"],
    Cell[240946, 5192, 86, 2, 45, "Subsection",
      CellTags->"s12"],
    Cell[241035, 5196, 4033, 71, 1355, "Input",
      InitializationCell->True,
      CellTags->"s12"]},
  "s5"->{
    Cell[48643, 997, 92, 2, 45, "Subsection",
      CellTags->"s5"],
    Cell[48738, 1001, 148, 4, 32, "Text",
      CellTags->"s5"],
    Cell[48889, 1007, 87, 1, 32, "Text",
      CellTags->"s5"],
    Cell[48979, 1010, 1257, 23, 315, "Input",
      InitializationCell->True,
      CellTags->"s5"],
    Cell[50239, 1035, 857, 16, 235, "Input",
      InitializationCell->True,
      CellTags->"s5"],
    Cell[51099, 1053, 565, 11, 187, "Input",
      CellTags->"s5"]},
  "s6"->{
    Cell[51701, 1069, 98, 2, 45, "Subsection",
      CellTags->"s6"],
    Cell[51961, 1081, 779, 23, 374, "Text",
      CellTags->"s6"],
    Cell[52905, 1112, 158, 3, 43, "Input",
      CellTags->"s6"],
    Cell[53357, 1130, 686, 15, 139, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[54118, 1152, 2584, 48, 747, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[56896, 1211, 2707, 51, 779, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[59676, 1269, 175, 7, 99, "Text",
      CellTags->"s6"],
    Cell[59946, 1281, 4046, 70, 1195, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[65509, 1388, 502, 9, 171, "Input",
      CellTags->"s6"],
    Cell[66125, 1404, 123, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[66467, 1416, 425, 9, 107, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[66895, 1427, 81, 2, 31, "Text",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[66979, 1431, 273, 6, 59, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[67338, 1444, 44, 1, 31, "Text",
      CellTags->"s6"],
    Cell[67385, 1447, 153, 5, 65, "Text",
      CellTags->"s6"],
    Cell[67541, 1454, 201, 4, 43, "Input",
      CellTags->"s6"],
    Cell[67898, 1465, 216, 6, 82, "Text",
      CellTags->"s6"],
    Cell[68117, 1473, 166, 4, 43, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[68286, 1479, 290, 8, 116, "Text",
      CellTags->"s6"],
    Cell[68579, 1489, 162, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[68873, 1501, 160, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[69036, 1507, 193, 7, 99, "Text",
      CellTags->"s6"],
    Cell[69232, 1516, 136, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[69371, 1521, 206, 5, 43, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[69580, 1528, 270, 6, 43, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[69853, 1536, 431, 8, 107, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[70287, 1546, 429, 8, 107, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[70719, 1556, 149, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[70871, 1562, 222, 6, 43, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[71096, 1570, 277, 7, 43, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[71930, 1592, 149, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[72082, 1598, 229, 5, 59, "Input",
      InitializationCell->True,
      CellTags->"s6"],
    Cell[73052, 1625, 202, 6, 27, "Input",
      InitializationCell->True,
      CellTags->"s6"]},
  "s7"->{
    Cell[72946, 1621, 103, 2, 45, "Subsection",
      CellTags->"s7"],
    Cell[73426, 1642, 726, 17, 303, "Text",
      CellTags->"s7"],
    Cell[74375, 1669, 4094, 70, 1083, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[79420, 1773, 3906, 66, 1003, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[84115, 1864, 3188, 56, 875, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[87733, 1940, 5917, 103, 1547, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[94741, 2073, 186, 5, 65, "Text",
      CellTags->"s7"],
    Cell[96352, 2118, 4912, 84, 1275, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[101542, 2215, 307, 10, 150, "Text",
      CellTags->"s7"],
    Cell[102063, 2235, 3361, 58, 939, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[105427, 2295, 717, 19, 303, "Text",
      CellTags->"s7"],
    Cell[106213, 2321, 772, 22, 356, "Text",
      CellTags->"s7"],
    Cell[107331, 2355, 3269, 58, 891, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[110715, 2419, 1248, 23, 347, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[113255, 2485, 2149, 36, 587, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[115804, 2537, 1956, 33, 555, "Input",
      CellTags->"s7"],
    Cell[117831, 2577, 674, 16, 248, "Text",
      CellTags->"s7"],
    Cell[118722, 2603, 2581, 44, 763, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[121905, 2664, 101, 2, 45, "Subsection",
      CellTags->"s7"],
    Cell[122770, 2697, 6492, 115, 1611, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[129781, 2834, 1921, 34, 523, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[132399, 2898, 8049, 146, 1947, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[141951, 3090, 5534, 91, 1515, "Input",
      InitializationCell->True,
      CellTags->"s7"],
    Cell[149549, 3235, 4311, 75, 1163, "Input",
      InitializationCell->True,
      CellTags->"s7"]},
  "s9"->{
    Cell[171638, 3669, 125, 2, 45, "Subsection",
      CellTags->"s9"],
    Cell[171821, 3677, 133, 4, 48, "Text",
      CellTags->"s9"],
    Cell[171957, 3683, 144, 4, 48, "Text",
      CellTags->"s9"],
    Cell[172104, 3689, 231, 5, 65, "Text",
      CellTags->"s9"],
    Cell[173021, 3716, 2111, 41, 523, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[175210, 3761, 2290, 46, 571, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[177503, 3809, 511, 12, 123, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[178017, 3823, 3699, 69, 859, "Input",
      CellTags->"s9"],
    Cell[181987, 3901, 94, 2, 27, "Input",
      CellTags->"s9"],
    Cell[184601, 3966, 111, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[184715, 3971, 273, 6, 75, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[185495, 3997, 356, 8, 107, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[186153, 4015, 5246, 98, 1467, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[191523, 4120, 3182, 54, 763, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[194841, 4184, 140, 5, 65, "Text",
      CellTags->"s9"],
    Cell[195291, 4199, 825, 16, 235, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[196119, 4217, 1106, 21, 283, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[197228, 4240, 134, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[197365, 4245, 161, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[197975, 4264, 237, 5, 59, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[198215, 4271, 316, 8, 75, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[198534, 4281, 131, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[198967, 4294, 918, 19, 235, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[199888, 4315, 157, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[200501, 4338, 320, 7, 91, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[201049, 4355, 593, 12, 155, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[201962, 4380, 645, 13, 171, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[202835, 4403, 647, 13, 171, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[203605, 4422, 323, 7, 91, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[204527, 4454, 997, 20, 251, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[205951, 4491, 1869, 35, 395, "Input",
      InitializationCell->True,
      CellTags->"s9"],
    Cell[208172, 4541, 651, 14, 187, "Input",
      InitializationCell->True,
      CellTags->"s9"]},
  "s11"->{
    Cell[229578, 4960, 92, 2, 45, "Subsection",
      CellTags->"s11"],
    Cell[229673, 4964, 338, 8, 104, "Text",
      CellTags->"s11"],
    Cell[231307, 5015, 8712, 154, 2379, "Input",
      InitializationCell->True,
      CellTags->"s11"],
    Cell[240022, 5171, 887, 16, 283, "Input",
      CellTags->"s11"]},
  "s13"->{
    Cell[245105, 5272, 87, 2, 45, "Subsection",
      CellTags->"s13"],
    Cell[245195, 5276, 231, 5, 50, "Text",
      CellTags->"s13"],
    Cell[245429, 5283, 117, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[245549, 5288, 119, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[245671, 5293, 119, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[245793, 5298, 154, 4, 50, "Text",
      CellTags->"s13"],
    Cell[245950, 5304, 127, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[246080, 5309, 142, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[246225, 5315, 159, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[246387, 5321, 246, 9, 104, "Text",
      CellTags->"s13"],
    Cell[246636, 5332, 91, 1, 32, "Text",
      CellTags->"s13"],
    Cell[246730, 5335, 152, 4, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[246885, 5341, 211, 5, 43, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[247099, 5348, 231, 5, 43, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[247333, 5355, 120, 4, 32, "Text",
      CellTags->"s13"],
    Cell[247456, 5361, 665, 13, 187, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[248497, 5384, 240, 6, 59, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[248740, 5392, 369, 8, 75, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[249112, 5402, 282, 7, 59, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[249397, 5411, 278, 6, 75, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[249678, 5419, 121, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[249802, 5424, 667, 13, 187, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[250472, 5439, 112, 3, 27, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[250587, 5444, 303, 6, 75, "Input",
      InitializationCell->True,
      CellTags->"s13"],
    Cell[250893, 5452, 47, 1, 32, "Text",
      CellTags->"s13"],
    Cell[250943, 5455, 189, 4, 43, "Input",
      CellTags->"s13"],
    Cell[251135, 5461, 237, 5, 59, "Input",
      CellTags->"s13"],
    Cell[251375, 5468, 108, 4, 32, "Text",
      CellTags->"s13"],
    Cell[251486, 5474, 449, 8, 139, "Input",
      CellTags->"s13"]},
  "s14"->{
    Cell[251972, 5487, 88, 2, 45, "Subsection",
      CellTags->"s14"],
    Cell[252063, 5491, 169, 5, 43, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[252235, 5498, 2042, 35, 587, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[254280, 5535, 787, 15, 203, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[255070, 5552, 141, 4, 48, "Text",
      CellTags->"s14"],
    Cell[255214, 5558, 1194, 20, 331, "Input",
      CellTags->"s14"],
    Cell[256411, 5580, 47, 1, 31, "Text",
      CellTags->"s14"],
    Cell[256461, 5583, 323, 7, 75, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[256787, 5592, 465, 10, 107, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[257255, 5604, 288, 7, 75, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[257546, 5613, 345, 6, 91, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[257894, 5621, 240, 7, 82, "Text",
      CellTags->"s14"],
    Cell[258137, 5630, 474, 9, 107, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[258614, 5641, 387, 8, 91, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[259004, 5651, 398, 8, 91, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[259405, 5661, 505, 10, 123, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[259913, 5673, 269, 5, 91, "Input",
      CellTags->"s14"],
    Cell[260185, 5680, 2601, 45, 715, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[262789, 5727, 559, 10, 155, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[263390, 5741, 994, 18, 251, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[264387, 5761, 952, 17, 251, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[265342, 5780, 921, 16, 235, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[266266, 5798, 967, 17, 235, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[267236, 5817, 475, 9, 123, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[267714, 5828, 963, 17, 235, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[268680, 5847, 288, 7, 75, "Input",
      InitializationCell->True,
      CellTags->"s14"],
    Cell[268971, 5856, 254, 6, 43, "Input",
      InitializationCell->True,
      CellTags->"s14"]},
  "s15"->{
    Cell[269262, 5867, 85, 2, 45, "Subsection",
      CellTags->"s15"],
    Cell[269350, 5871, 76, 1, 31, "Text",
      CellTags->"s15"],
    Cell[269429, 5874, 928, 19, 203, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[270360, 5895, 80, 1, 31, "Text",
      CellTags->"s15"],
    Cell[270443, 5898, 1279, 24, 379, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[271725, 5924, 514, 11, 123, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[272242, 5937, 578, 12, 187, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[272823, 5951, 471, 10, 107, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[273297, 5963, 85, 1, 31, "Text",
      CellTags->"s15"],
    Cell[273385, 5966, 605, 12, 171, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[273993, 5980, 257, 6, 43, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[274253, 5988, 184, 5, 27, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[274440, 5995, 211, 5, 27, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[274654, 6002, 175, 5, 27, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[274832, 6009, 111, 4, 31, "Text",
      CellTags->"s15"],
    Cell[274946, 6015, 1033, 18, 283, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[275982, 6035, 368, 8, 75, "Input",
      CellTags->"s15"],
    Cell[276353, 6045, 893, 16, 235, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[277249, 6063, 166, 3, 43, "Input",
      CellTags->"s15"],
    Cell[277418, 6068, 88, 1, 31, "Text",
      CellTags->"s15"],
    Cell[277509, 6071, 488, 11, 123, "Input",
      CellTags->"s15"],
    Cell[278000, 6084, 320, 7, 91, "Input",
      CellTags->"s15"],
    Cell[278401, 6096, 567, 10, 139, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[279084, 6113, 550, 10, 139, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[279637, 6125, 3302, 60, 859, "Input",
      InitializationCell->True,
      CellTags->"s15"],
    Cell[282942, 6187, 163, 4, 27, "Input",
      CellTags->"s15"]},
  "Cuboid"->{
    Cell[283493, 6214, 4484, 78, 1035, "Input",
      InitializationCell->True,
      CellTags->"Cuboid"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"s1", 288946, 6330},
  {"s2", 290182, 6370},
  {"s3", 290422, 6378},
  {"s4", 290696, 6387},
  {"s12", 290880, 6393},
  {"s5", 291326, 6407},
  {"s6", 291804, 6422},
  {"s7", 294710, 6511},
  {"s9", 296874, 6575},
  {"s11", 299869, 6665},
  {"s13", 300196, 6675},
  {"s14", 302757, 6752},
  {"s15", 305306, 6828},
  {"Cuboid", 307591, 6896}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 105, 2, 61, "Subsection",
  CellTags->"s1"],
Cell[1847, 55, 69, 1, 32, "Text",
  CellTags->"s1"],
Cell[1919, 58, 62, 1, 32, "Text",
  CellTags->"s1"],
Cell[1984, 61, 71, 1, 32, "Text",
  CellTags->"s1"],
Cell[2058, 64, 53, 1, 32, "Text",
  CellTags->"s1"],
Cell[2114, 67, 55, 1, 32, "Text",
  CellTags->"s1"],
Cell[2172, 70, 519, 11, 140, "Text",
  CellTags->"s1"],
Cell[2694, 83, 516, 11, 140, "Text",
  CellTags->"s1"],
Cell[3213, 96, 43, 1, 32, "Text",
  CellTags->"s1"],
Cell[3259, 99, 80, 1, 32, "Text",
  CellTags->"s1"],
Cell[3342, 102, 93, 1, 32, "Text",
  CellTags->"s1"],
Cell[3438, 105, 59, 1, 32, "Text",
  CellTags->"s1"],
Cell[3500, 108, 322, 8, 122, "Text",
  CellTags->"s1"],
Cell[3825, 118, 146, 4, 32, "Text",
  CellTags->"s1"],
Cell[3974, 124, 88, 3, 32, "Text"],
Cell[4065, 129, 128, 4, 32, "Text",
  CellTags->"s1"],
Cell[4196, 135, 90, 2, 27, "Input",
  InitializationCell->True],
Cell[4289, 139, 204, 4, 59, "Input",
  InitializationCell->True,
  CellTags->"s1"],
Cell[4496, 145, 127, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s1"],
Cell[4626, 150, 140, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s1"]
}, Closed]],

Cell[CellGroupData[{
Cell[4803, 159, 92, 2, 45, "Subsection",
  CellTags->"s2"],
Cell[4898, 163, 50, 1, 32, "Text",
  CellTags->"s2"],
Cell[4951, 166, 1385, 26, 395, "Input",
  InitializationCell->True,
  CellTags->"s2"],
Cell[6339, 194, 116, 3, 32, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[6492, 202, 89, 2, 45, "Subsection",
  CellTags->"s3"],
Cell[6584, 206, 101, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s3"],
Cell[6688, 211, 3509, 64, 843, "Input",
  InitializationCell->True,
  CellTags->"s3"]
}, Closed]],

Cell[CellGroupData[{
Cell[10234, 280, 89, 2, 45, "Subsection",
  CellTags->"s4"],
Cell[10326, 284, 282, 5, 91, "Input",
  InitializationCell->True],
Cell[10611, 291, 96, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s12"],
Cell[10710, 296, 95, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s12"],
Cell[10808, 301, 229, 4, 65, "Text"],
Cell[11040, 307, 98, 2, 27, "Input",
  CellTags->"s12"],
Cell[11141, 311, 36987, 665, 9691, "Input",
  InitializationCell->True,
  CellTags->"s4"],
Cell[48131, 978, 475, 14, 235, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[48643, 997, 92, 2, 45, "Subsection",
  CellTags->"s5"],
Cell[48738, 1001, 148, 4, 32, "Text",
  CellTags->"s5"],
Cell[48889, 1007, 87, 1, 32, "Text",
  CellTags->"s5"],
Cell[48979, 1010, 1257, 23, 315, "Input",
  InitializationCell->True,
  CellTags->"s5"],
Cell[50239, 1035, 857, 16, 235, "Input",
  InitializationCell->True,
  CellTags->"s5"],
Cell[51099, 1053, 565, 11, 187, "Input",
  CellTags->"s5"]
}, Closed]],

Cell[CellGroupData[{
Cell[51701, 1069, 98, 2, 45, "Subsection",
  CellTags->"s6"],
Cell[51802, 1073, 99, 2, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[51926, 1079, 32, 0, 42, "Subsubsection"],
Cell[51961, 1081, 779, 23, 374, "Text",
  CellTags->"s6"],
Cell[52743, 1106, 74, 1, 27, "Input"],
Cell[52820, 1109, 82, 1, 27, "Input"],
Cell[52905, 1112, 158, 3, 43, "Input",
  CellTags->"s6"],
Cell[53066, 1117, 87, 1, 27, "Input"],
Cell[53156, 1120, 121, 3, 32, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[53314, 1128, 40, 0, 28, "Subsubsection"],
Cell[53357, 1130, 686, 15, 139, "Input",
  InitializationCell->True,
  CellTags->"s6"]
}, Closed]],

Cell[CellGroupData[{
Cell[54080, 1150, 35, 0, 28, "Subsubsection"],
Cell[54118, 1152, 2584, 48, 747, "Input",
  InitializationCell->True,
  CellTags->"s6"]
}, Closed]],

Cell[CellGroupData[{
Cell[56739, 1205, 33, 0, 28, "Subsubsection"],
Cell[56775, 1207, 118, 2, 27, "Input"],
Cell[56896, 1211, 2707, 51, 779, "Input",
  InitializationCell->True,
  CellTags->"s6"]
}, Closed]],

Cell[CellGroupData[{
Cell[59640, 1267, 33, 0, 28, "Subsubsection"],
Cell[59676, 1269, 175, 7, 99, "Text",
  CellTags->"s6"],
Cell[59854, 1278, 89, 1, 27, "Input"],
Cell[59946, 1281, 4046, 70, 1195, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[63995, 1353, 1307, 23, 283, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[65339, 1381, 51, 0, 28, "Subsubsection"],
Cell[65393, 1383, 113, 3, 48, "Text"],
Cell[65509, 1388, 502, 9, 171, "Input",
  CellTags->"s6"],
Cell[66014, 1399, 108, 3, 48, "Text"],
Cell[66125, 1404, 123, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[66251, 1409, 213, 5, 82, "Text"],
Cell[66467, 1416, 425, 9, 107, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[66895, 1427, 81, 2, 31, "Text",
  InitializationCell->True,
  CellTags->"s6"],
Cell[66979, 1431, 273, 6, 59, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[67255, 1439, 80, 3, 48, "Text"],
Cell[67338, 1444, 44, 1, 31, "Text",
  CellTags->"s6"],
Cell[67385, 1447, 153, 5, 65, "Text",
  CellTags->"s6"],
Cell[67541, 1454, 201, 4, 43, "Input",
  CellTags->"s6"],
Cell[67745, 1460, 150, 3, 43, "Input",
  InitializationCell->True],
Cell[67898, 1465, 216, 6, 82, "Text",
  CellTags->"s6"],
Cell[68117, 1473, 166, 4, 43, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[68286, 1479, 290, 8, 116, "Text",
  CellTags->"s6"],
Cell[68579, 1489, 162, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[68744, 1495, 126, 4, 65, "Text"],
Cell[68873, 1501, 160, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[69036, 1507, 193, 7, 99, "Text",
  CellTags->"s6"],
Cell[69232, 1516, 136, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[69371, 1521, 206, 5, 43, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[69580, 1528, 270, 6, 43, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[69853, 1536, 431, 8, 107, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[70287, 1546, 429, 8, 107, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[70719, 1556, 149, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[70871, 1562, 222, 6, 43, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[71096, 1570, 277, 7, 43, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[71376, 1579, 551, 11, 123, "Input",
  InitializationCell->True],
Cell[71930, 1592, 149, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[72082, 1598, 229, 5, 59, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[72314, 1605, 583, 10, 139, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[72946, 1621, 103, 2, 45, "Subsection",
  CellTags->"s7"],
Cell[73052, 1625, 202, 6, 27, "Input",
  InitializationCell->True,
  CellTags->"s6"],
Cell[73257, 1633, 108, 3, 48, "Text"],

Cell[CellGroupData[{
Cell[73390, 1640, 33, 0, 42, "Subsubsection"],
Cell[73426, 1642, 726, 17, 303, "Text",
  CellTags->"s7"],
Cell[74155, 1661, 114, 2, 27, "Input",
  InitializationCell->True],
Cell[74272, 1665, 100, 2, 27, "Input",
  InitializationCell->True],
Cell[74375, 1669, 4094, 70, 1083, "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{
Cell[78506, 1744, 29, 0, 28, "Subsubsection"],
Cell[78538, 1746, 671, 17, 269, "Text"],
Cell[79212, 1765, 106, 2, 27, "Input",
  InitializationCell->True],
Cell[79321, 1769, 96, 2, 27, "Input",
  InitializationCell->True],
Cell[79420, 1773, 3906, 66, 1003, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[83329, 1841, 492, 8, 155, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[83858, 1854, 34, 0, 28, "Subsubsection"],
Cell[83895, 1856, 114, 2, 27, "Input",
  InitializationCell->True],
Cell[84012, 1860, 100, 2, 27, "Input",
  InitializationCell->True],
Cell[84115, 1864, 3188, 56, 875, "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{
Cell[87340, 1925, 33, 0, 28, "Subsubsection"],
Cell[87376, 1927, 137, 3, 48, "Text"],
Cell[87516, 1932, 112, 2, 27, "Input",
  InitializationCell->True],
Cell[87631, 1936, 99, 2, 27, "Input",
  InitializationCell->True],
Cell[87733, 1940, 5917, 103, 1547, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[93653, 2045, 658, 11, 187, "Input"],
Cell[94314, 2058, 334, 8, 133, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[94685, 2071, 53, 0, 28, "Subsubsection"],
Cell[94741, 2073, 186, 5, 65, "Text",
  CellTags->"s7"],
Cell[94930, 2080, 89, 1, 27, "Input"],
Cell[95022, 2083, 78, 1, 27, "Input"],
Cell[95103, 2086, 346, 6, 107, "Input"],
Cell[95452, 2094, 675, 13, 187, "Input",
  InitializationCell->True],
Cell[96130, 2109, 96, 2, 27, "Input",
  InitializationCell->True],
Cell[96229, 2113, 120, 3, 27, "Input"],
Cell[96352, 2118, 4912, 84, 1275, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[101267, 2204, 205, 4, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[101509, 2213, 30, 0, 28, "Subsubsection"],
Cell[101542, 2215, 307, 10, 150, "Text",
  CellTags->"s7"],
Cell[101852, 2227, 108, 2, 27, "Input",
  InitializationCell->True],
Cell[101963, 2231, 97, 2, 27, "Input",
  InitializationCell->True],
Cell[102063, 2235, 3361, 58, 939, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[105427, 2295, 717, 19, 303, "Text",
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{
Cell[106181, 2319, 29, 0, 28, "Subsubsection"],
Cell[106213, 2321, 772, 22, 356, "Text",
  CellTags->"s7"],
Cell[106988, 2345, 147, 3, 27, "Input",
  InitializationCell->True],
Cell[107138, 2350, 190, 3, 43, "Input"],
Cell[107331, 2355, 3269, 58, 891, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[110603, 2415, 109, 2, 27, "Input"],
Cell[110715, 2419, 1248, 23, 347, "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{
Cell[112000, 2447, 31, 0, 28, "Subsubsection"],
Cell[112034, 2449, 767, 18, 320, "Text"],
Cell[112804, 2469, 120, 2, 27, "Input"],
Cell[112927, 2473, 111, 2, 27, "Input"],
Cell[113041, 2477, 110, 2, 27, "Input",
  InitializationCell->True],
Cell[113154, 2481, 98, 2, 27, "Input",
  InitializationCell->True],
Cell[113255, 2485, 2149, 36, 587, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[115407, 2523, 209, 4, 43, "Input"],
Cell[115619, 2529, 182, 6, 104, "Text"],
Cell[115804, 2537, 1956, 33, 555, "Input",
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{
Cell[117797, 2575, 31, 0, 28, "Subsubsection"],
Cell[117831, 2577, 674, 16, 248, "Text",
  CellTags->"s7"],
Cell[118508, 2595, 110, 2, 27, "Input",
  InitializationCell->True],
Cell[118621, 2599, 98, 2, 27, "Input",
  InitializationCell->True],
Cell[118722, 2603, 2581, 44, 763, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[121306, 2649, 550, 9, 155, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[121905, 2664, 101, 2, 45, "Subsection",
  CellTags->"s7"],

Cell[CellGroupData[{
Cell[122031, 2670, 29, 0, 42, "Subsubsection"],
Cell[122063, 2672, 107, 2, 27, "Input",
  InitializationCell->True],
Cell[122173, 2676, 96, 2, 27, "Input",
  InitializationCell->True],
Cell[122272, 2680, 495, 15, 252, "Text"],
Cell[122770, 2697, 6492, 115, 1611, "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{
Cell[129299, 2817, 29, 0, 28, "Subsubsection"],
Cell[129331, 2819, 107, 2, 27, "Input",
  InitializationCell->True],
Cell[129441, 2823, 96, 2, 27, "Input",
  InitializationCell->True],
Cell[129540, 2827, 238, 5, 86, "Text"],
Cell[129781, 2834, 1921, 34, 523, "Input",
  InitializationCell->True,
  CellTags->"s7"]
}, Closed]],

Cell[CellGroupData[{
Cell[131739, 2873, 31, 0, 28, "Subsubsection"],
Cell[131773, 2875, 408, 13, 212, "Text"],
Cell[132184, 2890, 111, 2, 27, "Input",
  InitializationCell->True],
Cell[132298, 2894, 98, 2, 27, "Input",
  InitializationCell->True],
Cell[132399, 2898, 8049, 146, 1947, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[140451, 3046, 890, 19, 203, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[141378, 3070, 34, 0, 28, "Subsubsection"],
Cell[141415, 3072, 309, 8, 133, "Text"],
Cell[141727, 3082, 117, 2, 27, "Input",
  InitializationCell->True],
Cell[141847, 3086, 101, 2, 27, "Input",
  InitializationCell->True],
Cell[141951, 3090, 5534, 91, 1515, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[147488, 3183, 1228, 23, 379, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[148753, 3211, 29, 0, 28, "Subsubsection"],
Cell[148785, 3213, 552, 12, 201, "Text"],
Cell[149340, 3227, 107, 2, 27, "Input",
  InitializationCell->True],
Cell[149450, 3231, 96, 2, 27, "Input",
  InitializationCell->True],
Cell[149549, 3235, 4311, 75, 1163, "Input",
  InitializationCell->True,
  CellTags->"s7"],
Cell[153863, 3312, 585, 10, 171, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[154485, 3327, 30, 0, 28, "Subsubsection"],
Cell[154518, 3329, 301, 9, 150, "Text"],
Cell[154822, 3340, 109, 2, 27, "Input",
  InitializationCell->True],
Cell[154934, 3344, 97, 2, 27, "Input",
  InitializationCell->True],
Cell[155034, 3348, 6484, 113, 1643, "Input",
  InitializationCell->True],
Cell[161521, 3463, 69, 1, 27, "Input"],
Cell[161593, 3466, 300, 6, 99, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[161930, 3477, 32, 0, 28, "Subsubsection"],
Cell[161965, 3479, 97, 3, 31, "Text"],
Cell[162065, 3484, 466, 12, 116, "Text"],
Cell[162534, 3498, 106, 2, 27, "Input"],
Cell[162643, 3502, 99, 2, 27, "Input",
  InitializationCell->True],
Cell[162745, 3506, 8283, 143, 2443, "Input",
  InitializationCell->True],
Cell[171031, 3651, 558, 12, 201, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[171638, 3669, 125, 2, 45, "Subsection",
  CellTags->"s9"],

Cell[CellGroupData[{
Cell[171788, 3675, 30, 0, 42, "Subsubsection"],
Cell[171821, 3677, 133, 4, 48, "Text",
  CellTags->"s9"],
Cell[171957, 3683, 144, 4, 48, "Text",
  CellTags->"s9"],
Cell[172104, 3689, 231, 5, 65, "Text",
  CellTags->"s9"],
Cell[172338, 3696, 218, 4, 75, "Input"],
Cell[172559, 3702, 297, 6, 91, "Input",
  InitializationCell->True],
Cell[172859, 3710, 159, 4, 48, "Text"],
Cell[173021, 3716, 2111, 41, 523, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[175135, 3759, 72, 0, 31, "Text"],
Cell[175210, 3761, 2290, 46, 571, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[177503, 3809, 511, 12, 123, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[178017, 3823, 3699, 69, 859, "Input",
  CellTags->"s9"],
Cell[181719, 3894, 265, 5, 75, "Input",
  InitializationCell->True],
Cell[181987, 3901, 94, 2, 27, "Input",
  CellTags->"s9"],
Cell[182084, 3905, 165, 4, 65, "Text"],
Cell[182252, 3911, 111, 3, 48, "Text"],
Cell[182366, 3916, 1178, 20, 331, "Input",
  InitializationCell->True],
Cell[183547, 3938, 45, 0, 31, "Text"],
Cell[183595, 3940, 530, 11, 155, "Input",
  InitializationCell->True],
Cell[184128, 3953, 326, 6, 91, "Input",
  InitializationCell->True],
Cell[184457, 3961, 141, 3, 43, "Input"],
Cell[184601, 3966, 111, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[184715, 3971, 273, 6, 75, "Input",
  InitializationCell->True,
  CellTags->"s9"]
}, Closed]],

Cell[CellGroupData[{
Cell[185025, 3982, 32, 0, 28, "Subsubsection"],
Cell[185060, 3984, 209, 4, 50, "Text"],
Cell[185272, 3990, 60, 0, 32, "Text"],
Cell[185335, 3992, 157, 3, 43, "Input",
  InitializationCell->True],
Cell[185495, 3997, 356, 8, 107, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[185854, 4007, 296, 6, 91, "Input",
  InitializationCell->True],
Cell[186153, 4015, 5246, 98, 1467, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[191402, 4115, 118, 3, 48, "Text"],
Cell[191523, 4120, 3182, 54, 763, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[194708, 4176, 63, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[194808, 4182, 30, 0, 28, "Subsubsection"],
Cell[194841, 4184, 140, 5, 65, "Text",
  CellTags->"s9"],
Cell[194984, 4191, 304, 6, 91, "Input",
  InitializationCell->True],
Cell[195291, 4199, 825, 16, 235, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[196119, 4217, 1106, 21, 283, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[197228, 4240, 134, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[197365, 4245, 161, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[197529, 4251, 290, 6, 91, "Input",
  InitializationCell->True],
Cell[197822, 4259, 150, 3, 48, "Text"],
Cell[197975, 4264, 237, 5, 59, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[198215, 4271, 316, 8, 75, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[198534, 4281, 131, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[198668, 4286, 296, 6, 91, "Input",
  InitializationCell->True],
Cell[198967, 4294, 918, 19, 235, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[199888, 4315, 157, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[200048, 4321, 80, 1, 27, "Input"],
Cell[200131, 4324, 107, 2, 27, "Input"],
Cell[200241, 4328, 38, 0, 31, "Text"],
Cell[200282, 4330, 99, 2, 27, "Input",
  InitializationCell->True],
Cell[200384, 4334, 114, 2, 27, "Input",
  InitializationCell->True],
Cell[200501, 4338, 320, 7, 91, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[200824, 4347, 101, 2, 27, "Input",
  InitializationCell->True],
Cell[200928, 4351, 118, 2, 27, "Input",
  InitializationCell->True],
Cell[201049, 4355, 593, 12, 155, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[201645, 4369, 109, 2, 27, "Input",
  InitializationCell->True],
Cell[201757, 4373, 143, 3, 27, "Input",
  InitializationCell->True],
Cell[201903, 4378, 56, 0, 31, "Text"],
Cell[201962, 4380, 645, 13, 171, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[202610, 4395, 101, 2, 27, "Input",
  InitializationCell->True],
Cell[202714, 4399, 118, 2, 27, "Input",
  InitializationCell->True],
Cell[202835, 4403, 647, 13, 171, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[203485, 4418, 117, 2, 27, "Input",
  InitializationCell->True],
Cell[203605, 4422, 323, 7, 91, "Input",
  InitializationCell->True,
  CellTags->"s9"]
}, Closed]],

Cell[CellGroupData[{
Cell[203965, 4434, 79, 0, 28, "Subsubsection"],
Cell[204047, 4436, 115, 3, 50, "Text"],
Cell[204165, 4441, 109, 2, 27, "Input"],
Cell[204277, 4445, 106, 2, 27, "Input",
  InitializationCell->True],
Cell[204386, 4449, 138, 3, 27, "Input",
  InitializationCell->True],
Cell[204527, 4454, 997, 20, 251, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[205527, 4476, 60, 0, 32, "Text"],
Cell[205590, 4478, 117, 2, 27, "Input"],
Cell[205710, 4482, 103, 2, 27, "Input",
  InitializationCell->True],
Cell[205816, 4486, 132, 3, 27, "Input",
  InitializationCell->True],
Cell[205951, 4491, 1869, 35, 395, "Input",
  InitializationCell->True,
  CellTags->"s9"],
Cell[207823, 4528, 106, 2, 27, "Input"],
Cell[207932, 4532, 103, 2, 27, "Input",
  InitializationCell->True],
Cell[208038, 4536, 131, 3, 27, "Input",
  InitializationCell->True],
Cell[208172, 4541, 651, 14, 187, "Input",
  InitializationCell->True,
  CellTags->"s9"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[208872, 4561, 71, 1, 45, "Subsection"],
Cell[208946, 4564, 1164, 18, 338, "Text"],
Cell[210113, 4584, 286, 4, 91, "Input"],
Cell[210402, 4590, 108, 2, 27, "Input",
  InitializationCell->True],
Cell[210513, 4594, 68, 1, 27, "Input"],
Cell[210584, 4597, 17386, 304, 4603, "Input",
  InitializationCell->True],
Cell[227973, 4903, 673, 22, 392, "Text"],
Cell[228649, 4927, 370, 8, 104, "Text"],
Cell[229022, 4937, 519, 18, 266, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[229578, 4960, 92, 2, 45, "Subsection",
  CellTags->"s11"],
Cell[229673, 4964, 338, 8, 104, "Text",
  CellTags->"s11"],
Cell[230014, 4974, 344, 6, 107, "Input"],
Cell[230361, 4982, 122, 3, 27, "Input",
  InitializationCell->True],
Cell[230486, 4987, 139, 3, 27, "Input",
  InitializationCell->True],
Cell[230628, 4992, 140, 3, 27, "Input",
  InitializationCell->True],
Cell[230771, 4997, 150, 3, 43, "Input",
  InitializationCell->True],
Cell[230924, 5002, 98, 2, 27, "Input",
  InitializationCell->True],
Cell[231025, 5006, 103, 2, 27, "Input",
  InitializationCell->True],
Cell[231131, 5010, 173, 3, 43, "Input",
  InitializationCell->True],
Cell[231307, 5015, 8712, 154, 2379, "Input",
  InitializationCell->True,
  CellTags->"s11"],
Cell[240022, 5171, 887, 16, 283, "Input",
  CellTags->"s11"]
}, Closed]],

Cell[CellGroupData[{
Cell[240946, 5192, 86, 2, 45, "Subsection",
  CellTags->"s12"],
Cell[241035, 5196, 4033, 71, 1355, "Input",
  InitializationCell->True,
  CellTags->"s12"]
}, Closed]],

Cell[CellGroupData[{
Cell[245105, 5272, 87, 2, 45, "Subsection",
  CellTags->"s13"],
Cell[245195, 5276, 231, 5, 50, "Text",
  CellTags->"s13"],
Cell[245429, 5283, 117, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[245549, 5288, 119, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[245671, 5293, 119, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[245793, 5298, 154, 4, 50, "Text",
  CellTags->"s13"],
Cell[245950, 5304, 127, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[246080, 5309, 142, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[246225, 5315, 159, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[246387, 5321, 246, 9, 104, "Text",
  CellTags->"s13"],
Cell[246636, 5332, 91, 1, 32, "Text",
  CellTags->"s13"],
Cell[246730, 5335, 152, 4, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[246885, 5341, 211, 5, 43, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[247099, 5348, 231, 5, 43, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[247333, 5355, 120, 4, 32, "Text",
  CellTags->"s13"],
Cell[247456, 5361, 665, 13, 187, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[248124, 5376, 370, 6, 123, "Input"],
Cell[248497, 5384, 240, 6, 59, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[248740, 5392, 369, 8, 75, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[249112, 5402, 282, 7, 59, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[249397, 5411, 278, 6, 75, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[249678, 5419, 121, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[249802, 5424, 667, 13, 187, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[250472, 5439, 112, 3, 27, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[250587, 5444, 303, 6, 75, "Input",
  InitializationCell->True,
  CellTags->"s13"],
Cell[250893, 5452, 47, 1, 32, "Text",
  CellTags->"s13"],
Cell[250943, 5455, 189, 4, 43, "Input",
  CellTags->"s13"],
Cell[251135, 5461, 237, 5, 59, "Input",
  CellTags->"s13"],
Cell[251375, 5468, 108, 4, 32, "Text",
  CellTags->"s13"],
Cell[251486, 5474, 449, 8, 139, "Input",
  CellTags->"s13"]
}, Closed]],

Cell[CellGroupData[{
Cell[251972, 5487, 88, 2, 45, "Subsection",
  CellTags->"s14"],
Cell[252063, 5491, 169, 5, 43, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[252235, 5498, 2042, 35, 587, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[254280, 5535, 787, 15, 203, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[255070, 5552, 141, 4, 48, "Text",
  CellTags->"s14"],
Cell[255214, 5558, 1194, 20, 331, "Input",
  CellTags->"s14"],
Cell[256411, 5580, 47, 1, 31, "Text",
  CellTags->"s14"],
Cell[256461, 5583, 323, 7, 75, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[256787, 5592, 465, 10, 107, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[257255, 5604, 288, 7, 75, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[257546, 5613, 345, 6, 91, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[257894, 5621, 240, 7, 82, "Text",
  CellTags->"s14"],
Cell[258137, 5630, 474, 9, 107, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[258614, 5641, 387, 8, 91, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[259004, 5651, 398, 8, 91, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[259405, 5661, 505, 10, 123, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[259913, 5673, 269, 5, 91, "Input",
  CellTags->"s14"],
Cell[260185, 5680, 2601, 45, 715, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[262789, 5727, 559, 10, 155, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[263351, 5739, 36, 0, 31, "Text"],
Cell[263390, 5741, 994, 18, 251, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[264387, 5761, 952, 17, 251, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[265342, 5780, 921, 16, 235, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[266266, 5798, 967, 17, 235, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[267236, 5817, 475, 9, 123, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[267714, 5828, 963, 17, 235, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[268680, 5847, 288, 7, 75, "Input",
  InitializationCell->True,
  CellTags->"s14"],
Cell[268971, 5856, 254, 6, 43, "Input",
  InitializationCell->True,
  CellTags->"s14"]
}, Closed]],

Cell[CellGroupData[{
Cell[269262, 5867, 85, 2, 45, "Subsection",
  CellTags->"s15"],
Cell[269350, 5871, 76, 1, 31, "Text",
  CellTags->"s15"],
Cell[269429, 5874, 928, 19, 203, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[270360, 5895, 80, 1, 31, "Text",
  CellTags->"s15"],
Cell[270443, 5898, 1279, 24, 379, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[271725, 5924, 514, 11, 123, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[272242, 5937, 578, 12, 187, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[272823, 5951, 471, 10, 107, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[273297, 5963, 85, 1, 31, "Text",
  CellTags->"s15"],
Cell[273385, 5966, 605, 12, 171, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[273993, 5980, 257, 6, 43, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[274253, 5988, 184, 5, 27, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[274440, 5995, 211, 5, 27, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[274654, 6002, 175, 5, 27, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[274832, 6009, 111, 4, 31, "Text",
  CellTags->"s15"],
Cell[274946, 6015, 1033, 18, 283, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[275982, 6035, 368, 8, 75, "Input",
  CellTags->"s15"],
Cell[276353, 6045, 893, 16, 235, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[277249, 6063, 166, 3, 43, "Input",
  CellTags->"s15"],
Cell[277418, 6068, 88, 1, 31, "Text",
  CellTags->"s15"],
Cell[277509, 6071, 488, 11, 123, "Input",
  CellTags->"s15"],
Cell[278000, 6084, 320, 7, 91, "Input",
  CellTags->"s15"],
Cell[278323, 6093, 75, 1, 27, "Input"],
Cell[278401, 6096, 567, 10, 139, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[278971, 6108, 110, 3, 27, "Input"],
Cell[279084, 6113, 550, 10, 139, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[279637, 6125, 3302, 60, 859, "Input",
  InitializationCell->True,
  CellTags->"s15"],
Cell[282942, 6187, 163, 4, 27, "Input",
  CellTags->"s15"],
Cell[283108, 6193, 382, 19, 320, "Text"],
Cell[283493, 6214, 4484, 78, 1035, "Input",
  InitializationCell->True,
  CellTags->"Cuboid"]
}, Closed]],

Cell[CellGroupData[{
Cell[288014, 6297, 65, 1, 45, "Subsection"],
Cell[288082, 6300, 66, 2, 27, "Input",
  InitializationCell->True],
Cell[288151, 6304, 86, 2, 27, "Input",
  InitializationCell->True],
Cell[288240, 6308, 73, 2, 27, "Input",
  InitializationCell->True]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

