(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     67842,       1598]*)
(*NotebookOutlinePosition[     82482,       1981]*)
(*  CellTagsIndexPosition[     82358,       1973]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["rayshade`", "Subsection",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Rayshade",
  StyleBox["[", "MR"],
  StyleBox["\"filename.ray\", obj_, opts___", "TI"],
  "]  Exports graphics to \"filename.ray\" in rayshade raytracer file format \
and optionally view it."
}], "Usage",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
Makes file.ray that will look much like notebook raytraced with \
rayshade.  POVRay is supported too.  Hopefully most book examples work and \
appear much as in notebook except raytraced.  (there are notable \
caveats)\
\>", "DefinitionBox",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
See Install / Compile notes on getting rayshade raytracer and urt \
image tools.\
\>", "Caption",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] obj can be ~Graphics3D~ or ~SurfaceGraphics~ or {gr1, \
gr2, ...} list of them.  ~ Graphics ~ also works, but partially.  see notes.\n\
\[FilledSmallSquare] opts can be given as {list of rules}, rule, rule.  If \
opts are given they are preffered over FullOptions which are preferred over \
Options[Graphics3D].  Only a few are looked at.  If your scene's camera is \
way off there's a good chance PlotRange is missing.  Either supply it or \
insure it is not missing in gr.\n\[FilledSmallSquare] There are several \
Options[Rayshade], ie,. final zoom in / out of rendering and glass.\n\
\[FilledSmallSquare] RayView and RayShow options render and view \
automatically.\n\[FilledSmallSquare] Animation with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " example is in Feature Notes.\n\[FilledSmallSquare] raytracing can make \
images of some Graphics3D more realistic\n\[FilledSmallSquare] for Text using \
POVRay see Feature Notes for POVray\n\[FilledSmallSquare] Note I meant book \
examples for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " v 5.2 and under which are handle pretty well.  Many simple ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 9 book examples work and others, using Graphics commands to coax \
primatives for output, will work.  Using less \"fancy options\" is sure to \
help.  Some features supported are for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 9 (ie Opacity)."
}], "Notes",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Beta release: do not start big project with \
expectation rayshade` is perfect or correctable.\
\>", "Text",
  CellTags->{"1.1", "S1.1.1"}],

Cell[CellGroupData[{

Cell["Further  Examples", "ExampleSection",
  CellTags->{"1.1", "S1.7.1"}],

Cell["\<\
See install section about installing required rayshade (preferred) \
and or POVRay binaries.  Download tarball into home directory.  This extracts \
.tar.gz into ~/rayshade/\
\>", "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \(\(\(SetDirectory["\<~\>"]\)\(\ \)\( (*\ "\</home/user/\>"\ *) \)\)\)], \
"Input",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \(\(Run["\<tar -xzf rayshade.2.3.tar.gz\>"];\)\)], "Input",
  CellTags->{"S1.1.1", "1.1"}],

Cell["This loads the package.  (SurfaceGraphics3D is optional)", "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],

Cell["<<rayshade`", "Input",
  Evaluatable->False,
  CellTags->{"S1.1.1", "1.1"}],

Cell["<<SurfaceGraphics3D`", "Input",
  Evaluatable->False,
  CellTags->{"S1.1.1", "1.1"}],

Cell["if the above did not find it, do this:", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["<< ~/rayshade/rayshade.m", "Input",
  Evaluatable->False,
  CellTags->{"S1.1.1", "1.1"}],

Cell["a graphic to do", "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \(\(gr = 
        ContourPlot3D[
          x\ y\ z, {x, \(-1\), 1}, {y, \(-1\), 1}, {z, \(-1\), 1}, 
          Contours \[Rule] { .1}];\)\)], "Input",
  CellTags->{"1.1", "S1.1.1"}],

Cell["Suggested first time use:", "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],

Cell["create file and view result in front end", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \(Rayshade["\<file.ray\>", gr, RayPreView \[Rule] True, 
      RayShow \[Rule] True, RayFastLight \[Rule] True]\)], "Input",
  CellTags->{"1.1", "S1.1.1"}],

Cell["An example using POVRay:", "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \(Rayshade["\<file.pov\>", gr, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayTesselation \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "For 2D plots try FullGraphics to get more primatives, but see Feature \
Notes.  For 3D plots see PolygonIntersections->False.  There are other ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " features that effect what primatives are in graphics arrays that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " would normally omit (but render during Show)."
}], "ExampleText",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Feature  Notes", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Notebook compatibility\n\tThe primary goal has been \
to render a good deal of ver 4.0 ",
  StyleBox["Mathematica\n\tBook",
    FontSlant->"Italic"],
  " 3D examples so they appear and work like the front end but rendered.\n\t\
Many internal features provide this.  There has not been much focus\n\tupon \
dramatic raytrace rendering or 2D options support."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Important notes:\n\tPolygons from from, ie Plot3D, \
may not appear connected when raytraced.\n\tRayTesselation->True often fixes \
that.  See tesselation notes.\n\tHowever some are smooth: ie, Contour3D and \
Parametric3D\n\tSome ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Graphics are PostScript files (ie, Plot3D)\n\t(show contentes of \
~Graphics~ cell to see ps rendering instructions)\n\tThough polys aren't \
connected rendered by ps they appear to be.\n\t\n\tFor 2D graphics \
RayOverlay->True  is default but is not always optimal.\n\tIf using 2D \
graphics see that option."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Point,  PointSize
\tmakes discs as subst for points.  PointSize works but will vary.
\tsee also ViewPoint, linewidth, RayLineWidth and PointSize.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] RGBColor , GrayLevel , Hue
\ta \"surface spec\" is applied to any / ea. primative on the fly
\tNote in raytrace it's surface color but there are colored lights:
\t\tdon't expect grays to be all gray with colored lights
\tsee also RaySurfaces, which overrides surface
\tNOTE: colors aren't well adjusted to mm colors (yet) and doing so
\tcan change ability of RayGlass to look good (if you change it save \
first).\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Text  and  RasterArray
\tInitial or tentative support with a some differences.
\t\tText can hide behind objects, though works with RayOverlay.
\t\tIf you think it looks pink: it's the lights.  See note below or RayGrey.
\tBecause Display is used to render text as a cell the (only, current)
\tway to specify Text style is with TextStyle.  ex:
\t\tGraphics3D[ Text[ expr , {0, 0, 0}, TextStyle->{FontSize->24} ] ]
\t\t\tcurrently ...
\t\tFormatType, TextStyle, Background of Graphic's Text[] opts are
\t\tare checked and applied to Cell[ expr, \"Text\", opts ] which Displays.
\tSee POVRay about Text (about increasing image size).
\tRayshade's Background->None produces %50 translucent and harder to see.
\tPositioning: don't rely heavily upon it being placed as notebook does.
\trayshade.m makes image of Cell [ Text[...] ] and uses it as a texture.
\tImages are temp files in /tmp/m000* and are never deleted, for safety
\tvertical Text direction is not supported
\t\tthough by using Cell formatting it is possible otherwise
\tAs a quirk feature you can use rRasterClear[...]  for %50 transparent
\t\twhere white %100 transparent for POV, %100 white for ray
\tNOTE:  Text no longer forces white background that does not reflect
\tthe color of lights.  You can use Glow[ 1,1,1 ] to increase ambient
\tor set Background to \"SolidWhite\" to fall back to old behavior, ex:
\t\tGraphics3D[ Text[ expr , {0, 0, 0}, Background->\"SolidWhite\" ] ]\
\>", \
"Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 9\n\tCylinder, Opacity, Tube, Sphere, Specularity, Glow, and\n\t\
LightSources spec Ambient, Directional, Point, Spot.\n\tSome ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " v. 9 things work, and work even if using v.4\n\tAlso the arguments to \
some allow mm 9 additions."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] ViewPoint
\tIf ViewPoint or linewidth is in options they are used literally for \
rayshade.
\t\tthis alows override of all calculations (ie, allowing a ViewPoint
\t\tinside the bounding box, a zoom in, see also fov)
\tAdjusted automatically further out from obj's FullOptions.
\tDefault for 2D plot is up in front unless you choose a 3D direction.\
\>", \
"Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Linewidth,  Thickness, PointSize\n\tLinewidth depends \
upon ViewPoint (distance from eye to line).\n\tIf linewidth is in opts it is \
used \"as is\" (not same as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " value).\n\tIf you set linewidth: line lines far from eyep may look spotty\
\n\t\tnote this also depends on lights and scene not just width.\n\t\
[Absolute]Thickness will [slightly] vary from front-end size.\n\t\t\
AbsoluteThickness depends on pr because mm's does.\n\tSee Know Bugs about \
scaling v. use of RayAspect."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Arrow,  Dashing
\tDashing may have problems it is complicated / loopy.
\tNo problems are known yet.
\tremember to insure RayCsg->False for Dashing Circle\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Animation\n\tQuickly.  rayshade has built-in \
animation ability, so does ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\tThis isn't a mature software; for important projects use professional\
\n\tanimation software. This example works using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s Animation:\n\n\tqq = Table[ Rayshade[\"r.orig.ray\", p4, opts, \
RayPreView -> True,\n\tRayShow -> True, ViewPoint -> {1 + (inc .05), -2.4`, \
2.`}], {inc, 3, 10}]\n\tShowAnimation[qq]\n\n\tSee also:  Etc Notes: Overlays \
and Animation (tools for are in extra/)"
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ~Graphics~\n\tShould do lines, poly, point, text, \
raster.\n\t\tSee: FullGraphics Notes  about getting more prims for 2D plots.\n\
\tExpect more problems with 2D, it is More complicated than 3D.\n\t\t\
Sometimes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s 2D PlotRange doesn't match data.\n\t\tSee PlotRange and ViewPoint,  \
linewidth,  Thickness.\n\tAll things said: (many) tens of 2D options are not \
supported...\n\t\tnot  Contour, BesselJ, splines, Density,\n\t\tContour 2D, \
not most of Text, AxesLabel, not allot.\n\t\tOne could try SplineFit[] on \
data to build up prims.\n\tCombining 3D and 2D\n\t\tProlog isn't supported.  \
2D things will go to {x, 0, y}\n\t\t(using Prolog ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " moves objects allot to co-incide\n\t\t rayshade.nb.m does not do that)\n\t\
\t",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not do ~Graphics~ in 3D at all\n\t\t rayshade.nb.m does.\n\t2D \
objects can be moved by supplying 3D vertexes, by using Affine,\n\t\tor \
rayshade.m features / rayshade features for \"translate\", ...\n\tIf doing \
layered 2D (ie, bar chart) and somethings missing\n\t\tsee RayOverlay Etc \
Notes -WorldGraphics- example for help.\n\t3D Lighting makes some lines or \
points reflect thus appear \"washed out\"\n\tbecause they reflect light.\n\t\t\
A \"quick fix\" for simple lighting for 2D in most cases is:\n\t\t\t\
RayGrey->True\n\t\tblack is black, and dont expect colors to be exactly the \
same."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] FullGraphics and 2D
\tHaven't tested it allot, works ok.
\tSee Notes on Text , Lines, and ~ Graphics ~\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "Graphics Primatives for 2D, a few 3D, and Cuboid\n\tSome ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " built-in \"primatives\" never yield data (are internal)\n\t\tand are not \
supported yet, except trivially Cuboid\n\tHowever, there are plenty of ways \
to get data for shapes one is:\n\t\t<< Geometry`Polytopes`"
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] PlotRange  and  Boxed\n\tshould work the same.  see \
also code notes for ways to use.\n\t\tnote: things outside pr get dropped\n\t\
\ta 2D plotrange enacts a few 2D defaults in rayshade.m\n\tif polygons are \
dropped ClipFill -> None is always used.\n\trayshade.nb.m doesn't know how to \
fill, it always clips\n\t(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fills some dropped polys with )\n\t(rayshade drops poly for any point, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does slightly differently)\n\tdon't be surprised if some lines don't \
appear (are dropped)\n\t\tadjust PlotRange to be [a little] bigger, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s range\n\t\tsimply drop (or what drops is internal)."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] LineTube ,  Point  ;  Substitutions
\tto subst (for ex. long cylinders as lines) do this before Rayshade[]
\tgr=Graphics3D[...] ;  gr[[1]] = gr[[1]] /. Line->LineTube ;
\t\tnote: RayTubeLines->True can now be used.
\tFor Point you can, yourself, substitute Spheres for Points
\t\tin the size and style you are looking for.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Circle  Disk  Rectangle
\tfor  semi-axis Csg is not implemented, gets done as lines or poly
\tRectangle[ c, ~Graphics~ ]  technically works but little tested and is
\tbound to work poorly considering 2D in totality is not well \
supported.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Lights
\tThe following is substituted for effect only if LightSources is
\tnot changed by any opts:
\tLightSources\[Rule]{
\t{{1,-1,-1},RGBColor[1,0,0]},
\t{{1,1,1},RGBColor[0,1,0]},
\t{{-1,-1,1},RGBColor[0,0,1]}} ;\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] PolygonIntersections , RenderAll\n\tAdds a little \
extra ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nuance to rendering (try w/ and w/o):\n\tand btw hides space between \
polygons (opposed with tesselation).\n\tex.  gr = ContourPlot3D[x y z, \
{x,-1,1}, {y,-1,1}, {z,-1,1}, Contours -> {.1}\n\t, \
PolygonIntersections->False ]\n\tRenderAll effects drawing Polygons that are \
hidden from view."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] RayTesselation->True
\tMakes some plots whose polygons appear disconnected, connected.
\tIt takes longer, isn't always necessary, and may not work for strange \
polys.
\tSee also: whole object Delaney tesselation in etc notes.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Texture
\tinitial / rudimentary support only

\tdoes NOT follow VertexTextureCoordinates TextureCoordinateFunction
\tonly \"file\" type tested, works on spheres or across poly etc
 \twill do planar spherical cylindrical automatically: but planar only for \
POV so far

\tuse Texture[ \"filename\" ] , can try TextureCoordinateScaling
\tfile should be .tiff or .rle or it will attempt to Imported / Exported to \
be so
\t\twhich isn't yet tested
\t
\tnote:  for polygons texture is per poly.  (it may appear as if it's spread
\tacross surface but this is not a feature: its happenstancial)\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] POVray\n\tPOVray renders better but the language has \
also grown more complex,\n\twhile rayshade is stuck in time and has simple \
low syntax style yet\n\tplenty of features, learnable in a night.  POVRay \
binaries are more avail.\n\tPOVRay renders far faster but sometimes rayshade \
raytraces\n\tget shading better - meaning with all defaults though.\n\n\t\
POVray Text doesn't work as well, raster seems ok.  Try:\n\t\t\t$ povray \
file.pov -H1024 -W1024\n\tto get better looking Text. (RayView default is \
-H512 -W512)\n\n\tSee tesselation notes, POV doesn't like ",
  StyleBox["Mathematica's",
    FontSlant->"Italic"],
  " polygons.\n\t(usually RayTesselation->True is required as opposed to \
desired)"
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] ParametricPlot3D  other tesselation
\tRoman E.Maeder's  SurfaceGraphics3D.m makes ParametricPlot3D
\tplots smooth by re-making a SurfaceGraphics mesh from output.
\t\tUse: ParametricPlot3DtoSurfaceGraphics[f, f, f, {range}]
\t\t~SurfaceGraphics3D~ is output and rules are provided so
\t\tthat Graphics3D or Show will work as usual.
\tMy posting of it is slightly adjusted so it:
\t\tdoesn't prevent / overtake normal use of SurfaceGraphics
\t\tloads separately from rayshade.m
\t\tshould work exactly as ver 1.0 if rayshade 2.0 isn't present\
\>", "Text",\

  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Render Quality
\trayshade has many features that greatly effect rendering quality
\tall of these features can greatly lengthen render time and
\tmany are not default
\[FilledSmallSquare] AffineShape, RotateShape, TranslateShape
\tare present but I assume evaluation before entry precludes them\
\>", "Text",\

  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] RSDEFS
\thas some rashade raytracing #defines and examples.
\t\tex.  rsdefs-text-example.ray\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Re-Entrance
\tRayshade[] is not re-entrant (gropts, grcount, RayInformation,...)
\tWithin 1 kernel only 1 should be running.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RayOptions", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell[TextData[{
  " Options[Rayshade]={\n\[FilledSmallSquare]     RayView\[Rule]False,\n\t\
render and pop open xli(1) (what views .rle images)\n\t(X load image pops \
open image if RayShow->False)\n\[FilledSmallSquare]     \
RayPreView\[Rule]False,\n\trender -p (preview) same as View but renders very \
quickly.\n\t(btw close xli window if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " claims license processes\n\t  are exceeded and your trying to open one)\n\
\[FilledSmallSquare]     RayShow\[Rule]False,\n\tShows rendered image in \
notebook and returns ~Graphics~\n\tMust also use RayView or RayPreView to set \
quality.\n\[FilledSmallSquare]     RayLineWidth\[Rule].001,\n    \toverride \
the size of lines and points if automatic doesn't work\n\[FilledSmallSquare]  \
   RayScaled->False\n\tIf True take care of Scaled[ coord ]  AND  Offset[ ... \
]\n\tby default gr1 is (mostly) not re-evaluated.  True breaks the rule to\n\t\
ReplaceAll inside gr1.\n\[FilledSmallSquare]     RayTesselate>False\n    \tIf \
tesselates PER POLYGON.  Meaning it has no chance to work\n    \twith a set \
(ie, to connect gaps between lists of polygons).\n    \tSee notes on \
Tesselation above.\n\tThis makes some plots whose polygons appear \
disconnected, connected.\n\[FilledSmallSquare]     RayOverlay->True\n\tIf \
True slightly adjust 2D items so they overlap instead of coincide\n\tThis \
applies to {x,y} items and is meant to be \"quickly remedial\"\n\tand not any \
kind of \"total solution\" of course.\n\tor  RayOverlay->{+ starting y offset \
ie of PlotRange , - step by value }\n\tRayOverlay->False may be a more \
righted scene but overlays\n\tmay be spotty.\n\t(see known bugs about why \
overlay can be useful)\n\[FilledSmallSquare]     RayFovAngle->40\n    \tThis \
effects automatic \"zoom\".  A higher value means zoom in,\n    \tmeaning \
some part of the view box may not be in view.  It shortens\n    \tor lengths \
ViewPoint so that the angle to any bounding box point is\n    \tno more than \
40 degrees.  rayshade fov is always 45 unless changed.\n\t(if rayshade fov is \
far out the scene is distorted, so 45 is sought)\n\t    \t* use of ViewPoint \
in opts overrides automatic vp *\n       \tPerspective is apparently better \
preserved (comparing to notebook)\n    \tusing 28 and an fov (see footer) of \
35.\n\[FilledSmallSquare]     PlotRangeClipping\[Rule]True\n\tif False allow \
all objects to draw, do no drop or clip for PlotRange\n\[FilledSmallSquare]   \
  RayClipPlotRange\[Rule]False\n\tThis is a cleaner way to Clip than \
PlotRangeClipping->True\n\tif True use CSG difference to Clip or Exlude all \
graphics using PlotRange\n\tlikely  PlotRangeClipping\[Rule]False  is want, \
though it's not forced\n\tnote RayCsg is ignored\n\[FilledSmallSquare]     \
RayAspect\[Rule]False\t\n    \tattempts to do aspect ratio squash / scale \
objects\n    \tto fit into a cube box.  it's not very mature though.\n    \t\
was a first attempt at scene control - alone it's not good enough\n    \tnote \
\"gr[[1]]=gr[[1]] .5\" will scale too and so can rayshade\n\
\[FilledSmallSquare]     RayFastLights->False\n    \tIf true \"directional\" \
lighting is used.  It's faster and will appear different.\n\
\[FilledSmallSquare]     RayGreyShade->False\n    \tIf true objects will be \
grey shades that are partialy transparent.\n    \t(RGBColor is an exception, \
these retain their color)\n\[FilledSmallSquare]     RayGrey->False\n    \tIf \
true If true objects will be greys, one light from view point\n    \tgives a \
more normal depth perspective and shading.\n    \t(RGBColor objs keep color, \
in some cases this lighting is more dramatic)\n\[FilledSmallSquare]     \
RayGlass->False\n    \tIf true If true objects will appear like glass (one \
style of).\n    \tGood appearance of glass is heavily dependant upon \
background scenery,\n    \tsurface color, and lighting.  This \"glass\" \
actually doesn't use \"index\"\n    \t(of refraction).  To see the bending \
light effect add \"index 1.3\" to\n    \tunder \"object gr1\" of a glass \
sphere (or use options that do that).\n\[FilledSmallSquare]     \
RayBoxLines->False\n\tLines are drawn using stretched Boxes\n\tie, may be \
useful if file.pov is imported in modeling prog.\n\[FilledSmallSquare]     \
RayTubeLines->False\n\tLines are drawn using Tubes (default is camera facing \
poly)\n\[FilledSmallSquare]     RayCsg->True\n\tWhere possible render as \
lines & poly.  If False do the opposite.\n\tThere isn't always a choice (ie, \
Circle and semi angle).\n\[FilledSmallSquare]     \
RayInformation\[Rule]Automatic,\n\tWhether to use Show[] to get FullOptions \
for {gr1, gr2, ... }\n\tnecessary to cobine opts for the scene (ie, tot. \
bounding box)\n\tor to use Options[Graphics3D] and various defaults.  The \
defaults can\n\tbe augmented by opts as usual.  Useful if Show won't work\n\t\
(ie, you use Glow but your mm version does not have Glow).\n\tUse \
rGraphics3D[ { rCone[ ... ] , ... } ] if Graphics3D also cannot work.\n\
\[FilledSmallSquare]     RayHeader\[Rule]\"\",\n\ttext that goes at top of \
file.ray\n\[FilledSmallSquare]     RayFooter\[Rule]Automatic (is \"background \
1 1 1\")\n\ttext that goes at bottom of file.ray\n\tspecify rayshade options \
using this.\n\tie, fov==45 so \"\\nfov 25\\nbackground 1 1 1\\n\" zooms in\n\t\
\"\\nfov 65\\nbackground 1 1 1\\n\" zooms out.\n\t(background 1 1 1 is \
default footer, if you override footer provide it)\n\[FilledSmallSquare]     \
RaySurfaces\[Rule]{},\n\tone String per gr1 gr2 containing any / all surface \
spec lines needed.\n\t(as opposed to RGB surface color this goes where object\
\n\tis instanciated (not where #defined), just after \"object gr1\")\n    }"
}], "Text",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Install  /  Compile   Notes", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell["\<\
\[FilledSmallSquare] Needed binaries:
\trayshade (and optionally povray)
\t(from urt) rlebox (urt has viewer getx11)
\t(linux) rletopnm, pnmtorle, (for Text[]) tifftopnm, pnmtojpeg
\t(linux) cpp (can use \"rayshade -u\" if you can't use cpp)\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Pre-Compiled rayshade and urt (Intel cpu only, \
32bit, Debian / Linux):
\tsee  http://sourceforge.net/projects/rayshade-linux/
\talso: check your OS distribution, the above may be availble in \
packages\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Where to download from
Rayshade and Utah Raster Toolkit  at their sites:
\thttp://www-graphics.stanford.edu/~cek/rayshade/rayshade.html
\tftp://graphics.stanford.edu/pub/rayshade
\tftp://graphics.stanford.edu/pub/Graphics/URT
\thttp://sourceforge.net/projects/rayshade-linux/
\t\t(linux patch for each to make compiling easy / possible in linux)
This package, rayshade.m tarball:
\thttp://sourceforge.net/projects/rayshade-math/
POVRay
\thttp://www.povray.org/\
\>", "Text"],

Cell["\<\
\[FilledSmallSquare] Compiling:\t
Compiling rayshade doesn't involve much OS dependancy so compiling should be \
easy and preferred to obtaining binares as less troublesome (not \"libx wrong \
version\" problems).  One does need standard compiler libs / headers and \
compiler of course.  POVRay isn't yet as well supported however finding \
pre-compiled versions should be easy.

\tUtah Raster Toolkit: doesn't need X11 libs or even to build all binaries,
\trayshade uses only /usr/local/lib/librle.a

\tRayshade:  Doesn't need the Silicon Graphics GL viewers to build,
\tthey don't by default, or rsconvert either, these are extras.\
\>", "Text"],

Cell["\<\
\[FilledSmallSquare] errata
\tRayshade outputs \"mtv\" files (no viewer for) unless librle.a is \
available, 
\tif urt is, rayshade output / works with RLE files.

\txli(1) \"X Load Image\" can view file.rle directly (suggested).
\turt's getx11 works and has -m movie mode (see Etc Notes).

\t\"image tools\" / converters  tiff, pnm, jpg, gif, etc:
\tDebian package netpbm has rletopnm and pnmto[any]

\tcpp.  Use \"rayshade -u\" if you don't have cpp.  You'll have to hack that \
into
\tRayshade[ file_String, obj, opt ] for [Pre]View to work right.  cpp allows
\tallows C style macros that some file.ray make use of.
\t\trayshade.nb.m doesn't use any\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Etc  notes", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell["\<\
\[FilledSmallSquare] How to reset.  Sometimes resetting helps:
\tScan[Unprotect,Names[\"rayshade`Private`*\"]];
\tScan[Remove,Names[\"rayshade`Private`*\"]];
\tScan[Unprotect,Names[\"rayshade`*\"]];
\tScan[Remove,Names[\"rayshade`*\"]];
\t<<rayshade.nb.m;\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] WoldGraphics  (",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " v. 4.0  -  the 2D one)\n\tdon't work \"easily\" - but can work\n\t\ti \
don't suggest it there is better 3D data\n\t\tto seek - it's more a test\n\n\t\
(* rough *)\n\tGraphics[WorldPlot[Africa][[1]]];\n\t\
Rayshade[\"y.orig.ray\",%,RayPreView\[Rule]True];\n\n\t(* better *)\n\t\
w=WorldPlot[{World,RandomGrays},WorldToGraphics\[Rule]True]\n\tww[[1]] = \
ww[[1]] /. Thickness[x_] -> Thickness[.2];\n\tww[[1]] = ww[[1]] //. {x___, \
Line[___], y___} -> {x, y};\n\twl = Select[Flatten[w[[1]]], (Head[#] == Line) \
&];\n\t(* if avoiding use of overlay use this: *)\n\t(* \
wl=wl//.{x_,y_}\[Rule]{x,123,y}; *)\n\twww = ww;\n\twww[[1]] = {wl, ww[[1]]};\
\n\n(* is now:  Graphics[ { all Lines (unstructured), the rest (still \
structured) } ]  *)\nRayshade[ \"c.pov\", www, RayPreView\[Rule]True, \
RayFastLight\[Rule]True, RayGrey\[Rule]True, RayOverlay\[Rule]{5000,-1}, \
RayPOV->True ]\n\nThere are countless variations.  One would be to use a \
separate ~Graphic~ gr2 for all Lines then to use \"translate 0 123 0\" on \
gr2.  Why the -1?  Because default linewidth is wide and when stacked deep, \
by linewidth each time, lines are far away and can't be seen and polygons are \
visibly far from each other: it's easier to provide a smaller -inc than to \
adjust the whole scene or hack at adjusting RayLineWidth.  (and that's \
assuming RayClipPlotRange->False, that things aren't dissapearing out of \
bounds - another reason -inc is easier).  POV is much faster for this, so \
start with POV.\n\nIn all: if any difficulty is had, it's better to avoid use \
of overlay and specify depth.\n\nIt would be a good feature to only apply \
-inc per rGraphic group.  Then give Rayshade[ \"file\", {gr1, gr2}...] where \
gr1 are known not coincide with gr2 , thus only one inc level per gr.  \
However that's an easy hack I'm sure anyone interested can apply it.\n"
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] RLE\n\tif you have urt you should have conversion \
tools that could be\n\tused.  note urt's giftorle may not work with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " due\n\tto \"upgrades\" to the gif format.  rawtorle and rletoraw will\n\t\
always work."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] raytraces that take long to finish
\trayshade can stop and resume rendering a file.ray
\trayshade can render a sub-window of a whole scene at full quality
\t\t(useful to get to see a crop area without rendering rest of scene)
\trayshade -p renders quicky but at loss of view quality
\tother options effect speed and quality, see rayshade docs\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Overlay of transparencies and Animation
\t* Export[... GIF ...] can do transparencies and animations of graphic \
objects
\t* pnmcomp(1) can overlay transparencies or paste pnm files together.
\t   try script \"extra/overlay -h\" (overlay file1.pnm file2.pnm using \
transparency)
\t* file.rle is an animation able image format but viewers for it are \
uncommon
\t   \"getx11 -m file.rle\" works  (assuming file has many rle in one file,
\t   ie, made by /usr/src/rayshade.4.0/Examples/coin.ray).
\t   Converters that can make mpeg movie from a collection of pnm
\t   (or other image formats) are common.  Try script \"extra/make-mpeg -h\"
\t\t   [rle | gif | image list] -> mpeg
\t  if you don't have or want a huge dvd media suite, ie mplayer.  make-mpeg
\t   uses just ppmtompeg(1) from netpbm (and urt tools if an rle).\
\>", \
"Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Textures: rayshade support only, no ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 9 support\n\tThere's no ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 9 support to map images on polygon lists\n\t\t(can't use the new syntax \
for now).\n\tHowever use of RaySurfaces, using rayshade syntax, can do most.\n\
\t\tRaySurfaces->{ \"...\", \"texture image file.rle map planar\", \"...\" }\n\
\t(one string per gr1 object made - or just edit it in under object in \
file.ray)\n\t\t(rayshade.m Text[] and Raster[] in effect use this)\n\t\
rayshade.m can easily (but doesn't) have syntax for surface specs per polygon\
\n\t\t(it does per say, RGBColor, Opacity, etc do it: there's\n\t\t simply no \
function for specifying a custom string)\n\t(meaning rayshade.m could apply \
any image to any part of any polygon\n\t\t or triangle or object as a whole \
and map it planar, spherical, etc\n\t\t as rayshade allows)"
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Text
\tHave no time for text with no background.  It can be done.  One way is
\tto do text in reverse contrast and make object black and background
\ttransparent.  Extra complication I don't want to added in a first version.
\tAs things are if made transparent the text is \"see through\" instead of
\tthe background, is the way things work.
\t\tSee also, code notes.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] file.ray  version 3 v. version 4
\tIf an older file.ray doesn't work try rsconvert(1)
\tit may be a version 3 file and will be converted to ver 4.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\[FilledSmallSquare] Tesselation:", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\tIs optional.
\tSee also RayTesselate (per polygon, maybe not as good, but easy).
\tTo get triangular polygons (tesselated) for a whole object try this:\
\>", \
"Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \(\(Needs["\<DiscreteMath`ComputationalGeometry`\>"];\)\)], "Input",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \(tessfun[gr_] := 
      Module[{g, g2, q}, \n
        If[Head[gr] =!= Graphics3D, g = Graphics3D[gr], 
          g = gr]; \[IndentingNewLine]g2 = 
          g[\([1]\)] /. Polygon[q___] \[Rule] q; \n
        g2 = Partition[Flatten[g2], 3]; \n
        TriangularSurfacePlot[g2]\[IndentingNewLine]]\)], "Input",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\tFor any polygon graphics or graphics part you want fixed \
do:\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \(Module[{g, x, y}, \[IndentingNewLine]g = 
        Plot3D[Sin[x]\ Exp[y], {x, \(-5\), 5}, {y, \(-2\), 2}, 
          PlotPoints \[Rule] 10, DisplayFunction \[Rule] Identity]; \n
      tessfun[g]\[IndentingNewLine]]\)], "Input",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\tHowever tessfun[] only works for graphics that are only a list of \
Polygons.
\tAnd that's a nature of tesselation.  What to tesselate and how best to
\tis always a central problem where tesselation is needed.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Three Script
\tpoly given by ThreeScript given Show[] ~Graphics3D~
\t~~ ARE SAME unjoined polygons from gr[[1]] ~~
\tThreeScript is apparently not a well supported \"standard\".\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Known  Bug:  use of  RayAspect  and  LineWidth ...", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell["\<\
\[FilledSmallSquare] Not a bug:   Colors appear spotty
\tRaytracers don't allow coincident surfaces with different textures.
\tSee rayshade/extra/circle.[spotty , fixed].ray
\tSee RayOption  RayOverlay\
\>", "Text"],

Cell[TextData[{
  "\[FilledSmallSquare] Not a bug:   in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ver. 4.0\n\tIf you have an older mm, then ie Sphere, Cone, Cylinder, etc\n\
\tare Graphics3D`Shapes`Cone  and change your parameters which\n\tyou may or \
may not (at first) notice.  see  RayOption  RayInformation.\n\t\
Sphere[{0,0,0}] becomes Sphere[{0,0,0},{0,0,0},{0,0,0}]\n\tand may or may not \
render or become an error.\nAnswer: use either rSphere[...] or Sphere[ {...}, \
rad ] or Unevaluated[ Sphere... ]  Use of rSphere does not need to be inside \
Graphics3D."
}], "Text"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "Lines when using RayAspect looks worse and will have problems with a \
drastic squash (say, 50x).  Like ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Graphics[[1]] rayshade` retains orig points orig. points in file.ray.\n\t\
* If you need to do large squashes on an object / scene\n\t* do it in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " before giving the graphic(s) to rayshade`\nKnown problems:  RayAspect \
makes Points oblong points (area of is ok).  (no rayshade primitive for \
arbitrary oblongs to adapt with)  And it makes lines appear very thin in \
areas.  Use of Cylinder is worse with drastic squash, so rayshade precision \
is a factor at least.  And linewidth for cylinder line will be too large.\n\n\
Text will be NOT be squashed (rather they are un-squashed) with caveat the \
text coordinates will be unchanged and possibly (well) outside the plot \
range.\n\nUnlike ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " rayshade has to interpret \"super tiny polygon widths v. view normal\" \
with large squashes to be visible.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on the otherhand simply plots set-width lines at a scew at estimated \
placement."
}], "Text"],

Cell["\<\
\[FilledSmallSquare] Direct use of XrSphere[ Hold[ { {...} } ] ] is \
not suggested as easier and file must be currently OpenAppend for it to work. \
 Note several Xr funs write to string stack not file (GreyLevel, Text).\
\>", \
"Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["License", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell["\<\
\[FilledSmallSquare] Version 2.0 of rayshade.m is Copyright 2013, \
John D. Hendrickson, all righs reserved.  Permission for use is granted for \
evaluation purpose.  Please pay if you find it useful.  Please do not copy \
code parts for use in similar application.  No express or implied: warranty, \
fitness for use.  There is expressely no permission for government or \
commercial use without payment.  Copies of the work may be retained for \
storage and must retain this notice.\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Contact", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell["\<\
\[FilledSmallSquare] If you have a bug to report or a question you \
can contact:
\thttps://groups.google.com/group/comp.soft-sys.math.mathematica
\t(do that first if it might be a newbie question)
\tjohnandsara2@cox.net
\t(not often checked) debguy22124@gmail.com
\[FilledSmallSquare] Please tell me what missing Export feature you most \
believe is needed to make raytraced rendering files more useful.\
\>", "Text",\

  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
\[FilledSmallSquare] Thanks for helping!
\tMurray Eisenberg\tmurray@math.umass.edu\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rayshade  Quick  Reference", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell["\<\
                      Rayshade Quick Reference

------------------------------------------------------------------------------\
-
Key:
[thing]  Optional item              <Thing>  Production
Thing    Number or String           (thing)  Default value(s)
thing    Keyword
------------------------------------------------------------------------------\
-

Reals and integers may be written in exponential notation, with or without a
decimal point.  Reals are truncated to integers when need be.  Numbers may \
also
be written as expressions surrounded by a matched pair of parentheses.
Subexpressions may be parenthesized to control order of evaluation.  \
Variables
may be defined and used in parenthesized expressions.  Predefined variables
include time (current time) and frame (current frame number, 0 - frames-1), \
pi,
dtor (pi/180), rotd (180/pi).  Available operators are '+' (addition),
'-' (subtraction and negation), '*' (multiplication), '/' (division),
'%' (remainder), '^' (exponentiation).  Functions include sin, cos, tan, \
asin,
acos, atan, sqrt, hypot.

Strings are written as non-quoted strings that may include include the
special characters '/' (\"slash\"), '-' (\"dash\"), '_' (\"underscore), and \
'.'
(\"period\"), in addition to upper and lowercase letters and non-leading \
digits.

------------------------------------------------------------------------------\
-
Command-line options (override options set in input file):

-A frame       First frame to render 
-a             Toggle alpha channel   -C cutoff      Adaptive tree cutoff 
-c             Continued rendering    -D depth       Maximum ray tree depth.
-E eye_sep     Eye separation         -e             Exponential RLE output
-F freq        Report frequency       -f             Flip triangle normals
-G gamma       Gamma exponent         -g             Use gaussian filter
-h             Help                   -j             Toggle jittered sampling
-l             Render left eye view   -m             Produce sample map
-N frames      Total frames to render -n             No shadows
-O outfile     Output file name       -o             Toggle opaque shadows 
-P cpp-args    Arguments for cpp      -p             Preview-quality
-q             Run quietly            -R xres yres   Resolution
-r             Right eye view         -S samples     Use Samples^2 samples
-s             Toggle shadow caching  -T r g b       Contrast threshold
-u             Toggle use of cpp      -V filename    Verbose file output
-v             Verbose output         -W lx hx ly hy Render subwindow
-X l r b t     Crop window
------------------------------------------------------------------------------\
-

File: /* Input file consists of...*/
        <Item> [<Item> ... ]

Item:
        <Viewing>
        <Light>
        <Atmosphere>
        <RenderOption>
        <ObjItem>
        <Definition>

ObjItem: /* Items used in object definition blocks */
        <SurfDef>
        <ApplySurf>
        <Instance>
        <ObjDef>

Viewing:
        eyep Xpos Ypos Zpos     /* Eye position (0 -10 0) */
        lookp Xpos Ypos Zpos    /* Look position (0 0 0) */
        up Xup Yup Zup          /* \"up\" vector (0 0 1) */
        fov Hfov [Vfov]         /* Field of view in degrees (horiontal=45) */
        aperture Width          /* Aperture width (0) */
        focaldist Distance      /* focal distance (|eyep - lookp|) */
        shutter Speed           /* Shutter speed (0 --> no blur) */
        framelength Length      /* Length of a singelf frame (1) */
        screen Xsize Ysize      /* Screen size */
        window Xmin Xmax Ymin Ymax /* Window (0 xsize-1 0 ysize-1) */
        crop left right bot top /* Crop window (0 1 0 1) */
        eyesep Separation       /* eye separation (0) */

SurfDef: /* Give a name to a set of surface attributes. */
        surface Name <SurfSpec> [<SurfSpec> ...]

Surface: /* Surface specification */
        <SurfSpec>                /* Use gven attributes */
        Surfname [<SurfSpec> ...] /* Use named surface w/ optional mods. */
        cursurf  [<SurfSpec> ...] /* Use cur. surface w/mods - see ApplySurf \
*/

SurfSpec: /* Surface attribute specification */
        ambient R G B           /* Ambient contribution */
        diffuse R G B           /* Diffuse color */
        specular R G B          /* Specular color */
        specpow Exponent        /* Phong exponent */
        body R G B              /* Body color */
        extinct Coef            /* Extinction coefficient */
        transp Ktr              /* Transparency */
        reflect Kr              /* Reflectivity */
        index N                 /* Index of refraction */
        translu Ktl R G B Stpow /* Translucency, transmit diffuse, spec exp \
*/
        noshadow                /* No shadows cast on this surface */

Effect: /* Atmospheric Effects */
        mist   R G B Rtrans Gtrans Btrans Zero Scale
        fog    R G B Rtrans Gtrans Btrans

Atmosphere: /* Global atmosphere */
        atmosphere [Index] <Effect> [<Effect>...] /* Global index, effects */

ApplySurf:
        applysurf <Surface> /* apply surf to all following objs w/o surface \
*/

Instance: /* Instance of an object */
        <Object> [<Transforms>] [<Textures>] 

Object:
        Primitive        /* Primitive object */
        Aggregate        /* Named aggregate */

ObjDef: /* define a named object */
        name Objname <Instance>
        
Primitive: /* Primitive object */
        plane    [<Surface>] Xpos Ypos Zpos Xnorm Ynorm Znorm
        disc     [<Surface>] Radius Xpos Ypos Zpos Xnorm Ynorm Znorm
        sphere   [<Surface>] Radius Xpos Ypos Zpos
        triangle [<Surface>] Xv1 Yv1 Zv1
                             Xv2 Yv2 Zv2  Xv3 Yv3 Zv3/* flat-shaded triangle \
*/
        triangle [<Surface>] Xv1 Yv1 Zv1 Xn1 Yn1 Zn1
                             Xv2 Yv2 Zv2 Xn2 Yn2 Zn2
                             Xv3 Yv3 Zv3 Xn3 Yn3 Zn3/* Phong-shaded triangle \
*/
        polygon  [<Surface>] Xv1 Yv1 Zv1
                             Xv2 Yv2 Zv2  Xv3 Yv3 Zv3 [Xv3 Yv4 Zv4 ...]
        box      [<Surface>] Xlow Ylow Zlow
                             Xhi  Yhi  Zhi
        cylinder [<Surface>] Radius Xbase Ybase Zbase Xapex Yapex Zapex
        cone     [<Surface>] Rbase Xbase Ybase Zbase  Rapex Xapex Yapex Zapex
        torus    [<Surface>] Rswept Rtube Xpos Ypos Zpos Xnorm Ynorm Znorm
        blob     [<Surface>] Thresh Stren Rad Xpos Ypos Zpos
                             [Stren Rad X Y Z ...]
        heightfield [<Surface>] Filename

Aggregate:
        Grid
        List
        Csg

Grid:
        grid X Y Z <ObjItem> [<ObjItem> ...]  end

List:
        list <ObjItem> [<ObjItem> ...] end

Csg:
        union      <Object> <Object> [<Object> ...] end
        intersect  <Object> <Object> [<Object> ...] end
        difference <Object> <Object> [<Object> ...] end

        /* CSG will only work properly when applied to closed objects, e.g.:
         * sphere, box, torus, blob, closed Aggregate, other Csg object
         */

Transforms: /* Transformations */
        translate  Xtrans Ytrans Ztrans
        scale      Xscale Yscale Zscale
        rotate     Xaxis Yaxis Zaxis Degrees
        transform  A   B   C
                   D   E   F
                   G   H   I
                  [Xt  Yt  Zt]

Textures:
        texture <TextType> [Transforms] [<Texture> [Transforms] ...]

Texture:
        checker    <Surface>
        blotch    Scale <Surface>
        bump      Bumpscale
        marble    [Colormapname]
        fbm       Offset Scale H Lambda Octaves Thresh [Colormapname]
        fbmbump   Offset Scale H Lambda Octaves
        wood
        gloss     Glossiness
        cloud     Offset Scale H Lambda Octaves Cthresh Lthresh Transcale
        sky       Scale H Lambda Octaves Cthresh Lthresh
        stripe    <Surface> Width Bumpscale
        image     Imagefile [<ImageTextOption> [<ImageTextOption> ...]]

ImageTextOption:
        component <SufComp>
        range     Lo Hi
        smooth
        textsurf  <Surface>
        tile      U V
        <Mapping>

SurfComp:
        ambient
        diffuse
        reflect
        transp
        specular
        specpow

Mapping:
        map uv
        map cylindrical [Xorigin Yorigin Zorigin Xup Yup Zup Xu Yu Zu] 
        map planar      [Xorigin Yorigin Zorigin Xv  Yv  Zv  Xu Yu Zu]
        map spherical   [Xorigin Yorigin Zorigin Xup Yup Zup Xu Yu Zu]

Light:
        light R G B <LightType> [noshadow]
        light Intensity <LightType> [noshadow]

LightType:
        ambient
        point       Xpos Ypos Zpos
        directional Xdir Ydir Zdir
        extended    Radius Xpos Ypos Zpos
        spot        Xpos Ypos Zpos Xat Yat Zat Coef Thetain Thetaout
        area        Xorigin Yorigin Zorigin Xu Yu Zu Usamples Xv Yv Zv \
Vsamples

RenderOption:
        samples      Nsamp [jitter | nojitter]
                                /* Use Nsamp^2 pixel samples (3^2 jittered) \
*/
        background   R G B      /* Background color (0 0 0) */
        outfile      Filename   /* Output file name (written to stdout) */
        frames       Nframes    /* Number of frames to render (1) */
        starttime    Time       /* Time corresponding to start of frame 0 */
        contrast     R G B      /* Maximum contrast w/o supersampling */
        maxdepth     Depth      /* Maximum ray tree depth (5) */
        cutoff       Factor     /* Minium spawned ray contribution (.001) */
        report [verbose] [quiet] [Freq] [Statfile]
                                /* Reporting mode (false false 10 stderr) */
        shadowtransp            /* Toggle object opacity affects shadows */

Definition: /* Variable definition */
        define Name Expr        /* Assign value for Name */\
\>", "Print",
  CellLabel->"From (lic2) In[32]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["spurious code  notes  /  scene setup notes", "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],

Cell[TextData[{
  "Basic Scene Setup notes:  OLD notes\n\tSet things up so eye sees the whole \
box, optimally.\n\t\tthis is a most complicated thing to do\n\tMathematica \
doesn't adjust ViewPoint\n\t\tit magically squashes objects to fit in view\n\t\
\tOR changes final image size: often both.  see options.\n\trayshade needs \
eyep farther away to keep \"fov\" field of view\n\t\treasonable, hopefully 45 \
exactly.  a \"wide angle\"\n\t\tfov like 120 distorts final scene.\n\t\tit's \
problematic getting fov just right.\n\t\tanother is whether to use \
ViewCenter.\n\tPlotRange should work the same.\n\t\tNote you can change this \
opt before and or after\n\t\tPlot3d and it moves whole scene around.\n\n\t\
ViewCenter and lookp\n\t",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applies this after scene is made.  rayshade 1.0 used it as\n\tlookp (.5 \
.5 .5 is wrong).  See code notes about scene setup.\n\tView Center is not \
done by rayshade.nb\n\t(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " centers / crops some images after it renders, \"vc\")\n\t** Still, if you \
provide ViewCenter an override it's used as lookp.\n\nNEW: ignore this as a \
problem: r1.23 setup centers vp and lookp to be boxcenter\n\tViewCenter (see \
below) translates img AFTER the scene is rendered.\n\t\twhich one can do by \
cropping with an image program\n\t\t\trayshade -R x y  -X l r b t  might also \
help\n\t\t\tThis program isn't mature enough to know what\n\t\t\twhere in \
resulting image bounding box is for using -X\n\t\tor by using import / export \
with the front-end\n\t\t\tViewCenter is IGNORED, not feature raytracers do\n\t\
\tNOTE: it's not the same as translating shapes before rendering\n\t\tthe \
view angle of an object is all different when translated\n\t\t** there are of \
course many ways around relying on vc **\n\nNEW: vp not a position vector \
now, it looks at lookp (pos. vec. is vp-boxcenter)\n\tViewPoint should be \
construed as a Position Vector (vp-0).\n\tAt the right distance (dist * vp) \
the perspective in rayshade is the same\n\tas in the notebook (the viewing \
angle against each object).\n\t\t* using n (vp-vc) the wrong angle of view is \
had\n\t\t* note vp still points to origin 0 if PlotRange is manually\n\t\t   \
translated in front end and or for rayshade\n\t\t   (therefor it's one way to \
do translation for either / both)\n\t** n won't be perfect but often gets \
perspective very close to what\n\t     notebook used.  Sometimes fov or more \
rarely ViewPoint will need\n\t     a little manual editing in file.ray to \
\"zoom in\" or \"zoom out\"\n\n\[FilledSmallSquare] The view point is given \
in a special scaled coordinate system in which the longest side of the \
bounding box has length 1. The center of the bounding box is taken to have \
coordinates ",
  StyleBox["{0,", "MR"],
  " ",
  StyleBox["0,", "MR"],
  " ",
  StyleBox["0}", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ViewCenter", "MR"],
  " is an option for ",
  StyleBox["Graphics3D", "MR"],
  " and ",
  StyleBox["SurfaceGraphics", "MR"],
  " which gives the scaled coordinates of the point which appears at the \
center of the display area in the final plot. \n\[FilledSmallSquare] With the \
setting ",
  StyleBox["ViewCenter", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{1/2,", "MR"],
  " ",
  StyleBox["1/2,", "MR"],
  " ",
  StyleBox["1/2}", "MR"],
  ", the center of the three\[Hyphen]dimensional bounding box will be placed \
at the center of the final display area. \n\[FilledSmallSquare] In three\
\[Hyphen]dimensional graphics, polygons are considered to have both a front \
and a back face. The sense of a polygon is defined in terms of its first \
three vertices. When taken in order, these vertices go in a ",
  StyleBox["counterclockwise", "TI"],
  " direction when viewed from the ",
  StyleBox["front", "TI"],
  ". (The frontward normal is thus obtained from a ",
  StyleBox["right\[Hyphen]hand", "TI"],
  " rule.) "
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "Code notes:\n\t",
  Cell[BoxData[
      \(\(onnormalplane = \(-1\) {0, vp[\([2]\)]\/vp[\([1]\)], 
              vp[\([3]\)]\/vp[\([1]\)]};\)\)],
    InitializationCell->True],
  "\n\tis the solution to eq. of normal plane\n  \t    \ta(x-x0) + b(y-y0) + \
c(z-z0) == 0\n  \tin general ax+by+cz==0 is a plane with normal <a,b,c>\n     \
\tx is taken to be 0 because it can be\n     \t\tb = (c z) / y\n      \tand \
vp=<a,b,c>\n      \tnote there are inf. many sol'n having differing direction \
on it."
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
Glass is touchy ...
note rayshade values for glass it is very touchy to get translucence without \
washing out image whithout removing gradient shading of poly and get phong \
too note POVRay is using a builtin texture function phong() as a helper to \
get about the same effect.  rayshade also has a variety of \"auto texture\" \
functions but not one for that.

to get \"good glass\" you have to have lights and surface specs match up \
exactly right\
\>", "Text"],

Cell["\<\
Text probem for POVRay
\tI think for small sizes povray is \"lossy\" because if it's enlarged say 8x
\tletters are clear but a little blocky. (w/orig very smooth)
\tThis isn't useable because 8x is way too large and end-user can
\t8x times the font anyhow.
\tNEW:
\t\tafter finding out given ImageSize Raster was much easier than I 
\t\tthought I tried the same code in Text for POV figuring that would
\t\tfix lossiness.  it didn't make any difference.  done trying to fix it
\t\t? maybe there's a lossiness setting I dont' know of ?\
\>", "Text"],

Cell["\<\
Text transparency for rayshade
\t(from above)
 Have no time for text with no background.  It can be done.  One way is to do \
text in reverse contrast and make object black and background transparent.  \
Extra complication I don't want to added in a first version.
\tAs text is made transp .4, the black of text is \"see through\" instead of
\tthe white background, is the way things work.
Also rayshade pays attention to alpha channels as to color mixing that \
texture surfaces can take advantage of that. Furthermore \"component\" can be \
used so that textures apply to only particular surface properties (ie, \
diffuse only, transparency only, ...).  The PROBLEM is image analysis and \
scene setup analysis.  Assuming RLE is in use there's no telling is alpha \
channel is in use.  And that changes everything being done depending how \
used.

The problem is complexity.  The more features used to make text background \
transparent the more chance it won't be seen at all for unforseen \
circumstances / scene settings.  I'd rather have it simple and (mostly) \
immutable for a first release.
\
\>", "Text"],

Cell[TextData[{
  "Texture Coordinates\n\nNEW: after finding raster is easier if poly is \
normalized\n",
  "(*\ncreate at origin facing {0,-1,0).  scaling is need for poly size v. \
image size.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " always faces text toward ViewPoint.  Translate as needed.  Rotate x then \
z using vpRotAngles.  See notes in rayshade-note.nb for detail\n\nnote raster \
uses normalized poly and resizes afterward which likely is better quality \
more reliable for huge text going deep.  however the above works well for \
text i've tried (poly and texture well aligned) i see no reason to change it, \
code wise it would be likely be barely simpler.\n*)",
  "\n\ntry to render text to image.  in rayshade texture must be put on \
polygon however: they must be positioned separately and positioning textures \
in 3-space is a total pain.  However.  once a named list then positioning \
works on both at once easily.\n\nFor ease they are placed not with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calculated positions but at origin facing {0,-1,0).  scaling is need for \
rect size v. imagage size.  Next consider ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " always faces text toward ViewPoint.\n\nFirst translate to pos Text[ , \
,coord] says to.  Then make rotations, on x-y a next z-y face text toward \
ViewPoint.  Note the sense is reversed using rayshade (rotate 1 0 0 turns \
text on x axis).\n\nNote rayshade texture coord \"punting\".  For textures it \
uses x-y not x-z despite what up says.\n\n(* x scale to make rect given pixel \
width of text *)\n(* .00076 for 2630 pix; \\\n.0007276 for 368pix *)\n(* \
.00076(2630/2630)-.0052 (368/2630)\n    ==m(2630-386) gives\n  *)\n\
m=1.4321590301661122`*^-8;\nf[x_]:=.00076-m(2630-x); \n\
x=f[box[[2]]]~N~maxprecision;"
}], "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
surfstore
\tif surfstore was allowed mult. entries per group then it would be necessary \
to remove prev names however - it isn't.  The program assumes any surfspec \
given replaces whatever is current and takes care of choosing a name if it \
needs name (regular or glass).
\tStringReplace[ surfstore[[Length[surfstore]]],{\"regular\"\[Rule]\"\", \
\"glass\"->\"\"} ];\
\>", "Text"],

Cell["\<\
old processOpts
\torig code inserted these from fullopts into opts just before processOpts
\t\tvc=ViewCenter/.opointInPlotRange/.Options[Graphics3D];
\t\tvv=ViewVertical/.opointInPlotRange/.Options[Graphics3D];
\t\tnote Options[...] is usu. Automatic
\tfov was 47.8 for all regular plots, and wrong for many, ie. Plot3D
\t\twriteNums[file,\"fov\",N[fov/Degree,32]];
\t\tfov is one way to fit obj in scene; obj scale is another\
\>", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell["\<\
(*
why writeobj[ functionsymbol, Hold[ obj_ ] ] is used instead of more familiar
writeobj[ g_function[ {arg1_, arg2_} ] ] to get to handler with arg1, arg2.

We need(ed) undefined functions (rLine2) that have different SetAttributes \
than
Line, different parameter abilities (mm 4.0, mm 9.0) and as well are \
impervious to
unintended evaluation (ie, are not evaluated by ReplaceAll or when passed as \
an
argument).  mm tends to work oppositely.
\tSetAttributes[writeobj,HoldAll];
\tcan be used with (matcher needs to evaluate to match...)
\t\twriteobj[file,g_,x_] NOT even writeobj[file,g_Symbol,x_List]
\t\tthis would be used to avoid continual evaluation of Graphics
\twriteobj[file_g:rGraphics3D[oblist_,opts_List:{}]]  picks out objlist opts
\t\tfor function however that is convenience, function can do that anyway.
\tEXCEPT that we're using rGraphics (never defined)
\tAND, ie, RGBColor is innoculous as to re-evaluation
\tAND we'd like if user can override rLine as they can Line.
\tSO HoldAll isn't required (and parameter matching is gained).
NOTE: while the setup looks familiar it is doing all the above.  It's not \
arbitraray.

\tWRONG.
\t\tfor List what's inside list evaluates so Unevaluated
\t\tand name replacing doesn't avoid re-evaluating Graphics at least some
\tSO
\t\tuse callwriteobj to separate function head and args w/o evaluating
\t\tallow symbol to use matching while holding obj_
\t\t\tthis is so nesting writeobj[ List, obj_ ] can work without
\t\t\tcontinually evaluating obj (hopefully it doesn't keep copying either ! \
)
\t\twriteobj[ symbol, obj_ ]
\t\t\tcaveat?  each fun must splice obj_ as need be: however that's 
\t\t\ta bonus because some funs need to handle more than one split
*)\
\>", "Text",
  InitializationCell->True],

Cell[BoxData[{
    \( (*\[IndentingNewLine]why\ writeobj[functionsymbol, 
          Hold[obj_]]\ is\ used\ instead\ of\ more\ familiar; \
\[IndentingNewLine]writeobj[
          g_function[{arg1_, arg2_}]]\ to\ get\ to\ handler\ with\ arg1, 
      arg2; \[IndentingNewLine]\[IndentingNewLine]this\ older\ attempt\ shows\
\ difficulties; \[IndentingNewLine]trying\ to\ keep\ writeobj[file, 
          g : fun[arg1_, 
              arg2_]];\[IndentingNewLine]*) \[IndentingNewLine]\
\[IndentingNewLine] (*\ 
      which\ Attributes\ Sphere[]\ \ what\ argument\ pattern; 
      mm\ ver . \ 
          9\ or\ same\ named\ upgrades\ introduces; \[IndentingNewLine]\
\[IndentingNewLine]\t
      argument\ matching\ problems; \
\[IndentingNewLine]\[IndentingNewLine]Sphere\ may\ not\ be\ defined\ in\ 4.0\ \
and\ if\ it\ is; \[IndentingNewLine]we\ need\ both\ mm\ 4.0\ and\ mm\ 9.0\ \
argument\ matches; \[IndentingNewLine]also\ we\ may\ not\ want\ whatever\ \
attrbutes\ were\ set; \[IndentingNewLine]for\ ex . \ 
          mm\ 9.0\ adds\ new\ grouping\ inside\ \(\(Sphere\)\(.\)\); 
      thats\ hard\ to\ test\ if\ mm\ 4.0\ is\ \(\(running\)\(.\)\); \
\[IndentingNewLine]finally\ we\ may\ want\ to\ add\ new\ arguments\ or\ \
matching; \[IndentingNewLine]or\ to\ be\ able\ to\ set\ attributes;\
\[IndentingNewLine]*) \[IndentingNewLine]\[IndentingNewLine] (*\ 
      what\ to\ use\ of\ only\ current\ ver\ mm\ matching\ is\ allowed\ *) \
\[IndentingNewLine] (*\ \(writeobj[
          file, #];\)\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
      wrong\ way; \[IndentingNewLine]writeobj[
        file, \(Symbol[
            ToString[#[\([0]\)]]]\)[#[\([1]\)]]]; \[IndentingNewLine]this\ \
may\ or\ may\ not\ become\ rayshade`Private`obj[ ... ];\[IndentingNewLine]*) \
\[IndentingNewLine]\[IndentingNewLine] (*\ 
      the\ below\ would\ substitute\ some\ needs\ but\ still\ not\ fill\ all\ \
*) \[IndentingNewLine]\[IndentingNewLine]\(lprimcount = 
        primcount;\)\), "\[IndentingNewLine]", 
    \(\(writeobj[file, #];\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(If[
        lprimcount === primcount, \[IndentingNewLine]Print[
          obj[\([0]\)]]; \[IndentingNewLine]ctp = $ContextPath; \
\[IndentingNewLine]$ContextPath = {"\<rayshade`Private`\>"}; \
\[IndentingNewLine]rpobj = obj[\([0]\)]; \[IndentingNewLine]$ContextPath = 
          ctp; \[IndentingNewLine]writeobj[file, 
          rpobj[obj[\([1]\)]]];\[IndentingNewLine]];\)\[IndentingNewLine]\
\[IndentingNewLine] (*\[IndentingNewLine]if\ we\ dont\ rename\ Line \[Rule] 
        rpLine, \ 
      if\ Context\ is\ used; \[IndentingNewLine]a\ trap\ is\ Mathematica\ \
changing\ definition\ of\ ie . \ 
          Line; \[IndentingNewLine]which\ has\ happened\ already; \ 
      thus\ arg\ match\ will\ fail; \[IndentingNewLine]also\ to\ add\ new\ \
matches\ Line \[Rule] 
        rpLine\ is\ again\ needed;\[IndentingNewLine]*) \)}], "Input"],

Cell["FullOptions[p3]", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \({AmbientLight \[Rule] GrayLevel[0.`], 
      AspectRatio \[Rule] 0.8111359925044471`, Axes \[Rule] True, 
      AxesEdge \[Rule] Automatic, AxesLabel \[Rule] None, 
      AxesStyle \[Rule] Automatic, Background \[Rule] Automatic, 
      Boxed \[Rule] True, BoxRatios \[Rule] {1.`, 1.`, 0.4`}, 
      BoxStyle \[Rule] Automatic, ClipFill \[Rule] Automatic, 
      ColorFunction \[Rule] Automatic, ColorFunctionScaling \[Rule] True, 
      ColorOutput \[Rule] Automatic, DefaultColor \[Rule] Automatic, 
      Epilog \[Rule] {}, FaceGrids \[Rule] None, HiddenSurface \[Rule] True, 
      ImageSize \[Rule] Automatic, Lighting \[Rule] True, 
      LightSources \[Rule] {{{1.`, 0.`, 1.`}, 
            RGBColor[1.`, 0.`, 0.`]}, {{1.`, 1.`, 1.`}, 
            RGBColor[0.`, 1.`, 0.`]}, {{0.`, 1.`, 1.`}, 
            RGBColor[0.`, 0.`, 1.`]}}, Mesh \[Rule] True, 
      MeshRange \[Rule] {{\(-5.`\), 5.`}, {\(-2.`\), 2.`}}, 
      MeshStyle \[Rule] Automatic, 
      Plot3Matrix \[Rule] {{0.18206863201988546`, \(-0.08364924488574586`\), \
\(-0.025989674100720138`\), \(-0.03841851809676022`\)}, {0.3612219295064409`, 
            0.38607343793421167`, 0.11995234200332362`, 
            0.17731623736966248`}, {\(-0.03061313963292485`\), 
            0.160657793587851`, \(-0.04141885536842973`\), \
\(-0.061226279265849705`\)}, {1.691892431568863`, 
            1.691892431568863`, \(-3.7383290907300193`*^-16\), 
            3.383784863137726`}}, PlotLabel \[Rule] None, 
      PlotRange \[Rule] {{\(-5.`\), 5.`}, {\(-2.`\), 
            2.`}, {\(-1.9307203758018174`\), 1.9307203758018174`}}, 
      PlotRegion \[Rule] Automatic, Prolog \[Rule] {}, Shading \[Rule] True, 
      SphericalRegion \[Rule] False, Ticks \[Rule] Automatic, 
      ViewCenter \[Rule] {0.5`, 0.5`, 0.5`}, 
      ViewPoint \[Rule] {1.3`, \(-2.4`\), 2.`}, 
      ViewVertical \[Rule] {0.`, 0.`, 1.`}, 
      DefaultFont \[Rule] {"Courier", 10.`}, 
      DisplayFunction \[Rule] \((Display[$Display, #1] &)\), 
      FormatType \[Rule] StandardForm, TextStyle \[Rule] {}}\)], "Output",
  CellTags->{"S1.1.1", "1.1"}],

Cell["Options[Graphics3D]", "Text",
  CellTags->{"S1.1.1", "1.1"}],

Cell[BoxData[
    \({AmbientLight \[Rule] GrayLevel[0], AspectRatio \[Rule] Automatic, 
      Axes \[Rule] False, AxesEdge \[Rule] Automatic, AxesLabel \[Rule] None, 
      AxesStyle \[Rule] Automatic, Background \[Rule] Automatic, 
      Boxed \[Rule] True, BoxRatios \[Rule] Automatic, 
      BoxStyle \[Rule] Automatic, ColorOutput \[Rule] Automatic, 
      DefaultColor \[Rule] Automatic, Epilog \[Rule] {}, 
      FaceGrids \[Rule] None, ImageSize \[Rule] Automatic, 
      Lighting \[Rule] True, 
      LightSources \[Rule] {{{1.`, 0.`, 1.`}, 
            RGBColor[1, 0, 0]}, {{1.`, 1.`, 1.`}, 
            RGBColor[0, 1, 0]}, {{0.`, 1.`, 1.`}, RGBColor[0, 0, 1]}}, 
      Plot3Matrix \[Rule] Automatic, PlotLabel \[Rule] None, 
      PlotRange \[Rule] Automatic, PlotRegion \[Rule] Automatic, 
      PolygonIntersections \[Rule] True, Prolog \[Rule] {}, 
      RenderAll \[Rule] True, Shading \[Rule] True, 
      SphericalRegion \[Rule] False, Ticks \[Rule] Automatic, 
      ViewCenter \[Rule] Automatic, ViewPoint \[Rule] {1.3`, \(-2.4`\), 2.`}, 
      ViewVertical \[Rule] {0.`, 0.`, 1.`}, 
      DefaultFont \[RuleDelayed] $DefaultFont, 
      DisplayFunction \[RuleDelayed] $DisplayFunction, 
      FormatType \[RuleDelayed] $FormatType, 
      TextStyle \[RuleDelayed] $TextStyle}\)], "Output",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->None,
WindowSize->{520, 600},
WindowMargins->{{2, Automatic}, {102, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.1.1"->{
    Cell[1717, 49, 62, 1, 44, "Subsection",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[1782, 52, 274, 7, 47, "Usage",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[2059, 61, 282, 6, 73, "DefinitionBox",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[2344, 69, 138, 4, 16, "Caption",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[2485, 75, 1529, 29, 290, "Notes",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4017, 106, 170, 4, 24, "Text",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[4289, 117, 235, 5, 50, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4527, 124, 132, 3, 26, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4662, 129, 108, 2, 26, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4773, 133, 110, 1, 34, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4886, 136, 81, 2, 28, "Input",
      Evaluatable->False,
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4970, 140, 90, 2, 28, "Input",
      Evaluatable->False,
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5063, 144, 85, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5151, 147, 94, 2, 28, "Input",
      Evaluatable->False,
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5248, 151, 69, 1, 34, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5320, 154, 199, 5, 42, "Input",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[5522, 161, 79, 1, 34, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5604, 164, 87, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5694, 167, 173, 3, 42, "Input",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[5870, 172, 78, 1, 34, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5951, 175, 208, 4, 42, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[6162, 181, 441, 10, 82, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[6640, 196, 71, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[6714, 199, 440, 9, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[7157, 210, 683, 13, 240, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[7843, 225, 221, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[8067, 232, 489, 10, 168, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[8559, 244, 1520, 26, 552, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[10082, 272, 435, 11, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[10520, 285, 425, 10, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[10948, 297, 624, 12, 192, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[11575, 311, 229, 6, 96, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[11807, 319, 664, 14, 240, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[12474, 335, 1593, 29, 600, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[14070, 366, 178, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[14251, 373, 417, 9, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[14671, 384, 840, 17, 264, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[15514, 403, 398, 8, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[15915, 413, 315, 7, 96, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[16233, 422, 291, 9, 168, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[16527, 433, 495, 11, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[17025, 446, 302, 7, 96, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[17330, 455, 664, 17, 312, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[17997, 474, 795, 14, 312, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[18795, 490, 619, 13, 240, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[19417, 505, 371, 9, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[19791, 516, 168, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[19962, 523, 200, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[20199, 533, 67, 1, 39, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[20269, 536, 5774, 79, 2256, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[26080, 620, 84, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[26167, 623, 296, 7, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[26466, 632, 279, 7, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[28630, 692, 67, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[28700, 695, 310, 8, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[29013, 705, 2013, 30, 816, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[31029, 737, 350, 8, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[31382, 747, 418, 8, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[31803, 757, 901, 18, 288, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[32707, 777, 1015, 18, 312, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[33725, 797, 443, 9, 168, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34171, 808, 222, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34396, 815, 80, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34479, 818, 210, 6, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34692, 826, 117, 2, 26, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34812, 830, 358, 8, 106, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[35173, 840, 119, 4, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[35295, 846, 277, 5, 90, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[35575, 853, 266, 6, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[35844, 861, 253, 6, 96, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[36134, 872, 107, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[38640, 933, 64, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[38707, 936, 539, 9, 88, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[39283, 950, 64, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[39350, 953, 461, 11, 160, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[39957, 974, 83, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[49902, 1235, 99, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[50004, 1238, 4036, 77, 1312, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[54043, 1317, 562, 12, 224, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[56775, 1379, 1885, 33, 784, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[59059, 1424, 481, 10, 192, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[64243, 1529, 62, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[64308, 1532, 2107, 35, 413, "Output",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[66418, 1569, 66, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[66487, 1572, 1339, 23, 277, "Output",
      CellTags->{"S1.1.1", "1.1"}]},
  "1.1"->{
    Cell[1717, 49, 62, 1, 44, "Subsection",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[1782, 52, 274, 7, 47, "Usage",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[2059, 61, 282, 6, 73, "DefinitionBox",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[2344, 69, 138, 4, 16, "Caption",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[2485, 75, 1529, 29, 290, "Notes",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4017, 106, 170, 4, 24, "Text",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[4212, 114, 74, 1, 39, "ExampleSection",
      CellTags->{"1.1", "S1.7.1"}],
    Cell[4289, 117, 235, 5, 50, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4527, 124, 132, 3, 26, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4662, 129, 108, 2, 26, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4773, 133, 110, 1, 34, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4886, 136, 81, 2, 28, "Input",
      Evaluatable->False,
      CellTags->{"S1.1.1", "1.1"}],
    Cell[4970, 140, 90, 2, 28, "Input",
      Evaluatable->False,
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5063, 144, 85, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5151, 147, 94, 2, 28, "Input",
      Evaluatable->False,
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5248, 151, 69, 1, 34, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5320, 154, 199, 5, 42, "Input",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[5522, 161, 79, 1, 34, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5604, 164, 87, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5694, 167, 173, 3, 42, "Input",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[5870, 172, 78, 1, 34, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[5951, 175, 208, 4, 42, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[6162, 181, 441, 10, 82, "ExampleText",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[6640, 196, 71, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[6714, 199, 440, 9, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[7157, 210, 683, 13, 240, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[7843, 225, 221, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[8067, 232, 489, 10, 168, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[8559, 244, 1520, 26, 552, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[10082, 272, 435, 11, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[10520, 285, 425, 10, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[10948, 297, 624, 12, 192, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[11575, 311, 229, 6, 96, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[11807, 319, 664, 14, 240, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[12474, 335, 1593, 29, 600, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[14070, 366, 178, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[14251, 373, 417, 9, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[14671, 384, 840, 17, 264, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[15514, 403, 398, 8, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[15915, 413, 315, 7, 96, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[16233, 422, 291, 9, 168, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[16527, 433, 495, 11, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[17025, 446, 302, 7, 96, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[17330, 455, 664, 17, 312, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[17997, 474, 795, 14, 312, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[18795, 490, 619, 13, 240, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[19417, 505, 371, 9, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[19791, 516, 168, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[19962, 523, 200, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[20199, 533, 67, 1, 39, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[20269, 536, 5774, 79, 2256, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[26080, 620, 84, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[26167, 623, 296, 7, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[26466, 632, 279, 7, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[28630, 692, 67, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[28700, 695, 310, 8, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[29013, 705, 2013, 30, 816, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[31029, 737, 350, 8, 120, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[31382, 747, 418, 8, 144, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[31803, 757, 901, 18, 288, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[32707, 777, 1015, 18, 312, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[33725, 797, 443, 9, 168, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34171, 808, 222, 5, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34396, 815, 80, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34479, 818, 210, 6, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34692, 826, 117, 2, 26, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[34812, 830, 358, 8, 106, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[35173, 840, 119, 4, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[35295, 846, 277, 5, 90, "Input",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[35575, 853, 266, 6, 72, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[35844, 861, 253, 6, 96, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[36134, 872, 107, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[38640, 933, 64, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[38707, 936, 539, 9, 88, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[39283, 950, 64, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[39350, 953, 461, 11, 160, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[39957, 974, 83, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[49902, 1235, 99, 1, 33, "ExampleSection",
      CellTags->{"1.1", "S1.1.1"}],
    Cell[50004, 1238, 4036, 77, 1312, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[54043, 1317, 562, 12, 224, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[56775, 1379, 1885, 33, 784, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[59059, 1424, 481, 10, 192, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[64243, 1529, 62, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[64308, 1532, 2107, 35, 413, "Output",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[66418, 1569, 66, 1, 24, "Text",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[66487, 1572, 1339, 23, 277, "Output",
      CellTags->{"S1.1.1", "1.1"}]},
  "S1.7.1"->{
    Cell[4212, 114, 74, 1, 39, "ExampleSection",
      CellTags->{"1.1", "S1.7.1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.1.1", 68495, 1616},
  {"1.1", 75327, 1790},
  {"S1.7.1", 82247, 1966}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 62, 1, 44, "Subsection",
  CellTags->{"S1.1.1", "1.1"}],
Cell[1782, 52, 274, 7, 47, "Usage",
  CellTags->{"S1.1.1", "1.1"}],
Cell[2059, 61, 282, 6, 73, "DefinitionBox",
  CellTags->{"S1.1.1", "1.1"}],
Cell[2344, 69, 138, 4, 16, "Caption",
  CellTags->{"S1.1.1", "1.1"}],
Cell[2485, 75, 1529, 29, 290, "Notes",
  CellTags->{"S1.1.1", "1.1"}],
Cell[4017, 106, 170, 4, 24, "Text",
  CellTags->{"1.1", "S1.1.1"}],

Cell[CellGroupData[{
Cell[4212, 114, 74, 1, 39, "ExampleSection",
  CellTags->{"1.1", "S1.7.1"}],
Cell[4289, 117, 235, 5, 50, "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],
Cell[4527, 124, 132, 3, 26, "Input",
  CellTags->{"S1.1.1", "1.1"}],
Cell[4662, 129, 108, 2, 26, "Input",
  CellTags->{"S1.1.1", "1.1"}],
Cell[4773, 133, 110, 1, 34, "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],
Cell[4886, 136, 81, 2, 28, "Input",
  Evaluatable->False,
  CellTags->{"S1.1.1", "1.1"}],
Cell[4970, 140, 90, 2, 28, "Input",
  Evaluatable->False,
  CellTags->{"S1.1.1", "1.1"}],
Cell[5063, 144, 85, 1, 24, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[5151, 147, 94, 2, 28, "Input",
  Evaluatable->False,
  CellTags->{"S1.1.1", "1.1"}],
Cell[5248, 151, 69, 1, 34, "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],
Cell[5320, 154, 199, 5, 42, "Input",
  CellTags->{"1.1", "S1.1.1"}],
Cell[5522, 161, 79, 1, 34, "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],
Cell[5604, 164, 87, 1, 24, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[5694, 167, 173, 3, 42, "Input",
  CellTags->{"1.1", "S1.1.1"}],
Cell[5870, 172, 78, 1, 34, "ExampleText",
  CellTags->{"S1.1.1", "1.1"}],
Cell[5951, 175, 208, 4, 42, "Input",
  CellTags->{"S1.1.1", "1.1"}],
Cell[6162, 181, 441, 10, 82, "ExampleText",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[6640, 196, 71, 1, 33, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[6714, 199, 440, 9, 120, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[7157, 210, 683, 13, 240, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[7843, 225, 221, 5, 72, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[8067, 232, 489, 10, 168, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[8559, 244, 1520, 26, 552, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[10082, 272, 435, 11, 120, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[10520, 285, 425, 10, 144, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[10948, 297, 624, 12, 192, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[11575, 311, 229, 6, 96, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[11807, 319, 664, 14, 240, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[12474, 335, 1593, 29, 600, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[14070, 366, 178, 5, 72, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[14251, 373, 417, 9, 120, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[14671, 384, 840, 17, 264, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[15514, 403, 398, 8, 144, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[15915, 413, 315, 7, 96, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[16233, 422, 291, 9, 168, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[16527, 433, 495, 11, 144, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[17025, 446, 302, 7, 96, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[17330, 455, 664, 17, 312, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[17997, 474, 795, 14, 312, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[18795, 490, 619, 13, 240, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[19417, 505, 371, 9, 144, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[19791, 516, 168, 5, 72, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[19962, 523, 200, 5, 72, "Text",
  CellTags->{"S1.1.1", "1.1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20199, 533, 67, 1, 39, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[20269, 536, 5774, 79, 2256, "Text",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[26080, 620, 84, 1, 33, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[26167, 623, 296, 7, 120, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[26466, 632, 279, 7, 72, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[26748, 641, 505, 12, 264, "Text"],
Cell[27256, 655, 658, 13, 240, "Text"],
Cell[27917, 670, 676, 17, 336, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[28630, 692, 67, 1, 33, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[28700, 695, 310, 8, 144, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[29013, 705, 2013, 30, 816, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[31029, 737, 350, 8, 120, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[31382, 747, 418, 8, 144, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[31803, 757, 901, 18, 288, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[32707, 777, 1015, 18, 312, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[33725, 797, 443, 9, 168, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[34171, 808, 222, 5, 72, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[34396, 815, 80, 1, 24, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[34479, 818, 210, 6, 72, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[34692, 826, 117, 2, 26, "Input",
  CellTags->{"S1.1.1", "1.1"}],
Cell[34812, 830, 358, 8, 106, "Input",
  CellTags->{"S1.1.1", "1.1"}],
Cell[35173, 840, 119, 4, 24, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[35295, 846, 277, 5, 90, "Input",
  CellTags->{"S1.1.1", "1.1"}],
Cell[35575, 853, 266, 6, 72, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[35844, 861, 253, 6, 96, "Text",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[36134, 872, 107, 1, 33, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[36244, 875, 225, 5, 96, "Text"],
Cell[36472, 882, 598, 11, 184, "Text"],
Cell[37073, 895, 1280, 26, 304, "Text"],
Cell[38356, 923, 247, 5, 56, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[38640, 933, 64, 1, 33, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[38707, 936, 539, 9, 88, "Text",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[39283, 950, 64, 1, 33, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[39350, 953, 461, 11, 160, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[39814, 966, 106, 3, 48, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[39957, 974, 83, 1, 33, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[40043, 977, 9822, 253, 4566, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[49902, 1235, 99, 1, 33, "ExampleSection",
  CellTags->{"1.1", "S1.1.1"}],
Cell[50004, 1238, 4036, 77, 1312, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[54043, 1317, 562, 12, 224, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[54608, 1331, 476, 10, 144, "Text"],
Cell[55087, 1343, 558, 11, 240, "Text"],
Cell[55648, 1356, 1124, 21, 344, "Text"],
Cell[56775, 1379, 1885, 33, 784, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[58663, 1414, 393, 8, 104, "Text"],
Cell[59059, 1424, 481, 10, 192, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[59543, 1436, 1777, 39, 768, "Text",
  InitializationCell->True],
Cell[61323, 1477, 2917, 50, 874, "Input"],
Cell[64243, 1529, 62, 1, 24, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[64308, 1532, 2107, 35, 413, "Output",
  CellTags->{"S1.1.1", "1.1"}],
Cell[66418, 1569, 66, 1, 24, "Text",
  CellTags->{"S1.1.1", "1.1"}],
Cell[66487, 1572, 1339, 23, 277, "Output",
  CellTags->{"S1.1.1", "1.1"}]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

