(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     88828,       2566]*)
(*NotebookOutlinePosition[     91533,       2655]*)
(*  CellTagsIndexPosition[     91262,       2642]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["tests", "Subsubsection"],

Cell[BoxData[
    \(\(reset[];\)\)], "Input"],

Cell[BoxData[
    \(<< rayshade.m\)], "Input"],

Cell[BoxData[
    \({p4, xx}\)], "Input"],

Cell[BoxData[
    \(\(\(,\)\(RayOverlay \[Rule] False\)\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p3, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", p3, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      RayTesselate \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", xx, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", WireFrame[Graphics3D[Cone[]]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\),  .5}, {\(-1\), 1}, {\(-1\), 2}}, 
      RayFovAngle \[Rule] 60]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Unevaluated[Graphics3D[Glow[ .9,  .2,  .2], Disk[{0, 0},  .5]]], 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] True, 
      RayPOV \[Rule] True, RayInformation \[Rule] {}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {p4, xx}, 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] 
        True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", {p4, xx}, RayView \[Rule] True, 
      RayFastLight \[Rule] True, RayTesselate \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Test  --  Sphere   replacement  fun -- not yet tested", "Subsubsection"],

Cell[BoxData[
    \(\(?Sphere\)\)], "Input"],

Cell[BoxData[
    \(Sphere[x___] := Print["\<sphere called\>"]\)], "Input"],

Cell[BoxData[
    \(Remove[Sphere]\)], "Input"],

Cell[BoxData[
    \(<< Graphics`\)], "Input"],

Cell["<<Graphics`Shapes`", "Input",
  CellTags->"S5.41.1"],

Cell[BoxData[
    \(Global`Sphere[vl_, r_:  1] := \((Print["\<dang\>"]; 
        Return[\(Unevaluated[Sphere]\)[vl, r]];)\)\)], "Input"],

Cell[BoxData[
    \(\(Graphics3D[Sphere[{0, 0, 0}, 1]]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(Global`Sphere[x___] := \((Print["\<sphere called\>"]; 
        Graphics`Shapes`Sphere[x])\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Sphere[{0, 0, 0},  .5], opts, 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Test    .m", "Subsubsection"],

Cell[BoxData[
    \(\(reset[];\)\)], "Input"],

Cell[BoxData[
    \(<< rayshade.m\)], "Input"],

Cell[BoxData[
    \(<< SurfaceGraphics3D.m\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Tube", "Subsubsection"],

Cell[BoxData[
    \(\(p6d = p6;\)\)], "Input"],

Cell[BoxData[
    \(\(p6e = p6;\)\)], "Input"],

Cell[BoxData[
    \(\(p6e[\([1, 0]\)] = Tube;\)\)], "Input"],

Cell[BoxData[
    \(\(p6d[\([1, 0]\)] = Tube;\)\)], "Input"],

Cell[BoxData[
    \(\(p6d[\([1]\)] = Append[p6d[\([1]\)],  .01];\)\)], "Input"],

Cell["\<\
OUCH.
\t? povray does this right rayshade does not ?
\t\tpovray fills / solid - that's differenet but not wrong
\t? or the other way around ?\
\>", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      p6d, \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      p6e, \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[\[IndentingNewLine]Tube[\[IndentingNewLine]{{0, 0, 
              0}, { .75,  .75,  .75}}\[IndentingNewLine]]], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[\[IndentingNewLine]Tube[\[IndentingNewLine]{{0, 0, 
              0}, { .15,  .15,  .15}},  .5\[IndentingNewLine]]], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[\[IndentingNewLine]Tube[\[IndentingNewLine]{\
\[IndentingNewLine]{{0, 0, 
                0}, { .5,  .5,  .5}}, \[IndentingNewLine]{{ .25,  .25,  .25}, \
{ .75,  .75,  .75}}\[IndentingNewLine]}\[IndentingNewLine]]], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[\[IndentingNewLine]Tube[\[IndentingNewLine]{\
\[IndentingNewLine]{{0, 0, 
                0}, { .5,  .5,  .5}}, \[IndentingNewLine]{{ .5,  .5,  .5}, { \
.75,  .5,  .75}}\[IndentingNewLine]}, { .15,  .25}\[IndentingNewLine]]], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      rGraphics[{CapForm["\<Butt\>"], \[IndentingNewLine]Tube[\
\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
                  0}, { .5,  .5,  .5}}, \[IndentingNewLine]{{ .5,  .5,  .5}, \
{ .75,  .5,  .75}}\[IndentingNewLine]}, { .15,  .25}\[IndentingNewLine]]}], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      rGraphics[{CapForm["\<Round\>"], \[IndentingNewLine]Tube[\
\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
                  0}, { .5,  .5,  .5}}, \[IndentingNewLine]{{ .5,  .5,  .5}, \
{ .75,  .5,  .75}}\[IndentingNewLine]}, { .15,  .25}\[IndentingNewLine]]}], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<cc.pov\>", p6d, RayView \[Rule] True, RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<cc.pov\>", p6e, RayView \[Rule] True, RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<cc.pov\>", 
      Graphics3D[\[IndentingNewLine]Tube[\[IndentingNewLine]{\
\[IndentingNewLine]{{0, 0, 
                0}, { .5,  .5,  .5}}, \[IndentingNewLine]{{ .25,  .25,  .25}, \
{ .75,  .75,  .75}}\[IndentingNewLine]}\[IndentingNewLine]]], 
      RayView \[Rule] True, RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test   Cuboid", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[{Cuboid[{0, 0, 0}], Cuboid[{0, 0, 1}], Cuboid[{0, 1, 1}], 
          Cuboid[{1, 1, 1}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics3D[Cuboid[]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics3D[Cuboid[{0, \(-1\), 0}]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell["doens't need to work {{}}", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics3D[Cuboid[{{0, \(-2\), 0}}]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[\[IndentingNewLine]Cuboid[\[IndentingNewLine]{\
\[IndentingNewLine]{{0, 0, 
                0}, { .5,  .5,  .5}}, \[IndentingNewLine]{{ .25,  .25,  .25}, \
{ .75,  .75,  .75}}\[IndentingNewLine]}\[IndentingNewLine]]], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<cc.pov\>", Graphics3D[Cuboid[{{0, 0, 0}}]], 
      RayView \[Rule] True, RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<cc.pov\>", 
      Graphics3D[\[IndentingNewLine]Cuboid[\[IndentingNewLine]{\
\[IndentingNewLine]{{0, 0, 
                0}, { .5,  .5,  .5}}, \[IndentingNewLine]{{ .25,  .25,  .25}, \
{ .75,  .75,  .75}}\[IndentingNewLine]}\[IndentingNewLine]]], 
      RayView \[Rule] True, RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Sphere", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rSphere[], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rSphere[{0, 0, 0}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rSphere[{0,  .5, 0},  .25], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell["NOTE:  OUT OF BOUNDS", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rSphere[{0, 1, 0},  .25], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell["NOTE: ONE OUT OF BOUNDS", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rSphere[{{0, 0, 0}, { .5,  .5,  .5}}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rSphere[{{0, 0, 0}, { .5,  .5,  .5}}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-2\), 2}, {\(-2\), 2}, {\(-2\), 2}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rSphere[{{0, 0, 0}, { .5,  .5,  .5}},  .15], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      rSphere[{{0, 0, 0}, { .5,  .5,  .5}}, { .15,  .25}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<cc.pov\>", rSphere[{{0, 0, 0}, { .5,  .5,  .5}},  .5], 
      RayView \[Rule] True, RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<cc.pov\>", {Unevaluated[Sphere[{0, 0, 0},  .5]]}, 
      RayView \[Rule] True, RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayInformation \[Rule] False]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  PlotRangeClipping", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \[IndentingNewLine]rGraphics[{\
\[IndentingNewLine]rCone[{{0, 0, 
                0}, {\(-1.75\), \(-2\), \(-1.5\)}}], \
\[IndentingNewLine]rCone[{{0, 0, 0}, {1.75, 2, 
                1.5}}]\[IndentingNewLine]}]\[IndentingNewLine], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      PlotRangeClipping \[Rule] False, 
      RayClipPlotRange \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \[IndentingNewLine]rGraphics[{rSphere[{{0, 
                0, 0}, {1.5, 1.5, 
                1.5}}]}], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      PlotRangeClipping \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics[{\[IndentingNewLine]rCone[{{0, 0, 
                0}, {\(-1.75\), \(-2\), \(-1.5\)}}], \
\[IndentingNewLine]rCone[{{0, 0, 0}, {1.75, 2, 
                1.5}}]\[IndentingNewLine]}]\[IndentingNewLine], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      PlotRangeClipping \[Rule] False, RayClipPlotRange \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \[IndentingNewLine]rGraphics[{rSphere[{{0, 0, 
                0}, {1.5, 1.5, 
                1.5}}]}], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      PlotRangeClipping \[Rule] False, RayPOV \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test Cone", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rCone[], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rCone[{{0, 0, 0}, { .75, 1,  .15}}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", rCone[{{0, 0, 0}, { .75, 1,  .15}}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCone[{{0, 0, 0}, { .75, 1,  .15}}]}]\[IndentingNewLine], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCone[{{0, 0, 0}, { .75, 1,  .15}}]}]\[IndentingNewLine], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Round\>"], 
          rCone[{{0, 0, 0}, { .75, 1,  .15}},  .25]}]\[IndentingNewLine], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Round\>"], 
          rCone[{{0, 0, 0}, { .75, 1,  .15}},  .35]}]\[IndentingNewLine], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rCone[{{0, 0, 0}, {1, 1, 1}}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rCone[{{0, 0, 0}, {1, 1, 1}},  .25], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      rCone[{{{0, 0, 0}, {1, \(- .5\), 1}}, {{0, 0, 0}, {1, 1, 1}}}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      rCone[{{{0, 0, 0}, {1, \(- .5\), 1}}, {{0, 0, 0}, {1, 1, 1}}},  .25], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      rCone[{{{0, 0, 0}, {1, \(- .5\), 1}}, {{0, 0, 0}, {1, 1, 
              1}}}, { .25,  .4}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayBoxLines \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Cylinder  w/  cap", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCylinder[]}], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayInformation \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCylinder[]}], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayInformation \[Rule] False, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCylinder[{{0, 0, 
                0}, { .25,  .25,  .25}}]}], \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCylinder[{{0, 0, 
                0}, { .25,  .25,  .25}}]}], \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Round\>"], 
          rCylinder[]}], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayInformation \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Round\>"], 
          rCylinder[]}], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayInformation \[Rule] False, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Round\>"], 
          rCylinder[{{0, 0, 
                0}, { .5,  .5,  .5}}]}], \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Round\>"], 
          rCylinder[{{0, 0, 
                0}, { .5,  .5,  .5}}]}], \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCylinder[{{0, 0, 
                0}, { .25,  .25,  .25}},  .5]}], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCylinder[\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
                  0}, { .25,  .25,  .25}}, \[IndentingNewLine]{{\(- .25\), \
\(- .25\), \(- .25\)}, {\(- .5\), \(- .5\), \(- .5\)}}, \[IndentingNewLine]{{ \
.5,  .5,  .5}, { .75,  .75,  .75}}\[IndentingNewLine]}, { .5,  .25,  .75}\
\[IndentingNewLine]]}], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Round\>"], 
          rCylinder[\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
                  0}, { .25,  .25,  .25}}, \[IndentingNewLine]{{\(- .25\), \
\(- .25\), \(- .25\)}, {\(- .5\), \(- .5\), \(- .5\)}}, \[IndentingNewLine]{{ \
.5,  .5,  .5}, { .75,  .75,  .75}}\[IndentingNewLine]}, { .5,  .25,  .75}\
\[IndentingNewLine]]}], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          rCylinder[\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
                  0}, { .25,  .25,  .25}}, \[IndentingNewLine]{{\(- .25\), \
\(- .25\), \(- .25\)}, {\(- .5\), \(- .5\), \(- .5\)}}, \[IndentingNewLine]{{ \
.5,  .5,  .5}, { .75,  .75,  .75}}\[IndentingNewLine]}\[IndentingNewLine]]}], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics[{CapForm["\<Butt\>"], 
          Cylinder[\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
                  0}, { .25,  .25,  .25}}, \[IndentingNewLine]{{\(- .25\), \
\(- .25\), \(- .25\)}, {\(- .5\), \(- .5\), \(- .5\)}}, \[IndentingNewLine]{{ \
.5,  .5,  .5}, { .75,  .75,  .75}}\[IndentingNewLine]}, { .5,  .25,  .75}]\
\[IndentingNewLine]}], \[IndentingNewLine]RayView \[Rule] True, 
      RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Cylinder", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \[IndentingNewLine]rCylinder[], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \[IndentingNewLine]rCylinder[{{0, 0, 
            0}, { .25,  .25,  .25}}], \[IndentingNewLine]RayPreView \[Rule] 
        True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \[IndentingNewLine]rCylinder[{{0, 0, 
            0}, { .25,  .25,  .25}},  .5], \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \[IndentingNewLine]rCylinder[\
\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
              0}, { .25,  .25,  .25}}, \[IndentingNewLine]{{\(- .25\), \(- \
.25\), \(- .25\)}, {\(- .5\), \(- .5\), \(- .5\)}}, \[IndentingNewLine]{{ .5, \
 .5,  .5}, { .75,  .75,  .75}}\[IndentingNewLine]}, { .5,  .25,  .75}\
\[IndentingNewLine]], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \[IndentingNewLine]rCylinder[\
\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
              0}, { .25,  .25,  .25}}, \[IndentingNewLine]{{\(- .25\), \(- \
.25\), \(- .25\)}, {\(- .5\), \(- .5\), \(- .5\)}}, \[IndentingNewLine]{{ .5, \
 .5,  .5}, { .75,  .75,  .75}}\[IndentingNewLine]}\[IndentingNewLine]], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \[IndentingNewLine]rGraphics3D[
        Cylinder[\[IndentingNewLine]{\[IndentingNewLine]{{0, 0, 
                0}, { .25,  .25,  .25}}, \[IndentingNewLine]{{\(- .25\), \(- \
.25\), \(- .25\)}, {\(- .5\), \(- .5\), \(- .5\)}}, \[IndentingNewLine]{{ .5, \
 .5,  .5}, { .75,  .75,  .75}}\[IndentingNewLine]}, { .5,  .25,  .75}\
\[IndentingNewLine]]], RayView \[Rule] True, RayPOV \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayInformation \[Rule] False]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["tests  plot2d  and  unk test", "Subsubsection"],

Cell[BoxData[
    \(xx = Plot[x^2, {x, \(-200\), 200}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", xx, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", {Point[{0, 0, 0}]}, opts, 
      RayPreView \[Rule] True, RayFovAngle \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", xx, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {p3, xx}, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p3, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", xxx, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(xx = Plot[x^2, {x, \(-200\), 200}]\)], "Input"],

Cell[BoxData[
    \(xxx = Plot[x^3, {x, \(-200\), 200}]\)], "Input"],

Cell[BoxData[
    \(RayAspect \[Rule] True, RayFovAngle \[Rule] 65, 
    RayLineWidth \[Rule] 5\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<cc.pov\>", %, RayPreView \[Rule] True, RayPOV \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<xxx.ray\>", g3, RayView \[Rule] True, 
      ViewPoint \[Rule] {1.3`, \(-2.4`\), 2.`}\ 3]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<xxx.ray\>", g3, RayView \[Rule] True, 
      RayGrey \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<xxx.ray\>", g3, RayView \[Rule] True, 
      ViewPoint \[Rule] {0, \(-12\), 0}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<xxx.ray\>", g3, RayView \[Rule] True, 
      ViewPoint \[Rule] {\(-3.1\), \(-12\), 1.4}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<xxx.ray\>", g3, RayView \[Rule] True, 
      ViewPoint \[Rule] {\(-3.1\), \(-12\), 1.4}, 
      ViewCenter \[Rule] \[InvisibleSpace]{\(-3.1\), 0, 1.4}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p8, RayPreView \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<x.orig.ray\>", p4, RayPreView \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<x.orig.ray\>", p4, RayGlass \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p8, opts, RayGlass \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p4, opts, RayView \[Rule] True, 
      RayGlass \[Rule] True, RayShow \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", p9, opts, RayPreView \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p3, RayPreView \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p4, RayPreView \[Rule] True, 
      RayTesselate \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p9, opts, RayPreView \[Rule] True, 
      RayGlass \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p4, opts, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p6, opts, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 25]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p7, opts, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p8, opts, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 40, RayGlass \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Opacity   and  AbsoluteThickness", "Subsubsection"],

Cell[BoxData[
    \(\(reset[];\)\)], "Input"],

Cell[BoxData[
    \(<< rayshade.m\)], "Input"],

Cell[BoxData[
    \(\(p8b = p8;\)\)], "Input"],

Cell[BoxData[
    \(\(p8b[\([1]\)] = Insert[p8b[\([1]\)], Opacity[ .5], 213];\)\)], "Input"],

Cell[BoxData[
    \(\(Take[p8b[\([1]\)], {210, 220}];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p8b, RayFastLight \[Rule] True, 
      RayPreView \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", p8b, RayView \[Rule] True, RayPOV \[Rule] True, 
      RayTesselate \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p8b, opts, RayFastLight \[Rule] True, 
      RayPreView \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(p6c = {Line[{{0.18592604767165588`, 0.291185352818269`, 
                0.038262169877488754`}, {0.2824087638357882`, 
                0.19759712890951997`, 
                0.6780067307909183`}, {0.15319419226575032`, 
                0.12676011845416174`, 
                0.21608040489829075`}, {0.27233939505489807`, 
                0.5657218168626842`, 
                0.8153878188241248`}, {0.31113551302258613`, 
                0.45454925842811766`, 
                0.20283066713650097`}, {0.378320795727515`, 
                0.0949085645079499`, 
                0.7954532108676676`}, {0.6579269048292299`, 
                0.309391678151107`, 
                0.6084958813812197`}, {0.3422273783786798`, 
                0.4087237289969996`, 
                0.1365459069521073`}, {0.42256983370956375`, 
                0.05104202556041076`, 
                0.37046155911951084`}, {0.854137143116319`, 
                0.22497270480004378`, 
                0.3730352947694924`}, {0.21726736685376052`, 
                0.7273770246621573`, 0.008892299901753017`}}], 
          Line[{{0.1006958997145943`, 0.6515455499910764`, 
                0.9119892058380324`}, {0.6977567868791669`, 
                0.6461466412864766`, 
                0.4487148828545754`}, {0.5336684101105176`, 
                0.602848222371217`, 
                0.850693430418809`}, {0.7907879780253455`, 
                0.22427673195941053`, 
                0.9943523409899974`}, {0.5084660520401292`, 
                0.3820642490283459`, 
                0.08773082500730323`}, {0.5717825072804337`, 
                0.4574240264797184`, 
                0.011602689908835027`}, {0.23359368189098417`, 
                0.34680980248038984`, 
                0.08438873171022605`}, {0.7943353230550745`, 
                0.5062166572288269`, 
                0.33791750257863684`}, {0.9836928319956317`, 
                0.14278977306399812`, 
                0.5942274513907944`}, {0.64016071569947`, 
                0.3375461907091551`, 
                0.6940748902094227`}, {0.06055904128027686`, 
                0.03731249332825293`, 
                0.48685276029034613`}, {0.9032869121840772`, 
                0.8362823093208663`, 
                0.04296015233825556`}, {0.978386708250217`, 
                0.5212226631557313`, 0.7485514843135631`}}]};\)\)], "Input"],

Cell[BoxData[
    \(\(p6b = {Line[{{0.18592604767165588`, 0.291185352818269`, 
                0.038262169877488754`}, {0.2824087638357882`, 
                0.19759712890951997`, 
                0.6780067307909183`}, {0.15319419226575032`, 
                0.12676011845416174`, 
                0.21608040489829075`}, {0.27233939505489807`, 
                0.5657218168626842`, 
                0.8153878188241248`}, {0.31113551302258613`, 
                0.45454925842811766`, 
                0.20283066713650097`}, {0.378320795727515`, 
                0.0949085645079499`, 
                0.7954532108676676`}, {0.6579269048292299`, 
                0.309391678151107`, 
                0.6084958813812197`}, {0.3422273783786798`, 
                0.4087237289969996`, 
                0.1365459069521073`}, {0.42256983370956375`, 
                0.05104202556041076`, 
                0.37046155911951084`}, {0.854137143116319`, 
                0.22497270480004378`, 
                0.3730352947694924`}, {0.21726736685376052`, 
                0.7273770246621573`, 0.008892299901753017`}}], 
          AbsoluteThickness[1], 
          Line[{{0.1006958997145943`, 0.6515455499910764`, 
                0.9119892058380324`}, {0.6977567868791669`, 
                0.6461466412864766`, 
                0.4487148828545754`}, {0.5336684101105176`, 
                0.602848222371217`, 
                0.850693430418809`}, {0.7907879780253455`, 
                0.22427673195941053`, 
                0.9943523409899974`}, {0.5084660520401292`, 
                0.3820642490283459`, 
                0.08773082500730323`}, {0.5717825072804337`, 
                0.4574240264797184`, 
                0.011602689908835027`}, {0.23359368189098417`, 
                0.34680980248038984`, 
                0.08438873171022605`}, {0.7943353230550745`, 
                0.5062166572288269`, 
                0.33791750257863684`}, {0.9836928319956317`, 
                0.14278977306399812`, 
                0.5942274513907944`}, {0.64016071569947`, 
                0.3375461907091551`, 
                0.6940748902094227`}, {0.06055904128027686`, 
                0.03731249332825293`, 
                0.48685276029034613`}, {0.9032869121840772`, 
                0.8362823093208663`, 
                0.04296015233825556`}, {0.978386708250217`, 
                0.5212226631557313`, 0.7485514843135631`}}]};\)\)], "Input"],

Cell[BoxData[
    \(\(p6b = Graphics3D[p6b];\)\)], "Input"],

Cell[BoxData[
    \(\(p6c = Graphics3D[p6c];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p6b, opts, RayFastLight \[Rule] True, 
      RayPreView \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p6c, opts, RayFastLight \[Rule] True, 
      RayPreView \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Text", "Subsubsection"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<hi   \!\(there\^2\)   adsf   asdf hi \
  there   asdf  asdf hi   \!\(there\_2\)   \!\(\@asdf\)   asdf\>\""\
\[IndentingNewLine], {0, 0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[StyleForm[\[IndentingNewLine]\*"\"\<hi   \!\(there\^2\)   adsf \
  asdf hi   there   asdf  asdf hi   \!\(there\_2\)   \!\(\@asdf\)   \
asdf\>\"", FontSize \[Rule] 24]\[IndentingNewLine], {0, 0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)\\n    \!\(bob\_2\)\\ntwo\
\>\""\[IndentingNewLine], {0, 0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)  asdf asdf\\n  \
\!\(bob\_2\) asdf asdf\\ntwo asdf asdf\\nasdf asdf\\nasdf asdf\>\""\
\[IndentingNewLine], {0, 0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<hi   \!\(there\^2\)   adsf   asdf hi \
  there   asdf  asdf hi   \!\(there\_2\)   \!\(\@asdf\)   asdf\>\""\
\[IndentingNewLine], {0, 0, 0}, {\(-1\), 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<hi   \!\(there\^2\)   adsf   asdf hi \
  there   asdf  asdf hi   \!\(there\_2\)   \!\(\@asdf\)   asdf\>\""\
\[IndentingNewLine], {0, 0, 0}, {0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)\\n    \!\(bob\_2\)\\ntwo\
\>\""\[IndentingNewLine], {0, 0, 0}, {\(-1\), 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)  asdf asdf\\n  \
\!\(bob\_2\) asdf asdf\\ntwo asdf asdf\\nasdf asdf\\nasdf asdf\>\""\
\[IndentingNewLine], {0, 0, 0}, {\(-1\), 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)  asdf asdf\\n  \
\!\(bob\_2\) asdf asdf\\ntwo asdf asdf\\nasdf asdf\\nasdf asdf\>\""\
\[IndentingNewLine], {0, 0, 0}, {0, \(-1\)}]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)  asdf asdf\\n  \
\!\(bob\_2\) asdf asdf\\ntwo asdf asdf\\nasdf asdf\\nasdf asdf\>\""\
\[IndentingNewLine], {0, 0, 0}, {0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", xx, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {xx, p4}, opts, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {p4, xx}, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {p3, xx}, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-5.`\), 5.`}, {\(-2.`\), 
            2.`}, {\(-7.72288150320727`\), 7.72288150320727`}}]\)], "Input"],

Cell[BoxData[
    \(Show[{xx, p4}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", xx, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Raster", "Subsubsection"],

Cell[BoxData[
    \(\(x900 = 
        Graphics[
          Raster[N[
              Table[1\/9\ Mod[i, j], {i, 900}, {j, 900}]]]];\)\)], "Input"],

Cell[BoxData[
    \(\(x500 = 
        Graphics[
          Raster[N[
              Table[1\/9\ Mod[i, j], {i, 500}, {j, 500}]]]];\)\)], "Input"],

Cell[BoxData[
    \(\(x250 = 
        Graphics[
          Raster[N[
              Table[1\/9\ Mod[i, j], {i, 250}, {j, 250}]]]];\)\)], "Input"],

Cell[BoxData[
    \(\(x100 = 
        Graphics[
          Raster[N[
              Table[1\/9\ Mod[i, j], {i, 100}, {j, 100}]]]];\)\)], "Input"],

Cell[BoxData[
    \(\(x50 = 
        Graphics[
          Raster[N[Table[1\/9\ Mod[i, j], {i, 50}, {j, 50}]]]];\)\)], "Input"],

Cell[BoxData[
    \(\(x25 = 
        Graphics[
          Raster[N[Table[1\/9\ Mod[i, j], {i, 25}, {j, 25}]]]];\)\)], "Input"],

Cell[BoxData[
    \(\(x10 = 
        Graphics[
          Raster[N[Table[1\/9\ Mod[i, j], {i, 10}, {j, 10}]]]];\)\)], "Input"],

Cell[BoxData[
    \(Table[i, {i, 0, 255}, {j, 0, 255}]\)], "Input"],

Cell[BoxData[
    \(\(x10 = 
        Graphics[
          Raster[N[Table[i/255, {i, 0, 255}, {j, 0, 255}]]]];\)\)], "Input"],

Cell[BoxData[
    \(x10[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(x10 // Show\)], "Input"],

Cell[BoxData[
    \(\(x5 = 
        Graphics[
          Raster[N[Table[1\/9\ Mod[i, j], {i, 5}, {j, 5}]]]];\)\)], "Input"],

Cell[BoxData[
    \(\(xc10 = 
        Graphics[
          RasterArray[
            Table[Hue[ .1  Mod[i, j]], {i, 2, 10}, {j, 2, 
                10}]]];\)\)], "Input",
  CellTags->"RasterArray"],

Cell["see if under squash text is un-squashed", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {p3, xx}, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics[
          Raster[N[Table[1\/9\ Mod[i, j], {i, 10}, {j, 10}]]]];\)\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics[
          RasterArray[
            Table[Hue[ .1  Mod[i, j]], {i, 2, 10}, {j, 2, 
                10}]]];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", xc10, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 40, ViewPoint \[Rule] {0, \(-4\), 0}]\)], "Input"],

Cell[BoxData[
    \(xc10 //. RasterArray \[Rule] rRasterArrayClear\)], "Input"],

Cell[BoxData[
    \(x10 //. Raster \[Rule] rRasterClear\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", %, RayPreView \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", %, RayPreView \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", x10, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 40, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", xx, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(\(Display["\</tmp/x.tiff\>" <> "\<.tiff\>", 
        Cell[Text["\<hi bob\>", "\<Text\>"], 
          FontFamily \[Rule] "\<Courier\>"], "\<TIFF\>", 
        ImageResolution \[Rule] 512];\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["tests  Animation  and  other", "Subsubsection"],

Cell[BoxData[
    \( (*\ note\ this\ overrides\ so\ this\ is\ zoom\ out\ *) \)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p4, opts, RayPreView \[Rule] True, 
      ViewPoint \[Rule] {5, 10, 3}, RayFovAngle \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p4, opts, RayPreView \[Rule] True, 
      ViewPoint \[Rule] {10, 20, 6}, RayFovAngle \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \( (*\ OLD\ TEST\ note\ in\ plot\ this\ is\ rear\ right\ *) \)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p6, opts, RayPreView \[Rule] True, 
      ViewCenter \[Rule] { .5,  .5,  .5}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<y.orig.ray\>", p5, opts, RayPreView \[Rule] True, 
      RayFovAngle \[Rule] 40]\)], "Input"],

Cell[BoxData[
    \(<< Miscellaneous`WorldPlot`\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics[\(WorldPlot[Africa]\)[\([1]\)] /. 
            Thickness[x__] \[Rule] Thickness[ .1]];\)\)], "Input"],

Cell[BoxData[
    \(xx[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(Rayshade["\<r.orig.ray\>", xx, RayPreView \[Rule] True];\)\)], "Input"],

Cell[BoxData[
    \(qq = 
      Table[Rayshade["\<r.orig.ray\>", p4, opts, RayPreView \[Rule] True, 
          RayShow \[Rule] True, 
          ViewPoint -> {1 + \((inc\  .05)\), \(-2.4`\), 2.`}], {inc, 3, 
          10}]\)], "Input"],

Cell[BoxData[
    \(ShowAnimation[qq]\)], "Input"],

Cell[BoxData[
    \(\(qq =. ;\)\)], "Input"],

Cell["malformed graphic lists with non-existant function names", "Text"],

Cell[BoxData[
    \(\({{Graphics3D[{{Line[{0, 0}], 
                0, {{0, 0}, Line[{{0, 0}, {\(- .5\), \(- .5\)}}]}}, 
              Null}]}};\)\)], "Input"],

Cell[BoxData[
    \({{{{Line2[{0, 0}], 0, {{0, 0}, Line2[{{0, 0}, { .5,  .5}}]}}, 
          Null}}}\)], "Input"],

Cell[BoxData[
    \(Unevaluated[{{{{Line2[{0, 0}], 
              0, {{0, 0}, Line2[{{0, 0}, { .5,  .5}}]}}, Null}}}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test   Point w/  Color", "Subsubsection"],

Cell[BoxData[
    \(Show[Graphics3D[{RGBColor[0, 1, 0], Point[{0, 0, 0}]}]]\)], "Input"],

Cell[BoxData[
    \(%[\([1]\)]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test   SurfaceGraphics3D", "Subsubsection"],

Cell[BoxData[
    \(\(Close["\<r.orig.ray\>"];\)\)], "Input"],

Cell[BoxData[
    \(Scan[Unprotect, Names["\<SurfaceGraphics3D`*\>"]]\)], "Input"],

Cell[BoxData[
    \(Scan[Remove, Names["\<SurfaceGraphics3D`*\>"]]\)], "Input"],

Cell[BoxData[
    \(\(Unprotect@$Packages;\)\)], "Input"],

Cell[BoxData[
    \(\($Packages = 
        Select[$Packages, \((Not@
                StringMatchQ[#, "\<SurfaceGraphics3D`\>"])\) &];\)\)], "Input"],

Cell[BoxData[
    \(\($Packages = 
        Select[$Packages, \((Not@
                StringMatchQ[#, "\<rayshade`\>"])\) &];\)\)], "Input"],

Cell[BoxData[
    \(\($Packages = 
        Select[$Packages, \((Not@
                StringMatchQ[#, "\<rayshade`SurfaceGraphics3D`\>"])\) \
&];\)\)], "Input"],

Cell[BoxData[
    \(\(Protect@$Packages;\)\)], "Input"],

Cell[BoxData[
    \(\(reset[];\)\)], "Input"],

Cell[BoxData[
    \(\(?rayshade`*\)\)], "Input"],

Cell[BoxData[
    \(\(?SurfaceGraphics3D`*\)\)], "Input"],

Cell[BoxData[
    \(<< "\</home/jdh/math/Mathematica/MathSource/tmp/tmp/SurfaceGraphics3D.m\
\>"\)], "Input"],

Cell[BoxData[
    \(<< rayshade.m\)], "Input"],

Cell[BoxData[
    \( (*\ << SurfaceGraphics3D . m\ *) \)], "Input"],

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell[BoxData[
    \(Remove[rayshade`Private`SurfaceGraphics3D]\)], "Input"],

Cell[BoxData[
    \(\(?rayshade`Private`SurfaceGraphics3D`*\)\)], "Input"],

Cell[BoxData[
    \(\(p5 = 
        Module[{u, t}, 
          ParametricPlot3DtoSurfaceGraphics[{u\ Sin[t], u\ Cos[t], t/3}, {t, 
              0, 15}, {u, \(-1\), 1}]];\)\)], "Input"],

Cell[BoxData[
    \(\(p5b = {\(,\)\({}\)};\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(p5b[\([0]\)] = p5[\([0]\)]\) \)\(;\)\(\(p5b[\([1]\)] = 
        p5[\([1]\)]\) \)\(;\)\( (*\ \(p5b[\([2]\)] = 
          p5[\([2]\)];\)\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(p5a = 
        Module[{u, t}, 
          ParametricPlot3D[{u\ Sin[t], u\ Cos[t], t/3}, {t, 0, 
              15}, {u, \(-1\), 1}]];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p3, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Graphics3D[
      SurfaceGraphics3D[p5b[\([1]\)], p5b[\([2]\)], {}]]\)], "Input"],

Cell[BoxData[
    \(\(p5b = {\(,\)\({}\)};\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(p5b[\([0]\)] = p5[\([0]\)]\) \)\(;\)\(\(p5b[\([1]\)] = 
        p5[\([1]\)]\) \)\(;\)\( (*\ \(p5b[\([2]\)] = 
          p5[\([2]\)];\)\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p5b, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p5, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(rayshade`Private`pr\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p5a, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", p5, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(p5b[\([2]\)] = FullOptions[p5a];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", p5b, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      RayTesselate \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(rayshade`Private`pr\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", p5a, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      RayTesselate \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(AbsoluteOptions[p5];\)\)], "Input"],

Cell[BoxData[
    \(rayshade`Private`pr\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  FullGraphics", "Subsubsection"],

Cell[BoxData[
    \(\(Show[
        Graphics[{Circle[{0, 0}, 1]}, AspectRatio \[Rule] Automatic, 
          Axes \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Circle"],

Cell[BoxData[
    \(\(g10 = FullGraphics[%];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", g10, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayGrey \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", g10, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayGrey \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell["ListPlot[ Table[EulerPhi[n], {n, 10}] ];", "Input",
  CellTags->"S2.9.1"],

Cell[BoxData[
    \(\(g10 = FullGraphics[%];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", g10, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayGrey \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
test  fullopts   if  p4  ,  { xx , p4 }  , { g3 , xx }  get \
fullopts \
\>", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", g3, 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] 
        True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p4, 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] 
        True]\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)  asdf asdf\\n  \
\!\(bob\_2\) asdf asdf\\ntwo asdf asdf\\nasdf asdf\\nasdf asdf\>\""\
\[IndentingNewLine], {0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(\(g5 = Show[{g3, xx}];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", g5, 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] 
        True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {g3, xx}, 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] 
        True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {xx, p4}, 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] 
        True]\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)  asdf asdf\\n  \
\!\(bob\_2\) asdf asdf\\ntwo asdf asdf\\nasdf asdf\\nasdf asdf\>\""\
\[IndentingNewLine], {0, 0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {xx, p4}, 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] 
        True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  RayBoxLines  etc Glow    and Lines test", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics3D[Circle[{0, 0},  .5]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayInformation \[Rule] {}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics3D[Circle[{0, 0},  .5]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayInformation \[Rule] {}, RayBoxLines \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics3D[Circle[{0, 0},  .5]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayInformation \[Rule] {}, RayTubeLines \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", p6, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayBoxLines \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Unevaluated[Graphics3D[Glow[ .9,  .2,  .2], Disk[{0, 0},  .5]]], 
      RayPreView \[Rule] True, \[IndentingNewLine]RayFastLight \[Rule] True, 
      RayPOV \[Rule] True, RayInformation \[Rule] {}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \[IndentingNewLine]{\[IndentingNewLine]WireFrame[
          Graphics3D[Cone[]]], \[IndentingNewLine]WireFrame[
          Graphics3D[
            Torus[]]]\[IndentingNewLine]}, \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      ViewPoint \[Rule] {1.20, \(-2.2\), 1.845}  .5]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]{\[IndentingNewLine]WireFrame[
          Graphics3D[Cone[]]], \[IndentingNewLine]WireFrame[
          Graphics3D[
            Torus[]]]\[IndentingNewLine]}, \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \[IndentingNewLine]{\[IndentingNewLine]WireFrame[
          Graphics3D[Cone[]]], \[IndentingNewLine]WireFrame[
          Graphics3D[
            Torus[]]]\[IndentingNewLine]}, \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      ViewPoint \[Rule] {1.20, \(-2.2\), 1.845}  .5]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]{\[IndentingNewLine]WireFrame[
          Graphics3D[Cone[]]], \[IndentingNewLine]WireFrame[
          Graphics3D[
            Torus[]]]\[IndentingNewLine]}, \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, RayBoxLines \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \[IndentingNewLine]{\[IndentingNewLine]WireFrame[
          Graphics3D[Cone[]]], \[IndentingNewLine]WireFrame[
          Graphics3D[
            Torus[]]]\[IndentingNewLine]}, \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, RayBoxLines \[Rule] True, 
      RayPOV \[Rule] True, 
      ViewPoint \[Rule] {1.20, \(-2.2\), 1.845}  .35]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \
\[IndentingNewLine]{\[IndentingNewLine]WireFrame[
          Graphics3D[Cone[]]], \[IndentingNewLine]WireFrame[
          Graphics3D[
            Torus[]]]\[IndentingNewLine]}, \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, 
      RayTubeLines \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(rayshade`Private`vp\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \[IndentingNewLine]{\[IndentingNewLine]WireFrame[
          Graphics3D[Cone[]]], \[IndentingNewLine]WireFrame[
          Graphics3D[
            Torus[]]]\[IndentingNewLine]}, \[IndentingNewLine]RayPreView \
\[Rule] True, RayFastLight \[Rule] True, RayTubeLines \[Rule] True, 
      RayPOV \[Rule] True, 
      ViewPoint \[Rule] {1.20, \(-2.2\), 1.845}  .25]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Circle  Disk", "Subsubsection"],

Cell[BoxData[
    \(\(reset[];\)\)], "Input"],

Cell[BoxData[
    \(<< rayshade.m\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{RGBColor[0, 0, 1], Unevaluated[Disk[]]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-4\), 4}, {0, 0}, {\(-4\), 4}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{RGBColor[0, 0, 1], Unevaluated[Disk[{0, 0}]]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-4\), 4}, {0, 0}, {\(-4\), 4}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{RGBColor[0, 0, 1], Unevaluated[Disk[{0, 0}]]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-4\), 4}, {0, 0}, {\(-4\), 4}}, 
      RayOverlay \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{RGBColor[0, 0, 1], Unevaluated[Disk[{0, 0}]]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-4\), 4}, {\(-1\), 1}, {\(-4\), 4}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Disk[{0, 0}, 1], Disk[{0, 0}, {2, 1}], 
          Disk[{0, 0}, 2, {0, 1}]}, AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] False, 
      PlotRange \[Rule] {{\(-4\), 4}, {0, 0}, {\(-4\), 4}}, 
      ViewPoint \[Rule] {0, \(-15\), 0}, RayOverlay \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{{RGBColor[0, 0, 1], {RGBColor[0, 1, 1], Disk[{0, 0}, 1]}, 
            Disk[{0, 0}, {2, 1}]}, {RGBColor[1, 1, 0], 
            Disk[{0, 0}, 2, {0, 1}]}}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{{RGBColor[0, 0, 1], {RGBColor[0, 1, 1], Disk[{0, 0}, 1]}, 
            Disk[{0, 0}, {2, 1}]}, {RGBColor[1, 1, 0], 
            Disk[{0, 0}, 2, {0, 1}]}}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{{RGBColor[0, 0, 1], {RGBColor[0, 1, 1], Disk[{0, 0}, 1]}, 
            Disk[{0, 0}, {2, 1}]}, {RGBColor[1, 1, 0], 
            Disk[{0, 0}, 2, {0, 1}]}}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{{RGBColor[0, 0, 1], {RGBColor[0, 1, 1], Disk[{0, 0}, 1]}, 
            Disk[{0, 0}, {2, 1}]}, {RGBColor[1, 1, 0], 
            Disk[{0, 0}, 2, {0, 1}]}}, AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {2, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}, AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] True, 
      ViewPoint \[Rule] {0, \(-15\), 0}, 
      PlotRange \[Rule] {{\(-1\), 1}, {0, 0}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {2, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}, AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] False, 
      PlotRange \[Rule] {{\(-1.5\), 1.5}, {0, 0}, {\(-1.5\), 1.5}}, 
      ViewPoint \[Rule] {0, \(-15\), 0}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {2, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}, AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] False, 
      PlotRange \[Rule] {{\(-1\), 1}, {0, 0}, {\(-1\), 1}}, 
      ViewPoint \[Rule] {0, \(-15\), 0}]\)], "Input"],

Cell[BoxData[
    \(rayshade`Private`pr~Drop~{2, 2}\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {2, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}, AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] False, 
      PlotRange \[Rule] {{\(-2\), 2}, {0, 0}, {\(-2\), 2}}, 
      ViewPoint \[Rule] {0, \(-15\), 0}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {2, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}, AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] False, 
      PlotRange \[Rule] {{\(-4\), 4}, {0, 0}, {\(-4\), 4}}, 
      ViewPoint \[Rule] {0, \(-15\), 0}]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {2, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}, AspectRatio \[Rule] Automatic, 
        Axes \[Rule] Automatic], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {2, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{Disk[{0, 0}, 1], Disk[{0, 0}, {3, 1}], 
          Disk[{0, 0}, 2, {0, 1}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayBoxLines \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{Disk[{0, 0}, 1], Disk[{0, 0}, {3, 1}], 
          Disk[{0, 0}, 2, {0, 1}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayBoxLines \[Rule] True, 
      RayPOV \[Rule] True, RayCsg \[Rule] False]\)], "Input"],

Cell[BoxData[
    \( (*\ \(RayBoxLines \[Rule] True\)\(,\)\ *) \)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {3, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      RayCsg \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Circle[{0, 0}, 1], Circle[{0, 0}, {3, 1}], 
          Circle[{0, 0}, 2, {0, 1}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayBoxLines \[Rule] False, 
      RayCsg \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics3D[Circle[{0, 0},  .5]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayInformation \[Rule] {}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Rectangle  and disable re-enable pointInPlotrange", \
"Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", Graphics[Rectangle[]], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics[Rectangle[]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics[Rectangle[{0, 0}]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", Graphics[Rectangle[{0, 0}, {1, 3}]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{Hue[ .77], Rectangle[{1, 1.5}], Rectangle[{0, 0}, {5, 1}], 
          Hue[ .17], Rectangle[{3, 0}, {4, 2}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{RGBColor[ .7,  .2,  .5], Rectangle[{0, 0}, {5, 1}], 
          RGBColor[ .9,  .9,  .1], Rectangle[{3, 0}, {4, 2}]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{RGBColor[ .7,  .2,  .5], Rectangle[{0, 0}, {5, 1}], 
          RGBColor[ .9,  .9,  .1], Rectangle[{3, 0}, {4, 2}]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(\(,\)\(PlotRangeClipping \[Rule] False\)\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[\[IndentingNewLine]Rectangle[\[IndentingNewLine]{0, 0}, {2, 
            3}, Graphics[
            Line[Table[{Random[], 
                  Random[]}, {24}]]]\[IndentingNewLine]]\[IndentingNewLine]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRangeClipping \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[\[IndentingNewLine]Rectangle[\[IndentingNewLine]{0, 0}, {2, 
            3}, Graphics[
            Line[Table[{Random[], 
                  Random[]}, {24}]]]\[IndentingNewLine]]\[IndentingNewLine]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Close["\<r.orig.ray\>"]\)], "Input"],

Cell[BoxData[
    \(\(({ .5,  .5} + {2, 3})\)/2\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{\[IndentingNewLine]Rectangle[{0, 0}, { .5, 
              3}], \[IndentingNewLine]Rectangle[{0, 
              0}, {2,  .5}], \[IndentingNewLine]Rectangle[{0, 0}, {4, 7}, 
            Graphics[{}]], \[IndentingNewLine]Rectangle[{ .5,  .5}, {2, 3}, 
            Graphics[
              Line[Table[{7\ Random[], 
                    7\ Random[]}, {500}]]]]\[IndentingNewLine]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{\[IndentingNewLine]Rectangle[{0, 0}, { .5, 
              3}], \[IndentingNewLine]Rectangle[{0, 
              0}, {2,  .5}], \[IndentingNewLine]Rectangle[{0, 0}, {4, 7}, 
            Graphics[{}]], \[IndentingNewLine]Rectangle[{ .5,  .5}, {2, 3}, 
            Graphics[
              Line[Table[{\(-7\)\ Random[], 
                    7\ Random[]}, {500}]]]]\[IndentingNewLine]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell["\<\
NOTE: effort to create gr around 0 so it's also centered in \
rect\
\>", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{\[IndentingNewLine]Rectangle[{0, 0}, { .5, 
              3}], \[IndentingNewLine]Rectangle[{0, 
              0}, {2,  .5}], \[IndentingNewLine]Rectangle[{0, 0}, {4, 7}, 
            Graphics[{}]], \[IndentingNewLine]Rectangle[{ .5,  .5}, {2, 3}, 
            Graphics[
              Line[Table[{7\ Random[] \((\(-1\) + 2  Random[Integer])\), 
                    7\ Random[] \((\(-1\) + 
                          2  Random[
                              Integer])\)}, {500}]]]]\[IndentingNewLine]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True]\)], "Input"],

Cell["\<\
NOTE: effort to create gr around 0 so it's also centered in \
rect\
\>", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{\[IndentingNewLine]Rectangle[{0, 0}, { .5, 
              3}], \[IndentingNewLine]Rectangle[{0, 
              0}, {2,  .5}], \[IndentingNewLine]Rectangle[{0, 0}, {4, 7}, 
            Graphics[{}]], \[IndentingNewLine]Rectangle[{ .5,  .5}, {2, 3}, 
            Graphics[Circle[{0, 0},  .25]]]\[IndentingNewLine]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayClipPlotRange \[Rule] False, 
      PlotRangeClipping \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Rectangle[\[IndentingNewLine]{0, 0}, {1, 
              1}], \[IndentingNewLine]Rectangle[\[IndentingNewLine]{0, 
              0}, {2, 3}, 
            Graphics[
              Line[Table[{5\ Random[], 
                    5\ Random[]}, {1000}]]]\[IndentingNewLine]]}\
\[IndentingNewLine]], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{Rectangle[\[IndentingNewLine]{0, 0}, {1, 
              1}], \[IndentingNewLine]Rectangle[\[IndentingNewLine]{0, 
              0}, {2, 3}, 
            Graphics[
              Line[Table[{5\ Random[], 
                    5\ Random[]}, {1000}]]]\[IndentingNewLine]]}\
\[IndentingNewLine]], RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[{Rectangle[\[IndentingNewLine]{0, 
              0}, { .25,  .5}], \[IndentingNewLine]Rectangle[\
\[IndentingNewLine]{0, 0}, {2, 3}, 
            Graphics[
              Line[Table[{Random[], 
                    Random[]}, \
{24}]]]\[IndentingNewLine]]}\[IndentingNewLine]], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{Rectangle[\[IndentingNewLine]{0, 
              0}, { .25,  .5}], \[IndentingNewLine]Rectangle[\
\[IndentingNewLine]{0, 0}, {2, 3}, 
            Graphics[
              Line[Table[{Random[], 
                    Random[]}, \
{24}]]]\[IndentingNewLine]]}\[IndentingNewLine]], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[{Rectangle[\[IndentingNewLine]{0, 0}, {2, 
              3}], \[IndentingNewLine]Rectangle[\[IndentingNewLine]{0, 
              0}, {2, 3}, 
            Graphics[
              Line[Table[{Random[], 
                    Random[]}, \
{24}]]]\[IndentingNewLine]]}\[IndentingNewLine]], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", 
      Graphics[Rectangle[{0, 0}, {2, 3}, Graphics[Circle[{0, 0},  .5]]]], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Scaled", "Subsubsection"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[{Cuboid[{ .1,  .1,  .1}, { .3,  .3,  .3}], 
          Cuboid[{ .8,  .5, 0}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[{Cuboid[{ .1,  .1,  .1}, { .3,  .3,  .3}], 
          Cuboid[{ .8,  .5, 0}, { .9,  .9,  .9}]}], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayScaled \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(rayshade`Private`pr\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics3D[{Cuboid[Scaled[{ .1,  .1,  .1}], Scaled[{ .3,  .3,  .3}]], 
          Cuboid[Scaled[{ .8,  .5, 0}], Scaled[{ .9,  .9,  .9}]]}], 
      RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      RayScaled \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", 
      Graphics[Table[Circle[{x, x^2}, Offset[{2, 2}]], {x, 10}], 
        Frame \[Rule] True], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayCsg \[Rule] False, 
      RayScaled \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Arrows", "Subsubsection"],

Cell["\<\
x=Show[Graphics[{RGBColor[0,0,0],Arrow[{0, 0},{1, 1}],
    Hue[0], Arrow[{.75, .25},{.25, .75}]}]]\
\>", "Input",
  CellTags->"S5.27.1"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True, 
      HeadScaling \[Rule] Relative]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True, 
      HeadScaling \[Rule] Relative, RayTubeLines \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell["\<\
x=Show[Graphics[{RGBColor[0,0,0],Arrow[{0, 0},{1, 1}],
    Hue[0], Arrow[{.75, .25},{.25, .75},HeadScaling\[Rule]Relative]}]]\
\>", \
"Input",
  CellTags->"S5.27.1"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", rGraphics[x[\([1]\)]], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayAspect \[Rule] True, 
      HeadScaling \[Rule] Relative, RayTubeLines \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell["\<\
mm v.9  x  of Arrow[p1,p2,x] , x is ignored (opts of mm v4 are not \
ignored) and ArrowHeads is a todo (would work like PointSize). rayshade \
doesn't support splines and pov\
\>", "Text"],

Cell["\<\
what about Arrow[ Cylinder[v] ] ?  it can work but won't support \
many of mm 9's features. for mm v4 it will recurse checking options so, three \
ways to avoid that:
\t1) avoid by replacing Arrow with rArrow
\t2) avoid by using: rGraphics[gr[[1]]]
\t   may need to add PlotRange
\t3) simplicity; remove Cylinder, use v only\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Dashing", "Subsubsection"],

Cell["\<\
NOTE: if some dots are missing insure RayGreyShade (reflect spec) \
isn't why.\
\>", "Text"],

Cell[BoxData[
    \(\(reset[];\)\)], "Input"],

Cell[BoxData[
    \(<< rayshade.m\)], "Input"],

Cell[BoxData[
    \(x = 
      Show[Graphics[{Dashing[{ .3,  .1}], Arrow[{ .25,  .25}, {1, 1}], 
            Hue[0], Arrow[{ .75,  .25}, { .25,  .75}]}]]\)], "Input"],

Cell[BoxData[
    \(x = 
      Show[Graphics[{Dashing[{ .1,  .3}], Arrow[{ .25,  .25}, {1, 1}], 
            Hue[0], Arrow[{ .75,  .25}, { .25,  .75}]}]]\)], "Input"],

Cell[BoxData[
    \(x = 
      Show[Graphics[{Dashing[{0,  .1}], Arrow[{ .25,  .25}, {1, 1}], Hue[0], 
            Arrow[{ .75,  .25}, { .25,  .75}]}]]\)], "Input"],

Cell[BoxData[
    \(x = 
      Show[Graphics[{Dashing[{ .1,  .025}], Arrow[{ .25,  .25}, {1, 1}], 
            Hue[0], Arrow[{ .75,  .25}, { .25,  .75}]}]]\)], "Input"],

Cell[BoxData[
    \(x = 
      Show[Graphics[{Dashing[{ .07,  .25}], 
            Line[{{ .25,  .25}, { .3,  .4}, { .4,  .3}, { .4,  .4}, {1, 1}}], 
            Hue[0], Arrow[{ .75,  .25}, { .25,  .75}]}]]\)], "Input"],

Cell[BoxData[
    \(x = 
      Show[Graphics[{Dashing[{ .05,  .1}], 
            Line[{{ .25,  .25}, { .3,  .4}, { .4,  .3}, { .4,  .4}, {1, 1}}], 
            Hue[0], Arrow[{ .75,  .25}, { .25,  .75}]}]]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayView \[Rule] True, 
      RayFastLight \[Rule] True, HeadScaling \[Rule] Relative, 
      RayCsg \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", y, RayView \[Rule] True, 
      RayFastLight \[Rule] True, HeadScaling \[Rule] Relative, 
      RayCsg \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      RayCsg \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", y, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      RayCsg \[Rule] False]\)], "Input"],

Cell["1) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{ .5,  .5}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["\<\
2) seems ok
\tone 2x seg on left no unusual\
\>", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{0.5, 0.05}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["3) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{0.2, 0.05}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["4) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{0.4, 0.05}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["5) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{0.2, 0.01}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["6) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{0.2, 0.02}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["7) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{1, 1}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["8) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{ .1,  .1}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["9) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{ .03,  .3}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["10) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{ .01,  .3}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["11) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{ .095,  .095}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["10) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{0, 0.01}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["13) seems ok", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{0, 0.1}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell["14) seems ok", "Text"],

Cell["\<\
.0001 is invisible but that makes sense
\twe go by scenedepth etc
.005   is just visible\
\>", "Text"],

Cell[BoxData[
    \(\(y = 
        Show[Graphics[{Dashing[{0.005, 0.1}], Circle[{0, 0}, 1]}, 
            AspectRatio \[Rule] Automatic]];\)\)], "Input",
  CellTags->"Dashing"],

Cell[BoxData[
    \(Close["\<r.orig.ray\>"]\)], "Input"],

Cell[BoxData[
    \(Close["\<c.pov\>"]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  overlay  pie  bar", "Subsubsection"],

Cell["\<\
x=BarChart[{1, 3, 4, 5, 3.5, 3}, {3, 2, 5, 3},
 BarSpacing -> -.3, BarGroupSpacing -> .5,
 BarStyle -> {GrayLevel[.6], Hue[0]},
 BarEdgeStyle ->
 {{Dashing[{.01}],Hue[0]},GrayLevel[0]},
 BarLabels ->
 {\"Apr\",\"May\",\"Jun\",\"Jul\",\"Aug\",\"Sep\"},
 PlotLabel -> \"Projected and Current Profit,
 Tourist Season\",
 DefaultFont -> {\"Helvetica\", 9}
 ]\
\>", "Input",
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(PieChart[{ .2,  .3,  .1}, PieExploded \[Rule] All]\)], "Input"],

Cell["\<\
DisplayTogetherArray[
    PieChart[{.2,.3,.1}],
    PieChart[{.2,.3,.1},
        PieExploded->All],
    PieChart[{.2,.3,.1},
        PieExploded->{{3,.2}}]
]\
\>", "Input",
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(x = %[\([1, 2]\)]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", g4, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", g4, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] False]\)], "Input"],

Cell["oops pie does need offset", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<hi   \!\(there\^2\)   adsf   asdf hi \
  there   asdf  asdf hi   \!\(there\_2\)   \!\(\@asdf\)   asdf\>\"", {0, 0, 
              0}, Background \[Rule] "\<SolidWhite\>", 
            TextStyle -> {FontFamily \[Rule] "\<Courier\>", 
                FontSize \[Rule] 24}]];\)\)], "Input"],

Cell[BoxData[
    \(xx[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(xx // Show\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {p4, xx}, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] False, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(xxx = x;\)\)], "Input"],

Cell[BoxData[
    \(xxx[\([1]\)] = 
      xxx[\([1]\)] /. 
        Text[a_, b_] \[Rule] Text[a, b, Background \[Rule] White]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", xxx, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] True, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] { .5,  .001}]\)], "Input"],

Cell["for rect chart only", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] False, 
      PlotRange -> \[InvisibleSpace]{{0.375`, 6.875`}, {\(-0.125`\), 
            5.125`}, {\(-0.125`\), 5.125`}}]\)], "Input"],

Cell[BoxData[
    \(rayshade`Private`pr\)], "Input"],

Cell[",RayOverlay\[Rule]{.25,-.001}", "Text"],

Cell[",RayOverlay\[Rule]{5,-.001}", "Text"],

Cell["{4.6363355729140325`,-0.04886644270859677`}", "Text"],

Cell[BoxData[
    \( (*\ PlotRangeClipping \[Rule] False\ *) \)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] True]\)], "Input"],

Cell["\<\
takes very litle overlay to disturb 2D chart wow !  linewidth is \
.04  and obviosly in space they'd overlap unless line poly type\
\>", "Text"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", x, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      RayOverlay \[Rule] {5, \(- .004\)}]\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<\!\(hi\^2\)  asdf asdf\\n  \
\!\(bob\_2\) asdf asdf\\ntwo asdf asdf\\nasdf asdf\\nasdf asdf\>\""\
\[IndentingNewLine], {0, 0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {p4, xx}, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayOverlay \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", {p4, xx}, RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["test  Texture", "Subsubsection"],

Cell[BoxData[
    \(\(\(Texture["\<zzz.tif\>"]\)\(,\)\)\)], "Input"],

Cell[BoxData[
    \(x = Import["\</tmp/x.xbm\>"]\)], "Input"],

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell[BoxData[
    \(StringMatchQ["\<hello.tiff\>", "\<*.tiff\>"]\)], "Input"],

Cell[BoxData[
    \(StringReplace["\<hello.tiff\>", "\<.tiff\>" \[Rule] "\<\>"]\)], "Input"],

Cell[BoxData[
    \(\(\(Texture["\<zzz.rle\>"]\)\(,\)\)\)], "Input"],

Cell[BoxData[
    \(Plus @@ {{1, 1, 1}, {2, 2, 2}}\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", \[IndentingNewLine]rGraphics3D[\
\[IndentingNewLine]Texture["\<zzz.rle\>"], \[IndentingNewLine]Sphere[{\(- .25\
\), \(- .25\), \(- .25\)},  .25], \[IndentingNewLine]Sphere[{ .25,  .25,  \
.25},  .25]\[IndentingNewLine]], \[IndentingNewLine]RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}]\)], "Input"],

Cell[BoxData[
    \(p4\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", \
\[IndentingNewLine]rGraphics3D[\[IndentingNewLine]Texture["\<zzz.tiff\>"], \
\[IndentingNewLine]Sphere[{\(- .25\), \(- .25\), \(- .25\)},  .25], \
\[IndentingNewLine]Sphere[{ .25,  .25,  .25},  .25]\[IndentingNewLine]], \
\[IndentingNewLine]RayPreView \[Rule] True, RayFastLight \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}, {\(-1\), 1}}, 
      RayPOV \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(Append[{Texture["\<zzz.rle\>"]}, p4[\([1]\)]];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<r.orig.ray\>", rGraphics3D[%], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(\(Append[{Texture["\<zzz.tiff\>"]}, p4[\([1]\)]];\)\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", rGraphics3D[%], RayPreView \[Rule] True, 
      RayFastLight \[Rule] True, RayPOV \[Rule] True, 
      RayTesselate \[Rule] True]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["POV", "Subsubsection"],

Cell[BoxData[
    \(<< POVray.m\)], "Input"],

Cell[BoxData[
    \(Rayshade["\<c.pov\>", p4, opts, RayPreView \[Rule] True, 
      RayPOV \[Rule] True, RayTesselate \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(POVray["\<y.pov\>", p4]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["vars  /  const", "Subsubsection"],

Cell[BoxData[
    \(\(?rayshade`*\)\)], "Input"],

Cell[BoxData[
    \(vp = {1.3`, \(-2.4`\), 2.`}\)], "Input"],

Cell[BoxData[
    \(vp = rayshade`Private`vp\)], "Input"],

Cell[BoxData[
    \(rayshade`Private`vv\)], "Input"],

Cell[BoxData[
    \(pr = rayshade`Private`pr\)], "Input"],

Cell[BoxData[
    \(box = rayshade`Private`prbox[pr]\)], "Input"],

Cell[BoxData[
    \(\(boxcenter = \((box[\([7]\)] + box[\([1]\)])\)/2;\)\)], "Input"],

Cell[BoxData[
    \(scenedepth = \(Table[magnitude[boxcenter, box[\([i]\)]], {i, 1, 8}] // 
          Sort\) // Last\)], "Input"],

Cell[BoxData[
    \(linewidth = 
      linewidth\ scenedepth\ \((scenedepth)\)^\((1/2)\)\)], "Input"],

Cell[BoxData[
    \(unit = vp/magnitude[vp]\)], "Input"],

Cell[BoxData[
    \(onnormalplane = \(-1\) {0, vp[\([2]\)]/\((vp[\([1]\)] +  .0001)\), 
          vp[\([3]\)]/\((vp[\([1]\)] +  .0001)\)}\)], "Input"],

Cell[BoxData[
    \(vpnormal = Cross[onnormalplane, vp]\)], "Input"],

Cell[BoxData[
    \(vpnormal = vpnormal/\((magnitude[vpnormal])\)\)], "Input"],

Cell[BoxData[
    \(\(opts = {LightSources \[Rule] {{{1.`, 0.`, 1.`}, 
                RGBColor[1, 0, 0]}, {{1.`, 1.`, 1.`}, 
                RGBColor[0, 1, 0]}, {{0.`, 1.`, 1.`}, 
                RGBColor[0, 0, 1]}}};\)\)], "Input"],

Cell[BoxData[
    \(\(opts = {LightSources \[Rule] {{{1, \(-1\), \(-1\)}, 
                RGBColor[1, 0, 0]}, {{1, 1, 1}, 
                RGBColor[0, 1, 0]}, {{0, \(-1\), 1}, 
                RGBColor[0, 0, 1]}}}\ ;\)\)], "Input"],

Cell[BoxData[
    \(\(opts = {LightSources \[Rule] {{{1, \(-1\), \(-1\)}, 
                RGBColor[ .5,  .5,  .5]}, {{1, 1, 1}, 
                RGBColor[ .5,  .5,  .5]}, {{0, \(-1\), 1}, 
                RGBColor[ .5,  .5,  .5]}}}\ ;\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["opts", "Subsubsection"],

Cell[BoxData[
    \(opts = rayshade`Private`lights\)], "Input"],

Cell[BoxData[
    \(opts = \(\(LightSources\)\(->\)\({{{1, \(-1\), \(-1\)}, 
            Hue[ .1]}, {{1, 1, 1}, RGBColor[0, 1, 0]}, {{\(-1\), \(-1\), 1}, 
            RGBColor[0, 0, 1]}}\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(opts = \(\(LightSources\)\(->\)\({{{1, \(-1\), \(-1\)}, 
            Gray[1]}, {{1, 1, 1}, RGBColor[0, 1, 0]}, {{\(-1\), \(-1\), 1}, 
            RGBColor[0, 0, 1]}}\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(opts = {LightSources \[Rule] {LightSources /. 
                Options[Graphics3D]}[\([1]\)]}\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["oops   bb", "Subsubsection"],

Cell[BoxData[
    \(rayshade`Private`pr\)], "Input"],

Cell[BoxData[
    \(\(boundingbox[pr_] := 
        Module[{xl, xh, yl, yh, zl, zh}, \[IndentingNewLine]xl = 
            pr[\([1, 1]\)]; 
          xh = pr[\([1, 2]\)]; \[IndentingNewLine]yl = pr[\([2, 1]\)]; 
          yh = pr[\([2, 2]\)]; \[IndentingNewLine]zl = pr[\([3, 1]\)]; 
          zh = pr[\([3, 2]\)]; \[IndentingNewLine]{\  (*\ 
              going\ cc\ *) \[IndentingNewLine] (*\ 
              xl + 1\ corners\ *) \[IndentingNewLine]Cuboid[{xl + 1, yl, 
                zl + 1}, {xh + 1, yl, 
                zh + 1}], \[IndentingNewLine]Cuboid[{xh, yl + 1, 
                zl + 1}, {xh, yh + 1, 
                zh + 1}], \[IndentingNewLine]Cuboid[{xl + 1, yh, 
                zl + 1}, {xh + 1, yh, 
                zh + 1}], \[IndentingNewLine]Cuboid[{xl + 1, yl, 
                zl + 1}, {xl + 1, yh, zh + 1}], \[IndentingNewLine] (*\ 
              t\ b\ *) \[IndentingNewLine]Cuboid[{xl + 1, yl + 1, 
                zh}, {xh + 1, yh + 1, 
                zh}], \[IndentingNewLine]Cuboid[{xl + 1, yl + 1, 
                zl}, {xh + 1, yh + 1, 
                zl}]\[IndentingNewLine]}\[IndentingNewLine]];\)\)], "Input",
  CellTags->"Cuboid"],

Cell[BoxData[
    \(boundingbox[rayshade`Private`pr]\)], "Input"],

Cell[BoxData[
    \(Show@\(Graphics3D@%\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        Graphics3D[{Cuboid[{0, 0, 0}], Cuboid[{0, 0, 1}], Cuboid[{0, 1, 1}], 
            Cuboid[{1, 1, 1}]}]];\)\)], "Input",
  CellTags->"Cuboid"]
}, Closed]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{529, 598},
WindowMargins->{{263, Automatic}, {Automatic, -1}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.41.1"->{
    Cell[3648, 118, 58, 1, 27, "Input",
      CellTags->"S5.41.1"]},
  "RasterArray"->{
    Cell[40783, 1092, 195, 6, 75, "Input",
      CellTags->"RasterArray"]},
  "Circle"->{
    Cell[48555, 1375, 170, 4, 43, "Input",
      CellTags->"Circle"]},
  "S2.9.1"->{
    Cell[49109, 1393, 79, 1, 27, "Input",
      CellTags->"S2.9.1"]},
  "S5.27.1"->{
    Cell[70219, 1946, 146, 4, 55, "Input",
      CellTags->"S5.27.1"],
    Cell[71084, 1971, 175, 5, 70, "Input",
      CellTags->"S5.27.1"]},
  "Dashing"->{
    Cell[74533, 2080, 174, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[74780, 2091, 175, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[74988, 2099, 175, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[75196, 2107, 175, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[75404, 2115, 175, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[75612, 2123, 175, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[75820, 2131, 170, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[76023, 2139, 174, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[76230, 2147, 175, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[76439, 2155, 175, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[76648, 2163, 178, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[76860, 2171, 173, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[77067, 2179, 172, 4, 43, "Input",
      CellTags->"Dashing"],
    Cell[77388, 2193, 176, 4, 43, "Input",
      CellTags->"Dashing"]},
  "S5.32.1"->{
    Cell[77765, 2210, 402, 13, 177, "Input",
      CellTags->"S5.32.1"],
    Cell[78256, 2228, 205, 9, 117, "Input",
      CellTags->"S5.32.1"]},
  "Cuboid"->{
    Cell[87343, 2530, 1165, 21, 251, "Input",
      CellTags->"Cuboid"],
    Cell[88636, 2559, 176, 4, 43, "Input",
      CellTags->"Cuboid"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.41.1", 89417, 2582},
  {"RasterArray", 89505, 2585},
  {"Circle", 89595, 2588},
  {"S2.9.1", 89680, 2591},
  {"S5.27.1", 89765, 2594},
  {"Dashing", 89923, 2599},
  {"S5.32.1", 90933, 2628},
  {"Cuboid", 91093, 2633}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 30, 0, 42, "Subsubsection"],
Cell[1772, 53, 45, 1, 27, "Input"],
Cell[1820, 56, 46, 1, 27, "Input"],
Cell[1869, 59, 41, 1, 27, "Input"],
Cell[1913, 62, 70, 1, 27, "Input"],
Cell[1986, 65, 122, 2, 43, "Input"],
Cell[2111, 69, 172, 3, 43, "Input"],
Cell[2286, 74, 138, 2, 43, "Input"],
Cell[2427, 78, 281, 5, 59, "Input"],
Cell[2711, 85, 259, 4, 75, "Input"],
Cell[2973, 91, 156, 3, 43, "Input"],
Cell[3132, 96, 175, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3344, 104, 78, 0, 28, "Subsubsection"],
Cell[3425, 106, 44, 1, 27, "Input"],
Cell[3472, 109, 75, 1, 27, "Input"],
Cell[3550, 112, 47, 1, 27, "Input"],
Cell[3600, 115, 45, 1, 27, "Input"],
Cell[3648, 118, 58, 1, 27, "Input",
  CellTags->"S5.41.1"],
Cell[3709, 121, 136, 2, 43, "Input"],
Cell[3848, 125, 78, 1, 27, "Input"],
Cell[3929, 128, 124, 2, 43, "Input"],
Cell[4056, 132, 148, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4241, 139, 35, 0, 28, "Subsubsection"],
Cell[4279, 141, 45, 1, 27, "Input"],
Cell[4327, 144, 46, 1, 27, "Input"],
Cell[4376, 147, 55, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4468, 153, 35, 0, 28, "Subsubsection"],
Cell[4506, 155, 46, 1, 27, "Input"],
Cell[4555, 158, 46, 1, 27, "Input"],
Cell[4604, 161, 60, 1, 27, "Input"],
Cell[4667, 164, 60, 1, 27, "Input"],
Cell[4730, 167, 79, 1, 27, "Input"],
Cell[4812, 170, 165, 5, 82, "Text"],
Cell[4980, 177, 215, 4, 59, "Input"],
Cell[5198, 183, 215, 4, 59, "Input"],
Cell[5416, 189, 328, 5, 107, "Input"],
Cell[5747, 196, 333, 5, 107, "Input"],
Cell[6083, 203, 432, 7, 155, "Input"],
Cell[6518, 212, 442, 7, 155, "Input"],
Cell[6963, 221, 26, 0, 27, "Input"],
Cell[6992, 223, 466, 7, 171, "Input"],
Cell[7461, 232, 467, 7, 171, "Input"],
Cell[7931, 241, 169, 2, 43, "Input"],
Cell[8103, 245, 169, 2, 43, "Input"],
Cell[8275, 249, 405, 7, 139, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[8717, 261, 38, 0, 28, "Subsubsection"],
Cell[8758, 263, 226, 4, 75, "Input"],
Cell[8987, 269, 206, 3, 59, "Input"],
Cell[9196, 274, 220, 3, 59, "Input"],
Cell[9419, 279, 41, 0, 31, "Text"],
Cell[9463, 281, 222, 3, 59, "Input"],
Cell[9688, 286, 434, 7, 155, "Input"],
Cell[10125, 295, 204, 3, 59, "Input"],
Cell[10332, 300, 407, 7, 139, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[10776, 312, 37, 0, 28, "Subsubsection"],
Cell[10816, 314, 129, 2, 43, "Input"],
Cell[10948, 318, 138, 2, 43, "Input"],
Cell[11089, 322, 146, 2, 43, "Input"],
Cell[11238, 326, 36, 0, 31, "Text"],
Cell[11277, 328, 144, 2, 43, "Input"],
Cell[11424, 332, 39, 0, 31, "Text"],
Cell[11466, 334, 223, 3, 59, "Input"],
Cell[11692, 339, 223, 3, 59, "Input"],
Cell[11918, 344, 229, 3, 59, "Input"],
Cell[12150, 349, 244, 4, 75, "Input"],
Cell[12397, 355, 215, 3, 59, "Input"],
Cell[12615, 360, 247, 4, 59, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[12899, 369, 48, 0, 28, "Subsubsection"],
Cell[12950, 371, 528, 10, 139, "Input"],
Cell[13481, 383, 374, 6, 91, "Input"],
Cell[13858, 391, 544, 10, 155, "Input"],
Cell[14405, 403, 390, 6, 91, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[14832, 414, 34, 0, 28, "Subsubsection"],
Cell[14869, 416, 219, 3, 59, "Input"],
Cell[15091, 421, 254, 4, 59, "Input"],
Cell[15348, 427, 277, 5, 59, "Input"],
Cell[15628, 434, 339, 6, 91, "Input"],
Cell[15970, 442, 362, 7, 91, "Input"],
Cell[16335, 451, 346, 6, 91, "Input"],
Cell[16684, 459, 369, 7, 91, "Input"],
Cell[17056, 468, 248, 4, 59, "Input"],
Cell[17307, 474, 254, 4, 59, "Input"],
Cell[17564, 480, 288, 5, 75, "Input"],
Cell[17855, 487, 294, 5, 75, "Input"],
Cell[18152, 494, 309, 5, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[18498, 504, 48, 0, 28, "Subsubsection"],
Cell[18549, 506, 319, 6, 75, "Input"],
Cell[18871, 514, 335, 6, 91, "Input"],
Cell[19209, 522, 325, 6, 91, "Input"],
Cell[19537, 530, 348, 7, 91, "Input"],
Cell[19888, 539, 320, 6, 75, "Input"],
Cell[20211, 547, 336, 6, 91, "Input"],
Cell[20550, 555, 323, 6, 91, "Input"],
Cell[20876, 563, 346, 7, 91, "Input"],
Cell[21225, 572, 330, 6, 91, "Input"],
Cell[21558, 580, 581, 9, 171, "Input"],
Cell[22142, 591, 582, 9, 171, "Input"],
Cell[22727, 602, 555, 8, 171, "Input"],
Cell[23285, 612, 566, 9, 171, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[23888, 626, 39, 0, 28, "Subsubsection"],
Cell[23930, 628, 230, 3, 75, "Input"],
Cell[24163, 633, 281, 4, 75, "Input"],
Cell[24447, 639, 279, 4, 75, "Input"],
Cell[24729, 645, 532, 8, 171, "Input"],
Cell[25264, 655, 506, 7, 171, "Input"],
Cell[25773, 664, 550, 8, 155, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[26360, 677, 53, 0, 28, "Subsubsection"],
Cell[26416, 679, 67, 1, 27, "Input"],
Cell[26486, 682, 146, 2, 43, "Input"],
Cell[26635, 686, 141, 2, 43, "Input"],
Cell[26779, 690, 146, 2, 43, "Input"],
Cell[26928, 694, 152, 2, 43, "Input"],
Cell[27083, 698, 146, 2, 43, "Input"],
Cell[27232, 702, 123, 2, 43, "Input"],
Cell[27358, 706, 67, 1, 27, "Input"],
Cell[27428, 709, 68, 1, 27, "Input"],
Cell[27499, 712, 108, 2, 27, "Input"],
Cell[27610, 716, 138, 2, 43, "Input"],
Cell[27751, 720, 134, 2, 43, "Input"],
Cell[27888, 724, 111, 2, 27, "Input"],
Cell[28002, 728, 124, 2, 27, "Input"],
Cell[28129, 732, 133, 2, 43, "Input"],
Cell[28265, 736, 196, 3, 43, "Input"],
Cell[28464, 741, 88, 1, 27, "Input"],
Cell[28555, 744, 88, 1, 27, "Input"],
Cell[28646, 747, 86, 1, 27, "Input"],
Cell[28735, 750, 92, 1, 27, "Input"],
Cell[28830, 753, 143, 2, 43, "Input"],
Cell[28976, 757, 117, 2, 27, "Input"],
Cell[29096, 761, 88, 1, 27, "Input"],
Cell[29187, 764, 122, 2, 43, "Input"],
Cell[29312, 768, 124, 2, 43, "Input"],
Cell[29439, 772, 125, 2, 43, "Input"],
Cell[29567, 776, 125, 2, 43, "Input"],
Cell[29695, 780, 125, 2, 43, "Input"],
Cell[29823, 784, 148, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[30008, 791, 63, 0, 28, "Subsubsection"],
Cell[30074, 793, 45, 1, 27, "Input"],
Cell[30122, 796, 46, 1, 27, "Input"],
Cell[30171, 799, 46, 1, 27, "Input"],
Cell[30220, 802, 92, 1, 27, "Input"],
Cell[30315, 805, 68, 1, 27, "Input"],
Cell[30386, 808, 123, 2, 43, "Input"],
Cell[30512, 812, 136, 2, 43, "Input"],
Cell[30651, 816, 129, 2, 43, "Input"],
Cell[30783, 820, 2401, 46, 795, "Input"],
Cell[33187, 868, 2434, 47, 795, "Input"],
Cell[35624, 917, 59, 1, 27, "Input"],
Cell[35686, 920, 59, 1, 27, "Input"],
Cell[35748, 923, 129, 2, 43, "Input"],
Cell[35880, 927, 129, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[36046, 934, 35, 0, 28, "Subsubsection"],
Cell[36084, 936, 245, 5, 86, "Input"],
Cell[36332, 943, 277, 5, 89, "Input"],
Cell[36612, 950, 180, 4, 66, "Input"],
Cell[36795, 956, 235, 5, 82, "Input"],
Cell[37033, 963, 258, 5, 86, "Input"],
Cell[37294, 970, 253, 5, 86, "Input"],
Cell[37550, 977, 193, 4, 66, "Input"],
Cell[37746, 983, 248, 5, 82, "Input"],
Cell[37997, 990, 248, 5, 82, "Input"],
Cell[38248, 997, 243, 5, 82, "Input"],
Cell[38494, 1004, 122, 2, 43, "Input"],
Cell[38619, 1008, 131, 2, 43, "Input"],
Cell[38753, 1012, 128, 2, 43, "Input"],
Cell[38884, 1016, 247, 4, 75, "Input"],
Cell[39134, 1022, 47, 1, 27, "Input"],
Cell[39184, 1025, 138, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[39359, 1032, 37, 0, 28, "Subsubsection"],
Cell[39399, 1034, 143, 4, 62, "Input"],
Cell[39545, 1040, 143, 4, 62, "Input"],
Cell[39691, 1046, 143, 4, 62, "Input"],
Cell[39837, 1052, 143, 4, 62, "Input"],
Cell[39983, 1058, 125, 3, 62, "Input"],
Cell[40111, 1063, 125, 3, 62, "Input"],
Cell[40239, 1068, 125, 3, 62, "Input"],
Cell[40367, 1073, 67, 1, 27, "Input"],
Cell[40437, 1076, 123, 3, 43, "Input"],
Cell[40563, 1081, 45, 1, 27, "Input"],
Cell[40611, 1084, 44, 1, 27, "Input"],
Cell[40658, 1087, 122, 3, 44, "Input"],
Cell[40783, 1092, 195, 6, 75, "Input",
  CellTags->"RasterArray"],
Cell[40981, 1100, 55, 0, 31, "Text"],
Cell[41039, 1102, 152, 2, 43, "Input"],
Cell[41194, 1106, 124, 3, 44, "Input"],
Cell[41321, 1111, 166, 5, 75, "Input"],
Cell[41490, 1118, 155, 2, 43, "Input"],
Cell[41648, 1122, 79, 1, 27, "Input"],
Cell[41730, 1125, 68, 1, 27, "Input"],
Cell[41801, 1128, 87, 1, 27, "Input"],
Cell[41891, 1131, 110, 2, 27, "Input"],
Cell[42004, 1135, 136, 2, 43, "Input"],
Cell[42143, 1139, 119, 2, 43, "Input"],
Cell[42265, 1143, 221, 4, 59, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[42523, 1152, 53, 0, 28, "Subsubsection"],
Cell[42579, 1154, 89, 1, 27, "Input"],
Cell[42671, 1157, 155, 2, 43, "Input"],
Cell[42829, 1161, 156, 2, 43, "Input"],
Cell[42988, 1165, 91, 1, 27, "Input"],
Cell[43082, 1168, 137, 2, 43, "Input"],
Cell[43222, 1172, 125, 2, 43, "Input"],
Cell[43350, 1176, 60, 1, 27, "Input"],
Cell[43413, 1179, 146, 3, 43, "Input"],
Cell[43562, 1184, 44, 1, 27, "Input"],
Cell[43609, 1187, 93, 1, 27, "Input"],
Cell[43705, 1190, 234, 5, 59, "Input"],
Cell[43942, 1197, 50, 1, 27, "Input"],
Cell[43995, 1200, 44, 1, 27, "Input"],
Cell[44042, 1203, 72, 0, 31, "Text"],
Cell[44117, 1205, 159, 3, 59, "Input"],
Cell[44279, 1210, 113, 2, 43, "Input"],
Cell[44395, 1214, 130, 2, 59, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[44562, 1221, 47, 0, 28, "Subsubsection"],
Cell[44612, 1223, 88, 1, 27, "Input"],
Cell[44703, 1226, 43, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[44783, 1232, 49, 0, 28, "Subsubsection"],
Cell[44835, 1234, 61, 1, 27, "Input"],
Cell[44899, 1237, 82, 1, 27, "Input"],
Cell[44984, 1240, 79, 1, 27, "Input"],
Cell[45066, 1243, 57, 1, 27, "Input"],
Cell[45126, 1246, 148, 3, 43, "Input"],
Cell[45277, 1251, 139, 3, 43, "Input"],
Cell[45419, 1256, 159, 4, 43, "Input"],
Cell[45581, 1262, 55, 1, 27, "Input"],
Cell[45639, 1265, 45, 1, 27, "Input"],
Cell[45687, 1268, 48, 1, 27, "Input"],
Cell[45738, 1271, 57, 1, 27, "Input"],
Cell[45798, 1274, 109, 2, 43, "Input"],
Cell[45910, 1278, 46, 1, 27, "Input"],
Cell[45959, 1281, 67, 1, 27, "Input"],
Cell[46029, 1284, 44, 1, 27, "Input"],
Cell[46076, 1287, 75, 1, 27, "Input"],
Cell[46154, 1290, 74, 1, 27, "Input"],
Cell[46231, 1293, 184, 4, 43, "Input"],
Cell[46418, 1299, 57, 1, 27, "Input"],
Cell[46478, 1302, 182, 3, 43, "Input"],
Cell[46663, 1307, 168, 4, 59, "Input"],
Cell[46834, 1313, 122, 2, 43, "Input"],
Cell[46959, 1317, 101, 2, 27, "Input"],
Cell[47063, 1321, 57, 1, 27, "Input"],
Cell[47123, 1324, 182, 3, 43, "Input"],
Cell[47308, 1329, 123, 2, 43, "Input"],
Cell[47434, 1333, 122, 2, 43, "Input"],
Cell[47559, 1337, 52, 1, 27, "Input"],
Cell[47614, 1340, 123, 2, 43, "Input"],
Cell[47740, 1344, 138, 2, 43, "Input"],
Cell[47881, 1348, 69, 1, 27, "Input"],
Cell[47953, 1351, 173, 3, 43, "Input"],
Cell[48129, 1356, 52, 1, 27, "Input"],
Cell[48184, 1359, 173, 3, 43, "Input"],
Cell[48360, 1364, 57, 1, 27, "Input"],
Cell[48420, 1367, 52, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[48509, 1373, 43, 0, 28, "Subsubsection"],
Cell[48555, 1375, 170, 4, 43, "Input",
  CellTags->"Circle"],
Cell[48728, 1381, 59, 1, 27, "Input"],
Cell[48790, 1384, 145, 2, 43, "Input"],
Cell[48938, 1388, 168, 3, 43, "Input"],
Cell[49109, 1393, 79, 1, 27, "Input",
  CellTags->"S2.9.1"],
Cell[49191, 1396, 59, 1, 27, "Input"],
Cell[49253, 1399, 145, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[49435, 1406, 104, 3, 28, "Subsubsection"],
Cell[49542, 1411, 150, 3, 43, "Input"],
Cell[49695, 1416, 150, 3, 43, "Input"],
Cell[49848, 1421, 230, 5, 82, "Input"],
Cell[50081, 1428, 57, 1, 27, "Input"],
Cell[50141, 1431, 150, 3, 43, "Input"],
Cell[50294, 1436, 156, 3, 43, "Input"],
Cell[50453, 1441, 156, 3, 43, "Input"],
Cell[50612, 1446, 235, 5, 82, "Input"],
Cell[50850, 1453, 156, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[51043, 1461, 70, 0, 28, "Subsubsection"],
Cell[51116, 1463, 185, 3, 43, "Input"],
Cell[51304, 1468, 211, 3, 59, "Input"],
Cell[51518, 1473, 212, 3, 59, "Input"],
Cell[51733, 1478, 148, 2, 43, "Input"],
Cell[51884, 1482, 259, 4, 75, "Input"],
Cell[52146, 1488, 378, 6, 123, "Input"],
Cell[52527, 1496, 310, 6, 107, "Input"],
Cell[52840, 1504, 378, 6, 123, "Input"],
Cell[53221, 1512, 336, 6, 107, "Input"],
Cell[53560, 1520, 412, 7, 123, "Input"],
Cell[53975, 1529, 344, 7, 107, "Input"],
Cell[54322, 1538, 52, 1, 27, "Input"],
Cell[54377, 1541, 413, 7, 123, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[54827, 1553, 43, 0, 28, "Subsubsection"],
Cell[54873, 1555, 45, 1, 27, "Input"],
Cell[54921, 1558, 46, 1, 27, "Input"],
Cell[54970, 1561, 238, 4, 75, "Input"],
Cell[55211, 1567, 244, 4, 75, "Input"],
Cell[55458, 1573, 277, 5, 75, "Input"],
Cell[55738, 1580, 249, 4, 75, "Input"],
Cell[55990, 1586, 427, 7, 107, "Input"],
Cell[56420, 1595, 316, 5, 107, "Input"],
Cell[56739, 1602, 290, 5, 107, "Input"],
Cell[57032, 1609, 306, 5, 107, "Input"],
Cell[57341, 1616, 354, 6, 123, "Input"],
Cell[57698, 1624, 26, 0, 27, "Input"],
Cell[57727, 1626, 406, 7, 107, "Input"],
Cell[58136, 1635, 415, 7, 107, "Input"],
Cell[58554, 1644, 407, 7, 107, "Input"],
Cell[58964, 1653, 64, 1, 27, "Input"],
Cell[59031, 1656, 407, 7, 107, "Input"],
Cell[59441, 1665, 407, 7, 107, "Input"],
Cell[59851, 1674, 304, 5, 91, "Input"],
Cell[60158, 1681, 240, 4, 75, "Input"],
Cell[60401, 1687, 261, 5, 75, "Input"],
Cell[60665, 1694, 283, 5, 91, "Input"],
Cell[60951, 1701, 76, 1, 27, "Input"],
Cell[61030, 1704, 263, 5, 75, "Input"],
Cell[61296, 1711, 274, 5, 75, "Input"],
Cell[61573, 1718, 185, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[61795, 1726, 82, 1, 28, "Subsubsection"],
Cell[61880, 1729, 157, 2, 43, "Input"],
Cell[62040, 1733, 141, 2, 43, "Input"],
Cell[62184, 1737, 147, 2, 43, "Input"],
Cell[62334, 1741, 155, 2, 43, "Input"],
Cell[62492, 1745, 261, 4, 91, "Input"],
Cell[62756, 1751, 275, 5, 75, "Input"],
Cell[63034, 1758, 252, 4, 75, "Input"],
Cell[63289, 1764, 77, 1, 27, "Input"],
Cell[63369, 1767, 374, 7, 123, "Input"],
Cell[63746, 1776, 334, 6, 107, "Input"],
Cell[64083, 1784, 56, 1, 27, "Input"],
Cell[64142, 1787, 60, 1, 27, "Input"],
Cell[64205, 1790, 512, 9, 123, "Input"],
Cell[64720, 1801, 517, 9, 123, "Input"],
Cell[65240, 1812, 90, 3, 31, "Text"],
Cell[65333, 1817, 638, 11, 155, "Input"],
Cell[65974, 1830, 90, 3, 31, "Text"],
Cell[66067, 1835, 529, 9, 123, "Input"],
Cell[66599, 1846, 426, 9, 123, "Input"],
Cell[67028, 1857, 442, 9, 123, "Input"],
Cell[67473, 1868, 410, 9, 123, "Input"],
Cell[67886, 1879, 426, 9, 123, "Input"],
Cell[68315, 1890, 434, 9, 123, "Input"],
Cell[68752, 1901, 216, 4, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[69005, 1910, 37, 0, 28, "Subsubsection"],
Cell[69045, 1912, 215, 4, 75, "Input"],
Cell[69263, 1918, 256, 4, 75, "Input"],
Cell[69522, 1924, 52, 1, 27, "Input"],
Cell[69577, 1927, 295, 5, 91, "Input"],
Cell[69875, 1934, 267, 5, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[70179, 1944, 37, 0, 28, "Subsubsection"],
Cell[70219, 1946, 146, 4, 55, "Input",
  CellTags->"S5.27.1"],
Cell[70368, 1952, 145, 2, 43, "Input"],
Cell[70516, 1956, 182, 3, 43, "Input"],
Cell[70701, 1961, 209, 3, 59, "Input"],
Cell[70913, 1966, 168, 3, 56, "Input"],
Cell[71084, 1971, 175, 5, 70, "Input",
  CellTags->"S5.27.1"],
Cell[71262, 1978, 168, 3, 56, "Input"],
Cell[71433, 1983, 188, 3, 56, "Input"],
Cell[71624, 1988, 232, 4, 72, "Input"],
Cell[71859, 1994, 198, 4, 65, "Text"],
Cell[72060, 2000, 348, 8, 133, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[72445, 2013, 38, 0, 28, "Subsubsection"],
Cell[72486, 2015, 102, 3, 48, "Text"],
Cell[72591, 2020, 45, 1, 27, "Input"],
Cell[72639, 2023, 46, 1, 27, "Input"],
Cell[72688, 2026, 166, 3, 59, "Input"],
Cell[72857, 2031, 166, 3, 59, "Input"],
Cell[73026, 2036, 164, 3, 59, "Input"],
Cell[73193, 2041, 168, 3, 59, "Input"],
Cell[73364, 2046, 218, 4, 91, "Input"],
Cell[73585, 2052, 217, 4, 91, "Input"],
Cell[73805, 2058, 177, 3, 43, "Input"],
Cell[73985, 2063, 177, 3, 43, "Input"],
Cell[74165, 2068, 166, 3, 43, "Input"],
Cell[74334, 2073, 166, 3, 43, "Input"],
Cell[74503, 2078, 27, 0, 31, "Text"],
Cell[74533, 2080, 174, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[74710, 2086, 67, 3, 48, "Text"],
Cell[74780, 2091, 175, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[74958, 2097, 27, 0, 31, "Text"],
Cell[74988, 2099, 175, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[75166, 2105, 27, 0, 31, "Text"],
Cell[75196, 2107, 175, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[75374, 2113, 27, 0, 31, "Text"],
Cell[75404, 2115, 175, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[75582, 2121, 27, 0, 31, "Text"],
Cell[75612, 2123, 175, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[75790, 2129, 27, 0, 31, "Text"],
Cell[75820, 2131, 170, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[75993, 2137, 27, 0, 31, "Text"],
Cell[76023, 2139, 174, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[76200, 2145, 27, 0, 31, "Text"],
Cell[76230, 2147, 175, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[76408, 2153, 28, 0, 31, "Text"],
Cell[76439, 2155, 175, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[76617, 2161, 28, 0, 31, "Text"],
Cell[76648, 2163, 178, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[76829, 2169, 28, 0, 31, "Text"],
Cell[76860, 2171, 173, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[77036, 2177, 28, 0, 31, "Text"],
Cell[77067, 2179, 172, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[77242, 2185, 28, 0, 31, "Text"],
Cell[77273, 2187, 112, 4, 65, "Text"],
Cell[77388, 2193, 176, 4, 43, "Input",
  CellTags->"Dashing"],
Cell[77567, 2199, 56, 1, 27, "Input"],
Cell[77626, 2202, 51, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[77714, 2208, 48, 0, 28, "Subsubsection"],
Cell[77765, 2210, 402, 13, 177, "Input",
  CellTags->"S5.32.1"],
Cell[78170, 2225, 83, 1, 27, "Input"],
Cell[78256, 2228, 205, 9, 117, "Input",
  CellTags->"S5.32.1"],
Cell[78464, 2239, 50, 1, 27, "Input"],
Cell[78517, 2242, 147, 2, 43, "Input"],
Cell[78667, 2246, 148, 2, 43, "Input"],
Cell[78818, 2250, 41, 0, 31, "Text"],
Cell[78862, 2252, 147, 2, 43, "Input"],
Cell[79012, 2256, 146, 2, 43, "Input"],
Cell[79161, 2260, 376, 7, 103, "Input"],
Cell[79540, 2269, 44, 1, 27, "Input"],
Cell[79587, 2272, 43, 1, 27, "Input"],
Cell[79633, 2275, 153, 2, 43, "Input"],
Cell[79789, 2279, 146, 2, 43, "Input"],
Cell[79938, 2283, 170, 3, 43, "Input"],
Cell[80111, 2288, 169, 3, 43, "Input"],
Cell[80283, 2293, 45, 1, 27, "Input"],
Cell[80331, 2296, 137, 3, 43, "Input"],
Cell[80471, 2301, 171, 3, 43, "Input"],
Cell[80645, 2306, 154, 2, 43, "Input"],
Cell[80802, 2310, 35, 0, 31, "Text"],
Cell[80840, 2312, 263, 4, 75, "Input"],
Cell[81106, 2318, 52, 1, 27, "Input"],
Cell[81161, 2321, 45, 0, 31, "Text"],
Cell[81209, 2323, 43, 0, 31, "Text"],
Cell[81255, 2325, 59, 0, 31, "Text"],
Cell[81317, 2327, 74, 1, 27, "Input"],
Cell[81394, 2330, 146, 2, 43, "Input"],
Cell[81543, 2334, 154, 3, 48, "Text"],
Cell[81700, 2339, 164, 3, 43, "Input"],
Cell[81867, 2344, 235, 5, 82, "Input"],
Cell[82105, 2351, 154, 2, 43, "Input"],
Cell[82262, 2355, 128, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[82427, 2362, 38, 0, 28, "Subsubsection"],
Cell[82468, 2364, 68, 1, 27, "Input"],
Cell[82539, 2367, 61, 1, 27, "Input"],
Cell[82603, 2370, 44, 1, 27, "Input"],
Cell[82650, 2373, 77, 1, 27, "Input"],
Cell[82730, 2376, 92, 1, 27, "Input"],
Cell[82825, 2379, 68, 1, 27, "Input"],
Cell[82896, 2382, 63, 1, 27, "Input"],
Cell[82962, 2385, 424, 6, 139, "Input"],
Cell[83389, 2393, 35, 1, 27, "Input"],
Cell[83427, 2396, 443, 7, 139, "Input"],
Cell[83873, 2405, 83, 1, 27, "Input"],
Cell[83959, 2408, 134, 2, 43, "Input"],
Cell[84096, 2412, 84, 1, 27, "Input"],
Cell[84183, 2415, 184, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[84404, 2423, 28, 0, 28, "Subsubsection"],
Cell[84435, 2425, 44, 1, 27, "Input"],
Cell[84482, 2428, 144, 2, 43, "Input"],
Cell[84629, 2432, 56, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[84722, 2438, 39, 0, 28, "Subsubsection"],
Cell[84764, 2440, 48, 1, 27, "Input"],
Cell[84815, 2443, 60, 1, 27, "Input"],
Cell[84878, 2446, 57, 1, 27, "Input"],
Cell[84938, 2449, 52, 1, 27, "Input"],
Cell[84993, 2452, 57, 1, 27, "Input"],
Cell[85053, 2455, 65, 1, 27, "Input"],
Cell[85121, 2458, 85, 1, 27, "Input"],
Cell[85209, 2461, 129, 2, 43, "Input"],
Cell[85341, 2465, 101, 2, 27, "Input"],
Cell[85445, 2469, 56, 1, 27, "Input"],
Cell[85504, 2472, 150, 2, 43, "Input"],
Cell[85657, 2476, 68, 1, 27, "Input"],
Cell[85728, 2479, 78, 1, 27, "Input"],
Cell[85809, 2482, 233, 4, 75, "Input"],
Cell[86045, 2488, 232, 4, 75, "Input"],
Cell[86280, 2494, 250, 4, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[86567, 2503, 29, 0, 28, "Subsubsection"],
Cell[86599, 2505, 63, 1, 27, "Input"],
Cell[86665, 2508, 209, 3, 59, "Input"],
Cell[86877, 2513, 208, 3, 59, "Input"],
Cell[87088, 2518, 126, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[87251, 2525, 34, 0, 28, "Subsubsection"],
Cell[87288, 2527, 52, 1, 27, "Input"],
Cell[87343, 2530, 1165, 21, 251, "Input",
  CellTags->"Cuboid"],
Cell[88511, 2553, 65, 1, 27, "Input"],
Cell[88579, 2556, 54, 1, 27, "Input"],
Cell[88636, 2559, 176, 4, 43, "Input",
  CellTags->"Cuboid"]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

