(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14333,        433]*)
(*NotebookOutlinePosition[     16254,        500]*)
(*  CellTagsIndexPosition[     16052,        489]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(Unprotect[In, \ Out];\)\)], "Input"],

Cell[BoxData[
    \(\(Clear[In, \ Out];\)\)], "Input"],

Cell[BoxData[
    \(\(Protect[In, \ Out];\)\)], "Input"],

Cell[BoxData[
    \(\($HistoryLength\  = \ 5;\)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(\(p = 1;\)\)], "Input"],

Cell[BoxData[
    \(SetDirectory["\</home/jdh/math/Mathematica/MathSource/tmp/tmp\>"]\)], \
"Input"],

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell[BoxData[
    \(\(reset[] := 
        Module[{}, \n
          SetDirectory["\<~/math/Mathematica/MathSource/tmp/tmp\>"]; \
\[IndentingNewLine]Map[Unprotect, 
            Names["\<SurfaceGraphics3D`Private`*\>"]]; \[IndentingNewLine]Map[
            Remove, Names["\<SurfaceGraphics3D`Private`*\>"]]; \
\[IndentingNewLine]Map[Unprotect, 
            Names["\<SurfaceGraphics3D`*\>"]]; \[IndentingNewLine]Map[Remove, 
            Names["\<SurfaceGraphics3D`*\>"]]; \[IndentingNewLine]Map[
            Unprotect, 
            Names["\<rayshade`Private`*\>"]]; \[IndentingNewLine]Map[Remove, 
            Names["\<rayshade`Private`*\>"]]; \n
          Map[Unprotect, Names["\<rayshade`*\>"]]; \[IndentingNewLine]Map[
            Remove, Names["\<rayshade`*\>"]]; \
\[IndentingNewLine]Close["\<y.orig.ray\>"]; \n
          Map[Unprotect, Names["\<POVray`Private`*\>"]]; \n
          Map[Remove, Names["\<POVray`Private`*\>"]]; \n
          Map[Unprotect, Names["\<POVray`*\>"]]; \n
          Map[Remove, 
            Names["\<POVray`*\>"]];\[IndentingNewLine]];\)\)], "Input"],

Cell[BoxData[
    \(\(reset[] := 
        Module[{}, \n
          SetDirectory["\<~/math/Mathematica/MathSource/tmp/tmp\>"]; \
\[IndentingNewLine]Map[Unprotect, 
            Names["\<rayshade`Private`*\>"]]; \[IndentingNewLine]Map[Remove, 
            Names["\<rayshade`Private`*\>"]]; \n
          Map[Unprotect, Names["\<rayshade`*\>"]]; \[IndentingNewLine]Map[
            Remove, Names["\<rayshade`*\>"]]; \
\[IndentingNewLine]Close["\<y.orig.ray\>"]; \n
          Close["\<c.pov\>"];\[IndentingNewLine]];\)\)], "Input"],

Cell[BoxData[
    \(opts = {\[IndentingNewLine]LightSources \[Rule] {{{1.`, 0.`, 1.`}, 
              RGBColor[ .75, 0, 0]}, {{1.`, 1.`, 1.`}, 
              RGBColor[0, 1, 0]}, {{0.`, 1.`, 1.`}, 
              RGBColor[0, 0, 1]}}\[IndentingNewLine], 
        ViewPoint \[Rule] {1.3`, \(-2.4`\), 2.`}, 
        ViewVertical \[Rule] {0.`, 0.`, 1.`}\[IndentingNewLine]}\)], "Input"],

Cell[BoxData[
    \(\(reset[];\)\)], "Input"],

Cell[BoxData[
    \(opts\)], "Input"],

Cell[BoxData[
    \(\(opts = {\[IndentingNewLine]LightSources \[Rule] {{{1.`, 0.`, 1.`}, 
                RGBColor[1, 0, 0]}, {{1.`, 1.`, 1.`}, 
                RGBColor[0, 1, 0]}, {{0.`, 1.`, 1.`}, 
                RGBColor[0, 0, 1]}}\[IndentingNewLine], 
          ViewPoint \[Rule] {1.3`, \(-2.4`\), 2.`}, 
          ViewVertical \[Rule] {0.`, 0.`, 
              1.`}\[IndentingNewLine]};\)\)], "Input"],

Cell[BoxData[
    \(\(LightSources\  /. \ opts\)\  /. \ Options[Graphics3D]\)], "Input"],

Cell["\<\
p4=ContourPlot3D[x y z,
   {x,-1,1}, {y,-1,1}, {z,-1,1},
      Contours -> {.1},ViewCenter->{.75,.15,.15}]\
\>", "Input",
  CellTags->"S5.30.1"],

Cell["\<\
p4=ContourPlot3D[x y z,
   {x,-1,1}, {y,-1,1}, {z,-1,1},
      Contours -> \
{.1},PlotRange\[Rule].5+{{-1.05,1.05},{-1.05,1.05},{-1.05,1.05}}]\
\>", \
"Input",
  CellTags->"S5.30.1"],

Cell["Rayshade[\"y.orig.ray\",%,opts]", "Text"],

Cell["y.orig.ray", "Text"],

Cell[BoxData[
    \(p4 = 
      ContourPlot3D[x\ y\ z, {x, \(-1\), 1}, {y, \(-1\), 1}, {z, \(-1\), 1}, 
        Contours \[Rule] { .1}, ViewPoint \[Rule] {5, 10, 3}]\)], "Input"],

Cell["\<\
p4=Module[{x,y,z},ContourPlot3D[x y z,
   {x,-1,1}, {y,-1,1}, {z,-1,1},
      Contours -> {.1}]]\
\>", "Input",
  CellTags->"S5.30.1"],

Cell["\<\
p4=ContourPlot3D[x y z,
   {x,-1,1}, {y,-1,1}, {z,-1,1},
      Contours -> {.1},PolygonIntersections->False]\
\>", "Input",
  CellTags->"S2.9.6"],

Cell[BoxData[
    \(Show[{Plot[x^2, {x, \(-2\), 2}], p4}]\)], "Input"],

Cell[BoxData[
    \(\(xx = Plot[x^2, {x, \(-2\), 2}];\)\)], "Input"],

Cell[BoxData[
    \(Show[Graphics3D[p4[\([1]\)], Prolog \[Rule] {xx[\([1]\)]}]]\)], "Input"],

Cell["\<\
p3=Module[{x,y},Plot3D[Sin[x] Exp[y], {x, -5, 5}, {y, -2, \
2},PlotPoints->10]]\
\>", "Input",
  CellTags->"S2.9.6"],

Cell[BoxData[
    \(Show[p3, SphericalRegion \[Rule] True, 
      BoxRatios \[Rule] {1, 1, 1}]\)], "Input"],

Cell[BoxData[
    \(Head[Unevaluated[p3[\([1, 1]\)]]]\)], "Input"],

Cell[BoxData[
    \(\(p3[\([1]\)] *=  .5;\)\)], "Input"],

Cell["Show[ Graphics3D[ MoebiusStrip[ 2, 1, 80] ]]", "Input",
  CellTags->"S5.41.1"],

Cell["\<\
LightSources/.Flatten[{opts,FullOptions[p3],Options[Graphics3D]}]\
\
\>", "Text"],

Cell["PlotRange/.Flatten[{Options[Graphics3D],FullOptions[p3]}] ", "Text"],

Cell["Options[Graphics3D]", "Text"],

Cell["FullOptions[p3]", "Text"],

Cell["Normally this produces Show[]", "Text"],

Cell[BoxData[
    \(<< Graphics`ParametricPlot3D`\)], "Input"],

Cell["\<\
p5a=Module[{u,t},ParametricPlot3D[{u Sin[t], u Cos[t], t/3},{t, 0, \
15}, {u, -1, 1}]]\
\>", "Input",
  CellTags->"S1.9.10"],

Cell[BoxData[
    \(SurfaceGraphics3D`\)], "Input"],

Cell["\<\
p5=Module[{u,t},ParametricPlot3DtoSurfaceGraphics[{u Sin[t], u \
Cos[t], t/3},{t, 0, 15}, {u, -1, 1}]]\
\>", "Input",
  CellTags->"S1.9.10"],

Cell[BoxData[
    \(Show[%]\)], "Input"],

Cell[BoxData[
    \( (*\ Graphics3D[p5]\ *) \)], "Input"],

Cell[BoxData[
    \(p6 = 
      Show[Graphics3D[
          Line[Table[{Random[], Random[], Random[]}, {12}]]]]\)], "Input",
  CellTags->"Line"],

Cell[BoxData[
    \(FullOptions[p6]\)], "Input"],

Cell[BoxData[
    \(vc = ViewCenter /. FullOptions[p3]\)], "Input"],

Cell[BoxData[
    \(vv = ViewVertical /. FullOptions[p3]\)], "Input"],

Cell[BoxData[
    \(vp = ViewPoint /. FullOptions[p3]\)], "Input"],

Cell[BoxData[
    \(pr = PlotRange /. FullOptions[p3]\)], "Input"],

Cell[BoxData[
    \(PlotRange /. FullOptions[p3]\)], "Input"],

Cell[BoxData[
    \(PlotRange /. FullOptions[p4]\)], "Input"],

Cell[BoxData[
    \(PlotRange /. FullOptions[p6]\)], "Input"],

Cell[BoxData[
    \(PlotRange /. FullOptions[p7]\)], "Input"],

Cell[BoxData[
    \(p7 = 
      Module[{x}, 
        Show[Graphics3D[Point /@ Table[{x, 1\/x, 0}, {x, \(-10\), 10,  .2}]], 
          ViewCenter \[Rule] { .5,  .5,  .5}]]\)], "Input",
  CellTags->"Point"],

Cell[BoxData[
    \(\(?Global`*\)\)], "Input"],

Cell[BoxData[
    \(Names["\<rayshade`*\>"]\)], "Input"],

Cell[BoxData[
    \(\(Names["\<rayshade`Private`*\>"];\)\)], "Input"],

Cell["\<\
Plot3D[Sin[x] Exp[y], {x, -5, 5}, {y, -2, 2},PlotPoints\[Rule]10, \
BoxRatios -> {1, 1, 1}]\
\>", "Input",
  CellTags->"S2.9.6"],

Cell["\<\
Plot3D[Sin[x] Exp[y], {x, -5, 5}, {y, -2, 2},PlotPoints\[Rule]10, \
SphericalRegion->True, BoxRatios -> {1, 5, 1}]\
\>", "Input",
  CellTags->"S2.9.6"],

Cell["\<\
Plot3D[Sin[x] Exp[y], {x, -5, 5}, {y, -2, 2},PlotPoints\[Rule]10, \
BoxRatios -> {1, 5, 1},Axes->Automatic]\
\>", "Input",
  CellTags->"S2.9.6"],

Cell[BoxData[
    \(\(Insert[p7[\([1]\)], RGBColor[1, 0, 0], 35];\)\)], "Input"],

Cell[BoxData[
    \(Show[Graphics3D[Insert[p7[\([1]\)], RGBColor[1, 0, 0], 43]]]\)], "Input"],

Cell[BoxData[
    \(\(xx = 
        Graphics3D[
          Text[\[IndentingNewLine]\*"\"\<hi   \!\(there\^2\)   adsf   asdf hi \
  there   asdf  asdf hi   \!\(there\_2\)   \!\(\@asdf\)   asdf\>\""\
\[IndentingNewLine], {0, 0, 0}]];\)\)], "Input"],

Cell[BoxData[
    \(Show[xx]\)], "Input"],

Cell["\<\
p8=
Module[{data},
data = Table[x^2 + 2*y^2 + 3*z^2,
                   {z, -1, 1, .25},
                   {y, -1, 1, .25},
                   {x, -1, 1, .25}];
ListContourPlot3D[data,
 MeshRange -> {{-1,1}, {-1,1}, {-1,1}},
    Contours -> {1.5, 3.},
    Lighting -> False, Axes -> True,
    ContourStyle -> {{RGBColor[0,1,0]},
       {RGBColor[1,0,0]}}]
       ]\
\>", "Input",
  CellTags->"S5.30.1"],

Cell["\<\
p9=Module[{data},
data = Table[x^2 + 2*y^2 + 3*z^2,
                   {z, -1, 1, .25},
                   {y, -1, 1, .25},
                   {x, -1, 1, .25}];
ListContourPlot3D[data,
 MeshRange -> {{-1,1}, {-1,1}, {-1,1}},
    Contours -> {1.5, 3.}]]\
\>", "Input",
  CellTags->"S5.30.1"],

Cell[BoxData[
    \(\(g3 =. ;\)\)], "Input"],

Cell[BoxData[
    \(Module[{r, x, y, c, t, magnitude}, \n
      magnitude[
          v_] := \((\((v[\([\)\(1\)\(]\)])\)^2 + \
\((v[\([\)\(2\)\(]\)])\)^2)\)^\((1/2)\); \n
      r[x_] := {1 - \((x)\)^2, \((x)\)}; \neqdr[x_, y_] := Dt[r[x], y]; \n
      eqs[x_, y_] := Integrate[magnitude[eqdr[x, y]], y]; \n
      eqst = eqs[t, t]; \n\(c = 
          Table[t /. FindRoot[eqst \[Equal] i, {t,  .1}], {i, 1, 9}]~Prepend~
            0; \)\n\(g1\  = \ 
          ParametricPlot[
            r[t], \ {t, \ 0, \ c[\([\)\(10\)\(]\)]}]; \)\n\(g2\  = \ 
          ListPlot[
            Table[r[c[\([\)\(i\  + \ 1\)\(]\)]], \ {i, \ 0, \ 9}]]\); \n
      g1[\([\)\(1, 1\)\(]\)] = 
        Prepend[g1[\([\)\(1, 1\)\(]\)], RGBColor[0, 0, 1]]; \n
      g3 = Show[{g1, g2}];\n]\)], "Input"],

Cell[BoxData[
    \(\(g4 = g3;\)\)], "Input"],

Cell[BoxData[
    \(\(g4[\([2]\)] = g3[\([2]\)];\)\)], "Input"],

Cell[BoxData[
    \(\(g4[\([1]\)] = {{{RGBColor[0, 0, 1], RGBColor[1, 0, 0], 
              Line[{{0.9999999999999857`, 
                    1.1977632291270357`*^-7}, {0.9999874079809126`, 
                    0.003548523508081326`}, {0.9999540727064219`, 
                    0.006776967874946659`}, {0.9998896752442977`, 
                    0.010503559192113685`}, {0.9998032619970159`, 
                    0.014026332485155559`}, {0.9995882349632227`, 
                    0.020291994401173533`}, {0.9992659598798622`, 
                    0.027093174788824437`}, {0.998804009801833`, 
                    0.03458309121763069`}, {0.99819177310666`, 
                    0.04252325120848609`}, {0.9967773125796671`, 
                    0.056768718677921194`}, {0.9948916740161823`, 
                    0.07147255405970677`}, {0.9927328961710844`, 
                    0.08524730980456593`}, {0.9864009039978646`, 
                    0.11661516197362767`}, {0.977914705303719`, 
                    0.14861121995421783`}, {0.9683568480408226`, 
                    0.1778852213062609`}, {0.9405644520437418`, 
                    0.2437940687470846`}, {0.9093396151510473`, 
                    0.30109862976930446`}, {0.8677592751695499`, 
                    0.3636491782342566`}, {0.7634813577899777`, 
                    0.4863318231516649`}, {0.6346529879870053`, 
                    0.6044394196385563`}, {0.4671735814799851`, 
                    0.729949599986201`}, {0.2759951730138005`, 
                    0.8508847319033287`}, {0.06443746710128195`, 
                    0.9672448153899394`}, {\(-0.19029732738878824`\), 
                    1.0910074827373037`}, {\(-0.4645721840677004`\), 
                    1.2101951016541508`}, {\(-0.75511536816228`\), 
                    1.324807672140481`}, {\(-1.0932962912454651`\), 
                    1.4468228264875644`}, {\(-1.4469185216935703`\), 
                    1.5642629324041308`}, {\(-1.8530778028849855`\), 
                    1.6891056221814507`}, {\(-2.273831606770883`\), 
                    1.8093732635282536`}, {\(-2.7058785516485475`\), 
                    1.9250658564445393`}, {\(-3.194963618007285`\), 
                    2.0481610332215787`}, {\(-3.694507255894094`\), 
                    2.1666811615681008`}, {\(-4.20125605334592`\), 
                    2.280626241484106`}, {\(-4.769478641554128`\), 
                    2.4019739052608644`}, {\(-5.344084035070403`\), 
                    2.518746520607106`}, {\(-5.985035217065126`\), 
                    2.642921719814101`}, {\(-6.631527085491273`\), 
                    2.762521870590579`}, {\(-7.263507008935598`\), 
                    2.8746316301285626`}}]}}, {Point[{1, 0}], 
            Point[{0.41641603489076917`, 0.7639266752177403`}], 
            Point[{\(-0.47477568572832274`\), 1.2144034279136084`}], 
            Point[{\(-1.4150565433967017`\), 1.5540452192252006`}], 
            Point[{\(-2.374135232934903`\), 1.836881932225069`}], 
            Point[{\(-3.3430799460130425`\), 2.0840057451967455`}], 
            Point[{\(-4.318085137828941`\), 2.306097382555416`}], 
            Point[{\(-5.297185050342193`\), 2.509419265555717`}], 
            Point[{\(-6.279234031570897`\), 2.6980055655188884`}], 
            Point[{\(-7.263507697561225`\), 
                2.8746317499048857`}]}}\ ;\)\)], "Input"],

Cell[BoxData[
    \(Show[g4]\)], "Input"]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{520, 600},
WindowMargins->{{250, Automatic}, {157, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.30.1"->{
    Cell[4779, 134, 154, 5, 57, "Input",
      CellTags->"S5.30.1"],
    Cell[4936, 141, 192, 7, 72, "Input",
      CellTags->"S5.30.1"],
    Cell[5391, 159, 144, 5, 57, "Input",
      CellTags->"S5.30.1"],
    Cell[9245, 321, 413, 15, 207, "Input",
      CellTags->"S5.30.1"],
    Cell[9661, 338, 300, 10, 132, "Input",
      CellTags->"S5.30.1"]},
  "S2.9.6"->{
    Cell[5538, 166, 155, 5, 57, "Input",
      CellTags->"S2.9.6"],
    Cell[5935, 182, 126, 4, 42, "Input",
      CellTags->"S2.9.6"],
    Cell[8312, 287, 138, 4, 42, "Input",
      CellTags->"S2.9.6"],
    Cell[8453, 293, 161, 4, 42, "Input",
      CellTags->"S2.9.6"],
    Cell[8617, 299, 154, 4, 42, "Input",
      CellTags->"S2.9.6"]},
  "S5.41.1"->{
    Cell[6302, 198, 84, 1, 27, "Input",
      CellTags->"S5.41.1"]},
  "S1.9.10"->{
    Cell[6745, 217, 134, 4, 42, "Input",
      CellTags->"S1.9.10"],
    Cell[6936, 226, 150, 4, 42, "Input",
      CellTags->"S1.9.10"]},
  "Line"->{
    Cell[7192, 238, 143, 4, 75, "Input",
      CellTags->"Line"]},
  "Point"->{
    Cell[7925, 271, 204, 5, 121, "Input",
      CellTags->"Point"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.30.1", 14923, 449},
  {"S2.9.6", 15287, 460},
  {"S5.41.1", 15643, 471},
  {"S1.9.10", 15727, 474},
  {"Line", 15878, 479},
  {"Point", 15958, 482}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 58, 1, 27, "Input"],
Cell[1778, 52, 54, 1, 27, "Input"],
Cell[1835, 55, 56, 1, 27, "Input"],
Cell[1894, 58, 60, 1, 27, "Input"],
Cell[1957, 61, 46, 1, 27, "Input"],
Cell[2006, 64, 43, 1, 27, "Input"],
Cell[2052, 67, 100, 2, 43, "Input"],
Cell[2155, 71, 44, 1, 27, "Input"],
Cell[2202, 74, 1075, 20, 267, "Input"],
Cell[3280, 96, 524, 10, 155, "Input"],
Cell[3807, 108, 380, 6, 123, "Input"],
Cell[4190, 116, 45, 1, 27, "Input"],
Cell[4238, 119, 37, 1, 27, "Input"],
Cell[4278, 122, 407, 7, 123, "Input"],
Cell[4688, 131, 88, 1, 27, "Input"],
Cell[4779, 134, 154, 5, 57, "Input",
  CellTags->"S5.30.1"],
Cell[4936, 141, 192, 7, 72, "Input",
  CellTags->"S5.30.1"],
Cell[5131, 150, 47, 0, 31, "Text"],
Cell[5181, 152, 26, 0, 31, "Text"],
Cell[5210, 154, 178, 3, 43, "Input"],
Cell[5391, 159, 144, 5, 57, "Input",
  CellTags->"S5.30.1"],
Cell[5538, 166, 155, 5, 57, "Input",
  CellTags->"S2.9.6"],
Cell[5696, 173, 70, 1, 27, "Input"],
Cell[5769, 176, 68, 1, 27, "Input"],
Cell[5840, 179, 92, 1, 27, "Input"],
Cell[5935, 182, 126, 4, 42, "Input",
  CellTags->"S2.9.6"],
Cell[6064, 188, 107, 2, 27, "Input"],
Cell[6174, 192, 66, 1, 27, "Input"],
Cell[6243, 195, 56, 1, 27, "Input"],
Cell[6302, 198, 84, 1, 27, "Input",
  CellTags->"S5.41.1"],
Cell[6389, 201, 91, 3, 31, "Text"],
Cell[6483, 206, 74, 0, 31, "Text"],
Cell[6560, 208, 35, 0, 31, "Text"],
Cell[6598, 210, 31, 0, 31, "Text"],
Cell[6632, 212, 45, 0, 31, "Text"],
Cell[6680, 214, 62, 1, 27, "Input"],
Cell[6745, 217, 134, 4, 42, "Input",
  CellTags->"S1.9.10"],
Cell[6882, 223, 51, 1, 27, "Input"],
Cell[6936, 226, 150, 4, 42, "Input",
  CellTags->"S1.9.10"],
Cell[7089, 232, 40, 1, 27, "Input"],
Cell[7132, 235, 57, 1, 27, "Input"],
Cell[7192, 238, 143, 4, 75, "Input",
  CellTags->"Line"],
Cell[7338, 244, 48, 1, 27, "Input"],
Cell[7389, 247, 67, 1, 27, "Input"],
Cell[7459, 250, 69, 1, 27, "Input"],
Cell[7531, 253, 66, 1, 27, "Input"],
Cell[7600, 256, 66, 1, 27, "Input"],
Cell[7669, 259, 61, 1, 27, "Input"],
Cell[7733, 262, 61, 1, 27, "Input"],
Cell[7797, 265, 61, 1, 27, "Input"],
Cell[7861, 268, 61, 1, 27, "Input"],
Cell[7925, 271, 204, 5, 121, "Input",
  CellTags->"Point"],
Cell[8132, 278, 46, 1, 27, "Input"],
Cell[8181, 281, 56, 1, 27, "Input"],
Cell[8240, 284, 69, 1, 27, "Input"],
Cell[8312, 287, 138, 4, 42, "Input",
  CellTags->"S2.9.6"],
Cell[8453, 293, 161, 4, 42, "Input",
  CellTags->"S2.9.6"],
Cell[8617, 299, 154, 4, 42, "Input",
  CellTags->"S2.9.6"],
Cell[8774, 305, 80, 1, 27, "Input"],
Cell[8857, 308, 93, 1, 27, "Input"],
Cell[8953, 311, 245, 5, 86, "Input"],
Cell[9201, 318, 41, 1, 27, "Input"],
Cell[9245, 321, 413, 15, 207, "Input",
  CellTags->"S5.30.1"],
Cell[9661, 338, 300, 10, 132, "Input",
  CellTags->"S5.30.1"],
Cell[9964, 350, 44, 1, 27, "Input"],
Cell[10011, 353, 774, 16, 219, "Input"],
Cell[10788, 371, 45, 1, 27, "Input"],
Cell[10836, 374, 63, 1, 27, "Input"],
Cell[10902, 377, 3383, 51, 827, "Input"],
Cell[14288, 430, 41, 1, 27, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

