(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialization Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

























If[$VersionNumber<6,
  BeginPackage["SurfaceGraphics3D`","Utilities`FilterOptions`",
    "Graphics`ParametricPlot3D`"
    ],
  BeginPackage["SurfaceGraphics3D`"]
  ]

SurfaceGraphics3D::usage="SurfaceGraphics3D[vertices, (normals,) {opts...}] \
represents a surface with given vertices and normals.  Create with \
ParametricPlot3DtoSurfaceGraphics used instead of ParametricPlot3D or see \
Private`MakeSurface3D."

ParametricPlot3DtoSurfaceGraphics::usage="Works as ParametricPlot3D[{f}, \
{u,1,2}, {v,1,2}, opts___ ] but yeilds SurfaceGraphics3D object which will \
work with: Show, Graphics3D, Rayshade."



ParametricPlot3DtoSurfaceGraphics[f_,{u_,u0_,u1_},{v_,v0_,v1_},opts___]:=
  Module[{plotpoints,ndu,ndv},
    plotpoints=PlotPoints/.{opts}/.Options[ParametricPlot3D];
    If[Head[plotpoints]=!=List,plotpoints={plotpoints,plotpoints}];
    plotpoints=plotpoints/.Automatic\[Rule]15;
    ndu=N[(u1-u0)/(plotpoints[[1]]-1)];
    ndv=N[(v1-v0)/(plotpoints[[2]]-1)];
    SurfaceGraphics3D`Private`MakeSurface3D[f,{u,u0,u1,ndu},{v,v0,v1,ndv},
      opts]]

Unprotect[ParametricPlot3DtoSurfaceGraphics]

Begin["`Private`"]

If[Not[rayshade`Private`version\[GreaterEqual]2],
  protected=Unprotect[ParametricPlot3D]]

(*overload ParametricPlot3D[] to produce SurfaceGraphics3D*)

If[Not[rayshade`Private`version\[GreaterEqual]2],
  ParametricPlot3D[f_,{u_,u0_,u1_},{v_,v0_,v1_},opts___]:=
    Module[{plotpoints,ndu,ndv},
      plotpoints=PlotPoints/.{opts}/.Options[ParametricPlot3D];
      If[Head[plotpoints]=!=List,plotpoints={plotpoints,plotpoints}];
      plotpoints=plotpoints/.Automatic\[Rule]15;
      ndu=N[(u1-u0)/(plotpoints[[1]]-1)];
      ndv=N[(v1-v0)/(plotpoints[[2]]-1)];
      MakeSurface3D[f,{u,u0,u1,ndu},{v,v0,v1,ndv},opts]]]



(*compute normals*)

MakeSurface3D[f:{_,_,_},ur:{u_,_,_,_},vr:{v_,_,_,_},opts___]:=
  Module[{n,coords,surf,normals},
    n=cross[D[f,v],D[f,u]];    (*normal vectors*)coords=
      Table[N[{f,n}],ur,vr];
    {surf,normals}=Transpose[coords,{3,2,1}];
    If[And@@NumberQ/@Flatten[normals],
      SurfaceGraphics3D[surf,normals,{opts}],(* couldnt compute normals *)
   
         SurfaceGraphics3D[surf,{opts}]]]

(* strange functions; Do not attempt to produce normals; *)

MakeSurface3D[f_,ur:{u_,_,_,_},vr:{v_,_,_,_},opts___]:=
  Module[{surf},surf=Table[N[f],ur,vr];
    SurfaceGraphics3D[surf,{opts}]]

cross[{ax_,ay_,az_},{bx_,by_,bz_}]:={ay bz-az by,az bx-ax bz,ax by-ay bx}

(* converts to Graphics3D if touched within Show or Graphics3D *)

makeMesh[vl_List]:=
  Module[{l=Drop[#,-1]&/@vl,l1=Drop[#,1]&/@vl,mesh},
    mesh={Drop[l,-1],Drop[l1,-1],Drop[l1,1],Drop[l,1]};
    Transpose[Flatten[#,1]&/@mesh]]

SurfaceGraphics3D/:
  Graphics3D[SurfaceGraphics3D[vl_List,normals_:{},{opts___}]]:=
  Graphics3D[Polygon/@makeMesh[vl],
    If[$VersionNumber<6,
      {FilterOptions[Graphics3D,opts]},
      {Sequence@@FilterRules[opts,Options@Graphics3D]}
      ]
    ]

SurfaceGraphics3D/:Show[s_SurfaceGraphics3D,opts___]:=Show[Graphics3D[s],opts]

Unprotect@AbsoluteOptions;

SurfaceGraphics3D/:AbsoluteOptions[s_SurfaceGraphics3D]:=
  AbsoluteOptions[Graphics3D[s]]

Protect@AbsoluteOptions;

Format[_SurfaceGraphics3D]="-SurfaceGraphics3D-"

If[Not[rayshade`Private`version\[GreaterEqual]2],Protect[Evaluate[protected]]]

End[]

Protect[ParametricPlot3DtoSurfaceGraphics]

Protect[SurfaceGraphics3D]

EndPackage[]



Begin["rayshade`Private`"]

(* If[rayshade`Private`version\[GreaterEqual]2, *)

makeMesh[vl_List]:=
    Module[{l=vl,l1=RotateLeft/@vl,mesh},
      mesh={l,l1,RotateLeft[l1],RotateLeft[l]};
      mesh=Map[Drop[#,-1]&,mesh,{1,2}];
      Transpose[Flatten[#,1]&/@mesh]];

writeobj["rSurfaceGraphics3D",vl_]:=
    Module[{v,len,g,vec,norms},
      (* Print["SurfaceGraphics3D"]; *)
      v=ReleaseHold[vl];
      If[v==={},Return[]];
      len=Length[v];
      If[len\[LessEqual]2,
        (* without normals:turn into Graphics3D;
          without loss of information; see (1) ; *)
        
        g=Graphics3D[SurfaceGraphics3D`SurfaceGraphics3D[Sequence@@v]];
        writeobj["List",Hold[{g}]];
        Return[];
        ];
      vec=v[[1]];
      norms=v[[2]];
      len=Length[vec];
      If[len>0,
          newline[file];
          
          If[raypov===False,
            
            Write[file,"name gr"<>ToString[grcount]];
            newline[file];
            Write[file,"list /* SurfaceGraphics3D */"];
            
            Scan[triangles[file,#[[1]],#[[2]]]&,
              Transpose[(*Chop@*){makeMesh[vec],makeMesh[norms]}]];
            newline[file];
            Write[file,"end  /* SurfaceGraphics3D */"];
            ,
            
            
            Write[file,
              "#declare gr"<>ToString[grcount]<>
                " = union {  /* SurfaceGraphics3D */"];
            newline[file];
            
            Scan[writeSmoothTriangles[file,#[[1]],#[[2]]]&,(*Chop@*)
                Transpose[{makeMesh[vec],makeMesh[norms]}]];
            newline[file];
            Write[file,"} /* SurfaceGraphics3D */"];
            ];
          
          primcount+=len;
          ++grcount;
          ];
      ];

(* from rayshade.m *)

triangles[
      file_,{a_,b_,c_,d_},{na_,nb_,nc_,nd_}]:=(triangle[file,d,nd,c,nc,a,na];
      triangle[file,b,nb,a,na,c,nc];);

(* is for rayshade Phong-shaded triangle only *)

triangle[file_,p1_,n1_,p2_,n2_,p3_,n3_]:=(
      Write[file,"triangle  "<>surfstore[[Length[surfstore]]]];
      writeNumsFastV[{p1,n1,p2,n2,p3,n3}];
      );

(* Scan[writeNums[file,#]&,{p1,n1,p2,n2,p3,n3}]; *)

(* from POVray.m  smooth only *)

writeVector[file_,txt_:"",r_List]/;Length[r]\[Equal]3:=
    Write[file,txt,"<",Infix[nForm/@r,", "],">"];

writeSmoothTriangles[
      file_,{a_,b_,c_,d_},{na_,nb_,nc_,nd_}]:=(writeSmoothTriangle[file,d,nd,
        c,nc,a,na];
      writeSmoothTriangle[file,b,nb,a,na,c,nc];);

writeSmoothTriangle[file_,p1_,n1_,p2_,n2_,p3_,n3_]:=(
      Write[file,"smooth_triangle {"];
      writeVector[file,"\t  ",p1];
      Scan[writeVector[file,"\t, ",#]&,{n1,p2,n2,p3,n3}] ;
      Write[file,surfstore[[Length[surfstore]]]];
      Write[file,"}"];
      );

Print["added SurfaceGraphics3D extention to rayshade"];

(* ]; *)

End[];

