(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16168,        431]*)
(*NotebookOutlinePosition[     16841,        455]*)
(*  CellTagsIndexPosition[     16797,        451]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[":Title:  Surface Graphics", "Text"],

Cell[":Author: Roman E. Maeder", "Text"],

Cell["\<\
:Summary:
  A data type for surfaces in 3D, including normal vectors.  \
\>", "Text"],

Cell[":Context: SurfaceGraphics3D`", "Text"],

Cell[":Package Version: 1.0a", "Text"],

Cell["\<\
:Copyright: Copyright 1994, Roman E. Maeder.

   Permission is granted to use and distribute this file for any purpose
   except for inclusion in commercial software or program collections.
   This copyright notice must remain intact.\
\>", "Text"],

Cell["\<\
:History:
   Version 1.0 for the Mathematica Journal, June 1994.

   Version 1.0a is modified to keep this separate from
   rayshade.m and as well no longer replaces ParametricPlot3D.
   Adds itself to rayshade` if present.\
\>", "Text"],

Cell["\<\
:Keywords: 
  surfaces, graphics, parametric plots\
\>", "Text"],

Cell["\<\
:Source: 
    Maeder, Roman E. 1994. Ray Tracing and Graphics Extensions.
        The Mathematica Journal, 4(3).\
\>", "Text"],

Cell["\<\
:Warning:
   Redefines the function ParametricPlot3D. \
\>", "Text"],

Cell[":Mathematica Version: 2.2", "Text"],

Cell["\<\
:Discussion: 
   may optionally be used together with the package
   Graphics`ParametricPlot3D'.
   The main use of the new graphics data type is for external renderers
   that benefit from normal vectors to produce smooth surfaces.\
\>", "Text"],

Cell[BoxData[
    \(If[$VersionNumber < 
        6, \[IndentingNewLine]BeginPackage["\<SurfaceGraphics3D`\>", \
"\<Utilities`FilterOptions`\>", "\<Graphics`ParametricPlot3D`\>"\
\[IndentingNewLine]], \
\[IndentingNewLine]BeginPackage["\<SurfaceGraphics3D`\>"]\[IndentingNewLine]]\
\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(SurfaceGraphics3D::usage = "\<SurfaceGraphics3D[vertices, (normals,) \
{opts...}] represents a surface with given vertices and normals.  Create with \
ParametricPlot3DtoSurfaceGraphics used instead of ParametricPlot3D or see \
Private`MakeSurface3D.\>"\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(ParametricPlot3DtoSurfaceGraphics::usage = "\<Works as \
ParametricPlot3D[{f}, {u,1,2}, {v,1,2}, opts___ ] but yeilds \
SurfaceGraphics3D object which will work with: Show, Graphics3D, Rayshade.\>"\
\)], "Input",
  InitializationCell->True],

Cell["\<\
FIXME:   given
\t\tg=Module[{u,t},ParametricPlot3DtoSurfaceGraphics[
\t\t{u Sin[t], u Cos[t], t/3},{t, 0, 15}, {u, -1, 1}]]
\tt and t$123  ends up defined in Gobal`
\t(same for rayshade>=2 or not)\
\>", "Text"],

Cell[BoxData[
    \(ParametricPlot3DtoSurfaceGraphics[f_, {u_, u0_, u1_}, {v_, v0_, v1_}, 
        opts___] := 
      Module[{plotpoints, ndu, 
          ndv}, \[IndentingNewLine]plotpoints = \(PlotPoints /. {opts}\) /. 
            Options[ParametricPlot3D]; 
        If[Head[plotpoints] =!= List, 
          plotpoints = {plotpoints, 
              plotpoints}]; \[IndentingNewLine]plotpoints = 
          plotpoints /. Automatic \[Rule] 15; \[IndentingNewLine]ndu = 
          N[\((u1 - u0)\)/\((plotpoints[\([1]\)] - 
                  1)\)]; \[IndentingNewLine]ndv = 
          N[\((v1 - v0)\)/\((plotpoints[\([2]\)] - 
                  1)\)]; \[IndentingNewLine]SurfaceGraphics3D`Private`\
MakeSurface3D[f, {u, u0, u1, ndu}, {v, v0, v1, ndv}, opts]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Unprotect[ParametricPlot3DtoSurfaceGraphics]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Begin["\<`Private`\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(If[Not[rayshade`Private`version \[GreaterEqual] 2], 
      protected = Unprotect[ParametricPlot3D]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*overload\ ParametricPlot3D[]\ to\ produce\ SurfaceGraphics3D*) \)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(If[Not[rayshade`Private`version \[GreaterEqual] 2], 
      ParametricPlot3D[f_, {u_, u0_, u1_}, {v_, v0_, v1_}, opts___] := 
        Module[{plotpoints, ndu, ndv}, 
          plotpoints = \(PlotPoints /. {opts}\) /. 
              Options[ParametricPlot3D]; \[IndentingNewLine]If[
            Head[plotpoints] =!= List, 
            plotpoints = {plotpoints, 
                plotpoints}]; \[IndentingNewLine]plotpoints = 
            plotpoints /. Automatic \[Rule] 15; \[IndentingNewLine]ndu = 
            N[\((u1 - u0)\)/\((plotpoints[\([1]\)] - 
                    1)\)]; \[IndentingNewLine]ndv = 
            N[\((v1 - v0)\)/\((plotpoints[\([2]\)] - 
                    1)\)]; \[IndentingNewLine]MakeSurface3D[
            f, {u, u0, u1, ndu}, {v, v0, v1, ndv}, opts]]]\)], "Input",
  InitializationCell->True],

Cell["\<\
The above leaves opts empty and no way to find.  To avoid eval of f \
fun again and because we dont have a PlotRange finder for AbsoluteOptions to \
use: comprimise by use of Graphics3D in Options, which has caveat it will \
makemesh each Options check.\
\>", "Text"],

Cell[BoxData[
    \( (*compute\ normals*) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeSurface3D[f : {_, _, _}, ur : {u_, _, _, _}, vr : {v_, _, _, _}, 
        opts___] := 
      Module[{n, coords, surf, normals}, 
        n = cross[D[f, v], D[f, u]]; \ \ \ \  (*normal\ vectors*) coords = 
          Table[N[{f, n}], ur, vr]; \[IndentingNewLine]{surf, normals} = 
          Transpose[coords, {3, 2, 1}]; \[IndentingNewLine]If[
          And @@ \(NumberQ /@ Flatten[normals]\), 
          SurfaceGraphics3D[surf, normals, {opts}],  (*\ 
            couldnt\ compute\ normals\ \
*) \[IndentingNewLine]SurfaceGraphics3D[surf, {opts}]]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\ strange\ functions; \ 
      Do\ not\ attempt\ to\ produce\ normals;\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeSurface3D[f_, ur : {u_, _, _, _}, vr : {v_, _, _, _}, opts___] := 
      Module[{surf}, 
        surf = Table[N[f], ur, vr]; \[IndentingNewLine]SurfaceGraphics3D[
          surf, {opts}]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(cross[{ax_, ay_, az_}, {bx_, by_, bz_}] := {ay\ bz - az\ by, 
        az\ bx - ax\ bz, ax\ by - ay\ bx}\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\ 
      converts\ to\ Graphics3D\ if\ touched\ within\ Show\ or\ Graphics3D\ *) \
\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(makeMesh[vl_List] := 
      Module[{l = \(Drop[#, \(-1\)] &\) /@ vl, l1 = \(Drop[#, 1] &\) /@ vl, 
          mesh}, mesh = {Drop[l, \(-1\)], Drop[l1, \(-1\)], Drop[l1, 1], 
            Drop[l, 1]}; \[IndentingNewLine]Transpose[\(Flatten[#, 1] &\) /@ 
            mesh]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(SurfaceGraphics3D /: 
      Graphics3D[SurfaceGraphics3D[vl_List, normals_: {}, {opts___}]] := 
      Graphics3D[
        Polygon /@ 
          makeMesh[vl], \[IndentingNewLine]If[$VersionNumber < 
            6, \[IndentingNewLine]{FilterOptions[Graphics3D, 
              opts]}, \[IndentingNewLine]{Sequence @@ 
              FilterRules[opts, 
                Options@
                  Graphics3D]}\[IndentingNewLine]]\[IndentingNewLine]]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(SurfaceGraphics3D /: Show[s_SurfaceGraphics3D, opts___] := 
      Show[Graphics3D[s], opts]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Unprotect@AbsoluteOptions;\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(SurfaceGraphics3D /: AbsoluteOptions[s_SurfaceGraphics3D] := 
      AbsoluteOptions[Graphics3D[s]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Protect@AbsoluteOptions;\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Format[_SurfaceGraphics3D] = "\<-SurfaceGraphics3D-\>"\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(If[Not[rayshade`Private`version \[GreaterEqual] 2], 
      Protect[Evaluate[protected]]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(End[]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Protect[ParametricPlot3DtoSurfaceGraphics]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Protect[SurfaceGraphics3D]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(EndPackage[]\)], "Input",
  InitializationCell->True],

Cell["\<\
this adds SurfaceGraphics3D to rayshade.nb.m v2.0
\tslightly adjusted from rayshade.m v1.0
\tit will break rayshade v 1.0 thus the test
btw: despite the care taken this doesn't work between BeginPackage and \
EndPackage\
\>", "Text"],

Cell[BoxData[
    \(Begin["\<rayshade`Private`\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \( (*\ \(If\)\([\)\(\(rayshade`Private`version \[GreaterEqual] 
          2\)\(,\)\)\(\ \)*) \[IndentingNewLine]\[IndentingNewLine]\(makeMesh[
          vl_List] := 
        Module[{l = vl, l1 = RotateLeft /@ vl, mesh}, 
          mesh = {l, l1, RotateLeft[l1], 
              RotateLeft[l]}; \[IndentingNewLine]mesh = 
            Map[Drop[#, \(-1\)] &, 
              mesh, {1, 
                2}]; \[IndentingNewLine]Transpose[\(Flatten[#, 1] &\) /@ 
              mesh]];\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(writeobj["\<rSurfaceGraphics3D\>", 
          vl_] := \[IndentingNewLine]Module[{v, len, g, vec, 
            norms}, \[IndentingNewLine] (*\ \(Print["\<SurfaceGraphics3D\>"];\
\)\ *) \[IndentingNewLine]v = ReleaseHold[vl]; \[IndentingNewLine]If[
            v === {}, Return[]]; \[IndentingNewLine]len = 
            Length[v]; \[IndentingNewLine]If[
            len \[LessEqual] 2, \[IndentingNewLine] (*\ 
              without\ \(normals : 
                  turn\ into\ Graphics3D\); \[IndentingNewLine]without\ loss\ \
of\ information; \ see\ \((1)\)\ ;\ *) \[IndentingNewLine]g = 
              Graphics3D[
                SurfaceGraphics3D`SurfaceGraphics3D[
                  Sequence @@ v]]; \[IndentingNewLine]writeobj["\<List\>", 
              Hold[{g}]]; \
\[IndentingNewLine]\(Return[];\)\[IndentingNewLine]]; \[IndentingNewLine]vec \
= v[\([1]\)]; \[IndentingNewLine]norms = v[\([2]\)]; \[IndentingNewLine]len = 
            Length[vec]; \[IndentingNewLine]\(If[
              len > 0, \[IndentingNewLine]newline[
                file]; \[IndentingNewLine]\[IndentingNewLine]If[
                raypov === False, \[IndentingNewLine]\[IndentingNewLine]Write[
                  file, "\<name gr\>" <> 
                    ToString[grcount]]; \[IndentingNewLine]newline[
                  file]; \[IndentingNewLine]Write[
                  file, "\<list /* SurfaceGraphics3D */\>"]; \
\[IndentingNewLine]Scan[triangles[file, #[\([1]\)], #[\([2]\)]] &, 
                  Transpose[ (*\(Chop\)\(@\)*) {makeMesh[vec], 
                      makeMesh[norms]}]]; \[IndentingNewLine]newline[
                  file]; \[IndentingNewLine]Write[
                  file, "\<end  /* SurfaceGraphics3D */\>"];\
\[IndentingNewLine], \[IndentingNewLine]\[IndentingNewLine]Write[
                  file, "\<#declare gr\>" <> 
                    ToString[
                      grcount] <> "\< = union {  /* SurfaceGraphics3D */\>"]; \
\[IndentingNewLine]newline[file]; \[IndentingNewLine]Scan[
                  writeSmoothTriangles[
                      file, #[\([1]\)], #[\([2]\)]] &,  (*\(Chop\)\(@\)*) 
                    Transpose[{makeMesh[vec], 
                      makeMesh[norms]}]]; \[IndentingNewLine]newline[
                  file]; \[IndentingNewLine]Write[
                  file, "\<} /* SurfaceGraphics3D \
*/\>"];\[IndentingNewLine]]; \[IndentingNewLine]\[IndentingNewLine]primcount += 
                len; \[IndentingNewLine]\(++grcount\);\[IndentingNewLine]];\)\
\[IndentingNewLine]];\)\[IndentingNewLine]\[IndentingNewLine] (*\ 
      from\ rayshade . m\ *) \[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(triangles[
          file_, {a_, b_, c_, d_}, {na_, nb_, nc_, nd_}] := \((triangle[file, 
            d, nd, c, nc, a, na]; 
          triangle[file, b, nb, a, na, c, 
            nc];)\);\)\[IndentingNewLine]\[IndentingNewLine] (*\ 
      is\ for\ rayshade\ Phong - 
        shaded\ triangle\ only\ *) \[IndentingNewLine]\), \
"\[IndentingNewLine]", 
    \(\(triangle[file_, p1_, n1_, p2_, n2_, p3_, 
          n3_] := \((\[IndentingNewLine]Write[
            file, "\<triangle  \>" <> 
              surfstore[\([Length[
                    surfstore]]\)]]; \[IndentingNewLine]writeNumsFastV[{p1, 
              n1, p2, n2, p3, 
              n3}];\[IndentingNewLine])\);\)\[IndentingNewLine]\
\[IndentingNewLine] (*\ \(Scan[
          writeNums[file, #] &, {p1, n1, p2, n2, p3, 
            n3}];\)\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
      from\ POVray . 
          m\ \ smooth\ only\ *) \[IndentingNewLine]\), "\[IndentingNewLine]", \

    \(\(writeVector[file_, txt_: "\<\>", r_List] /; Length[r] \[Equal] 3 := 
        Write[file, txt, "\<<\>", 
          Infix[nForm /@ 
              r, "\<, \>"], "\<>\>"];\)\[IndentingNewLine]\), "\
\[IndentingNewLine]", 
    \(\(writeSmoothTriangles[
          file_, {a_, b_, c_, d_}, {na_, nb_, nc_, 
            nd_}] := \((writeSmoothTriangle[file, d, nd, c, nc, a, 
            na]; \[IndentingNewLine]writeSmoothTriangle[file, b, nb, a, na, 
            c, nc];)\);\)\n\), "\[IndentingNewLine]", 
    \(\(writeSmoothTriangle[file_, p1_, n1_, p2_, n2_, p3_, 
          n3_] := \((\[IndentingNewLine]Write[
            file, "\<smooth_triangle {\>"]; \[IndentingNewLine]writeVector[
            file, "\<\t  \>", p1]; \[IndentingNewLine]Scan[
            writeVector[file, "\<\t, \>", #] &, {n1, p2, n2, p3, 
              n3}]\ ; \[IndentingNewLine]Write[file, 
            surfstore[\([Length[surfstore]]\)]]; \[IndentingNewLine]Write[
            file, "\<}\>"];\[IndentingNewLine])\);\)\n\), \
"\[IndentingNewLine]", 
    \(\(Print["\<added SurfaceGraphics3D extention to rayshade\>"];\)\
\[IndentingNewLine]\[IndentingNewLine] (*\(\(\(\ \)\(]\)\);\)\ *) \)}], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(End[];\)\)], "Input",
  InitializationCell->True],

Cell["\<\
----------------------------
(1)  I consider it a fixme using
\tSurfaceGraphics3D`SurfaceGraphics3D[]
\tnot just   SurfaceGraphics3D[]
i'm unsure why it's needed since SurfaceGraphics3D` should exist already - \
yet System`Graphics3D isn't needed.  This is what I was expecting:
\tex:
\tIn[]:=x=5;
\tIn[]:=Begin[\"a`p`\"];
\tIn[]:=x
\tOut[]=5
\tIn[]:=End[];\
\>", "Text"]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{568, 600},
WindowMargins->{{79, Automatic}, {Automatic, 66}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 41, 0, 32, "Text"],
Cell[1761, 51, 40, 0, 32, "Text"],
Cell[1804, 53, 95, 3, 50, "Text"],
Cell[1902, 58, 44, 0, 32, "Text"],
Cell[1949, 60, 38, 0, 32, "Text"],
Cell[1990, 62, 258, 6, 104, "Text"],
Cell[2251, 70, 247, 7, 122, "Text"],
Cell[2501, 79, 74, 3, 50, "Text"],
Cell[2578, 84, 136, 4, 68, "Text"],
Cell[2717, 90, 78, 3, 50, "Text"],
Cell[2798, 95, 41, 0, 32, "Text"],
Cell[2842, 97, 256, 6, 104, "Text"],
Cell[3101, 105, 322, 7, 107, "Input",
  InitializationCell->True],
Cell[3426, 114, 313, 5, 91, "Input",
  InitializationCell->True],
Cell[3742, 121, 260, 5, 75, "Input",
  InitializationCell->True],
Cell[4005, 128, 220, 6, 104, "Text"],
Cell[4228, 136, 797, 15, 187, "Input",
  InitializationCell->True],
Cell[5028, 153, 105, 2, 27, "Input",
  InitializationCell->True],
Cell[5136, 157, 83, 2, 27, "Input",
  InitializationCell->True],
Cell[5222, 161, 160, 3, 43, "Input",
  InitializationCell->True],
Cell[5385, 166, 129, 3, 27, "Input",
  InitializationCell->True],
Cell[5517, 171, 838, 15, 171, "Input",
  InitializationCell->True],
Cell[6358, 188, 277, 5, 68, "Text"],
Cell[6638, 195, 83, 2, 27, "Input",
  InitializationCell->True],
Cell[6724, 199, 612, 11, 155, "Input",
  InitializationCell->True],
Cell[7339, 212, 139, 3, 27, "Input",
  InitializationCell->True],
Cell[7481, 217, 252, 5, 59, "Input",
  InitializationCell->True],
Cell[7736, 224, 164, 3, 43, "Input",
  InitializationCell->True],
Cell[7903, 229, 147, 4, 27, "Input",
  InitializationCell->True],
Cell[8053, 235, 330, 6, 75, "Input",
  InitializationCell->True],
Cell[8386, 243, 506, 12, 139, "Input",
  InitializationCell->True],
Cell[8895, 257, 152, 3, 43, "Input",
  InitializationCell->True],
Cell[9050, 262, 91, 2, 27, "Input",
  InitializationCell->True],
Cell[9144, 266, 159, 3, 43, "Input",
  InitializationCell->True],
Cell[9306, 271, 89, 2, 27, "Input",
  InitializationCell->True],
Cell[9398, 275, 115, 2, 27, "Input",
  InitializationCell->True],
Cell[9516, 279, 149, 3, 27, "Input",
  InitializationCell->True],
Cell[9668, 284, 66, 2, 27, "Input",
  InitializationCell->True],
Cell[9737, 288, 103, 2, 27, "Input",
  InitializationCell->True],
Cell[9843, 292, 87, 2, 27, "Input",
  InitializationCell->True],
Cell[9933, 296, 73, 2, 27, "Input",
  InitializationCell->True],
Cell[10009, 300, 243, 6, 86, "Text"],
Cell[10255, 308, 91, 2, 27, "Input",
  InitializationCell->True],
Cell[10349, 312, 5357, 98, 1419, "Input",
  InitializationCell->True],
Cell[15709, 412, 71, 2, 27, "Input",
  InitializationCell->True],
Cell[15783, 416, 381, 13, 230, "Text"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

