(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    783499,      16908]
NotebookOptionsPosition[    779413,      16774]
NotebookOutlinePosition[    780278,      16804]
CellTagsIndexPosition[    780235,      16801]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["LevelScheme examples",
 FontFamily->"Times New Roman",
 FontSize->36]], "Text",
 FontSize->10],

Cell[TextData[{
 StyleBox["M. A. Caprio, ", "SmallText",
  FontFamily->"Times New Roman",
  FontSize->12],
 "Department of Physics, University of Notre Dame"
}], "Text",
 CellChangeTimes->{{3.39552255203125*^9, 3.3955225581875*^9}, {
   3.396878383875*^9, 3.39687838403125*^9}, 3.397586352671875*^9, {
   3.39854548165625*^9, 3.398545486203125*^9}, {3.430247945015625*^9, 
   3.430247947875*^9}, {3.436820309328125*^9, 3.436820313328125*^9}, {
   3.443996368375*^9, 3.443996375046875*^9}, {3.47108965090625*^9, 
   3.471089655984375*^9}, {3.49722506396875*^9, 3.4972250644375*^9}}],

Cell[CellGroupData[{

Cell["Package initialization", "Section"],

Cell[TextData[{
 "If you have not already loaded the LevelScheme package since starting this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you must do so now.  See the user guide for information first on \
installing the package and then on loading it at the beginning of each ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session."
}], "Text",
 CellChangeTimes->{{3.4921245209375*^9, 3.492124756234375*^9}, {
  3.492124799609375*^9, 3.492124838453125*^9}, {3.495659733515625*^9, 
  3.495659808359375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", "\"\<LevelScheme`\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.492124284765625*^9, 3.49212429721875*^9}, 
   3.492124551328125*^9}],

Cell[BoxData[
 FrameBox[
  TemplateBox[{TagBox[
     GridBox[{{
        RowBox[{
         "LevelScheme", " ", "scientific", " ", "figure", " ", "preparation", 
          " ", "system"}]}, {
        RowBox[{
          RowBox[{"M", ".", " ", "A", ".", " ", "Caprio"}], ",", " ", 
          RowBox[{"Department", " ", "of", " ", "Physics"}], ",", " ", 
          RowBox[{"University", " ", "of", " ", "Notre", " ", "Dame"}]}]}, {
        TemplateBox[{"\"Comput. Phys. Commun. \"", 
          TagBox[
           StyleBox["\"171\"", FontWeight -> "Bold"], 
           StyleForm[#, FontWeight -> "Bold"]& ], "\", 107 (2005)\""}, 
         "RowDefault"]}, {
        RowBox[{"Version", " ", "3.52", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"September", " ", "20"}], ",", " ", "2011"}], ")"}]}]}, {
        RowBox[{
          ButtonBox[
           StyleBox[
            RowBox[{"View", " ", "color", " ", "palette"}], FontFamily -> 
            "Times"], Active -> True, Appearance -> {Automatic, "DialogBox"}, 
           ButtonFunction :> (NamedColors`NamedColorPalette[]& ), ButtonNote -> 
           "Named color palette", Evaluator -> Automatic, ImageSize -> 
           Automatic], 
          TagBox[
           ButtonBox[
            StyleBox[
             RowBox[{"Visit", " ", "home", " ", "page"}], FontFamily -> 
             "Times"], Active -> True, Appearance -> {Automatic, "DialogBox"},
             ButtonData :> {
              URL[
              "http://scidraw.nd.edu/levelscheme/landing/levelscheme-3.52.\
html"], None}, ButtonFunction :> (FrontEndExecute[{
               FrontEnd`NotebookLocate[#2]}]& ), ButtonNote -> 
            "http://scidraw.nd.edu/levelscheme/landing/levelscheme-3.52.html",
             ImageSize -> Automatic], DisplayForm]}]}}, 
      GridBoxAlignment -> {
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}], DisplayForm],"\"  \"",GraphicsBox[{{
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 200.}, {0.9, 200.}}]}, {
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 116.93046875}, {0.1536723484848485, 116.93046875}, {
        0.2610170454545455, 100.}, {0.7389829545454545, 100.}, {
        0.8463276515151515, 116.93046875}, {0.9, 116.93046875}}]}, {
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 0.}, {0.9, 0.}}], {
        GrayLevel[0.5], 
        Opacity[1], 
        PolygonBox[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {
         0.6828827683115883, 106.35880620986916`}, {0.675461586050597, 
         105.04604015402995`}, {0.73, 100.}, {0.7595683183418321, 
         119.92405545354092`}, {0.7521471360808408, 118.61128939770171`}, {
         0.6707584254785426, 200.}}]}, {
        GrayLevel[0], 
        AbsoluteThickness[1], 
        Opacity[1], 
        Dashing[{}], 
        LineBox[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {
         0.6828827683115883, 106.35880620986916`}, {0.675461586050597, 
         105.04604015402995`}, {0.73, 100.}, {0.7595683183418321, 
         119.92405545354092`}, {0.7521471360808408, 118.61128939770171`}, {
         0.6707584254785426, 200.}, {0.6300000000000001, 200.}}], {
         GrayLevel[0.5], 
         Opacity[1], 
         PolygonBox[{{0.2700000000000001, 100.}, {0.22924157452145752`, 
          100.}, {0.3228827683115884, 6.358806209869151}, {0.3154615860505971,
           5.046040154029939}, {0.37000000000000005`, 0.}, {
          0.3995683183418322, 19.924055453540902`}, {0.39214713608084084`, 
          18.61128939770171}, {0.3107584254785426, 100.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.2700000000000001, 100.}, {0.22924157452145752`, 100.}, {
          0.3228827683115884, 6.358806209869151}, {0.3154615860505971, 
          5.046040154029939}, {0.37000000000000005`, 0.}, {0.3995683183418322,
           19.924055453540902`}, {0.39214713608084084`, 18.61128939770171}, {
          0.3107584254785426, 100.}, {0.2700000000000001, 100.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 20.}, {0.529, 20.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 21.3}, {0.5589999999999999, 21.3}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 24.333333333333336`}, {0.589, 
          24.333333333333336`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 29.1}, {0.619, 29.1}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 35.6}, {0.649, 35.6}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 43.833333333333336`}, {0.679, 
          43.833333333333336`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.681, 53.8}, {0.709, 53.8}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.711, 65.5}, {0.739, 65.5}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.741, 78.93333333333334}, {0.769, 78.93333333333334}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 33.}, {0.529, 33.}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 34.3}, {0.5589999999999999, 34.3}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 37.333333333333336`}, {0.589, 
          37.333333333333336`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 42.099999999999994`}, {0.619, 
          42.099999999999994`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 48.599999999999994`}, {0.649, 
          48.599999999999994`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 56.833333333333336`}, {0.679, 
          56.833333333333336`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.681, 66.8}, {0.709, 66.8}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.711, 78.5}, {0.739, 78.5}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 47.761071567264665`}, {0.529, 
          47.761071567264665`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 49.24022665797266}, {0.5589999999999999, 
          49.24022665797266}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 52.691588536291334`}, {0.589, 
          52.691588536291334`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 58.115157202220665`}, {0.619, 
          58.115157202220665`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 65.51093265576067}, {0.649, 65.51093265576067}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 74.87891489691134}, {0.679, 74.87891489691134}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 56.07894755622853}, {0.529, 56.07894755622853}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 57.38554745213195}, {0.5589999999999999, 
          57.38554745213195}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 60.434280542573276`}, {0.589, 
          60.434280542573276`}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 65.22514682755249}, {0.619, 65.22514682755249}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 71.75814630706962}, {0.649, 71.75814630706962}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 80.03327898112465}, {0.679, 80.03327898112465}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 60.981197953135855`}, {0.529, 
          60.981197953135855`}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 62.04756255970392}, {0.5589999999999999, 
          62.04756255970392}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 64.53574664169608}, {0.589, 
          64.53574664169608}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 68.44575019911233}, {0.619, 68.44575019911233}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 73.77757323195266}, {0.649, 73.77757323195266}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 80.53121574021708}, {0.679, 80.53121574021708}}], 
         InsetBox[
          TagBox["\"LevelScheme\"", DisplayForm], {0.1, 200.}, {-1, -0.75}, 
          Automatic, {1, 0}, 
          BaseStyle -> {
           FontFamily -> "Times", FontSize -> 10, FontSlant -> "Plain", 
            FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
            GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}]}}}}, 
     AspectRatio -> 0.7727272727272727, Axes -> False, Background -> 
     RGBColor[0.889996, 0.509995, 0.089999], 
     BaseStyle -> {
      FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", 
       FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
       GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}, 
     DisplayFunction -> Identity, Frame -> False, 
     FrameLabel -> {None, None, None, None}, FrameStyle -> Directive[{
        GrayLevel[0], 
        Opacity[1], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{}]}], FrameTicks -> None, 
     ImageSize -> {93.17647058823529, 72.}, 
     PlotRange -> {{-0.0001, 1.0001}, {-50.0325, 275.0325}}, Ticks -> None]},
   "RowDefault"],
  Background->GrayLevel[0.85],
  FrameMargins->10,
  FrameStyle->None,
  StripOnInput->False]], "Print",
 CellChangeTimes->{3.507513552078125*^9, 3.5668365037297225`*^9, 
  3.5668373143542337`*^9, 3.5668373936949615`*^9, 3.566837631340436*^9, 
  3.5668376785605307`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["First example from User's Guide", "Section",
 CellChangeTimes->{{3.491258926390625*^9, 3.491258929953125*^9}, {
  3.49125896034375*^9, 3.491258967515625*^9}, {3.491259018953125*^9, 
  3.4912590219375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"Thickness", "\[Rule]", "3"}], ",", 
       RowBox[{"Color", "\[Rule]", "Red"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"ArrowType", "\[Rule]", "ShapeArrow"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "LightGray"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev1", ",", "0", ",", "2", ",", "0"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev2", ",", "1", ",", "2", ",", "100"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev3", ",", "0", ",", "2", ",", "200"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev2", ",", "0.5", ",", "lev1", ",", "0.9", ",", 
       RowBox[{"Width", "\[Rule]", "10"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev3", ",", "0.5", ",", "lev1", ",", "0.5", ",", 
       RowBox[{"Width", "\[Rule]", "20"}]}], "]"}]}], "\[IndentingNewLine]", 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "210"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.491258957328125*^9, 3.491258974*^9}, 
   3.49125901271875*^9},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 1.7763568394002505`*^-15}, {1.9, 
     1.7763568394002505`*^-15}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.1, 100.}, {1.9, 100.}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 200.}, {1.9, 200.}}], 
    {GrayLevel[0.85], Opacity[1], 
     PolygonBox[{{1.5, 100.}, {1.444518291800332, 100.}, {0.8919614131335113, 
      7.9071868888632135`}, {0.8687731817878713, 9.590652484556676}, {
      0.8999999999999999, 1.7763568394002505`*^-15}, {0.9924437489646176, 
      0.6121693075248942}, {0.9692555176189778, 2.2956349032183567`}, {
      1.555481708199668, 100.}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{1.5, 100.}, {1.444518291800332, 100.}, {
      0.8919614131335113, 7.9071868888632135`}, {0.8687731817878713, 
      9.590652484556676}, {0.8999999999999999, 1.7763568394002505`*^-15}, {
      0.9924437489646176, 0.6121693075248942}, {0.9692555176189778, 
      2.2956349032183567`}, {1.555481708199668, 100.}, {1.5, 100.}}], 
     {GrayLevel[0.85], Opacity[1], 
      PolygonBox[{{0.5, 200.}, {0.40738888888888886`, 200.}, {
       0.407388888888889, 6.112333333333334}, {0.3796055555555557, 
       6.112333333333334}, {0.5000000000000001, 1.7763568394002505`*^-15}, {
       0.6203944444444445, 6.112333333333334}, {0.5926111111111112, 
       6.112333333333334}, {0.592611111111111, 200.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.5, 200.}, {0.40738888888888886`, 200.}, {
       0.407388888888889, 6.112333333333334}, {0.3796055555555557, 
       6.112333333333334}, {0.5000000000000001, 1.7763568394002505`*^-15}, {
       0.6203944444444445, 6.112333333333334}, {0.5926111111111112, 
       6.112333333333334}, {0.592611111111111, 200.}, {0.5, 200.}}]}}}},
  AspectRatio->1,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{216, 216},
  PlotRange->{{-0.0002, 2.0002}, {-10.022, 210.022}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.491259013453125*^9, 3.497225071125*^9, 
  3.50751355265625*^9, 3.566836505973839*^9, 
  3.566837678750531*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Another simple level scheme", "Section",
 CellChangeTimes->{{3.49916749078125*^9, 3.499167494640625*^9}, {
  3.499167591515625*^9, 3.499167592125*^9}}],

Cell["\<\
Notice the use of Table and formulas to calculate the level energies.  This \
example also illustrates the alternate syntax for labeling levels (with Tag) \
and specifying transition arrow endpoint placement (with EndPositions).\
\>", "Text",
 CellChangeTimes->{{3.49916750065625*^9, 3.4991675683125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeObject", ",", 
       RowBox[{"FontSize", "\[Rule]", "13"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"OffsetL", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", "1"}], ",", "0"}], "}"}]}], ",", 
       RowBox[{"OffsetR", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ",", 
       RowBox[{"Thickness", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "bands", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Lev", "[", 
        RowBox[{"0", ",", "1", ",", 
         RowBox[{"J", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"J", "+", "1"}], ")"}], "/", "6"}], "*", "100"}], ",", 
         RowBox[{"LabL", "\[Rule]", 
          RowBox[{"LabelJiP", "[", 
           RowBox[{"J", ",", "1"}], "]"}]}], ",", 
         RowBox[{"Tag", "\[Rule]", 
          RowBox[{"lev", "[", 
           RowBox[{"J", ",", "1"}], "]"}]}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"J", ",", "0", ",", "6", ",", "2"}], "}"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOrigin", "[", "1.5", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"0", ",", "1", ",", "1000", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJiP", "[", 
         RowBox[{"2", ",", "2"}], "]"}]}], ",", 
       RowBox[{"Tag", "\[Rule]", 
        RowBox[{"lev", "[", 
         RowBox[{"2", ",", "2"}], "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOrigin", "[", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"BandLabel", "[", 
      RowBox[{
       RowBox[{"lev", "[", 
        RowBox[{"0", ",", "1"}], "]"}], ",", "\"\<\!\(\*
StyleBox[\"K\",
FontSlant->\"Italic\"]\)=0\>\""}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BandLabel", "[", 
      RowBox[{
       RowBox[{"lev", "[", 
        RowBox[{"2", ",", "2"}], "]"}], ",", "\"\<\!\(\*
StyleBox[\"K\",
FontSlant->\"Italic\"]\)=2\>\""}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "transitions", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Trans", "[", 
        RowBox[{
         RowBox[{"lev", "[", 
          RowBox[{"J", ",", "1"}], "]"}], ",", 
         RowBox[{"lev", "[", 
          RowBox[{
           RowBox[{"J", "-", "2"}], ",", "1"}], "]"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"J", ",", "2", ",", "6", ",", "2"}], "}"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{
       RowBox[{"lev", "[", 
        RowBox[{"2", ",", "2"}], "]"}], ",", 
       RowBox[{"lev", "[", 
        RowBox[{"2", ",", "1"}], "]"}], ",", 
       RowBox[{"EndPositions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.25", ",", "0.9"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"panel", " ", "label"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.8", ",", "0.3"}], "}"}], ",", 
       RowBox[{"Isotope", "[", 
        RowBox[{"100", ",", "\"\<X\>\""}], "]"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "16"}]}], "]"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ExtendRange", "\[Rule]", "0.2"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.40243520075*^9, 3.40243524146875*^9}, {
  3.402435289734375*^9, 3.402435537453125*^9}, {3.402435570578125*^9, 
  3.402435759390625*^9}, {3.40243588296875*^9, 3.40243591275*^9}, {
  3.40829301315625*^9, 3.40829302334375*^9}, {3.49916339290625*^9, 
  3.49916376359375*^9}, {3.499163794265625*^9, 3.49916402471875*^9}, {
  3.499165030234375*^9, 3.49916507584375*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, -2.842170943040401*^-14}, {
     0.8999999999999999, -2.842170943040401*^-14}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 99.99999999999996}, {
     0.8999999999999999, 99.99999999999996}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 333.33333333333326`}, {
     0.8999999999999999, 333.33333333333326`}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 699.9999999999999}, {
     0.8999999999999999, 699.9999999999999}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.5999999999999999`, 999.9999999999999}, {
     2.3999999999999995`, 999.9999999999999}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.49999999999999994`, 100.}, {
     0.49999999999999994`, -2.842170943040401*^-14}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5388966666666666, 38.896666666666675`}, {
     0.49999999999999994`, -2.842170943040401*^-14}, {0.46110333333333337`, 
     38.896666666666675`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.49999999999999994`, 333.33333333333326`}, {
     0.49999999999999994`, 100.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5388966666666666, 138.8966666666667}, {
     0.49999999999999994`, 100.}, {0.46110333333333337`, 
     138.8966666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.49999999999999994`, 699.9999999999999}, {
     0.49999999999999994`, 333.33333333333326`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5388966666666666, 372.2299999999999}, {
     0.49999999999999994`, 333.33333333333326`}, {0.46110333333333337`, 
     372.2299999999999}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.7500000000000004`, 999.9999999999999}, {
     0.8999999999999997, 100.00000000000011`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9683905020482892, 126.8676972332567}, {
     0.8999999999999997, 100.00000000000011`}, {0.898045985655763, 
     143.47681915926995`}}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubsuperscriptBox["0", "1", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->13,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999999, -2.842170943040401*^-14}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubsuperscriptBox["2", "1", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->13,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999999, 99.99999999999996}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubsuperscriptBox["4", "1", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->13,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999999, 333.33333333333326`}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubsuperscriptBox["6", "1", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->13,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999999, 699.9999999999999}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubsuperscriptBox["2", "2", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->13,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.5999999999999999`, 999.9999999999999}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*\\nStyleBox[\\\"K\\\",\\nFontSlant->\\\"Italic\\\"\
]\\)=0\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->13,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.49999999999999994`, -2.842170943040401*^-14}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*\\nStyleBox[\\\"K\\\",\\nFontSlant->\\\"Italic\\\"\
]\\)=2\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->13,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.9999999999999996`, 999.9999999999999}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{
         TemplateBox[{"\"\"", "\"\"", "100"}, "Subsuperscript"],
          TemplateBox[{"\"X\"", "\"\"", "\"\""}, "Subsuperscript"]},
         "RowDefault"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->16,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.8401680000000002`, 219.94400000000007`}, {0, 0}, 
     Automatic, {1, 0}]}},
  AspectRatio->1,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{216, 216},
  PlotRange->{{-0.40028, 2.40028}, {-200.14, 1200.14}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.499163982640625*^9, 3.499164025484375*^9}, {
   3.499165031171875*^9, 3.499165036046875*^9}, {3.499165068109375*^9, 
   3.49916507653125*^9}, 3.50751355309375*^9, 3.566836508523842*^9, 
   3.566837678905531*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simple two-panel level scheme", "Section"],

Cell["\<\
Adapted from M. A. Caprio, Ph.D. thesis, Yale University (2003), \
arXiv:nucl-ex/0502004.\
\>", "Text",
 FontSize->8],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Figure", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "set", " ", "default", " ", "styles", " ", "for", " ", "level", " ", 
       "scheme", " ", "objects"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"SetOptions", "[", 
        RowBox[{"SchemeObject", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"SetOptions", "[", 
        RowBox[{"Lev", ",", 
         RowBox[{"NudgeL", "\[Rule]", "1"}], ",", 
         RowBox[{"NudgeR", "\[Rule]", "1"}], ",", 
         RowBox[{"LabR", "\[Rule]", "Automatic"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"Trans", ",", 
        RowBox[{"ArrowType", "\[Rule]", "ShapeArrow"}], ",", 
        RowBox[{"HeadLength", "\[Rule]", "9"}], ",", 
        RowBox[{"HeadLip", "\[Rule]", "10"}], ",", 
        RowBox[{"Width", "\[Rule]", "30"}], ",", "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", "Blue"}], ",", 
        RowBox[{"OrientationC", "\[Rule]", "Horizontal"}], ",", 
        RowBox[{"BackgroundC", "\[Rule]", "Automatic"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"LevelLabel", ",", 
        RowBox[{"Gap", "\[Rule]", "10"}]}], "]"}], ",", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"draw", " ", "cascade", " ", "from", " ", "4"}], "+", " ", 
        "level"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"SetOrigin", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ManualLabel", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".4"}], ",", "850"}], "}"}], ",", "\"\<(a)\>\"", ",", 
        RowBox[{"Offset", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev0", ",", "0", ",", "2", ",", "\"\<0\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev335", ",", "0", ",", "2", ",", "\"\<335\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LevelLabel", "[", 
       RowBox[{"lev335", ",", "Right", ",", "\"\<27 ps\>\""}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev661", ",", "0", ",", "2", ",", "\"\<661\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev747", ",", "0", ",", "2", ",", "\"\<747\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LevelLabel", "[", 
       RowBox[{"lev747", ",", "Right", ",", "\"\<  6 ps\>\"", ",", 
        RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev335", ",", "1.3", ",", "lev0", ",", "Automatic", ",", 
        RowBox[{"FillColor", "\[Rule]", "Gray"}], ",", 
        RowBox[{"LabC", "\[Rule]", "\"\<TIMING\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev747", ",", ".7", ",", "lev335", ",", "Automatic", ",", 
        RowBox[{"FillColor", "\[Rule]", "White"}], ",", 
        RowBox[{"LabC", "\[Rule]", "\"\<GATE\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"draw", " ", "cascade", " ", "from", " ", "0"}], "+", " ", 
        "level"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"SetOrigin", "[", "3.5", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ManualLabel", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".4"}], ",", "850"}], "}"}], ",", "\"\<(b)\>\"", ",", 
        RowBox[{"Offset", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev0", ",", "0", ",", "2", ",", "\"\<0\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev335", ",", "0", ",", "2", ",", "\"\<335\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LevelLabel", "[", 
       RowBox[{"lev335", ",", "Right", ",", "\"\<27 ps\>\""}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev661", ",", "0", ",", "2", ",", "\"\<661\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LevelLabel", "[", 
       RowBox[{"lev661", ",", "Right", ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<\[Tau](\>\"", ",", 
           RowBox[{"hspace", "[", 
            RowBox[{"-", "0.2"}], "]"}], ",", 
           RowBox[{"LabelJiP", "[", 
            RowBox[{"0", ",", "2"}], "]"}], ",", "\"\<)\>\""}], "}"}], "]"}], 
        ",", 
        RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev747", ",", "0", ",", "2", ",", "\"\<747\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev335", ",", "1.3", ",", "lev0", ",", "Automatic", ",", 
        RowBox[{"FillColor", "\[Rule]", "Gray"}], ",", 
        RowBox[{"LabC", "->", "\"\<TIMING\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev661", ",", ".9", ",", "lev335", ",", "Automatic", ",", 
        RowBox[{"FillColor", "\[Rule]", "White"}], ",", 
        RowBox[{"LabC", "->", "\"\<GATE\>\""}]}], "]"}], ","}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".8"}], ",", "6.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "900"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"72", "*", 
      RowBox[{"{", 
       RowBox[{"8", ",", "4"}], "}"}]}]}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.395093707578125*^9, {3.395093919203125*^9, 3.39509391990625*^9}, {
   3.39509411065625*^9, 3.395094113046875*^9}, {3.395094284578125*^9, 
   3.395094292078125*^9}, 3.395095437171875*^9, {3.3955211378125*^9, 
   3.395521138484375*^9}, {3.471089714921875*^9, 3.471089716375*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.10000000000000012`, 1.4210854715202004`*^-14}, {1.9, 
     1.4210854715202004`*^-14}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.10000000000000012`, 335.}, {1.9, 335.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.10000000000000012`, 661.}, {1.9, 661.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.10000000000000012`, 747.}, {1.9, 747.}}], 
    {GrayLevel[0.5], Opacity[1], 
     PolygonBox[{{1.3000000000000003`, 335.0000000000001}, {
      1.1150671875000002`, 335.0000000000001}, {1.1150671875000002`, 
      31.256250000000023`}, {0.9917786458333335, 31.256250000000023`}, {
      1.3000000000000003`, 2.842170943040401*^-14}, {1.608221354166667, 
      31.256250000000023`}, {1.4849328125000003`, 31.256250000000023`}, {
      1.4849328125000003`, 335.0000000000001}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{1.3000000000000003`, 335.0000000000001}, {
      1.1150671875000002`, 335.0000000000001}, {1.1150671875000002`, 
      31.256250000000023`}, {0.9917786458333335, 31.256250000000023`}, {
      1.3000000000000003`, 2.842170943040401*^-14}, {1.608221354166667, 
      31.256250000000023`}, {1.4849328125000003`, 31.256250000000023`}, {
      1.4849328125000003`, 335.0000000000001}, {1.3000000000000003`, 
      335.0000000000001}}], 
     {GrayLevel[1], Opacity[1], 
      PolygonBox[{{0.7, 747.}, {0.5150671874999999, 747.}, {
       0.5150671874999999, 366.25625000000014`}, {0.39177864583333344`, 
       366.25625000000014`}, {0.7000000000000002, 335.0000000000001}, {
       1.0082213541666667`, 366.25625000000014`}, {0.8849328125, 
       366.25625000000014`}, {0.8849328125, 747.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], 
      LineBox[{{0.7, 747.}, {0.5150671874999999, 747.}, {0.5150671874999999, 
       366.25625000000014`}, {0.39177864583333344`, 366.25625000000014`}, {
       0.7000000000000002, 335.0000000000001}, {1.0082213541666667`, 
       366.25625000000014`}, {0.8849328125, 366.25625000000014`}, {
       0.8849328125, 747.}, {0.7, 747.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{3.6000000000000005`, 1.4210854715202004`*^-14}, {5.4, 
       1.4210854715202004`*^-14}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{3.6000000000000005`, 335.}, {5.4, 335.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{3.6000000000000005`, 661.}, {5.4, 661.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{3.6000000000000005`, 747.}, {5.4, 747.}}], 
      {GrayLevel[0.5], Opacity[1], 
       PolygonBox[{{4.800000000000001, 335.0000000000001}, {4.615067187500001,
         335.0000000000001}, {4.615067187500001, 31.256250000000023`}, {
        4.4917786458333335`, 31.256250000000023`}, {4.800000000000001, 
        2.842170943040401*^-14}, {5.108221354166668, 31.256250000000023`}, {
        4.9849328125, 31.256250000000023`}, {4.9849328125, 
        335.0000000000001}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{4.800000000000001, 335.0000000000001}, {
        4.615067187500001, 335.0000000000001}, {4.615067187500001, 
        31.256250000000023`}, {4.4917786458333335`, 31.256250000000023`}, {
        4.800000000000001, 2.842170943040401*^-14}, {5.108221354166668, 
        31.256250000000023`}, {4.9849328125, 31.256250000000023`}, {
        4.9849328125, 335.0000000000001}, {4.800000000000001, 
        335.0000000000001}}], 
       {GrayLevel[1], Opacity[1], 
        PolygonBox[{{4.4, 661.}, {4.215067187500001, 661.}, {
         4.215067187500001, 366.25625000000014`}, {4.091778645833333, 
         366.25625000000014`}, {4.4, 335.0000000000001}, {4.708221354166666, 
         366.25625000000014`}, {4.5849328125, 366.25625000000014`}, {
         4.5849328125, 661.}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{4.4, 661.}, {4.215067187500001, 661.}, {
         4.215067187500001, 366.25625000000014`}, {4.091778645833333, 
         366.25625000000014`}, {4.4, 335.0000000000001}, {4.708221354166666, 
         366.25625000000014`}, {4.5849328125, 366.25625000000014`}, {
         4.5849328125, 661.}, {4.4, 661.}}], InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            StyleBox[
             TagBox["\<\"TIMING\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->20,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->RGBColor[0, 0, 1],
             FontOpacity->1],
            DisplayForm],
           StripOnInput->False,
           ShowContents->False],
          Background->GrayLevel[1],
          ContentPadding->False,
          FrameMargins->None,
          FrameStyle->None,
          StripOnInput->False], {1.3000000000000003`, 167.50000000000003`}, {0, 0},
          Automatic, {1, 0}], InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            StyleBox[
             TagBox["\<\"GATE\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->20,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->RGBColor[0, 0, 1],
             FontOpacity->1],
            DisplayForm],
           StripOnInput->False,
           ShowContents->False],
          Background->GrayLevel[1],
          ContentPadding->False,
          FrameMargins->None,
          FrameStyle->None,
          StripOnInput->False], {0.7, 541.0000000000001}, {0, 0}, Automatic, {
         1, 0}], InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            StyleBox[
             TagBox["\<\"TIMING\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->20,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->RGBColor[0, 0, 1],
             FontOpacity->1],
            DisplayForm],
           StripOnInput->False,
           ShowContents->False],
          Background->GrayLevel[1],
          ContentPadding->False,
          FrameMargins->None,
          FrameStyle->None,
          StripOnInput->False], {4.800000000000001, 167.50000000000003`}, {0, 0},
          Automatic, {1, 0}], InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            StyleBox[
             TagBox["\<\"GATE\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->20,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->RGBColor[0, 0, 1],
             FontOpacity->1],
            DisplayForm],
           StripOnInput->False,
           ShowContents->False],
          Background->GrayLevel[1],
          ContentPadding->False,
          FrameMargins->None,
          FrameStyle->None,
          StripOnInput->False], {4.4, 498.}, {0, 0}, Automatic, {1, 0}], 
        InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"(a)\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {-0.3999999999999999, 850.}, {-1, 1}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            SuperscriptBox["0", "+"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {0.10000000000000012`, 3.4729166666666806`}, {-1, -0.75},
          Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"0\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {1.9, 3.4729166666666806`}, {1, -0.75}, Automatic, {1,
          0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            SuperscriptBox["2", "+"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {0.10000000000000012`, 338.47291666666666`}, {-1, -0.75},
          Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"335\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {1.9, 338.47291666666666`}, {1, -0.75}, Automatic, {1,
          0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"27 ps\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {2.0232885416666666`, 335.}, {-1, 0}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            SuperscriptBox["0", "+"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {0.10000000000000012`, 664.4729166666667}, {-1, -0.75},
          Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"661\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {1.9, 664.4729166666667}, {1, -0.75}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            SuperscriptBox["4", "+"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {0.10000000000000012`, 750.4729166666667}, {-1, -0.75},
          Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"747\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {1.9, 750.4729166666667}, {1, -0.75}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"  6 ps\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->RGBColor[1, 0, 0],
           FontOpacity->1],
          DisplayForm], {2.0232885416666666`, 747.}, {-1, 0}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"TIMING\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->RGBColor[0, 0, 1],
           FontOpacity->1],
          DisplayForm], {1.3000000000000003`, 167.50000000000003`}, {0, 0}, 
         Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"GATE\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->RGBColor[0, 0, 1],
           FontOpacity->1],
          DisplayForm], {0.7, 541.0000000000001}, {0, 0}, Automatic, {1, 0}], 
        InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"(b)\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {3.1000000000000005`, 850.}, {-1, 1}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            SuperscriptBox["0", "+"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {3.6000000000000005`, 3.4729166666666806`}, {-1, -0.75},
          Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"0\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {5.4, 3.4729166666666806`}, {1, -0.75}, Automatic, {1,
          0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            SuperscriptBox["2", "+"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {3.6000000000000005`, 338.47291666666666`}, {-1, -0.75},
          Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"335\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {5.4, 338.47291666666666`}, {1, -0.75}, Automatic, {1,
          0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"27 ps\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {5.523288541666667, 335.}, {-1, 0}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            SuperscriptBox["0", "+"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {3.6000000000000005`, 664.4729166666667}, {-1, -0.75},
          Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"661\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {5.4, 664.4729166666667}, {1, -0.75}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            
            TemplateBox[{
             "\"\[Tau](\"",AdjustmentBox[
              "", BoxMargins -> {{0, -0.2}, {0, 0}}],SubsuperscriptBox[
              "0", "2", "+"],"\")\""},
             "RowDefault"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->RGBColor[1, 0, 0],
           FontOpacity->1],
          DisplayForm], {5.523288541666667, 661.}, {-1, 0}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox[
            SuperscriptBox["4", "+"],
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {3.6000000000000005`, 750.4729166666667}, {-1, -0.75},
          Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"747\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->GrayLevel[0],
           FontOpacity->1],
          DisplayForm], {5.4, 750.4729166666667}, {1, -0.75}, Automatic, {1, 
         0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"TIMING\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->RGBColor[0, 0, 1],
           FontOpacity->1],
          DisplayForm], {4.800000000000001, 167.50000000000003`}, {0, 0}, 
         Automatic, {1, 0}], InsetBox[
         TagBox[
          StyleBox[
           TagBox["\<\"GATE\"\>",
            DisplayForm],
           StripOnInput->False,
           ShowAutoStyles->False,
           SingleLetterItalics->False,
           FontFamily->"Times",
           FontSize->20,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontTracking->"Plain",
           FontColor->RGBColor[0, 0, 1],
           FontOpacity->1],
          DisplayForm], {4.4, 498.}, {0, 0}, Automatic, {1, 0}]}}}}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{576, 288},
  PlotRange->{{-0.80071, 6.30071}, {-100.1, 900.1}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.39509391046875*^9, 3.395093921484375*^9}, 
   3.39509407503125*^9, 3.395094113859375*^9, 3.39509415871875*^9, 
   3.395094198578125*^9, 3.39509428609375*^9, {3.39509543178125*^9, 
   3.395095437921875*^9}, 3.39552075853125*^9, 3.395521151640625*^9, 
   3.39688017678125*^9, 3.430247980625*^9, 3.47108970709375*^9, 
   3.47108974734375*^9, 3.49722507696875*^9, 3.507513553671875*^9, 
   3.566836511213846*^9, 3.5668376791055317`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Level scheme combining various styles of transition arrow", "Section"],

Cell["\<\
Adapted from M. A. Caprio, Ph.D. thesis, Yale University (2003), \
arXiv:nucl-ex/0502004.\
\>", "Text",
 FontSize->8],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Figure", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetOptions", "[", 
       RowBox[{"SchemeObject", ",", 
        RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"Trans", ",", 
        RowBox[{"HeadLength", "\[Rule]", "9"}], ",", " ", 
        RowBox[{"HeadLip", "\[Rule]", "3"}], ",", 
        RowBox[{"ArrowType", "\[Rule]", "ShapeArrow"}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev100", ",", "0", ",", "1", ",", "0", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev112", ",", "0", ",", "1", ",", "556", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev124", ",", "0", ",", "1", ",", "1276", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev122", ",", "1", ",", "2", ",", "1534", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev136", ",", "0", ",", "1", ",", "2110.9", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "6", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev134", ",", "1", ",", "2", ",", "2138", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev133", ",", "2", ",", "3", ",", "2111.5", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "3", "]"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"SetOrigin", "[", "3.25", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev01", ",", "0", ",", "1", ",", "1593", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}], ",", 
        RowBox[{"LabR", "\[Rule]", "Automatic"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ExtensionLine", "[", 
       RowBox[{"lev100", ",", "Right", ",", "2"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev01", ",", ".6", ",", "lev100", ",", "2.4", ",", 
        RowBox[{"Width", "\[Rule]", "20"}], ",", 
        RowBox[{"FillColor", "\[Rule]", "White"}], ",", 
        RowBox[{"LabC", "\[Rule]", 
         RowBox[{"\\(", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Rho]", "\\^", "2"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\\*", 
               RowBox[{"textit", "[", "\"\<E\>\"", "]"}]}], "0"}], ")"}]}], 
           "=", 
           RowBox[{"4.0", 
            RowBox[{
             RowBox[{"(", "15", ")"}], "\[Cross]", 
             RowBox[{"10", "\\^", 
              RowBox[{"-", "3"}]}]}]}]}], "\\)"}]}], ",", 
        RowBox[{"PosnC", "\[Rule]", "0.6"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev01", ",", ".4", ",", "lev112", ",", ".5", ",", 
        RowBox[{"ArrowType", "\[Rule]", "LineArrow"}], ",", 
        RowBox[{"Dashing", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"LabL", "->", "\"\<<0.0004 W.u.\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev01", ",", ".05", ",", "lev122", ",", ".95", ",", 
        RowBox[{"TailBevel", "\[Rule]", "False"}], ",", 
        RowBox[{"Width", "\[Rule]", "20"}], ",", 
        RowBox[{"FillColor", "\[Rule]", "Gray"}], ",", 
        RowBox[{"LabR", "->", "\"\<96(40) W.u.\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"SetOrigin", "[", "4.5", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev02", ",", "0", ",", "1", ",", "1658", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}], ",", 
        RowBox[{"LabR", "\[Rule]", "Automatic"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev02", ",", "0.5", ",", "lev112", ",", "0.8", ",", 
        RowBox[{"Width", "\[Rule]", "3"}], ",", 
        RowBox[{"FillColor", "\[Rule]", "Gray"}], ",", 
        RowBox[{"LabR", "->", "\"\<13(3) W.u.\>\""}], ",", 
        RowBox[{"PosnR", "\[Rule]", "0.2"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev02", ",", "0.6", ",", "lev100", ",", "2.75", ",", 
        RowBox[{"ArrowType", "->", "LineArrow"}], ",", 
        RowBox[{"Dashing", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"LabR", "->", 
         RowBox[{"\\(", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Rho]", "\\^", "2"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\\*", 
               RowBox[{"textit", "[", "\"\<E\>\"", "]"}]}], "0"}], ")"}]}], 
           "<", 
           RowBox[{"0.3", "\[Cross]", 
            RowBox[{"10", "\\^", 
             RowBox[{"-", "3"}]}]}]}], "\\)"}]}], ",", 
        RowBox[{"BufferR", "\[Rule]", "1.5"}]}], "]"}], ","}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "2300"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "False"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"72", "*", 
      RowBox[{"{", 
       RowBox[{"7.5", ",", "4.5"}], "}"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.395095465359375*^9, 3.395095465890625*^9}, {
  3.395520788125*^9, 3.3955208513125*^9}, {3.39552113928125*^9, 
  3.395521139921875*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999988, -1.4210854715202004`*^-14}, {
     0.8999999999999998, -1.4210854715202004`*^-14}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999988, 555.9999999999999}, {
     0.8999999999999998, 555.9999999999999}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999988, 1275.9999999999998`}, {
     0.8999999999999998, 1275.9999999999998`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999996`, 1533.9999999999998`}, {
     1.8999999999999995`, 1533.9999999999998`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999988, 2110.8999999999996`}, {
     0.8999999999999998, 2110.8999999999996`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999996`, 2137.9999999999995`}, {
     1.8999999999999995`, 2137.9999999999995`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.0999999999999996`, 2111.4999999999995`}, {
     2.8999999999999995`, 2111.4999999999995`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.35, 1592.9999999999998`}, {4.15, 
     1592.9999999999998`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.8999999999999998, -1.4210854715202004`*^-14}, {
     2.8999999999999995`, -1.4210854715202004`*^-14}}], 
    {GrayLevel[1], Opacity[1], 
     PolygonBox[{{3.8499999999999996`, 1592.9999999999998`}, {
      3.695579349710255, 1592.9999999999998`}, {2.3296312238609898`, 
      92.3411279462896}, {2.2921404344330822`, 102.04788740478098`}, {
      2.3999999999999995`, -1.8474111129762605`*^-13}, {2.617060609474946, 
      17.922638764521835`}, {2.5795698200470385`, 27.629398223013226`}, {
      4.004420650289744, 1592.9999999999998`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{3.8499999999999996`, 1592.9999999999998`}, {
      3.695579349710255, 1592.9999999999998`}, {2.3296312238609898`, 
      92.3411279462896}, {2.2921404344330822`, 102.04788740478098`}, {
      2.3999999999999995`, -1.8474111129762605`*^-13}, {2.617060609474946, 
      17.922638764521835`}, {2.5795698200470385`, 27.629398223013226`}, {
      4.004420650289744, 1592.9999999999998`}, {3.8499999999999996`, 
      1592.9999999999998`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}], 
     CapForm[None], 
     LineBox[{{3.6500000000000004`, 1592.9999999999998`}, {0.4999999999999998,
       555.9999999999995}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.6282793634608546, 572.110385090229}, {
      0.4999999999999998, 555.9999999999995}, {0.5844993075421756, 
      609.9377043796567}}], 
     {GrayLevel[0.5], Opacity[1], 
      PolygonBox[{{3.3000000000000003`, 1592.9999999999998`}, {
       3.2886545788331873`, 1666.8413852212916`}, {2.063261916394117, 
       1613.2871873813617`}, {2.0598582900440734`, 1635.4396029477493`}, {
       1.9499999999999997`, 1533.9999999999995`}, {2.089356385077787, 
       1443.4520013723904`}, {2.085952758727743, 1465.604416938778}, {
       3.3113454211668127`, 1519.158614778708}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{3.3000000000000003`, 1592.9999999999998`}, {
       3.2886545788331873`, 1666.8413852212916`}, {2.063261916394117, 
       1613.2871873813617`}, {2.0598582900440734`, 1635.4396029477493`}, {
       1.9499999999999997`, 1533.9999999999995`}, {2.089356385077787, 
       1443.4520013723904`}, {2.085952758727743, 1465.604416938778}, {
       3.3113454211668127`, 1519.158614778708}, {3.3000000000000003`, 
       1592.9999999999998`}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{4.599999999999999, 1657.9999999999998`}, {
       5.399999999999999, 1657.9999999999998`}}], 
      {GrayLevel[0.5], Opacity[1], 
       PolygonBox[{{4.999999999999999, 1657.9999999999998`}, {
        4.952796100176643, 1657.9999999999998`}, {0.9029856031951609, 
        595.4068648396202}, {0.8845887585329677, 615.3506915998438}, {
        0.7999999999999992, 555.9999999999995}, {0.9397792925195472, 
        555.5192113191728}, {0.921382447857354, 575.4630380793965}, {
        5.047203899823355, 1657.9999999999998`}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{4.999999999999999, 1657.9999999999998`}, {
        4.952796100176643, 1657.9999999999998`}, {0.9029856031951609, 
        595.4068648396202}, {0.8845887585329677, 615.3506915998438}, {
        0.7999999999999992, 555.9999999999995}, {0.9397792925195472, 
        555.5192113191728}, {0.921382447857354, 575.4630380793965}, {
        5.047203899823355, 1657.9999999999998`}, {4.999999999999999, 
        1657.9999999999998`}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
       AbsoluteDashing[{4, 2}], CapForm[None], 
       LineBox[{{5.099999999999999, 1657.9999999999998`}, {
        2.7500000000000004`, -1.8474111129762605`*^-13}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{2.858638150814625, 39.78898451721692}, {
        2.7500000000000004`, -1.8474111129762605`*^-13}, {2.792147913069831, 
        66.59539587445327}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["0", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {0.09999999999999988, -1.4210854715202004`*^-14}, {-1, -0.75},
         Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["2", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {0.09999999999999988, 555.9999999999999}, {-1, -0.75}, 
        Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["4", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {0.09999999999999988, 1275.9999999999998`}, {-1, -0.75},
         Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["2", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {1.0999999999999996`, 1533.9999999999998`}, {-1, -0.75},
         Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["6", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {0.09999999999999988, 2110.8999999999996`}, {-1, -0.75},
         Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["4", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {1.0999999999999996`, 2137.9999999999995`}, {-1, -0.75},
         Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["3", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {2.0999999999999996`, 2111.4999999999995`}, {-1, -0.75},
         Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["0", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {3.35, 1592.9999999999998`}, {-1, -0.75}, Automatic, {
        1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["1593",
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {4.15, 1592.9999999999998`}, {1, -0.75}, Automatic, {1,
         0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           RowBox[{
            RowBox[{
             SuperscriptBox["\[Rho]", "2"], 
             RowBox[{"(", 
              RowBox[{
               TagBox[
                StyleBox["\<\"E\"\>",
                 FontSlant->"Italic"],
                StyleForm[#, FontSlant -> "Italic"]& ], "0"}], ")"}]}], "=", 
            RowBox[{"4.0", 
             RowBox[{
              RowBox[{"(", "15", ")"}], "\[Cross]", 
              SuperscriptBox["10", 
               RowBox[{"-", "3"}]]}]}]}],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {2.98, 637.1999999999998}, {0, 0}, Automatic, {
        0.4367168322656622, 0.899599026464483}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"<0.0004 W.u.\"\>",
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {2.0151672569111385`, 1126.1973363622176`}, {0, 0}, 
        Automatic, {0.8509444951130999, 0.5252556199001697}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"96(40) W.u.\"\>",
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {2.6456486665236, 1429.1086788972484`}, {0, 0}, 
        Automatic, {0.996659368613718, 0.08167069826140219}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           SuperscriptBox["0", "+"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {4.599999999999999, 1657.9999999999998`}, {-1, -0.75}, 
        Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["1658",
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {5.399999999999999, 1657.9999999999998`}, {1, -0.75}, 
        Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"13(3) W.u.\"\>",
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {4.219483131074423, 1373.114960141943}, {0, 0}, 
        Automatic, {0.8972927456609373, 0.4414359846956935}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           RowBox[{
            RowBox[{
             SuperscriptBox["\[Rho]", "2"], 
             RowBox[{"(", 
              RowBox[{
               TagBox[
                StyleBox["\<\"E\"\>",
                 FontSlant->"Italic"],
                StyleForm[#, FontSlant -> "Italic"]& ], "0"}], ")"}]}], "<", 
            RowBox[{"0.3", "\[Cross]", 
             SuperscriptBox["10", 
              RowBox[{"-", "3"}]]}]}],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {4.046898769198789, 779.8549125117331}, {0, 0}, 
        Automatic, {0.6030236508076566, 0.7977233082758742}]}}}}},
  AspectRatio->0.6,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{540., 324.},
  PlotRange->{{-0.50075, 7.00075}, {-100.24, 2300.24}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.497225087421875*^9, 3.507513554265625*^9, 
  3.5668365139938498`*^9, 
  3.566837679310532*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Level scheme with bent arrows", "Section"],

Cell["\<\
Adapted from M. A. Caprio, Ph.D. thesis, Yale University (2003), \
arXiv:nucl-ex/0502004.\
\>", "Text",
 FontSize->8],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"a", "=", "6"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "first", " ", "interfamily", " ", "horizontal", " ", "separation"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "=", "5"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "second", " ", "interfamily", " ", "horizontal", " ", "separation"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "=", "0.2"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "arrow", " ", "position", " ", "parameter", " ", "for", " ", "kinked", " ",
     "arrows"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Figure", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"Thickness", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"Thickness", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{"HeadLength", "\[Rule]", "4"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "0.5"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PosnC", "\[Rule]", 
        RowBox[{"FromTailVertical", "[", "15", "]"}]}], ",", 
       RowBox[{"BackgroundC", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"OrientationC", "->", "Horizontal"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PosnL", "\[Rule]", 
        RowBox[{"FromTailVertical", "[", "17", "]"}]}], ",", 
       RowBox[{"BufferL", "\[Rule]", "1.0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PosnR", "\[Rule]", 
        RowBox[{"FromTailVertical", "[", "10", "]"}]}], ",", 
       RowBox[{"BufferR", "\[Rule]", "1.0"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"LevelLabel", ",", 
       RowBox[{"Gap", "\[Rule]", "3"}]}], "]"}], ",", "\[IndentingNewLine]", 
     " ", "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.2", ",", "0.7"}], "}"}], ",", "\"\<E(5)\>\"", ",", 
       RowBox[{"FontSize", "\[Rule]", "35"}], ",", 
       RowBox[{"Color", "\[Rule]", "IndianRed"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"\[Xi]", "=", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev100", ",", "0", ",", "1", ",", "\"\<0.000\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev100", ",", "Left", ",", "\"\<0.000\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev112", ",", "0", ",", "1", ",", "\"\<1.000\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev112", ",", "Left", ",", "\"\<1.000\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev124", ",", "0", ",", "1", ",", "\"\<2.199\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev122", ",", "1", ",", "2", ",", "\"\<2.199\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "2", "]"}]}], ",", 
       RowBox[{"BackgroundL", "\[Rule]", "Automatic"}]}], "]"}], ",", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{"background", " ", "for", " ", "crossover", " ", "arrow"}], " ",
       "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev122redraw", ",", "1", ",", "2", ",", "\"\<2.199\>\"", ",", 
       RowBox[{"Layer", "\[Rule]", "5"}]}], "]"}], ",", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "inelegant", " ", "fix", " ", "so", " ", "background", " ", "label", 
       " ", 
       RowBox[{"doesn", "'"}], "t", " ", "hide", " ", "line"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev124", ",", "Left", ",", "\"\<2.199\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev136", ",", "0", ",", "1", ",", "\"\<3.590\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "6", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev134", ",", "1", ",", "2", ",", "\"\<3.590\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev133", ",", "2", ",", "3", ",", "\"\<3.590\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "3", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev130", ",", "3", ",", "4", ",", "\"\<3.590\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev136", ",", "Left", ",", "\"\<3.590\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev148", ",", "0", ",", "1", ",", "\"\<5.169\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "8", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev146", ",", "1", ",", "2", ",", "\"\<5.169\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "6", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev145", ",", "2", ",", "3", ",", "\"\<5.169\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "5", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev144", ",", "3", ",", "4", ",", "\"\<5.169\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev142", ",", "4", ",", "5", ",", "\"\<5.169\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev148", ",", "Left", ",", "\"\<5.169\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev112", ",", "0.5", ",", "lev100", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<100\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev124", ",", "0.5", ",", "lev112", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<167\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev122", ",", "0.5", ",", "lev112", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<167\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev136", ",", "0.5", ",", "lev124", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<217\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev134", ",", "0.5", ",", "lev124", ",", "0.5", ",", 
       RowBox[{"LabL", "\[Rule]", "\"\<103\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev134", ",", "0.5", ",", "lev122", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<114\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev133", ",", "0.5", ",", "lev124", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<62\>\""}], ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<62.0\>\""}]}], "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"LabL", "->", "\"\<62\>\""}], ",", 
       RowBox[{"PosnL", "\[Rule]", 
        RowBox[{"FromTailVertical", "[", "12", "]"}]}], ","}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev133", ",", "0.5", ",", "lev122", ",", "0.5", ",", 
       RowBox[{"LabR", "\[Rule]", "\"\<155\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev130", ",", "0.5", ",", "lev122", ",", "0.5", ",", 
       RowBox[{"LabL", "\[Rule]", "\"\<217\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev148", ",", "0.5", ",", "lev136", ",", "0.5", ",", 
       RowBox[{"LabC", "->", "\"\<255\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev146", ",", "0.5", ",", "lev136", ",", "0.5", ",", 
       RowBox[{"LabL", "->", "\"\<81\>\""}], ",", 
       RowBox[{"LabL", "->", "\"\<81.2\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev146", ",", "0.5", ",", "lev134", ",", "0.5", ",", 
       RowBox[{"LabC", "->", "\"\<174\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev145", ",", "0.5", ",", "lev136", ",", "0.5", ",", 
       RowBox[{"LabC", "->", "\"\<60\>\""}], ",", 
       RowBox[{"LabC", "->", "\"\<60.3\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev145", ",", "0.5", ",", "lev134", ",", "0.5", ",", 
       RowBox[{"LabC", "->", "\"\<61\>\""}], ",", 
       RowBox[{"LabC", "->", "\"\<60.9\>\""}], ",", 
       RowBox[{"NudgeC", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1.2", ",", "0"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev145", ",", "0.5", ",", "lev133", ",", "0.5", ",", 
       RowBox[{"LabC", "->", "\"\<134\>\""}], ",", 
       RowBox[{"NudgeC", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1.8", ",", "0"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"\[Xi]", "=", "2"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"PosnC", "\[Rule]", 
        RowBox[{"FromTailVertical", "[", "25", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetOrigin", "[", "a", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev200", ",", "0", ",", "1", ",", "\"\<3.031\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev200", ",", "Left", ",", "\"\<3.031\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev212", ",", "0", ",", "1", ",", "\"\<4.800\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev212", ",", "Left", ",", "\"\<4.800\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev224", ",", "0", ",", "1", ",", "\"\<6.780\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev222", ",", "1", ",", "2", ",", "\"\<6.780\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev224", ",", "Left", ",", "\"\<6.780\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev236", ",", "0", ",", "1", ",", "\"\<8.967\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "6", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev234", ",", "1", ",", "2", ",", "\"\<8.967\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev233", ",", "2", ",", "3", ",", "\"\<8.967\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "3", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev230", ",", "3", ",", "4", ",", "\"\<8.967\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev236", ",", "Left", ",", "\"\<8.967\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev212", ",", "0.5", ",", "lev200", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<75\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev224", ",", "0.5", ",", "lev212", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<124\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev222", ",", "0.5", ",", "lev212", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<124\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ekink", "=", "2"}], ";", "\[IndentingNewLine]", 
      RowBox[{"dekink", "=", "0.5"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{"lev200", ",", 
        RowBox[{"0.5", "-", "d"}], ",", "lev112", ",", 
        RowBox[{"0.5", "+", "d"}], ",", 
        RowBox[{"Kink", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "ekink"}], "}"}]}], ",", 
        RowBox[{"LabR", "->", "\"\<87\>\""}], ",", 
        RowBox[{"PosnR", "\[Rule]", 
         RowBox[{"FromTailHorizontal", "[", "20", "]"}]}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev212", ",", 
       RowBox[{"0.5", "-", "d"}], ",", "lev100", ",", 
       RowBox[{"0.5", "+", "d"}], ",", 
       RowBox[{"Kink", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"ekink", "+=", 
           RowBox[{"1.5", "*", "dekink"}]}]}], "}"}]}], ",", 
       RowBox[{"LabR", "->", "\"\<0.47\>\""}], ",", 
       RowBox[{"PosnR", "\[Rule]", 
        RowBox[{"FromTailHorizontal", "[", 
         RowBox[{"20", "-", "6"}], "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev212", ",", 
       RowBox[{"0.5", "-", "d"}], ",", "lev122", ",", 
       RowBox[{"0.5", "+", "d"}], ",", 
       RowBox[{"Kink", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"ekink", "+=", 
           RowBox[{"1", "*", "dekink"}]}]}], "}"}]}], ",", 
       RowBox[{"LabR", "->", "\"\<19\>\""}], ",", 
       RowBox[{"PosnR", "\[Rule]", 
        RowBox[{"FromTailHorizontal", "[", "20", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev212", ",", 
       RowBox[{"0.5", "-", "d"}], ",", "lev124", ",", 
       RowBox[{"0.5", "+", "d"}], ",", 
       RowBox[{"Kink", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"ekink", "+=", 
           RowBox[{"1", "*", "dekink"}]}]}], "}"}]}], ",", 
       RowBox[{"LabR", "->", "\"\<34\>\""}], ",", 
       RowBox[{"PosnR", "\[Rule]", 
        RowBox[{"FromTailHorizontal", "[", "20", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"\[Xi]", "=", "3"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"PosnC", "\[Rule]", 
        RowBox[{"FromTailVertical", "[", "35", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetOrigin", "[", 
       RowBox[{"a", "+", "b"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Lev", "[", 
       RowBox[{"lev300", ",", "0", ",", "1", ",", "\"\<7.577\>\"", ",", 
        RowBox[{"LabL", "\[Rule]", 
         RowBox[{"LabelJP", "[", "0", "]"}]}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev300", ",", "Left", ",", "\"\<7.577\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev312", ",", "0", ",", "1", ",", "\"\<10.107\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev312", ",", "Left", ",", "\"\<10.107\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev324", ",", "0", ",", "1", ",", "\"\<12.854\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "4", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev322", ",", "1", ",", "2", ",", "\"\<12.854\>\"", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"LabelJP", "[", "2", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev324", ",", "Left", ",", "\"\<12.854\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev312", ",", "0.5", ",", "lev300", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<66\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev324", ",", "0.5", ",", "lev312", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<107\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev322", ",", "0.5", ",", "lev312", ",", "0.5", ",", 
       RowBox[{"LabC", "\[Rule]", "\"\<107\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev300", ",", 
       RowBox[{"0.5", "-", "d"}], ",", "lev112", ",", 
       RowBox[{"0.5", "+", "d"}], ",", 
       RowBox[{"Kink", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1.5"}], "}"}]}], ",", 
       RowBox[{"LabR", "->", "\"\<1.6\>\""}], ",", 
       RowBox[{"PosnR", "\[Rule]", 
        RowBox[{"FromTailHorizontal", "[", 
         RowBox[{"20", "-", "4"}], "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"lev300", ",", 
       RowBox[{"0.5", "-", "d"}], ",", "lev212", ",", 
       RowBox[{"0.5", "+", "d"}], ",", 
       RowBox[{"Kink", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "6"}], "}"}]}], ",", 
       RowBox[{"LabR", "->", "\"\<123\>\""}], ",", 
       RowBox[{"PosnR", "\[Rule]", 
        RowBox[{"FromTailHorizontal", "[", "20", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"\[Tau]", " ", "and", " ", "\[Xi]", " ", "labels"}], " ", 
      "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"LevelLabel", ",", 
       RowBox[{"Gap", "\[Rule]", "40"}], ",", 
       RowBox[{"Color", "\[Rule]", "IndianRed"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev100", ",", "Left", ",", "\"\<\[Tau]=0\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev112", ",", "Left", ",", "\"\<\[Tau]=1\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev124", ",", "Left", ",", "\"\<\[Tau]=2\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev136", ",", "Left", ",", "\"\<\[Tau]=3\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LevelLabel", "[", 
      RowBox[{"lev148", ",", "Left", ",", "\"\<\[Tau]=4\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"BandLabel", ",", 
       RowBox[{"Nudge", "\[Rule]", 
        RowBox[{"-", "6"}]}], ",", 
       RowBox[{"Color", "\[Rule]", "IndianRed"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BandLabel", "[", 
      RowBox[{"lev100", ",", "\"\<\[Xi]=1\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BandLabel", "[", 
      RowBox[{"lev200", ",", "\"\<\[Xi]=2\>\""}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BandLabel", "[", 
      RowBox[{"lev300", ",", "\"\<\[Xi]=3\>\""}], "]"}], ","}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", 
        RowBox[{"a", "+", "b", "+", "2.5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "14.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"12", ",", "8"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.3950954873125*^9, 3.395095495921875*^9}, 
   3.39552093990625*^9, 3.50751343946875*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999977, 0.}, {0.8999999999999997, 0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999977, 1.}, {0.8999999999999997, 1.}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999977, 2.199}, {0.8999999999999997, 
     2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999996`, 2.199}, {1.8999999999999995`, 
     2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999977, 3.59}, {0.8999999999999997, 
     3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999996`, 3.59}, {1.8999999999999995`, 
     3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.0999999999999996`, 3.59}, {2.8999999999999995`, 
     3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.0999999999999996`, 3.59}, {3.8999999999999995`, 
     3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999977, 5.169}, {0.8999999999999997, 
     5.169}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999996`, 5.169}, {1.8999999999999995`, 
     5.169}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.0999999999999996`, 5.169}, {2.8999999999999995`, 
     5.169}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.0999999999999996`, 5.169}, {3.8999999999999995`, 
     5.169}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{4.099999999999999, 5.169}, {4.8999999999999995`, 
     5.169}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5, 0.9999999999999998}, {0.5, 0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5086822916666667, 0.1111333333333333}, {0.5, 0.}, {
     0.4913177083333331, 0.1111333333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5, 2.199}, {0.5, 0.9999999999999998}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5086822916666667, 1.1111333333333333`}, {0.5, 
     0.9999999999999998}, {0.4913177083333331, 1.1111333333333333`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.4999999999999996`, 2.199}, {0.5, 
     0.9999999999999993}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.56078993263597, 1.0555277538826113`}, {0.5, 
     0.9999999999999993}, {0.5503767418036922, 1.0777610887705438`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5, 3.59}, {0.5, 2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5086822916666667, 2.310133333333333}, {0.5, 2.199}, {
     0.4913177083333331, 2.310133333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.4999999999999996`, 3.59}, {0.5, 2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5581150039880307, 2.261430527291716}, {0.5, 2.199}, {
     0.5467221535127504, 2.2823979587918712`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], 
    LineBox[{{1.4999999999999996`, 3.59}, {1.4999999999999996`, 2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.5086822916666662`, 2.310133333333333}, {
     1.4999999999999996`, 2.199}, {1.4913177083333329`, 2.310133333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.5, 3.59}, {0.49999999999999956`, 2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5671615922629281, 2.230563534716638}, {
     0.49999999999999956`, 2.199}, {0.5602391533138165, 
     2.2560436838319875`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.5, 3.59}, {1.4999999999999996`, 2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.5581150039880307`, 2.261430527291716}, {
     1.4999999999999996`, 2.199}, {1.5467221535127504`, 
     2.2823979587918712`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.5, 3.59}, {1.4999999999999996`, 2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.567161592262928, 2.230563534716638}, {
     1.4999999999999996`, 2.199}, {1.5602391533138165`, 
     2.2560436838319875`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5, 5.1690000000000005`}, {0.5, 3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5086822916666667, 3.701133333333333}, {0.5, 3.59}, {
     0.4913177083333331, 3.701133333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.4999999999999996`, 5.1690000000000005`}, {0.5, 
     3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], 
    LineBox[{{0.5555364415486923, 3.658174757428492}, {0.5, 3.59}, {
     0.5433392037428106, 3.6779498864867923`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.4999999999999996`, 5.1690000000000005`}, {
     1.4999999999999996`, 3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.5086822916666662`, 3.701133333333333}, {
     1.4999999999999996`, 3.59}, {1.4913177083333329`, 3.701133333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.5, 5.1690000000000005`}, {0.5, 3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.5661299760291585, 3.6267188157861305`}, {0.5, 3.59}, {
     0.5584461589534717, 3.651634042782656}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.5, 5.1690000000000005`}, {1.4999999999999996`, 
     3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.5555364415486923`, 3.658174757428492}, {
     1.4999999999999996`, 3.59}, {1.5433392037428106`, 
     3.6779498864867923`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.5, 5.1690000000000005`}, {2.5, 3.59}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.5086822916666662`, 3.701133333333333}, {2.5, 3.59}, {
     2.4913177083333333`, 3.701133333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.1, 3.031}, {6.9, 3.031}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.1, 4.8}, {6.9, 4.8}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.1, 6.78}, {6.9, 6.78}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{7.1, 6.78}, {7.8999999999999995`, 6.78}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.1, 8.967}, {6.9, 8.967}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{7.1, 8.967}, {7.8999999999999995`, 8.967}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{8.1, 8.967}, {8.899999999999999, 8.967}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{9.1, 8.967}, {9.899999999999999, 8.967}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.5, 4.800000000000001}, {6.5, 3.0309999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.508682291666666, 3.1421333333333337`}, {6.5, 
     3.0309999999999997`}, {6.491317708333333, 3.1421333333333337`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.5, 6.779999999999999}, {6.5, 4.800000000000001}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.508682291666666, 4.911133333333334}, {6.5, 
     4.800000000000001}, {6.491317708333333, 4.911133333333334}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{7.499999999999998, 6.779999999999999}, {6.5, 
     4.800000000000001}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.550408978689704, 4.877707589341424}, {6.5, 
     4.800000000000001}, {6.536902919446726, 4.89516996896871}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.3, 3.0309999999999997`}, {5., 1.9999999999999998`}, {
     0.6999999999999984, 0.9999999999999989}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.7699848976527481, 1.0022379182118788`}, {
     0.6999999999999984, 0.9999999999999989}, {0.7674872210769896, 
     1.0297323419578268`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.3, 4.800000000000001}, {5., 2.75}, {
     0.6999999999999988, -1.5543122344752192`*^-15}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.7677194083653371, 0.02834864037332019}, {
     0.6999999999999988, -1.5543122344752192`*^-15}, {0.7612744049735851, 
     0.05414740304110488}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.3, 4.800000000000001}, {5., 3.25}, {
     1.6999999999999988`, 2.199}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.7698168600838873`, 2.207071410254968}, {
     1.6999999999999988`, 2.199}, {1.7664268935805416`, 
     2.2343201609878545`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.3, 4.800000000000001}, {5., 3.750000000000001}, {
     0.6999999999999984, 2.1990000000000007`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.7696672783532255, 2.209888536049524}, {
     0.6999999999999984, 2.1990000000000007`}, {0.765848510396276, 
     2.2369916937994248`}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.099999999999998`, 7.577}, {11.899999999999999`, 
     7.577}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.099999999999998`, 10.107}, {11.899999999999999`, 
     10.107}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.099999999999998`, 12.854}, {11.899999999999999`, 
     12.854}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{12.099999999999998`, 12.854}, {12.899999999999999`, 
     12.854}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.499999999999998`, 10.107}, {11.499999999999998`, 
     7.576999999999998}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.508682291666664`, 7.688133333333331}, {
     11.499999999999998`, 7.576999999999998}, {11.491317708333332`, 
     7.688133333333331}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.499999999999998`, 12.853999999999997`}, {
     11.499999999999998`, 10.107}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.508682291666664`, 10.218133333333332`}, {
     11.499999999999998`, 10.107}, {11.491317708333332`, 
     10.218133333333332`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{12.5, 12.853999999999997`}, {11.499999999999998`, 
     10.107}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.542461089100263`, 10.196039650248354`}, {
     11.499999999999998`, 10.107}, {11.527456186320507`, 
     10.210023105332509`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.299999999999999`, 7.576999999999998}, {
     9.999999999999998, 1.5000000000000002`}, {0.6999999999999988, 
     1.0000000000000002`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.7697107327559864, 0.9898483818318875}, {
     0.6999999999999988, 1.0000000000000002`}, {0.7691275745432042, 
     1.0176160432917258`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.299999999999999`, 7.576999999999998}, {
     9.999999999999998, 6.}, {6.700000000000003, 4.800000000000001}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.769655282002699, 4.811083271390484}, {
     6.700000000000003, 4.800000000000001}, {6.765806923881003, 
     4.838175712567224}}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["2", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {1.0999999999999996`, 2.199}, {-1, -0.75}, 
     Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"100\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {0.5, 0.5832499999999998}, {0, 0}, Automatic, {1, 
     0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"167\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {0.5, 1.7822499999999997`}, {0, 0}, Automatic, {1,
      0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"167\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {1.1524186822351958`, 1.7822499999999997`}, {0, 0},
      Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"217\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {0.5, 3.1732500000000003`}, {0, 0}, Automatic, {1,
      0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"114\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {1.4999999999999996`, 3.1732500000000003`}, {0, 0},
      Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"62\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {1.9007907979870593`, 3.1732500000000003`}, {0, 0},
      Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"255\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {0.5, 4.75225}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"174\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {1.4999999999999996`, 4.75225}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"60\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {1.9721342621912603`, 4.75225}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"61\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {2.25690463109563, 4.75225}, {0, 0}, Automatic, {
     1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"134\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {2.53125625, 4.75225}, {0, 0}, Automatic, {1, 0}],
     InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"75\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {6.5, 4.105416666666667}, {0, 0}, Automatic, {1, 
     0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"124\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {6.5, 6.085416666666666}, {0, 0}, Automatic, {1, 
     0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"124\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {7.149200336700336, 6.085416666666666}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"66\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {11.499999999999998`, 9.134583333333332}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"107\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {11.499999999999998`, 11.881583333333332`}, {0, 0},
      Automatic, {1, 0}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"107\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {12.146007766047807`, 11.881583333333332`}, {0, 0},
      Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"E(5)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->35,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {1.4991000000000003`, 9.70064}, {0, 0}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["0", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999977, 0.}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0.000\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.047906249999999775`, 0.}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["2", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999977, 1.}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1.000\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.047906249999999775`, 1.}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["4", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999977, 2.199}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["2", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.0999999999999996`, 2.199}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"2.199\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.047906249999999775`, 2.199}, {1, 0}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["6", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999977, 3.59}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["4", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.0999999999999996`, 3.59}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["3", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.0999999999999996`, 3.59}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["0", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {3.0999999999999996`, 3.59}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"3.590\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.047906249999999775`, 3.59}, {1, 0}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["8", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999977, 5.169}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["6", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.0999999999999996`, 5.169}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["5", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.0999999999999996`, 5.169}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["4", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {3.0999999999999996`, 5.169}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["2", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {4.099999999999999, 5.169}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"5.169\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.047906249999999775`, 5.169}, {1, 0}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"100\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5, 0.5832499999999998}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"167\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5, 1.7822499999999997`}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"167\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.1524186822351958`, 1.7822499999999997`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"217\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5, 3.1732500000000003`}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"103\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.0863945907700114`, 3.2539716380843497`}, {0, 0}, 
     Automatic, {0.7546765986858924, 0.6560969679825479}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"114\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.4999999999999996`, 3.1732500000000003`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"62\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.9007907979870593`, 3.1732500000000003`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"155\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.3743171274183412`, 3.1758783619156503`}, {0, 0}, 
     Automatic, {0.7546765986858924, 0.6560969679825479}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"217\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.775900384549443, 3.283304302583102}, {0, 0}, 
     Automatic, {0.9171019477630133, 0.3986527529182348}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"255\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5, 4.75225}, {0, 0}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"81\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.12159403617015, 4.8252216722122885`}, {0, 0}, 
     Automatic, {0.7117622936400982, 0.7024204135360721}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"174\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.4999999999999996`, 4.75225}, {0, 0}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"60\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.9721342621912603`, 4.75225}, {0, 0}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"61\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.25690463109563, 4.75225}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"134\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.53125625, 4.75225}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["0", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.1, 3.031}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"3.031\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.04790625, 3.031}, {1, 0}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["2", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.1, 4.8}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"4.800\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.04790625, 4.8}, {1, 0}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["4", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.1, 6.78}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["2", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {7.1, 6.78}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"6.780\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.04790625, 6.78}, {1, 0}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["6", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.1, 8.967}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["4", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {7.1, 8.967}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["3", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {8.1, 8.967}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["0", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {9.1, 8.967}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"8.967\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.04790625, 8.967}, {1, 0}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"75\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.5, 4.105416666666667}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"124\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.5, 6.085416666666666}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"124\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {7.149200336700336, 6.085416666666666}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"87\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {4.668943231075763, 1.740520741775368}, {0, 0}, 
     Automatic, {0.9896013345872147, 0.14383740328302538`}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0.47\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {4.798788355379723, 2.426834447698158}, {0, 0}, 
     Automatic, {0.928569742091834, 0.37115796377217203`}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"19\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {4.6747431156050805`, 2.962275986397856}, {0, 0}, 
     Automatic, {0.980758874608984, 0.19522302598750796`}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"34\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {4.677530325053503, 3.4485621781140168`}, {0, 0}, 
     Automatic, {0.9755185752813778, 0.21991705091008956`}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["0", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.099999999999998`, 7.577}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"7.577\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.047906249999999`, 7.577}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["2", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.099999999999998`, 10.107}, {-1, -0.75}, Automatic, {1,
      0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"10.107\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.047906249999999`, 10.107}, {1, 0}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["4", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.099999999999998`, 12.854}, {-1, -0.75}, Automatic, {1,
      0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SuperscriptBox["2", "+"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {12.099999999999998`, 12.854}, {-1, -0.75}, Automatic, {1,
      0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"12.854\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.047906249999999`, 12.854}, {1, 0}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"66\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.499999999999998`, 9.134583333333332}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"107\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.499999999999998`, 11.881583333333332`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"107\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {12.146007766047807`, 11.881583333333332`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1.6\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {9.72595719504975, 1.3045729245253865`}, {0, 0}, 
     Automatic, {0.9994359253691149, 0.03358319641697295}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"123\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {9.677722661124355, 5.6976112535633145`}, {0, 0}, 
     Automatic, {0.9751328557914597, 0.22162110358896828`}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Tau]=0\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {-0.5945833333333336, 0.}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Tau]=1\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {-0.5945833333333336, 1.}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Tau]=2\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {-0.5945833333333336, 2.199}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Tau]=3\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {-0.5945833333333336, 3.59}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Tau]=4\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {-0.5945833333333336, 5.169}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Xi]=1\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {0.4999999999999997, -0.1667}, {0, 1}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Xi]=2\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {6.5, 2.8643}, {0, 1}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Xi]=3\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0.689993, 0.089999, 0.119999],
       FontOpacity->1],
      DisplayForm], {11.499999999999998`, 7.4103}, {0, 1}, Automatic, {1, 
     0}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999996`, 2.199}, {1.8999999999999995`, 
     2.199}}]}},
  AspectRatio->NCache[
    Rational[2, 3], 0.6666666666666666],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{864, 576},
  PlotRange->{{-1.5015, 13.5015}, {-1.5016, 14.5016}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.497225102125*^9, 3.507513556484375*^9, 
  3.566836517483855*^9, 3.5668376800180387`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beta decay scheme", "Section"],

Cell["\<\
The LevelScheme layered drawing system is necessary to prevent the white-out \
boxes behind the labels from obstructing the neighboring labels.  To see what \
would happen if there were no layered drawing system, temporarily disable \
layering by including
\tSetOptions[SchemeObject,Layer\[Rule]0].
at the beginning of the scheme.\
\>", "Text"],

Cell[TextData[{
 "Adapted from E. A. McCutchan ",
 StyleBox["et al.",
  FontSlant->"Italic"],
 ", Phys. Rev. C ",
 StyleBox["71",
  FontWeight->"Bold"],
 ", 024309 (2005).\nCourtesy of E. A. McCutchan."
}], "Text",
 FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"BackgroundT", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"NudgeT", "\[Rule]", "2"}], ",", " ", 
       RowBox[{"Thickness", " ", "\[Rule]", " ", "3"}], ",", " ", 
       RowBox[{"FontSize", " ", "\[Rule]", " ", "20"}], ",", " ", 
       RowBox[{"OrientationT", " ", "\[Rule]", " ", "Automatic"}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"Thickness", "\[Rule]", "3"}], ",", 
       RowBox[{"LabR", "\[Rule]", "Automatic"}], ",", " ", 
       RowBox[{"FontSize", " ", "\[Rule]", " ", "20"}], ",", " ", 
       RowBox[{"WingRiseWidth", " ", "\[Rule]", " ", "10"}], ",", " ", 
       RowBox[{"WingTipWidth", " ", "\[Rule]", " ", "60"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "title", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", 
         RowBox[{"-", "100"}]}], "}"}], ",", 
       "\"\<\!\(\*SuperscriptBox[\(\[InvisiblePrefixScriptBase]\), \
\(166\)]\)Hf\>\"", ",", " ", 
       RowBox[{"FontSize", " ", "\[Rule]", " ", "35"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "levels", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev0", ",", "0", ",", "14", ",", "\"\<0.0\>\"", ",", " ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<\!\(\*SuperscriptBox[\(0\), \(+\)]\)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev159", ",", "0", ",", "14", ",", "\"\<158.6\>\"", ",", " ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<\!\(\*SuperscriptBox[\(2\), \(+\)]\)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev470", ",", "0", ",", "14", ",", "\"\<470.5\>\"", ",", " ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<\!\(\*SuperscriptBox[\(4\), \(+\)]\)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev810", ",", "0", ",", "14", ",", "\"\<809.9\>\"", ",", 
       RowBox[{"WingHeight", "\[Rule]", 
        RowBox[{"-", "5"}]}], ",", " ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<\!\(\*SuperscriptBox[\(2\), \(+\)]\)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{
      "lev897", ",", " ", "0", ",", "14", ",", "\"\<897.2\>\"", ",", "  ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<\!\(\*SuperscriptBox[\(6\), \(+\)]\)\>\""}], ",", " ", 
       RowBox[{"WingHeight", " ", "\[Rule]", " ", 
        RowBox[{"-", "3"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev1006", ",", "0", ",", "14", ",", "\"\<1007.1\>\"", ",", 
       RowBox[{"WingHeight", "\[Rule]", 
        RowBox[{"-", "7"}]}], ",", "  ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<\!\(\*SuperscriptBox[\(3\), \(+\)]\)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev1065", ",", "0", ",", "14", ",", "\"\<1065.0\>\"", ",", " ", 
       RowBox[{"WingHeight", " ", "\[Rule]", " ", 
        RowBox[{"+", "5"}]}], ",", "  ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<(\!\(\*SuperscriptBox[\(0\), \(+\)]\))\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev1164", ",", "0", ",", "14", ",", "\"\<1162.7\>\""}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{
      "lev1219", ",", " ", "0", ",", " ", "14", ",", " ", "\"\<1218.8\>\"", 
       ",", " ", 
       RowBox[{"WingHeight", " ", "\[Rule]", " ", 
        RowBox[{"+", "8"}]}], ",", "  ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<(\!\(\*SuperscriptBox[\(2\), \(+\)]\))\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"lev1332", ",", "0", ",", "14", ",", "\"\<1332.4\>\""}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{
      "lev1405", ",", " ", "0", " ", ",", "14", ",", " ", "\"\<1404.6\>\""}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{
      "lev1551", ",", " ", "0", ",", "14", ",", "\"\<1551.4\>\"", ",", "  ", 
       RowBox[{
       "LabL", " ", "\[Rule]", " ", 
        "\"\<(\!\(\*SuperscriptBox[\(5\), \(+\)]\))\>\""}], ",", " ", 
       RowBox[{"WingHeight", "  ", "\[Rule]", " ", 
        RowBox[{"-", "7"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{
      "lev1603", ",", " ", "0", ",", "14", ",", " ", "\"\<1603.2\>\""}], 
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "transitions", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"AutoLevelInit", "[", 
      RowBox[{"12.2", ",", 
       RowBox[{"-", "0.5"}], ",", 
       RowBox[{"-", "0.5"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev159", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev0", ",", 
       RowBox[{"LabT", "\[Rule]", "\"\<159  \!\(\*
StyleBox[\"100\",
FontSlant->\"Italic\",
FontTracking->\"Plain\",
FontVariations->{\"CompatibilityType\"->0,
\"Masked\"->False,
\"Outline\"->False,
\"RotationAngle\"->0,
\"Shadow\"->False,
\"StrikeThrough\"->False,
\"Underline\"->False}]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev470", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev159", ",", 
       RowBox[{"LabT", "\[Rule]", "\"\<312  \!\(\*
StyleBox[\"44.7\",
FontSlant->\"Italic\",
FontTracking->\"Plain\",
FontVariations->{\"CompatibilityType\"->0,
\"Masked\"->False,
\"Outline\"->False,
\"RotationAngle\"->0,
\"Shadow\"->False,
\"StrikeThrough\"->False,
\"Underline\"->False}]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev810", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev0", ",", 
       RowBox[{"LabT", "\[Rule]", "\"\<810  \!\(\*
StyleBox[\"20.2\",
FontSlant->\"Italic\",
FontTracking->\"Plain\",
FontVariations->{\"CompatibilityType\"->0,
\"Masked\"->False,
\"Outline\"->False,
\"RotationAngle\"->0,
\"Shadow\"->False,
\"StrikeThrough\"->False,
\"Underline\"->False}]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev159", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<651  \!\(\*
StyleBox[\"18.9\",
FontSlant->\"Italic\",
FontTracking->\"Plain\",
FontVariations->{\"CompatibilityType\"->0,
\"Masked\"->False,
\"Outline\"->False,
\"RotationAngle\"->0,
\"Shadow\"->False,
\"StrikeThrough\"->False,
\"Underline\"->False}]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev897", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev470", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<427  \!\(\*
StyleBox[\"1.2\",
FontSlant->\"Italic\",
FontTracking->\"Plain\",
FontVariations->{\"CompatibilityType\"->0,
\"Masked\"->False,
\"Outline\"->False,
\"RotationAngle\"->0,
\"Shadow\"->False,
\"StrikeThrough\"->False,
\"Underline\"->False}]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev1006", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev159", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<848  \!\(\*
StyleBox[\"12.7\",
FontSlant->\"Italic\",
FontTracking->\"Plain\",
FontVariations->{\"CompatibilityType\"->0,
\"Masked\"->False,
\"Outline\"->False,
\"RotationAngle\"->0,
\"Shadow\"->False,
\"StrikeThrough\"->False,
\"Underline\"->False}]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev470", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<537  \!\(\*
StyleBox[\"2.0\",
FontSlant->\"Italic\",
FontTracking->\"Plain\",
FontVariations->{\"CompatibilityType\"->0,
\"Masked\"->False,
\"Outline\"->False,
\"RotationAngle\"->0,
\"Shadow\"->False,
\"StrikeThrough\"->False,
\"Underline\"->False}]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev1065", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev159", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<906  \!\(\*
StyleBox[\"2.1\",
FontSlant->\"Italic\",
FontTracking->\"Plain\",
FontVariations->{\"CompatibilityType\"->0,
\"Masked\"->False,
\"Outline\"->False,
\"RotationAngle\"->0,
\"Shadow\"->False,
\"StrikeThrough\"->False,
\"Underline\"->False}]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev1164", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev470", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<692  \!\(\*
StyleBox[\"4.4\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev1219", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev0", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<1219  \!\(\*
StyleBox[\"1.0\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev159", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<1060  \!\(\*
StyleBox[\"2.3\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev470", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<748  \!\(\*
StyleBox[\"3.0\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev1332", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev159", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<1174  \!\(\*
StyleBox[\"5.9\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev470", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<862  \!\(\*
StyleBox[\"5.4\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev1405", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev159", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<1246  \!\(\*
StyleBox[\"5.4\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev810", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<595  \!\(\*
StyleBox[\"5.7\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev1006", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<398  \!\(\*
StyleBox[\"2.9\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev1551", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev470", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<1081  \!\(\*
StyleBox[\"1.6\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev1006", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<544  \!\(\*
StyleBox[\"0.9\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AutoLevel", "[", "lev1603", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev159", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<1444  \!\(\*
StyleBox[\"2.3\",
FontSlant->\"Italic\"]\)\>\""}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AutoTrans", "[", 
      RowBox[{"lev470", ",", " ", 
       RowBox[{"LabT", " ", "\[Rule]", " ", "\"\<1134  \!\(\*
StyleBox[\"2.5\",
FontSlant->\"Italic\"]\)\>\""}]}], " ", "]"}], ","}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "200"}], ",", "1910"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"8", ",", "8"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{3.395095505203125*^9, 3.50751344778125*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 2.842170943040401*^-14}, {13.9, 
     2.842170943040401*^-14}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 158.60000000000002`}, {13.9, 
     158.60000000000002`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 470.5}, {13.9, 470.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 791.5803645833333}, {1.767, 791.5803645833333}, {
     2.044833333333333, 809.9}, {11.955166666666667`, 809.9}, {12.233, 
     791.5803645833333}, {13.9, 791.5803645833333}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 886.20821875}, {1.767, 886.20821875}, {
     2.044833333333333, 897.2}, {11.955166666666667`, 897.2}, {12.233, 
     886.20821875}, {13.9, 886.20821875}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 981.4525104166667}, {1.767, 981.4525104166667}, {
     2.044833333333333, 1007.1}, {11.955166666666667`, 1007.1}, {12.233, 
     981.4525104166667}, {13.9, 981.4525104166667}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 1083.3196354166666`}, {1.767, 
     1083.3196354166666`}, {2.044833333333333, 1065.}, {11.955166666666667`, 
     1065.}, {12.233, 1083.3196354166666`}, {13.9, 1083.3196354166666`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 1162.7}, {13.9, 1162.7}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 1248.1114166666666`}, {1.767, 
     1248.1114166666666`}, {2.044833333333333, 1218.8}, {11.955166666666667`, 
     1218.8}, {12.233, 1248.1114166666666`}, {13.9, 1248.1114166666666`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 1332.4}, {13.9, 1332.4}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 1404.6}, {13.9, 1404.6}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 1525.7525104166668`}, {1.767, 
     1525.7525104166668`}, {2.044833333333333, 1551.4}, {11.955166666666667`, 
     1551.4}, {12.233, 1525.7525104166668`}, {13.9, 1525.7525104166668`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 1603.2}, {13.9, 1603.2}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{12.2, 158.59999999999997`}, {12.2, 0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{12.283349999999999`, 21.983562500000005`}, {12.2, 0.}, {
     12.11665, 21.983562500000005`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.699999999999998`, 470.5}, {11.699999999999998`, 
     158.59999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.783349999999999`, 180.58356249999997`}, {
     11.699999999999998`, 158.59999999999997`}, {11.616649999999998`, 
     180.58356249999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.2, 809.9}, {11.2, 5.684341886080802*^-14}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{11.283349999999999`, 21.983562500000062`}, {11.2, 
     5.684341886080802*^-14}, {11.116649999999998`, 21.983562500000062`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{10.7, 809.9}, {10.7, 158.59999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{10.783349999999999`, 180.58356249999997`}, {10.7, 
     158.59999999999997`}, {10.61665, 180.58356249999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{10.2, 897.1999999999998}, {10.2, 470.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{10.28335, 492.48356249999995`}, {10.2, 470.5}, {10.11665,
      492.48356249999995`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{9.7, 1007.1000000000001`}, {9.7, 158.59999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{9.783349999999999, 180.58356249999997`}, {9.7, 
     158.59999999999997`}, {9.616649999999998, 180.58356249999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{9.2, 1007.1000000000001`}, {9.2, 470.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{9.283349999999999, 492.48356249999995`}, {9.2, 470.5}, {
     9.11665, 492.48356249999995`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{8.7, 1065.}, {8.7, 158.59999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{8.78335, 180.58356249999997`}, {8.7, 
     158.59999999999997`}, {8.61665, 180.58356249999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{8.2, 1162.7}, {8.2, 470.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{8.283349999999999, 492.48356249999995`}, {8.2, 470.5}, {
     8.116649999999998, 492.48356249999995`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], 
    LineBox[{{7.699999999999999, 1218.8}, {7.699999999999999, 
     5.684341886080802*^-14}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{7.783349999999999, 21.983562500000062`}, {
     7.699999999999999, 5.684341886080802*^-14}, {7.61665, 
     21.983562500000062`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{7.199999999999999, 1218.8}, {7.199999999999999, 
     158.59999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{7.28335, 180.58356249999997`}, {7.199999999999999, 
     158.59999999999997`}, {7.11665, 180.58356249999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.7, 1218.8}, {6.7, 470.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.78335, 492.48356249999995`}, {6.7, 470.5}, {6.61665, 
     492.48356249999995`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.199999999999999, 1332.4}, {6.199999999999999, 
     158.59999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{6.283349999999999, 180.58356249999997`}, {
     6.199999999999999, 158.59999999999997`}, {6.116649999999999, 
     180.58356249999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{5.699999999999998, 1332.4}, {5.699999999999999, 
     470.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{5.7833499999999995`, 492.48356249999995`}, {
     5.699999999999999, 470.5}, {5.61665, 492.48356249999995`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{5.199999999999999, 1404.6}, {5.2, 
     158.59999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{5.28335, 180.58356249999997`}, {5.2, 
     158.59999999999997`}, {5.11665, 180.58356249999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{4.699999999999999, 1404.6}, {4.699999999999999, 
     809.9}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{4.783349999999999, 831.8835624999999}, {
     4.699999999999999, 809.9}, {4.616649999999999, 831.8835624999999}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{4.199999999999999, 1404.6}, {4.199999999999999, 
     1007.1000000000001`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{4.2833499999999995`, 1029.0835625}, {4.199999999999999, 
     1007.1000000000001`}, {4.11665, 1029.0835625}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.6999999999999993`, 1551.3999999999999`}, {3.7, 
     470.4999999999999}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.7833500000000004`, 492.48356249999983`}, {3.7, 
     470.4999999999999}, {3.61665, 492.48356249999983`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.2, 1551.3999999999999`}, {3.2, 1007.1000000000001`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.2833499999999995`, 1029.0835625}, {3.2, 
     1007.1000000000001`}, {3.11665, 1029.0835625}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.6999999999999993`, 1603.2}, {2.7, 
     158.59999999999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.7833500000000004`, 180.58356249999997`}, {2.7, 
     158.59999999999997`}, {2.61665, 180.58356249999997`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.1999999999999993`, 1603.2}, {2.1999999999999993`, 
     470.4999999999999}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.2833499999999995`, 492.48356249999983`}, {
     2.1999999999999993`, 470.4999999999999}, {2.116649999999999, 
     492.48356249999983`}}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"159  \
\\!\\(\\*\\nStyleBox[\\\"100\\\",\\nFontSlant->\\\"Italic\\\",\\nFontTracking-\
>\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\\n\\\"Masked\
\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->0,\\n\\\"\
Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\"->False}\
]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {12.2, 165.92785416666663`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"312  \
\\!\\(\\*\\nStyleBox[\\\"44.7\\\",\\nFontSlant->\\\"Italic\\\",\\\
nFontTracking->\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\
\\n\\\"Masked\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->\
0,\\n\\\"Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\
\"->False}]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {11.699999999999998`, 477.82785416666667`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"810  \
\\!\\(\\*\\nStyleBox[\\\"20.2\\\",\\nFontSlant->\\\"Italic\\\",\\\
nFontTracking->\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\
\\n\\\"Masked\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->\
0,\\n\\\"Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\
\"->False}]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {11.2, 817.2278541666666}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"651  \
\\!\\(\\*\\nStyleBox[\\\"18.9\\\",\\nFontSlant->\\\"Italic\\\",\\\
nFontTracking->\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\
\\n\\\"Masked\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->\
0,\\n\\\"Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\
\"->False}]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {10.7, 817.2278541666666}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"427  \
\\!\\(\\*\\nStyleBox[\\\"1.2\\\",\\nFontSlant->\\\"Italic\\\",\\nFontTracking-\
>\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\\n\\\"Masked\
\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->0,\\n\\\"\
Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\"->False}\
]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {10.2, 904.5278541666664}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"848  \
\\!\\(\\*\\nStyleBox[\\\"12.7\\\",\\nFontSlant->\\\"Italic\\\",\\\
nFontTracking->\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\
\\n\\\"Masked\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->\
0,\\n\\\"Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\
\"->False}]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {9.7, 1014.4278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"537  \
\\!\\(\\*\\nStyleBox[\\\"2.0\\\",\\nFontSlant->\\\"Italic\\\",\\nFontTracking-\
>\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\\n\\\"Masked\
\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->0,\\n\\\"\
Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\"->False}\
]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {9.2, 1014.4278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"906  \
\\!\\(\\*\\nStyleBox[\\\"2.1\\\",\\nFontSlant->\\\"Italic\\\",\\nFontTracking-\
>\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\\n\\\"Masked\
\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->0,\\n\\\"\
Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\"->False}\
]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {8.7, 1072.3278541666666`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"692  \
\\!\\(\\*\\nStyleBox[\\\"4.4\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {8.2, 1170.0278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"1219  \
\\!\\(\\*\\nStyleBox[\\\"1.0\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {7.699999999999999, 1226.1278541666666`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"1060  \
\\!\\(\\*\\nStyleBox[\\\"2.3\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {7.199999999999999, 1226.1278541666666`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"748  \
\\!\\(\\*\\nStyleBox[\\\"3.0\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {6.7, 1226.1278541666666`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"1174  \
\\!\\(\\*\\nStyleBox[\\\"5.9\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {6.199999999999999, 1339.7278541666667`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"862  \
\\!\\(\\*\\nStyleBox[\\\"5.4\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {5.699999999999998, 1339.7278541666667`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"1246  \
\\!\\(\\*\\nStyleBox[\\\"5.4\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {5.199999999999999, 1411.9278541666665`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"595  \
\\!\\(\\*\\nStyleBox[\\\"5.7\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {4.699999999999999, 1411.9278541666665`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"398  \
\\!\\(\\*\\nStyleBox[\\\"2.9\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {4.199999999999999, 1411.9278541666665`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"1081  \
\\!\\(\\*\\nStyleBox[\\\"1.6\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {3.6999999999999993`, 1558.7278541666665`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"544  \
\\!\\(\\*\\nStyleBox[\\\"0.9\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {3.2, 1558.7278541666665`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"1444  \
\\!\\(\\*\\nStyleBox[\\\"2.3\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {2.6999999999999993`, 1610.5278541666667`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox["\<\"1134  \
\\!\\(\\*\\nStyleBox[\\\"2.5\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[1],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {2.1999999999999993`, 1610.5278541666667`}, {-1, 0},
      Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(\[InvisiblePrefixScriptBase]\\),\
 \\(166\\)]\\)Hf\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->35,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {7., -99.99999999999997}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(0\\), \\(+\\)]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 2.842170943040401*^-14}, {-1, -0.75}, Automatic, {1,
      0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0.0\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 2.842170943040401*^-14}, {1, -0.75}, Automatic, {1,
      0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(2\\), \\(+\\)]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 158.60000000000002`}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"158.6\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 158.60000000000002`}, {1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(4\\), \\(+\\)]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 470.5}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"470.5\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 470.5}, {1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(2\\), \\(+\\)]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 791.5803645833333}, {-1, -0.75}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"809.9\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 791.5803645833333}, {1, -0.75}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(6\\), \\(+\\)]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 886.20821875}, {-1, -0.75}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"897.2\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 886.20821875}, {1, -0.75}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(3\\), \\(+\\)]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 981.4525104166667}, {-1, -0.75}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1007.1\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 981.4525104166667}, {1, -0.75}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(\\!\\(\\*SuperscriptBox[\\(0\\), \\(+\\)]\\))\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 1083.3196354166666`}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1065.0\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 1083.3196354166666`}, {1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1162.7\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 1162.7}, {1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(\\!\\(\\*SuperscriptBox[\\(2\\), \\(+\\)]\\))\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 1248.1114166666666`}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1218.8\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 1248.1114166666666`}, {1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1332.4\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 1332.4}, {1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1404.6\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 1404.6}, {1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(\\!\\(\\*SuperscriptBox[\\(5\\), \\(+\\)]\\))\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1, 1525.7525104166668`}, {-1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1551.4\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 1525.7525104166668`}, {1, -0.75}, Automatic, {1, 
     0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1603.2\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {13.9, 1603.2}, {1, -0.75}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"159  \
\\!\\(\\*\\nStyleBox[\\\"100\\\",\\nFontSlant->\\\"Italic\\\",\\nFontTracking-\
>\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\\n\\\"Masked\
\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->0,\\n\\\"\
Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\"->False}\
]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {12.2, 165.92785416666663`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"312  \
\\!\\(\\*\\nStyleBox[\\\"44.7\\\",\\nFontSlant->\\\"Italic\\\",\\\
nFontTracking->\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\
\\n\\\"Masked\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->\
0,\\n\\\"Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\
\"->False}]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.699999999999998`, 477.82785416666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"810  \
\\!\\(\\*\\nStyleBox[\\\"20.2\\\",\\nFontSlant->\\\"Italic\\\",\\\
nFontTracking->\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\
\\n\\\"Masked\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->\
0,\\n\\\"Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\
\"->False}]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {11.2, 817.2278541666666}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"651  \
\\!\\(\\*\\nStyleBox[\\\"18.9\\\",\\nFontSlant->\\\"Italic\\\",\\\
nFontTracking->\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\
\\n\\\"Masked\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->\
0,\\n\\\"Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\
\"->False}]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {10.7, 817.2278541666666}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"427  \
\\!\\(\\*\\nStyleBox[\\\"1.2\\\",\\nFontSlant->\\\"Italic\\\",\\nFontTracking-\
>\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\\n\\\"Masked\
\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->0,\\n\\\"\
Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\"->False}\
]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {10.2, 904.5278541666664}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"848  \
\\!\\(\\*\\nStyleBox[\\\"12.7\\\",\\nFontSlant->\\\"Italic\\\",\\\
nFontTracking->\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\
\\n\\\"Masked\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->\
0,\\n\\\"Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\
\"->False}]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {9.7, 1014.4278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"537  \
\\!\\(\\*\\nStyleBox[\\\"2.0\\\",\\nFontSlant->\\\"Italic\\\",\\nFontTracking-\
>\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\\n\\\"Masked\
\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->0,\\n\\\"\
Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\"->False}\
]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {9.2, 1014.4278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"906  \
\\!\\(\\*\\nStyleBox[\\\"2.1\\\",\\nFontSlant->\\\"Italic\\\",\\nFontTracking-\
>\\\"Plain\\\",\\nFontVariations->{\\\"CompatibilityType\\\"->0,\\n\\\"Masked\
\\\"->False,\\n\\\"Outline\\\"->False,\\n\\\"RotationAngle\\\"->0,\\n\\\"\
Shadow\\\"->False,\\n\\\"StrikeThrough\\\"->False,\\n\\\"Underline\\\"->False}\
]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {8.7, 1072.3278541666666`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"692  \
\\!\\(\\*\\nStyleBox[\\\"4.4\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {8.2, 1170.0278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1219  \
\\!\\(\\*\\nStyleBox[\\\"1.0\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {7.699999999999999, 1226.1278541666666`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1060  \
\\!\\(\\*\\nStyleBox[\\\"2.3\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {7.199999999999999, 1226.1278541666666`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"748  \
\\!\\(\\*\\nStyleBox[\\\"3.0\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.7, 1226.1278541666666`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1174  \
\\!\\(\\*\\nStyleBox[\\\"5.9\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {6.199999999999999, 1339.7278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"862  \
\\!\\(\\*\\nStyleBox[\\\"5.4\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {5.699999999999998, 1339.7278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1246  \
\\!\\(\\*\\nStyleBox[\\\"5.4\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {5.199999999999999, 1411.9278541666665`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"595  \
\\!\\(\\*\\nStyleBox[\\\"5.7\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {4.699999999999999, 1411.9278541666665`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"398  \
\\!\\(\\*\\nStyleBox[\\\"2.9\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {4.199999999999999, 1411.9278541666665`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1081  \
\\!\\(\\*\\nStyleBox[\\\"1.6\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {3.6999999999999993`, 1558.7278541666665`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"544  \
\\!\\(\\*\\nStyleBox[\\\"0.9\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {3.2, 1558.7278541666665`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1444  \
\\!\\(\\*\\nStyleBox[\\\"2.3\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.6999999999999993`, 1610.5278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1134  \
\\!\\(\\*\\nStyleBox[\\\"2.5\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->20,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.1999999999999993`, 1610.5278541666667`}, {-1, 0}, 
     Automatic, {-6.123233995736766*^-17, 1.}]}},
  AspectRatio->1,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{576, 576},
  PlotRange->{{-1.0016, 15.0016}, {-200.211, 1910.211}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.497225112109375*^9, 3.507513558015625*^9, 
  3.56683652093386*^9, 3.5668376805455465`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nuclear shell model diagram", "Section",
 CellChangeTimes->{{3.49226220584375*^9, 3.492262216140625*^9}, 
   3.492288068421875*^9, {3.4922886865625*^9, 3.49228868796875*^9}}],

Cell["\<\
Example of writing simple functions to automatically create the list of \
levels to plot, calcule the level energies, generate the labels, etc.\
\>", "Text",
 CellChangeTimes->{{3.492288075203125*^9, 3.49228809359375*^9}, {
  3.49228846959375*^9, 3.492288548359375*^9}}],

Cell["\<\
Labeling -- spectroscopic notation and color scheme for levels\
\>", "Text",
 CellChangeTimes->{{3.492288107703125*^9, 3.492288130859375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "0", "]"}], "=", "\"\<s\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "1", "]"}], "=", "\"\<p\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "2", "]"}], "=", "\"\<d\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "3", "]"}], "=", "\"\<f\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "4", "]"}], "=", "\"\<g\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "5", "]"}], "=", "\"\<h\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "6", "]"}], "=", "\"\<i\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "7", "]"}], "=", "\"\<j\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "8", "]"}], "=", "\"\<k\>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.49226469321875*^9, 3.492264755703125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ShellLabel", "[", 
    RowBox[{"{", 
     RowBox[{"n_", ",", "l_", ",", "j_"}], "}"}], "]"}], ":=", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"Subscript", "[", 
       RowBox[{
        RowBox[{"SpectroscopicLetter", "[", "l", "]"}], ",", 
        RowBox[{"SolidusFractionize", "[", "j", "]"}]}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShellGrade", "[", 
    RowBox[{"{", 
     RowBox[{"n_", ",", "l_", ",", "j_"}], "}"}], "]"}], ":=", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "l"}], ",", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShellColor", "[", 
    RowBox[{"{", 
     RowBox[{"n_", ",", "l_", ",", "j_"}], "}"}], "]"}], ":=", 
   RowBox[{"Switch", "[", 
    RowBox[{
     RowBox[{"ShellGrade", "[", 
      RowBox[{"{", 
       RowBox[{"n", ",", "l", ",", "j"}], "}"}], "]"}], ",", "0", ",", "Blue",
      ",", "1", ",", "Red"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.492264649796875*^9, 3.4922646850625*^9}, {
  3.492264779640625*^9, 3.492264836*^9}, {3.49226632103125*^9, 
  3.49226639190625*^9}}],

Cell["Energy function", "Text",
 CellChangeTimes->{{3.492288090015625*^9, 3.49228809221875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ESM", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ho_", ",", "D_", ",", "xi_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n_", ",", "l_", ",", "j_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", "n"}], "+", "l", "+", 
       RowBox[{"3", "/", "2"}]}], ")"}], "*", "ho"}], "+", 
    RowBox[{"D", "*", "l", "*", 
     RowBox[{"(", 
      RowBox[{"l", "+", "1"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "*", "xi", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "l"}], "*", 
        RowBox[{"KroneckerDelta", "[", 
         RowBox[{"j", ",", 
          RowBox[{"l", "+", 
           RowBox[{"1", "/", "2"}]}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}], "*", 
        RowBox[{"KroneckerDelta", "[", 
         RowBox[{"j", ",", 
          RowBox[{"l", "-", 
           RowBox[{"1", "/", "2"}]}]}], "]"}]}]}], ")"}]}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.492262293*^9, 3.492262396265625*^9}, 
   3.492263307328125*^9}],

Cell["Generating set of orbitals by major shell", "Text",
 CellChangeTimes->{{3.49228813553125*^9, 3.4922881408125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LevelSetOrbital", "[", "N_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"N", "-", "l"}], ")"}]}], ",", "l"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", 
       RowBox[{"Mod", "[", 
        RowBox[{"N", ",", "2"}], "]"}], ",", "N", ",", "2"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelSetSpinOrbit", "[", "NMax_", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "l", ",", "j"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Last", "[", 
      RowBox[{"Last", "[", 
       RowBox[{"Reap", "[", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"n", ",", "l"}], "}"}], "=", "nl"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"j", "=", 
            RowBox[{"l", "+", 
             RowBox[{"sigma", "*", 
              RowBox[{"1", "/", "2"}]}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"j", ">", "0"}], ",", 
             RowBox[{"Sow", "[", 
              RowBox[{"{", 
               RowBox[{"n", ",", "l", ",", "j"}], "}"}], "]"}]}], "]"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"N", ",", "0", ",", "NMax"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"nl", ",", 
            RowBox[{"LevelSetOrbital", "[", "N", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"sigma", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", 
              RowBox[{"+", "1"}]}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
         "]"}], "\[IndentingNewLine]", "]"}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.492262405796875*^9, 3.49226241809375*^9}, {
   3.49226245740625*^9, 3.49226253490625*^9}, {3.49226256825*^9, 
   3.4922627654375*^9}, {3.49226279753125*^9, 3.49226279871875*^9}, {
   3.4922638994375*^9, 3.492263903234375*^9}, {3.49228816740625*^9, 
   3.492288174359375*^9}, 3.507513517640625*^9, {3.507513605375*^9, 
   3.5075136363125*^9}}],

Cell["Specifically, levels through N=3 plus g9/2 orbit", "Text",
 CellChangeTimes->{{3.49228819971875*^9, 3.49228822434375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotLevelSet", "=", 
  RowBox[{"Append", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LevelSetSpinOrbit", "[", "3", "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", 
      RowBox[{"9", "/", "2"}]}], "}"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4922639515*^9, 3.492263980421875*^9}, {
   3.492264606625*^9, 3.49226463459375*^9}, {3.492264914015625*^9, 
   3.492264946109375*^9}, 3.4922665214375*^9, 3.49228814609375*^9, {
   3.492288178046875*^9, 3.492288188828125*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     FractionBox["3", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", 
     FractionBox["3", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", 
     FractionBox["5", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     FractionBox["3", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", 
     FractionBox["5", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", 
     FractionBox["7", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4", ",", 
     FractionBox["9", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.49228818921875*^9, 3.50751355821875*^9, {3.507513613796875*^9, 
   3.507513639*^9}, 3.566836530613873*^9, 3.5668376805730467`*^9}]
}, Open  ]],

Cell["Make plot", "Text",
 CellChangeTimes->{{3.492288230171875*^9, 3.49228823134375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"HOParams", "=", 
   RowBox[{"{", 
    RowBox[{"6.9", ",", 
     RowBox[{"-", "0.3"}], ",", 
     RowBox[{"-", "0.6"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HOParams0", "=", 
   RowBox[{"HOParams", "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HOParams1", "=", 
   RowBox[{"HOParams", "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HOParams2", "=", 
   RowBox[{"HOParams", "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"Thickness", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Connector", ",", 
       RowBox[{"Dashing", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOrigin", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Lev", "[", 
        RowBox[{"0", ",", "1", ",", 
         RowBox[{"ESM", "[", 
          RowBox[{"HOParams0", ",", "nlj"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Color", "\[Rule]", 
          RowBox[{"ShellColor", "[", "nlj", "]"}]}], ",", 
         RowBox[{"Tag", "\[Rule]", 
          RowBox[{"lev", "[", 
           RowBox[{"{", 
            RowBox[{"nlj", ",", "0"}], "}"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"OffsetL", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"+", "1"}], ",", "0"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Switch", "[", "\[IndentingNewLine]", 
          RowBox[{"nlj", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "l_", ",", "j_"}], "}"}], "/;", 
            RowBox[{"(", 
             RowBox[{"j", "\[Equal]", 
              RowBox[{"l", "+", 
               RowBox[{"1", "/", "2"}]}]}], ")"}]}], ",", 
           RowBox[{"LabL", "\[Rule]", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"nlj", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               "\"\<\[ThinSpace]\[HBar]\[Omega]\>\""}], "}"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "_", ",", 
           RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
        "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"nlj", ",", "PlotLevelSet"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOrigin", "[", "1", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Lev", "[", 
          RowBox[{"0", ",", "1", ",", 
           RowBox[{"ESM", "[", 
            RowBox[{"HOParams1", ",", "nlj"}], "]"}], ",", 
           RowBox[{"Color", "\[Rule]", 
            RowBox[{"ShellColor", "[", "nlj", "]"}]}], ",", 
           RowBox[{"Tag", "\[Rule]", 
            RowBox[{"lev", "[", 
             RowBox[{"{", 
              RowBox[{"nlj", ",", "1"}], "}"}], "]"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Connector", "[", 
          RowBox[{
           RowBox[{"lev", "[", 
            RowBox[{"{", 
             RowBox[{"nlj", ",", "0"}], "}"}], "]"}], ",", 
           RowBox[{"lev", "[", 
            RowBox[{"{", 
             RowBox[{"nlj", ",", "1"}], "}"}], "]"}], ",", 
           RowBox[{"Color", "\[Rule]", 
            RowBox[{"ShellColor", "[", "nlj", "]"}]}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"nlj", ",", "PlotLevelSet"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOrigin", "[", "2", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Lev", "[", 
          RowBox[{"0", ",", "1", ",", 
           RowBox[{"ESM", "[", 
            RowBox[{"HOParams2", ",", "nlj"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Color", "\[Rule]", 
            RowBox[{"ShellColor", "[", "nlj", "]"}]}], ",", 
           RowBox[{"Tag", "\[Rule]", 
            RowBox[{"lev", "[", 
             RowBox[{"{", 
              RowBox[{"nlj", ",", "2"}], "}"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"LabR", "\[Rule]", 
            RowBox[{"Grid", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ShellLabel", "[", "nlj", "]"}], ",", 
                 RowBox[{"FixedPointForm", "[", 
                  RowBox[{
                   RowBox[{"ESM", "[", 
                    RowBox[{"HOParams2", ",", "nlj"}], "]"}], ",", "2"}], 
                  "]"}]}], "}"}], "}"}], ",", 
              RowBox[{"ItemSize", "\[Rule]", "3"}], ",", 
              RowBox[{"Spacings", "\[Rule]", "0"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"OffsetR", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"special", " ", "adjustments"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"Switch", "[", "\[IndentingNewLine]", 
            RowBox[{"nlj", ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", 
               RowBox[{"3", "/", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"NudgeC", "\[Rule]", 
                RowBox[{"-", "3"}]}], ",", 
               RowBox[{"NudgeR", "\[Rule]", 
                RowBox[{"-", "3"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", 
               RowBox[{"1", "/", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"NudgeC", "\[Rule]", 
                RowBox[{"+", "6"}]}], ",", 
               RowBox[{"NudgeR", "\[Rule]", 
                RowBox[{"+", "6"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
             "_", ",", 
             RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Connector", "[", 
          RowBox[{
           RowBox[{"lev", "[", 
            RowBox[{"{", 
             RowBox[{"nlj", ",", "1"}], "}"}], "]"}], ",", 
           RowBox[{"lev", "[", 
            RowBox[{"{", 
             RowBox[{"nlj", ",", "2"}], "}"}], "]"}], ",", 
           RowBox[{"Color", "\[Rule]", 
            RowBox[{"ShellColor", "[", "nlj", "]"}]}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"nlj", ",", "PlotLevelSet"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"BandLabel", ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], ",", 
       RowBox[{"Nudge", "\[Rule]", 
        RowBox[{"-", "25"}]}]}], "]"}], ",", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "align", " ", "bottoms", " ", "rather", " ", "than", " ", "top", " ", 
       "of", " ", "subscript"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"BandLabel", "[", 
      RowBox[{
       RowBox[{"lev", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", 
            RowBox[{"1", "/", "2"}]}], "}"}], ",", "0"}], "}"}], "]"}], ",", 
       "\"\<HO\>\""}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BandLabel", "[", 
      RowBox[{
       RowBox[{"lev", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", 
            RowBox[{"1", "/", "2"}]}], "}"}], ",", "1"}], "}"}], "]"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<HO+\>\"", ",", 
          RowBox[{"Superscript", "[", 
           RowBox[{
            RowBox[{"textbf", "[", "\"\<\[ScriptL]\>\"", "]"}], ",", "2"}], 
           "]"}]}], "}"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BandLabel", "[", 
      RowBox[{
       RowBox[{"lev", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", 
            RowBox[{"1", "/", "2"}]}], "}"}], ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<HO+\>\"", ",", 
          RowBox[{"Superscript", "[", 
           RowBox[{
            RowBox[{"textbf", "[", "\"\<\[ScriptL]\>\"", "]"}], ",", "2"}], 
           "]"}], ",", "\"\<+\>\"", ",", 
          RowBox[{"textbf", "[", "\"\<\[ScriptL]\>\"", "]"}], ",", 
          "\"\<\[CenterDot]\>\"", ",", 
          RowBox[{"textbf", "[", "\"\<s\>\"", "]"}]}], "}"}], "]"}]}], "]"}], 
     ","}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "35"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.40243520075*^9, 3.40243524146875*^9}, {
   3.402435289734375*^9, 3.402435537453125*^9}, {3.402435570578125*^9, 
   3.402435759390625*^9}, {3.40243588296875*^9, 3.40243591275*^9}, {
   3.40829301315625*^9, 3.40829302334375*^9}, {3.49226222871875*^9, 
   3.492262231953125*^9}, {3.492262808703125*^9, 3.4922629375625*^9}, {
   3.49226303015625*^9, 3.4922630304375*^9}, {3.492263068609375*^9, 
   3.492263069609375*^9}, {3.492263262421875*^9, 3.492263270140625*^9}, {
   3.492263924328125*^9, 3.4922639318125*^9}, {3.49226484984375*^9, 
   3.492264883125*^9}, {3.492265680125*^9, 3.49226572640625*^9}, {
   3.4922660951875*^9, 3.492266199390625*^9}, {3.492266232984375*^9, 
   3.492266241875*^9}, {3.492266363453125*^9, 3.492266363734375*^9}, {
   3.49226639928125*^9, 3.492266454734375*^9}, {3.4922666233125*^9, 
   3.4922666421875*^9}, 3.492266688765625*^9, {3.492266750296875*^9, 
   3.49226676521875*^9}, {3.492266808546875*^9, 3.492267030671875*^9}, {
   3.49226717971875*^9, 3.49226718025*^9}, 3.492267291203125*^9, {
   3.4922673844375*^9, 3.492267413234375*^9}, {3.492267464765625*^9, 
   3.492267729546875*^9}, {3.492267768390625*^9, 3.492267939953125*^9}, 
   3.4922760386875*^9, {3.492286894796875*^9, 3.49228691540625*^9}, 
   3.49228701034375*^9, {3.49228705271875*^9, 3.4922870935625*^9}, {
   3.492287209328125*^9, 3.49228724259375*^9}, {3.492287297171875*^9, 
   3.492287342578125*^9}, {3.4922874141875*^9, 3.492287423765625*^9}, {
   3.492287474734375*^9, 3.49228752403125*^9}, {3.4922882399375*^9, 
   3.492288433640625*^9}, {3.492288660015625*^9, 3.49228866584375*^9}, {
   3.5668377056455975`*^9, 3.5668377125506067`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 10.350000000000001`}, {
     0.8999999999999999, 10.350000000000001`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 17.249999999999996`}, {
     0.8999999999999999, 17.249999999999996`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 17.249999999999996`}, {
     0.8999999999999999, 17.249999999999996`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 24.15}, {0.8999999999999999, 
     24.15}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 24.15}, {0.8999999999999999, 
     24.15}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 24.15}, {0.8999999999999999, 
     24.15}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 31.049999999999997`}, {
     0.8999999999999999, 31.049999999999997`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 31.049999999999997`}, {
     0.8999999999999999, 31.049999999999997`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 31.049999999999997`}, {
     0.8999999999999999, 31.049999999999997`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.09999999999999999, 31.049999999999997`}, {
     0.8999999999999999, 31.049999999999997`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 10.350000000000001`}, {
     1.8999999999999997`, 10.350000000000001`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 10.350000000000001`}, {1.0999999999999999`, 
     10.350000000000001`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 16.649999999999995`}, {
     1.8999999999999997`, 16.649999999999995`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 17.249999999999996`}, {1.0999999999999999`, 
     16.649999999999995`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 16.649999999999995`}, {
     1.8999999999999997`, 16.649999999999995`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 17.249999999999996`}, {1.0999999999999999`, 
     16.649999999999995`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 24.15}, {1.8999999999999997`, 
     24.15}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 24.15}, {1.0999999999999999`, 24.15}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 22.349999999999998`}, {
     1.8999999999999997`, 22.349999999999998`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 24.15}, {1.0999999999999999`, 
     22.349999999999998`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 22.349999999999998`}, {
     1.8999999999999997`, 22.349999999999998`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 24.15}, {1.0999999999999999`, 
     22.349999999999998`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 30.449999999999996`}, {
     1.8999999999999997`, 30.449999999999996`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 31.049999999999997`}, {1.0999999999999999`, 
     30.449999999999996`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 30.449999999999996`}, {
     1.8999999999999997`, 30.449999999999996`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 31.049999999999997`}, {1.0999999999999999`, 
     30.449999999999996`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 27.45}, {1.8999999999999997`, 
     27.45}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 31.049999999999997`}, {1.0999999999999999`, 
     27.45}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.0999999999999999`, 27.45}, {1.8999999999999997`, 
     27.45}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.8999999999999999, 31.049999999999997`}, {1.0999999999999999`, 
     27.45}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], 
    LineBox[{{1.0999999999999999`, 31.95}, {1.8999999999999997`, 31.95}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{0.9982333333333331, 35.003}, {1.0999999999999999`, 31.95}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 10.350000000000001`}, {
     2.8999999999999995`, 10.350000000000001`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 10.350000000000001`}, {2.099999999999999, 
     10.350000000000001`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 17.249999999999996`}, {
     2.8999999999999995`, 17.249999999999996`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 16.649999999999995`}, {2.099999999999999, 
     17.249999999999996`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 16.349999999999994`}, {
     2.8999999999999995`, 16.349999999999994`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 16.649999999999995`}, {2.099999999999999, 
     16.349999999999994`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 24.15}, {2.8999999999999995`, 
     24.15}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 24.15}, {2.099999999999999, 24.15}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 23.249999999999996`}, {
     2.8999999999999995`, 23.249999999999996`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 22.349999999999998`}, {2.099999999999999, 
     23.249999999999996`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 21.749999999999996`}, {
     2.8999999999999995`, 21.749999999999996`}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 22.349999999999998`}, {2.099999999999999, 
     21.749999999999996`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 31.049999999999997`}, {
     2.8999999999999995`, 31.049999999999997`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 30.449999999999996`}, {2.099999999999999, 
     31.049999999999997`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 30.149999999999995`}, {
     2.8999999999999995`, 30.149999999999995`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 30.449999999999996`}, {2.099999999999999, 
     30.149999999999995`}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 28.65}, {2.8999999999999995`, 
     28.65}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 27.45}, {2.099999999999999, 28.65}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 26.55}, {2.8999999999999995`, 
     26.55}}]}, 
   {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 27.45}, {2.099999999999999, 26.55}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.099999999999999, 30.75}, {2.8999999999999995`, 
     30.75}}]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{2, 1}], CapForm[None], 
    LineBox[{{1.8999999999999997`, 31.95}, {2.099999999999999, 30.75}}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"0","\"\[ThinSpace]\:f7d8\[Omega]\""},
         "RowDefault"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0, 0, 1],
       FontOpacity->1],
      DisplayForm], {0.09999999999999999, 10.350000000000001`}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"1","\"\[ThinSpace]\:f7d8\[Omega]\""},
         "RowDefault"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[1, 0, 0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999999, 17.249999999999996`}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"2","\"\[ThinSpace]\:f7d8\[Omega]\""},
         "RowDefault"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0, 0, 1],
       FontOpacity->1],
      DisplayForm], {0.09999999999999999, 24.15}, {1, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"3","\"\[ThinSpace]\:f7d8\[Omega]\""},
         "RowDefault"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[1, 0, 0],
       FontOpacity->1],
      DisplayForm], {0.09999999999999999, 31.049999999999997`}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"0",SubscriptBox["\"s\"", 
               GridBox[{{
                  TagBox["1", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 10.35\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0, 0, 1],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 10.350000000000001`}, {-1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"0",SubscriptBox["\"p\"", 
               GridBox[{{
                  TagBox["1", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 17.25\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[1, 0, 0],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 17.249999999999996`}, {-1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"0",SubscriptBox["\"p\"", 
               GridBox[{{
                  TagBox["3", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 16.35\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[1, 0, 0],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 16.349999999999994`}, {-1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"1",SubscriptBox["\"s\"", 
               GridBox[{{
                  TagBox["1", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 24.15\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0, 0, 1],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 24.15}, {-1, 0}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"0",SubscriptBox["\"d\"", 
               GridBox[{{
                  TagBox["3", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 23.25\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0, 0, 1],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 23.249999999999996`}, {-1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"0",SubscriptBox["\"d\"", 
               GridBox[{{
                  TagBox["5", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 21.75\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0, 0, 1],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 21.749999999999996`}, {-1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"1",SubscriptBox["\"p\"", 
               GridBox[{{
                  TagBox["1", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 31.05\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[1, 0, 0],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 31.466749999999998`}, {-1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"1",SubscriptBox["\"p\"", 
               GridBox[{{
                  TagBox["3", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 30.15\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[1, 0, 0],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 29.941624999999995`}, {-1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"0",SubscriptBox["\"f\"", 
               GridBox[{{
                  TagBox["5", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 28.65\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[1, 0, 0],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 28.65}, {-1, 0}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"0",SubscriptBox["\"f\"", 
               GridBox[{{
                  TagBox["7", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 26.55\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[1, 0, 0],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 26.55}, {-1, 0}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[GridBox[{
           {
            TemplateBox[{"0",SubscriptBox["\"g\"", 
               GridBox[{{
                  TagBox["9", DisplayForm], "/", 
                  TagBox["2", DisplayForm]}}, 
                BaselinePosition -> {Baseline, {1, 3}}, 
                GridBoxSpacings -> {"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[-0.06999999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}]]},
             "RowDefault"], "\<\" 30.75\"\>"}
          },
          AutoDelete->False,
          GridBoxItemSize->{"Columns" -> {{3}}},
          GridBoxSpacings->{"Columns" -> {{0}}}],
         "Grid"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->RGBColor[0, 0, 1],
       FontOpacity->1],
      DisplayForm], {2.8999999999999995`, 30.75}, {-1, 0}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"HO\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.49999999999999994`, 8.613541666666668}, {0, -1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"\"HO+\"",TemplateBox[{
            TagBox[
             StyleBox["\"\[ScriptL]\"", FontWeight -> "Bold"], 
             StyleForm[#, FontWeight -> "Bold"]& ], "2"}, "Superscript"]},
         "RowDefault"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.4999999999999998`, 8.613541666666668}, {0, -1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"\"HO+\"",TemplateBox[{
            TagBox[
             StyleBox["\"\[ScriptL]\"", FontWeight -> "Bold"], 
             StyleForm[#, FontWeight -> "Bold"]& ], "2"}, "Superscript"],
          "\"+\"",TagBox[
           StyleBox["\"\[ScriptL]\"", FontWeight -> "Bold"], 
           StyleForm[#, FontWeight -> "Bold"]& ],"\"\[CenterDot]\"",TagBox[
           StyleBox["\"s\"", FontWeight -> "Bold"], 
           StyleForm[#, FontWeight -> "Bold"]& ]},
         "RowDefault"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.499999999999999, 8.613541666666668}, {0, -1}, 
     Automatic, {1, 0}]}},
  AspectRatio->1,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{432, 432},
  PlotRange->{{-1.0005, 4.0005}, {4.997, 35.003}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.492288406125*^9, 3.492288434921875*^9}, 
   3.492288666953125*^9, 3.5075135591875*^9, 3.507513641671875*^9, 
   3.5668365320288754`*^9, 3.5668376808805513`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Molecular potentials and spectra: Combining plots and level schemes in one \
figure\
\>", "Section",
 CellChangeTimes->{{3.492288566921875*^9, 3.4922886273125*^9}}],

Cell["\<\
This figure illustrates several possibilities for drawing a figure:

\t1. Creating multipanel plots with unequal panel sizes, gaps between panels, \
and colored frames
\t
\t2. Including functions in a plot, and controlling their appearance by \
changing the default options (here Thickness) for RawGraphics
\t
\t3. Drawing axes with SchemeAxis
\t
\t4. Annotating plots with drawing objects, here SchemeCircle
\t
\t5. Defining functions (here U2Lev and SO3Lev) to draw levels based on \
energy formulas
\t
\t6. Using Table to construct level schemes with many levels automatically\t\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"U2Lev", "[", 
    RowBox[{"k_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Lev", "[", 
    RowBox[{
     RowBox[{"lev", "[", 
      RowBox[{"k", ",", "n"}], "]"}], ",", "k", ",", 
     RowBox[{"k", "+", "1"}], ",", 
     RowBox[{"epsilon", "*", "n"}], ",", 
     RowBox[{"LabL", "\[Rule]", 
      RowBox[{"n", "-", 
       RowBox[{"2", "*", "k"}]}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SO3Lev", "[", 
     RowBox[{"v_", ",", "l_"}], "]"}], ":=", 
    RowBox[{"Lev", "[", 
     RowBox[{
      RowBox[{"lev", "[", 
       RowBox[{"v", ",", "l"}], "]"}], ",", "v", ",", 
      RowBox[{"v", "+", "1"}], ",", 
      RowBox[{"v", "+", 
       RowBox[{"b", "*", 
        RowBox[{"l", "^", "2"}]}]}], ",", 
      RowBox[{"LabL", "\[Rule]", "l"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"scrE", "=", 
    RowBox[{"textit", "[", "\"\<E\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MS", " ", "Windows", " ", 
      RowBox[{"users", " ", "--"}], " ", "try", " ", "using", " ", "this", 
      " ", "definition", " ", "for", " ", "a", " ", "fancy", " ", "script", 
      " ", 
      RowBox[{"E", ":", "\[IndentingNewLine]", "scrE"}]}], "=", 
     RowBox[{"textbf", "[", 
      RowBox[{"textfamily", "[", 
       RowBox[{"\"\<Script\>\"", ",", "\"\<E\>\""}], "]"}], "]"}]}], ";"}], 
   "   ", "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"set", " ", "up", " ", "drawing", " ", "options"}], " ", "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeObject", ",", 
       RowBox[{"FontFamily", "->", "\"\<Times New Roman\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"ScaledLabel", ",", 
       RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"OffsetL", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", "1"}], ",", "0"}], "}"}]}], ",", 
       RowBox[{"Thickness", "\[Rule]", "2"}], ",", 
       RowBox[{"Margin", "\[Rule]", "0.2"}], ",", 
       RowBox[{"WingTipWidth", "\[Rule]", "10"}], ",", 
       RowBox[{"WingRiseWidth", "\[Rule]", "5"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"HeadLength", "\[Rule]", "5"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "2"}], ",", 
       RowBox[{"Thickness", "\[Rule]", "1.5"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"RawGraphics", ",", 
       RowBox[{"Thickness", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeAxis", ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"set", " ", "up", " ", "multipanel", " ", "plot"}], " ", "*)"}],
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XPanelSizes", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.6", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"XGapSizes", "\[Rule]", "0.1"}], ",", "\[IndentingNewLine]", 
       RowBox[{"YGapSizes", "\[Rule]", "0.1"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ShowPanelLetter", "\[Rule]", "False"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LineColor", "\[Rule]", "Gray"}], ",", 
       RowBox[{"ShowTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"False", ",", "False", ",", "False", ",", "False"}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Margin", "\[Rule]", "1"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"draw", " ", "functions"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"XPlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.6"}], ",", "3.5"}], "}"}]}], ",", 
       RowBox[{"YPlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.4"}], ",", "1.3"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeAxis", "[", 
      RowBox[{"Left", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"LabL", "\[Rule]", "scrE"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeAxis", "[", 
      RowBox[{"Bottom", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3.2"}], "}"}], ",", "0", ",", 
       RowBox[{"LabB", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<r\>\"", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"r", "^", "2"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{"r", "^", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Point", "[", "3", "]"}], ",", 
       RowBox[{"Color", "\[Rule]", "VenetianRed"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"XPlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.6"}], ",", "3.5"}], "}"}]}], ",", 
       RowBox[{"YPlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.5"}], ",", "0.5"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeAxis", "[", 
      RowBox[{"Left", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.1"}], ",", "0.2"}], "}"}], ",", 
       RowBox[{"LabL", "\[Rule]", "scrE"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeAxis", "[", 
      RowBox[{"Bottom", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3.2"}], "}"}], ",", "0", ",", 
       RowBox[{"LabB", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<r\>\"", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"r", "^", "2"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}], "*", 
         RowBox[{"r", "^", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"Point", "[", "3", "]"}], ",", 
       RowBox[{"Color", "\[Rule]", "Blue"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"draw", " ", "level", " ", "schemes"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"XPlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.8"}], ",", "3.2"}], "}"}]}], ",", 
       RowBox[{"YPlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "3"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"LineColor", "\[Rule]", "VenetianRed"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"epsilon", "=", "0.6"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"U2Lev", "[", 
        RowBox[{"k", ",", "n"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"2", "*", "k"}], ",", "4"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"LevelLabel", "[", 
        RowBox[{
         RowBox[{"lev", "[", 
          RowBox[{"0", ",", "n"}], "]"}], ",", "Left", ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"textit", "[", "\"\<n\>\"", "]"}], ",", "\"\<=\>\"", ",", 
            "n"}], "}"}], "]"}], ",", 
         RowBox[{"Gap", "\[Rule]", "15"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7", ",", "0.2"}], "}"}], ",", "\"\<U(2)\>\""}], "]"}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"XPlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.2"}], ",", "3.2"}], "}"}]}], ",", 
       RowBox[{"YPlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "3"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"LineColor", "\[Rule]", "Blue"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"b", "=", "0.15"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"SO3Lev", "[", 
        RowBox[{"0", ",", "l"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"SO3Lev", "[", 
        RowBox[{"1", ",", "l"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"SO3Lev", "[", 
        RowBox[{"2", ",", "l"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"BandLabel", "[", 
        RowBox[{
         RowBox[{"lev", "[", 
          RowBox[{"v", ",", "0"}], "]"}], ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"textit", "[", "\"\<v\>\"", "]"}], ",", "\"\<=\>\"", ",", 
            "v"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.7", ",", "0.2"}], "}"}], ",", "\"\<SO(3)\>\""}], "]"}], 
     ","}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "False"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.3950955260625*^9, 3.395095541375*^9}, 
   3.3950956338125*^9, 3.3955211409375*^9, {3.3955214840625*^9, 
   3.39552148421875*^9}, {3.430248040421875*^9, 3.430248068375*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.0023152777777777776`, 0.523715022675737}, {
     0.35362214052287577`, 0.523715022675737}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.0023152777777777776`, 0.523715022675737}, {
     0.0023152777777777776`, 0.9980154761904761}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.0023152777777777776`, 0.9980154761904761}, {
     0.35362214052287577`, 0.9980154761904761}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.35362214052287577`, 0.523715022675737}, {
     0.35362214052287577`, 0.9980154761904761}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.05372603817949944, 0.6074151027077498}, {
     0.05372603817949944, 0.9143153961584634}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.0467802048461661, 0.9024082533013206}, {
     0.05372603817949944, 0.9143153961584634}, {0.06067187151283277, 
     0.9024082533013206}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.05372603817949944, 0.6353151293850874}, {
     0.327916760322015, 0.6353151293850874}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.3140250936553483, 0.6412687008136588}, {
     0.32791676032201494`, 0.6353151293850875}, {0.3140250936553483, 
     0.629361557956516}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Hs81XcYB3BySc3GGJVuJDWV1oUS00diRa0dllzmUu56hTSVsAolGVnm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       "]]}}, 
    {RGBColor[0.829997, 0.099994, 0.119999], Opacity[1], 
     DiskBox[{0.05372603817949944, 0.6353151293850874}, {0.006945833333333333, 0.005953571428571428},
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[1], Opacity[1],
      Dashing[{}], CapForm[None], 
     CircleBox[{0.05372603817949944, 0.6353151293850874}, {0.006945833333333333, 0.005953571428571428},
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.0023152777777777776`, 0.0019845238095239637`}, {
      0.35362214052287577`, 0.0019845238095239637`}}]}, 
    {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None]}, 
    {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.0023152777777777776`, 0.0019845238095239637`}, {
      0.0023152777777777776`, 0.4762849773242631}}]}, 
    {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None]}, 
    {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.0023152777777777776`, 0.4762849773242631}, {
      0.35362214052287577`, 0.4762849773242631}}]}, 
    {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None]}, 
    {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.35362214052287577`, 0.0019845238095239637`}, {
      0.35362214052287577`, 0.4762849773242631}}]}, 
    {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.05372603817949944, 0.09684461451247178}, {
      0.05372603817949944, 0.4051399092970523}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.0467802048461661, 0.39323276643990945`}, {
      0.05372603817949944, 0.4051399092970523}, {0.06067187151283277, 
      0.39323276643990945`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.05372603817949944, 0.35770986394557835`}, {
      0.327916760322015, 0.35770986394557835`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], 
     LineBox[{{0.3140250936553483, 0.3636634353741498}, {0.32791676032201494`,
       0.35770986394557835`}, {0.3140250936553483, 0.35175629251700696`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None]}, 
    {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
     None], {{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4lO0XB3B6SyRFKS16E1FSyhaRvipKodCqPVpFpTeJFyFSspRXSYpk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        "]]}}, 
     {RGBColor[0, 0, 1], Opacity[1], 
      DiskBox[{0.13941063884903554`, 0.12055963718820878`}, {0.006945833333333333, 0.005953571428571428},
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      CircleBox[{0.13941063884903554`, 0.12055963718820878`}, {0.006945833333333333, 0.005953571428571428},
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.41217328431372546`, 0.523715022675737}, {
       0.9976847222222222, 0.523715022675737}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.41217328431372546`, 0.523715022675737}, {
       0.41217328431372546`, 0.9980154761904761}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.41217328431372546`, 0.9980154761904761}, {
       0.9976847222222222, 0.9980154761904761}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.9976847222222222, 0.523715022675737}, {
       0.9976847222222222, 0.9980154761904761}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.5585511437908497, 0.5914722303206997}, {0.6463778594771242, 
       0.5914722303206997}}]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.5585511437908497, 0.672780879494655}, {0.6463778594771242, 
       0.672780879494655}}]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.5585511437908497, 0.7540895286686102}, {0.6463778594771242, 
       0.7540895286686102}}]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.5585511437908497, 0.8353981778425655}, {0.6463778594771242, 
       0.8353981778425655}}]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.5585511437908497, 0.9167068270165208}, {0.6463778594771242, 
       0.9167068270165208}}]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.7049290032679738, 0.7540895286686102}, {0.7927557189542483, 
       0.7540895286686102}}]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.7049290032679738, 0.8353981778425655}, {0.7927557189542483, 
       0.8353981778425655}}]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.7049290032679738, 0.9167068270165208}, {0.7927557189542483, 
       0.9167068270165208}}]}, 
     {RGBColor[0.829997, 0.099994, 0.119999], AbsoluteThickness[2], Opacity[
      1], Dashing[{}], CapForm[None], 
      LineBox[{{0.851306862745098, 0.9167068270165208}, {0.9391335784313726, 
       0.9167068270165208}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.41217328431372546`, 0.0019845238095239637`}, {
       0.9976847222222222, 0.0019845238095239637`}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.41217328431372546`, 0.0019845238095239637`}, {
       0.41217328431372546`, 0.4762849773242631}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.41217328431372546`, 0.4762849773242631}, {
       0.9976847222222222, 0.4762849773242631}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.9976847222222222, 0.0019845238095239637`}, {
       0.9976847222222222, 0.4762849773242631}}]}, 
     {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.4810569828911957, 0.0697417314544867}, {0.584382530757401, 
       0.0697417314544867}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.4810569828911957, 0.09006889374797553}, {0.584382530757401, 
       0.09006889374797553}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.4810569828911957, 0.15105038062844198`}, {0.584382530757401,
        0.15105038062844198`}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.4810569828911957, 0.25268619209588605`}, {0.584382530757401,
        0.25268619209588605`}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.4810569828911957, 0.3949763281503078}, {0.584382530757401, 
       0.3949763281503078}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.6532662293348711, 0.20525614674441217`}, {
       0.7565917772010764, 0.20525614674441217`}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.6532662293348711, 0.22558330903790097`}, {
       0.7565917772010764, 0.22558330903790097`}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.6532662293348711, 0.2865647959183675}, {0.7565917772010764, 
       0.2865647959183675}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.6532662293348711, 0.3882006073858115}, {0.7565917772010764, 
       0.3882006073858115}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.8254754757785466, 0.34077056203433764`}, {
       0.9288010236447519, 0.34077056203433764`}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.8254754757785466, 0.36109772432782644`}, {
       0.9288010236447519, 0.36109772432782644`}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.8254754757785466, 0.42207921120829295`}, {
       0.9288010236447519, 0.42207921120829295`}}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          TagBox[
           StyleBox["\<\"E\"\>",
            FontSlant->"Italic"],
           StyleForm[#, FontSlant -> "Italic"]& ],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->15,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.03346735762394389, 0.7608652494331066}, {0, 0}, 
       Automatic, {0, 1}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          TagBox[
           StyleBox["\<\"r\"\>",
            FontSlant->"Italic"],
           StyleForm[#, FontSlant -> "Italic"]& ],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->15,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.1908213992507572, 0.6179505460517541}, {0, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          TagBox[
           StyleBox["\<\"E\"\>",
            FontSlant->"Italic"],
           StyleForm[#, FontSlant -> "Italic"]& ],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->15,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.03346735762394389, 0.25099226190476204`}, {0, 0}, 
       Automatic, {0, 1}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          TagBox[
           StyleBox["\<\"r\"\>",
            FontSlant->"Italic"],
           StyleForm[#, FontSlant -> "Italic"]& ],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->15,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.1908213992507572, 0.34034528061224506`}, {0, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["0",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.5585511437908497, 0.5914722303206997}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["1",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.5585511437908497, 0.672780879494655}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["2",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.5585511437908497, 0.7540895286686102}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["3",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.5585511437908497, 0.8353981778425655}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["4",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.5585511437908497, 0.9167068270165208}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["0",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.7049290032679738, 0.7540895286686102}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["1",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.7049290032679738, 0.8353981778425655}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["2",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.7049290032679738, 0.9167068270165208}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["0",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.851306862745098, 0.9167068270165208}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          RowBox[{
           TagBox[
            StyleBox["\<\"n\"\>",
             FontSlant->"Italic"],
            StyleForm[#, FontSlant -> "Italic"]& ], "=", "0"}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.523821977124183, 0.5914722303206997}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          RowBox[{
           TagBox[
            StyleBox["\<\"n\"\>",
             FontSlant->"Italic"],
            StyleForm[#, FontSlant -> "Italic"]& ], "=", "1"}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.523821977124183, 0.672780879494655}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          RowBox[{
           TagBox[
            StyleBox["\<\"n\"\>",
             FontSlant->"Italic"],
            StyleForm[#, FontSlant -> "Italic"]& ], "=", "2"}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.523821977124183, 0.7540895286686102}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          RowBox[{
           TagBox[
            StyleBox["\<\"n\"\>",
             FontSlant->"Italic"],
            StyleForm[#, FontSlant -> "Italic"]& ], "=", "3"}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.523821977124183, 0.8353981778425655}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          RowBox[{
           TagBox[
            StyleBox["\<\"n\"\>",
             FontSlant->"Italic"],
            StyleForm[#, FontSlant -> "Italic"]& ], "=", "4"}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.523821977124183, 0.9167068270165208}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["\<\"U(2)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.8220312908496732, 0.6185751133786849}, {0, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["0",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.4810569828911957, 0.0697417314544867}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["1",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.4810569828911957, 0.09006889374797553}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["2",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.4810569828911957, 0.15105038062844198`}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["3",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.4810569828911957, 0.25268619209588605`}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["4",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.4810569828911957, 0.3949763281503078}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["0",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.6532662293348711, 0.20525614674441217`}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["1",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.6532662293348711, 0.22558330903790097`}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["2",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.6532662293348711, 0.2865647959183675}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["3",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.6532662293348711, 0.3882006073858115}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["0",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.8254754757785466, 0.34077056203433764`}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["1",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.8254754757785466, 0.36109772432782644`}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["2",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.8254754757785466, 0.42207921120829295`}, {1, 0}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          RowBox[{
           TagBox[
            StyleBox["\<\"v\"\>",
             FontSlant->"Italic"],
            StyleForm[#, FontSlant -> "Italic"]& ], "=", "0"}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.5327197568242983, 0.0697417314544867}, {0, 1}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          RowBox[{
           TagBox[
            StyleBox["\<\"v\"\>",
             FontSlant->"Italic"],
            StyleForm[#, FontSlant -> "Italic"]& ], "=", "1"}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.7049290032679738, 0.20525614674441217`}, {0, 1}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          RowBox[{
           TagBox[
            StyleBox["\<\"v\"\>",
             FontSlant->"Italic"],
            StyleForm[#, FontSlant -> "Italic"]& ], "=", "2"}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.8771382497116493, 0.34077056203433764`}, {0, 1}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["\<\"SO(3)\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times New Roman",
         FontSize->20,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.8220312908496732, 0.0968446145124718}, {0, 0}, 
       Automatic, {1, 0}]}}}},
  AspectRatio->NCache[
    Rational[7, 6], 1.1666666666666667`],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{432, 504},
  PlotRange->{{-0.0001, 1.0001}, {-0.0001, 1.0001}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.395095614546875*^9, 3.395095635125*^9}, 
   3.39552099134375*^9, 3.39552117603125*^9, 3.395521489640625*^9, 
   3.39688018203125*^9, {3.43024802521875*^9, 3.430248070125*^9}, 
   3.47108971571875*^9, 3.507513560921875*^9, 3.56683768142056*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LevelScheme poster (original)", "Section",
 CellChangeTimes->{{3.430248076984375*^9, 3.43024808565625*^9}, {
  3.430248449140625*^9, 3.430248450140625*^9}, {3.4991676414375*^9, 
  3.499167653609375*^9}}],

Cell[TextData[{
 "This illustrates the use of the ",
 StyleBox["Table",
  FontFamily->"Courier New"],
 " function to automatically generate sets of levels."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RotationalBand", "[", 
    RowBox[{
    "Name_", ",", "BandHead_", ",", "Moment_", ",", "MaxSpin_", ",", 
     "MaxEnergy_", ",", "ShowLab_", ",", "Col_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Energy", "=", 
       RowBox[{
        RowBox[{"Moment", "*", "J", "*", 
         RowBox[{"(", 
          RowBox[{"J", "+", "1"}], ")"}]}], "+", "BandHead"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Energy", "\[LessEqual]", "MaxEnergy"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"LevelE", "[", "Name", "]"}], "[", "J", "]"}], "=", 
          "Energy"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Lev", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"BandMember", "[", "Name", "]"}], "[", "J", "]"}], ",", 
           RowBox[{
            RowBox[{"J", "/", "2"}], "*", "0.03"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"J", "/", "2"}], "+", "1"}], ")"}], "*", "0.03"}], ",", 
           "Energy", ",", 
           RowBox[{"LabL", "\[Rule]", 
            RowBox[{"SuperscriptBox", "[", 
             RowBox[{"J", ",", "\"\<+\>\""}], "]"}]}], ",", 
           RowBox[{"ShowLabL", "\[Rule]", "ShowLab"}], ",", 
           RowBox[{"Color", "\[Rule]", "Col"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"J", ",", "0", ",", "MaxSpin", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Figure", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"Thickness", "\[Rule]", "3"}], ",", 
       RowBox[{"WingTipWidth", "\[Rule]", "50"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"ArrowType", "\[Rule]", "ShapeArrow"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Gray"}], ",", 
       RowBox[{"Width", "\[Rule]", "35"}], ",", 
       RowBox[{"HeadLength", "\[Rule]", "30"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "7.5"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"Lev3", ",", "0", ",", "1", ",", "200", ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"textit", "[", "\"\<LevelScheme\>\"", "]"}], "}"}], "]"}]}],
        ",", 
       RowBox[{"FontSize", "\[Rule]", "70"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeIfDef", "[", 
      RowBox[{"\"\<Streamlined\>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"SetOptions", "[", 
        RowBox[{"Lev", ",", 
         RowBox[{"ShowLabL", "\[Rule]", "False"}], ",", 
         RowBox[{"ShowLabR", "\[Rule]", "False"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SetOptions", "[", 
        RowBox[{"Lab", ",", 
         RowBox[{"ShowText", "\[Rule]", "False"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"Lev2", ",", "0", ",", "1", ",", "100", ",", 
       RowBox[{"WingHeight", "\[Rule]", "30"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"Lev1", ",", "0", ",", "1", ",", "0", ",", 
       RowBox[{"LabR", "\[Rule]", 
        RowBox[{
        "texttt", "[", "\"\<http://wnsl.physics.yale.edu/levelscheme\>\"", 
         "]"}]}], ",", 
       RowBox[{"OffsetR", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1.1"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.15", ",", "150"}], "}"}], ",", 
       RowBox[{"StackText", "[", 
        RowBox[{"Left", ",", "0", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Level scheme drawing package\>\"", ",", 
           "\"\<     for Mathematica\>\""}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FontSize", "\[Rule]", "25"}], ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.15", ",", "200"}], "}"}], ",", "\[IndentingNewLine]", 
       "\"\<M. A. Caprio, Yale University\>\"", ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"Lev3", ",", "0.65", ",", "Lev2", ",", "0.75"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"Lev2", ",", "0.25", ",", "Lev1", ",", "0.35"}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Generate", " ", "levels", " ", "for", " ", "mini"}], "-", 
       "scheme"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"Thickness", "\[Rule]", "1"}], ",", 
       RowBox[{"Margin", "\[Rule]", "0.001"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "5"}]}], "]"}], ",", 
     "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetScale", "[", "0.013", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"SetOrigin", "[", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "20"}], "}"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"MaxSpin", "=", "16"}], ";", "\[IndentingNewLine]", 
      RowBox[{"MaxEnergy", "=", "4800"}], ";", "\[IndentingNewLine]", 
      RowBox[{"RotationalBand", "[", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"N", "[", 
         RowBox[{"100", "/", "6"}], "]"}], ",", "MaxSpin", ",", "MaxEnergy", 
        ",", "True", ",", "Black"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"RotationalBand", "[", 
      RowBox[{"1", ",", "700", ",", 
       RowBox[{"N", "[", 
        RowBox[{"100", "/", "6"}], "]"}], ",", "MaxSpin", ",", "MaxEnergy", 
       ",", "False", ",", "Blue"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"RotationalBand", "[", 
      RowBox[{"2", ",", "1000", ",", 
       RowBox[{"N", "[", 
        RowBox[{"100", "/", "6"}], "]"}], ",", "MaxSpin", ",", "MaxEnergy", 
       ",", "False", ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SeedRandom", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"RotationalBand", "[", 
        RowBox[{"Dummy", ",", 
         RowBox[{"Random", "[", 
          RowBox[{"Real", ",", 
           RowBox[{"{", 
            RowBox[{"1300", ",", "MaxEnergy"}], "}"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"100", "/", "6"}], "]"}], "*", 
          RowBox[{"Random", "[", 
           RowBox[{"Real", ",", 
            RowBox[{"{", 
             RowBox[{"0.8", ",", "1.2"}], "}"}]}], "]"}]}], ",", "MaxSpin", 
         ",", "MaxEnergy", ",", "False", ",", 
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"Random", "[", "]"}], ",", "0.7", ",", "1"}], "]"}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "50", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "50"}], ",", "275"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", "0.8", "*", 
     RowBox[{"{", 
      RowBox[{"11", ",", "8.5"}], "}"}]}]}], ",", 
   RowBox[{"Background", "\[Rule]", "YellowOchre"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.395521143578125*^9, 3.395521552359375*^9, {3.3955216215625*^9, 
   3.39552163634375*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 200.}, {0.9, 200.}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 119.91819852941177`}, {0.17892992424242424`, 
     119.91819852941177`}, {0.19471590909090908`, 100.}, {0.8052840909090909, 
     100.}, {0.8210700757575757, 119.91819852941177`}, {0.9, 
     119.91819852941177`}}]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1, 0.}, {0.9, 0.}}], 
    {GrayLevel[0.5], Opacity[1], 
     PolygonBox[{{0.65, 200.00000000000003`}, {0.6200305695010717, 
      200.00000000000003`}, {0.7061747944910316, 113.85577501004013`}, {
      0.6952612911660443, 111.92523669262954`}, {0.75, 100.}, {
      0.7680179799992928, 124.79549214203348`}, {0.7571044766743055, 
      122.86495382462289`}, {0.6799694304989283, 200.00000000000003`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.65, 200.00000000000003`}, {0.6200305695010717, 
      200.00000000000003`}, {0.7061747944910316, 113.85577501004013`}, {
      0.6952612911660443, 111.92523669262954`}, {0.75, 100.}, {
      0.7680179799992928, 124.79549214203348`}, {0.7571044766743055, 
      122.86495382462289`}, {0.6799694304989283, 200.00000000000003`}, {0.65, 
      200.00000000000003`}}], 
     {GrayLevel[0.5], Opacity[1], 
      PolygonBox[{{0.25000000000000006`, 100.}, {0.22003056950107175`, 
       100.}, {0.3061747944910316, 13.855775010040126`}, {0.2952612911660444, 
       11.925236692629525`}, {0.35000000000000003`, 7.105427357601002*^-15}, {
       0.3680179799992927, 24.79549214203348}, {0.3571044766743055, 
       22.864953824622887`}, {0.27996943049892836`, 100.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.25000000000000006`, 100.}, {0.22003056950107175`, 
       100.}, {0.3061747944910316, 13.855775010040126`}, {0.2952612911660444, 
       11.925236692629525`}, {0.35000000000000003`, 7.105427357601002*^-15}, {
       0.3680179799992927, 24.79549214203348}, {0.3571044766743055, 
       22.864953824622887`}, {0.27996943049892836`, 100.}, {
       0.25000000000000006`, 100.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.501, 20.}, {0.529, 20.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.531, 21.3}, {0.5589999999999999, 21.3}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.5609999999999999, 24.333333333333336`}, {0.589, 
       24.333333333333336`}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.591, 29.1}, {0.619, 29.1}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.621, 35.6}, {0.649, 35.6}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.651, 43.833333333333336`}, {0.679, 
       43.833333333333336`}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.681, 53.8}, {0.709, 53.8}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.711, 65.5}, {0.739, 65.5}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.741, 78.93333333333334}, {0.769, 
       78.93333333333334}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.501, 29.1}, {0.529, 29.1}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.531, 30.4}, {0.5589999999999999, 30.4}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.5609999999999999, 33.43333333333334}, {0.589, 
       33.43333333333334}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.591, 38.2}, {0.619, 38.2}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.621, 44.7}, {0.649, 44.7}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.651, 52.93333333333334}, {0.679, 52.93333333333334}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.681, 62.9}, {0.709, 62.9}}]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.711, 74.6}, {0.739, 74.6}}]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.501, 33.}, {0.529, 33.}}]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.531, 34.3}, {0.5589999999999999, 34.3}}]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.5609999999999999, 37.333333333333336`}, {0.589, 
       37.333333333333336`}}]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.591, 42.099999999999994`}, {0.619, 42.099999999999994`}}]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.621, 48.599999999999994`}, {0.649, 48.599999999999994`}}]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      LineBox[{{0.651, 56.833333333333336`}, {0.679, 56.833333333333336`}}]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.681, 66.8}, {0.709, 66.8}}]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], LineBox[{{0.711, 78.5}, {0.739, 78.5}}]}, 
     {Hue[0.7243025153516004, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 38.349340482777706`}, {0.529, 38.349340482777706`}}]}, 
     {Hue[0.7243025153516004, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 39.722248750371136`}, {0.5589999999999999, 
       39.722248750371136`}}]}, 
     {Hue[0.7243025153516004, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 42.9257013747558}, {0.589, 
       42.9257013747558}}]}, 
     {Hue[0.7243025153516004, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 47.95969835593172}, {0.619, 47.95969835593172}}]}, 
     {Hue[0.7243025153516004, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 54.82423969389887}, {0.649, 54.82423969389887}}]}, 
     {Hue[0.7243025153516004, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 63.519325388657265`}, {0.679, 63.519325388657265`}}]}, 
     {Hue[0.7243025153516004, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 74.0449554402069}, {0.709, 74.0449554402069}}]}, 
     {Hue[0.6367341366765064, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 63.33022998810457}, {0.529, 63.33022998810457}}]}, 
     {Hue[0.6367341366765064, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 64.85442874648962}, {0.5589999999999999, 
       64.85442874648962}}]}, 
     {Hue[0.6367341366765064, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 68.41089251605476}, {0.589, 
       68.41089251605476}}]}, 
     {Hue[0.6367341366765064, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 73.99962129679996}, {0.619, 73.99962129679996}}]}, 
     {Hue[0.6367341366765064, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 81.62061508872523}, {0.649, 81.62061508872523}}]}, 
     {Hue[0.7023036666567358, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 79.14332314759224}, {0.529, 79.14332314759224}}]}, 
     {Hue[0.7023036666567358, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 80.20877185372271}, {0.5589999999999999, 
       80.20877185372271}}]}, 
     {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 56.24815027823352}, {0.529, 56.24815027823352}}]}, 
     {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 57.64882787958702}, {0.5589999999999999, 
       57.64882787958702}}]}, 
     {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 60.91707561607851}, {0.589, 
       60.91707561607851}}]}, 
     {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 66.05289348770802}, {0.619, 66.05289348770802}}]}, 
     {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 73.05628149447553}, {0.649, 73.05628149447553}}]}, 
     {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 81.92723963638102}, {0.679, 81.92723963638102}}]}, 
     {Hue[0.3128677452178393, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 70.64981048030887}, {0.529, 70.64981048030887}}]}, 
     {Hue[0.3128677452178393, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 72.10764646965019}, {0.5589999999999999, 
       72.10764646965019}}]}, 
     {Hue[0.3128677452178393, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 75.50926377811331}, {0.589, 
       75.50926377811331}}]}, 
     {Hue[0.3128677452178393, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 80.85466240569819}, {0.619, 80.85466240569819}}]}, 
     {Hue[0.9696329414334267, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 81.19697358639304}, {0.529, 81.19697358639304}}]}, 
     {Hue[0.6774990123895557, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 73.07537323110722}, {0.529, 73.07537323110722}}]}, 
     {Hue[0.6774990123895557, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 74.60136749121867}, {0.5589999999999999, 
       74.60136749121867}}]}, 
     {Hue[0.6774990123895557, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 78.16202076481207}, {0.589, 
       78.16202076481207}}]}, 
     {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 62.00447027805959}, {0.529, 62.00447027805959}}]}, 
     {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 63.057761857631206`}, {0.5589999999999999, 
       63.057761857631206`}}]}, 
     {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 65.51544220996497}, {0.589, 
       65.51544220996497}}]}, 
     {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 69.37751133506089}, {0.619, 69.37751133506089}}]}, 
     {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 74.64396923291895}, {0.649, 74.64396923291895}}]}, 
     {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 81.31481590353914}, {0.679, 81.31481590353914}}]}, 
     {Hue[0.3012582145938071, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 66.27686458094706}, {0.529, 66.27686458094706}}]}, 
     {Hue[0.3012582145938071, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 67.79086454510289}, {0.5589999999999999, 
       67.79086454510289}}]}, 
     {Hue[0.3012582145938071, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 71.32353112813314}, {0.589, 
       71.32353112813314}}]}, 
     {Hue[0.3012582145938071, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 76.87486433003782}, {0.619, 76.87486433003782}}]}, 
     {Hue[0.2748042559308436, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 47.18576726233493}, {0.529, 47.18576726233493}}]}, 
     {Hue[0.2748042559308436, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 48.597304099160695`}, {0.5589999999999999, 
       48.597304099160695`}}]}, 
     {Hue[0.2748042559308436, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 51.890890051754155`}, {0.589, 
       51.890890051754155`}}]}, 
     {Hue[0.2748042559308436, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 57.06652512011531}, {0.619, 57.06652512011531}}]}, 
     {Hue[0.2748042559308436, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 64.12420930424415}, {0.649, 64.12420930424415}}]}, 
     {Hue[0.2748042559308436, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 73.06394260414069}, {0.679, 73.06394260414069}}]}, 
     {Hue[0.012190250315896208`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 53.863925616425995`}, {0.529, 53.863925616425995`}}]}, 
     {Hue[0.012190250315896208`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 54.99602853615078}, {0.5589999999999999, 
       54.99602853615078}}]}, 
     {Hue[0.012190250315896208`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 57.63760201550862}, {0.589, 
       57.63760201550862}}]}, 
     {Hue[0.012190250315896208`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 61.78864605449951}, {0.619, 61.78864605449951}}]}, 
     {Hue[0.012190250315896208`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 67.44916065312344}, {0.649, 67.44916065312344}}]}, 
     {Hue[0.012190250315896208`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 74.61914581138043}, {0.679, 74.61914581138043}}]}, 
     {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 75.55544336661987}, {0.529, 75.55544336661987}}]}, 
     {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 76.94863920088267}, {0.5589999999999999, 
       76.94863920088267}}]}, 
     {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 80.1994294808292}, {0.589, 
       80.1994294808292}}]}, 
     {Hue[0.3663550129798464, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 49.20484590906442}, {0.529, 49.20484590906442}}]}, 
     {Hue[0.3663550129798464, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 50.268786415341594`}, {0.5589999999999999, 
       50.268786415341594`}}]}, 
     {Hue[0.3663550129798464, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 52.75131426332168}, {0.589, 
       52.75131426332168}}]}, 
     {Hue[0.3663550129798464, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 56.65242945300468}, {0.619, 56.65242945300468}}]}, 
     {Hue[0.3663550129798464, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 61.97213198439059}, {0.649, 61.97213198439059}}]}, 
     {Hue[0.3663550129798464, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 68.7104218574794}, {0.679, 68.7104218574794}}]}, 
     {Hue[0.3663550129798464, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 76.86729907227112}, {0.709, 76.86729907227112}}]}, 
     {Hue[0.0764064937149989, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 45.31047305233403}, {0.529, 45.31047305233403}}]}, 
     {Hue[0.0764064937149989, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 46.50900651372574}, {0.5589999999999999, 
       46.50900651372574}}]}, 
     {Hue[0.0764064937149989, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 49.30558459030637}, {0.589, 
       49.30558459030637}}]}, 
     {Hue[0.0764064937149989, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 53.700207282075915`}, {0.619, 53.700207282075915`}}]}, 
     {Hue[0.0764064937149989, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 59.692874589034396`}, {0.649, 59.692874589034396`}}]}, 
     {Hue[0.0764064937149989, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 67.28358651118181}, {0.679, 67.28358651118181}}]}, 
     {Hue[0.0764064937149989, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 76.47234304851816}, {0.709, 76.47234304851816}}]}, 
     {Hue[0.6273730287483228, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 62.893779859475785`}, {0.529, 62.893779859475785`}}]}, 
     {Hue[0.6273730287483228, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 64.063905291391}, {0.5589999999999999, 
       64.063905291391}}]}, 
     {Hue[0.6273730287483228, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 66.79419796585984}, {0.589, 
       66.79419796585984}}]}, 
     {Hue[0.6273730287483228, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 71.08465788288228}, {0.619, 71.08465788288228}}]}, 
     {Hue[0.6273730287483228, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 76.93528504245836}, {0.649, 76.93528504245836}}]}, 
     {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 60.77202518597285}, {0.529, 60.77202518597285}}]}, 
     {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 62.09580537622382}, {0.5589999999999999, 
       62.09580537622382}}]}, 
     {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 65.18462582014274}, {0.589, 
       65.18462582014274}}]}, 
     {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 70.03848651772964}, {0.619, 70.03848651772964}}]}, 
     {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 76.65738746898447}, {0.649, 76.65738746898447}}]}, 
     {Hue[0.24447292050420938`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 81.5686082271016}, {0.529, 81.5686082271016}}]}, 
     {Hue[0.33831724565901194`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 46.784210779806855`}, {0.529, 46.784210779806855`}}]}, 
     {Hue[0.33831724565901194`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 47.96317232271939}, {0.5589999999999999, 
       47.96317232271939}}]}, 
     {Hue[0.33831724565901194`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 50.714082589515314`}, {0.589, 
       50.714082589515314`}}]}, 
     {Hue[0.33831724565901194`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 55.03694158019461}, {0.619, 55.03694158019461}}]}, 
     {Hue[0.33831724565901194`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 60.93174929475728}, {0.649, 60.93174929475728}}]}, 
     {Hue[0.33831724565901194`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 68.39850573320334}, {0.679, 68.39850573320334}}]}, 
     {Hue[0.33831724565901194`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 77.43721089553279}, {0.709, 77.43721089553279}}]}, 
     {Hue[0.2550434860543644, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 76.55959226651552}, {0.529, 76.55959226651552}}]}, 
     {Hue[0.2550434860543644, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 77.62045175570282}, {0.5589999999999999, 
       77.62045175570282}}]}, 
     {Hue[0.2550434860543644, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 80.0957905638065}, {0.589, 
       80.0957905638065}}]}, 
     {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 59.13799131086517}, {0.529, 59.13799131086517}}]}, 
     {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 60.27804795964827}, {0.5589999999999999, 
       60.27804795964827}}]}, 
     {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 62.93818014014216}, {0.589, 
       62.93818014014216}}]}, 
     {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 67.11838785234684}, {0.619, 67.11838785234684}}]}, 
     {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 72.8186710962623}, {0.649, 72.8186710962623}}]}, 
     {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 80.03902987188857}, {0.679, 80.03902987188857}}]}, 
     {Hue[0.8260616192953368, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 81.69963270640916}, {0.529, 81.69963270640916}}]}, 
     {Hue[0.36630113291383215`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 68.60728561282686}, {0.529, 68.60728561282686}}]}, 
     {Hue[0.36630113291383215`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 70.00074795379413}, {0.5589999999999999, 
       70.00074795379413}}]}, 
     {Hue[0.36630113291383215`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 73.25216008271775}, {0.589, 
       73.25216008271775}}]}, 
     {Hue[0.36630113291383215`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 78.36152199959773}, {0.619, 78.36152199959773}}]}, 
     {Hue[0.05236224234257158, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 48.49202381846203}, {0.529, 48.49202381846203}}]}, 
     {Hue[0.05236224234257158, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 49.76426736497912}, {0.5589999999999999, 
       49.76426736497912}}]}, 
     {Hue[0.05236224234257158, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 52.73283564018568}, {0.589, 
       52.73283564018568}}]}, 
     {Hue[0.05236224234257158, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 57.397728644081674`}, {0.619, 57.397728644081674`}}]}, 
     {Hue[0.05236224234257158, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 63.75894637666713}, {0.649, 63.75894637666713}}]}, 
     {Hue[0.05236224234257158, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 71.81648883794205}, {0.679, 71.81648883794205}}]}, 
     {Hue[0.05236224234257158, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 81.57035602790643}, {0.709, 81.57035602790643}}]}, 
     {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 75.1946763616065}, {0.529, 75.1946763616065}}]}, 
     {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 76.60337644356653}, {0.5589999999999999, 
       76.60337644356653}}]}, 
     {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 79.89034330147325}, {0.589, 
       79.89034330147325}}]}, 
     {Hue[0.464565698649687, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 40.11387379948539}, {0.529, 40.11387379948539}}]}, 
     {Hue[0.464565698649687, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 41.27270406279131}, {0.5589999999999999, 
       41.27270406279131}}]}, 
     {Hue[0.464565698649687, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 43.97664134383846}, {0.589, 
       43.97664134383846}}]}, 
     {Hue[0.464565698649687, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 48.225685642626836`}, {0.619, 48.225685642626836`}}]}, 
     {Hue[0.464565698649687, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 54.01983695915644}, {0.649, 54.01983695915644}}]}, 
     {Hue[0.464565698649687, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 61.35909529342727}, {0.679, 61.35909529342727}}]}, 
     {Hue[0.464565698649687, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 70.24346064543934}, {0.709, 70.24346064543934}}]}, 
     {Hue[0.464565698649687, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.711, 80.67293301519263}, {0.739, 80.67293301519263}}]}, 
     {Hue[0.890202491467759, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 72.66712149829692}, {0.529, 72.66712149829692}}]}, 
     {Hue[0.890202491467759, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 74.12488994166421}, {0.5589999999999999, 
       74.12488994166421}}]}, 
     {Hue[0.890202491467759, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 77.52634964285458}, {0.589, 
       77.52634964285458}}]}, 
     {Hue[0.548357366575054, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 63.87814702204522}, {0.529, 63.87814702204522}}]}, 
     {Hue[0.548357366575054, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 65.3060546356956}, {0.5589999999999999, 
       65.3060546356956}}]}, 
     {Hue[0.548357366575054, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 68.63783906754651}, {0.589, 
       68.63783906754651}}]}, 
     {Hue[0.548357366575054, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 73.87350031759793}, {0.619, 73.87350031759793}}]}, 
     {Hue[0.548357366575054, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 81.01303838584988}, {0.649, 81.01303838584988}}]}, 
     {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 55.16622205091786}, {0.529, 55.16622205091786}}]}, 
     {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 56.414487082386714`}, {0.5589999999999999, 
       56.414487082386714`}}]}, 
     {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 59.32710548914736}, {0.589, 
       59.32710548914736}}]}, 
     {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 63.90407727119981}, {0.619, 63.90407727119981}}]}, 
     {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 70.14540242854406}, {0.649, 70.14540242854406}}]}, 
     {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 78.05108096118012}, {0.679, 78.05108096118012}}]}, 
     {Hue[0.5744480566062979, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 62.550627472755785`}, {0.529, 62.550627472755785`}}]}, 
     {Hue[0.5744480566062979, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 64.08917633034784}, {0.5589999999999999, 
       64.08917633034784}}]}, 
     {Hue[0.5744480566062979, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 67.67912366472935}, {0.589, 
       67.67912366472935}}]}, 
     {Hue[0.5744480566062979, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 73.32046947590027}, {0.619, 73.32046947590027}}]}, 
     {Hue[0.5744480566062979, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 81.0132137638606}, {0.649, 81.0132137638606}}]}, 
     {Hue[0.5924466701478391, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 44.51687191642117}, {0.529, 44.51687191642117}}]}, 
     {Hue[0.5924466701478391, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 46.01655960371397}, {0.5589999999999999, 
       46.01655960371397}}]}, 
     {Hue[0.5924466701478391, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 49.51583087406384}, {0.589, 
       49.51583087406384}}]}, 
     {Hue[0.5924466701478391, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 55.01468572747078}, {0.619, 55.01468572747078}}]}, 
     {Hue[0.5924466701478391, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 62.51312416393478}, {0.649, 62.51312416393478}}]}, 
     {Hue[0.5924466701478391, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 72.01114618345585}, {0.679, 72.01114618345585}}]}, 
     {Hue[0.8316525409128149, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 51.44536275712452}, {0.529, 51.44536275712452}}]}, 
     {Hue[0.8316525409128149, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 52.86016917536653}, {0.5589999999999999, 
       52.86016917536653}}]}, 
     {Hue[0.8316525409128149, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 56.16138415126454}, {0.589, 
       56.16138415126454}}]}, 
     {Hue[0.8316525409128149, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 61.349007684818574`}, {0.619, 61.349007684818574`}}]}, 
     {Hue[0.8316525409128149, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 68.4230397760286}, {0.649, 68.4230397760286}}]}, 
     {Hue[0.8316525409128149, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 77.38348042489464}, {0.679, 77.38348042489464}}]}, 
     {Hue[0.7174555894081717, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 71.06164713012018}, {0.529, 71.06164713012018}}]}, 
     {Hue[0.7174555894081717, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 72.41917976538443}, {0.5589999999999999, 
       72.41917976538443}}]}, 
     {Hue[0.7174555894081717, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 75.58675591433435}, {0.589, 
       75.58675591433435}}]}, 
     {Hue[0.7174555894081717, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 80.56437557696995}, {0.619, 80.56437557696995}}]}, 
     {Hue[0.14607398455080184`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 71.5263168120477}, {0.529, 71.5263168120477}}]}, 
     {Hue[0.14607398455080184`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 72.83790537308599}, {0.5589999999999999, 
       72.83790537308599}}]}, 
     {Hue[0.14607398455080184`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 75.89827868217539}, {0.589, 
       75.89827868217539}}]}, 
     {Hue[0.14607398455080184`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 80.70743673931585}, {0.619, 80.70743673931585}}]}, 
     {Hue[0.6320832028366825, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 79.27710781977488}, {0.529, 79.27710781977488}}]}, 
     {Hue[0.6320832028366825, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 80.81506871140242}, {0.5589999999999999, 
       80.81506871140242}}]}, 
     {Hue[0.4092597327086638, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 62.068219275016254`}, {0.529, 62.068219275016254`}}]}, 
     {Hue[0.4092597327086638, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 63.20462146502044}, {0.5589999999999999, 
       63.20462146502044}}]}, 
     {Hue[0.4092597327086638, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 65.85622657503019}, {0.589, 
       65.85622657503019}}]}, 
     {Hue[0.4092597327086638, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 70.02303460504554}, {0.619, 70.02303460504554}}]}, 
     {Hue[0.4092597327086638, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 75.70504555506645}, {0.649, 75.70504555506645}}]}, 
     {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 47.393563678151196`}, {0.529, 47.393563678151196`}}]}, 
     {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 48.512935438396816`}, {0.5589999999999999, 
       48.512935438396816`}}]}, 
     {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 51.12480287896993}, {0.589, 
       51.12480287896993}}]}, 
     {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 55.229165999870546`}, {0.619, 55.229165999870546`}}]}, 
     {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 60.826024801098654`}, {0.649, 60.826024801098654`}}]}, 
     {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 67.91537928265426}, {0.679, 67.91537928265426}}]}, 
     {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 76.49722944453734}, {0.709, 76.49722944453734}}]}, 
     {Hue[0.578189943866051, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 75.37069036548841}, {0.529, 75.37069036548841}}]}, 
     {Hue[0.578189943866051, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 76.55206794993236}, {0.5589999999999999, 
       76.55206794993236}}]}, 
     {Hue[0.578189943866051, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 79.30861564696824}, {0.589, 
       79.30861564696824}}]}, 
     {Hue[0.6794332999366697, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 43.89416217969675}, {0.529, 43.89416217969675}}]}, 
     {Hue[0.6794332999366697, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 45.43413952515239}, {0.5589999999999999, 
       45.43413952515239}}]}, 
     {Hue[0.6794332999366697, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 49.02741999788222}, {0.589, 
       49.02741999788222}}]}, 
     {Hue[0.6794332999366697, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 54.67400359788622}, {0.619, 54.67400359788622}}]}, 
     {Hue[0.6794332999366697, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 62.37389032516442}, {0.649, 62.37389032516442}}]}, 
     {Hue[0.6794332999366697, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 72.12708017971678}, {0.679, 72.12708017971678}}]}, 
     {Hue[0.12984235419418133`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 48.6622796887808}, {0.529, 48.6622796887808}}]}, 
     {Hue[0.12984235419418133`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 49.92740655259247}, {0.5589999999999999, 
       49.92740655259247}}]}, 
     {Hue[0.12984235419418133`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 52.8793692348197}, {0.589, 
       52.8793692348197}}]}, 
     {Hue[0.12984235419418133`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 57.51816773546249}, {0.619, 57.51816773546249}}]}, 
     {Hue[0.12984235419418133`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 63.84380205452084}, {0.649, 63.84380205452084}}]}, 
     {Hue[0.12984235419418133`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 71.85627219199475}, {0.679, 71.85627219199475}}]}, 
     {Hue[0.12984235419418133`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 81.55557814788423}, {0.709, 81.55557814788423}}]}, 
     {Hue[0.7154806871527328, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 79.1525680169983}, {0.529, 79.1525680169983}}]}, 
     {Hue[0.7154806871527328, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 80.52946143532012}, {0.5589999999999999, 
       80.52946143532012}}]}, 
     {Hue[0.5017979737603753, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 53.681510303787555`}, {0.529, 53.681510303787555`}}]}, 
     {Hue[0.5017979737603753, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 54.93280823437208}, {0.5589999999999999, 
       54.93280823437208}}]}, 
     {Hue[0.5017979737603753, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 57.85250340573599}, {0.589, 
       57.85250340573599}}]}, 
     {Hue[0.5017979737603753, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 62.440595817879256`}, {0.619, 62.440595817879256`}}]}, 
     {Hue[0.5017979737603753, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 68.6970854708019}, {0.649, 68.6970854708019}}]}, 
     {Hue[0.5017979737603753, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 76.6219723645039}, {0.679, 76.6219723645039}}]}, 
     {Hue[0.774258971364333, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 72.57726344567445}, {0.529, 72.57726344567445}}]}, 
     {Hue[0.774258971364333, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 73.83109124323306}, {0.5589999999999999, 
       73.83109124323306}}]}, 
     {Hue[0.774258971364333, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 76.7566894375365}, {0.589, 
       76.7566894375365}}]}, 
     {Hue[0.774258971364333, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 81.35405802858473}, {0.619, 81.35405802858473}}]}, 
     {Hue[0.0019475702886637936`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 80.0635885310808}, {0.529, 80.0635885310808}}]}, 
     {Hue[0.0019475702886637936`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 81.41492649474148}, {0.5589999999999999, 
       81.41492649474148}}]}, 
     {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 61.63521951892595}, {0.529, 61.63521951892595}}]}, 
     {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 63.08914591332126}, {0.5589999999999999, 
       63.08914591332126}}]}, 
     {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 66.48164083357696}, {0.589, 
       66.48164083357696}}]}, 
     {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 71.81270427969307}, {0.619, 71.81270427969307}}]}, 
     {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 79.08233625166957}, {0.649, 79.08233625166957}}]}, 
     {Hue[0.2178223530479914, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 44.01792408264578}, {0.529, 44.01792408264578}}]}, 
     {Hue[0.2178223530479914, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 45.199234721275275`}, {0.5589999999999999, 
       45.199234721275275`}}]}, 
     {Hue[0.2178223530479914, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 47.955626211410774`}, {0.589, 
       47.955626211410774`}}]}, 
     {Hue[0.2178223530479914, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 52.287098553052246`}, {0.619, 52.287098553052246`}}]}, 
     {Hue[0.2178223530479914, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 58.19365174619972}, {0.649, 58.19365174619972}}]}, 
     {Hue[0.2178223530479914, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 65.6752857908532}, {0.679, 65.6752857908532}}]}, 
     {Hue[0.2178223530479914, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 74.73200068701266}, {0.709, 74.73200068701266}}]}, 
     {Hue[0.5923179281969743, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 42.536875544493824`}, {0.529, 42.536875544493824`}}]}, 
     {Hue[0.5923179281969743, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 43.67824590283985}, {0.5589999999999999, 
       43.67824590283985}}]}, 
     {Hue[0.5923179281969743, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 46.341443405647254`}, {0.589, 
       46.341443405647254`}}]}, 
     {Hue[0.5923179281969743, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 50.526468052916016`}, {0.619, 50.526468052916016`}}]}, 
     {Hue[0.5923179281969743, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 56.23331984464616}, {0.649, 56.23331984464616}}]}, 
     {Hue[0.5923179281969743, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 63.461998780837675`}, {0.679, 63.461998780837675`}}]}, 
     {Hue[0.5923179281969743, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 72.21250486149054}, {0.709, 72.21250486149054}}]}, 
     {Hue[0.06510064262510336, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 80.5486373749028}, {0.529, 80.5486373749028}}]}, 
     {Hue[0.06510064262510336, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 81.94793194588536}, {0.5589999999999999, 
       81.94793194588536}}]}, 
     {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 67.09789771596402}, {0.529, 67.09789771596402}}]}, 
     {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 68.2998458676411}, {0.5589999999999999, 
       68.2998458676411}}]}, 
     {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 71.10439155488763}, {0.589, 
       71.10439155488763}}]}, 
     {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 75.51153477770356}, {0.619, 75.51153477770356}}]}, 
     {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 81.52127553608895}, {0.649, 81.52127553608895}}]}, 
     {Hue[0.8096407794647732, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 68.58056893565464}, {0.529, 68.58056893565464}}]}, 
     {Hue[0.8096407794647732, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 69.75438983610971}, {0.5589999999999999, 
       69.75438983610971}}]}, 
     {Hue[0.8096407794647732, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 72.49330527050483}, {0.589, 
       72.49330527050483}}]}, 
     {Hue[0.8096407794647732, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 76.79731523884007}, {0.619, 76.79731523884007}}]}, 
     {Hue[0.4830889141261685, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.501, 45.606640249848866`}, {0.529, 45.606640249848866`}}]}, 
     {Hue[0.4830889141261685, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.531, 46.79487609726917}, {0.5589999999999999, 
       46.79487609726917}}]}, 
     {Hue[0.4830889141261685, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.5609999999999999, 49.567426407916535`}, {0.589, 
       49.567426407916535`}}]}, 
     {Hue[0.4830889141261685, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.591, 53.92429118179096}, {0.619, 53.92429118179096}}]}, 
     {Hue[0.4830889141261685, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.621, 59.865470418892464`}, {0.649, 59.865470418892464`}}]}, 
     {Hue[0.4830889141261685, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.651, 67.39096411922102}, {0.679, 67.39096411922102}}]}, 
     {Hue[0.4830889141261685, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
      Dashing[{}], CapForm[None], 
      LineBox[{{0.681, 76.50077228277667}, {0.709, 76.50077228277667}}], 
      InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          TagBox[
           StyleBox["\<\"LevelScheme\"\>",
            FontSlant->"Italic"],
           StyleForm[#, FontSlant -> "Italic"]& ],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->70,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.1, 200.}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          TagBox[
           StyleBox["\<\"http://wnsl.physics.yale.edu/levelscheme\"\>",
            FontFamily->"Courier"],
           StyleForm[#, FontFamily -> "Courier"]& ],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.9, 0.}, {1, -1.1}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[GridBox[{
            {
             RowBox[{"Level", " ", "scheme", " ", "drawing", " ", "package"}]},
            {
             RowBox[{"     ", 
              RowBox[{"for", " ", "Mathematica"}]}]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->25,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.15, 150.}, {-1, 0}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["\<\"M. A. Caprio, Yale University\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->15,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.15, 200.}, {-1, 1}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["0", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.501, 20.}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["2", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.531, 21.3}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["4", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.5609999999999999, 24.333333333333336`}, {-1, -0.75}, 
       Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["6", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.591, 29.1}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["8", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.621, 35.6}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["10", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.651, 43.833333333333336`}, {-1, -0.75}, Automatic, {
       1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["12", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.681, 53.8}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["14", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.711, 65.5}, {-1, -0.75}, Automatic, {1, 0}], InsetBox[
       TagBox[
        StyleBox[
         TagBox[
          SuperscriptBox["16", "+"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->5,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.741, 78.93333333333334}, {-1, -0.75}, Automatic, {1, 
       0}]}}}},
  AspectRatio->0.7727272727272727,
  Axes->False,
  Background->RGBColor[0.889996, 0.509995, 0.089999],
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{633.6, 489.6},
  PlotRange->{{-0.0001, 1.0001}, {-50.0325, 275.0325}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.3955215544375*^9, 3.3955216419375*^9, 
  3.396880194203125*^9, 3.43024809140625*^9, 3.47108972540625*^9, 
  3.507513566046875*^9, 3.566837682970566*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LevelScheme poster (revised)", "Section",
 CellChangeTimes->{{3.430248076984375*^9, 3.43024808565625*^9}, {
  3.43024833653125*^9, 3.4302483369375*^9}, {3.43024845575*^9, 
  3.430248457*^9}, {3.499167646359375*^9, 3.499167660125*^9}}],

Cell[TextData[{
 "This illustrates the use of the ",
 StyleBox["Table",
  FontFamily->"Courier New"],
 " function to automatically generate sets of levels."
}], "Text"],

Cell[TextData[{
 "Caveat: LevelScheme's data plotting capability (",
 StyleBox["DataPlot",
  FontFamily->"Courier New"],
 "), used in this poster, is still under development.  If you decide to use \
it, be aware that the syntax is subject to change in future versions of \
LevelScheme.  Note that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s usual data plotting functions (",
 StyleBox["ListPlot",
  FontFamily->"Courier New"],
 ", ",
 StyleBox["etc.",
  FontSlant->"Italic"],
 ") can always be used to generate data plots within LevelScheme figures."
}], "Text",
 CellChangeTimes->{{3.4115055216875*^9, 3.411505557703125*^9}, {
  3.4115055933125*^9, 3.41150559809375*^9}, {3.4302483426875*^9, 
  3.430248397859375*^9}, {3.43024847371875*^9, 3.4302486310625*^9}}],

Cell["\<\
Caveat: Since this example uses object transparency (the Opacity option), \
PostScript or EncapsulatedPostscript export may not work well and may even \
crash Mathematica.\
\>", "Text",
 CellChangeTimes->{{3.4912584364375*^9, 3.491258489*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"WData", "=", 
   RowBox[{"Replace", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"180", ",", "2095"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "45", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"175", ",", "2124"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "45", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"170", ",", "2030"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "44", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"165", ",", "1691"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "40", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"160", ",", "1444"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "37", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"155", ",", "1195"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "34", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"150", ",", "1024"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "31", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"145", ",", "917"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "30", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"140", ",", "911"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "30", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"135", ",", "959"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "30", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"130", ",", "1025"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "31", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"125", ",", "982"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "31", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"120", ",", "1037"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "32", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"115", ",", "952"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "30", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"110", ",", "828"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "28", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"105", ",", "711"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "26", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"100", ",", "576"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "24", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"95", ",", "439"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "21", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"90", ",", "398"}], "}"}], ",", 
         RowBox[{"ErrorBar", "[", "20", "]"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"theta_", ",", "value_"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "err_", "]"}]}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"180", "-", "theta"}], ",", 
        RowBox[{"ErrorValue", "[", 
         RowBox[{
          RowBox[{"value", "/", "898.1"}], ",", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"value", "/", "898.1"}], "]"}], "*", "0.15"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"{", "1", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\n", 
 RowBox[{"Figure", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"Thickness", "\[Rule]", "3"}], ",", 
       RowBox[{"WingTipWidth", "\[Rule]", "50"}], ",", 
       RowBox[{"Margin", "\[Rule]", "0"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"Lev3", ",", "0", ",", "1", ",", "200"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"Lev2", ",", "0", ",", "1", ",", "100", ",", 
       RowBox[{"WingHeight", "\[Rule]", "30"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Lev", "[", 
      RowBox[{"Lev1", ",", "0", ",", "1", ",", "0"}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.05", ",", "185"}], "}"}], ",", "\"\<LevelScheme\>\"", ",", 
       RowBox[{"FontSize", "\[Rule]", "45"}], ",", 
       RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"+", "1"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.05", ",", "155"}], "}"}], ",", 
       RowBox[{"StackText", "[", 
        RowBox[{"Left", ",", "0.2", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
          "\"\<  A scientific figure preparation\>\"", ",", 
           "\[IndentingNewLine]", "\"\<    system for Mathematica\>\""}], 
          "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "26"}], ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"+", "1"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<M. A. Caprio, Comput. Phys. Commun. \>\"", ",", 
          RowBox[{"textbf", "[", "\"\<171\>\"", "]"}], ",", 
          "\"\<, 107 (2005)\>\""}], "}"}], "]"}], ",", 
       RowBox[{"Offset", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1.1"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{
       "texttt", "[", "\"\<http://wnsl.physics.yale.edu/levelscheme\>\"", 
        "]"}], ",", 
       RowBox[{"Offset", "->", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1.1"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"ArrowType", "\[Rule]", "ShapeArrow"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Gray"}], ",", 
       RowBox[{"Width", "\[Rule]", "55"}], ",", 
       RowBox[{"HeadLength", "\[Rule]", "30"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "7.5"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Trans", "[", 
      RowBox[{"Lev3", ",", "0.65", ",", "Lev2", ",", "0.80"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Trans", "[", 
        RowBox[{"Lev2", ",", "0.25", ",", "Lev1", ",", "0.35"}], "]"}], ","}],
       "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"0", "+", "5"}], ",", 
           RowBox[{"200", "-", "5"}]}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"3", ",", "6"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"LineColor", "\[Rule]", "Beige"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ShowPanelLetter", "\[Rule]", "False"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XGapSizes", "\[Rule]", "0.03"}], ",", "\[IndentingNewLine]", 
       RowBox[{"YGapSizes", "\[Rule]", "0.03"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ShowTickLabelsExterior", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"False", ",", "False", ",", "False", ",", "False"}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Layer", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FigurePanel", "[", 
        RowBox[{"{", 
         RowBox[{"i", ",", "j"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "6"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"FigurePanel", ",", 
       RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.46", ",", "0.96"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "100"}], "}"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", 
            RowBox[{"90", "+", "5"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataLine", ",", 
       RowBox[{"LineShape", "->", "\"\<Step\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataSymbol", ",", 
       RowBox[{"FillColor", "->", "LightSlateGray"}], ",", 
       RowBox[{"Color", "\[Rule]", "Red"}], ",", 
       RowBox[{"SymbolSize", "\[Rule]", "6"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DataPlot", "[", "WData", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"FigurePanel", ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
       RowBox[{"Color", "\[Rule]", "Beige"}], ",", 
       RowBox[{"Opacity", "\[Rule]", "0.4"}], ",", 
       RowBox[{"Background", "\[Rule]", "White"}], ",", 
       RowBox[{"BackgroundOpacity", "\[Rule]", "0.15"}], ",", 
       RowBox[{"ExtendRange", "\[Rule]", "0.05"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.05", ",", "0.45"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"15", ",", "90"}], "}"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "9"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"5000", "-", "100"}]}], "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Lev", ",", 
       RowBox[{"Thickness", "\[Rule]", "1"}], ",", 
       RowBox[{"Margin", "\[Rule]", "0.05"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "7"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"DrawBand", "[", 
        RowBox[{
        "Name_", ",", "BandHead_", ",", "Moment_", ",", "MaxSpin_", ",", 
         "MaxEnergy_", ",", "ShowLab_", ",", "Col_"}], "]"}], ":=", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Energy", "=", 
           RowBox[{
            RowBox[{"Moment", "*", "J", "*", 
             RowBox[{"(", 
              RowBox[{"J", "+", "1"}], ")"}]}], "+", "BandHead"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Energy", "\[LessEqual]", "MaxEnergy"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"LevelE", "[", "Name", "]"}], "[", "J", "]"}], "=", 
              "Energy"}], ";", "\[IndentingNewLine]", 
             RowBox[{"Lev", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"BandMember", "[", "Name", "]"}], "[", "J", "]"}], 
               ",", 
               RowBox[{"J", "/", "2"}], ",", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"J", "/", "2"}], "+", "1"}], ")"}], ",", "Energy", 
               ",", 
               RowBox[{"LabL", "\[Rule]", 
                RowBox[{"SuperscriptBox", "[", 
                 RowBox[{"J", ",", "\"\<+\>\""}], "]"}]}], ",", 
               RowBox[{"ShowLabL", "\[Rule]", "ShowLab"}], ",", 
               RowBox[{"Color", "\[Rule]", "Col"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"J", ",", "0", ",", "MaxSpin", ",", "2"}], "}"}]}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"MaxSpin", "=", "16"}], ";", "\[IndentingNewLine]", 
      RowBox[{"MaxEnergy", "=", "4800"}], ";", "\[IndentingNewLine]", 
      RowBox[{"DrawBand", "[", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"N", "[", 
         RowBox[{"100", "/", "6"}], "]"}], ",", "MaxSpin", ",", "MaxEnergy", 
        ",", 
        RowBox[{"True", ";", "False"}], ",", "Black"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DrawBand", "[", 
      RowBox[{"1", ",", "700", ",", 
       RowBox[{"N", "[", 
        RowBox[{"100", "/", "6"}], "]"}], ",", "MaxSpin", ",", "MaxEnergy", 
       ",", "False", ",", "Blue"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"DrawBand", "[", 
      RowBox[{"2", ",", "1000", ",", 
       RowBox[{"N", "[", 
        RowBox[{"100", "/", "6"}], "]"}], ",", "MaxSpin", ",", "MaxEnergy", 
       ",", "False", ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"Trans", ",", 
       RowBox[{"ArrowType", "\[Rule]", "SquiggleArrow"}], ",", 
       RowBox[{"Color", "\[Rule]", "Red"}], ",", 
       RowBox[{"HeadLength", "\[Rule]", "4"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "3"}], ",", 
       RowBox[{"Width", "\[Rule]", "3"}], ",", 
       RowBox[{"SquiggleWavelength", "\[Rule]", "8"}], ",", 
       RowBox[{"SquiggleBuffer", "\[Rule]", "2"}], ",", 
       RowBox[{"SquiggleSide", "\[Rule]", "Right"}], ",", 
       RowBox[{"EndPositions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.37", ",", "0.63"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Trans", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"BandMember", "[", "1", "]"}], "[", "0", "]"}], ",", 
         RowBox[{
          RowBox[{"BandMember", "[", "0", "]"}], "[", "0", "]"}]}], "]"}], 
       ","}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Trans", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"BandMember", "[", "0", "]"}], "[", "J", "]"}], ",", 
         RowBox[{
          RowBox[{"BandMember", "[", "0", "]"}], "[", 
          RowBox[{"J", "-", "2"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"J", ",", "2", ",", "MaxSpin", ",", "2"}], "}"}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SeedRandom", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DrawBand", "[", 
        RowBox[{"Dummy", ",", 
         RowBox[{"Random", "[", 
          RowBox[{"Real", ",", 
           RowBox[{"{", 
            RowBox[{"1300", ",", "MaxEnergy"}], "}"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"100", "/", "6"}], "]"}], "*", 
          RowBox[{"Random", "[", 
           RowBox[{"Real", ",", 
            RowBox[{"{", 
             RowBox[{"0.8", ",", "1.2"}], "}"}]}], "]"}]}], ",", "MaxSpin", 
         ",", "MaxEnergy", ",", "False", ",", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"Random", "[", "]"}], "]"}], ";", 
          RowBox[{"Hue", "[", 
           RowBox[{
            RowBox[{"Random", "[", "]"}], ",", "0.7", ",", "1"}], "]"}]}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "50", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.05"}], ",", "1.05"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "15"}], ",", 
        RowBox[{"200", "+", "15"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", "0.8", "*", 
     RowBox[{"{", 
      RowBox[{"11", ",", "8.5"}], "}"}]}]}], ",", 
   RowBox[{"Background", "\[Rule]", "LightSlateGray"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.430248227*^9, 3.430248227265625*^9}, 3.430248432*^9, {
   3.488839221390625*^9, 3.488839247734375*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 132.90849673202615`}, {0.16260162601626016`, 
     132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 135.54725967320263`}, {0., 132.90849673202615`}}], 
    LineBox[{{0.005000000000000001, 134.2278782026144}, {0.005000000000000001,
      132.90849673202615`}}], 
    LineBox[{{0.010000000000000002`, 134.2278782026144}, {
     0.010000000000000002`, 132.90849673202615`}}], 
    LineBox[{{0.015000000000000003`, 134.2278782026144}, {
     0.015000000000000003`, 132.90849673202615`}}], 
    LineBox[{{0.020000000000000004`, 134.2278782026144}, {
     0.020000000000000004`, 132.90849673202615`}}], 
    LineBox[{{0.025, 135.54725967320263`}, {0.025, 132.90849673202615`}}], 
    LineBox[{{0.030000000000000002`, 134.2278782026144}, {
     0.030000000000000002`, 132.90849673202615`}}], 
    LineBox[{{0.035, 134.2278782026144}, {0.035, 132.90849673202615`}}], 
    LineBox[{{0.04000000000000001, 134.2278782026144}, {0.04000000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.045000000000000005`, 134.2278782026144}, {
     0.045000000000000005`, 132.90849673202615`}}], 
    LineBox[{{0.05, 135.54725967320263`}, {0.05, 132.90849673202615`}}], 
    LineBox[{{0.05500000000000001, 134.2278782026144}, {0.05500000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.060000000000000005`, 134.2278782026144}, {
     0.060000000000000005`, 132.90849673202615`}}], 
    LineBox[{{0.065, 134.2278782026144}, {0.065, 132.90849673202615`}}], 
    LineBox[{{0.07, 134.2278782026144}, {0.07, 132.90849673202615`}}], 
    LineBox[{{0.07500000000000001, 135.54725967320263`}, {0.07500000000000001,
      132.90849673202615`}}], 
    LineBox[{{0.08000000000000002, 134.2278782026144}, {0.08000000000000002, 
     132.90849673202615`}}], 
    LineBox[{{0.08500000000000002, 134.2278782026144}, {0.08500000000000002, 
     132.90849673202615`}}], 
    LineBox[{{0.09000000000000001, 134.2278782026144}, {0.09000000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.09500000000000001, 134.2278782026144}, {0.09500000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.1, 135.54725967320263`}, {0.1, 132.90849673202615`}}], 
    LineBox[{{0.10500000000000001`, 134.2278782026144}, {0.10500000000000001`,
      132.90849673202615`}}], 
    LineBox[{{0.11000000000000001`, 134.2278782026144}, {0.11000000000000001`,
      132.90849673202615`}}], 
    LineBox[{{0.115, 134.2278782026144}, {0.115, 132.90849673202615`}}], 
    LineBox[{{0.12000000000000001`, 134.2278782026144}, {0.12000000000000001`,
      132.90849673202615`}}], 
    LineBox[{{0.125, 135.54725967320263`}, {0.125, 132.90849673202615`}}], 
    LineBox[{{0.13, 134.2278782026144}, {0.13, 132.90849673202615`}}], 
    LineBox[{{0.135, 134.2278782026144}, {0.135, 132.90849673202615`}}], 
    LineBox[{{0.14, 134.2278782026144}, {0.14, 132.90849673202615`}}], 
    LineBox[{{0.14500000000000002`, 134.2278782026144}, {0.14500000000000002`,
      132.90849673202615`}}], 
    LineBox[{{0.15000000000000002`, 135.54725967320263`}, {
     0.15000000000000002`, 132.90849673202615`}}], 
    LineBox[{{0.15500000000000003`, 134.2278782026144}, {0.15500000000000003`,
      132.90849673202615`}}], 
    LineBox[{{0.16000000000000003`, 134.2278782026144}, {0.16000000000000003`,
      132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 132.90849673202615`}, {0., 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.004875975000000001, 134.}, {0., 134.}}], 
    LineBox[{{0.004875975000000001, 136.}, {0., 136.}}], 
    LineBox[{{0.004875975000000001, 138.}, {0., 138.}}], 
    LineBox[{{0.009751950000000002, 140.}, {0., 140.}}], 
    LineBox[{{0.004875975000000001, 142.}, {0., 142.}}], 
    LineBox[{{0.004875975000000001, 144.}, {0., 144.}}], 
    LineBox[{{0.004875975000000001, 146.}, {0., 146.}}], 
    LineBox[{{0.004875975000000001, 148.}, {0., 148.}}], 
    LineBox[{{0.009751950000000002, 150.}, {0., 150.}}], 
    LineBox[{{0.004875975000000001, 152.}, {0., 152.}}], 
    LineBox[{{0.004875975000000001, 154.}, {0., 154.}}], 
    LineBox[{{0.004875975000000001, 156.}, {0., 156.}}], 
    LineBox[{{0.004875975000000001, 158.}, {0., 158.}}], 
    LineBox[{{0.009751950000000002, 160.}, {0., 160.}}], 
    LineBox[{{0.004875975000000001, 162.}, {0., 162.}}], 
    LineBox[{{0.004875975000000001, 164.}, {0., 164.}}], 
    LineBox[{{0.004875975000000001, 166.}, {0., 166.}}], 
    LineBox[{{0.004875975000000001, 168.}, {0., 168.}}], 
    LineBox[{{0.009751950000000002, 170.}, {0., 170.}}], 
    LineBox[{{0.004875975000000001, 172.}, {0., 172.}}], 
    LineBox[{{0.004875975000000001, 174.}, {0., 174.}}], 
    LineBox[{{0.004875975000000001, 176.}, {0., 176.}}], 
    LineBox[{{0.004875975000000001, 178.}, {0., 178.}}], 
    LineBox[{{0.009751950000000002, 180.}, {0., 180.}}], 
    LineBox[{{0.004875975000000001, 182.}, {0., 182.}}], 
    LineBox[{{0.004875975000000001, 184.}, {0., 184.}}], 
    LineBox[{{0.004875975000000001, 186.}, {0., 186.}}], 
    LineBox[{{0.004875975000000001, 188.}, {0., 188.}}], 
    LineBox[{{0.009751950000000002, 190.}, {0., 190.}}], 
    LineBox[{{0.004875975000000001, 192.}, {0., 192.}}], 
    LineBox[{{0.004875975000000001, 194.}, {0., 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 195.}, {0.16260162601626016`, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 192.36123705882352`}, {0., 195.}}], 
    LineBox[{{0.005000000000000001, 193.68061852941176`}, {
     0.005000000000000001, 195.}}], 
    LineBox[{{0.010000000000000002`, 193.68061852941176`}, {
     0.010000000000000002`, 195.}}], 
    LineBox[{{0.015000000000000003`, 193.68061852941176`}, {
     0.015000000000000003`, 195.}}], 
    LineBox[{{0.020000000000000004`, 193.68061852941176`}, {
     0.020000000000000004`, 195.}}], 
    LineBox[{{0.025, 192.36123705882352`}, {0.025, 195.}}], 
    LineBox[{{0.030000000000000002`, 193.68061852941176`}, {
     0.030000000000000002`, 195.}}], 
    LineBox[{{0.035, 193.68061852941176`}, {0.035, 195.}}], 
    LineBox[{{0.04000000000000001, 193.68061852941176`}, {0.04000000000000001,
      195.}}], 
    LineBox[{{0.045000000000000005`, 193.68061852941176`}, {
     0.045000000000000005`, 195.}}], 
    LineBox[{{0.05, 192.36123705882352`}, {0.05, 195.}}], 
    LineBox[{{0.05500000000000001, 193.68061852941176`}, {0.05500000000000001,
      195.}}], 
    LineBox[{{0.060000000000000005`, 193.68061852941176`}, {
     0.060000000000000005`, 195.}}], 
    LineBox[{{0.065, 193.68061852941176`}, {0.065, 195.}}], 
    LineBox[{{0.07, 193.68061852941176`}, {0.07, 195.}}], 
    LineBox[{{0.07500000000000001, 192.36123705882352`}, {0.07500000000000001,
      195.}}], 
    LineBox[{{0.08000000000000002, 193.68061852941176`}, {0.08000000000000002,
      195.}}], 
    LineBox[{{0.08500000000000002, 193.68061852941176`}, {0.08500000000000002,
      195.}}], 
    LineBox[{{0.09000000000000001, 193.68061852941176`}, {0.09000000000000001,
      195.}}], 
    LineBox[{{0.09500000000000001, 193.68061852941176`}, {0.09500000000000001,
      195.}}], LineBox[{{0.1, 192.36123705882352`}, {0.1, 195.}}], 
    LineBox[{{0.10500000000000001`, 193.68061852941176`}, {
     0.10500000000000001`, 195.}}], 
    LineBox[{{0.11000000000000001`, 193.68061852941176`}, {
     0.11000000000000001`, 195.}}], 
    LineBox[{{0.115, 193.68061852941176`}, {0.115, 195.}}], 
    LineBox[{{0.12000000000000001`, 193.68061852941176`}, {
     0.12000000000000001`, 195.}}], 
    LineBox[{{0.125, 192.36123705882352`}, {0.125, 195.}}], 
    LineBox[{{0.13, 193.68061852941176`}, {0.13, 195.}}], 
    LineBox[{{0.135, 193.68061852941176`}, {0.135, 195.}}], 
    LineBox[{{0.14, 193.68061852941176`}, {0.14, 195.}}], 
    LineBox[{{0.14500000000000002`, 193.68061852941176`}, {
     0.14500000000000002`, 195.}}], 
    LineBox[{{0.15000000000000002`, 192.36123705882352`}, {
     0.15000000000000002`, 195.}}], 
    LineBox[{{0.15500000000000003`, 193.68061852941176`}, {
     0.15500000000000003`, 195.}}], 
    LineBox[{{0.16000000000000003`, 193.68061852941176`}, {
     0.16000000000000003`, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16260162601626016`, 132.90849673202615`}, {
     0.16260162601626016`, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.15772565101626015`, 134.}, {0.16260162601626016`, 134.}}], 
    LineBox[{{0.15772565101626015`, 136.}, {0.16260162601626016`, 136.}}], 
    LineBox[{{0.15772565101626015`, 138.}, {0.16260162601626016`, 138.}}], 
    LineBox[{{0.15284967601626015`, 140.}, {0.16260162601626016`, 140.}}], 
    LineBox[{{0.15772565101626015`, 142.}, {0.16260162601626016`, 142.}}], 
    LineBox[{{0.15772565101626015`, 144.}, {0.16260162601626016`, 144.}}], 
    LineBox[{{0.15772565101626015`, 146.}, {0.16260162601626016`, 146.}}], 
    LineBox[{{0.15772565101626015`, 148.}, {0.16260162601626016`, 148.}}], 
    LineBox[{{0.15284967601626015`, 150.}, {0.16260162601626016`, 150.}}], 
    LineBox[{{0.15772565101626015`, 152.}, {0.16260162601626016`, 152.}}], 
    LineBox[{{0.15772565101626015`, 154.}, {0.16260162601626016`, 154.}}], 
    LineBox[{{0.15772565101626015`, 156.}, {0.16260162601626016`, 156.}}], 
    LineBox[{{0.15772565101626015`, 158.}, {0.16260162601626016`, 158.}}], 
    LineBox[{{0.15284967601626015`, 160.}, {0.16260162601626016`, 160.}}], 
    LineBox[{{0.15772565101626015`, 162.}, {0.16260162601626016`, 162.}}], 
    LineBox[{{0.15772565101626015`, 164.}, {0.16260162601626016`, 164.}}], 
    LineBox[{{0.15772565101626015`, 166.}, {0.16260162601626016`, 166.}}], 
    LineBox[{{0.15772565101626015`, 168.}, {0.16260162601626016`, 168.}}], 
    LineBox[{{0.15284967601626015`, 170.}, {0.16260162601626016`, 170.}}], 
    LineBox[{{0.15772565101626015`, 172.}, {0.16260162601626016`, 172.}}], 
    LineBox[{{0.15772565101626015`, 174.}, {0.16260162601626016`, 174.}}], 
    LineBox[{{0.15772565101626015`, 176.}, {0.16260162601626016`, 176.}}], 
    LineBox[{{0.15772565101626015`, 178.}, {0.16260162601626016`, 178.}}], 
    LineBox[{{0.15284967601626015`, 180.}, {0.16260162601626016`, 180.}}], 
    LineBox[{{0.15772565101626015`, 182.}, {0.16260162601626016`, 182.}}], 
    LineBox[{{0.15772565101626015`, 184.}, {0.16260162601626016`, 184.}}], 
    LineBox[{{0.15772565101626015`, 186.}, {0.16260162601626016`, 186.}}], 
    LineBox[{{0.15772565101626015`, 188.}, {0.16260162601626016`, 188.}}], 
    LineBox[{{0.15284967601626015`, 190.}, {0.16260162601626016`, 190.}}], 
    LineBox[{{0.15772565101626015`, 192.}, {0.16260162601626016`, 192.}}], 
    LineBox[{{0.15772565101626015`, 194.}, {0.16260162601626016`, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 132.90849673202615`}, {0.3300813008130081,
      132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17, 134.2278782026144}, {0.17, 132.90849673202615`}}], 
    LineBox[{{0.17500000000000002`, 135.54725967320263`}, {
     0.17500000000000002`, 132.90849673202615`}}], 
    LineBox[{{0.18000000000000002`, 134.2278782026144}, {0.18000000000000002`,
      132.90849673202615`}}], 
    LineBox[{{0.18500000000000003`, 134.2278782026144}, {0.18500000000000003`,
      132.90849673202615`}}], 
    LineBox[{{0.19, 134.2278782026144}, {0.19, 132.90849673202615`}}], 
    LineBox[{{0.195, 134.2278782026144}, {0.195, 132.90849673202615`}}], 
    LineBox[{{0.2, 135.54725967320263`}, {0.2, 132.90849673202615`}}], 
    LineBox[{{0.20500000000000002`, 134.2278782026144}, {0.20500000000000002`,
      132.90849673202615`}}], 
    LineBox[{{0.21000000000000002`, 134.2278782026144}, {0.21000000000000002`,
      132.90849673202615`}}], 
    LineBox[{{0.215, 134.2278782026144}, {0.215, 132.90849673202615`}}], 
    LineBox[{{0.22, 134.2278782026144}, {0.22, 132.90849673202615`}}], 
    LineBox[{{0.225, 135.54725967320263`}, {0.225, 132.90849673202615`}}], 
    LineBox[{{0.23, 134.2278782026144}, {0.23, 132.90849673202615`}}], 
    LineBox[{{0.23500000000000001`, 134.2278782026144}, {0.23500000000000001`,
      132.90849673202615`}}], 
    LineBox[{{0.24, 134.2278782026144}, {0.24, 132.90849673202615`}}], 
    LineBox[{{0.245, 134.2278782026144}, {0.245, 132.90849673202615`}}], 
    LineBox[{{0.25, 135.54725967320263`}, {0.25, 132.90849673202615`}}], 
    LineBox[{{0.255, 134.2278782026144}, {0.255, 132.90849673202615`}}], 
    LineBox[{{0.26, 134.2278782026144}, {0.26, 132.90849673202615`}}], 
    LineBox[{{0.265, 134.2278782026144}, {0.265, 132.90849673202615`}}], 
    LineBox[{{0.27, 134.2278782026144}, {0.27, 132.90849673202615`}}], 
    LineBox[{{0.275, 135.54725967320263`}, {0.275, 132.90849673202615`}}], 
    LineBox[{{0.28, 134.2278782026144}, {0.28, 132.90849673202615`}}], 
    LineBox[{{0.28500000000000003`, 134.2278782026144}, {0.28500000000000003`,
      132.90849673202615`}}], 
    LineBox[{{0.29000000000000004`, 134.2278782026144}, {0.29000000000000004`,
      132.90849673202615`}}], 
    LineBox[{{0.29500000000000004`, 134.2278782026144}, {0.29500000000000004`,
      132.90849673202615`}}], 
    LineBox[{{0.30000000000000004`, 135.54725967320263`}, {
     0.30000000000000004`, 132.90849673202615`}}], 
    LineBox[{{0.30500000000000005`, 134.2278782026144}, {0.30500000000000005`,
      132.90849673202615`}}], 
    LineBox[{{0.31000000000000005`, 134.2278782026144}, {0.31000000000000005`,
      132.90849673202615`}}], 
    LineBox[{{0.31500000000000006`, 134.2278782026144}, {0.31500000000000006`,
      132.90849673202615`}}], 
    LineBox[{{0.32000000000000006`, 134.2278782026144}, {0.32000000000000006`,
      132.90849673202615`}}], 
    LineBox[{{0.325, 135.54725967320263`}, {0.325, 132.90849673202615`}}], 
    LineBox[{{0.33, 134.2278782026144}, {0.33, 132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 132.90849673202615`}, {
     0.16747967479674797`, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17235564979674797`, 134.}, {0.16747967479674797`, 134.}}], 
    LineBox[{{0.17235564979674797`, 136.}, {0.16747967479674797`, 136.}}], 
    LineBox[{{0.17235564979674797`, 138.}, {0.16747967479674797`, 138.}}], 
    LineBox[{{0.17723162479674798`, 140.}, {0.16747967479674797`, 140.}}], 
    LineBox[{{0.17235564979674797`, 142.}, {0.16747967479674797`, 142.}}], 
    LineBox[{{0.17235564979674797`, 144.}, {0.16747967479674797`, 144.}}], 
    LineBox[{{0.17235564979674797`, 146.}, {0.16747967479674797`, 146.}}], 
    LineBox[{{0.17235564979674797`, 148.}, {0.16747967479674797`, 148.}}], 
    LineBox[{{0.17723162479674798`, 150.}, {0.16747967479674797`, 150.}}], 
    LineBox[{{0.17235564979674797`, 152.}, {0.16747967479674797`, 152.}}], 
    LineBox[{{0.17235564979674797`, 154.}, {0.16747967479674797`, 154.}}], 
    LineBox[{{0.17235564979674797`, 156.}, {0.16747967479674797`, 156.}}], 
    LineBox[{{0.17235564979674797`, 158.}, {0.16747967479674797`, 158.}}], 
    LineBox[{{0.17723162479674798`, 160.}, {0.16747967479674797`, 160.}}], 
    LineBox[{{0.17235564979674797`, 162.}, {0.16747967479674797`, 162.}}], 
    LineBox[{{0.17235564979674797`, 164.}, {0.16747967479674797`, 164.}}], 
    LineBox[{{0.17235564979674797`, 166.}, {0.16747967479674797`, 166.}}], 
    LineBox[{{0.17235564979674797`, 168.}, {0.16747967479674797`, 168.}}], 
    LineBox[{{0.17723162479674798`, 170.}, {0.16747967479674797`, 170.}}], 
    LineBox[{{0.17235564979674797`, 172.}, {0.16747967479674797`, 172.}}], 
    LineBox[{{0.17235564979674797`, 174.}, {0.16747967479674797`, 174.}}], 
    LineBox[{{0.17235564979674797`, 176.}, {0.16747967479674797`, 176.}}], 
    LineBox[{{0.17235564979674797`, 178.}, {0.16747967479674797`, 178.}}], 
    LineBox[{{0.17723162479674798`, 180.}, {0.16747967479674797`, 180.}}], 
    LineBox[{{0.17235564979674797`, 182.}, {0.16747967479674797`, 182.}}], 
    LineBox[{{0.17235564979674797`, 184.}, {0.16747967479674797`, 184.}}], 
    LineBox[{{0.17235564979674797`, 186.}, {0.16747967479674797`, 186.}}], 
    LineBox[{{0.17235564979674797`, 188.}, {0.16747967479674797`, 188.}}], 
    LineBox[{{0.17723162479674798`, 190.}, {0.16747967479674797`, 190.}}], 
    LineBox[{{0.17235564979674797`, 192.}, {0.16747967479674797`, 192.}}], 
    LineBox[{{0.17235564979674797`, 194.}, {0.16747967479674797`, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 195.}, {0.3300813008130081, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17, 193.68061852941176`}, {0.17, 195.}}], 
    LineBox[{{0.17500000000000002`, 192.36123705882352`}, {
     0.17500000000000002`, 195.}}], 
    LineBox[{{0.18000000000000002`, 193.68061852941176`}, {
     0.18000000000000002`, 195.}}], 
    LineBox[{{0.18500000000000003`, 193.68061852941176`}, {
     0.18500000000000003`, 195.}}], 
    LineBox[{{0.19, 193.68061852941176`}, {0.19, 195.}}], 
    LineBox[{{0.195, 193.68061852941176`}, {0.195, 195.}}], 
    LineBox[{{0.2, 192.36123705882352`}, {0.2, 195.}}], 
    LineBox[{{0.20500000000000002`, 193.68061852941176`}, {
     0.20500000000000002`, 195.}}], 
    LineBox[{{0.21000000000000002`, 193.68061852941176`}, {
     0.21000000000000002`, 195.}}], 
    LineBox[{{0.215, 193.68061852941176`}, {0.215, 195.}}], 
    LineBox[{{0.22, 193.68061852941176`}, {0.22, 195.}}], 
    LineBox[{{0.225, 192.36123705882352`}, {0.225, 195.}}], 
    LineBox[{{0.23, 193.68061852941176`}, {0.23, 195.}}], 
    LineBox[{{0.23500000000000001`, 193.68061852941176`}, {
     0.23500000000000001`, 195.}}], 
    LineBox[{{0.24, 193.68061852941176`}, {0.24, 195.}}], 
    LineBox[{{0.245, 193.68061852941176`}, {0.245, 195.}}], 
    LineBox[{{0.25, 192.36123705882352`}, {0.25, 195.}}], 
    LineBox[{{0.255, 193.68061852941176`}, {0.255, 195.}}], 
    LineBox[{{0.26, 193.68061852941176`}, {0.26, 195.}}], 
    LineBox[{{0.265, 193.68061852941176`}, {0.265, 195.}}], 
    LineBox[{{0.27, 193.68061852941176`}, {0.27, 195.}}], 
    LineBox[{{0.275, 192.36123705882352`}, {0.275, 195.}}], 
    LineBox[{{0.28, 193.68061852941176`}, {0.28, 195.}}], 
    LineBox[{{0.28500000000000003`, 193.68061852941176`}, {
     0.28500000000000003`, 195.}}], 
    LineBox[{{0.29000000000000004`, 193.68061852941176`}, {
     0.29000000000000004`, 195.}}], 
    LineBox[{{0.29500000000000004`, 193.68061852941176`}, {
     0.29500000000000004`, 195.}}], 
    LineBox[{{0.30000000000000004`, 192.36123705882352`}, {
     0.30000000000000004`, 195.}}], 
    LineBox[{{0.30500000000000005`, 193.68061852941176`}, {
     0.30500000000000005`, 195.}}], 
    LineBox[{{0.31000000000000005`, 193.68061852941176`}, {
     0.31000000000000005`, 195.}}], 
    LineBox[{{0.31500000000000006`, 193.68061852941176`}, {
     0.31500000000000006`, 195.}}], 
    LineBox[{{0.32000000000000006`, 193.68061852941176`}, {
     0.32000000000000006`, 195.}}], 
    LineBox[{{0.325, 192.36123705882352`}, {0.325, 195.}}], 
    LineBox[{{0.33, 193.68061852941176`}, {0.33, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.3300813008130081, 132.90849673202615`}, {0.3300813008130081, 
     195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.32520532581300815`, 134.}, {0.3300813008130081, 134.}}], 
    LineBox[{{0.32520532581300815`, 136.}, {0.3300813008130081, 136.}}], 
    LineBox[{{0.32520532581300815`, 138.}, {0.3300813008130081, 138.}}], 
    LineBox[{{0.3203293508130081, 140.}, {0.3300813008130081, 140.}}], 
    LineBox[{{0.32520532581300815`, 142.}, {0.3300813008130081, 142.}}], 
    LineBox[{{0.32520532581300815`, 144.}, {0.3300813008130081, 144.}}], 
    LineBox[{{0.32520532581300815`, 146.}, {0.3300813008130081, 146.}}], 
    LineBox[{{0.32520532581300815`, 148.}, {0.3300813008130081, 148.}}], 
    LineBox[{{0.3203293508130081, 150.}, {0.3300813008130081, 150.}}], 
    LineBox[{{0.32520532581300815`, 152.}, {0.3300813008130081, 152.}}], 
    LineBox[{{0.32520532581300815`, 154.}, {0.3300813008130081, 154.}}], 
    LineBox[{{0.32520532581300815`, 156.}, {0.3300813008130081, 156.}}], 
    LineBox[{{0.32520532581300815`, 158.}, {0.3300813008130081, 158.}}], 
    LineBox[{{0.3203293508130081, 160.}, {0.3300813008130081, 160.}}], 
    LineBox[{{0.32520532581300815`, 162.}, {0.3300813008130081, 162.}}], 
    LineBox[{{0.32520532581300815`, 164.}, {0.3300813008130081, 164.}}], 
    LineBox[{{0.32520532581300815`, 166.}, {0.3300813008130081, 166.}}], 
    LineBox[{{0.32520532581300815`, 168.}, {0.3300813008130081, 168.}}], 
    LineBox[{{0.3203293508130081, 170.}, {0.3300813008130081, 170.}}], 
    LineBox[{{0.32520532581300815`, 172.}, {0.3300813008130081, 172.}}], 
    LineBox[{{0.32520532581300815`, 174.}, {0.3300813008130081, 174.}}], 
    LineBox[{{0.32520532581300815`, 176.}, {0.3300813008130081, 176.}}], 
    LineBox[{{0.32520532581300815`, 178.}, {0.3300813008130081, 178.}}], 
    LineBox[{{0.3203293508130081, 180.}, {0.3300813008130081, 180.}}], 
    LineBox[{{0.32520532581300815`, 182.}, {0.3300813008130081, 182.}}], 
    LineBox[{{0.32520532581300815`, 184.}, {0.3300813008130081, 184.}}], 
    LineBox[{{0.32520532581300815`, 186.}, {0.3300813008130081, 186.}}], 
    LineBox[{{0.32520532581300815`, 188.}, {0.3300813008130081, 188.}}], 
    LineBox[{{0.3203293508130081, 190.}, {0.3300813008130081, 190.}}], 
    LineBox[{{0.32520532581300815`, 192.}, {0.3300813008130081, 192.}}], 
    LineBox[{{0.32520532581300815`, 194.}, {0.3300813008130081, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 132.90849673202615`}, {0.4975609756097561,
      132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.335, 134.2278782026144}, {0.335, 132.90849673202615`}}], 
    LineBox[{{0.34, 134.2278782026144}, {0.34, 132.90849673202615`}}], 
    LineBox[{{0.34500000000000003`, 134.2278782026144}, {0.34500000000000003`,
      132.90849673202615`}}], 
    LineBox[{{0.35000000000000003`, 135.54725967320263`}, {
     0.35000000000000003`, 132.90849673202615`}}], 
    LineBox[{{0.35500000000000004`, 134.2278782026144}, {0.35500000000000004`,
      132.90849673202615`}}], 
    LineBox[{{0.36000000000000004`, 134.2278782026144}, {0.36000000000000004`,
      132.90849673202615`}}], 
    LineBox[{{0.365, 134.2278782026144}, {0.365, 132.90849673202615`}}], 
    LineBox[{{0.37, 134.2278782026144}, {0.37, 132.90849673202615`}}], 
    LineBox[{{0.375, 135.54725967320263`}, {0.375, 132.90849673202615`}}], 
    LineBox[{{0.38, 134.2278782026144}, {0.38, 132.90849673202615`}}], 
    LineBox[{{0.385, 134.2278782026144}, {0.385, 132.90849673202615`}}], 
    LineBox[{{0.38999999999999996`, 134.2278782026144}, {0.38999999999999996`,
      132.90849673202615`}}], 
    LineBox[{{0.39499999999999996`, 134.2278782026144}, {0.39499999999999996`,
      132.90849673202615`}}], 
    LineBox[{{0.4, 135.54725967320263`}, {0.4, 132.90849673202615`}}], 
    LineBox[{{0.405, 134.2278782026144}, {0.405, 132.90849673202615`}}], 
    LineBox[{{0.41000000000000003`, 134.2278782026144}, {0.41000000000000003`,
      132.90849673202615`}}], 
    LineBox[{{0.415, 134.2278782026144}, {0.415, 132.90849673202615`}}], 
    LineBox[{{0.42, 134.2278782026144}, {0.42, 132.90849673202615`}}], 
    LineBox[{{0.42500000000000004`, 135.54725967320263`}, {
     0.42500000000000004`, 132.90849673202615`}}], 
    LineBox[{{0.43000000000000005`, 134.2278782026144}, {0.43000000000000005`,
      132.90849673202615`}}], 
    LineBox[{{0.43500000000000005`, 134.2278782026144}, {0.43500000000000005`,
      132.90849673202615`}}], 
    LineBox[{{0.44, 134.2278782026144}, {0.44, 132.90849673202615`}}], 
    LineBox[{{0.445, 134.2278782026144}, {0.445, 132.90849673202615`}}], 
    LineBox[{{0.45, 135.54725967320263`}, {0.45, 132.90849673202615`}}], 
    LineBox[{{0.455, 134.2278782026144}, {0.455, 132.90849673202615`}}], 
    LineBox[{{0.46, 134.2278782026144}, {0.46, 132.90849673202615`}}], 
    LineBox[{{0.46499999999999997`, 134.2278782026144}, {0.46499999999999997`,
      132.90849673202615`}}], 
    LineBox[{{0.47, 134.2278782026144}, {0.47, 132.90849673202615`}}], 
    LineBox[{{0.47500000000000003`, 135.54725967320263`}, {
     0.47500000000000003`, 132.90849673202615`}}], 
    LineBox[{{0.48000000000000004`, 134.2278782026144}, {0.48000000000000004`,
      132.90849673202615`}}], 
    LineBox[{{0.48500000000000004`, 134.2278782026144}, {0.48500000000000004`,
      132.90849673202615`}}], 
    LineBox[{{0.49000000000000005`, 134.2278782026144}, {0.49000000000000005`,
      132.90849673202615`}}], 
    LineBox[{{0.49500000000000005`, 134.2278782026144}, {0.49500000000000005`,
      132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 132.90849673202615`}, {
     0.33495934959349594`, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.3398353245934959, 134.}, {0.33495934959349594`, 134.}}], 
    LineBox[{{0.3398353245934959, 136.}, {0.33495934959349594`, 136.}}], 
    LineBox[{{0.3398353245934959, 138.}, {0.33495934959349594`, 138.}}], 
    LineBox[{{0.34471129959349595`, 140.}, {0.33495934959349594`, 140.}}], 
    LineBox[{{0.3398353245934959, 142.}, {0.33495934959349594`, 142.}}], 
    LineBox[{{0.3398353245934959, 144.}, {0.33495934959349594`, 144.}}], 
    LineBox[{{0.3398353245934959, 146.}, {0.33495934959349594`, 146.}}], 
    LineBox[{{0.3398353245934959, 148.}, {0.33495934959349594`, 148.}}], 
    LineBox[{{0.34471129959349595`, 150.}, {0.33495934959349594`, 150.}}], 
    LineBox[{{0.3398353245934959, 152.}, {0.33495934959349594`, 152.}}], 
    LineBox[{{0.3398353245934959, 154.}, {0.33495934959349594`, 154.}}], 
    LineBox[{{0.3398353245934959, 156.}, {0.33495934959349594`, 156.}}], 
    LineBox[{{0.3398353245934959, 158.}, {0.33495934959349594`, 158.}}], 
    LineBox[{{0.34471129959349595`, 160.}, {0.33495934959349594`, 160.}}], 
    LineBox[{{0.3398353245934959, 162.}, {0.33495934959349594`, 162.}}], 
    LineBox[{{0.3398353245934959, 164.}, {0.33495934959349594`, 164.}}], 
    LineBox[{{0.3398353245934959, 166.}, {0.33495934959349594`, 166.}}], 
    LineBox[{{0.3398353245934959, 168.}, {0.33495934959349594`, 168.}}], 
    LineBox[{{0.34471129959349595`, 170.}, {0.33495934959349594`, 170.}}], 
    LineBox[{{0.3398353245934959, 172.}, {0.33495934959349594`, 172.}}], 
    LineBox[{{0.3398353245934959, 174.}, {0.33495934959349594`, 174.}}], 
    LineBox[{{0.3398353245934959, 176.}, {0.33495934959349594`, 176.}}], 
    LineBox[{{0.3398353245934959, 178.}, {0.33495934959349594`, 178.}}], 
    LineBox[{{0.34471129959349595`, 180.}, {0.33495934959349594`, 180.}}], 
    LineBox[{{0.3398353245934959, 182.}, {0.33495934959349594`, 182.}}], 
    LineBox[{{0.3398353245934959, 184.}, {0.33495934959349594`, 184.}}], 
    LineBox[{{0.3398353245934959, 186.}, {0.33495934959349594`, 186.}}], 
    LineBox[{{0.3398353245934959, 188.}, {0.33495934959349594`, 188.}}], 
    LineBox[{{0.34471129959349595`, 190.}, {0.33495934959349594`, 190.}}], 
    LineBox[{{0.3398353245934959, 192.}, {0.33495934959349594`, 192.}}], 
    LineBox[{{0.3398353245934959, 194.}, {0.33495934959349594`, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 195.}, {0.4975609756097561, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.335, 193.68061852941176`}, {0.335, 195.}}], 
    LineBox[{{0.34, 193.68061852941176`}, {0.34, 195.}}], 
    LineBox[{{0.34500000000000003`, 193.68061852941176`}, {
     0.34500000000000003`, 195.}}], 
    LineBox[{{0.35000000000000003`, 192.36123705882352`}, {
     0.35000000000000003`, 195.}}], 
    LineBox[{{0.35500000000000004`, 193.68061852941176`}, {
     0.35500000000000004`, 195.}}], 
    LineBox[{{0.36000000000000004`, 193.68061852941176`}, {
     0.36000000000000004`, 195.}}], 
    LineBox[{{0.365, 193.68061852941176`}, {0.365, 195.}}], 
    LineBox[{{0.37, 193.68061852941176`}, {0.37, 195.}}], 
    LineBox[{{0.375, 192.36123705882352`}, {0.375, 195.}}], 
    LineBox[{{0.38, 193.68061852941176`}, {0.38, 195.}}], 
    LineBox[{{0.385, 193.68061852941176`}, {0.385, 195.}}], 
    LineBox[{{0.38999999999999996`, 193.68061852941176`}, {
     0.38999999999999996`, 195.}}], 
    LineBox[{{0.39499999999999996`, 193.68061852941176`}, {
     0.39499999999999996`, 195.}}], 
    LineBox[{{0.4, 192.36123705882352`}, {0.4, 195.}}], 
    LineBox[{{0.405, 193.68061852941176`}, {0.405, 195.}}], 
    LineBox[{{0.41000000000000003`, 193.68061852941176`}, {
     0.41000000000000003`, 195.}}], 
    LineBox[{{0.415, 193.68061852941176`}, {0.415, 195.}}], 
    LineBox[{{0.42, 193.68061852941176`}, {0.42, 195.}}], 
    LineBox[{{0.42500000000000004`, 192.36123705882352`}, {
     0.42500000000000004`, 195.}}], 
    LineBox[{{0.43000000000000005`, 193.68061852941176`}, {
     0.43000000000000005`, 195.}}], 
    LineBox[{{0.43500000000000005`, 193.68061852941176`}, {
     0.43500000000000005`, 195.}}], 
    LineBox[{{0.44, 193.68061852941176`}, {0.44, 195.}}], 
    LineBox[{{0.445, 193.68061852941176`}, {0.445, 195.}}], 
    LineBox[{{0.45, 192.36123705882352`}, {0.45, 195.}}], 
    LineBox[{{0.455, 193.68061852941176`}, {0.455, 195.}}], 
    LineBox[{{0.46, 193.68061852941176`}, {0.46, 195.}}], 
    LineBox[{{0.46499999999999997`, 193.68061852941176`}, {
     0.46499999999999997`, 195.}}], 
    LineBox[{{0.47, 193.68061852941176`}, {0.47, 195.}}], 
    LineBox[{{0.47500000000000003`, 192.36123705882352`}, {
     0.47500000000000003`, 195.}}], 
    LineBox[{{0.48000000000000004`, 193.68061852941176`}, {
     0.48000000000000004`, 195.}}], 
    LineBox[{{0.48500000000000004`, 193.68061852941176`}, {
     0.48500000000000004`, 195.}}], 
    LineBox[{{0.49000000000000005`, 193.68061852941176`}, {
     0.49000000000000005`, 195.}}], 
    LineBox[{{0.49500000000000005`, 193.68061852941176`}, {
     0.49500000000000005`, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.4975609756097561, 132.90849673202615`}, {0.4975609756097561, 
     195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.4926850006097561, 134.}, {0.4975609756097561, 134.}}], 
    LineBox[{{0.4926850006097561, 136.}, {0.4975609756097561, 136.}}], 
    LineBox[{{0.4926850006097561, 138.}, {0.4975609756097561, 138.}}], 
    LineBox[{{0.4878090256097561, 140.}, {0.4975609756097561, 140.}}], 
    LineBox[{{0.4926850006097561, 142.}, {0.4975609756097561, 142.}}], 
    LineBox[{{0.4926850006097561, 144.}, {0.4975609756097561, 144.}}], 
    LineBox[{{0.4926850006097561, 146.}, {0.4975609756097561, 146.}}], 
    LineBox[{{0.4926850006097561, 148.}, {0.4975609756097561, 148.}}], 
    LineBox[{{0.4878090256097561, 150.}, {0.4975609756097561, 150.}}], 
    LineBox[{{0.4926850006097561, 152.}, {0.4975609756097561, 152.}}], 
    LineBox[{{0.4926850006097561, 154.}, {0.4975609756097561, 154.}}], 
    LineBox[{{0.4926850006097561, 156.}, {0.4975609756097561, 156.}}], 
    LineBox[{{0.4926850006097561, 158.}, {0.4975609756097561, 158.}}], 
    LineBox[{{0.4878090256097561, 160.}, {0.4975609756097561, 160.}}], 
    LineBox[{{0.4926850006097561, 162.}, {0.4975609756097561, 162.}}], 
    LineBox[{{0.4926850006097561, 164.}, {0.4975609756097561, 164.}}], 
    LineBox[{{0.4926850006097561, 166.}, {0.4975609756097561, 166.}}], 
    LineBox[{{0.4926850006097561, 168.}, {0.4975609756097561, 168.}}], 
    LineBox[{{0.4878090256097561, 170.}, {0.4975609756097561, 170.}}], 
    LineBox[{{0.4926850006097561, 172.}, {0.4975609756097561, 172.}}], 
    LineBox[{{0.4926850006097561, 174.}, {0.4975609756097561, 174.}}], 
    LineBox[{{0.4926850006097561, 176.}, {0.4975609756097561, 176.}}], 
    LineBox[{{0.4926850006097561, 178.}, {0.4975609756097561, 178.}}], 
    LineBox[{{0.4878090256097561, 180.}, {0.4975609756097561, 180.}}], 
    LineBox[{{0.4926850006097561, 182.}, {0.4975609756097561, 182.}}], 
    LineBox[{{0.4926850006097561, 184.}, {0.4975609756097561, 184.}}], 
    LineBox[{{0.4926850006097561, 186.}, {0.4975609756097561, 186.}}], 
    LineBox[{{0.4926850006097561, 188.}, {0.4975609756097561, 188.}}], 
    LineBox[{{0.4878090256097561, 190.}, {0.4975609756097561, 190.}}], 
    LineBox[{{0.4926850006097561, 192.}, {0.4975609756097561, 192.}}], 
    LineBox[{{0.4926850006097561, 194.}, {0.4975609756097561, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 132.90849673202615`}, {0.6650406504065041, 
     132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.505, 134.2278782026144}, {0.505, 132.90849673202615`}}], 
    LineBox[{{0.51, 134.2278782026144}, {0.51, 132.90849673202615`}}], 
    LineBox[{{0.515, 134.2278782026144}, {0.515, 132.90849673202615`}}], 
    LineBox[{{0.52, 134.2278782026144}, {0.52, 132.90849673202615`}}], 
    LineBox[{{0.525, 135.54725967320263`}, {0.525, 132.90849673202615`}}], 
    LineBox[{{0.53, 134.2278782026144}, {0.53, 132.90849673202615`}}], 
    LineBox[{{0.535, 134.2278782026144}, {0.535, 132.90849673202615`}}], 
    LineBox[{{0.54, 134.2278782026144}, {0.54, 132.90849673202615`}}], 
    LineBox[{{0.545, 134.2278782026144}, {0.545, 132.90849673202615`}}], 
    LineBox[{{0.55, 135.54725967320263`}, {0.55, 132.90849673202615`}}], 
    LineBox[{{0.555, 134.2278782026144}, {0.555, 132.90849673202615`}}], 
    LineBox[{{0.56, 134.2278782026144}, {0.56, 132.90849673202615`}}], 
    LineBox[{{0.5650000000000001, 134.2278782026144}, {0.5650000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.5700000000000001, 134.2278782026144}, {0.5700000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.5750000000000001, 135.54725967320263`}, {0.5750000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.5800000000000001, 134.2278782026144}, {0.5800000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.5850000000000001, 134.2278782026144}, {0.5850000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.5900000000000001, 134.2278782026144}, {0.5900000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.5950000000000001, 134.2278782026144}, {0.5950000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.6000000000000001, 135.54725967320263`}, {0.6000000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.6050000000000001, 134.2278782026144}, {0.6050000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.6100000000000001, 134.2278782026144}, {0.6100000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.6150000000000001, 134.2278782026144}, {0.6150000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.6200000000000001, 134.2278782026144}, {0.6200000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.625, 135.54725967320263`}, {0.625, 132.90849673202615`}}], 
    LineBox[{{0.63, 134.2278782026144}, {0.63, 132.90849673202615`}}], 
    LineBox[{{0.635, 134.2278782026144}, {0.635, 132.90849673202615`}}], 
    LineBox[{{0.64, 134.2278782026144}, {0.64, 132.90849673202615`}}], 
    LineBox[{{0.645, 134.2278782026144}, {0.645, 132.90849673202615`}}], 
    LineBox[{{0.65, 135.54725967320263`}, {0.65, 132.90849673202615`}}], 
    LineBox[{{0.655, 134.2278782026144}, {0.655, 132.90849673202615`}}], 
    LineBox[{{0.66, 134.2278782026144}, {0.66, 132.90849673202615`}}], 
    LineBox[{{0.665, 134.2278782026144}, {0.665, 132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 132.90849673202615`}, {0.5024390243902439, 
     195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5073149993902439, 134.}, {0.5024390243902439, 134.}}], 
    LineBox[{{0.5073149993902439, 136.}, {0.5024390243902439, 136.}}], 
    LineBox[{{0.5073149993902439, 138.}, {0.5024390243902439, 138.}}], 
    LineBox[{{0.5121909743902439, 140.}, {0.5024390243902439, 140.}}], 
    LineBox[{{0.5073149993902439, 142.}, {0.5024390243902439, 142.}}], 
    LineBox[{{0.5073149993902439, 144.}, {0.5024390243902439, 144.}}], 
    LineBox[{{0.5073149993902439, 146.}, {0.5024390243902439, 146.}}], 
    LineBox[{{0.5073149993902439, 148.}, {0.5024390243902439, 148.}}], 
    LineBox[{{0.5121909743902439, 150.}, {0.5024390243902439, 150.}}], 
    LineBox[{{0.5073149993902439, 152.}, {0.5024390243902439, 152.}}], 
    LineBox[{{0.5073149993902439, 154.}, {0.5024390243902439, 154.}}], 
    LineBox[{{0.5073149993902439, 156.}, {0.5024390243902439, 156.}}], 
    LineBox[{{0.5073149993902439, 158.}, {0.5024390243902439, 158.}}], 
    LineBox[{{0.5121909743902439, 160.}, {0.5024390243902439, 160.}}], 
    LineBox[{{0.5073149993902439, 162.}, {0.5024390243902439, 162.}}], 
    LineBox[{{0.5073149993902439, 164.}, {0.5024390243902439, 164.}}], 
    LineBox[{{0.5073149993902439, 166.}, {0.5024390243902439, 166.}}], 
    LineBox[{{0.5073149993902439, 168.}, {0.5024390243902439, 168.}}], 
    LineBox[{{0.5121909743902439, 170.}, {0.5024390243902439, 170.}}], 
    LineBox[{{0.5073149993902439, 172.}, {0.5024390243902439, 172.}}], 
    LineBox[{{0.5073149993902439, 174.}, {0.5024390243902439, 174.}}], 
    LineBox[{{0.5073149993902439, 176.}, {0.5024390243902439, 176.}}], 
    LineBox[{{0.5073149993902439, 178.}, {0.5024390243902439, 178.}}], 
    LineBox[{{0.5121909743902439, 180.}, {0.5024390243902439, 180.}}], 
    LineBox[{{0.5073149993902439, 182.}, {0.5024390243902439, 182.}}], 
    LineBox[{{0.5073149993902439, 184.}, {0.5024390243902439, 184.}}], 
    LineBox[{{0.5073149993902439, 186.}, {0.5024390243902439, 186.}}], 
    LineBox[{{0.5073149993902439, 188.}, {0.5024390243902439, 188.}}], 
    LineBox[{{0.5121909743902439, 190.}, {0.5024390243902439, 190.}}], 
    LineBox[{{0.5073149993902439, 192.}, {0.5024390243902439, 192.}}], 
    LineBox[{{0.5073149993902439, 194.}, {0.5024390243902439, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 195.}, {0.6650406504065041, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.505, 193.68061852941176`}, {0.505, 195.}}], 
    LineBox[{{0.51, 193.68061852941176`}, {0.51, 195.}}], 
    LineBox[{{0.515, 193.68061852941176`}, {0.515, 195.}}], 
    LineBox[{{0.52, 193.68061852941176`}, {0.52, 195.}}], 
    LineBox[{{0.525, 192.36123705882352`}, {0.525, 195.}}], 
    LineBox[{{0.53, 193.68061852941176`}, {0.53, 195.}}], 
    LineBox[{{0.535, 193.68061852941176`}, {0.535, 195.}}], 
    LineBox[{{0.54, 193.68061852941176`}, {0.54, 195.}}], 
    LineBox[{{0.545, 193.68061852941176`}, {0.545, 195.}}], 
    LineBox[{{0.55, 192.36123705882352`}, {0.55, 195.}}], 
    LineBox[{{0.555, 193.68061852941176`}, {0.555, 195.}}], 
    LineBox[{{0.56, 193.68061852941176`}, {0.56, 195.}}], 
    LineBox[{{0.5650000000000001, 193.68061852941176`}, {0.5650000000000001, 
     195.}}], LineBox[{{0.5700000000000001, 193.68061852941176`}, {
     0.5700000000000001, 195.}}], 
    LineBox[{{0.5750000000000001, 192.36123705882352`}, {0.5750000000000001, 
     195.}}], 
    LineBox[{{0.5800000000000001, 193.68061852941176`}, {0.5800000000000001, 
     195.}}], LineBox[{{0.5850000000000001, 193.68061852941176`}, {
     0.5850000000000001, 195.}}], 
    LineBox[{{0.5900000000000001, 193.68061852941176`}, {0.5900000000000001, 
     195.}}], LineBox[{{0.5950000000000001, 193.68061852941176`}, {
     0.5950000000000001, 195.}}], 
    LineBox[{{0.6000000000000001, 192.36123705882352`}, {0.6000000000000001, 
     195.}}], LineBox[{{0.6050000000000001, 193.68061852941176`}, {
     0.6050000000000001, 195.}}], 
    LineBox[{{0.6100000000000001, 193.68061852941176`}, {0.6100000000000001, 
     195.}}], LineBox[{{0.6150000000000001, 193.68061852941176`}, {
     0.6150000000000001, 195.}}], 
    LineBox[{{0.6200000000000001, 193.68061852941176`}, {0.6200000000000001, 
     195.}}], LineBox[{{0.625, 192.36123705882352`}, {0.625, 195.}}], 
    LineBox[{{0.63, 193.68061852941176`}, {0.63, 195.}}], 
    LineBox[{{0.635, 193.68061852941176`}, {0.635, 195.}}], 
    LineBox[{{0.64, 193.68061852941176`}, {0.64, 195.}}], 
    LineBox[{{0.645, 193.68061852941176`}, {0.645, 195.}}], 
    LineBox[{{0.65, 192.36123705882352`}, {0.65, 195.}}], 
    LineBox[{{0.655, 193.68061852941176`}, {0.655, 195.}}], 
    LineBox[{{0.66, 193.68061852941176`}, {0.66, 195.}}], 
    LineBox[{{0.665, 193.68061852941176`}, {0.665, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6650406504065041, 132.90849673202615`}, {0.6650406504065041, 
     195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.660164675406504, 134.}, {0.6650406504065041, 134.}}], 
    LineBox[{{0.660164675406504, 136.}, {0.6650406504065041, 136.}}], 
    LineBox[{{0.660164675406504, 138.}, {0.6650406504065041, 138.}}], 
    LineBox[{{0.6552887004065041, 140.}, {0.6650406504065041, 140.}}], 
    LineBox[{{0.660164675406504, 142.}, {0.6650406504065041, 142.}}], 
    LineBox[{{0.660164675406504, 144.}, {0.6650406504065041, 144.}}], 
    LineBox[{{0.660164675406504, 146.}, {0.6650406504065041, 146.}}], 
    LineBox[{{0.660164675406504, 148.}, {0.6650406504065041, 148.}}], 
    LineBox[{{0.6552887004065041, 150.}, {0.6650406504065041, 150.}}], 
    LineBox[{{0.660164675406504, 152.}, {0.6650406504065041, 152.}}], 
    LineBox[{{0.660164675406504, 154.}, {0.6650406504065041, 154.}}], 
    LineBox[{{0.660164675406504, 156.}, {0.6650406504065041, 156.}}], 
    LineBox[{{0.660164675406504, 158.}, {0.6650406504065041, 158.}}], 
    LineBox[{{0.6552887004065041, 160.}, {0.6650406504065041, 160.}}], 
    LineBox[{{0.660164675406504, 162.}, {0.6650406504065041, 162.}}], 
    LineBox[{{0.660164675406504, 164.}, {0.6650406504065041, 164.}}], 
    LineBox[{{0.660164675406504, 166.}, {0.6650406504065041, 166.}}], 
    LineBox[{{0.660164675406504, 168.}, {0.6650406504065041, 168.}}], 
    LineBox[{{0.6552887004065041, 170.}, {0.6650406504065041, 170.}}], 
    LineBox[{{0.660164675406504, 172.}, {0.6650406504065041, 172.}}], 
    LineBox[{{0.660164675406504, 174.}, {0.6650406504065041, 174.}}], 
    LineBox[{{0.660164675406504, 176.}, {0.6650406504065041, 176.}}], 
    LineBox[{{0.660164675406504, 178.}, {0.6650406504065041, 178.}}], 
    LineBox[{{0.6552887004065041, 180.}, {0.6650406504065041, 180.}}], 
    LineBox[{{0.660164675406504, 182.}, {0.6650406504065041, 182.}}], 
    LineBox[{{0.660164675406504, 184.}, {0.6650406504065041, 184.}}], 
    LineBox[{{0.660164675406504, 186.}, {0.6650406504065041, 186.}}], 
    LineBox[{{0.660164675406504, 188.}, {0.6650406504065041, 188.}}], 
    LineBox[{{0.6552887004065041, 190.}, {0.6650406504065041, 190.}}], 
    LineBox[{{0.660164675406504, 192.}, {0.6650406504065041, 192.}}], 
    LineBox[{{0.660164675406504, 194.}, {0.6650406504065041, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 132.90849673202615`}, {0.832520325203252, 
     132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.67, 134.2278782026144}, {0.67, 132.90849673202615`}}], 
    LineBox[{{0.675, 135.54725967320263`}, {0.675, 132.90849673202615`}}], 
    LineBox[{{0.68, 134.2278782026144}, {0.68, 132.90849673202615`}}], 
    LineBox[{{0.685, 134.2278782026144}, {0.685, 132.90849673202615`}}], 
    LineBox[{{0.6900000000000001, 134.2278782026144}, {0.6900000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.6950000000000001, 134.2278782026144}, {0.6950000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7000000000000001, 135.54725967320263`}, {0.7000000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7050000000000001, 134.2278782026144}, {0.7050000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7100000000000001, 134.2278782026144}, {0.7100000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7150000000000001, 134.2278782026144}, {0.7150000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7200000000000001, 134.2278782026144}, {0.7200000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7250000000000001, 135.54725967320263`}, {0.7250000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7300000000000001, 134.2278782026144}, {0.7300000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7350000000000001, 134.2278782026144}, {0.7350000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7400000000000001, 134.2278782026144}, {0.7400000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.7450000000000001, 134.2278782026144}, {0.7450000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.75, 135.54725967320263`}, {0.75, 132.90849673202615`}}], 
    LineBox[{{0.755, 134.2278782026144}, {0.755, 132.90849673202615`}}], 
    LineBox[{{0.76, 134.2278782026144}, {0.76, 132.90849673202615`}}], 
    LineBox[{{0.765, 134.2278782026144}, {0.765, 132.90849673202615`}}], 
    LineBox[{{0.77, 134.2278782026144}, {0.77, 132.90849673202615`}}], 
    LineBox[{{0.775, 135.54725967320263`}, {0.775, 132.90849673202615`}}], 
    LineBox[{{0.78, 134.2278782026144}, {0.78, 132.90849673202615`}}], 
    LineBox[{{0.785, 134.2278782026144}, {0.785, 132.90849673202615`}}], 
    LineBox[{{0.79, 134.2278782026144}, {0.79, 132.90849673202615`}}], 
    LineBox[{{0.795, 134.2278782026144}, {0.795, 132.90849673202615`}}], 
    LineBox[{{0.8, 135.54725967320263`}, {0.8, 132.90849673202615`}}], 
    LineBox[{{0.805, 134.2278782026144}, {0.805, 132.90849673202615`}}], 
    LineBox[{{0.81, 134.2278782026144}, {0.81, 132.90849673202615`}}], 
    LineBox[{{0.8150000000000001, 134.2278782026144}, {0.8150000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.8200000000000001, 134.2278782026144}, {0.8200000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.8250000000000001, 135.54725967320263`}, {0.8250000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.8300000000000001, 134.2278782026144}, {0.8300000000000001, 
     132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 132.90849673202615`}, {0.6699186991869919, 
     195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6747946741869919, 134.}, {0.6699186991869919, 134.}}], 
    LineBox[{{0.6747946741869919, 136.}, {0.6699186991869919, 136.}}], 
    LineBox[{{0.6747946741869919, 138.}, {0.6699186991869919, 138.}}], 
    LineBox[{{0.6796706491869918, 140.}, {0.6699186991869919, 140.}}], 
    LineBox[{{0.6747946741869919, 142.}, {0.6699186991869919, 142.}}], 
    LineBox[{{0.6747946741869919, 144.}, {0.6699186991869919, 144.}}], 
    LineBox[{{0.6747946741869919, 146.}, {0.6699186991869919, 146.}}], 
    LineBox[{{0.6747946741869919, 148.}, {0.6699186991869919, 148.}}], 
    LineBox[{{0.6796706491869918, 150.}, {0.6699186991869919, 150.}}], 
    LineBox[{{0.6747946741869919, 152.}, {0.6699186991869919, 152.}}], 
    LineBox[{{0.6747946741869919, 154.}, {0.6699186991869919, 154.}}], 
    LineBox[{{0.6747946741869919, 156.}, {0.6699186991869919, 156.}}], 
    LineBox[{{0.6747946741869919, 158.}, {0.6699186991869919, 158.}}], 
    LineBox[{{0.6796706491869918, 160.}, {0.6699186991869919, 160.}}], 
    LineBox[{{0.6747946741869919, 162.}, {0.6699186991869919, 162.}}], 
    LineBox[{{0.6747946741869919, 164.}, {0.6699186991869919, 164.}}], 
    LineBox[{{0.6747946741869919, 166.}, {0.6699186991869919, 166.}}], 
    LineBox[{{0.6747946741869919, 168.}, {0.6699186991869919, 168.}}], 
    LineBox[{{0.6796706491869918, 170.}, {0.6699186991869919, 170.}}], 
    LineBox[{{0.6747946741869919, 172.}, {0.6699186991869919, 172.}}], 
    LineBox[{{0.6747946741869919, 174.}, {0.6699186991869919, 174.}}], 
    LineBox[{{0.6747946741869919, 176.}, {0.6699186991869919, 176.}}], 
    LineBox[{{0.6747946741869919, 178.}, {0.6699186991869919, 178.}}], 
    LineBox[{{0.6796706491869918, 180.}, {0.6699186991869919, 180.}}], 
    LineBox[{{0.6747946741869919, 182.}, {0.6699186991869919, 182.}}], 
    LineBox[{{0.6747946741869919, 184.}, {0.6699186991869919, 184.}}], 
    LineBox[{{0.6747946741869919, 186.}, {0.6699186991869919, 186.}}], 
    LineBox[{{0.6747946741869919, 188.}, {0.6699186991869919, 188.}}], 
    LineBox[{{0.6796706491869918, 190.}, {0.6699186991869919, 190.}}], 
    LineBox[{{0.6747946741869919, 192.}, {0.6699186991869919, 192.}}], 
    LineBox[{{0.6747946741869919, 194.}, {0.6699186991869919, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 195.}, {0.832520325203252, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.67, 193.68061852941176`}, {0.67, 195.}}], 
    LineBox[{{0.675, 192.36123705882352`}, {0.675, 195.}}], 
    LineBox[{{0.68, 193.68061852941176`}, {0.68, 195.}}], 
    LineBox[{{0.685, 193.68061852941176`}, {0.685, 195.}}], 
    LineBox[{{0.6900000000000001, 193.68061852941176`}, {0.6900000000000001, 
     195.}}], LineBox[{{0.6950000000000001, 193.68061852941176`}, {
     0.6950000000000001, 195.}}], 
    LineBox[{{0.7000000000000001, 192.36123705882352`}, {0.7000000000000001, 
     195.}}], LineBox[{{0.7050000000000001, 193.68061852941176`}, {
     0.7050000000000001, 195.}}], 
    LineBox[{{0.7100000000000001, 193.68061852941176`}, {0.7100000000000001, 
     195.}}], LineBox[{{0.7150000000000001, 193.68061852941176`}, {
     0.7150000000000001, 195.}}], 
    LineBox[{{0.7200000000000001, 193.68061852941176`}, {0.7200000000000001, 
     195.}}], LineBox[{{0.7250000000000001, 192.36123705882352`}, {
     0.7250000000000001, 195.}}], 
    LineBox[{{0.7300000000000001, 193.68061852941176`}, {0.7300000000000001, 
     195.}}], LineBox[{{0.7350000000000001, 193.68061852941176`}, {
     0.7350000000000001, 195.}}], 
    LineBox[{{0.7400000000000001, 193.68061852941176`}, {0.7400000000000001, 
     195.}}], LineBox[{{0.7450000000000001, 193.68061852941176`}, {
     0.7450000000000001, 195.}}], 
    LineBox[{{0.75, 192.36123705882352`}, {0.75, 195.}}], 
    LineBox[{{0.755, 193.68061852941176`}, {0.755, 195.}}], 
    LineBox[{{0.76, 193.68061852941176`}, {0.76, 195.}}], 
    LineBox[{{0.765, 193.68061852941176`}, {0.765, 195.}}], 
    LineBox[{{0.77, 193.68061852941176`}, {0.77, 195.}}], 
    LineBox[{{0.775, 192.36123705882352`}, {0.775, 195.}}], 
    LineBox[{{0.78, 193.68061852941176`}, {0.78, 195.}}], 
    LineBox[{{0.785, 193.68061852941176`}, {0.785, 195.}}], 
    LineBox[{{0.79, 193.68061852941176`}, {0.79, 195.}}], 
    LineBox[{{0.795, 193.68061852941176`}, {0.795, 195.}}], 
    LineBox[{{0.8, 192.36123705882352`}, {0.8, 195.}}], 
    LineBox[{{0.805, 193.68061852941176`}, {0.805, 195.}}], 
    LineBox[{{0.81, 193.68061852941176`}, {0.81, 195.}}], 
    LineBox[{{0.8150000000000001, 193.68061852941176`}, {0.8150000000000001, 
     195.}}], LineBox[{{0.8200000000000001, 193.68061852941176`}, {
     0.8200000000000001, 195.}}], 
    LineBox[{{0.8250000000000001, 192.36123705882352`}, {0.8250000000000001, 
     195.}}], LineBox[{{0.8300000000000001, 193.68061852941176`}, {
     0.8300000000000001, 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.832520325203252, 132.90849673202615`}, {0.832520325203252, 
     195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.827644350203252, 134.}, {0.832520325203252, 134.}}], 
    LineBox[{{0.827644350203252, 136.}, {0.832520325203252, 136.}}], 
    LineBox[{{0.827644350203252, 138.}, {0.832520325203252, 138.}}], 
    LineBox[{{0.8227683752032521, 140.}, {0.832520325203252, 140.}}], 
    LineBox[{{0.827644350203252, 142.}, {0.832520325203252, 142.}}], 
    LineBox[{{0.827644350203252, 144.}, {0.832520325203252, 144.}}], 
    LineBox[{{0.827644350203252, 146.}, {0.832520325203252, 146.}}], 
    LineBox[{{0.827644350203252, 148.}, {0.832520325203252, 148.}}], 
    LineBox[{{0.8227683752032521, 150.}, {0.832520325203252, 150.}}], 
    LineBox[{{0.827644350203252, 152.}, {0.832520325203252, 152.}}], 
    LineBox[{{0.827644350203252, 154.}, {0.832520325203252, 154.}}], 
    LineBox[{{0.827644350203252, 156.}, {0.832520325203252, 156.}}], 
    LineBox[{{0.827644350203252, 158.}, {0.832520325203252, 158.}}], 
    LineBox[{{0.8227683752032521, 160.}, {0.832520325203252, 160.}}], 
    LineBox[{{0.827644350203252, 162.}, {0.832520325203252, 162.}}], 
    LineBox[{{0.827644350203252, 164.}, {0.832520325203252, 164.}}], 
    LineBox[{{0.827644350203252, 166.}, {0.832520325203252, 166.}}], 
    LineBox[{{0.827644350203252, 168.}, {0.832520325203252, 168.}}], 
    LineBox[{{0.8227683752032521, 170.}, {0.832520325203252, 170.}}], 
    LineBox[{{0.827644350203252, 172.}, {0.832520325203252, 172.}}], 
    LineBox[{{0.827644350203252, 174.}, {0.832520325203252, 174.}}], 
    LineBox[{{0.827644350203252, 176.}, {0.832520325203252, 176.}}], 
    LineBox[{{0.827644350203252, 178.}, {0.832520325203252, 178.}}], 
    LineBox[{{0.8227683752032521, 180.}, {0.832520325203252, 180.}}], 
    LineBox[{{0.827644350203252, 182.}, {0.832520325203252, 182.}}], 
    LineBox[{{0.827644350203252, 184.}, {0.832520325203252, 184.}}], 
    LineBox[{{0.827644350203252, 186.}, {0.832520325203252, 186.}}], 
    LineBox[{{0.827644350203252, 188.}, {0.832520325203252, 188.}}], 
    LineBox[{{0.8227683752032521, 190.}, {0.832520325203252, 190.}}], 
    LineBox[{{0.827644350203252, 192.}, {0.832520325203252, 192.}}], 
    LineBox[{{0.827644350203252, 194.}, {0.832520325203252, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 132.90849673202615`}, {1., 
     132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8400000000000001, 134.2278782026144}, {0.8400000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.8450000000000001, 134.2278782026144}, {0.8450000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.8500000000000001, 135.54725967320263`}, {0.8500000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.8550000000000001, 134.2278782026144}, {0.8550000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.8600000000000001, 134.2278782026144}, {0.8600000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.865, 134.2278782026144}, {0.865, 132.90849673202615`}}], 
    LineBox[{{0.87, 134.2278782026144}, {0.87, 132.90849673202615`}}], 
    LineBox[{{0.875, 135.54725967320263`}, {0.875, 132.90849673202615`}}], 
    LineBox[{{0.88, 134.2278782026144}, {0.88, 132.90849673202615`}}], 
    LineBox[{{0.885, 134.2278782026144}, {0.885, 132.90849673202615`}}], 
    LineBox[{{0.8899999999999999, 134.2278782026144}, {0.8899999999999999, 
     132.90849673202615`}}], 
    LineBox[{{0.8949999999999999, 134.2278782026144}, {0.8949999999999999, 
     132.90849673202615`}}], 
    LineBox[{{0.9, 135.54725967320263`}, {0.9, 132.90849673202615`}}], 
    LineBox[{{0.905, 134.2278782026144}, {0.905, 132.90849673202615`}}], 
    LineBox[{{0.91, 134.2278782026144}, {0.91, 132.90849673202615`}}], 
    LineBox[{{0.9149999999999999, 134.2278782026144}, {0.9149999999999999, 
     132.90849673202615`}}], 
    LineBox[{{0.9199999999999999, 134.2278782026144}, {0.9199999999999999, 
     132.90849673202615`}}], 
    LineBox[{{0.925, 135.54725967320263`}, {0.925, 132.90849673202615`}}], 
    LineBox[{{0.93, 134.2278782026144}, {0.93, 132.90849673202615`}}], 
    LineBox[{{0.935, 134.2278782026144}, {0.935, 132.90849673202615`}}], 
    LineBox[{{0.94, 134.2278782026144}, {0.94, 132.90849673202615`}}], 
    LineBox[{{0.945, 134.2278782026144}, {0.945, 132.90849673202615`}}], 
    LineBox[{{0.9500000000000001, 135.54725967320263`}, {0.9500000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.9550000000000001, 134.2278782026144}, {0.9550000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.9600000000000001, 134.2278782026144}, {0.9600000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.965, 134.2278782026144}, {0.965, 132.90849673202615`}}], 
    LineBox[{{0.97, 134.2278782026144}, {0.97, 132.90849673202615`}}], 
    LineBox[{{0.9750000000000001, 135.54725967320263`}, {0.9750000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.9800000000000001, 134.2278782026144}, {0.9800000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.9850000000000001, 134.2278782026144}, {0.9850000000000001, 
     132.90849673202615`}}], 
    LineBox[{{0.99, 134.2278782026144}, {0.99, 132.90849673202615`}}], 
    LineBox[{{0.995, 134.2278782026144}, {0.995, 132.90849673202615`}}], 
    LineBox[{{1., 135.54725967320263`}, {1., 132.90849673202615`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 132.90849673202615`}, {0.8373983739837398, 
     195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8422743489837399, 134.}, {0.8373983739837398, 134.}}], 
    LineBox[{{0.8422743489837399, 136.}, {0.8373983739837398, 136.}}], 
    LineBox[{{0.8422743489837399, 138.}, {0.8373983739837398, 138.}}], 
    LineBox[{{0.8471503239837398, 140.}, {0.8373983739837398, 140.}}], 
    LineBox[{{0.8422743489837399, 142.}, {0.8373983739837398, 142.}}], 
    LineBox[{{0.8422743489837399, 144.}, {0.8373983739837398, 144.}}], 
    LineBox[{{0.8422743489837399, 146.}, {0.8373983739837398, 146.}}], 
    LineBox[{{0.8422743489837399, 148.}, {0.8373983739837398, 148.}}], 
    LineBox[{{0.8471503239837398, 150.}, {0.8373983739837398, 150.}}], 
    LineBox[{{0.8422743489837399, 152.}, {0.8373983739837398, 152.}}], 
    LineBox[{{0.8422743489837399, 154.}, {0.8373983739837398, 154.}}], 
    LineBox[{{0.8422743489837399, 156.}, {0.8373983739837398, 156.}}], 
    LineBox[{{0.8422743489837399, 158.}, {0.8373983739837398, 158.}}], 
    LineBox[{{0.8471503239837398, 160.}, {0.8373983739837398, 160.}}], 
    LineBox[{{0.8422743489837399, 162.}, {0.8373983739837398, 162.}}], 
    LineBox[{{0.8422743489837399, 164.}, {0.8373983739837398, 164.}}], 
    LineBox[{{0.8422743489837399, 166.}, {0.8373983739837398, 166.}}], 
    LineBox[{{0.8422743489837399, 168.}, {0.8373983739837398, 168.}}], 
    LineBox[{{0.8471503239837398, 170.}, {0.8373983739837398, 170.}}], 
    LineBox[{{0.8422743489837399, 172.}, {0.8373983739837398, 172.}}], 
    LineBox[{{0.8422743489837399, 174.}, {0.8373983739837398, 174.}}], 
    LineBox[{{0.8422743489837399, 176.}, {0.8373983739837398, 176.}}], 
    LineBox[{{0.8422743489837399, 178.}, {0.8373983739837398, 178.}}], 
    LineBox[{{0.8471503239837398, 180.}, {0.8373983739837398, 180.}}], 
    LineBox[{{0.8422743489837399, 182.}, {0.8373983739837398, 182.}}], 
    LineBox[{{0.8422743489837399, 184.}, {0.8373983739837398, 184.}}], 
    LineBox[{{0.8422743489837399, 186.}, {0.8373983739837398, 186.}}], 
    LineBox[{{0.8422743489837399, 188.}, {0.8373983739837398, 188.}}], 
    LineBox[{{0.8471503239837398, 190.}, {0.8373983739837398, 190.}}], 
    LineBox[{{0.8422743489837399, 192.}, {0.8373983739837398, 192.}}], 
    LineBox[{{0.8422743489837399, 194.}, {0.8373983739837398, 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 195.}, {1., 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8400000000000001, 193.68061852941176`}, {0.8400000000000001, 
     195.}}], LineBox[{{0.8450000000000001, 193.68061852941176`}, {
     0.8450000000000001, 195.}}], 
    LineBox[{{0.8500000000000001, 192.36123705882352`}, {0.8500000000000001, 
     195.}}], LineBox[{{0.8550000000000001, 193.68061852941176`}, {
     0.8550000000000001, 195.}}], 
    LineBox[{{0.8600000000000001, 193.68061852941176`}, {0.8600000000000001, 
     195.}}], LineBox[{{0.865, 193.68061852941176`}, {0.865, 195.}}], 
    LineBox[{{0.87, 193.68061852941176`}, {0.87, 195.}}], 
    LineBox[{{0.875, 192.36123705882352`}, {0.875, 195.}}], 
    LineBox[{{0.88, 193.68061852941176`}, {0.88, 195.}}], 
    LineBox[{{0.885, 193.68061852941176`}, {0.885, 195.}}], 
    LineBox[{{0.8899999999999999, 193.68061852941176`}, {0.8899999999999999, 
     195.}}], LineBox[{{0.8949999999999999, 193.68061852941176`}, {
     0.8949999999999999, 195.}}], 
    LineBox[{{0.9, 192.36123705882352`}, {0.9, 195.}}], 
    LineBox[{{0.905, 193.68061852941176`}, {0.905, 195.}}], 
    LineBox[{{0.91, 193.68061852941176`}, {0.91, 195.}}], 
    LineBox[{{0.9149999999999999, 193.68061852941176`}, {0.9149999999999999, 
     195.}}], LineBox[{{0.9199999999999999, 193.68061852941176`}, {
     0.9199999999999999, 195.}}], 
    LineBox[{{0.925, 192.36123705882352`}, {0.925, 195.}}], 
    LineBox[{{0.93, 193.68061852941176`}, {0.93, 195.}}], 
    LineBox[{{0.935, 193.68061852941176`}, {0.935, 195.}}], 
    LineBox[{{0.94, 193.68061852941176`}, {0.94, 195.}}], 
    LineBox[{{0.945, 193.68061852941176`}, {0.945, 195.}}], 
    LineBox[{{0.9500000000000001, 192.36123705882352`}, {0.9500000000000001, 
     195.}}], LineBox[{{0.9550000000000001, 193.68061852941176`}, {
     0.9550000000000001, 195.}}], 
    LineBox[{{0.9600000000000001, 193.68061852941176`}, {0.9600000000000001, 
     195.}}], LineBox[{{0.965, 193.68061852941176`}, {0.965, 195.}}], 
    LineBox[{{0.97, 193.68061852941176`}, {0.97, 195.}}], 
    LineBox[{{0.9750000000000001, 192.36123705882352`}, {0.9750000000000001, 
     195.}}], LineBox[{{0.9800000000000001, 193.68061852941176`}, {
     0.9800000000000001, 195.}}], 
    LineBox[{{0.9850000000000001, 193.68061852941176`}, {0.9850000000000001, 
     195.}}], LineBox[{{0.99, 193.68061852941176`}, {0.99, 195.}}], 
    LineBox[{{0.995, 193.68061852941176`}, {0.995, 195.}}], 
    LineBox[{{1., 192.36123705882352`}, {1., 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{1., 132.90849673202615`}, {1., 195.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], LineBox[{{0.995124025, 134.}, {1., 134.}}], 
    LineBox[{{0.995124025, 136.}, {1., 136.}}], 
    LineBox[{{0.995124025, 138.}, {1., 138.}}], 
    LineBox[{{0.99024805, 140.}, {1., 140.}}], 
    LineBox[{{0.995124025, 142.}, {1., 142.}}], 
    LineBox[{{0.995124025, 144.}, {1., 144.}}], 
    LineBox[{{0.995124025, 146.}, {1., 146.}}], 
    LineBox[{{0.995124025, 148.}, {1., 148.}}], 
    LineBox[{{0.99024805, 150.}, {1., 150.}}], 
    LineBox[{{0.995124025, 152.}, {1., 152.}}], 
    LineBox[{{0.995124025, 154.}, {1., 154.}}], 
    LineBox[{{0.995124025, 156.}, {1., 156.}}], 
    LineBox[{{0.995124025, 158.}, {1., 158.}}], 
    LineBox[{{0.99024805, 160.}, {1., 160.}}], 
    LineBox[{{0.995124025, 162.}, {1., 162.}}], 
    LineBox[{{0.995124025, 164.}, {1., 164.}}], 
    LineBox[{{0.995124025, 166.}, {1., 166.}}], 
    LineBox[{{0.995124025, 168.}, {1., 168.}}], 
    LineBox[{{0.99024805, 170.}, {1., 170.}}], 
    LineBox[{{0.995124025, 172.}, {1., 172.}}], 
    LineBox[{{0.995124025, 174.}, {1., 174.}}], 
    LineBox[{{0.995124025, 176.}, {1., 176.}}], 
    LineBox[{{0.995124025, 178.}, {1., 178.}}], 
    LineBox[{{0.99024805, 180.}, {1., 180.}}], 
    LineBox[{{0.995124025, 182.}, {1., 182.}}], 
    LineBox[{{0.995124025, 184.}, {1., 184.}}], 
    LineBox[{{0.995124025, 186.}, {1., 186.}}], 
    LineBox[{{0.995124025, 188.}, {1., 188.}}], 
    LineBox[{{0.99024805, 190.}, {1., 190.}}], 
    LineBox[{{0.995124025, 192.}, {1., 192.}}], 
    LineBox[{{0.995124025, 194.}, {1., 194.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 68.95424836601308}, {0.16260162601626016`, 
     68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 71.59301130718954}, {0., 68.95424836601308}}], 
    LineBox[{{0.005000000000000001, 70.27362983660132}, {0.005000000000000001,
      68.95424836601308}}], 
    LineBox[{{0.010000000000000002`, 70.27362983660132}, {
     0.010000000000000002`, 68.95424836601308}}], 
    LineBox[{{0.015000000000000003`, 70.27362983660132}, {
     0.015000000000000003`, 68.95424836601308}}], 
    LineBox[{{0.020000000000000004`, 70.27362983660132}, {
     0.020000000000000004`, 68.95424836601308}}], 
    LineBox[{{0.025, 71.59301130718954}, {0.025, 68.95424836601308}}], 
    LineBox[{{0.030000000000000002`, 70.27362983660132}, {
     0.030000000000000002`, 68.95424836601308}}], 
    LineBox[{{0.035, 70.27362983660132}, {0.035, 68.95424836601308}}], 
    LineBox[{{0.04000000000000001, 70.27362983660132}, {0.04000000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.045000000000000005`, 70.27362983660132}, {
     0.045000000000000005`, 68.95424836601308}}], 
    LineBox[{{0.05, 71.59301130718954}, {0.05, 68.95424836601308}}], 
    LineBox[{{0.05500000000000001, 70.27362983660132}, {0.05500000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.060000000000000005`, 70.27362983660132}, {
     0.060000000000000005`, 68.95424836601308}}], 
    LineBox[{{0.065, 70.27362983660132}, {0.065, 68.95424836601308}}], 
    LineBox[{{0.07, 70.27362983660132}, {0.07, 68.95424836601308}}], 
    LineBox[{{0.07500000000000001, 71.59301130718954}, {0.07500000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.08000000000000002, 70.27362983660132}, {0.08000000000000002, 
     68.95424836601308}}], 
    LineBox[{{0.08500000000000002, 70.27362983660132}, {0.08500000000000002, 
     68.95424836601308}}], 
    LineBox[{{0.09000000000000001, 70.27362983660132}, {0.09000000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.09500000000000001, 70.27362983660132}, {0.09500000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.1, 71.59301130718954}, {0.1, 68.95424836601308}}], 
    LineBox[{{0.10500000000000001`, 70.27362983660132}, {0.10500000000000001`,
      68.95424836601308}}], 
    LineBox[{{0.11000000000000001`, 70.27362983660132}, {0.11000000000000001`,
      68.95424836601308}}], 
    LineBox[{{0.115, 70.27362983660132}, {0.115, 68.95424836601308}}], 
    LineBox[{{0.12000000000000001`, 70.27362983660132}, {0.12000000000000001`,
      68.95424836601308}}], 
    LineBox[{{0.125, 71.59301130718954}, {0.125, 68.95424836601308}}], 
    LineBox[{{0.13, 70.27362983660132}, {0.13, 68.95424836601308}}], 
    LineBox[{{0.135, 70.27362983660132}, {0.135, 68.95424836601308}}], 
    LineBox[{{0.14, 70.27362983660132}, {0.14, 68.95424836601308}}], 
    LineBox[{{0.14500000000000002`, 70.27362983660132}, {0.14500000000000002`,
      68.95424836601308}}], 
    LineBox[{{0.15000000000000002`, 71.59301130718954}, {0.15000000000000002`,
      68.95424836601308}}], 
    LineBox[{{0.15500000000000003`, 70.27362983660132}, {0.15500000000000003`,
      68.95424836601308}}], 
    LineBox[{{0.16000000000000003`, 70.27362983660132}, {0.16000000000000003`,
      68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 68.95424836601308}, {0., 131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.009751950000000002, 70.}, {0., 70.}}], 
    LineBox[{{0.004875975000000001, 72.}, {0., 72.}}], 
    LineBox[{{0.004875975000000001, 74.}, {0., 74.}}], 
    LineBox[{{0.004875975000000001, 76.}, {0., 76.}}], 
    LineBox[{{0.004875975000000001, 78.}, {0., 78.}}], 
    LineBox[{{0.009751950000000002, 80.}, {0., 80.}}], 
    LineBox[{{0.004875975000000001, 82.}, {0., 82.}}], 
    LineBox[{{0.004875975000000001, 84.}, {0., 84.}}], 
    LineBox[{{0.004875975000000001, 86.}, {0., 86.}}], 
    LineBox[{{0.004875975000000001, 88.}, {0., 88.}}], 
    LineBox[{{0.009751950000000002, 90.}, {0., 90.}}], 
    LineBox[{{0.004875975000000001, 92.}, {0., 92.}}], 
    LineBox[{{0.004875975000000001, 94.}, {0., 94.}}], 
    LineBox[{{0.004875975000000001, 96.}, {0., 96.}}], 
    LineBox[{{0.004875975000000001, 98.}, {0., 98.}}], 
    LineBox[{{0.009751950000000002, 100.}, {0., 100.}}], 
    LineBox[{{0.004875975000000001, 102.}, {0., 102.}}], 
    LineBox[{{0.004875975000000001, 104.}, {0., 104.}}], 
    LineBox[{{0.004875975000000001, 106.}, {0., 106.}}], 
    LineBox[{{0.004875975000000001, 108.}, {0., 108.}}], 
    LineBox[{{0.009751950000000002, 110.}, {0., 110.}}], 
    LineBox[{{0.004875975000000001, 112.}, {0., 112.}}], 
    LineBox[{{0.004875975000000001, 114.}, {0., 114.}}], 
    LineBox[{{0.004875975000000001, 116.}, {0., 116.}}], 
    LineBox[{{0.004875975000000001, 118.}, {0., 118.}}], 
    LineBox[{{0.009751950000000002, 120.}, {0., 120.}}], 
    LineBox[{{0.004875975000000001, 122.}, {0., 122.}}], 
    LineBox[{{0.004875975000000001, 124.}, {0., 124.}}], 
    LineBox[{{0.004875975000000001, 126.}, {0., 126.}}], 
    LineBox[{{0.004875975000000001, 128.}, {0., 128.}}], 
    LineBox[{{0.009751950000000002, 130.}, {0., 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 131.04575163398692`}, {0.16260162601626016`, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 128.40698869281044`}, {0., 131.04575163398692`}}], 
    LineBox[{{0.005000000000000001, 129.72637016339868`}, {
     0.005000000000000001, 131.04575163398692`}}], 
    LineBox[{{0.010000000000000002`, 129.72637016339868`}, {
     0.010000000000000002`, 131.04575163398692`}}], 
    LineBox[{{0.015000000000000003`, 129.72637016339868`}, {
     0.015000000000000003`, 131.04575163398692`}}], 
    LineBox[{{0.020000000000000004`, 129.72637016339868`}, {
     0.020000000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.025, 128.40698869281044`}, {0.025, 131.04575163398692`}}], 
    LineBox[{{0.030000000000000002`, 129.72637016339868`}, {
     0.030000000000000002`, 131.04575163398692`}}], 
    LineBox[{{0.035, 129.72637016339868`}, {0.035, 131.04575163398692`}}], 
    LineBox[{{0.04000000000000001, 129.72637016339868`}, {0.04000000000000001,
      131.04575163398692`}}], 
    LineBox[{{0.045000000000000005`, 129.72637016339868`}, {
     0.045000000000000005`, 131.04575163398692`}}], 
    LineBox[{{0.05, 128.40698869281044`}, {0.05, 131.04575163398692`}}], 
    LineBox[{{0.05500000000000001, 129.72637016339868`}, {0.05500000000000001,
      131.04575163398692`}}], 
    LineBox[{{0.060000000000000005`, 129.72637016339868`}, {
     0.060000000000000005`, 131.04575163398692`}}], 
    LineBox[{{0.065, 129.72637016339868`}, {0.065, 131.04575163398692`}}], 
    LineBox[{{0.07, 129.72637016339868`}, {0.07, 131.04575163398692`}}], 
    LineBox[{{0.07500000000000001, 128.40698869281044`}, {0.07500000000000001,
      131.04575163398692`}}], 
    LineBox[{{0.08000000000000002, 129.72637016339868`}, {0.08000000000000002,
      131.04575163398692`}}], 
    LineBox[{{0.08500000000000002, 129.72637016339868`}, {0.08500000000000002,
      131.04575163398692`}}], 
    LineBox[{{0.09000000000000001, 129.72637016339868`}, {0.09000000000000001,
      131.04575163398692`}}], 
    LineBox[{{0.09500000000000001, 129.72637016339868`}, {0.09500000000000001,
      131.04575163398692`}}], 
    LineBox[{{0.1, 128.40698869281044`}, {0.1, 131.04575163398692`}}], 
    LineBox[{{0.10500000000000001`, 129.72637016339868`}, {
     0.10500000000000001`, 131.04575163398692`}}], 
    LineBox[{{0.11000000000000001`, 129.72637016339868`}, {
     0.11000000000000001`, 131.04575163398692`}}], 
    LineBox[{{0.115, 129.72637016339868`}, {0.115, 131.04575163398692`}}], 
    LineBox[{{0.12000000000000001`, 129.72637016339868`}, {
     0.12000000000000001`, 131.04575163398692`}}], 
    LineBox[{{0.125, 128.40698869281044`}, {0.125, 131.04575163398692`}}], 
    LineBox[{{0.13, 129.72637016339868`}, {0.13, 131.04575163398692`}}], 
    LineBox[{{0.135, 129.72637016339868`}, {0.135, 131.04575163398692`}}], 
    LineBox[{{0.14, 129.72637016339868`}, {0.14, 131.04575163398692`}}], 
    LineBox[{{0.14500000000000002`, 129.72637016339868`}, {
     0.14500000000000002`, 131.04575163398692`}}], 
    LineBox[{{0.15000000000000002`, 128.40698869281044`}, {
     0.15000000000000002`, 131.04575163398692`}}], 
    LineBox[{{0.15500000000000003`, 129.72637016339868`}, {
     0.15500000000000003`, 131.04575163398692`}}], 
    LineBox[{{0.16000000000000003`, 129.72637016339868`}, {
     0.16000000000000003`, 131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16260162601626016`, 68.95424836601308}, {0.16260162601626016`,
      131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.15284967601626015`, 70.}, {0.16260162601626016`, 70.}}], 
    LineBox[{{0.15772565101626015`, 72.}, {0.16260162601626016`, 72.}}], 
    LineBox[{{0.15772565101626015`, 74.}, {0.16260162601626016`, 74.}}], 
    LineBox[{{0.15772565101626015`, 76.}, {0.16260162601626016`, 76.}}], 
    LineBox[{{0.15772565101626015`, 78.}, {0.16260162601626016`, 78.}}], 
    LineBox[{{0.15284967601626015`, 80.}, {0.16260162601626016`, 80.}}], 
    LineBox[{{0.15772565101626015`, 82.}, {0.16260162601626016`, 82.}}], 
    LineBox[{{0.15772565101626015`, 84.}, {0.16260162601626016`, 84.}}], 
    LineBox[{{0.15772565101626015`, 86.}, {0.16260162601626016`, 86.}}], 
    LineBox[{{0.15772565101626015`, 88.}, {0.16260162601626016`, 88.}}], 
    LineBox[{{0.15284967601626015`, 90.}, {0.16260162601626016`, 90.}}], 
    LineBox[{{0.15772565101626015`, 92.}, {0.16260162601626016`, 92.}}], 
    LineBox[{{0.15772565101626015`, 94.}, {0.16260162601626016`, 94.}}], 
    LineBox[{{0.15772565101626015`, 96.}, {0.16260162601626016`, 96.}}], 
    LineBox[{{0.15772565101626015`, 98.}, {0.16260162601626016`, 98.}}], 
    LineBox[{{0.15284967601626015`, 100.}, {0.16260162601626016`, 100.}}], 
    LineBox[{{0.15772565101626015`, 102.}, {0.16260162601626016`, 102.}}], 
    LineBox[{{0.15772565101626015`, 104.}, {0.16260162601626016`, 104.}}], 
    LineBox[{{0.15772565101626015`, 106.}, {0.16260162601626016`, 106.}}], 
    LineBox[{{0.15772565101626015`, 108.}, {0.16260162601626016`, 108.}}], 
    LineBox[{{0.15284967601626015`, 110.}, {0.16260162601626016`, 110.}}], 
    LineBox[{{0.15772565101626015`, 112.}, {0.16260162601626016`, 112.}}], 
    LineBox[{{0.15772565101626015`, 114.}, {0.16260162601626016`, 114.}}], 
    LineBox[{{0.15772565101626015`, 116.}, {0.16260162601626016`, 116.}}], 
    LineBox[{{0.15772565101626015`, 118.}, {0.16260162601626016`, 118.}}], 
    LineBox[{{0.15284967601626015`, 120.}, {0.16260162601626016`, 120.}}], 
    LineBox[{{0.15772565101626015`, 122.}, {0.16260162601626016`, 122.}}], 
    LineBox[{{0.15772565101626015`, 124.}, {0.16260162601626016`, 124.}}], 
    LineBox[{{0.15772565101626015`, 126.}, {0.16260162601626016`, 126.}}], 
    LineBox[{{0.15772565101626015`, 128.}, {0.16260162601626016`, 128.}}], 
    LineBox[{{0.15284967601626015`, 130.}, {0.16260162601626016`, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 68.95424836601308}, {0.3300813008130081, 
     68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17, 70.27362983660132}, {0.17, 68.95424836601308}}], 
    LineBox[{{0.17500000000000002`, 71.59301130718954}, {0.17500000000000002`,
      68.95424836601308}}], 
    LineBox[{{0.18000000000000002`, 70.27362983660132}, {0.18000000000000002`,
      68.95424836601308}}], 
    LineBox[{{0.18500000000000003`, 70.27362983660132}, {0.18500000000000003`,
      68.95424836601308}}], 
    LineBox[{{0.19, 70.27362983660132}, {0.19, 68.95424836601308}}], 
    LineBox[{{0.195, 70.27362983660132}, {0.195, 68.95424836601308}}], 
    LineBox[{{0.2, 71.59301130718954}, {0.2, 68.95424836601308}}], 
    LineBox[{{0.20500000000000002`, 70.27362983660132}, {0.20500000000000002`,
      68.95424836601308}}], 
    LineBox[{{0.21000000000000002`, 70.27362983660132}, {0.21000000000000002`,
      68.95424836601308}}], 
    LineBox[{{0.215, 70.27362983660132}, {0.215, 68.95424836601308}}], 
    LineBox[{{0.22, 70.27362983660132}, {0.22, 68.95424836601308}}], 
    LineBox[{{0.225, 71.59301130718954}, {0.225, 68.95424836601308}}], 
    LineBox[{{0.23, 70.27362983660132}, {0.23, 68.95424836601308}}], 
    LineBox[{{0.23500000000000001`, 70.27362983660132}, {0.23500000000000001`,
      68.95424836601308}}], 
    LineBox[{{0.24, 70.27362983660132}, {0.24, 68.95424836601308}}], 
    LineBox[{{0.245, 70.27362983660132}, {0.245, 68.95424836601308}}], 
    LineBox[{{0.25, 71.59301130718954}, {0.25, 68.95424836601308}}], 
    LineBox[{{0.255, 70.27362983660132}, {0.255, 68.95424836601308}}], 
    LineBox[{{0.26, 70.27362983660132}, {0.26, 68.95424836601308}}], 
    LineBox[{{0.265, 70.27362983660132}, {0.265, 68.95424836601308}}], 
    LineBox[{{0.27, 70.27362983660132}, {0.27, 68.95424836601308}}], 
    LineBox[{{0.275, 71.59301130718954}, {0.275, 68.95424836601308}}], 
    LineBox[{{0.28, 70.27362983660132}, {0.28, 68.95424836601308}}], 
    LineBox[{{0.28500000000000003`, 70.27362983660132}, {0.28500000000000003`,
      68.95424836601308}}], 
    LineBox[{{0.29000000000000004`, 70.27362983660132}, {0.29000000000000004`,
      68.95424836601308}}], 
    LineBox[{{0.29500000000000004`, 70.27362983660132}, {0.29500000000000004`,
      68.95424836601308}}], 
    LineBox[{{0.30000000000000004`, 71.59301130718954}, {0.30000000000000004`,
      68.95424836601308}}], 
    LineBox[{{0.30500000000000005`, 70.27362983660132}, {0.30500000000000005`,
      68.95424836601308}}], 
    LineBox[{{0.31000000000000005`, 70.27362983660132}, {0.31000000000000005`,
      68.95424836601308}}], 
    LineBox[{{0.31500000000000006`, 70.27362983660132}, {0.31500000000000006`,
      68.95424836601308}}], 
    LineBox[{{0.32000000000000006`, 70.27362983660132}, {0.32000000000000006`,
      68.95424836601308}}], 
    LineBox[{{0.325, 71.59301130718954}, {0.325, 68.95424836601308}}], 
    LineBox[{{0.33, 70.27362983660132}, {0.33, 68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 68.95424836601308}, {0.16747967479674797`,
      131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17723162479674798`, 70.}, {0.16747967479674797`, 70.}}], 
    LineBox[{{0.17235564979674797`, 72.}, {0.16747967479674797`, 72.}}], 
    LineBox[{{0.17235564979674797`, 74.}, {0.16747967479674797`, 74.}}], 
    LineBox[{{0.17235564979674797`, 76.}, {0.16747967479674797`, 76.}}], 
    LineBox[{{0.17235564979674797`, 78.}, {0.16747967479674797`, 78.}}], 
    LineBox[{{0.17723162479674798`, 80.}, {0.16747967479674797`, 80.}}], 
    LineBox[{{0.17235564979674797`, 82.}, {0.16747967479674797`, 82.}}], 
    LineBox[{{0.17235564979674797`, 84.}, {0.16747967479674797`, 84.}}], 
    LineBox[{{0.17235564979674797`, 86.}, {0.16747967479674797`, 86.}}], 
    LineBox[{{0.17235564979674797`, 88.}, {0.16747967479674797`, 88.}}], 
    LineBox[{{0.17723162479674798`, 90.}, {0.16747967479674797`, 90.}}], 
    LineBox[{{0.17235564979674797`, 92.}, {0.16747967479674797`, 92.}}], 
    LineBox[{{0.17235564979674797`, 94.}, {0.16747967479674797`, 94.}}], 
    LineBox[{{0.17235564979674797`, 96.}, {0.16747967479674797`, 96.}}], 
    LineBox[{{0.17235564979674797`, 98.}, {0.16747967479674797`, 98.}}], 
    LineBox[{{0.17723162479674798`, 100.}, {0.16747967479674797`, 100.}}], 
    LineBox[{{0.17235564979674797`, 102.}, {0.16747967479674797`, 102.}}], 
    LineBox[{{0.17235564979674797`, 104.}, {0.16747967479674797`, 104.}}], 
    LineBox[{{0.17235564979674797`, 106.}, {0.16747967479674797`, 106.}}], 
    LineBox[{{0.17235564979674797`, 108.}, {0.16747967479674797`, 108.}}], 
    LineBox[{{0.17723162479674798`, 110.}, {0.16747967479674797`, 110.}}], 
    LineBox[{{0.17235564979674797`, 112.}, {0.16747967479674797`, 112.}}], 
    LineBox[{{0.17235564979674797`, 114.}, {0.16747967479674797`, 114.}}], 
    LineBox[{{0.17235564979674797`, 116.}, {0.16747967479674797`, 116.}}], 
    LineBox[{{0.17235564979674797`, 118.}, {0.16747967479674797`, 118.}}], 
    LineBox[{{0.17723162479674798`, 120.}, {0.16747967479674797`, 120.}}], 
    LineBox[{{0.17235564979674797`, 122.}, {0.16747967479674797`, 122.}}], 
    LineBox[{{0.17235564979674797`, 124.}, {0.16747967479674797`, 124.}}], 
    LineBox[{{0.17235564979674797`, 126.}, {0.16747967479674797`, 126.}}], 
    LineBox[{{0.17235564979674797`, 128.}, {0.16747967479674797`, 128.}}], 
    LineBox[{{0.17723162479674798`, 130.}, {0.16747967479674797`, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 131.04575163398692`}, {0.3300813008130081,
      131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17, 129.72637016339868`}, {0.17, 131.04575163398692`}}], 
    LineBox[{{0.17500000000000002`, 128.40698869281044`}, {
     0.17500000000000002`, 131.04575163398692`}}], 
    LineBox[{{0.18000000000000002`, 129.72637016339868`}, {
     0.18000000000000002`, 131.04575163398692`}}], 
    LineBox[{{0.18500000000000003`, 129.72637016339868`}, {
     0.18500000000000003`, 131.04575163398692`}}], 
    LineBox[{{0.19, 129.72637016339868`}, {0.19, 131.04575163398692`}}], 
    LineBox[{{0.195, 129.72637016339868`}, {0.195, 131.04575163398692`}}], 
    LineBox[{{0.2, 128.40698869281044`}, {0.2, 131.04575163398692`}}], 
    LineBox[{{0.20500000000000002`, 129.72637016339868`}, {
     0.20500000000000002`, 131.04575163398692`}}], 
    LineBox[{{0.21000000000000002`, 129.72637016339868`}, {
     0.21000000000000002`, 131.04575163398692`}}], 
    LineBox[{{0.215, 129.72637016339868`}, {0.215, 131.04575163398692`}}], 
    LineBox[{{0.22, 129.72637016339868`}, {0.22, 131.04575163398692`}}], 
    LineBox[{{0.225, 128.40698869281044`}, {0.225, 131.04575163398692`}}], 
    LineBox[{{0.23, 129.72637016339868`}, {0.23, 131.04575163398692`}}], 
    LineBox[{{0.23500000000000001`, 129.72637016339868`}, {
     0.23500000000000001`, 131.04575163398692`}}], 
    LineBox[{{0.24, 129.72637016339868`}, {0.24, 131.04575163398692`}}], 
    LineBox[{{0.245, 129.72637016339868`}, {0.245, 131.04575163398692`}}], 
    LineBox[{{0.25, 128.40698869281044`}, {0.25, 131.04575163398692`}}], 
    LineBox[{{0.255, 129.72637016339868`}, {0.255, 131.04575163398692`}}], 
    LineBox[{{0.26, 129.72637016339868`}, {0.26, 131.04575163398692`}}], 
    LineBox[{{0.265, 129.72637016339868`}, {0.265, 131.04575163398692`}}], 
    LineBox[{{0.27, 129.72637016339868`}, {0.27, 131.04575163398692`}}], 
    LineBox[{{0.275, 128.40698869281044`}, {0.275, 131.04575163398692`}}], 
    LineBox[{{0.28, 129.72637016339868`}, {0.28, 131.04575163398692`}}], 
    LineBox[{{0.28500000000000003`, 129.72637016339868`}, {
     0.28500000000000003`, 131.04575163398692`}}], 
    LineBox[{{0.29000000000000004`, 129.72637016339868`}, {
     0.29000000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.29500000000000004`, 129.72637016339868`}, {
     0.29500000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.30000000000000004`, 128.40698869281044`}, {
     0.30000000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.30500000000000005`, 129.72637016339868`}, {
     0.30500000000000005`, 131.04575163398692`}}], 
    LineBox[{{0.31000000000000005`, 129.72637016339868`}, {
     0.31000000000000005`, 131.04575163398692`}}], 
    LineBox[{{0.31500000000000006`, 129.72637016339868`}, {
     0.31500000000000006`, 131.04575163398692`}}], 
    LineBox[{{0.32000000000000006`, 129.72637016339868`}, {
     0.32000000000000006`, 131.04575163398692`}}], 
    LineBox[{{0.325, 128.40698869281044`}, {0.325, 131.04575163398692`}}], 
    LineBox[{{0.33, 129.72637016339868`}, {0.33, 131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.3300813008130081, 68.95424836601308}, {0.3300813008130081, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.3203293508130081, 70.}, {0.3300813008130081, 70.}}], 
    LineBox[{{0.32520532581300815`, 72.}, {0.3300813008130081, 72.}}], 
    LineBox[{{0.32520532581300815`, 74.}, {0.3300813008130081, 74.}}], 
    LineBox[{{0.32520532581300815`, 76.}, {0.3300813008130081, 76.}}], 
    LineBox[{{0.32520532581300815`, 78.}, {0.3300813008130081, 78.}}], 
    LineBox[{{0.3203293508130081, 80.}, {0.3300813008130081, 80.}}], 
    LineBox[{{0.32520532581300815`, 82.}, {0.3300813008130081, 82.}}], 
    LineBox[{{0.32520532581300815`, 84.}, {0.3300813008130081, 84.}}], 
    LineBox[{{0.32520532581300815`, 86.}, {0.3300813008130081, 86.}}], 
    LineBox[{{0.32520532581300815`, 88.}, {0.3300813008130081, 88.}}], 
    LineBox[{{0.3203293508130081, 90.}, {0.3300813008130081, 90.}}], 
    LineBox[{{0.32520532581300815`, 92.}, {0.3300813008130081, 92.}}], 
    LineBox[{{0.32520532581300815`, 94.}, {0.3300813008130081, 94.}}], 
    LineBox[{{0.32520532581300815`, 96.}, {0.3300813008130081, 96.}}], 
    LineBox[{{0.32520532581300815`, 98.}, {0.3300813008130081, 98.}}], 
    LineBox[{{0.3203293508130081, 100.}, {0.3300813008130081, 100.}}], 
    LineBox[{{0.32520532581300815`, 102.}, {0.3300813008130081, 102.}}], 
    LineBox[{{0.32520532581300815`, 104.}, {0.3300813008130081, 104.}}], 
    LineBox[{{0.32520532581300815`, 106.}, {0.3300813008130081, 106.}}], 
    LineBox[{{0.32520532581300815`, 108.}, {0.3300813008130081, 108.}}], 
    LineBox[{{0.3203293508130081, 110.}, {0.3300813008130081, 110.}}], 
    LineBox[{{0.32520532581300815`, 112.}, {0.3300813008130081, 112.}}], 
    LineBox[{{0.32520532581300815`, 114.}, {0.3300813008130081, 114.}}], 
    LineBox[{{0.32520532581300815`, 116.}, {0.3300813008130081, 116.}}], 
    LineBox[{{0.32520532581300815`, 118.}, {0.3300813008130081, 118.}}], 
    LineBox[{{0.3203293508130081, 120.}, {0.3300813008130081, 120.}}], 
    LineBox[{{0.32520532581300815`, 122.}, {0.3300813008130081, 122.}}], 
    LineBox[{{0.32520532581300815`, 124.}, {0.3300813008130081, 124.}}], 
    LineBox[{{0.32520532581300815`, 126.}, {0.3300813008130081, 126.}}], 
    LineBox[{{0.32520532581300815`, 128.}, {0.3300813008130081, 128.}}], 
    LineBox[{{0.3203293508130081, 130.}, {0.3300813008130081, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 68.95424836601308}, {0.4975609756097561, 
     68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.335, 70.27362983660132}, {0.335, 68.95424836601308}}], 
    LineBox[{{0.34, 70.27362983660132}, {0.34, 68.95424836601308}}], 
    LineBox[{{0.34500000000000003`, 70.27362983660132}, {0.34500000000000003`,
      68.95424836601308}}], 
    LineBox[{{0.35000000000000003`, 71.59301130718954}, {0.35000000000000003`,
      68.95424836601308}}], 
    LineBox[{{0.35500000000000004`, 70.27362983660132}, {0.35500000000000004`,
      68.95424836601308}}], 
    LineBox[{{0.36000000000000004`, 70.27362983660132}, {0.36000000000000004`,
      68.95424836601308}}], 
    LineBox[{{0.365, 70.27362983660132}, {0.365, 68.95424836601308}}], 
    LineBox[{{0.37, 70.27362983660132}, {0.37, 68.95424836601308}}], 
    LineBox[{{0.375, 71.59301130718954}, {0.375, 68.95424836601308}}], 
    LineBox[{{0.38, 70.27362983660132}, {0.38, 68.95424836601308}}], 
    LineBox[{{0.385, 70.27362983660132}, {0.385, 68.95424836601308}}], 
    LineBox[{{0.38999999999999996`, 70.27362983660132}, {0.38999999999999996`,
      68.95424836601308}}], 
    LineBox[{{0.39499999999999996`, 70.27362983660132}, {0.39499999999999996`,
      68.95424836601308}}], 
    LineBox[{{0.4, 71.59301130718954}, {0.4, 68.95424836601308}}], 
    LineBox[{{0.405, 70.27362983660132}, {0.405, 68.95424836601308}}], 
    LineBox[{{0.41000000000000003`, 70.27362983660132}, {0.41000000000000003`,
      68.95424836601308}}], 
    LineBox[{{0.415, 70.27362983660132}, {0.415, 68.95424836601308}}], 
    LineBox[{{0.42, 70.27362983660132}, {0.42, 68.95424836601308}}], 
    LineBox[{{0.42500000000000004`, 71.59301130718954}, {0.42500000000000004`,
      68.95424836601308}}], 
    LineBox[{{0.43000000000000005`, 70.27362983660132}, {0.43000000000000005`,
      68.95424836601308}}], 
    LineBox[{{0.43500000000000005`, 70.27362983660132}, {0.43500000000000005`,
      68.95424836601308}}], 
    LineBox[{{0.44, 70.27362983660132}, {0.44, 68.95424836601308}}], 
    LineBox[{{0.445, 70.27362983660132}, {0.445, 68.95424836601308}}], 
    LineBox[{{0.45, 71.59301130718954}, {0.45, 68.95424836601308}}], 
    LineBox[{{0.455, 70.27362983660132}, {0.455, 68.95424836601308}}], 
    LineBox[{{0.46, 70.27362983660132}, {0.46, 68.95424836601308}}], 
    LineBox[{{0.46499999999999997`, 70.27362983660132}, {0.46499999999999997`,
      68.95424836601308}}], 
    LineBox[{{0.47, 70.27362983660132}, {0.47, 68.95424836601308}}], 
    LineBox[{{0.47500000000000003`, 71.59301130718954}, {0.47500000000000003`,
      68.95424836601308}}], 
    LineBox[{{0.48000000000000004`, 70.27362983660132}, {0.48000000000000004`,
      68.95424836601308}}], 
    LineBox[{{0.48500000000000004`, 70.27362983660132}, {0.48500000000000004`,
      68.95424836601308}}], 
    LineBox[{{0.49000000000000005`, 70.27362983660132}, {0.49000000000000005`,
      68.95424836601308}}], 
    LineBox[{{0.49500000000000005`, 70.27362983660132}, {0.49500000000000005`,
      68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 68.95424836601308}, {0.33495934959349594`,
      131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.34471129959349595`, 70.}, {0.33495934959349594`, 70.}}], 
    LineBox[{{0.3398353245934959, 72.}, {0.33495934959349594`, 72.}}], 
    LineBox[{{0.3398353245934959, 74.}, {0.33495934959349594`, 74.}}], 
    LineBox[{{0.3398353245934959, 76.}, {0.33495934959349594`, 76.}}], 
    LineBox[{{0.3398353245934959, 78.}, {0.33495934959349594`, 78.}}], 
    LineBox[{{0.34471129959349595`, 80.}, {0.33495934959349594`, 80.}}], 
    LineBox[{{0.3398353245934959, 82.}, {0.33495934959349594`, 82.}}], 
    LineBox[{{0.3398353245934959, 84.}, {0.33495934959349594`, 84.}}], 
    LineBox[{{0.3398353245934959, 86.}, {0.33495934959349594`, 86.}}], 
    LineBox[{{0.3398353245934959, 88.}, {0.33495934959349594`, 88.}}], 
    LineBox[{{0.34471129959349595`, 90.}, {0.33495934959349594`, 90.}}], 
    LineBox[{{0.3398353245934959, 92.}, {0.33495934959349594`, 92.}}], 
    LineBox[{{0.3398353245934959, 94.}, {0.33495934959349594`, 94.}}], 
    LineBox[{{0.3398353245934959, 96.}, {0.33495934959349594`, 96.}}], 
    LineBox[{{0.3398353245934959, 98.}, {0.33495934959349594`, 98.}}], 
    LineBox[{{0.34471129959349595`, 100.}, {0.33495934959349594`, 100.}}], 
    LineBox[{{0.3398353245934959, 102.}, {0.33495934959349594`, 102.}}], 
    LineBox[{{0.3398353245934959, 104.}, {0.33495934959349594`, 104.}}], 
    LineBox[{{0.3398353245934959, 106.}, {0.33495934959349594`, 106.}}], 
    LineBox[{{0.3398353245934959, 108.}, {0.33495934959349594`, 108.}}], 
    LineBox[{{0.34471129959349595`, 110.}, {0.33495934959349594`, 110.}}], 
    LineBox[{{0.3398353245934959, 112.}, {0.33495934959349594`, 112.}}], 
    LineBox[{{0.3398353245934959, 114.}, {0.33495934959349594`, 114.}}], 
    LineBox[{{0.3398353245934959, 116.}, {0.33495934959349594`, 116.}}], 
    LineBox[{{0.3398353245934959, 118.}, {0.33495934959349594`, 118.}}], 
    LineBox[{{0.34471129959349595`, 120.}, {0.33495934959349594`, 120.}}], 
    LineBox[{{0.3398353245934959, 122.}, {0.33495934959349594`, 122.}}], 
    LineBox[{{0.3398353245934959, 124.}, {0.33495934959349594`, 124.}}], 
    LineBox[{{0.3398353245934959, 126.}, {0.33495934959349594`, 126.}}], 
    LineBox[{{0.3398353245934959, 128.}, {0.33495934959349594`, 128.}}], 
    LineBox[{{0.34471129959349595`, 130.}, {0.33495934959349594`, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 131.04575163398692`}, {0.4975609756097561,
      131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.335, 129.72637016339868`}, {0.335, 131.04575163398692`}}], 
    LineBox[{{0.34, 129.72637016339868`}, {0.34, 131.04575163398692`}}], 
    LineBox[{{0.34500000000000003`, 129.72637016339868`}, {
     0.34500000000000003`, 131.04575163398692`}}], 
    LineBox[{{0.35000000000000003`, 128.40698869281044`}, {
     0.35000000000000003`, 131.04575163398692`}}], 
    LineBox[{{0.35500000000000004`, 129.72637016339868`}, {
     0.35500000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.36000000000000004`, 129.72637016339868`}, {
     0.36000000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.365, 129.72637016339868`}, {0.365, 131.04575163398692`}}], 
    LineBox[{{0.37, 129.72637016339868`}, {0.37, 131.04575163398692`}}], 
    LineBox[{{0.375, 128.40698869281044`}, {0.375, 131.04575163398692`}}], 
    LineBox[{{0.38, 129.72637016339868`}, {0.38, 131.04575163398692`}}], 
    LineBox[{{0.385, 129.72637016339868`}, {0.385, 131.04575163398692`}}], 
    LineBox[{{0.38999999999999996`, 129.72637016339868`}, {
     0.38999999999999996`, 131.04575163398692`}}], 
    LineBox[{{0.39499999999999996`, 129.72637016339868`}, {
     0.39499999999999996`, 131.04575163398692`}}], 
    LineBox[{{0.4, 128.40698869281044`}, {0.4, 131.04575163398692`}}], 
    LineBox[{{0.405, 129.72637016339868`}, {0.405, 131.04575163398692`}}], 
    LineBox[{{0.41000000000000003`, 129.72637016339868`}, {
     0.41000000000000003`, 131.04575163398692`}}], 
    LineBox[{{0.415, 129.72637016339868`}, {0.415, 131.04575163398692`}}], 
    LineBox[{{0.42, 129.72637016339868`}, {0.42, 131.04575163398692`}}], 
    LineBox[{{0.42500000000000004`, 128.40698869281044`}, {
     0.42500000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.43000000000000005`, 129.72637016339868`}, {
     0.43000000000000005`, 131.04575163398692`}}], 
    LineBox[{{0.43500000000000005`, 129.72637016339868`}, {
     0.43500000000000005`, 131.04575163398692`}}], 
    LineBox[{{0.44, 129.72637016339868`}, {0.44, 131.04575163398692`}}], 
    LineBox[{{0.445, 129.72637016339868`}, {0.445, 131.04575163398692`}}], 
    LineBox[{{0.45, 128.40698869281044`}, {0.45, 131.04575163398692`}}], 
    LineBox[{{0.455, 129.72637016339868`}, {0.455, 131.04575163398692`}}], 
    LineBox[{{0.46, 129.72637016339868`}, {0.46, 131.04575163398692`}}], 
    LineBox[{{0.46499999999999997`, 129.72637016339868`}, {
     0.46499999999999997`, 131.04575163398692`}}], 
    LineBox[{{0.47, 129.72637016339868`}, {0.47, 131.04575163398692`}}], 
    LineBox[{{0.47500000000000003`, 128.40698869281044`}, {
     0.47500000000000003`, 131.04575163398692`}}], 
    LineBox[{{0.48000000000000004`, 129.72637016339868`}, {
     0.48000000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.48500000000000004`, 129.72637016339868`}, {
     0.48500000000000004`, 131.04575163398692`}}], 
    LineBox[{{0.49000000000000005`, 129.72637016339868`}, {
     0.49000000000000005`, 131.04575163398692`}}], 
    LineBox[{{0.49500000000000005`, 129.72637016339868`}, {
     0.49500000000000005`, 131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.4975609756097561, 68.95424836601308}, {0.4975609756097561, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.4878090256097561, 70.}, {0.4975609756097561, 70.}}], 
    LineBox[{{0.4926850006097561, 72.}, {0.4975609756097561, 72.}}], 
    LineBox[{{0.4926850006097561, 74.}, {0.4975609756097561, 74.}}], 
    LineBox[{{0.4926850006097561, 76.}, {0.4975609756097561, 76.}}], 
    LineBox[{{0.4926850006097561, 78.}, {0.4975609756097561, 78.}}], 
    LineBox[{{0.4878090256097561, 80.}, {0.4975609756097561, 80.}}], 
    LineBox[{{0.4926850006097561, 82.}, {0.4975609756097561, 82.}}], 
    LineBox[{{0.4926850006097561, 84.}, {0.4975609756097561, 84.}}], 
    LineBox[{{0.4926850006097561, 86.}, {0.4975609756097561, 86.}}], 
    LineBox[{{0.4926850006097561, 88.}, {0.4975609756097561, 88.}}], 
    LineBox[{{0.4878090256097561, 90.}, {0.4975609756097561, 90.}}], 
    LineBox[{{0.4926850006097561, 92.}, {0.4975609756097561, 92.}}], 
    LineBox[{{0.4926850006097561, 94.}, {0.4975609756097561, 94.}}], 
    LineBox[{{0.4926850006097561, 96.}, {0.4975609756097561, 96.}}], 
    LineBox[{{0.4926850006097561, 98.}, {0.4975609756097561, 98.}}], 
    LineBox[{{0.4878090256097561, 100.}, {0.4975609756097561, 100.}}], 
    LineBox[{{0.4926850006097561, 102.}, {0.4975609756097561, 102.}}], 
    LineBox[{{0.4926850006097561, 104.}, {0.4975609756097561, 104.}}], 
    LineBox[{{0.4926850006097561, 106.}, {0.4975609756097561, 106.}}], 
    LineBox[{{0.4926850006097561, 108.}, {0.4975609756097561, 108.}}], 
    LineBox[{{0.4878090256097561, 110.}, {0.4975609756097561, 110.}}], 
    LineBox[{{0.4926850006097561, 112.}, {0.4975609756097561, 112.}}], 
    LineBox[{{0.4926850006097561, 114.}, {0.4975609756097561, 114.}}], 
    LineBox[{{0.4926850006097561, 116.}, {0.4975609756097561, 116.}}], 
    LineBox[{{0.4926850006097561, 118.}, {0.4975609756097561, 118.}}], 
    LineBox[{{0.4878090256097561, 120.}, {0.4975609756097561, 120.}}], 
    LineBox[{{0.4926850006097561, 122.}, {0.4975609756097561, 122.}}], 
    LineBox[{{0.4926850006097561, 124.}, {0.4975609756097561, 124.}}], 
    LineBox[{{0.4926850006097561, 126.}, {0.4975609756097561, 126.}}], 
    LineBox[{{0.4926850006097561, 128.}, {0.4975609756097561, 128.}}], 
    LineBox[{{0.4878090256097561, 130.}, {0.4975609756097561, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 68.95424836601308}, {0.6650406504065041, 
     68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.505, 70.27362983660132}, {0.505, 68.95424836601308}}], 
    LineBox[{{0.51, 70.27362983660132}, {0.51, 68.95424836601308}}], 
    LineBox[{{0.515, 70.27362983660132}, {0.515, 68.95424836601308}}], 
    LineBox[{{0.52, 70.27362983660132}, {0.52, 68.95424836601308}}], 
    LineBox[{{0.525, 71.59301130718954}, {0.525, 68.95424836601308}}], 
    LineBox[{{0.53, 70.27362983660132}, {0.53, 68.95424836601308}}], 
    LineBox[{{0.535, 70.27362983660132}, {0.535, 68.95424836601308}}], 
    LineBox[{{0.54, 70.27362983660132}, {0.54, 68.95424836601308}}], 
    LineBox[{{0.545, 70.27362983660132}, {0.545, 68.95424836601308}}], 
    LineBox[{{0.55, 71.59301130718954}, {0.55, 68.95424836601308}}], 
    LineBox[{{0.555, 70.27362983660132}, {0.555, 68.95424836601308}}], 
    LineBox[{{0.56, 70.27362983660132}, {0.56, 68.95424836601308}}], 
    LineBox[{{0.5650000000000001, 70.27362983660132}, {0.5650000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.5700000000000001, 70.27362983660132}, {0.5700000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.5750000000000001, 71.59301130718954}, {0.5750000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.5800000000000001, 70.27362983660132}, {0.5800000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.5850000000000001, 70.27362983660132}, {0.5850000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.5900000000000001, 70.27362983660132}, {0.5900000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.5950000000000001, 70.27362983660132}, {0.5950000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.6000000000000001, 71.59301130718954}, {0.6000000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.6050000000000001, 70.27362983660132}, {0.6050000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.6100000000000001, 70.27362983660132}, {0.6100000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.6150000000000001, 70.27362983660132}, {0.6150000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.6200000000000001, 70.27362983660132}, {0.6200000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.625, 71.59301130718954}, {0.625, 68.95424836601308}}], 
    LineBox[{{0.63, 70.27362983660132}, {0.63, 68.95424836601308}}], 
    LineBox[{{0.635, 70.27362983660132}, {0.635, 68.95424836601308}}], 
    LineBox[{{0.64, 70.27362983660132}, {0.64, 68.95424836601308}}], 
    LineBox[{{0.645, 70.27362983660132}, {0.645, 68.95424836601308}}], 
    LineBox[{{0.65, 71.59301130718954}, {0.65, 68.95424836601308}}], 
    LineBox[{{0.655, 70.27362983660132}, {0.655, 68.95424836601308}}], 
    LineBox[{{0.66, 70.27362983660132}, {0.66, 68.95424836601308}}], 
    LineBox[{{0.665, 70.27362983660132}, {0.665, 68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 68.95424836601308}, {0.5024390243902439, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5121909743902439, 70.}, {0.5024390243902439, 70.}}], 
    LineBox[{{0.5073149993902439, 72.}, {0.5024390243902439, 72.}}], 
    LineBox[{{0.5073149993902439, 74.}, {0.5024390243902439, 74.}}], 
    LineBox[{{0.5073149993902439, 76.}, {0.5024390243902439, 76.}}], 
    LineBox[{{0.5073149993902439, 78.}, {0.5024390243902439, 78.}}], 
    LineBox[{{0.5121909743902439, 80.}, {0.5024390243902439, 80.}}], 
    LineBox[{{0.5073149993902439, 82.}, {0.5024390243902439, 82.}}], 
    LineBox[{{0.5073149993902439, 84.}, {0.5024390243902439, 84.}}], 
    LineBox[{{0.5073149993902439, 86.}, {0.5024390243902439, 86.}}], 
    LineBox[{{0.5073149993902439, 88.}, {0.5024390243902439, 88.}}], 
    LineBox[{{0.5121909743902439, 90.}, {0.5024390243902439, 90.}}], 
    LineBox[{{0.5073149993902439, 92.}, {0.5024390243902439, 92.}}], 
    LineBox[{{0.5073149993902439, 94.}, {0.5024390243902439, 94.}}], 
    LineBox[{{0.5073149993902439, 96.}, {0.5024390243902439, 96.}}], 
    LineBox[{{0.5073149993902439, 98.}, {0.5024390243902439, 98.}}], 
    LineBox[{{0.5121909743902439, 100.}, {0.5024390243902439, 100.}}], 
    LineBox[{{0.5073149993902439, 102.}, {0.5024390243902439, 102.}}], 
    LineBox[{{0.5073149993902439, 104.}, {0.5024390243902439, 104.}}], 
    LineBox[{{0.5073149993902439, 106.}, {0.5024390243902439, 106.}}], 
    LineBox[{{0.5073149993902439, 108.}, {0.5024390243902439, 108.}}], 
    LineBox[{{0.5121909743902439, 110.}, {0.5024390243902439, 110.}}], 
    LineBox[{{0.5073149993902439, 112.}, {0.5024390243902439, 112.}}], 
    LineBox[{{0.5073149993902439, 114.}, {0.5024390243902439, 114.}}], 
    LineBox[{{0.5073149993902439, 116.}, {0.5024390243902439, 116.}}], 
    LineBox[{{0.5073149993902439, 118.}, {0.5024390243902439, 118.}}], 
    LineBox[{{0.5121909743902439, 120.}, {0.5024390243902439, 120.}}], 
    LineBox[{{0.5073149993902439, 122.}, {0.5024390243902439, 122.}}], 
    LineBox[{{0.5073149993902439, 124.}, {0.5024390243902439, 124.}}], 
    LineBox[{{0.5073149993902439, 126.}, {0.5024390243902439, 126.}}], 
    LineBox[{{0.5073149993902439, 128.}, {0.5024390243902439, 128.}}], 
    LineBox[{{0.5121909743902439, 130.}, {0.5024390243902439, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 131.04575163398692`}, {0.6650406504065041, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.505, 129.72637016339868`}, {0.505, 131.04575163398692`}}], 
    LineBox[{{0.51, 129.72637016339868`}, {0.51, 131.04575163398692`}}], 
    LineBox[{{0.515, 129.72637016339868`}, {0.515, 131.04575163398692`}}], 
    LineBox[{{0.52, 129.72637016339868`}, {0.52, 131.04575163398692`}}], 
    LineBox[{{0.525, 128.40698869281044`}, {0.525, 131.04575163398692`}}], 
    LineBox[{{0.53, 129.72637016339868`}, {0.53, 131.04575163398692`}}], 
    LineBox[{{0.535, 129.72637016339868`}, {0.535, 131.04575163398692`}}], 
    LineBox[{{0.54, 129.72637016339868`}, {0.54, 131.04575163398692`}}], 
    LineBox[{{0.545, 129.72637016339868`}, {0.545, 131.04575163398692`}}], 
    LineBox[{{0.55, 128.40698869281044`}, {0.55, 131.04575163398692`}}], 
    LineBox[{{0.555, 129.72637016339868`}, {0.555, 131.04575163398692`}}], 
    LineBox[{{0.56, 129.72637016339868`}, {0.56, 131.04575163398692`}}], 
    LineBox[{{0.5650000000000001, 129.72637016339868`}, {0.5650000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.5700000000000001, 129.72637016339868`}, {0.5700000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.5750000000000001, 128.40698869281044`}, {0.5750000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.5800000000000001, 129.72637016339868`}, {0.5800000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.5850000000000001, 129.72637016339868`}, {0.5850000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.5900000000000001, 129.72637016339868`}, {0.5900000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.5950000000000001, 129.72637016339868`}, {0.5950000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.6000000000000001, 128.40698869281044`}, {0.6000000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.6050000000000001, 129.72637016339868`}, {0.6050000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.6100000000000001, 129.72637016339868`}, {0.6100000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.6150000000000001, 129.72637016339868`}, {0.6150000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.6200000000000001, 129.72637016339868`}, {0.6200000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.625, 128.40698869281044`}, {0.625, 131.04575163398692`}}], 
    LineBox[{{0.63, 129.72637016339868`}, {0.63, 131.04575163398692`}}], 
    LineBox[{{0.635, 129.72637016339868`}, {0.635, 131.04575163398692`}}], 
    LineBox[{{0.64, 129.72637016339868`}, {0.64, 131.04575163398692`}}], 
    LineBox[{{0.645, 129.72637016339868`}, {0.645, 131.04575163398692`}}], 
    LineBox[{{0.65, 128.40698869281044`}, {0.65, 131.04575163398692`}}], 
    LineBox[{{0.655, 129.72637016339868`}, {0.655, 131.04575163398692`}}], 
    LineBox[{{0.66, 129.72637016339868`}, {0.66, 131.04575163398692`}}], 
    LineBox[{{0.665, 129.72637016339868`}, {0.665, 131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6650406504065041, 68.95424836601308}, {0.6650406504065041, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6552887004065041, 70.}, {0.6650406504065041, 70.}}], 
    LineBox[{{0.660164675406504, 72.}, {0.6650406504065041, 72.}}], 
    LineBox[{{0.660164675406504, 74.}, {0.6650406504065041, 74.}}], 
    LineBox[{{0.660164675406504, 76.}, {0.6650406504065041, 76.}}], 
    LineBox[{{0.660164675406504, 78.}, {0.6650406504065041, 78.}}], 
    LineBox[{{0.6552887004065041, 80.}, {0.6650406504065041, 80.}}], 
    LineBox[{{0.660164675406504, 82.}, {0.6650406504065041, 82.}}], 
    LineBox[{{0.660164675406504, 84.}, {0.6650406504065041, 84.}}], 
    LineBox[{{0.660164675406504, 86.}, {0.6650406504065041, 86.}}], 
    LineBox[{{0.660164675406504, 88.}, {0.6650406504065041, 88.}}], 
    LineBox[{{0.6552887004065041, 90.}, {0.6650406504065041, 90.}}], 
    LineBox[{{0.660164675406504, 92.}, {0.6650406504065041, 92.}}], 
    LineBox[{{0.660164675406504, 94.}, {0.6650406504065041, 94.}}], 
    LineBox[{{0.660164675406504, 96.}, {0.6650406504065041, 96.}}], 
    LineBox[{{0.660164675406504, 98.}, {0.6650406504065041, 98.}}], 
    LineBox[{{0.6552887004065041, 100.}, {0.6650406504065041, 100.}}], 
    LineBox[{{0.660164675406504, 102.}, {0.6650406504065041, 102.}}], 
    LineBox[{{0.660164675406504, 104.}, {0.6650406504065041, 104.}}], 
    LineBox[{{0.660164675406504, 106.}, {0.6650406504065041, 106.}}], 
    LineBox[{{0.660164675406504, 108.}, {0.6650406504065041, 108.}}], 
    LineBox[{{0.6552887004065041, 110.}, {0.6650406504065041, 110.}}], 
    LineBox[{{0.660164675406504, 112.}, {0.6650406504065041, 112.}}], 
    LineBox[{{0.660164675406504, 114.}, {0.6650406504065041, 114.}}], 
    LineBox[{{0.660164675406504, 116.}, {0.6650406504065041, 116.}}], 
    LineBox[{{0.660164675406504, 118.}, {0.6650406504065041, 118.}}], 
    LineBox[{{0.6552887004065041, 120.}, {0.6650406504065041, 120.}}], 
    LineBox[{{0.660164675406504, 122.}, {0.6650406504065041, 122.}}], 
    LineBox[{{0.660164675406504, 124.}, {0.6650406504065041, 124.}}], 
    LineBox[{{0.660164675406504, 126.}, {0.6650406504065041, 126.}}], 
    LineBox[{{0.660164675406504, 128.}, {0.6650406504065041, 128.}}], 
    LineBox[{{0.6552887004065041, 130.}, {0.6650406504065041, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 68.95424836601308}, {0.832520325203252, 
     68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.67, 70.27362983660132}, {0.67, 68.95424836601308}}], 
    LineBox[{{0.675, 71.59301130718954}, {0.675, 68.95424836601308}}], 
    LineBox[{{0.68, 70.27362983660132}, {0.68, 68.95424836601308}}], 
    LineBox[{{0.685, 70.27362983660132}, {0.685, 68.95424836601308}}], 
    LineBox[{{0.6900000000000001, 70.27362983660132}, {0.6900000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.6950000000000001, 70.27362983660132}, {0.6950000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7000000000000001, 71.59301130718954}, {0.7000000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7050000000000001, 70.27362983660132}, {0.7050000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7100000000000001, 70.27362983660132}, {0.7100000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7150000000000001, 70.27362983660132}, {0.7150000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7200000000000001, 70.27362983660132}, {0.7200000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7250000000000001, 71.59301130718954}, {0.7250000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7300000000000001, 70.27362983660132}, {0.7300000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7350000000000001, 70.27362983660132}, {0.7350000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7400000000000001, 70.27362983660132}, {0.7400000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.7450000000000001, 70.27362983660132}, {0.7450000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.75, 71.59301130718954}, {0.75, 68.95424836601308}}], 
    LineBox[{{0.755, 70.27362983660132}, {0.755, 68.95424836601308}}], 
    LineBox[{{0.76, 70.27362983660132}, {0.76, 68.95424836601308}}], 
    LineBox[{{0.765, 70.27362983660132}, {0.765, 68.95424836601308}}], 
    LineBox[{{0.77, 70.27362983660132}, {0.77, 68.95424836601308}}], 
    LineBox[{{0.775, 71.59301130718954}, {0.775, 68.95424836601308}}], 
    LineBox[{{0.78, 70.27362983660132}, {0.78, 68.95424836601308}}], 
    LineBox[{{0.785, 70.27362983660132}, {0.785, 68.95424836601308}}], 
    LineBox[{{0.79, 70.27362983660132}, {0.79, 68.95424836601308}}], 
    LineBox[{{0.795, 70.27362983660132}, {0.795, 68.95424836601308}}], 
    LineBox[{{0.8, 71.59301130718954}, {0.8, 68.95424836601308}}], 
    LineBox[{{0.805, 70.27362983660132}, {0.805, 68.95424836601308}}], 
    LineBox[{{0.81, 70.27362983660132}, {0.81, 68.95424836601308}}], 
    LineBox[{{0.8150000000000001, 70.27362983660132}, {0.8150000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.8200000000000001, 70.27362983660132}, {0.8200000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.8250000000000001, 71.59301130718954}, {0.8250000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.8300000000000001, 70.27362983660132}, {0.8300000000000001, 
     68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 68.95424836601308}, {0.6699186991869919, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6796706491869918, 70.}, {0.6699186991869919, 70.}}], 
    LineBox[{{0.6747946741869919, 72.}, {0.6699186991869919, 72.}}], 
    LineBox[{{0.6747946741869919, 74.}, {0.6699186991869919, 74.}}], 
    LineBox[{{0.6747946741869919, 76.}, {0.6699186991869919, 76.}}], 
    LineBox[{{0.6747946741869919, 78.}, {0.6699186991869919, 78.}}], 
    LineBox[{{0.6796706491869918, 80.}, {0.6699186991869919, 80.}}], 
    LineBox[{{0.6747946741869919, 82.}, {0.6699186991869919, 82.}}], 
    LineBox[{{0.6747946741869919, 84.}, {0.6699186991869919, 84.}}], 
    LineBox[{{0.6747946741869919, 86.}, {0.6699186991869919, 86.}}], 
    LineBox[{{0.6747946741869919, 88.}, {0.6699186991869919, 88.}}], 
    LineBox[{{0.6796706491869918, 90.}, {0.6699186991869919, 90.}}], 
    LineBox[{{0.6747946741869919, 92.}, {0.6699186991869919, 92.}}], 
    LineBox[{{0.6747946741869919, 94.}, {0.6699186991869919, 94.}}], 
    LineBox[{{0.6747946741869919, 96.}, {0.6699186991869919, 96.}}], 
    LineBox[{{0.6747946741869919, 98.}, {0.6699186991869919, 98.}}], 
    LineBox[{{0.6796706491869918, 100.}, {0.6699186991869919, 100.}}], 
    LineBox[{{0.6747946741869919, 102.}, {0.6699186991869919, 102.}}], 
    LineBox[{{0.6747946741869919, 104.}, {0.6699186991869919, 104.}}], 
    LineBox[{{0.6747946741869919, 106.}, {0.6699186991869919, 106.}}], 
    LineBox[{{0.6747946741869919, 108.}, {0.6699186991869919, 108.}}], 
    LineBox[{{0.6796706491869918, 110.}, {0.6699186991869919, 110.}}], 
    LineBox[{{0.6747946741869919, 112.}, {0.6699186991869919, 112.}}], 
    LineBox[{{0.6747946741869919, 114.}, {0.6699186991869919, 114.}}], 
    LineBox[{{0.6747946741869919, 116.}, {0.6699186991869919, 116.}}], 
    LineBox[{{0.6747946741869919, 118.}, {0.6699186991869919, 118.}}], 
    LineBox[{{0.6796706491869918, 120.}, {0.6699186991869919, 120.}}], 
    LineBox[{{0.6747946741869919, 122.}, {0.6699186991869919, 122.}}], 
    LineBox[{{0.6747946741869919, 124.}, {0.6699186991869919, 124.}}], 
    LineBox[{{0.6747946741869919, 126.}, {0.6699186991869919, 126.}}], 
    LineBox[{{0.6747946741869919, 128.}, {0.6699186991869919, 128.}}], 
    LineBox[{{0.6796706491869918, 130.}, {0.6699186991869919, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 131.04575163398692`}, {0.832520325203252, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.67, 129.72637016339868`}, {0.67, 131.04575163398692`}}], 
    LineBox[{{0.675, 128.40698869281044`}, {0.675, 131.04575163398692`}}], 
    LineBox[{{0.68, 129.72637016339868`}, {0.68, 131.04575163398692`}}], 
    LineBox[{{0.685, 129.72637016339868`}, {0.685, 131.04575163398692`}}], 
    LineBox[{{0.6900000000000001, 129.72637016339868`}, {0.6900000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.6950000000000001, 129.72637016339868`}, {0.6950000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7000000000000001, 128.40698869281044`}, {0.7000000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7050000000000001, 129.72637016339868`}, {0.7050000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7100000000000001, 129.72637016339868`}, {0.7100000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7150000000000001, 129.72637016339868`}, {0.7150000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7200000000000001, 129.72637016339868`}, {0.7200000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7250000000000001, 128.40698869281044`}, {0.7250000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7300000000000001, 129.72637016339868`}, {0.7300000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7350000000000001, 129.72637016339868`}, {0.7350000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7400000000000001, 129.72637016339868`}, {0.7400000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.7450000000000001, 129.72637016339868`}, {0.7450000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.75, 128.40698869281044`}, {0.75, 131.04575163398692`}}], 
    LineBox[{{0.755, 129.72637016339868`}, {0.755, 131.04575163398692`}}], 
    LineBox[{{0.76, 129.72637016339868`}, {0.76, 131.04575163398692`}}], 
    LineBox[{{0.765, 129.72637016339868`}, {0.765, 131.04575163398692`}}], 
    LineBox[{{0.77, 129.72637016339868`}, {0.77, 131.04575163398692`}}], 
    LineBox[{{0.775, 128.40698869281044`}, {0.775, 131.04575163398692`}}], 
    LineBox[{{0.78, 129.72637016339868`}, {0.78, 131.04575163398692`}}], 
    LineBox[{{0.785, 129.72637016339868`}, {0.785, 131.04575163398692`}}], 
    LineBox[{{0.79, 129.72637016339868`}, {0.79, 131.04575163398692`}}], 
    LineBox[{{0.795, 129.72637016339868`}, {0.795, 131.04575163398692`}}], 
    LineBox[{{0.8, 128.40698869281044`}, {0.8, 131.04575163398692`}}], 
    LineBox[{{0.805, 129.72637016339868`}, {0.805, 131.04575163398692`}}], 
    LineBox[{{0.81, 129.72637016339868`}, {0.81, 131.04575163398692`}}], 
    LineBox[{{0.8150000000000001, 129.72637016339868`}, {0.8150000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.8200000000000001, 129.72637016339868`}, {0.8200000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.8250000000000001, 128.40698869281044`}, {0.8250000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.8300000000000001, 129.72637016339868`}, {0.8300000000000001, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.832520325203252, 68.95424836601308}, {0.832520325203252, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8227683752032521, 70.}, {0.832520325203252, 70.}}], 
    LineBox[{{0.827644350203252, 72.}, {0.832520325203252, 72.}}], 
    LineBox[{{0.827644350203252, 74.}, {0.832520325203252, 74.}}], 
    LineBox[{{0.827644350203252, 76.}, {0.832520325203252, 76.}}], 
    LineBox[{{0.827644350203252, 78.}, {0.832520325203252, 78.}}], 
    LineBox[{{0.8227683752032521, 80.}, {0.832520325203252, 80.}}], 
    LineBox[{{0.827644350203252, 82.}, {0.832520325203252, 82.}}], 
    LineBox[{{0.827644350203252, 84.}, {0.832520325203252, 84.}}], 
    LineBox[{{0.827644350203252, 86.}, {0.832520325203252, 86.}}], 
    LineBox[{{0.827644350203252, 88.}, {0.832520325203252, 88.}}], 
    LineBox[{{0.8227683752032521, 90.}, {0.832520325203252, 90.}}], 
    LineBox[{{0.827644350203252, 92.}, {0.832520325203252, 92.}}], 
    LineBox[{{0.827644350203252, 94.}, {0.832520325203252, 94.}}], 
    LineBox[{{0.827644350203252, 96.}, {0.832520325203252, 96.}}], 
    LineBox[{{0.827644350203252, 98.}, {0.832520325203252, 98.}}], 
    LineBox[{{0.8227683752032521, 100.}, {0.832520325203252, 100.}}], 
    LineBox[{{0.827644350203252, 102.}, {0.832520325203252, 102.}}], 
    LineBox[{{0.827644350203252, 104.}, {0.832520325203252, 104.}}], 
    LineBox[{{0.827644350203252, 106.}, {0.832520325203252, 106.}}], 
    LineBox[{{0.827644350203252, 108.}, {0.832520325203252, 108.}}], 
    LineBox[{{0.8227683752032521, 110.}, {0.832520325203252, 110.}}], 
    LineBox[{{0.827644350203252, 112.}, {0.832520325203252, 112.}}], 
    LineBox[{{0.827644350203252, 114.}, {0.832520325203252, 114.}}], 
    LineBox[{{0.827644350203252, 116.}, {0.832520325203252, 116.}}], 
    LineBox[{{0.827644350203252, 118.}, {0.832520325203252, 118.}}], 
    LineBox[{{0.8227683752032521, 120.}, {0.832520325203252, 120.}}], 
    LineBox[{{0.827644350203252, 122.}, {0.832520325203252, 122.}}], 
    LineBox[{{0.827644350203252, 124.}, {0.832520325203252, 124.}}], 
    LineBox[{{0.827644350203252, 126.}, {0.832520325203252, 126.}}], 
    LineBox[{{0.827644350203252, 128.}, {0.832520325203252, 128.}}], 
    LineBox[{{0.8227683752032521, 130.}, {0.832520325203252, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 68.95424836601308}, {1., 
     68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8400000000000001, 70.27362983660132}, {0.8400000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.8450000000000001, 70.27362983660132}, {0.8450000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.8500000000000001, 71.59301130718954}, {0.8500000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.8550000000000001, 70.27362983660132}, {0.8550000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.8600000000000001, 70.27362983660132}, {0.8600000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.865, 70.27362983660132}, {0.865, 68.95424836601308}}], 
    LineBox[{{0.87, 70.27362983660132}, {0.87, 68.95424836601308}}], 
    LineBox[{{0.875, 71.59301130718954}, {0.875, 68.95424836601308}}], 
    LineBox[{{0.88, 70.27362983660132}, {0.88, 68.95424836601308}}], 
    LineBox[{{0.885, 70.27362983660132}, {0.885, 68.95424836601308}}], 
    LineBox[{{0.8899999999999999, 70.27362983660132}, {0.8899999999999999, 
     68.95424836601308}}], 
    LineBox[{{0.8949999999999999, 70.27362983660132}, {0.8949999999999999, 
     68.95424836601308}}], 
    LineBox[{{0.9, 71.59301130718954}, {0.9, 68.95424836601308}}], 
    LineBox[{{0.905, 70.27362983660132}, {0.905, 68.95424836601308}}], 
    LineBox[{{0.91, 70.27362983660132}, {0.91, 68.95424836601308}}], 
    LineBox[{{0.9149999999999999, 70.27362983660132}, {0.9149999999999999, 
     68.95424836601308}}], 
    LineBox[{{0.9199999999999999, 70.27362983660132}, {0.9199999999999999, 
     68.95424836601308}}], 
    LineBox[{{0.925, 71.59301130718954}, {0.925, 68.95424836601308}}], 
    LineBox[{{0.93, 70.27362983660132}, {0.93, 68.95424836601308}}], 
    LineBox[{{0.935, 70.27362983660132}, {0.935, 68.95424836601308}}], 
    LineBox[{{0.94, 70.27362983660132}, {0.94, 68.95424836601308}}], 
    LineBox[{{0.945, 70.27362983660132}, {0.945, 68.95424836601308}}], 
    LineBox[{{0.9500000000000001, 71.59301130718954}, {0.9500000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.9550000000000001, 70.27362983660132}, {0.9550000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.9600000000000001, 70.27362983660132}, {0.9600000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.965, 70.27362983660132}, {0.965, 68.95424836601308}}], 
    LineBox[{{0.97, 70.27362983660132}, {0.97, 68.95424836601308}}], 
    LineBox[{{0.9750000000000001, 71.59301130718954}, {0.9750000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.9800000000000001, 70.27362983660132}, {0.9800000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.9850000000000001, 70.27362983660132}, {0.9850000000000001, 
     68.95424836601308}}], 
    LineBox[{{0.99, 70.27362983660132}, {0.99, 68.95424836601308}}], 
    LineBox[{{0.995, 70.27362983660132}, {0.995, 68.95424836601308}}], 
    LineBox[{{1., 71.59301130718954}, {1., 68.95424836601308}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 68.95424836601308}, {0.8373983739837398, 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8471503239837398, 70.}, {0.8373983739837398, 70.}}], 
    LineBox[{{0.8422743489837399, 72.}, {0.8373983739837398, 72.}}], 
    LineBox[{{0.8422743489837399, 74.}, {0.8373983739837398, 74.}}], 
    LineBox[{{0.8422743489837399, 76.}, {0.8373983739837398, 76.}}], 
    LineBox[{{0.8422743489837399, 78.}, {0.8373983739837398, 78.}}], 
    LineBox[{{0.8471503239837398, 80.}, {0.8373983739837398, 80.}}], 
    LineBox[{{0.8422743489837399, 82.}, {0.8373983739837398, 82.}}], 
    LineBox[{{0.8422743489837399, 84.}, {0.8373983739837398, 84.}}], 
    LineBox[{{0.8422743489837399, 86.}, {0.8373983739837398, 86.}}], 
    LineBox[{{0.8422743489837399, 88.}, {0.8373983739837398, 88.}}], 
    LineBox[{{0.8471503239837398, 90.}, {0.8373983739837398, 90.}}], 
    LineBox[{{0.8422743489837399, 92.}, {0.8373983739837398, 92.}}], 
    LineBox[{{0.8422743489837399, 94.}, {0.8373983739837398, 94.}}], 
    LineBox[{{0.8422743489837399, 96.}, {0.8373983739837398, 96.}}], 
    LineBox[{{0.8422743489837399, 98.}, {0.8373983739837398, 98.}}], 
    LineBox[{{0.8471503239837398, 100.}, {0.8373983739837398, 100.}}], 
    LineBox[{{0.8422743489837399, 102.}, {0.8373983739837398, 102.}}], 
    LineBox[{{0.8422743489837399, 104.}, {0.8373983739837398, 104.}}], 
    LineBox[{{0.8422743489837399, 106.}, {0.8373983739837398, 106.}}], 
    LineBox[{{0.8422743489837399, 108.}, {0.8373983739837398, 108.}}], 
    LineBox[{{0.8471503239837398, 110.}, {0.8373983739837398, 110.}}], 
    LineBox[{{0.8422743489837399, 112.}, {0.8373983739837398, 112.}}], 
    LineBox[{{0.8422743489837399, 114.}, {0.8373983739837398, 114.}}], 
    LineBox[{{0.8422743489837399, 116.}, {0.8373983739837398, 116.}}], 
    LineBox[{{0.8422743489837399, 118.}, {0.8373983739837398, 118.}}], 
    LineBox[{{0.8471503239837398, 120.}, {0.8373983739837398, 120.}}], 
    LineBox[{{0.8422743489837399, 122.}, {0.8373983739837398, 122.}}], 
    LineBox[{{0.8422743489837399, 124.}, {0.8373983739837398, 124.}}], 
    LineBox[{{0.8422743489837399, 126.}, {0.8373983739837398, 126.}}], 
    LineBox[{{0.8422743489837399, 128.}, {0.8373983739837398, 128.}}], 
    LineBox[{{0.8471503239837398, 130.}, {0.8373983739837398, 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 131.04575163398692`}, {1., 
     131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8400000000000001, 129.72637016339868`}, {0.8400000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.8450000000000001, 129.72637016339868`}, {0.8450000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.8500000000000001, 128.40698869281044`}, {0.8500000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.8550000000000001, 129.72637016339868`}, {0.8550000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.8600000000000001, 129.72637016339868`}, {0.8600000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.865, 129.72637016339868`}, {0.865, 131.04575163398692`}}], 
    LineBox[{{0.87, 129.72637016339868`}, {0.87, 131.04575163398692`}}], 
    LineBox[{{0.875, 128.40698869281044`}, {0.875, 131.04575163398692`}}], 
    LineBox[{{0.88, 129.72637016339868`}, {0.88, 131.04575163398692`}}], 
    LineBox[{{0.885, 129.72637016339868`}, {0.885, 131.04575163398692`}}], 
    LineBox[{{0.8899999999999999, 129.72637016339868`}, {0.8899999999999999, 
     131.04575163398692`}}], 
    LineBox[{{0.8949999999999999, 129.72637016339868`}, {0.8949999999999999, 
     131.04575163398692`}}], 
    LineBox[{{0.9, 128.40698869281044`}, {0.9, 131.04575163398692`}}], 
    LineBox[{{0.905, 129.72637016339868`}, {0.905, 131.04575163398692`}}], 
    LineBox[{{0.91, 129.72637016339868`}, {0.91, 131.04575163398692`}}], 
    LineBox[{{0.9149999999999999, 129.72637016339868`}, {0.9149999999999999, 
     131.04575163398692`}}], 
    LineBox[{{0.9199999999999999, 129.72637016339868`}, {0.9199999999999999, 
     131.04575163398692`}}], 
    LineBox[{{0.925, 128.40698869281044`}, {0.925, 131.04575163398692`}}], 
    LineBox[{{0.93, 129.72637016339868`}, {0.93, 131.04575163398692`}}], 
    LineBox[{{0.935, 129.72637016339868`}, {0.935, 131.04575163398692`}}], 
    LineBox[{{0.94, 129.72637016339868`}, {0.94, 131.04575163398692`}}], 
    LineBox[{{0.945, 129.72637016339868`}, {0.945, 131.04575163398692`}}], 
    LineBox[{{0.9500000000000001, 128.40698869281044`}, {0.9500000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.9550000000000001, 129.72637016339868`}, {0.9550000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.9600000000000001, 129.72637016339868`}, {0.9600000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.965, 129.72637016339868`}, {0.965, 131.04575163398692`}}], 
    LineBox[{{0.97, 129.72637016339868`}, {0.97, 131.04575163398692`}}], 
    LineBox[{{0.9750000000000001, 128.40698869281044`}, {0.9750000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.9800000000000001, 129.72637016339868`}, {0.9800000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.9850000000000001, 129.72637016339868`}, {0.9850000000000001, 
     131.04575163398692`}}], 
    LineBox[{{0.99, 129.72637016339868`}, {0.99, 131.04575163398692`}}], 
    LineBox[{{0.995, 129.72637016339868`}, {0.995, 131.04575163398692`}}], 
    LineBox[{{1., 128.40698869281044`}, {1., 131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{1., 68.95424836601308}, {1., 131.04575163398692`}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], LineBox[{{0.99024805, 70.}, {1., 70.}}], 
    LineBox[{{0.995124025, 72.}, {1., 72.}}], 
    LineBox[{{0.995124025, 74.}, {1., 74.}}], 
    LineBox[{{0.995124025, 76.}, {1., 76.}}], 
    LineBox[{{0.995124025, 78.}, {1., 78.}}], 
    LineBox[{{0.99024805, 80.}, {1., 80.}}], 
    LineBox[{{0.995124025, 82.}, {1., 82.}}], 
    LineBox[{{0.995124025, 84.}, {1., 84.}}], 
    LineBox[{{0.995124025, 86.}, {1., 86.}}], 
    LineBox[{{0.995124025, 88.}, {1., 88.}}], 
    LineBox[{{0.99024805, 90.}, {1., 90.}}], 
    LineBox[{{0.995124025, 92.}, {1., 92.}}], 
    LineBox[{{0.995124025, 94.}, {1., 94.}}], 
    LineBox[{{0.995124025, 96.}, {1., 96.}}], 
    LineBox[{{0.995124025, 98.}, {1., 98.}}], 
    LineBox[{{0.99024805, 100.}, {1., 100.}}], 
    LineBox[{{0.995124025, 102.}, {1., 102.}}], 
    LineBox[{{0.995124025, 104.}, {1., 104.}}], 
    LineBox[{{0.995124025, 106.}, {1., 106.}}], 
    LineBox[{{0.995124025, 108.}, {1., 108.}}], 
    LineBox[{{0.99024805, 110.}, {1., 110.}}], 
    LineBox[{{0.995124025, 112.}, {1., 112.}}], 
    LineBox[{{0.995124025, 114.}, {1., 114.}}], 
    LineBox[{{0.995124025, 116.}, {1., 116.}}], 
    LineBox[{{0.995124025, 118.}, {1., 118.}}], 
    LineBox[{{0.99024805, 120.}, {1., 120.}}], 
    LineBox[{{0.995124025, 122.}, {1., 122.}}], 
    LineBox[{{0.995124025, 124.}, {1., 124.}}], 
    LineBox[{{0.995124025, 126.}, {1., 126.}}], 
    LineBox[{{0.995124025, 128.}, {1., 128.}}], 
    LineBox[{{0.99024805, 130.}, {1., 130.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 5.000000000000007}, {0.16260162601626016`, 
     5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 7.638762941176478}, {0., 5.000000000000007}}], 
    LineBox[{{0.005000000000000001, 6.319381470588242}, {0.005000000000000001,
      5.000000000000007}}], 
    LineBox[{{0.010000000000000002`, 6.319381470588242}, {
     0.010000000000000002`, 5.000000000000007}}], 
    LineBox[{{0.015000000000000003`, 6.319381470588242}, {
     0.015000000000000003`, 5.000000000000007}}], 
    LineBox[{{0.020000000000000004`, 6.319381470588242}, {
     0.020000000000000004`, 5.000000000000007}}], 
    LineBox[{{0.025, 7.638762941176478}, {0.025, 5.000000000000007}}], 
    LineBox[{{0.030000000000000002`, 6.319381470588242}, {
     0.030000000000000002`, 5.000000000000007}}], 
    LineBox[{{0.035, 6.319381470588242}, {0.035, 5.000000000000007}}], 
    LineBox[{{0.04000000000000001, 6.319381470588242}, {0.04000000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.045000000000000005`, 6.319381470588242}, {
     0.045000000000000005`, 5.000000000000007}}], 
    LineBox[{{0.05, 7.638762941176478}, {0.05, 5.000000000000007}}], 
    LineBox[{{0.05500000000000001, 6.319381470588242}, {0.05500000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.060000000000000005`, 6.319381470588242}, {
     0.060000000000000005`, 5.000000000000007}}], 
    LineBox[{{0.065, 6.319381470588242}, {0.065, 5.000000000000007}}], 
    LineBox[{{0.07, 6.319381470588242}, {0.07, 5.000000000000007}}], 
    LineBox[{{0.07500000000000001, 7.638762941176478}, {0.07500000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.08000000000000002, 6.319381470588242}, {0.08000000000000002, 
     5.000000000000007}}], 
    LineBox[{{0.08500000000000002, 6.319381470588242}, {0.08500000000000002, 
     5.000000000000007}}], 
    LineBox[{{0.09000000000000001, 6.319381470588242}, {0.09000000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.09500000000000001, 6.319381470588242}, {0.09500000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.1, 7.638762941176478}, {0.1, 5.000000000000007}}], 
    LineBox[{{0.10500000000000001`, 6.319381470588242}, {0.10500000000000001`,
      5.000000000000007}}], 
    LineBox[{{0.11000000000000001`, 6.319381470588242}, {0.11000000000000001`,
      5.000000000000007}}], 
    LineBox[{{0.115, 6.319381470588242}, {0.115, 5.000000000000007}}], 
    LineBox[{{0.12000000000000001`, 6.319381470588242}, {0.12000000000000001`,
      5.000000000000007}}], 
    LineBox[{{0.125, 7.638762941176478}, {0.125, 5.000000000000007}}], 
    LineBox[{{0.13, 6.319381470588242}, {0.13, 5.000000000000007}}], 
    LineBox[{{0.135, 6.319381470588242}, {0.135, 5.000000000000007}}], 
    LineBox[{{0.14, 6.319381470588242}, {0.14, 5.000000000000007}}], 
    LineBox[{{0.14500000000000002`, 6.319381470588242}, {0.14500000000000002`,
      5.000000000000007}}], 
    LineBox[{{0.15000000000000002`, 7.638762941176478}, {0.15000000000000002`,
      5.000000000000007}}], 
    LineBox[{{0.15500000000000003`, 6.319381470588242}, {0.15500000000000003`,
      5.000000000000007}}], 
    LineBox[{{0.16000000000000003`, 6.319381470588242}, {0.16000000000000003`,
      5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 5.000000000000007}, {0., 67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.004875975000000001, 6.}, {0., 6.}}], 
    LineBox[{{0.004875975000000001, 8.}, {0., 8.}}], 
    LineBox[{{0.009751950000000002, 10.}, {0., 10.}}], 
    LineBox[{{0.004875975000000001, 12.}, {0., 12.}}], 
    LineBox[{{0.004875975000000001, 14.}, {0., 14.}}], 
    LineBox[{{0.004875975000000001, 16.}, {0., 16.}}], 
    LineBox[{{0.004875975000000001, 18.}, {0., 18.}}], 
    LineBox[{{0.009751950000000002, 20.}, {0., 20.}}], 
    LineBox[{{0.004875975000000001, 22.}, {0., 22.}}], 
    LineBox[{{0.004875975000000001, 24.}, {0., 24.}}], 
    LineBox[{{0.004875975000000001, 26.}, {0., 26.}}], 
    LineBox[{{0.004875975000000001, 28.}, {0., 28.}}], 
    LineBox[{{0.009751950000000002, 30.}, {0., 30.}}], 
    LineBox[{{0.004875975000000001, 32.}, {0., 32.}}], 
    LineBox[{{0.004875975000000001, 34.}, {0., 34.}}], 
    LineBox[{{0.004875975000000001, 36.}, {0., 36.}}], 
    LineBox[{{0.004875975000000001, 38.}, {0., 38.}}], 
    LineBox[{{0.009751950000000002, 40.}, {0., 40.}}], 
    LineBox[{{0.004875975000000001, 42.}, {0., 42.}}], 
    LineBox[{{0.004875975000000001, 44.}, {0., 44.}}], 
    LineBox[{{0.004875975000000001, 46.}, {0., 46.}}], 
    LineBox[{{0.004875975000000001, 48.}, {0., 48.}}], 
    LineBox[{{0.009751950000000002, 50.}, {0., 50.}}], 
    LineBox[{{0.004875975000000001, 52.}, {0., 52.}}], 
    LineBox[{{0.004875975000000001, 54.}, {0., 54.}}], 
    LineBox[{{0.004875975000000001, 56.}, {0., 56.}}], 
    LineBox[{{0.004875975000000001, 58.}, {0., 58.}}], 
    LineBox[{{0.009751950000000002, 60.}, {0., 60.}}], 
    LineBox[{{0.004875975000000001, 62.}, {0., 62.}}], 
    LineBox[{{0.004875975000000001, 64.}, {0., 64.}}], 
    LineBox[{{0.004875975000000001, 66.}, {0., 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 67.09150326797386}, {0.16260162601626016`, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0., 64.4527403267974}, {0., 67.09150326797386}}], 
    LineBox[{{0.005000000000000001, 65.77212179738562}, {0.005000000000000001,
      67.09150326797386}}], 
    LineBox[{{0.010000000000000002`, 65.77212179738562}, {
     0.010000000000000002`, 67.09150326797386}}], 
    LineBox[{{0.015000000000000003`, 65.77212179738562}, {
     0.015000000000000003`, 67.09150326797386}}], 
    LineBox[{{0.020000000000000004`, 65.77212179738562}, {
     0.020000000000000004`, 67.09150326797386}}], 
    LineBox[{{0.025, 64.4527403267974}, {0.025, 67.09150326797386}}], 
    LineBox[{{0.030000000000000002`, 65.77212179738562}, {
     0.030000000000000002`, 67.09150326797386}}], 
    LineBox[{{0.035, 65.77212179738562}, {0.035, 67.09150326797386}}], 
    LineBox[{{0.04000000000000001, 65.77212179738562}, {0.04000000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.045000000000000005`, 65.77212179738562}, {
     0.045000000000000005`, 67.09150326797386}}], 
    LineBox[{{0.05, 64.4527403267974}, {0.05, 67.09150326797386}}], 
    LineBox[{{0.05500000000000001, 65.77212179738562}, {0.05500000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.060000000000000005`, 65.77212179738562}, {
     0.060000000000000005`, 67.09150326797386}}], 
    LineBox[{{0.065, 65.77212179738562}, {0.065, 67.09150326797386}}], 
    LineBox[{{0.07, 65.77212179738562}, {0.07, 67.09150326797386}}], 
    LineBox[{{0.07500000000000001, 64.4527403267974}, {0.07500000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.08000000000000002, 65.77212179738562}, {0.08000000000000002, 
     67.09150326797386}}], 
    LineBox[{{0.08500000000000002, 65.77212179738562}, {0.08500000000000002, 
     67.09150326797386}}], 
    LineBox[{{0.09000000000000001, 65.77212179738562}, {0.09000000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.09500000000000001, 65.77212179738562}, {0.09500000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.1, 64.4527403267974}, {0.1, 67.09150326797386}}], 
    LineBox[{{0.10500000000000001`, 65.77212179738562}, {0.10500000000000001`,
      67.09150326797386}}], 
    LineBox[{{0.11000000000000001`, 65.77212179738562}, {0.11000000000000001`,
      67.09150326797386}}], 
    LineBox[{{0.115, 65.77212179738562}, {0.115, 67.09150326797386}}], 
    LineBox[{{0.12000000000000001`, 65.77212179738562}, {0.12000000000000001`,
      67.09150326797386}}], 
    LineBox[{{0.125, 64.4527403267974}, {0.125, 67.09150326797386}}], 
    LineBox[{{0.13, 65.77212179738562}, {0.13, 67.09150326797386}}], 
    LineBox[{{0.135, 65.77212179738562}, {0.135, 67.09150326797386}}], 
    LineBox[{{0.14, 65.77212179738562}, {0.14, 67.09150326797386}}], 
    LineBox[{{0.14500000000000002`, 65.77212179738562}, {0.14500000000000002`,
      67.09150326797386}}], 
    LineBox[{{0.15000000000000002`, 64.4527403267974}, {0.15000000000000002`, 
     67.09150326797386}}], 
    LineBox[{{0.15500000000000003`, 65.77212179738562}, {0.15500000000000003`,
      67.09150326797386}}], 
    LineBox[{{0.16000000000000003`, 65.77212179738562}, {0.16000000000000003`,
      67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16260162601626016`, 5.000000000000007}, {0.16260162601626016`,
      67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.15772565101626015`, 6.}, {0.16260162601626016`, 6.}}], 
    LineBox[{{0.15772565101626015`, 8.}, {0.16260162601626016`, 8.}}], 
    LineBox[{{0.15284967601626015`, 10.}, {0.16260162601626016`, 10.}}], 
    LineBox[{{0.15772565101626015`, 12.}, {0.16260162601626016`, 12.}}], 
    LineBox[{{0.15772565101626015`, 14.}, {0.16260162601626016`, 14.}}], 
    LineBox[{{0.15772565101626015`, 16.}, {0.16260162601626016`, 16.}}], 
    LineBox[{{0.15772565101626015`, 18.}, {0.16260162601626016`, 18.}}], 
    LineBox[{{0.15284967601626015`, 20.}, {0.16260162601626016`, 20.}}], 
    LineBox[{{0.15772565101626015`, 22.}, {0.16260162601626016`, 22.}}], 
    LineBox[{{0.15772565101626015`, 24.}, {0.16260162601626016`, 24.}}], 
    LineBox[{{0.15772565101626015`, 26.}, {0.16260162601626016`, 26.}}], 
    LineBox[{{0.15772565101626015`, 28.}, {0.16260162601626016`, 28.}}], 
    LineBox[{{0.15284967601626015`, 30.}, {0.16260162601626016`, 30.}}], 
    LineBox[{{0.15772565101626015`, 32.}, {0.16260162601626016`, 32.}}], 
    LineBox[{{0.15772565101626015`, 34.}, {0.16260162601626016`, 34.}}], 
    LineBox[{{0.15772565101626015`, 36.}, {0.16260162601626016`, 36.}}], 
    LineBox[{{0.15772565101626015`, 38.}, {0.16260162601626016`, 38.}}], 
    LineBox[{{0.15284967601626015`, 40.}, {0.16260162601626016`, 40.}}], 
    LineBox[{{0.15772565101626015`, 42.}, {0.16260162601626016`, 42.}}], 
    LineBox[{{0.15772565101626015`, 44.}, {0.16260162601626016`, 44.}}], 
    LineBox[{{0.15772565101626015`, 46.}, {0.16260162601626016`, 46.}}], 
    LineBox[{{0.15772565101626015`, 48.}, {0.16260162601626016`, 48.}}], 
    LineBox[{{0.15284967601626015`, 50.}, {0.16260162601626016`, 50.}}], 
    LineBox[{{0.15772565101626015`, 52.}, {0.16260162601626016`, 52.}}], 
    LineBox[{{0.15772565101626015`, 54.}, {0.16260162601626016`, 54.}}], 
    LineBox[{{0.15772565101626015`, 56.}, {0.16260162601626016`, 56.}}], 
    LineBox[{{0.15772565101626015`, 58.}, {0.16260162601626016`, 58.}}], 
    LineBox[{{0.15284967601626015`, 60.}, {0.16260162601626016`, 60.}}], 
    LineBox[{{0.15772565101626015`, 62.}, {0.16260162601626016`, 62.}}], 
    LineBox[{{0.15772565101626015`, 64.}, {0.16260162601626016`, 64.}}], 
    LineBox[{{0.15772565101626015`, 66.}, {0.16260162601626016`, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 5.000000000000007}, {0.3300813008130081, 
     5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17, 6.319381470588242}, {0.17, 5.000000000000007}}], 
    LineBox[{{0.17500000000000002`, 7.638762941176478}, {0.17500000000000002`,
      5.000000000000007}}], 
    LineBox[{{0.18000000000000002`, 6.319381470588242}, {0.18000000000000002`,
      5.000000000000007}}], 
    LineBox[{{0.18500000000000003`, 6.319381470588242}, {0.18500000000000003`,
      5.000000000000007}}], 
    LineBox[{{0.19, 6.319381470588242}, {0.19, 5.000000000000007}}], 
    LineBox[{{0.195, 6.319381470588242}, {0.195, 5.000000000000007}}], 
    LineBox[{{0.2, 7.638762941176478}, {0.2, 5.000000000000007}}], 
    LineBox[{{0.20500000000000002`, 6.319381470588242}, {0.20500000000000002`,
      5.000000000000007}}], 
    LineBox[{{0.21000000000000002`, 6.319381470588242}, {0.21000000000000002`,
      5.000000000000007}}], 
    LineBox[{{0.215, 6.319381470588242}, {0.215, 5.000000000000007}}], 
    LineBox[{{0.22, 6.319381470588242}, {0.22, 5.000000000000007}}], 
    LineBox[{{0.225, 7.638762941176478}, {0.225, 5.000000000000007}}], 
    LineBox[{{0.23, 6.319381470588242}, {0.23, 5.000000000000007}}], 
    LineBox[{{0.23500000000000001`, 6.319381470588242}, {0.23500000000000001`,
      5.000000000000007}}], 
    LineBox[{{0.24, 6.319381470588242}, {0.24, 5.000000000000007}}], 
    LineBox[{{0.245, 6.319381470588242}, {0.245, 5.000000000000007}}], 
    LineBox[{{0.25, 7.638762941176478}, {0.25, 5.000000000000007}}], 
    LineBox[{{0.255, 6.319381470588242}, {0.255, 5.000000000000007}}], 
    LineBox[{{0.26, 6.319381470588242}, {0.26, 5.000000000000007}}], 
    LineBox[{{0.265, 6.319381470588242}, {0.265, 5.000000000000007}}], 
    LineBox[{{0.27, 6.319381470588242}, {0.27, 5.000000000000007}}], 
    LineBox[{{0.275, 7.638762941176478}, {0.275, 5.000000000000007}}], 
    LineBox[{{0.28, 6.319381470588242}, {0.28, 5.000000000000007}}], 
    LineBox[{{0.28500000000000003`, 6.319381470588242}, {0.28500000000000003`,
      5.000000000000007}}], 
    LineBox[{{0.29000000000000004`, 6.319381470588242}, {0.29000000000000004`,
      5.000000000000007}}], 
    LineBox[{{0.29500000000000004`, 6.319381470588242}, {0.29500000000000004`,
      5.000000000000007}}], 
    LineBox[{{0.30000000000000004`, 7.638762941176478}, {0.30000000000000004`,
      5.000000000000007}}], 
    LineBox[{{0.30500000000000005`, 6.319381470588242}, {0.30500000000000005`,
      5.000000000000007}}], 
    LineBox[{{0.31000000000000005`, 6.319381470588242}, {0.31000000000000005`,
      5.000000000000007}}], 
    LineBox[{{0.31500000000000006`, 6.319381470588242}, {0.31500000000000006`,
      5.000000000000007}}], 
    LineBox[{{0.32000000000000006`, 6.319381470588242}, {0.32000000000000006`,
      5.000000000000007}}], 
    LineBox[{{0.325, 7.638762941176478}, {0.325, 5.000000000000007}}], 
    LineBox[{{0.33, 6.319381470588242}, {0.33, 5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 5.000000000000007}, {0.16747967479674797`,
      67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17235564979674797`, 6.}, {0.16747967479674797`, 6.}}], 
    LineBox[{{0.17235564979674797`, 8.}, {0.16747967479674797`, 8.}}], 
    LineBox[{{0.17723162479674798`, 10.}, {0.16747967479674797`, 10.}}], 
    LineBox[{{0.17235564979674797`, 12.}, {0.16747967479674797`, 12.}}], 
    LineBox[{{0.17235564979674797`, 14.}, {0.16747967479674797`, 14.}}], 
    LineBox[{{0.17235564979674797`, 16.}, {0.16747967479674797`, 16.}}], 
    LineBox[{{0.17235564979674797`, 18.}, {0.16747967479674797`, 18.}}], 
    LineBox[{{0.17723162479674798`, 20.}, {0.16747967479674797`, 20.}}], 
    LineBox[{{0.17235564979674797`, 22.}, {0.16747967479674797`, 22.}}], 
    LineBox[{{0.17235564979674797`, 24.}, {0.16747967479674797`, 24.}}], 
    LineBox[{{0.17235564979674797`, 26.}, {0.16747967479674797`, 26.}}], 
    LineBox[{{0.17235564979674797`, 28.}, {0.16747967479674797`, 28.}}], 
    LineBox[{{0.17723162479674798`, 30.}, {0.16747967479674797`, 30.}}], 
    LineBox[{{0.17235564979674797`, 32.}, {0.16747967479674797`, 32.}}], 
    LineBox[{{0.17235564979674797`, 34.}, {0.16747967479674797`, 34.}}], 
    LineBox[{{0.17235564979674797`, 36.}, {0.16747967479674797`, 36.}}], 
    LineBox[{{0.17235564979674797`, 38.}, {0.16747967479674797`, 38.}}], 
    LineBox[{{0.17723162479674798`, 40.}, {0.16747967479674797`, 40.}}], 
    LineBox[{{0.17235564979674797`, 42.}, {0.16747967479674797`, 42.}}], 
    LineBox[{{0.17235564979674797`, 44.}, {0.16747967479674797`, 44.}}], 
    LineBox[{{0.17235564979674797`, 46.}, {0.16747967479674797`, 46.}}], 
    LineBox[{{0.17235564979674797`, 48.}, {0.16747967479674797`, 48.}}], 
    LineBox[{{0.17723162479674798`, 50.}, {0.16747967479674797`, 50.}}], 
    LineBox[{{0.17235564979674797`, 52.}, {0.16747967479674797`, 52.}}], 
    LineBox[{{0.17235564979674797`, 54.}, {0.16747967479674797`, 54.}}], 
    LineBox[{{0.17235564979674797`, 56.}, {0.16747967479674797`, 56.}}], 
    LineBox[{{0.17235564979674797`, 58.}, {0.16747967479674797`, 58.}}], 
    LineBox[{{0.17723162479674798`, 60.}, {0.16747967479674797`, 60.}}], 
    LineBox[{{0.17235564979674797`, 62.}, {0.16747967479674797`, 62.}}], 
    LineBox[{{0.17235564979674797`, 64.}, {0.16747967479674797`, 64.}}], 
    LineBox[{{0.17235564979674797`, 66.}, {0.16747967479674797`, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.16747967479674797`, 67.09150326797386}, {0.3300813008130081, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.17, 65.77212179738562}, {0.17, 67.09150326797386}}], 
    LineBox[{{0.17500000000000002`, 64.4527403267974}, {0.17500000000000002`, 
     67.09150326797386}}], 
    LineBox[{{0.18000000000000002`, 65.77212179738562}, {0.18000000000000002`,
      67.09150326797386}}], 
    LineBox[{{0.18500000000000003`, 65.77212179738562}, {0.18500000000000003`,
      67.09150326797386}}], 
    LineBox[{{0.19, 65.77212179738562}, {0.19, 67.09150326797386}}], 
    LineBox[{{0.195, 65.77212179738562}, {0.195, 67.09150326797386}}], 
    LineBox[{{0.2, 64.4527403267974}, {0.2, 67.09150326797386}}], 
    LineBox[{{0.20500000000000002`, 65.77212179738562}, {0.20500000000000002`,
      67.09150326797386}}], 
    LineBox[{{0.21000000000000002`, 65.77212179738562}, {0.21000000000000002`,
      67.09150326797386}}], 
    LineBox[{{0.215, 65.77212179738562}, {0.215, 67.09150326797386}}], 
    LineBox[{{0.22, 65.77212179738562}, {0.22, 67.09150326797386}}], 
    LineBox[{{0.225, 64.4527403267974}, {0.225, 67.09150326797386}}], 
    LineBox[{{0.23, 65.77212179738562}, {0.23, 67.09150326797386}}], 
    LineBox[{{0.23500000000000001`, 65.77212179738562}, {0.23500000000000001`,
      67.09150326797386}}], 
    LineBox[{{0.24, 65.77212179738562}, {0.24, 67.09150326797386}}], 
    LineBox[{{0.245, 65.77212179738562}, {0.245, 67.09150326797386}}], 
    LineBox[{{0.25, 64.4527403267974}, {0.25, 67.09150326797386}}], 
    LineBox[{{0.255, 65.77212179738562}, {0.255, 67.09150326797386}}], 
    LineBox[{{0.26, 65.77212179738562}, {0.26, 67.09150326797386}}], 
    LineBox[{{0.265, 65.77212179738562}, {0.265, 67.09150326797386}}], 
    LineBox[{{0.27, 65.77212179738562}, {0.27, 67.09150326797386}}], 
    LineBox[{{0.275, 64.4527403267974}, {0.275, 67.09150326797386}}], 
    LineBox[{{0.28, 65.77212179738562}, {0.28, 67.09150326797386}}], 
    LineBox[{{0.28500000000000003`, 65.77212179738562}, {0.28500000000000003`,
      67.09150326797386}}], 
    LineBox[{{0.29000000000000004`, 65.77212179738562}, {0.29000000000000004`,
      67.09150326797386}}], 
    LineBox[{{0.29500000000000004`, 65.77212179738562}, {0.29500000000000004`,
      67.09150326797386}}], 
    LineBox[{{0.30000000000000004`, 64.4527403267974}, {0.30000000000000004`, 
     67.09150326797386}}], 
    LineBox[{{0.30500000000000005`, 65.77212179738562}, {0.30500000000000005`,
      67.09150326797386}}], 
    LineBox[{{0.31000000000000005`, 65.77212179738562}, {0.31000000000000005`,
      67.09150326797386}}], 
    LineBox[{{0.31500000000000006`, 65.77212179738562}, {0.31500000000000006`,
      67.09150326797386}}], 
    LineBox[{{0.32000000000000006`, 65.77212179738562}, {0.32000000000000006`,
      67.09150326797386}}], 
    LineBox[{{0.325, 64.4527403267974}, {0.325, 67.09150326797386}}], 
    LineBox[{{0.33, 65.77212179738562}, {0.33, 67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.3300813008130081, 5.000000000000007}, {0.3300813008130081, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.32520532581300815`, 6.}, {0.3300813008130081, 6.}}], 
    LineBox[{{0.32520532581300815`, 8.}, {0.3300813008130081, 8.}}], 
    LineBox[{{0.3203293508130081, 10.}, {0.3300813008130081, 10.}}], 
    LineBox[{{0.32520532581300815`, 12.}, {0.3300813008130081, 12.}}], 
    LineBox[{{0.32520532581300815`, 14.}, {0.3300813008130081, 14.}}], 
    LineBox[{{0.32520532581300815`, 16.}, {0.3300813008130081, 16.}}], 
    LineBox[{{0.32520532581300815`, 18.}, {0.3300813008130081, 18.}}], 
    LineBox[{{0.3203293508130081, 20.}, {0.3300813008130081, 20.}}], 
    LineBox[{{0.32520532581300815`, 22.}, {0.3300813008130081, 22.}}], 
    LineBox[{{0.32520532581300815`, 24.}, {0.3300813008130081, 24.}}], 
    LineBox[{{0.32520532581300815`, 26.}, {0.3300813008130081, 26.}}], 
    LineBox[{{0.32520532581300815`, 28.}, {0.3300813008130081, 28.}}], 
    LineBox[{{0.3203293508130081, 30.}, {0.3300813008130081, 30.}}], 
    LineBox[{{0.32520532581300815`, 32.}, {0.3300813008130081, 32.}}], 
    LineBox[{{0.32520532581300815`, 34.}, {0.3300813008130081, 34.}}], 
    LineBox[{{0.32520532581300815`, 36.}, {0.3300813008130081, 36.}}], 
    LineBox[{{0.32520532581300815`, 38.}, {0.3300813008130081, 38.}}], 
    LineBox[{{0.3203293508130081, 40.}, {0.3300813008130081, 40.}}], 
    LineBox[{{0.32520532581300815`, 42.}, {0.3300813008130081, 42.}}], 
    LineBox[{{0.32520532581300815`, 44.}, {0.3300813008130081, 44.}}], 
    LineBox[{{0.32520532581300815`, 46.}, {0.3300813008130081, 46.}}], 
    LineBox[{{0.32520532581300815`, 48.}, {0.3300813008130081, 48.}}], 
    LineBox[{{0.3203293508130081, 50.}, {0.3300813008130081, 50.}}], 
    LineBox[{{0.32520532581300815`, 52.}, {0.3300813008130081, 52.}}], 
    LineBox[{{0.32520532581300815`, 54.}, {0.3300813008130081, 54.}}], 
    LineBox[{{0.32520532581300815`, 56.}, {0.3300813008130081, 56.}}], 
    LineBox[{{0.32520532581300815`, 58.}, {0.3300813008130081, 58.}}], 
    LineBox[{{0.3203293508130081, 60.}, {0.3300813008130081, 60.}}], 
    LineBox[{{0.32520532581300815`, 62.}, {0.3300813008130081, 62.}}], 
    LineBox[{{0.32520532581300815`, 64.}, {0.3300813008130081, 64.}}], 
    LineBox[{{0.32520532581300815`, 66.}, {0.3300813008130081, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 5.000000000000007}, {0.4975609756097561, 
     5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.335, 6.319381470588242}, {0.335, 5.000000000000007}}], 
    LineBox[{{0.34, 6.319381470588242}, {0.34, 5.000000000000007}}], 
    LineBox[{{0.34500000000000003`, 6.319381470588242}, {0.34500000000000003`,
      5.000000000000007}}], 
    LineBox[{{0.35000000000000003`, 7.638762941176478}, {0.35000000000000003`,
      5.000000000000007}}], 
    LineBox[{{0.35500000000000004`, 6.319381470588242}, {0.35500000000000004`,
      5.000000000000007}}], 
    LineBox[{{0.36000000000000004`, 6.319381470588242}, {0.36000000000000004`,
      5.000000000000007}}], 
    LineBox[{{0.365, 6.319381470588242}, {0.365, 5.000000000000007}}], 
    LineBox[{{0.37, 6.319381470588242}, {0.37, 5.000000000000007}}], 
    LineBox[{{0.375, 7.638762941176478}, {0.375, 5.000000000000007}}], 
    LineBox[{{0.38, 6.319381470588242}, {0.38, 5.000000000000007}}], 
    LineBox[{{0.385, 6.319381470588242}, {0.385, 5.000000000000007}}], 
    LineBox[{{0.38999999999999996`, 6.319381470588242}, {0.38999999999999996`,
      5.000000000000007}}], 
    LineBox[{{0.39499999999999996`, 6.319381470588242}, {0.39499999999999996`,
      5.000000000000007}}], 
    LineBox[{{0.4, 7.638762941176478}, {0.4, 5.000000000000007}}], 
    LineBox[{{0.405, 6.319381470588242}, {0.405, 5.000000000000007}}], 
    LineBox[{{0.41000000000000003`, 6.319381470588242}, {0.41000000000000003`,
      5.000000000000007}}], 
    LineBox[{{0.415, 6.319381470588242}, {0.415, 5.000000000000007}}], 
    LineBox[{{0.42, 6.319381470588242}, {0.42, 5.000000000000007}}], 
    LineBox[{{0.42500000000000004`, 7.638762941176478}, {0.42500000000000004`,
      5.000000000000007}}], 
    LineBox[{{0.43000000000000005`, 6.319381470588242}, {0.43000000000000005`,
      5.000000000000007}}], 
    LineBox[{{0.43500000000000005`, 6.319381470588242}, {0.43500000000000005`,
      5.000000000000007}}], 
    LineBox[{{0.44, 6.319381470588242}, {0.44, 5.000000000000007}}], 
    LineBox[{{0.445, 6.319381470588242}, {0.445, 5.000000000000007}}], 
    LineBox[{{0.45, 7.638762941176478}, {0.45, 5.000000000000007}}], 
    LineBox[{{0.455, 6.319381470588242}, {0.455, 5.000000000000007}}], 
    LineBox[{{0.46, 6.319381470588242}, {0.46, 5.000000000000007}}], 
    LineBox[{{0.46499999999999997`, 6.319381470588242}, {0.46499999999999997`,
      5.000000000000007}}], 
    LineBox[{{0.47, 6.319381470588242}, {0.47, 5.000000000000007}}], 
    LineBox[{{0.47500000000000003`, 7.638762941176478}, {0.47500000000000003`,
      5.000000000000007}}], 
    LineBox[{{0.48000000000000004`, 6.319381470588242}, {0.48000000000000004`,
      5.000000000000007}}], 
    LineBox[{{0.48500000000000004`, 6.319381470588242}, {0.48500000000000004`,
      5.000000000000007}}], 
    LineBox[{{0.49000000000000005`, 6.319381470588242}, {0.49000000000000005`,
      5.000000000000007}}], 
    LineBox[{{0.49500000000000005`, 6.319381470588242}, {0.49500000000000005`,
      5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 5.000000000000007}, {0.33495934959349594`,
      67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.3398353245934959, 6.}, {0.33495934959349594`, 6.}}], 
    LineBox[{{0.3398353245934959, 8.}, {0.33495934959349594`, 8.}}], 
    LineBox[{{0.34471129959349595`, 10.}, {0.33495934959349594`, 10.}}], 
    LineBox[{{0.3398353245934959, 12.}, {0.33495934959349594`, 12.}}], 
    LineBox[{{0.3398353245934959, 14.}, {0.33495934959349594`, 14.}}], 
    LineBox[{{0.3398353245934959, 16.}, {0.33495934959349594`, 16.}}], 
    LineBox[{{0.3398353245934959, 18.}, {0.33495934959349594`, 18.}}], 
    LineBox[{{0.34471129959349595`, 20.}, {0.33495934959349594`, 20.}}], 
    LineBox[{{0.3398353245934959, 22.}, {0.33495934959349594`, 22.}}], 
    LineBox[{{0.3398353245934959, 24.}, {0.33495934959349594`, 24.}}], 
    LineBox[{{0.3398353245934959, 26.}, {0.33495934959349594`, 26.}}], 
    LineBox[{{0.3398353245934959, 28.}, {0.33495934959349594`, 28.}}], 
    LineBox[{{0.34471129959349595`, 30.}, {0.33495934959349594`, 30.}}], 
    LineBox[{{0.3398353245934959, 32.}, {0.33495934959349594`, 32.}}], 
    LineBox[{{0.3398353245934959, 34.}, {0.33495934959349594`, 34.}}], 
    LineBox[{{0.3398353245934959, 36.}, {0.33495934959349594`, 36.}}], 
    LineBox[{{0.3398353245934959, 38.}, {0.33495934959349594`, 38.}}], 
    LineBox[{{0.34471129959349595`, 40.}, {0.33495934959349594`, 40.}}], 
    LineBox[{{0.3398353245934959, 42.}, {0.33495934959349594`, 42.}}], 
    LineBox[{{0.3398353245934959, 44.}, {0.33495934959349594`, 44.}}], 
    LineBox[{{0.3398353245934959, 46.}, {0.33495934959349594`, 46.}}], 
    LineBox[{{0.3398353245934959, 48.}, {0.33495934959349594`, 48.}}], 
    LineBox[{{0.34471129959349595`, 50.}, {0.33495934959349594`, 50.}}], 
    LineBox[{{0.3398353245934959, 52.}, {0.33495934959349594`, 52.}}], 
    LineBox[{{0.3398353245934959, 54.}, {0.33495934959349594`, 54.}}], 
    LineBox[{{0.3398353245934959, 56.}, {0.33495934959349594`, 56.}}], 
    LineBox[{{0.3398353245934959, 58.}, {0.33495934959349594`, 58.}}], 
    LineBox[{{0.34471129959349595`, 60.}, {0.33495934959349594`, 60.}}], 
    LineBox[{{0.3398353245934959, 62.}, {0.33495934959349594`, 62.}}], 
    LineBox[{{0.3398353245934959, 64.}, {0.33495934959349594`, 64.}}], 
    LineBox[{{0.3398353245934959, 66.}, {0.33495934959349594`, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.33495934959349594`, 67.09150326797386}, {0.4975609756097561, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.335, 65.77212179738562}, {0.335, 67.09150326797386}}], 
    LineBox[{{0.34, 65.77212179738562}, {0.34, 67.09150326797386}}], 
    LineBox[{{0.34500000000000003`, 65.77212179738562}, {0.34500000000000003`,
      67.09150326797386}}], 
    LineBox[{{0.35000000000000003`, 64.4527403267974}, {0.35000000000000003`, 
     67.09150326797386}}], 
    LineBox[{{0.35500000000000004`, 65.77212179738562}, {0.35500000000000004`,
      67.09150326797386}}], 
    LineBox[{{0.36000000000000004`, 65.77212179738562}, {0.36000000000000004`,
      67.09150326797386}}], 
    LineBox[{{0.365, 65.77212179738562}, {0.365, 67.09150326797386}}], 
    LineBox[{{0.37, 65.77212179738562}, {0.37, 67.09150326797386}}], 
    LineBox[{{0.375, 64.4527403267974}, {0.375, 67.09150326797386}}], 
    LineBox[{{0.38, 65.77212179738562}, {0.38, 67.09150326797386}}], 
    LineBox[{{0.385, 65.77212179738562}, {0.385, 67.09150326797386}}], 
    LineBox[{{0.38999999999999996`, 65.77212179738562}, {0.38999999999999996`,
      67.09150326797386}}], 
    LineBox[{{0.39499999999999996`, 65.77212179738562}, {0.39499999999999996`,
      67.09150326797386}}], 
    LineBox[{{0.4, 64.4527403267974}, {0.4, 67.09150326797386}}], 
    LineBox[{{0.405, 65.77212179738562}, {0.405, 67.09150326797386}}], 
    LineBox[{{0.41000000000000003`, 65.77212179738562}, {0.41000000000000003`,
      67.09150326797386}}], 
    LineBox[{{0.415, 65.77212179738562}, {0.415, 67.09150326797386}}], 
    LineBox[{{0.42, 65.77212179738562}, {0.42, 67.09150326797386}}], 
    LineBox[{{0.42500000000000004`, 64.4527403267974}, {0.42500000000000004`, 
     67.09150326797386}}], 
    LineBox[{{0.43000000000000005`, 65.77212179738562}, {0.43000000000000005`,
      67.09150326797386}}], 
    LineBox[{{0.43500000000000005`, 65.77212179738562}, {0.43500000000000005`,
      67.09150326797386}}], 
    LineBox[{{0.44, 65.77212179738562}, {0.44, 67.09150326797386}}], 
    LineBox[{{0.445, 65.77212179738562}, {0.445, 67.09150326797386}}], 
    LineBox[{{0.45, 64.4527403267974}, {0.45, 67.09150326797386}}], 
    LineBox[{{0.455, 65.77212179738562}, {0.455, 67.09150326797386}}], 
    LineBox[{{0.46, 65.77212179738562}, {0.46, 67.09150326797386}}], 
    LineBox[{{0.46499999999999997`, 65.77212179738562}, {0.46499999999999997`,
      67.09150326797386}}], 
    LineBox[{{0.47, 65.77212179738562}, {0.47, 67.09150326797386}}], 
    LineBox[{{0.47500000000000003`, 64.4527403267974}, {0.47500000000000003`, 
     67.09150326797386}}], 
    LineBox[{{0.48000000000000004`, 65.77212179738562}, {0.48000000000000004`,
      67.09150326797386}}], 
    LineBox[{{0.48500000000000004`, 65.77212179738562}, {0.48500000000000004`,
      67.09150326797386}}], 
    LineBox[{{0.49000000000000005`, 65.77212179738562}, {0.49000000000000005`,
      67.09150326797386}}], 
    LineBox[{{0.49500000000000005`, 65.77212179738562}, {0.49500000000000005`,
      67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.4975609756097561, 5.000000000000007}, {0.4975609756097561, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.4926850006097561, 6.}, {0.4975609756097561, 6.}}], 
    LineBox[{{0.4926850006097561, 8.}, {0.4975609756097561, 8.}}], 
    LineBox[{{0.4878090256097561, 10.}, {0.4975609756097561, 10.}}], 
    LineBox[{{0.4926850006097561, 12.}, {0.4975609756097561, 12.}}], 
    LineBox[{{0.4926850006097561, 14.}, {0.4975609756097561, 14.}}], 
    LineBox[{{0.4926850006097561, 16.}, {0.4975609756097561, 16.}}], 
    LineBox[{{0.4926850006097561, 18.}, {0.4975609756097561, 18.}}], 
    LineBox[{{0.4878090256097561, 20.}, {0.4975609756097561, 20.}}], 
    LineBox[{{0.4926850006097561, 22.}, {0.4975609756097561, 22.}}], 
    LineBox[{{0.4926850006097561, 24.}, {0.4975609756097561, 24.}}], 
    LineBox[{{0.4926850006097561, 26.}, {0.4975609756097561, 26.}}], 
    LineBox[{{0.4926850006097561, 28.}, {0.4975609756097561, 28.}}], 
    LineBox[{{0.4878090256097561, 30.}, {0.4975609756097561, 30.}}], 
    LineBox[{{0.4926850006097561, 32.}, {0.4975609756097561, 32.}}], 
    LineBox[{{0.4926850006097561, 34.}, {0.4975609756097561, 34.}}], 
    LineBox[{{0.4926850006097561, 36.}, {0.4975609756097561, 36.}}], 
    LineBox[{{0.4926850006097561, 38.}, {0.4975609756097561, 38.}}], 
    LineBox[{{0.4878090256097561, 40.}, {0.4975609756097561, 40.}}], 
    LineBox[{{0.4926850006097561, 42.}, {0.4975609756097561, 42.}}], 
    LineBox[{{0.4926850006097561, 44.}, {0.4975609756097561, 44.}}], 
    LineBox[{{0.4926850006097561, 46.}, {0.4975609756097561, 46.}}], 
    LineBox[{{0.4926850006097561, 48.}, {0.4975609756097561, 48.}}], 
    LineBox[{{0.4878090256097561, 50.}, {0.4975609756097561, 50.}}], 
    LineBox[{{0.4926850006097561, 52.}, {0.4975609756097561, 52.}}], 
    LineBox[{{0.4926850006097561, 54.}, {0.4975609756097561, 54.}}], 
    LineBox[{{0.4926850006097561, 56.}, {0.4975609756097561, 56.}}], 
    LineBox[{{0.4926850006097561, 58.}, {0.4975609756097561, 58.}}], 
    LineBox[{{0.4878090256097561, 60.}, {0.4975609756097561, 60.}}], 
    LineBox[{{0.4926850006097561, 62.}, {0.4975609756097561, 62.}}], 
    LineBox[{{0.4926850006097561, 64.}, {0.4975609756097561, 64.}}], 
    LineBox[{{0.4926850006097561, 66.}, {0.4975609756097561, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 5.000000000000007}, {0.6650406504065041, 
     5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.505, 6.319381470588242}, {0.505, 5.000000000000007}}], 
    LineBox[{{0.51, 6.319381470588242}, {0.51, 5.000000000000007}}], 
    LineBox[{{0.515, 6.319381470588242}, {0.515, 5.000000000000007}}], 
    LineBox[{{0.52, 6.319381470588242}, {0.52, 5.000000000000007}}], 
    LineBox[{{0.525, 7.638762941176478}, {0.525, 5.000000000000007}}], 
    LineBox[{{0.53, 6.319381470588242}, {0.53, 5.000000000000007}}], 
    LineBox[{{0.535, 6.319381470588242}, {0.535, 5.000000000000007}}], 
    LineBox[{{0.54, 6.319381470588242}, {0.54, 5.000000000000007}}], 
    LineBox[{{0.545, 6.319381470588242}, {0.545, 5.000000000000007}}], 
    LineBox[{{0.55, 7.638762941176478}, {0.55, 5.000000000000007}}], 
    LineBox[{{0.555, 6.319381470588242}, {0.555, 5.000000000000007}}], 
    LineBox[{{0.56, 6.319381470588242}, {0.56, 5.000000000000007}}], 
    LineBox[{{0.5650000000000001, 6.319381470588242}, {0.5650000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.5700000000000001, 6.319381470588242}, {0.5700000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.5750000000000001, 7.638762941176478}, {0.5750000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.5800000000000001, 6.319381470588242}, {0.5800000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.5850000000000001, 6.319381470588242}, {0.5850000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.5900000000000001, 6.319381470588242}, {0.5900000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.5950000000000001, 6.319381470588242}, {0.5950000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.6000000000000001, 7.638762941176478}, {0.6000000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.6050000000000001, 6.319381470588242}, {0.6050000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.6100000000000001, 6.319381470588242}, {0.6100000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.6150000000000001, 6.319381470588242}, {0.6150000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.6200000000000001, 6.319381470588242}, {0.6200000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.625, 7.638762941176478}, {0.625, 5.000000000000007}}], 
    LineBox[{{0.63, 6.319381470588242}, {0.63, 5.000000000000007}}], 
    LineBox[{{0.635, 6.319381470588242}, {0.635, 5.000000000000007}}], 
    LineBox[{{0.64, 6.319381470588242}, {0.64, 5.000000000000007}}], 
    LineBox[{{0.645, 6.319381470588242}, {0.645, 5.000000000000007}}], 
    LineBox[{{0.65, 7.638762941176478}, {0.65, 5.000000000000007}}], 
    LineBox[{{0.655, 6.319381470588242}, {0.655, 5.000000000000007}}], 
    LineBox[{{0.66, 6.319381470588242}, {0.66, 5.000000000000007}}], 
    LineBox[{{0.665, 6.319381470588242}, {0.665, 5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 5.000000000000007}, {0.5024390243902439, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5073149993902439, 6.}, {0.5024390243902439, 6.}}], 
    LineBox[{{0.5073149993902439, 8.}, {0.5024390243902439, 8.}}], 
    LineBox[{{0.5121909743902439, 10.}, {0.5024390243902439, 10.}}], 
    LineBox[{{0.5073149993902439, 12.}, {0.5024390243902439, 12.}}], 
    LineBox[{{0.5073149993902439, 14.}, {0.5024390243902439, 14.}}], 
    LineBox[{{0.5073149993902439, 16.}, {0.5024390243902439, 16.}}], 
    LineBox[{{0.5073149993902439, 18.}, {0.5024390243902439, 18.}}], 
    LineBox[{{0.5121909743902439, 20.}, {0.5024390243902439, 20.}}], 
    LineBox[{{0.5073149993902439, 22.}, {0.5024390243902439, 22.}}], 
    LineBox[{{0.5073149993902439, 24.}, {0.5024390243902439, 24.}}], 
    LineBox[{{0.5073149993902439, 26.}, {0.5024390243902439, 26.}}], 
    LineBox[{{0.5073149993902439, 28.}, {0.5024390243902439, 28.}}], 
    LineBox[{{0.5121909743902439, 30.}, {0.5024390243902439, 30.}}], 
    LineBox[{{0.5073149993902439, 32.}, {0.5024390243902439, 32.}}], 
    LineBox[{{0.5073149993902439, 34.}, {0.5024390243902439, 34.}}], 
    LineBox[{{0.5073149993902439, 36.}, {0.5024390243902439, 36.}}], 
    LineBox[{{0.5073149993902439, 38.}, {0.5024390243902439, 38.}}], 
    LineBox[{{0.5121909743902439, 40.}, {0.5024390243902439, 40.}}], 
    LineBox[{{0.5073149993902439, 42.}, {0.5024390243902439, 42.}}], 
    LineBox[{{0.5073149993902439, 44.}, {0.5024390243902439, 44.}}], 
    LineBox[{{0.5073149993902439, 46.}, {0.5024390243902439, 46.}}], 
    LineBox[{{0.5073149993902439, 48.}, {0.5024390243902439, 48.}}], 
    LineBox[{{0.5121909743902439, 50.}, {0.5024390243902439, 50.}}], 
    LineBox[{{0.5073149993902439, 52.}, {0.5024390243902439, 52.}}], 
    LineBox[{{0.5073149993902439, 54.}, {0.5024390243902439, 54.}}], 
    LineBox[{{0.5073149993902439, 56.}, {0.5024390243902439, 56.}}], 
    LineBox[{{0.5073149993902439, 58.}, {0.5024390243902439, 58.}}], 
    LineBox[{{0.5121909743902439, 60.}, {0.5024390243902439, 60.}}], 
    LineBox[{{0.5073149993902439, 62.}, {0.5024390243902439, 62.}}], 
    LineBox[{{0.5073149993902439, 64.}, {0.5024390243902439, 64.}}], 
    LineBox[{{0.5073149993902439, 66.}, {0.5024390243902439, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.5024390243902439, 67.09150326797386}, {0.6650406504065041, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.505, 65.77212179738562}, {0.505, 67.09150326797386}}], 
    LineBox[{{0.51, 65.77212179738562}, {0.51, 67.09150326797386}}], 
    LineBox[{{0.515, 65.77212179738562}, {0.515, 67.09150326797386}}], 
    LineBox[{{0.52, 65.77212179738562}, {0.52, 67.09150326797386}}], 
    LineBox[{{0.525, 64.4527403267974}, {0.525, 67.09150326797386}}], 
    LineBox[{{0.53, 65.77212179738562}, {0.53, 67.09150326797386}}], 
    LineBox[{{0.535, 65.77212179738562}, {0.535, 67.09150326797386}}], 
    LineBox[{{0.54, 65.77212179738562}, {0.54, 67.09150326797386}}], 
    LineBox[{{0.545, 65.77212179738562}, {0.545, 67.09150326797386}}], 
    LineBox[{{0.55, 64.4527403267974}, {0.55, 67.09150326797386}}], 
    LineBox[{{0.555, 65.77212179738562}, {0.555, 67.09150326797386}}], 
    LineBox[{{0.56, 65.77212179738562}, {0.56, 67.09150326797386}}], 
    LineBox[{{0.5650000000000001, 65.77212179738562}, {0.5650000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.5700000000000001, 65.77212179738562}, {0.5700000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.5750000000000001, 64.4527403267974}, {0.5750000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.5800000000000001, 65.77212179738562}, {0.5800000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.5850000000000001, 65.77212179738562}, {0.5850000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.5900000000000001, 65.77212179738562}, {0.5900000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.5950000000000001, 65.77212179738562}, {0.5950000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.6000000000000001, 64.4527403267974}, {0.6000000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.6050000000000001, 65.77212179738562}, {0.6050000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.6100000000000001, 65.77212179738562}, {0.6100000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.6150000000000001, 65.77212179738562}, {0.6150000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.6200000000000001, 65.77212179738562}, {0.6200000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.625, 64.4527403267974}, {0.625, 67.09150326797386}}], 
    LineBox[{{0.63, 65.77212179738562}, {0.63, 67.09150326797386}}], 
    LineBox[{{0.635, 65.77212179738562}, {0.635, 67.09150326797386}}], 
    LineBox[{{0.64, 65.77212179738562}, {0.64, 67.09150326797386}}], 
    LineBox[{{0.645, 65.77212179738562}, {0.645, 67.09150326797386}}], 
    LineBox[{{0.65, 64.4527403267974}, {0.65, 67.09150326797386}}], 
    LineBox[{{0.655, 65.77212179738562}, {0.655, 67.09150326797386}}], 
    LineBox[{{0.66, 65.77212179738562}, {0.66, 67.09150326797386}}], 
    LineBox[{{0.665, 65.77212179738562}, {0.665, 67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6650406504065041, 5.000000000000007}, {0.6650406504065041, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.660164675406504, 6.}, {0.6650406504065041, 6.}}], 
    LineBox[{{0.660164675406504, 8.}, {0.6650406504065041, 8.}}], 
    LineBox[{{0.6552887004065041, 10.}, {0.6650406504065041, 10.}}], 
    LineBox[{{0.660164675406504, 12.}, {0.6650406504065041, 12.}}], 
    LineBox[{{0.660164675406504, 14.}, {0.6650406504065041, 14.}}], 
    LineBox[{{0.660164675406504, 16.}, {0.6650406504065041, 16.}}], 
    LineBox[{{0.660164675406504, 18.}, {0.6650406504065041, 18.}}], 
    LineBox[{{0.6552887004065041, 20.}, {0.6650406504065041, 20.}}], 
    LineBox[{{0.660164675406504, 22.}, {0.6650406504065041, 22.}}], 
    LineBox[{{0.660164675406504, 24.}, {0.6650406504065041, 24.}}], 
    LineBox[{{0.660164675406504, 26.}, {0.6650406504065041, 26.}}], 
    LineBox[{{0.660164675406504, 28.}, {0.6650406504065041, 28.}}], 
    LineBox[{{0.6552887004065041, 30.}, {0.6650406504065041, 30.}}], 
    LineBox[{{0.660164675406504, 32.}, {0.6650406504065041, 32.}}], 
    LineBox[{{0.660164675406504, 34.}, {0.6650406504065041, 34.}}], 
    LineBox[{{0.660164675406504, 36.}, {0.6650406504065041, 36.}}], 
    LineBox[{{0.660164675406504, 38.}, {0.6650406504065041, 38.}}], 
    LineBox[{{0.6552887004065041, 40.}, {0.6650406504065041, 40.}}], 
    LineBox[{{0.660164675406504, 42.}, {0.6650406504065041, 42.}}], 
    LineBox[{{0.660164675406504, 44.}, {0.6650406504065041, 44.}}], 
    LineBox[{{0.660164675406504, 46.}, {0.6650406504065041, 46.}}], 
    LineBox[{{0.660164675406504, 48.}, {0.6650406504065041, 48.}}], 
    LineBox[{{0.6552887004065041, 50.}, {0.6650406504065041, 50.}}], 
    LineBox[{{0.660164675406504, 52.}, {0.6650406504065041, 52.}}], 
    LineBox[{{0.660164675406504, 54.}, {0.6650406504065041, 54.}}], 
    LineBox[{{0.660164675406504, 56.}, {0.6650406504065041, 56.}}], 
    LineBox[{{0.660164675406504, 58.}, {0.6650406504065041, 58.}}], 
    LineBox[{{0.6552887004065041, 60.}, {0.6650406504065041, 60.}}], 
    LineBox[{{0.660164675406504, 62.}, {0.6650406504065041, 62.}}], 
    LineBox[{{0.660164675406504, 64.}, {0.6650406504065041, 64.}}], 
    LineBox[{{0.660164675406504, 66.}, {0.6650406504065041, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 5.000000000000007}, {0.832520325203252, 
     5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.67, 6.319381470588242}, {0.67, 5.000000000000007}}], 
    LineBox[{{0.675, 7.638762941176478}, {0.675, 5.000000000000007}}], 
    LineBox[{{0.68, 6.319381470588242}, {0.68, 5.000000000000007}}], 
    LineBox[{{0.685, 6.319381470588242}, {0.685, 5.000000000000007}}], 
    LineBox[{{0.6900000000000001, 6.319381470588242}, {0.6900000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.6950000000000001, 6.319381470588242}, {0.6950000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7000000000000001, 7.638762941176478}, {0.7000000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7050000000000001, 6.319381470588242}, {0.7050000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7100000000000001, 6.319381470588242}, {0.7100000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7150000000000001, 6.319381470588242}, {0.7150000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7200000000000001, 6.319381470588242}, {0.7200000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7250000000000001, 7.638762941176478}, {0.7250000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7300000000000001, 6.319381470588242}, {0.7300000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7350000000000001, 6.319381470588242}, {0.7350000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7400000000000001, 6.319381470588242}, {0.7400000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.7450000000000001, 6.319381470588242}, {0.7450000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.75, 7.638762941176478}, {0.75, 5.000000000000007}}], 
    LineBox[{{0.755, 6.319381470588242}, {0.755, 5.000000000000007}}], 
    LineBox[{{0.76, 6.319381470588242}, {0.76, 5.000000000000007}}], 
    LineBox[{{0.765, 6.319381470588242}, {0.765, 5.000000000000007}}], 
    LineBox[{{0.77, 6.319381470588242}, {0.77, 5.000000000000007}}], 
    LineBox[{{0.775, 7.638762941176478}, {0.775, 5.000000000000007}}], 
    LineBox[{{0.78, 6.319381470588242}, {0.78, 5.000000000000007}}], 
    LineBox[{{0.785, 6.319381470588242}, {0.785, 5.000000000000007}}], 
    LineBox[{{0.79, 6.319381470588242}, {0.79, 5.000000000000007}}], 
    LineBox[{{0.795, 6.319381470588242}, {0.795, 5.000000000000007}}], 
    LineBox[{{0.8, 7.638762941176478}, {0.8, 5.000000000000007}}], 
    LineBox[{{0.805, 6.319381470588242}, {0.805, 5.000000000000007}}], 
    LineBox[{{0.81, 6.319381470588242}, {0.81, 5.000000000000007}}], 
    LineBox[{{0.8150000000000001, 6.319381470588242}, {0.8150000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.8200000000000001, 6.319381470588242}, {0.8200000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.8250000000000001, 7.638762941176478}, {0.8250000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.8300000000000001, 6.319381470588242}, {0.8300000000000001, 
     5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 5.000000000000007}, {0.6699186991869919, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6747946741869919, 6.}, {0.6699186991869919, 6.}}], 
    LineBox[{{0.6747946741869919, 8.}, {0.6699186991869919, 8.}}], 
    LineBox[{{0.6796706491869918, 10.}, {0.6699186991869919, 10.}}], 
    LineBox[{{0.6747946741869919, 12.}, {0.6699186991869919, 12.}}], 
    LineBox[{{0.6747946741869919, 14.}, {0.6699186991869919, 14.}}], 
    LineBox[{{0.6747946741869919, 16.}, {0.6699186991869919, 16.}}], 
    LineBox[{{0.6747946741869919, 18.}, {0.6699186991869919, 18.}}], 
    LineBox[{{0.6796706491869918, 20.}, {0.6699186991869919, 20.}}], 
    LineBox[{{0.6747946741869919, 22.}, {0.6699186991869919, 22.}}], 
    LineBox[{{0.6747946741869919, 24.}, {0.6699186991869919, 24.}}], 
    LineBox[{{0.6747946741869919, 26.}, {0.6699186991869919, 26.}}], 
    LineBox[{{0.6747946741869919, 28.}, {0.6699186991869919, 28.}}], 
    LineBox[{{0.6796706491869918, 30.}, {0.6699186991869919, 30.}}], 
    LineBox[{{0.6747946741869919, 32.}, {0.6699186991869919, 32.}}], 
    LineBox[{{0.6747946741869919, 34.}, {0.6699186991869919, 34.}}], 
    LineBox[{{0.6747946741869919, 36.}, {0.6699186991869919, 36.}}], 
    LineBox[{{0.6747946741869919, 38.}, {0.6699186991869919, 38.}}], 
    LineBox[{{0.6796706491869918, 40.}, {0.6699186991869919, 40.}}], 
    LineBox[{{0.6747946741869919, 42.}, {0.6699186991869919, 42.}}], 
    LineBox[{{0.6747946741869919, 44.}, {0.6699186991869919, 44.}}], 
    LineBox[{{0.6747946741869919, 46.}, {0.6699186991869919, 46.}}], 
    LineBox[{{0.6747946741869919, 48.}, {0.6699186991869919, 48.}}], 
    LineBox[{{0.6796706491869918, 50.}, {0.6699186991869919, 50.}}], 
    LineBox[{{0.6747946741869919, 52.}, {0.6699186991869919, 52.}}], 
    LineBox[{{0.6747946741869919, 54.}, {0.6699186991869919, 54.}}], 
    LineBox[{{0.6747946741869919, 56.}, {0.6699186991869919, 56.}}], 
    LineBox[{{0.6747946741869919, 58.}, {0.6699186991869919, 58.}}], 
    LineBox[{{0.6796706491869918, 60.}, {0.6699186991869919, 60.}}], 
    LineBox[{{0.6747946741869919, 62.}, {0.6699186991869919, 62.}}], 
    LineBox[{{0.6747946741869919, 64.}, {0.6699186991869919, 64.}}], 
    LineBox[{{0.6747946741869919, 66.}, {0.6699186991869919, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.6699186991869919, 67.09150326797386}, {0.832520325203252, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.67, 65.77212179738562}, {0.67, 67.09150326797386}}], 
    LineBox[{{0.675, 64.4527403267974}, {0.675, 67.09150326797386}}], 
    LineBox[{{0.68, 65.77212179738562}, {0.68, 67.09150326797386}}], 
    LineBox[{{0.685, 65.77212179738562}, {0.685, 67.09150326797386}}], 
    LineBox[{{0.6900000000000001, 65.77212179738562}, {0.6900000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.6950000000000001, 65.77212179738562}, {0.6950000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7000000000000001, 64.4527403267974}, {0.7000000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7050000000000001, 65.77212179738562}, {0.7050000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7100000000000001, 65.77212179738562}, {0.7100000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7150000000000001, 65.77212179738562}, {0.7150000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7200000000000001, 65.77212179738562}, {0.7200000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7250000000000001, 64.4527403267974}, {0.7250000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7300000000000001, 65.77212179738562}, {0.7300000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7350000000000001, 65.77212179738562}, {0.7350000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7400000000000001, 65.77212179738562}, {0.7400000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.7450000000000001, 65.77212179738562}, {0.7450000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.75, 64.4527403267974}, {0.75, 67.09150326797386}}], 
    LineBox[{{0.755, 65.77212179738562}, {0.755, 67.09150326797386}}], 
    LineBox[{{0.76, 65.77212179738562}, {0.76, 67.09150326797386}}], 
    LineBox[{{0.765, 65.77212179738562}, {0.765, 67.09150326797386}}], 
    LineBox[{{0.77, 65.77212179738562}, {0.77, 67.09150326797386}}], 
    LineBox[{{0.775, 64.4527403267974}, {0.775, 67.09150326797386}}], 
    LineBox[{{0.78, 65.77212179738562}, {0.78, 67.09150326797386}}], 
    LineBox[{{0.785, 65.77212179738562}, {0.785, 67.09150326797386}}], 
    LineBox[{{0.79, 65.77212179738562}, {0.79, 67.09150326797386}}], 
    LineBox[{{0.795, 65.77212179738562}, {0.795, 67.09150326797386}}], 
    LineBox[{{0.8, 64.4527403267974}, {0.8, 67.09150326797386}}], 
    LineBox[{{0.805, 65.77212179738562}, {0.805, 67.09150326797386}}], 
    LineBox[{{0.81, 65.77212179738562}, {0.81, 67.09150326797386}}], 
    LineBox[{{0.8150000000000001, 65.77212179738562}, {0.8150000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.8200000000000001, 65.77212179738562}, {0.8200000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.8250000000000001, 64.4527403267974}, {0.8250000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.8300000000000001, 65.77212179738562}, {0.8300000000000001, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.832520325203252, 5.000000000000007}, {0.832520325203252, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.827644350203252, 6.}, {0.832520325203252, 6.}}], 
    LineBox[{{0.827644350203252, 8.}, {0.832520325203252, 8.}}], 
    LineBox[{{0.8227683752032521, 10.}, {0.832520325203252, 10.}}], 
    LineBox[{{0.827644350203252, 12.}, {0.832520325203252, 12.}}], 
    LineBox[{{0.827644350203252, 14.}, {0.832520325203252, 14.}}], 
    LineBox[{{0.827644350203252, 16.}, {0.832520325203252, 16.}}], 
    LineBox[{{0.827644350203252, 18.}, {0.832520325203252, 18.}}], 
    LineBox[{{0.8227683752032521, 20.}, {0.832520325203252, 20.}}], 
    LineBox[{{0.827644350203252, 22.}, {0.832520325203252, 22.}}], 
    LineBox[{{0.827644350203252, 24.}, {0.832520325203252, 24.}}], 
    LineBox[{{0.827644350203252, 26.}, {0.832520325203252, 26.}}], 
    LineBox[{{0.827644350203252, 28.}, {0.832520325203252, 28.}}], 
    LineBox[{{0.8227683752032521, 30.}, {0.832520325203252, 30.}}], 
    LineBox[{{0.827644350203252, 32.}, {0.832520325203252, 32.}}], 
    LineBox[{{0.827644350203252, 34.}, {0.832520325203252, 34.}}], 
    LineBox[{{0.827644350203252, 36.}, {0.832520325203252, 36.}}], 
    LineBox[{{0.827644350203252, 38.}, {0.832520325203252, 38.}}], 
    LineBox[{{0.8227683752032521, 40.}, {0.832520325203252, 40.}}], 
    LineBox[{{0.827644350203252, 42.}, {0.832520325203252, 42.}}], 
    LineBox[{{0.827644350203252, 44.}, {0.832520325203252, 44.}}], 
    LineBox[{{0.827644350203252, 46.}, {0.832520325203252, 46.}}], 
    LineBox[{{0.827644350203252, 48.}, {0.832520325203252, 48.}}], 
    LineBox[{{0.8227683752032521, 50.}, {0.832520325203252, 50.}}], 
    LineBox[{{0.827644350203252, 52.}, {0.832520325203252, 52.}}], 
    LineBox[{{0.827644350203252, 54.}, {0.832520325203252, 54.}}], 
    LineBox[{{0.827644350203252, 56.}, {0.832520325203252, 56.}}], 
    LineBox[{{0.827644350203252, 58.}, {0.832520325203252, 58.}}], 
    LineBox[{{0.8227683752032521, 60.}, {0.832520325203252, 60.}}], 
    LineBox[{{0.827644350203252, 62.}, {0.832520325203252, 62.}}], 
    LineBox[{{0.827644350203252, 64.}, {0.832520325203252, 64.}}], 
    LineBox[{{0.827644350203252, 66.}, {0.832520325203252, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 5.000000000000007}, {1., 
     5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8400000000000001, 6.319381470588242}, {0.8400000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.8450000000000001, 6.319381470588242}, {0.8450000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.8500000000000001, 7.638762941176478}, {0.8500000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.8550000000000001, 6.319381470588242}, {0.8550000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.8600000000000001, 6.319381470588242}, {0.8600000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.865, 6.319381470588242}, {0.865, 5.000000000000007}}], 
    LineBox[{{0.87, 6.319381470588242}, {0.87, 5.000000000000007}}], 
    LineBox[{{0.875, 7.638762941176478}, {0.875, 5.000000000000007}}], 
    LineBox[{{0.88, 6.319381470588242}, {0.88, 5.000000000000007}}], 
    LineBox[{{0.885, 6.319381470588242}, {0.885, 5.000000000000007}}], 
    LineBox[{{0.8899999999999999, 6.319381470588242}, {0.8899999999999999, 
     5.000000000000007}}], 
    LineBox[{{0.8949999999999999, 6.319381470588242}, {0.8949999999999999, 
     5.000000000000007}}], 
    LineBox[{{0.9, 7.638762941176478}, {0.9, 5.000000000000007}}], 
    LineBox[{{0.905, 6.319381470588242}, {0.905, 5.000000000000007}}], 
    LineBox[{{0.91, 6.319381470588242}, {0.91, 5.000000000000007}}], 
    LineBox[{{0.9149999999999999, 6.319381470588242}, {0.9149999999999999, 
     5.000000000000007}}], 
    LineBox[{{0.9199999999999999, 6.319381470588242}, {0.9199999999999999, 
     5.000000000000007}}], 
    LineBox[{{0.925, 7.638762941176478}, {0.925, 5.000000000000007}}], 
    LineBox[{{0.93, 6.319381470588242}, {0.93, 5.000000000000007}}], 
    LineBox[{{0.935, 6.319381470588242}, {0.935, 5.000000000000007}}], 
    LineBox[{{0.94, 6.319381470588242}, {0.94, 5.000000000000007}}], 
    LineBox[{{0.945, 6.319381470588242}, {0.945, 5.000000000000007}}], 
    LineBox[{{0.9500000000000001, 7.638762941176478}, {0.9500000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.9550000000000001, 6.319381470588242}, {0.9550000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.9600000000000001, 6.319381470588242}, {0.9600000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.965, 6.319381470588242}, {0.965, 5.000000000000007}}], 
    LineBox[{{0.97, 6.319381470588242}, {0.97, 5.000000000000007}}], 
    LineBox[{{0.9750000000000001, 7.638762941176478}, {0.9750000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.9800000000000001, 6.319381470588242}, {0.9800000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.9850000000000001, 6.319381470588242}, {0.9850000000000001, 
     5.000000000000007}}], 
    LineBox[{{0.99, 6.319381470588242}, {0.99, 5.000000000000007}}], 
    LineBox[{{0.995, 6.319381470588242}, {0.995, 5.000000000000007}}], 
    LineBox[{{1., 7.638762941176478}, {1., 5.000000000000007}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 5.000000000000007}, {0.8373983739837398, 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8422743489837399, 6.}, {0.8373983739837398, 6.}}], 
    LineBox[{{0.8422743489837399, 8.}, {0.8373983739837398, 8.}}], 
    LineBox[{{0.8471503239837398, 10.}, {0.8373983739837398, 10.}}], 
    LineBox[{{0.8422743489837399, 12.}, {0.8373983739837398, 12.}}], 
    LineBox[{{0.8422743489837399, 14.}, {0.8373983739837398, 14.}}], 
    LineBox[{{0.8422743489837399, 16.}, {0.8373983739837398, 16.}}], 
    LineBox[{{0.8422743489837399, 18.}, {0.8373983739837398, 18.}}], 
    LineBox[{{0.8471503239837398, 20.}, {0.8373983739837398, 20.}}], 
    LineBox[{{0.8422743489837399, 22.}, {0.8373983739837398, 22.}}], 
    LineBox[{{0.8422743489837399, 24.}, {0.8373983739837398, 24.}}], 
    LineBox[{{0.8422743489837399, 26.}, {0.8373983739837398, 26.}}], 
    LineBox[{{0.8422743489837399, 28.}, {0.8373983739837398, 28.}}], 
    LineBox[{{0.8471503239837398, 30.}, {0.8373983739837398, 30.}}], 
    LineBox[{{0.8422743489837399, 32.}, {0.8373983739837398, 32.}}], 
    LineBox[{{0.8422743489837399, 34.}, {0.8373983739837398, 34.}}], 
    LineBox[{{0.8422743489837399, 36.}, {0.8373983739837398, 36.}}], 
    LineBox[{{0.8422743489837399, 38.}, {0.8373983739837398, 38.}}], 
    LineBox[{{0.8471503239837398, 40.}, {0.8373983739837398, 40.}}], 
    LineBox[{{0.8422743489837399, 42.}, {0.8373983739837398, 42.}}], 
    LineBox[{{0.8422743489837399, 44.}, {0.8373983739837398, 44.}}], 
    LineBox[{{0.8422743489837399, 46.}, {0.8373983739837398, 46.}}], 
    LineBox[{{0.8422743489837399, 48.}, {0.8373983739837398, 48.}}], 
    LineBox[{{0.8471503239837398, 50.}, {0.8373983739837398, 50.}}], 
    LineBox[{{0.8422743489837399, 52.}, {0.8373983739837398, 52.}}], 
    LineBox[{{0.8422743489837399, 54.}, {0.8373983739837398, 54.}}], 
    LineBox[{{0.8422743489837399, 56.}, {0.8373983739837398, 56.}}], 
    LineBox[{{0.8422743489837399, 58.}, {0.8373983739837398, 58.}}], 
    LineBox[{{0.8471503239837398, 60.}, {0.8373983739837398, 60.}}], 
    LineBox[{{0.8422743489837399, 62.}, {0.8373983739837398, 62.}}], 
    LineBox[{{0.8422743489837399, 64.}, {0.8373983739837398, 64.}}], 
    LineBox[{{0.8422743489837399, 66.}, {0.8373983739837398, 66.}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8373983739837398, 67.09150326797386}, {1., 
     67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{0.8400000000000001, 65.77212179738562}, {0.8400000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.8450000000000001, 65.77212179738562}, {0.8450000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.8500000000000001, 64.4527403267974}, {0.8500000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.8550000000000001, 65.77212179738562}, {0.8550000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.8600000000000001, 65.77212179738562}, {0.8600000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.865, 65.77212179738562}, {0.865, 67.09150326797386}}], 
    LineBox[{{0.87, 65.77212179738562}, {0.87, 67.09150326797386}}], 
    LineBox[{{0.875, 64.4527403267974}, {0.875, 67.09150326797386}}], 
    LineBox[{{0.88, 65.77212179738562}, {0.88, 67.09150326797386}}], 
    LineBox[{{0.885, 65.77212179738562}, {0.885, 67.09150326797386}}], 
    LineBox[{{0.8899999999999999, 65.77212179738562}, {0.8899999999999999, 
     67.09150326797386}}], 
    LineBox[{{0.8949999999999999, 65.77212179738562}, {0.8949999999999999, 
     67.09150326797386}}], 
    LineBox[{{0.9, 64.4527403267974}, {0.9, 67.09150326797386}}], 
    LineBox[{{0.905, 65.77212179738562}, {0.905, 67.09150326797386}}], 
    LineBox[{{0.91, 65.77212179738562}, {0.91, 67.09150326797386}}], 
    LineBox[{{0.9149999999999999, 65.77212179738562}, {0.9149999999999999, 
     67.09150326797386}}], 
    LineBox[{{0.9199999999999999, 65.77212179738562}, {0.9199999999999999, 
     67.09150326797386}}], 
    LineBox[{{0.925, 64.4527403267974}, {0.925, 67.09150326797386}}], 
    LineBox[{{0.93, 65.77212179738562}, {0.93, 67.09150326797386}}], 
    LineBox[{{0.935, 65.77212179738562}, {0.935, 67.09150326797386}}], 
    LineBox[{{0.94, 65.77212179738562}, {0.94, 67.09150326797386}}], 
    LineBox[{{0.945, 65.77212179738562}, {0.945, 67.09150326797386}}], 
    LineBox[{{0.9500000000000001, 64.4527403267974}, {0.9500000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.9550000000000001, 65.77212179738562}, {0.9550000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.9600000000000001, 65.77212179738562}, {0.9600000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.965, 65.77212179738562}, {0.965, 67.09150326797386}}], 
    LineBox[{{0.97, 65.77212179738562}, {0.97, 67.09150326797386}}], 
    LineBox[{{0.9750000000000001, 64.4527403267974}, {0.9750000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.9800000000000001, 65.77212179738562}, {0.9800000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.9850000000000001, 65.77212179738562}, {0.9850000000000001, 
     67.09150326797386}}], 
    LineBox[{{0.99, 65.77212179738562}, {0.99, 67.09150326797386}}], 
    LineBox[{{0.995, 65.77212179738562}, {0.995, 67.09150326797386}}], 
    LineBox[{{1., 64.4527403267974}, {1., 67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[None], 
    LineBox[{{1., 5.000000000000007}, {1., 67.09150326797386}}]}, 
   {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[1], 
    Dashing[{}], CapForm[
    None], {LineBox[{{0.995124025, 6.}, {1., 6.}}], 
     LineBox[{{0.995124025, 8.}, {1., 8.}}], 
     LineBox[{{0.99024805, 10.}, {1., 10.}}], 
     LineBox[{{0.995124025, 12.}, {1., 12.}}], 
     LineBox[{{0.995124025, 14.}, {1., 14.}}], 
     LineBox[{{0.995124025, 16.}, {1., 16.}}], 
     LineBox[{{0.995124025, 18.}, {1., 18.}}], 
     LineBox[{{0.99024805, 20.}, {1., 20.}}], 
     LineBox[{{0.995124025, 22.}, {1., 22.}}], 
     LineBox[{{0.995124025, 24.}, {1., 24.}}], 
     LineBox[{{0.995124025, 26.}, {1., 26.}}], 
     LineBox[{{0.995124025, 28.}, {1., 28.}}], 
     LineBox[{{0.99024805, 30.}, {1., 30.}}], 
     LineBox[{{0.995124025, 32.}, {1., 32.}}], 
     LineBox[{{0.995124025, 34.}, {1., 34.}}], 
     LineBox[{{0.995124025, 36.}, {1., 36.}}], 
     LineBox[{{0.995124025, 38.}, {1., 38.}}], 
     LineBox[{{0.99024805, 40.}, {1., 40.}}], 
     LineBox[{{0.995124025, 42.}, {1., 42.}}], 
     LineBox[{{0.995124025, 44.}, {1., 44.}}], 
     LineBox[{{0.995124025, 46.}, {1., 46.}}], 
     LineBox[{{0.995124025, 48.}, {1., 48.}}], 
     LineBox[{{0.99024805, 50.}, {1., 50.}}], 
     LineBox[{{0.995124025, 52.}, {1., 52.}}], 
     LineBox[{{0.995124025, 54.}, {1., 54.}}], 
     LineBox[{{0.995124025, 56.}, {1., 56.}}], 
     LineBox[{{0.995124025, 58.}, {1., 58.}}], 
     LineBox[{{0.99024805, 60.}, {1., 60.}}], 
     LineBox[{{0.995124025, 62.}, {1., 62.}}], 
     LineBox[{{0.995124025, 64.}, {1., 64.}}], 
     LineBox[{{0.995124025, 66.}, {1., 66.}}]}, 
    {GrayLevel[1], Opacity[0.15], RectangleBox[{0.05, 15.}, {0.45, 90.}]}, 
    {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0., 200.}, {1., 200.}}]}, 
    {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0., 114.09595588235294`}, {0.08682291666666668, 
      114.09595588235294`}, {0.10418750000000002`, 100.}, {0.8958125, 100.}, {
      0.9131770833333334, 114.09595588235294`}, {1., 114.09595588235294`}}]}, 
    {GrayLevel[0], AbsoluteThickness[3], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0., 1.7763568394002505`*^-15}, {1., 
      1.7763568394002505`*^-15}}], 
     {GrayLevel[0.5], Opacity[1], 
      PolygonBox[{{0.65, 200.00000000000003`}, {0.5984638886099332, 
       200.00000000000003`}, {0.7361614794294772, 108.201606120304}, {
       0.7240941534506162, 106.87628803529002`}, {0.8, 100.}, {
       0.8367225292533179, 119.24592349542064`}, {0.824655203274457, 
       117.92060541040664`}, {0.701536111390067, 200.00000000000003`}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.65, 200.00000000000003`}, {0.5984638886099332, 
       200.00000000000003`}, {0.7361614794294772, 108.201606120304}, {
       0.7240941534506162, 106.87628803529002`}, {0.8, 100.}, {
       0.8367225292533179, 119.24592349542064`}, {0.824655203274457, 
       117.92060541040664`}, {0.701536111390067, 200.00000000000003`}, {0.65, 
       200.00000000000003`}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQA2IQzXV9cYEt1337n/6KRnO2BzuAudcx+csvnPDn/Rns
sEOu9XXgjgcY/D79s9LvVIIdWoA8udaHGPwwf7lv79UDHILAGh5h8DfwdTlJ
f/V2ABsn9xiD/yWn+5L/RHeHNyDjXmPyc+uVZ/T0ukDd8wSDf+ekrfqiVU5Q
9zzF4M+dEnmlt98J6p5nGPxpdtXZBhnOUPc8x+D7dHj+5p/kAnUPJn8z17Pg
f+edoe55gcE//UlwocUJF6h7XmLwyxkKt87wcIa65xUGn3MLy/ovEo5Q97zG
4Jd4u+69IGjn8ArsHkx+1Ht1bTt/S6h73mDwD+UX8cyrMoG65y0Gn2+Gs1cH
h7EDmPsawQcAfacjnA==
       "]]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], {{
        LineBox[{{0.485, 78.86890843632854}, {0.485, 71.61414467305657}}], 
        LineBox[{{0.47979062499999997`, 71.61414467305657}, {0.490209375, 
         71.61414467305657}}]}, {
        LineBox[{{0.51, 79.89143747912259}, {0.51, 72.58663431929173}}], 
        LineBox[{{0.504790625, 72.58663431929173}, {0.515209375, 
         72.58663431929173}}]}, {
        LineBox[{{0.5349999999999999, 76.57703299558327}, {0.5349999999999999,
          69.43570006612583}}], 
        LineBox[{{0.529790625, 69.43570006612583}, {0.5402093749999999, 
         69.43570006612583}}]}, {
        LineBox[{{0.5599999999999999, 64.62402108154251}, {0.5599999999999999,
          58.10619053598526}}], 
        LineBox[{{0.554790625, 58.10619053598526}, {0.5652093749999999, 
         58.10619053598526}}]}, {
        LineBox[{{0.585, 55.91489440671046}, {0.585, 49.89186674076195}}], 
        LineBox[{{0.579790625, 49.89186674076195}, {0.5902093749999999, 
         49.89186674076195}}]}, {
        LineBox[{{0.61, 47.135248487547784`}, {0.61, 41.65607295217955}}], 
        LineBox[{{0.604790625, 41.65607295217955}, {0.615209375, 
         41.65607295217955}}]}, {
        LineBox[{{0.635, 41.10585309727944}, {0.635, 36.03382979963859}}], 
        LineBox[{{0.629790625, 36.03382979963859}, {0.640209375, 
         36.03382979963859}}]}, {
        LineBox[{{0.6599999999999999, 37.33307352559106}, {0.6599999999999999,
          32.53335323301321}}], 
        LineBox[{{0.654790625, 32.53335323301321}, {0.6652093749999999, 
         32.53335323301321}}]}, {
        LineBox[{{0.6849999999999999, 37.12151579259919}, {0.6849999999999999,
          32.337523735516854`}}], 
        LineBox[{{0.679790625, 32.337523735516854`}, {0.6902093749999999, 
         32.337523735516854`}}]}, {
        LineBox[{{0.71, 38.81397765653416}, {0.71, 33.9055706766393}}], 
        LineBox[{{0.704790625, 33.9055706766393}, {0.7152093749999999, 
         33.9055706766393}}]}, {
        LineBox[{{0.735, 41.14111271944475}, {0.735, 36.06661345226534}}], 
        LineBox[{{0.729790625, 36.06661345226534}, {0.740209375, 
         36.06661345226534}}]}, {
        LineBox[{{0.76, 39.62494896633634}, {0.76, 34.65803079321182}}], 
        LineBox[{{0.754790625, 34.65803079321182}, {0.765209375, 
         34.65803079321182}}]}, {
        LineBox[{{0.7849999999999999, 41.5642281854285}, {0.7849999999999999, 
         36.46011096673947}}], 
        LineBox[{{0.779790625, 36.46011096673947}, {0.7902093749999999, 
         36.46011096673947}}]}, {
        LineBox[{{0.8099999999999999, 38.56716030137698}, {0.8099999999999999,
          33.67670002500921}}], 
        LineBox[{{0.804790625, 33.67670002500921}, {0.8152093749999999, 
         33.67670002500921}}]}, {
        LineBox[{{0.835, 34.1949671528783}, {0.835, 29.634110424540324`}}], 
        LineBox[{{0.829790625, 29.634110424540324`}, {0.8402093749999999, 
         29.634110424540324`}}]}, {
        LineBox[{{0.8599999999999999, 30.0695913595368}, {0.8599999999999999, 
         25.84323550091936}}], 
        LineBox[{{0.8547906249999999, 25.84323550091936}, {0.8652093749999998,
          25.84323550091936}}]}, {
        LineBox[{{0.8849999999999999, 25.309542367219684`}, {
         0.8849999999999999, 21.505524893989044`}}], 
        LineBox[{{0.8797906249999999, 21.505524893989044`}, {
         0.8902093749999999, 21.505524893989044`}}]}, {
        LineBox[{{0.9099999999999999, 20.47897413057195}, {0.9099999999999999,
          17.158015072102167`}}], 
        LineBox[{{0.904790625, 17.158015072102167`}, {0.9152093749999999, 
         17.158015072102167`}}]}, {
        LineBox[{{0.9349999999999999, 19.03332962179416}, {0.9349999999999999,
          15.871250028310097`}}], 
        LineBox[{{0.929790625, 15.871250028310097`}, {0.9402093749999999, 
         15.871250028310097`}}]}, {
        LineBox[{{0.485, 78.86890843632854}, {0.485, 86.1236721996005}}], 
        LineBox[{{0.47979062499999997`, 86.1236721996005}, {0.490209375, 
         86.1236721996005}}]}, {
        LineBox[{{0.51, 79.89143747912259}, {0.51, 87.19624063895344}}], 
        LineBox[{{0.504790625, 87.19624063895344}, {0.515209375, 
         87.19624063895344}}]}, {
        LineBox[{{0.5349999999999999, 76.57703299558327}, {0.5349999999999999,
          83.7183659250407}}], 
        LineBox[{{0.529790625, 83.7183659250407}, {0.5402093749999999, 
         83.7183659250407}}]}, {
        LineBox[{{0.5599999999999999, 64.62402108154251}, {0.5599999999999999,
          71.14185162709975}}], 
        LineBox[{{0.554790625, 71.14185162709975}, {0.5652093749999999, 
         71.14185162709975}}]}, {
        LineBox[{{0.585, 55.91489440671046}, {0.585, 61.93792207265897}}], 
        LineBox[{{0.579790625, 61.93792207265897}, {0.5902093749999999, 
         61.93792207265897}}]}, {
        LineBox[{{0.61, 47.135248487547784`}, {0.61, 52.61442402291602}}], 
        LineBox[{{0.604790625, 52.61442402291602}, {0.615209375, 
         52.61442402291602}}]}, {
        LineBox[{{0.635, 41.10585309727944}, {0.635, 46.1778763949203}}], 
        LineBox[{{0.629790625, 46.1778763949203}, {0.640209375, 
         46.1778763949203}}]}, {
        LineBox[{{0.6599999999999999, 37.33307352559106}, {0.6599999999999999,
          42.13279381816891}}], 
        LineBox[{{0.654790625, 42.13279381816891}, {0.6652093749999999, 
         42.13279381816891}}]}, {
        LineBox[{{0.6849999999999999, 37.12151579259919}, {0.6849999999999999,
          41.90550784968153}}], 
        LineBox[{{0.679790625, 41.90550784968153}, {0.6902093749999999, 
         41.90550784968153}}]}, {
        LineBox[{{0.71, 38.81397765653416}, {0.71, 43.72238463642903}}], 
        LineBox[{{0.704790625, 43.72238463642903}, {0.7152093749999999, 
         43.72238463642903}}]}, {
        LineBox[{{0.735, 41.14111271944475}, {0.735, 46.21561198662416}}], 
        LineBox[{{0.729790625, 46.21561198662416}, {0.740209375, 
         46.21561198662416}}]}, {
        LineBox[{{0.76, 39.62494896633634}, {0.76, 44.59186713946086}}], 
        LineBox[{{0.754790625, 44.59186713946086}, {0.765209375, 
         44.59186713946086}}]}, {
        LineBox[{{0.7849999999999999, 41.5642281854285}, {0.7849999999999999, 
         46.668345404117524`}}], 
        LineBox[{{0.779790625, 46.668345404117524`}, {0.7902093749999999, 
         46.668345404117524`}}]}, {
        LineBox[{{0.8099999999999999, 38.56716030137698}, {0.8099999999999999,
          43.45762057774475}}], 
        LineBox[{{0.804790625, 43.45762057774475}, {0.8152093749999999, 
         43.45762057774475}}]}, {
        LineBox[{{0.835, 34.1949671528783}, {0.835, 38.75582388121627}}], 
        LineBox[{{0.829790625, 38.75582388121627}, {0.8402093749999999, 
         38.75582388121627}}]}, {
        LineBox[{{0.8599999999999999, 30.0695913595368}, {0.8599999999999999, 
         34.29594721815424}}], 
        LineBox[{{0.8547906249999999, 34.29594721815424}, {0.8652093749999998,
          34.29594721815424}}]}, {
        LineBox[{{0.8849999999999999, 25.309542367219684`}, {
         0.8849999999999999, 29.113559840450325`}}], 
        LineBox[{{0.8797906249999999, 29.113559840450325`}, {
         0.8902093749999999, 29.113559840450325`}}]}, {
        LineBox[{{0.9099999999999999, 20.47897413057195}, {0.9099999999999999,
          23.79993318904173}}], 
        LineBox[{{0.904790625, 23.79993318904173}, {0.9152093749999999, 
         23.79993318904173}}]}, {
        LineBox[{{0.9349999999999999, 19.03332962179416}, {0.9349999999999999,
          22.19540921527822}}], 
        LineBox[{{0.929790625, 22.19540921527822}, {0.9402093749999999, 
         22.19540921527822}}]}}, 
      {RGBColor[0.466704, 0.533296, 0.599994], Opacity[1], 
       PolygonBox[{{0.489812834939676, 79.40833731428111}, {
        0.48868358438824366`, 79.86564303550036}, {0.48699354150547686`, 
        80.17120494941733}, {0.485, 80.27850402456383}, {0.4830064584945231, 
        80.17120494941733}, {0.4813164156117563, 79.86564303550036}, {
        0.480187165060324, 79.40833731428111}, {0.47979062499999997`, 
        78.86890843632854}, {0.480187165060324, 78.32947955837597}, {
        0.4813164156117563, 77.87217383715672}, {0.4830064584945231, 
        77.56661192323975}, {0.485, 77.45931284809325}, {0.48699354150547686`,
         77.56661192323975}, {0.48868358438824366`, 77.87217383715672}, {
        0.489812834939676, 78.32947955837597}, {0.490209375, 
        78.86890843632854}}], 
       PolygonBox[{{0.514812834939676, 80.43086635707516}, {
        0.5136835843882437, 80.8881720782944}, {0.5119935415054769, 
        81.19373399221138}, {0.51, 81.30103306735788}, {0.5080064584945231, 
        81.19373399221138}, {0.5063164156117563, 80.8881720782944}, {
        0.505187165060324, 80.43086635707516}, {0.504790625, 
        79.89143747912259}, {0.505187165060324, 79.35200860117001}, {
        0.5063164156117563, 78.89470287995077}, {0.5080064584945231, 
        78.5891409660338}, {0.51, 78.4818418908873}, {0.5119935415054769, 
        78.5891409660338}, {0.5136835843882437, 78.89470287995077}, {
        0.514812834939676, 79.35200860117001}, {0.515209375, 
        79.89143747912259}}], 
       PolygonBox[{{0.5398128349396759, 77.11646187353584}, {
        0.5386835843882436, 77.57376759475508}, {0.5369935415054768, 
        77.87932950867206}, {0.5349999999999999, 77.98662858381856}, {
        0.533006458494523, 77.87932950867206}, {0.5313164156117562, 
        77.57376759475508}, {0.5301871650603239, 77.11646187353584}, {
        0.529790625, 76.57703299558327}, {0.5301871650603239, 
        76.03760411763069}, {0.5313164156117562, 75.58029839641145}, {
        0.533006458494523, 75.27473648249448}, {0.5349999999999999, 
        75.16743740734798}, {0.5369935415054768, 75.27473648249448}, {
        0.5386835843882436, 75.58029839641145}, {0.5398128349396759, 
        76.03760411763069}, {0.5402093749999999, 76.57703299558327}}], 
       PolygonBox[{{0.5648128349396759, 65.16344995949508}, {
        0.5636835843882436, 65.62075568071432}, {0.5619935415054769, 
        65.9263175946313}, {0.5599999999999999, 66.0336166697778}, {
        0.558006458494523, 65.9263175946313}, {0.5563164156117563, 
        65.62075568071432}, {0.555187165060324, 65.16344995949508}, {
        0.554790625, 64.62402108154251}, {0.555187165060324, 
        64.08459220358993}, {0.5563164156117563, 63.62728648237069}, {
        0.558006458494523, 63.32172456845371}, {0.5599999999999999, 
        63.21442549330722}, {0.5619935415054769, 63.32172456845371}, {
        0.5636835843882436, 63.62728648237069}, {0.5648128349396759, 
        64.08459220358993}, {0.5652093749999999, 64.62402108154251}}], 
       PolygonBox[{{0.589812834939676, 56.454323284663026`}, {
        0.5886835843882436, 56.911629005882276`}, {0.5869935415054769, 
        57.21719091979926}, {0.585, 57.32448999494575}, {0.583006458494523, 
        57.21719091979926}, {0.5813164156117563, 56.911629005882276`}, {
        0.580187165060324, 56.454323284663026`}, {0.579790625, 
        55.91489440671046}, {0.580187165060324, 55.37546552875789}, {
        0.5813164156117563, 54.91815980753864}, {0.583006458494523, 
        54.61259789362166}, {0.585, 54.50529881847517}, {0.5869935415054769, 
        54.61259789362166}, {0.5886835843882436, 54.91815980753864}, {
        0.589812834939676, 55.37546552875789}, {0.5902093749999999, 
        55.91489440671046}}], 
       PolygonBox[{{0.614812834939676, 47.67467736550035}, {
        0.6136835843882437, 48.1319830867196}, {0.6119935415054769, 
        48.43754500063658}, {0.61, 48.544844075783075`}, {0.6080064584945231, 
        48.43754500063658}, {0.6063164156117563, 48.1319830867196}, {
        0.605187165060324, 47.67467736550035}, {0.604790625, 
        47.135248487547784`}, {0.605187165060324, 46.59581960959522}, {
        0.6063164156117563, 46.13851388837597}, {0.6080064584945231, 
        45.832951974458986`}, {0.61, 45.72565289931249}, {0.6119935415054769, 
        45.832951974458986`}, {0.6136835843882437, 46.13851388837597}, {
        0.614812834939676, 46.59581960959522}, {0.615209375, 
        47.135248487547784`}}], 
       PolygonBox[{{0.639812834939676, 41.64528197523201}, {
        0.6386835843882437, 42.10258769645126}, {0.6369935415054769, 
        42.40814961036824}, {0.635, 42.515448685514734`}, {0.6330064584945231,
         42.40814961036824}, {0.6313164156117563, 42.10258769645126}, {
        0.630187165060324, 41.64528197523201}, {0.629790625, 
        41.10585309727944}, {0.630187165060324, 40.566424219326876`}, {
        0.6313164156117563, 40.10911849810763}, {0.6330064584945231, 
        39.803556584190645`}, {0.635, 39.69625750904415}, {0.6369935415054769,
         39.803556584190645`}, {0.6386835843882437, 40.10911849810763}, {
        0.639812834939676, 40.566424219326876`}, {0.640209375, 
        41.10585309727944}}], 
       PolygonBox[{{0.6648128349396759, 37.87250240354363}, {
        0.6636835843882436, 38.32980812476288}, {0.6619935415054768, 
        38.63537003867986}, {0.6599999999999999, 38.74266911382635}, {
        0.658006458494523, 38.63537003867986}, {0.6563164156117562, 
        38.32980812476288}, {0.6551871650603239, 37.87250240354363}, {
        0.654790625, 37.33307352559106}, {0.6551871650603239, 
        36.793644647638494`}, {0.6563164156117562, 36.336338926419245`}, {
        0.658006458494523, 36.03077701250226}, {0.6599999999999999, 
        35.92347793735577}, {0.6619935415054768, 36.03077701250226}, {
        0.6636835843882436, 36.336338926419245`}, {0.6648128349396759, 
        36.793644647638494`}, {0.6652093749999999, 37.33307352559106}}], 
       PolygonBox[{{0.6898128349396759, 37.66094467055176}, {
        0.6886835843882436, 38.11825039177101}, {0.6869935415054769, 
        38.42381230568799}, {0.6849999999999999, 38.53111138083448}, {
        0.683006458494523, 38.42381230568799}, {0.6813164156117563, 
        38.11825039177101}, {0.680187165060324, 37.66094467055176}, {
        0.679790625, 37.12151579259919}, {0.680187165060324, 
        36.582086914646624`}, {0.6813164156117563, 36.124781193427374`}, {
        0.683006458494523, 35.81921927951039}, {0.6849999999999999, 
        35.7119202043639}, {0.6869935415054769, 35.81921927951039}, {
        0.6886835843882436, 36.124781193427374`}, {0.6898128349396759, 
        36.582086914646624`}, {0.6902093749999999, 37.12151579259919}}], 
       PolygonBox[{{0.714812834939676, 39.35340653448673}, {
        0.7136835843882436, 39.81071225570598}, {0.7119935415054769, 
        40.11627416962296}, {0.71, 40.223573244769455`}, {0.708006458494523, 
        40.11627416962296}, {0.7063164156117563, 39.81071225570598}, {
        0.705187165060324, 39.35340653448673}, {0.704790625, 
        38.81397765653416}, {0.705187165060324, 38.2745487785816}, {
        0.7063164156117563, 37.81724305736235}, {0.708006458494523, 
        37.511681143445365`}, {0.71, 37.40438206829887}, {0.7119935415054769, 
        37.511681143445365`}, {0.7136835843882436, 37.81724305736235}, {
        0.714812834939676, 38.2745487785816}, {0.7152093749999999, 
        38.81397765653416}}], 
       PolygonBox[{{0.739812834939676, 41.680541597397315`}, {
        0.7386835843882437, 42.137847318616565`}, {0.7369935415054769, 
        42.44340923253355}, {0.735, 42.55070830768004}, {0.7330064584945231, 
        42.44340923253355}, {0.7313164156117563, 42.137847318616565`}, {
        0.730187165060324, 41.680541597397315`}, {0.729790625, 
        41.14111271944475}, {0.730187165060324, 40.60168384149218}, {
        0.7313164156117563, 40.14437812027293}, {0.7330064584945231, 
        39.83881620635595}, {0.735, 39.73151713120946}, {0.7369935415054769, 
        39.83881620635595}, {0.7386835843882437, 40.14437812027293}, {
        0.739812834939676, 40.60168384149218}, {0.740209375, 
        41.14111271944475}}], 
       PolygonBox[{{0.764812834939676, 40.16437784428891}, {
        0.7636835843882437, 40.62168356550816}, {0.7619935415054769, 
        40.92724547942514}, {0.76, 41.03454455457163}, {0.7580064584945231, 
        40.92724547942514}, {0.7563164156117563, 40.62168356550816}, {
        0.755187165060324, 40.16437784428891}, {0.754790625, 
        39.62494896633634}, {0.755187165060324, 39.085520088383774`}, {
        0.7563164156117563, 38.628214367164524`}, {0.7580064584945231, 
        38.32265245324754}, {0.76, 38.21535337810105}, {0.7619935415054769, 
        38.32265245324754}, {0.7636835843882437, 38.628214367164524`}, {
        0.764812834939676, 39.085520088383774`}, {0.765209375, 
        39.62494896633634}}], 
       PolygonBox[{{0.7898128349396759, 42.103657063381064`}, {
        0.7886835843882436, 42.560962784600314`}, {0.7869935415054768, 
        42.866524698517296`}, {0.7849999999999999, 42.97382377366379}, {
        0.783006458494523, 42.866524698517296`}, {0.7813164156117562, 
        42.560962784600314`}, {0.7801871650603239, 42.103657063381064`}, {
        0.779790625, 41.5642281854285}, {0.7801871650603239, 
        41.02479930747593}, {0.7813164156117562, 40.56749358625668}, {
        0.783006458494523, 40.2619316723397}, {0.7849999999999999, 
        40.154632597193206`}, {0.7869935415054768, 40.2619316723397}, {
        0.7886835843882436, 40.56749358625668}, {0.7898128349396759, 
        41.02479930747593}, {0.7902093749999999, 41.5642281854285}}], 
       PolygonBox[{{0.8148128349396759, 39.106589179329546`}, {
        0.8136835843882436, 39.563894900548796`}, {0.8119935415054769, 
        39.86945681446578}, {0.8099999999999999, 39.97675588961227}, {
        0.808006458494523, 39.86945681446578}, {0.8063164156117563, 
        39.563894900548796`}, {0.805187165060324, 39.106589179329546`}, {
        0.804790625, 38.56716030137698}, {0.805187165060324, 
        38.02773142342441}, {0.8063164156117563, 37.57042570220516}, {
        0.808006458494523, 37.26486378828818}, {0.8099999999999999, 
        37.15756471314169}, {0.8119935415054769, 37.26486378828818}, {
        0.8136835843882436, 37.57042570220516}, {0.8148128349396759, 
        38.02773142342441}, {0.8152093749999999, 38.56716030137698}}], 
       PolygonBox[{{0.839812834939676, 34.734396030830865`}, {
        0.8386835843882436, 35.191701752050115`}, {0.8369935415054769, 
        35.4972636659671}, {0.835, 35.60456274111359}, {0.833006458494523, 
        35.4972636659671}, {0.8313164156117563, 35.191701752050115`}, {
        0.830187165060324, 34.734396030830865`}, {0.829790625, 
        34.1949671528783}, {0.830187165060324, 33.65553827492573}, {
        0.8313164156117563, 33.19823255370648}, {0.833006458494523, 
        32.8926706397895}, {0.835, 32.78537156464301}, {0.8369935415054769, 
        32.8926706397895}, {0.8386835843882436, 33.19823255370648}, {
        0.839812834939676, 33.65553827492573}, {0.8402093749999999, 
        34.1949671528783}}], 
       PolygonBox[{{0.8648128349396759, 30.60902023748937}, {
        0.8636835843882436, 31.066325958708617`}, {0.8619935415054768, 
        31.371887872625596`}, {0.8599999999999999, 31.479186947772096`}, {
        0.858006458494523, 31.371887872625596`}, {0.8563164156117562, 
        31.066325958708617`}, {0.8551871650603239, 30.60902023748937}, {
        0.8547906249999999, 30.0695913595368}, {0.8551871650603239, 
        29.53016248158423}, {0.8563164156117562, 29.072856760364985`}, {
        0.858006458494523, 28.767294846448006`}, {0.8599999999999999, 
        28.659995771301507`}, {0.8619935415054768, 28.767294846448006`}, {
        0.8636835843882436, 29.072856760364985`}, {0.8648128349396759, 
        29.53016248158423}, {0.8652093749999998, 30.0695913595368}}], 
       PolygonBox[{{0.8898128349396759, 25.848971245172255`}, {
        0.8886835843882436, 26.3062769663915}, {0.8869935415054768, 
        26.61183888030848}, {0.8849999999999999, 26.71913795545498}, {
        0.883006458494523, 26.61183888030848}, {0.8813164156117562, 
        26.3062769663915}, {0.8801871650603239, 25.848971245172255`}, {
        0.8797906249999999, 25.309542367219684`}, {0.8801871650603239, 
        24.770113489267114`}, {0.8813164156117562, 24.31280776804787}, {
        0.883006458494523, 24.00724585413089}, {0.8849999999999999, 
        23.89994677898439}, {0.8869935415054768, 24.00724585413089}, {
        0.8886835843882436, 24.31280776804787}, {0.8898128349396759, 
        24.770113489267114`}, {0.8902093749999999, 25.309542367219684`}}], 
       PolygonBox[{{0.9148128349396759, 21.01840300852452}, {
        0.9136835843882436, 21.475708729743765`}, {0.9119935415054768, 
        21.781270643660744`}, {0.9099999999999999, 21.888569718807243`}, {
        0.908006458494523, 21.781270643660744`}, {0.9063164156117562, 
        21.475708729743765`}, {0.9051871650603239, 21.01840300852452}, {
        0.904790625, 20.47897413057195}, {0.9051871650603239, 
        19.93954525261938}, {0.9063164156117562, 19.482239531400133`}, {
        0.908006458494523, 19.176677617483154`}, {0.9099999999999999, 
        19.069378542336654`}, {0.9119935415054768, 19.176677617483154`}, {
        0.9136835843882436, 19.482239531400133`}, {0.9148128349396759, 
        19.93954525261938}, {0.9152093749999999, 20.47897413057195}}], 
       PolygonBox[{{0.9398128349396759, 19.57275849974673}, {
        0.9386835843882436, 20.030064220965976`}, {0.9369935415054769, 
        20.335626134882954`}, {0.9349999999999999, 20.442925210029454`}, {
        0.933006458494523, 20.335626134882954`}, {0.9313164156117563, 
        20.030064220965976`}, {0.930187165060324, 19.57275849974673}, {
        0.929790625, 19.03332962179416}, {0.930187165060324, 
        18.49390074384159}, {0.9313164156117563, 18.036595022622343`}, {
        0.933006458494523, 17.731033108705365`}, {0.9349999999999999, 
        17.623734033558865`}, {0.9369935415054769, 17.731033108705365`}, {
        0.9386835843882436, 18.036595022622343`}, {0.9398128349396759, 
        18.49390074384159}, {0.9402093749999999, 19.03332962179416}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.489812834939676, 79.40833731428111}, {0.48868358438824366`,
         79.86564303550036}, {0.48699354150547686`, 80.17120494941733}, {
        0.485, 80.27850402456383}, {0.4830064584945231, 80.17120494941733}, {
        0.4813164156117563, 79.86564303550036}, {0.480187165060324, 
        79.40833731428111}, {0.47979062499999997`, 78.86890843632854}, {
        0.480187165060324, 78.32947955837597}, {0.4813164156117563, 
        77.87217383715672}, {0.4830064584945231, 77.56661192323975}, {0.485, 
        77.45931284809325}, {0.48699354150547686`, 77.56661192323975}, {
        0.48868358438824366`, 77.87217383715672}, {0.489812834939676, 
        78.32947955837597}, {0.490209375, 78.86890843632854}, {
        0.489812834939676, 79.40833731428111}}], 
       LineBox[{{0.514812834939676, 80.43086635707516}, {0.5136835843882437, 
        80.8881720782944}, {0.5119935415054769, 81.19373399221138}, {0.51, 
        81.30103306735788}, {0.5080064584945231, 81.19373399221138}, {
        0.5063164156117563, 80.8881720782944}, {0.505187165060324, 
        80.43086635707516}, {0.504790625, 79.89143747912259}, {
        0.505187165060324, 79.35200860117001}, {0.5063164156117563, 
        78.89470287995077}, {0.5080064584945231, 78.5891409660338}, {0.51, 
        78.4818418908873}, {0.5119935415054769, 78.5891409660338}, {
        0.5136835843882437, 78.89470287995077}, {0.514812834939676, 
        79.35200860117001}, {0.515209375, 79.89143747912259}, {
        0.514812834939676, 80.43086635707516}}], 
       LineBox[{{0.5398128349396759, 77.11646187353584}, {0.5386835843882436, 
        77.57376759475508}, {0.5369935415054768, 77.87932950867206}, {
        0.5349999999999999, 77.98662858381856}, {0.533006458494523, 
        77.87932950867206}, {0.5313164156117562, 77.57376759475508}, {
        0.5301871650603239, 77.11646187353584}, {0.529790625, 
        76.57703299558327}, {0.5301871650603239, 76.03760411763069}, {
        0.5313164156117562, 75.58029839641145}, {0.533006458494523, 
        75.27473648249448}, {0.5349999999999999, 75.16743740734798}, {
        0.5369935415054768, 75.27473648249448}, {0.5386835843882436, 
        75.58029839641145}, {0.5398128349396759, 76.03760411763069}, {
        0.5402093749999999, 76.57703299558327}, {0.5398128349396759, 
        77.11646187353584}}], 
       LineBox[{{0.5648128349396759, 65.16344995949508}, {0.5636835843882436, 
        65.62075568071432}, {0.5619935415054769, 65.9263175946313}, {
        0.5599999999999999, 66.0336166697778}, {0.558006458494523, 
        65.9263175946313}, {0.5563164156117563, 65.62075568071432}, {
        0.555187165060324, 65.16344995949508}, {0.554790625, 
        64.62402108154251}, {0.555187165060324, 64.08459220358993}, {
        0.5563164156117563, 63.62728648237069}, {0.558006458494523, 
        63.32172456845371}, {0.5599999999999999, 63.21442549330722}, {
        0.5619935415054769, 63.32172456845371}, {0.5636835843882436, 
        63.62728648237069}, {0.5648128349396759, 64.08459220358993}, {
        0.5652093749999999, 64.62402108154251}, {0.5648128349396759, 
        65.16344995949508}}], 
       LineBox[{{0.589812834939676, 56.454323284663026`}, {0.5886835843882436,
         56.911629005882276`}, {0.5869935415054769, 57.21719091979926}, {
        0.585, 57.32448999494575}, {0.583006458494523, 57.21719091979926}, {
        0.5813164156117563, 56.911629005882276`}, {0.580187165060324, 
        56.454323284663026`}, {0.579790625, 55.91489440671046}, {
        0.580187165060324, 55.37546552875789}, {0.5813164156117563, 
        54.91815980753864}, {0.583006458494523, 54.61259789362166}, {0.585, 
        54.50529881847517}, {0.5869935415054769, 54.61259789362166}, {
        0.5886835843882436, 54.91815980753864}, {0.589812834939676, 
        55.37546552875789}, {0.5902093749999999, 55.91489440671046}, {
        0.589812834939676, 56.454323284663026`}}], 
       LineBox[{{0.614812834939676, 47.67467736550035}, {0.6136835843882437, 
        48.1319830867196}, {0.6119935415054769, 48.43754500063658}, {0.61, 
        48.544844075783075`}, {0.6080064584945231, 48.43754500063658}, {
        0.6063164156117563, 48.1319830867196}, {0.605187165060324, 
        47.67467736550035}, {0.604790625, 47.135248487547784`}, {
        0.605187165060324, 46.59581960959522}, {0.6063164156117563, 
        46.13851388837597}, {0.6080064584945231, 45.832951974458986`}, {0.61, 
        45.72565289931249}, {0.6119935415054769, 45.832951974458986`}, {
        0.6136835843882437, 46.13851388837597}, {0.614812834939676, 
        46.59581960959522}, {0.615209375, 47.135248487547784`}, {
        0.614812834939676, 47.67467736550035}}], 
       LineBox[{{0.639812834939676, 41.64528197523201}, {0.6386835843882437, 
        42.10258769645126}, {0.6369935415054769, 42.40814961036824}, {0.635, 
        42.515448685514734`}, {0.6330064584945231, 42.40814961036824}, {
        0.6313164156117563, 42.10258769645126}, {0.630187165060324, 
        41.64528197523201}, {0.629790625, 41.10585309727944}, {
        0.630187165060324, 40.566424219326876`}, {0.6313164156117563, 
        40.10911849810763}, {0.6330064584945231, 39.803556584190645`}, {0.635,
         39.69625750904415}, {0.6369935415054769, 39.803556584190645`}, {
        0.6386835843882437, 40.10911849810763}, {0.639812834939676, 
        40.566424219326876`}, {0.640209375, 41.10585309727944}, {
        0.639812834939676, 41.64528197523201}}], 
       LineBox[{{0.6648128349396759, 37.87250240354363}, {0.6636835843882436, 
        38.32980812476288}, {0.6619935415054768, 38.63537003867986}, {
        0.6599999999999999, 38.74266911382635}, {0.658006458494523, 
        38.63537003867986}, {0.6563164156117562, 38.32980812476288}, {
        0.6551871650603239, 37.87250240354363}, {0.654790625, 
        37.33307352559106}, {0.6551871650603239, 36.793644647638494`}, {
        0.6563164156117562, 36.336338926419245`}, {0.658006458494523, 
        36.03077701250226}, {0.6599999999999999, 35.92347793735577}, {
        0.6619935415054768, 36.03077701250226}, {0.6636835843882436, 
        36.336338926419245`}, {0.6648128349396759, 36.793644647638494`}, {
        0.6652093749999999, 37.33307352559106}, {0.6648128349396759, 
        37.87250240354363}}], 
       LineBox[{{0.6898128349396759, 37.66094467055176}, {0.6886835843882436, 
        38.11825039177101}, {0.6869935415054769, 38.42381230568799}, {
        0.6849999999999999, 38.53111138083448}, {0.683006458494523, 
        38.42381230568799}, {0.6813164156117563, 38.11825039177101}, {
        0.680187165060324, 37.66094467055176}, {0.679790625, 
        37.12151579259919}, {0.680187165060324, 36.582086914646624`}, {
        0.6813164156117563, 36.124781193427374`}, {0.683006458494523, 
        35.81921927951039}, {0.6849999999999999, 35.7119202043639}, {
        0.6869935415054769, 35.81921927951039}, {0.6886835843882436, 
        36.124781193427374`}, {0.6898128349396759, 36.582086914646624`}, {
        0.6902093749999999, 37.12151579259919}, {0.6898128349396759, 
        37.66094467055176}}], 
       LineBox[{{0.714812834939676, 39.35340653448673}, {0.7136835843882436, 
        39.81071225570598}, {0.7119935415054769, 40.11627416962296}, {0.71, 
        40.223573244769455`}, {0.708006458494523, 40.11627416962296}, {
        0.7063164156117563, 39.81071225570598}, {0.705187165060324, 
        39.35340653448673}, {0.704790625, 38.81397765653416}, {
        0.705187165060324, 38.2745487785816}, {0.7063164156117563, 
        37.81724305736235}, {0.708006458494523, 37.511681143445365`}, {0.71, 
        37.40438206829887}, {0.7119935415054769, 37.511681143445365`}, {
        0.7136835843882436, 37.81724305736235}, {0.714812834939676, 
        38.2745487785816}, {0.7152093749999999, 38.81397765653416}, {
        0.714812834939676, 39.35340653448673}}], 
       LineBox[{{0.739812834939676, 41.680541597397315`}, {0.7386835843882437,
         42.137847318616565`}, {0.7369935415054769, 42.44340923253355}, {
        0.735, 42.55070830768004}, {0.7330064584945231, 42.44340923253355}, {
        0.7313164156117563, 42.137847318616565`}, {0.730187165060324, 
        41.680541597397315`}, {0.729790625, 41.14111271944475}, {
        0.730187165060324, 40.60168384149218}, {0.7313164156117563, 
        40.14437812027293}, {0.7330064584945231, 39.83881620635595}, {0.735, 
        39.73151713120946}, {0.7369935415054769, 39.83881620635595}, {
        0.7386835843882437, 40.14437812027293}, {0.739812834939676, 
        40.60168384149218}, {0.740209375, 41.14111271944475}, {
        0.739812834939676, 41.680541597397315`}}], 
       LineBox[{{0.764812834939676, 40.16437784428891}, {0.7636835843882437, 
        40.62168356550816}, {0.7619935415054769, 40.92724547942514}, {0.76, 
        41.03454455457163}, {0.7580064584945231, 40.92724547942514}, {
        0.7563164156117563, 40.62168356550816}, {0.755187165060324, 
        40.16437784428891}, {0.754790625, 39.62494896633634}, {
        0.755187165060324, 39.085520088383774`}, {0.7563164156117563, 
        38.628214367164524`}, {0.7580064584945231, 38.32265245324754}, {0.76, 
        38.21535337810105}, {0.7619935415054769, 38.32265245324754}, {
        0.7636835843882437, 38.628214367164524`}, {0.764812834939676, 
        39.085520088383774`}, {0.765209375, 39.62494896633634}, {
        0.764812834939676, 40.16437784428891}}], 
       LineBox[{{0.7898128349396759, 42.103657063381064`}, {
        0.7886835843882436, 42.560962784600314`}, {0.7869935415054768, 
        42.866524698517296`}, {0.7849999999999999, 42.97382377366379}, {
        0.783006458494523, 42.866524698517296`}, {0.7813164156117562, 
        42.560962784600314`}, {0.7801871650603239, 42.103657063381064`}, {
        0.779790625, 41.5642281854285}, {0.7801871650603239, 
        41.02479930747593}, {0.7813164156117562, 40.56749358625668}, {
        0.783006458494523, 40.2619316723397}, {0.7849999999999999, 
        40.154632597193206`}, {0.7869935415054768, 40.2619316723397}, {
        0.7886835843882436, 40.56749358625668}, {0.7898128349396759, 
        41.02479930747593}, {0.7902093749999999, 41.5642281854285}, {
        0.7898128349396759, 42.103657063381064`}}], 
       LineBox[{{0.8148128349396759, 39.106589179329546`}, {
        0.8136835843882436, 39.563894900548796`}, {0.8119935415054769, 
        39.86945681446578}, {0.8099999999999999, 39.97675588961227}, {
        0.808006458494523, 39.86945681446578}, {0.8063164156117563, 
        39.563894900548796`}, {0.805187165060324, 39.106589179329546`}, {
        0.804790625, 38.56716030137698}, {0.805187165060324, 
        38.02773142342441}, {0.8063164156117563, 37.57042570220516}, {
        0.808006458494523, 37.26486378828818}, {0.8099999999999999, 
        37.15756471314169}, {0.8119935415054769, 37.26486378828818}, {
        0.8136835843882436, 37.57042570220516}, {0.8148128349396759, 
        38.02773142342441}, {0.8152093749999999, 38.56716030137698}, {
        0.8148128349396759, 39.106589179329546`}}], 
       LineBox[{{0.839812834939676, 34.734396030830865`}, {0.8386835843882436,
         35.191701752050115`}, {0.8369935415054769, 35.4972636659671}, {0.835,
         35.60456274111359}, {0.833006458494523, 35.4972636659671}, {
        0.8313164156117563, 35.191701752050115`}, {0.830187165060324, 
        34.734396030830865`}, {0.829790625, 34.1949671528783}, {
        0.830187165060324, 33.65553827492573}, {0.8313164156117563, 
        33.19823255370648}, {0.833006458494523, 32.8926706397895}, {0.835, 
        32.78537156464301}, {0.8369935415054769, 32.8926706397895}, {
        0.8386835843882436, 33.19823255370648}, {0.839812834939676, 
        33.65553827492573}, {0.8402093749999999, 34.1949671528783}, {
        0.839812834939676, 34.734396030830865`}}], 
       LineBox[{{0.8648128349396759, 30.60902023748937}, {0.8636835843882436, 
        31.066325958708617`}, {0.8619935415054768, 31.371887872625596`}, {
        0.8599999999999999, 31.479186947772096`}, {0.858006458494523, 
        31.371887872625596`}, {0.8563164156117562, 31.066325958708617`}, {
        0.8551871650603239, 30.60902023748937}, {0.8547906249999999, 
        30.0695913595368}, {0.8551871650603239, 29.53016248158423}, {
        0.8563164156117562, 29.072856760364985`}, {0.858006458494523, 
        28.767294846448006`}, {0.8599999999999999, 28.659995771301507`}, {
        0.8619935415054768, 28.767294846448006`}, {0.8636835843882436, 
        29.072856760364985`}, {0.8648128349396759, 29.53016248158423}, {
        0.8652093749999998, 30.0695913595368}, {0.8648128349396759, 
        30.60902023748937}}], 
       LineBox[{{0.8898128349396759, 25.848971245172255`}, {
        0.8886835843882436, 26.3062769663915}, {0.8869935415054768, 
        26.61183888030848}, {0.8849999999999999, 26.71913795545498}, {
        0.883006458494523, 26.61183888030848}, {0.8813164156117562, 
        26.3062769663915}, {0.8801871650603239, 25.848971245172255`}, {
        0.8797906249999999, 25.309542367219684`}, {0.8801871650603239, 
        24.770113489267114`}, {0.8813164156117562, 24.31280776804787}, {
        0.883006458494523, 24.00724585413089}, {0.8849999999999999, 
        23.89994677898439}, {0.8869935415054768, 24.00724585413089}, {
        0.8886835843882436, 24.31280776804787}, {0.8898128349396759, 
        24.770113489267114`}, {0.8902093749999999, 25.309542367219684`}, {
        0.8898128349396759, 25.848971245172255`}}], 
       LineBox[{{0.9148128349396759, 21.01840300852452}, {0.9136835843882436, 
        21.475708729743765`}, {0.9119935415054768, 21.781270643660744`}, {
        0.9099999999999999, 21.888569718807243`}, {0.908006458494523, 
        21.781270643660744`}, {0.9063164156117562, 21.475708729743765`}, {
        0.9051871650603239, 21.01840300852452}, {0.904790625, 
        20.47897413057195}, {0.9051871650603239, 19.93954525261938}, {
        0.9063164156117562, 19.482239531400133`}, {0.908006458494523, 
        19.176677617483154`}, {0.9099999999999999, 19.069378542336654`}, {
        0.9119935415054768, 19.176677617483154`}, {0.9136835843882436, 
        19.482239531400133`}, {0.9148128349396759, 19.93954525261938}, {
        0.9152093749999999, 20.47897413057195}, {0.9148128349396759, 
        21.01840300852452}}], 
       LineBox[{{0.9398128349396759, 19.57275849974673}, {0.9386835843882436, 
        20.030064220965976`}, {0.9369935415054769, 20.335626134882954`}, {
        0.9349999999999999, 20.442925210029454`}, {0.933006458494523, 
        20.335626134882954`}, {0.9313164156117563, 20.030064220965976`}, {
        0.930187165060324, 19.57275849974673}, {0.929790625, 
        19.03332962179416}, {0.930187165060324, 18.49390074384159}, {
        0.9313164156117563, 18.036595022622343`}, {0.933006458494523, 
        17.731033108705365`}, {0.9349999999999999, 17.623734033558865`}, {
        0.9369935415054769, 17.731033108705365`}, {0.9386835843882436, 
        18.036595022622343`}, {0.9398128349396759, 18.49390074384159}, {
        0.9402093749999999, 19.03332962179416}, {0.9398128349396759, 
        19.57275849974673}}]}, 
      {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[0.4], 
       Dashing[{}], CapForm[None], LineBox[{{0.05, 15.}, {0.45, 15.}}]}, 
      {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[0.4], 
       Dashing[{}], CapForm[None]}, 
      {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[0.4], 
       Dashing[{}], CapForm[None], LineBox[{{0.05, 15.}, {0.05, 90.}}]}, 
      {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[0.4], 
       Dashing[{}], CapForm[None]}, 
      {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[0.4], 
       Dashing[{}], CapForm[None], LineBox[{{0.05, 90.}, {0.45, 90.}}]}, 
      {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[0.4], 
       Dashing[{}], CapForm[None]}, 
      {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[0.4], 
       Dashing[{}], CapForm[None], LineBox[{{0.45, 15.}, {0.45, 90.}}]}, 
      {RGBColor[0.640004, 0.580004, 0.5], AbsoluteThickness[1], Opacity[0.4], 
       Dashing[{}], CapForm[None]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.07020202020202021, 18.40909090909091}, {
        0.10656565656565659`, 18.40909090909091}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.11060606060606062`, 19.800556586270872`}, {
        0.146969696969697, 19.800556586270872`}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.15101010101010104`, 23.04730983302412}, {
        0.18737373737373741`, 23.04730983302412}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], 
       LineBox[{{0.19141414141414145`, 28.14935064935065}, {
        0.22777777777777786`, 28.14935064935065}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.23181818181818187`, 35.106679035250465`}, {
        0.26818181818181824`, 35.106679035250465`}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.27222222222222225`, 43.919294990723564`}, {
        0.3085858585858587, 43.919294990723564`}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.3126262626262627, 54.58719851576994}, {
        0.34898989898989907`, 54.58719851576994}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.3530303030303031, 67.1103896103896}, {
        0.38939393939393946`, 67.1103896103896}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.3934343434343435, 81.48886827458257}, {
        0.42979797979797985`, 81.48886827458257}}]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.07020202020202021, 28.14935064935065}, {
        0.10656565656565659`, 28.14935064935065}}]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.11060606060606062`, 29.540816326530614`}, {
        0.146969696969697, 29.540816326530614`}}]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.15101010101010104`, 32.78756957328386}, {
        0.18737373737373741`, 32.78756957328386}}]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.19141414141414145`, 37.88961038961039}, {
        0.22777777777777786`, 37.88961038961039}}]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.23181818181818187`, 44.8469387755102}, {
        0.26818181818181824`, 44.8469387755102}}]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.27222222222222225`, 53.6595547309833}, {0.3085858585858587,
         53.6595547309833}}]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.3126262626262627, 64.32745825602969}, {
        0.34898989898989907`, 64.32745825602969}}]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.3530303030303031, 76.85064935064935}, {
        0.38939393939393946`, 76.85064935064935}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.07020202020202021, 32.32374768089054}, {
        0.10656565656565659`, 32.32374768089054}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.11060606060606062`, 33.7152133580705}, {0.146969696969697, 
        33.7152133580705}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.15101010101010104`, 36.96196660482375}, {
        0.18737373737373741`, 36.96196660482375}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.19141414141414145`, 42.06400742115028}, {
        0.22777777777777786`, 42.06400742115028}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.23181818181818187`, 49.02133580705009}, {
        0.26818181818181824`, 49.02133580705009}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.27222222222222225`, 57.8339517625232}, {0.3085858585858587,
         57.8339517625232}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.3126262626262627, 68.50185528756957}, {
        0.34898989898989907`, 68.50185528756957}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.3530303030303031, 81.02504638218925}, {
        0.38939393939393946`, 81.02504638218925}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAATYpVTwOgvz99ocRG8cwzQIeytqY0
bb4/C5fxziqVM0DhvPHfz1a+P4PzryxhbTNARR2ykDNAvj/dNr3S7EYzQDv7
0VIqKb4/L2vk6xUjM0BbW9bvghG+Pxfm7+gKAzNAASwWRRL5vT87HkXh1Ocy
QAVDF+y0370/wePwYk3SMkDfcNKWUMW9PyfaXBYWwzJAUXF8EtWpvT+rP+6H
kroyQMHQ4eY8jb0/axCsVOS4MkDJAjaMjW+9P0dQj9/pvTJAp0tENddQvT8F
wTKcP8kyQOXaEzA0Mb0/Jb8s4kPaMkCn2h7jxxC9P4F6cCMd8DJAk1wOcb3v
vD9xfJhIwgkzQBFcXRBGzrw/W2/a4AQmM0CZsTEnl6y8PyVJa8GcQzNAIwcG
PuiKvD/vIvyhNGEzQJ8GVd1wabw/2RU+Ond9M0CPiERrZki8P8sXZl8clzNA
UYhPHvonvD8n06mg9awzQIsXHxlXCLw/RdGj5vm9M0BtYC3CoOm7PwNCR6NP
yTNAc5KBZ/HLuz/fgSouVc4zQOPx5jtZr7s/oVLo+qbMM0BX8pC33ZO7PyO4
eWwjxDNAMSBMYnl5uz+JruUf7LQzQDM3TQkcYLs/D3SRoWSfM0DZB41eq0e7
PzOs5pkuhDNA+2eR+wMwuz8bJ/KWI2QzQO1Fsb36GLs/bVsZsExAM0BTpnFu
XgK7P8eeJlbYGTNArbCsp/nruj9B++SzDvIyQPvXiH+N+Lc/66KLLrpoMkCx
2gTq
        "]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.10136469223502122`, 17.338466380155257`}, {
        0.09363636363636367, 18.409090909090917`}, {0.09959868527708123, 
        20.116863046381386`}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAA/HS/T/f7xD8rnkl/HAw3QJy5/tLw
TsQ/s1SLmVJ5NkDgayjL8EfEP0Feo5h0TTZAkqWuwLNAxD8zQ+j41yI2QH4a
JQn/OMQ/TZrQwbH6NUBa9XyTnDDEP9Up58Ae1jVAgkrs+1wnxD+/duuXGLY1
QDrcJV4ZHcQ/rxT1JGybNUBIkfbTtBHEP/dT+qKxhjVAenmUkR0FxD9XaC7Q
Rng1QC5dspRN98M/5aTEU0twNUAGdJ3fSujDP4u2iYafbjVANq4fPifYwz+H
aUqq5XI1QPQkbJb/xsM/i20QhIV8NUD+FdDM+rTDP/EuxDWyijVA+GwVRUii
wz/DKKYdcpw1QCz/ShAej8M/v5QrbqiwNUDOGN3YtnvDPx3c3R8gxjVAcjJv
oU9owz97I5DRl9s1QKbEpGwlVcM/d48VIs7vNUCgG+rkckLDP0mJ9wmOATZA
qgxOG24wwz+xSqu7ug82QGiDmnNGH8M/s05xlVoZNkCYvRzSIg/DP7EBMrmg
HTZAcNQHHSAAwz9VE/fr9Bs2QCS4JSBQ8sI/4U+Nb/kTNkBWoMPduOXCP0Nk
wZyOBTZAZlWUU1Tawj+Lo8Ya1PA1QBznzbUQ0MI/fUHQpyfWNUBEPD0e0cbC
P2eO1H4htjVAIBeVqG6+wj/tHet9jpE1QAyMC/G5tsI/B3XTRmhpNUC+xZHm
fK/CP/tZGKfLPjVAAni73nyowj+HYzCm7RI1QNQb2Wc8KME/faHERvHMM0DE
1AmK
        "]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.14242671117220007`, 19.192362272582567`}, {
        0.13404040404040407`, 19.800556586270876`}, {0.13854633768934893`, 
        21.808728783968203`}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], LineBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAA1CTU9+wnyj/xmBrYOyY8QKjlS8UX
v8k/g0vT9nmaO0C6+3ZQ8bvJP3GJN3apbDtAogseenO4yT8Nzw/f/T87QOju
YjxKtMk/rwQq2ZAVO0DyFKonKK/JP5FOxfdl7jpAeOdpXMmoyT/l6OK/YMs6
QFY55ib2oMk/GYDz6TutOkB+pC4jhZfJP99/5TSClDpAzLZQ1FyMyT8BFiwR
iYE6QKj1F590f8k/32wzWG10OkCo27ge1XDJPxtajzASbTpA9tol0JdgyT/n
r8wpIms6QJZZTxfmTsk/kwL9hBJuOkC2hPGn9zvJP7Glr4kodTpAmvKVYRAo
yT8RXeOygH86QNoz2LN9E8k/dQRZbReMOkD0bpakk/7IP4ezQhHTmTpADKpU
lanpyD+bYiy1jqc6QEzrlucW1cg//wmibyW0OkAyWTuhL8HIP1/B1Zh9vjpA
UITdMUGuyD97ZIidk8U6QPQCB3mPnMg/Kbe4+IPIOkA+AnQqUozIP/UM9vGT
xjpAQugUqrJ9yD8z+lHKOL86QBwn3HTKcMg/DVFZER2yOkBqOf4lomXIPzHn
n+0jnzpAkqRGIjFcyD/35pE4aoY6QHD2wuxdVMg/K36iYkVoOkD4yIIh/03I
P38YwCpARTpAAO/JDN1IyD9hYltJFR46QETSDs+zRMg/A5h1Q6jzOUAw4rX4
NUHIP5/dTaz8xjlAQPjggw8+yD+NG7IrLJk5QE4ODA/pOsg/e1kWq1trOUA6
HrM4azfIPxef7hOwPjlAfgH4+kEzyD+51AgOQxQ5QIgnP+YfLsg/mx6kLBjt
OEAO+v4awSfIP++4wfQSyjhA7Et75e0fyD8lUNIe7qs4QBS3w+F8Fsg/6U/E
aTSTOEBiyeWSVAvIPw3mCkY7gDhAPgitXWz+xz/rPBKNH3M4QEDuTd3M78c/
JypuZcRrOECK7bqOj9/HP/N/q17UaThALmzk1d3Nxz+f0tu5xGw4QEyXhmbv
usc/u3WOvtpzOEAyBSsgCKfHPxstwucyfjhAckZtcnWSxz+B1DeiyYo4QIqB
K2OLfcc/k4MhRoWYOECqy+0PMlTGPyueSX8cDDdATc+AGg==
        "]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.1830983680599399, 22.857551521711788`}, {
        0.17444444444444446`, 23.047309833024126`}, {0.1775407725438739, 
        25.24216142856419}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], LineBox[CompressedData["
1:eJwVjn9Q03UYx+eU/JFiFgymuKLzmodehzrAFn2f9ygJ5Q5BHIyKJAaDsVsx
ZXKogXJ4elyFnhxHSLoUGQ7EH8FcecrSGFO/ny9iINxFmrtrUXYim8D5I+rb
H88997r387rnHZ3/2ZZCqUQiWSfO/9sxOHbcl9lPY96jbfYvNbh9MtOhvCbQ
X+e9LvkCDXxxivG3RG5qbLsXDACd7fcK7l8VSHEnIS1jFHA/1mZf/FEg557j
OOcBWptNr+b2CDQn5Nii/RcAl73IU3VJoKm6mTNxNuCxRxH/S7dAKU1FA+GH
gNp3vHcSOwXyV4Ta9dXA0y7X3v0toh8XrNhQDgi5vk5Ho0DbE5TrvZ8ClXMz
/c5agfLCvw7eLQZq5jnTru8SqNmb8om+EHAuH6wKMwoU/0yyJaIAkDWM1I1q
RT92mcwucrJ5j7VMI1Dx+3xXhwG4EjE0rF4tUGmfdvg7o9jv1ApTg0ygtGNf
aTgzEKMqm5mQCLTa2tfuLQVsd/k81wNGqsl0oX8HMNhdmpw+zGjlQql5yArE
vmnNivyJkUETtaZwJ1Dw7pED+guMJGWD0XIxL3lvatx6glGisqbuGwsQ9dCg
rK5nFBMytanLBDxqOKS1H2TUODdmfoIeyAvd9+94JSPn1dDRSB0QqImxZZQz
2nqi+7xhE7C25f7iMxZGrR2KoWQ1kHT2V2e/WfQTqqzTSmBldrDSamLk7/k8
iX8FUNuMltQSRs/4G8as54QXZKv+CBgZzU75M3lJPyGsbXJViJhvCz9d32sj
rFC7SyNE7vEV+yq2Ex6d3ee/It735h7oUW0gSJ9Mj9QXM5p0ZLUE5IQx26Jv
1QZGhy9lcs0THJ62z0/JzWdkHQir+ofnsP6m+6LrI0Zyv7/3cgcHXlOiW6pl
pD2lsuQc5pD4/QdSfaroL5uRLd/N4aX8mtiDxMj8muHI6yUc3C9OFtWvYZQ6
unFB+sccPAt1t1qjxX5Jp3/XZYv/onfOCixmFLTL+9xbOeiadi354TlPlpfT
Nv+m5VBrUUxnjPH0Ic598SCHgySqPCfyZ55MuDbwZBuHeIfn7x2XeVI+VLWG
FnGo3i11KffepInGpSNvv5GI/wDIDYIR
        "]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.2235114440165486, 28.306041340565375`}, {
        0.2148484848484849, 28.149350649350655`}, {0.21671820209366788`, 
        30.443555083253667`}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], LineBox[CompressedData["
1:eJwVkGkw3VcYh4V0xtJcRq2ZRsZwQz5USy0ljffl/G8WsdxcCdqgEgSpfQlR
ZqS41Q4RikqQpGONGElVr0hloUUsuf2fWxeR5LaoLaEhlhGG6emHM2eeeX/z
nPf8zM/EScLV1dTUCDv/325d2xbzoICznDjl1qoIh5qrNkN1FDCokyZuzRCh
UVBDo+xdBSRbJI62h4uwRt6o8WSXAmTHq9LsfUS4+sxWPUaggHtyu74SZxF2
zFjanGbs+l7nJXehCAszB2+ms3xajM/9cn0RvjSe3C5mfhvH79+O7xBhpdl6
eYGmArIuXbl3cplDUnxVFbBTAY/VzayNZjgUHctU/btNIdFN2m/zgsMDCQvf
nlynoF8ZbVqi5PAbjcD0a4sUPKWGCxY8h0FXnbnpGQrqfyXJ6wY5dP11IMhX
RSHeS2Gi6OewZKyvxmCIQnD2/lEPxs2lnkVf9FEQaL46fJOxoUGvVewDCgHV
L/7IGOAwo9jtQcbPFG648v5i5ivz+r2xt4GC+Lei3mbG89FdS3nXKLi+nZVa
MZYXnNBZK6HQFHGYSpivxtJOeTCfQsij2hZlD4eLshvd0hwKlY3e0vBODqef
6yUsZFL49B0HZX87h7Oly/HZaRSmSVXq5G0OC7TKZN7JFGzumk9VV3OIerfE
RxMoZOlZ1xmXcljZ2Fl7Oo6C/dMvJ0JyOIzFKPOvYllfH2/otSVw6OAZ6BXH
eCU1bzgsiPX12eQxXZZfW9lj1X2Y/XdgqkYYT8HF4mgv2HLod2HRN435J1yI
j2g3h+VWm+oDiRS+kxwc8dDgUHhl69R4EoXBrMjU7nmCaXU5n19k+/FbW73C
EYKuLanSFMYS9/yCP7sI6h3Zq17I8pcrd3fsv0MwesLBv575ufDg9cTrBPfO
eSz9yPYrux/WPn2ZYHfggmPMOQoq27l99TkEew15R41wCnnxx/sephPsOIAT
UcEU9g04mQiTCGrJmxUtfhTCfvn7VWsMQVVYfuWGFwUTATxxOkfwYa6ZLIKj
IM2oMg6NJGhc+/6WtQuF5JaV4WcRBD8KuT6X9CEFSyfZIRc2L1eZZn1tSSFa
0SDfFUVwO7DEqMiUgiymwm+csYmJscZzAXvvTWAPMH+ck6FH1U4KJ6xbc++y
uTigPlR7k4dHZfr8JPMLX+d8IHnDw/nX8T+dDSOYeHF5T8VLHlqemuauBROM
rA/t2/EPDxJ7taFT/gSjQg71/aDiYTsx8nyyF+tvaFYQOsYDNzM/ae9GsGts
qyFohIcyWK5psCNolmKwnaLkwVPTaXzJnOCidseFwiEepGe6dY/oEmwzul2b
zVi73le5uuGOWpaONRYsL7CcE/pNuWNZ6SdbzsM8iCUGPbzcHUcJacpn/vUo
gfdwmzs2lercEfjxMPu4oqG+wA3/Ay4lAXg=
        "]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.2637872972502752, 35.53791345494352}, {0.2552525252525253, 
        35.106679035250465`}, {0.2561123166881147, 37.444457210532974`}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], LineBox[CompressedData["
1:eJwVkHk01WkcxkskUunOJFHKtVSWHKE0I99vQ34LM2U5WWpmkK3rlpStRrJO
uaOZaOjGdblu0yKjLOEcS6VFNJPG762mErqkuK0nVAbNrz/e857nvM95P8/z
mIbG+IRrTJs2zZc/n28bI50Pg3cJvGmx8lnp6Ymptm3O7ucJZLoKNRJ7WfzG
baFdYRWBh7EBWQ9usmhkn6aqrCFgo3x+5mQ1i57OK/LcLhKYNb9He30xi5uM
C6JM6ghEtDgGfTrM4rpN1bV6vM7zvzDgksAix8V3D9QSWAwBgc7hLIan2I8d
qiYgCPChzLbwPK+KD6pKAgPlvg6LGRb97u9IeH2WQPf+7dG2rixWZQ121ygJ
1GbuV3g5sagVtNXJTUZg5FL/5q2rWNQ9mLij6RgBKbNvePlKFkdHNnzBSAho
XnJoirFgsdaD6zdO5f17N6U9EbLYXqW4sCuewO7wO2nLTFkcG8n+KlVEYNDv
nPDmUhZNnfdcy/2RQLD7z1djTFh0VmLugB+/h5P2tcrFn/3/hNSzBDqGhdnL
jFhUiWSz3TcQWBP8OCjKgMXB3xqg2ZnAv0N7Rhzns/h1mK3Uy56AkUW30k2X
RamgfErfmt9/1bsHodNZLC+OTF5iSWB4SkMQN8bgoWhVSpKQQIu35pR4iEFD
A7nUeBmBatGU2v8hgzWFIZffmRBw9TkV7NvOYPHtA3oqXkepTdVH6xhUVKlV
TUsJ3JQmrfctY/BOQ16etymBkzN3ydQ5DJ49NbExwozfY+3UpboEBsVNXi5N
FgToaEe3RcEM2nXJVgtWEJDLRTd+YhjUvjxz0NKKz9s5PuThwKBz25/5jXz+
v9a/oXuXMOhSbiwusCFgpfYoUugwaNmztiGT136ZrRa9YzReDv2vdxvv74sW
FT58SqP3nPqPn/j/SWbY4ev3aFz1yH4iiOefuR8e19JOI0a83hfJ9y09HV/R
2UJj8ZfiPmsjAklVOapXF2l8+7zPuVFAoOHFaO5kJY1jcybFjroEghJ+se44
S+OTjDaDK9P4/uqNk/NP0Vh6N+DZsTEOGkpDWjOUNNbh8tpBNQeOearWVgWN
qox5rh/6OChPa94uKqVxbtv7Np17HJjHSjUFJTSar77x+7ZbHMhDF2l5F9PY
n+EfbneFg18XOnW0FtJ4+6PpvKZ6DsZzXhfpHqeRM3F1czrPgcwgy+l+Lo3L
31UXXTvNQY/3q4GnEhqzFHYa2QoOardqGWul01hg8/JgvoyDCusFvgaJNMaN
R6a/kXKQnmIA80Q0av1hJjtWwEHCcX3b8SAaS1Y+uxqdz4HGwQbFKENj9vcz
9IN4bWXoaOOwlsYjGDvoyPsl1yUpo0IamynDgvbjHEQ5pD4+MofnOaUzPSf4
PcL0pwe+pzDQswsceb6e1COzsY9C4xDhGomcg+BbydomHRSOfJczJC/loHpC
z3qohkLzLQ4nHMr4/iINSZqcwhXrFDFzlRy8WhjY7SahULCzuXGCfzesIhFp
iRRWvE3tJ3zfMmnyo+QICl1lLpOJJRxIqxLaI/15nqj+U1cRB2LNpIvBLIW2
o3EHevn8YeTQy1igUKJ82688yoFLj9wsdw2FPYkRLg7ZHCQvmsWV2FHYL0vf
XZHKgYmyWCy2ovC24FujdYkc5BgGuNZaUngkrGd49k4O9v+9d4alOYVlnRX1
P4RyMNYyMiNcSGGnIH/Dbn8OdlV2ntQzpVD6ckGmzosuiHDfHH9udCP+D5wU
de4=
        "]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.3040044311005117, 44.56505091532085}, {
        0.29565656565656573`, 43.91929499072357}, {0.29570293826577765`, 
        46.26858746140289}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], LineBox[CompressedData["
1:eJwVknsw1WkYx2VtFFpFsVQum/slxy0s3qcw1Tq/9/cL45ITJU5bGZfS6bKd
NtcSI5JqLZHLdKIOubO5ZqJdSeI9opJrrTaiOJuK/e0fzzzzmWe+M5/5vq9u
cIRnqKyMjIwXO//vdUdUO4cPS9C27MxclXYGhst0jG0tJSj2S6dceCgDAQXD
PF9rCVoMmVn02c1A5EO6zcZOghrJmQ/hNAMDW99tSbaXoJseFatG3RiY2Dva
tMFRgqb4DrPPHRmYzn78tprlV7JXtWI4DJgxZ16ZsKwwsln4zoiB+S1B8v5s
njiKfO11GZCoaNPmthLklfApMEKTgcNuajN5rM+PUGB9VY2BtQffVNSbSNDj
f/RtS75jgGqdEqX+IEGKqudLcxQZqL1Uw3fWkiDhaf1gPwUGdM4KOmZXS9Dv
/KzdDd8yYKqW6jImL0FrpXu1RN8wkLTQ24y/ElR3oUt2ehkDCWoPBdGzBOUZ
Fo2FyDAQY9FglvWaIJUkaUrVVxpeqcmVyr0gyK+sJ8B1gYa3Ii39+R6CuE+C
XmjM0+B5ZSCx5CFBiUU7u0be09DIL3Db3ULQoRPx1n6TNMw13XKwqCdopG2H
kfMIDbljwi/bKwlS2ohNQ/tpsNY4ev2PUoIGMm70VnbSoDZjNXHxNkG9Rm6j
ek00DPWrKjcWE3RkwOZabSkNWimty6xYbr3GD0i/TsOmDrH5XywXduuKnyXT
wHldWLWHzVvKWxx7dJyGrKBtxpViguRmrpRUBdNQmlCWln6X9e29e3mcS4PR
iai2CtbnTNHC+Ro7GvIPWf3bV0OQQOAqTNKhoSYtL6iC9Z/3D+TXraRBZ4XL
0xUNBHW4tmffmMNgbmQTkN1IkPepp/szhzHYheics20iyL48tfpFF4Yj6o9/
ucXeL0Q2n6xuwOC8VJovuUeQgd5dC64Yg3Z/xGRJHUE6NV7O9XkYyhVDU7Sr
CJoyuzmxIhMDz9KBdmD70Ui8/TcnGUNGEnJTFhGU2hP5cl0chiV/Bdl7uQRF
F5W4ppzGwN/evj/qCkHik5k2PscxRA2+fBacQlB+ll616VEM3S36vEcxBE22
fI2vi8DQOfj9mg8Cguo/F+8oCsPQMafcoRHG+tr6KaUfxGD43PunuH0EdfOs
BzfyMXAiw5qjfQl6IGzmfdyH4bc9pnommCAZz2KqkYdBzuLjUL87QWObxsut
fTA4nVvove1CEC/q1k0NjGGipOvqA3u2/z/FxeCG4dTQfQdHG7Y/kPVOs8cQ
UBsXs4rD/q++wuBFEwz6eSEip82sb2Km+mUtDMFeqjllFgQ5ubcPhK3EcPji
UsdO9r5RGGteJaXguHiOeW5JUHFF6kfRKAXDBhltVtYEnc6RmqR3USDlLjNT
sWN9Y9aotdRSEIlag6wc2PfdFaCQkU/BG05chrcT279e4ZeQFAoWfWcWOIig
8OVN45cFFBzoTg0/v5UgeG+4XriPgujp+HlNV4K6DGxGIykKhKZRepUslwdO
29Y5UlD3UlvdiGXZDbqf0o0piH8g4+LD5vO6VosNNSng5zYnmLD9ZO2vvJep
RMGnnirD66zPz8/k+eMyFBRIkyZrWP9LVsoHlaVcGGDShpLNCFL49cme2Sku
uOv65zhuYn13Kd0/8IYLd1ZpLE1rEmRkMF/BGeVCbf7mY8MqBK3fHmcrP8QF
9SSB1GM5QSHhgXKZg1xQLTh0J+pzH7IRKXac7edCrLuOn1xsH3rfaOJp7OEB
/wHB7HNY
        "]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.3442053876796955, 55.400977550172186`}, {
        0.33606060606060606`, 54.587198515769956`}, {0.33545399842668056`, 
        56.930783447161346`}}]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], LineBox[CompressedData["
1:eJwVkX041Wkexk1oK2UMvaxUkopJk2Oyccal7zdl0JTxex6N2Kj0NjibJqzS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        "]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       LineBox[{{0.38441073063417386`, 68.05713662458008}, {
        0.3764646464646465, 67.1103896103896}, {0.37533065627742096`, 
        69.43959099157664}}]}, 
      {Hue[0.5808841755627379, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 38.049458201917055`}, {
        0.10656565656565659`, 38.049458201917055`}}]}, 
      {Hue[0.5808841755627379, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 39.518961842126956`}, {
        0.146969696969697, 39.518961842126956`}}]}, 
      {Hue[0.5808841755627379, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 42.947803669283374`}, {
        0.18737373737373741`, 42.947803669283374`}}]}, 
      {Hue[0.5808841755627379, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 48.33598368338632}, {
        0.22777777777777786`, 48.33598368338632}}]}, 
      {Hue[0.5808841755627379, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 55.683501884435785`}, {
        0.26818181818181824`, 55.683501884435785`}}]}, 
      {Hue[0.5808841755627379, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 64.99035827243178}, {
        0.3085858585858587, 64.99035827243178}}]}, 
      {Hue[0.5808841755627379, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 76.25655284737431}, {
        0.34898989898989907`, 76.25655284737431}}]}, 
      {Hue[0.04893981948167165, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 81.84643002571605}, {
        0.10656565656565659`, 81.84643002571605}}]}, 
      {Hue[0.04893981948167165, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 83.31400004612968}, {0.146969696969697,
         83.31400004612968}}]}, 
      {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 70.70124536129742}, {
        0.10656565656565659`, 70.70124536129742}}]}, 
      {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 72.05109734945091}, {0.146969696969697,
         72.05109734945091}}]}, 
      {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 75.2007519884757}, {
        0.18737373737373741`, 75.2007519884757}}]}, 
      {Hue[0.018715578839379847`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 80.1502092783718}, {
        0.22777777777777786`, 80.1502092783718}}]}, 
      {Hue[0.9735598590416055, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 72.62253155449072}, {
        0.10656565656565659`, 72.62253155449072}}]}, 
      {Hue[0.9735598590416055, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 74.18293827920316}, {0.146969696969697,
         74.18293827920316}}]}, 
      {Hue[0.9735598590416055, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 77.82388730353215}, {
        0.18737373737373741`, 77.82388730353215}}]}, 
      {Hue[0.9735598590416055, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 83.54537862747773}, {
        0.22777777777777786`, 83.54537862747773}}]}, 
      {Hue[0.9346043463681922, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 83.52237195371514}, {
        0.10656565656565659`, 83.52237195371514}}]}, 
      {Hue[0.9346043463681922, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 85.17522887844618}, {0.146969696969697,
         85.17522887844618}}]}, 
      {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 69.49322648464904}, {
        0.10656565656565659`, 69.49322648464904}}]}, 
      {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 70.91349360868493}, {0.146969696969697,
         70.91349360868493}}]}, 
      {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 74.22745023143531}, {
        0.18737373737373741`, 74.22745023143531}}]}, 
      {Hue[0.8069449945151539, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 79.43509635290019}, {
        0.22777777777777786`, 79.43509635290019}}]}, 
      {Hue[0.22606081895241606`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 67.94191299516241}, {
        0.10656565656565659`, 67.94191299516241}}]}, 
      {Hue[0.22606081895241606`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 69.56243529160436}, {0.146969696969697,
         69.56243529160436}}]}, 
      {Hue[0.22606081895241606`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 73.34365398330222}, {
        0.18737373737373741`, 73.34365398330222}}]}, 
      {Hue[0.22606081895241606`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 79.28556907025599}, {
        0.22777777777777786`, 79.28556907025599}}]}, 
      {Hue[0.17712099947074442`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 71.2949263831755}, {
        0.10656565656565659`, 71.2949263831755}}]}, 
      {Hue[0.17712099947074442`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 72.56105120094776}, {0.146969696969697,
         72.56105120094776}}]}, 
      {Hue[0.17712099947074442`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 75.51534244241638}, {
        0.18737373737373741`, 75.51534244241638}}]}, 
      {Hue[0.17712099947074442`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 80.15780010758137}, {
        0.22777777777777786`, 80.15780010758137}}]}, 
      {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 37.091825734308486`}, {
        0.10656565656565659`, 37.091825734308486`}}]}, 
      {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 38.67785737654323}, {0.146969696969697,
         38.67785737654323}}]}, 
      {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 42.37859787509097}, {
        0.18737373737373741`, 42.37859787509097}}]}, 
      {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 48.19404722995169}, {
        0.22777777777777786`, 48.19404722995169}}]}, 
      {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 56.12420544112541}, {
        0.26818181818181824`, 56.12420544112541}}]}, 
      {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 66.16907250861212}, {
        0.3085858585858587, 66.16907250861212}}]}, 
      {Hue[0.15840542063136456`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 78.32864843241181}, {
        0.34898989898989907`, 78.32864843241181}}]}, 
      {Hue[0.18484556158975904`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 49.66873759354689}, {
        0.10656565656565659`, 49.66873759354689}}]}, 
      {Hue[0.18484556158975904`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 50.80753505281318}, {0.146969696969697,
         50.80753505281318}}]}, 
      {Hue[0.18484556158975904`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 53.46472912443451}, {
        0.18737373737373741`, 53.46472912443451}}]}, 
      {Hue[0.18484556158975904`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 57.640319808410894`}, {
        0.22777777777777786`, 57.640319808410894`}}]}, 
      {Hue[0.18484556158975904`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 63.33430710474232}, {
        0.26818181818181824`, 63.33430710474232}}]}, 
      {Hue[0.18484556158975904`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 70.5466910134288}, {0.3085858585858587,
         70.5466910134288}}]}, 
      {Hue[0.18484556158975904`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 79.27747153447032}, {
        0.34898989898989907`, 79.27747153447032}}]}, 
      {Hue[0.25024121522156684`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 51.34580905356087}, {
        0.10656565656565659`, 51.34580905356087}}]}, 
      {Hue[0.25024121522156684`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 52.50150840071208}, {0.146969696969697,
         52.50150840071208}}]}, 
      {Hue[0.25024121522156684`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 55.198140210731566`}, {
        0.18737373737373741`, 55.198140210731566`}}]}, 
      {Hue[0.25024121522156684`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 59.43570448361932}, {
        0.22777777777777786`, 59.43570448361932}}]}, 
      {Hue[0.25024121522156684`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 65.21420121937534}, {
        0.26818181818181824`, 65.21420121937534}}]}, 
      {Hue[0.25024121522156684`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 72.53363041799963}, {
        0.3085858585858587, 72.53363041799963}}]}, 
      {Hue[0.25024121522156684`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 81.39399207949221}, {
        0.34898989898989907`, 81.39399207949221}}]}, 
      {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 67.05202598264096}, {
        0.10656565656565659`, 67.05202598264096}}]}, 
      {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 68.45721701837223}, {0.146969696969697,
         68.45721701837223}}]}, 
      {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 71.73599610174523}, {
        0.18737373737373741`, 71.73599610174523}}]}, 
      {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 76.88836323275993}, {
        0.22777777777777786`, 76.88836323275993}}]}, 
      {Hue[0.44329622070641295`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 83.91431841141635}, {
        0.26818181818181824`, 83.91431841141635}}]}, 
      {Hue[0.21723540175399692`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 84.30955640120766}, {
        0.10656565656565659`, 84.30955640120766}}]}, 
      {Hue[0.0401144022832525, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 49.512774730462596`}, {
        0.10656565656565659`, 49.512774730462596`}}]}, 
      {Hue[0.0401144022832525, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 50.814250006339606`}, {
        0.146969696969697, 50.814250006339606`}}]}, 
      {Hue[0.0401144022832525, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 53.851025650052605`}, {
        0.18737373737373741`, 53.851025650052605`}}]}, 
      {Hue[0.0401144022832525, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 58.62310166160161}, {
        0.22777777777777786`, 58.62310166160161}}]}, 
      {Hue[0.0401144022832525, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 65.13047804098662}, {
        0.26818181818181824`, 65.13047804098662}}]}, 
      {Hue[0.0401144022832525, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 73.37315478820761}, {
        0.3085858585858587, 73.37315478820761}}]}, 
      {Hue[0.0401144022832525, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 83.35113190326463}, {
        0.34898989898989907`, 83.35113190326463}}]}, 
      {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 48.91909370858454}, {
        0.10656565656565659`, 48.91909370858454}}]}, 
      {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 50.304296154842746`}, {
        0.146969696969697, 50.304296154842746`}}]}, 
      {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 53.53643519611191}, {
        0.18737373737373741`, 53.53643519611191}}]}, 
      {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 58.61551083239203}, {
        0.22777777777777786`, 58.61551083239203}}]}, 
      {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 65.5415230636831}, {
        0.26818181818181824`, 65.5415230636831}}]}, 
      {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 74.31447188998511}, {
        0.3085858585858587, 74.31447188998511}}]}, 
      {Hue[0.8817089816518879, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 84.93435731129809}, {
        0.34898989898989907`, 84.93435731129809}}]}, 
      {Hue[0.6968634200621289, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 84.44979952876676}, {
        0.10656565656565659`, 84.44979952876676}}]}, 
      {Hue[0.44662220484056203`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 69.60213518763632}, {
        0.10656565656565659`, 69.60213518763632}}]}, 
      {Hue[0.44662220484056203`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 70.91918591096498}, {0.146969696969697,
         70.91918591096498}}]}, 
      {Hue[0.44662220484056203`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 73.99230426539853}, {
        0.18737373737373741`, 73.99230426539853}}]}, 
      {Hue[0.44662220484056203`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 78.82149025093696}, {
        0.22777777777777786`, 78.82149025093696}}]}, 
      {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 39.0482539174258}, {
        0.10656565656565659`, 39.0482539174258}}]}, 
      {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 40.629872417639135`}, {
        0.146969696969697, 40.629872417639135`}}]}, 
      {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 44.32031558480358}, {
        0.18737373737373741`, 44.32031558480358}}]}, 
      {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 50.11958341891915}, {
        0.22777777777777786`, 50.11958341891915}}]}, 
      {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 58.027675919985825`}, {
        0.26818181818181824`, 58.027675919985825`}}]}, 
      {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 68.04459308800362}, {
        0.3085858585858587, 68.04459308800362}}]}, 
      {Hue[0.003325984134149069, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 80.17033492297253}, {
        0.34898989898989907`, 80.17033492297253}}]}, 
      {Hue[0.7860905823801522, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 39.93814092994726}, {
        0.10656565656565659`, 39.93814092994726}}]}, 
      {Hue[0.7860905823801522, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 41.178504419999264`}, {
        0.146969696969697, 41.178504419999264`}}]}, 
      {Hue[0.7860905823801522, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 44.07268589678728}, {
        0.18737373737373741`, 44.07268589678728}}]}, 
      {Hue[0.7860905823801522, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 48.6206853603113}, {
        0.22777777777777786`, 48.6206853603113}}]}, 
      {Hue[0.7860905823801522, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 54.822502810571336`}, {
        0.26818181818181824`, 54.822502810571336`}}]}, 
      {Hue[0.7860905823801522, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 62.678138247567375`}, {
        0.3085858585858587, 62.678138247567375`}}]}, 
      {Hue[0.7860905823801522, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 72.18759167129942}, {
        0.34898989898989907`, 72.18759167129942}}]}, 
      {Hue[0.7860905823801522, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3530303030303031, 83.35086308176747}, {
        0.38939393939393946`, 83.35086308176747}}]}, 
      {Hue[0.7459761800968997, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 75.62480961321378}, {
        0.10656565656565659`, 75.62480961321378}}]}, 
      {Hue[0.7459761800968997, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 77.23345664000475}, {0.146969696969697,
         77.23345664000475}}]}, 
      {Hue[0.7459761800968997, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 80.98696636918366}, {
        0.18737373737373741`, 80.98696636918366}}]}, 
      {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 63.203860617059675`}, {
        0.10656565656565659`, 63.203860617059675`}}]}, 
      {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 64.5404777393364}, {0.146969696969697, 
        64.5404777393364}}]}, 
      {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 67.65925102464874}, {
        0.18737373737373741`, 67.65925102464874}}]}, 
      {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 72.5601804729967}, {
        0.22777777777777786`, 72.5601804729967}}]}, 
      {Hue[0.8642671984450118, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 79.2432660843803}, {
        0.26818181818181824`, 79.2432660843803}}]}, 
      {Hue[0.16740377838288284`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 63.95350450202203}, {
        0.10656565656565659`, 63.95350450202203}}]}, 
      {Hue[0.16740377838288284`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 65.6003029081788}, {0.146969696969697, 
        65.6003029081788}}]}, 
      {Hue[0.16740377838288284`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 69.44283252254462}, {
        0.18737373737373741`, 69.44283252254462}}]}, 
      {Hue[0.16740377838288284`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 75.48109334511945}, {
        0.22777777777777786`, 75.48109334511945}}]}, 
      {Hue[0.16740377838288284`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 83.71508537590331}, {
        0.26818181818181824`, 83.71508537590331}}]}, 
      {Hue[0.7207815735423208, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 79.55081272811483}, {
        0.10656565656565659`, 79.55081272811483}}]}, 
      {Hue[0.7207815735423208, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 80.99373295268691}, {0.146969696969697,
         80.99373295268691}}]}, 
      {Hue[0.7207815735423208, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 84.36054681002176}, {
        0.18737373737373741`, 84.36054681002176}}]}, 
      {Hue[0.7174555894081717, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 77.00070352311945}, {
        0.10656565656565659`, 77.00070352311945}}]}, 
      {Hue[0.7174555894081717, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 78.53176406009416}, {0.146969696969697,
         78.53176406009416}}]}, 
      {Hue[0.7174555894081717, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 82.10423864636846}, {
        0.18737373737373741`, 82.10423864636846}}]}, 
      {Hue[0.9313650070280196, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 73.56070730560263}, {
        0.10656565656565659`, 73.56070730560263}}]}, 
      {Hue[0.9313650070280196, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 74.9645768942693}, {0.146969696969697, 
        74.9645768942693}}]}, 
      {Hue[0.9313650070280196, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 78.24027260115818}, {
        0.18737373737373741`, 78.24027260115818}}]}, 
      {Hue[0.9313650070280196, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 83.38779442626928}, {
        0.22777777777777786`, 83.38779442626928}}]}, 
      {Hue[0.18538882693111988`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 83.13534110611798}, {
        0.10656565656565659`, 83.13534110611798}}]}, 
      {Hue[0.18538882693111988`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 84.60032248060963}, {0.146969696969697,
         84.60032248060963}}]}, 
      {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 56.42962520148873}, {
        0.10656565656565659`, 56.42962520148873}}]}, 
      {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 57.67116199544765}, {0.146969696969697,
         57.67116199544765}}]}, 
      {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 60.56808118135177}, {
        0.18737373737373741`, 60.56808118135177}}]}, 
      {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 65.12038275920112}, {
        0.22777777777777786`, 65.12038275920112}}]}, 
      {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 71.32806672899568}, {
        0.26818181818181824`, 71.32806672899568}}]}, 
      {Hue[0.3211216284861082, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 79.19113309073546}, {
        0.3085858585858587, 79.19113309073546}}]}, 
      {Hue[0.15371785010322536`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 77.67556411319582}, {
        0.10656565656565659`, 77.67556411319582}}]}, 
      {Hue[0.15371785010322536`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 78.94006131361391}, {0.146969696969697,
         78.94006131361391}}]}, 
      {Hue[0.15371785010322536`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 81.89055478125613}, {
        0.18737373737373741`, 81.89055478125613}}]}, 
      {Hue[0.43293627656090455`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 83.32419479881011}, {
        0.10656565656565659`, 83.32419479881011}}]}, 
      {Hue[0.43293627656090455`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 84.81553058727208}, {0.146969696969697,
         84.81553058727208}}]}, 
      {Hue[0.7154806871527328, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 42.82163598812107}, {
        0.10656565656565659`, 42.82163598812107}}]}, 
      {Hue[0.7154806871527328, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 44.4516700522243}, {0.146969696969697, 
        44.4516700522243}}]}, 
      {Hue[0.7154806871527328, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 48.25508286846515}, {
        0.18737373737373741`, 48.25508286846515}}]}, 
      {Hue[0.7154806871527328, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 54.23187443684364}, {
        0.22777777777777786`, 54.23187443684364}}]}, 
      {Hue[0.7154806871527328, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 62.38204475735975}, {
        0.26818181818181824`, 62.38204475735975}}]}, 
      {Hue[0.7154806871527328, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 72.7055938300135}, {0.3085858585858587,
         72.7055938300135}}]}, 
      {Hue[0.7841156801247133, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 54.46037209624757}, {
        0.10656565656565659`, 54.46037209624757}}]}, 
      {Hue[0.7841156801247133, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 55.799709113428094`}, {
        0.146969696969697, 55.799709113428094`}}]}, 
      {Hue[0.7841156801247133, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 58.924828820182654`}, {
        0.18737373737373741`, 58.924828820182654`}}]}, 
      {Hue[0.7841156801247133, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 63.83573121651126}, {
        0.22777777777777786`, 63.83573121651126}}]}, 
      {Hue[0.7841156801247133, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 70.5324163024139}, {
        0.26818181818181824`, 70.5324163024139}}]}, 
      {Hue[0.7841156801247133, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 79.01488407789058}, {
        0.3085858585858587, 79.01488407789058}}]}, 
      {Hue[0.5987268531935934, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 56.52447440385872}, {
        0.10656565656565659`, 56.52447440385872}}]}, 
      {Hue[0.5987268531935934, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 58.068588859163555`}, {
        0.146969696969697, 58.068588859163555`}}]}, 
      {Hue[0.5987268531935934, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 61.671522588208134`}, {
        0.18737373737373741`, 61.671522588208134`}}]}, 
      {Hue[0.5987268531935934, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 67.33327559099249}, {
        0.22777777777777786`, 67.33327559099249}}]}, 
      {Hue[0.5987268531935934, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 75.0538478675166}, {
        0.26818181818181824`, 75.0538478675166}}]}, 
      {Hue[0.5987268531935934, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 84.83323941778048}, {
        0.3085858585858587, 84.83323941778048}}]}, 
      {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 36.59299391480042}, {
        0.10656565656565659`, 36.59299391480042}}]}, 
      {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 38.0087441178903}, {0.146969696969697, 
        38.0087441178903}}]}, 
      {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 41.312161258433356`}, {
        0.18737373737373741`, 41.312161258433356`}}]}, 
      {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 46.503245336429586`}, {
        0.22777777777777786`, 46.503245336429586`}}]}, 
      {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 53.581996351878985`}, {
        0.26818181818181824`, 53.581996351878985`}}]}, 
      {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 62.54841430478157}, {
        0.3085858585858587, 62.54841430478157}}]}, 
      {Hue[0.2776052247074852, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 73.40249919513732}, {
        0.34898989898989907`, 73.40249919513732}}]}, 
      {Hue[0.12388737460425987`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 44.11687321533372}, {
        0.10656565656565659`, 44.11687321533372}}]}, 
      {Hue[0.12388737460425987`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 45.38129875974948}, {0.146969696969697,
         45.38129875974948}}]}, 
      {Hue[0.12388737460425987`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 48.33162503005292}, {
        0.18737373737373741`, 48.33162503005292}}]}, 
      {Hue[0.12388737460425987`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 52.96785202624402}, {
        0.22777777777777786`, 52.96785202624402}}]}, 
      {Hue[0.12388737460425987`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 59.28997974832281}, {
        0.26818181818181824`, 59.28997974832281}}]}, 
      {Hue[0.12388737460425987`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 67.29800819628927}, {
        0.3085858585858587, 67.29800819628927}}]}, 
      {Hue[0.12388737460425987`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 76.99193737014342}, {
        0.34898989898989907`, 76.99193737014342}}]}, 
      {Hue[0.6909510980433553, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 45.99212183025273}, {
        0.10656565656565659`, 45.99212183025273}}]}, 
      {Hue[0.6909510980433553, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 47.43497039882247}, {0.146969696969697,
         47.43497039882247}}]}, 
      {Hue[0.6909510980433553, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 50.80161705881855}, {
        0.18737373737373741`, 50.80161705881855}}]}, 
      {Hue[0.6909510980433553, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 56.092061810240935`}, {
        0.22777777777777786`, 56.092061810240935`}}]}, 
      {Hue[0.6909510980433553, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 63.30630465308967}, {
        0.26818181818181824`, 63.30630465308967}}]}, 
      {Hue[0.6909510980433553, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 72.44434558736472}, {
        0.3085858585858587, 72.44434558736472}}]}, 
      {Hue[0.6909510980433553, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 83.5061846130661}, {0.34898989898989907`,
         83.5061846130661}}]}, 
      {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 39.668630554562085`}, {
        0.10656565656565659`, 39.668630554562085`}}]}, 
      {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 41.15120387164456}, {0.146969696969697,
         41.15120387164456}}]}, 
      {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 44.61054161150368}, {
        0.18737373737373741`, 44.61054161150368}}]}, 
      {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 50.046643774139426`}, {
        0.22777777777777786`, 50.046643774139426`}}]}, 
      {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 57.459510359551814`}, {
        0.26818181818181824`, 57.459510359551814`}}]}, 
      {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 66.84914136774084}, {
        0.3085858585858587, 66.84914136774084}}]}, 
      {Hue[0.9754704108906225, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 78.2155367987065}, {0.34898989898989907`,
         78.2155367987065}}]}, 
      {Hue[0.19135473076590917`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 70.40770187204365}, {
        0.10656565656565659`, 70.40770187204365}}]}, 
      {Hue[0.19135473076590917`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 71.66411071368957}, {0.146969696969697,
         71.66411071368957}}]}, 
      {Hue[0.19135473076590917`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 74.59573134419671}, {
        0.18737373737373741`, 74.59573134419671}}]}, 
      {Hue[0.19135473076590917`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 79.20256376356508}, {
        0.22777777777777786`, 79.20256376356508}}]}, 
      {Hue[0.5926278775723157, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 50.38137218061535}, {
        0.10656565656565659`, 50.38137218061535}}]}, 
      {Hue[0.5926278775723157, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 51.763425379572396`}, {
        0.146969696969697, 51.763425379572396`}}]}, 
      {Hue[0.5926278775723157, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 54.98821617713885}, {
        0.18737373737373741`, 54.98821617713885}}]}, 
      {Hue[0.5926278775723157, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 60.05574457331471}, {
        0.22777777777777786`, 60.05574457331471}}]}, 
      {Hue[0.5926278775723157, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 66.96601056809996}, {
        0.26818181818181824`, 66.96601056809996}}]}, 
      {Hue[0.5926278775723157, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 75.71901416149463}, {
        0.3085858585858587, 75.71901416149463}}]}, 
      {Hue[0.31502265286483055`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 50.28652297824536}, {
        0.10656565656565659`, 50.28652297824536}}]}, 
      {Hue[0.31502265286483055`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 51.92258478672849}, {0.146969696969697,
         51.92258478672849}}]}, 
      {Hue[0.31502265286483055`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 55.74006233985578}, {
        0.18737373737373741`, 55.74006233985578}}]}, 
      {Hue[0.31502265286483055`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 61.73895563762724}, {
        0.22777777777777786`, 61.73895563762724}}]}, 
      {Hue[0.31502265286483055`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 69.91926468004287}, {
        0.26818181818181824`, 69.91926468004287}}]}, 
      {Hue[0.31502265286483055`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 80.28098946710267}, {
        0.3085858585858587, 80.28098946710267}}]}, 
      {Hue[0.19113527826057067`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 42.66779447534207}, {
        0.10656565656565659`, 42.66779447534207}}]}, 
      {Hue[0.19113527826057067`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 44.152603281153404`}, {
        0.146969696969697, 44.152603281153404`}}]}, 
      {Hue[0.19113527826057067`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 47.617157161379865`}, {
        0.18737373737373741`, 47.617157161379865`}}]}, 
      {Hue[0.19113527826057067`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 53.06145611602143}, {
        0.22777777777777786`, 53.06145611602143}}]}, 
      {Hue[0.19113527826057067`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 60.485500145078134`}, {
        0.26818181818181824`, 60.485500145078134`}}]}, 
      {Hue[0.19113527826057067`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 69.88928924854994}, {
        0.3085858585858587, 69.88928924854994}}]}, 
      {Hue[0.19113527826057067`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 81.27282342643687}, {
        0.34898989898989907`, 81.27282342643687}}]}, 
      {Hue[0.5001841802172153, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 81.87511605881846}, {
        0.10656565656565659`, 81.87511605881846}}]}, 
      {Hue[0.5001841802172153, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 83.03024883780402}, {0.146969696969697,
         83.03024883780402}}]}, 
      {Hue[0.5247137693265929, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 78.70463021668681}, {
        0.10656565656565659`, 78.70463021668681}}]}, 
      {Hue[0.5247137693265929, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 80.04694849120584}, {0.146969696969697,
         80.04694849120584}}]}, 
      {Hue[0.5247137693265929, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 83.17902446508361}, {
        0.18737373737373741`, 83.17902446508361}}]}, 
      {Hue[0.3333590385606837, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 44.795073057073594`}, {
        0.10656565656565659`, 44.795073057073594`}}]}, 
      {Hue[0.3333590385606837, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 45.99415503169068}, {0.146969696969697,
         45.99415503169068}}]}, 
      {Hue[0.3333590385606837, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 48.79201297246391}, {
        0.18737373737373741`, 48.79201297246391}}]}, 
      {Hue[0.3333590385606837, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 53.18864687939325}, {
        0.22777777777777786`, 53.18864687939325}}]}, 
      {Hue[0.3333590385606837, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 59.184056752478725`}, {
        0.26818181818181824`, 59.184056752478725`}}]}, 
      {Hue[0.3333590385606837, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 66.77824259172031}, {
        0.3085858585858587, 66.77824259172031}}]}, 
      {Hue[0.3333590385606837, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.3126262626262627, 75.97120439711803}, {
        0.34898989898989907`, 75.97120439711803}}]}, 
      {Hue[0.740731160988368, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 79.61314429018736}, {
        0.10656565656565659`, 79.61314429018736}}]}, 
      {Hue[0.740731160988368, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 81.09993187846335}, {0.146969696969697,
         81.09993187846335}}]}, 
      {Hue[0.740731160988368, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 84.56910291777402}, {
        0.18737373737373741`, 84.56910291777402}}]}, 
      {Hue[0.42570850812353744`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 65.82476602437242}, {
        0.10656565656565659`, 65.82476602437242}}]}, 
      {Hue[0.42570850812353744`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 67.34525061678126}, {0.146969696969697,
         67.34525061678126}}]}, 
      {Hue[0.42570850812353744`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 70.89304799906851}, {
        0.18737373737373741`, 70.89304799906851}}]}, 
      {Hue[0.42570850812353744`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 76.46815817123422}, {
        0.22777777777777786`, 76.46815817123422}}]}, 
      {Hue[0.42570850812353744`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 84.07058113327837}, {
        0.26818181818181824`, 84.07058113327837}}]}, 
      {Hue[0.23457322986296675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 59.65511626146079}, {
        0.10656565656565659`, 59.65511626146079}}]}, 
      {Hue[0.23457322986296675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 60.80396458980225}, {0.146969696969697,
         60.80396458980225}}]}, 
      {Hue[0.23457322986296675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 63.48461068926565}, {
        0.18737373737373741`, 63.48461068926565}}]}, 
      {Hue[0.23457322986296675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 67.697054559851}, {
        0.22777777777777786`, 67.697054559851}}]}, 
      {Hue[0.23457322986296675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 73.4412962015583}, {
        0.26818181818181824`, 73.4412962015583}}]}, 
      {Hue[0.23457322986296675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.27222222222222225`, 80.71733561438755}, {
        0.3085858585858587, 80.71733561438755}}]}, 
      {Hue[0.7343890496457514, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 62.97944361637144}, {
        0.10656565656565659`, 62.97944361637144}}]}, 
      {Hue[0.7343890496457514, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 64.64291797834329}, {0.146969696969697,
         64.64291797834329}}]}, 
      {Hue[0.7343890496457514, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 68.52435815627761}, {
        0.18737373737373741`, 68.52435815627761}}]}, 
      {Hue[0.7343890496457514, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 74.62376415017441}, {
        0.22777777777777786`, 74.62376415017441}}]}, 
      {Hue[0.7343890496457514, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 82.94113596003366}, {
        0.26818181818181824`, 82.94113596003366}}]}, 
      {Hue[0.20967528031915844`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 69.47425681341377}, {
        0.10656565656565659`, 69.47425681341377}}]}, 
      {Hue[0.20967528031915844`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 70.90858544261054}, {0.146969696969697,
         70.90858544261054}}]}, 
      {Hue[0.20967528031915844`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 74.2553522440697}, {
        0.18737373737373741`, 74.2553522440697}}]}, 
      {Hue[0.20967528031915844`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 79.51455721779122}, {
        0.22777777777777786`, 79.51455721779122}}]}, 
      {Hue[0.8763162417584747, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 61.17732846877061}, {
        0.10656565656565659`, 61.17732846877061}}]}, 
      {Hue[0.8763162417584747, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 62.52574766509427}, {0.146969696969697,
         62.52574766509427}}]}, 
      {Hue[0.8763162417584747, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 65.67205912318279}, {
        0.18737373737373741`, 65.67205912318279}}]}, 
      {Hue[0.8763162417584747, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 70.6162628430362}, {
        0.22777777777777786`, 70.6162628430362}}]}, 
      {Hue[0.8763162417584747, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 77.35835882465447}, {
        0.26818181818181824`, 77.35835882465447}}]}, 
      {Hue[0.13558508077010675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.07020202020202021, 66.76362759231237}, {
        0.10656565656565659`, 66.76362759231237}}]}, 
      {Hue[0.13558508077010675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.11060606060606062`, 68.29501801297599}, {0.146969696969697,
         68.29501801297599}}]}, 
      {Hue[0.13558508077010675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.15101010101010104`, 71.86826232785775}, {
        0.18737373737373741`, 71.86826232785775}}]}, 
      {Hue[0.13558508077010675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.19141414141414145`, 77.48336053695766}, {
        0.22777777777777786`, 77.48336053695766}}]}, 
      {Hue[0.13558508077010675`, 0.7, 1], AbsoluteThickness[1], Opacity[1], 
       Dashing[{}], CapForm[None], 
       LineBox[{{0.23181818181818187`, 85.14031264027571}, {
        0.26818181818181824`, 85.14031264027571}}], InsetBox[
        TagBox[
         StyleBox[
          TagBox["\<\"LevelScheme\"\>",
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->45,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {0.05, 185.}, {-1, 1}, Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[GridBox[{
             {
              RowBox[{"  ", 
               RowBox[{
               "A", " ", "scientific", " ", "figure", " ", "preparation"}]}]},
             {
              RowBox[{"    ", 
               RowBox[{"system", " ", "for", " ", "Mathematica"}]}]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.08]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->26,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {0.05, 155.}, {-1, 1}, Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           TemplateBox[{"\"M. A. Caprio, Comput. Phys. Commun. \"",TagBox[
              StyleBox["\"171\"", FontWeight -> "Bold"], 
              StyleForm[#, FontWeight -> "Bold"]& ],"\", 107 (2005)\""},
            "RowDefault"],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->12,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {0., 1.7763568394002505`*^-15}, {-1, -1.1}, 
        Automatic, {1, 0}], InsetBox[
        TagBox[
         StyleBox[
          TagBox[
           TagBox[
            StyleBox["\<\"http://wnsl.physics.yale.edu/levelscheme\"\>",
             FontFamily->"Courier"],
            StyleForm[#, FontFamily -> "Courier"]& ],
           DisplayForm],
          StripOnInput->False,
          ShowAutoStyles->False,
          SingleLetterItalics->False,
          FontFamily->"Times",
          FontSize->12,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontTracking->"Plain",
          FontColor->GrayLevel[0],
          FontOpacity->1],
         DisplayForm], {1., 1.7763568394002505`*^-15}, {1, -1.1}, Automatic, {
        1, 0}]}}}}},
  AspectRatio->0.7727272727272727,
  Axes->False,
  Background->RGBColor[0.466704, 0.533296, 0.599994],
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{633.6, 489.6},
  PlotRange->{{-0.05011, 1.05011}, {-15.023, 215.023}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.4888392345625*^9, 3.488839266125*^9, 3.49722514740625*^9,
   3.507513581328125*^9, 3.5668376864155703`*^9}]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1272, 902},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
DockedCells->(FrontEndExecute[{
   FrontEnd`NotebookApply[
    FrontEnd`InputNotebook[], #, Placeholder]}]& ),
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{None, None, None}, {None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{71.875, 71.875}, {53.875, 53.875}}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 118, 3, 69, "Text"],
Cell[666, 25, 581, 11, 34, "Text"],
Cell[CellGroupData[{
Cell[1272, 40, 41, 0, 88, "Section"],
Cell[1316, 42, 533, 12, 55, "Text"],
Cell[CellGroupData[{
Cell[1874, 58, 184, 4, 35, "Input"],
Cell[2061, 64, 12413, 310, 141, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14523, 380, 211, 3, 88, "Section"],
Cell[CellGroupData[{
Cell[14759, 387, 1820, 47, 278, "Input"],
Cell[16582, 436, 5739, 103, 288, 2696, 52, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22370, 545, 157, 2, 88, "Section"],
Cell[22530, 549, 315, 5, 55, "Text"],
Cell[CellGroupData[{
Cell[22870, 558, 4799, 120, 762, "Input"],
Cell[27672, 680, 7751, 207, 288, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35472, 893, 48, 0, 88, "Section"],
Cell[35523, 895, 127, 4, 29, "Text"],
Cell[CellGroupData[{
Cell[35675, 903, 7428, 167, 938, "Input"],
Cell[43106, 1072, 23274, 631, 378, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66429, 1709, 76, 0, 88, "Section"],
Cell[66508, 1711, 127, 4, 29, "Text"],
Cell[CellGroupData[{
Cell[66660, 1719, 6263, 144, 608, "Input"],
Cell[72926, 1865, 37324, 754, 423, 15997, 403, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[110299, 2625, 48, 0, 88, "Section"],
Cell[110350, 2627, 127, 4, 29, "Text"],
Cell[CellGroupData[{
Cell[110502, 2635, 21742, 494, 2698, "Input"],
Cell[132247, 3131, 62565, 1887, 738, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[194861, 5024, 36, 0, 88, "Section"],
Cell[194900, 5026, 354, 7, 97, "Text"],
Cell[195257, 5035, 228, 9, 49, "Text"],
Cell[CellGroupData[{
Cell[195510, 5048, 13227, 328, 1673, "Input"],
Cell[208740, 5378, 54831, 1514, 738, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[263620, 6898, 180, 2, 88, "Section"],
Cell[263803, 6902, 280, 5, 34, "Text"],
Cell[264086, 6909, 152, 3, 34, "Text"],
Cell[264241, 6914, 1200, 37, 212, "Input"],
Cell[265444, 6953, 1243, 37, 80, "Input"],
Cell[266690, 6992, 96, 1, 34, "Text"],
Cell[266789, 6995, 1148, 37, 58, "Input"],
Cell[267940, 7034, 120, 1, 34, "Text"],
Cell[268063, 7037, 2438, 63, 278, "Input"],
Cell[270504, 7102, 128, 1, 34, "Text"],
Cell[CellGroupData[{
Cell[270657, 7107, 572, 12, 102, "Input"],
Cell[271232, 7121, 1231, 38, 53, "Output"]
}, Open  ]],
Cell[272478, 7162, 90, 1, 34, "Text"],
Cell[CellGroupData[{
Cell[272593, 7167, 11800, 278, 1356, "Input"],
Cell[284396, 7447, 30147, 747, 558, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[314592, 8200, 174, 4, 88, "Section"],
Cell[314769, 8206, 605, 17, 283, "Text"],
Cell[CellGroupData[{
Cell[315399, 8227, 12780, 340, 1532, "Input"],
Cell[328182, 8569, 42494, 1021, 648, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[370725, 9596, 209, 3, 88, "Section"],
Cell[370937, 9601, 168, 5, 34, "Text"],
Cell[CellGroupData[{
Cell[371130, 9610, 8364, 202, 1048, "Input"],
Cell[379497, 9814, 60052, 1153, 630, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[439598, 10973, 240, 3, 88, "Section"],
Cell[439841, 10978, 168, 5, 34, "Text"],
Cell[440012, 10985, 775, 19, 55, "Text"],
Cell[440790, 11006, 253, 5, 34, "Text"],
Cell[CellGroupData[{
Cell[441068, 11015, 17801, 455, 1752, "Input"],
Cell[458872, 11472, 320513, 5298, 630, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
