(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    925107,      17608]
NotebookOptionsPosition[    922487,      17523]
NotebookOutlinePosition[    923352,      17553]
CellTagsIndexPosition[    923309,      17550]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["LevelScheme examples: Plots",
 FontFamily->"Times New Roman",
 FontSize->36]], "Text",
 CellChangeTimes->{{3.4912582924375*^9, 3.4912582936875*^9}, {
  3.4912586879375*^9, 3.49125868853125*^9}},
 FontSize->10],

Cell[TextData[{
 StyleBox["M. A. Caprio, ", "SmallText",
  FontFamily->"Times New Roman",
  FontSize->12],
 "Department of Physics, University of Notre Dame"
}], "Text",
 CellChangeTimes->{{3.39552255203125*^9, 3.3955225581875*^9}, {
   3.396878383875*^9, 3.39687838403125*^9}, 3.397586352671875*^9, {
   3.39854548165625*^9, 3.398545486203125*^9}, {3.430247945015625*^9, 
   3.430247947875*^9}, {3.436820309328125*^9, 3.436820313328125*^9}, {
   3.443996368375*^9, 3.443996375046875*^9}, {3.47108965090625*^9, 
   3.471089655984375*^9}, {3.497225037953125*^9, 3.497225038359375*^9}}],

Cell[CellGroupData[{

Cell["Package initialization", "Section"],

Cell[TextData[{
 "If you have not already loaded the LevelScheme package since starting this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you must do so now.  See the user guide for information first on \
installing the package and then on loading it at the beginning of each ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session."
}], "Text",
 CellChangeTimes->{{3.4921245209375*^9, 3.492124756234375*^9}, {
  3.492124799609375*^9, 3.492124838453125*^9}, {3.495659733515625*^9, 
  3.495659808359375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", "\"\<LevelScheme`\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.492124284765625*^9, 3.49212429721875*^9}, 
   3.492124551328125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot and inset plot -- Bessel functions", "Section",
 CellChangeTimes->{{3.492124873796875*^9, 3.492124882515625*^9}}],

Cell["\<\
In this example, the graphical output of Plot is directly included in the \
figure, using RawGraphics.\
\>", "Text",
 CellChangeTimes->{{3.49902227665625*^9, 3.499022294046875*^9}, {
  3.499022333453125*^9, 3.4990223378125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"main", " ", "panel"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FigurePanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "20"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.6"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"LinTicks", "[", 
           RowBox[{"0", ",", "20"}], "]"}], ",", 
          RowBox[{"LinTicks", "[", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1", ",", "0.5", ",", "5"}], "]"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FontSize", "\[Rule]", "15"}], ",", 
       RowBox[{"LabB", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<x\>\"", "]"}]}], ",", 
       RowBox[{"BufferB", "\[Rule]", "2.5"}], ",", "\[IndentingNewLine]", 
       RowBox[{"TickFontSize", "\[Rule]", "12"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Background", "\[Rule]", "Wheat"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeLine", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"20", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.2", ",", "0.9"}], "}"}], ",", 
       RowBox[{"SubscriptBox", "[", 
        RowBox[{
         RowBox[{"textit", "[", "\"\<J\>\"", "]"}], ",", "\"\<\[Nu]\>\""}], 
        "]"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"BesselJ", "[", 
         RowBox[{"0", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"BesselJ", "[", 
          RowBox[{"1", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
       RowBox[{"Dashing", "\[Rule]", "Automatic"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"inset", " ", "panel"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ScaledFigurePanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.55", ",", "0.95"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.55", ",", "0.95"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "20"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.6"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"LinTicks", "[", 
           RowBox[{"0", ",", "20"}], "]"}], ",", 
          RowBox[{"LinTicks", "[", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1", ",", "0.5", ",", "5"}], "]"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"TickFontSize", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Background", "\[Rule]", "Eggshell"}]}], "\[IndentingNewLine]",
       "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeLine", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"20", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.2", ",", "0.9"}], "}"}], ",", 
       RowBox[{"SubscriptBox", "[", 
        RowBox[{
         RowBox[{"textit", "[", "\"\<Y\>\"", "]"}], ",", "\"\<\[Nu]\>\""}], 
        "]"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"BesselY", "[", 
         RowBox[{"0", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"BesselY", "[", 
          RowBox[{"1", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
       RowBox[{"Dashing", "\[Rule]", "Automatic"}]}], "]"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2"}], ",", "1.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"6", ",", "4"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.395095660953125*^9, 3.395095674*^9}, {
  3.395521201609375*^9, 3.395521219546875*^9}, {3.395521484265625*^9, 
  3.395521484265625*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.960799, 0.870602, 0.702002], Opacity[1], RectangleBox[{0, 0}]}, 
   {RGBColor[0.990005, 0.900006, 0.790002], Opacity[1], 
    RectangleBox[{0.55, 0.55}, {0.95, 0.95}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 0}, {1, 0}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0., 0.016253249999999997`}, {0., 0.}}], 
    LineBox[{{0.05, 0.008126624999999998}, {0.05, 0.}}], 
    LineBox[{{0.1, 0.008126624999999998}, {0.1, 0.}}], 
    LineBox[{{0.15000000000000002`, 0.008126624999999998}, {
     0.15000000000000002`, 0.}}], 
    LineBox[{{0.2, 0.008126624999999998}, {0.2, 0.}}], 
    LineBox[{{0.25, 0.016253249999999997`}, {0.25, 0.}}], 
    LineBox[{{0.30000000000000004`, 0.008126624999999998}, {
     0.30000000000000004`, 0.}}], 
    LineBox[{{0.35000000000000003`, 0.008126624999999998}, {
     0.35000000000000003`, 0.}}], 
    LineBox[{{0.4, 0.008126624999999998}, {0.4, 0.}}], 
    LineBox[{{0.45, 0.008126624999999998}, {0.45, 0.}}], 
    LineBox[{{0.5, 0.016253249999999997`}, {0.5, 0.}}], 
    LineBox[{{0.55, 0.008126624999999998}, {0.55, 0.}}], 
    LineBox[{{0.6000000000000001, 0.008126624999999998}, {0.6000000000000001, 
     0.}}], LineBox[{{0.65, 0.008126624999999998}, {0.65, 0.}}], 
    LineBox[{{0.7000000000000001, 0.008126624999999998}, {0.7000000000000001, 
     0.}}], LineBox[{{0.75, 0.016253249999999997`}, {0.75, 0.}}], 
    LineBox[{{0.8, 0.008126624999999998}, {0.8, 0.}}], 
    LineBox[{{0.8500000000000001, 0.008126624999999998}, {0.8500000000000001, 
     0.}}], LineBox[{{0.9, 0.008126624999999998}, {0.9, 0.}}], 
    LineBox[{{0.9500000000000001, 0.008126624999999998}, {0.9500000000000001, 
     0.}}], LineBox[{{1., 0.016253249999999997`}, {1., 0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 0}, {0, 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.00541775, 0.}, {0., 0.}}], 
    LineBox[{{0.0108355, 0.05882352941176466}, {0., 0.05882352941176466}}], 
    LineBox[{{0.00541775, 0.11764705882352935`}, {0., 0.11764705882352935`}}],
     LineBox[{{0.00541775, 0.17647058823529407`}, {0., 
     0.17647058823529407`}}], 
    LineBox[{{0.00541775, 0.23529411764705876`}, {0., 0.23529411764705876`}}],
     LineBox[{{0.00541775, 0.2941176470588235}, {0., 0.2941176470588235}}], 
    LineBox[{{0.0108355, 0.35294117647058815`}, {0., 0.35294117647058815`}}], 
    LineBox[{{0.00541775, 0.41176470588235287`}, {0., 0.41176470588235287`}}],
     LineBox[{{0.00541775, 0.47058823529411753`}, {0., 
     0.47058823529411753`}}], 
    LineBox[{{0.00541775, 0.5294117647058822}, {0., 0.5294117647058822}}], 
    LineBox[{{0.00541775, 0.588235294117647}, {0., 0.588235294117647}}], 
    LineBox[{{0.0108355, 0.6470588235294117}, {0., 0.6470588235294117}}], 
    LineBox[{{0.00541775, 0.7058823529411763}, {0., 0.7058823529411763}}], 
    LineBox[{{0.00541775, 0.764705882352941}, {0., 0.764705882352941}}], 
    LineBox[{{0.00541775, 0.8235294117647057}, {0., 0.8235294117647057}}], 
    LineBox[{{0.00541775, 0.8823529411764703}, {0., 0.8823529411764703}}], 
    LineBox[{{0.0108355, 0.9411764705882351}, {0., 0.9411764705882351}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 1}, {1, 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{1, 0}, {1, 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0., 0.35294117647058815`}, {1., 0.35294117647058815`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVWHk8lO8XFYq0WNqsUUmSLSmROvnSqsW+FCoJCSFJIpU1ZUlSRAmlyFK2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       "]]}}}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{4, 2}], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmXc41e8bxwkZhZKV9DUSkSQZUbwlI8moiKw0lZJCS4mKFpWiUoiSCNkr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       "]]}}}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.55, 0.55}, {0.95, 0.55}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.55, 0.56625325}, {0.55, 0.55}}], 
    LineBox[{{0.5700000000000001, 0.5581266250000001}, {0.5700000000000001, 
     0.55}}], LineBox[{{0.5900000000000001, 0.5581266250000001}, {
     0.5900000000000001, 0.55}}], 
    LineBox[{{0.61, 0.5581266250000001}, {0.61, 0.55}}], 
    LineBox[{{0.63, 0.5581266250000001}, {0.63, 0.55}}], 
    LineBox[{{0.65, 0.56625325}, {0.65, 0.55}}], 
    LineBox[{{0.67, 0.5581266250000001}, {0.67, 0.55}}], 
    LineBox[{{0.6900000000000001, 0.5581266250000001}, {0.6900000000000001, 
     0.55}}], LineBox[{{0.71, 0.5581266250000001}, {0.71, 0.55}}], 
    LineBox[{{0.73, 0.5581266250000001}, {0.73, 0.55}}], 
    LineBox[{{0.75, 0.56625325}, {0.75, 0.55}}], 
    LineBox[{{0.77, 0.5581266250000001}, {0.77, 0.55}}], 
    LineBox[{{0.79, 0.5581266250000001}, {0.79, 0.55}}], 
    LineBox[{{0.81, 0.5581266250000001}, {0.81, 0.55}}], 
    LineBox[{{0.8300000000000001, 0.5581266250000001}, {0.8300000000000001, 
     0.55}}], LineBox[{{0.85, 0.56625325}, {0.85, 0.55}}], 
    LineBox[{{0.87, 0.5581266250000001}, {0.87, 0.55}}], 
    LineBox[{{0.89, 0.5581266250000001}, {0.89, 0.55}}], 
    LineBox[{{0.9099999999999999, 0.5581266250000001}, {0.9099999999999999, 
     0.55}}], LineBox[{{0.9299999999999999, 0.5581266250000001}, {
     0.9299999999999999, 0.55}}], 
    LineBox[{{0.95, 0.56625325}, {0.95, 0.55}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.55, 0.55}, {0.55, 0.95}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.55541775, 0.55}, {0.55, 0.55}}], 
    LineBox[{{0.5608355, 0.573529411764706}, {0.55, 0.573529411764706}}], 
    LineBox[{{0.55541775, 0.5970588235294118}, {0.55, 0.5970588235294118}}], 
    LineBox[{{0.55541775, 0.6205882352941177}, {0.55, 0.6205882352941177}}], 
    LineBox[{{0.55541775, 0.6441176470588236}, {0.55, 0.6441176470588236}}], 
    LineBox[{{0.55541775, 0.6676470588235294}, {0.55, 0.6676470588235294}}], 
    LineBox[{{0.5608355, 0.6911764705882353}, {0.55, 0.6911764705882353}}], 
    LineBox[{{0.55541775, 0.7147058823529412}, {0.55, 0.7147058823529412}}], 
    LineBox[{{0.55541775, 0.738235294117647}, {0.55, 0.738235294117647}}], 
    LineBox[{{0.55541775, 0.7617647058823529}, {0.55, 0.7617647058823529}}], 
    LineBox[{{0.55541775, 0.7852941176470588}, {0.55, 0.7852941176470588}}], 
    LineBox[{{0.5608355, 0.8088235294117646}, {0.55, 0.8088235294117646}}], 
    LineBox[{{0.55541775, 0.8323529411764705}, {0.55, 0.8323529411764705}}], 
    LineBox[{{0.55541775, 0.8558823529411764}, {0.55, 0.8558823529411764}}], 
    LineBox[{{0.55541775, 0.8794117647058823}, {0.55, 0.8794117647058823}}], 
    LineBox[{{0.55541775, 0.9029411764705881}, {0.55, 0.9029411764705881}}], 
    LineBox[{{0.5608355, 0.926470588235294}, {0.55, 0.926470588235294}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.55, 0.95}, {0.95, 0.95}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.95, 0.55}, {0.95, 0.95}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.55, 0.6911764705882353}, {0.95, 0.6911764705882353}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmHk8lF8UxhEiS5KokJAtikoi1YlkiaSEVntCFKKsIWtRJPsWkaKSJXta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       "]]}}}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{4, 2}], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmHdcjX8Ux5ESJUlLJdIulQYN1WlQEtKeGioqoiijjISGlWhrKNFQJA1F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       "]]}}, InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\" 0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0., -0.002257395833333333}, {0, 1}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\" 5\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.25, -0.002257395833333333}, {0, 1}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"10\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5, -0.002257395833333333}, {0, 1}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"15\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.75, -0.002257395833333333}, {0, 1}, Automatic, {1, 0}],
     InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"20\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1., -0.002257395833333333}, {0, 1}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[
         StyleBox["\<\"x\"\>",
          FontSlant->"Italic"],
         StyleForm[#, FontSlant -> "Italic"]& ],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5000000000000001, -0.08690973958333331}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"-0.5\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0015049305555555554`, 0.05882352941176466}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0.0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0015049305555555554`, 0.35294117647058815`}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0.5\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0015049305555555554`, 0.6470588235294117}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1.0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0015049305555555554`, 0.9411764705882351}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubscriptBox[
         TagBox[
          StyleBox["\<\"J\"\>",
           FontSlant->"Italic"],
          StyleForm[#, FontSlant -> "Italic"]& ], "\[Nu]"],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.2, 0.9}, {0, 0}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\" 0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.55, 0.5477426041666668}, {0, 1}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\" 5\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.65, 0.5477426041666668}, {0, 1}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"10\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.75, 0.5477426041666668}, {0, 1}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"15\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.85, 0.5477426041666668}, {0, 1}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"20\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.95, 0.5477426041666668}, {0, 1}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"-0.5\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5484950694444445, 0.573529411764706}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0.0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5484950694444445, 0.6911764705882353}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0.5\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5484950694444445, 0.8088235294117646}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1.0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5484950694444445, 0.926470588235294}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubscriptBox[
         TagBox[
          StyleBox["\<\"Y\"\>",
           FontSlant->"Italic"],
          StyleForm[#, FontSlant -> "Italic"]& ], "\[Nu]"],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.63, 0.9099999999999999}, {0, 0}, Automatic, {1, 0}]}},
  AspectRatio->NCache[
    Rational[2, 3], 0.6666666666666666],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{432, 288},
  PlotRange->{{-0.20013, 1.10013}, {-0.20013, 1.10013}},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.3950956768125*^9, {3.395521189109375*^9, 3.395521222609375*^9}, 
   3.395521494109375*^9, 3.396880184859375*^9, 3.430248056125*^9, 
   3.471089718453125*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multipanel plot -- Lissajous curves", "Section",
 CellChangeTimes->{{3.49212486321875*^9, 3.492124867125*^9}}],

Cell["\<\
This plot illustrates the use of different sized panels, gaps between panels, \
and custom tick marks.
In this example, the graphical output of Plot or ParametricPlot is directly \
included in the figure, using RawGraphics.\
\>", "Text",
 CellChangeTimes->{{3.499022378875*^9, 3.499022384765625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", "1"}], "}"}], ",", "\"\<Lissajous curves\>\"", 
       ",", 
       RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "Pi"}], "/", "2"}], ",", 
            RowBox[{
             RowBox[{"8", "*", "Pi"}], "+", 
             RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"YPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XFrameLabels", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"textit", "[", "\"\<x\>\"", "]"}], ",", 
          RowBox[{"textit", "[", "\"\<t\>\"", "]"}]}], "}"}]}], ",", 
       RowBox[{"BufferB", "\[Rule]", "2.5"}], ",", "\[IndentingNewLine]", 
       RowBox[{"YFrameLabels", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<y\>\"", "]"}]}], ",", 
       RowBox[{"BufferL", "\[Rule]", "3"}], ",", "\[IndentingNewLine]", 
       RowBox[{"TickFontSize", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XFrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"LinTicks", "[", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "2", ",", "1", ",", "5"}], "]"}], ",", 
          RowBox[{"LinTicks", "[", 
           RowBox[{
            RowBox[{"-", "Pi"}], ",", 
            RowBox[{"9", "*", "Pi"}], ",", "Pi", ",", "4", ",", 
            RowBox[{"TickLabelFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Rationalize", "[", 
                 RowBox[{"#", "/", "Pi"}], "]"}], "*", "Pi"}], "&"}], 
              ")"}]}]}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"YFrameTicks", "\[Rule]", 
        RowBox[{"LinTicks", "[", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2", ",", "1", ",", "5"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XPanelSizes", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2.5"}], "}"}]}], ",", 
       RowBox[{"XGapSizes", "\[Rule]", 
        RowBox[{"{", "0.1", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"YPanelSizes", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], ",", 
       RowBox[{"YGapSizes", "\[Rule]", 
        RowBox[{"{", "0.1", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Background", "\[Rule]", "Wheat"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PanelLetterBackground", "\[Rule]", "Wheat"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"1", "*", "t"}], "]"}], ",", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"1", "*", "t"}], "-", 
            RowBox[{"Pi", "/", "2"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"1", "*", "t"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", 
           RowBox[{"8", "*", "Pi"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Dashing", "\[Rule]", "Automatic"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"1", "*", "t"}], "-", 
          RowBox[{"Pi", "/", "2"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"8", "*", "Pi"}]}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"PanelLetterBackground", "\[Rule]", "None"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"1", "*", "t"}], "]"}], ",", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"4", "*", "t"}], "-", 
            RowBox[{"Pi", "/", "2"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"1", "*", "t"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", 
           RowBox[{"8", "*", "Pi"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Dashing", "\[Rule]", "Automatic"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RawGraphics", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"4", "*", "t"}], "-", 
          RowBox[{"Pi", "/", "2"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"8", "*", "Pi"}]}], "}"}]}], "]"}], "]"}], ","}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "1.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", "2", "*", 
     RowBox[{"{", 
      RowBox[{"3.6", ",", "2.1"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.395521502984375*^9, 3.395521519828125*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.960799, 0.870602, 0.702002], Opacity[1], 
    RectangleBox[{0, 0.5238095238095238}, {0.2777777777777778, 1}]}, 
   {RGBColor[0.960799, 0.870602, 0.702002], Opacity[1], 
    RectangleBox[{0.3055555555555556, 0.5238095238095238}, {1., 1}]}, 
   {RGBColor[0.960799, 0.870602, 0.702002], Opacity[1], 
    RectangleBox[{0, 1.1102230246251565`*^-16}, \
{0.2777777777777778, 0.4761904761904763}]}, 
   {RGBColor[0.960799, 0.870602, 0.702002], Opacity[1], 
    RectangleBox[{0.3055555555555556, 1.1102230246251565`*^-16}, \
{1., 0.4761904761904763}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 0.5238095238095238}, {0.2777777777777778, 
      0.5238095238095238}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.009259259259259273, 0.5319540095238096}, {
     0.009259259259259273, 0.5238095238095238}}], 
    LineBox[{{0.02777777777777779, 0.5319540095238096}, {0.02777777777777779, 
     0.5238095238095238}}], 
    LineBox[{{0.04629629629629631, 0.5400984952380953}, {0.04629629629629631, 
     0.5238095238095238}}], 
    LineBox[{{0.06481481481481483, 0.5319540095238096}, {0.06481481481481483, 
     0.5238095238095238}}], 
    LineBox[{{0.08333333333333334, 0.5319540095238096}, {0.08333333333333334, 
     0.5238095238095238}}], 
    LineBox[{{0.10185185185185186`, 0.5319540095238096}, {
     0.10185185185185186`, 0.5238095238095238}}], 
    LineBox[{{0.12037037037037038`, 0.5319540095238096}, {
     0.12037037037037038`, 0.5238095238095238}}], 
    LineBox[{{0.1388888888888889, 0.5400984952380953}, {0.1388888888888889, 
     0.5238095238095238}}], 
    LineBox[{{0.1574074074074074, 0.5319540095238096}, {0.1574074074074074, 
     0.5238095238095238}}], 
    LineBox[{{0.17592592592592593`, 0.5319540095238096}, {
     0.17592592592592593`, 0.5238095238095238}}], 
    LineBox[{{0.19444444444444445`, 0.5319540095238096}, {
     0.19444444444444445`, 0.5238095238095238}}], 
    LineBox[{{0.21296296296296297`, 0.5319540095238096}, {
     0.21296296296296297`, 0.5238095238095238}}], 
    LineBox[{{0.23148148148148148`, 0.5400984952380953}, {
     0.23148148148148148`, 0.5238095238095238}}], 
    LineBox[{{0.25, 0.5319540095238096}, {0.25, 0.5238095238095238}}], 
    LineBox[{{0.2685185185185185, 0.5319540095238096}, {0.2685185185185185, 
     0.5238095238095238}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 0.5238095238095238}, {0, 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.0047509499999999994`, 0.5396825396825397}, {0., 
     0.5396825396825397}}], 
    LineBox[{{0.0047509499999999994`, 0.5714285714285714}, {0., 
     0.5714285714285714}}], 
    LineBox[{{0.009501899999999999, 0.6031746031746031}, {0., 
     0.6031746031746031}}], 
    LineBox[{{0.0047509499999999994`, 0.6349206349206349}, {0., 
     0.6349206349206349}}], 
    LineBox[{{0.0047509499999999994`, 0.6666666666666666}, {0., 
     0.6666666666666666}}], 
    LineBox[{{0.0047509499999999994`, 0.6984126984126984}, {0., 
     0.6984126984126984}}], 
    LineBox[{{0.0047509499999999994`, 0.7301587301587301}, {0., 
     0.7301587301587301}}], 
    LineBox[{{0.009501899999999999, 0.7619047619047619}, {0., 
     0.7619047619047619}}], 
    LineBox[{{0.0047509499999999994`, 0.7936507936507936}, {0., 
     0.7936507936507936}}], 
    LineBox[{{0.0047509499999999994`, 0.8253968253968254}, {0., 
     0.8253968253968254}}], 
    LineBox[{{0.0047509499999999994`, 0.8571428571428571}, {0., 
     0.8571428571428571}}], 
    LineBox[{{0.0047509499999999994`, 0.8888888888888888}, {0., 
     0.8888888888888888}}], 
    LineBox[{{0.009501899999999999, 0.9206349206349206}, {0., 
     0.9206349206349206}}], 
    LineBox[{{0.0047509499999999994`, 0.9523809523809523}, {0., 
     0.9523809523809523}}], 
    LineBox[{{0.0047509499999999994`, 0.9841269841269841}, {0., 
     0.9841269841269841}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 1}, {0.2777777777777778, 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.009259259259259273, 0.9918555142857143}, {
     0.009259259259259273, 1.}}], 
    LineBox[{{0.02777777777777779, 0.9918555142857143}, {0.02777777777777779, 
     1.}}], LineBox[{{0.04629629629629631, 0.9837110285714286}, {
     0.04629629629629631, 1.}}], 
    LineBox[{{0.06481481481481483, 0.9918555142857143}, {0.06481481481481483, 
     1.}}], LineBox[{{0.08333333333333334, 0.9918555142857143}, {
     0.08333333333333334, 1.}}], 
    LineBox[{{0.10185185185185186`, 0.9918555142857143}, {
     0.10185185185185186`, 1.}}], 
    LineBox[{{0.12037037037037038`, 0.9918555142857143}, {
     0.12037037037037038`, 1.}}], 
    LineBox[{{0.1388888888888889, 0.9837110285714286}, {0.1388888888888889, 
     1.}}], LineBox[{{0.1574074074074074, 0.9918555142857143}, {
     0.1574074074074074, 1.}}], 
    LineBox[{{0.17592592592592593`, 0.9918555142857143}, {
     0.17592592592592593`, 1.}}], 
    LineBox[{{0.19444444444444445`, 0.9918555142857143}, {
     0.19444444444444445`, 1.}}], 
    LineBox[{{0.21296296296296297`, 0.9918555142857143}, {
     0.21296296296296297`, 1.}}], 
    LineBox[{{0.23148148148148148`, 0.9837110285714286}, {
     0.23148148148148148`, 1.}}], 
    LineBox[{{0.25, 0.9918555142857143}, {0.25, 1.}}], 
    LineBox[{{0.2685185185185185, 0.9918555142857143}, {0.2685185185185185, 
     1.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.2777777777777778, 0.5238095238095238}, {
      0.2777777777777778, 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.2730268277777778, 0.5396825396825397}, {0.2777777777777778, 
     0.5396825396825397}}], 
    LineBox[{{0.2730268277777778, 0.5714285714285714}, {0.2777777777777778, 
     0.5714285714285714}}], 
    LineBox[{{0.2682758777777778, 0.6031746031746031}, {0.2777777777777778, 
     0.6031746031746031}}], 
    LineBox[{{0.2730268277777778, 0.6349206349206349}, {0.2777777777777778, 
     0.6349206349206349}}], 
    LineBox[{{0.2730268277777778, 0.6666666666666666}, {0.2777777777777778, 
     0.6666666666666666}}], 
    LineBox[{{0.2730268277777778, 0.6984126984126984}, {0.2777777777777778, 
     0.6984126984126984}}], 
    LineBox[{{0.2730268277777778, 0.7301587301587301}, {0.2777777777777778, 
     0.7301587301587301}}], 
    LineBox[{{0.2682758777777778, 0.7619047619047619}, {0.2777777777777778, 
     0.7619047619047619}}], 
    LineBox[{{0.2730268277777778, 0.7936507936507936}, {0.2777777777777778, 
     0.7936507936507936}}], 
    LineBox[{{0.2730268277777778, 0.8253968253968254}, {0.2777777777777778, 
     0.8253968253968254}}], 
    LineBox[{{0.2730268277777778, 0.8571428571428571}, {0.2777777777777778, 
     0.8571428571428571}}], 
    LineBox[{{0.2730268277777778, 0.8888888888888888}, {0.2777777777777778, 
     0.8888888888888888}}], 
    LineBox[{{0.2682758777777778, 0.9206349206349206}, {0.2777777777777778, 
     0.9206349206349206}}], 
    LineBox[{{0.2730268277777778, 0.9523809523809523}, {0.2777777777777778, 
     0.9523809523809523}}], 
    LineBox[{{0.2730268277777778, 0.9841269841269841}, {0.2777777777777778, 
     0.9841269841269841}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], {}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd23lUjG8bB/AokVKUCikqklJEFJVvSIpKtEiIqLRZIi0kooVUUimSJO37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      "]]}}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 0.5238095238095238}, {1., 
     0.5238095238095238}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 0.5319540095238096}, {0.3055555555555556, 
     0.5238095238095238}}], 
    LineBox[{{0.32484567901234573`, 0.5319540095238096}, {
     0.32484567901234573`, 0.5238095238095238}}], 
    LineBox[{{0.34413580246913583`, 0.5400984952380953}, {
     0.34413580246913583`, 0.5238095238095238}}], 
    LineBox[{{0.36342592592592593`, 0.5319540095238096}, {
     0.36342592592592593`, 0.5238095238095238}}], 
    LineBox[{{0.3827160493827161, 0.5319540095238096}, {0.3827160493827161, 
     0.5238095238095238}}], 
    LineBox[{{0.4020061728395062, 0.5319540095238096}, {0.4020061728395062, 
     0.5238095238095238}}], 
    LineBox[{{0.42129629629629634`, 0.5400984952380953}, {
     0.42129629629629634`, 0.5238095238095238}}], 
    LineBox[{{0.44058641975308643`, 0.5319540095238096}, {
     0.44058641975308643`, 0.5238095238095238}}], 
    LineBox[{{0.4598765432098766, 0.5319540095238096}, {0.4598765432098766, 
     0.5238095238095238}}], 
    LineBox[{{0.4791666666666667, 0.5319540095238096}, {0.4791666666666667, 
     0.5238095238095238}}], 
    LineBox[{{0.4984567901234568, 0.5400984952380953}, {0.4984567901234568, 
     0.5238095238095238}}], 
    LineBox[{{0.5177469135802469, 0.5319540095238096}, {0.5177469135802469, 
     0.5238095238095238}}], 
    LineBox[{{0.5370370370370371, 0.5319540095238096}, {0.5370370370370371, 
     0.5238095238095238}}], 
    LineBox[{{0.5563271604938271, 0.5319540095238096}, {0.5563271604938271, 
     0.5238095238095238}}], 
    LineBox[{{0.5756172839506173, 0.5400984952380953}, {0.5756172839506173, 
     0.5238095238095238}}], 
    LineBox[{{0.5949074074074074, 0.5319540095238096}, {0.5949074074074074, 
     0.5238095238095238}}], 
    LineBox[{{0.6141975308641976, 0.5319540095238096}, {0.6141975308641976, 
     0.5238095238095238}}], 
    LineBox[{{0.6334876543209877, 0.5319540095238096}, {0.6334876543209877, 
     0.5238095238095238}}], 
    LineBox[{{0.6527777777777778, 0.5400984952380953}, {0.6527777777777778, 
     0.5238095238095238}}], 
    LineBox[{{0.6720679012345679, 0.5319540095238096}, {0.6720679012345679, 
     0.5238095238095238}}], 
    LineBox[{{0.691358024691358, 0.5319540095238096}, {0.691358024691358, 
     0.5238095238095238}}], 
    LineBox[{{0.7106481481481481, 0.5319540095238096}, {0.7106481481481481, 
     0.5238095238095238}}], 
    LineBox[{{0.7299382716049383, 0.5400984952380953}, {0.7299382716049383, 
     0.5238095238095238}}], 
    LineBox[{{0.7492283950617284, 0.5319540095238096}, {0.7492283950617284, 
     0.5238095238095238}}], 
    LineBox[{{0.7685185185185185, 0.5319540095238096}, {0.7685185185185185, 
     0.5238095238095238}}], 
    LineBox[{{0.7878086419753086, 0.5319540095238096}, {0.7878086419753086, 
     0.5238095238095238}}], 
    LineBox[{{0.8070987654320988, 0.5400984952380953}, {0.8070987654320988, 
     0.5238095238095238}}], 
    LineBox[{{0.826388888888889, 0.5319540095238096}, {0.826388888888889, 
     0.5238095238095238}}], 
    LineBox[{{0.845679012345679, 0.5319540095238096}, {0.845679012345679, 
     0.5238095238095238}}], 
    LineBox[{{0.8649691358024691, 0.5319540095238096}, {0.8649691358024691, 
     0.5238095238095238}}], 
    LineBox[{{0.8842592592592593, 0.5400984952380953}, {0.8842592592592593, 
     0.5238095238095238}}], 
    LineBox[{{0.9035493827160495, 0.5319540095238096}, {0.9035493827160495, 
     0.5238095238095238}}], 
    LineBox[{{0.9228395061728396, 0.5319540095238096}, {0.9228395061728396, 
     0.5238095238095238}}], 
    LineBox[{{0.9421296296296295, 0.5319540095238096}, {0.9421296296296295, 
     0.5238095238095238}}], 
    LineBox[{{0.9614197530864197, 0.5400984952380953}, {0.9614197530864197, 
     0.5238095238095238}}], 
    LineBox[{{0.9807098765432098, 0.5319540095238096}, {0.9807098765432098, 
     0.5238095238095238}}], 
    LineBox[{{1., 0.5319540095238096}, {1., 0.5238095238095238}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 0.5238095238095238}, {
      0.3055555555555556, 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.31030650555555556`, 0.5396825396825397}, {0.3055555555555556, 
     0.5396825396825397}}], 
    LineBox[{{0.31030650555555556`, 0.5714285714285714}, {0.3055555555555556, 
     0.5714285714285714}}], 
    LineBox[{{0.3150574555555556, 0.6031746031746031}, {0.3055555555555556, 
     0.6031746031746031}}], 
    LineBox[{{0.31030650555555556`, 0.6349206349206349}, {0.3055555555555556, 
     0.6349206349206349}}], 
    LineBox[{{0.31030650555555556`, 0.6666666666666666}, {0.3055555555555556, 
     0.6666666666666666}}], 
    LineBox[{{0.31030650555555556`, 0.6984126984126984}, {0.3055555555555556, 
     0.6984126984126984}}], 
    LineBox[{{0.31030650555555556`, 0.7301587301587301}, {0.3055555555555556, 
     0.7301587301587301}}], 
    LineBox[{{0.3150574555555556, 0.7619047619047619}, {0.3055555555555556, 
     0.7619047619047619}}], 
    LineBox[{{0.31030650555555556`, 0.7936507936507936}, {0.3055555555555556, 
     0.7936507936507936}}], 
    LineBox[{{0.31030650555555556`, 0.8253968253968254}, {0.3055555555555556, 
     0.8253968253968254}}], 
    LineBox[{{0.31030650555555556`, 0.8571428571428571}, {0.3055555555555556, 
     0.8571428571428571}}], 
    LineBox[{{0.31030650555555556`, 0.8888888888888888}, {0.3055555555555556, 
     0.8888888888888888}}], 
    LineBox[{{0.3150574555555556, 0.9206349206349206}, {0.3055555555555556, 
     0.9206349206349206}}], 
    LineBox[{{0.31030650555555556`, 0.9523809523809523}, {0.3055555555555556, 
     0.9523809523809523}}], 
    LineBox[{{0.31030650555555556`, 0.9841269841269841}, {0.3055555555555556, 
     0.9841269841269841}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 1}, {1., 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 0.9918555142857143}, {0.3055555555555556, 
     1.}}], LineBox[{{0.32484567901234573`, 0.9918555142857143}, {
     0.32484567901234573`, 1.}}], 
    LineBox[{{0.34413580246913583`, 0.9837110285714286}, {
     0.34413580246913583`, 1.}}], 
    LineBox[{{0.36342592592592593`, 0.9918555142857143}, {
     0.36342592592592593`, 1.}}], 
    LineBox[{{0.3827160493827161, 0.9918555142857143}, {0.3827160493827161, 
     1.}}], LineBox[{{0.4020061728395062, 0.9918555142857143}, {
     0.4020061728395062, 1.}}], 
    LineBox[{{0.42129629629629634`, 0.9837110285714286}, {
     0.42129629629629634`, 1.}}], 
    LineBox[{{0.44058641975308643`, 0.9918555142857143}, {
     0.44058641975308643`, 1.}}], 
    LineBox[{{0.4598765432098766, 0.9918555142857143}, {0.4598765432098766, 
     1.}}], LineBox[{{0.4791666666666667, 0.9918555142857143}, {
     0.4791666666666667, 1.}}], 
    LineBox[{{0.4984567901234568, 0.9837110285714286}, {0.4984567901234568, 
     1.}}], LineBox[{{0.5177469135802469, 0.9918555142857143}, {
     0.5177469135802469, 1.}}], 
    LineBox[{{0.5370370370370371, 0.9918555142857143}, {0.5370370370370371, 
     1.}}], LineBox[{{0.5563271604938271, 0.9918555142857143}, {
     0.5563271604938271, 1.}}], 
    LineBox[{{0.5756172839506173, 0.9837110285714286}, {0.5756172839506173, 
     1.}}], LineBox[{{0.5949074074074074, 0.9918555142857143}, {
     0.5949074074074074, 1.}}], 
    LineBox[{{0.6141975308641976, 0.9918555142857143}, {0.6141975308641976, 
     1.}}], 
    LineBox[{{0.6334876543209877, 0.9918555142857143}, {0.6334876543209877, 
     1.}}], LineBox[{{0.6527777777777778, 0.9837110285714286}, {
     0.6527777777777778, 1.}}], 
    LineBox[{{0.6720679012345679, 0.9918555142857143}, {0.6720679012345679, 
     1.}}], LineBox[{{0.691358024691358, 0.9918555142857143}, {
     0.691358024691358, 1.}}], 
    LineBox[{{0.7106481481481481, 0.9918555142857143}, {0.7106481481481481, 
     1.}}], LineBox[{{0.7299382716049383, 0.9837110285714286}, {
     0.7299382716049383, 1.}}], 
    LineBox[{{0.7492283950617284, 0.9918555142857143}, {0.7492283950617284, 
     1.}}], LineBox[{{0.7685185185185185, 0.9918555142857143}, {
     0.7685185185185185, 1.}}], 
    LineBox[{{0.7878086419753086, 0.9918555142857143}, {0.7878086419753086, 
     1.}}], LineBox[{{0.8070987654320988, 0.9837110285714286}, {
     0.8070987654320988, 1.}}], 
    LineBox[{{0.826388888888889, 0.9918555142857143}, {0.826388888888889, 
     1.}}], LineBox[{{0.845679012345679, 0.9918555142857143}, {
     0.845679012345679, 1.}}], 
    LineBox[{{0.8649691358024691, 0.9918555142857143}, {0.8649691358024691, 
     1.}}], LineBox[{{0.8842592592592593, 0.9837110285714286}, {
     0.8842592592592593, 1.}}], 
    LineBox[{{0.9035493827160495, 0.9918555142857143}, {0.9035493827160495, 
     1.}}], LineBox[{{0.9228395061728396, 0.9918555142857143}, {
     0.9228395061728396, 1.}}], 
    LineBox[{{0.9421296296296295, 0.9918555142857143}, {0.9421296296296295, 
     1.}}], LineBox[{{0.9614197530864197, 0.9837110285714286}, {
     0.9614197530864197, 1.}}], 
    LineBox[{{0.9807098765432098, 0.9918555142857143}, {0.9807098765432098, 
     1.}}], LineBox[{{1., 0.9918555142857143}, {1., 1.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{1., 0.5238095238095238}, {1., 1}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.99524905, 0.5396825396825397}, {1., 0.5396825396825397}}], 
    LineBox[{{0.99524905, 0.5714285714285714}, {1., 0.5714285714285714}}], 
    LineBox[{{0.9904981, 0.6031746031746031}, {1., 0.6031746031746031}}], 
    LineBox[{{0.99524905, 0.6349206349206349}, {1., 0.6349206349206349}}], 
    LineBox[{{0.99524905, 0.6666666666666666}, {1., 0.6666666666666666}}], 
    LineBox[{{0.99524905, 0.6984126984126984}, {1., 0.6984126984126984}}], 
    LineBox[{{0.99524905, 0.7301587301587301}, {1., 0.7301587301587301}}], 
    LineBox[{{0.9904981, 0.7619047619047619}, {1., 0.7619047619047619}}], 
    LineBox[{{0.99524905, 0.7936507936507936}, {1., 0.7936507936507936}}], 
    LineBox[{{0.99524905, 0.8253968253968254}, {1., 0.8253968253968254}}], 
    LineBox[{{0.99524905, 0.8571428571428571}, {1., 0.8571428571428571}}], 
    LineBox[{{0.99524905, 0.8888888888888888}, {1., 0.8888888888888888}}], 
    LineBox[{{0.9904981, 0.9206349206349206}, {1., 0.9206349206349206}}], 
    LineBox[{{0.99524905, 0.9523809523809523}, {1., 0.9523809523809523}}], 
    LineBox[{{0.99524905, 0.9841269841269841}, {1., 0.9841269841269841}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{4, 2}], {}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw9nHdcTf8fx42mkiJlJJUQKSGE6lUaFA2VtL9Fg6RBSxElJJGShLSorHZC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      "]]}}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], {}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVm3k4lF0YxilbdpWliJIkSZKKwl1SlmwVQhQlRYuKSvKV0KIFoUKWlLIk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      "]]}}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 1.1102230246251565`*^-16}, {0.2777777777777778, 
      1.1102230246251565`*^-16}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.009259259259259273, 0.008144485714285825}, {
     0.009259259259259273, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.02777777777777779, 0.008144485714285825}, {
     0.02777777777777779, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.04629629629629631, 0.01628897142857154}, {0.04629629629629631,
      1.1102230246251565`*^-16}}], 
    LineBox[{{0.06481481481481483, 0.008144485714285825}, {
     0.06481481481481483, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.08333333333333334, 0.008144485714285825}, {
     0.08333333333333334, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.10185185185185186`, 0.008144485714285825}, {
     0.10185185185185186`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.12037037037037038`, 0.008144485714285825}, {
     0.12037037037037038`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.1388888888888889, 0.01628897142857154}, {0.1388888888888889, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.1574074074074074, 0.008144485714285825}, {0.1574074074074074, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.17592592592592593`, 0.008144485714285825}, {
     0.17592592592592593`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.19444444444444445`, 0.008144485714285825}, {
     0.19444444444444445`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.21296296296296297`, 0.008144485714285825}, {
     0.21296296296296297`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.23148148148148148`, 0.01628897142857154}, {
     0.23148148148148148`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.25, 0.008144485714285825}, {0.25, 1.1102230246251565`*^-16}}],
     LineBox[{{0.2685185185185185, 0.008144485714285825}, {0.2685185185185185,
      1.1102230246251565`*^-16}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 1.1102230246251565`*^-16}, {0, 0.4761904761904763}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.0047509499999999994`, 0.015873015873015983`}, {0., 
     0.015873015873015983`}}], 
    LineBox[{{0.0047509499999999994`, 0.0476190476190477}, {0., 
     0.0476190476190477}}], 
    LineBox[{{0.009501899999999999, 0.07936507936507944}, {0., 
     0.07936507936507944}}], 
    LineBox[{{0.0047509499999999994`, 0.11111111111111119`}, {0., 
     0.11111111111111119`}}], 
    LineBox[{{0.0047509499999999994`, 0.14285714285714293`}, {0., 
     0.14285714285714293`}}], 
    LineBox[{{0.0047509499999999994`, 0.17460317460317468`}, {0., 
     0.17460317460317468`}}], 
    LineBox[{{0.0047509499999999994`, 0.20634920634920642`}, {0., 
     0.20634920634920642`}}], 
    LineBox[{{0.009501899999999999, 0.23809523809523817`}, {0., 
     0.23809523809523817`}}], 
    LineBox[{{0.0047509499999999994`, 0.2698412698412699}, {0., 
     0.2698412698412699}}], 
    LineBox[{{0.0047509499999999994`, 0.3015873015873016}, {0., 
     0.3015873015873016}}], 
    LineBox[{{0.0047509499999999994`, 0.33333333333333337`}, {0., 
     0.33333333333333337`}}], 
    LineBox[{{0.0047509499999999994`, 0.3650793650793651}, {0., 
     0.3650793650793651}}], 
    LineBox[{{0.009501899999999999, 0.39682539682539686`}, {0., 
     0.39682539682539686`}}], 
    LineBox[{{0.0047509499999999994`, 0.4285714285714286}, {0., 
     0.4285714285714286}}], 
    LineBox[{{0.0047509499999999994`, 0.46031746031746035`}, {0., 
     0.46031746031746035`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0, 0.4761904761904763}, {0.2777777777777778, 
      0.4761904761904763}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.009259259259259273, 0.46804599047619055`}, {
     0.009259259259259273, 0.4761904761904763}}], 
    LineBox[{{0.02777777777777779, 0.46804599047619055`}, {
     0.02777777777777779, 0.4761904761904763}}], 
    LineBox[{{0.04629629629629631, 0.45990150476190483`}, {
     0.04629629629629631, 0.4761904761904763}}], 
    LineBox[{{0.06481481481481483, 0.46804599047619055`}, {
     0.06481481481481483, 0.4761904761904763}}], 
    LineBox[{{0.08333333333333334, 0.46804599047619055`}, {
     0.08333333333333334, 0.4761904761904763}}], 
    LineBox[{{0.10185185185185186`, 0.46804599047619055`}, {
     0.10185185185185186`, 0.4761904761904763}}], 
    LineBox[{{0.12037037037037038`, 0.46804599047619055`}, {
     0.12037037037037038`, 0.4761904761904763}}], 
    LineBox[{{0.1388888888888889, 0.45990150476190483`}, {0.1388888888888889, 
     0.4761904761904763}}], 
    LineBox[{{0.1574074074074074, 0.46804599047619055`}, {0.1574074074074074, 
     0.4761904761904763}}], 
    LineBox[{{0.17592592592592593`, 0.46804599047619055`}, {
     0.17592592592592593`, 0.4761904761904763}}], 
    LineBox[{{0.19444444444444445`, 0.46804599047619055`}, {
     0.19444444444444445`, 0.4761904761904763}}], 
    LineBox[{{0.21296296296296297`, 0.46804599047619055`}, {
     0.21296296296296297`, 0.4761904761904763}}], 
    LineBox[{{0.23148148148148148`, 0.45990150476190483`}, {
     0.23148148148148148`, 0.4761904761904763}}], 
    LineBox[{{0.25, 0.46804599047619055`}, {0.25, 0.4761904761904763}}], 
    LineBox[{{0.2685185185185185, 0.46804599047619055`}, {0.2685185185185185, 
     0.4761904761904763}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.2777777777777778, 1.1102230246251565`*^-16}, {
     0.2777777777777778, 0.4761904761904763}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.2730268277777778, 0.015873015873015983`}, {0.2777777777777778,
      0.015873015873015983`}}], 
    LineBox[{{0.2730268277777778, 0.0476190476190477}, {0.2777777777777778, 
     0.0476190476190477}}], 
    LineBox[{{0.2682758777777778, 0.07936507936507944}, {0.2777777777777778, 
     0.07936507936507944}}], 
    LineBox[{{0.2730268277777778, 0.11111111111111119`}, {0.2777777777777778, 
     0.11111111111111119`}}], 
    LineBox[{{0.2730268277777778, 0.14285714285714293`}, {0.2777777777777778, 
     0.14285714285714293`}}], 
    LineBox[{{0.2730268277777778, 0.17460317460317468`}, {0.2777777777777778, 
     0.17460317460317468`}}], 
    LineBox[{{0.2730268277777778, 0.20634920634920642`}, {0.2777777777777778, 
     0.20634920634920642`}}], 
    LineBox[{{0.2682758777777778, 0.23809523809523817`}, {0.2777777777777778, 
     0.23809523809523817`}}], 
    LineBox[{{0.2730268277777778, 0.2698412698412699}, {0.2777777777777778, 
     0.2698412698412699}}], 
    LineBox[{{0.2730268277777778, 0.3015873015873016}, {0.2777777777777778, 
     0.3015873015873016}}], 
    LineBox[{{0.2730268277777778, 0.33333333333333337`}, {0.2777777777777778, 
     0.33333333333333337`}}], 
    LineBox[{{0.2730268277777778, 0.3650793650793651}, {0.2777777777777778, 
     0.3650793650793651}}], 
    LineBox[{{0.2682758777777778, 0.39682539682539686`}, {0.2777777777777778, 
     0.39682539682539686`}}], 
    LineBox[{{0.2730268277777778, 0.4285714285714286}, {0.2777777777777778, 
     0.4285714285714286}}], 
    LineBox[{{0.2730268277777778, 0.46031746031746035`}, {0.2777777777777778, 
     0.46031746031746035`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], {}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUm3k8lG8XxqUSEpKkQvYlqUiRcJWkUmTPThKFny3Zk0qUItGCNsm+L2Mb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      "]]}}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 1.1102230246251565`*^-16}, {1., 
     1.1102230246251565`*^-16}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 0.008144485714285825}, {0.3055555555555556, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.32484567901234573`, 0.008144485714285825}, {
     0.32484567901234573`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.34413580246913583`, 0.01628897142857154}, {
     0.34413580246913583`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.36342592592592593`, 0.008144485714285825}, {
     0.36342592592592593`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.3827160493827161, 0.008144485714285825}, {0.3827160493827161, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.4020061728395062, 0.008144485714285825}, {0.4020061728395062, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.42129629629629634`, 0.01628897142857154}, {
     0.42129629629629634`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.44058641975308643`, 0.008144485714285825}, {
     0.44058641975308643`, 1.1102230246251565`*^-16}}], 
    LineBox[{{0.4598765432098766, 0.008144485714285825}, {0.4598765432098766, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.4791666666666667, 0.008144485714285825}, {0.4791666666666667, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.4984567901234568, 0.01628897142857154}, {0.4984567901234568, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.5177469135802469, 0.008144485714285825}, {0.5177469135802469, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.5370370370370371, 0.008144485714285825}, {0.5370370370370371, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.5563271604938271, 0.008144485714285825}, {0.5563271604938271, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.5756172839506173, 0.01628897142857154}, {0.5756172839506173, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.5949074074074074, 0.008144485714285825}, {0.5949074074074074, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.6141975308641976, 0.008144485714285825}, {0.6141975308641976, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.6334876543209877, 0.008144485714285825}, {0.6334876543209877, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.6527777777777778, 0.01628897142857154}, {0.6527777777777778, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.6720679012345679, 0.008144485714285825}, {0.6720679012345679, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.691358024691358, 0.008144485714285825}, {0.691358024691358, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.7106481481481481, 0.008144485714285825}, {0.7106481481481481, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.7299382716049383, 0.01628897142857154}, {0.7299382716049383, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.7492283950617284, 0.008144485714285825}, {0.7492283950617284, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.7685185185185185, 0.008144485714285825}, {0.7685185185185185, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.7878086419753086, 0.008144485714285825}, {0.7878086419753086, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.8070987654320988, 0.01628897142857154}, {0.8070987654320988, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.826388888888889, 0.008144485714285825}, {0.826388888888889, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.845679012345679, 0.008144485714285825}, {0.845679012345679, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.8649691358024691, 0.008144485714285825}, {0.8649691358024691, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.8842592592592593, 0.01628897142857154}, {0.8842592592592593, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.9035493827160495, 0.008144485714285825}, {0.9035493827160495, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.9228395061728396, 0.008144485714285825}, {0.9228395061728396, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.9421296296296295, 0.008144485714285825}, {0.9421296296296295, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.9614197530864197, 0.01628897142857154}, {0.9614197530864197, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{0.9807098765432098, 0.008144485714285825}, {0.9807098765432098, 
     1.1102230246251565`*^-16}}], 
    LineBox[{{1., 0.008144485714285825}, {1., 1.1102230246251565`*^-16}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 1.1102230246251565`*^-16}, {
     0.3055555555555556, 0.4761904761904763}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.31030650555555556`, 0.015873015873015983`}, {
     0.3055555555555556, 0.015873015873015983`}}], 
    LineBox[{{0.31030650555555556`, 0.0476190476190477}, {0.3055555555555556, 
     0.0476190476190477}}], 
    LineBox[{{0.3150574555555556, 0.07936507936507944}, {0.3055555555555556, 
     0.07936507936507944}}], 
    LineBox[{{0.31030650555555556`, 0.11111111111111119`}, {
     0.3055555555555556, 0.11111111111111119`}}], 
    LineBox[{{0.31030650555555556`, 0.14285714285714293`}, {
     0.3055555555555556, 0.14285714285714293`}}], 
    LineBox[{{0.31030650555555556`, 0.17460317460317468`}, {
     0.3055555555555556, 0.17460317460317468`}}], 
    LineBox[{{0.31030650555555556`, 0.20634920634920642`}, {
     0.3055555555555556, 0.20634920634920642`}}], 
    LineBox[{{0.3150574555555556, 0.23809523809523817`}, {0.3055555555555556, 
     0.23809523809523817`}}], 
    LineBox[{{0.31030650555555556`, 0.2698412698412699}, {0.3055555555555556, 
     0.2698412698412699}}], 
    LineBox[{{0.31030650555555556`, 0.3015873015873016}, {0.3055555555555556, 
     0.3015873015873016}}], 
    LineBox[{{0.31030650555555556`, 0.33333333333333337`}, {
     0.3055555555555556, 0.33333333333333337`}}], 
    LineBox[{{0.31030650555555556`, 0.3650793650793651}, {0.3055555555555556, 
     0.3650793650793651}}], 
    LineBox[{{0.3150574555555556, 0.39682539682539686`}, {0.3055555555555556, 
     0.39682539682539686`}}], 
    LineBox[{{0.31030650555555556`, 0.4285714285714286}, {0.3055555555555556, 
     0.4285714285714286}}], 
    LineBox[{{0.31030650555555556`, 0.46031746031746035`}, {
     0.3055555555555556, 0.46031746031746035`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 0.4761904761904763}, {1., 
     0.4761904761904763}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.3055555555555556, 0.46804599047619055`}, {0.3055555555555556, 
     0.4761904761904763}}], 
    LineBox[{{0.32484567901234573`, 0.46804599047619055`}, {
     0.32484567901234573`, 0.4761904761904763}}], 
    LineBox[{{0.34413580246913583`, 0.45990150476190483`}, {
     0.34413580246913583`, 0.4761904761904763}}], 
    LineBox[{{0.36342592592592593`, 0.46804599047619055`}, {
     0.36342592592592593`, 0.4761904761904763}}], 
    LineBox[{{0.3827160493827161, 0.46804599047619055`}, {0.3827160493827161, 
     0.4761904761904763}}], 
    LineBox[{{0.4020061728395062, 0.46804599047619055`}, {0.4020061728395062, 
     0.4761904761904763}}], 
    LineBox[{{0.42129629629629634`, 0.45990150476190483`}, {
     0.42129629629629634`, 0.4761904761904763}}], 
    LineBox[{{0.44058641975308643`, 0.46804599047619055`}, {
     0.44058641975308643`, 0.4761904761904763}}], 
    LineBox[{{0.4598765432098766, 0.46804599047619055`}, {0.4598765432098766, 
     0.4761904761904763}}], 
    LineBox[{{0.4791666666666667, 0.46804599047619055`}, {0.4791666666666667, 
     0.4761904761904763}}], 
    LineBox[{{0.4984567901234568, 0.45990150476190483`}, {0.4984567901234568, 
     0.4761904761904763}}], 
    LineBox[{{0.5177469135802469, 0.46804599047619055`}, {0.5177469135802469, 
     0.4761904761904763}}], 
    LineBox[{{0.5370370370370371, 0.46804599047619055`}, {0.5370370370370371, 
     0.4761904761904763}}], 
    LineBox[{{0.5563271604938271, 0.46804599047619055`}, {0.5563271604938271, 
     0.4761904761904763}}], 
    LineBox[{{0.5756172839506173, 0.45990150476190483`}, {0.5756172839506173, 
     0.4761904761904763}}], 
    LineBox[{{0.5949074074074074, 0.46804599047619055`}, {0.5949074074074074, 
     0.4761904761904763}}], 
    LineBox[{{0.6141975308641976, 0.46804599047619055`}, {0.6141975308641976, 
     0.4761904761904763}}], 
    LineBox[{{0.6334876543209877, 0.46804599047619055`}, {0.6334876543209877, 
     0.4761904761904763}}], 
    LineBox[{{0.6527777777777778, 0.45990150476190483`}, {0.6527777777777778, 
     0.4761904761904763}}], 
    LineBox[{{0.6720679012345679, 0.46804599047619055`}, {0.6720679012345679, 
     0.4761904761904763}}], 
    LineBox[{{0.691358024691358, 0.46804599047619055`}, {0.691358024691358, 
     0.4761904761904763}}], 
    LineBox[{{0.7106481481481481, 0.46804599047619055`}, {0.7106481481481481, 
     0.4761904761904763}}], 
    LineBox[{{0.7299382716049383, 0.45990150476190483`}, {0.7299382716049383, 
     0.4761904761904763}}], 
    LineBox[{{0.7492283950617284, 0.46804599047619055`}, {0.7492283950617284, 
     0.4761904761904763}}], 
    LineBox[{{0.7685185185185185, 0.46804599047619055`}, {0.7685185185185185, 
     0.4761904761904763}}], 
    LineBox[{{0.7878086419753086, 0.46804599047619055`}, {0.7878086419753086, 
     0.4761904761904763}}], 
    LineBox[{{0.8070987654320988, 0.45990150476190483`}, {0.8070987654320988, 
     0.4761904761904763}}], 
    LineBox[{{0.826388888888889, 0.46804599047619055`}, {0.826388888888889, 
     0.4761904761904763}}], 
    LineBox[{{0.845679012345679, 0.46804599047619055`}, {0.845679012345679, 
     0.4761904761904763}}], 
    LineBox[{{0.8649691358024691, 0.46804599047619055`}, {0.8649691358024691, 
     0.4761904761904763}}], 
    LineBox[{{0.8842592592592593, 0.45990150476190483`}, {0.8842592592592593, 
     0.4761904761904763}}], 
    LineBox[{{0.9035493827160495, 0.46804599047619055`}, {0.9035493827160495, 
     0.4761904761904763}}], 
    LineBox[{{0.9228395061728396, 0.46804599047619055`}, {0.9228395061728396, 
     0.4761904761904763}}], 
    LineBox[{{0.9421296296296295, 0.46804599047619055`}, {0.9421296296296295, 
     0.4761904761904763}}], 
    LineBox[{{0.9614197530864197, 0.45990150476190483`}, {0.9614197530864197, 
     0.4761904761904763}}], 
    LineBox[{{0.9807098765432098, 0.46804599047619055`}, {0.9807098765432098, 
     0.4761904761904763}}], 
    LineBox[{{1., 0.46804599047619055`}, {1., 0.4761904761904763}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{1., 1.1102230246251565`*^-16}, {1., 0.4761904761904763}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{0.99524905, 0.015873015873015983`}, {1., 
     0.015873015873015983`}}], 
    LineBox[{{0.99524905, 0.0476190476190477}, {1., 0.0476190476190477}}], 
    LineBox[{{0.9904981, 0.07936507936507944}, {1., 0.07936507936507944}}], 
    LineBox[{{0.99524905, 0.11111111111111119`}, {1., 0.11111111111111119`}}],
     LineBox[{{0.99524905, 0.14285714285714293`}, {1., 
     0.14285714285714293`}}], 
    LineBox[{{0.99524905, 0.17460317460317468`}, {1., 0.17460317460317468`}}],
     LineBox[{{0.99524905, 0.20634920634920642`}, {1., 
     0.20634920634920642`}}], 
    LineBox[{{0.9904981, 0.23809523809523817`}, {1., 0.23809523809523817`}}], 
    LineBox[{{0.99524905, 0.2698412698412699}, {1., 0.2698412698412699}}], 
    LineBox[{{0.99524905, 0.3015873015873016}, {1., 0.3015873015873016}}], 
    LineBox[{{0.99524905, 0.33333333333333337`}, {1., 0.33333333333333337`}}],
     LineBox[{{0.99524905, 0.3650793650793651}, {1., 0.3650793650793651}}], 
    LineBox[{{0.9904981, 0.39682539682539686`}, {1., 0.39682539682539686`}}], 
    LineBox[{{0.99524905, 0.4285714285714286}, {1., 0.4285714285714286}}], 
    LineBox[{{0.99524905, 0.46031746031746035`}, {1., 
     0.46031746031746035`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
    AbsoluteDashing[{4, 2}], {}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw9nHc81f/7/1WSlSijt5RISylpKeOBKMkm2SkjSUpJolSKJKkkKS0yGpI4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      "]]}}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUWnc81t8fpWSTVEgqyTdFpEJKHBllr2SFRApJS5JKRUYoJakkSVKSQs9j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       "]]}}, InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(a)\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       ShowContents->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.034729166666666665`, 0.9404642857142858}, {0, 0}, 
     Automatic, {1, 0},
     Background->RGBColor[0.960799, 0.870602, 0.702002]], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(b)\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       ShowContents->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.3402847222222222, 0.9404642857142858}, {0, 0}, 
     Automatic, {1, 0},
     Background->RGBColor[0.960799, 0.870602, 0.702002]], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(d)\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       ShowContents->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.3402847222222222, 0.416654761904762}, {0, 0}, 
     Automatic, {1, 0},
     Background->RGBColor[0.960799, 0.870602, 0.702002]], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"Lissajous curves\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->18,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5, 1.10012}, {0, 1}, Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"-1\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0011576388888888888`, 0.6031746031746031}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0011576388888888888`, 0.7619047619047619}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0011576388888888888`, 0.9206349206349206}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[
         StyleBox["\<\"y\"\>",
          FontSlant->"Italic"],
         StyleForm[#, FontSlant -> "Italic"]& ],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.042832638888888885`, 0.761904761904762}, {0, 0}, 
     Automatic, {0, 1}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(a)\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.034729166666666665`, 0.9404642857142858}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(b)\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.3402847222222222, 0.9404642857142858}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"-1\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.04629629629629631, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1388888888888889, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.23148148148148148`, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[
         StyleBox["\<\"x\"\>",
          FontSlant->"Italic"],
         StyleForm[#, FontSlant -> "Italic"]& ],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.1388888888888889, -0.061520238095237975`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"-1\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0011576388888888888`, 0.07936507936507944}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"0\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0011576388888888888`, 0.23809523809523817`}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"1\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.0011576388888888888`, 0.39682539682539686`}, {1, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[
         StyleBox["\<\"y\"\>",
          FontSlant->"Italic"],
         StyleForm[#, FontSlant -> "Italic"]& ],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.042832638888888885`, 0.23809523809523825`}, {0, 0}, 
     Automatic, {0, 1}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(c)\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.034729166666666665`, 0.416654761904762}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["0",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.34413580246913583`, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\[Pi]",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.42129629629629634`, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        RowBox[{"2", " ", "\[Pi]"}],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.4984567901234568, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        RowBox[{"3", " ", "\[Pi]"}],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.5756172839506173, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        RowBox[{"4", " ", "\[Pi]"}],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.6527777777777778, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        RowBox[{"5", " ", "\[Pi]"}],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.7299382716049383, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        RowBox[{"6", " ", "\[Pi]"}],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.8070987654320988, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        RowBox[{"7", " ", "\[Pi]"}],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.8842592592592593, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        RowBox[{"8", " ", "\[Pi]"}],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->10,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.9614197530864197, -0.0019845238095236983`}, {0, 1}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[
         StyleBox["\<\"t\"\>",
          FontSlant->"Italic"],
         StyleForm[#, FontSlant -> "Italic"]& ],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.6527777777777779, -0.061520238095237975`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"(d)\"\>",
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.3402847222222222, 0.416654761904762}, {0, 0}, 
     Automatic, {1, 0}]}},
  AspectRatio->0.5833333333333335,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{518.4, 302.40000000000003`},
  PlotRange->{{-0.10012, 1.10012}, {-0.10012, 1.10012}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.395521504296875*^9, 3.395521533546875*^9}, 
   3.39688018959375*^9, 3.430248063421875*^9, 3.47108972125*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plots with axes -- Harmonic oscillator radial solutions", "Section",
 CellChangeTimes->{{3.49211071465625*^9, 3.49211071803125*^9}, {
  3.49212386140625*^9, 3.49212387503125*^9}, {3.4921248533125*^9, 
  3.492124856453125*^9}}],

Cell["\<\
In this example, we use LevelScheme to control the appearance of the plot \
line, by feeding the output of Plot to SchemeLine, which takes the plot's \
curve, extracts the coordinates of its points, and (re)draws the curve \
following these points, but using SchemeLine's formatting options.\
\>", "Text",
 CellChangeTimes->{{3.499022408515625*^9, 3.499022501*^9}, {
  3.499032886046875*^9, 3.499032945375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VHO", "[", 
    RowBox[{"l_", ",", "r_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"VCent", "[", 
     RowBox[{"l", ",", "r"}], "]"}], "+", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "*", 
     RowBox[{"r", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VCent", "[", 
    RowBox[{"l_", ",", "r_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "*", "l", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"l", "+", "1"}], ")"}], "/", 
     RowBox[{"r", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"n_", ",", "l_", ",", "r_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"Factorial", "[", "n", "]"}], "/", 
       RowBox[{"Gamma", "[", 
        RowBox[{"n", "+", "l", "+", 
         RowBox[{"3", "/", "2"}]}], "]"}]}]}], "]"}], "*", 
    RowBox[{"r", "^", "l"}], "*", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"r", "^", "2"}]}], "/", "2"}], "]"}], "*", 
    RowBox[{"LaguerreL", "[", 
     RowBox[{"n", ",", 
      RowBox[{"l", "+", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"r", "^", "2"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"n_", ",", "l_", ",", "r_"}], "]"}], ":=", 
   RowBox[{"r", "*", 
    RowBox[{"g", "[", 
     RowBox[{"n", ",", "l", ",", "r"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.492121372359375*^9, 3.4921213936875*^9}, {
  3.4921215495*^9, 3.492121571109375*^9}, {3.492121961109375*^9, 
  3.492122080234375*^9}, {3.492122113359375*^9, 3.492122138828125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"With", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"rMax", "=", "5"}], ",", 
        RowBox[{"dr", "=", "0.1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"VMax", "=", "10"}], ",", 
        RowBox[{"dV", "=", "0.1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"fMax", "=", "1"}], ",", 
        RowBox[{"df", "=", "0.05"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"XPlotRanges", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "rMax"}], "}"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"XGapSizes", "\[Rule]", "0.15"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"YPlotRanges", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "VMax"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "fMax"}], ",", "fMax"}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"YPanelSizes", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"ShowPanelLetter", "\[Rule]", "False"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Frame", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
          RowBox[{"ExtendRange", "\[Rule]", "0.1"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Margin", "\[Rule]", "20"}]}], "\[IndentingNewLine]", "]"}],
         ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"l", "=", 
             RowBox[{"s", "-", "1"}]}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"top", " ", 
              RowBox[{"panel", " ", "--"}], " ", "potential"}], " ", "*)"}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"FigurePanel", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "s"}], "}"}], "]"}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"column", " ", "label"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"ScaledLabel", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.5", ",", "1"}], "}"}], ",", 
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{"\"\<\[ScriptL]\>\"", ",", "\"\<=\>\"", ",", "l"}], 
                "}"}], "]"}], ",", 
              RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", "axes", " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"SchemeAxis", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Bottom", ",", "Left"}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"rMax", "+", "dr"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"VMax", "+", "dV"}]}], "}"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"LabB", "\[Rule]", 
               RowBox[{"textit", "[", "\"\<r\>\"", "]"}]}], ",", 
              RowBox[{"LabL", "\[Rule]", 
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"textit", "[", "V", "]"}], ",", "\"\<(\>\"", ",", 
                  RowBox[{"textit", "[", "\"\<r\>\"", "]"}], ",", 
                  "\"\<)\>\""}], "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"PosnB", "\[Rule]", "0.9"}], ",", 
              RowBox[{"PosnL", "\[Rule]", "0.9"}], ",", 
              RowBox[{"OrientationL", "\[Rule]", "Horizontal"}], ",", 
              RowBox[{"OffsetL", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}]}], ",", 
              RowBox[{"BufferL", "\[Rule]", "0.5"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"None", ",", 
                 RowBox[{"LinTicks", "[", 
                  RowBox[{"0", ",", "VMax", ",", "1", ",", "1", ",", 
                   RowBox[{"ShowTickLabels", "\[Rule]", "False"}], ",", 
                   RowBox[{"TickLengthScale", "\[Rule]", "0.5"}]}], "]"}]}], 
                "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"TickLineColor", "\[Rule]", "Gray"}]}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"potential", " ", "plots"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"SchemeLine", "[", 
             RowBox[{
              RowBox[{"Plot", "[", 
               RowBox[{
                RowBox[{"VHO", "[", 
                 RowBox[{"l", ",", "r"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "0", ",", "rMax"}], "}"}], ",", 
                RowBox[{"PlotRange", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "VMax"}], "}"}]}]}], "]"}], ",", 
              RowBox[{"Thickness", "\[Rule]", "2"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"l", ">", "0"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"SchemeLine", "[", 
                 RowBox[{"Plot", "[", 
                  RowBox[{
                   RowBox[{"VHO", "[", 
                    RowBox[{"0", ",", "r"}], "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"r", ",", "0", ",", "rMax"}], "}"}], ",", 
                   RowBox[{"PlotRange", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "VMax"}], "}"}]}]}], "]"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"SchemeLine", "[", 
                 RowBox[{
                  RowBox[{"Plot", "[", 
                   RowBox[{
                    RowBox[{"VCent", "[", 
                    RowBox[{"l", ",", "r"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"r", ",", "0", ",", "rMax"}], "}"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "VMax"}], "}"}]}]}], "]"}], ",", 
                  RowBox[{"Dashing", "\[Rule]", "3"}]}], "]"}]}], 
               "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], 
            ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"dots", " ", "for", " ", "energies"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"SetOptions", "[", 
             RowBox[{"SchemeCircle", ",", 
              RowBox[{"Color", "\[Rule]", "Red"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"SchemeCircle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{"2", "*", "n"}], "+", "l", "+", 
                   RowBox[{"3", "/", "2"}]}]}], "}"}], ",", 
                RowBox[{"Point", "[", "2", "]"}], ",", 
                RowBox[{"Show", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "*", "n"}], "+", "l", "+", 
                    RowBox[{"3", "/", "2"}]}], ")"}], "<=", "VMax"}], 
                  ")"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"n", ",", "0", ",", "VMax"}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"bottom", " ", 
              RowBox[{"panel", " ", "--"}], " ", "auxiliary", " ", "radial", 
              " ", "wave", " ", "function"}], " ", "*)"}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"FigurePanel", "[", 
             RowBox[{"{", 
              RowBox[{"2", ",", "s"}], "}"}], "]"}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", "axes", " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"SchemeAxis", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Bottom", ",", "Left"}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"rMax", "+", "dr"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "fMax"}], ",", 
                  RowBox[{"fMax", "+", "df"}]}], "}"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"LabB", "\[Rule]", 
               RowBox[{"textit", "[", "\"\<r\>\"", "]"}]}], ",", 
              RowBox[{"LabL", "\[Rule]", 
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"textit", "[", "u", "]"}], ",", "\"\<(\>\"", ",", 
                  RowBox[{"textit", "[", "\"\<r\>\"", "]"}], ",", 
                  "\"\<)\>\""}], "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"PosnB", "\[Rule]", "0.9"}], ",", 
              RowBox[{"PosnL", "\[Rule]", "0.9"}], ",", 
              RowBox[{"OrientationL", "\[Rule]", "Horizontal"}], ",", 
              RowBox[{"OffsetL", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}]}], ",", 
              RowBox[{"BufferL", "\[Rule]", "0.5"}]}], "\[IndentingNewLine]", 
             "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"wave", " ", "function", " ", "plots"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"SchemeLine", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"Plot", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"n", ",", "l", ",", "r"}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"r", ",", "0", ",", "rMax"}], "}"}], ",", 
                  RowBox[{"PlotRange", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "fMax"}], ",", "fMax"}], "}"}]}]}], "]"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"Color", "\[Rule]", "Red"}], ",", 
                RowBox[{"Dashing", "\[Rule]", 
                 RowBox[{"Switch", "[", 
                  RowBox[{
                  "n", ",", "0", ",", "None", ",", "1", ",", "4", ",", "2", 
                   ",", "2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"n", ",", "0", ",", "2"}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], ","}], "\[IndentingNewLine]", 
           "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"s", ",", "1", ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
         "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], 
     "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"8", ",", "5"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.492110727375*^9, 3.4921107806875*^9}, {
   3.492110840640625*^9, 3.492111020375*^9}, {3.492111059796875*^9, 
   3.4921111175625*^9}, {3.492111185078125*^9, 3.49211121003125*^9}, 
   3.492122097671875*^9, {3.492122198390625*^9, 3.492122345765625*^9}, {
   3.492122411453125*^9, 3.4921233444375*^9}, {3.492123448890625*^9, 
   3.492123516671875*^9}, {3.49212355040625*^9, 3.4921236323125*^9}, {
   3.4921236738125*^9, 3.4921236840625*^9}, {3.492123759375*^9, 
   3.492123809453125*^9}, {3.4921251469375*^9, 3.492125161578125*^9}, {
   3.499022392984375*^9, 3.4990224044375*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.0582276936026936, 0.45555666666666667`}, {
     0.2979126683501683, 0.45555666666666667`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.2874939183501683, 0.4638916666666666}, {
     0.2979126683501683, 0.4555566666666666}, {0.2874939183501683, 
     0.44722166666666663`}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.0582276936026936, 0.45555666666666667`}, {
     0.0582276936026936, 0.9044343333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.053018318602693584`, 0.8877643333333333}, {
     0.058227693602693587`, 0.9044343333333332}, {0.06343706860269359, 
     0.8877643333333333}}]}, 
   {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.0622910061026936, 0.45555666666666667`}, {
     0.0582276936026936, 0.45555666666666667`}}], 
    LineBox[{{0.0622910061026936, 0.5}, {0.0582276936026936, 0.5}}], 
    LineBox[{{0.0622910061026936, 0.5444433333333334}, {0.0582276936026936, 
     0.5444433333333334}}], 
    LineBox[{{0.0622910061026936, 0.5888866666666667}, {0.0582276936026936, 
     0.5888866666666667}}], 
    LineBox[{{0.0622910061026936, 0.63333}, {0.0582276936026936, 0.63333}}], 
    LineBox[{{0.0622910061026936, 0.6777733333333333}, {0.0582276936026936, 
     0.6777733333333333}}], 
    LineBox[{{0.0622910061026936, 0.7222166666666667}, {0.0582276936026936, 
     0.7222166666666667}}], 
    LineBox[{{0.0622910061026936, 0.76666}, {0.0582276936026936, 0.76666}}], 
    LineBox[{{0.0622910061026936, 0.8111033333333333}, {0.0582276936026936, 
     0.8111033333333333}}], 
    LineBox[{{0.0622910061026936, 0.8555466666666667}, {0.0582276936026936, 
     0.8555466666666667}}], 
    LineBox[{{0.0622910061026936, 0.8999900000000001}, {0.0582276936026936, 
     0.8999900000000001}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[CompressedData["
1:eJwV1Hk01WsXB3CUlEauKJIkia65kvEbqotyRZkKlTHcFupWXg4azFcqU6wK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     "]], 
    {RGBColor[1, 0, 0], Opacity[1], 
     DiskBox[{0.0582276936026936, 0.5222216666666667}, {0.0034729166666666663`, 0.005556666666666666},
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
     CapForm[None], 
     CircleBox[{0.0582276936026936, 0.5222216666666667}, {0.0034729166666666663`, 0.005556666666666666},
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
     {RGBColor[1, 0, 0], Opacity[1], 
      DiskBox[{0.0582276936026936, 0.6111083333333334}, {0.0034729166666666663`, 0.005556666666666666},
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      CircleBox[{0.0582276936026936, 0.6111083333333334}, {0.0034729166666666663`, 0.005556666666666666},
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
      {RGBColor[1, 0, 0], Opacity[1], 
       DiskBox[{0.0582276936026936, 0.699995}, {0.0034729166666666663`, 0.005556666666666666},
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       CircleBox[{0.0582276936026936, 0.699995}, {0.0034729166666666663`, 0.005556666666666666},
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
       {RGBColor[1, 0, 0], Opacity[1], 
        DiskBox[{0.0582276936026936, 0.7888816666666667}, {0.0034729166666666663`, 0.005556666666666666},
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
        CapForm[None], 
        CircleBox[{0.0582276936026936, 0.7888816666666667}, {0.0034729166666666663`, 0.005556666666666666},
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
        {RGBColor[1, 0, 0], Opacity[1], 
         DiskBox[{0.0582276936026936, 0.8777683333333333}, {0.0034729166666666663`, 0.005556666666666666},
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
         CapForm[None], 
         CircleBox[{0.0582276936026936, 0.8777683333333333}, {0.0034729166666666663`, 0.005556666666666666},
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.0582276936026936, 0.23334}, {0.2979126683501683, 
          0.23334}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.2874939183501683, 0.24167500000000003`}, {
          0.2979126683501683, 0.23334000000000002`}, {0.2874939183501683, 
          0.22500500000000004`}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.0582276936026936, 0.08519555555555552}, {
          0.0582276936026936, 0.3888916666666667}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.053018318602693584`, 0.3722216666666667}, {
          0.058227693602693587`, 0.3888916666666667}, {0.06343706860269359, 
          0.3722216666666667}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None]}, 
        {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
         CapForm[None], LineBox[CompressedData["
1:eJwV2Hc81V0cB3CzRCkiSaKhlMpIlNSnUpRkZI8UqZBUtMiDJCMzDSqjZWdl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          "]]}, 
        {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
         AbsoluteDashing[{4, 2}], CapForm[None], LineBox[CompressedData["
1:eJwV13k4lF8bB3CphJRSohBCKQllK8u3VSVJ2oSECpUkRYUKSRESkSXVL9n3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          "]]}, 
        {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
         AbsoluteDashing[{2, 1}], CapForm[None], LineBox[CompressedData["
1:eJwVl3k8VG8bxhEppNKCJFpIC6mkolxEKhVaLEmbZCkpKYRQ2ZPsEW1SWuzG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          "]]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.38250736531986523`, 0.45555666666666667`}, {
          0.6221923400673399, 0.45555666666666667`}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.6117735900673399, 0.4638916666666666}, {
          0.6221923400673398, 0.4555566666666666}, {0.6117735900673399, 
          0.44722166666666663`}}]}, 
        {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
         CapForm[None]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.38250736531986523`, 0.45555666666666667`}, {
          0.38250736531986523`, 0.9044343333333333}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.3772979903198652, 0.8877643333333333}, {
          0.38250736531986523`, 0.9044343333333332}, {0.38771674031986525`, 
          0.8877643333333333}}]}, 
        {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
         CapForm[None], 
         LineBox[{{0.3865706778198652, 0.45555666666666667`}, {
          0.38250736531986523`, 0.45555666666666667`}}], 
         LineBox[{{0.3865706778198652, 0.5}, {0.38250736531986523`, 0.5}}], 
         LineBox[{{0.3865706778198652, 0.5444433333333334}, {
          0.38250736531986523`, 0.5444433333333334}}], 
         LineBox[{{0.3865706778198652, 0.5888866666666667}, {
          0.38250736531986523`, 0.5888866666666667}}], 
         LineBox[{{0.3865706778198652, 0.63333}, {0.38250736531986523`, 
          0.63333}}], 
         LineBox[{{0.3865706778198652, 0.6777733333333333}, {
          0.38250736531986523`, 0.6777733333333333}}], 
         LineBox[{{0.3865706778198652, 0.7222166666666667}, {
          0.38250736531986523`, 0.7222166666666667}}], 
         LineBox[{{0.3865706778198652, 0.76666}, {0.38250736531986523`, 
          0.76666}}], 
         LineBox[{{0.3865706778198652, 0.8111033333333333}, {
          0.38250736531986523`, 0.8111033333333333}}], 
         LineBox[{{0.3865706778198652, 0.8555466666666667}, {
          0.38250736531986523`, 0.8555466666666667}}], 
         LineBox[{{0.3865706778198652, 0.8999900000000001}, {
          0.38250736531986523`, 0.8999900000000001}}]}, 
        {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[CompressedData["
1:eJw92Hk4VXsXB3BDg5uopDToEiVTpUHJ9FXGEEWZhxAR0qxLZYpUpFHKLA0U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          "]]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[CompressedData["
1:eJwV03k01ekfB3CRmnQmpYVMKoxkzVJDWd62QimlsZWuEhpU5GT5yTIpu2SE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          "]]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[
          NCache[{3, 
            Rational[3, 2]}, {3, 1.5}]], CapForm[None], 
         LineBox[CompressedData["
1:eJwV1nlYDusbB/A2pAWnHUWbZCm7Uh1f2veQUEpKaVE5pU1RIRSSU9IiLXT6
2duUvESdFkooSzUz78y7tahkTSHym/PHXHN9rpnrmfu5n3ue+9Hy3b/FX0JM
TIxir//unRV3OpLCCAxZqL6+2/4Odte9/nkYQ8BPa2Ot9uNhHMj0ujwUS2C3
+sMgqavDuHTIq1AljoBSg1mJa+owPjl75YYdIsAp/1i/0mkYuV880+YdIZCs
EbrvITGEt2aeUQmnCJyo1liYLDUEBT3PiOunCVhz3Hn+w4Mwm+m5v+sMAf9j
4eO5LwdxTrAzyDCdQPs5/TtfigdhdGKnF5NJ4PmCH99sLAdx8oWH1fpLBNKf
Bg3suvAWFbUe5sEFBPQzX7x6duQtqGIPXCgkYJKZJYwPfQvDSI9174sJ2Bwm
9v5t9RZdah4GBaUEHpQfnHfy2wAW+LorT5YRKK0nVd8EDiDWNSbRooKAbkHb
oh3bBvDUMmswpZJARCItp2w5gPCFnXWK1Wy8ycwpY80B1L2z3buIQ0Bqf5Kz
PNUPtxjju1ubCEwfa8td5dGPq4HbtPKaCWQK66eM2Pdjwj3yNK+FgPp9dYdX
pv0oNiv3Dm4lMONb3TWdef0YEdeXTnpOwLbTxbehtw/Hz6i63+ghQCgQUwIP
9qHn8JrGjwQBfrn/syshfVi839VgLUVAIsp5QGJ3Hzo2p4s30AQCOcvlF9n0
QV112vUuIYG4kL2Hp6n24U7x2A/xEQI18RatpQ960VvzJn+HOInak0YzitR7
MRif5JIiQSLPdjhPXqkXHzYskaiVJHHj64REumwvfrQlBahOJTFtT2p4+w8R
/uAtWdklQ8JVTXnzElKE9dOOPnZVIvErMXSxbb4Ilu1L444pkzjN3Xi157wI
9n93L61SIVGXnXD+YJoIbnMNMhRmkzjf9GR8OEGEkGU9np0aJNbPbG1P8xUh
d7vhZ+eFJFZXdPcVLBWhUJ0oSdAnsfJ6iKqWngj/CI5tv72IRL7jzd/l80Uo
30c8kF9KguOa7/FdQYTHickn25eTUDH01NX/IcTo/0h1exMS/xZe+cq0CeHy
7YSNlROJhStyQzoihUhodgk460wiM3Ei0XO/EDcz1E52u5CokNWSHQ0SQsbg
ekvQFhJrshlpK28hmn2eWZ3dTmKW8ibTffZCmD5VtOz2ITHPWz//trYQQTnc
PZp7SAQmZMn2agiR4//PsSA/EknZm7R1Zgsx9ntt48ReEsL755i6mUKUr/Yw
1wwh4Xhz9KXvLwH0Coo2BEWTEDNs5biRArjtC9pdGUNiUce0VXO6BEg2Xpk0
EUti1DCC7O8UQPCy8VFaPIkz7VzfnFYB8qcNrK9MYvOToqrhcU8AhXCDPydO
kfD4mT3fJk+ASQvOurRCEsPyh47Y+wjgOTa0o6OIRPanfluxXQJwrs6NVbxM
Ys4yzZ77HgLEyB+uyS0hIdE8W81yqwAfu7Cq9BqJK7Ght7Jt2O8HNS99VEXi
uFa71oZlAjSnd8z/9JiEi7UMaSkhgI65OFa3knh3vlAn/zcfR0ZX7IppI/Ep
oPTx+E8+1rtn5v9qJ/HRaPX3++N81Ghvmy3zksRNP4Xf0SN8XK2mFHS4JGIF
Cu1lBB9nqP4pbh9J/PZvqP98h49LPiWhRz+RkBvPWDhUycftAZ83ZZ9JjCzu
j+4t5+PFF26JzFcSuhU/agU3+VCUe2VR/52tryKlVZMlfOSZPTqyRJLCG7GJ
IE4WH9cuZf8SV6HwuLa7WOMgHxwdN/9lqhSsRsUcAmP4eHpN4ZmnGoV188LM
q6P4GKlOy787h0KC2hnZbRF8rHh+zDR0PoV4fc2syn181E7uP9ijT0FdT0P5
9S4+Hnvbfr1tSoHOb/teYM2H+Hudtq9mFBo4Nt1yVnyYHvpdYLaewsuIFsEh
Cz7Kcmps2zZQmH66JXTPBj6yO3Xz+6woBMQ0fLEz4WOvhbiF+iYKf9sq+R00
5GPqQs65VD8K5u0pw7ZqfGyozvLv8KfQHRph91WFjziLcBPVANb0fL8ryny8
99bvLQmioFZR1iilyEdXzgWj+jAKypIHeih5PkplDjBjsRSkhHWveiT5sH6/
ZKlfGgVbuTVWYwIeVm46b5d1lsI//Z8bCR4P8yt/7m1JZ+czJbL6Ec3Dt6hn
xfoZFNaKXxNkEDzc+BWmOnKBgvvljjG3Th5myVdKRBdRGJ9XNuTQwAN3iTFx
soqCieWH6bzLPDxJKxqrvUPB9VqLgkwxD9UfpJWGqikYm3pqGxXycLaKcHas
ZZ3YbZd9kYeNpvFNs+ooYHNXwP7zPJTaPyzLbaGwPe2c96ETPIQHWZ64QVC4
XXHAfGwfD2nlSle6SApb/Ge2+gXzcH2895E4l41/kv7wOpAH4fHj37czFMru
aihz/HlwvdwSIiWioCIyT8r25mE1Zevq9Y7CsUtWY/muPIw7OmnO/M2u9zOF
KU1mPCie1/jTRIwLz86KRF9THpZRI+7+4lx2Hy5ylzDhISDobOZ9SS5Gcgx0
rY146Dn+YmqgNBfvMvoF9Aoe7j3cPFL/BxdtXQdiHRfycGj5Nk6ELheTDT6B
cxR5aEi0tLy7gAsnp6ovLX/wMPXFyucTelycX+XLRM7i4e/QmcLkRVw8WG/f
9lqezcf1J9OzDdnnO1WflEjz0KFr6n7fmAtZl9ymY5MMdGZrfpN04oJU0ypd
McygTXxoTVYUF6HbfDW/Pmbwr66/dFM0F8Xvb2tPtjDg2PDJzzFcdO25LCbN
+npaV+KmOC7GnoY5zGticGp2Y6tsIhfHI0+KudUzsF+R73U0hYvLwZ1yQ7UM
nux2Pr7/IhcKG6TVbl5n0PKo8rVdAxftyQ3J3ucYDAw5KGX8y0XnvYS8k+kM
pFX6XMlGLsJqx8PLz7Ljhai+Cm7hghuQ5CuVxuC52qHO00+5kBl5v7w6lUFX
uNXzZ2+4eKtd9GjdMQZ9Oj2PNw9xMWNoXeuTaAZTUn5x3BVp7FMISnjlzcAt
Z/L7RSUao9LVXfqsS6/+NmaUaUyx4nMSdjGwaRW/66tGIyAnQnepF4MUmalV
+zRobF89NSTNg4Fc2owbhxfSWB6R4BDkxkApY/7FYlMasn2ugUcd2Pzmb4wf
3EOjruOls8Y6BnpJLyRU/Gm8itr3Is+YwWI/r1Pme2ncPBdwS4318qUHcy8G
0qiK1ktSNmJg9qD8rlMojSxT9RjFNQy2ceePVkTT2KK1wFtzBRuP+mRIXCqN
adB4Hr+Iwft8zi7ZMhqZwdoz9OcymJO613VzOQ3fmkULKuYwsI5SsM2uoGHQ
aJ1pwrrQKXiFzh0aaXfCDjjPZrBpcraU6T0a1qctTeJUGVR6H7wW3EhjptWT
XIEig2ht49HWbhq6xOqIETkGv/5XnZoixuCTXLnF4G8a9wr7urMdGUybU1IT
OESjtjg7VKKQwaLzO4hTXTQufDCn331goDYn0JFqpqG9WOevIPY/WfkCsjtr
aXwKO26/MY0Hixc+YVk3aIQWqdveYPeRmu/mrZrFNHrPdqXbK/AxNDArXiaH
xp2X3vNH2H3RV/Viun06DfLMsfqe3Xykv/xyWCqFhpZj4JTPqXwsnaVfP55E
Y0eFnZED2zc+GI86tcTR6D/THDfSzcfdn7F96VFsfKESvnVi//Vhz8URf9HI
byI8uvQEaJy8RKiH0MhouLVhmaMAhvw4OVN2na43mrdVRwpgpad5ycePhppZ
hP9xtu9enT7RoOpD4+o935KjjWxf9pHa8dKLxtlbI6NPBgUw12tOldxJw88m
aqULey545ZA3HLODhmd/naKksRBuLUdzhtzY8SeKportEmKTbrR+jSuNOSpW
lxafFOLPezfkEjfTiOvq08wqE2Lr1rIZ8S5sHcpr1di+ESKN+KuB40RD2k7j
w6JJIXr1/gr56kDDaKJq3VZdEf5U/GITbE/DzdUm/KGdCJJXZ0xO2rJ1Vn7R
cVuECNXNsplpNjSWJJ9aZ5QjQiA3cLm9NQ31to2efNYfCnJqLVnLzfqekJor
QrbLRnOwHrkY0ETlse/vmnBfzfp2laVL0iURlKIkL85jvUI06dd6WQQVv/e+
X6zYeMwPnNt5SwQHn4ypBaz1UxZXSd0WwXQL8yCHtdpzwZtbrIPvZ0Rmsv7m
vmmuWLkIP8dWvk1hzQk3KC2pZM+R2hb8A6z/LB64P3JXhLgjqxTtWRsMFDAX
akWYiH3Ks2Q9z2Cb+IZ7IsyQaroF1pO1TdYZHBFcRa+d1rCu7yjuXFsnwlaj
wAJN1uUq7qM81q9MxqPmsi7ynKWa+lAEu1GhswrrI28TPKlHIrgXPJeSYx1h
uDYxuV4EtbxngqmsfSNHig0aWPsurBdnvYVT0tTFOuIQVfjTkoa5mOdA4r8i
RO4fTBpn/X94fe/n
          "]], 
         {RGBColor[1, 0, 0], Opacity[1], 
          DiskBox[{0.38250736531986523`, 0.566665}, {0.0034729166666666663`, 0.005556666666666666},
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          CircleBox[{0.38250736531986523`, 0.566665}, {0.0034729166666666663`, 0.005556666666666666},
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{0.38250736531986523`, 0.6555516666666666}, {0.0034729166666666663`, 0.005556666666666666},
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           CircleBox[{0.38250736531986523`, 0.6555516666666666}, {0.0034729166666666663`, 0.005556666666666666},
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
           {RGBColor[1, 0, 0], Opacity[1], 
            DiskBox[{0.38250736531986523`, 0.7444383333333333}, {0.0034729166666666663`, 0.005556666666666666},
              NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
           {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
            CapForm[None], 
            CircleBox[{0.38250736531986523`, 0.7444383333333333}, {0.0034729166666666663`, 0.005556666666666666},
              NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
            {RGBColor[1, 0, 0], Opacity[1], 
             DiskBox[{0.38250736531986523`, 0.8333250000000001}, {0.0034729166666666663`, 0.005556666666666666},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
            {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}],
              CapForm[None], 
             CircleBox[{0.38250736531986523`, 0.8333250000000001}, {0.0034729166666666663`, 0.005556666666666666},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.38250736531986523`, 0.23334}, {0.6221923400673399, 
              0.23334}}]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.6117735900673399, 0.24167500000000003`}, {
              0.6221923400673398, 0.23334000000000002`}, {0.6117735900673399, 
              0.22500500000000004`}}]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.38250736531986523`, 0.08519555555555552}, {
              0.38250736531986523`, 0.3888916666666667}}]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.3772979903198652, 0.3722216666666667}, {
              0.38250736531986523`, 0.3888916666666667}, {
              0.38771674031986525`, 0.3722216666666667}}]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None]}, 
            {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}],
              CapForm[None], LineBox[CompressedData["
1:eJwV2XlcTF0YB/A22ZVEolSKpEREWvSTVNoXFEmbLEUUEYU20WqpKKSFJKWU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              "]]}, 
            {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
             AbsoluteDashing[{4, 2}], CapForm[None], LineBox[CompressedData["
1:eJwV1nc81H8cB3ArSlo0JJFERam0SS9RGYkUIiFJUZFKiUQphZCkIiNE0rKF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              "]]}, 
            {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
             AbsoluteDashing[{2, 1}], CapForm[None], LineBox[CompressedData["
1:eJwV13k8VF8fB3CJFmlDSCpaLKGkTaU+iiJJUlr9RJYskSUpKdojS1EhKpVU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              "]]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.7067870370370369, 0.45555666666666667`}, {
              0.9464720117845116, 0.45555666666666667`}}]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.9360532617845116, 0.4638916666666666}, {
              0.9464720117845116, 0.4555566666666666}, {0.9360532617845116, 
              0.44722166666666663`}}]}, 
            {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.7067870370370369, 0.45555666666666667`}, {
              0.7067870370370369, 0.9044343333333333}}]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.7015776620370369, 0.8877643333333333}, {
              0.7067870370370368, 0.9044343333333332}, {0.7119964120370369, 
              0.8877643333333333}}]}, 
            {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             LineBox[{{0.710850349537037, 0.45555666666666667`}, {
              0.7067870370370369, 0.45555666666666667`}}], 
             LineBox[{{0.710850349537037, 0.5}, {0.7067870370370369, 0.5}}], 
             LineBox[{{0.710850349537037, 0.5444433333333334}, {
              0.7067870370370369, 0.5444433333333334}}], 
             LineBox[{{0.710850349537037, 0.5888866666666667}, {
              0.7067870370370369, 0.5888866666666667}}], 
             LineBox[{{0.710850349537037, 0.63333}, {0.7067870370370369, 
              0.63333}}], 
             LineBox[{{0.710850349537037, 0.6777733333333333}, {
              0.7067870370370369, 0.6777733333333333}}], 
             LineBox[{{0.710850349537037, 0.7222166666666667}, {
              0.7067870370370369, 0.7222166666666667}}], 
             LineBox[{{0.710850349537037, 0.76666}, {0.7067870370370369, 
              0.76666}}], 
             LineBox[{{0.710850349537037, 0.8111033333333333}, {
              0.7067870370370369, 0.8111033333333333}}], 
             LineBox[{{0.710850349537037, 0.8555466666666667}, {
              0.7067870370370369, 0.8555466666666667}}], 
             LineBox[{{0.710850349537037, 0.8999900000000001}, {
              0.7067870370370369, 0.8999900000000001}}]}, 
            {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
             CapForm[None], LineBox[CompressedData["
1:eJw92Hk4Vd3bB3BDogwVlXke0yNFJOJOQhNlfEgkGZJEE9FAA1IayE9ChkKh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              "]]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], LineBox[CompressedData["
1:eJwV1Xk41dkfB3Bpr/lVRGYs2YZrCUnGentnmdI2ylgjFWFQiV/MzfqjLGXS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              "]]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[
              NCache[{3, 
                Rational[3, 2]}, {3, 1.5}]], CapForm[None], 
             LineBox[CompressedData["
1:eJwV1nk4ldsXB3BkajI1CIkypXRDNIkvuWnShBTKVMJNJSFpwM1wRXU1iChD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              "]], 
             {RGBColor[1, 0, 0], Opacity[1], 
              DiskBox[{0.7067870370370369, 0.6111083333333334}, {0.0034729166666666663`, 0.005556666666666666},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
             {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
              Dashing[{}], CapForm[None], 
              CircleBox[{0.7067870370370369, 0.6111083333333334}, {0.0034729166666666663`, 0.005556666666666666},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
              {RGBColor[1, 0, 0], Opacity[1], 
               DiskBox[{0.7067870370370369, 0.699995}, {0.0034729166666666663`, 0.005556666666666666},
                 NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
              {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
               Dashing[{}], CapForm[None], 
               CircleBox[{0.7067870370370369, 0.699995}, {0.0034729166666666663`, 0.005556666666666666},
                 NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
               {RGBColor[1, 0, 0], Opacity[1], 
                DiskBox[{0.7067870370370369, 0.7888816666666667}, {0.0034729166666666663`, 0.005556666666666666},
                  NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
               {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
                Dashing[{}], CapForm[None], 
                CircleBox[{0.7067870370370369, 0.7888816666666667}, {0.0034729166666666663`, 0.005556666666666666},
                  NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                {RGBColor[1, 0, 0], Opacity[1], 
                 DiskBox[{0.7067870370370369, 0.8777683333333333}, {0.0034729166666666663`, 0.005556666666666666},
                   NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
                 Dashing[{}], CapForm[None], 
                 CircleBox[{0.7067870370370369, 0.8777683333333333}, {0.0034729166666666663`, 0.005556666666666666},
                   NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                 CapForm[None], 
                 LineBox[{{0.7067870370370369, 0.23334}, {0.9464720117845116, 
                  0.23334}}]}, 
                {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                 CapForm[None], 
                 LineBox[{{0.9360532617845116, 0.24167500000000003`}, {
                  0.9464720117845116, 0.23334000000000002`}, {
                  0.9360532617845116, 0.22500500000000004`}}]}, 
                {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                 CapForm[None]}, 
                {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                 CapForm[None], 
                 LineBox[{{0.7067870370370369, 0.08519555555555552}, {
                  0.7067870370370369, 0.3888916666666667}}]}, 
                {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                 CapForm[None], 
                 LineBox[{{0.7015776620370369, 0.3722216666666667}, {
                  0.7067870370370368, 0.3888916666666667}, {
                  0.7119964120370369, 0.3722216666666667}}]}, 
                {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                 CapForm[None]}, 
                {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
                 Dashing[{}], CapForm[None], LineBox[CompressedData["
1:eJwV2Xk4VF0YAHBbEkpJiuzZSYiE6qVEi3Y7WaMIpSRbok1atFGWlJ3sldBi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                  "]]}, 
                {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
                 AbsoluteDashing[{4, 2}], CapForm[None], 
                 LineBox[CompressedData["
1:eJwV13k4VN8bAHCkTVmylCJLQqKUUiG9X5QQKoRSFFlLJISUZC+VVAgh2bJE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                  "]]}, 
                {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], 
                 AbsoluteDashing[{2, 1}], CapForm[None], 
                 LineBox[CompressedData["
1:eJwV13k4lF8bB3CkEsm+lSJlX0qppPy+oSQlJclStkKkRKiohAqlhRRFlkhl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                  "]], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{"\"\[ScriptL]\"","\"=\"","0"},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->15,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.17572032828282827`, 0.9444333333333333}, {0, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"r\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   
                   DisplayForm], \
{0.27394417087542083`, 0.43583049999999995`}, {0, 0}, Automatic, {1, 0}], 
                 InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{TagBox[
                    StyleBox["V", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\"(\"",TagBox[
                    StyleBox["\"r\"", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\")\""},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3, "\[InvisibleSpace]", #4}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   
                   DisplayForm], {0.052150089436026933`, 0.8595465666666665}, \
{1, 0}, Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"r\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.27394417087542083`, 0.2136138333333334}, {0, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{TagBox[
                    StyleBox["u", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\"(\"",TagBox[
                    StyleBox["\"r\"", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\")\""},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3, "\[InvisibleSpace]", #4}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   
                   DisplayForm], \
{0.052150089436026933`, 0.35852205555555555`}, {1, 0}, Automatic, {1, 0}], 
                 InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{"\"\[ScriptL]\"","\"=\"","1"},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->15,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.4999999999999999, 0.9444333333333333}, {0, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"r\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.5982238425925924, 0.43583049999999995`}, {0, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{TagBox[
                    StyleBox["V", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\"(\"",TagBox[
                    StyleBox["\"r\"", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\")\""},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3, "\[InvisibleSpace]", #4}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.3764297611531986, 0.8595465666666665}, {1, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"r\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.5982238425925924, 0.2136138333333334}, {0, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{TagBox[
                    StyleBox["u", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\"(\"",TagBox[
                    StyleBox["\"r\"", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\")\""},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3, "\[InvisibleSpace]", #4}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.3764297611531986, 0.35852205555555555`}, {1, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{"\"\[ScriptL]\"","\"=\"","2"},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->15,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.8242796717171716, 0.9444333333333333}, {0, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"r\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.9225035143097641, 0.43583049999999995`}, {0, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{TagBox[
                    StyleBox["V", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\"(\"",TagBox[
                    StyleBox["\"r\"", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\")\""},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3, "\[InvisibleSpace]", #4}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.7007094328703701, 0.8595465666666665}, {1, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"r\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.9225035143097641, 0.2136138333333334}, {0, 0},
                   Automatic, {1, 0}], InsetBox[
                  TagBox[
                   StyleBox[
                    TagBox[
                    TemplateBox[{TagBox[
                    StyleBox["u", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\"(\"",TagBox[
                    StyleBox["\"r\"", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\")\""},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3, "\[InvisibleSpace]", #4}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], "]"}]& )],
                    DisplayForm],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                   DisplayForm], {0.7007094328703701, 0.35852205555555555`}, {1, 0},
                   Automatic, {1, 0}]}}}}}}}}}}}}}}},
  AspectRatio->NCache[
    Rational[5, 8], 0.625],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{576, 360},
  PlotRange->{{-0.0001, 1.0001}, {-0.0001, 1.0001}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.4921232349375*^9, 3.49212327721875*^9}, 
   3.49212331765625*^9, 3.4921233485*^9, 3.492123493109375*^9, {
   3.49212356134375*^9, 3.4921236366875*^9}, 3.49212368815625*^9, {
   3.492125152546875*^9, 3.4921251658125*^9}, 3.499022510578125*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Attaching text labels to plots -- Woods-Saxon wave functions", "Section",
 CellChangeTimes->{{3.499032716421875*^9, 3.499032727734375*^9}}],

Cell["\<\
In this example, we use LevelScheme to control the appearance of the plot \
line, by feeding the output of Plot to SchemeLine, which takes the plot's \
curve, extracts the coordinates of its points, and (re)draws the curve \
following these points, but using SchemeLine's formatting options.\
\>", "Text",
 CellChangeTimes->{{3.499022408515625*^9, 3.499022501*^9}, {
  3.499032886046875*^9, 3.499032945375*^9}}],

Cell["Set up some automated label formatting functions", "Text",
 CellChangeTimes->{{3.49903279484375*^9, 3.499032801734375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "0", "]"}], "=", "\"\<s\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "1", "]"}], "=", "\"\<p\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "2", "]"}], "=", "\"\<d\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "3", "]"}], "=", "\"\<f\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "4", "]"}], "=", "\"\<g\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "5", "]"}], "=", "\"\<h\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "6", "]"}], "=", "\"\<i\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "7", "]"}], "=", "\"\<j\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpectroscopicLetter", "[", "8", "]"}], "=", "\"\<k\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ShellLabel", "[", 
    RowBox[{"{", 
     RowBox[{"n_", ",", "l_", ",", "j_"}], "}"}], "]"}], ":=", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"Subscript", "[", 
       RowBox[{
        RowBox[{"SpectroscopicLetter", "[", "l", "]"}], ",", 
        RowBox[{"SolidusFractionize", "[", "j", "]"}]}], "]"}]}], "}"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.49226469321875*^9, 3.492264755703125*^9}, 
   3.499032848578125*^9}],

Cell["Define wave functions", "Text",
 CellChangeTimes->{{3.499032854328125*^9, 3.499032858109375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"b_", ",", "n_", ",", "l_", ",", "r_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"Factorial", "[", "n", "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "3"}], "*", 
         RowBox[{"Gamma", "[", 
          RowBox[{"n", "+", "l", "+", 
           RowBox[{"3", "/", "2"}]}], "]"}]}], ")"}]}]}], "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"r", "/", "b"}], ")"}], "^", "l"}], "*", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"r", "^", "2"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}], "]"}], "*", 
    RowBox[{"LaguerreL", "[", 
     RowBox[{"n", ",", 
      RowBox[{"l", "+", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "/", "b"}], ")"}], "^", "2"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.499033007703125*^9, 3.4990330079375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"b40", "=", "1.94"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R0s1", "[", "r_", "]"}], ":=", 
   RowBox[{
    RowBox[{"0.995", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "0", ",", "0", ",", "r"}], "]"}]}], "-", 
    RowBox[{"0.087", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "1", ",", "0", ",", "r"}], "]"}]}], "-", 
    RowBox[{"0.034", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "2", ",", "0", ",", "r"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R0p3", "[", "r_", "]"}], ":=", 
   RowBox[{
    RowBox[{"0.998", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "0", ",", "1", ",", "r"}], "]"}]}], "-", 
    RowBox[{"0.044", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "1", ",", "1", ",", "r"}], "]"}]}], "-", 
    RowBox[{"0.026", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "2", ",", "1", ",", "r"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R0p1", "[", "r_", "]"}], ":=", 
   RowBox[{
    RowBox[{"0.999", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "0", ",", "1", ",", "r"}], "]"}]}], "-", 
    RowBox[{"0.002", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "1", ",", "1", ",", "r"}], "]"}]}], "-", 
    RowBox[{"0.009", "*", 
     RowBox[{"g", "[", 
      RowBox[{"b40", ",", "2", ",", "1", ",", "r"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R0s1HO", "[", "r_", "]"}], ":=", 
   RowBox[{"g", "[", 
    RowBox[{"b40", ",", "0", ",", "0", ",", "r"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R0p3HO", "[", "r_", "]"}], ":=", 
   RowBox[{"g", "[", 
    RowBox[{"b40", ",", "0", ",", "1", ",", "r"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R0p1HO", "[", "r_", "]"}], ":=", 
   RowBox[{"g", "[", 
    RowBox[{"b40", ",", "0", ",", "1", ",", "r"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.49228897271875*^9, 3.4922891151875*^9}, {
  3.492289643015625*^9, 3.49228966546875*^9}}],

Cell["Generate figure", "Text",
 CellChangeTimes->{{3.49903286125*^9, 3.499032862890625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeLine", ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeLine", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"R0s1", "[", "r", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabB", "\[Rule]", 
        RowBox[{"ShellLabel", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], "]"}]}], ",", 
       RowBox[{"PosnB", "\[Rule]", "0.25"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeLine", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"R0p3", "[", "r", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabB", "\[Rule]", 
        RowBox[{"ShellLabel", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", 
           RowBox[{"3", "/", "2"}]}], "}"}], "]"}]}], ",", 
       RowBox[{"PosnB", "\[Rule]", "0.25"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeLine", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"R0p1", "[", "r", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabT", "\[Rule]", 
        RowBox[{"ShellLabel", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], "]"}]}], ",", 
       RowBox[{"PosnT", "\[Rule]", "0.25"}], ",", 
       RowBox[{"NudgeT", "\[Rule]", "2"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeLine", ",", 
       RowBox[{"Dashing", "\[Rule]", "3"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeLine", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"R0s1HO", "[", "r", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeLine", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"R0p3HO", "[", "r", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], ","}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.6"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"6", ",", "4"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"LabB", "\[Rule]", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"textit", "[", "\"\<r\>\"", "]"}], ",", "\"\< (fm)\>\""}], 
      "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"LabL", "\[Rule]", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"textit", "[", "\"\<R\>\"", "]"}], ",", "\"\<(\>\"", ",", 
       RowBox[{"textit", "[", "\"\<r\>\"", "]"}], ",", "\"\<)\>\""}], "}"}], 
     "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"FontSize", "\[Rule]", "15"}], ",", 
   RowBox[{"TickFontSize", "\[Rule]", "12"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.40243520075*^9, 3.40243524146875*^9}, {
   3.402435289734375*^9, 3.402435537453125*^9}, {3.402435570578125*^9, 
   3.402435759390625*^9}, {3.40243588296875*^9, 3.40243591275*^9}, {
   3.40829301315625*^9, 3.40829302334375*^9}, {3.4922891346875*^9, 
   3.49228921690625*^9}, {3.492289314296875*^9, 3.492289561734375*^9}, {
   3.49228959565625*^9, 3.49228962503125*^9}, {3.4922899125*^9, 
   3.492290116265625*^9}, 3.49903275740625*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[CompressedData["
1:eJwV1Hk41WkbB3BblijL762oLI3sWpSmVNwPUkPqLdE6UzF06ERliJAihTCW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     "]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[CompressedData["
1:eJwV1nc81d8fB/DPvVZGGbe+lEIoJSUtmu8jIyMio4ySTVYZDavQN1kRWdmh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     "]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[CompressedData["
1:eJwV1nk8VdsXAPBzL3mUCrc8lZkikVSUprVLEyIZKmkiZChDmTJlCO8ZQgpl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     "]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[
     NCache[{3, 
       Rational[3, 2]}, {3, 1.5}]], CapForm[None], LineBox[CompressedData["
1:eJwV1Hk81NsbB3BbSpbiexMpW4uLUv20F8+5TSprIVe0iMaWVuUqRAtJhNEw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     "]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[
     NCache[{3, 
       Rational[3, 2]}, {3, 1.5}]], CapForm[None], LineBox[CompressedData["
1:eJwV1nk0VP8bB/AZW6JiDKXFFt8USipbi+cjpWQthMK3EWXNlhJSUclOZAlJ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     "]], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"0",SubscriptBox["\"s\"", 
           GridBox[{{
              TagBox["1", DisplayForm], "/", 
              TagBox["2", DisplayForm]}}, 
            BaselinePosition -> {Baseline, {1, 3}}, 
            GridBoxSpacings -> {"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[-0.06999999999999999]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]]},
         "Row",
         DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
         InterpretationFunction->(RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], "]"}]& )],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.2908539913935027`, 0.3805125169220574}, {0, 0}, 
     Automatic, {0.8642457939572388, -0.5030697840530893}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"0",SubscriptBox["\"p\"", 
           GridBox[{{
              TagBox["3", DisplayForm], "/", 
              TagBox["2", DisplayForm]}}, 
            BaselinePosition -> {Baseline, {1, 3}}, 
            GridBoxSpacings -> {"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[-0.06999999999999999]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]]},
         "Row",
         DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
         InterpretationFunction->(RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], "]"}]& )],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.0753545032633245`, 0.17161961714621013`}, {0, 0}, 
     Automatic, {0.7781782782866417, 0.6280434437225167}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{"0",SubscriptBox["\"p\"", 
           GridBox[{{
              TagBox["1", DisplayForm], "/", 
              TagBox["2", DisplayForm]}}, 
            BaselinePosition -> {Baseline, {1, 3}}, 
            GridBoxSpacings -> {"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[-0.06999999999999999]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]]},
         "Row",
         DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
         InterpretationFunction->(RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], "]"}]& )],
        DisplayForm],
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.9158224448454658, 0.21473424285226417`}, {0, 0}, 
     Automatic, {0.7604722599233651, 0.6493704196273878}]}},
  AspectRatio->NCache[
    Rational[2, 3], 0.6666666666666666],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
     TagBox[
      TagBox[
       StyleBox[
        TemplateBox[{
          TagBox[
           StyleBox["\"r\"", FontSlant -> "Italic"], 
           StyleForm[#, FontSlant -> "Italic"]& ], "\" (fm)\""}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[InvisibleSpace]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], "]"}]& )], FontFamily -> "Times", 
        FontSize -> 15, FontSlant -> "Plain", FontTracking -> "Plain", 
        FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 1, 
        ShowAutoStyles -> False, SingleLetterItalics -> False], 
       StyleForm[#, FontFamily -> "Times", FontSize -> 15, FontSlant -> 
        "Plain", FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
        GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False, 
        SingleLetterItalics -> False]& ], DisplayForm], TraditionalForm], 
    FormBox[
     TagBox[
      TagBox[
       StyleBox[
        TemplateBox[{
          TagBox[
           StyleBox["\"R\"", FontSlant -> "Italic"], 
           StyleForm[#, FontSlant -> "Italic"]& ], "\"(\"", 
          TagBox[
           StyleBox["\"r\"", FontSlant -> "Italic"], 
           StyleForm[#, FontSlant -> "Italic"]& ], "\")\""}, "Row", 
         DisplayFunction -> (
          RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
            "\[InvisibleSpace]", #4}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], "]"}]& )], 
        FontFamily -> "Times", FontSize -> 15, FontSlant -> "Plain", 
        FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
        GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False, 
        SingleLetterItalics -> False], 
       StyleForm[#, FontFamily -> "Times", FontSize -> 15, FontSlant -> 
        "Plain", FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
        GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False, 
        SingleLetterItalics -> False]& ], DisplayForm], TraditionalForm], 
    None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->Automatic,
  ImageSize->{432, 288},
  PlotRange->{{-0.0005, 5.0005}, {-0.00006, 0.6000599999999999}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.49229001078125*^9, 3.492290117375*^9}, 
   3.49903296603125*^9, 3.499033012*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Contour plot superposed on chart, using online isotope data -- Chart of \
nuclides\
\>", "Section",
 CellChangeTimes->{{3.491258598296875*^9, 3.49125862234375*^9}, {
  3.492124979765625*^9, 3.492125010921875*^9}}],

Cell["\<\
This provides an example of constructing a table automatically.\
\>", "Text",
 CellChangeTimes->{{3.49125862540625*^9, 3.491258635234375*^9}}],

Cell[TextData[{
 "Labels and shading of stable isotopes are produced automatically from data \
provided by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["IsotopeData",
  FontFamily->"Courier New"],
 " function.\nRequires network connection for access to Wolfram data."
}], "Text",
 CellChangeTimes->{{3.395521901375*^9, 3.39552193546875*^9}, {
  3.39758610159375*^9, 3.39758610696875*^9}, {3.397586251609375*^9, 
  3.397586251765625*^9}, {3.4710898836875*^9, 3.47108989640625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "some", " ", "functions", " ", "useful", " ", "for", " ", 
    "labeling", " ", "the", " ", "chart", " ", "of", " ", "the", " ", 
    "nuclides"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"IsStable", "[", 
      RowBox[{"N_", ",", "Z_"}], "]"}], ":=", 
     RowBox[{"IsotopeData", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Z", ",", 
         RowBox[{"N", "+", "Z"}]}], "}"}], ",", "\"\<Stable\>\""}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ChemicalSymbol", "[", 
       RowBox[{"N_", ",", "Z_"}], "]"}], ":=", 
      RowBox[{"IsotopeData", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Z", ",", 
          RowBox[{"N", "+", "Z"}]}], "}"}], ",", "\"\<Symbol\>\""}], "]"}]}], 
     ";"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Make", " ", "the", " ", "contour", " ", "plot"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"The", " ", "option", " ", "DisplayFunction"}], "\[Rule]", 
     RowBox[{
     "Identity", " ", "prevents", " ", "it", " ", "from", " ", "actually", 
      " ", "displaying", " ", 
      RowBox[{"here", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PFactor8250", "[", 
      RowBox[{"N_", ",", "Z_"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Np", ",", "Nn"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Nn", "=", 
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"N", "-", "82"}], ",", 
           RowBox[{"126", "-", "N"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Np", "=", 
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"Z", "-", "50"}], ",", 
           RowBox[{"82", "-", "Z"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Np", "*", 
         RowBox[{"Nn", "/", 
          RowBox[{"(", 
           RowBox[{"Np", "+", "Nn"}], ")"}]}]}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"ZMin", "=", "58"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"ZMax", "=", "72"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"NMin", "=", "84"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"NMax", "=", "96"}], ";"}], "\n", 
   RowBox[{"Figure", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "use", " ", "variable", " ", "name", " ", "\"\<NValue\>\"", " ", 
         "instead", " ", "of", " ", "\"\<N\>\""}], ",", " ", 
        RowBox[{
        "since", " ", "N", " ", "is", " ", "already", " ", "used", " ", "as", 
         " ", "a", " ", "Mathematica", " ", "function", " ", "name"}], ",", 
        " ", 
        RowBox[{
        "and", " ", "ContourPlot", " ", "therefore", " ", "produces", " ", 
         "an", " ", "error", " ", "message"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ExampleChartPlot", "=", 
         RowBox[{"ContourPlot", "[", 
          RowBox[{
           RowBox[{"PFactor8250", "[", 
            RowBox[{"NValue", ",", "ZValue"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"NValue", ",", 
             RowBox[{"NMin", "-", "1"}], ",", 
             RowBox[{"NMax", "+", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"ZValue", ",", 
             RowBox[{"ZMin", "-", "1"}], ",", 
             RowBox[{"ZMax", "+", "1"}]}], "}"}], ",", 
           RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
           RowBox[{"ContourShading", "\[Rule]", "False"}], ",", 
           RowBox[{"Contours", "\[Rule]", 
            RowBox[{"Range", "[", 
             RowBox[{"3", ",", "7"}], "]"}]}], ",", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"{", "BurntSienna", "}"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
           RowBox[{
           "draw", " ", "contour", " ", "line", " ", "in", " ", "layer", " ", 
            "\"\<1.5\>\"", " ", "to", " ", "go", " ", "in", " ", "front", " ",
             "of", " ", "boxes", " ", "but", " ", "behind", " ", "layer", " ",
             "white"}], "-", 
           RowBox[{"out", " ", "boxes"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
          "but", " ", "with", " ", "opacity", " ", "0.5", " ", "so", " ", 
           "boxes", " ", "show", " ", "through"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"RawGraphics", "[", "\[IndentingNewLine]", 
         RowBox[{"ExampleChartPlot", ",", " ", 
          RowBox[{"Color", "\[Rule]", "BurntSienna"}], ",", " ", 
          RowBox[{"Layer", "\[Rule]", "1.5"}], ",", 
          RowBox[{"Thickness", "\[Rule]", "3"}], ",", 
          RowBox[{"Opacity", "\[Rule]", "0.5"}]}], "\[IndentingNewLine]", 
         "]"}]}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SchemeBox", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"NValue", "-", "1"}], ",", 
               RowBox[{"NValue", "+", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ZValue", "-", "1"}], ",", 
               RowBox[{"ZValue", "+", "1"}]}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"LabC", "->", 
            RowBox[{"ChemicalSymbol", "[", 
             RowBox[{"NValue", ",", "ZValue"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"FillColor", "\[Rule]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"IsStable", "[", 
               RowBox[{"NValue", ",", "ZValue"}], "]"}], ",", "Gray", ",", 
              "LightBeige"}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"BackgroundC", "\[Rule]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"IsStable", "[", 
               RowBox[{"NValue", ",", "ZValue"}], "]"}], ",", "Gray", ",", 
              "LightBeige"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"ZValue", ",", "ZMin", ",", "ZMax", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"NValue", ",", "NMin", ",", "NMax", ",", "2"}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"NMin", "-", "1"}], ",", 
          RowBox[{"NMax", "+", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ZMin", "-", "1"}], ",", 
          RowBox[{"ZMax", "+", "1"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"72", "*", 
       RowBox[{"{", 
        RowBox[{"6", ",", "4"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabB", "\[Rule]", 
      RowBox[{"textit", "[", "\"\<N\>\"", "]"}]}], ",", 
     RowBox[{"LabL", "\[Rule]", 
      RowBox[{"textit", "[", "\"\<Z\>\"", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"LinTicks", "[", 
         RowBox[{"NMin", ",", "NMax", ",", "2", ",", "1"}], "]"}], ",", 
        RowBox[{"LinTicks", "[", 
         RowBox[{"ZMin", ",", "ZMax", ",", "2", ",", "1"}], "]"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.3955211441875*^9, 3.39552114503125*^9}, {
  3.395521863171875*^9, 3.395521889140625*^9}, {3.395521954109375*^9, 
  3.395521999171875*^9}, {3.395522347671875*^9, 3.39552236221875*^9}, {
  3.395522399015625*^9, 3.395522522046875*^9}, {3.395522700875*^9, 
  3.395522723203125*^9}, {3.395524165796875*^9, 3.39552421321875*^9}, {
  3.396880514765625*^9, 3.39688061846875*^9}, {3.397586081*^9, 
  3.397586126890625*^9}, {3.397586157*^9, 3.39758618046875*^9}, {
  3.397586308078125*^9, 3.397586315625*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.5], Opacity[1], 
    PolygonBox[{{83., 57.}, {83., 59.}, {85., 59.}, {85., 57.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
    LineBox[{{83., 57.}, {83., 59.}, {85., 59.}, {85., 57.}, {83., 57.}}], 
    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
     PolygonBox[{{85., 57.}, {85., 59.}, {87., 59.}, {87., 57.}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
     LineBox[{{85., 57.}, {85., 59.}, {87., 59.}, {87., 57.}, {85., 57.}}], 
     {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
      PolygonBox[{{87., 57.}, {87., 59.}, {89., 59.}, {89., 57.}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      LineBox[{{87., 57.}, {87., 59.}, {89., 59.}, {89., 57.}, {87., 57.}}], 
      {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
       PolygonBox[{{89., 57.}, {89., 59.}, {91., 59.}, {91., 57.}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       LineBox[{{89., 57.}, {89., 59.}, {91., 59.}, {91., 57.}, {89., 57.}}], 
       {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
        PolygonBox[{{91., 57.}, {91., 59.}, {93., 59.}, {93., 57.}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
        LineBox[{{91., 57.}, {91., 59.}, {93., 59.}, {93., 57.}, {91., 57.}}], 
        {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
         PolygonBox[{{93., 57.}, {93., 59.}, {95., 59.}, {95., 57.}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
         LineBox[{{93., 57.}, {93., 59.}, {95., 59.}, {95., 57.}, {93., 
          57.}}], 
         {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
          PolygonBox[{{95., 57.}, {95., 59.}, {97., 59.}, {97., 57.}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          LineBox[{{95., 57.}, {95., 59.}, {97., 59.}, {97., 57.}, {95., 
           57.}}], 
          {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
           PolygonBox[{{83., 59.}, {83., 61.}, {85., 61.}, {85., 59.}}]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           LineBox[{{83., 59.}, {83., 61.}, {85., 61.}, {85., 59.}, {83., 
            59.}}], 
           {GrayLevel[0.5], Opacity[1], 
            PolygonBox[{{85., 59.}, {85., 61.}, {87., 61.}, {87., 59.}}]}, 
           {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
            LineBox[{{85., 59.}, {85., 61.}, {87., 61.}, {87., 59.}, {85., 
             59.}}], 
            {GrayLevel[0.5], Opacity[1], 
             PolygonBox[{{87., 59.}, {87., 61.}, {89., 61.}, {89., 59.}}]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             LineBox[{{87., 59.}, {87., 61.}, {89., 61.}, {89., 59.}, {87., 
              59.}}], 
             {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
              PolygonBox[{{89., 59.}, {89., 61.}, {91., 61.}, {91., 59.}}]}, 
             {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
              LineBox[{{89., 59.}, {89., 61.}, {91., 61.}, {91., 59.}, {89., 
               59.}}], 
              {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
               PolygonBox[{{91., 59.}, {91., 61.}, {93., 61.}, {93., 59.}}]}, 
              {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
               LineBox[{{91., 59.}, {91., 61.}, {93., 61.}, {93., 59.}, {91., 
                59.}}], 
               {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                PolygonBox[{{93., 59.}, {93., 61.}, {95., 61.}, {95., 59.}}]}, 
               {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                LineBox[{{93., 59.}, {93., 61.}, {95., 61.}, {95., 59.}, {93.,
                  59.}}], 
                {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                 PolygonBox[{{95., 59.}, {95., 61.}, {97., 61.}, {97., 
                  59.}}]}, 
                {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                 LineBox[{{95., 59.}, {95., 61.}, {97., 61.}, {97., 59.}, {
                  95., 59.}}], 
                 {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                  PolygonBox[{{83., 61.}, {83., 63.}, {85., 63.}, {85., 
                   61.}}]}, 
                 {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}],
                   LineBox[{{83., 61.}, {83., 63.}, {85., 63.}, {85., 61.}, {
                   83., 61.}}], 
                  {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                   PolygonBox[{{85., 61.}, {85., 63.}, {87., 63.}, {87., 
                    61.}}]}, 
                  {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                   Dashing[{}], 
                   LineBox[{{85., 61.}, {85., 63.}, {87., 63.}, {87., 61.}, {
                    85., 61.}}], 
                   {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{87., 61.}, {87., 63.}, {89., 63.}, {89., 
                    61.}}]}, 
                   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{87., 61.}, {87., 63.}, {89., 63.}, {89., 61.}, {
                    87., 61.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{89., 61.}, {89., 63.}, {91., 63.}, {91., 
                    61.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{89., 61.}, {89., 63.}, {91., 63.}, {91., 61.}, {
                    89., 61.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{91., 61.}, {91., 63.}, {93., 63.}, {93., 
                    61.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{91., 61.}, {91., 63.}, {93., 63.}, {93., 61.}, {
                    91., 61.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{93., 61.}, {93., 63.}, {95., 63.}, {95., 
                    61.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{93., 61.}, {93., 63.}, {95., 63.}, {95., 61.}, {
                    93., 61.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{95., 61.}, {95., 63.}, {97., 63.}, {97., 
                    61.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{95., 61.}, {95., 63.}, {97., 63.}, {97., 61.}, {
                    95., 61.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{83., 63.}, {83., 65.}, {85., 65.}, {85., 
                    63.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{83., 63.}, {83., 65.}, {85., 65.}, {85., 63.}, {
                    83., 63.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{85., 63.}, {85., 65.}, {87., 65.}, {87., 
                    63.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{85., 63.}, {85., 65.}, {87., 65.}, {87., 63.}, {
                    85., 63.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{87., 63.}, {87., 65.}, {89., 65.}, {89., 
                    63.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{87., 63.}, {87., 65.}, {89., 65.}, {89., 63.}, {
                    87., 63.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{89., 63.}, {89., 65.}, {91., 65.}, {91., 
                    63.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{89., 63.}, {89., 65.}, {91., 65.}, {91., 63.}, {
                    89., 63.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{91., 63.}, {91., 65.}, {93., 65.}, {93., 
                    63.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{91., 63.}, {91., 65.}, {93., 65.}, {93., 63.}, {
                    91., 63.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{93., 63.}, {93., 65.}, {95., 65.}, {95., 
                    63.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{93., 63.}, {93., 65.}, {95., 65.}, {95., 63.}, {
                    93., 63.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{95., 63.}, {95., 65.}, {97., 65.}, {97., 
                    63.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{95., 63.}, {95., 65.}, {97., 65.}, {97., 63.}, {
                    95., 63.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{83., 65.}, {83., 67.}, {85., 67.}, {85., 
                    65.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{83., 65.}, {83., 67.}, {85., 67.}, {85., 65.}, {
                    83., 65.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{85., 65.}, {85., 67.}, {87., 67.}, {87., 
                    65.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], 
                    LineBox[{{85., 65.}, {85., 67.}, {87., 67.}, {87., 65.}, {
                    85., 65.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{87., 65.}, {87., 67.}, {89., 67.}, {89., 
                    65.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{87., 65.}, {87., 67.}, {89., 
                    67.}, {89., 65.}, {87., 65.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{89., 65.}, {89., 67.}, {91., 67.}, {91., 
                    65.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{89., 65.}, {89., 67.}, {91., 
                    67.}, {91., 65.}, {89., 65.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{91., 65.}, {91., 67.}, {93., 67.}, {93., 
                    65.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{91., 65.}, {91., 67.}, {93., 
                    67.}, {93., 65.}, {91., 65.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{93., 65.}, {93., 67.}, {95., 67.}, {95., 
                    65.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{93., 65.}, {93., 67.}, {95., 
                    67.}, {95., 65.}, {93., 65.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{95., 65.}, {95., 67.}, {97., 67.}, {97., 
                    65.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{95., 65.}, {95., 67.}, {97., 
                    67.}, {97., 65.}, {95., 65.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{83., 67.}, {83., 69.}, {85., 69.}, {85., 
                    67.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{83., 67.}, {83., 69.}, {85., 
                    69.}, {85., 67.}, {83., 67.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{85., 67.}, {85., 69.}, {87., 69.}, {87., 
                    67.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{85., 67.}, {85., 69.}, {87., 
                    69.}, {87., 67.}, {85., 67.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{87., 67.}, {87., 69.}, {89., 69.}, {89., 
                    67.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{87., 67.}, {87., 69.}, {89., 
                    69.}, {89., 67.}, {87., 67.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{89., 67.}, {89., 69.}, {91., 69.}, {91., 
                    67.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{89., 67.}, {89., 69.}, {91., 
                    69.}, {91., 67.}, {89., 67.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{91., 67.}, {91., 69.}, {93., 69.}, {93., 
                    67.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{91., 67.}, {91., 69.}, {93., 
                    69.}, {93., 67.}, {91., 67.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{93., 67.}, {93., 69.}, {95., 69.}, {95., 
                    67.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{93., 67.}, {93., 69.}, {95., 
                    69.}, {95., 67.}, {93., 67.}}], 
                    {GrayLevel[0.5], Opacity[1], 
                    PolygonBox[{{95., 67.}, {95., 69.}, {97., 69.}, {97., 
                    67.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{95., 67.}, {95., 69.}, {97., 
                    69.}, {97., 67.}, {95., 67.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{83., 69.}, {83., 71.}, {85., 71.}, {85., 
                    69.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{83., 69.}, {83., 71.}, {85., 
                    71.}, {85., 69.}, {83., 69.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{85., 69.}, {85., 71.}, {87., 71.}, {87., 
                    69.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{85., 69.}, {85., 71.}, {87., 
                    71.}, {87., 69.}, {85., 69.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{87., 69.}, {87., 71.}, {89., 71.}, {89., 
                    69.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{87., 69.}, {87., 71.}, {89., 
                    71.}, {89., 69.}, {87., 69.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{89., 69.}, {89., 71.}, {91., 71.}, {91., 
                    69.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{89., 69.}, {89., 71.}, {91., 
                    71.}, {91., 69.}, {89., 69.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{91., 69.}, {91., 71.}, {93., 71.}, {93., 
                    69.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{91., 69.}, {91., 71.}, {93., 
                    71.}, {93., 69.}, {91., 69.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{93., 69.}, {93., 71.}, {95., 71.}, {95., 
                    69.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{93., 69.}, {93., 71.}, {95., 
                    71.}, {95., 69.}, {93., 69.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{95., 69.}, {95., 71.}, {97., 71.}, {97., 
                    69.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{95., 69.}, {95., 71.}, {97., 
                    71.}, {97., 69.}, {95., 69.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{83., 71.}, {83., 73.}, {85., 73.}, {85., 
                    71.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{83., 71.}, {83., 73.}, {85., 
                    73.}, {85., 71.}, {83., 71.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{85., 71.}, {85., 73.}, {87., 73.}, {87., 
                    71.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{85., 71.}, {85., 73.}, {87., 
                    73.}, {87., 71.}, {85., 71.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{87., 71.}, {87., 73.}, {89., 73.}, {89., 
                    71.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{87., 71.}, {87., 73.}, {89., 
                    73.}, {89., 71.}, {87., 71.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{89., 71.}, {89., 73.}, {91., 73.}, {91., 
                    71.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{89., 71.}, {89., 73.}, {91., 
                    73.}, {91., 71.}, {89., 71.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{91., 71.}, {91., 73.}, {93., 73.}, {93., 
                    71.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{91., 71.}, {91., 73.}, {93., 
                    73.}, {93., 71.}, {91., 71.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{93., 71.}, {93., 73.}, {95., 73.}, {95., 
                    71.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{93., 71.}, {93., 73.}, {95., 
                    73.}, {95., 71.}, {93., 71.}}], 
                    {RGBColor[0.960799, 0.960799, 0.862697], Opacity[1], 
                    PolygonBox[{{95., 71.}, {95., 73.}, {97., 73.}, {97., 
                    71.}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], LineBox[{{95., 71.}, {95., 73.}, {97., 
                    73.}, {97., 71.}, {95., 71.}}]}, 
                    {RGBColor[0.539994, 0.209998, 0.059999], 
                    AbsoluteThickness[3], Opacity[0.5], Dashing[{}], 
                    GraphicsComplexBox[CompressedData["
1:eJxc23/Mtw1dl/EnkoGOkhgMKQxZaIrYJJShID1LSYaAyFCMNB2REjEBR4RF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                    "], {{{}, {}, {}, {}, {}, {}}, {{}, 
                    {RGBColor[0.539994, 0.209998, 0.059999], 
                    TagBox[
                    TooltipBox[LineBox[CompressedData["
1:eJwV02tozmEcxvHbaSsxCdNoObQ0c4jUFmYHQ14gRjmVc3J8tHLmBaOYMWfD
Zkw5TYRRFsowhzdOxeawwgu8mZVC5PT5v7ie675+39/9u5///X+eXvNW5Mda
hBAG+UjICWHG8BDGDgvhjnUtVY0IYf6oEFpkhlBtfYVm6tmWHcI1685jQrjK
m+Tx9s0fHUKNXCQvtW8ZLaIltJi+qk/Wt3NkCLuomOLNrrWnq1m3+Wzz8/Us
NOuO3Ba/z+toLlZsxkPrJP0P+Dd5uv4l+h/LJfJT3h1/wn/Ks/Dl+Et5j9zA
k/F6/kueg8fwN/JeuZH3wN/y3/ICvAB/Jx+QP/Ce+Hv+L3pWfCX+US6VP/Ne
+Cce3GMMX4U3yYfxZp6Cf+Et8QJ8Df5NPoL/4H3w77w1vhJfh/+Ry/B/PBX/
y+PwNfgGvE1WCOV4PO+Lx/F4PM0dtrfup9aOx9zjWns22pMgD8CLvJ8dtJ06
qRXo2aCn2TsaiGflhpBNXbH+5iTydmYX6tlkTpJc4ezu0Ty8G2+d5ztRK4qn
ONpt/h7qYJ1ubgLP4Af1F5pTZF5Hc3fxLfIh9d5USlvlEvUueCKVq01yVhlP
lo/xLLmCp1AlZcsneE88lQ+W+/JRzpzqeabROs96wNwUPaW82Dmn9QykM7RT
PqyeipfxErkqmkXnabdcrp6GV/J98gX1IXSR9ssn1fvjZ/hB+ZJ6Ol2mQ/JZ
9cH4BX5EvqqeQdfoqHxRPQOv5hXydfVMqqHjUb/6UPw6r5RvRHdBN+lk9L9U
z8Jv8VNyjvpcd7Da87/yPja7g9c8T89t7I11I72lXPk+5bu7Oj5WzwOeKz/k
o+kJTZYf83H4eHpqfdZZtc6cIN/l5+RnUQ89pyr5nvpE/FH0O/Z7WO57recx
/lLPFHNfRPP11PM8uYFPjJjaTfoPZm7g3Q==
                    "]],
                    "7"],
                    Annotation[#, 7, "Tooltip"]& ]}, 
                    {RGBColor[0.539994, 0.209998, 0.059999], 
                    TagBox[
                    TooltipBox[LineBox[CompressedData["
1:eJwV1ndwF1UUBeBFQDESgQDiSKRIk6DCEGoKNQm9hQ4iGKVJCygooLShqYBD
kSqEXhQH0BkLFpQiKImUgIyigoo1qBSlI37vjzPnnXvPufve/nY3qZw1KnNk
oSiK3r4timqlRlGdtCiqDT80i6K4FlFUCh6hGyVHUUxSFDVMj6IEvn30502j
6G61JLV6avX4zsjt1Ssjl0jXhSQ6lq8xXyJfnlwuxKndy3dAvxzej5P1kyDV
Opsn1bqhGSm4ET6kVlbufv6DPPH4C5yunwZP64+BFN4MujFODnuAI+rlZKvJ
VIeqcEi2PV87aGI9lqdjWPN3wE3xMbV4uVr8+TwJ+Cjurl8oI4q64WZ0eZ4W
ztiDPiHzFVRSy1Drq5Zu1ln3p164N5BGN5eryJPO0yfk6CdwFjwvPxEGWhd2
nSfxSfpB/nb8Q+i2Zlww82u5FDPb0K3D2ekafG35BvN9R4/Aw6GV9SRzRlkX
NXck/oF+mL8j/7P0ZLqLOZnQETpDJ/hRvQ5fG9c6Y05r/BOeKFPMrAlhT3Rt
ns5mPU//Rk/Fd+pPCfeaTtTvqj+NLqBn4hj9GbgDXV+/m/4s+iw9DxfXn4s7
0431e+i/Qv9NL8Kx+gtxVzpVv5f+q/RFejkuob8Md6eb6vfWX0FfonNwSf1V
uCfdQr+P/mr6Cr0Rx+lvwL3pDP1++pvoG/Qz7sM4GAtZ7lOB+9SO53GebTwz
6R24tBnbw5no9vpZ+u/Qs+n3cFn9d/F5+vaUKPrY+h61j/BjrtNFZqDMrnA/
9Re73lJYAtmu+49cL56hPAd55tJ5+D4zcvFl+gocs45Xy8cDze0nM1zmeDin
uZvNK423hDOZ+wxcl8viG8X3Pd8CeiE8oZatdirsVWY87wR4Dn5WG2r+Uzw7
zfoAajWPoofgrF4VeygI75FnOF72hXCG8Ozji3hY+A7I7g/fCagrlwg39GrI
Xg/PsGw12SkyRZp4dnFhPEJ2nOxJuW+hoVwjuEsvQTYGx8g+JDtLJo6eiUvh
bNkJsn/K/QXJcimQCpPVJzlvWb46slf0r8FVmCsfa+Z0nqk8FXhy3KOx5s1Q
K6E3G+/Fe2CR/hcyFXFJuhKubW+VcWOzu7heJnSFOXJleObjWWYv54mny8MS
M6qEc7W0R7mauAnOUZvNu0CmAl9FWKd2kH8tzg05teV4BTSUayPXALfFG3he
kl8sX52vBmxRO8y7GR/BNdVW4RxIl8uUS8Nd8Vae+eE9Ct9Pvo14UXgnwr2j
a4fvoXVdZ66Pe8oMc9bh8IJ7tpW/Ac8O/Fp4V3iS4F1YSb+l3kg/mT7u+jvx
0fDNhnxIDefF66GPPfU3vzcegHfxrjfjw/Dd5vsEb6J3q7eEVuE3ws3sbS9O
gzxoEd4l3E4/AyfSrfDg8Ozb9wSYCLvN68SzH281N5+nExyDN+kD6pn6uXgb
/Y16NzgJ2+k89Z763envobvrfIf7qp0K+6FP4x7wc2D6DO6v/wtOp38N9xT+
CEz/jrP0C3AGfRb3gXPQi/4bD9I/H85PXwjXg8vQm76En9K/glvTV/GjcDPM
oW/gUfr/4Tb0rbAfKOQd6EtHeLT+bbgtXTh8U/THhDM57/vOfYfaILVieCd9
Wn2c/o/4Q7q4+hD9WPwR/ZP6+HBm/Lrf9g3YAi/7PUryPOo6JcLfUp5S4btL
x+FhZtyD+9Fl8WT9kWrlrD81t8C8KWp/4t10tt48M9f5bS+E7xP8G75XMJ2v
gtyl8C7jy3g0/wz1c/L75CurP632AP6MPq/+ov4/4dtovx/A+7DINarx9Lev
qngOz1yobn1A7l/+efRV/An/kvAs46W4Fs8AuQS8gGdh+L6F/7fkroV3j76F
D9ET7WVFeEed56b9/geR+i28lG9ZeD9lD6tF4W8oXQTvca2VcrvxKlyf53HX
rIdzeFZDA+t8uaL8a+g78X7+Nfyf4bU4Nfz2cil4I88k+2lifUIuhn+TWiz+
kv8Q5ME6ucP4bvVv+KaGd1htmzPste99ME3tf3k+9TE=
                    "]],
                    "6"],
                    Annotation[#, 6, "Tooltip"]& ]}, 
                    {RGBColor[0.539994, 0.209998, 0.059999], 
                    TagBox[
                    TooltipBox[LineBox[CompressedData["
1:eJwV1nucT3UeBvDjOuQSmc24VkMxvWSZhtw1zLoMvWJC0aKRlIgYNlkjQi12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                    "]],
                    "5"],
                    Annotation[#, 5, "Tooltip"]& ]}, 
                    {RGBColor[0.539994, 0.209998, 0.059999], 
                    TagBox[
                    TooltipBox[LineBox[CompressedData["
1:eJwV1nmUj2UcBfB3SIeskb3FRMPJsWYPYxvLKTNOhZEhdWzZpoYMSbYsKRFZ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                    "]],
                    "4"],
                    Annotation[#, 4, "Tooltip"]& ]}, 
                    {RGBColor[0.539994, 0.209998, 0.059999], 
                    TagBox[
                    TooltipBox[LineBox[CompressedData["
1:eJwV1nmQz3Ucx/EPNXJ0OMvKtWqTIpWp3NYKTdLkyDTlKOQqUZOjJowc6ypH
OhTFNiQliu1wRQetoxJFCh1it6lFFOXq8f7jOa/v+/k5v8fvs5vZe0jnR0qk
lMaWTOnbJinNb5XSTrkuO6W1+KlNSvtxD5/fPKUDbVNaKfPUzzZLqVDbKvUh
+ZGswX1n/PrWKc1w/bk5NmK9toPGfiwXGrsIn7v+w7jPZC199xi32biXXH9h
TAG2aSsybqtcYsw8beeM2ak+K3fIK7hfjP3R2L3YZtyX+AqH+NrG/xDrRj/t
i+Sv8oJbUyqF5eYt1i9Lv0L9eqmv0ecwV6TfUtc7zLUTR7QX63dY/qntXW1/
yMMoRmXzrYxnhdP6VFefkg31+8d8J/Q5iV3m2o3vcZKvZ86SLVL6QL/T2j+U
Z2RZLtMcKSelEjjHnSdLIotfa51zxjc0vpK+g9SNjE1NUyqtz1rXP1pjL/bh
fL6Rvhn6rtdWRp8NsqysxV0sP1FfJMvjEtS3zkbzbkIDfW5Q15dN9Ctnvir6
XIrfzH8QzfhL+AyuwPUhrhBFqMQ3t35L47dqq6nPNllLtueull+r68rtsp5s
bb1sNHB9XewH16Mhcvjd9pVp3vbm7W6OJ9U5xtbhbtLnZvxp7WK05bP4Ftwe
18e44/gb9fhsfl+8K/UJPGq+Uu1SGipztO3X1lr+JNvIkXyHuHf17bIj7sDd
9tVJdsZd6Iou6MYfsL/fMNnYe9WT5J3G32z9+/TpjjPWPotOfFO+J9cr3nu8
f3TlW/J9uOOuS8X3jNLI5gfyJ+L9xjeEcmgT83tGC6z3r7aH9flPDpaLuZGx
rnqEPCufkG/xo2Jd3/BTcgxGo69958pJmIgpmIzB/HQ5A89iFmZiCH/MPd9t
D/3tocC809S9rdONe1Wf11DVPjPQh7+Xz+NeRzXucvTje/FLYm+oydVCbTzA
53NV7DVTXQdX4EH+ff4y/kp1Fq7Cw/waPoNvoL4OR+0ry/s+Ij/VVkPbJ7GO
/Eye5DfLTHWBrCO3yNQypW/kVertsq7cIUvz++S16r3x3cQ3hHGexyFZiIP4
HUWYyh+Vf+FIvFscwzT+dLwfnIpzIN5RPGO+jHOwLErjQpTDTL6CrIjyqIxK
mMVnyGqoiuq4HM/xs1HTddM4x2WzOJdllnuoL1upr5XZ8bzkNfyNsq36BtlO
NpL1+Sayg7qxvCPOP+4Z731O/Ma4O7nunncP9MQ8vh3flX9A3Tu+AbzO3853
4weoB2IQ3uQ7xNwYrH4Eo30by/guMQ+GcEMxhs/nm8bZFH/X7OW7ODewC624
hbK7MT1wH3qhJ97g+8oH0Qf90Q+L+YFyEAZEu/09JG8z9/Bw6mFyoBwhO/Kj
Yk/xO5JD5WjZib/J99ZZPsY9bb/jMB5f2vN4fYbxuepJmIzt/AR+OD9FPTX6
x98ofio/LeCewQT+2zgn3GPfOOusUxi/RVkk+3Mr5Kz4BuK7wfOYjZX8i/Il
vIDR1psj7zd2nnxaPVeOk6/G8+EXyAnq+XKi7M+t9t5/jt8ylxtz2NfLeAUH
+LdjvzFXfAfIjb8Z/FL+HSzg8uL+428tPzbOcvmpeWs7Q3LVE7HaflfEvvEe
ZpgzXz5uD2vjvtRr4l7kuniu8Z169sPlHG6RNd7AYpwy/wZ95vJL1e9givVL
4BVrzUVja59nD7fI82Ve/J9jDwXGbcYX2Iot2MCPiTPC9cI4I+SiOCPi+fHN
7GO8XMK9a633sAIV4v8pfXbFfanzMY2riOXWu1Tut3ZHe1gZ7zL+37LWJnxv
zFLz7Y7nKPfI6dZoYa0Zchm3ynyrsQbVzPU/OPjq7g==
                    "]],
                    "3"],
                    Annotation[#, 3, "Tooltip"]& ]}, {}, {}}}], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["142",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 142], "Ce"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 58.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["144",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 144], "Ce"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 58.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["146",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 146], "Ce"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 58.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["148",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 148], "Ce"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 58.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 150], "Ce"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 58.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 152], "Ce"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 58.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 154], "Ce"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 58.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["144",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 144], "Nd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 60.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["146",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 146], "Nd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 60.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["148",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 148], "Nd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 60.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 150], "Nd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 60.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 152], "Nd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 60.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 154], "Nd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 60.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 156], "Nd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 60.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["146",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 146], "Sm"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 62.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["148",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 148], "Sm"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 62.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 150], "Sm"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 62.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 152], "Sm"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 62.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 154], "Sm"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 62.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 156], "Sm"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 62.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 158], "Sm"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 62.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["148",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 148], "Gd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 64.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 150], "Gd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 64.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 152], "Gd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 64.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 154], "Gd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 64.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 156], "Gd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 64.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 158], "Gd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 64.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 160], "Gd"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 64.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 150], "Dy"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 66.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 152], "Dy"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 66.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 154], "Dy"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 66.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 156], "Dy"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 66.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 158], "Dy"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 66.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 160], "Dy"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 66.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["162",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 162], "Dy"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 66.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 152], "Er"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 68.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 154], "Er"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 68.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 156], "Er"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 68.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 158], "Er"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 68.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 160], "Er"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 68.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["162",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 162], "Er"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 68.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["164",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 164], "Er"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 68.}, {0, 0}, Automatic, {1, 0},
                    Background->GrayLevel[0.5]], InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 154], "Yb"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 70.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 156], "Yb"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 70.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 158], "Yb"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 70.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 160], "Yb"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 70.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["162",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 162], "Yb"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 70.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["164",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 164], "Yb"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 70.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["166",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 166], "Yb"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 70.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 156], "Hf"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 72.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 158], "Hf"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 72.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 160], "Hf"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 72.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["162",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 162], "Hf"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 72.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["164",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 164], "Hf"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 72.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["166",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 166], "Hf"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 72.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["168",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 168], "Hf"}]],
                    ShowAutoStyles->False,
                    ShowContents->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 72.}, {0, 0}, Automatic, {1, 0},
                    Background->RGBColor[0.960799, 0.960799, 0.862697]], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["142",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 142], "Ce"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 58.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["144",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 144], "Ce"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 58.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["146",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 146], "Ce"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 58.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["148",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 148], "Ce"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 58.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 150], "Ce"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 58.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 152], "Ce"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 58.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Ce\"\>"}],
                    Row[{
                    Superscript["", 154], "Ce"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 58.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["144",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 144], "Nd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 60.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["146",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 146], "Nd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 60.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["148",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 148], "Nd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 60.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 150], "Nd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 60.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 152], "Nd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 60.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 154], "Nd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 60.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Nd\"\>"}],
                    Row[{
                    Superscript["", 156], "Nd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 60.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["146",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 146], "Sm"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 62.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["148",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 148], "Sm"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 62.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 150], "Sm"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 62.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 152], "Sm"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 62.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 154], "Sm"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 62.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 156], "Sm"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 62.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Sm\"\>"}],
                    Row[{
                    Superscript["", 158], "Sm"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 62.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["148",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 148], "Gd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 64.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 150], "Gd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 64.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 152], "Gd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 64.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 154], "Gd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 64.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 156], "Gd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 64.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 158], "Gd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 64.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Gd\"\>"}],
                    Row[{
                    Superscript["", 160], "Gd"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 64.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["150",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 150], "Dy"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 66.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 152], "Dy"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 66.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 154], "Dy"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 66.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 156], "Dy"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 66.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 158], "Dy"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 66.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 160], "Dy"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 66.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["162",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Dy\"\>"}],
                    Row[{
                    Superscript["", 162], "Dy"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 66.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["152",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 152], "Er"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 68.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 154], "Er"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 68.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 156], "Er"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 68.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 158], "Er"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 68.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 160], "Er"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 68.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["162",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 162], "Er"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 68.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["164",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Er\"\>"}],
                    Row[{
                    Superscript["", 164], "Er"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 68.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["154",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 154], "Yb"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 70.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 156], "Yb"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 70.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 158], "Yb"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 70.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 160], "Yb"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 70.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["162",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 162], "Yb"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 70.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["164",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 164], "Yb"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 70.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["166",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Yb\"\>"}],
                    Row[{
                    Superscript["", 166], "Yb"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 70.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["156",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 156], "Hf"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {84., 72.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["158",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 158], "Hf"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {86., 72.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["160",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 160], "Hf"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {88., 72.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["162",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 162], "Hf"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {90., 72.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["164",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 164], "Hf"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {92., 72.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["166",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 166], "Hf"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {94., 72.}, {0, 0}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    InterpretationBox[
                    RowBox[{
                    TagBox[
                    SuperscriptBox[
                    TagBox["\<\"\"\>",
                    Power,
                    Editable->True,
                    Selectable->True], 
                    TagBox["168",
                    Power,
                    Editable->True,
                    Selectable->True]],
                    InterpretTemplate[Superscript[#, #2]& ],
                    Editable->False,
                    Selectable->False], "\[InvisibleSpace]", "\<\"Hf\"\>"}],
                    Row[{
                    Superscript["", 168], "Hf"}]],
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {96., 72.}, {0, 0}, Automatic, {1, 
                    0}]}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}\
}},
  AspectRatio->NCache[
    Rational[2, 3], 0.6666666666666666],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
     TagBox[
      TagBox[
       StyleBox[
        TagBox[
         StyleBox["\"N\"", FontSlant -> "Italic"], 
         StyleForm[#, FontSlant -> "Italic"]& ], FontFamily -> "Times", 
        FontSize -> 12, FontSlant -> "Plain", FontTracking -> "Plain", 
        FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 1, 
        ShowAutoStyles -> False, SingleLetterItalics -> False], 
       StyleForm[#, FontFamily -> "Times", FontSize -> 12, FontSlant -> 
        "Plain", FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
        GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False, 
        SingleLetterItalics -> False]& ], DisplayForm], TraditionalForm], 
    FormBox[
     TagBox[
      TagBox[
       StyleBox[
        TagBox[
         StyleBox["\"Z\"", FontSlant -> "Italic"], 
         StyleForm[#, FontSlant -> "Italic"]& ], FontFamily -> "Times", 
        FontSize -> 12, FontSlant -> "Plain", FontTracking -> "Plain", 
        FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 1, 
        ShowAutoStyles -> False, SingleLetterItalics -> False], 
       StyleForm[#, FontFamily -> "Times", FontSize -> 12, FontSlant -> 
        "Plain", FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
        GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False, 
        SingleLetterItalics -> False]& ], DisplayForm], TraditionalForm], 
    None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->{{{84., 
      FormBox["\"84\"", TraditionalForm], {0.01, 0}, {}}, {86., 
      FormBox["\"86\"", TraditionalForm], {0.01, 0}, {}}, {88., 
      FormBox["\"88\"", TraditionalForm], {0.01, 0}, {}}, {90., 
      FormBox["\"90\"", TraditionalForm], {0.01, 0}, {}}, {92., 
      FormBox["\"92\"", TraditionalForm], {0.01, 0}, {}}, {94., 
      FormBox["\"94\"", TraditionalForm], {0.01, 0}, {}}, {96., 
      FormBox["\"96\"", TraditionalForm], {0.01, 0}, {}}}, {{58., 
      FormBox["\"58\"", TraditionalForm], {0.01, 0}, {}}, {60., 
      FormBox["\"60\"", TraditionalForm], {0.01, 0}, {}}, {62., 
      FormBox["\"62\"", TraditionalForm], {0.01, 0}, {}}, {64., 
      FormBox["\"64\"", TraditionalForm], {0.01, 0}, {}}, {66., 
      FormBox["\"66\"", TraditionalForm], {0.01, 0}, {}}, {68., 
      FormBox["\"68\"", TraditionalForm], {0.01, 0}, {}}, {70., 
      FormBox["\"70\"", TraditionalForm], {0.01, 0}, {}}, {72., 
      FormBox["\"72\"", TraditionalForm], {0.01, 0}, {}}}, {}, {}},
  ImageSize->{432, 288},
  PlotRange->{{82.9986, 97.0014}, {56.9984, 73.0016}},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.39552201146875*^9, 3.395522356734375*^9, 3.395522422890625*^9, 
   3.39552253146875*^9, 3.395522727671875*^9, 3.395524222890625*^9, 
   3.39688020140625*^9, {3.3968805225625*^9, 3.39688058321875*^9}, 
   3.39758627040625*^9, 3.430248107046875*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1272, 902},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
DockedCells->(FrontEndExecute[{
   FrontEnd`NotebookApply[
    FrontEnd`InputNotebook[], #, Placeholder]}]& ),
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{None, None, None}, {None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{71.875, 71.875}, {53.875, 53.875}}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 233, 5, 69, "Text"],
Cell[781, 27, 584, 11, 34, "Text"],
Cell[CellGroupData[{
Cell[1390, 42, 41, 0, 88, "Section"],
Cell[1434, 44, 533, 12, 55, "Text"],
Cell[1970, 58, 184, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2191, 67, 124, 1, 88, "Section"],
Cell[2318, 70, 238, 5, 34, "Text"],
Cell[CellGroupData[{
Cell[2581, 79, 6039, 161, 740, "Input"],
Cell[8623, 242, 90406, 1665, 378, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99078, 1913, 116, 1, 88, "Section"],
Cell[99197, 1916, 310, 6, 55, "Text"],
Cell[CellGroupData[{
Cell[99532, 1926, 7476, 194, 850, "Input"],
Cell[107011, 2122, 239780, 4255, 396, 200681, 3613, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[346840, 6383, 232, 3, 88, "Section"],
Cell[347075, 6388, 421, 7, 55, "Text"],
Cell[347499, 6397, 1712, 52, 102, "Input"],
Cell[CellGroupData[{
Cell[349236, 6453, 13764, 294, 2016, "Input"],
Cell[363003, 6749, 166546, 2852, 468, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[529598, 9607, 145, 1, 88, "Section"],
Cell[529746, 9610, 421, 7, 55, "Text"],
Cell[530170, 9619, 129, 1, 34, "Text"],
Cell[530302, 9622, 1638, 51, 234, "Input"],
Cell[531943, 9675, 103, 1, 34, "Text"],
Cell[532049, 9678, 1066, 34, 58, "Input"],
Cell[533118, 9714, 2129, 63, 168, "Input"],
Cell[535250, 9779, 93, 1, 34, "Text"],
Cell[CellGroupData[{
Cell[535368, 9784, 4434, 110, 608, "Input"],
Cell[539805, 9896, 46948, 835, 378, 29572, 548, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[586802, 10737, 223, 5, 88, "Section"],
Cell[587028, 10744, 152, 3, 34, "Text"],
Cell[587183, 10749, 505, 12, 55, "Text"],
Cell[CellGroupData[{
Cell[587713, 10765, 8579, 206, 1026, "Input"],
Cell[596295, 10973, 326164, 6546, 378, 294016, 6017, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
