(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1932368,      34350]
NotebookOptionsPosition[   1927958,      34211]
NotebookOutlinePosition[   1928823,      34241]
CellTagsIndexPosition[   1928780,      34238]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["LevelScheme examples: Diagrams",
 FontFamily->"Times New Roman",
 FontSize->36]], "Text",
 CellChangeTimes->{{3.491258240734375*^9, 3.491258242390625*^9}},
 FontSize->10],

Cell[TextData[{
 StyleBox["M. A. Caprio, ", "SmallText",
  FontFamily->"Times New Roman",
  FontSize->12],
 "Department of Physics, University of Notre Dame"
}], "Text",
 CellChangeTimes->{{3.39552255203125*^9, 3.3955225581875*^9}, {
   3.396878383875*^9, 3.39687838403125*^9}, 3.397586352671875*^9, {
   3.39854548165625*^9, 3.398545486203125*^9}, {3.430247945015625*^9, 
   3.430247947875*^9}, {3.436820309328125*^9, 3.436820313328125*^9}, {
   3.4972250515*^9, 3.497225051796875*^9}}],

Cell[CellGroupData[{

Cell["Package initialization", "Section"],

Cell[TextData[{
 "If you have not already loaded the LevelScheme package since starting this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you must do so now.  See the user guide for information first on \
installing the package and then on loading it at the beginning of each ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session."
}], "Text",
 CellChangeTimes->{{3.4921245209375*^9, 3.492124756234375*^9}, {
  3.492124799609375*^9, 3.492124838453125*^9}, {3.495659733515625*^9, 
  3.495659808359375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", "\"\<LevelScheme`\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.492124284765625*^9, 3.49212429721875*^9}, 
   3.492124551328125*^9}],

Cell[BoxData[
 FrameBox[
  TemplateBox[{TagBox[
     GridBox[{{
        RowBox[{
         "LevelScheme", " ", "scientific", " ", "figure", " ", "preparation", 
          " ", "system"}]}, {
        RowBox[{
          RowBox[{"M", ".", " ", "A", ".", " ", "Caprio"}], ",", " ", 
          RowBox[{"Department", " ", "of", " ", "Physics"}], ",", " ", 
          RowBox[{"University", " ", "of", " ", "Notre", " ", "Dame"}]}]}, {
        TemplateBox[{"\"Comput. Phys. Commun. \"", 
          TagBox[
           StyleBox["\"171\"", FontWeight -> "Bold"], 
           StyleForm[#, FontWeight -> "Bold"]& ], "\", 107 (2005)\""}, "Row", 
         DisplayFunction -> (
          RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]}, {
        RowBox[{"Version", " ", "3.52", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"September", " ", "20"}], ",", " ", "2011"}], ")"}]}]}, {
        RowBox[{
          ButtonBox[
           StyleBox[
            RowBox[{"View", " ", "color", " ", "palette"}], FontFamily -> 
            "Times"], Active -> True, Appearance -> {Automatic, "DialogBox"}, 
           ButtonFunction :> (NamedColors`NamedColorPalette[]& ), ButtonNote -> 
           "Named color palette", Evaluator -> Automatic, ImageSize -> 
           Automatic], 
          TagBox[
           ButtonBox[
            StyleBox[
             RowBox[{"Visit", " ", "home", " ", "page"}], FontFamily -> 
             "Times"], Active -> True, Appearance -> {Automatic, "DialogBox"},
             ButtonData :> {
              URL["http://scidraw.nd.edu/landing/levelscheme-3.52.html"], 
              None}, ButtonFunction :> (FrontEndExecute[{
               FrontEnd`NotebookLocate[#2]}]& ), ButtonNote -> 
            "http://scidraw.nd.edu/landing/levelscheme-3.52.html", ImageSize -> 
            Automatic], DisplayForm]}]}}, 
      GridBoxAlignment -> {
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}], DisplayForm],"\"  \"",GraphicsBox[{{
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 200.}, {0.9, 200.}}]}, {
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 116.93046875}, {0.1536723484848485, 116.93046875}, {
        0.2610170454545455, 100.}, {0.7389829545454545, 100.}, {
        0.8463276515151515, 116.93046875}, {0.9, 116.93046875}}]}, {
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 0.}, {0.9, 0.}}], {
        GrayLevel[0.5], 
        Opacity[1], 
        PolygonBox[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {
         0.6828827683115883, 106.35880620986916`}, {0.675461586050597, 
         105.04604015402995`}, {0.73, 100.}, {0.7595683183418321, 
         119.92405545354092`}, {0.7521471360808408, 118.61128939770171`}, {
         0.6707584254785426, 200.}}]}, {
        GrayLevel[0], 
        AbsoluteThickness[1], 
        Opacity[1], 
        Dashing[{}], 
        LineBox[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {
         0.6828827683115883, 106.35880620986916`}, {0.675461586050597, 
         105.04604015402995`}, {0.73, 100.}, {0.7595683183418321, 
         119.92405545354092`}, {0.7521471360808408, 118.61128939770171`}, {
         0.6707584254785426, 200.}, {0.6300000000000001, 200.}}], {
         GrayLevel[0.5], 
         Opacity[1], 
         PolygonBox[{{0.2700000000000001, 100.}, {0.22924157452145752`, 
          100.}, {0.3228827683115884, 6.358806209869151}, {0.3154615860505971,
           5.046040154029939}, {0.37000000000000005`, 0.}, {
          0.3995683183418322, 19.924055453540902`}, {0.39214713608084084`, 
          18.61128939770171}, {0.3107584254785426, 100.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.2700000000000001, 100.}, {0.22924157452145752`, 100.}, {
          0.3228827683115884, 6.358806209869151}, {0.3154615860505971, 
          5.046040154029939}, {0.37000000000000005`, 0.}, {0.3995683183418322,
           19.924055453540902`}, {0.39214713608084084`, 18.61128939770171}, {
          0.3107584254785426, 100.}, {0.2700000000000001, 100.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 20.}, {0.529, 20.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 21.3}, {0.5589999999999999, 21.3}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 24.333333333333336`}, {0.589, 
          24.333333333333336`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 29.1}, {0.619, 29.1}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 35.6}, {0.649, 35.6}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 43.833333333333336`}, {0.679, 
          43.833333333333336`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.681, 53.8}, {0.709, 53.8}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.711, 65.5}, {0.739, 65.5}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.741, 78.93333333333334}, {0.769, 78.93333333333334}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 33.}, {0.529, 33.}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 34.3}, {0.5589999999999999, 34.3}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 37.333333333333336`}, {0.589, 
          37.333333333333336`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 42.099999999999994`}, {0.619, 
          42.099999999999994`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 48.599999999999994`}, {0.649, 
          48.599999999999994`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 56.833333333333336`}, {0.679, 
          56.833333333333336`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.681, 66.8}, {0.709, 66.8}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.711, 78.5}, {0.739, 78.5}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 47.761071567264665`}, {0.529, 
          47.761071567264665`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 49.24022665797266}, {0.5589999999999999, 
          49.24022665797266}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 52.691588536291334`}, {0.589, 
          52.691588536291334`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 58.115157202220665`}, {0.619, 
          58.115157202220665`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 65.51093265576067}, {0.649, 65.51093265576067}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 74.87891489691134}, {0.679, 74.87891489691134}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 56.07894755622853}, {0.529, 56.07894755622853}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 57.38554745213195}, {0.5589999999999999, 
          57.38554745213195}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 60.434280542573276`}, {0.589, 
          60.434280542573276`}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 65.22514682755249}, {0.619, 65.22514682755249}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 71.75814630706962}, {0.649, 71.75814630706962}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 80.03327898112465}, {0.679, 80.03327898112465}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 60.981197953135855`}, {0.529, 
          60.981197953135855`}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 62.04756255970392}, {0.5589999999999999, 
          62.04756255970392}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 64.53574664169608}, {0.589, 
          64.53574664169608}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 68.44575019911233}, {0.619, 68.44575019911233}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 73.77757323195266}, {0.649, 73.77757323195266}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 80.53121574021708}, {0.679, 80.53121574021708}}], 
         InsetBox[
          TagBox["\"LevelScheme\"", DisplayForm], {0.1, 200.}, {-1, -0.75}, 
          Automatic, {1, 0}, 
          BaseStyle -> {
           FontFamily -> "Times", FontSize -> 10, FontSlant -> "Plain", 
            FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
            GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}]}}}}, 
     AspectRatio -> 0.7727272727272727, Axes -> False, Background -> 
     RGBColor[0.889996, 0.509995, 0.089999], 
     BaseStyle -> {
      FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", 
       FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
       GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}, 
     DisplayFunction -> Identity, Frame -> False, 
     FrameLabel -> {None, None, None, None}, FrameStyle -> Directive[{
        GrayLevel[0], 
        Opacity[1], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{}]}], FrameTicks -> None, 
     ImageSize -> {93.17647058823529, 72.}, 
     PlotRange -> {{-0.0001, 1.0001}, {-50.0325, 275.0325}}, Ticks -> None]},
   "Row",
   DisplayFunction->(
    RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3}]& ),
   InterpretationFunction->(RowBox[{"Row", "[", 
      RowBox[{"{", 
        RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
  Background->GrayLevel[0.85],
  FrameMargins->10,
  FrameStyle->None,
  StripOnInput->False]], "Print",
 CellChangeTimes->{3.525527880296875*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Diagram with various special arrow types", "Section"],

Cell["Note the uses of \"squiggle\" and \"multiline\" arrows", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "target", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SchemeSquare", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.03", ",", "0.3"}], "}"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Gold"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "beam", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeArrow", ",", 
       RowBox[{"ArrowType", "\[Rule]", "MultilineArrow"}], ",", 
       RowBox[{"ShaftLines", "\[Rule]", "3"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Gray"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"ShowHead", "\[Rule]", "False"}], ",", 
       RowBox[{"HeadLength", "\[Rule]", "0"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"Dashing", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"gamma", " ", "rays"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeArrow", ",", 
       RowBox[{"ArrowType", "\[Rule]", "SquiggleArrow"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"Color", "\[Rule]", "Blue"}], ",", 
       RowBox[{"SquiggleWavelength", "\[Rule]", "8"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"Color", "\[Rule]", "Red"}], ",", 
       RowBox[{"SquiggleWavelength", "\[Rule]", "12"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "0.3", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Pi", "/", "4"}]}], "}"}], ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}], ",", 
       RowBox[{"LabR", "\[Rule]", "\"\<\[Theta]\>\""}], ",", 
       RowBox[{"NudgeR", "\[Rule]", "10"}]}], "]"}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{3.395521142875*^9, 3.39552154471875*^9}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1., 0.843104, 0.], Opacity[1], 
    PolygonBox[{{-0.03, -0.3}, {-0.03, 0.3}, {0.03, 0.3}, {0.03, -0.3}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.03, -0.3}, {-0.03, 0.3}, {0.03, 0.3}, {
     0.03, -0.3}, {-0.03, -0.3}}], 
    {GrayLevel[0.5], Opacity[1], 
     PolygonBox[{{-2., -0.03472916666666681}, {0., -0.03472916666666681}, {0.,
       0.}, {0., 0.03472916666666648}, {-2., 0.03472916666666648}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{-2., -0.03472916666666681}, {
      0., -0.03472916666666681}}], LineBox[{{-2., 0.}, {0., 0.}}], 
     LineBox[{{-2., 0.03472916666666648}, {0., 0.03472916666666648}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}], 
     CapForm[None], 
     LineBox[{{0., -0.03472916666666681}, {
      1.9621136363636356`, -0.03472916666666681}}], 
     LineBox[{{0., 0.}, {1.9999999999999991`, 0.}}], 
     LineBox[{{0., 0.03472916666666648}, {1.9621136363636356`, 
      0.03472916666666648}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{1.9166499999999993`, 0.0764041666666666}, {
      1.9999999999999991`, 0.}, {
      1.9166499999999993`, -0.07640416666666672}}]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
     CapForm[None], LineBox[CompressedData["
1:eJxdl3s0VPv//1VK91RCkTi6iaIbpfQUKnWUURSFJt2INCThKE5USqeECpEJ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      "]]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
     CapForm[None], 
     LineBox[{{0.9115939746821518, 0.9705313248940504}, {0.9999999999999996, 
      0.9999999999999996}, {0.9705313248940506, 0.9115939746821518}}]}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
     CapForm[None], LineBox[CompressedData["
1:eJxdlnk01PvDxxGuFq6krFcSkqSSUKnImihlrSvJVpZCSSLabFG4JSlSoVJX
KEuSvG1FY2loMNbZjDFmSLZEy/N9nqfn1znPnDPndV7n8/qc8/7+9f2ucA/Y
7yUkICAwQfz/m///Z1QdssBv3V0I/B/dVDrVxDOQnE22PDuahapie3lVhXTc
T1DZp7D2MS4I7w9rib2D9dMSu48a/gsj+fmGwxF3MBahlDIrWoAL+r3nJlXS
QRUg71m47TkuzLS5P7+ZAXqXxVOt2heoar0W8J2fCWqehKGmZDHuy1B3hyg8
QFXmnOh55RK4zT1nLDfMhrKecOvsOOEPdogodDyEM1+H0hxXCje7dRWHmLlI
yygUj2CXQqCz8O1ZhzzMeLDvQuIlbNe5xYpKFsJttV2i+aKXKPR0jMqTeQHL
iP3qQZxSFDqfj/uuV4wLUstfjj0the3sLt/D7qUw+sWqdGnr6mtlGGME/9Ui
Vwpy0jZbqWflWH/GON+mrwTKbzfalBVXQLbRyDy0rARjca8/C96pRGhyvt7P
khIEqm2fq19dBboT650xjThfPJtL5VdBWeyIwOetpQgM7wtyulEN58qkeXWt
xPNM2nVeVKhBmUNa846cl5A0cq5AVA3uW0SnpRSXQSP907YnH2qQJm+teV2w
HJan8rsFfhA+URtdFPuaeP4GlSypWoSWRMUbG79B7qufd7wW18L27KJ1CerA
fY+fg7NEb+skmCp7qwpG+V4F5fQaOLcula1+VA1ZlTmxkxU1/6FAarL76rQa
9J6kf1Vpq0UafVqTe7YGdP5keCOjDsnx0yGRR2sQ90dgWCb7LQyOr/1k7F2D
UG6RtQn1HcbIFvqssBp4WknvXVBSD8knopQtT2owpEf+Jh/aAA3hTAfVSeL8
ftHb20rvQd2btcX9UC2c5TTX1D16j4YG2ftX2bUQ9tKWFJIkwVLn27GFV+ug
UfX2H95BEhqUypYp7n0L07QobZMrJFSdl5VjrXmHmbnMkIG7JOQeceHFKtUj
t7999HEGCc7nOrkHVRpwP659y7Z4wqd5fvN03sPg49Z53/1IkLVodSm2+E36
rVIbr0ONmCz3LvVbSfjixg/ix5twVaQ5co0ICXFa5i30wGbEFTSRqsbfI1Qi
/n60Rwt0r88zifr8Hm4Bw1nWRh/An/orQU2UhLG1drn5gmQIt/SuitAloZBZ
t2jUngyN1cFPvM+ToLH8wo55t8mgBIcm5gyRIGAmpJPVTEbDyOhES2AjUsab
x5dNkGHq1FZhI9OEHNe11TsXtKLBJNHXtbsJ55K3eN2QbkVxzqi/2stmUAQd
V0wtaUVOjM4O0pMWkDsc6kH0lg+ebbv77AMUv8X9e2+OjFxxBi3LlYxFpXbO
4VwyxH5xJkBJxKmTDF/Xd2S74FaY3tzH1Wsg40Q6ebHGN8J99yUJgowaDYl/
Fke2IaPHf7dHJRnlcutnPb60IVg87FMR0WtbuYXXe33EhbNdb2g0MgKNtrft
rf8I6VUPI+1FWqE9VaCXJE8B33pV0MTmVuRu8PPJcaXA8wozWyyyFZFOI3+b
3KBAdbu9mGVrK6REXimWlRHnujqHyTptUAqS5bE+UED1dKdvfNCGmSy1JN1u
CsgOUbti5D9ij7Tx7tQu4j6ruiEgg3Cu0Wc3MgUayk3zTVUpSJMIbjeqpiCu
YfslxYLf5Ac+n53c3I7QS/PXzWQQ/uz11vfV7ah5bLiEeo0Co61fy1+YdKDq
nOGrrCgKDLQUVEXedGDZqNNpYcILXXY/PLamE+PLveQcEikY27/629jVTvxI
qONceEic/5Hutp7eieubk3OnSMQeU8cbZqpUHDsslZ7ykwIBX2r0gDMV9PTm
5icm7UiWyTE/EElFpu0OHW5qOzIuz1safZMKpvlfV4JmiJ0lkq/a71HheMZm
Qbt3B8jqWqf1Cd9zLODUKnoHmubWKAilUpE1lTcu6d4J6RWHfzJiqMjRebmR
ze2EcM/qvDfBVIj+4mTKpPNtdyq8L2eopv6kwrR81bazdlT4Vz3y8o3tglHS
KpaJFRWVNgMDdvO7kSZgcu/hLipKt4vueXSpG4E6tibTRK8ZoPdh/uduXMgs
WKziR8UJL2n16/t7IGkd3paaTIWWfEx868MeDAV9r9v0ltjjaPxmkNsDt/yy
L1bzuxB2rrYgWqkXyh6aLvEuXVikmRQ4a9ILtwNiRVKVXZBPHd2u/ncvqFcM
dEO0ujFdP8cM8epFU9jBuw0Pu2G9WeYe1ZO4L5am+GJVD6wkZMyyiV7VLOtQ
TEEPUjdarb5s3YuoEekO1y2/OXQzdo/+214EP6Zd2qJBeNs/SQtt+lDVJHVU
Xq4XRm4fJKZa+lDxQEqc/WcvdPd9PmNh2Q/pJdrvzQnPvbji69PSfoyabj1+
i+j5Z37u3ShLw2zhna2163uRpxVUfNKPhkRX72/6jsQ+Hy1ObAENnlFDox3x
vZhJzO9SH6Chvyp7Bb+lF+ZK25qbhenIOL00Zo1KH/ZQ/Is9JOno95voLbrc
hy3HT4leXUqHfcZKV5nxPgyqXRwwJNz6mlm9j18/PCUv6mcRfab8ZXO7kX4s
yL6zWmo+HVlO12JXnabhf78C6BD6xbFXpLyeERp07Dcb+pvRYUj7nvy6n4bi
k5UujlcIL/6uF9NOg+vmQ4q7SXSkqMlNcCg0UDeM2k6KMuDvpH7LgEaDtFXM
YvXtDITWRnt5TtOwyWzKcPgEAzFlGjf44sS95dqfrqQxENjos8hQgw7ym4S4
lHIG8n3qH5pb0VFBbhIcoDCwyFTAefAUHVGPddwzOQxo7wi4/DSHjoRD7rt0
Jxg45vSHaW8PHaHTx9JdZhgY3JsWGi3LgFpByFlxwhOX6RuEHWAg63ZI00mi
l9xU4ex5lwFLreRKJo8BoytTKWTmbwb2abcaajBhMHjQr7KLgfG5os/q/kz0
hwYf0m5jIKNm/3OFZ0y4eAQX3mhmQP41i13HZUJM8VKiKeH2H8MfTSuzMFUc
R/cn+uCW4dbyfSx88y2rF+pngJK7MupgOAvvjJU03owReywu/uV1l4VC+8MP
Fi1k4tuBmtTilyyMjFdskVnLRN16jS8nSCxYN0/xSx2ZIA069Qt3sHCiwVM2
PJaJsvOu69f2sJBL/0bNq2TC08Bfor+bBdWua+KOc0wMqPgfMSH6lntazVaG
LMSVRNsVtbCwt/L5iO4FFvEdxFv94O1vhgTYCiRVEHu8Vb3FFw5ASch3/Ecx
CzrRT2K+7BlABt/HzLOQhd7dlub8pAFYPjyzcinhTqZdYTebBqC7PfL0thIW
rrsEba2fx4bh5DOXj1UsFDnRvRN02RBtXPLm2kcWpHTk5Na4sjHWZ6/XN0Ls
IYe82HSBDa1zLz5w/hzAFtbLNdF32Ih35F2M3TyAeeV/Xd3xjI38fQef7fYd
wIJAm1PtZWwM+Ywfj3gwgGkx+7ff37Dh7n45S71/ANnVR7LzCV+0WsVdYTkb
K/KOTC95xUaixeNLIh5sNGwPH7r8nI3KdHplUO5vjn6Sm+sbYaN0xuzm4Xts
BErcU2jYMAiXhMOxH26xodi+rafi5CC6Tx/u1r3BRmpzy5/eBYOI0T5exr7O
Rhvbm3xrcBDB9acWSKSxMU5vn/tbhoOwiOzP2dls7H8tkT9nxIGJ/fz9rqXE
ngP+FqIeHGgftWp8RmYjzP9ZlUMEB74iuZ5l42zsNFmyQjKZAxKNvsxZcRCW
X3eKPUrngNe9d6eizSD0ru862HKfA/UJjtCeqEEwrZwMzhOexQvV/1I1CLdN
TgkDRG/9QuYLT5AD0YbACPsUDprJGTIdZhx8U+2w25nAwY9fnL64VXP9JWLP
2T+T88kcZEg7KN4P46DwVkphmvQQZH/aB4iEcHDAdWPgNYchvHvpblN6moN2
x7ocvetDKLb1uddP9JIBLl7H3g+hXPR2THAMBxt8G5O1Zodwqe/HoPZtDpJN
hU2aVnLhP7bDLbKI2MM80tthxsXTxLtf49o5KJvKclB340LMp+NfjZ8cXGwS
K6Wf5ELT06yTv24IcZcM7oZEcuF9ru+W0tEhnFbY8SnzMhfM4BNN9dlDWEGx
bt5LePxW8asVA0O4V2mtXEL0iw5ez3ukwYXZPm8ptTNcGOY3Dkmd4GLbL/oL
iaidL+JCd+EGCHhxMaYcb+bzhYvuu1bPAw9xkcbREHE1GMaBOCvhDmcupOmv
Nv9xehjCxs7MGMJtZ/bNGuQNY7zLVbeA6AMnqtS+9w5jJilRwcyHi5bmr50Z
ojxUe0+G/wwn9vg7BT3W4CHv7KapPalczESmDU/v5GFY5kbigTIuqhx+WD13
4MFyvNHoK4OLdwu1dSyO8OAzssX/jdQwXuToRgV485Aj8lHr065huB3a6a5M
uPIPjyNpMcPot9hZEk30pDqhFdfqhxHV/ffjqQM8WLNijc8s5OGcfnUEy/Y3
T6ao27daEHsSZl/tTeVBfpWRubERD9pPz3dv7uYhdbHR7UdbeaAGKt3RVuDD
lGRzxolwe5+Clk4nPtZ72L8/T/SJFy2S5ifxYSAXVbjUmoeCc6XlzeBDYIwr
SXblQcLpk/9xLh98oTXxy8/ysHvKWjR04Qg0H8St1EznQU8s8Xy92gjiwqvb
39fxIECboF00GEFuyHrBxCkeRG+urJcxHcFAYkM1tPiYXKspZ7RrBG6xB6aP
+fCROaj/ZcxyBGJ7ZkoOPeVDqVXfypHo4/0jOixG+aj12Gf4znAE5VWlUsUb
R/D6FwX/5z049h/+F+6pjtU=
      "]]}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
     CapForm[None], 
     LineBox[{{-0.9115939746821522, -0.9705313248940509}, \
{-1.0000000000000002`, -1.0000000000000002`}, {-0.9705313248940508, \
-0.9115939746821522}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], CircleBox[{0., 0.}, 0.3, 
      NCache[{0, Rational[1, 4] Pi}, {0, 0.7853981633974483}]], InsetBox[
      TagBox[
       StyleBox[
        TagBox["\<\"\[Theta]\"\>",
         DisplayForm],
        StripOnInput->False,
        ShowAutoStyles->False,
        SingleLetterItalics->False,
        FontFamily->"Times",
        FontSize->12,
        FontWeight->"Plain",
        FontSlant->"Plain",
        FontTracking->"Plain",
        FontColor->GrayLevel[0],
        FontOpacity->1],
       DisplayForm], {0.3, 0.13891666666666666`}, {-1, 0}, Automatic, {1, 
      0}]}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{288, 144},
  PlotRange->{{-2.0004, 2.0004}, {-1.0002, 1.0002}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.497225598359375*^9, 3.525527882015625*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SU(2) laddering", "Section",
 CellChangeTimes->{{3.489885713125*^9, 3.4898857150625*^9}, {
  3.49272478496875*^9, 3.49272479584375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SchemeLine", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"ShowHead", "\[Rule]", "True"}], ",", 
       RowBox[{"LabR", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<M\>\"", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"lab", "[", 
       RowBox[{"-", "3"}], "]"}], "=", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<-\>\"", ",", 
         RowBox[{"textit", "[", "\"\<J\>\"", "]"}]}], "}"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"lab", "[", 
       RowBox[{"-", "2"}], "]"}], "=", "None"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"lab", "[", 
       RowBox[{"-", "1"}], "]"}], "=", "None"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"lab", "[", "0", "]"}], "=", "\"\<\[CenterEllipsis]\>\""}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"lab", "[", 
       RowBox[{"+", "1"}], "]"}], "=", "None"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"lab", "[", 
       RowBox[{"+", "2"}], "]"}], "=", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"textit", "[", "\"\<J\>\"", "]"}], ",", "\"\<-1\>\""}], 
        "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"lab", "[", 
       RowBox[{"+", "3"}], "]"}], "=", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"textit", "[", "\"\<J\>\"", "]"}], "}"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SchemeCircle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"M", ",", "0"}], "}"}], ",", 
         RowBox[{"Point", "[", "3", "]"}], ",", 
         RowBox[{"FillColor", "\[Rule]", "Moccasin"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"LabB", "\[Rule]", 
          RowBox[{"lab", "[", "M", "]"}]}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"M", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SchemeLine", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"M", "-", "1", "+", "0.05"}], ",", "0.1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"M", "-", "0.05"}], ",", "0.1"}], "}"}]}], "}"}], ",", 
         RowBox[{"ShowTail", "\[Rule]", "True"}], ",", 
         RowBox[{"ShowHead", "\[Rule]", "True"}], ",", 
         RowBox[{"Color", "\[Rule]", "Firebrick"}], ",", 
         RowBox[{"HeadLip", "\[Rule]", "2"}], ",", 
         RowBox[{"HeadLength", "\[Rule]", "3"}], ",", 
         RowBox[{"LabT", "\[Rule]", 
          RowBox[{"Subscript", "[", 
           RowBox[{
            RowBox[{"textit", "[", "\"\<J\>\"", "]"}], ",", 
            "\"\<\[PlusMinus]\>\""}], "]"}]}], ",", 
         RowBox[{"OffsetT", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], ",", 
         RowBox[{"PosnT", "\[Rule]", "0.5"}], ",", 
         RowBox[{"BufferT", "\[Rule]", "0"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"M", ",", 
         RowBox[{"-", "2"}], ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ","}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.40243520075*^9, 3.40243524146875*^9}, {
   3.402435289734375*^9, 3.402435537453125*^9}, {3.402435570578125*^9, 
   3.402435759390625*^9}, {3.40243588296875*^9, 3.40243591275*^9}, {
   3.40829301315625*^9, 3.40829302334375*^9}, {3.489876338515625*^9, 
   3.48987651640625*^9}, {3.4898765751875*^9, 3.489877023234375*^9}, {
   3.48987706428125*^9, 3.4898771024375*^9}, {3.4898771391875*^9, 
   3.489877449546875*^9}, {3.489885728828125*^9, 3.489886394046875*^9}, 
   3.492724774671875*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-3.999999999999999, 0.}, {4.000000000000001, 0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.749950000000001, 0.04167499999999991}, {
     4.000000000000001, 0.}, {3.749950000000001, -0.04167500000000013}}], 
    {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
     DiskBox[{-2.999999999999999, 0.}, {0.125025, 0.041675}, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], CircleBox[{-2.999999999999999, 0.}, {0.125025, 0.041675}, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
     {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
      DiskBox[{-1.9999999999999991`, 0.}, {0.125025, 0.041675}, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], CircleBox[{-1.9999999999999991`, 0.}, {0.125025, 0.041675}, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
      {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
       DiskBox[{-0.9999999999999991, 0.}, {0.125025, 0.041675}, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], CircleBox[{-0.9999999999999991, 0.}, {0.125025, 0.041675}, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
       {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
        DiskBox[{8.881784197001252*^-16, 0.}, {0.125025, 0.041675}, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], CircleBox[{8.881784197001252*^-16, 0.}, {0.125025, 0.041675}, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
        {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
         DiskBox[{1.0000000000000009`, 0.}, {0.125025, 0.041675}, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], CircleBox[{1.0000000000000009`, 0.}, {0.125025, 0.041675}, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
         {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
          DiskBox[{2.000000000000001, 0.}, {0.125025, 0.041675}, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          CircleBox[{2.000000000000001, 0.}, {0.125025, 0.041675}, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
          {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
           DiskBox[{3.000000000000001, 0.}, {0.125025, 0.041675}, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           CircleBox[{3.000000000000001, 0.}, {0.125025, 0.041675}, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-2.9499999999999993`, 0.1}, {-2.049999999999999, 0.1}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-2.175024999999998, 
            0.12778333333333336`}, {-2.049999999999998, 
            0.09999999999999987}, {-2.175024999999998, 0.0722166666666666}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-2.824974999999999, 
            0.0722166666666666}, {-2.949999999999999, 
            0.09999999999999987}, {-2.824974999999999, 
            0.12778333333333336`}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-1.949999999999999, 0.1}, {-1.0499999999999992`, 0.1}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-1.1750249999999989`, 
            0.12778333333333336`}, {-1.049999999999998, 
            0.09999999999999987}, {-1.1750249999999989`, 
            0.0722166666666666}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-1.8249749999999985`, 
            0.0722166666666666}, {-1.9499999999999984`, 
            0.09999999999999987}, {-1.8249749999999985`, 
            0.12778333333333336`}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-0.9499999999999991, 0.1}, {-0.049999999999999115`, 
            0.1}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-0.17502499999999888`, 
            0.12778333333333336`}, {-0.049999999999998934`, 
            0.09999999999999987}, {-0.17502499999999888`, 
            0.0722166666666666}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{-0.8249749999999985, 
            0.0722166666666666}, {-0.9499999999999984, 
            0.09999999999999987}, {-0.8249749999999985, 
            0.12778333333333336`}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{0.05000000000000089, 0.1}, {0.9500000000000008, 0.1}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{0.8249750000000011, 0.12778333333333336`}, {
            0.9500000000000011, 0.09999999999999987}, {0.8249750000000011, 
            0.0722166666666666}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{0.17502500000000154`, 0.0722166666666666}, {
            0.0500000000000016, 0.09999999999999987}, {0.17502500000000154`, 
            0.12778333333333336`}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{1.050000000000001, 0.1}, {1.9500000000000008`, 0.1}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{1.8249750000000011`, 0.12778333333333336`}, {
            1.950000000000002, 0.09999999999999987}, {1.8249750000000011`, 
            0.0722166666666666}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{1.1750250000000015`, 0.0722166666666666}, {
            1.0500000000000016`, 0.09999999999999987}, {1.1750250000000015`, 
            0.12778333333333336`}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{2.0500000000000007`, 0.1}, {2.950000000000001, 0.1}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{2.824975000000003, 0.12778333333333336`}, {
            2.9500000000000037`, 0.09999999999999987}, {2.824975000000003, 
            0.0722166666666666}}]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           LineBox[{{2.1750250000000007`, 0.0722166666666666}, {
            2.0500000000000016`, 0.09999999999999987}, {2.1750250000000007`, 
            0.12778333333333336`}}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TagBox[
                StyleBox["\<\"M\"\>",
                 FontSlant->"Italic"],
                StyleForm[#, FontSlant -> "Italic"]& ],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.000000000000001, 0.}, {-1, 0}, Automatic, {1., 
            0.}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"-\"",TagBox[
                  StyleBox["\"J\"", FontSlant -> "Italic"], 
                  StyleForm[#, FontSlant -> "Italic"]& ]},
                "Row",
                DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], "]"}]& )],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-2.999999999999999, -0.041675}, {0, 1}, 
            Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[CenterEllipsis]\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {8.881784197001252*^-16, -0.041675}, {0, 1}, 
            Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{TagBox[
                  StyleBox["\"J\"", FontSlant -> "Italic"], 
                  StyleForm[#, FontSlant -> "Italic"]& ],"\"-1\""},
                "Row",
                DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], "]"}]& )],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {2.000000000000001, -0.041675}, {0, 1}, 
            Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{TagBox[
                  StyleBox["\"J\"", FontSlant -> "Italic"], 
                  StyleForm[#, FontSlant -> "Italic"]& ]},
                "Row",
                DisplayFunction->(#& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", #, "}"}], "]"}]& )],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {3.000000000000001, -0.041675}, {0, 1}, 
            Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               SubscriptBox[
                TagBox[
                 StyleBox["\<\"J\"\>",
                  FontSlant->"Italic"],
                 
                 StyleForm[#, FontSlant -> 
                  "Italic"]& ], "\<\"\[PlusMinus]\"\>"],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->RGBColor[0.698004, 0.133305, 0.133305],
              FontOpacity->1],
             DisplayForm], {-2.4999999999999987`, 0.09999999999999987}, {0, -1},
             Automatic, {1., 0.}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               SubscriptBox[
                TagBox[
                 StyleBox["\<\"J\"\>",
                  FontSlant->"Italic"],
                 
                 StyleForm[#, FontSlant -> 
                  "Italic"]& ], "\<\"\[PlusMinus]\"\>"],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->RGBColor[0.698004, 0.133305, 0.133305],
              FontOpacity->1],
             DisplayForm], {-1.4999999999999991`, 0.09999999999999987}, {0, -1},
             Automatic, {1., 0.}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               SubscriptBox[
                TagBox[
                 StyleBox["\<\"J\"\>",
                  FontSlant->"Italic"],
                 
                 StyleForm[#, FontSlant -> 
                  "Italic"]& ], "\<\"\[PlusMinus]\"\>"],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->RGBColor[0.698004, 0.133305, 0.133305],
              FontOpacity->1],
             DisplayForm], {-0.4999999999999982, 0.09999999999999987}, {0, -1},
             Automatic, {1., 0.}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               SubscriptBox[
                TagBox[
                 StyleBox["\<\"J\"\>",
                  FontSlant->"Italic"],
                 
                 StyleForm[#, FontSlant -> 
                  "Italic"]& ], "\<\"\[PlusMinus]\"\>"],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->RGBColor[0.698004, 0.133305, 0.133305],
              FontOpacity->1],
             DisplayForm], {0.5000000000000018, 0.09999999999999987}, {0, -1},
             Automatic, {1., 0.}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               SubscriptBox[
                TagBox[
                 StyleBox["\<\"J\"\>",
                  FontSlant->"Italic"],
                 
                 StyleForm[#, FontSlant -> 
                  "Italic"]& ], "\<\"\[PlusMinus]\"\>"],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->RGBColor[0.698004, 0.133305, 0.133305],
              FontOpacity->1],
             DisplayForm], {1.5000000000000018`, 0.09999999999999987}, {0, -1},
             Automatic, {1., 0.}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               SubscriptBox[
                TagBox[
                 StyleBox["\<\"J\"\>",
                  FontSlant->"Italic"],
                 
                 StyleForm[#, FontSlant -> 
                  "Italic"]& ], "\<\"\[PlusMinus]\"\>"],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->RGBColor[0.698004, 0.133305, 0.133305],
              FontOpacity->1],
             DisplayForm], {2.5000000000000027`, 0.09999999999999987}, {0, -1},
             Automatic, {1., 0.}]}}}}}}}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{288, 144},
  PlotRange->{{-6.0012, 6.0012}, {-1.0002, 1.0002}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.489886083796875*^9, 3.48988625875*^9}, {
   3.4898863718125*^9, 3.48988639484375*^9}, 3.492724776921875*^9, 
   3.5255278825625*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dipole-dipole interaction: Ellipses and arrows", "Section",
 CellChangeTimes->{{3.441571665177*^9, 3.44157167364575*^9}, {
  3.495659242078125*^9, 3.495659253296875*^9}, {3.495659289125*^9, 
  3.4956592956875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeArrow", ",", 
       RowBox[{"Thickness", "\[Rule]", "1"}], ",", 
       RowBox[{"PosnC", "\[Rule]", "1"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeEllipse", ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}], ",", 
       RowBox[{"ShowHead", "\[Rule]", "True"}], ",", 
       RowBox[{"HeadLength", "\[Rule]", "3"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "4"}], ",", 
       RowBox[{"Thickness", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"sa", "=", "0.3"}], ",", "\[IndentingNewLine]", 
     RowBox[{"rs", "=", "0.1"}], ",", "\[IndentingNewLine]", 
     RowBox[{"rl", "=", "0.2"}], ",", "\[IndentingNewLine]", 
     RowBox[{"P1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"P2", "=", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{"P1", ",", 
       RowBox[{"Point", "[", "2", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"P1", "+", 
        RowBox[{"Polar", "@", 
         RowBox[{"{", 
          RowBox[{"sa", ",", 
           RowBox[{
            RowBox[{"-", "Pi"}], "/", "2"}]}], "}"}]}]}], ",", 
       RowBox[{"P1", "+", 
        RowBox[{"Polar", "@", 
         RowBox[{"{", 
          RowBox[{"sa", ",", 
           RowBox[{
            RowBox[{"+", "Pi"}], "/", "2"}]}], "}"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabC", "\[Rule]", 
        RowBox[{"SubscriptBox", "[", 
         RowBox[{
          RowBox[{"textbf", "[", "\"\<m\>\"", "]"}], ",", "\"\<1\>\""}], 
         "]"}]}], ",", 
       RowBox[{"OffsetC", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], ",", 
       RowBox[{"OrientationC", "\[Rule]", "Horizontal"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeEllipse", "[", 
      RowBox[{"P1", ",", 
       RowBox[{"{", 
        RowBox[{"rl", ",", "rs"}], "}"}], ",", "0"}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{"P2", ",", 
       RowBox[{"Point", "[", "2", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"P2", "+", 
        RowBox[{"Polar", "@", 
         RowBox[{"{", 
          RowBox[{"sa", ",", "Pi"}], "}"}]}]}], ",", 
       RowBox[{"P2", "+", 
        RowBox[{"Polar", "@", 
         RowBox[{"{", 
          RowBox[{"sa", ",", "0"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabC", "\[Rule]", 
        RowBox[{"SubscriptBox", "[", 
         RowBox[{
          RowBox[{"textbf", "[", "\"\<m\>\"", "]"}], ",", "\"\<2\>\""}], 
         "]"}]}], ",", 
       RowBox[{"OffsetC", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.5"}], ",", "0"}], "}"}]}], ",", 
       RowBox[{"OrientationC", "\[Rule]", "Horizontal"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeEllipse", "[", 
      RowBox[{"P2", ",", 
       RowBox[{"{", 
        RowBox[{"rl", ",", "rs"}], "}"}], ",", 
       RowBox[{"Pi", "/", "2"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{"P2", ",", "0.5", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
       RowBox[{"ShowTail", "\[Rule]", "True"}], ",", 
       RowBox[{"LabX", "\[Rule]", "\"\<\[Theta]\>\""}], ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}], ",", 
       RowBox[{"HeadLength", "\[Rule]", "3"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeLine", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2"}], "}"}], ",", 
       RowBox[{"Dashing", "\[Rule]", "True"}]}], "]"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ExtendRange", "\[Rule]", "0.2"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"8", ",", "4"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.400339538875*^9, 3.400339641125*^9}, 
   3.40033967371875*^9, {3.400339770671875*^9, 3.4003400125625*^9}, {
   3.410558353359375*^9, 3.41055836778125*^9}, {3.410558452890625*^9, 
   3.410558714703125*^9}, {3.41055889328125*^9, 3.41055892746875*^9}, {
   3.4105589676875*^9, 3.410558992125*^9}, {3.41055937271875*^9, 
   3.41055937871875*^9}, {3.410559421546875*^9, 3.41055982309375*^9}, {
   3.441571567677*^9, 3.441571576677*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], Opacity[1], 
    DiskBox[{-2.220446049250313*^-16, 0.}, 0.01944833333333333, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], CircleBox[{-2.220446049250313*^-16, 0.}, 0.01944833333333333, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.220446049250313*^-16, -0.2999999999999998}, \
{-2.220446049250313*^-16, 0.30000000000000004`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.029172500000000268`, 
     0.24165500000000018`}, {-2.220446049250313*^-16, 0.30000000000000004`}, {
     0.029172499999999824`, 0.24165500000000018`}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[CompressedData["
1:eJxdlF1IU2EYx8dYhllETPuSxI1AkCQkBMnqUZlG4EUJFuT8yEoFxYXdKMay
C6UPS4fWZh9o4NdyTt2Y2zT7k9U2M7sQTJEsupDU7Ea6ENsg3dt78xw4HF7O
Oe/7PP//7/lrSgy515UKhUK/dW8/W9q3r0lS/L+OR2jjDJcnqbvjbvNgQRNN
rL06EtsdoPy5QsVt1zOKWl5OOtXsp7lFk3p1ZxcdLvzQtzfFR9H1f1TWGitp
EtIibzreU755LHdFYyd39mxledw72jQe3ciMGKZIZ1bwwb23VK4p+azrcVBy
VWA9KgTaM7/YGhNy0le7IdQfMU6NY2c2HPtdpP6ZmFGVMkp56dO3foRc9LDj
mO3RfTcpX8fr/WMjdOV3afG4ykVL52pHVy+5SXe1Izr9pYM2p7V2/bybzv+t
e2HVD5EuTWdez/BQ2UKRwlRqo4ufMnxGi4caV/rbpjL76KBFmar87qEJdY95
KruLahu0vbMHvGRcG7LZKjpJ+2RX6kedlx6rvnj9ee2UFF8RyCzzUlPrQkJ1
0EQF36r2na330kiR8+SSsYGqLVmDphYvDVhqZnKeVlLd6Zxf7Zat9fPwGnI9
Uhz+HvL73W3h/SD3i9kRPg/yvDeiHsh6lNHheiHr9Yl+IPvpFf1C9ntD6AGp
xzWhF6Red4SekHoOCL0h9T4h/ID0Iyj8gvTrgvAT0s9Dwm9Iv/2CB0gekgUv
kLwkCp4geYoVvEHyNiN4hOSRBK+QvHYKniF5Zu/B/gfbH+x8sPrA6gfrD6x/
MH3A9APTF0x/MH/A/APzF8x/MD7A+AHjC4w/MD7B+AXjG4x/sPkAmx+w+QKb
P7D5BJtfsPkGm3+wfADLD7B8AcsfsHwCyy+wfAPLP7B8BMtPsHwFy1/wfObr
f0gD6qg=
     "]]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[None]
    , LineBox[{{0.16110333333333293`, -0.029172499999999824`}, {
     0.19999999999999973`, 2.220446049250313*^-16}, {
     0.2388966666666663, -0.029172499999999824`}}], 
    {GrayLevel[0], Opacity[1], 
     DiskBox[{1.4999999999999996`, 0.}, 0.01944833333333333, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], CircleBox[{1.4999999999999996`, 0.}, 0.01944833333333333, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{1.1999999999999997`, 2.220446049250313*^-16}, {
      1.7999999999999998`, 2.220446049250313*^-16}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{1.7416549999999997`, 0.029172500000000268`}, {
      1.7999999999999998`, 2.220446049250313*^-16}, {
      1.7416549999999997`, -0.029172499999999824`}}]}, 
    {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[CompressedData["
1:eJxdlGlIlFEUhjUlCKHJlHaVRsg0yx9lu72VZVEGFSYt0kxptowoWpllplkW
KhlD02KajlSTpS3MtFnaNc1cf1g2U4RK2DbSaBZyZy5qpT+6P86Fj4/Dvd+5
533fh2/67oTNe0Y5OTlFDT8j7z9/R5YdV/JHViNY7yf9qno7FoxWeidsb0TJ
6T8uAVo7mmx3vKbebIAiMfp+tcoOD6t19tLz9Rja8eHJ4nl2KHfWlSqCXyPU
98CjvrF2+PstGXPQ+Apjn6a1FvzkYGHmuH3etbB2TDYVmDncTasHc7NfIk1Z
Y5hTzbEivuG32xBDmOfxVt09Dtu9hKGy0VUQs+Zap+s5fL8HrIgPfoZl/SE5
oTqOa8WB5Xk5T6DWbI04mcOR2BOrrnJ9BO82r+BjmRwR0cWey0uMWFeZa/mU
yqEeSL12O+oBFn0u8EhJ5jj7UeWkjS3HcUt6uyKJw9BdpmteWQrD+3M3M+M5
ujwMl5vDbqAwMj3KpOEosj0oL9foMbDhaFvufg6zq6Wifks+Jo3vzhvYy9Fy
4aNf0qAWRwxuX3ksx3y1afHXE1mYsXT9ruTh+u7VlLfhV+Nozch5Rvoxch8j
8zAyLyN6GNHLiB+M+MWIn4z4zUgejOTFSJ6M5M0ID4zwwghPjPDGCI+M8MoI
zyzE3Uf1fKFD7u9IdR40xzvk9z15hRuhd8j+f6/7ra1rdsj7K9ovrlP8csj5
etdkBsWME3J+T+W38JgAIfWld4RsewMh9T/+cSpIs0lIf1zetUzsVAnp3wu3
msOVGiH9LdTdKjtxWEj/OwO7mrLShMzHGHrI3+e0kPnVTouxnc0WMt8M/wzf
vnNC5h85M2l7mlZIPtS3M66H64Tkx9l4JvDQJSH5+tIzIdH1ipD8ZW3rnzIm
X0g+LbUPi7KH6//8khrkPEg/kPtA5gGZF0QPiF4QP0D8AvETxG+QPEDyAskT
JG8QHkB4AeEJhDcQHkF4Bf0/0/of+g4UOQ==
      "]]}, 
    {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{1.5291724999999996`, 0.16110333333333338`}, {
      1.4999999999999996`, 0.20000000000000018`}, {1.5291724999999996`, 
      0.23889666666666676`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], CircleBox[{1.4999999999999996`, 0.}, 0.49999999999999994`, 
      NCache[{0, Rational[1, 2] Pi}, {0, 1.5707963267948966`}]]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{2.0291724999999996`, 0.029172500000000268`}, {
      1.9999999999999996`, 2.220446049250313*^-16}, {1.9708274999999995`, 
      0.029172500000000268`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}], 
     CapForm[None], 
     LineBox[{{-2.220446049250313*^-16, 0.}, {1.4999999999999996`, 0.}}], 
     InsetBox[
      TagBox[
       StyleBox[
        TagBox[
         SubscriptBox[
          TagBox[
           StyleBox["\<\"m\"\>",
            FontWeight->"Bold"],
           StyleForm[#, FontWeight -> "Bold"]& ], "1"],
         DisplayForm],
        StripOnInput->False,
        ShowAutoStyles->False,
        SingleLetterItalics->False,
        FontFamily->"Times",
        FontSize->12,
        FontWeight->"Plain",
        FontSlant->"Plain",
        FontTracking->"Plain",
        FontColor->GrayLevel[0],
        FontOpacity->1],
       DisplayForm], {-2.220446049250313*^-16, 0.30000000000000004`}, {0, -1},
       Automatic, {1, 0}], InsetBox[
      TagBox[
       StyleBox[
        TagBox[
         SubscriptBox[
          TagBox[
           StyleBox["\<\"m\"\>",
            FontWeight->"Bold"],
           StyleForm[#, FontWeight -> "Bold"]& ], "2"],
         DisplayForm],
        StripOnInput->False,
        ShowAutoStyles->False,
        SingleLetterItalics->False,
        FontFamily->"Times",
        FontSize->12,
        FontWeight->"Plain",
        FontSlant->"Plain",
        FontTracking->"Plain",
        FontColor->GrayLevel[0],
        FontOpacity->1],
       DisplayForm], {1.7999999999999998`, 2.220446049250313*^-16}, {-1.5, 0},
       Automatic, {1, 0}], InsetBox[
      TagBox[
       StyleBox[
        TagBox["\<\"\[Theta]\"\>",
         DisplayForm],
        StripOnInput->False,
        ShowAutoStyles->False,
        SingleLetterItalics->False,
        FontFamily->"Times",
        FontSize->12,
        FontWeight->"Plain",
        FontSlant->"Plain",
        FontTracking->"Plain",
        FontColor->GrayLevel[0],
        FontOpacity->1],
       DisplayForm], {1.9023731623521294`, 0.4023731623521298}, {0, 0}, 
      Automatic, {0.7071067811865475, -0.7071067811865476}]}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{576, 288},
  PlotRange->{{-1.80056, 3.80056}, {-1.40028, 1.40028}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.488839177921875*^9, 3.525527882953125*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Internal reflection", "Section",
 CellChangeTimes->{{3.4818133868125*^9, 3.481813394375*^9}, 
   3.482108535609375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LineEndpoints", "[", 
    RowBox[{"theta_", ",", "d_", ",", 
     RowBox[{"{", 
      RowBox[{"L1_", ",", "L2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"d", "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "theta", "]"}], ",", 
         RowBox[{"Sin", "[", "theta", "]"}]}], "}"}]}], "+", 
      RowBox[{"L1", "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
         RowBox[{"Cos", "[", "theta", "]"}]}], "}"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d", "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "theta", "]"}], ",", 
         RowBox[{"Sin", "[", "theta", "]"}]}], "}"}]}], "+", 
      RowBox[{"L2", "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
         RowBox[{"Cos", "[", "theta", "]"}]}], "}"}]}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.481813936078125*^9, 3.48181395778125*^9}, {
  3.481814074265625*^9, 3.4818141066875*^9}, {3.481814147359375*^9, 
  3.481814186734375*^9}, {3.481814434578125*^9, 3.48181446075*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"zm", "=", "2.5"}], ",", "\[IndentingNewLine]", 
     RowBox[{"zme", "=", 
      RowBox[{"0.4", "*", "zm"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"xm", "=", "1.5"}], ",", "\[IndentingNewLine]", 
     RowBox[{"head", "=", "0.1"}], ",", "\[IndentingNewLine]", 
     RowBox[{"lambda", "=", "0.15"}], ",", "\[IndentingNewLine]", 
     RowBox[{"side", "=", 
      RowBox[{"xm", "*", 
       RowBox[{"Cos", "[", "theta", "]"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"infinity", "=", "999"}], ",", "\[IndentingNewLine]", 
     RowBox[{"theta", "=", 
      RowBox[{"45", "*", "Degree"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"nj", "=", "10"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeArrow", ",", 
       RowBox[{"HeadLength", "\[Rule]", "4"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeAxis", ",", 
       RowBox[{"HeadLength", "\[Rule]", "4"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "axes", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"SchemeAxis", "[", 
      RowBox[{"Bottom", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"zm", "+", "head"}]}], "}"}], ",", "0", ",", 
       RowBox[{"LabB", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<z\>\"", "]"}]}], ",", 
       RowBox[{"PosnB", "\[Rule]", "1"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeAxis", "[", 
      RowBox[{"Left", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "xm"}], ",", 
         RowBox[{"xm", "+", "head"}]}], "}"}], ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<x\>\"", "]"}]}], ",", 
       RowBox[{"PosnL", "\[Rule]", "1"}], ",", 
       RowBox[{"OrientationL", "\[Rule]", "Horizontal"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeBox", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "zm"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "xm"}], ",", "xm"}], "}"}]}], "}"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "LightGray"}], ",", 
       RowBox[{"ShowLine", "\[Rule]", "False"}], ",", 
       RowBox[{"Layer", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeArrow", ",", 
       RowBox[{"BackgroundL", "\[Rule]", "LightGray"}], ",", 
       RowBox[{"BufferL", "\[Rule]", "1.3"}], ",", 
       RowBox[{"Thickness", "\[Rule]", "2"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeLine", ",", 
       RowBox[{"Thickness", "\[Rule]", "0.5"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"plane", " ", "waves"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "clip", " ", "wavefronts", " ", "to", " ", "region", " ", "with", " ", 
       "SetRegion"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"SetRegion", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "zm"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "xm"}], ",", "xm"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "zm"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "xm"}], ",", "xm"}], "}"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SchemeLine", "[", 
        RowBox[{"LineEndpoints", "[", 
         RowBox[{"theta", ",", 
          RowBox[{"lambda", "*", "i"}], ",", 
          RowBox[{"{", 
           RowBox[{"side", ",", 
            RowBox[{"-", "infinity"}]}], "}"}]}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SchemeLine", "[", 
        RowBox[{"LineEndpoints", "[", 
         RowBox[{
          RowBox[{"-", "theta"}], ",", 
          RowBox[{"lambda", "*", "i"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "side"}], ",", "infinity"}], "}"}]}], "]"}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SetRegion", "[", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Polar", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "theta"}], "}"}], "]"}], ",", 
         RowBox[{"Polar", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "side"}], ",", "theta"}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"textbf", "[", "\"\<k\>\"", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"Reverse", "@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Polar", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", 
             RowBox[{"-", "theta"}]}], "}"}], "]"}], ",", 
          RowBox[{"Polar", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "side"}], ",", 
             RowBox[{"-", "theta"}]}], "}"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"SuperPrime", "[", 
         RowBox[{
          RowBox[{"textbf", "[", "\"\<k\>\"", "]"}], ",", "2"}], "]"}]}]}], 
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"evanescent", " ", "wave"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"SetRegion", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "zm"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "xm"}], ",", "xm"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "zm"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "xm"}], ",", "xm"}], "}"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SchemeLine", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"zme", "/", "nj"}], "*", 
              RowBox[{"(", 
               RowBox[{"j", "-", "1"}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"lambda", "/", 
               RowBox[{"Sin", "[", "theta", "]"}]}], "*", "i"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"zme", "/", "nj"}], "*", "j"}], ",", 
             RowBox[{
              RowBox[{"lambda", "/", 
               RowBox[{"Sin", "[", "theta", "]"}]}], "*", "i"}]}], "}"}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"LineColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", 
           RowBox[{"j", "/", "nj"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Show", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"i", "!=", "0"}], ")"}]}]}], "\[IndentingNewLine]", "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "nj"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SetRegion", "[", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"zme", ",", 
         RowBox[{"0.5", "*", "xm"}]}], "}"}], ",", 
       RowBox[{"SuperPrime", "[", 
        RowBox[{"OverTilde", "[", 
         RowBox[{"textbf", "[", "\"\<k\>\"", "]"}], "]"}], "]"}]}], "]"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "0.85"}], "*", "zm"}], ",", 
         RowBox[{
          RowBox[{"-", "0.2"}], "*", "xm"}]}], "}"}], ",", 
       RowBox[{"Subscript", "[", 
        RowBox[{
         RowBox[{"textit", "[", "\"\<n\>\"", "]"}], ",", "\"\<1\>\""}], 
        "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ManualLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"+", "0.85"}], "*", "zm"}], ",", 
         RowBox[{
          RowBox[{"-", "0.2"}], "*", "xm"}]}], "}"}], ",", 
       RowBox[{"Subscript", "[", 
        RowBox[{
         RowBox[{"textit", "[", "\"\<n\>\"", "]"}], ",", "\"\<2\>\""}], 
        "]"}]}], "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeArrow", ",", 
       RowBox[{"Thickness", "\[Rule]", "1"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"0.3", "*", "zm"}], ",", 
            RowBox[{
             RowBox[{"-", "0.5"}], "*", "xm"}]}], "}"}], "+", 
          RowBox[{"{", 
           RowBox[{"0.4", ",", 
            RowBox[{"-", "0.2"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"0.3", "*", "zm"}], ",", 
           RowBox[{
            RowBox[{"-", "0.5"}], "*", "xm"}]}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabT", "\[Rule]", 
        RowBox[{"StackText", "[", 
         RowBox[{"Center", ",", "0", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<Evanescent\>\"", ",", "\"\<wave\>\""}], "}"}]}], 
         "]"}]}], ",", 
       RowBox[{"OrientationT", "\[Rule]", "Horizontal"}], ",", 
       RowBox[{"OffsetT", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1"}], ",", 
          RowBox[{"+", "1"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", "0.75", "*", 
     RowBox[{"{", 
      RowBox[{"6", ",", "4"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.400339538875*^9, 3.400339641125*^9}, 
   3.40033967371875*^9, {3.400339770671875*^9, 3.4003400125625*^9}, {
   3.40034057915625*^9, 3.400340757515625*^9}, {3.40034081134375*^9, 
   3.400341004390625*^9}, {3.40284428675*^9, 3.402844347046875*^9}, {
   3.40284438971875*^9, 3.402844707515625*^9}, {3.40680969346875*^9, 
   3.4068099673125*^9}, {3.406835998875*^9, 3.406836068671875*^9}, {
   3.4343079153125*^9, 3.434308117078125*^9}, {3.438374458280198*^9, 
   3.438374461327073*^9}, {3.438374765061448*^9, 3.438375054295823*^9}, 
   3.465677031109375*^9, {3.4656770730625*^9, 3.465677285875*^9}, {
   3.46567840534375*^9, 3.46567871090625*^9}, {3.4657214805625*^9, 
   3.465721495109375*^9}, {3.465723373375*^9, 3.465723432734375*^9}, {
   3.465723463859375*^9, 3.465723504140625*^9}, {3.465723536421875*^9, 
   3.4657235808125*^9}, {3.465723622546875*^9, 3.4657237045625*^9}, {
   3.465723899671875*^9, 3.465723909484375*^9}, {3.465723943609375*^9, 
   3.465724152234375*^9}, {3.46572430209375*^9, 3.4657245648125*^9}, {
   3.465724609859375*^9, 3.465724686015625*^9}, 3.4657247286875*^9, {
   3.465724810765625*^9, 3.465724940796875*^9}, 3.465724994375*^9, 
   3.4657250260625*^9, {3.46572513190625*^9, 3.465725228921875*^9}, 
   3.46572537428125*^9, {3.465725608421875*^9, 3.4657263133125*^9}, {
   3.46572662571875*^9, 3.4657269748125*^9}, {3.465729455828125*^9, 
   3.465729466046875*^9}, {3.469956861*^9, 3.469957021546875*^9}, {
   3.46995767309375*^9, 3.469957726671875*^9}, {3.46995776421875*^9, 
   3.46995777453125*^9}, {3.469957852875*^9, 3.46995797765625*^9}, {
   3.4749012973125*^9, 3.474901336515625*^9}, {3.474901370859375*^9, 
   3.474901372515625*^9}, {3.474901418640625*^9, 3.474901421078125*^9}, {
   3.474901488703125*^9, 3.474901824984375*^9}, {3.4749028675625*^9, 
   3.47490288171875*^9}, {3.475419584640625*^9, 3.4754196073125*^9}, {
   3.47541963840625*^9, 3.475419653484375*^9}, {3.4754196881875*^9, 
   3.475420094546875*^9}, {3.47542012846875*^9, 3.4754202186875*^9}, {
   3.475420261515625*^9, 3.47542035315625*^9}, {3.475420803921875*^9, 
   3.4754210959375*^9}, {3.47903126865625*^9, 3.4790314976875*^9}, {
   3.48085512759375*^9, 3.48085528175*^9}, {3.48085536146875*^9, 
   3.48085554375*^9}, {3.48085557909375*^9, 3.48085576815625*^9}, {
   3.48085581309375*^9, 3.480855864328125*^9}, {3.480855909265625*^9, 
   3.48085600040625*^9}, {3.480856053453125*^9, 3.480856057171875*^9}, {
   3.481813414953125*^9, 3.481813673515625*^9}, {3.481813752328125*^9, 
   3.481813814421875*^9}, {3.481813851890625*^9, 3.481813934109375*^9}, {
   3.481814200515625*^9, 3.481814316265625*^9}, {3.481814361578125*^9, 
   3.481814398296875*^9}, {3.481814465296875*^9, 3.481814481234375*^9}, {
   3.4818145763125*^9, 3.481814622546875*^9}, {3.481814717203125*^9, 
   3.481814720203125*^9}, {3.481814758671875*^9, 3.4818148053125*^9}, {
   3.481814883015625*^9, 3.481815109484375*^9}, {3.48181513975*^9, 
   3.481815168203125*^9}, {3.4818152449375*^9, 3.481815439078125*^9}, {
   3.48181548884375*^9, 3.48181555653125*^9}, {3.481815595625*^9, 
   3.481815632109375*^9}, {3.481815667359375*^9, 3.481815673546875*^9}, {
   3.4818157098125*^9, 3.481815761875*^9}, {3.48181579925*^9, 
   3.481815808046875*^9}, {3.481816322765625*^9, 3.481816588671875*^9}, {
   3.481816647171875*^9, 3.48181665028125*^9}, {3.4818168593125*^9, 
   3.481816861328125*^9}, {3.482107918984375*^9, 3.48210798253125*^9}, {
   3.482108015046875*^9, 3.4821081316875*^9}, {3.482108173109375*^9, 
   3.48210830775*^9}, {3.4821085515*^9, 3.482108562078125*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.85], Opacity[1], 
    PolygonBox[{{-2.4999999999999996`, -1.5}, {-2.4999999999999996`, 1.5}, {
     4.440892098500626*^-16, 1.5}, {4.440892098500626*^-16, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{4.440892098500626*^-16, 0.}, {2.6000000000000005`, 
     0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.5259111111111117`, 0.03704444444444421}, {2.6, 0.}, {
     2.5259111111111117`, -0.037044444444444435`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{4.440892098500626*^-16, -1.5}, {4.440892098500626*^-16, 
     1.6}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.03704444444444421, 1.5259111111111112`}, {
     4.440892098500626*^-16, 1.6}, {0.03704444444444466, 
     1.5259111111111112`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.5, -1.3183766184073558`}, {-2.3183766184073558`, \
-1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.5, -1.106244584051392}, {-2.106244584051392, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.447056274847714, -0.9470562748477139}, \
{-1.8941125496954276`, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.340990257669732, -0.840990257669732}, \
{-1.6819805153394638`, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.2349242404917495`, -0.7349242404917499}, \
{-1.4698484809834995`, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.1288582233137676`, -0.6288582233137677}, \
{-1.2577164466275352`, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.0227922061357853`, -0.5227922061357854}, \
{-1.0455844122715705`, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.9167261889578033`, -0.41672618895780345`}, \
{-0.8334523779156067, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.810660171779821, -0.3106601717798213}, \
{-0.6213203435596424, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.7045941546018388`, -0.20459415460183905`}, \
{-0.4091883092036779, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.5985281374238567`, -0.09852813742385702}, \
{-0.19705627484771382`, -1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.4924621202458748`, 0.00753787975412501}, {
      0, -1.4849242404917498`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.3863961030678924`, 0.11360389693210726`}, {
      0, -1.2727922061357853`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.2803300858899105`, 0.2196699141100893}, {
      0, -1.0606601717798212`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.1742640687119283`, 0.32573593128807143`}, {
      0, -0.8485281374238569}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.0681980515339462`, 0.4318019484660536}, {
      0, -0.6363961030678926}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.9621320343559641, 0.5378679656440357}, {
      0, -0.42426406871192834`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.856066017177982, 0.6439339828220177}, {
      0, -0.21213203435596428`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.7499999999999999, 0.7499999999999999}, {0, 0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.6439339828220177, 0.856066017177982}, {
      0, 0.21213203435596428`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.5378679656440357, 0.9621320343559641}, {
      0, 0.42426406871192834`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.4318019484660536, 1.0681980515339462`}, {
      0, 0.6363961030678925}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.32573593128807143`, 1.1742640687119283`}, {
      0, 0.8485281374238569}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.2196699141100893, 1.2803300858899105`}, {
      0, 1.0606601717798212`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.11360389693210726`, 1.3863961030678924`}, {
      0, 1.2727922061357853`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.00753787975412501, 1.4924621202458748`}, {
      0, 1.4849242404917498`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.5, 1.3183766184073558`}, {-2.3183766184073558`, 
     1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.5, 1.106244584051392}, {-2.106244584051392, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.447056274847714, 
     0.9470562748477139}, {-1.8941125496954276`, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.340990257669732, 
     0.840990257669732}, {-1.6819805153394638`, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], 
    LineBox[{{-2.2349242404917495`, 
     0.7349242404917499}, {-1.4698484809834995`, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.1288582233137676`, 
     0.6288582233137677}, {-1.2577164466275352`, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-2.0227922061357853`, 
     0.5227922061357854}, {-1.0455844122715705`, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.9167261889578033`, 
     0.41672618895780345`}, {-0.8334523779156067, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.810660171779821, 
     0.3106601717798213}, {-0.6213203435596424, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.7045941546018388`, 
     0.20459415460183905`}, {-0.4091883092036779, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.5985281374238567`, 
     0.09852813742385702}, {-0.19705627484771382`, 1.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.4924621202458748`, -0.00753787975412501}, {
      0, 1.4849242404917498`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.3863961030678924`, -0.11360389693210726`}, {
      0, 1.2727922061357853`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.2803300858899105`, -0.2196699141100893}, {
      0, 1.0606601717798212`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.1742640687119283`, -0.32573593128807143`}, {
      0, 0.8485281374238569}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], 
    LineBox[{{-1.0681980515339462`, -0.4318019484660536}, {
      0, 0.6363961030678926}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.9621320343559641, -0.5378679656440357}, {
      0, 0.42426406871192834`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.856066017177982, -0.6439339828220177}, {
      0, 0.21213203435596428`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.7499999999999999, -0.7499999999999999}, {0, 0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.6439339828220177, -0.856066017177982}, {
      0, -0.21213203435596428`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.5378679656440357, -0.9621320343559641}, {
      0, -0.42426406871192834`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.4318019484660536, -1.0681980515339462`}, {
      0, -0.6363961030678925}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.32573593128807143`, -1.1742640687119283`}, {
      0, -0.8485281374238569}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.2196699141100893, -1.2803300858899105`}, {
      0, -1.0606601717798212`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.11360389693210726`, -1.3863961030678924`}, {
      0, -1.2727922061357853`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.00753787975412501, -1.4924621202458748`}, {
      0, -1.4849242404917498`}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.4142135623730947`, -1.4142135623730954`}, \
{-0.7499999999999996, -0.7499999999999998}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.8285831336158647, -0.7761943778719549}, \
{-0.7499999999999996, -0.7499999999999998}, {-0.7761943778719544, \
-0.8285831336158649}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.7499999999999996, 0.75}, {-1.4142135623730947`, 
     1.414213562373095}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.3880191845011398`, 
     1.3356304287572298`}, {-1.4142135623730947`, 
     1.414213562373095}, {-1.3356304287572296`, 1.38801918450114}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., -1.4849242404917498`}, {0.1, -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, -1.4849242404917498`}, {0.2, -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, -1.4849242404917498`}, {
     0.30000000000000004`, -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, -1.4849242404917498`}, {
     0.4, -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, -1.4849242404917498`}, {0.5, -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, -1.4849242404917498`}, {
     0.6000000000000001, -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, -1.4849242404917498`}, {
     0.7000000000000001, -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, -1.4849242404917498`}, {
     0.8, -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, -1.4849242404917498`}, {0.9, -1.4849242404917498`}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, -1.4849242404917498`}, {
     1., -1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., -1.2727922061357855`}, {0.1, -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, -1.2727922061357855`}, {0.2, -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, -1.2727922061357855`}, {
     0.30000000000000004`, -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, -1.2727922061357855`}, {
     0.4, -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, -1.2727922061357855`}, {0.5, -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, -1.2727922061357855`}, {
     0.6000000000000001, -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, -1.2727922061357855`}, {
     0.7000000000000001, -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, -1.2727922061357855`}, {
     0.8, -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, -1.2727922061357855`}, {0.9, -1.2727922061357855`}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, -1.2727922061357855`}, {
     1., -1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., -1.0606601717798212`}, {0.1, -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, -1.0606601717798212`}, {0.2, -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, -1.0606601717798212`}, {
     0.30000000000000004`, -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, -1.0606601717798212`}, {
     0.4, -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, -1.0606601717798212`}, {0.5, -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, -1.0606601717798212`}, {
     0.6000000000000001, -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, -1.0606601717798212`}, {
     0.7000000000000001, -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, -1.0606601717798212`}, {
     0.8, -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, -1.0606601717798212`}, {0.9, -1.0606601717798212`}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, -1.0606601717798212`}, {
     1., -1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., -0.848528137423857}, {0.1, -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, -0.848528137423857}, {0.2, -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, -0.848528137423857}, {
     0.30000000000000004`, -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, -0.848528137423857}, {
     0.4, -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, -0.848528137423857}, {0.5, -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, -0.848528137423857}, {
     0.6000000000000001, -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, -0.848528137423857}, {
     0.7000000000000001, -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, -0.848528137423857}, {
     0.8, -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, -0.848528137423857}, {0.9, -0.848528137423857}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, -0.848528137423857}, {1., -0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., -0.6363961030678927}, {0.1, -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, -0.6363961030678927}, {0.2, -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, -0.6363961030678927}, {
     0.30000000000000004`, -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, -0.6363961030678927}, {
     0.4, -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, -0.6363961030678927}, {0.5, -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, -0.6363961030678927}, {
     0.6000000000000001, -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, -0.6363961030678927}, {
     0.7000000000000001, -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, -0.6363961030678927}, {
     0.8, -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, -0.6363961030678927}, {0.9, -0.6363961030678927}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, -0.6363961030678927}, {1., -0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., -0.4242640687119285}, {0.1, -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, -0.4242640687119285}, {0.2, -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, -0.4242640687119285}, {
     0.30000000000000004`, -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, -0.4242640687119285}, {
     0.4, -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, -0.4242640687119285}, {0.5, -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, -0.4242640687119285}, {
     0.6000000000000001, -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, -0.4242640687119285}, {
     0.7000000000000001, -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, -0.4242640687119285}, {
     0.8, -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, -0.4242640687119285}, {0.9, -0.4242640687119285}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, -0.4242640687119285}, {1., -0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., -0.21213203435596426`}, {0.1, -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, -0.21213203435596426`}, {0.2, -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, -0.21213203435596426`}, {
     0.30000000000000004`, -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, -0.21213203435596426`}, {
     0.4, -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, -0.21213203435596426`}, {0.5, -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, -0.21213203435596426`}, {
     0.6000000000000001, -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, -0.21213203435596426`}, {
     0.7000000000000001, -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, -0.21213203435596426`}, {
     0.8, -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, -0.21213203435596426`}, {0.9, -0.21213203435596426`}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, -0.21213203435596426`}, {
     1., -0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., 0.21213203435596426`}, {0.1, 0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, 0.21213203435596426`}, {0.2, 0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, 0.21213203435596426`}, {0.30000000000000004`, 
     0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, 0.21213203435596426`}, {0.4, 
     0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, 0.21213203435596426`}, {0.5, 0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, 0.21213203435596426`}, {0.6000000000000001, 
     0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, 0.21213203435596426`}, {0.7000000000000001, 
     0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, 0.21213203435596426`}, {0.8, 
     0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, 0.21213203435596426`}, {0.9, 0.21213203435596426`}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, 0.21213203435596426`}, {1., 
     0.21213203435596426`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., 0.4242640687119285}, {0.1, 0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, 0.4242640687119285}, {0.2, 0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, 0.4242640687119285}, {0.30000000000000004`, 
     0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, 0.4242640687119285}, {0.4, 
     0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, 0.4242640687119285}, {0.5, 0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, 0.4242640687119285}, {0.6000000000000001, 
     0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, 0.4242640687119285}, {0.7000000000000001, 
     0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, 0.4242640687119285}, {0.8, 
     0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, 0.4242640687119285}, {0.9, 0.4242640687119285}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, 0.4242640687119285}, {1., 0.4242640687119285}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., 0.6363961030678927}, {0.1, 0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, 0.6363961030678927}, {0.2, 0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, 0.6363961030678927}, {0.30000000000000004`, 
     0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, 0.6363961030678927}, {0.4, 
     0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, 0.6363961030678927}, {0.5, 0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, 0.6363961030678927}, {0.6000000000000001, 
     0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, 0.6363961030678927}, {0.7000000000000001, 
     0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, 0.6363961030678927}, {0.8, 
     0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, 0.6363961030678927}, {0.9, 0.6363961030678927}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, 0.6363961030678927}, {1., 0.6363961030678927}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., 0.848528137423857}, {0.1, 0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, 0.848528137423857}, {0.2, 0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, 0.848528137423857}, {0.30000000000000004`, 
     0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, 0.848528137423857}, {0.4, 
     0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, 0.848528137423857}, {0.5, 0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, 0.848528137423857}, {0.6000000000000001, 
     0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, 0.848528137423857}, {0.7000000000000001, 
     0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, 0.848528137423857}, {0.8, 
     0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, 0.848528137423857}, {0.9, 0.848528137423857}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, 0.848528137423857}, {1., 0.848528137423857}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., 1.0606601717798212`}, {0.1, 1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, 1.0606601717798212`}, {0.2, 1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, 1.0606601717798212`}, {0.30000000000000004`, 
     1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, 1.0606601717798212`}, {0.4, 
     1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, 1.0606601717798212`}, {0.5, 1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, 1.0606601717798212`}, {0.6000000000000001, 
     1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, 1.0606601717798212`}, {0.7000000000000001, 
     1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, 1.0606601717798212`}, {0.8, 
     1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, 1.0606601717798212`}, {0.9, 1.0606601717798212`}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, 1.0606601717798212`}, {1., 1.0606601717798212`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., 1.2727922061357855`}, {0.1, 1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, 1.2727922061357855`}, {0.2, 1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, 1.2727922061357855`}, {0.30000000000000004`, 
     1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, 1.2727922061357855`}, {0.4, 
     1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, 1.2727922061357855`}, {0.5, 1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, 1.2727922061357855`}, {0.6000000000000001, 
     1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, 1.2727922061357855`}, {0.7000000000000001, 
     1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, 1.2727922061357855`}, {0.8, 
     1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, 1.2727922061357855`}, {0.9, 1.2727922061357855`}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, 1.2727922061357855`}, {1., 1.2727922061357855`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0., 1.4849242404917498`}, {0.1, 1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.1, 1.4849242404917498`}, {0.2, 1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.2, 1.4849242404917498`}, {0.30000000000000004`, 
     1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.30000000000000004`, 1.4849242404917498`}, {0.4, 
     1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.4, 1.4849242404917498`}, {0.5, 1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.5, 1.4849242404917498`}, {0.6000000000000001, 
     1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.6000000000000001, 1.4849242404917498`}, {0.7000000000000001, 
     1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None], 
    LineBox[{{0.7000000000000001, 1.4849242404917498`}, {0.8, 
     1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None], 
    LineBox[{{0.8, 1.4849242404917498`}, {0.9, 1.4849242404917498`}}]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.9, 1.4849242404917498`}, {1., 1.4849242404917498`}}]}, 
   {GrayLevel[
     NCache[
      Rational[1, 10], 0.1]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[1, 5], 0.2]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[3, 10], 0.3]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[2, 5], 0.4]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[1, 2], 0.5]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[3, 5], 0.6]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[7, 10], 0.7]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[4, 5], 0.8]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], 
    CapForm[None]}, 
   {GrayLevel[
     NCache[
      Rational[9, 10], 0.9]], AbsoluteThickness[0.5], Opacity[1], Dashing[{}],
     CapForm[None]}, 
   {GrayLevel[1], AbsoluteThickness[0.5], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{1.15, -0.95}, {
     0.7500000000000004, -0.7500000000000002}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.7997003375798961, -0.8162671167731939}, {
     0.7500000000000004, -0.7500000000000002}, {
     0.8328338959664925, -0.7500000000000002}}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox[
          TagBox[
           StyleBox["\<\"k\"\>",
            FontWeight->"Bold"],
           StyleForm[#, FontWeight -> "Bold"]& ],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[0.85],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {-0.9668515185499453, -1.1973620438231494`}, {0, 0},
      Automatic, {0.7071067811865474, 0.7071067811865477}], InsetBox[
     FrameBox[
      StyleBox[
       TagBox[
        StyleBox[
         TagBox[
          TemplateBox[{TagBox[
             StyleBox["\"k\"", FontWeight -> "Bold"], 
             StyleForm[#, FontWeight -> "Bold"]& ],"\"\[Prime]\[Prime]\""},
           "Superscript"],
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->12,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm],
       StripOnInput->False,
       ShowContents->False],
      Background->GrayLevel[0.85],
      ContentPadding->False,
      FrameMargins->None,
      FrameStyle->None,
      StripOnInput->False], {-0.9668515185499453, 1.1973620438231496`}, {0, 0},
      Automatic, {0.7071067811865475, -0.7071067811865476}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[
         StyleBox["\<\"z\"\>",
          FontSlant->"Italic"],
         StyleForm[#, FontSlant -> "Italic"]& ],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.6, -0.13150777777777778`}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[
         StyleBox["\<\"x\"\>",
          FontSlant->"Italic"],
         StyleForm[#, FontSlant -> "Italic"]& ],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.13150777777777733`, 1.6}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TagBox[
         StyleBox["\<\"k\"\>",
          FontWeight->"Bold"],
         StyleForm[#, FontWeight -> "Bold"]& ],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.9668515185499453, -1.1973620438231494`}, {0, 0}, 
     Automatic, {0.7071067811865474, 0.7071067811865477}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{TagBox[
           StyleBox["\"k\"", FontWeight -> "Bold"], 
           StyleForm[#, FontWeight -> "Bold"]& ],"\"\[Prime]\[Prime]\""},
         "Superscript"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-0.9668515185499453, 1.1973620438231496`}, {0, 0}, 
     Automatic, {0.7071067811865475, -0.7071067811865476}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        TemplateBox[{OverscriptBox[
           TagBox[
            StyleBox["\"k\"", FontWeight -> "Bold"], 
            StyleForm[#, FontWeight -> "Bold"]& ], "~"],"\"\[Prime]\""},
         "Superscript"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.0000000000000004`, 0.75}, {0, 0}, Automatic, {1, 0}], 
    InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubscriptBox[
         TagBox[
          StyleBox["\<\"n\"\>",
           FontSlant->"Italic"],
          StyleForm[#, FontSlant -> "Italic"]& ], "\<\"1\"\>"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {-2.1249999999999996`, -0.30000000000000004`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[
        SubscriptBox[
         TagBox[
          StyleBox["\<\"n\"\>",
           FontSlant->"Italic"],
          StyleForm[#, FontSlant -> "Italic"]& ], "\<\"2\"\>"],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {2.1250000000000004`, -0.30000000000000004`}, {0, 0}, 
     Automatic, {1, 0}], InsetBox[
     TagBox[
      StyleBox[
       TagBox[GridBox[{
          {"Evanescent"},
          {"wave"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {1.15, -0.95}, {-1.1, 1}, Automatic, {1, 0}]}},
  AspectRatio->0.6666666666666666,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{324., 216.},
  PlotRange->{{-3.0006, 3.0006}, {-2.0004, 2.0004}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.48210822121875*^9, 3.482108312296875*^9}, 
   3.525527886921875*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rotating inhomogeneous sphere", "Section",
 CellChangeTimes->{{3.465676987359375*^9, 3.465676993328125*^9}, {
  3.469958116140625*^9, 3.469958117625*^9}, {3.4730184600625*^9, 
  3.473018469265625*^9}, {3.501273684375*^9, 3.501273707859375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeArrow", ",", 
       RowBox[{"Thickness", "\[Rule]", "1"}], ",", 
       RowBox[{"PosnC", "\[Rule]", "1"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeCircle", ",", 
       RowBox[{"FillColor", "\[Rule]", "Gray"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeEllipse", ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"set", " ", "various", " ", "radius", " ", "parameters"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ra", "=", "0.5"}], ",", "\[IndentingNewLine]", 
     RowBox[{"hb", "=", "0.2"}], ",", "\[IndentingNewLine]", 
     RowBox[{"rb", "=", "0.7"}], ",", "\[IndentingNewLine]", 
     RowBox[{"rc", "=", "0.9"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"a", "=", "0"}], ",", "\[IndentingNewLine]", 
     RowBox[{"b", "=", "rb"}], ",", "\[IndentingNewLine]", 
     RowBox[{"dr", "=", "0.01"}], ",", "\[IndentingNewLine]", 
     RowBox[{"lmin", "=", "0.05"}], ",", "\[IndentingNewLine]", 
     RowBox[{"lmax", "=", "0.85"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"make", " ", "cloud"}], "-", 
       RowBox[{
       "like", " ", "gradient", " ", "fill", " ", "out", " ", "of", " ", 
        "successively", " ", "darker", " ", 
        RowBox[{"(", 
         RowBox[{"as", " ", "we", " ", "move", " ", "inward"}], ")"}], " ", 
        "concentric", " ", "circles"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SchemeCircle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"Horizontal", "[", "r", "]"}], ",", 
         RowBox[{"FillColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", 
           RowBox[{"lmin", "+", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"lmax", "-", "lmin"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"b", "-", "a"}], ")"}]}], "*", 
             RowBox[{"(", 
              RowBox[{"r", "-", "a"}], ")"}]}]}], "]"}]}], ",", 
         RowBox[{"ShowLine", "\[Rule]", "False"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"r", ",", "b", ",", 
         RowBox[{"a", "+", "dr"}], ",", 
         RowBox[{"-", "dr"}]}], "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "rb", ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "annotations", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Horizontal", "[", "rb", "]"}], ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"Polar", "[", 
        RowBox[{"{", 
         RowBox[{"rc", ",", 
          RowBox[{
           RowBox[{"-", "Pi"}], "/", "2"}]}], "}"}], "]"}], ",", 
       RowBox[{"Polar", "[", 
        RowBox[{"{", 
         RowBox[{"rc", ",", 
          RowBox[{
           RowBox[{"+", "Pi"}], "/", "2"}]}], "}"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeEllipse", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "hb"}], "}"}], ",", 
       RowBox[{"Horizontal", "[", 
        RowBox[{"{", 
         RowBox[{"ra", ",", 
          RowBox[{"0.5", "*", "ra"}]}], "}"}], "]"}], ",", 
       RowBox[{"ShowHead", "\[Rule]", "True"}], ",", 
       RowBox[{"HeadLength", "\[Rule]", "3"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "4"}], ",", 
       RowBox[{"Thickness", "\[Rule]", "2"}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabX", "\[Rule]", "\"\<\[Omega]\>\""}], ",", 
       RowBox[{"PosnX", "\[Rule]", "Pi"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeEllipse", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Horizontal", "[", 
        RowBox[{"{", 
         RowBox[{"rb", ",", 
          RowBox[{"0.5", "*", "rb"}]}], "}"}], "]"}], ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"Pi", ",", 
         RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeEllipse", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Horizontal", "[", 
        RowBox[{"{", 
         RowBox[{"rb", ",", 
          RowBox[{"0.5", "*", "rb"}]}], "}"}], "]"}], ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "Pi"}], "}"}], ",", 
       RowBox[{"Dashing", "\[Rule]", "3"}]}], "]"}], ","}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ExtendRange", "\[Rule]", "0.2"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.400339538875*^9, 3.400339641125*^9}, 
   3.40033967371875*^9, {3.400339770671875*^9, 3.4003400125625*^9}, {
   3.410558353359375*^9, 3.41055836778125*^9}, {3.410558452890625*^9, 
   3.410558714703125*^9}, {3.41055889328125*^9, 3.41055892746875*^9}, {
   3.4105589676875*^9, 3.410558992125*^9}, {3.41055937271875*^9, 
   3.41055937871875*^9}, {3.410559421546875*^9, 3.41055982309375*^9}, {
   3.441571567677*^9, 3.441571576677*^9}, {3.441571981505125*^9, 
   3.441572019817625*^9}, {3.441572050052*^9, 3.44157215070825*^9}, {
   3.44157230477075*^9, 3.441572324223875*^9}, {3.441572744536375*^9, 
   3.441572892036375*^9}, {3.4415729458645*^9, 3.44157315839575*^9}, {
   3.4730185059375*^9, 3.47301864846875*^9}, {3.47301869*^9, 
   3.473018813484375*^9}, {3.48210857434375*^9, 3.482108575703125*^9}, {
   3.50127357684375*^9, 3.501273660703125*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.85], Opacity[1], 
    DiskBox[{0., 0.}, 0.6999999999999998, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.8385714285714285], Opacity[1], 
    DiskBox[{0., 0.}, 0.69, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.8271428571428571], Opacity[1], 
    DiskBox[{0., 0.}, 0.6799999999999998, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.8157142857142856], Opacity[1], 
    DiskBox[{0., 0.}, 0.6699999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.8042857142857142], Opacity[1], 
    DiskBox[{0., 0.}, 0.6599999999999998, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.7928571428571427], Opacity[1], 
    DiskBox[{0., 0.}, 0.6499999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.7814285714285714], Opacity[1], 
    DiskBox[{0., 0.}, 0.6399999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.77], Opacity[1], 
    DiskBox[{0., 0.}, 0.63, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.7585714285714286], Opacity[1], 
    DiskBox[{0., 0.}, 0.62, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.7471428571428571], Opacity[1], 
    DiskBox[{0., 0.}, 0.61, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.7357142857142857], Opacity[1], 
    DiskBox[{0., 0.}, 0.6, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.7242857142857143], Opacity[1], 
    DiskBox[{0., 0.}, 0.59, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.7128571428571429], Opacity[1], 
    DiskBox[{0., 0.}, 0.58, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.7014285714285714], Opacity[1], 
    DiskBox[{0., 0.}, 0.57, NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.69], Opacity[1], 
    DiskBox[{0., 0.}, 0.5599999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.6785714285714285], Opacity[1], 
    DiskBox[{0., 0.}, 0.5499999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.667142857142857], Opacity[1], 
    DiskBox[{0., 0.}, 0.5399999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.6557142857142856], Opacity[1], 
    DiskBox[{0., 0.}, 0.5299999999999998, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.6442857142857142], Opacity[1], 
    DiskBox[{0., 0.}, 0.5199999999999998, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.6328571428571428], Opacity[1], 
    DiskBox[{0., 0.}, 0.5099999999999998, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.6214285714285713], Opacity[1], 
    DiskBox[{0., 0.}, 0.4999999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.61], Opacity[1], 
    DiskBox[{0., 0.}, 0.4899999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5985714285714285], Opacity[1], 
    DiskBox[{0., 0.}, 0.47999999999999987`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5871428571428571], Opacity[1], 
    DiskBox[{0., 0.}, 0.4699999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5757142857142857], Opacity[1], 
    DiskBox[{0., 0.}, 0.4599999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5642857142857143], Opacity[1], 
    DiskBox[{0., 0.}, 0.4499999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5528571428571428], Opacity[1], 
    DiskBox[{0., 0.}, 0.4399999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5414285714285714], Opacity[1], 
    DiskBox[{0., 0.}, 0.4299999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5299999999999999], Opacity[1], 
    DiskBox[{0., 0.}, 0.4199999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5185714285714286], Opacity[1], 
    DiskBox[{0., 0.}, 0.4099999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.5071428571428571], Opacity[1], 
    DiskBox[{0., 0.}, 0.3999999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.4957142857142856], Opacity[1], 
    DiskBox[{0., 0.}, 0.3899999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.4842857142857142], Opacity[1], 
    DiskBox[{0., 0.}, 0.3799999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.47285714285714275`], Opacity[1], 
    DiskBox[{0., 0.}, 0.3699999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.4614285714285713], Opacity[1], 
    DiskBox[{0., 0.}, 0.35999999999999993`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.4499999999999999], Opacity[1], 
    DiskBox[{0., 0.}, 0.3499999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.4385714285714285], Opacity[1], 
    DiskBox[{0., 0.}, 0.3399999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.42714285714285705`], Opacity[1], 
    DiskBox[{0., 0.}, 0.3299999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.41571428571428565`], Opacity[1], 
    DiskBox[{0., 0.}, 0.31999999999999995`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.4042857142857142], Opacity[1], 
    DiskBox[{0., 0.}, 0.3099999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.39285714285714274`], Opacity[1], 
    DiskBox[{0., 0.}, 0.2999999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.38142857142857134`], Opacity[1], 
    DiskBox[{0., 0.}, 0.28999999999999987`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.36999999999999994`], Opacity[1], 
    DiskBox[{0., 0.}, 0.27999999999999997`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.3585714285714285], Opacity[1], 
    DiskBox[{0., 0.}, 0.26999999999999996`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.3471428571428571], Opacity[1], 
    DiskBox[{0., 0.}, 0.2599999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.33571428571428563`], Opacity[1], 
    DiskBox[{0., 0.}, 0.24999999999999992`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.3242857142857142], Opacity[1], 
    DiskBox[{0., 0.}, 0.2399999999999999, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.3128571428571428], Opacity[1], 
    DiskBox[{0., 0.}, 0.22999999999999993`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.3014285714285713], Opacity[1], 
    DiskBox[{0., 0.}, 0.21999999999999995`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.2899999999999999], Opacity[1], 
    DiskBox[{0., 0.}, 0.20999999999999994`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.2785714285714285], Opacity[1], 
    DiskBox[{0., 0.}, 0.19999999999999996`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.26714285714285707`], Opacity[1], 
    DiskBox[{0., 0.}, 0.18999999999999995`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.2557142857142856], Opacity[1], 
    DiskBox[{0., 0.}, 0.17999999999999994`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.24428571428571422`], Opacity[1], 
    DiskBox[{0., 0.}, 0.16999999999999996`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.23285714285714276`], Opacity[1], 
    DiskBox[{0., 0.}, 0.15999999999999995`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.22142857142857136`], Opacity[1], 
    DiskBox[{0., 0.}, 0.14999999999999994`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.20999999999999996`], Opacity[1], 
    DiskBox[{0., 0.}, 0.13999999999999993`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.1985714285714285], Opacity[1], 
    DiskBox[{0., 0.}, 0.12999999999999995`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.18714285714285706`], Opacity[1], 
    DiskBox[{0., 0.}, 0.11999999999999993`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.17571428571428566`], Opacity[1], 
    DiskBox[{0., 0.}, 0.10999999999999995`, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.16428571428571423`], Opacity[1], 
    DiskBox[{0., 0.}, 0.09999999999999995, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.1528571428571428], Opacity[1], 
    DiskBox[{0., 0.}, 0.08999999999999993, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.14142857142857135`], Opacity[1], 
    DiskBox[{0., 0.}, 0.07999999999999993, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.12999999999999992`], Opacity[1], 
    DiskBox[{0., 0.}, 0.06999999999999994, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.11857142857142851`], Opacity[1], 
    DiskBox[{0., 0.}, 0.05999999999999994, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.10714285714285707`], Opacity[1], 
    DiskBox[{0., 0.}, 0.04999999999999994, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.09571428571428564], Opacity[1], 
    DiskBox[{0., 0.}, 0.03999999999999993, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.08428571428571421], Opacity[1], 
    DiskBox[{0., 0.}, 0.02999999999999994, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.07285714285714279], Opacity[1], 
    DiskBox[{0., 0.}, 0.01999999999999994, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0.06142857142857136], Opacity[1], 
    DiskBox[{0., 0.}, 0.009999999999999941, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], CircleBox[{0., 0.}, 0.6999999999999998, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], CircleBox[{0., 0.}, 0.6999999999999998, 
     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{2.220446049250313*^-16, -0.8999999999999998}, {
     2.220446049250313*^-16, 0.9000000000000004}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-0.029172499999999824`, 0.8416550000000003}, {
     2.220446049250313*^-16, 0.9000000000000004}, {0.029172500000000268`, 
     0.8416550000000003}}]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[CompressedData["
1:eJxdlHlIVFEUxqdpErE/LDI3hDIitaREArWFE6Lt+EeSThCllkFluUyUJYlW
lEu2mKSZqYk5U1YyZotiHi1NSkeymZp0ntmepsUoZqRDtnC/94cPHo8L9917
zvf9zucZE78pVqlQKLb+ff99f0/8e3rp0v/nKTWfuvHJQd9LWcN29ivtO2hc
O/tTdMcbSiq2lHt7dpLzvB1B0zU9NDfm63Coo5Eq747mhj+ykHHpluL0RyYa
sWa2OfZ2kWuc9l5swCvaX+CQofxsJp+iD9p7CWYyz4kc/z7wkm57PjPcP/Ca
+kIeHvL6bSSTJmDd2PouCjfEpi6a/4IUyhGtbayLDj6v69sZ/ZyUsw11h7O7
6URrQKT/PgOFBUfv8lFayKBLezAY+oxshep03mEh7xWtbufWtVJmTlmtXY2F
gsa6VSZNM5kTI/eqRi2U17e81L2xiY4N3rX38JVoxsdXh1PDG0ja27FksVoi
S8HZo6nqWgqMCt5cnSJRi1ePOf9kDZXtMS5py5do+skNuqDKKupvdMyKuCVR
Q2Cn/kxKBT1xqQ74VS9RSGBUZvGbQnLaqO72apXoZlT21IS36bRMI034tstr
xlrsZ+wX5zHOE/cx7hP1MOoR9TLqFf0w+hH9MvoVejD0EHox9BJ6MvQUejP0
Fn4w/BB+MfwSfjL8FH4z/BY8MHgQvDB4ETwxeBK8MXgTPDJ4FLwyeBU88ySe
WbfKd9Howhb5/7DRlP531kb5/M899YVhPnXy/W4XpnzbvvWOXJ8q7rxLycxK
uf60gaoclzVX5f50qT/rPcJy5f7nJma6mrQaWZ9Gt8KLj9XJDP389sUvUK04
w9B3bfaRdlvGRYb+fs7WlG1lRQx/0krWKHYbSxn+WZu+50R8KGP4uzH/ffKs
vHKG/065FfrykWsMPmxLV/e0zNAy+AnJ6NCfHtIy+Epbpj/+5YqOwV/c0GOr
zf06g0/ThR/TkuKuM/i1Nzj7X86T14Q1+Md+zAfOw/zgPswX6sH8oV7MJ/rB
/KJfzDf0wPxDL+QD9ER+QG/kC/xA/sAv5BP8RH7Bb+QbeED+gRfkI3hCfoI3
5Ct4RP6C18n5PHn9B0ydJbU=
     "]]}, 
   {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.4611033333333334, 0.17082750000000013`}, {0.5, 
     0.20000000000000018`}, {0.5388966666666668, 0.17082750000000013`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[CompressedData["
1:eJw9kl1Ik3EUxsci+pBKssKLRS4mWYKTcpFL3kNoFxFGsyKwTcO2LsLexRJj
kERBRnWRJJFi62II7cKwckXG8mmL9TELndteMNPM5ijISFFiUFDCOR348+fA
4Xw8z8/Y4K5x6XU6Xcm/t/g7Ty5GBjoONeqwGs0Z9F6/7cvGAyi9sdB/rm0a
6u+agiHlKXIHiwOHfWkY/Jvi31vDcDzq6TutfkHuzyPp9n2vUBnJC5gMU1BN
zqIeRwwZn7W+69kkLBO0fSH2HvVZbzb4YAIV47fKztuG0Xzc3XTqzxhWbmz4
7GmJY1V/uEVzjWJdemfnx7MjUK4t9b74oWF/x47qQiWBQM49raIziYvdd84c
SCcQWVMbLHSOIFCw7cRMYxJfm3PW5lcPo7ypLt82nsS3Xx2JIv87jPUdqwqW
p2D5dGhyYPQNYje9M+rlFDyNGzZ7rFGs36ufNb5MwWV7aJp7HsbbMmXuw3wK
eXctJWooBHvlitlSg4bdVV2R1cVPsCXkcNdaNXRfGoi+9vaiTb/HrBzUYJ63
ty8f8sM5bfdeqNNw9MrWXUuWXcXg46n7ra7/OUnO9ST13I+kH88jmcf7kOzD
+5Lsy/eQ3MP3ktzLepDowXqR6MV6kujJepPozX6Q+MF+kfjFfpL4yX6T+M08
kPDAvJDwwjyR8MS8kfDGPJLwyLyS8Mo8k/D8F5iGglM=
     "]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[
     NCache[{3, 
       Rational[3, 2]}, {3, 1.5}]], CapForm[None], LineBox[CompressedData["
1:eJw9kl1Ik3EUxsci+pBKssKLRS4mWYKTcpFL3ofQLiKMZkVgm4ZtXYS9iyXG
IImCjOoiSSLF1sUQ2oVh5YqM5WmL9TELndteMNPM5ijISFFiUFDCOR348+fA
4Xw8z8/Y4K5x6XU6Xcm/t/g7Ty5GBjoONeqwGs0Z9F6/7cvGAyi9sdB/rm0a
6u+agiHlKXIHiwOHfWkY/Jvi31vDcDzq6TutfkHuzyPp9n2vUBnJC5gMU1BN
zqIeRwwZn7W+69kkLBPYvhB7j/qsNxt8MIGK8Vtl523DaD7ubjr1ZwwrNzZ8
9rTEsao/3KK5RrEuvbPz49kRKNeWel/80LC/Y0d1oZJAIOeeVtGZxMXuO2cO
pBOIrKkNFjpHECjYdmKmMYmvzTlr86uHUd5Ul28bT+Lbr45Ekf8dxvqOVQXL
U7B8OjQ5MPoGsZveGfVyCp7GDZs91ijW79XPGl+m4LI9NM09D+NtmTL3YT6F
vLuWEjUUgr1yxWypQcPuqq7I6uIn2BJyuGutGrovDURfe3vRpt9jVg5qMM/b
25cP+eGctnsv1Gk4emXrriXLrmLw8dT9Vtf/nCTnepJ67kfSj+eRzON9SPbh
fUn25XtI7uF7Se5lPUj0YL1I9GI9SfRkvUn0Zj9I/GC/SPxiP0n8ZL9J/GYe
SHhgXkh4YZ5IeGLeSHhjHkl4ZF5JeGWeSXj+CwfFbFM=
     "]], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Omega]\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.37774002639456994`, 0.4330133970016863}, {0, 0}, 
     Automatic, {0.9267806473751461, -0.375603024017253}]}},
  AspectRatio->1,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{288, 288},
  PlotRange->{{-1.40028, 1.40028}, {-1.40028, 1.40028}},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.482108582296875*^9, {3.501273652515625*^9, 3.50127366228125*^9}, 
   3.52552788834375*^9}]
}, Open  ]],

Cell[BoxData[""], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Some more (circles, arrows, arcs, ",
 StyleBox["etc.",
  FontSlant->"Italic"],
 ")"
}], "Section",
 CellChangeTimes->{{3.399735755125*^9, 3.399735761734375*^9}, {
  3.399737667796875*^9, 3.39973767721875*^9}, {3.495659279546875*^9, 
  3.495659312453125*^9}}],

Cell["\<\
Note how functions (Dipole and ForceArrow) have been defined to draw parts of \
the diagram, thereby saving retyping and allowing easy changes to the \
coordinates.  For instance, the \"dipole\" can be moved or its size changed \
just by changing the argument to Dipole, without the need to manually edit \
the coordinates for each component of the dipole.\
\>", "Text",
 CellChangeTimes->{{3.399737682484375*^9, 3.399737846890625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Dipole", "[", 
    RowBox[{"x0_List", ",", "a_", ",", "theta_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "avec", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"avec", "=", 
         RowBox[{"a", "*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "theta", "]"}], ",", 
            RowBox[{"Sin", "[", "theta", "]"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SchemeCircle", "[", 
         RowBox[{
          RowBox[{"x0", "+", "avec"}], ",", 
          RowBox[{"Point", "[", "4", "]"}], ",", 
          RowBox[{"FillColor", "\[Rule]", "Red"}], ",", 
          RowBox[{"LabT", "\[Rule]", "\"\<+\>\""}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SchemeCircle", "[", 
        RowBox[{
         RowBox[{"x0", "-", "avec"}], ",", 
         RowBox[{"Point", "[", "4", "]"}], ",", 
         RowBox[{"FillColor", "\[Rule]", "Blue"}], ",", 
         RowBox[{"LabB", "\[Rule]", "\"\<-\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SchemeArrow", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x0", "-", "avec"}], ",", 
           RowBox[{"x0", "+", "avec"}]}], "}"}], ",", 
         RowBox[{"LabR", "\[Rule]", 
          RowBox[{"textbf", "[", "\"\<p\>\"", "]"}]}], ",", 
         RowBox[{"Thickness", "\[Rule]", "2"}], ",", 
         RowBox[{"BufferR", "\[Rule]", "1.3"}], ",", 
         RowBox[{"OrientationR", "\[Rule]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"N", "[", "theta", "]"}], "<", 
             RowBox[{"Pi", "/", "2"}]}], ",", "Automatic", ",", "Inverted"}], 
           "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ForceArrow", "[", 
    RowBox[{"x_List", ",", "l_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "rhat", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"rhat", "=", 
       RowBox[{"x", "/", 
        RowBox[{"Norm", "[", "x", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"SchemeArrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"x", "+", 
           RowBox[{"l", "*", "rhat"}]}]}], "}"}], ",", 
        RowBox[{"ArrowType", "\[Rule]", "MultilineArrow"}], ",", 
        RowBox[{"ShowFill", "\[Rule]", "False"}], ",", 
        RowBox[{"Layer", "\[Rule]", "0"}], ",", 
        RowBox[{"Width", "\[Rule]", "3"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "\[IndentingNewLine]", "]"}]}], ";"}], "\n", 
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Margin", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.2"}], ",", "1"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"YPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.4"}], ",", "0.8"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XFrameTicks", "\[Rule]", "None"}], ",", 
       RowBox[{"YFrameTicks", "\[Rule]", "None"}]}], "\[IndentingNewLine]", 
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"x0", "=", 
      RowBox[{"{", 
       RowBox[{"0.6", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"a", "=", "0.13"}], ",", "\[IndentingNewLine]", 
     RowBox[{"l", "=", "0.15"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeAxis", "[", 
      RowBox[{"Bottom", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.9"}], "}"}], ",", "0", ",", 
       RowBox[{"LabB", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<x\>\"", "]"}]}], ",", 
       RowBox[{"PosnB", "\[Rule]", "1"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeAxis", "[", 
      RowBox[{"Left", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.5"}], "}"}], ",", 
       RowBox[{"LabL", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<z\>\"", "]"}]}], ",", 
       RowBox[{"PosnL", "\[Rule]", "1"}]}], "]"}], ",", "\[IndentingNewLine]",
      "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Point", "[", "10", "]"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Red"}], ",", 
       RowBox[{"LabC", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<Q\>\"", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Dipole", "[", 
      RowBox[{"x0", ",", "a", ",", 
       RowBox[{"55", "*", "Degree"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{"x0", ",", "a", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"45", "*", "Degree"}]}], "}"}], ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}], ",", 
       RowBox[{"LabX", "\[Rule]", "\"\<\[Alpha]\>\""}], ",", 
       RowBox[{"PosnX", "\[Rule]", "0.3"}], ",", 
       RowBox[{"Layer", "\[Rule]", "0"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{"x0", ",", 
       RowBox[{"Point", "[", "3", "]"}], ",", 
       RowBox[{"LabB", "\[Rule]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<(\>\"", ",", 
           RowBox[{"textit", "[", "\"\<r\>\"", "]"}], ",", "\"\<,0,0)\>\""}], 
          "}"}], "]"}]}], ",", 
       RowBox[{"OffsetB", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"+", "1"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Point", "[", "10", "]"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Red"}], ",", 
       RowBox[{"LabC", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<Q\>\"", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Dipole", "[", 
      RowBox[{"x0", ",", "a", ",", 
       RowBox[{"0", "*", "Degree"}]}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Point", "[", "10", "]"}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Red"}], ",", 
       RowBox[{"LabC", "\[Rule]", 
        RowBox[{"textit", "[", "\"\<Q\>\"", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Dipole", "[", 
      RowBox[{"x0", ",", "a", ",", 
       RowBox[{"90", "*", "Degree"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ForceArrow", "[", 
      RowBox[{
       RowBox[{"x0", "+", 
        RowBox[{"{", 
         RowBox[{"0", ",", "a"}], "}"}]}], ",", "l"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ForceArrow", "[", 
      RowBox[{
       RowBox[{"x0", "+", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "a"}]}], "}"}]}], ",", 
       RowBox[{"-", "l"}]}], "]"}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", "0.8", "*", 
     RowBox[{"{", 
      RowBox[{"9", ",", "3"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.399732547171875*^9, 3.39973266503125*^9}, {
   3.39973270928125*^9, 3.399732721875*^9}, {3.39973283740625*^9, 
   3.399732839078125*^9}, {3.399732878515625*^9, 3.399732880015625*^9}, {
   3.399732910921875*^9, 3.399732921515625*^9}, 3.399732996796875*^9, {
   3.399733394671875*^9, 3.399733401515625*^9}, {3.399733435671875*^9, 
   3.399733437703125*^9}, {3.399733496140625*^9, 3.399733567953125*^9}, {
   3.399733956796875*^9, 3.399733958578125*^9}, {3.3997343233125*^9, 
   3.39973448796875*^9}, {3.399734649140625*^9, 3.399734746*^9}, {
   3.399734901921875*^9, 3.39973491115625*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], CircleBox[{0.2329411008230453, 0.3526273148148148}, {0.03471765689300413, 0.09579224537037037},
      NCache[{0, 45 Degree}, {0, 0.7853981633974483}]], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"\[Alpha]\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->12,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {0.2781198682752133, 0.39768481228754055`}, {0, 0}, 
     Automatic, {0.2525697535070605, -0.9675786891066703}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.874448056720046, 0.4399046861399264}, {
     0.9098140945428449, 0.46104728915958565`}}], 
    LineBox[{{0.8733168609754273, 0.4569344342304439}, {0.9086828987982261, 
     0.4780770372501032}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.8999829261244883, 0.4905820023621452}, {
     0.913032885135095, 0.4718245546940821}, {0.9033765133583449, 
     0.4394927580905928}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.874448056720046, 0.26534994348970325`}, {
     0.8390820188972473, 0.28649254650936246`}}], 
    LineBox[{{0.8733168609754273, 0.24832019539918573`}, {0.8379508231526285, 
     0.269462798418845}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.8443884043371286, 0.24790826734985208`}, {
     0.8347320325603784, 0.2802400639533414}, {0.8477819915709851, 
     0.29899751162140453`}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.01929398148148148, 0.05788194444444439}, {
     0.3397646604938272, 0.05788194444444439}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.01929398148148148, 0.05788194444444439}, {
     0.01929398148148148, 0.9421180555555556}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.01929398148148148, 0.9421180555555556}, {
     0.3397646604938272, 0.9421180555555556}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.3397646604938272, 0.05788194444444439}, {
     0.3397646604938272, 0.9421180555555556}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.07270576131687244, 0.3526273148148148}, {
     0.31305877057613174`, 0.3526273148148148}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.3014823816872429, 0.36999189814814815`}, {
     0.3130587705761318, 0.35262731481481485`}, {0.3014823816872429, 
     0.3352627314814815}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.07270576131687244, 0.3526273148148148}, {
     0.07270576131687244, 0.7210590277777778}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.06691756687242799, 0.686329861111111}, {
     0.07270576131687244, 0.7210590277777778}, {0.07849395576131689, 
     0.686329861111111}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], {}, 
    {RGBColor[1, 0, 0], Opacity[1], 
     DiskBox[{0.07270576131687244, 0.3526273148148148}, {0.01929398148148148, 0.05788194444444444},
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], CircleBox[{0.07270576131687244, 0.3526273148148148}, {0.01929398148148148, 0.05788194444444444},
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
     {RGBColor[1, 0, 0], Opacity[1], 
      DiskBox[{0.25285433074219293`, 0.4310957284369864}, {0.007717592592592593, 0.023152777777777776`},
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], CircleBox[{0.25285433074219293`, 0.4310957284369864}, {0.007717592592592593, 0.023152777777777776`},
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
      {RGBColor[0, 0, 1], Opacity[1], 
       DiskBox[{0.2130278709038977, 0.2741589011926432}, {0.007717592592592593, 0.023152777777777776`},
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], CircleBox[{0.2130278709038977, 0.2741589011926432}, {0.007717592592592593, 0.023152777777777776`},
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.21302787090389771`, 0.27415890119264325`}, {
        0.252854330742193, 0.4310957284369864}}]}, 
      {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.24123653037767329`, 0.41398186844244145`}, {
        0.252854330742193, 0.4310957284369864}, {0.2504473465220265, 
        0.39294469156541223`}}], 
       {GrayLevel[0], Opacity[1], 
        DiskBox[{0.2329411008230453, 0.3526273148148148}, {0.005788194444444445, 0.017364583333333333`},
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], 
        CircleBox[{0.2329411008230453, 0.3526273148148148}, {0.005788194444444445, 0.017364583333333333`},
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.3397646604938272, 0.05788194444444439}, {
         0.6602353395061729, 0.05788194444444439}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.3397646604938272, 0.05788194444444439}, {
         0.3397646604938272, 0.9421180555555556}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.3397646604938272, 0.9421180555555556}, {
         0.6602353395061729, 0.9421180555555556}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.6602353395061729, 0.05788194444444439}, {
         0.6602353395061729, 0.9421180555555556}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], {}, 
        {RGBColor[1, 0, 0], Opacity[1], 
         DiskBox[{0.39317644032921817`, 0.3526273148148148}, {0.01929398148148148, 0.05788194444444444},
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], CircleBox[{0.39317644032921817`, 0.3526273148148148}, {0.01929398148148148, 0.05788194444444444},
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
         {RGBColor[1, 0, 0], Opacity[1], 
          DiskBox[{0.5881294367283951, 0.3526273148148148}, {0.007717592592592593, 0.023152777777777776`},
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          CircleBox[{0.5881294367283951, 0.3526273148148148}, {0.007717592592592593, 0.023152777777777776`},
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
          {RGBColor[0, 0, 1], Opacity[1], 
           DiskBox[{0.5186941229423869, 0.3526273148148148}, {0.007717592592592593, 0.023152777777777776`},
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           CircleBox[{0.5186941229423869, 0.3526273148148148}, {0.007717592592592593, 0.023152777777777776`},
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.5186941229423869, 0.35262731481481485`}, {
            0.5881294367283951, 0.35262731481481485`}}]}, 
          {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.5765530478395062, 0.36999189814814815`}, {
            0.5881294367283951, 0.35262731481481485`}, {0.5765530478395062, 
            0.3352627314814815}}]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.6602353395061729, 0.05788194444444439}, {
            0.9807060185185186, 0.05788194444444439}}]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.6602353395061729, 0.05788194444444439}, {
            0.6602353395061729, 0.9421180555555556}}]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.6602353395061729, 0.9421180555555556}, {
            0.9807060185185186, 0.9421180555555556}}]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9807060185185186, 0.05788194444444439}, {
            0.9807060185185186, 0.9421180555555556}}]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], {}, 
           {RGBColor[1, 0, 0], Opacity[1], 
            DiskBox[{0.7136471193415638, 0.3526273148148148}, {0.01929398148148148, 0.05788194444444444},
              NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
           {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
            CapForm[None], 
            CircleBox[{0.7136471193415638, 0.3526273148148148}, {0.01929398148148148, 0.05788194444444444},
              NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
            {RGBColor[1, 0, 0], Opacity[1], 
             DiskBox[{0.8738824588477366, 0.44841956018518514`}, {0.007717592592592593, 0.023152777777777776`},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             CircleBox[{0.8738824588477366, 0.44841956018518514`}, {0.007717592592592593, 0.023152777777777776`},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
             {RGBColor[0, 0, 1], Opacity[1], 
              DiskBox[{0.8738824588477366, 0.25683506944444445`}, {0.007717592592592593, 0.023152777777777776`},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
             {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
              CapForm[None], 
              CircleBox[{0.8738824588477366, 0.25683506944444445`}, {0.007717592592592593, 0.023152777777777776`},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
             {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
              CapForm[None], 
              LineBox[{{0.8738824588477366, 0.25683506944444445`}, {
               0.8738824588477366, 0.44841956018518514`}}]}, 
             {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
              CapForm[None], 
              LineBox[{{0.8680942644032922, 0.4136903935185185}, {
               0.8738824588477366, 0.44841956018518514`}, {0.8796706532921811,
                0.4136903935185185}}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"(a)\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.048234953703703703`, 0.855295138888889}, {0, 0},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TagBox[
                   StyleBox["\<\"x\"\>",
                    FontSlant->"Italic"],
                   StyleForm[#, FontSlant -> "Italic"]& ],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.3130587705761318, 0.31153113425925927`}, {0, 0},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TagBox[
                   StyleBox["\<\"z\"\>",
                    FontSlant->"Italic"],
                   StyleForm[#, FontSlant -> "Italic"]& ],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.05900703446502059, 0.7210590277777778}, {0, 0},
                Automatic, {0, 1}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TagBox[
                   StyleBox["\<\"Q\"\>",
                    FontSlant->"Italic"],
                   StyleForm[#, FontSlant -> "Italic"]& ],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.07270576131687244, 0.3526273148148148}, {0, 0},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"+\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.25285433074219293`, 0.4542485062147642}, {0, -1},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"-\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.2130278709038977, 0.2510061234148654}, {0, 1},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TagBox[
                   StyleBox["\<\"p\"\>",
                    FontWeight->"Bold"],
                   StyleForm[#, FontWeight -> "Bold"]& ],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.21943190381132735`, 0.3834818409011244}, {0, 0},
                Automatic, {0.6057495441496134, 0.7956553837953563}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TemplateBox[{"\"(\"",TagBox[
                    StyleBox["\"r\"", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\",0,0)\""},
                   "Row",
                   
                   DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                   InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.2329411008230453, 0.33526273148148145`}, {-1, 1},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"(b)\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.3687056327160494, 0.855295138888889}, {0, 0},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TagBox[
                   StyleBox["\<\"Q\"\>",
                    FontSlant->"Italic"],
                   StyleForm[#, FontSlant -> "Italic"]& ],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.39317644032921817`, 0.3526273148148148}, {0, 0},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"+\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.5881294367283951, 0.3757800925925926}, {0, -1},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"-\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.5186941229423869, 0.329474537037037}, {0, 1},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TagBox[
                   StyleBox["\<\"p\"\>",
                    FontWeight->"Bold"],
                   StyleForm[#, FontWeight -> "Bold"]& ],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.553411779835391, 0.4035634259259259}, {0, 0},
                Automatic, {1., 0.}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"(c)\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.6891763117283951, 0.855295138888889}, {0, 0},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TagBox[
                   StyleBox["\<\"Q\"\>",
                    FontSlant->"Italic"],
                   StyleForm[#, FontSlant -> "Italic"]& ],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.7136471193415638, 0.3526273148148148}, {0, 0},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"+\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.8738824588477366, 0.47157233796296294`}, {0, -1},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox["\<\"-\"\>",
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.8738824588477366, 0.23368229166666668`}, {0, 1},
                Automatic, {1, 0}], InsetBox[
               TagBox[
                StyleBox[
                 TagBox[
                  TagBox[
                   StyleBox["\<\"p\"\>",
                    FontWeight->"Bold"],
                   StyleForm[#, FontWeight -> "Bold"]& ],
                  DisplayForm],
                 StripOnInput->False,
                 ShowAutoStyles->False,
                 SingleLetterItalics->False,
                 FontFamily->"Times",
                 FontSize->12,
                 FontWeight->"Plain",
                 FontSlant->"Plain",
                 FontTracking->"Plain",
                 FontColor->GrayLevel[0],
                 FontOpacity->1],
                DisplayForm], {0.8569037551440329, 0.35262731481481485`}, {0, 0},
                Automatic, {-6.123233995736766*^-17, -1.}]}}}}}}}}}}}},
  AspectRatio->0.33333333333333337`,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{518.4, 172.8},
  PlotRange->{{-0.0001, 1.0001}, {-0.0001, 1.0001}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.3997333100625*^9, 3.39973332078125*^9}, {
   3.3997333545*^9, 3.3997334100625*^9}, {3.39973344040625*^9, 
   3.399733598609375*^9}, {3.3997336471875*^9, 3.399733669609375*^9}, {
   3.399733722078125*^9, 3.399733725609375*^9}, {3.3997338146875*^9, 
   3.3997338840625*^9}, {3.39973416515625*^9, 3.39973428484375*^9}, 
   3.3997343508125*^9, {3.3997343879375*^9, 3.3997345141875*^9}, 
   3.399734656453125*^9, {3.39973471578125*^9, 3.399734747484375*^9}, {
   3.399734895765625*^9, 3.399734912375*^9}, 3.43024801746875*^9, 
   3.52552788953125*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Diagram of recurrence relations", "Section",
 CellChangeTimes->{{3.495658481421875*^9, 3.495658485828125*^9}}],

Cell[TextData[{
 "Figure from F. Q. Luo and M. A. Caprio, Nuclear Physics A ",
 StyleBox["849",
  FontWeight->"Bold"],
 ", 35 (2011)."
}], "Text",
 CellChangeTimes->{{3.525527975296875*^9, 3.52552799284375*^9}}],

Cell["\<\
This provides an example of defining functions to draw certain elements of \
the figure which you use repeatedly within the figure (e.g., nodes of a \
network) and then of using \"Table[]\" to construct the full figure.

This also provides an example of maintaining multiple variants of a figure in \
parallel using \"conditional inclusion\", so that any changes you make \
automatically apply to both/all versions.  Two variants are needed here: 
\t1) With SchemeFlags \[Rule] {\"EqnNumber\"}, we make a version for use in \
the paper, with cross references to certain equation numbers.
\t2) With SchemeFlags \[Rule] {\"Color\"}, we make a color version for use in \
presentations.\
\>", "Text",
 CellChangeTimes->{{3.495658556640625*^9, 3.49565869053125*^9}}],

Cell[TextData[{
 "Character definition\nIncidentally, this figure also provides a simple \
example of selecting a different font to get a symbol we need.  In Times \
Roman, a lowercase italic \"",
 StyleBox["v",
  FontSlant->"Italic"],
 "\" looks very similar to a lowercase Greek \"\[Nu]\".  We are trying to \
avoid this by using a different font for \"v\", namely, ",
 "\"BookAntiqua\"",
 ".  If you do not have \"BookAntiqua\" installed as a font on your system, \
you may not get this rounded v character in the example, or you may have to \
hunt for another suitable font if you really want it!  (For instance, \
\"BookmanOldStyle\" works well.)"
}], "Text",
 CellChangeTimes->{{3.495658829859375*^9, 3.495659026703125*^9}, {
  3.495659068953125*^9, 3.49565912803125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RoundedV", "=", 
  RowBox[{"Style", "[", 
   RowBox[{"\"\<v\>\"", ",", "Italic", ",", 
    RowBox[{"FontFamily", "\[Rule]", "\"\<BookAntiqua\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.484770186703125*^9, 3.484770200859375*^9}, {
  3.4847702585625*^9, 3.48477027103125*^9}, {3.484770819984375*^9, 
  3.484770854984375*^9}, {3.495658874984375*^9, 3.495658887015625*^9}}],

Cell[BoxData[
 StyleBox["\<\"v\"\>",
  StripOnInput->False,
  FontFamily->"BookAntiqua",
  FontSlant->Italic]], "Output",
 CellChangeTimes->{3.495658888609375*^9, 3.495659630203125*^9, 
  3.525527889640625*^9}]
}, Open  ]],

Cell["Diagram components: Nodes", "Text",
 CellChangeTimes->{{3.495658156828125*^9, 3.495658161546875*^9}, {
   3.495658205375*^9, 3.495658207953125*^9}, 3.495658252796875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OverlapDot", "[", 
    RowBox[{"v_", ",", "N_"}], "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"N", ",", "v"}], "}"}], ",", "DotRadius", ",", 
       RowBox[{"ShowLine", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeCircle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"N", ",", "v"}], "}"}], ",", 
       RowBox[{"DotScale", "*", "DotRadius"}], ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}], ",", 
       RowBox[{"Show", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"v", "\[Equal]", "0"}], ")"}]}]}], "]"}], ","}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OBMEDot", "[", 
    RowBox[{"v_", ",", "N_"}], "]"}], ":=", 
   RowBox[{"SchemeCircle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"N", ",", 
       RowBox[{"v", "+", "0.5"}]}], "}"}], ",", "DotRadius", ",", 
     RowBox[{"ShowLine", "\[Rule]", "False"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UpEllipsis", "[", 
    RowBox[{"v_", ",", "N_"}], "]"}], ":=", 
   RowBox[{"ManualLabel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"N", ",", 
       RowBox[{"v", "+", "0.5", "+", "0.25"}]}], "}"}], ",", 
     "\"\<\[VerticalEllipsis]\>\""}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.484771232625*^9, 3.484771261671875*^9}, {
   3.484771425734375*^9, 3.4847714690625*^9}, {3.484771529109375*^9, 
   3.484771539234375*^9}, {3.484772151875*^9, 3.48477217065625*^9}, {
   3.484772547640625*^9, 3.48477256515625*^9}, {3.484772597640625*^9, 
   3.48477261821875*^9}, 3.48477265509375*^9, {3.484774961234375*^9, 
   3.48477499371875*^9}, {3.48477512915625*^9, 3.484775151078125*^9}, {
   3.48477519909375*^9, 3.484775260390625*^9}, {3.48477565565625*^9, 
   3.48477566178125*^9}, 3.48477599353125*^9, {3.484776041734375*^9, 
   3.48477604490625*^9}, {3.4847761121875*^9, 3.48477621546875*^9}, {
   3.4847762741875*^9, 3.484776284796875*^9}, {3.484776994796875*^9, 
   3.48477705896875*^9}, {3.4847771034375*^9, 3.484777106078125*^9}, {
   3.48477713753125*^9, 3.484777156734375*^9}, {3.4847772154375*^9, 
   3.48477721678125*^9}, {3.4847772808125*^9, 3.4847772973125*^9}, {
   3.48477735465625*^9, 3.48477740865625*^9}, {3.4847775466875*^9, 
   3.484777585640625*^9}, {3.4848359379375*^9, 3.48483596296875*^9}, {
   3.48571588434375*^9, 3.485715906625*^9}, {3.48667959440625*^9, 
   3.486679657453125*^9}, {3.495657942875*^9, 3.495657975109375*^9}, {
   3.495658023*^9, 3.495658033546875*^9}, 3.49565816896875*^9}],

Cell["Diagram components: Arrows", "Text",
 CellChangeTimes->{{3.495658156828125*^9, 3.495658161546875*^9}, {
   3.495658205375*^9, 3.495658215328125*^9}, 3.495658252828125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OverlapNetwork", "[", 
    RowBox[{"v_", ",", "N_"}], "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SchemeArrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"N", ",", "v"}], "}"}], "+", "LL"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"N", ",", 
           RowBox[{"v", "-", "0.5"}]}], "}"}], "+", "UL"}]}], "}"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"N", ",", "v"}], "}"}], "+", "LR"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"N", ",", 
           RowBox[{"v", "-", "1"}]}], "}"}], "+", "UR"}]}], "}"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"OBMENetwork", "[", 
    RowBox[{"v_", ",", "N_"}], "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"N", ",", 
            RowBox[{"v", "+", "0.5"}]}], "}"}], "+", "ML"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"N", "-", "1"}], ",", 
            RowBox[{"v", "+", "0.5"}]}], "}"}], "+", "MR"}]}], "}"}], ",", 
       RowBox[{"Show", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"N", ">", "0"}], ")"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"N", ",", 
            RowBox[{"v", "+", "0.5"}]}], "}"}], "+", "LL"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"N", "-", "1"}], ",", "v"}], "}"}], "+", "UR"}]}], "}"}], 
       ",", 
       RowBox[{"Show", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"N", ">", "0"}], ")"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"N", ",", 
            RowBox[{"v", "+", "0.5"}]}], "}"}], "+", "LC"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"N", ",", "v"}], "}"}], "+", "UC"}]}], "}"}], ",", 
       RowBox[{"Show", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"v", ">", "0"}], ")"}]}]}], "]"}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.484771232625*^9, 3.484771261671875*^9}, {
   3.484771425734375*^9, 3.4847714690625*^9}, {3.484771529109375*^9, 
   3.484771539234375*^9}, {3.484772151875*^9, 3.48477217065625*^9}, {
   3.484772547640625*^9, 3.48477256515625*^9}, {3.484772597640625*^9, 
   3.48477261821875*^9}, 3.48477265509375*^9, {3.484774961234375*^9, 
   3.48477499371875*^9}, {3.48477512915625*^9, 3.484775151078125*^9}, {
   3.48477519909375*^9, 3.484775260390625*^9}, {3.48477565565625*^9, 
   3.48477566178125*^9}, 3.48477599353125*^9, {3.484776041734375*^9, 
   3.48477604490625*^9}, {3.4847761121875*^9, 3.48477621546875*^9}, {
   3.4847762741875*^9, 3.484776284796875*^9}, {3.484776994796875*^9, 
   3.48477705896875*^9}, {3.4847771034375*^9, 3.484777106078125*^9}, {
   3.48477713753125*^9, 3.484777156734375*^9}, {3.4847772154375*^9, 
   3.48477721678125*^9}, {3.4847772808125*^9, 3.4847772973125*^9}, {
   3.48477735465625*^9, 3.48477740865625*^9}, {3.4847775466875*^9, 
   3.484777585640625*^9}, {3.4848359379375*^9, 3.48483596296875*^9}, {
   3.48571588434375*^9, 3.485715906625*^9}, {3.48667959440625*^9, 
   3.486679657453125*^9}, {3.495657942875*^9, 3.495657975109375*^9}, {
   3.495658023*^9, 3.495658033546875*^9}, 3.49565816896875*^9, 
   3.495658217890625*^9}],

Cell["Diagram components: Labels", "Text",
 CellChangeTimes->{{3.495658156828125*^9, 3.495658161546875*^9}, {
   3.495658205375*^9, 3.49565822215625*^9}, 3.495658252859375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OverlapLabel", "[", "v_", "]"}], ":=", 
   RowBox[{"ManualLabel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "v"}], "}"}], ",", 
     RowBox[{"Subsuperscript", "[", 
      RowBox[{
       RowBox[{"textit", "[", "\"\<O\>\"", "]"}], ",", 
       RowBox[{"textit", "[", "\"\<N\>\"", "]"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<(\>\"", ",", "v", ",", "\"\<)\>\""}], "}"}], "]"}]}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OBMELabel", "[", "v_", "]"}], ":=", 
   RowBox[{"ManualLabel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", 
       RowBox[{"v", "+", "0.5"}]}], "}"}], ",", 
     RowBox[{"Subsuperscript", "[", 
      RowBox[{
       RowBox[{"textit", "[", "\"\<T\>\"", "]"}], ",", 
       RowBox[{"textit", "[", "\"\<N\>\"", "]"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<(\>\"", ",", "v", ",", "\"\<)\>\""}], "}"}], "]"}]}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OverlapRecur", "[", "v_", "]"}], ":=", 
   RowBox[{"ManualLabel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NMax", "+", "0.5"}], ",", 
       RowBox[{"v", "-", "0.25"}]}], "}"}], ",", 
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<(\>\"", ",", 
        RowBox[{"OverlapEquations", "[", 
         RowBox[{"[", 
          RowBox[{"v", "+", "1"}], "]"}], "]"}], ",", "\"\<)\>\""}], "}"}], 
      "]"}], ",", 
     RowBox[{"Show", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"v", ">", "0"}], ")"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OBMERecur", "[", "v_", "]"}], ":=", 
   RowBox[{"ManualLabel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NMax", "+", "0.5"}], ",", 
       RowBox[{"v", "+", "0.5", "-", "0.25"}]}], "}"}], ",", 
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<(\>\"", ",", 
        RowBox[{"OBMEEquations", "[", 
         RowBox[{"[", 
          RowBox[{"v", "+", "1"}], "]"}], "]"}], ",", "\"\<)\>\""}], "}"}], 
      "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"OverlapEquations", "=", 
   RowBox[{
    RowBox[{"{", "None", "}"}], "~", "Join", "~", 
    RowBox[{"Range", "[", 
     RowBox[{"54", ",", 
      RowBox[{"54", "+", "3"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OBMEEquations", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"47", ",", 
     RowBox[{"47", "+", "4"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.484771232625*^9, 3.484771261671875*^9}, {
   3.484771425734375*^9, 3.4847714690625*^9}, {3.484771529109375*^9, 
   3.484771539234375*^9}, {3.484772151875*^9, 3.48477217065625*^9}, {
   3.484772547640625*^9, 3.48477256515625*^9}, {3.484772597640625*^9, 
   3.48477261821875*^9}, 3.48477265509375*^9, {3.484774961234375*^9, 
   3.48477499371875*^9}, {3.48477512915625*^9, 3.484775151078125*^9}, {
   3.48477519909375*^9, 3.484775260390625*^9}, {3.48477565565625*^9, 
   3.48477566178125*^9}, 3.48477599353125*^9, {3.484776041734375*^9, 
   3.48477604490625*^9}, {3.4847761121875*^9, 3.48477621546875*^9}, {
   3.4847762741875*^9, 3.484776284796875*^9}, {3.484776994796875*^9, 
   3.48477705896875*^9}, {3.4847771034375*^9, 3.484777106078125*^9}, {
   3.48477713753125*^9, 3.484777156734375*^9}, {3.4847772154375*^9, 
   3.48477721678125*^9}, {3.4847772808125*^9, 3.4847772973125*^9}, {
   3.48477735465625*^9, 3.48477740865625*^9}, {3.4847775466875*^9, 
   3.484777585640625*^9}, {3.4848359379375*^9, 3.48483596296875*^9}, {
   3.48571588434375*^9, 3.485715906625*^9}, {3.48667959440625*^9, 
   3.486679657453125*^9}, {3.495657942875*^9, 3.495657975109375*^9}, {
   3.495658023*^9, 3.495658033546875*^9}, 3.49565816896875*^9, 
   3.495658217890625*^9}],

Cell["Draw figure", "Text",
 CellChangeTimes->{{3.4956583750625*^9, 3.495658473125*^9}, {
  3.4956586949375*^9, 3.495658695234375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Figure", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetOptions", "[", 
       RowBox[{"SchemeArrow", ",", 
        RowBox[{"HeadLip", "\[Rule]", "2"}], ",", 
        RowBox[{"HeadLength", "\[Rule]", "2"}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"define", " ", "network", " ", "size"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vMax", "=", "4"}], ";", "\[IndentingNewLine]", 
       RowBox[{"NMax", "=", "4"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"define", " ", "dot", " ", "dimensions"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"DotRadius", "=", 
        RowBox[{"ConvertCoordinate", "[", 
         RowBox[{"AbsoluteCoords", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}], ",", "D"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"DotScale", "=", "1.5"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"UR", "=", 
        RowBox[{"DotScale", "*", "DotRadius", "*", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"UC", "=", 
        RowBox[{"DotScale", "*", "DotRadius", "*", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"UL", "=", 
        RowBox[{"DotScale", "*", "DotRadius", "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ML", "=", 
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "*", "DotScale", "*", "DotRadius", 
         "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MR", "=", 
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "*", "DotScale", "*", "DotRadius", 
         "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"+", "1"}], ",", "0"}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"LR", "=", 
        RowBox[{"DotScale", "*", "DotRadius", "*", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"LC", "=", 
        RowBox[{"DotScale", "*", "DotRadius", "*", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"LL", "=", 
        RowBox[{"DotScale", "*", "DotRadius", "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "axes", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"SchemeAxis", "[", 
        RowBox[{"Left", ",", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"vMax", "+", "0.5"}]}], "}"}], ",", 
         RowBox[{"LabL", "\[Rule]", "RoundedV"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SchemeAxis", "[", 
       RowBox[{"Bottom", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "NMax"}], "}"}], ",", 
        RowBox[{"-", "0.3"}], ",", 
        RowBox[{"LabB", "\[Rule]", 
         RowBox[{"textit", "[", "\"\<N\>\"", "]"}]}], ",", 
        RowBox[{"Ticks", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "\"\<0\>\""}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "\"\<1\>\""}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "\"\<2\>\""}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "\"\<\[CenterEllipsis]\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], ",", 
        RowBox[{"PosnB", "\[Rule]", "1"}], ",", 
        RowBox[{"OffsetB", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
        RowBox[{"BufferB", "\[Rule]", "0"}]}], "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"side", " ", "labels"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"OverlapLabel", "[", "v", "]"}], ",", 
          RowBox[{"OBMELabel", "[", "v", "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"v", ",", "0", ",", "vMax"}], "}"}]}], "\[IndentingNewLine]",
        "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"SchemeIfDef", "[", "\[IndentingNewLine]", 
       RowBox[{"\"\<EqnNumber\>\"", ",", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"OverlapRecur", "[", "v", "]"}], ",", 
            RowBox[{"OBMERecur", "[", "v", "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"v", ",", "0", ",", "vMax"}], "}"}]}], 
         "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"top", " ", "labels"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"UpEllipsis", "[", 
         RowBox[{"vMax", ",", "N"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"N", ",", "0", ",", "NMax"}], "}"}]}], "\[IndentingNewLine]",
        "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"DEBUGGING", ":", " ", 
         RowBox[{"on", " ", "network", " ", "arrows"}]}], ",", " ", 
        RowBox[{
        "use", " ", "dummy", " ", "index", " ", "names", " ", "different", 
         " ", "from", " ", 
         RowBox[{"(", 
          RowBox[{"N", ",", "v"}], ")"}]}], ",", " ", 
        RowBox[{
        "to", " ", "prevent", " ", "bizarre", " ", "errors", " ", "when", " ",
          "function", " ", "definition", " ", "dummy", " ", "index", " ", 
         "has", " ", "same", " ", "name", " ", "as", " ", "loop", " ", 
         "dummy", " ", "index"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"nodes", " ", "and", " ", "arrows"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"BlockSchemeOptions", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SetOptions", "[", 
          RowBox[{"SchemeObject", ",", 
           RowBox[{"Color", "\[Rule]", 
            RowBox[{"SchemeIfElseDef", "[", 
             RowBox[{"\"\<Color\>\"", ",", "Blue", ",", "Black"}], "]"}]}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"OverlapDot", "[", 
            RowBox[{"v", ",", "N"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"N", ",", "0", ",", "NMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"v", ",", "0", ",", "vMax"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"OverlapNetwork", "[", 
            RowBox[{"vx", ",", "Nx"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"Nx", ",", "0", ",", "NMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"vx", ",", "1", ",", "vMax"}], "}"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BlockSchemeOptions", "[", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SetOptions", "[", 
          RowBox[{"SchemeObject", ",", 
           RowBox[{"Color", "->", 
            RowBox[{"SchemeIfElseDef", "[", 
             RowBox[{"\"\<Color\>\"", ",", "Red", ",", "Gray"}], "]"}]}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"OBMEDot", "[", 
            RowBox[{"v", ",", "N"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"N", ",", "0", ",", "NMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"v", ",", "0", ",", "vMax"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"OBMENetwork", "[", 
            RowBox[{"vx", ",", "Nx"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"Nx", ",", "0", ",", "NMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"vx", ",", "0", ",", "vMax"}], "}"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ","}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "6"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"72", "*", 
      RowBox[{"{", 
       RowBox[{"6", ",", "6"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"SchemeFlags", "\[Rule]", 
     RowBox[{"{", "\"\<Color\>\"", "}"}]}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "clear", " ", "some", " ", "variable", " ", "names", " ", "used", " ", 
    "in", " ", "example", " ", "below"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"DotScale", ",", "DotRadius"}], "]"}], " "}]}], "Input",
 CellChangeTimes->{{3.40243520075*^9, 3.40243524146875*^9}, {
   3.402435289734375*^9, 3.402435537453125*^9}, {3.402435570578125*^9, 
   3.402435759390625*^9}, {3.40243588296875*^9, 3.40243591275*^9}, {
   3.40829301315625*^9, 3.40829302334375*^9}, {3.484769285328125*^9, 
   3.4847692855*^9}, {3.484769903984375*^9, 3.484769938453125*^9}, {
   3.4847700048125*^9, 3.4847700455*^9}, {3.484771194703125*^9, 
   3.484771227484375*^9}, {3.4847714413125*^9, 3.484771513515625*^9}, {
   3.484771633453125*^9, 3.48477178225*^9}, {3.484771866109375*^9, 
   3.4847718805*^9}, {3.484772231546875*^9, 3.48477238303125*^9}, {
   3.484772658921875*^9, 3.484772676859375*^9}, 3.484774066359375*^9, {
   3.484774270578125*^9, 3.4847743265625*^9}, {3.484774849375*^9, 
   3.484774898921875*^9}, {3.4847750326875*^9, 3.484775081484375*^9}, {
   3.484775157390625*^9, 3.484775169921875*^9}, {3.48477527925*^9, 
   3.484775312171875*^9}, {3.48477537065625*^9, 3.484775513515625*^9}, {
   3.484775549015625*^9, 3.4847755871875*^9}, {3.48477567359375*^9, 
   3.4847756765*^9}, {3.484775718640625*^9, 3.484775744859375*^9}, {
   3.484775853640625*^9, 3.484776009796875*^9}, {3.484776078390625*^9, 
   3.4847761035625*^9}, {3.484776224828125*^9, 3.48477625071875*^9}, {
   3.48477629371875*^9, 3.48477630890625*^9}, {3.484776362375*^9, 
   3.48477650171875*^9}, {3.484776578984375*^9, 3.48477662178125*^9}, {
   3.484776668734375*^9, 3.484776762984375*^9}, 3.484776795609375*^9, {
   3.484777071578125*^9, 3.48477708240625*^9}, {3.4847773299375*^9, 
   3.48477734821875*^9}, {3.484777601546875*^9, 3.484777630703125*^9}, {
   3.484777704984375*^9, 3.4847777088125*^9}, {3.48477773884375*^9, 
   3.484777835203125*^9}, {3.484777886109375*^9, 3.484777923203125*^9}, {
   3.484778119703125*^9, 3.484778169921875*^9}, {3.484835987953125*^9, 
   3.484836023578125*^9}, {3.484836122359375*^9, 3.484836154734375*^9}, {
   3.484836191578125*^9, 3.484836257078125*^9}, 3.485715930328125*^9, {
   3.485821326265625*^9, 3.485821348671875*^9}, {3.48701129153125*^9, 
   3.487011312296875*^9}, {3.489427811796875*^9, 3.4894278501875*^9}, 
   3.4894279020625*^9, {3.49565794325*^9, 3.49565795540625*^9}, 
   3.495658083171875*^9, {3.4956581160625*^9, 3.4956581174375*^9}, {
   3.495658276609375*^9, 3.495658348703125*^9}, {3.495658721703125*^9, 
   3.49565872234375*^9}, {3.50751313375*^9, 3.507513174953125*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1., 0.}, {-1., 4.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.0555666666666665`, 4.388866666666667}, {-1., 
     4.5}, {-0.9444333333333335, 4.388866666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0., -0.3}, {4., -0.3}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.888866666666667, -0.24443333333333328`}, {
     4., -0.2999999999999998}, {3.888866666666667, -0.3555666666666666}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], {LineBox[{{0., -0.239988}, {0., -0.3}}], 
     LineBox[{{1., -0.239988}, {1., -0.3}}], 
     LineBox[{{2., -0.239988}, {2., -0.3}}]}, 
    {RGBColor[0, 0, 1], Opacity[1], 
     DiskBox[{0., 0.}, 0.03704444444444444, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
     CapForm[None], 
     CircleBox[{0., 0.}, 0.05556666666666667, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
     {RGBColor[0, 0, 1], Opacity[1], 
      DiskBox[{0., 1.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {RGBColor[0, 0, 1], Opacity[1], 
      DiskBox[{0., 2.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {RGBColor[0, 0, 1], Opacity[1], 
      DiskBox[{0., 3.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {RGBColor[0, 0, 1], Opacity[1], 
      DiskBox[{0., 4.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {RGBColor[0, 0, 1], Opacity[1], 
      DiskBox[{1., 0.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
      CapForm[None], 
      CircleBox[{1., 0.}, 0.05556666666666667, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
      {RGBColor[0, 0, 1], Opacity[1], 
       DiskBox[{1., 1.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {RGBColor[0, 0, 1], Opacity[1], 
       DiskBox[{1., 2.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {RGBColor[0, 0, 1], Opacity[1], 
       DiskBox[{1., 3.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {RGBColor[0, 0, 1], Opacity[1], 
       DiskBox[{1., 4.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {RGBColor[0, 0, 1], Opacity[1], 
       DiskBox[{2., 0.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
       CapForm[None], 
       CircleBox[{2., 0.}, 0.05556666666666667, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
       {RGBColor[0, 0, 1], Opacity[1], 
        DiskBox[{2., 1.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {RGBColor[0, 0, 1], Opacity[1], 
        DiskBox[{2., 2.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {RGBColor[0, 0, 1], Opacity[1], 
        DiskBox[{2., 3.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {RGBColor[0, 0, 1], Opacity[1], 
        DiskBox[{2., 4.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {RGBColor[0, 0, 1], Opacity[1], 
        DiskBox[{3., 0.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
        CapForm[None], 
        CircleBox[{3., 0.}, 0.05556666666666667, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
        {RGBColor[0, 0, 1], Opacity[1], 
         DiskBox[{3., 1.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {RGBColor[0, 0, 1], Opacity[1], 
         DiskBox[{3., 2.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {RGBColor[0, 0, 1], Opacity[1], 
         DiskBox[{3., 3.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {RGBColor[0, 0, 1], Opacity[1], 
         DiskBox[{3., 4.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {RGBColor[0, 0, 1], Opacity[1], 
         DiskBox[{4., 0.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
         CapForm[None], 
         CircleBox[{4., 0.}, 0.05556666666666667, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
         {RGBColor[0, 0, 1], Opacity[1], 
          DiskBox[{4., 1.}, 0.03704444444444444, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {RGBColor[0, 0, 1], Opacity[1], 
          DiskBox[{4., 2.}, 0.03704444444444444, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {RGBColor[0, 0, 1], Opacity[1], 
          DiskBox[{4., 3.}, 0.03704444444444444, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {RGBColor[0, 0, 1], Opacity[1], 
          DiskBox[{4., 4.}, 0.03704444444444444, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.055566666666666764`, 
           0.944433333333333}, {-0.055566666666666764`, 
           0.5555666666666665}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.01852222222222233, 
           0.5926111111111108}, {-0.055566666666666764`, 
           0.5555666666666665}, {-0.0926111111111112, 0.5926111111111108}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.05556666666666654, 0.944433333333333}, {
           0.05556666666666654, 0.05556666666666654}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.0926111111111112, 0.0926111111111112}, {
           0.05556666666666654, 0.05556666666666654}, {0.01852222222222233, 
           0.0926111111111112}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.055566666666666764`, 
           1.944433333333333}, {-0.055566666666666764`, 
           1.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.01852222222222233, 
           1.5926111111111108`}, {-0.055566666666666764`, 
           1.5555666666666665`}, {-0.0926111111111112, 
           1.5926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.05556666666666654, 1.944433333333333}, {
           0.05556666666666654, 1.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.0926111111111112, 1.0926111111111108`}, {
           0.05556666666666654, 1.0555666666666665`}, {0.01852222222222233, 
           1.0926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.055566666666666764`, 
           2.9444333333333335`}, {-0.055566666666666764`, 
           2.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.01852222222222233, 
           2.592611111111111}, {-0.055566666666666764`, 
           2.5555666666666665`}, {-0.0926111111111112, 2.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.05556666666666654, 2.9444333333333335`}, {
           0.05556666666666654, 2.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.0926111111111112, 2.092611111111111}, {
           0.05556666666666654, 2.0555666666666665`}, {0.01852222222222233, 
           2.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.055566666666666764`, 
           3.9444333333333335`}, {-0.055566666666666764`, 
           3.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.01852222222222233, 
           3.592611111111111}, {-0.055566666666666764`, 
           3.5555666666666665`}, {-0.0926111111111112, 3.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.05556666666666654, 3.9444333333333335`}, {
           0.05556666666666654, 3.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.0926111111111112, 3.092611111111111}, {
           0.05556666666666654, 3.0555666666666665`}, {0.01852222222222233, 
           3.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.944433333333333, 0.944433333333333}, {0.944433333333333,
            0.5555666666666665}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.9814777777777777, 0.5926111111111108}, {
           0.944433333333333, 0.5555666666666665}, {0.9073888888888888, 
           0.5926111111111108}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0555666666666665`, 0.944433333333333}, {
           1.0555666666666665`, 0.05556666666666654}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0926111111111108`, 0.0926111111111112}, {
           1.0555666666666665`, 0.05556666666666654}, {1.0185222222222219`, 
           0.0926111111111112}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.944433333333333, 1.944433333333333}, {0.944433333333333,
            1.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.9814777777777777, 1.5926111111111108`}, {
           0.944433333333333, 1.5555666666666665`}, {0.9073888888888888, 
           1.5926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0555666666666665`, 1.944433333333333}, {
           1.0555666666666665`, 1.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0926111111111108`, 1.0926111111111108`}, {
           1.0555666666666665`, 1.0555666666666665`}, {1.0185222222222219`, 
           1.0926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.944433333333333, 2.9444333333333335`}, {
           0.944433333333333, 2.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.9814777777777777, 2.592611111111111}, {
           0.944433333333333, 2.5555666666666665`}, {0.9073888888888888, 
           2.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0555666666666665`, 2.9444333333333335`}, {
           1.0555666666666665`, 2.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0926111111111108`, 2.092611111111111}, {
           1.0555666666666665`, 2.0555666666666665`}, {1.0185222222222219`, 
           2.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.944433333333333, 3.9444333333333335`}, {
           0.944433333333333, 3.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.9814777777777777, 3.592611111111111}, {
           0.944433333333333, 3.5555666666666665`}, {0.9073888888888888, 
           3.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0555666666666665`, 3.9444333333333335`}, {
           1.0555666666666665`, 3.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0926111111111108`, 3.092611111111111}, {
           1.0555666666666665`, 3.0555666666666665`}, {1.0185222222222219`, 
           3.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.944433333333333, 0.944433333333333}, {1.944433333333333,
            0.5555666666666665}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.9814777777777777`, 0.5926111111111108}, {
           1.944433333333333, 0.5555666666666665}, {1.9073888888888888`, 
           0.5926111111111108}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.0555666666666665`, 0.944433333333333}, {
           2.0555666666666665`, 0.05556666666666654}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.092611111111111, 0.0926111111111112}, {
           2.0555666666666665`, 0.05556666666666654}, {2.018522222222222, 
           0.0926111111111112}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.944433333333333, 1.944433333333333}, {1.944433333333333,
            1.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.9814777777777777`, 1.5926111111111108`}, {
           1.944433333333333, 1.5555666666666665`}, {1.9073888888888888`, 
           1.5926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.0555666666666665`, 1.944433333333333}, {
           2.0555666666666665`, 1.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.092611111111111, 1.0926111111111108`}, {
           2.0555666666666665`, 1.0555666666666665`}, {2.018522222222222, 
           1.0926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.944433333333333, 2.9444333333333335`}, {
           1.944433333333333, 2.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.9814777777777777`, 2.592611111111111}, {
           1.944433333333333, 2.5555666666666665`}, {1.9073888888888888`, 
           2.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.0555666666666665`, 2.9444333333333335`}, {
           2.0555666666666665`, 2.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.092611111111111, 2.092611111111111}, {
           2.0555666666666665`, 2.0555666666666665`}, {2.018522222222222, 
           2.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.944433333333333, 3.9444333333333335`}, {
           1.944433333333333, 3.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.9814777777777777`, 3.592611111111111}, {
           1.944433333333333, 3.5555666666666665`}, {1.9073888888888888`, 
           3.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.0555666666666665`, 3.9444333333333335`}, {
           2.0555666666666665`, 3.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.092611111111111, 3.092611111111111}, {
           2.0555666666666665`, 3.0555666666666665`}, {2.018522222222222, 
           3.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.9444333333333335`, 0.944433333333333}, {
           2.9444333333333335`, 0.5555666666666665}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.981477777777778, 0.5926111111111108}, {
           2.9444333333333335`, 0.5555666666666665}, {2.907388888888889, 
           0.5926111111111108}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.0555666666666665`, 0.944433333333333}, {
           3.0555666666666665`, 0.05556666666666654}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.092611111111111, 0.0926111111111112}, {
           3.0555666666666665`, 0.05556666666666654}, {3.018522222222222, 
           0.0926111111111112}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.9444333333333335`, 1.944433333333333}, {
           2.9444333333333335`, 1.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.981477777777778, 1.5926111111111108`}, {
           2.9444333333333335`, 1.5555666666666665`}, {2.907388888888889, 
           1.5926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.0555666666666665`, 1.944433333333333}, {
           3.0555666666666665`, 1.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.092611111111111, 1.0926111111111108`}, {
           3.0555666666666665`, 1.0555666666666665`}, {3.018522222222222, 
           1.0926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.9444333333333335`, 2.9444333333333335`}, {
           2.9444333333333335`, 2.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.981477777777778, 2.592611111111111}, {
           2.9444333333333335`, 2.5555666666666665`}, {2.907388888888889, 
           2.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.0555666666666665`, 2.9444333333333335`}, {
           3.0555666666666665`, 2.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.092611111111111, 2.092611111111111}, {
           3.0555666666666665`, 2.0555666666666665`}, {3.018522222222222, 
           2.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.9444333333333335`, 3.9444333333333335`}, {
           2.9444333333333335`, 3.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.981477777777778, 3.592611111111111}, {
           2.9444333333333335`, 3.5555666666666665`}, {2.907388888888889, 
           3.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.0555666666666665`, 3.9444333333333335`}, {
           3.0555666666666665`, 3.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.092611111111111, 3.092611111111111}, {
           3.0555666666666665`, 3.0555666666666665`}, {3.018522222222222, 
           3.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.9444333333333335`, 0.944433333333333}, {
           3.9444333333333335`, 0.5555666666666665}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.981477777777778, 0.5926111111111108}, {
           3.9444333333333335`, 0.5555666666666665}, {3.907388888888889, 
           0.5926111111111108}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.0555666666666665`, 0.944433333333333}, {
           4.0555666666666665`, 0.05556666666666654}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.092611111111111, 0.0926111111111112}, {
           4.0555666666666665`, 0.05556666666666654}, {4.018522222222222, 
           0.0926111111111112}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.9444333333333335`, 1.944433333333333}, {
           3.9444333333333335`, 1.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.981477777777778, 1.5926111111111108`}, {
           3.9444333333333335`, 1.5555666666666665`}, {3.907388888888889, 
           1.5926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.0555666666666665`, 1.944433333333333}, {
           4.0555666666666665`, 1.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.092611111111111, 1.0926111111111108`}, {
           4.0555666666666665`, 1.0555666666666665`}, {4.018522222222222, 
           1.0926111111111108`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.9444333333333335`, 2.9444333333333335`}, {
           3.9444333333333335`, 2.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.981477777777778, 2.592611111111111}, {
           3.9444333333333335`, 2.5555666666666665`}, {3.907388888888889, 
           2.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.0555666666666665`, 2.9444333333333335`}, {
           4.0555666666666665`, 2.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.092611111111111, 2.092611111111111}, {
           4.0555666666666665`, 2.0555666666666665`}, {4.018522222222222, 
           2.092611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.9444333333333335`, 3.9444333333333335`}, {
           3.9444333333333335`, 3.5555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.981477777777778, 3.592611111111111}, {
           3.9444333333333335`, 3.5555666666666665`}, {3.907388888888889, 
           3.592611111111111}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.0555666666666665`, 3.9444333333333335`}, {
           4.0555666666666665`, 3.0555666666666665`}}]}, 
         {RGBColor[0, 0, 1], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.092611111111111, 3.092611111111111}, {
           4.0555666666666665`, 3.0555666666666665`}, {4.018522222222222, 
           3.092611111111111}}], 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{0., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{0., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{0., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{0., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{0., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{1., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{1., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{1., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{1., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{1., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{2., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{2., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{2., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{2., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{2., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{3., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{3., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{3., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{3., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{3., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{4., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{4., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{4., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{4., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{4., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0., 1.444433333333333}, {0., 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.03704444444444421, 1.0926111111111108`}, {0., 
            1.0555666666666665`}, {-0.037044444444444435`, 
            1.0926111111111108`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0., 2.4444333333333335`}, {0., 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.03704444444444421, 2.092611111111111}, {0., 
            2.0555666666666665`}, {-0.037044444444444435`, 
            2.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0., 3.4444333333333335`}, {0., 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.03704444444444421, 3.092611111111111}, {0., 
            3.0555666666666665`}, {-0.037044444444444435`, 
            3.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0., 4.4444333333333335`}, {0., 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.03704444444444421, 4.092611111111111}, {0., 
            4.0555666666666665`}, {-0.037044444444444435`, 
            4.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 0.49999999999999956`}, {
            0.07858313361586511, 0.49999999999999956`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 0.46295555555555534`}, {
            0.07858313361586511, 0.49999999999999956`}, {0.11562757806030932`,
             0.5370444444444442}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 0.444433333333333}, {
            0.055566666666666986`, 0.05556666666666654}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110819`, 0.03647566234216937}, {
            0.055566666666666986`, 0.05556666666666654}, {0.07465767099116372,
             0.10435309185110775`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 1.5}, {0.07858313361586511, 1.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 1.4629555555555553`}, {
            0.07858313361586511, 1.5}, {0.11562757806030932`, 
            1.5370444444444442`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 1.444433333333333}, {
            0.05556666666666654, 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110775`, 1.0364756623421694`}, {
            0.05556666666666654, 1.0555666666666665`}, {0.07465767099116372, 
            1.1043530918511077`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9999999999999996, 1.444433333333333}, {
            0.9999999999999996, 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.0370444444444442`, 1.0926111111111108`}, {
            0.9999999999999996, 1.0555666666666665`}, {0.9629555555555553, 
            1.0926111111111108`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 2.5}, {0.07858313361586511, 2.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 2.4629555555555553`}, {
            0.07858313361586511, 2.5}, {0.11562757806030932`, 
            2.5370444444444447`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 2.4444333333333335`}, {
            0.05556666666666654, 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110775`, 2.036475662342169}, {
            0.05556666666666654, 2.0555666666666665`}, {0.07465767099116372, 
            2.1043530918511077`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9999999999999996, 2.4444333333333335`}, {
            0.9999999999999996, 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.0370444444444442`, 2.092611111111111}, {
            0.9999999999999996, 2.0555666666666665`}, {0.9629555555555553, 
            2.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 3.5}, {0.07858313361586511, 3.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 3.4629555555555553`}, {
            0.07858313361586511, 3.5}, {0.11562757806030932`, 
            3.5370444444444447`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 3.4444333333333335`}, {
            0.05556666666666654, 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110775`, 3.03647566234217}, {
            0.05556666666666654, 3.0555666666666665`}, {0.07465767099116372, 
            3.1043530918511086`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9999999999999996, 3.4444333333333335`}, {
            0.9999999999999996, 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.0370444444444442`, 3.092611111111111}, {
            0.9999999999999996, 3.0555666666666665`}, {0.9629555555555553, 
            3.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 4.5}, {0.07858313361586511, 4.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 4.462955555555555}, {
            0.07858313361586511, 4.5}, {0.11562757806030932`, 
            4.537044444444445}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 4.4444333333333335`}, {
            0.05556666666666654, 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110775`, 4.03647566234217}, {
            0.05556666666666654, 4.0555666666666665`}, {0.07465767099116372, 
            4.104353091851109}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9999999999999996, 4.4444333333333335`}, {
            0.9999999999999996, 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.0370444444444442`, 4.092611111111111}, {
            0.9999999999999996, 4.0555666666666665`}, {0.9629555555555553, 
            4.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 0.49999999999999956`}, {
            1.0785831336158647`, 0.49999999999999956`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 0.46295555555555534`}, {
            1.0785831336158647`, 0.49999999999999956`}, {1.1156275780603093`, 
            0.5370444444444442}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 0.444433333333333}, {
            1.0555666666666665`, 0.055566666666666986`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 0.03647566234216981}, {
            1.0555666666666665`, 0.055566666666666986`}, {1.0746576709911637`,
             0.10435309185110819`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 1.5}, {1.0785831336158647`, 1.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 1.4629555555555553`}, {
            1.0785831336158647`, 1.5}, {1.1156275780603093`, 
            1.5370444444444442`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 1.444433333333333}, {
            1.0555666666666665`, 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 1.0364756623421694`}, {
            1.0555666666666665`, 1.0555666666666665`}, {1.0746576709911637`, 
            1.1043530918511077`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2., 1.444433333333333}, {2., 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.0370444444444447`, 1.0926111111111108`}, {2., 
            1.0555666666666665`}, {1.9629555555555553`, 
            1.0926111111111108`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 2.5}, {1.0785831336158647`, 2.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 2.4629555555555553`}, {
            1.0785831336158647`, 2.5}, {1.1156275780603093`, 
            2.5370444444444447`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 2.4444333333333335`}, {
            1.0555666666666665`, 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 2.036475662342169}, {
            1.0555666666666665`, 2.0555666666666665`}, {1.0746576709911637`, 
            2.1043530918511077`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2., 2.4444333333333335`}, {2., 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.0370444444444447`, 2.092611111111111}, {2., 
            2.0555666666666665`}, {1.9629555555555553`, 2.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 3.5}, {1.0785831336158647`, 3.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 3.4629555555555553`}, {
            1.0785831336158647`, 3.5}, {1.1156275780603093`, 
            3.5370444444444447`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 3.4444333333333335`}, {
            1.0555666666666665`, 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 3.03647566234217}, {
            1.0555666666666665`, 3.0555666666666665`}, {1.0746576709911637`, 
            3.1043530918511086`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2., 3.4444333333333335`}, {2., 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.0370444444444447`, 3.092611111111111}, {2., 
            3.0555666666666665`}, {1.9629555555555553`, 3.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 4.5}, {1.0785831336158647`, 4.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 4.462955555555555}, {
            1.0785831336158647`, 4.5}, {1.1156275780603093`, 
            4.537044444444445}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 4.4444333333333335`}, {
            1.0555666666666665`, 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 4.03647566234217}, {
            1.0555666666666665`, 4.0555666666666665`}, {1.0746576709911637`, 
            4.104353091851109}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2., 4.4444333333333335`}, {2., 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.0370444444444447`, 4.092611111111111}, {2., 
            4.0555666666666665`}, {1.9629555555555553`, 4.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 0.49999999999999956`}, {
            2.078583133615865, 0.49999999999999956`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 0.46295555555555534`}, {
            2.078583133615865, 0.49999999999999956`}, {2.1156275780603098`, 
            0.5370444444444442}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 0.444433333333333}, {
            2.0555666666666665`, 0.055566666666666986`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 0.03647566234216981}, {
            2.0555666666666665`, 0.055566666666666986`}, {2.074657670991164, 
            0.10435309185110819`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 1.5}, {2.078583133615865, 1.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 1.4629555555555553`}, {
            2.078583133615865, 1.5}, {2.1156275780603098`, 
            1.5370444444444442`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 1.444433333333333}, {
            2.0555666666666665`, 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 1.0364756623421694`}, {
            2.0555666666666665`, 1.0555666666666665`}, {2.074657670991164, 
            1.1043530918511077`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3., 1.444433333333333}, {3., 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.0370444444444447`, 1.0926111111111108`}, {3., 
            1.0555666666666665`}, {2.9629555555555553`, 
            1.0926111111111108`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 2.5}, {2.078583133615865, 2.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 2.4629555555555553`}, {
            2.078583133615865, 2.5}, {2.1156275780603098`, 
            2.5370444444444447`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 2.4444333333333335`}, {
            2.0555666666666665`, 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 2.036475662342169}, {
            2.0555666666666665`, 2.0555666666666665`}, {2.074657670991164, 
            2.1043530918511077`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3., 2.4444333333333335`}, {3., 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.0370444444444447`, 2.092611111111111}, {3., 
            2.0555666666666665`}, {2.9629555555555553`, 2.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 3.5}, {2.078583133615865, 3.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 3.4629555555555553`}, {
            2.078583133615865, 3.5}, {2.1156275780603098`, 
            3.5370444444444447`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 3.4444333333333335`}, {
            2.0555666666666665`, 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 3.03647566234217}, {
            2.0555666666666665`, 3.0555666666666665`}, {2.074657670991164, 
            3.1043530918511086`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3., 3.4444333333333335`}, {3., 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.0370444444444447`, 3.092611111111111}, {3., 
            3.0555666666666665`}, {2.9629555555555553`, 3.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 4.5}, {2.078583133615865, 4.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 4.462955555555555}, {
            2.078583133615865, 4.5}, {2.1156275780603098`, 
            4.537044444444445}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 4.4444333333333335`}, {
            2.0555666666666665`, 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 4.03647566234217}, {
            2.0555666666666665`, 4.0555666666666665`}, {2.074657670991164, 
            4.104353091851109}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3., 4.4444333333333335`}, {3., 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.0370444444444447`, 4.092611111111111}, {3., 
            4.0555666666666665`}, {2.9629555555555553`, 4.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 0.49999999999999956`}, {
            3.078583133615864, 0.49999999999999956`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 0.46295555555555534`}, {
            3.078583133615864, 0.49999999999999956`}, {3.115627578060309, 
            0.5370444444444442}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 0.444433333333333}, {
            3.0555666666666665`, 0.055566666666666986`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 0.03647566234216981}, {
            3.0555666666666665`, 0.055566666666666986`}, {3.0746576709911633`,
             0.10435309185110819`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 1.5}, {3.078583133615864, 1.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 1.4629555555555553`}, {
            3.078583133615864, 1.5}, {3.115627578060309, 
            1.5370444444444442`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 1.444433333333333}, {
            3.0555666666666665`, 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 1.0364756623421694`}, {
            3.0555666666666665`, 1.0555666666666665`}, {3.0746576709911633`, 
            1.1043530918511077`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4., 1.444433333333333}, {4., 1.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4.037044444444445, 1.0926111111111108`}, {4., 
            1.0555666666666665`}, {3.9629555555555553`, 
            1.0926111111111108`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 2.5}, {3.078583133615864, 2.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 2.4629555555555553`}, {
            3.078583133615864, 2.5}, {3.115627578060309, 
            2.5370444444444447`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 2.4444333333333335`}, {
            3.0555666666666665`, 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 2.036475662342169}, {
            3.0555666666666665`, 2.0555666666666665`}, {3.0746576709911633`, 
            2.1043530918511077`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4., 2.4444333333333335`}, {4., 2.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4.037044444444445, 2.092611111111111}, {4., 
            2.0555666666666665`}, {3.9629555555555553`, 2.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 3.5}, {3.078583133615864, 3.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 3.4629555555555553`}, {
            3.078583133615864, 3.5}, {3.115627578060309, 
            3.5370444444444447`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 3.4444333333333335`}, {
            3.0555666666666665`, 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 3.03647566234217}, {
            3.0555666666666665`, 3.0555666666666665`}, {3.0746576709911633`, 
            3.1043530918511086`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4., 3.4444333333333335`}, {4., 3.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4.037044444444445, 3.092611111111111}, {4., 
            3.0555666666666665`}, {3.9629555555555553`, 3.092611111111111}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 4.5}, {3.078583133615864, 4.5}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 4.462955555555555}, {
            3.078583133615864, 4.5}, {3.115627578060309, 
            4.537044444444445}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 4.4444333333333335`}, {
            3.0555666666666665`, 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 4.03647566234217}, {
            3.0555666666666665`, 4.0555666666666665`}, {3.0746576709911633`, 
            4.104353091851109}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4., 4.4444333333333335`}, {4., 4.0555666666666665`}}]}, 
          {RGBColor[1, 0, 0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4.037044444444445, 4.092611111111111}, {4., 
            4.0555666666666665`}, {3.9629555555555553`, 4.092611111111111}}], 
           InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               StyleBox["\<\"v\"\>",
                StripOnInput->False,
                FontFamily->"BookAntiqua",
                FontSlant->Italic],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-1.1315077777777778`, 2.25}, {0, 0}, Automatic, {
            0, 1}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"0\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {0., -0.3092611111111111}, {0, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"1\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {1., -0.3092611111111111}, {0, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"2\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {2., -0.3092611111111111}, {0, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[CenterEllipsis]\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {3., -0.3092611111111111}, {0, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TagBox[
                StyleBox["\<\"N\"\>",
                 FontSlant->"Italic"],
                StyleForm[#, FontSlant -> "Italic"]& ],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4., -0.309261111111111}, {-1, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","0","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 0, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 0.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","0","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 0, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 0.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","1","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 1, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 1.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","1","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 1, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 1.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","2","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 2, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 2.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","2","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 2, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 2.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","3","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 3, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 3.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","3","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 3, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 3.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","4","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 4, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 4.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","4","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 4, ")"}]],
                Editable->False],
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 4.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {0., 4.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {1., 4.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {2., 4.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {3., 4.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              StripOnInput->False,
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4., 4.75}, {0, 0}, Automatic, {1, 0}]}}}}}}}}},
  AspectRatio->1,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{432, 432},
  PlotRange->{{-2.0008, 6.0008}, {-2.0008, 6.0008}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.4956587290625*^9, 3.52552789496875*^9}]
}, Open  ]],

Cell["\<\
For the paper, we instead use
\tSchemeFlags \[Rule] {\"EqnNumber\"}\
\>", "Text",
 CellChangeTimes->{{3.49565806659375*^9, 3.495658067203125*^9}, {
  3.4956581323125*^9, 3.49565813253125*^9}, {3.495658699609375*^9, 
  3.495658713265625*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1., 0.}, {-1., 4.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{-1.0555666666666665`, 4.388866666666667}, {-1., 
     4.5}, {-0.9444333333333335, 4.388866666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0., -0.3}, {4., -0.3}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{3.888866666666667, -0.24443333333333328`}, {
     4., -0.2999999999999998}, {3.888866666666667, -0.3555666666666666}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], {LineBox[{{0., -0.239988}, {0., -0.3}}], 
     LineBox[{{1., -0.239988}, {1., -0.3}}], 
     LineBox[{{2., -0.239988}, {2., -0.3}}]}, 
    {GrayLevel[0], Opacity[1], 
     DiskBox[{0., 0.}, 0.03704444444444444, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], CircleBox[{0., 0.}, 0.05556666666666667, 
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
     {GrayLevel[0], Opacity[1], 
      DiskBox[{0., 1.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0], Opacity[1], 
      DiskBox[{0., 2.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0], Opacity[1], 
      DiskBox[{0., 3.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0], Opacity[1], 
      DiskBox[{0., 4.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0], Opacity[1], 
      DiskBox[{1., 0.}, 0.03704444444444444, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], 
      CircleBox[{1., 0.}, 0.05556666666666667, 
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
      {GrayLevel[0], Opacity[1], 
       DiskBox[{1., 1.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], Opacity[1], 
       DiskBox[{1., 2.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], Opacity[1], 
       DiskBox[{1., 3.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], Opacity[1], 
       DiskBox[{1., 4.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], Opacity[1], 
       DiskBox[{2., 0.}, 0.03704444444444444, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], CircleBox[{2., 0.}, 0.05556666666666667, 
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
       {GrayLevel[0], Opacity[1], 
        DiskBox[{2., 1.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], Opacity[1], 
        DiskBox[{2., 2.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], Opacity[1], 
        DiskBox[{2., 3.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], Opacity[1], 
        DiskBox[{2., 4.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], Opacity[1], 
        DiskBox[{3., 0.}, 0.03704444444444444, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], CircleBox[{3., 0.}, 0.05556666666666667, 
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
        {GrayLevel[0], Opacity[1], 
         DiskBox[{3., 1.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], Opacity[1], 
         DiskBox[{3., 2.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], Opacity[1], 
         DiskBox[{3., 3.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], Opacity[1], 
         DiskBox[{3., 4.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], Opacity[1], 
         DiskBox[{4., 0.}, 0.03704444444444444, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], CircleBox[{4., 0.}, 0.05556666666666667, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
         {GrayLevel[0], Opacity[1], 
          DiskBox[{4., 1.}, 0.03704444444444444, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {GrayLevel[0], Opacity[1], 
          DiskBox[{4., 2.}, 0.03704444444444444, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {GrayLevel[0], Opacity[1], 
          DiskBox[{4., 3.}, 0.03704444444444444, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {GrayLevel[0], Opacity[1], 
          DiskBox[{4., 4.}, 0.03704444444444444, 
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.055566666666666764`, 
           0.944433333333333}, {-0.055566666666666764`, 
           0.5555666666666665}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.01852222222222233, 
           0.5926111111111108}, {-0.055566666666666764`, 
           0.5555666666666665}, {-0.0926111111111112, 0.5926111111111108}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.05556666666666654, 0.944433333333333}, {
           0.05556666666666654, 0.05556666666666654}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.0926111111111112, 0.0926111111111112}, {
           0.05556666666666654, 0.05556666666666654}, {0.01852222222222233, 
           0.0926111111111112}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.055566666666666764`, 
           1.944433333333333}, {-0.055566666666666764`, 
           1.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.01852222222222233, 
           1.5926111111111108`}, {-0.055566666666666764`, 
           1.5555666666666665`}, {-0.0926111111111112, 
           1.5926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.05556666666666654, 1.944433333333333}, {
           0.05556666666666654, 1.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.0926111111111112, 1.0926111111111108`}, {
           0.05556666666666654, 1.0555666666666665`}, {0.01852222222222233, 
           1.0926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.055566666666666764`, 
           2.9444333333333335`}, {-0.055566666666666764`, 
           2.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.01852222222222233, 
           2.592611111111111}, {-0.055566666666666764`, 
           2.5555666666666665`}, {-0.0926111111111112, 2.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.05556666666666654, 2.9444333333333335`}, {
           0.05556666666666654, 2.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.0926111111111112, 2.092611111111111}, {
           0.05556666666666654, 2.0555666666666665`}, {0.01852222222222233, 
           2.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.055566666666666764`, 
           3.9444333333333335`}, {-0.055566666666666764`, 
           3.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{-0.01852222222222233, 
           3.592611111111111}, {-0.055566666666666764`, 
           3.5555666666666665`}, {-0.0926111111111112, 3.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.05556666666666654, 3.9444333333333335`}, {
           0.05556666666666654, 3.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.0926111111111112, 3.092611111111111}, {
           0.05556666666666654, 3.0555666666666665`}, {0.01852222222222233, 
           3.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.944433333333333, 0.944433333333333}, {0.944433333333333,
            0.5555666666666665}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.9814777777777777, 0.5926111111111108}, {
           0.944433333333333, 0.5555666666666665}, {0.9073888888888888, 
           0.5926111111111108}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0555666666666665`, 0.944433333333333}, {
           1.0555666666666665`, 0.05556666666666654}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0926111111111108`, 0.0926111111111112}, {
           1.0555666666666665`, 0.05556666666666654}, {1.0185222222222219`, 
           0.0926111111111112}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.944433333333333, 1.944433333333333}, {0.944433333333333,
            1.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.9814777777777777, 1.5926111111111108`}, {
           0.944433333333333, 1.5555666666666665`}, {0.9073888888888888, 
           1.5926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0555666666666665`, 1.944433333333333}, {
           1.0555666666666665`, 1.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0926111111111108`, 1.0926111111111108`}, {
           1.0555666666666665`, 1.0555666666666665`}, {1.0185222222222219`, 
           1.0926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.944433333333333, 2.9444333333333335`}, {
           0.944433333333333, 2.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.9814777777777777, 2.592611111111111}, {
           0.944433333333333, 2.5555666666666665`}, {0.9073888888888888, 
           2.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0555666666666665`, 2.9444333333333335`}, {
           1.0555666666666665`, 2.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0926111111111108`, 2.092611111111111}, {
           1.0555666666666665`, 2.0555666666666665`}, {1.0185222222222219`, 
           2.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.944433333333333, 3.9444333333333335`}, {
           0.944433333333333, 3.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.9814777777777777, 3.592611111111111}, {
           0.944433333333333, 3.5555666666666665`}, {0.9073888888888888, 
           3.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0555666666666665`, 3.9444333333333335`}, {
           1.0555666666666665`, 3.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.0926111111111108`, 3.092611111111111}, {
           1.0555666666666665`, 3.0555666666666665`}, {1.0185222222222219`, 
           3.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.944433333333333, 0.944433333333333}, {1.944433333333333,
            0.5555666666666665}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.9814777777777777`, 0.5926111111111108}, {
           1.944433333333333, 0.5555666666666665}, {1.9073888888888888`, 
           0.5926111111111108}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.0555666666666665`, 0.944433333333333}, {
           2.0555666666666665`, 0.05556666666666654}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.092611111111111, 0.0926111111111112}, {
           2.0555666666666665`, 0.05556666666666654}, {2.018522222222222, 
           0.0926111111111112}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.944433333333333, 1.944433333333333}, {1.944433333333333,
            1.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.9814777777777777`, 1.5926111111111108`}, {
           1.944433333333333, 1.5555666666666665`}, {1.9073888888888888`, 
           1.5926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.0555666666666665`, 1.944433333333333}, {
           2.0555666666666665`, 1.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.092611111111111, 1.0926111111111108`}, {
           2.0555666666666665`, 1.0555666666666665`}, {2.018522222222222, 
           1.0926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.944433333333333, 2.9444333333333335`}, {
           1.944433333333333, 2.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.9814777777777777`, 2.592611111111111}, {
           1.944433333333333, 2.5555666666666665`}, {1.9073888888888888`, 
           2.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.0555666666666665`, 2.9444333333333335`}, {
           2.0555666666666665`, 2.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.092611111111111, 2.092611111111111}, {
           2.0555666666666665`, 2.0555666666666665`}, {2.018522222222222, 
           2.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.944433333333333, 3.9444333333333335`}, {
           1.944433333333333, 3.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{1.9814777777777777`, 3.592611111111111}, {
           1.944433333333333, 3.5555666666666665`}, {1.9073888888888888`, 
           3.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.0555666666666665`, 3.9444333333333335`}, {
           2.0555666666666665`, 3.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.092611111111111, 3.092611111111111}, {
           2.0555666666666665`, 3.0555666666666665`}, {2.018522222222222, 
           3.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.9444333333333335`, 0.944433333333333}, {
           2.9444333333333335`, 0.5555666666666665}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.981477777777778, 0.5926111111111108}, {
           2.9444333333333335`, 0.5555666666666665}, {2.907388888888889, 
           0.5926111111111108}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.0555666666666665`, 0.944433333333333}, {
           3.0555666666666665`, 0.05556666666666654}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.092611111111111, 0.0926111111111112}, {
           3.0555666666666665`, 0.05556666666666654}, {3.018522222222222, 
           0.0926111111111112}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.9444333333333335`, 1.944433333333333}, {
           2.9444333333333335`, 1.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.981477777777778, 1.5926111111111108`}, {
           2.9444333333333335`, 1.5555666666666665`}, {2.907388888888889, 
           1.5926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.0555666666666665`, 1.944433333333333}, {
           3.0555666666666665`, 1.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.092611111111111, 1.0926111111111108`}, {
           3.0555666666666665`, 1.0555666666666665`}, {3.018522222222222, 
           1.0926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.9444333333333335`, 2.9444333333333335`}, {
           2.9444333333333335`, 2.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.981477777777778, 2.592611111111111}, {
           2.9444333333333335`, 2.5555666666666665`}, {2.907388888888889, 
           2.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.0555666666666665`, 2.9444333333333335`}, {
           3.0555666666666665`, 2.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.092611111111111, 2.092611111111111}, {
           3.0555666666666665`, 2.0555666666666665`}, {3.018522222222222, 
           2.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.9444333333333335`, 3.9444333333333335`}, {
           2.9444333333333335`, 3.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{2.981477777777778, 3.592611111111111}, {
           2.9444333333333335`, 3.5555666666666665`}, {2.907388888888889, 
           3.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.0555666666666665`, 3.9444333333333335`}, {
           3.0555666666666665`, 3.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.092611111111111, 3.092611111111111}, {
           3.0555666666666665`, 3.0555666666666665`}, {3.018522222222222, 
           3.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.9444333333333335`, 0.944433333333333}, {
           3.9444333333333335`, 0.5555666666666665}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.981477777777778, 0.5926111111111108}, {
           3.9444333333333335`, 0.5555666666666665}, {3.907388888888889, 
           0.5926111111111108}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.0555666666666665`, 0.944433333333333}, {
           4.0555666666666665`, 0.05556666666666654}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.092611111111111, 0.0926111111111112}, {
           4.0555666666666665`, 0.05556666666666654}, {4.018522222222222, 
           0.0926111111111112}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.9444333333333335`, 1.944433333333333}, {
           3.9444333333333335`, 1.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.981477777777778, 1.5926111111111108`}, {
           3.9444333333333335`, 1.5555666666666665`}, {3.907388888888889, 
           1.5926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.0555666666666665`, 1.944433333333333}, {
           4.0555666666666665`, 1.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.092611111111111, 1.0926111111111108`}, {
           4.0555666666666665`, 1.0555666666666665`}, {4.018522222222222, 
           1.0926111111111108`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.9444333333333335`, 2.9444333333333335`}, {
           3.9444333333333335`, 2.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.981477777777778, 2.592611111111111}, {
           3.9444333333333335`, 2.5555666666666665`}, {3.907388888888889, 
           2.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.0555666666666665`, 2.9444333333333335`}, {
           4.0555666666666665`, 2.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.092611111111111, 2.092611111111111}, {
           4.0555666666666665`, 2.0555666666666665`}, {4.018522222222222, 
           2.092611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.9444333333333335`, 3.9444333333333335`}, {
           3.9444333333333335`, 3.5555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{3.981477777777778, 3.592611111111111}, {
           3.9444333333333335`, 3.5555666666666665`}, {3.907388888888889, 
           3.592611111111111}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.0555666666666665`, 3.9444333333333335`}, {
           4.0555666666666665`, 3.0555666666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{4.092611111111111, 3.092611111111111}, {
           4.0555666666666665`, 3.0555666666666665`}, {4.018522222222222, 
           3.092611111111111}}], 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{0., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{0., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{0., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{0., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{0., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{1., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{1., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{1., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{1., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{1., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{2., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{2., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{2., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{2., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{2., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{3., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{3., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{3., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{3., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{3., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{4., 0.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{4., 1.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{4., 2.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{4., 3.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], Opacity[1], 
           DiskBox[{4., 4.5}, 0.03704444444444444, 
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0., 1.444433333333333}, {0., 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.03704444444444421, 1.0926111111111108`}, {0., 
            1.0555666666666665`}, {-0.037044444444444435`, 
            1.0926111111111108`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0., 2.4444333333333335`}, {0., 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.03704444444444421, 2.092611111111111}, {0., 
            2.0555666666666665`}, {-0.037044444444444435`, 
            2.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0., 3.4444333333333335`}, {0., 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.03704444444444421, 3.092611111111111}, {0., 
            3.0555666666666665`}, {-0.037044444444444435`, 
            3.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0., 4.4444333333333335`}, {0., 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.03704444444444421, 4.092611111111111}, {0., 
            4.0555666666666665`}, {-0.037044444444444435`, 
            4.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 0.49999999999999956`}, {
            0.07858313361586511, 0.49999999999999956`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 0.46295555555555534`}, {
            0.07858313361586511, 0.49999999999999956`}, {0.11562757806030932`,
             0.5370444444444442}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 0.444433333333333}, {
            0.055566666666666986`, 0.05556666666666654}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110819`, 0.03647566234216937}, {
            0.055566666666666986`, 0.05556666666666654}, {0.07465767099116372,
             0.10435309185110775`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 1.5}, {0.07858313361586511, 1.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 1.4629555555555553`}, {
            0.07858313361586511, 1.5}, {0.11562757806030932`, 
            1.5370444444444442`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 1.444433333333333}, {
            0.05556666666666654, 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110775`, 1.0364756623421694`}, {
            0.05556666666666654, 1.0555666666666665`}, {0.07465767099116372, 
            1.1043530918511077`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9999999999999996, 1.444433333333333}, {
            0.9999999999999996, 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.0370444444444442`, 1.0926111111111108`}, {
            0.9999999999999996, 1.0555666666666665`}, {0.9629555555555553, 
            1.0926111111111108`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 2.5}, {0.07858313361586511, 2.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 2.4629555555555553`}, {
            0.07858313361586511, 2.5}, {0.11562757806030932`, 
            2.5370444444444447`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 2.4444333333333335`}, {
            0.05556666666666654, 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110775`, 2.036475662342169}, {
            0.05556666666666654, 2.0555666666666665`}, {0.07465767099116372, 
            2.1043530918511077`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9999999999999996, 2.4444333333333335`}, {
            0.9999999999999996, 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.0370444444444442`, 2.092611111111111}, {
            0.9999999999999996, 2.0555666666666665`}, {0.9629555555555553, 
            2.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 3.5}, {0.07858313361586511, 3.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 3.4629555555555553`}, {
            0.07858313361586511, 3.5}, {0.11562757806030932`, 
            3.5370444444444447`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 3.4444333333333335`}, {
            0.05556666666666654, 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110775`, 3.03647566234217}, {
            0.05556666666666654, 3.0555666666666665`}, {0.07465767099116372, 
            3.1043530918511086`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9999999999999996, 3.4444333333333335`}, {
            0.9999999999999996, 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.0370444444444442`, 3.092611111111111}, {
            0.9999999999999996, 3.0555666666666665`}, {0.9629555555555553, 
            3.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9214168663841353, 4.5}, {0.07858313361586511, 4.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.11562757806030932`, 4.462955555555555}, {
            0.07858313361586511, 4.5}, {0.11562757806030932`, 
            4.537044444444445}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.944433333333333, 4.4444333333333335`}, {
            0.05556666666666654, 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.10435309185110775`, 4.03647566234217}, {
            0.05556666666666654, 4.0555666666666665`}, {0.07465767099116372, 
            4.104353091851109}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{0.9999999999999996, 4.4444333333333335`}, {
            0.9999999999999996, 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.0370444444444442`, 4.092611111111111}, {
            0.9999999999999996, 4.0555666666666665`}, {0.9629555555555553, 
            4.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 0.49999999999999956`}, {
            1.0785831336158647`, 0.49999999999999956`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 0.46295555555555534`}, {
            1.0785831336158647`, 0.49999999999999956`}, {1.1156275780603093`, 
            0.5370444444444442}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 0.444433333333333}, {
            1.0555666666666665`, 0.055566666666666986`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 0.03647566234216981}, {
            1.0555666666666665`, 0.055566666666666986`}, {1.0746576709911637`,
             0.10435309185110819`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 1.5}, {1.0785831336158647`, 1.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 1.4629555555555553`}, {
            1.0785831336158647`, 1.5}, {1.1156275780603093`, 
            1.5370444444444442`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 1.444433333333333}, {
            1.0555666666666665`, 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 1.0364756623421694`}, {
            1.0555666666666665`, 1.0555666666666665`}, {1.0746576709911637`, 
            1.1043530918511077`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2., 1.444433333333333}, {2., 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.0370444444444447`, 1.0926111111111108`}, {2., 
            1.0555666666666665`}, {1.9629555555555553`, 
            1.0926111111111108`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 2.5}, {1.0785831336158647`, 2.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 2.4629555555555553`}, {
            1.0785831336158647`, 2.5}, {1.1156275780603093`, 
            2.5370444444444447`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 2.4444333333333335`}, {
            1.0555666666666665`, 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 2.036475662342169}, {
            1.0555666666666665`, 2.0555666666666665`}, {1.0746576709911637`, 
            2.1043530918511077`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2., 2.4444333333333335`}, {2., 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.0370444444444447`, 2.092611111111111}, {2., 
            2.0555666666666665`}, {1.9629555555555553`, 2.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 3.5}, {1.0785831336158647`, 3.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 3.4629555555555553`}, {
            1.0785831336158647`, 3.5}, {1.1156275780603093`, 
            3.5370444444444447`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 3.4444333333333335`}, {
            1.0555666666666665`, 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 3.03647566234217}, {
            1.0555666666666665`, 3.0555666666666665`}, {1.0746576709911637`, 
            3.1043530918511086`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2., 3.4444333333333335`}, {2., 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.0370444444444447`, 3.092611111111111}, {2., 
            3.0555666666666665`}, {1.9629555555555553`, 3.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.9214168663841353`, 4.5}, {1.0785831336158647`, 4.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1156275780603093`, 4.462955555555555}, {
            1.0785831336158647`, 4.5}, {1.1156275780603093`, 
            4.537044444444445}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.944433333333333, 4.4444333333333335`}, {
            1.0555666666666665`, 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{1.1043530918511077`, 4.03647566234217}, {
            1.0555666666666665`, 4.0555666666666665`}, {1.0746576709911637`, 
            4.104353091851109}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2., 4.4444333333333335`}, {2., 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.0370444444444447`, 4.092611111111111}, {2., 
            4.0555666666666665`}, {1.9629555555555553`, 4.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 0.49999999999999956`}, {
            2.078583133615865, 0.49999999999999956`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 0.46295555555555534`}, {
            2.078583133615865, 0.49999999999999956`}, {2.1156275780603098`, 
            0.5370444444444442}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 0.444433333333333}, {
            2.0555666666666665`, 0.055566666666666986`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 0.03647566234216981}, {
            2.0555666666666665`, 0.055566666666666986`}, {2.074657670991164, 
            0.10435309185110819`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 1.5}, {2.078583133615865, 1.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 1.4629555555555553`}, {
            2.078583133615865, 1.5}, {2.1156275780603098`, 
            1.5370444444444442`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 1.444433333333333}, {
            2.0555666666666665`, 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 1.0364756623421694`}, {
            2.0555666666666665`, 1.0555666666666665`}, {2.074657670991164, 
            1.1043530918511077`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3., 1.444433333333333}, {3., 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.0370444444444447`, 1.0926111111111108`}, {3., 
            1.0555666666666665`}, {2.9629555555555553`, 
            1.0926111111111108`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 2.5}, {2.078583133615865, 2.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 2.4629555555555553`}, {
            2.078583133615865, 2.5}, {2.1156275780603098`, 
            2.5370444444444447`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 2.4444333333333335`}, {
            2.0555666666666665`, 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 2.036475662342169}, {
            2.0555666666666665`, 2.0555666666666665`}, {2.074657670991164, 
            2.1043530918511077`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3., 2.4444333333333335`}, {3., 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.0370444444444447`, 2.092611111111111}, {3., 
            2.0555666666666665`}, {2.9629555555555553`, 2.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 3.5}, {2.078583133615865, 3.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 3.4629555555555553`}, {
            2.078583133615865, 3.5}, {2.1156275780603098`, 
            3.5370444444444447`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 3.4444333333333335`}, {
            2.0555666666666665`, 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 3.03647566234217}, {
            2.0555666666666665`, 3.0555666666666665`}, {2.074657670991164, 
            3.1043530918511086`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3., 3.4444333333333335`}, {3., 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.0370444444444447`, 3.092611111111111}, {3., 
            3.0555666666666665`}, {2.9629555555555553`, 3.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.921416866384134, 4.5}, {2.078583133615865, 4.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1156275780603098`, 4.462955555555555}, {
            2.078583133615865, 4.5}, {2.1156275780603098`, 
            4.537044444444445}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.9444333333333335`, 4.4444333333333335`}, {
            2.0555666666666665`, 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{2.1043530918511077`, 4.03647566234217}, {
            2.0555666666666665`, 4.0555666666666665`}, {2.074657670991164, 
            4.104353091851109}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3., 4.4444333333333335`}, {3., 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.0370444444444447`, 4.092611111111111}, {3., 
            4.0555666666666665`}, {2.9629555555555553`, 4.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 0.49999999999999956`}, {
            3.078583133615864, 0.49999999999999956`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 0.46295555555555534`}, {
            3.078583133615864, 0.49999999999999956`}, {3.115627578060309, 
            0.5370444444444442}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 0.444433333333333}, {
            3.0555666666666665`, 0.055566666666666986`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 0.03647566234216981}, {
            3.0555666666666665`, 0.055566666666666986`}, {3.0746576709911633`,
             0.10435309185110819`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 1.5}, {3.078583133615864, 1.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 1.4629555555555553`}, {
            3.078583133615864, 1.5}, {3.115627578060309, 
            1.5370444444444442`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 1.444433333333333}, {
            3.0555666666666665`, 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 1.0364756623421694`}, {
            3.0555666666666665`, 1.0555666666666665`}, {3.0746576709911633`, 
            1.1043530918511077`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4., 1.444433333333333}, {4., 1.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4.037044444444445, 1.0926111111111108`}, {4., 
            1.0555666666666665`}, {3.9629555555555553`, 
            1.0926111111111108`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 2.5}, {3.078583133615864, 2.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 2.4629555555555553`}, {
            3.078583133615864, 2.5}, {3.115627578060309, 
            2.5370444444444447`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 2.4444333333333335`}, {
            3.0555666666666665`, 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 2.036475662342169}, {
            3.0555666666666665`, 2.0555666666666665`}, {3.0746576709911633`, 
            2.1043530918511077`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4., 2.4444333333333335`}, {4., 2.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4.037044444444445, 2.092611111111111}, {4., 
            2.0555666666666665`}, {3.9629555555555553`, 2.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 3.5}, {3.078583133615864, 3.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 3.4629555555555553`}, {
            3.078583133615864, 3.5}, {3.115627578060309, 
            3.5370444444444447`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 3.4444333333333335`}, {
            3.0555666666666665`, 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 3.03647566234217}, {
            3.0555666666666665`, 3.0555666666666665`}, {3.0746576709911633`, 
            3.1043530918511086`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4., 3.4444333333333335`}, {4., 3.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4.037044444444445, 3.092611111111111}, {4., 
            3.0555666666666665`}, {3.9629555555555553`, 3.092611111111111}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.921416866384134, 4.5}, {3.078583133615864, 4.5}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.115627578060309, 4.462955555555555}, {
            3.078583133615864, 4.5}, {3.115627578060309, 
            4.537044444444445}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.9444333333333335`, 4.4444333333333335`}, {
            3.0555666666666665`, 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{3.1043530918511086`, 4.03647566234217}, {
            3.0555666666666665`, 4.0555666666666665`}, {3.0746576709911633`, 
            4.104353091851109}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4., 4.4444333333333335`}, {4., 4.0555666666666665`}}]}, 
          {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           LineBox[{{4.037044444444445, 4.092611111111111}, {4., 
            4.0555666666666665`}, {3.9629555555555553`, 4.092611111111111}}], 
           InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               StyleBox["\<\"v\"\>",
                StripOnInput->False,
                FontFamily->"BookAntiqua",
                FontSlant->Italic],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-1.1315077777777778`, 2.25}, {0, 0}, Automatic, {
            0, 1}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"0\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {0., -0.3092611111111111}, {0, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"1\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {1., -0.3092611111111111}, {0, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"2\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {2., -0.3092611111111111}, {0, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[CenterEllipsis]\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {3., -0.3092611111111111}, {0, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TagBox[
                StyleBox["\<\"N\"\>",
                 FontSlant->"Italic"],
                StyleForm[#, FontSlant -> "Italic"]& ],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4., -0.309261111111111}, {-1, 1}, Automatic, {1, 
            0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","0","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 0, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 0.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","0","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 0, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 0.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","1","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 1, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 1.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","1","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 1, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 1.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","2","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 2, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 2.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","2","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 2, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 2.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","3","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 3, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 3.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","3","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 3, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 3.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"O\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","4","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["O", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 4, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 4.}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               InterpretationBox[
                SubsuperscriptBox[
                 TagBox[
                  StyleBox["\<\"T\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TagBox[
                  StyleBox["\<\"N\"\>",
                   FontSlant->"Italic"],
                  StyleForm[#, FontSlant -> "Italic"]& ], 
                 TemplateBox[{"\"(\"","4","\")\""},
                  "Row",
                  
                  DisplayFunction->(
                   RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3}]& ),
                  InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]],
                Subsuperscript[
                 StyleForm["T", FontSlant -> "Italic"], 
                 StyleForm["N", FontSlant -> "Italic"], 
                 Row[{"(", 4, ")"}]],
                Editable->False],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {-0.5, 4.5}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","47","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 0.25}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","54","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 0.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","48","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 1.25}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","55","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 1.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","49","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 2.25}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","56","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 2.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","50","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 3.25}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","57","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 3.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{"\"(\"","51","\")\""},
                "Row",
                
                DisplayFunction->(
                 RowBox[{#, "\[InvisibleSpace]", #2, 
                   "\[InvisibleSpace]", #3}]& ),
                InterpretationFunction->(RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4.5, 4.25}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {0., 4.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {1., 4.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {2., 4.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {3., 4.75}, {0, 0}, Automatic, {1, 0}], InsetBox[
            TagBox[
             StyleBox[
              TagBox["\<\"\[VerticalEllipsis]\"\>",
               DisplayForm],
              ShowAutoStyles->False,
              SingleLetterItalics->False,
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontColor->GrayLevel[0],
              FontOpacity->1],
             DisplayForm], {4., 4.75}, {0, 0}, Automatic, {1, 0}]}}}}}}}}},
  AspectRatio->1,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{432, 432},
  PlotRange->{{-2.0008, 6.0008}, {-2.0008, 6.0008}},
  Ticks->None]], "Output",
 CellChangeTimes->{3.495658088125*^9, 3.4956581224375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nuclear structure: A multipanel diagram", "Section",
 CellChangeTimes->{{3.488147355921875*^9, 3.488147357953125*^9}, {
  3.488366055109375*^9, 3.488366057859375*^9}, {3.491258720046875*^9, 
  3.491258744515625*^9}, {3.4956593404375*^9, 3.49565936984375*^9}}],

Cell["\<\
This provides plenty of examples of defining functions to draw different \
diagram elements, and also an example of PDF import.\
\>", "Text",
 CellChangeTimes->{{3.495659372296875*^9, 3.495659403046875*^9}}],

Cell["import PDF graphics", "Text",
 CellChangeTimes->{{3.488837807625*^9, 3.488837812*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipsoidGraphics", "=", 
   RowBox[{
   "Import", "[", 
    "\"\<LevelScheme/ExampleData/nuclpict_modes_redblue_Y22C.pdf\>\"", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4881504998125*^9, 3.488150503515625*^9}, {
   3.488151365*^9, 3.488151434515625*^9}, {3.488281363875*^9, 
   3.488281364125*^9}, {3.48828319428125*^9, 3.488283206625*^9}, {
   3.48883605475*^9, 3.488836058734375*^9}, {3.48883632528125*^9, 
   3.488836343359375*^9}, {3.488837665890625*^9, 3.4888376971875*^9}, {
   3.4888377524375*^9, 3.488837773359375*^9}, 3.492125327390625*^9, 
   3.492125423609375*^9, {3.495659420765625*^9, 3.495659433921875*^9}, {
   3.501273983125*^9, 3.50127398465625*^9}}],

Cell["generate points for plot", "Text",
 CellChangeTimes->{{3.488837814328125*^9, 3.48883781725*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ParamFcn", "[", 
    RowBox[{"eta0_", ",", "xi_", ",", "x0_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"eta0", "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Tanh", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "x0"}], ")"}], "/", "xi"}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ParamPlot", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"ParamFcn", "[", 
      RowBox[{"0.5", ",", "2", ",", "3", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BCSPoints", "=", 
   RowBox[{"Reverse", "/@", 
    RowBox[{"GrabPoints", "[", "ParamPlot", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.488287030796875*^9, 3.488287140765625*^9}, {
   3.488287203453125*^9, 3.48828723346875*^9}, {3.4883661865625*^9, 
   3.488366191640625*^9}, 3.48883780009375*^9, 3.488838298734375*^9}],

Cell["\<\
define simple (or maybe not-so-simple) functions to draw particles in pairing \
diagram\
\>", "Text",
 CellChangeTimes->{{3.48883782228125*^9, 3.488837886296875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ShellPoint", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"N", "\[Rule]", "6"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShellPoint", "[", 
    RowBox[{"y_Integer", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"k_", "?", "NumericQ"}], ")"}], "?", "Positive"}], ",", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"OptionValue", "[", "N", "]"}], "+", "1"}], ")"}]}], ",", 
     "y"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4882873059375*^9, 3.488287365390625*^9}, {
  3.4882879288125*^9, 3.488287930125*^9}, {3.488288016734375*^9, 
  3.48828802465625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ShellDot", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DotRadius", "\[Rule]", 
      RowBox[{"Point", "[", "2", "]"}]}], ",", 
     RowBox[{"DotOptions", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"Occupied", "\[Rule]", "True"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShellDot", "[", 
    RowBox[{"y_Integer", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"k_", "?", "NumericQ"}], ")"}], "?", "Positive"}], ",", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"SchemeCircle", "[", 
       RowBox[{
        RowBox[{"ShellPoint", "[", 
         RowBox[{"y", ",", "k"}], "]"}], ",", 
        RowBox[{"OptionValue", "[", "DotRadius", "]"}], ",", 
        RowBox[{"OptionValue", "[", "DotOptions", "]"}], ",", 
        RowBox[{"ShowFill", "\[Rule]", 
         RowBox[{"OptionValue", "[", "Occupied", "]"}]}]}], "]"}], 
      "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4881972606875*^9, 3.48819726125*^9}, {
   3.48819761890625*^9, 3.488197640078125*^9}, {3.488197678703125*^9, 
   3.488197890359375*^9}, {3.48819821825*^9, 3.488198263234375*^9}, {
   3.488198308421875*^9, 3.488198312375*^9}, {3.488198395109375*^9, 
   3.488198438765625*^9}, {3.4881985739375*^9, 3.48819859771875*^9}, 
   3.488198711578125*^9, {3.488198764453125*^9, 3.48819877359375*^9}, {
   3.488286746453125*^9, 3.48828680965625*^9}, 3.488287302984375*^9, {
   3.48828737040625*^9, 3.4882873770625*^9}, 3.488287934296875*^9, {
   3.488288019296875*^9, 3.488288020203125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ShellPair", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ExtraRadius", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"NucleonShift", "\[Rule]", "0"}], ",", 
     RowBox[{"PairOptions", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"NucleonOptions", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"ArrowOptions", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"ArrowVector", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.2"}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ShellPair", "[", 
   RowBox[{"y_Integer", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k_", "?", "NumericQ"}], ")"}], "?", "Positive"}], ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"P1", ",", "P2"}], "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"P1", "=", 
        RowBox[{"ShellPoint", "[", 
         RowBox[{"y", ",", 
          RowBox[{"k", "+", 
           RowBox[{"OptionValue", "[", "NucleonShift", "]"}]}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"P2", "=", 
        RowBox[{"ShellPoint", "[", 
         RowBox[{"y", ",", 
          RowBox[{"k", "+", "1", "-", 
           RowBox[{"OptionValue", "[", "NucleonShift", "]"}]}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"SchemeCircle", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Mean", "[", 
          RowBox[{"{", 
           RowBox[{"P1", ",", "P2"}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "2"}], "*", 
           RowBox[{"(", 
            RowBox[{"P2", "-", "P1"}], ")"}]}], "+", 
          RowBox[{"OptionValue", "[", "ExtraRadius", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"OptionValue", "[", "PairOptions", "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShellDot", "[", 
       RowBox[{"y", ",", 
        RowBox[{"k", "+", 
         RowBox[{"OptionValue", "[", "NucleonShift", "]"}]}], ",", 
        RowBox[{"OptionValue", "[", "NucleonOptions", "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ShellDot", "[", 
       RowBox[{"y", ",", 
        RowBox[{"k", "+", "1", "-", 
         RowBox[{"OptionValue", "[", "NucleonShift", "]"}]}], ",", 
        RowBox[{"OptionValue", "[", "NucleonOptions", "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SchemeArrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"P1", "-", 
           RowBox[{"OptionValue", "[", "ArrowVector", "]"}]}], ",", 
          RowBox[{"P1", "+", 
           RowBox[{"OptionValue", "[", "ArrowVector", "]"}]}]}], "}"}], ",", 
        RowBox[{"OptionValue", "[", "ArrowOptions", "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SchemeArrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"P2", "+", 
           RowBox[{"OptionValue", "[", "ArrowVector", "]"}]}], ",", 
          RowBox[{"P2", "-", 
           RowBox[{"OptionValue", "[", "ArrowVector", "]"}]}]}], "}"}], ",", 
        RowBox[{"OptionValue", "[", "ArrowOptions", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.48828741490625*^9, 3.4882875993125*^9}, {
   3.4882876493125*^9, 3.48828771003125*^9}, {3.4882877415625*^9, 
   3.488287771453125*^9}, {3.488287850625*^9, 3.488287867625*^9}, {
   3.48828789825*^9, 3.48828790909375*^9}, 3.488287941359375*^9, 
   3.48828801390625*^9, {3.4882880929375*^9, 3.488288126125*^9}, {
   3.4882881620625*^9, 3.488288302796875*^9}, {3.48828833475*^9, 
   3.48828836340625*^9}, {3.488836183375*^9, 3.488836185234375*^9}, {
   3.48883629878125*^9, 3.488836299453125*^9}}],

Cell["\<\
define functions to draw particles in a circle for shell model schematic\
\>", "Text",
 CellChangeTimes->{{3.488837914125*^9, 3.488837928015625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DrawParticle", "[", 
    RowBox[{"R_", ",", "theta_", ",", "r_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"SchemeCircle", "[", 
    RowBox[{
     RowBox[{"ConvertCoordinate", "[", 
      RowBox[{"AbsoluteCoords", ",", "UserCoords", ",", "D", ",", 
       RowBox[{"R", "*", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "theta", "]"}], ",", 
          RowBox[{"Sin", "[", "theta", "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Point", "[", "r", "]"}], ",", "Opts"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"NaturalDistance", "[", 
    RowBox[{"dtheta_", ",", "r_"}], "]"}], ":=", 
   RowBox[{"r", "*", 
    RowBox[{"Sec", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{"(", 
       RowBox[{"Pi", "-", "dtheta"}], ")"}]}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{3.405207762953125*^9}],

Cell["put it all together", "Text",
 CellChangeTimes->{{3.488837934859375*^9, 3.488837937234375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"YPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ExtendRange", "\[Rule]", "0.25"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ShowPanelLetter", "\[Rule]", "False"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"ScaledLabel", ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "nucleus", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"PanelLetter", "\[Rule]", "None"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", "1"}], "}"}], ",", "\"\<Nucleon interactions\>\"",
        ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"+", "1"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BlockSchemeOptions", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"SeedRandom", "[", "3", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"RNucl", "=", "1"}], ";", "\[IndentingNewLine]", 
         RowBox[{"SchemeCircle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "RNucl", ",", 
           RowBox[{"FillColor", "\[Rule]", "Gray"}], ",", 
           RowBox[{"ShowLine", "\[Rule]", "False"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"SchemeCircle", "[", 
           RowBox[{
            RowBox[{"Polar", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0.7", "*", "RNucl", "*", 
                RowBox[{"Random", "[", "]"}]}], ",", 
               RowBox[{"2", "*", "Pi", "*", 
                RowBox[{"Random", "[", "]"}]}]}], "}"}], "]"}], ",", 
            RowBox[{"Point", "[", "14", "]"}], ",", 
            RowBox[{"FillColor", "\[Rule]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Random", "[", "Integer", "]"}], "\[Equal]", "1"}], 
               ",", "Red", ",", "DimGray"}], "]"}]}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "100"}], "}"}]}], 
         "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"shell", " ", "structure"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"PanelLetter", "\[Rule]", "\"\<(a)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", "1"}], "}"}], ",", "\"\<Shell structure\>\"", ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"+", "1"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BlockSchemeOptions", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"RN", "=", "8"}], ",", "\[IndentingNewLine]", 
        RowBox[{"R1", "=", 
         RowBox[{"1.2", "*", 
          RowBox[{"Sqrt", "[", "2", "]"}], "*", "RN"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"R2", "=", 
         RowBox[{"1.7", "*", "2.61", "*", "RN"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"SchemeCircle", ",", 
          RowBox[{"FillColor", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"LabC", "\[Rule]", "None"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"TableForEach", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"DrawParticle", "[", 
           RowBox[{"R1", ",", "theta", ",", "RN", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "i", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"FillColor", "\[Rule]", "Red"}], ",", 
                RowBox[{"LabC", "\[Rule]", 
                 RowBox[{"textit", "@", "\"\<p\>\""}]}], ",", 
                RowBox[{"NudgeC", "\[Rule]", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"FillColor", "\[Rule]", "DimGray"}], ",", 
                RowBox[{"LabC", "\[Rule]", 
                 RowBox[{"textit", "@", "\"\<n\>\""}]}]}], "}"}]}], "]"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"theta", ",", "i", ",", 
            RowBox[{"Range", "[", 
             RowBox[{"0", ",", 
              RowBox[{"2", "*", "Pi"}], ",", 
              RowBox[{"2", "*", 
               RowBox[{"Pi", "/", "4"}]}]}], "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"TableForEach", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"DrawParticle", "[", 
           RowBox[{"R2", ",", "theta", ",", "RN", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "i", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"FillColor", "\[Rule]", "Red"}], ",", 
                RowBox[{"LabC", "\[Rule]", 
                 RowBox[{"textit", "@", "\"\<p\>\""}]}], ",", 
                RowBox[{"NudgeC", "\[Rule]", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"FillColor", "\[Rule]", "DimGray"}], ",", 
                RowBox[{"LabC", "\[Rule]", 
                 RowBox[{"textit", "@", "\"\<n\>\""}]}]}], "}"}]}], "]"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"theta", ",", "i", ",", 
            RowBox[{"Range", "[", 
             RowBox[{"0", ",", 
              RowBox[{"2", "*", "Pi"}], ",", 
              RowBox[{"2", "*", 
               RowBox[{"Pi", "/", "12"}]}]}], "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"SchemeCircle", ",", 
          RowBox[{"ShowFill", "\[Rule]", "False"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SchemeCircle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"R1", "+", "R2"}], ")"}], "/", "2"}], "]"}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"SchemeCircle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"2", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"R1", "+", "R2"}], ")"}], "/", "2"}]}], "]"}]}], 
         "]"}]}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "deformation", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"ExtendRange", "\[Rule]", "0.15"}], ",", 
       RowBox[{"PanelLetter", "\[Rule]", "\"\<(b)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", "1"}], "}"}], ",", 
       "\"\<Collective deformation\>\"", ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"+", "1"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FigGraphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", 
       "EllipsoidGraphics"}], "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"alpha", " ", "cluster"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"PanelLetter", "\[Rule]", "\"\<(c)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0"}], "}"}], ",", "\"\<Cluster correlations\>\"",
        ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BlockSchemeOptions", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Ralpha", "=", "20"}], ",", "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"SchemeCircle", ",", 
          RowBox[{"FillColor", "\[Rule]", "Gold"}], ",", 
          RowBox[{"LabC", "->", "\"\<\[Alpha]\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "16"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"DrawParticle", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "/", 
              RowBox[{"Sqrt", "[", "3", "]"}]}], "*", "Ralpha"}], ",", 
            "theta", ",", "Ralpha"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"theta", ",", "0", ",", 
            RowBox[{"2", "*", "Pi"}], ",", 
            RowBox[{"2", "*", 
             RowBox[{"Pi", "/", "3"}]}]}], "}"}]}], "\[IndentingNewLine]", 
         "]"}]}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "pairing", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.25"}], ",", "1.25"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.5"}], ",", "5.5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ExtendRange", "\[Rule]", "0.05"}], ",", 
       RowBox[{"PanelLetter", "\[Rule]", "\"\<(d)\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaledLabel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0"}], "}"}], ",", "\"\<Pair condensation\>\"", 
       ",", 
       RowBox[{"Offset", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BlockSchemeOptions", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SetOptions", "[", 
         RowBox[{"SchemeAxis", ",", 
          RowBox[{"HeadLength", "\[Rule]", "5"}], ",", 
          RowBox[{"HeadLip", "\[Rule]", "3"}], ",", 
          RowBox[{"Color", "\[Rule]", "DimGray"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SchemeAxis", "[", 
         RowBox[{"Left", ",", 
          RowBox[{"-", "0.1"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.5"}], ",", "5.5"}], "}"}], ",", 
          RowBox[{"LabL", "\[Rule]", 
           RowBox[{"textit", "[", "\"\<E\>\"", "]"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"Lev", ",", 
          RowBox[{"Margin", "\[Rule]", "0"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"ShellPair", ",", 
          RowBox[{"NucleonShift", "\[Rule]", "0.15"}], ",", 
          RowBox[{"ExtraRadius", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0.05", ",", "0.3"}], "}"}]}], ",", 
          RowBox[{"PairOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"FillColor", "\[Rule]", "Moccasin"}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ArrowOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"HeadLength", "\[Rule]", "2"}], ",", 
             RowBox[{"HeadLip", "\[Rule]", "2"}]}], "}"}]}], ",", 
          RowBox[{"ArrowVector", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0.025", ",", "0.2"}], "}"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Lev", "[", 
           RowBox[{"0", ",", "1", ",", "i"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ShellPair", "[", 
         RowBox[{"0", ",", "1"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ShellPair", "[", 
         RowBox[{"0", ",", "3"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ShellPair", "[", 
         RowBox[{"0", ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ShellPair", "[", 
         RowBox[{"1", ",", "1"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ShellPair", "[", 
         RowBox[{"1", ",", "3"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ShellPair", "[", 
         RowBox[{"2", ",", "1"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ShellPair", "[", 
         RowBox[{"2", ",", "3"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ShellPair", "[", 
         RowBox[{"3", ",", "1"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ShellDot", "[", 
             RowBox[{"0", ",", "k"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "1", ",", "6"}], "}"}]}], "]"}], ","}], "*)"}],
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"SchemeLine", "[", 
         RowBox[{"BCSPoints", ",", 
          RowBox[{"Thickness", "\[Rule]", "2"}], ",", 
          RowBox[{"Color", "\[Rule]", "Gray"}], ",", 
          RowBox[{"Layer", "\[Rule]", "0"}]}], "]"}]}], "\[IndentingNewLine]",
        "}"}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"interpanel", " ", "arrows"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Px", "=", "0.1"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"FigurePanel", "[", 
          RowBox[{"{", 
           RowBox[{"i", ",", "j"}], "}"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"SavePoint", "[", 
          RowBox[{
           RowBox[{"PL", "[", 
            RowBox[{"i", ",", "j"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"Px", ",", "0.5"}], "}"}], ",", "ScaledCoords"}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"SavePoint", "[", 
          RowBox[{
           RowBox[{"PR", "[", 
            RowBox[{"i", ",", "j"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "-", "Px"}], ",", "0.5"}], "}"}], ",", 
           "ScaledCoords"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"SavePoint", "[", 
          RowBox[{
           RowBox[{"PT", "[", 
            RowBox[{"i", ",", "j"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.5", ",", 
             RowBox[{"1", "-", "Px"}]}], "}"}], ",", "ScaledCoords"}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"SavePoint", "[", 
          RowBox[{
           RowBox[{"PB", "[", 
            RowBox[{"i", ",", "j"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.5", ",", "Px"}], "}"}], ",", "ScaledCoords"}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"SavePoint", "[", 
          RowBox[{
           RowBox[{"PTL", "[", 
            RowBox[{"i", ",", "j"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Px", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
             RowBox[{"1", "-", 
              RowBox[{"Px", "/", 
               RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], "}"}], ",", 
           "ScaledCoords"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"SavePoint", "[", 
          RowBox[{
           RowBox[{"PBR", "[", 
            RowBox[{"i", ",", "j"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "-", 
              RowBox[{"Px", "/", 
               RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
             RowBox[{"Px", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], "}"}], ",", 
           "ScaledCoords"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"SetRegion", "[", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"SchemeArrow", ",", 
       RowBox[{"ArrowType", "\[Rule]", "MultilineArrow"}], ",", 
       RowBox[{"ShowFill", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"GetPoint", "[", 
        RowBox[{"PR", "[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"GetPoint", "[", 
        RowBox[{"PL", "[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"GetPoint", "[", 
        RowBox[{"PR", "[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"GetPoint", "[", 
        RowBox[{"PL", "[", 
         RowBox[{"1", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"GetPoint", "[", 
        RowBox[{"PB", "[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"GetPoint", "[", 
        RowBox[{"PT", "[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"GetPoint", "[", 
        RowBox[{"PBR", "[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"GetPoint", "[", 
        RowBox[{"PTL", "[", 
         RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "]"}], ","}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", "0.7", "*", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.4052021644375*^9, 3.40520220715625*^9}, {
   3.405202238578125*^9, 3.40520223878125*^9}, {3.405202292609375*^9, 
   3.405202309484375*^9}, {3.405202468546875*^9, 3.405202475*^9}, {
   3.4052025325*^9, 3.405202631546875*^9}, {3.405202731875*^9, 
   3.405203287703125*^9}, {3.405203325578125*^9, 3.40520335125*^9}, {
   3.40520343996875*^9, 3.40520350828125*^9}, {3.405204675671875*^9, 
   3.405204740328125*^9}, {3.40520477325*^9, 3.405204832828125*^9}, 
   3.48828153896875*^9, {3.488281624859375*^9, 3.488281694890625*^9}, {
   3.488282148296875*^9, 3.48828228190625*^9}, {3.488283226109375*^9, 
   3.488283247671875*^9}, {3.488284071875*^9, 3.488284109640625*^9}, {
   3.488284168796875*^9, 3.48828417221875*^9}, {3.4882842058125*^9, 
   3.488284228625*^9}, {3.48828430809375*^9, 3.488284327875*^9}, {
   3.488284477984375*^9, 3.488284618828125*^9}, {3.48828465840625*^9, 
   3.48828473565625*^9}, {3.488284768390625*^9, 3.488284768515625*^9}, {
   3.48828486096875*^9, 3.48828487484375*^9}, {3.488285554125*^9, 
   3.48828555965625*^9}, {3.488285643921875*^9, 3.488285679796875*^9}, {
   3.48828572040625*^9, 3.488285809015625*^9}, {3.48828585146875*^9, 
   3.488285871390625*^9}, {3.488285908734375*^9, 3.488285993140625*^9}, {
   3.48828603015625*^9, 3.4882860306875*^9}, {3.4882863721875*^9, 
   3.4882863745*^9}, {3.488286417671875*^9, 3.488286417984375*^9}, {
   3.488286548703125*^9, 3.48828660359375*^9}, {3.488288503765625*^9, 
   3.4882886588125*^9}, {3.48828869615625*^9, 3.4882887044375*^9}, {
   3.48828874446875*^9, 3.48828880053125*^9}, {3.48828883409375*^9, 
   3.488288835765625*^9}, {3.48828887921875*^9, 3.48828893128125*^9}, {
   3.4882889638125*^9, 3.488289012578125*^9}, {3.48828904384375*^9, 
   3.48828904496875*^9}, {3.488289172609375*^9, 3.488289173109375*^9}, {
   3.48883601928125*^9, 3.488836033484375*^9}, {3.488836390515625*^9, 
   3.488836414484375*^9}}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.5], AbsoluteThickness[2], Opacity[1], Dashing[{}], CapForm[
   None], LineBox[CompressedData["
1:eJwV02s0lAkcBvDJaROtmghJF7c4IWrDlpYndFnXVrLIKAZRycollzK02pKo
pjY6qYidRJu0q5FyaZLbjEYYE3qlVfLOzPtuK20qyb774X+e8zvPp+fD35j7
07ZINRaL5c3c/6kXGbCvrICGafQ/L2UPGhCe5v91DuO+M+FHg1sbsO/H4ZIY
xqdq5WbDjxtgtrKwajXjj5r1kW8GGsC9Y+1zP5+G9OaJUY1/G5DePnqq4zyN
1HETlfOKRrgHcOaNnqPRyfN/e53fCHta6jN5mka9R0im8+oHaCk5IRg8RsNS
qb29VEcEzaEa9sl0GlzfiET1URGaTJK45xNoCB/kaWwWPkScy/t2cRQNyV31
CN2CJrCmbRZKgmncSFky51X0IxzS++NdsTcNL1FWsptXM3o93RXJzjQ0tR8G
plu1QPqt3wcTWxrnLC8dE0624MKMQRfTJTQGJS2pmYOtGKyw3PFJk8Zbu7xa
96o2LB2pceyboGByzSqW5rWDt431LPsvCrrFi0jjXWIszs3KdZBQ6A4TVPqv
kkBcb8ryv03hh98zHRfpdMCUL7xhm09B+WXN+tqxDqzz1gvzPsT0BlnZAaLH
uJV37lMsh8LBOpPCYyVSzJiRs3+2M4Voi52fqhM7IXbYLtptSCFPK2meo/UT
2PX2BIkmVEicY0HMuvQE2Ubh8Yt7VXChzbf6zexCWX3dmuWVKsTqdJpFJ3VB
OsJW8bNVOLKkufjz8y4I2qpLG7kqlFhZBPA2d+NCAVHdvlYFU97quDZhNwwy
Lq94w1Yhp/qE7dllPWhedmnWNyNK+Nrm+Jrxe7CxiYr/u1YJi8r3N0tZMnR1
iw5n8JUYZt+uKomWYff7vCJxpBJfanT09vbLUBBPhvo7KTHt+sj4tmsv/KVm
njZ6SsztfhE1Ut4LrcukbjKlAE8gYA8byNFYEeMa16KAjHN3186f5RBnF42G
XFEgJzBhfum4HBGfzWys0xQwX3t4T1TIU0wZ3O96G6BAp+HY5MLmp5BzlJYB
dgoMuM0dO2vfh7g/X728uEAB8dbU3NwrfTiZIEohx0ksKs7N8WH3IyGi3vB0
L4nUd3OapjL60dIxwZLdI1Fn3X/VmuyH4waae6aIRGi5z0vToAGMSwUr7xwn
odTQllx8OABxfgrVfoBEVqwL/WXFM4RVqF0rDCZxSN8g3uriMziUGUs535MI
+s358lM1AtUHr3/QYDw0eWS6YiaBqpSvnGu2kAj3aw7jzSIwu3OlgTbj/Wpe
5ss1CWSllLPbN5HIDA26FT+fgL6XbHq9G4myxYkiLSMC1q/l9+ydSbz7tXzE
zYlAQeAqh9dOzB6K2qIPAsdj70nyGU+5rapQbiDQxvXc9OE7Eurjwlj+RgL5
5h0H6taTMPR9NPHck0A5efWG+zoSLlpDGmk7CKTuzm6dXEuiOcIkxptDYNrH
Y+omY4+6SKnRTgKFzz2E2oz99lFnW8OYPUuvhww6kIhq/2iou4dg/rdnyxnG
lJETj9xLwHVvpacb4wMpmS/uxxBQ6oYWl9uTSLNQF3DjCIwVWY1xGLMyPNQd
4gksr+UHsxkfleft0UgkYDmWO9RkR2K2TZeESCIQKNdPT2Z86pcFNlXJBP4D
t35yJQ==
    "]], 
   {GrayLevel[0.5], Opacity[1], 
    DiskBox[{0.16666666666666666`, 0.75}, {0.1111111111111111, 0.16666666666666666`},
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {RGBColor[1, 0, 0], Opacity[1], 
    DiskBox[{0.10962826255724775`, 0.7488375202932471}, {0.030870370370370374`, 0.04630555555555556},
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], CircleBox[{0.10962826255724775`, 0.7488375202932471}, {0.030870370370370374`, 0.04630555555555556},
      NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
     DiskBox[{0.17641079289046807`, 0.7016526711723247}, {0.030870370370370374`, 0.04630555555555556},
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], CircleBox[{0.17641079289046807`, 0.7016526711723247}, {0.030870370370370374`, 0.04630555555555556},
       NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
     {RGBColor[1, 0, 0], Opacity[1], 
      DiskBox[{0.17845126483458307`, 0.7494819470500875}, {0.030870370370370374`, 0.04630555555555556},
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], CircleBox[{0.17845126483458307`, 0.7494819470500875}, {0.030870370370370374`, 0.04630555555555556},
        NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
      {RGBColor[1, 0, 0], Opacity[1], 
       DiskBox[{0.22162370568793519`, 0.6818114185612199}, {0.030870370370370374`, 0.04630555555555556},
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], CircleBox[{0.22162370568793519`, 0.6818114185612199}, {0.030870370370370374`, 0.04630555555555556},
         NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
       {RGBColor[1, 0, 0], Opacity[1], 
        DiskBox[{0.1778700421125725, 0.7072079858120044}, {0.030870370370370374`, 0.04630555555555556},
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], CircleBox[{0.1778700421125725, 0.7072079858120044}, {0.030870370370370374`, 0.04630555555555556},
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
        {RGBColor[1, 0, 0], Opacity[1], 
         DiskBox[{0.18564627969188913`, 0.7428108284297903}, {0.030870370370370374`, 0.04630555555555556},
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], CircleBox[{0.18564627969188913`, 0.7428108284297903}, {0.030870370370370374`, 0.04630555555555556},
           NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
         {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
          DiskBox[{0.1719203867040178, 0.7950273004752003}, {0.030870370370370374`, 0.04630555555555556},
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          CircleBox[{0.1719203867040178, 0.7950273004752003}, {0.030870370370370374`, 0.04630555555555556},
            NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
          {RGBColor[1, 0, 0], Opacity[1], 
           DiskBox[{0.18823336403286456`, 0.7365505422825905}, {0.030870370370370374`, 0.04630555555555556},
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
           CapForm[None], 
           CircleBox[{0.18823336403286456`, 0.7365505422825905}, {0.030870370370370374`, 0.04630555555555556},
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
           {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
            DiskBox[{0.206244245350506, 0.7342173409871459}, {0.030870370370370374`, 0.04630555555555556},
              NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
           {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
            CapForm[None], 
            CircleBox[{0.206244245350506, 0.7342173409871459}, 
             {0.030870370370370374`, 0.04630555555555556}, 
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
            {RGBColor[1, 0, 0], Opacity[1], 
             DiskBox[{0.13677768210356106`, 0.8065723207924073}, {0.030870370370370374`, 0.04630555555555556},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
            {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
             CapForm[None], 
             CircleBox[{0.13677768210356106`, 0.8065723207924073}, {0.030870370370370374`, 0.04630555555555556},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
             {RGBColor[1, 0, 0], Opacity[1], 
              DiskBox[{0.19387260019426125`, 0.8067223351833027}, {0.030870370370370374`, 0.04630555555555556},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
             {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
              CapForm[None], 
              CircleBox[{0.19387260019426125`, 0.8067223351833027}, {0.030870370370370374`, 0.04630555555555556},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
              {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
               DiskBox[{0.13270786651127311`, 0.7046282783339405}, {0.030870370370370374`, 0.04630555555555556},
                 NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
              {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
               CapForm[None], 
               CircleBox[{0.13270786651127311`, 0.7046282783339405}, {0.030870370370370374`, 0.04630555555555556},
                 NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
               {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                DiskBox[{0.1266130095668783, 0.66884017722208}, {0.030870370370370374`, 0.04630555555555556},
                  NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
               {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                CapForm[None], 
                CircleBox[{0.1266130095668783, 0.66884017722208}, {0.030870370370370374`, 0.04630555555555556},
                  NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                 DiskBox[{0.17163137689035368`, 0.7339355297918034}, {0.030870370370370374`, 0.04630555555555556},
                   NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                 CapForm[None], 
                 CircleBox[{0.17163137689035368`, 0.7339355297918034}, {0.030870370370370374`, 0.04630555555555556},
                   NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                 {RGBColor[1, 0, 0], Opacity[1], 
                  DiskBox[{0.13494928311717408`, 0.6816308030078513}, {0.030870370370370374`, 0.04630555555555556},
                    NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                 {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}],
                   CapForm[None], 
                  CircleBox[{0.13494928311717408`, 0.6816308030078513}, {0.030870370370370374`, 0.04630555555555556},
                    NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                  {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                   DiskBox[{0.18314382766484683`, 0.7381941824828057}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                  {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                   Dashing[{}], CapForm[None], 
                   CircleBox[{0.18314382766484683`, 0.7381941824828057}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                   {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.18048077516422373`, 0.7189609457513234}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.18048077516422373`, 0.7189609457513234}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.24163147395483275`, 0.7274084956530797}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.24163147395483275`, 0.7274084956530797}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.11444014977697356`, 0.6752580155706648}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.11444014977697356`, 0.6752580155706648}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.21875901871998993`, 0.765493188866323}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.21875901871998993`, 0.765493188866323}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.1503677751376467, 0.7100390281227604}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1503677751376467, 0.7100390281227604}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.16438986556142346`, 0.7433495155030547}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16438986556142346`, 0.7433495155030547}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.10441613593677268`, 0.7430206333135643}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.10441613593677268`, 0.7430206333135643}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.20144585898487516`, 0.7701576360239594}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.20144585898487516`, 0.7701576360239594}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.2142767607396895, 0.66722444818024}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.2142767607396895, 0.66722444818024}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.16833098083124926`, 0.7881394634274697}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16833098083124926`, 0.7881394634274697}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.17097685784119743`, 0.7752155126286593}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.17097685784119743`, 0.7752155126286593}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.1639867834485963, 0.760056850167667}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1639867834485963, 0.760056850167667}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.11975689539613273`, 0.8284428731472119}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.11975689539613273`, 0.8284428731472119}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.16199964595695196`, 0.7607195541176355}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16199964595695196`, 0.7607195541176355}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.16433589781993904`, 0.6362843606416446}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16433589781993904`, 0.6362843606416446}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.15426381655259672`, 0.7962050996350336}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.15426381655259672`, 0.7962050996350336}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.20542179202163038`, 0.7831549811218212}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.20542179202163038`, 0.7831549811218212}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.1481933079363576, 0.7179952308779909}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1481933079363576, 0.7179952308779909}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.11250502044917561`, 0.71138341871372}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.11250502044917561`, 0.71138341871372}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.10598775323031576`, 0.7016301327471045}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.10598775323031576`, 0.7016301327471045}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.14948187933426488`, 0.6561817405447755}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.14948187933426488`, 0.6561817405447755}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.14392731277386364`, 0.8051571431592377}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.14392731277386364`, 0.8051571431592377}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.11916439173757104`, 0.751221809806875}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.11916439173757104`, 0.751221809806875}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.20213958481917105`, 0.7593300195540715}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.20213958481917105`, 0.7593300195540715}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.20411271899163033`, 0.8104979399029238}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.20411271899163033`, 0.8104979399029238}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.1558409246083144, 0.7121153472344672}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1558409246083144, 0.7121153472344672}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.12374781182208597`, 0.8061885845399849}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.12374781182208597`, 0.8061885845399849}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.11583853421128631`, 0.8265984016751078}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.11583853421128631`, 0.8265984016751078}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.162607020485542, 0.7674979732857237}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.162607020485542, 0.7674979732857237}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.16342081942362538`, 0.684439429312888}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16342081942362538`, 0.684439429312888}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.16339129468800115`, 0.7050268080550433}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16339129468800115`, 0.7050268080550433}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.19487761263689982`, 0.8171071532715722}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.19487761263689982`, 0.8171071532715722}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.20919599934724553`, 0.7602510083117288}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.20919599934724553`, 0.7602510083117288}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.17090436288770278`, 0.7369860425971643}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.17090436288770278`, 0.7369860425971643}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.09446233314179885, 0.7306859208749301}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.09446233314179885, 0.7306859208749301}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.1809150405162427, 0.6758914361266499}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1809150405162427, 0.6758914361266499}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.15204772332268188`, 0.7665325270243578}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.15204772332268188`, 0.7665325270243578}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.18519570193587787`, 0.7727397561063772}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.18519570193587787`, 0.7727397561063772}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.20568580417259685`, 0.7541956603255492}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.20568580417259685`, 0.7541956603255492}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.16378309951738373`, 0.7057082526161692}, 
                    {0.030870370370370374`, 0.04630555555555556}, 
                    NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16378309951738373`, 0.7057082526161692}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.1596988995002085, 0.7112325640635403}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1596988995002085, 0.7112325640635403}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.2302681856629148, 0.7477843988715976}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.2302681856629148, 0.7477843988715976}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.24016535634064068`, 0.7328270049006061}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.24016535634064068`, 0.7328270049006061}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.17217695910819933`, 0.7361918210451561}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.17217695910819933`, 0.7361918210451561}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.19644730787189976`, 0.7355006814132998}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.19644730787189976`, 0.7355006814132998}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.16773583178646434`, 0.7501366878449977}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16773583178646434`, 0.7501366878449977}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.13513363935468475`, 0.775248779257651}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.13513363935468475`, 0.775248779257651}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.17200221498999976`, 0.7903614960065755}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.17200221498999976`, 0.7903614960065755}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.1838920028702114, 0.7540554708123601}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1838920028702114, 0.7540554708123601}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.16936066138432418`, 0.753330587855946}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16936066138432418`, 0.753330587855946}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.2225630323184003, 0.7570700493038968}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.2225630323184003, 0.7570700493038968}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.13013312156254264`, 0.8046609475546139}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.13013312156254264`, 0.8046609475546139}, 
                    {0.030870370370370374`, 0.04630555555555556}, NCache[{0, 
                    2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.15668045151566012`, 0.7913616288171724}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.15668045151566012`, 0.7913616288171724}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.11904271144630928`, 0.8180195881657848}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.11904271144630928`, 0.8180195881657848}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.15092294182993451`, 0.7930246101199494}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.15092294182993451`, 0.7930246101199494}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.11363682020325194`, 0.727941753579797}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.11363682020325194`, 0.727941753579797}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.16563999862777173`, 0.7514489850888507}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16563999862777173`, 0.7514489850888507}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.11363419658833476`, 0.7350734078023837}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.11363419658833476`, 0.7350734078023837}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.20859737498645073`, 0.7329559847653601}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.20859737498645073`, 0.7329559847653601}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.15679702754284772`, 0.7869329923528072}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.15679702754284772`, 0.7869329923528072}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.19040978765011685`, 0.7340818351511996}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.19040978765011685`, 0.7340818351511996}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.173651849458961, 0.7829260987342007}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.173651849458961, 0.7829260987342007}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.2084164214209503, 0.715425826262482}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.2084164214209503, 0.715425826262482}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.18921881389006154`, 0.6843884845259185}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.18921881389006154`, 0.6843884845259185}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.1528479748091814, 0.7318607331301731}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1528479748091814, 0.7318607331301731}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.10881679133522346`, 0.7800967308739549}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.10881679133522346`, 0.7800967308739549}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.153018058461559, 0.8429021627565985}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.153018058461559, 0.8429021627565985}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.17176809108017047`, 0.7447157293184402}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.17176809108017047`, 0.7447157293184402}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.2178839129886952, 0.6975605443744385}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.2178839129886952, 0.6975605443744385}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.14553442099168207`, 0.7819816935852252}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.14553442099168207`, 0.7819816935852252}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.18420685610002963`, 0.740861356359363}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.18420685610002963`, 0.740861356359363}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.16988424809493943`, 0.7520389256272987}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16988424809493943`, 0.7520389256272987}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.23674576309621398`, 0.7590641223550431}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.23674576309621398`, 0.7590641223550431}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.2045292437322936, 0.6836297773641676}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.2045292437322936, 0.6836297773641676}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.18548113251903478`, 0.7689147240543597}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.18548113251903478`, 0.7689147240543597}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.17544821238597566`, 0.7531087424766851}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.17544821238597566`, 0.7531087424766851}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.16241547287868302`, 0.7508235235024672}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16241547287868302`, 0.7508235235024672}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.14507907979860377`, 0.7294441306352335}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.14507907979860377`, 0.7294441306352335}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.1729777301207578, 0.7763141554659955}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.1729777301207578, 0.7763141554659955}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.15910898658279568`, 0.7232473330393165}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.15910898658279568`, 0.7232473330393165}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.15803354545121057`, 0.7999642530382449}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.15803354545121057`, 0.7999642530382449}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.14120511861793705`, 0.8431689309614905}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.14120511861793705`, 0.8431689309614905}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.15788045359041422`, 0.7697732473659346}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.15788045359041422`, 0.7697732473659346}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.16734626364915337`, 0.8454482919415076}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.16734626364915337`, 0.8454482919415076}, {0.030870370370370374`, 0.04630555555555556},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.5299364318536629, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5299364318536629, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.5, 0.7949046477804943}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5, 0.7949046477804943}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.47006356814633715`, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.47006356814633715`, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.5, 0.7050953522195057}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5, 0.7050953522195057}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.5299364318536629, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5299364318536629, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.5782696190476191, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5782696190476191, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.5677834784397685, 0.8087022142857143}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5677834784397685, 0.8087022142857143}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.5391348095238095, 0.8516752176596527}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5391348095238095, 0.8516752176596527}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.5, 0.8674044285714285}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5, 0.8674044285714285}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.46086519047619046`, 0.8516752176596527}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.46086519047619046`, 0.8516752176596527}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.4322165215602315, 0.8087022142857143}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.4322165215602315, 0.8087022142857143}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.42173038095238097`, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.42173038095238097`, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.4322165215602315, 0.6912977857142857}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.4322165215602315, 0.6912977857142857}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.46086519047619046`, 0.6483247823403473}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.46086519047619046`, 0.6483247823403473}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.5, 0.6325955714285715}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5, 0.6325955714285715}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.5391348095238095, 0.6483247823403473}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5391348095238095, 0.6483247823403473}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[0.333333, 0.333333, 0.333333], Opacity[1], 
                    DiskBox[{0.5677834784397685, 0.6912977857142857}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5677834784397685, 0.6912977857142857}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1, 0, 0], Opacity[1], 
                    DiskBox[{0.5782696190476191, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5782696190476191, 0.75}, {0.017640211640211644`, 0.026460317460317462`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5, 0.75}, {0.054103025450640954`, 0.08115453817596142},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5, 0.75}, {0.10820605090128191`, 0.16230907635192285`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], InsetBox[
                    GraphicsBox[
                    {Thickness[0.006024096385542169], 
                    {FaceForm[{RGBColor[0.64314, 0., 0.35686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{3.16, 
                    64.6}, {1.12, 67.72}, {1.9600000000000002`, 
                    60.279999999999994`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{3.16, 
                    64.6}, {1.12, 67.72}, {1.9600000000000002`, 
                    60.279999999999994`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.64314, 0., 0.35686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{1.12, 
                    67.72}, {3.16, 64.6}, {3.52, 74.67999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{1.12, 67.72}, {3.16, 64.6}, {3.52, 
                    74.67999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.64314, 0., 0.35686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{3.52, 
                    74.67999999999999}, {1.3599999999999999`, 
                    75.63999999999999}, {1.12, 67.72}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{3.52, 74.67999999999999}, {1.3599999999999999`, 
                    75.63999999999999}, {1.12, 67.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61961, 0., 0.38039], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{1.36, 
                    75.64}, {3.5200000000000005`, 74.68}, {5.08, 84.64}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{1.36, 75.64}, {3.5200000000000005`, 
                    74.68}, {5.08, 84.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61961, 0., 0.38039], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{5.08, 
                    84.64}, {2.56, 83.44}, {1.3599999999999999`, 75.64}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{5.08, 84.64}, {2.56, 
                    83.44}, {1.3599999999999999`, 75.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61961, 0., 0.38039], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{4.24, 
                    55.120000000000005`}, {1.96, 
                    60.28}, {3.7600000000000002`, 53.56}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{4.24, 55.120000000000005`}, {1.96, 
                    60.28}, {3.7600000000000002`, 53.56}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.64314, 0., 0.35686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{1.96, 
                    60.28}, {4.24, 55.120000000000005`}, {3.16, 64.6}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{1.96, 60.28}, {4.24, 
                    55.120000000000005`}, {3.16, 64.6}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.57255, 0., 0.42745000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{2.56, 83.44000000000001}, {5.08, 
                    84.64000000000001}, {7.84, 94.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{2.56, 83.44000000000001}, {5.08, 
                    84.64000000000001}, {7.84, 94.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.57255, 0., 0.42745000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{7.84, 94.11999999999999}, {4.72, 
                    90.88}, {2.5599999999999996`, 83.44}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{7.84, 
                    94.11999999999999}, {4.72, 90.88}, {2.5599999999999996`, 
                    83.44}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7215699999999999, 0., 0.27843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{7.84, 61.720000000000006`}, {3.16, 
                    64.60000000000001}, {4.24, 55.120000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{7.84, 61.720000000000006`}, {3.16, 
                    64.60000000000001}, {4.24, 55.120000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7215699999999999, 0., 0.27843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{3.16, 64.6}, {7.84, 61.71999999999999}, {8.32, 
                    73.47999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{3.16, 
                    64.6}, {7.84, 61.71999999999999}, {8.32, 
                    73.47999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7215699999999999, 0., 0.27843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{8.32, 73.48}, {3.5200000000000005`, 
                    74.68}, {3.160000000000001, 64.60000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{8.32, 73.48}, {3.5200000000000005`, 
                    74.68}, {3.160000000000001, 64.60000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6823499999999999, 0., 0.31765], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{3.52, 74.67999999999999}, {8.32, 
                    73.47999999999999}, {10.12, 85.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{3.52, 74.67999999999999}, {8.32, 
                    73.47999999999999}, {10.12, 85.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6823499999999999, 0., 0.31765], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{10.12, 85.24000000000001}, {5.079999999999999, 
                    84.64000000000001}, {3.5199999999999996`, 74.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{10.12, 
                    85.24000000000001}, {5.079999999999999, 
                    84.64000000000001}, {3.5199999999999996`, 74.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61961, 0., 0.38039], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{3.7600000000000002`, 
                    53.56}, {6.5200000000000005`, 46.72}, {4.24, 
                    55.120000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{3.7600000000000002`, 
                    53.56}, {6.5200000000000005`, 46.72}, {4.24, 
                    55.120000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6823499999999999, 0., 0.31765], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{9.04, 50.68}, {4.239999999999999, 55.12}, {6.52, 
                    46.72}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{9.04, 
                    50.68}, {4.239999999999999, 55.12}, {6.52, 46.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7215699999999999, 0., 0.27843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{4.24, 55.120000000000005`}, {9.04, 
                    50.68000000000001}, {7.84, 61.720000000000006`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{4.24, 55.120000000000005`}, {9.04, 
                    50.68000000000001}, {7.84, 61.720000000000006`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51765, 0., 0.48235000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{11.68, 102.52}, {7.84, 97.6}, {4.72, 90.88}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{11.68, 102.52}, {7.84, 97.6}, {4.72, 90.88}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51765, 0., 0.48235000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{4.72, 90.88}, {7.84, 94.11999999999999}, {11.68, 
                    102.52}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{4.72, 
                    90.88}, {7.84, 94.11999999999999}, {11.68, 102.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61176, 0., 0.38824], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{5.08, 
                    84.64}, {10.120000000000001`, 85.24}, {13.36, 96.28}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{5.08, 84.64}, {10.120000000000001`, 
                    85.24}, {13.36, 96.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61176, 0., 0.38824], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{13.360000000000001`, 96.28}, {7.840000000000002, 
                    94.12}, {5.080000000000002, 84.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{13.360000000000001`, 96.28}, {7.840000000000002, 
                    94.12}, {5.080000000000002, 84.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61176, 0., 0.38824], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{11.56, 
                    40.839999999999996`}, {6.5200000000000005`, 
                    46.72}, {9.76, 39.63999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{11.56, 
                    40.839999999999996`}, {6.5200000000000005`, 
                    46.72}, {9.76, 39.63999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6823499999999999, 0., 0.31765], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{6.52, 
                    46.720000000000006`}, {11.559999999999999`, 
                    40.84}, {9.04, 50.68000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{6.52, 
                    46.720000000000006`}, {11.559999999999999`, 
                    40.84}, {9.04, 50.68000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.4549, 0., 0.5451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{16.36, 
                    109.48}, {11.559999999999999`, 103.12}, {7.84, 
                    97.60000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{16.36, 
                    109.48}, {11.559999999999999`, 103.12}, {7.84, 
                    97.60000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.4549, 0., 0.5451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{7.84, 
                    97.6}, {11.68, 102.52}, {16.36, 109.47999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{7.84, 97.6}, {11.68, 102.52}, {16.36, 
                    109.47999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{17.8, 
                    106.11999999999999`}, {11.680000000000001`, 
                    102.52}, {7.84, 94.11999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{17.8, 
                    106.11999999999999`}, {11.680000000000001`, 
                    102.52}, {7.84, 94.11999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{7.84, 
                    94.11999999999999}, {13.36, 96.27999999999999}, {17.8, 
                    106.11999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{7.84, 
                    94.11999999999999}, {13.36, 96.27999999999999}, {17.8, 
                    106.11999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8, 0., 0.2], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{14.56, 
                    59.08}, {7.840000000000001, 61.72}, {9.040000000000001, 
                    50.68}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{14.56, 
                    59.08}, {7.840000000000001, 61.72}, {9.040000000000001, 
                    50.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8, 0., 0.2], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{7.84, 
                    61.720000000000006`}, {14.559999999999999`, 
                    59.080000000000005`}, {15.04, 72.16000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{7.84, 
                    61.720000000000006`}, {14.559999999999999`, 
                    59.080000000000005`}, {15.04, 72.16000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8, 0., 0.2], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{15.04, 
                    72.16}, {8.32, 73.47999999999999}, {7.839999999999999, 
                    61.72}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{15.04, 
                    72.16}, {8.32, 73.47999999999999}, {7.839999999999999, 
                    61.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{8.32, 
                    73.48}, {15.04, 72.16000000000001}, {17.08, 85.12}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{8.32, 73.48}, {15.04, 
                    72.16000000000001}, {17.08, 85.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{17.08, 
                    85.11999999999999}, {10.119999999999997`, 
                    85.24}, {8.319999999999999, 73.47999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{17.08, 
                    85.11999999999999}, {10.119999999999997`, 
                    85.24}, {8.319999999999999, 73.47999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{15.76, 
                    46.96}, {9.04, 50.68}, {11.559999999999999`, 40.84}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{15.76, 46.96}, {9.04, 
                    50.68}, {11.559999999999999`, 40.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8, 0., 0.2], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{9.04, 
                    50.68}, {15.759999999999998`, 
                    46.96}, {14.559999999999999`, 59.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{9.04, 50.68}, {15.759999999999998`, 
                    46.96}, {14.559999999999999`, 59.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61176, 0., 0.38824], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{9.76, 
                    39.64}, {15.28, 32.8}, {11.56, 40.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{9.76, 39.64}, {15.28, 32.8}, {11.56, 40.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{15.28, 
                    32.8}, {9.76, 39.64}, {13.84, 34.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{15.28, 32.8}, {9.76, 39.64}, {13.84, 34.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.65098, 0., 0.34902], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{10.12, 
                    85.24000000000001}, {17.08, 85.12}, {20.56, 97.48}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{10.12, 85.24000000000001}, {17.08, 
                    85.12}, {20.56, 97.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.65098, 0., 0.34902], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{20.56, 
                    97.48}, {13.36, 96.28}, {10.12, 85.24000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{20.56, 97.48}, {13.36, 96.28}, {10.12, 
                    85.24000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.65098, 0., 0.34902], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{18.52, 
                    36.04}, {11.559999999999999`, 
                    40.839999999999996`}, {15.28, 32.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{18.52, 36.04}, {11.559999999999999`, 
                    40.839999999999996`}, {15.28, 32.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{11.56, 
                    40.839999999999996`}, {18.52, 
                    36.04}, {15.760000000000002`, 46.959999999999994`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{11.56, 40.839999999999996`}, {18.52, 
                    36.04}, {15.760000000000002`, 46.959999999999994`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.4313700000000001, 0., 0.5686300000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{23.08, 114.28}, {16.36, 
                    109.48}, {11.679999999999998`, 102.52}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{23.08, 114.28}, {16.36, 
                    109.48}, {11.679999999999998`, 102.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.4313700000000001, 0., 0.5686300000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{11.68, 102.52}, {17.799999999999997`, 
                    106.11999999999999`}, {23.08, 114.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{11.68, 102.52}, {17.799999999999997`, 
                    106.11999999999999`}, {23.08, 114.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{25.36, 108.28}, {17.8, 106.12}, {13.36, 
                    96.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{25.36, 
                    108.28}, {17.8, 106.12}, {13.36, 96.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{13.360000000000001`, 
                    96.28}, {20.560000000000002`, 97.48}, {25.36, 108.28}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{13.360000000000001`, 
                    96.28}, {20.560000000000002`, 97.48}, {25.36, 108.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{13.84, 
                    34.48}, {20.08, 26.799999999999997`}, {15.28, 32.8}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{13.84, 34.48}, {20.08, 
                    26.799999999999997`}, {15.28, 32.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.8705900000000001, 0., 0.12941000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{22.72, 56.92}, {14.559999999999999`, 
                    59.08}, {15.759999999999998`, 46.96}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{22.72, 56.92}, {14.559999999999999`, 
                    59.08}, {15.759999999999998`, 46.96}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.8705900000000001, 0., 0.12941000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{14.56, 59.08}, {22.72, 56.92}, {23.2, 70.84}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{14.56, 59.08}, {22.72, 56.92}, {23.2, 70.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.8705900000000001, 0., 0.12941000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{23.2, 70.84}, {15.04, 72.16}, {14.56, 
                    59.080000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{23.2, 
                    70.84}, {15.04, 72.16}, {14.56, 59.080000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8078400000000001, 0., 0.19216], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{15.04, 72.16}, {23.2, 70.84}, {25.24, 84.64}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{15.04, 72.16}, {23.2, 70.84}, {25.24, 84.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8078400000000001, 0., 0.19216], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{25.24, 84.64}, {17.08, 85.12}, {15.04, 
                    72.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{25.24, 
                    84.64}, {17.08, 85.12}, {15.04, 72.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{22.6, 27.16}, {15.280000000000001`, 
                    32.8}, {20.080000000000002`, 26.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{22.6, 27.16}, {15.280000000000001`, 
                    32.8}, {20.080000000000002`, 26.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.65098, 0., 0.34902], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{15.28, 
                    32.8}, {22.599999999999998`, 
                    27.159999999999997`}, {18.52, 36.04}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{15.28, 32.8}, {22.599999999999998`, 
                    27.159999999999997`}, {18.52, 36.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8078400000000001, 0., 0.19216], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{23.8, 
                    43.839999999999996`}, {15.760000000000002`, 
                    46.959999999999994`}, {18.52, 36.04}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{23.8, 
                    43.839999999999996`}, {15.760000000000002`, 
                    46.959999999999994`}, {18.52, 36.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.8705900000000001, 0., 0.12941000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{15.76, 46.96}, {23.799999999999997`, 
                    43.84}, {22.72, 56.92}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{15.76, 
                    46.96}, {23.799999999999997`, 43.84}, {22.72, 56.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{16.36, 
                    109.48}, {23.08, 114.28}, {29.08, 120.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{16.36, 109.48}, {23.08, 114.28}, {29.08, 
                    120.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{29.08, 
                    120.16}, {21.52, 114.75999999999999`}, {16.36, 
                    109.47999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{29.08, 
                    120.16}, {21.52, 114.75999999999999`}, {16.36, 
                    109.47999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6901999999999999, 0., 0.3098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{17.08, 85.11999999999999}, {25.24, 
                    84.63999999999999}, {29.08, 97.71999999999998}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{17.08, 85.11999999999999}, {25.24, 
                    84.63999999999999}, {29.08, 97.71999999999998}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6901999999999999, 0., 0.3098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{29.08, 97.72}, {20.56, 97.48}, {17.08, 
                    85.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{29.08, 
                    97.72}, {20.56, 97.48}, {17.08, 85.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.40392000000000006`, 0., 0.5960799999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{31.24, 117.28}, {23.08, 
                    114.28}, {17.799999999999997`, 106.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{31.24, 117.28}, {23.08, 
                    114.28}, {17.799999999999997`, 106.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.40392000000000006`, 0., 0.5960799999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{17.8, 106.11999999999999`}, {25.36, 
                    108.27999999999999`}, {31.240000000000002`, 
                    117.27999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{17.8, 
                    106.11999999999999`}, {25.36, 
                    108.27999999999999`}, {31.240000000000002`, 
                    117.27999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6901999999999999, 0., 0.3098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{26.68, 32.32}, {18.52, 36.04}, {22.6, 27.16}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{26.68, 32.32}, {18.52, 36.04}, {22.6, 27.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8078400000000001, 0., 0.19216], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{18.52, 36.04}, {26.68, 32.32}, {23.8, 
                    43.839999999999996`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{18.52, 
                    36.04}, {26.68, 32.32}, {23.8, 43.839999999999996`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{20.08, 26.8}, {27.639999999999997`, 
                    20.68}, {22.599999999999998`, 27.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{20.08, 26.8}, {27.639999999999997`, 
                    20.68}, {22.599999999999998`, 27.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53725, 0., 0.46275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{20.56, 
                    97.48}, {29.08, 97.72}, {34.12, 109.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{20.56, 
                    97.48}, {29.08, 97.72}, {34.12, 109.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53725, 0., 0.46275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{34.120000000000005`, 
                    109.48}, {25.360000000000007`, 
                    108.28}, {20.560000000000002`, 97.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{34.120000000000005`, 
                    109.48}, {25.360000000000007`, 
                    108.28}, {20.560000000000002`, 97.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53725, 0., 0.46275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{30.88, 
                    22.959999999999997`}, {22.6, 
                    27.159999999999997`}, {27.64, 20.679999999999996`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{30.88, 22.959999999999997`}, {22.6, 
                    27.159999999999997`}, {27.64, 20.679999999999996`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6901999999999999, 0., 0.3098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{22.6, 27.16}, {30.880000000000003`, 
                    22.96}, {26.68, 32.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{22.6, 
                    27.16}, {30.880000000000003`, 22.96}, {26.68, 32.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.92549, 0., 0.07451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{31.6, 
                    55.}, {22.72, 56.92}, {23.8, 43.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{31.6, 55.}, {22.72, 56.92}, {23.8, 43.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.92549, 0., 0.07451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{22.72, 
                    56.92}, {31.6, 55.}, {32.2, 69.4}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{22.72, 56.92}, {31.6, 55.}, {32.2, 69.4}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.92549, 0., 0.07451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.2, 
                    69.4}, {23.200000000000003`, 
                    70.84}, {22.720000000000002`, 56.92}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{32.2, 69.4}, {23.200000000000003`, 
                    70.84}, {22.720000000000002`, 56.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29804, 0., 0.7019599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{23.08, 114.28}, {31.24, 
                    117.28}, {37.599999999999994`, 123.88}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{23.08, 114.28}, {31.24, 
                    117.28}, {37.599999999999994`, 123.88}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29804, 0., 0.7019599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{37.6, 123.88}, {29.080000000000002`, 
                    120.16}, {23.080000000000002`, 114.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{37.6, 123.88}, {29.080000000000002`, 
                    120.16}, {23.080000000000002`, 114.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8549000000000001, 0., 0.1451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{23.2, 70.84}, {32.2, 69.4}, {34.36, 83.92}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{23.2, 70.84}, {32.2, 69.4}, {34.36, 83.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8549000000000001, 0., 0.1451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{34.36, 83.92}, {25.240000000000002`, 
                    84.64}, {23.2, 70.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{34.36, 
                    83.92}, {25.240000000000002`, 84.64}, {23.2, 70.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8549000000000001, 0., 0.1451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{32.8, 41.44}, {23.799999999999997`, 
                    43.839999999999996`}, {26.68, 32.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{32.8, 41.44}, {23.799999999999997`, 
                    43.839999999999996`}, {26.68, 32.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.92549, 0., 0.07451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{23.8, 
                    43.839999999999996`}, {32.8, 41.44}, {31.6, 55.}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{23.8, 43.839999999999996`}, {32.8, 
                    41.44}, {31.6, 55.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.71765, 0., 0.28235000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{25.24, 84.64}, {34.36, 83.92}, {38.2, 97.48}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{25.24, 84.64}, {34.36, 83.92}, {38.2, 97.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.71765, 0., 0.28235000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{38.2, 97.48}, {29.080000000000005`, 
                    97.72}, {25.240000000000002`, 84.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{38.2, 97.48}, {29.080000000000005`, 
                    97.72}, {25.240000000000002`, 84.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.38431000000000004`, 0., 0.6156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{25.36, 108.28}, {34.12, 109.48}, {40.12, 
                    118.96000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{25.36, 
                    108.28}, {34.12, 109.48}, {40.12, 118.96000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.38431000000000004`, 0., 0.6156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{40.120000000000005`, 
                    118.96000000000001`}, {31.240000000000002`, 
                    117.28}, {25.360000000000007`, 108.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{40.120000000000005`, 
                    118.96000000000001`}, {31.240000000000002`, 
                    117.28}, {25.360000000000007`, 108.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.71765, 0., 0.28235000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{35.56, 29.439999999999998`}, {26.68, 
                    32.32}, {30.880000000000003`, 22.959999999999997`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 10.}]
                    , JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{35.56, 
                    29.439999999999998`}, {26.68, 
                    32.32}, {30.880000000000003`, 22.959999999999997`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8549000000000001, 0., 0.1451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{26.68, 32.32}, {35.56, 29.44}, {32.8, 41.44}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{26.68, 32.32}, {35.56, 29.44}, {32.8, 41.44}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53725, 0., 0.46275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{27.64, 
                    20.68}, {36.16, 16.12}, {30.880000000000003`, 22.96}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{27.64, 20.68}, {36.16, 
                    16.12}, {30.880000000000003`, 22.96}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.38431000000000004`, 0., 0.6156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{36.160000000000004`, 
                    16.12}, {27.640000000000004`, 20.68}, {33.52, 
                    16.720000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{36.160000000000004`, 
                    16.12}, {27.640000000000004`, 20.68}, {33.52, 
                    16.720000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.22353, 0., 0.77647], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{29.08, 
                    120.16}, {37.599999999999994`, 
                    123.88}, {44.31999999999999, 127.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{29.08, 120.16}, {37.599999999999994`, 
                    123.88}, {44.31999999999999, 127.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.22353, 0., 0.77647], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{44.32, 
                    127.84}, {35.2, 
                    123.88000000000001`}, {29.080000000000002`, 120.16}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{44.32, 127.84}, {35.2, 
                    123.88000000000001`}, {29.080000000000002`, 120.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5451, 0., 0.4549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{29.08, 
                    97.72}, {38.199999999999996`, 97.48}, {43.36, 109.6}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{29.08, 97.72}, {38.199999999999996`, 
                    97.48}, {43.36, 109.6}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5451, 0., 0.4549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{43.36, 
                    109.6}, {34.120000000000005`, 
                    109.47999999999999`}, {29.08, 97.72}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{43.36, 109.6}, {34.120000000000005`, 
                    109.47999999999999`}, {29.08, 97.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5451, 0., 0.4549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{39.760000000000005`, 
                    19.84}, {30.880000000000003`, 
                    22.96}, {36.160000000000004`, 16.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{39.760000000000005`, 
                    19.84}, {30.880000000000003`, 
                    22.96}, {36.160000000000004`, 16.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.71765, 0., 0.28235000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{30.88, 22.959999999999997`}, {39.76, 
                    19.839999999999996`}, {35.56, 29.439999999999998`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{30.88, 22.959999999999997`}, {39.76, 
                    19.839999999999996`}, {35.56, 29.439999999999998`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.24706000000000003`, 0., 0.75294], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{46.839999999999996`, 
                    125.92}, {37.599999999999994`, 
                    123.88}, {31.239999999999995`, 117.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{46.839999999999996`, 
                    125.92}, {37.599999999999994`, 
                    123.88}, {31.239999999999995`, 117.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.24706000000000003`, 0., 0.75294], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{31.24, 117.28}, {40.12, 
                    118.96000000000001`}, {46.839999999999996`, 125.92}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{31.24, 117.28}, {40.12, 
                    118.96000000000001`}, {46.839999999999996`, 125.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.96471, 0., 0.03529399999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{41.08, 53.2}, {31.599999999999998`, 55.}, {32.8, 
                    41.440000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{41.08, 
                    53.2}, {31.599999999999998`, 55.}, {32.8, 
                    41.440000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.96471, 0., 0.03529399999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{31.6, 55.}, {41.08, 53.2}, {41.68, 
                    67.96000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{31.6, 
                    55.}, {41.08, 53.2}, {41.68, 67.96000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.96471, 0., 0.03529399999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{41.68, 67.96000000000001}, {32.2, 69.4}, {31.6, 
                    55.00000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{41.68, 
                    67.96000000000001}, {32.2, 69.4}, {31.6, 
                    55.00000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.88235, 0., 0.11765], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.2, 
                    69.4}, {41.68000000000001, 67.96000000000001}, {43.96, 
                    82.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.2, 
                    69.4}, {41.68000000000001, 67.96000000000001}, {43.96, 
                    82.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.88235, 0., 0.11765], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{43.96, 
                    82.84}, {34.36, 83.92}, {32.2, 69.4}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{43.96, 82.84}, {34.36, 83.92}, {32.2, 69.4}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.88235, 0., 0.11765], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{42.160000000000004`, 
                    39.4}, {32.800000000000004`, 41.44}, {35.56, 
                    29.439999999999998`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 10.}]
                    , JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{42.160000000000004`, 
                    39.4}, {32.800000000000004`, 41.44}, {35.56, 
                    29.439999999999998`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.96471, 0., 0.03529399999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{32.8, 41.44}, {42.16, 39.4}, {41.08, 
                    53.199999999999996`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.8, 
                    41.44}, {42.16, 39.4}, {41.08, 53.199999999999996`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.38431000000000004`, 0., 0.6156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{33.52, 16.72}, {42.160000000000004`, 
                    11.919999999999998`}, {36.160000000000004`, 
                    16.119999999999997`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{33.52, 
                    16.72}, {42.160000000000004`, 
                    11.919999999999998`}, {36.160000000000004`, 
                    16.119999999999997`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{49.6, 
                    119.44000000000001`}, {40.120000000000005`, 
                    118.96000000000001`}, {34.120000000000005`, 
                    109.48000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{49.6, 
                    119.44000000000001`}, {40.120000000000005`, 
                    118.96000000000001`}, {34.120000000000005`, 
                    109.48000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{34.120000000000005`, 109.48}, {43.36, 
                    109.60000000000001`}, {49.60000000000001, 119.44}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{34.120000000000005`, 109.48}, {43.36, 
                    109.60000000000001`}, {49.60000000000001, 119.44}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.73725, 0., 0.26275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{34.36, 
                    83.92}, {43.96, 82.84}, {47.8, 96.76}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{34.36, 83.92}, {43.96, 82.84}, {47.8, 96.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.73725, 0., 0.26275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{47.8, 
                    96.76}, {38.199999999999996`, 97.48}, {34.36, 83.92}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{47.8, 96.76}, {38.199999999999996`, 
                    97.48}, {34.36, 83.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.73725, 0., 0.26275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{44.92, 
                    27.16}, {35.56, 29.44}, {39.760000000000005`, 19.84}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{44.92, 27.16}, {35.56, 
                    29.44}, {39.760000000000005`, 19.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.88235, 0., 0.11765], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{35.56, 
                    29.439999999999998`}, {44.92, 
                    27.159999999999997`}, {42.160000000000004`, 39.4}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{35.56, 29.439999999999998`}, {44.92, 
                    27.159999999999997`}, {42.160000000000004`, 39.4}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{45.04, 
                    12.639999999999999`}, {36.16, 
                    16.119999999999997`}, {42.16, 11.919999999999998`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{45.04, 12.639999999999999`}, {36.16, 
                    16.119999999999997`}, {42.16, 11.919999999999998`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5451, 0., 0.4549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{36.160000000000004`, 
                    16.12}, {45.040000000000006`, 
                    12.64}, {39.760000000000005`, 19.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{36.160000000000004`, 
                    16.12}, {45.040000000000006`, 
                    12.64}, {39.760000000000005`, 19.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.15294000000000005`, 0., 0.84706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{53.8, 130.12}, {44.31999999999999, 
                    127.84}, {37.599999999999994`, 123.88000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{53.8, 130.12}, {44.31999999999999, 
                    127.84}, {37.599999999999994`, 123.88000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.15294000000000005`, 0., 0.84706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{37.6, 123.88}, {46.84, 125.92}, {53.8, 
                    130.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{37.6, 
                    123.88}, {46.84, 125.92}, {53.8, 130.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5529400000000001, 0., 0.44706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{38.2, 97.48}, {47.800000000000004`, 
                    96.76}, {52.96, 109.24000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{38.2, 97.48}, {47.800000000000004`, 
                    96.76}, {52.96, 109.24000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5529400000000001, 0., 0.44706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{52.96, 109.24000000000001`}, {43.36, 
                    109.60000000000001`}, {38.2, 97.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{52.96, 109.24000000000001`}, {43.36, 
                    109.60000000000001`}, {38.2, 97.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5529400000000001, 0., 0.44706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{49., 17.32}, {39.760000000000005`, 
                    19.84}, {45.04, 12.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{49., 
                    17.32}, {39.760000000000005`, 19.84}, {45.04, 12.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.73725, 0., 0.26275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{39.760000000000005`, 19.84}, {49., 
                    17.32}, {44.92, 27.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{39.760000000000005`, 19.84}, {49., 
                    17.32}, {44.92, 27.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.20784000000000002`, 0., 0.7921599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{56.32, 126.76}, {46.84, 
                    125.92}, {40.120000000000005`, 118.96000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{56.32, 126.76}, {46.84, 
                    125.92}, {40.120000000000005`, 118.96000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.20784000000000002`, 0., 0.7921599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{40.120000000000005`, 
                    118.96000000000001`}, {49.60000000000001, 
                    119.44000000000001`}, {56.32000000000001, 126.76}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{40.120000000000005`, 
                    118.96000000000001`}, {49.60000000000001, 
                    119.44000000000001`}, {56.32000000000001, 126.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.97647, 0., 0.023528999999999998`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{51.04, 51.64}, {41.08, 53.2}, {42.16, 
                    39.400000000000006`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{51.04, 
                    51.64}, {41.08, 53.2}, {42.16, 39.400000000000006`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.97647, 0., 0.023528999999999998`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{41.08, 53.2}, {51.04, 51.64}, {51.76, 66.64}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{41.08, 53.2}, {51.04, 51.64}, {51.76, 66.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.97647, 0., 0.023528999999999998`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{51.760000000000005`, 66.64}, {41.68000000000001, 
                    67.96}, {41.080000000000005`, 53.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{51.760000000000005`, 66.64}, {41.68000000000001, 
                    67.96}, {41.080000000000005`, 53.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.89412, 0., 0.10588], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{41.68, 
                    67.96000000000001}, {51.76, 66.64000000000001}, {54.04, 
                    81.52000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{41.68, 
                    67.96000000000001}, {51.76, 66.64000000000001}, {54.04, 
                    81.52000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.89412, 0., 0.10588], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{54.04, 
                    81.52}, {43.96, 82.83999999999999}, {41.68, 67.96}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{54.04, 81.52}, {43.96, 
                    82.83999999999999}, {41.68, 67.96}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{42.160000000000004`, 
                    11.92}, {51.040000000000006`, 
                    8.44}, {45.040000000000006`, 12.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{42.160000000000004`, 
                    11.92}, {51.040000000000006`, 
                    8.44}, {45.040000000000006`, 12.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.89412, 0., 0.10588], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{52.120000000000005`, 
                    37.720000000000006`}, {42.160000000000004`, 
                    39.400000000000006`}, {44.92, 27.160000000000004`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{52.120000000000005`, 
                    37.720000000000006`}, {42.160000000000004`, 
                    39.400000000000006`}, {44.92, 27.160000000000004`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.97647, 0., 0.023528999999999998`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{42.160000000000004`, 
                    39.4}, {52.120000000000005`, 
                    37.72}, {51.040000000000006`, 51.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{42.160000000000004`, 
                    39.4}, {52.120000000000005`, 
                    37.72}, {51.040000000000006`, 51.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{43.36, 
                    109.6}, {52.96, 109.24}, {59.2, 119.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{43.36, 109.6}, {52.96, 109.24}, {59.2, 119.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{59.2, 
                    119.32}, {49.6, 119.44}, {43.36, 109.6}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{59.2, 119.32}, {49.6, 119.44}, {43.36, 109.6}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{43.96, 
                    82.84}, {54.04, 81.52000000000001}, {57.88, 95.68}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{43.96, 
                    82.84}, {54.04, 81.52000000000001}, {57.88, 95.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{57.879999999999995`, 95.67999999999999}, {47.8, 
                    96.75999999999999}, {43.959999999999994`, 
                    82.83999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{57.879999999999995`, 95.67999999999999}, {47.8, 
                    96.75999999999999}, {43.959999999999994`, 
                    82.83999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{54.760000000000005`, 25.36}, {44.92, 
                    27.16}, {49.00000000000001, 17.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{54.760000000000005`, 25.36}, {44.92, 
                    27.16}, {49.00000000000001, 17.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.89412, 0., 0.10588], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{44.92, 
                    27.16}, {54.760000000000005`, 
                    25.36}, {52.120000000000005`, 37.72}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{44.92, 27.16}, {54.760000000000005`, 
                    25.36}, {52.120000000000005`, 37.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{54.28, 
                    10.12}, {45.040000000000006`, 
                    12.639999999999999`}, {51.04, 8.44}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{54.28, 10.12}, {45.040000000000006`, 
                    12.639999999999999`}, {51.04, 8.44}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5529400000000001, 0., 0.44706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{45.04, 12.639999999999999`}, {54.28, 
                    10.12}, {49., 17.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{45.04, 
                    12.639999999999999`}, {54.28, 10.12}, {49., 17.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.10196000000000001`, 0., 0.8980400000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{46.839999999999996`, 
                    125.92}, {56.31999999999999, 
                    126.76}, {63.279999999999994`, 131.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{46.839999999999996`, 
                    125.92}, {56.31999999999999, 
                    126.76}, {63.279999999999994`, 131.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.10196000000000001`, 0., 0.8980400000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{63.28, 131.08}, {53.8, 130.12}, {46.84, 
                    125.92000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{63.28, 
                    131.08}, {53.8, 130.12}, {46.84, 125.92000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.55686, 0., 0.44314], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{47.8, 
                    96.76}, {57.879999999999995`, 95.68}, {63.03999999999999, 
                    108.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{47.8, 
                    96.76}, {57.879999999999995`, 95.68}, {63.03999999999999, 
                    108.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.55686, 0., 0.44314], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{63.04, 
                    108.28}, {52.96, 109.24}, {47.8, 96.76}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{63.04, 108.28}, {52.96, 109.24}, {47.8, 96.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.55686, 0., 0.44314], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{58.720000000000006`, 15.52}, {49.00000000000001, 
                    17.32}, {54.28000000000001, 10.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{58.720000000000006`, 15.52}, {49.00000000000001, 
                    17.32}, {54.28000000000001, 10.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{49., 
                    17.32}, {58.72, 15.52}, {54.76, 25.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{49., 17.32}, {58.72, 15.52}, {54.76, 25.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.18431, 0., 0.8156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{49.6, 119.44000000000001`}, {59.2, 
                    119.32000000000001`}, {65.92, 126.76}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{49.6, 119.44000000000001`}, {59.2, 
                    119.32000000000001`}, {65.92, 126.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.18431, 0., 0.8156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{65.92, 126.76}, {56.32, 126.76}, {49.6, 
                    119.44000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{65.92, 
                    126.76}, {56.32, 126.76}, {49.6, 119.44000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.96471, 0., 0.03529399999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{61.839999999999996`, 50.32}, {51.03999999999999, 
                    51.64}, {52.12, 37.72}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{61.839999999999996`, 50.32}, {51.03999999999999, 
                    51.64}, {52.12, 37.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.96471, 0., 0.03529399999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{51.04, 51.64}, {61.84, 50.32}, {62.56, 65.2}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{51.04, 51.64}, {61.84, 50.32}, {62.56, 65.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.96471, 0., 0.03529399999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{62.56, 65.2}, {51.760000000000005`, 
                    66.64}, {51.040000000000006`, 51.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{62.56, 65.2}, {51.760000000000005`, 
                    66.64}, {51.040000000000006`, 51.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{51.04, 
                    8.44}, {60.28, 5.92}, {54.28, 10.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{51.04, 
                    8.44}, {60.28, 5.92}, {54.28, 10.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.88235, 0., 0.11765], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{51.760000000000005`, 66.64}, {62.56, 
                    65.2}, {64.84, 80.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{51.760000000000005`, 66.64}, {62.56, 
                    65.2}, {64.84, 80.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.88235, 0., 0.11765], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.84, 
                    80.08}, {54.040000000000006`, 
                    81.52}, {51.760000000000005`, 66.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{64.84, 80.08}, {54.040000000000006`, 
                    81.52}, {51.760000000000005`, 66.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.88235, 0., 0.11765], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{62.8, 
                    36.28}, {52.12, 37.72}, {54.76, 25.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{62.8, 36.28}, {52.12, 37.72}, {54.76, 25.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.96471, 0., 0.03529399999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{52.120000000000005`, 
                    37.720000000000006`}, {62.800000000000004`, 
                    36.28000000000001}, {61.84, 50.32000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{52.120000000000005`, 
                    37.720000000000006`}, {62.800000000000004`, 
                    36.28000000000001}, {61.84, 50.32000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{52.96, 
                    109.24000000000001`}, {63.04, 
                    108.28000000000002`}, {69.03999999999999, 118.48}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{52.96, 109.24000000000001`}, {63.04, 
                    108.28000000000002`}, {69.03999999999999, 118.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{69.04, 
                    118.48}, {59.2, 119.32000000000001`}, {52.96000000000001, 
                    109.24000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{69.04, 
                    118.48}, {59.2, 119.32000000000001`}, {52.96000000000001, 
                    109.24000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.06274500000000001, 0., 0.93725], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{70.24000000000001, 132.52}, {60.64000000000001, 
                    131.56}, {53.80000000000001, 130.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{70.24000000000001, 132.52}, {60.64000000000001, 
                    131.56}, {53.80000000000001, 130.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.06274500000000001, 0., 0.93725], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{53.8, 130.12}, {63.28, 131.08}, {70.24, 
                    132.52}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{53.8, 
                    130.12}, {63.28, 131.08}, {70.24, 132.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.73725, 0., 0.26275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{54.04, 
                    81.52}, {64.84, 80.08}, {68.56, 94.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{54.04, 81.52}, {64.84, 80.08}, {68.56, 94.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.73725, 0., 0.26275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{68.56, 
                    94.24000000000001}, {57.88, 95.68}, {54.040000000000006`, 
                    81.52000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{68.56, 
                    94.24000000000001}, {57.88, 95.68}, {54.040000000000006`, 
                    81.52000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{63.760000000000005`, 8.2}, {54.28, 
                    10.12}, {60.28000000000001, 5.919999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{63.760000000000005`, 8.2}, {54.28, 
                    10.12}, {60.28000000000001, 5.919999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.55686, 0., 0.44314], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{54.28, 
                    10.12}, {63.760000000000005`, 8.2}, {58.72, 15.52}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{54.28, 10.12}, {63.760000000000005`, 
                    8.2}, {58.72, 15.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.73725, 0., 0.26275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{65.2, 
                    24.04}, {54.760000000000005`, 25.36}, {58.72, 15.52}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{65.2, 24.04}, {54.760000000000005`, 
                    25.36}, {58.72, 15.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.88235, 0., 0.11765], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{54.760000000000005`, 25.36}, {65.2, 
                    24.04}, {62.800000000000004`, 36.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{54.760000000000005`, 25.36}, {65.2, 
                    24.04}, {62.800000000000004`, 36.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.066667, 0., 0.93333], Opacity[1.]}],
                     FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{56.32, 
                    126.76}, {65.92, 126.76}, {72.88, 131.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{56.32, 126.76}, {65.92, 126.76}, {72.88, 
                    131.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.066667, 0., 0.93333], Opacity[1.]}],
                     FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{72.88, 
                    131.08}, {63.279999999999994`, 
                    131.08}, {56.31999999999999, 126.76000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{72.88, 131.08}, {63.279999999999994`, 
                    131.08}, {56.31999999999999, 126.76000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5529400000000001, 0., 0.44706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{57.879999999999995`, 95.67999999999999}, {68.56, 
                    94.24}, {73.6, 106.72}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{57.879999999999995`, 95.67999999999999}, {68.56, 
                    94.24}, {73.6, 106.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5529400000000001, 0., 0.44706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{73.6, 106.72}, {63.03999999999999, 
                    108.28}, {57.879999999999995`, 95.68}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{73.6, 106.72}, {63.03999999999999, 
                    108.28}, {57.879999999999995`, 95.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5529400000000001, 0., 0.44706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{69.04, 14.2}, {58.720000000000006`, 
                    15.52}, {63.760000000000005`, 8.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{69.04, 14.2}, {58.720000000000006`, 
                    15.52}, {63.760000000000005`, 8.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.73725, 0., 0.26275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{58.720000000000006`, 15.52}, {69.04, 
                    14.2}, {65.2, 24.04}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{58.720000000000006`, 15.52}, {69.04, 
                    14.2}, {65.2, 24.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.17255, 0., 0.82745], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{59.2, 
                    119.32}, {69.04, 118.47999999999999`}, {75.76, 
                    125.91999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{59.2, 
                    119.32}, {69.04, 118.47999999999999`}, {75.76, 
                    125.91999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.17255, 0., 0.82745], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{75.76, 
                    125.92}, {65.92, 126.76}, {59.2, 119.32000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{75.76, 125.92}, {65.92, 126.76}, {59.2, 
                    119.32000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{60.28, 
                    5.92}, {69.64, 4.}, {63.76, 8.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{60.28, 
                    5.92}, {69.64, 4.}, {63.76, 8.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.17255, 0., 0.82745], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{69.64, 
                    4.}, {60.28, 5.92}, {66.76, 4.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{69.64, 4.}, {60.28, 5.92}, {66.76, 4.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.92549, 0., 0.07451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{73.72, 
                    49.}, {61.839999999999996`, 50.32}, {62.8, 36.28}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{73.72, 49.}, {61.839999999999996`, 
                    50.32}, {62.8, 36.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.92549, 0., 0.07451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{61.839999999999996`, 50.32}, {73.72, 
                    49.}, {74.44, 63.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{61.839999999999996`, 50.32}, {73.72, 
                    49.}, {74.44, 63.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.92549, 0., 0.07451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{74.44000000000001, 63.64}, {62.56000000000001, 
                    65.2}, {61.84000000000001, 50.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{74.44000000000001, 63.64}, {62.56000000000001, 
                    65.2}, {61.84000000000001, 50.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8549000000000001, 0., 0.1451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{62.56, 65.2}, {74.44, 63.64}, {76.6, 78.28}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{62.56, 65.2}, {74.44, 63.64}, {76.6, 78.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8549000000000001, 0., 0.1451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{76.6, 78.28}, {64.83999999999999, 
                    80.08}, {62.559999999999995`, 65.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{76.6, 78.28}, {64.83999999999999, 
                    80.08}, {62.559999999999995`, 65.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8549000000000001, 0., 0.1451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{74.44000000000001, 35.32}, {62.80000000000001, 
                    36.28}, {65.20000000000002, 24.04}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{74.44000000000001, 35.32}, {62.80000000000001, 
                    36.28}, {65.20000000000002, 24.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.92549, 0., 0.07451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{62.8, 
                    36.28}, {74.44, 35.32}, {73.72, 49.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{62.8, 36.28}, {74.44, 35.32}, {73.72, 49.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{63.04, 
                    108.28}, {73.6, 106.72}, {79.47999999999999, 117.04}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{63.04, 108.28}, {73.6, 
                    106.72}, {79.47999999999999, 117.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{79.48, 
                    117.04}, {69.04, 118.48}, {63.040000000000006`, 
                    108.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{79.48, 
                    117.04}, {69.04, 118.48}, {63.040000000000006`, 108.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.023528999999999998`, 0., 0.97647], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{63.28, 131.08}, {72.88, 131.08}, {79.72, 
                    132.52}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{63.28, 
                    131.08}, {72.88, 131.08}, {79.72, 132.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.023528999999999998`, 0., 0.97647], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{79.72, 132.52}, {70.24, 132.52}, {63.28, 
                    131.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{79.72, 
                    132.52}, {70.24, 132.52}, {63.28, 131.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{73.96000000000001, 7.}, {63.760000000000005`, 
                    8.2}, {69.64000000000001, 4.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{73.96000000000001, 7.}, {63.760000000000005`, 
                    8.2}, {69.64000000000001, 4.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5529400000000001, 0., 0.44706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{63.760000000000005`, 8.2}, {73.96000000000001, 
                    6.999999999999999}, {69.04, 14.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{63.760000000000005`, 8.2}, {73.96000000000001, 
                    6.999999999999999}, {69.04, 14.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.71765, 0., 0.28235000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{64.84, 80.08}, {76.60000000000001, 
                    78.28}, {80.32000000000001, 92.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{64.84, 80.08}, {76.60000000000001, 
                    78.28}, {80.32000000000001, 92.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.71765, 0., 0.28235000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{80.32, 92.2}, {68.55999999999999, 
                    94.24000000000001}, {64.83999999999999, 80.08}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{80.32, 92.2}, {68.55999999999999, 
                    94.24000000000001}, {64.83999999999999, 80.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.71765, 0., 0.28235000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{76.84, 23.32}, {65.2, 24.04}, {69.04, 
                    14.200000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{76.84, 
                    23.32}, {65.2, 24.04}, {69.04, 14.200000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8549000000000001, 0., 0.1451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{65.2, 24.04}, {76.84, 23.32}, {74.44, 35.32}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{65.2, 24.04}, {76.84, 23.32}, {74.44, 35.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.054902000000000006`, 0., 0.9451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{65.92, 126.76}, {75.76, 125.92}, {82.48, 
                    130.48000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{65.92, 
                    126.76}, {75.76, 125.92}, {82.48, 130.48000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.054902000000000006`, 0., 0.9451], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{82.48, 130.48000000000002`}, {72.88000000000001, 
                    131.08}, {65.92, 126.76000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{82.48, 130.48000000000002`}, {72.88000000000001, 
                    131.08}, {65.92, 126.76000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.17255, 0., 0.82745], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{66.76, 
                    4.48}, {76., 2.6800000000000006`}, {69.64, 4.}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{66.76, 4.48}, {76., 
                    2.6800000000000006`}, {69.64, 4.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5451, 0., 0.4549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{68.56, 
                    94.24000000000001}, {80.32000000000001, 92.2}, {85.12, 
                    104.56}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{68.56, 
                    94.24000000000001}, {80.32000000000001, 92.2}, {85.12, 
                    104.56}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5451, 0., 0.4549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{85.11999999999999, 104.56}, {73.6, 
                    106.72}, {68.55999999999999, 94.24000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{85.11999999999999, 104.56}, {73.6, 
                    106.72}, {68.55999999999999, 94.24000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.18431, 0., 0.8156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{69.04, 118.48}, {79.48, 
                    117.04}, {85.96000000000001, 124.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{69.04, 118.48}, {79.48, 
                    117.04}, {85.96000000000001, 124.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.18431, 0., 0.8156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{85.96000000000001, 124.48}, {75.76, 
                    125.92}, {69.04, 118.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{85.96000000000001, 124.48}, {75.76, 
                    125.92}, {69.04, 118.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5451, 0., 0.4549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{80.32, 
                    13.6}, {69.03999999999999, 14.2}, {73.96, 7.}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{80.32, 13.6}, {69.03999999999999, 
                    14.2}, {73.96, 7.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.71765, 0., 0.28235000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{69.04, 14.2}, {80.32000000000001, 13.6}, {76.84, 
                    23.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{69.04, 
                    14.2}, {80.32000000000001, 13.6}, {76.84, 23.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{69.64, 
                    4.}, {79.6, 2.6799999999999997`}, {73.96, 7.}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{69.64, 4.}, {79.6, 
                    2.6799999999999997`}, {73.96, 7.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.18431, 0., 0.8156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{79.6, 2.68}, {69.63999999999999, 4.}, {76., 
                    2.68}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{79.6, 
                    2.68}, {69.63999999999999, 4.}, {76., 2.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.011764999999999998`, 0., 0.98824], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{72.88, 131.08}, {82.47999999999999, 
                    130.48000000000002`}, {89.19999999999999, 
                    131.92000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{72.88, 
                    131.08}, {82.47999999999999, 
                    130.48000000000002`}, {89.19999999999999, 
                    131.92000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.011764999999999998`, 0., 0.98824], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{89.2, 131.92000000000002`}, {79.72, 
                    132.52}, {72.88, 131.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{89.2, 
                    131.92000000000002`}, {79.72, 132.52}, {72.88, 131.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{73.6, 
                    106.72}, {85.11999999999999, 104.56}, {90.63999999999999, 
                    114.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{73.6, 
                    106.72}, {85.11999999999999, 104.56}, {90.63999999999999, 
                    114.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{90.64, 
                    114.64}, {79.48, 117.04}, {73.6, 106.72}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{90.64, 114.64}, {79.48, 117.04}, {73.6, 106.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.8705900000000001, 0., 0.12941000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{86.67999999999999, 48.04}, {73.72, 49.}, {74.44, 
                    35.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{86.67999999999999, 48.04}, {73.72, 49.}, {74.44, 
                    35.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8705900000000001, 0., 
                    0.12941000000000003`], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{73.72, 
                    49.}, {86.68, 48.04}, {87.4, 62.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{73.72, 49.}, {86.68, 48.04}, {87.4, 62.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.8705900000000001, 0., 0.12941000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{87.4, 62.08}, {74.44, 63.64}, {73.72, 49.}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{87.4, 62.08}, {74.44, 63.64}, {73.72, 49.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{84.88, 
                    6.52}, {73.96, 7.}, {79.6, 2.6799999999999997`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{84.88, 6.52}, {73.96, 7.}, {79.6, 
                    2.6799999999999997`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5451, 0., 0.4549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{73.96000000000001, 7.}, {84.88000000000001, 
                    6.52}, {80.32000000000001, 13.6}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{73.96000000000001, 7.}, {84.88000000000001, 
                    6.52}, {80.32000000000001, 13.6}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8078400000000001, 0., 0.19216], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{74.44000000000001, 63.64}, {87.4, 
                    62.08}, {89.68, 76.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{74.44000000000001, 63.64}, {87.4, 
                    62.08}, {89.68, 76.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8078400000000001, 0., 0.19216], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{89.67999999999999, 76.11999999999999}, {76.6, 
                    78.27999999999999}, {74.44, 63.639999999999986`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{89.67999999999999, 76.11999999999999}, {76.6, 
                    78.27999999999999}, {74.44, 63.639999999999986`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8078400000000001, 0., 0.19216], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{87.4, 34.96}, {74.44, 35.32}, {76.84, 23.32}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{87.4, 34.96}, {74.44, 35.32}, {76.84, 23.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.8705900000000001, 0., 0.12941000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{74.44000000000001, 35.32}, {87.4, 
                    34.96}, {86.68, 48.04}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{74.44000000000001, 35.32}, {87.4, 
                    34.96}, {86.68, 48.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.066667, 0., 0.93333], Opacity[1.]}],
                     FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{75.76, 
                    125.92}, {85.96000000000001, 124.48}, {92.56, 129.04}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{75.76, 125.92}, {85.96000000000001, 
                    124.48}, {92.56, 129.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.066667, 0., 0.93333], Opacity[1.]}],
                     FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{92.56, 
                    129.04}, {82.48, 130.48}, {75.76, 
                    125.91999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{92.56, 
                    129.04}, {82.48, 130.48}, {75.76, 125.91999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.18431, 0., 0.8156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{76., 2.68}, {85.6, 1.36}, {79.6, 2.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{76., 2.68}, {85.6, 1.36}, {79.6, 2.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6901999999999999, 0., 0.3098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{76.6, 78.28}, {89.67999999999999, 
                    76.12}, {93.03999999999999, 89.44}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{76.6, 78.28}, {89.67999999999999, 
                    76.12}, {93.03999999999999, 89.44}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6901999999999999, 0., 0.3098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{93.04, 89.44000000000001}, {80.32000000000001, 
                    92.20000000000002}, {76.60000000000001, 
                    78.28000000000002}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{93.04, 
                    89.44000000000001}, {80.32000000000001, 
                    92.20000000000002}, {76.60000000000001, 
                    78.28000000000002}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6901999999999999, 0., 0.3098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{89.32, 23.56}, {76.83999999999999, 
                    23.32}, {80.32, 13.599999999999998`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{89.32, 23.56}, {76.83999999999999, 
                    23.32}, {80.32, 13.599999999999998`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8078400000000001, 0., 0.19216], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{76.84, 23.32}, {89.32000000000001, 
                    23.56}, {87.4, 34.96}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{76.84, 
                    23.32}, {89.32000000000001, 23.56}, {87.4, 34.96}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.20784000000000002`, 0., 0.7921599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{79.48, 117.04}, {90.64, 114.64}, {96.76, 
                    122.08000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{79.48, 
                    117.04}, {90.64, 114.64}, {96.76, 122.08000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.20784000000000002`, 0., 
                    0.7921599999999999], Opacity[1.]}], FilledCurveBox[{{{0, 
                    2, 0}, {0, 1, 0}}}, {{{96.76, 
                    122.08}, {85.96000000000001, 124.48}, {79.48, 
                    117.03999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{96.76, 
                    122.08}, {85.96000000000001, 124.48}, {79.48, 
                    117.03999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{79.6, 
                    2.68}, {90.16, 2.44}, {84.88, 6.52}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{79.6, 2.68}, {90.16, 2.44}, {84.88, 6.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.20784000000000002`, 0., 0.7921599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{90.16, 2.44}, {79.6, 2.68}, {85.6, 
                    1.3599999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{90.16, 
                    2.44}, {79.6, 2.68}, {85.6, 1.3599999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53725, 0., 0.46275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{80.32, 
                    92.2}, {93.03999999999999, 89.44}, {97.47999999999999, 
                    101.32000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{80.32, 
                    92.2}, {93.03999999999999, 89.44}, {97.47999999999999, 
                    101.32000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53725, 0., 0.46275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.48, 
                    101.32}, {85.12, 
                    104.55999999999999`}, {80.32000000000001, 
                    92.19999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.48, 
                    101.32}, {85.12, 
                    104.55999999999999`}, {80.32000000000001, 
                    92.19999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53725, 0., 0.46275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{92.56, 
                    14.2}, {80.32000000000001, 13.6}, {84.88, 6.52}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{92.56, 14.2}, {80.32000000000001, 
                    13.6}, {84.88, 6.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6901999999999999, 0., 0.3098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{80.32, 13.6}, {92.55999999999999, 14.2}, {89.32, 
                    23.560000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{80.32, 
                    13.6}, {92.55999999999999, 14.2}, {89.32, 
                    23.560000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.023528999999999998`, 0., 0.97647], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{82.48, 130.48000000000002`}, {92.56, 
                    129.04000000000002`}, {99.04, 130.60000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{82.48, 130.48000000000002`}, {92.56, 
                    129.04000000000002`}, {99.04, 130.60000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.023528999999999998`, 0., 0.97647], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{99.04, 130.6}, {89.2, 131.92}, {82.48, 
                    130.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{99.04, 
                    130.6}, {89.2, 131.92}, {82.48, 130.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.38431000000000004`, 0., 0.6156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{96.76, 7.359999999999999}, {84.88000000000001, 
                    6.52}, {90.16000000000001, 2.4399999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{96.76, 
                    7.359999999999999}, {84.88000000000001, 
                    6.52}, {90.16000000000001, 2.4399999999999995`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53725, 0., 0.46275], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{84.88, 
                    6.52}, {96.75999999999999, 7.359999999999999}, {92.56, 
                    14.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{84.88, 
                    6.52}, {96.75999999999999, 7.359999999999999}, {92.56, 
                    14.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.38431000000000004`, 0., 
                    0.6156900000000001], Opacity[1.]}], FilledCurveBox[{{{0, 
                    2, 0}, {0, 1, 0}}}, {{{85.11999999999999, 
                    104.56}, {97.47999999999999, 
                    101.32000000000001`}, {102.63999999999999`, 111.04}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{85.11999999999999, 
                    104.56}, {97.47999999999999, 
                    101.32000000000001`}, {102.63999999999999`, 111.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.38431000000000004`, 0., 0.6156900000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{102.64, 111.04}, {90.64, 114.64}, {85.12, 
                    104.56}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{102.64, 111.04}, {90.64, 114.64}, {85.12, 
                    104.56}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.20784000000000002`, 0., 
                    0.7921599999999999], Opacity[1.]}], FilledCurveBox[{{{0, 
                    2, 0}, {0, 1, 0}}}, {{{85.6, 1.36}, {95.91999999999999, 
                    1.12}, {90.16, 2.4400000000000004`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{85.6, 1.36}, {95.91999999999999, 1.12}, {90.16, 
                    2.4400000000000004`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.10196000000000001`, 0., 0.8980400000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{85.96000000000001, 124.48}, {96.76, 
                    122.08}, {103.12, 126.52000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{85.96000000000001, 124.48}, {96.76, 
                    122.08}, {103.12, 126.52000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.10196000000000001`, 0., 0.8980400000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{103.11999999999999`, 
                    126.52}, {92.55999999999999, 129.04}, {85.96, 
                    124.47999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{103.11999999999999`, 
                    126.52}, {92.55999999999999, 129.04}, {85.96, 
                    124.47999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8, 0., 0.2], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{100.84, 
                    47.68}, {86.68, 48.04}, {87.4, 34.96}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{100.84, 47.68}, {86.68, 48.04}, {87.4, 34.96}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8, 0., 0.2], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{86.67999999999999, 48.04}, {100.83999999999999`, 
                    47.68}, {101.55999999999999`, 60.519999999999996`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{86.67999999999999, 
                    48.04}, {100.83999999999999`, 
                    47.68}, {101.55999999999999`, 60.519999999999996`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8, 0., 0.2], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{101.56, 
                    60.52}, {87.4, 62.080000000000005`}, {86.68, 
                    48.040000000000006`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.56, 60.52}, {87.4, 
                    62.080000000000005`}, {86.68, 48.040000000000006`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{101.32, 
                    35.56}, {87.39999999999999, 34.96}, {89.32, 
                    23.560000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.32, 35.56}, {87.39999999999999, 
                    34.96}, {89.32, 23.560000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.8, 0., 0.2], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{87.4, 
                    34.96}, {101.32000000000001`, 35.56}, {100.84, 47.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{87.4, 34.96}, {101.32000000000001`, 
                    35.56}, {100.84, 47.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{87.4, 
                    62.08}, {101.56, 
                    60.519999999999996`}, {103.60000000000001`, 73.48}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{87.4, 62.08}, {101.56, 
                    60.519999999999996`}, {103.60000000000001`, 73.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.6, 
                    73.48}, {89.67999999999999, 76.12}, {87.39999999999999, 
                    62.080000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.6, 
                    73.48}, {89.67999999999999, 76.12}, {87.39999999999999, 
                    62.080000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.65098, 0., 0.34902], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103., 
                    25.}, {89.32, 23.56}, {92.56, 14.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{103., 25.}, {89.32, 23.56}, {92.56, 14.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7451, 0., 0.2549], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{89.32, 
                    23.56}, {103., 25.}, {101.32, 35.56}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{89.32, 23.56}, {103., 25.}, {101.32, 35.56}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.65098, 0., 0.34902], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{89.67999999999999, 76.11999999999999}, {103.6, 
                    73.47999999999999}, {106.6, 85.83999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{89.67999999999999, 
                    76.11999999999999}, {103.6, 73.47999999999999}, {106.6, 
                    85.83999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.65098, 0., 0.34902], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{106.6, 
                    85.84}, {93.03999999999999, 89.44}, {89.67999999999999, 
                    76.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{106.6, 
                    85.84}, {93.03999999999999, 89.44}, {89.67999999999999, 
                    76.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.38431000000000004`, 0., 
                    0.6156900000000001], Opacity[1.]}], FilledCurveBox[{{{0, 
                    2, 0}, {0, 1, 0}}}, {{{90.16, 2.44}, {101.56, 
                    3.2800000000000002`}, {96.75999999999999, 
                    7.359999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{90.16, 
                    2.44}, {101.56, 3.2800000000000002`}, {96.75999999999999, 
                    7.359999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.24706000000000003`, 0., 0.75294], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.56, 3.2800000000000002`}, {90.16, 
                    2.4400000000000004`}, {95.92, 1.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.56, 3.2800000000000002`}, {90.16, 
                    2.4400000000000004`}, {95.92, 1.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.24706000000000003`, 0., 0.75294], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{90.64, 114.64}, {102.64, 111.04}, {108.28, 
                    118.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{90.64, 
                    114.64}, {102.64, 111.04}, {108.28, 118.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.24706000000000003`, 0., 0.75294], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{108.28, 118.24000000000001`}, {96.76, 
                    122.08000000000001`}, {90.64, 114.64000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{108.28, 118.24000000000001`}, {96.76, 
                    122.08000000000001`}, {90.64, 114.64000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.06274500000000001, 0., 0.93725], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{92.56, 129.04}, {103.12, 
                    126.52}, {109.24000000000001`, 128.07999999999998`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{92.56, 129.04}, {103.12, 
                    126.52}, {109.24000000000001`, 128.07999999999998`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.06274500000000001, 0., 0.93725], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{109.24000000000001`, 128.08}, {99.04, 
                    130.60000000000002`}, {92.56, 129.04000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{109.24000000000001`, 128.08}, {99.04, 
                    130.60000000000002`}, {92.56, 129.04000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{105.76, 16.24}, {92.56, 14.2}, {96.76, 
                    7.359999999999998}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{105.76, 16.24}, {92.56, 14.2}, {96.76, 
                    7.359999999999998}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.65098, 0., 0.34902], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{92.56, 
                    14.2}, {105.76, 16.24}, {103., 25.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{92.56, 14.2}, {105.76, 16.24}, {103., 25.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{93.04, 89.44000000000001}, {106.60000000000001`, 
                    85.84000000000002}, {110.56, 96.76}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{93.04, 89.44000000000001}, {106.60000000000001`, 
                    85.84000000000002}, {110.56, 96.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{110.56, 96.76}, {97.48, 
                    101.32000000000001`}, {93.04, 89.44000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{110.56, 96.76}, {97.48, 
                    101.32000000000001`}, {93.04, 89.44000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.24706000000000003`, 0., 0.75294], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{95.92, 1.12}, {106.84, 2.08}, {101.56, 
                    3.2800000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{95.92, 
                    1.12}, {106.84, 2.08}, {101.56, 3.2800000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.40392000000000006`, 0., 0.5960799999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{109.36, 10.}, {96.76, 
                    7.359999999999999}, {101.56, 3.2800000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{109.36, 10.}, {96.76, 
                    7.359999999999999}, {101.56, 3.2800000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{96.76, 7.359999999999999}, {109.36, 
                    10.}, {105.76, 16.240000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{96.76, 7.359999999999999}, {109.36, 
                    10.}, {105.76, 16.240000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.15294000000000005`, 0., 0.84706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{96.76, 122.08}, {108.28, 118.24}, {114.16, 
                    122.67999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{96.76, 
                    122.08}, {108.28, 118.24}, {114.16, 122.67999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.15294000000000005`, 0., 0.84706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{114.16, 122.67999999999999`}, {103.12, 
                    126.52}, {96.75999999999999, 122.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{114.16, 122.67999999999999`}, {103.12, 
                    126.52}, {96.75999999999999, 122.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.40392000000000006`, 0., 0.5960799999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{97.48, 101.32}, {110.56, 
                    96.75999999999999}, {115.24000000000001`, 
                    105.75999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.48, 
                    101.32}, {110.56, 
                    96.75999999999999}, {115.24000000000001`, 
                    105.75999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.40392000000000006`, 0., 0.5960799999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{115.24000000000001`, 
                    105.76}, {102.64000000000001`, 
                    111.04}, {97.48000000000002, 101.32000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{115.24000000000001`, 
                    105.76}, {102.64000000000001`, 
                    111.04}, {97.48000000000002, 101.32000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.10196000000000001`, 0., 0.8980400000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{99.04, 130.6}, {109.24000000000001`, 
                    128.07999999999998`}, {114.88000000000001`, 126.88}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{99.04, 130.6}, {109.24000000000001`, 
                    128.07999999999998`}, {114.88000000000001`, 126.88}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.10196000000000001`, 0., 0.8980400000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{114.88, 126.88}, {105.03999999999999`, 
                    129.16}, {99.03999999999999, 130.6}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{114.88, 126.88}, {105.03999999999999`, 
                    129.16}, {99.03999999999999, 130.6}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7215699999999999, 0., 0.27843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{115.6, 47.92}, {100.83999999999999`, 
                    47.68}, {101.32, 35.56}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{115.6, 
                    47.92}, {100.83999999999999`, 47.68}, {101.32, 35.56}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7215699999999999, 0., 0.27843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{116.32, 59.08}, {101.55999999999999`, 
                    60.519999999999996`}, {100.83999999999999`, 47.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{116.32, 59.08}, {101.55999999999999`, 
                    60.519999999999996`}, {100.83999999999999`, 47.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7215699999999999, 0., 0.27843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{100.84, 47.68}, {115.60000000000001`, 
                    47.92}, {116.32000000000001`, 59.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{100.84, 47.68}, {115.60000000000001`, 
                    47.92}, {116.32000000000001`, 59.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6823499999999999, 0., 0.31765], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{115.96000000000001`, 
                    37.36}, {101.32000000000001`, 35.56}, {103., 25.}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{115.96000000000001`, 
                    37.36}, {101.32000000000001`, 35.56}, {103., 25.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.7215699999999999, 0., 0.27843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.32, 35.56}, {115.96, 37.36}, {115.6, 
                    47.92}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.32, 35.56}, {115.96, 37.36}, {115.6, 47.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29804, 0., 0.7019599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{113.67999999999999`, 
                    6.159999999999999}, {101.55999999999999`, 
                    3.2799999999999994`}, {106.83999999999999`, 
                    2.079999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{113.67999999999999`, 
                    6.159999999999999}, {101.55999999999999`, 
                    3.2799999999999994`}, {106.83999999999999`, 
                    2.079999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.40392000000000006`, 0., 0.5960799999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.56, 3.2800000000000002`}, {113.68, 
                    6.16}, {109.36, 10.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.56, 3.2800000000000002`}, {113.68, 
                    6.16}, {109.36, 10.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6823499999999999, 0., 0.31765], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.56, 60.52}, {116.32000000000001`, 
                    59.080000000000005`}, {118., 70.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{101.56, 60.52}, {116.32000000000001`, 
                    59.080000000000005`}, {118., 70.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6823499999999999, 0., 0.31765], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{118., 70.36}, {103.6, 73.48}, {101.56, 
                    60.519999999999996`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{118., 
                    70.36}, {103.6, 73.48}, {101.56, 60.519999999999996`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29804, 0., 0.7019599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{102.64, 111.04}, {115.24, 105.76}, {120.28, 
                    112.60000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{102.64, 111.04}, {115.24, 105.76}, {120.28, 
                    112.60000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29804, 0., 0.7019599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{120.28, 112.6}, {108.28, 118.24}, {102.64, 
                    111.03999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{120.28, 112.6}, {108.28, 118.24}, {102.64, 
                    111.03999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61176, 0., 0.38824], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{117.28, 
                    28.12}, {103., 25.}, {105.76, 16.240000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{117.28, 28.12}, {103., 25.}, {105.76, 
                    16.240000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.6823499999999999, 0., 0.31765], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{103., 25.}, {117.28, 
                    28.12}, {115.96000000000001`, 37.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{103., 25.}, {117.28, 
                    28.12}, {115.96000000000001`, 37.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.12157000000000001`, 0., 0.87843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{103.11999999999999`, 126.52}, {114.16, 
                    122.67999999999999`}, {119.79999999999998`, 124.24}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{103.11999999999999`, 126.52}, {114.16, 
                    122.67999999999999`}, {119.79999999999998`, 124.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.12157000000000001`, 0., 0.87843], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{119.8, 124.24000000000001`}, {109.24, 
                    128.08}, {103.12, 126.52000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{119.8, 124.24000000000001`}, {109.24, 
                    128.08}, {103.12, 126.52000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61176, 0., 0.38824], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.6, 
                    73.48}, {118., 70.36}, {120.63999999999999`, 81.16}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{103.6, 73.48}, {118., 
                    70.36}, {120.63999999999999`, 81.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61176, 0., 0.38824], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{120.64, 
                    81.16}, {106.6, 85.84}, {103.6, 73.47999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{120.64, 81.16}, {106.6, 85.84}, {103.6, 
                    73.47999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{119.44000000000001`, 
                    20.439999999999998`}, {105.76000000000002`, 
                    16.24}, {109.36000000000001`, 9.999999999999998}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{119.44000000000001`, 
                    20.439999999999998`}, {105.76000000000002`, 
                    16.24}, {109.36000000000001`, 9.999999999999998}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61176, 0., 0.38824], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{105.76, 
                    16.24}, {119.44, 20.439999999999998`}, {117.28, 
                    28.119999999999997`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{105.76, 16.24}, {119.44, 
                    20.439999999999998`}, {117.28, 28.119999999999997`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{106.6, 
                    85.84}, {120.63999999999999`, 81.16}, {124., 90.76}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{106.6, 85.84}, {120.63999999999999`, 
                    81.16}, {124., 90.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{124., 
                    90.76}, {110.56, 96.76}, {106.6, 85.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{124., 90.76}, {110.56, 96.76}, {106.6, 85.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29804, 0., 0.7019599999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{106.84, 2.08}, {118.36, 4.96}, {113.68, 
                    6.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{106.84, 2.08}, {118.36, 4.96}, {113.68, 6.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.22353, 0., 0.77647], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{108.28, 
                    118.24000000000001`}, {120.28, 
                    112.60000000000001`}, {125.44, 116.68}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{108.28, 118.24000000000001`}, {120.28, 
                    112.60000000000001`}, {125.44, 116.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.22353, 0., 0.77647], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{125.44000000000001`, 
                    116.67999999999999`}, {114.16000000000001`, 
                    122.67999999999999`}, {108.28000000000002`, 118.24}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{125.44000000000001`, 
                    116.67999999999999`}, {114.16000000000001`, 
                    122.67999999999999`}, {108.28000000000002`, 118.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.15294000000000005`, 0., 0.84706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{125.08, 123.04}, {114.88, 
                    126.88000000000001`}, {109.24, 128.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{125.08, 123.04}, {114.88, 
                    126.88000000000001`}, {109.24, 128.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.15294000000000005`, 0., 0.84706], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{109.24000000000001`, 
                    128.08}, {119.80000000000001`, 
                    124.24000000000001`}, {125.08000000000001`, 123.04}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{109.24000000000001`, 
                    128.08}, {119.80000000000001`, 
                    124.24000000000001`}, {125.08000000000001`, 123.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.4313700000000001, 0., 0.5686300000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{122.44000000000001`, 
                    14.8}, {109.36000000000001`, 10.}, {113.68, 
                    6.160000000000002}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{122.44000000000001`, 
                    14.8}, {109.36000000000001`, 10.}, {113.68, 
                    6.160000000000002}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{109.36, 
                    10.}, {122.44, 14.8}, {119.44, 20.439999999999998`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{109.36, 10.}, {122.44, 14.8}, {119.44, 
                    20.439999999999998`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.4313700000000001, 0., 0.5686300000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{110.56, 96.76}, {124., 
                    90.76}, {127.96000000000001`, 98.68}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{110.56, 96.76}, {124., 
                    90.76}, {127.96000000000001`, 98.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.4313700000000001, 0., 0.5686300000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{127.96000000000001`, 
                    98.67999999999999}, {115.24000000000001`, 
                    105.75999999999999`}, {110.56, 96.75999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{127.96000000000001`, 
                    98.67999999999999}, {115.24000000000001`, 
                    105.75999999999999`}, {110.56, 96.75999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{125.92, 
                    11.44}, {113.68, 6.159999999999999}, {118.36, 
                    4.959999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{125.92, 11.44}, {113.68, 
                    6.159999999999999}, {118.36, 4.959999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[
                    0.4313700000000001, 0., 0.5686300000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{113.67999999999999`, 
                    6.159999999999999}, {125.91999999999999`, 
                    11.44}, {122.44, 14.799999999999997`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{113.67999999999999`, 
                    6.159999999999999}, {125.91999999999999`, 
                    11.44}, {122.44, 14.799999999999997`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.19608, 0., 0.8039200000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{114.16, 122.67999999999999`}, {125.44, 
                    116.67999999999999`}, {130.48, 118.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{114.16, 122.67999999999999`}, {125.44, 
                    116.67999999999999`}, {130.48, 118.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.19608, 0., 0.8039200000000001], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{130.48000000000002`, 
                    118.24000000000001`}, {119.80000000000001`, 
                    124.24000000000001`}, {114.16000000000003`, 122.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{130.48000000000002`, 
                    118.24000000000001`}, {119.80000000000001`, 
                    124.24000000000001`}, {114.16000000000003`, 122.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{115.24000000000001`, 
                    105.76}, {127.96000000000001`, 98.68}, {132.16, 
                    104.68}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{115.24000000000001`, 
                    105.76}, {127.96000000000001`, 98.68}, {132.16, 104.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{132.16, 
                    104.67999999999999`}, {120.28, 112.6}, {115.24, 
                    105.75999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{132.16, 104.67999999999999`}, {120.28, 
                    112.6}, {115.24, 105.75999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.64314, 0., 0.35686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.12, 
                    49.}, {115.60000000000001`, 47.92}, {115.96000000000001`, 
                    37.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{130.12, 49.}, {115.60000000000001`, 
                    47.92}, {115.96000000000001`, 37.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.64314, 0., 0.35686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{115.6, 
                    47.92}, {130.12, 49.}, {130.72, 57.88}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{115.6, 47.92}, {130.12, 49.}, {130.72, 57.88}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.64314, 0., 0.35686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.72, 
                    57.879999999999995`}, {116.32, 59.08}, {115.6, 
                    47.919999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{130.72, 57.879999999999995`}, {116.32, 
                    59.08}, {115.6, 47.919999999999995`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61961, 0., 0.38039], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.36, 
                    40.48}, {115.96000000000001`, 
                    37.36}, {117.28000000000002`, 28.119999999999997`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{130.36, 40.48}, {115.96000000000001`, 
                    37.36}, {117.28000000000002`, 28.119999999999997`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.64314, 0., 0.35686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{115.96000000000001`, 37.36}, {130.36, 
                    40.48}, {130.12, 49.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{115.96000000000001`, 37.36}, {130.36, 
                    40.48}, {130.12, 49.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61961, 0., 0.38039], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{116.32, 
                    59.08}, {130.72, 57.879999999999995`}, {132.04, 67.}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{116.32, 59.08}, {130.72, 
                    57.879999999999995`}, {132.04, 67.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61961, 0., 0.38039], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{132.04, 
                    67.}, {118., 70.36}, {116.32, 59.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{132.04, 67.}, {118., 70.36}, {116.32, 59.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.57255, 0., 0.42745000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{131.32000000000002`, 
                    33.04}, {117.28000000000003`, 
                    28.119999999999997`}, {119.44000000000003`, 
                    20.439999999999998`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{131.32000000000002`, 
                    33.04}, {117.28000000000003`, 
                    28.119999999999997`}, {119.44000000000003`, 
                    20.439999999999998`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.61961, 0., 0.38039], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{117.28, 
                    28.12}, {131.32, 33.04}, {130.36, 
                    40.480000000000004`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{117.28, 28.12}, {131.32, 33.04}, {130.36, 
                    40.480000000000004`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.57255, 0., 0.42745000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{118., 70.36}, {132.04, 67.}, {134.2, 75.64}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{118., 70.36}, {132.04, 67.}, {134.2, 75.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.57255, 0., 0.42745000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{134.2, 75.64}, {120.63999999999999`, 
                    81.16}, {117.99999999999999`, 70.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{134.2, 75.64}, {120.63999999999999`, 
                    81.16}, {117.99999999999999`, 70.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29412000000000005`, 0., 0.70588], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{129.88000000000002`, 
                    10.239999999999998`}, {118.36000000000003`, 
                    4.959999999999998}, {123.16000000000003`, 
                    6.2799999999999985`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{129.88000000000002`, 
                    10.239999999999998`}, {118.36000000000003`, 
                    4.959999999999998}, {123.16000000000003`, 
                    6.2799999999999985`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{118.36, 
                    4.96}, {129.88, 10.24}, {125.92, 11.440000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{118.36, 4.96}, {129.88, 10.24}, {125.92, 
                    11.440000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51765, 0., 0.48235000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{132.88000000000002`, 
                    26.8}, {119.44000000000003`, 
                    20.44}, {122.44000000000003`, 14.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{132.88000000000002`, 
                    26.8}, {119.44000000000003`, 
                    20.44}, {122.44000000000003`, 14.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.57255, 0., 0.42745000000000005`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{119.44000000000001`, 
                    20.439999999999998`}, {132.88000000000002`, 
                    26.799999999999997`}, {131.32000000000002`, 33.04}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{119.44000000000001`, 
                    20.439999999999998`}, {132.88000000000002`, 
                    26.799999999999997`}, {131.32000000000002`, 33.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.22353, 0., 0.77647], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{135.16, 
                    117.4}, {125.08, 123.04}, {119.8, 
                    124.24000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{135.16, 117.4}, {125.08, 123.04}, {119.8, 
                    124.24000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.22353, 0., 0.77647], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{119.8, 
                    124.24000000000001`}, {130.48, 
                    118.24000000000001`}, {135.16, 117.4}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{119.8, 
                    124.24000000000001`}, {130.48, 
                    118.24000000000001`}, {135.16, 117.4}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29412000000000005`, 0., 0.70588], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{120.28, 112.6}, {132.16, 
                    104.67999999999999`}, {136.48, 108.52}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{120.28, 112.6}, {132.16, 
                    104.67999999999999`}, {136.48, 108.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29412000000000005`, 0., 0.70588], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{136.48000000000002`, 
                    108.52}, {125.44000000000003`, 
                    116.67999999999999`}, {120.28000000000002`, 112.6}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{136.48000000000002`, 
                    108.52}, {125.44000000000003`, 
                    116.67999999999999`}, {120.28000000000002`, 112.6}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51765, 0., 0.48235000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{120.64, 81.16}, {134.2, 75.64}, {136.72, 
                    83.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{120.64, 81.16}, {134.2, 75.64}, {136.72, 83.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51765, 0., 0.48235000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{136.72, 83.32}, {124., 
                    90.75999999999999}, {120.64, 81.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{136.72, 83.32}, {124., 
                    90.75999999999999}, {120.64, 81.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.4549, 0., 0.5451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{135.16, 
                    22.24}, {122.44, 14.799999999999997`}, {125.92, 
                    11.439999999999998`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{135.16, 22.24}, {122.44, 
                    14.799999999999997`}, {125.92, 11.439999999999998`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51765, 0., 0.48235000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{122.44000000000001`, 
                    14.8}, {135.16000000000003`, 
                    22.240000000000002`}, {132.88000000000002`, 26.8}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{122.44000000000001`, 
                    14.8}, {135.16000000000003`, 
                    22.240000000000002`}, {132.88000000000002`, 26.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29412000000000005`, 0., 0.70588], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{123.16, 6.28}, {133.96, 11.32}, {129.88, 
                    10.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{123.16, 6.28}, {133.96, 11.32}, {129.88, 10.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.4549, 0., 0.5451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{124., 
                    90.76}, {136.72, 83.32000000000001}, {139.72, 
                    89.80000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{124., 
                    90.76}, {136.72, 83.32000000000001}, {139.72, 
                    89.80000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.4549, 0., 0.5451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{139.72, 
                    89.8}, {127.96, 98.67999999999999}, {124., 
                    90.75999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{139.72, 89.8}, {127.96, 
                    98.67999999999999}, {124., 90.75999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.27451000000000003`, 0., 0.72549], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{125.44000000000001`, 
                    116.67999999999999`}, {136.48000000000002`, 
                    108.52}, {140.68, 110.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{125.44000000000001`, 
                    116.67999999999999`}, {136.48000000000002`, 
                    108.52}, {140.68, 110.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.27451000000000003`, 0., 0.72549], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{140.68, 110.08}, {130.48000000000002`, 
                    118.24}, {125.44000000000001`, 116.67999999999999`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{140.68, 110.08}, {130.48000000000002`, 
                    118.24}, {125.44000000000001`, 116.67999999999999`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.39608000000000004`, 0., 0.60392], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{137.8, 19.36}, {125.92000000000002`, 
                    11.44}, {129.88000000000002`, 10.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{137.8, 19.36}, {125.92000000000002`, 
                    11.44}, {129.88000000000002`, 10.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.4549, 0., 0.5451], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{125.92, 
                    11.44}, {137.8, 19.36}, {135.16, 22.240000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{125.92, 11.44}, {137.8, 19.36}, {135.16, 
                    22.240000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.39608000000000004`, 0., 0.60392], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{127.96000000000001`, 
                    98.67999999999999}, {139.72, 89.8}, {142.96, 94.72}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{127.96000000000001`, 
                    98.67999999999999}, {139.72, 89.8}, {142.96, 94.72}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.39608000000000004`, 0., 0.60392], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{142.96, 94.72}, {132.16, 
                    104.68}, {127.96000000000001`, 98.67999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{142.96, 94.72}, {132.16, 
                    104.68}, {127.96000000000001`, 98.67999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{140.8, 
                    18.279999999999998`}, {129.88000000000002`, 
                    10.239999999999998`}, {133.96, 11.319999999999997`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{140.8, 
                    18.279999999999998`}, {129.88000000000002`, 
                    10.239999999999998`}, {133.96, 11.319999999999997`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.39608000000000004`, 0., 0.60392], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{129.88000000000002`, 
                    10.239999999999998`}, {140.8, 
                    18.279999999999998`}, {137.8, 19.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{129.88000000000002`, 
                    10.239999999999998`}, {140.8, 
                    18.279999999999998`}, {137.8, 19.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.58039, 0., 0.41961000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.32000000000002`, 
                    50.8}, {130.12000000000003`, 49.}, {130.36, 40.48}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{143.32000000000002`, 
                    50.8}, {130.12000000000003`, 49.}, {130.36, 40.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.58039, 0., 0.41961000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{130.12, 49.}, {143.32, 50.8}, {143.8, 57.04}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{130.12, 49.}, {143.32, 50.8}, {143.8, 57.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.58039, 0., 0.41961000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.8, 57.04}, {130.72, 57.88}, {130.12, 
                    49.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{143.8, 
                    57.04}, {130.72, 57.88}, {130.12, 49.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.56471, 0., 0.43529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.32000000000002`, 44.92}, {130.36, 
                    40.480000000000004`}, {131.32000000000002`, 33.04}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{143.32000000000002`, 44.92}, {130.36, 
                    40.480000000000004`}, {131.32000000000002`, 33.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.58039, 0., 0.41961000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{130.36, 40.48}, {143.32000000000002`, 
                    44.919999999999995`}, {143.32000000000002`, 50.8}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{130.36, 40.48}, {143.32000000000002`, 
                    44.919999999999995`}, {143.32000000000002`, 50.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29412000000000005`, 0., 0.70588], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{144.64, 109.36}, {135.16, 117.4}, {130.48, 
                    118.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{144.64, 109.36}, {135.16, 117.4}, {130.48, 
                    118.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.29412000000000005`, 0., 0.70588], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{130.48000000000002`, 
                    118.24000000000001`}, {140.68, 
                    110.08000000000001`}, {144.64000000000001`, 
                    109.36000000000001`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{130.48000000000002`, 
                    118.24000000000001`}, {140.68, 
                    110.08000000000001`}, {144.64000000000001`, 
                    109.36000000000001`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.56471, 0., 0.43529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.72, 
                    57.879999999999995`}, {143.8, 
                    57.03999999999999}, {144.64, 63.39999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{130.72, 57.879999999999995`}, {143.8, 
                    57.03999999999999}, {144.64, 63.39999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.56471, 0., 0.43529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{144.64, 
                    63.4}, {132.04, 67.}, {130.72, 57.879999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{144.64, 63.4}, {132.04, 67.}, {130.72, 
                    57.879999999999995`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.54118, 0., 0.45882000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.92000000000002`, 
                    39.760000000000005`}, {131.32000000000002`, 
                    33.040000000000006`}, {132.88000000000002`, 
                    26.800000000000004`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.92000000000002`, 
                    39.760000000000005`}, {131.32000000000002`, 
                    33.040000000000006`}, {132.88000000000002`, 
                    26.800000000000004`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.56471, 0., 0.43529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{131.32000000000002`, 
                    33.04}, {143.92000000000002`, 
                    39.76}, {143.32000000000002`, 44.92}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{131.32000000000002`, 
                    33.04}, {143.92000000000002`, 
                    39.76}, {143.32000000000002`, 44.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.54118, 0., 0.45882000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{132.04, 67.}, {144.64, 
                    63.4}, {145.95999999999998`, 69.4}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{132.04, 67.}, {144.64, 
                    63.4}, {145.95999999999998`, 69.4}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.54118, 0., 0.45882000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{145.96, 69.4}, {134.20000000000002`, 
                    75.64}, {132.04000000000002`, 67.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{145.96, 69.4}, {134.20000000000002`, 
                    75.64}, {132.04000000000002`, 67.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{132.16, 
                    104.67999999999999`}, {142.96, 94.72}, {146.32, 
                    97.96}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{132.16, 104.67999999999999`}, {142.96, 
                    94.72}, {146.32, 97.96}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{146.32000000000002`, 
                    97.96000000000001}, {136.48000000000002`, 
                    108.52000000000001`}, {132.16000000000003`, 104.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{146.32000000000002`, 
                    97.96000000000001}, {136.48000000000002`, 
                    108.52000000000001`}, {132.16000000000003`, 104.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51373, 0., 0.48627000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{145., 35.32}, {132.88, 26.8}, {135.16, 
                    22.240000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{145., 
                    35.32}, {132.88, 26.8}, {135.16, 22.240000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.54118, 0., 0.45882000000000006`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{132.88000000000002`, 
                    26.8}, {145.00000000000003`, 
                    35.32}, {143.92000000000002`, 39.760000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{132.88000000000002`, 
                    26.8}, {145.00000000000003`, 
                    35.32}, {143.92000000000002`, 39.760000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{144.04, 
                    19.}, {133.95999999999998`, 11.32}, {138.04, 14.32}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{144.04, 19.}, {133.95999999999998`, 
                    11.32}, {138.04, 14.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{133.96, 
                    11.32}, {144.04000000000002`, 19.}, {140.8, 18.28}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{133.96, 11.32}, {144.04000000000002`, 
                    19.}, {140.8, 18.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51373, 0., 0.48627000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{134.2, 75.64}, {145.95999999999998`, 
                    69.4}, {147.76, 74.68}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{134.2, 
                    75.64}, {145.95999999999998`, 69.4}, {147.76, 74.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51373, 0., 0.48627000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{147.76, 74.67999999999999}, {136.72, 
                    83.32}, {134.2, 75.63999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{147.76, 74.67999999999999}, {136.72, 
                    83.32}, {134.2, 75.63999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47451000000000004`, 0., 0.52549], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{146.44, 32.08}, {135.16, 22.24}, {137.8, 
                    19.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{146.44, 32.08}, {135.16, 22.24}, {137.8, 19.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.51373, 0., 0.48627000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{135.16, 22.24}, {146.44, 32.08}, {145., 
                    35.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{135.16, 22.24}, {146.44, 32.08}, {145., 35.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{148.12, 
                    106.48}, {139.24, 114.04}, {135.16, 117.4}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{148.12, 106.48}, {139.24, 114.04}, {135.16, 
                    117.4}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.34902, 0., 0.65098], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{135.16, 
                    117.4}, {144.64, 109.36000000000001`}, {148.12, 
                    106.48}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{135.16, 117.4}, {144.64, 
                    109.36000000000001`}, {148.12, 106.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{136.48000000000002`, 
                    108.52}, {146.32000000000002`, 97.96}, {149.68, 
                    99.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{136.48000000000002`, 
                    108.52}, {146.32000000000002`, 97.96}, {149.68, 99.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{149.68, 
                    99.28}, {140.68, 110.08}, {136.48000000000002`, 
                    108.52}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{149.68, 99.28}, {140.68, 
                    110.08}, {136.48000000000002`, 108.52}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47451000000000004`, 0., 0.52549], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{136.72, 83.32}, {147.76, 
                    74.67999999999999}, {149.8, 79.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{136.72, 83.32}, {147.76, 
                    74.67999999999999}, {149.8, 79.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47451000000000004`, 0., 0.52549], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{149.8, 79.36}, {139.72, 89.8}, {136.72, 
                    83.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{149.8, 
                    79.36}, {139.72, 89.8}, {136.72, 83.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.44314, 0., 0.55686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{148.23999999999998`, 
                    29.919999999999998`}, {137.79999999999998`, 
                    19.36}, {140.79999999999998`, 18.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{148.23999999999998`, 
                    29.919999999999998`}, {137.79999999999998`, 
                    19.36}, {140.79999999999998`, 18.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47451000000000004`, 0., 0.52549], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{137.8, 19.36}, {148.24, 29.92}, {146.44, 
                    32.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{137.8, 
                    19.36}, {148.24, 29.92}, {146.44, 32.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.35294, 0., 0.64706], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{138.04, 
                    14.32}, {147.28, 21.4}, {144.04, 19.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{138.04, 14.32}, {147.28, 21.4}, {144.04, 19.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.44314, 0., 0.55686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{139.72, 
                    89.8}, {149.8, 79.36}, {152.08, 82.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{139.72, 89.8}, {149.8, 79.36}, {152.08, 82.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.44314, 0., 0.55686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{152.08, 
                    82.84}, {142.96, 94.72}, {139.72, 89.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{152.08, 82.84}, {142.96, 94.72}, {139.72, 89.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{152.68, 
                    98.8}, {144.64000000000001`, 109.36}, {140.68, 
                    110.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{152.68, 98.8}, {144.64000000000001`, 
                    109.36}, {140.68, 110.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.36471, 0., 0.63529], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{140.68, 
                    110.08}, {149.68, 99.28}, {152.68, 98.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{140.68, 110.08}, {149.68, 99.28}, {152.68, 
                    98.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.42745000000000005`, 0., 0.57255], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{150.28, 29.08}, {140.8, 
                    18.279999999999998`}, {144.04, 19.}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{150.28, 29.08}, {140.8, 
                    18.279999999999998`}, {144.04, 19.}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.44314, 0., 0.55686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{140.8, 
                    18.279999999999998`}, {150.28, 29.08}, {148.24, 
                    29.919999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{140.8, 
                    18.279999999999998`}, {150.28, 29.08}, {148.24, 
                    29.919999999999995`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.42745000000000005`, 0., 0.57255], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{142.96, 94.72}, {152.08, 82.84}, {154.24, 
                    85.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{142.96, 94.72}, {152.08, 82.84}, {154.24, 
                    85.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.42745000000000005`, 0., 0.57255], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.23999999999998`, 
                    85.24000000000001}, {146.32, 
                    97.96000000000001}, {142.95999999999998`, 
                    94.72000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.23999999999998`, 
                    85.24000000000001}, {146.32, 
                    97.96000000000001}, {142.95999999999998`, 
                    94.72000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{153.88000000000002`, 
                    53.56}, {143.32000000000002`, 
                    50.800000000000004`}, {143.32000000000002`, 44.92}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{153.88000000000002`, 
                    53.56}, {143.32000000000002`, 
                    50.800000000000004`}, {143.32000000000002`, 44.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.12, 56.68}, {143.8, 57.04}, {143.32, 
                    50.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.12, 56.68}, {143.8, 57.04}, {143.32, 50.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.32000000000002`, 
                    50.8}, {153.88000000000002`, 
                    53.559999999999995`}, {154.12000000000003`, 56.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{143.32000000000002`, 
                    50.8}, {153.88000000000002`, 
                    53.559999999999995`}, {154.12000000000003`, 56.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52549, 0., 0.47451000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{153.88000000000002`, 
                    50.56}, {143.32000000000002`, 
                    44.92}, {143.92000000000002`, 39.760000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{153.88000000000002`, 
                    50.56}, {143.32000000000002`, 
                    44.92}, {143.92000000000002`, 39.760000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.53333, 0., 0.46667000000000003`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.32000000000002`, 
                    44.92}, {153.88000000000002`, 
                    50.56}, {153.88000000000002`, 53.56}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.32000000000002`, 
                    44.92}, {153.88000000000002`, 
                    50.56}, {153.88000000000002`, 53.56}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52549, 0., 0.47451000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.8, 57.04}, {154.12, 
                    56.68}, {154.60000000000002`, 59.92}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.8, 57.04}, {154.12, 
                    56.68}, {154.60000000000002`, 59.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52549, 0., 0.47451000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.6, 59.92}, {144.64, 
                    63.4}, {143.79999999999998`, 57.04}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.6, 59.92}, {144.64, 
                    63.4}, {143.79999999999998`, 57.04}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{154.12, 
                    47.8}, {143.92000000000002`, 39.76}, {145., 
                    35.31999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.12, 47.8}, {143.92000000000002`, 
                    39.76}, {145., 35.31999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52549, 0., 0.47451000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{143.92000000000002`, 
                    39.760000000000005`}, {154.12, 
                    47.800000000000004`}, {153.88000000000002`, 50.56}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{143.92000000000002`, 
                    39.760000000000005`}, {154.12, 
                    47.800000000000004`}, {153.88000000000002`, 50.56}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.42745000000000005`, 0., 0.57255], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{144.04, 19.}, {152.44, 
                    29.560000000000002`}, {150.28, 29.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{144.04, 19.}, {152.44, 
                    29.560000000000002`}, {150.28, 29.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.41961000000000004`, 0., 0.58039], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{152.44, 29.56}, {144.04, 19.}, {147.28, 
                    21.4}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{152.44, 29.56}, {144.04, 19.}, {147.28, 21.4}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.39608000000000004`, 0., 0.60392], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{155.44, 96.76}, {148.12, 106.48}, {144.64, 
                    109.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{155.44, 96.76}, {148.12, 106.48}, {144.64, 
                    109.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.39608000000000004`, 0., 0.60392], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{144.64, 109.36}, {152.67999999999998`, 
                    98.8}, {155.44, 96.76}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{144.64, 109.36}, {152.67999999999998`, 
                    98.8}, {155.44, 96.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{144.64, 
                    63.4}, {154.6, 59.92}, {155.32, 62.92}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{144.64, 63.4}, {154.6, 59.92}, {155.32, 62.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{155.32000000000002`, 62.92}, {145.96, 
                    69.4}, {144.64000000000001`, 63.4}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{155.32000000000002`, 62.92}, {145.96, 
                    69.4}, {144.64000000000001`, 63.4}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{154.6, 
                    45.64}, {145., 35.32}, {146.44, 32.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.6, 45.64}, {145., 35.32}, {146.44, 32.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{145., 
                    35.32}, {154.6, 45.64}, {154.12, 47.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{145., 35.32}, {154.6, 45.64}, {154.12, 47.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{145.96, 
                    69.4}, {155.32000000000002`, 62.92}, {156.16, 65.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{145.96, 69.4}, {155.32000000000002`, 
                    62.92}, {156.16, 65.68}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{156.16, 
                    65.67999999999999}, {147.76, 74.67999999999999}, {145.96, 
                    69.39999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{156.16, 65.67999999999999}, {147.76, 
                    74.67999999999999}, {145.96, 69.39999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.41961000000000004`, 0., 0.58039], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{146.32000000000002`, 
                    97.96000000000001}, {154.24, 85.24000000000001}, {156.52, 
                    86.32000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{146.32000000000002`, 
                    97.96000000000001}, {154.24, 85.24000000000001}, {156.52, 
                    86.32000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.41961000000000004`, 0., 0.58039], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{156.52, 86.32}, {149.68, 
                    99.28}, {146.32000000000002`, 97.96}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{156.52, 86.32}, {149.68, 
                    99.28}, {146.32000000000002`, 97.96}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.48627000000000004`, 0., 0.51373], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{155.44, 43.839999999999996`}, {146.44, 
                    32.08}, {148.24, 29.919999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{155.44, 43.839999999999996`}, {146.44, 
                    32.08}, {148.24, 29.919999999999995`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{146.44, 
                    32.08}, {155.44, 43.839999999999996`}, {154.6, 45.64}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{146.44, 32.08}, {155.44, 
                    43.839999999999996`}, {154.6, 45.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.41961000000000004`, 0., 0.58039], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{147.28, 21.4}, {154.6, 
                    31.119999999999997`}, {152.44, 29.56}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{147.28, 21.4}, {154.6, 
                    31.119999999999997`}, {152.44, 29.56}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.42745000000000005`, 0., 0.57255], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.6, 31.12}, {147.28, 
                    21.400000000000002`}, {150.28, 25.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.6, 31.12}, {147.28, 
                    21.400000000000002`}, {150.28, 25.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.48627000000000004`, 0., 0.51373], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{147.76, 74.67999999999999}, {156.16, 
                    65.67999999999999}, {157.12, 68.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{147.76, 74.67999999999999}, {156.16, 
                    65.67999999999999}, {157.12, 68.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.48627000000000004`, 0., 0.51373], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{157.12, 68.08}, {149.8, 79.36}, {147.76, 
                    74.67999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{157.12, 68.08}, {149.8, 79.36}, {147.76, 
                    74.67999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47843, 0., 0.52157], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{156.28, 
                    42.64}, {148.24, 29.92}, {150.28, 29.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{156.28, 42.64}, {148.24, 29.92}, {150.28, 
                    29.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.48627000000000004`, 0., 0.51373], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{148.23999999999998`, 
                    29.919999999999998`}, {156.27999999999997`, 
                    42.64}, {155.43999999999997`, 43.839999999999996`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{148.23999999999998`, 
                    29.919999999999998`}, {156.27999999999997`, 
                    42.64}, {155.43999999999997`, 43.839999999999996`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.42745000000000005`, 0., 0.57255], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{158.68, 86.08}, {152.68, 98.8}, {149.68, 
                    99.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{158.68, 86.08}, {152.68, 98.8}, {149.68, 99.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.42745000000000005`, 0., 0.57255], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{149.68, 99.28}, {156.52, 86.32}, {158.68, 
                    86.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{149.68, 99.28}, {156.52, 86.32}, {158.68, 
                    86.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47843, 0., 0.52157], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{149.8, 
                    79.36}, {157.12, 68.08}, {158.32000000000002`, 69.88}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{149.8, 79.36}, {157.12, 
                    68.08}, {158.32000000000002`, 69.88}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47843, 0., 0.52157], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{158.32000000000002`, 69.88}, {152.08, 
                    82.84}, {149.8, 79.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{158.32000000000002`, 69.88}, {152.08, 
                    82.84}, {149.8, 79.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47843, 0., 0.52157], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{150.28, 
                    29.08}, {157.24, 42.16}, {156.28, 42.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{150.28, 29.08}, {157.24, 42.16}, {156.28, 
                    42.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47059, 0., 0.5294099999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{157.23999999999998`, 
                    42.160000000000004`}, {150.27999999999997`, 
                    29.080000000000005`}, {152.43999999999997`, 
                    29.560000000000002`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{157.23999999999998`, 
                    42.160000000000004`}, {150.27999999999997`, 
                    29.080000000000005`}, {152.43999999999997`, 
                    29.560000000000002`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.42745000000000005`, 0., 0.57255], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{150.28, 25.36}, {156.76, 33.76}, {154.6, 
                    31.119999999999997`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{150.28, 25.36}, {156.76, 33.76}, {154.6, 
                    31.119999999999997`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47059, 0., 0.5294099999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{152.08, 82.84}, {158.32000000000002`, 
                    69.88}, {159.4, 71.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{152.08, 82.84}, {158.32000000000002`, 
                    69.88}, {159.4, 71.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47059, 0., 0.5294099999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{159.4, 71.2}, {154.24, 
                    85.24000000000001}, {152.08, 82.84}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{159.4, 71.2}, {154.24, 
                    85.24000000000001}, {152.08, 82.84}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47059, 0., 0.5294099999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{152.44, 29.56}, {158.32, 42.28}, {157.24, 
                    42.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{152.44, 29.56}, {158.32, 42.28}, {157.24, 
                    42.16}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.46667000000000003`, 0., 0.53333], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{158.32000000000002`, 
                    42.28}, {152.44000000000003`, 
                    29.560000000000002`}, {154.60000000000002`, 31.12}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{158.32000000000002`, 
                    42.28}, {152.44000000000003`, 
                    29.560000000000002`}, {154.60000000000002`, 31.12}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.44314, 0., 0.55686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{160.6, 
                    84.76}, {155.44, 96.76}, {152.68, 98.80000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{160.6, 84.76}, {155.44, 96.76}, {152.68, 
                    98.80000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.44314, 0., 0.55686], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{152.68, 
                    98.8}, {158.68, 86.08}, {160.6, 84.75999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{152.68, 98.8}, {158.68, 86.08}, {160.6, 
                    84.75999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5098, 0., 0.49019999999999997`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {153.88, 
                    53.559999999999995`}, {153.88, 50.559999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 56.8}, {153.88, 
                    53.559999999999995`}, {153.88, 
                    50.559999999999995`}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5098, 0., 0.49019999999999997`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {154.11999999999998`, 
                    56.68}, {153.88, 53.559999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{161.2, 56.8}, {154.11999999999998`, 
                    56.68}, {153.88, 53.559999999999995`}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5098, 0., 0.49019999999999997`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {153.88, 
                    50.559999999999995`}, {154.11999999999998`, 47.8}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 56.8}, {153.88, 
                    50.559999999999995`}, {154.11999999999998`, 
                    47.8}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5098, 0., 0.49019999999999997`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {154.6, 
                    59.919999999999995`}, {154.11999999999998`, 56.68}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 56.8}, {154.6, 
                    59.919999999999995`}, {154.11999999999998`, 
                    56.68}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {154.11999999999998`, 47.8}, {154.6, 45.64}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {154.11999999999998`, 47.8}, {154.6, 
                    45.64}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.46667000000000003`, 0., 0.53333], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.23999999999998`, 
                    85.24000000000001}, {159.39999999999998`, 
                    71.20000000000002}, {160.48, 71.80000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{154.23999999999998`, 
                    85.24000000000001}, {159.39999999999998`, 
                    71.20000000000002}, {160.48, 71.80000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.46667000000000003`, 0., 0.53333], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{160.48000000000002`, 71.8}, {156.52, 
                    86.32}, {154.24, 85.24}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{160.48000000000002`, 71.8}, {156.52, 
                    86.32}, {154.24, 85.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {155.32, 62.919999999999995`}, {154.6, 
                    59.919999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {155.32, 
                    62.919999999999995`}, {154.6, 
                    59.919999999999995`}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.46667000000000003`, 0., 0.53333], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.6, 31.12}, {159.4, 
                    43.120000000000005`}, {158.32, 42.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{154.6, 31.12}, {159.4, 
                    43.120000000000005`}, {158.32, 42.28}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47059, 0., 0.5294099999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{159.4, 43.120000000000005`}, {154.6, 
                    31.120000000000005`}, {156.76000000000002`, 
                    33.760000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.4, 
                    43.120000000000005`}, {154.6, 
                    31.120000000000005`}, {156.76000000000002`, 
                    33.760000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {154.6, 45.64}, {155.44, 43.839999999999996`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 56.8}, {154.6, 
                    45.64}, {155.44, 43.839999999999996`}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {156.16, 65.67999999999999}, {155.32, 
                    62.919999999999995`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {156.16, 
                    65.67999999999999}, {155.32, 
                    62.919999999999995`}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49412, 0., 0.50196], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {155.44, 43.839999999999996`}, {156.28, 42.64}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 56.8}, {155.44, 
                    43.839999999999996`}, {156.28, 42.64}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47451000000000004`, 0., 0.52549], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{155.44, 96.76}, {160.6, 84.76}, {162.16, 
                    82.24000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{155.44, 96.76}, {160.6, 84.76}, {162.16, 
                    82.24000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47451000000000004`, 0., 0.52549], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{162.16, 82.24000000000001}, {157.72, 
                    92.92000000000002}, {155.44, 96.76}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{162.16, 82.24000000000001}, {157.72, 
                    92.92000000000002}, {155.44, 96.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49412, 0., 0.50196], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {157.11999999999998`, 68.08}, {156.16, 
                    65.67999999999999}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {157.11999999999998`, 
                    68.08}, {156.16, 65.67999999999999}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {156.28, 
                    42.64}, {157.23999999999998`, 42.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{161.2, 56.8}, {156.28, 
                    42.64}, {157.23999999999998`, 42.16}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47059, 0., 0.5294099999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{156.52, 86.32}, {160.48000000000002`, 
                    71.8}, {161.68, 71.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{156.52, 86.32}, {160.48000000000002`, 
                    71.8}, {161.68, 71.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47059, 0., 0.5294099999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.68, 71.8}, {158.68, 86.08}, {156.52, 
                    86.32}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.68, 71.8}, {158.68, 86.08}, {156.52, 86.32}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47843, 0., 0.52157], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{160.6, 
                    44.44}, {156.76, 33.76}, {158.79999999999998`, 37.48}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{160.6, 44.44}, {156.76, 
                    33.76}, {158.79999999999998`, 37.48}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47059, 0., 0.5294099999999999], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{156.76, 33.760000000000005`}, {160.6, 
                    44.440000000000005`}, {159.39999999999998`, 
                    43.120000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{156.76, 33.760000000000005`}, {160.6, 
                    44.440000000000005`}, {159.39999999999998`, 
                    43.120000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {158.32, 
                    69.88}, {157.11999999999998`, 68.08}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {158.32, 
                    69.88}, {157.11999999999998`, 68.08}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {157.23999999999998`, 
                    42.16}, {158.32, 42.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {157.23999999999998`, 
                    42.16}, {158.32, 42.28}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {159.39999999999998`, 
                    71.2}, {158.32, 69.88}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {159.39999999999998`, 
                    71.2}, {158.32, 69.88}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {158.32, 
                    42.28}, {159.39999999999998`, 43.12}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{161.2, 56.8}, {158.32, 
                    42.28}, {159.39999999999998`, 43.12}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47843, 0., 0.52157], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{162.52, 
                    71.2}, {160.60000000000002`, 84.76}, {158.68, 86.08}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{162.52, 71.2}, {160.60000000000002`, 
                    84.76}, {158.68, 86.08}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47843, 0., 0.52157], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{158.68, 
                    86.08}, {161.68, 71.8}, {162.52, 71.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{158.68, 86.08}, {161.68, 71.8}, {162.52, 71.2}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.47843, 0., 0.52157], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{158.8, 
                    37.48}, {161.68, 46.36}, {160.60000000000002`, 44.44}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{158.8, 37.48}, {161.68, 
                    46.36}, {160.60000000000002`, 44.44}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.48627000000000004`, 0., 0.51373], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.68, 46.36}, {158.8, 37.48}, {160.6, 
                    41.92}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.68, 46.36}, {158.8, 37.48}, {160.6, 41.92}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {160.48, 
                    71.8}, {159.39999999999998`, 71.2}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{161.2, 56.8}, {160.48, 
                    71.8}, {159.39999999999998`, 71.2}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {159.39999999999998`, 
                    43.12}, {160.6, 44.44}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {159.39999999999998`, 
                    43.12}, {160.6, 44.44}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {161.67999999999998`, 
                    71.8}, {160.48, 71.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {161.67999999999998`, 
                    71.8}, {160.48, 71.8}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.48627000000000004`, 0., 0.51373], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{160.6, 84.76}, {162.51999999999998`, 
                    71.2}, {163.48, 69.88000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{160.6, 84.76}, {162.51999999999998`, 
                    71.2}, {163.48, 69.88000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.48627000000000004`, 0., 0.51373], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{163.48000000000002`, 
                    69.88}, {162.16000000000003`, 
                    82.24}, {160.60000000000002`, 84.75999999999999}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{163.48000000000002`, 
                    69.88}, {162.16000000000003`, 
                    82.24}, {160.60000000000002`, 84.75999999999999}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {160.6, 
                    44.44}, {161.67999999999998`, 46.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{161.2, 56.8}, {160.6, 
                    44.44}, {161.67999999999998`, 46.36}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{162.52, 
                    48.760000000000005`}, {160.60000000000002`, 
                    41.92}, {162.16, 47.080000000000005`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{162.52, 
                    48.760000000000005`}, {160.60000000000002`, 
                    41.92}, {162.16, 47.080000000000005`}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.48627000000000004`, 0., 0.51373], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{160.6, 41.92}, {162.51999999999998`, 
                    48.760000000000005`}, {161.68, 46.36}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{160.6, 41.92}, {162.51999999999998`, 
                    48.760000000000005`}, {161.68, 46.36}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49412, 0., 0.50196], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {161.67999999999998`, 
                    46.36}, {162.51999999999998`, 48.76}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{161.2, 56.8}, {161.67999999999998`, 
                    46.36}, {162.51999999999998`, 48.76}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {162.51999999999998`, 
                    48.76}, {163.35999999999999`, 51.28}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{161.2, 56.8}, {162.51999999999998`, 
                    48.76}, {163.35999999999999`, 51.28}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {163.35999999999999`, 
                    51.28}, {164.07999999999998`, 54.279999999999994`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {163.35999999999999`, 
                    51.28}, {164.07999999999998`, 
                    54.279999999999994`}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5098, 0., 0.49019999999999997`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {164.07999999999998`, 
                    54.279999999999994`}, {164.56, 57.279999999999994`}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {164.07999999999998`, 
                    54.279999999999994`}, {164.56, 
                    57.279999999999994`}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49019999999999997`, 0., 0.5098], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {162.51999999999998`, 
                    71.2}, {161.67999999999998`, 71.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{161.2, 56.8}, {162.51999999999998`, 
                    71.2}, {161.67999999999998`, 71.8}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.49412, 0., 0.50196], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {163.48, 69.88}, {162.51999999999998`, 71.2}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 56.8}, {163.48, 
                    69.88}, {162.51999999999998`, 71.2}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {164.07999999999998`, 68.08}, {163.48, 69.88}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {164.07999999999998`, 68.08}, {163.48, 
                    69.88}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {164.56, 65.8}, {164.07999999999998`, 68.08}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 56.8}, {164.56, 
                    65.8}, {164.07999999999998`, 68.08}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5098, 0., 0.49019999999999997`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {164.79999999999998`, 
                    63.16}, {164.56, 65.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {164.79999999999998`, 
                    63.16}, {164.56, 65.8}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5098, 0., 0.49019999999999997`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {164.79999999999998`, 
                    60.279999999999994`}, {164.79999999999998`, 63.16}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}, {0, 1, 0}}}, {{{161.2, 
                    56.8}, {164.79999999999998`, 
                    60.279999999999994`}, {164.79999999999998`, 
                    63.16}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.5098, 0., 0.49019999999999997`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {164.56, 
                    57.279999999999994`}, {164.79999999999998`, 
                    60.279999999999994`}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}}, {{{161.2, 56.8}, {164.56, 
                    57.279999999999994`}, {164.79999999999998`, 
                    60.279999999999994`}, {161.2, 56.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{164.08, 
                    68.08}, {163.36, 78.64}, {162.16000000000003`, 82.24}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{164.08, 68.08}, {163.36, 
                    78.64}, {162.16000000000003`, 82.24}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{162.16, 
                    82.24000000000001}, {163.48, 
                    69.88000000000001}, {164.07999999999998`, 
                    68.08000000000001}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{162.16, 82.24000000000001}, {163.48, 
                    69.88000000000001}, {164.07999999999998`, 
                    68.08000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.50196, 0., 0.49412], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{162.16, 
                    47.08}, {163.35999999999999`, 51.28}, {162.52, 48.76}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{162.16, 47.08}, {163.35999999999999`, 
                    51.28}, {162.52, 48.76}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{164.56, 
                    65.8}, {164.2, 74.32}, {163.36, 78.64}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{164.56, 65.8}, {164.2, 74.32}, {163.36, 78.64}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52157, 0., 0.47843], Opacity[1.]}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.36, 
                    78.64}, {164.08, 68.08}, {164.56, 65.8}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{
                    "Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{163.36, 78.64}, {164.08, 68.08}, {164.56, 65.8}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52549, 0., 0.47451000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{164.8, 63.160000000000004`}, {164.68, 
                    69.28}, {164.20000000000002`, 74.32000000000001}}}]}, 
                    {Thickness[0.002168674698795181], 
                    JoinForm[{"Miter", 10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 
                    1, 0}}}, {{{164.8, 63.160000000000004`}, {164.68, 
                    69.28}, {164.20000000000002`, 74.32000000000001}}},
                    CurveClosed->{0}]}, 
                    {FaceForm[{RGBColor[0.52549, 0., 0.47451000000000004`], 
                    Opacity[1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 
                    0}}}, {{{164.2, 74.32}, {164.56, 
                    65.8}, {164.79999999999998`, 63.16}}}]}, 
                    {Thickness[0.002168674698795181], JoinForm[{"Miter", 
                    10.}], JoinedCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{164.2, 
                    74.32}, {164.56, 65.8}, {164.79999999999998`, 63.16}}},
                    CurveClosed->{0}]}},
                    AspectRatio->Automatic,
                    ImageSize->{166., 135.},
                    PlotRange->{{0., 166.}, {0., 135.}}], {0.8333333333333333, 0.75},
                     Center, {0.2564102564102564, 0.3846153846153846}], 
                    {RGBColor[1., 0.843104, 0.], Opacity[1], 
                    DiskBox[{0.5509229046951908, 0.25}, {0.04410052910052911, 0.06615079365079365},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5509229046951908, 0.25}, {0.04410052910052911, 0.06615079365079365},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1., 0.843104, 0.], Opacity[1], 
                    DiskBox[{0.4745385476524046, 0.3161507936507937}, {0.04410052910052911, 0.06615079365079365},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.4745385476524046, 0.3161507936507937}, {0.04410052910052911, 0.06615079365079365},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1., 0.843104, 0.], Opacity[1], 
                    DiskBox[{0.4745385476524046, 0.18384920634920635`}, {0.04410052910052911, 0.06615079365079365},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.4745385476524046, 0.18384920634920635`}, {0.04410052910052911, 0.06615079365079365},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {RGBColor[1., 0.843104, 0.], Opacity[1], 
                    DiskBox[{0.5509229046951908, 0.25}, {0.04410052910052911, 0.06615079365079365},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.5509229046951908, 0.25}, {0.04410052910052911, 0.06615079365079365},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {RGBColor[0.333333, 0.333333, 0.333333], 
                    AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                    CapForm[None], LineBox[{{0.712121212121212, 
                    0.08766233766233769}, {0.712121212121212, 
                    0.47727272727272735`}}]}, 
                    {RGBColor[0.333333, 0.333333, 0.333333], 
                    AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                    CapForm[None], LineBox[{{0.7055061327561327, 
                    0.46073502886002893`}, {0.712121212121212, 
                    0.47727272727272735`}, {0.7187362914862915, 
                    0.46073502886002893`}}]}, 
                    {RGBColor[0.333333, 0.333333, 0.333333], 
                    AbsoluteThickness[1], Opacity[1], Dashing[{}], 
                    CapForm[None]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7323232323232323, 
                    0.12012987012987016`}, {0.9343434343434343, 
                    0.12012987012987016`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7323232323232323, 
                    0.1850649350649351}, {0.9343434343434343, 
                    0.1850649350649351}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7323232323232323, 
                    0.25000000000000006`}, {0.9343434343434343, 
                    0.25000000000000006`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7323232323232323, 
                    0.31493506493506496`}, {0.9343434343434343, 
                    0.31493506493506496`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7323232323232323, 
                    0.3798701298701299}, {0.9343434343434343, 
                    0.3798701298701299}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7323232323232323, 
                    0.44480519480519487`}, {0.9343434343434343, 
                    0.44480519480519487`}}], 
                    {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
                    DiskBox[{0.7756132756132755, 0.12012987012987016`}, {0.020202020202020207`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7756132756132755, 0.12012987012987016`}, {0.020202020202020207`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.7655122655122655, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7655122655122655, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.7857142857142857, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7857142857142857, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7604617604617604, 
                    0.10714285714285719`}, {0.7705627705627704, 
                    0.13311688311688316`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7645313620248172, 
                    0.13073606395716475`}, {0.7705627705627704, 
                    0.13311688311688316`}, {0.7721499833359161, 
                    0.12406977030995323`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7907647907647908, 
                    0.13311688311688316`}, {0.7806637806637807, 
                    0.10714285714285719`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.786695189201734, 
                    0.1095236763025756}, {0.7806637806637807, 
                    0.10714285714285719`}, {0.7790765678906351, 
                    0.1161899699497871}}], 
                    {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
                    DiskBox[{0.8333333333333333, 0.12012987012987016`}, {0.020202020202020204`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8333333333333333, 0.12012987012987016`}, {0.020202020202020204`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.8232323232323232, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8232323232323232, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.8434343434343434, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8434343434343434, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8181818181818182, 
                    0.10714285714285719`}, {0.8282828282828284, 
                    0.13311688311688316`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8222514197448751, 
                    0.1307360639571648}, {0.8282828282828284, 
                    0.13311688311688316`}, {0.8298700410559741, 
                    0.12406977030995323`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8484848484848484, 
                    0.13311688311688316`}, {0.8383838383838383, 
                    0.10714285714285719`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8444152469217917, 
                    0.1095236763025756}, {0.8383838383838383, 
                    0.10714285714285719`}, {0.8367966256106928, 
                    0.1161899699497871}}], 
                    {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
                    DiskBox[{0.891053391053391, 0.12012987012987016`}, {0.02020202020202019, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.891053391053391, 0.12012987012987016`}, {0.02020202020202019, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.8809523809523809, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8809523809523809, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.901154401154401, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.901154401154401, 0.12012987012987016`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.875901875901876, 
                    0.10714285714285719`}, {0.8860028860028861, 
                    0.13311688311688316`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8799714774649328, 
                    0.1307360639571648}, {0.8860028860028861, 
                    0.13311688311688316`}, {0.8875900987760317, 
                    0.12406977030995323`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.9062049062049062, 
                    0.13311688311688316`}, {0.8961038961038962, 
                    0.10714285714285719`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.9021353046418495, 
                    0.1095236763025756}, {0.8961038961038962, 
                    0.10714285714285719`}, {0.8945166833307506, 
                    0.1161899699497871}}], 
                    {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
                    DiskBox[{0.7756132756132755, 0.1850649350649351}, {0.020202020202020207`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7756132756132755, 0.1850649350649351}, {0.020202020202020207`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.7655122655122655, 0.1850649350649351}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7655122655122655, 0.1850649350649351}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.7857142857142857, 0.1850649350649351}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7857142857142857, 0.1850649350649351}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7604617604617604, 
                    0.17207792207792214`}, {0.7705627705627704, 
                    0.19805194805194812`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7645313620248172, 
                    0.19567112889222968`}, {0.7705627705627704, 
                    0.19805194805194812`}, {0.7721499833359161, 
                    0.18900483524501818`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7907647907647908, 
                    0.19805194805194812`}, {0.7806637806637807, 
                    0.17207792207792214`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.786695189201734, 
                    0.17445874123764055`}, {0.7806637806637807, 
                    0.17207792207792214`}, {0.7790765678906351, 
                    0.18112503488485204`}}], 
                    {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
                    DiskBox[{0.8333333333333333, 0.1850649350649351}, {0.020202020202020204`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8333333333333333, 0.1850649350649351}, {0.020202020202020204`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.8232323232323232, 0.1850649350649351}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8232323232323232, 0.1850649350649351}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.8434343434343434, 0.1850649350649351}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8434343434343434, 0.1850649350649351}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8181818181818182, 
                    0.17207792207792214`}, {0.8282828282828284, 
                    0.19805194805194812`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8222514197448751, 
                    0.19567112889222973`}, {0.8282828282828284, 
                    0.19805194805194812`}, {0.8298700410559741, 
                    0.18900483524501818`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8484848484848484, 
                    0.19805194805194812`}, {0.8383838383838383, 
                    0.17207792207792214`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8444152469217917, 
                    0.17445874123764055`}, {0.8383838383838383, 
                    0.17207792207792214`}, {0.8367966256106928, 
                    0.18112503488485204`}}], 
                    {RGBColor[1., 0.894101, 0.709799], Opacity[1], DiskBox[{0.7756132756132755, 0.25000000000000006`},\
 {0.020202020202020207`, 0.019480519480519484`}, NCache[{0, 2 Pi}, {0, 
                    6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7756132756132755, 0.25000000000000006`}, {0.020202020202020207`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.7655122655122655, 0.25000000000000006`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7655122655122655, 0.25000000000000006`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.7857142857142857, 0.25000000000000006`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7857142857142857, 0.25000000000000006`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7604617604617604, 
                    0.23701298701298706`}, {0.7705627705627704, 
                    0.2629870129870131}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7645313620248172, 
                    0.26060619382729466`}, {0.7705627705627704, 
                    0.2629870129870131}, {0.7721499833359161, 
                    0.25393990018008317`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7907647907647908, 
                    0.2629870129870131}, {0.7806637806637807, 
                    0.23701298701298706`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.786695189201734, 
                    0.23939380617270548`}, {0.7806637806637807, 
                    0.23701298701298706`}, {0.7790765678906351, 
                    0.24606009981991697`}}], 
                    {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
                    DiskBox[{0.8333333333333333, 0.25000000000000006`}, {0.020202020202020204`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8333333333333333, 0.25000000000000006`}, {0.020202020202020204`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.8232323232323232, 0.25000000000000006`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8232323232323232, 0.25000000000000006`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.8434343434343434, 0.25000000000000006`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.8434343434343434, 0.25000000000000006`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8181818181818182, 
                    0.23701298701298706`}, {0.8282828282828284, 
                    0.2629870129870131}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8222514197448751, 
                    0.2606061938272947}, {0.8282828282828284, 
                    0.2629870129870131}, {0.8298700410559741, 
                    0.25393990018008317`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8484848484848484, 
                    0.2629870129870131}, {0.8383838383838383, 
                    0.23701298701298706`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.8444152469217917, 
                    0.23939380617270548`}, {0.8383838383838383, 
                    0.23701298701298706`}, {0.8367966256106928, 
                    0.24606009981991697`}}], 
                    {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
                    DiskBox[{0.7756132756132755, 0.31493506493506496`}, {0.020202020202020207`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7756132756132755, 0.31493506493506496`}, {0.020202020202020207`, 0.019480519480519484`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.7655122655122655, 0.31493506493506496`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7655122655122655, 0.31493506493506496`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                    {GrayLevel[0], Opacity[1], 
                    DiskBox[{0.7857142857142857, 0.31493506493506496`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    CircleBox[{0.7857142857142857, 0.31493506493506496`}, {0.004410052910052911, 0.0066150793650793654`},
                     NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7604617604617604, 
                    0.301948051948052}, {0.7705627705627704, 
                    0.32792207792207806`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7645313620248172, 
                    0.3255412587623596}, {0.7705627705627704, 
                    0.32792207792207806`}, {0.7721499833359161, 
                    0.3188749651151482}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.7907647907647908, 
                    0.32792207792207806`}, {0.7806637806637807, 
                    0.301948051948052}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.786695189201734, 
                    0.30432887110777046`}, {0.7806637806637807, 
                    0.301948051948052}, {0.7790765678906351, 
                    0.3109951647549819}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    LineBox[{{0.30000000000000004`, 
                    0.7417311507936508}, {0.36065295815295817`, 
                    0.7417311507936508}}], LineBox[{{0.30000000000000004`, 
                    0.7582688492063492}, {0.36065295815295817`, 
                    0.7582688492063492}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    LineBox[{{0.35343650793650794`, 
                    0.7681914682539682}, {0.3666666666666667, 
                    0.75}, {0.35343650793650794`, 0.7318085317460318}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.6333333333333334, 
                    0.7417311507936508}, {0.6939862914862914, 
                    0.7417311507936508}}], LineBox[{{0.6333333333333334, 
                    0.7582688492063492}, {0.6939862914862914, 
                    0.7582688492063492}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.6867698412698413, 
                    0.7681914682539682}, {0.7000000000000001, 
                    0.75}, {0.6867698412698413, 0.7318085317460318}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], 
                    LineBox[{{0.49448743386243393`, 
                    0.55}, {0.49448743386243393`, 0.4590205627705628}}], 
                    LineBox[{{0.5055125661375662, 0.55}, {0.5055125661375662, 
                    0.4590205627705628}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.5121276455026456, 
                    0.46984523809523815`}, {0.5000000000000001, 
                    0.45}, {0.48787235449735455`, 0.46984523809523815`}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.6391984677295028, 
                    0.529508379712909}, {0.6820865857384834, 
                    0.465176202699438}}], LineBox[{{0.6469944135247276, 
                    0.5412022984057459}, {0.6898825315337082, 
                    0.476870121392275}}]}, 
                    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
                    Dashing[{}], CapForm[None], LineBox[{{0.6894572981266959, 
                    0.4915406739341979}, {0.6902368927062184, 
                    0.4646446609406727}, {0.6723062173772015, 
                    0.4658140528099564}}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"Nucleon interactions\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->15,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.16666666666666666`, 1.}, {0, 1}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"Shell structure\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->15,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5, 1.}, {0, 1}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5299364318536629, 0.7533075396825397}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"n\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5, 0.7949046477804943}, {0, 0}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.47006356814633715`, 0.7533075396825397}, \
{0, 0}, Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"n\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5, 0.7050953522195057}, {0, 0}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5299364318536629, 0.7533075396825397}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5782696190476191, 0.7533075396825397}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"n\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5677834784397685, 0.8087022142857143}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5391348095238095, 0.8549827573421924}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"n\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5, 0.8674044285714285}, {0, 0}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.46086519047619046`, 0.8549827573421924}, \
{0, 0}, Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"n\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.4322165215602315, 0.8087022142857143}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.42173038095238097`, 0.7533075396825397}, \
{0, 0}, Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"n\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.4322165215602315, 0.6912977857142857}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.46086519047619046`, 0.651632322022887}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"n\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5, 0.6325955714285715}, {0, 0}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5391348095238095, 0.651632322022887}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"n\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5677834784397685, 0.6912977857142857}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"p\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5782696190476191, 0.7533075396825397}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"Collective deformation\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->15,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.8333333333333333, 1.}, {0, 1}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"Cluster correlations\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->15,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5, 0.}, {0, -1}, Automatic, {1, 0}], 
                    InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"\[Alpha]\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->16,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5509229046951908, 0.25}, {0, 0}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"\[Alpha]\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->16,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.4745385476524046, 0.3161507936507937}, {0, 0},
                     Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"\[Alpha]\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->16,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.4745385476524046, 0.18384920634920635`}, \
{0, 0}, Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"\[Alpha]\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->16,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5509229046951908, 0.25}, {0, 0}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox["\<\"Pair condensation\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->15,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.8333333333333333, 0.}, {0, -1}, 
                    Automatic, {1, 0}], InsetBox[
                    TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    StyleBox["\<\"E\"\>",
                    FontSlant->"Italic"],
                    StyleForm[#, FontSlant -> "Italic"]& ],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->RGBColor[0.333333, 0.333333, 0.333333],
                    FontOpacity->1],
                    
                    DisplayForm], {0.6964655242905242, 0.28246753246753253`}, \
{0, 0}, Automatic, {0, 
                    1}]}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}\
}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}\
}}}}}}}}}}}}}},
AspectRatio->0.6666666666666667,
Axes->False,
Background->None,
BaseStyle->{
 FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
  "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 1,
   ShowAutoStyles -> False, SingleLetterItalics -> False},
DisplayFunction->Identity,
Frame->False,
FrameLabel->{None, None, None, None},
FrameStyle->Directive[{
   GrayLevel[0], 
   Opacity[1], 
   CapForm[None], 
   AbsoluteThickness[1], 
   AbsoluteDashing[{}]}],
FrameTicks->None,
ImageSize->{453.59999999999997`, 302.4},
PlotRange->{{-0.0001, 1.0001}, {-0.0001, 1.0001}},
Ticks->None]], "Output",
 CellChangeTimes->{3.488836538515625*^9, 3.48883794671875*^9, 
  3.4956594663125*^9, 3.495659704109375*^9, 3.525527904375*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simple example of image or vector graphics import", "Section",
 CellChangeTimes->{{3.488838544484375*^9, 3.488838555671875*^9}}],

Cell[TextData[{
 "Import bitmap image from standard Wolfram example data (this is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Image object)"
}], "Text",
 CellChangeTimes->{{3.488838441875*^9, 3.488838450328125*^9}, {
  3.48883848328125*^9, 3.488838484453125*^9}, {3.492724853375*^9, 
  3.49272486109375*^9}, {3.501273888984375*^9, 3.50127390671875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"MapImage", "=", 
   RowBox[{"Import", "[", "\"\<ExampleData/cea.tif\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.485821451328125*^9, 3.485821451921875*^9}, {
   3.485821551484375*^9, 3.485821563546875*^9}, {3.48883113828125*^9, 
   3.4888311386875*^9}, {3.48883125190625*^9, 3.488831275296875*^9}, {
   3.488837116125*^9, 3.488837126171875*^9}, {3.488837619625*^9, 
   3.488837619859375*^9}, 3.488838440359375*^9, 3.495659667828125*^9}],

Cell[TextData[{
 "Import vector graphics from a PDF file (this is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Graphics object)"
}], "Text",
 CellChangeTimes->{{3.48883845809375*^9, 3.488838480234375*^9}, {
  3.501273911375*^9, 3.501273918890625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipsoidGraphics", "=", 
   RowBox[{
   "Import", "[", 
    "\"\<LevelScheme/ExampleData/nuclpict_modes_redblue_Y22C.pdf\>\"", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4881504998125*^9, 3.488150503515625*^9}, {
   3.488151365*^9, 3.488151434515625*^9}, {3.488281363875*^9, 
   3.488281364125*^9}, {3.48828319428125*^9, 3.488283206625*^9}, {
   3.48883605475*^9, 3.488836058734375*^9}, {3.48883632528125*^9, 
   3.488836343359375*^9}, {3.488837665890625*^9, 3.4888376971875*^9}, {
   3.4888377524375*^9, 3.488837773359375*^9}, 3.492125327390625*^9, 
   3.492125423609375*^9, {3.495659420765625*^9, 3.495659433921875*^9}, {
   3.501273932671875*^9, 3.501273933984375*^9}, 3.50127399434375*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"YPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XGapSizes", "\[Rule]", "0.05"}], ",", "\[IndentingNewLine]", 
       RowBox[{"YGapSizes", "\[Rule]", "0.05"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ShowTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"False", ",", "False", ",", "False", ",", "False"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"r", "+", "s"}], ",", "2"}], "]"}], ",", 
         "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"FigurePanel", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"r", ",", "s"}], "}"}], ",", 
             RowBox[{"PanelLetterBackground", "\[Rule]", "LightGray"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"FigGraphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "MapImage"}], 
            "]"}], ","}], "\[IndentingNewLine]", "}"}], ",", 
         "\[IndentingNewLine]", "1", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"FigurePanel", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"r", ",", "s"}], "}"}], ",", 
             RowBox[{"ExtendRange", "\[Rule]", "0.05"}], ",", 
             RowBox[{"Background", "\[Rule]", "Moccasin"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"FigGraphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             "EllipsoidGraphics"}], "]"}], ","}], "\[IndentingNewLine]", 
          "}"}]}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"r", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "1", ",", "2"}], "}"}]}], "\[IndentingNewLine]", 
      "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ExtendRange", "\[Rule]", "0.1"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.4052021644375*^9, 3.40520220715625*^9}, {
   3.405202238578125*^9, 3.40520223878125*^9}, {3.405202292609375*^9, 
   3.405202309484375*^9}, {3.405202468546875*^9, 3.405202475*^9}, {
   3.4052025325*^9, 3.405202631546875*^9}, {3.405202731875*^9, 
   3.405203287703125*^9}, {3.405203325578125*^9, 3.40520335125*^9}, {
   3.40520343996875*^9, 3.40520350828125*^9}, {3.405204675671875*^9, 
   3.405204740328125*^9}, {3.40520477325*^9, 3.405204832828125*^9}, 
   3.48828153896875*^9, {3.488281624859375*^9, 3.488281694890625*^9}, {
   3.488282148296875*^9, 3.48828228190625*^9}, {3.488283226109375*^9, 
   3.488283247671875*^9}, {3.488284071875*^9, 3.488284109640625*^9}, {
   3.488284168796875*^9, 3.48828417221875*^9}, {3.4882842058125*^9, 
   3.488284228625*^9}, {3.48828430809375*^9, 3.488284327875*^9}, {
   3.488284477984375*^9, 3.488284618828125*^9}, {3.48828465840625*^9, 
   3.48828473565625*^9}, {3.488284768390625*^9, 3.488284768515625*^9}, {
   3.48828486096875*^9, 3.48828487484375*^9}, {3.488284916890625*^9, 
   3.488284939359375*^9}, {3.488284994625*^9, 3.48828503721875*^9}, {
   3.488285076765625*^9, 3.48828507703125*^9}, {3.48828549625*^9, 
   3.488285532375*^9}, {3.488833143078125*^9, 3.48883318528125*^9}, {
   3.48883326521875*^9, 3.488833284421875*^9}, {3.488833330984375*^9, 
   3.48883347028125*^9}, {3.48883386234375*^9, 3.488833895203125*^9}, {
   3.4888339380625*^9, 3.488833958796875*^9}, {3.48883399415625*^9, 
   3.488834068015625*^9}, {3.488837154109375*^9, 3.488837236796875*^9}, {
   3.488837297359375*^9, 3.48883753421875*^9}, {3.495659668546875*^9, 
   3.49565968328125*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
    RectangleBox[{0.5121951219512195, 0.5121951219512195}, {1., 1.}]}, 
   {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
    RectangleBox[{0., -5.551115123125783*^-17}, \
{0.48780487804878053`, 0.4878048780487805}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0., 0.5121951219512195}, {0.48780487804878053`, 
     0.5121951219512195}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0., 0.5121951219512195}, {0., 1.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0., 1.}, {0.48780487804878053`, 1.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.48780487804878053`, 0.5121951219512195}, {
     0.48780487804878053`, 1.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], {}, InsetBox[
     FormBox[
      GraphicsBox[
       TagBox[RasterBox[CompressedData["
1:eJzsvSuw5TobprdrEnDgphsuuOCiZjE0dJjZjGuGGKRqnKrUlKigoKCooKCg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