(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    378880,       7341]
NotebookOptionsPosition[    374879,       7212]
NotebookOutlinePosition[    375743,       7242]
CellTagsIndexPosition[    375700,       7239]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["LevelScheme examples: Data plots",
 FontFamily->"Times New Roman",
 FontSize->36]], "Text",
 CellChangeTimes->{{3.4912582924375*^9, 3.4912582936875*^9}, {
  3.4912586879375*^9, 3.49125868853125*^9}, {3.4990222156875*^9, 
  3.499022216765625*^9}},
 FontSize->10],

Cell[TextData[{
 StyleBox["M. A. Caprio, ", "SmallText",
  FontFamily->"Times New Roman",
  FontSize->12],
 "Department of Physics, University of Notre Dame"
}], "Text",
 CellChangeTimes->{{3.39552255203125*^9, 3.3955225581875*^9}, {
   3.396878383875*^9, 3.39687838403125*^9}, 3.397586352671875*^9, {
   3.39854548165625*^9, 3.398545486203125*^9}, {3.430247945015625*^9, 
   3.430247947875*^9}, {3.436820309328125*^9, 3.436820313328125*^9}, {
   3.443996368375*^9, 3.443996375046875*^9}, {3.47108965090625*^9, 
   3.471089655984375*^9}, {3.497225037953125*^9, 3.497225038359375*^9}}],

Cell[CellGroupData[{

Cell["Package initialization", "Section"],

Cell[TextData[{
 "If you have not already loaded the LevelScheme package since starting this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you must do so now.  See the user guide for information first on \
installing the package and then on loading it at the beginning of each ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session."
}], "Text",
 CellChangeTimes->{{3.4921245209375*^9, 3.492124756234375*^9}, {
  3.492124799609375*^9, 3.492124838453125*^9}, {3.495659733515625*^9, 
  3.495659808359375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", "\"\<LevelScheme`\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.492124284765625*^9, 3.49212429721875*^9}, 
   3.492124551328125*^9}],

Cell[BoxData[
 FrameBox[
  TemplateBox[{TagBox[
     GridBox[{{
        RowBox[{
         "LevelScheme", " ", "scientific", " ", "figure", " ", "preparation", 
          " ", "system"}]}, {
        RowBox[{
          RowBox[{"M", ".", " ", "A", ".", " ", "Caprio"}], ",", " ", 
          RowBox[{"Department", " ", "of", " ", "Physics"}], ",", " ", 
          RowBox[{"University", " ", "of", " ", "Notre", " ", "Dame"}]}]}, {
        TemplateBox[{"\"Comput. Phys. Commun. \"", 
          TagBox[
           StyleBox["\"171\"", FontWeight -> "Bold"], 
           StyleForm[#, FontWeight -> "Bold"]& ], "\", 107 (2005)\""}, "Row", 
         DisplayFunction -> (
          RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )]}, {
        RowBox[{"Version", " ", "3.51", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"February", " ", "23"}], ",", " ", "2011"}], ")"}]}]}, {
        RowBox[{
          ButtonBox[
           StyleBox[
            RowBox[{"View", " ", "color", " ", "palette"}], FontFamily -> 
            "Times"], Active -> True, Appearance -> {Automatic, "DialogBox"}, 
           ButtonFunction :> (
            LevelScheme`NamedColorPalette`NamedColorPalette[]& ), ButtonNote -> 
           "Named color palette", Evaluator -> Automatic, ImageSize -> 
           Automatic], 
          TagBox[
           ButtonBox[
            StyleBox[
             RowBox[{"Visit", " ", "home", " ", "page"}], FontFamily -> 
             "Times"], Active -> True, Appearance -> {Automatic, "DialogBox"},
             ButtonData :> {
              URL[
              "http://wnsl.physics.yale.edu/levelscheme/notebook_entrance_3.\
51.html"], None}, ButtonFunction :> (FrontEndExecute[{
               FrontEnd`NotebookLocate[#2]}]& ), ButtonNote -> 
            "http://wnsl.physics.yale.edu/levelscheme/notebook_entrance_3.51.\
html", ImageSize -> Automatic], DisplayForm]}]}}, 
      GridBoxAlignment -> {
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}], DisplayForm],"\"  \"",GraphicsBox[{{
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 200.}, {0.9, 200.}}]}, {
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 116.93046875}, {0.1536723484848485, 116.93046875}, {
        0.2610170454545455, 100.}, {0.7389829545454545, 100.}, {
        0.8463276515151515, 116.93046875}, {0.9, 116.93046875}}]}, {
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 0.}, {0.9, 0.}}], {
        GrayLevel[0.5], 
        Opacity[1], 
        PolygonBox[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {
         0.6828827683115883, 106.35880620986916`}, {0.675461586050597, 
         105.04604015402995`}, {0.73, 100.}, {0.7595683183418321, 
         119.92405545354092`}, {0.7521471360808408, 118.61128939770171`}, {
         0.6707584254785426, 200.}}]}, {
        GrayLevel[0], 
        AbsoluteThickness[1], 
        Opacity[1], 
        Dashing[{}], 
        LineBox[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {
         0.6828827683115883, 106.35880620986916`}, {0.675461586050597, 
         105.04604015402995`}, {0.73, 100.}, {0.7595683183418321, 
         119.92405545354092`}, {0.7521471360808408, 118.61128939770171`}, {
         0.6707584254785426, 200.}, {0.6300000000000001, 200.}}], {
         GrayLevel[0.5], 
         Opacity[1], 
         PolygonBox[{{0.2700000000000001, 100.}, {0.22924157452145752`, 
          100.}, {0.3228827683115884, 6.358806209869151}, {0.3154615860505971,
           5.046040154029939}, {0.37000000000000005`, 0.}, {
          0.3995683183418322, 19.924055453540902`}, {0.39214713608084084`, 
          18.61128939770171}, {0.3107584254785426, 100.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.2700000000000001, 100.}, {0.22924157452145752`, 100.}, {
          0.3228827683115884, 6.358806209869151}, {0.3154615860505971, 
          5.046040154029939}, {0.37000000000000005`, 0.}, {0.3995683183418322,
           19.924055453540902`}, {0.39214713608084084`, 18.61128939770171}, {
          0.3107584254785426, 100.}, {0.2700000000000001, 100.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 20.}, {0.529, 20.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 21.3}, {0.5589999999999999, 21.3}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 24.333333333333336`}, {0.589, 
          24.333333333333336`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 29.1}, {0.619, 29.1}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 35.6}, {0.649, 35.6}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 43.833333333333336`}, {0.679, 
          43.833333333333336`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.681, 53.8}, {0.709, 53.8}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.711, 65.5}, {0.739, 65.5}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.741, 78.93333333333334}, {0.769, 78.93333333333334}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 33.}, {0.529, 33.}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 34.3}, {0.5589999999999999, 34.3}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 37.333333333333336`}, {0.589, 
          37.333333333333336`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 42.099999999999994`}, {0.619, 
          42.099999999999994`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 48.599999999999994`}, {0.649, 
          48.599999999999994`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 56.833333333333336`}, {0.679, 
          56.833333333333336`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.681, 66.8}, {0.709, 66.8}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.711, 78.5}, {0.739, 78.5}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 47.761071567264665`}, {0.529, 
          47.761071567264665`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 49.24022665797266}, {0.5589999999999999, 
          49.24022665797266}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 52.691588536291334`}, {0.589, 
          52.691588536291334`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 58.115157202220665`}, {0.619, 
          58.115157202220665`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 65.51093265576067}, {0.649, 65.51093265576067}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 74.87891489691134}, {0.679, 74.87891489691134}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 56.07894755622853}, {0.529, 56.07894755622853}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 57.38554745213195}, {0.5589999999999999, 
          57.38554745213195}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 60.434280542573276`}, {0.589, 
          60.434280542573276`}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 65.22514682755249}, {0.619, 65.22514682755249}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 71.75814630706962}, {0.649, 71.75814630706962}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 80.03327898112465}, {0.679, 80.03327898112465}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 60.981197953135855`}, {0.529, 
          60.981197953135855`}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 62.04756255970392}, {0.5589999999999999, 
          62.04756255970392}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 64.53574664169608}, {0.589, 
          64.53574664169608}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 68.44575019911233}, {0.619, 68.44575019911233}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 73.77757323195266}, {0.649, 73.77757323195266}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 80.53121574021708}, {0.679, 80.53121574021708}}], 
         InsetBox[
          TagBox["\"LevelScheme\"", DisplayForm], {0.1, 200.}, {-1, -0.75}, 
          Automatic, {1, 0}, 
          BaseStyle -> {
           FontFamily -> "Times", FontSize -> 10, FontSlant -> "Plain", 
            FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
            GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}]}}}}, 
     AspectRatio -> 0.7727272727272727, Axes -> False, Background -> 
     RGBColor[0.889996, 0.509995, 0.089999], 
     BaseStyle -> {
      FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", 
       FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
       GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}, 
     DisplayFunction -> Identity, Frame -> False, 
     FrameLabel -> {None, None, None, None}, FrameStyle -> Directive[{
        GrayLevel[0], 
        Opacity[1], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{}]}], FrameTicks -> None, 
     ImageSize -> {93.17647058823529, 72.}, 
     PlotRange -> {{-0.0001, 1.0001}, {-50.0325, 275.0325}}, Ticks -> None]},
   "Row",
   DisplayFunction->(
    RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3}]& ),
   InterpretationFunction->(RowBox[{"Row", "[", 
      RowBox[{"{", 
        RowBox[{#, ",", #2, ",", #3}], "}"}], "]"}]& )],
  Background->GrayLevel[0.85],
  FrameMargins->10,
  FrameStyle->None,
  StripOnInput->False]], "Print",
 CellChangeTimes->{3.507512418625*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disclaimer", "Section",
 CellChangeTimes->{{3.499032577171875*^9, 3.499032578578125*^9}}],

Cell[TextData[{
 StyleBox["Data plotting:",
  FontWeight->"Bold"],
 " These examples involves the LevelScheme data plotting functions, which are \
not yet documented and still under development."
}], "Text",
 CellChangeTimes->{{3.495661032546875*^9, 3.495661059921875*^9}, {
  3.499032565921875*^9, 3.499032574625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Simple multipanel data plot (with data styles and legend) -- Nuclear mass \
predictions\
\>", "Section",
 CellChangeTimes->{{3.4990228219375*^9, 3.499022834984375*^9}, {
  3.49903249971875*^9, 3.499032539125*^9}}],

Cell["\<\
Experimental data -- entered here as a list\
\>", "Text",
 CellChangeTimes->{{3.497533748171875*^9, 3.49753375053125*^9}, {
  3.4990228745625*^9, 3.49902289484375*^9}, {3.499022967578125*^9, 
  3.4990229718125*^9}, {3.506122752222875*^9, 3.506122755910375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ExptData", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0.", ",", " ", "None"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"-", "7.363"}], ",", " ", "7.363"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"-", "19.843"}], ",", " ", "12.480"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"-", "27.776"}], ",", " ", "7.933"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"-", "38.906"}], ",", " ", "11.13"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", 
       RowBox[{"-", "46.321"}], ",", " ", "7.415"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"6", ",", " ", 
       RowBox[{"-", "56.715"}], ",", " ", "10.394"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", 
       RowBox[{"-", "63.991"}], ",", " ", "7.276"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"8", ",", " ", 
       RowBox[{"-", "73.936"}], ",", " ", "9.945"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "TableForm"}]}], "Input",
 CellChangeTimes->{{3.497533772515625*^9, 3.4975337860625*^9}, {
   3.499032326171875*^9, 3.499032333359375*^9}, 3.506122816426*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "0.`", "None"},
    {"1", 
     RowBox[{"-", "7.363`"}], "7.363`"},
    {"2", 
     RowBox[{"-", "19.843`"}], "12.48`"},
    {"3", 
     RowBox[{"-", "27.776`"}], "7.933`"},
    {"4", 
     RowBox[{"-", "38.906`"}], "11.13`"},
    {"5", 
     RowBox[{"-", "46.321`"}], "7.415`"},
    {"6", 
     RowBox[{"-", "56.715`"}], "10.394`"},
    {"7", 
     RowBox[{"-", "63.991`"}], "7.276`"},
    {"8", 
     RowBox[{"-", "73.936`"}], "9.945`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.499032330171875*^9, 3.49903233375*^9}, 
   3.506122816926*^9, 3.507512419078125*^9}]
}, Open  ]],

Cell["\<\
Theory data -- here we define a formula to calculate the data points\
\>", "Text",
 CellChangeTimes->{{3.497533795484375*^9, 3.497533798359375*^9}, {
  3.499022977921875*^9, 3.4990229785625*^9}, {3.506122759816625*^9, 
  3.506122774441625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"EGSSeniority", "[", 
    RowBox[{"G_", ",", "Omega_", ",", 
     RowBox[{"N_", "?", "EvenQ"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", "4"}], "*", "G", "*", "N", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", "Omega"}], "-", "N", "+", "2"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EGSSeniority", "[", 
    RowBox[{"G_", ",", "Omega_", ",", 
     RowBox[{"N_", "?", "OddQ"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", "4"}], "*", "G", "*", 
    RowBox[{"(", 
     RowBox[{"N", "-", "1"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", "Omega"}], "-", "N", "+", "1"}], ")"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SeniorityData", "[", 
    RowBox[{"epsilon_", ",", "G_"}], "]"}], ":=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"N", ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"N", "*", "epsilon"}], "+", 
        RowBox[{"EGSSeniority", "[", 
         RowBox[{"G", ",", "4", ",", "N"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"N", ">", "0"}], ",", "\[IndentingNewLine]", 
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"epsilon", "+", 
            RowBox[{"EGSSeniority", "[", 
             RowBox[{"G", ",", "4", ",", "N"}], "]"}], "-", 
            RowBox[{"EGSSeniority", "[", 
             RowBox[{"G", ",", "4", ",", 
              RowBox[{"N", "-", "1"}]}], "]"}]}], ")"}]}], ",", 
         "\[IndentingNewLine]", "None"}], "\[IndentingNewLine]", "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"N", ",", "0", ",", "8"}], "}"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.497386481109375*^9, 3.49738654365625*^9}, {
   3.499032316546875*^9, 3.499032338875*^9}, 3.506122779504125*^9}],

Cell["\<\
And let us store the results...\
\>", "Text",
 CellChangeTimes->{{3.50612278101975*^9, 3.506122786316625*^9}, {
  3.506122825801*^9, 3.506122833566625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"TheoryData", "=", 
   RowBox[{"SeniorityData", "[", 
    RowBox[{
     RowBox[{"-", "9.323"}], ",", "0.75"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "TableForm"}]}], "Input",
 CellChangeTimes->{{3.497386481109375*^9, 3.49738654365625*^9}, {
  3.499032316546875*^9, 3.499032338875*^9}, {3.506122779504125*^9, 
  3.506122809222875*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "0.`", "None"},
    {"1", 
     RowBox[{"-", "9.323`"}], "9.323`"},
    {"2", 
     RowBox[{"-", "21.646`"}], "12.323`"},
    {"3", 
     RowBox[{"-", "30.219`"}], "8.573`"},
    {"4", 
     RowBox[{"-", "41.792`"}], "11.573`"},
    {"5", 
     RowBox[{"-", "49.615`"}], "7.823`"},
    {"6", 
     RowBox[{"-", "60.438`"}], "10.823`"},
    {"7", 
     RowBox[{"-", "67.511`"}], "7.073`"},
    {"8", 
     RowBox[{"-", "77.584`"}], "10.073`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.49903231146875*^9, 3.4990323391875*^9}, {
   3.506122809972875*^9, 3.506122834660375*^9}, 3.506122932566625*^9, 
   3.507512419140625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "8"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"YPlotRanges", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "80"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "13"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Margin", "\[Rule]", "40"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XFrameTicks", "\[Rule]", 
        RowBox[{"LinTicks", "[", 
         RowBox[{"0", ",", "8", ",", "1", ",", "1"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ExtendRange", "\[Rule]", "0.03"}], ",", "\[IndentingNewLine]", 
       RowBox[{"XFrameLabels", "\[Rule]", "\"\<\!\(\*
StyleBox[\"N\",
FontSlant->\"Italic\"]\)\>\""}], ",", 
       RowBox[{"BufferB", "\[Rule]", "3.5"}], ",", "\[IndentingNewLine]", 
       RowBox[{"YFrameLabels", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*
StyleBox[\"E\",
FontSlant->\"Italic\"]\) (MeV)\>\"", ",", "\"\<\!\(\*
StyleBox[SubscriptBox[\"S\", \"n\"],
FontSlant->\"Italic\"]\) (MeV)\>\""}], "}"}]}], ",", 
       RowBox[{"BufferL", "\[Rule]", "4.5"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PanelLetterCorner", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Background", "\[Rule]", "Moccasin"}]}], "\[IndentingNewLine]",
       "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "define", " ", "common", " ", "data", " ", "styles", " ", "in", " ", 
        "advance"}], ",", " ", 
       RowBox[{
       "to", " ", "be", " ", "used", " ", "systematically", " ", "across", 
        " ", "the", " ", "plots"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataSymbol", ",", 
       RowBox[{"SymbolSize", "\[Rule]", "4"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DefineDataStyle", "[", 
      RowBox[{"\"\<expt\>\"", ",", 
       RowBox[{"DataLine", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Dashing", "\[Rule]", "True"}], "}"}]}], ",", 
       RowBox[{"DataSymbol", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"SymbolShape", "\[Rule]", "\"\<Cross\>\""}], ",", 
          RowBox[{"Thickness", "\[Rule]", "1.5"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DefineDataStyle", "[", 
      RowBox[{"\"\<theory\>\"", ",", 
       RowBox[{"DataSymbol", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"FillColor", "\[Rule]", "Firebrick"}], "}"}]}]}], "]"}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"panel", " ", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"DataPlot", "[", 
      RowBox[{"ExptData", ",", 
       RowBox[{"DataStyle", "\[Rule]", "\"\<expt\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DataPlot", "[", 
      RowBox[{"TheoryData", ",", 
       RowBox[{"DataStyle", "\[Rule]", "\"\<theory\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"legend", " ", "in", " ", "panel", " ", "1"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"DataLegend", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1", ",", "0.45"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<expt\>\"", ",", "\"\<Experiment\>\""}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"\"\<theory\>\"", ",", "\"\<Theory\>\""}], "}"}]}], 
        "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"panel", " ", "2"}], "  ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"DataPlot", "[", 
      RowBox[{
       RowBox[{"DataSet", "[", 
        RowBox[{"ExptData", ",", 
         RowBox[{"DataColumns", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}]}], "]"}], ",", 
       RowBox[{"DataStyle", "\[Rule]", "\"\<expt\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DataPlot", "[", 
      RowBox[{
       RowBox[{"DataSet", "[", 
        RowBox[{"TheoryData", ",", 
         RowBox[{"DataColumns", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}]}], "]"}], ",", 
       RowBox[{"DataStyle", "\[Rule]", "\"\<theory\>\""}]}], "]"}], ","}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.497386370734375*^9, 3.4973864339375*^9}, {
   3.49738655390625*^9, 3.49738663646875*^9}, {3.497386683296875*^9, 
   3.49738679415625*^9}, {3.49738683240625*^9, 3.49738685209375*^9}, {
   3.497386890296875*^9, 3.49738694628125*^9}, 3.49738699465625*^9, {
   3.49738712934375*^9, 3.497387178625*^9}, {3.497387243171875*^9, 
   3.497387299078125*^9}, {3.497533905109375*^9, 3.497534044890625*^9}, {
   3.497534259171875*^9, 3.497534510546875*^9}, {3.497534563609375*^9, 
   3.497534623078125*^9}, {3.497534691515625*^9, 3.49753469965625*^9}, {
   3.499032350640625*^9, 3.499032410609375*^9}, {3.506122840316625*^9, 
   3.506122851129125*^9}, {3.506122922191625*^9, 3.5061229848635*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
    RectangleBox[{0.11103333333333333`, 0.5}, \
{0.8889666666666667, 0.8889666666666667}]}, 
   {RGBColor[1., 0.894101, 0.709799], Opacity[1], 
    RectangleBox[{0.11103333333333333`, 0.11103333333333332`}, \
{0.8889666666666667, 0.5}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.11103333333333333`, 0.5}, {0.8889666666666667, 0.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1330503144654088, 0.510002}, {0.1330503144654088, 
     0.5}}], LineBox[{{0.2247877358490566, 0.510002}, {0.2247877358490566, 
     0.5}}], LineBox[{{0.31652515723270436`, 0.510002}, {0.31652515723270436`,
      0.5}}], LineBox[{{0.4082625786163522, 0.510002}, {0.4082625786163522, 
     0.5}}], LineBox[{{0.5, 0.510002}, {0.5, 0.5}}], 
    LineBox[{{0.5917374213836478, 0.510002}, {0.5917374213836478, 0.5}}], 
    LineBox[{{0.6834748427672955, 0.510002}, {0.6834748427672955, 0.5}}], 
    LineBox[{{0.7752122641509434, 0.510002}, {0.7752122641509434, 0.5}}], 
    LineBox[{{0.8669496855345912, 0.510002}, {0.8669496855345912, 0.5}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.11103333333333333`, 0.5}, {0.11103333333333333`, 
     0.8889666666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.12103533333333333`, 0.5110084905660378}, {
     0.11103333333333333`, 0.5110084905660378}}], 
    LineBox[{{0.11603433333333334`, 0.5339428459119497}, {
     0.11103333333333333`, 0.5339428459119497}}], 
    LineBox[{{0.11603433333333334`, 0.5568772012578617}, {
     0.11103333333333333`, 0.5568772012578617}}], 
    LineBox[{{0.11603433333333334`, 0.5798115566037736}, {
     0.11103333333333333`, 0.5798115566037736}}], 
    LineBox[{{0.12103533333333333`, 0.6027459119496856}, {
     0.11103333333333333`, 0.6027459119496856}}], 
    LineBox[{{0.11603433333333334`, 0.6256802672955976}, {
     0.11103333333333333`, 0.6256802672955976}}], 
    LineBox[{{0.11603433333333334`, 0.6486146226415095}, {
     0.11103333333333333`, 0.6486146226415095}}], 
    LineBox[{{0.11603433333333334`, 0.6715489779874214}, {
     0.11103333333333333`, 0.6715489779874214}}], 
    LineBox[{{0.12103533333333333`, 0.6944833333333333}, {
     0.11103333333333333`, 0.6944833333333333}}], 
    LineBox[{{0.11603433333333334`, 0.7174176886792454}, {
     0.11103333333333333`, 0.7174176886792454}}], 
    LineBox[{{0.11603433333333334`, 0.7403520440251573}, {
     0.11103333333333333`, 0.7403520440251573}}], 
    LineBox[{{0.11603433333333334`, 0.7632863993710692}, {
     0.11103333333333333`, 0.7632863993710692}}], 
    LineBox[{{0.12103533333333333`, 0.7862207547169812}, {
     0.11103333333333333`, 0.7862207547169812}}], 
    LineBox[{{0.11603433333333334`, 0.8091551100628931}, {
     0.11103333333333333`, 0.8091551100628931}}], 
    LineBox[{{0.11603433333333334`, 0.8320894654088051}, {
     0.11103333333333333`, 0.8320894654088051}}], 
    LineBox[{{0.11603433333333334`, 0.8550238207547171}, {
     0.11103333333333333`, 0.8550238207547171}}], 
    LineBox[{{0.12103533333333333`, 0.877958176100629}, {0.11103333333333333`,
      0.877958176100629}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.11103333333333333`, 0.8889666666666667}, {
     0.8889666666666667, 0.8889666666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.1330503144654088, 0.8789646666666667}, {
     0.1330503144654088, 0.8889666666666667}}], 
    LineBox[{{0.2247877358490566, 0.8789646666666667}, {0.2247877358490566, 
     0.8889666666666667}}], 
    LineBox[{{0.31652515723270436`, 0.8789646666666667}, {
     0.31652515723270436`, 0.8889666666666667}}], 
    LineBox[{{0.4082625786163522, 0.8789646666666667}, {0.4082625786163522, 
     0.8889666666666667}}], 
    LineBox[{{0.5, 0.8789646666666667}, {0.5, 0.8889666666666667}}], 
    LineBox[{{0.5917374213836478, 0.8789646666666667}, {0.5917374213836478, 
     0.8889666666666667}}], 
    LineBox[{{0.6834748427672955, 0.8789646666666667}, {0.6834748427672955, 
     0.8889666666666667}}], 
    LineBox[{{0.7752122641509434, 0.8789646666666667}, {0.7752122641509434, 
     0.8889666666666667}}], 
    LineBox[{{0.8669496855345912, 0.8789646666666667}, {0.8669496855345912, 
     0.8889666666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.8889666666666667, 0.5}, {0.8889666666666667, 
     0.8889666666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.8789646666666667, 0.5110084905660378}, {
     0.8889666666666667, 0.5110084905660378}}], 
    LineBox[{{0.8839656666666666, 0.5339428459119497}, {0.8889666666666667, 
     0.5339428459119497}}], 
    LineBox[{{0.8839656666666666, 0.5568772012578617}, {0.8889666666666667, 
     0.5568772012578617}}], 
    LineBox[{{0.8839656666666666, 0.5798115566037736}, {0.8889666666666667, 
     0.5798115566037736}}], 
    LineBox[{{0.8789646666666667, 0.6027459119496856}, {0.8889666666666667, 
     0.6027459119496856}}], 
    LineBox[{{0.8839656666666666, 0.6256802672955976}, {0.8889666666666667, 
     0.6256802672955976}}], 
    LineBox[{{0.8839656666666666, 0.6486146226415095}, {0.8889666666666667, 
     0.6486146226415095}}], 
    LineBox[{{0.8839656666666666, 0.6715489779874214}, {0.8889666666666667, 
     0.6715489779874214}}], 
    LineBox[{{0.8789646666666667, 0.6944833333333333}, {0.8889666666666667, 
     0.6944833333333333}}], 
    LineBox[{{0.8839656666666666, 0.7174176886792454}, {0.8889666666666667, 
     0.7174176886792454}}], 
    LineBox[{{0.8839656666666666, 0.7403520440251573}, {0.8889666666666667, 
     0.7403520440251573}}], 
    LineBox[{{0.8839656666666666, 0.7632863993710692}, {0.8889666666666667, 
     0.7632863993710692}}], 
    LineBox[{{0.8789646666666667, 0.7862207547169812}, {0.8889666666666667, 
     0.7862207547169812}}], 
    LineBox[{{0.8839656666666666, 0.8091551100628931}, {0.8889666666666667, 
     0.8091551100628931}}], 
    LineBox[{{0.8839656666666666, 0.8320894654088051}, {0.8889666666666667, 
     0.8320894654088051}}], 
    LineBox[{{0.8839656666666666, 0.8550238207547171}, {0.8889666666666667, 
     0.8550238207547171}}], 
    LineBox[{{0.8789646666666667, 0.877958176100629}, {0.8889666666666667, 
     0.877958176100629}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}], 
    CapForm[None], 
    LineBox[{{0.1330503144654088, 0.877958176100629}, {0.2247877358490566, 
     0.844185044418239}, {0.31652515723270436`, 0.7869408934748429}, {
     0.4082625786163522, 0.7505532452830189}, {0.5, 0.699501370283019}, {
     0.5917374213836478, 0.6654897213050315}, {0.6834748427672955, 
     0.6178137834119497}, {0.7752122641509434, 0.5844397095125786}, {
     0.8669496855345912, 0.5388232767295598}}]}, 
   {GrayLevel[0], AbsoluteThickness[1.5], Opacity[1], Dashing[{}], CapForm[
    None], {}, 
    {GrayLevel[0], Opacity[1], 
     PolygonBox[{{0.1330503144654088, 0.877958176100629}, {0.1283353264484569,
       0.8826731641175809}, {0.1330503144654088, 0.877958176100629}, {
      0.1283353264484569, 0.8732431880836771}, {0.1330503144654088, 
      0.877958176100629}, {0.13776530248236069`, 0.8732431880836771}, {
      0.1330503144654088, 0.877958176100629}, {0.13776530248236069`, 
      0.8826731641175809}, {0.1330503144654088, 0.877958176100629}}], 
     PolygonBox[{{0.2247877358490566, 0.844185044418239}, {0.2200727478321047,
       0.848900032435191}, {0.2247877358490566, 0.844185044418239}, {
      0.2200727478321047, 0.8394700564012871}, {0.2247877358490566, 
      0.844185044418239}, {0.22950272386600848`, 0.8394700564012871}, {
      0.2247877358490566, 0.844185044418239}, {0.22950272386600848`, 
      0.848900032435191}, {0.2247877358490566, 0.844185044418239}}], 
     PolygonBox[{{0.31652515723270436`, 0.7869408934748429}, {
      0.31181016921575244`, 0.7916558814917948}, {0.31652515723270436`, 
      0.7869408934748429}, {0.31181016921575244`, 0.782225905457891}, {
      0.31652515723270436`, 0.7869408934748429}, {0.3212401452496563, 
      0.782225905457891}, {0.31652515723270436`, 0.7869408934748429}, {
      0.3212401452496563, 0.7916558814917948}, {0.31652515723270436`, 
      0.7869408934748429}}], 
     PolygonBox[{{0.4082625786163522, 0.7505532452830189}, {
      0.40354759059940026`, 0.7552682332999708}, {0.4082625786163522, 
      0.7505532452830189}, {0.40354759059940026`, 0.745838257266067}, {
      0.4082625786163522, 0.7505532452830189}, {0.4129775666333041, 
      0.745838257266067}, {0.4082625786163522, 0.7505532452830189}, {
      0.4129775666333041, 0.7552682332999708}, {0.4082625786163522, 
      0.7505532452830189}}], 
     PolygonBox[{{0.5, 0.699501370283019}, {0.4952850119830481, 
      0.7042163582999709}, {0.5, 0.699501370283019}, {0.4952850119830481, 
      0.694786382266067}, {0.5, 0.699501370283019}, {0.5047149880169519, 
      0.694786382266067}, {0.5, 0.699501370283019}, {0.5047149880169519, 
      0.7042163582999709}, {0.5, 0.699501370283019}}], 
     PolygonBox[{{0.5917374213836478, 0.6654897213050315}, {
      0.5870224333666959, 0.6702047093219834}, {0.5917374213836478, 
      0.6654897213050315}, {0.5870224333666959, 0.6607747332880796}, {
      0.5917374213836478, 0.6654897213050315}, {0.5964524094005997, 
      0.6607747332880796}, {0.5917374213836478, 0.6654897213050315}, {
      0.5964524094005997, 0.6702047093219834}, {0.5917374213836478, 
      0.6654897213050315}}], 
     PolygonBox[{{0.6834748427672955, 0.6178137834119497}, {
      0.6787598547503436, 0.6225287714289016}, {0.6834748427672955, 
      0.6178137834119497}, {0.6787598547503436, 0.6130987953949978}, {
      0.6834748427672955, 0.6178137834119497}, {0.6881898307842474, 
      0.6130987953949978}, {0.6834748427672955, 0.6178137834119497}, {
      0.6881898307842474, 0.6225287714289016}, {0.6834748427672955, 
      0.6178137834119497}}], 
     PolygonBox[{{0.7752122641509434, 0.5844397095125786}, {
      0.7704972761339914, 0.5891546975295305}, {0.7752122641509434, 
      0.5844397095125786}, {0.7704972761339914, 0.5797247214956267}, {
      0.7752122641509434, 0.5844397095125786}, {0.7799272521678953, 
      0.5797247214956267}, {0.7752122641509434, 0.5844397095125786}, {
      0.7799272521678953, 0.5891546975295305}, {0.7752122641509434, 
      0.5844397095125786}}], 
     PolygonBox[{{0.8669496855345912, 0.5388232767295598}, {
      0.8622346975176393, 0.5435382647465117}, {0.8669496855345912, 
      0.5388232767295598}, {0.8622346975176393, 0.5341082887126078}, {
      0.8669496855345912, 0.5388232767295598}, {0.8716646735515431, 
      0.5341082887126078}, {0.8669496855345912, 0.5388232767295598}, {
      0.8716646735515431, 0.5435382647465117}, {0.8669496855345912, 
      0.5388232767295598}}]}, 
    {GrayLevel[0], AbsoluteThickness[1.5], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.1330503144654088, 0.877958176100629}, {
      0.1283353264484569, 0.8826731641175809}, {0.1330503144654088, 
      0.877958176100629}, {0.1283353264484569, 0.8732431880836771}, {
      0.1330503144654088, 0.877958176100629}, {0.13776530248236069`, 
      0.8732431880836771}, {0.1330503144654088, 0.877958176100629}, {
      0.13776530248236069`, 0.8826731641175809}, {0.1330503144654088, 
      0.877958176100629}, {0.1330503144654088, 0.877958176100629}}], 
     LineBox[{{0.2247877358490566, 0.844185044418239}, {0.2200727478321047, 
      0.848900032435191}, {0.2247877358490566, 0.844185044418239}, {
      0.2200727478321047, 0.8394700564012871}, {0.2247877358490566, 
      0.844185044418239}, {0.22950272386600848`, 0.8394700564012871}, {
      0.2247877358490566, 0.844185044418239}, {0.22950272386600848`, 
      0.848900032435191}, {0.2247877358490566, 0.844185044418239}, {
      0.2247877358490566, 0.844185044418239}}], 
     LineBox[{{0.31652515723270436`, 0.7869408934748429}, {
      0.31181016921575244`, 0.7916558814917948}, {0.31652515723270436`, 
      0.7869408934748429}, {0.31181016921575244`, 0.782225905457891}, {
      0.31652515723270436`, 0.7869408934748429}, {0.3212401452496563, 
      0.782225905457891}, {0.31652515723270436`, 0.7869408934748429}, {
      0.3212401452496563, 0.7916558814917948}, {0.31652515723270436`, 
      0.7869408934748429}, {0.31652515723270436`, 0.7869408934748429}}], 
     LineBox[{{0.4082625786163522, 0.7505532452830189}, {0.40354759059940026`,
       0.7552682332999708}, {0.4082625786163522, 0.7505532452830189}, {
      0.40354759059940026`, 0.745838257266067}, {0.4082625786163522, 
      0.7505532452830189}, {0.4129775666333041, 0.745838257266067}, {
      0.4082625786163522, 0.7505532452830189}, {0.4129775666333041, 
      0.7552682332999708}, {0.4082625786163522, 0.7505532452830189}, {
      0.4082625786163522, 0.7505532452830189}}], 
     LineBox[{{0.5, 0.699501370283019}, {0.4952850119830481, 
      0.7042163582999709}, {0.5, 0.699501370283019}, {0.4952850119830481, 
      0.694786382266067}, {0.5, 0.699501370283019}, {0.5047149880169519, 
      0.694786382266067}, {0.5, 0.699501370283019}, {0.5047149880169519, 
      0.7042163582999709}, {0.5, 0.699501370283019}, {0.5, 
      0.699501370283019}}], 
     LineBox[{{0.5917374213836478, 0.6654897213050315}, {0.5870224333666959, 
      0.6702047093219834}, {0.5917374213836478, 0.6654897213050315}, {
      0.5870224333666959, 0.6607747332880796}, {0.5917374213836478, 
      0.6654897213050315}, {0.5964524094005997, 0.6607747332880796}, {
      0.5917374213836478, 0.6654897213050315}, {0.5964524094005997, 
      0.6702047093219834}, {0.5917374213836478, 0.6654897213050315}, {
      0.5917374213836478, 0.6654897213050315}}], 
     LineBox[{{0.6834748427672955, 0.6178137834119497}, {0.6787598547503436, 
      0.6225287714289016}, {0.6834748427672955, 0.6178137834119497}, {
      0.6787598547503436, 0.6130987953949978}, {0.6834748427672955, 
      0.6178137834119497}, {0.6881898307842474, 0.6130987953949978}, {
      0.6834748427672955, 0.6178137834119497}, {0.6881898307842474, 
      0.6225287714289016}, {0.6834748427672955, 0.6178137834119497}, {
      0.6834748427672955, 0.6178137834119497}}], 
     LineBox[{{0.7752122641509434, 0.5844397095125786}, {0.7704972761339914, 
      0.5891546975295305}, {0.7752122641509434, 0.5844397095125786}, {
      0.7704972761339914, 0.5797247214956267}, {0.7752122641509434, 
      0.5844397095125786}, {0.7799272521678953, 0.5797247214956267}, {
      0.7752122641509434, 0.5844397095125786}, {0.7799272521678953, 
      0.5891546975295305}, {0.7752122641509434, 0.5844397095125786}, {
      0.7752122641509434, 0.5844397095125786}}], 
     LineBox[{{0.8669496855345912, 0.5388232767295598}, {0.8622346975176393, 
      0.5435382647465117}, {0.8669496855345912, 0.5388232767295598}, {
      0.8622346975176393, 0.5341082887126078}, {0.8669496855345912, 
      0.5388232767295598}, {0.8716646735515431, 0.5341082887126078}, {
      0.8669496855345912, 0.5388232767295598}, {0.8716646735515431, 
      0.5435382647465117}, {0.8669496855345912, 0.5388232767295598}, {
      0.8669496855345912, 0.5388232767295598}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.1330503144654088, 0.877958176100629}, {
      0.2247877358490566, 0.8351947771226416}, {0.31652515723270436`, 
      0.778670764937107}, {0.4082625786163522, 0.7393475192610064}, {0.5, 
      0.6862636603773585}, {0.5917374213836478, 0.6503805680031447}, {
      0.6834748427672955, 0.6007368624213837}, {0.7752122641509434, 
      0.5682939233490567}, {0.8669496855345912, 0.5220903710691824}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], {}, 
     {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
      PolygonBox[{{0.13818400506772985`, 0.8800846203731376}, {
       0.13697947114620204`, 0.8818873327814223}, {0.13517675873791749`, 
       0.88309186670295}, {0.1330503144654088, 0.8835148427672956}, {
       0.1309238701929001, 0.88309186670295}, {0.12912115778461555`, 
       0.8818873327814223}, {0.12791662386308775`, 0.8800846203731376}, {
       0.12749364779874214`, 0.877958176100629}, {0.12791662386308775`, 
       0.8758317318281204}, {0.12912115778461555`, 0.8740290194198357}, {
       0.1309238701929001, 0.8728244854983079}, {0.1330503144654088, 
       0.8724015094339623}, {0.13517675873791749`, 0.8728244854983079}, {
       0.13697947114620204`, 0.8740290194198357}, {0.13818400506772985`, 
       0.8758317318281204}, {0.13860698113207545`, 0.877958176100629}}], 
      PolygonBox[{{0.22992142645137764`, 0.8373212213951502}, {
       0.22871689252984984`, 0.8391239338034349}, {0.22691418012156528`, 
       0.8403284677249626}, {0.2247877358490566, 0.8407514437893082}, {
       0.2226612915765479, 0.8403284677249626}, {0.22085857916826335`, 
       0.8391239338034349}, {0.21965404524673554`, 0.8373212213951502}, {
       0.21923106918238994`, 0.8351947771226416}, {0.21965404524673554`, 
       0.8330683328501329}, {0.22085857916826335`, 0.8312656204418483}, {
       0.2226612915765479, 0.8300610865203205}, {0.2247877358490566, 
       0.8296381104559749}, {0.22691418012156528`, 0.8300610865203205}, {
       0.22871689252984984`, 0.8312656204418483}, {0.22992142645137764`, 
       0.8330683328501329}, {0.23034440251572325`, 0.8351947771226416}}], 
      PolygonBox[{{0.3216588478350254, 0.7807972092096156}, {
       0.3204543139134976, 0.7825999216179003}, {0.31865160150521304`, 
       0.783804455539428}, {0.31652515723270436`, 0.7842274316037736}, {
       0.31439871296019567`, 0.783804455539428}, {0.3125960005519111, 
       0.7825999216179003}, {0.3113914666303833, 0.7807972092096156}, {
       0.3109684905660377, 0.778670764937107}, {0.3113914666303833, 
       0.7765443206645983}, {0.3125960005519111, 0.7747416082563137}, {
       0.31439871296019567`, 0.7735370743347859}, {0.31652515723270436`, 
       0.7731140982704403}, {0.31865160150521304`, 0.7735370743347859}, {
       0.3204543139134976, 0.7747416082563137}, {0.3216588478350254, 
       0.7765443206645983}, {0.322081823899371, 0.778670764937107}}], 
      PolygonBox[{{0.41339626921867323`, 0.741473963533515}, {
       0.4121917352971454, 0.7432766759417997}, {0.41038902288886087`, 
       0.7444812098633274}, {0.4082625786163522, 0.744904185927673}, {
       0.4061361343438435, 0.7444812098633274}, {0.40433342193555893`, 
       0.7432766759417997}, {0.40312888801403113`, 0.741473963533515}, {
       0.4027059119496855, 0.7393475192610064}, {0.40312888801403113`, 
       0.7372210749884978}, {0.40433342193555893`, 0.7354183625802131}, {
       0.4061361343438435, 0.7342138286586853}, {0.4082625786163522, 
       0.7337908525943397}, {0.41038902288886087`, 0.7342138286586853}, {
       0.4121917352971454, 0.7354183625802131}, {0.41339626921867323`, 
       0.7372210749884978}, {0.41381924528301883`, 0.7393475192610064}}], 
      PolygonBox[{{0.505133690602321, 0.6883901046498672}, {
       0.5039291566807933, 0.6901928170581518}, {0.5021264442725086, 
       0.6913973509796796}, {0.5, 0.6918203270440252}, {0.4978735557274913, 
       0.6913973509796796}, {0.49607084331920676`, 0.6901928170581518}, {
       0.49486630939767895`, 0.6883901046498672}, {0.49444333333333335`, 
       0.6862636603773585}, {0.49486630939767895`, 0.6841372161048499}, {
       0.49607084331920676`, 0.6823345036965652}, {0.4978735557274913, 
       0.6811299697750375}, {0.5, 0.6807069937106919}, {0.5021264442725086, 
       0.6811299697750375}, {0.5039291566807933, 0.6823345036965652}, {
       0.505133690602321, 0.6841372161048499}, {0.5055566666666667, 
       0.6862636603773585}}], 
      PolygonBox[{{0.5968711119859689, 0.6525070122756533}, {
       0.5956665780644411, 0.654309724683938}, {0.5938638656561565, 
       0.6555142586054657}, {0.5917374213836478, 0.6559372346698114}, {
       0.5896109771111392, 0.6555142586054657}, {0.5878082647028545, 
       0.654309724683938}, {0.5866037307813268, 0.6525070122756533}, {
       0.5861807547169812, 0.6503805680031447}, {0.5866037307813268, 
       0.6482541237306361}, {0.5878082647028545, 0.6464514113223514}, {
       0.5896109771111392, 0.6452468774008236}, {0.5917374213836478, 
       0.644823901336478}, {0.5938638656561565, 0.6452468774008236}, {
       0.5956665780644411, 0.6464514113223514}, {0.5968711119859689, 
       0.6482541237306361}, {0.5972940880503145, 0.6503805680031447}}], 
      PolygonBox[{{0.6886085333696166, 0.6028633066938923}, {
       0.6874039994480888, 0.604666019102177}, {0.6856012870398042, 
       0.6058705530237047}, {0.6834748427672955, 0.6062935290880503}, {
       0.6813483984947869, 0.6058705530237047}, {0.6795456860865022, 
       0.604666019102177}, {0.6783411521649745, 0.6028633066938923}, {
       0.6779181761006289, 0.6007368624213837}, {0.6783411521649745, 
       0.5986104181488751}, {0.6795456860865022, 0.5968077057405904}, {
       0.6813483984947869, 0.5956031718190626}, {0.6834748427672955, 
       0.595180195754717}, {0.6856012870398042, 0.5956031718190626}, {
       0.6874039994480888, 0.5968077057405904}, {0.6886085333696166, 
       0.5986104181488751}, {0.6890315094339622, 0.6007368624213837}}], 
      PolygonBox[{{0.7803459547532644, 0.5704203676215653}, {
       0.7791414208317367, 0.57222308002985}, {0.777338708423452, 
       0.5734276139513778}, {0.7752122641509434, 0.5738505900157234}, {
       0.7730858198784347, 0.5734276139513778}, {0.77128310747015, 
       0.57222308002985}, {0.7700785735486223, 0.5704203676215653}, {
       0.7696555974842767, 0.5682939233490567}, {0.7700785735486223, 
       0.5661674790765481}, {0.77128310747015, 0.5643647666682634}, {
       0.7730858198784347, 0.5631602327467357}, {0.7752122641509434, 
       0.56273725668239}, {0.777338708423452, 0.5631602327467357}, {
       0.7791414208317367, 0.5643647666682634}, {0.7803459547532644, 
       0.5661674790765481}, {0.78076893081761, 0.5682939233490567}}], 
      PolygonBox[{{0.8720833761369122, 0.5242168153416911}, {
       0.8708788422153845, 0.5260195277499757}, {0.8690761298070998, 
       0.5272240616715035}, {0.8669496855345912, 0.5276470377358491}, {
       0.8648232412620825, 0.5272240616715035}, {0.8630205288537979, 
       0.5260195277499757}, {0.8618159949322701, 0.5242168153416911}, {
       0.8613930188679245, 0.5220903710691824}, {0.8618159949322701, 
       0.5199639267966738}, {0.8630205288537979, 0.5181612143883891}, {
       0.8648232412620825, 0.5169566804668614}, {0.8669496855345912, 
       0.5165337044025158}, {0.8690761298070998, 0.5169566804668614}, {
       0.8708788422153845, 0.5181612143883891}, {0.8720833761369122, 
       0.5199639267966738}, {0.8725063522012578, 0.5220903710691824}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.13818400506772985`, 0.8800846203731376}, {
       0.13697947114620204`, 0.8818873327814223}, {0.13517675873791749`, 
       0.88309186670295}, {0.1330503144654088, 0.8835148427672956}, {
       0.1309238701929001, 0.88309186670295}, {0.12912115778461555`, 
       0.8818873327814223}, {0.12791662386308775`, 0.8800846203731376}, {
       0.12749364779874214`, 0.877958176100629}, {0.12791662386308775`, 
       0.8758317318281204}, {0.12912115778461555`, 0.8740290194198357}, {
       0.1309238701929001, 0.8728244854983079}, {0.1330503144654088, 
       0.8724015094339623}, {0.13517675873791749`, 0.8728244854983079}, {
       0.13697947114620204`, 0.8740290194198357}, {0.13818400506772985`, 
       0.8758317318281204}, {0.13860698113207545`, 0.877958176100629}, {
       0.13818400506772985`, 0.8800846203731376}}], 
      LineBox[{{0.22992142645137764`, 0.8373212213951502}, {
       0.22871689252984984`, 0.8391239338034349}, {0.22691418012156528`, 
       0.8403284677249626}, {0.2247877358490566, 0.8407514437893082}, {
       0.2226612915765479, 0.8403284677249626}, {0.22085857916826335`, 
       0.8391239338034349}, {0.21965404524673554`, 0.8373212213951502}, {
       0.21923106918238994`, 0.8351947771226416}, {0.21965404524673554`, 
       0.8330683328501329}, {0.22085857916826335`, 0.8312656204418483}, {
       0.2226612915765479, 0.8300610865203205}, {0.2247877358490566, 
       0.8296381104559749}, {0.22691418012156528`, 0.8300610865203205}, {
       0.22871689252984984`, 0.8312656204418483}, {0.22992142645137764`, 
       0.8330683328501329}, {0.23034440251572325`, 0.8351947771226416}, {
       0.22992142645137764`, 0.8373212213951502}}], 
      LineBox[{{0.3216588478350254, 0.7807972092096156}, {0.3204543139134976, 
       0.7825999216179003}, {0.31865160150521304`, 0.783804455539428}, {
       0.31652515723270436`, 0.7842274316037736}, {0.31439871296019567`, 
       0.783804455539428}, {0.3125960005519111, 0.7825999216179003}, {
       0.3113914666303833, 0.7807972092096156}, {0.3109684905660377, 
       0.778670764937107}, {0.3113914666303833, 0.7765443206645983}, {
       0.3125960005519111, 0.7747416082563137}, {0.31439871296019567`, 
       0.7735370743347859}, {0.31652515723270436`, 0.7731140982704403}, {
       0.31865160150521304`, 0.7735370743347859}, {0.3204543139134976, 
       0.7747416082563137}, {0.3216588478350254, 0.7765443206645983}, {
       0.322081823899371, 0.778670764937107}, {0.3216588478350254, 
       0.7807972092096156}}], 
      LineBox[{{0.41339626921867323`, 0.741473963533515}, {0.4121917352971454,
        0.7432766759417997}, {0.41038902288886087`, 0.7444812098633274}, {
       0.4082625786163522, 0.744904185927673}, {0.4061361343438435, 
       0.7444812098633274}, {0.40433342193555893`, 0.7432766759417997}, {
       0.40312888801403113`, 0.741473963533515}, {0.4027059119496855, 
       0.7393475192610064}, {0.40312888801403113`, 0.7372210749884978}, {
       0.40433342193555893`, 0.7354183625802131}, {0.4061361343438435, 
       0.7342138286586853}, {0.4082625786163522, 0.7337908525943397}, {
       0.41038902288886087`, 0.7342138286586853}, {0.4121917352971454, 
       0.7354183625802131}, {0.41339626921867323`, 0.7372210749884978}, {
       0.41381924528301883`, 0.7393475192610064}, {0.41339626921867323`, 
       0.741473963533515}}], 
      LineBox[{{0.505133690602321, 0.6883901046498672}, {0.5039291566807933, 
       0.6901928170581518}, {0.5021264442725086, 0.6913973509796796}, {0.5, 
       0.6918203270440252}, {0.4978735557274913, 0.6913973509796796}, {
       0.49607084331920676`, 0.6901928170581518}, {0.49486630939767895`, 
       0.6883901046498672}, {0.49444333333333335`, 0.6862636603773585}, {
       0.49486630939767895`, 0.6841372161048499}, {0.49607084331920676`, 
       0.6823345036965652}, {0.4978735557274913, 0.6811299697750375}, {0.5, 
       0.6807069937106919}, {0.5021264442725086, 0.6811299697750375}, {
       0.5039291566807933, 0.6823345036965652}, {0.505133690602321, 
       0.6841372161048499}, {0.5055566666666667, 0.6862636603773585}, {
       0.505133690602321, 0.6883901046498672}}], 
      LineBox[{{0.5968711119859689, 0.6525070122756533}, {0.5956665780644411, 
       0.654309724683938}, {0.5938638656561565, 0.6555142586054657}, {
       0.5917374213836478, 0.6559372346698114}, {0.5896109771111392, 
       0.6555142586054657}, {0.5878082647028545, 0.654309724683938}, {
       0.5866037307813268, 0.6525070122756533}, {0.5861807547169812, 
       0.6503805680031447}, {0.5866037307813268, 0.6482541237306361}, {
       0.5878082647028545, 0.6464514113223514}, {0.5896109771111392, 
       0.6452468774008236}, {0.5917374213836478, 0.644823901336478}, {
       0.5938638656561565, 0.6452468774008236}, {0.5956665780644411, 
       0.6464514113223514}, {0.5968711119859689, 0.6482541237306361}, {
       0.5972940880503145, 0.6503805680031447}, {0.5968711119859689, 
       0.6525070122756533}}], 
      LineBox[{{0.6886085333696166, 0.6028633066938923}, {0.6874039994480888, 
       0.604666019102177}, {0.6856012870398042, 0.6058705530237047}, {
       0.6834748427672955, 0.6062935290880503}, {0.6813483984947869, 
       0.6058705530237047}, {0.6795456860865022, 0.604666019102177}, {
       0.6783411521649745, 0.6028633066938923}, {0.6779181761006289, 
       0.6007368624213837}, {0.6783411521649745, 0.5986104181488751}, {
       0.6795456860865022, 0.5968077057405904}, {0.6813483984947869, 
       0.5956031718190626}, {0.6834748427672955, 0.595180195754717}, {
       0.6856012870398042, 0.5956031718190626}, {0.6874039994480888, 
       0.5968077057405904}, {0.6886085333696166, 0.5986104181488751}, {
       0.6890315094339622, 0.6007368624213837}, {0.6886085333696166, 
       0.6028633066938923}}], 
      LineBox[{{0.7803459547532644, 0.5704203676215653}, {0.7791414208317367, 
       0.57222308002985}, {0.777338708423452, 0.5734276139513778}, {
       0.7752122641509434, 0.5738505900157234}, {0.7730858198784347, 
       0.5734276139513778}, {0.77128310747015, 0.57222308002985}, {
       0.7700785735486223, 0.5704203676215653}, {0.7696555974842767, 
       0.5682939233490567}, {0.7700785735486223, 0.5661674790765481}, {
       0.77128310747015, 0.5643647666682634}, {0.7730858198784347, 
       0.5631602327467357}, {0.7752122641509434, 0.56273725668239}, {
       0.777338708423452, 0.5631602327467357}, {0.7791414208317367, 
       0.5643647666682634}, {0.7803459547532644, 0.5661674790765481}, {
       0.78076893081761, 0.5682939233490567}, {0.7803459547532644, 
       0.5704203676215653}}], 
      LineBox[{{0.8720833761369122, 0.5242168153416911}, {0.8708788422153845, 
       0.5260195277499757}, {0.8690761298070998, 0.5272240616715035}, {
       0.8669496855345912, 0.5276470377358491}, {0.8648232412620825, 
       0.5272240616715035}, {0.8630205288537979, 0.5260195277499757}, {
       0.8618159949322701, 0.5242168153416911}, {0.8613930188679245, 
       0.5220903710691824}, {0.8618159949322701, 0.5199639267966738}, {
       0.8630205288537979, 0.5181612143883891}, {0.8648232412620825, 
       0.5169566804668614}, {0.8669496855345912, 0.5165337044025158}, {
       0.8690761298070998, 0.5169566804668614}, {0.8708788422153845, 
       0.5181612143883891}, {0.8720833761369122, 0.5199639267966738}, {
       0.8725063522012578, 0.5220903710691824}, {0.8720833761369122, 
       0.5242168153416911}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}],
       CapForm[None], 
      LineBox[{{0.18882666666666667`, 0.6583650000000001}, {
       0.24439333333333335`, 0.6583650000000001}}]}, 
     {GrayLevel[0], AbsoluteThickness[1.5], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.21661, 0.6583650000000001}, {0.2118950119830481, 
       0.663079988016952}, {0.21661, 0.6583650000000001}, {0.2118950119830481,
        0.6536500119830482}, {0.21661, 0.6583650000000001}, {
       0.22132498801695188`, 0.6536500119830482}, {0.21661, 
       0.6583650000000001}, {0.22132498801695188`, 0.663079988016952}, {
       0.21661, 0.6583650000000001}, {0.21661, 0.6583650000000001}}], 
      {GrayLevel[0], Opacity[1], 
       PolygonBox[{{0.21661, 0.6583650000000001}, {0.2118950119830481, 
        0.663079988016952}, {0.21661, 0.6583650000000001}, {
        0.2118950119830481, 0.6536500119830482}, {0.21661, 
        0.6583650000000001}, {0.22132498801695188`, 0.6536500119830482}, {
        0.21661, 0.6583650000000001}, {0.22132498801695188`, 
        0.663079988016952}, {0.21661, 0.6583650000000001}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.18882666666666667`, 0.6216910000000001}, {
        0.24439333333333335`, 0.6216910000000001}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.22174369060232105`, 0.6238174442725087}, {
        0.22053915668079324`, 0.6256201566807934}, {0.21873644427250868`, 
        0.6268246906023212}, {0.21661, 0.6272476666666668}, {
        0.2144835557274913, 0.6268246906023212}, {0.21268084331920675`, 
        0.6256201566807934}, {0.21147630939767895`, 0.6238174442725087}, {
        0.21105333333333334`, 0.6216910000000001}, {0.21147630939767895`, 
        0.6195645557274915}, {0.21268084331920675`, 0.6177618433192068}, {
        0.2144835557274913, 0.616557309397679}, {0.21661, 
        0.6161343333333335}, {0.21873644427250868`, 0.616557309397679}, {
        0.22053915668079324`, 0.6177618433192068}, {0.22174369060232105`, 
        0.6195645557274915}, {0.22216666666666665`, 0.6216910000000001}, {
        0.22174369060232105`, 0.6238174442725087}}], 
       {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
        PolygonBox[{{0.22174369060232105`, 0.6238174442725087}, {
         0.22053915668079324`, 0.6256201566807934}, {0.21873644427250868`, 
         0.6268246906023212}, {0.21661, 0.6272476666666668}, {
         0.2144835557274913, 0.6268246906023212}, {0.21268084331920675`, 
         0.6256201566807934}, {0.21147630939767895`, 0.6238174442725087}, {
         0.21105333333333334`, 0.6216910000000001}, {0.21147630939767895`, 
         0.6195645557274915}, {0.21268084331920675`, 0.6177618433192068}, {
         0.2144835557274913, 0.616557309397679}, {0.21661, 
         0.6161343333333335}, {0.21873644427250868`, 0.616557309397679}, {
         0.22053915668079324`, 0.6177618433192068}, {0.22174369060232105`, 
         0.6195645557274915}, {0.22216666666666665`, 0.6216910000000001}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.11103333333333333`, 0.11103333333333332`}, {
         0.8889666666666667, 0.11103333333333332`}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.1330503144654088, 0.12103533333333331`}, {
         0.1330503144654088, 0.11103333333333332`}}], 
        LineBox[{{0.2247877358490566, 0.12103533333333331`}, {
         0.2247877358490566, 0.11103333333333332`}}], 
        LineBox[{{0.31652515723270436`, 0.12103533333333331`}, {
         0.31652515723270436`, 0.11103333333333332`}}], 
        LineBox[{{0.4082625786163522, 0.12103533333333331`}, {
         0.4082625786163522, 0.11103333333333332`}}], 
        LineBox[{{0.5, 0.12103533333333331`}, {0.5, 0.11103333333333332`}}], 
        LineBox[{{0.5917374213836478, 0.12103533333333331`}, {
         0.5917374213836478, 0.11103333333333332`}}], 
        LineBox[{{0.6834748427672955, 0.12103533333333331`}, {
         0.6834748427672955, 0.11103333333333332`}}], 
        LineBox[{{0.7752122641509434, 0.12103533333333331`}, {
         0.7752122641509434, 0.11103333333333332`}}], 
        LineBox[{{0.8669496855345912, 0.12103533333333331`}, {
         0.8669496855345912, 0.11103333333333332`}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.11103333333333333`, 0.11103333333333332`}, {
         0.11103333333333333`, 0.5}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.11603433333333334`, 0.11155754716981126`}, {
         0.11103333333333333`, 0.11155754716981126`}}], 
        LineBox[{{0.12103533333333333`, 0.12204182389937102`}, {
         0.11103333333333333`, 0.12204182389937102`}}], 
        LineBox[{{0.11603433333333334`, 0.13252610062893078`}, {
         0.11103333333333333`, 0.13252610062893078`}}], 
        LineBox[{{0.11603433333333334`, 0.14301037735849054`}, {
         0.11103333333333333`, 0.14301037735849054`}}], 
        LineBox[{{0.11603433333333334`, 0.15349465408805024`}, {
         0.11103333333333333`, 0.15349465408805024`}}], 
        LineBox[{{0.11603433333333334`, 0.16397893081761}, {
         0.11103333333333333`, 0.16397893081761}}], 
        LineBox[{{0.12103533333333333`, 0.17446320754716976`}, {
         0.11103333333333333`, 0.17446320754716976`}}], 
        LineBox[{{0.11603433333333334`, 0.18494748427672952`}, {
         0.11103333333333333`, 0.18494748427672952`}}], 
        LineBox[{{0.11603433333333334`, 0.19543176100628928`}, {
         0.11103333333333333`, 0.19543176100628928`}}], 
        LineBox[{{0.11603433333333334`, 0.205916037735849}, {
         0.11103333333333333`, 0.205916037735849}}], 
        LineBox[{{0.11603433333333334`, 0.21640031446540875`}, {
         0.11103333333333333`, 0.21640031446540875`}}], 
        LineBox[{{0.12103533333333333`, 0.2268845911949685}, {
         0.11103333333333333`, 0.2268845911949685}}], 
        LineBox[{{0.11603433333333334`, 0.23736886792452822`}, {
         0.11103333333333333`, 0.23736886792452822`}}], 
        LineBox[{{0.11603433333333334`, 0.24785314465408803`}, {
         0.11103333333333333`, 0.24785314465408803`}}], 
        LineBox[{{0.11603433333333334`, 0.25833742138364774`}, {
         0.11103333333333333`, 0.25833742138364774`}}], 
        LineBox[{{0.11603433333333334`, 0.26882169811320755`}, {
         0.11103333333333333`, 0.26882169811320755`}}], 
        LineBox[{{0.12103533333333333`, 0.27930597484276726`}, {
         0.11103333333333333`, 0.27930597484276726`}}], 
        LineBox[{{0.11603433333333334`, 0.28979025157232696`}, {
         0.11103333333333333`, 0.28979025157232696`}}], 
        LineBox[{{0.11603433333333334`, 0.3002745283018868}, {
         0.11103333333333333`, 0.3002745283018868}}], 
        LineBox[{{0.11603433333333334`, 0.31075880503144643`}, {
         0.11103333333333333`, 0.31075880503144643`}}], 
        LineBox[{{0.11603433333333334`, 0.3212430817610063}, {
         0.11103333333333333`, 0.3212430817610063}}], 
        LineBox[{{0.12103533333333333`, 0.33172735849056595`}, {
         0.11103333333333333`, 0.33172735849056595`}}], 
        LineBox[{{0.11603433333333334`, 0.3422116352201257}, {
         0.11103333333333333`, 0.3422116352201257}}], 
        LineBox[{{0.11603433333333334`, 0.35269591194968547`}, {
         0.11103333333333333`, 0.35269591194968547`}}], 
        LineBox[{{0.11603433333333334`, 0.36318018867924523`}, {
         0.11103333333333333`, 0.36318018867924523`}}], 
        LineBox[{{0.11603433333333334`, 0.373664465408805}, {
         0.11103333333333333`, 0.373664465408805}}], 
        LineBox[{{0.12103533333333333`, 0.38414874213836475`}, {
         0.11103333333333333`, 0.38414874213836475`}}], 
        LineBox[{{0.11603433333333334`, 0.3946330188679244}, {
         0.11103333333333333`, 0.3946330188679244}}], 
        LineBox[{{0.11603433333333334`, 0.4051172955974843}, {
         0.11103333333333333`, 0.4051172955974843}}], 
        LineBox[{{0.11603433333333334`, 0.4156015723270439}, {
         0.11103333333333333`, 0.4156015723270439}}], 
        LineBox[{{0.11603433333333334`, 0.4260858490566038}, {
         0.11103333333333333`, 0.4260858490566038}}], 
        LineBox[{{0.12103533333333333`, 0.43657012578616344`}, {
         0.11103333333333333`, 0.43657012578616344`}}], 
        LineBox[{{0.11603433333333334`, 0.4470544025157232}, {
         0.11103333333333333`, 0.4470544025157232}}], 
        LineBox[{{0.11603433333333334`, 0.45753867924528296`}, {
         0.11103333333333333`, 0.45753867924528296`}}], 
        LineBox[{{0.11603433333333334`, 0.4680229559748427}, {
         0.11103333333333333`, 0.4680229559748427}}], 
        LineBox[{{0.11603433333333334`, 0.4785072327044025}, {
         0.11103333333333333`, 0.4785072327044025}}], 
        LineBox[{{0.12103533333333333`, 0.48899150943396225`}, {
         0.11103333333333333`, 0.48899150943396225`}}], 
        LineBox[{{0.11603433333333334`, 0.4994757861635219}, {
         0.11103333333333333`, 0.4994757861635219}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.11103333333333333`, 0.5}, {0.8889666666666667, 
         0.5}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.1330503144654088, 0.489998}, {0.1330503144654088, 
         0.5}}], 
        LineBox[{{0.2247877358490566, 0.489998}, {0.2247877358490566, 0.5}}], 
        LineBox[{{0.31652515723270436`, 0.489998}, {0.31652515723270436`, 
         0.5}}], LineBox[{{0.4082625786163522, 0.489998}, {0.4082625786163522,
          0.5}}], LineBox[{{0.5, 0.489998}, {0.5, 0.5}}], 
        LineBox[{{0.5917374213836478, 0.489998}, {0.5917374213836478, 0.5}}], 
        LineBox[{{0.6834748427672955, 0.489998}, {0.6834748427672955, 0.5}}], 
        LineBox[{{0.7752122641509434, 0.489998}, {0.7752122641509434, 0.5}}], 
        LineBox[{{0.8669496855345912, 0.489998}, {0.8669496855345912, 0.5}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.8889666666666667, 0.11103333333333332`}, {
         0.8889666666666667, 0.5}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.8839656666666666, 0.11155754716981126`}, {
         0.8889666666666667, 0.11155754716981126`}}], 
        LineBox[{{0.8789646666666667, 0.12204182389937102`}, {
         0.8889666666666667, 0.12204182389937102`}}], 
        LineBox[{{0.8839656666666666, 0.13252610062893078`}, {
         0.8889666666666667, 0.13252610062893078`}}], 
        LineBox[{{0.8839656666666666, 0.14301037735849054`}, {
         0.8889666666666667, 0.14301037735849054`}}], 
        LineBox[{{0.8839656666666666, 0.15349465408805024`}, {
         0.8889666666666667, 0.15349465408805024`}}], 
        LineBox[{{0.8839656666666666, 0.16397893081761}, {0.8889666666666667, 
         0.16397893081761}}], 
        LineBox[{{0.8789646666666667, 0.17446320754716976`}, {
         0.8889666666666667, 0.17446320754716976`}}], 
        LineBox[{{0.8839656666666666, 0.18494748427672952`}, {
         0.8889666666666667, 0.18494748427672952`}}], 
        LineBox[{{0.8839656666666666, 0.19543176100628928`}, {
         0.8889666666666667, 0.19543176100628928`}}], 
        LineBox[{{0.8839656666666666, 0.205916037735849}, {0.8889666666666667,
          0.205916037735849}}], 
        LineBox[{{0.8839656666666666, 0.21640031446540875`}, {
         0.8889666666666667, 0.21640031446540875`}}], 
        LineBox[{{0.8789646666666667, 0.2268845911949685}, {
         0.8889666666666667, 0.2268845911949685}}], 
        LineBox[{{0.8839656666666666, 0.23736886792452822`}, {
         0.8889666666666667, 0.23736886792452822`}}], 
        LineBox[{{0.8839656666666666, 0.24785314465408803`}, {
         0.8889666666666667, 0.24785314465408803`}}], 
        LineBox[{{0.8839656666666666, 0.25833742138364774`}, {
         0.8889666666666667, 0.25833742138364774`}}], 
        LineBox[{{0.8839656666666666, 0.26882169811320755`}, {
         0.8889666666666667, 0.26882169811320755`}}], 
        LineBox[{{0.8789646666666667, 0.27930597484276726`}, {
         0.8889666666666667, 0.27930597484276726`}}], 
        LineBox[{{0.8839656666666666, 0.28979025157232696`}, {
         0.8889666666666667, 0.28979025157232696`}}], 
        LineBox[{{0.8839656666666666, 0.3002745283018868}, {
         0.8889666666666667, 0.3002745283018868}}], 
        LineBox[{{0.8839656666666666, 0.31075880503144643`}, {
         0.8889666666666667, 0.31075880503144643`}}], 
        LineBox[{{0.8839656666666666, 0.3212430817610063}, {
         0.8889666666666667, 0.3212430817610063}}], 
        LineBox[{{0.8789646666666667, 0.33172735849056595`}, {
         0.8889666666666667, 0.33172735849056595`}}], 
        LineBox[{{0.8839656666666666, 0.3422116352201257}, {
         0.8889666666666667, 0.3422116352201257}}], 
        LineBox[{{0.8839656666666666, 0.35269591194968547`}, {
         0.8889666666666667, 0.35269591194968547`}}], 
        LineBox[{{0.8839656666666666, 0.36318018867924523`}, {
         0.8889666666666667, 0.36318018867924523`}}], 
        LineBox[{{0.8839656666666666, 0.373664465408805}, {0.8889666666666667,
          0.373664465408805}}], 
        LineBox[{{0.8789646666666667, 0.38414874213836475`}, {
         0.8889666666666667, 0.38414874213836475`}}], 
        LineBox[{{0.8839656666666666, 0.3946330188679244}, {
         0.8889666666666667, 0.3946330188679244}}], 
        LineBox[{{0.8839656666666666, 0.4051172955974843}, {
         0.8889666666666667, 0.4051172955974843}}], 
        LineBox[{{0.8839656666666666, 0.4156015723270439}, {
         0.8889666666666667, 0.4156015723270439}}], 
        LineBox[{{0.8839656666666666, 0.4260858490566038}, {
         0.8889666666666667, 0.4260858490566038}}], 
        LineBox[{{0.8789646666666667, 0.43657012578616344`}, {
         0.8889666666666667, 0.43657012578616344`}}], 
        LineBox[{{0.8839656666666666, 0.4470544025157232}, {
         0.8889666666666667, 0.4470544025157232}}], 
        LineBox[{{0.8839656666666666, 0.45753867924528296`}, {
         0.8889666666666667, 0.45753867924528296`}}], 
        LineBox[{{0.8839656666666666, 0.4680229559748427}, {
         0.8889666666666667, 0.4680229559748427}}], 
        LineBox[{{0.8839656666666666, 0.4785072327044025}, {
         0.8889666666666667, 0.4785072327044025}}], 
        LineBox[{{0.8789646666666667, 0.48899150943396225`}, {
         0.8889666666666667, 0.48899150943396225`}}], 
        LineBox[{{0.8839656666666666, 0.4994757861635219}, {
         0.8889666666666667, 0.4994757861635219}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], 
        AbsoluteDashing[{4, 2}], CapForm[None], 
        LineBox[{{0.2247877358490566, 0.19349216981132072`}, {
         0.31652515723270436`, 0.4617323899371069}, {0.4082625786163522, 
         0.22337235849056597`}, {0.5, 0.3909635220125786}, {
         0.5917374213836478, 0.19621808176100625`}, {0.6834748427672955, 
         0.35238138364779875`}, {0.7752122641509434, 0.1889315094339622}, {
         0.8669496855345912, 0.3288441823899371}}]}, 
       {GrayLevel[0], AbsoluteThickness[1.5], Opacity[1], Dashing[{}], 
        CapForm[None], {}, 
        {GrayLevel[0], Opacity[1], 
         PolygonBox[{{0.2247877358490566, 0.19349216981132072`}, {
          0.2200727478321047, 0.1982071578282726}, {0.2247877358490566, 
          0.19349216981132072`}, {0.2200727478321047, 0.18877718179436884`}, {
          0.2247877358490566, 0.19349216981132072`}, {0.22950272386600848`, 
          0.18877718179436884`}, {0.2247877358490566, 0.19349216981132072`}, {
          0.22950272386600848`, 0.1982071578282726}, {0.2247877358490566, 
          0.19349216981132072`}}], 
         PolygonBox[{{0.31652515723270436`, 0.4617323899371069}, {
          0.31181016921575244`, 0.46644737795405883`}, {0.31652515723270436`, 
          0.4617323899371069}, {0.31181016921575244`, 0.457017401920155}, {
          0.31652515723270436`, 0.4617323899371069}, {0.3212401452496563, 
          0.457017401920155}, {0.31652515723270436`, 0.4617323899371069}, {
          0.3212401452496563, 0.46644737795405883`}, {0.31652515723270436`, 
          0.4617323899371069}}], 
         PolygonBox[{{0.4082625786163522, 0.22337235849056597`}, {
          0.40354759059940026`, 0.22808734650751786`}, {0.4082625786163522, 
          0.22337235849056597`}, {0.40354759059940026`, 
          0.21865737047361408`}, {0.4082625786163522, 0.22337235849056597`}, {
          0.4129775666333041, 0.21865737047361408`}, {0.4082625786163522, 
          0.22337235849056597`}, {0.4129775666333041, 0.22808734650751786`}, {
          0.4082625786163522, 0.22337235849056597`}}], 
         PolygonBox[{{0.5, 0.3909635220125786}, {0.4952850119830481, 
          0.39567851002953053`}, {0.5, 0.3909635220125786}, {
          0.4952850119830481, 0.3862485339956267}, {0.5, 
          0.3909635220125786}, {0.5047149880169519, 0.3862485339956267}, {0.5,
           0.3909635220125786}, {0.5047149880169519, 0.39567851002953053`}, {
          0.5, 0.3909635220125786}}], 
         PolygonBox[{{0.5917374213836478, 0.19621808176100625`}, {
          0.5870224333666959, 0.20093306977795813`}, {0.5917374213836478, 
          0.19621808176100625`}, {0.5870224333666959, 0.19150309374405436`}, {
          0.5917374213836478, 0.19621808176100625`}, {0.5964524094005997, 
          0.19150309374405436`}, {0.5917374213836478, 0.19621808176100625`}, {
          0.5964524094005997, 0.20093306977795813`}, {0.5917374213836478, 
          0.19621808176100625`}}], 
         PolygonBox[{{0.6834748427672955, 0.35238138364779875`}, {
          0.6787598547503436, 0.35709637166475067`}, {0.6834748427672955, 
          0.35238138364779875`}, {0.6787598547503436, 0.34766639563084684`}, {
          0.6834748427672955, 0.35238138364779875`}, {0.6881898307842474, 
          0.34766639563084684`}, {0.6834748427672955, 0.35238138364779875`}, {
          0.6881898307842474, 0.35709637166475067`}, {0.6834748427672955, 
          0.35238138364779875`}}], 
         PolygonBox[{{0.7752122641509434, 0.1889315094339622}, {
          0.7704972761339914, 0.19364649745091408`}, {0.7752122641509434, 
          0.1889315094339622}, {0.7704972761339914, 0.1842165214170103}, {
          0.7752122641509434, 0.1889315094339622}, {0.7799272521678953, 
          0.1842165214170103}, {0.7752122641509434, 0.1889315094339622}, {
          0.7799272521678953, 0.19364649745091408`}, {0.7752122641509434, 
          0.1889315094339622}}], 
         PolygonBox[{{0.8669496855345912, 0.3288441823899371}, {
          0.8622346975176393, 0.33355917040688904`}, {0.8669496855345912, 
          0.3288441823899371}, {0.8622346975176393, 0.3241291943729852}, {
          0.8669496855345912, 0.3288441823899371}, {0.8716646735515431, 
          0.3241291943729852}, {0.8669496855345912, 0.3288441823899371}, {
          0.8716646735515431, 0.33355917040688904`}, {0.8669496855345912, 
          0.3288441823899371}}]}, 
        {GrayLevel[0], AbsoluteThickness[1.5], Opacity[1], Dashing[{}], 
         CapForm[None], 
         LineBox[{{0.2247877358490566, 0.19349216981132072`}, {
          0.2200727478321047, 0.1982071578282726}, {0.2247877358490566, 
          0.19349216981132072`}, {0.2200727478321047, 0.18877718179436884`}, {
          0.2247877358490566, 0.19349216981132072`}, {0.22950272386600848`, 
          0.18877718179436884`}, {0.2247877358490566, 0.19349216981132072`}, {
          0.22950272386600848`, 0.1982071578282726}, {0.2247877358490566, 
          0.19349216981132072`}, {0.2247877358490566, 0.19349216981132072`}}],
          LineBox[{{0.31652515723270436`, 0.4617323899371069}, {
          0.31181016921575244`, 0.46644737795405883`}, {0.31652515723270436`, 
          0.4617323899371069}, {0.31181016921575244`, 0.457017401920155}, {
          0.31652515723270436`, 0.4617323899371069}, {0.3212401452496563, 
          0.457017401920155}, {0.31652515723270436`, 0.4617323899371069}, {
          0.3212401452496563, 0.46644737795405883`}, {0.31652515723270436`, 
          0.4617323899371069}, {0.31652515723270436`, 0.4617323899371069}}], 
         LineBox[{{0.4082625786163522, 0.22337235849056597`}, {
          0.40354759059940026`, 0.22808734650751786`}, {0.4082625786163522, 
          0.22337235849056597`}, {0.40354759059940026`, 
          0.21865737047361408`}, {0.4082625786163522, 0.22337235849056597`}, {
          0.4129775666333041, 0.21865737047361408`}, {0.4082625786163522, 
          0.22337235849056597`}, {0.4129775666333041, 0.22808734650751786`}, {
          0.4082625786163522, 0.22337235849056597`}, {0.4082625786163522, 
          0.22337235849056597`}}], 
         LineBox[{{0.5, 0.3909635220125786}, {0.4952850119830481, 
          0.39567851002953053`}, {0.5, 0.3909635220125786}, {
          0.4952850119830481, 0.3862485339956267}, {0.5, 
          0.3909635220125786}, {0.5047149880169519, 0.3862485339956267}, {0.5,
           0.3909635220125786}, {0.5047149880169519, 0.39567851002953053`}, {
          0.5, 0.3909635220125786}, {0.5, 0.3909635220125786}}], 
         LineBox[{{0.5917374213836478, 0.19621808176100625`}, {
          0.5870224333666959, 0.20093306977795813`}, {0.5917374213836478, 
          0.19621808176100625`}, {0.5870224333666959, 0.19150309374405436`}, {
          0.5917374213836478, 0.19621808176100625`}, {0.5964524094005997, 
          0.19150309374405436`}, {0.5917374213836478, 0.19621808176100625`}, {
          0.5964524094005997, 0.20093306977795813`}, {0.5917374213836478, 
          0.19621808176100625`}, {0.5917374213836478, 0.19621808176100625`}}],
          LineBox[{{0.6834748427672955, 0.35238138364779875`}, {
          0.6787598547503436, 0.35709637166475067`}, {0.6834748427672955, 
          0.35238138364779875`}, {0.6787598547503436, 0.34766639563084684`}, {
          0.6834748427672955, 0.35238138364779875`}, {0.6881898307842474, 
          0.34766639563084684`}, {0.6834748427672955, 0.35238138364779875`}, {
          0.6881898307842474, 0.35709637166475067`}, {0.6834748427672955, 
          0.35238138364779875`}, {0.6834748427672955, 0.35238138364779875`}}],
          LineBox[{{0.7752122641509434, 0.1889315094339622}, {
          0.7704972761339914, 0.19364649745091408`}, {0.7752122641509434, 
          0.1889315094339622}, {0.7704972761339914, 0.1842165214170103}, {
          0.7752122641509434, 0.1889315094339622}, {0.7799272521678953, 
          0.1842165214170103}, {0.7752122641509434, 0.1889315094339622}, {
          0.7799272521678953, 0.19364649745091408`}, {0.7752122641509434, 
          0.1889315094339622}, {0.7752122641509434, 0.1889315094339622}}], 
         LineBox[{{0.8669496855345912, 0.3288441823899371}, {
          0.8622346975176393, 0.33355917040688904`}, {0.8669496855345912, 
          0.3288441823899371}, {0.8622346975176393, 0.3241291943729852}, {
          0.8669496855345912, 0.3288441823899371}, {0.8716646735515431, 
          0.3241291943729852}, {0.8669496855345912, 0.3288441823899371}, {
          0.8716646735515431, 0.33355917040688904`}, {0.8669496855345912, 
          0.3288441823899371}, {0.8669496855345912, 0.3288441823899371}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], LineBox[{{0.2247877358490566, 0.29623808176100624`}, {
          0.31652515723270436`, 0.45350223270440243`}, {0.4082625786163522, 
          0.2569220440251572}, {0.5, 0.4141861949685534}, {0.5917374213836478,
           0.21760600628930815`}, {0.6834748427672955, 0.3748701572327044}, {
          0.7752122641509434, 0.17828996855345908`}, {0.8669496855345912, 
          0.3355541194968554}}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], {}, 
         {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
          PolygonBox[{{0.22992142645137764`, 0.29836452603351493`}, {
           0.22871689252984984`, 0.3001672384417995}, {0.22691418012156528`, 
           0.3013717723633273}, {0.2247877358490566, 0.3017947484276729}, {
           0.2226612915765479, 0.3013717723633273}, {0.22085857916826335`, 
           0.3001672384417995}, {0.21965404524673554`, 
           0.29836452603351493`}, {0.21923106918238994`, 
           0.29623808176100624`}, {0.21965404524673554`, 
           0.29411163748849756`}, {0.22085857916826335`, 0.292308925080213}, {
           0.2226612915765479, 0.2911043911586852}, {0.2247877358490566, 
           0.2906814150943396}, {0.22691418012156528`, 0.2911043911586852}, {
           0.22871689252984984`, 0.292308925080213}, {0.22992142645137764`, 
           0.29411163748849756`}, {0.23034440251572325`, 
           0.29623808176100624`}}], 
          PolygonBox[{{0.3216588478350254, 0.4556286769769111}, {
           0.3204543139134976, 0.4574313893851957}, {0.31865160150521304`, 
           0.4586359233067235}, {0.31652515723270436`, 0.4590588993710691}, {
           0.31439871296019567`, 0.4586359233067235}, {0.3125960005519111, 
           0.4574313893851957}, {0.3113914666303833, 0.4556286769769111}, {
           0.3109684905660377, 0.45350223270440243`}, {0.3113914666303833, 
           0.45137578843189374`}, {0.3125960005519111, 0.4495730760236092}, {
           0.31439871296019567`, 0.4483685421020814}, {0.31652515723270436`, 
           0.4479455660377358}, {0.31865160150521304`, 0.4483685421020814}, {
           0.3204543139134976, 0.4495730760236092}, {0.3216588478350254, 
           0.45137578843189374`}, {0.322081823899371, 0.45350223270440243`}}],
           PolygonBox[{{0.41339626921867323`, 0.2590484882976659}, {
           0.4121917352971454, 0.26085120070595047`}, {0.41038902288886087`, 
           0.2620557346274783}, {0.4082625786163522, 0.2624787106918239}, {
           0.4061361343438435, 0.2620557346274783}, {0.40433342193555893`, 
           0.26085120070595047`}, {0.40312888801403113`, 
           0.2590484882976659}, {0.4027059119496855, 0.2569220440251572}, {
           0.40312888801403113`, 0.25479559975264854`}, {0.40433342193555893`,
            0.252992887344364}, {0.4061361343438435, 0.2517883534228362}, {
           0.4082625786163522, 0.25136537735849057`}, {0.41038902288886087`, 
           0.2517883534228362}, {0.4121917352971454, 0.252992887344364}, {
           0.41339626921867323`, 0.25479559975264854`}, {0.41381924528301883`,
            0.2569220440251572}}], 
          PolygonBox[{{0.505133690602321, 0.4163126392410621}, {
           0.5039291566807933, 0.41811535164934666`}, {0.5021264442725086, 
           0.41931988557087446`}, {0.5, 0.41974286163522007`}, {
           0.4978735557274913, 0.41931988557087446`}, {0.49607084331920676`, 
           0.41811535164934666`}, {0.49486630939767895`, 
           0.4163126392410621}, {0.49444333333333335`, 0.4141861949685534}, {
           0.49486630939767895`, 0.4120597506960447}, {0.49607084331920676`, 
           0.41025703828776017`}, {0.4978735557274913, 
           0.40905250436623236`}, {0.5, 0.40862952830188676`}, {
           0.5021264442725086, 0.40905250436623236`}, {0.5039291566807933, 
           0.41025703828776017`}, {0.505133690602321, 0.4120597506960447}, {
           0.5055566666666667, 0.4141861949685534}}], 
          PolygonBox[{{0.5968711119859689, 0.21973245056181684`}, {
           0.5956665780644411, 0.2215351629701014}, {0.5938638656561565, 
           0.2227396968916292}, {0.5917374213836478, 0.2231626729559748}, {
           0.5896109771111392, 0.2227396968916292}, {0.5878082647028545, 
           0.2215351629701014}, {0.5866037307813268, 0.21973245056181684`}, {
           0.5861807547169812, 0.21760600628930815`}, {0.5866037307813268, 
           0.21547956201679946`}, {0.5878082647028545, 0.2136768496085149}, {
           0.5896109771111392, 0.2124723156869871}, {0.5917374213836478, 
           0.2120493396226415}, {0.5938638656561565, 0.2124723156869871}, {
           0.5956665780644411, 0.2136768496085149}, {0.5968711119859689, 
           0.21547956201679946`}, {0.5972940880503145, 
           0.21760600628930815`}}], 
          PolygonBox[{{0.6886085333696166, 0.3769966015052131}, {
           0.6874039994480888, 0.37879931391349764`}, {0.6856012870398042, 
           0.38000384783502544`}, {0.6834748427672955, 
           0.38042682389937105`}, {0.6813483984947869, 
           0.38000384783502544`}, {0.6795456860865022, 
           0.37879931391349764`}, {0.6783411521649745, 0.3769966015052131}, {
           0.6779181761006289, 0.3748701572327044}, {0.6783411521649745, 
           0.3727437129601957}, {0.6795456860865022, 0.37094100055191115`}, {
           0.6813483984947869, 0.36973646663038334`}, {0.6834748427672955, 
           0.36931349056603774`}, {0.6856012870398042, 
           0.36973646663038334`}, {0.6874039994480888, 
           0.37094100055191115`}, {0.6886085333696166, 0.3727437129601957}, {
           0.6890315094339622, 0.3748701572327044}}], 
          PolygonBox[{{0.7803459547532644, 0.18041641282596776`}, {
           0.7791414208317367, 0.18221912523425232`}, {0.777338708423452, 
           0.18342365915578013`}, {0.7752122641509434, 
           0.18384663522012573`}, {0.7730858198784347, 
           0.18342365915578013`}, {0.77128310747015, 0.18221912523425232`}, {
           0.7700785735486223, 0.18041641282596776`}, {0.7696555974842767, 
           0.17828996855345908`}, {0.7700785735486223, 0.1761635242809504}, {
           0.77128310747015, 0.17436081187266583`}, {0.7730858198784347, 
           0.17315627795113803`}, {0.7752122641509434, 
           0.17273330188679242`}, {0.777338708423452, 0.17315627795113803`}, {
           0.7791414208317367, 0.17436081187266583`}, {0.7803459547532644, 
           0.1761635242809504}, {0.78076893081761, 0.17828996855345908`}}], 
          PolygonBox[{{0.8720833761369122, 0.33768056376936406`}, {
           0.8708788422153845, 0.3394832761776486}, {0.8690761298070998, 
           0.3406878100991764}, {0.8669496855345912, 0.34111078616352203`}, {
           0.8648232412620825, 0.3406878100991764}, {0.8630205288537979, 
           0.3394832761776486}, {0.8618159949322701, 0.33768056376936406`}, {
           0.8613930188679245, 0.3355541194968554}, {0.8618159949322701, 
           0.3334276752243467}, {0.8630205288537979, 0.33162496281606213`}, {
           0.8648232412620825, 0.3304204288945343}, {0.8669496855345912, 
           0.3299974528301887}, {0.8690761298070998, 0.3304204288945343}, {
           0.8708788422153845, 0.33162496281606213`}, {0.8720833761369122, 
           0.3334276752243467}, {0.8725063522012578, 0.3355541194968554}}]}, 
         {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], {
           LineBox[{{0.22992142645137764`, 0.29836452603351493`}, {
            0.22871689252984984`, 0.3001672384417995}, {0.22691418012156528`, 
            0.3013717723633273}, {0.2247877358490566, 0.3017947484276729}, {
            0.2226612915765479, 0.3013717723633273}, {0.22085857916826335`, 
            0.3001672384417995}, {0.21965404524673554`, 
            0.29836452603351493`}, {0.21923106918238994`, 
            0.29623808176100624`}, {0.21965404524673554`, 
            0.29411163748849756`}, {0.22085857916826335`, 
            0.292308925080213}, {0.2226612915765479, 0.2911043911586852}, {
            0.2247877358490566, 0.2906814150943396}, {0.22691418012156528`, 
            0.2911043911586852}, {0.22871689252984984`, 0.292308925080213}, {
            0.22992142645137764`, 0.29411163748849756`}, {
            0.23034440251572325`, 0.29623808176100624`}, {
            0.22992142645137764`, 0.29836452603351493`}}], 
           LineBox[{{0.3216588478350254, 0.4556286769769111}, {
            0.3204543139134976, 0.4574313893851957}, {0.31865160150521304`, 
            0.4586359233067235}, {0.31652515723270436`, 0.4590588993710691}, {
            0.31439871296019567`, 0.4586359233067235}, {0.3125960005519111, 
            0.4574313893851957}, {0.3113914666303833, 0.4556286769769111}, {
            0.3109684905660377, 0.45350223270440243`}, {0.3113914666303833, 
            0.45137578843189374`}, {0.3125960005519111, 0.4495730760236092}, {
            0.31439871296019567`, 0.4483685421020814}, {0.31652515723270436`, 
            0.4479455660377358}, {0.31865160150521304`, 0.4483685421020814}, {
            0.3204543139134976, 0.4495730760236092}, {0.3216588478350254, 
            0.45137578843189374`}, {0.322081823899371, 
            0.45350223270440243`}, {0.3216588478350254, 0.4556286769769111}}],
            LineBox[{{0.41339626921867323`, 0.2590484882976659}, {
            0.4121917352971454, 0.26085120070595047`}, {0.41038902288886087`, 
            0.2620557346274783}, {0.4082625786163522, 0.2624787106918239}, {
            0.4061361343438435, 0.2620557346274783}, {0.40433342193555893`, 
            0.26085120070595047`}, {0.40312888801403113`, 
            0.2590484882976659}, {0.4027059119496855, 0.2569220440251572}, {
            0.40312888801403113`, 0.25479559975264854`}, {
            0.40433342193555893`, 0.252992887344364}, {0.4061361343438435, 
            0.2517883534228362}, {0.4082625786163522, 0.25136537735849057`}, {
            0.41038902288886087`, 0.2517883534228362}, {0.4121917352971454, 
            0.252992887344364}, {0.41339626921867323`, 
            0.25479559975264854`}, {0.41381924528301883`, 
            0.2569220440251572}, {0.41339626921867323`, 0.2590484882976659}}],
            LineBox[{{0.505133690602321, 0.4163126392410621}, {
            0.5039291566807933, 0.41811535164934666`}, {0.5021264442725086, 
            0.41931988557087446`}, {0.5, 0.41974286163522007`}, {
            0.4978735557274913, 0.41931988557087446`}, {0.49607084331920676`, 
            0.41811535164934666`}, {0.49486630939767895`, 
            0.4163126392410621}, {0.49444333333333335`, 0.4141861949685534}, {
            0.49486630939767895`, 0.4120597506960447}, {0.49607084331920676`, 
            0.41025703828776017`}, {0.4978735557274913, 
            0.40905250436623236`}, {0.5, 0.40862952830188676`}, {
            0.5021264442725086, 0.40905250436623236`}, {0.5039291566807933, 
            0.41025703828776017`}, {0.505133690602321, 0.4120597506960447}, {
            0.5055566666666667, 0.4141861949685534}, {0.505133690602321, 
            0.4163126392410621}}], 
           LineBox[{{0.5968711119859689, 0.21973245056181684`}, {
            0.5956665780644411, 0.2215351629701014}, {0.5938638656561565, 
            0.2227396968916292}, {0.5917374213836478, 0.2231626729559748}, {
            0.5896109771111392, 0.2227396968916292}, {0.5878082647028545, 
            0.2215351629701014}, {0.5866037307813268, 0.21973245056181684`}, {
            0.5861807547169812, 0.21760600628930815`}, {0.5866037307813268, 
            0.21547956201679946`}, {0.5878082647028545, 0.2136768496085149}, {
            0.5896109771111392, 0.2124723156869871}, {0.5917374213836478, 
            0.2120493396226415}, {0.5938638656561565, 0.2124723156869871}, {
            0.5956665780644411, 0.2136768496085149}, {0.5968711119859689, 
            0.21547956201679946`}, {0.5972940880503145, 
            0.21760600628930815`}, {0.5968711119859689, 
            0.21973245056181684`}}], 
           LineBox[{{0.6886085333696166, 0.3769966015052131}, {
            0.6874039994480888, 0.37879931391349764`}, {0.6856012870398042, 
            0.38000384783502544`}, {0.6834748427672955, 
            0.38042682389937105`}, {0.6813483984947869, 
            0.38000384783502544`}, {0.6795456860865022, 
            0.37879931391349764`}, {0.6783411521649745, 0.3769966015052131}, {
            0.6779181761006289, 0.3748701572327044}, {0.6783411521649745, 
            0.3727437129601957}, {0.6795456860865022, 0.37094100055191115`}, {
            0.6813483984947869, 0.36973646663038334`}, {0.6834748427672955, 
            0.36931349056603774`}, {0.6856012870398042, 
            0.36973646663038334`}, {0.6874039994480888, 
            0.37094100055191115`}, {0.6886085333696166, 0.3727437129601957}, {
            0.6890315094339622, 0.3748701572327044}, {0.6886085333696166, 
            0.3769966015052131}}], 
           LineBox[{{0.7803459547532644, 0.18041641282596776`}, {
            0.7791414208317367, 0.18221912523425232`}, {0.777338708423452, 
            0.18342365915578013`}, {0.7752122641509434, 
            0.18384663522012573`}, {0.7730858198784347, 
            0.18342365915578013`}, {0.77128310747015, 0.18221912523425232`}, {
            0.7700785735486223, 0.18041641282596776`}, {0.7696555974842767, 
            0.17828996855345908`}, {0.7700785735486223, 0.1761635242809504}, {
            0.77128310747015, 0.17436081187266583`}, {0.7730858198784347, 
            0.17315627795113803`}, {0.7752122641509434, 
            0.17273330188679242`}, {0.777338708423452, 
            0.17315627795113803`}, {0.7791414208317367, 
            0.17436081187266583`}, {0.7803459547532644, 0.1761635242809504}, {
            0.78076893081761, 0.17828996855345908`}, {0.7803459547532644, 
            0.18041641282596776`}}], 
           LineBox[{{0.8720833761369122, 0.33768056376936406`}, {
            0.8708788422153845, 0.3394832761776486}, {0.8690761298070998, 
            0.3406878100991764}, {0.8669496855345912, 0.34111078616352203`}, {
            0.8648232412620825, 0.3406878100991764}, {0.8630205288537979, 
            0.3394832761776486}, {0.8618159949322701, 0.33768056376936406`}, {
            0.8613930188679245, 0.3355541194968554}, {0.8618159949322701, 
            0.3334276752243467}, {0.8630205288537979, 0.33162496281606213`}, {
            0.8648232412620825, 0.3304204288945343}, {0.8669496855345912, 
            0.3299974528301887}, {0.8690761298070998, 0.3304204288945343}, {
            0.8708788422153845, 0.33162496281606213`}, {0.8720833761369122, 
            0.3334276752243467}, {0.8725063522012578, 0.3355541194968554}, {
            0.8720833761369122, 0.33768056376936406`}}]}, InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"-80\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.5110084905660378}, {1, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"-60\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.6027459119496856}, {1, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"-40\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.6944833333333333}, {1, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"-20\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.7862207547169812}, {1, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\" 0\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.877958176100629}, {1, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             
             TagBox["\<\"\\!\\(\\*\\nStyleBox[\\\"E\\\",\\nFontSlant->\\\"\
Italic\\\"]\\) (MeV)\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.03462916666666667, 0.6944833333333333}, {0, 0}, 
           Automatic, {0, 1}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"(a)\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.15270833333333333`, 0.541675}, {0, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"Experiment\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.258285, 0.6583650000000001}, {-1, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"Theory\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.258285, 0.6216910000000001}, {-1, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"0\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.1330503144654088, 0.10964416666666665`}, {0, 1}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"1\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.2247877358490566, 0.10964416666666665`}, {0, 1}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"2\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.31652515723270436`, 0.10964416666666665`}, {0, 1},
            Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"3\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.4082625786163522, 0.10964416666666665`}, {0, 1}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"4\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.5, 0.10964416666666665`}, {0, 1}, Automatic, {1, 
           0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"5\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.5917374213836478, 0.10964416666666665`}, {0, 1}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"6\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.6834748427672955, 0.10964416666666665`}, {0, 1}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"7\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.7752122641509434, 0.10964416666666665`}, {0, 1}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"8\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.8669496855345912, 0.10964416666666665`}, {0, 1}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             
             TagBox["\<\"\\!\\(\\*\\nStyleBox[\\\"N\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.5, 0.05129916666666664}, {0, 0}, Automatic, {1, 
           0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\" 6\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.12204182389937102`}, {1, 0},
            Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\" 7\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.17446320754716976`}, {1, 0},
            Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\" 8\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.2268845911949685}, {1, 0}, 
           Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\" 9\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.27930597484276726`}, {1, 0},
            Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"10\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.33172735849056595`}, {1, 0},
            Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"11\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.38414874213836475`}, {1, 0},
            Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"12\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.43657012578616344`}, {1, 0},
            Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"13\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.10964416666666667`, 0.48899150943396225`}, {1, 0},
            Automatic, {1, 0}], InsetBox[
           TagBox[
            StyleBox[
             
             TagBox["\<\"\\!\\(\\*\\nStyleBox[SubscriptBox[\\\"S\\\", \\\"n\\\
\"],\\nFontSlant->\\\"Italic\\\"]\\) (MeV)\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.03462916666666667, 0.30551666666666666`}, {0, 0},
            Automatic, {0, 1}], InsetBox[
           TagBox[
            StyleBox[
             TagBox["\<\"(b)\"\>",
              DisplayForm],
             StripOnInput->False,
             ShowAutoStyles->False,
             SingleLetterItalics->False,
             FontFamily->"Times",
             FontSize->12,
             FontWeight->"Plain",
             FontSlant->"Plain",
             FontTracking->"Plain",
             FontColor->GrayLevel[0],
             FontOpacity->1],
            DisplayForm], {0.15270833333333333`, 0.1527083333333333}, {0, 0}, 
           Automatic, {1, 0}]}}}}}}}},
  AspectRatio->1,
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{360, 360},
  PlotRange->{{-0.0001, 1.0001}, {-0.0001, 1.0001}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.506122965566625*^9, 3.5061229863635*^9}, 
   3.507512420375*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some simple demos of data plotting options", "Section",
 CellChangeTimes->{{3.499034047703125*^9, 3.499034056296875*^9}}],

Cell[CellGroupData[{

Cell["Error bars", "Subsection",
 CellChangeTimes->{{3.49903452359375*^9, 3.49903452525*^9}}],

Cell["\<\
Although it is anticipated that other ways of specifying error bars will be \
added later...\
\>", "Text",
 CellChangeTimes->{{3.49903452734375*^9, 3.49903455078125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "0."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.39269908169872414", ",", "0.3826834323650898"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7853981633974483", ",", "0.7071067811865475"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ErrorValue", "[", 
        RowBox[{"1.1781", ",", "0.2"}], "]"}], ",", 
       RowBox[{"ErrorValue", "[", 
        RowBox[{"0.92388", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.4"}], ",", "0.2"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5707963267948966", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.9634954084936207", ",", "0.9238795325112867"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.356194490192345", ",", "0.7071067811865475"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.748893571891069", ",", "0.3826834323650898"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.141592653589793", ",", "0."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.5342917352885173", ",", 
       RowBox[{"-", "0.3826834323650898"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9269908169872414", ",", 
       RowBox[{"-", "0.7071067811865475"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.319689898685965", ",", 
       RowBox[{"-", "0.9238795325112867"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.71238898038469", ",", 
       RowBox[{"-", "1."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.105088062083414", ",", 
       RowBox[{"-", "0.9238795325112867"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.497787143782138", ",", 
       RowBox[{"-", "0.7071067811865475"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.890486225480862", ",", 
       RowBox[{"-", "0.3826834323650898"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.283185307179586", ",", "0."}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.499034510078125*^9, 3.4990345178125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataLine", ",", 
       RowBox[{"Dashing", "\[Rule]", "4"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataSymbol", ",", 
       RowBox[{"SymbolShape", "\[Rule]", "\"\<Circle\>\""}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Red"}], ",", 
       RowBox[{"SymbolSize", "\[Rule]", "6"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"DataPlot", "[", "\[IndentingNewLine]", 
      RowBox[{"Data", ",", 
       RowBox[{"Tag", "\[Rule]", 
        RowBox[{"set", "[", "1", "]"}]}]}], "\[IndentingNewLine]", "]"}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"DataLegend", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.75", ",", "0.9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"set", "[", "1", "]"}], ",", "\"\<Data\>\""}], "}"}], "}"}],
        ",", 
       RowBox[{"Length", "\[Rule]", "10"}], ",", 
       RowBox[{"Gap", "\[Rule]", "5"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBGIQzdAwXTbl00tHBgY2RTDdYGQHoS86QOgLrhBazxtC
R1ZB1L+rhfAzJ0Ho1qkQes9MiPxVCN3QvApC31sDES/eA6H37YOIe52D0C7n
IfTHp6lg+WfPILTgvjQwbQahG468h/CfQOn8delg8XYIzdCwHcKP2gOhg+5C
aOl7EPlI+QwwnQ2lW9QhtJEmhBbUB9MN8hCaodwRQn92gohP8obQu/wh4rfC
ILRHLITWnwKhI6H02t0PBF8B1dvsBdMMD45AaKUTELrsIYS+8QxEAwAYg7x0

  "]],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}], 
    CapForm[None], 
    LineBox[{{1.0842021724855044`*^-19, 0.}, {0.39269908169872414`, 
     0.3826834323650898}, {0.7853981633974483, 0.7071067811865475}, {1.1781, 
     0.92388}, {1.5707963267948966`, 1.}, {1.9634954084936207`, 
     0.9238795325112867}, {2.356194490192345, 0.7071067811865475}, {
     2.748893571891069, 0.3826834323650898}, {3.141592653589793, 0.}, {
     3.5342917352885173`, -0.3826834323650898}, {
     3.9269908169872414`, -0.7071067811865475}, {
     4.319689898685965, -0.9238795325112867}, {4.71238898038469, -1.}, {
     5.105088062083414, -0.9238795325112867}, {
     5.497787143782138, -0.7071067811865475}, {
     5.890486225480862, -0.3826834323650898}, {6.283185307179586, 0.}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], {{LineBox[{{1.1781, 0.92388}, {0.9781, 0.92388}}], 
      LineBox[{{0.9781, 0.8683133333333334}, {0.9781, 
       0.9794466666666667}}]}, {
      LineBox[{{1.1781, 0.92388}, {1.3780999999999999`, 0.92388}}], 
      LineBox[{{1.3780999999999999`, 0.8683133333333334}, {
       1.3780999999999999`, 0.9794466666666667}}]}, {
      LineBox[{{1.1781, 0.92388}, {1.1781, 0.52388}}], 
      LineBox[{{1.1344580420538817`, 0.52388}, {1.2217419579461182`, 
       0.52388}}]}, {LineBox[{{1.1781, 0.92388}, {1.1781, 1.12388}}], 
      LineBox[{{1.1344580420538817`, 1.12388}, {1.2217419579461182`, 
       1.12388}}]}}, 
    {RGBColor[1, 0, 0], Opacity[1], 
     PolygonBox[{{-0.0006283185307179586, 
      0.05540753677276294}, {-0.0006283185307179586, -0.05540753677276294}, {
      1.0842021724855044`*^-19, -0.05556666666666667}, {
      0.01670105426195342, -0.05133690602321049}, {
      0.030859524407958316`, -0.039291566807932485`}, {
      0.04031991170513692, -0.02126444272508682}, {0.04364195794611821, 0.}, {
      0.04031991170513692, 0.02126444272508682}, {0.030859524407958316`, 
      0.039291566807932485`}, {0.01670105426195342, 0.05133690602321049}, {
      1.0842021724855044`*^-19, 0.05556666666666667}}], 
     PolygonBox[{{0.4330189934038611, 0.4039478750901766}, {
      0.42355860610668244`, 0.4219749991730223}, {0.40940013596067754`, 
      0.4340203383883003}, {0.39269908169872414`, 0.43825009903175643`}, {
      0.37599802743677074`, 0.4340203383883003}, {0.36183955729076583`, 
      0.4219749991730223}, {0.3523791699935872, 0.4039478750901766}, {
      0.34905712375260595`, 0.3826834323650898}, {0.3523791699935872, 
      0.36141898964000296`}, {0.36183955729076583`, 0.3433918655571573}, {
      0.37599802743677074`, 0.3313465263418793}, {0.39269908169872414`, 
      0.32711676569842313`}, {0.40940013596067754`, 0.3313465263418793}, {
      0.42355860610668244`, 0.3433918655571573}, {0.4330189934038611, 
      0.36141898964000296`}, {0.43634103964484233`, 0.3826834323650898}}], 
     PolygonBox[{{0.8257180751025852, 0.7283712239116342}, {
      0.8162576878054066, 0.7463983479944799}, {0.8020992176594017, 
      0.758443687209758}, {0.7853981633974483, 0.7626734478532141}, {
      0.7686971091354948, 0.758443687209758}, {0.7545386389894899, 
      0.7463983479944799}, {0.7450782516923113, 0.7283712239116342}, {
      0.74175620545133, 0.7071067811865475}, {0.7450782516923113, 
      0.6858423384614607}, {0.7545386389894899, 0.667815214378615}, {
      0.7686971091354948, 0.655769875163337}, {0.7853981633974483, 
      0.6515401145198808}, {0.8020992176594017, 0.655769875163337}, {
      0.8162576878054066, 0.667815214378615}, {0.8257180751025852, 
      0.6858423384614607}, {0.8290401213435665, 0.7071067811865475}}], 
     PolygonBox[{{1.2184199117051369`, 0.9451444427250868}, {
      1.2089595244079583`, 0.9631715668079325}, {1.1948010542619534`, 
      0.9752169060232105}, {1.1781, 0.9794466666666667}, {1.1613989457380465`,
       0.9752169060232105}, {1.1472404755920416`, 0.9631715668079325}, {
      1.137780088294863, 0.9451444427250868}, {1.1344580420538817`, 
      0.92388}, {1.137780088294863, 0.9026155572749133}, {1.1472404755920416`,
       0.8845884331920676}, {1.1613989457380465`, 0.8725430939767895}, {
      1.1781, 0.8683133333333334}, {1.1948010542619534`, 
      0.8725430939767895}, {1.2089595244079583`, 0.8845884331920676}, {
      1.2184199117051369`, 0.9026155572749133}, {1.2217419579461182`, 
      0.92388}}], 
     PolygonBox[{{1.6111162385000335`, 1.0212644427250868`}, {
      1.601655851202855, 1.0392915668079326`}, {1.58749738105685, 
      1.0513369060232105`}, {1.5707963267948966`, 1.0555666666666668`}, {
      1.554095272532943, 1.0513369060232105`}, {1.5399368023869382`, 
      1.0392915668079326`}, {1.5304764150897596`, 1.0212644427250868`}, {
      1.5271543688487783`, 1.}, {1.5304764150897596`, 0.9787355572749132}, {
      1.5399368023869382`, 0.9607084331920676}, {1.554095272532943, 
      0.9486630939767895}, {1.5707963267948966`, 0.9444333333333333}, {
      1.58749738105685, 0.9486630939767895}, {1.601655851202855, 
      0.9607084331920676}, {1.6111162385000335`, 0.9787355572749132}, {
      1.6144382847410148`, 1.}}], 
     PolygonBox[{{2.0038153201987576`, 0.9451439752363735}, {
      1.994354932901579, 0.9631710993192192}, {1.9801964627555741`, 
      0.9752164385344972}, {1.9634954084936207`, 0.9794461991779534}, {
      1.9467943542316672`, 0.9752164385344972}, {1.9326358840856623`, 
      0.9631710993192192}, {1.9231754967884838`, 0.9451439752363735}, {
      1.9198534505475024`, 0.9238795325112867}, {1.9231754967884838`, 
      0.9026150897862}, {1.9326358840856623`, 0.8845879657033543}, {
      1.9467943542316672`, 0.8725426264880762}, {1.9634954084936207`, 
      0.8683128658446201}, {1.9801964627555741`, 0.8725426264880762}, {
      1.994354932901579, 0.8845879657033543}, {2.0038153201987576`, 
      0.9026150897862}, {2.0071373664397387`, 0.9238795325112867}}], 
     PolygonBox[{{2.3965144018974818`, 0.7283712239116342}, {
      2.387054014600303, 0.7463983479944799}, {2.3728955444542983`, 
      0.758443687209758}, {2.356194490192345, 0.7626734478532141}, {
      2.3394934359303914`, 0.758443687209758}, {2.3253349657843865`, 
      0.7463983479944799}, {2.315874578487208, 0.7283712239116342}, {
      2.312552532246227, 0.7071067811865475}, {2.315874578487208, 
      0.6858423384614607}, {2.3253349657843865`, 0.667815214378615}, {
      2.3394934359303914`, 0.655769875163337}, {2.356194490192345, 
      0.6515401145198808}, {2.3728955444542983`, 0.655769875163337}, {
      2.387054014600303, 0.667815214378615}, {2.3965144018974818`, 
      0.6858423384614607}, {2.399836448138463, 0.7071067811865475}}], 
     PolygonBox[{{2.789213483596206, 0.4039478750901766}, {
      2.7797530962990273`, 0.4219749991730223}, {2.7655946261530224`, 
      0.4340203383883003}, {2.748893571891069, 0.43825009903175643`}, {
      2.7321925176291155`, 0.4340203383883003}, {2.7180340474831106`, 
      0.4219749991730223}, {2.708573660185932, 0.4039478750901766}, {
      2.705251613944951, 0.3826834323650898}, {2.708573660185932, 
      0.36141898964000296`}, {2.7180340474831106`, 0.3433918655571573}, {
      2.7321925176291155`, 0.3313465263418793}, {2.748893571891069, 
      0.32711676569842313`}, {2.7655946261530224`, 0.3313465263418793}, {
      2.7797530962990273`, 0.3433918655571573}, {2.789213483596206, 
      0.36141898964000296`}, {2.792535529837187, 0.3826834323650898}}], 
     PolygonBox[{{3.18191256529493, 0.02126444272508682}, {
      3.1724521779977515`, 0.039291566807932485`}, {3.1582937078517466`, 
      0.05133690602321049}, {3.141592653589793, 0.05556666666666667}, {
      3.1248915993278397`, 0.05133690602321049}, {3.1107331291818348`, 
      0.039291566807932485`}, {3.101272741884656, 0.02126444272508682}, {
      3.097950695643675, 0.}, {3.101272741884656, -0.02126444272508682}, {
      3.1107331291818348`, -0.039291566807932485`}, {
      3.1248915993278397`, -0.05133690602321049}, {
      3.141592653589793, -0.05556666666666667}, {
      3.1582937078517466`, -0.05133690602321049}, {
      3.1724521779977515`, -0.039291566807932485`}, {
      3.18191256529493, -0.02126444272508682}, {3.185234611535911, 0.}}], 
     PolygonBox[{{3.574611646993654, -0.36141898964000296`}, {
      3.5651512596964756`, -0.3433918655571573}, {
      3.5509927895504707`, -0.3313465263418793}, {
      3.5342917352885173`, -0.32711676569842313`}, {
      3.517590681026564, -0.3313465263418793}, {
      3.503432210880559, -0.3433918655571573}, {
      3.4939718235833803`, -0.36141898964000296`}, {
      3.4906497773423992`, -0.3826834323650898}, {
      3.4939718235833803`, -0.4039478750901766}, {
      3.503432210880559, -0.4219749991730223}, {
      3.517590681026564, -0.4340203383883003}, {
      3.5342917352885173`, -0.43825009903175643`}, {
      3.5509927895504707`, -0.4340203383883003}, {
      3.5651512596964756`, -0.4219749991730223}, {
      3.574611646993654, -0.4039478750901766}, {
      3.5779336932346353`, -0.3826834323650898}}], 
     PolygonBox[{{3.9673107286923783`, -0.6858423384614607}, {
      3.9578503413951998`, -0.667815214378615}, {
      3.943691871249195, -0.655769875163337}, {
      3.9269908169872414`, -0.6515401145198808}, {
      3.910289762725288, -0.655769875163337}, {
      3.896131292579283, -0.667815214378615}, {
      3.8866709052821045`, -0.6858423384614607}, {
      3.8833488590411234`, -0.7071067811865475}, {
      3.8866709052821045`, -0.7283712239116342}, {
      3.896131292579283, -0.7463983479944799}, {
      3.910289762725288, -0.758443687209758}, {
      3.9269908169872414`, -0.7626734478532141}, {
      3.943691871249195, -0.758443687209758}, {
      3.9578503413951998`, -0.7463983479944799}, {
      3.9673107286923783`, -0.7283712239116342}, {
      3.9706327749333594`, -0.7071067811865475}}], 
     PolygonBox[{{4.360009810391102, -0.9026150897862}, {
      4.3505494230939235`, -0.8845879657033543}, {
      4.3363909529479185`, -0.8725426264880762}, {
      4.319689898685965, -0.8683128658446201}, {
      4.302988844424012, -0.8725426264880762}, {
      4.288830374278007, -0.8845879657033543}, {
      4.279369986980829, -0.9026150897862}, {
      4.276047940739847, -0.9238795325112867}, {
      4.279369986980829, -0.9451439752363735}, {
      4.288830374278007, -0.9631710993192192}, {
      4.302988844424012, -0.9752164385344972}, {
      4.319689898685965, -0.9794461991779534}, {
      4.3363909529479185`, -0.9752164385344972}, {
      4.3505494230939235`, -0.9631710993192192}, {
      4.360009810391102, -0.9451439752363735}, {
      4.363331856632083, -0.9238795325112867}}], 
     PolygonBox[{{4.752708892089826, -0.9787355572749132}, {
      4.743248504792648, -0.9607084331920676}, {
      4.729090034646643, -0.9486630939767895}, {
      4.71238898038469, -0.9444333333333333}, {
      4.695687926122736, -0.9486630939767895}, {
      4.681529455976731, -0.9607084331920676}, {
      4.672069068679553, -0.9787355572749132}, {4.668747022438572, -1.}, {
      4.672069068679553, -1.0212644427250868`}, {
      4.681529455976731, -1.0392915668079326`}, {
      4.695687926122736, -1.0513369060232105`}, {
      4.71238898038469, -1.0555666666666668`}, {
      4.729090034646643, -1.0513369060232105`}, {
      4.743248504792648, -1.0392915668079326`}, {
      4.752708892089826, -1.0212644427250868`}, {4.756030938330808, -1.}}], 
     PolygonBox[{{5.145407973788551, -0.9026150897862}, {
      5.135947586491373, -0.8845879657033543}, {
      5.121789116345368, -0.8725426264880762}, {
      5.105088062083414, -0.8683128658446201}, {
      5.088387007821461, -0.8725426264880762}, {
      5.074228537675456, -0.8845879657033543}, {
      5.064768150378278, -0.9026150897862}, {
      5.061446104137296, -0.9238795325112867}, {
      5.064768150378278, -0.9451439752363735}, {
      5.074228537675456, -0.9631710993192192}, {
      5.088387007821461, -0.9752164385344972}, {
      5.105088062083414, -0.9794461991779534}, {
      5.121789116345368, -0.9752164385344972}, {
      5.135947586491373, -0.9631710993192192}, {
      5.145407973788551, -0.9451439752363735}, {
      5.148730020029532, -0.9238795325112867}}], 
     PolygonBox[{{5.538107055487274, -0.6858423384614607}, {
      5.528646668190096, -0.667815214378615}, {
      5.514488198044091, -0.655769875163337}, {
      5.497787143782138, -0.6515401145198808}, {
      5.4810860895201845`, -0.655769875163337}, {
      5.46692761937418, -0.667815214378615}, {
      5.4574672320770015`, -0.6858423384614607}, {
      5.45414518583602, -0.7071067811865475}, {
      5.4574672320770015`, -0.7283712239116342}, {
      5.46692761937418, -0.7463983479944799}, {
      5.4810860895201845`, -0.758443687209758}, {
      5.497787143782138, -0.7626734478532141}, {
      5.514488198044091, -0.758443687209758}, {
      5.528646668190096, -0.7463983479944799}, {
      5.538107055487274, -0.7283712239116342}, {
      5.541429101728256, -0.7071067811865475}}], 
     PolygonBox[{{5.930806137185998, -0.36141898964000296`}, {
      5.92134574988882, -0.3433918655571573}, {
      5.907187279742815, -0.3313465263418793}, {
      5.890486225480862, -0.32711676569842313`}, {
      5.873785171218908, -0.3313465263418793}, {
      5.859626701072903, -0.3433918655571573}, {
      5.850166313775725, -0.36141898964000296`}, {
      5.846844267534744, -0.3826834323650898}, {
      5.850166313775725, -0.4039478750901766}, {
      5.859626701072903, -0.4219749991730223}, {
      5.873785171218908, -0.4340203383883003}, {
      5.890486225480862, -0.43825009903175643`}, {
      5.907187279742815, -0.4340203383883003}, {
      5.92134574988882, -0.4219749991730223}, {
      5.930806137185998, -0.4039478750901766}, {
      5.93412818342698, -0.3826834323650898}}], 
     PolygonBox[{{6.266484252917633, 0.05133690602321049}, {6.252325782771628,
       0.039291566807932485`}, {6.24286539547445, 0.02126444272508682}, {
      6.239543349233468, 0.}, {6.24286539547445, -0.02126444272508682}, {
      6.252325782771628, -0.039291566807932485`}, {
      6.266484252917633, -0.05133690602321049}, {
      6.283185307179586, -0.05556666666666667}, {
      6.283813625710304, -0.0554075367727629}, {6.283813625710304, 
      0.0554075367727629}, {6.283185307179586, 0.05556666666666667}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], {LineBox[{{0.04031991170513692, 0.02126444272508682}, {
       0.030859524407958316`, 0.039291566807932485`}, {0.01670105426195342, 
       0.05133690602321049}, {1.0842021724855044`*^-19, 
       0.05556666666666667}, {-0.0006283185307179586, 0.05540753677276294}}], 
      LineBox[{{-0.0006283185307179586, -0.05540753677276294}, {
       1.0842021724855044`*^-19, -0.05556666666666667}, {
       0.01670105426195342, -0.05133690602321049}, {
       0.030859524407958316`, -0.039291566807932485`}, {
       0.04031991170513692, -0.02126444272508682}, {0.04364195794611821, 
       0.}, {0.04031991170513692, 0.02126444272508682}}]}, 
     LineBox[{{0.4330189934038611, 0.4039478750901766}, {0.42355860610668244`,
       0.4219749991730223}, {0.40940013596067754`, 0.4340203383883003}, {
      0.39269908169872414`, 0.43825009903175643`}, {0.37599802743677074`, 
      0.4340203383883003}, {0.36183955729076583`, 0.4219749991730223}, {
      0.3523791699935872, 0.4039478750901766}, {0.34905712375260595`, 
      0.3826834323650898}, {0.3523791699935872, 0.36141898964000296`}, {
      0.36183955729076583`, 0.3433918655571573}, {0.37599802743677074`, 
      0.3313465263418793}, {0.39269908169872414`, 0.32711676569842313`}, {
      0.40940013596067754`, 0.3313465263418793}, {0.42355860610668244`, 
      0.3433918655571573}, {0.4330189934038611, 0.36141898964000296`}, {
      0.43634103964484233`, 0.3826834323650898}, {0.4330189934038611, 
      0.4039478750901766}}], 
     LineBox[{{0.8257180751025852, 0.7283712239116342}, {0.8162576878054066, 
      0.7463983479944799}, {0.8020992176594017, 0.758443687209758}, {
      0.7853981633974483, 0.7626734478532141}, {0.7686971091354948, 
      0.758443687209758}, {0.7545386389894899, 0.7463983479944799}, {
      0.7450782516923113, 0.7283712239116342}, {0.74175620545133, 
      0.7071067811865475}, {0.7450782516923113, 0.6858423384614607}, {
      0.7545386389894899, 0.667815214378615}, {0.7686971091354948, 
      0.655769875163337}, {0.7853981633974483, 0.6515401145198808}, {
      0.8020992176594017, 0.655769875163337}, {0.8162576878054066, 
      0.667815214378615}, {0.8257180751025852, 0.6858423384614607}, {
      0.8290401213435665, 0.7071067811865475}, {0.8257180751025852, 
      0.7283712239116342}}], 
     LineBox[{{1.2184199117051369`, 0.9451444427250868}, {1.2089595244079583`,
       0.9631715668079325}, {1.1948010542619534`, 0.9752169060232105}, {
      1.1781, 0.9794466666666667}, {1.1613989457380465`, 
      0.9752169060232105}, {1.1472404755920416`, 0.9631715668079325}, {
      1.137780088294863, 0.9451444427250868}, {1.1344580420538817`, 
      0.92388}, {1.137780088294863, 0.9026155572749133}, {1.1472404755920416`,
       0.8845884331920676}, {1.1613989457380465`, 0.8725430939767895}, {
      1.1781, 0.8683133333333334}, {1.1948010542619534`, 
      0.8725430939767895}, {1.2089595244079583`, 0.8845884331920676}, {
      1.2184199117051369`, 0.9026155572749133}, {1.2217419579461182`, 
      0.92388}, {1.2184199117051369`, 0.9451444427250868}}], 
     LineBox[{{1.6111162385000335`, 1.0212644427250868`}, {1.601655851202855, 
      1.0392915668079326`}, {1.58749738105685, 1.0513369060232105`}, {
      1.5707963267948966`, 1.0555666666666668`}, {1.554095272532943, 
      1.0513369060232105`}, {1.5399368023869382`, 1.0392915668079326`}, {
      1.5304764150897596`, 1.0212644427250868`}, {1.5271543688487783`, 1.}, {
      1.5304764150897596`, 0.9787355572749132}, {1.5399368023869382`, 
      0.9607084331920676}, {1.554095272532943, 0.9486630939767895}, {
      1.5707963267948966`, 0.9444333333333333}, {1.58749738105685, 
      0.9486630939767895}, {1.601655851202855, 0.9607084331920676}, {
      1.6111162385000335`, 0.9787355572749132}, {1.6144382847410148`, 1.}, {
      1.6111162385000335`, 1.0212644427250868`}}], 
     LineBox[{{2.0038153201987576`, 0.9451439752363735}, {1.994354932901579, 
      0.9631710993192192}, {1.9801964627555741`, 0.9752164385344972}, {
      1.9634954084936207`, 0.9794461991779534}, {1.9467943542316672`, 
      0.9752164385344972}, {1.9326358840856623`, 0.9631710993192192}, {
      1.9231754967884838`, 0.9451439752363735}, {1.9198534505475024`, 
      0.9238795325112867}, {1.9231754967884838`, 0.9026150897862}, {
      1.9326358840856623`, 0.8845879657033543}, {1.9467943542316672`, 
      0.8725426264880762}, {1.9634954084936207`, 0.8683128658446201}, {
      1.9801964627555741`, 0.8725426264880762}, {1.994354932901579, 
      0.8845879657033543}, {2.0038153201987576`, 0.9026150897862}, {
      2.0071373664397387`, 0.9238795325112867}, {2.0038153201987576`, 
      0.9451439752363735}}], 
     LineBox[{{2.3965144018974818`, 0.7283712239116342}, {2.387054014600303, 
      0.7463983479944799}, {2.3728955444542983`, 0.758443687209758}, {
      2.356194490192345, 0.7626734478532141}, {2.3394934359303914`, 
      0.758443687209758}, {2.3253349657843865`, 0.7463983479944799}, {
      2.315874578487208, 0.7283712239116342}, {2.312552532246227, 
      0.7071067811865475}, {2.315874578487208, 0.6858423384614607}, {
      2.3253349657843865`, 0.667815214378615}, {2.3394934359303914`, 
      0.655769875163337}, {2.356194490192345, 0.6515401145198808}, {
      2.3728955444542983`, 0.655769875163337}, {2.387054014600303, 
      0.667815214378615}, {2.3965144018974818`, 0.6858423384614607}, {
      2.399836448138463, 0.7071067811865475}, {2.3965144018974818`, 
      0.7283712239116342}}], 
     LineBox[{{2.789213483596206, 0.4039478750901766}, {2.7797530962990273`, 
      0.4219749991730223}, {2.7655946261530224`, 0.4340203383883003}, {
      2.748893571891069, 0.43825009903175643`}, {2.7321925176291155`, 
      0.4340203383883003}, {2.7180340474831106`, 0.4219749991730223}, {
      2.708573660185932, 0.4039478750901766}, {2.705251613944951, 
      0.3826834323650898}, {2.708573660185932, 0.36141898964000296`}, {
      2.7180340474831106`, 0.3433918655571573}, {2.7321925176291155`, 
      0.3313465263418793}, {2.748893571891069, 0.32711676569842313`}, {
      2.7655946261530224`, 0.3313465263418793}, {2.7797530962990273`, 
      0.3433918655571573}, {2.789213483596206, 0.36141898964000296`}, {
      2.792535529837187, 0.3826834323650898}, {2.789213483596206, 
      0.4039478750901766}}], 
     LineBox[{{3.18191256529493, 0.02126444272508682}, {3.1724521779977515`, 
      0.039291566807932485`}, {3.1582937078517466`, 0.05133690602321049}, {
      3.141592653589793, 0.05556666666666667}, {3.1248915993278397`, 
      0.05133690602321049}, {3.1107331291818348`, 0.039291566807932485`}, {
      3.101272741884656, 0.02126444272508682}, {3.097950695643675, 0.}, {
      3.101272741884656, -0.02126444272508682}, {
      3.1107331291818348`, -0.039291566807932485`}, {
      3.1248915993278397`, -0.05133690602321049}, {
      3.141592653589793, -0.05556666666666667}, {
      3.1582937078517466`, -0.05133690602321049}, {
      3.1724521779977515`, -0.039291566807932485`}, {
      3.18191256529493, -0.02126444272508682}, {3.185234611535911, 0.}, {
      3.18191256529493, 0.02126444272508682}}], 
     LineBox[{{3.574611646993654, -0.36141898964000296`}, {
      3.5651512596964756`, -0.3433918655571573}, {
      3.5509927895504707`, -0.3313465263418793}, {
      3.5342917352885173`, -0.32711676569842313`}, {
      3.517590681026564, -0.3313465263418793}, {
      3.503432210880559, -0.3433918655571573}, {
      3.4939718235833803`, -0.36141898964000296`}, {
      3.4906497773423992`, -0.3826834323650898}, {
      3.4939718235833803`, -0.4039478750901766}, {
      3.503432210880559, -0.4219749991730223}, {
      3.517590681026564, -0.4340203383883003}, {
      3.5342917352885173`, -0.43825009903175643`}, {
      3.5509927895504707`, -0.4340203383883003}, {
      3.5651512596964756`, -0.4219749991730223}, {
      3.574611646993654, -0.4039478750901766}, {
      3.5779336932346353`, -0.3826834323650898}, {
      3.574611646993654, -0.36141898964000296`}}], 
     LineBox[{{3.9673107286923783`, -0.6858423384614607}, {
      3.9578503413951998`, -0.667815214378615}, {
      3.943691871249195, -0.655769875163337}, {
      3.9269908169872414`, -0.6515401145198808}, {
      3.910289762725288, -0.655769875163337}, {
      3.896131292579283, -0.667815214378615}, {
      3.8866709052821045`, -0.6858423384614607}, {
      3.8833488590411234`, -0.7071067811865475}, {
      3.8866709052821045`, -0.7283712239116342}, {
      3.896131292579283, -0.7463983479944799}, {
      3.910289762725288, -0.758443687209758}, {
      3.9269908169872414`, -0.7626734478532141}, {
      3.943691871249195, -0.758443687209758}, {
      3.9578503413951998`, -0.7463983479944799}, {
      3.9673107286923783`, -0.7283712239116342}, {
      3.9706327749333594`, -0.7071067811865475}, {
      3.9673107286923783`, -0.6858423384614607}}], 
     LineBox[{{4.360009810391102, -0.9026150897862}, {
      4.3505494230939235`, -0.8845879657033543}, {
      4.3363909529479185`, -0.8725426264880762}, {
      4.319689898685965, -0.8683128658446201}, {
      4.302988844424012, -0.8725426264880762}, {
      4.288830374278007, -0.8845879657033543}, {
      4.279369986980829, -0.9026150897862}, {
      4.276047940739847, -0.9238795325112867}, {
      4.279369986980829, -0.9451439752363735}, {
      4.288830374278007, -0.9631710993192192}, {
      4.302988844424012, -0.9752164385344972}, {
      4.319689898685965, -0.9794461991779534}, {
      4.3363909529479185`, -0.9752164385344972}, {
      4.3505494230939235`, -0.9631710993192192}, {
      4.360009810391102, -0.9451439752363735}, {
      4.363331856632083, -0.9238795325112867}, {
      4.360009810391102, -0.9026150897862}}], 
     LineBox[{{4.752708892089826, -0.9787355572749132}, {
      4.743248504792648, -0.9607084331920676}, {
      4.729090034646643, -0.9486630939767895}, {
      4.71238898038469, -0.9444333333333333}, {
      4.695687926122736, -0.9486630939767895}, {
      4.681529455976731, -0.9607084331920676}, {
      4.672069068679553, -0.9787355572749132}, {4.668747022438572, -1.}, {
      4.672069068679553, -1.0212644427250868`}, {
      4.681529455976731, -1.0392915668079326`}, {
      4.695687926122736, -1.0513369060232105`}, {
      4.71238898038469, -1.0555666666666668`}, {
      4.729090034646643, -1.0513369060232105`}, {
      4.743248504792648, -1.0392915668079326`}, {
      4.752708892089826, -1.0212644427250868`}, {4.756030938330808, -1.}, {
      4.752708892089826, -0.9787355572749132}}], 
     LineBox[{{5.145407973788551, -0.9026150897862}, {
      5.135947586491373, -0.8845879657033543}, {
      5.121789116345368, -0.8725426264880762}, {
      5.105088062083414, -0.8683128658446201}, {
      5.088387007821461, -0.8725426264880762}, {
      5.074228537675456, -0.8845879657033543}, {
      5.064768150378278, -0.9026150897862}, {
      5.061446104137296, -0.9238795325112867}, {
      5.064768150378278, -0.9451439752363735}, {
      5.074228537675456, -0.9631710993192192}, {
      5.088387007821461, -0.9752164385344972}, {
      5.105088062083414, -0.9794461991779534}, {
      5.121789116345368, -0.9752164385344972}, {
      5.135947586491373, -0.9631710993192192}, {
      5.145407973788551, -0.9451439752363735}, {
      5.148730020029532, -0.9238795325112867}, {
      5.145407973788551, -0.9026150897862}}], 
     LineBox[{{5.538107055487274, -0.6858423384614607}, {
      5.528646668190096, -0.667815214378615}, {
      5.514488198044091, -0.655769875163337}, {
      5.497787143782138, -0.6515401145198808}, {
      5.4810860895201845`, -0.655769875163337}, {
      5.46692761937418, -0.667815214378615}, {
      5.4574672320770015`, -0.6858423384614607}, {
      5.45414518583602, -0.7071067811865475}, {
      5.4574672320770015`, -0.7283712239116342}, {
      5.46692761937418, -0.7463983479944799}, {
      5.4810860895201845`, -0.758443687209758}, {
      5.497787143782138, -0.7626734478532141}, {
      5.514488198044091, -0.758443687209758}, {
      5.528646668190096, -0.7463983479944799}, {
      5.538107055487274, -0.7283712239116342}, {
      5.541429101728256, -0.7071067811865475}, {
      5.538107055487274, -0.6858423384614607}}], 
     LineBox[{{5.930806137185998, -0.36141898964000296`}, {
      5.92134574988882, -0.3433918655571573}, {
      5.907187279742815, -0.3313465263418793}, {
      5.890486225480862, -0.32711676569842313`}, {
      5.873785171218908, -0.3313465263418793}, {
      5.859626701072903, -0.3433918655571573}, {
      5.850166313775725, -0.36141898964000296`}, {
      5.846844267534744, -0.3826834323650898}, {
      5.850166313775725, -0.4039478750901766}, {
      5.859626701072903, -0.4219749991730223}, {
      5.873785171218908, -0.4340203383883003}, {
      5.890486225480862, -0.43825009903175643`}, {
      5.907187279742815, -0.4340203383883003}, {
      5.92134574988882, -0.4219749991730223}, {
      5.930806137185998, -0.4039478750901766}, {
      5.93412818342698, -0.3826834323650898}, {
      5.930806137185998, -0.36141898964000296`}}], 
     LineBox[{{6.283813625710304, 0.0554075367727629}, {6.283185307179586, 
      0.05556666666666667}, {6.266484252917633, 0.05133690602321049}, {
      6.252325782771628, 0.039291566807932485`}, {6.24286539547445, 
      0.02126444272508682}, {6.239543349233468, 0.}, {
      6.24286539547445, -0.02126444272508682}, {
      6.252325782771628, -0.039291566807932485`}, {
      6.266484252917633, -0.05133690602321049}, {
      6.283185307179586, -0.05556666666666667}, {
      6.283813625710304, -0.0554075367727629}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}], 
     CapForm[None], 
     LineBox[{{4.712703139650048, 1.4614033333333334`}, {5.003649525957503, 
      1.4614033333333334`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{4.898496244508912, 1.4826677760584202`}, {
      4.889035857211734, 1.500694900141266}, {4.874877387065729, 
      1.512740239356544}, {4.858176332803776, 1.5169700000000002`}, {
      4.8414752785418225`, 1.512740239356544}, {4.827316808395818, 
      1.500694900141266}, {4.817856421098639, 1.4826677760584202`}, {
      4.814534374857658, 1.4614033333333334`}, {4.817856421098639, 
      1.4401388906082466`}, {4.827316808395818, 1.4221117665254008`}, {
      4.8414752785418225`, 1.4100664273101229`}, {4.858176332803776, 
      1.4058366666666666`}, {4.874877387065729, 1.4100664273101229`}, {
      4.889035857211734, 1.4221117665254008`}, {4.898496244508912, 
      1.4401388906082466`}, {4.901818290749894, 1.4614033333333334`}, {
      4.898496244508912, 1.4826677760584202`}}], 
     {RGBColor[1, 0, 0], Opacity[1], 
      PolygonBox[{{4.898496244508912, 1.4826677760584202`}, {
       4.889035857211734, 1.500694900141266}, {4.874877387065729, 
       1.512740239356544}, {4.858176332803776, 1.5169700000000002`}, {
       4.8414752785418225`, 1.512740239356544}, {4.827316808395818, 
       1.500694900141266}, {4.817856421098639, 1.4826677760584202`}, {
       4.814534374857658, 1.4614033333333334`}, {4.817856421098639, 
       1.4401388906082466`}, {4.827316808395818, 1.4221117665254008`}, {
       4.8414752785418225`, 1.4100664273101229`}, {4.858176332803776, 
       1.4058366666666666`}, {4.874877387065729, 1.4100664273101229`}, {
       4.889035857211734, 1.4221117665254008`}, {4.898496244508912, 
       1.4401388906082466`}, {4.901818290749894, 1.4614033333333334`}}], 
      InsetBox[
       TagBox[
        StyleBox[
         TagBox["\<\"Data\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->15,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {5.076386122534367, 1.4614033333333334`}, {-1, 0}, 
       Automatic, {1, 0}]}}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{432, 216},
  PlotRange->{{-0.0006283185307179586, 6.283813625710304}, {-2.0004, 2.0004}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.49903438053125*^9, 3.499034423359375*^9}, {
   3.499034493171875*^9, 3.499034520640625*^9}, 3.507512420734375*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Log-log plotting (with error bars)", "Subsection",
 CellChangeTimes->{{3.499034063046875*^9, 3.499034073359375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "0."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.39269908169872414", ",", "0.3826834323650898"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7853981633974483", ",", "0.7071067811865475"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ErrorValue", "[", 
        RowBox[{"1.1781", ",", "0.2"}], "]"}], ",", 
       RowBox[{"ErrorValue", "[", 
        RowBox[{"0.92388", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.4"}], ",", "0.2"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5707963267948966", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.9634954084936207", ",", "0.9238795325112867"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.356194490192345", ",", "0.7071067811865475"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.748893571891069", ",", "0.3826834323650898"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.499034477234375*^9, 3.499034477828125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataValues", ",", 
       RowBox[{"AxisScaling", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Log", ",", "Log"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataLine", ",", 
       RowBox[{"Dashing", "\[Rule]", "4"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataSymbol", ",", 
       RowBox[{"SymbolShape", "\[Rule]", "\"\<Circle\>\""}], ",", 
       RowBox[{"FillColor", "\[Rule]", "Red"}], ",", 
       RowBox[{"SymbolSize", "\[Rule]", "6"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"DataPlot", "[", "\[IndentingNewLine]", 
      RowBox[{"Data", ",", 
       RowBox[{"Tag", "\[Rule]", 
        RowBox[{"set", "[", "1", "]"}]}]}], "\[IndentingNewLine]", "]"}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"DataLegend", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.75", ",", "0.9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"set", "[", "1", "]"}], ",", "\"\<Data\>\""}], "}"}], "}"}],
        ",", 
       RowBox[{"Length", "\[Rule]", "10"}], ",", 
       RowBox[{"Gap", "\[Rule]", "5"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0.1"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"LogTicks", "[", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"LogTicks", "[", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", "None", ",", "None"}], 
     "}"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQzdAwXTbl00tHBgY2RTDdYGQHoS86QOgLrhBazxtC
R1ZB1L+rhfAzJ0Ho1qkQes9MiPxVCN3QvApC31sDES/eA6H37YOIe52D0C7n
IfTHp6lg+WfPILTgvjQwbQahG468h/CfQOn8delg8XYIzdCwHcKP2gOhg+5C
aOl7EPlI+QwwnQ2lW9QhtJEmhBbUB9MN8hCaodwRQn92gohP8obQu/wh4rfC
ILRHLITWnwKhI6H02t0PBF8B1dvsBdMMD45AaKUTIBoAi/i1Jg==
  "]],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}], 
    CapForm[None], 
    LineBox[{{-0.40594011429780974`, -0.4171603394169174}, \
{-0.10491011863382854`, -0.15051499783199063`}, {
     0.07118215599008064, -0.03438443432343685}, {0.19611987703015263`, 0.}, {
     0.293029890038209, -0.03438465407905436}, {
     0.3722111360858339, -0.15051499783199063`}, {
     0.439157925716447, -0.4171603394169174}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], {{LineBox[{{
       0.07118215599008064, -0.03438443432343685}, {-0.009616741093766437, \
-0.03438443432343685}}], 
      LineBox[{{-0.009616741093766437, -0.04966526765677018}, \
{-0.009616741093766437, -0.019103600990103522`}}]}, {
      LineBox[{{0.07118215599008064, -0.03438443432343685}, {
       0.13928073271852426`, -0.03438443432343685}}], 
      LineBox[{{0.13928073271852426`, -0.04966526765677018}, {
       0.13928073271852426`, -0.019103600990103522`}}]}, {
      LineBox[{{0.07118215599008064, -0.03438443432343685}, {
       0.07118215599008064, -0.2807681811577708}}], 
      LineBox[{{0.057290489323413976`, -0.2807681811577708}, {
       0.0850738226567473, -0.2807681811577708}}]}, {
      LineBox[{{0.07118215599008064, -0.03438443432343685}, {
       0.07118215599008064, 0.05071994279889286}}], 
      LineBox[{{0.057290489323413976`, 0.05071994279889286}, {
       0.0850738226567473, 0.05071994279889286}}]}}, 
    {RGBColor[1, 0, 0], Opacity[1], 
     PolygonBox[{{-0.3931058877920071, -0.41131261766751853`}, \
{-0.3961172225958266, -0.406355158544736}, {-0.40062400361653805`, \
-0.4030426902605345}, {-0.40594011429780974`, -0.401879506083584}, \
{-0.41125622497908143`, -0.4030426902605345}, {-0.4157630059997929, \
-0.406355158544736}, {-0.41877434080361237`, -0.41131261766751853`}, \
{-0.41983178096447643`, -0.4171603394169174}, {-0.41877434080361237`, \
-0.42300806116631623`}, {-0.4157630059997929, -0.4279655202890988}, \
{-0.41125622497908143`, -0.43127798857330024`}, {-0.40594011429780974`, \
-0.43244117275025074`}, {-0.40062400361653805`, -0.43127798857330024`}, \
{-0.3961172225958266, -0.4279655202890988}, {-0.3931058877920071, \
-0.42300806116631623`}, {-0.39204844763114305`, -0.4171603394169174}}], 
     PolygonBox[{{-0.09207589212802592, -0.14466727608259175`}, \
{-0.09508722693184542, -0.1397098169598092}, {-0.09959400795255684, \
-0.13639734867560774`}, {-0.10491011863382854`, -0.1352341644986573}, \
{-0.11022622931510025`, -0.13639734867560774`}, {-0.11473301033581167`, \
-0.1397098169598092}, {-0.11774434513963117`, -0.14466727608259175`}, \
{-0.1188017853004952, -0.15051499783199063`}, {-0.11774434513963117`, \
-0.1563627195813895}, {-0.11473301033581167`, -0.16132017870417206`}, \
{-0.11022622931510025`, -0.16463264698837352`}, {-0.10491011863382854`, \
-0.16579583116532395`}, {-0.09959400795255684, -0.16463264698837352`}, \
{-0.09508722693184542, -0.16132017870417206`}, {-0.09207589212802592, \
-0.1563627195813895}, {-0.09101845196716188, -0.15051499783199063`}}], 
     PolygonBox[{{0.08401638249588327, -0.028536712574037976`}, {
      0.08100504769206376, -0.02357925345125542}, {
      0.07649826667135234, -0.02026678516705397}, {
      0.07118215599008064, -0.019103600990103522`}, {
      0.06586604530880893, -0.02026678516705397}, {
      0.061359264288097515`, -0.02357925345125542}, {
      0.05834792948427801, -0.028536712574037976`}, {
      0.057290489323413976`, -0.03438443432343685}, {
      0.05834792948427801, -0.04023215607283573}, {
      0.061359264288097515`, -0.04518961519561829}, {
      0.06586604530880893, -0.048502083479819734`}, {
      0.07118215599008064, -0.04966526765677018}, {
      0.07649826667135234, -0.048502083479819734`}, {
      0.08100504769206376, -0.04518961519561829}, {
      0.08401638249588327, -0.04023215607283573}, {
      0.0850738226567473, -0.03438443432343685}}], 
     PolygonBox[{{0.20895410353595525`, 0.005847721749398875}, {
      0.20594276873213574`, 0.010805180872181432`}, {0.20143598771142435`, 
      0.014117649156382884`}, {0.19611987703015263`, 0.01528083333333333}, {
      0.1908037663488809, 0.014117649156382884`}, {0.18629698532816952`, 
      0.010805180872181432`}, {0.18328565052435, 0.005847721749398875}, {
      0.18222821036348597`, 0.}, {0.18328565052435, -0.005847721749398875}, {
      0.18629698532816952`, -0.010805180872181432`}, {
      0.1908037663488809, -0.014117649156382884`}, {
      0.19611987703015263`, -0.01528083333333333}, {
      0.20143598771142435`, -0.014117649156382884`}, {
      0.20594276873213574`, -0.010805180872181432`}, {
      0.20895410353595525`, -0.005847721749398875}, {0.2100115436968193, 
      0.}}], PolygonBox[{{0.30586411654401163`, -0.028536932329655484`}, {
      0.30285278174019215`, -0.02357947320687293}, {
      0.2983460007194807, -0.02026700492267148}, {
      0.293029890038209, -0.01910382074572103}, {
      0.2877137793569373, -0.02026700492267148}, {
      0.28320699833622587`, -0.02357947320687293}, {
      0.2801956635324064, -0.028536932329655484`}, {
      0.2791382233715423, -0.03438465407905436}, {
      0.2801956635324064, -0.04023237582845324}, {
      0.28320699833622587`, -0.0451898349512358}, {
      0.2877137793569373, -0.04850230323543724}, {
      0.293029890038209, -0.04966548741238769}, {
      0.2983460007194807, -0.04850230323543724}, {
      0.30285278174019215`, -0.0451898349512358}, {
      0.30586411654401163`, -0.04023237582845324}, {
      0.3069215567048757, -0.03438465407905436}}], 
     PolygonBox[{{0.3850453625916365, -0.14466727608259175`}, {
      0.38203402778781703`, -0.1397098169598092}, {
      0.3775272467671056, -0.13639734867560774`}, {
      0.3722111360858339, -0.1352341644986573}, {
      0.3668950254045622, -0.13639734867560774`}, {
      0.36238824438385075`, -0.1397098169598092}, {
      0.35937690958003127`, -0.14466727608259175`}, {
      0.3583194694191672, -0.15051499783199063`}, {
      0.35937690958003127`, -0.1563627195813895}, {
      0.36238824438385075`, -0.16132017870417206`}, {
      0.3668950254045622, -0.16463264698837352`}, {
      0.3722111360858339, -0.16579583116532395`}, {
      0.3775272467671056, -0.16463264698837352`}, {
      0.38203402778781703`, -0.16132017870417206`}, {
      0.3850453625916365, -0.1563627195813895}, {
      0.3861028027525006, -0.15051499783199063`}}], 
     PolygonBox[{{0.45199215222224964`, -0.41131261766751853`}, {
      0.44898081741843016`, -0.406355158544736}, {
      0.4444740363977187, -0.4030426902605345}, {
      0.439157925716447, -0.401879506083584}, {
      0.4338418150351753, -0.4030426902605345}, {
      0.4293350340144639, -0.406355158544736}, {
      0.4263236992106444, -0.41131261766751853`}, {
      0.4252662590497803, -0.4171603394169174}, {
      0.4263236992106444, -0.42300806116631623`}, {
      0.4293350340144639, -0.4279655202890988}, {
      0.4338418150351753, -0.43127798857330024`}, {
      0.439157925716447, -0.43244117275025074`}, {
      0.4444740363977187, -0.43127798857330024`}, {
      0.44898081741843016`, -0.4279655202890988}, {
      0.45199215222224964`, -0.42300806116631623`}, {
      0.4530495923831137, -0.4171603394169174}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{-0.3931058877920071, -0.41131261766751853`}, \
{-0.3961172225958266, -0.406355158544736}, {-0.40062400361653805`, \
-0.4030426902605345}, {-0.40594011429780974`, -0.401879506083584}, \
{-0.41125622497908143`, -0.4030426902605345}, {-0.4157630059997929, \
-0.406355158544736}, {-0.41877434080361237`, -0.41131261766751853`}, \
{-0.41983178096447643`, -0.4171603394169174}, {-0.41877434080361237`, \
-0.42300806116631623`}, {-0.4157630059997929, -0.4279655202890988}, \
{-0.41125622497908143`, -0.43127798857330024`}, {-0.40594011429780974`, \
-0.43244117275025074`}, {-0.40062400361653805`, -0.43127798857330024`}, \
{-0.3961172225958266, -0.4279655202890988}, {-0.3931058877920071, \
-0.42300806116631623`}, {-0.39204844763114305`, -0.4171603394169174}, \
{-0.3931058877920071, -0.41131261766751853`}}], 
     LineBox[{{-0.09207589212802592, -0.14466727608259175`}, \
{-0.09508722693184542, -0.1397098169598092}, {-0.09959400795255684, \
-0.13639734867560774`}, {-0.10491011863382854`, -0.1352341644986573}, \
{-0.11022622931510025`, -0.13639734867560774`}, {-0.11473301033581167`, \
-0.1397098169598092}, {-0.11774434513963117`, -0.14466727608259175`}, \
{-0.1188017853004952, -0.15051499783199063`}, {-0.11774434513963117`, \
-0.1563627195813895}, {-0.11473301033581167`, -0.16132017870417206`}, \
{-0.11022622931510025`, -0.16463264698837352`}, {-0.10491011863382854`, \
-0.16579583116532395`}, {-0.09959400795255684, -0.16463264698837352`}, \
{-0.09508722693184542, -0.16132017870417206`}, {-0.09207589212802592, \
-0.1563627195813895}, {-0.09101845196716188, -0.15051499783199063`}, \
{-0.09207589212802592, -0.14466727608259175`}}], 
     LineBox[{{0.08401638249588327, -0.028536712574037976`}, {
      0.08100504769206376, -0.02357925345125542}, {
      0.07649826667135234, -0.02026678516705397}, {
      0.07118215599008064, -0.019103600990103522`}, {
      0.06586604530880893, -0.02026678516705397}, {
      0.061359264288097515`, -0.02357925345125542}, {
      0.05834792948427801, -0.028536712574037976`}, {
      0.057290489323413976`, -0.03438443432343685}, {
      0.05834792948427801, -0.04023215607283573}, {
      0.061359264288097515`, -0.04518961519561829}, {
      0.06586604530880893, -0.048502083479819734`}, {
      0.07118215599008064, -0.04966526765677018}, {
      0.07649826667135234, -0.048502083479819734`}, {
      0.08100504769206376, -0.04518961519561829}, {
      0.08401638249588327, -0.04023215607283573}, {
      0.0850738226567473, -0.03438443432343685}, {
      0.08401638249588327, -0.028536712574037976`}}], 
     LineBox[{{0.20895410353595525`, 0.005847721749398875}, {
      0.20594276873213574`, 0.010805180872181432`}, {0.20143598771142435`, 
      0.014117649156382884`}, {0.19611987703015263`, 0.01528083333333333}, {
      0.1908037663488809, 0.014117649156382884`}, {0.18629698532816952`, 
      0.010805180872181432`}, {0.18328565052435, 0.005847721749398875}, {
      0.18222821036348597`, 0.}, {0.18328565052435, -0.005847721749398875}, {
      0.18629698532816952`, -0.010805180872181432`}, {
      0.1908037663488809, -0.014117649156382884`}, {
      0.19611987703015263`, -0.01528083333333333}, {
      0.20143598771142435`, -0.014117649156382884`}, {
      0.20594276873213574`, -0.010805180872181432`}, {
      0.20895410353595525`, -0.005847721749398875}, {0.2100115436968193, 
      0.}, {0.20895410353595525`, 0.005847721749398875}}], 
     LineBox[{{0.30586411654401163`, -0.028536932329655484`}, {
      0.30285278174019215`, -0.02357947320687293}, {
      0.2983460007194807, -0.02026700492267148}, {
      0.293029890038209, -0.01910382074572103}, {
      0.2877137793569373, -0.02026700492267148}, {
      0.28320699833622587`, -0.02357947320687293}, {
      0.2801956635324064, -0.028536932329655484`}, {
      0.2791382233715423, -0.03438465407905436}, {
      0.2801956635324064, -0.04023237582845324}, {
      0.28320699833622587`, -0.0451898349512358}, {
      0.2877137793569373, -0.04850230323543724}, {
      0.293029890038209, -0.04966548741238769}, {
      0.2983460007194807, -0.04850230323543724}, {
      0.30285278174019215`, -0.0451898349512358}, {
      0.30586411654401163`, -0.04023237582845324}, {
      0.3069215567048757, -0.03438465407905436}, {
      0.30586411654401163`, -0.028536932329655484`}}], 
     LineBox[{{0.3850453625916365, -0.14466727608259175`}, {
      0.38203402778781703`, -0.1397098169598092}, {
      0.3775272467671056, -0.13639734867560774`}, {
      0.3722111360858339, -0.1352341644986573}, {
      0.3668950254045622, -0.13639734867560774`}, {
      0.36238824438385075`, -0.1397098169598092}, {
      0.35937690958003127`, -0.14466727608259175`}, {
      0.3583194694191672, -0.15051499783199063`}, {
      0.35937690958003127`, -0.1563627195813895}, {
      0.36238824438385075`, -0.16132017870417206`}, {
      0.3668950254045622, -0.16463264698837352`}, {
      0.3722111360858339, -0.16579583116532395`}, {
      0.3775272467671056, -0.16463264698837352`}, {
      0.38203402778781703`, -0.16132017870417206`}, {
      0.3850453625916365, -0.1563627195813895}, {
      0.3861028027525006, -0.15051499783199063`}, {
      0.3850453625916365, -0.14466727608259175`}}], 
     LineBox[{{0.45199215222224964`, -0.41131261766751853`}, {
      0.44898081741843016`, -0.406355158544736}, {
      0.4444740363977187, -0.4030426902605345}, {
      0.439157925716447, -0.401879506083584}, {
      0.4338418150351753, -0.4030426902605345}, {
      0.4293350340144639, -0.406355158544736}, {
      0.4263236992106444, -0.41131261766751853`}, {
      0.4252662590497803, -0.4171603394169174}, {
      0.4263236992106444, -0.42300806116631623`}, {
      0.4293350340144639, -0.4279655202890988}, {
      0.4338418150351753, -0.43127798857330024`}, {
      0.439157925716447, -0.43244117275025074`}, {
      0.4444740363977187, -0.43127798857330024`}, {
      0.44898081741843016`, -0.4279655202890988}, {
      0.45199215222224964`, -0.42300806116631623`}, {
      0.4530495923831137, -0.4171603394169174}, {
      0.45199215222224964`, -0.41131261766751853`}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], AbsoluteDashing[{4, 2}], 
     CapForm[None], 
     LineBox[{{0.5001, -0.04811408333333336}, {
      0.5927111111111111, -0.04811408333333336}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], LineBox[{{0.5592397820613582, -0.042266361583934486`}, {
      0.5562284472575387, -0.03730890246115193}, {
      0.5517216662368273, -0.03399643417695048}, {
      0.5464055555555556, -0.032833250000000036`}, {
      0.5410894448742839, -0.03399643417695048}, {
      0.5365826638535725, -0.03730890246115193}, {
      0.533571329049753, -0.042266361583934486`}, {
      0.532513888888889, -0.04811408333333336}, {
      0.533571329049753, -0.05396180508273224}, {
      0.5365826638535725, -0.0589192642055148}, {
      0.5410894448742839, -0.062231732489716245`}, {
      0.5464055555555556, -0.06339491666666669}, {
      0.5517216662368273, -0.062231732489716245`}, {
      0.5562284472575387, -0.0589192642055148}, {
      0.5592397820613582, -0.05396180508273224}, {
      0.5602972222222222, -0.04811408333333336}, {
      0.5592397820613582, -0.042266361583934486`}}], 
     {RGBColor[1, 0, 0], Opacity[1], 
      PolygonBox[{{0.5592397820613582, -0.042266361583934486`}, {
       0.5562284472575387, -0.03730890246115193}, {
       0.5517216662368273, -0.03399643417695048}, {
       0.5464055555555556, -0.032833250000000036`}, {
       0.5410894448742839, -0.03399643417695048}, {
       0.5365826638535725, -0.03730890246115193}, {
       0.533571329049753, -0.042266361583934486`}, {
       0.532513888888889, -0.04811408333333336}, {
       0.533571329049753, -0.05396180508273224}, {
       0.5365826638535725, -0.0589192642055148}, {
       0.5410894448742839, -0.062231732489716245`}, {
       0.5464055555555556, -0.06339491666666669}, {
       0.5517216662368273, -0.062231732489716245`}, {
       0.5562284472575387, -0.0589192642055148}, {
       0.5592397820613582, -0.05396180508273224}, {
       0.5602972222222222, -0.04811408333333336}}], InsetBox[
       TagBox[
        StyleBox[
         TagBox["\<\"Data\"\>",
          DisplayForm],
         StripOnInput->False,
         ShowAutoStyles->False,
         SingleLetterItalics->False,
         FontFamily->"Times",
         FontSize->15,
         FontWeight->"Plain",
         FontSlant->"Plain",
         FontTracking->"Plain",
         FontColor->GrayLevel[0],
         FontOpacity->1],
        DisplayForm], {0.6158638888888889, -0.04811408333333336}, {-1, 0}, 
       Automatic, {1, 0}]}}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->{{{-2., 
      FormBox[
       TagBox[
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {-1., 
      FormBox[
       TagBox[
        SuperscriptBox["10", 
         RowBox[{"-", "1"}]], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {0., 
      FormBox[
       TagBox[
        SuperscriptBox["10", "0"], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {1., 
      FormBox[
       TagBox[
        SuperscriptBox["10", "1"], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {2., 
      FormBox[
       TagBox[
        SuperscriptBox["10", "2"], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {-1.6989700043360187`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.5228787452803376`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.3979400086720377`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.3010299956639813`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.2218487496163566`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.1549019599857433`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.0969100130080567`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.0457574905606752`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {-0.6989700043360189, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {-0.5228787452803376, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {-0.3979400086720377, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-0.30102999566398136`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-0.22184874961635648`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {-0.1549019599857433, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-0.09691001300805668, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-0.04575749056067524, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {
     0.30102999566398114`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.4771212547196624, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.6020599913279623, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.6989700043360186, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.7781512503836435, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.8450980400142567, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.9030899869919433, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.9542425094393248, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.3010299956639813`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.4771212547196624`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.6020599913279623`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.6989700043360187`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.7781512503836434`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.8450980400142567`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.9030899869919433`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.9542425094393248`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}}, {{-2., 
      FormBox[
       TagBox[
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {-1., 
      FormBox[
       TagBox[
        SuperscriptBox["10", 
         RowBox[{"-", "1"}]], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {0., 
      FormBox[
       TagBox[
        SuperscriptBox["10", "0"], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {1., 
      FormBox[
       TagBox[
        SuperscriptBox["10", "1"], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {2., 
      FormBox[
       TagBox[
        SuperscriptBox["10", "2"], DisplayForm], TraditionalForm], {
      0.01, 0}, {}}, {-1.6989700043360187`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.5228787452803376`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.3979400086720377`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.3010299956639813`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.2218487496163566`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.1549019599857433`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.0969100130080567`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-1.0457574905606752`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {-0.6989700043360189, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {-0.5228787452803376, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {-0.3979400086720377, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-0.30102999566398136`, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-0.22184874961635648`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {-0.1549019599857433, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-0.09691001300805668, 
      FormBox["\"\"", TraditionalForm], {
      0.005, 0}, {}}, {-0.04575749056067524, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {
     0.30102999566398114`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.4771212547196624, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.6020599913279623, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.6989700043360186, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.7781512503836435, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.8450980400142567, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.9030899869919433, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {0.9542425094393248, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.3010299956639813`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.4771212547196624`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.6020599913279623`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.6989700043360187`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.7781512503836434`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.8450980400142567`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.9030899869919433`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}, {1.9542425094393248`, 
      FormBox["\"\"", TraditionalForm], {0.005, 0}, {}}}, None, None},
  ImageSize->{432, 216},
  PlotRange->{{-1.0002, 1.0002}, {-1.00011, 0.10011}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.499034165546875*^9, 3.499034177671875*^9}, 
   3.499034215296875*^9, 3.49903431184375*^9, {3.499034468203125*^9, 
   3.49903448240625*^9}, 3.507512421015625*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Step line shape", "Subsection",
 CellChangeTimes->{{3.499034599828125*^9, 3.499034602140625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Data", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"N", "@", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "*", "Pi"}], ",", 
      RowBox[{"Pi", "/", "8"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4990346065625*^9, 3.499034607171875*^9}, {
  3.499034651703125*^9, 3.499034658046875*^9}, {3.499034810796875*^9, 
  3.49903481109375*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.39269908169872414`", ",", "0.3826834323650898`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7853981633974483`", ",", "0.7071067811865475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1780972450961724`", ",", "0.9238795325112867`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5707963267948966`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9634954084936207`", ",", "0.9238795325112867`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.356194490192345`", ",", "0.7071067811865475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.748893571891069`", ",", "0.3826834323650898`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.141592653589793`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5342917352885173`", ",", 
     RowBox[{"-", "0.3826834323650898`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9269908169872414`", ",", 
     RowBox[{"-", "0.7071067811865475`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.319689898685965`", ",", 
     RowBox[{"-", "0.9238795325112867`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.71238898038469`", ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.105088062083414`", ",", 
     RowBox[{"-", "0.9238795325112867`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.497787143782138`", ",", 
     RowBox[{"-", "0.7071067811865475`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.890486225480862`", ",", 
     RowBox[{"-", "0.3826834323650898`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.283185307179586`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.499034608203125*^9, 3.4990346590625*^9, 
  3.49903481165625*^9, 3.5075124210625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataLine", ",", 
       RowBox[{"LineShape", "\[Rule]", "\"\<Step\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataSymbol", ",", 
       RowBox[{"Show", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DataPlot", "[", 
      RowBox[{"Data", ",", 
       RowBox[{"Tag", "\[Rule]", 
        RowBox[{"set", "[", "1", "]"}]}]}], "]"}], ",", "\[IndentingNewLine]",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"DataLegend", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.75", ",", "0.9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"set", "[", "1", "]"}], ",", "\"\<Data\>\""}], "}"}], "}"}],
        ",", 
       RowBox[{"Length", "\[Rule]", "10"}], ",", 
       RowBox[{"Gap", "\[Rule]", "5"}], ",", 
       RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.4990346324375*^9, 3.4990346375*^9}, {3.49903467525*^9, 
  3.49903470178125*^9}, {3.49903473765625*^9, 3.499034776921875*^9}, {
  3.4990348075625*^9, 3.499034830625*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAmIQDQU2MIaErkvIb8WT9uj85JXrlj2qvWF/SdG4vubm
Iwz+Gev6tHkLntnHWYRqVmW9x+C79Rqdz57w1r50+e6Xu/9+xeBDbPtgv3vT
mX1Wbn8w+DD1DPffnYxxZ3RA58PsW5JSbjInmwWDD3Ov26v/8273s2PwYf59
ld/BKb2FC4MPVb+/56tASdQNXgw+1L79M/b6vPepE8DgQ927P5Nh4pIcASEM
PtS/+62dr0b2LBLG4MPU87RJ8q8xEcXgw+y7dyL2yOljYhh8mHvXcy+qfB0h
gcFHjW9JOB8AKU7r9A==
     "]]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{4.712703139650048, 1.4614033333333334`}, {
     5.003649525957503, 1.4614033333333334`}}], InsetBox[
     TagBox[
      StyleBox[
       TagBox["\<\"Data\"\>",
        DisplayForm],
       StripOnInput->False,
       ShowAutoStyles->False,
       SingleLetterItalics->False,
       FontFamily->"Times",
       FontSize->15,
       FontWeight->"Plain",
       FontSlant->"Plain",
       FontTracking->"Plain",
       FontColor->GrayLevel[0],
       FontOpacity->1],
      DisplayForm], {5.076386122534367, 1.4614033333333334`}, {-1, 0}, 
     Automatic, {1, 0}]}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{432, 216},
  PlotRange->{{-0.0006283185307179586, 6.283813625710304}, {-2.0004, 2.0004}},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.49903463375*^9, 3.499034638125*^9}, {
   3.499034751390625*^9, 3.499034777671875*^9}, {3.49903482009375*^9, 
   3.49903483115625*^9}, 3.507512421203125*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Plotting imported data, plus a complicated diagram -- Shell model basis \
dimension plot\
\>", "Section",
 CellChangeTimes->{{3.4888367863125*^9, 3.48883678853125*^9}, {
  3.491258775640625*^9, 3.491258786375*^9}, {3.49212491759375*^9, 
  3.492124954421875*^9}}],

Cell["\<\
define coordinate system for three-dimensional harmonic oscillator potential
\t(the specific numbers have to do with the quantum mechanics)\
\>", "Text",
 CellChangeTimes->{{3.488837981328125*^9, 3.4888380186875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ShellDimension", "[", 
    RowBox[{"N_", "?", "NonNegative"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"N", "+", "1"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"N", "+", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HOE", "[", 
    RowBox[{"N_", "?", "NonNegative"}], "]"}], ":=", 
   RowBox[{"N", "+", 
    RowBox[{"3", "/", "2"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.488195478640625*^9, 3.488195482125*^9}, {
   3.48819553796875*^9, 3.488195563265625*^9}, {3.48819560025*^9, 
   3.4881956115625*^9}, {3.488196355671875*^9, 3.488196355859375*^9}, {
   3.488196554828125*^9, 3.488196556515625*^9}, 3.488198187046875*^9, {
   3.48819899215625*^9, 3.48819900371875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HOScale", "[", 
    RowBox[{"N1_", "?", "NonNegative"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yMax", ",", "xMax"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"yMax", "=", 
       RowBox[{"HOE", "[", 
        RowBox[{"N1", "+", 
         RowBox[{"1", "/", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xMax", "=", 
       RowBox[{"Sqrt", "[", "yMax", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "xMax"}], ",", 
        RowBox[{"1", "/", "yMax"}]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.488197272046875*^9, 3.488197334453125*^9}, {
  3.48819741353125*^9, 3.488197525609375*^9}}],

Cell["\<\
define function to plot harmonic oscillator -- and also set the local \
coordinate system for dots and arrows to be plotted on top of the harmonic \
oscillator\
\>", "Text",
 CellChangeTimes->{{3.488838037796875*^9, 3.488838064140625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "HOPlot", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HOPotlOpts", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thickness", "\[Rule]", "2"}], "}"}]}], ",", 
     RowBox[{"HOLevelOpts", "\[Rule]", 
      RowBox[{"{", "}"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HOPlot", "[", 
    RowBox[{
     RowBox[{"N1_", "?", "NonNegative"}], ",", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "yMax", ",", "xMax", ",", "ScaleFunction"}],
       "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"set", " ", "global", " ", 
        RowBox[{"scale", " ", "--"}], " ", "plot", " ", "up", " ", "to", " ", 
        "half", " ", "a", " ", "level", " ", "above", " ", "N1"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"yMax", "=", 
        RowBox[{"HOE", "[", 
         RowBox[{"N1", "+", 
          RowBox[{"1", "/", "2"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"xMax", "=", 
        RowBox[{"Sqrt", "[", "yMax", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"SetScale", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "xMax"}], ",", 
          RowBox[{"1", "/", "yMax"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"plot", " ", 
         RowBox[{"levels", " ", "--"}], " ", "behind", " ", "potential"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"y", "=", 
            RowBox[{"HOE", "[", "N", "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"SchemeLine", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"Sqrt", "[", "y", "]"}]}], ",", "y"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Sqrt", "[", "y", "]"}], ",", "y"}], "}"}]}], "}"}], 
             ",", 
             RowBox[{"OptionValue", "[", "HOLevelOpts", "]"}]}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"N", ",", "0", ",", "N1"}], "}"}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"plot", " ", "potential"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"SchemeLine", "[", 
        RowBox[{
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"x", "^", "2"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "xMax"}], ",", 
             RowBox[{"+", "xMax"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"OptionValue", "[", "HOPotlOpts", "]"}]}], "]"}], ","}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.488195700734375*^9, 3.4881959901875*^9}, {
  3.488196058546875*^9, 3.4881961170625*^9}, {3.4881962383125*^9, 
  3.488196275109375*^9}, {3.488196361375*^9, 3.4881964714375*^9}, {
  3.488197316109375*^9, 3.488197349796875*^9}, {3.4881975649375*^9, 
  3.48819761409375*^9}, {3.488197894640625*^9, 3.4881979455625*^9}, {
  3.488200389484375*^9, 3.488200400046875*^9}, {3.499022534140625*^9, 
  3.4990225455625*^9}, {3.499022575671875*^9, 3.499022581984375*^9}}],

Cell["define functions to draw dots", "Text",
 CellChangeTimes->{{3.488197655140625*^9, 3.488197673015625*^9}, 
   3.4881982679375*^9, {3.488838068328125*^9, 3.4888380755*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "HOPoint", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"Scale", "\[Rule]", "0.1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HOPoint", "[", 
    RowBox[{
     RowBox[{"N_", "?", "NonNegative"}], ",", 
     RowBox[{
      RowBox[{"(", "k_Integer", ")"}], "?", "Positive"}], ",", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"y", "=", 
       RowBox[{"HOE", "[", "N", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"x", "=", 
       RowBox[{
        RowBox[{"OptionValue", "[", "Scale", "]"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ShellDimension", "[", "N", "]"}], "-", "1"}], ")"}]}], 
          "+", 
          RowBox[{"(", 
           RowBox[{"k", "-", "1"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4881986888125*^9, 3.488198758984375*^9}, 
   3.488198804671875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "HODot", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DotRadius", "\[Rule]", 
      RowBox[{"Point", "[", "2", "]"}]}], ",", 
     RowBox[{"DotOptions", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"Occupied", "\[Rule]", "True"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HODot", "[", 
    RowBox[{
     RowBox[{"N_", "?", "NonNegative"}], ",", 
     RowBox[{
      RowBox[{"(", "k_Integer", ")"}], "?", "Positive"}], ",", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"SchemeCircle", "[", 
       RowBox[{
        RowBox[{"HOPoint", "[", 
         RowBox[{"N", ",", "k"}], "]"}], ",", 
        RowBox[{"OptionValue", "[", "DotRadius", "]"}], ",", 
        RowBox[{"OptionValue", "[", "DotOptions", "]"}], ",", 
        RowBox[{"ShowFill", "\[Rule]", 
         RowBox[{"OptionValue", "[", "Occupied", "]"}]}]}], "]"}], 
      "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4881972606875*^9, 3.48819726125*^9}, {
   3.48819761890625*^9, 3.488197640078125*^9}, {3.488197678703125*^9, 
   3.488197890359375*^9}, {3.48819821825*^9, 3.488198263234375*^9}, {
   3.488198308421875*^9, 3.488198312375*^9}, {3.488198395109375*^9, 
   3.488198438765625*^9}, {3.4881985739375*^9, 3.48819859771875*^9}, 
   3.488198711578125*^9, {3.488198764453125*^9, 3.48819877359375*^9}}],

Cell["Basis data import", "Text",
 CellChangeTimes->{{3.488190852953125*^9, 3.488190857125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nuclei", "=", 
  RowBox[{"{", 
   RowBox[{
   "\"\<8Be\>\"", ",", "\"\<12C\>\"", ",", "\"\<16O\>\"", ",", "\"\<20Ne\>\"",
     ",", "\"\<24Mg\>\""}], "}"}]}]], "Input",
 CellChangeTimes->{{3.4881502433125*^9, 3.488150244171875*^9}, {
   3.48818966853125*^9, 3.4881897620625*^9}, {3.488190014109375*^9, 
   3.488190022953125*^9}, {3.488190166203125*^9, 3.48819017075*^9}, {
   3.488190415*^9, 3.4881904205625*^9}, {3.488190812625*^9, 
   3.488190830984375*^9}, 3.488838084734375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"8Be\"\>", ",", "\<\"12C\"\>", ",", "\<\"16O\"\>", 
   ",", "\<\"20Ne\"\>", ",", "\<\"24Mg\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.488190473546875*^9, 3.48819083128125*^9, 
  3.488366261859375*^9, 3.488370149203125*^9, 3.488838102*^9, 
  3.49566109403125*^9, 3.49722502609375*^9, 3.49902255771875*^9, 
  3.507512421265625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FileName", "=", 
      RowBox[{
      "\"\<LevelScheme/ExampleData/dims_\>\"", "<>", "x", "<>", "\"\<_\>\"", "<>",
        "DataSet", "<>", "\"\<.dat\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "FileName", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"DimensionData", "[", 
       RowBox[{"x", ",", "DataSet"}], "]"}], "=", 
      RowBox[{"Import", "[", "FileName", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "@", 
      RowBox[{"DimensionData", "[", 
       RowBox[{"x", ",", "DataSet"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "Nuclei"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"DataSet", ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"x", "\[Equal]", "\"\<12C\>\""}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<m\>\"", ",", "\"\<j-0\>\""}], "}"}], ",", 
        RowBox[{"{", "\"\<m\>\"", "}"}]}], "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4881502433125*^9, 3.488150244171875*^9}, {
   3.48818966853125*^9, 3.488189775140625*^9}, {3.488190428484375*^9, 
   3.488190508203125*^9}, {3.488190567828125*^9, 3.488190601171875*^9}, {
   3.488190649015625*^9, 3.488190795*^9}, {3.488838088078125*^9, 
   3.488838144796875*^9}, {3.492125290078125*^9, 3.492125292*^9}, {
   3.492125463234375*^9, 3.4921254636875*^9}, {3.4956599229375*^9, 
   3.495659925921875*^9}, 3.497225000265625*^9, {3.507512408375*^9, 
   3.507512409546875*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"LevelScheme/ExampleData/dims_8Be_m.dat\"\>"], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.507512421296875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "51"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5103"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "143792"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "2217754"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "23346724"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "187304858"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "1222330036"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "6770401490"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "32787482114"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "141871838200"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "557615009428"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.50751242159375*^9}],

Cell[BoxData["\<\"LevelScheme/ExampleData/dims_12C_m.dat\"\>"], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.507512421625*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "51"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "17725"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1118926"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "32598920"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "594496743"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7830355795"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "80791831793"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "687586662589"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "5000645950810"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "31883820915478"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "181683757394328"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.507512421796875*^9}],

Cell[BoxData["\<\"LevelScheme/ExampleData/dims_12C_j-0.dat\"\>"], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.5075124218125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1223"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "54692"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1260008"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "19001265"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "212516741"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "1896492709"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "14154420593"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "91266485614"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "520524613808"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "2673031464496"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.507512421921875*^9}],

Cell[BoxData["\<\"LevelScheme/ExampleData/dims_16O_m.dat\"\>"], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.507512421953125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1245"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "345365"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "26483625"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "996878170"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "23709299558"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "406327725468"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "5425818528852"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "59403380960781"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "552459133073711"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "4478768089572347"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.50751242225*^9}],

Cell[BoxData["\<\"LevelScheme/ExampleData/dims_20Ne_m.dat\"\>"], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.50751242228125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "640"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "542072"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "74668421"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4392390341"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "152243743459"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "3638757261551"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "65707716312680"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "950734053547124"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "11478322774747285"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "118565877620996657"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "913788212122942315"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.507512422453125*^9}],

Cell[BoxData["\<\"LevelScheme/ExampleData/dims_24Mg_m.dat\"\>"], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.50751242246875*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "28503"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "17941903"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2330225841"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "142516975375"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "5371018298923"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "142772869772281"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "2902084251756085"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "47571333233735467"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "577737308933988851"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "3946162315235158335"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "17360663094100388619"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.495661094859375*^9, 3.49722502678125*^9, 
  3.49902255846875*^9, 3.507512422546875*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NucleusLabels", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\"\<8Be\>\"", "\[Rule]", 
      RowBox[{"NucleusBox", "[", 
       RowBox[{"\"\<Be\>\"", ",", 
        RowBox[{"NuclearA", "\[Rule]", "8"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<12C\>\"", "\[Rule]", 
      RowBox[{"NucleusBox", "[", 
       RowBox[{"\"\<C\>\"", ",", 
        RowBox[{"NuclearA", "\[Rule]", "12"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<16O\>\"", "\[Rule]", 
      RowBox[{"NucleusBox", "[", 
       RowBox[{"\"\<O\>\"", ",", 
        RowBox[{"NuclearA", "\[Rule]", "16"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<20Ne\>\"", "\[Rule]", 
      RowBox[{"NucleusBox", "[", 
       RowBox[{"\"\<Ne\>\"", ",", 
        RowBox[{"NuclearA", "\[Rule]", "20"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<24Mg\>\"", "\[Rule]", 
      RowBox[{"NucleusBox", "[", 
       RowBox[{"\"\<Mg\>\"", ",", 
        RowBox[{"NuclearA", "\[Rule]", "24"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NucleusPosns", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\"\<8Be\>\"", "\[Rule]", "0.40"}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<12C\>\"", "\[Rule]", "0.30"}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<16O\>\"", "\[Rule]", "0.53"}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<20Ne\>\"", "\[Rule]", "0.29"}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<24Mg\>\"", "\[Rule]", "0.27"}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NucleusColors", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\"\<12C\>\"", "\[Rule]", "Firebrick"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"_", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Figure", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ShowPanelLetter", "\[Rule]", "False"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Margin", "\[Rule]", "40"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"FigurePanel", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "20"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "12"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"LinTicks", "[", 
           RowBox[{"0", ",", "20", ",", "2", ",", "1"}], "]"}], ",", 
          RowBox[{"LogTicks", "[", 
           RowBox[{"0", ",", "20", ",", 
            RowBox[{"TickLabelStep", "\[Rule]", "2"}]}], "]"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"LabB", "\[Rule]", "\"\<Excitation quanta\>\""}], ",", 
       RowBox[{"BufferB", "\[Rule]", "3.0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabL", "\[Rule]", "\"\<Dimension\>\""}], ",", 
       RowBox[{"BufferL", "\[Rule]", "4.0"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataValues", ",", 
       RowBox[{"AxisScaling", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"None", ",", "Log"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"DataSymbol", ",", 
       RowBox[{"FillColor", "\[Rule]", "White"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"DataPlot", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"DimensionData", "[", 
            RowBox[{"x", ",", "\"\<m\>\""}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Tag", "\[Rule]", 
            RowBox[{"Curve", "[", 
             RowBox[{"x", ",", "\"\<m\>\""}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"DataLine", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Color", "\[Rule]", 
              RowBox[{"Replace", "[", 
               RowBox[{"x", ",", "NucleusColors"}], "]"}]}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"DataSymbol", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Color", "\[Rule]", 
              RowBox[{"Replace", "[", 
               RowBox[{"x", ",", "NucleusColors"}], "]"}]}], "}"}]}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"DataLabel", "[", 
          RowBox[{
           RowBox[{"Curve", "[", 
            RowBox[{"x", ",", "\"\<m\>\""}], "]"}], ",", 
           RowBox[{"LabT", "\[Rule]", 
            RowBox[{"Replace", "[", 
             RowBox[{"x", ",", "NucleusLabels"}], "]"}]}], ",", 
           RowBox[{"PosnT", "\[Rule]", 
            RowBox[{"Replace", "[", 
             RowBox[{"x", ",", "NucleusPosns"}], "]"}]}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "Nuclei"}], "}"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"With", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", "=", "\"\<12C\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SetOptions", "[", 
          RowBox[{"DataLine", ",", 
           RowBox[{"Color", "\[Rule]", 
            RowBox[{"Replace", "[", 
             RowBox[{"x", ",", "NucleusColors"}], "]"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"SetOptions", "[", 
          RowBox[{"DataSymbol", ",", 
           RowBox[{"Color", "\[Rule]", 
            RowBox[{"Replace", "[", 
             RowBox[{"x", ",", "NucleusColors"}], "]"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"DataPlot", "[", 
          RowBox[{
           RowBox[{"DimensionData", "[", 
            RowBox[{"x", ",", "\"\<j-0\>\""}], "]"}], ",", 
           RowBox[{"DataLine", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Dashing", "\[Rule]", "4"}], "}"}]}], ",", 
           RowBox[{"Tag", "\[Rule]", 
            RowBox[{"Curve", "[", 
             RowBox[{"x", ",", "\"\<j-0\>\""}], "]"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"DataLabel", "[", 
          RowBox[{
           RowBox[{"Curve", "[", 
            RowBox[{"x", ",", "\"\<j-0\>\""}], "]"}], ",", 
           RowBox[{"LabT", "\[Rule]", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Replace", "[", 
                RowBox[{"x", ",", "NucleusLabels"}], "]"}], ",", "\"\< \>\"", 
               ",", 
               RowBox[{"textit", "[", "\"\<J\>\"", "]"}], ",", "\"\<=0\>\""}],
               "}"}], "]"}]}], ",", 
           RowBox[{"PosnT", "\[Rule]", "0.75"}]}], "]"}], ","}], 
        "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ScaledFigurePanel", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.5", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.60"}], "}"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ExtendRange", "\[Rule]", "0.2"}], ",", 
       RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"HOPlot", "[", 
      RowBox[{"6", ",", 
       RowBox[{"HOLevelOpts", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Color", "\[Rule]", "Gray"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"HOPoint", ",", 
       RowBox[{"Scale", "\[Rule]", "0.4"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SetOptions", "[", 
      RowBox[{"HODot", ",", 
       RowBox[{"DotOptions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Color", "\[Rule]", "Firebrick"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"HODot", "[", 
         RowBox[{"0", ",", "k"}], "]"}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", 
         RowBox[{"ShellDimension", "[", "0", "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"HODot", "[", 
          RowBox[{"1", ",", "k", ",", 
           RowBox[{"Occupied", "\[Rule]", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "\[LessEqual]", "4"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"k", "\[NotEqual]", "2"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"k", "\[NotEqual]", "4"}], ")"}]}]}]}], "]"}], ","}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", 
         RowBox[{"ShellDimension", "[", "1", "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "excitations", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ExcitationArrowStyle", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ArrowType", "\[Rule]", "MultilineArrow"}], ",", 
        RowBox[{"Width", "\[Rule]", "2"}], ",", 
        RowBox[{"HeadLength", "\[Rule]", "3"}], ",", 
        RowBox[{"HeadLip", "\[Rule]", "2"}], ",", 
        RowBox[{"Color", "\[Rule]", "Firebrick"}], ",", 
        RowBox[{"FillColor", "\[Rule]", "White"}], ",", 
        RowBox[{"HeadRecess", "\[Rule]", "3"}], ",", 
        RowBox[{"TailRecess", "\[Rule]", "3"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"HODot", "[", 
      RowBox[{"3", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"ShellDimension", "[", "3", "]"}], "/", "2"}], "-", "2"}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"HOPoint", "[", 
          RowBox[{"1", ",", "2"}], "]"}], ",", 
         RowBox[{"HOPoint", "[", 
          RowBox[{"3", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"ShellDimension", "[", "3", "]"}], "/", "2"}], "-", 
            "2"}]}], "]"}]}], "}"}], ",", "ExcitationArrowStyle"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"HODot", "[", 
      RowBox[{"3", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"ShellDimension", "[", "3", "]"}], "/", "2"}], "+", "2"}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"HOPoint", "[", 
          RowBox[{"1", ",", "4"}], "]"}], ",", 
         RowBox[{"HOPoint", "[", 
          RowBox[{"3", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"ShellDimension", "[", "3", "]"}], "/", "2"}], "+", 
            "2"}]}], "]"}]}], "}"}], ",", "ExcitationArrowStyle"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"ManualLabel", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HOPoint", "[", 
           RowBox[{"3", ",", 
            RowBox[{
             RowBox[{"ShellDimension", "[", "3", "]"}], "/", "2"}]}], "]"}], 
          "+", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0.2"}], "}"}]}], ",", 
         "\"\<4\:f7d8\[CapitalOmega]\>\"", ",", 
         RowBox[{"Color", "\[Rule]", "Firebrick"}], ",", 
         RowBox[{"Background", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"FontSize", "\[Rule]", "13"}]}], "]"}], ","}], "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"ManualLabel", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"HOE", "[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"HOE", "[", "1", "]"}]}], "}"}], ",", 
        RowBox[{"StackText", "[", 
         RowBox[{"Center", ",", "0", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<Valence\>\"", ",", "\"\<shell\>\""}], "}"}]}], "]"}], 
        ",", 
        RowBox[{"CallOutVector", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"+", "5"}], ",", "0"}], "}"}]}]}], "]"}], "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"valence", " ", "shell", " ", "label"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"P0", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"HOE", "[", "1", "]"}], "]"}]}], ",", 
        RowBox[{"HOE", "[", "1", "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"SchemeArrow", "[", 
      RowBox[{
       RowBox[{"P0", "+", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ",", "P0", ",", 
       RowBox[{"LabT", "->", 
        RowBox[{"StackText", "[", 
         RowBox[{"Center", ",", "0", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<Valence\>\"", ",", "\"\<shell\>\""}], "}"}]}], 
         "]"}]}], ",", 
       RowBox[{"OrientationT", "\[Rule]", "Horizontal"}], ",", 
       RowBox[{"OffsetT", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", "0.75"}], ",", "0"}], "}"}]}], ",", 
       RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
       RowBox[{"HeadLength", "\[Rule]", "3"}], ",", 
       RowBox[{"HeadLip", "\[Rule]", "2"}], ",", 
       RowBox[{"HeadRecess", "\[Rule]", "3"}], ",", 
       RowBox[{"TailRecess", "\[Rule]", "3"}]}], "]"}], ","}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"72", "*", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.48814902090625*^9, 3.488149073609375*^9}, {
   3.488189064*^9, 3.488189114171875*^9}, {3.48818919740625*^9, 
   3.48818922984375*^9}, {3.488189266890625*^9, 3.48818934934375*^9}, {
   3.48818979096875*^9, 3.488189844140625*^9}, {3.48819087678125*^9, 
   3.488190908359375*^9}, {3.48819097371875*^9, 3.4881910305625*^9}, {
   3.488191068109375*^9, 3.488191168890625*^9}, {3.48819121590625*^9, 
   3.48819129065625*^9}, 3.4881914684375*^9, {3.48819164665625*^9, 
   3.488191660046875*^9}, {3.48819173496875*^9, 3.48819175965625*^9}, {
   3.488191790953125*^9, 3.488191866640625*^9}, {3.48819212578125*^9, 
   3.488192280734375*^9}, {3.488192379921875*^9, 3.4881923855*^9}, {
   3.48819501784375*^9, 3.488195018078125*^9}, {3.488195054234375*^9, 
   3.488195152125*^9}, {3.48819526375*^9, 3.48819528453125*^9}, {
   3.48819533628125*^9, 3.488195375*^9}, {3.488195995328125*^9, 
   3.48819599825*^9}, {3.488196295234375*^9, 3.48819633484375*^9}, {
   3.4881965946875*^9, 3.4881967965625*^9}, {3.488196827890625*^9, 
   3.488197033015625*^9}, {3.488197069484375*^9, 3.48819710021875*^9}, {
   3.488197142484375*^9, 3.488197178203125*^9}, {3.4881973541875*^9, 
   3.488197360296875*^9}, {3.4881975306875*^9, 3.488197535203125*^9}, 
   3.488197588703125*^9, {3.48819795125*^9, 3.488198095515625*^9}, {
   3.48819827515625*^9, 3.48819829115625*^9}, 3.48819832846875*^9, {
   3.488198454828125*^9, 3.488198513328125*^9}, {3.488198546375*^9, 
   3.488198565375*^9}, 3.488198603390625*^9, {3.488198783015625*^9, 
   3.488198917015625*^9}, {3.488198957046875*^9, 3.488198968875*^9}, {
   3.488199011890625*^9, 3.488199133203125*^9}, {3.488200277390625*^9, 
   3.488200369359375*^9}, {3.4882004796875*^9, 3.48820061753125*^9}, {
   3.488201204203125*^9, 3.48820141015625*^9}, 3.48837654153125*^9, {
   3.488376610453125*^9, 3.488376762796875*^9}, {3.488376808953125*^9, 
   3.48837700778125*^9}, {3.488838238640625*^9, 3.488838238859375*^9}, {
   3.5075124106875*^9, 3.50751241159375*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.11113333333333333`, 0.1389166666666667}, {
     0.8888666666666667, 0.1389166666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.11113333333333333`, 0.15016891666666668`}, {
     0.11113333333333333`, 0.1389166666666667}}], 
    LineBox[{{0.18890666666666667`, 0.15016891666666668`}, {
     0.18890666666666667`, 0.1389166666666667}}], 
    LineBox[{{0.26668000000000003`, 0.15016891666666668`}, {
     0.26668000000000003`, 0.1389166666666667}}], 
    LineBox[{{0.3444533333333334, 0.15016891666666668`}, {0.3444533333333334, 
     0.1389166666666667}}], 
    LineBox[{{0.42222666666666675`, 0.15016891666666668`}, {
     0.42222666666666675`, 0.1389166666666667}}], 
    LineBox[{{0.5000000000000001, 0.15016891666666668`}, {0.5000000000000001, 
     0.1389166666666667}}], 
    LineBox[{{0.5777733333333334, 0.15016891666666668`}, {0.5777733333333334, 
     0.1389166666666667}}], 
    LineBox[{{0.6555466666666667, 0.15016891666666668`}, {0.6555466666666667, 
     0.1389166666666667}}], 
    LineBox[{{0.7333200000000001, 0.15016891666666668`}, {0.7333200000000001, 
     0.1389166666666667}}], 
    LineBox[{{0.8110933333333334, 0.15016891666666668`}, {0.8110933333333334, 
     0.1389166666666667}}], 
    LineBox[{{0.8888666666666668, 0.15016891666666668`}, {0.8888666666666668, 
     0.1389166666666667}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.11113333333333333`, 0.1389166666666667}, {
     0.11113333333333333`, 0.8610833333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.12013513333333334`, 0.1389166666666667}, {
     0.11113333333333333`, 0.1389166666666667}}], 
    LineBox[{{0.11563423333333334`, 0.15703281904461155`}, {
     0.11113333333333333`, 0.15703281904461155`}}], 
    LineBox[{{0.11563423333333334`, 0.1676300888430597}, {
     0.11113333333333333`, 0.1676300888430597}}], 
    LineBox[{{0.11563423333333334`, 0.17514897142255642`}, {
     0.11113333333333333`, 0.17514897142255642`}}], 
    LineBox[{{0.11563423333333334`, 0.18098106984427736`}, {
     0.11113333333333333`, 0.18098106984427736`}}], 
    LineBox[{{0.11563423333333334`, 0.18574624122100455`}, {
     0.11113333333333333`, 0.18574624122100455`}}], 
    LineBox[{{0.11563423333333334`, 0.1897751362136358}, {
     0.11113333333333333`, 0.1897751362136358}}], 
    LineBox[{{0.11563423333333334`, 0.19326512380050126`}, {
     0.11113333333333333`, 0.19326512380050126`}}], 
    LineBox[{{0.11563423333333334`, 0.19634351101945272`}, {
     0.11113333333333333`, 0.19634351101945272`}}], 
    LineBox[{{0.12013513333333334`, 0.19909722222222223`}, {
     0.11113333333333333`, 0.19909722222222223`}}], 
    LineBox[{{0.11563423333333334`, 0.2172133746001671}, {
     0.11113333333333333`, 0.2172133746001671}}], 
    LineBox[{{0.11563423333333334`, 0.22781064439861526`}, {
     0.11113333333333333`, 0.22781064439861526`}}], 
    LineBox[{{0.11563423333333334`, 0.23532952697811196`}, {
     0.11113333333333333`, 0.23532952697811196`}}], 
    LineBox[{{0.11563423333333334`, 0.24116162539983294`}, {
     0.11113333333333333`, 0.24116162539983294`}}], 
    LineBox[{{0.11563423333333334`, 0.2459267967765601}, {
     0.11113333333333333`, 0.2459267967765601}}], 
    LineBox[{{0.11563423333333334`, 0.2499556917691913}, {
     0.11113333333333333`, 0.2499556917691913}}], 
    LineBox[{{0.11563423333333334`, 0.25344567935605683`}, {
     0.11113333333333333`, 0.25344567935605683`}}], 
    LineBox[{{0.11563423333333334`, 0.25652406657500826`}, {
     0.11113333333333333`, 0.25652406657500826`}}], 
    LineBox[{{0.12013513333333334`, 0.2592777777777778}, {
     0.11113333333333333`, 0.2592777777777778}}], 
    LineBox[{{0.11563423333333334`, 0.27739393015572267`}, {
     0.11113333333333333`, 0.27739393015572267`}}], 
    LineBox[{{0.11563423333333334`, 0.2879911999541708}, {
     0.11113333333333333`, 0.2879911999541708}}], 
    LineBox[{{0.11563423333333334`, 0.2955100825336675}, {
     0.11113333333333333`, 0.2955100825336675}}], 
    LineBox[{{0.11563423333333334`, 0.30134218095538845`}, {
     0.11113333333333333`, 0.30134218095538845`}}], 
    LineBox[{{0.11563423333333334`, 0.30610735233211567`}, {
     0.11113333333333333`, 0.30610735233211567`}}], 
    LineBox[{{0.11563423333333334`, 0.31013624732474687`}, {
     0.11113333333333333`, 0.31013624732474687`}}], 
    LineBox[{{0.11563423333333334`, 0.31362623491161234`}, {
     0.11113333333333333`, 0.31362623491161234`}}], 
    LineBox[{{0.11563423333333334`, 0.31670462213056383`}, {
     0.11113333333333333`, 0.31670462213056383`}}], 
    LineBox[{{0.12013513333333334`, 0.31945833333333334`}, {
     0.11113333333333333`, 0.31945833333333334`}}], 
    LineBox[{{0.11563423333333334`, 0.33757448571127824`}, {
     0.11113333333333333`, 0.33757448571127824`}}], 
    LineBox[{{0.11563423333333334`, 0.34817175550972634`}, {
     0.11113333333333333`, 0.34817175550972634`}}], 
    LineBox[{{0.11563423333333334`, 0.3556906380892231}, {
     0.11113333333333333`, 0.3556906380892231}}], 
    LineBox[{{0.11563423333333334`, 0.361522736510944}, {0.11113333333333333`,
      0.361522736510944}}], 
    LineBox[{{0.11563423333333334`, 0.3662879078876712}, {
     0.11113333333333333`, 0.3662879078876712}}], 
    LineBox[{{0.11563423333333334`, 0.37031680288030244`}, {
     0.11113333333333333`, 0.37031680288030244`}}], 
    LineBox[{{0.11563423333333334`, 0.3738067904671679}, {
     0.11113333333333333`, 0.3738067904671679}}], 
    LineBox[{{0.11563423333333334`, 0.3768851776861194}, {
     0.11113333333333333`, 0.3768851776861194}}], 
    LineBox[{{0.12013513333333334`, 0.37963888888888886`}, {
     0.11113333333333333`, 0.37963888888888886`}}], 
    LineBox[{{0.11563423333333334`, 0.39775504126683375`}, {
     0.11113333333333333`, 0.39775504126683375`}}], 
    LineBox[{{0.11563423333333334`, 0.4083523110652819}, {
     0.11113333333333333`, 0.4083523110652819}}], 
    LineBox[{{0.11563423333333334`, 0.41587119364477865`}, {
     0.11113333333333333`, 0.41587119364477865`}}], 
    LineBox[{{0.11563423333333334`, 0.4217032920664996}, {
     0.11113333333333333`, 0.4217032920664996}}], 
    LineBox[{{0.11563423333333334`, 0.4264684634432268}, {
     0.11113333333333333`, 0.4264684634432268}}], 
    LineBox[{{0.11563423333333334`, 0.43049735843585796`}, {
     0.11113333333333333`, 0.43049735843585796`}}], 
    LineBox[{{0.11563423333333334`, 0.4339873460227235}, {
     0.11113333333333333`, 0.4339873460227235}}], 
    LineBox[{{0.11563423333333334`, 0.4370657332416749}, {
     0.11113333333333333`, 0.4370657332416749}}], 
    LineBox[{{0.12013513333333334`, 0.43981944444444443`}, {
     0.11113333333333333`, 0.43981944444444443`}}], 
    LineBox[{{0.11563423333333334`, 0.4579355968223893}, {
     0.11113333333333333`, 0.4579355968223893}}], 
    LineBox[{{0.11563423333333334`, 0.4685328666208375}, {
     0.11113333333333333`, 0.4685328666208375}}], 
    LineBox[{{0.11563423333333334`, 0.47605174920033416`}, {
     0.11113333333333333`, 0.47605174920033416`}}], 
    LineBox[{{0.11563423333333334`, 0.4818838476220551}, {
     0.11113333333333333`, 0.4818838476220551}}], 
    LineBox[{{0.11563423333333334`, 0.4866490189987823}, {
     0.11113333333333333`, 0.4866490189987823}}], 
    LineBox[{{0.11563423333333334`, 0.49067791399141353`}, {
     0.11113333333333333`, 0.49067791399141353`}}], 
    LineBox[{{0.11563423333333334`, 0.49416790157827906`}, {
     0.11113333333333333`, 0.49416790157827906`}}], 
    LineBox[{{0.11563423333333334`, 0.4972462887972305}, {
     0.11113333333333333`, 0.4972462887972305}}], 
    LineBox[{{0.12013513333333334`, 0.5}, {0.11113333333333333`, 0.5}}], 
    LineBox[{{0.11563423333333334`, 0.5181161523779448}, {
     0.11113333333333333`, 0.5181161523779448}}], 
    LineBox[{{0.11563423333333334`, 0.5287134221763929}, {
     0.11113333333333333`, 0.5287134221763929}}], 
    LineBox[{{0.11563423333333334`, 0.5362323047558897}, {
     0.11113333333333333`, 0.5362323047558897}}], 
    LineBox[{{0.11563423333333334`, 0.5420644031776107}, {
     0.11113333333333333`, 0.5420644031776107}}], 
    LineBox[{{0.11563423333333334`, 0.5468295745543379}, {
     0.11113333333333333`, 0.5468295745543379}}], 
    LineBox[{{0.11563423333333334`, 0.5508584695469692}, {
     0.11113333333333333`, 0.5508584695469692}}], 
    LineBox[{{0.11563423333333334`, 0.5543484571338346}, {
     0.11113333333333333`, 0.5543484571338346}}], 
    LineBox[{{0.11563423333333334`, 0.5574268443527861}, {
     0.11113333333333333`, 0.5574268443527861}}], 
    LineBox[{{0.12013513333333334`, 0.5601805555555555}, {
     0.11113333333333333`, 0.5601805555555555}}], 
    LineBox[{{0.11563423333333334`, 0.5782967079335004}, {
     0.11113333333333333`, 0.5782967079335004}}], 
    LineBox[{{0.11563423333333334`, 0.5888939777319486}, {
     0.11113333333333333`, 0.5888939777319486}}], 
    LineBox[{{0.11563423333333334`, 0.5964128603114454}, {
     0.11113333333333333`, 0.5964128603114454}}], 
    LineBox[{{0.11563423333333334`, 0.6022449587331662}, {
     0.11113333333333333`, 0.6022449587331662}}], 
    LineBox[{{0.11563423333333334`, 0.6070101301098934}, {
     0.11113333333333333`, 0.6070101301098934}}], 
    LineBox[{{0.11563423333333334`, 0.6110390251025246}, {
     0.11113333333333333`, 0.6110390251025246}}], 
    LineBox[{{0.11563423333333334`, 0.6145290126893901}, {
     0.11113333333333333`, 0.6145290126893901}}], 
    LineBox[{{0.11563423333333334`, 0.6176073999083416}, {
     0.11113333333333333`, 0.6176073999083416}}], 
    LineBox[{{0.12013513333333334`, 0.6203611111111111}, {
     0.11113333333333333`, 0.6203611111111111}}], 
    LineBox[{{0.11563423333333334`, 0.638477263489056}, {0.11113333333333333`,
      0.638477263489056}}], 
    LineBox[{{0.11563423333333334`, 0.6490745332875041}, {
     0.11113333333333333`, 0.6490745332875041}}], 
    LineBox[{{0.11563423333333334`, 0.6565934158670008}, {
     0.11113333333333333`, 0.6565934158670008}}], 
    LineBox[{{0.11563423333333334`, 0.6624255142887218}, {
     0.11113333333333333`, 0.6624255142887218}}], 
    LineBox[{{0.11563423333333334`, 0.667190685665449}, {0.11113333333333333`,
      0.667190685665449}}], 
    LineBox[{{0.11563423333333334`, 0.6712195806580802}, {
     0.11113333333333333`, 0.6712195806580802}}], 
    LineBox[{{0.11563423333333334`, 0.6747095682449457}, {
     0.11113333333333333`, 0.6747095682449457}}], 
    LineBox[{{0.11563423333333334`, 0.6777879554638971}, {
     0.11113333333333333`, 0.6777879554638971}}], 
    LineBox[{{0.12013513333333334`, 0.6805416666666666}, {
     0.11113333333333333`, 0.6805416666666666}}], 
    LineBox[{{0.11563423333333334`, 0.6986578190446115}, {
     0.11113333333333333`, 0.6986578190446115}}], 
    LineBox[{{0.11563423333333334`, 0.7092550888430597}, {
     0.11113333333333333`, 0.7092550888430597}}], 
    LineBox[{{0.11563423333333334`, 0.7167739714225564}, {
     0.11113333333333333`, 0.7167739714225564}}], 
    LineBox[{{0.11563423333333334`, 0.7226060698442773}, {
     0.11113333333333333`, 0.7226060698442773}}], 
    LineBox[{{0.11563423333333334`, 0.7273712412210045}, {
     0.11113333333333333`, 0.7273712412210045}}], 
    LineBox[{{0.11563423333333334`, 0.7314001362136358}, {
     0.11113333333333333`, 0.7314001362136358}}], 
    LineBox[{{0.11563423333333334`, 0.7348901238005012}, {
     0.11113333333333333`, 0.7348901238005012}}], 
    LineBox[{{0.11563423333333334`, 0.7379685110194527}, {
     0.11113333333333333`, 0.7379685110194527}}], 
    LineBox[{{0.12013513333333334`, 0.7407222222222222}, {
     0.11113333333333333`, 0.7407222222222222}}], 
    LineBox[{{0.11563423333333334`, 0.758838374600167}, {0.11113333333333333`,
      0.758838374600167}}], 
    LineBox[{{0.11563423333333334`, 0.7694356443986152}, {
     0.11113333333333333`, 0.7694356443986152}}], 
    LineBox[{{0.11563423333333334`, 0.776954526978112}, {0.11113333333333333`,
      0.776954526978112}}], 
    LineBox[{{0.11563423333333334`, 0.7827866253998329}, {
     0.11113333333333333`, 0.7827866253998329}}], 
    LineBox[{{0.11563423333333334`, 0.7875517967765601}, {
     0.11113333333333333`, 0.7875517967765601}}], 
    LineBox[{{0.11563423333333334`, 0.7915806917691913}, {
     0.11113333333333333`, 0.7915806917691913}}], 
    LineBox[{{0.11563423333333334`, 0.7950706793560568}, {
     0.11113333333333333`, 0.7950706793560568}}], 
    LineBox[{{0.11563423333333334`, 0.7981490665750083}, {
     0.11113333333333333`, 0.7981490665750083}}], 
    LineBox[{{0.12013513333333334`, 0.8009027777777777}, {
     0.11113333333333333`, 0.8009027777777777}}], 
    LineBox[{{0.11563423333333334`, 0.8190189301557226}, {
     0.11113333333333333`, 0.8190189301557226}}], 
    LineBox[{{0.11563423333333334`, 0.8296161999541708}, {
     0.11113333333333333`, 0.8296161999541708}}], 
    LineBox[{{0.11563423333333334`, 0.8371350825336675}, {
     0.11113333333333333`, 0.8371350825336675}}], 
    LineBox[{{0.11563423333333334`, 0.8429671809553884}, {
     0.11113333333333333`, 0.8429671809553884}}], 
    LineBox[{{0.11563423333333334`, 0.8477323523321156}, {
     0.11113333333333333`, 0.8477323523321156}}], 
    LineBox[{{0.11563423333333334`, 0.8517612473247468}, {
     0.11113333333333333`, 0.8517612473247468}}], 
    LineBox[{{0.11563423333333334`, 0.8552512349116124}, {
     0.11113333333333333`, 0.8552512349116124}}], 
    LineBox[{{0.11563423333333334`, 0.8583296221305637}, {
     0.11113333333333333`, 0.8583296221305637}}], 
    LineBox[{{0.12013513333333334`, 0.8610833333333333}, {
     0.11113333333333333`, 0.8610833333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.11113333333333333`, 0.8610833333333333}, {
     0.8888666666666667, 0.8610833333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.8888666666666667, 0.1389166666666667}, {
     0.8888666666666667, 0.8610833333333333}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], LineBox[{{0.11113333333333333`, 0.24167918851433828`}, {
     0.18890666666666667`, 0.36205566927199384`}, {0.26668000000000003`, 
     0.4493120077860231}, {0.3444533333333334, 0.5208172588543303}, {
     0.42222666666666675`, 0.5823405977486591}, {0.5000000000000001, 
     0.636763263846214}, {0.5777733333333334, 0.6857887180536776}, {
     0.6555466666666667, 0.7305285041220194}, {0.7333200000000001, 
     0.7717578201798164}, {0.8110933333333334, 0.8100439752291739}, {
     0.8888666666666668, 0.8458175999239809}}]}, 
   {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
    None], {}, 
    {GrayLevel[1], Opacity[1], 
     PolygonBox[{{0.11113333333333333`, 0.24602033434767162`}, {
      0.11113333333333333`, 0.23733804268100495`}, {0.11113333333333333`, 
      0.23733804268100495`}, {0.11246236100365126`, 0.23766849273127497`}, {
      0.11358905625882912`, 0.23860953485746855`}, {0.11434188995978399`, 
      0.24001790392644087`}, {0.11460625, 0.24167918851433828`}, {
      0.11434188995978399`, 0.2433404731022357}, {0.11358905625882912`, 
      0.24474884217120801`}, {0.11246236100365126`, 0.2456898842974016}, {
      0.11113333333333333`, 0.24602033434767162`}}], 
     PolygonBox[{{0.1921152232931173, 0.3637169538598912}, {
      0.19136238959216245`, 0.36512532292886357`}, {0.1902356943369846, 
      0.3660663650550572}, {0.18890666666666667`, 0.3663968151053272}, {
      0.18757763899634874`, 0.3660663650550572}, {0.18645094374117088`, 
      0.36512532292886357`}, {0.18569811004021602`, 0.3637169538598912}, {
      0.18543375, 0.36205566927199384`}, {0.18569811004021602`, 
      0.36039438468409646`}, {0.18645094374117088`, 0.3589860156151241}, {
      0.18757763899634874`, 0.3580449734889305}, {0.18890666666666667`, 
      0.3577145234386605}, {0.1902356943369846, 0.3580449734889305}, {
      0.19136238959216245`, 0.3589860156151241}, {0.1921152232931173, 
      0.36039438468409646`}, {0.19237958333333333`, 0.36205566927199384`}}], 
     PolygonBox[{{0.26988855662645067`, 0.4509732923739205}, {
      0.2691357229254958, 0.4523816614428928}, {0.268009027670318, 
      0.45332270356908644`}, {0.26668000000000003`, 0.45365315361935643`}, {
      0.2653509723296821, 0.45332270356908644`}, {0.26422427707450424`, 
      0.4523816614428928}, {0.2634714433735494, 0.4509732923739205}, {
      0.26320708333333337`, 0.4493120077860231}, {0.2634714433735494, 
      0.4476507231981257}, {0.26422427707450424`, 0.44624235412915336`}, {
      0.2653509723296821, 0.44530131200295975`}, {0.26668000000000003`, 
      0.44497086195268976`}, {0.268009027670318, 0.44530131200295975`}, {
      0.2691357229254958, 0.44624235412915336`}, {0.26988855662645067`, 
      0.4476507231981257}, {0.2701529166666667, 0.4493120077860231}}], 
     PolygonBox[{{0.34766188995978403`, 0.5224785434422277}, {
      0.3469090562588292, 0.5238869125112}, {0.34578236100365134`, 
      0.5248279546373936}, {0.3444533333333334, 0.5251584046876636}, {
      0.34312430566301544`, 0.5248279546373936}, {0.3419976104078376, 
      0.5238869125112}, {0.34124477670688275`, 0.5224785434422277}, {
      0.34098041666666673`, 0.5208172588543303}, {0.34124477670688275`, 
      0.5191559742664329}, {0.3419976104078376, 0.5177476051974605}, {
      0.34312430566301544`, 0.5168065630712669}, {0.3444533333333334, 
      0.5164761130209969}, {0.34578236100365134`, 0.5168065630712669}, {
      0.3469090562588292, 0.5177476051974605}, {0.34766188995978403`, 
      0.5191559742664329}, {0.34792625000000005`, 0.5208172588543303}}], 
     PolygonBox[{{0.4254352232931174, 0.5840018823365565}, {
      0.42468238959216253`, 0.5854102514055288}, {0.4235556943369847, 
      0.5863512935317224}, {0.42222666666666675`, 0.5866817435819924}, {
      0.4208976389963488, 0.5863512935317224}, {0.41977094374117097`, 
      0.5854102514055288}, {0.4190181100402161, 0.5840018823365565}, {
      0.4187537500000001, 0.5823405977486591}, {0.4190181100402161, 
      0.5806793131607617}, {0.41977094374117097`, 0.5792709440917894}, {
      0.4208976389963488, 0.5783299019655957}, {0.42222666666666675`, 
      0.5779994519153258}, {0.4235556943369847, 0.5783299019655957}, {
      0.42468238959216253`, 0.5792709440917894}, {0.4254352232931174, 
      0.5806793131607617}, {0.4256995833333334, 0.5823405977486591}}], 
     PolygonBox[{{0.5032085566264508, 0.6384245484341113}, {
      0.5024557229254959, 0.6398329175030837}, {0.5013290276703181, 
      0.6407739596292773}, {0.5000000000000001, 0.6411044096795473}, {
      0.49867097232968216`, 0.6407739596292773}, {0.4975442770745043, 
      0.6398329175030837}, {0.49679144337354947`, 0.6384245484341113}, {
      0.49652708333333345`, 0.636763263846214}, {0.49679144337354947`, 
      0.6351019792583166}, {0.4975442770745043, 0.6336936101893442}, {
      0.49867097232968216`, 0.6327525680631506}, {0.5000000000000001, 
      0.6324221180128806}, {0.5013290276703181, 0.6327525680631506}, {
      0.5024557229254959, 0.6336936101893442}, {0.5032085566264508, 
      0.6351019792583166}, {0.5034729166666668, 0.636763263846214}}], 
     PolygonBox[{{0.5809818899597841, 0.687450002641575}, {0.5802290562588291,
       0.6888583717105473}, {0.5791023610036513, 0.6897994138367409}, {
      0.5777733333333334, 0.6901298638870109}, {0.5764443056630154, 
      0.6897994138367409}, {0.5753176104078376, 0.6888583717105473}, {
      0.5745647767068827, 0.687450002641575}, {0.5743004166666666, 
      0.6857887180536776}, {0.5745647767068827, 0.6841274334657802}, {
      0.5753176104078376, 0.6827190643968079}, {0.5764443056630154, 
      0.6817780222706142}, {0.5777733333333334, 0.6814475722203442}, {
      0.5791023610036513, 0.6817780222706142}, {0.5802290562588291, 
      0.6827190643968079}, {0.5809818899597841, 0.6841274334657802}, {
      0.5812462500000001, 0.6857887180536776}}], 
     PolygonBox[{{0.6587552232931174, 0.7321897887099168}, {
      0.6580023895921625, 0.7335981577788891}, {0.6568756943369847, 
      0.7345391999050828}, {0.6555466666666667, 0.7348696499553528}, {
      0.6542176389963488, 0.7345391999050828}, {0.6530909437411709, 
      0.7335981577788891}, {0.652338110040216, 0.7321897887099168}, {
      0.65207375, 0.7305285041220194}, {0.652338110040216, 
      0.728867219534122}, {0.6530909437411709, 0.7274588504651497}, {
      0.6542176389963488, 0.7265178083389561}, {0.6555466666666667, 
      0.7261873582886861}, {0.6568756943369847, 0.7265178083389561}, {
      0.6580023895921625, 0.7274588504651497}, {0.6587552232931174, 
      0.728867219534122}, {0.6590195833333334, 0.7305285041220194}}], 
     PolygonBox[{{0.7365285566264508, 0.7734191047677138}, {
      0.7357757229254959, 0.7748274738366862}, {0.734649027670318, 
      0.7757685159628798}, {0.7333200000000001, 0.7760989660131498}, {
      0.7319909723296821, 0.7757685159628798}, {0.7308642770745043, 
      0.7748274738366862}, {0.7301114433735494, 0.7734191047677138}, {
      0.7298470833333334, 0.7717578201798164}, {0.7301114433735494, 
      0.770096535591919}, {0.7308642770745043, 0.7686881665229467}, {
      0.7319909723296821, 0.7677471243967531}, {0.7333200000000001, 
      0.7674166743464831}, {0.734649027670318, 0.7677471243967531}, {
      0.7357757229254959, 0.7686881665229467}, {0.7365285566264508, 
      0.770096535591919}, {0.7367929166666668, 0.7717578201798164}}], 
     PolygonBox[{{0.8143018899597841, 0.8117052598170713}, {
      0.8135490562588292, 0.8131136288860437}, {0.8124223610036514, 
      0.8140546710122373}, {0.8110933333333334, 0.8143851210625073}, {
      0.8097643056630155, 0.8140546710122373}, {0.8086376104078377, 
      0.8131136288860437}, {0.8078847767068827, 0.8117052598170713}, {
      0.8076204166666667, 0.8100439752291739}, {0.8078847767068827, 
      0.8083826906412765}, {0.8086376104078377, 0.8069743215723042}, {
      0.8097643056630155, 0.8060332794461106}, {0.8110933333333334, 
      0.8057028293958406}, {0.8124223610036514, 0.8060332794461106}, {
      0.8135490562588292, 0.8069743215723042}, {0.8143018899597841, 
      0.8083826906412765}, {0.8145662500000002, 0.8100439752291739}}], 
     PolygonBox[{{0.8875376389963489, 0.8498282957070442}, {0.886410943741171,
       0.8488872535808506}, {0.8856581100402161, 0.8474788845118782}, {
      0.8853937500000001, 0.8458175999239809}, {0.8856581100402161, 
      0.8441563153360835}, {0.886410943741171, 0.8427479462671111}, {
      0.8875376389963489, 0.8418069041409175}, {0.8888666666666668, 
      0.8414764540906475}, {0.8888666666666667, 0.8414764540906475}, {
      0.8888666666666667, 0.8501587457573142}, {0.8888666666666668, 
      0.8501587457573142}}]}, 
    {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
     None], {LineBox[{{0.11434188995978399`, 0.2433404731022357}, {
       0.11358905625882912`, 0.24474884217120801`}, {0.11246236100365126`, 
       0.2456898842974016}, {0.11113333333333333`, 0.24602033434767162`}, {
       0.11113333333333333`, 0.24602033434767162`}}], 
      LineBox[{{0.11113333333333333`, 0.23733804268100495`}, {
       0.11113333333333333`, 0.23733804268100495`}, {0.11246236100365126`, 
       0.23766849273127497`}, {0.11358905625882912`, 0.23860953485746855`}, {
       0.11434188995978399`, 0.24001790392644087`}, {0.11460625, 
       0.24167918851433828`}, {0.11434188995978399`, 0.2433404731022357}}]}, 
     LineBox[{{0.1921152232931173, 0.3637169538598912}, {0.19136238959216245`,
       0.36512532292886357`}, {0.1902356943369846, 0.3660663650550572}, {
      0.18890666666666667`, 0.3663968151053272}, {0.18757763899634874`, 
      0.3660663650550572}, {0.18645094374117088`, 0.36512532292886357`}, {
      0.18569811004021602`, 0.3637169538598912}, {0.18543375, 
      0.36205566927199384`}, {0.18569811004021602`, 0.36039438468409646`}, {
      0.18645094374117088`, 0.3589860156151241}, {0.18757763899634874`, 
      0.3580449734889305}, {0.18890666666666667`, 0.3577145234386605}, {
      0.1902356943369846, 0.3580449734889305}, {0.19136238959216245`, 
      0.3589860156151241}, {0.1921152232931173, 0.36039438468409646`}, {
      0.19237958333333333`, 0.36205566927199384`}, {0.1921152232931173, 
      0.3637169538598912}}], 
     LineBox[{{0.26988855662645067`, 0.4509732923739205}, {0.2691357229254958,
       0.4523816614428928}, {0.268009027670318, 0.45332270356908644`}, {
      0.26668000000000003`, 0.45365315361935643`}, {0.2653509723296821, 
      0.45332270356908644`}, {0.26422427707450424`, 0.4523816614428928}, {
      0.2634714433735494, 0.4509732923739205}, {0.26320708333333337`, 
      0.4493120077860231}, {0.2634714433735494, 0.4476507231981257}, {
      0.26422427707450424`, 0.44624235412915336`}, {0.2653509723296821, 
      0.44530131200295975`}, {0.26668000000000003`, 0.44497086195268976`}, {
      0.268009027670318, 0.44530131200295975`}, {0.2691357229254958, 
      0.44624235412915336`}, {0.26988855662645067`, 0.4476507231981257}, {
      0.2701529166666667, 0.4493120077860231}, {0.26988855662645067`, 
      0.4509732923739205}}], 
     LineBox[{{0.34766188995978403`, 0.5224785434422277}, {0.3469090562588292,
       0.5238869125112}, {0.34578236100365134`, 0.5248279546373936}, {
      0.3444533333333334, 0.5251584046876636}, {0.34312430566301544`, 
      0.5248279546373936}, {0.3419976104078376, 0.5238869125112}, {
      0.34124477670688275`, 0.5224785434422277}, {0.34098041666666673`, 
      0.5208172588543303}, {0.34124477670688275`, 0.5191559742664329}, {
      0.3419976104078376, 0.5177476051974605}, {0.34312430566301544`, 
      0.5168065630712669}, {0.3444533333333334, 0.5164761130209969}, {
      0.34578236100365134`, 0.5168065630712669}, {0.3469090562588292, 
      0.5177476051974605}, {0.34766188995978403`, 0.5191559742664329}, {
      0.34792625000000005`, 0.5208172588543303}, {0.34766188995978403`, 
      0.5224785434422277}}], 
     LineBox[{{0.4254352232931174, 0.5840018823365565}, {0.42468238959216253`,
       0.5854102514055288}, {0.4235556943369847, 0.5863512935317224}, {
      0.42222666666666675`, 0.5866817435819924}, {0.4208976389963488, 
      0.5863512935317224}, {0.41977094374117097`, 0.5854102514055288}, {
      0.4190181100402161, 0.5840018823365565}, {0.4187537500000001, 
      0.5823405977486591}, {0.4190181100402161, 0.5806793131607617}, {
      0.41977094374117097`, 0.5792709440917894}, {0.4208976389963488, 
      0.5783299019655957}, {0.42222666666666675`, 0.5779994519153258}, {
      0.4235556943369847, 0.5783299019655957}, {0.42468238959216253`, 
      0.5792709440917894}, {0.4254352232931174, 0.5806793131607617}, {
      0.4256995833333334, 0.5823405977486591}, {0.4254352232931174, 
      0.5840018823365565}}], 
     LineBox[{{0.5032085566264508, 0.6384245484341113}, {0.5024557229254959, 
      0.6398329175030837}, {0.5013290276703181, 0.6407739596292773}, {
      0.5000000000000001, 0.6411044096795473}, {0.49867097232968216`, 
      0.6407739596292773}, {0.4975442770745043, 0.6398329175030837}, {
      0.49679144337354947`, 0.6384245484341113}, {0.49652708333333345`, 
      0.636763263846214}, {0.49679144337354947`, 0.6351019792583166}, {
      0.4975442770745043, 0.6336936101893442}, {0.49867097232968216`, 
      0.6327525680631506}, {0.5000000000000001, 0.6324221180128806}, {
      0.5013290276703181, 0.6327525680631506}, {0.5024557229254959, 
      0.6336936101893442}, {0.5032085566264508, 0.6351019792583166}, {
      0.5034729166666668, 0.636763263846214}, {0.5032085566264508, 
      0.6384245484341113}}], 
     LineBox[{{0.5809818899597841, 0.687450002641575}, {0.5802290562588291, 
      0.6888583717105473}, {0.5791023610036513, 0.6897994138367409}, {
      0.5777733333333334, 0.6901298638870109}, {0.5764443056630154, 
      0.6897994138367409}, {0.5753176104078376, 0.6888583717105473}, {
      0.5745647767068827, 0.687450002641575}, {0.5743004166666666, 
      0.6857887180536776}, {0.5745647767068827, 0.6841274334657802}, {
      0.5753176104078376, 0.6827190643968079}, {0.5764443056630154, 
      0.6817780222706142}, {0.5777733333333334, 0.6814475722203442}, {
      0.5791023610036513, 0.6817780222706142}, {0.5802290562588291, 
      0.6827190643968079}, {0.5809818899597841, 0.6841274334657802}, {
      0.5812462500000001, 0.6857887180536776}, {0.5809818899597841, 
      0.687450002641575}}], 
     LineBox[{{0.6587552232931174, 0.7321897887099168}, {0.6580023895921625, 
      0.7335981577788891}, {0.6568756943369847, 0.7345391999050828}, {
      0.6555466666666667, 0.7348696499553528}, {0.6542176389963488, 
      0.7345391999050828}, {0.6530909437411709, 0.7335981577788891}, {
      0.652338110040216, 0.7321897887099168}, {0.65207375, 
      0.7305285041220194}, {0.652338110040216, 0.728867219534122}, {
      0.6530909437411709, 0.7274588504651497}, {0.6542176389963488, 
      0.7265178083389561}, {0.6555466666666667, 0.7261873582886861}, {
      0.6568756943369847, 0.7265178083389561}, {0.6580023895921625, 
      0.7274588504651497}, {0.6587552232931174, 0.728867219534122}, {
      0.6590195833333334, 0.7305285041220194}, {0.6587552232931174, 
      0.7321897887099168}}], 
     LineBox[{{0.7365285566264508, 0.7734191047677138}, {0.7357757229254959, 
      0.7748274738366862}, {0.734649027670318, 0.7757685159628798}, {
      0.7333200000000001, 0.7760989660131498}, {0.7319909723296821, 
      0.7757685159628798}, {0.7308642770745043, 0.7748274738366862}, {
      0.7301114433735494, 0.7734191047677138}, {0.7298470833333334, 
      0.7717578201798164}, {0.7301114433735494, 0.770096535591919}, {
      0.7308642770745043, 0.7686881665229467}, {0.7319909723296821, 
      0.7677471243967531}, {0.7333200000000001, 0.7674166743464831}, {
      0.734649027670318, 0.7677471243967531}, {0.7357757229254959, 
      0.7686881665229467}, {0.7365285566264508, 0.770096535591919}, {
      0.7367929166666668, 0.7717578201798164}, {0.7365285566264508, 
      0.7734191047677138}}], 
     LineBox[{{0.8143018899597841, 0.8117052598170713}, {0.8135490562588292, 
      0.8131136288860437}, {0.8124223610036514, 0.8140546710122373}, {
      0.8110933333333334, 0.8143851210625073}, {0.8097643056630155, 
      0.8140546710122373}, {0.8086376104078377, 0.8131136288860437}, {
      0.8078847767068827, 0.8117052598170713}, {0.8076204166666667, 
      0.8100439752291739}, {0.8078847767068827, 0.8083826906412765}, {
      0.8086376104078377, 0.8069743215723042}, {0.8097643056630155, 
      0.8060332794461106}, {0.8110933333333334, 0.8057028293958406}, {
      0.8124223610036514, 0.8060332794461106}, {0.8135490562588292, 
      0.8069743215723042}, {0.8143018899597841, 0.8083826906412765}, {
      0.8145662500000002, 0.8100439752291739}, {0.8143018899597841, 
      0.8117052598170713}}], 
     LineBox[{{0.8888666666666667, 0.8501587457573142}, {0.8888666666666668, 
      0.8501587457573142}, {0.8875376389963489, 0.8498282957070442}, {
      0.886410943741171, 0.8488872535808506}, {0.8856581100402161, 
      0.8474788845118782}, {0.8853937500000001, 0.8458175999239809}, {
      0.8856581100402161, 0.8441563153360835}, {0.886410943741171, 
      0.8427479462671111}, {0.8875376389963489, 0.8418069041409175}, {
      0.8888666666666668, 0.8414764540906475}, {0.8888666666666667, 
      0.8414764540906475}}]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], Opacity[1],
      Dashing[{}], CapForm[None], 
     LineBox[{{0.11113333333333333`, 0.24167918851433828`}, {
      0.18890666666666667`, 0.39459894714755783`}, {0.26668000000000003`, 
      0.5029368932863889}, {0.3444533333333334, 0.5910654099762193}, {
      0.42222666666666675`, 0.6669498568790517}, {0.5000000000000001, 
      0.7343299336375967}, {0.5777733333333334, 0.795328099757183}, {
      0.6555466666666667, 0.8512936085337072}, {0.6702288142284473, 
      0.8610833333333333}}]}, 
    {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], Opacity[1],
      Dashing[{}], CapForm[None], {}, 
     {GrayLevel[1], Opacity[1], 
      PolygonBox[{{0.11113333333333333`, 0.24602033434767162`}, {
       0.11113333333333333`, 0.23733804268100495`}, {0.11113333333333333`, 
       0.23733804268100495`}, {0.11246236100365126`, 0.23766849273127497`}, {
       0.11358905625882912`, 0.23860953485746855`}, {0.11434188995978399`, 
       0.24001790392644087`}, {0.11460625, 0.24167918851433828`}, {
       0.11434188995978399`, 0.2433404731022357}, {0.11358905625882912`, 
       0.24474884217120801`}, {0.11246236100365126`, 0.2456898842974016}, {
       0.11113333333333333`, 0.24602033434767162`}}], 
      PolygonBox[{{0.1921152232931173, 0.3962602317354552}, {
       0.19136238959216245`, 0.39766860080442756`}, {0.1902356943369846, 
       0.3986096429306212}, {0.18890666666666667`, 0.39894009298089117`}, {
       0.18757763899634874`, 0.3986096429306212}, {0.18645094374117088`, 
       0.39766860080442756`}, {0.18569811004021602`, 0.3962602317354552}, {
       0.18543375, 0.39459894714755783`}, {0.18569811004021602`, 
       0.39293766255966045`}, {0.18645094374117088`, 0.3915292934906881}, {
       0.18757763899634874`, 0.3905882513644945}, {0.18890666666666667`, 
       0.3902578013142245}, {0.1902356943369846, 0.3905882513644945}, {
       0.19136238959216245`, 0.3915292934906881}, {0.1921152232931173, 
       0.39293766255966045`}, {0.19237958333333333`, 0.39459894714755783`}}], 
      PolygonBox[{{0.26988855662645067`, 0.5045981778742863}, {
       0.2691357229254958, 0.5060065469432586}, {0.268009027670318, 
       0.5069475890694523}, {0.26668000000000003`, 0.5072780391197222}, {
       0.2653509723296821, 0.5069475890694523}, {0.26422427707450424`, 
       0.5060065469432586}, {0.2634714433735494, 0.5045981778742863}, {
       0.26320708333333337`, 0.5029368932863889}, {0.2634714433735494, 
       0.5012756086984915}, {0.26422427707450424`, 0.4998672396295192}, {
       0.2653509723296821, 0.49892619750332556`}, {0.26668000000000003`, 
       0.49859574745305557`}, {0.268009027670318, 0.49892619750332556`}, {
       0.2691357229254958, 0.4998672396295192}, {0.26988855662645067`, 
       0.5012756086984915}, {0.2701529166666667, 0.5029368932863889}}], 
      PolygonBox[{{0.34766188995978403`, 0.5927266945641166}, {
       0.3469090562588292, 0.594135063633089}, {0.34578236100365134`, 
       0.5950761057592826}, {0.3444533333333334, 0.5954065558095526}, {
       0.34312430566301544`, 0.5950761057592826}, {0.3419976104078376, 
       0.594135063633089}, {0.34124477670688275`, 0.5927266945641166}, {
       0.34098041666666673`, 0.5910654099762193}, {0.34124477670688275`, 
       0.5894041253883219}, {0.3419976104078376, 0.5879957563193495}, {
       0.34312430566301544`, 0.5870547141931559}, {0.3444533333333334, 
       0.5867242641428859}, {0.34578236100365134`, 0.5870547141931559}, {
       0.3469090562588292, 0.5879957563193495}, {0.34766188995978403`, 
       0.5894041253883219}, {0.34792625000000005`, 0.5910654099762193}}], 
      PolygonBox[{{0.4254352232931174, 0.6686111414669491}, {
       0.42468238959216253`, 0.6700195105359215}, {0.4235556943369847, 
       0.6709605526621151}, {0.42222666666666675`, 0.6712910027123851}, {
       0.4208976389963488, 0.6709605526621151}, {0.41977094374117097`, 
       0.6700195105359215}, {0.4190181100402161, 0.6686111414669491}, {
       0.4187537500000001, 0.6669498568790517}, {0.4190181100402161, 
       0.6652885722911543}, {0.41977094374117097`, 0.663880203222182}, {
       0.4208976389963488, 0.6629391610959884}, {0.42222666666666675`, 
       0.6626087110457184}, {0.4235556943369847, 0.6629391610959884}, {
       0.42468238959216253`, 0.663880203222182}, {0.4254352232931174, 
       0.6652885722911543}, {0.4256995833333334, 0.6669498568790517}}], 
      PolygonBox[{{0.5032085566264508, 0.7359912182254941}, {
       0.5024557229254959, 0.7373995872944664}, {0.5013290276703181, 
       0.73834062942066}, {0.5000000000000001, 0.73867107947093}, {
       0.49867097232968216`, 0.73834062942066}, {0.4975442770745043, 
       0.7373995872944664}, {0.49679144337354947`, 0.7359912182254941}, {
       0.49652708333333345`, 0.7343299336375967}, {0.49679144337354947`, 
       0.7326686490496993}, {0.4975442770745043, 0.731260279980727}, {
       0.49867097232968216`, 0.7303192378545333}, {0.5000000000000001, 
       0.7299887878042634}, {0.5013290276703181, 0.7303192378545333}, {
       0.5024557229254959, 0.731260279980727}, {0.5032085566264508, 
       0.7326686490496993}, {0.5034729166666668, 0.7343299336375967}}], 
      PolygonBox[{{0.5809818899597841, 0.7969893843450804}, {
       0.5802290562588291, 0.7983977534140527}, {0.5791023610036513, 
       0.7993387955402463}, {0.5777733333333334, 0.7996692455905163}, {
       0.5764443056630154, 0.7993387955402463}, {0.5753176104078376, 
       0.7983977534140527}, {0.5745647767068827, 0.7969893843450804}, {
       0.5743004166666666, 0.795328099757183}, {0.5745647767068827, 
       0.7936668151692856}, {0.5753176104078376, 0.7922584461003133}, {
       0.5764443056630154, 0.7913174039741196}, {0.5777733333333334, 
       0.7909869539238497}, {0.5791023610036513, 0.7913174039741196}, {
       0.5802290562588291, 0.7922584461003133}, {0.5809818899597841, 
       0.7936668151692856}, {0.5812462500000001, 0.795328099757183}}], 
      PolygonBox[{{0.6587552232931174, 0.8529548931216046}, {
       0.6580023895921625, 0.8543632621905769}, {0.6568756943369847, 
       0.8553043043167705}, {0.6555466666666667, 0.8556347543670405}, {
       0.6542176389963488, 0.8553043043167705}, {0.6530909437411709, 
       0.8543632621905769}, {0.652338110040216, 0.8529548931216046}, {
       0.65207375, 0.8512936085337072}, {0.652338110040216, 
       0.8496323239458098}, {0.6530909437411709, 0.8482239548768374}, {
       0.6542176389963488, 0.8472829127506438}, {0.6555466666666667, 
       0.8469524627003738}, {0.6568756943369847, 0.8472829127506438}, {
       0.6580023895921625, 0.8482239548768374}, {0.6587552232931174, 
       0.8496323239458098}, {0.6590195833333334, 0.8512936085337072}}], 
      PolygonBox[{}], PolygonBox[{}], PolygonBox[{}]}, 
     {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], Opacity[
      1], Dashing[{}], CapForm[
      None], {LineBox[{{0.11434188995978399`, 0.2433404731022357}, {
        0.11358905625882912`, 0.24474884217120801`}, {0.11246236100365126`, 
        0.2456898842974016}, {0.11113333333333333`, 0.24602033434767162`}, {
        0.11113333333333333`, 0.24602033434767162`}}], 
       LineBox[{{0.11113333333333333`, 0.23733804268100495`}, {
        0.11113333333333333`, 0.23733804268100495`}, {0.11246236100365126`, 
        0.23766849273127497`}, {0.11358905625882912`, 0.23860953485746855`}, {
        0.11434188995978399`, 0.24001790392644087`}, {0.11460625, 
        0.24167918851433828`}, {0.11434188995978399`, 0.2433404731022357}}]}, 
      LineBox[{{0.1921152232931173, 0.3962602317354552}, {
       0.19136238959216245`, 0.39766860080442756`}, {0.1902356943369846, 
       0.3986096429306212}, {0.18890666666666667`, 0.39894009298089117`}, {
       0.18757763899634874`, 0.3986096429306212}, {0.18645094374117088`, 
       0.39766860080442756`}, {0.18569811004021602`, 0.3962602317354552}, {
       0.18543375, 0.39459894714755783`}, {0.18569811004021602`, 
       0.39293766255966045`}, {0.18645094374117088`, 0.3915292934906881}, {
       0.18757763899634874`, 0.3905882513644945}, {0.18890666666666667`, 
       0.3902578013142245}, {0.1902356943369846, 0.3905882513644945}, {
       0.19136238959216245`, 0.3915292934906881}, {0.1921152232931173, 
       0.39293766255966045`}, {0.19237958333333333`, 0.39459894714755783`}, {
       0.1921152232931173, 0.3962602317354552}}], 
      LineBox[{{0.26988855662645067`, 0.5045981778742863}, {
       0.2691357229254958, 0.5060065469432586}, {0.268009027670318, 
       0.5069475890694523}, {0.26668000000000003`, 0.5072780391197222}, {
       0.2653509723296821, 0.5069475890694523}, {0.26422427707450424`, 
       0.5060065469432586}, {0.2634714433735494, 0.5045981778742863}, {
       0.26320708333333337`, 0.5029368932863889}, {0.2634714433735494, 
       0.5012756086984915}, {0.26422427707450424`, 0.4998672396295192}, {
       0.2653509723296821, 0.49892619750332556`}, {0.26668000000000003`, 
       0.49859574745305557`}, {0.268009027670318, 0.49892619750332556`}, {
       0.2691357229254958, 0.4998672396295192}, {0.26988855662645067`, 
       0.5012756086984915}, {0.2701529166666667, 0.5029368932863889}, {
       0.26988855662645067`, 0.5045981778742863}}], 
      LineBox[{{0.34766188995978403`, 0.5927266945641166}, {
       0.3469090562588292, 0.594135063633089}, {0.34578236100365134`, 
       0.5950761057592826}, {0.3444533333333334, 0.5954065558095526}, {
       0.34312430566301544`, 0.5950761057592826}, {0.3419976104078376, 
       0.594135063633089}, {0.34124477670688275`, 0.5927266945641166}, {
       0.34098041666666673`, 0.5910654099762193}, {0.34124477670688275`, 
       0.5894041253883219}, {0.3419976104078376, 0.5879957563193495}, {
       0.34312430566301544`, 0.5870547141931559}, {0.3444533333333334, 
       0.5867242641428859}, {0.34578236100365134`, 0.5870547141931559}, {
       0.3469090562588292, 0.5879957563193495}, {0.34766188995978403`, 
       0.5894041253883219}, {0.34792625000000005`, 0.5910654099762193}, {
       0.34766188995978403`, 0.5927266945641166}}], 
      LineBox[{{0.4254352232931174, 0.6686111414669491}, {
       0.42468238959216253`, 0.6700195105359215}, {0.4235556943369847, 
       0.6709605526621151}, {0.42222666666666675`, 0.6712910027123851}, {
       0.4208976389963488, 0.6709605526621151}, {0.41977094374117097`, 
       0.6700195105359215}, {0.4190181100402161, 0.6686111414669491}, {
       0.4187537500000001, 0.6669498568790517}, {0.4190181100402161, 
       0.6652885722911543}, {0.41977094374117097`, 0.663880203222182}, {
       0.4208976389963488, 0.6629391610959884}, {0.42222666666666675`, 
       0.6626087110457184}, {0.4235556943369847, 0.6629391610959884}, {
       0.42468238959216253`, 0.663880203222182}, {0.4254352232931174, 
       0.6652885722911543}, {0.4256995833333334, 0.6669498568790517}, {
       0.4254352232931174, 0.6686111414669491}}], 
      LineBox[{{0.5032085566264508, 0.7359912182254941}, {0.5024557229254959, 
       0.7373995872944664}, {0.5013290276703181, 0.73834062942066}, {
       0.5000000000000001, 0.73867107947093}, {0.49867097232968216`, 
       0.73834062942066}, {0.4975442770745043, 0.7373995872944664}, {
       0.49679144337354947`, 0.7359912182254941}, {0.49652708333333345`, 
       0.7343299336375967}, {0.49679144337354947`, 0.7326686490496993}, {
       0.4975442770745043, 0.731260279980727}, {0.49867097232968216`, 
       0.7303192378545333}, {0.5000000000000001, 0.7299887878042634}, {
       0.5013290276703181, 0.7303192378545333}, {0.5024557229254959, 
       0.731260279980727}, {0.5032085566264508, 0.7326686490496993}, {
       0.5034729166666668, 0.7343299336375967}, {0.5032085566264508, 
       0.7359912182254941}}], 
      LineBox[{{0.5809818899597841, 0.7969893843450804}, {0.5802290562588291, 
       0.7983977534140527}, {0.5791023610036513, 0.7993387955402463}, {
       0.5777733333333334, 0.7996692455905163}, {0.5764443056630154, 
       0.7993387955402463}, {0.5753176104078376, 0.7983977534140527}, {
       0.5745647767068827, 0.7969893843450804}, {0.5743004166666666, 
       0.795328099757183}, {0.5745647767068827, 0.7936668151692856}, {
       0.5753176104078376, 0.7922584461003133}, {0.5764443056630154, 
       0.7913174039741196}, {0.5777733333333334, 0.7909869539238497}, {
       0.5791023610036513, 0.7913174039741196}, {0.5802290562588291, 
       0.7922584461003133}, {0.5809818899597841, 0.7936668151692856}, {
       0.5812462500000001, 0.795328099757183}, {0.5809818899597841, 
       0.7969893843450804}}], 
      LineBox[{{0.6587552232931174, 0.8529548931216046}, {0.6580023895921625, 
       0.8543632621905769}, {0.6568756943369847, 0.8553043043167705}, {
       0.6555466666666667, 0.8556347543670405}, {0.6542176389963488, 
       0.8553043043167705}, {0.6530909437411709, 0.8543632621905769}, {
       0.652338110040216, 0.8529548931216046}, {0.65207375, 
       0.8512936085337072}, {0.652338110040216, 0.8496323239458098}, {
       0.6530909437411709, 0.8482239548768374}, {0.6542176389963488, 
       0.8472829127506438}, {0.6555466666666667, 0.8469524627003738}, {
       0.6568756943369847, 0.8472829127506438}, {0.6580023895921625, 
       0.8482239548768374}, {0.6587552232931174, 0.8496323239458098}, {
       0.6590195833333334, 0.8512936085337072}, {0.6587552232931174, 
       0.8529548931216046}}], {}, {}, {}}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], LineBox[{{0.11113333333333333`, 0.1389166666666667}, {
       0.18890666666666667`, 0.32518567777435825`}, {0.26668000000000003`, 
       0.4722133329760082}, {0.3444533333333334, 0.5856355722669526}, {
       0.42222666666666675`, 0.6804599466335656}, {0.5000000000000001, 
       0.7632850393110616}, {0.5777733333333334, 0.8375453012305225}, {
       0.6047982837251793, 0.8610833333333333}}]}, 
     {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
      None], {}, 
      {GrayLevel[1], Opacity[1], 
       PolygonBox[{{0.11113333333333333`, 0.14325781250000003`}, {
        0.11113333333333333`, 0.1389166666666667}, {0.11460625, 
        0.1389166666666667}, {0.11460625, 0.1389166666666667}, {
        0.11434188995978399`, 0.1405779512545641}, {0.11358905625882912`, 
        0.14198632032353642`}, {0.11246236100365126`, 0.14292736244973}, {
        0.11113333333333333`, 0.14325781250000003`}}], 
       PolygonBox[{{0.1921152232931173, 0.32684696236225563`}, {
        0.19136238959216245`, 0.328255331431228}, {0.1902356943369846, 
        0.3291963735574216}, {0.18890666666666667`, 0.3295268236076916}, {
        0.18757763899634874`, 0.3291963735574216}, {0.18645094374117088`, 
        0.328255331431228}, {0.18569811004021602`, 0.32684696236225563`}, {
        0.18543375, 0.32518567777435825`}, {0.18569811004021602`, 
        0.32352439318646087`}, {0.18645094374117088`, 0.3221160241174885}, {
        0.18757763899634874`, 0.3211749819912949}, {0.18890666666666667`, 
        0.3208445319410249}, {0.1902356943369846, 0.3211749819912949}, {
        0.19136238959216245`, 0.3221160241174885}, {0.1921152232931173, 
        0.32352439318646087`}, {0.19237958333333333`, 0.32518567777435825`}}],
        PolygonBox[{{0.26988855662645067`, 0.4738746175639056}, {
        0.2691357229254958, 0.47528298663287794`}, {0.268009027670318, 
        0.47622402875907155`}, {0.26668000000000003`, 0.47655447880934154`}, {
        0.2653509723296821, 0.47622402875907155`}, {0.26422427707450424`, 
        0.47528298663287794`}, {0.2634714433735494, 0.4738746175639056}, {
        0.26320708333333337`, 0.4722133329760082}, {0.2634714433735494, 
        0.4705520483881108}, {0.26422427707450424`, 0.4691436793191385}, {
        0.2653509723296821, 0.46820263719294486`}, {0.26668000000000003`, 
        0.46787218714267487`}, {0.268009027670318, 0.46820263719294486`}, {
        0.2691357229254958, 0.4691436793191385}, {0.26988855662645067`, 
        0.4705520483881108}, {0.2701529166666667, 0.4722133329760082}}], 
       PolygonBox[{{0.34766188995978403`, 0.58729685685485}, {
        0.3469090562588292, 0.5887052259238224}, {0.34578236100365134`, 
        0.589646268050016}, {0.3444533333333334, 0.589976718100286}, {
        0.34312430566301544`, 0.589646268050016}, {0.3419976104078376, 
        0.5887052259238224}, {0.34124477670688275`, 0.58729685685485}, {
        0.34098041666666673`, 0.5856355722669526}, {0.34124477670688275`, 
        0.5839742876790552}, {0.3419976104078376, 0.5825659186100829}, {
        0.34312430566301544`, 0.5816248764838893}, {0.3444533333333334, 
        0.5812944264336193}, {0.34578236100365134`, 0.5816248764838893}, {
        0.3469090562588292, 0.5825659186100829}, {0.34766188995978403`, 
        0.5839742876790552}, {0.34792625000000005`, 0.5856355722669526}}], 
       PolygonBox[{{0.4254352232931174, 0.682121231221463}, {
        0.42468238959216253`, 0.6835296002904353}, {0.4235556943369847, 
        0.6844706424166289}, {0.42222666666666675`, 0.6848010924668989}, {
        0.4208976389963488, 0.6844706424166289}, {0.41977094374117097`, 
        0.6835296002904353}, {0.4190181100402161, 0.682121231221463}, {
        0.4187537500000001, 0.6804599466335656}, {0.4190181100402161, 
        0.6787986620456682}, {0.41977094374117097`, 0.6773902929766958}, {
        0.4208976389963488, 0.6764492508505022}, {0.42222666666666675`, 
        0.6761188008002322}, {0.4235556943369847, 0.6764492508505022}, {
        0.42468238959216253`, 0.6773902929766958}, {0.4254352232931174, 
        0.6787986620456682}, {0.4256995833333334, 0.6804599466335656}}], 
       PolygonBox[{{0.5032085566264508, 0.764946323898959}, {
        0.5024557229254959, 0.7663546929679314}, {0.5013290276703181, 
        0.767295735094125}, {0.5000000000000001, 0.767626185144395}, {
        0.49867097232968216`, 0.767295735094125}, {0.4975442770745043, 
        0.7663546929679314}, {0.49679144337354947`, 0.764946323898959}, {
        0.49652708333333345`, 0.7632850393110616}, {0.49679144337354947`, 
        0.7616237547231642}, {0.4975442770745043, 0.7602153856541919}, {
        0.49867097232968216`, 0.7592743435279983}, {0.5000000000000001, 
        0.7589438934777283}, {0.5013290276703181, 0.7592743435279983}, {
        0.5024557229254959, 0.7602153856541919}, {0.5032085566264508, 
        0.7616237547231642}, {0.5034729166666668, 0.7632850393110616}}], 
       PolygonBox[{{0.5809818899597841, 0.8392065858184199}, {
        0.5802290562588291, 0.8406149548873922}, {0.5791023610036513, 
        0.8415559970135859}, {0.5777733333333334, 0.8418864470638558}, {
        0.5764443056630154, 0.8415559970135859}, {0.5753176104078376, 
        0.8406149548873922}, {0.5745647767068827, 0.8392065858184199}, {
        0.5743004166666666, 0.8375453012305225}, {0.5745647767068827, 
        0.8358840166426251}, {0.5753176104078376, 0.8344756475736528}, {
        0.5764443056630154, 0.8335346054474592}, {0.5777733333333334, 
        0.8332041553971892}, {0.5791023610036513, 0.8335346054474592}, {
        0.5802290562588291, 0.8344756475736528}, {0.5809818899597841, 
        0.8358840166426251}, {0.5812462500000001, 0.8375453012305225}}], 
       PolygonBox[{}], PolygonBox[{}], PolygonBox[{}], PolygonBox[{}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], {LineBox[{{0.11434188995978399`, 0.1405779512545641}, {
         0.11358905625882912`, 0.14198632032353642`}, {0.11246236100365126`, 
         0.14292736244973}, {0.11113333333333333`, 0.14325781250000003`}, {
         0.11113333333333333`, 0.14325781250000003`}}], 
        LineBox[{{0.11460625, 0.1389166666666667}, {0.11460625, 
         0.1389166666666667}, {0.11434188995978399`, 0.1405779512545641}}]}, 
       LineBox[{{0.1921152232931173, 0.32684696236225563`}, {
        0.19136238959216245`, 0.328255331431228}, {0.1902356943369846, 
        0.3291963735574216}, {0.18890666666666667`, 0.3295268236076916}, {
        0.18757763899634874`, 0.3291963735574216}, {0.18645094374117088`, 
        0.328255331431228}, {0.18569811004021602`, 0.32684696236225563`}, {
        0.18543375, 0.32518567777435825`}, {0.18569811004021602`, 
        0.32352439318646087`}, {0.18645094374117088`, 0.3221160241174885}, {
        0.18757763899634874`, 0.3211749819912949}, {0.18890666666666667`, 
        0.3208445319410249}, {0.1902356943369846, 0.3211749819912949}, {
        0.19136238959216245`, 0.3221160241174885}, {0.1921152232931173, 
        0.32352439318646087`}, {0.19237958333333333`, 0.32518567777435825`}, {
        0.1921152232931173, 0.32684696236225563`}}], 
       LineBox[{{0.26988855662645067`, 0.4738746175639056}, {
        0.2691357229254958, 0.47528298663287794`}, {0.268009027670318, 
        0.47622402875907155`}, {0.26668000000000003`, 0.47655447880934154`}, {
        0.2653509723296821, 0.47622402875907155`}, {0.26422427707450424`, 
        0.47528298663287794`}, {0.2634714433735494, 0.4738746175639056}, {
        0.26320708333333337`, 0.4722133329760082}, {0.2634714433735494, 
        0.4705520483881108}, {0.26422427707450424`, 0.4691436793191385}, {
        0.2653509723296821, 0.46820263719294486`}, {0.26668000000000003`, 
        0.46787218714267487`}, {0.268009027670318, 0.46820263719294486`}, {
        0.2691357229254958, 0.4691436793191385}, {0.26988855662645067`, 
        0.4705520483881108}, {0.2701529166666667, 0.4722133329760082}, {
        0.26988855662645067`, 0.4738746175639056}}], 
       LineBox[{{0.34766188995978403`, 0.58729685685485}, {0.3469090562588292,
         0.5887052259238224}, {0.34578236100365134`, 0.589646268050016}, {
        0.3444533333333334, 0.589976718100286}, {0.34312430566301544`, 
        0.589646268050016}, {0.3419976104078376, 0.5887052259238224}, {
        0.34124477670688275`, 0.58729685685485}, {0.34098041666666673`, 
        0.5856355722669526}, {0.34124477670688275`, 0.5839742876790552}, {
        0.3419976104078376, 0.5825659186100829}, {0.34312430566301544`, 
        0.5816248764838893}, {0.3444533333333334, 0.5812944264336193}, {
        0.34578236100365134`, 0.5816248764838893}, {0.3469090562588292, 
        0.5825659186100829}, {0.34766188995978403`, 0.5839742876790552}, {
        0.34792625000000005`, 0.5856355722669526}, {0.34766188995978403`, 
        0.58729685685485}}], 
       LineBox[{{0.4254352232931174, 0.682121231221463}, {
        0.42468238959216253`, 0.6835296002904353}, {0.4235556943369847, 
        0.6844706424166289}, {0.42222666666666675`, 0.6848010924668989}, {
        0.4208976389963488, 0.6844706424166289}, {0.41977094374117097`, 
        0.6835296002904353}, {0.4190181100402161, 0.682121231221463}, {
        0.4187537500000001, 0.6804599466335656}, {0.4190181100402161, 
        0.6787986620456682}, {0.41977094374117097`, 0.6773902929766958}, {
        0.4208976389963488, 0.6764492508505022}, {0.42222666666666675`, 
        0.6761188008002322}, {0.4235556943369847, 0.6764492508505022}, {
        0.42468238959216253`, 0.6773902929766958}, {0.4254352232931174, 
        0.6787986620456682}, {0.4256995833333334, 0.6804599466335656}, {
        0.4254352232931174, 0.682121231221463}}], 
       LineBox[{{0.5032085566264508, 0.764946323898959}, {0.5024557229254959, 
        0.7663546929679314}, {0.5013290276703181, 0.767295735094125}, {
        0.5000000000000001, 0.767626185144395}, {0.49867097232968216`, 
        0.767295735094125}, {0.4975442770745043, 0.7663546929679314}, {
        0.49679144337354947`, 0.764946323898959}, {0.49652708333333345`, 
        0.7632850393110616}, {0.49679144337354947`, 0.7616237547231642}, {
        0.4975442770745043, 0.7602153856541919}, {0.49867097232968216`, 
        0.7592743435279983}, {0.5000000000000001, 0.7589438934777283}, {
        0.5013290276703181, 0.7592743435279983}, {0.5024557229254959, 
        0.7602153856541919}, {0.5032085566264508, 0.7616237547231642}, {
        0.5034729166666668, 0.7632850393110616}, {0.5032085566264508, 
        0.764946323898959}}], 
       LineBox[{{0.5809818899597841, 0.8392065858184199}, {0.5802290562588291,
         0.8406149548873922}, {0.5791023610036513, 0.8415559970135859}, {
        0.5777733333333334, 0.8418864470638558}, {0.5764443056630154, 
        0.8415559970135859}, {0.5753176104078376, 0.8406149548873922}, {
        0.5745647767068827, 0.8392065858184199}, {0.5743004166666666, 
        0.8375453012305225}, {0.5745647767068827, 0.8358840166426251}, {
        0.5753176104078376, 0.8344756475736528}, {0.5764443056630154, 
        0.8335346054474592}, {0.5777733333333334, 0.8332041553971892}, {
        0.5791023610036513, 0.8335346054474592}, {0.5802290562588291, 
        0.8344756475736528}, {0.5809818899597841, 0.8358840166426251}, {
        0.5812462500000001, 0.8375453012305225}, {0.5809818899597841, 
        0.8392065858184199}}], {}, {}, {}, {}}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], LineBox[{{0.11113333333333333`, 0.3077941364898914}, {
        0.18890666666666667`, 0.4839954010071282}, {0.26668000000000003`, 
        0.6127264233343626}, {0.3444533333333334, 0.7192197655605562}, {
        0.42222666666666675`, 0.8118881035362778}, {0.4683497099186271, 
        0.8610833333333333}}]}, 
      {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
       None], {}, 
       {GrayLevel[1], Opacity[1], 
        PolygonBox[{{0.11113333333333333`, 0.31213528232322474`}, {
         0.11113333333333333`, 0.30345299065655806`}, {0.11113333333333333`, 
         0.30345299065655806`}, {0.11246236100365126`, 
         0.30378344070682806`}, {0.11358905625882912`, 
         0.30472448283302167`}, {0.11434188995978399`, 0.306132851901994}, {
         0.11460625, 0.3077941364898914}, {0.11434188995978399`, 
         0.3094554210777888}, {0.11358905625882912`, 0.31086379014676113`}, {
         0.11246236100365126`, 0.31180483227295475`}, {0.11113333333333333`, 
         0.31213528232322474`}}], 
        PolygonBox[{{0.1921152232931173, 0.48565668559502556`}, {
         0.19136238959216245`, 0.4870650546639979}, {0.1902356943369846, 
         0.4880060967901915}, {0.18890666666666667`, 0.4883365468404615}, {
         0.18757763899634874`, 0.4880060967901915}, {0.18645094374117088`, 
         0.4870650546639979}, {0.18569811004021602`, 0.48565668559502556`}, {
         0.18543375, 0.4839954010071282}, {0.18569811004021602`, 
         0.4823341164192308}, {0.18645094374117088`, 0.48092574735025845`}, {
         0.18757763899634874`, 0.47998470522406483`}, {0.18890666666666667`, 
         0.47965425517379484`}, {0.1902356943369846, 0.47998470522406483`}, {
         0.19136238959216245`, 0.48092574735025845`}, {0.1921152232931173, 
         0.4823341164192308}, {0.19237958333333333`, 0.4839954010071282}}], 
        PolygonBox[{{0.26988855662645067`, 0.6143877079222599}, {
         0.2691357229254958, 0.6157960769912323}, {0.268009027670318, 
         0.6167371191174259}, {0.26668000000000003`, 0.6170675691676959}, {
         0.2653509723296821, 0.6167371191174259}, {0.26422427707450424`, 
         0.6157960769912323}, {0.2634714433735494, 0.6143877079222599}, {
         0.26320708333333337`, 0.6127264233343626}, {0.2634714433735494, 
         0.6110651387464652}, {0.26422427707450424`, 0.6096567696774928}, {
         0.2653509723296821, 0.6087157275512992}, {0.26668000000000003`, 
         0.6083852775010292}, {0.268009027670318, 0.6087157275512992}, {
         0.2691357229254958, 0.6096567696774928}, {0.26988855662645067`, 
         0.6110651387464652}, {0.2701529166666667, 0.6127264233343626}}], 
        PolygonBox[{{0.34766188995978403`, 0.7208810501484536}, {
         0.3469090562588292, 0.722289419217426}, {0.34578236100365134`, 
         0.7232304613436196}, {0.3444533333333334, 0.7235609113938896}, {
         0.34312430566301544`, 0.7232304613436196}, {0.3419976104078376, 
         0.722289419217426}, {0.34124477670688275`, 0.7208810501484536}, {
         0.34098041666666673`, 0.7192197655605562}, {0.34124477670688275`, 
         0.7175584809726588}, {0.3419976104078376, 0.7161501119036865}, {
         0.34312430566301544`, 0.7152090697774929}, {0.3444533333333334, 
         0.7148786197272229}, {0.34578236100365134`, 0.7152090697774929}, {
         0.3469090562588292, 0.7161501119036865}, {0.34766188995978403`, 
         0.7175584809726588}, {0.34792625000000005`, 0.7192197655605562}}], 
        PolygonBox[{{0.4254352232931174, 0.8135493881241752}, {
         0.42468238959216253`, 0.8149577571931476}, {0.4235556943369847, 
         0.8158987993193412}, {0.42222666666666675`, 0.8162292493696112}, {
         0.4208976389963488, 0.8158987993193412}, {0.41977094374117097`, 
         0.8149577571931476}, {0.4190181100402161, 0.8135493881241752}, {
         0.4187537500000001, 0.8118881035362778}, {0.4190181100402161, 
         0.8102268189483804}, {0.41977094374117097`, 0.8088184498794081}, {
         0.4208976389963488, 0.8078774077532145}, {0.42222666666666675`, 
         0.8075469577029445}, {0.4235556943369847, 0.8078774077532145}, {
         0.42468238959216253`, 0.8088184498794081}, {0.4254352232931174, 
         0.8102268189483804}, {0.4256995833333334, 0.8118881035362778}}], 
        PolygonBox[{}], PolygonBox[{}], PolygonBox[{}], PolygonBox[{}], 
        PolygonBox[{}], PolygonBox[{}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], {
         LineBox[{{0.11434188995978399`, 0.3094554210777888}, {
          0.11358905625882912`, 0.31086379014676113`}, {0.11246236100365126`, 
          0.31180483227295475`}, {0.11113333333333333`, 
          0.31213528232322474`}, {0.11113333333333333`, 
          0.31213528232322474`}}], 
         LineBox[{{0.11113333333333333`, 0.30345299065655806`}, {
          0.11113333333333333`, 0.30345299065655806`}, {0.11246236100365126`, 
          0.30378344070682806`}, {0.11358905625882912`, 
          0.30472448283302167`}, {0.11434188995978399`, 0.306132851901994}, {
          0.11460625, 0.3077941364898914}, {0.11434188995978399`, 
          0.3094554210777888}}]}, 
        LineBox[{{0.1921152232931173, 0.48565668559502556`}, {
         0.19136238959216245`, 0.4870650546639979}, {0.1902356943369846, 
         0.4880060967901915}, {0.18890666666666667`, 0.4883365468404615}, {
         0.18757763899634874`, 0.4880060967901915}, {0.18645094374117088`, 
         0.4870650546639979}, {0.18569811004021602`, 0.48565668559502556`}, {
         0.18543375, 0.4839954010071282}, {0.18569811004021602`, 
         0.4823341164192308}, {0.18645094374117088`, 0.48092574735025845`}, {
         0.18757763899634874`, 0.47998470522406483`}, {0.18890666666666667`, 
         0.47965425517379484`}, {0.1902356943369846, 0.47998470522406483`}, {
         0.19136238959216245`, 0.48092574735025845`}, {0.1921152232931173, 
         0.4823341164192308}, {0.19237958333333333`, 0.4839954010071282}, {
         0.1921152232931173, 0.48565668559502556`}}], 
        LineBox[{{0.26988855662645067`, 0.6143877079222599}, {
         0.2691357229254958, 0.6157960769912323}, {0.268009027670318, 
         0.6167371191174259}, {0.26668000000000003`, 0.6170675691676959}, {
         0.2653509723296821, 0.6167371191174259}, {0.26422427707450424`, 
         0.6157960769912323}, {0.2634714433735494, 0.6143877079222599}, {
         0.26320708333333337`, 0.6127264233343626}, {0.2634714433735494, 
         0.6110651387464652}, {0.26422427707450424`, 0.6096567696774928}, {
         0.2653509723296821, 0.6087157275512992}, {0.26668000000000003`, 
         0.6083852775010292}, {0.268009027670318, 0.6087157275512992}, {
         0.2691357229254958, 0.6096567696774928}, {0.26988855662645067`, 
         0.6110651387464652}, {0.2701529166666667, 0.6127264233343626}, {
         0.26988855662645067`, 0.6143877079222599}}], 
        LineBox[{{0.34766188995978403`, 0.7208810501484536}, {
         0.3469090562588292, 0.722289419217426}, {0.34578236100365134`, 
         0.7232304613436196}, {0.3444533333333334, 0.7235609113938896}, {
         0.34312430566301544`, 0.7232304613436196}, {0.3419976104078376, 
         0.722289419217426}, {0.34124477670688275`, 0.7208810501484536}, {
         0.34098041666666673`, 0.7192197655605562}, {0.34124477670688275`, 
         0.7175584809726588}, {0.3419976104078376, 0.7161501119036865}, {
         0.34312430566301544`, 0.7152090697774929}, {0.3444533333333334, 
         0.7148786197272229}, {0.34578236100365134`, 0.7152090697774929}, {
         0.3469090562588292, 0.7161501119036865}, {0.34766188995978403`, 
         0.7175584809726588}, {0.34792625000000005`, 0.7192197655605562}, {
         0.34766188995978403`, 0.7208810501484536}}], 
        LineBox[{{0.4254352232931174, 0.8135493881241752}, {
         0.42468238959216253`, 0.8149577571931476}, {0.4235556943369847, 
         0.8158987993193412}, {0.42222666666666675`, 0.8162292493696112}, {
         0.4208976389963488, 0.8158987993193412}, {0.41977094374117097`, 
         0.8149577571931476}, {0.4190181100402161, 0.8135493881241752}, {
         0.4187537500000001, 0.8118881035362778}, {0.4190181100402161, 
         0.8102268189483804}, {0.41977094374117097`, 0.8088184498794081}, {
         0.4208976389963488, 0.8078774077532145}, {0.42222666666666675`, 
         0.8075469577029445}, {0.4235556943369847, 0.8078774077532145}, {
         0.42468238959216253`, 0.8088184498794081}, {0.4254352232931174, 
         0.8102268189483804}, {0.4256995833333334, 0.8118881035362778}, {
         0.4254352232931174, 0.8135493881241752}}], {}, {}, {}, {}, {}, {}}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], LineBox[{{0.11113333333333333`, 0.407014456277654}, {
         0.18890666666666667`, 0.5754585031885906}, {0.26668000000000003`, 
         0.7026518832622323}, {0.3444533333333334, 0.8101625550536755}, {
         0.38620376554148084`, 0.8610833333333333}}]}, 
       {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
        None], {}, 
        {GrayLevel[1], Opacity[1], 
         PolygonBox[{{0.11113333333333333`, 0.4113556021109873}, {
          0.11113333333333333`, 0.40267331044432064`}, {0.11113333333333333`, 
          0.40267331044432064`}, {0.11246236100365126`, 
          0.40300376049459063`}, {0.11358905625882912`, 
          0.40394480262078425`}, {0.11434188995978399`, 0.4053531716897566}, {
          0.11460625, 0.407014456277654}, {0.11434188995978399`, 
          0.40867574086555136`}, {0.11358905625882912`, 0.4100841099345237}, {
          0.11246236100365126`, 0.4110251520607173}, {0.11113333333333333`, 
          0.4113556021109873}}], 
         PolygonBox[{{0.1921152232931173, 0.577119787776488}, {
          0.19136238959216245`, 0.5785281568454603}, {0.1902356943369846, 
          0.5794691989716539}, {0.18890666666666667`, 0.5797996490219239}, {
          0.18757763899634874`, 0.5794691989716539}, {0.18645094374117088`, 
          0.5785281568454603}, {0.18569811004021602`, 0.577119787776488}, {
          0.18543375, 0.5754585031885906}, {0.18569811004021602`, 
          0.5737972186006932}, {0.18645094374117088`, 0.5723888495317209}, {
          0.18757763899634874`, 0.5714478074055273}, {0.18890666666666667`, 
          0.5711173573552573}, {0.1902356943369846, 0.5714478074055273}, {
          0.19136238959216245`, 0.5723888495317209}, {0.1921152232931173, 
          0.5737972186006932}, {0.19237958333333333`, 0.5754585031885906}}], 
         PolygonBox[{{0.26988855662645067`, 0.7043131678501297}, {
          0.2691357229254958, 0.705721536919102}, {0.268009027670318, 
          0.7066625790452956}, {0.26668000000000003`, 0.7069930290955656}, {
          0.2653509723296821, 0.7066625790452956}, {0.26422427707450424`, 
          0.705721536919102}, {0.2634714433735494, 0.7043131678501297}, {
          0.26320708333333337`, 0.7026518832622323}, {0.2634714433735494, 
          0.7009905986743349}, {0.26422427707450424`, 0.6995822296053625}, {
          0.2653509723296821, 0.6986411874791689}, {0.26668000000000003`, 
          0.6983107374288989}, {0.268009027670318, 0.6986411874791689}, {
          0.2691357229254958, 0.6995822296053625}, {0.26988855662645067`, 
          0.7009905986743349}, {0.2701529166666667, 0.7026518832622323}}], 
         PolygonBox[{{0.34766188995978403`, 0.8118238396415729}, {
          0.3469090562588292, 0.8132322087105452}, {0.34578236100365134`, 
          0.8141732508367389}, {0.3444533333333334, 0.8145037008870089}, {
          0.34312430566301544`, 0.8141732508367389}, {0.3419976104078376, 
          0.8132322087105452}, {0.34124477670688275`, 0.8118238396415729}, {
          0.34098041666666673`, 0.8101625550536755}, {0.34124477670688275`, 
          0.8085012704657781}, {0.3419976104078376, 0.8070929013968058}, {
          0.34312430566301544`, 0.8061518592706122}, {0.3444533333333334, 
          0.8058214092203422}, {0.34578236100365134`, 0.8061518592706122}, {
          0.3469090562588292, 0.8070929013968058}, {0.34766188995978403`, 
          0.8085012704657781}, {0.34792625000000005`, 0.8101625550536755}}], 
         PolygonBox[{}], PolygonBox[{}], PolygonBox[{}], PolygonBox[{}], 
         PolygonBox[{}], PolygonBox[{}], PolygonBox[{}]}, 
        {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}], CapForm[
         None], {LineBox[{{0.11434188995978399`, 0.40867574086555136`}, {
           0.11358905625882912`, 0.4100841099345237}, {0.11246236100365126`, 
           0.4110251520607173}, {0.11113333333333333`, 0.4113556021109873}, {
           0.11113333333333333`, 0.4113556021109873}}], 
          LineBox[{{0.11113333333333333`, 0.40267331044432064`}, {
           0.11113333333333333`, 0.40267331044432064`}, {0.11246236100365126`,
            0.40300376049459063`}, {0.11358905625882912`, 
           0.40394480262078425`}, {0.11434188995978399`, 
           0.4053531716897566}, {0.11460625, 0.407014456277654}, {
           0.11434188995978399`, 0.40867574086555136`}}]}, 
         LineBox[{{0.1921152232931173, 0.577119787776488}, {
          0.19136238959216245`, 0.5785281568454603}, {0.1902356943369846, 
          0.5794691989716539}, {0.18890666666666667`, 0.5797996490219239}, {
          0.18757763899634874`, 0.5794691989716539}, {0.18645094374117088`, 
          0.5785281568454603}, {0.18569811004021602`, 0.577119787776488}, {
          0.18543375, 0.5754585031885906}, {0.18569811004021602`, 
          0.5737972186006932}, {0.18645094374117088`, 0.5723888495317209}, {
          0.18757763899634874`, 0.5714478074055273}, {0.18890666666666667`, 
          0.5711173573552573}, {0.1902356943369846, 0.5714478074055273}, {
          0.19136238959216245`, 0.5723888495317209}, {0.1921152232931173, 
          0.5737972186006932}, {0.19237958333333333`, 0.5754585031885906}, {
          0.1921152232931173, 0.577119787776488}}], 
         LineBox[{{0.26988855662645067`, 0.7043131678501297}, {
          0.2691357229254958, 0.705721536919102}, {0.268009027670318, 
          0.7066625790452956}, {0.26668000000000003`, 0.7069930290955656}, {
          0.2653509723296821, 0.7066625790452956}, {0.26422427707450424`, 
          0.705721536919102}, {0.2634714433735494, 0.7043131678501297}, {
          0.26320708333333337`, 0.7026518832622323}, {0.2634714433735494, 
          0.7009905986743349}, {0.26422427707450424`, 0.6995822296053625}, {
          0.2653509723296821, 0.6986411874791689}, {0.26668000000000003`, 
          0.6983107374288989}, {0.268009027670318, 0.6986411874791689}, {
          0.2691357229254958, 0.6995822296053625}, {0.26988855662645067`, 
          0.7009905986743349}, {0.2701529166666667, 0.7026518832622323}, {
          0.26988855662645067`, 0.7043131678501297}}], 
         LineBox[{{0.34766188995978403`, 0.8118238396415729}, {
          0.3469090562588292, 0.8132322087105452}, {0.34578236100365134`, 
          0.8141732508367389}, {0.3444533333333334, 0.8145037008870089}, {
          0.34312430566301544`, 0.8141732508367389}, {0.3419976104078376, 
          0.8132322087105452}, {0.34124477670688275`, 0.8118238396415729}, {
          0.34098041666666673`, 0.8101625550536755}, {0.34124477670688275`, 
          0.8085012704657781}, {0.3419976104078376, 0.8070929013968058}, {
          0.34312430566301544`, 0.8061518592706122}, {0.3444533333333334, 
          0.8058214092203422}, {0.34578236100365134`, 0.8061518592706122}, {
          0.3469090562588292, 0.8070929013968058}, {0.34766188995978403`, 
          0.8085012704657781}, {0.34792625000000005`, 0.8101625550536755}, {
          0.34766188995978403`, 
          0.8118238396415729}}], {}, {}, {}, {}, {}, {}, {}}, 
        {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
         Opacity[1], AbsoluteDashing[{4, 2}], CapForm[None], 
         LineBox[{{0.11113333333333333`, 0.19634351101945272`}, {
          0.18890666666666667`, 0.3247197060880309}, {0.26668000000000003`, 
          0.4240475534391513}, {0.3444533333333334, 0.5060405211094474}, {
          0.42222666666666675`, 0.5769578421789909}, {0.5000000000000001, 
          0.6400638125988353}, {0.5777733333333334, 0.6972689229406444}, {
          0.6555466666666667, 0.7498029924094738}, {0.7333200000000001, 
          0.7985142914195279}, {0.8110933333333334, 0.8440186114663482}, {
          0.8421297281051507, 0.8610833333333333}}]}, 
        {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
         Opacity[1], Dashing[{}], CapForm[None], {}, 
         {GrayLevel[1], Opacity[1], 
          PolygonBox[{{0.11113333333333333`, 0.20068465685278605`}, {
           0.11113333333333333`, 0.19200236518611938`}, {0.11113333333333333`,
            0.19200236518611938`}, {0.11246236100365126`, 
           0.1923328152363894}, {0.11358905625882912`, 
           0.19327385736258298`}, {0.11434188995978399`, 
           0.1946822264315553}, {0.11460625, 0.19634351101945272`}, {
           0.11434188995978399`, 0.19800479560735013`}, {0.11358905625882912`,
            0.19941316467632245`}, {0.11246236100365126`, 
           0.20035420680251603`}, {0.11113333333333333`, 
           0.20068465685278605`}}], 
          PolygonBox[{{0.1921152232931173, 0.3263809906759283}, {
           0.19136238959216245`, 0.32778935974490064`}, {0.1902356943369846, 
           0.32873040187109426`}, {0.18890666666666667`, 
           0.32906085192136425`}, {0.18757763899634874`, 
           0.32873040187109426`}, {0.18645094374117088`, 
           0.32778935974490064`}, {0.18569811004021602`, 
           0.3263809906759283}, {0.18543375, 0.3247197060880309}, {
           0.18569811004021602`, 0.32305842150013353`}, {0.18645094374117088`,
            0.3216500524311612}, {0.18757763899634874`, 
           0.32070901030496757`}, {0.18890666666666667`, 
           0.3203785602546976}, {0.1902356943369846, 0.32070901030496757`}, {
           0.19136238959216245`, 0.3216500524311612}, {0.1921152232931173, 
           0.32305842150013353`}, {0.19237958333333333`, 
           0.3247197060880309}}], 
          PolygonBox[{{0.26988855662645067`, 0.4257088380270487}, {
           0.2691357229254958, 0.427117207096021}, {0.268009027670318, 
           0.42805824922221464`}, {0.26668000000000003`, 
           0.42838869927248463`}, {0.2653509723296821, 
           0.42805824922221464`}, {0.26422427707450424`, 0.427117207096021}, {
           0.2634714433735494, 0.4257088380270487}, {0.26320708333333337`, 
           0.4240475534391513}, {0.2634714433735494, 0.4223862688512539}, {
           0.26422427707450424`, 0.42097789978228156`}, {0.2653509723296821, 
           0.42003685765608795`}, {0.26668000000000003`, 
           0.41970640760581795`}, {0.268009027670318, 0.42003685765608795`}, {
           0.2691357229254958, 0.42097789978228156`}, {0.26988855662645067`, 
           0.4223862688512539}, {0.2701529166666667, 0.4240475534391513}}], 
          PolygonBox[{{0.34766188995978403`, 0.5077018056973448}, {
           0.3469090562588292, 0.5091101747663171}, {0.34578236100365134`, 
           0.5100512168925108}, {0.3444533333333334, 0.5103816669427808}, {
           0.34312430566301544`, 0.5100512168925108}, {0.3419976104078376, 
           0.5091101747663171}, {0.34124477670688275`, 0.5077018056973448}, {
           0.34098041666666673`, 0.5060405211094474}, {0.34124477670688275`, 
           0.50437923652155}, {0.3419976104078376, 0.5029708674525777}, {
           0.34312430566301544`, 0.5020298253263841}, {0.3444533333333334, 
           0.5016993752761141}, {0.34578236100365134`, 0.5020298253263841}, {
           0.3469090562588292, 0.5029708674525777}, {0.34766188995978403`, 
           0.50437923652155}, {0.34792625000000005`, 0.5060405211094474}}], 
          PolygonBox[{{0.4254352232931174, 0.5786191267668883}, {
           0.42468238959216253`, 0.5800274958358607}, {0.4235556943369847, 
           0.5809685379620543}, {0.42222666666666675`, 0.5812989880123243}, {
           0.4208976389963488, 0.5809685379620543}, {0.41977094374117097`, 
           0.5800274958358607}, {0.4190181100402161, 0.5786191267668883}, {
           0.4187537500000001, 0.5769578421789909}, {0.4190181100402161, 
           0.5752965575910935}, {0.41977094374117097`, 0.5738881885221212}, {
           0.4208976389963488, 0.5729471463959276}, {0.42222666666666675`, 
           0.5726166963456576}, {0.4235556943369847, 0.5729471463959276}, {
           0.42468238959216253`, 0.5738881885221212}, {0.4254352232931174, 
           0.5752965575910935}, {0.4256995833333334, 0.5769578421789909}}], 
          PolygonBox[{{0.5032085566264508, 0.6417250971867327}, {
           0.5024557229254959, 0.643133466255705}, {0.5013290276703181, 
           0.6440745083818986}, {0.5000000000000001, 0.6444049584321686}, {
           0.49867097232968216`, 0.6440745083818986}, {0.4975442770745043, 
           0.643133466255705}, {0.49679144337354947`, 0.6417250971867327}, {
           0.49652708333333345`, 0.6400638125988353}, {0.49679144337354947`, 
           0.6384025280109379}, {0.4975442770745043, 0.6369941589419655}, {
           0.49867097232968216`, 0.6360531168157719}, {0.5000000000000001, 
           0.6357226667655019}, {0.5013290276703181, 0.6360531168157719}, {
           0.5024557229254959, 0.6369941589419655}, {0.5032085566264508, 
           0.6384025280109379}, {0.5034729166666668, 0.6400638125988353}}], 
          PolygonBox[{{0.5809818899597841, 0.6989302075285417}, {
           0.5802290562588291, 0.7003385765975141}, {0.5791023610036513, 
           0.7012796187237077}, {0.5777733333333334, 0.7016100687739777}, {
           0.5764443056630154, 0.7012796187237077}, {0.5753176104078376, 
           0.7003385765975141}, {0.5745647767068827, 0.6989302075285417}, {
           0.5743004166666666, 0.6972689229406444}, {0.5745647767068827, 
           0.695607638352747}, {0.5753176104078376, 0.6941992692837746}, {
           0.5764443056630154, 0.693258227157581}, {0.5777733333333334, 
           0.692927777107311}, {0.5791023610036513, 0.693258227157581}, {
           0.5802290562588291, 0.6941992692837746}, {0.5809818899597841, 
           0.695607638352747}, {0.5812462500000001, 0.6972689229406444}}], 
          PolygonBox[{{0.6587552232931174, 0.7514642769973712}, {
           0.6580023895921625, 0.7528726460663435}, {0.6568756943369847, 
           0.7538136881925371}, {0.6555466666666667, 0.7541441382428071}, {
           0.6542176389963488, 0.7538136881925371}, {0.6530909437411709, 
           0.7528726460663435}, {0.652338110040216, 0.7514642769973712}, {
           0.65207375, 0.7498029924094738}, {0.652338110040216, 
           0.7481417078215764}, {0.6530909437411709, 0.7467333387526041}, {
           0.6542176389963488, 0.7457922966264104}, {0.6555466666666667, 
           0.7454618465761405}, {0.6568756943369847, 0.7457922966264104}, {
           0.6580023895921625, 0.7467333387526041}, {0.6587552232931174, 
           0.7481417078215764}, {0.6590195833333334, 0.7498029924094738}}], 
          PolygonBox[{{0.7365285566264508, 0.8001755760074253}, {
           0.7357757229254959, 0.8015839450763976}, {0.734649027670318, 
           0.8025249872025912}, {0.7333200000000001, 0.8028554372528612}, {
           0.7319909723296821, 0.8025249872025912}, {0.7308642770745043, 
           0.8015839450763976}, {0.7301114433735494, 0.8001755760074253}, {
           0.7298470833333334, 0.7985142914195279}, {0.7301114433735494, 
           0.7968530068316305}, {0.7308642770745043, 0.7954446377626582}, {
           0.7319909723296821, 0.7945035956364646}, {0.7333200000000001, 
           0.7941731455861946}, {0.734649027670318, 0.7945035956364646}, {
           0.7357757229254959, 0.7954446377626582}, {0.7365285566264508, 
           0.7968530068316305}, {0.7367929166666668, 0.7985142914195279}}], 
          PolygonBox[{{0.8143018899597841, 0.8456798960542455}, {
           0.8135490562588292, 0.8470882651232179}, {0.8124223610036514, 
           0.8480293072494115}, {0.8110933333333334, 0.8483597572996815}, {
           0.8097643056630155, 0.8480293072494115}, {0.8086376104078377, 
           0.8470882651232179}, {0.8078847767068827, 0.8456798960542455}, {
           0.8076204166666667, 0.8440186114663482}, {0.8078847767068827, 
           0.8423573268784508}, {0.8086376104078377, 0.8409489578094784}, {
           0.8097643056630155, 0.8400079156832848}, {0.8110933333333334, 
           0.8396774656330148}, {0.8124223610036514, 0.8400079156832848}, {
           0.8135490562588292, 0.8409489578094784}, {0.8143018899597841, 
           0.8423573268784508}, {0.8145662500000002, 0.8440186114663482}}], 
          PolygonBox[{}]}, 
         {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
          Opacity[1], Dashing[{}], CapForm[
          None], {LineBox[{{0.11434188995978399`, 0.19800479560735013`}, {
            0.11358905625882912`, 0.19941316467632245`}, {
            0.11246236100365126`, 0.20035420680251603`}, {
            0.11113333333333333`, 0.20068465685278605`}, {
            0.11113333333333333`, 0.20068465685278605`}}], 
           LineBox[{{0.11113333333333333`, 0.19200236518611938`}, {
            0.11113333333333333`, 0.19200236518611938`}, {
            0.11246236100365126`, 0.1923328152363894}, {0.11358905625882912`, 
            0.19327385736258298`}, {0.11434188995978399`, 
            0.1946822264315553}, {0.11460625, 0.19634351101945272`}, {
            0.11434188995978399`, 0.19800479560735013`}}]}, 
          LineBox[{{0.1921152232931173, 0.3263809906759283}, {
           0.19136238959216245`, 0.32778935974490064`}, {0.1902356943369846, 
           0.32873040187109426`}, {0.18890666666666667`, 
           0.32906085192136425`}, {0.18757763899634874`, 
           0.32873040187109426`}, {0.18645094374117088`, 
           0.32778935974490064`}, {0.18569811004021602`, 
           0.3263809906759283}, {0.18543375, 0.3247197060880309}, {
           0.18569811004021602`, 0.32305842150013353`}, {0.18645094374117088`,
            0.3216500524311612}, {0.18757763899634874`, 
           0.32070901030496757`}, {0.18890666666666667`, 
           0.3203785602546976}, {0.1902356943369846, 0.32070901030496757`}, {
           0.19136238959216245`, 0.3216500524311612}, {0.1921152232931173, 
           0.32305842150013353`}, {0.19237958333333333`, 
           0.3247197060880309}, {0.1921152232931173, 0.3263809906759283}}], 
          LineBox[{{0.26988855662645067`, 0.4257088380270487}, {
           0.2691357229254958, 0.427117207096021}, {0.268009027670318, 
           0.42805824922221464`}, {0.26668000000000003`, 
           0.42838869927248463`}, {0.2653509723296821, 
           0.42805824922221464`}, {0.26422427707450424`, 0.427117207096021}, {
           0.2634714433735494, 0.4257088380270487}, {0.26320708333333337`, 
           0.4240475534391513}, {0.2634714433735494, 0.4223862688512539}, {
           0.26422427707450424`, 0.42097789978228156`}, {0.2653509723296821, 
           0.42003685765608795`}, {0.26668000000000003`, 
           0.41970640760581795`}, {0.268009027670318, 0.42003685765608795`}, {
           0.2691357229254958, 0.42097789978228156`}, {0.26988855662645067`, 
           0.4223862688512539}, {0.2701529166666667, 0.4240475534391513}, {
           0.26988855662645067`, 0.4257088380270487}}], 
          LineBox[{{0.34766188995978403`, 0.5077018056973448}, {
           0.3469090562588292, 0.5091101747663171}, {0.34578236100365134`, 
           0.5100512168925108}, {0.3444533333333334, 0.5103816669427808}, {
           0.34312430566301544`, 0.5100512168925108}, {0.3419976104078376, 
           0.5091101747663171}, {0.34124477670688275`, 0.5077018056973448}, {
           0.34098041666666673`, 0.5060405211094474}, {0.34124477670688275`, 
           0.50437923652155}, {0.3419976104078376, 0.5029708674525777}, {
           0.34312430566301544`, 0.5020298253263841}, {0.3444533333333334, 
           0.5016993752761141}, {0.34578236100365134`, 0.5020298253263841}, {
           0.3469090562588292, 0.5029708674525777}, {0.34766188995978403`, 
           0.50437923652155}, {0.34792625000000005`, 0.5060405211094474}, {
           0.34766188995978403`, 0.5077018056973448}}], 
          LineBox[{{0.4254352232931174, 0.5786191267668883}, {
           0.42468238959216253`, 0.5800274958358607}, {0.4235556943369847, 
           0.5809685379620543}, {0.42222666666666675`, 0.5812989880123243}, {
           0.4208976389963488, 0.5809685379620543}, {0.41977094374117097`, 
           0.5800274958358607}, {0.4190181100402161, 0.5786191267668883}, {
           0.4187537500000001, 0.5769578421789909}, {0.4190181100402161, 
           0.5752965575910935}, {0.41977094374117097`, 0.5738881885221212}, {
           0.4208976389963488, 0.5729471463959276}, {0.42222666666666675`, 
           0.5726166963456576}, {0.4235556943369847, 0.5729471463959276}, {
           0.42468238959216253`, 0.5738881885221212}, {0.4254352232931174, 
           0.5752965575910935}, {0.4256995833333334, 0.5769578421789909}, {
           0.4254352232931174, 0.5786191267668883}}], 
          LineBox[{{0.5032085566264508, 0.6417250971867327}, {
           0.5024557229254959, 0.643133466255705}, {0.5013290276703181, 
           0.6440745083818986}, {0.5000000000000001, 0.6444049584321686}, {
           0.49867097232968216`, 0.6440745083818986}, {0.4975442770745043, 
           0.643133466255705}, {0.49679144337354947`, 0.6417250971867327}, {
           0.49652708333333345`, 0.6400638125988353}, {0.49679144337354947`, 
           0.6384025280109379}, {0.4975442770745043, 0.6369941589419655}, {
           0.49867097232968216`, 0.6360531168157719}, {0.5000000000000001, 
           0.6357226667655019}, {0.5013290276703181, 0.6360531168157719}, {
           0.5024557229254959, 0.6369941589419655}, {0.5032085566264508, 
           0.6384025280109379}, {0.5034729166666668, 0.6400638125988353}, {
           0.5032085566264508, 0.6417250971867327}}], 
          LineBox[{{0.5809818899597841, 0.6989302075285417}, {
           0.5802290562588291, 0.7003385765975141}, {0.5791023610036513, 
           0.7012796187237077}, {0.5777733333333334, 0.7016100687739777}, {
           0.5764443056630154, 0.7012796187237077}, {0.5753176104078376, 
           0.7003385765975141}, {0.5745647767068827, 0.6989302075285417}, {
           0.5743004166666666, 0.6972689229406444}, {0.5745647767068827, 
           0.695607638352747}, {0.5753176104078376, 0.6941992692837746}, {
           0.5764443056630154, 0.693258227157581}, {0.5777733333333334, 
           0.692927777107311}, {0.5791023610036513, 0.693258227157581}, {
           0.5802290562588291, 0.6941992692837746}, {0.5809818899597841, 
           0.695607638352747}, {0.5812462500000001, 0.6972689229406444}, {
           0.5809818899597841, 0.6989302075285417}}], 
          LineBox[{{0.6587552232931174, 0.7514642769973712}, {
           0.6580023895921625, 0.7528726460663435}, {0.6568756943369847, 
           0.7538136881925371}, {0.6555466666666667, 0.7541441382428071}, {
           0.6542176389963488, 0.7538136881925371}, {0.6530909437411709, 
           0.7528726460663435}, {0.652338110040216, 0.7514642769973712}, {
           0.65207375, 0.7498029924094738}, {0.652338110040216, 
           0.7481417078215764}, {0.6530909437411709, 0.7467333387526041}, {
           0.6542176389963488, 0.7457922966264104}, {0.6555466666666667, 
           0.7454618465761405}, {0.6568756943369847, 0.7457922966264104}, {
           0.6580023895921625, 0.7467333387526041}, {0.6587552232931174, 
           0.7481417078215764}, {0.6590195833333334, 0.7498029924094738}, {
           0.6587552232931174, 0.7514642769973712}}], 
          LineBox[{{0.7365285566264508, 0.8001755760074253}, {
           0.7357757229254959, 0.8015839450763976}, {0.734649027670318, 
           0.8025249872025912}, {0.7333200000000001, 0.8028554372528612}, {
           0.7319909723296821, 0.8025249872025912}, {0.7308642770745043, 
           0.8015839450763976}, {0.7301114433735494, 0.8001755760074253}, {
           0.7298470833333334, 0.7985142914195279}, {0.7301114433735494, 
           0.7968530068316305}, {0.7308642770745043, 0.7954446377626582}, {
           0.7319909723296821, 0.7945035956364646}, {0.7333200000000001, 
           0.7941731455861946}, {0.734649027670318, 0.7945035956364646}, {
           0.7357757229254959, 0.7954446377626582}, {0.7365285566264508, 
           0.7968530068316305}, {0.7367929166666668, 0.7985142914195279}, {
           0.7365285566264508, 0.8001755760074253}}], 
          LineBox[{{0.8143018899597841, 0.8456798960542455}, {
           0.8135490562588292, 0.8470882651232179}, {0.8124223610036514, 
           0.8480293072494115}, {0.8110933333333334, 0.8483597572996815}, {
           0.8097643056630155, 0.8480293072494115}, {0.8086376104078377, 
           0.8470882651232179}, {0.8078847767068827, 0.8456798960542455}, {
           0.8076204166666667, 0.8440186114663482}, {0.8078847767068827, 
           0.8423573268784508}, {0.8086376104078377, 0.8409489578094784}, {
           0.8097643056630155, 0.8400079156832848}, {0.8110933333333334, 
           0.8396774656330148}, {0.8124223610036514, 0.8400079156832848}, {
           0.8135490562588292, 0.8409489578094784}, {0.8143018899597841, 
           0.8423573268784508}, {0.8145662500000002, 0.8440186114663482}, {
           0.8143018899597841, 0.8456798960542455}}], {}}, 
         {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.6342961169014925, 0.2588479166666667}, {
           0.7545705497651742, 0.2588479166666667}}]}, 
         {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.6167965207574031, 0.29753541666666666`}, {
           0.7720701459092636, 0.29753541666666666`}}]}, 
         {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.6025722178723825, 0.33622291666666665`}, {
           0.7862944487942842, 0.33622291666666665`}}]}, 
         {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.5902726190476191, 0.37491041666666663`}, {
           0.7985940476190476, 0.37491041666666663`}}]}, 
         {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.5792793309396247, 0.4135979166666666}, {
           0.809587335727042, 0.4135979166666666}}]}, 
         {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.5692477345846343, 0.45228541666666666`}, {
           0.8196189320820324, 0.45228541666666666`}}]}, 
         {GrayLevel[0.5], AbsoluteThickness[1], Opacity[1], Dashing[{}], 
          CapForm[None], 
          LineBox[{{0.5599624294141199, 0.49097291666666665`}, {
           0.8289042372525468, 0.49097291666666665`}}]}, 
         {GrayLevel[0], AbsoluteThickness[2], Opacity[1], Dashing[{}], 
          CapForm[None], LineBox[CompressedData["
1:eJw92Hk8Fd//B3AVEkraFRUlJUpZEvJKklCWsoayJUpJoRBJKslaVKQdlVDC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           "]], 
          {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
           DiskBox[{0.6846129670127116, 0.2588479166666667}, {0.005556666666666666, 0.0069458333333333325`},
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
          {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
           Opacity[1], Dashing[{}], CapForm[None], 
           CircleBox[{0.6846129670127116, 0.2588479166666667}, {0.005556666666666666, 0.0069458333333333325`},
             NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
           {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
            DiskBox[{0.7042536996539551, 0.2588479166666667}, {0.005556666666666666, 0.0069458333333333325`},
              NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
           {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
            Opacity[1], Dashing[{}], CapForm[None], 
            CircleBox[{0.7042536996539551, 0.2588479166666667}, {0.005556666666666666, 0.0069458333333333325`},
              NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
            {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
             DiskBox[{0.6453315017302247, 0.29753541666666666`}, {0.005556666666666666, 0.0069458333333333325`},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
            {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
             Opacity[1], Dashing[{}], CapForm[None], 
             CircleBox[{0.6453315017302247, 0.29753541666666666`}, {0.005556666666666666, 0.0069458333333333325`},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
            {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
             Opacity[1], Dashing[{}], CapForm[None], 
             CircleBox[{0.6649722343714681, 0.29753541666666666`}, {0.005556666666666666, 0.0069458333333333325`},
               NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
             {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
              DiskBox[{0.6846129670127116, 0.29753541666666666`}, {0.005556666666666666, 0.0069458333333333325`},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
             {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
              Opacity[1], Dashing[{}], CapForm[None], 
              CircleBox[{0.6846129670127116, 0.29753541666666666`}, {0.005556666666666666, 0.0069458333333333325`},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
             {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
              Opacity[1], Dashing[{}], CapForm[None], 
              CircleBox[{0.7042536996539551, 0.29753541666666666`}, {0.005556666666666666, 0.0069458333333333325`},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
             {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
              Opacity[1], Dashing[{}], CapForm[None], 
              CircleBox[{0.7238944322951986, 0.29753541666666666`}, {0.005556666666666666, 0.0069458333333333325`},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
             {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
              Opacity[1], Dashing[{}], CapForm[None], 
              CircleBox[{0.743535164936442, 0.29753541666666666`}, {0.005556666666666666, 0.0069458333333333325`},
                NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
              {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
               DiskBox[{0.6453315017302247, 0.37491041666666663`}, {0.005556666666666666, 0.0069458333333333325`},
                 NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
              {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
               Opacity[1], Dashing[{}], CapForm[None], 
               CircleBox[{0.6453315017302247, 0.37491041666666663`}, {0.005556666666666666, 0.0069458333333333325`},
                 NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
               {GrayLevel[1], Opacity[1], 
                PolygonBox[{{0.6650996314324716, 0.30851658884197136`}, {
                 0.6513408213812915, 0.36271965484545343`}, {
                 0.6478523256973946, 0.36497958781101614`}, {
                 0.6460443793249445, 0.3606189682061451}, {0.6598031893761247,
                  0.306415902202663}}]}, 
               {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
                Opacity[1], Dashing[{}], CapForm[None], 
                LineBox[{{0.6650996314324716, 0.30851658884197136`}, {
                 0.6513408213812915, 0.36271965484545343`}}], 
                LineBox[{{0.6598031893761247, 0.306415902202663}, {
                 0.6460443793249445, 0.3606189682061451}}]}, 
               {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1], 
                Opacity[1], Dashing[{}], CapForm[None], 
                LineBox[{{0.6424284865800443, 0.35189772899640315`}, {
                 0.6478523256973946, 0.36497958781101614`}, {
                 0.6583178127490851, 0.3581997889143281}}], 
                {RGBColor[0.698004, 0.133305, 0.133305], Opacity[1], 
                 DiskBox[{0.7238944322951986, 0.37491041666666663`}, {0.005556666666666666, 0.0069458333333333325`},
                   NCache[{0, 2 Pi}, {0, 6.283185307179586}]]}, 
                {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[1],
                  Opacity[1], Dashing[{}], CapForm[None], 
                 CircleBox[{0.7238944322951986, 0.37491041666666663`}, {0.005556666666666666, 0.0069458333333333325`},
                   NCache[{0, 2 Pi}, {0, 6.283185307179586}]], 
                 {GrayLevel[1], Opacity[1], 
                  PolygonBox[{{0.7094227446492986, 0.306415902202663}, {
                   0.7231815547004786, 0.3606189682061451}, {
                   0.7213736083280285, 0.36497958781101614`}, {
                   0.7178851126441317, 0.36271965484545343`}, {
                   0.7041263025929516, 0.30851658884197136`}}]}, 
                 {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[
                  1], Opacity[1], Dashing[{}], CapForm[None], 
                  LineBox[{{0.7094227446492986, 0.306415902202663}, {
                   0.7231815547004786, 0.3606189682061451}}], 
                  LineBox[{{0.7041263025929516, 0.30851658884197136`}, {
                   0.7178851126441317, 0.36271965484545343`}}]}, 
                 {RGBColor[0.698004, 0.133305, 0.133305], AbsoluteThickness[
                  1], Opacity[1], Dashing[{}], CapForm[None], 
                  LineBox[{{0.7109081212763382, 0.3581997889143281}, {
                   0.7213736083280285, 0.36497958781101614`}, {
                   0.726797447445379, 0.35189772899640315`}}]}, 
                 {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}],
                   CapForm[None], 
                  LineBox[{{0.5760296891542944, 0.29753541666666666`}, {
                   0.6084615207574031, 0.29753541666666666`}}]}, 
                 {GrayLevel[0], AbsoluteThickness[1], Opacity[1], Dashing[{}],
                   CapForm[None], 
                  LineBox[{{0.6001265207574031, 0.30448125}, {
                   0.6084615207574031, 0.29753541666666666`}, {
                   0.6001265207574031, 0.29058958333333335`}}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\" 0\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], \
{0.11113333333333333`, 0.13718020833333336`}, {0, 1}, Automatic, {1, 0}], 
                  InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\" 2\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], \
{0.18890666666666667`, 0.13718020833333336`}, {0, 1}, Automatic, {1, 0}], 
                  InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\" 4\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], \
{0.26668000000000003`, 0.13718020833333336`}, {0, 1}, Automatic, {1, 0}], 
                  InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\" 6\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.3444533333333334, 0.13718020833333336`}, \
{0, 1}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\" 8\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], \
{0.42222666666666675`, 0.13718020833333336`}, {0, 1}, Automatic, {1, 0}], 
                  InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\"10\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.5000000000000001, 0.13718020833333336`}, \
{0, 1}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\"12\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.5777733333333334, 0.13718020833333336`}, \
{0, 1}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\"14\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.6555466666666667, 0.13718020833333336`}, \
{0, 1}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\"16\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.7333200000000001, 0.13718020833333336`}, \
{0, 1}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\"18\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.8110933333333334, 0.13718020833333336`}, \
{0, 1}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\"20\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.8888666666666668, 0.13718020833333336`}, \
{0, 1}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\"Excitation quanta\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.5, 0.07466770833333336}, {0, 0}, 
                   Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    SuperscriptBox["10", "0"],
                    DisplayForm],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.10974416666666667`, 0.1389166666666667}, \
{1, 0}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    SuperscriptBox["10", "2"],
                    DisplayForm],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.10974416666666667`, 0.2592777777777778}, \
{1, 0}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    SuperscriptBox["10", "4"],
                    DisplayForm],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], \
{0.10974416666666667`, 0.37963888888888886`}, {1, 0}, Automatic, {1, 0}], 
                  InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    SuperscriptBox["10", "6"],
                    DisplayForm],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.10974416666666667`, 0.5}, {1, 0}, 
                   Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    SuperscriptBox["10", "8"],
                    DisplayForm],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.10974416666666667`, 0.6203611111111111}, \
{1, 0}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    SuperscriptBox["10", "10"],
                    DisplayForm],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.10974416666666667`, 0.7407222222222222}, \
{1, 0}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    SuperscriptBox["10", "12"],
                    DisplayForm],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.10974416666666667`, 0.8610833333333333}, \
{1, 0}, Automatic, {1, 0}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox["\<\"Dimension\"\>",
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.04306416666666668, 0.5}, {0, 0}, 
                   Automatic, {0, 1}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    
                    TemplateBox[{
                    SubsuperscriptBox["", "", "8"],SubsuperscriptBox[
                    "Be", "", ""]},
                    "Row",
                    DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], "]"}]& )],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.3743864748484956, 0.5716217506192874}, {0, 0},
                    Automatic, {0.8450045373516333, 0.5347591344289055}], 
                  InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    
                    TemplateBox[{
                    SubsuperscriptBox["", "", "12"],SubsuperscriptBox[
                    "C", "", ""]},
                    "Row",
                    DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], "]"}]& )],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.2834248710964799, 0.5528487803440036}, {0, 0},
                    Automatic, {0.7408886802635362, 0.6716278459514284}], 
                  InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    
                    TemplateBox[{
                    SubsuperscriptBox["", "", "16"],SubsuperscriptBox[
                    "O", "", ""]},
                    "Row",
                    DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], "]"}]& )],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.44696613514009337`, 0.7369183149142263}, \
{0, 0}, Automatic, {0.761201117185811, 0.6485158897013035}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    
                    TemplateBox[{
                    SubsuperscriptBox["", "", "20"],SubsuperscriptBox[
                    "Ne", "", ""]},
                    "Row",
                    DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], "]"}]& )],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.26943926090631587`, 0.6505019478250222}, \
{0, 0}, Automatic, {0.674207391669256, 0.7385420726123451}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    
                    TemplateBox[{
                    SubsuperscriptBox["", "", "24"],SubsuperscriptBox[
                    "Mg", "", ""]},
                    "Row",
                    DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], "]"}]& )],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.25736710922482653`, 0.7239529824890665}, \
{0, 0}, Automatic, {0.6707050517389206, 0.7417241627262063}], InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[
                    TemplateBox[{TemplateBox[{
                    SubsuperscriptBox["", "", "12"], 
                    SubsuperscriptBox["C", "", ""]}, "Row", 
                    DisplayFunction -> (
                    RowBox[{#, "\[InvisibleSpace]", #2}]& ), 
                    InterpretationFunction -> (RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], "]"}]& )],"\" \"",TagBox[
                    StyleBox["\"J\"", FontSlant -> "Italic"], 
                    StyleForm[#, FontSlant -> "Italic"]& ],"\"=0\""},
                    "Row",
                    
                    DisplayFunction->(
                    RowBox[{#, "\[InvisibleSpace]", #2, 
                    "\[InvisibleSpace]", #3, "\[InvisibleSpace]", #4}]& ),
                    InterpretationFunction->(RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], "]"}]& )],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    DisplayForm], {0.6616574156174314, 0.7792679032869896}, {0, 0},
                    Automatic, {0.8940481027710078, 0.4479709699651993}], 
                  InsetBox[
                   TagBox[
                    StyleBox[
                    TagBox[GridBox[{
                    {"Valence"},
                    {"shell"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                    DisplayForm],
                    StripOnInput->False,
                    ShowAutoStyles->False,
                    SingleLetterItalics->False,
                    FontFamily->"Times",
                    FontSize->10,
                    FontWeight->"Plain",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    FontColor->GrayLevel[0],
                    FontOpacity->1],
                    
                    DisplayForm], {0.5760296891542944, 0.29753541666666666`}, \
{0.75, 0}, Automatic, {1, 0}]}}}}}}}}}}}}}}}},
  AspectRatio->NCache[
    Rational[4, 5], 0.8],
  Axes->False,
  Background->None,
  BaseStyle->{
   FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", FontTracking -> 
    "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 
    1, ShowAutoStyles -> False, SingleLetterItalics -> False},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{None, None, None, None},
  FrameStyle->Directive[{
     GrayLevel[0], 
     Opacity[1], 
     CapForm[None], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{}]}],
  FrameTicks->None,
  ImageSize->{360, 288},
  PlotRange->{{-0.0001, 1.0001}, {-0.0001, 1.0001}},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.4888382411875*^9, 3.49722503075*^9, {3.499022562703125*^9, 
   3.49902258615625*^9}, 3.50751243528125*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1272, 902},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
DockedCells->(FrontEndExecute[{
   FrontEnd`NotebookApply[
    FrontEnd`InputNotebook[], #, Placeholder]}]& ),
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{None, None, None}, {None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{71.875, 71.875}, {53.875, 53.875}}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 285, 6, 69, "Text"],
Cell[833, 28, 584, 11, 34, "Text"],
Cell[CellGroupData[{
Cell[1442, 43, 41, 0, 88, "Section"],
Cell[1486, 45, 533, 12, 55, "Text"],
Cell[CellGroupData[{
Cell[2044, 61, 184, 4, 35, "Input"],
Cell[2231, 67, 12761, 318, 145, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15041, 391, 95, 1, 88, "Section"],
Cell[15139, 394, 319, 7, 35, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15495, 406, 223, 5, 88, "Section"],
Cell[15721, 413, 271, 5, 34, "Text"],
Cell[CellGroupData[{
Cell[16017, 422, 1348, 34, 80, "Input"],
Cell[17368, 458, 1059, 33, 176, "Output"]
}, Open  ]],
Cell[18442, 494, 254, 5, 34, "Text"],
Cell[18699, 501, 2041, 57, 278, "Input"],
Cell[20743, 560, 166, 4, 34, "Text"],
Cell[CellGroupData[{
Cell[20934, 568, 394, 10, 58, "Input"],
Cell[21331, 580, 1116, 34, 176, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22484, 619, 6259, 142, 938, "Input"],
Cell[28746, 763, 86214, 1536, 468, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115009, 2305, 127, 1, 88, "Section"],
Cell[CellGroupData[{
Cell[115161, 2310, 93, 1, 46, "Subsection"],
Cell[115257, 2313, 180, 4, 34, "Text"],
Cell[115440, 2319, 2084, 54, 146, "Input"],
Cell[CellGroupData[{
Cell[117549, 2377, 2222, 56, 366, "Input"],
Cell[119774, 2435, 31127, 544, 288, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[150950, 2985, 122, 1, 46, "Subsection"],
Cell[151075, 2988, 1110, 29, 80, "Input"],
Cell[CellGroupData[{
Cell[152210, 3021, 2765, 70, 410, "Input"],
Cell[154978, 3093, 23529, 443, 288, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[178556, 3542, 103, 1, 46, "Subsection"],
Cell[CellGroupData[{
Cell[178684, 3547, 509, 14, 35, "Input"],
Cell[179196, 3563, 1816, 45, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181049, 3613, 1909, 49, 322, "Input"],
Cell[182961, 3664, 2014, 53, 288, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[185036, 3724, 272, 6, 88, "Section"],
Cell[185311, 3732, 227, 4, 55, "Text"],
Cell[185541, 3738, 781, 20, 58, "Input"],
Cell[186325, 3760, 841, 22, 146, "Input"],
Cell[187169, 3784, 249, 5, 34, "Text"],
Cell[187421, 3791, 3794, 89, 542, "Input"],
Cell[191218, 3882, 176, 2, 34, "Text"],
Cell[191397, 3886, 1381, 41, 168, "Input"],
Cell[192781, 3929, 1667, 40, 168, "Input"],
Cell[194451, 3971, 96, 1, 34, "Text"],
Cell[CellGroupData[{
Cell[194572, 3976, 506, 10, 35, "Input"],
Cell[195081, 3988, 376, 7, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195494, 4000, 1614, 35, 168, "Input"],
Cell[CellGroupData[{
Cell[197133, 4039, 181, 2, 27, "Print"],
Cell[197317, 4043, 895, 26, 50, "Print"],
Cell[198215, 4071, 178, 2, 27, "Print"],
Cell[198396, 4075, 911, 26, 50, "Print"],
Cell[199310, 4103, 181, 2, 27, "Print"],
Cell[199494, 4107, 896, 26, 50, "Print"],
Cell[200393, 4135, 181, 2, 27, "Print"],
Cell[200577, 4139, 910, 26, 50, "Print"],
Cell[201490, 4167, 181, 2, 27, "Print"],
Cell[201674, 4171, 939, 26, 50, "Print"],
Cell[202616, 4199, 181, 2, 27, "Print"],
Cell[202800, 4203, 958, 26, 72, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[203807, 4235, 17461, 412, 2148, "Input"],
Cell[221271, 4649, 153580, 2559, 378, 128478, 2145, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
