(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    200618,       5895]
NotebookOptionsPosition[    189109,       5533]
NotebookOutlinePosition[    190249,       5578]
CellTagsIndexPosition[    190175,       5573]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Header comments", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Title", ":", " ", "MCText"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Context", ":", " ", "MCText`"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"Author", ":", " ", 
      RowBox[{"Mark", " ", 
       RowBox[{"A", ".", " ", "Caprio"}]}]}]}], ",", " ", 
    RowBox[{"Department", " ", "of", " ", "Physics"}], ",", " ", 
    RowBox[{"University", " ", "of", " ", "Notre", " ", "Dame"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Summary", ":", " ", 
     RowBox[{"Miscellaneous", " ", "text", " ", "formatting", " ", 
      RowBox[{"utilities", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"Copyright", ":", " ", 
      RowBox[{"Copyright", " ", "2005"}]}]}], ",", " ", 
    RowBox[{"Mark", " ", 
     RowBox[{"A", ".", " ", "Caprio"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Package", " ", 
     RowBox[{"Version", ":", " ", "0.0"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Mathematica", " ", 
     RowBox[{"Version", ":", " ", "7.0"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", "History", ":", "\[IndentingNewLine]", 
     RowBox[{"Package", " ", "started", " ", "December", " ", "2003"}]}], ",",
     " ", 
    RowBox[{
    "based", " ", "upon", " ", "functions", " ", "written", " ", "for", " ", 
     RowBox[{"LevelScheme", ".", "\[IndentingNewLine]", "Distributed"}], " ", 
     "with", " ", "the", " ", "LevelScheme", " ", 
     RowBox[{"package", ".", "\[IndentingNewLine]", "Context"}], " ", 
     "changed", " ", "to", " ", "LevelScheme`", "*", 
     RowBox[{".", "\[IndentingNewLine]", "Rev", ".", " ", "January"}], " ", 
     "10"}], ",", " ", 
    RowBox[{"2013.", "  ", "Mathematica", " ", "9", " ", 
     RowBox[{"compatibility", "."}]}]}], "\[IndentingNewLine]", 
   "*)"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.42784100378125*^9, 3.427841006546875*^9}, {
  3.453754056546875*^9, 3.4537540963125*^9}, {3.4972228680625*^9, 
  3.497222868328125*^9}, {3.5668368406720896`*^9, 3.56683686231212*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin package", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", "\"\<LevelScheme`MCText`\>\"", "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.497222871546875*^9, 3.49722287309375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"$Context", "<>", "\"\<*\>\""}], "]"}], "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Messages", "Section"],

Cell[CellGroupData[{

Cell["Usage messages", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"textup", "::", "usage"}], "=", 
   "\"\<textup[text] gives non-italic text.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textsl", "::", "usage"}], "=", 
   "\"\<textsl[text] gives slanted text.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textit", "::", "usage"}], "=", 
   "\"\<textit[text] gives italic text.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"textmd", "::", "usage"}], "=", 
   "\"\<textmd[text] gives non-bold text.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textbf", "::", "usage"}], "=", 
   "\"\<textbf[text] gives bold text.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"textrm", "::", "usage"}], "=", 
   "\"\<textrm[text] gives text in the Times font.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"texttt", "::", "usage"}], "=", 
   "\"\<texttt[text] gives text in the Courier font.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"textsf", "::", "usage"}], "=", 
    "\"\<textsf[text] gives text in the Helvetica font.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textsize", "::", "usage"}], "=", 
   "\"\<textsize[size,text] gives text with the specified point size.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"textcolor", "::", "usage"}], "=", 
   "\"\<textcolor[color,text] gives text with the specified color.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"texttracking", "::", "usage"}], "=", 
   "\"\<texttracking[tracking,text] gives text with the specified tracking.\>\
\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"textfamily", "::", "usage"}], "=", 
   "\"\<textfamily[family,text] gives text with the specified family.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"texthidden", "::", "usage"}], "=", 
    "\"\<texthidden[text] gives invisible text.\>\""}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textsubscript", "::", "usage"}], "=", "\"\<UNDOCUMENTED\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"textsuperscript", "::", "usage"}], "=", "\"\<UNDOCUMENTED\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"textsubsuperscript", "::", "usage"}], "=", 
    "\"\<UNDOCUMENTED\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"hspace", "::", "usage"}], "=", 
    "\"\<hspace[width] produces box of given width in ems, which may be \
negative.\>\""}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"StackText", "::", "usage"}], "=", 
    "\"\<StackText[alignment,linegap,{line1,...}] produces a multiline label.\
\>\""}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LabelJP", "::", "usage"}], "=", 
   "\"\<LabelJP[J,P], or Label[J] for P=+1, produces a level spin label, with \
rational number fractions converted to typeset fractions.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LabelJiP", "::", "usage"}], "=", 
    "\"\<LabelJiP[J,i,P], or Label[J,i] for P=+1, produces a level spin \
label, with rational number fractions converted to typeset fractions, with \
subscript i.\>\""}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NucleusBox", "::", "usage"}], "=", 
   "\"\<UNDOCUMENTED (Limitation: Left subscript and superscript are left \
aligned.)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NuclearA", "::", "usage"}], "=", "\"\<UNDOCUMENTED\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NuclearN", "::", "usage"}], "=", "\"\<UNDOCUMENTED\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NuclearZ", "::", "usage"}], "=", "\"\<UNDOCUMENTED\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Isotope", "::", "usage"}], "=", 
    "\"\<UNDOCUMENTED -- inspired by usage of LaTeX isotope package\>\""}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SuperPrimeBox", "::", "usage"}], "=", 
   "\"\<SuperPrimeBox[x] places x in a SuperscriptBox with superscript prime. \
SuperPrimeBox[x,n] produces n primes. (UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SuperPrime", "::", "usage"}], "=", 
    "\"\<SuperPrime[x] superscripts x with a prime, in analogy to SuperPlus, \
SuperMinus, etc. -- since uses Superscript, behaves like mathematical \
expression, including automatic parenthesization.   SuperPrime[x,n] produces \
n primes.  (DEPRECATED)\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultipletLabel", "::", "usage"}], "=", 
   "\"\<MultipletLabel[{n1,n2,...}] displays as \\\"(n1,n2,...)\\\".  The \
option EntrySeparator specifies a separator to be used instead of commas, or \
None.  The option Delimiter->{left,right} specifies a delimiter to be used \
instead of left and right parentheses.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EntrySeparator", "::", "usage"}], "=", 
    "\"\<Option for MultipletLabel.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TightRowBox", "::", "usage"}], "=", 
    "\"\<UNDOCUMENTED (DEPRECATED)\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SolidusFractionBox", "::", "usage"}], "=", 
   "\"\<SolidusFractionBox[x,y] typesets x/y as a solidus fraction.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalFractionBox", "::", "usage"}], "=", 
   "\"\<DiagonalFractionBox[x,y] typesets x/y as a diagonal fraction.  The \
option ColumnSpacings->(spacing) controls the horizontal separation between \
the elements of the fraction.  The option \
Baseline->{numeratorheight,slashheight,denominatorheight} controls the \
vertical positioning of the different elements of the fraction.  \
KernForSuperscript->(adjustment) introduces a horizontal adjustment to the \
position of any superscript attached to the fraction.  The default option \
values produce visually reasonable results for the Times New Roman \
font.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"KernForSuperscript", "::", "usage"}], "=", 
    "\"\<KernForSuperscript is an option for DiagonalFractionBox.\>\""}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fractionize", "::", "usage"}], "=", 
   "\"\<Fractionize[expr] converts any expression with nonzero denominator \
into a FractionBox.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SolidusFractionize", "::", "usage"}], "=", 
   "\"\<SolidusFractionize[expr] converts any expression with nonzero \
denominator into a SolidusFractionBox.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DiagonalFractionize", "::", "usage"}], "=", 
    "\"\<DiagonalFractionize[expr] converts any expression with nonzero \
denominator into a DiagonalFractionBox.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FractionString", "::", "usage"}], "=", 
   "\"\<Provides a compact solidus-delimited fraction representation of a \
rational number, in string form. (UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PiFractionString", "::", "usage"}], "=", 
    "\"\<Provides a compact solidus-delimited fraction representation of a \
rational multiple of Pi, in string form. (UNDOCUMENTED)\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SignString", "::", "usage"}], "=", 
    "\"\<SignString[x] returns \\\"+\\\", \\\"\\\", or \\\"-\\\", depending \
upon the value of Sign[x].\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sqrtize", "::", "usage"}], "=", 
   "\"\<Sqrtize[x] formats a fraction which is the square root of a rational \
number entirely under the radical (e.g., the usual format for Clebsch-Gordan \
coefficients).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Radicalize", "::", "usage"}], "=", 
    "\"\<Radicalize[x,n] formats a fraction involving nth roots entirely \
under the radical.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SubarrayEllipsis", "::", "usage"}], "=", 
    "\"\<SubarrayEllipsis[m,{rows,cols}] prints a Subarray of m with ellipses \
appended.\>\""}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AlignmentBox", "::", "usage"}], "=", " ", 
   "\"\<UNDOCUMENTED  (AlignmentBox options: Any option for GridBox may be \
used. ColumnWidths is crucial option for alignment across labels. \
Options[AlignmentBox] overrides GridBox defaults of ColumnAlignments and \
ColumnSpacings. Any option for StyleBox may be used. Background is the most \
likely to be needed.)\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Align", "::", "usage"}], "=", 
   "\"\<Align is an option for AlignmentBox. (UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LaTeXTableEntryValue", "::", "usage"}], "=", 
    "\"\<LaTeXTableEntryValue[Str] takes a typical LaTeX table entry and \
converts it to a number, by stripping it of any leading nonnumeric \
characters, any \\\"&\\\", and any trailing error estimate following \
\\\"(\\\" or \\\"\[PlusMinus]\\\".   (UNDOCUMENTED)\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeColumnBox", "::", "usage"}], "=", "\"\<UNDOCUMENTED\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeHelpBox", "::", "usage"}], "=", 
   "\"\<UNDOCUMENTED  (Notebook style sheet should be HelpBrowser.)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeCaptionBox", "::", "usage"}], "=", "\"\<UNDOCUMENTED\>\""}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeButtonForURL", "::", "usage"}], "=", 
    "\"\<UNDOCUMENTED\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NPrint", "::", "usage"}], "=", 
    "\"\<NPrint[args] applies N to all numeric arguments before passing the \
resulting modified arguments to Print. (UNDOCUMENTED)\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PageBreak", "::", "usage"}], "=", 
   "\"\<PageBreak[] prints a cell with attribute PageBreakBelow set to \
True.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.45375386809375*^9, 3.453753870109375*^9}, {
   3.46109201778125*^9, 3.461092029296875*^9}, {3.46109326621875*^9, 
   3.46109332790625*^9}, {3.46109340240625*^9, 3.461093414578125*^9}, {
   3.461093694828125*^9, 3.46109378234375*^9}, {3.46109390425*^9, 
   3.461093906953125*^9}, 3.467215730703125*^9, {3.481816211375*^9, 
   3.481816212640625*^9}, {3.4818162670625*^9, 3.48181630678125*^9}, {
   3.4927253715*^9, 3.49272539484375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error messages", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LabelJP", "::", "invalidparity"}], "=", 
   "\"\<Parity must be +1, -1, or None.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LabelJiP", "::", "invalidparity"}], "=", 
   "\"\<Parity must be +1, -1, or None.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeColumnBox", "::", "notmult"}], "=", 
   "\"\<Number of contents items must be multiple of number of \
columns.\>\""}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin private context", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell["\<\
Workaround for missing FilterOptions\
\>", "Subsection",
 CellChangeTimes->{{3.566836726306817*^9, 3.566836734306828*^9}}],

Cell["Needs[\"Utilities`FilterOptions`\"]", "Program",
 CellChangeTimes->{3.5668367588968625`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LegacyFilterOptions", "[", 
    RowBox[{"f_Symbol", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"FilterRules", "[", 
     RowBox[{
      RowBox[{"{", "Opts", "}"}], ",", 
      RowBox[{"Options", "[", "f", "]"}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.5668367511368513`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"L", 
    StyleBox[
     AdjustmentBox["A",
      BoxBaselineShift->-0.2,
      BoxMargins->{{-0.36, -0.1}, {0, 0}}],
     FontSize->Smaller], "T", 
    AdjustmentBox["E",
     BoxBaselineShift->0.5,
     BoxMargins->{{-0.075, -0.085}, {0, 0}}], "X"}]]]],
 "-like text formatting"
}], "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"textup", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontSlant", "\[Rule]", "\"\<Plain\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textsl", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontSlant", "\[Rule]", "\"\<Oblique\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textit", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textmd", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textbf", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textrm", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"texttt", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Courier\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textsf", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"hspace", "[", "Lems_", "]"}], ":=", 
   RowBox[{"AdjustmentBox", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"BoxMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Lems"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"textsize", "[", 
    RowBox[{"s_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontSize", "\[Rule]", "s"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textcolor", "[", 
    RowBox[{"c_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontColor", "\[Rule]", "c"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"texttracking", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontTracking", "\[Rule]", "t"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textfamily", "[", 
    RowBox[{"f_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FontFamily", "\[Rule]", "f"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"texthidden", "[", "x_", "]"}], ":=", 
   RowBox[{"StyleForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"ShowContents", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",\

 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"textsubscript", "[", "x_", "]"}], ":=", 
   RowBox[{"SubscriptBox", "[", 
    RowBox[{"\"\<\>\"", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textsuperscript", "[", "y_", "]"}], ":=", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\"\<\>\"", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textsubsuperscript", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"SubsuperscriptBox", "[", 
    RowBox[{"\"\<\>\"", ",", "x", ",", "y"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell["Italic correction", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "textit", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"hspace", "\[Rule]", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"textit", "[", 
    RowBox[{"x_", ",", "Opts___"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{"Opts", ",", 
          RowBox[{"Options", "[", "textit", "]"}]}], "}"}], "]"}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"AdjustmentBox", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"StyleForm", "[", 
        RowBox[{"x", ",", 
         RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"BoxMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"hspace", "/.", "FullOpts"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]",
       "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["General text formatting", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StackText", "[", 
    RowBox[{"Alignment_", ",", "Spacing_", ",", "Lines_List", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"GridBox", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", "#", "}"}], "&"}], "/@", "Lines"}], ",", 
     RowBox[{"ColumnAlignments", "\[Rule]", "Alignment"}], ",", 
     RowBox[{"RowSpacings", "\[Rule]", "Spacing"}], ",", "Opts"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SuperPrimeBox", "[", 
     RowBox[{"x_", ",", 
      RowBox[{"n", ":", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"_Integer", "?", "NonNegative"}], ")"}], ":", "1"}]}]}], 
     "]"}], ":=", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"x", ",", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"Table", "[", 
        RowBox[{"\"\<\[Prime]\>\"", ",", 
         RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SuperPrime", "[", "x_", "]"}], ":=", 
     RowBox[{"Superscript", "[", 
      RowBox[{"x", ",", "\"\<\[Prime]\>\""}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SuperPrime", "[", 
    RowBox[{"x_", ",", 
     RowBox[{"n", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_Integer", "?", "NonNegative"}], ")"}], ":", "1"}]}]}], 
    "]"}], ":=", 
   RowBox[{"Superscript", "[", 
    RowBox[{"x", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"Table", "[", 
       RowBox[{"\"\<\[Prime]\>\"", ",", 
        RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.48181599803125*^9, 3.48181604925*^9}, {
  3.4818160843125*^9, 3.481816170328125*^9}, {3.481816202078125*^9, 
  3.481816203828125*^9}, {3.4818162516875*^9, 3.48181625884375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "NucleusBox", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"NuclearA", "->", "\"\<\>\""}], ",", 
     RowBox[{"NuclearZ", "->", "\"\<\>\""}], ",", 
     RowBox[{"NuclearN", "->", "\"\<\>\""}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NucleusBox", "[", 
    RowBox[{"Element_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{"Opts", ",", 
          RowBox[{"Options", "[", "NucleusBox", "]"}]}], "}"}], "]"}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Row", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SubsuperscriptBox", "[", 
         RowBox[{"\"\<\>\"", ",", 
          RowBox[{"NuclearZ", "/.", "FullOpts"}], ",", 
          RowBox[{"NuclearA", "/.", "FullOpts"}]}], "]"}], ",", 
        RowBox[{"SubsuperscriptBox", "[", 
         RowBox[{"Element", ",", 
          RowBox[{"NuclearN", "/.", "FullOpts"}], ",", "\"\<\>\""}], "]"}]}], 
       "  ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "to", " ", "match", " ", "subsuperscript", " ", "on", " ", "left", 
         " ", "for", " ", "alignment"}], " ", "*)"}], "\[IndentingNewLine]", 
       "}"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.488191930234375*^9, 3.488191991546875*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NucleusBox", "[", 
   RowBox[{"\"\<Au\>\"", ",", 
    RowBox[{"NuclearA", "\[Rule]", "\"\<A\>\""}], ",", 
    RowBox[{"NuclearZ", "->", "\"\<Z\>\""}], ",", 
    RowBox[{"NuclearN", "->", "\"\<N\>\""}]}], "]"}], "//", 
  "DisplayForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  TemplateBox[{
   SubsuperscriptBox["", "Z", "A"],SubsuperscriptBox["Au", "N", ""]},
   "Row",
   DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
   InterpretationFunction->(RowBox[{"Row", "[", 
      RowBox[{"{", 
        RowBox[{#, ",", #2}], "}"}], "]"}]& )],
  DisplayForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.488191937328125*^9, 3.488191995625*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"LIMITATION", ":", " ", 
   RowBox[{
   "A", " ", "and", " ", "Z", " ", "are", " ", "left", " ", "aligned"}]}], 
  " ", "*)"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.492725582515625*^9, 3.492725604453125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Isotope", "[", 
    RowBox[{
     RowBox[{"A_:", "None"}], ",", 
     RowBox[{"Z_:", "None"}], ",", 
     RowBox[{"N_:", "None"}], ",", 
     RowBox[{"Sup_:", "None"}], ",", "Element_String"}], "]"}], ":=", 
   RowBox[{"Row", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Subsuperscript", "[", 
       RowBox[{"\"\<\>\"", ",", 
        RowBox[{"Replace", "[", 
         RowBox[{"Z", ",", 
          RowBox[{"None", "\[Rule]", "\"\<\>\""}]}], "]"}], ",", 
        RowBox[{"Replace", "[", 
         RowBox[{"A", ",", 
          RowBox[{"None", "\[Rule]", "\"\<\>\""}]}], "]"}]}], "]"}], ",", 
      RowBox[{"Subsuperscript", "[", 
       RowBox[{"Element", ",", 
        RowBox[{"Replace", "[", 
         RowBox[{"N", ",", 
          RowBox[{"None", "\[Rule]", "\"\<\>\""}]}], "]"}], ",", 
        RowBox[{"Replace", "[", 
         RowBox[{"Sup", ",", 
          RowBox[{"None", "\[Rule]", "\"\<\>\""}]}], "]"}]}], "]"}]}], "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "to", " ", "match", " ", "subsuperscript", " ", "on", " ", "left", " ", 
       "for", " ", "alignment"}], " ", "*)"}], "\[IndentingNewLine]", "}"}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4927254290625*^9, 3.492725513234375*^9}, {
  3.492725546203125*^9, 3.492725567953125*^9}, {3.492725665453125*^9, 
  3.492725668390625*^9}, {3.492725770234375*^9, 3.492725808640625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Isotope", "[", "\"\<C\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Isotope", "[", 
  RowBox[{"12", ",", "\"\<C\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Isotope", "[", 
  RowBox[{"12", ",", "6", ",", "\"\<C\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Isotope", "[", 
  RowBox[{"12", ",", "6", ",", "6", ",", "\"\<C\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Isotope", "[", 
  RowBox[{"12", ",", "None", ",", "6", ",", "\"\<C\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Isotope", "[", 
  RowBox[{
  "12", ",", "None", ",", "None", ",", "\"\<*\>\"", ",", "\"\<C\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.492725706328125*^9, 3.492725750109375*^9}, {
  3.49272579659375*^9, 3.492725830453125*^9}}],

Cell[BoxData[
 TemplateBox[{InterpretationBox[
    SubsuperscriptBox["\"\"", "\"\"", "\"\""], 
    Subsuperscript["", "", ""], Editable -> False],InterpretationBox[
    SubsuperscriptBox["\"C\"", "\"\"", "\"\""], 
    Subsuperscript["C", "", ""], Editable -> False]},
  "Row",
  DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2}], "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.492725715703125*^9, 3.49272575075*^9}, {
  3.49272580296875*^9, 3.492725830921875*^9}}],

Cell[BoxData[
 TemplateBox[{InterpretationBox[
    SubsuperscriptBox["\"\"", "\"\"", "12"], 
    Subsuperscript["", "", 12], Editable -> False],InterpretationBox[
    SubsuperscriptBox["\"C\"", "\"\"", "\"\""], 
    Subsuperscript["C", "", ""], Editable -> False]},
  "Row",
  DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2}], "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.492725715703125*^9, 3.49272575075*^9}, {
  3.49272580296875*^9, 3.49272583096875*^9}}],

Cell[BoxData[
 TemplateBox[{InterpretationBox[
    SubsuperscriptBox["\"\"", "6", "12"], 
    Subsuperscript["", 6, 12], Editable -> False],InterpretationBox[
    SubsuperscriptBox["\"C\"", "\"\"", "\"\""], 
    Subsuperscript["C", "", ""], Editable -> False]},
  "Row",
  DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2}], "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.492725715703125*^9, 3.49272575075*^9}, {
  3.49272580296875*^9, 3.49272583096875*^9}}],

Cell[BoxData[
 TemplateBox[{InterpretationBox[
    SubsuperscriptBox["\"\"", "6", "12"], 
    Subsuperscript["", 6, 12], Editable -> False],InterpretationBox[
    SubsuperscriptBox["\"C\"", "6", "\"\""], 
    Subsuperscript["C", 6, ""], Editable -> False]},
  "Row",
  DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2}], "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.492725715703125*^9, 3.49272575075*^9}, {
  3.49272580296875*^9, 3.492725831015625*^9}}],

Cell[BoxData[
 TemplateBox[{InterpretationBox[
    SubsuperscriptBox["\"\"", "\"\"", "12"], 
    Subsuperscript["", "", 12], Editable -> False],InterpretationBox[
    SubsuperscriptBox["\"C\"", "6", "\"\""], 
    Subsuperscript["C", 6, ""], Editable -> False]},
  "Row",
  DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2}], "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.492725715703125*^9, 3.49272575075*^9}, {
  3.49272580296875*^9, 3.4927258310625*^9}}],

Cell[BoxData[
 TemplateBox[{InterpretationBox[
    SubsuperscriptBox["\"\"", "\"\"", "12"], 
    Subsuperscript["", "", 12], Editable -> False],InterpretationBox[
    SubsuperscriptBox["\"C\"", "\"\"", "\"*\""], 
    Subsuperscript["C", "", "*"], Editable -> False]},
  "Row",
  DisplayFunction->(RowBox[{#, "\[InvisibleSpace]", #2}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2}], "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.492725715703125*^9, 3.49272575075*^9}, {
  3.49272580296875*^9, 3.492725831109375*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LabelJiP", "[", 
    RowBox[{"J_", ",", "i_", ",", 
     RowBox[{"P_:", "+", "1"}]}], "]"}], ":=", 
   RowBox[{"SubsuperscriptBox", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"J", "/.", 
      RowBox[{"{", 
       RowBox[{"Rational", "\[Rule]", "FractionBox"}], "}"}]}], ",", 
     "\[IndentingNewLine]", "i", ",", "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"P", ",", 
       RowBox[{"+", "1"}], ",", "\"\<+\>\"", ",", 
       RowBox[{"-", "1"}], ",", "\"\<-\>\"", ",", "None", ",", "\"\<\>\"", 
       ",", "_", ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{"LabelJP", "::", "invalidparity"}], "]"}], ";", 
        "\"\<\>\""}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LabelJP", "[", 
    RowBox[{"J_", ",", 
     RowBox[{"P_:", "+", "1"}]}], "]"}], ":=", 
   RowBox[{"SuperscriptBox", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"J", "/.", 
      RowBox[{"{", 
       RowBox[{"Rational", "\[Rule]", "FractionBox"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"P", ",", 
       RowBox[{"+", "1"}], ",", "\"\<+\>\"", ",", 
       RowBox[{"-", "1"}], ",", "\"\<-\>\"", ",", "None", ",", "\"\<\>\"", 
       ",", "_", ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{"LabelJP", "::", "invalidparity"}], "]"}], ";", 
        "\"\<\>\""}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"LabelJiP", "[", 
     RowBox[{"2", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "]"}], ",", 
    RowBox[{"LabelJiP", "[", 
     RowBox[{"2", ",", "1", ",", "None"}], "]"}], ",", 
    RowBox[{"LabelJiP", "[", 
     RowBox[{"2", ",", "1", ",", "999"}], "]"}], ",", 
    RowBox[{"LabelJiP", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], ",", 
    RowBox[{"LabelJP", "[", 
     RowBox[{"1", "/", "2"}], "]"}]}], "}"}], "//", "DisplayForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LabelJP", "::", "\<\"invalidparity\"\>"}], ":", 
  " ", "\<\"Parity must be +1, -1, or None.\"\>"}]], "Message"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    SubsuperscriptBox["2", "1", "-"], ",", 
    RowBox[{
     SubsuperscriptBox["2", "1", ","], 
     SubsuperscriptBox["2", "1", ","], 
     SubsuperscriptBox[
      FractionBox["1", "2"], "1", "+"]}], ",", 
    SuperscriptBox[
     FractionBox["1", "2"], "+"]}], "}"}],
  DisplayForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Row box structure -- DEPRECATED", "Subsection",
 CellChangeTimes->{{3.461092194671875*^9, 3.461092197015625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TightRowBox", "::", "deprecated"}], "=", 
   "\"\<TightRowBox is deprecated in favor of Row (for Mathematica 6 and \
above).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TightRowBox", "[", "Row_List", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{"TightRowBox", "::", "deprecated"}], "]"}], ";", 
     RowBox[{"GridBox", "[", 
      RowBox[{
       RowBox[{"{", "Row", "}"}], ",", 
       RowBox[{"ColumnSpacings", "\[Rule]", "0"}]}], "]"}]}], ")"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.461092058515625*^9, 3.461092073234375*^9}, {
  3.461092105734375*^9, 3.4610921216875*^9}, {3.46109217778125*^9, 
  3.461092184578125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multiplet", "Subsection",
 CellChangeTimes->{{3.461092203296875*^9, 3.46109220475*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "MultipletLabel", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EntrySeparator", "\[Rule]", "\"\<,\>\""}], ",", 
     RowBox[{"Delimiter", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<(\>\"", ",", "\"\<)\>\""}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultipletLabel", "[", 
    RowBox[{"Values_List", ",", 
     RowBox[{"Opts", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"DeducedEntrySeparator", ",", "DeducedDelimiter"}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"DeducedDelimiter", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"OptionValue", "[", "Delimiter", "]"}], ",", 
         "\[IndentingNewLine]", "None", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<\>\"", ",", "\"\<\>\""}], "}"}], ",", 
         "\[IndentingNewLine]", "_", ",", 
         RowBox[{"OptionValue", "[", "Delimiter", "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DeducedEntrySeparator", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"OptionValue", "[", "EntrySeparator", "]"}], ",", 
         "\[IndentingNewLine]", "None", ",", "\"\<\>\"", ",", 
         "\[IndentingNewLine]", "_", ",", 
         RowBox[{"OptionValue", "[", "EntrySeparator", "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"DeducedDelimiter", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", 
         RowBox[{"Riffle", "[", 
          RowBox[{"Values", ",", "DeducedEntrySeparator"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"DeducedDelimiter", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.461092214125*^9, 3.461092289390625*^9}, {
   3.46109239584375*^9, 3.461092445609375*^9}, {3.461093160296875*^9, 
   3.461093251765625*^9}, {3.461093431796875*^9, 3.461093505640625*^9}, {
   3.461093635796875*^9, 3.461093661828125*^9}, 3.461093809390625*^9, {
   3.461101489453125*^9, 3.461101537515625*^9}, {3.46110159278125*^9, 
   3.4611016504375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MultipletLabel", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MultipletLabel", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"Delimiter", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<[\>\"", ",", "\"\<]\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"MultipletLabel", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"EntrySeparator", "\[Rule]", "None"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"MultipletLabel", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"EntrySeparator", "\[Rule]", "None"}], ",", 
   RowBox[{"Delimiter", "\[Rule]", "None"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.46109381090625*^9, 3.461093868421875*^9}, {
  3.461101659671875*^9, 3.461101664515625*^9}}],

Cell[BoxData[
 TemplateBox[{"\"(\"","1","\",\"","2","\",\"","3","\")\""},
  "Row",
  DisplayFunction->(
   RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
     "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
     "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
       "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.46109382121875*^9, 3.461093868734375*^9}, {
  3.461101654921875*^9, 3.461101664796875*^9}}],

Cell[BoxData[
 TemplateBox[{"\"[\"","1","\",\"","2","\",\"","3","\"]\""},
  "Row",
  DisplayFunction->(
   RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
     "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
     "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
       "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.46109382121875*^9, 3.461093868734375*^9}, {
  3.461101654921875*^9, 3.461101664828125*^9}}],

Cell[BoxData[
 TemplateBox[{"\"(\"","1","\"\"","2","\"\"","3","\")\""},
  "Row",
  DisplayFunction->(
   RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
     "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
     "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
       "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.46109382121875*^9, 3.461093868734375*^9}, {
  3.461101654921875*^9, 3.461101664875*^9}}],

Cell[BoxData[
 TemplateBox[{"\"\"","1","\"\"","2","\"\"","3","\"\""},
  "Row",
  DisplayFunction->(
   RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
     "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
     "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ),
  InterpretationFunction->(RowBox[{"Row", "[", 
     RowBox[{"{", 
       RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
       "}"}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.46109382121875*^9, 3.461093868734375*^9}, {
  3.461101654921875*^9, 3.461101664921875*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fraction formatting", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Options", "[", "GridBox", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Options", "[", "RowBox", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GridBaseline", "\[Rule]", "Axis"}], ",", 
   RowBox[{"RowSpacings", "\[Rule]", "1.`"}], ",", 
   RowBox[{"ColumnSpacings", "\[Rule]", "0.800000011920929`"}], ",", 
   RowBox[{"ColumnWidths", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"RowAlignments", "\[Rule]", "Baseline"}], ",", 
   RowBox[{"ColumnAlignments", "\[Rule]", 
    RowBox[{"{", "Center", "}"}]}], ",", 
   RowBox[{"GridFrame", "\[Rule]", "False"}], ",", 
   RowBox[{"GridFrameMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.4000000059604645`", ",", "0.4000000059604645`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.5`", ",", "0.5`"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"RowLines", "\[Rule]", "False"}], ",", 
   RowBox[{"ColumnLines", "\[Rule]", "False"}], ",", 
   RowBox[{"RowMinHeight", "\[Rule]", "1.`"}], ",", 
   RowBox[{"RowsEqual", "\[Rule]", "False"}], ",", 
   RowBox[{"ColumnsEqual", "\[Rule]", "False"}], ",", 
   RowBox[{"AutoDelete", "\[Rule]", "True"}], ",", 
   RowBox[{"AllowScriptLevelChange", "\[Rule]", "True"}], ",", 
   RowBox[{"MultilineFunction", "\[Rule]", "None"}], ",", 
   RowBox[{
   "GridDefaultElement", "\[RuleDelayed]", "\<\"\[Placeholder]\"\>"}]}], 
  "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Notes on formatting in fraction constructs:
\tApplying DisplayForm to inidividual fraction elements is required for \
quantities deep within (like Pi) to be displayed correctly even if full \
fraction is displayed in DisplayForm.
\tRowBox seems to give most generous default spacing, which cannot be \
adjusted.  Applying DisplayForm to individual list elements makes this worse, \
but apparently only for RowBox.   Therefore, GridBox is preferred.\
\>", "Text"],

Cell["Fractionize", "Text"],

Cell[TextData[{
 "SolidusFractionBox\n\tHas mediocre spacing due to use of RowBox.\n\t\
DisplayForm ",
 StyleBox["inside",
  FontSlant->"Italic"],
 " RowBox is needed to ensure Pi appears as \[Pi]."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SolidusFractionBox", "[", 
    RowBox[{"x_", ",", "y_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"GridBox", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DisplayForm", "[", "x", "]"}], ",", "\"\</\>\"", ",", 
        RowBox[{"DisplayForm", "[", "y", "]"}]}], "}"}], "}"}], ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", 
      RowBox[{"-", "0.1"}]}], ",", 
     RowBox[{"GridBaseline", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Baseline", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True],

Cell["\<\
DiagonalFractionBox

\tImposing slant on slash seems to have no effect.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ColumnSpacings", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.1"}], " ", "worked", " ", "well", " ", "for", " ", 
      "Mathematica", " ", "5", " ", 
      RowBox[{"(", 
       RowBox[{"with", " ", "Times"}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "ColumnSpacings"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.5"}], " ", "needed", " ", "for", " ", "Mathematica", 
      " ", "6."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "DiagonalFractionBox", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ColumnSpacings", "\[Rule]", 
        RowBox[{"-", "0.1"}]}], ",", 
       RowBox[{"Baseline", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.3", ",", "0.0"}], "}"}]}], ",", 
       RowBox[{"KernForSuperscript", "\[Rule]", 
        RowBox[{"-", "0.15"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DiagonalFractionBox", "[", 
      RowBox[{"x_", ",", "y_", ",", 
       RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"FullOpts", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"Opts", ",", 
            RowBox[{"Options", "[", "DiagonalFractionBox", "]"}]}], "}"}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"TagBox", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"StyleBox", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"GridBox", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"AdjustmentBox", "[", 
                 RowBox[{
                  RowBox[{"SubscriptBox", "[", 
                   RowBox[{"\"\<\>\"", ",", 
                    RowBox[{"DisplayForm", "[", "x", "]"}]}], "]"}], ",", 
                  RowBox[{"BoxBaselineShift", "\[Rule]", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"Baseline", "/.", "FullOpts"}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ")"}]}]}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"AdjustmentBox", "[", 
                 RowBox[{
                  RowBox[{"SubscriptBox", "[", 
                   RowBox[{"\"\<\>\"", ",", 
                    RowBox[{"StyleForm", "[", 
                    RowBox[{"\"\</\>\"", ",", 
                    RowBox[{"FontSlant", "->", "\"\<Oblique\>\""}]}], "]"}]}],
                    "]"}], ",", 
                  RowBox[{"BoxBaselineShift", "\[Rule]", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"Baseline", "/.", "FullOpts"}], ")"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ")"}]}]}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"AdjustmentBox", "[", 
                 RowBox[{
                  RowBox[{"SubscriptBox", "[", 
                   RowBox[{"\"\<\>\"", ",", 
                    RowBox[{"DisplayForm", "[", "y", "]"}]}], "]"}], ",", 
                  RowBox[{"BoxBaselineShift", "\[Rule]", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"Baseline", "/.", "FullOpts"}], ")"}], "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ")"}]}]}]}], "]"}]}], 
               "\[IndentingNewLine]", "}"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColumnSpacings", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{"ColumnSpacings", "/.", "FullOpts"}], ")"}]}], ",", 
             RowBox[{"GridBaseline", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Bottom", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}]}], 
            "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"ScriptBaselineShifts", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}]}], "\[IndentingNewLine]", "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"DiagonalFractionBox", "[", 
          RowBox[{"(", 
           RowBox[{"KernForSuperscript", "/.", "FullOpts"}], ")"}], "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.427840928265625*^9, 3.4278409818125*^9}, 
   3.427918133203125*^9}],

Cell["DiagonalFractionBox kerning setup", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "TagBox", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TagBox", "/:", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"TagBox", "[", 
       RowBox[{"_", ",", 
        RowBox[{"DiagonalFractionBox", "[", "Adjustment_", "]"}]}], "]"}]}], 
     ",", "n_"}], "]"}], ":=", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{
     RowBox[{"AdjustmentBox", "[", 
      RowBox[{"x", ",", 
       RowBox[{"BoxMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "Adjustment"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}], ",", "n"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "TagBox", "]"}], ";"}]}], "Input",
 InitializationCell->True],

Cell["Fractionization functions", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Fractionize", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "==", "1"}], ")"}]}], ":=", 
   RowBox[{"DisplayForm", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Fractionize", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "!=", "1"}], ")"}]}], ":=", 
   RowBox[{"FractionBox", "[", 
    RowBox[{
     RowBox[{"Numerator", "[", "x", "]"}], ",", 
     RowBox[{"Denominator", "[", "x", "]"}], ",", "Opts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", ":", 
    RowBox[{"Fractionize", "[", 
     RowBox[{"x_List", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}]}], ":=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Unevaluated", "[", "f", "]"}], ",", "List", ",", "1"}], "]"}]}],
   ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SolidusFractionize", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "==", "1"}], ")"}]}], ":=", 
   RowBox[{"DisplayForm", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SolidusFractionize", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "!=", "1"}], ")"}]}], ":=", 
   RowBox[{"SolidusFractionBox", "[", 
    RowBox[{
     RowBox[{"Numerator", "[", "x", "]"}], ",", 
     RowBox[{"Denominator", "[", "x", "]"}], ",", "Opts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", ":", 
    RowBox[{"SolidusFractionize", "[", 
     RowBox[{"x_List", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}]}], ":=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Unevaluated", "[", "f", "]"}], ",", "List", ",", "1"}], "]"}]}],
   ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DiagonalFractionize", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "==", "1"}], ")"}]}], ":=", 
   RowBox[{"DisplayForm", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DiagonalFractionize", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "!=", "1"}], ")"}]}], ":=", 
   RowBox[{"DiagonalFractionBox", "[", 
    RowBox[{
     RowBox[{"Numerator", "[", "x", "]"}], ",", 
     RowBox[{"Denominator", "[", "x", "]"}], ",", "Opts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", ":", 
    RowBox[{"DiagonalFractionize", "[", 
     RowBox[{"x_List", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}]}], ":=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Unevaluated", "[", "f", "]"}], ",", "List", ",", "1"}], "]"}]}],
   ";"}]}], "Input",
 InitializationCell->True],

Cell["Tests of fractionization", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<xxxx,\>\"", ",", 
     RowBox[{"SolidusFractionBox", "[", 
      RowBox[{"1", "/", "2"}], "]"}], ",", "\"\<,\>\"", ",", 
     RowBox[{"SolidusFractionBox", "[", "Pi", "]"}], ",", "\"\<xxx\>\""}], 
    "}"}], "]"}], "//", "DisplayForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SolidusFractionBox", "[", 
      RowBox[{
       RowBox[{"Rationalize", "[", 
        RowBox[{"#", "/", "Pi"}], "]"}], "*", "Pi"}], "]"}], "&"}], ")"}], "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Pi", "/", "2"}], ",", 
     RowBox[{"3", "*", "Pi"}]}], "}"}]}], "//", 
  "DisplayForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SolidusFractionize", "[", 
   RowBox[{"1", "/", "2"}], "]"}], "//", "DisplayForm"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   RowBox[{"xxxx", ","}], GridBox[{
     {
      TagBox["1",
       DisplayForm], "/", 
      TagBox["2",
       DisplayForm]}
    },
    BaselinePosition->{Baseline, {1, 3}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[-0.06999999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], ",", 
   TagBox["\[Pi]",
    DisplayForm], "xxx"}],
  DisplayForm]], "Output"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{GridBox[{
      {
       TagBox["\[Pi]",
        DisplayForm], "/", 
       TagBox["2",
        DisplayForm]}
     },
     BaselinePosition->{Baseline, {1, 3}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[-0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ",", 
    TagBox[
     RowBox[{"3", " ", "\[Pi]"}],
     DisplayForm]}], "}"}],
  DisplayForm]], "Output"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox["1",
      DisplayForm], "/", 
     TagBox["2",
      DisplayForm]}
   },
   BaselinePosition->{Baseline, {1, 3}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[-0.06999999999999999]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  DisplayForm]], "Output"]
}, Open  ]],

Cell["\tOld RowBox formatting, for comparison", "Text"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox["\[Pi]",
      DisplayForm], 
     TagBox["\<\"/\"\>",
      DisplayForm], 
     TagBox["2",
      DisplayForm]}], ",", 
    TagBox[
     RowBox[{"3", " ", "\[Pi]"}],
     DisplayForm]}], "}"}],
  DisplayForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False],

Cell["\tDiagonal fraction option optimization", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DiagonalFractionBox", ",", 
    RowBox[{"ColumnSpacings", "\[Rule]", 
     RowBox[{"-", "0.1"}]}], ",", 
    RowBox[{"Baseline", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.3", ",", "0.0"}], "}"}]}]}], "]"}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"textfamily", "[", 
   RowBox[{"\"\<Times New Roman\>\"", ",", 
    RowBox[{"textsize", "[", 
     RowBox[{"20", ",", "\[IndentingNewLine]", 
      RowBox[{"TightRowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<xxxx11,\>\"", ",", 
         RowBox[{"DiagonalFractionize", "[", 
          RowBox[{"1", "/", "2"}], "]"}], ",", "\"\<,\>\"", ",", 
         RowBox[{"textfamily", "[", 
          RowBox[{"Times", ",", 
           RowBox[{"DiagonalFractionize", "[", 
            RowBox[{"1", "/", "2"}], "]"}]}], "]"}], ",", "\"\<,\>\"", ",", 
         RowBox[{"DiagonalFractionize", "[", "Pi", "]"}], ",", "\"\<,\>\"", 
         ",", 
         RowBox[{"DiagonalFractionize", "[", 
          RowBox[{"Pi", "/", "2"}], "]"}], ",", "\"\<,\>\"", ",", 
         RowBox[{"DiagonalFractionize", "[", 
          RowBox[{"3", "*", 
           RowBox[{"Pi", "/", "2"}]}], "]"}], ",", "\"\<xxx\>\""}], "}"}], 
       "]"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], "//", 
  "DisplayForm"}]], "Input"],

Cell["-0.1 {0.5,0.3,0.0}", "Text"],

Cell[BoxData[
 TagBox[
  TagBox[
   StyleBox[
    TagBox[
     StyleBox[GridBox[{
        {
         RowBox[{"xxxx11", ","}], 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["1",
                DisplayForm]],
              BoxBaselineShift->-0.5], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.06999999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         TagBox[
          StyleBox[GridBox[{
             {
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["1",
                 DisplayForm]],
               BoxBaselineShift->-0.5], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox[
                 StyleBox["\<\"/\"\>",
                  FontSlant->"Oblique"],
                 StyleForm[#, FontSlant -> "Oblique"]& ]],
               BoxBaselineShift->-0.3], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["2",
                 DisplayForm]],
               BoxBaselineShift->0]}
            },
            BaselinePosition->{Bottom, {1, 3}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[-0.06999999999999999]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ScriptBaselineShifts->{0, 0},
           FontFamily->"Times"],
          StyleForm[#, FontFamily -> Times]& ], ",", 
         TagBox["\[Pi]",
          DisplayForm], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["\[Pi]",
                DisplayForm]],
              BoxBaselineShift->-0.5], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.06999999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                RowBox[{"3", " ", "\[Pi]"}],
                DisplayForm]],
              BoxBaselineShift->-0.5], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.06999999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], "xxx"}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      FontSize->20],
     StyleForm[#, FontSize -> 20]& ],
    FontFamily->"Times New Roman"],
   StyleForm[#, FontFamily -> "Times New Roman"]& ],
  DisplayForm]], "Output"],

Cell["-0.1 {0.6,0.3,0.0}", "Text"],

Cell[BoxData[
 TagBox[
  TagBox[
   StyleBox[
    TagBox[
     StyleBox[GridBox[{
        {
         RowBox[{"xxxx11", ","}], 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["1",
                DisplayForm]],
              BoxBaselineShift->-0.6], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.06999999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         TagBox[
          StyleBox[GridBox[{
             {
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["1",
                 DisplayForm]],
               BoxBaselineShift->-0.6], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox[
                 StyleBox["\<\"/\"\>",
                  FontSlant->"Oblique"],
                 StyleForm[#, FontSlant -> "Oblique"]& ]],
               BoxBaselineShift->-0.3], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["2",
                 DisplayForm]],
               BoxBaselineShift->0]}
            },
            BaselinePosition->{Bottom, {1, 3}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[-0.06999999999999999]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ScriptBaselineShifts->{0, 0},
           FontFamily->"Times"],
          StyleForm[#, FontFamily -> Times]& ], ",", 
         TagBox["\[Pi]",
          DisplayForm], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["\[Pi]",
                DisplayForm]],
              BoxBaselineShift->-0.6], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.06999999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                RowBox[{"3", " ", "\[Pi]"}],
                DisplayForm]],
              BoxBaselineShift->-0.6], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.06999999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], "xxx"}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      FontSize->20],
     StyleForm[#, FontSize -> 20]& ],
    FontFamily->"Times New Roman"],
   StyleForm[#, FontFamily -> "Times New Roman"]& ],
  DisplayForm]], "Output"],

Cell["-0.2 {0.6,0.3,0.0}", "Text"],

Cell[BoxData[
 TagBox[
  TagBox[
   StyleBox[
    TagBox[
     StyleBox[GridBox[{
        {
         RowBox[{"xxxx11", ","}], 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["1",
                DisplayForm]],
              BoxBaselineShift->-0.6], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         TagBox[
          StyleBox[GridBox[{
             {
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["1",
                 DisplayForm]],
               BoxBaselineShift->-0.6], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox[
                 StyleBox["\<\"/\"\>",
                  FontSlant->"Oblique"],
                 StyleForm[#, FontSlant -> "Oblique"]& ]],
               BoxBaselineShift->-0.3], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["2",
                 DisplayForm]],
               BoxBaselineShift->0]}
            },
            BaselinePosition->{Bottom, {1, 3}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[-0.13999999999999999`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ScriptBaselineShifts->{0, 0},
           FontFamily->"Times"],
          StyleForm[#, FontFamily -> Times]& ], ",", 
         TagBox["\[Pi]",
          DisplayForm], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["\[Pi]",
                DisplayForm]],
              BoxBaselineShift->-0.6], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                RowBox[{"3", " ", "\[Pi]"}],
                DisplayForm]],
              BoxBaselineShift->-0.6], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], "xxx"}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      FontSize->20],
     StyleForm[#, FontSize -> 20]& ],
    FontFamily->"Times New Roman"],
   StyleForm[#, FontFamily -> "Times New Roman"]& ],
  DisplayForm]], "Output"],

Cell["-0.2 {0.8,0.4,0.0}", "Text"],

Cell[BoxData[
 TagBox[
  TagBox[
   StyleBox[
    TagBox[
     StyleBox[GridBox[{
        {
         RowBox[{"xxxx11", ","}], 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["1",
                DisplayForm]],
              BoxBaselineShift->-0.8], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.4], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         TagBox[
          StyleBox[GridBox[{
             {
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["1",
                 DisplayForm]],
               BoxBaselineShift->-0.8], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox[
                 StyleBox["\<\"/\"\>",
                  FontSlant->"Oblique"],
                 StyleForm[#, FontSlant -> "Oblique"]& ]],
               BoxBaselineShift->-0.4], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["2",
                 DisplayForm]],
               BoxBaselineShift->0]}
            },
            BaselinePosition->{Bottom, {1, 3}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[-0.13999999999999999`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ScriptBaselineShifts->{0, 0},
           FontFamily->"Times"],
          StyleForm[#, FontFamily -> Times]& ], ",", 
         TagBox["\[Pi]",
          DisplayForm], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["\[Pi]",
                DisplayForm]],
              BoxBaselineShift->-0.8], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.4], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                RowBox[{"3", " ", "\[Pi]"}],
                DisplayForm]],
              BoxBaselineShift->-0.8], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.4], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], "xxx"}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      FontSize->20],
     StyleForm[#, FontSize -> 20]& ],
    FontFamily->"Times New Roman"],
   StyleForm[#, FontFamily -> "Times New Roman"]& ],
  DisplayForm]], "Output"],

Cell["-0.2 {0.9,0.5,0.0}", "Text"],

Cell[BoxData[
 TagBox[
  TagBox[
   StyleBox[
    TagBox[
     StyleBox[GridBox[{
        {
         RowBox[{"xxxx11", ","}], 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["1",
                DisplayForm]],
              BoxBaselineShift->-0.9], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.5], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         TagBox[
          StyleBox[GridBox[{
             {
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["1",
                 DisplayForm]],
               BoxBaselineShift->-0.9], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox[
                 StyleBox["\<\"/\"\>",
                  FontSlant->"Oblique"],
                 StyleForm[#, FontSlant -> "Oblique"]& ]],
               BoxBaselineShift->-0.5], 
              AdjustmentBox[
               SubscriptBox["", 
                TagBox["2",
                 DisplayForm]],
               BoxBaselineShift->0]}
            },
            BaselinePosition->{Bottom, {1, 3}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[-0.13999999999999999`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ScriptBaselineShifts->{0, 0},
           FontFamily->"Times"],
          StyleForm[#, FontFamily -> Times]& ], ",", 
         TagBox["\[Pi]",
          DisplayForm], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["\[Pi]",
                DisplayForm]],
              BoxBaselineShift->-0.9], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.5], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], ",", 
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                RowBox[{"3", " ", "\[Pi]"}],
                DisplayForm]],
              BoxBaselineShift->-0.9], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.5], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.13999999999999999`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}], "xxx"}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      FontSize->20],
     StyleForm[#, FontSize -> 20]& ],
    FontFamily->"Times New Roman"],
   StyleForm[#, FontFamily -> "Times New Roman"]& ],
  DisplayForm]], "Output"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<xxxx11,\>\"", ",", 
     RowBox[{"DiagonalFractionBox", "[", 
      RowBox[{"1", "/", "2"}], "]"}], ",", "\"\<,\>\"", ",", 
     RowBox[{"textfamily", "[", 
      RowBox[{"Times", ",", 
       RowBox[{"DiagonalFractionBox", "[", 
        RowBox[{"1", "/", "2"}], "]"}]}], "]"}], ",", "\"\<,\>\"", ",", 
     RowBox[{"DiagonalFractionBox", "[", "Pi", "]"}], ",", "\"\<,\>\"", ",", 
     RowBox[{"DiagonalFractionBox", "[", 
      RowBox[{"Pi", "/", "2"}], "]"}], ",", "\"\<,\>\"", ",", 
     RowBox[{"DiagonalFractionBox", "[", 
      RowBox[{"3", "*", 
       RowBox[{"Pi", "/", "2"}]}], "]"}], ",", "\"\<xxx\>\""}], "}"}], "]"}], 
  "//", "DisplayForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   RowBox[{"xxxx11", ","}], 
   StyleBox[GridBox[{
      {
       AdjustmentBox[
        SubscriptBox["", 
         TagBox["1",
          DisplayForm]],
        BoxBaselineShift->-0.9], 
       AdjustmentBox[
        SubscriptBox["", 
         StyleBox["/",
          FontSlant->"Oblique"]],
        BoxBaselineShift->-0.5], 
       SubscriptBox["", 
        TagBox["2",
         DisplayForm]]}
     },
     BaselinePosition->{Bottom, {1, 3}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[-0.13999999999999999`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ScriptBaselineShifts->{0, 0}], ",", 
   TagBox[
    StyleBox[GridBox[{
       {
        AdjustmentBox[
         SubscriptBox["", 
          TagBox["1",
           DisplayForm]],
         BoxBaselineShift->-0.9], 
        AdjustmentBox[
         SubscriptBox["", 
          StyleBox["/",
           FontSlant->"Oblique"]],
         BoxBaselineShift->-0.5], 
        SubscriptBox["", 
         TagBox["2",
          DisplayForm]]}
      },
      BaselinePosition->{Bottom, {1, 3}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[-0.13999999999999999`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ScriptBaselineShifts->{0, 0},
     FontFamily->"Times"],
    StyleForm[#, FontFamily -> Times]& ], ",", 
   TagBox["\[Pi]",
    DisplayForm], ",", 
   StyleBox[GridBox[{
      {
       AdjustmentBox[
        SubscriptBox["", 
         TagBox["\[Pi]",
          DisplayForm]],
        BoxBaselineShift->-0.9], 
       AdjustmentBox[
        SubscriptBox["", 
         StyleBox["/",
          FontSlant->"Oblique"]],
        BoxBaselineShift->-0.5], 
       SubscriptBox["", 
        TagBox["2",
         DisplayForm]]}
     },
     BaselinePosition->{Bottom, {1, 3}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[-0.13999999999999999`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ScriptBaselineShifts->{0, 0}], ",", 
   StyleBox[GridBox[{
      {
       AdjustmentBox[
        SubscriptBox["", 
         TagBox[
          RowBox[{"3", " ", "\[Pi]"}],
          DisplayForm]],
        BoxBaselineShift->-0.9], 
       AdjustmentBox[
        SubscriptBox["", 
         StyleBox["/",
          FontSlant->"Oblique"]],
        BoxBaselineShift->-0.5], 
       SubscriptBox["", 
        TagBox["2",
         DisplayForm]]}
     },
     BaselinePosition->{Bottom, {1, 3}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[-0.13999999999999999`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ScriptBaselineShifts->{0, 0}], "xxx"}],
  DisplayForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DiagonalFractionize", "[", 
   RowBox[{"1", "/", "2"}], "]"}], "//", 
  "FullForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"textfamily", "[", 
   RowBox[{"\"\<Times New Roman\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SuperscriptBox", "[", 
       RowBox[{
        RowBox[{"DiagonalFractionize", "[", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", 
          RowBox[{"KernForSuperscript", "\[Rule]", "0"}]}], "]"}], ",", 
        "\"\<+\>\""}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"SuperscriptBox", "[", 
       RowBox[{
        RowBox[{"DiagonalFractionize", "[", 
         RowBox[{"1", "/", "2"}], "]"}], ",", "\"\<+\>\""}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SubsuperscriptBox", "[", 
       RowBox[{
        RowBox[{"DiagonalFractionize", "[", 
         RowBox[{"1", "/", "2"}], "]"}], ",", "\"\<0\>\"", ",", "\"\<+\>\""}],
        "]"}]}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}],
   "//", "DisplayForm"}]}], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"StyleBox", "[", 
      RowBox[{
       RowBox[{"GridBox", "[", 
        RowBox[{
         RowBox[{"List", "[", 
          RowBox[{"List", "[", 
           RowBox[{
            RowBox[{"AdjustmentBox", "[", 
             RowBox[{
              RowBox[{"SubscriptBox", "[", 
               RowBox[{"\"\<\>\"", ",", 
                RowBox[{"DisplayForm", "[", "1", "]"}]}], "]"}], ",", 
              RowBox[{"Rule", "[", 
               RowBox[{"BoxBaselineShift", ",", 
                RowBox[{"-", "0.5`"}]}], "]"}]}], "]"}], ",", 
            RowBox[{"AdjustmentBox", "[", 
             RowBox[{
              RowBox[{"SubscriptBox", "[", 
               RowBox[{"\"\<\>\"", ",", 
                RowBox[{"StyleForm", "[", 
                 RowBox[{"\"\</\>\"", ",", 
                  RowBox[{"Rule", "[", 
                   RowBox[{"FontSlant", ",", "\"\<Oblique\>\""}], "]"}]}], 
                 "]"}]}], "]"}], ",", 
              RowBox[{"Rule", "[", 
               RowBox[{"BoxBaselineShift", ",", 
                RowBox[{"-", "0.3`"}]}], "]"}]}], "]"}], ",", 
            RowBox[{"AdjustmentBox", "[", 
             RowBox[{
              RowBox[{"SubscriptBox", "[", 
               RowBox[{"\"\<\>\"", ",", 
                RowBox[{"DisplayForm", "[", "2", "]"}]}], "]"}], ",", 
              RowBox[{"Rule", "[", 
               RowBox[{"BoxBaselineShift", ",", "0.`"}], "]"}]}], "]"}]}], 
           "]"}], "]"}], ",", 
         RowBox[{"Rule", "[", 
          RowBox[{"ColumnSpacings", ",", 
           RowBox[{"-", "0.1`"}]}], "]"}], ",", 
         RowBox[{"Rule", "[", 
          RowBox[{"GridBaseline", ",", 
           RowBox[{"List", "[", 
            RowBox[{"Bottom", ",", 
             RowBox[{"List", "[", 
              RowBox[{"1", ",", "3"}], "]"}]}], "]"}]}], "]"}]}], "]"}], ",", 
       
       RowBox[{"Rule", "[", 
        RowBox[{"ScriptBaselineShifts", ",", 
         RowBox[{"List", "[", 
          RowBox[{"0", ",", "0"}], "]"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"DiagonalFractionBox", "[", 
      RowBox[{"-", "0.15`"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output"],

Cell[BoxData[
 TagBox[
  TagBox[
   StyleBox[
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox[
       AdjustmentBox[
        TagBox[
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["1",
                DisplayForm]],
              BoxBaselineShift->-0.5], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.06999999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}],
         DiagonalFractionBox[0]],
        BoxMargins->{{0, 0}, {0, 0}}], "+"], ",", 
      SuperscriptBox[
       AdjustmentBox[
        TagBox[
         StyleBox[GridBox[{
            {
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["1",
                DisplayForm]],
              BoxBaselineShift->-0.5], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox[
                StyleBox["\<\"/\"\>",
                 FontSlant->"Oblique"],
                StyleForm[#, FontSlant -> "Oblique"]& ]],
              BoxBaselineShift->-0.3], 
             AdjustmentBox[
              SubscriptBox["", 
               TagBox["2",
                DisplayForm]],
              BoxBaselineShift->0]}
           },
           BaselinePosition->{Bottom, {1, 3}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[-0.06999999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ScriptBaselineShifts->{0, 0}],
         DiagonalFractionBox[-0.15]],
        BoxMargins->{{0, -0.15}, {0, 0}}], "+"], ",", 
      SubsuperscriptBox[
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["2",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], "0", "+"]}], "}"}],
    FontFamily->"Times New Roman"],
   StyleForm[#, FontFamily -> "Times New Roman"]& ],
  DisplayForm]], "Output"]
}, Open  ]],

Cell["\<\
Brute force listability by Listable attribute causes unwanted threading over \
option lists....\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagonalFractionize", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2"}], ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2"}], ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DiagonalFractionize", "[", 
    RowBox[{"a", ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2`"}]}], "]"}], ",", 
   RowBox[{"DiagonalFractionize", "[", 
    RowBox[{"a", ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2`"}]}], "]"}], ",", 
   RowBox[{"DiagonalFractionize", "[", 
    RowBox[{"a", ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2`"}]}], "]"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["\<\
So instead explicitly force listability over first argument with rule...\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagonalFractionize", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2"}], ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2"}], ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"DiagonalFractionize", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2`"}], ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2`"}], ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0.2`"}]}], "}"}]}], 
  "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalFractionize", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"i", "*", "j"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}], "//", "MatrixForm"}], "//",
   "DisplayForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       TagBox["1",
        DisplayForm], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["2",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["3",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["4",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["5",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]]},
      {
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["2",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["4",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["6",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["8",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["10",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]]},
      {
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["3",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["6",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["9",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["12",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["15",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]]},
      {
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["4",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["8",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["12",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["16",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["20",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]]},
      {
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["5",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["10",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["15",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["20",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]], 
       TagBox[
        StyleBox[GridBox[{
           {
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["1",
               DisplayForm]],
             BoxBaselineShift->-0.5], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox[
               StyleBox["\<\"/\"\>",
                FontSlant->"Oblique"],
               StyleForm[#, FontSlant -> "Oblique"]& ]],
             BoxBaselineShift->-0.3], 
            AdjustmentBox[
             SubscriptBox["", 
              TagBox["25",
               DisplayForm]],
             BoxBaselineShift->0]}
          },
          BaselinePosition->{Bottom, {1, 3}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[-0.06999999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ScriptBaselineShifts->{0, 0}],
        DiagonalFractionBox[-0.15]]}
     }], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  DisplayForm]], "Output"]
}, Open  ]],

Cell["FractionString", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FractionString", "[", 
    RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "NumeratorString", ",", "DenominatorString"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"Rationalize", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"NumeratorString", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Numerator", "[", "f", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DenominatorString", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Denominator", "[", "f", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"f", "\[Equal]", "0"}], ",", "\"\<0\>\"", ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Denominator", "[", "f", "]"}], "\[Equal]", "1"}], ",", 
        RowBox[{"StringJoin", "[", "NumeratorString", "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Denominator", "[", "f", "]"}], "!=", "1"}], ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
         "NumeratorString", ",", "\"\</\>\"", ",", "DenominatorString"}], 
         "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["PiFractionString", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PiFractionString", "[", 
    RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "NumeratorString", ",", "DenominatorString"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"Rationalize", "[", 
        RowBox[{"x", "/", "Pi"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"NumeratorString", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Numerator", "[", "f", "]"}], "\[Equal]", "1"}], ",", 
         "\[IndentingNewLine]", "\"\<\>\"", ",", "\[IndentingNewLine]", 
         RowBox[{"ToString", "[", 
          RowBox[{"Numerator", "[", "f", "]"}], "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DenominatorString", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Denominator", "[", "f", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Which", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"f", "\[Equal]", "0"}], ",", "\"\<0\>\"", ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Denominator", "[", "f", "]"}], "\[Equal]", "1"}], ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"NumeratorString", ",", "\"\<\[Pi]\>\""}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Denominator", "[", "f", "]"}], "!=", "1"}], ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
         "NumeratorString", ",", "\"\<\[Pi]\>\"", ",", "\"\</\>\"", ",", 
          "DenominatorString"}], "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PiFractionString", "[", 
  RowBox[{"0", "*", "Pi"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PiFractionString", "[", 
  RowBox[{"1", "*", 
   RowBox[{"Pi", "/", "2"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PiFractionString", "[", 
  RowBox[{"2", "*", "Pi"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PiFractionString", "[", 
  RowBox[{"2", "*", 
   RowBox[{"Pi", "/", "3"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PiFractionString", "[", 
  RowBox[{"2", "*", "E", "*", 
   RowBox[{"Pi", "/", "3"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PiFractionString", "[", "3.9", "]"}]}], "Input"],

Cell[BoxData["\<\"0\"\>"], "Output"],

Cell[BoxData["\<\"\[Pi]/2\"\>"], "Output"],

Cell[BoxData["\<\"2\[Pi]\"\>"], "Output"],

Cell[BoxData["\<\"2\[Pi]/3\"\>"], "Output"],

Cell[BoxData["\<\"2 E\[Pi]/3\"\>"], "Output"],

Cell[BoxData["\<\"1.24141\[Pi]\"\>"], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sign character", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SignString", "[", 
    RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"Switch", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Sign", "[", "x", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"+", "1"}], ",", "\"\<+\>\"", ",", "\[IndentingNewLine]", "0", 
     ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"-", "1"}], ",", "\"\<-\>\""}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Formatting of root-containing quantities entirely under radical\
\>", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"Sqrtize", ",", "Listable"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sqrtize", "[", 
    RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"RationalQ", "[", "x", "]"}], ",", "x", ","}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"RationalQ", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{
      RowBox[{"Sign", "[", "x", "]"}], "*", 
      RowBox[{"SqrtBox", "[", 
       RowBox[{"x", "^", "2"}], "]"}]}], ",", "\[IndentingNewLine]", "True", 
     ",", "x"}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"Radicalize", ",", "Listable"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Radicalize", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], ",", "n_Integer"}], "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"RationalQ", "[", "x", "]"}], ",", "x", ","}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"RationalQ", "[", 
      RowBox[{"x", "^", "n"}], "]"}], ",", 
     RowBox[{
      RowBox[{"Sign", "[", "x", "]"}], "*", 
      RowBox[{"RadicalBox", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"x", "^", "n"}], "]"}], ",", "n"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "True", ",", "x"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RationalQ", "[", "x_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"IntegerQ", "[", "x", "]"}], "||", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Head", "[", "x", "]"}], "===", "Rational"}], ")"}]}], ")"}]}],
   ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RationalQ", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"RationalQ", "[", 
  RowBox[{"1", "/", "5"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"RationalQ", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "/", "5"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"RationalQ", "[", 
  RowBox[{"Sqrt", "[", "5", "]"}], "]"}]}], "Input"],

Cell[BoxData["True"], "Output"],

Cell[BoxData["True"], "Output"],

Cell[BoxData["True"], "Output"],

Cell[BoxData["False"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Sqrtize", "[", "1", "]"}], "//", 
  "DisplayForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sqrtize", "[", 
   RowBox[{"1", "/", "5"}], "]"}], "//", 
  "DisplayForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sqrtize", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], "/", "2"}], "]"}], "//", 
  "DisplayForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sqrtize", "[", "Pi", "]"}], "//", "DisplayForm"}]}], "Input"],

Cell[BoxData[
 TagBox[
  SqrtBox["1"],
  DisplayForm]], "Output"],

Cell[BoxData[
 TagBox[
  SqrtBox[
   FractionBox["1", "25"]],
  DisplayForm]], "Output"],

Cell[BoxData[
 TagBox[
  RowBox[{"-", 
   SqrtBox[
    FractionBox["5", "4"]]}],
  DisplayForm]], "Output"],

Cell[BoxData[
 TagBox["\[Pi]",
  DisplayForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Radicalize", "[", 
   RowBox[{"1", ",", "3"}], "]"}], "//", 
  "DisplayForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Radicalize", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"3", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "3"}], ")"}]}]}], "/", "2"}], ",", "3"}], "]"}], "//",
   "DisplayForm"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RadicalBox["1", "3"],
  DisplayForm]], "Output"],

Cell[BoxData[
 TagBox[
  RowBox[{"-", 
   RadicalBox[
    FractionBox["3", "8"], "3"]}],
  DisplayForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["String alignment and value extraction", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "AlignmentBox", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"AlignmentMarker", "->", "\"\<&\>\""}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Align", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ColumnAlignments", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Left"}], "}"}]}], ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", "0"}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BreakString", "[", 
     RowBox[{"Separator_", ",", "Str_"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "PosnList", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"PosnList", "=", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"Null", ",", "0"}], "}"}], "}"}], ",", 
          RowBox[{"StringPosition", "[", 
           RowBox[{"Str", ",", "Separator"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"StringLength", "[", "Str", "]"}], "+", "1"}], ",", 
             "Null"}], "}"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"StringTake", "[", 
          RowBox[{"Str", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"PosnList", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", "1"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"PosnList", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "+", "1"}], "]"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], "}"}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{
            RowBox[{"Length", "[", "PosnList", "]"}], "-", "1"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AlignmentBox", "[", 
    RowBox[{"Str_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{"Opts", ",", 
          RowBox[{"Options", "[", "AlignmentBox", "]"}]}], "}"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Align", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"AlignmentMarker", ",", "_String", ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"StyleBox", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Align", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
          RowBox[{"GridBox", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"BreakString", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"AlignmentMarker", "/.", "FullOpts"}], ")"}], ",", 
               "Str"}], "]"}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"LegacyFilterOptions", "[", 
             RowBox[{"GridBox", ",", "FullOpts"}], "]"}]}], 
           "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"StringReplace", "[", 
           RowBox[{"Str", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"AlignmentMarker", "/.", "FullOpts"}], ")"}], "->", 
             "\"\<\>\""}]}], "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"LegacyFilterOptions", "[", 
         RowBox[{"StyleBox", ",", "FullOpts"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.566836778126889*^9, 3.566836779586891*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"AlignmentBox", "[", 
   RowBox[{"\"\<a&b\>\"", ",", 
    RowBox[{"ColumnWidths", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], ",", 
    RowBox[{"Align", "\[Rule]", "False"}]}], "]"}], "//", 
  "DisplayForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AlignmentBox", "[", 
   RowBox[{"\"\<a&b\>\"", ",", 
    RowBox[{"ColumnWidths", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}]}], "]"}], "//", 
  "DisplayForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AlignmentBox", "[", 
   RowBox[{"\"\<aaaa&bbbb\>\"", ",", 
    RowBox[{"ColumnWidths", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}]}], "]"}], "//", 
  "DisplayForm"}]}], "Input"],

Cell[BoxData[
 TagBox["ab",
  DisplayForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"}
   },
   GridBoxAlignment->{
    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
     "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{5}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  DisplayForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False],

Cell[BoxData[
 TagBox[GridBox[{
    {"aaaa", "bbbb"}
   },
   GridBoxAlignment->{
    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
     "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{5}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  DisplayForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LaTeXTableEntryValue", "[", 
    RowBox[{"Value_", "?", "NumericQ"}], "]"}], ":=", "Value"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LaTeXTableEntryValue", "[", "Str_String", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "FirstNumericPosn", ",", "\[IndentingNewLine]", "ErrorBarsPosn", ",", 
       "\[IndentingNewLine]", "Value"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"FirstNumericPosn", "=", 
       RowBox[{
        RowBox[{"StringPosition", "[", 
         RowBox[{"Str", ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<+\>\"", ",", "\"\<-\>\"", ",", "\"\<0\>\"", ",", "\"\<1\>\"", 
            ",", "\"\<2\>\"", ",", "\"\<3\>\"", ",", "\"\<4\>\"", ",", 
            "\"\<5\>\"", ",", "\"\<6\>\"", ",", "\"\<7\>\"", ",", "\"\<8\>\"",
             ",", "\"\<9\>\"", ",", "\"\<.\>\""}], "}"}], ",", "1"}], "]"}], 
        "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"ErrorBarsPosn", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"StringPosition", "[", 
            RowBox[{"Str", ",", "\"\<(\>\"", ",", "1"}], "]"}], "]"}], 
          "\[GreaterEqual]", "1"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"StringPosition", "[", 
           RowBox[{"Str", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<(\>\"", ",", "\"\<\[PlusMinus]\>\""}], "}"}], ",", 
            "1"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{
          RowBox[{"StringLength", "[", "Str", "]"}], "+", "1"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Value", "=", 
       RowBox[{"ToExpression", "[", "\[IndentingNewLine]", 
        RowBox[{"StringReplace", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"StringTake", "[", 
           RowBox[{"Str", ",", 
            RowBox[{"{", 
             RowBox[{"FirstNumericPosn", ",", 
              RowBox[{"ErrorBarsPosn", "-", "1"}]}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"\"\<&\>\"", "->", "\"\<\>\""}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"NumericQ", "[", "Value", "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"LaTeXTableEntryValue", "::", "notnumeric"}], ",", "Str", 
          ",", "Value"}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "Value"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix formatting", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "SubarrayEllipsis", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"Padding", "\[Rule]", "\"\<\[CenterEllipsis]\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SubarrayEllipsis", "[", 
    RowBox[{
     RowBox[{"m_", "?", "MatrixQ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Rows", ":", 
        RowBox[{"(", 
         RowBox[{"_Integer", "|", "Infinity"}], ")"}]}], ",", 
       RowBox[{"Columns", ":", 
        RowBox[{"(", 
         RowBox[{"_Integer", "|", "Infinity"}], ")"}]}]}], "}"}], ",", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "RowTrim", ",", "ColumnTrim", ",", "RowMax", ",", "ColumnMax", ",", 
       "MatrixTrimmed"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RowTrim", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "m", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", "Rows"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"RowMax", "=", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "m", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "Rows"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ColumnTrim", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "m", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ">", "Columns"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ColumnMax", "=", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "m", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", "Columns"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"ArrayPad", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"m", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"1", ";;", "RowMax"}], ",", 
           RowBox[{"1", ";;", "ColumnMax"}]}], "]"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"If", "[", 
             RowBox[{"RowTrim", ",", "1", ",", "0"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"If", "[", 
             RowBox[{"ColumnTrim", ",", "1", ",", "0"}], "]"}]}], "}"}]}], 
         "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"OptionValue", "[", "Padding", "]"}]}], "\[IndentingNewLine]",
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SubarrayEllipsis", "[", 
    RowBox[{"m_List", ",", 
     RowBox[{"{", 
      RowBox[{"Rows", ":", 
       RowBox[{"(", 
        RowBox[{"_Integer", "|", "Infinity"}], ")"}]}], "}"}], ",", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"RowTrim", ",", "RowMax", ",", "MatrixTrimmed"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RowTrim", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "m", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", "Rows"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"RowMax", "=", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "m", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "Rows"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"ArrayPad", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"m", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", "RowMax"}], "]"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"If", "[", 
            RowBox[{"RowTrim", ",", "1", ",", "0"}], "]"}]}], "}"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"OptionValue", "[", "Padding", "]"}]}], "\[IndentingNewLine]",
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.453752688421875*^9, 3.453752798171875*^9}, {
   3.453752835078125*^9, 3.453752858125*^9}, {3.453752915046875*^9, 
   3.453753005640625*^9}, {3.453753107703125*^9, 3.45375318890625*^9}, {
   3.453753269890625*^9, 3.4537533165*^9}, {3.453753348875*^9, 
   3.453753423375*^9}, {3.45375348009375*^9, 3.4537535103125*^9}, {
   3.45375362628125*^9, 3.453753644703125*^9}, {3.453753703703125*^9, 
   3.453753734171875*^9}, 3.45375387246875*^9, {3.453754018015625*^9, 
   3.453754038546875*^9}, {3.453754132359375*^9, 3.453754173328125*^9}, {
   3.471795786375*^9, 3.47179583884375*^9}, {3.471795928265625*^9, 
   3.471795978421875*^9}, {3.471796042375*^9, 3.471796044546875*^9}, {
   3.4717962060625*^9, 3.4717962070625*^9}, {3.471796247625*^9, 
   3.47179624865625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SubarrayEllipsis", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SubarrayEllipsis", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "12"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SubarrayEllipsis", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SubarrayEllipsis", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", 
    RowBox[{"Padding", "\[Rule]", "\"\<~\>\""}]}], "]"}], "//", 
  "TableForm"}]}], "Input",
 CellChangeTimes->{{3.45375376603125*^9, 3.4537537978125*^9}, {
  3.453753874375*^9, 3.4537538751875*^9}, {3.45375420128125*^9, 
  3.453754222765625*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1", "1", "1", "\<\"\[CenterEllipsis]\"\>"},
     {"2", "2", "2", "2", "2", "\<\"\[CenterEllipsis]\"\>"},
     {"3", "3", "3", "3", "3", "\<\"\[CenterEllipsis]\"\>"},
     {"4", "4", "4", "4", "4", "\<\"\[CenterEllipsis]\"\>"},
     {"5", "5", "5", "5", "5", "\<\"\[CenterEllipsis]\"\>"},
     {"\<\"\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\
\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\
\>", "\<\"\[CenterEllipsis]\"\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.453753762515625*^9, 3.45375380025*^9}, 
   3.453753928140625*^9, 3.453754045546875*^9, {3.453754180296875*^9, 
   3.453754186*^9}, 3.453754223125*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1"},
     {"2", "2", "2", "2", "2", "2", "2", "2", "2", "2"},
     {"3", "3", "3", "3", "3", "3", "3", "3", "3", "3"},
     {"4", "4", "4", "4", "4", "4", "4", "4", "4", "4"},
     {"5", "5", "5", "5", "5", "5", "5", "5", "5", "5"},
     {"\<\"\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\
\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\
\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\
\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\
\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.453753762515625*^9, 3.45375380025*^9}, 
   3.453753928140625*^9, 3.453754045546875*^9, {3.453754180296875*^9, 
   3.453754186*^9}, 3.4537542231875*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1", "1", "1", "\<\"\[CenterEllipsis]\"\>"},
     {"2", "2", "2", "2", "2", "\<\"\[CenterEllipsis]\"\>"},
     {"3", "3", "3", "3", "3", "\<\"\[CenterEllipsis]\"\>"},
     {"4", "4", "4", "4", "4", "\<\"\[CenterEllipsis]\"\>"},
     {"5", "5", "5", "5", "5", "\<\"\[CenterEllipsis]\"\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.453753762515625*^9, 3.45375380025*^9}, 
   3.453753928140625*^9, 3.453754045546875*^9, {3.453754180296875*^9, 
   3.453754186*^9}, 3.453754223234375*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "1", "1", "1", "1", "\<\"~\"\>"},
    {"2", "2", "2", "2", "2", "\<\"~\"\>"},
    {"3", "3", "3", "3", "3", "\<\"~\"\>"},
    {"4", "4", "4", "4", "4", "\<\"~\"\>"},
    {"5", "5", "5", "5", "5", "\<\"~\"\>"},
    {"\<\"~\"\>", "\<\"~\"\>", "\<\"~\"\>", "\<\"~\"\>", "\<\"~\"\>", \
"\<\"~\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.453753762515625*^9, 3.45375380025*^9}, 
   3.453753928140625*^9, 3.453754045546875*^9, {3.453754180296875*^9, 
   3.453754186*^9}, 3.4537542233125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"SubarrayEllipsis", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.4717959895*^9, {3.47179605803125*^9, 3.471796089015625*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
         "1", ",", "1", ",", "1"}], "}"}]},
      {
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
         "2", ",", "2", ",", "2"}], "}"}]},
      {
       RowBox[{"{", 
        RowBox[{
        "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
         "3", ",", "3", ",", "3"}], "}"}]},
      {
       RowBox[{"{", 
        RowBox[{
        "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
         "4", ",", "4", ",", "4"}], "}"}]},
      {
       RowBox[{"{", 
        RowBox[{
        "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
         "5", ",", "5", ",", "5"}], "}"}]},
      {"\<\"\[CenterEllipsis]\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, TableDepth -> 1]]]], "Output",
 CellChangeTimes->{
  3.47179598978125*^9, {3.471796050109375*^9, 3.471796089390625*^9}, 
   3.471796293046875*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperlink box construction", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeButtonForURL", "[", 
    RowBox[{"Contents_", ",", 
     RowBox[{"URLString_String", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"StringMatchQ", "[", 
         RowBox[{"#", ",", "\"\<http://*\>\""}], "]"}], "&"}], ")"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"DisplayForm", "[", 
    RowBox[{"ButtonBox", "[", "\[IndentingNewLine]", 
     RowBox[{
     "Contents", ",", "\[IndentingNewLine]", "Opts", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ButtonData", "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"URL", "[", "URLString", "]"}], ",", "None"}], "}"}]}], ",", 
      
      RowBox[{"ButtonNote", "->", "URLString"}], ",", 
      RowBox[{"ButtonFunction", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"FrontEndExecute", "[", 
          RowBox[{"{", 
           RowBox[{"FrontEnd`NotebookLocate", "[", "#2", "]"}], "}"}], "]"}], 
         "&"}], ")"}]}], ",", 
      RowBox[{"Active", "\[Rule]", "True"}]}], "\[IndentingNewLine]", "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellTags->"ButtonBox"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-style documentation box construction"
}], "Subsection"],

Cell[TextData[{
 "Notes: \n\tGridBox seems to recognize options only if given explicitly or \
through GridBoxOptions, not if given through a named argument.  This \
presumably has to do with evaluation rules.\n\t",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s help files use TraditionalForm and rely heavily upon the \"InlineFormula\
\" style.\n\t",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s help files use a special style \"MR\" to acheive a typewriter-like font \
for symbol names.\n\tThe HelpBrowser style sheet fixes the column widths, but \
this could be overridden (e.g., by setting ColumnWidths->Automatic, together \
with a modified ColumnSeparations).\n\tHere we use DisplayForm, with no \
obvious effect relative to no form specification, but included as a \
precaution.\n\tWe set Times as the default font, to obtain a similar \
appearance to TraditionalForm formulas with simpler typesetting.\n\tWe use a \
larger inter-row spacing than in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s help files.\n\tCell contents for \"Caption\" must be TextData, not \
BoxData, for style to properly control font."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeColumnBox", "[", 
   RowBox[{
   "StyleName_String", ",", "Columns_Integer", ",", "GridBoxOptionsList_List",
     ",", "Contents___List"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "GridData", "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"{", "Contents", "}"}], "]"}], ",", 
          RowBox[{"Columns", "\[Equal]", "0"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Message", "[", 
        RowBox[{"MakeColumnBox", "::", "notmult"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Convert", " ", "each", " ", "list", " ", "into", " ", "a", " ", 
       "RowBox"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"GridData", "=", 
      RowBox[{"RowBox", "/@", 
       RowBox[{"{", "Contents", "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Group", " ", "entries", " ", "into", " ", "rows"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"GridData", "=", 
      RowBox[{"Partition", "[", 
       RowBox[{"GridData", ",", "Columns"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Convert", " ", "text", " ", "styles", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"created", " ", "by", " ", "the", " ", "LaTeX"}], "-", 
         RowBox[{"like", " ", "directives"}]}], ")"}], " ", "into", " ", 
       "actual", " ", "boxes"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"GridData", "=", 
      RowBox[{"GridData", "/.", 
       RowBox[{"{", 
        RowBox[{"StyleForm", "\[Rule]", "StyleBox"}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Make", " ", "cell", " ", "containing", " ", "framed", " ", "grid", " ",
        "of", " ", "table", " ", "entries"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"CellPrint", "[", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"BoxData", "[", "\[IndentingNewLine]", 
         RowBox[{"FormBox", "[", 
          RowBox[{
           RowBox[{"StyleBox", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"FrameBox", "[", "\[IndentingNewLine]", 
              RowBox[{"GridBox", "[", "GridData", "]"}], 
              "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
             "StyleName", ",", 
             RowBox[{"GridBoxOptions", "\[Rule]", "GridBoxOptionsList"}], ",", 
             RowBox[{"FontFamily", "->", "\"\<Times\>\""}]}], 
            "\[IndentingNewLine]", "]"}], ",", "DisplayForm"}], "]"}], 
         "\[IndentingNewLine]", "]"}], ",", "\"\<Text\>\""}], "]"}], 
      "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeCaptionBox", "[", "Contents_List", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "ContentsData", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "Contents", "}"}], "]"}], ",", 
           RowBox[{"Columns", "\[Equal]", "0"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Message", "[", 
         RowBox[{"MakeColumnBox", "::", "notmult"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Convert", " ", "each", " ", "list", " ", "into", " ", "text", " ", 
        "data"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ContentsData", "=", 
       RowBox[{"RowBox", "[", "Contents", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Convert", " ", "text", " ", "styles", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"created", " ", "by", " ", "the", " ", "LaTeX"}], "-", 
          RowBox[{"like", " ", "directives"}]}], ")"}], " ", "into", " ", 
        "actual", " ", "boxes"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ContentsData", "=", 
       RowBox[{"ContentsData", "/.", 
        RowBox[{"{", 
         RowBox[{"StyleForm", "\[Rule]", "StyleBox"}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Make", " ", "cell"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"CellPrint", "[", "\[IndentingNewLine]", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"TextData", "[", "ContentsData", "]"}], ",", 
         "\"\<Caption\>\""}], "]"}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"original", " ", "2", 
     RowBox[{"ColumnBox", ":", " ", "ColumnWidths"}]}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.31", ",", "0.67"}], "}"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"MakeHelpBox", "[", 
      RowBox[{"\"\<SymbolSummary\>\"", ",", "Contents___List"}], "]"}], ":=", 
     
     RowBox[{"MakeColumnBox", "[", 
      RowBox[{"\"\<2ColumnBox\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColumnAlignments", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Right", ",", "Left"}], "}"}]}], ",", 
         RowBox[{"RowLines", "\[Rule]", 
          RowBox[{"{", "False", "}"}]}], ",", 
         RowBox[{"RowSpacings", "\[Rule]", "1.5"}], ",", 
         RowBox[{"ColumnWidths", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0.31", ",", "0.65"}], "}"}]}]}], "}"}], ",", "Contents"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeHelpBox", "[", 
      RowBox[{
      "\"\<SymbolSummaryWideDescription\>\"", ",", "Contents___List"}], "]"}],
      ":=", 
     RowBox[{"MakeColumnBox", "[", 
      RowBox[{"\"\<2ColumnBox\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColumnAlignments", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Right", ",", "Left"}], "}"}]}], ",", 
         RowBox[{"RowLines", "\[Rule]", 
          RowBox[{"{", "False", "}"}]}], ",", 
         RowBox[{"RowSpacings", "\[Rule]", "1.5"}], ",", 
         RowBox[{"ColumnWidths", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0.26", ",", "0.70"}], "}"}]}]}], "}"}], ",", "Contents"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"original", " ", "3", 
     RowBox[{"ColumnBox", ":", " ", 
      RowBox[{"{", 
       RowBox[{"ColumnWidths", "\[Rule]", "0.32"}], "}"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeHelpBox", "[", 
      RowBox[{"\"\<OptionSummary\>\"", ",", "Contents___List"}], "]"}], ":=", 
     
     RowBox[{"MakeColumnBox", "[", 
      RowBox[{"\"\<3ColumnBox\>\"", ",", "3", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColumnAlignments", "\[Rule]", 
          RowBox[{"{", "Left", "}"}]}], ",", 
         RowBox[{"RowLines", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], ",", 
         RowBox[{"RowSpacings", "\[Rule]", "1.5"}], ",", 
         RowBox[{"ColumnWidths", "\[Rule]", 
          RowBox[{"{", "0.32", "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"StyleBox", "[", 
         RowBox[{"\"\<option name\>\"", ",", "\"\<SO10\>\""}], "]"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"StyleBox", "[", 
         RowBox[{"\"\<default value\>\"", ",", "\"\<SO10\>\""}], "]"}], "}"}],
        ",", 
       RowBox[{"{", "\"\<\>\"", "}"}], ",", "\[IndentingNewLine]", 
       "Contents"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeHelpBox", "[", 
      RowBox[{
      "\"\<OptionSummaryWideDescription\>\"", ",", "Contents___List"}], "]"}],
      ":=", 
     RowBox[{"MakeColumnBox", "[", 
      RowBox[{"\"\<3ColumnBox\>\"", ",", "3", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColumnAlignments", "\[Rule]", 
          RowBox[{"{", "Left", "}"}]}], ",", 
         RowBox[{"RowLines", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], ",", 
         RowBox[{"RowSpacings", "\[Rule]", "1.5"}], ",", 
         RowBox[{"ColumnWidths", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0.23", ",", "0.23", ",", "0.5"}], "}"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"StyleBox", "[", 
         RowBox[{"\"\<option name\>\"", ",", "\"\<SO10\>\""}], "]"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"StyleBox", "[", 
         RowBox[{"\"\<default value\>\"", ",", "\"\<SO10\>\""}], "]"}], "}"}],
        ",", 
       RowBox[{"{", "\"\<\>\"", "}"}], ",", "\[IndentingNewLine]", 
       "Contents"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeHelpBox", "[", 
      RowBox[{
      "\"\<OptionSummaryWideDescriptionContinuation\>\"", ",", 
       "Contents___List"}], "]"}], ":=", 
     RowBox[{"MakeColumnBox", "[", 
      RowBox[{"\"\<3ColumnBox\>\"", ",", "3", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColumnAlignments", "\[Rule]", 
          RowBox[{"{", "Left", "}"}]}], ",", 
         RowBox[{"RowLines", "\[Rule]", 
          RowBox[{"{", "False", "}"}]}], ",", 
         RowBox[{"RowSpacings", "\[Rule]", "1.5"}], ",", 
         RowBox[{"ColumnWidths", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0.23", ",", "0.23", ",", "0.5"}], "}"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "Contents"}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{"MakeHelpBox", "[", 
  RowBox[{"\"\<SymbolSummary\>\"", ",", 
   RowBox[{"{", "\"\<a\>\"", "}"}], ",", 
   RowBox[{"{", "\"\<b\>\"", "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MakeHelpBox", "[", 
  RowBox[{"\"\<OptionSummary\>\"", ",", 
   RowBox[{"{", "\"\<a\>\"", "}"}], ",", 
   RowBox[{"{", "\"\<b\>\"", "}"}], ",", 
   RowBox[{"{", "\"\<cyuiop\>\"", "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MakeCaptionBox", "[", 
  RowBox[{"{", "\"\<This is a test.\>\"", "}"}], "]"}]}], "Input"],

Cell[BoxData[
 FormBox[
  StyleBox[
   FrameBox[GridBox[{
      {"a", "b"}
     }]], "2ColumnBox",
   FontFamily->"Times",
   GridBoxOptions->{
   GridBoxAlignment->{
    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
     "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
   GridBoxDividers->{
    "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.31], {
        Scaled[0.65]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.5599999999999999]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.6]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}}], DisplayForm]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 FormBox[
  StyleBox[
   FrameBox[GridBox[{
      {
       StyleBox[
        RowBox[{"option", " ", "name"}], "SO10"], 
       StyleBox[
        RowBox[{"default", " ", "value"}], "SO10"], ""},
      {"a", "b", "cyuiop"}
     }]], "3ColumnBox",
   FontFamily->"Times",
   GridBoxOptions->{
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxDividers->{
    "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
     "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.32]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.5599999999999999]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.6]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}}], DisplayForm]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell["This is a test.", "Caption",
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["NPrint", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NPrint", "[", "ArgSeq___", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "NArgList", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NArgList", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"NumericQ", "[", "#", "]"}], ",", 
           RowBox[{"N", "[", "#", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", "ArgSeq", "}"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"Sequence", "@@", "NArgList"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NPrint", "[", 
  RowBox[{"5", ",", "\"\<a\>\""}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5.`", "\[InvisibleSpace]", "\<\"a\"\>"}],
  SequenceForm[5., "a"],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pagination", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PageBreak", ":=", 
   RowBox[{"CellPrint", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"\"\<\>\"", ",", 
      RowBox[{"PageBreakBelow", "\[Rule]", "True"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End private context", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["End package", "Section"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"$Context", "<>", "\"\<*\>\""}], "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"$Context", "<>", "\"\<$*\>\""}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scratch", "Section"],

Cell["\<\
\tFor diagonal fractions, problems with superscript/normal/subscript \
implementation: In Courier, looks fine, but in Times slash is too tall \
relative to numbers.  In proportional font slash shrinks so denominator \
squeezes against it.  But ColumnsEqual->True is not good, since it gives poor \
results if the numerator or denominator is a fat expression.

In this type of diagonal fraction, using Bottom of lower number as baseline \
gives good alignment, while using Bottom of whole box allows too much space \
at bottom.  Cannot use baseline of an of the entries, since these are all the \
baseline of the slash, but the denominator dangles below this. \
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalFractionBox", "[", 
    RowBox[{"x_", ",", "y_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"GridBox", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\"\<\>\"", ",", 
          RowBox[{"DisplayForm", "[", "x", "]"}]}], "]"}], ",", "\"\</\>\"", 
        ",", 
        RowBox[{"SubscriptBox", "[", 
         RowBox[{"\"\<\>\"", ",", 
          RowBox[{"DisplayForm", "[", "y", "]"}]}], "]"}]}], "}"}], "}"}], 
     ",", 
     RowBox[{"ColumnSpacings", "\[Rule]", 
      RowBox[{"-", "0.2"}]}], ",", 
     RowBox[{"GridBaseline", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Bottom", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input"],

Cell["And the following just doesn't work...", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DiagonalFractionBox", "[", 
     RowBox[{"x_", ",", "y_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
    RowBox[{"GridBox", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"x", ",", "\[IndentingNewLine]", 
         RowBox[{"StyleBox", "[", 
          RowBox[{
           RowBox[{"SuperscriptBox", "[", 
            RowBox[{"\"\<\>\"", ",", 
             RowBox[{"DisplayForm", "[", "x", "]"}]}], "]"}], ",", 
           RowBox[{"ScriptBaseLineShifts", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"StyleBox", "[", 
          RowBox[{
           RowBox[{"SuperscriptBox", "[", 
            RowBox[{"\"\<\>\"", ",", "\"\</\>\""}], "]"}], ",", 
           RowBox[{"ScriptBaseLineShifts", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0.1"}], "}"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"StyleBox", "[", 
          RowBox[{
           RowBox[{"SubscriptBox", "[", 
            RowBox[{"\"\<\>\"", ",", 
             RowBox[{"DisplayForm", "[", "y", "]"}]}], "]"}], ",", 
           RowBox[{"ScriptBaseLineShifts", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "}"}], ",", 
      RowBox[{"ColumnSpacings", "\[Rule]", 
       RowBox[{"-", "0.2"}]}], ",", 
      RowBox[{"GridBaseline", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input"],

Cell["Old single-argument form of fraction boxes", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SolidusFractionBox", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "==", "1"}], ")"}]}], ":=", 
   RowBox[{"DisplayForm", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SolidusFractionBox", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "!=", "1"}], ")"}]}], ":=", 
   RowBox[{"SolidusFractionBox", "[", 
    RowBox[{
     RowBox[{"Numerator", "[", "x", "]"}], ",", 
     RowBox[{"Denominator", "[", "x", "]"}], ",", "Opts"}], "]"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DiagonalFractionBox", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "==", "1"}], ")"}]}], ":=", 
   RowBox[{"DisplayForm", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DiagonalFractionBox", "[", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Denominator", "[", "x", "]"}], "!=", "1"}], ")"}]}], ":=", 
   RowBox[{"DiagonalFractionBox", "[", 
    RowBox[{
     RowBox[{"Numerator", "[", "x", "]"}], ",", 
     RowBox[{"Denominator", "[", "x", "]"}], ",", "Opts"}], "]"}]}], 
  ";"}]}], "Input"],

Cell["\<\
Fractionizing by replacement of Rational
\tCan deal with more complex entities (e.g., lists of fractions) but gives \
undesirable for many simple quantities.  E.g., Pi/2 becomes Pi *(1/2).\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Fractionize", "[", 
    RowBox[{"Expr_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"Expr", "/.", 
     RowBox[{"{", 
      RowBox[{"x_Rational", ":>", 
       RowBox[{"FractionBox", "[", 
        RowBox[{
         RowBox[{"Numerator", "[", "x", "]"}], ",", 
         RowBox[{"Denominator", "[", "x", "]"}], ",", "Opts"}], "]"}]}], 
      "}"}]}], ")"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SolidusFractionize", "[", 
    RowBox[{"Expr_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"Expr", "/.", 
     RowBox[{"{", 
      RowBox[{"x_Rational", "\[RuleDelayed]", 
       RowBox[{"SolidusFractionBox", "[", 
        RowBox[{
         RowBox[{"Numerator", "[", "x", "]"}], ",", 
         RowBox[{"Denominator", "[", "x", "]"}], ",", "Opts"}], "]"}]}], 
      "}"}]}], ")"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalFractionize", "[", "Expr_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"Expr", "/.", 
     RowBox[{"{", 
      RowBox[{"x_Rational", "\[RuleDelayed]", 
       RowBox[{"DiagonalFractionBox", "[", 
        RowBox[{
         RowBox[{"Numerator", "[", "x", "]"}], ",", 
         RowBox[{"Denominator", "[", "x", "]"}]}], "]"}]}], "}"}]}], ")"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   RowBox[{"xxxx11", ","}], 
   StyleBox[GridBox[{
      {
       AdjustmentBox[
        SubscriptBox["", 
         TagBox["1",
          DisplayForm]],
        BoxBaselineShift->-0.9], 
       AdjustmentBox[
        SubscriptBox["", 
         TagBox[
          StyleBox["\<\"/\"\>",
           FontSlant->"Oblique"],
          StyleForm[#, FontSlant -> "Oblique"]& ]],
        BoxBaselineShift->-0.5], 
       AdjustmentBox[
        SubscriptBox["", 
         TagBox["2",
          DisplayForm]],
        BoxBaselineShift->-0.5]}
     },
     BaselinePosition->{Bottom, {1, 3}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[-0.13999999999999999`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ScriptBaselineShifts->{0, 0}], ",", 
   TagBox[
    StyleBox[GridBox[{
       {
        AdjustmentBox[
         SubscriptBox["", 
          TagBox["1",
           DisplayForm]],
         BoxBaselineShift->-0.9], 
        AdjustmentBox[
         SubscriptBox["", 
          TagBox[
           StyleBox["\<\"/\"\>",
            FontSlant->"Oblique"],
           StyleForm[#, FontSlant -> "Oblique"]& ]],
         BoxBaselineShift->-0.5], 
        AdjustmentBox[
         SubscriptBox["", 
          TagBox["2",
           DisplayForm]],
         BoxBaselineShift->-0.5]}
      },
      BaselinePosition->{Bottom, {1, 3}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[-0.13999999999999999`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ScriptBaselineShifts->{0, 0},
     FontFamily->"Times"],
    StyleForm[#, FontFamily -> Times]& ], ",", "Pi", ",", 
   RowBox[{"\[Pi]", " ", 
    StyleBox[GridBox[{
       {
        AdjustmentBox[
         SubscriptBox["", 
          TagBox["1",
           DisplayForm]],
         BoxBaselineShift->-0.9], 
        AdjustmentBox[
         SubscriptBox["", 
          TagBox[
           StyleBox["\<\"/\"\>",
            FontSlant->"Oblique"],
           StyleForm[#, FontSlant -> "Oblique"]& ]],
         BoxBaselineShift->-0.5], 
        AdjustmentBox[
         SubscriptBox["", 
          TagBox["2",
           DisplayForm]],
         BoxBaselineShift->-0.5]}
      },
      BaselinePosition->{Bottom, {1, 3}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[-0.13999999999999999`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ScriptBaselineShifts->{0, 0}]}], ",", 
   RowBox[{"\[Pi]", " ", 
    StyleBox[GridBox[{
       {
        AdjustmentBox[
         SubscriptBox["", 
          TagBox["3",
           DisplayForm]],
         BoxBaselineShift->-0.9], 
        AdjustmentBox[
         SubscriptBox["", 
          TagBox[
           StyleBox["\<\"/\"\>",
            FontSlant->"Oblique"],
           StyleForm[#, FontSlant -> "Oblique"]& ]],
         BoxBaselineShift->-0.5], 
        AdjustmentBox[
         SubscriptBox["", 
          TagBox["2",
           DisplayForm]],
         BoxBaselineShift->-0.5]}
      },
      BaselinePosition->{Bottom, {1, 3}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[-0.13999999999999999`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ScriptBaselineShifts->{0, 0}]}], "xxx"}],
  DisplayForm]], "Output"]
}, Open  ]],

Cell["\<\
SubmatrixEllipsis -- not robust against equal or lesser dimension matrices, \
trimmed number region to one less than specified dimensions\
\>", "Text",
 CellChangeTimes->{{3.453753071390625*^9, 3.453753091640625*^9}, {
  3.453753899796875*^9, 3.453753906609375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SubmatrixEllipsis", "[", 
    RowBox[{
     RowBox[{"m_", "?", "MatrixQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"Rows_", ",", "Cols_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Append", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"m", ",", 
           RowBox[{"Rows", "-", "1"}], ",", 
           RowBox[{"Cols", "-", "1"}]}], "]"}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{"\"\<\[CenterEllipsis]\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"Cols", "-", "1"}], "}"}]}], "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<\[CenterEllipsis]\>\"", ",", 
       RowBox[{"{", "Rows", "}"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4537538786875*^9, 3.453753885*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SubmatrixEllipsis", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.453753879328125*^9, 3.45375388878125*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1", "1", "\<\"\[CenterEllipsis]\"\>"},
     {"2", "2", "2", "2", "\<\"\[CenterEllipsis]\"\>"},
     {"3", "3", "3", "3", "\<\"\[CenterEllipsis]\"\>"},
     {"4", "4", "4", "4", "\<\"\[CenterEllipsis]\"\>"},
     {"\<\"\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\
\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\>", "\<\"\[CenterEllipsis]\"\
\>"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["Old multiplet label", "Text",
 CellChangeTimes->{{3.461093928625*^9, 3.461093930984375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MultipletBox", "::", "usage"}], "=", 
   "\"\<UNDOCUMENTED (DEPRECATED)\>\""}], ";"}]], "Input",
 CellChangeTimes->{3.461093918015625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MultipletBox", "[", "ValueSeq__", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ValueList", "=", 
       RowBox[{"{", "ValueSeq", "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"RowBox", "[", 
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\"\<(\>\"", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"First", "[", "ValueList", "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"{", 
              RowBox[{"\"\<,\>\"", ",", 
               RowBox[{"hspace", "[", 
                RowBox[{"-", "0.2"}], "]"}], ",", "#"}], "}"}], ")"}], "&"}], 
           "/@", 
           RowBox[{"Rest", "[", "ValueList", "]"}]}], ",", "1"}], "]"}], " ", 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\"\<)\>\"", "}"}]}], "\[IndentingNewLine]", "]"}], 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MultipletBox", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"1", "/", "2"}]}], "]"}], "//", "DisplayForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", "2"], ",", 
    FractionBox["1", "2"], ",", 
    FractionBox["1", "2"]}], ")"}],
  DisplayForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{1272, 902},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
DockedCells->(FrontEndExecute[{
   FrontEnd`NotebookApply[
    FrontEnd`InputNotebook[], #, Placeholder]}]& ),
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{
      ValueBox["FileName"]}], "Header"]}, {
   Cell[
    TextData[{
      ValueBox["FileName"]}], "Header"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageHeaderLines->{False, Inherited},
PrintingOptions->{"FirstPageHeader"->False,
"PrintingMargins"->{{36, 36}, {36, 36}}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ButtonBox"->{
  Cell[156842, 4587, 1206, 32, 262, "Input",
   InitializationCell->True,
   CellTags->"ButtonBox"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ButtonBox", 190050, 5566}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 34, 0, 88, "Section"],
Cell[604, 24, 2417, 61, 300, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[3058, 90, 32, 0, 88, "Section"],
Cell[3093, 92, 204, 5, 35, "Input",
 InitializationCell->True],
Cell[3300, 99, 184, 5, 35, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[3521, 109, 27, 0, 88, "Section"],
Cell[CellGroupData[{
Cell[3573, 113, 36, 0, 46, "Subsection"],
Cell[3612, 115, 11566, 299, 2280, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[15215, 419, 36, 0, 46, "Subsection"],
Cell[15254, 421, 488, 14, 80, "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15791, 441, 40, 0, 88, "Section"],
Cell[15834, 443, 119, 3, 35, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[15978, 450, 132, 3, 46, "Subsection"],
Cell[16113, 455, 98, 1, 48, "Program"],
Cell[16214, 458, 422, 12, 35, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[16673, 475, 352, 13, 47, "Subsection"],
Cell[17028, 490, 1809, 57, 190, "Input",
 InitializationCell->True],
Cell[18840, 549, 425, 14, 35, "Input",
 InitializationCell->True],
Cell[19268, 565, 1205, 40, 124, "Input",
 InitializationCell->True],
Cell[20476, 607, 627, 17, 80, "Input",
 InitializationCell->True],
Cell[21106, 626, 33, 0, 34, "Text"],
Cell[21142, 628, 1228, 34, 190, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[22407, 667, 45, 0, 46, "Subsection"],
Cell[22455, 669, 510, 14, 58, "Input",
 InitializationCell->True],
Cell[22968, 685, 1444, 43, 80, "Input",
 InitializationCell->True],
Cell[24415, 730, 1582, 41, 190, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[26022, 775, 281, 7, 35, "Input"],
Cell[26306, 784, 435, 12, 35, "Output"]
}, Open  ]],
Cell[26756, 799, 275, 7, 35, "Input",
 InitializationCell->True],
Cell[27034, 808, 1467, 36, 124, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[28526, 848, 758, 17, 146, "Input"],
Cell[29287, 867, 572, 12, 35, "Output"],
Cell[29862, 881, 569, 12, 35, "Output"],
Cell[30434, 895, 565, 12, 35, "Output"],
Cell[31002, 909, 562, 12, 35, "Output"],
Cell[31567, 923, 564, 12, 53, "Output"],
Cell[32134, 937, 572, 12, 53, "Output"]
}, Open  ]],
Cell[32721, 952, 1567, 43, 331, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[34313, 999, 535, 15, 53, "Input"],
Cell[34851, 1016, 147, 3, 41, "Message"],
Cell[35001, 1021, 349, 12, 82, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35399, 1039, 119, 1, 71, "Subsection"],
Cell[35521, 1042, 778, 21, 90, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[36336, 1068, 93, 1, 71, "Subsection"],
Cell[36432, 1071, 2580, 60, 606, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[39037, 1135, 944, 25, 158, "Input"],
Cell[39984, 1162, 576, 12, 53, "Output"],
Cell[40563, 1176, 576, 12, 53, "Output"],
Cell[41142, 1190, 571, 12, 53, "Output"],
Cell[41716, 1204, 572, 12, 66, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42337, 1222, 41, 0, 88, "Subsection"],
Cell[CellGroupData[{
Cell[42403, 1226, 134, 2, 112, "Input"],
Cell[42540, 1230, 1281, 29, 383, "Output"],
Cell[43824, 1261, 45, 1, 127, "Output"]
}, Open  ]],
Cell[43884, 1265, 472, 8, 366, "Text"],
Cell[44359, 1275, 27, 0, 126, "Text"],
Cell[44389, 1277, 210, 6, 118, "Text"],
Cell[44602, 1285, 708, 21, 90, "Input",
 InitializationCell->True],
Cell[45313, 1308, 95, 4, 118, "Text"],
Cell[45411, 1314, 4871, 114, 708, "Input",
 InitializationCell->True],
Cell[50285, 1430, 49, 0, 52, "Text"],
Cell[50337, 1432, 889, 26, 158, "Input",
 InitializationCell->True],
Cell[51229, 1460, 41, 0, 52, "Text"],
Cell[51273, 1462, 1202, 37, 125, "Input",
 InitializationCell->True],
Cell[52478, 1501, 1230, 37, 158, "Input",
 InitializationCell->True],
Cell[53711, 1540, 1234, 37, 158, "Input",
 InitializationCell->True],
Cell[54948, 1579, 40, 0, 196, "Text"],
Cell[CellGroupData[{
Cell[55013, 1583, 847, 24, 472, "Input"],
Cell[55863, 1609, 573, 20, 197, "Output"],
Cell[56439, 1631, 609, 21, 197, "Output"],
Cell[57051, 1654, 469, 16, 197, "Output"]
}, Open  ]],
Cell[57535, 1673, 55, 0, 196, "Text"],
Cell[57593, 1675, 347, 16, 197, "Output"],
Cell[57943, 1693, 55, 0, 196, "Text"],
Cell[58001, 1695, 310, 9, 197, "Input"],
Cell[58314, 1706, 1026, 23, 597, "Input"],
Cell[59343, 1731, 34, 0, 196, "Text"],
Cell[59380, 1733, 5046, 142, 285, "Output"],
Cell[64429, 1877, 34, 0, 196, "Text"],
Cell[64466, 1879, 5046, 142, 291, "Output"],
Cell[69515, 2023, 34, 0, 196, "Text"],
Cell[69552, 2025, 5050, 142, 291, "Output"],
Cell[74605, 2169, 34, 0, 196, "Text"],
Cell[74642, 2171, 5050, 142, 293, "Output"],
Cell[79695, 2315, 34, 0, 196, "Text"],
Cell[79732, 2317, 5050, 142, 293, "Output"],
Cell[CellGroupData[{
Cell[84807, 2463, 750, 17, 472, "Input"],
Cell[85560, 2482, 3274, 110, 233, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88871, 2597, 1097, 27, 1126, "Input"],
Cell[89971, 2626, 2280, 59, 733, "Output"],
Cell[92254, 2687, 3706, 108, 235, "Output"]
}, Open  ]],
Cell[95975, 2798, 119, 3, 196, "Text"],
Cell[CellGroupData[{
Cell[96119, 2805, 295, 7, 197, "Input"],
Cell[96417, 2814, 446, 12, 340, "Output"]
}, Open  ]],
Cell[96878, 2829, 96, 2, 196, "Text"],
Cell[CellGroupData[{
Cell[96999, 2835, 295, 7, 197, "Input"],
Cell[97297, 2844, 302, 8, 197, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97636, 2857, 407, 13, 197, "Input"],
Cell[98046, 2872, 26027, 758, 733, "Output"]
}, Open  ]],
Cell[124088, 3633, 30, 0, 52, "Text"],
Cell[124121, 3635, 1463, 36, 400, "Input",
 InitializationCell->True],
Cell[125587, 3673, 32, 0, 52, "Text"],
Cell[125622, 3675, 1829, 43, 537, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[127476, 3722, 625, 14, 860, "Input"],
Cell[128104, 3738, 36, 0, 197, "Output"],
Cell[128143, 3740, 42, 0, 197, "Output"],
Cell[128188, 3742, 41, 0, 197, "Output"],
Cell[128232, 3744, 43, 0, 197, "Output"],
Cell[128278, 3746, 45, 0, 197, "Output"],
Cell[128326, 3748, 47, 0, 197, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[128422, 3754, 36, 0, 71, "Subsection"],
Cell[128461, 3756, 498, 12, 227, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[128996, 3773, 93, 2, 71, "Subsection"],
Cell[129092, 3777, 1626, 47, 433, "Input",
 InitializationCell->True],
Cell[130721, 3826, 322, 11, 35, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[131068, 3841, 349, 8, 102, "Input"],
Cell[131420, 3851, 31, 0, 35, "Output"],
Cell[131454, 3853, 31, 0, 35, "Output"],
Cell[131488, 3855, 31, 0, 35, "Output"],
Cell[131522, 3857, 32, 0, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[131591, 3862, 493, 15, 102, "Input"],
Cell[132087, 3879, 65, 3, 38, "Output"],
Cell[132155, 3884, 88, 4, 64, "Output"],
Cell[132246, 3890, 107, 5, 64, "Output"],
Cell[132356, 3897, 57, 2, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132450, 3904, 381, 13, 58, "Input"],
Cell[132834, 3919, 73, 3, 41, "Output"],
Cell[132910, 3924, 115, 5, 64, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133074, 3935, 59, 0, 46, "Subsection"],
Cell[133136, 3937, 554, 14, 124, "Input",
 InitializationCell->True],
Cell[133693, 3953, 3990, 100, 630, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[137708, 4057, 752, 22, 80, "Input"],
Cell[138463, 4081, 104, 4, 35, "Output"],
Cell[138570, 4087, 638, 19, 35, "Output"],
Cell[139211, 4108, 644, 19, 35, "Output"]
}, Open  ]],
Cell[139870, 4130, 3125, 76, 564, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[143032, 4211, 39, 0, 46, "Subsection"],
Cell[143074, 4213, 5293, 134, 658, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[148392, 4351, 1662, 52, 478, "Input"],
Cell[150057, 4405, 1214, 26, 577, "Output"],
Cell[151274, 4433, 1315, 28, 577, "Output"],
Cell[152592, 4463, 1032, 23, 491, "Output"],
Cell[153627, 4488, 966, 24, 577, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[154630, 4517, 493, 14, 158, "Input"],
Cell[155126, 4533, 1616, 46, 657, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[156791, 4585, 48, 0, 71, "Subsection"],
Cell[156842, 4587, 1206, 32, 262, "Input",
 InitializationCell->True,
 CellTags->"ButtonBox"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158085, 4624, 123, 4, 213, "Subsection"],
Cell[158211, 4630, 1156, 22, 312, "Text"],
Cell[159370, 4654, 3122, 73, 950, "Input",
 InitializationCell->True],
Cell[162495, 4729, 2067, 48, 640, "Input",
 InitializationCell->True],
Cell[164565, 4779, 5047, 130, 743, "Input",
 InitializationCell->True],
Cell[169615, 4911, 525, 11, 378, "Input"],
Cell[170143, 4924, 900, 26, 226, "Text"],
Cell[171046, 4952, 1051, 30, 327, "Text"],
Cell[172100, 4984, 82, 2, 121, "Caption"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172219, 4991, 28, 0, 71, "Subsection"],
Cell[172250, 4993, 710, 19, 193, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[172985, 5016, 90, 2, 158, "Input"],
Cell[173078, 5020, 191, 6, 121, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[173318, 5032, 32, 0, 71, "Subsection"],
Cell[173353, 5034, 258, 8, 53, "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[173660, 5048, 38, 0, 137, "Section"],
Cell[173701, 5050, 96, 3, 53, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[173834, 5058, 30, 0, 137, "Section"],
Cell[173867, 5060, 406, 12, 125, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[174310, 5077, 26, 0, 415, "Section"],
Cell[174339, 5079, 683, 11, 551, "Text"],
Cell[175025, 5092, 863, 25, 378, "Input"],
Cell[175891, 5119, 54, 0, 157, "Text"],
Cell[175948, 5121, 1735, 45, 688, "Input"],
Cell[177686, 5168, 58, 0, 157, "Text"],
Cell[177747, 5170, 877, 26, 378, "Input"],
Cell[178627, 5198, 880, 26, 378, "Input"],
Cell[179510, 5226, 212, 4, 257, "Text"],
Cell[CellGroupData[{
Cell[179747, 5234, 1354, 40, 378, "Input"],
Cell[181104, 5276, 3865, 125, 181, "Output"]
}, Open  ]],
Cell[184984, 5404, 276, 5, 157, "Text"],
Cell[185263, 5411, 919, 25, 272, "Input"],
Cell[CellGroupData[{
Cell[186207, 5440, 425, 12, 158, "Input"],
Cell[186635, 5454, 533, 12, 491, "Output"]
}, Open  ]],
Cell[187183, 5469, 98, 1, 157, "Text"],
Cell[187284, 5472, 185, 5, 158, "Input"],
Cell[187472, 5479, 1144, 29, 1007, "Input"],
Cell[CellGroupData[{
Cell[188641, 5512, 208, 6, 158, "Input"],
Cell[188852, 5520, 229, 9, 246, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
