(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* :Title: MCText *)
(* :Context: MCText` *)
(* :Author: Mark A. Caprio, Department of Physics, University of Notre Dame *)
(* :Summary: Miscellaneous text formatting utilities. *)
(* :Copyright: Copyright 2005, Mark A. Caprio *)
(* :Package Version: 0.0 *)
(* :Mathematica Version: 7.0 *)
(* :History:
Package started December 2003, based upon functions written for LevelScheme.
Distributed with the LevelScheme package.
Context changed to LevelScheme`*.
Rev. January 10, 2013.  Mathematica 9 compatibility.
*)


BeginPackage["LevelScheme`MCText`"];


Unprotect[Evaluate[$Context<>"*"]];


textup::usage="textup[text] gives non-italic text.";
textsl::usage="textsl[text] gives slanted text.";
textit::usage="textit[text] gives italic text.";
textmd::usage="textmd[text] gives non-bold text.";
textbf::usage="textbf[text] gives bold text.";
textrm::usage="textrm[text] gives text in the Times font.";
texttt::usage="texttt[text] gives text in the Courier font.";
textsf::usage="textsf[text] gives text in the Helvetica font.";

textsize::usage="textsize[size,text] gives text with the specified point size.";
textcolor::usage="textcolor[color,text] gives text with the specified color.";
texttracking::usage="texttracking[tracking,text] gives text with the specified tracking.";
textfamily::usage="textfamily[family,text] gives text with the specified family.";
texthidden::usage="texthidden[text] gives invisible text.";

textsubscript::usage="UNDOCUMENTED";
textsuperscript::usage="UNDOCUMENTED";
textsubsuperscript::usage="UNDOCUMENTED";

hspace::usage="hspace[width] produces box of given width in ems, which may be negative.";

StackText::usage="StackText[alignment,linegap,{line1,...}] produces a multiline label.";

LabelJP::usage="LabelJP[J,P], or Label[J] for P=+1, produces a level spin label, with rational number fractions converted to typeset fractions.";
LabelJiP::usage="LabelJiP[J,i,P], or Label[J,i] for P=+1, produces a level spin label, with rational number fractions converted to typeset fractions, with subscript i.";

NucleusBox::usage="UNDOCUMENTED (Limitation: Left subscript and superscript are left aligned.)";
NuclearA::usage="UNDOCUMENTED";
NuclearN::usage="UNDOCUMENTED";
NuclearZ::usage="UNDOCUMENTED";
Isotope::usage="UNDOCUMENTED -- inspired by usage of LaTeX isotope package";

SuperPrimeBox::usage="SuperPrimeBox[x] places x in a SuperscriptBox with superscript prime. SuperPrimeBox[x,n] produces n primes. (UNDOCUMENTED)";
SuperPrime::usage="SuperPrime[x] superscripts x with a prime, in analogy to SuperPlus, SuperMinus, etc. -- since uses Superscript, behaves like mathematical expression, including automatic parenthesization.   SuperPrime[x,n] produces n primes.  (DEPRECATED)";

MultipletLabel::usage="MultipletLabel[{n1,n2,...}] displays as \"(n1,n2,...)\".  The option EntrySeparator specifies a separator to be used instead of commas, or None.  The option Delimiter->{left,right} specifies a delimiter to be used instead of left and right parentheses.";
EntrySeparator::usage="Option for MultipletLabel.";

TightRowBox::usage="UNDOCUMENTED (DEPRECATED)";

SolidusFractionBox::usage="SolidusFractionBox[x,y] typesets x/y as a solidus fraction.";
DiagonalFractionBox::usage="DiagonalFractionBox[x,y] typesets x/y as a diagonal fraction.  The option ColumnSpacings->(spacing) controls the horizontal separation between the elements of the fraction.  The option Baseline->{numeratorheight,slashheight,denominatorheight} controls the vertical positioning of the different elements of the fraction.  KernForSuperscript->(adjustment) introduces a horizontal adjustment to the position of any superscript attached to the fraction.  The default option values produce visually reasonable results for the Times New Roman font.";
KernForSuperscript::usage="KernForSuperscript is an option for DiagonalFractionBox.";

Fractionize::usage="Fractionize[expr] converts any expression with nonzero denominator into a FractionBox.";
SolidusFractionize::usage="SolidusFractionize[expr] converts any expression with nonzero denominator into a SolidusFractionBox.";
DiagonalFractionize::usage="DiagonalFractionize[expr] converts any expression with nonzero denominator into a DiagonalFractionBox.";

FractionString::usage="Provides a compact solidus-delimited fraction representation of a rational number, in string form. (UNDOCUMENTED)";
PiFractionString::usage="Provides a compact solidus-delimited fraction representation of a rational multiple of Pi, in string form. (UNDOCUMENTED)";

SignString::usage="SignString[x] returns \"+\", \"\", or \"-\", depending upon the value of Sign[x].";

Sqrtize::usage="Sqrtize[x] formats a fraction which is the square root of a rational number entirely under the radical (e.g., the usual format for Clebsch-Gordan coefficients).";
Radicalize::usage="Radicalize[x,n] formats a fraction involving nth roots entirely under the radical.";

SubarrayEllipsis::usage="SubarrayEllipsis[m,{rows,cols}] prints a Subarray of m with ellipses appended.";

AlignmentBox::usage= "UNDOCUMENTED  (AlignmentBox options: Any option for GridBox may be used. ColumnWidths is crucial option for alignment across labels. Options[AlignmentBox] overrides GridBox defaults of ColumnAlignments and ColumnSpacings. Any option for StyleBox may be used. Background is the most likely to be needed.)";
Align::usage="Align is an option for AlignmentBox. (UNDOCUMENTED)";
LaTeXTableEntryValue::usage="LaTeXTableEntryValue[Str] takes a typical LaTeX table entry and converts it to a number, by stripping it of any leading nonnumeric characters, any \"&\", and any trailing error estimate following \"(\" or \"\[PlusMinus]\".   (UNDOCUMENTED)";

MakeColumnBox::usage="UNDOCUMENTED";
MakeHelpBox::usage="UNDOCUMENTED  (Notebook style sheet should be HelpBrowser.)";
MakeCaptionBox::usage="UNDOCUMENTED";

MakeButtonForURL::usage="UNDOCUMENTED";

NPrint::usage="NPrint[args] applies N to all numeric arguments before passing the resulting modified arguments to Print. (UNDOCUMENTED)";

PageBreak::usage="PageBreak[] prints a cell with attribute PageBreakBelow set to True.";


LabelJP::invalidparity="Parity must be +1, -1, or None.";
LabelJiP::invalidparity="Parity must be +1, -1, or None.";
MakeColumnBox::notmult="Number of contents items must be multiple of number of columns.";


Begin["`Private`"];


LegacyFilterOptions[f_Symbol,Opts___?OptionQ]:=Sequence@@FilterRules[{Opts},Options[f]];


textup[x_]:=StyleForm[x,FontSlant->"Plain"];
textsl[x_]:=StyleForm[x,FontSlant->"Oblique"];
textit[x_]:=StyleForm[x,FontSlant->"Italic"];
textmd[x_]:=StyleForm[x,FontWeight->"Plain"];
textbf[x_]:=StyleForm[x,FontWeight->"Bold"];
textrm[x_]:=StyleForm[x,FontFamily->"Times"];
texttt[x_]:=StyleForm[x,FontFamily->"Courier"];
textsf[x_]:=StyleForm[x,FontFamily->"Helvetica"];


hspace[Lems_]:=AdjustmentBox["",BoxMargins->{{0,Lems},{0,0}}];


textsize[s_,x_]:=StyleForm[x,FontSize->s];
textcolor[c_,x_]:=StyleForm[x,FontColor->c];
texttracking[t_,x_]:=StyleForm[x,FontTracking->t];
textfamily[f_,x_]:=StyleForm[x,FontFamily->f];
texthidden[x_]:=StyleForm[x,ShowContents->False];


textsubscript[x_]:=SubscriptBox["",x];
textsuperscript[y_]:=SuperscriptBox["",y];
textsubsuperscript[x_,y_]:=SubsuperscriptBox["",x,y];


Options[textit]={hspace->0};
textit[x_,Opts___]:=Module[
{FullOpts=Flatten[{Opts,Options[textit]}]},
AdjustmentBox[
StyleForm[x,FontSlant->"Italic"],
BoxMargins->{{0,hspace/.FullOpts},{0,0}}
]
];


StackText[Alignment_,Spacing_,Lines_List,Opts___?OptionQ]:=GridBox[{#}&/@Lines,ColumnAlignments->Alignment,RowSpacings->Spacing,Opts];


SuperPrimeBox[x_,n:(_Integer?NonNegative):1]:=SuperscriptBox[x,StringJoin[Table["\[Prime]",{n}]]];
(*SuperPrime[x_]:=Superscript[x,"\[Prime]"];*)
SuperPrime[x_,n:(_Integer?NonNegative):1]:=Superscript[x,StringJoin[Table["\[Prime]",{n}]]];


Options[NucleusBox]={NuclearA->"",NuclearZ->"",NuclearN->""};
NucleusBox[Element_,Opts___?OptionQ]:=Module[
{FullOpts=Flatten[{Opts,Options[NucleusBox]}]},
Row[{
SubsuperscriptBox["",NuclearZ/.FullOpts,NuclearA/.FullOpts],SubsuperscriptBox[Element,NuclearN/.FullOpts,""]  (* to match subsuperscript on left for alignment *)
}]
];


(* LIMITATION: A and Z are left aligned *)


Isotope[A_:None,Z_:None,N_:None,Sup_:None,Element_String]:=Row[{
Subsuperscript["",Replace[Z,None->""],Replace[A,None->""]],Subsuperscript[Element,Replace[N,None->""],Replace[Sup,None->""]]  (* to match subsuperscript on left for alignment *)
}];


LabelJiP[J_,i_,P_:+1]:=SubsuperscriptBox[
J/.{Rational->FractionBox},
i,
Switch[P,+1,"+",-1,"-",None,"",_,Message[LabelJP::invalidparity];""]
];
LabelJP[J_,P_:+1]:=SuperscriptBox[
J/.{Rational->FractionBox},
Switch[P,+1,"+",-1,"-",None,"",_,Message[LabelJP::invalidparity];""]
];


TightRowBox::deprecated="TightRowBox is deprecated in favor of Row (for Mathematica 6 and above).";
TightRowBox[Row_List]:=(Message[TightRowBox::deprecated];GridBox[{Row},ColumnSpacings->0]);


Options[MultipletLabel]={EntrySeparator->",",Delimiter->{"(",")"}};
MultipletLabel[Values_List,Opts:OptionsPattern[]]:=Module[
{DeducedEntrySeparator,DeducedDelimiter},

DeducedDelimiter=Switch[
OptionValue[Delimiter],
None,{"",""},
_,OptionValue[Delimiter]
];
DeducedEntrySeparator=Switch[
OptionValue[EntrySeparator],
None,"",
_,OptionValue[EntrySeparator]
];

Row[Join[{DeducedDelimiter[[1]]},Riffle[Values,DeducedEntrySeparator],{DeducedDelimiter[[2]]}]]
];


SolidusFractionBox[x_,y_,Opts___?OptionQ]:=GridBox[{{DisplayForm[x],"/",DisplayForm[y]}},ColumnSpacings->-0.1,GridBaseline->{Baseline,{1,3}}];


(* ColumnSpacings->-0.1 worked well for Mathematica 5 (with Times), but ColumnSpacings->-0.5 needed for Mathematica 6. *)
Options[DiagonalFractionBox]={ColumnSpacings->-0.1,Baseline->{0.5,0.3,0.0},KernForSuperscript->-0.15};
DiagonalFractionBox[x_,y_,Opts___?OptionQ]:=Module[
{FullOpts=Flatten[{Opts,Options[DiagonalFractionBox]}]},
TagBox[
StyleBox[
GridBox[
{{
AdjustmentBox[SubscriptBox["",DisplayForm[x]],BoxBaselineShift->-((Baseline/.FullOpts)[[1]])],
AdjustmentBox[SubscriptBox["",StyleForm["/",FontSlant->"Oblique"]],BoxBaselineShift->-((Baseline/.FullOpts)[[2]])],
AdjustmentBox[SubscriptBox["",DisplayForm[y]],BoxBaselineShift->-((Baseline/.FullOpts)[[3]])]
}},
ColumnSpacings->(ColumnSpacings/.FullOpts),GridBaseline->{Bottom,{1,3}}
],
ScriptBaselineShifts->{0,0}
],
DiagonalFractionBox[(KernForSuperscript/.FullOpts)]
]
];


Unprotect[TagBox];
TagBox/:SuperscriptBox[x:TagBox[_,DiagonalFractionBox[Adjustment_]],n_]:=SuperscriptBox[AdjustmentBox[x,BoxMargins->{{0,Adjustment},{0,0}}],n];
Protect[TagBox];


Fractionize[x_?NumericQ,Opts___?OptionQ]/;(Denominator[x]==1):=DisplayForm[x];
Fractionize[x_?NumericQ,Opts___?OptionQ]/;(Denominator[x]!=1):=FractionBox[Numerator[x],Denominator[x],Opts];
f:Fractionize[x_List,Opts___?OptionQ]:=Thread[Unevaluated[f],List,1];


SolidusFractionize[x_?NumericQ,Opts___?OptionQ]/;(Denominator[x]==1):=DisplayForm[x];
SolidusFractionize[x_?NumericQ,Opts___?OptionQ]/;(Denominator[x]!=1):=SolidusFractionBox[Numerator[x],Denominator[x],Opts];
f:SolidusFractionize[x_List,Opts___?OptionQ]:=Thread[Unevaluated[f],List,1];


DiagonalFractionize[x_?NumericQ,Opts___?OptionQ]/;(Denominator[x]==1):=DisplayForm[x];
DiagonalFractionize[x_?NumericQ,Opts___?OptionQ]/;(Denominator[x]!=1):=DiagonalFractionBox[Numerator[x],Denominator[x],Opts];
f:DiagonalFractionize[x_List,Opts___?OptionQ]:=Thread[Unevaluated[f],List,1];


FractionString[x_?NumericQ]:=Module[
{f,NumeratorString,DenominatorString},
f=Rationalize[x];
NumeratorString=ToString[Numerator[f]];
DenominatorString=ToString[Denominator[f]];
Which[
f==0,"0",
Denominator[f]==1,StringJoin[NumeratorString],
Denominator[f]!=1,StringJoin[NumeratorString,"/",DenominatorString]
]
];


PiFractionString[x_?NumericQ]:=Module[
{f,NumeratorString,DenominatorString},
f=Rationalize[x/Pi];
NumeratorString=If[
Numerator[f]==1,
"",
ToString[Numerator[f]]
];
DenominatorString=ToString[Denominator[f]];
Which[
f==0,"0",
Denominator[f]==1,StringJoin[NumeratorString,"\[Pi]"],
Denominator[f]!=1,StringJoin[NumeratorString,"\[Pi]","/",DenominatorString]
]
];


SignString[x_?NumericQ]:=Switch[
Sign[x],
+1,"+",
0,"",
-1,"-"
];


SetAttributes[Sqrtize,Listable];
Sqrtize[x_?NumericQ]:=Which[
(*RationalQ[x],x,*)
RationalQ[x^2],Sign[x]*SqrtBox[x^2],
True,x
];
SetAttributes[Radicalize,Listable];
Radicalize[x_?NumericQ,n_Integer]:=Which[
(*RationalQ[x],x,*)
RationalQ[x^n],Sign[x]*RadicalBox[Abs[x^n],n],
True,x
];


RationalQ[x_]:=(IntegerQ[x]||(Head[x]===Rational));


Options[AlignmentBox]={
AlignmentMarker->"&",
Align->True,
ColumnAlignments->{Right,Left},ColumnSpacings->0
};


BreakString[Separator_,Str_]:=Module[
{PosnList},
PosnList=Join[{{Null,0}},StringPosition[Str,Separator],{{StringLength[Str]+1,Null}}];

Table[StringTake[Str,{PosnList[[i]][[2]]+1,PosnList[[i+1]][[1]]-1}],
{i,1,Length[PosnList]-1}
]
];

AlignmentBox[Str_,Opts___?OptionQ]:=Module[
{
FullOpts=Flatten[{Opts,Options[AlignmentBox]}]
},

CheckOption[Align,True|False,FullOpts];
CheckOption[AlignmentMarker,_String,FullOpts];
StyleBox[
If[
Align/.FullOpts,
GridBox[
{BreakString[(AlignmentMarker/.FullOpts),Str]},
LegacyFilterOptions[GridBox,FullOpts]
],
StringReplace[Str,(AlignmentMarker/.FullOpts)->""]
],
LegacyFilterOptions[StyleBox,FullOpts]
]
];


LaTeXTableEntryValue[Value_?NumericQ]:=Value;
LaTeXTableEntryValue[Str_String]:=Module[
{
FirstNumericPosn,
ErrorBarsPosn,
Value
},

FirstNumericPosn=StringPosition[Str,{"+","-","0","1","2","3","4","5","6","7","8","9","."},1][[1,1]];
ErrorBarsPosn=If[
Length[StringPosition[Str,"(",1]]>=1,
StringPosition[Str,{"(","\[PlusMinus]"},1][[1,1]],
StringLength[Str]+1
];
Value=ToExpression[
StringReplace[
StringTake[Str,{FirstNumericPosn,ErrorBarsPosn-1}],
{"&"->""}
]
];
If[!NumericQ[Value],
Message[LaTeXTableEntryValue::notnumeric,Str,Value]
];
Value
];


Options[SubarrayEllipsis]={Padding->"\[CenterEllipsis]"};
SubarrayEllipsis[m_?MatrixQ,{Rows:(_Integer|Infinity),Columns:(_Integer|Infinity)},OptionsPattern[]]:=Module[
{
RowTrim,ColumnTrim,RowMax,ColumnMax,MatrixTrimmed
},
RowTrim=(Dimensions[m][[1]]>Rows);
RowMax=Min[Dimensions[m][[1]],Rows];
ColumnTrim=(Dimensions[m][[2]]>Columns);
ColumnMax=Min[Dimensions[m][[2]],Columns];

ArrayPad[
m[[1;;RowMax,1;;ColumnMax]],
{{0,If[RowTrim,1,0]},{0,If[ColumnTrim,1,0]}},
OptionValue[Padding]
]
];
SubarrayEllipsis[m_List,{Rows:(_Integer|Infinity)},OptionsPattern[]]:=Module[
{
RowTrim,RowMax,MatrixTrimmed
},
RowTrim=(Dimensions[m][[1]]>Rows);
RowMax=Min[Dimensions[m][[1]],Rows];

ArrayPad[
m[[1;;RowMax]],
{{0,If[RowTrim,1,0]}},
OptionValue[Padding]
]
];


MakeButtonForURL[Contents_,URLString_String?(StringMatchQ[#,"http://*"]&),Opts___?OptionQ]:=DisplayForm[ButtonBox[
Contents,
Opts,
ButtonData:>{URL[URLString],None},ButtonNote->URLString,ButtonFunction->(FrontEndExecute[{FrontEnd`NotebookLocate[#2]}]&),Active->True
]
];


MakeColumnBox[StyleName_String,Columns_Integer,GridBoxOptionsList_List,Contents___List]:=Module[
{GridData},

If[!Mod[Length[{Contents}],Columns==0],
Message[MakeColumnBox::notmult]
];

(* Convert each list into a RowBox *)
GridData=RowBox/@{Contents};
(* Group entries into rows *)
GridData=Partition[GridData,Columns];
(* Convert text styles (created by the LaTeX-like directives) into actual boxes *)
GridData=GridData/.{StyleForm->StyleBox};

(* Make cell containing framed grid of table entries *)
CellPrint[
Cell[BoxData[
FormBox[StyleBox[
FrameBox[
GridBox[GridData]
],
StyleName,GridBoxOptions->GridBoxOptionsList,FontFamily->"Times"
],DisplayForm]
],"Text"]
]

]


MakeCaptionBox[Contents_List]:=Module[
{ContentsData},

If[!Mod[Length[{Contents}],Columns==0],
Message[MakeColumnBox::notmult]
];

(* Convert each list into text data *)
ContentsData=RowBox[Contents];
(* Convert text styles (created by the LaTeX-like directives) into actual boxes *)
ContentsData=ContentsData/.{StyleForm->StyleBox};

(* Make cell *)
CellPrint[
Cell[TextData[ContentsData],"Caption"]
]

];


(* original 2ColumnBox: ColumnWidths->{0.31,0.67}*)
MakeHelpBox["SymbolSummary",Contents___List]:=MakeColumnBox["2ColumnBox",2,{ColumnAlignments->{Right,Left},RowLines->{False},RowSpacings->1.5,ColumnWidths->{0.31,0.65}},Contents];
MakeHelpBox["SymbolSummaryWideDescription",Contents___List]:=MakeColumnBox["2ColumnBox",2,{ColumnAlignments->{Right,Left},RowLines->{False},RowSpacings->1.5,ColumnWidths->{0.26,0.70}},Contents];
(* original 3ColumnBox: {ColumnWidths->0.32} *)
MakeHelpBox["OptionSummary",Contents___List]:=MakeColumnBox["3ColumnBox",3,{ColumnAlignments->{Left},RowLines->{True,False},RowSpacings->1.5,ColumnWidths->{0.32}},
{StyleBox["option name","SO10"]},{StyleBox["default value","SO10"]},{""},
Contents];
MakeHelpBox["OptionSummaryWideDescription",Contents___List]:=MakeColumnBox["3ColumnBox",3,{ColumnAlignments->{Left},RowLines->{True,False},RowSpacings->1.5,ColumnWidths->{0.23,0.23,0.5}},
{StyleBox["option name","SO10"]},{StyleBox["default value","SO10"]},{""},
Contents];
MakeHelpBox["OptionSummaryWideDescriptionContinuation",Contents___List]:=MakeColumnBox["3ColumnBox",3,{ColumnAlignments->{Left},RowLines->{False},RowSpacings->1.5,ColumnWidths->{0.23,0.23,0.5}},
Contents];


NPrint[ArgSeq___]:=Module[
{NArgList},
NArgList=If[NumericQ[#],N[#],#]&/@{ArgSeq};
Print[Sequence@@NArgList]
];


PageBreak:=CellPrint[Cell["",PageBreakBelow->True]];


End[];


Protect[Evaluate[$Context<>"*"]];
Unprotect[Evaluate[$Context<>"$*"]];
EndPackage[];



