(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 5.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1067358,      26837]
NotebookOptionsPosition[   1036110,      25872]
NotebookOutlinePosition[   1037524,      25917]
CellTagsIndexPosition[   1037481,      25914]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 StyleBox["LevelScheme",
  FontFamily->"Times New Roman",
  FontSize->36],
 StyleBox["\n\t",
  FontFamily->"Times New Roman"],
 StyleBox["M. A. Caprio, ", "SmallText",
  FontFamily->"Times New Roman",
  FontSize->12],
 "Department of Physics, University of Notre Dame"
}], "Chapter",
 CellChangeTimes->{{3.411677728390625*^9, 3.41167773678125*^9}}],

Cell[CellGroupData[{

Cell["Header comments", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Title", ":", " ", "LevelScheme"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Context", ":", " ", "LevelScheme`LevelScheme`"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Summary", ":", " ", 
     RowBox[{
     "Scientific", " ", "figure", " ", "preparation", " ", "system"}]}]}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"Author", ":", " ", 
      RowBox[{"Mark", " ", 
       RowBox[{"A", ".", " ", "Caprio"}]}]}]}], ",", " ", 
    RowBox[{"Department", " ", "of", " ", "Physics"}], ",", " ", 
    RowBox[{"University", " ", "of", " ", "Notre", " ", "Dame"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", "Copyright", ":", " ", 
     RowBox[{"Copyright", " ", "2013"}]}], ",", " ", 
    RowBox[{"Mark", " ", 
     RowBox[{"A", ".", " ", "Caprio"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Package", " ", "Version"}], ":", " ", "3.53"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Mathematica", " ", "Version"}], ":", " ", "9.0"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", "History", ":", "\[IndentingNewLine]", 
     RowBox[{"Early", " ", "ancestor", " ", "code"}]}], ",", " ", 
    RowBox[{
     RowBox[{"July", " ", "1999."}], "\n", "   ", 
     RowBox[{"V1", ".00"}]}], ",", " ", 
    RowBox[{"January", " ", "2004", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"first", " ", "web", " ", "release"}], ")"}], ".", " ", 
      "\[IndentingNewLine]", "V2"}], ".00"}], ",", " ", 
    RowBox[{
     RowBox[{"November", " ", "2004."}], "  ", "\[IndentingNewLine]", " ", 
     RowBox[{"V3", ".00"}]}], ",", " ", 
    RowBox[{
     RowBox[{"March", " ", "2005."}], "\[IndentingNewLine]", " ", 
     RowBox[{"V3", ".01"}]}], ",", " ", 
    RowBox[{"March", " ", "2005.", "\[IndentingNewLine]", " ", 
     StyleBox["V3",
      FontFamily->"Courier New"], 
     StyleBox[".02",
      FontFamily->"Courier New"]}], 
    StyleBox[",",
     FontFamily->"Courier New"], 
    StyleBox[" ",
     FontFamily->"Courier New"], 
    RowBox[{
     StyleBox["April",
      FontFamily->"Courier New"], 
     StyleBox[" ",
      FontFamily->"Courier New"], 
     StyleBox["2005.",
      FontFamily->"Courier New"], "\[IndentingNewLine]", " ", "V3", ".10"}], 
    ",", " ", 
    RowBox[{"April", " ", "2005", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"CPCPL", " ", "distribution"}], ")"}], ".", 
      "\[IndentingNewLine]", "V3"}], ".11"}], ",", " ", 
    RowBox[{
     RowBox[{"May", " ", "2005."}], "\n", "   ", 
     RowBox[{"V3", ".20"}]}], ",", " ", 
    RowBox[{
     RowBox[{"October", " ", "2005."}], "\n", "   ", 
     RowBox[{"V3", ".21"}]}], ",", " ", 
    RowBox[{
     RowBox[{"October", " ", "2005."}], "\[IndentingNewLine]", " ", 
     RowBox[{"V3", ".30"}]}], ",", " ", 
    RowBox[{"July", " ", "2007.", "\n", "V3", ".40"}], ",", " ", 
    RowBox[{"August", " ", "2007.", "\n", "V3", ".41"}], ",", " ", 
    RowBox[{"September", " ", "2007.", "\n", "V3", ".42"}], ",", " ", 
    RowBox[{"September", " ", "2008.", "\n", "V3", ".43"}], ",", " ", 
    RowBox[{"November", " ", "2008.", "\n", "V3", ".44"}], ",", " ", 
    RowBox[{"February", " ", "2009.", "\n", "V3", ".45"}], ",", " ", 
    RowBox[{"December", " ", "2009.", "\n", "V3", ".50"}], ",", " ", 
    RowBox[{"November", " ", "2010.", "\n", "V3", ".51"}], ",", " ", 
    RowBox[{"February", " ", "2011.", "\n", "V3", ".52"}], ",", " ", 
    RowBox[{"September", " ", "2011.", "\n", "V3", ".53"}], ",", " ", 
    RowBox[{"January", " ", "2013."}]}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", "Discussion", ":", "\n", " ", 
     RowBox[{
     "The", " ", "LevelScheme", " ", "package", " ", "has", " ", "been", " ", 
      "published", " ", "in", " ", "Computer", " ", "Physics", " ", 
      "Communications"}]}], ",", " ", 
    RowBox[{"M", ".", " ", "A", ".", " ", "Caprio"}], ",", " ", 
    RowBox[{"Comput", ".", " ", "Phys", ".", " ", "Commun", ".", " ", "171"}],
     ",", " ", 
    RowBox[{"107", " ", 
     RowBox[{
      RowBox[{"(", "2005", ")"}], ".", "  ", "Updates"}], " ", "and", " ", 
     "further", " ", "information", " ", "may", " ", "be", " ", "obtained", 
     " ", "through", " ", "the", " ", "LevelScheme", " ", "home", " ", 
     "page"}], ",", " ", 
    RowBox[{
     RowBox[{"www", ".", "levelscheme", ".", "org", ".", "  ", "If"}], " ", 
     "you", " ", "modify", " ", "the", " ", "software"}], ",", " ", 
    RowBox[{
    "you", " ", "*", "must", "*", " ", "change", " ", "the", " ", "package", 
     " ", "name", " ", "and", " ", "*", "must", "*", " ", "change", " ", 
     "the", " ", "message", " ", "displayed", " ", "when", " ", "the", " ", 
     "package", " ", "is", " ", "loaded"}], ",", " ", 
    RowBox[{
    "to", " ", "clearly", " ", "indicate", " ", "that", " ", "the", " ", 
     "package", " ", "is", " ", "a", " ", "modified", " ", 
     RowBox[{"version", "."}]}]}], "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 AutoIndent->False,
 CellChangeTimes->{{3.395093723328125*^9, 3.39509375184375*^9}, {
   3.398545735296875*^9, 3.39854574365625*^9}, 3.398799700609375*^9, {
   3.43024739209375*^9, 3.43024739990625*^9}, 3.430247813015625*^9, {
   3.436819738734375*^9, 3.436819746828125*^9}, 3.436820195484375*^9, {
   3.4439959535*^9, 3.4439959773125*^9}, {3.471089562875*^9, 
   3.471089568359375*^9}, {3.471089636203125*^9, 3.471089639046875*^9}, {
   3.48681044459375*^9, 3.4868104458125*^9}, {3.489687811140625*^9, 
   3.489687812484375*^9}, {3.497222348765625*^9, 3.497222354953125*^9}, 
   3.497224390546875*^9, {3.497299514859375*^9, 3.497299515046875*^9}, {
   3.49903536659375*^9, 3.49903536784375*^9}, {3.503265433671875*^9, 
   3.5032654415*^9}, {3.50612390383225*^9, 3.5061239087385*^9}, 
   3.507509920109375*^9, {3.525523519921875*^9, 3.52552352703125*^9}, {
   3.566837758611201*^9, 3.566837765761211*^9}, {3.566838556746784*^9, 
   3.5668385824753485`*^9}},
 LanguageCategory->"NaturalLanguage"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin package", "Section"],

Cell[CellGroupData[{

Cell["Package context definition", "Subsection"],

Cell["\<\
Declare package context, read in packages which should be visible to the \
user, and unprotect all symbols in current context in case package is read in \
over itself.\
\>", "Text"],

Cell[TextData[{
 "Provided packages:\n\tCustomTicks` is provided for the user's benefit, used \
internally for tick processing.\n\tMCText` is provided for the user's \
benefit.\n\tForEach` is provided for the user's benefit, also used \
internally.\n\tBlockOptions` is provided for symbol BlockOptions, also used \
internally for dynamic scoping of option values.\n\tInheritOptions` is \
provided so that the user can access the symbol Inherited, also used \
internally for option processing.\n\tClipToRectangle` is provided so that the \
user can access the symbol ClipToRectangle, also used internally by drawing \
functions.\n\tGraphics`Common`GraphicsCommon` is provided to avoid hiding \
ScaleFactor.  (Eliminated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 9.)\n\tLegacyColors` is provided for the user's benefit.\n\t\
NamedColorPalette` is provided so user can directly launch palette, also used \
internally for palette pop-up button."
}], "Text",
 CellChangeTimes->{{3.39508774165625*^9, 3.395087742265625*^9}, {
   3.395087773609375*^9, 3.395087773859375*^9}, {3.395090593546875*^9, 
   3.39509059396875*^9}, 3.395090637203125*^9, {3.395090677359375*^9, 
   3.3950906781875*^9}, {3.395091141296875*^9, 3.39509117134375*^9}, {
   3.395518963640625*^9, 3.3955189995625*^9}, {3.39551904921875*^9, 
   3.395519068234375*^9}, {3.566837100436349*^9, 3.566837127186387*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", 
   RowBox[{"\"\<LevelScheme`\>\"", ",", 
    RowBox[{"Join", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "\"\<CustomTicks`\>\"", ",", "\[IndentingNewLine]", 
        "\"\<BlockOptions`\>\"", ",", "\[IndentingNewLine]", 
        "\"\<InheritOptions`\>\"", ",", "\[IndentingNewLine]", 
        "\"\<ForEach`\>\"", ",", "\[IndentingNewLine]", 
        "\"\<ClipToRectangle`\>\"", ",", "\[IndentingNewLine]", 
        "\"\<NamedColors`\>\"", ",", "\[IndentingNewLine]", 
        "\"\<LevelScheme`MCText`\>\""}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"$VersionNumber", "<", "9"}], ",", 
        RowBox[{"{", "\"\<Graphics`Common`GraphicsCommon`\>\"", "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395087747453125*^9, 3.39508775096875*^9}, {
   3.39509064290625*^9, 3.395090643234375*^9}, 3.395090710546875*^9, {
   3.395091175015625*^9, 3.395091179703125*^9}, {3.395093472375*^9, 
   3.39509347784375*^9}, {3.395093608140625*^9, 3.3950936085*^9}, {
   3.395519039875*^9, 3.395519061546875*^9}, {3.495041989453125*^9, 
   3.495042010953125*^9}, {3.495042158078125*^9, 3.495042163671875*^9}, {
   3.497222416421875*^9, 3.497222462578125*^9}, {3.497222963890625*^9, 
   3.497222994640625*^9}, 3.497223030953125*^9, {3.51613619428125*^9, 
   3.5161362795*^9}, {3.516136364328125*^9, 3.51613637959375*^9}, 
   3.516136439078125*^9, 3.51613650503125*^9, {3.525525796546875*^9, 
   3.525525830921875*^9}, {3.5668371497764187`*^9, 3.566837204656495*^9}, {
   3.5668373630923033`*^9, 3.5668373781823244`*^9}, 3.566838616125396*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"$Context", "<>", "\"\<*\>\""}], "]"}], "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version-specific configuration", "Subsection",
 CellChangeTimes->{{3.398810358859375*^9, 3.3988103635625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "LevelSchemeRevisionString", "=", "\"\<3.53 (January 10, 2013)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "LevelSchemeHomePageURL", "=", 
   "\"\<http://scidraw.nd.edu/levelscheme/landing/levelscheme-3.53.html\>\""}]\
, ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395093759515625*^9, 3.39509380640625*^9}, {
   3.3955242503125*^9, 3.3955242775*^9}, {3.395524400171875*^9, 
   3.3955244023125*^9}, {3.396268347734375*^9, 3.396268400109375*^9}, {
   3.396543732125*^9, 3.3965437368125*^9}, {3.39687832734375*^9, 
   3.39687832746875*^9}, {3.398545138328125*^9, 3.398545160234375*^9}, 
   3.39854552634375*^9, {3.398801181671875*^9, 3.398801186328125*^9}, 
   3.39881022871875*^9, 3.39881026321875*^9, {3.39881036725*^9, 
   3.3988103698125*^9}, {3.399734881765625*^9, 3.399734881921875*^9}, {
   3.41055887696875*^9, 3.41055888021875*^9}, {3.41124724875*^9, 
   3.411247274984375*^9}, {3.4112473493125*^9, 3.41124735415625*^9}, {
   3.417537949140625*^9, 3.417537959390625*^9}, 3.417538129125*^9, {
   3.4206605533125*^9, 3.420660554875*^9}, {3.421623418359375*^9, 
   3.42162341925*^9}, {3.42445916384375*^9, 3.424459166046875*^9}, {
   3.426015357734375*^9, 3.426015357890625*^9}, {3.428252598609375*^9, 
   3.4282525996875*^9}, {3.430247413375*^9, 3.430247421078125*^9}, {
   3.43126081609375*^9, 3.43126081928125*^9}, {3.43448491978125*^9, 
   3.43448492225*^9}, {3.436819946296875*^9, 3.436819956078125*^9}, {
   3.438373670139573*^9, 3.438373677030198*^9}, {3.441572541802*^9, 
   3.441572543036375*^9}, {3.443996005875*^9, 3.443996013796875*^9}, {
   3.450567436052453*^9, 3.4505674452866507`*^9}, {3.456346719859375*^9, 
   3.45634672090625*^9}, {3.45998300846875*^9, 3.459983043234375*^9}, 
   3.46012539846875*^9, {3.46083061403125*^9, 3.460830623890625*^9}, 
   3.461088025125*^9, {3.46108849065625*^9, 3.4610884910625*^9}, {
   3.464467969984375*^9, 3.46446797225*^9}, {3.467757918078125*^9, 
   3.467757920484375*^9}, {3.46995764359375*^9, 3.469957647328125*^9}, {
   3.47108957571875*^9, 3.47108958221875*^9}, {3.4799293410625*^9, 
   3.47992934909375*^9}, {3.48252656396875*^9, 3.482526564265625*^9}, {
   3.48468697009375*^9, 3.484686971515625*^9}, {3.486810453390625*^9, 
   3.486810453578125*^9}, {3.48883837915625*^9, 3.488838380359375*^9}, {
   3.489689744921875*^9, 3.489689746640625*^9}, {3.492012690578125*^9, 
   3.49201269071875*^9}, {3.49566046240625*^9, 3.495660495828125*^9}, {
   3.496875374421875*^9, 3.49687537915625*^9}, 3.497222361828125*^9, 
   3.4972995071875*^9, 3.49738323434375*^9, {3.497534234*^9, 
   3.49753423409375*^9}, {3.499035376390625*^9, 3.499035383484375*^9}, {
   3.502552490671875*^9, 3.5025524978125*^9}, {3.50326541846875*^9, 
   3.503265421390625*^9}, {3.505410662140625*^9, 3.505410662375*^9}, {
   3.506123912972875*^9, 3.5061239187385*^9}, {3.50750974884375*^9, 
   3.5075097489375*^9}, {3.510069596171875*^9, 3.510069604734375*^9}, {
   3.5119690405*^9, 3.511969041578125*^9}, {3.516136394125*^9, 
   3.516136394890625*^9}, {3.516821646375*^9, 3.516821646546875*^9}, {
   3.52552353653125*^9, 3.525523552625*^9}, {3.525523588484375*^9, 
   3.5255235939375*^9}, {3.52552418015625*^9, 3.525524181296875*^9}, {
   3.525809171505125*^9, 3.52580919627075*^9}, 3.525809269552*^9, {
   3.5668385905853605`*^9, 3.566838603195378*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["External configuration flags", "Subsection",
 CellChangeTimes->{{3.443994457375*^9, 3.443994461890625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"ValueQ", "[", "LevelScheme`Config`Splash", "]"}]}], ",", 
    RowBox[{"LevelScheme`Config`Splash", "=", "True"}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.443994463125*^9, 3.44399447053125*^9}, {
  3.443994512859375*^9, 3.443994560296875*^9}, {3.497224396421875*^9, 
  3.49722439940625*^9}, {3.497224440125*^9, 3.497224441453125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " version flag message"
}], "Subsection",
 CellChangeTimes->{{3.39551529709375*^9, 3.39551530159375*^9}, {
  3.39881031675*^9, 3.39881032040625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "mathversion"}], "=", 
   "\"\<This version of LevelScheme requires Mathematica 6 or higher.  You \
are currently running Mathematica `1`.  Please visit the LevelScheme home \
page to download a legacy version of LevelScheme which will run under your \
version of Mathematica.\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.456346734640625*^9, 3.45634675996875*^9}, 
   3.456346807578125*^9, {3.4563468391875*^9, 3.456346846609375*^9}, {
   3.456346957953125*^9, 3.456346964796875*^9}, 3.507509768578125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$VersionNumber", "<", "6.0"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"LevelScheme", "::", "mathversion"}], ",", 
       RowBox[{"IntegerPart", "[", "$VersionNumber", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Abort", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395515425421875*^9, 3.395515556828125*^9}, {
  3.395515586859375*^9, 3.395515853921875*^9}, {3.3955159191875*^9, 
  3.395515920640625*^9}, {3.395515954171875*^9, 3.395515984609375*^9}, {
  3.39654378584375*^9, 3.396543820328125*^9}, {3.398545170921875*^9, 
  3.3985451744375*^9}, {3.3985452474375*^9, 3.39854528821875*^9}, {
  3.456346776828125*^9, 3.45634680046875*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Messages", "Section"],

Cell[CellGroupData[{

Cell["Generic parent object", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SchemeObject", "::", "usage"}], "=", 
   "\"\<Parent object for option inheritance for level scheme objects.\>\""}],
   ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generic rendering options", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Color", "::", "usage"}], "=", 
   "\"\<Option for level scheme drawing objects.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Opacity", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], " ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowLine", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LineColor", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LineOpacity", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Thickness", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], "  ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Dashing", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], "  ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CapForm", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], "  ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DashingGap", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DashingCorrection", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowFill", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FillColor", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FillOpacity", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "FontXXXXXX", " ", "options", " ", "are", " ", "all", " ", "from", " ", 
    RowBox[{"System`", "."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Show", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], " ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Tooltip", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], " ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Layer", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Tag", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConditionalOptions", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3950877775*^9, 3.3950878165625*^9}, 
   3.3955199864375*^9, {3.396634096515625*^9, 3.396634120734375*^9}, {
   3.396634182421875*^9, 3.39663418646875*^9}, {3.431539593640625*^9, 
   3.431539606453125*^9}, {3.465140532265625*^9, 3.465140534453125*^9}, {
   3.486810152875*^9, 3.486810156453125*^9}, {3.4960545955*^9, 
   3.4960546405*^9}, 3.5025550971875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generic text label options", "Subsection"],

Cell["\<\
\tNot all possible options for all labels are presently used, but they are \
reserved here anyway.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowText", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Offset", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], "   ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Nudge", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Orientation", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Background", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], "   ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundOpacity", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LabL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowLabL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OffsetL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NudgeL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OrientationL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundOpacityL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PosnL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BufferL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AboveKinkL", "::", "usage"}], "=", 
   "\"\<Option for level scheme drawing objects.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SegmentL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LabR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowLabR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OffsetR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NudgeR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OrientationR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundOpacityR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PosnR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BufferR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AboveKinkR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SegmentR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LabT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowLabT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OffsetT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NudgeT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OrientationT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundOpacityT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PosnT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BufferT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AboveKinkT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SegmentT", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LabB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowLabB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OffsetB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NudgeB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OrientationB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundOpacityB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PosnB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BufferB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AboveKinkB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SegmentB", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LabC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowLabC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OffsetC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NudgeC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OrientationC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundOpacityC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PosnC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BufferC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AboveKinkC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SegmentC", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LabX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowLabX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OffsetX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NudgeX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OrientationX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BackgroundOpacityX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PosnX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BufferX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AboveKinkX", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SegmentX", "::", "usage"}], "=", 
   "\"\<Option for level scheme drawing objects.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.396636409859375*^9, 3.396636436390625*^9}, {
  3.39663648990625*^9, 3.39663653065625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tick mark control options", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Ticks", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], " ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickShowLine", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickLineColor", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickLineOpacity", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickThickness", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickFontColor", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickFontOpacity", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickFontFamily", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickFontSize", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickFontSlant", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickFontTracking", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickFontWeight", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickBackground", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickBackgroundOpacity", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickNudge", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39663442825*^9, 3.396634432890625*^9}, {
  3.42445872534375*^9, 3.424458734640625*^9}, {3.4699572723125*^9, 
  3.4699572938125*^9}, {3.46995735384375*^9, 3.46995735503125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Panel letter control options", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterFontColor", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterFontOpacity", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterFontFamily", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterFontSize", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterFontSlant", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterFontTracking", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterFontWeight", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowPanelLetter", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PanelLetterOffset", "::", "usage"}], "=", 
   "\"\<Option for level scheme drawing objects.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterNudge", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterOrientation", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterBackground", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterBackgroundOpacity", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PanelLetterOrigin", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39663441440625*^9, 3.39663441934375*^9}, {
  3.396636535953125*^9, 3.3966365574375*^9}, {3.434484655296875*^9, 
  3.434484661703125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Specialized drawing options", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Margin", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EnergyLabelFunction", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EnergyNudge", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"WingHeight", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"WingRiseWidth", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"WingTipWidth", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeWingL", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeWingR", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ToWing", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FromWing", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LineToFront", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects. (UNDOCUMENTED)\>\""}], 
   ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EndPositions", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ArrowType", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ArrowHalf", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects. (UNDOCUMENTED)\>\""}], 
   ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Width", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SquiggleWavelength", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SquiggleSide", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SquiggleBuffer", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PlotPoints", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TailBevel", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShaftLines", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HeadLength", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  RowBox[{"(*", "Graphics`Arrow`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HeadLip", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Kink", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowHead", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowTail", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HeadRecess", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TailRecess", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConversionColor", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConversionSide", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConversionCoeff", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CallOutVector", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], " "}], "\n", 

 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Gap", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.48820014584375*^9, 3.488200155390625*^9}}],

Cell["Options for Scheme not already defined above", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Frame", "::", "reusage"}], "=", "\"\<Option for Scheme.\>\""}], 
   ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FrameLabel", "::", "reusage"}], "=", 
    "\"\<Option for Scheme.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FrameTicks", "::", "reusage"}], "=", 
    "\"\<Option for Scheme.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Axes", "::", "reusage"}], "=", "\"\<Option for Scheme.\>\""}], 
   ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PlotRange", "::", "reusage"}], "=", 
    "\"\<Option for Scheme.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ImageSize", "::", "reusage"}], "=", 
    "\"\<Option for Scheme.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DisplayFunction", "::", "reusage"}], "=", 
    "\"\<Option for Scheme.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeFlags", "::", "usage"}], "=", 
   "\"\<Option for Scheme.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BlockOptions", "::", "reusage"}], "=", 
    "\"\<Option for Scheme.\>\""}], ";"}], 
  RowBox[{"(*", "BlockOptions`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Information", "::", "reusage"}], "=", 
    "\"\<Option for Scheme. (UNDOCUMENTED)\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Debug", "::", "reusage"}], "=", 
    "\"\<Option for Scheme. (UNDOCUMENTED)\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Inverted", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LineArrow", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MultilineArrow", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SquiggleArrow", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShapeArrow", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FromHead", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FromTail", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FromHeadVertical", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FromTailVertical", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FromHeadHorizontal", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FromTailHorizontal", "::", "usage"}], "=", 
   "\"\<Option value for level scheme drawing objects.\>\""}], 
  ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordinate system control and conversion", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetOrigin", "::", "usage"}], "=", 
   "\"\<SetOrigin[x] or SetOrigin[pt] sets the origin of the user coordinate \
system.  SetOrigin[] clears the definition.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetScale", "::", "usage"}], "=", 
   "\"\<SetScale[yfactor] or SetScale[{xfactor,yfactor}] sets the scaling of \
the user coordinate system.  SetScale[] clears the definition.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetRegion", "::", "usage"}], "=", 
   "\"\<SetRegion[{{xc1,xc2},{yc1,yc2}},{{xr1,xr2},{yr1,yr2}}] sets the \
region coordinate system and clipping box.  Any existing user coordinate \
definitions (origin or scale) are cleared.  SetRegion[] resets the region to \
the full canvas.\>\""}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "::", "usage"}], "=", 
   "\"\<ConvertCoordinate[system,[newsystem],{x,y},[D]] or \
ConvertCoordinate[system,[newsystem],axis,x,[D]] carries out coordinate \
system conversion.  The systems can be specified to be CanvasCoords, \
RegionCoords, UserCoords, AbsoluteCoords, or ScaledCoords, and by default \
conversion is to UserCoords.  The axis may be Horizontal or Vertical, for X \
or Y coordinate conversion.  The argument D indicates displacement (rather \
than coordinate) conversion.  LEGACY SYNTAX: \
ConvertCoordinate[system,newsystem,C|D,{x,y}] or \
ConvertCoordinate[system,newsystem,C|D,1|2,x].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertRange", "::", "usage"}], "=", 
   "\"\<ConvertRange[system,[newsystem],axis,{x1,x2},[D]] carries out \
coordinate system conversion for X or Y ranges.  The arguments have similar \
meanings as for ConvertCoordinate. LEGACY SYNTAX: \
ConvertRange[system,newsystem,C|D,{x1,x2},1|2]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertRegion", "::", "usage"}], "=", 
   "\"\<ConvertRegion[system,[newsystem],{{x1,x2},{y1,y2}},[D]] carries out \
coordinate system conversion for regions.  The arguments have similar \
meanings as for ConvertCoordinate. LEGACY SYNTAX: \
ConvertRegion[system,newsystem,C|D,{{x1,x2},{y1,y2}}]\>\""}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.484772785*^9, 3.484772828390625*^9}, {
  3.484774099796875*^9, 3.484774258515625*^9}, {3.48477474921875*^9, 
  3.484774815890625*^9}, {3.505336186671875*^9, 3.50533618821875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"C", "::", "reusage"}], "=", 
    "\"\<Conversion type identifier for ConvertCoordinate.\>\""}], ";"}], " ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "::", "reusage"}], "=", 
    "\"\<Conversion type identifier for ConvertCoordinate.\>\""}], ";"}], " ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CanvasCoords", "::", "usage"}], "=", 
   "\"\<Level scheme drawing coordinate system identifier.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AbsoluteCoords", "::", "usage"}], "=", 
   "\"\<Level scheme drawing coordinate system identifier.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RegionCoords", "::", "usage"}], "=", 
   "\"\<Level scheme drawing coordinate system identifier.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScaledCoords", "::", "usage"}], "=", 
   "\"\<Level scheme drawing coordinate system identifier.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UserCoords", "::", "usage"}], "=", 
   "\"\<Level scheme drawing coordinate system identifier.\>\""}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SavePoint", "::", "usage"}], "=", 
   "\"\<SavePoint[ID,{x,y}] or SavePoint[ID,{x,y},system] saves the canvas \
position of the given point.  If no coordinate system is specified, it is \
assumed {x,y} are the coordinates in the current user coordinate \
system.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GetPoint", "::", "usage"}], "=", 
   "\"\<GetPoint[ID] or GetPoint[ID,system] returns the position of the \
previously saved point, converted to the presently-defined coordinate \
systems.  If no coordinate system is specified, the point is given in the \
current user coordinates.\>\""}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure display", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Figure", "::", "usage"}], "=", 
   "\"\<Figure[list] returns a drawing constructed from the objects in \
list.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExtendRange", "::", "reusage"}], "=", 
    "\"\<Option for Figure.\>\""}], ";"}], " ", 
  RowBox[{"(*", " ", "LevelScheme`", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeDef", "::", "usage"}], "=", 
   "\"\<SchemeDef[Flag] returns True or False depending whether or not Flag \
is defined in the SchemeFlags option.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeIf", "::", "usage"}], "=", 
   "\"\<SchemeIf[condition,Object1,...] evaluates objects and splices them \
into the figure only if condition is True.\>\""}], ";", 
  RowBox[{
   RowBox[{"SchemeIfDef", "::", "usage"}], "=", 
   "\"\<SchemeIfDef[Flag,Object1,...] evaluates objects and splices them into \
the figure only if Flag is defined in the SchemeFlags option.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeIfNDef", "::", "usage"}], "=", 
   "\"\<SchemeIfNDef[Flag,Object1,...] evaluates objects and splices them \
into the figure only if Flag is *not* defined in the SchemeFlags \
option.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeIfElseDef", "::", "usage"}], "=", 
   "\"\<SchemeIfDef[Flag,Object1,Object2] evaluates objects and splices them \
into the figure depending whether or not Flag is defined in the SchemeFlags \
option.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.428171401015625*^9, 3.428171424640625*^9}, {
  3.428173899390625*^9, 3.428173915578125*^9}, {3.42817765209375*^9, 
  3.4281776524375*^9}, {3.454768622234375*^9, 3.454768647*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Level objects", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Lev", "::", "usage"}], "=", 
   "\"\<Lev[ID,x1,x2,Energy] is a level scheme drawing object.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtensionLine", "::", "usage"}], "=", 
   "\"\<ExtensionLine[ID,position1,position2] or \
ExtensionLine[ID,side,length] is a level scheme drawing object.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LastLevel", "::", "usage"}], "=", 
   "\"\<LastLevel is a global variable containing the ID of the most recently \
defined level.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelEnergy", "::", "usage"}], "=", 
   "\"\<LevelEnergy[ID] returns the energy value (user coordinate) specified \
when the given level was defined.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Connector", "::", "usage"}], "=", 
   "\"\<Connector[ID1,ID2] is a level scheme drawing object.\>\""}], 
  ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transition arrow objects", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Trans", "::", "usage"}], "=", 
   "\"\<Trans[ID1,position1,ID2,position2] or Trans[ID1,ID2] or \
Trans[pt1,pt2] is a level scheme drawing object.\>\""}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Drawing shape objects", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SchemeLine", "::", "usage"}], "=", 
   "\"\<SchemeLine[{pt1,pt2,...}] or SchemeLine[graphics] is a level scheme \
drawing object.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemePolygon", "::", "usage"}], "=", 
   "\"\<SchemePolygon[{pt1,pt2,...}] is a level scheme drawing object.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeCircle", "::", "usage"}], "=", 
   "\"\<SchemeCircle[pt,radius] or SchemeCircle[pt,radius,{theta1,theta2}] is \
a level scheme drawing object.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeEllipse", "::", "usage"}], "=", 
   "\"\<SchemeEllipse[pt,{r1,r2}] or SchemeEllipse[pt,{r1,r2},theta] or \
SchemeEllipse[pt,{r1,r2},theta,{theta1,theta2}] is a level scheme drawing \
object.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBox", "::", "usage"}], "=", 
   "\"\<SchemeBox[{{x1,x2},{y1,y2}}] or SchemeBox[pt1,pt2] is a level scheme \
drawing object.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeSquare", "::", "usage"}], "=", 
   "\"\<SchemeSquare[pt,radius] is a level scheme drawing object.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeArrow", "::", "usage"}], "=", 
   "\"\<SchemeArrow[pt1,pt2] is a level scheme drawing object.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBracket", "::", "usage"}], "=", 
   "\"\<SchemeBracket[Bottom|Top,{x1,x2},y] or \
SchemeBracket[Left|Right,x,{y1,y2}] is a level scheme drawing object.  Level \
IDs may be specified instead of coordinates, as in \
SchemeBracket[Bottom|Top,{ID1,ID2},y] or \
SchemeBracket[Left|Right,x,{ID1,ID2}] or \
SchemeBracket[Bottom|Top,{x1,x2},ID,EnergyNudge->...].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeLine3D", "::", "usage"}], "=", 
   "\"\<SchemeLine3D[{pt1,pt2,...}] is a 3D analogue of a level scheme \
drawing object.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeArrow3D", "::", "usage"}], "=", 
   "\"\<SchemeArrow3D[pt1,pt2] or SchemeArrow3D[pt1,pt2,headangle] is a 3D \
analogue of a level scheme drawing object.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.410558827875*^9, 3.4105588351875*^9}, {
  3.44157238214575*^9, 3.441572386130125*^9}, {3.461095432421875*^9, 
  3.4610954850625*^9}, {3.49229037778125*^9, 3.49229042996875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Label objects", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ManualLabel", "::", "usage"}], "=", 
   "\"\<ManualLabel[pt,text] is a level scheme drawing object.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ScaledLabel", "::", "usage"}], "=", 
   "\"\<ScaledLabel[scaledpt,text] is a level scheme drawing object.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"BandLabel", "::", "usage"}], "=", 
   "\"\<BandLabel[ID,text] or BandLabel[ID,position,text] is a level scheme \
drawing object.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelLabel", "::", "usage"}], "=", 
   "\"\<LevelLabel[ID,position,text] is a level scheme drawing object.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ManualLabel3D", "::", "usage"}], "=", 
   "\"\<ManualLabel3D[pt,text] is a 3D analogue of a level scheme drawing \
object.\>\""}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics inclusion", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RawGraphics", "::", "usage"}], "=", 
   "\"\<RawGraphics[graphics1,...] is a level scheme drawing object which \
includes Graphics, ContourGraphics, or DensityGraphics objects in the scheme.\
\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FigGraphics", "::", "usage"}], "=", 
   "\"\<FigGraphics[{{x1,x2},{y1,y2}},graphics] or \
FigGraphics[{{x1,x2},{y1,y2}},image] is a level scheme drawing object which \
includes Mathematica-generated or imported graphics within a figure.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RawGraphics3D", "::", "usage"}], "=", 
   "\"\<RawGraphics3D[graphics1,...] is a level scheme drawing object.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ClipToRectangle", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], " ", 
  RowBox[{"(*", "ClipToRectangle`", "*)"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.488282361890625*^9, 3.488282461328125*^9}, {
  3.488832969359375*^9, 3.48883299575*^9}, {3.488833053546875*^9, 
  3.488833070015625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ViewPort3D", "::", "usage"}], "=", 
   "\"\<ViewPort3D[{graphics,...},{{x1,x2},{y1,y2}}] is a level scheme \
drawing object which includes three-dimensional graphics objects in the \
scheme.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScaledViewPort3D", "::", "usage"}], "=", 
   "\"\<ScaledViewPort3D[{graphics,...},{{x1s,x2s},{y1s,y2s}}] is a level \
scheme drawing object which includes three-dimensional graphics objects in \
the scheme.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AxisScaling", "::", "usage"}], "=", 
   "\"\<Option for ViewPort3D.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EulerRotation", "::", "usage"}], "=", 
   "\"\<Option for ViewPort3D.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395091929890625*^9, 3.395091937828125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Axes and panels", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SchemeAxis", "::", "usage"}], "=", 
   "\"\<SchemeAxis[Bottom|Top,{x1,x2},y] or SchemeAxis[Left|Right,x,{y1,y2}] \
generates a freestanding axis.  \
SchemeAxis[{Bottom|Top,Left|Right},{{x1,x2},{y1,y2}}] generates crossed \
horizontal and vertical axes.  The crossing point may be specified with the \
option AxesOrigin.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FigurePanel", "::", "usage"}], "=", 
   "\"\<FigurePanel[{{xc1,xc2},{yc1,yc2}}] sets the region coordinate system \
and draws a panel frame, labels, and fill.  The panel position is specified \
in canvas coordinates.  FigurePanel[] produces a panel covering the full \
canvas.  FigurePanel[{row,column}] generates a panel of a multipanel \
plot.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScaledFigurePanel", "::", "usage"}], "=", 
   "\"\<ScaledFigurePanel[{{xs1,xs2},{ys1,ys2}}] sets the region coordinate \
system and draws a panel frame, labels, and fill.  The panel position is \
specified in scaled coordinates relative to the present plotting \
region.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PlotRange", "::", "reusage"}], "=", 
    "\"\<Option for FigurePanel.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XPlotRange", "::", "usage"}], "=", 
   "\"\<Option for FigurePanel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YPlotRange", "::", "usage"}], "=", 
   "\"\<Option for FigurePanel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowEdge", "::", "usage"}], "=", 
   "\"\<Option for level scheme drawing objects.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TickLabelMargin", "::", "usage"}], "=", 
   "\"\<Option for FigurePanel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Multipanel", "::", "usage"}], "=", 
   "\"\<Multipanel[{{xc3,xc4},{yc3,yc4}},{rows,columns}] initializes \
automatic multipanel plotting.  Multipanel[{rows,columns}] produces a \
multipanel plot covering the full canvas.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XPlotRanges", "::", "usage"}], "=", 
   "\"\<Option for Multipanel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YPlotRanges", "::", "usage"}], "=", 
   "\"\<Option for Multipanel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XFrameTicks", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YFrameTicks", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XFrameLabels", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YFrameLabels", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XPanelSizes", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YPanelSizes", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XGapSizes", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YGapSizes", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XMarginSizes", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YMarginSizes", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PanelShift", "::", "usage"}], "=", 
   "\"\<Option for Panel, only relevant when used with automatic panel \
generation.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PanelAdjustments", "::", "usage"}], "=", 
   "\"\<Option for Panel, only relevant when used with automatic panel \
generation.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowTicks", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowTickLabels", "::", "reusage"}], "=", 
    "\"\<Option for automatic panel generation.\>\""}], ";"}], 
  RowBox[{"(*", "CustomTicks`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowTickLabelsExterior", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowTickLabelsInterior", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowFrameLabels", "::", "reusage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowFrameLabelsExterior", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowFrameLabelsInterior", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExteriorMask", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TickLabelAutoSuppress", "::", "usage"}], "=", 
   "\"\<Option for automatic panel generation.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PanelLetterCorner", "::", "usage"}], "=", 
   "\"\<Option for level scheme drawing objects.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PanelLetterInset", "::", "usage"}], "=", 
   "\"\<Option for Panel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PanelLetter", "::", "usage"}], "=", 
   "\"\<PanelLetter[] returns the letter for the current panel of a \
multipanel plot.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Order", "::", "reusage"}], "=", 
    "\"\<Option for PanelLetter.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"First", "::", "reusage"}], "=", 
    "\"\<Option for PanelLetter.\>\""}], ";"}], 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Format", "::", "reusage"}], "=", 
   "\"\<Option for PanelLetter.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TickOptions", "::", "usage"}], "=", "\"\<Option for Panel.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", "System`", "*)"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3950921478125*^9, 3.395092164515625*^9}, {
   3.39552123815625*^9, 3.3955212451875*^9}, {3.42162143440625*^9, 
   3.421621452140625*^9}, {3.424459112015625*^9, 3.424459118234375*^9}, 
   3.43126084596875*^9, 3.434488676234375*^9, {3.459546226984375*^9, 
   3.45954623571875*^9}, {3.461089309796875*^9, 3.461089447421875*^9}, {
   3.464879197609375*^9, 3.464879230703125*^9}, {3.489687825796875*^9, 
   3.48968783096875*^9}, {3.497384732453125*^9, 3.497384744484375*^9}, {
   3.497534203625*^9, 3.49753422834375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data plotting", "Subsection"],

Cell["Data utilities", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AttachIndex", "::", "usage"}], "=", "\"\<(UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ScaleFactor", "::", "reusage"}], "=", 
    "\"\<Option for AttachIndex.\>\""}], ";"}], " ", 
  RowBox[{
  "(*", "Graphics`Common`GraphicsCommon`ScaleFactor`", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Range", "::", "reusage"}], "=", 
    "\"\<Option for AttachIndex.\>\""}], ";"}], " ", 
  RowBox[{"(*", "System`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSetQ", "::", "usage"}], "=", 
   "\"\<DataSetQ[list] returns True only if list is a valid LevelScheme data \
set.\>\""}], ";"}]}], "Input",
 InitializationCell->True],

Cell["Data filtering", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SelectData", "::", "usage"}], "=", 
   "\"\<SelectData[test] is a data filter for DataPlot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExcludeData", "::", "usage"}], "=", 
   "\"\<ExcludeData[test] is a data filter for DataPlot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TransformData", "::", "usage"}], "=", 
   "\"\<TransformData[f] is a data filter for DataPlot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DownsampleData", "::", "usage"}], "=", 
   "\"\<DownsampleData[f] is a data filter for DataPlot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XRange", "::", "usage"}], "=", 
   "\"\<XRange[x1,x2] is a logical test which acts on a data point.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YRange", "::", "usage"}], "=", 
   "\"\<YRange[y1,y2] is a logical test which acts on a data point.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InPlotRegion", "::", "usage"}], "=", 
   "\"\<InPlotRegion is a data filter for DataPlot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LimitX", "::", "usage"}], "=", 
   "\"\<LimitX[x1,x2] is a data filter for DataPlot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LimitY", "::", "usage"}], "=", 
   "\"\<LimitY[y1,y2] is a data filter for DataPlot.\>\""}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.461088416453125*^9, 3.461088417203125*^9}}],

Cell["Data plotting", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DataPlot", "::", "usage"}], "=", 
   "\"\<DataPlot[data] produces customizable data plots.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSequence", "::", "usage"}], "=", 
   "\"\<DataSequence[{data1,data2,...}] is a structure to contain multiple \
data sets for DataPlot.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataTag", "::", "usage"}], "=", 
   "\"\<DataTag[ID] sets the name of the following data set. \
(DEPRECATED)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefineDataStyle", "::", "usage"}], "=", 
   "\"\<DefineDataStyle[ID] saves the current plotting options.  A DataStyle \
may be specified as a starting point, and options may be further overridden \
by specifying DataLine->{...} or DataSymbol->{...}.  All inherited values are \
frozen in.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UseDataOptions", "::", "usage"}], "=", 
   "\"\<UseDataOptions[] sets the data plotting style options as specified in \
any options given to UseDataOptions.   A DataStyle may be specified as a \
starting point, and options may be further overridden by specifying \
DataLine->{...} or DataSymbol->{...}.  All inherited values are frozen \
in.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataLabel", "::", "usage"}], "=", 
   "\"\<DataLabel[ID] attaches text to a data plot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataLegend", "::", "usage"}], "=", 
   "\"\<DataLegend[{xs,ys},{{dataset1,label1},...}] generates a data plot \
legend.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSet", "::", "usage"}], "=", 
   "\"\<Symbol the option values for which control the behavior of \
DataPlot.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataValues", "::", "usage"}], "=", 
   "\"\<Symbol the option values for which control the behavior of \
DataPlot.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataLine", "::", "usage"}], "=", 
   "\"\<Symbol the option values for which control the behavior of \
DataPlot.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbol", "::", "usage"}], "=", 
   "\"\<Symbol the option values for which control the behavior of \
DataPlot.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DataStyle", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowData", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LineShape", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IgnoreMissingValues", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DataColumns", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DataFilters", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymbolShape", "::", "reusage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], " ", 
  RowBox[{"(*", "Graphics`MultipleListPlot`", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ErrorValue", "::", "usage"}], "=", 
   "\"\<Value type for data points.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymbolSize", "::", "usage"}], "=", 
    "\"\<Option for level scheme drawing objects.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataLineShape", "::", "usage"}], "=", 
   "\"\<Symbol used for specification of LevelScheme plot line shape.  \
DataLineShape[shape,plotpoints] should act on a list of points, transforming \
it to another list of points.\>\""}], ";", 
  RowBox[{
   RowBox[{"DataSymbolShape", "::", "usage"}], "=", 
   "\"\<Symbol used for specification of LevelScheme plot symbol shape.  \
DataSymbolShape[shape,plotpoints] should return a list of points, spanning \
approximately the unit circle.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.3987971915625*^9, {3.424456818*^9, 3.424456822828125*^9}, {
   3.464965162390625*^9, 3.4649651673125*^9}, {3.464971566125*^9, 
   3.464971573453125*^9}, {3.467209496515625*^9, 3.467209496921875*^9}, {
   3.46720966171875*^9, 3.467209665546875*^9}, {3.4672109908125*^9, 
   3.46721100925*^9}, {3.467211061921875*^9, 3.46721106309375*^9}, {
   3.467211854046875*^9, 3.467211854890625*^9}, {3.46721201053125*^9, 
   3.4672121716875*^9}, {3.488367514078125*^9, 3.488367518296875*^9}, {
   3.488368626765625*^9, 3.488368630296875*^9}, {3.492012531234375*^9, 
   3.492012561421875*^9}, {3.49201259728125*^9, 3.4920125995*^9}, {
   3.5029019675*^9, 3.502901977625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["User-accessible utilities", "Subsection"],

Cell["Decay scheme construction", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AutoLevelInit", "::", "usage"}], "=", 
   "\"\<AutoLevelInit[x0,space,bigspace] initializes automatic placement of \
transitions in a decay scheme.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AutoLevel", "::", "usage"}], "=", 
   "\"\<AutoLevel[ID1] selects the starting level for automatic placement of \
transitions in a decay scheme.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AutoTrans", "::", "usage"}], "=", 
   "\"\<AutoTrans[ID2] generates a transition to the specified ending level \
for automatic placement of transitions in a decay scheme.\>\""}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell["Graphics", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GrabPoints", "::", "usage"}], "=", 
   "\"\<GrabPoints[graphics] returns the list of points from the first Line \
found by ExtractCurves[graphics].\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtractCurves", "::", "usage"}], "=", 
   "\"\<ExtractCurves[graphics] extracts a list of Line objects from a \
Graphics, ContourGraphics, or Graphics3D object.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Graphics3DQ", "::", "usage"}], "=", 
   "\"\<Graphics3DQ[x] returns True if x is a Graphics3D object, with first \
argument of head list and optional second argument a flat list of \
options.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CombineGraphics3D", "::", "usage"}], "=", 
   "\"\<CombineGraphics3D[{graphics1,...}] returns a Graphics3D object with a \
primative list combining the primative lists of graphics1, ..., each as \
separate sublists (so style directives in one sublist do not affect the \
following sublists).\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRange", "::", "usage"}], "=", 
   "\"\<ExtendRange[{x1,x2},{fx1,fx2}] or ExtendRange[{x1,x2},fx] extends an \
interval by the specified fractional amounts in each direction.\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRegion", "::", "usage"}], "=", 
   "\"\<ExtendRegion[{{x1,x2},{y1,y2}},{{fx1,fx2},{fy1,fy2}}] or \
ExtendRegion[{{x1,x2},{y1,y2}},{fx,fy}] or ExtendRegion[{{x1,x2},{y1,y2}},f] \
extends a plot region by the specified fractional amounts in each \
direction.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRegionAspectRatio", "::", "usage"}], "=", 
   "\"\<ExtendRegion[{{x1,x2},{y1,y2}},a] extends a region to have the \
indicated aspect ratio.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RegionCorners", "::", "usage"}], "=", 
   "\"\<RegionCorners[{{x1,x2},{y1,y2}}] returns the corner points of the \
region, clockwise from bottom left, as {{x1,y1},...}.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Polar", "::", "usage"}], "=", 
   "\"\<Polar[{r,phi}] returns the Cartesian form of these polar coordinates. \
(UNDOCUMENTED)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Cylindrical", "::", "usage"}], "=", 
   "\"\<Cylindrical[{r,phi,z}] returns the Cartesian form of these \
cylindrical coordinates. (UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Spherical", "::", "usage"}], "=", 
   "\"\<Spherical[{r,theta,phi}] returns the Cartesian form of these \
spherical coordinates (where theta is the polar angle and phi the azimuthal \
angle). (UNDOCUMENTED)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VectorLength", "::", "usage"}], "=", "\"\<(UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VectorArcTan", "::", "usage"}], "=", "\"\<(UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SegmentLength", "::", "usage"}], "=", "\"\<(UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SegmentArcTan", "::", "usage"}], "=", "\"\<(UNDOCUMENTED)\>\""}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.438373742202073*^9, 3.438373791436448*^9}, {
  3.4596925925*^9, 3.459692655640625*^9}, {3.45969273790625*^9, 
  3.4596927563125*^9}, {3.470920166*^9, 3.470920229140625*^9}, {
  3.48828402065625*^9, 3.48828404225*^9}, {3.492380932890625*^9, 
  3.492380934140625*^9}, {3.505410605*^9, 3.505410651890625*^9}}],

Cell["LevelScheme technology and debugging", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FigRealizeOptions", "::", "usage"}], "=", 
   "\"\<FigRealizeOptions[object,opts...] realizes inherited and conditional \
options under the LevelScheme option system.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeGraphics", "::", "usage"}], "=", 
   "\"\<Graphics container for LevelScheme objects.\>\""}], ";", 
  RowBox[{
   RowBox[{"LineStyle", "::", "usage"}], "=", 
   "\"\<LineStyle[] returns a list of line style directives specified \
following the LevelScheme option system.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FillStyle", "::", "usage"}], "=", 
   "\"\<FillStyle[] returns a list of fill style directives specified \
following the LevelScheme option system.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BlockSchemeOptions", "::", "usage"}], "=", 
   "\"\<BlockSchemeOptions[expr] evaluates expr with BlockOptions on all \
LevelScheme object options. (UNDOCUMENTED)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "usage"}], "=", 
   "\"\<Evaluating LevelScheme[] reloads the LevelScheme package. \
(UNDOCUMENTED)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultipanelSettings", "::", "usage"}], "=", 
   "\"\<MultipanelSettings[] prints the current Multipanel plotting settings. \
(UNDOCUMENTED)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PackageVersions", "::", "usage"}], "=", 
   "\"\<Evaluating PackageVersions[] displays package version information for \
all loaded packages. (UNDOCUMENTED)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelSchemeLogo", "::", "usage"}], "=", 
   "\"\<LevelSchemeLogo contains the graphics for the the level scheme logo. \
(UNDOCUMENTED)\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.39552335603125*^9, {3.39664039028125*^9, 3.3966404351875*^9}, {
   3.396640628234375*^9, 3.396640670421875*^9}, {3.398810105046875*^9, 
   3.39881014965625*^9}, {3.456519961796875*^9, 3.456520019046875*^9}, {
   3.49605557828125*^9, 3.496055624671875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Legacy functions", "Subsection"],

Cell["\<\
\tDeprecated functions still work.
\tReplaced functions do not.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExtensionLineL", "::", "deprecated"}], "=", 
   "\"\<ExtensionLineL (last used in LevelScheme 2.0) has been absorbed into \
ExtensionLine.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtensionLineR", "::", "deprecated"}], "=", 
   "\"\<ExtensionLineR (last used in LevelScheme 2.0) has been absorbed into \
ExtensionLine.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TransArrow", "::", "deprecated"}], "=", 
   "\"\<TransArrow (last used in LevelScheme 2.0) has been absorbed into \
Trans.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RegionLabel", "::", "deprecated"}], "=", 
   "\"\<RegionLabel (last used in LevelScheme 2.0) has been replaced with \
ScaledLabel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AnnotateL", "::", "deprecated"}], "=", 
   "\"\<AnnotateL (last used in LevelScheme 2.0) has been replaced with \
LevelLabel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AnnotateR", "::", "deprecated"}], "=", 
   "\"\<AnnotateR (last used in LevelScheme 2.0) has been replaced with \
LevelLabel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeAxisB", "::", "deprecated"}], "=", 
   "\"\<SchemeAxisB (last used in LevelScheme 2.0) has been replaced with \
SchemeAxis.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeAxisL", "::", "deprecated"}], "=", 
   "\"\<SchemeAxisL (last used in LevelScheme 2.0) has been replaced with \
SchemeAxis.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeAxisT", "::", "deprecated"}], "=", 
   "\"\<SchemeAxisT (last used in LevelScheme 2.0) has been replaced with \
SchemeAxis.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeAxisR", "::", "deprecated"}], "=", 
   "\"\<SchemeAxisR (last used in LevelScheme 2.0) has been replaced with \
SchemeAxis.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AutoInit", "::", "deprecated"}], "=", 
   "\"\<AutoInit (last used in LevelScheme 2.0) has been renamed \
AutoLevelInit.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AutoPanelInit", "::", "replaced"}], "=", 
   "\"\<AutoPanelInit (last used in LevelScheme 2.0) has been replaced with \
Multipanel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AutoPanel", "::", "replaced"}], "=", 
   "\"\<AutoPanel (last used in LevelScheme 2.0) has been replaced with \
Panel.  Use SetRegion[] to turn off multipanel plotting.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetSchemeOrigin", "::", "deprecated"}], "=", 
   "\"\<SetSchemeOrigin (last used in LevelScheme 2.0) has been replaced with \
SetOrigin.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetSchemeScale", "::", "deprecated"}], "=", 
   "\"\<SetSchemeScale (last used in LevelScheme 2.0) has been replaced with \
SetScale.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetSchemeRegion", "::", "deprecated"}], "=", 
   "\"\<SetSchemeRegion (last used in LevelScheme 2.0) has been replaced with \
SetRegion.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ResetCoordinates", "::", "deprecated"}], "=", 
   "\"\<ResetCoordinates (last used in LevelScheme 3.21) has been absorbed \
into SetRegion.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemePoints", "::", "deprecated"}], "=", 
   "\"\<SchemePoints (last used in LevelScheme 3.21+ development version) has \
been absorbed into DataPlot.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Scheme", "::", "deprecated"}], "=", 
   "\"\<Scheme (last used in LevelScheme 3.21) has been replaced with Figure.\
\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.395523389484375*^9, {3.39663605815625*^9, 3.39663605871875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "abovekinkx"}], "=", 
   "\"\<The options AboveKinkL, AboveKinkR, and AboveKinkC (last used in \
LevelScheme 3.21) are no longer supported.  Please use SegmentL, SegmentR, \
and SegmentC instead.\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.395519995734375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error messages", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "lsargs"}], "=", 
   "\"\<Missing or unexpected arguments in level scheme object `1`.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "lsargsnull"}], "=", 
   "\"\<One of the arguments in `1` is Null.  Check for extra commas among \
the arguments.\>\""}], ";", 
  RowBox[{
   RowBox[{"LevelScheme", "::", "notinscheme"}], "=", 
   "\"\<Level scheme objects cannot be used outside of the function Scheme.  \
(If you are trying to save a list of level scheme objects for later use in a \
scheme, or to write a function which uses level scheme objects, use the \
SetDelayed symbol \\\":=\\\" for the assignment.)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "notreentrant"}], "=", 
   "\"\<Scheme is not reentrant.  It cannot be called within the object list \
given to Scheme.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "badparam"}], "=", 
   "\"\<Option `1` has invalid value `2`.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "badvalue"}], "=", 
   "\"\<An invalid value `2` has been encountered for `1`.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "badlevel"}], "=", 
   "\"\<A reference to an unrecognized level ID `1` has been \
encountered.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "badpoint"}], "=", 
   "\"\<A reference to an unrecognized point ID `1` has been \
encountered.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelScheme", "::", "baddataset"}], "=", 
   "\"\<A reference to an unrecognized dataset ID `1` has been encountered.\>\
\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetScale", "::", "nonpositive"}], "=", 
   "\"\<User axis scale setting `1` is not positive.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetRegion", "::", "nonpositive"}], "=", 
   "\"\<User coordinate region setting `1` does not consist of positive \
intervals.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Lev", "::", "energystr"}], "=", 
   "\"\<A string `2` has been specified as the level energy for a level \
(object identifier `1`), but this string cannot be converted to a \
number.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RawGraphics", "::", "empty"}], "=", 
   "\"\<Empty graphics (Graphics[options___]) discarded.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RawGraphics", "::", "multiarg"}], "=", 
   "\"\<Graphics with extra argument (Graphics[_,nonoption,options___]) \
discarded.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RawGraphics", "::", "badpoint"}], "=", 
   "\"\<Encountered point coordinates (`1`) not a numerical pair or a valid \
Mathematica Scaled or Offset coordinate.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ViewPort3D", "::", "prange"}], "=", 
   "\"\<PlotRange must be given explicitly as numerical values when option \
AxisScaling is used.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FigurePanel", "::", "badij"}], "=", 
   "\"\<A bad {row,column} index pair `1` has been specified for FigurePanel.\
\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Figure", "::", "prange"}], "=", 
   "\"\<No value specified for option PlotRange.  Assuming default value \
{{0,1},{0,1}}.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Figure", "::", "freegraphics"}], "=", 
   "\"\<A Mathematica graphics object was encountered among the objects in \
the list you gave to Figure.  Did you wish the graphics to be displayed as \
part of the figure?  If so, enclose the graphics in RawGraphics (see \
LevelScheme user guide).  Otherwise Mathematica graphics objects (such as the \
output of plotting functions) are simply discarded by Scheme.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Figure", "::", "timesgraphics"}], "=", 
   "\"\<The list of objects you gave to Figure appears to include a graphics \
object \\\"multiplied\\\" by something else.  Did you accidentally omit the \
comma separating two items in the list?\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Trans", "::", "twoautos"}], "=", 
   "\"\<You cannot specify both initial and final horizontal positions as \
Automatic.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "args"}], "=", 
   "\"\<Missing or unexpected arguments in `1`.  (Check for missing or extra \
commas among the arguments.)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "kinks"}], "=", 
   "\"\<Kinks have been specified for an arrow type which does not support \
them.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "nullsegment"}], "=", 
   "\"\<An arrow cannot contain a line segment of zero length (canvas \
coordinates `1`).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "fromvert"}], "=", 
   "\"\<Position specified as FromTailVertical or FromHeadVertical on \
horizontal line segment.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "fromhoriz"}], "=", 
   "\"\<Position specified as FromTailHorizontal or FromHeadHorizontal on \
vertical line segment.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "horizbevel"}], "=", 
   "\"\<Cannot bevel tail of horizontal arrow.  (Set option \
TailBevel->False.)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "conversionlip"}], "=", 
   "\"\<For conversion-electron arrows, it is recommended that HeadLip be set \
to 0, yielding a cornerless arrowhead.  Otherwise, a misleading plot is \
obtained, since the corner of the arrowhead is still shaded even for \
vanishing conversion coefficient.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LaTeXTableEntryValue", "::", "notnumeric"}], "=", 
   "\"\<LaTeX-style table entry `1` converts to `2`, which is not \
numeric.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeSquare", "::", "badr"}], "=", 
   "\"\<Unrecognized radius specification format `1`.\>\""}], ";", 
  RowBox[{
   RowBox[{"SchemeCircle", "::", "badr"}], "=", 
   "\"\<Unrecognized radius specification format `1`.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Multipanel", "::", "oldsyntax"}], "=", 
   "\"\<Old syntax (LevelScheme 2.0) used for Multipanel.  Assuming value \
None for tick lists.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Multipanel", "::", "ambigticks"}], "=", 
   "\"\<Ambiguous whether `1` specifies the tick values for a single axis, to \
be repeated, or several axes.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Multipanel", "::", "num"}], "=", 
   "\"\<Incorrect number of `1` given.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Multipanel", "::", "rule"}], "=", 
   "\"\<Rules for `1` yield invalid value for panel `2`.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Multipanel", "::", "autosizes"}], "=", 
   "\"\<Cannot generate `1` automatically if any of `2` are Automatic.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FigurePanel", "::", "undefined"}], "=", 
   "\"\<FigurePanel[{row,column}] called when no multipanel plot \
defined.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PanelLetter", "::", "nopanel"}], "=", 
   "\"\<Cannot generate panel letter since not in multipanel plot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GrabPoints", "::", "noline"}], "=", 
   "\"\<No line found in graphics.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GrabPoints", "::", "manylines"}], "=", 
   "\"\<More than one line found in graphics.  Only using first.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSet", "::", "badcolumn"}], "=", 
   "\"\<Data column number list `1` contains entry greater than maximum \
column in given data.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataPlot", "::", "baddata"}], "=", 
   "\"\<Invalid data set (`1`) encountered in DataPlot.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LimitX", "::", "badvalue"}], "=", 
   "\"\<Nonnumerical x value in data point (`1`).\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LimitY", "::", "badvalue"}], "=", 
   "\"\<Nonnumerical y value in data point (`1`).\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbol", "::", "badsymbol"}], "=", 
   "\"\<Symbol shape `1` unrecognized or improperly defined.  New symbols can \
be defined using DataSymbolShape.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.39509193859375*^9, {3.395092266484375*^9, 3.3950922706875*^9}, {
   3.395521246375*^9, 3.395521249125*^9}, {3.431540040171875*^9, 
   3.43154015040625*^9}, {3.431540854078125*^9, 3.431540855359375*^9}, {
   3.46445175425*^9, 3.46445175625*^9}, {3.479931157203125*^9, 
   3.479931187703125*^9}, {3.482533018359375*^9, 3.482533039859375*^9}, {
   3.4883693891875*^9, 3.488369436359375*^9}, {3.488369519765625*^9, 
   3.4883695205625*^9}, {3.49226564921875*^9, 3.492265651953125*^9}, {
   3.51007011759375*^9, 3.5100701565625*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin private context", "Section"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$PrivateContext", "=", "$Context"}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initialization", "Section"],

Cell[CellGroupData[{

Cell[TextData[{
 "Load private packages and define pre-",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 legacy functions"
}], "Subsection",
 CellChangeTimes->{{3.3950910055*^9, 3.395091018765625*^9}}],

Cell["\<\
Private packages used only internally:
\tGraphics legacy package is for TransformGraphics.
\tBlockUnprotect` is used in restoring data set plotting options.\
\>", "Text",
 CellChangeTimes->{{3.39508867859375*^9, 3.395088684171875*^9}, {
  3.39508882375*^9, 3.395088834234375*^9}, {3.395089603546875*^9, 
  3.39508960509375*^9}, {3.395090977890625*^9, 3.39509098175*^9}}],

Cell["\<\
Note: Rotate2D[] rotation is CCW, so must negate angle to obtain CW rotation.\
\
\>", "Text",
 CellChangeTimes->{{3.3950909898125*^9, 3.39509099175*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LegacyFilterOptions", "[", 
    RowBox[{"f_Symbol", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"FilterRules", "[", 
     RowBox[{
      RowBox[{"{", "Opts", "}"}], ",", 
      RowBox[{"Options", "[", "f", "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LegacyRotate2D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], ",", "phi_", ",", 
     RowBox[{"{", 
      RowBox[{"x0_", ",", "y0_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"RotationTransform", "[", 
     RowBox[{
      RowBox[{"-", "phi"}], ",", 
      RowBox[{"{", 
       RowBox[{"x0", ",", "y0"}], "}"}]}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LegacyRotate2D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], ",", "phi_"}], "]"}], ":=", 
   RowBox[{"LegacyRotate2D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "phi", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RotationMatrix3D", "[", 
    RowBox[{"phi_", ",", "theta_", ",", "psi_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"RotationMatrix", "[", 
     RowBox[{
      RowBox[{"Pi", "-", "psi"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ".", 
    RowBox[{"RotationMatrix", "[", 
     RowBox[{"theta", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], ".", 
    RowBox[{"RotationMatrix", "[", 
     RowBox[{
      RowBox[{"Pi", "-", "phi"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LegacyRegularPolygon", "[", 
     RowBox[{"n_", ",", " ", 
      RowBox[{"rad_:", "1"}], ",", " ", 
      RowBox[{"ctr_:", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"tilt_:", "0"}], ",", " ", 
      RowBox[{"k_:", "1"}]}], "]"}], ":=", 
    RowBox[{"Line", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ctr", "+", 
         RowBox[{"rad", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"t", "+", "tilt"}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"t", "+", "tilt"}], "]"}]}], "}"}]}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"t", ",", " ", "0", ",", " ", 
          RowBox[{"2", "Pi"}], ",", " ", 
          RowBox[{"2", 
           RowBox[{"Pi", "/", "n"}]}]}], "}"}]}], "]"}], 
      "\[LeftDoubleBracket]", 
      RowBox[{"NestList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"#", "+", "k"}], ",", "n", ",", "1"}], "]"}], "&"}], ",", 
        "1", ",", "n"}], "]"}], "\[RightDoubleBracket]"}], 
     "\[IndentingNewLine]", "]"}]}], " ", ";"}], " "}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395088870203125*^9, 3.395088884796875*^9}, {
   3.395088918546875*^9, 3.395088949390625*^9}, 3.395089863421875*^9, {
   3.39509091809375*^9, 3.395090968*^9}, 3.39509102459375*^9, {
   3.395092686921875*^9, 3.395092704640625*^9}, {3.39509299859375*^9, 
   3.39509300584375*^9}, {3.395093119421875*^9, 3.39509314678125*^9}, 
   3.39509559921875*^9, {3.398544547875*^9, 3.3985445481875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
   "Needs", "[", "\"\<LevelScheme`LegacyTransformGraphics`\>\"", "]"}], ";"}],
   " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Needs", "[", "\"\<LevelScheme`BlockUnprotect`\>\"", " ", "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3950888423125*^9, 3.39508886715625*^9}, 
   3.395089608484375*^9, {3.39509040403125*^9, 3.395090412625*^9}, 
   3.39509097015625*^9, {3.443995361390625*^9, 3.443995362515625*^9}, {
   3.4950419718125*^9, 3.495041978171875*^9}, {3.495042443359375*^9, 
   3.49504244590625*^9}, {3.497222388515625*^9, 3.497222398828125*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Get", "::", "noopen"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Cannot open \
\[NoBreak]\\!\\(\\\"Graphics`Common`GraphicsCommon`\\\"\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/noopen\\\", \
ButtonNote -> \\\"Get::noopen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5668373803123274`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Needs", "::", "nocont"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Context \
\[NoBreak]\\!\\(\\\"Graphics`Common`GraphicsCommon`\\\"\\)\[NoBreak] was not \
created when Needs was evaluated. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Needs/nocont\\\", \
ButtonNote -> \\\"Needs::nocont\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.566837380322327*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Get", "::", "noopen"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Cannot open \[NoBreak]\\!\\(\\\"Utilities`FilterOptions`\\\
\"\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/noopen\\\", ButtonNote -> \
\\\"Get::noopen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5668373803573275`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Needs", "::", "nocont"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Context \
\[NoBreak]\\!\\(\\\"Utilities`FilterOptions`\\\"\\)\[NoBreak] was not created \
when Needs was evaluated. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Needs/nocont\\\", ButtonNote -> \
\\\"Needs::nocont\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.566837380372327*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Get", "::", "noopen"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Cannot open \
\[NoBreak]\\!\\(\\\"Statistics`DataManipulation`\\\"\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/noopen\\\", \
ButtonNote -> \\\"Get::noopen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.566837380409828*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Get :: \
noopen\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.566837380424828*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Needs", "::", "nocont"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Context \[NoBreak]\\!\\(\\\"Statistics`DataManipulation`\\\
\"\\)\[NoBreak] was not created when Needs was evaluated. \\!\\(\\*ButtonBox[\
\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Needs/nocont\\\", ButtonNote -> \
\\\"Needs::nocont\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5668373804398284`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Needs :: \
nocont\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5668373804598284`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display greeting message", "Subsection"],

Cell["\<\
LevelSchemeLogo=Graphics[{GrayLevel[0], Opacity[1], AbsoluteThickness[2], \
AbsoluteDashing[{}], 
  {Line[{{0.1, 200.}, {0.9, 200.}}]}, GrayLevel[0], Opacity[1], \
AbsoluteThickness[2], 
  AbsoluteDashing[{}], {Line[{{0.1, 116.93046875}, {0.1536723484848485, \
116.93046875}, 
     {0.2610170454545455, 100.}, {0.7389829545454545, 100.}, \
{0.8463276515151515, 116.93046875}, 
     {0.9, 116.93046875}}]}, GrayLevel[0], Opacity[1], AbsoluteThickness[2], \
AbsoluteDashing[{}], 
  {Line[{{0.1, 0.}, {0.9, 0.}}]}, GrayLevel[0.5], Opacity[1], 
  Polygon[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, \
{0.6828827683115883, 
    106.35880620986916}, {0.675461586050597, 105.04604015402995}, {0.73, \
100.}, 
    {0.7595683183418321, 119.92405545354092}, {0.7521471360808408, \
118.61128939770171}, 
    {0.6707584254785426, 200.}}], GrayLevel[0], Opacity[1], \
AbsoluteThickness[1], 
  AbsoluteDashing[{}], {Line[{{0.6300000000000001, 200.}, \
{0.5892415745214576, 200.}, 
     {0.6828827683115883, 106.35880620986916}, {0.675461586050597, \
105.04604015402995}, 
     {0.73, 100.}, {0.7595683183418321, 119.92405545354092}, \
{0.7521471360808408, 
      118.61128939770171}, {0.6707584254785426, 200.}, {0.6300000000000001, \
200.}}]}, 
  GrayLevel[0.5], Opacity[1], Polygon[{{0.2700000000000001, 100.}, \
{0.22924157452145752, 100.}, 
    {0.3228827683115884, 6.358806209869151}, {0.3154615860505971, \
5.046040154029939}, 
    {0.37000000000000005, 0.}, {0.3995683183418322, 19.924055453540902}, \
{0.39214713608084084, 
    18.61128939770171}, {0.3107584254785426, 100.}}], GrayLevel[0], \
Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.2700000000000001, 100.}, {0.22924157452145752, 100.}, 
     {0.3228827683115884, 6.358806209869151}, {0.3154615860505971, \
5.046040154029939}, 
     {0.37000000000000005, 0.}, {0.3995683183418322, 19.924055453540902}, 
     {0.39214713608084084, 18.61128939770171}, {0.3107584254785426, 100.}, 
     {0.2700000000000001, 100.}}]}, GrayLevel[0], Opacity[1], \
AbsoluteThickness[1], 
  AbsoluteDashing[{}], {Line[{{0.501, 20.}, {0.529, 20.}}]}, GrayLevel[0], \
Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], {Line[{{0.531, 21.3}, \
{0.5589999999999999, 21.3}}]}, 
  GrayLevel[0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 24.333333333333336}, {0.589, \
24.333333333333336}}]}, GrayLevel[0], 
  Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], {Line[{{0.591, \
29.1}, {0.619, 29.1}}]}, 
  GrayLevel[0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.621, 35.6}, {0.649, 35.6}}]}, GrayLevel[0], Opacity[1], \
AbsoluteThickness[1], 
  AbsoluteDashing[{}], {Line[{{0.651, 43.833333333333336}, {0.679, \
43.833333333333336}}]}, 
  GrayLevel[0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.681, 53.8}, {0.709, 53.8}}]}, GrayLevel[0], Opacity[1], \
AbsoluteThickness[1], 
  AbsoluteDashing[{}], {Line[{{0.711, 65.5}, {0.739, 65.5}}]}, GrayLevel[0], \
Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.741, 78.93333333333334}, {0.769, 78.93333333333334}}]}, \
RGBColor[1, 0, 0], Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], {Line[{{0.501, 33.}, {0.529, \
33.}}]}, 
  RGBColor[1, 0, 0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.531, 34.3}, {0.5589999999999999, 34.3}}]}, RGBColor[1, 0, 0], \
Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 37.333333333333336}, {0.589, \
37.333333333333336}}]}, 
  RGBColor[1, 0, 0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.591, 42.099999999999994}, {0.619, 42.099999999999994}}]}, \
RGBColor[1, 0, 0], 
  Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.621, 48.599999999999994}, {0.649, 48.599999999999994}}]}, \
RGBColor[1, 0, 0], 
  Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.651, 56.833333333333336}, {0.679, 56.833333333333336}}]}, \
RGBColor[1, 0, 0], 
  Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], {Line[{{0.681, \
66.8}, {0.709, 66.8}}]}, 
  RGBColor[1, 0, 0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.711, 78.5}, {0.739, 78.5}}]}, Hue[0.4739282735611543, 0.7, 1], \
Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.501, 47.761071567264665}, {0.529, 47.761071567264665}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.531, 49.24022665797266}, {0.5589999999999999, \
49.24022665797266}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 52.691588536291334}, {0.589, \
52.691588536291334}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.591, 58.115157202220665}, {0.619, 58.115157202220665}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.621, 65.51093265576067}, {0.649, 65.51093265576067}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.651, 74.87891489691134}, {0.679, 74.87891489691134}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.501, 56.07894755622853}, {0.529, 56.07894755622853}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.531, 57.38554745213195}, {0.5589999999999999, \
57.38554745213195}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 60.434280542573276}, {0.589, \
60.434280542573276}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.591, 65.22514682755249}, {0.619, 65.22514682755249}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.621, 71.75814630706962}, {0.649, 71.75814630706962}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.651, 80.03327898112465}, {0.679, 80.03327898112465}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.501, 60.981197953135855}, {0.529, 60.981197953135855}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.531, 62.04756255970392}, {0.5589999999999999, \
62.04756255970392}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 64.53574664169608}, {0.589, \
64.53574664169608}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.591, 68.44575019911233}, {0.619, 68.44575019911233}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.621, 73.77757323195266}, {0.649, 73.77757323195266}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}], 
  {Line[{{0.651, 80.53121574021708}, {0.679, 80.53121574021708}}]}, \
Text[DisplayForm[
    \\(\\*\"LevelScheme\"\\)
    ], {0.1, 200.}, {-1, -0.75}, {1, 0}, BaseStyle -> {FontFamily -> \
\"Times\", FontSize -> 10, 
     FontSlant -> \"Plain\", FontTracking -> \"Plain\", FontWeight -> \"Plain\
\", 
     FontColor -> GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}]}, \

 {PlotRange -> {{-0.0001, 1.0001}, {-50.0325, 275.0325}}, ImageSize -> \
{93.17647058823529, 72.}, 
  AspectRatio -> 0.7727272727272727, Frame -> False, 
  FrameStyle -> Directive[{GrayLevel[0], Opacity[1], AbsoluteThickness[1], \
AbsoluteDashing[{}]}], 
  FrameLabel -> {None, None, None, None}, FrameTicks -> None, Axes -> False, \
Ticks -> None, 
  TextStyle -> {FontFamily -> \"Times\", FontSize -> 12, FontSlant -> \"Plain\
\", 
    FontTracking -> \"Plain\", FontWeight -> \"Plain\", FontColor -> \
GrayLevel[0], FontOpacity -> 1, 
    ShowAutoStyles -> False}, Background -> RGBColor[0.889996, 0.509995, \
0.089999], 
  DisplayFunction -> Identity}];\
\>", "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.398798713796875*^9, 3.39879871775*^9}, 
   3.39879949665625*^9, 3.398799783140625*^9, {3.3988001090625*^9, 
   3.3988001145*^9}, {3.398810157125*^9, 3.39881016075*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SplashContents", "=", 
   RowBox[{"Row", "[", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"GridBox", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
           "{", "\"\<LevelScheme scientific figure preparation system\>\"", 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{
           "{", "\"\<M. A. Caprio, Department of Physics, University of Notre \
Dame\>\"", "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"\"\<Comput. Phys. Commun. \>\"", ",", 
               RowBox[{"textbf", "[", "\"\<171\>\"", "]"}], ",", 
               "\"\<, 107 (2005)\>\""}], "}"}], "]"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"\"\<Version \>\"", "<>", "LevelSchemeRevisionString"}], 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{"RowBox", "[", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"ButtonBox", "[", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<View color palette\>\"", ",", 
                   RowBox[{"FontFamily", "->", "\"\<Times\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "->", "\"\<Named color palette\>\""}], 
                 ",", 
                 RowBox[{"ButtonFunction", "\[Rule]", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"NamedColorPalette", "[", "]"}], "&"}], ")"}]}], 
                 ",", 
                 RowBox[{"Active", "\[Rule]", "True"}], ",", 
                 RowBox[{"ButtonFrame", "\[Rule]", "\"\<DialogBox\>\""}], ",", 
                 RowBox[{"ButtonExpandable", "\[Rule]", "False"}], ",", 
                 RowBox[{"Evaluator", "\[Rule]", "Automatic"}]}], 
                "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"MakeButtonForURL", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<Visit home page\>\"", ",", 
                   RowBox[{"FontFamily", "->", "\"\<Times\>\""}]}], "]"}], 
                 ",", "LevelSchemeHomePageURL", ",", 
                 RowBox[{"ButtonFrame", "\[Rule]", "\"\<DialogBox\>\""}], ",", 
                 RowBox[{"ButtonExpandable", "\[Rule]", "False"}]}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}], "\[IndentingNewLine]", 
            "}"}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ColumnAlignments", "\[Rule]", "Left"}]}], 
        "\[IndentingNewLine]", "]"}], "//", "DisplayForm"}], ",", 
      "\[IndentingNewLine]", "\"\<  \>\"", ",", "\[IndentingNewLine]", 
      "LevelSchemeLogo"}], "\[IndentingNewLine]", "}"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4956600655625*^9, 3.495660069625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", "\[IndentingNewLine]", 
  RowBox[{"LevelScheme`Config`Splash", ",", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\[IndentingNewLine]", 
    RowBox[{"Framed", "[", 
     RowBox[{"SplashContents", ",", 
      RowBox[{"Background", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"FrameMargins", "\[Rule]", "10"}], ",", 
      RowBox[{"FrameStyle", "\[Rule]", "None"}]}], "]"}], 
    "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.395089143765625*^9, {3.398798251046875*^9, 3.39879837440625*^9}, {
   3.3987984359375*^9, 3.398798467890625*^9}, {3.39879879175*^9, 
   3.398798792359375*^9}, {3.39879892084375*^9, 3.398798976890625*^9}, 
   3.39879900734375*^9, {3.398799045765625*^9, 3.398799080015625*^9}, 
   3.3988101679375*^9, 3.39881022890625*^9, 3.39881026340625*^9, {
   3.443994581078125*^9, 3.443994586921875*^9}, {3.495660060171875*^9, 
   3.49566008028125*^9}, {3.49566016078125*^9, 3.49566017196875*^9}, {
   3.49566020234375*^9, 3.4956602059375*^9}, {3.495660362875*^9, 
   3.495660367046875*^9}, {3.495660411484375*^9, 3.49566041525*^9}, 
   3.49722440828125*^9, 3.49722444265625*^9}],

Cell[BoxData[
 FrameBox[
  TemplateBox[{TagBox[
     GridBox[{{
        RowBox[{
         "LevelScheme", " ", "scientific", " ", "figure", " ", "preparation", 
          " ", "system"}]}, {
        RowBox[{
          RowBox[{"M", ".", " ", "A", ".", " ", "Caprio"}], ",", " ", 
          RowBox[{"Department", " ", "of", " ", "Physics"}], ",", " ", 
          RowBox[{"University", " ", "of", " ", "Notre", " ", "Dame"}]}]}, {
        TemplateBox[{"\"Comput. Phys. Commun. \"", 
          TagBox[
           StyleBox["\"171\"", FontWeight -> "Bold"], 
           StyleForm[#, FontWeight -> "Bold"]& ], "\", 107 (2005)\""}, 
         "RowDefault"]}, {
        RowBox[{"Version", " ", "3.52", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"September", " ", "20"}], ",", " ", "2011"}], ")"}]}]}, {
        RowBox[{
          ButtonBox[
           StyleBox[
            RowBox[{"View", " ", "color", " ", "palette"}], FontFamily -> 
            "Times"], Active -> True, Appearance -> {Automatic, "DialogBox"}, 
           ButtonFunction :> (NamedColors`NamedColorPalette[]& ), ButtonNote -> 
           "Named color palette", Evaluator -> Automatic, ImageSize -> 
           Automatic], 
          TagBox[
           ButtonBox[
            StyleBox[
             RowBox[{"Visit", " ", "home", " ", "page"}], FontFamily -> 
             "Times"], Active -> True, Appearance -> {Automatic, "DialogBox"},
             ButtonData :> {
              URL[
              "http://scidraw.nd.edu/levelscheme/landing/levelscheme-3.52.\
html"], None}, ButtonFunction :> (FrontEndExecute[{
               FrontEnd`NotebookLocate[#2]}]& ), ButtonNote -> 
            "http://scidraw.nd.edu/levelscheme/landing/levelscheme-3.52.html",
             ImageSize -> Automatic], DisplayForm]}]}}, 
      GridBoxAlignment -> {
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}], DisplayForm],"\"  \"",GraphicsBox[{{
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 200.}, {0.9, 200.}}]}, {
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 116.93046875}, {0.1536723484848485, 116.93046875}, {
        0.2610170454545455, 100.}, {0.7389829545454545, 100.}, {
        0.8463276515151515, 116.93046875}, {0.9, 116.93046875}}]}, {
       GrayLevel[0], 
       AbsoluteThickness[2], 
       Opacity[1], 
       Dashing[{}], 
       LineBox[{{0.1, 0.}, {0.9, 0.}}], {
        GrayLevel[0.5], 
        Opacity[1], 
        PolygonBox[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {
         0.6828827683115883, 106.35880620986916`}, {0.675461586050597, 
         105.04604015402995`}, {0.73, 100.}, {0.7595683183418321, 
         119.92405545354092`}, {0.7521471360808408, 118.61128939770171`}, {
         0.6707584254785426, 200.}}]}, {
        GrayLevel[0], 
        AbsoluteThickness[1], 
        Opacity[1], 
        Dashing[{}], 
        LineBox[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {
         0.6828827683115883, 106.35880620986916`}, {0.675461586050597, 
         105.04604015402995`}, {0.73, 100.}, {0.7595683183418321, 
         119.92405545354092`}, {0.7521471360808408, 118.61128939770171`}, {
         0.6707584254785426, 200.}, {0.6300000000000001, 200.}}], {
         GrayLevel[0.5], 
         Opacity[1], 
         PolygonBox[{{0.2700000000000001, 100.}, {0.22924157452145752`, 
          100.}, {0.3228827683115884, 6.358806209869151}, {0.3154615860505971,
           5.046040154029939}, {0.37000000000000005`, 0.}, {
          0.3995683183418322, 19.924055453540902`}, {0.39214713608084084`, 
          18.61128939770171}, {0.3107584254785426, 100.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.2700000000000001, 100.}, {0.22924157452145752`, 100.}, {
          0.3228827683115884, 6.358806209869151}, {0.3154615860505971, 
          5.046040154029939}, {0.37000000000000005`, 0.}, {0.3995683183418322,
           19.924055453540902`}, {0.39214713608084084`, 18.61128939770171}, {
          0.3107584254785426, 100.}, {0.2700000000000001, 100.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 20.}, {0.529, 20.}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 21.3}, {0.5589999999999999, 21.3}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 24.333333333333336`}, {0.589, 
          24.333333333333336`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 29.1}, {0.619, 29.1}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 35.6}, {0.649, 35.6}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 43.833333333333336`}, {0.679, 
          43.833333333333336`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.681, 53.8}, {0.709, 53.8}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.711, 65.5}, {0.739, 65.5}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.741, 78.93333333333334}, {0.769, 78.93333333333334}}]}, {
        
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 33.}, {0.529, 33.}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 34.3}, {0.5589999999999999, 34.3}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 37.333333333333336`}, {0.589, 
          37.333333333333336`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 42.099999999999994`}, {0.619, 
          42.099999999999994`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 48.599999999999994`}, {0.649, 
          48.599999999999994`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 56.833333333333336`}, {0.679, 
          56.833333333333336`}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.681, 66.8}, {0.709, 66.8}}]}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.711, 78.5}, {0.739, 78.5}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 47.761071567264665`}, {0.529, 
          47.761071567264665`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 49.24022665797266}, {0.5589999999999999, 
          49.24022665797266}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 52.691588536291334`}, {0.589, 
          52.691588536291334`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 58.115157202220665`}, {0.619, 
          58.115157202220665`}}]}, {
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 65.51093265576067}, {0.649, 65.51093265576067}}]}, {
        
         Hue[0.4739282735611543, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 74.87891489691134}, {0.679, 74.87891489691134}}]}, {
        
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 56.07894755622853}, {0.529, 56.07894755622853}}]}, {
        
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 57.38554745213195}, {0.5589999999999999, 
          57.38554745213195}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 60.434280542573276`}, {0.589, 
          60.434280542573276`}}]}, {
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 65.22514682755249}, {0.619, 65.22514682755249}}]}, {
        
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 71.75814630706962}, {0.649, 71.75814630706962}}]}, {
        
         Hue[0.022803460025882117`, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 80.03327898112465}, {0.679, 80.03327898112465}}]}, {
        
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.501, 60.981197953135855`}, {0.529, 
          60.981197953135855`}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.531, 62.04756255970392}, {0.5589999999999999, 
          62.04756255970392}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.5609999999999999, 64.53574664169608}, {0.589, 
          64.53574664169608}}]}, {
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.591, 68.44575019911233}, {0.619, 68.44575019911233}}]}, {
        
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.621, 73.77757323195266}, {0.649, 73.77757323195266}}]}, {
        
         Hue[0.7490704830227459, 0.7, 1], 
         AbsoluteThickness[1], 
         Opacity[1], 
         Dashing[{}], 
         LineBox[{{0.651, 80.53121574021708}, {0.679, 80.53121574021708}}], 
         InsetBox[
          TagBox["\"LevelScheme\"", DisplayForm], {0.1, 200.}, {-1, -0.75}, 
          Automatic, {1, 0}, 
          BaseStyle -> {
           FontFamily -> "Times", FontSize -> 10, FontSlant -> "Plain", 
            FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
            GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}]}}}}, 
     AspectRatio -> 0.7727272727272727, Axes -> False, Background -> 
     RGBColor[0.889996, 0.509995, 0.089999], 
     BaseStyle -> {
      FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", 
       FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> 
       GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}, 
     DisplayFunction -> Identity, Frame -> False, 
     FrameLabel -> {None, None, None, None}, FrameStyle -> Directive[{
        GrayLevel[0], 
        Opacity[1], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{}]}], FrameTicks -> None, 
     ImageSize -> {93.17647058823529, 72.}, 
     PlotRange -> {{-0.0001, 1.0001}, {-50.0325, 275.0325}}, Ticks -> None]},
   "RowDefault"],
  Background->GrayLevel[0.85],
  FrameMargins->10,
  FrameStyle->None,
  StripOnInput->False]], "Print",
 CellChangeTimes->{{3.4960552215625*^9, 3.496055228140625*^9}, {
   3.506121104222875*^9, 3.506121119379125*^9}, 3.566837380492329*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Global constants", "Subsection"],

Cell["Drawing layers", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$SchemeBackgroundLayer", "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$SchemeDrawingLayer", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$SchemeBlankingLayer", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$SchemeTextLayer", "=", "3"}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Flag to prevent evaluation of scheme objects outside of a scheme\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$InScheme", "=", "False"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option definitions", "Section"],

Cell[CellGroupData[{

Cell["Option scoping symbol lists", "Subsection"],

Cell["\<\
List of symbols for which options should be dynamically scoped\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"OptionSymbols", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"from", " ", "LevelScheme"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
    "SchemeObject", ",", "Lev", ",", "ExtensionLine", ",", "Connector", ",", 
     "Trans", ",", "ManualLabel", ",", "ScaledLabel", ",", "BandLabel", ",", 
     "LevelLabel", ",", "SchemeBracket", ",", "\[IndentingNewLine]", 
     "SchemeLine", ",", "SchemePoints", ",", "SchemePolygon", ",", 
     "SchemeBox", ",", "SchemeSquare", ",", "SchemeCircle", ",", 
     "SchemeEllipse", ",", "SchemeArrow", ",", "\[IndentingNewLine]", 
     "RawGraphics", ",", "FigGraphics", ",", "ViewPort3D", ",", 
     "ScaledViewPort3D", ",", "\[IndentingNewLine]", "FigurePanel", ",", 
     "ScaledFigurePanel", ",", "Multipanel", ",", "SchemeAxis", ",", 
     "PanelLetter", ",", "\[IndentingNewLine]", "LineStyle", ",", "FillStyle",
      ",", "\[IndentingNewLine]", "AttachIndex", ",", "\[IndentingNewLine]", 
     "DataPlot", ",", "DataTag", ",", "DefineDataStyle", ",", 
     "UseDataOptions", ",", "DataLabel", ",", "DataSet", ",", "DataValues", 
     ",", "DataLine", ",", "DataSymbol", ",", "DataLegend", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "external", " ", "*)"}], "\[IndentingNewLine]", 
     "LinTicks", ",", "LogTicks"}], "\[IndentingNewLine]", "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OptionSymbols3D", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
    "ManualLabel3D", ",", "SchemeLine3D", ",", "SchemeArrow3D", ",", 
     "RawGraphics3D"}], "\[IndentingNewLine]", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3950919401875*^9, 3.395091940671875*^9}, {
   3.395092273328125*^9, 3.395092273953125*^9}, {3.395521251203125*^9, 
   3.39552125121875*^9}, 3.39879719159375*^9, {3.459698466625*^9, 
   3.459698471765625*^9}, {3.45969852665625*^9, 3.459698526953125*^9}, {
   3.464965180390625*^9, 3.4649651823125*^9}, 3.46720949809375*^9, {
   3.4672110176875*^9, 3.467211018328125*^9}, 3.467211064015625*^9, 
   3.467211855703125*^9, 3.467212010578125*^9, {3.4882824911875*^9, 
   3.48828249371875*^9}, {3.488368644*^9, 3.488368645359375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shorthand list definitions", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BasicOpts", "=", 
   RowBox[{"{", 
    RowBox[{
    "Show", ",", "Tooltip", ",", "Color", ",", "Opacity", ",", "Layer", ",", 
     "ClipToRectangle"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ObjectOpts", "=", 
   RowBox[{"{", 
    RowBox[{"Tag", ",", "ConditionalOptions"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OutlineOpts", "=", 
   RowBox[{"{", 
    RowBox[{
    "ShowLine", ",", "LineColor", ",", "LineOpacity", ",", "Thickness", ",", 
     "CapForm", ",", "Dashing", ",", "DashingGap", ",", "DashingCorrection"}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TickOutlineOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TickShowLine", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"TickLineColor", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"TickLineOpacity", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"TickThickness", "\[Rule]", "Automatic"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FillOpts", "=", 
   RowBox[{"{", 
    RowBox[{"ShowFill", ",", "FillColor", ",", "FillOpacity"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"BackgroundOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Background", "\[Rule]", "None"}], ",", 
     RowBox[{"BackgroundOpacity", "\[Rule]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ArrowheadOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HeadLength", "\[Rule]", "6"}], ",", 
     RowBox[{"HeadLip", "\[Rule]", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TextOpts", "=", 
   RowBox[{"{", 
    RowBox[{
    "FontFamily", ",", "FontSize", ",", "FontWeight", ",", "FontSlant", ",", 
     "FontTracking", ",", "FontColor", ",", "FontOpacity"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"TickTextOpts", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"TickFontFamily", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"TickFontSize", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"TickFontWeight", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"TickFontSlant", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"TickFontTracking", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"TickFontColor", "->", "Automatic"}], ",", 
     RowBox[{"TickFontOpacity", "->", "Automatic"}], ",", 
     RowBox[{"TickBackground", "\[Rule]", "Automatic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PanelLetterTextOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PanelLetterFontFamily", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PanelLetterFontSize", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PanelLetterFontWeight", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PanelLetterFontSlant", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PanelLetterFontTracking", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PanelLetterFontColor", "->", "Automatic"}], ",", 
     RowBox[{"PanelLetterFontOpacity", "->", "Automatic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PanelLetterOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ShowPanelLetter", "\[Rule]", "True"}], ",", 
     RowBox[{"PanelLetterOffset", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PanelLetterCorner", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
     RowBox[{"PanelLetterNudge", "\[Rule]", "None"}], ",", 
     RowBox[{"PanelLetterOrientation", "->", "Automatic"}], ",", 
     RowBox[{"PanelLetterBackground", "\[Rule]", "None"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LabLOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LabL", "\[Rule]", "None"}], ",", 
     RowBox[{"ShowLabL", "\[Rule]", "True"}], ",", 
     RowBox[{"OffsetL", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"NudgeL", "\[Rule]", "None"}], ",", 
     RowBox[{"OrientationL", "->", "Automatic"}], ",", 
     RowBox[{"BackgroundL", "\[Rule]", "None"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LabROpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LabR", "\[Rule]", "None"}], ",", 
     RowBox[{"ShowLabR", "\[Rule]", "True"}], ",", 
     RowBox[{"OffsetR", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"NudgeR", "\[Rule]", "None"}], ",", 
     RowBox[{"OrientationR", "->", "Automatic"}], ",", 
     RowBox[{"BackgroundR", "\[Rule]", "None"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LabTOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LabT", "\[Rule]", "None"}], ",", 
     RowBox[{"ShowLabT", "\[Rule]", "True"}], ",", 
     RowBox[{"OffsetT", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"NudgeT", "\[Rule]", "None"}], ",", 
     RowBox[{"OrientationT", "->", "Automatic"}], ",", 
     RowBox[{"BackgroundT", "\[Rule]", "None"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LabBOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LabB", "\[Rule]", "None"}], ",", 
     RowBox[{"ShowLabB", "\[Rule]", "True"}], ",", 
     RowBox[{"OffsetB", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"NudgeB", "\[Rule]", "None"}], ",", 
     RowBox[{"OrientationB", "->", "Automatic"}], ",", 
     RowBox[{"BackgroundB", "\[Rule]", "None"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LabCOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LabC", "\[Rule]", "None"}], ",", 
     RowBox[{"ShowLabC", "\[Rule]", "True"}], ",", 
     RowBox[{"OffsetC", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"NudgeC", "\[Rule]", "None"}], ",", 
     RowBox[{"OrientationC", "->", "Automatic"}], ",", 
     RowBox[{"BackgroundC", "\[Rule]", "None"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LabXOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LabX", "\[Rule]", "None"}], ",", 
     RowBox[{"ShowLabX", "\[Rule]", "True"}], ",", 
     RowBox[{"OffsetX", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"NudgeX", "\[Rule]", "None"}], ",", 
     RowBox[{"OrientationX", "->", "Automatic"}], ",", 
     RowBox[{"BackgroundX", "\[Rule]", "None"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LabOpts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ShowText", "\[Rule]", "True"}], ",", 
     RowBox[{"Offset", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"Nudge", "\[Rule]", "None"}], ",", 
     RowBox[{"Orientation", "->", "Automatic"}], ",", 
     RowBox[{"Background", "\[Rule]", "None"}]}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3955199989375*^9, 3.395519999421875*^9}, {
   3.396634439375*^9, 3.396634476921875*^9}, {3.39663466884375*^9, 
   3.396634696140625*^9}, {3.396636778984375*^9, 3.396636795*^9}, {
   3.431539645953125*^9, 3.431539648046875*^9}, {3.4651413043125*^9, 
   3.465141343359375*^9}, {3.46995738725*^9, 3.469957397953125*^9}, {
   3.48681018309375*^9, 3.486810184578125*^9}, {3.48840113828125*^9, 
   3.488401147453125*^9}, {3.4914123481875*^9, 3.491412359875*^9}, {
   3.492265158484375*^9, 3.492265159203125*^9}, 3.492265204390625*^9, {
   3.4960540858125*^9, 3.496054088140625*^9}, {3.496054657765625*^9, 
   3.496054658125*^9}, 3.50255510309375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"InheritanceMode", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TrapUninheritableOptions", "\[Rule]", "True"}], ",", 
     RowBox[{"TrapUnknownOptions", "\[Rule]", "True"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generic parent object", "Subsection"],

Cell[TextData[{
 "Default font family\n\tUse of \"Times New Roman\" instead of \"Times\" \
under MS Windows seems to cause much lower rate of drawing glitches, at least \
under ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.1 front end.\n\tOn other hand, \"Times\" yields much better text in \
direct export of PDF under ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6."
}], "Text",
 CellChangeTimes->{{3.411677559578125*^9, 3.411677617515625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefaultFontFamily", "=", "\"\<Times\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.411677624484375*^9, 3.411677628265625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeObject", ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Overall", " ", "color"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Color", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Opacity", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Outline", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ShowLine", "\[Rule]", "True"}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"LineColor", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"LineOpacity", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"Thickness", "\[Rule]", "1"}], ",", 
      RowBox[{"CapForm", "\[Rule]", "None"}], ",", 
      RowBox[{"Dashing", "\[Rule]", "None"}], ",", 
      RowBox[{"DashingGap", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"DashingCorrection", "\[Rule]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"$VersionNumber", "\[GreaterEqual]", "7.0"}], ",", "False", 
         ",", "True"}], "]"}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Fill", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ShowFill", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"FillColor", "->", "Automatic"}], ",", 
      RowBox[{"FillOpacity", "->", "Automatic"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Text", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FontFamily", "\[Rule]", "$DefaultFontFamily"}], ",", 
      RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
      RowBox[{"FontWeight", "->", "\"\<Plain\>\""}], ",", 
      RowBox[{"FontSlant", "->", "\"\<Plain\>\""}], ",", 
      RowBox[{"FontTracking", " ", "->", "\"\<Plain\>\""}], ",", 
      RowBox[{"FontColor", "->", "Automatic"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FontOpacity", "->", "Automatic"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"General", " ", "rendering"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Tooltip", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Layer", "->", "Automatic"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ClipToRectangle", "\[Rule]", "True"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Object", " ", "management"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Tag", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ConditionalOptions", "\[Rule]", 
       RowBox[{"{", "}"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", "InheritanceMode"}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39552000415625*^9, 3.395520009109375*^9}, {
   3.396634483765625*^9, 3.396634488359375*^9}, {3.3966347294375*^9, 
   3.3966347504375*^9}, {3.43153966403125*^9, 3.43153966903125*^9}, {
   3.45634629953125*^9, 3.45634630765625*^9}, {3.456346679796875*^9, 
   3.456346690453125*^9}, 3.45634800375*^9, {3.46514050934375*^9, 
   3.46514052215625*^9}, {3.486810196890625*^9, 3.486810199625*^9}, {
   3.496054668953125*^9, 3.496054671515625*^9}, {3.502555107796875*^9, 
   3.502555108015625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Level objects", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"Lev", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
       "BasicOpts", ",", "ObjectOpts", ",", "OutlineOpts", ",", "TextOpts"}], 
       "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Line", " ", "geometry", " ", "margin"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Margin", "\[Rule]", "0.1"}], ",", "\[IndentingNewLine]", 
      RowBox[{"EnergyNudge", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabLOpts", ",", "LabROpts", ",", "LabTOpts", ",", "LabBOpts", ",", 
      "LabCOpts", ",", "\[IndentingNewLine]", 
      RowBox[{"EnergyLabelFunction", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DecimalDigits", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Gull", " ", "wings"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"WingHeight", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"WingRiseWidth", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"WingTipWidth", "\[Rule]", "30"}], ",", "\[IndentingNewLine]", 
      RowBox[{"MakeWingL", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"MakeWingR", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Layer", " ", "override"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LineToFront", "\[Rule]", "False"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.42626144325*^9, 3.426261450171875*^9}, {
  3.49226530534375*^9, 3.492265307734375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"ExtensionLine", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Extension", " ", "line", " ", "endpoint", " ", "coordinates"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ToWing", "\[Rule]", "True"}], "\[IndentingNewLine]", "}"}], ",",
     "\[IndentingNewLine]", "InheritanceMode"}], "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"Connector", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "}"}], ",", "InheritanceMode"}], "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transition arrow objects", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"Trans", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
       "BasicOpts", ",", "OutlineOpts", ",", "FillOpts", ",", "TextOpts"}], 
       "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Arrow", " ", "shape", " ", "properties"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ArrowType", "\[Rule]", "LineArrow"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ArrowHalf", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Width", " ", "\[Rule]", "5"}], ",", "\[IndentingNewLine]", 
      RowBox[{"TailBevel", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShaftLines", "\[Rule]", "2"}], ",", "\[IndentingNewLine]", 
      RowBox[{"SquiggleBuffer", "\[Rule]", "2"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"SquiggleWavelength", "\[Rule]", "10"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SquiggleSide", "\[Rule]", "Right"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotPoints", "\[Rule]", "32"}], ",", "\[IndentingNewLine]", 
      "ArrowheadOpts", ",", "\[IndentingNewLine]", 
      RowBox[{"Kink", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTail", "\[Rule]", "False"}], ",", 
      RowBox[{"ShowHead", "\[Rule]", "True"}], ",", "  ", 
      "\[IndentingNewLine]", 
      RowBox[{"TailRecess", "\[Rule]", "0"}], ",", 
      RowBox[{"HeadRecess", "\[Rule]", "0"}], ",", "  ", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Conversion", " ", "fill", " ", "properties"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ConversionColor", "\[Rule]", "White"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ConversionSide", "\[Rule]", "Right"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ConversionCoeff", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabLOpts", ",", 
      RowBox[{"PosnL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AboveKinkL", "\[Rule]", "False"}], ",", 
      RowBox[{"SegmentL", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "LabROpts", ",", 
      RowBox[{"PosnR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AboveKinkR", "\[Rule]", "False"}], ",", 
      RowBox[{"SegmentR", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "LabCOpts", ",", 
      RowBox[{"PosnC", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AboveKinkC", "\[Rule]", "False"}], ",", 
      RowBox[{"SegmentC", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "LabTOpts", ",", 
      RowBox[{"PosnT", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Endpoint", " ", "coordinates", " ", "when", " ", "between", " ", 
        "levels"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"EndPositions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.5"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FromWing", "\[Rule]", "False"}], ",", 
      RowBox[{"ToWing", "\[Rule]", "False"}]}], "\[IndentingNewLine]", "}"}], 
    ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.488200163890625*^9, 3.4882001784375*^9}, {
  3.488401157046875*^9, 3.488401159890625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Label objects", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"ManualLabel", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "TextOpts"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "LabOpts", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"callout", " ", "line", " ", 
       RowBox[{"control", " ", "--"}], " ", "TO", " ", "IMPLEMENT", " ", 
       RowBox[{"w", "/", " ", "Recess"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"CallOutVector", "\[Rule]", "None"}], " ", "*)"}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"ScaledLabel", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "TextOpts"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "LabOpts", "}"}], ",", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"BandLabel", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "TextOpts"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "LabOpts", "}"}], ",", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"LevelLabel", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts", ",", "TextOpts"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"LabOpts", ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Callout", " ", "line", " ", "and", " ", "horizontal", " ", "gap", " ",
         "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"CallOutVector", "\[Rule]", "None"}], ",", 
      RowBox[{"Gap", "\[Rule]", "0"}]}], " ", "\[IndentingNewLine]", "}"}], 
    ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.488200691578125*^9, 3.4882007084375*^9}, {
  3.488201035578125*^9, 3.488201058890625*^9}, {3.488201153046875*^9, 
  3.488201175578125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", "\[IndentingNewLine]", 
   RowBox[{"ManualLabel3D", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "TextOpts"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Offset", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Nudge", "\[Rule]", "0"}], ","}], "*)"}], 
      RowBox[{"Orientation", "->", "Automatic"}], ",", 
      RowBox[{"ShowText", "\[Rule]", "True"}], ",", 
      RowBox[{"Background", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"3", "D", " ", "supplement"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"GeometricTransformation", "\[Rule]", 
       RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.45969861015625*^9, 3.459698644015625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Drawing shape objects", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeLine", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts", ",", "TextOpts"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Arrow", " ", "shape", " ", "properties"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"ArrowheadOpts", ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTail", "\[Rule]", "False"}], ",", 
      RowBox[{"ShowHead", "\[Rule]", "False"}], ",", "  ", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabLOpts", ",", 
      RowBox[{"PosnL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"BufferL", "\[Rule]", "Automatic"}], ","}], "*)"}], 
      "\[IndentingNewLine]", "LabROpts", ",", 
      RowBox[{"PosnR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"BufferR", "\[Rule]", "Automatic"}], ","}], "*)"}], 
      "\[IndentingNewLine]", "LabTOpts", ",", 
      RowBox[{"PosnT", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferT", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabBOpts", ",", 
      RowBox[{"PosnB", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferB", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabCOpts", ",", 
      RowBox[{"PosnC", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"graphics", " ", "curve", " ", "extraction"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "\[Rule]", "False"}]}], "\[IndentingNewLine]", "}"}], 
    ",", "\[IndentingNewLine]", "InheritanceMode"}], "\[IndentingNewLine]", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemePoints", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts", ",", "FillOpts"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SymbolSize", "\[Rule]", "2.5"}], ",", 
      RowBox[{"SymbolShape", "\[Rule]", "\"\<Circle\>\""}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "16"}]}], "}"}], ",", 
    "InheritanceMode"}], "]"}], ";", 
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemePolygon", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts", ",", "FillOpts"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Outline", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ShowEdge", "\[Rule]", "Automatic"}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeCircle", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
       "BasicOpts", ",", "OutlineOpts", ",", "FillOpts", ",", "TextOpts"}], 
       "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Arrow", " ", "shape", " ", "properties"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"ArrowheadOpts", ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTail", "\[Rule]", "False"}], ",", 
      RowBox[{"ShowHead", "\[Rule]", "False"}], ",", "  ", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabLOpts", ",", "LabROpts", ",", "LabTOpts", ",", "LabBOpts", ",", 
      "LabCOpts", ",", "LabXOpts", ",", 
      RowBox[{"BufferX", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PosnX", "\[Rule]", "Automatic"}]}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeEllipse", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
       "BasicOpts", ",", "OutlineOpts", ",", "FillOpts", ",", "TextOpts"}], 
       "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Plotting", " ", "control"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PlotPoints", "\[Rule]", "90"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Arrow", " ", "shape", " ", "properties"}], " ", "*)"}], 
      "\[IndentingNewLine]", "ArrowheadOpts", ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTail", "\[Rule]", "False"}], ",", 
      RowBox[{"ShowHead", "\[Rule]", "False"}], ",", "  ", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabLOpts", ",", "LabROpts", ",", "LabTOpts", ",", "LabBOpts", ",", 
      "LabCOpts", ",", "LabXOpts", ",", 
      RowBox[{"BufferX", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PosnX", "\[Rule]", "Automatic"}]}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeBox", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
       "BasicOpts", ",", "OutlineOpts", ",", "FillOpts", ",", "TextOpts"}], 
       "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
     "LabLOpts", ",", "LabROpts", ",", "LabTOpts", ",", "LabBOpts", ",", 
      "LabCOpts"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeSquare", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
       "BasicOpts", ",", "OutlineOpts", ",", "FillOpts", ",", "TextOpts"}], 
       "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
     "LabLOpts", ",", "LabROpts", ",", "LabTOpts", ",", "LabBOpts", ",", 
      "LabCOpts"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeArrow", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
       "BasicOpts", ",", "OutlineOpts", ",", "FillOpts", ",", "TextOpts"}], 
       "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Arrow", " ", "shape", " ", 
       RowBox[{"properties", " ", "--"}], " ", "default", " ", "for", " ", 
       "TailBevel", " ", "differs", " ", "from", " ", "Trans"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ArrowType", "\[Rule]", "LineArrow"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ArrowHalf", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Width", " ", "\[Rule]", "5"}], ",", "\[IndentingNewLine]", 
      RowBox[{"TailBevel", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShaftLines", "\[Rule]", "2"}], ",", "\[IndentingNewLine]", 
      RowBox[{"SquiggleBuffer", "\[Rule]", "2"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"SquiggleWavelength", "\[Rule]", "10"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SquiggleSide", "\[Rule]", "Right"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotPoints", "\[Rule]", "32"}], ",", "\[IndentingNewLine]", 
      "ArrowheadOpts", ",", "\[IndentingNewLine]", 
      RowBox[{"Kink", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTail", "\[Rule]", "False"}], ",", 
      RowBox[{"ShowHead", "\[Rule]", "True"}], ",", "  ", 
      "\[IndentingNewLine]", 
      RowBox[{"TailRecess", "\[Rule]", "0"}], ",", 
      RowBox[{"HeadRecess", "\[Rule]", "0"}], ",", "  ", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Conversion", " ", "fill", " ", "properties"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ConversionColor", "\[Rule]", "White"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ConversionSide", "\[Rule]", "Right"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ConversionCoeff", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabLOpts", ",", 
      RowBox[{"PosnL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AboveKinkL", "\[Rule]", "False"}], ",", 
      RowBox[{"SegmentL", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "LabROpts", ",", 
      RowBox[{"PosnR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AboveKinkR", "\[Rule]", "False"}], ",", 
      RowBox[{"SegmentR", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "LabCOpts", ",", 
      RowBox[{"PosnC", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AboveKinkC", "\[Rule]", "False"}], ",", 
      RowBox[{"SegmentC", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "LabTOpts", ",", 
      RowBox[{"PosnT", "\[Rule]", "Automatic"}]}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeBracket", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts", ",", "TextOpts"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "Geometry", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"EnergyNudge", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Arrowhead", " ", "control"}], " ", "*)"}], 
      "\[IndentingNewLine]", "ArrowheadOpts", ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabBOpts", ",", 
      RowBox[{"PosnB", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferB", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabLOpts", ",", 
      RowBox[{"PosnL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferL", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabTOpts", ",", 
      RowBox[{"PosnT", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferT", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabROpts", ",", 
      RowBox[{"PosnR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferR", "\[Rule]", "Automatic"}]}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeLine3D", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Color", ",", "Opacity", ",", "Show"}], "}"}], ",", 
        "OutlineOpts"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"3", "D", " ", "supplement"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"GeometricTransformation", "\[Rule]", 
      RowBox[{"IdentityMatrix", "[", "3", "]"}]}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeArrow3D", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Color", ",", "Opacity", ",", "Show"}], "}"}], ",", 
        "OutlineOpts", ",", "TextOpts"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Arrow", " ", "shape", " ", "properties"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ArrowType", "\[Rule]", "LineArrow"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"HeadLength", "\[Rule]", "0.1"}], ",", "\[IndentingNewLine]", 
      RowBox[{"HeadLip", "\[Rule]", "0.1"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTail", "\[Rule]", "False"}], ",", 
      RowBox[{"ShowHead", "\[Rule]", "True"}], " ", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabCOpts", ",", 
      RowBox[{"PosnC", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"3", "D", " ", "supplement"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"GeometricTransformation", "\[Rule]", 
       RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\n"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.396634772359375*^9, 3.3966347775*^9}, {
   3.459698656125*^9, 3.459698666*^9}, {3.461095226640625*^9, 
   3.4610952338125*^9}, 3.4882002125625*^9, {3.488401057671875*^9, 
   3.4884010795625*^9}, {3.488401163765625*^9, 3.48840117765625*^9}, 
   3.488836276359375*^9, {3.48968787015625*^9, 3.489687899625*^9}, {
   3.492381398328125*^9, 3.492381409125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Raw graphics objects", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"RawGraphics", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"{", 
       RowBox[{
       "Color", ",", "Opacity", ",", "Thickness", ",", "CapForm", ",", 
        "Dashing", ",", "DashingGap", ",", "DashingCorrection", ",", "Show", 
        ",", "Layer", ",", "ClipToRectangle"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "UNDOCUMENTED", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Debug", "\[Rule]", "False"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"FigGraphics", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"{", 
       RowBox[{
       "Color", ",", "Opacity", ",", "Thickness", ",", "CapForm", ",", 
        "Dashing", ",", "DashingGap", ",", "DashingCorrection", ",", "Show", 
        ",", "Layer", ",", "ClipToRectangle"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "UNDOCUMENTED", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Debug", "\[Rule]", "False"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"RawGraphics3D", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"{", 
       RowBox[{
       "Color", ",", "Opacity", ",", "Thickness", ",", "CapForm", ",", 
        "Dashing", ",", "DashingGap", ",", "DashingCorrection", ",", "Show"}],
        "}"}]}], "}"}], ",", 
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"3", "D", " ", "supplement"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"GeometricTransformation", "\[Rule]", 
       RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "UNDOCUMENTED", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Debug", "\[Rule]", "False"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"ViewPort3D", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"{", 
       RowBox[{"Show", ",", "Layer"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Fill", " ", 
       RowBox[{"control", " ", "--"}], " ", "differs", " ", "from", " ", 
       RowBox[{"Color", "/", "FillColor"}], " ", "and", " ", "ShowFill", " ", 
       "convention", " ", "of", " ", "other", " ", "objects"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
     "BackgroundOpts", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Option", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"BlockOptions", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"3", "D", " ", "display", " ", "options"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"EulerRotation", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxisScaling", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Complement", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Options", "[", "Graphics3D", "]"}], ",", 
        RowBox[{"Cases", "[", 
         RowBox[{
          RowBox[{"Options", "[", "Graphics3D", "]"}], ",", 
          RowBox[{"x", ":", 
           RowBox[{"(", 
            RowBox[{"Background", "\[Rule]", "_"}], ")"}]}]}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "UNDOCUMENTED", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Debug", "\[Rule]", "False"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"ScaledViewPort3D", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"{", 
       RowBox[{"Show", ",", "Layer"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Fill", " ", 
       RowBox[{"control", " ", "--"}], " ", "differs", " ", "from", " ", 
       RowBox[{"Color", "/", "FillColor"}], " ", "and", " ", "ShowFill", " ", 
       "convention", " ", "of", " ", "other", " ", "objects"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
     "BackgroundOpts", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Option", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"BlockOptions", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"3", "D", " ", "display", " ", "options"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"EulerRotation", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxisScaling", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Complement", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Options", "[", "Graphics3D", "]"}], ",", 
        RowBox[{"Cases", "[", 
         RowBox[{
          RowBox[{"Options", "[", "Graphics3D", "]"}], ",", 
          RowBox[{"x", ":", 
           RowBox[{"(", 
            RowBox[{"Background", "\[Rule]", "_"}], ")"}]}]}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "UNDOCUMENTED", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Debug", "\[Rule]", "False"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395091941515625*^9, 3.3950919419375*^9}, {
  3.395520016171875*^9, 3.39552002559375*^9}, {3.396634782765625*^9, 
  3.396634792140625*^9}, {3.396636698796875*^9, 3.39663673590625*^9}, {
  3.396636814265625*^9, 3.39663682515625*^9}, {3.459698673296875*^9, 
  3.45969867521875*^9}, {3.486810218140625*^9, 3.486810229796875*^9}, {
  3.48828250496875*^9, 3.4882825096875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Axes and panels", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"PanelLetter", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"First", "->", "\"\<a\>\""}], ",", 
      RowBox[{"PanelLetterOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ",", 
      RowBox[{"Order", "\[Rule]", "Horizontal"}], ",", 
      RowBox[{"Format", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<(\>\"", ",", "\"\<)\>\""}], "}"}]}]}], "}"}], ",", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"FigurePanel", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Color", ",", "Opacity", ",", "Show", ",", "Layer"}], "}"}], 
        ",", "OutlineOpts", ",", "TextOpts"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"PanelLetter", ",", "All"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Panel", " ", "coordinate", " ", "range"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"XPlotRange", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"YPlotRange", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ExtendRange", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Panel", " ", "geometry", " ", 
        RowBox[{"adjustments", " ", "--"}], " ", "generic"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Margin", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Panel", " ", "geometry", " ", 
        RowBox[{"adjustments", " ", "--"}], " ", "in", " ", "Multipanel", " ",
         "array", " ", "only"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PanelShift", "\[Rule]", "None"}], ",", 
      RowBox[{"PanelAdjustments", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Fill", " ", 
        RowBox[{"control", " ", "--"}], " ", "differs", " ", "from", " ", 
        RowBox[{"Color", "/", "FillColor"}], " ", "and", " ", "ShowFill", " ",
         "convention", " ", "of", " ", "other", " ", "objects"}], " ", "*)"}],
       "\[IndentingNewLine]", "BackgroundOpts", ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Frame", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowEdge", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]}], ",",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabBOpts", ",", 
      RowBox[{"PosnB", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferB", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabLOpts", ",", 
      RowBox[{"PosnL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferL", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabTOpts", ",", 
      RowBox[{"PosnT", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferT", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabROpts", ",", 
      RowBox[{"PosnR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferR", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ShowFrameLabels", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", 
        RowBox[{"control", " ", "--"}], " ", "multipanel", " ", "only"}], " ",
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ShowFrameLabelsExterior", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"ShowFrameLabelsInterior", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "False", ",", "False", ",", "False"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"ExteriorMask", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Panel", " ", "letter", " ", "control"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PanelLetter", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"PanelLetterInset", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"15", ",", "15"}], "}"}]}], ",", "\[IndentingNewLine]", 
      "PanelLetterTextOpts", ",", "\[IndentingNewLine]", "PanelLetterOpts", 
      ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Tick", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTicks", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ShowTickLabels", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"TickNudge", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"TickOptions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"TickLabelMargin", "\[Rule]", "0"}], ",", "\[IndentingNewLine]",
       "TickTextOpts", ",", "\[IndentingNewLine]", "TickOutlineOpts", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Tick", " ", 
        RowBox[{"control", " ", "--"}], " ", "multipanel", " ", "only"}], " ",
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ShowTickLabelsExterior", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTickLabelsInterior", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "False", ",", "False", ",", "False"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"TickLabelAutoSuppress", "\[Rule]", "False"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"ScaledFigurePanel", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Color", ",", "Opacity", ",", "Show", ",", "Layer"}], "}"}], 
        ",", "OutlineOpts", ",", "TextOpts"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"PanelLetter", ",", "All"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Panel", " ", "coordinate", " ", "range"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"XPlotRange", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"YPlotRange", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ExtendRange", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Panel", " ", "geometry", " ", 
        RowBox[{"adjustments", " ", "--"}], " ", "generic"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Margin", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Panel", " ", "geometry", " ", 
        RowBox[{"adjustments", " ", "--"}], " ", "in", " ", "Multipanel", " ",
         "array", " ", "only"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"not", " ", "applicable", " ", "to", " ", "ScaledPanel"}], " ",
        "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Fill", " ", 
        RowBox[{"control", " ", "--"}], " ", "differs", " ", "from", " ", 
        RowBox[{"Color", "/", "FillColor"}], " ", "and", " ", "ShowFill", " ",
         "convention", " ", "of", " ", "other", " ", "objects"}], " ", "*)"}],
       "\[IndentingNewLine]", "BackgroundOpts", ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Frame", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowEdge", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]}], ",",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "label", " ", "control"}], " ", "*)"}], 
      "\[IndentingNewLine]", "LabBOpts", ",", 
      RowBox[{"PosnB", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferB", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabLOpts", ",", 
      RowBox[{"PosnL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferL", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabTOpts", ",", 
      RowBox[{"PosnT", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferT", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabROpts", ",", 
      RowBox[{"PosnR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferR", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ShowFrameLabels", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Panel", " ", "letter", " ", "control"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PanelLetter", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"PanelLetterInset", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"15", ",", 
         RowBox[{"-", "15"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      "PanelLetterTextOpts", ",", "\[IndentingNewLine]", "PanelLetterOpts", 
      ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Frame", " ", "ticks"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTicks", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ShowTickLabels", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"TickNudge", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"TickOptions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"TickLabelMargin", "\[Rule]", "0"}], ",", "\[IndentingNewLine]",
       "TickTextOpts", ",", "\[IndentingNewLine]", "TickOutlineOpts"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"Multipanel", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"FigurePanel", ",", "\[IndentingNewLine]", 
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"First", "/@", 
         RowBox[{"Options", "[", "FigurePanel", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
         "PlotRange", ",", "XPlotRange", ",", "YPlotRange", ",", "LabB", ",", 
          "LabL", ",", "LabT", ",", "LabR", ",", "FrameLabel", ",", 
          "FrameTicks", ",", "TickLabelMargin", ",", "PanelLetter", ",", 
          "Margin"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "Geometry", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"XPanelSizes", "\[Rule]", "1"}], ",", 
      RowBox[{"YPanelSizes", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
      RowBox[{"XGapSizes", "\[Rule]", "0"}], ",", 
      RowBox[{"YGapSizes", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"XMarginSizes", "\[Rule]", "0"}], ",", 
      RowBox[{"YMarginSizes", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Margin", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Panel", " ", "appearance"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"XPlotRanges", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"YPlotRanges", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"XFrameLabels", "\[Rule]", "None"}], ",", 
      RowBox[{"YFrameLabels", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"XFrameTicks", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"YFrameTicks", "\[Rule]", "Automatic"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"SchemeAxis", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts", ",", "TextOpts"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Arrowhead", " ", "control"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ShowHead", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      "ArrowheadOpts", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Label", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      "LabBOpts", ",", 
      RowBox[{"PosnB", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferB", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabLOpts", ",", 
      RowBox[{"PosnL", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferL", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabTOpts", ",", 
      RowBox[{"PosnT", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferT", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabROpts", ",", 
      RowBox[{"PosnR", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferR", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Frame", " ", "ticks"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTicks", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ShowTickLabels", "\[Rule]", "True"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"TickNudge", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      "TickTextOpts", ",", "\[IndentingNewLine]", "TickOutlineOpts", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"axis", " ", "geometry"}], " ", "*)"}], "\[IndentingNewLine]", 
      
      RowBox[{"AxesOrigin", "\[Rule]", "Automatic"}]}], "\[IndentingNewLine]",
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "InheritanceMode"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3950922848125*^9, 3.395092301375*^9}, 
   3.395092333765625*^9, {3.39552125125*^9, 3.3955212513125*^9}, {
   3.39663481503125*^9, 3.396634824703125*^9}, {3.396636743921875*^9, 
   3.396636744609375*^9}, {3.39663682884375*^9, 3.39663683403125*^9}, {
   3.421621477265625*^9, 3.42162151484375*^9}, {3.421621553828125*^9, 
   3.42162155596875*^9}, {3.4244591425*^9, 3.424459151359375*^9}, {
   3.42601533446875*^9, 3.42601533628125*^9}, {3.428252017109375*^9, 
   3.42825203559375*^9}, {3.4282523096875*^9, 3.428252310921875*^9}, {
   3.434484689015625*^9, 3.4344847040625*^9}, {3.434485322546875*^9, 
   3.434485363921875*^9}, {3.434486275265625*^9, 3.434486282984375*^9}, {
   3.434487339421875*^9, 3.4344873609375*^9}, 3.4344876520625*^9, {
   3.43448768315625*^9, 3.43448772075*^9}, 3.4344880685*^9, 
   3.4344886773125*^9, {3.45954625196875*^9, 3.45954625765625*^9}, {
   3.46108910028125*^9, 3.461089114796875*^9}, {3.464879256*^9, 
   3.464879265484375*^9}, {3.4648793145625*^9, 3.4648793454375*^9}, {
   3.464880832828125*^9, 3.46488083996875*^9}, 3.464881963515625*^9, {
   3.46488246303125*^9, 3.464882466640625*^9}, {3.466947091953125*^9, 
   3.46694709984375*^9}, {3.4669473234375*^9, 3.4669473321875*^9}, {
   3.46694739978125*^9, 3.466947416015625*^9}, {3.488401189265625*^9, 
   3.488401190046875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data plotting", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"AttachIndex", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"First", "\[Rule]", "1"}], ",", 
      RowBox[{"ScaleFactor", "\[Rule]", "1"}]}], "}"}], ",", 
    "InheritanceMode"}], "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DataPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", "ObjectOpts"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ShowData", "\[Rule]", "True"}], ",", 
      RowBox[{"Debug", "\[Rule]", "False"}], ",", 
      RowBox[{"DataLine", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"DataSymbol", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"DataValues", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"DataStyle", "\[Rule]", "None"}]}], "}"}], ",", 
    "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DataTag", ",", 
    RowBox[{"{", "}"}], ",", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DefineDataStyle", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"DataLine", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"DataSymbol", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"DataStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Debug", "\[Rule]", "False"}]}], "}"}], ",", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"UseDataOptions", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"DataLine", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"DataSymbol", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"DataStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Debug", "\[Rule]", "False"}]}], "}"}], ",", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DataLabel", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "TextOpts"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"LabLOpts", ",", 
      RowBox[{"PosnL", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]", 
      "LabROpts", ",", 
      RowBox[{"PosnR", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]", 
      "LabTOpts", ",", 
      RowBox[{"PosnT", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferT", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabBOpts", ",", 
      RowBox[{"PosnB", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BufferB", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
       "LabCOpts", ",", 
      RowBox[{"PosnC", "\[Rule]", "Automatic"}]}], "\[IndentingNewLine]", 
     "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.464965186671875*^9, 3.46496518996875*^9}, {
   3.464965473265625*^9, 3.4649654816875*^9}, {3.464971467296875*^9, 
   3.464971519546875*^9}, {3.465141227*^9, 3.465141262546875*^9}, 
   3.46514135325*^9, 3.46720950028125*^9, {3.467209813203125*^9, 
   3.46720982309375*^9}, {3.467211022078125*^9, 3.46721103259375*^9}, 
   3.467211065125*^9, {3.467211856921875*^9, 3.467211886390625*^9}, 
   3.46721201059375*^9, {3.4883686579375*^9, 3.4883686741875*^9}, 
   3.488368767578125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DataLine", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts", ",", 
        RowBox[{"Complement", "[", 
         RowBox[{"FillOpts", ",", 
          RowBox[{"{", "ShowFill", "}"}]}], "]"}]}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"LineShape", "\[Rule]", "\"\<Straight\>\""}], ",", 
      RowBox[{"IgnoreMissingValues", "\[Rule]", "False"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "3"}], ",", 
      RowBox[{"ShowFill", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Transpose", "\[Rule]", "False"}]}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"quick", " ", 
       RowBox[{"fix", " ", "--"}], " ", "TO", " ", "REVISIT"}], " ", "*)"}], 
     "\[IndentingNewLine]", "}"}], ",", "InheritanceMode"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DataSymbol", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"BasicOpts", ",", "OutlineOpts", ",", "FillOpts"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SymbolSize", "\[Rule]", "2.5"}], ",", 
      RowBox[{"SymbolShape", "\[Rule]", "\"\<Circle\>\""}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "16"}]}], "}"}], ",", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DataValues", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AxisScaling", "\[Rule]", "None"}], ",", 
      RowBox[{"DataFilters", "\[Rule]", "None"}]}], "}"}], ",", 
    "InheritanceMode"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DataSet", ",", 
    RowBox[{"{", 
     RowBox[{"DataColumns", "\[Rule]", "Automatic"}], "}"}], ",", 
    "InheritanceMode"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.398797191609375*^9, {3.398797531546875*^9, 3.398797545015625*^9}, {
   3.48468621225*^9, 3.48468622821875*^9}, {3.4846868054375*^9, 
   3.484686831640625*^9}, {3.488367551875*^9, 3.488367554921875*^9}, {
   3.488368685765625*^9, 3.488368690296875*^9}, {3.4883687975625*^9, 
   3.488368807625*^9}, {3.502902024359375*^9, 3.502902036921875*^9}, {
   3.511968953296875*^9, 3.51196897009375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"DataLegend", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
       "BasicOpts", ",", "OutlineOpts", ",", "FillOpts", ",", "TextOpts"}], 
       "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"LabOpts", ",", 
      RowBox[{"Length", "\[Rule]", "10"}], ",", 
      RowBox[{"Gap", "\[Rule]", "5"}], ",", 
      RowBox[{"Width", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"LineSpacing", "\[Rule]", "1.1"}], ",", 
      RowBox[{"Dimensions", "\[Rule]", "Automatic"}]}], "}"}], ",", 
    "\[IndentingNewLine]", "InheritanceMode"}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.50319062296875*^9, 3.503190641015625*^9}, {
  3.50319089440625*^9, 3.50319091040625*^9}, {3.5031912756875*^9, 
  3.503191283359375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure display", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"Figure", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Color", ",", "Opacity"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "LineColor", ",", "LineOpacity", ",", "Thickness", ",", "CapForm", 
          ",", "Dashing", ",", "DashingGap", ",", "DashingCorrection"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "FontFamily", ",", "FontSize", ",", "FontWeight", ",", "FontSlant", 
          ",", "FontTracking", ",", "FontColor", ",", "FontOpacity"}], 
         "}"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "inherited", " ", "outline", " ", "and", " ", "text", " ", "options", 
       " ", "control", " ", "frame", " ", "line", " ", "and", " ", "labels", 
       " ", "but", " ", "not", " ", "frame", " ", "ticks"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Plot", " ", "region", " ", "control"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ExtendRange", "\[Rule]", "0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Axes", " ", "and", " ", "frame", " ", "control"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabB", "\[Rule]", "None"}], ",", 
      RowBox[{"LabL", "\[Rule]", "None"}], ",", 
      RowBox[{"LabT", "\[Rule]", "None"}], ",", 
      RowBox[{"LabR", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Tick", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      "TickTextOpts", ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"TickOutlineOpts", " ", "not", " ", "supported"}], " ", "*)"}],
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Rendering", " ", "properties"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Background", "\[Rule]", "None"}], ",", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"BackgroundOpacity", " ", "not", " ", "supported"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Option", " ", "control"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "DEPRECATED", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"BlockOptions", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "scoping", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Block", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Conditional", " ", "inclusion"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"SchemeFlags", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"UNDOCUMENTED", " ", "debugging", " ", "options"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Information", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Debug", "\[Rule]", "False"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395089240171875*^9, 3.395089242*^9}, {
  3.395520033515625*^9, 3.39552003390625*^9}, {3.396634492796875*^9, 
  3.396634496671875*^9}, {3.39663483340625*^9, 3.396634847453125*^9}, {
  3.396636853234375*^9, 3.3966368624375*^9}, {3.396637299125*^9, 
  3.396637317609375*^9}, {3.48681024925*^9, 3.4868102511875*^9}, {
  3.505334836515625*^9, 3.505334862328125*^9}, {3.51232252090625*^9, 
  3.512322529703125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Utilities", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"LineStyle", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"{", 
       RowBox[{
       "Color", ",", "Opacity", ",", "LineColor", ",", "LineOpacity", ",", 
        "Thickness", ",", "CapForm", ",", "Dashing", ",", "DashingGap", ",", 
        "DashingCorrection"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefineOptions", "[", 
   RowBox[{"FillStyle", ",", 
    RowBox[{"{", 
     RowBox[{"SchemeObject", ",", 
      RowBox[{"{", 
       RowBox[{
       "Color", ",", "Opacity", ",", "FillColor", ",", "FillOpacity"}], 
       "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "InheritanceMode"}], 
   "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395520038015625*^9, 3.39552003846875*^9}, {
  3.39663485534375*^9, 3.396634875828125*^9}, {3.486810259390625*^9, 
  3.48681026121875*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordinate system arithmetic", "Section"],

Cell[CellGroupData[{

Cell["Coordinate arithmetic definitions", "Subsection"],

Cell["\<\
Global coordinate system parameters
   $AbsSize={x size,y size}
   $P1C={x1C,y1C};$P2C={x2C,y2C}     equivalent to \
$CanvasRange={{x1C,x2C},{y1C,y2C}}
   $P3C={x3C,y3C};$P4C={x4C,y4C}     equivalent to \
$RegionRange={{x3C,x4C},{y3C,y4C}} 
   $P3R={x3R,y3R};$P4R={x4R,y4R}\
\>", "Text"],

Cell["Coordinate system nomenclature", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"CoordinateSystems", "=", 
   RowBox[{"{", 
    RowBox[{
    "CanvasCoords", ",", "AbsoluteCoords", ",", "RegionCoords", ",", 
     "ScaledCoords", ",", "UserCoords"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CoordinateSystemAbbreviation", "[", "CanvasCoords", "]"}], "=", 
   "\"\<C\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CoordinateSystemAbbreviation", "[", "AbsoluteCoords", "]"}], "=", 
   "\"\<A\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CoordinateSystemAbbreviation", "[", "RegionCoords", "]"}], "=", 
   "\"\<R\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CoordinateSystemAbbreviation", "[", "ScaledCoords", "]"}], "=", 
   "\"\<S\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CoordinateSystemAbbreviation", "[", "UserCoords", "]"}], "=", 
   "\"\<U\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CoordinateSystemQ", "[", "SystemA_", "]"}], ":=", 
   RowBox[{"MemberQ", "[", 
    RowBox[{"CoordinateSystems", ",", "SystemA"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Set up special context for coordinate arithmetic variables
\tThe following code serves to establish the symbols CoordA and CoordB and \
the symbols for shorthand conversion functions in a separate context \
LevelScheme`Coord`.
\tThe definition of ConversionFunctionSymbols, it is necessary that the \
symbols for the shorthand functions have no values associated yet, so that \
when ToExpression is applied to the name strings it evaluates just to the \
symbols, not to actual function definitions.  The check on \
ValueQ[ConversionFunctionSymbols] is so that if the package is loaded over \
itself, any leftover values will not cause the definition to fail.
\tHoldPattern facilitates use on LHS of assignment in DefineCoordinates.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Hold", "[", "LevelScheme`Coord`CoordA", "]"}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hold", "[", "LevelScheme`Coord`CoordB", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"ValueQ", "[", "ConversionFunctionSymbols", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ConversionFunctionSymbols", "=", 
     RowBox[{"HoldPattern", "/@", 
      RowBox[{"ToExpression", "/@", 
       RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
        RowBox[{"TableForEach", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"\"\<LevelScheme`Coord`\>\"", "<>", "\"\<P\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemG", "]"}], 
             "<>", "\"\<Of\>\"", "<>", "\"\<P\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemF", "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"\"\<LevelScheme`Coord`\>\"", "<>", "\"\<X\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemG", "]"}], 
             "<>", "\"\<Of\>\"", "<>", "\"\<X\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemF", "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"\"\<LevelScheme`Coord`\>\"", "<>", "\"\<Y\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemG", "]"}], 
             "<>", "\"\<Of\>\"", "<>", "\"\<Y\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemF", "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"\"\<LevelScheme`Coord`\>\"", "<>", "\"\<DP\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemG", "]"}], 
             "<>", "\"\<Of\>\"", "<>", "\"\<P\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemF", "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"\"\<LevelScheme`Coord`\>\"", "<>", "\"\<DX\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemG", "]"}], 
             "<>", "\"\<Of\>\"", "<>", "\"\<X\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemF", "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"\"\<LevelScheme`Coord`\>\"", "<>", "\"\<DY\>\"", "<>", 
             RowBox[{"CoordinateSystemAbbreviation", "[", "SystemG", "]"}], 
             "<>", "\"\<Of\>\"", "<>", "\"\<Y\>\"", "<>", 
             RowBox[{
             "CoordinateSystemAbbreviation", "[", "SystemF", "]"}]}]}], 
           "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"SystemF", ",", "CoordinateSystems"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"SystemG", ",", "CoordinateSystems"}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}]}]}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$ContextPath", ",", "\"\<LevelScheme`Coord`\>\""}], "]"}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Generic conversion function
\tCoordinates must be defined as _ rather than _?NumericQ for proper creation \
of compiled functions below.  This allows pattern matching to occur when \
referenced inside Evalute with still symbolic arguments, so a compilable \
algebraic expression results.  In compiled expression, point must be given as \
explicit coordinate pair rather than single symbol to prevent erroneous \
threading of multiplication.\
\>", "Text",
 InitializationCell->True],

Cell["\<\
Legacy syntax (different coordinate order, numbered axes instead of \
Horizontal and Vertical) retained as underlying implementation\
\>", "Text",
 CellChangeTimes->{{3.48477300740625*^9, 3.484773026*^9}, {
  3.484773284734375*^9, 3.484773293109375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"Type", ":", "C"}], ",", 
     RowBox[{"PF", ":", 
      RowBox[{"{", 
       RowBox[{"_", ",", "_"}], "}"}]}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CoordA", "[", 
     RowBox[{"SystemF", ",", "SystemG"}], "]"}], "+", 
    RowBox[{
     RowBox[{"CoordB", "[", 
      RowBox[{"SystemF", ",", "SystemG"}], "]"}], "*", "PF"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"Type", ":", "D"}], ",", 
     RowBox[{"PF", ":", 
      RowBox[{"{", 
       RowBox[{"_", ",", "_"}], "}"}]}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CoordB", "[", 
     RowBox[{"SystemF", ",", "SystemG"}], "]"}], "*", "PF"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"Type", ":", "C"}], ",", "x_", ",", 
     RowBox[{"Index", ":", 
      RowBox[{"(", 
       RowBox[{"1", "|", "2"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"CoordA", "[", 
      RowBox[{"SystemF", ",", "SystemG"}], "]"}], "[", 
     RowBox[{"[", "Index", "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"CoordB", "[", 
       RowBox[{"SystemF", ",", "SystemG"}], "]"}], "[", 
      RowBox[{"[", "Index", "]"}], "]"}], "*", "x"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{"SystemF_", ",", "SystemG_", ",", 
     RowBox[{"Type", ":", "D"}], ",", "x_", ",", 
     RowBox[{"Index", ":", 
      RowBox[{"(", 
       RowBox[{"1", "|", "2"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"CoordB", "[", 
      RowBox[{"SystemF", ",", "SystemG"}], "]"}], "[", 
     RowBox[{"[", "Index", "]"}], "]"}], "*", "x"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConvertRange", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{"(", 
       RowBox[{"C", "|", "D"}], ")"}]}], ",", 
     RowBox[{"RF", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"Index", ":", 
      RowBox[{"(", 
       RowBox[{"1", "|", "2"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ConvertCoordinate", "[", 
        RowBox[{
        "SystemF", ",", "SystemG", ",", "Type", ",", "#", ",", "Index"}], 
        "]"}], "&"}], ")"}], ",", "RF"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.484773429125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConvertRegion", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{"(", 
       RowBox[{"C", "|", "D"}], ")"}]}], ",", 
     RowBox[{"RF", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}]}], "]"}], ":=", 
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ConvertRange", "[", 
        RowBox[{"SystemF", ",", "SystemG", ",", "Type", ",", "#1", ",", 
         RowBox[{"First", "[", "#2", "]"}]}], "]"}], "&"}], ")"}], ",", 
     "RF"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.484773429125*^9}],

Cell["Is this ever used?", "Text",
 CellChangeTimes->{{3.48477350809375*^9, 3.484773514203125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{"(", 
       RowBox[{"C", "|", "D"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RF1", ":", 
        RowBox[{"{", 
         RowBox[{"_", ",", "_"}], "}"}]}], ",", 
       RowBox[{"RF2", ":", 
        RowBox[{"{", 
         RowBox[{"_", ",", "_"}], "}"}]}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ConvertCoordinate", "[", 
      RowBox[{"SystemF", ",", "SystemG", ",", "Type", ",", "RF1", ",", "1"}], 
      "]"}], ",", 
     RowBox[{"ConvertCoordinate", "[", 
      RowBox[{"SystemF", ",", "SystemG", ",", "Type", ",", "RF2", ",", "2"}], 
      "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{"(", 
       RowBox[{"C", "|", "D"}], ")"}]}], ",", 
     RowBox[{"RF", ":", 
      RowBox[{"{", 
       RowBox[{"_", ",", "_"}], "}"}]}], ",", 
     RowBox[{"Index", ":", 
      RowBox[{"(", 
       RowBox[{"1", "|", "2"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"ConvertCoordinate", "[", 
      RowBox[{
      "SystemF", ",", "SystemG", ",", "Type", ",", "#", ",", "Index"}], "]"}],
      "&"}], "/@", "RF"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell["Modernized syntax -- easier to remember", "Text",
 CellChangeTimes->{{3.484773265296875*^9, 3.4847732680625*^9}, {
  3.48477383259375*^9, 3.484773835390625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "CoordinateSystemQ"}], ")"}], ":", "UserCoords"}]}],
      ",", 
     RowBox[{"Axis", ":", "Horizontal"}], ",", 
     RowBox[{"x_", "?", "NumericQ"}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "|", "D"}], ")"}], ":", "C"}]}]}], "]"}], ":=", 
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{"SystemF", ",", " ", "SystemG", ",", "Type", ",", "x", ",", "1"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "CoordinateSystemQ"}], ")"}], ":", "UserCoords"}]}],
      ",", 
     RowBox[{"Axis", ":", "Vertical"}], ",", 
     RowBox[{"x_", "?", "NumericQ"}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "|", "D"}], ")"}], ":", "C"}]}]}], "]"}], ":=", 
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{"SystemF", ",", " ", "SystemG", ",", "Type", ",", "x", ",", "2"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "CoordinateSystemQ"}], ")"}], ":", "UserCoords"}]}],
      ",", 
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "|", "D"}], ")"}], ":", "C"}]}]}], "]"}], ":=", 
   RowBox[{"ConvertCoordinate", "[", 
    RowBox[{"SystemF", ",", " ", "SystemG", ",", "Type", ",", "P"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.484773083921875*^9, 3.48477315609375*^9}, {
  3.484773186703125*^9, 3.484773277421875*^9}, {3.4847739123125*^9, 
  3.48477396775*^9}, {3.4847743588125*^9, 3.484774373484375*^9}, {
  3.48477460634375*^9, 3.48477462859375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConvertRange", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "CoordinateSystemQ"}], ")"}], ":", "UserCoords"}]}],
      ",", 
     RowBox[{"Axis", ":", "Horizontal"}], ",", 
     RowBox[{"RF", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{"(", 
       RowBox[{"C", "|", "D"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"ConvertRange", "[", 
    RowBox[{
    "SystemF", ",", " ", "SystemG", ",", "Type", ",", "RF", ",", "1"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertRange", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "CoordinateSystemQ"}], ")"}], ":", "UserCoords"}]}],
      ",", 
     RowBox[{"Axis", ":", "Vertical"}], ",", 
     RowBox[{"RF", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{"(", 
       RowBox[{"C", "|", "D"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"ConvertRange", "[", 
    RowBox[{
    "SystemF", ",", " ", "SystemG", ",", "Type", ",", "RF", ",", "2"}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.484773429125*^9, {3.484773983921875*^9, 3.48477403653125*^9}, {
   3.484774380828125*^9, 3.484774401328125*^9}, {3.484774631609375*^9, 
   3.4847746340625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConvertRegion", "[", 
    RowBox[{
     RowBox[{"SystemF_", "?", "CoordinateSystemQ"}], ",", 
     RowBox[{"SystemG", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "CoordinateSystemQ"}], ")"}], ":", "UserCoords"}]}],
      ",", 
     RowBox[{"RF", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Type", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "|", "D"}], ")"}], ":", "C"}]}]}], "]"}], ":=", 
   RowBox[{"ConvertRegion", "[", 
    RowBox[{"SystemF", ",", " ", "SystemG", ",", "Type", ",", "RF"}], "]"}]}],
   ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.484773429125*^9, {3.484774663140625*^9, 3.484774726828125*^9}}],

Cell["Point saving and retrieval", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SavePoint", "[", 
    RowBox[{"ID_", ",", 
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"GivenSystem", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "CoordinateSystemQ"}], ")"}], ":", 
       "UserCoords"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckValue", "[", 
       RowBox[{"ID", ",", 
        RowBox[{"_", "?", "LevelIdentifierQ"}], ",", 
        "\"\<a point identifier symbol (cannot be list or number)\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`P", "[", "ID", "]"}], "=", 
       RowBox[{"ConvertCoordinate", "[", 
        RowBox[{"GivenSystem", ",", "CanvasCoords", ",", "C", ",", "P"}], 
        "]"}]}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GetPoint", "[", 
    RowBox[{"ID_", ",", 
     RowBox[{"GivenSystem", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "CoordinateSystemQ"}], ")"}], ":", 
       "UserCoords"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckPoint", "[", "ID", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ConvertCoordinate", "[", 
       RowBox[{"CanvasCoords", ",", "GivenSystem", ",", "C", ",", 
        RowBox[{"LevelScheme`Data`P", "[", "ID", "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Coordinate system implementation
\t- calculating conversion constants
\t- defining shorthand functions\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefineCoordinates", "[", 
    RowBox[{
    "AbsSize_List", ",", "P1C_List", ",", "P2C_List", ",", "P3C_List", ",", 
     "P4C_List", ",", "P3R_List", ",", "P4R_List", ",", "AUR_List", ",", 
     "BUR_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "SystemF", ",", "SystemG", ",", "FunctionNameStrings", ",", "P", ",", 
       "X", ",", "Y"}], "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "define", " ", "conversion", " ", "constants", " ", "to", " ", "canvas",
        " ", "system"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"CoordA", "[", 
        RowBox[{"CanvasCoords", ",", "CanvasCoords"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0."}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordB", "[", 
        RowBox[{"CanvasCoords", ",", "CanvasCoords"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"1.", ",", "1."}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordA", "[", 
        RowBox[{"AbsoluteCoords", ",", "CanvasCoords"}], "]"}], "=", "P1C"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordB", "[", 
        RowBox[{"AbsoluteCoords", ",", "CanvasCoords"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"P2C", "-", "P1C"}], ")"}], "/", "AbsSize"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordA", "[", 
        RowBox[{"RegionCoords", ",", "CanvasCoords"}], "]"}], "=", 
       RowBox[{"P3C", "-", 
        RowBox[{"P3R", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"P4C", "-", "P3C"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"P4R", "-", "P3R"}], ")"}]}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordB", "[", 
        RowBox[{"RegionCoords", ",", "CanvasCoords"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"P4C", "-", "P3C"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"P4R", "-", "P3R"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordA", "[", 
        RowBox[{"ScaledCoords", ",", "CanvasCoords"}], "]"}], "=", "P3C"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordB", "[", 
        RowBox[{"ScaledCoords", ",", "CanvasCoords"}], "]"}], "=", 
       RowBox[{"P4C", "-", "P3C"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordA", "[", 
        RowBox[{"UserCoords", ",", "CanvasCoords"}], "]"}], "=", 
       RowBox[{"P3C", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"AUR", "-", "P3R"}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"P4C", "-", "P3C"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"P4R", "-", "P3R"}], ")"}]}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CoordB", "[", 
        RowBox[{"UserCoords", ",", "CanvasCoords"}], "]"}], "=", 
       RowBox[{"BUR", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"P4C", "-", "P3C"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"P4R", "-", "P3R"}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "deduce", " ", "conversion", " ", "constants", " ", "to", " ", "any", 
        " ", "other", " ", "system"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DoForEach", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"CoordA", "[", 
           RowBox[{"SystemF", ",", "SystemG"}], "]"}], "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"CoordA", "[", 
              RowBox[{"SystemF", ",", "CanvasCoords"}], "]"}], "-", 
             RowBox[{"CoordA", "[", 
              RowBox[{"SystemG", ",", "CanvasCoords"}], "]"}]}], ")"}], "/", 
           RowBox[{"CoordB", "[", 
            RowBox[{"SystemG", ",", "CanvasCoords"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"CoordB", "[", 
           RowBox[{"SystemF", ",", "SystemG"}], "]"}], "=", 
          RowBox[{
           RowBox[{"CoordB", "[", 
            RowBox[{"SystemF", ",", "CanvasCoords"}], "]"}], "/", 
           RowBox[{"CoordB", "[", 
            RowBox[{"SystemG", ",", "CanvasCoords"}], "]"}]}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"SystemF", ",", "CoordinateSystems"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"SystemG", ",", 
          RowBox[{"Complement", "[", 
           RowBox[{"CoordinateSystems", ",", 
            RowBox[{"{", "CanvasCoords", "}"}]}], "]"}]}], "}"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"define", " ", "private", " ", "shorthand", " ", "operators"}],
        " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Evaluate", "[", "ConversionFunctionSymbols", "]"}], "=", 
       "\[IndentingNewLine]", 
       RowBox[{"SuppressMessage", "[", 
        RowBox[{
         RowBox[{"Part", "::", "partd"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
          RowBox[{"TableForEach", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Compile", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"P", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
                RowBox[{"Evaluate", "[", 
                 RowBox[{"ConvertCoordinate", "[", 
                  RowBox[{"SystemF", ",", "SystemG", ",", "C", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"P", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"P", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], "]"}]}],
                "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Compile", "[", 
               RowBox[{
                RowBox[{"{", "X", "}"}], ",", 
                RowBox[{"Evaluate", "[", 
                 RowBox[{"ConvertCoordinate", "[", 
                  RowBox[{
                  "SystemF", ",", "SystemG", ",", "C", ",", "X", ",", "1"}], 
                  "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Compile", "[", 
               RowBox[{
                RowBox[{"{", "Y", "}"}], ",", 
                RowBox[{"Evaluate", "[", 
                 RowBox[{"ConvertCoordinate", "[", 
                  RowBox[{
                  "SystemF", ",", "SystemG", ",", "C", ",", "Y", ",", "2"}], 
                  "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Compile", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"P", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
                RowBox[{"Evaluate", "[", 
                 RowBox[{"ConvertCoordinate", "[", 
                  RowBox[{"SystemF", ",", "SystemG", ",", "D", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"P", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"P", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], "]"}]}],
                "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Compile", "[", 
               RowBox[{
                RowBox[{"{", "X", "}"}], ",", 
                RowBox[{"Evaluate", "[", 
                 RowBox[{"ConvertCoordinate", "[", 
                  RowBox[{
                  "SystemF", ",", "SystemG", ",", "D", ",", "X", ",", "1"}], 
                  "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Compile", "[", 
               RowBox[{
                RowBox[{"{", "Y", "}"}], ",", 
                RowBox[{"Evaluate", "[", 
                 RowBox[{"ConvertCoordinate", "[", 
                  RowBox[{
                  "SystemF", ",", "SystemG", ",", "D", ",", "Y", ",", "2"}], 
                  "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"SystemF", ",", "CoordinateSystems"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"SystemG", ",", "CoordinateSystems"}], "}"}]}], 
           "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.395092913421875*^9}],

Cell[TextData[{
 "Functions for scaling tick length\n\t",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses scaled coordinates for tick lengths.\n\tHere we use an \"averaged\" \
scaled coordinate based upon the average of the full plot's horizontal and \
vertical sizes, to ensure consistent tick lengths between horizontal and \
vertical axes and between panels."
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DXCTick", ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"DXCOfXA", "[", 
      RowBox[{"$TickScaleFactor", "*", "#"}], "]"}], "&"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DYCTick", ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"DYCOfYA", "[", 
      RowBox[{"$TickScaleFactor", "*", "#"}], "]"}], "&"}], ")"}]}], 
  ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["User control of graphics coordinates", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetOrigin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"y_", "?", "NumericQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"$AUR", "=", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DefineCoordinates", "[", 
       RowBox[{
       "$AbsSize", ",", "$P1C", ",", "$P2C", ",", "$P3C", ",", "$P4C", ",", 
        "$P3R", ",", "$P4R", ",", "$AUR", ",", "$BUR"}], "]"}], ";", 
      "\[IndentingNewLine]", "Null"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetOrigin", "[", 
    RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"SetOrigin", "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetOrigin", "[", "]"}], ":=", 
   RowBox[{"SetOrigin", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetScale", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"y_", "?", "NumericQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"$BUR", "=", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"Positive", "[", 
          RowBox[{"Min", "[", "$BUR", "]"}], "]"}]}], ",", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"SetScale", "::", "nonpositive"}], ",", "$BUR"}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"DefineCoordinates", "[", 
       RowBox[{
       "$AbsSize", ",", "$P1C", ",", "$P2C", ",", "$P3C", ",", "$P4C", ",", 
        "$P3R", ",", "$P4R", ",", "$AUR", ",", "$BUR"}], "]"}], ";", 
      "\[IndentingNewLine]", "Null"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetScale", "[", 
    RowBox[{"y_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"SetScale", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "y"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetScale", "[", "]"}], ":=", 
   RowBox[{"SetScale", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetRegion", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x3C_", "?", "NumericQ"}], ",", 
         RowBox[{"x4C_", "?", "NumericQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y3C_", "?", "NumericQ"}], ",", 
         RowBox[{"y4C_", "?", "NumericQ"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x3R_", "?", "NumericQ"}], ",", 
         RowBox[{"x4R_", "?", "NumericQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y3R_", "?", "NumericQ"}], ",", 
         RowBox[{"y4R_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "Differences", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"$RegionRange", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x3C", ",", "x4C"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y3C", ",", "y4C"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"$P3C", "=", 
       RowBox[{"{", 
        RowBox[{"x3C", ",", "y3C"}], "}"}]}], ";", 
      RowBox[{"$P4C", "=", 
       RowBox[{"{", 
        RowBox[{"x4C", ",", "y4C"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"$P3R", "=", 
       RowBox[{"{", 
        RowBox[{"x3R", ",", "y3R"}], "}"}]}], ";", 
      RowBox[{"$P4R", "=", 
       RowBox[{"{", 
        RowBox[{"x4R", ",", "y4R"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"$AUR", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"$BUR", "=", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Differences", "=", 
       RowBox[{"-", 
        RowBox[{"Subtract", "@@@", "$RegionRange"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"Positive", "[", 
          RowBox[{"Min", "[", "Differences", "]"}], "]"}]}], ",", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"SetRegion", "::", "nonpositive"}], ",", "$RegionRange"}], 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"DefineCoordinates", "[", 
       RowBox[{
       "$AbsSize", ",", "$P1C", ",", "$P2C", ",", "$P3C", ",", "$P4C", ",", 
        "$P3R", ",", "$P4R", ",", "$AUR", ",", "$BUR"}], "]"}], ";", 
      "\[IndentingNewLine]", "Null"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetRegion", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"$Background", "=", "None"}], ";", 
     RowBox[{"SetRegion", "[", 
      RowBox[{"$CanvasRange", ",", "$CanvasRange"}], "]"}]}], ")"}]}], 
  ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Utilities", "Section"],

Cell[CellGroupData[{

Cell["Listable logic operations", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ListableNot", ",", "Listable"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ListableNot", "[", "Args___", "]"}], ":=", 
   RowBox[{"Not", "[", "Args", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ListableAnd", ",", "Listable"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ListableAnd", "[", "Args___", "]"}], ":=", 
   RowBox[{"And", "[", "Args", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ListableOr", ",", "Listable"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ListableOr", "[", "Args___", "]"}], ":=", 
   RowBox[{"Or", "[", "Args", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ListableXor", ",", "Listable"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ListableXor", "[", "Args___", "]"}], ":=", 
   RowBox[{"Xor", "[", "Args", "]"}]}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trigonometry for 2D vectors", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VectorArcTan", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"y_", "?", "NumericQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "==", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", "0.", ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VectorLength", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"y_", "?", "NumericQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SegmentArcTan", "[", 
    RowBox[{"{", 
     RowBox[{"X1_List", ",", "X2_List"}], "}"}], "]"}], ":=", 
   RowBox[{"VectorArcTan", "[", 
    RowBox[{"X2", "-", "X1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SegmentLength", "[", 
    RowBox[{"{", 
     RowBox[{"X1_List", ",", "X2_List"}], "}"}], "]"}], ":=", 
   RowBox[{"VectorLength", "[", 
    RowBox[{"X2", "-", "X1"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trigonometric utility", "Subsection",
 CellChangeTimes->{{3.438373853920823*^9, 3.438373860248948*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Polar", "[", 
    RowBox[{"{", 
     RowBox[{"rho_", ",", "phi_"}], "}"}], "]"}], ":=", 
   RowBox[{"rho", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "phi", "]"}], ",", 
      RowBox[{"Sin", "[", "phi", "]"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Cylindrical", "[", 
    RowBox[{"{", 
     RowBox[{"rho_", ",", "phi_", ",", "z_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rho", "*", 
      RowBox[{"Cos", "[", "phi", "]"}]}], ",", 
     RowBox[{"rho", "*", 
      RowBox[{"Sin", "[", "phi", "]"}]}], ",", "z"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Spherical", "[", 
    RowBox[{"{", 
     RowBox[{"r_", ",", "theta_", ",", "phi_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "*", 
      RowBox[{"Sin", "[", "theta", "]"}], "*", 
      RowBox[{"Cos", "[", "phi", "]"}]}], ",", 
     RowBox[{"r", "*", 
      RowBox[{"Sin", "[", "theta", "]"}], "*", 
      RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
     RowBox[{"r", "*", 
      RowBox[{"Cos", "[", "theta", "]"}]}]}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.459692712578125*^9, 3.45969272240625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interpolation", "Subsection"],

Cell["from package MCArithmetic", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Interpolate", "[", 
    RowBox[{"x1_", ",", "x2_", ",", "y1_", ",", "y2_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"y1", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "x1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"x2", "-", "x1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"y2", "-", "y1"}], ")"}]}]}]}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Range checking and expansion", "Subsection"],

Cell["from package MCGraphics", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "x2_"}], "}"}], ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x1", "\[LessEqual]", "x"}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{"x", "\[LessEqual]", "x2"}], ")"}]}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InRegion", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "x2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y1_", ",", "y2_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"InRange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", "x"}], "]"}], "&&", 
    RowBox[{"InRange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y1", ",", "y2"}], "}"}], ",", "y"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InRegion", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"InRange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", "x"}], "]"}], "&&", 
    RowBox[{"InRange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y1", ",", "y2"}], "}"}], ",", "y"}], "]"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRange", "[", 
    RowBox[{
     RowBox[{"PRange", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1_", "?", "NumericQ"}], ",", 
        RowBox[{"x2_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"PFrac", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fx1_", "?", "NumericQ"}], ",", 
        RowBox[{"fx2_", "?", "NumericQ"}]}], "}"}]}]}], "]"}], ":=", 
   RowBox[{"PRange", "+", 
    RowBox[{"PFrac", "*", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"+", "1"}]}], "}"}], "*", 
     RowBox[{"-", 
      RowBox[{"Subtract", "@@", "PRange"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRange", "[", 
    RowBox[{
     RowBox[{"PRange", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1_", "?", "NumericQ"}], ",", 
        RowBox[{"x2_", "?", "NumericQ"}]}], "}"}]}], ",", "fx_"}], "]"}], ":=", 
   RowBox[{"ExtendRange", "[", 
    RowBox[{"PRange", ",", 
     RowBox[{"{", 
      RowBox[{"fx", ",", "fx"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRegion", "[", 
    RowBox[{
     RowBox[{"PRange", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1_", "?", "NumericQ"}], ",", 
          RowBox[{"x2_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"y1_", "?", "NumericQ"}], ",", 
          RowBox[{"y2_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PFrac", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"fx1_", "?", "NumericQ"}], ",", 
          RowBox[{"fx2_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"fy1_", "?", "NumericQ"}], ",", 
          RowBox[{"fy2_", "?", "NumericQ"}]}], "}"}]}], "}"}]}]}], "]"}], ":=", 
   RowBox[{"PRange", "+", 
    RowBox[{"PFrac", "*", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"+", "1"}]}], "}"}]}], "}"}], "*", 
     RowBox[{"-", 
      RowBox[{"Subtract", "@@@", "PRange"}]}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRegion", "[", 
    RowBox[{
     RowBox[{"PRange", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1_", "?", "NumericQ"}], ",", 
          RowBox[{"x2_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"y1_", "?", "NumericQ"}], ",", 
          RowBox[{"y2_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fx_", "?", "NumericQ"}], ",", 
       RowBox[{"fy_", "?", "NumericQ"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"ExtendRegion", "[", 
    RowBox[{"PRange", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"fx", ",", "fx"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"fy", ",", "fy"}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRegion", "[", 
    RowBox[{
     RowBox[{"PRange", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1_", "?", "NumericQ"}], ",", 
          RowBox[{"x2_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"y1_", "?", "NumericQ"}], ",", 
          RowBox[{"y2_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"f_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{"ExtendRegion", "[", 
    RowBox[{"PRange", ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "f"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.470920245828125*^9, 3.470920252046875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RegionCorners", "[", 
    RowBox[{"PRange", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1_", "?", "NumericQ"}], ",", 
         RowBox[{"x2_", "?", "NumericQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y1_", "?", "NumericQ"}], ",", 
         RowBox[{"y2_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "y1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "y2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", "y2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", "y1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.470920245828125*^9, 3.470920282046875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Region extension to given aspect ratio", "Subsection",
 CellChangeTimes->{{3.48828399440625*^9, 3.48828400728125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRegionAspectRatio", "[", 
    RowBox[{
     RowBox[{"PRange", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xRange", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x1_", "?", "NumericQ"}], ",", 
           RowBox[{"x2_", "?", "NumericQ"}]}], "}"}]}], ",", 
        RowBox[{"yRange", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"y1_", "?", "NumericQ"}], ",", 
           RowBox[{"y2_", "?", "NumericQ"}]}], "}"}]}]}], "}"}]}], ",", 
     RowBox[{"TargetAspectRatio_", "?", "Positive"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
     "{", "\[IndentingNewLine]", "IntrinsicAspectRatio", 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"aspect", " ", "ratio"}], " ", "=", " ", 
       RowBox[{"height", "/", "width"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "calculate", " ", "intrinsic", " ", "aspect", " ", "ratio", " ", "of", 
       " ", "region"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"IntrinsicAspectRatio", "=", 
       RowBox[{"1", "/", 
        RowBox[{"Divide", "@@", 
         RowBox[{"(", 
          RowBox[{"Subtract", "@@@", "PRange"}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"IntrinsicAspectRatio", "<", "TargetAspectRatio"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"too", " ", "short"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"stretch", " ", "height", " ", "so", " ", 
           RowBox[{"a", "'"}]}], "=", 
          RowBox[{"h", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", "\[Epsilon]"}]}], ")"}], "/", "w"}]}]}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"xRange", ",", 
          RowBox[{"ExtendRange", "[", 
           RowBox[{"yRange", ",", 
            RowBox[{
             RowBox[{"1", "/", "2"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"TargetAspectRatio", "/", "IntrinsicAspectRatio"}], 
               "-", "1"}], ")"}]}]}], "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"too", " ", "long"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"stretch", " ", "width", " ", "so", " ", 
           RowBox[{"a", "'"}]}], "=", 
          RowBox[{
           RowBox[{"h", "/", "w"}], 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", "\[Epsilon]"}]}], ")"}]}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ExtendRange", "[", 
           RowBox[{"xRange", ",", 
            RowBox[{
             RowBox[{"1", "/", "2"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IntrinsicAspectRatio", "/", "TargetAspectRatio"}], 
               "-", "1"}], ")"}]}]}], "]"}], ",", "yRange"}], "}"}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.488283345265625*^9, 3.488283412171875*^9}, {
  3.488283444453125*^9, 3.4882834798125*^9}, {3.488283528984375*^9, 
  3.488283575578125*^9}, {3.4882836065625*^9, 3.488283643578125*^9}, {
  3.4882836818125*^9, 3.488283768203125*^9}, {3.4882838064375*^9, 
  3.488283912546875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExtendRegionAspectRatio", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "166."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.", ",", "135."}], "}"}]}], "}"}], ",", "1"}], "]"}]], "Input",\

 CellChangeTimes->{{3.488283492765625*^9, 3.488283507890625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "166.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "15.5`"}], ",", "150.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.488283509890625*^9, 3.488283512078125*^9}, 
   3.48828354325*^9, 3.4882839195625*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Number testing", "Subsection"],

Cell["from package MCArithmetic", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RealNumericQ", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "===", 
        RowBox[{"-", "Infinity"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{"#", "===", 
        RowBox[{"+", "Infinity"}]}], ")"}], "||", 
      RowBox[{
       RowBox[{"Head", "[", 
        RowBox[{"N", "[", "#", "]"}], "]"}], "===", "Real"}]}], "&"}], 
    ")"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Message suppression", "Subsection"],

Cell["\<\
SuppressMessage is a scoping structure which temporarily suppresses a \
specified message while evaluating an expression, without affecting the \
global On/Off status of the message.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"SuppressMessage", ",", "HoldAll"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SuppressMessage", "[", 
    RowBox[{"MessageID_", ",", "Body_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"WasOn", ",", "Value"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"WasOn", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Head", "[", "MessageID", "]"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"String", "|", "MessageName"}], ",", "True", ",", 
         "\[IndentingNewLine]", "$Off", ",", "False"}], "\[IndentingNewLine]",
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Off", "[", "MessageID", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Value", "=", "Body"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"WasOn", ",", 
        RowBox[{"On", "[", "MessageID", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "Value"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["List augmentation", "Subsection"],

Cell["\<\
UpgradeScalarX, UpgradeScalarY, and UpgradeScalarXY upgrade a numeric \
argument (or None) to a 2D list, or passes a 2D list through unchanged\
\>", "Text",
 CellChangeTimes->{{3.4914122990625*^9, 3.49141230090625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeScalarX", "[", "P_", "]"}], ":=", 
   RowBox[{"Switch", "[", 
    RowBox[{"P", ",", "\[IndentingNewLine]", "None", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"_", "?", "NumericQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"P", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], ",", 
       RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", "P"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeScalarY", "[", "P_", "]"}], ":=", 
   RowBox[{"Switch", "[", 
    RowBox[{"P", ",", "\[IndentingNewLine]", "None", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"_", "?", "NumericQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "P"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], ",", 
       RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", "P"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeScalarXY", "[", "P_", "]"}], ":=", 
   RowBox[{"Switch", "[", 
    RowBox[{"P", ",", "\[IndentingNewLine]", "None", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"_", "?", "NumericQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"P", ",", "P"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], ",", 
       RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", "P"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49141230934375*^9, 3.491412320203125*^9}}],

Cell["\<\
Frame option upgrades -- generic
\tincluding interconversion paired \[LeftRightArrow] list
\tonly works if basic single-edge option values cannot themselves be lists \
(compare AugmentAxisTickOptions)\
\>", "Text",
 CellChangeTimes->{{3.428181708328125*^9, 3.428181714515625*^9}, {
  3.459546646359375*^9, 3.45954666640625*^9}, {3.461090186078125*^9, 
  3.461090206421875*^9}, {3.461090554328125*^9, 3.461090557796875*^9}, {
  3.46694655503125*^9, 3.466946556640625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NonListQ", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Head", "[", "#", "]"}], "=!=", "List"}], "&"}], ")"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.428182108078125*^9, 3.42818213259375*^9}, {
  3.466946473984375*^9, 3.46694650646875*^9}, {3.46694656646875*^9, 
  3.466946566796875*^9}}],

Cell["...with second axis as duplicate of first", "Text",
 CellChangeTimes->{{3.466948131453125*^9, 3.466948140796875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{"xy_", "?", "NonListQ"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{"{", 
     RowBox[{"xy", ",", "xy"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "NonListQ"}], ",", 
      RowBox[{"y_", "?", "NonListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "y"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1_", "?", "NonListQ"}], ",", 
        RowBox[{"x2_", "?", "NonListQ"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y1_", "?", "NonListQ"}], ",", 
        RowBox[{"y2_", "?", "NonListQ"}]}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x1_", "?", "NonListQ"}], ",", 
      RowBox[{"y1_", "?", "NonListQ"}], ",", 
      RowBox[{"x2_", "?", "NonListQ"}], ",", 
      RowBox[{"y2_", "?", "NonListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{"xy_", "?", "NonListQ"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{"{", 
     RowBox[{"xy", ",", "xy"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "NonListQ"}], ",", 
      RowBox[{"y_", "?", "NonListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "y"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1_", "?", "NonListQ"}], ",", 
        RowBox[{"x2_", "?", "NonListQ"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y1_", "?", "NonListQ"}], ",", 
        RowBox[{"y2_", "?", "NonListQ"}]}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "y1", ",", "x2", ",", "y2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x1_", "?", "NonListQ"}], ",", 
      RowBox[{"y1_", "?", "NonListQ"}], ",", 
      RowBox[{"x2_", "?", "NonListQ"}], ",", 
      RowBox[{"y2_", "?", "NonListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "y1", ",", "x2", ",", "y2"}], "}"}]}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.428181740703125*^9, 3.4281817943125*^9}, {
   3.428181880328125*^9, 3.428181908125*^9}, {3.428182150109375*^9, 
   3.428182171484375*^9}, {3.42818246159375*^9, 3.42818248540625*^9}, 
   3.466946390578125*^9}],

Cell["...with second axis defaulting to Filler", "Text",
 CellChangeTimes->{{3.466948131453125*^9, 3.466948150484375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{
     RowBox[{"xy_", "?", "NonListQ"}], ",", "Filler_"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xy", ",", "xy"}], "}"}], ",", "Filler"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x_", "?", "NonListQ"}], ",", 
       RowBox[{"y_", "?", "NonListQ"}]}], "}"}], ",", "Filler_"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "Filler"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "Filler"}], "}"}]}], "}"}], ",", "Filler"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1_", "?", "NonListQ"}], ",", 
         RowBox[{"x2_", "?", "NonListQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y1_", "?", "NonListQ"}], ",", 
         RowBox[{"y2_", "?", "NonListQ"}]}], "}"}]}], "}"}], ",", "Filler_"}],
     "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsPaired", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1_", "?", "NonListQ"}], ",", 
       RowBox[{"y1_", "?", "NonListQ"}], ",", 
       RowBox[{"x2_", "?", "NonListQ"}], ",", 
       RowBox[{"y2_", "?", "NonListQ"}]}], "}"}], ",", "Filler_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{
     RowBox[{"xy_", "?", "NonListQ"}], ",", "Filler_"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xy", ",", "xy"}], "}"}], ",", "Filler"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x_", "?", "NonListQ"}], ",", 
       RowBox[{"y_", "?", "NonListQ"}]}], "}"}], ",", "Filler_"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "Filler"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "Filler"}], "}"}]}], "}"}], ",", "Filler"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1_", "?", "NonListQ"}], ",", 
         RowBox[{"x2_", "?", "NonListQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y1_", "?", "NonListQ"}], ",", 
         RowBox[{"y2_", "?", "NonListQ"}]}], "}"}]}], "}"}], ",", "Filler_"}],
     "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "y1", ",", "x2", ",", "y2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsList", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1_", "?", "NonListQ"}], ",", 
       RowBox[{"y1_", "?", "NonListQ"}], ",", 
       RowBox[{"x2_", "?", "NonListQ"}], ",", 
       RowBox[{"y2_", "?", "NonListQ"}]}], "}"}], ",", "Filler_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "y1", ",", "x2", ",", "y2"}], "}"}]}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.428181740703125*^9, 3.4281817943125*^9}, {
   3.428181880328125*^9, 3.428181908125*^9}, {3.428182150109375*^9, 
   3.428182171484375*^9}, {3.42818246159375*^9, 3.42818248540625*^9}, 
   3.466946390578125*^9, {3.466948053140625*^9, 3.466948123390625*^9}}],

Cell["\<\
Frame option upgrades -- flat lists
\tincluding interconversion paired \[LeftRightArrow] list
\tonly works if basic single-edge option values can *only* be flat lists \
(e.g., lists of options for each axis)\
\>", "Text",
 CellChangeTimes->{{3.428181708328125*^9, 3.428181714515625*^9}, {
  3.459546646359375*^9, 3.45954666640625*^9}, {3.461090186078125*^9, 
  3.461090206421875*^9}, {3.461090554328125*^9, 3.461090557796875*^9}, {
  3.46694655503125*^9, 3.466946564171875*^9}, {3.466946616796875*^9, 
  3.4669466523125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FlatListQ", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MatchQ", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{"___", "?", "NonListQ"}], "}"}]}], "]"}], "&"}], ")"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsFlatPaired", "[", 
    RowBox[{"xy_", "?", "FlatListQ"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsFlatPaired", "[", 
    RowBox[{"{", 
     RowBox[{"xy", ",", "xy"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsFlatPaired", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "FlatListQ"}], ",", 
      RowBox[{"y_", "?", "FlatListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsFlatPaired", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "y"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsFlatPaired", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1_", "?", "FlatListQ"}], ",", 
        RowBox[{"x2_", "?", "FlatListQ"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y1_", "?", "FlatListQ"}], ",", 
        RowBox[{"y2_", "?", "FlatListQ"}]}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsFlatPaired", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x1_", "?", "FlatListQ"}], ",", 
      RowBox[{"y1_", "?", "FlatListQ"}], ",", 
      RowBox[{"x2_", "?", "FlatListQ"}], ",", 
      RowBox[{"y2_", "?", "FlatListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsFlatList", "[", 
    RowBox[{"xy_", "?", "FlatListQ"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsFlatList", "[", 
    RowBox[{"{", 
     RowBox[{"xy", ",", "xy"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsFlatList", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "FlatListQ"}], ",", 
      RowBox[{"y_", "?", "FlatListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"UpgradeFrameOptionsFlatList", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "y"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsFlatList", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1_", "?", "FlatListQ"}], ",", 
        RowBox[{"x2_", "?", "FlatListQ"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y1_", "?", "FlatListQ"}], ",", 
        RowBox[{"y2_", "?", "FlatListQ"}]}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "y1", ",", "x2", ",", "y2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeFrameOptionsFlatList", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x1_", "?", "FlatListQ"}], ",", 
      RowBox[{"y1_", "?", "FlatListQ"}], ",", 
      RowBox[{"x2_", "?", "FlatListQ"}], ",", 
      RowBox[{"y2_", "?", "FlatListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "y1", ",", "x2", ",", "y2"}], "}"}]}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.428181740703125*^9, 3.4281817943125*^9}, {
   3.428181880328125*^9, 3.428181908125*^9}, {3.428182150109375*^9, 
   3.428182171484375*^9}, {3.42818246159375*^9, 3.42818248540625*^9}, 
   3.466946390578125*^9, {3.4669464221875*^9, 3.46694642928125*^9}, {
   3.466946524140625*^9, 3.466946535*^9}}],

Cell["Frame mask option validation", "Text",
 CellChangeTimes->{{3.466946583953125*^9, 3.466946587875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FrameMaskListQ", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"True", "|", "False"}], ")"}], "|", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", "|", "False"}], ",", 
       RowBox[{"True", "|", "False"}]}], "}"}], "|", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"True", "|", "False"}], ",", 
       RowBox[{"True", "|", "False"}], ",", 
       RowBox[{"True", "|", "False"}], ",", 
       RowBox[{"True", "|", "False"}]}], "}"}]}], "]"}], ":=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FrameMaskListQ", "[", "_", "]"}], ":=", "False"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.459546749921875*^9, 3.459546769015625*^9}, {
  3.45954686046875*^9, 3.459546956359375*^9}}],

Cell["\<\
Axis option upgrades
\tonly works if basic single-axis option values cannot themselves be lists \
(compare AugmentAxisTickOptions)\
\>", "Text",
 CellChangeTimes->{{3.428181708328125*^9, 3.428181714515625*^9}, {
  3.459546646359375*^9, 3.45954666640625*^9}, {3.461090051453125*^9, 
  3.46109005715625*^9}, {3.461090217890625*^9, 3.461090222171875*^9}, {
  3.4610905315625*^9, 3.461090564125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeAxisOptions", "[", 
    RowBox[{"xy_", "?", "NonListQ"}], "]"}], ":=", 
   RowBox[{"UpgradeAxisOptions", "[", 
    RowBox[{"{", 
     RowBox[{"xy", ",", "xy"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeAxisOptions", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "NonListQ"}], ",", 
      RowBox[{"y_", "?", "NonListQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.46109007403125*^9, 3.46109014009375*^9}}],

Cell["\<\
 Margin upgrade
\tCan Margin be supplanted by UpgradeFrameOptionsPaired?\
\>", "Text",
 CellChangeTimes->{{3.4281818028125*^9, 3.42818183225*^9}, 
   3.428182472375*^9, {3.461090595625*^9, 3.461090598703125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MarginQ", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], ",", 
       RowBox[{"_", "?", "NumericQ"}]}], "}"}], "|", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], "]"}], ":=", 
   "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MarginQ", "[", "_", "]"}], ":=", "False"}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeMargin", "[", 
    RowBox[{"xy_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"UpgradeMargin", "[", 
    RowBox[{"{", 
     RowBox[{"xy", ",", "xy"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeMargin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], ",", 
      RowBox[{"y_", "?", "NumericQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"UpgradeMargin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "y"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UpgradeMargin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1_", "?", "NumericQ"}], ",", 
        RowBox[{"x2_", "?", "NumericQ"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y1_", "?", "NumericQ"}], ",", 
        RowBox[{"y2_", "?", "NumericQ"}]}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Margin arithmetic
\tadjusts a box in canvas coordinates by a margin given in absolute \
coordinates\
\>", "Text",
 CellChangeTimes->{{3.464879536484375*^9, 3.46487956415625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ImposeAbsoluteMargin", "[", 
    RowBox[{
     RowBox[{"OuterBox", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"m_", "?", "MarginQ"}]}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"OuterBox", "+", 
     RowBox[{"ConvertRegion", "[", 
      RowBox[{"AbsoluteCoords", ",", "CanvasCoords", ",", "D", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"+", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"+", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}], "*", 
        RowBox[{"UpgradeMargin", "[", "m", "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4648795783125*^9, 3.464879606015625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Entry interspersing", "Subsection"],

Cell["from MCList", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "Intersperse", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"First", "\[Rule]", "False"}], ",", 
     RowBox[{"Last", "\[Rule]", "False"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Intersperse", "[", 
    RowBox[{"L_List", ",", "Separator_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{"Opts", ",", 
          RowBox[{"Options", "[", "Intersperse", "]"}]}], "}"}], "]"}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Insert", "[", "\[IndentingNewLine]", 
      RowBox[{
      "L", ",", "\[IndentingNewLine]", "Separator", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", "i", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"First", "/.", "FullOpts"}], ",", "1", ",", "2"}], "]"}],
            ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"Last", "/.", "FullOpts"}], ",", 
             RowBox[{
              RowBox[{"Length", "[", "L", "]"}], "+", "1"}], ",", 
             RowBox[{"Length", "[", "L", "]"}]}], "]"}]}], "}"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Intersperse", "[", 
    RowBox[{"Item_", ",", "Separator_", ",", 
     RowBox[{"Num_Integer", "?", "NonNegative"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Intersperse", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"Item", ",", 
       RowBox[{"{", "Num", "}"}]}], "]"}], ",", "Separator", ",", "Opts"}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Radius testing and conversion", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SingleRadiusQ", "[", "P_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"P", ",", 
     RowBox[{
      RowBox[{"_", "?", "NumericQ"}], "|", 
      RowBox[{"Horizontal", "[", 
       RowBox[{"_", "?", "NumericQ"}], "]"}], "|", 
      RowBox[{"Vertical", "[", 
       RowBox[{"_", "?", "NumericQ"}], "]"}], "|", 
      RowBox[{"Point", "[", 
       RowBox[{"_", "?", "NumericQ"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DoubleRadiusQ", "[", "P_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"P", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}], "|", 
      RowBox[{"Horizontal", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}], "]"}], "|", 
      RowBox[{"Vertical", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}], "]"}], "|", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RadiusQ", "[", "P_", "]"}], ":=", 
   RowBox[{
    RowBox[{"SingleRadiusQ", "[", "P", "]"}], "||", 
    RowBox[{"DoubleRadiusQ", "[", "P", "]"}]}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConvertRadiusToCanvas", "[", 
    RowBox[{"R_", "?", "RadiusQ"}], "]"}], ":=", 
   RowBox[{"Switch", "[", "\[IndentingNewLine]", 
    RowBox[{"R", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"_", "?", "NumericQ"}], "|", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"DPCOfPU", "@", 
      RowBox[{"UpgradeScalarXY", "[", "R", "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Horizontal", "[", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], "|", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DPCOfPA", "@", 
      RowBox[{"(", 
       RowBox[{"DXAOfXU", "/@", 
        RowBox[{"UpgradeScalarXY", "[", 
         RowBox[{"First", "[", "R", "]"}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Vertical", "[", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], "|", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DPCOfPA", "@", 
      RowBox[{"(", 
       RowBox[{"DYAOfYU", "/@", 
        RowBox[{"UpgradeScalarXY", "[", 
         RowBox[{"First", "[", "R", "]"}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Point", "[", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], "|", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DPCOfPA", "@", 
      RowBox[{"UpgradeScalarXY", "[", 
       RowBox[{"First", "[", "R", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input validation and error message generation", "Subsection"],

Cell["\<\
ErrorMessage
\tError flagging and trapping mechanism in Scheme:
\tAn Abort would prevent Scheme from restoring the saved global option \
values, so must use a Throw out to Scheme.
\tAbort is provided for use by standalone utilities which can be used outside \
of scheme.  Necessary so utilities can safely make use of CheckOption, etc.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ErrorMessage", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ErrorMessage", "[", "Args___", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Message", "[", "Args", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{"$InScheme", ",", "\[IndentingNewLine]", 
        RowBox[{"Throw", "[", "$ErrorFlag", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Abort", "[", "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.49722451228125*^9}],

Cell["CatchError", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"CatchError", ",", "HoldAll"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CatchError", "[", "Body_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Catch", "[", "Body", "]"}], "===", "$ErrorFlag"}], ")"}]}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
CheckInScheme
\tDisplay warning if object is evaluated outside a scheme.
\tEach user-callable scheme object should check this first thing before any \
calculations or other parameter checks, since these may yield garbage or \
create and uncaught throw if evaluated outside a scheme.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckInScheme", "[", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"$InScheme", "=!=", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{"LevelScheme", "::", "notinscheme"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Abort", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.497224520390625*^9}],

Cell["\<\
CheckInScheme test is so that an object used with wrong syntax but outside of \
scheme will produce a notinscheme error instead of an lsargs error.
Previously, inclusion of this test in ErrorMessage necessitated that the \
global $InScheme flag be set for most of the body of Scheme, since otherwise \
ErrorMessage calls generated by Scheme itself will produce notinscheme errors.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"FallThroughError", ",", "HoldAll"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FallThroughError", "[", 
    RowBox[{"Object_Symbol", ",", "Expr_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Count", "[", 
          RowBox[{
           RowBox[{"Hold", "[", "Expr", "]"}], ",", "Null", ",", 
           RowBox[{"{", "2", "}"}]}], "]"}], ">", "0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"Object", "::", "lsargsnull"}], ",", 
          RowBox[{"HoldForm", "[", "Expr", "]"}]}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ErrorMessage", "[", 
       RowBox[{
        RowBox[{"Object", "::", "lsargs"}], ",", 
        RowBox[{"HoldForm", "[", "Expr", "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell["CheckOption, CheckValue", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CheckOption", "[", 
    RowBox[{"Param_", ",", "TestPattern_", ",", "FullOpts_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MatchQ", "[", 
         RowBox[{
          RowBox[{"Param", "/.", "FullOpts"}], ",", "TestPattern"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"ErrorMessage", "[", 
        RowBox[{
         RowBox[{"LevelScheme", "::", "badparam"}], ",", "Param", ",", 
         RowBox[{"Param", "/.", "FullOpts"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CheckValue", "[", 
    RowBox[{"Value_", ",", "TestPattern_", ",", "Description_String"}], "]"}],
    ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"Value", ",", "TestPattern"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ErrorMessage", "[", 
        RowBox[{
         RowBox[{"LevelScheme", "::", "badvalue"}], ",", "Description", ",", 
         "Value"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell["Checks for defined identifiers", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckLevel", "[", "ID_", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"NumericQ", "[", 
         RowBox[{"LevelScheme`Data`UserEnergy", "[", "ID", "]"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"ErrorMessage", "[", 
        RowBox[{
         RowBox[{"LevelScheme", "::", "badlevel"}], ",", "ID"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckPoint", "[", "ID_", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"VectorQ", "[", 
         RowBox[{"LevelScheme`Data`P", "[", "ID", "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ErrorMessage", "[", 
        RowBox[{
         RowBox[{"LevelScheme", "::", "badpoint"}], ",", "ID"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckDataSet", "[", "ID_", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"TrueQ", "[", 
         RowBox[{"LevelScheme`Data`DataTagDefined", "[", "ID", "]"}], "]"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"ErrorMessage", "[", 
        RowBox[{
         RowBox[{"LevelScheme", "::", "baddataset"}], ",", "ID"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
LevelIdentifierQ -- test for expression permitted as level identifier\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LevelIdentifierQ", "[", "Expr_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Head", "[", "Expr", "]"}], "=!=", "List"}], ")"}], "&&", 
     RowBox[{"!", 
      RowBox[{"NumericQ", "[", "Expr", "]"}]}]}], ")"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option management", "Subsection",
 CellChangeTimes->{{3.496055551640625*^9, 3.496055554328125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FigRealizeOptions", "[", 
    RowBox[{"Object_Symbol", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "RealizedOptions", ",", "TagValue", ",", "Patt", ",", "ActiveOptions"}],
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"do", " ", "inheritance", " ", "first"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RealizedOptions", "=", 
       RowBox[{"RealizeOptions", "[", 
        RowBox[{"Object", ",", "Opts"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "select", " ", "conditional", " ", "options", " ", "whose", " ", 
        "pattern", " ", "matches", " ", "Tag"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"TagValue", "=", 
       RowBox[{"(", 
        RowBox[{"Tag", "/.", "RealizedOptions"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ActiveOptions", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ConditionalOptions", "/.", "RealizedOptions"}], ")"}], ",",
          "\[IndentingNewLine]", "ConditionalOptions", ",", 
         RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "_", ",", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"ConditionalOptions", "/.", "RealizedOptions"}], ")"}], 
           ",", 
           RowBox[{"(", 
            RowBox[{"Patt_", "/;", 
             RowBox[{"MatchQ", "[", 
              RowBox[{"TagValue", ",", "Patt"}], "]"}]}], ")"}]}], "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "prepend", " ", "these", " ", "options", " ", "to", " ", "full", " ", 
        "option", " ", "list"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Last", "/@", "ActiveOptions"}], ",", "RealizedOptions"}], 
        "}"}], "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49605483734375*^9, 3.49605521271875*^9}, {
  3.496055426109375*^9, 3.49605543165625*^9}, {3.496055470546875*^9, 
  3.496055511171875*^9}, {3.49605581478125*^9, 3.496055816921875*^9}, {
  3.4960561991875*^9, 3.496056251359375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Object data management", "Subsection",
 CellChangeTimes->{{3.49666752028125*^9, 3.49666752659375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FigObjectExistsQ", "[", "Tag_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{
     RowBox[{"LevelScheme`Data`ObjectData", "[", "Tag", "]"}], ",", "_List"}],
     "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.496667679328125*^9, 3.496667732625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FigDefineObject", "[", 
    RowBox[{
     RowBox[{"Data", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", "_Rule", ")"}], "..."}], "}"}]}], ",", "FullOpts_List"}],
     "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "ensure", " ", "sure", " ", "data", " ", "list", " ", "exists"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"FigObjectExistsQ", "[", "Tag", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`ObjectData", "[", "Tag", "]"}], "=", 
          RowBox[{"{", "}"}]}]}], "\[IndentingNewLine]", "]"}], ";"}], "*)"}],
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"LevelScheme`Data`ObjectData", "[", 
        RowBox[{"(", 
         RowBox[{"Tag", "/.", "FullOpts"}], ")"}], "]"}], "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"prepend", " ", "new", " ", "data"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`ObjectData", "[", 
        RowBox[{"(", 
         RowBox[{"Tag", "/.", "FullOpts"}], ")"}], "]"}], "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{"Data", ",", 
          RowBox[{"LevelScheme`Data`ObjectData", "[", 
           RowBox[{"(", 
            RowBox[{"Tag", "/.", "FullOpts"}], ")"}], "]"}]}], "}"}], 
        "]"}]}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49666759025*^9, 3.4966676686875*^9}, {
  3.496667744296875*^9, 3.496667896296875*^9}, {3.496667981765625*^9, 
  3.4966679933125*^9}, {3.4966681666875*^9, 3.496668244515625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FigObjectData", "[", 
    RowBox[{"Tag_", ",", "Field_Symbol"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Field", "/.", 
      RowBox[{"LevelScheme`Data`ObjectData", "[", "Tag", "]"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49666790928125*^9, 3.496667955390625*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics construction functions", "Section"],

Cell[CellGroupData[{

Cell["Directive patterns for option validation", "Subsection",
 CellChangeTimes->{{3.3955204599375*^9, 3.395520466828125*^9}}],

Cell[TextData[{
 "Note that Opacity is not allowed here as a color directive, since it is \
preferred that the Opacity, LineOpacity, ",
 StyleBox["etc.",
  FontSlant->"Italic"],
 " options be used instead."
}], "Text",
 CellChangeTimes->{{3.3966349168125*^9, 3.3966349643125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ColorDirectivePattern", "=", 
    RowBox[{"(", 
     RowBox[{"_GrayLevel", "|", "_RGBColor", "|", "_Hue", "|", "_CMYKColor"}],
      ")"}]}], ";"}], " "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395520471*^9, 3.395520493953125*^9}, {
  3.395520539328125*^9, 3.395520569640625*^9}, {3.39663491028125*^9, 
  3.396634914140625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outlines", "Subsection"],

Cell[TextData[{
 "MakeOutline takes a list Art of line art objects, and returns a graphics \
object containing of this list with appropriate graphics directives prepended \
according to the option list FullOpts, \nexcept returning null if the \
ShowLine option is set to False.\n\tArguments:\n\t\tArt -- list of graphics \
primatives\n\tRequired options:\n\t\tShowLine\n\t\tColor, Opacity,\n\t\t\
LineColor, LineOpacity, Thickness (interpreted as an absolute thickness, \
contrary to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " convention), CapForm -- line properties\n\t\tDashing, DashingGap, \
DashingCorrection  -- implements smart dashing which allows for pen diameter \
(outdated with CapForm->None)\n\t\tClipToRectangle, Layer (Automatic yields \
drawn object default)"
}], "Text",
 CellChangeTimes->{{3.3955200445*^9, 3.3955200449375*^9}, {3.3966349833125*^9,
   3.396634984546875*^9}, {3.39663509253125*^9, 3.3966351233125*^9}, {
  3.486810275046875*^9, 3.486810297171875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CorrectedDash", "[", "Thickness_", "]"}], "[", 
    RowBox[{"Length_", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", "Index_Integer", ")"}], "?", "OddQ"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"Length", "-", "Thickness"}], ",", "0."}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CorrectedDash", "[", "Thickness_", "]"}], "[", 
    RowBox[{"Length_", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", "Index_Integer", ")"}], "?", "EvenQ"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"Length", "+", "Thickness"}], ",", "0."}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeOutlineDirectives", "[", "FullOpts_List", "]"}], " ", ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "DashLengths", ",", "DefaultGapLength", ",", "DefaultGapFactor"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckOption", "[", 
        RowBox[{"Color", ",", "ColorDirectivePattern", ",", "FullOpts"}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"Opacity", ",", 
         RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"LineColor", ",", 
         RowBox[{"Automatic", "|", "ColorDirectivePattern"}], ",", 
         "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"LineOpacity", ",", 
         RowBox[{"Automatic", "|", 
          RowBox[{"_", "?", "NumericQ"}]}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"Thickness", ",", 
         RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"CapForm", ",", 
         RowBox[{"None", "|", 
          RowBox[{"(", "_String", ")"}]}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"Dashing", ",", 
         RowBox[{"None", "|", "Automatic", "|", "True", "|", 
          RowBox[{"(", 
           RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"_", "?", "NumericQ"}], ")"}], "..."}], "}"}], "|", 
          RowBox[{"AbsoluteDashing", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"_", "?", "NumericQ"}], ")"}], "..."}], "}"}], "]"}]}], 
         ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"DashingGap", ",", 
         RowBox[{"Automatic", "|", 
          RowBox[{"(", 
           RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"DashingCorrection", ",", 
         RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"DefaultGapFactor", "=", 
        RowBox[{"1", "/", "2"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "default", " ", "ratio", " ", "of", " ", "gap", " ", "to", " ", 
         "average", " ", "dash", " ", "length"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"DefaultGapLength", "=", 
        RowBox[{"GetAutoOption", "[", "\[IndentingNewLine]", 
         RowBox[{"DashingGap", ",", "\[IndentingNewLine]", 
          RowBox[{"Switch", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Dashing", "/.", "FullOpts"}], ")"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"None", "|", "0", "|", "_AbsoluteDashing"}], ",", "None", 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Automatic", "|", "True"}], ",", 
            RowBox[{"DefaultGapFactor", "*", "4"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"_", "?", "NumericQ"}], ",", 
            RowBox[{"DefaultGapFactor", "*", 
             RowBox[{"(", 
              RowBox[{"Dashing", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"_", "?", "NumericQ"}], ")"}], "..."}], "}"}], ",", 
            RowBox[{"DefaultGapFactor", "*", 
             RowBox[{
              RowBox[{"Plus", "@@", 
               RowBox[{"(", 
                RowBox[{"Dashing", "/.", "FullOpts"}], ")"}]}], "/", 
              RowBox[{"Length", "[", 
               RowBox[{"(", 
                RowBox[{"Dashing", "/.", "FullOpts"}], ")"}], "]"}]}]}], ",", 
            "\[IndentingNewLine]", "_AbsoluteDashing", ",", "None"}], 
           "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
          "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"DashLengths", "=", 
        RowBox[{"Switch", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Dashing", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
          RowBox[{"None", "|", "0"}], ",", 
          RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Automatic", "|", "True"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "DefaultGapLength"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Dashing", "/.", "FullOpts"}], ")"}], ",", 
            "DefaultGapLength"}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"_", "?", "NumericQ"}], ")"}], "..."}], "}"}], ",", 
          RowBox[{"Intersperse", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Dashing", "/.", "FullOpts"}], ")"}], ",", 
            "DefaultGapLength", ",", 
            RowBox[{"Last", "\[Rule]", "True"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "_AbsoluteDashing", ",", 
          RowBox[{"First", "[", 
           RowBox[{"Dashing", "/.", "FullOpts"}], "]"}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"DashLengths", "=", 
        RowBox[{"MapIndexed", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"CorrectedDash", "[", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"DashingCorrection", "/.", "FullOpts"}], ")"}], ",", 
             RowBox[{"(", 
              RowBox[{"Thickness", "/.", "FullOpts"}], ")"}], ",", "0"}], 
            "]"}], "]"}], ",", "\[IndentingNewLine]", "DashLengths"}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"GetAutoOption", "[", 
          RowBox[{"LineColor", ",", 
           RowBox[{"Color", "/.", "FullOpts"}], ",", "FullOpts"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Opacity", "[", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"LineOpacity", ",", 
            RowBox[{"Opacity", "/.", "FullOpts"}], ",", "FullOpts"}], "]"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"CapForm", "[", 
          RowBox[{"CapForm", "/.", "FullOpts"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"AbsoluteThickness", "[", 
          RowBox[{"Thickness", "/.", "FullOpts"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"AbsoluteDashing", "[", "DashLengths", "]"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeOutline", "[", 
    RowBox[{"Art_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", "Opts", "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
       "CroppedArt"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowLine", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Layer", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"_", "?", "NumericQ"}]}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ClipToRectangle", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Show", "/.", "FullOpts"}], ")"}], "&&", 
         RowBox[{"(", 
          RowBox[{"ShowLine", "/.", "FullOpts"}], ")"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"CroppedArt", "=", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"ClipToRectangle", "/.", "FullOpts"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"First", "@", 
             RowBox[{"ClipToRectangle", "[", 
              RowBox[{"$RegionRange", ",", 
               RowBox[{"Graphics", "[", "Art", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", "Art"}], "\[IndentingNewLine]", "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"SchemeGraphics", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"MakeOutlineDirectives", "[", "FullOpts", "]"}], ",", 
           "\[IndentingNewLine]", "CroppedArt", ",", "\[IndentingNewLine]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"Layer", ",", "$SchemeDrawingLayer", ",", "FullOpts"}], 
            "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39552005190625*^9, 3.395520062359375*^9}, 
   3.3955205121875*^9, 3.395520576703125*^9, {3.39663499453125*^9, 
   3.396635037265625*^9}, {3.4666377645*^9, 3.46663778046875*^9}, {
   3.48681031478125*^9, 3.486810373640625*^9}}],

Cell["\<\
MakeOutline3D -- 3D analogue of MakeOutline
\tignores option Layer\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeOutline3D", "[", 
    RowBox[{"Art_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", "Opts", "}"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowLine", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Show", "/.", "FullOpts"}], ")"}], "&&", 
         RowBox[{"(", 
          RowBox[{"ShowLine", "/.", "FullOpts"}], ")"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"GeometricTransformation", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Flatten", "[", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"MakeOutlineDirectives", "[", "FullOpts", "]"}], ",", 
               "\[IndentingNewLine]", "Art"}], "\[IndentingNewLine]", "}"}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{"GeometricTransformation", "/.", "FullOpts"}], ")"}]}], 
           "\[IndentingNewLine]", "]"}], "}"}], "\[IndentingNewLine]", 
         "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.459698750828125*^9, 3.459698772953125*^9}, {
  3.459699510359375*^9, 3.4596995206875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fills", "Subsection"],

Cell["\<\
MakeFill returns graphics with prepended directives (or Null)
\tArguments:
\t\tArt -- list of graphics primatives
\tRequired options:
\t\tShowFill
\t\tColor, Opacity,
\t\tFillColor, FillOpacity,
\t\tClipToRectangle, Layer (Automatic yields drawn object default)\
\>", "Text",
 CellChangeTimes->{{3.396635127875*^9, 3.3966351371875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeFillDirectives", "[", "FullOpts_List", "]"}], " ", ":=", " ",
     "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"CheckOption", "[", 
        RowBox[{"Color", ",", "ColorDirectivePattern", ",", "FullOpts"}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"Opacity", ",", 
         RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"FillColor", ",", 
         RowBox[{"Automatic", "|", "ColorDirectivePattern"}], ",", 
         "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"FillOpacity", ",", 
         RowBox[{"Automatic", "|", 
          RowBox[{"_", "?", "NumericQ"}]}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"FillColor", ",", 
         RowBox[{"Color", "/.", "FullOpts"}], ",", "FullOpts"}], "]"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Opacity", "[", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"FillOpacity", ",", 
         RowBox[{"Opacity", "/.", "FullOpts"}], ",", "FullOpts"}], "]"}], 
       "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeFill", "[", 
    RowBox[{"Art_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", "  ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", "Opts", "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
       "CroppedArt"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowFill", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Layer", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"_", "?", "NumericQ"}]}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ClipToRectangle", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Show", "/.", "FullOpts"}], ")"}], "&&", 
         RowBox[{"(", 
          RowBox[{"ShowFill", "/.", "FullOpts"}], ")"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"CroppedArt", "=", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"ClipToRectangle", "/.", "FullOpts"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"First", "@", 
             RowBox[{"ClipToRectangle", "[", 
              RowBox[{"$RegionRange", ",", 
               RowBox[{"Graphics", "[", "Art", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", "Art"}], "\[IndentingNewLine]", "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"SchemeGraphics", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"MakeFillDirectives", "[", "FullOpts", "]"}], ",", 
           "\[IndentingNewLine]", "CroppedArt", ",", "\[IndentingNewLine]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"Layer", ",", "$SchemeDrawingLayer", ",", "FullOpts"}], 
            "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39552059484375*^9, 3.39552059778125*^9}, {
   3.39663514575*^9, 3.396635187421875*^9}, 3.39663555353125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Text", "Subsection"],

Cell["\<\
MakeText returns a text label (or Null)
\tArguments:
\t\tArt -- expression to display
\t\t\tPuts text in DisplayForm.
\t\t\tReturns Null if text is Null.
\t\tPosn -- position in regular coordinates
\t\tDefaultAngle -- angle (CCW from normal horizontal) to use as default \
orientation and basis for calculations based on Orientation option
\tRequired options:
\t\tShowText
\t\tOffset,
\t\tNudge,\t
\t\tOrientation,
\t\tBackground,
\t\tFontFamily, FontSize,  FontSlant, FontWeight, FontColor, FontOpacity, \
defaulting to Color and Opacity if values are Automatic
\t\tClipToRectangle, Layer (Automatic yields text defaults)\t\
\>", "Text",
 CellChangeTimes->{{3.396634502640625*^9, 3.39663453021875*^9}, 
   3.502555111765625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeTextStyle", "[", "FullOpts_List", "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckOption", "[", 
        RowBox[{"Color", ",", "ColorDirectivePattern", ",", "FullOpts"}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"Opacity", ",", 
         RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"FontColor", ",", 
         RowBox[{"Automatic", "|", "ColorDirectivePattern"}], ",", 
         "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"FontOpacity", ",", 
         RowBox[{"Automatic", "|", 
          RowBox[{"(", 
           RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"FontSize", ",", 
         RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FontFamily", " ", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"FontFamily", "/.", "FullOpts"}], ")"}]}], ",", 
         RowBox[{"FontSize", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}], ",", 
         RowBox[{"FontSlant", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"FontSlant", "/.", "FullOpts"}], ")"}]}], ",", 
         RowBox[{"FontTracking", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"FontTracking", "/.", "FullOpts"}], ")"}]}], ",", 
         RowBox[{"FontWeight", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"FontWeight", "/.", "FullOpts"}], ")"}]}], ",", 
         RowBox[{"FontColor", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"FontColor", ",", 
            RowBox[{"Color", "/.", "FullOpts"}], ",", "FullOpts"}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"FontOpacity", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"FontOpacity", ",", 
            RowBox[{"Opacity", "/.", "FullOpts"}], ",", "FullOpts"}], "]"}]}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"ShowAutoStyles", "\[Rule]", "False"}], ",", 
         RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], 
        "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeTextOrientation", "[", 
     RowBox[{"OrientationOption_", ",", "theta_"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"theta0", ",", "InversionSign"}], "\[IndentingNewLine]", "}"}],
       ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"theta0", "=", 
        RowBox[{"Mod", "[", 
         RowBox[{"theta", ",", 
          RowBox[{"2", "*", "Pi"}], ",", 
          RowBox[{"-", "Pi"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"InversionSign", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "Pi"}], "/", "2"}], "<", "theta0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"theta0", "<=", 
             RowBox[{"Pi", "/", "2"}]}], ")"}]}], ",", 
          RowBox[{"+", "1"}], ",", 
          RowBox[{"-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "OrientationOption", ",", "\[IndentingNewLine]", "Automatic", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"InversionSign", "*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "theta", "]"}], ",", 
            RowBox[{"Sin", "[", "theta", "]"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", "Inverted", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"-", "InversionSign"}], "*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "theta", "]"}], ",", 
            RowBox[{"Sin", "[", "theta", "]"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", "Horizontal", ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
         "Vertical", ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"_", "?", "NumericQ"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "OrientationOption", "]"}], ",", 
           RowBox[{"Sin", "[", "OrientationOption", "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", "_List", ",", "\[IndentingNewLine]", 
         "OrientationOption"}], "\[IndentingNewLine]", "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeText", "[", 
    RowBox[{"Art_", ",", "Posn_", ",", "DefaultAngle_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", "  ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", "Opts", "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
       "CalculatedOffset", ",", "\[IndentingNewLine]", "CalculatedPosn", ",", 
       "\[IndentingNewLine]", "CalculatedOrientation", ",", 
       "\[IndentingNewLine]", "StyleList", ",", "\[IndentingNewLine]", 
       "StyledText", ",", "\[IndentingNewLine]", "OptOffset", ",", 
       "\[IndentingNewLine]", "OptNudge", ",", "\[IndentingNewLine]", 
       "OptBackground", ",", "\[IndentingNewLine]", "IsInRegion"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowText", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ClipToRectangle", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Offset", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Nudge", ",", 
        RowBox[{"None", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"OptOffset", "=", 
       RowBox[{"(", 
        RowBox[{"Offset", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptNudge", "=", 
       RowBox[{"(", 
        RowBox[{"Nudge", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "background", " ", "of", " ", "Automatic", " ", "should", " ", "use", 
         " ", "panel", " ", "background", " ", "$Background", " ", "if", " ", 
         "defined"}], ",", " ", 
        RowBox[{"else", " ", "white"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      
      RowBox[{"OptBackground", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"Background", ",", 
         RowBox[{"Switch", "[", 
          RowBox[{
          "$Background", ",", "None", ",", "White", ",", "_", ",", 
           "$Background"}], "]"}], ",", "FullOpts"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Calculate", " ", "properties"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"CalculatedOffset", "=", "OptOffset"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CalculatedPosn", "=", 
       RowBox[{"Posn", "+", 
        RowBox[{"DPCOfPA", "[", 
         RowBox[{"UpgradeScalarY", "[", "OptNudge", "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CalculatedOrientation", "=", 
       RowBox[{"MakeTextOrientation", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Orientation", "/.", "FullOpts"}], ")"}], " ", ",", 
         "DefaultAngle"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"StyleList", "=", 
       RowBox[{"MakeTextStyle", "[", "FullOpts", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"IsInRegion", "=", 
       RowBox[{"InRegion", "[", 
        RowBox[{"$RegionRange", ",", "Posn"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Show", "/.", "FullOpts"}], ")"}], "&&", 
         RowBox[{"(", 
          RowBox[{"ShowText", "/.", "FullOpts"}], ")"}], "&&", 
         RowBox[{"(", 
          RowBox[{"Art", "=!=", "None"}], ")"}]}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"IsInRegion", "||", 
           RowBox[{"!", 
            RowBox[{"(", 
             RowBox[{"ClipToRectangle", "/.", "FullOpts"}], ")"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"apply", " ", "style", " ", "to", " ", "text"}], " ", 
            "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"StyledText", "=", 
              RowBox[{"DisplayForm", "[", 
               RowBox[{"Style", "[", 
                RowBox[{
                 RowBox[{"DisplayForm", "[", "Art", "]"}], ",", "StyleList"}],
                 "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{"background", " ", "block"}], " ", "*)"}], 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"OptBackground", "=!=", "None"}], ")"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"SchemeGraphics", "[", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{"Text", "[", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"Framed", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Invisible", "[", "StyledText", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"FrameMargins", "\[Rule]", "None"}], ",", 
                    RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                    RowBox[{"ContentPadding", "\[Rule]", "False"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Background", "\[Rule]", "OptBackground"}]}], 
                    "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
                    "CalculatedPosn", ",", "\[IndentingNewLine]", 
                    "CalculatedOffset", ",", "\[IndentingNewLine]", 
                    "CalculatedOrientation"}], "\[IndentingNewLine]", "]"}], 
                  "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"GetAutoOption", "[", 
                  RowBox[{
                  "Layer", ",", "$SchemeBlankingLayer", ",", "FullOpts"}], 
                  "]"}]}], "\[IndentingNewLine]", "]"}]}], 
              "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"text", " ", "itself"}], " ", "*)"}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"SchemeGraphics", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"Text", "[", 
                RowBox[{
                "StyledText", ",", "CalculatedPosn", ",", "CalculatedOffset", 
                 ",", "CalculatedOrientation"}], "]"}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"Layer", ",", "$SchemeTextLayer", ",", "FullOpts"}], 
               "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]",
            "}"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
       "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39508980746875*^9, 3.395089811546875*^9}, {
   3.395520606171875*^9, 3.395520609015625*^9}, {3.396634539125*^9, 
   3.39663457575*^9}, {3.39663520575*^9, 3.39663521278125*^9}, 
   3.39973480634375*^9, {3.411246404546875*^9, 3.411246409890625*^9}, {
   3.411246648796875*^9, 3.411246668578125*^9}, {3.411246850890625*^9, 
   3.4112469100625*^9}, {3.411247001609375*^9, 3.411247003484375*^9}, {
   3.411247039984375*^9, 3.41124707440625*^9}, {3.41124711196875*^9, 
   3.411247143546875*^9}, {3.459982953890625*^9, 3.4599829981875*^9}, {
   3.491411916609375*^9, 3.491411939390625*^9}, {3.49141204325*^9, 
   3.49141205965625*^9}, {3.491412105984375*^9, 3.491412138875*^9}, {
   3.491412208875*^9, 3.49141221125*^9}, {3.49141226790625*^9, 
   3.491412268640625*^9}, {3.491412417390625*^9, 3.4914124180625*^9}, {
   3.491412527234375*^9, 3.491412528*^9}, 3.491412597203125*^9, {
   3.49329578440625*^9, 3.493295793015625*^9}, {3.49687780803125*^9, 
   3.49687781659375*^9}, {3.49687788753125*^9, 3.49687801946875*^9}, {
   3.496878249171875*^9, 3.496878348453125*^9}, {3.49687848228125*^9, 
   3.49687848415625*^9}, {3.496878556203125*^9, 3.496878564421875*^9}, 
   3.49687861640625*^9, {3.496878731859375*^9, 3.496878736359375*^9}, 
   3.502554573953125*^9, 3.50255462815625*^9, {3.50255470775*^9, 
   3.502554802875*^9}, {3.5025548570625*^9, 3.502554859265625*^9}, {
   3.502554914984375*^9, 3.5025549193125*^9}, {3.502555194203125*^9, 
   3.502555200375*^9}, {3.502555265625*^9, 3.502555269703125*^9}, {
   3.502555336484375*^9, 3.50255536971875*^9}, {3.502555439015625*^9, 
   3.50255545171875*^9}, {3.50255557375*^9, 3.5025556216875*^9}}],

Cell["\<\
MakeText3D -- 3D analogue of MakeText
\tignores options Nudge, Layer\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeText3D", "[", 
    RowBox[{"Art_", ",", "Posn_", ",", "DefaultAngle_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", "  ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", "Opts", "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
       "CalculatedOffset", ",", "\[IndentingNewLine]", "CalculatedPosn", ",", 
       "\[IndentingNewLine]", "CalculatedOrientation", ",", 
       "\[IndentingNewLine]", "StyleList", ",", "\[IndentingNewLine]", 
       "OptBackground"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowText", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"OptBackground", "=", 
       RowBox[{"(", 
        RowBox[{"Background", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Calculate", " ", "properties"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"CalculatedOffset", "=", 
       RowBox[{"(", 
        RowBox[{"Offset", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CalculatedPosn", "=", "Posn"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CalculatedOrientation", "=", 
       RowBox[{"MakeTextOrientation", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Orientation", "/.", "FullOpts"}], ")"}], " ", ",", 
         "DefaultAngle"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"StyleList", "=", 
       RowBox[{"MakeTextStyle", "[", "FullOpts", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"GeometricTransformation", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"background", " ", "block"}], " ", "*)"}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{"Note", ":", " ", 
               RowBox[{
               "If", " ", "FontSize", " ", "is", " ", "specified", " ", "in", 
                " ", "TextStyle", " ", "option", " ", "to", " ", 
                RowBox[{"Text", "[", "]"}]}]}], ",", " ", 
              RowBox[{
              "then", " ", "background", " ", "box", " ", "can", " ", "still",
                " ", "shrink", " ", "horizontally", " ", "but", " ", "can", 
               " ", "never", " ", "shrink", " ", "below", " ", "the", " ", 
               RowBox[{"font", "'"}], "s", " ", "height", " ", 
               RowBox[{"(", 
                RowBox[{"with", " ", "generous", " ", "margins"}], ")"}]}], 
              ",", " ", 
              RowBox[{
              "whether", " ", "adjusted", " ", "with", " ", "an", " ", 
               "AdjustmentBox", " ", "or", " ", "set", " ", "in", " ", "a", 
               " ", "different", " ", "font", " ", "size", " ", "using", " ", 
               "they", " ", 
               RowBox[{"StyleBox", ".", "  ", "Vertical"}], " ", "height", 
               " ", "seems", " ", "not", " ", "to", " ", "shrink", " ", 
               "much", " ", "in", " ", "general", " ", "for", " ", "smaller", 
               " ", 
               RowBox[{"fonts", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]",
             "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Show", "/.", "FullOpts"}], ")"}], "&&", 
                RowBox[{"(", 
                 RowBox[{"ShowText", "/.", "FullOpts"}], ")"}], "&&", 
                RowBox[{"(", 
                 RowBox[{"Art", "=!=", "None"}], ")"}], "&&", 
                RowBox[{"(", 
                 RowBox[{"OptBackground", "=!=", "None"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{"Text", "[", "\[IndentingNewLine]", 
                 RowBox[{"(*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    RowBox[{"AdjustmentBox", "[", 
                    RowBox[{"Art", ",", 
                    RowBox[{"BoxMargins", "\[Rule]", "$BackgroundMargins"}]}],
                     "]"}], ",", 
                    RowBox[{"ShowContents", "\[Rule]", "False"}]}], "]"}], "//",
                     "DisplayForm"}], ","}], "*)"}], "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"DisplayForm", "[", 
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"Art", ",", 
                    RowBox[{"FontSize", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}], ",", 
                    RowBox[{"ShowContents", "\[Rule]", "False"}]}], "]"}], 
                   "]"}], ",", "\[IndentingNewLine]", "CalculatedPosn", ",", 
                  "\[IndentingNewLine]", "CalculatedOffset", ",", 
                  "\[IndentingNewLine]", "CalculatedOrientation", ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"BaseStyle", "\[Rule]", "StyleList"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Background", "\[Rule]", "OptBackground"}]}], 
                 "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "}"}], 
               ",", "\[IndentingNewLine]", 
               RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{"text", " ", "itself"}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Show", "/.", "FullOpts"}], ")"}], "&&", 
                RowBox[{"(", 
                 RowBox[{"ShowText", "/.", "FullOpts"}], ")"}], "&&", 
                RowBox[{"(", 
                 RowBox[{"Art", "=!=", "None"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{"Text", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"DisplayForm", "[", "Art", "]"}], ",", 
                  "\[IndentingNewLine]", "CalculatedPosn", ",", 
                  "\[IndentingNewLine]", "CalculatedOffset", ",", 
                  "\[IndentingNewLine]", "CalculatedOrientation", ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"BaseStyle", "\[Rule]", "StyleList"}]}], 
                 "\[IndentingNewLine]", "]"}], "}"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], 
           "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(", 
           RowBox[{"GeometricTransformation", "/.", "FullOpts"}], ")"}]}], 
         "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "}"}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395089289671875*^9, 3.39508929334375*^9}, {
  3.4596983526875*^9, 3.459698437671875*^9}, {3.45969954878125*^9, 
  3.459699555046875*^9}, {3.50255512559375*^9, 3.50255513415625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Raw graphics", "Subsection"],

Cell["\<\
MakeRawGraphics returns graphics with prepended directives (or Null)
\tArguments:
\t\tArt -- list of graphics primatives
\t\tArt is assumed to be \"safe\", with no directives at top level, and so \
should be quarantined by the calling routine.
\tRequired options:
\t\tShow
\t\tColor, Opacity
\t\toutline directive options except LineColor and LineOpacity
\t\tLayer (Automatic yields background layer default)\
\>", "Text",
 CellChangeTimes->{{3.396635250515625*^9, 3.396635259859375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeRawGraphicsDirectives", "[", "FullOpts_List", "]"}], " ", ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckOption", "[", 
        RowBox[{"Color", ",", "ColorDirectivePattern", ",", "FullOpts"}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"Opacity", ",", 
         RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"MakeOutlineDirectives", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"FullOpts", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"LineColor", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"LineOpacity", "\[Rule]", "Automatic"}]}], "}"}]}], "]"}],
         "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeRawGraphics", "[", 
    RowBox[{"Art_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", "Opts", "}"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Layer", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"_", "?", "NumericQ"}]}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Show", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
        RowBox[{"SchemeGraphics", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"MakeRawGraphicsDirectives", "[", "FullOpts", "]"}], ",", 
          "\[IndentingNewLine]", "Art", ",", "\[IndentingNewLine]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"Layer", ",", "$SchemeDrawingLayer", ",", "FullOpts"}], 
           "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.3955206215*^9, {3.3966352624375*^9, 3.396635286328125*^9}}],

Cell["\<\
MakeRawGraphics3D -- 3D analogue of RawGraphics
\tignores option Layer\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeRawGraphics3D", "[", 
    RowBox[{"Art_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", "Opts", "}"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Show", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"GeometricTransformation", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Flatten", "[", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"MakeRawGraphicsDirectives", "[", "FullOpts", "]"}], 
                ",", " ", 
                RowBox[{
                 RowBox[{"--", " ", "makes"}], " ", "objects", " ", "black", 
                 " ", "by", " ", "default"}]}], " ", "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"(*", " ", 
               RowBox[{"PRESENTLY", " ", 
                RowBox[{"IGNORED", " ", "--"}], " ", "style", " ", 
                "directives"}], " ", "*)"}], "\[IndentingNewLine]", "Art", 
              "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{"GeometricTransformation", "/.", "FullOpts"}], ")"}]}], 
           "\[IndentingNewLine]", "]"}], "}"}], "\[IndentingNewLine]", 
         "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4596988048125*^9, 3.45969881315625*^9}, {
   3.459698859515625*^9, 3.459698861546875*^9}, {3.459698900921875*^9, 
   3.459698904734375*^9}, {3.4596989879375*^9, 3.45969899009375*^9}, {
   3.45969902884375*^9, 3.45969906628125*^9}, 3.459699125015625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Verbatim", "Subsection"],

Cell["\<\
MakeVerbatim returns graphics with no prepended directives (or Null)
\tArguments:
\t\tArt -- list of graphics primatives
\t\tArt is assumed to be \"safe\", with no directives at top level, and so \
should be quarantined by the calling routine.
\tRequired options:
\t\tShow
\t\tLayer (Automatic yields background layer default)\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeVerbatim", "[", 
    RowBox[{"Art_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", "Opts", "}"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Layer", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"_", "?", "NumericQ"}]}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Show", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
        RowBox[{"SchemeGraphics", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "Art", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"Layer", ",", "$SchemeDrawingLayer", ",", "FullOpts"}], 
           "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Drawing objects", "Section"],

Cell[CellGroupData[{

Cell["Basic curve annotation", "Subsection"],

Cell["\<\
TO DO: Fix label geometry calculation for curve (data set) with just one \
point and gracefully handle null curve.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicLineAnnotations", "[", 
    RowBox[{"Points_List", ",", "FullOpts_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "AbsPoints", ",", "Lengths", ",", "LengthSoFar", ",", "CurveParam", ",",
        "\[IndentingNewLine]", "AbsXFcn", ",", "AbsYFcn", ",", "AbsPFcn", ",",
        "AbsTangentFcn", ",", "\[IndentingNewLine]", "HalfWidthForLabels", 
       ",", "\[IndentingNewLine]", "bufft", ",", "offt", ",", "OptPosnT", ",",
        "PointT", ",", "AngleT", ",", "\[IndentingNewLine]", "buffb", ",", 
       "offb", ",", "OptPosnB", ",", "PointB", ",", "AngleB", ",", 
       "\[IndentingNewLine]", "OptPosnL", ",", "PointL", ",", "AngleL", ",", 
       "\[IndentingNewLine]", "OptPosnR", ",", "PointR", ",", "AngleR", ",", 
       "\[IndentingNewLine]", "OptPosnC", ",", "PointC", ",", "AngleC"}], 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"option", " ", "processing"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"PosnL", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PosnR", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PosnT", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PosnB", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PosnC", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"parametrize", " ", "data", " ", "curve"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"AbsPoints", "=", 
       RowBox[{"PAOfPC", "/@", "Points"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Lengths", "=", 
       RowBox[{"VectorLength", "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Drop", "[", 
           RowBox[{"AbsPoints", ",", 
            RowBox[{"-", "1"}]}], "]"}], "-", 
          RowBox[{"Drop", "[", 
           RowBox[{"AbsPoints", ",", "1"}], "]"}]}], ")"}]}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"i", ".", "e", "."}], ",", " ", 
        RowBox[{"Most", "-", "Rest"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LengthSoFar", "=", "0."}], ";", "\[IndentingNewLine]", 
      RowBox[{"CurveParam", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"LengthSoFar", "+=", "#"}], "&"}], ")"}], "/@", 
         RowBox[{"Prepend", "[", 
          RowBox[{"Lengths", ",", "0."}], "]"}]}], "/", "LengthSoFar"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"AbsXFcn", "=", 
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{"CurveParam", ",", 
            RowBox[{"First", "/@", "AbsPoints"}]}], "}"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AbsYFcn", "=", 
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{"CurveParam", ",", 
            RowBox[{"Last", "/@", "AbsPoints"}]}], "}"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AbsPFcn", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsXFcn", "[", "#", "]"}], ",", 
           RowBox[{"AbsYFcn", "[", "#", "]"}]}], "}"}], "&"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AbsTangentFcn", "=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Derivative", "[", "1", "]"}], "[", "AbsXFcn", "]"}], 
             "[", "#", "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"Derivative", "[", "1", "]"}], "[", "AbsYFcn", "]"}], 
             "[", "#", "]"}]}], "}"}], "/", 
          RowBox[{"VectorLength", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Derivative", "[", "1", "]"}], "[", "AbsXFcn", "]"}], 
              "[", "#", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Derivative", "[", "1", "]"}], "[", "AbsYFcn", "]"}], 
              "[", "#", "]"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", "&"}],
         ")"}]}], ";", "  ", "\[IndentingNewLine]", 
      RowBox[{"AbsNormalFcn", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ".", 
          RowBox[{"AbsTangentFcn", "[", "#", "]"}]}], "&"}], ")"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"HalfWidthForLabels", "=", "0"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "was", " ", "to", " ", "allow", " ", "for", " ", "line", " ", "width",
          " ", "in", " ", "placing", " ", "labels"}], ",", " ", 
        RowBox[{
        "but", " ", "awkward", " ", "if", " ", "do", " ", "not", " ", "know", 
         " ", "orientation", " ", "out", " ", "to", " ", "label", " ", "in", 
         " ", 
         RowBox[{"advance", " ", "--"}], " ", "could", " ", "incorporate", 
         " ", "into", " ", "Buffer", " ", "mechanism"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"SuppressMessage", "[", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "silently", " ", "allow", " ", "linear", " ", "extrapolation", " ", 
         "of", " ", "curve"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"InterpolatingFunction", "::", "\"\<dmval\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabT", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
              ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"offt", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"OffsetT", ",", "\[IndentingNewLine]", 
                RowBox[{"Switch", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Horizontal", "|", "Vertical"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Automatic", "|", "Inverted", "|", "_"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}]}], "\[IndentingNewLine]", 
                 "]"}], ",", "\[IndentingNewLine]", "FullOpts"}], 
               "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"bufft", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"BufferT", ",", "\[IndentingNewLine]", 
                RowBox[{"Switch", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Horizontal", "|", "Vertical"}], ",", "0", ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Automatic", "|", "Inverted", "|", "_"}], ",", 
                  "1.1"}], "\[IndentingNewLine]", "]"}], ",", 
                "\[IndentingNewLine]", "FullOpts"}], "\[IndentingNewLine]", 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"OptPosnT", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"PosnT", ",", "0.5", ",", "FullOpts"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"PointT", "=", 
              RowBox[{"PCOfPA", "@", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"AbsPFcn", "[", "OptPosnT", "]"}], "+", 
                 RowBox[{
                  RowBox[{"AbsNormalFcn", "[", "OptPosnT", "]"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"HalfWidthForLabels", "+", 
                    RowBox[{
                    RowBox[{"bufft", "/", "2"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"AngleT", "=", 
              RowBox[{"VectorArcTan", "[", 
               RowBox[{"AbsTangentFcn", "[", "OptPosnT", "]"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeText", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabT", "/.", "FullOpts"}], ")"}], ",", "PointT", ",",
                "AngleT", ",", "\[IndentingNewLine]", 
               RowBox[{"ShowText", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Offset", "\[Rule]", "offt"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Nudge", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"NudgeT", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Orientation", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Background", "->", 
                RowBox[{"(", 
                 RowBox[{"BackgroundT", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", "FullOpts"}], " ", 
              "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
          ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabB", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
              ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"ShowLabB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"offb", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"OffsetB", ",", "\[IndentingNewLine]", 
                RowBox[{"Switch", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"OrientationB", "/.", "FullOpts"}], ")"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Horizontal", "|", "Vertical"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Automatic", "|", "Inverted", "|", "_"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}]}], "\[IndentingNewLine]", 
                 "]"}], ",", "\[IndentingNewLine]", "FullOpts"}], 
               "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"buffb", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"BufferB", ",", "\[IndentingNewLine]", 
                RowBox[{"Switch", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"OrientationB", "/.", "FullOpts"}], ")"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Horizontal", "|", "Vertical"}], ",", "0", ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Automatic", "|", "Inverted", "|", "_"}], ",", 
                  "1.1"}], "\[IndentingNewLine]", "]"}], ",", 
                "\[IndentingNewLine]", "FullOpts"}], "\[IndentingNewLine]", 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"OptPosnB", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"PosnB", ",", "0.5", ",", "FullOpts"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"PointB", "=", 
              RowBox[{"PCOfPA", "@", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"AbsPFcn", "[", "OptPosnB", "]"}], "-", 
                 RowBox[{
                  RowBox[{"AbsNormalFcn", "[", "OptPosnB", "]"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"HalfWidthForLabels", "+", 
                    RowBox[{
                    RowBox[{"buffb", "/", "2"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"AngleB", "=", 
              RowBox[{"VectorArcTan", "[", 
               RowBox[{"AbsTangentFcn", "[", "OptPosnB", "]"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeText", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabB", "/.", "FullOpts"}], ")"}], ",", "PointB", ",",
                "AngleB", ",", "\[IndentingNewLine]", 
               RowBox[{"ShowText", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"ShowLabB", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Offset", "\[Rule]", "offb"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Nudge", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"NudgeB", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Orientation", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"OrientationB", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Background", "->", 
                RowBox[{"(", 
                 RowBox[{"BackgroundB", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", "FullOpts"}], " ", 
              "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
          ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabL", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
              ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"OptPosnL", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"PosnL", ",", "0.0", ",", "FullOpts"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"PointL", "=", 
              RowBox[{"PCOfPA", "@", 
               RowBox[{"AbsPFcn", "[", "OptPosnL", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"AngleL", "=", 
              RowBox[{"VectorArcTan", "[", 
               RowBox[{"AbsTangentFcn", "[", "OptPosnL", "]"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeText", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabL", "/.", "FullOpts"}], ")"}], ",", "PointL", ",",
                "AngleL", ",", "\[IndentingNewLine]", 
               RowBox[{"ShowText", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Offset", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"OffsetL", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"+", "1"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
                 "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"Nudge", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"NudgeL", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Orientation", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Background", "->", 
                RowBox[{"(", 
                 RowBox[{"BackgroundL", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", "FullOpts"}], " ", 
              "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
          ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabR", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
              ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"OptPosnR", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"PosnR", ",", "1.0", ",", "FullOpts"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"PointR", "=", 
              RowBox[{"PCOfPA", "@", 
               RowBox[{"AbsPFcn", "[", "OptPosnR", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"AngleR", "=", 
              RowBox[{"VectorArcTan", "[", 
               RowBox[{"AbsTangentFcn", "[", "OptPosnR", "]"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeText", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabR", "/.", "FullOpts"}], ")"}], ",", "PointR", ",",
                "AngleR", ",", "\[IndentingNewLine]", 
               RowBox[{"ShowText", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Offset", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"OffsetR", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
                 "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"Nudge", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"NudgeR", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Orientation", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Background", "->", 
                RowBox[{"(", 
                 RowBox[{"BackgroundR", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", "FullOpts"}], " ", 
              "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
          ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabC", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
              ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"OptPosnC", "=", 
              RowBox[{"GetAutoOption", "[", 
               RowBox[{"PosnC", ",", "0.5", ",", "FullOpts"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"PointC", "=", 
              RowBox[{"PCOfPA", "@", 
               RowBox[{"AbsPFcn", "[", "OptPosnC", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"AngleC", "=", 
              RowBox[{"VectorArcTan", "[", 
               RowBox[{"AbsTangentFcn", "[", "OptPosnC", "]"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeText", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"LabC", "/.", "FullOpts"}], ")"}], ",", "PointC", ",",
                "AngleC", ",", "\[IndentingNewLine]", 
               RowBox[{"ShowText", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Offset", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"OffsetC", ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}],
                ",", "\[IndentingNewLine]", 
               RowBox[{"Nudge", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"NudgeC", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Orientation", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"OrientationC", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Background", "->", 
                RowBox[{"(", 
                 RowBox[{"BackgroundC", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", "FullOpts"}], " ", 
              "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
           "]"}]}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
       "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.465726513390625*^9, 3.465726557484375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic arrow object", "Subsection"],

Cell["\<\
ArrowPoint calculates the absolute coordinates of a point with its lateral \
position along the arrow (denoted by x, since the arrow is constructed \"on \
its side\") and transverse displacement relative to the arrow axis (denoted \
by y) specified in various ways.  Position along the axis may be specified \
according to various modes: as a fraction of the length of the arrow, as an \
explicit absolute coordinate, on the beveled tail surface, on a horizontal \
tail surface, or various places in relation to the arrow head.

Calculation of position FromHeadVertical/FromTailVertical will fail for \
horizontal arrow, and similarly calculation \
FromHeadHorizontal/FromTailHorizontal will fail for vertical arrow.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{"Caller_Symbol", ",", 
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtUserPosition", 
     ",", "x_", ",", "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d", ",", "xa"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckValue", "[", "\[IndentingNewLine]", 
       RowBox[{"x", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
         RowBox[{"FromHead", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], "|", 
         RowBox[{"FromTail", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], "|", 
         RowBox[{"FromHeadVertical", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], "|", 
         RowBox[{"FromTailVertical", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], "|", 
         RowBox[{"FromHeadHorizontal", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], "|", 
         RowBox[{"FromTailHorizontal", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}]}], ",", 
        "\[IndentingNewLine]", "\"\<a label position\>\""}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xa", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"x", ",", "\[IndentingNewLine]", 
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"x", "*", "d"}], ",", "\[IndentingNewLine]", 
         RowBox[{"FromHead", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], ",", 
         RowBox[{"d", "-", 
          RowBox[{"x", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"FromTail", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], ",", 
         RowBox[{"x", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"FromHeadVertical", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Chop", "[", 
              RowBox[{"Sin", "[", "theta", "]"}], "]"}], "\[Equal]", "0"}], 
            ",", 
            RowBox[{"ErrorMessage", "[", 
             RowBox[{"Caller", "::", "fromvert"}], "]"}]}], "]"}], ";", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "-", 
             RowBox[{"x", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
           RowBox[{"(", 
            RowBox[{"-", 
             RowBox[{"Csc", "[", "theta", "]"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FromTailVertical", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Chop", "[", 
              RowBox[{"Sin", "[", "theta", "]"}], "]"}], "\[Equal]", "0"}], 
            ",", 
            RowBox[{"ErrorMessage", "[", 
             RowBox[{"Caller", "::", "fromvert"}], "]"}]}], "]"}], ";", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ")"}], "*", 
           RowBox[{"(", 
            RowBox[{"-", 
             RowBox[{"Csc", "[", "theta", "]"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FromHeadHorizontal", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Chop", "[", 
              RowBox[{"Cos", "[", "theta", "]"}], "]"}], "\[Equal]", "0"}], 
            ",", 
            RowBox[{"ErrorMessage", "[", 
             RowBox[{"Caller", "::", "fromhoriz"}], "]"}]}], "]"}], ";", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "-", 
             RowBox[{"x", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
           RowBox[{"(", 
            RowBox[{"-", 
             RowBox[{"Sec", "[", "theta", "]"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FromTailHorizontal", "[", 
          RowBox[{"_", "?", "NumericQ"}], "]"}], ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Chop", "[", 
              RowBox[{"Cos", "[", "theta", "]"}], "]"}], "\[Equal]", "0"}], 
            ",", 
            RowBox[{"ErrorMessage", "[", 
             RowBox[{"Caller", "::", "fromhoriz"}], "]"}]}], "]"}], ";", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ")"}], "*", 
           RowBox[{"(", 
            RowBox[{"-", 
             RowBox[{"Sec", "[", "theta", "]"}]}], ")"}]}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"xa", ",", "ya"}], "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtPosition", ",", 
     "xa_", ",", "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"xa", ",", "ya"}], "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtTail", ",", 
     "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "ya"}], "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtTail", ",", 
     RowBox[{"{", 
      RowBox[{"xa_", ",", "ya_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"xa", ",", "ya"}], "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtTailHorizontal", 
     ",", "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "theta", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "ya"}], "*", 
          RowBox[{"Csc", "[", "theta", "]"}]}], ",", "0"}], "}"}]}]}]}], " ", 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtHead", ",", 
     "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"d", ",", "ya"}], "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtHead", ",", 
     RowBox[{"{", 
      RowBox[{"xa_", ",", "ya_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "+", "xa"}], ",", "ya"}], "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtHeadHorizontal", 
     ",", "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "theta", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pfa", "+", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "ya"}], "*", 
          RowBox[{"Csc", "[", "theta", "]"}]}], ",", "0"}], "}"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtLip", ",", 
     "HeadLength_", ",", "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "-", "HeadLength"}], ",", "ya"}], "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtTailLip", ",", 
     "HeadLength_", ",", "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"HeadLength", ",", "ya"}], "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowPoint", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", "AtEdge", ",", 
     "HeadLength_", ",", "HeadHalfWidth_", ",", "ya_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"theta", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pia", "+", 
       RowBox[{"LegacyRotate2D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "-", 
            RowBox[{
             RowBox[{"Abs", "[", "ya", "]"}], "*", 
             RowBox[{"HeadLength", "/", "HeadHalfWidth"}]}]}], ",", "ya"}], 
          "}"}], ",", 
         RowBox[{"-", "theta"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395091061953125*^9, 3.39509106553125*^9}, {
  3.488199882609375*^9, 3.4881999614375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SquigglePoints", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pia_List", ",", "Pfa_List"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"MinBuffer1_", ",", "MinBuffer2_"}], "}"}], ",", "HalfWidth_", 
     ",", "SquiggleWavelength_", ",", "SquiggleSide_", ",", "PlotPoints_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "theta", ",", "d", ",", "dp", ",", "Delta", ",", "x", ",", "PointList", 
       ",", "s"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"s", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"SquiggleSide", ",", "Right", ",", 
         RowBox[{"+", "1"}], ",", "Left", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"theta", "=", 
       RowBox[{"VectorArcTan", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"VectorLength", "[", 
        RowBox[{"Pfa", "-", "Pia"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dp", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"SquiggleWavelength", "/", "2"}], ")"}], "*", 
        RowBox[{"Floor", "[", 
         RowBox[{
          RowBox[{"Max", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "-", "MinBuffer1", "-", "MinBuffer2"}], ")"}], ",", 
            "0"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"SquiggleWavelength", "/", "2"}], ")"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Delta", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "-", "MinBuffer1", "-", "MinBuffer2", "-", "dp"}], 
         ")"}], "/", "2"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"PointList", "=", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Pia", "+", 
          RowBox[{"LegacyRotate2D", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x", "+", "MinBuffer1", "+", "Delta"}], ",", 
              RowBox[{"s", "*", "HalfWidth", "*", 
               RowBox[{"Sin", "[", 
                RowBox[{"2", "*", 
                 RowBox[{"Pi", "/", "SquiggleWavelength"}], "*", "x"}], 
                "]"}]}]}], "}"}], ",", 
            RowBox[{"-", "theta"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "dp", ",", 
           RowBox[{"SquiggleWavelength", "/", "PlotPoints"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "Pia", "}"}], ",", "PointList", ",", 
        RowBox[{"{", "Pfa", "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.395091066171875*^9}],

Cell["\<\
ArrowHeadPoints
\tReturns list of three points defining an arrow head at the end of the given \
segment.  All coordinates are absolute.
\tArrowHeadPoints[{P1a,P2a},...], defined with segment, reduces to \
ArrowHeadPoints[Pa,theta,...].\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ArrowHeadPoints", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"P1a", ":", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
       RowBox[{"P2a", ":", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "}"}], ",", 
     RowBox[{"HeadLength_", "?", "NumericQ"}], ",", 
     RowBox[{"HeadLip_", "?", "NumericQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"ArrowHeadPoints", "[", 
    RowBox[{"P2a", ",", 
     RowBox[{"VectorArcTan", "[", 
      RowBox[{"P2a", "-", "P1a"}], "]"}], ",", "HeadLength", ",", "HeadLip"}],
     "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ArrowHeadPoints", "[", 
    RowBox[{
     RowBox[{"Pa", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"theta_", "?", "NumericQ"}], ",", 
     RowBox[{"HeadLength_", "?", "NumericQ"}], ",", 
     RowBox[{"HeadLip_", "?", "NumericQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Pa", "+", 
        RowBox[{"LegacyRotate2D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "HeadLength"}], ",", 
            RowBox[{"+", "HeadLip"}]}], "}"}], ",", 
          RowBox[{"-", "theta"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Pa", "+", 
        RowBox[{"{", 
         RowBox[{"0.", ",", "0."}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Pa", "+", 
        RowBox[{"LegacyRotate2D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "HeadLength"}], ",", 
            RowBox[{"-", "HeadLip"}]}], "}"}], ",", 
          RowBox[{"-", "theta"}]}], "]"}]}]}], "\[IndentingNewLine]", "}"}]}],
     "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3950910666875*^9, 3.39509106709375*^9}}],

Cell[TextData[{
 "Shape arrow geometry and kink geometry\n                                    \
            5",
 StyleBox["\n     7               |\\                       \n     \
----------------- \\                      \n     |               6  \\        \
  \n     |0 (=i     )        ) 4 (=f)                                Segment \
\n     |               2  /                      i -----*-----*---*-------> f \
  \n     ----------------- /                              k1    k2  k3 ...\n  \
   1               |/\n                     3\n     <-------- d ------->\n    \
 ",
  FontFamily->"Courier"],
 "\nArrow points are calculated in horizontal orientation, rotated to correct \
theta, then displaced to put origin at tail point.  All calculations must be \
done in absolute units (printer's points), for which x and y metrics on \
screen are the same, so that arrow won't be skewed under rotation.\n\nFor a \
conversion electron shaded area, extending from one side to a line at height \
y above the centerline, the width is ConversionWidth=(Width/2 \[PlusMinus] \
y), and the ratio of shaded width to total width should be \
ConversionWidth/Width = alpha/(1+alpha)."
}], "Text"],

Cell["\<\
Calculating label positions

\t1. calculate position along arrow axis (dl,...)
\t\tThis is based upon the fractional position up from the bottom of the arrow.
\t\tFor the top label, it also includes an extra buffer (buffer factor)*(font \
size), mainly so a white-out box will not overlap the level line.
\t2. calculate displacement perpendicular to arrow axis (wl,...)
  \t\tThis is (arrow width)/2 + (buffer \"offset\")/2*(font size) for side \
labels, or 0 for central labels.
      \t3. add displacement to arrow start point to obtain absolute \
coordinates (xl,yl,...)

\"Left\" is defined as CW side, and \"right\" is defined as CCW side, \
therefore having their natural senses for an energy descending transition.

Default label offsets and buffers are set depending upon text orientation:
\tHorizontal/vertical text positioning is most easily controlled using the \
Mathematica offset mechanism, while tilted text is most easily positioned by \
calculating \"buffered\" coordinates for its center relative to the arrow edge.
\t
Debugging: Do not name initial point Pi, as this overloads the constant Pi.  \
Including all text calculations inside If prevents unnecessary error \
conditions when position specification is bad (e.g., horizontal distance \
specified on vertical arrow) but no label is actually to be drawn.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicArrow", "[", 
    RowBox[{"Caller_Symbol", ",", "Nodes_List", ",", "FullOpts_List"}], "]"}],
    " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "PointList", ",", "\[IndentingNewLine]", "AbsNodes", ",", "AbsSegments",
        ",", "Segment", ",", "\[IndentingNewLine]", "ConversionPointList", 
       ",", "ConversionP0", ",", "ConversionP4", ",", "ConversionWidth", ",", 
       "Conversiony", ",", "ConversionSideSign", ",", "\[IndentingNewLine]", 
       "d", ",", "dp", ",", "dk", ",", "Delta", ",", "\[IndentingNewLine]", 
       "ShaftPosition", ",", "ShaftPoints", ",", "\[IndentingNewLine]", 
       "LineArt", ",", "TextArt", ",", "\[IndentingNewLine]", "theta0", ",", 
       "InversionSign", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       "HalfWidthForLabels", ",", "\[IndentingNewLine]", "PLa", ",", "PRa", 
       ",", "PCa", ",", "PTa", ",", "\[IndentingNewLine]", "offl", ",", 
       "offr", ",", "offc", ",", "offkc", ",", "offt", ",", 
       "\[IndentingNewLine]", "buffl", ",", "buffr", ",", 
       "\[IndentingNewLine]", "SegmentPointsL", ",", "SegmentPointsC", ",", 
       "SegmentPointsR", ",", "SegmentPointsT", ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "OptWidth", ",", "\[IndentingNewLine]", 
       "OptThickness", ",", "\[IndentingNewLine]", "OptHeadLength", ",", 
       "\[IndentingNewLine]", "OptShaftLines", ",", "\[IndentingNewLine]", 
       "OptHeadLip"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"option", " ", "checks"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"ArrowType", ",", 
        RowBox[{
        "LineArrow", "|", "MultilineArrow", "|", "SquiggleArrow", "|", 
         "ShapeArrow"}], ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ArrowHalf", ",", 
        RowBox[{"All", "|", "Left", "|", "Right"}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLength", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLip", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Width", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"TailBevel", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShaftLines", ",", 
        RowBox[{
         RowBox[{"(", "x_Integer", ")"}], "/;", 
         RowBox[{"(", 
          RowBox[{"x", "\[GreaterEqual]", "2"}], ")"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PlotPoints", ",", 
        RowBox[{
         RowBox[{"(", "x_Integer", ")"}], "/;", 
         RowBox[{"(", 
          RowBox[{"x", "\[GreaterEqual]", "4"}], ")"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SquiggleBuffer", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x_", "?", "NumericQ"}], ")"}], "/;", 
         RowBox[{"(", 
          RowBox[{"x", ">=", "0"}], ")"}]}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SquiggleWavelength", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x_", "?", "NumericQ"}], ")"}], "/;", 
         RowBox[{"(", 
          RowBox[{"x", ">", "0"}], ")"}]}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SquiggleSide", ",", 
        RowBox[{"Left", "|", "Right"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SegmentL", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"x_Integer", "/;", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "!=", "0"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Abs", "[", "x", "]"}], "<", 
               RowBox[{"Length", "[", "Nodes", "]"}]}], ")"}]}], ")"}]}], 
          ")"}]}], ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SegmentR", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"x_Integer", "/;", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "!=", "0"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Abs", "[", "x", "]"}], "<", 
               RowBox[{"Length", "[", "Nodes", "]"}]}], ")"}]}], ")"}]}], 
          ")"}]}], ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SegmentC", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"x_Integer", "/;", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "!=", "0"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Abs", "[", "x", "]"}], "<", 
               RowBox[{"Length", "[", "Nodes", "]"}]}], ")"}]}], ")"}]}], 
          ")"}]}], ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"!", 
           RowBox[{"MatchQ", "[", 
            RowBox[{
             RowBox[{"ArrowType", "/.", "FullOpts"}], ",", "LineArrow"}], 
            "]"}]}], ")"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Length", "[", "Nodes", "]"}], ">", "2"}], ")"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{"Caller", "::", "kinks"}], "]"}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowHead", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTail", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadRecess", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"TailRecess", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"MatchQ", "[", 
          RowBox[{
           RowBox[{"ArrowType", "/.", "FullOpts"}], ",", 
           RowBox[{"LineArrow", "|", "SquiggleArrow"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"CheckOption", "[", 
         RowBox[{"ShowTail", ",", "False", ",", "FullOpts"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ConversionSide", ",", 
        RowBox[{"Left", "|", "Right"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ConversionCoeff", ",", 
        RowBox[{"None", "|", 
         RowBox[{"_", "?", "NumericQ"}], "|", "Infinity"}], ",", "FullOpts"}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"ConversionCoeff", "/.", "FullOpts"}], ")"}], "=!=", 
           "None"}], ")"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"HeadLip", "/.", "FullOpts"}], ")"}], "=!=", "0"}], 
          ")"}]}], ",", 
        RowBox[{"Message", "[", 
         RowBox[{"Caller", "::", "conversionlip"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"AboveKinkL", "/.", "FullOpts"}], ")"}], "=!=", "False"}], 
        ",", 
        RowBox[{"Message", "[", 
         RowBox[{"LevelScheme", "::", "abovekinkx"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"AboveKinkR", "/.", "FullOpts"}], ")"}], "=!=", "False"}], 
        ",", 
        RowBox[{"Message", "[", 
         RowBox[{"LevelScheme", "::", "abovekinkx"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"AboveKinkC", "/.", "FullOpts"}], ")"}], "=!=", "False"}], 
        ",", 
        RowBox[{"Message", "[", 
         RowBox[{"LevelScheme", "::", "abovekinkx"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"calculate", " ", "arrow", " ", 
        RowBox[{"geometry", " ", "--"}], " ", "absolute", " ", 
        "coordinates"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"AbsNodes", "=", 
       RowBox[{"PAOfPC", "/@", "Nodes"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"AbsNodes", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"ArrowPoint", "[", 
        RowBox[{
         RowBox[{"AbsNodes", "[", 
          RowBox[{"[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], ",", "AtTail", ",", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"TailRecess", "/.", "FullOpts"}], ")"}], ",", "0"}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"AbsNodes", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}], "=", 
       RowBox[{"ArrowPoint", "[", 
        RowBox[{
         RowBox[{"AbsNodes", "[", 
          RowBox[{"[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", 
             RowBox[{"-", "1"}]}], "}"}], "]"}], "]"}], ",", "AtHead", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"HeadRecess", "/.", "FullOpts"}], ")"}]}], ",", "0"}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"AbsSegments", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{"AbsNodes", ",", "2", ",", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"Chop", "/@", 
           RowBox[{"SegmentLength", "/@", "AbsSegments"}]}], ",", "0"}], 
         "]"}], ",", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"Caller", "::", "nullsegment"}], ",", "Nodes"}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Segment", "=", 
       RowBox[{"AbsSegments", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"shorthand", " ", "useful", " ", "for", " ", "single"}], "-", 
        
        RowBox[{"segment", " ", "arrow", " ", "types"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"OptWidth", "=", 
       RowBox[{"(", 
        RowBox[{"Width", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptHeadLength", "=", 
       RowBox[{"(", 
        RowBox[{"HeadLength", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptHeadLip", "=", 
       RowBox[{"(", 
        RowBox[{"HeadLip", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptShaftLines", " ", "=", " ", 
       RowBox[{"(", 
        RowBox[{"ShaftLines", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptThickness", "=", 
       RowBox[{"(", 
        RowBox[{"Thickness", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"make", " ", "arrow"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LineArt", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ArrowType", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", "LineArrow", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "shaft", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"MakeOutline", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Line", "[", 
               RowBox[{"PCOfPA", "/@", "AbsNodes"}], "]"}], "}"}], ",", 
             "FullOpts"}], "]"}], " ", ",", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "head", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ShowHead", "/.", "FullOpts"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeOutline", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Line", "[", 
                 RowBox[{"PCOfPA", "/@", 
                  RowBox[{"ArrowHeadPoints", "[", 
                   RowBox[{
                    RowBox[{"AbsSegments", "[", 
                    RowBox[{"[", 
                    RowBox[{"-", "1"}], "]"}], "]"}], ",", "OptHeadLength", 
                    ",", "OptHeadLip"}], "]"}]}], "]"}], "}"}], ",", 
               RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
              "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "tail", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ShowTail", "/.", "FullOpts"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeOutline", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Line", "[", 
                 RowBox[{"PCOfPA", "/@", 
                  RowBox[{"ArrowHeadPoints", "[", 
                   RowBox[{
                    RowBox[{"Reverse", "@", 
                    RowBox[{"AbsSegments", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", "OptHeadLength", 
                    ",", "OptHeadLip"}], "]"}]}], "]"}], "}"}], ",", 
               RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
              "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         "MultilineArrow", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"ShaftPoints", "=", 
             RowBox[{"Table", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"ShaftPosition", "=", 
                 RowBox[{"OptWidth", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "2"}], "+", 
                    RowBox[{"i", "/", 
                    RowBox[{"(", 
                    RowBox[{"OptShaftLines", "-", "1"}], ")"}]}]}], ")"}]}]}],
                 ";", "\[IndentingNewLine]", 
                RowBox[{"Switch", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"TailBevel", "/.", "FullOpts"}], ")"}], ",", 
                  "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", 
                  
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"ArrowPoint", "[", 
                    RowBox[{"Segment", ",", "AtTail", ",", "ShaftPosition"}], 
                    "]"}], ",", 
                    RowBox[{"ArrowPoint", "[", 
                    RowBox[{
                    "Segment", ",", "AtEdge", ",", "OptHeadLength", ",", 
                    RowBox[{
                    RowBox[{"OptWidth", "/", "2"}], "+", "OptHeadLip"}], ",", 
                    "ShaftPosition"}], "]"}]}], "}"}], ",", 
                  "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"ArrowPoint", "[", 
                    RowBox[{
                    "Segment", ",", "AtTailHorizontal", ",", 
                    "ShaftPosition"}], "]"}], ",", 
                    RowBox[{"ArrowPoint", "[", 
                    RowBox[{
                    "Segment", ",", "AtEdge", ",", "OptHeadLength", ",", 
                    RowBox[{
                    RowBox[{"OptWidth", "/", "2"}], "+", "OptHeadLip"}], ",", 
                    "ShaftPosition"}], "]"}]}], "}"}]}], 
                 "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{"i", ",", "0", ",", 
                 RowBox[{"OptShaftLines", "-", "1"}]}], "}"}]}], 
              "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", "fill", " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{"Polygon", "[", 
                RowBox[{"PCOfPA", "/@", 
                 RowBox[{"Join", "[", 
                  RowBox[{
                   RowBox[{"First", "[", "ShaftPoints", "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Last", "[", "Segment", "]"}], "}"}], ",", 
                   RowBox[{"Reverse", "[", 
                    RowBox[{"Last", "[", "ShaftPoints", "]"}], "]"}]}], 
                  "]"}]}], "]"}], "\[IndentingNewLine]", "}"}], ",", 
              "\[IndentingNewLine]", "FullOpts"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"shaft", " ", "lines"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{"Table", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"Line", "[", 
                 RowBox[{"PCOfPA", "/@", 
                  RowBox[{"ShaftPoints", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"i", ",", "1", ",", "OptShaftLines"}], "}"}]}], 
               "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "}"}], 
             ",", "\[IndentingNewLine]", "FullOpts"}], "]"}], " ", ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "head", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ShowHead", "/.", "FullOpts"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeOutline", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Line", "[", 
                 RowBox[{"PCOfPA", "/@", 
                  RowBox[{"ArrowHeadPoints", "[", 
                   RowBox[{"Segment", ",", "OptHeadLength", ",", 
                    RowBox[{
                    RowBox[{"OptWidth", "/", "2"}], "+", "OptHeadLip"}]}], 
                   "]"}]}], "]"}], "}"}], ",", 
               RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
              "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
          "}"}], ",", "\[IndentingNewLine]", "SquiggleArrow", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"main", " ", "segment"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"PointList", "=", 
             RowBox[{"SquigglePoints", "[", "\[IndentingNewLine]", 
              RowBox[{"Segment", ",", "\[IndentingNewLine]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ShowTail", "/.", "FullOpts"}], ")"}], ",", 
                    "OptHeadLength", ",", "0"}], "]"}], "+", 
                  RowBox[{"(", 
                   RowBox[{"SquiggleBuffer", "/.", "FullOpts"}], ")"}]}], ",",
                  "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ShowHead", "/.", "FullOpts"}], ")"}], ",", 
                    "OptHeadLength", ",", "0"}], "]"}], "+", 
                  RowBox[{"(", 
                   RowBox[{"SquiggleBuffer", "/.", "FullOpts"}], ")"}]}]}], 
                "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{"OptWidth", "/", "2"}], ",", "\[IndentingNewLine]", 
               RowBox[{"(", 
                RowBox[{"SquiggleWavelength", "/.", "FullOpts"}], ")"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"(", 
                RowBox[{"SquiggleSide", "/.", "FullOpts"}], ")"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"(", 
                RowBox[{"PlotPoints", "/.", "FullOpts"}], ")"}]}], 
              "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"MakeOutline", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"PCOfPA", "/@", "PointList"}], "]"}], "}"}], ",", 
              "FullOpts"}], "]"}]}], " ", ",", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "head", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ShowHead", "/.", "FullOpts"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeOutline", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Line", "[", 
                 RowBox[{"PCOfPA", "/@", 
                  RowBox[{"ArrowHeadPoints", "[", 
                   RowBox[{
                   "Segment", ",", "OptHeadLength", ",", "OptHeadLip"}], 
                   "]"}]}], "]"}], "}"}], ",", 
               RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
              "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "tail", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ShowTail", "/.", "FullOpts"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"MakeOutline", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Line", "[", 
                 RowBox[{"PCOfPA", "/@", 
                  RowBox[{"ArrowHeadPoints", "[", 
                   RowBox[{
                    RowBox[{"Reverse", "@", "Segment"}], ",", "OptHeadLength",
                     ",", "OptHeadLip"}], "]"}]}], "]"}], "}"}], ",", 
               RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
              "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         "ShapeArrow", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"PointList", "=", 
             RowBox[{"Switch", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"TailBevel", "/.", "FullOpts"}], ")"}], ",", 
               "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", 
               " ", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"First", "[", "Segment", "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{"Segment", ",", "AtTail", ",", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"OptWidth", "/", "2"}], ")"}]}]}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{
                  "Segment", ",", "AtLip", ",", "OptHeadLength", ",", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"OptWidth", "/", "2"}], ")"}]}]}], "]"}], ",", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{
                  "Segment", ",", "AtLip", ",", "OptHeadLength", ",", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"OptWidth", "/", "2"}], "+", "OptHeadLip"}], 
                    ")"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"Last", "[", "Segment", "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{
                  "Segment", ",", "AtLip", ",", "OptHeadLength", ",", 
                   RowBox[{"+", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"OptWidth", "/", "2"}], "+", "OptHeadLip"}], 
                    ")"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{
                  "Segment", ",", "AtLip", ",", "OptHeadLength", ",", 
                   RowBox[{"+", 
                    RowBox[{"(", 
                    RowBox[{"OptWidth", "/", "2"}], ")"}]}]}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{"Segment", ",", "AtTail", ",", 
                   RowBox[{"+", 
                    RowBox[{"(", 
                    RowBox[{"OptWidth", "/", "2"}], ")"}]}]}], "]"}]}], 
                "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
               "True", ",", "\[IndentingNewLine]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"First", "[", "Segment", "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{"Segment", ",", "AtTailHorizontal", ",", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"OptWidth", "/", "2"}], ")"}]}]}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{
                  "Segment", ",", "AtLip", ",", "OptHeadLength", ",", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"OptWidth", "/", "2"}], ")"}]}]}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{
                  "Segment", ",", "AtLip", ",", "OptHeadLength", ",", 
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"OptWidth", "/", "2"}], "+", "OptHeadLip"}], 
                    ")"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"Last", "[", "Segment", "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{
                  "Segment", ",", "AtLip", ",", "OptHeadLength", ",", 
                   RowBox[{"+", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"OptWidth", "/", "2"}], "+", "OptHeadLip"}], 
                    ")"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{
                  "Segment", ",", "AtLip", ",", "OptHeadLength", ",", 
                   RowBox[{"+", 
                    RowBox[{"(", 
                    RowBox[{"OptWidth", "/", "2"}], ")"}]}]}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"ArrowPoint", "[", 
                  RowBox[{"Segment", ",", "AtTailHorizontal", ",", 
                   RowBox[{"+", 
                    RowBox[{"(", 
                    RowBox[{"OptWidth", "/", "2"}], ")"}]}]}], "]"}]}], 
                "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"PointList", "=", 
             RowBox[{"Switch", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"ArrowHalf", "/.", "FullOpts"}], ")"}], ",", 
               "\[IndentingNewLine]", "All", ",", "PointList", ",", 
               "\[IndentingNewLine]", "Left", ",", 
               RowBox[{"Take", "[", 
                RowBox[{"PointList", ",", "5"}], "]"}], ",", 
               "\[IndentingNewLine]", "Right", ",", 
               RowBox[{"Take", "[", 
                RowBox[{
                 RowBox[{"RotateLeft", "[", "PointList", "]"}], ",", 
                 RowBox[{"-", "5"}]}], "]"}]}], "\[IndentingNewLine]", 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"ConversionCoeff", "/.", "FullOpts"}], ")"}], "=!=", 
               "None"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"ConversionSideSign", "=", 
                RowBox[{"Switch", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"ConversionSide", "/.", "FullOpts"}], ")"}], ",", 
                  "Left", ",", 
                  RowBox[{"+", "1"}], ",", "Right", ",", 
                  RowBox[{"-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"ConversionWidth", "=", 
                RowBox[{"If", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"ConversionCoeff", "/.", "FullOpts"}], ")"}], "==",
                    "Infinity"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Width", "/.", "FullOpts"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"Width", "*", 
                    RowBox[{"ConversionCoeff", "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "ConversionCoeff"}], ")"}]}]}], ")"}], "/.",
                    "FullOpts"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"Conversiony", "=", 
                RowBox[{"ConversionSideSign", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"ConversionWidth", "-", 
                    RowBox[{"Width", "/", "2"}]}], ")"}], "/.", "FullOpts"}], 
                  ")"}]}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"ConversionP0", "=", 
                RowBox[{"Switch", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"TailBevel", "/.", "FullOpts"}], ")"}], ",", 
                  "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", 
                  
                  RowBox[{"ArrowPoint", "[", 
                   RowBox[{"Segment", ",", "AtTail", ",", "Conversiony"}], 
                   "]"}], ",", "\[IndentingNewLine]", "True", ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"ArrowPoint", "[", 
                   RowBox[{
                   "Segment", ",", "AtTailHorizontal", ",", "Conversiony"}], 
                   "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"ConversionP4", "=", 
                RowBox[{"ArrowPoint", "[", 
                 RowBox[{
                 "Segment", ",", "AtEdge", ",", "OptHeadLength", ",", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"OptWidth", "/", "2"}], "+", "OptHeadLip"}], 
                   ")"}], ",", "Conversiony"}], "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"ConversionPointList", "=", 
                RowBox[{"Switch", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"ConversionSide", "/.", "FullOpts"}], ")"}], ",", 
                  "\[IndentingNewLine]", "Left", ",", "\[IndentingNewLine]", 
                  RowBox[{"Join", "[", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"PointList", "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"(*", " ", 
                    RowBox[{"side", " ", "points"}], " ", "*)"}], 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Conversiony", ">", "0"}], ",", 
                    RowBox[{"PointList", "[", 
                    RowBox[{"[", 
                    RowBox[{"{", "5", "}"}], "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", " ", 
                    RowBox[{"(*", " ", 
                    RowBox[{"optional", ":", " ", "tip"}], " ", "*)"}], 
                    "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"ConversionP4", ",", "ConversionP0"}], "}"}]}], 
                   "  ", 
                   RowBox[{"(*", " ", 
                    RowBox[{"truncated", " ", "side"}], " ", "*)"}], 
                   "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
                  "Right", ",", "\[IndentingNewLine]", 
                  RowBox[{"Join", "[", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"PointList", "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "7", ",", "6"}], "}"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"(*", " ", 
                    RowBox[{"side", " ", "points"}], " ", "*)"}], 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Conversiony", "<", "0"}], ",", 
                    RowBox[{"PointList", "[", 
                    RowBox[{"[", 
                    RowBox[{"{", "5", "}"}], "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", " ", 
                    RowBox[{"(*", " ", 
                    RowBox[{"optional", ":", " ", "tip"}], " ", "*)"}], 
                    "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"ConversionP4", ",", "ConversionP0"}], "}"}]}], 
                   " ", 
                   RowBox[{"(*", " ", 
                    RowBox[{"truncated", " ", "side"}], " ", "*)"}], 
                   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
                 "]"}]}]}]}], "\[IndentingNewLine]", "]"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{"Polygon", "[", 
                RowBox[{"PCOfPA", "/@", "PointList"}], "]"}], 
               "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
              "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"ConversionCoeff", "/.", "FullOpts"}], ")"}], "=!=", 
              "None"}], ",", "\[IndentingNewLine]", 
             RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{"Polygon", "[", 
                 RowBox[{"PCOfPA", "/@", "ConversionPointList"}], "]"}], 
                "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{"FillColor", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"ConversionColor", "/.", "FullOpts"}], ")"}]}], ",", 
               "FullOpts"}], "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{"Line", "[", 
               RowBox[{"PCOfPA", "/@", 
                RowBox[{"(", 
                 RowBox[{"PointList", "~", "Append", "~", 
                  RowBox[{"First", "[", "PointList", "]"}]}], ")"}]}], "]"}], 
              "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
             "FullOpts"}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"make", " ", "labels"}], " ", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"HalfWidthForLabels", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ArrowType", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", "LineArrow", ",", 
         RowBox[{"OptThickness", "/", "2"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MultilineArrow", "|", "SquiggleArrow", "|", "ShapeArrow"}], 
         ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"OptWidth", "+", "OptThickness"}], ")"}], "/", "2"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"TextArt", "=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"LabL", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
             ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"offl", "=", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetL", ",", "\[IndentingNewLine]", 
               RowBox[{"Switch", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}], ",", 
                 "\[IndentingNewLine]", "Automatic", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
                 "Inverted", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
                 "Horizontal", ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
                 "Vertical", ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
                 "_", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}]}], "\[IndentingNewLine]", 
                "]"}], ",", "\[IndentingNewLine]", "FullOpts"}], 
              "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"buffl", "=", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"BufferL", ",", "\[IndentingNewLine]", 
               RowBox[{"Switch", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}], ",", 
                 "\[IndentingNewLine]", "Automatic", ",", "1.1", ",", 
                 "\[IndentingNewLine]", "Inverted", ",", "1.1", ",", 
                 "\[IndentingNewLine]", "Horizontal", ",", "0", ",", 
                 "\[IndentingNewLine]", "Vertical", ",", "0", ",", 
                 "\[IndentingNewLine]", "_", ",", " ", "1.1"}], 
                "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
               "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"SegmentPointsL", "=", 
             RowBox[{"Switch", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"SegmentL", "/.", "FullOpts"}], ")"}], ",", 
               "\[IndentingNewLine]", "Automatic", ",", 
               RowBox[{"AbsSegments", "[", 
                RowBox[{"[", 
                 RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[IndentingNewLine]",
                "_Integer", ",", 
               RowBox[{"AbsSegments", "[", 
                RowBox[{"[", 
                 RowBox[{"(", 
                  RowBox[{"SegmentL", "/.", "FullOpts"}], ")"}], "]"}], 
                "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"PLa", "=", 
             RowBox[{"ArrowPoint", "[", 
              RowBox[{
              "Caller", ",", "SegmentPointsL", ",", "AtUserPosition", ",", 
               RowBox[{"GetAutoOption", "[", 
                RowBox[{"PosnL", ",", "0.5", ",", "FullOpts"}], "]"}], ",", 
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"HalfWidthForLabels", "+", 
                  RowBox[{
                   RowBox[{"buffl", "/", "2"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}]}], 
                 ")"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"MakeText", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"LabL", "/.", "FullOpts"}], ")"}], ",", 
              RowBox[{"PCOfPA", "[", "PLa", "]"}], ",", 
              RowBox[{"SegmentArcTan", "[", "SegmentPointsL", "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ShowText", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Offset", "\[Rule]", "offl"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Nudge", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"NudgeL", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Orientation", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Background", "->", 
               RowBox[{"(", 
                RowBox[{"BackgroundL", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]",
              "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"LabR", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
             ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"offr", "=", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetR", ",", "\[IndentingNewLine]", 
               RowBox[{"Switch", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}], ",", 
                 "\[IndentingNewLine]", "Automatic", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
                 "Inverted", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
                 "Horizontal", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                 "\[IndentingNewLine]", "Vertical", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
                 "_", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}]}], "\[IndentingNewLine]", 
                "]"}], ",", "\[IndentingNewLine]", "FullOpts"}], 
              "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"buffr", "=", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"BufferR", ",", "\[IndentingNewLine]", 
               RowBox[{"Switch", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}], ",", 
                 "\[IndentingNewLine]", "Automatic", ",", "1.1", ",", 
                 "\[IndentingNewLine]", "Inverted", ",", "1.1", ",", 
                 "\[IndentingNewLine]", "Horizontal", ",", "0", ",", 
                 "\[IndentingNewLine]", "Vertical", ",", "0", ",", 
                 "\[IndentingNewLine]", "_", ",", " ", "1.1"}], 
                "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
               "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"SegmentPointsR", "=", 
             RowBox[{"Switch", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"SegmentR", "/.", "FullOpts"}], ")"}], ",", 
               "\[IndentingNewLine]", "Automatic", ",", 
               RowBox[{"AbsSegments", "[", 
                RowBox[{"[", 
                 RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[IndentingNewLine]",
                "_Integer", ",", 
               RowBox[{"AbsSegments", "[", 
                RowBox[{"[", 
                 RowBox[{"(", 
                  RowBox[{"SegmentR", "/.", "FullOpts"}], ")"}], "]"}], 
                "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"PRa", "=", 
             RowBox[{"ArrowPoint", "[", 
              RowBox[{
              "Caller", ",", "SegmentPointsR", ",", "AtUserPosition", ",", 
               RowBox[{"GetAutoOption", "[", 
                RowBox[{"PosnR", ",", "0.5", ",", "FullOpts"}], "]"}], ",", 
               RowBox[{"+", 
                RowBox[{"(", 
                 RowBox[{"HalfWidthForLabels", "+", 
                  RowBox[{
                   RowBox[{"buffr", "/", "2"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}]}], 
                 ")"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"MakeText", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"LabR", "/.", "FullOpts"}], ")"}], ",", " ", 
              RowBox[{"PCOfPA", "[", "PRa", "]"}], ",", 
              RowBox[{"SegmentArcTan", "[", "SegmentPointsR", "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ShowText", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Offset", "\[Rule]", "offr"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Nudge", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"NudgeR", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Orientation", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Background", "->", 
               RowBox[{"(", 
                RowBox[{"BackgroundR", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]",
              "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"LabC", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
             ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"offc", "=", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetC", ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
               "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"SegmentPointsC", "=", 
             RowBox[{"Switch", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"SegmentC", "/.", "FullOpts"}], ")"}], ",", 
               "\[IndentingNewLine]", "Automatic", ",", 
               RowBox[{"AbsSegments", "[", 
                RowBox[{"[", 
                 RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[IndentingNewLine]",
                "_Integer", ",", 
               RowBox[{"AbsSegments", "[", 
                RowBox[{"[", 
                 RowBox[{"(", 
                  RowBox[{"SegmentC", "/.", "FullOpts"}], ")"}], "]"}], 
                "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"PCa", "=", 
             RowBox[{"ArrowPoint", "[", 
              RowBox[{
              "Caller", ",", "SegmentPointsC", ",", "AtUserPosition", ",", 
               RowBox[{"GetAutoOption", "[", 
                RowBox[{"PosnC", ",", "0.5", ",", "FullOpts"}], "]"}], ",", 
               "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"MakeText", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"LabC", "/.", "FullOpts"}], ")"}], ",", " ", 
              RowBox[{"PCOfPA", "[", "PCa", "]"}], ",", 
              RowBox[{"SegmentArcTan", "[", "SegmentPointsC", "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ShowText", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Offset", "\[Rule]", "offc"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Nudge", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"NudgeC", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Orientation", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"OrientationC", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Background", "->", 
               RowBox[{"(", 
                RowBox[{"BackgroundC", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]",
              "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"LabT", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
             ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"SegmentPointsT", "=", 
             RowBox[{"AbsSegments", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"PTa", "=", 
             RowBox[{"ArrowPoint", "[", 
              RowBox[{
              "Caller", ",", "SegmentPointsT", ",", "AtUserPosition", ",", 
               RowBox[{"GetAutoOption", "[", 
                RowBox[{"PosnT", ",", "0", ",", "FullOpts"}], "]"}], ",", 
               "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "calculate", " ", "orientation", " ", "and", " ", "offset", " ", 
              "information", " ", "for", " ", "\"\<Automatic\>\"", " ", 
              "label"}], " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{"pre", "-", 
               RowBox[{"6", " ", 
                RowBox[{"rotation", ":", " ", 
                 RowBox[{
                 "reference", " ", "point", " ", "is", " ", "of", " ", 
                  "rotated", " ", "box"}]}]}]}], ",", " ", 
              RowBox[{
               RowBox[{"defaults", " ", "were", " ", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "1"}]}], "}"}], " ", "\[IndentingNewLine]", 
                "post"}], "-", 
               RowBox[{"6", " ", 
                RowBox[{"rotation", ":", " ", 
                 RowBox[{
                 "reference", " ", "point", " ", "is", " ", "of", " ", 
                  "origintal", " ", "box"}]}]}]}]}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"theta0", "=", 
             RowBox[{"SegmentArcTan", "[", "SegmentPointsT", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"InversionSign", "=", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "Pi"}], "/", "2"}], "<", "theta0"}], ")"}], "&&", 
                RowBox[{"(", 
                 RowBox[{"theta0", "<=", 
                  RowBox[{"Pi", "/", "2"}]}], ")"}]}], ",", 
               RowBox[{"+", "1"}], ",", 
               RowBox[{"-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"offt", "=", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetT", ",", "\[IndentingNewLine]", 
               RowBox[{"Switch", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}], ",", 
                 "\[IndentingNewLine]", "Automatic", ",", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"1", ",", "0"}], "}"}], "*", "InversionSign"}], 
                 ",", "\[IndentingNewLine]", "Inverted", ",", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"{", 
                    RowBox[{"1", ",", "0"}], "}"}]}], "*", "InversionSign"}], 
                 ",", "\[IndentingNewLine]", "Horizontal", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
                 "Vertical", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                 "\[IndentingNewLine]", "_", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}]}], "\[IndentingNewLine]", 
                "]"}], ",", "\[IndentingNewLine]", "FullOpts"}], 
              "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"MakeText", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"LabT", "/.", "FullOpts"}], ")"}], ",", " ", 
              RowBox[{"PCOfPA", "[", "PTa", "]"}], ",", "theta0", ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ShowText", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Offset", "\[Rule]", "offt"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Nudge", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"NudgeT", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Orientation", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Background", "->", 
               RowBox[{"(", 
                RowBox[{"BackgroundT", "/.", "FullOpts"}], ")"}]}], ",", 
              "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]",
              "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"return", " ", "completed", " ", "artwork"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{"LineArt", ",", "TextArt"}], "]"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQzdCgdKrA56UjQ0PweTDN8HKJ2V8Q/8R6CJ20BUwz
hOyA8NcdgdDWxyHicVPtuV4B+cshNAP3UgjfGkIzqO6A0E93Quisf4d4QfRZ
CN2wh+cwmL9XBkLzJUDo2gww3RCWA6FFmiDib1sh9B8ozdkNoYP7IHTlJgj9
cDNE3xm1I2D+P3UIvSECTDfYR0PoyAQIXZQGok8v9DNMlQfSijMh9MKbQRD+
rVgQDQCIAX58
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Level objects", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Lev", "[", 
    RowBox[{
     RowBox[{"ID_:", "None"}], ",", 
     RowBox[{"xa0_", "?", "NumericQ"}], ",", 
     RowBox[{"xb0_", "?", "NumericQ"}], ",", 
     RowBox[{"EnergyStr", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], "|", "_String"}], ")"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"Lev", ",", "Opts"}], "]"}]}], ",", "\[IndentingNewLine]", 
       "WingRiseWidthL", ",", "WingRiseWidthR", ",", "\[IndentingNewLine]", 
       "WingTipWidthL", ",", "WingTipWidthR", ",", "\[IndentingNewLine]", 
       "DefaultLabel", ",", "\[IndentingNewLine]", "PointList", ",", 
       "\[IndentingNewLine]", "DerivedEnergyLabelFunction", ",", 
       "\[IndentingNewLine]", "IDExpr", ",", "\[IndentingNewLine]", 
       "ObjectTag"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckValue", "[", 
       RowBox[{"ID", ",", 
        RowBox[{"IDExpr_", "?", "LevelIdentifierQ"}], ",", 
        "\"\<a level identifier symbol (cannot be list or number)\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"EnergyNudge", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"WingHeight", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"WingRiseWidth", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"WingTipWidth", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"MakeWingL", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"MakeWingR", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"label", " ", "validation"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowLabL", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowLabR", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowLabT", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowLabB", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowLabC", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"DecimalDigits", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_Integer", "?", "NonNegative"}], ")"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_Integer", "?", "NonNegative"}], ",", 
           RowBox[{"_Integer", "?", "NonNegative"}]}], "}"}]}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Store", " ", "level", " ", "parameters"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ObjectTag", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ID", "=!=", "None"}], ",", "\[IndentingNewLine]", "ID", ",",
          "\[IndentingNewLine]", 
         RowBox[{"(", 
          RowBox[{"Tag", "/.", "FullOpts"}], ")"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"$LastLevel", "=", "ObjectTag"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`xa0", "[", "ObjectTag", "]"}], "=", 
       RowBox[{"XCOfXU", "[", "xa0", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`xb0", "[", "ObjectTag", "]"}], "=", 
       RowBox[{"XCOfXU", "[", "xb0", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], "=", " ", 
       RowBox[{"XCOfXU", "[", 
        RowBox[{"xa0", "+", 
         RowBox[{"(", 
          RowBox[{"Margin", "/.", "FullOpts"}], ")"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}], "=", " ", 
       RowBox[{"XCOfXU", "[", 
        RowBox[{"xb0", "-", 
         RowBox[{"(", 
          RowBox[{"Margin", "/.", "FullOpts"}], ")"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`UserEnergy", "[", "ObjectTag", "]"}], "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"EnergyStr", ",", "\[IndentingNewLine]", 
         RowBox[{"_", "?", "NumericQ"}], ",", "EnergyStr", ",", 
         "\[IndentingNewLine]", "_String", ",", 
         RowBox[{"ToExpression", "[", "EnergyStr", "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"NumericQ", "[", 
          RowBox[{"LevelScheme`Data`UserEnergy", "[", "ObjectTag", "]"}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"Lev", "::", "energystr"}], ",", "ObjectTag", ",", 
          "EnergyStr"}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`Energy", "[", "ObjectTag", "]"}], " ", "=", 
       " ", 
       RowBox[{
        RowBox[{"YCOfYU", "[", 
         RowBox[{"LevelScheme`Data`UserEnergy", "[", "ObjectTag", "]"}], 
         "]"}], "+", 
        RowBox[{"DYCOfYA", "[", 
         RowBox[{"EnergyNudge", "/.", "FullOpts"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`WingEnergy", "[", "ObjectTag", "]"}], " ", 
       "=", 
       RowBox[{
        RowBox[{"LevelScheme`Data`Energy", "[", "ObjectTag", "]"}], "+", 
        RowBox[{"DYCOfYA", "[", 
         RowBox[{"WingHeight", "/.", "FullOpts"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Outline", " ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"WingRiseWidthL", ",", "WingRiseWidthR"}], "}"}], "=", 
          RowBox[{"UpgradeScalarXY", "[", 
           RowBox[{"WingRiseWidth", "/.", "FullOpts"}], "]"}]}], ";", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"WingTipWidthL", ",", "WingTipWidthR"}], "}"}], "=", 
          RowBox[{"UpgradeScalarXY", "[", 
           RowBox[{"WingTipWidth", "/.", "FullOpts"}], "]"}]}], ";", 
         RowBox[{"PointList", "=", 
          RowBox[{"Join", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"MakeWingL", "/.", "FullOpts"}], ")"}], "&&", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"WingHeight", "/.", "FullOpts"}], ")"}], "=!=", 
                "0"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"LevelScheme`Data`EnergyL", "[", "ObjectTag", "]"}], 
                "=", 
                RowBox[{
                "LevelScheme`Data`WingEnergy", "[", "ObjectTag", "]"}]}], ";",
                "\[IndentingNewLine]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], 
                   " ", ",", 
                   RowBox[{
                   "LevelScheme`Data`WingEnergy", "[", "ObjectTag", "]"}]}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], 
                    "+", 
                    RowBox[{"DXCOfXA", "[", "WingTipWidthL", "]"}]}], " ", 
                   ",", 
                   RowBox[{
                   "LevelScheme`Data`WingEnergy", "[", "ObjectTag", "]"}]}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], 
                    "+", 
                    RowBox[{"DXCOfXA", "[", "WingTipWidthL", "]"}], " ", "+", 
                    
                    RowBox[{"DXCOfXA", "[", "WingRiseWidthL", "]"}]}], " ", 
                   ",", 
                   RowBox[{
                   "LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], 
                  "}"}]}], "\[IndentingNewLine]", "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"LevelScheme`Data`EnergyL", "[", "ObjectTag", "]"}], 
                "=", 
                RowBox[{"LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], 
               ";", "\[IndentingNewLine]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], " ",
                   ",", 
                  RowBox[{
                  "LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], "}"}],
                 "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"MakeWingR", "/.", "FullOpts"}], ")"}], "&&", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"WingHeight", "/.", "FullOpts"}], ")"}], "=!=", 
                "0"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"LevelScheme`Data`EnergyR", "[", "ObjectTag", "]"}], 
                "=", 
                RowBox[{
                "LevelScheme`Data`WingEnergy", "[", "ObjectTag", "]"}]}], ";",
                "\[IndentingNewLine]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}], 
                    "-", 
                    RowBox[{"DXCOfXA", "[", "WingTipWidthR", "]"}], " ", "-", 
                    
                    RowBox[{"DXCOfXA", "[", "WingRiseWidthR", "]"}]}], " ", 
                   ",", 
                   RowBox[{
                   "LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}], 
                    "-", 
                    RowBox[{"DXCOfXA", "[", "WingTipWidthR", "]"}]}], " ", 
                   ",", 
                   RowBox[{
                   "LevelScheme`Data`WingEnergy", "[", "ObjectTag", "]"}]}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}], 
                   ",", 
                   RowBox[{
                   "LevelScheme`Data`WingEnergy", "[", "ObjectTag", "]"}]}], 
                  "}"}]}], "\[IndentingNewLine]", "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"LevelScheme`Data`EnergyR", "[", "ObjectTag", "]"}], 
                "=", 
                RowBox[{"LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], 
               ";", "\[IndentingNewLine]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}], " ",
                   ",", 
                  RowBox[{
                  "LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], "}"}],
                 "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", 
             "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{"Line", "[", "PointList", "]"}], "\[IndentingNewLine]", 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"LineToFront", "/.", "FullOpts"}], ")"}], ",", 
             RowBox[{"Layer", "\[Rule]", "$SchemeTextLayer"}], ",", 
             RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
           "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "Labels", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"energy", " ", "label", " ", 
           RowBox[{"priority", ":", " ", 
            RowBox[{
             RowBox[{"(", "1", ")"}], " ", "string"}]}]}], ",", " ", 
          RowBox[{
           RowBox[{"(", "2", ")"}], " ", "specified", " ", "function"}], ",", 
          " ", 
          RowBox[{
           RowBox[{"(", "3", ")"}], " ", "specified", " ", "decimal", " ", 
           "digits"}], ",", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"(", "4", ")"}], " ", "pass"}], "-", "through"}]}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"DerivedEnergyLabelFunction", "=", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"EnergyLabelFunction", "/.", "FullOpts"}], ")"}], "===",
              "Automatic"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"DecimalDigits", "/.", "FullOpts"}], ")"}], "===", 
               "Automatic"}], ",", "\[IndentingNewLine]", "Identity", ",", 
              "\[IndentingNewLine]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"FixedPointForm", "[", 
                 RowBox[{"#", ",", 
                  RowBox[{"(", 
                   RowBox[{"DecimalDigits", "/.", "FullOpts"}], ")"}]}], 
                 "]"}], "&"}], ")"}]}], "\[IndentingNewLine]", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{"EnergyLabelFunction", "/.", "FullOpts"}], ")"}]}], 
           "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"DefaultLabel", "=", 
          RowBox[{"Switch", "[", "\[IndentingNewLine]", 
           RowBox[{
           "EnergyStr", ",", "\[IndentingNewLine]", "_String", ",", 
            "EnergyStr", ",", "\[IndentingNewLine]", 
            RowBox[{"_", "?", "NumericQ"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"DerivedEnergyLabelFunction", "/.", "FullOpts"}], ")"}],
              "@", "EnergyStr"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"MakeText", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"LabL", ",", "DefaultLabel", ",", "FullOpts"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], ",", 
             RowBox[{"LevelScheme`Data`EnergyL", "[", "ObjectTag", "]"}]}], 
            "}"}], ",", "\[IndentingNewLine]", "0", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ShowText", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Offset", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"OffsetL", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", 
                RowBox[{"-", ".75"}]}], "}"}], ",", "FullOpts"}], "]"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Nudge", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"NudgeL", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Orientation", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"OrientationL", ",", "Horizontal", ",", "FullOpts"}], 
             "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"BackgroundL", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
          "]"}]}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"LabC", ",", "DefaultLabel", ",", "FullOpts"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], "+", 
               RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}]}], 
              ")"}], "/", "2"}], ",", 
            RowBox[{"LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetC", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", ".75"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OrientationC", ",", "Horizontal", ",", "FullOpts"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Background", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"BackgroundC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"LabR", ",", "DefaultLabel", ",", "FullOpts"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}], ",", 
            RowBox[{"LevelScheme`Data`EnergyR", "[", "ObjectTag", "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetR", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"+", "1"}], ",", 
               RowBox[{"-", ".75"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OrientationR", ",", "Horizontal", ",", "FullOpts"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Background", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"BackgroundR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"LabT", ",", "DefaultLabel", ",", "FullOpts"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], "+", 
               RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}]}], 
              ")"}], "/", "2"}], ",", 
            RowBox[{"LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetT", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", ".75"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OrientationT", ",", "Horizontal", ",", "FullOpts"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Background", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"BackgroundT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"LabB", ",", "DefaultLabel", ",", "FullOpts"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"LevelScheme`Data`xa", "[", "ObjectTag", "]"}], "+", 
               RowBox[{"LevelScheme`Data`xb", "[", "ObjectTag", "]"}]}], 
              ")"}], "/", "2"}], ",", 
            RowBox[{"LevelScheme`Data`Energy", "[", "ObjectTag", "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetB", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"+", "1.0"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OrientationB", ",", "Horizontal", ",", "FullOpts"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Background", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"BackgroundB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.420660524265625*^9, {3.42066082175*^9, 3.4206608221875*^9}, {
   3.4262612698125*^9, 3.42626142590625*^9}, {3.42626156065625*^9, 
   3.4262615839375*^9}, {3.42626167396875*^9, 3.426261688265625*^9}, {
   3.49226532834375*^9, 3.492265477828125*^9}, {3.492265513234375*^9, 
   3.492265513734375*^9}, {3.4922655990625*^9, 3.4922656058125*^9}, {
   3.492265637671875*^9, 3.49226564125*^9}, {3.496055245453125*^9, 
   3.49605524584375*^9}, {3.496055360296875*^9, 3.4960553645*^9}, 
   3.49605546371875*^9, {3.496056042828125*^9, 3.496056096828125*^9}, {
   3.496057226765625*^9, 3.49605743965625*^9}, {3.4960575211875*^9, 
   3.4960575223125*^9}, {3.512325064234375*^9, 3.51232506740625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LastLevel", ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      "$LastLevel"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelEnergy", "[", 
    RowBox[{"ID_", "?", "LevelIdentifierQ"}], "]"}], " ", ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "ID", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Data`UserEnergy", "[", "ID", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicExtensionLine", "[", 
    RowBox[{
     RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", "x1_", ",", "x2_", ",", 
     "FullOpts_List"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "ID", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ToWing", "/.", "FullOpts"}], ")"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", 
                 RowBox[{"LevelScheme`Data`WingEnergy", "[", "ID", "]"}]}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"x2", ",", 
                 RowBox[{"LevelScheme`Data`WingEnergy", "[", "ID", "]"}]}], 
                "}"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", 
                 RowBox[{"LevelScheme`Data`Energy", "[", "ID", "]"}]}], "}"}],
                ",", 
               RowBox[{"{", 
                RowBox[{"x2", ",", 
                 RowBox[{"LevelScheme`Data`Energy", "[", "ID", "]"}]}], 
                "}"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", "]"}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         "FullOpts"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtensionLine", "[", 
    RowBox[{
     RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Posn1_", "?", "NumericQ"}], ",", 
     RowBox[{"Posn2_", "?", "NumericQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", 
   RowBox[{"BasicExtensionLine", "[", 
    RowBox[{"ID", ",", 
     RowBox[{
      RowBox[{"LevelScheme`Data`xa0", "[", "ID", "]"}], " ", "+", 
      RowBox[{"DXCOfXU", "[", "Posn1", "]"}]}], ",", 
     RowBox[{
      RowBox[{"LevelScheme`Data`xa0", "[", "ID", "]"}], " ", "+", 
      RowBox[{"DXCOfXU", "[", "Posn2", "]"}]}], ",", 
     RowBox[{"FigRealizeOptions", "[", 
      RowBox[{"ExtensionLine", ",", "Opts"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtensionLine", "[", 
    RowBox[{
     RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", "Left", ",", "Length_", 
     ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"BasicExtensionLine", "[", 
    RowBox[{"ID", ",", 
     RowBox[{
      RowBox[{"LevelScheme`Data`xa", "[", "ID", "]"}], "-", 
      RowBox[{"DXCOfXU", "[", "Length", "]"}]}], ",", 
     RowBox[{"LevelScheme`Data`xa", "[", "ID", "]"}], ",", 
     RowBox[{"FigRealizeOptions", "[", 
      RowBox[{"ExtensionLine", ",", "Opts"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtensionLine", "[", 
    RowBox[{
     RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", "Right", ",", "Length_", 
     ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"BasicExtensionLine", "[", 
    RowBox[{"ID", ",", 
     RowBox[{"LevelScheme`Data`xb", "[", "ID", "]"}], ",", 
     RowBox[{
      RowBox[{"LevelScheme`Data`xb", "[", "ID", "]"}], "+", 
      RowBox[{"DXCOfXU", "[", "Length", "]"}]}], ",", 
     RowBox[{"FigRealizeOptions", "[", 
      RowBox[{"ExtensionLine", ",", "Opts"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49605569803125*^9, 3.496055698125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Connector", "[", 
    RowBox[{
     RowBox[{"IDi_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"IDf_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"Connector", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDi", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDf", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"LevelScheme`Data`xb", "[", "IDi", "]"}], ",", 
              RowBox[{"LevelScheme`Data`EnergyR", "[", "IDi", "]"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"LevelScheme`Data`xa", "[", "IDf", "]"}], ",", 
              RowBox[{"LevelScheme`Data`EnergyL", "[", "IDf", "]"}]}], 
             "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", "}"}], ",", 
        "\[IndentingNewLine]", "FullOpts"}], "\[IndentingNewLine]", "]"}]}]}],
     "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.496055698171875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transition arrows", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArrowNodeQ", "[", "P_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"P", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}], "|", 
      RowBox[{"FromHead", "[", 
       RowBox[{"_", "?", "DoubleRadiusQ"}], "]"}], "|", 
      RowBox[{"FromTail", "[", 
       RowBox[{"_", "?", "DoubleRadiusQ"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Trans", "[", 
    RowBox[{
     RowBox[{"RawNodes", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PI", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "ArrowNodeQ"}], ")"}], "..."}], ",", 
        RowBox[{"Pf", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"Trans", ",", "Opts"}], "]"}]}], ",", "\[IndentingNewLine]", 
       "Nodes", ",", "R", ",", "P"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Kink", ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Nodes", "=", 
       RowBox[{"Replace", "[", "\[IndentingNewLine]", 
        RowBox[{"RawNodes", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"P", ":", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ":>", 
            RowBox[{"PCOfPU", "@", "P"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"FromHead", "[", "R_", "]"}], "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"PCOfPU", "@", "Pf"}], "+", 
              RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ")"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"FromTail", "[", "R_", "]"}], "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"PCOfPU", "@", "PI"}], "+", 
              RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ")"}]}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", "1"}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BasicArrow", "[", 
       RowBox[{"Trans", ",", "Nodes", ",", "FullOpts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Trans", "[", 
    RowBox[{
     RowBox[{"PI", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"Pf", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"Trans", ",", "Opts"}], "]"}]}], ",", "\[IndentingNewLine]", 
       "RawNodes", ",", "Nodes", ",", "R", ",", "P"}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Kink", ",", 
        RowBox[{"None", "|", 
         RowBox[{"_", "?", "ArrowNodeQ"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"_", "?", "ArrowNodeQ"}], ")"}], "..."}], "}"}]}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"RawNodes", "=", 
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "PI", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Switch", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Kink", "/.", "FullOpts"}], ")"}], ",", 
           "\[IndentingNewLine]", "None", ",", 
           RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"_", "?", "ArrowNodeQ"}], ",", 
           RowBox[{"{", 
            RowBox[{"(", 
             RowBox[{"Kink", "/.", "FullOpts"}], ")"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"_", "?", "ArrowNodeQ"}], ")"}], "..."}], "}"}], ",", 
           RowBox[{"(", 
            RowBox[{"Kink", "/.", "FullOpts"}], ")"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", "Pf", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Nodes", "=", 
       RowBox[{"Replace", "[", "\[IndentingNewLine]", 
        RowBox[{"RawNodes", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"P", ":", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ":>", 
            RowBox[{"PCOfPU", "@", "P"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"FromHead", "[", "R_", "]"}], "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"PCOfPU", "@", "Pf"}], "+", 
              RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ")"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"FromTail", "[", "R_", "]"}], "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"PCOfPU", "@", "PI"}], "+", 
              RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ")"}]}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", "1"}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BasicArrow", "[", 
       RowBox[{"Trans", ",", "Nodes", ",", "FullOpts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Trans", "[", 
    RowBox[{
     RowBox[{"IDi_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"IDf_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"Trans", ",", "Opts"}], "]"}]}], ",", "\[IndentingNewLine]", 
       "xi", ",", "yi", ",", "xf", ",", "yf", ",", "\[IndentingNewLine]", 
       "PI", ",", "Pf", ",", "\[IndentingNewLine]", "Posni", ",", "Posnf"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"EndPositions", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"_", "?", "NumericQ"}], "|", "Automatic"}], ")"}], ",", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"_", "?", "NumericQ"}], "|", "Automatic"}], ")"}]}], 
         "}"}], ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDi", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDf", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Posni", ",", "Posnf"}], "}"}], "=", 
       RowBox[{"(", 
        RowBox[{"EndPositions", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Calculate", " ", "start"}], ",", " ", "end", ",", " ", 
        RowBox[{"and", " ", "optional", " ", "kink", " ", "points"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "PI", " ", "and", " ", "Pf", " ", "are", " ", "distance", " ", "in", 
        " ", "band", " ", "units", " ", "from", " ", "left", " ", "origin", 
        " ", "of", " ", "band"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xi", ",", "xf"}], "}"}], "=", 
       RowBox[{"Which", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Posni", "=!=", "Automatic"}], ")"}], "&&", 
          RowBox[{"(", 
           RowBox[{"Posnf", "=!=", "Automatic"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"LevelScheme`Data`xa0", "[", "IDi", "]"}], ",", 
            RowBox[{"LevelScheme`Data`xa0", "[", "IDf", "]"}]}], "}"}], "+", 
          RowBox[{"DXCOfXU", "/@", 
           RowBox[{"{", 
            RowBox[{"Posni", ",", "Posnf"}], "}"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Posni", "=!=", "Automatic"}], ")"}], "&&", 
          RowBox[{"(", 
           RowBox[{"Posnf", "===", "Automatic"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"LevelScheme`Data`xa0", "[", "IDi", "]"}], ",", 
            RowBox[{"LevelScheme`Data`xa0", "[", "IDi", "]"}]}], "}"}], "+", 
          RowBox[{"DXCOfXU", "/@", 
           RowBox[{"{", 
            RowBox[{"Posni", ",", "Posni"}], "}"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Posni", "===", "Automatic"}], ")"}], "&&", 
          RowBox[{"(", 
           RowBox[{"Posnf", "=!=", "Automatic"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"LevelScheme`Data`xa0", "[", "IDf", "]"}], ",", 
            RowBox[{"LevelScheme`Data`xa0", "[", "IDf", "]"}]}], "}"}], "+", 
          RowBox[{"DXCOfXU", "/@", 
           RowBox[{"{", 
            RowBox[{"Posnf", ",", "Posnf"}], "}"}]}]}], ",", 
         "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
         RowBox[{"ErrorMessage", "[", 
          RowBox[{"Trans", "::", "twoautos"}], "]"}]}], "\[IndentingNewLine]",
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"yi", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"FromWing", "/.", "FullOpts"}], ",", 
         RowBox[{"LevelScheme`Data`WingEnergy", "[", "IDi", "]"}], ",", 
         RowBox[{"LevelScheme`Data`Energy", "[", "IDi", "]"}]}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"yf", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ToWing", "/.", "FullOpts"}], ",", 
         RowBox[{"LevelScheme`Data`WingEnergy", "[", "IDf", "]"}], ",", 
         RowBox[{"LevelScheme`Data`Energy", "[", "IDf", "]"}]}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"PI", "=", 
       RowBox[{"{", 
        RowBox[{"xi", ",", "yi"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Pf", "=", 
       RowBox[{"{", 
        RowBox[{"xf", ",", "yf"}], "}"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{
        RowBox[{"PUOfPC", "@", "PI"}], ",", 
        RowBox[{"PUOfPC", "@", "Pf"}], ",", "FullOpts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Trans", "[", 
    RowBox[{
     RowBox[{"IDi_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Posni", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], "|", "Automatic"}], ")"}]}], ",", 
     RowBox[{"IDf_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Posnf", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], "|", "Automatic"}], ")"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Trans", "[", 
    RowBox[{"IDi", ",", "IDf", ",", 
     RowBox[{"EndPositions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Posni", ",", "Posnf"}], "}"}]}], ",", "Opts"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.496055698203125*^9, 3.49605569825*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Label primatives", "Subsection"],

Cell["\<\
User-level label command must construct FullOpts from user and default \
options and must provide an explicit numerical value for option Offset\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicLabel", "[", 
    RowBox[{"P_", ",", "Contents_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", "Opts", "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"MakeText", "[", 
      RowBox[{"Contents", ",", "P", ",", "0", ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"pass", " ", "on", " ", "ShowText"}], ",", " ", "Offset", 
         ",", " ", "Nudge", ",", " ", "Orientation", ",", " ", "Background", 
         ",", " ", 
         RowBox[{"font", " ", "style", " ", "parameters"}], ",", " ", 
         RowBox[{"and", " ", "Layer", " ", "from", " ", "FullOpts"}]}], 
        "*)"}], "\[IndentingNewLine]", "FullOpts"}], " ", 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ManualLabel", "[", 
     RowBox[{"P_", ",", "Contents_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"ManualLabel", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]",
        "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"BasicLabel", "[", 
        RowBox[{
         RowBox[{"PCOfPU", "[", "P", "]"}], ",", "Contents", ",", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"Offset", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
         "FullOpts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "   "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.496055698265625*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BandLabel", "[", 
     RowBox[{
      RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", "Contents_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"BandLabel", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckLevel", "[", "ID", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"BasicLabel", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LevelScheme`Data`xa", "[", "ID", "]"}], "+", 
              RowBox[{"LevelScheme`Data`xb", "[", "ID", "]"}]}], ")"}], "/", 
            "2"}], ",", 
           RowBox[{"LevelScheme`Data`Energy", "[", "ID", "]"}]}], "}"}], ",", 
         "Contents", ",", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"Offset", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"+", "1"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
         "FullOpts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BandLabel", "[", 
     RowBox[{
      RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", 
      RowBox[{"Posn_", "?", "NumericQ"}], ",", "Contents_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"BandLabel", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckLevel", "[", "ID", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"BasicLabel", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"LevelScheme`Data`xa0", "[", "ID", "]"}], "+", 
            RowBox[{"DXCOfXU", "[", "Posn", "]"}]}], ",", 
           RowBox[{"LevelScheme`Data`Energy", "[", "ID", "]"}]}], "}"}], ",", 
         "Contents", ",", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"Offset", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"+", "1"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
         "FullOpts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ScaledLabel", "[", 
    RowBox[{"Pr_", ",", "Contents_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"ScaledLabel", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"BasicLabel", "[", 
       RowBox[{
        RowBox[{"PCOfPS", "[", "Pr", "]"}], ",", "Contents", ",", 
        RowBox[{"Offset", "\[Rule]", 
         RowBox[{"GetAutoOption", "[", 
          RowBox[{"Offset", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
        "FullOpts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49605569828125*^9, 3.496055698296875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicLevelLabel", "[", 
    RowBox[{
     RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Posn", ":", 
      RowBox[{"(", 
       RowBox[{"Left", "|", "Right"}], ")"}]}], ",", "Contents_", ",", 
     "FullOpts_List"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "P0", ",", "P1", ",", "P2", ",", "PLabel", ",", "Sense", ",", 
       "NeedLine", ",", "GapValues"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"CallOutVector", ",", 
        RowBox[{"None", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Gap", ",", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"side", " ", "options"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Sense", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"Posn", ",", "Left", ",", 
         RowBox[{"-", "1"}], ",", "Right", ",", 
         RowBox[{"+", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"P0", " ", "=", " ", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "Posn", ",", "\[IndentingNewLine]", "Left", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"LevelScheme`Data`xa", "[", "ID", "]"}], ",", 
           RowBox[{"LevelScheme`Data`EnergyL", "[", "ID", "]"}]}], "}"}], ",",
          "\[IndentingNewLine]", "Right", ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"LevelScheme`Data`xb", "[", "ID", "]"}], ",", 
           RowBox[{"LevelScheme`Data`EnergyR", "[", "ID", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"GapValues", "=", 
       RowBox[{"UpgradeScalarXY", "[", 
        RowBox[{"Gap", "/.", "FullOpts"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"call", "-", 
        RowBox[{"out", " ", "options"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"NeedLine", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"CallOutVector", "/.", "FullOpts"}], ")"}], "=!=", 
        "None"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"point", " ", "computation"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"NeedLine", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"P1", " ", "=", 
          RowBox[{"P0", "+", 
           RowBox[{"Sense", "*", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"DXCOfXA", " ", "@", 
               RowBox[{"GapValues", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", "0"}], "}"}]}]}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"P2", " ", "=", 
          RowBox[{"P1", "+", 
           RowBox[{"DPCOfPA", "@", 
            RowBox[{"(", 
             RowBox[{"CallOutVector", "/.", "FullOpts"}], ")"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"PLabel", " ", "=", 
          RowBox[{"P2", "+", 
           RowBox[{"Sense", "*", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"DXCOfXA", " ", "@", 
               RowBox[{"GapValues", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", "0"}], "}"}]}]}]}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"PLabel", "=", 
         RowBox[{"P0", "+", 
          RowBox[{"Sense", "*", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"DXCOfXA", " ", "@", 
              RowBox[{"GapValues", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ",", "0"}], "}"}]}]}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Optional", " ", "call"}], "-", 
         RowBox[{"out", " ", "line"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"NeedLine", ",", "\[IndentingNewLine]", 
          RowBox[{"MakeOutline", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"P1", ",", "P2"}], "}"}], "]"}], "}"}], ",", 
            "FullOpts"}], "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "Label", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"BasicLabel", "[", 
         RowBox[{"PLabel", ",", "Contents", ",", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"Offset", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "Sense"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
            "]"}]}], ",", "FullOpts"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BasicLevelLabel", "[", 
    RowBox[{
     RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Posn", ":", 
      RowBox[{"(", 
       RowBox[{"Bottom", "|", "Top"}], ")"}]}], ",", "Contents_", ",", 
     "FullOpts_List"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "P0", ",", "P1", ",", "P2", ",", "PLabel", ",", "Sense", ",", 
       "NeedLine", ",", "GapValues"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"CallOutVector", ",", 
        RowBox[{"None", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Gap", ",", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Sense", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"Posn", ",", "Bottom", ",", 
         RowBox[{"-", "1"}], ",", "Top", ",", 
         RowBox[{"+", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Label", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"BasicLabel", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LevelScheme`Data`xa", "[", "ID", "]"}], "+", 
              RowBox[{"LevelScheme`Data`xb", "[", "ID", "]"}]}], ")"}], "/", 
            "2"}], ",", 
           RowBox[{"LevelScheme`Data`Energy", "[", "ID", "]"}]}], "}"}], ",", 
         "Contents", ",", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"Offset", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "Sense"}]}], "}"}], ",", "FullOpts"}], "]"}]}], 
         ",", "FullOpts"}], "]"}], "\[IndentingNewLine]", "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LevelLabel", "[", 
    RowBox[{
     RowBox[{"ID_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Posn", ":", 
      RowBox[{"(", 
       RowBox[{"Left", "|", "Right", "|", "Top", "|", "Bottom"}], ")"}]}], 
     ",", "Contents_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"LevelLabel", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "ID", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"BasicLevelLabel", "[", 
       RowBox[{"ID", ",", "Posn", ",", "Contents", ",", "FullOpts"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.488200776484375*^9, 3.488200844375*^9}, {
   3.48820092925*^9, 3.488200968*^9}, 3.496055698328125*^9}],

Cell["\<\
3D label
\tRespects only those options recognized by MakeText3D, produces graphics \
primatives (rather than SchemeGraphics)\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicLabel3D", "[", 
    RowBox[{"P_", ",", "Contents_", ",", "FullOpts_List"}], "]"}], " ", ":=", 
   " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"MakeText3D", "[", 
      RowBox[{"Contents", ",", "P", ",", "0", ",", "FullOpts"}], " ", "]"}]}],
     "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ManualLabel3D", "[", 
     RowBox[{"P_", ",", "Contents_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"ManualLabel3D", ",", "Opts"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BasicLabel3D", "[", 
       RowBox[{"P", ",", "Contents", ",", 
        RowBox[{"OptionsUnion", "[", 
         RowBox[{
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"Offset", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], ",",
           "FullOpts"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "   "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.49605569834375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Drawing objects", "Subsection"],

Cell["Simple elements", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicLine", "[", 
    RowBox[{"Points_List", ",", "FullOpts_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"option", " ", "processing"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLength", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLip", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowHead", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTail", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"object", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FigDefineObject", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Line", "\[Rule]", "Points"}], "}"}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "outline", " ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Line", "[", "Points", "]"}], "\[IndentingNewLine]", "}"}],
           ",", "\[IndentingNewLine]", "FullOpts"}], "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ShowHead", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"PCOfPA", "/@", 
               RowBox[{"ArrowHeadPoints", "[", 
                RowBox[{
                 RowBox[{"PAOfPC", "/@", 
                  RowBox[{"Take", "[", 
                   RowBox[{"Points", ",", 
                    RowBox[{"-", "2"}]}], "]"}]}], ",", 
                 RowBox[{"(", 
                  RowBox[{"HeadLength", "/.", "FullOpts"}], ")"}], ",", 
                 RowBox[{"(", 
                  RowBox[{"HeadLip", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
              "]"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ShowTail", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"PCOfPA", "/@", 
               RowBox[{"ArrowHeadPoints", "[", 
                RowBox[{
                 RowBox[{"Reverse", "@", 
                  RowBox[{"(", 
                   RowBox[{"PAOfPC", "/@", 
                    RowBox[{"Take", "[", 
                    RowBox[{"Points", ",", "2"}], "]"}]}], ")"}]}], ",", 
                 RowBox[{"(", 
                  RowBox[{"HeadLength", "/.", "FullOpts"}], ")"}], ",", 
                 RowBox[{"(", 
                  RowBox[{"HeadLip", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
              "]"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "text", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"BasicLineAnnotations", "[", 
         RowBox[{"Points", ",", "FullOpts"}], "]"}]}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeLine", "[", 
    RowBox[{
     RowBox[{"Points", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], "..."}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"SchemeLine", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"CheckValue", "[", 
         RowBox[{"Points", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}], "..."}], "}"}], ",", 
          "\"\<list of points given to SchemeLine\>\""}], "]"}], ";"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"BasicLine", "[", 
       RowBox[{
        RowBox[{"PCOfPU", "/@", "Points"}], ",", "FullOpts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeLine", "[", 
    RowBox[{"g_Graphics", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeLine", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "CurveList", ",", "Curve"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Join", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"extract", " ", "curves"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"CurveList", "=", 
       RowBox[{"ExtractCurves", "[", "g", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Join", "/.", "FullOpts"}], ")"}], ",", 
        RowBox[{"CurveList", "=", 
         RowBox[{"{", 
          RowBox[{"Join", "@@", "CurveList"}], "}"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"CheckValue", "[", 
           RowBox[{"Curve", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"_", "?", "NumericQ"}], ",", 
                RowBox[{"_", "?", "NumericQ"}]}], "}"}], "..."}], "}"}], ",", 
            "\"\<list of points extracted from graphics given to SchemeLine\>\
\""}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"BasicLine", "[", 
           RowBox[{
            RowBox[{"PCOfPU", "/@", "Curve"}], ",", "FullOpts"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Curve", ",", "CurveList"}], "}"}]}], "\[IndentingNewLine]", 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3955201269375*^9, 3.395520130609375*^9}, {
   3.450567284586611*^9, 3.4505672872740593`*^9}, {3.492289691578125*^9, 
   3.492289707421875*^9}, {3.492289794578125*^9, 3.49228989878125*^9}, {
   3.492290555234375*^9, 3.492290559015625*^9}, {3.492380001375*^9, 
   3.492380120578125*^9}, 3.4923809419375*^9, {3.4923814556875*^9, 
   3.492381542109375*^9}, {3.496055698359375*^9, 3.496055698359375*^9}, {
   3.496668058015625*^9, 3.496668112734375*^9}, {3.49666826934375*^9, 
   3.496668278140625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicPolygon", "[", 
    RowBox[{"Points_List", ",", "FullOpts_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ClosedPoints", ",", "LineComplex"}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"option", " ", "processing"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowEdge", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"L", ":", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"True", "|", "False"}], ")"}], ".."}], "}"}]}], "/;", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "L", "]"}], "==", 
             RowBox[{"Length", "[", "Points", "]"}]}], ")"}]}], ")"}]}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"choose", " ", "edges", " ", "to", " ", "draw"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ClosedPoints", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"Points", ",", 
         RowBox[{"First", "[", "Points", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"LineComplex", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ShowEdge", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", "Automatic", ",", "\[IndentingNewLine]", 
         "ClosedPoints", ",", "\[IndentingNewLine]", "_List", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Pick", "[", 
          RowBox[{
           RowBox[{"Partition", "[", 
            RowBox[{"ClosedPoints", ",", "2", ",", "1"}], "]"}], ",", 
           RowBox[{"(", 
            RowBox[{"ShowEdge", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Fill", " ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Polygon", "[", "Points", "]"}], "\[IndentingNewLine]", 
           "}"}], ",", "\[IndentingNewLine]", "FullOpts"}], "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "Outline", " ", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Line", "[", "LineComplex", "]"}], "\[IndentingNewLine]", 
           "}"}], ",", "\[IndentingNewLine]", "FullOpts"}], "]"}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemePolygon", "[", 
    RowBox[{
     RowBox[{"Points", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], "..."}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"SchemePolygon", ",", "Opts"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"CheckValue", "[", 
         RowBox[{"Points", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}], "..."}], "}"}], ",", 
          "\"\<list of points given to SchemePolygon\>\""}], "]"}], ";"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"BasicPolygon", "[", 
       RowBox[{
        RowBox[{"PCOfPU", "/@", "Points"}], ",", "FullOpts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.489687933171875*^9, 3.48968802940625*^9}, {
   3.489688095421875*^9, 3.489688199515625*^9}, {3.48968824003125*^9, 
   3.489688299515625*^9}, {3.48968843615625*^9, 3.48968844309375*^9}, 
   3.48968899328125*^9, {3.492290464125*^9, 3.49229046978125*^9}, {
   3.492290513078125*^9, 3.492290539625*^9}, 3.496055698375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicBox", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "x2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y1_", ",", "y2_"}], "}"}]}], "}"}], ",", "FullOpts_List"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Fill", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x1", ",", "y1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "y2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2", ",", "y2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2", ",", "y1"}], "}"}]}], "}"}], "]"}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         "FullOpts"}], "]"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Outline", " ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x1", ",", "y1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "y2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2", ",", "y2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2", ",", "y1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "y1"}], "}"}]}], "}"}], "]"}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         "FullOpts"}], "]"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Labels", " ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"MakeText", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"LabL", "/.", "FullOpts"}], ")"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"x1", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y1", "+", "y2"}], ")"}], "/", "2"}]}], "}"}], ",", "0", 
         ",", "\[IndentingNewLine]", 
         RowBox[{"ShowText", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"OffsetL", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"+", "1"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Nudge", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"NudgeL", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Orientation", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Background", "->", 
          RowBox[{"(", 
           RowBox[{"BackgroundL", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"MakeText", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"LabR", "/.", "FullOpts"}], ")"}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y1", "+", "y2"}], ")"}], "/", "2"}]}], "}"}], ",", "0", 
         ",", "\[IndentingNewLine]", 
         RowBox[{"ShowText", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"OffsetR", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Nudge", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"NudgeR", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Orientation", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Background", "->", 
          RowBox[{"(", 
           RowBox[{"BackgroundR", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"MakeText", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"LabC", "/.", "FullOpts"}], ")"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x1", "+", "x2"}], ")"}], "/", "2"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y1", "+", "y2"}], ")"}], "/", "2"}]}], "}"}], ",", "0", 
         ",", "\[IndentingNewLine]", 
         RowBox[{"ShowText", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"OffsetC", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Nudge", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"NudgeC", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Orientation", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"OrientationC", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Background", "->", 
          RowBox[{"(", 
           RowBox[{"BackgroundC", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"MakeText", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"LabT", "/.", "FullOpts"}], ")"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x1", "+", "x2"}], ")"}], "/", "2"}], ",", "y2"}], "}"}],
          ",", "0", ",", "\[IndentingNewLine]", 
         RowBox[{"ShowText", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"OffsetT", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Nudge", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"NudgeT", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Orientation", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Background", "->", 
          RowBox[{"(", 
           RowBox[{"BackgroundT", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"MakeText", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"LabB", "/.", "FullOpts"}], ")"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x1", "+", "x2"}], ")"}], "/", "2"}], ",", "y1"}], "}"}],
          ",", "0", ",", "\[IndentingNewLine]", 
         RowBox[{"ShowText", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"ShowLabB", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Offset", "\[Rule]", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"OffsetB", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"+", "1"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Nudge", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"NudgeB", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Orientation", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"OrientationB", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Background", "->", 
          RowBox[{"(", 
           RowBox[{"BackgroundB", "/.", "FullOpts"}], ")"}]}], ",", 
         "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
        "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBox", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1_", "?", "NumericQ"}], ",", 
         RowBox[{"x2_", "?", "NumericQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y1_", "?", "NumericQ"}], ",", 
         RowBox[{"y2_", "?", "NumericQ"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"SchemeBox", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"BasicBox", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XCOfXU", "/@", 
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2"}], "}"}]}], ",", 
          RowBox[{"YCOfYU", "/@", 
           RowBox[{"{", 
            RowBox[{"y1", ",", "y2"}], "}"}]}]}], "}"}], ",", "FullOpts"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBox", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1_", "?", "NumericQ"}], ",", 
       RowBox[{"y1_", "?", "NumericQ"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x2_", "?", "NumericQ"}], ",", 
       RowBox[{"y2_", "?", "NumericQ"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"SchemeBox", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1", ",", "x2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}], ",", "Opts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeSquare", "[", 
    RowBox[{
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"R_", "?", "RadiusQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "PC", ",", "xc", ",", "yc", ",", "RC", ",", "xr", ",", "yr", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeSquare", ",", "Opts"}], "]"}]}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"PC", "=", 
       RowBox[{"PCOfPU", "@", "P"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RC", "=", 
       RowBox[{"ConvertRadiusToCanvas", "@", "R"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"RC", "===", "None"}], ",", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"SchemeSquare", "::", "badr"}], ",", "R"}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xc", ",", "yc"}], "}"}], "=", "PC"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xr", ",", "yr"}], "}"}], "=", "RC"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"BasicBox", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"xc", "-", "xr"}], ",", 
            RowBox[{"xc", "+", "xr"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"yc", "-", "yr"}], ",", 
            RowBox[{"yc", "+", "yr"}]}], "}"}]}], "}"}], ",", "FullOpts"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.400339685*^9, 3.40033968571875*^9}, {3.4361284788125*^9,
   3.43612851365625*^9}, {3.496055698390625*^9, 3.496055698390625*^9}}],

Cell[TextData[{
 "SchemeCircle follows the basic ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notation of Circle and Disk for the radius, accepting either a number R \
(for a circle) or as a pair {Rxa,Rya} for an ellipse, but accepts special \
heads Horizontal, Vertical, and Point, instead of Offset.  BasicCircle \
requires a pair of x and y radii in canvas displacements."
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicCircle", "[", 
    RowBox[{
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"R", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"theta1_", "?", "NumericQ"}], ",", 
       RowBox[{"theta2_", "?", "NumericQ"}]}], "}"}], ",", "FullOpts_List"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "OptPosnX", ",", "OptBufferX", ",", "theta", ",", "RX", ",", "PX", ",", 
       "AngleX"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"option", " ", "processing"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLength", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLip", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowHead", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTail", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PosnX", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "fill", " ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Disk", "[", 
            RowBox[{"P", ",", "R", ",", 
             RowBox[{"{", 
              RowBox[{"theta1", ",", "theta2"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
          "FullOpts"}], "]"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "outline", " ", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Circle", "[", 
            RowBox[{"P", ",", "R", ",", 
             RowBox[{"{", 
              RowBox[{"theta1", ",", "theta2"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
          "FullOpts"}], "]"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ShowHead", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"PCOfPA", "/@", 
               RowBox[{"ArrowHeadPoints", "[", 
                RowBox[{
                 RowBox[{"PAOfPC", "[", 
                  RowBox[{"P", "+", 
                   RowBox[{"R", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "theta2", "]"}], ",", 
                    RowBox[{"Sin", "[", "theta2", "]"}]}], "}"}]}]}], "]"}], 
                 ",", 
                 RowBox[{"VectorArcTan", "[", 
                  RowBox[{"-", 
                   RowBox[{"DPAOfPC", "[", 
                    RowBox[{"R", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sin", "[", "theta2", "]"}], ",", 
                    RowBox[{"-", 
                    RowBox[{"Cos", "[", "theta2", "]"}]}]}], "}"}]}], "]"}]}],
                   "]"}], ",", 
                 RowBox[{"(", 
                  RowBox[{"HeadLength", "/.", "FullOpts"}], ")"}], ",", 
                 RowBox[{"(", 
                  RowBox[{"HeadLip", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
              "]"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ShowTail", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"PCOfPA", "/@", 
               RowBox[{"ArrowHeadPoints", "[", 
                RowBox[{
                 RowBox[{"PAOfPC", "[", 
                  RowBox[{"P", "+", 
                   RowBox[{"R", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "theta1", "]"}], ",", 
                    RowBox[{"Sin", "[", "theta1", "]"}]}], "}"}]}]}], "]"}], 
                 ",", 
                 RowBox[{"VectorArcTan", "[", 
                  RowBox[{"+", 
                   RowBox[{"DPAOfPC", "[", 
                    RowBox[{"R", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sin", "[", "theta1", "]"}], ",", 
                    RowBox[{"-", 
                    RowBox[{"Cos", "[", "theta1", "]"}]}]}], "}"}]}], "]"}]}],
                   "]"}], ",", 
                 RowBox[{"(", 
                  RowBox[{"HeadLength", "/.", "FullOpts"}], ")"}], ",", 
                 RowBox[{"(", 
                  RowBox[{"HeadLip", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
              "]"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "labels", " ", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabL", "/.", "FullOpts"}], ")"}], ",", 
          RowBox[{"P", "+", 
           RowBox[{"R", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetL", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"+", "1"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeL", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundL", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabR", "/.", "FullOpts"}], ")"}], ",", 
          RowBox[{"P", "+", 
           RowBox[{"R", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"+", "1"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetR", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabC", "/.", "FullOpts"}], ")"}], ",", "P", ",", "0", ",",
           "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetC", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabT", "/.", "FullOpts"}], ")"}], ",", 
          RowBox[{"P", "+", 
           RowBox[{"R", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"+", "1"}]}], "}"}]}], "}"}]}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetT", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabB", "/.", "FullOpts"}], ")"}], ",", 
          RowBox[{"P", "+", 
           RowBox[{"R", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetB", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"+", "1"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"OptPosnX", "=", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"PosnX", ",", "0.5", ",", "FullOpts"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"OptBufferX", "=", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"BufferX", ",", "\[IndentingNewLine]", 
            RowBox[{"Switch", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"OrientationX", "/.", "FullOpts"}], ")"}], ",", 
              "\[IndentingNewLine]", "Automatic", ",", "1.1", ",", 
              "\[IndentingNewLine]", "Inverted", ",", "1.1", ",", 
              "\[IndentingNewLine]", "Horizontal", ",", "0", ",", 
              "\[IndentingNewLine]", "Vertical", ",", "0", ",", 
              "\[IndentingNewLine]", "_", ",", " ", "1.1"}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"theta", "=", 
          RowBox[{"Interpolate", "[", 
           RowBox[{
           "0", ",", "1", ",", "theta1", ",", "theta2", ",", "OptPosnX"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"RX", "=", 
          RowBox[{"R", "*", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "theta", "]"}], ",", 
             RowBox[{"Sin", "[", "theta", "]"}]}], "}"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"AngleX", "=", 
          RowBox[{"VectorArcTan", "[", 
           RowBox[{"DPAOfPC", "[", 
            RowBox[{"R", "*", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Sin", "[", "theta", "]"}], ",", 
               RowBox[{"-", 
                RowBox[{"Cos", "[", "theta", "]"}]}]}], "}"}]}], "]"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"PX", "=", 
          RowBox[{"P", "+", "RX", "+", 
           RowBox[{"DPCOfPA", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Thickness", "/.", "FullOpts"}], ")"}], "/", "2"}], 
               "+", 
               RowBox[{
                RowBox[{"OptBufferX", "/", "2"}], "*", 
                RowBox[{"(", 
                 RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}]}], ")"}], 
             "*", 
             RowBox[{"RX", "/", 
              RowBox[{"VectorLength", "[", "RX", "]"}]}]}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"MakeText", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"LabX", "/.", "FullOpts"}], ")"}], ",", "PX", ",", 
           "AngleX", ",", "\[IndentingNewLine]", 
           RowBox[{"ShowText", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"ShowLabX", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Offset", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"OffsetX", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Nudge", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"NudgeX", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Orientation", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"OrientationX", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Background", "->", 
            RowBox[{"(", 
             RowBox[{"BackgroundX", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
          "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeCircle", "[", 
    RowBox[{
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"R_", "?", "RadiusQ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"theta1_", "?", "NumericQ"}], ",", 
       RowBox[{"theta2_", "?", "NumericQ"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeCircle", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "RC"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"RC", "=", 
       RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"RC", "===", "None"}], ",", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"SchemeCircle", "::", "badr"}], ",", "R"}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"BasicCircle", "[", 
       RowBox[{
        RowBox[{"PCOfPU", "[", "P", "]"}], ",", "RC", ",", 
        RowBox[{"{", 
         RowBox[{"theta1", ",", "theta2"}], "}"}], ",", "FullOpts"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeCircle", "[", 
    RowBox[{
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"R_", "?", "RadiusQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"SchemeCircle", "[", 
    RowBox[{"P", ",", "R", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}], ",", "Opts"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395520134296875*^9, 3.395520139109375*^9}, 
   3.496055698421875*^9}],

Cell["\<\
BasicEllipse breaks convention and takes R in user coordinates, for major and \
minor axis lengths to be meaningful\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicEllipse", "[", 
    RowBox[{
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"R", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a_", "?", "NumericQ"}], ",", 
        RowBox[{"b_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"theta0_", "?", "NumericQ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"theta1_", "?", "NumericQ"}], ",", 
       RowBox[{"theta2_", "?", "NumericQ"}]}], "}"}], ",", 
     RowBox[{"Closed", ":", 
      RowBox[{"(", 
       RowBox[{"True", "|", "False"}], ")"}]}], ",", "FullOpts_List"}], "]"}],
    ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "OptPosnX", ",", "OptBufferX", ",", "theta", ",", "r", ",", "RX", ",", 
       "PX", ",", "AngleX", ",", "Points"}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"option", " ", "processing"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLength", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLip", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowHead", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTail", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PosnX", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"TO", " ", 
        RowBox[{"DO", ":", " ", 
         RowBox[{"validity", " ", "checks", " ", "on", " ", "angles"}]}]}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"2", "*", 
          RowBox[{"Pi", "/", 
           RowBox[{"(", 
            RowBox[{"PlotPoints", "/.", "FullOpts"}], ")"}]}]}], ">", 
         RowBox[{"(", 
          RowBox[{"theta2", "-", "theta1"}], ")"}]}], ",", 
        RowBox[{"ErrorMessage", "[", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Points", "=", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"r", "=", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"a", "^", "2"}], "*", 
                 RowBox[{
                  RowBox[{"Sin", "[", "theta", "]"}], "^", "2"}]}], "+", 
                RowBox[{
                 RowBox[{"b", "^", "2"}], "*", 
                 RowBox[{
                  RowBox[{"Cos", "[", "theta", "]"}], "^", "2"}]}]}], 
               ")"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"P", "+", 
           RowBox[{"DPCOfPU", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"r", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"theta", "+", "theta0"}], "]"}]}], ",", 
              RowBox[{"r", "*", 
               RowBox[{"Sin", "[", 
                RowBox[{"theta", "+", "theta0"}], "]"}]}]}], "}"}]}]}]}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"theta", ",", "theta1", ",", "theta2", ",", 
           RowBox[{"2", "*", 
            RowBox[{"Pi", "/", 
             RowBox[{"(", 
              RowBox[{"PlotPoints", "/.", "FullOpts"}], ")"}]}]}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "fill", " ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Polygon", "[", 
            RowBox[{"If", "[", 
             RowBox[{"Closed", ",", "Points", ",", 
              RowBox[{"Append", "[", 
               RowBox[{"Points", ",", "P"}], "]"}]}], "]"}], "]"}], 
           "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
          "FullOpts"}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "outline", " ", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Line", "[", 
            RowBox[{"If", "[", 
             RowBox[{"Closed", ",", 
              RowBox[{"Append", "[", 
               RowBox[{"Points", ",", 
                RowBox[{"First", "[", "Points", "]"}]}], "]"}], ",", 
              "Points"}], "]"}], "]"}], "\[IndentingNewLine]", "}"}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], "\[IndentingNewLine]", "]"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"TO", " ", 
          RowBox[{"DO", ":", " ", 
           RowBox[{
           "Implement", " ", "arrowheads", " ", "and", " ", "labels"}]}]}], 
         " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ShowHead", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"r", "=", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"a", "^", "2"}], "*", 
                 RowBox[{
                  RowBox[{"b", "^", "2"}], "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"a", "^", "2"}], "*", 
                    RowBox[{
                    RowBox[{"Sin", "[", "theta2", "]"}], "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{"b", "^", "2"}], "*", 
                    RowBox[{
                    RowBox[{"Cos", "[", "theta2", "]"}], "^", "2"}]}]}], 
                   ")"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"Line", "[", 
               RowBox[{"PCOfPA", "/@", 
                RowBox[{"ArrowHeadPoints", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"PAOfPC", "[", 
                   RowBox[{"P", "+", 
                    RowBox[{"DPCOfPU", "@", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"r", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"theta2", "+", "theta0"}], "]"}]}], ",", 
                    RowBox[{"r", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"theta2", "+", "theta0"}], "]"}]}]}], "}"}]}]}], 
                   "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"VectorArcTan", "[", 
                    RowBox[{"-", 
                    RowBox[{"DPAOfPC", "[", 
                    RowBox[{"R", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sin", "[", "theta2", "]"}], ",", 
                    RowBox[{"-", 
                    RowBox[{"Cos", "[", "theta2", "]"}]}]}], "}"}]}], "]"}]}],
                     "]"}], "+", "theta0"}], ",", " ", 
                  RowBox[{"(*", " ", 
                   RowBox[{"TO", " ", 
                    RowBox[{"DO", ":", " ", "angle"}]}], " ", "*)"}], 
                  "\[IndentingNewLine]", 
                  RowBox[{"(", 
                   RowBox[{"HeadLength", "/.", "FullOpts"}], ")"}], ",", 
                  RowBox[{"(", 
                   RowBox[{"HeadLip", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
               "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ShowTail", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeOutline", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "labels", " ", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabL", "/.", "FullOpts"}], ")"}], ",", 
          RowBox[{"P", "+", 
           RowBox[{"R", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetL", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"+", "1"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeL", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundL", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabR", "/.", "FullOpts"}], ")"}], ",", 
          RowBox[{"P", "+", 
           RowBox[{"R", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"+", "1"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetR", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "FullOpts"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundR", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabC", "/.", "FullOpts"}], ")"}], ",", "P", ",", "0", ",",
           "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetC", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundC", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabT", "/.", "FullOpts"}], ")"}], ",", 
          RowBox[{"P", "+", 
           RowBox[{"R", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"+", "1"}]}], "}"}]}], "}"}]}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetT", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundT", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"MakeText", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"LabB", "/.", "FullOpts"}], ")"}], ",", 
          RowBox[{"P", "+", 
           RowBox[{"R", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ShowText", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"ShowLabB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Offset", "\[Rule]", 
           RowBox[{"GetAutoOption", "[", 
            RowBox[{"OffsetB", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"+", "1"}]}], "}"}], ",", "FullOpts"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Nudge", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"NudgeB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Orientation", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"OrientationB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Background", "->", 
           RowBox[{"(", 
            RowBox[{"BackgroundB", "/.", "FullOpts"}], ")"}]}], ",", 
          "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
         "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"OptPosnX", "=", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"PosnX", ",", "0.5", ",", "FullOpts"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"OptBufferX", "=", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"BufferX", ",", "\[IndentingNewLine]", 
            RowBox[{"Switch", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"OrientationX", "/.", "FullOpts"}], ")"}], ",", 
              "\[IndentingNewLine]", "Automatic", ",", "1.1", ",", 
              "\[IndentingNewLine]", "Inverted", ",", "1.1", ",", 
              "\[IndentingNewLine]", "Horizontal", ",", "0", ",", 
              "\[IndentingNewLine]", "Vertical", ",", "0", ",", 
              "\[IndentingNewLine]", "_", ",", " ", "1.1"}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"theta", "=", 
          RowBox[{"Interpolate", "[", 
           RowBox[{
           "0", ",", "1", ",", "theta1", ",", "theta2", ",", "OptPosnX"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"RX", "=", 
          RowBox[{"R", "*", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "theta", "]"}], ",", 
             RowBox[{"Sin", "[", "theta", "]"}]}], "}"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"AngleX", "=", 
          RowBox[{"VectorArcTan", "[", 
           RowBox[{"DPAOfPC", "[", 
            RowBox[{"R", "*", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Sin", "[", "theta", "]"}], ",", 
               RowBox[{"-", 
                RowBox[{"Cos", "[", "theta", "]"}]}]}], "}"}]}], "]"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"PX", "=", 
          RowBox[{"P", "+", "RX", "+", 
           RowBox[{"DPCOfPA", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Thickness", "/.", "FullOpts"}], ")"}], "/", "2"}], 
               "+", 
               RowBox[{
                RowBox[{"OptBufferX", "/", "2"}], "*", 
                RowBox[{"(", 
                 RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}]}], ")"}], 
             "*", 
             RowBox[{"RX", "/", 
              RowBox[{"VectorLength", "[", "RX", "]"}]}]}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"MakeText", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"LabX", "/.", "FullOpts"}], ")"}], ",", "PX", ",", 
           "AngleX", ",", "\[IndentingNewLine]", 
           RowBox[{"ShowText", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"ShowLabX", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Offset", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"OffsetX", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Nudge", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"NudgeX", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Orientation", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"OrientationX", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Background", "->", 
            RowBox[{"(", 
             RowBox[{"BackgroundX", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
          "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeEllipse", "[", 
    RowBox[{
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"R_", "?", "RadiusQ"}], ",", 
     RowBox[{"theta0_", "?", "NumericQ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"theta1_", "?", "NumericQ"}], ",", 
       RowBox[{"theta2_", "?", "NumericQ"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"SchemeEllipse", ",", "Opts"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BasicEllipse", "[", 
       RowBox[{
        RowBox[{"PCOfPU", "[", "P", "]"}], ",", 
        RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}], ",", "theta0", ",", 
        
        RowBox[{"{", 
         RowBox[{"theta1", ",", "theta2"}], "}"}], ",", "False", ",", 
        "FullOpts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeEllipse", "[", 
    RowBox[{
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"R_", "?", "RadiusQ"}], ",", 
     RowBox[{"theta0_", "?", "NumericQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"SchemeEllipse", ",", "Opts"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BasicEllipse", "[", 
       RowBox[{
        RowBox[{"PCOfPU", "[", "P", "]"}], ",", 
        RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}], ",", "theta0", ",", 
        
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"2", "*", "Pi"}]}], "}"}], ",", "True", ",", "FullOpts"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeEllipse", "[", 
    RowBox[{
     RowBox[{"P", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"R_", "?", "RadiusQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"SchemeEllipse", "[", 
    RowBox[{"P", ",", "R", ",", "0", ",", "Opts"}], "]"}]}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.395520143578125*^9, 3.39552014725*^9}, {
   3.4105590690625*^9, 3.4105590693125*^9}, {3.410559244328125*^9, 
   3.410559298640625*^9}, 3.41055934828125*^9, {3.410559393609375*^9, 
   3.41055941040625*^9}, {3.441572433177*^9, 3.441572442973875*^9}, {
   3.441572479677*^9, 3.44157250364575*^9}, {3.4415726721145*^9, 
   3.441572706677*^9}, {3.441572929411375*^9, 3.441572929817625*^9}, {
   3.4960556984375*^9, 3.496055698453125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SchemeArrow", "[", 
    RowBox[{
     RowBox[{"RawNodes", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PI", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "ArrowNodeQ"}], ")"}], "..."}], ",", 
        RowBox[{"Pf", ":", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeArrow", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "Nodes", ",", "R", ",", "P"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Kink", ",", "None", ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Nodes", "=", 
       RowBox[{"Replace", "[", "\[IndentingNewLine]", 
        RowBox[{"RawNodes", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"P", ":", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ":>", 
            RowBox[{"PCOfPU", "@", "P"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"FromHead", "[", "R_", "]"}], "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"PCOfPU", "@", "Pf"}], "+", 
              RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ")"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"FromTail", "[", "R_", "]"}], "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"PCOfPU", "@", "PI"}], "+", 
              RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ")"}]}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", "1"}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BasicArrow", "[", 
       RowBox[{"SchemeArrow", ",", "Nodes", ",", "FullOpts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeArrow", "[", 
    RowBox[{
     RowBox[{"PI", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"Pf", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeArrow", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "RawNodes", ",", "Nodes", ",", "R", ",", "P"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Kink", ",", 
        RowBox[{"None", "|", 
         RowBox[{"_", "?", "ArrowNodeQ"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"_", "?", "ArrowNodeQ"}], ")"}], "..."}], "}"}]}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"RawNodes", "=", 
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "PI", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Switch", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Kink", "/.", "FullOpts"}], ")"}], ",", 
           "\[IndentingNewLine]", "None", ",", 
           RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"_", "?", "ArrowNodeQ"}], ",", 
           RowBox[{"{", 
            RowBox[{"(", 
             RowBox[{"Kink", "/.", "FullOpts"}], ")"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"_", "?", "ArrowNodeQ"}], ")"}], "..."}], "}"}], ",", 
           RowBox[{"(", 
            RowBox[{"Kink", "/.", "FullOpts"}], ")"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", "Pf", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Nodes", "=", 
       RowBox[{"Replace", "[", "\[IndentingNewLine]", 
        RowBox[{"RawNodes", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"P", ":", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ":>", 
            RowBox[{"PCOfPU", "@", "P"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"FromHead", "[", "R_", "]"}], "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"PCOfPU", "@", "Pf"}], "+", 
              RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ")"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"FromTail", "[", "R_", "]"}], "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"PCOfPU", "@", "PI"}], "+", 
              RowBox[{"ConvertRadiusToCanvas", "[", "R", "]"}]}], ")"}]}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", "1"}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BasicArrow", "[", 
       RowBox[{"SchemeArrow", ",", "Nodes", ",", "FullOpts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49605569846875*^9, 3.49605569846875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicSchemeBracket", "[", 
    RowBox[{"Caller_Symbol", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "x2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y1_", ",", "y2_"}], "}"}]}], "}"}], ",", 
     RowBox[{"Axis", ":", 
      RowBox[{"(", 
       RowBox[{"1", "|", "2", "|", "3", "|", "4"}], ")"}]}], ",", 
     "FullOpts_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "Segment", ",", "HalfWidthForLabels", ",", "Buffer", ",", "Posn", ",", 
       "P", ",", "\[IndentingNewLine]", "LabelGraphics", ",", 
       "\[IndentingNewLine]", "ArrowHeadSign", ",", "\[IndentingNewLine]", 
       "Points"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"calculate", " ", "geometry"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Segment", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"Axis", ",", "\[IndentingNewLine]", "1", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "y1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", "y1"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", "2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "y1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x1", ",", "y2"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", "3", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "y2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", "y2"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", "4", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x2", ",", "y1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", "y2"}], "}"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ArrowHeadSign", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"Axis", ",", "\[IndentingNewLine]", 
         RowBox[{"1", "|", "4"}], ",", 
         RowBox[{"+", "1"}], ",", "\[IndentingNewLine]", 
         RowBox[{"2", "|", "3"}], ",", 
         RowBox[{"-", "1"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"construct", " ", "axis", " ", "label"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "basic", " ", "spacing", " ", "provided", " ", "by", " ", "Offset"}], 
        ",", " ", 
        RowBox[{"additional", " ", "by", " ", "Buffer"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"HalfWidthForLabels", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Thickness", "/.", "FullOpts"}], ")"}], "/", "2"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Buffer", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{
         RowBox[{"Switch", "[", 
          RowBox[{
          "Axis", ",", "1", ",", "BufferB", ",", "2", ",", "BufferL", ",", 
           "3", ",", "BufferT", ",", "4", ",", "BufferR"}], "]"}], ",", "1.1",
          ",", "FullOpts"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Posn", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{
         RowBox[{"Switch", "[", 
          RowBox[{
          "Axis", ",", "1", ",", "PosnB", ",", "2", ",", "PosnL", ",", "3", 
           ",", "PosnT", ",", "4", ",", "PosnR"}], "]"}], ",", "0.5", ",", 
         "FullOpts"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"P", "=", 
       RowBox[{"PCOfPA", "@", 
        RowBox[{"ArrowPoint", "[", 
         RowBox[{"Caller", ",", 
          RowBox[{"PAOfPC", "/@", "Segment"}], ",", "AtUserPosition", ",", 
          "Posn", ",", 
          RowBox[{
           RowBox[{"Switch", "[", 
            RowBox[{"Axis", ",", 
             RowBox[{"1", "|", "4"}], ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"2", "|", "3"}], ",", 
             RowBox[{"+", "1"}]}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"HalfWidthForLabels", "+", 
             RowBox[{
              RowBox[{"Buffer", "/", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}]}], ")"}]}]}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"LabelGraphics", "=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"Switch", "[", "\[IndentingNewLine]", 
         RowBox[{
         "Axis", ",", "\[IndentingNewLine]", "1", ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeText", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"LabB", "/.", "FullOpts"}], ")"}], ",", "P", ",", "0", 
            ",", "\[IndentingNewLine]", 
            RowBox[{"ShowText", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"ShowLabB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Offset", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetB", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Nudge", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"NudgeB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Orientation", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"OrientationB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "->", 
             RowBox[{"(", 
              RowBox[{"BackgroundB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
           "]"}], ",", "\[IndentingNewLine]", "2", ",", "\[IndentingNewLine]", 
          RowBox[{"MakeText", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"LabL", "/.", "FullOpts"}], ")"}], ",", "P", ",", 
            RowBox[{
             RowBox[{"-", "Pi"}], "/", "2"}], ",", "\[IndentingNewLine]", 
            RowBox[{"ShowText", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Offset", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetL", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Nudge", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"NudgeL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Orientation", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "->", 
             RowBox[{"(", 
              RowBox[{"BackgroundL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
           "]"}], ",", "\[IndentingNewLine]", "3", ",", "\[IndentingNewLine]", 
          RowBox[{"MakeText", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"LabT", "/.", "FullOpts"}], ")"}], ",", "P", ",", "0", 
            ",", "\[IndentingNewLine]", 
            RowBox[{"ShowText", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Offset", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetT", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Nudge", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"NudgeT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Orientation", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "->", 
             RowBox[{"(", 
              RowBox[{"BackgroundT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
           "]"}], ",", "\[IndentingNewLine]", "4", ",", "\[IndentingNewLine]", 
          RowBox[{"MakeText", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"LabR", "/.", "FullOpts"}], ")"}], ",", "P", ",", 
            RowBox[{
             RowBox[{"-", "Pi"}], "/", "2"}], ",", "\[IndentingNewLine]", 
            RowBox[{"ShowText", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Offset", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetR", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Nudge", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"NudgeR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Orientation", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "->", 
             RowBox[{"(", 
              RowBox[{"BackgroundR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
           "]"}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Combine", " ", "ticks", " ", "with", " ", "axis", " ", "line"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Points", "=", 
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{
           RowBox[{"PCOfPA", "/@", 
            RowBox[{"ArrowHeadPoints", "[", 
             RowBox[{
              RowBox[{"PAOfPC", "/@", 
               RowBox[{"Reverse", "@", "Segment"}]}], ",", 
              RowBox[{
               RowBox[{"-", "HeadLength"}], "/.", "FullOpts"}], ",", 
              RowBox[{"HeadLip", "/.", "FullOpts"}]}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"-", "1"}], "*", "ArrowHeadSign"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "Segment", ",", "\[IndentingNewLine]", 
         RowBox[{"Take", "[", 
          RowBox[{
           RowBox[{"PCOfPA", "/@", 
            RowBox[{"ArrowHeadPoints", "[", 
             RowBox[{
              RowBox[{"PAOfPC", "/@", "Segment"}], ",", 
              RowBox[{
               RowBox[{"-", "HeadLength"}], "/.", "FullOpts"}], ",", 
              RowBox[{"HeadLip", "/.", "FullOpts"}]}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"+", "1"}], "*", "ArrowHeadSign"}]}], "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"axis", " ", "line"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"MakeOutline", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Line", "[", "Points", "]"}], "}"}], ",", "FullOpts"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "labels", " ", "*)"}], "\[IndentingNewLine]", 
         "LabelGraphics"}], "\[IndentingNewLine]", "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBracket", "[", 
    RowBox[{
     RowBox[{"Side", ":", 
      RowBox[{"(", 
       RowBox[{"Bottom", "|", "Top"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xa_", "?", "NumericQ"}], ",", 
       RowBox[{"xb_", "?", "NumericQ"}]}], "}"}], ",", 
     RowBox[{"y_", "?", "NumericQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeBracket", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "yNudged"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"EnergyNudge", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"yNudged", "=", 
       RowBox[{"y", "+", 
        RowBox[{"(", 
         RowBox[{"EnergyNudge", "/.", "FullOpts"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", "\[IndentingNewLine]", 
       RowBox[{
       "Side", ",", "\[IndentingNewLine]", "Bottom", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BasicSchemeBracket", "[", 
         RowBox[{"SchemeBracket", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XCOfXU", "[", "xa", "]"}], ",", 
              RowBox[{"XCOfXU", "[", "xb", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"YCOfYU", "[", "yNudged", "]"}], ",", "Null"}], "}"}]}],
            "}"}], ",", "1", ",", "FullOpts"}], "]"}], ",", 
        "\[IndentingNewLine]", "Top", ",", "\[IndentingNewLine]", 
        RowBox[{"BasicSchemeBracket", "[", 
         RowBox[{"SchemeBracket", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XCOfXU", "[", "xa", "]"}], ",", 
              RowBox[{"XCOfXU", "[", "xb", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Null", ",", 
              RowBox[{"YCOfYU", "[", "yNudged", "]"}]}], "}"}]}], "}"}], ",", 
          "3", ",", "FullOpts"}], "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBracket", "[", 
    RowBox[{
     RowBox[{"Side", ":", 
      RowBox[{"(", 
       RowBox[{"Left", "|", "Right"}], ")"}]}], ",", 
     RowBox[{"x_", "?", "NumericQ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ya_", "?", "NumericQ"}], ",", 
       RowBox[{"yb_", "?", "NumericQ"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"SchemeBracket", ",", "Opts"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", "\[IndentingNewLine]", 
       RowBox[{
       "Side", ",", "\[IndentingNewLine]", "Left", ",", "\[IndentingNewLine]", 
        RowBox[{"BasicSchemeBracket", "[", 
         RowBox[{"SchemeBracket", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XCOfXU", "[", "x", "]"}], ",", "Null"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"YCOfYU", "[", "ya", "]"}], ",", 
              RowBox[{"YCOfYU", "[", "yb", "]"}]}], "}"}]}], "}"}], ",", "2", 
          ",", "FullOpts"}], "]"}], ",", "\[IndentingNewLine]", "Right", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BasicSchemeBracket", "[", 
         RowBox[{"SchemeBracket", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Null", ",", 
              RowBox[{"XCOfXU", "[", "x", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"YCOfYU", "[", "ya", "]"}], ",", 
              RowBox[{"YCOfYU", "[", "yb", "]"}]}], "}"}]}], "}"}], ",", "4", 
          ",", "FullOpts"}], "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBracket", "[", 
    RowBox[{
     RowBox[{"Side", ":", 
      RowBox[{"(", 
       RowBox[{"Bottom", "|", "Top"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"IDi_", "?", "LevelIdentifierQ"}], ",", 
       RowBox[{"IDf_", "?", "LevelIdentifierQ"}]}], "}"}], ",", "y_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDi", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDf", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"SchemeBracket", "[", 
       RowBox[{"Side", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XUOfXC", "@", 
           RowBox[{"LevelScheme`Data`xa", "[", "IDi", "]"}]}], ",", 
          RowBox[{"XUOfXC", "@", 
           RowBox[{"LevelScheme`Data`xb", "[", "IDf", "]"}]}]}], "}"}], ",", 
        "y", ",", "Opts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBracket", "[", 
    RowBox[{
     RowBox[{"Side", ":", 
      RowBox[{"(", 
       RowBox[{"Bottom", "|", "Top"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x1_", ",", "x2_"}], "}"}], ",", 
     RowBox[{"IDy_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDy", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"SchemeBracket", "[", 
       RowBox[{"Side", ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", "x2"}], "}"}], ",", 
        RowBox[{"YUOfYC", "@", 
         RowBox[{"LevelScheme`Data`Energy", "[", "IDy", "]"}]}], ",", 
        "Opts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeBracket", "[", 
    RowBox[{
     RowBox[{"Side", ":", 
      RowBox[{"(", 
       RowBox[{"Left", "|", "Right"}], ")"}]}], ",", 
     RowBox[{"x_", "?", "NumericQ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"IDi_", "?", "LevelIdentifierQ"}], ",", 
       RowBox[{"IDf_", "?", "LevelIdentifierQ"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDi", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckLevel", "[", "IDf", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"SchemeBracket", "[", 
       RowBox[{"Side", ",", "x", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"YUOfYC", "@", 
           RowBox[{"LevelScheme`Data`Energy", "[", "IDi", "]"}]}], ",", 
          RowBox[{"YUOfYC", "@", 
           RowBox[{"LevelScheme`Data`Energy", "[", "IDf", "]"}]}]}], "}"}], 
        ",", "Opts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.428186708015625*^9, 3.428186714984375*^9}, 
   3.428186769359375*^9, {3.461094924546875*^9, 3.461095017609375*^9}, {
   3.46109507353125*^9, 3.461095128265625*^9}, {3.4610953008125*^9, 
   3.461095403453125*^9}, {3.46109551625*^9, 3.461095525796875*^9}, {
   3.4960556985*^9, 3.496055698515625*^9}, {3.496678124421875*^9, 
   3.4966781536875*^9}, 3.4966782113125*^9}],

Cell["\<\
3D arrow
\tRespects only those options recognized by MakeOutline3D (no Layer), \
produces graphics primatives (rather than SchemeGraphics)
\tOnly LineArrow implemented, with no labels

Note on arrow head rotation calculation:  RotationMatrix3D for (\[Alpha],\
\[Beta],\[Gamma]) uses Euler angle convention (-z,-x,-z), if considered as an \
active transformation, and rotates with respect to the original unrotated \
frame coordinates if rotations are carried out in the order written. \
Therefore a point on the z-axis is rotated under (\[Alpha],\[Beta],\[Gamma]) \
to polar angle \[Theta]=\[Beta] and azimuthal angle \[Phi]=\[Pi]/2-\[Gamma], \
independent of \[Alpha].\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ArrowHeadPoints3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "P2_"}], "}"}], ",", "HeadLength_", ",", "HeadLip_",
      ",", "HeadAngle_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "v", ",", "Normv", ",", "u", ",", "\[IndentingNewLine]", "alpha", ",", 
       "beta", ",", "gamma", ",", "\[IndentingNewLine]", "R"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"v", "=", 
       RowBox[{"P2", "-", "P1"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Normv", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Plus", "@@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "^", "2"}], "&"}], ")"}], "/@", "v"}], ")"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"u", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Normv", "==", "0."}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"v", "/", "Normv"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"alpha", "=", "HeadAngle"}], ";", "\[IndentingNewLine]", 
      RowBox[{"beta", "=", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"u", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"gamma", "=", 
       RowBox[{
        RowBox[{"Pi", "/", "2"}], "-", 
        RowBox[{"VectorArcTan", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R", "=", 
       RowBox[{"RotationMatrix3D", "[", 
        RowBox[{"alpha", ",", "beta", ",", "gamma"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"P2", "+", 
         RowBox[{"R", ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"+", "HeadLip"}], ",", "0.", ",", 
            RowBox[{"-", "HeadLength"}]}], "}"}]}]}], ",", 
        "\[IndentingNewLine]", "P2", ",", "\[IndentingNewLine]", 
        RowBox[{"P2", "+", 
         RowBox[{"R", ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "HeadLip"}], ",", "0.", ",", 
            RowBox[{"-", "HeadLength"}]}], "}"}]}]}]}], "\[IndentingNewLine]",
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BasicArrow3D", "[", 
    RowBox[{
    "Caller_Symbol", ",", "PI_", ",", "Pf_", ",", "HeadAngle_", ",", 
     "FullOpts_List"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "OptWidth", ",", "OptHeadLength", ",", "OptHeadLip", ",", 
       "OptThickness", ",", "Segment", ",", "TailSegment", ",", "PC", ",", 
       "Art"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"ArrowType", ",", "LineArrow", ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLength", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"HeadLip", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowHead", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTail", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PosnC", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}]}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"calculate", " ", "arrow", " ", "geometry"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"OptWidth", "=", 
       RowBox[{"(", 
        RowBox[{"Width", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptHeadLength", "=", 
       RowBox[{"(", 
        RowBox[{"HeadLength", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptHeadLip", "=", 
       RowBox[{"(", 
        RowBox[{"HeadLip", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptThickness", "=", 
       RowBox[{"(", 
        RowBox[{"Thickness", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Segment", "=", 
       RowBox[{"{", 
        RowBox[{"PI", ",", "Pf"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TailSegment", "=", "Segment"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"PC", "=", 
       RowBox[{"PI", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Pf", "-", "PI"}], ")"}], "*", 
         RowBox[{"GetAutoOption", "[", 
          RowBox[{"PosnC", ",", "0.5", ",", "FullOpts"}], "]"}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Art", "=", 
       RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"main", " ", "segment"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"MakeOutline3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Line", "[", "Segment", "]"}], "}"}], ",", "FullOpts"}], 
          "]"}], " ", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "head", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ShowHead", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MakeOutline3D", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Line", "[", 
               RowBox[{"ArrowHeadPoints3D", "[", 
                RowBox[{
                "Segment", ",", "OptHeadLength", ",", "OptHeadLip", ",", 
                 "HeadAngle"}], "]"}], "]"}], "}"}], ",", 
             RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], "]"}],
            ",", "\[IndentingNewLine]", 
           RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "tail", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ShowTail", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MakeOutline3D", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Line", "[", 
               RowBox[{"ArrowHeadPoints3D", "[", 
                RowBox[{
                 RowBox[{"Reverse", "@", "TailSegment"}], ",", 
                 "OptHeadLength", ",", "OptHeadLip", ",", "HeadAngle"}], 
                "]"}], "]"}], "}"}], ",", 
             RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], "]"}],
            ",", "\[IndentingNewLine]", 
           RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "label", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"MakeText3D", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"LabC", "/.", "FullOpts"}], ")"}], ",", " ", "PC", ",", 
           "0", ",", "\[IndentingNewLine]", 
           RowBox[{"ShowText", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"ShowLabC", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Offset", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"OffsetC", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Orientation", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"OrientationC", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Background", "->", 
            RowBox[{"(", 
             RowBox[{"BackgroundC", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
          "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], ";",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Flatten", "[", "Art", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395520155734375*^9, 3.3955201593125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SchemeArrow3D", "[", 
     RowBox[{
      RowBox[{"PI", ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
      RowBox[{"Pf", ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
      RowBox[{"HeadAngle", ":", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"_", "?", "NumericQ"}], ")"}], ":", "0"}]}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeArrow3D", ",", "Opts"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BasicArrow3D", "[", 
       RowBox[{
       "SchemeArrow3D", ",", "PI", ",", "Pf", ",", "HeadAngle", ",", 
        "FullOpts"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "   "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.496055698515625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicLine3D", "[", 
    RowBox[{"Points_List", ",", "FullOpts_List"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "outline", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"MakeOutline3D", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"Line", "[", "Points", "]"}], "\[IndentingNewLine]", "}"}], 
        ",", "\[IndentingNewLine]", "FullOpts"}], "]"}], 
      "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SchemeLine3D", "[", 
     RowBox[{
      RowBox[{"Points", ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}], "..."}], "}"}]}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], " ", ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeLine3D", ",", "Opts"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BasicLine3D", "[", 
       RowBox[{"Points", ",", "FullOpts"}], "]"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "   "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.496055698515625*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics inclusion", "Section"],

Cell[CellGroupData[{

Cell["Raw graphics", "Subsection"],

Cell[TextData[{
 "Conversion of user to canvas coordinates allowing the generalized ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Scaled and Offset coordinates\n\tCAVEAT: Doesn't actually work that way, \
since TransformGraphics does mapping at level -2.  Manual override is \
implemented by SpecialPointRules below."
}], "Text",
 CellChangeTimes->{{3.460830324015625*^9, 3.4608303943125*^9}, {
  3.460830480046875*^9, 3.460830483875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SchemeScaleP", "[", 
    RowBox[{"Offset", "[", 
     RowBox[{
      RowBox[{"DPA", ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "GeneralP_"}], "]"}],
     "]"}], ":=", 
   RowBox[{
    RowBox[{"DPCOfPA", "[", "DPA", "]"}], "+", 
    RowBox[{"SchemeScaleP", "[", "GeneralP", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeScaleP", "[", 
    RowBox[{"Scaled", "[", 
     RowBox[{
      RowBox[{"DPS", ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
      RowBox[{"PU", ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DPCOfPS", "[", "DPS", "]"}], "+", 
    RowBox[{"PCOfPU", "[", "PU", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeScaleP", "[", 
    RowBox[{"Scaled", "[", 
     RowBox[{"PS", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "]"}], "]"}], ":=", 
   RowBox[{"PCOfPS", "[", "PS", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeScaleP", "[", 
    RowBox[{"PU", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], ",", 
       RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"PCOfPU", "[", "PU", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeScaleP", "[", "x_", "]"}], ":=", 
   RowBox[{"ErrorMessage", "[", 
    RowBox[{
     RowBox[{"RawGraphics", "::", "badpoint"}], ",", "Expr"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
TO DO: Implement and test for general point P and for Scaled as well.\
\>", "Text",
 CellChangeTimes->{{3.460830488625*^9, 3.46083050353125*^9}, {
  3.460830542125*^9, 3.4608305469375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpecialPointRules", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"dP", ":", 
        RowBox[{"{", 
         RowBox[{"dx_", ",", "dy_"}], "}"}]}], ",", 
       RowBox[{"P", ":", 
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}]}]}], "]"}], "\[RuleDelayed]", 
     RowBox[{"(", 
      RowBox[{"P", "+", 
       RowBox[{"DPUOfPA", "[", "dP", "]"}]}], ")"}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.460830414625*^9, 3.460830422296875*^9}, 
   3.46083052434375*^9}],

Cell["\<\
Note on conversion of Graphics to SchemeGraphics:
A finished SchemeGraphics is of the form \
SchemeGraphics[{directives},{primatives},LayerSpec], satisfying the following \
assumptions:
\tAll relevant graphics properties are specified by {directives} -- color, \
thickness (if lines present), dashing (if lines present).
\tThe top layer of {primatives} does not contain directives.  (This prevents \
side effects when {primatives} is joined to other lists.)
SchemeGraphics are produced directly in this form by the Make.... functions.  \

The primatives in raw Graphics objects can in general not be trusted and must \
be quarantined in a sublist.\
\>", "Text",
 CellChangeTimes->{3.3955204155*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"basic", " ", 
    RowBox[{"case", " ", "--"}], "Graphics", " ", "with", " ", "only", " ", 
    "primatives", " ", "list", " ", "as", " ", "argument"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"RawGraphics", "[", 
      RowBox[{
       RowBox[{"GraphicsSeq", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Graphics", "[", "_List", "]"}], "..."}], ")"}]}], ",", 
       RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FullOpts", "=", 
          RowBox[{"FigRealizeOptions", "[", 
           RowBox[{"RawGraphics", ",", "Opts"}], "]"}]}], ",", 
         "\[IndentingNewLine]", "ScaledGraphicsList", ",", 
         "ClippedGraphicsList", ",", "Result"}], "\[IndentingNewLine]", "}"}],
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"CheckOption", "[", 
         RowBox[{"ClipToRectangle", ",", 
          RowBox[{"True", "|", "False", "|", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
          "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"CheckOption", "[", 
         RowBox[{"Show", ",", 
          RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"CheckOption", "[", 
         RowBox[{"Debug", ",", 
          RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Debug", "/.", "FullOpts"}], ",", 
          RowBox[{"Print", "[", "\"\<RawGraphics: Given\>\"", "]"}]}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Debug", "/.", "FullOpts"}], ",", 
          RowBox[{"Print", "[", 
           RowBox[{"First", "/@", 
            RowBox[{"{", "GraphicsSeq", "}"}]}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Debug", "/.", "FullOpts"}], ",", 
          RowBox[{"Print", "[", "\"\<RawGraphics: Scaling\>\"", "]"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"ScaledGraphicsList", "=", 
         RowBox[{
          RowBox[{"{", "GraphicsSeq", "}"}], "/.", "SpecialPointRules"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"ScaledGraphicsList", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"TransformGraphics", "[", 
             RowBox[{"#", ",", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"SchemeScaleP", "[", "#", "]"}], "&"}], ")"}]}], 
             "]"}], "&"}], ")"}], "/@", "ScaledGraphicsList"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Debug", "/.", "FullOpts"}], ",", 
          RowBox[{"Print", "[", 
           RowBox[{"First", "/@", "ScaledGraphicsList"}], "]"}]}], "]"}], ";",
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Debug", "/.", "FullOpts"}], ",", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<RawGraphics: Cropping \>\"", ",", "$RegionRange"}], 
           "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"ClippedGraphicsList", "=", 
         RowBox[{"Switch", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ClipToRectangle", "/.", "FullOpts"}], ",", 
           "\[IndentingNewLine]", "True", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ClipToRectangle", "[", 
               RowBox[{"$RegionRange", ",", "#"}], "]"}], "&"}], ")"}], "/@", 
            "ScaledGraphicsList"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ClipToRectangle", "[", 
               RowBox[{
                RowBox[{"ConvertCoordinate", "[", 
                 RowBox[{"RegionCoords", ",", "CanvasCoords", ",", "C", ",", 
                  RowBox[{"ClipToRectangle", "/.", "FullOpts"}]}], "]"}], ",",
                 "#"}], "]"}], "&"}], ")"}], "/@", "ScaledGraphicsList"}], 
           ",", "\[IndentingNewLine]", "False", ",", "ScaledGraphicsList"}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Debug", "/.", "FullOpts"}], ",", 
          RowBox[{"Print", "[", 
           RowBox[{"First", "/@", "ClippedGraphicsList"}], "]"}]}], "]"}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Debug", "/.", "FullOpts"}], ",", 
          RowBox[{"Print", "[", "\"\<RawGraphics: Making\>\"", "]"}]}], "]"}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"Result", "=", 
         RowBox[{"MakeRawGraphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"First", "/@", "ClippedGraphicsList"}], "}"}], ",", 
           "FullOpts"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Debug", "/.", "FullOpts"}], ",", 
          RowBox[{"Print", "[", "Result", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "Result"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "typecast", " ", "ContourGraphics", " ", "or", " ", "DensityGraphics", 
     " ", "to", " ", "Graphics"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"RawGraphics", "[", 
      RowBox[{"X___", ",", 
       RowBox[{"G", ":", 
        RowBox[{"(", 
         RowBox[{"_ContourGraphics", "|", "_DensityGraphics"}], ")"}]}], ",", 
       "Y___"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"RawGraphics", "[", 
        RowBox[{"X", ",", 
         RowBox[{"Graphics", "[", "G", "]"}], ",", "Y"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"strip", " ", "graphics", " ", "options"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RawGraphics", "[", 
      RowBox[{"X___", ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Arg_", ",", 
         RowBox[{"__", "?", "OptionQ"}]}], "]"}], ",", "Y___"}], "]"}], ":=", 
     
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"RawGraphics", "[", 
        RowBox[{"X", ",", 
         RowBox[{"Graphics", "[", "Arg", "]"}], ",", "Y"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "discard", " ", "graphics", " ", "with", " ", "no", " ", "argument"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RawGraphics", "[", 
      RowBox[{"X___", ",", 
       RowBox[{"Graphics", "[", "]"}], ",", "Y___"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{"RawGraphics", "::", "empty"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"RawGraphics", "[", 
         RowBox[{"X", ",", "Y"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"wrap", " ", "any", " ", "non"}], "-", 
     RowBox[{
     "list", " ", "first", " ", "element", " ", "of", " ", "graphics", " ", 
      RowBox[{"object", " ", "--"}], " ", "syntax", " ", "not", " ", 
      "documented", " ", "by", " ", "Mathematica", " ", "but", " ", 
      "supported", " ", "by", " ", "show", " ", "and", " ", "can", " ", 
      "occur", " ", "in", " ", "Graphics", " ", "cast", " ", "of", " ", 
      "DensityGraphics"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"RawGraphics", "[", 
      RowBox[{"X___", ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Primative_", "/;", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Head", "[", "Primative", "]"}], "=!=", "List"}], ")"}]}], 
        "]"}], ",", "Y___"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"RawGraphics", "[", 
        RowBox[{"X", ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", "Primative", "}"}], "]"}], ",", "Y"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "discard", " ", "graphics", " ", "with", " ", "more", " ", "than", " ", 
      "one", " ", "non"}], "-", 
     RowBox[{"option", " ", "argument"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RawGraphics", "[", 
      RowBox[{"X___", ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"_", ",", "___", ",", 
         RowBox[{"Arg", "/;", 
          RowBox[{"(", 
           RowBox[{"!", 
            RowBox[{"OptionQ", "[", "Arg", "]"}]}], ")"}]}], ",", "___"}], 
        "]"}], ",", "Y___"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{"RawGraphics", "::", "multiarg"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"RawGraphics", "[", 
         RowBox[{"X", ",", "Y"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39636969540625*^9, 3.396369700890625*^9}, {
   3.396543699984375*^9, 3.3965437014375*^9}, {3.3965522750625*^9, 
   3.396552276296875*^9}, {3.396552318015625*^9, 3.3965523268125*^9}, {
   3.460830268984375*^9, 3.46083031690625*^9}, {3.460830406234375*^9, 
   3.460830410734375*^9}, {3.488282684859375*^9, 3.488282688125*^9}, 
   3.49605569853125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure graphics -- UNDER DEVELOPMENT", "Subsection",
 CellChangeTimes->{{3.488282719*^9, 3.4882827269375*^9}}],

Cell["\<\
FigGraphics

for Image:
\trectangle required
\tuses Inset for display
\ttherefore no clipping possible
for Graphics:
\tallow single graphics to be enclosed in List -- pandering to Import result \
for PDF
\t*if* rectangle specified
\tuses Inset for display
\ttherefore no clipping possible
\
\>", "Text",
 CellChangeTimes->{{3.488832095390625*^9, 3.488832128765625*^9}, {
  3.488832221359375*^9, 3.488832233328125*^9}, {3.488834352828125*^9, 
  3.488834370515625*^9}, {3.488835161046875*^9, 3.488835177953125*^9}, {
  3.48883521059375*^9, 3.488835216578125*^9}, {3.488836978796875*^9, 
  3.4888369951875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FigGraphics", "[", 
    RowBox[{
     RowBox[{"UserRegion", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{
      RowBox[{"(", "x_Image", ")"}], "|", 
      RowBox[{"(", "x_Graphics", ")"}], "|", 
      RowBox[{"{", 
       RowBox[{"(", "x_Graphics", ")"}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"RawGraphics", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "CanvasRegion", ",", "CanvasCenter", ",", 
       "CanvasSize", ",", "Art"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Debug", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "calculate", " ", "center", " ", "and", " ", "size", " ", 
        "coordinates", " ", "for", " ", "image", " ", "inset"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"CanvasRegion", "=", 
       RowBox[{"ConvertRegion", "[", 
        RowBox[{"UserCoords", ",", "CanvasCoords", ",", "UserRegion"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"CanvasCenter", "=", 
       RowBox[{"Mean", "/@", "CanvasRegion"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"CanvasSize", "=", 
       RowBox[{"-", 
        RowBox[{"Subtract", "@@@", "CanvasRegion"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"generate", " ", "art"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Debug", "/.", "FullOpts"}], ")"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"Head", "[", "x", "]"}], "]"}], ";", "\[IndentingNewLine]", 
         
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Head", "[", "x", "]"}], "\[Equal]", "Graphics"}], ",", 
           RowBox[{"Print", "[", 
            RowBox[{"Short", "[", 
             RowBox[{"First", "[", "x", "]"}], "]"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"Rest", "[", 
           RowBox[{"List", "@@", "x"}], "]"}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Art", "=", 
       RowBox[{"{", 
        RowBox[{"Inset", "[", 
         RowBox[{"x", ",", "CanvasCenter", ",", "Center", ",", "CanvasSize"}],
          "]"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"MakeVerbatim", "[", 
       RowBox[{"Art", ",", "FullOpts"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39636969540625*^9, 3.396369700890625*^9}, {
   3.396543699984375*^9, 3.3965437014375*^9}, {3.3965522750625*^9, 
   3.396552276296875*^9}, {3.396552318015625*^9, 3.3965523268125*^9}, {
   3.460830268984375*^9, 3.46083031690625*^9}, {3.460830406234375*^9, 
   3.460830410734375*^9}, {3.488282684859375*^9, 3.488282688125*^9}, {
   3.48828273778125*^9, 3.4882828114375*^9}, {3.4882829623125*^9, 
   3.48828296775*^9}, {3.488283093578125*^9, 3.488283100046875*^9}, {
   3.488832141921875*^9, 3.488832145203125*^9}, 3.48883224596875*^9, {
   3.488832417390625*^9, 3.488832452609375*^9}, {3.48883248421875*^9, 
   3.4888325426875*^9}, {3.48883260078125*^9, 3.488832737328125*^9}, {
   3.4888327960625*^9, 3.48883281834375*^9}, {3.4888328816875*^9, 
   3.48883292146875*^9}, {3.48883320928125*^9, 3.48883324209375*^9}, {
   3.488833509890625*^9, 3.488833513015625*^9}, {3.48883354959375*^9, 
   3.48883358196875*^9}, {3.488833642765625*^9, 3.48883367509375*^9}, 
   3.48883407475*^9, {3.488835282390625*^9, 3.488835302859375*^9}, {
   3.48883564228125*^9, 3.488835721546875*^9}, {3.488836950859375*^9, 
   3.488837004875*^9}, 3.496055698546875*^9}],

Cell["\<\
Unlike RawGraphics, FigGraphics accepts just a single graphics primative and \
makes use of its plot range options.\
\>", "Text",
 CellChangeTimes->{{3.488282803171875*^9, 3.488282822125*^9}, {
  3.4882828655625*^9, 3.488282873453125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FigGraphics", "[", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"GPrimatives_List", ",", "GOptionSeq___"}], "]"}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"FullOpts", "=", 
         RowBox[{"FigRealizeOptions", "[", 
          RowBox[{"RawGraphics", ",", "Opts"}], "]"}]}], ",", 
        "\[IndentingNewLine]", "ScaledGraphicsList", ",", 
        "ClippedGraphicsList", ",", "Result"}], "\[IndentingNewLine]", "}"}], 
      ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"ClipToRectangle", ",", 
         RowBox[{"True", "|", "False", "|", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
         "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"Show", ",", 
         RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"CheckOption", "[", 
        RowBox[{"Debug", ",", 
         RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"TO", " ", "WRITE"}], "..."}], " ", "*)"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Debug", "/.", "FullOpts"}], ",", 
         RowBox[{"Print", "[", "\"\<RawGraphics: Scaling\>\"", "]"}]}], "]"}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"ScaledGraphicsList", "=", 
        RowBox[{
         RowBox[{"{", "GraphicsSeq", "}"}], "/.", "SpecialPointRules"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"ScaledGraphicsList", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"TransformGraphics", "[", 
            RowBox[{"#", ",", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"SchemeScaleP", "[", "#", "]"}], "&"}], ")"}]}], "]"}],
            "&"}], ")"}], "/@", "ScaledGraphicsList"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Debug", "/.", "FullOpts"}], ",", 
         RowBox[{"Print", "[", 
          RowBox[{"First", "/@", "ScaledGraphicsList"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Debug", "/.", "FullOpts"}], ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<RawGraphics: Cropping \>\"", ",", "$RegionRange"}], 
          "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"ClippedGraphicsList", "=", 
        RowBox[{"Switch", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ClipToRectangle", "/.", "FullOpts"}], ",", 
          "\[IndentingNewLine]", "True", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ClipToRectangle", "[", 
              RowBox[{"$RegionRange", ",", "#"}], "]"}], "&"}], ")"}], "/@", 
           "ScaledGraphicsList"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ClipToRectangle", "[", 
              RowBox[{
               RowBox[{"ConvertCoordinate", "[", 
                RowBox[{"RegionCoords", ",", "CanvasCoords", ",", "C", ",", 
                 RowBox[{"ClipToRectangle", "/.", "FullOpts"}]}], "]"}], ",", 
               "#"}], "]"}], "&"}], ")"}], "/@", "ScaledGraphicsList"}], ",", 
          "\[IndentingNewLine]", "False", ",", "ScaledGraphicsList"}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Debug", "/.", "FullOpts"}], ",", 
         RowBox[{"Print", "[", 
          RowBox[{"First", "/@", "ClippedGraphicsList"}], "]"}]}], "]"}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Debug", "/.", "FullOpts"}], ",", 
         RowBox[{"Print", "[", "\"\<RawGraphics: Making\>\"", "]"}]}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"Result", "=", 
        RowBox[{"MakeRawGraphics", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"First", "/@", "ClippedGraphicsList"}], "}"}], ",", 
          "FullOpts"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Debug", "/.", "FullOpts"}], ",", 
         RowBox[{"Print", "[", "Result", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "Result"}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "typecast", " ", "ContourGraphics", " ", "or", " ", "DensityGraphics", " ",
     "to", " ", "Graphics"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RawGraphics", "[", 
     RowBox[{"X___", ",", 
      RowBox[{"G", ":", 
       RowBox[{"(", 
        RowBox[{"_ContourGraphics", "|", "_DensityGraphics"}], ")"}]}], ",", 
      "Y___"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"RawGraphics", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Graphics", "[", "G", "]"}], ",", "Y"}], "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"strip", " ", "graphics", " ", "options"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RawGraphics", "[", 
     RowBox[{"X___", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Arg_", ",", 
        RowBox[{"__", "?", "OptionQ"}]}], "]"}], ",", "Y___"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"RawGraphics", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Graphics", "[", "Arg", "]"}], ",", "Y"}], "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "discard", " ", "graphics", " ", "with", " ", "no", " ", "argument"}], " ",
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RawGraphics", "[", 
     RowBox[{"X___", ",", 
      RowBox[{"Graphics", "[", "]"}], ",", "Y___"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Message", "[", 
        RowBox[{"RawGraphics", "::", "empty"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"RawGraphics", "[", 
        RowBox[{"X", ",", "Y"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"wrap", " ", "any", " ", "non"}], "-", 
    RowBox[{
    "list", " ", "first", " ", "element", " ", "of", " ", "graphics", " ", 
     RowBox[{"object", " ", "--"}], " ", "syntax", " ", "not", " ", 
     "documented", " ", "by", " ", "Mathematica", " ", "but", " ", 
     "supported", " ", "by", " ", "show", " ", "and", " ", "can", " ", 
     "occur", " ", "in", " ", "Graphics", " ", "cast", " ", "of", " ", 
     "DensityGraphics"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RawGraphics", "[", 
     RowBox[{"X___", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Primative_", "/;", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Head", "[", "Primative", "]"}], "=!=", "List"}], ")"}]}], 
       "]"}], ",", "Y___"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"RawGraphics", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", "Primative", "}"}], "]"}], ",", "Y"}], "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "discard", " ", "graphics", " ", "with", " ", "more", " ", "than", " ", 
     "one", " ", "non"}], "-", 
    RowBox[{"option", " ", "argument"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RawGraphics", "[", 
    RowBox[{"X___", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"_", ",", "___", ",", 
       RowBox[{"Arg", "/;", 
        RowBox[{"(", 
         RowBox[{"!", 
          RowBox[{"OptionQ", "[", "Arg", "]"}]}], ")"}]}], ",", "___"}], 
      "]"}], ",", "Y___"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Message", "[", 
       RowBox[{"RawGraphics", "::", "multiarg"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"RawGraphics", "[", 
       RowBox[{"X", ",", "Y"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39636969540625*^9, 3.396369700890625*^9}, {
   3.396543699984375*^9, 3.3965437014375*^9}, {3.3965522750625*^9, 
   3.396552276296875*^9}, {3.396552318015625*^9, 3.3965523268125*^9}, {
   3.460830268984375*^9, 3.46083031690625*^9}, {3.460830406234375*^9, 
   3.460830410734375*^9}, {3.488282684859375*^9, 3.488282688125*^9}, {
   3.48828273778125*^9, 3.4882828114375*^9}, {3.4882829623125*^9, 
   3.48828296775*^9}, {3.488283093578125*^9, 3.488283100046875*^9}, 
   3.488835820265625*^9, 3.496055698546875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Raw graphics 3D", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RawGraphics3D", "[", 
    RowBox[{
     RowBox[{"GraphicsSeq", ":", 
      RowBox[{"(", 
       RowBox[{"___", "?", "Graphics3DQ"}], ")"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"RawGraphics3D", ",", "Opts"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Debug", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"MakeRawGraphics3D", "[", 
       RowBox[{
        RowBox[{"First", "/@", 
         RowBox[{"{", "GraphicsSeq", "}"}]}], ",", "FullOpts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.4960556985625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3D viewport", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Graphics3DQ", "[", "_Graphics3D", "]"}], "=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Graphics3DQ", "[", "_", "]"}], "=", "False"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.510069510171875*^9, 3.5100695111875*^9}, {
  3.510069568375*^9, 3.51006958478125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"drop", " ", "nongraphical"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CombineGraphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"U___", ",", 
        RowBox[{"X_", "/;", 
         RowBox[{"(", 
          RowBox[{"!", 
           RowBox[{"MatchQ", "[", 
            RowBox[{"X", ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"_", "?", "Graphics3DQ"}], ")"}], "|", 
              RowBox[{"(", "_SurfaceGraphics", ")"}]}]}], "]"}]}], ")"}]}], 
        ",", "V___"}], "}"}], "]"}], ":=", 
     RowBox[{"CombineGraphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"U", ",", "V"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"convert", " ", "SurfaceGraphics", " ", "to", " ", "Graphics3D"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CombineGraphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"U___", ",", "X_SurfaceGraphics", ",", "V___"}], "}"}], "]"}], 
     ":=", 
     RowBox[{"CombineGraphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"U", ",", 
        RowBox[{"Graphics3D", "[", "X", "]"}], ",", "V"}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"do", " ", 
     RowBox[{"combination", " ", "--"}], " ", "primatives", " ", 
     "quarantined", " ", "in", " ", "sublists"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CombineGraphics3D", "[", 
      RowBox[{"GList", ":", 
       RowBox[{"{", 
        RowBox[{"___", "?", "Graphics3DQ"}], "}"}]}], "]"}], ":=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"First", "/@", "GList"}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->True],

Cell["\<\
Use Sign +1 for active rotation in RH sense, -1 for passive rotation in RH \
sense.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AxisRotationMatrix", "[", 
    RowBox[{"1", ",", "theta_", ",", 
     RowBox[{"Sign", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"+", "1"}], "|", 
        RowBox[{"-", "1"}]}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Cos", "[", "theta", "]"}], ",", 
       RowBox[{
        RowBox[{"-", "Sign"}], "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"+", "Sign"}], "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AxisRotationMatrix", "[", 
    RowBox[{"2", ",", "theta_", ",", 
     RowBox[{"Sign", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"+", "1"}], "|", 
        RowBox[{"-", "1"}]}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "theta", "]"}], ",", "0", ",", 
       RowBox[{
        RowBox[{"+", "Sign"}], "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "Sign"}], "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], ",", "0", ",", 
       RowBox[{"Cos", "[", "theta", "]"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AxisRotationMatrix", "[", 
    RowBox[{"3", ",", "theta_", ",", 
     RowBox[{"Sign", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"+", "1"}], "|", 
        RowBox[{"-", "1"}]}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "theta", "]"}], ",", 
       RowBox[{
        RowBox[{"-", "Sign"}], "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "Sign"}], "*", 
        RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
       RowBox[{"Cos", "[", "theta", "]"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationMatrix3DActiveY", "[", 
    RowBox[{"{", 
     RowBox[{"alpha_", ",", "beta_", ",", "gamma_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AxisRotationMatrix", "[", 
     RowBox[{"3", ",", "gamma", ",", 
      RowBox[{"+", "1"}]}], "]"}], ".", 
    RowBox[{"AxisRotationMatrix", "[", 
     RowBox[{"2", ",", "beta", ",", 
      RowBox[{"+", "1"}]}], "]"}], ".", 
    RowBox[{"AxisRotationMatrix", "[", 
     RowBox[{"3", ",", "alpha", ",", 
      RowBox[{"+", "1"}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"BasicViewPort3D", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BasicViewPort3D", "[", 
    RowBox[{"GList_List", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1c_", "?", "NumericQ"}], ",", 
         RowBox[{"x2c_", "?", "NumericQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y1c_", "?", "NumericQ"}], ",", 
         RowBox[{"y2c_", "?", "NumericQ"}]}], "}"}]}], "}"}], ",", 
     "FullOpts_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "ScaledGraphicsList", ",", "ClippedGraphicsList", ",", "Result", ",", 
       "\[IndentingNewLine]", "Primatives", ",", "RotationMatrix", ",", 
       "UsedOptions"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Background", ",", 
        RowBox[{"None", "|", "ColorDirectivePattern"}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"BackgroundOpacity", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"BlockOptions", ",", 
        RowBox[{"{", "___Symbol", "}"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Debug", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"EulerRotation", ",", 
        RowBox[{"None", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PlotRange", ",", 
        RowBox[{"Automatic", "|", "All", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}]}], "]"}], ";", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"AxisScaling", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"AxisScaling", "/.", "FullOpts"}], ")"}], "=!=", 
           "Automatic"}], ")"}], "&&", 
         RowBox[{"!", 
          RowBox[{"MatchQ", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"PlotRange", "/.", "FullOpts"}], ")"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"_", "?", "NumericQ"}], ",", 
                RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"_", "?", "NumericQ"}], ",", 
                RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"_", "?", "NumericQ"}], ",", 
                RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], "]"}]}]}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{"ViewPort3D", "::", "prange"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Primatives", "=", 
       RowBox[{"BlockOptions", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Union", "[", 
          RowBox[{"OptionSymbols3D", ",", 
           RowBox[{"(", 
            RowBox[{"BlockOptions", "/.", "FullOpts"}], ")"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"First", "[", 
          RowBox[{"CombineGraphics3D", "[", 
           RowBox[{"Flatten", "[", "GList", "]"}], "]"}], "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"EulerRotation", "/.", "FullOpts"}], ")"}], "=!=", "None"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"RotationMatrix", "=", 
          RowBox[{"RotationMatrix3DActiveY", "[", 
           RowBox[{"EulerRotation", "/.", "FullOpts"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Primatives", "=", 
          RowBox[{"GeometricTransformation", "[", 
           RowBox[{"Primatives", ",", "RotationMatrix"}], "]"}]}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Debug", "/.", "FullOpts"}], ")"}], ",", 
        RowBox[{"Print", "[", "Primatives", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"UsedOptions", "=", 
       RowBox[{"OptionsUnion", "[", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"AxisScaling", "/.", "FullOpts"}], ")"}], "===", 
             "Automatic"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"BoxRatios", "\[Rule]", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"AxisScaling", "/.", "FullOpts"}], ")"}], "*", 
               RowBox[{"-", 
                RowBox[{"Subtract", "@@@", 
                 RowBox[{"(", 
                  RowBox[{"PlotRange", "/.", "FullOpts"}], ")"}]}]}]}]}], 
             "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"LegacyFilterOptions", "[", 
           RowBox[{"Graphics3D", ",", "FullOpts"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Debug", "/.", "FullOpts"}], ")"}], ",", 
        RowBox[{"Print", "[", "UsedOptions", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "background", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Background", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Rectangle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1c", ",", "y1c"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"x2c", ",", "y2c"}], "}"}]}], "]"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Color", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"Background", "/.", "FullOpts"}], ")"}]}], ",", 
            RowBox[{"Opacity", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"BackgroundOpacity", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ShowFill", "\[Rule]", "True"}], ",", 
            RowBox[{"FillColor", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"FillOpacity", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"ClipToRectangle", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], "\[IndentingNewLine]", 
           "]"}]}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "contents", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"MakeVerbatim", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x1c", ",", "y1c"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2c", ",", "y2c"}], "}"}], ",", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"Primatives", ",", "UsedOptions"}], "]"}]}], "]"}], 
           "}"}], ",", "\[IndentingNewLine]", "FullOpts"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.395089864515625*^9, {3.395091949265625*^9, 3.39509195153125*^9}, {
   3.396636964921875*^9, 3.396636997796875*^9}, {3.396637196*^9, 
   3.396637197234375*^9}, {3.4596977549375*^9, 3.4596977893125*^9}, 
   3.4596978650625*^9, {3.45969789696875*^9, 3.459697898265625*^9}, {
   3.51006991609375*^9, 3.5100700115*^9}, {3.51007006371875*^9, 
   3.51007007396875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ViewPort3D", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ViewPort3D", "[", 
    RowBox[{"GList_List", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1_", "?", "NumericQ"}], ",", 
         RowBox[{"x2_", "?", "NumericQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y1_", "?", "NumericQ"}], ",", 
         RowBox[{"y2_", "?", "NumericQ"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"ViewPort3D", ",", "Opts"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BasicViewPort3D", "[", 
      RowBox[{"GList", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"XCOfXU", "/@", 
          RowBox[{"{", 
           RowBox[{"x1", ",", "x2"}], "}"}]}], ",", 
         RowBox[{"YCOfYU", "/@", 
          RowBox[{"{", 
           RowBox[{"y1", ",", "y2"}], "}"}]}]}], "}"}], ",", "FullOpts"}], 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ScaledViewPort3D", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScaledViewPort3D", "[", 
    RowBox[{"GList_List", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1s_", "?", "NumericQ"}], ",", 
         RowBox[{"x2s_", "?", "NumericQ"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y1s_", "?", "NumericQ"}], ",", 
         RowBox[{"y2s_", "?", "NumericQ"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"ScaledViewPort3D", ",", "Opts"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BasicViewPort3D", "[", 
      RowBox[{"GList", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"XCOfXS", "/@", 
          RowBox[{"{", 
           RowBox[{"x1s", ",", "x2s"}], "}"}]}], ",", 
         RowBox[{"YCOfYS", "/@", 
          RowBox[{"{", 
           RowBox[{"y1s", ",", "y2s"}], "}"}]}]}], "}"}], ",", "FullOpts"}], 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.39509195228125*^9, 3.395091959875*^9}, {
  3.4960556985625*^9, 3.496055698578125*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Axes and panels", "Section"],

Cell[CellGroupData[{

Cell["Basic axis object", "Subsection"],

Cell["\<\
BasicAxis draws a line segment, arrowhead, tick marks, and tick labels.
Ticks must be in full explicit form.  All coordinates, including tick \
lengths, must be in canvas coordinates.
The \"unneeded\" coordinate for the axis may have any value, not necessarily \
even numeric, since it is never referenced\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicAxis", "[", 
    RowBox[{"Caller_Symbol", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "x2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y1_", ",", "y2_"}], "}"}]}], "}"}], ",", 
     RowBox[{"Axis", ":", 
      RowBox[{"(", 
       RowBox[{"1", "|", "2", "|", "3", "|", "4"}], ")"}]}], ",", 
     RowBox[{"ShowAxis", ":", 
      RowBox[{"(", 
       RowBox[{"True", "|", "False"}], ")"}]}], ",", 
     RowBox[{"ShowHead", ":", 
      RowBox[{"(", 
       RowBox[{"True", "|", "False"}], ")"}]}], ",", "Ticks_List", ",", 
     "FullOpts_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "Segment", ",", "HalfWidthForLabels", ",", "Buffer", ",", "Posn", ",", 
       "P", ",", "\[IndentingNewLine]", "TickData", ",", "TickPosn", ",", 
       "TickText", ",", "TickLengths", ",", "TickAttributes", ",", 
       "\[IndentingNewLine]", "TickPoint", ",", "TickEndPoints", ",", 
       "TickOffset", ",", "TickLabelPoint", ",", "\[IndentingNewLine]", 
       "TickLineGraphics", ",", "TickLineArt", ",", "TickTextGraphics", ",", 
       "\[IndentingNewLine]", "LabelGraphics"}], "\[IndentingNewLine]", "}"}],
      ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"calculate", " ", "geometry"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Segment", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"Axis", ",", "\[IndentingNewLine]", "1", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "y1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", "y1"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", "2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "y1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x1", ",", "y2"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", "3", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "y2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", "y2"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", "4", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x2", ",", "y1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", "y2"}], "}"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"construct", " ", "ticks"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"TickLineArt", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TickTextGraphics", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "TickPosn", ",", "TickText", ",", "TickLengths", ",", 
            "TickAttributes"}], "}"}], "=", "TickData"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"TickText", "===", "\"\<\>\""}], ",", 
           RowBox[{"TickText", "=", "None"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Switch", "[", "\[IndentingNewLine]", 
          RowBox[{
          "Axis", ",", "\[IndentingNewLine]", "1", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"TickPoint", "=", 
             RowBox[{"{", 
              RowBox[{"TickPosn", ",", "y1"}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"TickEndPoints", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TickPoint", "+", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"TickLengths", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ",", 
               RowBox[{"TickPoint", "-", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"TickLengths", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"TickOffset", "=", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"+", "1"}]}], "}"}]}]}], ",", "\[IndentingNewLine]", 
           "2", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"TickPoint", "=", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "TickPosn"}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"TickEndPoints", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TickPoint", "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"TickLengths", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", "0"}], "}"}]}], ",", 
               RowBox[{"TickPoint", "-", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"TickLengths", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}]}]}], 
              "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"TickOffset", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"+", "1"}], ",", "0"}], "}"}]}]}], ",", 
           "\[IndentingNewLine]", "3", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"TickPoint", "=", 
             RowBox[{"{", 
              RowBox[{"TickPosn", ",", "y2"}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"TickEndPoints", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TickPoint", "-", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"TickLengths", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ",", 
               RowBox[{"TickPoint", "+", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"TickLengths", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"TickOffset", "=", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}]}]}], ",", "\[IndentingNewLine]", 
           "4", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"TickPoint", "=", 
             RowBox[{"{", 
              RowBox[{"x2", ",", "TickPosn"}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"TickEndPoints", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TickPoint", "-", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"TickLengths", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", "0"}], "}"}]}], ",", 
               RowBox[{"TickPoint", "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"TickLengths", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}]}]}], 
              "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"TickOffset", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"TickLabelPoint", "=", 
          RowBox[{"TickPoint", "+", 
           RowBox[{"DPCOfPA", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"Thickness", "/.", "FullOpts"}], ")"}]}], "/", "2"}], 
             "*", "TickOffset"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Chop", "[", 
             RowBox[{"DPAOfPC", "[", 
              RowBox[{"Subtract", "@@", "TickEndPoints"}], "]"}], "]"}], "!=", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"TickLineArt", ",", 
             RowBox[{"Join", "[", 
              RowBox[{"TickAttributes", ",", 
               RowBox[{"{", 
                RowBox[{"Line", "[", "TickEndPoints", "]"}], "}"}]}], "]"}]}],
             "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"TickText", "=!=", "None"}], ",", "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", "\[IndentingNewLine]", 
            RowBox[{"TickTextGraphics", ",", "\[IndentingNewLine]", 
             RowBox[{"MakeText", "[", 
              RowBox[{
              "TickText", ",", "TickLabelPoint", ",", "0", ",", 
               "\[IndentingNewLine]", 
               RowBox[{"ShowText", "\[Rule]", "True"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Offset", "\[Rule]", "TickOffset"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Nudge", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{"TickNudge", "/.", "FullOpts"}], ")"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Orientation", "\[Rule]", "0"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Background", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"TickBackground", ",", "None", ",", "FullOpts"}], 
                 "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"FontFamily", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"TickFontFamily", ",", 
                  RowBox[{"FontFamily", "/.", "FullOpts"}], ",", "FullOpts"}],
                  "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"FontSize", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"TickFontSize", ",", 
                  RowBox[{"FontSize", "/.", "FullOpts"}], ",", "FullOpts"}], 
                 "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"FontWeight", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"TickFontWeight", ",", 
                  RowBox[{"FontWeight", "/.", "FullOpts"}], ",", "FullOpts"}],
                  "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"FontSlant", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"TickFontSlant", ",", 
                  RowBox[{"FontSlant", "/.", "FullOpts"}], ",", "FullOpts"}], 
                 "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"FontTracking", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"TickFontTracking", ",", 
                  RowBox[{"FontTracking", "/.", "FullOpts"}], ",", 
                  "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"FontColor", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"TickFontColor", ",", 
                  RowBox[{"FontColor", "/.", "FullOpts"}], ",", "FullOpts"}], 
                 "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"FontOpacity", "\[Rule]", 
                RowBox[{"GetAutoOption", "[", 
                 RowBox[{"TickFontOpacity", ",", 
                  RowBox[{"FontOpacity", "/.", "FullOpts"}], ",", 
                  "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
               "FullOpts"}], " ", 
              RowBox[{"(*", " ", 
               RowBox[{
               "pass", " ", "on", " ", "default", " ", "color", " ", "and", 
                " ", "optional", " ", "Layer", " ", "from", " ", "FullOpts"}],
                " ", "*)"}], "\[IndentingNewLine]", "]"}]}], 
            "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"TickData", ",", "Ticks"}], "}"}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"TickLineGraphics", "=", 
       RowBox[{"MakeOutline", "[", 
        RowBox[{
         RowBox[{
         "{", "\[IndentingNewLine]", "TickLineArt", "\[IndentingNewLine]", 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Dashing", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ShowLine", "->", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"TickShowLine", ",", 
            RowBox[{"ShowLine", "/.", "FullOpts"}], ",", "FullOpts"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"LineColor", "->", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"TickLineColor", ",", 
            RowBox[{"LineColor", "/.", "FullOpts"}], ",", "FullOpts"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"LineOpacity", "->", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"TickLineOpacity", ",", 
            RowBox[{"LineOpacity", "/.", "FullOpts"}], ",", "FullOpts"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Thickness", "->", 
          RowBox[{"GetAutoOption", "[", 
           RowBox[{"TickThickness", ",", 
            RowBox[{"Thickness", "/.", "FullOpts"}], ",", "FullOpts"}], 
           "]"}]}], ",", "\[IndentingNewLine]", "FullOpts"}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"construct", " ", "axis", " ", "label"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "basic", " ", "spacing", " ", "provided", " ", "by", " ", "Offset"}], 
        ",", " ", 
        RowBox[{"additional", " ", "by", " ", "Buffer"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"HalfWidthForLabels", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Thickness", "/.", "FullOpts"}], ")"}], "/", "2"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Buffer", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{
         RowBox[{"Switch", "[", 
          RowBox[{
          "Axis", ",", "1", ",", "BufferB", ",", "2", ",", "BufferL", ",", 
           "3", ",", "BufferT", ",", "4", ",", "BufferR"}], "]"}], ",", "1.1",
          ",", "FullOpts"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Posn", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{
         RowBox[{"Switch", "[", 
          RowBox[{
          "Axis", ",", "1", ",", "PosnB", ",", "2", ",", "PosnL", ",", "3", 
           ",", "PosnT", ",", "4", ",", "PosnR"}], "]"}], ",", "0.5", ",", 
         "FullOpts"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"P", "=", 
       RowBox[{"PCOfPA", "@", 
        RowBox[{"ArrowPoint", "[", 
         RowBox[{"Caller", ",", 
          RowBox[{"PAOfPC", "/@", "Segment"}], ",", "AtUserPosition", ",", 
          "Posn", ",", 
          RowBox[{
           RowBox[{"Switch", "[", 
            RowBox[{"Axis", ",", 
             RowBox[{"1", "|", "4"}], ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"2", "|", "3"}], ",", 
             RowBox[{"+", "1"}]}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"HalfWidthForLabels", "+", 
             RowBox[{
              RowBox[{"Buffer", "/", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{"FontSize", "/.", "FullOpts"}], ")"}]}]}], ")"}]}]}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"LabelGraphics", "=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"Switch", "[", "\[IndentingNewLine]", 
         RowBox[{
         "Axis", ",", "\[IndentingNewLine]", "1", ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeText", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"LabB", "/.", "FullOpts"}], ")"}], ",", "P", ",", "0", 
            ",", "\[IndentingNewLine]", 
            RowBox[{"ShowText", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"ShowLabB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Offset", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetB", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Nudge", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"NudgeB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Orientation", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"OrientationB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "->", 
             RowBox[{"(", 
              RowBox[{"BackgroundB", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
           "]"}], ",", "\[IndentingNewLine]", "2", ",", "\[IndentingNewLine]", 
          RowBox[{"MakeText", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"LabL", "/.", "FullOpts"}], ")"}], ",", "P", ",", 
            RowBox[{
             RowBox[{"-", "Pi"}], "/", "2"}], ",", "\[IndentingNewLine]", 
            RowBox[{"ShowText", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"ShowLabL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Offset", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetL", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Nudge", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"NudgeL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Orientation", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"OrientationL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "->", 
             RowBox[{"(", 
              RowBox[{"BackgroundL", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
           "]"}], ",", "\[IndentingNewLine]", "3", ",", "\[IndentingNewLine]", 
          RowBox[{"MakeText", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"LabT", "/.", "FullOpts"}], ")"}], ",", "P", ",", "0", 
            ",", "\[IndentingNewLine]", 
            RowBox[{"ShowText", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"ShowLabT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Offset", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetT", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Nudge", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"NudgeT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Orientation", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"OrientationT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "->", 
             RowBox[{"(", 
              RowBox[{"BackgroundT", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
           "]"}], ",", "\[IndentingNewLine]", "4", ",", "\[IndentingNewLine]", 
          RowBox[{"MakeText", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"LabR", "/.", "FullOpts"}], ")"}], ",", "P", ",", 
            RowBox[{
             RowBox[{"-", "Pi"}], "/", "2"}], ",", "\[IndentingNewLine]", 
            RowBox[{"ShowText", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"ShowLabR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Offset", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"OffsetR", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Nudge", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"NudgeR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Orientation", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"OrientationR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "->", 
             RowBox[{"(", 
              RowBox[{"BackgroundR", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "FullOpts"}], " ", "\[IndentingNewLine]", 
           "]"}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Combine", " ", "ticks", " ", "with", " ", "axis", " ", "line"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"axis", " ", "line"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"ShowAxis", ",", "\[IndentingNewLine]", 
           RowBox[{"MakeOutline", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Line", "[", "Segment", "]"}], "}"}], ",", "FullOpts"}],
             "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "head", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"ShowHead", ",", "\[IndentingNewLine]", 
           RowBox[{"MakeOutline", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Line", "[", 
               RowBox[{"PCOfPA", "/@", 
                RowBox[{"ArrowHeadPoints", "[", 
                 RowBox[{
                  RowBox[{"PAOfPC", "/@", "Segment"}], ",", 
                  RowBox[{"HeadLength", "/.", "FullOpts"}], ",", 
                  RowBox[{"HeadLip", "/.", "FullOpts"}]}], "]"}]}], "]"}], 
              "}"}], ",", 
             RowBox[{"Dashing", "\[Rule]", "None"}], ",", "FullOpts"}], 
            "]"}]}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "ticks", " ", "*)"}], "\[IndentingNewLine]", 
         "TickLineGraphics", ",", "\[IndentingNewLine]", "TickTextGraphics", 
         ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "labels", " ", "*)"}], "\[IndentingNewLine]", 
         "LabelGraphics"}], "\[IndentingNewLine]", "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395520168859375*^9, 3.395520172234375*^9}, {
   3.39663458421875*^9, 3.3966345961875*^9}, {3.396635370375*^9, 
   3.396635382828125*^9}, {3.421623072171875*^9, 3.421623212171875*^9}, {
   3.426014211015625*^9, 3.426014454625*^9}, {3.426014527828125*^9, 
   3.426014542984375*^9}, {3.42601460659375*^9, 3.426014606828125*^9}, {
   3.42601467540625*^9, 3.42601468115625*^9}, {3.426014751296875*^9, 
   3.426014779171875*^9}, {3.426014906109375*^9, 3.42601491915625*^9}, {
   3.426015027125*^9, 3.4260150380625*^9}, 3.42601521821875*^9, {
   3.46995741709375*^9, 3.469957439453125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["SchemeAxis", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SchemeAxis", "[", 
    RowBox[{
     RowBox[{"Side", ":", 
      RowBox[{"(", 
       RowBox[{"Bottom", "|", "Top"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"xa_", ",", "xb_"}], "}"}], ",", "y_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeAxis", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "TickList"}], "\[IndentingNewLine]", "}"}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTicks", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTickLabels", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Ticks", "/.", "FullOpts"}], ")"}], ",", "None", ",", 
         RowBox[{"{", "}"}], ",", "_List", ",", 
         RowBox[{"Ticks", "/.", "FullOpts"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"AugmentTicks", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.0075", ",", "0"}], "}"}], ",", 
         RowBox[{"{", "}"}], ",", "TickList"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"TransformTicks", "[", 
        RowBox[{"XCOfXU", ",", "DYCTick", ",", 
         RowBox[{"LimitTickRange", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xa", ",", "xb"}], "}"}], ",", "TickList"}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ShowTickLabels", "/.", "FullOpts"}], ",", "TickList", ",", 
         RowBox[{"StripTickLabels", "[", "TickList", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ShowTicks", "/.", "FullOpts"}], ",", "TickList", ",", 
         RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", "\[IndentingNewLine]", 
       RowBox[{
       "Side", ",", "\[IndentingNewLine]", "Bottom", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BasicAxis", "[", 
         RowBox[{"SchemeAxis", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XCOfXU", "[", "xa", "]"}], ",", 
              RowBox[{"XCOfXU", "[", "xb", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"YCOfYU", "[", "y", "]"}], ",", "Null"}], "}"}]}], 
           "}"}], ",", "1", ",", "True", ",", 
          RowBox[{"(", 
           RowBox[{"ShowHead", "/.", "FullOpts"}], ")"}], ",", "TickList", 
          ",", "FullOpts"}], "]"}], ",", "\[IndentingNewLine]", "Top", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BasicAxis", "[", 
         RowBox[{"SchemeAxis", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XCOfXU", "[", "xa", "]"}], ",", 
              RowBox[{"XCOfXU", "[", "xb", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Null", ",", 
              RowBox[{"YCOfYU", "[", "y", "]"}]}], "}"}]}], "}"}], ",", "3", 
          ",", "True", ",", 
          RowBox[{"(", 
           RowBox[{"ShowHead", "/.", "FullOpts"}], ")"}], ",", "TickList", 
          ",", "FullOpts"}], "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeAxis", "[", 
    RowBox[{
     RowBox[{"Side", ":", 
      RowBox[{"(", 
       RowBox[{"Left", "|", "Right"}], ")"}]}], ",", "x_", ",", 
     RowBox[{"{", 
      RowBox[{"ya_", ",", "yb_"}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeAxis", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "TickList"}], "\[IndentingNewLine]", "}"}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTicks", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTickLabels", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Ticks", "/.", "FullOpts"}], ")"}], ",", "None", ",", 
         RowBox[{"{", "}"}], ",", "_List", ",", 
         RowBox[{"Ticks", "/.", "FullOpts"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"AugmentTicks", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0"}], "}"}], ",", 
         RowBox[{"{", "}"}], ",", "TickList"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"TransformTicks", "[", 
        RowBox[{"YCOfYU", ",", "DXCTick", ",", 
         RowBox[{"LimitTickRange", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ya", ",", "yb"}], "}"}], ",", "TickList"}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ShowTickLabels", "/.", "FullOpts"}], ",", "TickList", ",", 
         RowBox[{"StripTickLabels", "[", "TickList", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TickList", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ShowTicks", "/.", "FullOpts"}], ",", "TickList", ",", 
         RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", "\[IndentingNewLine]", 
       RowBox[{
       "Side", ",", "\[IndentingNewLine]", "Left", ",", "\[IndentingNewLine]", 
        RowBox[{"BasicAxis", "[", 
         RowBox[{"SchemeAxis", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XCOfXU", "[", "x", "]"}], ",", "Null"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"YCOfYU", "[", "ya", "]"}], ",", 
              RowBox[{"YCOfYU", "[", "yb", "]"}]}], "}"}]}], "}"}], ",", "2", 
          ",", "True", ",", 
          RowBox[{"(", 
           RowBox[{"ShowHead", "/.", "FullOpts"}], ")"}], ",", "TickList", 
          ",", "FullOpts"}], "]"}], ",", "\[IndentingNewLine]", "Right", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BasicAxis", "[", 
         RowBox[{"SchemeAxis", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Null", ",", 
              RowBox[{"XCOfXU", "[", "x", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"YCOfYU", "[", "ya", "]"}], ",", 
              RowBox[{"YCOfYU", "[", "yb", "]"}]}], "}"}]}], "}"}], ",", "4", 
          ",", "True", ",", 
          RowBox[{"(", 
           RowBox[{"ShowHead", "/.", "FullOpts"}], ")"}], ",", "TickList", 
          ",", "FullOpts"}], "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49605569859375*^9, 3.49605569859375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SchemeAxis", "[", 
    RowBox[{
     RowBox[{"Sides", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Bottom", "|", "Top"}], ",", 
          RowBox[{"Left", "|", "Right"}]}], "}"}], "|", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Left", "|", "Right"}], ",", 
          RowBox[{"Bottom", "|", "Top"}]}], "}"}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xRange", ":", 
        RowBox[{"{", 
         RowBox[{"xa_", ",", "xb_"}], "}"}]}], ",", 
       RowBox[{"yRange", ":", 
        RowBox[{"{", 
         RowBox[{"ya_", ",", "yb_"}], "}"}]}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"SchemeAxis", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "Side", ",", "xyOrigin", ",", "DeducedShowHead",
        ",", "DeducedAxisTicks"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"AxesOrigin", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"deduce", " ", "options"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"xyOrigin", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"AxesOrigin", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedAxisTicks", "=", 
       RowBox[{"AugmentAxisTickOptions", "[", 
        RowBox[{"2", ",", 
         RowBox[{"Ticks", "/.", "FullOpts"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedShowHead", "=", 
       RowBox[{"UpgradeAxisOptions", "[", 
        RowBox[{"ShowHead", "/.", "FullOpts"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"generate", " ", "axes"}], " ", "*)"}], "\[IndentingNewLine]", 
      
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Switch", "[", "\[IndentingNewLine]", 
         RowBox[{"Side", ",", "\[IndentingNewLine]", 
          RowBox[{"Bottom", "|", "Top"}], ",", "\[IndentingNewLine]", 
          RowBox[{"SchemeAxis", "[", "\[IndentingNewLine]", 
           RowBox[{"Side", ",", "xRange", ",", 
            RowBox[{"xyOrigin", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"DeducedAxisTicks", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"ShowHead", "\[Rule]", 
             RowBox[{"DeducedShowHead", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
            "FullOpts"}], "\[IndentingNewLine]", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Left", "|", "Right"}], ",", "\[IndentingNewLine]", 
          RowBox[{"SchemeAxis", "[", "\[IndentingNewLine]", 
           RowBox[{"Side", ",", 
            RowBox[{"xyOrigin", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "yRange", ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"DeducedAxisTicks", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{"ShowHead", "\[Rule]", 
             RowBox[{"DeducedShowHead", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
            "FullOpts"}], "\[IndentingNewLine]", "]"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Side", ",", "Sides"}], "}"}]}], "\[IndentingNewLine]", 
       "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.461088744140625*^9, {3.461088780125*^9, 3.461088864921875*^9}, {
   3.461088923203125*^9, 3.461088979859375*^9}, {3.461089018109375*^9, 
   3.461089070109375*^9}, {3.461089135625*^9, 3.461089237890625*^9}, {
   3.461089279375*^9, 3.461089283015625*^9}, {3.461089694046875*^9, 
   3.4610896995*^9}, {3.46109034521875*^9, 3.461090353671875*^9}, {
   3.4610903921875*^9, 3.461090446359375*^9}, {3.461090779984375*^9, 
   3.461090781859375*^9}, {3.4610908485625*^9, 3.461090861703125*^9}, 
   3.46109090109375*^9, {3.461090934359375*^9, 3.461091033203125*^9}, 
   3.461091223328125*^9, {3.461091304328125*^9, 3.46109131540625*^9}, 
   3.496055698609375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multipanel", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RangePattern", "=", 
   RowBox[{"(", 
    RowBox[{"Automatic", "|", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], ",", 
       RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TickPattern", "=", 
   RowBox[{"(", 
    RowBox[{"None", "|", "Automatic", "|", 
     RowBox[{"_", "?", "TickListQ"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RulePattern", "=", 
    RowBox[{
     RowBox[{"(", "_Rule", ")"}], "|", 
     RowBox[{"(", "_RuleDelayed", ")"}]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"allowed", " ", "entries", " ", "for"}], ",", " ", 
    RowBox[{"e", ".", "g", "."}], ",", " ", 
    RowBox[{"labels", " ", "are", " ", "anything", " ", "which", " ", 
     RowBox[{"doesn", "'"}], "t", " ", "mess", " ", "up", " ", 
     "classification", " ", "as", " ", "a", " ", "list", " ", "or", " ", 
     "array"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AllowedEntryPattern", "=", 
   RowBox[{"Except", "[", 
    RowBox[{"RulePattern", "|", "_List"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4799324388125*^9, 3.479932585015625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VectorOfQ", "[", 
    RowBox[{"x_", ",", "p_"}], "]"}], ":=", 
   RowBox[{"VectorQ", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"#", ",", "p"}], "]"}], "&"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MatrixOfQ", "[", 
    RowBox[{"x_", ",", "p_"}], "]"}], ":=", 
   RowBox[{"MatrixQ", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"#", ",", "p"}], "]"}], "&"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VectorPattern", "[", "p_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"VectorOfQ", "[", 
        RowBox[{"#", ",", "p"}], "]"}], "&"}], ")"}]}], ")"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MatrixPattern", "[", "p_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"MatrixOfQ", "[", 
        RowBox[{"#", ",", "p"}], "]"}], "&"}], ")"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RuleListPattern", "=", 
   RowBox[{"VectorPattern", "[", "RulePattern", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.47992947440625*^9, 3.4799294788125*^9}, {
  3.47992954340625*^9, 3.479929637640625*^9}, {3.479929732390625*^9, 
  3.47992973425*^9}, {3.479931825875*^9, 3.479931876515625*^9}, {
  3.47993247390625*^9, 3.479932480140625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MultipanelArrayPattern", "[", "p_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"RuleListPattern", "|", "p", "|", 
     RowBox[{"VectorPattern", "[", "p", "]"}], "|", 
     RowBox[{"MatrixPattern", "[", "p", "]"}]}], ")"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.47993238084375*^9, 3.47993242396875*^9}, {
  3.479932760859375*^9, 3.479932761765625*^9}}],

Cell["Upgrade of single entry", "Text",
 CellChangeTimes->{{3.479930336734375*^9, 3.479930339640625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UpgradeMultipanelArray", "[", "\[IndentingNewLine]", 
     RowBox[{"Data_", ",", "\[IndentingNewLine]", 
      RowBox[{"Sense", ":", "Horizontal"}], ",", 
      RowBox[{"{", 
       RowBox[{"Rows_Integer", ",", "Columns_Integer"}], "}"}], ",", 
      "OptionName_Symbol", ",", "EntryPattern_"}], "\[IndentingNewLine]", 
     "]"}], "/;", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"Data", ",", "EntryPattern"}], "]"}]}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"UpgradeMultipanelArray", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"Data", ",", 
       RowBox[{"{", "Columns", "}"}]}], "]"}], ",", "Sense", ",", 
     RowBox[{"{", 
      RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "OptionName", ",", 
     "EntryPattern"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UpgradeMultipanelArray", "[", "\[IndentingNewLine]", 
     RowBox[{"Data_", ",", "\[IndentingNewLine]", 
      RowBox[{"Sense", ":", "Vertical"}], ",", 
      RowBox[{"{", 
       RowBox[{"Rows_Integer", ",", "Columns_Integer"}], "}"}], ",", 
      "OptionName_Symbol", ",", "EntryPattern_"}], "\[IndentingNewLine]", 
     "]"}], "/;", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"Data", ",", "EntryPattern"}], "]"}]}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"UpgradeMultipanelArray", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"Data", ",", 
       RowBox[{"{", "Rows", "}"}]}], "]"}], ",", "Sense", ",", 
     RowBox[{"{", 
      RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "OptionName", ",", 
     "EntryPattern"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.479930153734375*^9, 3.47993015528125*^9}, {
  3.479930196890625*^9, 3.479930308171875*^9}, {3.479930347*^9, 
  3.479930359921875*^9}}],

Cell["Upgrade of vector", "Text",
 CellChangeTimes->{{3.479930362953125*^9, 3.4799303655625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UpgradeMultipanelArray", "[", "\[IndentingNewLine]", 
     RowBox[{"Data_", ",", "\[IndentingNewLine]", 
      RowBox[{"Sense", ":", "Horizontal"}], ",", 
      RowBox[{"{", 
       RowBox[{"Rows_Integer", ",", "Columns_Integer"}], "}"}], ",", 
      "OptionName_Symbol", ",", "EntryPattern_"}], "\[IndentingNewLine]", 
     "]"}], "/;", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"Data", ",", 
      RowBox[{"VectorPattern", "[", "EntryPattern", "]"}]}], "]"}]}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"UpgradeMultipanelArray", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"Data", ",", 
       RowBox[{"{", "Rows", "}"}]}], "]"}], ",", "Sense", ",", 
     RowBox[{"{", 
      RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "OptionName", ",", 
     "EntryPattern"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UpgradeMultipanelArray", "[", "\[IndentingNewLine]", 
     RowBox[{"Data_", ",", "\[IndentingNewLine]", 
      RowBox[{"Sense", ":", "Vertical"}], ",", 
      RowBox[{"{", 
       RowBox[{"Rows_Integer", ",", "Columns_Integer"}], "}"}], ",", 
      "OptionName_Symbol", ",", "EntryPattern_"}], "\[IndentingNewLine]", 
     "]"}], "/;", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"Data", ",", 
      RowBox[{"VectorPattern", "[", "EntryPattern", "]"}]}], "]"}]}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"UpgradeMultipanelArray", "[", 
    RowBox[{
     RowBox[{"Transpose", "@", 
      RowBox[{"Table", "[", 
       RowBox[{"Data", ",", 
        RowBox[{"{", "Columns", "}"}]}], "]"}]}], ",", "Sense", ",", 
     RowBox[{"{", 
      RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "OptionName", ",", 
     "EntryPattern"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.479930153734375*^9, 3.47993015528125*^9}, {
  3.479930196890625*^9, 3.479930308171875*^9}, {3.479930347*^9, 
  3.479930359921875*^9}, {3.479930431796875*^9, 3.4799304466875*^9}}],

Cell["Upgrade of rule list", "Text",
 CellChangeTimes->{{3.479930362953125*^9, 3.4799303655625*^9}, {
  3.479930500671875*^9, 3.47993050184375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UpgradeMultipanelArray", "[", "\[IndentingNewLine]", 
     RowBox[{"Data_", ",", "\[IndentingNewLine]", 
      RowBox[{"Sense", ":", 
       RowBox[{"(", 
        RowBox[{"Horizontal", "|", "Vertical", "|", "All"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"Rows_Integer", ",", "Columns_Integer"}], "}"}], ",", 
      "OptionName_Symbol", ",", "EntryPattern_"}], "\[IndentingNewLine]", 
     "]"}], "/;", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"Data", ",", "RuleListPattern"}], "]"}]}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ValueArray", ",", "r", ",", "s"}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ValueArray", "=", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Replace", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"r", ",", "s"}], "}"}], ",", 
           RowBox[{"Append", "[", 
            RowBox[{"Data", ",", 
             RowBox[{"(", 
              RowBox[{"_", "\[Rule]", "Automatic"}], ")"}]}], "]"}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"r", ",", "Rows"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "Columns"}], "}"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"MapIndexed", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"MatchQ", "[", 
             RowBox[{"#1", ",", "EntryPattern"}], "]"}]}], ",", 
           RowBox[{"ErrorMessage", "[", 
            RowBox[{
             RowBox[{"Multipanel", "::", "rule"}], ",", "OptionName", ",", 
             "#2"}], "]"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        "ValueArray", ",", "\[IndentingNewLine]", 
        RowBox[{"{", "2", "}"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "ValueArray"}]}], "\[IndentingNewLine]", "]"}]}],
   ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.479930518609375*^9, 3.479930538546875*^9}, {
   3.47993060696875*^9, 3.479930705546875*^9}, 3.47993081465625*^9, {
   3.47993087053125*^9, 3.479930882703125*^9}, {3.479930920984375*^9, 
   3.479931146515625*^9}, {3.47993121340625*^9, 3.47993137509375*^9}, 
   3.47993193084375*^9, {3.479932057515625*^9, 3.4799320765*^9}, {
   3.479932113703125*^9, 3.47993212834375*^9}, {3.479933356140625*^9, 
   3.479933356921875*^9}, {3.502557782625*^9, 3.50255779971875*^9}, {
   3.5025578630625*^9, 3.502557889421875*^9}, {3.502557937828125*^9, 
   3.5025579414375*^9}, {3.50255797384375*^9, 3.502557982515625*^9}, {
   3.502558044390625*^9, 3.502558051375*^9}}],

Cell["\<\
Upgrade of matrix -- dimension check and augmentation of one-row or \
one-column matrix\
\>", "Text",
 CellChangeTimes->{{3.479930450703125*^9, 3.47993048725*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UpgradeMultipanelArray", "[", 
     RowBox[{"Data_", ",", 
      RowBox[{"Sense", ":", 
       RowBox[{"(", 
        RowBox[{"Horizontal", "|", "Vertical", "|", "All"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"Rows_Integer", ",", "Columns_Integer"}], "}"}], ",", 
      "OptionName_Symbol", ",", "EntryPattern_"}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{"MatrixQ", "[", 
      RowBox[{"Data", ",", 
       RowBox[{
        RowBox[{"MatchQ", "[", 
         RowBox[{"#", ",", "EntryPattern"}], "]"}], "&"}]}], "]"}], ")"}]}], ":=",
    "\[IndentingNewLine]", 
   RowBox[{"Switch", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Dimensions", "[", 
      RowBox[{"Data", ",", "2"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "\[IndentingNewLine]", 
     "Data", ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "Columns"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"First", "[", "Data", "]"}], ",", 
       RowBox[{"{", "Rows", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Rows", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Transpose", "@", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"First", "[", 
         RowBox[{"Transpose", "@", "Data"}], "]"}], ",", 
        RowBox[{"{", "Columns", "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
     "_", ",", "\[IndentingNewLine]", 
     RowBox[{"ErrorMessage", "[", 
      RowBox[{
       RowBox[{"Multipanel", "::", "num"}], ",", "OptionName"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.479930153734375*^9, 3.47993015528125*^9}, {
   3.479930196890625*^9, 3.479930308171875*^9}, {3.479930347*^9, 
   3.479930359921875*^9}, 3.479930431796875*^9, {3.479933359390625*^9, 
   3.479933363359375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Multipanel", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"OuterBox", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Rows_Integer", ",", "Columns_Integer"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "\[IndentingNewLine]", "]"}], " ",
    ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"Multipanel", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "i", ",", "k", ",", "\[IndentingNewLine]", 
       "RelativeXPanelSizes", ",", "RelativeYPanelSizes", ",", 
       "\[IndentingNewLine]", "RelativeXGapSizes", ",", "RelativeYGapSizes", 
       ",", "\[IndentingNewLine]", "RelativeXMarginSizes", ",", 
       "RelativeYMarginSizes", ",", "\[IndentingNewLine]", 
       "CanvasXPanelSizes", ",", "CanvasYPanelSizes", ",", 
       "\[IndentingNewLine]", "CanvasXGapSizes", ",", "CanvasYGapSizes", ",", 
       "\[IndentingNewLine]", "CanvasXMarginSizes", ",", "CanvasYMarginSizes",
        ",", "\[IndentingNewLine]", "x1", ",", "x2", ",", "y1", ",", "y2"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"XPlotRanges", ",", 
        RowBox[{"MultipanelArrayPattern", "[", "RangePattern", "]"}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"YPlotRanges", ",", 
        RowBox[{"MultipanelArrayPattern", "[", "RangePattern", "]"}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"XFrameTicks", ",", 
        RowBox[{"MultipanelArrayPattern", "[", "TickPattern", "]"}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"YFrameTicks", ",", 
        RowBox[{"MultipanelArrayPattern", "[", "TickPattern", "]"}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"XFrameLabels", ",", 
        RowBox[{"MultipanelArrayPattern", "[", "AllowedEntryPattern", "]"}], 
        ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"YFrameLabels", ",", 
        RowBox[{"MultipanelArrayPattern", "[", "AllowedEntryPattern", "]"}], 
        ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Margin", ",", 
        RowBox[{"_", "?", "MarginQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"XPanelSizes", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"_", "?", "NumericQ"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"YPanelSizes", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"_", "?", "NumericQ"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"XGapSizes", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"YGapSizes", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"XMarginSizes", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"YMarginSizes", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowFrameLabels", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowFrameLabelsInterior", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowFrameLabelsExterior", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTicks", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTickLabels", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTickLabelsInterior", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTickLabelsExterior", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PanelLetterInset", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"set", " ", "up", " ", "indexing"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`Dimension", "=", 
       RowBox[{"{", 
        RowBox[{"Rows", ",", "Columns"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`PanelIndices", "=", "None"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"store", " ", "plot", " ", "ranges"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`XPlotRanges", "=", 
       RowBox[{"UpgradeMultipanelArray", "[", 
        RowBox[{
         RowBox[{"XPlotRanges", "/.", "FullOpts"}], ",", "Horizontal", ",", 
         RowBox[{"{", 
          RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "XPlotRanges", ",", 
         "RangePattern"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`YPlotRanges", "=", 
       RowBox[{"UpgradeMultipanelArray", "[", 
        RowBox[{
         RowBox[{"YPlotRanges", "/.", "FullOpts"}], ",", "Vertical", ",", 
         RowBox[{"{", 
          RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "YPlotRanges", ",", 
         "RangePattern"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"store", " ", "tick", " ", "mark", " ", "information"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`XFrameTicks", "=", 
       RowBox[{"UpgradeMultipanelArray", "[", 
        RowBox[{
         RowBox[{"XFrameTicks", "/.", "FullOpts"}], ",", "Horizontal", ",", 
         RowBox[{"{", 
          RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "XFrameTicks", ",", 
         "TickPattern"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`YFrameTicks", "=", 
       RowBox[{"UpgradeMultipanelArray", "[", 
        RowBox[{
         RowBox[{"YFrameTicks", "/.", "FullOpts"}], ",", "Vertical", ",", 
         RowBox[{"{", 
          RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "YFrameTicks", ",", 
         "TickPattern"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"MatchQ", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"XFrameTicks", "/.", "FullOpts"}], ")"}], ",", 
           "TickPattern"}], "]"}], "&&", 
         RowBox[{"MatchQ", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"XFrameTicks", "/.", "FullOpts"}], ")"}], ",", 
           RowBox[{"{", 
            RowBox[{"TickPattern", ".."}], "}"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"Multipanel", "::", "ambigticks"}], ",", 
          "\"\<XFrameTicks\>\""}], "]"}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"MatchQ", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"YFrameTicks", "/.", "FullOpts"}], ")"}], ",", 
           "TickPattern"}], "]"}], "&&", 
         RowBox[{"MatchQ", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"YFrameTicks", "/.", "FullOpts"}], ")"}], ",", 
           RowBox[{"{", 
            RowBox[{"TickPattern", ".."}], "}"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"Multipanel", "::", "ambigticks"}], ",", 
          "\"\<YFrameTicks\>\""}], "]"}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"store", " ", "frame", " ", "label", " ", "information"}], " ",
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`XFrameLabels", "=", 
       RowBox[{"UpgradeMultipanelArray", "[", 
        RowBox[{
         RowBox[{"XFrameLabels", "/.", "FullOpts"}], ",", "Horizontal", ",", 
         RowBox[{"{", 
          RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "XFrameLabels", ",", 
         "AllowedEntryPattern"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`YFrameLabels", "=", 
       RowBox[{"UpgradeMultipanelArray", "[", 
        RowBox[{
         RowBox[{"YFrameLabels", "/.", "FullOpts"}], ",", "Vertical", ",", 
         RowBox[{"{", 
          RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "YFrameLabels", ",", 
         "AllowedEntryPattern"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"store", " ", "geometry"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x1", ",", "x2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y1", ",", "y2"}], "}"}]}], "}"}], "=", 
       RowBox[{"ImposeAbsoluteMargin", "[", 
        RowBox[{"OuterBox", ",", 
         RowBox[{"Margin", "/.", "FullOpts"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"RelativeXPanelSizes", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"XPanelSizes", "/.", "FullOpts"}], ",", 
         "\[IndentingNewLine]", "Automatic", ",", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"MatchQ", "[", 
               RowBox[{"LevelScheme`Multipanel`XPlotRanges", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"_", "?", "NumericQ"}], ",", 
                    RowBox[{"_", "?", "NumericQ"}]}], "}"}], ".."}], "}"}], 
                  ".."}], "}"}]}], "]"}]}], ",", 
             RowBox[{"ErrorMessage", "[", 
              RowBox[{
               RowBox[{"Multipanel", "::", "autosizes"}], ",", 
               "\"\<XPanelSizes\>\"", ",", "\"\<XPlotRanges\>\""}], "]"}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"-", 
            RowBox[{"Subtract", "@@@", 
             RowBox[{
             "First", "[", "LevelScheme`Multipanel`XPlotRanges", "]"}]}]}]}], 
          "\[IndentingNewLine]", ")"}], ",", "\[IndentingNewLine]", 
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"XPanelSizes", "/.", "FullOpts"}], ",", 
           RowBox[{"{", "Columns", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}], ",", 
         RowBox[{"XPanelSizes", "/.", "FullOpts"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "RelativeXPanelSizes", "]"}], "=!=", 
         "Columns"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"Multipanel", "::", "num"}], ",", "\"\<X panel sizes\>\""}],
          "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"RelativeYPanelSizes", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"YPanelSizes", "/.", "FullOpts"}], ",", 
         "\[IndentingNewLine]", "Automatic", ",", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"MatchQ", "[", 
               RowBox[{"LevelScheme`Multipanel`YPlotRanges", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"_", "?", "NumericQ"}], ",", 
                    RowBox[{"_", "?", "NumericQ"}]}], "}"}], ".."}], "}"}], 
                  ".."}], "}"}]}], "]"}]}], ",", 
             RowBox[{"ErrorMessage", "[", 
              RowBox[{
               RowBox[{"Multipanel", "::", "autosizes"}], ",", 
               "\"\<YPanelSizes\>\"", ",", "\"\<YPlotRanges\>\""}], "]"}]}], 
            "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"-", 
            RowBox[{"Subtract", "@@@", 
             RowBox[{"First", "[", 
              RowBox[{
              "Transpose", "[", "LevelScheme`Multipanel`YPlotRanges", "]"}], 
              "]"}]}]}]}], "\[IndentingNewLine]", ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"YPanelSizes", "/.", "FullOpts"}], ",", 
           RowBox[{"{", "Rows", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}], ",", 
         RowBox[{"YPanelSizes", "/.", "FullOpts"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "RelativeYPanelSizes", "]"}], "=!=", "Rows"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"Multipanel", "::", "num"}], ",", "\"\<Y panel sizes\>\""}],
          "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"RelativeXGapSizes", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"XGapSizes", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"XGapSizes", "/.", "FullOpts"}], ",", 
           RowBox[{"{", 
            RowBox[{"Columns", "-", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}], ",", 
         RowBox[{"XGapSizes", "/.", "FullOpts"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "RelativeXGapSizes", "]"}], "=!=", 
         RowBox[{"(", 
          RowBox[{"Columns", "-", "1"}], ")"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"Multipanel", "::", "num"}], ",", "\"\<X panel gaps\>\""}], 
         "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"RelativeYGapSizes", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"YGapSizes", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"YGapSizes", "/.", "FullOpts"}], ",", 
           RowBox[{"{", 
            RowBox[{"Rows", "-", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ".."}], "}"}], ",", 
         RowBox[{"YGapSizes", "/.", "FullOpts"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "RelativeYGapSizes", "]"}], "=!=", 
         RowBox[{"(", 
          RowBox[{"Rows", "-", "1"}], ")"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"Multipanel", "::", "num"}], ",", "\"\<Y panel gaps\>\""}], 
         "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"RelativeXMarginSizes", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"XMarginSizes", "/.", "FullOpts"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"XMarginSizes", "/.", "FullOpts"}], ",", 
           RowBox[{"{", "2", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
         RowBox[{"XMarginSizes", "/.", "FullOpts"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RelativeYMarginSizes", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"YMarginSizes", "/.", "FullOpts"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"YMarginSizes", "/.", "FullOpts"}], ",", 
           RowBox[{"{", "2", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
         RowBox[{"YMarginSizes", "/.", "FullOpts"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`CanvasXUnit", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x2", "-", "x1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Plus", "@@", "RelativeXPanelSizes"}], "+", 
          RowBox[{"Plus", "@@", "RelativeXGapSizes"}], "+", 
          RowBox[{"Plus", "@@", "RelativeXMarginSizes"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CanvasXPanelSizes", "=", 
       RowBox[{
       "RelativeXPanelSizes", "*", "LevelScheme`Multipanel`CanvasXUnit"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CanvasXGapSizes", "=", 
       RowBox[{
       "RelativeXGapSizes", "*", "LevelScheme`Multipanel`CanvasXUnit"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CanvasXMarginSizes", "=", 
       RowBox[{
       "RelativeXMarginSizes", "*", "LevelScheme`Multipanel`CanvasXUnit"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`CanvasYUnit", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y2", "-", "y1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Plus", "@@", "RelativeYPanelSizes"}], "+", 
          RowBox[{"Plus", "@@", "RelativeYGapSizes"}], "+", 
          RowBox[{"Plus", "@@", "RelativeYMarginSizes"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CanvasYPanelSizes", "=", 
       RowBox[{
       "RelativeYPanelSizes", "*", "LevelScheme`Multipanel`CanvasYUnit"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CanvasYGapSizes", "=", 
       RowBox[{
       "RelativeYGapSizes", "*", "LevelScheme`Multipanel`CanvasYUnit"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CanvasYMarginSizes", "=", 
       RowBox[{
       "RelativeYMarginSizes", "*", "LevelScheme`Multipanel`CanvasYUnit"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`XRegionRangeList", "=", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"x1", "+", 
          RowBox[{"CanvasXMarginSizes", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"CanvasXPanelSizes", "[", 
              RowBox[{"[", "k", "]"}], "]"}], "+", 
             RowBox[{"CanvasXGapSizes", "[", 
              RowBox[{"[", "k", "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "1", ",", 
              RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], "+", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"CanvasXPanelSizes", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "Columns"}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`YRegionRangeList", "=", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"y2", "-", 
          RowBox[{"CanvasYMarginSizes", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "-", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"CanvasYPanelSizes", "[", 
              RowBox[{"[", "k", "]"}], "]"}], "+", 
             RowBox[{"CanvasYGapSizes", "[", 
              RowBox[{"[", "k", "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "1", ",", 
              RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], "+", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"CanvasYPanelSizes", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", "0"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "Rows"}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "store", " ", "frozen", " ", "copy", " ", "of", " ", "Panel", " ", 
        "formatting", " ", "option", " ", "defaults"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`PanelOptions", "=", 
       RowBox[{"{", 
        RowBox[{"LegacyFilterOptions", "[", 
         RowBox[{"FigurePanel", ",", "FullOpts"}], "]"}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "Null"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.395089867125*^9, 3.395092360234375*^9, 3.395521251375*^9, {
   3.424459345125*^9, 3.424459373109375*^9}, {3.428252181015625*^9, 
   3.428252213265625*^9}, {3.428252251859375*^9, 3.428252256375*^9}, {
   3.43448641490625*^9, 3.434486417078125*^9}, {3.434487395921875*^9, 
   3.434487397671875*^9}, {3.434487430484375*^9, 3.43448743590625*^9}, {
   3.434487481953125*^9, 3.4344874829375*^9}, {3.434488685984375*^9, 
   3.434488686390625*^9}, {3.464879644078125*^9, 3.46487965896875*^9}, {
   3.4799294095625*^9, 3.4799294653125*^9}, {3.479929989421875*^9, 
   3.479929989875*^9}, {3.47993143425*^9, 3.47993143734375*^9}, {
   3.47993158334375*^9, 3.479931625984375*^9}, {3.479931678015625*^9, 
   3.4799316911875*^9}, {3.479932157296875*^9, 3.479932164765625*^9}, {
   3.479932196578125*^9, 3.47993220103125*^9}, {3.47993229265625*^9, 
   3.479932294640625*^9}, {3.47993261534375*^9, 3.4799326623125*^9}, 
   3.479932883484375*^9, {3.479933010265625*^9, 3.47993302721875*^9}, 
   3.496055698625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Multipanel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Rows_Integer", ",", "Columns_Integer"}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Multipanel", "[", 
    RowBox[{"$CanvasRange", ",", 
     RowBox[{"{", 
      RowBox[{"Rows", ",", "Columns"}], "}"}], ",", "Opts"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49753410340625*^9, 3.497534167875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Panel", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasicFigurePanel", "[", 
    RowBox[{"Caller_Symbol", ",", 
     RowBox[{"OuterBox", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     "FullOpts_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "CanvasRange", ",", "ExpandedPlotRange", ",", "XYPlotRange", ",", 
       "UsedPlotRange", ",", "\[IndentingNewLine]", "DeducedShowFrameLabels", 
       ",", "DeducedFrameLabel", ",", "DeducedFrameLabelOptions", ",", 
       "DeducedTickOptions", ",", "DeducedFrameTicks", ",", 
       "DeducedShowTicks", ",", "DeducedShowTickLabels", ",", 
       "DeducedTickLabelRange", ",", "\[IndentingNewLine]", "AxisIndex", ",", 
       "PanelLetterPosn"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Margin", ",", 
        RowBox[{"_", "?", "MarginQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PlotRange", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Automatic", "|", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
           RowBox[{"Automatic", "|", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "}"}]}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Background", ",", 
        RowBox[{"None", "|", "ColorDirectivePattern"}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"BackgroundOpacity", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"FrameLabel", ",", 
        RowBox[{"None", "|", "Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"L_List", "/;", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "L", "]"}], "\[LessEqual]", "4"}], 
            ")"}]}], ")"}]}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowFrameLabels", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"True", "|", "False"}], ")"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"ad", " ", "hoc", " ", 
        RowBox[{"pattern", " ", "--"}], " ", "TO", " ", "NEATEN"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowEdge", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTicks", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTickLabels", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"True", "|", "False"}], ")"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}], ",", 
           RowBox[{"True", "|", "False"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", 
      RowBox[{"(*", " ", 
       RowBox[{"ad", " ", "hoc", " ", 
        RowBox[{"pattern", " ", "--"}], " ", "TO", " ", "NEATEN"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"TickNudge", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"L", ":", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], "|", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"_", "?", "NumericQ"}], ",", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ")"}], "..."}], 
            "}"}]}], "/;", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Length", "[", "L", "]"}], "==", "4"}], ")"}]}], ")"}], 
        ",", "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"hard", " ", "to", " ", "standardize", " ", "multi"}], "-", 
         RowBox[{"axis", " ", "specification"}]}], ",", " ", 
        RowBox[{
        "since", " ", "each", " ", "nudge", " ", "can", " ", "either", " ", 
         "be", " ", "a", " ", "number", " ", "or", " ", "a", " ", "list"}]}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"TickLabelMargin", ",", 
        RowBox[{"_", "?", "MarginQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"TickOptions", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"None", "|", 
           RowBox[{"(", 
            RowBox[{"_", "?", "FlatListQ"}], ")"}]}], ")"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"None", "|", 
             RowBox[{"(", 
              RowBox[{"_", "?", "FlatListQ"}], ")"}]}], ")"}], ",", 
           RowBox[{"(", 
            RowBox[{"None", "|", 
             RowBox[{"(", 
              RowBox[{"_", "?", "FlatListQ"}], ")"}]}], ")"}]}], "}"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"None", "|", 
               RowBox[{"(", 
                RowBox[{"_", "?", "FlatListQ"}], ")"}]}], ")"}], ",", 
             RowBox[{"(", 
              RowBox[{"None", "|", 
               RowBox[{"(", 
                RowBox[{"_", "?", "FlatListQ"}], ")"}]}], ")"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"None", "|", 
               RowBox[{"(", 
                RowBox[{"_", "?", "FlatListQ"}], ")"}]}], ")"}], ",", 
             RowBox[{"(", 
              RowBox[{"None", "|", 
               RowBox[{"(", 
                RowBox[{"_", "?", "FlatListQ"}], ")"}]}], ")"}]}], "}"}]}], 
          "}"}]}], ",", "FullOpts"}], "]"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"ad", " ", "hoc", " ", 
        RowBox[{"pattern", " ", "--"}], " ", "TO", " ", 
        RowBox[{"NEATEN", " ", "--"}], " ", "can", " ", "also", " ", 
        "validate", " ", "flat", " ", "list", " ", "as", " ", "option", " ", 
        "list"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ExtendRange", ",", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}], "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "set", " ", "up", " ", "global", " ", "properties", " ", "for", " ", 
        "panel"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"$Background", "=", 
       RowBox[{"Background", "/.", "FullOpts"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"CanvasRange", "=", 
       RowBox[{"ImposeAbsoluteMargin", "[", 
        RowBox[{"OuterBox", ",", 
         RowBox[{"Margin", "/.", "FullOpts"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"calculate", " ", "plot", " ", "range"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", "1", ")"}], " ", "expand", " ", "PlotRange", " ", 
          "value", " ", "Automatic", " ", "to", " ", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ";", " ", 
         RowBox[{
          RowBox[{"(", "2", ")"}], " ", "for", " ", "each", " ", 
          "coordinate"}]}], ",", " ", 
        RowBox[{
        "use", " ", "explicit", " ", "range", " ", "if", " ", "given", " ", 
         "in", " ", "PlotRange"}], ",", " ", 
        RowBox[{
         RowBox[{
         "or", " ", "for", " ", "Automatic", " ", "default", " ", "to", " ", 
          "separate", " ", "XPlotRange", " ", "and", " ", "YPlotRange"}], ";",
          " ", 
         RowBox[{
          RowBox[{"(", "3", ")"}], " ", "for", " ", "XPlotRange", " ", "and", 
          " ", "YPlotRange"}]}], ",", " ", 
        RowBox[{
        "use", " ", "explicit", " ", "ranges", " ", "if", " ", "given", " ", 
         "or", " ", "else", " ", "for", " ", "Automatic", " ", "default", " ",
          "to", " ", "canvas", " ", "coordinate", " ", "range", " ", 
         "covered", " ", "by", " ", "panel", " ", 
         RowBox[{"(", 
          RowBox[{"dubious", " ", "value"}], ")"}]}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ExpandedPlotRange", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"PlotRange", ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", "FullOpts"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"XYPlotRange", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Replace", "[", 
            RowBox[{"#1", ",", 
             RowBox[{"Automatic", "\[Rule]", "#2"}]}], "]"}], "&"}], ")"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"ExpandedPlotRange", ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"XPlotRange", ",", "YPlotRange"}], "}"}], "/.", 
            "FullOpts"}]}], "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"UsedPlotRange", "=", 
       RowBox[{"ExtendRegion", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Replace", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"Automatic", "\[Rule]", "#2"}]}], "]"}], "&"}], ")"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"XYPlotRange", ",", "CanvasRange"}], "}"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(", 
          RowBox[{"ExtendRange", "/.", "FullOpts"}], ")"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"set", " ", "new", " ", "coordinate", " ", "mapping"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"SetRegion", "[", 
       RowBox[{"CanvasRange", ",", "UsedPlotRange"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"obtain", " ", "frame", " ", "labels"}], ",", " ", 
        RowBox[{
        "defaulting", " ", "to", " ", "LabX", " ", "option", " ", 
         "values"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "construct", " ", "explicit", " ", "list", " ", "of", " ", "labels"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameLabel", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"FrameLabel", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", "Automatic", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"LabB", ",", "LabL", ",", "LabT", ",", "LabR"}], "}"}], "/.",
           "FullOpts"}], ",", "\[IndentingNewLine]", "_List", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"UpgradeFrameOptionsList", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"FrameLabel", "/.", "FullOpts"}], ")"}], ",", "None"}], 
          "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "remove", " ", "labels", " ", "except", " ", "on", " ", "sides", " ", 
        "where", " ", "allowed"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedShowFrameLabels", "=", 
       RowBox[{"UpgradeFrameOptionsList", "[", "\[IndentingNewLine]", 
        RowBox[{"GetAutoOption", "[", 
         RowBox[{"ShowFrameLabels", ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], 
          ",", "FullOpts"}], "]"}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "clothe", " ", "frame", " ", "labels", " ", "as", " ", "LabX", " ", 
        "option", " ", "rules"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameLabelOptions", "=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"MapThread", "[", 
          RowBox[{"Rule", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"LabB", ",", "LabL", ",", "LabT", ",", "LabR"}], "}"}], 
             ",", "DeducedFrameLabel"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"MapThread", "[", 
          RowBox[{"Rule", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "ShowLabB", ",", "ShowLabL", ",", "ShowLabT", ",", "ShowLabR"}],
               "}"}], ",", "DeducedShowFrameLabels"}], "}"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"process", " ", "frame", " ", "tick", " ", "specification"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "augment", " ", "specification", " ", "so", " ", "that", " ", "it", 
        " ", "is", " ", "a", " ", "list", " ", "of", " ", "lists"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"FrameTicks", ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic", ",", "None", ",", "None"}], 
          "}"}], ",", "FullOpts"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{"AugmentAxisTickOptions", "[", 
        RowBox[{"4", ",", "DeducedFrameTicks"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "generate", " ", "any", " ", "automatic", " ", "ticks", " ", "with", 
         " ", "LinTicks"}], ",", " ", 
        RowBox[{
        "with", " ", "labels", " ", "on", " ", "for", " ", "the", " ", 
         "bottom", " ", "and", " ", "left", " ", "and", " ", "off", " ", 
         "for", " ", "the", " ", "top", " ", "and", " ", "right"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedTickOptions", "=", 
       RowBox[{"UpgradeFrameOptionsFlatList", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"TickOptions", "/.", "FullOpts"}], ")"}], "/.", 
         RowBox[{"{", 
          RowBox[{"None", "\[Rule]", 
           RowBox[{"{", "}"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Replace", "[", 
            RowBox[{"#1", ",", 
             RowBox[{"Automatic", "\[RuleDelayed]", 
              RowBox[{"LinTicks", "[", 
               RowBox[{
                RowBox[{"Sequence", "@@", "#2"}], ",", 
                RowBox[{"ShowLabels", "\[Rule]", "#3"}], ",", "#4"}], 
               "]"}]}]}], "]"}], "&"}], ")"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"DeducedFrameTicks", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"UsedPlotRange", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"UsedPlotRange", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"UsedPlotRange", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"UsedPlotRange", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}], 
           ",", "\[IndentingNewLine]", "DeducedTickOptions"}], 
          "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "augment", " ", "specification", " ", "of", " ", "any", " ", 
         "under"}], "-", 
        RowBox[{"specified", " ", "ticks"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"AugmentTicks", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0.01", ",", "0"}], "}"}], ",", 
            RowBox[{"{", "}"}], ",", "#"}], "]"}], "&"}], ")"}], "/@", 
        "DeducedFrameTicks"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"convert", " ", "to", " ", "canvas", " ", "coordinates"}], " ",
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"TransformTicks", "[", 
            RowBox[{"#1", ",", "#2", ",", 
             RowBox[{"LimitTickRange", "[", 
              RowBox[{"#3", ",", "#4"}], "]"}]}], "]"}], "&"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"XCOfXU", ",", "YCOfYU", ",", "XCOfXU", ",", "YCOfYU"}], 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
            "DYCTick", ",", "DXCTick", ",", "DYCTick", ",", "DXCTick"}], 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"UsedPlotRange", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"UsedPlotRange", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"UsedPlotRange", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"UsedPlotRange", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
           "\[IndentingNewLine]", "DeducedFrameTicks"}], 
          "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "remove", " ", "tick", " ", "labels", " ", "except", " ", "on", " ", 
        "sides", " ", "where", " ", "allowed"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedShowTickLabels", "=", 
       RowBox[{"UpgradeFrameOptionsList", "[", "\[IndentingNewLine]", 
        RowBox[{"GetAutoOption", "[", 
         RowBox[{"ShowTickLabels", ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}], 
          ",", "FullOpts"}], "]"}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{"#2", ",", "#1", ",", 
             RowBox[{"StripTickLabels", "[", "#1", "]"}]}], "]"}], "&"}], 
          ")"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"DeducedFrameTicks", ",", "DeducedShowTickLabels"}], 
          "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "trim", " ", "tick", " ", "labels", " ", "to", " ", "restricted", " ", 
        "canvas", " ", "range", " ", "to", " ", "avoid", " ", "clash", " ", 
        "with", " ", "neighboring", " ", "frames"}], "  ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedTickLabelRange", "=", 
       RowBox[{"ImposeAbsoluteMargin", "[", 
        RowBox[{"CanvasRange", ",", 
         RowBox[{"(", 
          RowBox[{"TickLabelMargin", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"LimitTickLabelRange", "[", 
           RowBox[{"#2", ",", "#1"}], "]"}], "&"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"DeducedFrameTicks", ",", 
           RowBox[{"Join", "[", 
            RowBox[{"DeducedTickLabelRange", ",", "DeducedTickLabelRange"}], 
            "]"}]}], "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "remove", " ", "ticks", " ", "except", " ", "on", " ", "sides", " ", 
        "where", " ", "allowed"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedShowTicks", "=", 
       RowBox[{"UpgradeFrameOptionsList", "[", "\[IndentingNewLine]", 
        RowBox[{"GetAutoOption", "[", 
         RowBox[{"ShowTicks", ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], 
          ",", "FullOpts"}], "]"}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{"#2", ",", "#1", ",", 
             RowBox[{"{", "}"}]}], "]"}], "&"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"DeducedFrameTicks", ",", "DeducedShowTicks"}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"construct", " ", "artwork"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "fill", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"$Background", "=!=", "None"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"MakeFill", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Rectangle", "@@", 
              RowBox[{"Transpose", "[", "CanvasRange", "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Color", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"Background", "/.", "FullOpts"}], ")"}]}], ",", 
            RowBox[{"Opacity", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"BackgroundOpacity", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ShowFill", "\[Rule]", "True"}], ",", 
            RowBox[{"FillColor", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"FillOpacity", "\[Rule]", "Automatic"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Layer", "\[Rule]", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{
              "Layer", ",", "$SchemeBackgroundLayer", ",", "FullOpts"}], 
              "]"}]}], ",", "\[IndentingNewLine]", "FullOpts"}], 
           "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "edges", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "axis", " ", "options", " ", "are", " ", "as", " ", "in", " ", 
           "FullOpts"}], ",", " ", 
          RowBox[{
          "except", " ", "LabX", " ", "is", " ", "overriden", " ", "by", " ", 
           "FrameLabel"}], ",", " ", 
          RowBox[{
           RowBox[{"TickNudge", " ", "is", " ", "an", " ", "edge"}], "-", 
           "by", "-", 
           RowBox[{"edge", " ", "list"}]}], ",", " ", 
          RowBox[{
          "and", " ", "the", " ", "Ticks", " ", "are", " ", "given", " ", 
           "for", " ", "the", " ", "whole", " ", "frame"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"Frame", "/.", "FullOpts"}], ")"}], "&&", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"ShowEdge", "/.", "FullOpts"}], ")"}], "[", 
              RowBox[{"[", "AxisIndex", "]"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BasicAxis", "[", 
             RowBox[{
             "Caller", ",", "\[IndentingNewLine]", "CanvasRange", ",", 
              "\[IndentingNewLine]", "AxisIndex", ",", "\[IndentingNewLine]", 
              
              RowBox[{
               RowBox[{"(", 
                RowBox[{"ShowEdge", "/.", "FullOpts"}], ")"}], "[", 
               RowBox[{"[", "AxisIndex", "]"}], "]"}], ",", 
              "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", 
              RowBox[{"DeducedFrameTicks", "[", 
               RowBox[{"[", "AxisIndex", "]"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Flatten", "[", 
               RowBox[{"{", 
                RowBox[{"DeducedFrameLabelOptions", ",", 
                 RowBox[{"TickNudge", "\[Rule]", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"TickNudge", "/.", "FullOpts"}], ")"}], "[", 
                   RowBox[{"[", "AxisIndex", "]"}], "]"}]}], ",", 
                 "FullOpts"}], "}"}], "]"}]}], "\[IndentingNewLine]", "]"}]}],
            "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"AxisIndex", ",", "1", ",", "4"}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"panel", " ", "letter"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"PanelLetterPosn", "=", 
          RowBox[{
           RowBox[{"PCOfPS", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"PanelLetterCorner", "/.", "FullOpts"}], ")"}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], "\[Rule]", "0"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"PanelLetterCorner", "/.", "FullOpts"}], ")"}], "*", 
            RowBox[{"DPCOfPA", "@", 
             RowBox[{"(", 
              RowBox[{"PanelLetterInset", "/.", "FullOpts"}], ")"}]}]}]}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"MakeText", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"PanelLetter", "/.", "FullOpts"}], ")"}], ",", " ", 
           "PanelLetterPosn", ",", "0", ",", "\[IndentingNewLine]", 
           RowBox[{"ShowText", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"ShowPanelLetter", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Offset", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"PanelLetterOffset", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", "FullOpts"}], "]"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Nudge", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"PanelLetterNudge", "/.", "FullOpts"}], ")"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Orientation", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"PanelLetterOrientation", "/.", "FullOpts"}], ")"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Background", "->", 
            RowBox[{"(", 
             RowBox[{"PanelLetterBackground", "/.", "FullOpts"}], ")"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"FontFamily", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"PanelLetterFontFamily", ",", 
              RowBox[{"FontFamily", "/.", "FullOpts"}], ",", "FullOpts"}], 
             "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"FontSize", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"PanelLetterFontSize", ",", 
              RowBox[{"FontSize", "/.", "FullOpts"}], ",", "FullOpts"}], 
             "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"FontWeight", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"PanelLetterFontWeight", ",", 
              RowBox[{"FontWeight", "/.", "FullOpts"}], ",", "FullOpts"}], 
             "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"FontSlant", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"PanelLetterFontSlant", ",", 
              RowBox[{"FontSlant", "/.", "FullOpts"}], ",", "FullOpts"}], 
             "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"FontTracking", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"PanelLetterFontTracking", ",", 
              RowBox[{"FontTracking", "/.", "FullOpts"}], ",", "FullOpts"}], 
             "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"PanelLetterFontColor", ",", 
              RowBox[{"FontColor", "/.", "FullOpts"}], ",", "FullOpts"}], 
             "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"FontOpacity", "\[Rule]", 
            RowBox[{"GetAutoOption", "[", 
             RowBox[{"PanelLetterFontOpacity", ",", 
              RowBox[{"FontOpacity", "/.", "FullOpts"}], ",", "FullOpts"}], 
             "]"}]}], ",", "\[IndentingNewLine]", "FullOpts"}], " ", 
          "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FigurePanel", "[", 
     RowBox[{
      RowBox[{"CanvasRange", ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"FullOpts", "=", 
         RowBox[{"FigRealizeOptions", "[", 
          RowBox[{"FigurePanel", ",", "Opts"}], "]"}]}], ",", 
        "\[IndentingNewLine]", "AugmentedOpts"}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"AugmentedOpts", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ClipToRectangle", "\[Rule]", "False"}], ",", "FullOpts"}],
           "}"}], "]"}]}], ";", "  ", 
       RowBox[{"(*", " ", 
        RowBox[{"provide", " ", "ClipToRectangle", " ", "value"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"BasicFigurePanel", "[", 
        RowBox[{"FigurePanel", ",", "CanvasRange", ",", "AugmentedOpts"}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"DEBUGGING", ":", " ", 
     RowBox[{
     "Version", " ", "with", " ", "zero", " ", "arguments", " ", "could", " ",
       "in", " ", "principle", " ", "be", " ", "accomplished", " ", "by", " ",
       "putting", " ", "$CanvasRange", " ", "as", " ", "default", " ", 
      "value", " ", "for", " ", "CanvasRange", " ", "argument", " ", 
      "above"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "but", " ", "this", " ", "pattern", " ", "for", " ", "argument", " ", 
      "leads", " ", "to", " ", "fall"}], "-", 
     RowBox[{
     "through", " ", "to", " ", "\"\<unrecognized argument\>\"", " ", 
      "handler", " ", 
      RowBox[{"instead", "."}]}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FigurePanel", "[", 
    RowBox[{"Opts___", "?", "OptionQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"FigurePanel", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "AugmentedOpts"}], "\[IndentingNewLine]", "}"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"AugmentedOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ClipToRectangle", "\[Rule]", "False"}], ",", "FullOpts"}], 
         "}"}], "]"}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"provide", " ", "ClipToRectangle", " ", "value"}], " ", "*)"}],
       "\[IndentingNewLine]", 
      RowBox[{"BasicFigurePanel", "[", 
       RowBox[{"FigurePanel", ",", "$CanvasRange", ",", "AugmentedOpts"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScaledFigurePanel", "[", 
    RowBox[{
     RowBox[{"ScaledRange", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1s_", "?", "NumericQ"}], ",", 
          RowBox[{"x2s_", "?", "NumericQ"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"y1s_", "?", "NumericQ"}], ",", 
          RowBox[{"y2s_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"ScaledFigurePanel", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "AugmentedOpts"}], "\[IndentingNewLine]", "}"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"AugmentedOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ClipToRectangle", "\[Rule]", "False"}], ",", "FullOpts"}], 
         "}"}], "]"}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"provide", " ", "ClipToRectangle", " ", "value"}], " ", "*)"}],
       "\[IndentingNewLine]", 
      RowBox[{"BasicFigurePanel", "[", 
       RowBox[{"ScaledFigurePanel", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XCOfXS", "/@", 
           RowBox[{"{", 
            RowBox[{"x1s", ",", "x2s"}], "}"}]}], ",", 
          RowBox[{"YCOfYS", "/@", 
           RowBox[{"{", 
            RowBox[{"y1s", ",", "y2s"}], "}"}]}]}], "}"}], ",", 
        "AugmentedOpts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395092363140625*^9, 3.39509240184375*^9}, {
   3.3955212514375*^9, 3.39552125159375*^9}, {3.396557940734375*^9, 
   3.396557970265625*^9}, {3.39663460271875*^9, 3.39663461853125*^9}, {
   3.39663702675*^9, 3.396637044921875*^9}, {3.3966371118125*^9, 
   3.39663713953125*^9}, 3.421621157828125*^9, {3.421621223765625*^9, 
   3.42162132246875*^9}, {3.421621372546875*^9, 3.421621391296875*^9}, {
   3.421621644875*^9, 3.421621649375*^9}, {3.4216219961875*^9, 
   3.421621996390625*^9}, {3.42162214678125*^9, 3.421622153390625*^9}, 
   3.421622271234375*^9, {3.426013564328125*^9, 3.426013580359375*^9}, 
   3.42601373071875*^9, {3.426015091453125*^9, 3.426015093625*^9}, {
   3.426015177421875*^9, 3.4260151815*^9}, {3.428182332265625*^9, 
   3.428182389015625*^9}, {3.4281824724375*^9, 3.428182475703125*^9}, {
   3.428182517734375*^9, 3.4281825638125*^9}, {3.4282518810625*^9, 
   3.42825192675*^9}, 3.428251957546875*^9, {3.428252357921875*^9, 
   3.4282523915625*^9}, {3.4282524818125*^9, 3.42825252175*^9}, {
   3.43448580409375*^9, 3.434485805921875*^9}, {3.434485842140625*^9, 
   3.43448596346875*^9}, {3.434486539859375*^9, 3.434486592515625*^9}, {
   3.434486640984375*^9, 3.434486644015625*^9}, {3.434486678484375*^9, 
   3.43448668234375*^9}, {3.43448671859375*^9, 3.4344867230625*^9}, {
   3.434486759390625*^9, 3.434486771734375*^9}, {3.434487170578125*^9, 
   3.434487294078125*^9}, {3.4344881534375*^9, 3.434488178765625*^9}, 
   3.434488331359375*^9, {3.434488534140625*^9, 3.43448853721875*^9}, {
   3.464878469421875*^9, 3.464878471515625*^9}, {3.4648785798125*^9, 
   3.464878658484375*^9}, {3.4648786891875*^9, 3.46487874365625*^9}, 
   3.464878785953125*^9, {3.464879080015625*^9, 3.4648790874375*^9}, {
   3.4648793753125*^9, 3.464879387046875*^9}, {3.464879448296875*^9, 
   3.464879523765625*^9}, {3.464879673015625*^9, 3.46487968625*^9}, {
   3.464879725609375*^9, 3.464879726515625*^9}, {3.4648798*^9, 
   3.464879844390625*^9}, {3.4648799215*^9, 3.464879954875*^9}, {
   3.4648800825*^9, 3.4648800855*^9}, {3.46488040646875*^9, 
   3.4648804488125*^9}, {3.464880479265625*^9, 3.46488048446875*^9}, {
   3.46488055553125*^9, 3.464880582796875*^9}, {3.464880682171875*^9, 
   3.464880684671875*^9}, {3.46488073640625*^9, 3.46488087884375*^9}, 
   3.464880909421875*^9, {3.464881024375*^9, 3.46488102640625*^9}, {
   3.464881137234375*^9, 3.464881141953125*^9}, {3.464881267984375*^9, 
   3.46488133021875*^9}, {3.46488143178125*^9, 3.46488150634375*^9}, 
   3.4648817776875*^9, {3.4648819833125*^9, 3.464882036453125*^9}, {
   3.464882660859375*^9, 3.464882668*^9}, {3.46488270709375*^9, 
   3.4648827215625*^9}, 3.4648828583125*^9, {3.466946775984375*^9, 
   3.466946793078125*^9}, {3.466946837671875*^9, 3.466946867078125*^9}, {
   3.4669469046875*^9, 3.46694691925*^9}, {3.46694695353125*^9, 
   3.46694695584375*^9}, {3.466947038171875*^9, 3.466947038484375*^9}, {
   3.466947128578125*^9, 3.46694726684375*^9}, {3.466947424125*^9, 
   3.46694745878125*^9}, {3.466947493078125*^9, 3.46694750615625*^9}, {
   3.4669482303125*^9, 3.46694823440625*^9}, 3.4669483146875*^9, {
   3.496055698671875*^9, 3.4960556986875*^9}, {3.49738389103125*^9, 
   3.49738390515625*^9}, {3.49738431840625*^9, 3.497384348984375*^9}, {
   3.49738448621875*^9, 3.49738449065625*^9}, {3.49738452271875*^9, 
   3.497384678375*^9}}],

Cell["\<\
Option processing for Panel[{row,column}]

Since FigRealizeOptions was already used to generate \
LevelScheme`Multipanel`PanelOptions at the initial Multipanel invocation, it \
is only needed here in case the user now gives Inherited for any explicitly \
specified options and for validation of explicitly specified options.

Before we can obtain the multipanel deduced options, we come up with the \
preliminary option set FullOpts, for which the precedence is 
\t(1) explicitly specified Opts
\t(2) frozen default option values LevelScheme`Multipanel`PanelOptions
\t(3) present defaults for Panel (only affects a handful of options which \
will be superseded anyway by multipanel deduced options)
This preliminary set is needed since the multipanel deduced value of \
PanelLetter is affected by the value of the options First, etc.  It is also \
used to directly to allow panel-by-panel overrides for some multipanel \
options which did not require any processing in Multipanel.
The ultimate precedence of options is 
\t(1) explicitly specified Opts
\t(2) multipanel-based deduced options
\t(3) frozen default option values LevelScheme`Multipanel`PanelOptions
\t(X) present defaults for Panel (irrelevant, since guaranteed to be \
superseded by the frozen values or deduced options)
\
\>", "Text",
 CellChangeTimes->{{3.43448701290625*^9, 3.4344870801875*^9}, 
   3.496055698703125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FigurePanel", "[", 
    RowBox[{
     RowBox[{"PanelIndices", ":", 
      RowBox[{"{", 
       RowBox[{"Row_Integer", ",", "Column_Integer"}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"FigurePanel", ",", 
          RowBox[{"{", 
           RowBox[{"Opts", ",", "LevelScheme`Multipanel`PanelOptions"}], 
           "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", "DeducedFullOpts", 
       ",", "\[IndentingNewLine]", "OptPanelShift", ",", 
       "OptPanelAdjustments", ",", "\[IndentingNewLine]", "CanvasRange", ",", 
       "MultipanelPlotRange", ",", "ExpandedPlotRange", ",", "XYPlotRange", 
       ",", "DeducedPlotRange", ",", "\[IndentingNewLine]", 
       "DeducedFrameLabel", ",", "DeducedShowFrameLabels", ",", 
       "\[IndentingNewLine]", "DeducedFrameTicks", ",", 
       "DeducedShowTickLabels", ",", "DeducedTickLabelMargin", ",", 
       "\[IndentingNewLine]", "DeducedPanelLetter", ",", 
       "\[IndentingNewLine]", "DeducedOptions", ",", "\[IndentingNewLine]", 
       "AugmentedOpts", ",", "\[IndentingNewLine]", "DeducedExteriorMask"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"ValueQ", "[", "LevelScheme`Multipanel`Dimension", "]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{"FigurePanel", "::", "undefined"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"TrueQ", "[", 
          RowBox[{"InRegion", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
            "LevelScheme`Multipanel`Dimension", ",", "PanelIndices"}], "]"}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"FigurePanel", "::", "badij"}], ",", "PanelIndices"}], 
         "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PlotRange", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PanelShift", ",", 
        RowBox[{"None", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PanelAdjustments", ",", 
        RowBox[{"None", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"_", "?", "NumericQ"}], ",", 
             RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowFrameLabelsInterior", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowFrameLabelsExterior", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTickLabelsInterior", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowTickLabelsExterior", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}], ",", 
          RowBox[{"True", "|", "False"}]}], "}"}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ExteriorMask", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"(", 
          RowBox[{"_", "?", "FrameMaskListQ"}], ")"}]}], ",", "FullOpts"}], 
       "]"}], ";", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"LevelScheme`Multipanel`PanelIndices", "=", "PanelIndices"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"calculate", " ", "geometry"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"OptPanelShift", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"PanelShift", "/.", "FullOpts"}], ")"}], "===", "None"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"(", 
          RowBox[{"PanelShift", "/.", "FullOpts"}], ")"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptPanelAdjustments", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"PanelAdjustments", "/.", "FullOpts"}], ")"}], "===", 
          "None"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"(", 
          RowBox[{"PanelAdjustments", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CanvasRange", "=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"LevelScheme`Multipanel`XRegionRangeList", "[", 
           RowBox[{"[", "Column", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"OptPanelShift", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", 
           "LevelScheme`Multipanel`CanvasXUnit"}], "+", 
          RowBox[{
           RowBox[{"OptPanelAdjustments", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], "*", 
           "LevelScheme`Multipanel`CanvasXUnit"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Multipanel`YRegionRangeList", "[", 
           RowBox[{"[", "Row", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"OptPanelShift", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           "LevelScheme`Multipanel`CanvasYUnit"}], "+", 
          RowBox[{
           RowBox[{"OptPanelAdjustments", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], "*", 
           "LevelScheme`Multipanel`CanvasYUnit"}]}]}], "\[IndentingNewLine]", 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"calculate", " ", "plot", " ", "range"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", "1", ")"}], " ", "expand", " ", "PlotRange", " ", 
          "value", " ", "Automatic", " ", "to", " ", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ";", " ", 
         RowBox[{
          RowBox[{"(", "2", ")"}], " ", "for", " ", "each", " ", 
          "coordinate"}]}], ",", " ", 
        RowBox[{
        "use", " ", "explicit", " ", "range", " ", "if", " ", "given", " ", 
         "in", " ", "PlotRange"}], ",", " ", 
        RowBox[{
         RowBox[{
         "or", " ", "for", " ", "Automatic", " ", "default", " ", "to", " ", 
          "separate", " ", "XPlotRange", " ", "and", " ", "YPlotRange"}], ";",
          " ", 
         RowBox[{
          RowBox[{"(", "3", ")"}], " ", "for", " ", "XPlotRange", " ", "and", 
          " ", "YPlotRange"}]}], ",", " ", 
        RowBox[{
         RowBox[{
         "use", " ", "explicit", " ", "ranges", " ", "if", " ", "given", " ", 
          "or", " ", "else", " ", "for", " ", "Automatic", " ", "default", 
          " ", "to", " ", "range", " ", "for", " ", "this", " ", "row", " ", 
          "and", " ", "column", " ", "specified", " ", "to", " ", 
          "Multipanel"}], ";", " ", 
         RowBox[{
          RowBox[{"(", "4", ")"}], " ", "note", " ", "that", " ", "if", " ", 
          "Multipanel", " ", "range", " ", "is", " ", "in", " ", "turn", " ", 
          "Automatic"}]}], ",", " ", 
        RowBox[{
        "BasicPanel", " ", "will", " ", "later", " ", "extend", " ", "this", 
         " ", "range", " ", "if", " ", "necessary", " ", "and", " ", 
         "convert", " ", "this", " ", "to", " ", "the", " ", "range", " ", 
         "of", " ", "canvas", " ", "coordinates", " ", "covered", " ", "by", 
         " ", "the", " ", "panel"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"MultipanelPlotRange", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"LevelScheme`Multipanel`XPlotRanges", "[", 
          RowBox[{"[", 
           RowBox[{"Row", ",", "Column"}], "]"}], "]"}], ",", 
         RowBox[{"LevelScheme`Multipanel`YPlotRanges", "[", 
          RowBox[{"[", 
           RowBox[{"Row", ",", "Column"}], "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ExpandedPlotRange", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"PlotRange", ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", "FullOpts"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"XYPlotRange", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Replace", "[", 
            RowBox[{"#1", ",", 
             RowBox[{"Automatic", "\[Rule]", "#2"}]}], "]"}], "&"}], ")"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"ExpandedPlotRange", ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"XPlotRange", ",", "YPlotRange"}], "}"}], "/.", 
            "FullOpts"}]}], "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedPlotRange", "=", 
       RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Replace", "[", 
            RowBox[{"#1", ",", 
             RowBox[{"Automatic", "\[Rule]", "#2"}]}], "]"}], "&"}], ")"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"XYPlotRange", ",", "MultipanelPlotRange"}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "exterior", " ", "mask", " ", "for", " ", "edges", " ", "of", " ", 
        "current", " ", "panel"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedExteriorMask", "=", 
       RowBox[{"GetAutoOption", "[", "\[IndentingNewLine]", 
        RowBox[{"ExteriorMask", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Row", "==", 
            RowBox[{"LevelScheme`Multipanel`Dimension", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Column", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Row", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Column", "==", 
            RowBox[{"LevelScheme`Multipanel`Dimension", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", "}"}],
          ",", "\[IndentingNewLine]", "FullOpts"}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"deduce", " ", "labels"}], " ", "*)"}], "\[IndentingNewLine]", 
      
      RowBox[{"DeducedFrameLabel", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"LevelScheme`Multipanel`XFrameLabels", "[", 
          RowBox[{"[", 
           RowBox[{"Row", ",", "Column"}], "]"}], "]"}], ",", 
         RowBox[{"LevelScheme`Multipanel`YFrameLabels", "[", 
          RowBox[{"[", 
           RowBox[{"Row", ",", "Column"}], "]"}], "]"}], ",", "None", ",", 
         "None"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DeducedShowFrameLabels", "=", 
       RowBox[{"GetAutoOption", "[", "\[IndentingNewLine]", 
        RowBox[{"ShowFrameLabels", ",", "\[IndentingNewLine]", 
         RowBox[{"ListableOr", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ListableAnd", "[", 
            RowBox[{"DeducedExteriorMask", ",", 
             RowBox[{"(", 
              RowBox[{"ShowFrameLabelsExterior", "/.", "FullOpts"}], ")"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"ListableAnd", "[", 
            RowBox[{
             RowBox[{"ListableNot", "[", "DeducedExteriorMask", "]"}], ",", 
             RowBox[{"(", 
              RowBox[{"ShowFrameLabelsInterior", "/.", "FullOpts"}], ")"}]}], 
            "]"}]}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]",
          "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"deduce", " ", "ticks"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedFrameTicks", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"LevelScheme`Multipanel`XFrameTicks", "[", 
          RowBox[{"[", 
           RowBox[{"Row", ",", "Column"}], "]"}], "]"}], ",", 
         RowBox[{"LevelScheme`Multipanel`YFrameTicks", "[", 
          RowBox[{"[", 
           RowBox[{"Row", ",", "Column"}], "]"}], "]"}], ",", 
         RowBox[{"LevelScheme`Multipanel`XFrameTicks", "[", 
          RowBox[{"[", 
           RowBox[{"Row", ",", "Column"}], "]"}], "]"}], ",", 
         RowBox[{"LevelScheme`Multipanel`YFrameTicks", "[", 
          RowBox[{"[", 
           RowBox[{"Row", ",", "Column"}], "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"deduce", " ", "tick", " ", "label", " ", "sides"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "condition", " ", "for", " ", "tick", " ", "labels", " ", "to", " ", 
        "be", " ", "shown", " ", "is", " ", 
        RowBox[{"(", 
         RowBox[{"outer", " ", "edge"}], ")"}], " ", "AND", " ", 
        RowBox[{"(", 
         RowBox[{
         "edge", " ", "allowed", " ", "by", " ", "ShowTickLabels", " ", 
          "option", " ", "at", " ", "time", " ", "of", " ", "Multipanel", " ",
           "invocation"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedShowTickLabels", "=", 
       RowBox[{"GetAutoOption", "[", "\[IndentingNewLine]", 
        RowBox[{"ShowTickLabels", ",", "\[IndentingNewLine]", 
         RowBox[{"ListableOr", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ListableAnd", "[", 
            RowBox[{"DeducedExteriorMask", ",", 
             RowBox[{"(", 
              RowBox[{"ShowTickLabelsExterior", "/.", "FullOpts"}], ")"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"ListableAnd", "[", 
            RowBox[{
             RowBox[{"ListableNot", "[", "DeducedExteriorMask", "]"}], ",", 
             RowBox[{"(", 
              RowBox[{"ShowTickLabelsInterior", "/.", "FullOpts"}], ")"}]}], 
            "]"}]}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]",
          "FullOpts"}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"for", " ", "automatic", " ", "ticks"}], ",", " ", 
        RowBox[{
        "suppress", " ", "X", " ", "final", " ", "tick", " ", "unless", " ", 
         "right", " ", "exterior"}], ",", " ", 
        RowBox[{
        "Y", " ", "final", " ", "tick", " ", "unless", " ", "top", " ", 
         "exterior"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DeducedTickLabelMargin", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"TickLabelAutoSuppress", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Switch", "[", 
            RowBox[{
             RowBox[{"DeducedExteriorMask", "[", 
              RowBox[{"[", "4", "]"}], "]"}], ",", "False", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "5"}], "}"}], ",", "True", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Switch", "[", 
            RowBox[{
             RowBox[{"DeducedExteriorMask", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", "False", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "5"}], "}"}], ",", "True", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"deduce", " ", "panel", " ", "label"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedPanelLetter", "=", 
       RowBox[{"PanelLetter", "[", 
        RowBox[{"LegacyFilterOptions", "[", 
         RowBox[{"PanelLetter", ",", "FullOpts"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"combine", " ", "deduced", " ", "options"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"DeducedOptions", "=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"PlotRange", "\[Rule]", "DeducedPlotRange"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FrameLabel", "\[Rule]", "Automatic"}], ",", " ", 
         RowBox[{"(*", " ", 
          RowBox[{
          "for", " ", "easier", " ", "user", " ", "override", " ", "with", 
           " ", "LabX"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Margin", "\[Rule]", "0"}], ",", " ", 
         RowBox[{"(*", " ", 
          RowBox[{
          "override", " ", "different", " ", "meaning", " ", "of", " ", 
           "Margin", " ", "for", " ", "Multipanel"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"LabB", "->", 
          RowBox[{"DeducedFrameLabel", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"LabL", "->", 
          RowBox[{"DeducedFrameLabel", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{"LabT", "\[Rule]", 
          RowBox[{"DeducedFrameLabel", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", 
         RowBox[{"LabR", "\[Rule]", 
          RowBox[{"DeducedFrameLabel", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"ShowFrameLabels", "\[Rule]", "DeducedShowFrameLabels"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"FrameTicks", "->", "DeducedFrameTicks"}], ",", 
         RowBox[{"ShowTickLabels", "->", "DeducedShowTickLabels"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PanelLetter", "\[Rule]", "DeducedPanelLetter"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"TickLabelMargin", "->", "DeducedTickLabelMargin"}]}], 
        "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DeducedFullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"FigurePanel", ",", 
         RowBox[{"{", 
          RowBox[{
          "Opts", ",", "DeducedOptions", ",", 
           "LevelScheme`Multipanel`PanelOptions"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AugmentedOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ClipToRectangle", "\[Rule]", "False"}], ",", 
          "DeducedFullOpts"}], "}"}], "]"}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"provide", " ", "ClipToRectangle", " ", "value"}], " ", "*)"}],
       "\[IndentingNewLine]", 
      RowBox[{"BasicFigurePanel", "[", 
       RowBox[{"FigurePanel", ",", "CanvasRange", ",", "AugmentedOpts"}], 
       "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.3950898706875*^9, {3.3950924155625*^9, 3.39509244471875*^9}, {
   3.395521251609375*^9, 3.395521251671875*^9}, {3.42162167734375*^9, 
   3.421621706703125*^9}, 3.421621738765625*^9, {3.42162177121875*^9, 
   3.42162193578125*^9}, {3.421621981734375*^9, 3.42162198853125*^9}, 
   3.424458982375*^9, {3.424459019046875*^9, 3.42445905275*^9}, {
   3.424459290515625*^9, 3.42445929296875*^9}, {3.42445938315625*^9, 
   3.424459384671875*^9}, {3.428180539203125*^9, 3.4281805459375*^9}, {
   3.42825224190625*^9, 3.42825226384375*^9}, {3.428252526625*^9, 
   3.42825253915625*^9}, {3.434486184421875*^9, 3.434486197921875*^9}, {
   3.434487556890625*^9, 3.4344875836875*^9}, {3.434487785046875*^9, 
   3.434487818921875*^9}, {3.4344882759375*^9, 3.434488293546875*^9}, {
   3.434488347078125*^9, 3.434488350203125*^9}, {3.434488447609375*^9, 
   3.434488467875*^9}, {3.434488695265625*^9, 3.434488705890625*^9}, {
   3.4595462916875*^9, 3.459546323671875*^9}, {3.459546356328125*^9, 
   3.45954637771875*^9}, {3.4595464913125*^9, 3.459546527234375*^9}, {
   3.45954698784375*^9, 3.459546991125*^9}, {3.464882164671875*^9, 
   3.4648821665*^9}, {3.4648822711875*^9, 3.4648822774375*^9}, {
   3.464882320109375*^9, 3.4648823565625*^9}, 3.46488239271875*^9, {
   3.4648824270625*^9, 3.46488244265625*^9}, {3.464882522328125*^9, 
   3.464882525875*^9}, {3.464882578375*^9, 3.464882596921875*^9}, {
   3.464882773609375*^9, 3.464882786859375*^9}, {3.49605569871875*^9, 
   3.496055698734375*^9}, {3.502559044984375*^9, 3.5025590460625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["PanelLetter", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PanelLetter", "[", 
    RowBox[{"Opts___", "?", "OptionQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"PanelLetter", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "StartLetterCode", ",", "Letter", ",", 
       "\[IndentingNewLine]", "i", ",", "j"}], "\[IndentingNewLine]", "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Order", ",", 
        RowBox[{"Horizontal", "|", "Vertical"}], ",", "FullOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PanelLetterOrigin", ",", 
        RowBox[{"{", 
         RowBox[{"_Integer", ",", "_Integer"}], "}"}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"LevelScheme`Multipanel`PanelIndices", "===", "None"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{"PanelLetter", "::", "nopanel"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"StartLetterCode", "=", 
       RowBox[{"ToCharacterCode", "[", 
        RowBox[{"First", "/.", "FullOpts"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j"}], "}"}], "=", 
       RowBox[{"LevelScheme`Multipanel`PanelIndices", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"PanelLetterOrigin", "/.", "FullOpts"}], ")"}], "-", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Letter", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Order", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
         "Horizontal", ",", 
         RowBox[{"FromCharacterCode", "[", 
          RowBox[{"StartLetterCode", "+", 
           RowBox[{
            RowBox[{"LevelScheme`Multipanel`Dimension", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}]}], "+", 
           RowBox[{"(", 
            RowBox[{"j", "-", "1"}], ")"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "Vertical", ",", 
         RowBox[{"FromCharacterCode", "[", 
          RowBox[{"StartLetterCode", "+", 
           RowBox[{"(", 
            RowBox[{"i", "-", "1"}], ")"}], "+", 
           RowBox[{
            RowBox[{"LevelScheme`Multipanel`Dimension", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "*", 
            RowBox[{"(", 
             RowBox[{"j", "-", "1"}], ")"}]}]}], "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Format", "/.", "FullOpts"}], ")"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "<>", "Letter", "<>", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Format", "/.", "FullOpts"}], ")"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.434484744546875*^9, 3.434484799953125*^9}, 
   3.49605569875*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data plotting -- UNDER DEVELOPMENT", "Section"],

Cell[CellGroupData[{

Cell["Data utilities", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AttachIndex", "[", 
    RowBox[{"Values_List", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"AttachIndex", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "s", ",", "x0"}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"First", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ScaleFactor", ",", 
        RowBox[{"_", "?", "NumericQ"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Range", ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"_", "?", "NumericQ"}], ",", 
           RowBox[{"_", "?", "NumericQ"}]}], "}"}], "|", "Automatic"}], ",", 
        "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
        RowBox[{"Range", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
        "Automatic", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"s", "=", 
          RowBox[{"(", 
           RowBox[{"ScaleFactor", "/.", "FullOpts"}], ")"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"x0", "=", 
          RowBox[{"(", 
           RowBox[{"First", "/.", "FullOpts"}], ")"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"_", "?", "NumericQ"}], ",", 
          RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"s", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Subtract", "@@", 
             RowBox[{"Reverse", "[", 
              RowBox[{"Range", "/.", "FullOpts"}], "]"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "Values", "]"}], "-", "1"}], ")"}]}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"x0", "=", 
          RowBox[{"First", "[", 
           RowBox[{"Range", "/.", "FullOpts"}], "]"}]}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"MapIndexed", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"s", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"First", "[", "#2", "]"}], "-", "1"}], ")"}]}], "+", 
            "x0"}], ",", "#1"}], "}"}], "&"}], ",", "Values"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.398797165328125*^9, 3.3987971661875*^9}, 
   3.49605569875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DataValueQ", "[", "x_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"_", "?", "RealNumericQ"}], ")"}], "|", "None"}], ")"}], "|", 
      RowBox[{"ErrorValue", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"_", "?", "RealNumericQ"}], ")"}], "|", "None"}], ")"}], 
        ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "RealNumericQ"}], ")"}], "|", "None", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"_", "?", "RealNumericQ"}], ")"}], "|", "None"}], ")"}],
            ",", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"_", "?", "RealNumericQ"}], ")"}], "|", "None"}], 
            ")"}]}], "}"}]}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataValueNoneQ", "[", "x_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", "None", ")"}], "|", 
      RowBox[{"ErrorValue", "[", 
       RowBox[{"None", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "RealNumericQ"}], ")"}], "|", "None", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"_", "?", "RealNumericQ"}], ")"}], "|", "None"}], ")"}],
            ",", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"_", "?", "RealNumericQ"}], ")"}], "|", "None"}], 
            ")"}]}], "}"}]}]}], "]"}]}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DataPointQ", "[", "x_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"x", ",", 
     RowBox[{"None", "|", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "DataValueQ"}], ",", 
        RowBox[{"_", "?", "DataValueQ"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataPointNoneQ", "[", "x_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"x", ",", 
     RowBox[{"None", "|", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "DataValueNoneQ"}], ",", 
        RowBox[{"_", "?", "DataValueQ"}]}], "}"}], "|", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "DataValueQ"}], ",", 
        RowBox[{"_", "?", "DataValueNoneQ"}]}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4825323711875*^9, 3.48253237209375*^9}, {
  3.48253244209375*^9, 3.48253244975*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataSetQ", "[", "x_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "DataPointQ"}], ")"}], "..."}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.48253236728125*^9, 3.482532367890625*^9}, {
   3.4825327575*^9, 3.48253276546875*^9}, 3.48253309696875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data filtering", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SelectData", "[", 
     RowBox[{"Test_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "[", 
    RowBox[{"Data_", "?", "DataSetQ"}], "]"}], ":=", 
   RowBox[{"Replace", "[", 
    RowBox[{"Data", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}], "?", 
       RowBox[{"(", 
        RowBox[{"Composition", "[", 
         RowBox[{"Not", ",", "Test"}], "]"}], ")"}]}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExcludeData", "[", 
     RowBox[{"Test_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "[", 
    RowBox[{"Data_", "?", "DataSetQ"}], "]"}], ":=", 
   RowBox[{"Replace", "[", 
    RowBox[{"Data", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}], "?", "Test"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TransformData", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "[", 
    RowBox[{"Data_", "?", "DataSetQ"}], "]"}], ":=", 
   RowBox[{"Replace", "[", 
    RowBox[{"Data", ",", 
     RowBox[{
      RowBox[{"x", ":", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_"}], "}"}]}], ":>", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DownsampleData", "[", 
     RowBox[{"n_Integer", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "[", 
    RowBox[{"Data_", "?", "DataSetQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "=", "0"}], "}"}], ",", 
     RowBox[{"Select", "[", 
      RowBox[{"Data", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Mod", "[", 
           RowBox[{
            RowBox[{"i", "++"}], ",", "n"}], "]"}], "\[Equal]", "0"}], "&"}], 
        ")"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.482533876671875*^9, 3.482533879953125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"XRange", "[", 
    RowBox[{
     RowBox[{"x1_", "?", "RealNumericQ"}], ",", 
     RowBox[{"x2_", "?", "RealNumericQ"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"InRange", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1", ",", "x2"}], "}"}], ",", 
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "&"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"YRange", "[", 
    RowBox[{
     RowBox[{"y1_", "?", "RealNumericQ"}], ",", 
     RowBox[{"y2_", "?", "RealNumericQ"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"InRange", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y1", ",", "y2"}], "}"}], ",", 
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"InPlotRegion", ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"InRegion", "[", 
      RowBox[{"$RegionRange", ",", 
       RowBox[{"PCOfPU", "[", "#", "]"}]}], "]"}], "&"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LimitX", "[", 
    RowBox[{
     RowBox[{"x1_", "?", "RealNumericQ"}], ",", 
     RowBox[{"x2_", "?", "RealNumericQ"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Switch", "[", 
      RowBox[{"#", ",", 
       RowBox[{"_", "?", 
        RowBox[{"(", 
         RowBox[{"XRange", "[", 
          RowBox[{"x1", ",", "x2"}], "]"}], ")"}]}], ",", "#", ",", 
       RowBox[{"_", "?", 
        RowBox[{"(", 
         RowBox[{"XRange", "[", 
          RowBox[{
           RowBox[{"-", "Infinity"}], ",", "x1"}], "]"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x1", ",", 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"_", "?", 
        RowBox[{"(", 
         RowBox[{"XRange", "[", 
          RowBox[{"x2", ",", 
           RowBox[{"+", "Infinity"}]}], "]"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x2", ",", 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", "_", ",", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"LimitX", "::", "badvalue"}], ",", "#"}], "]"}]}], "]"}], 
     "&"}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LimitY", "[", 
    RowBox[{
     RowBox[{"y1_", "?", "RealNumericQ"}], ",", 
     RowBox[{"y2_", "?", "RealNumericQ"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Switch", "[", 
      RowBox[{"#", ",", 
       RowBox[{"_", "?", 
        RowBox[{"(", 
         RowBox[{"YRange", "[", 
          RowBox[{"y1", ",", "y2"}], "]"}], ")"}]}], ",", "#", ",", 
       RowBox[{"_", "?", 
        RowBox[{"(", 
         RowBox[{"YRange", "[", 
          RowBox[{
           RowBox[{"-", "Infinity"}], ",", "y1"}], "]"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "y1"}], "}"}], ",", 
       RowBox[{"_", "?", 
        RowBox[{"(", 
         RowBox[{"YRange", "[", 
          RowBox[{"y2", ",", 
           RowBox[{"+", "Infinity"}]}], "]"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "y2"}], "}"}], ",", "_", ",", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"LimitY", "::", "badvalue"}], ",", "#"}], "]"}]}], "]"}], 
     "&"}], ")"}]}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Line shape definitions", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DataLineShape", "[", 
     RowBox[{"\"\<Straight\>\"", ",", "n_"}], "]"}], "[", "Points_List", 
    "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "Points", "]"}], "<", "2"}], ",", 
        RowBox[{"Return", "[", 
         RowBox[{"{", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      "Points"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DataLineShape", "[", 
     RowBox[{"\"\<Step\>\"", ",", "n_"}], "]"}], "[", "Points_List", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "Points", "]"}], "<", "2"}], ",", 
        RowBox[{"Return", "[", 
         RowBox[{"{", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"First", "[", "Points", "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Table", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], "+", 
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], ")"}], 
                 "/", "2"}], ",", 
                RowBox[{"Last", "[", 
                 RowBox[{"Points", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], "+", 
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], ")"}], 
                 "/", "2"}], ",", 
                RowBox[{"Last", "[", 
                 RowBox[{"Points", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", 
              RowBox[{
               RowBox[{"Length", "[", "Points", "]"}], "-", "1"}]}], "}"}]}], 
           "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", "1"}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Last", "[", "Points", "]"}], "}"}]}], "\[IndentingNewLine]",
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DataLineShape", "[", 
     RowBox[{"\"\<StepAnchored\>\"", ",", "n_"}], "]"}], "[", "Points_List", 
    "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "Points", "]"}], "<", "2"}], ",", 
        RowBox[{"Return", "[", 
         RowBox[{"{", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"3", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"1", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], ")"}], ",", 
            RowBox[{"YCOfYU", "@", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"3", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"1", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], ")"}], ",", 
            RowBox[{"Last", "[", 
             RowBox[{"Points", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Table", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], "+", 
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], ")"}], 
                 "/", "2"}], ",", 
                RowBox[{"Last", "[", 
                 RowBox[{"Points", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], "+", 
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], ")"}], 
                 "/", "2"}], ",", 
                RowBox[{"Last", "[", 
                 RowBox[{"Points", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", 
              RowBox[{
               RowBox[{"Length", "[", "Points", "]"}], "-", "1"}]}], "}"}]}], 
           "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", "1"}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"3", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"1", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "2"}], "]"}], "]"}], "]"}]}]}], ")"}], ",", 
            RowBox[{"Last", "[", 
             RowBox[{"Points", "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"3", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"1", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "2"}], "]"}], "]"}], "]"}]}]}], ")"}], ",", 
            RowBox[{"YCOfYU", "@", "0"}]}], "}"}]}], "\[IndentingNewLine]", 
         "}"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DataLineShape", "[", 
     RowBox[{"\"\<Histogram\>\"", ",", "n_"}], "]"}], "[", "Points_List", 
    "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "Points", "]"}], "<", "2"}], ",", 
        RowBox[{"Return", "[", 
         RowBox[{"{", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"3", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"1", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], ")"}], ",", 
            RowBox[{"YCOfYU", "@", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"3", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"1", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], ")"}], ",", 
            RowBox[{"Last", "[", 
             RowBox[{"Points", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Table", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], "+", 
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], ")"}], 
                 "/", "2"}], ",", 
                RowBox[{"Last", "[", 
                 RowBox[{"Points", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], "+", 
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], ")"}], 
                 "/", "2"}], ",", 
                RowBox[{"YCOfYU", "@", "0"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], "+", 
                   RowBox[{"First", "[", 
                    RowBox[{"Points", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], ")"}], 
                 "/", "2"}], ",", 
                RowBox[{"Last", "[", 
                 RowBox[{"Points", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", 
              RowBox[{
               RowBox[{"Length", "[", "Points", "]"}], "-", "1"}]}], "}"}]}], 
           "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", "1"}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"3", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"1", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "2"}], "]"}], "]"}], "]"}]}]}], ")"}], ",", 
            RowBox[{"Last", "[", 
             RowBox[{"Points", "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"3", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "1"}], "]"}], "]"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"1", "/", "2"}], "*", 
               RowBox[{"First", "[", 
                RowBox[{"Points", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "2"}], "]"}], "]"}], "]"}]}]}], ")"}], ",", 
            RowBox[{"YCOfYU", "@", "0"}]}], "}"}]}], "\[IndentingNewLine]", 
         "}"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.48468545621875*^9, 3.484685460828125*^9}, 
   3.484685811671875*^9, {3.484685855890625*^9, 3.484685884390625*^9}, {
   3.4846859684375*^9, 3.484686037890625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbol shape definitions", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbolShape", "[", 
    RowBox[{"\"\<Circle\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "*", "Pi", "*", 
         RowBox[{"i", "/", "n"}]}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "*", "Pi", "*", 
         RowBox[{"i", "/", "n"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Most", "@", 
     RowBox[{"First", "@", 
      RowBox[{"N", "@", 
       RowBox[{"LegacyRegularPolygon", "[", 
        RowBox[{"3", ",", "1", ",", "0", ",", "theta"}], "]"}]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"theta", ",", "0", ",", 
      RowBox[{"3", "*", 
       RowBox[{"Pi", "/", "2"}]}], ",", 
      RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellChangeTimes->{3.39509273621875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Most", "::", "\<\"normal\"\>"}], ":", 
  " ", "\<\"Nonatomic expression expected at position \\!\\(1\\) in \
\\!\\(Most[3.`]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/normal\\\", ButtonNote -> \
\\\"Most::normal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.395090218703125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Most", "::", "\<\"normal\"\>"}], ":", 
  " ", "\<\"Nonatomic expression expected at position \\!\\(1\\) in \
\\!\\(Most[3.`]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/normal\\\", ButtonNote -> \
\\\"Most::normal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.39509021871875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Most", "::", "\<\"normal\"\>"}], ":", 
  " ", "\<\"Nonatomic expression expected at position \\!\\(1\\) in \
\\!\\(Most[3.`]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/normal\\\", ButtonNote -> \
\\\"Most::normal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.395090218734375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(Most :: \\\"normal\\\"\\) will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.39509021884375*^9}],

Cell["{Most[3.], Most[3.], Most[3.], Most[3.]}", "Output",
 CellChangeTimes->{3.395090218875*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbolShape", "[", 
    RowBox[{"\"\<UpTriangle\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"1.2", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.", ",", "1."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8660254037844386"}], ",", 
        RowBox[{"-", "0.5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8660254037844386", ",", 
        RowBox[{"-", "0.4999999999999999"}]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbolShape", "[", 
    RowBox[{"\"\<LeftTriangle\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"1.2", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1."}], ",", "0."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", 
        RowBox[{"-", "0.8660254037844386"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.4999999999999999", ",", "0.8660254037844386"}], "}"}]}], 
     "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbolShape", "[", 
    RowBox[{"\"\<DownTriangle\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"1.2", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.", ",", 
        RowBox[{"-", "1."}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8660254037844386", ",", "0.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8660254037844386"}], ",", "0.4999999999999999"}], 
       "}"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbolShape", "[", 
    RowBox[{"\"\<RightTriangle\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"1.2", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.", ",", "0."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "0.8660254037844386"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.4999999999999999"}], ",", 
        RowBox[{"-", "0.8660254037844386"}]}], "}"}]}], "}"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Most", "@", 
     RowBox[{"First", "@", 
      RowBox[{"N", "@", 
       RowBox[{"LegacyRegularPolygon", "[", 
        RowBox[{"4", ",", "1", ",", "0", ",", "theta"}], "]"}]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"theta", ",", "0", ",", 
      RowBox[{"Pi", "/", "4"}], ",", 
      RowBox[{"Pi", "/", "4"}]}], "}"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellChangeTimes->{3.39509273275*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Most", "::", "\<\"normal\"\>"}], ":", 
  " ", "\<\"Nonatomic expression expected at position \\!\\(1\\) in \
\\!\\(Most[4.`]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/normal\\\", ButtonNote -> \
\\\"Most::normal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.39509021890625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Most", "::", "\<\"normal\"\>"}], ":", 
  " ", "\<\"Nonatomic expression expected at position \\!\\(1\\) in \
\\!\\(Most[4.`]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/normal\\\", ButtonNote -> \
\\\"Most::normal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.395090218921875*^9}],

Cell["{Most[4.], Most[4.]}", "Output",
 CellChangeTimes->{3.395090218953125*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbolShape", "[", 
    RowBox[{"\"\<Square\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"1.2", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7071067811865476"}], ",", "0.7071067811865476"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7071067811865476"}], ",", 
        RowBox[{"-", "0.7071067811865476"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.7071067811865476", ",", 
        RowBox[{"-", "0.7071067811865476"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.7071067811865476", ",", "0.7071067811865476"}], "}"}]}], 
     "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbolShape", "[", 
    RowBox[{"\"\<Diamond\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"1.2", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.", ",", "1."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1."}], ",", "0."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.", ",", 
        RowBox[{"-", "1."}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.", ",", "0."}], "}"}]}], "}"}]}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataSymbolShape", "[", 
    RowBox[{"\"\<Cross\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"1.2", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7071067811865476"}], ",", "0.7071067811865476"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7071067811865476"}], ",", 
        RowBox[{"-", "0.7071067811865476"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.7071067811865476", ",", 
        RowBox[{"-", "0.7071067811865476"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.7071067811865476", ",", "0.7071067811865476"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49738316709375*^9, 3.4973832105625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbol construction", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DataSymbolVertices", "[", 
     RowBox[{"SymbolShape_", ",", 
      RowBox[{"SymbolSize_", "?", "NumericQ"}], ",", "PlotPoints_Integer"}], 
     "]"}], "[", 
    RowBox[{"P", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"_", "?", "NumericQ"}], ",", 
       RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "BasicShape", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"BasicShape", "=", 
       RowBox[{"DataSymbolShape", "[", 
        RowBox[{"SymbolShape", ",", "PlotPoints"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"MatchQ", "[", 
          RowBox[{"BasicShape", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "NumericQ"}], ",", 
               RowBox[{"_", "?", "NumericQ"}]}], "}"}], ".."}], "}"}]}], 
          "]"}]}], ",", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"DataSymbol", "::", "badsymbol"}], ",", "SymbolShape"}], 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"P", "+", "#"}], ")"}], "&"}], "/@", 
       RowBox[{"(", 
        RowBox[{"DPCOfPA", "/@", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"SymbolSize", "/", "2"}], ")"}], "*", "BasicShape"}], 
          "]"}]}], ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.464451674765625*^9, 3.4644517430625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ErrorBarPrimatives", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dx_", ",", "dy_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Capx_", ",", "Capy_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "+", 
         RowBox[{"{", 
          RowBox[{"dx", ",", "dy"}], "}"}]}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "+", 
         RowBox[{"{", 
          RowBox[{"dx", ",", "dy"}], "}"}], "-", 
         RowBox[{"DPCOfPA", "@", 
          RowBox[{"{", 
           RowBox[{"Capx", ",", "Capy"}], "}"}]}]}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "+", 
         RowBox[{"{", 
          RowBox[{"dx", ",", "dy"}], "}"}], "+", 
         RowBox[{"DPCOfPA", "@", 
          RowBox[{"{", 
           RowBox[{"Capx", ",", "Capy"}], "}"}]}]}]}], "}"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data plot engine", "Subsection"],

Cell["\<\
PartitionDataForLine partitions a data set into sublists, each containing at \
least two points, broken at points containing value None\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NoneFreeQ", "[", "x_", "]"}], ":=", 
    RowBox[{"!", 
     RowBox[{"DataPointNoneQ", "[", "x", "]"}]}]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"TO", " ", "REVISIT"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"NoneFreePairQ", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"NoneFreeQ", "[", "x", "]"}], "&&", 
      RowBox[{"NoneFreeQ", "[", "y", "]"}]}]}], ";"}], "*)"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.48253010078125*^9, 3.482530103359375*^9}, {
  3.48253028865625*^9, 3.48253030034375*^9}, {3.48253035971875*^9, 
  3.48253036484375*^9}, {3.482531151625*^9, 3.482531155265625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NoneFreePairQ", "[", 
    RowBox[{
     RowBox[{"Except", "[", "None", "]"}], ",", 
     RowBox[{"Except", "[", "None", "]"}]}], "]"}], ":=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoneFreePairQ", "[", 
    RowBox[{"_", ",", "_"}], "]"}], ":=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PartitionDataForLine", "[", "Data_List", "]"}], ":=", 
   RowBox[{"Cases", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Split", "[", 
      RowBox[{"Data", ",", "NoneFreePairQ"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"x", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Except", "[", "None", "]"}], ".."}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.48253010078125*^9, 3.482530103359375*^9}, {
  3.48253028865625*^9, 3.48253030034375*^9}, {3.48253035971875*^9, 
  3.48253042315625*^9}, {3.482530614078125*^9, 3.482530616359375*^9}, {
  3.4825306925*^9, 3.482530786828125*^9}, {3.482530936234375*^9, 
  3.48253098403125*^9}, {3.482531031796875*^9, 3.482531077296875*^9}, {
  3.4846856295*^9, 3.484685682515625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ApplyOrNone", "[", "f_", "]"}], "[", 
    RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
   RowBox[{"f", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ApplyOrNone", "[", "f_", "]"}], "[", "None", "]"}], ":=", 
   "None"}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Timing tests on DataPlot

For 100 lines of 100 points:
\tmapping SchemeLine onto each ~1.6 sec
\tapplying MakeOutline to list of lines ~1.3 sec
\t\twith no user to canvas conversion ~1.1 sec
\t\twith no clipping ~0.65 sec
\tapplying MakeOutline to list of lines, symbol machinery in place but not \
shown ~1.45 sec
\t... and calculations done but no art constructed ~1.85 sec
\t... and art constructed but Make commands commented out ~1.95
\t... and art constructed and display only suppressed at option level in Make \
commands (with Show test after clipping) ~15.1 sec
\t... and art constructed and display only suppressed at option level in Make \
commands (after moving clipping inside Show test) ~1.95 sec
\t... and symbols with line and fill shown ~15.3 sec
\t... and symbols with line and fill shown but no clipping on symbols ~2.46 sec
\t\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LogOrNone", "[", 
    RowBox[{
     RowBox[{"b_:", "E"}], ",", 
     RowBox[{"x_", "?", "Positive"}]}], "]"}], ":=", 
   RowBox[{"Log", "[", 
    RowBox[{"b", ",", "x"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LogOrNone", "[", 
    RowBox[{
     RowBox[{"b_:", "E"}], ",", "x_"}], "]"}], ":=", "None"}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DataLog", "[", 
    RowBox[{
     RowBox[{"b_:", "E"}], ",", 
     RowBox[{"ErrorValue", "[", 
      RowBox[{
       RowBox[{"x_", "?", "Positive"}], ",", 
       RowBox[{"{", 
        RowBox[{"dxm_", ",", "dxp_"}], "}"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{"Block", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "xp", ",", "xm", ",", "\[IndentingNewLine]", "logx", ",", "logxm", ",", 
       "logxp", ",", "\[IndentingNewLine]", "dlogxm", ",", "dlogxp"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"calculate", " ", "true", " ", "coordinates"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"xm", "=", 
       RowBox[{
        RowBox[{"ApplyOrNone", "[", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "+", "#"}], "&"}], ")"}], "]"}], "[", "dxm", "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xp", "=", 
       RowBox[{
        RowBox[{"ApplyOrNone", "[", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "+", "#"}], "&"}], ")"}], "]"}], "[", "dxp", "]"}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"calculate", " ", "logs"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"logx", "=", 
       RowBox[{"Log", "[", 
        RowBox[{"b", ",", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"logxm", "=", 
       RowBox[{"LogOrNone", "[", 
        RowBox[{"b", ",", "xm"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"logxp", "=", 
       RowBox[{"LogOrNone", "[", 
        RowBox[{"b", ",", "xp"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"convert", " ", "back", " ", "to", " ", "difference"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"dlogxm", "=", 
       RowBox[{
        RowBox[{"ApplyOrNone", "[", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "-", "logx"}], "&"}], ")"}], "]"}], "[", "logxm", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dlogxp", "=", 
       RowBox[{
        RowBox[{"ApplyOrNone", "[", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "-", "logx"}], "&"}], ")"}], "]"}], "[", "logxp", 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"construct", " ", "ErrorValue"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ErrorValue", "[", 
       RowBox[{"logx", ",", 
        RowBox[{"{", 
         RowBox[{"dlogxm", ",", "dlogxp"}], "}"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataLog", "[", 
    RowBox[{
     RowBox[{"b_:", "E"}], ",", 
     RowBox[{"ErrorValue", "[", 
      RowBox[{"x_", ",", 
       RowBox[{"{", 
        RowBox[{"dxm_", ",", "dxp_"}], "}"}]}], "]"}]}], "]"}], ":=", 
   "None"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.398800951375*^9, 3.39880109725*^9}, {
  3.482528288984375*^9, 3.4825283385625*^9}, {3.482528414734375*^9, 
  3.482528485828125*^9}, {3.482528518203125*^9, 3.48252860859375*^9}, {
  3.48252871209375*^9, 3.4825287301875*^9}, {3.482528764625*^9, 
  3.48252878253125*^9}, {3.482528822953125*^9, 3.482528874359375*^9}, {
  3.482528914078125*^9, 3.482529049734375*^9}, {3.482529085015625*^9, 
  3.482529239484375*^9}, {3.482534038984375*^9, 3.482534046625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ProcessDataSet", "[", 
    RowBox[{"Data_List", ",", "Tag_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "DataSetOpts", ",", "DataValuesOpts", ",", "DataLineOpts", ",", 
       "DataSymbolOpts", ",", "\[IndentingNewLine]", "OptDataColumns", ",", 
       "AdHocFixForDataGroup", ",", "\[IndentingNewLine]", "PairData", ",", 
       "FilteredData", ",", "ExpandedData", ",", "ScaledData", ",", 
       "FinalData", ",", "\[IndentingNewLine]", "Points", ",", "ValuePoints", 
       ",", "ValuePointCenters", ",", "Segments", ",", "LinePoints", ",", 
       "\[IndentingNewLine]", "BasicShape", ",", "i", ",", "Point", ",", 
       "PointVertices", ",", "CentralPoints", ",", "ExpandedErrorPoints", ",",
        "\[IndentingNewLine]", "DropFillArt", ",", "LineArt", ",", 
       "SymbolOutlineArt", ",", "SymbolFillArt", ",", "ErrorBarArt"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", "$ProcessDataSets"}], ",", 
        RowBox[{"Return", "[", 
         RowBox[{"{", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Generate", " ", "plot", " ", "options"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"DataSetOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", "DataSet", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataValuesOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", "DataValues", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataLineOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", "DataLine", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DataSymbolOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", "DataSymbol", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Validate", " ", "plot", " ", "options"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"AxisScaling", ",", 
        RowBox[{"None", "|", "Log", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"None", "|", "Log"}], ",", 
           RowBox[{"None", "|", "Log"}]}], "}"}]}], ",", "DataValuesOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"DataColumns", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", "_Integer", ")"}], "?", "Positive"}], ",", 
           RowBox[{
            RowBox[{"(", "_Integer", ")"}], "?", "Positive"}]}], "}"}]}], ",",
         "DataSetOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"DataFilters", ",", 
        RowBox[{"None", "|", 
         RowBox[{"(", "_List", ")"}]}], ",", "DataValuesOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "DataLineOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Show", ",", 
        RowBox[{"True", "|", "False"}], ",", "DataSymbolOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SymbolShape", ",", "_String", ",", "DataSymbolOpts"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SymbolSize", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}], "?", "Positive"}], ",", 
        "DataSymbolOpts"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PlotPoints", ",", 
        RowBox[{"_Integer", "?", "Positive"}], ",", "DataSymbolOpts"}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Construct", " ", "data", " ", "point", " ", "lists"}], " ", 
       "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"select", " ", "out", " ", "relevant", " ", "columns"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"OptDataColumns", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"DataColumns", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", "DataSetOpts"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Max", "[", "OptDataColumns", "]"}], ">", 
         RowBox[{
          RowBox[{"Dimensions", "[", "Data", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"DataSet", "::", "badcolumn"}], ",", "OptDataColumns"}], 
         "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"PairData", "=", 
       RowBox[{"Data", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "OptDataColumns"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"validate", " ", "as", " ", "two"}], "-", 
        RowBox[{"column", " ", "data", " ", "set"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"DataSetQ", "[", "PairData", "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ErrorMessage", "[", 
         RowBox[{
          RowBox[{"DataPlot", "::", "baddata"}], ",", "PairData"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "filter", " ", "data", " ", "based", " ", "on", " ", "central", " ", 
        "values"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FilteredData", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"DataFilters", "/.", "DataValuesOpts"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"None", "|", 
          RowBox[{"{", "}"}]}], ",", "PairData", ",", "\[IndentingNewLine]", 
         "_List", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Composition", "@@", 
            RowBox[{"Reverse", "[", 
             RowBox[{"DataFilters", "/.", "DataValuesOpts"}], "]"}]}], ")"}], 
          "[", "PairData", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "collapse", " ", "any", " ", "points", " ", "with", " ", "None", " ", 
        "for", " ", "x", " ", "or", " ", "y", " ", "coordinate", " ", "into", 
        " ", "a", " ", "simple", " ", "None"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"FilteredData", "=", 
       RowBox[{"Replace", "[", 
        RowBox[{"FilteredData", ",", 
         RowBox[{
          RowBox[{"_", "?", "DataPointNoneQ"}], "\[Rule]", "None"}], ",", 
         RowBox[{"{", "1", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "expand", " ", "data", " ", "points", " ", "to", " ", "include", " ", 
        "error", " ", "bars"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"--", " ", "x"}], " ", "error", " ", "bar"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ExpandedData", "=", 
       RowBox[{"Replace", "[", "\[IndentingNewLine]", 
        RowBox[{"FilteredData", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x_", "?", "NumericQ"}], ",", "y_"}], "}"}], 
            "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ErrorValue", "[", 
               RowBox[{"x", ",", 
                RowBox[{"{", 
                 RowBox[{"None", ",", "None"}], "}"}]}], "]"}], ",", "y"}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ErrorValue", "[", 
               RowBox[{"x_", ",", "None"}], "]"}], ",", "y_"}], "}"}], 
            "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ErrorValue", "[", 
               RowBox[{"x", ",", 
                RowBox[{"{", 
                 RowBox[{"None", ",", "None"}], "}"}]}], "]"}], ",", "y"}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ErrorValue", "[", 
               RowBox[{"x_", ",", 
                RowBox[{"dx_", "?", "NumericQ"}]}], "]"}], ",", "y_"}], "}"}],
             "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ErrorValue", "[", 
               RowBox[{"x", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "dx"}], ",", "dx"}], "}"}]}], "]"}], ",", 
              "y"}], "}"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "1", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"--", " ", "y"}], " ", "error", " ", "bar"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ExpandedData", "=", 
       RowBox[{"Replace", "[", "\[IndentingNewLine]", 
        RowBox[{"ExpandedData", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x_", ",", 
              RowBox[{"y_", "?", "NumericQ"}]}], "}"}], "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"ErrorValue", "[", 
               RowBox[{"y", ",", 
                RowBox[{"{", 
                 RowBox[{"None", ",", "None"}], "}"}]}], "]"}]}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x_", ",", 
              RowBox[{"ErrorValue", "[", 
               RowBox[{"y_", ",", "None"}], "]"}]}], "}"}], "\[RuleDelayed]", 
            
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"ErrorValue", "[", 
               RowBox[{"y", ",", 
                RowBox[{"{", 
                 RowBox[{"None", ",", "None"}], "}"}]}], "]"}]}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x_", ",", 
              RowBox[{"ErrorValue", "[", 
               RowBox[{"y_", ",", 
                RowBox[{"dy_", "?", "NumericQ"}]}], "]"}]}], "}"}], 
            "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"ErrorValue", "[", 
               RowBox[{"y", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "dy"}], ",", "dy"}], "}"}]}], "]"}]}], 
             "}"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "1", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"scale", " ", "data", " ", "and", " ", "error", " ", "bars"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ScaledData", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AxisScaling", "/.", "DataValuesOpts"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"None", "|", 
          RowBox[{"{", 
           RowBox[{"None", ",", "None"}], "}"}]}], ",", "ExpandedData", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Log", "|", 
          RowBox[{"{", 
           RowBox[{"None", ",", "Log"}], "}"}]}], ",", 
         RowBox[{
          RowBox[{"TransformData", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"DataLog", "[", 
               RowBox[{"10", ",", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], "&"}], 
           "]"}], "@", "ExpandedData"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Log", ",", "None"}], "}"}], ",", 
         RowBox[{
          RowBox[{"TransformData", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"DataLog", "[", 
               RowBox[{"10", ",", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "]"}], "@", 
          "ExpandedData"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Log", ",", "Log"}], "}"}], ",", 
         RowBox[{
          RowBox[{"TransformData", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"DataLog", "[", 
               RowBox[{"10", ",", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"DataLog", "[", 
               RowBox[{"10", ",", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], "&"}], 
           "]"}], "@", "ExpandedData"}]}], "\[IndentingNewLine]", "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "collapse", " ", "any", " ", "points", " ", "with", " ", "None", " ", 
        "for", " ", "x", " ", "or", " ", "y", " ", "coordinate", " ", "into", 
        " ", "a", " ", "simple", " ", "None"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"FinalData", "=", 
       RowBox[{"Replace", "[", 
        RowBox[{"ScaledData", ",", 
         RowBox[{
          RowBox[{"_", "?", "DataPointNoneQ"}], "\[Rule]", "None"}], ",", 
         RowBox[{"{", "1", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", "FinalData", "]"}], ";"}], "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "translate", " ", "points", " ", "into", " ", "canvas", " ", 
        "coordinates"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Points", "=", 
       RowBox[{"Replace", "[", "\[IndentingNewLine]", 
        RowBox[{"FinalData", ",", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ErrorValue", "[", 
              RowBox[{"x_", ",", 
               RowBox[{"{", 
                RowBox[{"dxm_", ",", "dxp_"}], "}"}]}], "]"}], ",", 
             RowBox[{"ErrorValue", "[", 
              RowBox[{"y_", ",", 
               RowBox[{"{", 
                RowBox[{"dym_", ",", "dyp_"}], "}"}]}], "]"}]}], "}"}], 
           "\[RuleDelayed]", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ErrorValue", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ApplyOrNone", "[", "XCOfXU", "]"}], "@", "x"}], ",", 
               
               RowBox[{
                RowBox[{"ApplyOrNone", "[", "DXCOfXU", "]"}], "/@", 
                RowBox[{"{", 
                 RowBox[{"dxm", ",", "dxp"}], "}"}]}]}], "]"}], ",", 
             RowBox[{"ErrorValue", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ApplyOrNone", "[", "YCOfYU", "]"}], "@", "y"}], ",", 
               
               RowBox[{
                RowBox[{"ApplyOrNone", "[", "DYCOfYU", "]"}], "/@", 
                RowBox[{"{", 
                 RowBox[{"dym", ",", "dyp"}], "}"}]}]}], "]"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", "1", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "select", " ", "points", " ", "with", " ", "central", " ", "values"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ValuePoints", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{"Points", ",", 
         RowBox[{"Except", "[", "None", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ValuePointCenters", "=", 
       RowBox[{"(", 
        RowBox[{"ValuePoints", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ErrorValue", "[", 
            RowBox[{"x_", ",", "_"}], "]"}], "\[RuleDelayed]", "x"}], "}"}]}],
         ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "partition", " ", "line", " ", "at", " ", "points", " ", "without", 
        " ", "values"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Segments", "=", 
       RowBox[{"PartitionDataForLine", "[", 
        RowBox[{"(", 
         RowBox[{"Points", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ErrorValue", "[", 
             RowBox[{"x_", ",", "_"}], "]"}], "\[RuleDelayed]", "x"}], 
           "}"}]}], ")"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"IgnoreMissingValues", "/.", "DataLineOpts"}], ")"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Segments", "=", 
         RowBox[{"{", 
          RowBox[{"Join", "@@", "Segments"}], "}"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Construct", " ", "lines", " ", "with", " ", "drop"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LinePoints", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Show", "/.", "DataLineOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"DataLineShape", "[", 
           RowBox[{
            RowBox[{"LineShape", "/.", "DataLineOpts"}], ",", 
            RowBox[{"PlotPoints", "/.", "DataLineOpts"}]}], "]"}], "/@", 
          "Segments"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Transpose", "/.", "DataLineOpts"}], ")"}], ",", 
        RowBox[{"LinePoints", "=", 
         RowBox[{"Map", "[", 
          RowBox[{"Reverse", ",", "LinePoints", ",", 
           RowBox[{"{", "2", "}"}]}], "]"}]}]}], "]"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"quick", " ", "fix", " ", "for", " ", 
        RowBox[{"L", ".", " ", "Shao"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", "LinePoints", "]"}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"DropFillArt", "=", 
       RowBox[{"Polygon", "/@", "LinePoints"}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"TO", " ", 
        RowBox[{"DO", ":", " ", 
         RowBox[{
         "more", " ", "sophisticated", " ", "handling", " ", "of", " ", 
          "endpoints"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LineArt", "=", 
       RowBox[{"Line", "/@", "LinePoints"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Construct", " ", "symbols"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Show", "/.", "DataSymbolOpts"}], ")"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PointVertices", "=", 
         RowBox[{
          RowBox[{"DataSymbolVertices", "[", 
           RowBox[{
            RowBox[{"SymbolShape", "/.", "DataSymbolOpts"}], ",", 
            RowBox[{"SymbolSize", "/.", "DataSymbolOpts"}], ",", 
            RowBox[{"PlotPoints", "/.", "DataSymbolOpts"}]}], "]"}], "/@", 
          "ValuePointCenters"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"SymbolOutlineArt", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Show", "/.", "DataSymbolOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"Append", "[", 
              RowBox[{"#", ",", 
               RowBox[{"First", "[", "#", "]"}]}], "]"}], "]"}], "&"}], ")"}],
           "/@", "PointVertices"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SymbolFillArt", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Show", "/.", "DataSymbolOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Polygon", "/@", "PointVertices"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Construct", " ", "error", " ", "bars"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"ErrorBarArt", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Show", "/.", "DataSymbolOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Join", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Cases", "[", "\[IndentingNewLine]", 
            RowBox[{"ValuePoints", ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"ErrorValue", "[", 
                 RowBox[{"x_", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dxm_", "?", "NumericQ"}], ",", "dxp_"}], "}"}]}],
                  "]"}], ",", 
                RowBox[{"ErrorValue", "[", 
                 RowBox[{"y_", ",", 
                  RowBox[{"{", 
                   RowBox[{"dym_", ",", "dyp_"}], "}"}]}], "]"}]}], "}"}], ":>", 
              RowBox[{"ErrorBarPrimatives", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"dxm", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"SymbolSize", "/.", "DataSymbolOpts"}], ")"}], 
                   "/", "2"}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Cases", "[", "\[IndentingNewLine]", 
            RowBox[{"ValuePoints", ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"ErrorValue", "[", 
                 RowBox[{"x_", ",", 
                  RowBox[{"{", 
                   RowBox[{"dxm_", ",", 
                    RowBox[{"dxp_", "?", "NumericQ"}]}], "}"}]}], "]"}], ",", 
                
                RowBox[{"ErrorValue", "[", 
                 RowBox[{"y_", ",", 
                  RowBox[{"{", 
                   RowBox[{"dym_", ",", "dyp_"}], "}"}]}], "]"}]}], "}"}], ":>", 
              RowBox[{"ErrorBarPrimatives", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"dxp", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"SymbolSize", "/.", "DataSymbolOpts"}], ")"}], 
                   "/", "2"}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Cases", "[", "\[IndentingNewLine]", 
            RowBox[{"ValuePoints", ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"ErrorValue", "[", 
                 RowBox[{"x_", ",", 
                  RowBox[{"{", 
                   RowBox[{"dxm_", ",", "dxp_"}], "}"}]}], "]"}], ",", 
                RowBox[{"ErrorValue", "[", 
                 RowBox[{"y_", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dym_", "?", "NumericQ"}], ",", "dyp_"}], "}"}]}],
                  "]"}]}], "}"}], ":>", 
              RowBox[{"ErrorBarPrimatives", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "dym"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"SymbolSize", "/.", "DataSymbolOpts"}], ")"}], 
                   "/", "2"}], ",", "0"}], "}"}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Cases", "[", "\[IndentingNewLine]", 
            RowBox[{"ValuePoints", ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"ErrorValue", "[", 
                 RowBox[{"x_", ",", 
                  RowBox[{"{", 
                   RowBox[{"dxm_", ",", "dxp_"}], "}"}]}], "]"}], ",", 
                RowBox[{"ErrorValue", "[", 
                 RowBox[{"y_", ",", 
                  RowBox[{"{", 
                   RowBox[{"dym_", ",", 
                    RowBox[{"dyp_", "?", "NumericQ"}]}], "}"}]}], "]"}]}], 
               "}"}], ":>", 
              RowBox[{"ErrorBarPrimatives", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "dyp"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"SymbolSize", "/.", "DataSymbolOpts"}], ")"}], 
                   "/", "2"}], ",", "0"}], "}"}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Save", " ", "dataset", " ", "info"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"TO", " ", 
         RowBox[{"DO", ":", " ", 
          RowBox[{"make", " ", "use", " ", "of", " ", "DefineDataStyle"}]}]}],
         ",", " ", 
        RowBox[{
        "or", " ", "convert", " ", "to", " ", "full", " ", "object", " ", 
         "management"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Tag", "=!=", "None"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"LevelScheme`Data`DataTagDefined", "[", "Tag", "]"}], "=", 
          "True"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`DataValuesOpts", "[", "Tag", "]"}], "=", 
          "DataValuesOpts"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`DataLineOpts", "[", "Tag", "]"}], "=", 
          "DataLineOpts"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`DataSymbolOpts", "[", "Tag", "]"}], "=", 
          "DataSymbolOpts"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`DataCanvasPoints", "[", "Tag", "]"}], "=",
           "ValuePointCenters"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Draw", " ", "artwork"}], " ", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Line", " ", "with", " ", "drop", " ", 
         RowBox[{"fill", " ", "--"}], " ", "behind", " ", "data", " ", 
         "points"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MakeFill", "[", 
         RowBox[{
          RowBox[{"{", "DropFillArt", "}"}], ",", "DataLineOpts"}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"MakeOutline", "[", 
         RowBox[{"LineArt", ",", "DataLineOpts"}], "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Error", " ", 
          RowBox[{"bars", " ", "--"}], " ", "behind", " ", "symbol", " ", 
          "fill"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"MakeOutline", "[", 
         RowBox[{
          RowBox[{"{", "ErrorBarArt", "}"}], ",", "DataSymbolOpts"}], "]"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "Symbols", " ", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"MakeFill", "[", 
         RowBox[{
          RowBox[{"{", "SymbolFillArt", "}"}], ",", "DataSymbolOpts"}], "]"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"MakeOutline", "[", 
         RowBox[{
          RowBox[{"{", "SymbolOutlineArt", "}"}], ",", "DataSymbolOpts"}], 
         "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.3987971916875*^9, 3.398797191875*^9}, {3.3987975745*^9, 
   3.39879762646875*^9}, {3.398797657109375*^9, 3.398797745140625*^9}, {
   3.398797814671875*^9, 3.39879797434375*^9}, {3.398800339*^9, 
   3.398800346*^9}, {3.39880040634375*^9, 3.398800415390625*^9}, {
   3.398800664*^9, 3.398800677515625*^9}, {3.39880111946875*^9, 
   3.398801121953125*^9}, 3.39880117534375*^9, {3.46445147359375*^9, 
   3.464451483015625*^9}, {3.465140790703125*^9, 3.465140796875*^9}, {
   3.46514178*^9, 3.46514179771875*^9}, {3.46721348590625*^9, 
   3.46721350453125*^9}, {3.467213546125*^9, 3.467213555125*^9}, {
   3.482526402953125*^9, 3.48252644721875*^9}, 3.482526529515625*^9, {
   3.48252699615625*^9, 3.482527001703125*^9}, {3.482527033*^9, 
   3.482527045640625*^9}, {3.482527428890625*^9, 3.482527429625*^9}, {
   3.48252752925*^9, 3.482527560359375*^9}, {3.482527609578125*^9, 
   3.48252764978125*^9}, 3.482527886890625*^9, {3.482527940265625*^9, 
   3.482527989453125*^9}, {3.482528030328125*^9, 3.48252823546875*^9}, {
   3.482529430109375*^9, 3.48252945028125*^9}, {3.482529481203125*^9, 
   3.48252950240625*^9}, {3.4825295380625*^9, 3.4825295388125*^9}, {
   3.48252960675*^9, 3.4825296105*^9}, 3.48252964884375*^9, {
   3.48252970028125*^9, 3.482529706734375*^9}, {3.48252973771875*^9, 
   3.482529745375*^9}, {3.482529788390625*^9, 3.482529794375*^9}, {
   3.48252996028125*^9, 3.482530073890625*^9}, {3.48253048478125*^9, 
   3.4825305420625*^9}, 3.482530654625*^9, 3.482530796640625*^9, {
   3.48253121453125*^9, 3.482531257453125*^9}, {3.482531348796875*^9, 
   3.482531359546875*^9}, {3.4825314090625*^9, 3.48253141225*^9}, {
   3.482531491015625*^9, 3.482531509171875*^9}, {3.482531547109375*^9, 
   3.482531697671875*^9}, {3.482531794734375*^9, 3.4825317954375*^9}, {
   3.482531833390625*^9, 3.48253183815625*^9}, {3.482531883421875*^9, 
   3.4825318963125*^9}, {3.482532051296875*^9, 3.482532118703125*^9}, 
   3.482532156140625*^9, {3.482532659046875*^9, 3.4825326634375*^9}, {
   3.48253280615625*^9, 3.482532819234375*^9}, {3.4825332051875*^9, 
   3.482533214015625*^9}, 3.4825332864375*^9, {3.482533464515625*^9, 
   3.482533499859375*^9}, {3.48253357246875*^9, 3.482533573515625*^9}, {
   3.482533686453125*^9, 3.48253369909375*^9}, {3.482534076859375*^9, 
   3.482534116125*^9}, {3.482534163015625*^9, 3.482534178984375*^9}, {
   3.482534365734375*^9, 3.4825344384375*^9}, {3.4825344700625*^9, 
   3.48253447478125*^9}, {3.482535847796875*^9, 3.482535849046875*^9}, {
   3.484685564984375*^9, 3.484685566140625*^9}, {3.484686299046875*^9, 
   3.48468643609375*^9}, {3.484686474578125*^9, 3.4846865816875*^9}, {
   3.488367451140625*^9, 3.48836750325*^9}, {3.48836760546875*^9, 
   3.488367669515625*^9}, {3.488367805046875*^9, 3.488367844265625*^9}, {
   3.4883680046875*^9, 3.4883680873125*^9}, {3.488368125875*^9, 
   3.4883681260625*^9}, {3.4883690045*^9, 3.48836902715625*^9}, {
   3.48836924315625*^9, 3.488369243546875*^9}, {3.48836927940625*^9, 
   3.48836927975*^9}, {3.4883694576875*^9, 3.488369488734375*^9}, {
   3.488370080671875*^9, 3.488370097453125*^9}, {3.488370196671875*^9, 
   3.488370223828125*^9}, {3.488370465796875*^9, 3.48837046896875*^9}, {
   3.49605569878125*^9, 3.49605569884375*^9}, {3.50290189815625*^9, 
   3.50290194221875*^9}, {3.51196898346875*^9, 3.511969021421875*^9}, {
   3.51196935971875*^9, 3.51196936821875*^9}, {3.511969417984375*^9, 
   3.511969484171875*^9}, {3.51196955634375*^9, 3.511969557390625*^9}, {
   3.51682163140625*^9, 3.516821631984375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data plot control", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlot", "[", 
    RowBox[{
     RowBox[{"DataSet", "[", 
      RowBox[{"Data_List", ",", 
       RowBox[{"DataSetOptsSeq___", "?", "OptionQ"}]}], "]"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"DataPlot", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "Item", ",", "\[IndentingNewLine]", 
       RowBox[{"LineOpts", "=", 
        RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"SymbolOpts", "=", 
        RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LineEnabled", "=", "False"}], ",", "\[IndentingNewLine]", 
       RowBox[{"SymbolEnabled", "=", "False"}], ",", "\[IndentingNewLine]", 
       "SafeData"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"ShowData", ",", 
        RowBox[{"True", "|", "False"}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"CheckDataSet", "[", 
         RowBox[{"(", 
          RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckValue", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Tag", "/.", "FullOpts"}], ")"}], ",", 
        RowBox[{"_", "?", "LevelIdentifierQ"}], ",", 
        "\"\<a data set identifier symbol (cannot be list or number)\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Debug", "/.", "FullOpts"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"(", 
          RowBox[{"Tag", "/.", "FullOpts"}], ")"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Debug", "/.", "FullOpts"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"InputForm", "[", "Data", "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"BlockSchemeOptions", "[", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "lock", " ", "in", " ", "plotting", " ", "style", " ", "options"}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"UseDataOptions", "[", 
         RowBox[{"FilterRules", "[", 
          RowBox[{"FullOpts", ",", 
           RowBox[{"{", 
            RowBox[{"DataLine", ",", "DataSymbol", ",", "DataStyle"}], 
            "}"}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "lock", " ", "in", " ", "data", " ", "value", " ", "options"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"DataValues", ",", 
          RowBox[{"(", 
           RowBox[{"DataValues", "/.", "FullOpts"}], ")"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"lock", " ", "in", " ", "data", " ", "structure"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"DataSet", ",", 
          RowBox[{"FilterRules", "[", 
           RowBox[{
            RowBox[{"{", "DataSetOptsSeq", "}"}], ",", 
            RowBox[{"{", "DataColumns", "}"}]}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"make", " ", "the", " ", "plot"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"ProcessDataSet", "[", 
         RowBox[{"Data", ",", 
          RowBox[{"(", 
           RowBox[{"Tag", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.464971939984375*^9, 3.46497201728125*^9}, {
   3.464972049234375*^9, 3.464972159859375*^9}, {3.46514071353125*^9, 
   3.465140768390625*^9}, {3.46514158496875*^9, 3.46514158728125*^9}, 
   3.4651418565*^9, 3.467211069578125*^9, 3.46721185915625*^9, {
   3.467211915890625*^9, 3.467211969796875*^9}, 3.467212010640625*^9, {
   3.482532525265625*^9, 3.482532580265625*^9}, 3.482532616890625*^9, {
   3.48253268025*^9, 3.482532690546875*^9}, {3.4825328588125*^9, 
   3.482532911578125*^9}, {3.482532980890625*^9, 3.482533006375*^9}, {
   3.482533051265625*^9, 3.482533051921875*^9}, {3.482533478546875*^9, 
   3.48253348678125*^9}, {3.48836848175*^9, 3.4883685466875*^9}, {
   3.488368870296875*^9, 3.488368922921875*^9}, {3.48836896715625*^9, 
   3.488368983796875*^9}, {3.48836904365625*^9, 3.488369076546875*^9}, {
   3.48836917678125*^9, 3.488369199859375*^9}, {3.488370068984375*^9, 
   3.488370069515625*^9}, 3.496055698859375*^9, {3.502552223140625*^9, 
   3.50255222815625*^9}, {3.502552451375*^9, 3.502552456234375*^9}, 
   3.502552549984375*^9}],

Cell["Accept raw list as data by wrapping as DataSet", "Text",
 CellChangeTimes->{{3.488369081375*^9, 3.48836909559375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlot", "[", 
    RowBox[{"Data_List", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"DataPlot", "[", 
    RowBox[{
     RowBox[{"DataSet", "[", "Data", "]"}], ",", "Opts"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.464971939984375*^9, 3.46497201728125*^9}, {
   3.464972049234375*^9, 3.464972159859375*^9}, {3.46514071353125*^9, 
   3.465140768390625*^9}, {3.46514158496875*^9, 3.46514158728125*^9}, 
   3.4651418565*^9, 3.467211069578125*^9, 3.46721185915625*^9, {
   3.467211915890625*^9, 3.467211969796875*^9}, 3.467212010640625*^9, {
   3.482532525265625*^9, 3.482532580265625*^9}, 3.482532616890625*^9, {
   3.48253268025*^9, 3.482532690546875*^9}, {3.4825328588125*^9, 
   3.482532911578125*^9}, {3.482532980890625*^9, 3.482533006375*^9}, {
   3.482533051265625*^9, 3.482533051921875*^9}, {3.482533478546875*^9, 
   3.48253348678125*^9}, {3.48836848175*^9, 3.4883685466875*^9}, {
   3.488368870296875*^9, 3.488368922921875*^9}, {3.48836896715625*^9, 
   3.488368983796875*^9}, {3.48836904365625*^9, 3.488369076546875*^9}}],

Cell["\<\
Accept data sequence by looping -- to be refined later to allow plot \
appearance to vary within sequence, fills, etc.\
\>", "Text",
 CellChangeTimes->{{3.492012642625*^9, 3.492012674296875*^9}, {
  3.4920134295625*^9, 3.4920134328125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlot", "[", 
    RowBox[{
     RowBox[{"DataSequence", "[", "L_List", "]"}], ",", "Opts___"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "Data", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DataPlot", "[", 
        RowBox[{"Data", ",", "Opts"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"Data", ",", "L"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49201240934375*^9, 3.49201246871875*^9}, 
   3.4920130348125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data labeling", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataLabel", "[", 
    RowBox[{"ID_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"DataLabel", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckDataSet", "[", "ID", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BasicLineAnnotations", "[", 
       RowBox[{
        RowBox[{"LevelScheme`Data`DataCanvasPoints", "[", "ID", "]"}], ",", 
        "FullOpts"}], "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.496055698859375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data set tags and styles", "Subsection"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"LastDataSet", "[", "]"}], ":=", "$DataTag"}], ";"}], 
  "*)"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.424456771703125*^9, 3.424456781203125*^9}, {
  3.424456830125*^9, 3.42445683075*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataTag", "[", 
    RowBox[{"ID_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"DataTag", ",", "Opts"}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckValue", "[", 
       RowBox[{"ID", ",", 
        RowBox[{"IDExpr_", "?", "LevelIdentifierQ"}], ",", 
        "\"\<a data set identifier symbol (cannot be list or number)\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"$DataTag", "=", "ID"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "store", " ", "tentative", " ", "style", " ", "information", " ", "in",
         " ", "case", " ", "no", " ", "plot", " ", "later", " ", "made"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`DataValuesOpts", "[", "$DataTag", "]"}], "=", 
       RowBox[{"FigRealizeOptions", "[", "DataValues", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`DataLineOpts", "[", "$DataTag", "]"}], "=", 
       RowBox[{"FigRealizeOptions", "[", "DataLine", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`DataSymbolOpts", "[", "$DataTag", "]"}], "=", 
       RowBox[{"FigRealizeOptions", "[", "DataSymbol", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`DataCanvasPoints", "[", "$DataTag", "]"}], 
       "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"LevelScheme`Data`DataTagDefined", "[", "$DataTag", "]"}], "=",
        "True"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.398797191890625*^9, 3.398797191890625*^9}, {
  3.425753661859375*^9, 3.42575367040625*^9}, {3.425753737625*^9, 
  3.425753737890625*^9}, {3.425753773046875*^9, 3.425753778859375*^9}, {
  3.425754442640625*^9, 3.425754447890625*^9}, {3.425754690046875*^9, 
  3.425754694609375*^9}, {3.496055698859375*^9, 3.496055698875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DefineDataStyle", "[", 
     RowBox[{"ID_", ",", 
      RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"DefineDataStyle", ",", "Opts"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckValue", "[", 
        RowBox[{"ID", ",", 
         RowBox[{"IDExpr_", "?", "LevelIdentifierQ"}], ",", 
         "\"\<a data set identifier symbol (cannot be list or number)\>\""}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "validation", " ", "to", " ", "be", " ", "done", " ", "by", " ", 
         "UseDataOptions"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"CheckOption", "[", 
          RowBox[{"DataLine", ",", "_List", ",", "FullOpts"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"CheckOption", "[", 
          RowBox[{"DataSymbol", ",", "_List", ",", "FullOpts"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"CheckDataSet", "[", 
            RowBox[{"(", 
             RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "]"}]}], 
          "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
       "BlockSchemeOptions", "[", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "realize", " ", "options", " ", "for", " ", "current", " ", "data", 
          " ", "style"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"UseDataOptions", "[", 
          RowBox[{"FilterRules", "[", 
           RowBox[{"FullOpts", ",", 
            RowBox[{"{", 
             RowBox[{"DataLine", ",", "DataSymbol", ",", "DataStyle"}], 
             "}"}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"save", " ", "these", " ", "options"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"TO", " ", 
           RowBox[{"UPDATE", ":", " ", 
            RowBox[{"to", " ", "full", " ", "object", " ", "management"}]}]}],
           " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`DataLineOpts", "[", "ID", "]"}], "=", 
          RowBox[{"Options", "[", "DataLine", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`DataSymbolOpts", "[", "ID", "]"}], "=", 
          RowBox[{"Options", "[", "DataSymbol", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`DataCanvasPoints", "[", "ID", "]"}], "=", 
          
          RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"LevelScheme`Data`DataTagDefined", "[", "ID", "]"}], "=", 
          "True"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UseDataOptions", "[", 
    RowBox[{"Opts___", "?", "OptionQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"FigRealizeOptions", "[", 
        RowBox[{"UseDataOptions", ",", "Opts"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"DataLine", ",", "_List", ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"DataSymbol", ",", "_List", ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"CheckDataSet", "[", 
         RowBox[{"(", 
          RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BlockUnprotect", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"DataLine", ",", "DataSymbol"}], "}"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"retrieve", " ", "style"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "=!=", "None"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"Options", "[", "DataLine", "]"}], "=", 
             RowBox[{"LevelScheme`Data`DataLineOpts", "[", 
              RowBox[{"(", 
               RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Options", "[", "DataSymbol", "]"}], "=", 
             RowBox[{"LevelScheme`Data`DataSymbolOpts", "[", 
              RowBox[{"(", 
               RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}], "]"}]}]}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"implement", " ", "any", " ", "overrides"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Note", ":", " ", 
           RowBox[{
           "FigRealizeOptions", " ", "freezes", " ", "in", " ", "any", " ", 
            "inherited", " ", "values", " ", "at", " ", "present", " ", 
            "defaults"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Options", "[", "DataLine", "]"}], "=", 
          RowBox[{"FigRealizeOptions", "[", 
           RowBox[{"DataLine", ",", 
            RowBox[{"(", 
             RowBox[{"DataLine", "/.", "FullOpts"}], ")"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Options", "[", "DataSymbol", "]"}], "=", 
          RowBox[{"FigRealizeOptions", "[", 
           RowBox[{"DataSymbol", ",", 
            RowBox[{"(", 
             RowBox[{"DataSymbol", "/.", "FullOpts"}], ")"}]}], "]"}]}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "perform", " ", "validation", " ", "of", " ", "options", " ", "which", 
        " ", "will", " ", "not", " ", "be", " ", "validated", " ", "at", " ", 
        "level", " ", "of", " ", "art", " ", "rendering", " ", "functions"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SymbolShape", ",", "_String", ",", 
        RowBox[{"Options", "[", "DataSymbol", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"SymbolSize", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"_", "?", "NumericQ"}], ")"}], "?", "Positive"}], ",", 
        RowBox[{"Options", "[", "DataSymbol", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"PlotPoints", ",", 
        RowBox[{"_Integer", "?", "Positive"}], ",", 
        RowBox[{"Options", "[", "DataSymbol", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "diagnostics", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Debug", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Restoring style: \>\"", ",", 
           RowBox[{"(", 
            RowBox[{"DataStyle", "/.", "FullOpts"}], ")"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"Options", "[", "DataLine", "]"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"Options", "[", "DataLine", "]"}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBmIQzdDw58OGoJeODAx/IXRDz6ayAyBaczOYZnDtenoB
RJ+H0A1u/RB61iSIeMAMCD8cShvNh4jbQGnP5RDx+6sg9Ke1LyD0Zgi9+SCY
ZvA6BKH3T9G9ChJnmAahLeZA6G/zwTTD5RUQfsJmCH/tFQjteh1Csz+ByM+G
0AzeXyD0s+8Qmuk/RF6LSQ9ijyaYZvCH0k90IbSAAYS+aA5RF2YFod/ZQcSt
7SH8Ve4QusQLQt/yg8iXREP4ZcUQ+lMrRLy3C0Kf6oaIP5wJ4YfNhdDzdPXB
4rzGYJohpsiI5xWQjgXTAJSaxiM=
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Legend construction", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataLegend", "[", 
    RowBox[{
     RowBox[{"PS", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"_", "?", "NumericQ"}], ",", 
        RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
     RowBox[{"DataSetInfo", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"_", ",", "_"}], "}"}], "..."}], "}"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"DataLegend", ",", "Opts"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "P0", ",", "Pi", ",", "DPY", ",", "DPLeft", ",",
        "DPSymbol", ",", "DPRight", ",", "DPText", ",", "DPColumn", ",", 
       "OptWidth", ",", "OptDimensions", ",", "NumRows", ",", 
       "\[IndentingNewLine]", "DataSetID", ",", "DataSetText", ",", 
       "LineVertices", ",", "\[IndentingNewLine]", "DataLineOpts", ",", 
       "DataSymbolOpts", ",", "SymbolVertices", ",", "\[IndentingNewLine]", 
       "i"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"validate", " ", "options"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"TODO", " ", "--"}], " ", "full", " ", "validation"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckOption", "[", 
       RowBox[{"Width", ",", 
        RowBox[{"Automatic", "|", 
         RowBox[{"_", "?", "NumericQ"}]}], ",", "FullOpts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckOption", "[", 
       RowBox[{"Dimensions", ",", 
        RowBox[{"Automatic", "|", "_Integer", "|", 
         RowBox[{"{", 
          RowBox[{"_Integer", ",", "_Integer"}], "}"}]}], ",", "FullOpts"}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"dimension", " ", "calculations"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"horizontal", " ", 
        RowBox[{"dimensions", ":", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"line", ":", " ", 
             RowBox[{"2", "*", "Length"}]}], ")"}], " ", "+", " ", 
           RowBox[{"(", 
            RowBox[{"gap", ":", " ", "Gap"}], ")"}], " ", "+", " ", 
           RowBox[{"(", 
            RowBox[{"text", " ", ":", " ", "Width"}], ")"}], " ", "+", " ", 
           RowBox[{"(", 
            RowBox[{"gap", ":", " ", "Gap"}], ")"}]}], " ", "..."}]}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"OptWidth", "=", 
       RowBox[{"GetAutoOption", "[", 
        RowBox[{"Width", ",", "15", ",", "FullOpts"}], "]"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"TODO", " ", "--"}], " ", "set", " ", "width", " ", "from", 
        " ", "widest", " ", "text"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"OptDimensions", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Dimensions", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", "Automatic", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Length", "[", "DataSetInfo", "]"}], ",", "1"}], "}"}], 
         ",", "\[IndentingNewLine]", "_Integer", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Dimensions", "/.", "FullOpts"}], ")"}], ",", 
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"Ceiling", "[", 
              RowBox[{
               RowBox[{"Length", "[", "DataSetInfo", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"Dimensions", "/.", "FullOpts"}], ")"}]}], "]"}], ",",
              "1"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"_Integer", ",", "_Integer"}], "}"}], ",", 
         RowBox[{"(", 
          RowBox[{"Dimensions", "/.", "FullOpts"}], ")"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"NumRows", "=", 
       RowBox[{"First", "[", "OptDimensions", "]"}]}], ";", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Dimensions", " ", "currently", " ", "just", " ", "used", " ", "to", 
        " ", "set", " ", "number", " ", "of", " ", "rows"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"P0", "=", 
       RowBox[{"PCOfPS", "[", "PS", "]"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"starting", " ", "point", " ", "UL", " ", "corner"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DPY", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", 
          RowBox[{"DYCOfYA", "[", 
           RowBox[{"FontSize", "/.", "FullOpts"}], "]"}]}]}], "}"}]}], ";", 
      "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"offset", " ", "--"}], " ", "down", " ", "a", " ", "row"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DPLeft", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"offset", " ", "--"}], " ", "in", " ", "to", " ", "left", " ",
         "of", " ", "line"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DPSymbol", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"DXCOfXA", "[", 
          RowBox[{"Length", "/.", "FullOpts"}], "]"}], ",", "0"}], "}"}]}], 
      ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"offset", " ", "--"}], " ", "in", " ", "to", " ", "symbol"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DPRight", "=", 
       RowBox[{"2", "*", "DPSymbol"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"offset", " ", "--"}], " ", "in", " ", "to", " ", "right", 
        " ", "of", " ", "line"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DPText", "=", 
       RowBox[{"DPRight", "+", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"DXCOfXA", "[", 
           RowBox[{"Gap", "/.", "FullOpts"}], "]"}], ",", "0"}], "}"}]}]}], 
      ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"offset", " ", "--"}], " ", "in", " ", "to", " ", "text"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DPColumn", "=", 
       RowBox[{"DPText", "+", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"DXCOfXA", "[", "OptWidth", "]"}], ",", "0"}], "}"}], "+", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"DXCOfXA", "[", 
           RowBox[{"Gap", "/.", "FullOpts"}], "]"}], ",", "0"}], "}"}]}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Show", "/.", "FullOpts"}], ")"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "otherwise", " ", "overridden", " ", "by", " ", "Show", " ", "in", 
          " ", "DataLineOpts", " ", "or", " ", "DataSymbolOpts"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"TableForEach", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"starting", " ", "location"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"position", " ", "for", " ", "start", " ", "of", " ", 
             RowBox[{"line", ":", " ", 
              RowBox[{
               RowBox[{"legend", " ", "UL", " ", "corner"}], " ", "+", " ", 
               RowBox[{"down", " ", "half", " ", "line"}], " ", "+", " ", 
               RowBox[{"down", " ", "0"}], "-", 
               RowBox[{"based", " ", "rows"}], " ", "+", " ", 
               RowBox[{"across", " ", "0"}], "-", 
               RowBox[{"based", " ", "columns"}]}]}]}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"Pi", "=", 
              RowBox[{"P0", "+", 
               RowBox[{
                RowBox[{"1", "/", "2"}], "*", "DPY"}], "+", 
               RowBox[{
                RowBox[{"Mod", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "-", "1"}], ")"}], ",", "NumRows"}], "]"}], 
                "*", 
                RowBox[{"(", 
                 RowBox[{"LineSpacing", "/.", "FullOpts"}], ")"}], "*", 
                "DPY"}], "+", 
               RowBox[{
                RowBox[{"Quotient", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "-", "1"}], ")"}], ",", "NumRows"}], "]"}], 
                "*", 
                RowBox[{"(", 
                 RowBox[{"LineSpacing", "/.", "FullOpts"}], ")"}], "*", 
                "DPColumn"}]}]}], ";", "\[IndentingNewLine]", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{"line", " ", "and", " ", "symbol"}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"BlockSchemeOptions", "[", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"UseDataOptions", "[", 
                  RowBox[{"DataStyle", "->", "DataSetID"}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"LineVertices", "=", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Pi", "+", "DPLeft"}], ",", 
                    RowBox[{"Pi", "+", "DPRight"}]}], "}"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"MakeOutline", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"Line", "[", "LineVertices", "]"}], "}"}], ",", 
                   RowBox[{"Options", "[", "DataLine", "]"}]}], "]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"SymbolVertices", "=", 
                  RowBox[{
                   RowBox[{"DataSymbolVertices", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"SymbolShape", "/.", 
                    RowBox[{"Options", "[", "DataSymbol", "]"}]}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"SymbolSize", "/.", 
                    RowBox[{"Options", "[", "DataSymbol", "]"}]}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"PlotPoints", "/.", 
                    RowBox[{"Options", "[", "DataSymbol", "]"}]}]}], 
                    "\[IndentingNewLine]", "]"}], "[", 
                   RowBox[{"Pi", "+", "DPSymbol"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"MakeOutline", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Line", "[", 
                    RowBox[{"Append", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"First", "[", "#", "]"}]}], "]"}], "]"}], "&"}], 
                    ")"}], "@", "SymbolVertices"}], "}"}], ",", 
                   RowBox[{"Options", "[", "DataSymbol", "]"}]}], "]"}]}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"MakeFill", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Polygon", "@", "SymbolVertices"}], "}"}], ",", 
                  RowBox[{"Options", "[", "DataSymbol", "]"}]}], "]"}]}], 
               "\[IndentingNewLine]", "}"}], "]"}]}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", "label", " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"MakeText", "[", 
             RowBox[{"DataSetText", ",", 
              RowBox[{"Pi", "+", "DPText"}], ",", "0", ",", 
              RowBox[{"Offset", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ",", "FullOpts"}], 
             "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"DataSetID", ",", "DataSetText"}], "}"}], ",", "i", ",", 
            "DataSetInfo"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4644513501875*^9, 3.46445138278125*^9}, {
   3.46445150503125*^9, 3.464451542921875*^9}, {3.46695391559375*^9, 
   3.466953973171875*^9}, {3.46695401746875*^9, 3.4669540913125*^9}, {
   3.467213037640625*^9, 3.467213125890625*^9}, {3.467213218109375*^9, 
   3.467213302375*^9}, {3.467213624796875*^9, 3.467213630078125*^9}, {
   3.467213664*^9, 3.4672136685*^9}, 3.46775788875*^9, 3.496055698921875*^9, {
   3.50319102275*^9, 3.50319113434375*^9}, 3.503191169125*^9, {
   3.503191306921875*^9, 3.503191830171875*^9}, 3.5031918845625*^9, {
   3.50319193*^9, 3.50319203515625*^9}, {3.503265262265625*^9, 
   3.50326528246875*^9}, {3.503265319359375*^9, 3.5032653205*^9}, {
   3.503265351390625*^9, 3.503265392125*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure construction", "Section"],

Cell[CellGroupData[{

Cell["Conditional evaluation", "Subsection"],

Cell["\<\
SchemeIfDef, SchemeIfNDef -- conditional inclusion
\tUses global variable: $SchemeFlags\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SchemeDef", "[", "Flag_", "]"}], ":=", 
   RowBox[{"MemberQ", "[", 
    RowBox[{"$SchemeFlags", ",", "Flag"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetAttributes", "[", 
    RowBox[{"SchemeIf", ",", "HoldRest"}], "]"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "HoldRest", " ", "to", " ", "avoid", " ", "side", " ", "effects", " ", 
    "of", " ", "evaluating", " ", "Objects", " ", "sequence"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeIf", "[", 
    RowBox[{"Expr_", ",", "Objects___"}], "]"}], ":=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"TrueQ", "[", "Expr", "]"}], ",", 
      RowBox[{"{", "Objects", "}"}], ",", 
      RowBox[{"{", "}"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetAttributes", "[", 
    RowBox[{"SchemeIfDef", ",", "HoldRest"}], "]"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "HoldRest", " ", "to", " ", "avoid", " ", "side", " ", "effects", " ", 
    "of", " ", "evaluating", " ", "Objects", " ", "sequence"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeIfDef", "[", 
    RowBox[{"Flag_", ",", "Objects___"}], "]"}], ":=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"MemberQ", "[", 
       RowBox[{"$SchemeFlags", ",", "Flag"}], "]"}], ",", 
      RowBox[{"{", "Objects", "}"}], ",", 
      RowBox[{"{", "}"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetAttributes", "[", 
    RowBox[{"SchemeIfNDef", ",", "HoldRest"}], "]"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "HoldRest", " ", "to", " ", "avoid", " ", "side", " ", "effects", " ", 
    "of", " ", "evaluating", " ", "Objects", " ", "sequence"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeIfNDef", "[", 
    RowBox[{"Flag_", ",", "Objects___"}], "]"}], ":=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$SchemeFlags", ",", "Flag"}], "]"}]}], ",", 
      RowBox[{"{", "Objects", "}"}], ",", 
      RowBox[{"{", "}"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetAttributes", "[", 
    RowBox[{"SchemeIfElseDef", ",", "HoldRest"}], "]"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "HoldRest", " ", "to", " ", "avoid", " ", "side", " ", "effects", " ", 
    "of", " ", "evaluating", " ", "Objects", " ", "sequence"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchemeIfElseDef", "[", 
    RowBox[{"Flag_", ",", "Object1_", ",", "Object2_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"$SchemeFlags", ",", "Flag"}], "]"}], ",", "Object1", ",", 
     "Object2"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.42817143909375*^9, 3.4281714479375*^9}, {
  3.428173927265625*^9, 3.42817399271875*^9}, {3.428177660578125*^9, 
  3.4281776609375*^9}, {3.454768664515625*^9, 3.45476871603125*^9}, {
  3.45476882734375*^9, 3.454768831296875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Layer sorting auxiliary functions", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GetLayer", "[", 
    RowBox[{"SchemeGraphics", "[", 
     RowBox[{"_", ",", "_", ",", "LayerID_"}], "]"}], "]"}], ":=", 
   "LayerID"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SchemeGraphicsOrderedQ", "=", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Obj1", ",", "Obj2"}], "}"}], ",", 
     RowBox[{
      RowBox[{"GetLayer", "[", "Obj1", "]"}], "\[LessEqual]", 
      RowBox[{"GetLayer", "[", "Obj2", "]"}]}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure display", "Subsection"],

Cell["\<\
\tMust set attribute HoldFirst for Figure[], so that any SetOptions[] \
expressions in the arguments are not evaluated  until *after* we have saved \
the global values using BlockOptions.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"Figure", ",", 
    RowBox[{"{", "HoldFirst", "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Figure", "[", 
    RowBox[{"Body_List", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"option", " ", "variables"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"FigRealizeOptions", "[", 
         RowBox[{"Figure", ",", "Opts"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ExpansionFactor", "=", 
        RowBox[{"10", "^", 
         RowBox[{"-", "4"}]}]}], ",", "  ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"CHECK", " ", "--"}], " ", "still", " ", 
         RowBox[{"needed", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"work", " ", "variables"}], " ", "*)"}], 
       "\[IndentingNewLine]", "SchemeList", ",", "\[IndentingNewLine]", 
       "RawFrameLabel", ",", "\[IndentingNewLine]", "FormattedFrameLabel", 
       ",", "\[IndentingNewLine]", "GraphicsPrimatives", ",", 
       "\[IndentingNewLine]", "GraphicsOptions", ",", "\[IndentingNewLine]", 
       "FullGraphics", ",", "\[IndentingNewLine]", "FrameStyleOpts", ",", 
       "FrameTextStyleOpts", ",", "TickTextStyleOpts", ",", 
       "\[IndentingNewLine]", "UsedPlotRange", ",", "\[IndentingNewLine]", 
       "ErrorStatus", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"pattern", " ", "names"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "locally", " ", "define", " ", "pattern", " ", "names", " ", "used", 
          " ", "in", " ", "scheme", " ", "list", " ", "processing"}], ",", 
         " ", 
         RowBox[{
         "to", " ", "avoid", " ", "glitch", " ", "if", " ", "global", " ", 
          "value", " ", "defined", " ", 
          RowBox[{"(", 
           RowBox[{
           "though", " ", "this", " ", "is", " ", "not", " ", "really", " ", 
            "a", " ", "concern", " ", "in", " ", "the", " ", "Private", " ", 
            "context"}], ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
       "GraphicsObject", ",", "\[IndentingNewLine]", "Primatives"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Flag", " ", "entry", " ", "into", " ", "Scheme"}], ",", " ", 
       RowBox[{"for", " ", "error", " ", "handling", " ", "mechanism"}]}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{"$InScheme", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{"LevelScheme", "::", "notreentrant"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Return", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Block", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"$InScheme", "=", "True"}], "\[IndentingNewLine]", "}"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Check", " ", "options"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"CatchError", "[", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"PlotRange", "/.", "FullOpts"}], ")"}], "===", 
                 "Automatic"}], ",", 
                RowBox[{"Message", "[", 
                 RowBox[{"Figure", "::", "prange"}], "]"}]}], "]"}], ";"}], 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"CheckOption", "[", 
              RowBox[{"PlotRange", ",", 
               RowBox[{"Automatic", "|", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"_", "?", "NumericQ"}], ",", 
                    RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"_", "?", "NumericQ"}], ",", 
                    RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "}"}]}], ",", 
               "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"CheckOption", "[", 
              RowBox[{"ImageSize", ",", 
               RowBox[{"Automatic", "|", 
                RowBox[{"_", "?", "NumericQ"}], "|", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"_", "?", "NumericQ"}], ",", 
                  RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", 
               "FullOpts"}], "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"CheckOption", "[", 
              RowBox[{"BlockOptions", ",", 
               RowBox[{"{", "___Symbol", "}"}], ",", "FullOpts"}], "]"}], ";",
              "\[IndentingNewLine]", 
             RowBox[{"CheckOption", "[", 
              RowBox[{"Block", ",", 
               RowBox[{"{", "___Symbol", "}"}], ",", "FullOpts"}], "]"}], ";",
              "\[IndentingNewLine]", 
             RowBox[{"CheckOption", "[", 
              RowBox[{"SchemeFlags", ",", 
               RowBox[{"{", "___String", "}"}], ",", "FullOpts"}], "]"}]}], 
            "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "Debugging", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Information", "/.", "FullOpts"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Print", "[", "$Version", "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"{", 
              RowBox[{
              "$System", ",", "$SystemID", ",", "$OperatingSystem", ",", 
               "$MachineType", ",", "$ProcessorType", ",", "$ByteOrdering", 
               ",", "$MachineName"}], "}"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", "$Path", "]"}]}]}], "\[IndentingNewLine]", 
          "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Clear", " ", "any", " ", "existing", " ", "scheme", " ", "data", 
           " ", "definitions"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", 
          RowBox[{
          "\"\<LevelScheme`Data`*\>\"", ",", 
           "\"\<LevelScheme`Multipanel`*\>\"", ",", 
           "\"\<LevelScheme`AutoLevel`\>\""}], "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Set", " ", "up", " ", "coordinate", " ", "systems"}], " ", 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"absolute", " ", "size", " ", "imitates", " ", "Show"}], 
           ",", " ", 
           RowBox[{"defaulting", " ", "to", " ", "4", "*", "72"}], ",", " ", 
           RowBox[{
           "with", " ", "GoldenRatio", " ", "aspect", " ", "ratio"}]}], " ", 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"$AbsSize", "=", 
          RowBox[{"Switch", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ImageSize", "/.", "FullOpts"}], ")"}], ",", 
            "\[IndentingNewLine]", "Automatic", ",", 
            RowBox[{"4", "*", "72", "*", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"1", "/", "GoldenRatio"}]}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"_", "?", "NumericQ"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ImageSize", "/.", "FullOpts"}], ")"}], "*", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"1", "/", "GoldenRatio"}]}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"_", "?", "NumericQ"}], ",", 
              RowBox[{"_", "?", "NumericQ"}]}], "}"}], ",", 
            RowBox[{"(", 
             RowBox[{"ImageSize", "/.", "FullOpts"}], ")"}]}], 
           "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "Plot", " ", "range", " ", "is", " ", "expanded", " ", "outwards", 
            " ", "by", " ", "small", " ", "fraction", " ", "in", " ", "each", 
            " ", "direction"}], ",", " ", 
           RowBox[{
            RowBox[{"beyond", " ", "user"}], "-", 
            RowBox[{"determined", " ", "nominal", " ", "range"}]}], ",", " ", 
           
           RowBox[{
           "so", " ", "ending", " ", "tick", " ", "labels", " ", "are", " ", 
            "guaranteed", " ", "to", " ", "fit", " ", 
            RowBox[{"in", "."}]}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
         
         RowBox[{"UsedPlotRange", "=", 
          RowBox[{"ExtendRegion", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"N", "[", 
             RowBox[{"GetAutoOption", "[", 
              RowBox[{"PlotRange", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "FullOpts"}], 
              "]"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{"ExtendRange", "/.", "FullOpts"}], ")"}]}], 
           "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"$CanvasRange", "=", 
          RowBox[{"ExtendRegion", "[", 
           RowBox[{"UsedPlotRange", ",", "ExpansionFactor"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"$P1C", "=", 
          RowBox[{"First", "/@", "$CanvasRange"}]}], ";", 
         RowBox[{"$P2C", "=", 
          RowBox[{"Last", "/@", "$CanvasRange"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"$TickScaleFactor", "=", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Plus", "@@", "$AbsSize"}], "/", "2"}], ")"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CatchError", "[", 
            RowBox[{"SetRegion", "[", "]"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Initialize", " ", "global", " ", "state", " ", "variables"}], " ", 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"$SchemeFlags", "=", 
          RowBox[{"(", 
           RowBox[{"SchemeFlags", "/.", "FullOpts"}], ")"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"$LastLevel", "=", "Null"}], ";", "\[IndentingNewLine]", 
         RowBox[{"$Background", "=", "None"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Evaluate", " ", "body"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "implements", " ", "held", " ", "calls", " ", "to", " ", 
            "SetOptions"}], ",", " ", 
           RowBox[{
           "catches", " ", "any", " ", "Throw", " ", "from", " ", "option", 
            " ", "or", " ", "parameter", " ", "validation"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"Block", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"$DisplayFunction", "=", "Identity"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Block", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Evaluate", "[", 
              RowBox[{"(", 
               RowBox[{"Block", "/.", "FullOpts"}], ")"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BlockOptions", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Union", "[", 
                RowBox[{"OptionSymbols", ",", "OptionSymbols3D", ",", 
                 RowBox[{"(", 
                  RowBox[{"BlockOptions", "/.", "FullOpts"}], ")"}]}], "]"}], 
               ",", "\[IndentingNewLine]", 
               RowBox[{"ErrorStatus", "=", 
                RowBox[{"CatchError", "[", 
                 RowBox[{"SchemeList", "=", "Body"}], "]"}]}]}], 
              "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "handle", " ", "possible", " ", "error", " ", "thrown", " ", "by", 
            " ", "ErrorMessage"}], ",", " ", 
           RowBox[{
           "but", " ", "only", " ", "now", " ", "after", " ", "block", " ", 
            "constructs", " ", "have", " ", "restored", " ", "all", " ", 
            "scoped", " ", "values"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"ErrorStatus", ",", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Preprocess", " ", "list", " ", "of", " ", "scheme", " ", 
           "objects"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Flatten", " ", "list"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"SchemeList", "=", 
          RowBox[{"Flatten", "[", "SchemeList", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Debug", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Object list after flattening: \>\"", ",", 
             RowBox[{"SchemeList", "//", "InputForm"}]}], "]"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Strip", " ", "any", " ", "remaining", " ", "unidentified", " ", 
           "objects"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Count", "[", 
             RowBox[{"SchemeList", ",", 
              RowBox[{"(", 
               RowBox[{
               "_Graphics", "|", "_ContourGraphics", "|", 
                "_DensityGraphics"}], ")"}], ",", 
              RowBox[{"{", "1", "}"}]}], "]"}], "\[NotEqual]", "0"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Message", "[", 
            RowBox[{"Figure", "::", "freegraphics"}], "]"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Count", "[", 
             RowBox[{"SchemeList", ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"_SchemeGraphics", "*", "_"}], ")"}], "|", 
               RowBox[{"(", 
                RowBox[{"_SchemeGraphics", "^", "_"}], ")"}]}], ",", 
              "Infinity"}], "]"}], "\[NotEqual]", "0"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Message", "[", 
            RowBox[{"Figure", "::", "timesgraphics"}], "]"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"SchemeList", "=", 
          RowBox[{"Cases", "[", 
           RowBox[{"SchemeList", ",", "_SchemeGraphics"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Debug", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Object list after cleanup: \>\"", ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"SchemeList", "//", "InputForm"}], ")"}], "//", 
              "TableForm"}]}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Sort", " ", "scheme", " ", "by", " ", "layer"}], " ", 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"SchemeList", "=", 
          RowBox[{"Sort", "[", 
           RowBox[{"SchemeList", ",", "SchemeGraphicsOrderedQ"}], "]"}]}], 
         ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Extract", " ", "all", " ", "the", " ", "graphics", " ", 
           "primatives"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"GraphicsPrimatives", "=", 
          RowBox[{"Replace", "[", "\[IndentingNewLine]", 
           RowBox[{"SchemeList", ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"SchemeGraphics", "[", 
               RowBox[{"Directives_List", ",", "Primatives_List", ",", "_"}], 
               "]"}], "\[RuleDelayed]", 
              RowBox[{"Join", "[", 
               RowBox[{"Directives", ",", "Primatives"}], "]"}]}], "}"}], ",",
             "\[IndentingNewLine]", 
            RowBox[{"{", "1", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"GraphicsPrimatives", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"GraphicsPrimatives", ",", "1"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Debug", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Graphics size before directive pruning: \>\"", ",", 
             RowBox[{"ByteCount", "[", "GraphicsPrimatives", "]"}], ",", 
             "\"\< bytes\>\""}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Construct", " ", "graphics", " ", "display", " ", "options"}], " ",
           "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CatchError", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"FrameStyleOpts", "=", 
              RowBox[{"MakeOutlineDirectives", "[", "FullOpts", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"FrameTextStyleOpts", "=", 
              RowBox[{"MakeTextStyle", "[", "FullOpts", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"TickTextStyleOpts", "=", 
              RowBox[{"MakeTextStyle", "[", 
               RowBox[{"OptionsUnion", "[", "\[IndentingNewLine]", 
                RowBox[{"(*", " ", 
                 RowBox[{"TickOpacity", " ", "ignored"}], " ", "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", 
                  RowBox[{"GetAutoOption", "[", 
                   RowBox[{"TickFontFamily", ",", 
                    RowBox[{"FontFamily", "/.", "FullOpts"}], ",", 
                    "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"FontSize", "\[Rule]", 
                  RowBox[{"GetAutoOption", "[", 
                   RowBox[{"TickFontSize", ",", 
                    RowBox[{"FontSize", "/.", "FullOpts"}], ",", "FullOpts"}],
                    "]"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"FontWeight", "\[Rule]", 
                  RowBox[{"GetAutoOption", "[", 
                   RowBox[{"TickFontWeight", ",", 
                    RowBox[{"FontWeight", "/.", "FullOpts"}], ",", 
                    "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"FontSlant", "\[Rule]", 
                  RowBox[{"GetAutoOption", "[", 
                   RowBox[{"TickFontSlant", ",", 
                    RowBox[{"FontSlant", "/.", "FullOpts"}], ",", 
                    "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"FontTracking", "\[Rule]", 
                  RowBox[{"GetAutoOption", "[", 
                   RowBox[{"TickFontTracking", ",", 
                    RowBox[{"FontTracking", "/.", "FullOpts"}], ",", 
                    "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"FontColor", "\[Rule]", 
                  RowBox[{"GetAutoOption", "[", 
                   RowBox[{"TickFontColor", ",", 
                    RowBox[{"FontColor", "/.", "FullOpts"}], ",", 
                    "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"FontOpacity", "\[Rule]", 
                  RowBox[{"GetAutoOption", "[", 
                   RowBox[{"TickFontOpacity", ",", 
                    RowBox[{"FontOpacity", "/.", "FullOpts"}], ",", 
                    "FullOpts"}], "]"}]}], ",", "\[IndentingNewLine]", 
                 "FullOpts"}], "\[IndentingNewLine]", "]"}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"RawFrameLabel", "=", 
          RowBox[{"Switch", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"FrameLabel", "/.", "FullOpts"}], ")"}], ",", 
            "\[IndentingNewLine]", "None", ",", "\[IndentingNewLine]", "None",
             ",", "\[IndentingNewLine]", "Automatic", ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"LabB", ",", "LabL", ",", "LabT", ",", "LabR"}], "}"}], 
             "/.", "FullOpts"}], ",", "\[IndentingNewLine]", "_List", ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{"FrameLabel", "/.", "FullOpts"}], ")"}]}], 
           "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"FormattedFrameLabel", "=", 
          RowBox[{"Switch", "[", "\[IndentingNewLine]", 
           RowBox[{
           "RawFrameLabel", ",", "\[IndentingNewLine]", "None", ",", "None", 
            ",", "\[IndentingNewLine]", "_List", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"#", "===", "None"}], ",", "None", ",", 
                 RowBox[{"DisplayForm", "[", 
                  RowBox[{"StyleForm", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"Sequence", "@@", "FrameTextStyleOpts"}]}], "]"}],
                   "]"}]}], "]"}], ")"}], "&"}], "/@", "RawFrameLabel"}]}], 
           "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"GraphicsOptions", "=", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"PlotRange", " ", "\[Rule]", "$CanvasRange"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ImageSize", "\[Rule]", "$AbsSize"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", 
             RowBox[{
              RowBox[{"$AbsSize", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "/", 
              RowBox[{"$AbsSize", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Frame", "->", " ", 
             RowBox[{"(", 
              RowBox[{"Frame", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"FrameStyle", "\[Rule]", 
             RowBox[{"Directive", "[", "FrameStyleOpts", "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"FrameLabel", "\[Rule]", "FormattedFrameLabel"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"FrameTicks", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"FrameTicks", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Axes", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"Axes", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"Ticks", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"TextStyle", "\[Rule]", "TickTextStyleOpts"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Background", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"Background", "/.", "FullOpts"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"DisplayFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"DisplayFunction", "/.", "FullOpts"}], ")"}]}]}], 
           "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Debug", "/.", "FullOpts"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Graphics options: \>\"", ",", "GraphicsOptions"}], 
            "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]",
          "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Construct", " ", "and", " ", "render", " ", "full", " ", 
           "graphics", " ", "object"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"FullGraphics", "=", 
          RowBox[{"Graphics", "[", 
           RowBox[{"GraphicsPrimatives", ",", "GraphicsOptions"}], "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"Show", "[", "FullGraphics", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Delete", " ", "scheme", " ", "data", " ", "definitions"}], 
          " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", 
          RowBox[{
          "\"\<LevelScheme`Data`*\>\"", ",", 
           "\"\<LevelScheme`Multipanel`*\>\"", ",", 
           "\"\<LevelScheme`AutoLevel`\>\""}], "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         
         RowBox[{"(*", " ", 
          RowBox[{"Return", " ", "result"}], " ", "*)"}], 
         "\[IndentingNewLine]", "FullGraphics"}]}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.395094058546875*^9, 3.39509406065625*^9}, {
   3.395094145734375*^9, 3.3950941489375*^9}, {3.395094187234375*^9, 
   3.395094190671875*^9}, {3.395094437453125*^9, 3.395094451484375*^9}, {
   3.395094677546875*^9, 3.39509467865625*^9}, 3.395094712265625*^9, {
   3.395094749828125*^9, 3.39509478028125*^9}, {3.395094815765625*^9, 
   3.395094816171875*^9}, {3.395094909625*^9, 3.39509491075*^9}, {
   3.3950953448125*^9, 3.395095377296875*^9}, {3.395520199671875*^9, 
   3.3955202125*^9}, 3.396633484703125*^9, {3.396634631390625*^9, 
   3.3966346449375*^9}, {3.396635471921875*^9, 3.39663547665625*^9}, {
   3.396635677296875*^9, 3.396635680078125*^9}, 3.398810229140625*^9, {
   3.4206605831875*^9, 3.42066058390625*^9}, {3.431539924625*^9, 
   3.431539929875*^9}, {3.43153999265625*^9, 3.4315400235*^9}, {
   3.43154015796875*^9, 3.4315401606875*^9}, {3.4315403589375*^9, 
   3.4315403851875*^9}, {3.43154046675*^9, 3.431540467625*^9}, {
   3.431540586984375*^9, 3.431540601171875*^9}, {3.431540692015625*^9, 
   3.43154072634375*^9}, {3.431540771671875*^9, 3.431540785703125*^9}, 
   3.431637606765625*^9, {3.46995746359375*^9, 3.469957477515625*^9}, 
   3.4960556989375*^9, {3.49722478321875*^9, 3.49722482246875*^9}, {
   3.497224862296875*^9, 3.497224862578125*^9}, {3.497384915140625*^9, 
   3.497384921984375*^9}, {3.505334958890625*^9, 3.505334990515625*^9}, {
   3.51232256684375*^9, 3.51232257675*^9}, {3.512322763734375*^9, 
   3.512322783234375*^9}, {3.512322825296875*^9, 3.51232283390625*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["User-accessible utilities", "Section"],

Cell[CellGroupData[{

Cell["Automatic level/transition spacing controls ", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AutoLevelInit", "[", 
     RowBox[{"Posn_", ",", "Space_", ",", "BigSpace_"}], "]"}], "  ", ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"LevelScheme`AutoLevel`IDi", " ", "=", " ", "Null"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"LevelScheme`AutoLevel`Posn", " ", "=", " ", "Posn"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"LevelScheme`AutoLevel`Space", " ", "=", " ", "Space"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"LevelScheme`AutoLevel`xbigSpace", " ", "=", " ", "BigSpace"}],
        ";", "\[IndentingNewLine]", "Null"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AutoLevel", "[", 
     RowBox[{"IDi_", "?", "LevelIdentifierQ"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"LevelScheme`AutoLevel`Posn", "+=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"TrueQ", "[", 
           RowBox[{"LevelScheme`AutoLevel`IDi", " ", "===", " ", "Null"}], 
           "]"}], ",", " ", "0", ",", 
          RowBox[{
          "LevelScheme`AutoLevel`xbigSpace", "-", 
           "LevelScheme`AutoLevel`Space"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"LevelScheme`AutoLevel`IDi", "=", "IDi"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AutoTrans", "[", 
    RowBox[{
     RowBox[{"IDf_", "?", "LevelIdentifierQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "Posn", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CheckInScheme", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Posn", "=", "LevelScheme`AutoLevel`Posn"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
      "LevelScheme`AutoLevel`Posn", "+=", "LevelScheme`AutoLevel`Space"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"Trans", "[", 
       RowBox[{
       "LevelScheme`AutoLevel`IDi", ",", "Posn", ",", "IDf", ",", "Automatic",
         ",", "Opts"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extraction of points from graphics", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox[
    RowBox[{"ExtractCurves", "[", 
     RowBox[{"G", ":", 
      RowBox[{"(", 
       RowBox[{"_Graphics", "|", "_Graphics3D"}], ")"}]}], "]"}],
    InitializationCell->True], 
   StyleBox[":=",
    InitializationCell->True], 
   RowBox[{
    StyleBox["Module",
     InitializationCell->True], 
    StyleBox["[",
     InitializationCell->True], 
    StyleBox["\[IndentingNewLine]",
     InitializationCell->True], 
    RowBox[{
     StyleBox[
      RowBox[{"{", 
       RowBox[{"LineSet", ",", "CurveComplexSet"}], "}"}],
      InitializationCell->True], 
     StyleBox[",",
      InitializationCell->True], 
     StyleBox["\[IndentingNewLine]",
      InitializationCell->True], 
     RowBox[{
      RowBox[{
       StyleBox["LineSet",
        InitializationCell->True], 
       StyleBox["=",
        InitializationCell->True], 
       RowBox[{
        StyleBox["Cases",
         InitializationCell->True], 
        StyleBox["[",
         InitializationCell->True], 
        RowBox[{
         StyleBox["G",
          InitializationCell->True], 
         StyleBox[",",
          InitializationCell->True], 
         RowBox[{
          StyleBox[
           RowBox[{"Line", "[", 
            RowBox[{"c", ":", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"_", "?", "NumericQ"}], ",", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}], ".."}], "}"}]}], 
            "]"}],
           InitializationCell->True], "|", 
          StyleBox[
           RowBox[{"Line", "[", 
            RowBox[{"cc", ":", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"_", "?", "NumericQ"}], ",", 
                   RowBox[{"_", "?", "NumericQ"}]}], "}"}], ".."}], "}"}], ".."}
               ], "}"}]}], "]"}],
           InitializationCell->True]}], 
         StyleBox[",",
          InitializationCell->True], 
         StyleBox["Infinity",
          InitializationCell->True]}], 
        StyleBox["]",
         InitializationCell->True]}]}], 
      StyleBox[";",
       InitializationCell->True], 
      StyleBox["\[IndentingNewLine]",
       InitializationCell->True], 
      RowBox[{"CurveComplexSet", "=", 
       RowBox[{
        StyleBox["Replace",
         InitializationCell->True], 
        StyleBox["[",
         InitializationCell->True], 
        StyleBox["\[IndentingNewLine]",
         InitializationCell->True], 
        RowBox[{
         StyleBox["LineSet",
          InitializationCell->True], 
         StyleBox[",",
          InitializationCell->True], 
         StyleBox["\[IndentingNewLine]",
          InitializationCell->True], 
         RowBox[{
          StyleBox["{",
           InitializationCell->True], 
          RowBox[{
           RowBox[{
            StyleBox[
             RowBox[{"Line", "[", 
              RowBox[{"c", ":", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"_", "?", "NumericQ"}], ",", 
                   RowBox[{"_", "?", "NumericQ"}]}], "}"}], ".."}], "}"}]}], 
              "]"}],
             InitializationCell->True], 
            StyleBox["\[RuleDelayed]",
             InitializationCell->True], 
            RowBox[{
             StyleBox["{",
              InitializationCell->True], "c", "}"}]}], ",", 
           RowBox[{
            StyleBox[
             RowBox[{"Line", "[", 
              RowBox[{"cc", ":", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"_", "?", "NumericQ"}], ",", 
                    RowBox[{"_", "?", "NumericQ"}]}], "}"}], ".."}], "}"}], 
                 ".."}], "}"}]}], "]"}],
             InitializationCell->True], 
            StyleBox["\[RuleDelayed]",
             InitializationCell->True], 
            StyleBox[
             RowBox[{
              StyleBox["c",
               InitializationCell->True], "c"}]]}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "1", "}"}]}], "\[IndentingNewLine]", 
        StyleBox["]",
         InitializationCell->True]}]}], 
      StyleBox[";",
       InitializationCell->True], 
      StyleBox["\[IndentingNewLine]",
       InitializationCell->True], 
      StyleBox[
       RowBox[{"Flatten", "[", 
        RowBox[{"CurveComplexSet", ",", "1"}], "]"}],
       InitializationCell->True]}]}], 
    StyleBox["\[IndentingNewLine]",
     InitializationCell->True], 
    StyleBox["]",
     InitializationCell->True]}]}], 
  StyleBox[";",
   InitializationCell->True]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.49238034571875*^9, 3.492380442734375*^9}, {
   3.49238061284375*^9, 3.49238073415625*^9}, {3.492380766734375*^9, 
   3.4923808134375*^9}, 3.492380943328125*^9}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"ExtractCurves", "[", 
     RowBox[{"CG", ":", 
      RowBox[{"(", "_ContourGraphics", ")"}]}], "]"}], ":=", 
    RowBox[{"ExtractCurves", "[", 
     RowBox[{"Graphics", "[", "CG", "]"}], "]"}]}], ";"}],
  InitializationCell->True]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.49238089921875*^9, {3.49238094475*^9, 3.49238094565625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GrabPoints", "[", 
    RowBox[{"G", ":", 
     RowBox[{"(", 
      RowBox[{"_Graphics", "|", "_Graphics3D", "|", "_ContourGraphics"}], 
      ")"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "Curves", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Curves", "=", 
       RowBox[{"ExtractCurves", "[", "G", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "Curves", "]"}], "==", "0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Message", "[", 
         RowBox[{"GrabPoints", "::", "nolines"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{