(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* :Title: LevelScheme *)
(* :Context: LevelScheme`LevelScheme` *)
(* :Summary: Scientific figure preparation system *)
(* :Author: Mark A. Caprio, Department of Physics, University of Notre Dame *)
(* :Copyright: Copyright 2013, Mark A. Caprio *)
(* :Package Version: 3.53 *)
(* :Mathematica Version: 9.0 *)
(* :History:
Early ancestor code, July 1999.
   V1 .00, January 2004 (first web release). 
V2.00, November 2004.  
 V3 .00, March 2005.
 V3 .01, March 2005.
 V3.02, April 2005.
 V3 .10, April 2005 (CPCPL distribution).
V3.11, May 2005.
   V3 .20, October 2005.
   V3 .21, October 2005.
 V3 .30, July 2007.
V3 .40, August 2007.
V3 .41, September 2007.
V3 .42, September 2008.
V3 .43, November 2008.
V3 .44, February 2009.
V3 .45, December 2009.
V3 .50, November 2010.
V3 .51, February 2011.
V3 .52, September 2011.
V3 .53, January 2013.
*)
(* :Discussion:
 The LevelScheme package has been published in Computer Physics Communications, M. A. Caprio, Comput. Phys. Commun. 171, 107 (2005).  Updates and further information may be obtained through the LevelScheme home page, www.levelscheme.org.  If you modify the software, you *must* change the package name and *must* change the message displayed when the package is loaded, to clearly indicate that the package is a modified version.
*)


BeginPackage["LevelScheme`",Join[
{
"CustomTicks`",
"BlockOptions`",
"InheritOptions`",
"ForEach`",
"ClipToRectangle`",
"NamedColors`",
"LevelScheme`MCText`"
},
If[$VersionNumber<9,{"Graphics`Common`GraphicsCommon`"},{}]
]
];


Unprotect[Evaluate[$Context<>"*"]];


LevelSchemeRevisionString="3.53 (January 10, 2013)";
LevelSchemeHomePageURL="http://scidraw.nd.edu/levelscheme/landing/levelscheme-3.53.html";


If[!ValueQ[LevelScheme`Config`Splash],LevelScheme`Config`Splash=True];


LevelScheme::mathversion="This version of LevelScheme requires Mathematica 6 or higher.  You are currently running Mathematica `1`.  Please visit the LevelScheme home page to download a legacy version of LevelScheme which will run under your version of Mathematica.";


If[
$VersionNumber<6.0,
Message[LevelScheme::mathversion,IntegerPart[$VersionNumber]];
Abort[]
];


SchemeObject::usage="Parent object for option inheritance for level scheme objects.";


Color::usage="Option for level scheme drawing objects.";
Opacity::reusage="Option for level scheme drawing objects."; (*System`*)
ShowLine::usage="Option for level scheme drawing objects."; 
LineColor::usage="Option for level scheme drawing objects."; 
LineOpacity::usage="Option for level scheme drawing objects."; 
Thickness::reusage="Option for level scheme drawing objects.";  (*System`*)
Dashing::reusage="Option for level scheme drawing objects.";  (*System`*)
CapForm::reusage="Option for level scheme drawing objects.";  (*System`*)
DashingGap::usage="Option for level scheme drawing objects."; 
DashingCorrection::usage="Option for level scheme drawing objects."; 
ShowFill::usage="Option for level scheme drawing objects."; 
FillColor::usage="Option for level scheme drawing objects."; 
FillOpacity::usage="Option for level scheme drawing objects."; 
(*FontXXXXXX options are all from System`. *)
Show::reusage="Option for level scheme drawing objects."; (*System`*)
Tooltip::reusage="Option for level scheme drawing objects."; (*System`*)
Layer::usage="Option for level scheme drawing objects."; 
Tag::usage="Option for level scheme drawing objects."; 
ConditionalOptions::usage="Option for level scheme drawing objects."; 


ShowText::usage="Option for level scheme drawing objects."; 
Offset::reusage="Option for level scheme drawing objects.";   (*System`*)
Nudge::usage="Option for level scheme drawing objects."; 
Orientation::usage="Option for level scheme drawing objects."; 
Background::reusage="Option for level scheme drawing objects.";   (*System`*)
BackgroundOpacity::usage="Option for level scheme drawing objects.";

LabL::usage="Option for level scheme drawing objects."; 
ShowLabL::usage="Option for level scheme drawing objects."; 
OffsetL::usage="Option for level scheme drawing objects."; 
NudgeL::usage="Option for level scheme drawing objects."; 
OrientationL::usage="Option for level scheme drawing objects."; 
BackgroundL::usage="Option for level scheme drawing objects."; 
BackgroundOpacityL::usage="Option for level scheme drawing objects."; 
PosnL::usage="Option for level scheme drawing objects."; 
BufferL::usage="Option for level scheme drawing objects."; 
AboveKinkL::usage="Option for level scheme drawing objects.";
SegmentL::usage="Option for level scheme drawing objects.";

LabR::usage="Option for level scheme drawing objects."; 
ShowLabR::usage="Option for level scheme drawing objects."; 
OffsetR::usage="Option for level scheme drawing objects."; 
NudgeR::usage="Option for level scheme drawing objects."; 
OrientationR::usage="Option for level scheme drawing objects."; 
BackgroundR::usage="Option for level scheme drawing objects."; 
BackgroundOpacityR::usage="Option for level scheme drawing objects."; 
PosnR::usage="Option for level scheme drawing objects."; 
BufferR::usage="Option for level scheme drawing objects."; 
AboveKinkR::usage="Option for level scheme drawing objects."; 
SegmentR::usage="Option for level scheme drawing objects.";

LabT::usage="Option for level scheme drawing objects."; 
ShowLabT::usage="Option for level scheme drawing objects."; 
OffsetT::usage="Option for level scheme drawing objects."; 
NudgeT::usage="Option for level scheme drawing objects."; 
OrientationT::usage="Option for level scheme drawing objects."; 
BackgroundT::usage="Option for level scheme drawing objects."; 
BackgroundOpacityT::usage="Option for level scheme drawing objects."; 
PosnT::usage="Option for level scheme drawing objects."; 
BufferT::usage="Option for level scheme drawing objects."; 
AboveKinkT::usage="Option for level scheme drawing objects."; 
SegmentT::usage="Option for level scheme drawing objects.";

LabB::usage="Option for level scheme drawing objects."; 
ShowLabB::usage="Option for level scheme drawing objects."; 
OffsetB::usage="Option for level scheme drawing objects."; 
NudgeB::usage="Option for level scheme drawing objects."; 
OrientationB::usage="Option for level scheme drawing objects."; 
BackgroundB::usage="Option for level scheme drawing objects."; 
BackgroundOpacityB::usage="Option for level scheme drawing objects."; 
PosnB::usage="Option for level scheme drawing objects."; 
BufferB::usage="Option for level scheme drawing objects."; 
AboveKinkB::usage="Option for level scheme drawing objects."; 
SegmentB::usage="Option for level scheme drawing objects.";

LabC::usage="Option for level scheme drawing objects."; 
ShowLabC::usage="Option for level scheme drawing objects."; 
OffsetC::usage="Option for level scheme drawing objects."; 
NudgeC::usage="Option for level scheme drawing objects."; 
OrientationC::usage="Option for level scheme drawing objects."; 
BackgroundC::usage="Option for level scheme drawing objects."; 
BackgroundOpacityC::usage="Option for level scheme drawing objects."; 
PosnC::usage="Option for level scheme drawing objects."; 
BufferC::usage="Option for level scheme drawing objects."; 
AboveKinkC::usage="Option for level scheme drawing objects."; 
SegmentC::usage="Option for level scheme drawing objects.";

LabX::usage="Option for level scheme drawing objects."; 
ShowLabX::usage="Option for level scheme drawing objects."; 
OffsetX::usage="Option for level scheme drawing objects."; 
NudgeX::usage="Option for level scheme drawing objects."; 
OrientationX::usage="Option for level scheme drawing objects."; 
BackgroundX::usage="Option for level scheme drawing objects."; 
BackgroundOpacityX::usage="Option for level scheme drawing objects."; 
PosnX::usage="Option for level scheme drawing objects."; 
BufferX::usage="Option for level scheme drawing objects."; 
AboveKinkX::usage="Option for level scheme drawing objects."; 
SegmentX::usage="Option for level scheme drawing objects.";


Ticks::reusage="Option for level scheme drawing objects."; (*System`*)
TickShowLine::usage="Option for level scheme drawing objects."; 
TickLineColor::usage="Option for level scheme drawing objects."; 
TickLineOpacity::usage="Option for level scheme drawing objects."; 
TickThickness::usage="Option for level scheme drawing objects."; 
TickFontColor::usage="Option for level scheme drawing objects."; 
TickFontOpacity::usage="Option for level scheme drawing objects."; 
TickFontFamily::usage="Option for level scheme drawing objects."; 
TickFontSize::usage="Option for level scheme drawing objects."; 
TickFontSlant::usage="Option for level scheme drawing objects."; 
TickFontTracking::usage="Option for level scheme drawing objects."; 
TickFontWeight::usage="Option for level scheme drawing objects."; 
TickBackground::usage="Option for level scheme drawing objects."; 
TickBackgroundOpacity::usage="Option for level scheme drawing objects."; 
TickNudge::usage="Option for level scheme drawing objects."; 


PanelLetterFontColor::usage="Option for level scheme drawing objects."; 
PanelLetterFontOpacity::usage="Option for level scheme drawing objects."; 
PanelLetterFontFamily::usage="Option for level scheme drawing objects."; 
PanelLetterFontSize::usage="Option for level scheme drawing objects."; 
PanelLetterFontSlant::usage="Option for level scheme drawing objects."; 
PanelLetterFontTracking::usage="Option for level scheme drawing objects."; 
PanelLetterFontWeight::usage="Option for level scheme drawing objects."; 
ShowPanelLetter::usage="Option for level scheme drawing objects."; 
PanelLetterOffset::usage="Option for level scheme drawing objects.";
PanelLetterNudge::usage="Option for level scheme drawing objects."; 
PanelLetterOrientation::usage="Option for level scheme drawing objects."; 
PanelLetterBackground::usage="Option for level scheme drawing objects.";  
PanelLetterBackgroundOpacity::usage="Option for level scheme drawing objects."; 
PanelLetterOrigin::usage="Option for level scheme drawing objects."; 


Margin::usage="Option for level scheme drawing objects."; 
EnergyLabelFunction::usage="Option for level scheme drawing objects.";  
EnergyNudge::usage="Option for level scheme drawing objects."; 
WingHeight::usage="Option for level scheme drawing objects."; 
WingRiseWidth::usage="Option for level scheme drawing objects."; 
WingTipWidth::usage="Option for level scheme drawing objects."; 
MakeWingL::usage="Option for level scheme drawing objects."; 
MakeWingR::usage="Option for level scheme drawing objects."; 
ToWing::usage="Option for level scheme drawing objects."; 
FromWing::usage="Option for level scheme drawing objects."; 
LineToFront::usage="Option for level scheme drawing objects. (UNDOCUMENTED)"; 
EndPositions::usage="Option for level scheme drawing objects."; 
ArrowType::usage="Option for level scheme drawing objects."; 
ArrowHalf::usage="Option for level scheme drawing objects. (UNDOCUMENTED)"; 
Width::usage="Option for level scheme drawing objects."; 
SquiggleWavelength::usage="Option for level scheme drawing objects."; 
SquiggleSide::usage="Option for level scheme drawing objects."; 
SquiggleBuffer::usage="Option for level scheme drawing objects."; 
PlotPoints::reusage="Option for level scheme drawing objects.";(*System`*)
TailBevel::usage="Option for level scheme drawing objects."; 
ShaftLines::usage="Option for level scheme drawing objects."; 
HeadLength::reusage="Option for level scheme drawing objects.";(*Graphics`Arrow`*)
HeadLip::usage="Option for level scheme drawing objects."; 
Kink::usage="Option for level scheme drawing objects."; 
ShowHead::usage="Option for level scheme drawing objects."; 
ShowTail::usage="Option for level scheme drawing objects."; 
HeadRecess::usage="Option for level scheme drawing objects."; 
TailRecess::usage="Option for level scheme drawing objects."; 
ConversionColor::usage="Option for level scheme drawing objects."; 
ConversionSide::usage="Option for level scheme drawing objects."; 
ConversionCoeff::usage="Option for level scheme drawing objects."; 
CallOutVector::usage="Option for level scheme drawing objects."; 
Gap::usage="Option for level scheme drawing objects."; 


Frame::reusage="Option for Scheme.";(*System`*)
FrameLabel::reusage="Option for Scheme.";(*System`*)
FrameTicks::reusage="Option for Scheme.";(*System`*)
Axes::reusage="Option for Scheme.";(*System`*)
PlotRange::reusage="Option for Scheme.";(*System`*)
ImageSize::reusage="Option for Scheme.";(*System`*)
DisplayFunction::reusage="Option for Scheme.";(*System`*)
SchemeFlags::usage="Option for Scheme.";
BlockOptions::reusage="Option for Scheme.";(*BlockOptions`*)
Information::reusage="Option for Scheme. (UNDOCUMENTED)";(*System`*)
Debug::reusage="Option for Scheme. (UNDOCUMENTED)";(*System`*)


Inverted::usage="Option value for level scheme drawing objects.";
LineArrow::usage="Option value for level scheme drawing objects.";
MultilineArrow::usage="Option value for level scheme drawing objects.";
SquiggleArrow::usage="Option value for level scheme drawing objects.";
ShapeArrow::usage="Option value for level scheme drawing objects.";
FromHead::usage="Option value for level scheme drawing objects.";
FromTail::usage="Option value for level scheme drawing objects.";
FromHeadVertical::usage="Option value for level scheme drawing objects.";
FromTailVertical::usage="Option value for level scheme drawing objects.";
FromHeadHorizontal::usage="Option value for level scheme drawing objects.";
FromTailHorizontal::usage="Option value for level scheme drawing objects.";


SetOrigin::usage="SetOrigin[x] or SetOrigin[pt] sets the origin of the user coordinate system.  SetOrigin[] clears the definition.";
SetScale::usage="SetScale[yfactor] or SetScale[{xfactor,yfactor}] sets the scaling of the user coordinate system.  SetScale[] clears the definition.";
SetRegion::usage="SetRegion[{{xc1,xc2},{yc1,yc2}},{{xr1,xr2},{yr1,yr2}}] sets the region coordinate system and clipping box.  Any existing user coordinate definitions (origin or scale) are cleared.  SetRegion[] resets the region to the full canvas.";


ConvertCoordinate::usage="ConvertCoordinate[system,[newsystem],{x,y},[D]] or ConvertCoordinate[system,[newsystem],axis,x,[D]] carries out coordinate system conversion.  The systems can be specified to be CanvasCoords, RegionCoords, UserCoords, AbsoluteCoords, or ScaledCoords, and by default conversion is to UserCoords.  The axis may be Horizontal or Vertical, for X or Y coordinate conversion.  The argument D indicates displacement (rather than coordinate) conversion.  LEGACY SYNTAX: ConvertCoordinate[system,newsystem,C|D,{x,y}] or ConvertCoordinate[system,newsystem,C|D,1|2,x].";
ConvertRange::usage="ConvertRange[system,[newsystem],axis,{x1,x2},[D]] carries out coordinate system conversion for X or Y ranges.  The arguments have similar meanings as for ConvertCoordinate. LEGACY SYNTAX: ConvertRange[system,newsystem,C|D,{x1,x2},1|2]";
ConvertRegion::usage="ConvertRegion[system,[newsystem],{{x1,x2},{y1,y2}},[D]] carries out coordinate system conversion for regions.  The arguments have similar meanings as for ConvertCoordinate. LEGACY SYNTAX: ConvertRegion[system,newsystem,C|D,{{x1,x2},{y1,y2}}]";


C::reusage="Conversion type identifier for ConvertCoordinate."; (*System`*)
D::reusage="Conversion type identifier for ConvertCoordinate."; (*System`*)
CanvasCoords::usage="Level scheme drawing coordinate system identifier.";
AbsoluteCoords::usage="Level scheme drawing coordinate system identifier.";
RegionCoords::usage="Level scheme drawing coordinate system identifier.";
ScaledCoords::usage="Level scheme drawing coordinate system identifier.";
UserCoords::usage="Level scheme drawing coordinate system identifier.";


SavePoint::usage="SavePoint[ID,{x,y}] or SavePoint[ID,{x,y},system] saves the canvas position of the given point.  If no coordinate system is specified, it is assumed {x,y} are the coordinates in the current user coordinate system.";
GetPoint::usage="GetPoint[ID] or GetPoint[ID,system] returns the position of the previously saved point, converted to the presently-defined coordinate systems.  If no coordinate system is specified, the point is given in the current user coordinates.";


Figure::usage="Figure[list] returns a drawing constructed from the objects in list.";
ExtendRange::reusage="Option for Figure."; (* LevelScheme` *)
SchemeDef::usage="SchemeDef[Flag] returns True or False depending whether or not Flag is defined in the SchemeFlags option.";
SchemeIf::usage="SchemeIf[condition,Object1,...] evaluates objects and splices them into the figure only if condition is True.";SchemeIfDef::usage="SchemeIfDef[Flag,Object1,...] evaluates objects and splices them into the figure only if Flag is defined in the SchemeFlags option.";
SchemeIfNDef::usage="SchemeIfNDef[Flag,Object1,...] evaluates objects and splices them into the figure only if Flag is *not* defined in the SchemeFlags option.";
SchemeIfElseDef::usage="SchemeIfDef[Flag,Object1,Object2] evaluates objects and splices them into the figure depending whether or not Flag is defined in the SchemeFlags option.";


Lev::usage="Lev[ID,x1,x2,Energy] is a level scheme drawing object.";
ExtensionLine::usage="ExtensionLine[ID,position1,position2] or ExtensionLine[ID,side,length] is a level scheme drawing object.";
LastLevel::usage="LastLevel is a global variable containing the ID of the most recently defined level.";
LevelEnergy::usage="LevelEnergy[ID] returns the energy value (user coordinate) specified when the given level was defined.";
Connector::usage="Connector[ID1,ID2] is a level scheme drawing object.";


Trans::usage="Trans[ID1,position1,ID2,position2] or Trans[ID1,ID2] or Trans[pt1,pt2] is a level scheme drawing object.";


SchemeLine::usage="SchemeLine[{pt1,pt2,...}] or SchemeLine[graphics] is a level scheme drawing object.";
SchemePolygon::usage="SchemePolygon[{pt1,pt2,...}] is a level scheme drawing object.";
SchemeCircle::usage="SchemeCircle[pt,radius] or SchemeCircle[pt,radius,{theta1,theta2}] is a level scheme drawing object.";
SchemeEllipse::usage="SchemeEllipse[pt,{r1,r2}] or SchemeEllipse[pt,{r1,r2},theta] or SchemeEllipse[pt,{r1,r2},theta,{theta1,theta2}] is a level scheme drawing object.";
SchemeBox::usage="SchemeBox[{{x1,x2},{y1,y2}}] or SchemeBox[pt1,pt2] is a level scheme drawing object.";
SchemeSquare::usage="SchemeSquare[pt,radius] is a level scheme drawing object.";
SchemeArrow::usage="SchemeArrow[pt1,pt2] is a level scheme drawing object.";
SchemeBracket::usage="SchemeBracket[Bottom|Top,{x1,x2},y] or SchemeBracket[Left|Right,x,{y1,y2}] is a level scheme drawing object.  Level IDs may be specified instead of coordinates, as in SchemeBracket[Bottom|Top,{ID1,ID2},y] or SchemeBracket[Left|Right,x,{ID1,ID2}] or SchemeBracket[Bottom|Top,{x1,x2},ID,EnergyNudge->...].";
SchemeLine3D::usage="SchemeLine3D[{pt1,pt2,...}] is a 3D analogue of a level scheme drawing object.";
SchemeArrow3D::usage="SchemeArrow3D[pt1,pt2] or SchemeArrow3D[pt1,pt2,headangle] is a 3D analogue of a level scheme drawing object.";


ManualLabel::usage="ManualLabel[pt,text] is a level scheme drawing object.";
ScaledLabel::usage="ScaledLabel[scaledpt,text] is a level scheme drawing object.";
BandLabel::usage="BandLabel[ID,text] or BandLabel[ID,position,text] is a level scheme drawing object.";
LevelLabel::usage="LevelLabel[ID,position,text] is a level scheme drawing object.";
ManualLabel3D::usage="ManualLabel3D[pt,text] is a 3D analogue of a level scheme drawing object.";


RawGraphics::usage="RawGraphics[graphics1,...] is a level scheme drawing object which includes Graphics, ContourGraphics, or DensityGraphics objects in the scheme.";
FigGraphics::usage="FigGraphics[{{x1,x2},{y1,y2}},graphics] or FigGraphics[{{x1,x2},{y1,y2}},image] is a level scheme drawing object which includes Mathematica-generated or imported graphics within a figure.";
RawGraphics3D::usage="RawGraphics3D[graphics1,...] is a level scheme drawing object.";
ClipToRectangle::reusage="Option for level scheme drawing objects."; (*ClipToRectangle`*)


ViewPort3D::usage="ViewPort3D[{graphics,...},{{x1,x2},{y1,y2}}] is a level scheme drawing object which includes three-dimensional graphics objects in the scheme.";
ScaledViewPort3D::usage="ScaledViewPort3D[{graphics,...},{{x1s,x2s},{y1s,y2s}}] is a level scheme drawing object which includes three-dimensional graphics objects in the scheme.";
AxisScaling::usage="Option for ViewPort3D.";
EulerRotation::usage="Option for ViewPort3D.";


SchemeAxis::usage="SchemeAxis[Bottom|Top,{x1,x2},y] or SchemeAxis[Left|Right,x,{y1,y2}] generates a freestanding axis.  SchemeAxis[{Bottom|Top,Left|Right},{{x1,x2},{y1,y2}}] generates crossed horizontal and vertical axes.  The crossing point may be specified with the option AxesOrigin.";
FigurePanel::usage="FigurePanel[{{xc1,xc2},{yc1,yc2}}] sets the region coordinate system and draws a panel frame, labels, and fill.  The panel position is specified in canvas coordinates.  FigurePanel[] produces a panel covering the full canvas.  FigurePanel[{row,column}] generates a panel of a multipanel plot.";
ScaledFigurePanel::usage="ScaledFigurePanel[{{xs1,xs2},{ys1,ys2}}] sets the region coordinate system and draws a panel frame, labels, and fill.  The panel position is specified in scaled coordinates relative to the present plotting region.";
PlotRange::reusage="Option for FigurePanel.";(*System`*)
XPlotRange::usage="Option for FigurePanel.";
YPlotRange::usage="Option for FigurePanel.";
ShowEdge::usage="Option for level scheme drawing objects.";
TickLabelMargin::usage="Option for FigurePanel.";
Multipanel::usage="Multipanel[{{xc3,xc4},{yc3,yc4}},{rows,columns}] initializes automatic multipanel plotting.  Multipanel[{rows,columns}] produces a multipanel plot covering the full canvas.";
XPlotRanges::usage="Option for Multipanel.";
YPlotRanges::usage="Option for Multipanel.";
XFrameTicks::usage="Option for automatic panel generation.";
YFrameTicks::usage="Option for automatic panel generation.";
XFrameLabels::usage="Option for automatic panel generation.";
YFrameLabels::usage="Option for automatic panel generation.";
XPanelSizes::usage="Option for automatic panel generation.";
YPanelSizes::usage="Option for automatic panel generation.";
XGapSizes::usage="Option for automatic panel generation.";
YGapSizes::usage="Option for automatic panel generation.";
XMarginSizes::usage="Option for automatic panel generation.";
YMarginSizes::usage="Option for automatic panel generation.";
PanelShift::usage="Option for Panel, only relevant when used with automatic panel generation.";
PanelAdjustments::usage="Option for Panel, only relevant when used with automatic panel generation.";
ShowTicks::usage="Option for automatic panel generation.";
ShowTickLabels::reusage="Option for automatic panel generation.";(*CustomTicks`*)
ShowTickLabelsExterior::usage="Option for automatic panel generation.";
ShowTickLabelsInterior::usage="Option for automatic panel generation.";
ShowFrameLabels::reusage="Option for automatic panel generation.";
ShowFrameLabelsExterior::usage="Option for automatic panel generation.";
ShowFrameLabelsInterior::usage="Option for automatic panel generation.";
ExteriorMask::usage="Option for automatic panel generation.";
TickLabelAutoSuppress::usage="Option for automatic panel generation.";
PanelLetterCorner::usage="Option for level scheme drawing objects.";
PanelLetterInset::usage="Option for Panel.";
PanelLetter::usage="PanelLetter[] returns the letter for the current panel of a multipanel plot.";
Order::reusage="Option for PanelLetter.";(*System`*)
First::reusage="Option for PanelLetter.";(*System`*)
Format::reusage="Option for PanelLetter.";
TickOptions::usage="Option for Panel.";
(*System`*)


AttachIndex::usage="(UNDOCUMENTED)";
ScaleFactor::reusage="Option for AttachIndex."; (*Graphics`Common`GraphicsCommon`ScaleFactor`*)
Range::reusage="Option for AttachIndex."; (*System`*)
DataSetQ::usage="DataSetQ[list] returns True only if list is a valid LevelScheme data set.";


SelectData::usage="SelectData[test] is a data filter for DataPlot.";
ExcludeData::usage="ExcludeData[test] is a data filter for DataPlot.";
TransformData::usage="TransformData[f] is a data filter for DataPlot.";
DownsampleData::usage="DownsampleData[f] is a data filter for DataPlot.";
XRange::usage="XRange[x1,x2] is a logical test which acts on a data point.";
YRange::usage="YRange[y1,y2] is a logical test which acts on a data point.";
InPlotRegion::usage="InPlotRegion is a data filter for DataPlot.";
LimitX::usage="LimitX[x1,x2] is a data filter for DataPlot.";
LimitY::usage="LimitY[y1,y2] is a data filter for DataPlot.";


DataPlot::usage="DataPlot[data] produces customizable data plots.";
DataSequence::usage="DataSequence[{data1,data2,...}] is a structure to contain multiple data sets for DataPlot.";
DataTag::usage="DataTag[ID] sets the name of the following data set. (DEPRECATED)";
DefineDataStyle::usage="DefineDataStyle[ID] saves the current plotting options.  A DataStyle may be specified as a starting point, and options may be further overridden by specifying DataLine->{...} or DataSymbol->{...}.  All inherited values are frozen in.";
UseDataOptions::usage="UseDataOptions[] sets the data plotting style options as specified in any options given to UseDataOptions.   A DataStyle may be specified as a starting point, and options may be further overridden by specifying DataLine->{...} or DataSymbol->{...}.  All inherited values are frozen in.";
DataLabel::usage="DataLabel[ID] attaches text to a data plot.";
DataLegend::usage="DataLegend[{xs,ys},{{dataset1,label1},...}] generates a data plot legend.";
DataSet::usage="Symbol the option values for which control the behavior of DataPlot.";
DataValues::usage="Symbol the option values for which control the behavior of DataPlot.";
DataLine::usage="Symbol the option values for which control the behavior of DataPlot.";
DataSymbol::usage="Symbol the option values for which control the behavior of DataPlot.";
DataStyle::usage="Option for level scheme drawing objects."; 
ShowData::usage="Option for level scheme drawing objects."; 
LineShape::reusage="Option for level scheme drawing objects."; 
IgnoreMissingValues::usage="Option for level scheme drawing objects."; 
DataColumns::usage="Option for level scheme drawing objects."; 
DataFilters::usage="Option for level scheme drawing objects."; 
SymbolShape::reusage="Option for level scheme drawing objects."; (*Graphics`MultipleListPlot`*)
ErrorValue::usage="Value type for data points.";
SymbolSize::usage="Option for level scheme drawing objects."; 
DataLineShape::usage="Symbol used for specification of LevelScheme plot line shape.  DataLineShape[shape,plotpoints] should act on a list of points, transforming it to another list of points.";DataSymbolShape::usage="Symbol used for specification of LevelScheme plot symbol shape.  DataSymbolShape[shape,plotpoints] should return a list of points, spanning approximately the unit circle.";


AutoLevelInit::usage="AutoLevelInit[x0,space,bigspace] initializes automatic placement of transitions in a decay scheme.";
AutoLevel::usage="AutoLevel[ID1] selects the starting level for automatic placement of transitions in a decay scheme.";
AutoTrans::usage="AutoTrans[ID2] generates a transition to the specified ending level for automatic placement of transitions in a decay scheme.";


GrabPoints::usage="GrabPoints[graphics] returns the list of points from the first Line found by ExtractCurves[graphics].";
ExtractCurves::usage="ExtractCurves[graphics] extracts a list of Line objects from a Graphics, ContourGraphics, or Graphics3D object.";
Graphics3DQ::usage="Graphics3DQ[x] returns True if x is a Graphics3D object, with first argument of head list and optional second argument a flat list of options.";
CombineGraphics3D::usage="CombineGraphics3D[{graphics1,...}] returns a Graphics3D object with a primative list combining the primative lists of graphics1, ..., each as separate sublists (so style directives in one sublist do not affect the following sublists).";
ExtendRange::usage="ExtendRange[{x1,x2},{fx1,fx2}] or ExtendRange[{x1,x2},fx] extends an interval by the specified fractional amounts in each direction.";
ExtendRegion::usage="ExtendRegion[{{x1,x2},{y1,y2}},{{fx1,fx2},{fy1,fy2}}] or ExtendRegion[{{x1,x2},{y1,y2}},{fx,fy}] or ExtendRegion[{{x1,x2},{y1,y2}},f] extends a plot region by the specified fractional amounts in each direction.";
ExtendRegionAspectRatio::usage="ExtendRegion[{{x1,x2},{y1,y2}},a] extends a region to have the indicated aspect ratio.";
RegionCorners::usage="RegionCorners[{{x1,x2},{y1,y2}}] returns the corner points of the region, clockwise from bottom left, as {{x1,y1},...}.";
Polar::usage="Polar[{r,phi}] returns the Cartesian form of these polar coordinates. (UNDOCUMENTED)";
Cylindrical::usage="Cylindrical[{r,phi,z}] returns the Cartesian form of these cylindrical coordinates. (UNDOCUMENTED)";
Spherical::usage="Spherical[{r,theta,phi}] returns the Cartesian form of these spherical coordinates (where theta is the polar angle and phi the azimuthal angle). (UNDOCUMENTED)";
VectorLength::usage="(UNDOCUMENTED)";
VectorArcTan::usage="(UNDOCUMENTED)";
SegmentLength::usage="(UNDOCUMENTED)";
SegmentArcTan::usage="(UNDOCUMENTED)";


FigRealizeOptions::usage="FigRealizeOptions[object,opts...] realizes inherited and conditional options under the LevelScheme option system.";
SchemeGraphics::usage="Graphics container for LevelScheme objects.";LineStyle::usage="LineStyle[] returns a list of line style directives specified following the LevelScheme option system.";
FillStyle::usage="FillStyle[] returns a list of fill style directives specified following the LevelScheme option system.";
BlockSchemeOptions::usage="BlockSchemeOptions[expr] evaluates expr with BlockOptions on all LevelScheme object options. (UNDOCUMENTED)";
LevelScheme::usage="Evaluating LevelScheme[] reloads the LevelScheme package. (UNDOCUMENTED)";
MultipanelSettings::usage="MultipanelSettings[] prints the current Multipanel plotting settings. (UNDOCUMENTED)";
PackageVersions::usage="Evaluating PackageVersions[] displays package version information for all loaded packages. (UNDOCUMENTED)";
LevelSchemeLogo::usage="LevelSchemeLogo contains the graphics for the the level scheme logo. (UNDOCUMENTED)";


ExtensionLineL::deprecated="ExtensionLineL (last used in LevelScheme 2.0) has been absorbed into ExtensionLine.";
ExtensionLineR::deprecated="ExtensionLineR (last used in LevelScheme 2.0) has been absorbed into ExtensionLine.";
TransArrow::deprecated="TransArrow (last used in LevelScheme 2.0) has been absorbed into Trans.";
RegionLabel::deprecated="RegionLabel (last used in LevelScheme 2.0) has been replaced with ScaledLabel.";
AnnotateL::deprecated="AnnotateL (last used in LevelScheme 2.0) has been replaced with LevelLabel.";
AnnotateR::deprecated="AnnotateR (last used in LevelScheme 2.0) has been replaced with LevelLabel.";
SchemeAxisB::deprecated="SchemeAxisB (last used in LevelScheme 2.0) has been replaced with SchemeAxis.";
SchemeAxisL::deprecated="SchemeAxisL (last used in LevelScheme 2.0) has been replaced with SchemeAxis.";
SchemeAxisT::deprecated="SchemeAxisT (last used in LevelScheme 2.0) has been replaced with SchemeAxis.";
SchemeAxisR::deprecated="SchemeAxisR (last used in LevelScheme 2.0) has been replaced with SchemeAxis.";
AutoInit::deprecated="AutoInit (last used in LevelScheme 2.0) has been renamed AutoLevelInit.";
AutoPanelInit::replaced="AutoPanelInit (last used in LevelScheme 2.0) has been replaced with Multipanel.";
AutoPanel::replaced="AutoPanel (last used in LevelScheme 2.0) has been replaced with Panel.  Use SetRegion[] to turn off multipanel plotting.";
SetSchemeOrigin::deprecated="SetSchemeOrigin (last used in LevelScheme 2.0) has been replaced with SetOrigin.";
SetSchemeScale::deprecated="SetSchemeScale (last used in LevelScheme 2.0) has been replaced with SetScale.";
SetSchemeRegion::deprecated="SetSchemeRegion (last used in LevelScheme 2.0) has been replaced with SetRegion.";
ResetCoordinates::deprecated="ResetCoordinates (last used in LevelScheme 3.21) has been absorbed into SetRegion.";
SchemePoints::deprecated="SchemePoints (last used in LevelScheme 3.21+ development version) has been absorbed into DataPlot.";
Scheme::deprecated="Scheme (last used in LevelScheme 3.21) has been replaced with Figure.";


LevelScheme::abovekinkx="The options AboveKinkL, AboveKinkR, and AboveKinkC (last used in LevelScheme 3.21) are no longer supported.  Please use SegmentL, SegmentR, and SegmentC instead.";


General::lsargs="Missing or unexpected arguments in level scheme object `1`.";
General::lsargsnull="One of the arguments in `1` is Null.  Check for extra commas among the arguments.";LevelScheme::notinscheme="Level scheme objects cannot be used outside of the function Scheme.  (If you are trying to save a list of level scheme objects for later use in a scheme, or to write a function which uses level scheme objects, use the SetDelayed symbol \":=\" for the assignment.)";
LevelScheme::notreentrant="Scheme is not reentrant.  It cannot be called within the object list given to Scheme.";
LevelScheme::badparam="Option `1` has invalid value `2`.";
LevelScheme::badvalue="An invalid value `2` has been encountered for `1`.";
LevelScheme::badlevel="A reference to an unrecognized level ID `1` has been encountered.";
LevelScheme::badpoint="A reference to an unrecognized point ID `1` has been encountered.";
LevelScheme::baddataset="A reference to an unrecognized dataset ID `1` has been encountered.";
SetScale::nonpositive="User axis scale setting `1` is not positive.";
SetRegion::nonpositive="User coordinate region setting `1` does not consist of positive intervals.";
Lev::energystr="A string `2` has been specified as the level energy for a level (object identifier `1`), but this string cannot be converted to a number.";
RawGraphics::empty="Empty graphics (Graphics[options___]) discarded.";
RawGraphics::multiarg="Graphics with extra argument (Graphics[_,nonoption,options___]) discarded.";
RawGraphics::badpoint="Encountered point coordinates (`1`) not a numerical pair or a valid Mathematica Scaled or Offset coordinate.";
ViewPort3D::prange="PlotRange must be given explicitly as numerical values when option AxisScaling is used.";
FigurePanel::badij="A bad {row,column} index pair `1` has been specified for FigurePanel.";
Figure::prange="No value specified for option PlotRange.  Assuming default value {{0,1},{0,1}}.";
Figure::freegraphics="A Mathematica graphics object was encountered among the objects in the list you gave to Figure.  Did you wish the graphics to be displayed as part of the figure?  If so, enclose the graphics in RawGraphics (see LevelScheme user guide).  Otherwise Mathematica graphics objects (such as the output of plotting functions) are simply discarded by Scheme.";
Figure::timesgraphics="The list of objects you gave to Figure appears to include a graphics object \"multiplied\" by something else.  Did you accidentally omit the comma separating two items in the list?";
Trans::twoautos="You cannot specify both initial and final horizontal positions as Automatic.";
General::args="Missing or unexpected arguments in `1`.  (Check for missing or extra commas among the arguments.)";
General::kinks="Kinks have been specified for an arrow type which does not support them.";
General::nullsegment="An arrow cannot contain a line segment of zero length (canvas coordinates `1`).";
General::fromvert="Position specified as FromTailVertical or FromHeadVertical on horizontal line segment.";
General::fromhoriz="Position specified as FromTailHorizontal or FromHeadHorizontal on vertical line segment.";
General::horizbevel="Cannot bevel tail of horizontal arrow.  (Set option TailBevel->False.)";
General::conversionlip="For conversion-electron arrows, it is recommended that HeadLip be set to 0, yielding a cornerless arrowhead.  Otherwise, a misleading plot is obtained, since the corner of the arrowhead is still shaded even for vanishing conversion coefficient.";
LaTeXTableEntryValue::notnumeric="LaTeX-style table entry `1` converts to `2`, which is not numeric.";
SchemeSquare::badr="Unrecognized radius specification format `1`.";SchemeCircle::badr="Unrecognized radius specification format `1`.";
Multipanel::oldsyntax="Old syntax (LevelScheme 2.0) used for Multipanel.  Assuming value None for tick lists.";
Multipanel::ambigticks="Ambiguous whether `1` specifies the tick values for a single axis, to be repeated, or several axes.";
Multipanel::num="Incorrect number of `1` given.";
Multipanel::rule="Rules for `1` yield invalid value for panel `2`.";
Multipanel::autosizes="Cannot generate `1` automatically if any of `2` are Automatic.";
FigurePanel::undefined="FigurePanel[{row,column}] called when no multipanel plot defined.";
PanelLetter::nopanel="Cannot generate panel letter since not in multipanel plot.";
GrabPoints::noline="No line found in graphics.";
GrabPoints::manylines="More than one line found in graphics.  Only using first.";
DataSet::badcolumn="Data column number list `1` contains entry greater than maximum column in given data.";
DataPlot::baddata="Invalid data set (`1`) encountered in DataPlot.";
LimitX::badvalue="Nonnumerical x value in data point (`1`).";
LimitY::badvalue="Nonnumerical y value in data point (`1`).";
DataSymbol::badsymbol="Symbol shape `1` unrecognized or improperly defined.  New symbols can be defined using DataSymbolShape.";


Begin["`Private`"];
$PrivateContext=$Context;


LegacyFilterOptions[f_Symbol,Opts___?OptionQ]:=Sequence@@FilterRules[{Opts},Options[f]];
LegacyRotate2D[{x_,y_},phi_,{x0_,y0_}]:=RotationTransform[-phi,{x0,y0}][{x,y}];
LegacyRotate2D[{x_,y_},phi_]:=LegacyRotate2D[{x,y},phi,{0,0}];
RotationMatrix3D[phi_,theta_,psi_]:=RotationMatrix[Pi-psi,{0,0,1}].RotationMatrix[theta,{1,0,0}].RotationMatrix[Pi-phi,{0,0,1}];
LegacyRegularPolygon[n_, rad_:1, ctr_:{0,0},tilt_:0, k_:1]:=Line[
Table[ctr+rad{Cos[t+tilt],Sin[t+tilt]}, {t, 0, 2Pi, 2Pi/n}][[NestList[Mod[#+k,n,1]&,1,n]]]
] ; 


Needs["LevelScheme`LegacyTransformGraphics`"]; 
Needs["LevelScheme`BlockUnprotect`" ];


LevelSchemeLogo=Graphics[{GrayLevel[0], Opacity[1], AbsoluteThickness[2], AbsoluteDashing[{}], 
  {Line[{{0.1, 200.}, {0.9, 200.}}]}, GrayLevel[0], Opacity[1], AbsoluteThickness[2], 
  AbsoluteDashing[{}], {Line[{{0.1, 116.93046875}, {0.1536723484848485, 116.93046875}, 
     {0.2610170454545455, 100.}, {0.7389829545454545, 100.}, {0.8463276515151515, 116.93046875}, 
     {0.9, 116.93046875}}]}, GrayLevel[0], Opacity[1], AbsoluteThickness[2], AbsoluteDashing[{}], 
  {Line[{{0.1, 0.}, {0.9, 0.}}]}, GrayLevel[0.5], Opacity[1], 
  Polygon[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, {0.6828827683115883, 
    106.35880620986916}, {0.675461586050597, 105.04604015402995}, {0.73, 100.}, 
    {0.7595683183418321, 119.92405545354092}, {0.7521471360808408, 118.61128939770171}, 
    {0.6707584254785426, 200.}}], GrayLevel[0], Opacity[1], AbsoluteThickness[1], 
  AbsoluteDashing[{}], {Line[{{0.6300000000000001, 200.}, {0.5892415745214576, 200.}, 
     {0.6828827683115883, 106.35880620986916}, {0.675461586050597, 105.04604015402995}, 
     {0.73, 100.}, {0.7595683183418321, 119.92405545354092}, {0.7521471360808408, 
      118.61128939770171}, {0.6707584254785426, 200.}, {0.6300000000000001, 200.}}]}, 
  GrayLevel[0.5], Opacity[1], Polygon[{{0.2700000000000001, 100.}, {0.22924157452145752, 100.}, 
    {0.3228827683115884, 6.358806209869151}, {0.3154615860505971, 5.046040154029939}, 
    {0.37000000000000005, 0.}, {0.3995683183418322, 19.924055453540902}, {0.39214713608084084, 
    18.61128939770171}, {0.3107584254785426, 100.}}], GrayLevel[0], Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.2700000000000001, 100.}, {0.22924157452145752, 100.}, 
     {0.3228827683115884, 6.358806209869151}, {0.3154615860505971, 5.046040154029939}, 
     {0.37000000000000005, 0.}, {0.3995683183418322, 19.924055453540902}, 
     {0.39214713608084084, 18.61128939770171}, {0.3107584254785426, 100.}, 
     {0.2700000000000001, 100.}}]}, GrayLevel[0], Opacity[1], AbsoluteThickness[1], 
  AbsoluteDashing[{}], {Line[{{0.501, 20.}, {0.529, 20.}}]}, GrayLevel[0], Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], {Line[{{0.531, 21.3}, {0.5589999999999999, 21.3}}]}, 
  GrayLevel[0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 24.333333333333336}, {0.589, 24.333333333333336}}]}, GrayLevel[0], 
  Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], {Line[{{0.591, 29.1}, {0.619, 29.1}}]}, 
  GrayLevel[0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.621, 35.6}, {0.649, 35.6}}]}, GrayLevel[0], Opacity[1], AbsoluteThickness[1], 
  AbsoluteDashing[{}], {Line[{{0.651, 43.833333333333336}, {0.679, 43.833333333333336}}]}, 
  GrayLevel[0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.681, 53.8}, {0.709, 53.8}}]}, GrayLevel[0], Opacity[1], AbsoluteThickness[1], 
  AbsoluteDashing[{}], {Line[{{0.711, 65.5}, {0.739, 65.5}}]}, GrayLevel[0], Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.741, 78.93333333333334}, {0.769, 78.93333333333334}}]}, RGBColor[1, 0, 0], Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], {Line[{{0.501, 33.}, {0.529, 33.}}]}, 
  RGBColor[1, 0, 0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.531, 34.3}, {0.5589999999999999, 34.3}}]}, RGBColor[1, 0, 0], Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 37.333333333333336}, {0.589, 37.333333333333336}}]}, 
  RGBColor[1, 0, 0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.591, 42.099999999999994}, {0.619, 42.099999999999994}}]}, RGBColor[1, 0, 0], 
  Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.621, 48.599999999999994}, {0.649, 48.599999999999994}}]}, RGBColor[1, 0, 0], 
  Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.651, 56.833333333333336}, {0.679, 56.833333333333336}}]}, RGBColor[1, 0, 0], 
  Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], {Line[{{0.681, 66.8}, {0.709, 66.8}}]}, 
  RGBColor[1, 0, 0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.711, 78.5}, {0.739, 78.5}}]}, Hue[0.4739282735611543, 0.7, 1], Opacity[1], 
  AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.501, 47.761071567264665}, {0.529, 47.761071567264665}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.531, 49.24022665797266}, {0.5589999999999999, 49.24022665797266}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 52.691588536291334}, {0.589, 52.691588536291334}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.591, 58.115157202220665}, {0.619, 58.115157202220665}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.621, 65.51093265576067}, {0.649, 65.51093265576067}}]}, 
  Hue[0.4739282735611543, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.651, 74.87891489691134}, {0.679, 74.87891489691134}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.501, 56.07894755622853}, {0.529, 56.07894755622853}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.531, 57.38554745213195}, {0.5589999999999999, 57.38554745213195}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 60.434280542573276}, {0.589, 60.434280542573276}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.591, 65.22514682755249}, {0.619, 65.22514682755249}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.621, 71.75814630706962}, {0.649, 71.75814630706962}}]}, 
  Hue[0.022803460025882117, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.651, 80.03327898112465}, {0.679, 80.03327898112465}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.501, 60.981197953135855}, {0.529, 60.981197953135855}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.531, 62.04756255970392}, {0.5589999999999999, 62.04756255970392}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.5609999999999999, 64.53574664169608}, {0.589, 64.53574664169608}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.591, 68.44575019911233}, {0.619, 68.44575019911233}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.621, 73.77757323195266}, {0.649, 73.77757323195266}}]}, 
  Hue[0.7490704830227459, 0.7, 1], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}], 
  {Line[{{0.651, 80.53121574021708}, {0.679, 80.53121574021708}}]}, Text[DisplayForm[
    \(\*"LevelScheme"\)
    ], {0.1, 200.}, {-1, -0.75}, {1, 0}, BaseStyle -> {FontFamily -> "Times", FontSize -> 10, 
     FontSlant -> "Plain", FontTracking -> "Plain", FontWeight -> "Plain", 
     FontColor -> GrayLevel[0], FontOpacity -> 1, ShowAutoStyles -> False}]}, 
 {PlotRange -> {{-0.0001, 1.0001}, {-50.0325, 275.0325}}, ImageSize -> {93.17647058823529, 72.}, 
  AspectRatio -> 0.7727272727272727, Frame -> False, 
  FrameStyle -> Directive[{GrayLevel[0], Opacity[1], AbsoluteThickness[1], AbsoluteDashing[{}]}], 
  FrameLabel -> {None, None, None, None}, FrameTicks -> None, Axes -> False, Ticks -> None, 
  TextStyle -> {FontFamily -> "Times", FontSize -> 12, FontSlant -> "Plain", 
    FontTracking -> "Plain", FontWeight -> "Plain", FontColor -> GrayLevel[0], FontOpacity -> 1, 
    ShowAutoStyles -> False}, Background -> RGBColor[0.889996, 0.509995, 0.089999], 
  DisplayFunction -> Identity}];


SplashContents=Row[
{
GridBox[
{
{"LevelScheme scientific figure preparation system"},
{"M. A. Caprio, Department of Physics, University of Notre Dame"},
{Row[{"Comput. Phys. Commun. ",textbf["171"],", 107 (2005)"}]},
{"Version "<>LevelSchemeRevisionString},
{
RowBox[{
ButtonBox[
StyleBox["View color palette",FontFamily->"Times"],
ButtonNote->"Named color palette",ButtonFunction->(NamedColorPalette[]&),Active->True,ButtonFrame->"DialogBox",ButtonExpandable->False,Evaluator->Automatic
],
MakeButtonForURL[StyleBox["Visit home page",FontFamily->"Times"],LevelSchemeHomePageURL,ButtonFrame->"DialogBox",ButtonExpandable->False]
}]
}
},
ColumnAlignments->Left
]//DisplayForm,
"  ",
LevelSchemeLogo
}
];


If[
LevelScheme`Config`Splash,
Print[
Framed[SplashContents,Background->LightGray,FrameMargins->10,FrameStyle->None]
]
]


$SchemeBackgroundLayer=0;
$SchemeDrawingLayer=1;
$SchemeBlankingLayer=2;
$SchemeTextLayer=3;


$InScheme=False;


OptionSymbols={
(* from LevelScheme *)
SchemeObject,Lev,ExtensionLine,Connector,Trans,ManualLabel,ScaledLabel,BandLabel,LevelLabel,SchemeBracket,
SchemeLine,SchemePoints,SchemePolygon,SchemeBox,SchemeSquare,SchemeCircle,SchemeEllipse,SchemeArrow,
RawGraphics,FigGraphics,ViewPort3D,ScaledViewPort3D,
FigurePanel,ScaledFigurePanel,Multipanel,SchemeAxis,PanelLetter,
LineStyle,FillStyle,
AttachIndex,
DataPlot,DataTag,DefineDataStyle,UseDataOptions,DataLabel,DataSet,DataValues,DataLine,DataSymbol,DataLegend,
(* external *)
LinTicks,LogTicks
};
OptionSymbols3D={
ManualLabel3D,SchemeLine3D,SchemeArrow3D,RawGraphics3D
};


BasicOpts={Show,Tooltip,Color,Opacity,Layer,ClipToRectangle};
ObjectOpts={Tag,ConditionalOptions};
OutlineOpts={ShowLine,LineColor,LineOpacity,Thickness,CapForm,Dashing,DashingGap,DashingCorrection};
TickOutlineOpts={TickShowLine->Automatic,TickLineColor->Automatic,TickLineOpacity->Automatic,TickThickness->Automatic};
FillOpts={ShowFill,FillColor,FillOpacity};
BackgroundOpts={Background->None,BackgroundOpacity->1};
ArrowheadOpts={HeadLength->6,HeadLip->3};
TextOpts={FontFamily,FontSize,FontWeight,FontSlant,FontTracking,FontColor,FontOpacity};
TickTextOpts={
TickFontFamily->Automatic,TickFontSize->Automatic,TickFontWeight->Automatic,TickFontSlant->Automatic,TickFontTracking->Automatic,TickFontColor->Automatic,TickFontOpacity->Automatic,TickBackground->Automatic};
PanelLetterTextOpts={PanelLetterFontFamily->Automatic,PanelLetterFontSize->Automatic,PanelLetterFontWeight->Automatic,PanelLetterFontSlant->Automatic,PanelLetterFontTracking->Automatic,PanelLetterFontColor->Automatic,PanelLetterFontOpacity->Automatic};
PanelLetterOpts={ShowPanelLetter->True,PanelLetterOffset->Automatic,PanelLetterCorner->{-1,1},PanelLetterNudge->None,PanelLetterOrientation->Automatic,PanelLetterBackground->None};
LabLOpts={LabL->None,ShowLabL->True,OffsetL->Automatic,NudgeL->None,OrientationL->Automatic,BackgroundL->None};
LabROpts={LabR->None,ShowLabR->True,OffsetR->Automatic,NudgeR->None,OrientationR->Automatic,BackgroundR->None};
LabTOpts={LabT->None,ShowLabT->True,OffsetT->Automatic,NudgeT->None,OrientationT->Automatic,BackgroundT->None};
LabBOpts={LabB->None,ShowLabB->True,OffsetB->Automatic,NudgeB->None,OrientationB->Automatic,BackgroundB->None};
LabCOpts={LabC->None,ShowLabC->True,OffsetC->Automatic,NudgeC->None,OrientationC->Automatic,BackgroundC->None};
LabXOpts={LabX->None,ShowLabX->True,OffsetX->Automatic,NudgeX->None,OrientationX->Automatic,BackgroundX->None};
LabOpts={ShowText->True,Offset->Automatic,Nudge->None,Orientation->Automatic,Background->None};


InheritanceMode={TrapUninheritableOptions->True,TrapUnknownOptions->True};


$DefaultFontFamily="Times";


DefineOptions[SchemeObject,
{
(* Overall color *)
Color->Black,
Opacity->1,

(* Outline *)
ShowLine->True, 
LineColor->Automatic,LineOpacity->Automatic,Thickness->1,CapForm->None,Dashing->None,DashingGap->Automatic,DashingCorrection->If[$VersionNumber>=7.0,False,True],

(* Fill *)
ShowFill->True, FillColor->Automatic,FillOpacity->Automatic,

(* Text *)
FontFamily->$DefaultFontFamily,FontSize->12,FontWeight->"Plain",FontSlant->"Plain",FontTracking ->"Plain",FontColor->Automatic,
FontOpacity->Automatic,

(* General rendering *)
Show->True,
Tooltip->None,
Layer->Automatic,
ClipToRectangle->True,

(* Object management *)
Tag->None,
ConditionalOptions->{}
},
InheritanceMode];


DefineOptions[Lev,{SchemeObject,Join[BasicOpts,ObjectOpts,OutlineOpts,TextOpts]},
{
(* Line geometry margin *)
Margin->0.1,
EnergyNudge->0,

(* Label control *)
LabLOpts,LabROpts,LabTOpts,LabBOpts,LabCOpts,
EnergyLabelFunction->Automatic,
DecimalDigits->Automatic,

(* Gull wings *)
WingHeight->0,
WingRiseWidth->10,
WingTipWidth->30,
MakeWingL->True,
MakeWingR->True,

(* Layer override*)
LineToFront->False

},
InheritanceMode];


DefineOptions[ExtensionLine,{SchemeObject,Join[BasicOpts,OutlineOpts]},
{
(* Extension line endpoint coordinates *)
ToWing->True
},
InheritanceMode];


DefineOptions[Connector,{SchemeObject,Join[BasicOpts,OutlineOpts]},{},InheritanceMode];


DefineOptions[Trans,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts,TextOpts]},
{
(* Arrow shape properties *)
ArrowType->LineArrow,
ArrowHalf->All,
Width ->5,
TailBevel->True,
ShaftLines->2,
SquiggleBuffer->2,
SquiggleWavelength->10,
SquiggleSide->Right,
PlotPoints->32,
ArrowheadOpts,
Kink->None,
ShowTail->False,ShowHead->True,  
TailRecess->0,HeadRecess->0,  

(* Conversion fill properties *)
ConversionColor->White,
ConversionSide->Right,
ConversionCoeff->None,

(* Label control *)
LabLOpts,PosnL->Automatic,BufferL->Automatic,AboveKinkL->False,SegmentL->Automatic,
LabROpts,PosnR->Automatic,BufferR->Automatic,AboveKinkR->False,SegmentR->Automatic,
LabCOpts,PosnC->Automatic,AboveKinkC->False,SegmentC->Automatic,
LabTOpts,PosnT->Automatic,

(* Endpoint coordinates when between levels *)
EndPositions->{0.5,0.5},
FromWing->False,ToWing->False
},
InheritanceMode];


DefineOptions[ManualLabel,{SchemeObject,Join[BasicOpts,TextOpts]},
{LabOpts
(* callout line control -- TO IMPLEMENT w/ Recess *)
(* CallOutVector->None *)
},
InheritanceMode];
DefineOptions[ScaledLabel,{SchemeObject,Join[BasicOpts,TextOpts]},{LabOpts},InheritanceMode];
DefineOptions[BandLabel,{SchemeObject,Join[BasicOpts,TextOpts]},{LabOpts},InheritanceMode];
DefineOptions[LevelLabel,{SchemeObject,Join[BasicOpts,OutlineOpts,TextOpts]},
{
LabOpts,
(* Callout line and horizontal gap control *)
CallOutVector->None,Gap->0 
},
InheritanceMode];


DefineOptions[
ManualLabel3D,
{SchemeObject,Join[BasicOpts,TextOpts]},
{
(* Label control *)
Offset->Automatic,(*Nudge->0,*)Orientation->Automatic,ShowText->True,Background->None,

(* 3D supplement *)
GeometricTransformation->IdentityMatrix[3]
},
InheritanceMode
];


DefineOptions[SchemeLine,{SchemeObject,Join[BasicOpts,OutlineOpts,TextOpts]},
{
(* Arrow shape properties *)
ArrowheadOpts,
ShowTail->False,ShowHead->False,  

(* Label control *)
LabLOpts,PosnL->Automatic,(*BufferL->Automatic,*)
LabROpts,PosnR->Automatic,(*BufferR->Automatic,*)
LabTOpts,PosnT->Automatic,BufferT->Automatic,
LabBOpts,PosnB->Automatic,BufferB->Automatic,
LabCOpts,PosnC->Automatic,

(* graphics curve extraction *)
Join->False
},
InheritanceMode
];
DefineOptions[SchemePoints,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts]},{SymbolSize->2.5,SymbolShape->"Circle",PlotPoints->16},InheritanceMode];DefineOptions[SchemePolygon,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts]},
{
(* Outline control *)
ShowEdge->Automatic
},
InheritanceMode];
DefineOptions[SchemeCircle,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts,TextOpts]},
{
(* Arrow shape properties *)
ArrowheadOpts,
ShowTail->False,ShowHead->False,  

(* Label control *)
LabLOpts,LabROpts,LabTOpts,LabBOpts,LabCOpts,LabXOpts,BufferX->Automatic,PosnX->Automatic
},
InheritanceMode];
DefineOptions[SchemeEllipse,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts,TextOpts]},
{
(* Plotting control *)
PlotPoints->90,

(* Arrow shape properties *)
ArrowheadOpts,
ShowTail->False,ShowHead->False,  

(* Label control *)
LabLOpts,LabROpts,LabTOpts,LabBOpts,LabCOpts,LabXOpts,BufferX->Automatic,PosnX->Automatic
},
InheritanceMode];
DefineOptions[SchemeBox,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts,TextOpts]},
{
(* Label control *)
LabLOpts,LabROpts,LabTOpts,LabBOpts,LabCOpts
},
InheritanceMode];
DefineOptions[SchemeSquare,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts,TextOpts]},
{
(* Label control *)
LabLOpts,LabROpts,LabTOpts,LabBOpts,LabCOpts
},
InheritanceMode];
DefineOptions[SchemeArrow,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts,TextOpts]},
{
(* Arrow shape properties -- default for TailBevel differs from Trans *)
ArrowType->LineArrow,
ArrowHalf->All,
Width ->5,
TailBevel->False,
ShaftLines->2,
SquiggleBuffer->2,
SquiggleWavelength->10,
SquiggleSide->Right,
PlotPoints->32,
ArrowheadOpts,
Kink->None,
ShowTail->False,ShowHead->True,  
TailRecess->0,HeadRecess->0,  

(* Conversion fill properties *)
ConversionColor->White,
ConversionSide->Right,
ConversionCoeff->None,

(* Label control *)
LabLOpts,PosnL->Automatic,BufferL->Automatic,AboveKinkL->False,SegmentL->Automatic,
LabROpts,PosnR->Automatic,BufferR->Automatic,AboveKinkR->False,SegmentR->Automatic,
LabCOpts,PosnC->Automatic,AboveKinkC->False,SegmentC->Automatic,
LabTOpts,PosnT->Automatic
},
InheritanceMode];
DefineOptions[SchemeBracket,
{SchemeObject,Join[BasicOpts,OutlineOpts,TextOpts]},
{

(* Geometry *)
EnergyNudge->0,

(* Arrowhead control *)
ArrowheadOpts,

(* Label control *)
LabBOpts,PosnB->Automatic,BufferB->Automatic,
LabLOpts,PosnL->Automatic,BufferL->Automatic,
LabTOpts,PosnT->Automatic,BufferT->Automatic,
LabROpts,PosnR->Automatic,BufferR->Automatic
},
InheritanceMode];
DefineOptions[SchemeLine3D,{SchemeObject,Join[{Color,Opacity,Show},OutlineOpts]},
{
(* 3D supplement *)
GeometricTransformation->IdentityMatrix[3]
},
InheritanceMode];
DefineOptions[SchemeArrow3D,{SchemeObject,Join[{Color,Opacity,Show},OutlineOpts,TextOpts]},
{
(* Arrow shape properties *)
ArrowType->LineArrow,
HeadLength->0.1,
HeadLip->0.1,
ShowTail->False,ShowHead->True ,

(* Label control *)
LabCOpts,PosnC->Automatic,

(* 3D supplement *)
GeometricTransformation->IdentityMatrix[3]
},
InheritanceMode];



DefineOptions[RawGraphics,{SchemeObject,{Color,Opacity,Thickness,CapForm,Dashing,DashingGap,DashingCorrection,Show,Layer,ClipToRectangle}},{

(* UNDOCUMENTED *)
Debug->False

},
InheritanceMode];
DefineOptions[FigGraphics,{SchemeObject,{Color,Opacity,Thickness,CapForm,Dashing,DashingGap,DashingCorrection,Show,Layer,ClipToRectangle}},{

(* UNDOCUMENTED *)
Debug->False

},
InheritanceMode];
DefineOptions[RawGraphics3D,{SchemeObject,{Color,Opacity,Thickness,CapForm,Dashing,DashingGap,DashingCorrection,Show}},{

(* 3D supplement *)
GeometricTransformation->IdentityMatrix[3],

(* UNDOCUMENTED *)
Debug->False

},
InheritanceMode];
DefineOptions[ViewPort3D,{SchemeObject,{Show,Layer}},{

(* Fill control -- differs from Color/FillColor and ShowFill convention of other objects *)
BackgroundOpts,

(* Option control *)
BlockOptions->{},

(* 3D display options *)
EulerRotation->None,
AxisScaling->Automatic,
Complement[
Options[Graphics3D],Cases[Options[Graphics3D],x:(Background->_)]
],

(* UNDOCUMENTED *)
Debug->False

},
InheritanceMode];
DefineOptions[ScaledViewPort3D,{SchemeObject,{Show,Layer}},{

(* Fill control -- differs from Color/FillColor and ShowFill convention of other objects *)
BackgroundOpts,

(* Option control *)
BlockOptions->{},

(* 3D display options *)
EulerRotation->None,
AxisScaling->Automatic,
Complement[
Options[Graphics3D],Cases[Options[Graphics3D],x:(Background->_)]
],

(* UNDOCUMENTED *)
Debug->False

},
InheritanceMode];


DefineOptions[PanelLetter,{First->"a",PanelLetterOrigin->{1,1},Order->Horizontal,Format->{"(",")"}},InheritanceMode];
DefineOptions[FigurePanel,
{SchemeObject,Join[{Color,Opacity,Show,Layer},OutlineOpts,TextOpts]},
{PanelLetter,All},
{
(* Panel coordinate range *)
PlotRange->Automatic,
XPlotRange->Automatic,YPlotRange->Automatic,
ExtendRange->0,

(* Panel geometry adjustments -- generic *)
Margin->0,

(* Panel geometry adjustments -- in Multipanel array only *)
PanelShift->None,PanelAdjustments->None,

(* Fill control -- differs from Color/FillColor and ShowFill convention of other objects *)
BackgroundOpts,

(* Frame control *)
Frame->True,
ShowEdge->{True,True,True,True},

(* Label control *)
LabBOpts,PosnB->Automatic,BufferB->Automatic,
LabLOpts,PosnL->Automatic,BufferL->Automatic,
LabTOpts,PosnT->Automatic,BufferT->Automatic,
LabROpts,PosnR->Automatic,BufferR->Automatic,
FrameLabel->Automatic,
ShowFrameLabels->Automatic,

(* Label control -- multipanel only *)
ShowFrameLabelsExterior->{True,True,False,False},
ShowFrameLabelsInterior->{False,False,False,False},
ExteriorMask->Automatic,

(* Panel letter control *)
PanelLetter->None,
PanelLetterInset->{15,15},
PanelLetterTextOpts,
PanelLetterOpts,

(* Tick control *)
FrameTicks->None,
ShowTicks->Automatic,
ShowTickLabels->Automatic,
TickNudge->{0,0,0,0},
TickOptions->None,
TickLabelMargin->0,
TickTextOpts,
TickOutlineOpts,

(* Tick control -- multipanel only *)
ShowTickLabelsExterior->{True,True,False,False},
ShowTickLabelsInterior->{False,False,False,False},
TickLabelAutoSuppress->False


},
InheritanceMode];
DefineOptions[ScaledFigurePanel,
{SchemeObject,Join[{Color,Opacity,Show,Layer},OutlineOpts,TextOpts]},
{PanelLetter,All},
{
(* Panel coordinate range *)
PlotRange->Automatic,
XPlotRange->Automatic,YPlotRange->Automatic,
ExtendRange->0,

(* Panel geometry adjustments -- generic *)
Margin->0,

(* Panel geometry adjustments -- in Multipanel array only *)
(* not applicable to ScaledPanel *)

(* Fill control -- differs from Color/FillColor and ShowFill convention of other objects *)
BackgroundOpts,

(* Frame control *)
Frame->True,
ShowEdge->{True,True,True,True},

(* Label label control *)
LabBOpts,PosnB->Automatic,BufferB->Automatic,
LabLOpts,PosnL->Automatic,BufferL->Automatic,
LabTOpts,PosnT->Automatic,BufferT->Automatic,
LabROpts,PosnR->Automatic,BufferR->Automatic,
FrameLabel->Automatic,
ShowFrameLabels->Automatic,

(* Panel letter control *)
PanelLetter->None,
PanelLetterInset->{15,-15},
PanelLetterTextOpts,
PanelLetterOpts,

(* Frame ticks *)
FrameTicks->None,
ShowTicks->Automatic,
ShowTickLabels->Automatic,
TickNudge->{0,0,0,0},
TickOptions->None,
TickLabelMargin->0,
TickTextOpts,
TickOutlineOpts

},
InheritanceMode];
DefineOptions[Multipanel,
{FigurePanel,
Complement[First/@Options[FigurePanel],{PlotRange,XPlotRange,YPlotRange,LabB,LabL,LabT,LabR,FrameLabel,FrameTicks,TickLabelMargin,PanelLetter,Margin}]
},
{

(* Geometry *)
XPanelSizes->1,YPanelSizes->1,
XGapSizes->0,YGapSizes->0,
XMarginSizes->0,YMarginSizes->0,
Margin->0,

(* Panel appearance *)
XPlotRanges->Automatic,YPlotRanges->Automatic,
XFrameLabels->None,YFrameLabels->None,
XFrameTicks->Automatic,YFrameTicks->Automatic
},
InheritanceMode];
DefineOptions[SchemeAxis,
{SchemeObject,Join[BasicOpts,OutlineOpts,TextOpts]},
{
(* Arrowhead control *)
ShowHead->True,
ArrowheadOpts,

(* Label control *)
LabBOpts,PosnB->Automatic,BufferB->Automatic,
LabLOpts,PosnL->Automatic,BufferL->Automatic,
LabTOpts,PosnT->Automatic,BufferT->Automatic,
LabROpts,PosnR->Automatic,BufferR->Automatic,

(* Frame ticks *)
Ticks->None,
ShowTicks->True,
ShowTickLabels->True,
TickNudge->0,
TickTextOpts,
TickOutlineOpts,

(* axis geometry *)
AxesOrigin->Automatic

},
InheritanceMode];


DefineOptions[AttachIndex,{Range->Automatic,First->1,ScaleFactor->1},InheritanceMode];


DefineOptions[DataPlot,
{SchemeObject,ObjectOpts},
{ShowData->True,Debug->False,DataLine->{},DataSymbol->{},DataValues->{},DataStyle->None},
InheritanceMode];
DefineOptions[DataTag,{},InheritanceMode];
DefineOptions[DefineDataStyle,{DataLine->{},DataSymbol->{},DataStyle->None,Debug->False},InheritanceMode];
DefineOptions[UseDataOptions,{DataLine->{},DataSymbol->{},DataStyle->None,Debug->False},InheritanceMode];
DefineOptions[DataLabel,{SchemeObject,Join[BasicOpts,TextOpts]},
{
LabLOpts,PosnL->Automatic,
LabROpts,PosnR->Automatic,
LabTOpts,PosnT->Automatic,BufferT->Automatic,
LabBOpts,PosnB->Automatic,BufferB->Automatic,
LabCOpts,PosnC->Automatic
},
InheritanceMode];


DefineOptions[DataLine,{SchemeObject,Join[BasicOpts,OutlineOpts,Complement[FillOpts,{ShowFill}]]},
{
LineShape->"Straight",IgnoreMissingValues->False,PlotPoints->3,ShowFill->False,
Transpose->False (* quick fix -- TO REVISIT *)
},InheritanceMode];
DefineOptions[DataSymbol,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts]},{SymbolSize->2.5,SymbolShape->"Circle",PlotPoints->16},InheritanceMode];
DefineOptions[DataValues,{AxisScaling->None,DataFilters->None},InheritanceMode];
DefineOptions[DataSet,{DataColumns->Automatic},InheritanceMode];


DefineOptions[DataLegend,{SchemeObject,Join[BasicOpts,OutlineOpts,FillOpts,TextOpts]},
{LabOpts,Length->10,Gap->5,Width->Automatic,LineSpacing->1.1,Dimensions->Automatic},
InheritanceMode];


DefineOptions[Figure,{SchemeObject,Join[{Color,Opacity},{LineColor,LineOpacity,Thickness,CapForm,Dashing,DashingGap,DashingCorrection},{FontFamily,FontSize,FontWeight,FontSlant,FontTracking,FontColor,FontOpacity}]},
{
(* inherited outline and text options control frame line and labels but not frame ticks *)

(* Plot region control *)
PlotRange->Automatic,
ExtendRange->0,
ImageSize->Automatic,

(* Axes and frame control *)
Frame->False,
FrameLabel->Automatic,
LabB->None,LabL->None,LabT->None,LabR->None,
Axes->False,

(* Tick control *)
FrameTicks->None,
Ticks->None,
TickTextOpts,
(* TickOutlineOpts not supported *)

(* Rendering properties *)
Background->None,  (* BackgroundOpacity not supported *)
DisplayFunction->$DisplayFunction,

(* Option control *)
(* DEPRECATED *)
BlockOptions->{},

(* scoping *)
Block->{},

(* Conditional inclusion *)
SchemeFlags->{},
Do->None,

(* UNDOCUMENTED debugging options *)
Information->False,
Debug->False

}
];


DefineOptions[LineStyle,{SchemeObject,{Color,Opacity,LineColor,LineOpacity,Thickness,CapForm,Dashing,DashingGap,DashingCorrection}},
{},
InheritanceMode];
DefineOptions[FillStyle,{SchemeObject,{Color,Opacity,FillColor,FillOpacity}},
{},
InheritanceMode];


CoordinateSystems={CanvasCoords,AbsoluteCoords,RegionCoords,ScaledCoords,UserCoords};
CoordinateSystemAbbreviation[CanvasCoords]="C";
CoordinateSystemAbbreviation[AbsoluteCoords]="A";
CoordinateSystemAbbreviation[RegionCoords]="R";
CoordinateSystemAbbreviation[ScaledCoords]="S";
CoordinateSystemAbbreviation[UserCoords]="U";
CoordinateSystemQ[SystemA_]:=MemberQ[CoordinateSystems,SystemA];


Hold[LevelScheme`Coord`CoordA];  
Hold[LevelScheme`Coord`CoordB]; 
If[!ValueQ[ConversionFunctionSymbols],
ConversionFunctionSymbols=HoldPattern/@ToExpression/@Flatten[
TableForEach[
{
"LevelScheme`Coord`"<>"P"<>CoordinateSystemAbbreviation[SystemG]<>"Of"<>"P"<>CoordinateSystemAbbreviation[SystemF],
"LevelScheme`Coord`"<>"X"<>CoordinateSystemAbbreviation[SystemG]<>"Of"<>"X"<>CoordinateSystemAbbreviation[SystemF],
"LevelScheme`Coord`"<>"Y"<>CoordinateSystemAbbreviation[SystemG]<>"Of"<>"Y"<>CoordinateSystemAbbreviation[SystemF],
"LevelScheme`Coord`"<>"DP"<>CoordinateSystemAbbreviation[SystemG]<>"Of"<>"P"<>CoordinateSystemAbbreviation[SystemF],
"LevelScheme`Coord`"<>"DX"<>CoordinateSystemAbbreviation[SystemG]<>"Of"<>"X"<>CoordinateSystemAbbreviation[SystemF],
"LevelScheme`Coord`"<>"DY"<>CoordinateSystemAbbreviation[SystemG]<>"Of"<>"Y"<>CoordinateSystemAbbreviation[SystemF]
},
{SystemF,CoordinateSystems},{SystemG,CoordinateSystems}
]
]
];
AppendTo[$ContextPath,"LevelScheme`Coord`"];


ConvertCoordinate[SystemF_?CoordinateSystemQ,SystemG_?CoordinateSystemQ,Type:C,PF:{_,_}]:=CoordA[SystemF,SystemG]+CoordB[SystemF,SystemG]*PF;
ConvertCoordinate[SystemF_?CoordinateSystemQ,SystemG_?CoordinateSystemQ,Type:D,PF:{_,_}]:=CoordB[SystemF,SystemG]*PF;
ConvertCoordinate[SystemF_?CoordinateSystemQ,SystemG_?CoordinateSystemQ,Type:C,x_,Index:(1|2)]:=CoordA[SystemF,SystemG][[Index]]+CoordB[SystemF,SystemG][[Index]]*x;
ConvertCoordinate[SystemF_,SystemG_,Type:D,x_,Index:(1|2)]:=CoordB[SystemF,SystemG][[Index]]*x;


ConvertRange[SystemF_?CoordinateSystemQ,SystemG_?CoordinateSystemQ,Type:(C|D),RF:{_?NumericQ,_?NumericQ},Index:(1|2)]:=Map[(ConvertCoordinate[SystemF,SystemG,Type,#,Index]&),RF];


ConvertRegion[SystemF_?CoordinateSystemQ,SystemG_?CoordinateSystemQ,Type:(C|D),RF:{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}}]:=MapIndexed[(ConvertRange[SystemF,SystemG,Type,#1,First[#2]]&),RF];


ConvertCoordinate[SystemF_?CoordinateSystemQ,SystemG_?CoordinateSystemQ,Type:(C|D),{RF1:{_,_},RF2:{_,_}}]:={ConvertCoordinate[SystemF,SystemG,Type,RF1,1],ConvertCoordinate[SystemF,SystemG,Type,RF2,2]};
ConvertCoordinate[SystemF_?CoordinateSystemQ,SystemG_?CoordinateSystemQ,Type:(C|D),RF:{_,_},Index:(1|2)]:=ConvertCoordinate[SystemF,SystemG,Type,#,Index]&/@RF;


ConvertCoordinate[SystemF_?CoordinateSystemQ,SystemG:(_?CoordinateSystemQ):UserCoords,Axis:Horizontal,x_?NumericQ,Type:(C|D):C]:=ConvertCoordinate[SystemF, SystemG,Type,x,1];
ConvertCoordinate[SystemF_?CoordinateSystemQ,SystemG:(_?CoordinateSystemQ):UserCoords,Axis:Vertical,x_?NumericQ,Type:(C|D):C]:=ConvertCoordinate[SystemF, SystemG,Type,x,2];
ConvertCoordinate[SystemF_?CoordinateSystemQ,SystemG:(_?CoordinateSystemQ):UserCoords,P:{_?NumericQ,_?NumericQ},Type:(C|D):C]:=ConvertCoordinate[SystemF, SystemG,Type,P];


ConvertRange[SystemF_?CoordinateSystemQ,SystemG:(_?CoordinateSystemQ):UserCoords,Axis:Horizontal,RF:{_?NumericQ,_?NumericQ},Type:(C|D)]:=ConvertRange[SystemF, SystemG,Type,RF,1];
ConvertRange[SystemF_?CoordinateSystemQ,SystemG:(_?CoordinateSystemQ):UserCoords,Axis:Vertical,RF:{_?NumericQ,_?NumericQ},Type:(C|D)]:=ConvertRange[SystemF, SystemG,Type,RF,2];


ConvertRegion[SystemF_?CoordinateSystemQ,SystemG:(_?CoordinateSystemQ):UserCoords,RF:{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},Type:(C|D):C]:=ConvertRegion[SystemF, SystemG,Type,RF];


SavePoint[ID_,P:{_?NumericQ,_?NumericQ},GivenSystem:(_?CoordinateSystemQ):UserCoords]:=Module[
{},

CheckInScheme[];
CheckValue[ID,_?LevelIdentifierQ,"a point identifier symbol (cannot be list or number)"];
LevelScheme`Data`P[ID]=ConvertCoordinate[GivenSystem,CanvasCoords,C,P];

];
GetPoint[ID_,GivenSystem:(_?CoordinateSystemQ):UserCoords]:=Module[
{},

CheckInScheme[];
CheckPoint[ID];
ConvertCoordinate[CanvasCoords,GivenSystem,C,LevelScheme`Data`P[ID]]
];


DefineCoordinates[AbsSize_List,P1C_List,P2C_List,P3C_List,P4C_List,P3R_List,P4R_List,AUR_List,BUR_List]:=Module[
{SystemF,SystemG,FunctionNameStrings,P,X,Y},

(* define conversion constants to canvas system *)
CoordA[CanvasCoords,CanvasCoords]={0.,0.};
CoordB[CanvasCoords,CanvasCoords]={1.,1.};
CoordA[AbsoluteCoords,CanvasCoords]=P1C;
CoordB[AbsoluteCoords,CanvasCoords]=(P2C-P1C)/AbsSize;
CoordA[RegionCoords,CanvasCoords]=P3C-P3R*(P4C-P3C)/(P4R-P3R);
CoordB[RegionCoords,CanvasCoords]=(P4C-P3C)/(P4R-P3R);
CoordA[ScaledCoords,CanvasCoords]=P3C;
CoordB[ScaledCoords,CanvasCoords]=P4C-P3C;
CoordA[UserCoords,CanvasCoords]=P3C+(AUR-P3R)*(P4C-P3C)/(P4R-P3R);
CoordB[UserCoords,CanvasCoords]=BUR*(P4C-P3C)/(P4R-P3R);

(* deduce conversion constants to any other system *)
DoForEach[
CoordA[SystemF,SystemG]=(CoordA[SystemF,CanvasCoords]-CoordA[SystemG,CanvasCoords])/CoordB[SystemG,CanvasCoords];
CoordB[SystemF,SystemG]=CoordB[SystemF,CanvasCoords]/CoordB[SystemG,CanvasCoords],
{SystemF,CoordinateSystems},{SystemG,Complement[CoordinateSystems,{CanvasCoords}]}
];

(* define private shorthand operators *)
Evaluate[ConversionFunctionSymbols]=
SuppressMessage[Part::partd,
Flatten[
TableForEach[
{
Compile[{{P,_Real,1}},Evaluate[ConvertCoordinate[SystemF,SystemG,C,{P[[1]],P[[2]]}]]],
Compile[{X},Evaluate[ConvertCoordinate[SystemF,SystemG,C,X,1]]],
Compile[{Y},Evaluate[ConvertCoordinate[SystemF,SystemG,C,Y,2]]],
Compile[{{P,_Real,1}},Evaluate[ConvertCoordinate[SystemF,SystemG,D,{P[[1]],P[[2]]}]]],
Compile[{X},Evaluate[ConvertCoordinate[SystemF,SystemG,D,X,1]]],
Compile[{Y},Evaluate[ConvertCoordinate[SystemF,SystemG,D,Y,2]]]
},
{SystemF,CoordinateSystems},{SystemG,CoordinateSystems}
]
]

];

];


DXCTick:=(DXCOfXA[$TickScaleFactor*#]&);
DYCTick:=(DYCOfYA[$TickScaleFactor*#]&);


SetOrigin[{x_?NumericQ,y_?NumericQ}]:=Module[{},
$AUR={x,y};
DefineCoordinates[$AbsSize,$P1C,$P2C,$P3C,$P4C,$P3R,$P4R,$AUR,$BUR];
Null
];
SetOrigin[x_?NumericQ]:=SetOrigin[{x,0}];
SetOrigin[]:=SetOrigin[{0,0}];


SetScale[{x_?NumericQ,y_?NumericQ}]:=Module[{},
$BUR={x,y};
If[!Positive[Min[$BUR]],ErrorMessage[SetScale::nonpositive,$BUR]];
DefineCoordinates[$AbsSize,$P1C,$P2C,$P3C,$P4C,$P3R,$P4R,$AUR,$BUR];
Null
];
SetScale[y_?NumericQ]:=SetScale[{1,y}];
SetScale[]:=SetScale[{1,1}];


SetRegion[{{x3C_?NumericQ,x4C_?NumericQ},{y3C_?NumericQ,y4C_?NumericQ}},{{x3R_?NumericQ,x4R_?NumericQ},{y3R_?NumericQ,y4R_?NumericQ}}]:=Module[
{Differences},
$RegionRange={{x3C,x4C},{y3C,y4C}};
$P3C={x3C,y3C};$P4C={x4C,y4C};
$P3R={x3R,y3R};$P4R={x4R,y4R};
$AUR={0,0};$BUR={1,1};
Differences=-Subtract@@@$RegionRange;
If[!Positive[Min[Differences]],ErrorMessage[SetRegion::nonpositive,$RegionRange]];
DefineCoordinates[$AbsSize,$P1C,$P2C,$P3C,$P4C,$P3R,$P4R,$AUR,$BUR];
Null
];
SetRegion[]:=($Background=None;SetRegion[$CanvasRange,$CanvasRange]);


SetAttributes[ListableNot,Listable];
ListableNot[Args___]:=Not[Args];
SetAttributes[ListableAnd,Listable];
ListableAnd[Args___]:=And[Args];
SetAttributes[ListableOr,Listable];
ListableOr[Args___]:=Or[Args];
SetAttributes[ListableXor,Listable];
ListableXor[Args___]:=Xor[Args];


VectorArcTan[{x_?NumericQ,y_?NumericQ}]:=If[{x,y}=={0,0},0.,ArcTan[x,y]];
VectorLength[{x_?NumericQ,y_?NumericQ}]:=Sqrt[x^2+y^2];


SegmentArcTan[{X1_List,X2_List}]:=VectorArcTan[X2-X1];
SegmentLength[{X1_List,X2_List}]:=VectorLength[X2-X1];


Polar[{rho_,phi_}]:=rho*{Cos[phi],Sin[phi]};
Cylindrical[{rho_,phi_,z_}]:={rho*Cos[phi],rho*Sin[phi],z};
Spherical[{r_,theta_,phi_}]:={r*Sin[theta]*Cos[phi],r*Sin[theta]*Sin[phi],r*Cos[theta]};


Interpolate[x1_,x2_,y1_,y2_,x_]:=y1+(x-x1)/(x2-x1)*(y2-y1);


InRange[{x1_,x2_},x_]:=(x1<=x)&&(x<=x2);


InRegion[{{x1_,x2_},{y1_,y2_}},{x_,y_}]:=InRange[{x1,x2},x]&&InRange[{y1,y2},y];
InRegion[{x1_,y1_},{x2_,y2_},{x_,y_}]:=InRange[{x1,x2},x]&&InRange[{y1,y2},y];


ExtendRange[PRange:{x1_?NumericQ,x2_?NumericQ},PFrac:{fx1_?NumericQ,fx2_?NumericQ}]:=PRange+PFrac*{-1,+1}*-Subtract@@PRange;
ExtendRange[PRange:{x1_?NumericQ,x2_?NumericQ},fx_]:=ExtendRange[PRange,{fx,fx}];


ExtendRegion[PRange:{{x1_?NumericQ,x2_?NumericQ},{y1_?NumericQ,y2_?NumericQ}},PFrac:{{fx1_?NumericQ,fx2_?NumericQ},{fy1_?NumericQ,fy2_?NumericQ}}]:=PRange+PFrac*{{-1,+1},{-1,+1}}*-Subtract@@@PRange;
ExtendRegion[PRange:{{x1_?NumericQ,x2_?NumericQ},{y1_?NumericQ,y2_?NumericQ}},{fx_?NumericQ,fy_?NumericQ}]:=ExtendRegion[PRange,{{fx,fx},{fy,fy}}];
ExtendRegion[PRange:{{x1_?NumericQ,x2_?NumericQ},{y1_?NumericQ,y2_?NumericQ}},f_?NumericQ]:=ExtendRegion[PRange,{f,f}];


RegionCorners[PRange:{{x1_?NumericQ,x2_?NumericQ},{y1_?NumericQ,y2_?NumericQ}}]:={{x1,y1},{x1,y2},{x2,y2},{x2,y1}};


ExtendRegionAspectRatio[PRange:{xRange:{x1_?NumericQ,x2_?NumericQ},yRange:{y1_?NumericQ,y2_?NumericQ}},TargetAspectRatio_?Positive]:=Module[
{
IntrinsicAspectRatio
},

(* aspect ratio = height/width *)
(* calculate intrinsic aspect ratio of region *)
IntrinsicAspectRatio=1/Divide@@(Subtract@@@PRange);

If[
IntrinsicAspectRatio<TargetAspectRatio,
(* too short *)
(* stretch height so a'=h (1+2\[Epsilon])/w *)
{xRange,ExtendRange[yRange,1/2*(TargetAspectRatio/IntrinsicAspectRatio-1)]},
(* too long *)
(* stretch width so a'=h/w(1+2\[Epsilon]) *)
{ExtendRange[xRange,1/2*(IntrinsicAspectRatio/TargetAspectRatio-1)],yRange}
]
];


RealNumericQ=((#===-Infinity)||(#===+Infinity)||Head[N[#]]===Real&);


SetAttributes[SuppressMessage,HoldAll];
SuppressMessage[MessageID_,Body_]:=Module[
{WasOn,Value},
WasOn=Switch[
Head[MessageID],
String|MessageName,True,
$Off,False
];
Off[MessageID];
Value=Body;
If[WasOn,On[MessageID]];
Value
];


UpgradeScalarX[P_]:=Switch[P,
None,{0,0},
_?NumericQ,{P,0},
{_?NumericQ,_?NumericQ},P
];
UpgradeScalarY[P_]:=Switch[P,
None,{0,0},
_?NumericQ,{0,P},
{_?NumericQ,_?NumericQ},P
];
UpgradeScalarXY[P_]:=Switch[P,
None,{0,0},
_?NumericQ,{P,P},
{_?NumericQ,_?NumericQ},P
];


NonListQ=(Head[#]=!=List&);


UpgradeFrameOptionsPaired[xy_?NonListQ]:=UpgradeFrameOptionsPaired[{xy,xy}];
UpgradeFrameOptionsPaired[{x_?NonListQ,y_?NonListQ}]:=UpgradeFrameOptionsPaired[{{x,x},{y,y}}];
UpgradeFrameOptionsPaired[{{x1_?NonListQ,x2_?NonListQ},{y1_?NonListQ,y2_?NonListQ}}]:={{x1,x2},{y1,y2}};
UpgradeFrameOptionsPaired[{x1_?NonListQ,y1_?NonListQ,x2_?NonListQ,y2_?NonListQ}]:={{x1,x2},{y1,y2}};
UpgradeFrameOptionsList[xy_?NonListQ]:=UpgradeFrameOptionsList[{xy,xy}];
UpgradeFrameOptionsList[{x_?NonListQ,y_?NonListQ}]:=UpgradeFrameOptionsList[{{x,x},{y,y}}];
UpgradeFrameOptionsList[{{x1_?NonListQ,x2_?NonListQ},{y1_?NonListQ,y2_?NonListQ}}]:={x1,y1,x2,y2};
UpgradeFrameOptionsList[{x1_?NonListQ,y1_?NonListQ,x2_?NonListQ,y2_?NonListQ}]:={x1,y1,x2,y2};


UpgradeFrameOptionsPaired[xy_?NonListQ,Filler_]:=UpgradeFrameOptionsPaired[{xy,xy},Filler];
UpgradeFrameOptionsPaired[{x_?NonListQ,y_?NonListQ},Filler_]:=UpgradeFrameOptionsPaired[{{x,Filler},{y,Filler}},Filler];
UpgradeFrameOptionsPaired[{{x1_?NonListQ,x2_?NonListQ},{y1_?NonListQ,y2_?NonListQ}},Filler_]:={{x1,x2},{y1,y2}};
UpgradeFrameOptionsPaired[{x1_?NonListQ,y1_?NonListQ,x2_?NonListQ,y2_?NonListQ},Filler_]:={{x1,x2},{y1,y2}};
UpgradeFrameOptionsList[xy_?NonListQ,Filler_]:=UpgradeFrameOptionsList[{xy,xy},Filler];
UpgradeFrameOptionsList[{x_?NonListQ,y_?NonListQ},Filler_]:=UpgradeFrameOptionsList[{{x,Filler},{y,Filler}},Filler];
UpgradeFrameOptionsList[{{x1_?NonListQ,x2_?NonListQ},{y1_?NonListQ,y2_?NonListQ}},Filler_]:={x1,y1,x2,y2};
UpgradeFrameOptionsList[{x1_?NonListQ,y1_?NonListQ,x2_?NonListQ,y2_?NonListQ},Filler_]:={x1,y1,x2,y2};


FlatListQ=(MatchQ[#,{___?NonListQ}]&);


UpgradeFrameOptionsFlatPaired[xy_?FlatListQ]:=UpgradeFrameOptionsFlatPaired[{xy,xy}];
UpgradeFrameOptionsFlatPaired[{x_?FlatListQ,y_?FlatListQ}]:=UpgradeFrameOptionsFlatPaired[{{x,x},{y,y}}];
UpgradeFrameOptionsFlatPaired[{{x1_?FlatListQ,x2_?FlatListQ},{y1_?FlatListQ,y2_?FlatListQ}}]:={{x1,x2},{y1,y2}};
UpgradeFrameOptionsFlatPaired[{x1_?FlatListQ,y1_?FlatListQ,x2_?FlatListQ,y2_?FlatListQ}]:={{x1,x2},{y1,y2}};
UpgradeFrameOptionsFlatList[xy_?FlatListQ]:=UpgradeFrameOptionsFlatList[{xy,xy}];
UpgradeFrameOptionsFlatList[{x_?FlatListQ,y_?FlatListQ}]:=UpgradeFrameOptionsFlatList[{{x,x},{y,y}}];
UpgradeFrameOptionsFlatList[{{x1_?FlatListQ,x2_?FlatListQ},{y1_?FlatListQ,y2_?FlatListQ}}]:={x1,y1,x2,y2};
UpgradeFrameOptionsFlatList[{x1_?FlatListQ,y1_?FlatListQ,x2_?FlatListQ,y2_?FlatListQ}]:={x1,y1,x2,y2};


FrameMaskListQ[(True|False)|{True|False,True|False}|{True|False,True|False,True|False,True|False}]:=True;
FrameMaskListQ[_]:=False;


UpgradeAxisOptions[xy_?NonListQ]:=UpgradeAxisOptions[{xy,xy}];
UpgradeAxisOptions[{x_?NonListQ,y_?NonListQ}]:={x,y};


MarginQ[(_?NumericQ)|{_?NumericQ,_?NumericQ}|{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}}]:=True;
MarginQ[_]:=False;


UpgradeMargin[xy_?NumericQ]:=UpgradeMargin[{xy,xy}];
UpgradeMargin[{x_?NumericQ,y_?NumericQ}]:=UpgradeMargin[{{x,x},{y,y}}];
UpgradeMargin[{{x1_?NumericQ,x2_?NumericQ},{y1_?NumericQ,y2_?NumericQ}}]:={{x1,x2},{y1,y2}};


ImposeAbsoluteMargin[OuterBox:{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},m_?MarginQ]:=(
OuterBox+ConvertRegion[AbsoluteCoords,CanvasCoords,D,{{+1,-1},{+1,-1}}*UpgradeMargin[m]]
);


Options[Intersperse]={First->False,Last->False};
Intersperse[L_List,Separator_,Opts___?OptionQ]:=Module[
{FullOpts=Flatten[{Opts,Options[Intersperse]}]},
Insert[
L,
Separator,
Table[{i},{i,If[First/.FullOpts,1,2],If[Last/.FullOpts,Length[L]+1,Length[L]]}]
]
];
Intersperse[Item_,Separator_,Num_Integer?NonNegative,Opts___?OptionQ]:=Intersperse[Table[Item,{Num}],Separator,Opts];


SingleRadiusQ[P_]:=MatchQ[P,_?NumericQ|Horizontal[_?NumericQ]|Vertical[_?NumericQ]|Point[_?NumericQ]];
DoubleRadiusQ[P_]:=MatchQ[P,{_?NumericQ,_?NumericQ}|Horizontal[{_?NumericQ,_?NumericQ}]|Vertical[{_?NumericQ,_?NumericQ}]|Point[{_?NumericQ,_?NumericQ}]];
RadiusQ[P_]:=SingleRadiusQ[P]||DoubleRadiusQ[P];


ConvertRadiusToCanvas[R_?RadiusQ]:=Switch[
R,
_?NumericQ|{_?NumericQ,_?NumericQ},
DPCOfPU@UpgradeScalarXY[R],
Horizontal[_?NumericQ|{_?NumericQ,_?NumericQ}],
DPCOfPA@(DXAOfXU/@UpgradeScalarXY[First[R]]),
Vertical[_?NumericQ|{_?NumericQ,_?NumericQ}],
DPCOfPA@(DYAOfYU/@UpgradeScalarXY[First[R]]),
Point[_?NumericQ|{_?NumericQ,_?NumericQ}],
DPCOfPA@UpgradeScalarXY[First[R]]
];


SetAttributes[ErrorMessage,HoldFirst];
ErrorMessage[Args___]:=Module[
{},
Message[Args];
If[
$InScheme,
Throw[$ErrorFlag],
Abort[]
]
];


SetAttributes[CatchError,HoldAll];
CatchError[Body_]:=(Catch[Body]===$ErrorFlag);


CheckInScheme[]:=Module[
{},
If[$InScheme=!=True,
Message[LevelScheme::notinscheme];
Abort[]
]
];


SetAttributes[FallThroughError,HoldAll];
FallThroughError[Object_Symbol,Expr_]:=Module[
{},
CheckInScheme[];
If[
Count[Hold[Expr],Null,{2}]>0,
Message[Object::lsargsnull,HoldForm[Expr]]
];
ErrorMessage[Object::lsargs,HoldForm[Expr]]
];


CheckOption[Param_,TestPattern_,FullOpts_List]:=Module[
{},
If[
!MatchQ[Param/.FullOpts,TestPattern],
ErrorMessage[LevelScheme::badparam,Param,Param/.FullOpts]
]
];
CheckValue[Value_,TestPattern_,Description_String]:=Module[
{},
If[
!MatchQ[Value,TestPattern],
ErrorMessage[LevelScheme::badvalue,Description,Value]
]
];


CheckLevel[ID_]:=Module[
{},
If[
!NumericQ[LevelScheme`Data`UserEnergy[ID]],
ErrorMessage[LevelScheme::badlevel,ID]
]
];


CheckPoint[ID_]:=Module[
{},
If[
!VectorQ[LevelScheme`Data`P[ID]],
ErrorMessage[LevelScheme::badpoint,ID]
]
];


CheckDataSet[ID_]:=Module[
{},
If[
!TrueQ[LevelScheme`Data`DataTagDefined[ID]],
ErrorMessage[LevelScheme::baddataset,ID]
]
];


LevelIdentifierQ[Expr_]:=((Head[Expr]=!=List)&&!NumericQ[Expr]);


FigRealizeOptions[Object_Symbol,Opts___?OptionQ]:=Module[
{RealizedOptions,TagValue,Patt,ActiveOptions},

(* do inheritance first *)
RealizedOptions=RealizeOptions[Object,Opts];

(* select conditional options whose pattern matches Tag *)
TagValue=(Tag/.RealizedOptions);
ActiveOptions=Switch[
(ConditionalOptions/.RealizedOptions),
ConditionalOptions,{},
_,FilterRules[(ConditionalOptions/.RealizedOptions),(Patt_/;MatchQ[TagValue,Patt])]
];
(* prepend these options to full option list *)
Flatten[{Last/@ActiveOptions,RealizedOptions}]

];


FigObjectExistsQ[Tag_]:=MatchQ[LevelScheme`Data`ObjectData[Tag],_List];


FigDefineObject[Data:{(_Rule)...},FullOpts_List]:=Module[
{},

(* ensure sure data list exists *)
(*If[
!FigObjectExistsQ[Tag],
LevelScheme`Data`ObjectData[Tag]={}
];*)

LevelScheme`Data`ObjectData[(Tag/.FullOpts)]={};

(* prepend new data *)
LevelScheme`Data`ObjectData[(Tag/.FullOpts)]=Flatten[{Data,LevelScheme`Data`ObjectData[(Tag/.FullOpts)]}]

];


FigObjectData[Tag_,Field_Symbol]:=Module[
{},

Field/.LevelScheme`Data`ObjectData[Tag]

];


ColorDirectivePattern=(_GrayLevel|_RGBColor|_Hue|_CMYKColor); 


CorrectedDash[Thickness_][Length_,{(Index_Integer)?OddQ}]:=Max[Length-Thickness,0.];
CorrectedDash[Thickness_][Length_,{(Index_Integer)?EvenQ}]:=Max[Length+Thickness,0.];
MakeOutlineDirectives[FullOpts_List] :=Module[
{DashLengths,DefaultGapLength,DefaultGapFactor},
CheckOption[Color,ColorDirectivePattern,FullOpts];
CheckOption[Opacity,_?NumericQ,FullOpts];
CheckOption[LineColor,Automatic|ColorDirectivePattern,FullOpts];
CheckOption[LineOpacity,Automatic|_?NumericQ,FullOpts];
CheckOption[Thickness,_?NumericQ,FullOpts];
CheckOption[CapForm,None|(_String),FullOpts];
CheckOption[Dashing,None|Automatic|True|(_?NumericQ)|{(_?NumericQ)...}|AbsoluteDashing[{(_?NumericQ)...}],FullOpts];
CheckOption[DashingGap,Automatic|(_?NumericQ),FullOpts];
CheckOption[DashingCorrection,True|False,FullOpts];

DefaultGapFactor=1/2; (* default ratio of gap to average dash length *)
DefaultGapLength=GetAutoOption[
DashingGap,
Switch[
(Dashing/.FullOpts),
None|0|_AbsoluteDashing,None,
Automatic|True,DefaultGapFactor*4,
_?NumericQ,DefaultGapFactor*(Dashing/.FullOpts),
{(_?NumericQ)...},DefaultGapFactor*Plus@@(Dashing/.FullOpts)/Length[(Dashing/.FullOpts)],
_AbsoluteDashing,None
],
FullOpts
];
DashLengths=Switch[
Dashing/.FullOpts,
None|0,{},
Automatic|True,{4,DefaultGapLength},
_?NumericQ,{(Dashing/.FullOpts),DefaultGapLength},
{(_?NumericQ)...},Intersperse[(Dashing/.FullOpts),DefaultGapLength,Last->True],
_AbsoluteDashing,First[Dashing/.FullOpts]
];
DashLengths=MapIndexed[
CorrectedDash[If[(DashingCorrection/.FullOpts),(Thickness/.FullOpts),0]],
DashLengths
];

{

GetAutoOption[LineColor,Color/.FullOpts,FullOpts],
Opacity[GetAutoOption[LineOpacity,Opacity/.FullOpts,FullOpts]],
CapForm[CapForm/.FullOpts],
AbsoluteThickness[Thickness/.FullOpts],
AbsoluteDashing[DashLengths]

}
];

MakeOutline[Art_,Opts___?OptionQ] := Module[
{
FullOpts=Flatten[{Opts}],
CroppedArt
},

CheckOption[Show,True|False,FullOpts];
CheckOption[ShowLine,True|False,FullOpts];
CheckOption[Layer,Automatic|_?NumericQ,FullOpts];
CheckOption[ClipToRectangle,True|False,FullOpts];

If[(Show/.FullOpts)&&(ShowLine/.FullOpts),
CroppedArt=If[
ClipToRectangle/.FullOpts,
First@ClipToRectangle[$RegionRange,Graphics[Art]],
Art
];
SchemeGraphics[
MakeOutlineDirectives[FullOpts],
CroppedArt,
GetAutoOption[Layer,$SchemeDrawingLayer,FullOpts]
]
]
];


MakeOutline3D[Art_,Opts___?OptionQ] := Module[
{
FullOpts=Flatten[{Opts}]
},

CheckOption[ShowLine,True|False,FullOpts];

If[
(Show/.FullOpts)&&(ShowLine/.FullOpts),
Graphics3D[{
GeometricTransformation[
Flatten[{
MakeOutlineDirectives[FullOpts],
Art
}],
(GeometricTransformation/.FullOpts)
]}
]
]
];


MakeFillDirectives[FullOpts_List] := 
{
CheckOption[Color,ColorDirectivePattern,FullOpts];
CheckOption[Opacity,_?NumericQ,FullOpts];
CheckOption[FillColor,Automatic|ColorDirectivePattern,FullOpts];
CheckOption[FillOpacity,Automatic|_?NumericQ,FullOpts];

GetAutoOption[FillColor,Color/.FullOpts,FullOpts],
Opacity[GetAutoOption[FillOpacity,Opacity/.FullOpts,FullOpts]]

};

MakeFill[Art_,Opts___?OptionQ] :=  Module[
{
FullOpts=Flatten[{Opts}],
CroppedArt
},

CheckOption[Show,True|False,FullOpts];
CheckOption[ShowFill,True|False,FullOpts];
CheckOption[Layer,Automatic|_?NumericQ,FullOpts];
CheckOption[ClipToRectangle,True|False,FullOpts];

If[(Show/.FullOpts)&&(ShowFill/.FullOpts),
CroppedArt=If[
ClipToRectangle/.FullOpts,
First@ClipToRectangle[$RegionRange,Graphics[Art]],
Art
];
SchemeGraphics[
MakeFillDirectives[FullOpts],
CroppedArt,
GetAutoOption[Layer,$SchemeDrawingLayer,FullOpts]
]
]
];


MakeTextStyle[FullOpts_List] := Module[
{},

CheckOption[Color,ColorDirectivePattern,FullOpts];
CheckOption[Opacity,_?NumericQ,FullOpts];
CheckOption[FontColor,Automatic|ColorDirectivePattern,FullOpts];
CheckOption[FontOpacity,Automatic|(_?NumericQ),FullOpts];
CheckOption[FontSize,_?NumericQ,FullOpts];

{
FontFamily ->(FontFamily/.FullOpts),FontSize->(FontSize/.FullOpts),FontSlant->(FontSlant/.FullOpts),FontTracking->(FontTracking/.FullOpts),FontWeight->(FontWeight/.FullOpts),FontColor->GetAutoOption[FontColor,Color/.FullOpts,FullOpts],
FontOpacity->GetAutoOption[FontOpacity,Opacity/.FullOpts,FullOpts],
ShowAutoStyles->False,SingleLetterItalics->False
}
];

MakeTextOrientation[OrientationOption_,theta_]:=Module[
{
theta0,InversionSign
},

theta0=Mod[theta,2*Pi,-Pi];
InversionSign=If[(-Pi/2<theta0)&&(theta0<=Pi/2),+1,-1];

Switch[OrientationOption,
Automatic,
InversionSign*{Cos[theta],Sin[theta]},
Inverted,
-InversionSign*{Cos[theta],Sin[theta]},
Horizontal,
{1,0},
Vertical,
{0,1},
_?NumericQ,
{Cos[OrientationOption],Sin[OrientationOption]},
_List,
OrientationOption
]
];

MakeText[Art_,Posn_,DefaultAngle_,Opts___?OptionQ] :=  Module[
{
FullOpts=Flatten[{Opts}],
CalculatedOffset,
CalculatedPosn,
CalculatedOrientation,
StyleList,
StyledText,
OptOffset,
OptNudge,
OptBackground,
IsInRegion
},

CheckOption[Show,True|False,FullOpts];
CheckOption[ShowText,True|False,FullOpts];
CheckOption[ClipToRectangle,True|False,FullOpts];
CheckOption[Offset,{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[Nudge,None|(_?NumericQ)|{_?NumericQ,_?NumericQ},FullOpts];

OptOffset=(Offset/.FullOpts);
OptNudge=(Nudge/.FullOpts);
(* background of Automatic should use panel background $Background if defined, else white *)
OptBackground=GetAutoOption[Background,Switch[$Background,None,White,_,$Background],FullOpts];

(* Calculate properties *)
CalculatedOffset=OptOffset;
CalculatedPosn=Posn+DPCOfPA[UpgradeScalarY[OptNudge]];
CalculatedOrientation=MakeTextOrientation[(Orientation/.FullOpts) ,DefaultAngle];
StyleList=MakeTextStyle[FullOpts];
IsInRegion=InRegion[$RegionRange,Posn];

If[(Show/.FullOpts)&&(ShowText/.FullOpts)&&(Art=!=None),If[IsInRegion||!(ClipToRectangle/.FullOpts),
{

(* apply style to text *)

StyledText=DisplayForm[Style[DisplayForm[Art],StyleList]];

(* background block *)

If[(OptBackground=!=None),
SchemeGraphics[
{},
{
Text[
Framed[
Invisible[StyledText],
FrameMargins->None,FrameStyle->None,ContentPadding->False,
Background->OptBackground
],
CalculatedPosn,
CalculatedOffset,
CalculatedOrientation
]
},
GetAutoOption[Layer,$SchemeBlankingLayer,FullOpts]
]
],

(* text itself *)

SchemeGraphics[
{},
{Text[StyledText,CalculatedPosn,CalculatedOffset,CalculatedOrientation]},
GetAutoOption[Layer,$SchemeTextLayer,FullOpts]
]
}
]
]

];


MakeText3D[Art_,Posn_,DefaultAngle_,Opts___?OptionQ] :=  Module[
{
FullOpts=Flatten[{Opts}],
CalculatedOffset,
CalculatedPosn,
CalculatedOrientation,
StyleList,
OptBackground
},

CheckOption[Show,True|False,FullOpts];
CheckOption[ShowText,True|False,FullOpts];

OptBackground=(Background/.FullOpts);

(* Calculate properties *)
CalculatedOffset=(Offset/.FullOpts);
CalculatedPosn=Posn;
CalculatedOrientation=MakeTextOrientation[(Orientation/.FullOpts) ,DefaultAngle];
StyleList=MakeTextStyle[FullOpts];

Graphics3D[{
GeometricTransformation[
Flatten[{

(* background block *)

(* Note: If FontSize is specified in TextStyle option to Text[], then background box can still shrink horizontally but can never shrink below the font's height (with generous margins), whether adjusted with an AdjustmentBox or set in a different font size using they StyleBox.  Vertical height seems not to shrink much in general for smaller fonts. *)

If[(Show/.FullOpts)&&(ShowText/.FullOpts)&&(Art=!=None)&&(OptBackground=!=None),
{
Text[
(*StyleBox[AdjustmentBox[Art,BoxMargins->$BackgroundMargins],ShowContents->False]//DisplayForm,*)
DisplayForm[StyleBox[Art,FontSize->(FontSize/.FullOpts),ShowContents->False]],
CalculatedPosn,
CalculatedOffset,
CalculatedOrientation,
BaseStyle->StyleList,
Background->OptBackground
]
},
{}
],

(* text itself *)
If[(Show/.FullOpts)&&(ShowText/.FullOpts)&&(Art=!=None),
{Text[
DisplayForm[Art],
CalculatedPosn,
CalculatedOffset,
CalculatedOrientation,
BaseStyle->StyleList
]},
{}
]

}
],
(GeometricTransformation/.FullOpts)
]
}
]

];


MakeRawGraphicsDirectives[FullOpts_List] :=Module[
{},

CheckOption[Color,ColorDirectivePattern,FullOpts];
CheckOption[Opacity,_?NumericQ,FullOpts];

MakeOutlineDirectives[Join[FullOpts,{LineColor->Automatic,LineOpacity->Automatic}]]
];

MakeRawGraphics[Art_,Opts___?OptionQ] := Module[
{
FullOpts=Flatten[{Opts}]
},

CheckOption[Show,True|False,FullOpts];
CheckOption[Layer,Automatic|_?NumericQ,FullOpts];

If[Show/.FullOpts,
SchemeGraphics[
MakeRawGraphicsDirectives[FullOpts],
Art,
GetAutoOption[Layer,$SchemeDrawingLayer,FullOpts]
]
]
];


MakeRawGraphics3D[Art_,Opts___?OptionQ] := Module[
{
FullOpts=Flatten[{Opts}]
},

CheckOption[Show,True|False,FullOpts];

If[
Show/.FullOpts,
Graphics3D[{
GeometricTransformation[
Flatten[{
(*MakeRawGraphicsDirectives[FullOpts], -- makes objects black by default *)
(* PRESENTLY IGNORED -- style directives *)
Art
}],
(GeometricTransformation/.FullOpts)
]}
]
]
];


MakeVerbatim[Art_,Opts___?OptionQ] := Module[
{
FullOpts=Flatten[{Opts}]
},

CheckOption[Show,True|False,FullOpts];
CheckOption[Layer,Automatic|_?NumericQ,FullOpts];

If[Show/.FullOpts,
SchemeGraphics[
{},
Art,
GetAutoOption[Layer,$SchemeDrawingLayer,FullOpts]
]
]
];


BasicLineAnnotations[Points_List,FullOpts_List]:=Module[
{AbsPoints,Lengths,LengthSoFar,CurveParam,
AbsXFcn,AbsYFcn,AbsPFcn,AbsTangentFcn,
HalfWidthForLabels,
bufft,offt,OptPosnT,PointT,AngleT,
buffb,offb,OptPosnB,PointB,AngleB,
OptPosnL,PointL,AngleL,
OptPosnR,PointR,AngleR,
OptPosnC,PointC,AngleC},

(* option processing *)
CheckOption[PosnL,Automatic|(_?NumericQ),FullOpts];
CheckOption[PosnR,Automatic|(_?NumericQ),FullOpts];
CheckOption[PosnT,Automatic|(_?NumericQ),FullOpts];
CheckOption[PosnB,Automatic|(_?NumericQ),FullOpts];
CheckOption[PosnC,Automatic|(_?NumericQ),FullOpts];

(* parametrize data curve *)
AbsPoints=PAOfPC/@Points;
Lengths=VectorLength/@(Drop[AbsPoints,-1]-Drop[AbsPoints,1]);  (* i.e., Most-Rest *)
LengthSoFar=0.;
CurveParam=(LengthSoFar+=#&)/@Prepend[Lengths,0.]/LengthSoFar;
AbsXFcn=Interpolation[Transpose[{CurveParam,First/@AbsPoints}],InterpolationOrder->1];
AbsYFcn=Interpolation[Transpose[{CurveParam,Last/@AbsPoints}],InterpolationOrder->1];
AbsPFcn=({AbsXFcn[#],AbsYFcn[#]}&);
AbsTangentFcn=(
{Derivative[1][AbsXFcn][#],Derivative[1][AbsYFcn][#]}/VectorLength[{Derivative[1][AbsXFcn][#],Derivative[1][AbsYFcn][#]}]
&);  
AbsNormalFcn=({{0,-1},{1,0}}.AbsTangentFcn[#]&);

HalfWidthForLabels=0; (* was to allow for line width in placing labels, but awkward if do not know orientation out to label in advance -- could incorporate into Buffer mechanism *)

SuppressMessage[
(* silently allow linear extrapolation of curve *)
InterpolatingFunction::"dmval",
{

If[
((LabT/.FullOpts)=!=None)&&(ShowLabT/.FullOpts),
offt=GetAutoOption[OffsetT,
Switch[(OrientationT/.FullOpts),
Horizontal|Vertical,{0,-1},
Automatic|Inverted|_,{0,0}
],
FullOpts
];
bufft=GetAutoOption[BufferT,
Switch[(OrientationT/.FullOpts),
Horizontal|Vertical,0,
Automatic|Inverted|_,1.1
],
FullOpts
];
OptPosnT=GetAutoOption[PosnT,0.5,FullOpts];
PointT=PCOfPA@(AbsPFcn[OptPosnT]+AbsNormalFcn[OptPosnT]*(HalfWidthForLabels+bufft/2*(FontSize/.FullOpts)));
AngleT=VectorArcTan[AbsTangentFcn[OptPosnT]];
MakeText[(LabT/.FullOpts),PointT,AngleT,
ShowText->(ShowLabT/.FullOpts),
Offset->offt,
Nudge->(NudgeT/.FullOpts),
Orientation->(OrientationT/.FullOpts),
Background->(BackgroundT/.FullOpts),
FullOpts 
]
],

If[
((LabB/.FullOpts)=!=None)&&(ShowLabB/.FullOpts),
offb=GetAutoOption[OffsetB,
Switch[(OrientationB/.FullOpts),
Horizontal|Vertical,{0,+1},
Automatic|Inverted|_,{0,0}
],
FullOpts
];
buffb=GetAutoOption[BufferB,
Switch[(OrientationB/.FullOpts),
Horizontal|Vertical,0,
Automatic|Inverted|_,1.1
],
FullOpts
];
OptPosnB=GetAutoOption[PosnB,0.5,FullOpts];
PointB=PCOfPA@(AbsPFcn[OptPosnB]-AbsNormalFcn[OptPosnB]*(HalfWidthForLabels+buffb/2*(FontSize/.FullOpts)));
AngleB=VectorArcTan[AbsTangentFcn[OptPosnB]];
MakeText[(LabB/.FullOpts),PointB,AngleB,
ShowText->(ShowLabB/.FullOpts),
Offset->offb,
Nudge->(NudgeB/.FullOpts),
Orientation->(OrientationB/.FullOpts),
Background->(BackgroundB/.FullOpts),
FullOpts 
]
],

If[
((LabL/.FullOpts)=!=None)&&(ShowLabL/.FullOpts),
OptPosnL=GetAutoOption[PosnL,0.0,FullOpts];
PointL=PCOfPA@AbsPFcn[OptPosnL];
AngleL=VectorArcTan[AbsTangentFcn[OptPosnL]];
MakeText[(LabL/.FullOpts),PointL,AngleL,
ShowText->(ShowLabL/.FullOpts),
Offset->GetAutoOption[OffsetL,{+1,0},FullOpts],
Nudge->(NudgeL/.FullOpts),
Orientation->(OrientationL/.FullOpts),
Background->(BackgroundL/.FullOpts),
FullOpts 
]
],

If[
((LabR/.FullOpts)=!=None)&&(ShowLabR/.FullOpts),
OptPosnR=GetAutoOption[PosnR,1.0,FullOpts];
PointR=PCOfPA@AbsPFcn[OptPosnR];
AngleR=VectorArcTan[AbsTangentFcn[OptPosnR]];
MakeText[(LabR/.FullOpts),PointR,AngleR,
ShowText->(ShowLabR/.FullOpts),
Offset->GetAutoOption[OffsetR,{-1,0},FullOpts],
Nudge->(NudgeR/.FullOpts),
Orientation->(OrientationR/.FullOpts),
Background->(BackgroundR/.FullOpts),
FullOpts 
]
],


If[
((LabC/.FullOpts)=!=None)&&(ShowLabC/.FullOpts),
OptPosnC=GetAutoOption[PosnC,0.5,FullOpts];
PointC=PCOfPA@AbsPFcn[OptPosnC];
AngleC=VectorArcTan[AbsTangentFcn[OptPosnC]];
MakeText[(LabC/.FullOpts),PointC,AngleC,
ShowText->(ShowLabC/.FullOpts),
Offset->GetAutoOption[OffsetC,{0,0},FullOpts],
Nudge->(NudgeC/.FullOpts),
Orientation->(OrientationC/.FullOpts),
Background->(BackgroundC/.FullOpts),
FullOpts 
]
]
}
]

];


ArrowPoint[Caller_Symbol,{Pia_List,Pfa_List},AtUserPosition,x_,ya_]:=Module[
{theta,d,xa},
CheckValue[
x,
(_?NumericQ)|FromHead[_?NumericQ]|FromTail[_?NumericQ]|FromHeadVertical[_?NumericQ]|FromTailVertical[_?NumericQ]|FromHeadHorizontal[_?NumericQ]|FromTailHorizontal[_?NumericQ],
"a label position"
];
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
xa=Switch[x,
_?NumericQ,x*d,
FromHead[_?NumericQ],d-x[[1]],
FromTail[_?NumericQ],x[[1]],
FromHeadVertical[_?NumericQ],If[Chop[Sin[theta]]==0,ErrorMessage[Caller::fromvert]];(d-x[[1]])*(-Csc[theta]),
FromTailVertical[_?NumericQ],If[Chop[Sin[theta]]==0,ErrorMessage[Caller::fromvert]];(x[[1]])*(-Csc[theta]),
FromHeadHorizontal[_?NumericQ],If[Chop[Cos[theta]]==0,ErrorMessage[Caller::fromhoriz]];(d-x[[1]])*(-Sec[theta]),
FromTailHorizontal[_?NumericQ],If[Chop[Cos[theta]]==0,ErrorMessage[Caller::fromhoriz]];(x[[1]])*(-Sec[theta])
];
Pia+LegacyRotate2D[{xa,ya},-theta]
];
ArrowPoint[{Pia_List,Pfa_List},AtPosition,xa_,ya_]:=Module[
{theta,d},
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
Pia+LegacyRotate2D[{xa,ya},-theta]
];
ArrowPoint[{Pia_List,Pfa_List},AtTail,ya_]:=Module[
{theta,d},
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
Pia+LegacyRotate2D[{0,ya},-theta]
];
ArrowPoint[{Pia_List,Pfa_List},AtTail,{xa_,ya_}]:=Module[
{theta,d},
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
Pia+LegacyRotate2D[{xa,ya},-theta]
];
ArrowPoint[{Pia_List,Pfa_List},AtTailHorizontal,ya_]:=Module[
{theta},
theta=VectorArcTan[Pfa-Pia];
Pia+{-ya*Csc[theta],0} 
];
ArrowPoint[{Pia_List,Pfa_List},AtHead,ya_]:=Module[
{theta,d},
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
Pia+LegacyRotate2D[{d,ya},-theta]
];
ArrowPoint[{Pia_List,Pfa_List},AtHead,{xa_,ya_}]:=Module[
{theta,d},
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
Pia+LegacyRotate2D[{d+xa,ya},-theta]
];
ArrowPoint[{Pia_List,Pfa_List},AtHeadHorizontal,ya_]:=Module[
{theta},
theta=VectorArcTan[Pfa-Pia];
Pfa+{-ya*Csc[theta],0}
];
ArrowPoint[{Pia_List,Pfa_List},AtLip,HeadLength_,ya_]:=Module[
{theta,d},
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
Pia+LegacyRotate2D[{d-HeadLength,ya},-theta]
];
ArrowPoint[{Pia_List,Pfa_List},AtTailLip,HeadLength_,ya_]:=Module[
{theta,d},
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
Pia+LegacyRotate2D[{HeadLength,ya},-theta]
];
ArrowPoint[{Pia_List,Pfa_List},AtEdge,HeadLength_,HeadHalfWidth_,ya_]:=Module[
{theta,d},
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
Pia+LegacyRotate2D[{d-Abs[ya]*HeadLength/HeadHalfWidth,ya},-theta]
];


SquigglePoints[{Pia_List,Pfa_List},{MinBuffer1_,MinBuffer2_},HalfWidth_,SquiggleWavelength_,SquiggleSide_,PlotPoints_]:=Module[
{theta,d,dp,Delta,x,PointList,s},
s=Switch[SquiggleSide,Right,+1,Left,-1];
theta=VectorArcTan[Pfa-Pia];
d=VectorLength[Pfa-Pia];
dp=(SquiggleWavelength/2)*Floor[Max[(d-MinBuffer1-MinBuffer2),0]/(SquiggleWavelength/2)];
Delta=(d-MinBuffer1-MinBuffer2-dp)/2;
PointList=Table[
Pia+LegacyRotate2D[{x+MinBuffer1+Delta,s*HalfWidth*Sin[2*Pi/SquiggleWavelength*x]},-theta],
{x,0,dp,SquiggleWavelength/PlotPoints}
];
Join[{Pia},PointList,{Pfa}]
];


ArrowHeadPoints[{P1a:{_?NumericQ,_?NumericQ},P2a:{_?NumericQ,_?NumericQ}},HeadLength_?NumericQ,HeadLip_?NumericQ] := ArrowHeadPoints[P2a,VectorArcTan[P2a-P1a],HeadLength,HeadLip];
ArrowHeadPoints[Pa:{_?NumericQ,_?NumericQ},theta_?NumericQ,HeadLength_?NumericQ,HeadLip_?NumericQ] := Module[
{},
{
Pa+LegacyRotate2D[{-HeadLength,+HeadLip},-theta],
Pa+{0.,0.},
Pa+LegacyRotate2D[{-HeadLength,-HeadLip},-theta]
}
];


BasicArrow[Caller_Symbol,Nodes_List,FullOpts_List] := Module[
{
PointList,
AbsNodes,AbsSegments,Segment,
ConversionPointList,ConversionP0,ConversionP4,ConversionWidth,Conversiony,ConversionSideSign,
d,dp,dk,Delta,
ShaftPosition,ShaftPoints,
LineArt,TextArt,
theta0,InversionSign,

HalfWidthForLabels,
PLa,PRa,PCa,PTa,
offl,offr,offc,offkc,offt,
buffl,buffr,
SegmentPointsL,SegmentPointsC,SegmentPointsR,SegmentPointsT,

OptWidth,
OptThickness,
OptHeadLength,
OptShaftLines,
OptHeadLip
},

(* option checks *)
CheckOption[ArrowType,LineArrow|MultilineArrow|SquiggleArrow|ShapeArrow,FullOpts];
CheckOption[ArrowHalf,All|Left|Right,FullOpts];
CheckOption[HeadLength,_?NumericQ,FullOpts];
CheckOption[HeadLip,_?NumericQ,FullOpts];
CheckOption[Width,_?NumericQ,FullOpts];
CheckOption[TailBevel,True|False,FullOpts];
CheckOption[ShaftLines,(x_Integer)/;(x>=2),FullOpts];
CheckOption[PlotPoints,(x_Integer)/;(x>=4),FullOpts];
CheckOption[SquiggleBuffer,(x_?NumericQ)/;(x>=0),FullOpts];
CheckOption[SquiggleWavelength,(x_?NumericQ)/;(x>0),FullOpts];
CheckOption[SquiggleSide,Left|Right,FullOpts];
CheckOption[SegmentL,Automatic|(x_Integer/;((x!=0)&&(Abs[x]<Length[Nodes]))),FullOpts];
CheckOption[SegmentR,Automatic|(x_Integer/;((x!=0)&&(Abs[x]<Length[Nodes]))),FullOpts];
CheckOption[SegmentC,Automatic|(x_Integer/;((x!=0)&&(Abs[x]<Length[Nodes]))),FullOpts];
If[
(!MatchQ[ArrowType/.FullOpts,LineArrow])&&(Length[Nodes]>2),
ErrorMessage[Caller::kinks]
];
CheckOption[ShowHead,True|False,FullOpts];
CheckOption[ShowTail,True|False,FullOpts];
CheckOption[HeadRecess,_?NumericQ,FullOpts];
CheckOption[TailRecess,_?NumericQ,FullOpts];
If[
!MatchQ[ArrowType/.FullOpts,LineArrow|SquiggleArrow],
CheckOption[ShowTail,False,FullOpts]
];
CheckOption[ConversionSide,Left|Right,FullOpts];
CheckOption[ConversionCoeff,None|_?NumericQ|Infinity,FullOpts];
If[((ConversionCoeff/.FullOpts)=!=None)&&((HeadLip/.FullOpts)=!=0),Message[Caller::conversionlip]];
If[(AboveKinkL/.FullOpts)=!=False,Message[LevelScheme::abovekinkx]];
If[(AboveKinkR/.FullOpts)=!=False,Message[LevelScheme::abovekinkx]];
If[(AboveKinkC/.FullOpts)=!=False,Message[LevelScheme::abovekinkx]];

(* calculate arrow geometry -- absolute coordinates *)
AbsNodes=PAOfPC/@Nodes;
AbsNodes[[1]]=ArrowPoint[AbsNodes[[{1,2}]],AtTail,{(TailRecess/.FullOpts),0}];
AbsNodes[[-1]]=ArrowPoint[AbsNodes[[{-2,-1}]],AtHead,{-(HeadRecess/.FullOpts),0}];
AbsSegments=Partition[AbsNodes,2,1];
If[MemberQ[Chop/@SegmentLength/@AbsSegments,0],ErrorMessage[Caller::nullsegment,Nodes]];
Segment=AbsSegments[[-1]];  (* shorthand useful for single-segment arrow types *)
OptWidth=(Width/.FullOpts);
OptHeadLength=(HeadLength/.FullOpts);
OptHeadLip=(HeadLip/.FullOpts);
OptShaftLines = (ShaftLines/.FullOpts);
OptThickness=(Thickness/.FullOpts);

(* make arrow *)
LineArt=Switch[
(ArrowType/.FullOpts),
LineArrow,
{

(* shaft *)
MakeOutline[{Line[PCOfPA/@AbsNodes]},FullOpts] ,

(* head *)
If[ShowHead/.FullOpts,
MakeOutline[{Line[PCOfPA/@ArrowHeadPoints[AbsSegments[[-1]],OptHeadLength,OptHeadLip]]},Dashing->None,FullOpts]
],

(* tail *)
If[ShowTail/.FullOpts,
MakeOutline[{Line[PCOfPA/@ArrowHeadPoints[Reverse@AbsSegments[[1]],OptHeadLength,OptHeadLip]]},Dashing->None,FullOpts]
]

},
MultilineArrow,
{

ShaftPoints=Table[
ShaftPosition=OptWidth*(-1/2+i/(OptShaftLines-1));
Switch[
(TailBevel/.FullOpts),
False,
{ArrowPoint[Segment,AtTail,ShaftPosition],ArrowPoint[Segment,AtEdge,OptHeadLength,OptWidth/2+OptHeadLip,ShaftPosition]},
True,
{ArrowPoint[Segment,AtTailHorizontal,ShaftPosition],ArrowPoint[Segment,AtEdge,OptHeadLength,OptWidth/2+OptHeadLip,ShaftPosition]}
],
{i,0,OptShaftLines-1}
];

(* fill *)
MakeFill[
{
Polygon[PCOfPA/@Join[First[ShaftPoints],{Last[Segment]},Reverse[Last[ShaftPoints]]]]
},
FullOpts],

(* shaft lines *)
MakeOutline[
{
Table[
Line[PCOfPA/@ShaftPoints[[i]]],
{i,1,OptShaftLines}
]
},
FullOpts] ,

(* head *)
If[ShowHead/.FullOpts,
MakeOutline[{Line[PCOfPA/@ArrowHeadPoints[Segment,OptHeadLength,OptWidth/2+OptHeadLip]]},Dashing->None,FullOpts]
]
},
SquiggleArrow,
{
(* main segment *)
PointList=SquigglePoints[
Segment,
{
If[(ShowTail/.FullOpts),OptHeadLength,0]+(SquiggleBuffer/.FullOpts),
If[(ShowHead/.FullOpts),OptHeadLength,0]+(SquiggleBuffer/.FullOpts)
},
OptWidth/2,
(SquiggleWavelength/.FullOpts),
(SquiggleSide/.FullOpts),
(PlotPoints/.FullOpts)
];
MakeOutline[{Line[PCOfPA/@PointList]},FullOpts] ,

(* head *)
If[ShowHead/.FullOpts,
MakeOutline[{Line[PCOfPA/@ArrowHeadPoints[Segment,OptHeadLength,OptHeadLip]]},Dashing->None,FullOpts]
],

(* tail *)
If[ShowTail/.FullOpts,
MakeOutline[{Line[PCOfPA/@ArrowHeadPoints[Reverse@Segment,OptHeadLength,OptHeadLip]]},Dashing->None,FullOpts]
]

},
ShapeArrow,
{

PointList=Switch[
(TailBevel/.FullOpts),
False,
 {
First[Segment],
ArrowPoint[Segment,AtTail,-(OptWidth/2)],
ArrowPoint[Segment,AtLip,OptHeadLength,-(OptWidth/2)],ArrowPoint[Segment,AtLip,OptHeadLength,-(OptWidth/2+OptHeadLip)],
Last[Segment],
ArrowPoint[Segment,AtLip,OptHeadLength,+(OptWidth/2+OptHeadLip)],
ArrowPoint[Segment,AtLip,OptHeadLength,+(OptWidth/2)],
ArrowPoint[Segment,AtTail,+(OptWidth/2)]
},
True,
{
First[Segment],
ArrowPoint[Segment,AtTailHorizontal,-(OptWidth/2)],
ArrowPoint[Segment,AtLip,OptHeadLength,-(OptWidth/2)],
ArrowPoint[Segment,AtLip,OptHeadLength,-(OptWidth/2+OptHeadLip)],
Last[Segment],
ArrowPoint[Segment,AtLip,OptHeadLength,+(OptWidth/2+OptHeadLip)],
ArrowPoint[Segment,AtLip,OptHeadLength,+(OptWidth/2)],
ArrowPoint[Segment,AtTailHorizontal,+(OptWidth/2)]
}
];
PointList=Switch[
(ArrowHalf/.FullOpts),
All,PointList,
Left,Take[PointList,5],
Right,Take[RotateLeft[PointList],-5]
];
If[
(ConversionCoeff/.FullOpts)=!=None,
ConversionSideSign=Switch[(ConversionSide/.FullOpts),Left,+1,Right,-1];
ConversionWidth=If[
(ConversionCoeff/.FullOpts)==Infinity,
Width/.FullOpts,
(Width*ConversionCoeff/(1+ConversionCoeff))/.FullOpts
];
Conversiony=ConversionSideSign*((ConversionWidth-Width/2)/.FullOpts);
ConversionP0=Switch[
(TailBevel/.FullOpts),
False,
ArrowPoint[Segment,AtTail,Conversiony],
True,
ArrowPoint[Segment,AtTailHorizontal,Conversiony]
];
ConversionP4=ArrowPoint[Segment,AtEdge,OptHeadLength,(OptWidth/2+OptHeadLip),Conversiony];
ConversionPointList=Switch[
(ConversionSide/.FullOpts),
Left,
Join[
PointList[[{2,3,4}]], (* side points *)
If[Conversiony>0,PointList[[{5}]],{}], (* optional: tip *)
{ConversionP4,ConversionP0}  (* truncated side *)
],
Right,
Join[
PointList[[{8,7,6}]], (* side points *)
If[Conversiony<0,PointList[[{5}]],{}], (* optional: tip *)
{ConversionP4,ConversionP0} (* truncated side *)
]
]
];

MakeFill[
{
Polygon[PCOfPA/@PointList]
},
FullOpts],
If[(ConversionCoeff/.FullOpts)=!=None,
MakeFill[
{
Polygon[PCOfPA/@ConversionPointList]
},
FillColor->(ConversionColor/.FullOpts),FullOpts]
],
MakeOutline[
{
Line[PCOfPA/@(PointList~Append~First[PointList])]
},
FullOpts]
}

];

(* make labels *)

HalfWidthForLabels=Switch[(ArrowType/.FullOpts),
LineArrow,OptThickness/2,
MultilineArrow|SquiggleArrow|ShapeArrow,(OptWidth+OptThickness)/2
];

TextArt={
If[
((LabL/.FullOpts)=!=None)&&(ShowLabL/.FullOpts),
offl=GetAutoOption[OffsetL,
Switch[(OrientationL/.FullOpts),
Automatic,{0,0},
Inverted,{0,0},
Horizontal,{1,0},
Vertical,{1,0},
_, {0,0}
],
FullOpts
];
buffl=GetAutoOption[BufferL,
Switch[(OrientationL/.FullOpts),
Automatic,1.1,
Inverted,1.1,
Horizontal,0,
Vertical,0,
_, 1.1
],
FullOpts
];
SegmentPointsL=Switch[
(SegmentL/.FullOpts),
Automatic,AbsSegments[[-1]],
_Integer,AbsSegments[[(SegmentL/.FullOpts)]]
];
PLa=ArrowPoint[Caller,SegmentPointsL,AtUserPosition,GetAutoOption[PosnL,0.5,FullOpts],-(HalfWidthForLabels+buffl/2*(FontSize/.FullOpts))];
MakeText[(LabL/.FullOpts),PCOfPA[PLa],SegmentArcTan[SegmentPointsL],
ShowText->(ShowLabL/.FullOpts),
Offset->offl,
Nudge->(NudgeL/.FullOpts),
Orientation->(OrientationL/.FullOpts),
Background->(BackgroundL/.FullOpts),
FullOpts 
]
],

If[
((LabR/.FullOpts)=!=None)&&(ShowLabR/.FullOpts),
offr=GetAutoOption[OffsetR,
Switch[(OrientationR/.FullOpts),
Automatic,{0,0},
Inverted,{0,0},
Horizontal,{-1,0},
Vertical,{0,0},
_, {0,0}
],
FullOpts
];
buffr=GetAutoOption[BufferR,
Switch[(OrientationR/.FullOpts),
Automatic,1.1,
Inverted,1.1,
Horizontal,0,
Vertical,0,
_, 1.1
],
FullOpts
];
SegmentPointsR=Switch[
(SegmentR/.FullOpts),
Automatic,AbsSegments[[-1]],
_Integer,AbsSegments[[(SegmentR/.FullOpts)]]
];
PRa=ArrowPoint[Caller,SegmentPointsR,AtUserPosition,GetAutoOption[PosnR,0.5,FullOpts],+(HalfWidthForLabels+buffr/2*(FontSize/.FullOpts))];
MakeText[(LabR/.FullOpts), PCOfPA[PRa],SegmentArcTan[SegmentPointsR],
ShowText->(ShowLabR/.FullOpts),
Offset->offr,
Nudge->(NudgeR/.FullOpts),
Orientation->(OrientationR/.FullOpts),
Background->(BackgroundR/.FullOpts),
FullOpts 
]
],

If[
((LabC/.FullOpts)=!=None)&&(ShowLabC/.FullOpts),
offc=GetAutoOption[OffsetC,
{0,0},
FullOpts
];
SegmentPointsC=Switch[
(SegmentC/.FullOpts),
Automatic,AbsSegments[[-1]],
_Integer,AbsSegments[[(SegmentC/.FullOpts)]]
];
PCa=ArrowPoint[Caller,SegmentPointsC,AtUserPosition,GetAutoOption[PosnC,0.5,FullOpts],0];
MakeText[(LabC/.FullOpts), PCOfPA[PCa],SegmentArcTan[SegmentPointsC],
ShowText->(ShowLabC/.FullOpts),
Offset->offc,
Nudge->(NudgeC/.FullOpts),
Orientation->(OrientationC/.FullOpts),
Background->(BackgroundC/.FullOpts),
FullOpts 
]
],

If[
((LabT/.FullOpts)=!=None)&&(ShowLabT/.FullOpts),
SegmentPointsT=AbsSegments[[1]];
PTa=ArrowPoint[Caller,SegmentPointsT,AtUserPosition,GetAutoOption[PosnT,0,FullOpts],0];
(* calculate orientation and offset information for "Automatic" label *)
(* pre-6 rotation: reference point is of rotated box, defaults were {0,-1} 
post-6 rotation: reference point is of origintal box *)
theta0=SegmentArcTan[SegmentPointsT];
InversionSign=If[(-Pi/2<theta0)&&(theta0<=Pi/2),+1,-1];
offt=GetAutoOption[OffsetT,
Switch[(OrientationT/.FullOpts),
Automatic,{1,0}*InversionSign,
Inverted,-{1,0}*InversionSign,
Horizontal,{0,-1},
Vertical,{-1,0},
_, {0,0}
],
FullOpts
];
MakeText[(LabT/.FullOpts), PCOfPA[PTa],theta0,
ShowText->(ShowLabT/.FullOpts),
Offset->offt,
Nudge->(NudgeT/.FullOpts),
Orientation->(OrientationT/.FullOpts),
Background->(BackgroundT/.FullOpts),
FullOpts 
]
]

};

(* return completed artwork *)
Join[LineArt,TextArt]

];


Lev[ID_:None,xa0_?NumericQ,xb0_?NumericQ,EnergyStr:(_?NumericQ|_String),Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[Lev,Opts],
WingRiseWidthL,WingRiseWidthR,
WingTipWidthL,WingTipWidthR,
DefaultLabel,
PointList,
DerivedEnergyLabelFunction,
IDExpr,
ObjectTag
},

CheckInScheme[];
CheckValue[ID,IDExpr_?LevelIdentifierQ,"a level identifier symbol (cannot be list or number)"];
CheckOption[EnergyNudge,_?NumericQ,FullOpts];
CheckOption[WingHeight,_?NumericQ,FullOpts];
CheckOption[WingRiseWidth,(_?NumericQ)|{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[WingTipWidth,(_?NumericQ)|{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[MakeWingL,True|False,FullOpts];
CheckOption[MakeWingR,True|False,FullOpts];

(* label validation *)
CheckOption[ShowLabL,True|False,FullOpts];
CheckOption[ShowLabR,True|False,FullOpts];
CheckOption[ShowLabT,True|False,FullOpts];
CheckOption[ShowLabB,True|False,FullOpts];
CheckOption[ShowLabC,True|False,FullOpts];
CheckOption[DecimalDigits,Automatic|(_Integer?NonNegative)|{_Integer?NonNegative,_Integer?NonNegative},FullOpts];

(* Store level parameters *)
ObjectTag=If[
ID=!=None,
ID,
(Tag/.FullOpts)
];
$LastLevel=ObjectTag;
LevelScheme`Data`xa0[ObjectTag]=XCOfXU[xa0];
LevelScheme`Data`xb0[ObjectTag]=XCOfXU[xb0];
LevelScheme`Data`xa[ObjectTag]= XCOfXU[xa0+(Margin/.FullOpts)];
LevelScheme`Data`xb[ObjectTag]= XCOfXU[xb0-(Margin/.FullOpts)];
LevelScheme`Data`UserEnergy[ObjectTag]=Switch[EnergyStr,
_?NumericQ,EnergyStr,
_String,ToExpression[EnergyStr]
];
If[
!NumericQ[LevelScheme`Data`UserEnergy[ObjectTag]],
ErrorMessage[Lev::energystr,ObjectTag,EnergyStr]
];
LevelScheme`Data`Energy[ObjectTag] = YCOfYU[LevelScheme`Data`UserEnergy[ObjectTag]]+DYCOfYA[EnergyNudge/.FullOpts];
LevelScheme`Data`WingEnergy[ObjectTag] =LevelScheme`Data`Energy[ObjectTag]+DYCOfYA[WingHeight/.FullOpts];

{

(* Outline *)

{WingRiseWidthL,WingRiseWidthR}=UpgradeScalarXY[WingRiseWidth/.FullOpts];{WingTipWidthL,WingTipWidthR}=UpgradeScalarXY[WingTipWidth/.FullOpts];PointList=Join[
If[
(MakeWingL/.FullOpts)&&(WingHeight/.FullOpts)=!=0,
LevelScheme`Data`EnergyL[ObjectTag]=LevelScheme`Data`WingEnergy[ObjectTag];
{
{LevelScheme`Data`xa[ObjectTag] ,LevelScheme`Data`WingEnergy[ObjectTag]},
{LevelScheme`Data`xa[ObjectTag]+DXCOfXA[WingTipWidthL] ,LevelScheme`Data`WingEnergy[ObjectTag]},
{LevelScheme`Data`xa[ObjectTag]+DXCOfXA[WingTipWidthL] +DXCOfXA[WingRiseWidthL] ,LevelScheme`Data`Energy[ObjectTag]}
},
LevelScheme`Data`EnergyL[ObjectTag]=LevelScheme`Data`Energy[ObjectTag];
{
{LevelScheme`Data`xa[ObjectTag] ,LevelScheme`Data`Energy[ObjectTag]}
}
],
If[
(MakeWingR/.FullOpts)&&(WingHeight/.FullOpts)=!=0,
LevelScheme`Data`EnergyR[ObjectTag]=LevelScheme`Data`WingEnergy[ObjectTag];
{
{LevelScheme`Data`xb[ObjectTag]-DXCOfXA[WingTipWidthR] -DXCOfXA[WingRiseWidthR] ,LevelScheme`Data`Energy[ObjectTag]},
{LevelScheme`Data`xb[ObjectTag]-DXCOfXA[WingTipWidthR] ,LevelScheme`Data`WingEnergy[ObjectTag]},
{LevelScheme`Data`xb[ObjectTag],LevelScheme`Data`WingEnergy[ObjectTag]}
},
LevelScheme`Data`EnergyR[ObjectTag]=LevelScheme`Data`Energy[ObjectTag];
{
{LevelScheme`Data`xb[ObjectTag] ,LevelScheme`Data`Energy[ObjectTag]}
}
]
];

MakeOutline[
{
Line[PointList]
},
If[(LineToFront/.FullOpts),Layer->$SchemeTextLayer,{}],
FullOpts
],

(* Labels *)
(* energy label priority: (1) string, (2) specified function, (3) specified decimal digits, (4) pass-through *)
DerivedEnergyLabelFunction=If[
(EnergyLabelFunction/.FullOpts)===Automatic,
If[
(DecimalDigits/.FullOpts)===Automatic,
Identity,
(FixedPointForm[#,(DecimalDigits/.FullOpts)]&)
],
(EnergyLabelFunction/.FullOpts)
];

DefaultLabel=Switch[
EnergyStr,
_String,EnergyStr,
_?NumericQ,(DerivedEnergyLabelFunction/.FullOpts)@EnergyStr
];

MakeText[
GetAutoOption[LabL,DefaultLabel,FullOpts],
{LevelScheme`Data`xa[ObjectTag],LevelScheme`Data`EnergyL[ObjectTag]},
0,
ShowText->(ShowLabL/.FullOpts),
Offset->GetAutoOption[OffsetL,{-1,-.75},FullOpts],
Nudge->(NudgeL/.FullOpts),
Orientation->GetAutoOption[OrientationL,Horizontal,FullOpts],
Background->(BackgroundL/.FullOpts),
FullOpts 
],

MakeText[
GetAutoOption[LabC,DefaultLabel,FullOpts],
{(LevelScheme`Data`xa[ObjectTag]+LevelScheme`Data`xb[ObjectTag])/2,LevelScheme`Data`Energy[ObjectTag]},
0,
ShowText->(ShowLabC/.FullOpts),
Offset->GetAutoOption[OffsetC,{0,-.75},FullOpts],
Nudge->(NudgeC/.FullOpts),
Orientation->GetAutoOption[OrientationC,Horizontal,FullOpts],
Background->(BackgroundC/.FullOpts),
FullOpts 
],

MakeText[
GetAutoOption[LabR,DefaultLabel,FullOpts],
{LevelScheme`Data`xb[ObjectTag],LevelScheme`Data`EnergyR[ObjectTag]},
0,
ShowText->(ShowLabR/.FullOpts),
Offset->GetAutoOption[OffsetR,{+1,-.75},FullOpts],
Nudge->(NudgeR/.FullOpts),
Orientation->GetAutoOption[OrientationR,Horizontal,FullOpts],
Background->(BackgroundR/.FullOpts),
FullOpts 
],

MakeText[
GetAutoOption[LabT,DefaultLabel,FullOpts],
{(LevelScheme`Data`xa[ObjectTag]+LevelScheme`Data`xb[ObjectTag])/2,LevelScheme`Data`Energy[ObjectTag]},
0,
ShowText->(ShowLabT/.FullOpts),
Offset->GetAutoOption[OffsetT,{0,-.75},FullOpts],
Nudge->(NudgeT/.FullOpts),
Orientation->GetAutoOption[OrientationT,Horizontal,FullOpts],
Background->(BackgroundT/.FullOpts),
FullOpts 
],

MakeText[
GetAutoOption[LabB,DefaultLabel,FullOpts],
{(LevelScheme`Data`xa[ObjectTag]+LevelScheme`Data`xb[ObjectTag])/2,LevelScheme`Data`Energy[ObjectTag]},
0,
ShowText->(ShowLabB/.FullOpts),
Offset->GetAutoOption[OffsetB,{0,+1.0},FullOpts],
Nudge->(NudgeB/.FullOpts),
Orientation->GetAutoOption[OrientationB,Horizontal,FullOpts],
Background->(BackgroundB/.FullOpts),
FullOpts 
]

}
];


LastLevel:=Module[
{},
CheckInScheme[];
$LastLevel
];
LevelEnergy[ID_?LevelIdentifierQ] :=Module[
{},
CheckInScheme[];
CheckLevel[ID];
LevelScheme`Data`UserEnergy[ID]
];


BasicExtensionLine[ID_?LevelIdentifierQ,x1_,x2_,FullOpts_List] := Module[
{},
CheckInScheme[];
CheckLevel[ID];

{
MakeOutline[
{
If[
(ToWing/.FullOpts),
Line[{{x1,LevelScheme`Data`WingEnergy[ID]},{x2,LevelScheme`Data`WingEnergy[ID]}}],
Line[{{x1,LevelScheme`Data`Energy[ID]},{x2,LevelScheme`Data`Energy[ID]}}]
]
},
FullOpts
]
}
];
ExtensionLine[ID_?LevelIdentifierQ,Posn1_?NumericQ,Posn2_?NumericQ,Opts___?OptionQ] :=BasicExtensionLine[ID,LevelScheme`Data`xa0[ID] +DXCOfXU[Posn1],LevelScheme`Data`xa0[ID] +DXCOfXU[Posn2],FigRealizeOptions[ExtensionLine,Opts]];
ExtensionLine[ID_?LevelIdentifierQ,Left,Length_,Opts___?OptionQ] := BasicExtensionLine[ID,LevelScheme`Data`xa[ID]-DXCOfXU[Length],LevelScheme`Data`xa[ID],FigRealizeOptions[ExtensionLine,Opts]];
ExtensionLine[ID_?LevelIdentifierQ,Right,Length_,Opts___?OptionQ] := BasicExtensionLine[ID,LevelScheme`Data`xb[ID],LevelScheme`Data`xb[ID]+DXCOfXU[Length],FigRealizeOptions[ExtensionLine,Opts]];


Connector[IDi_?LevelIdentifierQ,IDf_?LevelIdentifierQ,Opts___?OptionQ] :=Module[
{
FullOpts=FigRealizeOptions[Connector,Opts]
},

CheckInScheme[];
CheckLevel[IDi];
CheckLevel[IDf];

MakeOutline[
{
Line[{{LevelScheme`Data`xb[IDi],LevelScheme`Data`EnergyR[IDi]},{LevelScheme`Data`xa[IDf],LevelScheme`Data`EnergyL[IDf]}}]
},
FullOpts
]
];


ArrowNodeQ[P_]:=MatchQ[P,{_?NumericQ,_?NumericQ}|FromHead[_?DoubleRadiusQ]|FromTail[_?DoubleRadiusQ]];


Trans[RawNodes:{PI:{_?NumericQ,_?NumericQ},(_?ArrowNodeQ)...,Pf:{_?NumericQ,_?NumericQ}},Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[Trans,Opts],
Nodes,R,P
},

CheckInScheme[];
CheckOption[Kink,FullOpts];

Nodes=Replace[
RawNodes,
{
P:{_?NumericQ,_?NumericQ}:>PCOfPU@P,
FromHead[R_]:>(PCOfPU@Pf+ConvertRadiusToCanvas[R]),
FromTail[R_]:>(PCOfPU@PI+ConvertRadiusToCanvas[R])
},
1
];

BasicArrow[Trans,Nodes,FullOpts]
];
Trans[PI:{_?NumericQ,_?NumericQ},Pf:{_?NumericQ,_?NumericQ},Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[Trans,Opts],
RawNodes,Nodes,R,P
},

CheckInScheme[];
CheckOption[Kink,None|_?ArrowNodeQ|{(_?ArrowNodeQ)...},FullOpts];

RawNodes=Join[
{PI},
Switch[
(Kink/.FullOpts),
None,{},
_?ArrowNodeQ,{(Kink/.FullOpts)},
{(_?ArrowNodeQ)...},(Kink/.FullOpts)
],
{Pf}
];
Nodes=Replace[
RawNodes,
{
P:{_?NumericQ,_?NumericQ}:>PCOfPU@P,
FromHead[R_]:>(PCOfPU@Pf+ConvertRadiusToCanvas[R]),
FromTail[R_]:>(PCOfPU@PI+ConvertRadiusToCanvas[R])
},
1
];

BasicArrow[Trans,Nodes,FullOpts]
];
Trans[IDi_?LevelIdentifierQ,IDf_?LevelIdentifierQ,Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[Trans,Opts],
xi,yi,xf,yf,
PI,Pf,
Posni,Posnf
},

CheckInScheme[];
CheckOption[EndPositions,{(_?NumericQ|Automatic),(_?NumericQ|Automatic)},FullOpts];
CheckLevel[IDi];
CheckLevel[IDf];
{Posni,Posnf}=(EndPositions/.FullOpts);

(* Calculate start, end, and optional kink points *)
(* PI and Pf are distance in band units from left origin of band *)
{xi,xf}=Which[
(Posni=!=Automatic)&&(Posnf=!=Automatic),
{LevelScheme`Data`xa0[IDi],LevelScheme`Data`xa0[IDf]}+DXCOfXU/@{Posni,Posnf},
(Posni=!=Automatic)&&(Posnf===Automatic),
{LevelScheme`Data`xa0[IDi],LevelScheme`Data`xa0[IDi]}+DXCOfXU/@{Posni,Posni},
(Posni===Automatic)&&(Posnf=!=Automatic),
{LevelScheme`Data`xa0[IDf],LevelScheme`Data`xa0[IDf]}+DXCOfXU/@{Posnf,Posnf},
True,
ErrorMessage[Trans::twoautos]
];
yi=If[FromWing/.FullOpts,LevelScheme`Data`WingEnergy[IDi],LevelScheme`Data`Energy[IDi]];
yf=If[ToWing/.FullOpts,LevelScheme`Data`WingEnergy[IDf],LevelScheme`Data`Energy[IDf]];
PI={xi,yi};
Pf={xf,yf};

Trans[PUOfPC@PI,PUOfPC@Pf,FullOpts]

];
Trans[IDi_?LevelIdentifierQ,Posni:(_?NumericQ|Automatic),IDf_?LevelIdentifierQ,Posnf:(_?NumericQ|Automatic),Opts___?OptionQ]:=Trans[IDi,IDf,EndPositions->{Posni,Posnf},Opts];


BasicLabel[P_,Contents_,Opts___?OptionQ] := Module[
{FullOpts=Flatten[{Opts}]},

MakeText[Contents,P,0,
(* pass on ShowText, Offset, Nudge, Orientation, Background, font style parameters, and Layer from FullOpts*)
FullOpts 
]
];


ManualLabel[P_,Contents_,Opts___?OptionQ] :=Module[
{
FullOpts=FigRealizeOptions[ManualLabel,Opts]
},

CheckInScheme[];
BasicLabel[PCOfPU[P],Contents,Offset->GetAutoOption[Offset,{0,0},FullOpts],FullOpts]
];   


BandLabel[ID_?LevelIdentifierQ,Contents_,Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[BandLabel,Opts]
},
CheckInScheme[];
CheckLevel[ID];
BasicLabel[{(LevelScheme`Data`xa[ID]+LevelScheme`Data`xb[ID])/2,LevelScheme`Data`Energy[ID]},Contents,Offset->GetAutoOption[Offset,{0,+1},FullOpts],FullOpts]
];

BandLabel[ID_?LevelIdentifierQ,Posn_?NumericQ,Contents_,Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[BandLabel,Opts]
},

CheckInScheme[];
CheckLevel[ID];
BasicLabel[{LevelScheme`Data`xa0[ID]+DXCOfXU[Posn],LevelScheme`Data`Energy[ID]},Contents,Offset->GetAutoOption[Offset,{0,+1},FullOpts],FullOpts]
];

ScaledLabel[Pr_,Contents_,Opts___?OptionQ] :=Module[
{
FullOpts=FigRealizeOptions[ScaledLabel,Opts]
},

CheckInScheme[];
BasicLabel[PCOfPS[Pr],Contents,Offset->GetAutoOption[Offset,{0,0},FullOpts],FullOpts]
];


BasicLevelLabel[ID_?LevelIdentifierQ,Posn:(Left|Right),Contents_,FullOpts_List] := Module[
{
P0,P1,P2,PLabel,Sense,NeedLine,GapValues
},

CheckOption[CallOutVector,None|{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[Gap,_?NumericQ|{_?NumericQ,_?NumericQ},FullOpts];

(* side options *)
Sense=Switch[Posn,Left,-1,Right,+1];
P0 = Switch[Posn,
Left,
{LevelScheme`Data`xa[ID],LevelScheme`Data`EnergyL[ID]},
Right,
{LevelScheme`Data`xb[ID],LevelScheme`Data`EnergyR[ID]}
];
GapValues=UpgradeScalarXY[Gap/.FullOpts];

(* call-out options *)
NeedLine=(CallOutVector/.FullOpts)=!=None;

(* point computation *)
If[NeedLine,
P1 =P0+Sense*{DXCOfXA @GapValues[[1]],0};
P2 =P1+DPCOfPA@(CallOutVector/.FullOpts);
PLabel =P2+Sense*{DXCOfXA @GapValues[[2]],0},
PLabel=P0+Sense*{DXCOfXA @GapValues[[2]],0}
];

{

(* Optional call-out line *)
If[NeedLine,
MakeOutline[{Line[{P1,P2}]},FullOpts]
],

(* Label *)
BasicLabel[PLabel,Contents,Offset->GetAutoOption[Offset,{-Sense,0},FullOpts],FullOpts]
}
];
BasicLevelLabel[ID_?LevelIdentifierQ,Posn:(Bottom|Top),Contents_,FullOpts_List] := Module[
{
P0,P1,P2,PLabel,Sense,NeedLine,GapValues
},

CheckOption[CallOutVector,None|{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[Gap,_?NumericQ|{_?NumericQ,_?NumericQ},FullOpts];

Sense=Switch[Posn,Bottom,-1,Top,+1];

{
(* Label *)
BasicLabel[{(LevelScheme`Data`xa[ID]+LevelScheme`Data`xb[ID])/2,LevelScheme`Data`Energy[ID]},Contents,Offset->GetAutoOption[Offset,{0,-Sense},FullOpts],FullOpts]
}
];
LevelLabel[ID_?LevelIdentifierQ,Posn:(Left|Right|Top|Bottom),Contents_,Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[LevelLabel,Opts]
},
CheckInScheme[];
CheckLevel[ID];
BasicLevelLabel[ID,Posn,Contents,FullOpts]
];


BasicLabel3D[P_,Contents_,FullOpts_List] := Module[
{},
MakeText3D[Contents,P,0,FullOpts ]
];


ManualLabel3D[P_,Contents_,Opts___?OptionQ] :=Module[
{
FullOpts=FigRealizeOptions[ManualLabel3D,Opts]
},
BasicLabel3D[P,Contents,OptionsUnion[Offset->GetAutoOption[Offset,{0,0},FullOpts],FullOpts]]
];   


BasicLine[Points_List,FullOpts_List]:=Module[
{},

(* option processing *)

CheckOption[HeadLength,_?NumericQ,FullOpts];
CheckOption[HeadLip,_?NumericQ,FullOpts];
CheckOption[ShowHead,True|False,FullOpts];
CheckOption[ShowTail,True|False,FullOpts];

(* object data *)
FigDefineObject[{Line->Points},FullOpts];

{

(* outline *)

MakeOutline[
{
Line[Points]
},
FullOpts],

If[ShowHead/.FullOpts,
MakeOutline[
{
Line[PCOfPA/@ArrowHeadPoints[PAOfPC/@Take[Points,-2],(HeadLength/.FullOpts),(HeadLip/.FullOpts)]]
},
Dashing->None,FullOpts
]
],

If[ShowTail/.FullOpts,
MakeOutline[
{
Line[PCOfPA/@ArrowHeadPoints[Reverse@(PAOfPC/@Take[Points,2]),(HeadLength/.FullOpts),(HeadLip/.FullOpts)]]
},
Dashing->None,FullOpts
]
],

(* text *)
BasicLineAnnotations[Points,FullOpts]

}
];
SchemeLine[Points:{{_?NumericQ,_?NumericQ}...},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeLine,Opts]
},
CheckInScheme[];
(*CheckValue[Points,{{_?NumericQ,_?NumericQ}...},"list of points given to SchemeLine"];*)
BasicLine[PCOfPU/@Points,FullOpts]
];
SchemeLine[g_Graphics,Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeLine,Opts],
CurveList,Curve
},
CheckInScheme[];
CheckOption[Join,True|False,FullOpts];

(* extract curves *)
CurveList=ExtractCurves[g];
If[(Join/.FullOpts),CurveList={Join@@CurveList}];

Table[
{
CheckValue[Curve,{{_?NumericQ,_?NumericQ}...},"list of points extracted from graphics given to SchemeLine"],
BasicLine[PCOfPU/@Curve,FullOpts]
},
{Curve,CurveList}
]
];


BasicPolygon[Points_List,FullOpts_List]:=Module[
{ClosedPoints,LineComplex},

(* option processing *)
CheckOption[ShowEdge,Automatic|(L:{(True|False)..}/;(Length[L]==Length[Points])),FullOpts];

(* choose edges to draw *)
ClosedPoints=Append[Points,First[Points]];
LineComplex=Switch[
(ShowEdge/.FullOpts),
Automatic,
ClosedPoints,
_List,
Pick[Partition[ClosedPoints,2,1],(ShowEdge/.FullOpts)]
];

{

(* Fill *)

MakeFill[
{
Polygon[Points]
},
FullOpts],

(* Outline *)

MakeOutline[
{
Line[LineComplex]
},
FullOpts]

}
];
SchemePolygon[Points:{{_?NumericQ,_?NumericQ}...},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemePolygon,Opts]
},
CheckInScheme[];
(*CheckValue[Points,{{_?NumericQ,_?NumericQ}...},"list of points given to SchemePolygon"];*)
BasicPolygon[PCOfPU/@Points,FullOpts]
];


BasicBox[{{x1_,x2_},{y1_,y2_}},FullOpts_List]:=Module[
{},

{

(* Fill *)
MakeFill[
{
Polygon[{{x1,y1},{x1,y2},{x2,y2},{x2,y1}}]
},
FullOpts],

(* Outline *)

MakeOutline[
{
Line[{{x1,y1},{x1,y2},{x2,y2},{x2,y1},{x1,y1}}]
},
FullOpts],

(* Labels *)

MakeText[(LabL/.FullOpts), {x1,(y1+y2)/2},0,
ShowText->(ShowLabL/.FullOpts),
Offset->GetAutoOption[OffsetL,{+1,0},FullOpts],
Nudge->(NudgeL/.FullOpts),
Orientation->(OrientationL/.FullOpts),
Background->(BackgroundL/.FullOpts),
FullOpts 
],

MakeText[(LabR/.FullOpts),{x2,(y1+y2)/2},0,
ShowText->(ShowLabR/.FullOpts),
Offset->GetAutoOption[OffsetR,{-1,0},FullOpts],
Nudge->(NudgeR/.FullOpts),
Orientation->(OrientationR/.FullOpts),
Background->(BackgroundR/.FullOpts),
FullOpts 
],

MakeText[(LabC/.FullOpts),{(x1+x2)/2,(y1+y2)/2},0,
ShowText->(ShowLabC/.FullOpts),
Offset->GetAutoOption[OffsetC,{0,0},FullOpts],
Nudge->(NudgeC/.FullOpts),
Orientation->(OrientationC/.FullOpts),
Background->(BackgroundC/.FullOpts),
FullOpts 
],

MakeText[(LabT/.FullOpts),{(x1+x2)/2,y2},0,
ShowText->(ShowLabT/.FullOpts),
Offset->GetAutoOption[OffsetT,{0,-1},FullOpts],
Nudge->(NudgeT/.FullOpts),
Orientation->(OrientationT/.FullOpts),
Background->(BackgroundT/.FullOpts),
FullOpts 
],

MakeText[(LabB/.FullOpts),{(x1+x2)/2,y1},0,
ShowText->(ShowLabB/.FullOpts),
Offset->GetAutoOption[OffsetB,{0,+1},FullOpts],
Nudge->(NudgeB/.FullOpts),
Orientation->(OrientationB/.FullOpts),
Background->(BackgroundB/.FullOpts),
FullOpts 
]

}
];
SchemeBox[{{x1_?NumericQ,x2_?NumericQ},{y1_?NumericQ,y2_?NumericQ}},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeBox,Opts]
},
CheckInScheme[];
BasicBox[{XCOfXU/@{x1,x2},YCOfYU/@{y1,y2}},FullOpts]
];
SchemeBox[{x1_?NumericQ,y1_?NumericQ},{x2_?NumericQ,y2_?NumericQ},Opts___?OptionQ]:=SchemeBox[{{x1,x2},{y1,y2}},Opts];
SchemeSquare[P:{_?NumericQ,_?NumericQ},R_?RadiusQ,Opts___?OptionQ]:=Module[
{
PC,xc,yc,RC,xr,yr,
FullOpts=FigRealizeOptions[SchemeSquare,Opts]
},
CheckInScheme[];
PC=PCOfPU@P;
RC=ConvertRadiusToCanvas@R;
If[RC===None,ErrorMessage[SchemeSquare::badr,R]];

{xc,yc}=PC;
{xr,yr}=RC;
BasicBox[{{xc-xr,xc+xr},{yc-yr,yc+yr}},FullOpts]
];


BasicCircle[P:{_?NumericQ,_?NumericQ},R:{_?NumericQ,_?NumericQ},{theta1_?NumericQ,theta2_?NumericQ},FullOpts_List]:=Module[
{OptPosnX,OptBufferX,theta,RX,PX,AngleX},

(* option processing *)

CheckOption[HeadLength,_?NumericQ,FullOpts];
CheckOption[HeadLip,_?NumericQ,FullOpts];
CheckOption[ShowHead,True|False,FullOpts];
CheckOption[ShowTail,True|False,FullOpts];
CheckOption[PosnX,Automatic|(_?NumericQ),FullOpts];

{

(* fill *)

MakeFill[
{
Disk[P,R,{theta1,theta2}]
},
FullOpts],

(* outline *)

MakeOutline[
{
Circle[P,R,{theta1,theta2}]
},
FullOpts],

If[ShowHead/.FullOpts,
MakeOutline[
{
Line[PCOfPA/@ArrowHeadPoints[PAOfPC[P+R*{Cos[theta2],Sin[theta2]}],VectorArcTan[-DPAOfPC[R*{Sin[theta2],-Cos[theta2]}]],(HeadLength/.FullOpts),(HeadLip/.FullOpts)]]
},
Dashing->None,FullOpts
]
],

If[ShowTail/.FullOpts,
MakeOutline[
{
Line[PCOfPA/@ArrowHeadPoints[PAOfPC[P+R*{Cos[theta1],Sin[theta1]}],VectorArcTan[+DPAOfPC[R*{Sin[theta1],-Cos[theta1]}]],(HeadLength/.FullOpts),(HeadLip/.FullOpts)]]
},
Dashing->None,FullOpts
]
],

(* labels *)

MakeText[(LabL/.FullOpts),P+R.{{-1,0},{0,0}},0,
ShowText->(ShowLabL/.FullOpts),
Offset->GetAutoOption[OffsetL,{+1,0},FullOpts],
Nudge->(NudgeL/.FullOpts),
Orientation->(OrientationL/.FullOpts),
Background->(BackgroundL/.FullOpts),
FullOpts 
],

MakeText[(LabR/.FullOpts),P+R.{{+1,0},{0,0}},0,
ShowText->(ShowLabR/.FullOpts),
Offset->GetAutoOption[OffsetR,{-1,0},FullOpts],
Nudge->(NudgeR/.FullOpts),
Orientation->(OrientationR/.FullOpts),
Background->(BackgroundR/.FullOpts),
FullOpts 
],

MakeText[(LabC/.FullOpts),P,0,
ShowText->(ShowLabC/.FullOpts),
Offset->GetAutoOption[OffsetC,{0,0},FullOpts],
Nudge->(NudgeC/.FullOpts),
Orientation->(OrientationC/.FullOpts),
Background->(BackgroundC/.FullOpts),
FullOpts 
],

MakeText[(LabT/.FullOpts),P+R.{{0,0},{0,+1}},0,
ShowText->(ShowLabT/.FullOpts),
Offset->GetAutoOption[OffsetT,{0,-1},FullOpts],
Nudge->(NudgeT/.FullOpts),
Orientation->(OrientationT/.FullOpts),
Background->(BackgroundT/.FullOpts),
FullOpts 
],

MakeText[(LabB/.FullOpts),P+R.{{0,0},{0,-1}},0,
ShowText->(ShowLabB/.FullOpts),
Offset->GetAutoOption[OffsetB,{0,+1},FullOpts],
Nudge->(NudgeB/.FullOpts),
Orientation->(OrientationB/.FullOpts),
Background->(BackgroundB/.FullOpts),
FullOpts 
],

OptPosnX=GetAutoOption[PosnX,0.5,FullOpts];
OptBufferX=GetAutoOption[BufferX,
Switch[(OrientationX/.FullOpts),
Automatic,1.1,
Inverted,1.1,
Horizontal,0,
Vertical,0,
_, 1.1
],
FullOpts
];
theta=Interpolate[0,1,theta1,theta2,OptPosnX];
RX=R*{Cos[theta],Sin[theta]};
AngleX=VectorArcTan[DPAOfPC[R*{Sin[theta],-Cos[theta]}]];
PX=P+RX+DPCOfPA[((Thickness/.FullOpts)/2+OptBufferX/2*(FontSize/.FullOpts))*RX/VectorLength[RX]];
MakeText[(LabX/.FullOpts),PX,AngleX,
ShowText->(ShowLabX/.FullOpts),
Offset->GetAutoOption[OffsetX,{0,0},FullOpts],
Nudge->(NudgeX/.FullOpts),
Orientation->(OrientationX/.FullOpts),
Background->(BackgroundX/.FullOpts),
FullOpts 
]

}
];
SchemeCircle[P:{_?NumericQ,_?NumericQ},R_?RadiusQ,{theta1_?NumericQ,theta2_?NumericQ},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeCircle,Opts],
RC
},

CheckInScheme[];

RC=ConvertRadiusToCanvas[R];
If[RC===None,ErrorMessage[SchemeCircle::badr,R]];

BasicCircle[PCOfPU[P],RC,{theta1,theta2},FullOpts]
];
SchemeCircle[P:{_?NumericQ,_?NumericQ},R_?RadiusQ,Opts___?OptionQ]:=SchemeCircle[P,R,{0,2*Pi},Opts];


BasicEllipse[P:{_?NumericQ,_?NumericQ},R:{a_?NumericQ,b_?NumericQ},theta0_?NumericQ,{theta1_?NumericQ,theta2_?NumericQ},Closed:(True|False),FullOpts_List]:=Module[
{OptPosnX,OptBufferX,theta,r,RX,PX,AngleX,Points},

(* option processing *)

CheckOption[HeadLength,_?NumericQ,FullOpts];
CheckOption[HeadLip,_?NumericQ,FullOpts];
CheckOption[ShowHead,True|False,FullOpts];
CheckOption[ShowTail,True|False,FullOpts];
CheckOption[PosnX,Automatic|(_?NumericQ),FullOpts];

(* TO DO: validity checks on angles *)
If[2*Pi/(PlotPoints/.FullOpts)>(theta2-theta1),ErrorMessage[]];

Points=Table[
r=Sqrt[a^2*b^2/(a^2*Sin[theta]^2+b^2*Cos[theta]^2)];
P+DPCOfPU@{r*Cos[theta+theta0],r*Sin[theta+theta0]},
{theta,theta1,theta2,2*Pi/(PlotPoints/.FullOpts)}
];

{

(* fill *)

MakeFill[
{
Polygon[If[Closed,Points,Append[Points,P]]]
},
FullOpts
],

(* outline *)

MakeOutline[
{
Line[If[Closed,Append[Points,First[Points]],Points]]
},
FullOpts
],

(* TO DO: Implement arrowheads and labels *)

If[ShowHead/.FullOpts,
MakeOutline[
{
r=Sqrt[a^2*b^2/(a^2*Sin[theta2]^2+b^2*Cos[theta2]^2)];
Line[PCOfPA/@ArrowHeadPoints[
PAOfPC[P+DPCOfPU@{r*Cos[theta2+theta0],r*Sin[theta2+theta0]}],
VectorArcTan[-DPAOfPC[R*{Sin[theta2],-Cos[theta2]}]]+theta0, (* TO DO: angle *)
(HeadLength/.FullOpts),(HeadLip/.FullOpts)]
]
},
Dashing->None,FullOpts
]
],

If[ShowTail/.FullOpts,
MakeOutline[
{
},
Dashing->None,FullOpts
]
],

(* labels *)

MakeText[(LabL/.FullOpts),P+R.{{-1,0},{0,0}},0,
ShowText->(ShowLabL/.FullOpts),
Offset->GetAutoOption[OffsetL,{+1,0},FullOpts],
Nudge->(NudgeL/.FullOpts),
Orientation->(OrientationL/.FullOpts),
Background->(BackgroundL/.FullOpts),
FullOpts 
],

MakeText[(LabR/.FullOpts),P+R.{{+1,0},{0,0}},0,
ShowText->(ShowLabR/.FullOpts),
Offset->GetAutoOption[OffsetR,{-1,0},FullOpts],
Nudge->(NudgeR/.FullOpts),
Orientation->(OrientationR/.FullOpts),
Background->(BackgroundR/.FullOpts),
FullOpts 
],

MakeText[(LabC/.FullOpts),P,0,
ShowText->(ShowLabC/.FullOpts),
Offset->GetAutoOption[OffsetC,{0,0},FullOpts],
Nudge->(NudgeC/.FullOpts),
Orientation->(OrientationC/.FullOpts),
Background->(BackgroundC/.FullOpts),
FullOpts 
],

MakeText[(LabT/.FullOpts),P+R.{{0,0},{0,+1}},0,
ShowText->(ShowLabT/.FullOpts),
Offset->GetAutoOption[OffsetT,{0,-1},FullOpts],
Nudge->(NudgeT/.FullOpts),
Orientation->(OrientationT/.FullOpts),
Background->(BackgroundT/.FullOpts),
FullOpts 
],

MakeText[(LabB/.FullOpts),P+R.{{0,0},{0,-1}},0,
ShowText->(ShowLabB/.FullOpts),
Offset->GetAutoOption[OffsetB,{0,+1},FullOpts],
Nudge->(NudgeB/.FullOpts),
Orientation->(OrientationB/.FullOpts),
Background->(BackgroundB/.FullOpts),
FullOpts 
],

OptPosnX=GetAutoOption[PosnX,0.5,FullOpts];
OptBufferX=GetAutoOption[BufferX,
Switch[(OrientationX/.FullOpts),
Automatic,1.1,
Inverted,1.1,
Horizontal,0,
Vertical,0,
_, 1.1
],
FullOpts
];
theta=Interpolate[0,1,theta1,theta2,OptPosnX];
RX=R*{Cos[theta],Sin[theta]};
AngleX=VectorArcTan[DPAOfPC[R*{Sin[theta],-Cos[theta]}]];
PX=P+RX+DPCOfPA[((Thickness/.FullOpts)/2+OptBufferX/2*(FontSize/.FullOpts))*RX/VectorLength[RX]];
MakeText[(LabX/.FullOpts),PX,AngleX,
ShowText->(ShowLabX/.FullOpts),
Offset->GetAutoOption[OffsetX,{0,0},FullOpts],
Nudge->(NudgeX/.FullOpts),
Orientation->(OrientationX/.FullOpts),
Background->(BackgroundX/.FullOpts),
FullOpts 
]

}
];
SchemeEllipse[P:{_?NumericQ,_?NumericQ},R_?RadiusQ,theta0_?NumericQ,{theta1_?NumericQ,theta2_?NumericQ},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeEllipse,Opts]
},

CheckInScheme[];

BasicEllipse[PCOfPU[P],ConvertRadiusToCanvas[R],theta0,{theta1,theta2},False,FullOpts]
];
SchemeEllipse[P:{_?NumericQ,_?NumericQ},R_?RadiusQ,theta0_?NumericQ,Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeEllipse,Opts]
},

CheckInScheme[];

BasicEllipse[PCOfPU[P],ConvertRadiusToCanvas[R],theta0,{0,2*Pi},True,FullOpts]
];
SchemeEllipse[P:{_?NumericQ,_?NumericQ},R_?RadiusQ,Opts___?OptionQ]:=SchemeEllipse[P,R,0,Opts];


SchemeArrow[RawNodes:{PI:{_?NumericQ,_?NumericQ},(_?ArrowNodeQ)...,Pf:{_?NumericQ,_?NumericQ}},Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[SchemeArrow,Opts],
Nodes,R,P
},

CheckInScheme[];
CheckOption[Kink,None,FullOpts];

Nodes=Replace[
RawNodes,
{
P:{_?NumericQ,_?NumericQ}:>PCOfPU@P,
FromHead[R_]:>(PCOfPU@Pf+ConvertRadiusToCanvas[R]),
FromTail[R_]:>(PCOfPU@PI+ConvertRadiusToCanvas[R])
},
1
];

BasicArrow[SchemeArrow,Nodes,FullOpts]
];
SchemeArrow[PI:{_?NumericQ,_?NumericQ},Pf:{_?NumericQ,_?NumericQ},Opts___?OptionQ] := Module[
{
FullOpts=FigRealizeOptions[SchemeArrow,Opts],
RawNodes,Nodes,R,P
},

CheckInScheme[];
CheckOption[Kink,None|_?ArrowNodeQ|{(_?ArrowNodeQ)...},FullOpts];

RawNodes=Join[
{PI},
Switch[
(Kink/.FullOpts),
None,{},
_?ArrowNodeQ,{(Kink/.FullOpts)},
{(_?ArrowNodeQ)...},(Kink/.FullOpts)
],
{Pf}
];
Nodes=Replace[
RawNodes,
{
P:{_?NumericQ,_?NumericQ}:>PCOfPU@P,
FromHead[R_]:>(PCOfPU@Pf+ConvertRadiusToCanvas[R]),
FromTail[R_]:>(PCOfPU@PI+ConvertRadiusToCanvas[R])
},
1
];

BasicArrow[SchemeArrow,Nodes,FullOpts]
];


BasicSchemeBracket[Caller_Symbol,{{x1_,x2_},{y1_,y2_}},Axis:(1|2|3|4),FullOpts_List]:=Module[
{
Segment,HalfWidthForLabels,Buffer,Posn,P,
LabelGraphics,
ArrowHeadSign,
Points
},

(* calculate geometry *)
Segment=Switch[Axis,
1,{{x1,y1},{x2,y1}},
2,{{x1,y1},{x1,y2}},
3,{{x1,y2},{x2,y2}},
4,{{x2,y1},{x2,y2}}
];
ArrowHeadSign=Switch[Axis,
1|4,+1,
2|3,-1
];
(* construct axis label *)
(* basic spacing provided by Offset, additional by Buffer *)
HalfWidthForLabels=(Thickness/.FullOpts)/2;
Buffer=GetAutoOption[Switch[Axis,1,BufferB,2,BufferL,3,BufferT,4,BufferR],1.1,FullOpts];
Posn=GetAutoOption[Switch[Axis,1,PosnB,2,PosnL,3,PosnT,4,PosnR],0.5,FullOpts];
P=PCOfPA@ArrowPoint[Caller,PAOfPC/@Segment,AtUserPosition,Posn,Switch[Axis,1|4,-1,2|3,+1]*(HalfWidthForLabels+Buffer/2*(FontSize/.FullOpts))];

LabelGraphics={
Switch[
Axis,
1,
MakeText[(LabB/.FullOpts),P,0,
ShowText->(ShowLabB/.FullOpts),
Offset->GetAutoOption[OffsetB,{0,0},FullOpts],
Nudge->(NudgeB/.FullOpts),
Orientation->(OrientationB/.FullOpts),
Background->(BackgroundB/.FullOpts),
FullOpts 
],
2,
MakeText[(LabL/.FullOpts),P,-Pi/2,
ShowText->(ShowLabL/.FullOpts),
Offset->GetAutoOption[OffsetL,{0,0},FullOpts],
Nudge->(NudgeL/.FullOpts),
Orientation->(OrientationL/.FullOpts),
Background->(BackgroundL/.FullOpts),
FullOpts 
],
3,
MakeText[(LabT/.FullOpts),P,0,
ShowText->(ShowLabT/.FullOpts),
Offset->GetAutoOption[OffsetT,{0,0},FullOpts],
Nudge->(NudgeT/.FullOpts),
Orientation->(OrientationT/.FullOpts),
Background->(BackgroundT/.FullOpts),
FullOpts 
],
4,
MakeText[(LabR/.FullOpts),P,-Pi/2,
ShowText->(ShowLabR/.FullOpts),
Offset->GetAutoOption[OffsetR,{0,0},FullOpts],
Nudge->(NudgeR/.FullOpts),
Orientation->(OrientationR/.FullOpts),
Background->(BackgroundR/.FullOpts),
FullOpts 
]
]
};

(* Combine ticks with axis line *)
Points=Join[
Take[PCOfPA/@ArrowHeadPoints[PAOfPC/@Reverse@Segment,-HeadLength/.FullOpts,HeadLip/.FullOpts],-1*ArrowHeadSign],
Segment,
Take[PCOfPA/@ArrowHeadPoints[PAOfPC/@Segment,-HeadLength/.FullOpts,HeadLip/.FullOpts],+1*ArrowHeadSign]
];
Flatten[{
(* axis line *)
MakeOutline[{Line[Points]},FullOpts],
(* labels *)
LabelGraphics
}]

];
SchemeBracket[Side:(Bottom|Top),{xa_?NumericQ,xb_?NumericQ},y_?NumericQ,Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeBracket,Opts],
yNudged
},

CheckInScheme[];
CheckOption[EnergyNudge,_?NumericQ,FullOpts];

yNudged=y+(EnergyNudge/.FullOpts);
Switch[
Side,
Bottom,
BasicSchemeBracket[SchemeBracket,{{XCOfXU[xa],XCOfXU[xb]},{YCOfYU[yNudged],Null}},1,FullOpts],
Top,
BasicSchemeBracket[SchemeBracket,{{XCOfXU[xa],XCOfXU[xb]},{Null,YCOfYU[yNudged]}},3,FullOpts]
]
];
SchemeBracket[Side:(Left|Right),x_?NumericQ,{ya_?NumericQ,yb_?NumericQ},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeBracket,Opts]
},

CheckInScheme[];

Switch[
Side,
Left,
BasicSchemeBracket[SchemeBracket,{{XCOfXU[x],Null},{YCOfYU[ya],YCOfYU[yb]}},2,FullOpts],
Right,
BasicSchemeBracket[SchemeBracket,{{Null,XCOfXU[x]},{YCOfYU[ya],YCOfYU[yb]}},4,FullOpts]
]
];
SchemeBracket[Side:(Bottom|Top),{IDi_?LevelIdentifierQ,IDf_?LevelIdentifierQ},y_,Opts___?OptionQ]:=Module[
{},

CheckInScheme[];
CheckLevel[IDi];
CheckLevel[IDf];

SchemeBracket[Side,{XUOfXC@LevelScheme`Data`xa[IDi],XUOfXC@LevelScheme`Data`xb[IDf]},y,Opts]
];
SchemeBracket[Side:(Bottom|Top),{x1_,x2_},IDy_?LevelIdentifierQ,Opts___?OptionQ]:=Module[
{},

CheckInScheme[];
CheckLevel[IDy];

SchemeBracket[Side,{x1,x2},YUOfYC@LevelScheme`Data`Energy[IDy],Opts]
];
SchemeBracket[Side:(Left|Right),x_?NumericQ,{IDi_?LevelIdentifierQ,IDf_?LevelIdentifierQ},Opts___?OptionQ]:=Module[
{},

CheckInScheme[];
CheckLevel[IDi];
CheckLevel[IDf];

SchemeBracket[Side,x,{YUOfYC@LevelScheme`Data`Energy[IDi],YUOfYC@LevelScheme`Data`Energy[IDf]},Opts]
];



ArrowHeadPoints3D[{P1_,P2_},HeadLength_,HeadLip_,HeadAngle_] := Module[
{v,Normv,u,
alpha,beta,gamma,
R
},
v=P2-P1;
Normv=Sqrt[Plus@@((#^2&)/@v)];
u=If[Normv==0.,{0,0,1},v/Normv];
alpha=HeadAngle;
beta=ArcCos[u[[3]]];
gamma=Pi/2-VectorArcTan[{u[[1]],u[[2]]}];
R=RotationMatrix3D[alpha,beta,gamma];
{
P2+R.{+HeadLip,0.,-HeadLength},
P2,
P2+R.{-HeadLip,0.,-HeadLength}
}
];
BasicArrow3D[Caller_Symbol,PI_,Pf_,HeadAngle_,FullOpts_List] := Module[
{OptWidth,OptHeadLength,OptHeadLip,OptThickness,Segment,TailSegment,PC,Art},

CheckOption[ArrowType,LineArrow,FullOpts];
CheckOption[HeadLength,_?NumericQ,FullOpts];
CheckOption[HeadLip,_?NumericQ,FullOpts];
CheckOption[ShowHead,True|False,FullOpts];
CheckOption[ShowTail,True|False,FullOpts];
CheckOption[PosnC,Automatic|(_?NumericQ),FullOpts];

(* calculate arrow geometry *)
OptWidth=(Width/.FullOpts);
OptHeadLength=(HeadLength/.FullOpts);
OptHeadLip=(HeadLip/.FullOpts);
OptThickness=(Thickness/.FullOpts);
Segment={PI,Pf};
TailSegment=Segment;

PC=PI+(Pf-PI)*GetAutoOption[PosnC,0.5,FullOpts];

Art={

(* main segment *)
MakeOutline3D[{Line[Segment]},FullOpts] ,

(* head *)
If[ShowHead/.FullOpts,
MakeOutline3D[{Line[ArrowHeadPoints3D[Segment,OptHeadLength,OptHeadLip,HeadAngle]]},Dashing->None,FullOpts],
{}
],

(* tail *)
If[ShowTail/.FullOpts,
MakeOutline3D[{Line[ArrowHeadPoints3D[Reverse@TailSegment,OptHeadLength,OptHeadLip,HeadAngle]]},Dashing->None,FullOpts],
{}
],

(* label *)
MakeText3D[(LabC/.FullOpts), PC,0,
ShowText->(ShowLabC/.FullOpts),
Offset->GetAutoOption[OffsetC,{0,0},FullOpts],
Orientation->(OrientationC/.FullOpts),
Background->(BackgroundC/.FullOpts),
FullOpts 
]

};

Flatten[Art]
];


SchemeArrow3D[PI:{_?NumericQ,_?NumericQ,_?NumericQ},Pf:{_?NumericQ,_?NumericQ,_?NumericQ},HeadAngle:(_?NumericQ):0,Opts___?OptionQ] :=Module[
{
FullOpts=FigRealizeOptions[SchemeArrow3D,Opts]
},
BasicArrow3D[SchemeArrow3D,PI,Pf,HeadAngle,FullOpts]
];   


BasicLine3D[Points_List,FullOpts_List] := Module[
{},
{
(* outline *)
MakeOutline3D[
{
Line[Points]
},
FullOpts]
}
];


SchemeLine3D[Points:{{_?NumericQ,_?NumericQ,_?NumericQ}...},Opts___?OptionQ] :=Module[
{
FullOpts=FigRealizeOptions[SchemeLine3D,Opts]
},
BasicLine3D[Points,FullOpts]
];   


SchemeScaleP[Offset[DPA:{_?NumericQ,_?NumericQ},GeneralP_]]:=DPCOfPA[DPA]+SchemeScaleP[GeneralP];
SchemeScaleP[Scaled[DPS:{_?NumericQ,_?NumericQ},PU:{_?NumericQ,_?NumericQ}]]:=DPCOfPS[DPS]+PCOfPU[PU];
SchemeScaleP[Scaled[PS:{_?NumericQ,_?NumericQ}]]:=PCOfPS[PS];
SchemeScaleP[PU:{_?NumericQ,_?NumericQ}]:=PCOfPU[PU];
SchemeScaleP[x_]:=ErrorMessage[RawGraphics::badpoint,Expr];


SpecialPointRules={
Offset[dP:{dx_,dy_},P:{x_,y_}]:>(P+DPUOfPA[dP])
};


(* basic case --Graphics with only primatives list as argument *)
RawGraphics[GraphicsSeq:(Graphics[_List]...),Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[RawGraphics,Opts],
ScaledGraphicsList,ClippedGraphicsList,Result
},

CheckInScheme[];
CheckOption[ClipToRectangle,True|False|{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},FullOpts];
CheckOption[Show,True|False,FullOpts];
CheckOption[Debug,True|False,FullOpts];

If[Debug/.FullOpts,Print["RawGraphics: Given"]];
If[Debug/.FullOpts,Print[First/@{GraphicsSeq}]];

If[Debug/.FullOpts,Print["RawGraphics: Scaling"]];
ScaledGraphicsList={GraphicsSeq}/.SpecialPointRules;
ScaledGraphicsList=(TransformGraphics[#,(SchemeScaleP[#]&)]&)/@ScaledGraphicsList;
If[Debug/.FullOpts,Print[First/@ScaledGraphicsList]];

If[Debug/.FullOpts,Print["RawGraphics: Cropping ",$RegionRange]];
ClippedGraphicsList=Switch[
ClipToRectangle/.FullOpts,
True,(ClipToRectangle[$RegionRange,#]&)/@ScaledGraphicsList,
{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},(ClipToRectangle[ConvertCoordinate[RegionCoords,CanvasCoords,C,ClipToRectangle/.FullOpts],#]&)/@ScaledGraphicsList,
False,ScaledGraphicsList
];
If[Debug/.FullOpts,Print[First/@ClippedGraphicsList]];

If[Debug/.FullOpts,Print["RawGraphics: Making"]];
Result=MakeRawGraphics[{First/@ClippedGraphicsList},FullOpts];
If[Debug/.FullOpts,Print[Result]];
Result
];

(* typecast ContourGraphics or DensityGraphics to Graphics *)
RawGraphics[X___,G:(_ContourGraphics|_DensityGraphics),Y___]:=Module[
{},
RawGraphics[X,Graphics[G],Y]
];
(* strip graphics options *)
RawGraphics[X___,Graphics[Arg_,__?OptionQ],Y___]:=Module[
{},
RawGraphics[X,Graphics[Arg],Y]
];
(* discard graphics with no argument *)
RawGraphics[X___,Graphics[],Y___]:=Module[
{},
Message[RawGraphics::empty];
RawGraphics[X,Y]
];
(* wrap any non-list first element of graphics object -- syntax not documented by Mathematica but supported by show and can occur in Graphics cast of DensityGraphics *)
RawGraphics[X___,Graphics[Primative_/;(Head[Primative]=!=List)],Y___]:=Module[
{},
RawGraphics[X,Graphics[{Primative}],Y]
];
(* discard graphics with more than one non-option argument *)
RawGraphics[X___,Graphics[_,___,Arg/;(!OptionQ[Arg]),___],Y___]:=Module[
{},
Message[RawGraphics::multiarg];
RawGraphics[X,Y]
];


FigGraphics[UserRegion:{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},(x_Image)|(x_Graphics)|{(x_Graphics)},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[RawGraphics,Opts],
CanvasRegion,CanvasCenter,CanvasSize,Art
},

CheckInScheme[];
CheckOption[Show,True|False,FullOpts];
CheckOption[Debug,True|False,FullOpts];

(* calculate center and size coordinates for image inset *)
CanvasRegion=ConvertRegion[UserCoords,CanvasCoords,UserRegion];
CanvasCenter=Mean/@CanvasRegion;
CanvasSize=-Subtract@@@CanvasRegion;

(* generate art *)
If[(Debug/.FullOpts),
Print[Head[x]];
If[Head[x]==Graphics,Print[Short[First[x]]]];
Print[Rest[List@@x]]
];
Art={Inset[x,CanvasCenter,Center,CanvasSize]};
MakeVerbatim[Art,FullOpts]
];


FigGraphics[Graphics[GPrimatives_List,GOptionSeq___],Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[RawGraphics,Opts],
ScaledGraphicsList,ClippedGraphicsList,Result
},

CheckInScheme[];
CheckOption[ClipToRectangle,True|False|{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},FullOpts];
CheckOption[Show,True|False,FullOpts];
CheckOption[Debug,True|False,FullOpts];

(* TO WRITE... *)

If[Debug/.FullOpts,Print["RawGraphics: Scaling"]];
ScaledGraphicsList={GraphicsSeq}/.SpecialPointRules;
ScaledGraphicsList=(TransformGraphics[#,(SchemeScaleP[#]&)]&)/@ScaledGraphicsList;
If[Debug/.FullOpts,Print[First/@ScaledGraphicsList]];

If[Debug/.FullOpts,Print["RawGraphics: Cropping ",$RegionRange]];
ClippedGraphicsList=Switch[
ClipToRectangle/.FullOpts,
True,(ClipToRectangle[$RegionRange,#]&)/@ScaledGraphicsList,
{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},(ClipToRectangle[ConvertCoordinate[RegionCoords,CanvasCoords,C,ClipToRectangle/.FullOpts],#]&)/@ScaledGraphicsList,
False,ScaledGraphicsList
];
If[Debug/.FullOpts,Print[First/@ClippedGraphicsList]];

If[Debug/.FullOpts,Print["RawGraphics: Making"]];
Result=MakeRawGraphics[{First/@ClippedGraphicsList},FullOpts];
If[Debug/.FullOpts,Print[Result]];
Result
];

(* typecast ContourGraphics or DensityGraphics to Graphics *)
RawGraphics[X___,G:(_ContourGraphics|_DensityGraphics),Y___]:=Module[
{},
RawGraphics[X,Graphics[G],Y]
];
(* strip graphics options *)
RawGraphics[X___,Graphics[Arg_,__?OptionQ],Y___]:=Module[
{},
RawGraphics[X,Graphics[Arg],Y]
];
(* discard graphics with no argument *)
RawGraphics[X___,Graphics[],Y___]:=Module[
{},
Message[RawGraphics::empty];
RawGraphics[X,Y]
];
(* wrap any non-list first element of graphics object -- syntax not documented by Mathematica but supported by show and can occur in Graphics cast of DensityGraphics *)
RawGraphics[X___,Graphics[Primative_/;(Head[Primative]=!=List)],Y___]:=Module[
{},
RawGraphics[X,Graphics[{Primative}],Y]
];
(* discard graphics with more than one non-option argument *)
RawGraphics[X___,Graphics[_,___,Arg/;(!OptionQ[Arg]),___],Y___]:=Module[
{},
Message[RawGraphics::multiarg];
RawGraphics[X,Y]
];


RawGraphics3D[GraphicsSeq:(___?Graphics3DQ),Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[RawGraphics3D,Opts]
},

CheckInScheme[];
CheckOption[Show,True|False,FullOpts];
CheckOption[Debug,True|False,FullOpts];

MakeRawGraphics3D[First/@{GraphicsSeq},FullOpts]
];


Graphics3DQ[_Graphics3D]=True;
Graphics3DQ[_]=False;


(* drop nongraphical *)
CombineGraphics3D[{U___,X_/;(!MatchQ[X,(_?Graphics3DQ)|(_SurfaceGraphics)]),V___}]:=CombineGraphics3D[{U,V}];
(* convert SurfaceGraphics to Graphics3D *)
CombineGraphics3D[{U___,X_SurfaceGraphics,V___}]:=CombineGraphics3D[{U,Graphics3D[X],V}];
(* do combination -- primatives quarantined in sublists *)
CombineGraphics3D[GList:{___?Graphics3DQ}]:=Graphics3D[First/@GList];


AxisRotationMatrix[1,theta_,Sign:(+1|-1)]:={{1,0,0},{0,Cos[theta],-Sign*Sin[theta]},{0,+Sign*Sin[theta],Cos[theta]}};
AxisRotationMatrix[2,theta_,Sign:(+1|-1)]:={{Cos[theta],0,+Sign*Sin[theta]},{0,1,0},{-Sign*Sin[theta],0,Cos[theta]}};
AxisRotationMatrix[3,theta_,Sign:(+1|-1)]:={{Cos[theta],-Sign*Sin[theta],0},{+Sign*Sin[theta],Cos[theta],0},{0,0,1}};


RotationMatrix3DActiveY[{alpha_,beta_,gamma_}]:=AxisRotationMatrix[3,gamma,+1].AxisRotationMatrix[2,beta,+1].AxisRotationMatrix[3,alpha,+1];


SetAttributes[BasicViewPort3D,HoldFirst];
BasicViewPort3D[GList_List,{{x1c_?NumericQ,x2c_?NumericQ},{y1c_?NumericQ,y2c_?NumericQ}},FullOpts_List]:=Module[
{
ScaledGraphicsList,ClippedGraphicsList,Result,
Primatives,RotationMatrix,UsedOptions
},

CheckInScheme[];
CheckOption[Background,None|ColorDirectivePattern,FullOpts];
CheckOption[BackgroundOpacity,_?NumericQ,FullOpts];
CheckOption[Show,True|False,FullOpts];
CheckOption[BlockOptions,{___Symbol},FullOpts];
CheckOption[Debug,True|False,FullOpts];
CheckOption[EulerRotation,None|{_?NumericQ,_?NumericQ,_?NumericQ}];
CheckOption[PlotRange,Automatic|All|{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}}];CheckOption[AxisScaling,Automatic|{_?NumericQ,_?NumericQ,_?NumericQ}];
If[
((AxisScaling/.FullOpts)=!=Automatic)&&!MatchQ[(PlotRange/.FullOpts),{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}}],
ErrorMessage[ViewPort3D::prange]
];

Primatives=BlockOptions[
Union[OptionSymbols3D,(BlockOptions/.FullOpts)],
First[CombineGraphics3D[Flatten[GList]]]
];
If[
(EulerRotation/.FullOpts)=!=None,
RotationMatrix=RotationMatrix3DActiveY[EulerRotation/.FullOpts];
Primatives=GeometricTransformation[Primatives,RotationMatrix]
];
If[(Debug/.FullOpts),Print[Primatives]];
UsedOptions=OptionsUnion[
{
If[
(AxisScaling/.FullOpts)===Automatic,
{},
{BoxRatios->(AxisScaling/.FullOpts)*-Subtract@@@(PlotRange/.FullOpts)}
],
LegacyFilterOptions[Graphics3D,FullOpts]
}
];
If[(Debug/.FullOpts),Print[UsedOptions]];

{
(* background *)
If[
(Background/.FullOpts)=!=None,
MakeFill[
{Rectangle[{x1c,y1c},{x2c,y2c}]},
Color->(Background/.FullOpts),Opacity->(BackgroundOpacity/.FullOpts),
ShowFill->True,FillColor->Automatic,FillOpacity->Automatic,ClipToRectangle->False,
FullOpts
]
],

(* contents *)
MakeVerbatim[
{Rectangle[{x1c,y1c},{x2c,y2c},Graphics3D[Primatives,UsedOptions]]},
FullOpts]
}

];


SetAttributes[ViewPort3D,HoldFirst];
ViewPort3D[GList_List,{{x1_?NumericQ,x2_?NumericQ},{y1_?NumericQ,y2_?NumericQ}},Opts___?OptionQ]:=Module[
{FullOpts=FigRealizeOptions[ViewPort3D,Opts]},
BasicViewPort3D[GList,{XCOfXU/@{x1,x2},YCOfYU/@{y1,y2}},FullOpts]
];
SetAttributes[ScaledViewPort3D,HoldFirst];
ScaledViewPort3D[GList_List,{{x1s_?NumericQ,x2s_?NumericQ},{y1s_?NumericQ,y2s_?NumericQ}},Opts___?OptionQ]:=Module[
{FullOpts=FigRealizeOptions[ScaledViewPort3D,Opts]},
BasicViewPort3D[GList,{XCOfXS/@{x1s,x2s},YCOfYS/@{y1s,y2s}},FullOpts]
];


BasicAxis[Caller_Symbol,{{x1_,x2_},{y1_,y2_}},Axis:(1|2|3|4),ShowAxis:(True|False),ShowHead:(True|False),Ticks_List,FullOpts_List]:=Module[
{
Segment,HalfWidthForLabels,Buffer,Posn,P,
TickData,TickPosn,TickText,TickLengths,TickAttributes,
TickPoint,TickEndPoints,TickOffset,TickLabelPoint,
TickLineGraphics,TickLineArt,TickTextGraphics,
LabelGraphics
},

(* calculate geometry *)
Segment=Switch[Axis,
1,{{x1,y1},{x2,y1}},
2,{{x1,y1},{x1,y2}},
3,{{x1,y2},{x2,y2}},
4,{{x2,y1},{x2,y2}}
];

(* construct ticks *)
TickLineArt={};
TickTextGraphics={};
Do[
{TickPosn,TickText,TickLengths,TickAttributes}=TickData;
If[TickText==="",TickText=None];
Switch[
Axis,
1,
TickPoint={TickPosn,y1};
TickEndPoints={TickPoint+{0,TickLengths[[1]]},TickPoint-{0,TickLengths[[2]]}};
TickOffset={0,+1},
2,
TickPoint={x1,TickPosn};
TickEndPoints={TickPoint+{TickLengths[[1]],0},TickPoint-{TickLengths[[2]],0}};
TickOffset={+1,0},
3,
TickPoint={TickPosn,y2};
TickEndPoints={TickPoint-{0,TickLengths[[1]]},TickPoint+{0,TickLengths[[2]]}};
TickOffset={0,-1},
4,
TickPoint={x2,TickPosn};
TickEndPoints={TickPoint-{TickLengths[[1]],0},TickPoint+{TickLengths[[2]],0}};
TickOffset={-1,0}
];
TickLabelPoint=TickPoint+DPCOfPA[-(Thickness/.FullOpts)/2*TickOffset];
If[
Chop[DPAOfPC[Subtract@@TickEndPoints]]!={0,0},
AppendTo[TickLineArt,Join[TickAttributes,{Line[TickEndPoints]}]]
];
If[
TickText=!=None,
AppendTo[
TickTextGraphics,
MakeText[TickText,TickLabelPoint,0,
ShowText->True,
Offset->TickOffset,
Nudge->(TickNudge/.FullOpts),
Orientation->0,
Background->GetAutoOption[TickBackground,None,FullOpts],
FontFamily->GetAutoOption[TickFontFamily,FontFamily/.FullOpts,FullOpts],
FontSize->GetAutoOption[TickFontSize,FontSize/.FullOpts,FullOpts],
FontWeight->GetAutoOption[TickFontWeight,FontWeight/.FullOpts,FullOpts],
FontSlant->GetAutoOption[TickFontSlant,FontSlant/.FullOpts,FullOpts],
FontTracking->GetAutoOption[TickFontTracking,FontTracking/.FullOpts,FullOpts],
FontColor->GetAutoOption[TickFontColor,FontColor/.FullOpts,FullOpts],
FontOpacity->GetAutoOption[TickFontOpacity,FontOpacity/.FullOpts,FullOpts],
FullOpts (* pass on default color and optional Layer from FullOpts *)
]
]
],
{TickData,Ticks}
];
TickLineGraphics=MakeOutline[{
TickLineArt
},
Dashing->None,
ShowLine->GetAutoOption[TickShowLine,ShowLine/.FullOpts,FullOpts],
LineColor->GetAutoOption[TickLineColor,LineColor/.FullOpts,FullOpts],
LineOpacity->GetAutoOption[TickLineOpacity,LineOpacity/.FullOpts,FullOpts],
Thickness->GetAutoOption[TickThickness,Thickness/.FullOpts,FullOpts],
FullOpts
];

(* construct axis label *)
(* basic spacing provided by Offset, additional by Buffer *)
HalfWidthForLabels=(Thickness/.FullOpts)/2;
Buffer=GetAutoOption[Switch[Axis,1,BufferB,2,BufferL,3,BufferT,4,BufferR],1.1,FullOpts];
Posn=GetAutoOption[Switch[Axis,1,PosnB,2,PosnL,3,PosnT,4,PosnR],0.5,FullOpts];
P=PCOfPA@ArrowPoint[Caller,PAOfPC/@Segment,AtUserPosition,Posn,Switch[Axis,1|4,-1,2|3,+1]*(HalfWidthForLabels+Buffer/2*(FontSize/.FullOpts))];

LabelGraphics={
Switch[
Axis,
1,
MakeText[(LabB/.FullOpts),P,0,
ShowText->(ShowLabB/.FullOpts),
Offset->GetAutoOption[OffsetB,{0,0},FullOpts],
Nudge->(NudgeB/.FullOpts),
Orientation->(OrientationB/.FullOpts),
Background->(BackgroundB/.FullOpts),
FullOpts 
],
2,
MakeText[(LabL/.FullOpts),P,-Pi/2,
ShowText->(ShowLabL/.FullOpts),
Offset->GetAutoOption[OffsetL,{0,0},FullOpts],
Nudge->(NudgeL/.FullOpts),
Orientation->(OrientationL/.FullOpts),
Background->(BackgroundL/.FullOpts),
FullOpts 
],
3,
MakeText[(LabT/.FullOpts),P,0,
ShowText->(ShowLabT/.FullOpts),
Offset->GetAutoOption[OffsetT,{0,0},FullOpts],
Nudge->(NudgeT/.FullOpts),
Orientation->(OrientationT/.FullOpts),
Background->(BackgroundT/.FullOpts),
FullOpts 
],
4,
MakeText[(LabR/.FullOpts),P,-Pi/2,
ShowText->(ShowLabR/.FullOpts),
Offset->GetAutoOption[OffsetR,{0,0},FullOpts],
Nudge->(NudgeR/.FullOpts),
Orientation->(OrientationR/.FullOpts),
Background->(BackgroundR/.FullOpts),
FullOpts 
]
]
};

(* Combine ticks with axis line *)
Flatten[{
(* axis line *)
If[ShowAxis,
MakeOutline[{Line[Segment]},FullOpts]
],
(* head *)
If[ShowHead,
MakeOutline[{Line[PCOfPA/@ArrowHeadPoints[PAOfPC/@Segment,HeadLength/.FullOpts,HeadLip/.FullOpts]]},Dashing->None,FullOpts]
],
(* ticks *)
TickLineGraphics,
TickTextGraphics,
(* labels *)
LabelGraphics
}]

];


SchemeAxis[Side:(Bottom|Top),{xa_,xb_},y_,Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeAxis,Opts],
TickList
},

CheckInScheme[];
CheckOption[ShowTicks,True|False,FullOpts];
CheckOption[ShowTickLabels,True|False,FullOpts];

TickList=Switch[(Ticks/.FullOpts),None,{},_List,Ticks/.FullOpts];
TickList=AugmentTicks[{0.0075,0},{},TickList];
TickList=TransformTicks[XCOfXU,DYCTick,LimitTickRange[{xa,xb},TickList]];
TickList=If[ShowTickLabels/.FullOpts,TickList,StripTickLabels[TickList]];
TickList=If[ShowTicks/.FullOpts,TickList,{}];
Switch[
Side,
Bottom,
BasicAxis[SchemeAxis,{{XCOfXU[xa],XCOfXU[xb]},{YCOfYU[y],Null}},1,True,(ShowHead/.FullOpts),TickList,FullOpts],
Top,
BasicAxis[SchemeAxis,{{XCOfXU[xa],XCOfXU[xb]},{Null,YCOfYU[y]}},3,True,(ShowHead/.FullOpts),TickList,FullOpts]
]
];
SchemeAxis[Side:(Left|Right),x_,{ya_,yb_},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeAxis,Opts],
TickList
},

CheckInScheme[];
CheckOption[ShowTicks,True|False,FullOpts];
CheckOption[ShowTickLabels,True|False,FullOpts];

TickList=Switch[(Ticks/.FullOpts),None,{},_List,Ticks/.FullOpts];
TickList=AugmentTicks[{0.01,0},{},TickList];
TickList=TransformTicks[YCOfYU,DXCTick,LimitTickRange[{ya,yb},TickList]];
TickList=If[ShowTickLabels/.FullOpts,TickList,StripTickLabels[TickList]];
TickList=If[ShowTicks/.FullOpts,TickList,{}];

Switch[
Side,
Left,
BasicAxis[SchemeAxis,{{XCOfXU[x],Null},{YCOfYU[ya],YCOfYU[yb]}},2,True,(ShowHead/.FullOpts),TickList,FullOpts],
Right,
BasicAxis[SchemeAxis,{{Null,XCOfXU[x]},{YCOfYU[ya],YCOfYU[yb]}},4,True,(ShowHead/.FullOpts),TickList,FullOpts]
]
];


SchemeAxis[Sides:({Bottom|Top,Left|Right}|{Left|Right,Bottom|Top}),{xRange:{xa_,xb_},yRange:{ya_,yb_}},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemeAxis,Opts],
Side,xyOrigin,DeducedShowHead,DeducedAxisTicks
},

CheckOption[AxesOrigin,Automatic|{_?NumericQ,_?NumericQ},FullOpts];

(* deduce options *)
xyOrigin=GetAutoOption[AxesOrigin,{0,0},FullOpts];
DeducedAxisTicks=AugmentAxisTickOptions[2,Ticks/.FullOpts];
DeducedShowHead=UpgradeAxisOptions[ShowHead/.FullOpts];

(* generate axes *)
Table[
Switch[
Side,
Bottom|Top,
SchemeAxis[
Side,xRange,xyOrigin[[2]],
Ticks->DeducedAxisTicks[[1]],ShowHead->DeducedShowHead[[1]],
FullOpts
],
Left|Right,
SchemeAxis[
Side,xyOrigin[[1]],yRange,
Ticks->DeducedAxisTicks[[2]],ShowHead->DeducedShowHead[[2]],
FullOpts
]
],
{Side,Sides}
]

];


RangePattern=(Automatic|{_?NumericQ,_?NumericQ});
TickPattern=(None|Automatic|_?TickListQ);
RulePattern=(_Rule)|(_RuleDelayed);
(* allowed entries for, e.g., labels are anything which doesn't mess up classification as a list or array *)
AllowedEntryPattern=Except[RulePattern|_List];


VectorOfQ[x_,p_]:=VectorQ[x,MatchQ[#,p]&];
MatrixOfQ[x_,p_]:=MatrixQ[x,MatchQ[#,p]&];
VectorPattern[p_]:=(_?(VectorOfQ[#,p]&));
MatrixPattern[p_]:=(_?(MatrixOfQ[#,p]&));
RuleListPattern=VectorPattern[RulePattern];


MultipanelArrayPattern[p_]:=(RuleListPattern|p|VectorPattern[p]|MatrixPattern[p]);


UpgradeMultipanelArray[
Data_,
Sense:Horizontal,{Rows_Integer,Columns_Integer},OptionName_Symbol,EntryPattern_
]/;MatchQ[Data,EntryPattern]:=
UpgradeMultipanelArray[Table[Data,{Columns}],Sense,{Rows,Columns},OptionName,EntryPattern];
UpgradeMultipanelArray[
Data_,
Sense:Vertical,{Rows_Integer,Columns_Integer},OptionName_Symbol,EntryPattern_
]/;MatchQ[Data,EntryPattern]:=
UpgradeMultipanelArray[Table[Data,{Rows}],Sense,{Rows,Columns},OptionName,EntryPattern];


UpgradeMultipanelArray[
Data_,
Sense:Horizontal,{Rows_Integer,Columns_Integer},OptionName_Symbol,EntryPattern_
]/;MatchQ[Data,VectorPattern[EntryPattern]]:=
UpgradeMultipanelArray[Table[Data,{Rows}],Sense,{Rows,Columns},OptionName,EntryPattern];
UpgradeMultipanelArray[
Data_,
Sense:Vertical,{Rows_Integer,Columns_Integer},OptionName_Symbol,EntryPattern_
]/;MatchQ[Data,VectorPattern[EntryPattern]]:=
UpgradeMultipanelArray[Transpose@Table[Data,{Columns}],Sense,{Rows,Columns},OptionName,EntryPattern];


UpgradeMultipanelArray[
Data_,
Sense:(Horizontal|Vertical|All),{Rows_Integer,Columns_Integer},OptionName_Symbol,EntryPattern_
]/;MatchQ[Data,RuleListPattern]:=Module[
{ValueArray,r,s},

ValueArray=Table[
Replace[{r,s},Append[Data,(_->Automatic)]],
{r,Rows},{s,Columns}
];

MapIndexed[
Function[If[!MatchQ[#1,EntryPattern],ErrorMessage[Multipanel::rule,OptionName,#2]]],
ValueArray,
{2}
];
ValueArray
];


UpgradeMultipanelArray[Data_,Sense:(Horizontal|Vertical|All),{Rows_Integer,Columns_Integer},OptionName_Symbol,EntryPattern_]/;(MatrixQ[Data,MatchQ[#,EntryPattern]&]):=
Switch[
Dimensions[Data,2],
{Rows,Columns},
Data,
{1,Columns},
Table[First[Data],{Rows}],
{Rows,1},
Transpose@Table[First[Transpose@Data],{Columns}],
_,
ErrorMessage[Multipanel::num,OptionName]
];


Multipanel[
OuterBox:{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},
{Rows_Integer,Columns_Integer},
Opts___?OptionQ
] :=Module[
{
FullOpts=FigRealizeOptions[Multipanel,Opts],
i,k,
RelativeXPanelSizes,RelativeYPanelSizes,
RelativeXGapSizes,RelativeYGapSizes,
RelativeXMarginSizes,RelativeYMarginSizes,
CanvasXPanelSizes,CanvasYPanelSizes,
CanvasXGapSizes,CanvasYGapSizes,
CanvasXMarginSizes,CanvasYMarginSizes,
x1,x2,y1,y2
},

CheckInScheme[];
CheckOption[XPlotRanges,MultipanelArrayPattern[RangePattern],FullOpts];
CheckOption[YPlotRanges,MultipanelArrayPattern[RangePattern],FullOpts];
CheckOption[XFrameTicks,MultipanelArrayPattern[TickPattern],FullOpts];
CheckOption[YFrameTicks,MultipanelArrayPattern[TickPattern],FullOpts];
CheckOption[XFrameLabels,MultipanelArrayPattern[AllowedEntryPattern],FullOpts];
CheckOption[YFrameLabels,MultipanelArrayPattern[AllowedEntryPattern],FullOpts];

CheckOption[Margin,_?MarginQ,FullOpts];
CheckOption[XPanelSizes,Automatic|_?NumericQ,{_?NumericQ..},FullOpts];
CheckOption[YPanelSizes,Automatic|_?NumericQ,{_?NumericQ..},FullOpts];
CheckOption[XGapSizes,_?NumericQ,{_?NumericQ..},FullOpts];
CheckOption[YGapSizes,_?NumericQ,{_?NumericQ..},FullOpts];
CheckOption[XMarginSizes,_?NumericQ,{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[YMarginSizes,_?NumericQ,{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[ShowFrameLabels,Automatic|{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[ShowFrameLabelsInterior,{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[ShowFrameLabelsExterior,{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[ShowTicks,Automatic|{True|False,True|False,True|False,True|False},FullOpts];
CheckOption[ShowTickLabels,Automatic|{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[ShowTickLabelsInterior,{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[ShowTickLabelsExterior,{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[PanelLetterInset,{_?NumericQ,_?NumericQ},FullOpts];

(* set up indexing *)
LevelScheme`Multipanel`Dimension={Rows,Columns};
LevelScheme`Multipanel`PanelIndices=None;

(* store plot ranges *)
LevelScheme`Multipanel`XPlotRanges=UpgradeMultipanelArray[XPlotRanges/.FullOpts,Horizontal,{Rows,Columns},XPlotRanges,RangePattern];
LevelScheme`Multipanel`YPlotRanges=UpgradeMultipanelArray[YPlotRanges/.FullOpts,Vertical,{Rows,Columns},YPlotRanges,RangePattern];

(* store tick mark information *)
LevelScheme`Multipanel`XFrameTicks=UpgradeMultipanelArray[XFrameTicks/.FullOpts,Horizontal,{Rows,Columns},XFrameTicks,TickPattern];
LevelScheme`Multipanel`YFrameTicks=UpgradeMultipanelArray[YFrameTicks/.FullOpts,Vertical,{Rows,Columns},YFrameTicks,TickPattern];
If[
MatchQ[(XFrameTicks/.FullOpts),TickPattern]&&MatchQ[(XFrameTicks/.FullOpts),{TickPattern..}],
Message[Multipanel::ambigticks,"XFrameTicks"]
];
If[
MatchQ[(YFrameTicks/.FullOpts),TickPattern]&&MatchQ[(YFrameTicks/.FullOpts),{TickPattern..}],
Message[Multipanel::ambigticks,"YFrameTicks"]
];

(* store frame label information *)
LevelScheme`Multipanel`XFrameLabels=UpgradeMultipanelArray[XFrameLabels/.FullOpts,Horizontal,{Rows,Columns},XFrameLabels,AllowedEntryPattern];
LevelScheme`Multipanel`YFrameLabels=UpgradeMultipanelArray[YFrameLabels/.FullOpts,Vertical,{Rows,Columns},YFrameLabels,AllowedEntryPattern];

(* store geometry *)
{{x1,x2},{y1,y2}}=ImposeAbsoluteMargin[OuterBox,Margin/.FullOpts];
RelativeXPanelSizes=Switch[
XPanelSizes/.FullOpts,
Automatic,(
If[
!MatchQ[LevelScheme`Multipanel`XPlotRanges,{{{_?NumericQ,_?NumericQ}..}..}],ErrorMessage[Multipanel::autosizes,"XPanelSizes","XPlotRanges"]
];
-Subtract@@@First[LevelScheme`Multipanel`XPlotRanges]
),
_?NumericQ,Table[XPanelSizes/.FullOpts,{Columns}],
{_?NumericQ..},XPanelSizes/.FullOpts
];
If[Length[RelativeXPanelSizes]=!=Columns,
ErrorMessage[Multipanel::num,"X panel sizes"]
];
RelativeYPanelSizes=Switch[
YPanelSizes/.FullOpts,
Automatic,(
If[
!MatchQ[LevelScheme`Multipanel`YPlotRanges,{{{_?NumericQ,_?NumericQ}..}..}],ErrorMessage[Multipanel::autosizes,"YPanelSizes","YPlotRanges"]
];
-Subtract@@@First[Transpose[LevelScheme`Multipanel`YPlotRanges]]
),
_?NumericQ,Table[YPanelSizes/.FullOpts,{Rows}],
{_?NumericQ..},YPanelSizes/.FullOpts
];
If[Length[RelativeYPanelSizes]=!=Rows,
ErrorMessage[Multipanel::num,"Y panel sizes"]
];
RelativeXGapSizes=Switch[
XGapSizes/.FullOpts,
_?NumericQ,Table[XGapSizes/.FullOpts,{Columns-1}],
{_?NumericQ..},XGapSizes/.FullOpts
];
If[Length[RelativeXGapSizes]=!=(Columns-1),
ErrorMessage[Multipanel::num,"X panel gaps"]
];
RelativeYGapSizes=Switch[
YGapSizes/.FullOpts,
_?NumericQ,Table[YGapSizes/.FullOpts,{Rows-1}],
{_?NumericQ..},YGapSizes/.FullOpts
];
If[Length[RelativeYGapSizes]=!=(Rows-1),
ErrorMessage[Multipanel::num,"Y panel gaps"]
];
RelativeXMarginSizes=Switch[
XMarginSizes/.FullOpts,
_?NumericQ,Table[XMarginSizes/.FullOpts,{2}],
{_?NumericQ,_?NumericQ},XMarginSizes/.FullOpts
];
RelativeYMarginSizes=Switch[
YMarginSizes/.FullOpts,
_?NumericQ,Table[YMarginSizes/.FullOpts,{2}],
{_?NumericQ,_?NumericQ},YMarginSizes/.FullOpts
];
LevelScheme`Multipanel`CanvasXUnit=(x2-x1)/(Plus@@RelativeXPanelSizes+Plus@@RelativeXGapSizes+Plus@@RelativeXMarginSizes);
CanvasXPanelSizes=RelativeXPanelSizes*LevelScheme`Multipanel`CanvasXUnit;
CanvasXGapSizes=RelativeXGapSizes*LevelScheme`Multipanel`CanvasXUnit;
CanvasXMarginSizes=RelativeXMarginSizes*LevelScheme`Multipanel`CanvasXUnit;
LevelScheme`Multipanel`CanvasYUnit=(y2-y1)/(Plus@@RelativeYPanelSizes+Plus@@RelativeYGapSizes+Plus@@RelativeYMarginSizes);
CanvasYPanelSizes=RelativeYPanelSizes*LevelScheme`Multipanel`CanvasYUnit;
CanvasYGapSizes=RelativeYGapSizes*LevelScheme`Multipanel`CanvasYUnit;
CanvasYMarginSizes=RelativeYMarginSizes*LevelScheme`Multipanel`CanvasYUnit;
LevelScheme`Multipanel`XRegionRangeList=Table[
x1+CanvasXMarginSizes[[1]]+Sum[CanvasXPanelSizes[[k]]+CanvasXGapSizes[[k]],{k,1,i-1}]+{0,CanvasXPanelSizes[[i]]},
{i,1,Columns}
];
LevelScheme`Multipanel`YRegionRangeList=Table[
y2-CanvasYMarginSizes[[1]]-Sum[CanvasYPanelSizes[[k]]+CanvasYGapSizes[[k]],{k,1,i-1}]+{-CanvasYPanelSizes[[i]],0},
{i,1,Rows}
];



(* store frozen copy of Panel formatting option defaults *)
LevelScheme`Multipanel`PanelOptions={LegacyFilterOptions[FigurePanel,FullOpts]};

Null

];


Multipanel[{Rows_Integer,Columns_Integer},Opts___?OptionQ]:=Multipanel[$CanvasRange,{Rows,Columns},Opts];


BasicFigurePanel[Caller_Symbol,OuterBox:{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},FullOpts_List]:=Module[
{
CanvasRange,ExpandedPlotRange,XYPlotRange,UsedPlotRange,
DeducedShowFrameLabels,DeducedFrameLabel,DeducedFrameLabelOptions,DeducedTickOptions,DeducedFrameTicks,DeducedShowTicks,DeducedShowTickLabels,DeducedTickLabelRange,
AxisIndex,PanelLetterPosn
},
CheckInScheme[];

CheckOption[Margin,_?MarginQ,FullOpts];
CheckOption[PlotRange,Automatic|{Automatic|{_?NumericQ,_?NumericQ},Automatic|{_?NumericQ,_?NumericQ}},FullOpts];
CheckOption[Background,None|ColorDirectivePattern,FullOpts];
CheckOption[BackgroundOpacity,_?NumericQ,FullOpts];
CheckOption[FrameLabel,None|Automatic|(L_List/;(Length[L]<=4)),FullOpts];
CheckOption[ShowFrameLabels,Automatic|(True|False)|{True|False,True|False,True|False,True|False},FullOpts]; (* ad hoc pattern -- TO NEATEN *)
CheckOption[ShowEdge,{True|False,True|False,True|False,True|False},FullOpts];
CheckOption[ShowTicks,Automatic|{True|False,True|False,True|False,True|False},FullOpts];
CheckOption[ShowTickLabels,Automatic|(True|False)|{True|False,True|False,True|False,True|False},FullOpts];(* ad hoc pattern -- TO NEATEN *)
CheckOption[TickNudge,(L:{(_?NumericQ|{_?NumericQ,_?NumericQ})...}/;(Length[L]==4)),FullOpts];
(* hard to standardize multi-axis specification, since each nudge can either be a number or a list *)
CheckOption[TickLabelMargin,_?MarginQ,FullOpts];
CheckOption[TickOptions,(None|(_?FlatListQ))|{(None|(_?FlatListQ)),(None|(_?FlatListQ))}|{{(None|(_?FlatListQ)),(None|(_?FlatListQ))},{(None|(_?FlatListQ)),(None|(_?FlatListQ))}},FullOpts]; (* ad hoc pattern -- TO NEATEN -- can also validate flat list as option list *)
CheckOption[ExtendRange,_?NumericQ|{_?NumericQ,_?NumericQ}|{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},FullOpts];

(* set up global properties for panel *)
$Background=Background/.FullOpts;
CanvasRange=ImposeAbsoluteMargin[OuterBox,Margin/.FullOpts];


(* calculate plot range *)
(* (1) expand PlotRange value Automatic to {Automatic,Automatic}; (2) for each coordinate, use explicit range if given in PlotRange, or for Automatic default to separate XPlotRange and YPlotRange; (3) for XPlotRange and YPlotRange, use explicit ranges if given or else for Automatic default to canvas coordinate range covered by panel (dubious value) *)
ExpandedPlotRange=GetAutoOption[PlotRange,{Automatic,Automatic},FullOpts];
XYPlotRange=MapThread[
(Replace[#1,Automatic->#2]&),
{ExpandedPlotRange,{XPlotRange,YPlotRange}/.FullOpts}
];
UsedPlotRange=ExtendRegion[
MapThread[
(Replace[#1,Automatic->#2]&),
{XYPlotRange,CanvasRange}
],
(ExtendRange/.FullOpts)
];

(* set new coordinate mapping *)
SetRegion[CanvasRange,UsedPlotRange];

(* obtain frame labels, defaulting to LabX option values *)
(* construct explicit list of labels *)
DeducedFrameLabel=Switch[
(FrameLabel/.FullOpts),
Automatic,
{LabB,LabL,LabT,LabR}/.FullOpts,
_List,
UpgradeFrameOptionsList[(FrameLabel/.FullOpts),None]
];
(* remove labels except on sides where allowed *)
DeducedShowFrameLabels=UpgradeFrameOptionsList[
GetAutoOption[ShowFrameLabels,{True,True,True,True},FullOpts]
];
(* clothe frame labels as LabX option rules *)
DeducedFrameLabelOptions={
MapThread[Rule,{{LabB,LabL,LabT,LabR},DeducedFrameLabel}],
MapThread[Rule,{{ShowLabB,ShowLabL,ShowLabT,ShowLabR},DeducedShowFrameLabels}]
};

(* process frame tick specification *)
(* augment specification so that it is a list of lists*)
DeducedFrameTicks=GetAutoOption[FrameTicks,{Automatic,Automatic,None,None},FullOpts];
DeducedFrameTicks=AugmentAxisTickOptions[4,DeducedFrameTicks];
(* generate any automatic ticks with LinTicks, with labels on for the bottom and left and off for the top and right *)
DeducedTickOptions=UpgradeFrameOptionsFlatList[(TickOptions/.FullOpts)/.{None->{}}];
DeducedFrameTicks=MapThread[
(Replace[#1,Automatic:>LinTicks[Sequence@@#2,ShowLabels->#3,#4]]&),
{
DeducedFrameTicks,
{UsedPlotRange[[1]],UsedPlotRange[[2]],UsedPlotRange[[1]],UsedPlotRange[[2]]},
{True,True,False,False},
DeducedTickOptions
}
];
(* augment specification of any under-specified ticks *)
DeducedFrameTicks=(AugmentTicks[{0.01,0},{},#]&)/@DeducedFrameTicks;
(* convert to canvas coordinates *)
DeducedFrameTicks=MapThread[
(TransformTicks[#1,#2,LimitTickRange[#3,#4]]&),
{
{XCOfXU,YCOfYU,XCOfXU,YCOfYU},
{DYCTick,DXCTick,DYCTick,DXCTick},
{UsedPlotRange[[1]],UsedPlotRange[[2]],UsedPlotRange[[1]],UsedPlotRange[[2]]},
DeducedFrameTicks
}
];
(* remove tick labels except on sides where allowed *)
DeducedShowTickLabels=UpgradeFrameOptionsList[
GetAutoOption[ShowTickLabels,{True,True,False,False},FullOpts]
];
DeducedFrameTicks=MapThread[
(If[#2,#1,StripTickLabels[#1]]&),
{DeducedFrameTicks,DeducedShowTickLabels}
];
(* trim tick labels to restricted canvas range to avoid clash with neighboring frames  *)
DeducedTickLabelRange=ImposeAbsoluteMargin[CanvasRange,(TickLabelMargin/.FullOpts)];
DeducedFrameTicks=MapThread[
LimitTickLabelRange[#2,#1]&,
{DeducedFrameTicks,Join[DeducedTickLabelRange,DeducedTickLabelRange]}
];
(* remove ticks except on sides where allowed *)
DeducedShowTicks=UpgradeFrameOptionsList[
GetAutoOption[ShowTicks,{True,True,True,True},FullOpts]
];
DeducedFrameTicks=MapThread[
(If[#2,#1,{}]&),
{DeducedFrameTicks,DeducedShowTicks}
];

(* construct artwork *)
{
(* fill *)
If[
$Background=!=None,
MakeFill[
{Rectangle@@Transpose[CanvasRange]},
Color->(Background/.FullOpts),Opacity->(BackgroundOpacity/.FullOpts),
ShowFill->True,FillColor->Automatic,FillOpacity->Automatic,
Layer->GetAutoOption[Layer,$SchemeBackgroundLayer,FullOpts],
FullOpts
]
],

(* edges *)
(* axis options are as in FullOpts, except LabX is overriden by FrameLabel, TickNudge is an edge-by-edge list, and the Ticks are given for the whole frame *)
Table[
If[(Frame/.FullOpts)&&(ShowEdge/.FullOpts)[[AxisIndex]],
BasicAxis[Caller,
CanvasRange,
AxisIndex,
(ShowEdge/.FullOpts)[[AxisIndex]],
False,
DeducedFrameTicks[[AxisIndex]],
Flatten[{DeducedFrameLabelOptions,TickNudge->(TickNudge/.FullOpts)[[AxisIndex]],FullOpts}]
]
],
{AxisIndex,1,4}
],

(* panel letter *)
PanelLetterPosn=PCOfPS[(PanelLetterCorner/.FullOpts)/.{-1->0}]
+(-1)*(PanelLetterCorner/.FullOpts)*DPCOfPA@(PanelLetterInset/.FullOpts);
MakeText[(PanelLetter/.FullOpts), PanelLetterPosn,0,
ShowText->(ShowPanelLetter/.FullOpts),
Offset->GetAutoOption[PanelLetterOffset,{0,0},FullOpts],
Nudge->(PanelLetterNudge/.FullOpts),
Orientation->(PanelLetterOrientation/.FullOpts),
Background->(PanelLetterBackground/.FullOpts),
FontFamily->GetAutoOption[PanelLetterFontFamily,FontFamily/.FullOpts,FullOpts],
FontSize->GetAutoOption[PanelLetterFontSize,FontSize/.FullOpts,FullOpts],
FontWeight->GetAutoOption[PanelLetterFontWeight,FontWeight/.FullOpts,FullOpts],
FontSlant->GetAutoOption[PanelLetterFontSlant,FontSlant/.FullOpts,FullOpts],
FontTracking->GetAutoOption[PanelLetterFontTracking,FontTracking/.FullOpts,FullOpts],
FontColor->GetAutoOption[PanelLetterFontColor,FontColor/.FullOpts,FullOpts],
FontOpacity->GetAutoOption[PanelLetterFontOpacity,FontOpacity/.FullOpts,FullOpts],
FullOpts 
]

}
];
FigurePanel[CanvasRange:{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[FigurePanel,Opts],
AugmentedOpts
},
AugmentedOpts=Flatten[{ClipToRectangle->False,FullOpts}];  (* provide ClipToRectangle value *)
BasicFigurePanel[FigurePanel,CanvasRange,AugmentedOpts]
];
(* DEBUGGING: Version with zero arguments could in principle be accomplished by putting $CanvasRange as default value for CanvasRange argument above, but this pattern for argument leads to fall-through to "unrecognized argument" handler instead. *)
FigurePanel[Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[FigurePanel,Opts],
AugmentedOpts
},
AugmentedOpts=Flatten[{ClipToRectangle->False,FullOpts}];  (* provide ClipToRectangle value *)
BasicFigurePanel[FigurePanel,$CanvasRange,AugmentedOpts]
];
ScaledFigurePanel[ScaledRange:{{x1s_?NumericQ,x2s_?NumericQ},{y1s_?NumericQ,y2s_?NumericQ}},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[ScaledFigurePanel,Opts],
AugmentedOpts
},
AugmentedOpts=Flatten[{ClipToRectangle->False,FullOpts}];  (* provide ClipToRectangle value *)
BasicFigurePanel[ScaledFigurePanel,{XCOfXS/@{x1s,x2s},YCOfYS/@{y1s,y2s}},AugmentedOpts]
];


FigurePanel[PanelIndices:{Row_Integer,Column_Integer},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[FigurePanel,{Opts,LevelScheme`Multipanel`PanelOptions}],
DeducedFullOpts,
OptPanelShift,OptPanelAdjustments,
CanvasRange,MultipanelPlotRange,ExpandedPlotRange,XYPlotRange,DeducedPlotRange,
DeducedFrameLabel,DeducedShowFrameLabels,
DeducedFrameTicks,DeducedShowTickLabels,DeducedTickLabelMargin,
DeducedPanelLetter,
DeducedOptions,
AugmentedOpts,
DeducedExteriorMask
},

CheckInScheme[];
If[
!ValueQ[LevelScheme`Multipanel`Dimension],
ErrorMessage[FigurePanel::undefined]
];
If[
!TrueQ[InRegion[{1,1},LevelScheme`Multipanel`Dimension,PanelIndices]],
ErrorMessage[FigurePanel::badij,PanelIndices]
];
CheckOption[PlotRange,Automatic|{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},FullOpts];
CheckOption[PanelShift,None|{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[PanelAdjustments,None|{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},FullOpts];
CheckOption[ShowFrameLabelsInterior,{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[ShowFrameLabelsExterior,{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[ShowTickLabelsInterior,{True|False,True|False,True|False,True|False},FullOpts]; 
CheckOption[ShowTickLabelsExterior,{True|False,True|False,True|False,True|False},FullOpts];
CheckOption[ExteriorMask,Automatic|(_?FrameMaskListQ),FullOpts]; 

LevelScheme`Multipanel`PanelIndices=PanelIndices;

(* calculate geometry *)
OptPanelShift=If[(PanelShift/.FullOpts)===None,{0,0},(PanelShift/.FullOpts)];
OptPanelAdjustments=If[(PanelAdjustments/.FullOpts)===None,{{0,0},{0,0}},(PanelAdjustments/.FullOpts)];
CanvasRange={
LevelScheme`Multipanel`XRegionRangeList[[Column]]+OptPanelShift[[1]]*LevelScheme`Multipanel`CanvasXUnit+OptPanelAdjustments[[1]]*{-1,1}*LevelScheme`Multipanel`CanvasXUnit,
LevelScheme`Multipanel`YRegionRangeList[[Row]]+OptPanelShift[[2]]*LevelScheme`Multipanel`CanvasYUnit+OptPanelAdjustments[[2]]*{-1,1}*LevelScheme`Multipanel`CanvasYUnit
};

(* calculate plot range *)
(* (1) expand PlotRange value Automatic to {Automatic,Automatic}; (2) for each coordinate, use explicit range if given in PlotRange, or for Automatic default to separate XPlotRange and YPlotRange; (3) for XPlotRange and YPlotRange, use explicit ranges if given or else for Automatic default to range for this row and column specified to Multipanel; (4) note that if Multipanel range is in turn Automatic, BasicPanel will later extend this range if necessary and convert this to the range of canvas coordinates covered by the panel *)
MultipanelPlotRange={LevelScheme`Multipanel`XPlotRanges[[Row,Column]],LevelScheme`Multipanel`YPlotRanges[[Row,Column]]};
ExpandedPlotRange=GetAutoOption[PlotRange,{Automatic,Automatic},FullOpts];
XYPlotRange=MapThread[
(Replace[#1,Automatic->#2]&),
{ExpandedPlotRange,{XPlotRange,YPlotRange}/.FullOpts}
];
DeducedPlotRange=MapThread[
(Replace[#1,Automatic->#2]&),
{XYPlotRange,MultipanelPlotRange}
];

(* exterior mask for edges of current panel *)
DeducedExteriorMask=GetAutoOption[
ExteriorMask,
{
Row==LevelScheme`Multipanel`Dimension[[1]],
Column==1,
Row==1,
Column==LevelScheme`Multipanel`Dimension[[2]]
},
FullOpts
];

(* deduce labels *)
DeducedFrameLabel={LevelScheme`Multipanel`XFrameLabels[[Row,Column]],LevelScheme`Multipanel`YFrameLabels[[Row,Column]],None,None};
DeducedShowFrameLabels=GetAutoOption[
ShowFrameLabels,
ListableOr[
ListableAnd[DeducedExteriorMask,(ShowFrameLabelsExterior/.FullOpts)],
ListableAnd[ListableNot[DeducedExteriorMask],(ShowFrameLabelsInterior/.FullOpts)]
],
FullOpts
];

(* deduce ticks *)
DeducedFrameTicks={LevelScheme`Multipanel`XFrameTicks[[Row,Column]],LevelScheme`Multipanel`YFrameTicks[[Row,Column]],LevelScheme`Multipanel`XFrameTicks[[Row,Column]],LevelScheme`Multipanel`YFrameTicks[[Row,Column]]};
(* deduce tick label sides *)
(* condition for tick labels to be shown is (outer edge) AND (edge allowed by ShowTickLabels option at time of Multipanel invocation) *)
DeducedShowTickLabels=GetAutoOption[
ShowTickLabels,
ListableOr[
ListableAnd[DeducedExteriorMask,(ShowTickLabelsExterior/.FullOpts)],
ListableAnd[ListableNot[DeducedExteriorMask],(ShowTickLabelsInterior/.FullOpts)]
],
FullOpts
];
(* for automatic ticks, suppress X final tick unless right exterior, Y final tick unless top exterior *)
DeducedTickLabelMargin=If[
(TickLabelAutoSuppress/.FullOpts),
{
Switch[DeducedExteriorMask[[4]],False,{0,5},True,{0,0}],
Switch[DeducedExteriorMask[[3]],False,{0,5},True,{0,0}]
},
{{0,0},{0,0}}
];

(* deduce panel label *)
DeducedPanelLetter=PanelLetter[LegacyFilterOptions[PanelLetter,FullOpts]];

(* combine deduced options *)
DeducedOptions={
PlotRange->DeducedPlotRange,
FrameLabel->Automatic, (* for easier user override with LabX *)
Margin->0, (* override different meaning of Margin for Multipanel *)
LabB->DeducedFrameLabel[[1]],LabL->DeducedFrameLabel[[2]],LabT->DeducedFrameLabel[[3]],LabR->DeducedFrameLabel[[4]],
ShowFrameLabels->DeducedShowFrameLabels,
FrameTicks->DeducedFrameTicks,ShowTickLabels->DeducedShowTickLabels,
PanelLetter->DeducedPanelLetter,
TickLabelMargin->DeducedTickLabelMargin
};
DeducedFullOpts=FigRealizeOptions[FigurePanel,{Opts,DeducedOptions,LevelScheme`Multipanel`PanelOptions}];

AugmentedOpts=Flatten[{ClipToRectangle->False,DeducedFullOpts}];  (* provide ClipToRectangle value *)
BasicFigurePanel[FigurePanel,CanvasRange,AugmentedOpts]

];


PanelLetter[Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[PanelLetter,Opts],
StartLetterCode,Letter,
i,j
},
CheckInScheme[];
CheckOption[Order,Horizontal|Vertical,FullOpts];
CheckOption[PanelLetterOrigin,{_Integer,_Integer},FullOpts];
If[
LevelScheme`Multipanel`PanelIndices===None,
ErrorMessage[PanelLetter::nopanel]
];
StartLetterCode=ToCharacterCode[First/.FullOpts];

{i,j}=LevelScheme`Multipanel`PanelIndices-((PanelLetterOrigin/.FullOpts)-{1,1});
Letter=Switch[
Order/.FullOpts,
Horizontal,FromCharacterCode[StartLetterCode+LevelScheme`Multipanel`Dimension[[2]]*(i-1)+(j-1)],
Vertical,FromCharacterCode[StartLetterCode+(i-1)+LevelScheme`Multipanel`Dimension[[1]]*(j-1)]
];
(Format/.FullOpts)[[1]]<>Letter<>(Format/.FullOpts)[[2]]
];


AttachIndex[Values_List,Opts___?OptionQ]:=Module[
{FullOpts=FigRealizeOptions[AttachIndex,Opts],
s,x0},

CheckOption[First,_?NumericQ,FullOpts];
CheckOption[ScaleFactor,_?NumericQ,FullOpts];
CheckOption[Range,{_?NumericQ,_?NumericQ}|Automatic,FullOpts];

Switch[Range/.FullOpts,
Automatic,
s=(ScaleFactor/.FullOpts);
x0=(First/.FullOpts),
{_?NumericQ,_?NumericQ},
s=(Subtract@@Reverse[Range/.FullOpts])/(Length[Values]-1);
x0=First[Range/.FullOpts]
];

MapIndexed[{s*(First[#2]-1)+x0,#1}&,Values]
];


DataValueQ[x_]:=MatchQ[x,((_?RealNumericQ)|None)|ErrorValue[((_?RealNumericQ)|None),(_?RealNumericQ)|None|{((_?RealNumericQ)|None),((_?RealNumericQ)|None)}]];
DataValueNoneQ[x_]:=MatchQ[x,(None)|ErrorValue[None,(_?RealNumericQ)|None|{((_?RealNumericQ)|None),((_?RealNumericQ)|None)}]];


DataPointQ[x_]:=MatchQ[x,None|{_?DataValueQ,_?DataValueQ}];
DataPointNoneQ[x_]:=MatchQ[x,None|{_?DataValueNoneQ,_?DataValueQ}|{_?DataValueQ,_?DataValueNoneQ}];


DataSetQ[x_]:=MatchQ[x,{(_?DataPointQ)...}];


SelectData[Test_,Opts___?OptionQ][Data_?DataSetQ]:=Replace[Data,{_?NumericQ,_?NumericQ}?(Composition[Not,Test])->{None,None},{1}];
ExcludeData[Test_,Opts___?OptionQ][Data_?DataSetQ]:=Replace[Data,{_?NumericQ,_?NumericQ}?Test->{None,None},{1}];
TransformData[f_,Opts___?OptionQ][Data_?DataSetQ]:=Replace[Data,x:{_,_}:>f[x],{1}];
DownsampleData[n_Integer,Opts___?OptionQ][Data_?DataSetQ]:=Module[{i=0},Select[Data,(Mod[i++,n]==0&)]];


XRange[x1_?RealNumericQ,x2_?RealNumericQ]:=(InRange[{x1,x2},#[[1]]]&);
YRange[y1_?RealNumericQ,y2_?RealNumericQ]:=(InRange[{y1,y2},#[[2]]]&);
InPlotRegion:=(InRegion[$RegionRange,PCOfPU[#]]&);
LimitX[x1_?RealNumericQ,x2_?RealNumericQ]:=(Switch[#,_?(XRange[x1,x2]),#,_?(XRange[-Infinity,x1]),{x1,#[[2]]},_?(XRange[x2,+Infinity]),{x2,#[[2]]},_,Message[LimitX::badvalue,#]]&);
LimitY[y1_?RealNumericQ,y2_?RealNumericQ]:=(Switch[#,_?(YRange[y1,y2]),#,_?(YRange[-Infinity,y1]),{#[[1]],y1},_?(YRange[y2,+Infinity]),{#[[1]],y2},_,Message[LimitY::badvalue,#]]&);


DataLineShape["Straight",n_][Points_List]:=Module[
{},
If[Length[Points]<2,Return[{}]];
Points
];
DataLineShape["Step",n_][Points_List]:=Module[
{},
If[Length[Points]<2,Return[{}]];
Join[
{First[Points]},
Flatten[
Table[
{
{(First[Points[[i]]]+First[Points[[i+1]]])/2,Last[Points[[i]]]},{(First[Points[[i]]]+First[Points[[i+1]]])/2,Last[Points[[i+1]]]}
},
{i,1,Length[Points]-1}
],
1
],
{Last[Points]}
]
];
DataLineShape["StepAnchored",n_][Points_List]:=Module[
{},
If[Length[Points]<2,Return[{}]];
Join[
{
{(3/2*First[Points[[1]]]-1/2*First[Points[[2]]]),YCOfYU@0},
{(3/2*First[Points[[1]]]-1/2*First[Points[[2]]]),Last[Points[[1]]]}
},
Flatten[
Table[
{
{(First[Points[[i]]]+First[Points[[i+1]]])/2,Last[Points[[i]]]},
{(First[Points[[i]]]+First[Points[[i+1]]])/2,Last[Points[[i+1]]]}
},
{i,1,Length[Points]-1}
],
1
],
{
{(3/2*First[Points[[-1]]]-1/2*First[Points[[-2]]]),Last[Points[[-1]]]},
{(3/2*First[Points[[-1]]]-1/2*First[Points[[-2]]]),YCOfYU@0}
}
]
];
DataLineShape["Histogram",n_][Points_List]:=Module[
{},

If[Length[Points]<2,Return[{}]];
Join[
{
{(3/2*First[Points[[1]]]-1/2*First[Points[[2]]]),YCOfYU@0},
{(3/2*First[Points[[1]]]-1/2*First[Points[[2]]]),Last[Points[[1]]]}
},
Flatten[
Table[
{
{(First[Points[[i]]]+First[Points[[i+1]]])/2,Last[Points[[i]]]},
{(First[Points[[i]]]+First[Points[[i+1]]])/2,YCOfYU@0},
{(First[Points[[i]]]+First[Points[[i+1]]])/2,Last[Points[[i+1]]]}
},
{i,1,Length[Points]-1}
],
1
],
{
{(3/2*First[Points[[-1]]]-1/2*First[Points[[-2]]]),Last[Points[[-1]]]},
{(3/2*First[Points[[-1]]]-1/2*First[Points[[-2]]]),YCOfYU@0}
}
]
];


DataSymbolShape["Circle",n_]:=Table[{Cos[2*Pi*i/n],Sin[2*Pi*i/n]},{i,1,n}];


DataSymbolShape["UpTriangle",n_]:=1.2*{{0.,1.},{-0.8660254037844386,-0.5},{0.8660254037844386,-0.4999999999999999}};
DataSymbolShape["LeftTriangle",n_]:=1.2*{{-1.,0.},{0.5,-0.8660254037844386},{0.4999999999999999,0.8660254037844386}};
DataSymbolShape["DownTriangle",n_]:=1.2*{{0.,-1.},{0.8660254037844386,0.5},{-0.8660254037844386,0.4999999999999999}};
DataSymbolShape["RightTriangle",n_]:=1.2*{{1.,0.},{-0.5,0.8660254037844386},{-0.4999999999999999,-0.8660254037844386}};


DataSymbolShape["Square",n_]:=1.2*{{-0.7071067811865476,0.7071067811865476},{-0.7071067811865476,-0.7071067811865476},{0.7071067811865476,-0.7071067811865476},{0.7071067811865476,0.7071067811865476}};
DataSymbolShape["Diamond",n_]:=1.2*{{0.,1.},{-1.,0.},{0.,-1.},{1.,0.}};


DataSymbolShape["Cross",n_]:=1.2*{{0,0},{-0.7071067811865476,0.7071067811865476},{0,0},{-0.7071067811865476,-0.7071067811865476},{0,0},{0.7071067811865476,-0.7071067811865476},{0,0},{0.7071067811865476,0.7071067811865476},{0,0}};


DataSymbolVertices[SymbolShape_,SymbolSize_?NumericQ,PlotPoints_Integer][P:{_?NumericQ,_?NumericQ}]:=Module[
{BasicShape},
BasicShape=DataSymbolShape[SymbolShape,PlotPoints];
If[!MatchQ[BasicShape,{{_?NumericQ,_?NumericQ}..}],ErrorMessage[DataSymbol::badsymbol,SymbolShape]];
(P+#)&/@(DPCOfPA/@N[(SymbolSize/2)*BasicShape])
];


ErrorBarPrimatives[{x_,y_},{dx_,dy_},{Capx_,Capy_}]:={
Line[{{x,y},{x,y}+{dx,dy}}],
Line[{{x,y}+{dx,dy}-DPCOfPA@{Capx,Capy},{x,y}+{dx,dy}+DPCOfPA@{Capx,Capy}}]
};


NoneFreeQ[x_]:=!DataPointNoneQ[x];  (* TO REVISIT *)
(*NoneFreePairQ[x_,y_]:=NoneFreeQ[x]&&NoneFreeQ[y];*)


NoneFreePairQ[Except[None],Except[None]]:=True;
NoneFreePairQ[_,_]:=False;
PartitionDataForLine[Data_List]:=Cases[
Split[Data,NoneFreePairQ],
x:{Except[None]..}
];


ApplyOrNone[f_][x_?NumericQ]:=f[x];
ApplyOrNone[f_][None]:=None;


LogOrNone[b_:E,x_?Positive]:=Log[b,x];
LogOrNone[b_:E,x_]:=None;


DataLog[b_:E,ErrorValue[x_?Positive,{dxm_,dxp_}]]:=Block[
{
xp,xm,
logx,logxm,logxp,
dlogxm,dlogxp
},

(* calculate true coordinates *)
xm=ApplyOrNone[(x+#&)][dxm];
xp=ApplyOrNone[(x+#&)][dxp];

(* calculate logs *)
logx=Log[b,x];
logxm=LogOrNone[b,xm];
logxp=LogOrNone[b,xp];

(* convert back to difference *)
dlogxm=ApplyOrNone[(#-logx&)][logxm];
dlogxp=ApplyOrNone[(#-logx&)][logxp];

(* construct ErrorValue *)
ErrorValue[logx,{dlogxm,dlogxp}]
];
DataLog[b_:E,ErrorValue[x_,{dxm_,dxp_}]]:=None;


ProcessDataSet[Data_List,Tag_]:=Module[
{
DataSetOpts,DataValuesOpts,DataLineOpts,DataSymbolOpts,
OptDataColumns,AdHocFixForDataGroup,
PairData,FilteredData,ExpandedData,ScaledData,FinalData,
Points,ValuePoints,ValuePointCenters,Segments,LinePoints,
BasicShape,i,Point,PointVertices,CentralPoints,ExpandedErrorPoints,
DropFillArt,LineArt,SymbolOutlineArt,SymbolFillArt,ErrorBarArt
},

If[!$ProcessDataSets,Return[{}]];

(* Generate plot options *)

DataSetOpts=FigRealizeOptions[DataSet];
DataValuesOpts=FigRealizeOptions[DataValues];
DataLineOpts=FigRealizeOptions[DataLine];
DataSymbolOpts=FigRealizeOptions[DataSymbol];



(* Validate plot options *)

CheckOption[AxisScaling,None|Log|{None|Log,None|Log},DataValuesOpts];
CheckOption[DataColumns,Automatic|{(_Integer)?Positive,(_Integer)?Positive},DataSetOpts];
CheckOption[DataFilters,None|(_List),DataValuesOpts];
CheckOption[Show,True|False,DataLineOpts];
CheckOption[Show,True|False,DataSymbolOpts];
CheckOption[SymbolShape,_String,DataSymbolOpts];
CheckOption[SymbolSize,(_?NumericQ)?Positive,DataSymbolOpts];
CheckOption[PlotPoints,_Integer?Positive,DataSymbolOpts];

(* Construct data point lists *)

(* select out relevant columns *)
OptDataColumns=GetAutoOption[DataColumns,{1,2},DataSetOpts];
If[Max[OptDataColumns]>Dimensions[Data][[2]],
ErrorMessage[DataSet::badcolumn,OptDataColumns]
];
PairData=Data[[All,OptDataColumns]];

(* validate as two-column data set *)
If[
!DataSetQ[PairData],
ErrorMessage[DataPlot::baddata,PairData]
];

(* filter data based on central values *)
FilteredData=Switch[
DataFilters/.DataValuesOpts,
None|{},PairData,
_List,(Composition@@Reverse[DataFilters/.DataValuesOpts])[PairData]
];
(* collapse any points with None for x or y coordinate into a simple None *)
FilteredData=Replace[FilteredData,_?DataPointNoneQ->None,{1}];
(* expand data points to include error bars *)
(* -- x error bar *)
ExpandedData=Replace[
FilteredData,
{
{x_?NumericQ,y_}:>{ErrorValue[x,{None,None}],y},
{ErrorValue[x_,None],y_}:>{ErrorValue[x,{None,None}],y},
{ErrorValue[x_,dx_?NumericQ],y_}:>{ErrorValue[x,{-dx,dx}],y}
},
{1}
];
(* -- y error bar *)
ExpandedData=Replace[
ExpandedData,
{
{x_,y_?NumericQ}:>{x,ErrorValue[y,{None,None}]},
{x_,ErrorValue[y_,None]}:>{x,ErrorValue[y,{None,None}]},
{x_,ErrorValue[y_,dy_?NumericQ]}:>{x,ErrorValue[y,{-dy,dy}]}
},
{1}
];
(* scale data and error bars *)
ScaledData=Switch[
AxisScaling/.DataValuesOpts,
None|{None,None},ExpandedData,
Log|{None,Log},TransformData[{#[[1]],DataLog[10,#[[2]]]}&]@ExpandedData,
{Log,None},TransformData[{DataLog[10,#[[1]]],#[[2]]}&]@ExpandedData,
{Log,Log},TransformData[{DataLog[10,#[[1]]],DataLog[10,#[[2]]]}&]@ExpandedData
];
(* collapse any points with None for x or y coordinate into a simple None *)
FinalData=Replace[ScaledData,_?DataPointNoneQ->None,{1}];
(*Print[FinalData];*)

(* translate points into canvas coordinates *)
Points=Replace[
FinalData,
{
{ErrorValue[x_,{dxm_,dxp_}],ErrorValue[y_,{dym_,dyp_}]}:>
{ErrorValue[ApplyOrNone[XCOfXU]@x,ApplyOrNone[DXCOfXU]/@{dxm,dxp}],ErrorValue[ApplyOrNone[YCOfYU]@y,ApplyOrNone[DYCOfYU]/@{dym,dyp}]}
},
{1}
];
(* select points with central values *)
ValuePoints=Cases[Points,Except[None]];
ValuePointCenters=(ValuePoints/.{ErrorValue[x_,_]:>x});
(* partition line at points without values *)
Segments=PartitionDataForLine[(Points/.{ErrorValue[x_,_]:>x})];
If[
(IgnoreMissingValues/.DataLineOpts),
Segments={Join@@Segments}
];

(* Construct lines with drop*)
LinePoints=If[
(Show/.DataLineOpts),
DataLineShape[LineShape/.DataLineOpts,PlotPoints/.DataLineOpts]/@Segments,
{}
];
If[(Transpose/.DataLineOpts),LinePoints=Map[Reverse,LinePoints,{2}]]; (* quick fix for L. Shao *)
(*Print[LinePoints];*)
DropFillArt=Polygon/@LinePoints;  (* TO DO: more sophisticated handling of endpoints *)
LineArt=Line/@LinePoints;

(* Construct symbols *)

If[
(Show/.DataSymbolOpts),
PointVertices=DataSymbolVertices[SymbolShape/.DataSymbolOpts,SymbolSize/.DataSymbolOpts,PlotPoints/.DataSymbolOpts]/@ValuePointCenters
];

SymbolOutlineArt=If[
(Show/.DataSymbolOpts),
(Line[Append[#,First[#]]]&)/@PointVertices,
{}
];
SymbolFillArt=If[
(Show/.DataSymbolOpts),
Polygon/@PointVertices,
{}
];

(* Construct error bars *)
ErrorBarArt=If[
(Show/.DataSymbolOpts),

Join[
Cases[
ValuePoints,
{ErrorValue[x_,{dxm_?NumericQ,dxp_}],ErrorValue[y_,{dym_,dyp_}]}:>ErrorBarPrimatives[{x,y},{dxm,0},{0,(SymbolSize/.DataSymbolOpts)/2}]
],
Cases[
ValuePoints,
{ErrorValue[x_,{dxm_,dxp_?NumericQ}],ErrorValue[y_,{dym_,dyp_}]}:>ErrorBarPrimatives[{x,y},{dxp,0},{0,(SymbolSize/.DataSymbolOpts)/2}]
],
Cases[
ValuePoints,
{ErrorValue[x_,{dxm_,dxp_}],ErrorValue[y_,{dym_?NumericQ,dyp_}]}:>ErrorBarPrimatives[{x,y},{0,dym},{(SymbolSize/.DataSymbolOpts)/2,0}]
],
Cases[
ValuePoints,
{ErrorValue[x_,{dxm_,dxp_}],ErrorValue[y_,{dym_,dyp_?NumericQ}]}:>ErrorBarPrimatives[{x,y},{0,dyp},{(SymbolSize/.DataSymbolOpts)/2,0}]
]
],
{}
];

(* Save dataset info *)
(* TO DO: make use of DefineDataStyle, or convert to full object management *)
If[Tag=!=None,
LevelScheme`Data`DataTagDefined[Tag]=True;
LevelScheme`Data`DataValuesOpts[Tag]=DataValuesOpts;
LevelScheme`Data`DataLineOpts[Tag]=DataLineOpts;
LevelScheme`Data`DataSymbolOpts[Tag]=DataSymbolOpts;
LevelScheme`Data`DataCanvasPoints[Tag]=ValuePointCenters
];

(* Draw artwork *)

{

(* Line with drop fill -- behind data points *)
MakeFill[{DropFillArt},DataLineOpts],
MakeOutline[LineArt,DataLineOpts],

(* Error bars -- behind symbol fill *)
MakeOutline[{ErrorBarArt},DataSymbolOpts],

(* Symbols *)

MakeFill[{SymbolFillArt},DataSymbolOpts],
MakeOutline[{SymbolOutlineArt},DataSymbolOpts]

}

];


DataPlot[DataSet[Data_List,DataSetOptsSeq___?OptionQ],Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[DataPlot,Opts],
Item,
LineOpts={},
SymbolOpts={},
LineEnabled=False,
SymbolEnabled=False,
SafeData
},

CheckInScheme[];
CheckOption[ShowData,True|False,FullOpts];
If[
(DataStyle/.FullOpts)=!=None,
CheckDataSet[(DataStyle/.FullOpts)]
];

CheckValue[(Tag/.FullOpts),_?LevelIdentifierQ,"a data set identifier symbol (cannot be list or number)"];

If[Debug/.FullOpts,Print[(Tag/.FullOpts)]];
If[Debug/.FullOpts,Print[InputForm[Data]]];

BlockSchemeOptions[
(* lock in plotting style options *)
UseDataOptions[FilterRules[FullOpts,{DataLine,DataSymbol,DataStyle}]];
(* lock in data value options *)
SetOptions[DataValues,(DataValues/.FullOpts)];
(* lock in data structure *)
SetOptions[DataSet,FilterRules[{DataSetOptsSeq},{DataColumns}]];
(* make the plot *)
ProcessDataSet[Data,(Tag/.FullOpts)]
]

];


DataPlot[Data_List,Opts___?OptionQ]:=DataPlot[DataSet[Data],Opts];


DataPlot[DataSequence[L_List],Opts___]:=Module[
{Data},
Table[
DataPlot[Data,Opts],
{Data,L}
]
];


DataLabel[ID_,Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[DataLabel,Opts]
},

CheckInScheme[];
CheckDataSet[ID];

BasicLineAnnotations[LevelScheme`Data`DataCanvasPoints[ID],FullOpts]

];


(*LastDataSet[]:=$DataTag;*)


DataTag[ID_,Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[DataTag,Opts]
},

CheckInScheme[];
CheckValue[ID,IDExpr_?LevelIdentifierQ,"a data set identifier symbol (cannot be list or number)"];
$DataTag=ID;

(* store tentative style information in case no plot later made *)
LevelScheme`Data`DataValuesOpts[$DataTag]=FigRealizeOptions[DataValues];
LevelScheme`Data`DataLineOpts[$DataTag]=FigRealizeOptions[DataLine];
LevelScheme`Data`DataSymbolOpts[$DataTag]=FigRealizeOptions[DataSymbol];
LevelScheme`Data`DataCanvasPoints[$DataTag]={};
LevelScheme`Data`DataTagDefined[$DataTag]=True;

];


DefineDataStyle[ID_,Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[DefineDataStyle,Opts]
},
CheckInScheme[];
CheckValue[ID,IDExpr_?LevelIdentifierQ,"a data set identifier symbol (cannot be list or number)"];
(* validation to be done by UseDataOptions *)
(*
CheckOption[DataLine,_List,FullOpts];
CheckOption[DataSymbol,_List,FullOpts];
If[
(DataStyle/.FullOpts)=!=None,
CheckDataSet[(DataStyle/.FullOpts)]
];
*)

BlockSchemeOptions[

(* realize options for current data style *)
UseDataOptions[FilterRules[FullOpts,{DataLine,DataSymbol,DataStyle}]];

(* save these options *)
(* TO UPDATE: to full object management *)
LevelScheme`Data`DataLineOpts[ID]=Options[DataLine];
LevelScheme`Data`DataSymbolOpts[ID]=Options[DataSymbol];
LevelScheme`Data`DataCanvasPoints[ID]={};
LevelScheme`Data`DataTagDefined[ID]=True;

];

];

UseDataOptions[Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[UseDataOptions,Opts]
},
CheckInScheme[];
CheckOption[DataLine,_List,FullOpts];
CheckOption[DataSymbol,_List,FullOpts];
If[
(DataStyle/.FullOpts)=!=None,
CheckDataSet[(DataStyle/.FullOpts)]
];

BlockUnprotect[
{DataLine,DataSymbol},

(* retrieve style *)
If[(DataStyle/.FullOpts)=!=None,
Options[DataLine]=LevelScheme`Data`DataLineOpts[(DataStyle/.FullOpts)];
Options[DataSymbol]=LevelScheme`Data`DataSymbolOpts[(DataStyle/.FullOpts)]
];

(* implement any overrides *)
(* Note: FigRealizeOptions freezes in any inherited values at present defaults *)
Options[DataLine]=FigRealizeOptions[DataLine,(DataLine/.FullOpts)];
Options[DataSymbol]=FigRealizeOptions[DataSymbol,(DataSymbol/.FullOpts)];
];

(* perform validation of options which will not be validated at level of art rendering functions *)
CheckOption[SymbolShape,_String,Options[DataSymbol]];
CheckOption[SymbolSize,(_?NumericQ)?Positive,Options[DataSymbol]];
CheckOption[PlotPoints,_Integer?Positive,Options[DataSymbol]];

(* diagnostics *)
If[
Debug/.FullOpts,
Print["Restoring style: ",(DataStyle/.FullOpts)];
Print[Options[DataLine]];
Print[Options[DataLine]]
];

];


DataLegend[PS:{_?NumericQ,_?NumericQ},DataSetInfo:{{_,_}...},Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[DataLegend,Opts],
P0,Pi,DPY,DPLeft,DPSymbol,DPRight,DPText,DPColumn,OptWidth,OptDimensions,NumRows,
DataSetID,DataSetText,LineVertices,
DataLineOpts,DataSymbolOpts,SymbolVertices,
i
},

(* validate options *)
(* TODO -- full validation *)
CheckOption[Width,Automatic|_?NumericQ,FullOpts];
CheckOption[Dimensions,Automatic|_Integer|{_Integer,_Integer},FullOpts];

(* dimension calculations *)
(* horizontal dimensions: (line: 2*Length) + (gap: Gap) + (text : Width) + (gap: Gap) ... *)
OptWidth=GetAutoOption[Width,15,FullOpts]; (* TODO -- set width from widest text *)
OptDimensions=Switch[
(Dimensions/.FullOpts),
Automatic,{Length[DataSetInfo],1},
_Integer,{(Dimensions/.FullOpts),Max[Ceiling[Length[DataSetInfo]/(Dimensions/.FullOpts)],1]},
{_Integer,_Integer},(Dimensions/.FullOpts)
];
NumRows=First[OptDimensions];(* Dimensions currently just used to set number of rows *)

P0=PCOfPS[PS]; (* starting point UL corner *)
DPY={0,-DYCOfYA[FontSize/.FullOpts]};  (* offset -- down a row *)
DPLeft={0,0}; (* offset -- in to left of line *)
DPSymbol={DXCOfXA[Length/.FullOpts],0}; (* offset -- in to symbol *)
DPRight=2*DPSymbol; (* offset -- in to right of line *)
DPText=DPRight+{DXCOfXA[Gap/.FullOpts],0}; (* offset -- in to text *)
DPColumn=DPText+{DXCOfXA[OptWidth],0}+{DXCOfXA[Gap/.FullOpts],0};

If[
(Show/.FullOpts), (* otherwise overridden by Show in DataLineOpts or DataSymbolOpts *)
TableForEach[
{

(* starting location *)
(* position for start of line: legend UL corner + down half line + down 0-based rows + across 0-based columns *)
Pi=P0+1/2*DPY+Mod[(i-1),NumRows]*(LineSpacing/.FullOpts)*DPY+Quotient[(i-1),NumRows]*(LineSpacing/.FullOpts)*DPColumn;

(* line and symbol *)
BlockSchemeOptions[{
UseDataOptions[DataStyle->DataSetID];
LineVertices={Pi+DPLeft,Pi+DPRight};
MakeOutline[{Line[LineVertices]},Options[DataLine]],
SymbolVertices=DataSymbolVertices[
SymbolShape/.Options[DataSymbol],
SymbolSize/.Options[DataSymbol],
PlotPoints/.Options[DataSymbol]
][Pi+DPSymbol];
MakeOutline[{(Line[Append[#,First[#]]]&)@SymbolVertices},Options[DataSymbol]],
MakeFill[{Polygon@SymbolVertices},Options[DataSymbol]]
}],

(* label *)
MakeText[DataSetText,Pi+DPText,0,Offset->{-1,0},FullOpts]

},
{{DataSetID,DataSetText},i,DataSetInfo}
]
]
];


SchemeDef[Flag_]:=MemberQ[$SchemeFlags,Flag];
SetAttributes[SchemeIf,HoldRest];  (* HoldRest to avoid side effects of evaluating Objects sequence *)
SchemeIf[Expr_,Objects___]:=Sequence@@If[TrueQ[Expr],{Objects},{}];
SetAttributes[SchemeIfDef,HoldRest];  (* HoldRest to avoid side effects of evaluating Objects sequence *)
SchemeIfDef[Flag_,Objects___]:=Sequence@@If[MemberQ[$SchemeFlags,Flag],{Objects},{}];
SetAttributes[SchemeIfNDef,HoldRest];  (* HoldRest to avoid side effects of evaluating Objects sequence *)
SchemeIfNDef[Flag_,Objects___]:=Sequence@@If[!MemberQ[$SchemeFlags,Flag],{Objects},{}];
SetAttributes[SchemeIfElseDef,HoldRest];  (* HoldRest to avoid side effects of evaluating Objects sequence *)
SchemeIfElseDef[Flag_,Object1_,Object2_]:=If[MemberQ[$SchemeFlags,Flag],Object1,Object2];


GetLayer[SchemeGraphics[_,_,LayerID_]]:=LayerID;
SchemeGraphicsOrderedQ=Function[{Obj1,Obj2},GetLayer[Obj1]<=GetLayer[Obj2]];


SetAttributes[Figure,{HoldFirst}];
Figure[Body_List,Opts___?OptionQ]:=Module[
{
(* option variables *)
FullOpts=FigRealizeOptions[Figure,Opts],
ExpansionFactor=10^-4,  (* CHECK -- still needed? *)

(* work variables *)
SchemeList,
RawFrameLabel,
FormattedFrameLabel,
GraphicsPrimatives,
GraphicsOptions,
FullGraphics,
FrameStyleOpts,FrameTextStyleOpts,TickTextStyleOpts,
UsedPlotRange,
ErrorStatus,

(* pattern names *)
(* locally define pattern names used in scheme list processing, to avoid glitch if global value defined (though this is not really a concern in the Private context) *)
GraphicsObject,
Primatives

},

(* Flag entry into Scheme, for error handling mechanism *)
If[$InScheme,
Message[LevelScheme::notreentrant];
Return[]
];
Block[
{
$InScheme=True
},

(* Check options *)
If[CatchError[
(*If[(PlotRange/.FullOpts)===Automatic,Message[Figure::prange]];*)
CheckOption[PlotRange,Automatic|{{_?NumericQ,_?NumericQ},{_?NumericQ,_?NumericQ}},FullOpts];
CheckOption[ImageSize,Automatic|_?NumericQ|{_?NumericQ,_?NumericQ},FullOpts];
CheckOption[BlockOptions,{___Symbol},FullOpts];
CheckOption[Block,{___Symbol},FullOpts];
CheckOption[SchemeFlags,{___String},FullOpts]
],
Return[]
];

(* Debugging *)
If[Information/.FullOpts,
Print[$Version];
Print[{$System,$SystemID,$OperatingSystem,$MachineType,$ProcessorType,$ByteOrdering,$MachineName}];
Print[$Path]
];

(* Clear any existing scheme data definitions *)
Clear["LevelScheme`Data`*","LevelScheme`Multipanel`*","LevelScheme`AutoLevel`"];

(* Set up coordinate systems *)
(* absolute size imitates Show, defaulting to 4*72, with GoldenRatio aspect ratio *)
$AbsSize=Switch[
(ImageSize/.FullOpts),
Automatic,4*72*{1,1/GoldenRatio},
_?NumericQ,(ImageSize/.FullOpts)*{1,1/GoldenRatio},
{_?NumericQ,_?NumericQ},(ImageSize/.FullOpts)
];
(* Plot range is expanded outwards by small fraction in each direction, beyond user-determined nominal range, so ending tick labels are guaranteed to fit in. *) 
UsedPlotRange=ExtendRegion[
N[GetAutoOption[PlotRange,{{0,1},{0,1}},FullOpts]],
(ExtendRange/.FullOpts)
];
$CanvasRange=ExtendRegion[UsedPlotRange,ExpansionFactor];
$P1C=First/@$CanvasRange;$P2C=Last/@$CanvasRange;
$TickScaleFactor=(Plus@@$AbsSize/2);
If[
CatchError[SetRegion[]],
Return[]
];

(* Initialize global state variables *)
$SchemeFlags=(SchemeFlags/.FullOpts);
$LastLevel=Null;
$Background=None;

(* Evaluate body *)
(* implements held calls to SetOptions, catches any Throw from option or parameter validation *)
Block[
{$DisplayFunction=Identity},
Block[
Evaluate[(Block/.FullOpts)],
BlockOptions[
Union[OptionSymbols,OptionSymbols3D,(BlockOptions/.FullOpts)],
ErrorStatus=CatchError[SchemeList=Body]
]
]
];
(* handle possible error thrown by ErrorMessage, but only now after block constructs have restored all scoped values *)
If[ErrorStatus,
Return[]
];

(* Preprocess list of scheme objects *)
(* Flatten list *)
SchemeList=Flatten[SchemeList];
If[
Debug/.FullOpts,
Print["Object list after flattening: ",SchemeList//InputForm]
];
(* Strip any remaining unidentified objects *)
If[
Count[SchemeList,(_Graphics|_ContourGraphics|_DensityGraphics),{1}]!=0,
Message[Figure::freegraphics]
];
If[
Count[SchemeList,(_SchemeGraphics*_)|(_SchemeGraphics^_),Infinity]!=0,
Message[Figure::timesgraphics]
];
SchemeList=Cases[SchemeList,_SchemeGraphics];
If[Debug/.FullOpts,
Print["Object list after cleanup: ",(SchemeList//InputForm)//TableForm]
];

(* Sort scheme by layer *)
SchemeList=Sort[SchemeList,SchemeGraphicsOrderedQ];

(* Extract all the graphics primatives *)
GraphicsPrimatives=Replace[
SchemeList,
{SchemeGraphics[Directives_List,Primatives_List,_]:>Join[Directives,Primatives]},
{1}
];
GraphicsPrimatives=Flatten[GraphicsPrimatives,1];
If[Debug/.FullOpts,
Print["Graphics size before directive pruning: ",ByteCount[GraphicsPrimatives]," bytes"]
];

(* Construct graphics display options *)
If[
CatchError[
FrameStyleOpts=MakeOutlineDirectives[FullOpts];
FrameTextStyleOpts=MakeTextStyle[FullOpts];
TickTextStyleOpts=MakeTextStyle[OptionsUnion[
(* TickOpacity ignored *)
FontFamily->GetAutoOption[TickFontFamily,FontFamily/.FullOpts,FullOpts],
FontSize->GetAutoOption[TickFontSize,FontSize/.FullOpts,FullOpts],
FontWeight->GetAutoOption[TickFontWeight,FontWeight/.FullOpts,FullOpts],
FontSlant->GetAutoOption[TickFontSlant,FontSlant/.FullOpts,FullOpts],
FontTracking->GetAutoOption[TickFontTracking,FontTracking/.FullOpts,FullOpts],
FontColor->GetAutoOption[TickFontColor,FontColor/.FullOpts,FullOpts],
FontOpacity->GetAutoOption[TickFontOpacity,FontOpacity/.FullOpts,FullOpts],
FullOpts
]]
],
Return[]
];
RawFrameLabel=Switch[
(FrameLabel/.FullOpts),
None,
None,
Automatic,
{LabB,LabL,LabT,LabR}/.FullOpts,
_List,
(FrameLabel/.FullOpts)
];
FormattedFrameLabel=Switch[
RawFrameLabel,
None,None,
_List,(If[#===None,None,DisplayForm[StyleForm[#,Sequence@@FrameTextStyleOpts]]])&/@RawFrameLabel
];
GraphicsOptions={
PlotRange ->$CanvasRange,
ImageSize->$AbsSize,AspectRatio->$AbsSize[[2]]/$AbsSize[[1]],
Frame-> (Frame/.FullOpts),
FrameStyle->Directive[FrameStyleOpts],
FrameLabel->FormattedFrameLabel,
FrameTicks->(FrameTicks/.FullOpts),
Axes->(Axes/.FullOpts),
Ticks->(Ticks/.FullOpts),
TextStyle->TickTextStyleOpts,
Background->(Background/.FullOpts),
DisplayFunction->(DisplayFunction/.FullOpts)
};
If[Debug/.FullOpts,
Print["Graphics options: ",GraphicsOptions]
];

(* Construct and render full graphics object *)
FullGraphics=Graphics[GraphicsPrimatives,GraphicsOptions];
Show[FullGraphics];

(* Delete scheme data definitions *)
Clear["LevelScheme`Data`*","LevelScheme`Multipanel`*","LevelScheme`AutoLevel`"];


(* Return result *)
FullGraphics

]
];


AutoLevelInit[Posn_,Space_,BigSpace_]  :=Module[{},
CheckInScheme[];
LevelScheme`AutoLevel`IDi = Null;
LevelScheme`AutoLevel`Posn = Posn;
LevelScheme`AutoLevel`Space = Space;
LevelScheme`AutoLevel`xbigSpace = BigSpace;
Null
];

AutoLevel[IDi_?LevelIdentifierQ]:=Module[{},
CheckInScheme[];
LevelScheme`AutoLevel`Posn+=If[TrueQ[LevelScheme`AutoLevel`IDi === Null], 0,LevelScheme`AutoLevel`xbigSpace-LevelScheme`AutoLevel`Space];
LevelScheme`AutoLevel`IDi=IDi
];

AutoTrans[IDf_?LevelIdentifierQ,Opts___?OptionQ]:=Module[
{Posn},
CheckInScheme[];
Posn=LevelScheme`AutoLevel`Posn;
LevelScheme`AutoLevel`Posn+=LevelScheme`AutoLevel`Space; 
Trans[LevelScheme`AutoLevel`IDi,Posn,IDf,Automatic,Opts]
];


ExtractCurves[G:(_Graphics|_Graphics3D)]:=Module[
{LineSet,CurveComplexSet},
LineSet=Cases[G,Line[c:{{_?NumericQ,_?NumericQ}..}]|Line[cc:{{{_?NumericQ,_?NumericQ}..}..}],Infinity];
CurveComplexSet=Replace[
LineSet,
{Line[c:{{_?NumericQ,_?NumericQ}..}]:>{c},Line[cc:{{{_?NumericQ,_?NumericQ}..}..}]:>cc},
{1}
];
Flatten[CurveComplexSet,1]
];


ExtractCurves[CG:(_ContourGraphics)]:=ExtractCurves[Graphics[CG]];


GrabPoints[G:(_Graphics|_Graphics3D|_ContourGraphics)]:=Module[
{Curves},

Curves=ExtractCurves[G];
If[
Length[Curves]==0,
Message[GrabPoints::nolines]
];
If[
Length[Curves]>1,
Message[GrabPoints::manylines]
];
First[Curves]
];


LineStyle[Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[LineStyle,Opts]
},
MakeOutlineDirectives[FullOpts]
];


FillStyle[Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[FillStyle,Opts]
},
MakeFillDirectives[FullOpts]
];


IndentingNewline=FromCharacterCode[62371];
SchemeTemplateCell=Cell[BoxData[RowBox[{
RowBox[{
"Scheme","[",IndentingNewline,RowBox[{\({}\),",",IndentingNewline,\(PlotRange->\({\({0,1}\),\({0,1}\)}\)\),",",IndentingNewline,\(ImageSize->\(72*\({6,4}\)\)\)}],IndentingNewline,"]"
}],
";"
}]],"Input"];
SchemeTemplate[]:=CellPrint[SchemeTemplateCell];


LevelScheme[]:=Get["LevelScheme`"];


MultipanelSettings[]:=Module[
{SymbolNames},
SymbolNames=Names["LevelScheme`Multipanel`*"];
(Print[#," ",ToExpression[#]]&)/@SymbolNames
];


SetAttributes[BlockSchemeOptions,HoldAll];
BlockSchemeOptions[Expr_]:=BlockOptions[
Join[OptionSymbols,OptionSymbols3D],
Expr
];


Expr:HoldPattern[Lev[___]]:=FallThroughError[Lev,Expr];
Expr:HoldPattern[ExtensionLine[___]]:=FallThroughError[ExtensionLine,Expr];
Expr:HoldPattern[Connector[___]]:=FallThroughError[Connector,Expr];
Expr:HoldPattern[Trans[___]]:=FallThroughError[Trans,Expr];
Expr:HoldPattern[ManualLabel[___]]:=FallThroughError[ManualLabel,Expr];
Expr:HoldPattern[ScaledLabel[___]]:=FallThroughError[ScaledLabel,Expr];
Expr:HoldPattern[BandLabel[___]]:=FallThroughError[BandLabel,Expr];
Expr:HoldPattern[LevelLabel[___]]:=FallThroughError[LevelLabel,Expr];
Expr:HoldPattern[SchemeBracket[___]]:=FallThroughError[SchemeBracket,Expr];Expr:HoldPattern[SchemeLine[___]]:=FallThroughError[SchemeLine,Expr];
Expr:HoldPattern[SchemePoints[___]]:=FallThroughError[SchemePoints,Expr];
Expr:HoldPattern[SchemePolygon[___]]:=FallThroughError[SchemePolygon,Expr];
Expr:HoldPattern[SchemeCircle[___]]:=FallThroughError[SchemeCircle,Expr];
Expr:HoldPattern[SchemeEllipse[___]]:=FallThroughError[SchemeEllipse,Expr];
Expr:HoldPattern[SchemeBox[___]]:=FallThroughError[SchemeBox,Expr];
Expr:HoldPattern[SchemeSquare[___]]:=FallThroughError[SchemeSquare,Expr];
Expr:HoldPattern[SchemeArrow[___]]:=FallThroughError[SchemeArrow,Expr];
Expr:HoldPattern[RawGraphics[___]]:=FallThroughError[RawGraphics,Expr];
Expr:HoldPattern[FigGraphics[___]]:=FallThroughError[FigGraphics,Expr];
Expr:HoldPattern[ViewPort3D[___]]:=FallThroughError[ViewPort3D,Expr];
Expr:HoldPattern[ScaledViewPort3D[___]]:=FallThroughError[ViewPort3D,Expr];
Expr:HoldPattern[FigurePanel[___]]:=FallThroughError[FigurePanel,Expr];
Expr:HoldPattern[ScaledFigurePanel[___]]:=FallThroughError[ScaledFigurePanel,Expr];
Expr:HoldPattern[Multipanel[___]]:=FallThroughError[Multipanel,Expr];
Expr:HoldPattern[SchemeAxis[___]]:=FallThroughError[SchemeAxis,Expr];

Expr:HoldPattern[PanelLetter[___]]:=FallThroughError[PanelLetter,Expr];
Expr:HoldPattern[LineStyle[___]]:=FallThroughError[LineStyle,Expr];
Expr:HoldPattern[FillStyle[___]]:=FallThroughError[FillStyle,Expr];

Expr:HoldPattern[DataPlot[___]]:=FallThroughError[DataPlot,Expr];
Expr:HoldPattern[DataLegend[___]]:=FallThroughError[DataLegend,Expr];
Expr:HoldPattern[DataTag[___]]:=FallThroughError[DataTag,Expr];
Expr:HoldPattern[DefineDataStyle[___]]:=FallThroughError[DefineDataStyle,Expr];
Expr:HoldPattern[UseDataOptions[___]]:=FallThroughError[UseDataOptions,Expr];
Expr:HoldPattern[DataLabel[___]]:=FallThroughError[DataLabel,Expr];

Expr:HoldPattern[SetRegion[___]]:=FallThroughError[SetRegion,Expr];
Expr:HoldPattern[SetOrigin[___]]:=FallThroughError[SetOrigin,Expr];
Expr:HoldPattern[SetScale[___]]:=FallThroughError[SetScale,Expr];

(*Expr:HoldPattern[ConvertCoordinate[___]]:=FallThroughError[ConvertCoordinate,Expr];*)
Expr:HoldPattern[ConvertRange[___]]:=FallThroughError[ConvertRange,Expr];
Expr:HoldPattern[ConvertRegion[___]]:=FallThroughError[ConvertRegion,Expr];

Expr:HoldPattern[ManualLabel3D[___]]:=FallThroughError[ManualLabel3D,Expr];Expr:HoldPattern[SchemeLine3D[___]]:=FallThroughError[SchemeLine3D,Expr];
Expr:HoldPattern[SchemeArrow3D[___]]:=FallThroughError[SchemeArrow3D,Expr];
Expr:HoldPattern[RawGraphics3D[___]]:=FallThroughError[RawGraphics3D,Expr];


Expr:HoldPattern[Figure[___]]:=Message[Figure::args,Scheme];


Expr:HoldPattern[AttachIndex[___]]:=Message[AttachIndex::args,HoldForm[Expr]];


SetSchemeOrigin[Args___]:=Module[
{},
Message[SetSchemeOrigin::deprecated];
SetOrigin[Args]
];
SetSchemeScale[Args___]:=Module[
{},
Message[SetSchemeScale::deprecated];
SetScale[Args]
];
SetSchemeRegion[Args___]:=Module[
{},
Message[SetSchemeRegion::deprecated];
SetRegion[Args]
];
TransArrow[Args___] :=Module[
{},
Message[TransArrow::deprecated];
Trans[Args]
];
AnnotateL[ID_,Args___] :=Module[
{},
Message[AnnotateL::deprecated];
LevelLabel[ID,Left,Args]
];
AnnotateR[ID_,Args___] :=Module[
{},
Message[AnnotateR::deprecated];
LevelLabel[ID,Right,Args]
];
ExtensionLineL[ID_,Args___] :=Module[
{},
Message[ExtensionLineL::deprecated];
ExtensionLine[ID,Left,Args]
];
ExtensionLineR[ID_,Args___] :=Module[
{},
Message[ExtensionLineR::deprecated];
ExtensionLine[ID,Right,Args]
];
SchemeAxisB[Args___] :=Module[
{},
Message[SchemeAxisB::deprecated];
SchemeAxis[Bottom,Args]
];
SchemeAxisL[Args___] :=Module[
{},
Message[SchemeAxisL::deprecated];
SchemeAxis[Left,Args]
];
SchemeAxisT[Args___] :=Module[
{},
Message[SchemeAxisT::deprecated];
SchemeAxis[Top,Args]
];
SchemeAxisR[Args___] :=Module[
{},
Message[SchemeAxisR::deprecated];
SchemeAxis[Right,Args]
];
RegionLabel[Args___] :=Module[
{},
Message[RegionLabel::deprecated];
ScaledLabel[Args]
];
AutoInit[Args___]:=Module[
{},
Message[AutoInit::deprecated];
AutoLevelInit[Args]
];
AutoPanel[Args___]:=Module[
{},
Message[AutoPanel::replaced]
];
AutoPanelInit[Args___]:=Module[
{},
Message[AutoPanelInit::replaced]
];
ResetCoordinates[]:=Module[
{},
Message[ResetCoordinates::deprecated];
SetRegion[]
];


Scheme=Figure;


SchemePoints[Points_List,Opts___?OptionQ]:=Module[
{
FullOpts=FigRealizeOptions[SchemePoints,Opts],
BasicShape,i,Point,PointVertices,CentralPoints,ExpandedErrorPoints,ErrorBars
},

Message[SchemePoints::deprecated];
CheckInScheme[];
CheckOption[SymbolShape,_String,FullOpts];
CheckOption[SymbolSize,(_?NumericQ)?Positive,FullOpts];
CheckOption[PlotPoints,_Integer?Positive,FullOpts];

(* Construct points *)
BasicShape=DPCOfPA/@((SymbolSize/.FullOpts)*N[DataSymbolShape[(SymbolShape/.FullOpts),(PlotPoints/.FullOpts)]]);
If[!MatchQ[BasicShape,{{_?NumericQ,_?NumericQ}..}],ErrorMessage[DataSymbol::badsymbol,(SymbolShape/.FullOpts)]];
CentralPoints=(Points/.{ErrorValue[x_,_]:>x});
PointVertices=TableForEach[
(PCOfPU[Point]+#)&/@BasicShape,
{Point,CentralPoints}
];

(* Construct error bars *)
ExpandedErrorPoints=(Points/.{ErrorValue[x_,dx_]:>ErrorValue[x,{-dx,dx}]});
ErrorBars=Join[
Cases[
ExpandedErrorPoints,
{(x_)|ErrorValue[x_,_],ErrorValue[y_,{dym_,dyp_}]}:>ErrorBarPrimatives[Vertical,{x,y},{dym,dyp},(SymbolSize/.FullOpts)]
],
Cases[
ExpandedErrorPoints,
{ErrorValue[x_,{dxm_,dxp_}],(y_)|ErrorValue[y_,_]}:>ErrorBarPrimatives[Horizontal,{x,y},{dxm,dxp},(SymbolSize/.FullOpts)]
]
];

(* Draw artwork *)

{

(* Error bars -- behind fill *)
MakeOutline[
{
ErrorBars
},
FullOpts],

(* Fill *)

MakeFill[
{
Polygon/@PointVertices
},
FullOpts],

(* Outline *)

MakeOutline[
{
(Line[Append[#,First[#]]]&)/@PointVertices
},
FullOpts]

}

];


End[];


Protect[Evaluate[$Context<>"*"]];
Unprotect[Evaluate[$Context<>"DataLineShape"]];
Unprotect[Evaluate[$Context<>"DataSymbolShape"]];
EndPackage[];
