(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* :Title: InheritOptions *)
(* :Context: InheritOptions` *)
(* :Author: Mark A. Caprio, Department of Physics, University of Notre Dame *)
(* :Summary: Option value inheritance system and miscellaneous option processing utilities. *)
(* :Copyright: Copyright 2011, Mark A. Caprio *)
(* :Package Version: 2.01 *)
(* :Mathematica Version: 6.0 *)
(* :History:
 V1 .0, March 8, 2005.  CPCPL distribution with LevelScheme.
 V1.1, July 8, 2005.  Added KnownOptions.  MathSource distribution.
 V1.2, August 3, 2007.  Mathematica 6 compatibility update to avoid overwriting Inherited usage message.
V1.21, October 21, 2009.  Documentation update.
V2.0, June 22, 2011. DoForEach/TableForEach iteration replaced with simple Do/Table (requires Mathematica 6 or above).
Restructured to load from init.m file.  Add inheritance descriptor {parent,{option1->value1,...},All} for override of specific defaults while inheriting all options.  Modify RealizeOptions to work also for symbol with no OptionInheritanceRules.  Undocument function GetAutoOption as unrelated to inheritance.
V2.01, April 21, 2012. GetAutoOption and FlatOptionListQ accept strings as option name, though not presently supported for option inheritance.
*)


BeginPackage["InheritOptions`"];


Unprotect[Evaluate[$Context<>"*"]];


KnownOptions::usage="KnownOptions[symbol] returns a sorted list of known options for symbol.";
KnownOption::usage="KnownOption[symbol,option] returns true if option is a known option for symbol.";
FlatOptionListQ::usage="FlatOptionListQ[x] returns True if x is a flat list of option specifications, i.e., rules matching (_Symbol\[Rule]_)|(_Symbol\[RuleDelayed]_).  It is thus more specific than the standard OptionQ.";
OptionsSort::usage="OptionsSort[options] flattens an option specification and sorts by option name.  Order is preserved for rules for the same option.";
OptionsUnion::usage="OptionsUnion[options] flattens an option specification and sorts by option name.   Only the first rule for each option is preserved.";
DuplicatedOptions::usage="DuplicatedOptions[options] returns a list of all options which are specified more than once in options.";
GetAutoOption::usage="GetAutoOption[option,default,optionlist] retrieves the value for option specified in optionlist, substituting defaultvalue if option value is Automatic.";
DefineOptions::usage="DefineOptions[symbol,{parent,{inheritedoption,...}},...,{newoption->value,...}] set up option iheritance for symbol.  The value All may be given instead of an explicit list of inherited options.  An inherited option may be given as a rule, in which case the default value is not Inherited.  DefineOptions defines Options and OptionParents values for symbol.";
RealizeOptions::usage="RealizeOptions[symbol] produces a list (flattened, sorted, and with duplicate option specifications eliminated) of option value rules for symbol, with any options given to RealizeOptions taking precedence over Options[symbol].  Option values are inherited if appropriate.  Checks for illegal inheritance and unknown options are carried out if these were enabled when option inheritance was originally set up for symbol.";
OptionInheritanceRules::usage="OptionInheritanceRules[symbol] is a list or dispatch table of rules for realizing the inherited option values for symbol and checking option validity.";
Inherited::reusage="Option value indicating the actual value used should be inherited."; (*System`*)
TrapUninheritableOptions::usage="Option for DefineOptions";
TrapUnknownOptions::usage="Option for DefineOptions";
$UninheritableOption::usage="Global variable containing error handler function for attempt to inherit option which does not come from any parent.  Arguments are object name, option name, and full rule.";
$UnknownOption::usage="Global variable containing error handler function for presence of option which is not defined for object.  Arguments are object name, option name, and full rule.";


DefineOptions::badparent="Symbol `1` cannot be used as a parent for option inheritance, since its option list is not valid or was not defined using DefineOptions."; 
DefineOptions::undef="Option `2` is not defined for parent symbol `1`."; 
DefineOptions::duplicate="Symbol has been given multiple definitions of option `1`."; 
General::uninheritopt="Option `2` is not an inheritable option for `1`.";
(* alternative to standard ::optx *)
General::unknownopt="Unknown option `2` specified for `1`."; 


Begin["`Private`"];





KnownOptions[Object_Symbol]:=Union[First/@Options[Object]];KnownOption[Object_Symbol,Option_Symbol]:=MemberQ[KnownOptions[Object],Option];


FlatOptionListQ[x_]:=MatchQ[x,{(((_Symbol|_String)->_)|((_Symbol|_String):>_))...}];


OptionsSort[Opts___?OptionQ]:=Sort[Flatten[{Opts}],OrderedQ[First/@{#1,#2}]&];


OptionsUnion[Opts___?OptionQ]:=First/@Split[OptionsSort[Opts],SameQ[First[#1],First[#2]]&];


DuplicatedOptions[Opts___?OptionQ]:=First/@First/@Select[Split[OptionsSort[Opts],SameQ[First[#1],First[#2]]&],(Length[#]>1)&];


GetAutoOption[Option:(_Symbol|_String),DefaultValue_,FullOpts_?FlatOptionListQ]:=Module[
{Value},
Value=(Option/.FullOpts);
If [Value===Automatic,DefaultValue,Value]
];


Options[DefineOptions]={TrapUninheritableOptions->True,TrapUnknownOptions->True};
DefineOptions[
Object_Symbol,
RawInheritanceSeq:({_Symbol,Repeated[_List,{0,1}],Repeated[All,{0,1}]}...),
RawNewOptions:{___?OptionQ},
Opts___?OptionQ
]:=Module[
{
FullOpts=Flatten[{Opts,Options[DefineOptions]}],
RawInheritanceList={RawInheritanceSeq},
NewOptions=Flatten[RawNewOptions],
InheritanceArgument,Parent,OptionList,AllFlag,Option,
InheritanceList,ObjectOptions,BasicInheritanceRules,ErrorTrapRules,FullRule
},
Catch[
(* audit and expand inheritance list *)
InheritanceList=Table[

(* break down raw pair *)
{Parent,OptionList,AllFlag}=Replace[
InheritanceArgument,
{
{s_Symbol,l_List:{},All}:>{s,l,True},
{s_Symbol,l_List:{}}:>{s,l,False}
}
];

(* audit parent option list *)
If[
!FlatOptionListQ[Options[Parent]],
Message[DefineOptions::badparent,Parent];Throw[Null]
];
If[
!MatchQ[OptionInheritanceRules[Parent],_List|_Dispatch],
Message[DefineOptions::badparent,Parent];Throw[Null]
];

(* append all parent option names to list of options, if All specified *)
OptionList=Join[OptionList,If[AllFlag,First/@Options[Parent],{}]];

(* expand plain option names to rules with value Inherited *)
OptionList=Replace[OptionList,Option_Symbol:>(Option->Inherited),{1}];

(* remove redundancies, e.g., from a default-value override followed by All *)
OptionList=OptionsUnion[OptionList];

(* check that all options are inheritable from parent *)
Do[
If[
!KnownOption[Parent,Option],
Message[DefineOptions::undef,Parent,Option];Throw[Null]
],
{Option,First/@OptionList}
];

(* return completed pair *)
{Parent,OptionList},
{InheritanceArgument,RawInheritanceList}
];

(* construct full option list *)
(* combine inherited and new options, without duplicate elimination *)
ObjectOptions=OptionsSort[Last/@InheritanceList,NewOptions];
(* check for duplicated options *)
Do[
Message[DefineOptions::duplicate,Option];Throw[Null],
{Option,DuplicatedOptions[ObjectOptions]}
];
(* save resulting options list *)
Options[Object]=ObjectOptions;

(* construct inheritance rules *)
(* Rule and RuleDelay in each case treated separately to facilitate construction of Dispatch table *)
Block[
{InheritOption,$UninheritableOption,$UnknownOption},
BasicInheritanceRules=Table[
(* break down pair *)
{Parent,OptionList}=Pair;
OptionList=First/@OptionList;
(* return list of rule transformation *)
Table[
{
(Option->Inherited):>Evaluate[InheritOption[Parent,Option]],
(Option:>Inherited):>Evaluate[InheritOption[Parent,Option]]
},
{Option,OptionList}
],
{Pair,InheritanceList}
];
ErrorTrapRules={
If[
TrapUninheritableOptions/.FullOpts,
Table[
{
FullRule:(Option->Inherited):>Evaluate[$UninheritableOption[Object,Option,FullRule]],
FullRule:(Option:>Inherited):>Evaluate[$UninheritableOption[Object,Option,FullRule]]
},
{Option,First/@NewOptions}
],
{}
],
If[
TrapUnknownOptions/.FullOpts,
FullRule:((Option_Symbol->Value_)|(Option_Symbol:>Value_))/;!KnownOption[Object,Option]:>Evaluate[$UnknownOption[Object,Option,FullRule]],
{}
]
};
OptionInheritanceRules[Object]^=Dispatch[Flatten[{BasicInheritanceRules,ErrorTrapRules}]]
]
];
Null
];


InheritOption[Parent_Symbol,Option_Symbol]:=Module[
{ParentRule,ParentValue},

(* extract parent's rule for option *)
ParentRule=First[Cases[Options[Parent],(Option->_)|(Option:>_),{1},1]];

(* check whether parent again inherits *)
(* Hold is to avoid direct evaluation in case of RuleDelayed with side effects *)
ParentValue=Extract[ParentRule,{2},Hold];
If[
ParentValue===Hold[Inherited],
Replace[Option->Inherited,OptionInheritanceRules[Parent]],
ParentRule
]
];


$UninheritableOption=Function[{Object,Option,FullRule},Message[Object::uninheritopt,Object,Option];FullRule];
$UnknownOption=Function[{Object,Option,FullRule},Message[Object::unknownopt,Object,Option];FullRule];


RealizeOptions[Object_Symbol,Opts___?OptionQ]:=Replace[
OptionsUnion[Opts,Options[Object]],
If[Head[OptionInheritanceRules[Object]]===OptionInheritanceRules,
{},
OptionInheritanceRules[Object]
],
{1}
];


End[];


Protect[Evaluate[$Context<>"*"]];
Unprotect[Evaluate[$Context<>"$*"]];
EndPackage[];
