(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    111049,       2980]
NotebookOptionsPosition[    104811,       2771]
NotebookOutlinePosition[    105690,       2806]
CellTagsIndexPosition[    105647,       2803]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Header comments", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Title", ":", " ", "CustomTicks"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Context", ":", " ", "CustomTicks`"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"Author", ":", " ", 
      RowBox[{"Mark", " ", 
       RowBox[{"A", ".", " ", "Caprio"}]}]}]}], ",", " ", 
    RowBox[{"Department", " ", "of", " ", "Physics"}], ",", " ", 
    RowBox[{"University", " ", "of", " ", "Notre", " ", "Dame"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"Summary", ":", " ", 
      RowBox[{
      "Custom", " ", "tick", " ", "mark", " ", "generation", " ", "for", " ", 
       "linear"}]}]}], ",", " ", "log", ",", " ", 
    RowBox[{"and", " ", "general", " ", "nonlinear", " ", 
     RowBox[{"axes", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"Copyright", ":", " ", 
      RowBox[{"Copyright", " ", "2010"}]}]}], ",", " ", 
    RowBox[{"Mark", " ", 
     RowBox[{"A", ".", " ", "Caprio"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Package", " ", 
     RowBox[{"Version", ":", " ", "1.81"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{":", 
    RowBox[{"Mathematica", " ", 
     RowBox[{"Version", ":", " ", "6.0"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{":", 
     RowBox[{"History", ":", "\[IndentingNewLine]", 
      RowBox[{"MCAxes", " ", "package"}]}]}], ",", " ", 
    RowBox[{"January", " ", "10"}], ",", " ", 
    RowBox[{
    "2003.", "\[IndentingNewLine]", " ", "MCAxes", " ", "and", " ", "then", 
     " ", "MCTicks", " ", "packages", " ", "distributed", " ", "as", " ", 
     "part", " ", "of", " ", "LevelScheme"}], ",", " ", 
    RowBox[{"2004.", "\[IndentingNewLine]", " ", "V1", 
     RowBox[{".0", ".", " ", "March"}], " ", "11"}], ",", " ", 
    RowBox[{"2005.", "  ", "MathSource", " ", 
     RowBox[{"No", ".", " ", "5599."}], "\[IndentingNewLine]", " ", "V1", 
     RowBox[{".1", ".", " ", "March"}], " ", "18"}], ",", " ", 
    RowBox[{"2005.", "  ", "Documentation", " ", 
     RowBox[{"update", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".2", ".", " ", "September"}], " ", "17"}], ",", " ", 
    RowBox[{"2005.", "  ", "Simplified", " ", "LogTicks", " ", 
     RowBox[{"syntax", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".3", ".", " ", "November"}], " ", "29"}], ",", " ", 
    RowBox[{"2005.", "  ", "Documentation", " ", 
     RowBox[{"update", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".4", ".", " ", "July"}], " ", "18"}], ",", " ", 
    RowBox[{"2007.", "  ", "FixedPointForm"}], ",", " ", 
    RowBox[{"ExtraTicks", " ", 
     RowBox[{"option", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".5", ".", " ", "August"}], " ", "2"}], ",", " ", 
    RowBox[{"2007.", "  ", "Mathematica", " ", "6", " ", "compatibility", " ", 
     RowBox[{"update", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".6", ".", " ", "July"}], " ", "10"}], ",", " ", 
    RowBox[{
    "2008.", "  ", "Overhaul", " ", "of", " ", "FixedPointForm", " ", "to", 
     " ", "string", " ", 
     RowBox[{"output", ".", "  ", "Separate"}], " ", "options", " ", "for", 
     " ", 
     RowBox[{"LogTicks", ".", "  ", "Updates"}], " ", "for", " ", "use", " ", 
     "of", " ", "LinTicks", " ", "and", " ", "LogTicks", " ", "as", " ", 
     "automatic", " ", "tick", " ", 
     RowBox[{"functions", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".61", ".", " ", "July"}], " ", "23"}], ",", " ", 
    RowBox[{
    "2008.", " ", "Workaround", " ", "for", " ", "unexpected", " ", 
     "behavior", " ", "of", " ", 
     RowBox[{"RealDigits", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".62", ".", " ", "September"}], " ", "30"}], ",", " ", 
    RowBox[{
    "2008.", " ", "Rounding", " ", "rather", " ", "than", " ", "truncation", 
     " ", "on", " ", "digits", " ", "to", " ", "right", " ", "of", " ", 
     "decimal", " ", 
     RowBox[{"point", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".63", ".", " ", "December"}], " ", "29"}], ",", " ", 
    RowBox[{"2009.", " ", "TickTest", " ", "and", " ", 
     RowBox[{"TickLabelTest", ".", "  ", "TickLengthScale"}], " ", "and", " ", 
     RowBox[{
     "TickReverse", ".", "  ", "LimitTickLabelRange", ".", 
      "\[IndentingNewLine]", "V1"}], 
     RowBox[{".64", ".", " ", "October"}], " ", "27"}], ",", " ", 
    RowBox[{
    "2010.", " ", "Context", " ", "changed", " ", "to", " ", "LevelScheme`", 
     "*", 
     RowBox[{".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".70", ".", " ", "June"}], " ", "3"}], ",", " ", 
    RowBox[{"2011.", " ", "Restructured", " ", "with", " ", 
     RowBox[{"init", ".", "m"}], " ", 
     RowBox[{"file", ".", "  ", "Added"}], " ", "option", " ", 
     RowBox[{"LogPlot", ".", "  ", "Replaced"}], " ", "StyleForm", " ", 
     "with", " ", "Style", " ", 
     RowBox[{"(", 
      RowBox[{"Mathematica", " ", "6"}], ")"}], " ", "in", " ", "natural", 
     " ", "log", " ", 
     RowBox[{"plot", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".80", ".", " ", "September"}], " ", "30"}], ",", " ", 
    RowBox[{"2011.", " ", 
     RowBox[{"TickDirection", ".", "\[IndentingNewLine]", "V1"}], 
     RowBox[{".81", ".", " ", "March"}], " ", "24"}], ",", " ", 
    RowBox[{
     RowBox[{"2012.", " ", "Add", " ", "pass"}], "-", 
     RowBox[{
     "through", " ", "of", " ", "nonnumeric", " ", "values", " ", "for", " ", 
      
      RowBox[{"FixedPointForm", ".", "\[IndentingNewLine]", "V1"}], 
      RowBox[{".82", ".", " ", "July"}], " ", "15"}]}], ",", " ", 
    RowBox[{
    "2012.", " ", "Patch", " ", "to", " ", "allow", " ", "negative", " ", 
     "tick", " ", "range", " ", "in", " ", "range", " ", "tests"}], ",", " ", 
    
    RowBox[{
     RowBox[{"for", " ", "use", " ", "with", " ", "reversed"}], "-", 
     RowBox[{"axis", " ", 
      RowBox[{"plots", "."}]}]}]}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Acknowledgements", " ", "for", " ", "bug", " ", "reports", " ", "and", 
     " ", 
     RowBox[{"suggestions", ":", " ", 
      RowBox[{"Johannes", " ", "Grosse"}]}]}], ",", " ", 
    RowBox[{"Will", " ", "Robertson"}], ",", " ", 
    RowBox[{"Robert", " ", "Collyer"}]}], " ", "*)"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.3951514190625*^9, {3.39568157340625*^9, 3.39568157496875*^9}, {
   3.424725546640625*^9, 3.424725567828125*^9}, {3.424727071734375*^9, 
   3.424727073109375*^9}, {3.42472710353125*^9, 3.42472711078125*^9}, {
   3.42472922071875*^9, 3.424729256*^9}, {3.42473050140625*^9, 
   3.424730591828125*^9}, {3.424730948*^9, 3.42473095884375*^9}, {
   3.42473179496875*^9, 3.4247317985625*^9}, {3.425856536703125*^9, 
   3.42585655975*^9}, {3.431814907515625*^9, 3.431814916421875*^9}, {
   3.43181540325*^9, 3.4318154251875*^9}, {3.456517029390625*^9, 
   3.4565170318125*^9}, {3.456517228203125*^9, 3.456517234828125*^9}, {
   3.456517769359375*^9, 3.45651777596875*^9}, {3.4639578190464115`*^9, 
   3.4639578227026615`*^9}, {3.464877504828125*^9, 3.464877509171875*^9}, {
   3.4657255575*^9, 3.46572556121875*^9}, {3.471903775953125*^9, 
   3.471903792171875*^9}, {3.4972227648125*^9, 3.497222765375*^9}, {
   3.5148188310625*^9, 3.51481887053125*^9}, {3.51481890178125*^9, 
   3.514818904453125*^9}, {3.514819079328125*^9, 3.5148190883125*^9}, {
   3.514819169078125*^9, 3.514819288203125*^9}, {3.515273865890625*^9, 
   3.5152738930625*^9}, {3.516129456359375*^9, 3.5161294579375*^9}, {
   3.516132449046875*^9, 3.516132464359375*^9}, {3.51613256821875*^9, 
   3.516132608515625*^9}, {3.516298256375*^9, 3.51629827703125*^9}, {
   3.52642132984375*^9, 3.526421343140625*^9}, {3.54049554575*^9, 
   3.54049558584375*^9}, {3.54162255465625*^9, 3.5416225548125*^9}, {
   3.543179094515625*^9, 3.54317909465625*^9}, {3.55135556959375*^9, 
   3.55135560825*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin package", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", "\"\<CustomTicks`\>\"", "]"}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.497222760296875*^9, 3.49722276228125*^9}, {
   3.51481887890625*^9, 3.51481888025*^9}, {3.51482161584375*^9, 
   3.514821619765625*^9}, 3.5152738965*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"$Context", "<>", "\"\<*\>\""}], "]"}], "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Messages", "Section"],

Cell[CellGroupData[{

Cell["Usage messages", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CustomTicks", "::", "usage"}], "=", 
   "\"\<Reserved symbol for CustomTicks package.\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.516129428234375*^9, 3.51612944584375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LinTicks", "::", "usage"}], "=", 
   "\"\<LinTicks[x1,x2,spacing,subdivisions] or LinTicks[x1,x2] or \
LinTicks[majorlist,minorlist] produces linear or custom rescaled tick \
marks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LogTicks", "::", "usage"}], "=", 
    "\"\<LogTicks[power1,power2] or LogTicks[base,power1,power2] produces \
logarithmic tick marks.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtraTicks", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TickPreTransformation", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.  Mapping from given coordinate value to value \
used for range tests labeling.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TickPostTransformation", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.  Mapping from tick values to actual coordinates \
used for positioning tick mark, applied after all range tests and labeling.\>\
\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TickRange", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TickTest", "::", "usage"}], "=", "\"\<Option for LinTicks.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickLabelTest", "::", "usage"}], "=", 
    "\"\<Option for LinTicks.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowTickLabels", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TickLabelRange", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowFirst", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowLast", "::", "usage"}], "=", "\"\<Option for LinTicks.\>\""}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowMinorTicks", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TickLabelStart", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TickLabelStep", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TickLabelFunction", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DecimalDigits", "::", "usage"}], "=", 
    "\"\<Option for LinTicks.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MajorTickLength", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MinorTickLength", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TickLengthScale", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TickDirection", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TickReverse", "::", "usage"}], "=", 
   "\"\<Legacy option for LinTicks (v1.63).  Use TickDirection (v1.80) \
instead.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MajorTickStyle", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MinorTickStyle", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"MinorTickIndexRange", "::", "usage"}], "=", 
   "\"\<Option for LinTicks.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MinorTickIndexTransformation", "::", "usage"}], "=", 
    "\"\<Option for LinTicks.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FixedPointForm", "::", "usage"}], "=", 
   "\"\<FixedPointForm[x,r] formats x with r digits to the right of the \
decimal point.  It allows as many digits as necessary to the left of the \
decimal point, thereby avoiding the rounding problem associated with \
PaddedForm[x,{n,f}] when n is specified too small (PaddedForm zeros out some \
of the rightmost digits of the number).  It also suppresses any trailing \
decimal point when r=0.  FixedPointForm[x,{l,r}] formats x as a fixed-point \
number with l digits (or spaces) to the left and r to the right of the \
decimal point.  By default, for positive numbers a blank padding space \
appears at left (where a minus sign would be for negative numbers), but with \
NumberSigns->Automatic this space is suppressed.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FractionDigits", "::", "usage"}], "=", 
   "\"\<FractionDigits[x] returns the number of digits to the right of the \
point in the decimal representation of x.  It will return large values, \
determined by Precision, for some numbers, e.g., non-terminating rationals.\>\
\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FractionDigitsBase", "::", "usage"}], "=", 
    "\"\<Option for FractionDigits.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LimitTickRange", "::", "usage"}], "=", 
   "\"\<LimitTickRange[{x1,x2},ticks] selects those ticks with coordinates in \
the range x1...x2.  (The range check on the coordinate allows a tolerance, of \
10^-10, so that legitimate ticks at the edge of the range are not cut off due \
to roundoff error.)\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LimitTickLabelRange", "::", "usage"}], "=", 
   "\"\<LimitTickLabelRange[{x1,x2},ticks] retains the labels on those ticks \
with coordinates approximately in the range x1...x2, stripping the labels \
from all others.  (The range check on the coordinate allows a tolerance, of \
10^-10, so that legitimate ticks at the edge of the range are not cut off due \
to roundoff error.)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StripTickLabels", "::", "usage"}], "=", 
   "\"\<StripTickLabels[ticks] removes any text labels from ticks.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TransformTicks", "::", "usage"}], "=", 
    "\"\<StripTickLabels[positionfcn,lengthfcn,ticks] transforms the \
positions and lengths of all tick marks in a list.  Tick marks must be \
specified in full form, or at least with an explicit pair of in and out \
lengths.\>\""}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AugmentTicks", "::", "usage"}], "=", 
   "\"\<AugmentTicks[labelfunction,lengthlist,stylelist,ticks] augments any \
ticks in ticklist to full form.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AugmentAxisTickOptions", "::", "usage"}], "=", 
   "\"\<AugmentAxisTickOptions[numaxes,list] replaces any None entries with \
null lists and appends additional null lists as needed to make numaxes \
entries.  AugmentAxisTickOptions[numaxes,None] returns a list of null lists.  \
Note that this differs from the behavior of the Mathematica plotting \
functions with FrameTicks, for which an unspecified upper or right axis \
duplicates the given lower or left axis.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TickQ", "::", "usage"}], "=", 
   "\"\<TickQ[x] returns True if x is a valid tick specification.\>\""}], " ",
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TickListQ", "::", "usage"}], "=", 
    "\"\<TickListQ[x] returns True if x is a list of valid tick \
specifications.  This is not a general test for a valid axis tick option \
specification, as None, Automatic, and a function can also be valid axis tick \
option specifications.\>\""}], ";"}], " "}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.456517713734375*^9, 3.456517722890625*^9}, {
  3.463957834843286*^9, 3.4639578401401615`*^9}, {3.464877149*^9, 
  3.4648772659375*^9}, {3.4648777149375*^9, 3.464877848015625*^9}, {
  3.464877937265625*^9, 3.464878011609375*^9}, {3.464878104*^9, 
  3.4648781070625*^9}, {3.465725402515625*^9, 3.46572540709375*^9}, {
  3.526419571578125*^9, 3.526419581046875*^9}, {3.52642059775*^9, 
  3.5264206438125*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin private context", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Private range testing and manipulation utilities", "Section"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "range", " ", "testing", " ", "and", " ", "manipulation", " ", 
    "utilities"}], ",", " ", 
   RowBox[{"from", " ", "package", " ", "MCGraphics"}]}], " ", 
  "*)"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "x2_"}], "}"}], ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x1", "\[LessEqual]", "x"}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{"x", "\[LessEqual]", "x2"}], ")"}]}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "x2_"}], "}"}], ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x1", "\[LessEqual]", "x"}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{"x", "\[LessEqual]", "x2"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InRangeProper", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "x2_"}], "}"}], ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x1", "<", "x"}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{"x", "<", "x2"}], ")"}]}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InRegion", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "x2_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y1_", ",", "y2_"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"InRange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", "x"}], "]"}], "&&", 
    RowBox[{"InRange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y1", ",", "y2"}], "}"}], ",", "y"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InRegion", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"InRange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", "x"}], "]"}], "&&", 
    RowBox[{"InRange", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y1", ",", "y2"}], "}"}], ",", "y"}], "]"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRange", "[", 
    RowBox[{
     RowBox[{"PRange", ":", 
      RowBox[{"{", 
       RowBox[{"x1_", ",", "x2_"}], "}"}]}], ",", 
     RowBox[{"PFrac", ":", 
      RowBox[{"{", 
       RowBox[{"fx1_", ",", "fx2_"}], "}"}]}]}], "]"}], ":=", 
   RowBox[{"PRange", "+", 
    RowBox[{"PFrac", "*", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"+", "1"}]}], "}"}], "*", 
     RowBox[{"-", 
      RowBox[{"Subtract", "@@", "PRange"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtendRegion", "[", 
    RowBox[{
     RowBox[{"PRange", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x1_", ",", "x2_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y1_", ",", "y2_"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PFrac", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"fx1_", ",", "fx2_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"fy1_", ",", "fy2_"}], "}"}]}], "}"}]}]}], "]"}], ":=", 
   RowBox[{"PRange", "+", 
    RowBox[{"PFrac", "*", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"+", "1"}]}], "}"}]}], "}"}], "*", 
     RowBox[{"-", 
      RowBox[{"Subtract", "@@@", "PRange"}]}]}]}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"approximate", " ", "equality", " ", "testing", " ", "utility"}], 
    ",", " ", 
    RowBox[{"from", " ", "package", " ", "MCArithmetic"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "patched", " ", "to", " ", "accept", " ", "reversed", " ", "range", " ", 
    "limits"}], "*)"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.551355497171875*^9, 3.55135550915625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ApproxEqual", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"Chop", "\[Rule]", "1*^-10"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ApproxEqual", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], ",", 
     RowBox[{"y_", "?", "NumericQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"FullOpts", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{"Opts", ",", 
          RowBox[{"Options", "[", "ApproxEqual", "]"}]}], "}"}], "]"}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Chop", "[", 
       RowBox[{
        RowBox[{"x", "-", "y"}], ",", 
        RowBox[{"Chop", "/.", "FullOpts"}]}], "]"}], "\[Equal]", "0"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ApproxEqual", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], ",", "_DirectedInfinity"}], "]"}], ":=",
    "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ApproxEqual", "[", 
    RowBox[{"_DirectedInfinity", ",", 
     RowBox[{"x_", "?", "NumericQ"}]}], "]"}], ":=", "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ApproxInRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1p_", ",", "x2p_"}], "}"}], ",", "x_", ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"With", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1", "=", 
        RowBox[{"Min", "[", 
         RowBox[{"x1p", ",", "x2p"}], "]"}]}], ",", 
       RowBox[{"x2", "=", 
        RowBox[{"Max", "[", 
         RowBox[{"x1p", ",", "x2p"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ApproxEqual", "[", 
       RowBox[{"x", ",", "x1", ",", "Opts"}], "]"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x1", "\[LessEqual]", "x"}], ")"}], "&&", 
        RowBox[{"(", 
         RowBox[{"x", "\[LessEqual]", "x2"}], ")"}]}], ")"}], "||", 
      RowBox[{"ApproxEqual", "[", 
       RowBox[{"x", ",", "x2", ",", "Opts"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ApproxIntegerQ", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"ApproxEqual", "[", 
    RowBox[{
     RowBox[{"Round", "[", "x", "]"}], ",", "x", ",", "Opts"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.55135552725*^9, 3.55135556003125*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tick label formatting utilities", "Section"],

Cell[CellGroupData[{

Cell["Digit counting", "Subsection"],

Cell["\<\
FractionDigits -- returns number of digits to right of point in \
arbitrary-base representation of x, up to specified limit
Not based on RealDigits since too easily fooled by 0.9999... roundoff.
Effective limit in some cases is given implicity by chop value.  Chop value \
is chosen coarser than usual default 10^-10 to avoid occasionally failing to \
recognize terminating decimal.

Algorithm:
\tMake sure x is floating point.
\tKeep shifting x left until it is approximately an integer.
\tThe number of digits by which x had to be shifted is the number of digits \
originally to the left of the decimal point.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "FractionDigits", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FractionDigitsBase", "\[Rule]", "10"}], ",", 
     RowBox[{"Limit", "\[Rule]", "Infinity"}], ",", 
     RowBox[{"Chop", "\[Rule]", "1*^-8"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FractionDigits", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{"Opts", ",", 
           RowBox[{"Options", "[", "FractionDigits", "]"}]}], "}"}], "]"}]}], 
       ",", "\[IndentingNewLine]", "Value", ",", "NumToRight", ",", 
       "OptFractionDigitsBase", ",", "OptLimit"}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Value", "=", 
       RowBox[{"N", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"OptFractionDigitsBase", "=", 
       RowBox[{"FractionDigitsBase", "/.", "FullOpts"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"OptLimit", "=", 
       RowBox[{"Limit", "/.", "FullOpts"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"NumToRight", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"!", 
          RowBox[{"ApproxIntegerQ", "[", 
           RowBox[{"Value", ",", 
            RowBox[{"Chop", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"Chop", "/.", "FullOpts"}], ")"}]}]}], "]"}]}], "&&", 
         RowBox[{"(", 
          RowBox[{"NumToRight", "<", "OptLimit"}], ")"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Value", "*=", "OptFractionDigitsBase"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"NumToRight", "++"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "NumToRight"}]}], "\[IndentingNewLine]", "]"}]}],
   ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.42473112359375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fixed decimal notation", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FixedPointForm", "::", "leftdigits"}], "=", 
   "\"\<Insufficient left digits (`1`) specified for formatting of number \
(`2`).  Consider using automatic version FixedPointForm[x,r].\>\""}], ";", 
  RowBox[{
   RowBox[{"FixedPointForm", "::", "numbersigns"}], "=", 
   "\"\<Unsupported form of NumberSigns.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "FixedPointForm", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"NumberSigns", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<-\>\"", ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"NumberPoint", "\[Rule]", "\"\<.\>\""}], ",", 
     RowBox[{"SignPadding", "\[Rule]", "False"}], ",", 
     RowBox[{"Debug", "\[Rule]", "False"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FixedPointForm", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumberQ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"l_Integer", "?", "NonNegative"}], ",", 
       RowBox[{"r_Integer", "?", "NonNegative"}]}], "}"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{"Opts", ",", 
           RowBox[{"Options", "[", "FixedPointForm", "]"}]}], "}"}], "]"}]}], 
       ",", "\[IndentingNewLine]", "sx", ",", "mx", ",", "SignString", ",", 
       "LeftDigits", ",", "RightDigits", ",", "SeparatorString", ",", 
       "SignChars", ",", "PaddingChars", ",", "\[IndentingNewLine]", 
       "NaturalLeftDigits", ",", "\[IndentingNewLine]", "PartialSigns", ",", 
       "FullSigns", ",", "\[IndentingNewLine]", "AutoOpts"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sx", "=", 
       RowBox[{"Sign", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mx", "=", 
       RowBox[{"Abs", "[", 
        RowBox[{"N", "[", "x", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"LeftDigits", "=", 
         RowBox[{"IntegerDigits", "[", 
          RowBox[{"IntegerPart", "[", "mx", "]"}], "]"}]}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"RightDigits", "=", 
         RowBox[{"First", "[", 
          RowBox[{"RealDigits", "[", 
           RowBox[{"mx", ",", "10", ",", "r", ",", 
            RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"RightDigits", "=", 
         RowBox[{"First", "[", 
          RowBox[{"RealDigits", "[", 
           RowBox[{
            RowBox[{"FractionalPart", "[", "mx", "]"}], ",", "10", ",", "r", 
            ",", 
            RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"RightDigits", "=", 
         RowBox[{"IntegerDigits", "[", 
          RowBox[{
           RowBox[{"Round", "[", 
            RowBox[{
             RowBox[{"FractionalPart", "[", "mx", "]"}], "*", 
             RowBox[{"10", "^", "r"}]}], "]"}], ",", "10", ",", "r"}], 
          "]"}]}], ";"}], "*)"}], " ", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"round", " ", "rather", " ", "than", " ", "truncate"}], ",", 
        " ", 
        RowBox[{"to", " ", "avoid"}], ",", " ", 
        RowBox[{"e", ".", "g", "."}], ",", " ", 
        RowBox[{"2.3999999999", " ", "formatting", " ", "as", " ", "2.3"}]}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LeftDigits", "=", 
       RowBox[{"IntegerDigits", "[", 
        RowBox[{"IntegerPart", "[", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{"mx", "*", 
            RowBox[{"10", "^", "r"}]}], "]"}], "/", 
          RowBox[{"10", "^", "r"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"RightDigits", "=", 
       RowBox[{"IntegerDigits", "[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{"mx", "*", 
           RowBox[{"10", "^", "r"}]}], "]"}], ",", "10", ",", "r"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Debug", "/.", "FullOpts"}], ")"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "l", ",", "r"}], "}"}], ",", "\"\<: \>\"", ",", 
          RowBox[{"{", 
           RowBox[{"sx", ",", "mx", ",", "LeftDigits", ",", "RightDigits"}], 
           "}"}]}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SeparatorString", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"r", "\[Equal]", "0"}], ",", "\"\<\>\"", ",", 
         RowBox[{"(", 
          RowBox[{"NumberPoint", "/.", "FullOpts"}], ")"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"NaturalLeftDigits", "=", 
       RowBox[{"Length", "[", "LeftDigits", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"l", "<", "NaturalLeftDigits"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"FixedPointForm", "::", "leftdigits"}], ",", "l", ",", 
          "x"}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"FullSigns", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"NumberSigns", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", "Automatic", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "\"\<-\>\"", "}"}], ",", 
           RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"_String", ",", "_String"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"PartialSigns", "=", 
           RowBox[{"Characters", "/@", 
            RowBox[{"(", 
             RowBox[{"NumberSigns", "/.", "FullOpts"}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"PadLeft", "[", 
             RowBox[{"#", ",", 
              RowBox[{"Max", "[", 
               RowBox[{"Length", "/@", "PartialSigns"}], "]"}], ",", 
              "\"\< \>\""}], "]"}], "&"}], "/@", "PartialSigns"}]}], ",", 
         "\[IndentingNewLine]", "_", ",", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{"FixedPointForm", "::", "numbersigns"}], "]"}], ";", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", "\"\<-\>\"", "}"}], ",", 
            RowBox[{"{", "\"\< \>\"", "}"}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"SignChars", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{"sx", ",", "\[IndentingNewLine]", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"First", "[", "FullSigns", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"+", "1"}], "|", "0"}], ",", 
         RowBox[{"Last", "[", "FullSigns", "]"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"PaddingChars", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SignPadding", "/.", "FullOpts"}], ",", 
         "\[IndentingNewLine]", "False", ",", 
         RowBox[{"PadLeft", "[", 
          RowBox[{"SignChars", ",", 
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"l", "+", 
              RowBox[{"Length", "[", "SignChars", "]"}], "-", 
              "NaturalLeftDigits"}], ",", 
             RowBox[{"Length", "[", "SignChars", "]"}]}], "]"}], ",", 
           "\"\< \>\""}], "]"}], ",", "\[IndentingNewLine]", "True", ",", 
         RowBox[{"PadRight", "[", 
          RowBox[{"SignChars", ",", 
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"l", "+", 
              RowBox[{"Length", "[", "SignChars", "]"}], "-", 
              "NaturalLeftDigits"}], ",", 
             RowBox[{"Length", "[", "SignChars", "]"}]}], "]"}], ",", 
           "\"\< \>\""}], "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"StringJoin", "@@", 
       RowBox[{"Join", "[", 
        RowBox[{"PaddingChars", ",", 
         RowBox[{"ToString", "/@", "LeftDigits"}], ",", 
         RowBox[{"{", "SeparatorString", "}"}], ",", 
         RowBox[{"ToString", "/@", "RightDigits"}]}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FixedPointForm", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumberQ"}], ",", 
     RowBox[{"RightDigits_Integer", "?", "NonNegative"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"FixedPointForm", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"IntegerDigits", "[", 
         RowBox[{"IntegerPart", "[", 
          RowBox[{"N", "[", "x", "]"}], "]"}], "]"}], "]"}], ",", 
       "RightDigits"}], "}"}], ",", "Opts"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FixedPointForm", "[", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"Except", "[", 
       RowBox[{"_", "?", "NumberQ"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"l_Integer", "?", "NonNegative"}], ",", 
        RowBox[{"r_Integer", "?", "NonNegative"}]}], "}"}], "|", 
      RowBox[{"(", 
       RowBox[{"RightDigits_Integer", "?", "NonNegative"}], ")"}]}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", "x"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.424723602921875*^9, 3.42472364084375*^9, {3.42585518784375*^9, 
   3.4258552558125*^9}, {3.425856216*^9, 3.4258562830625*^9}, {
   3.4318135119375*^9, 3.431813572546875*^9}, {3.431813609640625*^9, 
   3.431813631578125*^9}, {3.4318137043125*^9, 3.4318137076875*^9}, {
   3.431814380234375*^9, 3.4318144036875*^9}, {3.43181465909375*^9, 
   3.431814659953125*^9}, {3.431814700625*^9, 3.431814701046875*^9}, {
   3.431814748*^9, 3.431814769765625*^9}, {3.431815441625*^9, 
   3.43181546734375*^9}, {3.431818571328125*^9, 3.4318185899375*^9}, {
   3.4318186254375*^9, 3.431818670046875*^9}, {3.4318187115*^9, 
   3.431818713125*^9}, {3.43181874584375*^9, 3.431818777765625*^9}, {
   3.4318188129375*^9, 3.431818813421875*^9}, {3.54049550584375*^9, 
   3.54049554096875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Label formatting function", "Subsection"],

Cell["\<\
Always pad to left by largest abs coord.
Choose decimal digits:
\tIf Automatic, use max needed for specified major ticks 
\tIf specified, use value specified
Right padding:
\tIf decimal digits 0,  truncate to integer
\tIf not, pad to right by decimal digits specified. 
Allow in all calculations for empty major coordinate list.
For positive ticks, space for sign is suppressed in padding.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FixedTickFunction", "[", 
    RowBox[{"ValueList_List", ",", "DecimalDigits_"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"LeftDigits", ",", "RightDigits", ",", "x"}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"LeftDigits", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ValueList", "===", 
          RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", "0", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Length", "[", 
          RowBox[{"IntegerDigits", "[", 
           RowBox[{"IntegerPart", "[", 
            RowBox[{"Max", "[", 
             RowBox[{"Abs", "[", "ValueList", "]"}], "]"}], "]"}], "]"}], 
          "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"RightDigits", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"DecimalDigits", "===", "Automatic"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ValueList", "===", 
            RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", "0", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Max", "[", 
            RowBox[{"FractionDigits", "/@", "ValueList"}], "]"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         "DecimalDigits"}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"With", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ld", "=", "LeftDigits"}], ",", 
          RowBox[{"rd", "=", "RightDigits"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Function", "[", 
         RowBox[{"x", ",", 
          RowBox[{"FixedPointForm", "[", 
           RowBox[{"x", ",", 
            RowBox[{"{", 
             RowBox[{"ld", ",", "rd"}], "}"}], ",", 
            RowBox[{"NumberSigns", "\[Rule]", "Automatic"}]}], "]"}]}], 
         "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.541622463765625*^9, 3.5416225100625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CustomTicks`Private`FixedTickFunction", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4.23"}], "}"}], ",", 
   "Automatic"}], "]"}]], "Input",
 CellChangeTimes->{{3.541622330703125*^9, 3.541622349234375*^9}, {
  3.54162239403125*^9, 3.541622417953125*^9}, {3.54162245678125*^9, 
  3.541622457140625*^9}, {3.541622521796875*^9, 3.541622534859375*^9}}],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"CustomTicks`Private`x$", ",", 
   RowBox[{"FixedPointForm", "[", 
    RowBox[{"CustomTicks`Private`x$", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"NumberSigns", "\[Rule]", "Automatic"}]}], "]"}]}], 
  "]"}]], "Output",
 CellChangeTimes->{
  3.5416223510625*^9, {3.54162241490625*^9, 3.541622418375*^9}, {
   3.541622457484375*^9, 3.5416224778125*^9}, {3.5416225135*^9, 
   3.5416225351875*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tick length utility", "Section",
 CellChangeTimes->{{3.526420212*^9, 3.526420214640625*^9}}],

Cell[TextData[{
 "\nTick lengths\n\t",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.1 default lengths are 0.00625 and 0.00375\n\tMCTicks default lengths \
were 0.00750 and 0.00375\n\tCustomTicks v1.0 default lengths are 0.010 and \
0.005 "
}], "Text",
 CellChangeTimes->{3.526420251984375*^9}],

Cell[CellGroupData[{

Cell["\<\
Derive tick {in,out} length from given options\
\>", "Subsection",
 CellChangeTimes->{{3.526420223828125*^9, 3.526420232203125*^9}}],

Cell["\<\
given tick length option may be either a single number or an {in,out} pair\
\>", "Text",
 CellChangeTimes->{{3.52642027084375*^9, 3.526420286265625*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ResolveTickLength", "[", 
    RowBox[{
     RowBox[{"d_", "?", "NumericQ"}], ",", 
     RowBox[{"TickLengthScale_", "?", "NumericQ"}], ",", 
     RowBox[{"TickDirection", ":", 
      RowBox[{"(", 
       RowBox[{"In", "|", "Out", "|", "All"}], ")"}]}], ",", 
     RowBox[{"TickReverse", ":", 
      RowBox[{"(", 
       RowBox[{"True", "|", "False"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "LengthPair", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"upgrade", " ", "single", " ", "length", " ", "to", " ", 
       RowBox[{"{", 
        RowBox[{"in", ",", "out"}], "}"}], " ", "pair"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"LengthPair", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"TickDirection", ",", "\[IndentingNewLine]", "In", ",", 
         RowBox[{"{", 
          RowBox[{"d", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", "Out", 
         ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "d"}], "}"}], ",", "\[IndentingNewLine]", "All", 
         ",", 
         RowBox[{"{", 
          RowBox[{"d", ",", "d"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "implement", " ", "legacy", " ", "direction", " ", "reversing", " ", 
        "option"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LengthPair", "=", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"TickReverse", ",", "Reverse", ",", "Identity"}], "]"}], "@",
         "LengthPair"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      
      RowBox[{"(*", " ", 
       RowBox[{"scale", " ", "length"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"TickLengthScale", "*", "LengthPair"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.526419774515625*^9, 3.526420039453125*^9}, {
  3.526420070609375*^9, 3.52642007815625*^9}, {3.526420303609375*^9, 
  3.526420304578125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ResolveTickLength", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d1_", "?", "NumericQ"}], ",", 
       RowBox[{"d2_", "?", "NumericQ"}]}], "}"}], ",", 
     RowBox[{"TickLengthScale_", "?", "NumericQ"}], ",", 
     RowBox[{"TickDirection", ":", 
      RowBox[{"(", 
       RowBox[{"In", "|", "Out", "|", "All"}], ")"}]}], ",", 
     RowBox[{"TickReverse", ":", 
      RowBox[{"(", 
       RowBox[{"True", "|", "False"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "LengthPair", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"ignore", " ", "TickDirection", " ", "if", " ", "given", " ", 
       RowBox[{"{", 
        RowBox[{"in", ",", "out"}], "}"}], " ", "pair"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"LengthPair", "=", 
       RowBox[{"{", 
        RowBox[{"d1", ",", "d2"}], "}"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "implement", " ", "legacy", " ", "direction", " ", "reversing", " ", 
        "option"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LengthPair", "=", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"TickReverse", ",", "Reverse", ",", "Identity"}], "]"}], "@",
         "LengthPair"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      
      RowBox[{"(*", " ", 
       RowBox[{"scale", " ", "length"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"TickLengthScale", "*", "LengthPair"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.526419774515625*^9, 3.526420039453125*^9}, {
   3.526420070609375*^9, 3.526420103765625*^9}, {3.52642013521875*^9, 
   3.5264201461875*^9}, {3.526420176484375*^9, 3.526420188734375*^9}, 
   3.526420307484375*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear ticks", "Section"],

Cell["\<\
Option MinorTickIndexRange is only respected by the iterating form of \
LinTicks.\
\>", "Text",
 CellChangeTimes->{{3.526420242703125*^9, 3.526420243453125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "LinTicks", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ExtraTicks", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"TickPreTransformation", "\[Rule]", "Identity"}], ",", 
     RowBox[{"TickPostTransformation", "\[Rule]", "Identity"}], ",", 
     RowBox[{"ShowFirst", "\[Rule]", "True"}], ",", 
     RowBox[{"ShowLast", "\[Rule]", "True"}], ",", 
     RowBox[{"ShowTickLabels", "\[Rule]", "True"}], ",", 
     RowBox[{"ShowMinorTicks", "\[Rule]", "True"}], ",", 
     RowBox[{"TickLabelStart", "\[Rule]", "0"}], ",", 
     RowBox[{"TickLabelStep", "\[Rule]", "1"}], ",", 
     RowBox[{"TickRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], ",", 
     RowBox[{"TickLabelRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], ",", 
     RowBox[{"TickLabelFunction", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"DecimalDigits", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"MajorTickLength", "\[Rule]", "0.010"}], ",", 
     RowBox[{"MinorTickLength", "\[Rule]", "0.005"}], ",", 
     RowBox[{"TickLengthScale", "\[Rule]", "1"}], ",", 
     RowBox[{"TickDirection", "\[Rule]", "In"}], ",", 
     RowBox[{"TickReverse", "\[Rule]", "False"}], ",", 
     RowBox[{"MajorTickStyle", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"MinorTickStyle", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"MinorTickIndexRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "Infinity"}], "}"}]}], ",", 
     RowBox[{"MinorTickIndexTransformation", "\[Rule]", "Identity"}], ",", 
     RowBox[{"TickTest", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"True", "&"}], ")"}]}], ",", 
     RowBox[{"TickLabelTest", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"True", "&"}], ")"}]}], ",", 
     RowBox[{"Debug", "\[Rule]", "False"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.447272246375*^9, 3.4472722608125*^9}, {
  3.456517337375*^9, 3.456517388421875*^9}, {3.463957849374536*^9, 
  3.463957853937036*^9}, {3.4657254158125*^9, 3.46572541940625*^9}, {
  3.5264205405*^9, 3.526420563734375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinTicks", "[", 
    RowBox[{
    "RawMajorCoordList_List", ",", "RawMinorCoordList_List", ",", "Opts___"}],
     "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", " ", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{"Opts", ",", 
           RowBox[{"Options", "[", "LinTicks", "]"}]}], "}"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "MajorCoordList", ",", "\[IndentingNewLine]", 
       "LabeledCoordList", ",", "\[IndentingNewLine]", "MinorCoordList", ",", 
       "\[IndentingNewLine]", "MajorTickList", ",", "\[IndentingNewLine]", 
       "MinorTickList", ",", "\[IndentingNewLine]", "UsedTickLabelFunction", 
       ",", "\[IndentingNewLine]", "DefaultTickLabelFunction", ",", 
       "\[IndentingNewLine]", "TickValue", ",", "\[IndentingNewLine]", 
       "TickPosition", ",", "\[IndentingNewLine]", "TickLabel", ",", 
       "\[IndentingNewLine]", "TickLength", ",", "\[IndentingNewLine]", 
       "TickStyle", ",", "\[IndentingNewLine]", "i"}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"make", " ", "major", " ", "ticks"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MajorCoordList", "=", 
       RowBox[{"Select", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"TickPreTransformation", "/.", "FullOpts"}], ")"}], "/@", 
          RowBox[{"Union", "[", 
           RowBox[{"RawMajorCoordList", ",", 
            RowBox[{"ExtraTicks", "/.", "FullOpts"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ApproxInRange", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"TickRange", "/.", "FullOpts"}], ")"}], ",", "#"}], 
             "]"}], "&&", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"TickTest", "/.", "FullOpts"}], ")"}], "[", "#", 
             "]"}]}], ")"}], "&"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"LabeledCoordList", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"TickValue", "=", 
            RowBox[{"MajorCoordList", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"ShowTickLabels", "/.", "FullOpts"}], ")"}], 
              "\[IndentingNewLine]", "&&", 
              RowBox[{"ApproxInRange", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"TickLabelRange", "/.", "FullOpts"}], ")"}], ",", 
                "TickValue"}], "]"}], "\[IndentingNewLine]", "&&", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Mod", "[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"(", 
                   RowBox[{"TickLabelStep", "/.", "FullOpts"}], ")"}]}], 
                 "]"}], "\[Equal]", 
                RowBox[{"(", 
                 RowBox[{"TickLabelStart", "/.", "FullOpts"}], ")"}]}], ")"}],
               "\[IndentingNewLine]", "&&", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"i", "\[NotEqual]", "1"}], ")"}], "||", 
                RowBox[{"(", 
                 RowBox[{"ShowFirst", "/.", "FullOpts"}], ")"}]}], ")"}], 
              "\[IndentingNewLine]", "&&", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"i", "\[NotEqual]", 
                  RowBox[{"Length", "[", "MajorCoordList", "]"}]}], ")"}], "||", 
                RowBox[{"(", 
                 RowBox[{"ShowLast", "/.", "FullOpts"}], ")"}]}], ")"}], 
              "\[IndentingNewLine]", "&&", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"TickLabelTest", "/.", "FullOpts"}], ")"}], "[", 
               "TickValue", "]"}]}], ",", "\[IndentingNewLine]", "TickValue", 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "MajorCoordList", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DefaultTickLabelFunction", "=", 
       RowBox[{"FixedTickFunction", "[", 
        RowBox[{"LabeledCoordList", ",", 
         RowBox[{"DecimalDigits", "/.", "FullOpts"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"UsedTickLabelFunction", "=", 
       RowBox[{"Switch", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"TickLabelFunction", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", "Automatic", ",", 
         RowBox[{"(", 
          RowBox[{"#2", "&"}], ")"}], ",", "\[IndentingNewLine]", "_", ",", 
         RowBox[{"(", 
          RowBox[{"TickLabelFunction", "/.", "FullOpts"}], ")"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TickLength", "=", 
       RowBox[{"ResolveTickLength", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MajorTickLength", "/.", "FullOpts"}], ")"}], ",", 
         RowBox[{"(", 
          RowBox[{"TickLengthScale", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(", 
          RowBox[{"TickDirection", "/.", "FullOpts"}], ")"}], ",", 
         RowBox[{"(", 
          RowBox[{"TickReverse", "/.", "FullOpts"}], ")"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TickStyle", "=", 
       RowBox[{"(", 
        RowBox[{"MajorTickStyle", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"MajorTickList", "=", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"calculate", " ", "tick", " ", "value"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"TickValue", "=", 
           RowBox[{"MajorCoordList", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "calculate", " ", "coordinate", " ", "for", " ", "drawing", " ", 
            "tick"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"TickPosition", "=", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"TickPostTransformation", "/.", "FullOpts"}], ")"}], "[",
             "TickValue", "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"construct", " ", "label"}], ",", " ", 
            RowBox[{
            "or", " ", "null", " ", "string", " ", "if", " ", "it", " ", 
             "should", " ", "be", " ", 
             RowBox[{"suppressed", " ", "--"}], " ", 
             RowBox[{"if", ":", " ", 
              RowBox[{"major", " ", "tick"}]}]}], ",", " ", 
            RowBox[{
            "in", " ", "designated", " ", "modular", " ", "cycle", " ", "if", 
             " ", "only", " ", "a", " ", "cycle", " ", "of", " ", "major", 
             " ", "ticks", " ", "are", " ", "to", " ", "be", " ", "labeled"}],
             ",", " ", 
            RowBox[{"tick", " ", "is", " ", "in", " ", "TickLabelRange"}], 
            ",", " ", 
            RowBox[{
             RowBox[{
             "and", " ", "not", " ", "explicitly", " ", "suppressed", " ", 
              "as", " ", "first", " ", "or", " ", "last", " ", "label"}], ";",
              " ", 
             RowBox[{
             "will", " ", "only", " ", "then", " ", "be", " ", "used", " ", 
              "if", " ", "tick", " ", "is", " ", "also", " ", "in", " ", 
              "TickRange"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"TickLabel", "=", 
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"ShowTickLabels", "/.", "FullOpts"}], ")"}], 
              "\[IndentingNewLine]", "&&", 
              RowBox[{"ApproxInRange", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"TickLabelRange", "/.", "FullOpts"}], ")"}], ",", 
                "TickValue"}], "]"}], "\[IndentingNewLine]", "&&", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Mod", "[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"(", 
                   RowBox[{"TickLabelStep", "/.", "FullOpts"}], ")"}]}], 
                 "]"}], "\[Equal]", 
                RowBox[{"(", 
                 RowBox[{"TickLabelStart", "/.", "FullOpts"}], ")"}]}], ")"}],
               "\[IndentingNewLine]", "&&", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"i", "\[NotEqual]", "1"}], ")"}], "||", 
                RowBox[{"(", 
                 RowBox[{"ShowFirst", "/.", "FullOpts"}], ")"}]}], ")"}], 
              "\[IndentingNewLine]", "&&", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"i", "\[NotEqual]", 
                  RowBox[{"Length", "[", "MajorCoordList", "]"}]}], ")"}], "||", 
                RowBox[{"(", 
                 RowBox[{"ShowLast", "/.", "FullOpts"}], ")"}]}], ")"}]}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"UsedTickLabelFunction", "[", 
              RowBox[{"TickValue", ",", 
               RowBox[{"DefaultTickLabelFunction", "[", "TickValue", "]"}]}], 
              "]"}], ",", "\[IndentingNewLine]", "\"\<\>\""}], 
            "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"make", " ", "tick"}], " ", "*)"}], "\[IndentingNewLine]", 
          
          RowBox[{"{", 
           RowBox[{
           "TickPosition", ",", "TickLabel", ",", "TickLength", ",", 
            "TickStyle"}], "}"}]}], ",", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MajorCoordList", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"make", " ", "minor", " ", "ticks"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"MinorCoordList", "=", 
       RowBox[{"Select", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"TickPreTransformation", "/.", "FullOpts"}], ")"}], "/@", 
          "RawMinorCoordList"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ApproxInRange", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"TickRange", "/.", "FullOpts"}], ")"}], ",", "#"}], 
             "]"}], "&&", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"TickTest", "/.", "FullOpts"}], ")"}], "[", "#", 
             "]"}]}], ")"}], "&"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TickLength", "=", 
       RowBox[{"ResolveTickLength", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MinorTickLength", "/.", "FullOpts"}], ")"}], ",", 
         RowBox[{"(", 
          RowBox[{"TickLengthScale", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(", 
          RowBox[{"TickDirection", "/.", "FullOpts"}], ")"}], ",", 
         RowBox[{"(", 
          RowBox[{"TickReverse", "/.", "FullOpts"}], ")"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TickStyle", "=", 
       RowBox[{"(", 
        RowBox[{"MinorTickStyle", "/.", "FullOpts"}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"MinorTickList", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ShowMinorTicks", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"calculate", " ", "tick", " ", "value"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"TickValue", "=", 
             RowBox[{"MinorCoordList", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "calculate", " ", "coordinate", " ", "for", " ", "drawing", " ", 
              "tick"}], " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"TickPosition", "=", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"TickPostTransformation", "/.", "FullOpts"}], ")"}], 
              "[", "TickValue", "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"make", " ", "tick"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
             "TickPosition", ",", "\"\<\>\"", ",", "TickLength", ",", 
              "TickStyle"}], "}"}]}], ",", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", 
             RowBox[{"Length", "[", "MinorCoordList", "]"}]}], "}"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"combine", " ", "tick", " ", "lists"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Debug", "/.", "FullOpts"}], ")"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", "RawMajorCoordList", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", "RawMinorCoordList", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"Join", "[", 
           RowBox[{"MajorTickList", ",", "MinorTickList"}], "]"}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{"MajorTickList", ",", "MinorTickList"}], "]"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.447272294375*^9, 3.44727232971875*^9}, {
  3.44727256815625*^9, 3.447272569484375*^9}, {3.44727263271875*^9, 
  3.44727268171875*^9}, {3.4565173984375*^9, 3.45651747484375*^9}, {
  3.456517513953125*^9, 3.4565175180625*^9}, {3.463957877280786*^9, 
  3.463957888468286*^9}, {3.4639579526401615`*^9, 3.4639579557339115`*^9}, {
  3.465725450609375*^9, 3.46572551059375*^9}, {3.526420313140625*^9, 
  3.52642037603125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinTicks", "[", 
   RowBox[{
    RowBox[{"x1_", "?", "NumericQ"}], ",", 
    RowBox[{"x2_", "?", "NumericQ"}], ",", 
    RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "UsedRange", ",", "DummyGraphics", ",", "TickList", ",", 
      "MajorCoordList", ",", "MinorCoordList", ",", "x"}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"extend", " ", "any", " ", "round"}], "-", 
      RowBox[{
      "number", " ", "range", " ", "by", " ", "a", " ", "tiny", " ", 
       "amount"}]}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
      "this", " ", "seems", " ", "to", " ", "make", " ", "Mathematica", " ", 
       "4.1", " ", "give", " ", "a", " ", "much", " ", "cleaner"}], ",", " ", 
      
      RowBox[{"sparser", " ", "set", " ", "of", " ", "ticks"}]}], " ", "*)"}],
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"UsedRange", "=", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"And", "@@", 
         RowBox[{"ApproxIntegerQ", "/@", 
          RowBox[{"{", 
           RowBox[{"x1", ",", "x2"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ExtendRange", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "x2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1*^-5", ",", "1*^-5"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"x1", ",", "x2"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "extract", " ", "raw", " ", "tick", " ", "coordinates", " ", "from", 
       " ", "Mathematica"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"{", "}"}], "]"}], " ", "primative", " ", "since", " ", 
       "Mathematica", " ", "6", " ", "requires", " ", "nonnull", " ", 
       "primative", " ", "list", " ", "in", " ", "Graphics", " ", "for", " ", 
       "suitable", " ", "ticks", " ", "to", " ", "be", " ", 
       RowBox[{"produced", " ", "--"}], " ", "reported", " ", "by", " ", 
       RowBox[{"J", ".", " ", "Grosse"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"DummyGraphics", "=", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Line", "[", 
           RowBox[{"{", "}"}], "]"}], "}"}], "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"UsedRange", ",", "Automatic"}], "}"}]}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TickList", "=", 
      RowBox[{"First", "[", 
       RowBox[{"Ticks", "/.", 
        RowBox[{"AbsoluteOptions", "[", 
         RowBox[{"DummyGraphics", ",", "Ticks"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MajorCoordList", "=", 
      RowBox[{"Cases", "[", 
       RowBox[{"TickList", ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x_", ",", "_Real", ",", "___"}], "}"}], "\[RuleDelayed]", 
         "x"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"MinorCoordList", "=", 
      RowBox[{"Cases", "[", 
       RowBox[{"TickList", ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x_", ",", "\"\<\>\"", ",", "___"}], "}"}], 
         "\[RuleDelayed]", "x"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "generate", " ", "formatted", " ", "tick", " ", "mark", " ", 
       "specifications"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LinTicks", "[", 
      RowBox[{"MajorCoordList", ",", "MinorCoordList", ",", "Opts"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinTicks", "[", 
    RowBox[{
     RowBox[{"x1_", "?", "NumericQ"}], ",", 
     RowBox[{"x2_", "?", "NumericQ"}], ",", 
     RowBox[{"Spacing_", "?", "NumericQ"}], ",", 
     RowBox[{"MinorSubdivs", ":", "_Integer"}], ",", "Opts___"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", " ", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{"Opts", ",", 
           RowBox[{"Options", "[", "LinTicks", "]"}]}], "}"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "MaxMajorIndex", ",", "\[IndentingNewLine]", 
       "MajorCoordList", ",", "MinorCoordList"}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"preliminary", " ", "calculations"}], "  ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxMajorIndex", "=", 
       RowBox[{"Round", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x2", "-", "x1"}], ")"}], "/", "Spacing"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"construct", " ", "table", " ", "of", " ", 
          RowBox[{"ticks", " ", "--"}], "indexed", " ", "by", " ", 
          "MajorIndex"}], "=", "0"}], ",", "1", ",", "...", ",", 
        RowBox[{
         RowBox[{"MaxMajorTick", " ", "and", " ", "MinorIndex"}], "=", "0"}], 
        ",", "...", ",", 
        RowBox[{"MinorSubdivs", "-", "1"}], ",", " ", 
        RowBox[{
         RowBox[{"where", " ", "MinorIndex"}], "=", 
         RowBox[{"0", " ", "gives", " ", "the", " ", "major", " ", "tick"}]}],
         ",", " ", "\[IndentingNewLine]", 
        RowBox[{
        "except", " ", "no", " ", "minor", " ", "ticks", " ", "after", " ", 
         "last", " ", "major", " ", "tick"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"MajorCoordList", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"x1", "+", 
            RowBox[{"MajorIndex", "*", "Spacing"}], "+", 
            RowBox[{"MinorIndex", "*", 
             RowBox[{"Spacing", "/", "MinorSubdivs"}]}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"MajorIndex", ",", "0", ",", "MaxMajorIndex"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"MinorIndex", ",", "0", ",", "0"}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"MinorCoordList", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"InRange", "[", 
             RowBox[{
              RowBox[{"MinorTickIndexRange", "/.", "FullOpts"}], ",", 
              "MinorIndex"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"N", "[", 
             RowBox[{"x1", "+", 
              RowBox[{"MajorIndex", "*", "Spacing"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"MinorTickIndexTransformation", "/.", "FullOpts"}], 
                  ")"}], "@", "MinorIndex"}], ")"}], "*", 
               RowBox[{"Spacing", "/", "MinorSubdivs"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"MajorIndex", ",", "0", ",", "MaxMajorIndex"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"MinorIndex", ",", "1", ",", 
            RowBox[{"MinorSubdivs", "-", "1"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "there", " ", "are", " ", "usually", " ", "ticks", " ", "to", " ", 
         "be", " ", "suppressed", " ", "at", " ", "the", " ", "upper", " ", 
         "end"}], ",", " ", 
        RowBox[{
        "since", " ", "the", " ", "major", " ", "tick", " ", "index", " ", 
         "rounds", " ", "up", " ", "to", " ", "the", " ", "next", " ", 
         "major", " ", "tick", " ", 
         RowBox[{"(", 
          RowBox[{
          "for", " ", "safety", " ", "in", " ", "borderline", " ", "cases", 
           " ", "where", " ", "truncation", " ", "might", " ", "fail"}], 
          ")"}]}], ",", " ", 
        RowBox[{
        "and", " ", "the", " ", "loop", " ", "minor", " ", "tick", " ", 
         "index", " ", "iterates", " ", "for", " ", "a", " ", "full", " ", 
         "series", " ", "of", " ", "minor", " ", "ticks", " ", "even", " ", 
         "after", " ", "the", " ", "last", " ", "major", " ", "tick"}]}], " ",
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"MajorCoordList", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"MajorCoordList", ",", 
         RowBox[{
          RowBox[{"ApproxInRange", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1", ",", "x2"}], "}"}], ",", "#"}], "]"}], "&"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"MinorCoordList", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"MinorCoordList", ",", 
         RowBox[{
          RowBox[{"ApproxInRange", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1", ",", "x2"}], "}"}], ",", "#"}], "]"}], "&"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"LinTicks", "[", 
       RowBox[{"MajorCoordList", ",", "MinorCoordList", ",", "Opts"}], 
       "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Log ticks", "Section"],

Cell["\<\
Minor tick calculation
\ts is number of subdivisions given by user
\ts' is number of subdivisions given to LinTicks (cancels out from \
calculations, but serves as internal iteration max+1 for k)
\tk is untransformed index (k = 1,...,s-1)
\ti is transformed index
\tp is preceding major tick's power
\tx is plot coordinate (so b^x is true exponentiated coordinate)
\t
\ti = Log[b,k+1]*s'
\tb^x = b^(p+i/s') = b^(i/s')*b^p = b^(Log[b,k+1]*s'/s')*b^p = (k+1)*b^p
\t
\tTherefore, any value of (k+1) from 2 to strictly less than b makes sense.
\tWe thus bound k+1 by \[LeftCeiling]b\[RightCeiling]-1, so this is the bound \
on s.  We arbitrarily choose s'=s, saving the need for an explicit \
MinorTickIndexRange.
\t
\tGeneral numeric values are allowed for the lower and upper exponents, to \
support arbitrary argments which arise when used as automatic tick function \
in Ticks or FrameTicks option.\
\>", "Text",
 CellChangeTimes->{{3.424726999953125*^9, 3.424727064734375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "LogTicks", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ExtraTicks", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"TickPreTransformation", "\[Rule]", "Identity"}], ",", 
     RowBox[{"TickPostTransformation", "\[Rule]", "Identity"}], ",", 
     RowBox[{"ShowFirst", "\[Rule]", "True"}], ",", 
     RowBox[{"ShowLast", "\[Rule]", "True"}], ",", 
     RowBox[{"ShowTickLabels", "\[Rule]", "True"}], ",", 
     RowBox[{"ShowMinorTicks", "\[Rule]", "True"}], ",", 
     RowBox[{"TickLabelStart", "\[Rule]", "0"}], ",", 
     RowBox[{"TickLabelStep", "\[Rule]", "1"}], ",", 
     RowBox[{"TickRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], ",", 
     RowBox[{"TickLabelRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], ",", 
     RowBox[{"DecimalDigits", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"MajorTickLength", "\[Rule]", "0.010"}], ",", 
     RowBox[{"MinorTickLength", "\[Rule]", "0.005"}], ",", 
     RowBox[{"TickLengthScale", "\[Rule]", "1"}], ",", 
     RowBox[{"TickDirection", "\[Rule]", "In"}], ",", 
     RowBox[{"TickReverse", "\[Rule]", "False"}], ",", 
     RowBox[{"MajorTickStyle", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"MinorTickStyle", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"MinorTickIndexRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "Infinity"}], "}"}]}], ",", 
     RowBox[{"LogPlot", "\[Rule]", "False"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.424728375796875*^9, 3.424728388046875*^9}, 
   3.424728593453125*^9, 3.4247286318125*^9, {3.424728699734375*^9, 
   3.4247287038125*^9}, {3.42472873859375*^9, 3.4247287560625*^9}, {
   3.4639579669526615`*^9, 3.463957970749536*^9}, {3.465725517765625*^9, 
   3.465725530125*^9}, {3.5161324951875*^9, 3.516132498234375*^9}, 
   3.52642058303125*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LogTicks", "::", "oldsyntax"}], "=", 
   "\"\<The number of minor subdivisions no longer needs to be specified for \
LogTicks (see CustomTicks manual for new syntax).\>\""}], ";", 
  RowBox[{
   RowBox[{"LogTicks", "::", "minorsubdivs"}], "=", 
   "\"\<Number of minor subdivisions `1` specified for LogTicks is not 1 or \
\[LeftCeiling]base\[RightCeiling]-1 (i.e., \
\[LeftCeiling]base\[RightCeiling]-2 tick marks) and so is being \
ignored.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LogTicks", "[", 
    RowBox[{
     RowBox[{"Base", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "NumericQ"}], ")"}], ":", "10"}]}], ",", 
     RowBox[{"p1Raw_", "?", "NumericQ"}], ",", 
     RowBox[{"p2Raw_", "?", "NumericQ"}], ",", 
     RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullOpts", "=", " ", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{"Opts", ",", 
           RowBox[{"Options", "[", "LogTicks", "]"}]}], "}"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "p1", ",", "p2", ",", "BaseSymbol", ",", 
       "MinorSubdivs", ",", "\[IndentingNewLine]", "UsedArgumentTransform", 
       ",", "UsedPostTransformation"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"for", " ", "use", " ", "with", " ", 
        RowBox[{"LogPlot", ":", " ", 
         RowBox[{
         "scale", " ", "input", " ", "arguments", " ", "from", " ", "true", 
          " ", "values", " ", "down", " ", "to", " ", "log"}]}]}], ",", " ", 
       RowBox[{
       "and", " ", "scale", " ", "coordinate", " ", "back", " ", "up", " ", 
        "from", " ", "log", " ", "to", " ", "true", " ", "value"}]}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"UsedPostTransformation", " ", "=", " ", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"LogPlot", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", " ", 
         RowBox[{"Composition", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"TickPostTransformation", "/.", "FullOpts"}], ")"}], ",", 
           
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Base", "^", "#"}], "&"}], ")"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(", 
          RowBox[{"TickPostTransformation", "/.", "FullOpts"}], ")"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"UsedArgumentTransform", "=", 
       RowBox[{"If", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"LogPlot", "/.", "FullOpts"}], ")"}], ",", 
         "\[IndentingNewLine]", " ", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"Base", ",", " ", "#"}], "]"}], "&"}], ",", 
         "\[IndentingNewLine]", "Identity"}], "\[IndentingNewLine]", "]"}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"p1", "=", 
       RowBox[{"Floor", "[", 
        RowBox[{"UsedArgumentTransform", "@", "p1Raw"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p2", "=", 
       RowBox[{"Ceiling", "[", 
        RowBox[{"UsedArgumentTransform", "@", "p2Raw"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"BaseSymbol", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Base", "===", "E"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<e\>\"", ",", 
           RowBox[{"FontFamily", "->", "\"\<Italic\>\""}]}], "]"}], ",", 
         "Base"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"MinorSubdivs", "=", 
       RowBox[{
        RowBox[{"Ceiling", "[", "Base", "]"}], "-", "1"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"one", " ", "more", " ", "than", " ", "minor", " ", "ticks"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"MinorSubdivs", "=", 
       RowBox[{"Max", "[", 
        RowBox[{"MinorSubdivs", ",", "1"}], "]"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "prevent", " ", "underflow", " ", "from", " ", "bases", " ", "less", 
        " ", "than", " ", "2"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LinTicks", "[", 
       RowBox[{
       "p1", ",", "p2", ",", "1", ",", "MinorSubdivs", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"TickPostTransformation", "->", "UsedPostTransformation"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"TickLabelFunction", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"DisplayForm", "[", 
            RowBox[{"SuperscriptBox", "[", 
             RowBox[{"BaseSymbol", ",", 
              RowBox[{"IntegerPart", "[", "#", "]"}]}], "]"}], "]"}], "&"}], 
          ")"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"MinorTickIndexTransformation", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"Base", ",", 
              RowBox[{"#", "+", "1"}]}], "]"}], "*", "MinorSubdivs"}], "&"}], 
          ")"}]}], ",", "\[IndentingNewLine]", "FullOpts"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"pass", " ", "through", " ", "to", " ", "LinTicks"}], "*)"}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.42472365271875*^9, {3.424726936953125*^9, 3.424726983453125*^9}, {
   3.424727140765625*^9, 3.42472714109375*^9}, {3.42472855790625*^9, 
   3.424728566140625*^9}, {3.424728877546875*^9, 3.424728890484375*^9}, 
   3.516132563421875*^9, {3.516132676*^9, 3.516132803640625*^9}, {
   3.5161328371875*^9, 3.516132880125*^9}, {3.516132911046875*^9, 
   3.516133158671875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"syntax", " ", "traps", " ", "for", " ", "old", " ", 
    RowBox[{"syntax", " ", "--"}], " ", "but", " ", "will", " ", "not", " ", 
    "catch", " ", "usual", " ", "situation", " ", "in", " ", "which", " ", 
    "base", " ", "was", " ", "unspecified", " ", "but", " ", "subdivs", " ", 
    "was"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"LogTicks", "[", 
       RowBox[{
        RowBox[{"Base_", "?", "NumericQ"}], ",", "p1_Integer", ",", 
        "p2_Integer", ",", "MinorSubdivs_Integer", ",", 
        RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
      RowBox[{"(", 
       RowBox[{"MinorSubdivs", "\[Equal]", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Ceiling", "[", "Base", "]"}], "-", "1"}], ",", "1"}], 
         "]"}]}], ")"}]}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Message", "[", 
        RowBox[{"LogTicks", "::", "oldsyntax"}], "]"}], ";", 
       RowBox[{"LogTicks", "[", 
        RowBox[{"Base", ",", "p1", ",", "p2", ",", 
         RowBox[{"ShowMinorTicks", "\[Rule]", "True"}], ",", "Opts"}], 
        "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"LogTicks", "[", 
       RowBox[{
        RowBox[{"Base_", "?", "NumericQ"}], ",", "p1_Integer", ",", 
        "p2_Integer", ",", "MinorSubdivs_Integer", ",", 
        RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
      RowBox[{"(", 
       RowBox[{"MinorSubdivs", "==", "1"}], ")"}]}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Message", "[", 
        RowBox[{"LogTicks", "::", "oldsyntax"}], "]"}], ";", 
       RowBox[{"LogTicks", "[", 
        RowBox[{"Base", ",", "p1", ",", "p2", ",", 
         RowBox[{"ShowMinorTicks", "\[Rule]", "False"}], ",", "Opts"}], 
        "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"LogTicks", "[", 
       RowBox[{
        RowBox[{"Base_", "?", "NumericQ"}], ",", "p1_Integer", ",", 
        "p2_Integer", ",", "MinorSubdivs_Integer", ",", 
        RowBox[{"Opts___", "?", "OptionQ"}]}], "]"}], "/;", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"MinorSubdivs", "!=", 
          RowBox[{"Max", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Ceiling", "[", "Base", "]"}], "-", "1"}], ",", "1"}], 
           "]"}]}], ")"}], "&&", 
        RowBox[{"(", 
         RowBox[{"MinorSubdivs", "!=", "1"}], ")"}]}], ")"}]}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Message", "[", 
        RowBox[{"LogTicks", "::", "oldsyntax"}], "]"}], ";", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"LogTicks", "::", "minorsubdivs"}], ",", "MinorSubdivs"}], 
        "]"}], ";", 
       RowBox[{"LogTicks", "[", 
        RowBox[{"Base", ",", "p1", ",", "p2", ",", 
         RowBox[{"ShowMinorTicks", "\[Rule]", "True"}], ",", "Opts"}], 
        "]"}]}], ")"}]}], ";"}]}]}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tick augmentation", "Section"],

Cell["Plain coordinate is upgraded to coordinate in list", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AugmentTick", "[", 
    RowBox[{
    "LabelFunction_", ",", "DefaultLength_List", ",", "DefaultStyle_List", 
     ",", 
     RowBox[{"x_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{"AugmentTick", "[", 
    RowBox[{"LabelFunction", ",", "DefaultLength", ",", "DefaultStyle", ",", 
     RowBox[{"{", "x", "}"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Wrapped coordinate is given label", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AugmentTick", "[", 
    RowBox[{
    "LabelFunction_", ",", "DefaultLength_List", ",", "DefaultStyle_List", 
     ",", 
     RowBox[{"{", 
      RowBox[{"x_", "?", "NumericQ"}], "}"}]}], "]"}], ":=", 
   RowBox[{"AugmentTick", "[", 
    RowBox[{"LabelFunction", ",", "DefaultLength", ",", "DefaultStyle", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"LabelFunction", "@", "x"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["Coordinate + label is given length list", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AugmentTick", "[", 
    RowBox[{
    "LabelFunction_", ",", "DefaultLength_List", ",", "DefaultStyle_List", 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x_", "?", "NumericQ"}], ",", "LabelText_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"AugmentTick", "[", 
    RowBox[{"LabelFunction", ",", "DefaultLength", ",", "DefaultStyle", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "LabelText", ",", "DefaultLength"}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Any tick with just plength is upgraded to haveing length list\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AugmentTick", "[", 
    RowBox[{
    "LabelFunction_", ",", "DefaultLength_List", ",", "DefaultStyle_List", 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x_", "?", "NumericQ"}], ",", "LabelText_", ",", 
       RowBox[{"PLen_", "?", "NumericQ"}], ",", "RestSeq___"}], "}"}]}], 
    "]"}], ":=", 
   RowBox[{"AugmentTick", "[", 
    RowBox[{"LabelFunction", ",", "DefaultLength", ",", "DefaultStyle", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "LabelText", ",", 
       RowBox[{"{", 
        RowBox[{"PLen", ",", "0"}], "}"}], ",", "RestSeq"}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 InitializationCell->True],

Cell["Coorindate + label + length list is given style ", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AugmentTick", "[", 
    RowBox[{
    "LabelFunction_", ",", "DefaultLength_List", ",", "DefaultStyle_List", 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x_", "?", "NumericQ"}], ",", "LabelText_", ",", 
       "LengthList_List"}], "}"}]}], "]"}], ":=", 
   RowBox[{"AugmentTick", "[", 
    RowBox[{"LabelFunction", ",", "DefaultLength", ",", "DefaultStyle", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "LabelText", ",", "LengthList", ",", "DefaultStyle"}],
       "}"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Release a complete tick", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AugmentTick", "[", 
    RowBox[{
    "LabelFunction_", ",", "DefaultLength_List", ",", "DefaultStyle_List", 
     ",", 
     RowBox[{"TheTick", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x_", "?", "NumericQ"}], ",", "LabelText_", ",", 
        "LengthList_List", ",", "Style_List"}], "}"}]}]}], "]"}], ":=", 
   "TheTick"}], ";"}]], "Input",
 InitializationCell->True],

Cell["Process full list", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AugmentTicks", "[", 
    RowBox[{
    "DefaultLength_List", ",", "DefaultStyle_List", ",", "TickList_List"}], 
    "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AugmentTick", "[", 
      RowBox[{
       RowBox[{"\"\<\>\"", "&"}], ",", "DefaultLength", ",", "DefaultStyle", 
       ",", "#"}], "]"}], "&"}], "/@", "TickList"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4247236933125*^9, 3.42472369375*^9}, 
   3.42472378509375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Augment tick axis lists", "Section"],

Cell["\<\
Converts plain None to list of empty lists
Augments list of specifications to NumAxes with empty lists, replacing None \
with empty list
Does not handle plain Automatic\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AugmentAxisTickOptions", "::", "numaxes"}], "=", 
   "\"\<Tick lists specified for more than `1` axes.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AugmentAxisTickOptions", "[", 
    RowBox[{"NumAxes_Integer", ",", 
     RowBox[{"TickLists", ":", "None"}]}], "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "NumAxes", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AugmentAxisTickOptions", "[", 
    RowBox[{"NumAxes_Integer", ",", "TickLists_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NumAxes", "<", 
         RowBox[{"Length", "[", "TickLists", "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"AugmentAxisTickOptions", "::", "numaxes"}], ",", 
          "NumAxes"}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Replace", "[", 
         RowBox[{"TickLists", ",", 
          RowBox[{"{", 
           RowBox[{"None", "\[Rule]", 
            RowBox[{"{", "}"}]}], "}"}], ",", 
          RowBox[{"{", "1", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"NumAxes", "-", 
            RowBox[{"Length", "[", "TickLists", "]"}]}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.424723770078125*^9, 3.42472377059375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tick testing", "Section"],

Cell["\<\
Valid tick is coordinate or {coordinate,label,length/pair,style}, with all \
contents after first optional, where coordinate and length or the components \
of pair must be numeric and style must be a list.
Ambiguity arises in that, e.g., {1,2,3} could either be a single tick mark or \
a list of very simple tick marks.  Thus, it produces True as an argument to \
either TickQ or TickListQ.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TickPattern", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
    RowBox[{"{", 
     RowBox[{"_", "?", "NumericQ"}], "}"}], "|", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"_", "?", "NumericQ"}], ",", "_"}], "}"}], "|", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"_", "?", "NumericQ"}], ",", "_", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "}"}], "|", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"_", "?", "NumericQ"}], ",", "_", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"_", "?", "NumericQ"}], ")"}], "|", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"_", "?", "NumericQ"}], ",", 
         RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], ",", "_List"}], "}"}]}]}],
   ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TickQ", "[", "x_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"x", ",", "TickPattern"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TickListQ", "[", "x_", "]"}], ":=", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"{", "}"}], "|", 
      RowBox[{"{", 
       RowBox[{"TickPattern", ".."}], "}"}]}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"TickQ", "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<a\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<a\>\"", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<a\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<a\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", "Red", "}"}]}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"TickQ", "/@", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<a\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "\"\<a\>\""}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "\"\<a\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", "Red"}], "}"}]}], 
   "}"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False", ",", "False"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"TickListQ", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"LinTicks", "[", 
     RowBox[{"1", ",", "5", ",", "1", ",", "2"}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"TickListQ", "/@", 
  RowBox[{"{", "None", "}"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", "False", "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tick list manipulation", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LimitTickRange", "[", 
    RowBox[{
     RowBox[{"Range", ":", 
      RowBox[{"{", 
       RowBox[{"x1_", ",", "x2_"}], "}"}]}], ",", "TickList_List"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"TickList", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x_", "?", "NumericQ"}], ")"}], "|", 
        RowBox[{"{", 
         RowBox[{"x_", ",", "___"}], "}"}]}], ")"}], "/;", 
      RowBox[{"ApproxInRange", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x1", ",", "x2"}], "}"}], ",", "x"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4648776748125*^9, 3.464877696859375*^9}, 
   3.46488172975*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LimitTickLabelRange", "[", 
    RowBox[{
     RowBox[{"Range", ":", 
      RowBox[{"{", 
       RowBox[{"x1_", ",", "x2_"}], "}"}]}], ",", "TickList_List"}], "]"}], ":=", 
   RowBox[{"Union", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Cases", "[", 
      RowBox[{"TickList", ",", 
       RowBox[{"x_", "?", "NumericQ"}]}], "]"}], ",", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{"bare", " ", "number"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Cases", "[", 
      RowBox[{"TickList", ",", 
       RowBox[{"{", "x_", "}"}]}], "]"}], ",", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{"no", " ", "label", " ", "given"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Cases", "[", 
      RowBox[{"TickList", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "l_", ",", "r___"}], "}"}], "/;", 
        RowBox[{"ApproxInRange", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "x2"}], "}"}], ",", "x"}], "]"}]}]}], "]"}], 
     ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"label", " ", "--"}], " ", "retain"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Cases", "[", 
      RowBox[{"TickList", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x_", ",", "l_", ",", "r___"}], "}"}], "/;", 
         RowBox[{"!", 
          RowBox[{"ApproxInRange", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1", ",", "x2"}], "}"}], ",", "x"}], "]"}]}]}], 
        "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"x", ",", "\"\<\>\"", ",", "r"}], "}"}]}]}], "]"}]}], "  ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"label", " ", "--"}], " ", "strip"}], " ", "*)"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.464877294546875*^9, 3.464877303390625*^9}, {
   3.464877335140625*^9, 3.46487745284375*^9}, {3.46487761528125*^9, 
   3.464877624296875*^9}, 3.46488172365625*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LimitTickLabelRange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "\"\<a\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", "\"\<b\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.464881597765625*^9, 3.4648816350625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "\<\"a\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "\<\"\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.464881636984375*^9, 3.46488169946875*^9, 
  3.464881742921875*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StripTickLabels", "[", "TickList_List", "]"}], ":=", 
   RowBox[{"Replace", "[", 
    RowBox[{"TickList", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x_", ",", "l_", ",", "r___"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "\"\<\>\"", ",", "r"}], "}"}]}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StripTickLabels", "[", "f_Symbol", "]"}], ":=", 
   RowBox[{"Composition", "[", 
    RowBox[{"StripTickLabels", ",", "f"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.4247295879375*^9, {3.464877473*^9, 3.46487748846875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TransformTicks", "[", 
    RowBox[{
    "PosnTransformation_", ",", "LengthTransformation_", ",", 
     "TickList_List"}], "]"}], ":=", 
   RowBox[{"Replace", "[", 
    RowBox[{"TickList", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x_", ",", "t_", ",", 
        RowBox[{"l", ":", 
         RowBox[{"{", 
          RowBox[{"_", ",", "_"}], "}"}]}], ",", "RestSeq___"}], "}"}], 
      "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PosnTransformation", "@", "x"}], ",", "t", ",", 
        RowBox[{"LengthTransformation", "/@", "l"}], ",", "RestSeq"}], 
       "}"}]}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["End private context", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["End package", "Section"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"$Context", "<>", "\"\<*\>\""}], "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]}], "Input",
 InitializationCell->True]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{1272, 902},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{
      ValueBox["FileName"]}], "Header"]}, {
   Cell[
    TextData[{
      ValueBox["FileName"]}], "Header"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageHeaderLines->{False, Inherited},
PrintingOptions->{"FirstPageHeader"->False,
"PrintingMargins"->{{36, 36}, {36, 36}}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 34, 0, 88, "Section"],
Cell[604, 24, 8180, 171, 674, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[8821, 200, 32, 0, 88, "Section"],
Cell[8856, 202, 307, 7, 35, "Input",
 InitializationCell->True],
Cell[9166, 211, 184, 5, 35, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[9387, 221, 27, 0, 88, "Section"],
Cell[CellGroupData[{
Cell[9439, 225, 36, 0, 46, "Subsection"],
Cell[9478, 227, 249, 6, 35, "Input",
 InitializationCell->True],
Cell[9730, 235, 8509, 208, 1620, "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18288, 449, 40, 0, 88, "Section"],
Cell[18331, 451, 119, 3, 35, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[18487, 459, 67, 0, 88, "Section"],
Cell[18557, 461, 265, 8, 35, "Input",
 InitializationCell->True],
Cell[18825, 471, 364, 12, 35, "Input",
 InitializationCell->True],
Cell[19192, 485, 691, 24, 58, "Input",
 InitializationCell->True],
Cell[19886, 511, 1209, 42, 58, "Input",
 InitializationCell->True],
Cell[21098, 555, 1511, 51, 80, "Input",
 InitializationCell->True],
Cell[22612, 608, 491, 13, 58, "Input",
 InitializationCell->True],
Cell[23106, 623, 2683, 80, 278, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[25826, 708, 50, 0, 88, "Section"],
Cell[CellGroupData[{
Cell[25901, 712, 36, 0, 46, "Subsection"],
Cell[25940, 714, 635, 13, 180, "Text"],
Cell[26578, 729, 333, 9, 35, "Input",
 InitializationCell->True],
Cell[26914, 740, 1904, 47, 344, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[28855, 792, 44, 0, 46, "Subsection"],
Cell[28902, 794, 10832, 262, 1207, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[39771, 1061, 47, 0, 46, "Subsection"],
Cell[39821, 1063, 413, 10, 200, "Text"],
Cell[40237, 1075, 2347, 55, 520, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[42609, 1134, 415, 8, 35, "Input"],
Cell[43027, 1144, 486, 12, 35, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43574, 1163, 98, 1, 88, "Section"],
Cell[43675, 1166, 302, 8, 117, "Text"],
Cell[CellGroupData[{
Cell[44002, 1178, 142, 3, 46, "Subsection"],
Cell[44147, 1183, 163, 3, 34, "Text"],
Cell[44313, 1188, 2169, 52, 388, "Input",
 InitializationCell->True],
Cell[46485, 1242, 1969, 48, 300, "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48503, 1296, 31, 0, 88, "Section"],
Cell[48537, 1298, 171, 4, 34, "Text"],
Cell[48711, 1304, 2267, 50, 146, "Input",
 InitializationCell->True],
Cell[50981, 1356, 15766, 353, 2500, "Input",
 InitializationCell->True],
Cell[66750, 1711, 4081, 100, 498, "Input",
 InitializationCell->True],
Cell[70834, 1813, 5978, 137, 784, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[76849, 1955, 28, 0, 88, "Section"],
Cell[76880, 1957, 988, 22, 325, "Text"],
Cell[77871, 1981, 2046, 44, 124, "Input",
 InitializationCell->True],
Cell[79920, 2027, 6056, 139, 872, "Input",
 InitializationCell->True],
Cell[85979, 2168, 3109, 81, 365, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[89125, 2254, 36, 0, 137, "Section"],
Cell[89164, 2256, 66, 0, 52, "Text"],
Cell[89233, 2258, 415, 11, 90, "Input",
 InitializationCell->True],
Cell[89651, 2271, 49, 0, 52, "Text"],
Cell[89703, 2273, 512, 15, 90, "Input",
 InitializationCell->True],
Cell[90218, 2290, 55, 0, 52, "Text"],
Cell[90276, 2292, 539, 15, 90, "Input",
 InitializationCell->True],
Cell[90818, 2309, 85, 2, 52, "Text"],
Cell[90906, 2313, 676, 19, 90, "Input",
 InitializationCell->True],
Cell[91585, 2334, 64, 0, 52, "Text"],
Cell[91652, 2336, 593, 16, 90, "Input",
 InitializationCell->True],
Cell[92248, 2354, 39, 0, 52, "Text"],
Cell[92290, 2356, 431, 13, 90, "Input",
 InitializationCell->True],
Cell[92724, 2371, 33, 0, 52, "Text"],
Cell[92760, 2373, 534, 15, 90, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[93331, 2393, 42, 0, 137, "Section"],
Cell[93376, 2395, 192, 5, 76, "Text"],
Cell[93571, 2402, 1897, 50, 300, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[95505, 2457, 31, 0, 88, "Section"],
Cell[95539, 2459, 414, 7, 76, "Text"],
Cell[95956, 2468, 1010, 32, 65, "Input",
 InitializationCell->True],
Cell[96969, 2502, 478, 16, 58, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[97472, 2522, 967, 29, 58, "Input"],
Cell[98442, 2553, 137, 4, 35, "Output"],
Cell[98582, 2559, 95, 2, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98714, 2566, 299, 9, 58, "Input"],
Cell[99016, 2577, 79, 2, 35, "Output"],
Cell[99098, 2581, 54, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99201, 2588, 41, 0, 88, "Section"],
Cell[99245, 2590, 761, 24, 40, "Input",
 InitializationCell->True],
Cell[100009, 2616, 2062, 56, 146, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[102096, 2676, 429, 12, 35, "Input"],
Cell[102528, 2690, 324, 9, 35, "Output"]
}, Open  ]],
Cell[102867, 2702, 695, 18, 58, "Input",
 InitializationCell->True],
Cell[103565, 2722, 742, 22, 58, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[104344, 2749, 38, 0, 88, "Section"],
Cell[104385, 2751, 96, 3, 35, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[104518, 2759, 30, 0, 88, "Section"],
Cell[104551, 2761, 244, 7, 58, "Input",
 InitializationCell->True]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
