(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* :Title: ClipToRectangle *)
(* :Context: ClipToRectangle` *)
(* :Author: Mark A. Caprio, Center for Theoretical Physics, Yale University *)
(* :Summary: Clips 2D graphics to a rectangular region. *)
(* :Copyright: Copyright 2011, Mark A. Caprio *)
(* :Package Version: 0.0 *)
(* :Mathematica Version: 4.0 *)
(* :History:
Originated March 5, 2005.
 April 2005.  Distributed with the LevelScheme package.
October 2005.  Fixed symbol name conflict with Mathematica 5.2.
August 2007.  Mathematica 6 compatibility update.
August 2010.  Allow Line to have line complex (list of curves) as argument.
September 20, 2011. Restructured to load from init.m file.  Fix action on Rectangle.
*)
(* :Discussion: Clipping to more complicated polygonal regions may be carried out using the GraphicsOperations package by Jeff Adams, MathSource No. 4200. *)
(* :Examples:

 ClipToRectangleDemo[{{0,1},{0,1}},Graphics[{Line[{{0.1,1.2},{0.1,0.1},{0.3,1.1},{0.4,1.1},{0.5,0.2},{1.1,-0.3},{1.1,1.2}}]}]
]

ClipToRectangleDemo[{{0,1},{0,1}},Graphics[{Polygon[{{0.1,1.2},{0.1,0.1},{0.3,1.1},{0.4,1.1},{0.5,0.2},{1.1,-0.3},{1.1,1.2}}]}]
]

ClipToRectangleDemo[{{0,1},{0,1}},Graphics[{Polygon[-{{0.1,1.2},{0.1,0.1},{0.3,1.1},{0.4,1.1},{0.5,0.2},{1.1,-0.3},{1.1,1.2}}]}]
]
*)


BeginPackage["ClipToRectangle`"];


Unprotect[Evaluate[$Context<>"*"]];


ClipToRectangle::usage="ClipToRectangle[graphics,{{x1,x2},{y1,y2}}] crops graphics to the specified rectangular range.";
ClipToRectangleDemo::usage="ClipToRectangleDemo[graphics,{{x1,x2},{y1,y2}}] crops graphics to the specified rectangular range and displays a \"before and after\" demonstration.";
$ClipToRectangleDebug::usage="Global debugging flag.";


Begin["`Private`"];


$ClipToRectangleDebug=False;


InRange[{x1_,x2_},x_]:=(x1<=x)&&(x<=x2);
InRangeProper[{x1_,x2_},x_]:=(x1<x)&&(x<x2);


InRegion[{{x1_,x2_},{y1_,y2_}},{x_,y_}]:=InRange[{x1,x2},x]&&InRange[{y1,y2},y];


SetAttributes[SegmentResult,HoldAll];  (* to prevent premature evaluation of Pi *)
SegmentResult[Line,Inside1_,Inside2_,P1_,P2_,Pi_]:=
Which[
Inside1&&Inside2,
{P1,P2},
Inside1&&!Inside2,
{P1,Pi},
!Inside1&&!Inside2,
{},
!Inside1&&Inside2,
{Pi,P2}
];
SegmentResult[Polygon,Inside1_,Inside2_,P1_,P2_,Pi_]:=
Which[
Inside1&&Inside2,
Point[P2],
Inside1&&!Inside2,
Point[Pi],
!Inside1&&!Inside2,
{},
!Inside1&&Inside2,
{Point[Pi],Point[P2]}
];


ProcessSegment[Mode_,Bottom,y_,{P1:{x1_,y1_},P2:{x2_,y2_}}]:=Module[
{Inside1,Inside2,Pi},
Inside1=(y1>=y);
Inside2=(y2>=y);
Pi:={x1+(x2-x1)/(y2-y1)*(y-y1),y};
SegmentResult[Mode,Inside1,Inside2,P1,P2,Pi]
];
ProcessSegment[Mode_,Left,x_,{P1:{x1_,y1_},P2:{x2_,y2_}}]:=Module[
{Inside1,Inside2,Pi},
Inside1=(x1>=x);
Inside2=(x2>=x);
Pi:={x,y1+(y2-y1)/(x2-x1)*(x-x1)};
SegmentResult[Mode,Inside1,Inside2,P1,P2,Pi]
];
ProcessSegment[Mode_,Top,y_,{P1:{x1_,y1_},P2:{x2_,y2_}}]:=Module[
{Inside1,Inside2,Pi},
Inside1=(y1<=y);
Inside2=(y2<=y);
Pi:={x1+(x2-x1)/(y2-y1)*(y-y1),y};
SegmentResult[Mode,Inside1,Inside2,P1,P2,Pi]
];
ProcessSegment[Mode_,Right,x_,{P1:{x1_,y1_},P2:{x2_,y2_}}]:=Module[
{Inside1,Inside2,Pi},
Inside1=(x1<=x);
Inside2=(x2<=x);
Pi:={x,y1+(y2-y1)/(x2-x1)*(x-x1)};
SegmentResult[Mode,Inside1,Inside2,P1,P2,Pi]
];


ClipToEdge[Line,Side_,Coord_,Segments_]:=Module[
{ClippedSegments},

(* apply rule to each segment to construct new clipped segment *)
ClippedSegments=(ProcessSegment[Line,Side,Coord,#]&)/@Segments;

(* remove null segments *)
Replace[ClippedSegments,{{}->Sequence@@{}},{1}]
];


ClipToEdge[Polygon,Side_,Coord_,Points_]:=Module[
{Segments,NestedPoints},

(* segmentation, e.g., {P1,P2,P3,P4} -> {{P1,P2},{P2,P3},{P3,P4},{P4,P1}} *) 
Segments=Partition[Points,2,1,{1,1}];

(* apply rule to each segment to construct new points *)
NestedPoints=(ProcessSegment[Polygon,Side,Coord,#]&)/@Segments;

(* flatten resulting list *)
Flatten[NestedPoints]/.{Point->Identity}
];


ListSpliceBlind[]:={};
ListSpliceBlind[L1_List,LRestSeq___List]:=Flatten[{{L1},Rest/@{LRestSeq}},2];
ListSplice[ListOfLists:{___List}]:=ListSpliceBlind@@@Split[ListOfLists,(Last[#1]===First[#2])&];


(* Master function *)
ClipToRectangle[ClipRange:{{x1_,x2_},{y1_,y2_}},Graphics[Primatives_List,Opts___]]:=Graphics[DoClip[ClipRange,Primatives]];


(* Descent into lists *)
DoClip[ClipRange_,Primatives_List]:=(DoClip[ClipRange,#]&)/@Primatives;


(* Polylines *)


DoClip[ClipRange:{{x1_,x2_},{y1_,y2_}},Line[Points:{{_?NumericQ,_?NumericQ}...}]]:=Module[
{Segments,Curves},
If[$ClipToRectangleDebug,Print[Line[Points]]];
If[Length[Points]<2,Return[{}]];

(* segmentation: e.g., {P1,P2,P3,P4} -> {{P1,P2},{P2,P3},{P3,P4}} *)
Segments=Partition[Points,2,1];

(* clip segments to each half plane *)
Segments=ClipToEdge[Line,Bottom,y1,Segments];
Segments=ClipToEdge[Line,Left,x1,Segments];
Segments=ClipToEdge[Line,Top,y2,Segments];
Segments=ClipToEdge[Line,Right,x2,Segments];

(* splice segments with shared endpoints back together *)
Curves=ListSplice[Segments];

If[$ClipToRectangleDebug,Print[Line/@Curves]];
Line/@Curves
];


(* Polygons *)
(* clipped according to Sutherland-Hodgman algorithm, specialized to rectangle *)


DoClip[ClipRange:{{x1_,x2_},{y1_,y2_}},Polygon[RawPoints:{___List}]]:=Module[
{Segments,Points},

If[$ClipToRectangleDebug,Print[Polygon[RawPoints]]];
If[Length[RawPoints]<3,Return[{}]];

AllInterior=And@@((InRegion[ClipRange,#]&)/@RawPoints);
If[AllInterior,Return[Polygon[RawPoints]]];

Points=RawPoints;
Points=ClipToEdge[Polygon,Bottom,y1,Points];
Points=ClipToEdge[Polygon,Left,x1,Points];
Points=ClipToEdge[Polygon,Top,y2,Points];
Points=ClipToEdge[Polygon,Right,x2,Points];

If[$ClipToRectangleDebug,Print[Polygon[Points]]];
Polygon[Points]
];



(* Rectangle as polygon *)
(* no cropping provided if Rectangle contains graphics *)
DoClip[ClipRange_,Rectangle[{x1_,y1_},{x2_,y2_}]]:=DoClip[ClipRange,Polygon[{{x1,y1},{x2,y1},{x2,y2},{x1,y2}}]];
DoClip[ClipRange_,R:Rectangle[{x1_,y1_},{x2_,y2_},_]]:=R;


(* Points, circles, text *)
(* all treated as point-like *)
DoClip[ClipRange_,P:(Point[{x_?NumericQ,y_?NumericQ}]|_Circle|_Disk)]:=If[InRegion[ClipRange,First[P]],P,Sequence@@{}];
DoClip[ClipRange_,P:Point[{{x_?NumericQ,y_?NumericQ}...}]]:=Point[Select[P,(InRegion[ClipRange,#]&)]];
DoClip[ClipRange_,T:_Text]:=If[InRegion[ClipRange,T[[2]]],T,Sequence@@{}];


(* Fall through *)
DoClip[ClipRange_,X:_]:=X;


ClipToRectangleDemo[ClipRange:{{x1_,x2_},{y1_,y2_}},G:Graphics[Primatives_List,Opts___]]:=Show[Graphics[{
{GrayLevel[0.5],First[G]},
{RGBColor[1,0,0],AbsoluteDashing[{2,2}],Line[{{x1,y1},{x2,y1},{x2,y2},{x1,y2},{x1,y1}}]},
{GrayLevel[0],AbsoluteThickness[2],First[ClipToRectangle[ClipRange,G]]}
},{PlotRange->All}
]
];


End[];


Protect[Evaluate[$Context<>"*"]];
Unprotect[Evaluate[$Context<>"$*"]];
EndPackage[];
