(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10946,        309]*)
(*NotebookOutlinePosition[     11762,        336]*)
(*  CellTagsIndexPosition[     11718,        332]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Math 384", "Subtitle"],

Cell[CellGroupData[{

Cell["Using Lagrange multipliers", "Subsubsection",
  CellDingbat->None],

Cell[TextData[{
  "Suppose we wish to minimize ",
  Cell[BoxData[
      \(\((x - 1)\)\^2 + y\^2 + \((z - 2)\)\^2 + \((w + 3)\)\^2\)]],
  " subject to the constraints ",
  Cell[BoxData[
      \(x\^2 + 2\ y\^2 + 3\ z\^2 + 4\ w\^2 \[LessEqual] 1\)]],
  " and ",
  Cell[BoxData[
      \(x - 3\ y + 2\ z - 4\ w \[LessEqual] 2\)]],
  ". The code below will do the job. Note that it is in essence the same \
methodology as was used in the first part of the hand-out for chapter 5."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(f[{x_, y_, z_, w_}] := \((x - 1)\)\^2 + 
        y\^2 + \((z - 2)\)\^2 + \((w + 3)\)\^2\), "\n", 
    \(g1[{x_, y_, z_, w_}] := 
      x\^2 + 2\ y\^2 + 3\ z\^2 + 4\ w\^2 - 1\), "\n", 
    \(g2[{x_, y_, z_, w_}] := 
      x - 3\ y + 2\ z - 4\ w - 2\), "\[IndentingNewLine]", 
    \(\(vars\  = \ {x, y, z, w};\)\), "\[IndentingNewLine]", 
    \(\(lambdas\  = \ {lam1, \ lam2};\)\), "\[IndentingNewLine]", 
    \(\(allvars\  = \ Join[vars, \ lambdas];\)\), "\n", 
    \(\(eqns1 = {lam1*\ g1[vars], 
          lam2*g2[vars]};\)\), "\[IndentingNewLine]", 
    \(\(eqns2\  = \ 
        Map[D[f[vars] + lam1*g1[vars] + lam2*g2[vars], #] &, \ 
          vars];\)\), "\[IndentingNewLine]", 
    \(eqns\  = \ Join[eqns1, eqns2]\)}], "Input"],

Cell[BoxData[
    \({lam1\ \((\(-1\) + 4\ w\^2 + x\^2 + 2\ y\^2 + 3\ z\^2)\), 
      lam2\ \((\(-2\) - 4\ w + x - 3\ y + 2\ z)\), 
      lam2 + 2\ \((\(-1\) + x)\) + 2\ lam1\ x, \(-3\)\ lam2 + 2\ y + 
        4\ lam1\ y, 
      2\ lam2 + 2\ \((\(-2\) + z)\) + 6\ lam1\ z, \(-4\)\ lam2 + 8\ lam1\ w + 
        2\ \((3 + w)\)}\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(\(solns = Solve[eqns == 0, allvars];\)\), "\n", 
    \(\(s2\  = \ 
        Select[solns, \ \((FreeQ[#, \ 
                  Complex]\  && \ \((Simplify[lam1 /. #])\) \[GreaterEqual] 
                  0\  && \ \((Simplify[lam2 /. #])\) \[GreaterEqual] 
                  0\  && \ \((Simplify[g1[vars] /. #])\) \[LessEqual] 
                  0\  && \ \((Simplify[g2[vars] /. #])\) \[LessEqual] 
                  0)\)\  &];\)\)}], "Input"],

Cell["Let us check our candidate minimizers.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[s2]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell["\<\
It would appear that we have only one, hence that must be the constrained \
global minimizer. Here is a question to ponder: How do we find a maximizer \
from among the original solutions? (Hint: there is a slightly different \
condition for the multipliers in this case.)\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(nsol\  = \ N[s2]\), "\[IndentingNewLine]", 
    \(f[vars]\  /. \ nsol\)}], "Input"],

Cell[BoxData[
    \({{lam2 \[Rule] 0.3586305350786038`, x \[Rule] 0.3504968070813653`, 
        y \[Rule] 0.1460626538609916`, z \[Rule] 0.3266751650545671`, 
        w \[Rule] \(-0.35858520609887773`\), 
        lam1 \[Rule] 1.341489896283152`}}\)], "Output"],

Cell[BoxData[
    \({10.220276813149287`}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This process raises several questions. First, why do we use ",
  Cell[BoxData[
      \(Solve\)]],
  " to find the candidates? Does it always work? Might there be a better way? \
What about selecting the candidates? Here are some issues to consider. First, \
",
  Cell[BoxData[
      \(Solve\)]],
  " is best as a solver for polynomial systems. If there are transcendental \
functions e.g. ",
  Cell[BoxData[
      \(Cos\)]],
  " or ",
  Cell[BoxData[
      \(Exp\)]],
  " then it may or may not find the solution you want. Moreover for \
polynomial systems it may expend alot of effort in finding all solutions, and \
many might be complex-valued. So there might be reason to use ",
  Cell[BoxData[
      \(NSolve\)]],
  " instead (it is often faster but will still try to find all solutions) or \
perhaps ",
  Cell[BoxData[
      \(FindRoot\)]],
  " or an implementation of Broyden's method from chapter 4. But for these \
one requires a reasonable initial guess, and this may not be obvious to find. \
Moral: reducing a max/min problem to a set of equations to solve does not \
finish the job. Here is another possible tactic: use (unconstrained) ",
  Cell[BoxData[
      \(FindMinimum\)]],
  " on the sum of squares of the expressions we need to solve."
}], "Text"],

Cell[TextData[{
  "There are other issues. I used ",
  Cell[BoxData[
      \(Solve\)]],
  " above because I know it will find exact solutions. In real-world problems \
we want to use faster numeric code and we are willing to have approximate \
solutions. So one might use ",
  Cell[BoxData[
      \(NSolve\)]],
  ". But then the constraints might not quite be satisfied. So in that case \
you might want to allow a small amount of slop in checking them. Indeed, if I \
use numeric approximations above the constraints will appear to be violated, \
and that was a relatively simple example."
}], "Text"],

Cell[TextData[{
  "The equations we get for inequality constraints are problematic when we \
use a numeric root-finder or minimizer. The reason is that a small Lagrange \
multiplier can make a term small even when the corresponding constraint is \
badly violated. For equality constraints we do not have ",
  Cell[BoxData[
      \(multiplier\ constraint == 0\)]],
  " because we know it is the constraint that must vanish, so this is not a \
problem in that case."
}], "Text"],

Cell[TextData[{
  "Below I illustrate some of this with the chapter 6 constrained variant of \
The Problem From Chapter Three. Due to the difficulty noted above I now use \
equality constraints and select random values between zero and one for \
starting values. I do not use ",
  Cell[BoxData[
      \(Solve\)]],
  " below to get candidate minimizers because it takes too long. ",
  Cell[BoxData[
      \(FindRoot\)]],
  " seems up to the task if allowed sufficiently many iterations."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(fhard[{x1_, x2_, x3_, x4_}] := 
      3*x1^2*x2\  - \ x1*x2*x3\  + \ x2*x4^2\  + \ 2*x1\  - \ 7*x3\  + 
        Exp[x1^2 + x2^4 + x3^2 + x4^2]\), "\[IndentingNewLine]", 
    \(\(vars\  = \ {x1, x2, x3, x4};\)\), "\[IndentingNewLine]", 
    \(g1[{x1_, x2_, x3_, x4_}] := \ 
      x1^2\  - \ 3*x2\  + \ x3*x4\  + \ 5\), "\[IndentingNewLine]", 
    \(g2[{x1_, x2_, x3_, x4_}] := \ 
      x1*x2\  - \ x4^2\  + \ x3\  + \ 6\), "\[IndentingNewLine]", 
    \(\(lambdas\  = \ {lam1, \ lam2};\)\), "\[IndentingNewLine]", 
    \(\(allvars\  = \ Join[vars, \ lambdas];\)\), "\n", 
    \(\(exprs1 = {\ g1[vars], g2[vars]};\)\), "\[IndentingNewLine]", 
    \(\(exprs2\  = \ 
        Map[D[fhard[vars] + lam1*g1[vars] + lam2*g2[vars], #] &, \ 
          vars];\)\), "\[IndentingNewLine]", 
    \(exprs\  = \ Join[exprs1, exprs2]\)}], "Input"],

Cell[BoxData[
    \({5 + x1\^2 - 3\ x2 + x3\ x4, 6 + x1\ x2 + x3 - x4\^2, 
      2 + 2\ \[ExponentialE]\^\(x1\^2 + x2\^4 + x3\^2 + x4\^2\)\ x1 + 
        2\ lam1\ x1 + lam2\ x2 + 6\ x1\ x2 - x2\ x3, \(-3\)\ lam1 + 
        lam2\ x1 + 3\ x1\^2 + 
        4\ \[ExponentialE]\^\(x1\^2 + x2\^4 + x3\^2 + x4\^2\)\ x2\^3 - 
        x1\ x3 + x4\^2, \(-7\) + lam2 - x1\ x2 + 
        2\ \[ExponentialE]\^\(x1\^2 + x2\^4 + x3\^2 + x4\^2\)\ x3 + lam1\ x4, 
      lam1\ x3 + 2\ \[ExponentialE]\^\(x1\^2 + x2\^4 + x3\^2 + x4\^2\)\ x4 - 
        2\ lam2\ x4 + 2\ x2\ x4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\(soln = 
          FindRoot[
            Evaluate[Thread[exprs == 0]], {x1, Random[]}, \ {x2, 
              Random[]}, \ {x3, Random[]}, {x4, Random[]}, \ {lam1, 
              Random[]}, \ {lam2, Random[]}, \ 
            MaxIterations \[Rule] 5000];\)]\)], "Input"],

Cell[BoxData[
    \({1.2100000000009459`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(soln\)], "Input"],

Cell[BoxData[
    \({x1 \[Rule] \(-0.19566064013889786`\), x2 \[Rule] 0.8332230212055597`, 
      x3 \[Rule] \(-1.1758486374398318`\), x4 \[Rule] 2.1589632726965555`, 
      lam1 \[Rule] 511.2343451033996`, 
      lam2 \[Rule] 570.7339287338688`}\)], "Output"]
}, Open  ]],

Cell["We check the constraint equations:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g1[vars]\  /. \ solns\)], "Input"],

Cell[BoxData[
    \(\(-8.881784197001252`*^-16\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g2[vars]\  /. \ soln\)], "Input"],

Cell[BoxData[
    \(8.881784197001252`*^-16\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Actually there is not much need to check things, we already saw this \
result in the penalty method hand-out. The fact that we have trouble handling \
inequality constraints (I tried it) indicates the importance of the penalty \
method from chapter 6, which was able to get reasonable results on the \
inequality-constrained variant of this problem. A tactic one might try with \
this method would be to split into subcases where either the constraint is \
zero or the multiplier is zero, letting ",
  Cell[BoxData[
      \(FindRoot\)]],
  " handle these separately."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 640}, {0, 407}},
ScreenStyleEnvironment->"Working",
WindowSize->{496, 311},
WindowMargins->{{Automatic, 55}, {Automatic, 24}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{36, 36}, {36, 43.1875}}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[1792, 55, 72, 1, 43, "Subsubsection"],
Cell[1867, 58, 486, 12, 90, "Text"],

Cell[CellGroupData[{
Cell[2378, 74, 752, 15, 230, "Input"],
Cell[3133, 91, 338, 6, 33, "Output"]
}, Open  ]],
Cell[3486, 100, 460, 8, 60, "Input"],
Cell[3949, 110, 54, 0, 26, "Text"],

Cell[CellGroupData[{
Cell[4028, 114, 43, 1, 22, "Input"],
Cell[4074, 117, 35, 1, 22, "Output"]
}, Open  ]],
Cell[4124, 121, 295, 5, 40, "Text"],

Cell[CellGroupData[{
Cell[4444, 130, 104, 2, 35, "Input"],
Cell[4551, 134, 260, 4, 22, "Output"],
Cell[4814, 140, 55, 1, 22, "Output"]
}, Open  ]],
Cell[4884, 144, 1287, 32, 127, "Text"],
Cell[6174, 178, 602, 13, 69, "Text"],
Cell[6779, 193, 476, 9, 69, "Text"],
Cell[7258, 204, 498, 11, 55, "Text"],

Cell[CellGroupData[{
Cell[7781, 219, 849, 15, 138, "Input"],
Cell[8633, 236, 571, 9, 54, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9241, 250, 296, 6, 48, "Input"],
Cell[9540, 258, 69, 1, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9646, 264, 37, 1, 22, "Input"],
Cell[9686, 267, 260, 4, 22, "Output"]
}, Open  ]],
Cell[9961, 274, 50, 0, 26, "Text"],

Cell[CellGroupData[{
Cell[10036, 278, 54, 1, 22, "Input"],
Cell[10093, 281, 62, 1, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10192, 287, 53, 1, 22, "Input"],
Cell[10248, 290, 57, 1, 22, "Output"]
}, Open  ]],
Cell[10320, 294, 598, 11, 69, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

