(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5084,        150]*)
(*NotebookOutlinePosition[      5864,        176]*)
(*  CellTagsIndexPosition[      5820,        172]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Math 384", "Subtitle"],

Cell[CellGroupData[{

Cell["Steepest Descent examples", "Subsubsection",
  CellDingbat->None],

Cell["\<\
Here is an implementation of something like the method of Steepest Descent as \
described in class. Part of the homework problem is to describe how this \
might fall short of that description.\
\>", "Text"],

Cell[BoxData[
    \(steepDescend[func_, \ vars_List, \ start_, \ iters_:  15]\  := 
      Module[\[IndentingNewLine]{grad, phi, t, point = start, 
          thisphi}, \[IndentingNewLine]grad\  = \ 
          Map[D[func, #] &, \ vars]; \[IndentingNewLine]phi[t]\  = \ 
          func\  /. \ Thread[
              vars\  -> vars - 
                  t*grad]; \[IndentingNewLine]Do[\[IndentingNewLine]thisphi\  
            = \ phi[t]\  /. 
              Thread[vars \[Rule] point]; \[IndentingNewLine]tmin\  = \ 
            FindMinimum[Evaluate[thisphi], \ 
              {t, 0, 1/2}]; \[IndentingNewLine]point\  = \ 
            point\  - 
              \((t /. \ tmin[\([2]\)])\)*
                \((grad /. Thread[vars \[Rule] point])\), \ 
          {iters}]; \[IndentingNewLine]point\[IndentingNewLine]]\)], "Input"],

Cell["\<\
Here is a quick example I covered in class, again using two iterations.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(steepDescend[x^2\  + \ 3*x*y\  + \ 3*y^2, {x, y}, {0, 2}, 2]\)], "Input"],

Cell[BoxData[
    \({\(-3.647612278889767`*^-8\), 0.026315894102427573`}\)], "Output"]
}, Open  ]],

Cell["\<\
Note that if you want to see the progress at each iteration you can simply \
insert print statements inside the loop. For example you can print out the \
coordinates of each successive point, or the function values at those points.

Here is the same example but with the default number of iterations (25).\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(steepDescend[x^2\  + \ 3*x*y\  + \ 3*y^2, {x, y}, {0, 2}]\)], "Input"],

Cell[BoxData[
    \({\(-5.3909199922870115`*^-14\), 2.8751572951347065`*^-14}\)], "Output"]
}, Open  ]],

Cell["\<\
Now we do the substantially harder example from the Newton's method handout. \
Note that I had to give a more favorable starting point because otherwise I \
get overflows. Offhand I am not sure if one can code this in such a way as to \
avoid that difficulty.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(f[x1_, x2_, x3_, x4_] := 
      3*x1^2*x2\  - \ x1*x2*x3\  + \ x2*x4^2\  + \ 2*x1\  - \ 7*x3\  + 
        Exp[x1^2 + x2^4 + x3^2 + x4^2]\), "\[IndentingNewLine]", 
    \(\(vars\  = \ {x1, x2, x3, x4};\)\), "\[IndentingNewLine]", 
    \(steepDescend[f[x1, x2, x3, x4], {x1, x2, x3, x4}, {2, 1, \(-1\), 1}, 
      100]\)}], "Input"],

Cell[BoxData[
    \({\(-0.5309267852184874`\), \(-0.4537210843382178`\), 
      0.9874186810699188`, \(-8.110542408474014`*^-17\)}\)], "Output"]
}, Open  ]],

Cell["\<\
This is in agreement with the result obtained from hand-coded Newton's \
iterations.\
\>", "Text"],

Cell[TextData[{
  "Note that ",
  Cell[BoxData[
      \(steepDescend\)]],
  " has a pair of related drawbacks. Homework: What are those shortcomings? \
Hint 1: What sort of task is performed at each step, and what can we say \
about the success or failure in performing that task? Hint 2: Reread what I \
said in the first paragraph."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{496, 295},
WindowMargins->{{Automatic, 3}, {-44, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{36, 36}, {36, 50.375}}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[1792, 55, 71, 1, 43, "Subsubsection"],
Cell[1866, 58, 216, 4, 71, "Text"],
Cell[2085, 64, 820, 15, 270, "Input"],
Cell[2908, 81, 95, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[3028, 87, 93, 1, 50, "Input"],
Cell[3124, 90, 86, 1, 29, "Output"]
}, Open  ]],
Cell[3225, 94, 329, 6, 109, "Text"],

Cell[CellGroupData[{
Cell[3579, 104, 90, 1, 30, "Input"],
Cell[3672, 107, 91, 1, 29, "Output"]
}, Open  ]],
Cell[3778, 111, 283, 5, 71, "Text"],

Cell[CellGroupData[{
Cell[4086, 120, 351, 6, 130, "Input"],
Cell[4440, 128, 144, 2, 29, "Output"]
}, Open  ]],
Cell[4599, 133, 108, 3, 33, "Text"],
Cell[4710, 138, 346, 8, 90, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

