(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16343,        505]*)
(*NotebookOutlinePosition[     16998,        528]*)
(*  CellTagsIndexPosition[     16954,        524]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Math 384", "Subtitle"],

Cell[CellGroupData[{

Cell["An unconstrained minimization (primal program) example", "Subsubsection",
  CellDingbat->None],

Cell["Suppose we wish to minimize", "Text"],

Cell[BoxData[
    \(f[w_, x_, y_, z_] := 
      w\^3\/\(\@x\ y\) + 3\ x\ y\^2\ z + \(2\ x\)\/\(y\ z\^2\) + 
        \(5\ z\^2\)\/w + \(\[Pi]\ y\ z\)\/x\^2\)], "Input"],

Cell[TextData[{
  "where as is customary for this sort of problem our domain is\n{",
  Cell[BoxData[
      \({w, x, y, z}\)]],
  " : ",
  Cell[BoxData[
      \(w > 0, x > 0, y > 0, z > 0\)]],
  "}\n\nWe set up linear equations for ",
  Cell[BoxData[
      \(\[Lambda]\_1\)]],
  ", ",
  Cell[BoxData[
      \(\[Lambda]\_2\)]],
  ", ",
  Cell[BoxData[
      \(\[Lambda]\_3\)]],
  ", ",
  Cell[BoxData[
      \(\[Lambda]\_4\)]],
  ", and ",
  Cell[BoxData[
      \(\[Lambda]\_5\)]],
  " in order to solve the dual program. In addition to the normality \
equation"
}], "Text"],

Cell[BoxData[
    \(\(eq1\  = \ 
        \[Lambda]\_1 + \[Lambda]\_2 + \[Lambda]\_3 + \[Lambda]\_4 + 
            \[Lambda]\_5 \[Equal] 1;\)\)], "Input"],

Cell[TextData[{
  "we have an equation for each variable. That is, we get an equation in the \
",
  Cell[BoxData[
      \(\[Lambda]\)]],
  "'s that forces the exponent of each variable to be zero when the AGM \
inequality is applied. The equations are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(moreeqns = 
        {3\ \[Lambda]\_1 - \[Lambda]\_4 == 0, 
          \(-\(\[Lambda]\_1\/2\)\) + \[Lambda]\_2 + \[Lambda]\_3 - 
              2\ \[Lambda]\_5 == 0, 
          \(-\[Lambda]\_1\) + 2\ \[Lambda]\_2 - \[Lambda]\_3 + \[Lambda]\_5 == 
            0, \[Lambda]\_2 - 2\ \[Lambda]\_3 + 2\ \[Lambda]\_4 + 
              \[Lambda]\_5 == 0};\)\), "\n", 
    \(\(vars = 
        {\[Lambda]\_1, \[Lambda]\_2, \[Lambda]\_3, \[Lambda]\_4, 
          \[Lambda]\_5};\)\), "\n", 
    \(lambdasoln = First[Solve[Prepend[moreeqns, eq1], vars]]\)}], "Input"],

Cell[BoxData[
    \({\[Lambda]\_1 \[Rule] 4\/57, \[Lambda]\_2 \[Rule] 1\/9, 
      \[Lambda]\_3 \[Rule] 65\/171, \[Lambda]\_4 \[Rule] 4\/19, 
      \[Lambda]\_5 \[Rule] 13\/57}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This gives values for the ",
  Cell[BoxData[
      \(\[Lambda]\)]],
  "'s for which the DP is consistent. As there is a unique solution it \
moreover gives the maximizing point for the DP. Let us explicitly state the \
DP, get the maximizing value, because it is the minimizing value for the PP. \
We will then use it to find the point that minimizes the original PP. The DP \
is to maximize"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(v[\[Lambda]1_, \[Lambda]2_, \[Lambda]3_, \[Lambda]4_, \[Lambda]5_] := 
        \((1\/\[Lambda]1)\)\^\[Lambda]1\ \((3\/\[Lambda]2)\)\^\[Lambda]2\ \
\((2\/\[Lambda]3)\)\^\[Lambda]3\ \((5\/\[Lambda]4)\)\^\[Lambda]4\ \((\[Pi]\/\
\[Lambda]5)\)\^\[Lambda]5;\)\), "\[IndentingNewLine]", 
    \(v[\[Lambda]\_1\ , \[Lambda]\_2\ , \[Lambda]\_3\ , \[Lambda]\_4\ , 
      \[Lambda]\_5]\)}], "Input"],

Cell[BoxData[
    \(2\^\[Lambda]\_3\ 3\^\[Lambda]\_2\ 5\^\[Lambda]\_4\ \[Pi]\^\[Lambda]\_5\ \
\((1\/\[Lambda]\_1)\)\^\[Lambda]\_1\ \((1\/\[Lambda]\_2)\)\^\[Lambda]\_2\ \
\((1\/\[Lambda]\_3)\)\^\[Lambda]\_3\ \((1\/\[Lambda]\_4)\)\^\[Lambda]\_4\ \
\((1\/\[Lambda]\_5)\)\^\[Lambda]\_5\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Now we plug in the values for the ",
  Cell[BoxData[
      \(\[Lambda]\)]],
  "'s that maximize the DP."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vlamstar\  = \ 
      v[\[Lambda]\_1\ , \[Lambda]\_2\ , \[Lambda]\_3\ , \[Lambda]\_4\ , 
          \[Lambda]\_5]\  /. \ lambdasoln\)], "Input"],

Cell[BoxData[
    \(\(3\ 3\^\(67/171\)\ 19\^\(8/9\)\ \[Pi]\^\(13/57\)\)\/\(2\^\(31/171\)\ 5\
\^\(29/171\)\ 13\^\(104/171\)\)\)], "Output"]
}, Open  ]],

Cell["\<\
Let us see numerically what our minimizing value is for the PP:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[vlamstar]\)], "Input"],

Cell[BoxData[
    \(11.574998663475107`\)], "Output"]
}, Open  ]],

Cell["\<\
To solve for the minimizing point for the PP, recall that we have the \
equations below.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(neweqns\  = \ 
        {\[Lambda]\_1 == \(w\^3\/\(\@x\ y\)\)\ /\ vlamstar, 
            \[Lambda]\_2\  == 3\ x\ y\^2\ z/vlamstar, \ 
            \[Lambda]\_3 == \(\(2\ x\)\/\(y\ z\^2\)\)/vlamstar, \ 
            \[Lambda]\_4 == \(\(5\ z\^2\)\/w\)/vlamstar, \ 
            \[Lambda]\_5 == \ \(\(\[Pi]\ y\ z\)\/x\^2\)/vlamstar}\  /. \ 
          lambdasoln;\)\), "\n", 
    \(\(origvars\  = \ {x, y, z, w};\)\), "\n", 
    \(\(soln\  = \ Solve[neweqns, origvars];\)\), "\n", 
    \(Length[soln]\)}], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[soln]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 0.830625087686358`, w \[Rule] 0.8702359672595865`, 
        y \[Rule] 0.8902305205514333`, z \[Rule] 0.6512491691620181`}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Let us check that we indeed go our minimizing point. It better give the \
minimizing value when we plug it into ",
  Cell[BoxData[
      \(f[w, x, y, z]\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fval\  = \ f[w, x, y, z]\  /. \ First[soln]\)], "Input"],

Cell[BoxData[
    \(\(8\ 2\^\(140/171\)\ 3\^\(67/171\)\ \[Pi]\^\(13/57\)\)\/\(5\^\(29/171\)\
\ 13\^\(104/171\)\ 19\^\(1/9\)\) + 
      \(5\^\(142/171\)\ 13\^\(67/171\)\ \[Pi]\^\(13/57\)\)\/\(2\^\(31/171\)\ \
3\^\(104/171\)\ 19\^\(1/9\)\) + 
      \(19\^\(8/9\)\ \[Pi]\^\(13/57\)\)\/\(2\^\(31/171\)\ 5\^\(29/171\)\ 39\^\
\(104/171\)\) + 
      \(39\^\(67/171\)\ \[Pi]\^\(13/57\)\)\/\(2\^\(31/171\)\ 5\^\(29/171\)\ \
19\^\(1/9\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[fval]\)], "Input"],

Cell[BoxData[
    \(11.57499866347513`\)], "Output"]
}, Open  ]],

Cell["\<\
Looks good. But this is a bit slow and it can also give extraneous solutions \
(obviously it did not do so in this case). We can avoid these pitfalls by \
converting to a linear system; this we accomplish by taking logarithms and \
applying the log laws that apply when all bases are positive and all \
exponents are real.\
\>", "Text"],

Cell[BoxData[{
    \(\(logneweqns\  = \ Map[Log, neweqns, {2}];\)\), "\[IndentingNewLine]", 
    \(\(logneweqnsexpanded\  = \ PowerExpand[logneweqns];\)\)}], "Input"],

Cell["\<\
To give you an idea of what the lines above did, we show one equation from \
each of the above.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(First[logneweqns]\), "\[IndentingNewLine]", 
    \(First[logneweqnsexpanded]\)}], "Input"],

Cell[BoxData[
    \(\(-Log[57\/4]\) == 
      Log[\(2\^\(31/171\)\ 5\^\(29/171\)\ 13\^\(104/171\)\ w\^3\)\/\(3\ \
3\^\(67/171\)\ 19\^\(8/9\)\ \[Pi]\^\(13/57\)\ \@x\ y\)]\)], "Output"],

Cell[BoxData[
    \(Log[4] - Log[57] == 
      \(31\ Log[2]\)\/171 - \(238\ Log[3]\)\/171 + \(29\ Log[5]\)\/171 + 
        \(104\ Log[13]\)\/171 - \(8\ Log[19]\)\/9 - \(13\ Log[\[Pi]]\)\/57 + 
        3\ Log[w] - Log[x]\/2 - Log[y]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "To make the equations truly linear we actually need to solve for ",
  Cell[BoxData[
      \(Log[w]\)]],
  ", etc. Hence I map ",
  Cell[BoxData[
      \(Log\)]],
  " over the variable list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(logvars\  = \ Map[Log, origvars];\)\), "\[IndentingNewLine]", 
    \(\(logsoln\  = \ First[Solve[logneweqnsexpanded, logvars]];\)\), 
  "\[IndentingNewLine]", 
    \(newsoln\  = \ Simplify[Map[Exp, \ logsoln, {2}]]\)}], "Input"],

Cell[BoxData[
    \({x \[Rule] 
        \(2\^\(44/171\)\ 19\^\(2/9\)\ \[Pi]\^\(22/57\)\)\/\(5\^\(14/171\)\ 39\
\^\(62/171\)\), 
      y \[Rule] 
        \(5\^\(14/57\)\ 13\^\(5/57\)\ 19\^\(1/3\)\)\/\(2\^\(44/57\)\ \
3\^\(52/57\)\ \[Pi]\^\(3/19\)\), 
      z \[Rule] 
        \(2\ \((3\/5)\)\^\(11/19\)\ 2\^\(2/19\)\ \
\[Pi]\^\(3/19\)\)\/13\^\(8/19\), 
      w \[Rule] 
        \(2\^\(67/171\)\ 5\^\(2/171\)\ 19\^\(1/9\)\ \
\[Pi]\^\(5/57\)\)\/39\^\(40/171\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Still looking good. This was a bit trickier to code but it works alot \
faster than a direct call to ",
  Cell[BoxData[
      \(Solve\)]],
  " without converting to/from logarithms.\n\nNote that the neweqns is \
overdetermined, hence so is ",
  Cell[BoxData[
      \(logneweqnsexpanded\)]],
  ". It was remarked in class that this should cause no trouble because the \
system will still be consistent. This is true, but suppose instead that we \
worked with machine numbers either because or original problem was in terms \
of approximate data or because the system of equations was large and we know \
machine arithmetic linear algebra is alot faster than exact linear algebra. \
Is the overdetermined system still consistent?"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(numericlogsoln\  = \ Solve[N[logneweqnsexpanded], logvars]\)], "Input"],

Cell[BoxData[
    \(RowReduce::"luc" \( : \ \) 
      "Result for \!\(RowReduce\) of badly conditioned matrix \!\({\
\[LeftSkeleton] 1 \[RightSkeleton]}\) may contain significant numerical \
errors."\)], "Message"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell["\<\
Oh dear, it appears not to be. We can repair this quite easily, actually. One \
method is simply to drop one equation.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(numericlogsoln\  = \ 
        First[Solve[N[Drop[logneweqnsexpanded, 1]], logvars]];\)\), 
  "\[IndentingNewLine]", 
    \(numericnewsoln\  = \ Map[Exp, \ numericlogsoln, {2}]\)}], "Input"],

Cell[BoxData[
    \({x \[Rule] 0.8306250876863586`, y \[Rule] 0.8902305205514371`, 
      z \[Rule] 0.6512491691620192`, w \[Rule] 0.8702359672595875`}\)], 
  "Output"]
}, Open  ]],

Cell["We'll check the accuracy of the numeric solution.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(({x, y, z, w}\  /. \ numericnewsoln)\)\  - \ 
      \(({x, y, z, w}\  /. newsoln)\)\)], "Input"],

Cell[BoxData[
    \({6.661338147750939`*^-16, 3.885780586188048`*^-15, 
      1.1102230246251565`*^-15, 9.992007221626409`*^-16}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Not bad, these are within an order of magnitude of ",
  Cell[BoxData[
      \($MachinePrecision\)]],
  ". We could do better if we are willing to do higher precision linear \
algebra, though of course this can be alot slower than using machine \
arithmetic. In fact if we do it this way often we will not even need to \
discard an equation; the software that performs this arithmetic will detect \
that they are consistent. Another method that is often used to handle \
over-determined linear (and even nonlinear, but using different technology \
than I describe) systems is to go for a \"least-squares\" solution. This is a \
result for which one does not have actual equality when solving the linear \
system ",
  Cell[BoxData[
      \(A . \(x\& \[Rule] \) = \(y\& \[Rule] \)\)]],
  " for ",
  Cell[BoxData[
      \(\(x\& \[Rule] \)\)]],
  " given the matrix ",
  Cell[BoxData[
      \(A\)]],
  " and vector ",
  Cell[BoxData[
      \(\(y\& \[Rule] \)\)]],
  ". Instead we minimize the sum of squares of the differences in each \
component between left-hand-side and right-hand-side. One way to obtain such \
a solution is to use what is called the pseudoinverse of a (non-invertible) \
matrix.\n\nTo demonstrate this method we explicitly convert to a matrix. For \
this I'll use a utility in the ",
  Cell[BoxData[
      \(LinearAlgebra\)]],
  " add-on package ",
  Cell[BoxData[
      \(MatrixManipulation\)]],
  ". If you wonder how I know about this obscure utility, well, it helps to \
be the person who wrote it."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(numericeqns\  = \ N[logneweqnsexpanded];\)\), "\n", 
    \(\(Needs["\<LinearAlgebra`MatrixManipulation`\>"];\)\), "\n", 
    \({mat, vec}\  = \ LinearEquationsToMatrices[numericeqns, logvars]\)}], 
  "Input"],

Cell[BoxData[
    \({{{0.5`, 1.`, 0, \(-3.`\)}, {\(-1\), \(-2.`\), \(-1\), 0}, 
        {\(-1\), 1.`, 2.`, 0}, {0, 0, \(-2.`\), 1.`}, 
        {2.`, \(-1\), \(-1\), 0}}, 
      {0.20790942220887798`, 0.8469893814985481`, \(-0.7884240173388126`\), 
        0.7187350459748684`, 0.1739843117166322`}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "First we show, using ",
  Cell[BoxData[
      \(LinearSolve\)]],
  ", that the system is indeed regarded as inconsistent."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[mat, vec]\)], "Input"],

Cell[BoxData[
    \(LinearSolve::"nosol" \( : \ \) 
      "Linear equation encountered which has no solution."\)], "Message"],

Cell[BoxData[
    \(LinearSolve[
      {{0.5`, 1.`, 0, \(-3.`\)}, {\(-1\), \(-2.`\), \(-1\), 0}, 
        {\(-1\), 1.`, 2.`, 0}, {0, 0, \(-2.`\), 1.`}, 
        {2.`, \(-1\), \(-1\), 0}}, 
      {0.20790942220887798`, 0.8469893814985481`, \(-0.7884240173388126`\), 
        0.7187350459748684`, 0.1739843117166322`}]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Now I find the least-squares solution to the linear system using ",
  Cell[BoxData[
      \(PseudoInverse\)]],
  ", and then exponentiate because we want solutions for the actual \
variables, not their logarithms."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Exp, \ PseudoInverse[mat]\  . \ vec]\)], "Input"],

Cell[BoxData[
    \({0.8306250876863585`, 0.8902305205514374`, 0.6512491691620188`, 
      0.8702359672595864`}\)], "Output"]
}, Open  ]],

Cell["\<\
Does it look familiar? I should mention that if you are unfamiliar \
least-squares minimization or with the pseudo-inverse of a matrix, these are \
topics we will cover in chapter four. Also, as with solving linear systems, \
there are frequently better ways than to explicitly multiply by the \
pseudo-inverse. This, too, will be covered in chapter 4.\
\>", "Text"],

Cell[TextData[{
  "To summarize, when we have an exactly determined system for finding the ",
  Cell[BoxData[
      \(\[Lambda]\)]],
  "'s to solve the DP we then get a system for the PP that appears to be \
overdetermined by one equation. We can still solve it exactly. We can solve \
it faster by converting to linear equations in the logarithms of the \
variables for the PP. We can solve it faster still if we are willing to use \
machine arithmetic approximations. But then the system will appear to be \
inconsistent. To address this we might (i) drop one equation, or (ii) use \
higher-precision arithmetic, or (iii) obtain a least-squares solution."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{496, 415},
WindowMargins->{{58, Automatic}, {Automatic, -20}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[1792, 55, 100, 1, 43, "Subsubsection"],
Cell[1895, 58, 43, 0, 33, "Text"],
Cell[1941, 60, 167, 3, 51, "Input"],
Cell[2111, 65, 572, 24, 109, "Text"],
Cell[2686, 91, 153, 3, 30, "Input"],
Cell[2842, 96, 265, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[3132, 107, 574, 11, 104, "Input"],
Cell[3709, 120, 190, 3, 42, "Output"]
}, Open  ]],
Cell[3914, 126, 423, 9, 90, "Text"],

Cell[CellGroupData[{
Cell[4362, 139, 410, 6, 85, "Input"],
Cell[4775, 147, 295, 4, 45, "Output"]
}, Open  ]],
Cell[5085, 154, 135, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[5245, 163, 163, 3, 30, "Input"],
Cell[5411, 168, 138, 2, 45, "Output"]
}, Open  ]],
Cell[5564, 173, 87, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[5676, 179, 44, 1, 30, "Input"],
Cell[5723, 182, 53, 1, 29, "Output"]
}, Open  ]],
Cell[5791, 186, 112, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[5928, 193, 529, 10, 207, "Input"],
Cell[6460, 205, 35, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6532, 211, 40, 1, 30, "Input"],
Cell[6575, 214, 171, 3, 29, "Output"]
}, Open  ]],
Cell[6761, 220, 194, 6, 52, "Text"],

Cell[CellGroupData[{
Cell[6980, 230, 76, 1, 30, "Input"],
Cell[7059, 233, 442, 8, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7538, 246, 40, 1, 30, "Input"],
Cell[7581, 249, 52, 1, 29, "Output"]
}, Open  ]],
Cell[7648, 253, 346, 6, 90, "Text"],
Cell[7997, 261, 166, 2, 50, "Input"],
Cell[8166, 265, 119, 3, 52, "Text"],

Cell[CellGroupData[{
Cell[8310, 272, 111, 2, 50, "Input"],
Cell[8424, 276, 183, 3, 50, "Output"],
Cell[8610, 281, 245, 4, 96, "Output"]
}, Open  ]],
Cell[8870, 288, 221, 8, 52, "Text"],

Cell[CellGroupData[{
Cell[9116, 300, 251, 4, 70, "Input"],
Cell[9370, 306, 471, 12, 89, "Output"]
}, Open  ]],
Cell[9856, 321, 759, 15, 185, "Text"],

Cell[CellGroupData[{
Cell[10640, 340, 91, 1, 30, "Input"],
Cell[10734, 343, 214, 4, 63, "Message"],
Cell[10951, 349, 36, 1, 29, "Output"]
}, Open  ]],
Cell[11002, 353, 142, 3, 52, "Text"],

Cell[CellGroupData[{
Cell[11169, 360, 212, 4, 70, "Input"],
Cell[11384, 366, 168, 3, 29, "Output"]
}, Open  ]],
Cell[11567, 372, 65, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[11657, 376, 118, 2, 30, "Input"],
Cell[11778, 380, 142, 2, 48, "Output"]
}, Open  ]],
Cell[11935, 385, 1552, 36, 299, "Text"],

Cell[CellGroupData[{
Cell[13512, 425, 231, 4, 90, "Input"],
Cell[13746, 431, 312, 5, 67, "Output"]
}, Open  ]],
Cell[14073, 439, 153, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[14251, 448, 54, 1, 30, "Input"],
Cell[14308, 451, 125, 2, 44, "Message"],
Cell[14436, 455, 330, 6, 67, "Output"]
}, Open  ]],
Cell[14781, 464, 245, 6, 52, "Text"],

Cell[CellGroupData[{
Cell[15051, 474, 73, 1, 30, "Input"],
Cell[15127, 477, 125, 2, 29, "Output"]
}, Open  ]],
Cell[15267, 482, 376, 6, 90, "Text"],
Cell[15646, 490, 669, 11, 147, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

