(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8702,        292]*)
(*NotebookOutlinePosition[      9486,        318]*)
(*  CellTagsIndexPosition[      9442,        314]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Math 384", "Subtitle"],

Cell[CellGroupData[{

Cell["A worked max/min example using the AGM inequality", "Subsubsection",
  CellDingbat->None],

Cell[TextData[{
  "The following problem is a mutation of exercise 15e from chapter 2 of the \
text. We want to minimize the objective function ",
  Cell[BoxData[
      \(x\^3 + 2\ y\^4 + 4\ z\)]],
  " subject to the constraint ",
  Cell[BoxData[
      \(x\ y\^2\ z\^4 = 39\)]],
  ". I intentionally changed the original problem so as to make it more work \
than I'd want to do by hand, just to illustrate that one can unleash software \
and get results without too much strain. I'll first show what to do in the \
AGM by magically giving the right convex combination of ",
  Cell[BoxData[
      \(\[Lambda]\_j\)]],
  "'s, then show how I found that combination.\n\nWe write"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(x\^3 + 2\ y\^4 + 4\ z = 
      29\ \((\(2\ x\^3\)\/\(29\ 2\) + \(3\ \((2\ y\^4)\)\)\/\(29\ 3\) + 
            \(24\ z\)\/\(29\ 6\))\)\)]]], "Text"],

Cell["\<\
(check this). Then by the AGM this is greater or equal to\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(29\ \((\((x\^3\/2)\)\^\(2/29\)\ \((\(2\ y\^4\)\/3)\)\^\(3/29\)\ \
\((z\/6)\)\^\(24/29\))\)\)]]], "Text"],

Cell["which is", "Text"],

Cell[TextData[Cell[BoxData[
    \(\(29\ x\^\(6/29\)\ y\^\(12/29\)\ z\^\(24/29\)\)\/\(2\^\(23/29\)\ \
3\^\(27/29\)\)\)]]], "Text"],

Cell["\<\
We do a bit of algebra to rewrite this as\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(\(29\ 39\^\(6/29\)\)\/\(2\^\(23/29\)\ 3\^\(27/29\)\)\)]]], "Text"],

Cell[TextData[{
  "using the fact that ",
  Cell[BoxData[
      \(x\ y\^2\ z\^4\)]],
  " is 39 and ",
  Cell[BoxData[
      \(x\^\(6/29\)\ y\^\(12/29\)\ z\^\(24/29\)\)]],
  " is ",
  Cell[BoxData[
      \(\((x\ y\^2\ z\^4)\)\^\(6/29\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "We also use the equality condition of AGM to deduce that\n",
  Cell[BoxData[
      \(x\^3 + 2\ y\^4 + 4\ z\)]],
  " achieves a minimum value of"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(\(29\ 39\^\(6/29\)\)\/\(2\^\(23/29\)\ 3\^\(27/29\)\)\)]]], "Text"],

Cell[TextData[{
  "precisely when\n",
  Cell[BoxData[
      \(x\^3\/2 == \(2\ y\^4\)\/3 == z\/6\)]]
}], "Text"],

Cell[TextData[{
  "If we also use the constraint equation then this is (almost) easy to solve \
for ",
  Cell[BoxData[
      \({x, y, z}\)]],
  ". Except ",
  Cell[BoxData[
      \(Solve\)]],
  " returns ALL solutions, including those with complex values, so we need to \
prune out the ones we do not want. These include all nonreal solutions as \
well as any real ones that have negative components. I show a bit of awkward \
code to handle all this."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(soln\  = \ 
        Solve[{\((\((x^3)\)/2)\) \[Equal] \((\((2*y^4)\)/3)\) \[Equal] z/6, \ 
            x*y^2*z^4 == 39}, \ {x, y, z}];\)\), "\n", 
    \(\(sols\  = \ {x, y, z}\  /. \ soln;\)\), "\n", 
    \(\(realsolpositions\  = \ 
      Flatten[Position[N[sols], \ {_Real, _Real, _Real}]]; \)\), "\n", 
    \(\(realsols\  = \ sols[[realsolpositions]]; \)\), "\n", 
    \(positivesols\  = \ 
      Select[realsols, \ Apply[And, \ Map[Positive, #]] &]\), "\n", 
    \(N[positivesols]\)}], "Input"],

Cell[BoxData[
    \({{26\^\(2/29\)\/3\^\(7/29\), 
        \(3\^\(2/29\)\ 13\^\(3/58\)\)\/2\^\(13/29\), 
        3\^\(8/29\)\ 26\^\(6/29\)}}\)], "Output"],

Cell[BoxData[
    \({{0.9603226438818279`, 0.9027722332058143`, 2.6568850369301993`}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "So now I know the minimum value for my objective function, and I also know \
the values of ",
  Cell[BoxData[
      \(x\)]],
  ", ",
  Cell[BoxData[
      \(y\)]],
  ", and ",
  Cell[BoxData[
      \(z\)]],
  " at which this minimum is achieved. The remaining issue is how to \
determine the multipliers used in the AGM above. This is  really not so hard, \
in fact it reduces to solving a system of linear equations. Notice that the \
exponent vector of my constraint is\n",
  Cell[BoxData[
      \({1, 2, 4}\)]],
  ". In other words, we raise ",
  Cell[BoxData[
      \({x, y, z}\)]],
  " to the ",
  Cell[BoxData[
      \({1, 2, 4}\)]],
  " powers respectively. The exponent vectors of the three summands in the \
objective function are\n",
  Cell[BoxData[
      \({3, 0, 0}\)]],
  ", ",
  Cell[BoxData[
      \({0, 4, 0}\)]],
  ", and ",
  Cell[BoxData[
      \({0, 0, 1}\)]],
  ". We need to find a convex combination ",
  Cell[BoxData[
      \(\[Lambda]\_1\)]],
  ", ",
  Cell[BoxData[
      \(\[Lambda]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(\[Lambda]\_3\)]],
  " (this means they are all nonnegative and sum to 1) and a number ",
  Cell[BoxData[
      \(\[Alpha]\)]],
  " such that\n",
  Cell[BoxData[
      \(\[Lambda]\_1\ {3, 0, 0} + \[Lambda]\_2\ {0, 4, 0} + 
        \[Lambda]\_3\ {0, 0, 1}\)]],
  " is equal to ",
  Cell[BoxData[
      \(\[Alpha]\ {1, 2, 4}\)]],
  ".\nIn fact we do not even need to know ",
  Cell[BoxData[
      \(\[Alpha]\)]],
  " so we just tell ",
  Cell[BoxData[
      \(Solve\)]],
  " to eliminate that one from the solution set."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[
      Append[Thread[
          \[Alpha]\ *{1, 2, 4}\  == \ 
            \[Lambda]\_1*{3, 0, 0} + \[Lambda]\_2*{0, 4, 0} + 
              \[Lambda]\_3*{0, 0, 1}], \ 
        \[Lambda]\_1 + \[Lambda]\_2 + \[Lambda]\_3 \[Equal] 1], \ 
      {\[Lambda]\_1, \[Lambda]\_2, \[Lambda]\_3}, \[Alpha]]\)], "Input"],

Cell[BoxData[
    \({{\[Lambda]\_1 \[Rule] 2\/29, \[Lambda]\_2 \[Rule] 3\/29, 
        \[Lambda]\_3 \[Rule] 24\/29}}\)], "Output"]
}, Open  ]],

Cell["\<\
Lo and behold, we get the values I showed above (of course we get the same \
result, how do you think I obtained them in the first place).\
\>", "Text"],

Cell[TextData[{
  "Here is an easier way to solve for ",
  Cell[BoxData[
      \({x, y, z}\)]],
  ". Take logarithms, apply ",
  Cell[BoxData[
      \(PowerExpand\)]],
  " to invoke those log laws from high school that only apply for positive \
bases, then solve the equations that result. This gives a much simpler system \
because it is linear in ",
  Cell[BoxData[
      \({Log[x], Log[y], Log[z]}\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqs\  = \ 
      {\((\((x^3)\)/2)\) \[Equal] \ \((\((2*y^4)\)/3)\), \ 
        \((\((x^3)\)/2)\) \[Equal] z/6, \ x*y^2*z^4 == 39}\)], "Input"],

Cell[BoxData[
    \({x\^3\/2 == \(2\ y\^4\)\/3, x\^3\/2 == z\/6, x\ y\^2\ z\^4 == 39}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(eqs2\  = \ Map[Log, eqs, {2}];\)\), "\[IndentingNewLine]", 
    \(\(eqs2\  = \ PowerExpand[eqs2];\)\), "\[IndentingNewLine]", 
    \(Solve[eqs2, \ {x, y, z}]\)}], "Input"],

Cell[BoxData[
    \({{x \[Rule] 26\^\(2/29\)\/3\^\(7/29\), 
        z \[Rule] 3\^\(8/29\)\ 26\^\(6/29\), 
        y \[Rule] \(3\^\(2/29\)\ 13\^\(3/58\)\)\/2\^\(13/29\)}}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{496, 415},
WindowMargins->{{69, Automatic}, {Automatic, 34}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{36, 36}, {50.375, 50.375}}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[1792, 55, 95, 1, 43, "Subsubsection"],
Cell[1890, 58, 687, 15, 166, "Text"],
Cell[2580, 75, 181, 3, 39, "Text"],
Cell[2764, 80, 81, 2, 33, "Text"],
Cell[2848, 84, 138, 2, 39, "Text"],
Cell[2989, 88, 24, 0, 33, "Text"],
Cell[3016, 90, 129, 2, 38, "Text"],
Cell[3148, 94, 65, 2, 33, "Text"],
Cell[3216, 98, 100, 1, 37, "Text"],
Cell[3319, 101, 257, 11, 33, "Text"],
Cell[3579, 114, 175, 5, 52, "Text"],
Cell[3757, 121, 100, 1, 37, "Text"],
Cell[3860, 124, 111, 4, 57, "Text"],
Cell[3974, 130, 464, 12, 90, "Text"],

Cell[CellGroupData[{
Cell[4463, 146, 520, 10, 190, "Input"],
Cell[4986, 158, 153, 3, 45, "Output"],
Cell[5142, 163, 102, 2, 29, "Output"]
}, Open  ]],
Cell[5259, 168, 1602, 59, 223, "Text"],

Cell[CellGroupData[{
Cell[6886, 231, 331, 7, 110, "Input"],
Cell[7220, 240, 130, 2, 42, "Output"]
}, Open  ]],
Cell[7365, 245, 162, 3, 52, "Text"],
Cell[7530, 250, 423, 13, 90, "Text"],

Cell[CellGroupData[{
Cell[7978, 267, 162, 3, 50, "Input"],
Cell[8143, 272, 102, 2, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8282, 279, 194, 3, 70, "Input"],
Cell[8479, 284, 183, 3, 45, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

