(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     68739,       1587]*)
(*NotebookOutlinePosition[     69952,       1625]*)
(*  CellTagsIndexPosition[     69908,       1621]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Math 384", "Subtitle"],

Cell[CellGroupData[{

Cell["So you think you may have a convex function?", "Subsection",
  CellDingbat->None],

Cell[TextData[{
  "We have seen in the course a few results that can help us to determine \
when a function on some domain is convex. Let me point out some more \
computational approaches that one might also try.\n\n(i) You might plot \
cross-section lines or planes in the domain, to see whether you get convex \
curves or surfaces in the graph.\n\n(ii) You might randomly select several \
points in the domain, and check whether the Hessian at those points is \
positive definite or semi-definite.\n\n(iii) You might try to check the \
Hessian symbolically.\n\nI will demonstrate these methods using an example \
from the homework. We will use\n",
  Cell[BoxData[
      \(f[x, y] = \((x + 2\ y + 1)\)\^8 - Log[x\ y]\^2\)]],
  " on the domain {",
  Cell[BoxData[
      \({x, y}\)]],
  " : ",
  Cell[BoxData[
      \(x > 1\)]],
  ",",
  Cell[BoxData[
      \(y > 1\)]],
  "} (a larger set than was used in the homework)."
}], "Text"],

Cell[BoxData[
    \(f[x_, y_]\  := \ \((x + 2*y + 1)\)^8\  - \ Log[\((x*y)\)^2]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot3D[Evaluate[f[x, y]], \ {x, 1, 1.5}, \ {y, 1, 1.5}, \ 
        Shading \[Rule] False];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.55112e-017 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.14598 .19958 -17.886 -9 ]
[.14598 .19958 .11404 0 ]
[.27013 .15073 -17.1354 -9 ]
[.27013 .15073 .86461 0 ]
[.40046 .09948 -16.3848 -9 ]
[.40046 .09948 1.61518 0 ]
[.53743 .04564 -15.6343 -9 ]
[.53743 .04564 2.36575 0 ]
[.68156 -0.01098 -14.8837 -9 ]
[.68156 -0.01098 3.11632 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.76745 .09703 0 -6.16187 ]
[.76745 .09703 18 2.83813 ]
[.82812 .18993 0 -6.07246 ]
[.82812 .18993 18 2.92754 ]
[.88369 .27502 0 -5.99218 ]
[.88369 .27502 18 3.00782 ]
[.93478 .35327 0 -5.9197 ]
[.93478 .35327 18 3.0803 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 18 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01606 .31556 -36 -2.78497 ]
[.01606 .31556 0 6.21503 ]
[.00775 .36768 -36 -2.82918 ]
[.00775 .36768 0 6.17082 ]
[-0.00085 .42158 -36 -2.87505 ]
[-0.00085 .42158 0 6.12495 ]
[-0.00975 .47733 -36 -2.92267 ]
[-0.00975 .47733 0 6.07733 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(1)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(1.1)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(1.2)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(1.3)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(1.4)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1.5)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06033 .24606 m
.06319 .24877 L
s
.08372 .23691 m
.08655 .23964 L
s
.10732 .22766 m
.11013 .23042 L
s
.13115 .21833 m
.13394 .22111 L
s
.17948 .19941 m
.18222 .20223 L
s
.20399 .18981 m
.2067 .19266 L
s
.22873 .18012 m
.23142 .183 L
s
.25371 .17034 m
.25638 .17324 L
s
.3044 .15049 m
.30701 .15344 L
s
.33011 .14043 m
.3327 .14339 L
s
.35608 .13026 m
.35864 .13325 L
s
.3823 .11999 m
.38483 .12301 L
s
.43553 .09915 m
.43799 .10222 L
s
.46254 .08857 m
.46497 .09167 L
s
.48982 .07789 m
.49222 .08101 L
s
.51738 .0671 m
.51975 .07024 L
s
.57333 .04519 m
.57563 .04838 L
s
.60174 .03407 m
.60401 .03728 L
s
.63044 .02283 m
.63267 .02607 L
s
.65944 .01147 m
.66163 .01474 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(1)] .70096 -0.00478 -1 .39157 Mshowa
.75514 .10158 m
.74899 .10385 L
s
[(1.1)] .76745 .09703 -1 .3693 Mshowa
.81573 .19425 m
.80953 .19642 L
s
[(1.2)] .82812 .18993 -1 .34944 Mshowa
.87123 .27915 m
.865 .28122 L
s
[(1.3)] .88369 .27502 -1 .3316 Mshowa
.92227 .35722 m
.91601 .35919 L
s
[(1.4)] .93478 .35327 -1 .31549 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(1.5)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70252 .02109 m
.69885 .02251 L
s
.71605 .04178 m
.71237 .04318 L
s
.72932 .06208 m
.72564 .06347 L
s
.74235 .08201 m
.73866 .08339 L
s
.7677 .12078 m
.764 .12213 L
s
.78003 .13965 m
.77633 .14098 L
s
.79214 .15817 m
.78843 .1595 L
s
.80404 .17637 m
.80033 .17768 L
s
.82721 .21182 m
.82349 .21311 L
s
.8385 .22909 m
.83478 .23037 L
s
.8496 .24606 m
.84587 .24733 L
s
.86051 .26275 m
.85677 .264 L
s
.88178 .29529 m
.87804 .29651 L
s
.89215 .31115 m
.88841 .31237 L
s
.90235 .32676 m
.89861 .32797 L
s
.91239 .34211 m
.90864 .34331 L
s
.93198 .37208 m
.92823 .37326 L
s
.94155 .38671 m
.93779 .38788 L
s
.95096 .40111 m
.9472 .40226 L
s
.96022 .41528 m
.95646 .41643 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02833 .31088 m
.03446 .30855 L
s
[(200000)] .01606 .31556 1 -0.38112 Mshowa
.02005 .36312 m
.0262 .36083 L
s
[(400000)] .00775 .36768 1 -0.37129 Mshowa
.01149 .41712 m
.01766 .41489 L
s
[(600000)] -0.00085 .42158 1 -0.3611 Mshowa
.00264 .47299 m
.00883 .47082 L
s
[(800000)] -0.00975 .47733 1 -0.35052 Mshowa
.125 Mabswid
.03436 .27282 m
.03803 .27139 L
s
.03236 .2854 m
.03604 .28399 L
s
.03035 .29809 m
.03403 .29668 L
s
.02628 .32378 m
.02996 .32239 L
s
.02422 .33678 m
.02791 .3354 L
s
.02214 .34989 m
.02583 .34852 L
s
.01794 .37645 m
.02163 .37509 L
s
.01581 .38989 m
.0195 .38854 L
s
.01366 .40345 m
.01736 .4021 L
s
.00931 .43091 m
.01301 .42958 L
s
.0071 .44481 m
.01081 .4435 L
s
.00488 .45884 m
.00859 .45753 L
s
.00038 .48726 m
.00409 .48596 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
1 g
.37972 .66501 .40193 .6951 .43952 .68995 .41752 .65901 Metetra
1 g
.41752 .65901 .43952 .68995 .47777 .68498 .45597 .65317 Metetra
1 g
.45597 .65317 .47777 .68498 .51669 .68023 .49509 .6475 Metetra
1 g
.49509 .6475 .51669 .68023 .55632 .67571 .53491 .64202 Metetra
1 g
.53491 .64202 .55632 .67571 .59667 .67143 .57545 .63674 Metetra
1 g
.57545 .63674 .59667 .67143 .6378 .66742 .61676 .63168 Metetra
1 g
.61676 .63168 .6378 .66742 .67973 .6637 .65886 .62685 Metetra
1 g
.65886 .62685 .67973 .6637 .72249 .66028 .70179 .62229 Metetra
1 g
.70179 .62229 .72249 .66028 .76614 .65721 .74558 .61801 Metetra
1 g
.74558 .61801 .76614 .65721 .81071 .65449 .79029 .61403 Metetra
1 g
.79029 .61403 .81071 .65449 .85625 .65216 .83595 .61038 Metetra
1 g
.83595 .61038 .85625 .65216 .90281 .65024 .88261 .60709 Metetra
1 g
.88261 .60709 .90281 .65024 .95045 .64878 .93033 .60417 Metetra
1 g
.93033 .60417 .95045 .64878 .99922 .6478 .97916 .60166 Metetra
1 g
.35702 .6353 .37972 .66501 .41752 .65901 .39504 .62849 Metetra
1 g
.39504 .62849 .41752 .65901 .45597 .65317 .43371 .62181 Metetra
1 g
.43371 .62181 .45597 .65317 .49509 .6475 .47304 .61526 Metetra
1 g
.47304 .61526 .49509 .6475 .53491 .64202 .51308 .60886 Metetra
1 g
.51308 .60886 .53491 .64202 .57545 .63674 .55383 .60263 Metetra
1 g
.55383 .60263 .57545 .63674 .61676 .63168 .59534 .59657 Metetra
1 g
.59534 .59657 .61676 .63168 .65886 .62685 .63764 .59071 Metetra
1 g
.63764 .59071 .65886 .62685 .70179 .62229 .68076 .58505 Metetra
1 g
.68076 .58505 .70179 .62229 .74558 .61801 .72474 .57963 Metetra
1 g
.72474 .57963 .74558 .61801 .79029 .61403 .76961 .57446 Metetra
1 g
.76961 .57446 .79029 .61403 .83595 .61038 .81543 .56956 Metetra
1 g
.81543 .56956 .83595 .61038 .88261 .60709 .86224 .56495 Metetra
1 g
.86224 .56495 .88261 .60709 .93033 .60417 .91008 .56066 Metetra
1 g
.91008 .56066 .93033 .60417 .97916 .60166 .95901 .55672 Metetra
1 g
.33378 .60586 .35702 .6353 .39504 .62849 .37204 .59828 Metetra
1 g
.37204 .59828 .39504 .62849 .43371 .62181 .41094 .59079 Metetra
1 g
.41094 .59079 .43371 .62181 .47304 .61526 .45051 .58341 Metetra
1 g
.45051 .58341 .47304 .61526 .51308 .60886 .49078 .57613 Metetra
1 g
.49078 .57613 .51308 .60886 .55383 .60263 .53177 .56898 Metetra
1 g
.53177 .56898 .55383 .60263 .59534 .59657 .57351 .56197 Metetra
1 g
.57351 .56197 .59534 .59657 .63764 .59071 .61603 .55511 Metetra
1 g
.61603 .55511 .63764 .59071 .68076 .58505 .65937 .54842 Metetra
1 g
.65937 .54842 .68076 .58505 .72474 .57963 .70356 .54192 Metetra
1 g
.70356 .54192 .72474 .57963 .76961 .57446 .74864 .53561 Metetra
1 g
.74864 .53561 .76961 .57446 .81543 .56956 .79465 .52952 Metetra
1 g
.79465 .52952 .81543 .56956 .86224 .56495 .84163 .52367 Metetra
1 g
.84163 .52367 .86224 .56495 .91008 .56066 .88964 .51808 Metetra
1 g
.88964 .51808 .91008 .56066 .95901 .55672 .93872 .51277 Metetra
1 g
.30998 .57661 .33378 .60586 .37204 .59828 .34849 .56829 Metetra
1 g
.34849 .56829 .37204 .59828 .41094 .59079 .38765 .56002 Metetra
1 g
.38765 .56002 .41094 .59079 .45051 .58341 .42747 .55183 Metetra
1 g
.42747 .55183 .45051 .58341 .49078 .57613 .46799 .54371 Metetra
1 g
.46799 .54371 .49078 .57613 .53177 .56898 .50923 .53569 Metetra
1 g
.50923 .53569 .53177 .56898 .57351 .56197 .55122 .52776 Metetra
1 g
.55122 .52776 .57351 .56197 .61603 .55511 .59399 .51995 Metetra
1 g
.59399 .51995 .61603 .55511 .65937 .54842 .63757 .51227 Metetra
1 g
.63757 .51227 .65937 .54842 .70356 .54192 .682 .50472 Metetra
1 g
.682 .50472 .70356 .54192 .74864 .53561 .72731 .49733 Metetra
1 g
.72731 .49733 .74864 .53561 .79465 .52952 .77355 .49011 Metetra
1 g
.77355 .49011 .79465 .52952 .84163 .52367 .82075 .48307 Metetra
1 g
.82075 .48307 .84163 .52367 .88964 .51808 .86897 .47625 Metetra
1 g
.86897 .47625 .88964 .51808 .93872 .51277 .91824 .46964 Metetra
1 g
.28559 .54746 .30998 .57661 .34849 .56829 .32437 .53842 Metetra
1 g
.32437 .53842 .34849 .56829 .38765 .56002 .36379 .52941 Metetra
1 g
.36379 .52941 .38765 .56002 .42747 .55183 .40388 .52043 Metetra
1 g
.40388 .52043 .42747 .55183 .46799 .54371 .44467 .51151 Metetra
1 g
.44467 .51151 .46799 .54371 .50923 .53569 .48618 .50263 Metetra
1 g
.48618 .50263 .50923 .53569 .55122 .52776 .52844 .49383 Metetra
1 g
.52844 .49383 .55122 .52776 .59399 .51995 .57148 .4851 Metetra
1 g
.57148 .4851 .59399 .51995 .63757 .51227 .61533 .47646 Metetra
1 g
.61533 .47646 .63757 .51227 .682 .50472 .66002 .46792 Metetra
1 g
.66002 .46792 .682 .50472 .72731 .49733 .7056 .45949 Metetra
1 g
.7056 .45949 .72731 .49733 .77355 .49011 .75209 .45118 Metetra
1 g
.75209 .45118 .77355 .49011 .82075 .48307 .79955 .44301 Metetra
1 g
.79955 .44301 .82075 .48307 .86897 .47625 .848 .435 Metetra
1 g
.848 .435 .86897 .47625 .91824 .46964 .89751 .42715 Metetra
1 g
.26058 .51833 .28559 .54746 .32437 .53842 .29963 .50858 Metetra
1 g
.29963 .50858 .32437 .53842 .36379 .52941 .33933 .49885 Metetra
1 g
.33933 .49885 .36379 .52941 .40388 .52043 .3797 .48912 Metetra
1 g
.3797 .48912 .40388 .52043 .44467 .51151 .42078 .4794 Metetra
1 g
.42078 .4794 .44467 .51151 .48618 .50263 .46257 .46972 Metetra
1 g
.46257 .46972 .48618 .50263 .52844 .49383 .50513 .46006 Metetra
1 g
.50513 .46006 .52844 .49383 .57148 .4851 .54846 .45044 Metetra
1 g
.54846 .45044 .57148 .4851 .61533 .47646 .5926 .44088 Metetra
1 g
.5926 .44088 .61533 .47646 .66002 .46792 .63758 .43138 Metetra
1 g
.63758 .43138 .66002 .46792 .7056 .45949 .68345 .42194 Metetra
1 g
.68345 .42194 .7056 .45949 .75209 .45118 .73023 .41259 Metetra
1 g
.73023 .41259 .75209 .45118 .79955 .44301 .77797 .40333 Metetra
1 g
.77797 .40333 .79955 .44301 .848 .435 .82671 .39418 Metetra
1 g
.82671 .39418 .848 .435 .89751 .42715 .87649 .38515 Metetra
1 g
.2349 .48913 .26058 .51833 .29963 .50858 .27424 .4787 Metetra
1 g
.27424 .4787 .29963 .50858 .33933 .49885 .31423 .46826 Metetra
1 g
.31423 .46826 .33933 .49885 .3797 .48912 .3549 .45779 Metetra
1 g
.3549 .45779 .3797 .48912 .42078 .4794 .39628 .44731 Metetra
1 g
.39628 .44731 .42078 .4794 .46257 .46972 .43838 .43683 Metetra
1 g
.43838 .43683 .46257 .46972 .50513 .46006 .48124 .42635 Metetra
1 g
.48124 .42635 .50513 .46006 .54846 .45044 .52489 .41587 Metetra
1 g
.52489 .41587 .54846 .45044 .5926 .44088 .56934 .40542 Metetra
1 g
.56934 .40542 .5926 .44088 .63758 .43138 .61464 .39498 Metetra
1 g
.61464 .39498 .63758 .43138 .68345 .42194 .66083 .38458 Metetra
1 g
.66083 .38458 .68345 .42194 .73023 .41259 .70792 .37421 Metetra
1 g
.70792 .37421 .73023 .41259 .77797 .40333 .75598 .3639 Metetra
1 g
.75598 .3639 .77797 .40333 .82671 .39418 .80503 .35365 Metetra
1 g
.80503 .35365 .82671 .39418 .87649 .38515 .85512 .34347 Metetra
1 g
.20854 .45979 .2349 .48913 .27424 .4787 .24817 .4487 Metetra
1 g
.24817 .4487 .27424 .4787 .31423 .46826 .28847 .43756 Metetra
1 g
.28847 .43756 .31423 .46826 .3549 .45779 .32945 .42637 Metetra
1 g
.32945 .42637 .3549 .45779 .39628 .44731 .37114 .41515 Metetra
1 g
.37114 .41515 .39628 .44731 .43838 .43683 .41357 .40389 Metetra
1 g
.41357 .40389 .43838 .43683 .48124 .42635 .45675 .3926 Metetra
1 g
.45675 .3926 .48124 .42635 .52489 .41587 .50073 .38129 Metetra
1 g
.50073 .38129 .52489 .41587 .56934 .40542 .54552 .36995 Metetra
1 g
.54552 .36995 .56934 .40542 .61464 .39498 .59116 .35861 Metetra
1 g
.59116 .35861 .61464 .39498 .66083 .38458 .63768 .34726 Metetra
1 g
.63768 .34726 .66083 .38458 .70792 .37421 .68512 .33592 Metetra
1 g
.68512 .33592 .70792 .37421 .75598 .3639 .73352 .32458 Metetra
1 g
.73352 .32458 .75598 .3639 .80503 .35365 .78291 .31327 Metetra
1 g
.78291 .31327 .80503 .35365 .85512 .34347 .83335 .30198 Metetra
1 g
.18144 .43023 .20854 .45979 .24817 .4487 .22138 .41848 Metetra
1 g
.22138 .41848 .24817 .4487 .28847 .43756 .262 .40666 Metetra
1 g
.262 .40666 .28847 .43756 .32945 .42637 .3033 .39477 Metetra
1 g
.3033 .39477 .32945 .42637 .37114 .41515 .34533 .38281 Metetra
1 g
.34533 .38281 .37114 .41515 .41357 .40389 .38809 .37079 Metetra
1 g
.38809 .37079 .41357 .40389 .45675 .3926 .43162 .35871 Metetra
1 g
.43162 .35871 .45675 .3926 .50073 .38129 .47594 .34658 Metetra
1 g
.47594 .34658 .50073 .38129 .54552 .36995 .52109 .33439 Metetra
1 g
.52109 .33439 .54552 .36995 .59116 .35861 .56709 .32216 Metetra
1 g
.56709 .32216 .59116 .35861 .63768 .34726 .61397 .30989 Metetra
1 g
.61397 .30989 .63768 .34726 .68512 .33592 .66178 .29759 Metetra
1 g
.66178 .29759 .68512 .33592 .73352 .32458 .71055 .28526 Metetra
1 g
.71055 .28526 .73352 .32458 .78291 .31327 .76032 .2729 Metetra
1 g
.76032 .2729 .78291 .31327 .83335 .30198 .81113 .26053 Metetra
1 g
.15359 .40039 .18144 .43023 .22138 .41848 .19384 .38799 Metetra
1 g
.19384 .38799 .22138 .41848 .262 .40666 .23478 .37549 Metetra
1 g
.23478 .37549 .262 .40666 .3033 .39477 .27643 .36291 Metetra
1 g
.27643 .36291 .3033 .39477 .34533 .38281 .31879 .35022 Metetra
1 g
.31879 .35022 .34533 .38281 .38809 .37079 .3619 .33745 Metetra
1 g
.3619 .33745 .38809 .37079 .43162 .35871 .40579 .32459 Metetra
1 g
.40579 .32459 .43162 .35871 .47594 .34658 .45048 .31165 Metetra
1 g
.45048 .31165 .47594 .34658 .52109 .33439 .496 .29863 Metetra
1 g
.496 .29863 .52109 .33439 .56709 .32216 .54238 .28553 Metetra
1 g
.54238 .28553 .56709 .32216 .61397 .30989 .58966 .27235 Metetra
1 g
.58966 .27235 .61397 .30989 .66178 .29759 .63786 .25911 Metetra
1 g
.63786 .25911 .66178 .29759 .71055 .28526 .68703 .2458 Metetra
1 g
.68703 .2458 .71055 .28526 .76032 .2729 .7372 .23243 Metetra
1 g
.7372 .23243 .76032 .2729 .81113 .26053 .78842 .219 Metetra
1 g
.12493 .37018 .15359 .40039 .19384 .38799 .16551 .35714 Metetra
1 g
.16551 .35714 .19384 .38799 .23478 .37549 .20679 .34398 Metetra
1 g
.20679 .34398 .23478 .37549 .27643 .36291 .24878 .3307 Metetra
1 g
.24878 .3307 .27643 .36291 .31879 .35022 .2915 .3173 Metetra
1 g
.2915 .3173 .31879 .35022 .3619 .33745 .33498 .30378 Metetra
1 g
.33498 .30378 .3619 .33745 .40579 .32459 .37924 .29016 Metetra
1 g
.37924 .29016 .40579 .32459 .45048 .31165 .42431 .27641 Metetra
1 g
.42431 .27641 .45048 .31165 .496 .29863 .47022 .26256 Metetra
1 g
.47022 .26256 .496 .29863 .54238 .28553 .517 .2486 Metetra
1 g
.517 .2486 .54238 .28553 .58966 .27235 .56469 .23453 Metetra
1 g
.56469 .23453 .58966 .27235 .63786 .25911 .61331 .22036 Metetra
1 g
.61331 .22036 .63786 .25911 .68703 .2458 .6629 .20609 Metetra
1 g
.6629 .20609 .68703 .2458 .7372 .23243 .7135 .19171 Metetra
1 g
.7135 .19171 .7372 .23243 .78842 .219 .76516 .17724 Metetra
1 g
.09543 .33955 .12493 .37018 .16551 .35714 .13635 .32586 Metetra
1 g
.13635 .32586 .16551 .35714 .20679 .34398 .17797 .31204 Metetra
1 g
.17797 .31204 .20679 .34398 .24878 .3307 .22031 .29807 Metetra
1 g
.22031 .29807 .24878 .3307 .2915 .3173 .2634 .28395 Metetra
1 g
.2634 .28395 .2915 .3173 .33498 .30378 .30726 .2697 Metetra
1 g
.30726 .2697 .33498 .30378 .37924 .29016 .35191 .25531 Metetra
1 g
.35191 .25531 .37924 .29016 .42431 .27641 .39738 .24077 Metetra
1 g
.39738 .24077 .42431 .27641 .47022 .26256 .4437 .2261 Metetra
1 g
.4437 .2261 .47022 .26256 .517 .2486 .4909 .21128 Metetra
1 g
.4909 .21128 .517 .2486 .56469 .23453 .53902 .19633 Metetra
1 g
.53902 .19633 .56469 .23453 .61331 .22036 .58808 .18123 Metetra
1 g
.58808 .18123 .61331 .22036 .6629 .20609 .63812 .16601 Metetra
1 g
.63812 .16601 .6629 .20609 .7135 .19171 .68918 .15064 Metetra
1 g
.68918 .15064 .7135 .19171 .76516 .17724 .74131 .13514 Metetra
1 g
.06505 .30842 .09543 .33955 .13635 .32586 .10631 .29409 Metetra
1 g
.10631 .29409 .13635 .32586 .17797 .31204 .14829 .27959 Metetra
1 g
.14829 .27959 .17797 .31204 .22031 .29807 .191 .26493 Metetra
1 g
.191 .26493 .22031 .29807 .2634 .28395 .23446 .25011 Metetra
1 g
.23446 .25011 .2634 .28395 .30726 .2697 .27871 .23512 Metetra
1 g
.27871 .23512 .30726 .2697 .35191 .25531 .32376 .21996 Metetra
1 g
.32376 .21996 .35191 .25531 .39738 .24077 .36965 .20463 Metetra
1 g
.36965 .20463 .39738 .24077 .4437 .2261 .41639 .18913 Metetra
1 g
.41639 .18913 .4437 .2261 .4909 .21128 .46403 .17347 Metetra
1 g
.46403 .17347 .4909 .21128 .53902 .19633 .5126 .15763 Metetra
1 g
.5126 .15763 .53902 .19633 .58808 .18123 .56212 .14162 Metetra
1 g
.56212 .14162 .58808 .18123 .63812 .16601 .61264 .12544 Metetra
1 g
.61264 .12544 .63812 .16601 .68918 .15064 .66418 .1091 Metetra
1 g
.66418 .1091 .68918 .15064 .74131 .13514 .71681 .09257 Metetra
1 g
.03374 .27672 .06505 .30842 .10631 .29409 .07536 .26174 Metetra
1 g
.07536 .26174 .10631 .29409 .14829 .27959 .1177 .24657 Metetra
1 g
.1177 .24657 .14829 .27959 .191 .26493 .16078 .23122 Metetra
1 g
.16078 .23122 .191 .26493 .23446 .25011 .20463 .21568 Metetra
1 g
.20463 .21568 .23446 .25011 .27871 .23512 .24928 .19995 Metetra
1 g
.24928 .19995 .27871 .23512 .32376 .21996 .29475 .18402 Metetra
1 g
.29475 .18402 .32376 .21996 .36965 .20463 .34106 .1679 Metetra
1 g
.34106 .1679 .36965 .20463 .41639 .18913 .38825 .15158 Metetra
1 g
.38825 .15158 .41639 .18913 .46403 .17347 .43635 .13506 Metetra
1 g
.43635 .13506 .46403 .17347 .5126 .15763 .48538 .11834 Metetra
1 g
.48538 .11834 .5126 .15763 .56212 .14162 .53539 .10142 Metetra
1 g
.53539 .10142 .56212 .14162 .61264 .12544 .5864 .08429 Metetra
1 g
.5864 .08429 .61264 .12544 .66418 .1091 .63846 .06696 Metetra
1 g
.63846 .06696 .66418 .1091 .71681 .09257 .69161 .04941 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(1)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(1.1)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(1.2)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(1.3)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(1.4)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1.5)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06033 .24606 m
.06319 .24877 L
s
.08372 .23691 m
.08655 .23964 L
s
.10732 .22766 m
.11013 .23042 L
s
.13115 .21833 m
.13394 .22111 L
s
.17948 .19941 m
.18222 .20223 L
s
.20399 .18981 m
.2067 .19266 L
s
.22873 .18012 m
.23142 .183 L
s
.25371 .17034 m
.25638 .17324 L
s
.3044 .15049 m
.30701 .15344 L
s
.33011 .14043 m
.3327 .14339 L
s
.35608 .13026 m
.35864 .13325 L
s
.3823 .11999 m
.38483 .12301 L
s
.43553 .09915 m
.43799 .10222 L
s
.46254 .08857 m
.46497 .09167 L
s
.48982 .07789 m
.49222 .08101 L
s
.51738 .0671 m
.51975 .07024 L
s
.57333 .04519 m
.57563 .04838 L
s
.60174 .03407 m
.60401 .03728 L
s
.63044 .02283 m
.63267 .02607 L
s
.65944 .01147 m
.66163 .01474 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jA000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo002hOol5
0002Ool20004Ool2001IOol00;Yoo`03001oogoo00Moo`04001oogoo001HOol00;Yoo`03001oogoo
00Yoo`03001oogoo05Ioo`00^Woo00<007ooOol027oo0P00FGoo002jOol00`00Oomoo`08Ool00`00
Oomoo`1HOol00;Uoo`8000Yoo`<000=oo`D0051oo`00cGoo00<007ooOol0D7oo003=Ool00`00Oomo
o`1@Ool00<eoo`03001oogoo051oo`00cGoo00<007ooOol0D7oo003<Ool2001BOol00<Ioo`<005Mo
o`00aGoo0P0000=oo`000000EWoo002EOol50002Ool20005Ool3000KOol40003Ool2001FOol009Mo
o`03001oogoo00Yoo`03001oogoo01Uoo`8000Ioo`03001oo`0005Eoo`00Ugoo00<007ooOol01goo
1@005goo0`0027oo00@007ooOol005Aoo`00Ugoo00<007ooOol01goo00@007ooOol001Eoo`<000]o
o`04001oo`00001DOol009Moo`03001oogoo00Qoo`03001oo`0001=oo`<000eoo`05001oogooOol0
001COol009Ioo`8000]oo`80011oo`<0011oo`03001oogoo009oo`03001oogoo051oo`00/goo0P00
4goo00<007ooOol00Woo00<007ooOol0D7oo002`Ool3000EOol00`00Oomoo`03Ool00`00Oomoo`1?
Ool00:eoo`<001Uoo`04001oogooOol3001@Ool00:]oo`<001Uoo`<000Eoo`03001oogoo04ioo`00
ZGoo0P006Goo0`000Woo00<007ooOol017oo00<007ooOol0CGoo002VOol3000HOol30005Ool00`00
Oomoo`04Ool00`00Oomoo`1=Ool00:Aoo`800003Ool007oo01Eoo`<000Qoo`8000Ioo`03001oogoo
04aoo`00M7oo1@000Woo0P0017oo0P0077oo00<007oo00000P005goo0`002goo0P001Goo00<007oo
0000CGoo001fOol00`00Oomoo`07Ool01000Oomoo`006Woo0`0067oo0P000Woo00<007ooOol02Goo
00<007oo00001Woo00<007ooOol0Bgoo001fOol00`00Oomoo`09Ool00`00Oomoo`0GOol2000HOol3
0004Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007ooOol0BWoo001fOol00`00Oomoo`0:Ool0
0`00Oomoo`0COol3000HOol20008Ool00`00Oomoo`08Ool01000Oomoo`001goo00<007ooOol017oo
1@000Woo0P000goo1@00=7oo001fOol00`00Oomoo`07Ool01000Oomoo`004goo0`0067oo0P002Woo
00<007ooOol027oo00D007ooOomoo`0000Eoo`8000Qoo`03001oogoo00Uoo`03001oogoo03Aoo`00
MGoo0P002Woo0P004Goo0`0067oo0`003Goo00<007ooOol01goo00D007ooOomoo`0000Moo`03001o
ogoo00Eoo`03001oogoo00Uoo`03001oogoo03Aoo`00TWoo0P0067oo0`000Woo00<007ooOol037oo
00<007ooOol01Woo00@007ooOomoo`8000Moo`03001oogoo00Aoo`03001oogoo00Uoo`03001oogoo
03Aoo`00Sgoo0`005goo0`001Goo00<007ooOol037oo00<007ooOol01Woo10000Woo00<007ooOol0
17oo00<007ooOol017oo00<007ooOol02Goo00<007ooOol0=7oo002<Ool3000GOol30009Ool00`00
Oomoo`0<Ool00`00Oomoo`03Ool30005Ool00`00Oomoo`05Ool00`00Oomoo`02Ool2000:Ool2000f
Ool008Yoo`@001Eoo`<000eoo`03001oogoo00]oo`03001oogoo00<0009oo`03001oogoo00Aoo`03
001oogoo00=oo`<004Moo`00QWoo10005Woo0`000Woo00<007ooOol02goo00<007ooOol02goo0`00
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0AGoo0025Ool3000EOol30005Ool00`00
Oomoo`0<Ool00`00Oomoo`07Ool30002Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool00`00Oomoo`14Ool005Eoo`D0009oo`8000=oo`@001eoo`<0009oo`03001oogoo011oo`<000Uo
o`03001oogoo00aoo`03001oogoo00=oo`<000Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001o
ogoo00Eoo`03001oogoo04=oo`00Egoo00<007ooOol01goo00<007ooOol077oo0P0057oo10003Goo
00<007ooOol02goo00<007ooOol00`002Goo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol0
17oo0P00AGoo001GOol00`00Oomoo`08Ool00`00Oomoo`0HOol4000AOol40003Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool3000<Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00
Oomoo`12Ool005Moo`03001oogoo00Uoo`03001oogoo01=oo`04001oo`00000AOol40007Ool00`00
Oomoo`0<Ool00`00Oomoo`07Ool30002Ool00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`11Ool005Moo`03001oogoo00Moo`04001oogoo000COol3000@
Ool3000<Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool30005Ool00`00Oomoo`0<Ool01@00Oomoogoo
000027oo0P001goo00<007ooOol0@Goo001FOol2000:Ool2000BOol2000@Ool30002Ool00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`030009Ool00`00Oomoo`0;Ool01@00Oomoogoo00001Goo
0`000Woo00<007ooOol01Goo00<007ooOol0@7oo001cOol3000@Ool20006Ool00`00Oomoo`0:Ool0
0`00Oomoo`0;Ool3000<Ool00`00Oomoo`0<Ool01000Oomoo`000Woo0`001Goo00<007ooOol017oo
0`00@Goo001aOol2000@Ool30008Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool30002Ool00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`030009Ool00`00Oomoo`05Ool00`00Oomoo`0oOol006eo
o`@000moo`<000aoo`03001oogoo00]oo`03001oogoo00=oo`<000Eoo`03001oogoo00aoo`03001o
ogoo00Yoo`@000]oo`03001oogoo00Ioo`03001oogoo03ioo`00Jgoo10003Woo0`000Woo00<007oo
Ool02goo00<007ooOol02Woo00<007ooOol00`002Goo00<007ooOol02goo00<007ooOol01goo0`00
00Aoo`00Ool000aoo`03001oogoo00Ioo`03001oogoo03eoo`00Igoo00@007oo0000011oo`8000Io
o`03001oogoo00]oo`03001oogoo00Uoo`<000eoo`03001oogoo00]oo`03001oogoo00=oo`<000Eo
o`8000eoo`03001oogoo00Aoo`8003moo`00IWoo0`003goo0`0027oo00<007ooOol02goo00<007oo
Ool01Goo10000Woo00<007ooOol02goo00<007ooOol02goo00<007ooOol00`0027oo0P003Goo00<0
07ooOol01Woo00<007ooOol0?7oo000gOol50002Ool20003Ool5000LOol20002Ool00`00Oomoo`0:
Ool3000<Ool00`00Oomoo`0;Ool00`00Oomoo`040006Ool00`00Oomoo`0<Ool00`00Oomoo`0:Ool3
000<Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool00`00Oomoo`0lOol003Uoo`03001oogoo00Uoo`03
001oogoo01Uoo`<000ioo`<0009oo`03001oogoo00]oo`03001oogoo00Yoo`<000]oo`03001oogoo
00aoo`03001oogoo00Eoo`@0009oo`03001oogoo00Yoo`03001oogoo00aoo`03001oogoo00Ioo`03
001oogoo00Aoo`D0009oo`8000=oo`@002Moo`00>Goo00<007ooOol02Goo00<007ooOol05goo0P00
3goo0P001Woo00<007ooOol02goo00<007ooOol01Woo0`000Woo00<007ooOol02Woo00<007ooOol0
2goo00@007ooOomoo`@000Ioo`03001oogoo00Yoo`8000eoo`8000Moo`8000Moo`03001oogoo00Mo
o`03001oogoo02Qoo`00>Goo00<007ooOol02Goo00<007ooOol057oo0`003Woo0`0027oo00<007oo
Ool02goo00<007ooOol017oo0P001Goo00<007ooOol02Woo00<007ooOol02goo10002goo00<007oo
Ool02Goo0P002Woo0`000Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol027oo00<007oo
Ool09goo000iOol00`00Oomoo`09Ool00`00Oomoo`0BOol3000=Ool3000<Ool00`00Oomoo`0;Ool0
0`00Oomoo`030008Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool30002Ool00`00Oomoo`0;Ool00`00
Oomoo`08Ool00`00Ool00005Ool40005Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`09
Ool00`00Oomoo`0VOol003Qoo`8000Yoo`80011oo`@000eoo`<0009oo`03001oogoo00]oo`03001o
ogoo00Yoo`<000aoo`03001oogoo00Yoo`03001oogoo00=oo`<000Eoo`03001oogoo00]oo`03001o
ogoo00Qoo`03001oo`00009oo`<000Yoo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Mo
o`04001oogoo000WOol005Aoo`<000ioo`8000Ioo`03001oogoo00]oo`03001oogoo00Ioo`<0009o
o`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00<000Uoo`03001oogoo00]oo`03001oogoo
00Moo`03001oo`00008000eoo`03001oogoo00Ioo`03001oogoo009oo`8000Yoo`8002Qoo`00DWoo
0P003Woo0`002Goo00<007ooOol02Woo00<007ooOol017oo0P001Goo00<007ooOol02goo00<007oo
Ool02Goo0`003Goo00<007ooOol02goo00<007ooOol017oo10000Woo00<007ooOol037oo00<007oo
Ool017oo00<007oo0000>Goo001?Ool3000=Ool3000<Ool00`00Oomoo`0;Ool00`00Oomoo`030008
Ool00`00Oomoo`0;Ool00`00Oomoo`04Ool40002Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00
Oomoo`040002Ool01@00Oomoogoo00003Woo00<007ooOol01goo00<007ooOol0=Woo001=Ool2000<
Ool40002Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool3000<Ool00`00Oomoo`0:Ool00`00Oomoo`04
0006Ool00`00Oomoo`0<Ool00`00Oomoo`0:Ool30007Ool01@00Oomoogoo00003Woo00<007ooOol0
1Woo00<007ooOol0=Woo001:Ool3000;Ool30007Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool40002
Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool3000;Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool40002
Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`0e
Ool002Moo`D001aoo`800003Ool007oo00Qoo`<000]oo`03001oogoo00]oo`03001oogoo00@000Io
o`03001oogoo00]oo`03001oogoo00Ioo`<0009oo`03001oogoo00Yoo`03001oogoo00]oo`04001o
ogooOol40006Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool0
0`00Ool0000fOol002Uoo`03001oogoo01Uoo`<000]oo`80009oo`03001oogoo00Uoo`03001oogoo
00]oo`<000]oo`03001oogoo00]oo`03001oogoo00=oo`8000Eoo`03001oogoo00Yoo`03001oogoo
00]oo`@000]oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00Yoo`8000Uoo`03001oogoo
03Aoo`00:Goo00<007ooOol05goo0`002Woo0`001Goo00<007ooOol02Goo00<007ooOol01goo0`00
0Woo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol00`0027oo00<007ooOol02Woo00<007oo
Ool01goo0`000Woo00<007ooOol02Woo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Goo
10000Woo00<007ooOol01goo00<007ooOol0<goo000YOol00`00Oomoo`0COol4000;Ool20009Ool0
0`00Oomoo`09Ool00`00Oomoo`04Ool20005Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool3000<Ool0
0`00Oomoo`0:Ool00`00Oomoo`03Ool30005Ool00`00Oomoo`0;Ool00`00Oomoo`03Ool00`00Oomo
o`04Ool01000Oomoogoo10001Woo00<007ooOol027oo00<007ooOol0<Woo000YOol00`00Oomoo`0B
Ool3000:Ool3000;Ool00`00Oomoo`0:Ool00`00Oomoo`030008Ool00`00Oomoo`0:Ool00`00Oomo
o`05Ool40002Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`030009Ool00`00Oomoo`0:
Ool00`00Oomoo`03Ool00`00Oomoo`04Ool4000;Ool00`00Oomoo`06Ool2000dOol002Qoo`8000mo
o`03001oo`00008000Yoo`<0009oo`03001oogoo00Yoo`03001oogoo00Uoo`<000aoo`03001oogoo
00Yoo`03001oogoo00@000Ioo`03001oogoo00]oo`03001oogoo00Uoo`<000aoo`03001oogoo00]o
o`03001oogoo009oo`03001oogoo00@00003Ool007oo00aoo`03001oogoo00Qoo`03001oogoo035o
o`00>7oo0`002goo0P001Woo00<007ooOol02Woo00<007ooOol01Goo0`000Woo00<007ooOol02Woo
00<007ooOol02Woo0`002goo00<007ooOol02goo00<007ooOol017oo10000Woo00<007ooOol02goo
00<007ooOol02Woo00@007ooOomoo`@000Ioo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo
031oo`00=Woo0P002goo0`002Goo00<007ooOol02Woo00<007ooOol010001Woo00<007ooOol02Woo
00<007ooOol01Woo0`000Woo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol010001Woo00<0
07ooOol037oo00<007ooOol02Goo1P0027oo00<007ooOol02goo00<007ooOol027oo00<007ooOol0
<7oo000cOol3000:Ool3000<Ool00`00Oomoo`0:Ool3000;Ool00`00Oomoo`0:Ool00`00Oomoo`03
Ool20005Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool3000;Ool00`00Oomoo`0;Ool00`00Oomoo`06
Ool3000017oo000000000Woo00<007ooOol01Woo00<007ooOol02goo00<007ooOol01goo0P00<Goo
000aOol2000:Ool30002Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool20002Ool00`00Oomoo`09Ool0
0`00Oomoo`0:Ool00`00Oomoo`030008Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool40002Ool00`00
Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`03Ool200001Woo00000000Ool000=oo`03001oogoo
00Ioo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo02ioo`00;goo0P002Goo0`001Woo00<0
07ooOol02goo00<007ooOol00goo0`001Goo00<007ooOol02Goo00<007ooOol02Goo0`0037oo00<0
07ooOol02Woo00<007ooOol010001Woo00<007ooOol02Woo00<007ooOol02goo00<007ooOol00`00
00=oo`0000001Goo00D007ooOomoo`0000Qoo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo
00Aoo`D0009oo`8000Aoo`8001]oo`00;Woo0`001Woo0`002Woo0P0037oo00<007ooOol00P002Goo
00<007ooOol02Goo00<007ooOol01Goo0`000Woo00<007ooOol02Woo00<007ooOol02Woo0`002goo
00<007ooOol02Woo00<007ooOol02Woo0`0000Aoo`00000000Moo`03001oogoo009oo`03001oogoo
00Eoo`03001oogoo00Yoo`8000]oo`03001oogoo00Eoo`03001oogoo00Moo`04001oogoo000JOol0
02Moo`8000Ioo`03001oo`0000=oo`80009oo`03001oogoo00Uoo`8000]oo`<000]oo`03001oogoo
00Yoo`03001oogoo00@000Ioo`03001oogoo00Yoo`03001oogoo00Ioo`<0009oo`03001oogoo00Yo
o`03001oogoo00Yoo`03001oogoo00Eoo`@00004Ool00000000;Ool00`00Oomoo`02Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool40002Ool00`00Oomoo`07Ool00`00Ool00006Ool00`00Oomoo`09Ool0
0`00Oomoo`0IOol002Ioo`04001oogoo0005Ool00`00Oomoo`030005Ool00`00Oomoo`0:Ool00`00
Oomoo`05Ool30002Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool3000;Ool00`00Oomoo`0:Ool00`00
Oomoo`03Ool20005Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool01000Oomoogoo10000Woo0`0000=o
o`00Ool037oo00D007ooOomoo`0000Moo`04001oogooOol40006Ool00`00Oomoo`09Ool00`00Oomo
o`04Ool00`00Oomoo`0:Ool00`00Oomoo`0HOol002Ioo`04001oogoo0004Ool01000Ool000002Goo
00<007ooOol02Woo00<007ooOol010001Woo00<007ooOol02Woo00<007ooOol01Goo0`000Woo00<0
07ooOol02Goo00<007ooOol02Woo00<007ooOol00`0027oo00<007ooOol02Woo00<007ooOol02Goo
10000goo0`001Goo00<007ooOol02Woo00<007ooOol00Woo00<007ooOol017oo10002goo00<007oo
Ool02Goo00<007ooOol00goo00<007ooOol01goo00@007ooOol001Yoo`009Woo00@007ooOol000Ao
o`8000]oo`03001oogoo00Yoo`<000]oo`03001oogoo00Yoo`03001oogoo00@000Eoo`03001oogoo
00Yoo`03001oogoo00Uoo`<000aoo`03001oogoo00Yoo`03001oogoo00Aoo`@0009oo`03001oo`00
008000Qoo`03001oogoo00]oo`03001oogoo009oo`03001oo`0000<0009oo`03001oogoo00Yoo`03
001oogoo00Uoo`03001oogoo009oo`8000Yoo`8001]oo`009Woo00@007ooOol000Aoo`8000aoo`03
001oogoo00Moo`80009oo`03001oogoo00Uoo`03001oogoo00Yoo`<000Yoo`03001oogoo00Yoo`03
001oogoo00Eoo`<0009oo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00@000Eoo`<000ao
o`03001oogoo00Yoo`03001oogoo00@000Ioo`03001oogoo00]oo`03001oogoo00Moo`03001oo`00
02aoo`009goo0P0017oo0P0000=oo`00Ool02goo00<007ooOol00goo0`001Goo00<007ooOol02Goo
00<007ooOol01goo0P000Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol010001Woo00<0
07ooOol02Woo00<007ooOol02Goo0`001goo0P000Woo00<007ooOol02Woo00<007ooOol02Woo0`00
0goo00<007ooOol01Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0:Goo000^Ool01000
Oomoo`0037oo00<007ooOol00P002Goo00<007ooOol02Goo00<007ooOol00goo0`0017oo00<007oo
Ool02Woo00<007ooOol02Goo0`002goo00<007ooOol02Woo00<007ooOol017oo10000Woo00<007oo
Ool00Woo0`001Goo00<007ooOol02Woo00<007ooOol01Goo10000Woo00<007ooOol00Woo00<007oo
Ool01Goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol0:Goo000^Ool01@00Oomoogoo0000
2goo0`002goo00<007ooOol02Woo00<007ooOol00P0027oo00<007ooOol02Goo00<007ooOol01Goo
10000Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol010001Woo00<007oo00000P0027oo
00<007ooOol02Woo00@007ooOomoo`@000Ioo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo
00]oo`03001oogoo00Qoo`8002Yoo`00;Goo00<007ooOol00goo00<007ooOol01Goo0`000Woo00<0
07ooOol02Woo00<007ooOol02Goo0`002goo00<007ooOol02Goo00<007ooOol010001Woo00<007oo
Ool02Woo00<007ooOol02Goo0`002Goo0`0037oo00<007ooOol02Goo10002goo00<007ooOol00Woo
00<007ooOol01Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol09goo000]Ool00`00Oomo
o`04Ool00`00Oomoo`040006Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool30002Ool00`00Oomoo`0:
Ool00`00Oomoo`08Ool3000;Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool30002Ool00`00Oomoo`04
Ool30003Ool00`00Oomoo`0:Ool00`00Oomoo`04Ool40002Ool00`00Oomoo`0:Ool00`00Oomoo`03
Ool00`00Oomoo`05Ool00`00Oomoo`08Ool3000;Ool00`00Oomoo`0WOol002eoo`8000Ioo`8000]o
o`03001oogoo00Yoo`03001oogoo00@000Ioo`03001oogoo00Uoo`03001oogoo00Eoo`<0009oo`03
001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00@000Eoo`04001oogooOol30007Ool00`00Oomo
o`09Ool00`00Oomoo`040006Ool00`00Oomoo`0;Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00
Oomoo`02Ool60003Ool00`00Oomoo`09Ool00`00Oomoo`0VOol002aoo`8000Qoo`03001oogoo00Yo
o`03001oogoo00Uoo`<000]oo`03001oogoo00Uoo`03001oogoo00@000Ioo`03001oogoo00Yoo`03
001oogoo00Uoo`<000Yoo`<000Yoo`03001oogoo00Qoo`@000]oo`03001oogoo00Yoo`03001oogoo
00Aoo`03001oogoo00=oo`D000Uoo`03001oogoo00Uoo`8002Moo`001goo10000goo0P0017oo0P00
17oo0P0017oo0P0017oo0P001Goo00<007ooOol01goo00<007ooOol02Woo00<007ooOol01Goo0`00
0Woo00<007ooOol02Goo00<007ooOol02Goo0`002goo00<007ooOol02Goo00<007ooOol01Goo1000
0Woo00<007ooOol01Woo100037oo00@007ooOomoo`H000=oo`03001oogoo00Yoo`03001oogoo00Yo
o`03001oogoo00=oo`03001oo`0000<00003Ool007oo00aoo`03001oogoo00Uoo`03001oogoo02Eo
o`001goo00<007ooOol00goo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@0
07ooOol0009oo`04001oogoo0004Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool00`00Oomoo`040005
Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool30002Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00
Oomoo`040006Ool00`00Oomoo`03Ool30004Ool00`00Oomoo`09Ool40009Ool00`00Oomoo`0:Ool0
0`00Oomoo`0:Ool01000Oomoogoo10001Woo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol0
97oo0008Ool00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool0
1000Oomoo`000Woo00@007ooOol000=oo`03001oogoo00Yoo`03001oogoo00Uoo`<000Yoo`03001o
ogoo00Yoo`03001oogoo00@000Ioo`03001oogoo00Uoo`03001oogoo00Uoo`<000]oo`03001oo`00
008000Moo`03001oogoo00Eoo`@0009oo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uo
o`@000Aoo`03001oogoo00=oo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo02=oo`002Goo
00D007ooOomoo`00009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
ogoo0002Ool01@00Oomoogoo00003Goo00<007ooOol01Goo0`000Woo00<007ooOol02Goo00<007oo
Ool02Goo0`002goo00<007ooOol02Goo00<007ooOol01Goo0`000Woo00<007ooOol027oo0`002goo
00<007ooOol010001Woo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol017oo10000Woo00<0
07ooOol017oo00<007ooOol00goo00<007ooOol02Woo00<007ooOol02Goo0P009Goo0007Ool01000
Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009o
o`04001oogoo0003Ool00`00Oomoo`0<Ool00`00Oomoo`040006Ool00`00Oomoo`09Ool00`00Oomo
o`06Ool20002Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`040005Ool00`00Oomoo`05
Ool30003Ool00`00Oomoo`08Ool3000;Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`04
0006Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomo
o`0ROol000Qoo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`8000=oo`8000moo`8000]oo`03
001oogoo00Qoo`03001oogoo00=oo`<000Eoo`03001oogoo00Uoo`03001oogoo00Uoo`<000Yoo`04
001oogooOol30006Ool00`00Oomoo`05Ool30002Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00
Oomoo`08Ool4000;Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`0;
Ool00`00Oomoo`03Ool50002Ool20005Ool3000=Ool002aoo`03001oogoo00ioo`03001oogoo00Uo
o`03001oogoo00Uoo`03001oogoo008000Uoo`03001oogoo00Uoo`03001oogoo00Eoo`<0009oo`03
001oogoo00Uoo`<000Yoo`03001oogoo00@000Eoo`03001oogoo00Yoo`03001oogoo00Yoo`04001o
ogooOol60003Ool00`00Oomoo`09Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool2
000;Ool20007Ool00`00Oomoo`0:Ool00`00Oomoo`0<Ool002aoo`03001oogoo00moo`03001oogoo
00Uoo`03001oogoo00Qoo`<000]oo`03001oogoo00Yoo`03001oogoo00@000Eoo`03001oogoo00Mo
o`@000]oo`<000Yoo`03001oogoo00Yoo`03001oogoo00Uoo`@000Uoo`03001oogoo00Yoo`03001o
ogoo00Aoo`03001oogoo00=oo`03001oogoo00Eoo`@0009oo`03001oogoo00Yoo`03001oogoo00Ao
o`03001oogoo00Moo`D000eoo`00:goo0P004Woo00<007ooOol02Goo00<007ooOol017oo0`000Woo
00<007ooOol02Woo00<007ooOol02Goo0`002Woo00<007ooOol00goo0`000goo00<007ooOol01Goo
10000Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol017oo10000Woo00<007ooOol02Goo
00<007ooOol02Goo00<007ooOol01Goo00<007ooOol00Woo00@007ooOomoo`@000Ioo`03001oogoo
00]oo`03001oogoo00=oo`03001oogoo00Moo`04001oogoo000>Ool002]oo`03001oogoo015oo`03
001oogoo00Yoo`03001oogoo00<000Ioo`03001oogoo00Yoo`03001oogoo00Eoo`<0009oo`03001o
ogoo00Uoo`03001oo`00008000Moo`03001oogoo00@000Ioo`03001oogoo00Uoo`03001oogoo00Yo
o`03001oogoo00@000Ioo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo
00D000]oo`03001oogoo00Yoo`03001oogoo00=oo`03001oogoo00Qoo`03001oo`0000ioo`00:goo
0P004goo00<007ooOol02Goo0`002Woo00<007ooOol02Woo00<007ooOol010001Goo00<007ooOol0
27oo0`002Woo0`002goo00<007ooOol02Goo00<007ooOol02Goo0`002goo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol00Woo1P000goo00<007ooOol02Woo00<007ooOol02Goo0`000goo0P00
2goo0P003Woo000[Ool00`00Oomoo`0COol00`00Oomoo`05Ool30002Ool00`00Oomoo`09Ool00`00
Oomoo`09Ool3000:Ool00`00Oomoo`04Ool30002Ool00`00Oomoo`05Ool30002Ool00`00Oomoo`09
Ool00`00Oomoo`0:Ool00`00Oomoo`04Ool40002Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00
Oomoo`09Ool50004Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0M
Ool000Moo`<0009oo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`8000Eoo`03001oogoo01Aoo`03001o
ogoo00@000Ioo`03001oogoo00Uoo`03001oogoo00Eoo`<0009oo`03001oogoo00Uoo`04001oogoo
Ool20006Ool00`00Oomoo`040005Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`040006
Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`04Ool40002Ool00`00Oomoo`05Ool00`00
Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0MOol000Qoo`04001oogoo0002
Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007oo
Ool00Woo00<007ooOol05Goo0P002goo00<007ooOol02Goo00<007ooOol010001Woo00<007ooOol0
2Goo0`0027oo0`002Woo00<007ooOol02Woo00<007ooOol01goo10002goo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol010001Woo00<007ooOol01Woo00D007ooOomoo`0000eoo`03001oogoo
00Yoo`8001ioo`001Goo1@0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool01000Oomoo`000Woo
00@007ooOol0009oo`04001oogoo0003Ool2000HOol00`00Oomoo`09Ool00`00Oomoo`09Ool3000;
Ool00`00Oomoo`05Ool40007Ool30002Ool00`00Oomoo`09Ool00`00Oomoo`09Ool01000Oomoogoo
1P000goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol01goo10002goo00<007ooOol01Woo
00D007ooOomoo`0000aoo`03001oogoo00aoo`03001oogoo01]oo`001Goo00@007ooOol0009oo`04
001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`00
0goo00<007ooOol067oo00<007ooOol02Goo00<007ooOol01Goo0`000Woo00<007ooOol02Goo00<0
07ooOol00Woo0`0017oo00<007ooOol010001Goo00<007ooOol02Woo00<007ooOol027oo10002Goo
00<007ooOol02Woo00<007ooOol02Goo00@007ooOomoo`H000=oo`03001oogoo00Yoo`03001oogoo
00Eoo`05001oogooOol0000=Ool00`00Oomoo`0;Ool00`00Oomoo`0KOol000Ioo`03001oo`00009o
o`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomo
o`000goo00<007ooOol06Goo00<007ooOol02Goo00<007ooOol010001Woo00<007ooOol02Goo1000
1Woo10002Woo00<007ooOol02Goo00<007ooOol01Goo0`000Woo00<007ooOol02Goo00<007ooOol0
2Goo00<007ooOol02Goo10002Goo00<007ooOol02Woo00<007ooOol01Woo00D007ooOomoo`0000Yo
o`<000ioo`03001oogoo01Yoo`001goo0P000goo0P0017oo0P0017oo0P0017oo0P0017oo0P0017oo
00<007ooOol06Woo00<007ooOol027oo0`002goo00<007ooOol01Woo10000goo1@000goo00<007oo
Ool02Goo00<007ooOol02Goo00<007ooOol010001Goo00<007ooOol02Woo00<007ooOol02Goo00<0
07ooOol017oo10000Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol01Woo00@007ooOol0
00Aoo`H000=oo`03001oogoo00Yoo`8001aoo`00:Woo00<007ooOol06goo00<007ooOol017oo0`00
0Woo00<007ooOol02Goo00<007ooOol017oo0P000goo10002Goo00<007ooOol02Goo00<007ooOol0
27oo0`002Woo00<007ooOol02Woo00<007ooOol027oo00<007ooOol010001Woo00<007ooOol02Goo
00<007ooOol02goo00<007ooOol01Woo1`002Goo00<007ooOol037oo00<007ooOol06Goo000ZOol0
0`00Oomoo`0LOol00`00Oomoo`030006Ool00`00Oomoo`09Ool00`00Oomoo`030002Ool30002Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`05Ool30002Ool00`00Oomoo`09Ool00`00Oomo
o`09Ool00`00Oomoo`07Ool4000;Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool01000Oomoogoo1P00
0Woo00<007ooOol02goo00<007ooOol037oo00<007ooOol067oo000YOol2000OOol2000:Ool00`00
Oomoo`08Ool300000goo000000020005Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`04
0005Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool01000Oomoogoo1@000goo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol02Woo10001Woo00@007ooOol000aoo`03001oogoo00]oo`8001Yoo`00
:Goo00<007ooOol07goo00<007ooOol02Goo00<007ooOol017oo0`0000Aoo`00000000Yoo`03001o
ogoo00Uoo`03001oogoo00Moo`@000Yoo`03001oogoo00Uoo`03001oogoo00Qoo`D000Qoo`03001o
ogoo00Yoo`03001oogoo00Uoo`03001oogoo00Eoo`@00003Ool007oo00Qoo`03001oo`0000eoo`03
001oogoo00aoo`03001oogoo01Moo`00:Goo00<007ooOol087oo00<007ooOol02Goo00<007ooOol0
0`0000Aoo`000000009oo`03001oogoo00Uoo`03001oogoo00Uoo`04001oogooOol50003Ool00`00
Oomoo`09Ool00`00Oomoo`09Ool01000Oomoogoo1P000goo00<007ooOol027oo00<007ooOol02Goo
00<007ooOol02Goo00@007ooOomoo`@000Ioo`03001oogoo00Ioo`04001oogoo000<Ool00`00Oomo
o`0=Ool00`00Oomoo`04Ool50002Ool20004Ool20003Ool002Uoo`80029oo`03001oogoo00Qoo`<0
0004Ool000000006Ool00`00Oomoo`09Ool00`00Oomoo`08Ool40009Ool00`00Oomoo`09Ool00`00
Oomoo`08Ool40009Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`07Ool5000:Ool00`00
Oomoo`07Ool00`00Ool0000=Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`07Ool01000
Oomoo`000Woo000XOol2000SOol00`00Oomoo`05Ool3000017oo000000002Woo00<007ooOol027oo
00<007ooOol01Goo0`000Woo00<007ooOol02Goo00<007ooOol027oo00<007ooOol01Goo0`000Woo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol027oo00@007ooOomoo`H000=oo`03001oogoo
00Yoo`03001oogoo00Moo`03001oo`0000aoo`03001oogoo00aoo`8000Moo`03001oogoo00Yoo`40
005oo`5oo`000goo0`0017oo0P0017oo0P0017oo0P0017oo0P0017oo0P001Goo00<007ooOol08Woo
00<007ooOol00Woo0P0000Aoo`000000009oo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo
00@000Eoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00@000Eoo`03001oogoo00Uoo`03
001oogoo00Uoo`03001oogoo00Moo`D000Uoo`03001oogoo00Yoo`03001oogoo00Qoo`8000eoo`03
001oogoo00eoo`03001oogoo00Aoo`03001oogoo00Qoo`8000=oo`000goo00@007ooOol0009oo`04
001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`00
0goo00<007ooOol097oo1`001Woo00<007ooOol027oo00<007ooOol027oo0`002Woo00<007ooOol0
2Goo00<007ooOol01goo10002Woo00<007ooOol02Goo00<007ooOol02Goo00@007ooOomoo`D000=o
o`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Moo`03001oo`0000Yoo`<000moo`03001o
ogoo00Aoo`03001oogoo00Qoo`03001oogoo009oo`000goo00@007ooOol0009oo`04001oogoo0002
Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000goo0P008goo
1@002goo00<007ooOol027oo00<007ooOol017oo0`000Woo00<007ooOol02Goo00<007ooOol02Goo
00@007ooOomoo`D000=oo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Moo`D000Qoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Qoo`8000Aoo`H000=oo`03001oogoo00]oo`<0
00Aoo`8000Yoo`<0009oo`000goo0`000goo00@007ooOol0009oo`04001oogoo0002Ool01000Oomo
o`000Woo00@007ooOol0009oo`04001oogoo0003Ool00`00Oomoo`0OOol30004Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`030006Ool00`00Oomoo`09Ool00`00Oomoo`08Ool40008Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool01000Oomoogoo1P000goo00<007ooOol027oo00<007ooOol0
2Goo00<007ooOol02Woo00<007ooOol01goo1P002Goo00<007ooOol027oo100000=oo`00Ool057oo
0004Ool00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000
Oomoo`000Woo00@007ooOol000=oo`03001oogoo01aoo`<000Qoo`03001oogoo00Uoo`03001oogoo
00Moo`@000Yoo`03001oogoo00Qoo`03001oogoo00Eoo`<0009oo`03001oogoo00Qoo`03001oogoo
00Uoo`03001oogoo00Qoo`@000Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`04
001oogooOol60002Ool00`00Oomoo`0;Ool00`00Oomoo`04Ool30005Ool00`00Oomoo`0COol000Ao
o`<000=oo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`8000=oo`8001]oo`<000aoo`03001oogoo00Uo
o`04001oogooOol50003Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`040005Ool00`00
Oomoo`08Ool00`00Oomoo`0:Ool00`00Oomoo`04Ool30002Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool50008Ool2000<Ool01000Oomoogoo0`0027oo00<007oo
Ool04goo000XOol00`00Oomoo`0GOol2000@Ool00`00Oomoo`08Ool40009Ool00`00Oomoo`08Ool0
0`00Oomoo`07Ool4000:Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`040005Ool00`00
Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool01000Oomoogoo1P000goo00<007ooOol027oo
00<007ooOol02goo0`0037oo00<007ooOol04Woo000WOol00`00Oomoo`0EOol3000COol00`00Oomo
o`04Ool30002Ool00`00Oomoo`09Ool00`00Oomoo`08Ool01000Oomoogoo1@000goo00<007ooOol0
27oo00<007ooOol02Goo00<007ooOol01goo10002Woo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol01goo1@002Goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol037oo00<007ooOol0
4Woo000WOol2000COol3000GOol00`00Oomoo`030006Ool00`00Oomoo`08Ool00`00Oomoo`08Ool4
0009Ool00`00Oomoo`08Ool00`00Oomoo`08Ool01000Oomoogoo1P000goo00<007ooOol027oo00<0
07ooOol02Goo00<007ooOol02Goo00@007ooOomoo`H000=oo`03001oogoo00Uoo`03001oogoo00Qo
o`03001oogoo00]oo`03001oogoo00]oo`03001oogoo019oo`009goo00<007ooOol03goo0`006goo
0P002Woo00<007ooOol027oo00<007ooOol017oo0`000Woo00<007ooOol02Goo00<007ooOol027oo
00<007ooOol01Woo1@002Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol01goo1@002Goo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol04Woo
000WOol00`00Oomoo`0<Ool3000OOol00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`030005
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool01000Oomoogoo1@000goo00<007ooOol02Goo00<007oo
Ool027oo00<007ooOol02Goo00@007ooOomoo`H000=oo`03001oogoo00Uoo`03001oogoo00Uoo`03
001oogoo00Qoo`8000aoo`03001oogoo00Yoo`03001oogoo019oo`009goo0P002Woo0`008goo00<0
07ooOol027oo00<007ooOol01goo10002Goo00<007ooOol02Goo00<007ooOol01Woo1@0027oo00<0
07ooOol02Goo00<007ooOol02Goo00<007ooOol01goo1@002Goo00<007ooOol02Goo00<007ooOol0
2Goo00<007ooOol02Goo0P002Goo0`0037oo00<007ooOol04Woo000VOol20008Ool3000WOol00`00
Oomoo`08Ool01000Oomoogoo1@000goo00<007ooOol027oo00<007ooOol02Goo00@007ooOomoo`@0
00=oo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`04001oogooOol60003Ool00`00
Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool20003Ool60002Ool00`00
Oomoo`0:Ool00`00Oomoo`0BOol0009oo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`8000Ao
o`03001oogoo00Eoo`8002Yoo`03001oogoo00Qoo`@000Uoo`03001oogoo00Qoo`03001oogoo00Qo
o`@000Moo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Ioo`D000Uoo`03001oogoo00Uo
o`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Aoo`T000Uoo`03001oogoo00Uoo`03001o
ogoo019oo`0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0
009oo`04001oogoo0002Ool01000Oomoo`000goo00<007ooOol00Woo0`00;Goo00<007ooOol017oo
0`000Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol01Goo0`000Woo00<007ooOol01goo
00<007ooOol02Goo00<007ooOol027oo00@007ooOomoo`D000=oo`03001oogoo00Uoo`03001oogoo
00Uoo`03001oogoo00Uoo`03001oogoo00Moo`P000Ioo`8000Yoo`03001oogoo00Yoo`03001oogoo
015oo`0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009o
o`04001oogoo0002Ool01000Oomoo`000goo1@00<Goo00<007ooOol00`001Woo00<007ooOol027oo
00<007ooOol027oo00<007ooOol010001Goo00<007ooOol027oo00<007ooOol027oo00<007ooOol0
1goo1@0027oo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00@007ooOomoo`H0009o
o`03001oogoo00Uoo`03001oo`0000Yoo`03001oogoo00Uoo`03001oogoo015oo`000Woo0P000goo
00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo
0003Ool2000eOol2000:Ool00`00Oomoo`08Ool00`00Oomoo`06Ool4000:Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool01000Oomoogoo1@000goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol0
2Goo00<007ooOol01goo1@002Goo00<007ooOol02Goo0P002Woo00<007ooOol02Goo00<007ooOol0
4Goo00001Goo001oogoo00000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo
00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`0dOol00`00Oomoo`08Ool00`00Oomoo`09
Ool01000Oomoogoo10000goo00<007ooOol027oo00<007ooOol027oo00<007ooOol01goo1@0027oo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol027oo00@007ooOomoo`H000=oo`03001oogoo
00Qoo`03001oogoo00Uoo`03001oo`0000Uoo`03001oogoo00Uoo`03001oogoo015oo`000Woo0P00
17oo0P0017oo0P0017oo0P0017oo0P0017oo0P001Woo0P00=Goo00<007ooOol027oo00<007ooOol0
1goo1@0027oo00<007ooOol027oo00<007ooOol027oo00@007ooOomoo`D000=oo`03001oogoo00Qo
o`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Aoo`P000Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oo`0000Uoo`03001oogoo00Qoo`03001oogoo015oo`00:Woo00<007ooOol0<goo
00<007ooOol027oo00@007ooOomoo`D000=oo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo
00Ioo`D000Qoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Moo`P000Ioo`03001oogoo
00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oo`0000Uoo`03001oogoo00Qoo`03001oogoo
015oo`00:goo00<007ooOol0<Woo00<007ooOol027oo100027oo00<007ooOol027oo00<007ooOol0
27oo00@007ooOomoo`D000=oo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Uoo`04001o
ogooOol50003Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Ool00009Ool00`00Oomoo`07Ool00`00Oomoo`0AOol002aoo`03001oogoo039oo`03001oogoo
00Aoo`<0009oo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Ioo`D000Qoo`03001oogoo
00Qoo`03001oogoo00Uoo`03001oogoo00Moo`D000Qoo`03001oogoo00Uoo`03001oogoo00Uoo`03
001oogoo00Qoo`03001oogoo00Uoo`04001oogoo0003Ool6000:Ool00`00Oomoo`0@Ool002eoo`80
03=oo`03001oogoo00<000Ioo`03001oogoo00Qoo`03001oogoo00Qoo`04001oogooOol40003Ool0
0`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool01000Oomoogoo1P000goo00<007ooOol0
27oo00<007ooOol027oo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol01goo20001Goo00<0
07ooOol027oo00<007ooOol047oo000_Ool00`00Oomoo`0aOol2000:Ool00`00Oomoo`08Ool00`00
Oomoo`06Ool50008Ool00`00Oomoo`07Ool00`00Oomoo`09Ool00`00Oomoo`06Ool50009Ool00`00
Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool01000Oomoogoo1P000Woo
00@007ooOol000Qoo`03001oogoo00Moo`03001oogoo011oo`00<7oo00<007ooOol0<Goo00<007oo
Ool027oo00<007ooOol027oo00@007ooOomoo`D000=oo`03001oogoo00Qoo`03001oogoo00Moo`03
001oogoo00Qoo`04001oogooOol50003Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`08
Ool00`00Oomoo`09Ool00`00Oomoo`04Ool80009Ool01000Oomoo`001goo00<007ooOol01goo00<0
07ooOol047oo000aOol00`00Oomoo`0aOol00`00Oomoo`08Ool00`00Oomoo`06Ool50008Ool00`00
Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`06Ool50008Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`09Ool00`00Oomoo`07Ool80005Ool00`00Oomoo`09Ool01@00Oomoogoo00001goo
00<007ooOol01Woo00<007ooOol047oo000bOol2000bOol00`00Oomoo`08Ool01000Oomoogoo1000
0goo00<007ooOol027oo00<007ooOol027oo00<007ooOol01goo00@007ooOomoo`D000=oo`03001o
ogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Qoo`04001oogooOol60002Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool01@00Oomoogoo00001Woo00<007ooOol01Woo00<007ooOol0
47oo000dOol00`00Oomoo`0`Ool00`00Oomoo`06Ool50008Ool00`00Oomoo`08Ool00`00Oomoo`08
Ool00`00Oomoo`03Ool70008Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00
Oomoo`04Ool80009Ool00`00Oomoo`08Ool00`00Oomoo`09Ool01@00Oomoogoo00001goo00<007oo
Ool01Goo00<007ooOol047oo000eOol00`00Oomoo`0`Ool01000Oomoogoo10000goo00<007ooOol0
27oo00<007ooOol027oo00<007ooOol01Woo1`001Goo00<007ooOol027oo00<007ooOol02Goo00<0
07ooOol027oo00<007ooOol01Woo20001Woo00<007ooOol027oo00<007ooOol02Goo00<007ooOol0
2Goo00D007ooOomoo`0000Ioo`03001oogoo00Ioo`03001oogoo00moo`00=Woo00<007ooOol0<7oo
0`0027oo00<007ooOol01goo00<007ooOol027oo00@007ooOomoo`D000=oo`03001oogoo00Moo`03
001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`04001oogooOol50003Ool00`00Oomoo`08
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool003Moo`03001oogoo031oo`03001oogoo00Qoo`03001o
ogoo00Moo`03001oogoo00Ioo`D000Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qo
o`03001oogoo00Aoo`L000Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001o
ogoo00Uoo`05001oogooOol00006Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool003Qoo`80035oo`03
001oogoo00Moo`03001oogoo00Qoo`04001oogooOol40003Ool00`00Oomoo`08Ool00`00Oomoo`07
Ool00`00Oomoo`08Ool00`00Oomoo`07Ool80005Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00
Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`0?Ool003Yoo`03001oogoo02moo`03001oogoo00Moo`03001oogoo00Io
o`D000Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`04001oogooOol50003Ool0
0`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool0
0`00Oomoo`04OolA0006Ool00`00Oomoo`0?Ool003]oo`03001oogoo02ioo`03001oogoo00Qoo`04
001oogooOol40003Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`04
Ool70008Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00
Oomoo`07Ool90005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0?
Ool003aoo`03001oogoo02ioo`03001oogoo00Ioo`D000Moo`03001oogoo00Qoo`03001oogoo00Qo
o`03001oogoo00Ioo`P000Eoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qoo`03001o
ogoo00Uoo`03001oogoo00Qoo`03001oogoo00H0009oo`03001oogoo00Yoo`03001oogoo009oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00moo`00?Goo0P00;goo00@007ooOomoo`@000=o
o`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`04001oogooOol50003Ool00`00Oomo
o`07Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomo
o`04Ool70009Ool00`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`0?Ool003moo`03001oogoo02eoo`<000Moo`03001oogoo00Moo`03001oogoo00Qoo`03
001oogoo00Ioo`D000Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo
00Moo`03001oogoo00Aoo`/000Eoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Aoo`03
001oogoo009oo`03001oogoo00=oo`03001oogoo00ioo`00@7oo00<007ooOol0;Goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol027oo00@007ooOomoo`@000=oo`03001oogoo00Qoo`03001o
ogoo00Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Aoo`X000Eoo`03001oogoo00Qo
o`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009o
o`03001oogoo00ioo`00@Goo00<007ooOol0;7oo00<007ooOol027oo00<007ooOol01goo00<007oo
Ool01Woo1@001goo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol01Woo
20001Goo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol02Goo00<007oo
Ool017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol03Woo0012Ool2000]Ool00`00Oomo
o`08Ool00`00Oomoo`06Ool01000Oomoogoo1@000goo00<007ooOol01goo00<007ooOol027oo00<0
07ooOol027oo00<007ooOol01goo00@007ooOomoo`D000=oo`03001oogoo00Moo`03001oogoo00Qo
o`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Aoo`03001oogoo009o
o`05001oogooOol0000@Ool004Aoo`03001oogoo02]oo`03001oogoo00Moo`03001oogoo00=oo`L0
00Qoo`03001oogoo00Moo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo00Aoo`L000Qoo`03
001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Uoo`03
001oogoo00Eoo`05001oogooOol00003Ool00`00Oomoo`0>Ool004Eoo`03001oogoo02]oo`03001o
ogoo00Eoo`L000Eoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Ao
o`X000Eoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001o
ogoo00Uoo`03001oogoo00Qoo`03001oogoo00Ioo`05001oogooOol00002Ool00`00Oomoo`0>Ool0
04Ioo`03001oogoo02Yoo`04001oogooOol40003Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool80005Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`08
Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`04
Ool60002Ool00`00Oomoo`0>Ool004Moo`8002]oo`<000Qoo`03001oogoo00Moo`03001oogoo00Qo
o`03001oogoo00Ioo`04001oogooOol50003Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomo
o`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`04OolG0002Ool0
1000Oomoo`000goo00<007ooOol03Goo0019Ool00`00Oomoo`0YOol00`00Oomoo`08Ool00`00Oomo
o`06Ool00`00Oomoo`08Ool00`00Oomoo`03Ool70008Ool00`00Oomoo`08Ool00`00Oomoo`07Ool0
0`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`03Ool;0005Ool00`00Oomo
o`08Ool00`00Oomoo`07Ool01000Oomoo`000Woo00<007ooOol03Goo001:Ool00`00Oomoo`0YOol0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool70005Ool00`00Oomoo`08Ool00`00Oomo
o`07Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`04Ool:0005Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`06Ool01000Oomoo`000Woo00<007ooOol03Goo
001;Ool00`00Oomoo`0YOol00`00Oomoo`07Ool00`00Oomoo`07Ool01000Oomoogoo10000goo00<0
07ooOol01Woo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol01goo00<0
07ooOol017oo2P001Goo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol0
1goo00H007ooOol007oo000?Ool004aoo`8002Uoo`03001oogoo00Qoo`03001oogoo00=oo`L000Mo
o`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Ao
o`X000Eoo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001o
ogoo00Moo`05001oo`00Ool0000?Ool004ioo`03001oogoo02Moo`03001oogoo00Ioo`L000Eoo`03
001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo00Aoo`X0
00Eoo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo
00Qoo`03001oogoo00Qoo`04001oo`00000?Ool004moo`03001oogoo02Moo`04001oogooOol40003
Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`04
Ool:0005Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00
Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`07Ool01000Ool000003goo001@Ool00`00Oomoo`0W
Ool30007Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool80005
Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`08
Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Ool0000?Ool0055oo`8002Qo
o`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`04001oogooOol5
0003Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomo
o`07Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`08Ool3000>Ool0
05=oo`03001oogoo02Eoo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo
00=oo`L000Qoo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03
001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Uoo`80
00ioo`00E7oo00<007ooOol09Goo00<007ooOol01goo00<007ooOol01goo00<007ooOol00goo2@00
1Goo00<007ooOol027oo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo00<007ooOol0
27oo00<007ooOol01goo00<007ooOol027oo00<007ooOol017oo7@003Woo001EOol00`00Oomoo`0U
Ool00`00Oomoo`07Ool00`00Oomoo`05Ool70005Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`04OolE000K
Ool2000>Ool005Ioo`03001oogoo02Eoo`03001oogoo00Ioo`04001oogooOol40003Ool00`00Oomo
o`06Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomo
o`07Ool00`00Oomoo`04Ool:000/Ool4000@Ool005Moo`8002Eoo`03001oogoo00=oo`L000Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Aoo`X0039oo`@001Aoo`00FGoo00<007ooOol08goo1@001Goo00<007ooOol01goo00<0
07ooOol01Woo00<007ooOol027oo00<007ooOol01goo00<007ooOol01goo00<007ooOol017oo2P00
>7oo100067oo001JOol00`00Oomoo`0SOol00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`08Ool00`00Oomoo`03OolD000nOol4000LOol005]oo`03001oogoo029oo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`L004ioo`@0021oo`00G7oo
0P008goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00@007ooOomoo`D0059oo`<0
02Aoo`00GWoo00<007ooOol08Goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol00goo1`00
Dgoo10009goo001OOol00`00Oomoo`0QOol00`00Oomoo`06Ool00`00Oomoo`03Ool9001FOol4000[
Ool0061oo`03001oogoo021oo`03001oogoo00=oo`T005]oo`@002moo`00HGoo0P008Goo1@00H7oo
1000<goo001SOol00`00Oomoo`0NOol00`00Oomoo`1NOol4000gOol006Aoo`03001oogoo01eoo`03
001oogoo05]oo`<003]oo`00IGoo00<007ooOol077oo00<007ooOol0Egoo1000?Woo001VOol2000L
Ool00`00Oomoo`1COol40012Ool006Qoo`03001oogoo01Uoo`03001oogoo04moo`@004Ioo`00JGoo
00<007ooOol067oo00<007ooOol0Bgoo1000BWoo001ZOol00`00Oomoo`0GOol00`00Oomoo`17Ool4
001>Ool006]oo`8001Moo`03001oogoo04Aoo`<0059oo`00KGoo00<007ooOol057oo00<007ooOol0
@7oo1000EGoo001^Ool00`00Oomoo`0COol00`00Oomoo`0lOol4001IOol006moo`03001oogoo019o
o`03001oogoo03Qoo`@005eoo`00L7oo0P004Woo00<007ooOol0=7oo1000HGoo001bOol00`00Oomo
o`0?Ool00`00Oomoo`0`Ool4001UOol007=oo`03001oogoo00ioo`03001oogoo02aoo`@006Uoo`00
M7oo00<007ooOol037oo00<007ooOol0:Woo0`00KGoo001eOol00`00Oomoo`0;Ool00`00Oomoo`0V
Ool4001`Ool007Ioo`8000]oo`03001oogoo029oo`@007Aoo`00N7oo00<007ooOol027oo00<007oo
Ool07Woo1000N7oo001iOol00`00Oomoo`07Ool00`00Oomoo`0JOol4001lOol007Yoo`03001oogoo
00Ioo`03001oogoo01Ioo`@0081oo`00Ngoo0P001Woo00<007ooOol04goo0`00Q7oo001mOol00`00
Oomoo`03Ool00`00Oomoo`0?Ool40027Ool007ioo`03001oogoo009oo`03001oogoo00]oo`@008]o
o`00Ogoo00D007ooOomoo`0000Uoo`@008moo`00P7oo0P0000=oo`00Ool017oo1000Tgoo0022Ool2
00000goo00000002002GOol008=oo`8009]oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo
003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{60.5625, 289.938}, {547.438, 361.625}} -> {-0.462719, 
  1.79106, 0.00405921, 0.00405921}}]
}, Open  ]],

Cell[TextData[{
  "It certainly looks like it may be convex. Let's try to check the Hessian \
at several points in the range ",
  Cell[BoxData[
      \(1 < x < 10\)]],
  " and ",
  Cell[BoxData[
      \(1 < y < 10\)]],
  ". After alot of debugging I decided to use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s high precision arithmetic because machine arithmetic seemed to mess up \
the smaller eigenvalue. No surprise, because they appear to be about a factor \
of ",
  Cell[BoxData[
      \($MachinePrecision\)]],
  " apart (un-comment the ",
  Cell[BoxData[
      \(Print\)]],
  " statement to see this)."
}], "Text"],

Cell[BoxData[{
    \(\(randTuple[n_]\  := \ 
        Table[1 + 100*Table[Random[Real, {0, 1}, 40], {n}]];\)\), 
  "\[IndentingNewLine]", 
    \(hessCheck[func_, vars_, n_]\  := \ 
      Module[{hess, evals, \ tuple, \ j = 0}, \[IndentingNewLine]hess\  = \ 
          Outer[D, Map[D[func, #] &, \ vars], vars]; \[IndentingNewLine]Do\ [
          \(++j\); \[IndentingNewLine]tuple\  = \ 
            randTuple[Length[vars]]; \[IndentingNewLine]evals\  = \ 
            Eigenvalues[
              hess\  /. \ Thread[vars \[Rule] tuple]]; \[IndentingNewLine] 
            (*\ \(Print[evals];\)\ *) \[IndentingNewLine]If\ [
            Apply[And, \ Map[Positive, evals]]\  =!= \ 
              True, \[IndentingNewLine]Break[]], \[IndentingNewLine]{n}]; \
\[IndentingNewLine]If\ [j < n, \ False, \ True]\[IndentingNewLine]]\)}], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hessCheck[f[x, y], {x, y}, 25]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "I have mentioned that we do not use the principal minors method to \
determine when a matrix is positive definite. While this is true for numeric \
examples, we may want to attempt it for symbolic examples, when computation \
of eigenvalues gives useless results. In this way we might hope to show that \
the Hessian is positive definite everywhere rather than just at a finite set \
of points.\n\nI should note that I am using a development version of ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " circa Spring '99, that has the ability to do simplification of \
inequalities subject to assumptions about where the variables live. So don't \
try this at home (until the new version is released)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(principalMinors[mat_]\  := \ 
      Table[Det[Take[mat, j, j]], \ {j, 1, Length[mat]}]\), 
  "\[IndentingNewLine]", 
    \(hessCheck2[func_, vars_, assume_]\  := \ 
      Module[\[IndentingNewLine]{hess, \ minrs}, \[IndentingNewLine]hess\  
          = \ Outer[D, Map[D[func, #] &, \ vars], 
            vars]; \[IndentingNewLine]minrs\  = \ 
          principalMinors[hess]; \[IndentingNewLine]Apply[And, 
          Map[FullSimplify[# > 0, \ assume] &, \ minrs]]\[IndentingNewLine]]
        \), "\[IndentingNewLine]", 
    \(hessCheck2[f[x, y], {x, y}, x > 1\  && \ y > 1]\)}], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["Pretty neat, you ask me.", "Text"],

Cell["\<\
So how might you know which of these methods to use for a given problem? \
Which, if any, are not generally useful? I guess it really depends on the \
problem at hand, and to some extent on personal preference. In general if the \
dimension of the domain is higher than three then I would not bother with any \
plots. These are suspect anyway whenever the scales in different directions \
are far apart, e.g. if near some point the eigenvalues of the Hessian differ \
by orders of magnitude (if there is a saddle it will most likely appear \
\"flat\"). By computing numerical eigenvalues one may at least control the \
precision, as I show above, and hence avoid this pitfall. For most problems \
this would be my method of choice.

The symbolic method of checking that principal minors are everywhere positive \
is, in my opinion, a novelty item. For most problems it will not be useful. \
There are several reasons for this. First, in high dimensions, one may lack \
the capability even to extract the minors in reasonable time or useful form; \
obtaining symbolic determinants can be strenuous. Moreover, the technology \
behind checking inequality inferences is computationally nontrivial. To \
handle polynomials it uses something known as \"cylindrical algebraic \
decomposition\" (whatever that means) and can be extremely time consuming for \
seemingly simple examples. For non-polynomial input there are ad-hoc rules \
used that may fail to determine whether the inequality holds everywhere in \
the domain, or may also cause the program to hang due to algorithmic \
complexity. That said, for some examples such as the one above, the symbolic \
method works quite well.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{496, 415},
WindowMargins->{{Automatic, 16}, {Automatic, 123}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"PrintingMargins"->{{36, 36}, {36, 54}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->True,
"PrintMultipleHorizontalPages"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[1792, 55, 87, 1, 47, "Subsection"],
Cell[1882, 58, 933, 22, 299, "Text"],
Cell[2818, 82, 92, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2935, 87, 127, 2, 50, "Input"],
Cell[3065, 91, 60836, 1381, 242, 19792, 870, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[63916, 1475, 636, 20, 109, "Text"],
Cell[64555, 1497, 835, 15, 290, "Input"],

Cell[CellGroupData[{
Cell[65415, 1516, 63, 1, 30, "Input"],
Cell[65481, 1519, 38, 1, 29, "Output"]
}, Open  ]],
Cell[65534, 1523, 742, 12, 185, "Text"],

Cell[CellGroupData[{
Cell[66301, 1539, 608, 11, 190, "Input"],
Cell[66912, 1552, 38, 1, 29, "Output"]
}, Open  ]],
Cell[66965, 1556, 40, 0, 33, "Text"],
Cell[67008, 1558, 1703, 25, 394, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

