(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6524,        230]*)
(*NotebookOutlinePosition[      7177,        253]*)
(*  CellTagsIndexPosition[      7133,        249]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Math 384", "Subtitle"],

Cell[CellGroupData[{

Cell["Review of hypersurface graphs and their tangent planes", "Subsection",
  CellDingbat->None],

Cell[TextData[{
  "A hypersurface graph in ",
  Cell[BoxData[
      \(\[DoubleStruckCapitalR]\^\(n + 1\)\)]],
  " is the graph of a function in n variables with continuous first partial \
derivatives. We may write this as ",
  Cell[BoxData[
      \(x\_\(n + 1\) = f[x\_1,  ... , x\_n]\)]],
  ". For example in ",
  Cell[BoxData[
      \(\[DoubleStruckCapitalR]\^2\)]],
  " we have graphs of the form ",
  Cell[BoxData[
      \(y = f[x]\)]],
  " which we call curves. In ",
  Cell[BoxData[
      \(\[DoubleStruckCapitalR]\^3\)]],
  " we have (ordinary) surfaces of the form ",
  Cell[BoxData[
      \(z = f[x, y]\)]],
  ". We want to describe tangent hyperplanes to such hypersurfaces. I will \
henceforth illustrate with ordinary surfaces in ",
  Cell[BoxData[
      \(\[DoubleStruckCapitalR]\^3\)]],
  "."
}], "Text"],

Cell["\<\
Draw in a reasonable surface and a tangent plane at some point in the space \
below.












\
\>", "Text"],

Cell[TextData[{
  "Lemma: Suppose we have a surface given by ",
  Cell[BoxData[
      \(x\_3 = f[x\_1, x\_2]\)]],
  ". Then we may obtain a normal (that is,a perpendicular vector) at the \
point ",
  Cell[BoxData[
      \({x\_1, x\_2, f[x\_1, x\_2]}\)]],
  " using ",
  Cell[BoxData[
      \({\[PartialD]\_\(x\_1\)f, \[PartialD]\_\(x\_2\)f, \(-1\)}\)]],
  " where the derivatives are evaluated at  ",
  Cell[BoxData[
      \(\(x\& \[Rule] \) = {x\_1, x\_2}\)]],
  " (in other words, ",
  Cell[BoxData[
      \(\(x\& \[Rule] \)\)]],
  " lies in the domain of ",
  Cell[BoxData[
      \(f\)]],
  ")."
}], "Text"],

Cell[TextData[{
  "Proof: Recall from multivariable calculus that if ",
  Cell[BoxData[
      \(F[x\_1, x\_2, x\_3]\)]],
  " has continuus first partial derivatives then the level set ",
  Cell[BoxData[
      \(F[x\_1, x\_2, x\_3] = constant\)]],
  " is a surface and ",
  Cell[BoxData[
      \(\[Del]F[x\_1, x\_2, x\_3]\)]],
  " is normal to this suface. We'll take ",
  Cell[BoxData[
      \(F[x\_1, x\_2, x\_3]\)]],
  " to be ",
  Cell[BoxData[
      \(x\_3\)]],
  Cell[BoxData[
      \(\(-f[x\_1, x\_2]\)\)]],
  "  (so we are looking at the level set ",
  Cell[BoxData[
      \(F = 0\)]],
  "). Then ",
  Cell[BoxData[
      \(\[Del]F[x\_1, x\_2, x\_3]\)]],
  "  = ",
  Cell[BoxData[
      \({\[PartialD]\_\(x\_1\)f, \[PartialD]\_\(x\_2\)f, \(-1\)}\)]],
  " by an obvious computation, and again, derivatives are evaluated at ",
  Cell[BoxData[
      \(\(x\& \[Rule] \)\)]],
  " as noted above."
}], "Text"],

Cell[TextData[{
  "Now suppose ",
  Cell[BoxData[
      \({y\_1, y\_2, y\_3}\)]],
  " is a point on the tangent plane. Any such point can clearly be written as \
a vector sum of ",
  Cell[BoxData[
      \({x\_1, x\_2, f[x\_1, x\_2]}\)]],
  " plus a vector that is perpendicular to the normal vector we just found. \
In other words, we have"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(\(({y\_1, y\_2, y\_3} - {x\_1, x\_2, f[x\_1, x\_2]})\) . 
        {\[PartialD]\_\(x\_1\)f, \[PartialD]\_\(x\_2\)f, \(-1\)} = 0\)]]]
, "Text"],

Cell["We rearrange this to obtain", "Text"],

Cell[TextData[Cell[BoxData[
    \(\((y\_1 - x\_1)\)\ \((\[PartialD]\_\(x\_1\)f)\)[x\_1, x\_2] + 
        \((y\_2 - x\_2)\)\ \((\[PartialD]\_\(x\_2\)f)\)[x\_1, x\_2] = 
      y\_3 - f[x\_1, x\_2]\)]]], "Text"],

Cell[TextData[{
  "Rearranging just a bit more and using dot products in the domain (which \
lies in ",
  Cell[BoxData[
      \(\[DoubleStruckCapitalR]\^2\)]],
  ") gives the formula we want: ",
  Cell[BoxData[
      \({\[PartialD]\_\(x\_1\)f, \[PartialD]\_\(x\_2\)f} . 
            {y\_1 - x\_1, y\_2 - x\_2} + f[x\_1, x\_2] = y\_3\)]],
  "\nSo the tangent plane consists of vectors of the form\n{ ",
  Cell[BoxData[
      \({y\_1, y\_2, y\_3}\)]],
  " : ",
  Cell[BoxData[
      \(y\_3 = 
        f[\(x\& \[Rule] \)] + 
          \[Del]f[\(x\& \[Rule] \)] . 
            \((\(y\& \[Rule] \) - \(x\& \[Rule] \))\)\)]],
  " where now ",
  Cell[BoxData[
      \(\(y\& \[Rule] \) = {y\_1, y\_2}\)]]
}], "Text"],

Cell["\<\
I realize this can be a bit confusing. We have vectors now in two spaces, the \
domain and also the space of dimension one more, where the graph lives.\
\>", "Text"],

Cell[TextData[{
  "Note that everything stated above holds for higher dimensional \
hypersurfaces. The proof is essentially as follows: wherever you see ",
  Cell[BoxData[
      \({x\_1, x\_2}\)]],
  " replace it with ",
  Cell[BoxData[
      \({x\_1,  ... , x\_n}\)]],
  " and similarly replace ",
  Cell[BoxData[
      \({y\_1, y\_2}\)]],
  " by ",
  Cell[BoxData[
      \({y\_1,  ... , y\_n}\)]],
  ". Everything will then work just fine."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{496, 413},
WindowMargins->{{8, Automatic}, {33, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[1792, 55, 97, 1, 47, "Subsection"],
Cell[1892, 58, 818, 25, 109, "Text"],
Cell[2713, 85, 121, 16, 280, "Text"],
Cell[2837, 103, 610, 21, 90, "Text"],
Cell[3450, 126, 910, 31, 128, "Text"],
Cell[4363, 159, 352, 10, 71, "Text"],
Cell[4718, 171, 175, 3, 31, "Text"],
Cell[4896, 176, 43, 0, 33, "Text"],
Cell[4942, 178, 208, 3, 31, "Text"],
Cell[5153, 183, 708, 21, 90, "Text"],
Cell[5864, 206, 175, 3, 52, "Text"],
Cell[6042, 211, 454, 15, 71, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

