(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11341,        326]*)
(*NotebookOutlinePosition[     12260,        356]*)
(*  CellTagsIndexPosition[     12216,        352]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Math 384", "Subtitle"],

Cell[TextData[{
  "How might we find eigenvalues of the matrix ",
  Cell[BoxData[
      RowBox[{"(", "\[NegativeThinSpace]", GridBox[{
            {\(-2\), "4"},
            {"4", "6"}
            }], "\[NegativeThinSpace]", ")"}]]],
  "? We might start with ",
  Cell[BoxData[
      RowBox[{"Det", "[", " ", 
        RowBox[{"(", "\[NegativeThinSpace]", GridBox[{
              {\(\(-2\) - \[Lambda]\), "4"},
              {"4", \(6 - \[Lambda]\)}
              }], "\[NegativeThinSpace]", ")"}], "]"}]]],
  " which is ",
  Cell[BoxData[
      \(\(-28\) - 4\ \[Lambda] + \[Lambda]\^2\)]],
  ". We could then find the roots using, say, the quadratic formula, or \
perhaps ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". ",
  Cell[BoxData[
      \(Roots[\(-28\) - 4\ \[Lambda] + \[Lambda]\^2 == 0, \[Lambda]]\)]],
  " gives\n",
  Cell[BoxData[
      \(\[Lambda] == 2\ \((1 - 2\ \@2)\) || 
        \[Lambda] == 2\ \((1 + 2\ \@2)\)\)]],
  ". Would you now want to find eigenvectors to go with this? (Not really). \
Even in two dimensions doing this sort of thing \"by hand\" can become \
cumbersome. What of three dimensions? Would you know how to find the roots if \
you did not have a sophisticated calculator or math program to do it for \
you?"
}], "Text"],

Cell[CellGroupData[{

Cell["Computational software to the rescue.", "Subsubsection",
  CellDingbat->None],

Cell[TextData[{
  "There are slicker ways in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to do some of the things I show below, but I want to keep this reasonably \
simple. If you are curious about any aspects of the programming that are \
unclear then stop by my office and I'll be happy to explain it in more \
detail. Needless to say, you are welcome to use any of these methods in the \
homework, though I think all problems assigned can be tackled with more \
traditional weaponry (pencil-and-paper)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(f[x_, y_, z_]\  := \ 
        x^2\  + \ 2*x*y*z\  - \ y^2\  + \ 5*x*y\  - \ 2*x*z\  - \ x\  + \ 
          3*y\  + \ z^2;\)\), "\[IndentingNewLine]", 
    \(\(vars\  = \ {x, y, z};\)\), "\[IndentingNewLine]", 
    \(derivs\  = \ Map[D[f[Sequence@@vars], #] &, \ vars]\)}], "Input"],

Cell[BoxData[
    \({\(-1\) + 2\ x + 5\ y - 2\ z + 2\ y\ z, 3 + 5\ x - 2\ y + 2\ x\ z, 
      \(-2\)\ x + 2\ x\ y + 2\ z}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sols\  = \ NSolve[derivs \[Equal] 0, \ vars]\)], "Input"],

Cell[BoxData[
    \({{y \[Rule] 
          \(-0.1115796824927009`\) - 0.26493178951811425`\ \[ImaginaryI], 
        z \[Rule] 
          \(-1.788512774140215`\) + 0.6698554967989987`\ \[ImaginaryI], 
        x \[Rule] 
          \(-1.3865912708666828`\) + 0.9330933444141363`\ \[ImaginaryI]}, 
      {y \[Rule] 
          \(-0.1115796824927009`\) + 0.26493178951811425`\ \[ImaginaryI], 
        z \[Rule] 
          \(-1.788512774140215`\) - 0.6698554967989987`\ \[ImaginaryI], 
        x \[Rule] 
          \(-1.3865912708666828`\) - 0.9330933444141363`\ \[ImaginaryI]}, 
      {y \[Rule] 
          \(2.701819320326189`\[InvisibleSpace]\) - 
            1.472459017689423`\ \[ImaginaryI], 
        z \[Rule] 
          \(-3.022150030547722`\) - 1.2062999257513805`\ \[ImaginaryI], 
        x \[Rule] 
          \(0.664832213805727`\[InvisibleSpace]\) + 
            1.2840599986849384`\ \[ImaginaryI]}, 
      {y \[Rule] 
          \(2.701819320326189`\[InvisibleSpace]\) + 
            1.472459017689423`\ \[ImaginaryI], 
        z \[Rule] 
          \(-3.022150030547722`\) + 1.2062999257513805`\ \[ImaginaryI], 
        x \[Rule] 
          \(0.664832213805727`\[InvisibleSpace]\) - 
            1.2840599986849384`\ \[ImaginaryI]}, 
      {y \[Rule] 0.31952072433302137`, z \[Rule] \(-0.37867439062411595`\), 
        x \[Rule] \(-0.5564818858780886`\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "We have only one critical point in real three dimensional space (all other \
solutions where the partials all vanish have complex values). Lesson 1: If \
ALL solutions were non-real, we'd have NO critical points, hence no local or \
global extrema. For an example of this situation, try setting the last \
monomial to ",
  Cell[BoxData[
      \(z\^3\)]],
  " instead of ",
  Cell[BoxData[
      \(z\^2\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Below I single out the critical point, which happens to be the last \
solution in the list above. For convenience I'll keep it in the form of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list of replacement rules."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(criticalpoint\  = \ \ Last[sols]\)], "Input"],

Cell[BoxData[
    \({y \[Rule] 0.31952072433302137`, z \[Rule] \(-0.37867439062411595`\), 
      x \[Rule] \(-0.5564818858780886`\)}\)], "Output"]
}, Open  ]],

Cell["Here is a fancy-pants way to get the Hessian matrix of func.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hess\  = \ Outer[D, derivs, vars]\)], "Input"],

Cell[BoxData[
    \({{2, 5 + 2\ z, \(-2\) + 2\ y}, {5 + 2\ z, \(-2\), 2\ x}, 
      {\(-2\) + 2\ y, 2\ x, 2}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "We'd like to know if ",
  Cell[BoxData[
      \(hess\)]],
  " is positive definite, negative definite, or indefinite when evaluated at \
the critical point. This will allow us to conclude something about the nature \
of that critical point."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hessatcp\  = \ hess\  /. \ criticalpoint\)], "Input"],

Cell[BoxData[
    \({{2, 4.242651218751768`, \(-1.3609585513339573`\)}, 
      {4.242651218751768`, \(-2\), \(-1.1129637717561771`\)}, 
      {\(-1.3609585513339573`\), \(-1.1129637717561771`\), 2}}\)], "Output"]
}, Open  ]],

Cell["\<\
To determine the definiteness or lack thereof, we look at the \
eigen-what-a-ma-call-em's.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Eigenvalues[hessatcp]\)], "Input"],

Cell[BoxData[
    \({5.5496813381718555`, \(-4.697415735940282`\), 1.1477343977684293`}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "We have an indefinite Hessian at the critical point, hence it is a saddle \
point. In one direction parallel to the eigenvector corresponding to that \
negative eigenvalue, the value of our function will increase. If you move \
from the critical point parallel to either of the eigenvectors that \
correspond to the two positive eigenvalues, the function will instead \
decrease. This may give you an appreciation for that eigen-stuff you learned \
about in math 315 (if you never covered this topic, consider this to be a \
crash introduction).\n\nBy the way, I just made up this problem. So it is in \
some sense \"random.\" Here are a few remarks that are equally random.\n(i) \
Random problems will never have semi-definite Hessians. The reason, \
mathematically, is roughly the same as the justification for the statement \
\"You cannot hit a bulls'eye exactly dead center with an infinitely thin \
dart.\" If you encounter a semi-definite Hessian (that is, some eigenvalue is \
zero), then either you have a very specialized problem with unusual \
structure, or you are looking at a textbook problem with little bearing on \
reality. Or both.\n(ii) I posed a problem for which I knew the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(NSolve\)]],
  " command could find all critical points. An easy way to fool it would be \
to start with a non-polynomial function, because ",
  Cell[BoxData[
      \(Solve\)]],
  " and ",
  Cell[BoxData[
      \(NSolve\)]],
  " are really only designed to handle algebraic functions (polynomials and \
roots thereof), and they will give at best incomplete solution sets for \
transcendental functions (things with exponentials, logs, trigs, etc.). For \
this sort of problem, you may have obtain whatever critical points you can \
with a numeric a root-finder. In our example this might be done as below."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newsols\  = \ 
      FindRoot[Evaluate[Thread[derivs \[Equal] 0]], \ 
        Evaluate[Apply[Sequence, Thread[{vars, 0}]]]]\)], "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.5564818855815126`\), y \[Rule] 0.3195207244158393`, 
      z \[Rule] \(-0.37867439027297733`\)}\)], "Output"]
}, Open  ]],

Cell["\<\
It looks familiar. In fact we already know, for this example, that this is \
the only critical point. In general one might need to call a root-finder \
repeatedly with different starting values. For many problems it is difficult \
to determine whether or not we have found all solutions. \
\>", "Text"],

Cell["\<\
I realize the above code is cryptic. It usually takes me a few tries to get \
it correct so don't fret if you try to do these and make some mistakes. Here \
is a more pedestrian way to do the same thing.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqns\  = \ Table[derivs[\([j]\)] \[Equal] 0, \ {j, Length[derivs]}]\)], 
  "Input"],

Cell[BoxData[
    \({\(-1\) + 2\ x + 5\ y - 2\ z + 2\ y\ z == 0, 
      3 + 5\ x - 2\ y + 2\ x\ z == 0, \(-2\)\ x + 2\ x\ y + 2\ z == 0}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(newsolstoo\  = \ FindRoot[eqns, \ {x, 0}, \ {y, 0}, \ {z, 0}]\)], 
  "Input"],

Cell[BoxData[
    \({x \[Rule] \(-0.5564818855815126`\), y \[Rule] 0.3195207244158393`, 
      z \[Rule] \(-0.37867439027297733`\)}\)], "Output"]
}, Open  ]],

Cell["\<\
By the way, you'll learn alot about root-finding in chapter three.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{496, 415},
WindowMargins->{{56, Automatic}, {-15, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{36, 36}, {50.375, 50.375}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False},
StyleDefinitions -> "Default.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 64, "Subtitle"],
Cell[1770, 53, 1269, 33, 163, "Text"],

Cell[CellGroupData[{
Cell[3064, 90, 83, 1, 43, "Subsubsection"],
Cell[3150, 93, 533, 10, 109, "Text"],

Cell[CellGroupData[{
Cell[3708, 107, 304, 5, 90, "Input"],
Cell[4015, 114, 135, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4187, 121, 77, 1, 30, "Input"],
Cell[4267, 124, 1374, 30, 143, "Output"]
}, Open  ]],
Cell[5656, 157, 443, 12, 90, "Text"],
Cell[6102, 171, 261, 6, 52, "Text"],

Cell[CellGroupData[{
Cell[6388, 181, 65, 1, 30, "Input"],
Cell[6456, 184, 146, 2, 29, "Output"]
}, Open  ]],
Cell[6617, 189, 76, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[6718, 193, 66, 1, 30, "Input"],
Cell[6787, 196, 123, 2, 29, "Output"]
}, Open  ]],
Cell[6925, 201, 272, 7, 71, "Text"],

Cell[CellGroupData[{
Cell[7222, 212, 73, 1, 30, "Input"],
Cell[7298, 215, 212, 3, 48, "Output"]
}, Open  ]],
Cell[7525, 221, 114, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[7664, 228, 54, 1, 30, "Input"],
Cell[7721, 231, 104, 2, 29, "Output"]
}, Open  ]],
Cell[7840, 236, 1916, 34, 413, "Text"],

Cell[CellGroupData[{
Cell[9781, 274, 156, 3, 50, "Input"],
Cell[9940, 279, 145, 2, 29, "Output"]
}, Open  ]],
Cell[10100, 284, 312, 5, 71, "Text"],
Cell[10415, 291, 227, 4, 71, "Text"],

Cell[CellGroupData[{
Cell[10667, 299, 103, 2, 30, "Input"],
Cell[10773, 303, 153, 3, 48, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10963, 311, 97, 2, 30, "Input"],
Cell[11063, 315, 145, 2, 29, "Output"]
}, Open  ]],
Cell[11223, 320, 90, 2, 33, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

