(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19624,        672]*)
(*NotebookOutlinePosition[     20406,        698]*)
(*  CellTagsIndexPosition[     20362,        694]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Math 384", "Subtitle"],

Cell[CellGroupData[{

Cell["The Cauchy-Schwarz inequality and several proofs thereof", 
  "Subsubsection",
  CellDingbat->None],

Cell[TextData[{
  "Given vectors ",
  StyleBox["v",
    FontWeight->"Bold"],
  " and ",
  StyleBox["w in ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(\[DoubleStruckCapitalR]\^n\)]],
  " the Cauchy-Schwarz inequality states that\n|",
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  " ",
  StyleBox["w| ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \( \[LessSlantEqual] \)]],
  " ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  "  . There are several proofs of this theorem. One is given in the book, \
where it is a simple corollary of the more general H",
  Cell[BoxData[
      \(\[ODoubleDot]\)]],
  "lder's inequality. Here are a few other standard proofs."
}], "Text"],

Cell[TextData[{
  "(1) Write ",
  StyleBox["w",
    FontWeight->"Bold"],
  " as a sum of a vector parallel to ",
  StyleBox["v",
    FontWeight->"Bold"],
  " and a vector orthogonal to ",
  StyleBox["v",
    FontWeight->"Bold"],
  ", that is,\n",
  StyleBox["w",
    FontWeight->"Bold"],
  " = ",
  Cell[BoxData[
      \(\[Alpha]\)]],
  StyleBox["v",
    FontWeight->"Bold"],
  " + ",
  Cell[BoxData[
      \(\[Beta]\)]],
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["v",
          FontWeight->"Bold"], "\[UpTee]"]]],
  ". Then |",
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  " ",
  StyleBox["w|",
    FontWeight->"Bold"],
  " = |",
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  " (",
  Cell[BoxData[
      \(\[Alpha]\)]],
  StyleBox["v",
    FontWeight->"Bold"],
  " + ",
  Cell[BoxData[
      \(\[Beta]\)]],
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["v",
          FontWeight->"Bold"], "\[UpTee]"]]],
  StyleBox[")| = |",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(\[Alpha]\)]],
  StyleBox["| ",
    FontWeight->"Bold"],
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox["v",
            FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"]]],
  " whereas\n",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  "  =",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  Cell[BoxData[
      SqrtBox[
        RowBox[{
          RowBox[{
          \(\[LeftBracketingBar]\[Alpha]\[RightBracketingBar]\^2\), " ", 
            SuperscriptBox[
              RowBox[{"\[LeftDoubleBracketingBar]", 
                StyleBox["v",
                  FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"]}]
            , "+", 
          RowBox[{
          \(\[LeftBracketingBar]\[Beta]\[RightBracketingBar]\^2\), " ", 
            SuperscriptBox[
              RowBox[{"\[LeftDoubleBracketingBar]", 
                SuperscriptBox[
                  StyleBox["v",
                    FontWeight->"Bold"], "\[UpTee]"], 
                "\[RightDoubleBracketingBar]"}], "2"]}]}]]]],
  Cell[BoxData[
      \( \[GreaterEqual] \)]],
  " ",
  StyleBox["|",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(\[Alpha]\)]],
  StyleBox["| ",
    FontWeight->"Bold"],
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox["v",
            FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"]]],
  " with equality holding if and only if ",
  Cell[BoxData[
      \(\[Beta]\)]],
  " is zero, that is, ",
  StyleBox["v",
    FontWeight->"Bold"],
  " is parallel to ",
  StyleBox["w",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[TextData[{
  "(2) For this proof we first assume ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  " = ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  " = 1. Then ",
  Cell[BoxData[
      RowBox[{
        RowBox[{"0", "\[LessEqual]", 
          SuperscriptBox[
            RowBox[{"\[LeftDoubleBracketingBar]", 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "-", 
                StyleBox["w",
                  FontWeight->"Bold"]}], "\[RightDoubleBracketingBar]"}], 
            "2"]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "-", 
                StyleBox["w",
                  FontWeight->"Bold"]}], ")"}], ".", 
            RowBox[{"(", 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "-", 
                StyleBox["w",
                  FontWeight->"Bold"]}], ")"}]}], "=", 
          RowBox[{
            SuperscriptBox[
              RowBox[{"\[LeftDoubleBracketingBar]", 
                StyleBox["v",
                  FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"], 
            "+", 
            SuperscriptBox[
              RowBox[{"\[LeftDoubleBracketingBar]", 
                StyleBox["w",
                  FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"], 
            "-", 
            RowBox[{"2", " ", 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], ".", 
                StyleBox["w",
                  FontWeight->"Bold"]}]}]}]}]}]]],
  " . Hence ",
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  " ",
  StyleBox["w ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \( \[LessEqual] \)]],
  " 1. Similarly ",
  Cell[BoxData[
      RowBox[{
        RowBox[{"0", "\[LessEqual]", 
          SuperscriptBox[
            RowBox[{"\[LeftDoubleBracketingBar]", 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "+", 
                StyleBox["w",
                  FontWeight->"Bold"]}], "\[RightDoubleBracketingBar]"}], 
            "2"]}], "=", 
        RowBox[{
          SuperscriptBox[
            RowBox[{"\[LeftDoubleBracketingBar]", 
              StyleBox["v",
                FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"], 
          "+", 
          SuperscriptBox[
            RowBox[{"\[LeftDoubleBracketingBar]", 
              StyleBox["w",
                FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"], 
          "+", 
          RowBox[{"2", " ", 
            RowBox[{
              StyleBox["v",
                FontWeight->"Bold"], ".", 
              StyleBox["w",
                FontWeight->"Bold"]}]}]}]}]]],
  " so we also obtain ",
  Cell[BoxData[
      RowBox[{
        RowBox[{"-", 
          RowBox[{
            StyleBox["v",
              FontWeight->"Bold"], ".", 
            StyleBox["w",
              FontWeight->"Bold"]}]}], "\[LessEqual]", "1"}]]],
  ". We conclude that ",
  Cell[BoxData[
      RowBox[{
        RowBox[{"\[LeftBracketingBar]", 
          RowBox[{
            StyleBox["v",
              FontWeight->"Bold"], " ", ".", " ", 
            StyleBox["w",
              FontWeight->"Bold"]}], "\[RightBracketingBar]"}], 
        "\[LessEqual]", 
        RowBox[{
          RowBox[{"\[LeftDoubleBracketingBar]", 
            StyleBox["v",
              FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], 
          RowBox[{"\[LeftDoubleBracketingBar]", 
            StyleBox["w",
              FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]}]}]]],
  " for this case. Next we suppose ",
  StyleBox["v",
    FontWeight->"Bold"],
  " or ",
  StyleBox["w",
    FontWeight->"Bold"],
  " is ",
  StyleBox["0. ",
    FontWeight->"Bold"],
  "Then both sides of the inequality are 0 so this case is fine. Finally we \
assume ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  " = ",
  Cell[BoxData[
      \(\[Alpha] > 0\)]],
  " and \[LeftDoubleBracketingBar]",
  StyleBox["w",
    FontWeight->"Bold"],
  "\[RightDoubleBracketingBar] = ",
  Cell[BoxData[
      \(\[Beta] > 0\)]],
  ". Then from the first case we have that\n|",
  Cell[BoxData[
      \(1\/\[Alpha]\)]],
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  Cell[BoxData[
      \(1\/\[Beta]\)]],
  " ",
  StyleBox["w|",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(\(\(\[LessEqual]\)\(1\)\)\)]],
  " (because ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        RowBox[{\(1\/\[Alpha]\), 
          StyleBox["v",
            FontWeight->"Bold"]}], "\[RightDoubleBracketingBar]"}]]],
  " = ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        RowBox[{\(1\/\[Beta]\), 
          StyleBox["w",
            FontWeight->"Bold"]}], "\[RightDoubleBracketingBar]"}]]],
  " = 1). So |",
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  " ",
  StyleBox["w| ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \( \[LessEqual] \)]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "\[Alpha] \[Beta] = ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  " for this case as well. The equality-if-and-only-if-parallel case is left \
as an exercise."
}], "Text"],

Cell[TextData[{
  "(3) This time we will use a Lagrange multiplier. This is actually a \
homework problem late in the book, but we figure that by the time you get to \
it your mice will have destroyed this and most other handouts that you used \
to line their cages.\n\nWe want to maximize |",
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  " ",
  StyleBox["w| ",
    FontWeight->"Bold"],
  " subject to the constraint that ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  " is constant. Equivalently we may square both sides, so now we will \
maximize ",
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"(", 
          RowBox[{
            StyleBox["v",
              FontWeight->"Bold"], " ", ".", " ", 
            StyleBox["w",
              FontWeight->"Bold"]}], ")"}], "2"]]],
  " with the constraint that ",
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"(", 
          RowBox[{
            RowBox[{"\[LeftDoubleBracketingBar]", 
              StyleBox["v",
                FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], 
            RowBox[{"\[LeftDoubleBracketingBar]", 
              StyleBox["w",
                FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]}], ")"}],
         "2"]]],
  " is constant (call it ",
  Cell[BoxData[
      \(\[Gamma]\)]],
  "). Write ",
  Cell[BoxData[
      RowBox[{
        StyleBox["v",
          FontWeight->"Bold"], "=", \({v\_1, v\_2,  ... , v\_n}\)}]]],
  " and\n",
  Cell[BoxData[
      RowBox[{
        StyleBox["w",
          FontWeight->"Bold"], "=", \({w\_1, w\_2,  ... , w\_n}\)}]]],
  ". For fixed ",
  StyleBox["v",
    FontWeight->"Bold"],
  " the objective function is\nf(",
  StyleBox["w",
    FontWeight->"Bold"],
  ") =",
  Cell[BoxData[
      \(\(\(\ \)\(\((\(v\_1\ w\_1 + \(v\_2\) 
                    w\_2\  + \  ... \)\  + \ \(v\_n\) w\_n)\)\^2\)\)\)]],
  " where\ng(",
  StyleBox["w",
    FontWeight->"Bold"],
  ") = ",
  Cell[BoxData[
      \(\((\(v\_1\%2 + v\_2\%2 +  ... \) + v\_n\%2)\)\)]],
  Cell[BoxData[
      \(\((\(w\_1\%2 + w\_2\%2 +  ... \) + w\_n\%2)\)\)]],
  " = ",
  Cell[BoxData[
      \(\[Gamma]\)]],
  ".\nThen ",
  Cell[BoxData[
      RowBox[{\(\[Del]f\), "=", 
        RowBox[{
        "2", " ", \((\(\(\(v\_1\ w\_1\)\(+\)\) ... \) + v\_n\ w\_n)\), " ", 
          StyleBox["v",
            FontWeight->"Bold"]}]}]]],
  " and the Lagrange multiplier condition says this must equal ",
  Cell[BoxData[
      \(\[Lambda]\)]],
  " ",
  Cell[BoxData[
      \(\[Del]\)]],
  "g for some scalar ",
  Cell[BoxData[
      \(\[Lambda]\)]],
  ". Now ",
  Cell[BoxData[
      RowBox[{\(\[Del]g\), "=", 
        RowBox[{\((\(v\_1\%2 + v\_2\%2 +  ... \) + v\_n\%2)\), " ", 
          StyleBox["w",
            FontWeight->"Bold"]}]}]]],
  ". Hence if ",
  Cell[BoxData[
      RowBox[{
        StyleBox["v",
          FontWeight->"Bold"], ",", " ", 
        RowBox[{
          StyleBox["w",
            FontWeight->"Bold"], "\[NotEqual]", 
          StyleBox["0",
            FontWeight->"Bold"]}]}]]],
  " then the Lagrange multiplier condition for an extremum shows that ",
  StyleBox["w",
    FontWeight->"Bold"],
  " is a scalar multiple of ",
  StyleBox["v",
    FontWeight->"Bold"],
  ". In this case it is easy to verify that |",
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  " ",
  StyleBox["w|",
    FontWeight->"Bold"],
  " is equal to ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  "."
}], "Text"],

Cell[TextData[{
  "Corollary (triangle inequality): Given vectors ",
  StyleBox["v",
    FontWeight->"Bold"],
  " and ",
  StyleBox["w in ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(\[DoubleStruckCapitalR]\^n\)]],
  " we have\n\[LeftDoubleBracketingBar]",
  StyleBox["v",
    FontWeight->"Bold"],
  " + ",
  StyleBox["w",
    FontWeight->"Bold"],
  "\[RightDoubleBracketingBar]",
  Cell[BoxData[
      \( \[LessSlantEqual] \)]],
  " ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  "+",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  ".\nProof: ",
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          RowBox[{
            StyleBox["v",
              FontWeight->"Bold"], " ", "+", " ", 
            StyleBox["w",
              FontWeight->"Bold"]}], "\[RightDoubleBracketingBar]"}], "2"]]],
  " = ",
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox["v",
            FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"]]],
  " + ",
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox["w",
            FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"]]],
  " + 2(",
  StyleBox["v",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \( . \)]],
  " ",
  StyleBox["w",
    FontWeight->"Bold"],
  ") \[LessSlantEqual] ",
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox["v",
            FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"]]],
  " + ",
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox["w",
            FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "2"]]],
  " + 2",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  " by the Cauchy-Schwarz inequality. This in turn is equal to ",
  Cell[BoxData[
      SuperscriptBox[
        RowBox[{"(", 
          RowBox[{
            RowBox[{"\[LeftDoubleBracketingBar]", 
              StyleBox["v",
                FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}], "+", 
            RowBox[{"\[LeftDoubleBracketingBar]", 
              StyleBox["w",
                FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]}], ")"}]
          , "2"]]],
  ". As both sides are nonnegative we can take square roots and preserve the \
inequality, so we obtain \[LeftDoubleBracketingBar]",
  StyleBox["v",
    FontWeight->"Bold"],
  " + ",
  StyleBox["w",
    FontWeight->"Bold"],
  "\[RightDoubleBracketingBar]",
  Cell[BoxData[
      \( \[LessSlantEqual] \)]],
  " ",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["v",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  "+",
  Cell[BoxData[
      RowBox[{"\[LeftDoubleBracketingBar]", 
        StyleBox["w",
          FontWeight->"Bold"], "\[RightDoubleBracketingBar]"}]]],
  ".\n\nThis too comes in a more general flavor, known as Minkowski's \
inequality. It is covered with H",
  Cell[BoxData[
      \(\[ODoubleDot]\)]],
  "lder's inequality at the end of chapter 2 in the book. Together they are \
cornerstones in the edifice of real and functional analysis (is that an \
awe-inspiring remark or what?)."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 640}, {0, 407}},
WindowSize->{496, 309},
WindowMargins->{{60, Automatic}, {Automatic, -20}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{36, 36}, {36, 43.1875}}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[1792, 55, 105, 2, 43, "Subsubsection"],
Cell[1900, 59, 972, 34, 90, "Text"],
Cell[2875, 95, 3073, 119, 90, "Text"],
Cell[5951, 216, 5926, 195, 170, "Text"],
Cell[11880, 413, 3989, 135, 280, "Text"],
Cell[15872, 550, 3724, 118, 223, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

